/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_samr.h"
#include "bin/default/librpc/gen_ndr/ndr_samr_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* samr - dcerpc server boilerplate generated by pidl */
static NTSTATUS samr__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SAMR_BIND
	return DCESRV_INTERFACE_SAMR_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void samr__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_SAMR_UNBIND
	DCESRV_INTERFACE_SAMR_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS samr__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_samr.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_samr.calls[opnum].struct_size, "struct %s", ndr_table_samr.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_samr.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS samr__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* samr_Connect */
		struct samr_Connect *r2 = (struct samr_Connect *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.connect_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.connect_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_Connect(p, r2);
		break;
	}
	case 1: { /* samr_Close */
		struct samr_Close *r2 = (struct samr_Close *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Close, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.handle = r2->in.handle;
		r2->out.result = _samr_Close(p, r2);
		break;
	}
	case 2: { /* samr_SetSecurity */
		struct samr_SetSecurity *r2 = (struct samr_SetSecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetSecurity, NDR_IN, r2);
		}
		r2->out.result = _samr_SetSecurity(p, r2);
		break;
	}
	case 3: { /* samr_QuerySecurity */
		struct samr_QuerySecurity *r2 = (struct samr_QuerySecurity *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QuerySecurity, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sdbuf = talloc_zero(r2, struct sec_desc_buf *);
		if (r2->out.sdbuf == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QuerySecurity(p, r2);
		break;
	}
	case 4: { /* samr_Shutdown */
		struct samr_Shutdown *r2 = (struct samr_Shutdown *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Shutdown, NDR_IN, r2);
		}
		r2->out.result = _samr_Shutdown(p, r2);
		break;
	}
	case 5: { /* samr_LookupDomain */
		struct samr_LookupDomain *r2 = (struct samr_LookupDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupDomain, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sid = talloc_zero(r2, struct dom_sid2 *);
		if (r2->out.sid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_LookupDomain(p, r2);
		break;
	}
	case 6: { /* samr_EnumDomains */
		struct samr_EnumDomains *r2 = (struct samr_EnumDomains *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomains, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.sam = talloc_zero(r2, struct samr_SamArray *);
		if (r2->out.sam == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.num_entries = talloc_zero(r2, uint32_t);
		if (r2->out.num_entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_EnumDomains(p, r2);
		break;
	}
	case 7: { /* samr_OpenDomain */
		struct samr_OpenDomain *r2 = (struct samr_OpenDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenDomain, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.domain_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.domain_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_OpenDomain(p, r2);
		break;
	}
	case 8: { /* samr_QueryDomainInfo */
		struct samr_QueryDomainInfo *r2 = (struct samr_QueryDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union samr_DomainInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryDomainInfo(p, r2);
		break;
	}
	case 9: { /* samr_SetDomainInfo */
		struct samr_SetDomainInfo *r2 = (struct samr_SetDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDomainInfo, NDR_IN, r2);
		}
		r2->out.result = _samr_SetDomainInfo(p, r2);
		break;
	}
	case 10: { /* samr_CreateDomainGroup */
		struct samr_CreateDomainGroup *r2 = (struct samr_CreateDomainGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomainGroup, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.group_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.group_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.rid = talloc_zero(r2, uint32_t);
		if (r2->out.rid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_CreateDomainGroup(p, r2);
		break;
	}
	case 11: { /* samr_EnumDomainGroups */
		struct samr_EnumDomainGroups *r2 = (struct samr_EnumDomainGroups *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainGroups, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.sam = talloc_zero(r2, struct samr_SamArray *);
		if (r2->out.sam == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.num_entries = talloc_zero(r2, uint32_t);
		if (r2->out.num_entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_EnumDomainGroups(p, r2);
		break;
	}
	case 12: { /* samr_CreateUser */
		struct samr_CreateUser *r2 = (struct samr_CreateUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.user_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.user_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.rid = talloc_zero(r2, uint32_t);
		if (r2->out.rid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_CreateUser(p, r2);
		break;
	}
	case 13: { /* samr_EnumDomainUsers */
		struct samr_EnumDomainUsers *r2 = (struct samr_EnumDomainUsers *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainUsers, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.sam = talloc_zero(r2, struct samr_SamArray *);
		if (r2->out.sam == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.num_entries = talloc_zero(r2, uint32_t);
		if (r2->out.num_entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_EnumDomainUsers(p, r2);
		break;
	}
	case 14: { /* samr_CreateDomAlias */
		struct samr_CreateDomAlias *r2 = (struct samr_CreateDomAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomAlias, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.alias_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.alias_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.rid = talloc_zero(r2, uint32_t);
		if (r2->out.rid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_CreateDomAlias(p, r2);
		break;
	}
	case 15: { /* samr_EnumDomainAliases */
		struct samr_EnumDomainAliases *r2 = (struct samr_EnumDomainAliases *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainAliases, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.resume_handle = r2->in.resume_handle;
		r2->out.sam = talloc_zero(r2, struct samr_SamArray *);
		if (r2->out.sam == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.num_entries = talloc_zero(r2, uint32_t);
		if (r2->out.num_entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_EnumDomainAliases(p, r2);
		break;
	}
	case 16: { /* samr_GetAliasMembership */
		struct samr_GetAliasMembership *r2 = (struct samr_GetAliasMembership *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetAliasMembership, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rids = talloc_zero(r2, struct samr_Ids);
		if (r2->out.rids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetAliasMembership(p, r2);
		break;
	}
	case 17: { /* samr_LookupNames */
		struct samr_LookupNames *r2 = (struct samr_LookupNames *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupNames, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rids = talloc_zero(r2, struct samr_Ids);
		if (r2->out.rids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.types = talloc_zero(r2, struct samr_Ids);
		if (r2->out.types == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_LookupNames(p, r2);
		break;
	}
	case 18: { /* samr_LookupRids */
		struct samr_LookupRids *r2 = (struct samr_LookupRids *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupRids, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.names = talloc_zero(r2, struct lsa_Strings);
		if (r2->out.names == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.types = talloc_zero(r2, struct samr_Ids);
		if (r2->out.types == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_LookupRids(p, r2);
		break;
	}
	case 19: { /* samr_OpenGroup */
		struct samr_OpenGroup *r2 = (struct samr_OpenGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenGroup, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.group_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.group_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_OpenGroup(p, r2);
		break;
	}
	case 20: { /* samr_QueryGroupInfo */
		struct samr_QueryGroupInfo *r2 = (struct samr_QueryGroupInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union samr_GroupInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryGroupInfo(p, r2);
		break;
	}
	case 21: { /* samr_SetGroupInfo */
		struct samr_SetGroupInfo *r2 = (struct samr_SetGroupInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetGroupInfo, NDR_IN, r2);
		}
		r2->out.result = _samr_SetGroupInfo(p, r2);
		break;
	}
	case 22: { /* samr_AddGroupMember */
		struct samr_AddGroupMember *r2 = (struct samr_AddGroupMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddGroupMember, NDR_IN, r2);
		}
		r2->out.result = _samr_AddGroupMember(p, r2);
		break;
	}
	case 23: { /* samr_DeleteDomainGroup */
		struct samr_DeleteDomainGroup *r2 = (struct samr_DeleteDomainGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomainGroup, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.group_handle = r2->in.group_handle;
		r2->out.result = _samr_DeleteDomainGroup(p, r2);
		break;
	}
	case 24: { /* samr_DeleteGroupMember */
		struct samr_DeleteGroupMember *r2 = (struct samr_DeleteGroupMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteGroupMember, NDR_IN, r2);
		}
		r2->out.result = _samr_DeleteGroupMember(p, r2);
		break;
	}
	case 25: { /* samr_QueryGroupMember */
		struct samr_QueryGroupMember *r2 = (struct samr_QueryGroupMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupMember, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rids = talloc_zero(r2, struct samr_RidAttrArray *);
		if (r2->out.rids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryGroupMember(p, r2);
		break;
	}
	case 26: { /* samr_SetMemberAttributesOfGroup */
		struct samr_SetMemberAttributesOfGroup *r2 = (struct samr_SetMemberAttributesOfGroup *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetMemberAttributesOfGroup, NDR_IN, r2);
		}
		r2->out.result = _samr_SetMemberAttributesOfGroup(p, r2);
		break;
	}
	case 27: { /* samr_OpenAlias */
		struct samr_OpenAlias *r2 = (struct samr_OpenAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenAlias, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.alias_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.alias_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_OpenAlias(p, r2);
		break;
	}
	case 28: { /* samr_QueryAliasInfo */
		struct samr_QueryAliasInfo *r2 = (struct samr_QueryAliasInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryAliasInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union samr_AliasInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryAliasInfo(p, r2);
		break;
	}
	case 29: { /* samr_SetAliasInfo */
		struct samr_SetAliasInfo *r2 = (struct samr_SetAliasInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetAliasInfo, NDR_IN, r2);
		}
		r2->out.result = _samr_SetAliasInfo(p, r2);
		break;
	}
	case 30: { /* samr_DeleteDomAlias */
		struct samr_DeleteDomAlias *r2 = (struct samr_DeleteDomAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomAlias, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.alias_handle = r2->in.alias_handle;
		r2->out.result = _samr_DeleteDomAlias(p, r2);
		break;
	}
	case 31: { /* samr_AddAliasMember */
		struct samr_AddAliasMember *r2 = (struct samr_AddAliasMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddAliasMember, NDR_IN, r2);
		}
		r2->out.result = _samr_AddAliasMember(p, r2);
		break;
	}
	case 32: { /* samr_DeleteAliasMember */
		struct samr_DeleteAliasMember *r2 = (struct samr_DeleteAliasMember *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteAliasMember, NDR_IN, r2);
		}
		r2->out.result = _samr_DeleteAliasMember(p, r2);
		break;
	}
	case 33: { /* samr_GetMembersInAlias */
		struct samr_GetMembersInAlias *r2 = (struct samr_GetMembersInAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetMembersInAlias, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sids = talloc_zero(r2, struct lsa_SidArray);
		if (r2->out.sids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetMembersInAlias(p, r2);
		break;
	}
	case 34: { /* samr_OpenUser */
		struct samr_OpenUser *r2 = (struct samr_OpenUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenUser, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.user_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.user_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_OpenUser(p, r2);
		break;
	}
	case 35: { /* samr_DeleteUser */
		struct samr_DeleteUser *r2 = (struct samr_DeleteUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteUser, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.user_handle = r2->in.user_handle;
		r2->out.result = _samr_DeleteUser(p, r2);
		break;
	}
	case 36: { /* samr_QueryUserInfo */
		struct samr_QueryUserInfo *r2 = (struct samr_QueryUserInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union samr_UserInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryUserInfo(p, r2);
		break;
	}
	case 37: { /* samr_SetUserInfo */
		struct samr_SetUserInfo *r2 = (struct samr_SetUserInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo, NDR_IN, r2);
		}
		r2->out.result = _samr_SetUserInfo(p, r2);
		break;
	}
	case 38: { /* samr_ChangePasswordUser */
		struct samr_ChangePasswordUser *r2 = (struct samr_ChangePasswordUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser, NDR_IN, r2);
		}
		r2->out.result = _samr_ChangePasswordUser(p, r2);
		break;
	}
	case 39: { /* samr_GetGroupsForUser */
		struct samr_GetGroupsForUser *r2 = (struct samr_GetGroupsForUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetGroupsForUser, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rids = talloc_zero(r2, struct samr_RidWithAttributeArray *);
		if (r2->out.rids == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetGroupsForUser(p, r2);
		break;
	}
	case 40: { /* samr_QueryDisplayInfo */
		struct samr_QueryDisplayInfo *r2 = (struct samr_QueryDisplayInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.total_size = talloc_zero(r2, uint32_t);
		if (r2->out.total_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.returned_size = talloc_zero(r2, uint32_t);
		if (r2->out.returned_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union samr_DispInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryDisplayInfo(p, r2);
		break;
	}
	case 41: { /* samr_GetDisplayEnumerationIndex */
		struct samr_GetDisplayEnumerationIndex *r2 = (struct samr_GetDisplayEnumerationIndex *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.idx = talloc_zero(r2, uint32_t);
		if (r2->out.idx == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetDisplayEnumerationIndex(p, r2);
		break;
	}
	case 42: { /* samr_TestPrivateFunctionsDomain */
		struct samr_TestPrivateFunctionsDomain *r2 = (struct samr_TestPrivateFunctionsDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsDomain, NDR_IN, r2);
		}
		r2->out.result = _samr_TestPrivateFunctionsDomain(p, r2);
		break;
	}
	case 43: { /* samr_TestPrivateFunctionsUser */
		struct samr_TestPrivateFunctionsUser *r2 = (struct samr_TestPrivateFunctionsUser *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsUser, NDR_IN, r2);
		}
		r2->out.result = _samr_TestPrivateFunctionsUser(p, r2);
		break;
	}
	case 44: { /* samr_GetUserPwInfo */
		struct samr_GetUserPwInfo *r2 = (struct samr_GetUserPwInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetUserPwInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct samr_PwInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetUserPwInfo(p, r2);
		break;
	}
	case 45: { /* samr_RemoveMemberFromForeignDomain */
		struct samr_RemoveMemberFromForeignDomain *r2 = (struct samr_RemoveMemberFromForeignDomain *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMemberFromForeignDomain, NDR_IN, r2);
		}
		r2->out.result = _samr_RemoveMemberFromForeignDomain(p, r2);
		break;
	}
	case 46: { /* samr_QueryDomainInfo2 */
		struct samr_QueryDomainInfo2 *r2 = (struct samr_QueryDomainInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union samr_DomainInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryDomainInfo2(p, r2);
		break;
	}
	case 47: { /* samr_QueryUserInfo2 */
		struct samr_QueryUserInfo2 *r2 = (struct samr_QueryUserInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, union samr_UserInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryUserInfo2(p, r2);
		break;
	}
	case 48: { /* samr_QueryDisplayInfo2 */
		struct samr_QueryDisplayInfo2 *r2 = (struct samr_QueryDisplayInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.total_size = talloc_zero(r2, uint32_t);
		if (r2->out.total_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.returned_size = talloc_zero(r2, uint32_t);
		if (r2->out.returned_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union samr_DispInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryDisplayInfo2(p, r2);
		break;
	}
	case 49: { /* samr_GetDisplayEnumerationIndex2 */
		struct samr_GetDisplayEnumerationIndex2 *r2 = (struct samr_GetDisplayEnumerationIndex2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.idx = talloc_zero(r2, uint32_t);
		if (r2->out.idx == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetDisplayEnumerationIndex2(p, r2);
		break;
	}
	case 50: { /* samr_CreateUser2 */
		struct samr_CreateUser2 *r2 = (struct samr_CreateUser2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.user_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.user_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.access_granted = talloc_zero(r2, uint32_t);
		if (r2->out.access_granted == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.rid = talloc_zero(r2, uint32_t);
		if (r2->out.rid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_CreateUser2(p, r2);
		break;
	}
	case 51: { /* samr_QueryDisplayInfo3 */
		struct samr_QueryDisplayInfo3 *r2 = (struct samr_QueryDisplayInfo3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo3, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.total_size = talloc_zero(r2, uint32_t);
		if (r2->out.total_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.returned_size = talloc_zero(r2, uint32_t);
		if (r2->out.returned_size == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info = talloc_zero(r2, union samr_DispInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_QueryDisplayInfo3(p, r2);
		break;
	}
	case 52: { /* samr_AddMultipleMembersToAlias */
		struct samr_AddMultipleMembersToAlias *r2 = (struct samr_AddMultipleMembersToAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddMultipleMembersToAlias, NDR_IN, r2);
		}
		r2->out.result = _samr_AddMultipleMembersToAlias(p, r2);
		break;
	}
	case 53: { /* samr_RemoveMultipleMembersFromAlias */
		struct samr_RemoveMultipleMembersFromAlias *r2 = (struct samr_RemoveMultipleMembersFromAlias *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMultipleMembersFromAlias, NDR_IN, r2);
		}
		r2->out.result = _samr_RemoveMultipleMembersFromAlias(p, r2);
		break;
	}
	case 54: { /* samr_OemChangePasswordUser2 */
		struct samr_OemChangePasswordUser2 *r2 = (struct samr_OemChangePasswordUser2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OemChangePasswordUser2, NDR_IN, r2);
		}
		r2->out.result = _samr_OemChangePasswordUser2(p, r2);
		break;
	}
	case 55: { /* samr_ChangePasswordUser2 */
		struct samr_ChangePasswordUser2 *r2 = (struct samr_ChangePasswordUser2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser2, NDR_IN, r2);
		}
		r2->out.result = _samr_ChangePasswordUser2(p, r2);
		break;
	}
	case 56: { /* samr_GetDomPwInfo */
		struct samr_GetDomPwInfo *r2 = (struct samr_GetDomPwInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDomPwInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct samr_PwInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetDomPwInfo(p, r2);
		break;
	}
	case 57: { /* samr_Connect2 */
		struct samr_Connect2 *r2 = (struct samr_Connect2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.connect_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.connect_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_Connect2(p, r2);
		break;
	}
	case 58: { /* samr_SetUserInfo2 */
		struct samr_SetUserInfo2 *r2 = (struct samr_SetUserInfo2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo2, NDR_IN, r2);
		}
		r2->out.result = _samr_SetUserInfo2(p, r2);
		break;
	}
	case 59: { /* samr_SetBootKeyInformation */
		struct samr_SetBootKeyInformation *r2 = (struct samr_SetBootKeyInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetBootKeyInformation, NDR_IN, r2);
		}
		r2->out.result = _samr_SetBootKeyInformation(p, r2);
		break;
	}
	case 60: { /* samr_GetBootKeyInformation */
		struct samr_GetBootKeyInformation *r2 = (struct samr_GetBootKeyInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetBootKeyInformation, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.unknown = talloc_zero(r2, uint32_t);
		if (r2->out.unknown == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_GetBootKeyInformation(p, r2);
		break;
	}
	case 61: { /* samr_Connect3 */
		struct samr_Connect3 *r2 = (struct samr_Connect3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect3, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.connect_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.connect_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_Connect3(p, r2);
		break;
	}
	case 62: { /* samr_Connect4 */
		struct samr_Connect4 *r2 = (struct samr_Connect4 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect4, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.connect_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.connect_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_Connect4(p, r2);
		break;
	}
	case 63: { /* samr_ChangePasswordUser3 */
		struct samr_ChangePasswordUser3 *r2 = (struct samr_ChangePasswordUser3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser3, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dominfo = talloc_zero(r2, struct samr_DomInfo1 *);
		if (r2->out.dominfo == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.reject = talloc_zero(r2, struct userPwdChangeFailureInformation *);
		if (r2->out.reject == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_ChangePasswordUser3(p, r2);
		break;
	}
	case 64: { /* samr_Connect5 */
		struct samr_Connect5 *r2 = (struct samr_Connect5 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect5, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.level_out = talloc_zero(r2, uint32_t);
		if (r2->out.level_out == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.info_out = talloc_zero(r2, union samr_ConnectInfo);
		if (r2->out.info_out == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.connect_handle = talloc_zero(r2, struct policy_handle);
		if (r2->out.connect_handle == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_Connect5(p, r2);
		break;
	}
	case 65: { /* samr_RidToSid */
		struct samr_RidToSid *r2 = (struct samr_RidToSid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RidToSid, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.sid = talloc_zero(r2, struct dom_sid2 *);
		if (r2->out.sid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_RidToSid(p, r2);
		break;
	}
	case 66: { /* samr_SetDsrmPassword */
		struct samr_SetDsrmPassword *r2 = (struct samr_SetDsrmPassword *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDsrmPassword, NDR_IN, r2);
		}
		r2->out.result = _samr_SetDsrmPassword(p, r2);
		break;
	}
	case 67: { /* samr_ValidatePassword */
		struct samr_ValidatePassword *r2 = (struct samr_ValidatePassword *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ValidatePassword, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rep = talloc_zero(r2, union samr_ValidatePasswordRep *);
		if (r2->out.rep == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _samr_ValidatePassword(p, r2);
		break;
	}
	case 68: { /* samr_Opnum68NotUsedOnWire */
		struct samr_Opnum68NotUsedOnWire *r2 = (struct samr_Opnum68NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum68NotUsedOnWire, NDR_IN, r2);
		}
		_samr_Opnum68NotUsedOnWire(p, r2);
		break;
	}
	case 69: { /* samr_Opnum69NotUsedOnWire */
		struct samr_Opnum69NotUsedOnWire *r2 = (struct samr_Opnum69NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum69NotUsedOnWire, NDR_IN, r2);
		}
		_samr_Opnum69NotUsedOnWire(p, r2);
		break;
	}
	case 70: { /* samr_Opnum70NotUsedOnWire */
		struct samr_Opnum70NotUsedOnWire *r2 = (struct samr_Opnum70NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum70NotUsedOnWire, NDR_IN, r2);
		}
		_samr_Opnum70NotUsedOnWire(p, r2);
		break;
	}
	case 71: { /* samr_Opnum71NotUsedOnWire */
		struct samr_Opnum71NotUsedOnWire *r2 = (struct samr_Opnum71NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum71NotUsedOnWire, NDR_IN, r2);
		}
		_samr_Opnum71NotUsedOnWire(p, r2);
		break;
	}
	case 72: { /* samr_Opnum72NotUsedOnWire */
		struct samr_Opnum72NotUsedOnWire *r2 = (struct samr_Opnum72NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum72NotUsedOnWire, NDR_IN, r2);
		}
		_samr_Opnum72NotUsedOnWire(p, r2);
		break;
	}
	case 73: { /* samr_ChangePasswordUser4 */
		struct samr_ChangePasswordUser4 *r2 = (struct samr_ChangePasswordUser4 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser4, NDR_IN, r2);
		}
		r2->out.result = _samr_ChangePasswordUser4(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS samr__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return samr__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS samr__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* samr_Connect */
		struct samr_Connect *r2 = (struct samr_Connect *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Connect\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* samr_Close */
		struct samr_Close *r2 = (struct samr_Close *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Close replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Close, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Close\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* samr_SetSecurity */
		struct samr_SetSecurity *r2 = (struct samr_SetSecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetSecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetSecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetSecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* samr_QuerySecurity */
		struct samr_QuerySecurity *r2 = (struct samr_QuerySecurity *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QuerySecurity replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QuerySecurity, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QuerySecurity\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* samr_Shutdown */
		struct samr_Shutdown *r2 = (struct samr_Shutdown *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Shutdown replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Shutdown, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Shutdown\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* samr_LookupDomain */
		struct samr_LookupDomain *r2 = (struct samr_LookupDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_LookupDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* samr_EnumDomains */
		struct samr_EnumDomains *r2 = (struct samr_EnumDomains *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomains replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomains, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_EnumDomains\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* samr_OpenDomain */
		struct samr_OpenDomain *r2 = (struct samr_OpenDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_OpenDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* samr_QueryDomainInfo */
		struct samr_QueryDomainInfo *r2 = (struct samr_QueryDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* samr_SetDomainInfo */
		struct samr_SetDomainInfo *r2 = (struct samr_SetDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* samr_CreateDomainGroup */
		struct samr_CreateDomainGroup *r2 = (struct samr_CreateDomainGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateDomainGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomainGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_CreateDomainGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* samr_EnumDomainGroups */
		struct samr_EnumDomainGroups *r2 = (struct samr_EnumDomainGroups *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainGroups replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainGroups, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_EnumDomainGroups\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* samr_CreateUser */
		struct samr_CreateUser *r2 = (struct samr_CreateUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_CreateUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* samr_EnumDomainUsers */
		struct samr_EnumDomainUsers *r2 = (struct samr_EnumDomainUsers *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainUsers replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainUsers, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_EnumDomainUsers\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* samr_CreateDomAlias */
		struct samr_CreateDomAlias *r2 = (struct samr_CreateDomAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateDomAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateDomAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_CreateDomAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* samr_EnumDomainAliases */
		struct samr_EnumDomainAliases *r2 = (struct samr_EnumDomainAliases *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_EnumDomainAliases replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_EnumDomainAliases, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_EnumDomainAliases\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* samr_GetAliasMembership */
		struct samr_GetAliasMembership *r2 = (struct samr_GetAliasMembership *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetAliasMembership replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetAliasMembership, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetAliasMembership\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* samr_LookupNames */
		struct samr_LookupNames *r2 = (struct samr_LookupNames *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupNames replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupNames, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_LookupNames\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* samr_LookupRids */
		struct samr_LookupRids *r2 = (struct samr_LookupRids *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_LookupRids replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_LookupRids, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_LookupRids\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* samr_OpenGroup */
		struct samr_OpenGroup *r2 = (struct samr_OpenGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_OpenGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* samr_QueryGroupInfo */
		struct samr_QueryGroupInfo *r2 = (struct samr_QueryGroupInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryGroupInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryGroupInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* samr_SetGroupInfo */
		struct samr_SetGroupInfo *r2 = (struct samr_SetGroupInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetGroupInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetGroupInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetGroupInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* samr_AddGroupMember */
		struct samr_AddGroupMember *r2 = (struct samr_AddGroupMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddGroupMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddGroupMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_AddGroupMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* samr_DeleteDomainGroup */
		struct samr_DeleteDomainGroup *r2 = (struct samr_DeleteDomainGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteDomainGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomainGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_DeleteDomainGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* samr_DeleteGroupMember */
		struct samr_DeleteGroupMember *r2 = (struct samr_DeleteGroupMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteGroupMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteGroupMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_DeleteGroupMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* samr_QueryGroupMember */
		struct samr_QueryGroupMember *r2 = (struct samr_QueryGroupMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryGroupMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryGroupMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryGroupMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* samr_SetMemberAttributesOfGroup */
		struct samr_SetMemberAttributesOfGroup *r2 = (struct samr_SetMemberAttributesOfGroup *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetMemberAttributesOfGroup replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetMemberAttributesOfGroup, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetMemberAttributesOfGroup\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* samr_OpenAlias */
		struct samr_OpenAlias *r2 = (struct samr_OpenAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_OpenAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* samr_QueryAliasInfo */
		struct samr_QueryAliasInfo *r2 = (struct samr_QueryAliasInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryAliasInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryAliasInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryAliasInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* samr_SetAliasInfo */
		struct samr_SetAliasInfo *r2 = (struct samr_SetAliasInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetAliasInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetAliasInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetAliasInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* samr_DeleteDomAlias */
		struct samr_DeleteDomAlias *r2 = (struct samr_DeleteDomAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteDomAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteDomAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_DeleteDomAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* samr_AddAliasMember */
		struct samr_AddAliasMember *r2 = (struct samr_AddAliasMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddAliasMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddAliasMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_AddAliasMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* samr_DeleteAliasMember */
		struct samr_DeleteAliasMember *r2 = (struct samr_DeleteAliasMember *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteAliasMember replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteAliasMember, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_DeleteAliasMember\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* samr_GetMembersInAlias */
		struct samr_GetMembersInAlias *r2 = (struct samr_GetMembersInAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetMembersInAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetMembersInAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetMembersInAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* samr_OpenUser */
		struct samr_OpenUser *r2 = (struct samr_OpenUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OpenUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OpenUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_OpenUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* samr_DeleteUser */
		struct samr_DeleteUser *r2 = (struct samr_DeleteUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_DeleteUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_DeleteUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_DeleteUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 36: { /* samr_QueryUserInfo */
		struct samr_QueryUserInfo *r2 = (struct samr_QueryUserInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryUserInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryUserInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 37: { /* samr_SetUserInfo */
		struct samr_SetUserInfo *r2 = (struct samr_SetUserInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetUserInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetUserInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 38: { /* samr_ChangePasswordUser */
		struct samr_ChangePasswordUser *r2 = (struct samr_ChangePasswordUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_ChangePasswordUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 39: { /* samr_GetGroupsForUser */
		struct samr_GetGroupsForUser *r2 = (struct samr_GetGroupsForUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetGroupsForUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetGroupsForUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetGroupsForUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 40: { /* samr_QueryDisplayInfo */
		struct samr_QueryDisplayInfo *r2 = (struct samr_QueryDisplayInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryDisplayInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 41: { /* samr_GetDisplayEnumerationIndex */
		struct samr_GetDisplayEnumerationIndex *r2 = (struct samr_GetDisplayEnumerationIndex *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDisplayEnumerationIndex replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetDisplayEnumerationIndex\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 42: { /* samr_TestPrivateFunctionsDomain */
		struct samr_TestPrivateFunctionsDomain *r2 = (struct samr_TestPrivateFunctionsDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_TestPrivateFunctionsDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_TestPrivateFunctionsDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 43: { /* samr_TestPrivateFunctionsUser */
		struct samr_TestPrivateFunctionsUser *r2 = (struct samr_TestPrivateFunctionsUser *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_TestPrivateFunctionsUser replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_TestPrivateFunctionsUser, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_TestPrivateFunctionsUser\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 44: { /* samr_GetUserPwInfo */
		struct samr_GetUserPwInfo *r2 = (struct samr_GetUserPwInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetUserPwInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetUserPwInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetUserPwInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 45: { /* samr_RemoveMemberFromForeignDomain */
		struct samr_RemoveMemberFromForeignDomain *r2 = (struct samr_RemoveMemberFromForeignDomain *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RemoveMemberFromForeignDomain replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMemberFromForeignDomain, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_RemoveMemberFromForeignDomain\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 46: { /* samr_QueryDomainInfo2 */
		struct samr_QueryDomainInfo2 *r2 = (struct samr_QueryDomainInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDomainInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDomainInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryDomainInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 47: { /* samr_QueryUserInfo2 */
		struct samr_QueryUserInfo2 *r2 = (struct samr_QueryUserInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryUserInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryUserInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryUserInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 48: { /* samr_QueryDisplayInfo2 */
		struct samr_QueryDisplayInfo2 *r2 = (struct samr_QueryDisplayInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryDisplayInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 49: { /* samr_GetDisplayEnumerationIndex2 */
		struct samr_GetDisplayEnumerationIndex2 *r2 = (struct samr_GetDisplayEnumerationIndex2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDisplayEnumerationIndex2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDisplayEnumerationIndex2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetDisplayEnumerationIndex2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 50: { /* samr_CreateUser2 */
		struct samr_CreateUser2 *r2 = (struct samr_CreateUser2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_CreateUser2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_CreateUser2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_CreateUser2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 51: { /* samr_QueryDisplayInfo3 */
		struct samr_QueryDisplayInfo3 *r2 = (struct samr_QueryDisplayInfo3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_QueryDisplayInfo3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_QueryDisplayInfo3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_QueryDisplayInfo3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 52: { /* samr_AddMultipleMembersToAlias */
		struct samr_AddMultipleMembersToAlias *r2 = (struct samr_AddMultipleMembersToAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_AddMultipleMembersToAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_AddMultipleMembersToAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_AddMultipleMembersToAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 53: { /* samr_RemoveMultipleMembersFromAlias */
		struct samr_RemoveMultipleMembersFromAlias *r2 = (struct samr_RemoveMultipleMembersFromAlias *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RemoveMultipleMembersFromAlias replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RemoveMultipleMembersFromAlias, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_RemoveMultipleMembersFromAlias\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 54: { /* samr_OemChangePasswordUser2 */
		struct samr_OemChangePasswordUser2 *r2 = (struct samr_OemChangePasswordUser2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_OemChangePasswordUser2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_OemChangePasswordUser2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_OemChangePasswordUser2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 55: { /* samr_ChangePasswordUser2 */
		struct samr_ChangePasswordUser2 *r2 = (struct samr_ChangePasswordUser2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_ChangePasswordUser2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 56: { /* samr_GetDomPwInfo */
		struct samr_GetDomPwInfo *r2 = (struct samr_GetDomPwInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetDomPwInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetDomPwInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetDomPwInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 57: { /* samr_Connect2 */
		struct samr_Connect2 *r2 = (struct samr_Connect2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Connect2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 58: { /* samr_SetUserInfo2 */
		struct samr_SetUserInfo2 *r2 = (struct samr_SetUserInfo2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetUserInfo2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetUserInfo2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetUserInfo2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 59: { /* samr_SetBootKeyInformation */
		struct samr_SetBootKeyInformation *r2 = (struct samr_SetBootKeyInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetBootKeyInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetBootKeyInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetBootKeyInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 60: { /* samr_GetBootKeyInformation */
		struct samr_GetBootKeyInformation *r2 = (struct samr_GetBootKeyInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_GetBootKeyInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_GetBootKeyInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_GetBootKeyInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 61: { /* samr_Connect3 */
		struct samr_Connect3 *r2 = (struct samr_Connect3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Connect3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 62: { /* samr_Connect4 */
		struct samr_Connect4 *r2 = (struct samr_Connect4 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect4 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect4, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Connect4\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 63: { /* samr_ChangePasswordUser3 */
		struct samr_ChangePasswordUser3 *r2 = (struct samr_ChangePasswordUser3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_ChangePasswordUser3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 64: { /* samr_Connect5 */
		struct samr_Connect5 *r2 = (struct samr_Connect5 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Connect5 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Connect5, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Connect5\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 65: { /* samr_RidToSid */
		struct samr_RidToSid *r2 = (struct samr_RidToSid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_RidToSid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_RidToSid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_RidToSid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 66: { /* samr_SetDsrmPassword */
		struct samr_SetDsrmPassword *r2 = (struct samr_SetDsrmPassword *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_SetDsrmPassword replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_SetDsrmPassword, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_SetDsrmPassword\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 67: { /* samr_ValidatePassword */
		struct samr_ValidatePassword *r2 = (struct samr_ValidatePassword *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ValidatePassword replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ValidatePassword, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_ValidatePassword\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 68: { /* samr_Opnum68NotUsedOnWire */
		struct samr_Opnum68NotUsedOnWire *r2 = (struct samr_Opnum68NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Opnum68NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum68NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Opnum68NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 69: { /* samr_Opnum69NotUsedOnWire */
		struct samr_Opnum69NotUsedOnWire *r2 = (struct samr_Opnum69NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Opnum69NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum69NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Opnum69NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 70: { /* samr_Opnum70NotUsedOnWire */
		struct samr_Opnum70NotUsedOnWire *r2 = (struct samr_Opnum70NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Opnum70NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum70NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Opnum70NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 71: { /* samr_Opnum71NotUsedOnWire */
		struct samr_Opnum71NotUsedOnWire *r2 = (struct samr_Opnum71NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Opnum71NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum71NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Opnum71NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 72: { /* samr_Opnum72NotUsedOnWire */
		struct samr_Opnum72NotUsedOnWire *r2 = (struct samr_Opnum72NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_Opnum72NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_Opnum72NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_Opnum72NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 73: { /* samr_ChangePasswordUser4 */
		struct samr_ChangePasswordUser4 *r2 = (struct samr_ChangePasswordUser4 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function samr_ChangePasswordUser4 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(samr_ChangePasswordUser4, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in samr_ChangePasswordUser4\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS samr__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_samr.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS samr__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return samr__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_samr_interface = {
	.name      = "samr",
	.syntax_id = {{0x12345778,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0x89,0xac}},1.0},
	.bind      = samr__op_bind,
	.unbind    = samr__op_unbind,
	.ndr_pull  = samr__op_ndr_pull,
	.dispatch  = samr__op_dispatch,
	.reply     = samr__op_reply,
	.ndr_push  = samr__op_ndr_push,
	.local     = samr__op_local,
#ifdef DCESRV_INTERFACE_SAMR_FLAGS
	.flags     = DCESRV_INTERFACE_SAMR_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS samr__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_SAMR_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_SAMR_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_samr.endpoints->count;i++) {
		const char *name = ndr_table_samr.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_samr_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS samr__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool samr__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_samr_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_samr_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_samr_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool samr__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_samr_interface.name, name)==0) {
		memcpy(iface, &dcesrv_samr_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server samr_ep_server = {
	/* fill in our name */
	.name = "samr",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_SAMR_INIT_SERVER
	.init_server = DCESRV_INTERFACE_SAMR_INIT_SERVER,
#else
	.init_server = samr__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_SAMR_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_SAMR_SHUTDOWN_SERVER,
#else
	.shutdown_server = samr__op_shutdown_server,
#endif
	.interface_by_uuid = samr__op_interface_by_uuid,
	.interface_by_name = samr__op_interface_by_name
};

const struct dcesrv_endpoint_server *samr_get_ep_server(void)
{
	return &samr_ep_server;
}
