#ifndef __SOURCE4_TORTURE_RPC_PROTO_H__
#define __SOURCE4_TORTURE_RPC_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/torture/rpc/join.c  */

bool torture_rpc_join(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/lsa.c  */

bool test_lsa_OpenPolicy2_ex(struct dcerpc_binding_handle *b,
			     struct torture_context *tctx,
			     struct policy_handle **handle,
			     NTSTATUS expected_status,
			     NTSTATUS expected_status2);
bool test_lsa_OpenPolicy2(struct dcerpc_binding_handle *b,
			  struct torture_context *tctx,
			  struct policy_handle **handle);
bool test_lsa_OpenPolicy3_ex(struct dcerpc_binding_handle *b,
			     struct torture_context *tctx,
			     struct policy_handle **handle,
			     NTSTATUS expected_status,
			     NTSTATUS expected_status2);
bool test_lsa_OpenPolicy3(struct dcerpc_binding_handle *b,
			  struct torture_context *tctx,
			  struct policy_handle **handle);
bool test_many_LookupSids(struct dcerpc_pipe *p,
			  struct torture_context *tctx,
			  struct policy_handle *handle,
			  enum lsa_LookupNamesLevel level);
bool test_lsa_Close(struct dcerpc_binding_handle *b,
		    struct torture_context *tctx,
		    struct policy_handle *handle);
bool torture_rpc_lsa(struct torture_context *tctx);
bool torture_rpc_lsa_get_user(struct torture_context *tctx);
struct torture_suite *torture_rpc_lsa_lookup_names(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_lsa_trusted_domains(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_lsa_privileges(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/forest_trust.c  */

struct torture_suite *torture_rpc_lsa_forest_trust(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/lsa_lookup.c  */

bool torture_rpc_lsa_lookup(struct torture_context *torture);
struct torture_suite *torture_rpc_lsa_lookup_sids(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/session_key.c  */

struct torture_suite *torture_rpc_lsa_secrets(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/echo.c  */

struct torture_suite *torture_rpc_echo(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/dfs.c  */

struct torture_suite *torture_rpc_dfs(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/drsuapi.c  */

bool test_QuerySitesByCost(struct torture_context *tctx,
			   struct DsPrivate *priv);
bool test_DsUnbind(struct dcerpc_pipe *p,
		   struct torture_context *tctx,
		   struct DsPrivate *priv);

/**
 * Helper func to collect DC information for testing purposes.
 * This function is almost identical to test_DsGetDomainControllerInfo
 */
bool torture_rpc_drsuapi_get_dcinfo(struct torture_context *torture,
				    struct DsPrivate *priv);

/**
 * Common test case setup function to be used
 * in DRS suit of test when appropriate
 */
bool torture_drsuapi_tcase_setup_common(struct torture_context *tctx, struct DsPrivate *priv);

/**
 * Common test case teardown function to be used
 * in DRS suit of test when appropriate
 */
bool torture_drsuapi_tcase_teardown_common(struct torture_context *tctx, struct DsPrivate *priv);

/**
 * DRSUAPI test case implementation
 */
void torture_rpc_drsuapi_tcase(struct torture_suite *suite);

/* The following definitions come from ../../source4/torture/rpc/drsuapi_w2k8.c  */

bool test_DsBind_w2k8(struct torture_context *tctx,
		      struct DsPrivate_w2k8 *priv);
bool test_DsUnbind_w2k8(struct torture_context *tctx,
			struct DsPrivate_w2k8 *priv);

/**
 * Common test case setup function to be used
 * in DRS suit of test when appropriate
 */
bool torture_drsuapi_w2k8_tcase_setup_common(struct torture_context *tctx,
					     struct DsPrivate_w2k8 *priv);

/**
 * Common test case teardown function to be used
 * in DRS suit of test when appropriate
 */
bool torture_drsuapi_w2k8_tcase_teardown_common(struct torture_context *tctx,
						struct DsPrivate_w2k8 *priv);

/**
 * DRSUAPI test case implementation
 */
void torture_rpc_drsuapi_w2k8_tcase(struct torture_suite *suite);

/* The following definitions come from ../../source4/torture/rpc/drsuapi_cracknames.c  */

bool test_DsCrackNames(struct torture_context *tctx,
		       struct DsPrivate *priv);

/**
 * CRACKNAMES test suite implementation
 */
void torture_rpc_drsuapi_cracknames_tcase(struct torture_suite *suite);

/* The following definitions come from ../../source4/torture/rpc/dsgetinfo.c  */


/**
 * DSGETINFO test case implementation
 */
void torture_drs_rpc_dsgetinfo_tcase(struct torture_suite *suite);

/* The following definitions come from ../../source4/torture/rpc/spoolss.c  */

bool test_GetPrinter_level_exp(struct torture_context *tctx,
			       struct dcerpc_binding_handle *b,
			       struct policy_handle *handle,
			       uint32_t level,
			       WERROR expected_werror,
			       union spoolss_PrinterInfo *info);
bool test_GetPrinter_level(struct torture_context *tctx,
			   struct dcerpc_binding_handle *b,
			   struct policy_handle *handle,
			   uint32_t level,
			   union spoolss_PrinterInfo *info);
bool test_ClosePrinter(struct torture_context *tctx,
		       struct dcerpc_binding_handle *b,
		       struct policy_handle *handle);
bool test_winreg_QueryValue(struct torture_context *tctx,
			    struct dcerpc_binding_handle *b,
			    struct policy_handle *handle,
			    const char *value_name,
			    enum winreg_Type *type_p,
			    uint32_t *data_size_p,
			    uint32_t *data_length_p,
			    uint8_t **data_p);
bool test_printer_all_keys(struct torture_context *tctx,
			   struct dcerpc_binding_handle *b,
			   struct policy_handle *handle);
void torture_tcase_printer(struct torture_tcase *tcase);
struct torture_suite *torture_rpc_spoolss_printer(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_spoolss(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_spoolss_driver(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/spoolss_win.c  */

struct torture_suite *torture_rpc_spoolss_win(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/spoolss_access.c  */

struct torture_suite *torture_rpc_spoolss_access(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/unixinfo.c  */


/**
  test the SidToUid interface
*/
struct torture_suite *torture_rpc_unixinfo(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/samr.c  */

bool test_samr_handle_Close(struct dcerpc_binding_handle *b,
			    struct torture_context *tctx,
			    struct policy_handle *handle);
bool test_ChangePasswordUser3(struct dcerpc_pipe *p, struct torture_context *tctx,
			      const char *account_string,
			      int policy_min_pw_len,
			      char **password,
			      const char *newpass,
			      NTTIME last_password_change,
			      bool handle_reject_reason);
bool test_ChangePasswordUser4(struct dcerpc_pipe *p,
			      struct torture_context *tctx,
			      const char *account_string,
			      int policy_min_pw_len,
			      char **password,
			      const char *newpassword);
bool test_ChangePasswordRandomBytes(struct dcerpc_pipe *p, struct torture_context *tctx,
				    const char *account_string,
				    struct policy_handle *handle,
				    char **password);
bool test_DeleteUser_byname(struct dcerpc_binding_handle *b,
			    struct torture_context *tctx,
			    struct policy_handle *handle, const char *name);
bool torture_rpc_samr(struct torture_context *torture);
bool torture_rpc_samr_users(struct torture_context *torture);
bool torture_rpc_samr_passwords(struct torture_context *torture);
struct torture_suite *torture_rpc_samr_passwords_pwdlastset(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_samr_user_privileges(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_samr_large_dc(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_samr_passwords_badpwdcount(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_samr_passwords_lockout(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_samr_passwords_validate(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/samr_accessmask.c  */

struct torture_suite *torture_rpc_samr_accessmask(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_samr_workstation_auth(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/samr_handletype.c  */

struct torture_suite *torture_rpc_samr_handletype(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/samr_priv.c  */

struct torture_suite *torture_rpc_samr_priv(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/wkssvc.c  */

struct torture_suite *torture_rpc_wkssvc(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/srvsvc.c  */


/**************************/
struct torture_suite *torture_rpc_srvsvc(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/svcctl.c  */

struct torture_suite *torture_rpc_svcctl(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/atsvc.c  */

struct torture_suite *torture_rpc_atsvc(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/eventlog.c  */

struct torture_suite *torture_rpc_eventlog(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/epmapper.c  */

struct torture_suite *torture_rpc_epmapper(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/winreg.c  */

struct torture_suite *torture_rpc_winreg(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/initshutdown.c  */

struct torture_suite *torture_rpc_initshutdown(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/mgmt.c  */

bool test_inq_if_ids(struct torture_context *tctx,
		     struct dcerpc_binding_handle *b,
		     TALLOC_CTX *mem_ctx,
		     bool (*per_id_test)(struct torture_context *,
					 const struct ndr_interface_table *iface,
					 TALLOC_CTX *mem_ctx,
					 struct ndr_syntax_id *id),
		     const void *priv);
bool torture_rpc_mgmt(struct torture_context *tctx);

/* The following definitions come from ../../source4/torture/rpc/scanner.c  */

bool torture_rpc_scanner(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/countcalls.c  */

bool count_calls(struct torture_context *tctx,
		 TALLOC_CTX *mem_ctx,
		 const struct ndr_interface_table *iface,
	bool all) ;
bool torture_rpc_countcalls(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/testjoin.c  */

struct test_join *torture_create_testuser_max_pwlen(struct torture_context *tctx,
						    const char *username,
						    const char *domain,
						    uint16_t acct_type,
						    const char **random_password,
						    int max_pw_len);
bool torture_setup_privs(struct torture_context *tctx,
			struct dcerpc_pipe *p,
			uint32_t num_privs,
			const char **privs,
			const struct dom_sid *user_sid);
struct test_join *torture_create_testuser(struct torture_context *torture,
					  const char *username,
					  const char *domain,
					  uint16_t acct_type,
					  const char **random_password);
NTSTATUS torture_delete_testuser(struct torture_context *torture,
				 struct test_join *join,
				 const char *username);
struct dcerpc_pipe *torture_join_samr_pipe(struct test_join *join) ;
struct policy_handle *torture_join_samr_user_policy(struct test_join *join) ;
const struct dom_sid *torture_join_user_sid(struct test_join *join);
const char *torture_join_netbios_name(struct test_join *join);
const struct GUID *torture_join_user_guid(struct test_join *join);
const char *torture_join_dom_netbios_name(struct test_join *join);
const char *torture_join_dom_dns_name(struct test_join *join);
struct test_join_ads_dc *torture_join_domain_ads_dc(const char *machine_name, 
						    const char *domain,
						    struct cli_credentials **machine_credentials);

/* The following definitions come from ../../source4/torture/rpc/schannel.c  */

bool test_netlogon_ex_ops(struct dcerpc_pipe *p, struct torture_context *tctx,
			  struct cli_credentials *credentials,
			  struct netlogon_creds_CredentialState *creds);
bool torture_rpc_schannel(struct torture_context *torture);
bool torture_rpc_schannel_anon_setpw(struct torture_context *torture);
bool torture_rpc_schannel2(struct torture_context *torture);
bool torture_rpc_schannel_bench1(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/netlogon.c  */

bool test_SetupCredentials(struct dcerpc_pipe *p, struct torture_context *tctx,
				  struct cli_credentials *credentials,
				  struct netlogon_creds_CredentialState **creds_out);
bool test_SetupCredentials2ex(struct dcerpc_pipe *p, struct torture_context *tctx,
			      uint32_t negotiate_flags,
			      struct cli_credentials *machine_credentials,
			      const char *computer_name,
			      enum netr_SchannelType sec_chan_type,
			      NTSTATUS expected_result,
			      struct netlogon_creds_CredentialState **creds_out);
bool test_SetupCredentials2(struct dcerpc_pipe *p, struct torture_context *tctx,
			    uint32_t negotiate_flags,
			    struct cli_credentials *machine_credentials,
			    enum netr_SchannelType sec_chan_type,
			    struct netlogon_creds_CredentialState **creds_out);
bool test_SetupCredentials3(struct dcerpc_pipe *p, struct torture_context *tctx,
			    uint32_t negotiate_flags,
			    struct cli_credentials *machine_credentials,
			    struct netlogon_creds_CredentialState **creds_out);
bool test_SetupCredentialsDowngrade(struct torture_context *tctx,
					struct dcerpc_pipe *p,
					struct cli_credentials *machine_credentials);
bool test_SetupCredentialsPipe(const struct dcerpc_pipe *p1,
			       struct torture_context *tctx,
			       struct cli_credentials *machine_credentials,
			       struct netlogon_creds_CredentialState *creds,
			       uint32_t additional_flags,
			       struct dcerpc_pipe **_p2);
bool test_netlogon_ops(struct dcerpc_pipe *p, struct torture_context *tctx,
		       struct cli_credentials *credentials,
		       struct netlogon_creds_CredentialState *creds);
bool test_netlogon_capabilities(struct dcerpc_pipe *p, struct torture_context *tctx,
				struct cli_credentials *credentials,
				uint32_t requested_flags,
				struct netlogon_creds_CredentialState *creds);
struct torture_suite *torture_rpc_netlogon(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_netlogon_s3(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_netlogon_zerologon(TALLOC_CTX *mem_ctx);
struct torture_suite *torture_rpc_netlogon_admin(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/netlogon_crypto.c  */

struct torture_suite *torture_rpc_netlogon_crypto_fips(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/remote_pac.c  */

struct torture_suite *torture_rpc_remote_pac(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/samlogon.c  */

bool test_InteractiveLogon(struct dcerpc_pipe *p, TALLOC_CTX *mem_ctx,
			   struct torture_context *tctx,
			   struct netlogon_creds_CredentialState *creds,
			   const char *comment,
			   const char *workstation_name,
			   const char *account_domain, const char *account_name,
			   const char *plain_pass, uint32_t parameter_control,
			   NTSTATUS expected_error);
bool torture_rpc_samlogon(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/samsync.c  */

bool torture_rpc_samsync(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/dssetup.c  */

bool test_DsRoleGetPrimaryDomainInformation_ext(struct torture_context *tctx, 
						struct dcerpc_pipe *p,
						NTSTATUS ext_status);
bool test_DsRoleGetPrimaryDomainInformation(struct torture_context *tctx, 
					    struct dcerpc_pipe *p);
struct torture_suite *torture_rpc_dssetup(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/alter_context.c  */

bool torture_rpc_alter_context(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/bench.c  */


/**************************/
bool torture_bench_rpc(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/samba3rpc.c  */

bool torture_bind_authcontext(struct torture_context *torture);
bool try_tcon(struct torture_context *tctx,
	      TALLOC_CTX *mem_ctx,
	      struct security_descriptor *orig_sd,
	      struct smbcli_session *session,
	      const char *sharename, const struct dom_sid *user_sid,
	      unsigned int access_mask, NTSTATUS expected_tcon,
	      NTSTATUS expected_mkdir);
bool torture_samba3_getaliasmembership_0(struct torture_context *torture);

/**
 * Test behaviour of a waiting read call on a pipe when
 * the user logs off
 * - open a pipe via smb2
 * - trigger a read which hangs since there is nothing to read
 * - do a logoff
 * - wait for the read to return and check the status
 *   (STATUS_PIPE_BROKEN)
 */
struct torture_suite *torture_rpc_samba3(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/rpc.c  */


/**
 * Obtain the DCE/RPC binding context associated with a torture context.
 *
 * @param tctx Torture context
 * @param binding Pointer to store DCE/RPC binding
 */
NTSTATUS torture_rpc_binding(struct torture_context *tctx,
			     struct dcerpc_binding **binding);

/**
 * open a rpc connection to a specific transport
 */
NTSTATUS torture_rpc_connection_transport(struct torture_context *tctx,
					  struct dcerpc_pipe **p,
					  const struct ndr_interface_table *table,
					  enum dcerpc_transport_t transport,
					  uint32_t assoc_group_id,
					  uint32_t extra_flags);
NTSTATUS torture_rpc_init(TALLOC_CTX *ctx);

/* The following definitions come from ../../source4/torture/rpc/async_bind.c  */

bool torture_async_bind(struct torture_context *torture);

/* The following definitions come from ../../source4/torture/rpc/handles.c  */

struct torture_suite *torture_rpc_handles(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/frsapi.c  */

struct torture_suite *torture_rpc_frsapi(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/object_uuid.c  */

struct torture_suite *torture_rpc_object_uuid(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/ntsvcs.c  */

struct torture_suite *torture_rpc_ntsvcs(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/browser.c  */

bool test_BrowserrQueryOtherDomains(struct torture_context *tctx,
				    struct dcerpc_pipe *p);
struct torture_suite *torture_rpc_browser(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/bind.c  */


/**
 * Verifies a handle created in a connection is available on
 * a second connection when the same association group is
 * requested in the bind operation. The LSA interface can't be
 * used because it runs in preforking mode in the selftests.
 * Association groups should work when binding to interfaces
 * running in the same process.
 */
struct torture_suite *torture_rpc_bind(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/fsrvp.c  */

struct torture_suite *torture_rpc_fsrvp(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/clusapi.c  */

bool test_OpenResource_int(struct torture_context *tctx,
			   struct dcerpc_pipe *p,
			   const char *lpszResourceName,
			   struct policy_handle *hResource);
bool test_CloseResource_int(struct torture_context *tctx,
			    struct dcerpc_pipe *p,
			    struct policy_handle *hResource);
bool test_OnlineResource_int(struct torture_context *tctx,
			     struct dcerpc_pipe *p,
			     struct policy_handle *hResource);
bool test_OfflineResource_int(struct torture_context *tctx,
			      struct dcerpc_pipe *p,
			      struct policy_handle *hResource);
void torture_tcase_cluster(struct torture_tcase *tcase);
void torture_tcase_resource(struct torture_tcase *tcase);
void torture_tcase_resourcetype(struct torture_tcase *tcase);
void torture_tcase_node(struct torture_tcase *tcase);
void torture_tcase_group(struct torture_tcase *tcase);
void torture_tcase_network(struct torture_tcase *tcase);
void torture_tcase_netinterface(struct torture_tcase *tcase);
void torture_tcase_registry(struct torture_tcase *tcase);
void torture_tcase_groupset(struct torture_tcase *tcase);
struct torture_suite *torture_rpc_clusapi(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/witness.c  */

struct torture_suite *torture_rpc_witness(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/iremotewinspool.c  */

struct torture_suite *torture_rpc_iremotewinspool(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/iremotewinspool_driver.c  */

struct torture_suite *torture_rpc_iremotewinspool_drv(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/mdssvc.c  */

struct torture_suite *torture_rpc_mdssvc(TALLOC_CTX *mem_ctx);

/* The following definitions come from ../../source4/torture/rpc/backupkey.c  */

struct torture_suite *torture_rpc_backupkey(TALLOC_CTX *mem_ctx);
#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_TORTURE_RPC_PROTO_H__ */

