// ui/accessibility/mojom/ax_event.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_event.mojom-features.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"  // IWYU pragma: export
#include "ui/accessibility/mojom/ax_event.mojom-forward.h"  // IWYU pragma: export
#include "ui/accessibility/ax_enums.mojom-forward.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom.h"
#include <string>
#include <vector>




#include "ui/accessibility/mojom/ax_event_mojom_traits.h"




namespace ax::mojom {








class  AXEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AXEvent, T>::value>;
  using DataView = AXEventDataView;
  using Data_ = internal::AXEvent_Data;

  template <typename... Args>
  static AXEventPtr New(Args&&... args) {
    return AXEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AXEventPtr From(const U& u) {
    return mojo::TypeConverter<AXEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AXEvent>::Convert(*this);
  }


  AXEvent();

  AXEvent(
      ::ax::mojom::Event event_type,
      int32_t id,
      ::ax::mojom::EventFrom event_from,
      ::ax::mojom::Action event_from_action,
      std::vector<::ax::mojom::EventIntentPtr> event_intents,
      int32_t action_request_id);

AXEvent(const AXEvent&) = delete;
AXEvent& operator=(const AXEvent&) = delete;

  ~AXEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AXEventPtr>
  AXEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AXEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AXEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AXEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AXEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AXEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AXEvent_UnserializedMessageContext<
            UserType, AXEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AXEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AXEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AXEvent_UnserializedMessageContext<
            UserType, AXEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AXEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::ax::mojom::Event event_type;
  
  int32_t id;
  
  ::ax::mojom::EventFrom event_from;
  
  ::ax::mojom::Action event_from_action;
  
  std::vector<::ax::mojom::EventIntentPtr> event_intents;
  
  int32_t action_request_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AXEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AXEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AXEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AXEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AXEventPtr AXEvent::Clone() const {
  return New(
      mojo::Clone(event_type),
      mojo::Clone(id),
      mojo::Clone(event_from),
      mojo::Clone(event_from_action),
      mojo::Clone(event_intents),
      mojo::Clone(action_request_id)
  );
}

template <typename T, AXEvent::EnableIfSame<T>*>
bool AXEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->event_type, other_struct.event_type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->event_from, other_struct.event_from))
    return false;
  if (!mojo::Equals(this->event_from_action, other_struct.event_from_action))
    return false;
  if (!mojo::Equals(this->event_intents, other_struct.event_intents))
    return false;
  if (!mojo::Equals(this->action_request_id, other_struct.action_request_id))
    return false;
  return true;
}

template <typename T, AXEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.event_type < rhs.event_type)
    return true;
  if (rhs.event_type < lhs.event_type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.event_from < rhs.event_from)
    return true;
  if (rhs.event_from < lhs.event_from)
    return false;
  if (lhs.event_from_action < rhs.event_from_action)
    return true;
  if (rhs.event_from_action < lhs.event_from_action)
    return false;
  if (lhs.event_intents < rhs.event_intents)
    return true;
  if (rhs.event_intents < lhs.event_intents)
    return false;
  if (lhs.action_request_id < rhs.action_request_id)
    return true;
  if (rhs.action_request_id < lhs.action_request_id)
    return false;
  return false;
}


}  // ax::mojom

namespace mojo {


template <>
struct  StructTraits<::ax::mojom::AXEvent::DataView,
                                         ::ax::mojom::AXEventPtr> {
  static bool IsNull(const ::ax::mojom::AXEventPtr& input) { return !input; }
  static void SetToNull(::ax::mojom::AXEventPtr* output) { output->reset(); }

  static decltype(::ax::mojom::AXEvent::event_type) event_type(
      const ::ax::mojom::AXEventPtr& input) {
    return input->event_type;
  }

  static decltype(::ax::mojom::AXEvent::id) id(
      const ::ax::mojom::AXEventPtr& input) {
    return input->id;
  }

  static decltype(::ax::mojom::AXEvent::event_from) event_from(
      const ::ax::mojom::AXEventPtr& input) {
    return input->event_from;
  }

  static decltype(::ax::mojom::AXEvent::event_from_action) event_from_action(
      const ::ax::mojom::AXEventPtr& input) {
    return input->event_from_action;
  }

  static const decltype(::ax::mojom::AXEvent::event_intents)& event_intents(
      const ::ax::mojom::AXEventPtr& input) {
    return input->event_intents;
  }

  static decltype(::ax::mojom::AXEvent::action_request_id) action_request_id(
      const ::ax::mojom::AXEventPtr& input) {
    return input->action_request_id;
  }

  static bool Read(::ax::mojom::AXEvent::DataView input, ::ax::mojom::AXEventPtr* output);
};

}  // namespace mojo

#endif  // UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_H_