// third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_WORKLET_SERVICE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_WORKLET_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/shared_storage/shared_storage_worklet_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "services/network/public/mojom/shared_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/shared_storage/shared_storage.mojom-shared.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-shared.h"
#include "third_party/blink/public/mojom/interest_group/interest_group_types.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class SharedStorageWorkletPermissionsPolicyStateDataView;

class SharedStorageKeyAndOrValueDataView;

class PrivateAggregationOperationDetailsDataView;

class GetInterestGroupsResultDataView;


}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::SharedStorageWorkletPermissionsPolicyStateDataView> {
  using Data = ::blink::mojom::internal::SharedStorageWorkletPermissionsPolicyState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::SharedStorageKeyAndOrValueDataView> {
  using Data = ::blink::mojom::internal::SharedStorageKeyAndOrValue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PrivateAggregationOperationDetailsDataView> {
  using Data = ::blink::mojom::internal::PrivateAggregationOperationDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::GetInterestGroupsResultDataView> {
  using Data = ::blink::mojom::internal::GetInterestGroupsResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class SharedStorageEntriesListenerInterfaceBase {};

using SharedStorageEntriesListenerPtrDataView =
    mojo::InterfacePtrDataView<SharedStorageEntriesListenerInterfaceBase>;
using SharedStorageEntriesListenerRequestDataView =
    mojo::InterfaceRequestDataView<SharedStorageEntriesListenerInterfaceBase>;
using SharedStorageEntriesListenerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedStorageEntriesListenerInterfaceBase>;
using SharedStorageEntriesListenerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedStorageEntriesListenerInterfaceBase>;
class SharedStorageWorkletServiceClientInterfaceBase {};

using SharedStorageWorkletServiceClientPtrDataView =
    mojo::InterfacePtrDataView<SharedStorageWorkletServiceClientInterfaceBase>;
using SharedStorageWorkletServiceClientRequestDataView =
    mojo::InterfaceRequestDataView<SharedStorageWorkletServiceClientInterfaceBase>;
using SharedStorageWorkletServiceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedStorageWorkletServiceClientInterfaceBase>;
using SharedStorageWorkletServiceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedStorageWorkletServiceClientInterfaceBase>;
class SharedStorageWorkletServiceInterfaceBase {};

using SharedStorageWorkletServicePtrDataView =
    mojo::InterfacePtrDataView<SharedStorageWorkletServiceInterfaceBase>;
using SharedStorageWorkletServiceRequestDataView =
    mojo::InterfaceRequestDataView<SharedStorageWorkletServiceInterfaceBase>;
using SharedStorageWorkletServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SharedStorageWorkletServiceInterfaceBase>;
using SharedStorageWorkletServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SharedStorageWorkletServiceInterfaceBase>;


class SharedStorageWorkletPermissionsPolicyStateDataView {
 public:
  SharedStorageWorkletPermissionsPolicyStateDataView() = default;

  SharedStorageWorkletPermissionsPolicyStateDataView(
      internal::SharedStorageWorkletPermissionsPolicyState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool private_aggregation_allowed() const {
    return data_->private_aggregation_allowed;
  }
  bool join_ad_interest_group_allowed() const {
    return data_->join_ad_interest_group_allowed;
  }
  bool run_ad_auction_allowed() const {
    return data_->run_ad_auction_allowed;
  }
 private:
  internal::SharedStorageWorkletPermissionsPolicyState_Data* data_ = nullptr;
};


class SharedStorageKeyAndOrValueDataView {
 public:
  SharedStorageKeyAndOrValueDataView() = default;

  SharedStorageKeyAndOrValueDataView(
      internal::SharedStorageKeyAndOrValue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetKeyDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
  inline void GetValueDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::SharedStorageKeyAndOrValue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrivateAggregationOperationDetailsDataView {
 public:
  PrivateAggregationOperationDetailsDataView() = default;

  PrivateAggregationOperationDetailsDataView(
      internal::PrivateAggregationOperationDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakePaHost() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::PrivateAggregationHostInterfaceBase>>(
            &data_->pa_host, &result, message_);
    DCHECK(ret);
    return result;
  }
  uint32_t filtering_id_max_bytes() const {
    return data_->filtering_id_max_bytes;
  }
 private:
  internal::PrivateAggregationOperationDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GetInterestGroupsResultDataView {
 public:
  using Tag = internal::GetInterestGroupsResult_Data::GetInterestGroupsResult_Tag;

  GetInterestGroupsResultDataView() = default;

  GetInterestGroupsResultDataView(
      internal::GetInterestGroupsResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error_message() const { return data_->tag == Tag::kErrorMessage; }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) const {
    
    CHECK(is_error_message());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_error_message.Get(), output, message_);
  }
  bool is_groups() const { return data_->tag == Tag::kGroups; }
  inline void GetGroupsDataView(
      mojo::ArrayDataView<::blink::mojom::StorageInterestGroupDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadGroups(UserType* output) const {
    
    CHECK(is_groups());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::StorageInterestGroupDataView>>(
        data_->data.f_groups.Get(), output, message_);
  }

 private:
  internal::GetInterestGroupsResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageWorkletPermissionsPolicyStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedStorageWorkletPermissionsPolicyStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedStorageWorkletPermissionsPolicyState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->private_aggregation_allowed = Traits::private_aggregation_allowed(input);
    fragment->join_ad_interest_group_allowed = Traits::join_ad_interest_group_allowed(input);
    fragment->run_ad_auction_allowed = Traits::run_ad_auction_allowed(input);
  }

  static bool Deserialize(::blink::mojom::internal::SharedStorageWorkletPermissionsPolicyState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedStorageWorkletPermissionsPolicyStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::SharedStorageKeyAndOrValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::SharedStorageKeyAndOrValueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::SharedStorageKeyAndOrValue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_key, key_fragment);
    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in SharedStorageKeyAndOrValue struct");
    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
        in_value, value_fragment);
    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->value.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in SharedStorageKeyAndOrValue struct");
  }

  static bool Deserialize(::blink::mojom::internal::SharedStorageKeyAndOrValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::SharedStorageKeyAndOrValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrivateAggregationOperationDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrivateAggregationOperationDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PrivateAggregationOperationDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::pa_host(input)) in_pa_host = Traits::pa_host(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PrivateAggregationHostInterfaceBase>>(
        in_pa_host, &fragment->pa_host, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->pa_host),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid pa_host in PrivateAggregationOperationDetails struct");
    fragment->filtering_id_max_bytes = Traits::filtering_id_max_bytes(input);
  }

  static bool Deserialize(::blink::mojom::internal::PrivateAggregationOperationDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PrivateAggregationOperationDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::GetInterestGroupsResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::GetInterestGroupsResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::GetInterestGroupsResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::blink::mojom::GetInterestGroupsResultDataView::Tag::kErrorMessage: {
        decltype(Traits::error_message(input))
            in_error_message = Traits::error_message(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_error_message)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<mojo::StringDataView>(
            in_error_message, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null error_message in GetInterestGroupsResult union");
        fragment->data.f_error_message.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::blink::mojom::GetInterestGroupsResultDataView::Tag::kGroups: {
        decltype(Traits::groups(input))
            in_groups = Traits::groups(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_groups)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StorageInterestGroupDataView>>(
            in_groups, value_fragment, &groups_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null groups in GetInterestGroupsResult union");
        fragment->data.f_groups.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
    }
  }

  static bool Deserialize(::blink::mojom::internal::GetInterestGroupsResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::GetInterestGroupsResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void SharedStorageKeyAndOrValueDataView::GetKeyDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->key.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void SharedStorageKeyAndOrValueDataView::GetValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}




inline void GetInterestGroupsResultDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error_message());
  *output = mojo::StringDataView(data_->data.f_error_message.Get(), message_);
}
inline void GetInterestGroupsResultDataView::GetGroupsDataView(
    mojo::ArrayDataView<::blink::mojom::StorageInterestGroupDataView>* output) const {
  CHECK(is_groups());
  *output = mojo::ArrayDataView<::blink::mojom::StorageInterestGroupDataView>(data_->data.f_groups.Get(), message_);
}


}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SHARED_STORAGE_SHARED_STORAGE_WORKLET_SERVICE_MOJOM_SHARED_H_