// services/video_effects/public/mojom/video_effects_processor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/video_effects/public/mojom/video_effects_processor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/video_effects/public/mojom/video_effects_processor.mojom-params-data.h"
#include "services/video_effects/public/mojom/video_effects_processor.mojom-shared-message-ids.h"

#include "services/video_effects/public/mojom/video_effects_processor.mojom-import-headers.h"
#include "services/video_effects/public/mojom/video_effects_processor.mojom-test-utils.h"


namespace video_effects::mojom {
PostProcessSuccess::PostProcessSuccess()
    : frame_info() {}

PostProcessSuccess::PostProcessSuccess(
    ::media::mojom::VideoFrameInfoPtr frame_info_in)
    : frame_info(std::move(frame_info_in)) {}

PostProcessSuccess::~PostProcessSuccess() = default;

void PostProcessSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "frame_info"), this->frame_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::media::mojom::VideoFrameInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PostProcessSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PostProcessResult::PostProcessResult() : tag_(Tag::kError) {
  data_.error = PostProcessError();
}

PostProcessResult::~PostProcessResult() {
  DestroyActive();
}


void PostProcessResult::set_error(
    PostProcessError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}
void PostProcessResult::set_success(
    PostProcessSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    *(data_.success) = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    data_.success = new PostProcessSuccessPtr(
        std::move(success));
  }
}

void PostProcessResult::DestroyActive() {
  switch (tag_) {

    case Tag::kError:

      break;
    case Tag::kSuccess:

      delete data_.success;
      break;
  }
}

bool PostProcessResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char VideoEffectsProcessor::Name_[] = "video_effects.mojom.VideoEffectsProcessor";

VideoEffectsProcessor::IPCStableHashFunction VideoEffectsProcessor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::VideoEffectsProcessor>(message.name())) {
    case messages::VideoEffectsProcessor::kPostProcess: {
      return &VideoEffectsProcessor::PostProcess_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* VideoEffectsProcessor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::VideoEffectsProcessor>(message.name())) {
      case messages::VideoEffectsProcessor::kPostProcess:
            return "Receive video_effects::mojom::VideoEffectsProcessor::PostProcess";
    }
  } else {
    switch (static_cast<messages::VideoEffectsProcessor>(message.name())) {
      case messages::VideoEffectsProcessor::kPostProcess:
            return "Receive reply video_effects::mojom::VideoEffectsProcessor::PostProcess";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t VideoEffectsProcessor::PostProcess_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)video_effects::mojom::VideoEffectsProcessor::PostProcess");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class VideoEffectsProcessor_PostProcess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  VideoEffectsProcessor_PostProcess_ForwardToCallback(
      VideoEffectsProcessor::PostProcessCallback callback
      ) : callback_(std::move(callback)) {
  }

  VideoEffectsProcessor_PostProcess_ForwardToCallback(const VideoEffectsProcessor_PostProcess_ForwardToCallback&) = delete;
  VideoEffectsProcessor_PostProcess_ForwardToCallback& operator=(const VideoEffectsProcessor_PostProcess_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  VideoEffectsProcessor::PostProcessCallback callback_;
};

VideoEffectsProcessorProxy::VideoEffectsProcessorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void VideoEffectsProcessorProxy::PostProcess(
    ::media::mojom::VideoBufferHandlePtr in_input_frame_data, ::media::mojom::VideoFrameInfoPtr in_input_frame_info, ::media::mojom::VideoBufferHandlePtr in_result_frame_data, ::media::VideoPixelFormat in_result_pixel_format, PostProcessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send video_effects::mojom::VideoEffectsProcessor::PostProcess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_frame_data"), in_input_frame_data,
                        "<value of type ::media::mojom::VideoBufferHandlePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("input_frame_info"), in_input_frame_info,
                        "<value of type ::media::mojom::VideoFrameInfoPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_frame_data"), in_result_frame_data,
                        "<value of type ::media::mojom::VideoBufferHandlePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_pixel_format"), in_result_pixel_format,
                        "<value of type ::media::VideoPixelFormat>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEffectsProcessor::kPostProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_effects::mojom::internal::VideoEffectsProcessor_PostProcess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->input_frame_data)>
      input_frame_data_fragment(params.message());
  input_frame_data_fragment.Claim(&params->input_frame_data);
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
      in_input_frame_data, input_frame_data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input_frame_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_frame_data in VideoEffectsProcessor.PostProcess request");
  mojo::internal::MessageFragment<
      typename decltype(params->input_frame_info)::BaseType> input_frame_info_fragment(
          params.message());
  mojo::internal::Serialize<::media::mojom::VideoFrameInfoDataView>(
      in_input_frame_info, input_frame_info_fragment);
  params->input_frame_info.Set(
      input_frame_info_fragment.is_null() ? nullptr : input_frame_info_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input_frame_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_frame_info in VideoEffectsProcessor.PostProcess request");
  mojo::internal::MessageFragment<decltype(params->result_frame_data)>
      result_frame_data_fragment(params.message());
  result_frame_data_fragment.Claim(&params->result_frame_data);
  mojo::internal::Serialize<::media::mojom::VideoBufferHandleDataView>(
      in_result_frame_data, result_frame_data_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result_frame_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result_frame_data in VideoEffectsProcessor.PostProcess request");
  mojo::internal::Serialize<::media::mojom::VideoPixelFormat>(
      in_result_pixel_format, &params->result_pixel_format);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEffectsProcessor::Name_);
  message.set_method_name("PostProcess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new VideoEffectsProcessor_PostProcess_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class VideoEffectsProcessor_PostProcess_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static VideoEffectsProcessor::PostProcessCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<VideoEffectsProcessor_PostProcess_ProxyToResponder> proxy(
        new VideoEffectsProcessor_PostProcess_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&VideoEffectsProcessor_PostProcess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~VideoEffectsProcessor_PostProcess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  VideoEffectsProcessor_PostProcess_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "VideoEffectsProcessor::PostProcessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PostProcessResultPtr in_result);
};

bool VideoEffectsProcessor_PostProcess_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::VideoEffectsProcessor_PostProcess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::VideoEffectsProcessor_PostProcess_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for VideoEffectsProcessor.0
  bool success = true;
  PostProcessResultPtr p_result{};
  VideoEffectsProcessor_PostProcess_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        VideoEffectsProcessor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void VideoEffectsProcessor_PostProcess_ProxyToResponder::Run(
    PostProcessResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply video_effects::mojom::VideoEffectsProcessor::PostProcess", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type PostProcessResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::VideoEffectsProcessor::kPostProcess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::video_effects::mojom::internal::VideoEffectsProcessor_PostProcess_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  mojo::internal::Serialize<::video_effects::mojom::PostProcessResultDataView>(
      in_result, result_fragment, true);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(VideoEffectsProcessor::Name_);
  message.set_method_name("PostProcess");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool VideoEffectsProcessorStubDispatch::Accept(
    VideoEffectsProcessor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::VideoEffectsProcessor>(message->header()->name)) {
    case messages::VideoEffectsProcessor::kPostProcess: {
      break;
    }
  }
  return false;
}

// static
bool VideoEffectsProcessorStubDispatch::AcceptWithResponder(
    VideoEffectsProcessor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::VideoEffectsProcessor>(message->header()->name)) {
    case messages::VideoEffectsProcessor::kPostProcess: {
      internal::VideoEffectsProcessor_PostProcess_Params_Data* params =
          reinterpret_cast<
              internal::VideoEffectsProcessor_PostProcess_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for VideoEffectsProcessor.0
      bool success = true;
      ::media::mojom::VideoBufferHandlePtr p_input_frame_data{};
      ::media::mojom::VideoFrameInfoPtr p_input_frame_info{};
      ::media::mojom::VideoBufferHandlePtr p_result_frame_data{};
      ::media::VideoPixelFormat p_result_pixel_format{};
      VideoEffectsProcessor_PostProcess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadInputFrameData(&p_input_frame_data))
        success = false;
      if (success && !input_data_view.ReadInputFrameInfo(&p_input_frame_info))
        success = false;
      if (success && !input_data_view.ReadResultFrameData(&p_result_frame_data))
        success = false;
      if (success && !input_data_view.ReadResultPixelFormat(&p_result_pixel_format))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            VideoEffectsProcessor::Name_, 0, false);
        return false;
      }
      VideoEffectsProcessor::PostProcessCallback callback =
          VideoEffectsProcessor_PostProcess_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PostProcess(        
        std::move(p_input_frame_data), 
        std::move(p_input_frame_info), 
        std::move(p_result_frame_data), 
        std::move(p_result_pixel_format), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kVideoEffectsProcessorValidationInfo[] = {
    {base::to_underlying(messages::VideoEffectsProcessor::kPostProcess),
     { &internal::VideoEffectsProcessor_PostProcess_Params_Data::Validate,
      &internal::VideoEffectsProcessor_PostProcess_ResponseParams_Data::Validate}},
};

bool VideoEffectsProcessorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::video_effects::mojom::VideoEffectsProcessor::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kVideoEffectsProcessorValidationInfo);
}

bool VideoEffectsProcessorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::video_effects::mojom::VideoEffectsProcessor::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kVideoEffectsProcessorValidationInfo);

}


}  // video_effects::mojom


namespace mojo {


// static
bool StructTraits<::video_effects::mojom::PostProcessSuccess::DataView, ::video_effects::mojom::PostProcessSuccessPtr>::Read(
    ::video_effects::mojom::PostProcessSuccess::DataView input,
    ::video_effects::mojom::PostProcessSuccessPtr* output) {
  bool success = true;
  ::video_effects::mojom::PostProcessSuccessPtr result(::video_effects::mojom::PostProcessSuccess::New());
  
      if (success && !input.ReadFrameInfo(&result->frame_info))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::video_effects::mojom::PostProcessResult::DataView, ::video_effects::mojom::PostProcessResultPtr>::Read(
    ::video_effects::mojom::PostProcessResult::DataView input,
    ::video_effects::mojom::PostProcessResultPtr* output) {
  using UnionType = ::video_effects::mojom::PostProcessResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kError: {
      ::video_effects::mojom::PostProcessError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    case Tag::kSuccess: {
      ::video_effects::mojom::PostProcessSuccessPtr result_success;
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace video_effects::mojom {


void VideoEffectsProcessorInterceptorForTesting::PostProcess(::media::mojom::VideoBufferHandlePtr input_frame_data, ::media::mojom::VideoFrameInfoPtr input_frame_info, ::media::mojom::VideoBufferHandlePtr result_frame_data, ::media::VideoPixelFormat result_pixel_format, PostProcessCallback callback) {
  GetForwardingInterface()->PostProcess(
    std::move(input_frame_data)
    , 
    std::move(input_frame_info)
    , 
    std::move(result_frame_data)
    , 
    std::move(result_pixel_format)
    , std::move(callback));
}
VideoEffectsProcessorAsyncWaiter::VideoEffectsProcessorAsyncWaiter(
    VideoEffectsProcessor* proxy) : proxy_(proxy) {}

VideoEffectsProcessorAsyncWaiter::~VideoEffectsProcessorAsyncWaiter() = default;

void VideoEffectsProcessorAsyncWaiter::PostProcess(
    ::media::mojom::VideoBufferHandlePtr input_frame_data, ::media::mojom::VideoFrameInfoPtr input_frame_info, ::media::mojom::VideoBufferHandlePtr result_frame_data, ::media::VideoPixelFormat result_pixel_format, PostProcessResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->PostProcess(
      std::move(input_frame_data),
      std::move(input_frame_info),
      std::move(result_frame_data),
      std::move(result_pixel_format),
      base::BindOnce(
          [](base::RunLoop* loop,
             PostProcessResultPtr* out_result
,
             PostProcessResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

PostProcessResultPtr VideoEffectsProcessorAsyncWaiter::PostProcess(
    ::media::mojom::VideoBufferHandlePtr input_frame_data, ::media::mojom::VideoFrameInfoPtr input_frame_info, ::media::mojom::VideoBufferHandlePtr result_frame_data, ::media::VideoPixelFormat result_pixel_format) {
  PostProcessResultPtr async_wait_result;
  PostProcess(std::move(input_frame_data),std::move(input_frame_info),std::move(result_frame_data),std::move(result_pixel_format),&async_wait_result);
  return async_wait_result;
}






}  // video_effects::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif