// services/device/public/mojom/usb_enumeration_options.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/usb_enumeration_options.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_enumeration_options.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/usb_enumeration_options.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include <string>
#include <vector>








namespace device::mojom {









class  UsbDeviceFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbDeviceFilter, T>::value>;
  using DataView = UsbDeviceFilterDataView;
  using Data_ = internal::UsbDeviceFilter_Data;

  template <typename... Args>
  static UsbDeviceFilterPtr New(Args&&... args) {
    return UsbDeviceFilterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbDeviceFilterPtr From(const U& u) {
    return mojo::TypeConverter<UsbDeviceFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbDeviceFilter>::Convert(*this);
  }


  UsbDeviceFilter();

  UsbDeviceFilter(
      bool has_vendor_id,
      uint16_t vendor_id,
      bool has_product_id,
      uint16_t product_id,
      bool has_class_code,
      uint8_t class_code,
      bool has_subclass_code,
      uint8_t subclass_code,
      bool has_protocol_code,
      uint8_t protocol_code,
      const std::optional<::std::u16string>& serial_number);


  ~UsbDeviceFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbDeviceFilterPtr>
  UsbDeviceFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbDeviceFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbDeviceFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbDeviceFilter_UnserializedMessageContext<
            UserType, UsbDeviceFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbDeviceFilter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbDeviceFilter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbDeviceFilter_UnserializedMessageContext<
            UserType, UsbDeviceFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbDeviceFilter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_vendor_id;
  
  uint16_t vendor_id;
  
  bool has_product_id;
  
  uint16_t product_id;
  
  bool has_class_code;
  
  uint8_t class_code;
  
  bool has_subclass_code;
  
  uint8_t subclass_code;
  
  bool has_protocol_code;
  
  uint8_t protocol_code;
  
  std::optional<::std::u16string> serial_number;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UsbEnumerationOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UsbEnumerationOptions, T>::value>;
  using DataView = UsbEnumerationOptionsDataView;
  using Data_ = internal::UsbEnumerationOptions_Data;

  template <typename... Args>
  static UsbEnumerationOptionsPtr New(Args&&... args) {
    return UsbEnumerationOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UsbEnumerationOptionsPtr From(const U& u) {
    return mojo::TypeConverter<UsbEnumerationOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UsbEnumerationOptions>::Convert(*this);
  }


  UsbEnumerationOptions();

  explicit UsbEnumerationOptions(
      std::vector<UsbDeviceFilterPtr> filters);

UsbEnumerationOptions(const UsbEnumerationOptions&) = delete;
UsbEnumerationOptions& operator=(const UsbEnumerationOptions&) = delete;

  ~UsbEnumerationOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UsbEnumerationOptionsPtr>
  UsbEnumerationOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UsbEnumerationOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UsbEnumerationOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UsbEnumerationOptions_UnserializedMessageContext<
            UserType, UsbEnumerationOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UsbEnumerationOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UsbEnumerationOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UsbEnumerationOptions_UnserializedMessageContext<
            UserType, UsbEnumerationOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UsbEnumerationOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<UsbDeviceFilterPtr> filters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
UsbDeviceFilterPtr UsbDeviceFilter::Clone() const {
  return New(
      mojo::Clone(has_vendor_id),
      mojo::Clone(vendor_id),
      mojo::Clone(has_product_id),
      mojo::Clone(product_id),
      mojo::Clone(has_class_code),
      mojo::Clone(class_code),
      mojo::Clone(has_subclass_code),
      mojo::Clone(subclass_code),
      mojo::Clone(has_protocol_code),
      mojo::Clone(protocol_code),
      mojo::Clone(serial_number)
  );
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>*>
bool UsbDeviceFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_vendor_id, other_struct.has_vendor_id))
    return false;
  if (!mojo::Equals(this->vendor_id, other_struct.vendor_id))
    return false;
  if (!mojo::Equals(this->has_product_id, other_struct.has_product_id))
    return false;
  if (!mojo::Equals(this->product_id, other_struct.product_id))
    return false;
  if (!mojo::Equals(this->has_class_code, other_struct.has_class_code))
    return false;
  if (!mojo::Equals(this->class_code, other_struct.class_code))
    return false;
  if (!mojo::Equals(this->has_subclass_code, other_struct.has_subclass_code))
    return false;
  if (!mojo::Equals(this->subclass_code, other_struct.subclass_code))
    return false;
  if (!mojo::Equals(this->has_protocol_code, other_struct.has_protocol_code))
    return false;
  if (!mojo::Equals(this->protocol_code, other_struct.protocol_code))
    return false;
  if (!mojo::Equals(this->serial_number, other_struct.serial_number))
    return false;
  return true;
}

template <typename T, UsbDeviceFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_vendor_id < rhs.has_vendor_id)
    return true;
  if (rhs.has_vendor_id < lhs.has_vendor_id)
    return false;
  if (lhs.vendor_id < rhs.vendor_id)
    return true;
  if (rhs.vendor_id < lhs.vendor_id)
    return false;
  if (lhs.has_product_id < rhs.has_product_id)
    return true;
  if (rhs.has_product_id < lhs.has_product_id)
    return false;
  if (lhs.product_id < rhs.product_id)
    return true;
  if (rhs.product_id < lhs.product_id)
    return false;
  if (lhs.has_class_code < rhs.has_class_code)
    return true;
  if (rhs.has_class_code < lhs.has_class_code)
    return false;
  if (lhs.class_code < rhs.class_code)
    return true;
  if (rhs.class_code < lhs.class_code)
    return false;
  if (lhs.has_subclass_code < rhs.has_subclass_code)
    return true;
  if (rhs.has_subclass_code < lhs.has_subclass_code)
    return false;
  if (lhs.subclass_code < rhs.subclass_code)
    return true;
  if (rhs.subclass_code < lhs.subclass_code)
    return false;
  if (lhs.has_protocol_code < rhs.has_protocol_code)
    return true;
  if (rhs.has_protocol_code < lhs.has_protocol_code)
    return false;
  if (lhs.protocol_code < rhs.protocol_code)
    return true;
  if (rhs.protocol_code < lhs.protocol_code)
    return false;
  if (lhs.serial_number < rhs.serial_number)
    return true;
  if (rhs.serial_number < lhs.serial_number)
    return false;
  return false;
}
template <typename StructPtrType>
UsbEnumerationOptionsPtr UsbEnumerationOptions::Clone() const {
  return New(
      mojo::Clone(filters)
  );
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>*>
bool UsbEnumerationOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->filters, other_struct.filters))
    return false;
  return true;
}

template <typename T, UsbEnumerationOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.filters < rhs.filters)
    return true;
  if (rhs.filters < lhs.filters)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct  StructTraits<::device::mojom::UsbDeviceFilter::DataView,
                                         ::device::mojom::UsbDeviceFilterPtr> {
  static bool IsNull(const ::device::mojom::UsbDeviceFilterPtr& input) { return !input; }
  static void SetToNull(::device::mojom::UsbDeviceFilterPtr* output) { output->reset(); }

  static decltype(::device::mojom::UsbDeviceFilter::has_vendor_id) has_vendor_id(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->has_vendor_id;
  }

  static decltype(::device::mojom::UsbDeviceFilter::vendor_id) vendor_id(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->vendor_id;
  }

  static decltype(::device::mojom::UsbDeviceFilter::has_product_id) has_product_id(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->has_product_id;
  }

  static decltype(::device::mojom::UsbDeviceFilter::product_id) product_id(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->product_id;
  }

  static decltype(::device::mojom::UsbDeviceFilter::has_class_code) has_class_code(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->has_class_code;
  }

  static decltype(::device::mojom::UsbDeviceFilter::class_code) class_code(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->class_code;
  }

  static decltype(::device::mojom::UsbDeviceFilter::has_subclass_code) has_subclass_code(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->has_subclass_code;
  }

  static decltype(::device::mojom::UsbDeviceFilter::subclass_code) subclass_code(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->subclass_code;
  }

  static decltype(::device::mojom::UsbDeviceFilter::has_protocol_code) has_protocol_code(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->has_protocol_code;
  }

  static decltype(::device::mojom::UsbDeviceFilter::protocol_code) protocol_code(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->protocol_code;
  }

  static const decltype(::device::mojom::UsbDeviceFilter::serial_number)& serial_number(
      const ::device::mojom::UsbDeviceFilterPtr& input) {
    return input->serial_number;
  }

  static bool Read(::device::mojom::UsbDeviceFilter::DataView input, ::device::mojom::UsbDeviceFilterPtr* output);
};


template <>
struct  StructTraits<::device::mojom::UsbEnumerationOptions::DataView,
                                         ::device::mojom::UsbEnumerationOptionsPtr> {
  static bool IsNull(const ::device::mojom::UsbEnumerationOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::UsbEnumerationOptionsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::UsbEnumerationOptions::filters)& filters(
      const ::device::mojom::UsbEnumerationOptionsPtr& input) {
    return input->filters;
  }

  static bool Read(::device::mojom::UsbEnumerationOptions::DataView input, ::device::mojom::UsbEnumerationOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_H_