// services/device/public/mojom/smart_card.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/smart_card.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace device::mojom {
class SmartCardReaderStateFlagsDataView;

class SmartCardReaderStateInDataView;

class SmartCardReaderStateOutDataView;

class SmartCardProtocolsDataView;

class SmartCardStatusDataView;

class SmartCardConnectSuccessDataView;

class SmartCardResultDataView;
class SmartCardStatusChangeResultDataView;
class SmartCardListReadersResultDataView;
class SmartCardCreateContextResultDataView;
class SmartCardConnectResultDataView;
class SmartCardDataResultDataView;
class SmartCardStatusResultDataView;
class SmartCardTransactionResultDataView;


}  // device::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::SmartCardReaderStateFlagsDataView> {
  using Data = ::device::mojom::internal::SmartCardReaderStateFlags_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardReaderStateInDataView> {
  using Data = ::device::mojom::internal::SmartCardReaderStateIn_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardReaderStateOutDataView> {
  using Data = ::device::mojom::internal::SmartCardReaderStateOut_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardProtocolsDataView> {
  using Data = ::device::mojom::internal::SmartCardProtocols_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardStatusDataView> {
  using Data = ::device::mojom::internal::SmartCardStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardConnectSuccessDataView> {
  using Data = ::device::mojom::internal::SmartCardConnectSuccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardResultDataView> {
  using Data = ::device::mojom::internal::SmartCardResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardStatusChangeResultDataView> {
  using Data = ::device::mojom::internal::SmartCardStatusChangeResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardListReadersResultDataView> {
  using Data = ::device::mojom::internal::SmartCardListReadersResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardCreateContextResultDataView> {
  using Data = ::device::mojom::internal::SmartCardCreateContextResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardConnectResultDataView> {
  using Data = ::device::mojom::internal::SmartCardConnectResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardDataResultDataView> {
  using Data = ::device::mojom::internal::SmartCardDataResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardStatusResultDataView> {
  using Data = ::device::mojom::internal::SmartCardStatusResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::device::mojom::SmartCardTransactionResultDataView> {
  using Data = ::device::mojom::internal::SmartCardTransactionResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class SmartCardSuccess : int32_t {
  
  kOk = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, SmartCardSuccess value);
inline bool IsKnownEnumValue(SmartCardSuccess value) {
  return internal::SmartCardSuccess_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardError : int32_t {
  
  kRemovedCard = 0,
  
  kResetCard = 1,
  
  kUnpoweredCard = 2,
  
  kUnresponsiveCard = 3,
  
  kUnsupportedCard = 4,
  
  kReaderUnavailable = 5,
  
  kSharingViolation = 6,
  
  kNotTransacted = 7,
  
  kNoSmartcard = 8,
  
  kProtoMismatch = 9,
  
  kSystemCancelled = 10,
  
  kNotReady = 11,
  
  kCancelled = 12,
  
  kInsufficientBuffer = 13,
  
  kInvalidHandle = 14,
  
  kInvalidParameter = 15,
  
  kInvalidValue = 16,
  
  kNoMemory = 17,
  
  kTimeout = 18,
  
  kUnknownReader = 19,
  
  kUnsupportedFeature = 20,
  
  kNoReadersAvailable = 21,
  
  kServiceStopped = 22,
  
  kNoService = 23,
  
  kCommError = 24,
  
  kInternalError = 25,
  
  kUnknownError = 26,
  
  kServerTooBusy = 27,
  
  kUnexpected = 28,
  
  kShutdown = 29,
  
  kUnknown = 30,
  
  kPermissionDenied = 31,
  kMinValue = 0,
  kMaxValue = 31,
};

 std::ostream& operator<<(std::ostream& os, SmartCardError value);
inline bool IsKnownEnumValue(SmartCardError value) {
  return internal::SmartCardError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardShareMode : int32_t {
  
  kShared = 0,
  
  kExclusive = 1,
  
  kDirect = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SmartCardShareMode value);
inline bool IsKnownEnumValue(SmartCardShareMode value) {
  return internal::SmartCardShareMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardProtocol : int32_t {
  
  kUndefined = 0,
  
  kT0 = 1,
  
  kT1 = 2,
  
  kRaw = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SmartCardProtocol value);
inline bool IsKnownEnumValue(SmartCardProtocol value) {
  return internal::SmartCardProtocol_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardDisposition : int32_t {
  
  kLeave = 0,
  
  kReset = 1,
  
  kUnpower = 2,
  
  kEject = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SmartCardDisposition value);
inline bool IsKnownEnumValue(SmartCardDisposition value) {
  return internal::SmartCardDisposition_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SmartCardConnectionState : int32_t {
  
  kAbsent = 0,
  
  kPresent = 1,
  
  kSwallowed = 2,
  
  kPowered = 3,
  
  kNegotiable = 4,
  
  kSpecific = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, SmartCardConnectionState value);
inline bool IsKnownEnumValue(SmartCardConnectionState value) {
  return internal::SmartCardConnectionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SmartCardTransactionInterfaceBase {};

using SmartCardTransactionPtrDataView =
    mojo::InterfacePtrDataView<SmartCardTransactionInterfaceBase>;
using SmartCardTransactionRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardTransactionInterfaceBase>;
using SmartCardTransactionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardTransactionInterfaceBase>;
using SmartCardTransactionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardTransactionInterfaceBase>;
class SmartCardConnectionInterfaceBase {};

using SmartCardConnectionPtrDataView =
    mojo::InterfacePtrDataView<SmartCardConnectionInterfaceBase>;
using SmartCardConnectionRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardConnectionInterfaceBase>;
using SmartCardConnectionAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardConnectionInterfaceBase>;
using SmartCardConnectionAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardConnectionInterfaceBase>;
class SmartCardContextInterfaceBase {};

using SmartCardContextPtrDataView =
    mojo::InterfacePtrDataView<SmartCardContextInterfaceBase>;
using SmartCardContextRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardContextInterfaceBase>;
using SmartCardContextAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardContextInterfaceBase>;
using SmartCardContextAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardContextInterfaceBase>;
class SmartCardContextFactoryInterfaceBase {};

using SmartCardContextFactoryPtrDataView =
    mojo::InterfacePtrDataView<SmartCardContextFactoryInterfaceBase>;
using SmartCardContextFactoryRequestDataView =
    mojo::InterfaceRequestDataView<SmartCardContextFactoryInterfaceBase>;
using SmartCardContextFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SmartCardContextFactoryInterfaceBase>;
using SmartCardContextFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SmartCardContextFactoryInterfaceBase>;


class SmartCardReaderStateFlagsDataView {
 public:
  SmartCardReaderStateFlagsDataView() = default;

  SmartCardReaderStateFlagsDataView(
      internal::SmartCardReaderStateFlags_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool unaware() const {
    return data_->unaware;
  }
  bool ignore() const {
    return data_->ignore;
  }
  bool changed() const {
    return data_->changed;
  }
  bool unknown() const {
    return data_->unknown;
  }
  bool unavailable() const {
    return data_->unavailable;
  }
  bool empty() const {
    return data_->empty;
  }
  bool present() const {
    return data_->present;
  }
  bool exclusive() const {
    return data_->exclusive;
  }
  bool inuse() const {
    return data_->inuse;
  }
  bool mute() const {
    return data_->mute;
  }
  bool unpowered() const {
    return data_->unpowered;
  }
 private:
  internal::SmartCardReaderStateFlags_Data* data_ = nullptr;
};


class SmartCardReaderStateInDataView {
 public:
  SmartCardReaderStateInDataView() = default;

  SmartCardReaderStateInDataView(
      internal::SmartCardReaderStateIn_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReader(UserType* output) {
    
    auto* pointer = data_->reader.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentStateDataView(
      SmartCardReaderStateFlagsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentState(UserType* output) {
    
    auto* pointer = data_->current_state.Get();
    return mojo::internal::Deserialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
        pointer, output, message_);
  }
  uint16_t current_count() const {
    return data_->current_count;
  }
 private:
  internal::SmartCardReaderStateIn_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardReaderStateOutDataView {
 public:
  SmartCardReaderStateOutDataView() = default;

  SmartCardReaderStateOutDataView(
      internal::SmartCardReaderStateOut_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReaderDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReader(UserType* output) {
    
    auto* pointer = data_->reader.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEventStateDataView(
      SmartCardReaderStateFlagsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEventState(UserType* output) {
    
    auto* pointer = data_->event_state.Get();
    return mojo::internal::Deserialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
        pointer, output, message_);
  }
  uint16_t event_count() const {
    return data_->event_count;
  }
  inline void GetAnswerToResetDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswerToReset(UserType* output) {
    
    auto* pointer = data_->answer_to_reset.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::SmartCardReaderStateOut_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardProtocolsDataView {
 public:
  SmartCardProtocolsDataView() = default;

  SmartCardProtocolsDataView(
      internal::SmartCardProtocols_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool t0() const {
    return data_->t0;
  }
  bool t1() const {
    return data_->t1;
  }
  bool raw() const {
    return data_->raw;
  }
 private:
  internal::SmartCardProtocols_Data* data_ = nullptr;
};


class SmartCardStatusDataView {
 public:
  SmartCardStatusDataView() = default;

  SmartCardStatusDataView(
      internal::SmartCardStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetReaderNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReaderName(UserType* output) {
    
    auto* pointer = data_->reader_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::device::mojom::SmartCardConnectionState>(
        data_value, output);
  }
  SmartCardConnectionState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SmartCardConnectionState>(data_->state));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProtocol(UserType* output) const {
    auto data_value = data_->protocol;
    return mojo::internal::Deserialize<::device::mojom::SmartCardProtocol>(
        data_value, output);
  }
  SmartCardProtocol protocol() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SmartCardProtocol>(data_->protocol));
  }
  inline void GetAnswerToResetDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswerToReset(UserType* output) {
    
    auto* pointer = data_->answer_to_reset.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::SmartCardStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardConnectSuccessDataView {
 public:
  SmartCardConnectSuccessDataView() = default;

  SmartCardConnectSuccessDataView(
      internal::SmartCardConnectSuccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeConnection() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardConnectionInterfaceBase>>(
            &data_->connection, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadActiveProtocol(UserType* output) const {
    auto data_value = data_->active_protocol;
    return mojo::internal::Deserialize<::device::mojom::SmartCardProtocol>(
        data_value, output);
  }
  SmartCardProtocol active_protocol() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SmartCardProtocol>(data_->active_protocol));
  }
 private:
  internal::SmartCardConnectSuccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SmartCardResultDataView {
 public:
  using Tag = internal::SmartCardResult_Data::SmartCardResult_Tag;

  SmartCardResultDataView() = default;

  SmartCardResultDataView(
      internal::SmartCardResult_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    CHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::SmartCardSuccess>(
        data_->data.f_success, output);
  }
  SmartCardSuccess success() const {
    CHECK(is_success());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardSuccess>(data_->data.f_success));
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardResult_Data* data_ = nullptr;
};



class SmartCardStatusChangeResultDataView {
 public:
  using Tag = internal::SmartCardStatusChangeResult_Data::SmartCardStatusChangeResult_Tag;

  SmartCardStatusChangeResultDataView() = default;

  SmartCardStatusChangeResultDataView(
      internal::SmartCardStatusChangeResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_reader_states() const { return data_->tag == Tag::kReaderStates; }
  inline void GetReaderStatesDataView(
      mojo::ArrayDataView<SmartCardReaderStateOutDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReaderStates(UserType* output) const {
    
    CHECK(is_reader_states());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::SmartCardReaderStateOutDataView>>(
        data_->data.f_reader_states.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardStatusChangeResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardListReadersResultDataView {
 public:
  using Tag = internal::SmartCardListReadersResult_Data::SmartCardListReadersResult_Tag;

  SmartCardListReadersResultDataView() = default;

  SmartCardListReadersResultDataView(
      internal::SmartCardListReadersResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_readers() const { return data_->tag == Tag::kReaders; }
  inline void GetReadersDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadReaders(UserType* output) const {
    
    CHECK(is_readers());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_readers.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardListReadersResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardCreateContextResultDataView {
 public:
  using Tag = internal::SmartCardCreateContextResult_Data::SmartCardCreateContextResult_Tag;

  SmartCardCreateContextResultDataView() = default;

  SmartCardCreateContextResultDataView(
      internal::SmartCardCreateContextResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_context() const { return data_->tag == Tag::kContext; }
  template <typename UserType>
  UserType TakeContext() {
    CHECK(is_context());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardContextInterfaceBase>>(
            &data_->data.f_context, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardCreateContextResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardConnectResultDataView {
 public:
  using Tag = internal::SmartCardConnectResult_Data::SmartCardConnectResult_Tag;

  SmartCardConnectResultDataView() = default;

  SmartCardConnectResultDataView(
      internal::SmartCardConnectResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      SmartCardConnectSuccessDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::device::mojom::SmartCardConnectSuccessDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardConnectResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardDataResultDataView {
 public:
  using Tag = internal::SmartCardDataResult_Data::SmartCardDataResult_Tag;

  SmartCardDataResultDataView() = default;

  SmartCardDataResultDataView(
      internal::SmartCardDataResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_data() const { return data_->tag == Tag::kData; }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) const {
    
    CHECK(is_data());
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        data_->data.f_data.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardDataResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardStatusResultDataView {
 public:
  using Tag = internal::SmartCardStatusResult_Data::SmartCardStatusResult_Tag;

  SmartCardStatusResultDataView() = default;

  SmartCardStatusResultDataView(
      internal::SmartCardStatusResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_status() const { return data_->tag == Tag::kStatus; }
  inline void GetStatusDataView(
      SmartCardStatusDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    
    CHECK(is_status());
    return mojo::internal::Deserialize<::device::mojom::SmartCardStatusDataView>(
        data_->data.f_status.Get(), output, message_);
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardStatusResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class SmartCardTransactionResultDataView {
 public:
  using Tag = internal::SmartCardTransactionResult_Data::SmartCardTransactionResult_Tag;

  SmartCardTransactionResultDataView() = default;

  SmartCardTransactionResultDataView(
      internal::SmartCardTransactionResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_transaction() const { return data_->tag == Tag::kTransaction; }
  template <typename UserType>
  UserType TakeTransaction() {
    CHECK(is_transaction());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<::device::mojom::SmartCardTransactionAssociatedPtrInfoDataView>(
            &data_->data.f_transaction, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::SmartCardError>(
        data_->data.f_error, output);
  }
  SmartCardError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(data_->data.f_error));
  }

 private:
  internal::SmartCardTransactionResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

namespace std {

template <>
struct hash<::device::mojom::SmartCardSuccess>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardSuccess> {};

template <>
struct hash<::device::mojom::SmartCardError>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardError> {};

template <>
struct hash<::device::mojom::SmartCardShareMode>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardShareMode> {};

template <>
struct hash<::device::mojom::SmartCardProtocol>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardProtocol> {};

template <>
struct hash<::device::mojom::SmartCardDisposition>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardDisposition> {};

template <>
struct hash<::device::mojom::SmartCardConnectionState>
    : public mojo::internal::EnumHashImpl<::device::mojom::SmartCardConnectionState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardSuccess, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardSuccess, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardSuccess>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardShareMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardShareMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardShareMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardProtocol, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardProtocol, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardProtocol>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardDisposition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardDisposition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardDisposition>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardConnectionState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::SmartCardConnectionState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::SmartCardConnectionState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardReaderStateFlagsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateFlagsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateFlags_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->unaware = Traits::unaware(input);
    fragment->ignore = Traits::ignore(input);
    fragment->changed = Traits::changed(input);
    fragment->unknown = Traits::unknown(input);
    fragment->unavailable = Traits::unavailable(input);
    fragment->empty = Traits::empty(input);
    fragment->present = Traits::present(input);
    fragment->exclusive = Traits::exclusive(input);
    fragment->inuse = Traits::inuse(input);
    fragment->mute = Traits::mute(input);
    fragment->unpowered = Traits::unpowered(input);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardReaderStateFlags_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardReaderStateFlagsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardReaderStateInDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateInDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateIn_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::reader(input)) in_reader = Traits::reader(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reader)::BaseType> reader_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_reader, reader_fragment);
    fragment->reader.Set(
        reader_fragment.is_null() ? nullptr : reader_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->reader.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reader in SmartCardReaderStateIn struct");
    decltype(Traits::current_state(input)) in_current_state = Traits::current_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->current_state)::BaseType> current_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
        in_current_state, current_state_fragment);
    fragment->current_state.Set(
        current_state_fragment.is_null() ? nullptr : current_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->current_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null current_state in SmartCardReaderStateIn struct");
    fragment->current_count = Traits::current_count(input);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardReaderStateIn_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardReaderStateInDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardReaderStateOutDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardReaderStateOutDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardReaderStateOut_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::reader(input)) in_reader = Traits::reader(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reader)::BaseType> reader_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_reader, reader_fragment);
    fragment->reader.Set(
        reader_fragment.is_null() ? nullptr : reader_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->reader.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reader in SmartCardReaderStateOut struct");
    decltype(Traits::event_state(input)) in_event_state = Traits::event_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_state)::BaseType> event_state_fragment(
            fragment.message());
    mojo::internal::Serialize<::device::mojom::SmartCardReaderStateFlagsDataView>(
        in_event_state, event_state_fragment);
    fragment->event_state.Set(
        event_state_fragment.is_null() ? nullptr : event_state_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->event_state.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_state in SmartCardReaderStateOut struct");
    fragment->event_count = Traits::event_count(input);
    decltype(Traits::answer_to_reset(input)) in_answer_to_reset = Traits::answer_to_reset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->answer_to_reset)::BaseType>
        answer_to_reset_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_answer_to_reset, answer_to_reset_fragment, &answer_to_reset_validate_params);
    fragment->answer_to_reset.Set(
        answer_to_reset_fragment.is_null() ? nullptr : answer_to_reset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->answer_to_reset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null answer_to_reset in SmartCardReaderStateOut struct");
  }

  static bool Deserialize(::device::mojom::internal::SmartCardReaderStateOut_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardReaderStateOutDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardProtocolsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardProtocolsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardProtocols_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->t0 = Traits::t0(input);
    fragment->t1 = Traits::t1(input);
    fragment->raw = Traits::raw(input);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardProtocols_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardProtocolsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardStatusDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardStatusDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardStatus_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::reader_name(input)) in_reader_name = Traits::reader_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reader_name)::BaseType> reader_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_reader_name, reader_name_fragment);
    fragment->reader_name.Set(
        reader_name_fragment.is_null() ? nullptr : reader_name_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->reader_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null reader_name in SmartCardStatus struct");
    mojo::internal::Serialize<::device::mojom::SmartCardConnectionState>(
        Traits::state(input), &fragment->state);
    mojo::internal::Serialize<::device::mojom::SmartCardProtocol>(
        Traits::protocol(input), &fragment->protocol);
    decltype(Traits::answer_to_reset(input)) in_answer_to_reset = Traits::answer_to_reset(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->answer_to_reset)::BaseType>
        answer_to_reset_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& answer_to_reset_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_answer_to_reset, answer_to_reset_fragment, &answer_to_reset_validate_params);
    fragment->answer_to_reset.Set(
        answer_to_reset_fragment.is_null() ? nullptr : answer_to_reset_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->answer_to_reset.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null answer_to_reset in SmartCardStatus struct");
  }

  static bool Deserialize(::device::mojom::internal::SmartCardStatus_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardStatusDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardConnectSuccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SmartCardConnectSuccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SmartCardConnectSuccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::connection(input)) in_connection = Traits::connection(input);
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardConnectionInterfaceBase>>(
        in_connection, &fragment->connection, &fragment.message());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        !mojo::internal::IsHandleOrInterfaceValid(fragment->connection),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid connection in SmartCardConnectSuccess struct");
    mojo::internal::Serialize<::device::mojom::SmartCardProtocol>(
        Traits::active_protocol(input), &fragment->active_protocol);
  }

  static bool Deserialize(::device::mojom::internal::SmartCardConnectSuccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardConnectSuccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardResultDataView::Tag::kSuccess: {
        decltype(Traits::success(input))
            in_success = Traits::success(input);
        mojo::internal::Serialize<::device::mojom::SmartCardSuccess>(
            in_success, &fragment->data.f_success);
        break;
      }
      case ::device::mojom::SmartCardResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardStatusChangeResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardStatusChangeResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardStatusChangeResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardStatusChangeResultDataView::Tag::kReaderStates: {
        decltype(Traits::reader_states(input))
            in_reader_states = Traits::reader_states(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_reader_states)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& reader_states_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::SmartCardReaderStateOutDataView>>(
            in_reader_states, value_fragment, &reader_states_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null reader_states in SmartCardStatusChangeResult union");
        fragment->data.f_reader_states.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::SmartCardStatusChangeResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardStatusChangeResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardStatusChangeResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardListReadersResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardListReadersResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardListReadersResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardListReadersResultDataView::Tag::kReaders: {
        decltype(Traits::readers(input))
            in_readers = Traits::readers(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_readers)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& readers_validate_params =
            mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
        mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
            in_readers, value_fragment, &readers_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null readers in SmartCardListReadersResult union");
        fragment->data.f_readers.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::SmartCardListReadersResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardListReadersResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardListReadersResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardCreateContextResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardCreateContextResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardCreateContextResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardCreateContextResultDataView::Tag::kContext: {
        decltype(Traits::context(input))
            in_context = Traits::context(input);
        mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SmartCardContextInterfaceBase>>(
            in_context, &fragment->data.f_context, &fragment.message());
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            !mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_context),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
            "invalid context in SmartCardCreateContextResult union");
        break;
      }
      case ::device::mojom::SmartCardCreateContextResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardCreateContextResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardCreateContextResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardConnectResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardConnectResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardConnectResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardConnectResultDataView::Tag::kSuccess: {
        decltype(Traits::success(input))
            in_success = Traits::success(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_success)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::SmartCardConnectSuccessDataView>(
            in_success, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null success in SmartCardConnectResult union");
        fragment->data.f_success.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::SmartCardConnectResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardConnectResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardConnectResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardDataResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardDataResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardDataResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardDataResultDataView::Tag::kData: {
        decltype(Traits::data(input))
            in_data = Traits::data(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_data)::BaseType>
            value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
            in_data, value_fragment, &data_validate_params);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null data in SmartCardDataResult union");
        fragment->data.f_data.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::SmartCardDataResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardDataResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardDataResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardStatusResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardStatusResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardStatusResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardStatusResultDataView::Tag::kStatus: {
        decltype(Traits::status(input))
            in_status = Traits::status(input);
        mojo::internal::MessageFragment<
            typename decltype(fragment->data.f_status)::BaseType>
            value_fragment(fragment.message());
        mojo::internal::Serialize<::device::mojom::SmartCardStatusDataView>(
            in_status, value_fragment);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_fragment.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null status in SmartCardStatusResult union");
        fragment->data.f_status.Set(
            value_fragment.is_null() ? nullptr : value_fragment.data());
        break;
      }
      case ::device::mojom::SmartCardStatusResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardStatusResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardStatusResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::SmartCardTransactionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::SmartCardTransactionResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::SmartCardTransactionResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::SmartCardTransactionResultDataView::Tag::kTransaction: {
        decltype(Traits::transaction(input))
            in_transaction = Traits::transaction(input);
        mojo::internal::Serialize<::device::mojom::SmartCardTransactionAssociatedPtrInfoDataView>(
            in_transaction, &fragment->data.f_transaction, &fragment.message());
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            !mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_transaction),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
            "invalid transaction in SmartCardTransactionResult union");
        break;
      }
      case ::device::mojom::SmartCardTransactionResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::SmartCardError>(
            in_error, &fragment->data.f_error);
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::SmartCardTransactionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::SmartCardTransactionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {



inline void SmartCardReaderStateInDataView::GetReaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reader.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SmartCardReaderStateInDataView::GetCurrentStateDataView(
    SmartCardReaderStateFlagsDataView* output) {
  auto pointer = data_->current_state.Get();
  *output = SmartCardReaderStateFlagsDataView(pointer, message_);
}


inline void SmartCardReaderStateOutDataView::GetReaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reader.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SmartCardReaderStateOutDataView::GetEventStateDataView(
    SmartCardReaderStateFlagsDataView* output) {
  auto pointer = data_->event_state.Get();
  *output = SmartCardReaderStateFlagsDataView(pointer, message_);
}
inline void SmartCardReaderStateOutDataView::GetAnswerToResetDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->answer_to_reset.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void SmartCardStatusDataView::GetReaderNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reader_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SmartCardStatusDataView::GetAnswerToResetDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->answer_to_reset.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}





inline void SmartCardStatusChangeResultDataView::GetReaderStatesDataView(
    mojo::ArrayDataView<SmartCardReaderStateOutDataView>* output) const {
  CHECK(is_reader_states());
  *output = mojo::ArrayDataView<SmartCardReaderStateOutDataView>(data_->data.f_reader_states.Get(), message_);
}

inline void SmartCardListReadersResultDataView::GetReadersDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) const {
  CHECK(is_readers());
  *output = mojo::ArrayDataView<mojo::StringDataView>(data_->data.f_readers.Get(), message_);
}


inline void SmartCardConnectResultDataView::GetSuccessDataView(
    SmartCardConnectSuccessDataView* output) const {
  CHECK(is_success());
  *output = SmartCardConnectSuccessDataView(data_->data.f_success.Get(), message_);
}

inline void SmartCardDataResultDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) const {
  CHECK(is_data());
  *output = mojo::ArrayDataView<uint8_t>(data_->data.f_data.Get(), message_);
}

inline void SmartCardStatusResultDataView::GetStatusDataView(
    SmartCardStatusDataView* output) const {
  CHECK(is_status());
  *output = SmartCardStatusDataView(data_->data.f_status.Get(), message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardSuccess> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardSuccess value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardShareMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardShareMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardProtocol> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardProtocol value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardDisposition> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardDisposition value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::SmartCardConnectionState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::SmartCardConnectionState value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SMART_CARD_MOJOM_SHARED_H_