// media/mojo/mojom/stable/stable_video_decoder_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_TYPES_MOJOM_H_
#define MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-features.h"  // IWYU pragma: export
#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-shared.h"  // IWYU pragma: export
#include "media/mojo/mojom/stable/stable_video_decoder_types.mojom-forward.h"  // IWYU pragma: export
#include "media/mojo/mojom/encryption_pattern.mojom.h"
#include "media/mojo/mojom/stable/native_pixmap_handle.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/mojom/buffer_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "media/mojo/mojom/stable/stable_video_decoder_types_mojom_traits.h"




namespace media::stable::mojom {





class  SubsampleEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SubsampleEntry, T>::value>;
  using DataView = SubsampleEntryDataView;
  using Data_ = internal::SubsampleEntry_Data;

  template <typename... Args>
  static SubsampleEntryPtr New(Args&&... args) {
    return SubsampleEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SubsampleEntryPtr From(const U& u) {
    return mojo::TypeConverter<SubsampleEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SubsampleEntry>::Convert(*this);
  }


  SubsampleEntry();

  SubsampleEntry(
      uint32_t clear_bytes,
      uint32_t cypher_bytes);


  ~SubsampleEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SubsampleEntryPtr>
  SubsampleEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SubsampleEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SubsampleEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SubsampleEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SubsampleEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SubsampleEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SubsampleEntry_UnserializedMessageContext<
            UserType, SubsampleEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SubsampleEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SubsampleEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SubsampleEntry_UnserializedMessageContext<
            UserType, SubsampleEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SubsampleEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t clear_bytes;
  
  uint32_t cypher_bytes;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SubsampleEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SubsampleEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SubsampleEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SubsampleEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}
















class  VideoFrameMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrameMetadata, T>::value>;
  using DataView = VideoFrameMetadataDataView;
  using Data_ = internal::VideoFrameMetadata_Data;

  template <typename... Args>
  static VideoFrameMetadataPtr New(Args&&... args) {
    return VideoFrameMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFrameMetadataPtr From(const U& u) {
    return mojo::TypeConverter<VideoFrameMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrameMetadata>::Convert(*this);
  }


  VideoFrameMetadata();

  VideoFrameMetadata(
      bool protected_video,
      bool hw_protected);

  VideoFrameMetadata(
      bool protected_video,
      bool hw_protected,
      bool needs_detiling);


  ~VideoFrameMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFrameMetadataPtr>
  VideoFrameMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoFrameMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrameMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoFrameMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrameMetadata_UnserializedMessageContext<
            UserType, VideoFrameMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrameMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool protected_video;
  
  bool hw_protected;
  
  bool needs_detiling;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  DecryptConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecryptConfig, T>::value>;
  using DataView = DecryptConfigDataView;
  using Data_ = internal::DecryptConfig_Data;

  template <typename... Args>
  static DecryptConfigPtr New(Args&&... args) {
    return DecryptConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecryptConfigPtr From(const U& u) {
    return mojo::TypeConverter<DecryptConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecryptConfig>::Convert(*this);
  }


  DecryptConfig();

  DecryptConfig(
      ::media::EncryptionScheme encryption_scheme,
      const std::string& key_id,
      const std::string& iv,
      std::vector<::media::SubsampleEntry> subsamples,
      const std::optional<::media::EncryptionPattern>& encryption_pattern);


  ~DecryptConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecryptConfigPtr>
  DecryptConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecryptConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecryptConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecryptConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecryptConfig_UnserializedMessageContext<
            UserType, DecryptConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecryptConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::EncryptionScheme encryption_scheme;
  
  std::string key_id;
  
  std::string iv;
  
  std::vector<::media::SubsampleEntry> subsamples;
  
  std::optional<::media::EncryptionPattern> encryption_pattern;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecryptConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ColorVolumeMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ColorVolumeMetadata, T>::value>;
  using DataView = ColorVolumeMetadataDataView;
  using Data_ = internal::ColorVolumeMetadata_Data;

  template <typename... Args>
  static ColorVolumeMetadataPtr New(Args&&... args) {
    return ColorVolumeMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorVolumeMetadataPtr From(const U& u) {
    return mojo::TypeConverter<ColorVolumeMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ColorVolumeMetadata>::Convert(*this);
  }


  ColorVolumeMetadata();

  ColorVolumeMetadata(
      const ::gfx::PointF& primary_r,
      const ::gfx::PointF& primary_g,
      const ::gfx::PointF& primary_b,
      const ::gfx::PointF& white_point,
      float luminance_max,
      float luminance_min);


  ~ColorVolumeMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorVolumeMetadataPtr>
  ColorVolumeMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ColorVolumeMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ColorVolumeMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ColorVolumeMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorVolumeMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ColorVolumeMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ColorVolumeMetadata_UnserializedMessageContext<
            UserType, ColorVolumeMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ColorVolumeMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ColorVolumeMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ColorVolumeMetadata_UnserializedMessageContext<
            UserType, ColorVolumeMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ColorVolumeMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF primary_r;
  
  ::gfx::PointF primary_g;
  
  ::gfx::PointF primary_b;
  
  ::gfx::PointF white_point;
  
  float luminance_max;
  
  float luminance_min;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ColorVolumeMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ColorVolumeMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ColorVolumeMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ColorVolumeMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  HDRMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HDRMetadata, T>::value>;
  using DataView = HDRMetadataDataView;
  using Data_ = internal::HDRMetadata_Data;

  template <typename... Args>
  static HDRMetadataPtr New(Args&&... args) {
    return HDRMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HDRMetadataPtr From(const U& u) {
    return mojo::TypeConverter<HDRMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HDRMetadata>::Convert(*this);
  }


  HDRMetadata();

  HDRMetadata(
      const ::gfx::HdrMetadataSmpteSt2086& color_volume_metadata,
      uint32_t max_content_light_level,
      uint32_t max_frame_average_light_level);


  ~HDRMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HDRMetadataPtr>
  HDRMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HDRMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HDRMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HDRMetadata_UnserializedMessageContext<
            UserType, HDRMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HDRMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HDRMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HDRMetadata_UnserializedMessageContext<
            UserType, HDRMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HDRMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::HdrMetadataSmpteSt2086 color_volume_metadata;
  
  uint32_t max_content_light_level;
  
  uint32_t max_frame_average_light_level;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HDRMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VideoDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoDecoderConfig, T>::value>;
  using DataView = VideoDecoderConfigDataView;
  using Data_ = internal::VideoDecoderConfig_Data;

  template <typename... Args>
  static VideoDecoderConfigPtr New(Args&&... args) {
    return VideoDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<VideoDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoDecoderConfig>::Convert(*this);
  }


  VideoDecoderConfig();

  VideoDecoderConfig(
      ::media::VideoCodec codec,
      ::media::VideoCodecProfile profile,
      uint32_t level,
      bool has_alpha,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      std::vector<uint8_t> extra_data,
      ::media::EncryptionScheme encryption_scheme,
      const ::gfx::ColorSpace& color_space_info,
      const std::optional<::gfx::HDRMetadata>& hdr_metadata);


  ~VideoDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoDecoderConfigPtr>
  VideoDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VideoDecoderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoDecoderConfig_UnserializedMessageContext<
            UserType, VideoDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoCodec codec;
  
  ::media::VideoCodecProfile profile;
  
  uint32_t level;
  
  bool has_alpha;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  std::vector<uint8_t> extra_data;
  
  ::media::EncryptionScheme encryption_scheme;
  
  ::gfx::ColorSpace color_space_info;
  
  std::optional<::gfx::HDRMetadata> hdr_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SupportedVideoDecoderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SupportedVideoDecoderConfig, T>::value>;
  using DataView = SupportedVideoDecoderConfigDataView;
  using Data_ = internal::SupportedVideoDecoderConfig_Data;

  template <typename... Args>
  static SupportedVideoDecoderConfigPtr New(Args&&... args) {
    return SupportedVideoDecoderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SupportedVideoDecoderConfigPtr From(const U& u) {
    return mojo::TypeConverter<SupportedVideoDecoderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SupportedVideoDecoderConfig>::Convert(*this);
  }


  SupportedVideoDecoderConfig();

  SupportedVideoDecoderConfig(
      ::media::VideoCodecProfile profile_min,
      ::media::VideoCodecProfile profile_max,
      const ::gfx::Size& coded_size_min,
      const ::gfx::Size& coded_size_max,
      bool allow_encrypted,
      bool require_encrypted);


  ~SupportedVideoDecoderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SupportedVideoDecoderConfigPtr>
  SupportedVideoDecoderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SupportedVideoDecoderConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SupportedVideoDecoderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SupportedVideoDecoderConfig_UnserializedMessageContext<
            UserType, SupportedVideoDecoderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SupportedVideoDecoderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SupportedVideoDecoderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SupportedVideoDecoderConfig_UnserializedMessageContext<
            UserType, SupportedVideoDecoderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SupportedVideoDecoderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoCodecProfile profile_min;
  
  ::media::VideoCodecProfile profile_max;
  
  ::gfx::Size coded_size_min;
  
  ::gfx::Size coded_size_max;
  
  bool allow_encrypted;
  
  bool require_encrypted;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  StatusData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StatusData, T>::value>;
  using DataView = StatusDataDataView;
  using Data_ = internal::StatusData_Data;

  template <typename... Args>
  static StatusDataPtr New(Args&&... args) {
    return StatusDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StatusDataPtr From(const U& u) {
    return mojo::TypeConverter<StatusDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StatusData>::Convert(*this);
  }


  StatusData();

  StatusData(
      const std::string& group,
      StatusCode code,
      const std::string& message,
      std::vector<::base::Value> frames,
      const std::optional<::media::internal::StatusData>& cause,
      ::base::Value data);

StatusData(const StatusData&) = delete;
StatusData& operator=(const StatusData&) = delete;

  ~StatusData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StatusDataPtr>
  StatusDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StatusData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StatusData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StatusData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StatusData_UnserializedMessageContext<
            UserType, StatusData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StatusData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StatusData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StatusData_UnserializedMessageContext<
            UserType, StatusData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StatusData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string group;
  
  StatusCode code;
  
  std::string message;
  
  std::vector<::base::Value> frames;
  
  std::optional<::media::internal::StatusData> cause;
  
  ::base::Value data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StatusData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Status {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Status, T>::value>;
  using DataView = StatusDataView;
  using Data_ = internal::Status_Data;

  template <typename... Args>
  static StatusPtr New(Args&&... args) {
    return StatusPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StatusPtr From(const U& u) {
    return mojo::TypeConverter<StatusPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Status>::Convert(*this);
  }


  Status();

  explicit Status(
      const std::optional<::media::internal::StatusData>& internal);


  ~Status();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StatusPtr>
  StatusPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Status::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Status::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Status::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Status::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Status::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Status_UnserializedMessageContext<
            UserType, Status::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Status::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Status::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Status_UnserializedMessageContext<
            UserType, Status::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Status::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::media::internal::StatusData> internal;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Status::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DecoderBufferSideData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecoderBufferSideData, T>::value>;
  using DataView = DecoderBufferSideDataDataView;
  using Data_ = internal::DecoderBufferSideData_Data;

  template <typename... Args>
  static DecoderBufferSideDataPtr New(Args&&... args) {
    return DecoderBufferSideDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecoderBufferSideDataPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferSideDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBufferSideData>::Convert(*this);
  }


  DecoderBufferSideData();

  DecoderBufferSideData(
      std::vector<uint32_t> spatial_layers,
      std::vector<uint8_t> alpha_data,
      uint64_t secure_handle);


  ~DecoderBufferSideData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecoderBufferSideDataPtr>
  DecoderBufferSideDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderBufferSideData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBufferSideData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecoderBufferSideData_UnserializedMessageContext<
            UserType, DecoderBufferSideData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecoderBufferSideData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecoderBufferSideData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecoderBufferSideData_UnserializedMessageContext<
            UserType, DecoderBufferSideData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecoderBufferSideData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint32_t> spatial_layers;
  
  std::vector<uint8_t> alpha_data;
  
  uint64_t secure_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  DecoderBuffer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DecoderBuffer, T>::value>;
  using DataView = DecoderBufferDataView;
  using Data_ = internal::DecoderBuffer_Data;

  template <typename... Args>
  static DecoderBufferPtr New(Args&&... args) {
    return DecoderBufferPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DecoderBufferPtr From(const U& u) {
    return mojo::TypeConverter<DecoderBufferPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DecoderBuffer>::Convert(*this);
  }


  DecoderBuffer();

  DecoderBuffer(
      ::base::TimeDelta timestamp,
      ::base::TimeDelta duration,
      bool is_end_of_stream,
      uint32_t data_size,
      bool is_key_frame,
      std::vector<uint8_t> raw_side_data,
      ::std::unique_ptr<::media::DecryptConfig> decrypt_config,
      ::base::TimeDelta front_discard,
      ::base::TimeDelta back_discard);

  DecoderBuffer(
      ::base::TimeDelta timestamp,
      ::base::TimeDelta duration,
      bool is_end_of_stream,
      uint32_t data_size,
      bool is_key_frame,
      std::vector<uint8_t> raw_side_data,
      ::std::unique_ptr<::media::DecryptConfig> decrypt_config,
      ::base::TimeDelta front_discard,
      ::base::TimeDelta back_discard,
      DecoderBufferSideDataPtr side_data);

DecoderBuffer(const DecoderBuffer&) = delete;
DecoderBuffer& operator=(const DecoderBuffer&) = delete;

  ~DecoderBuffer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DecoderBufferPtr>
  DecoderBufferPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DecoderBuffer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DecoderBuffer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DecoderBuffer_UnserializedMessageContext<
            UserType, DecoderBuffer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DecoderBuffer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DecoderBuffer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DecoderBuffer_UnserializedMessageContext<
            UserType, DecoderBuffer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DecoderBuffer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeDelta timestamp;
  
  ::base::TimeDelta duration;
  
  bool is_end_of_stream;
  
  uint32_t data_size;
  
  bool is_key_frame;
  
  std::vector<uint8_t> raw_side_data;
  
  ::std::unique_ptr<::media::DecryptConfig> decrypt_config;
  
  ::base::TimeDelta front_discard;
  
  ::base::TimeDelta back_discard;
  
  DecoderBufferSideDataPtr side_data;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DecoderBuffer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ColorSpace {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ColorSpace, T>::value>;
  using DataView = ColorSpaceDataView;
  using Data_ = internal::ColorSpace_Data;

  template <typename... Args>
  static ColorSpacePtr New(Args&&... args) {
    return ColorSpacePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ColorSpacePtr From(const U& u) {
    return mojo::TypeConverter<ColorSpacePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ColorSpace>::Convert(*this);
  }


  ColorSpace();

  ColorSpace(
      ::gfx::ColorSpace::PrimaryID primaries,
      ::gfx::ColorSpace::TransferID transfer,
      ::gfx::ColorSpace::MatrixID matrix,
      ::gfx::ColorSpace::RangeID range,
      std::vector<float> custom_primary_matrix,
      std::vector<float> transfer_params);


  ~ColorSpace();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ColorSpacePtr>
  ColorSpacePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ColorSpace::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ColorSpace::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ColorSpace_UnserializedMessageContext<
            UserType, ColorSpace::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ColorSpace::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ColorSpace::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ColorSpace_UnserializedMessageContext<
            UserType, ColorSpace::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ColorSpace::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::ColorSpace::PrimaryID primaries;
  
  ::gfx::ColorSpace::TransferID transfer;
  
  ::gfx::ColorSpace::MatrixID matrix;
  
  ::gfx::ColorSpace::RangeID range;
  
  std::vector<float> custom_primary_matrix;
  
  std::vector<float> transfer_params;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ColorSpace::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NativeGpuMemoryBufferHandle {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NativeGpuMemoryBufferHandle, T>::value>;
  using DataView = NativeGpuMemoryBufferHandleDataView;
  using Data_ = internal::NativeGpuMemoryBufferHandle_Data;

  template <typename... Args>
  static NativeGpuMemoryBufferHandlePtr New(Args&&... args) {
    return NativeGpuMemoryBufferHandlePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NativeGpuMemoryBufferHandlePtr From(const U& u) {
    return mojo::TypeConverter<NativeGpuMemoryBufferHandlePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NativeGpuMemoryBufferHandle>::Convert(*this);
  }


  NativeGpuMemoryBufferHandle();

  NativeGpuMemoryBufferHandle(
      ::gfx::GpuMemoryBufferId id,
      ::gfx::NativePixmapHandle platform_handle);

NativeGpuMemoryBufferHandle(const NativeGpuMemoryBufferHandle&) = delete;
NativeGpuMemoryBufferHandle& operator=(const NativeGpuMemoryBufferHandle&) = delete;

  ~NativeGpuMemoryBufferHandle();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NativeGpuMemoryBufferHandlePtr>
  NativeGpuMemoryBufferHandlePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NativeGpuMemoryBufferHandle::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NativeGpuMemoryBufferHandle_UnserializedMessageContext<
            UserType, NativeGpuMemoryBufferHandle::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NativeGpuMemoryBufferHandle::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NativeGpuMemoryBufferHandle::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NativeGpuMemoryBufferHandle_UnserializedMessageContext<
            UserType, NativeGpuMemoryBufferHandle::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NativeGpuMemoryBufferHandle::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::GpuMemoryBufferId id;
  
  ::gfx::NativePixmapHandle platform_handle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  VideoFrame {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VideoFrame, T>::value>;
  using DataView = VideoFrameDataView;
  using Data_ = internal::VideoFrame_Data;

  template <typename... Args>
  static VideoFramePtr New(Args&&... args) {
    return VideoFramePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VideoFramePtr From(const U& u) {
    return mojo::TypeConverter<VideoFramePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VideoFrame>::Convert(*this);
  }


  VideoFrame();

  VideoFrame(
      ::media::VideoPixelFormat format,
      const ::gfx::Size& coded_size,
      const ::gfx::Rect& visible_rect,
      const ::gfx::Size& natural_size,
      ::base::TimeDelta timestamp,
      ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle,
      const ::media::VideoFrameMetadata& metadata,
      const ::gfx::ColorSpace& color_space,
      const std::optional<::gfx::HDRMetadata>& hdr_metadata);

VideoFrame(const VideoFrame&) = delete;
VideoFrame& operator=(const VideoFrame&) = delete;

  ~VideoFrame();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VideoFramePtr>
  VideoFramePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VideoFrame::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VideoFrame::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VideoFrame_UnserializedMessageContext<
            UserType, VideoFrame::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VideoFrame::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media::VideoPixelFormat format;
  
  ::gfx::Size coded_size;
  
  ::gfx::Rect visible_rect;
  
  ::gfx::Size natural_size;
  
  ::base::TimeDelta timestamp;
  
  ::gfx::GpuMemoryBufferHandle gpu_memory_buffer_handle;
  
  ::media::VideoFrameMetadata metadata;
  
  ::gfx::ColorSpace color_space;
  
  std::optional<::gfx::HDRMetadata> hdr_metadata;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VideoFrame::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaLogRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaLogRecord, T>::value>;
  using DataView = MediaLogRecordDataView;
  using Data_ = internal::MediaLogRecord_Data;
  using Type = MediaLogRecord_Type;

  template <typename... Args>
  static MediaLogRecordPtr New(Args&&... args) {
    return MediaLogRecordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaLogRecordPtr From(const U& u) {
    return mojo::TypeConverter<MediaLogRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaLogRecord>::Convert(*this);
  }


  MediaLogRecord();

  MediaLogRecord(
      int32_t id,
      ::media::MediaLogRecord::Type type,
      ::base::Value::Dict params,
      ::base::TimeTicks time);

MediaLogRecord(const MediaLogRecord&) = delete;
MediaLogRecord& operator=(const MediaLogRecord&) = delete;

  ~MediaLogRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaLogRecordPtr>
  MediaLogRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaLogRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MediaLogRecord::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MediaLogRecord::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaLogRecord::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaLogRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaLogRecord_UnserializedMessageContext<
            UserType, MediaLogRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MediaLogRecord::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MediaLogRecord::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaLogRecord_UnserializedMessageContext<
            UserType, MediaLogRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaLogRecord::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  ::media::MediaLogRecord::Type type;
  
  ::base::Value::Dict params;
  
  ::base::TimeTicks time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaLogRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaLogRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaLogRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaLogRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SubsampleEntryPtr SubsampleEntry::Clone() const {
  return New(
      mojo::Clone(clear_bytes),
      mojo::Clone(cypher_bytes)
  );
}

template <typename T, SubsampleEntry::EnableIfSame<T>*>
bool SubsampleEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->clear_bytes, other_struct.clear_bytes))
    return false;
  if (!mojo::Equals(this->cypher_bytes, other_struct.cypher_bytes))
    return false;
  return true;
}

template <typename T, SubsampleEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.clear_bytes < rhs.clear_bytes)
    return true;
  if (rhs.clear_bytes < lhs.clear_bytes)
    return false;
  if (lhs.cypher_bytes < rhs.cypher_bytes)
    return true;
  if (rhs.cypher_bytes < lhs.cypher_bytes)
    return false;
  return false;
}
template <typename StructPtrType>
DecryptConfigPtr DecryptConfig::Clone() const {
  return New(
      mojo::Clone(encryption_scheme),
      mojo::Clone(key_id),
      mojo::Clone(iv),
      mojo::Clone(subsamples),
      mojo::Clone(encryption_pattern)
  );
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool DecryptConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->key_id, other_struct.key_id))
    return false;
  if (!mojo::Equals(this->iv, other_struct.iv))
    return false;
  if (!mojo::Equals(this->subsamples, other_struct.subsamples))
    return false;
  if (!mojo::Equals(this->encryption_pattern, other_struct.encryption_pattern))
    return false;
  return true;
}

template <typename T, DecryptConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.key_id < rhs.key_id)
    return true;
  if (rhs.key_id < lhs.key_id)
    return false;
  if (lhs.iv < rhs.iv)
    return true;
  if (rhs.iv < lhs.iv)
    return false;
  if (lhs.subsamples < rhs.subsamples)
    return true;
  if (rhs.subsamples < lhs.subsamples)
    return false;
  if (lhs.encryption_pattern < rhs.encryption_pattern)
    return true;
  if (rhs.encryption_pattern < lhs.encryption_pattern)
    return false;
  return false;
}
template <typename StructPtrType>
ColorVolumeMetadataPtr ColorVolumeMetadata::Clone() const {
  return New(
      mojo::Clone(primary_r),
      mojo::Clone(primary_g),
      mojo::Clone(primary_b),
      mojo::Clone(white_point),
      mojo::Clone(luminance_max),
      mojo::Clone(luminance_min)
  );
}

template <typename T, ColorVolumeMetadata::EnableIfSame<T>*>
bool ColorVolumeMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary_r, other_struct.primary_r))
    return false;
  if (!mojo::Equals(this->primary_g, other_struct.primary_g))
    return false;
  if (!mojo::Equals(this->primary_b, other_struct.primary_b))
    return false;
  if (!mojo::Equals(this->white_point, other_struct.white_point))
    return false;
  if (!mojo::Equals(this->luminance_max, other_struct.luminance_max))
    return false;
  if (!mojo::Equals(this->luminance_min, other_struct.luminance_min))
    return false;
  return true;
}

template <typename T, ColorVolumeMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primary_r < rhs.primary_r)
    return true;
  if (rhs.primary_r < lhs.primary_r)
    return false;
  if (lhs.primary_g < rhs.primary_g)
    return true;
  if (rhs.primary_g < lhs.primary_g)
    return false;
  if (lhs.primary_b < rhs.primary_b)
    return true;
  if (rhs.primary_b < lhs.primary_b)
    return false;
  if (lhs.white_point < rhs.white_point)
    return true;
  if (rhs.white_point < lhs.white_point)
    return false;
  if (lhs.luminance_max < rhs.luminance_max)
    return true;
  if (rhs.luminance_max < lhs.luminance_max)
    return false;
  if (lhs.luminance_min < rhs.luminance_min)
    return true;
  if (rhs.luminance_min < lhs.luminance_min)
    return false;
  return false;
}
template <typename StructPtrType>
HDRMetadataPtr HDRMetadata::Clone() const {
  return New(
      mojo::Clone(color_volume_metadata),
      mojo::Clone(max_content_light_level),
      mojo::Clone(max_frame_average_light_level)
  );
}

template <typename T, HDRMetadata::EnableIfSame<T>*>
bool HDRMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->color_volume_metadata, other_struct.color_volume_metadata))
    return false;
  if (!mojo::Equals(this->max_content_light_level, other_struct.max_content_light_level))
    return false;
  if (!mojo::Equals(this->max_frame_average_light_level, other_struct.max_frame_average_light_level))
    return false;
  return true;
}

template <typename T, HDRMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.color_volume_metadata < rhs.color_volume_metadata)
    return true;
  if (rhs.color_volume_metadata < lhs.color_volume_metadata)
    return false;
  if (lhs.max_content_light_level < rhs.max_content_light_level)
    return true;
  if (rhs.max_content_light_level < lhs.max_content_light_level)
    return false;
  if (lhs.max_frame_average_light_level < rhs.max_frame_average_light_level)
    return true;
  if (rhs.max_frame_average_light_level < lhs.max_frame_average_light_level)
    return false;
  return false;
}
template <typename StructPtrType>
VideoDecoderConfigPtr VideoDecoderConfig::Clone() const {
  return New(
      mojo::Clone(codec),
      mojo::Clone(profile),
      mojo::Clone(level),
      mojo::Clone(has_alpha),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(extra_data),
      mojo::Clone(encryption_scheme),
      mojo::Clone(color_space_info),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool VideoDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->codec, other_struct.codec))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  if (!mojo::Equals(this->level, other_struct.level))
    return false;
  if (!mojo::Equals(this->has_alpha, other_struct.has_alpha))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->extra_data, other_struct.extra_data))
    return false;
  if (!mojo::Equals(this->encryption_scheme, other_struct.encryption_scheme))
    return false;
  if (!mojo::Equals(this->color_space_info, other_struct.color_space_info))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.codec < rhs.codec)
    return true;
  if (rhs.codec < lhs.codec)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  if (lhs.level < rhs.level)
    return true;
  if (rhs.level < lhs.level)
    return false;
  if (lhs.has_alpha < rhs.has_alpha)
    return true;
  if (rhs.has_alpha < lhs.has_alpha)
    return false;
  if (lhs.coded_size < rhs.coded_size)
    return true;
  if (rhs.coded_size < lhs.coded_size)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.natural_size < rhs.natural_size)
    return true;
  if (rhs.natural_size < lhs.natural_size)
    return false;
  if (lhs.extra_data < rhs.extra_data)
    return true;
  if (rhs.extra_data < lhs.extra_data)
    return false;
  if (lhs.encryption_scheme < rhs.encryption_scheme)
    return true;
  if (rhs.encryption_scheme < lhs.encryption_scheme)
    return false;
  if (lhs.color_space_info < rhs.color_space_info)
    return true;
  if (rhs.color_space_info < lhs.color_space_info)
    return false;
  if (lhs.hdr_metadata < rhs.hdr_metadata)
    return true;
  if (rhs.hdr_metadata < lhs.hdr_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
SupportedVideoDecoderConfigPtr SupportedVideoDecoderConfig::Clone() const {
  return New(
      mojo::Clone(profile_min),
      mojo::Clone(profile_max),
      mojo::Clone(coded_size_min),
      mojo::Clone(coded_size_max),
      mojo::Clone(allow_encrypted),
      mojo::Clone(require_encrypted)
  );
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>*>
bool SupportedVideoDecoderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->profile_min, other_struct.profile_min))
    return false;
  if (!mojo::Equals(this->profile_max, other_struct.profile_max))
    return false;
  if (!mojo::Equals(this->coded_size_min, other_struct.coded_size_min))
    return false;
  if (!mojo::Equals(this->coded_size_max, other_struct.coded_size_max))
    return false;
  if (!mojo::Equals(this->allow_encrypted, other_struct.allow_encrypted))
    return false;
  if (!mojo::Equals(this->require_encrypted, other_struct.require_encrypted))
    return false;
  return true;
}

template <typename T, SupportedVideoDecoderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.profile_min < rhs.profile_min)
    return true;
  if (rhs.profile_min < lhs.profile_min)
    return false;
  if (lhs.profile_max < rhs.profile_max)
    return true;
  if (rhs.profile_max < lhs.profile_max)
    return false;
  if (lhs.coded_size_min < rhs.coded_size_min)
    return true;
  if (rhs.coded_size_min < lhs.coded_size_min)
    return false;
  if (lhs.coded_size_max < rhs.coded_size_max)
    return true;
  if (rhs.coded_size_max < lhs.coded_size_max)
    return false;
  if (lhs.allow_encrypted < rhs.allow_encrypted)
    return true;
  if (rhs.allow_encrypted < lhs.allow_encrypted)
    return false;
  if (lhs.require_encrypted < rhs.require_encrypted)
    return true;
  if (rhs.require_encrypted < lhs.require_encrypted)
    return false;
  return false;
}
template <typename StructPtrType>
StatusDataPtr StatusData::Clone() const {
  return New(
      mojo::Clone(group),
      mojo::Clone(code),
      mojo::Clone(message),
      mojo::Clone(frames),
      mojo::Clone(cause),
      mojo::Clone(data)
  );
}

template <typename T, StatusData::EnableIfSame<T>*>
bool StatusData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group, other_struct.group))
    return false;
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->message, other_struct.message))
    return false;
  if (!mojo::Equals(this->frames, other_struct.frames))
    return false;
  if (!mojo::Equals(this->cause, other_struct.cause))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, StatusData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group < rhs.group)
    return true;
  if (rhs.group < lhs.group)
    return false;
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.message < rhs.message)
    return true;
  if (rhs.message < lhs.message)
    return false;
  if (lhs.frames < rhs.frames)
    return true;
  if (rhs.frames < lhs.frames)
    return false;
  if (lhs.cause < rhs.cause)
    return true;
  if (rhs.cause < lhs.cause)
    return false;
  if (lhs.data < rhs.data)
    return true;
  if (rhs.data < lhs.data)
    return false;
  return false;
}
template <typename StructPtrType>
StatusPtr Status::Clone() const {
  return New(
      mojo::Clone(internal)
  );
}

template <typename T, Status::EnableIfSame<T>*>
bool Status::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->internal, other_struct.internal))
    return false;
  return true;
}

template <typename T, Status::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.internal < rhs.internal)
    return true;
  if (rhs.internal < lhs.internal)
    return false;
  return false;
}
template <typename StructPtrType>
DecoderBufferSideDataPtr DecoderBufferSideData::Clone() const {
  return New(
      mojo::Clone(spatial_layers),
      mojo::Clone(alpha_data),
      mojo::Clone(secure_handle)
  );
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>*>
bool DecoderBufferSideData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->spatial_layers, other_struct.spatial_layers))
    return false;
  if (!mojo::Equals(this->alpha_data, other_struct.alpha_data))
    return false;
  if (!mojo::Equals(this->secure_handle, other_struct.secure_handle))
    return false;
  return true;
}

template <typename T, DecoderBufferSideData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.spatial_layers < rhs.spatial_layers)
    return true;
  if (rhs.spatial_layers < lhs.spatial_layers)
    return false;
  if (lhs.alpha_data < rhs.alpha_data)
    return true;
  if (rhs.alpha_data < lhs.alpha_data)
    return false;
  if (lhs.secure_handle < rhs.secure_handle)
    return true;
  if (rhs.secure_handle < lhs.secure_handle)
    return false;
  return false;
}
template <typename StructPtrType>
DecoderBufferPtr DecoderBuffer::Clone() const {
  return New(
      mojo::Clone(timestamp),
      mojo::Clone(duration),
      mojo::Clone(is_end_of_stream),
      mojo::Clone(data_size),
      mojo::Clone(is_key_frame),
      mojo::Clone(raw_side_data),
      mojo::Clone(decrypt_config),
      mojo::Clone(front_discard),
      mojo::Clone(back_discard),
      mojo::Clone(side_data)
  );
}

template <typename T, DecoderBuffer::EnableIfSame<T>*>
bool DecoderBuffer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->is_end_of_stream, other_struct.is_end_of_stream))
    return false;
  if (!mojo::Equals(this->data_size, other_struct.data_size))
    return false;
  if (!mojo::Equals(this->is_key_frame, other_struct.is_key_frame))
    return false;
  if (!mojo::Equals(this->raw_side_data, other_struct.raw_side_data))
    return false;
  if (!mojo::Equals(this->decrypt_config, other_struct.decrypt_config))
    return false;
  if (!mojo::Equals(this->front_discard, other_struct.front_discard))
    return false;
  if (!mojo::Equals(this->back_discard, other_struct.back_discard))
    return false;
  if (!mojo::Equals(this->side_data, other_struct.side_data))
    return false;
  return true;
}

template <typename T, DecoderBuffer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.duration < rhs.duration)
    return true;
  if (rhs.duration < lhs.duration)
    return false;
  if (lhs.is_end_of_stream < rhs.is_end_of_stream)
    return true;
  if (rhs.is_end_of_stream < lhs.is_end_of_stream)
    return false;
  if (lhs.data_size < rhs.data_size)
    return true;
  if (rhs.data_size < lhs.data_size)
    return false;
  if (lhs.is_key_frame < rhs.is_key_frame)
    return true;
  if (rhs.is_key_frame < lhs.is_key_frame)
    return false;
  if (lhs.raw_side_data < rhs.raw_side_data)
    return true;
  if (rhs.raw_side_data < lhs.raw_side_data)
    return false;
  if (lhs.decrypt_config < rhs.decrypt_config)
    return true;
  if (rhs.decrypt_config < lhs.decrypt_config)
    return false;
  if (lhs.front_discard < rhs.front_discard)
    return true;
  if (rhs.front_discard < lhs.front_discard)
    return false;
  if (lhs.back_discard < rhs.back_discard)
    return true;
  if (rhs.back_discard < lhs.back_discard)
    return false;
  if (lhs.side_data < rhs.side_data)
    return true;
  if (rhs.side_data < lhs.side_data)
    return false;
  return false;
}
template <typename StructPtrType>
ColorSpacePtr ColorSpace::Clone() const {
  return New(
      mojo::Clone(primaries),
      mojo::Clone(transfer),
      mojo::Clone(matrix),
      mojo::Clone(range),
      mojo::Clone(custom_primary_matrix),
      mojo::Clone(transfer_params)
  );
}

template <typename T, ColorSpace::EnableIfSame<T>*>
bool ColorSpace::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primaries, other_struct.primaries))
    return false;
  if (!mojo::Equals(this->transfer, other_struct.transfer))
    return false;
  if (!mojo::Equals(this->matrix, other_struct.matrix))
    return false;
  if (!mojo::Equals(this->range, other_struct.range))
    return false;
  if (!mojo::Equals(this->custom_primary_matrix, other_struct.custom_primary_matrix))
    return false;
  if (!mojo::Equals(this->transfer_params, other_struct.transfer_params))
    return false;
  return true;
}

template <typename T, ColorSpace::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primaries < rhs.primaries)
    return true;
  if (rhs.primaries < lhs.primaries)
    return false;
  if (lhs.transfer < rhs.transfer)
    return true;
  if (rhs.transfer < lhs.transfer)
    return false;
  if (lhs.matrix < rhs.matrix)
    return true;
  if (rhs.matrix < lhs.matrix)
    return false;
  if (lhs.range < rhs.range)
    return true;
  if (rhs.range < lhs.range)
    return false;
  if (lhs.custom_primary_matrix < rhs.custom_primary_matrix)
    return true;
  if (rhs.custom_primary_matrix < lhs.custom_primary_matrix)
    return false;
  if (lhs.transfer_params < rhs.transfer_params)
    return true;
  if (rhs.transfer_params < lhs.transfer_params)
    return false;
  return false;
}
template <typename StructPtrType>
NativeGpuMemoryBufferHandlePtr NativeGpuMemoryBufferHandle::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(platform_handle)
  );
}

template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>*>
bool NativeGpuMemoryBufferHandle::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->platform_handle, other_struct.platform_handle))
    return false;
  return true;
}

template <typename T, NativeGpuMemoryBufferHandle::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.platform_handle < rhs.platform_handle)
    return true;
  if (rhs.platform_handle < lhs.platform_handle)
    return false;
  return false;
}
template <typename StructPtrType>
VideoFrameMetadataPtr VideoFrameMetadata::Clone() const {
  return New(
      mojo::Clone(protected_video),
      mojo::Clone(hw_protected),
      mojo::Clone(needs_detiling)
  );
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool VideoFrameMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->protected_video, other_struct.protected_video))
    return false;
  if (!mojo::Equals(this->hw_protected, other_struct.hw_protected))
    return false;
  if (!mojo::Equals(this->needs_detiling, other_struct.needs_detiling))
    return false;
  return true;
}

template <typename T, VideoFrameMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.protected_video < rhs.protected_video)
    return true;
  if (rhs.protected_video < lhs.protected_video)
    return false;
  if (lhs.hw_protected < rhs.hw_protected)
    return true;
  if (rhs.hw_protected < lhs.hw_protected)
    return false;
  if (lhs.needs_detiling < rhs.needs_detiling)
    return true;
  if (rhs.needs_detiling < lhs.needs_detiling)
    return false;
  return false;
}
template <typename StructPtrType>
VideoFramePtr VideoFrame::Clone() const {
  return New(
      mojo::Clone(format),
      mojo::Clone(coded_size),
      mojo::Clone(visible_rect),
      mojo::Clone(natural_size),
      mojo::Clone(timestamp),
      mojo::Clone(gpu_memory_buffer_handle),
      mojo::Clone(metadata),
      mojo::Clone(color_space),
      mojo::Clone(hdr_metadata)
  );
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool VideoFrame::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  if (!mojo::Equals(this->coded_size, other_struct.coded_size))
    return false;
  if (!mojo::Equals(this->visible_rect, other_struct.visible_rect))
    return false;
  if (!mojo::Equals(this->natural_size, other_struct.natural_size))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->gpu_memory_buffer_handle, other_struct.gpu_memory_buffer_handle))
    return false;
  if (!mojo::Equals(this->metadata, other_struct.metadata))
    return false;
  if (!mojo::Equals(this->color_space, other_struct.color_space))
    return false;
  if (!mojo::Equals(this->hdr_metadata, other_struct.hdr_metadata))
    return false;
  return true;
}

template <typename T, VideoFrame::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  if (lhs.coded_size < rhs.coded_size)
    return true;
  if (rhs.coded_size < lhs.coded_size)
    return false;
  if (lhs.visible_rect < rhs.visible_rect)
    return true;
  if (rhs.visible_rect < lhs.visible_rect)
    return false;
  if (lhs.natural_size < rhs.natural_size)
    return true;
  if (rhs.natural_size < lhs.natural_size)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.gpu_memory_buffer_handle < rhs.gpu_memory_buffer_handle)
    return true;
  if (rhs.gpu_memory_buffer_handle < lhs.gpu_memory_buffer_handle)
    return false;
  if (lhs.metadata < rhs.metadata)
    return true;
  if (rhs.metadata < lhs.metadata)
    return false;
  if (lhs.color_space < rhs.color_space)
    return true;
  if (rhs.color_space < lhs.color_space)
    return false;
  if (lhs.hdr_metadata < rhs.hdr_metadata)
    return true;
  if (rhs.hdr_metadata < lhs.hdr_metadata)
    return false;
  return false;
}
template <typename StructPtrType>
MediaLogRecordPtr MediaLogRecord::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(type),
      mojo::Clone(params),
      mojo::Clone(time)
  );
}

template <typename T, MediaLogRecord::EnableIfSame<T>*>
bool MediaLogRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->params, other_struct.params))
    return false;
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  return true;
}

template <typename T, MediaLogRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.params < rhs.params)
    return true;
  if (rhs.params < lhs.params)
    return false;
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  return false;
}


}  // media::stable::mojom

namespace mojo {


template <>
struct  StructTraits<::media::stable::mojom::SubsampleEntry::DataView,
                                         ::media::stable::mojom::SubsampleEntryPtr> {
  static bool IsNull(const ::media::stable::mojom::SubsampleEntryPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::SubsampleEntryPtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::SubsampleEntry::clear_bytes) clear_bytes(
      const ::media::stable::mojom::SubsampleEntryPtr& input) {
    return input->clear_bytes;
  }

  static decltype(::media::stable::mojom::SubsampleEntry::cypher_bytes) cypher_bytes(
      const ::media::stable::mojom::SubsampleEntryPtr& input) {
    return input->cypher_bytes;
  }

  static bool Read(::media::stable::mojom::SubsampleEntry::DataView input, ::media::stable::mojom::SubsampleEntryPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::DecryptConfig::DataView,
                                         ::media::stable::mojom::DecryptConfigPtr> {
  static bool IsNull(const ::media::stable::mojom::DecryptConfigPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::DecryptConfigPtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::DecryptConfig::encryption_scheme) encryption_scheme(
      const ::media::stable::mojom::DecryptConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::stable::mojom::DecryptConfig::key_id)& key_id(
      const ::media::stable::mojom::DecryptConfigPtr& input) {
    return input->key_id;
  }

  static const decltype(::media::stable::mojom::DecryptConfig::iv)& iv(
      const ::media::stable::mojom::DecryptConfigPtr& input) {
    return input->iv;
  }

  static const decltype(::media::stable::mojom::DecryptConfig::subsamples)& subsamples(
      const ::media::stable::mojom::DecryptConfigPtr& input) {
    return input->subsamples;
  }

  static const decltype(::media::stable::mojom::DecryptConfig::encryption_pattern)& encryption_pattern(
      const ::media::stable::mojom::DecryptConfigPtr& input) {
    return input->encryption_pattern;
  }

  static bool Read(::media::stable::mojom::DecryptConfig::DataView input, ::media::stable::mojom::DecryptConfigPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::ColorVolumeMetadata::DataView,
                                         ::media::stable::mojom::ColorVolumeMetadataPtr> {
  static bool IsNull(const ::media::stable::mojom::ColorVolumeMetadataPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::ColorVolumeMetadataPtr* output) { output->reset(); }

  static const decltype(::media::stable::mojom::ColorVolumeMetadata::primary_r)& primary_r(
      const ::media::stable::mojom::ColorVolumeMetadataPtr& input) {
    return input->primary_r;
  }

  static const decltype(::media::stable::mojom::ColorVolumeMetadata::primary_g)& primary_g(
      const ::media::stable::mojom::ColorVolumeMetadataPtr& input) {
    return input->primary_g;
  }

  static const decltype(::media::stable::mojom::ColorVolumeMetadata::primary_b)& primary_b(
      const ::media::stable::mojom::ColorVolumeMetadataPtr& input) {
    return input->primary_b;
  }

  static const decltype(::media::stable::mojom::ColorVolumeMetadata::white_point)& white_point(
      const ::media::stable::mojom::ColorVolumeMetadataPtr& input) {
    return input->white_point;
  }

  static decltype(::media::stable::mojom::ColorVolumeMetadata::luminance_max) luminance_max(
      const ::media::stable::mojom::ColorVolumeMetadataPtr& input) {
    return input->luminance_max;
  }

  static decltype(::media::stable::mojom::ColorVolumeMetadata::luminance_min) luminance_min(
      const ::media::stable::mojom::ColorVolumeMetadataPtr& input) {
    return input->luminance_min;
  }

  static bool Read(::media::stable::mojom::ColorVolumeMetadata::DataView input, ::media::stable::mojom::ColorVolumeMetadataPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::HDRMetadata::DataView,
                                         ::media::stable::mojom::HDRMetadataPtr> {
  static bool IsNull(const ::media::stable::mojom::HDRMetadataPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::HDRMetadataPtr* output) { output->reset(); }

  static const decltype(::media::stable::mojom::HDRMetadata::color_volume_metadata)& color_volume_metadata(
      const ::media::stable::mojom::HDRMetadataPtr& input) {
    return input->color_volume_metadata;
  }

  static decltype(::media::stable::mojom::HDRMetadata::max_content_light_level) max_content_light_level(
      const ::media::stable::mojom::HDRMetadataPtr& input) {
    return input->max_content_light_level;
  }

  static decltype(::media::stable::mojom::HDRMetadata::max_frame_average_light_level) max_frame_average_light_level(
      const ::media::stable::mojom::HDRMetadataPtr& input) {
    return input->max_frame_average_light_level;
  }

  static bool Read(::media::stable::mojom::HDRMetadata::DataView input, ::media::stable::mojom::HDRMetadataPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::VideoDecoderConfig::DataView,
                                         ::media::stable::mojom::VideoDecoderConfigPtr> {
  static bool IsNull(const ::media::stable::mojom::VideoDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::VideoDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::VideoDecoderConfig::codec) codec(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->codec;
  }

  static decltype(::media::stable::mojom::VideoDecoderConfig::profile) profile(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->profile;
  }

  static decltype(::media::stable::mojom::VideoDecoderConfig::level) level(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->level;
  }

  static decltype(::media::stable::mojom::VideoDecoderConfig::has_alpha) has_alpha(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->has_alpha;
  }

  static const decltype(::media::stable::mojom::VideoDecoderConfig::coded_size)& coded_size(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::stable::mojom::VideoDecoderConfig::visible_rect)& visible_rect(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::stable::mojom::VideoDecoderConfig::natural_size)& natural_size(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::stable::mojom::VideoDecoderConfig::extra_data)& extra_data(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->extra_data;
  }

  static decltype(::media::stable::mojom::VideoDecoderConfig::encryption_scheme) encryption_scheme(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->encryption_scheme;
  }

  static const decltype(::media::stable::mojom::VideoDecoderConfig::color_space_info)& color_space_info(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->color_space_info;
  }

  static const decltype(::media::stable::mojom::VideoDecoderConfig::hdr_metadata)& hdr_metadata(
      const ::media::stable::mojom::VideoDecoderConfigPtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::stable::mojom::VideoDecoderConfig::DataView input, ::media::stable::mojom::VideoDecoderConfigPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::SupportedVideoDecoderConfig::DataView,
                                         ::media::stable::mojom::SupportedVideoDecoderConfigPtr> {
  static bool IsNull(const ::media::stable::mojom::SupportedVideoDecoderConfigPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::SupportedVideoDecoderConfigPtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::SupportedVideoDecoderConfig::profile_min) profile_min(
      const ::media::stable::mojom::SupportedVideoDecoderConfigPtr& input) {
    return input->profile_min;
  }

  static decltype(::media::stable::mojom::SupportedVideoDecoderConfig::profile_max) profile_max(
      const ::media::stable::mojom::SupportedVideoDecoderConfigPtr& input) {
    return input->profile_max;
  }

  static const decltype(::media::stable::mojom::SupportedVideoDecoderConfig::coded_size_min)& coded_size_min(
      const ::media::stable::mojom::SupportedVideoDecoderConfigPtr& input) {
    return input->coded_size_min;
  }

  static const decltype(::media::stable::mojom::SupportedVideoDecoderConfig::coded_size_max)& coded_size_max(
      const ::media::stable::mojom::SupportedVideoDecoderConfigPtr& input) {
    return input->coded_size_max;
  }

  static decltype(::media::stable::mojom::SupportedVideoDecoderConfig::allow_encrypted) allow_encrypted(
      const ::media::stable::mojom::SupportedVideoDecoderConfigPtr& input) {
    return input->allow_encrypted;
  }

  static decltype(::media::stable::mojom::SupportedVideoDecoderConfig::require_encrypted) require_encrypted(
      const ::media::stable::mojom::SupportedVideoDecoderConfigPtr& input) {
    return input->require_encrypted;
  }

  static bool Read(::media::stable::mojom::SupportedVideoDecoderConfig::DataView input, ::media::stable::mojom::SupportedVideoDecoderConfigPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::StatusData::DataView,
                                         ::media::stable::mojom::StatusDataPtr> {
  static bool IsNull(const ::media::stable::mojom::StatusDataPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::StatusDataPtr* output) { output->reset(); }

  static const decltype(::media::stable::mojom::StatusData::group)& group(
      const ::media::stable::mojom::StatusDataPtr& input) {
    return input->group;
  }

  static decltype(::media::stable::mojom::StatusData::code) code(
      const ::media::stable::mojom::StatusDataPtr& input) {
    return input->code;
  }

  static const decltype(::media::stable::mojom::StatusData::message)& message(
      const ::media::stable::mojom::StatusDataPtr& input) {
    return input->message;
  }

  static const decltype(::media::stable::mojom::StatusData::frames)& frames(
      const ::media::stable::mojom::StatusDataPtr& input) {
    return input->frames;
  }

  static const decltype(::media::stable::mojom::StatusData::cause)& cause(
      const ::media::stable::mojom::StatusDataPtr& input) {
    return input->cause;
  }

  static const decltype(::media::stable::mojom::StatusData::data)& data(
      const ::media::stable::mojom::StatusDataPtr& input) {
    return input->data;
  }

  static bool Read(::media::stable::mojom::StatusData::DataView input, ::media::stable::mojom::StatusDataPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::Status::DataView,
                                         ::media::stable::mojom::StatusPtr> {
  static bool IsNull(const ::media::stable::mojom::StatusPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::StatusPtr* output) { output->reset(); }

  static const decltype(::media::stable::mojom::Status::internal)& internal(
      const ::media::stable::mojom::StatusPtr& input) {
    return input->internal;
  }

  static bool Read(::media::stable::mojom::Status::DataView input, ::media::stable::mojom::StatusPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::DecoderBufferSideData::DataView,
                                         ::media::stable::mojom::DecoderBufferSideDataPtr> {
  static bool IsNull(const ::media::stable::mojom::DecoderBufferSideDataPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::DecoderBufferSideDataPtr* output) { output->reset(); }

  static const decltype(::media::stable::mojom::DecoderBufferSideData::spatial_layers)& spatial_layers(
      const ::media::stable::mojom::DecoderBufferSideDataPtr& input) {
    return input->spatial_layers;
  }

  static const decltype(::media::stable::mojom::DecoderBufferSideData::alpha_data)& alpha_data(
      const ::media::stable::mojom::DecoderBufferSideDataPtr& input) {
    return input->alpha_data;
  }

  static decltype(::media::stable::mojom::DecoderBufferSideData::secure_handle) secure_handle(
      const ::media::stable::mojom::DecoderBufferSideDataPtr& input) {
    return input->secure_handle;
  }

  static bool Read(::media::stable::mojom::DecoderBufferSideData::DataView input, ::media::stable::mojom::DecoderBufferSideDataPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::DecoderBuffer::DataView,
                                         ::media::stable::mojom::DecoderBufferPtr> {
  static bool IsNull(const ::media::stable::mojom::DecoderBufferPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::DecoderBufferPtr* output) { output->reset(); }

  static const decltype(::media::stable::mojom::DecoderBuffer::timestamp)& timestamp(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->timestamp;
  }

  static const decltype(::media::stable::mojom::DecoderBuffer::duration)& duration(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->duration;
  }

  static decltype(::media::stable::mojom::DecoderBuffer::is_end_of_stream) is_end_of_stream(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->is_end_of_stream;
  }

  static decltype(::media::stable::mojom::DecoderBuffer::data_size) data_size(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->data_size;
  }

  static decltype(::media::stable::mojom::DecoderBuffer::is_key_frame) is_key_frame(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->is_key_frame;
  }

  static const decltype(::media::stable::mojom::DecoderBuffer::raw_side_data)& raw_side_data(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->raw_side_data;
  }

  static const decltype(::media::stable::mojom::DecoderBuffer::decrypt_config)& decrypt_config(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->decrypt_config;
  }

  static const decltype(::media::stable::mojom::DecoderBuffer::front_discard)& front_discard(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->front_discard;
  }

  static const decltype(::media::stable::mojom::DecoderBuffer::back_discard)& back_discard(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->back_discard;
  }

  static const decltype(::media::stable::mojom::DecoderBuffer::side_data)& side_data(
      const ::media::stable::mojom::DecoderBufferPtr& input) {
    return input->side_data;
  }

  static bool Read(::media::stable::mojom::DecoderBuffer::DataView input, ::media::stable::mojom::DecoderBufferPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::ColorSpace::DataView,
                                         ::media::stable::mojom::ColorSpacePtr> {
  static bool IsNull(const ::media::stable::mojom::ColorSpacePtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::ColorSpacePtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::ColorSpace::primaries) primaries(
      const ::media::stable::mojom::ColorSpacePtr& input) {
    return input->primaries;
  }

  static decltype(::media::stable::mojom::ColorSpace::transfer) transfer(
      const ::media::stable::mojom::ColorSpacePtr& input) {
    return input->transfer;
  }

  static decltype(::media::stable::mojom::ColorSpace::matrix) matrix(
      const ::media::stable::mojom::ColorSpacePtr& input) {
    return input->matrix;
  }

  static decltype(::media::stable::mojom::ColorSpace::range) range(
      const ::media::stable::mojom::ColorSpacePtr& input) {
    return input->range;
  }

  static const decltype(::media::stable::mojom::ColorSpace::custom_primary_matrix)& custom_primary_matrix(
      const ::media::stable::mojom::ColorSpacePtr& input) {
    return input->custom_primary_matrix;
  }

  static const decltype(::media::stable::mojom::ColorSpace::transfer_params)& transfer_params(
      const ::media::stable::mojom::ColorSpacePtr& input) {
    return input->transfer_params;
  }

  static bool Read(::media::stable::mojom::ColorSpace::DataView input, ::media::stable::mojom::ColorSpacePtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::NativeGpuMemoryBufferHandle::DataView,
                                         ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr> {
  static bool IsNull(const ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::NativeGpuMemoryBufferHandlePtr* output) { output->reset(); }

  static const decltype(::media::stable::mojom::NativeGpuMemoryBufferHandle::id)& id(
      const ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr& input) {
    return input->id;
  }

  static  decltype(::media::stable::mojom::NativeGpuMemoryBufferHandle::platform_handle)& platform_handle(
       ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr& input) {
    return input->platform_handle;
  }

  static bool Read(::media::stable::mojom::NativeGpuMemoryBufferHandle::DataView input, ::media::stable::mojom::NativeGpuMemoryBufferHandlePtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::VideoFrameMetadata::DataView,
                                         ::media::stable::mojom::VideoFrameMetadataPtr> {
  static bool IsNull(const ::media::stable::mojom::VideoFrameMetadataPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::VideoFrameMetadataPtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::VideoFrameMetadata::protected_video) protected_video(
      const ::media::stable::mojom::VideoFrameMetadataPtr& input) {
    return input->protected_video;
  }

  static decltype(::media::stable::mojom::VideoFrameMetadata::hw_protected) hw_protected(
      const ::media::stable::mojom::VideoFrameMetadataPtr& input) {
    return input->hw_protected;
  }

  static decltype(::media::stable::mojom::VideoFrameMetadata::needs_detiling) needs_detiling(
      const ::media::stable::mojom::VideoFrameMetadataPtr& input) {
    return input->needs_detiling;
  }

  static bool Read(::media::stable::mojom::VideoFrameMetadata::DataView input, ::media::stable::mojom::VideoFrameMetadataPtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::VideoFrame::DataView,
                                         ::media::stable::mojom::VideoFramePtr> {
  static bool IsNull(const ::media::stable::mojom::VideoFramePtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::VideoFramePtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::VideoFrame::format) format(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->format;
  }

  static const decltype(::media::stable::mojom::VideoFrame::coded_size)& coded_size(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->coded_size;
  }

  static const decltype(::media::stable::mojom::VideoFrame::visible_rect)& visible_rect(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->visible_rect;
  }

  static const decltype(::media::stable::mojom::VideoFrame::natural_size)& natural_size(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->natural_size;
  }

  static const decltype(::media::stable::mojom::VideoFrame::timestamp)& timestamp(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->timestamp;
  }

  static  decltype(::media::stable::mojom::VideoFrame::gpu_memory_buffer_handle)& gpu_memory_buffer_handle(
       ::media::stable::mojom::VideoFramePtr& input) {
    return input->gpu_memory_buffer_handle;
  }

  static const decltype(::media::stable::mojom::VideoFrame::metadata)& metadata(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->metadata;
  }

  static const decltype(::media::stable::mojom::VideoFrame::color_space)& color_space(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->color_space;
  }

  static const decltype(::media::stable::mojom::VideoFrame::hdr_metadata)& hdr_metadata(
      const ::media::stable::mojom::VideoFramePtr& input) {
    return input->hdr_metadata;
  }

  static bool Read(::media::stable::mojom::VideoFrame::DataView input, ::media::stable::mojom::VideoFramePtr* output);
};


template <>
struct  StructTraits<::media::stable::mojom::MediaLogRecord::DataView,
                                         ::media::stable::mojom::MediaLogRecordPtr> {
  static bool IsNull(const ::media::stable::mojom::MediaLogRecordPtr& input) { return !input; }
  static void SetToNull(::media::stable::mojom::MediaLogRecordPtr* output) { output->reset(); }

  static decltype(::media::stable::mojom::MediaLogRecord::id) id(
      const ::media::stable::mojom::MediaLogRecordPtr& input) {
    return input->id;
  }

  static decltype(::media::stable::mojom::MediaLogRecord::type) type(
      const ::media::stable::mojom::MediaLogRecordPtr& input) {
    return input->type;
  }

  static const decltype(::media::stable::mojom::MediaLogRecord::params)& params(
      const ::media::stable::mojom::MediaLogRecordPtr& input) {
    return input->params;
  }

  static const decltype(::media::stable::mojom::MediaLogRecord::time)& time(
      const ::media::stable::mojom::MediaLogRecordPtr& input) {
    return input->time;
  }

  static bool Read(::media::stable::mojom::MediaLogRecord::DataView input, ::media::stable::mojom::MediaLogRecordPtr* output);
};

}  // namespace mojo

#endif  // MEDIA_MOJO_MOJOM_STABLE_STABLE_VIDEO_DECODER_TYPES_MOJOM_H_