// extensions/common/mojom/renderer_host.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "extensions/common/mojom/renderer_host.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "extensions/common/mojom/renderer_host.mojom-params-data.h"
#include "extensions/common/mojom/renderer_host.mojom-shared-message-ids.h"

#include "extensions/common/mojom/renderer_host.mojom-import-headers.h"
#include "extensions/common/mojom/renderer_host.mojom-test-utils.h"


namespace extensions::mojom {
const char RendererHost::Name_[] = "extensions.mojom.RendererHost";

RendererHost::IPCStableHashFunction RendererHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RendererHost>(message.name())) {
    case messages::RendererHost::kAddAPIActionToActivityLog: {
      return &RendererHost::AddAPIActionToActivityLog_Sym::IPCStableHash;
    }
    case messages::RendererHost::kAddEventToActivityLog: {
      return &RendererHost::AddEventToActivityLog_Sym::IPCStableHash;
    }
    case messages::RendererHost::kAddDOMActionToActivityLog: {
      return &RendererHost::AddDOMActionToActivityLog_Sym::IPCStableHash;
    }
    case messages::RendererHost::kGetMessageBundle: {
      return &RendererHost::GetMessageBundle_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RendererHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RendererHost>(message.name())) {
      case messages::RendererHost::kAddAPIActionToActivityLog:
            return "Receive extensions::mojom::RendererHost::AddAPIActionToActivityLog";
      case messages::RendererHost::kAddEventToActivityLog:
            return "Receive extensions::mojom::RendererHost::AddEventToActivityLog";
      case messages::RendererHost::kAddDOMActionToActivityLog:
            return "Receive extensions::mojom::RendererHost::AddDOMActionToActivityLog";
      case messages::RendererHost::kGetMessageBundle:
            return "Receive extensions::mojom::RendererHost::GetMessageBundle";
    }
  } else {
    switch (static_cast<messages::RendererHost>(message.name())) {
      case messages::RendererHost::kAddAPIActionToActivityLog:
            return "Receive reply extensions::mojom::RendererHost::AddAPIActionToActivityLog";
      case messages::RendererHost::kAddEventToActivityLog:
            return "Receive reply extensions::mojom::RendererHost::AddEventToActivityLog";
      case messages::RendererHost::kAddDOMActionToActivityLog:
            return "Receive reply extensions::mojom::RendererHost::AddDOMActionToActivityLog";
      case messages::RendererHost::kGetMessageBundle:
            return "Receive reply extensions::mojom::RendererHost::GetMessageBundle";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RendererHost::AddAPIActionToActivityLog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::RendererHost::AddAPIActionToActivityLog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererHost::AddEventToActivityLog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::RendererHost::AddEventToActivityLog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererHost::AddDOMActionToActivityLog_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::RendererHost::AddDOMActionToActivityLog");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RendererHost::GetMessageBundle_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)extensions::mojom::RendererHost::GetMessageBundle");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool RendererHost::GetMessageBundle(const std::string& extension_id, base::flat_map<std::string, std::string>* out_message_map) {
  NOTREACHED();
}
class RendererHost_GetMessageBundle_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RendererHost_GetMessageBundle_HandleSyncResponse(
      bool* result, base::flat_map<std::string, std::string>* out_message_map)
      : result_(result), out_message_map_(out_message_map) {
    DCHECK(!*result_);
  }

  RendererHost_GetMessageBundle_HandleSyncResponse(const RendererHost_GetMessageBundle_HandleSyncResponse&) = delete;
  RendererHost_GetMessageBundle_HandleSyncResponse& operator=(const RendererHost_GetMessageBundle_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  base::flat_map<std::string, std::string>* out_message_map_;};

class RendererHost_GetMessageBundle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RendererHost_GetMessageBundle_ForwardToCallback(
      RendererHost::GetMessageBundleCallback callback
      ) : callback_(std::move(callback)) {
  }

  RendererHost_GetMessageBundle_ForwardToCallback(const RendererHost_GetMessageBundle_ForwardToCallback&) = delete;
  RendererHost_GetMessageBundle_ForwardToCallback& operator=(const RendererHost_GetMessageBundle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RendererHost::GetMessageBundleCallback callback_;
};

RendererHostProxy::RendererHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RendererHostProxy::AddAPIActionToActivityLog(
    const std::string& in_extension_id, const std::string& in_call_name, ::base::Value::List in_args, const std::string& in_extra) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::RendererHost::AddAPIActionToActivityLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_name"), in_call_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type ::base::Value::List>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extra"), in_extra,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kAddAPIActionToActivityLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::RendererHost_AddAPIActionToActivityLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in RendererHost.AddAPIActionToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->call_name)::BaseType> call_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_call_name, call_name_fragment);
  params->call_name.Set(
      call_name_fragment.is_null() ? nullptr : call_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->call_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null call_name in RendererHost.AddAPIActionToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_args, args_fragment);
  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in RendererHost.AddAPIActionToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->extra)::BaseType> extra_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extra, extra_fragment);
  params->extra.Set(
      extra_fragment.is_null() ? nullptr : extra_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extra.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra in RendererHost.AddAPIActionToActivityLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("AddAPIActionToActivityLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererHostProxy::AddEventToActivityLog(
    const std::string& in_extension_id, const std::string& in_call_name, ::base::Value::List in_args, const std::string& in_extra) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::RendererHost::AddEventToActivityLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_name"), in_call_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type ::base::Value::List>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extra"), in_extra,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kAddEventToActivityLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::RendererHost_AddEventToActivityLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in RendererHost.AddEventToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->call_name)::BaseType> call_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_call_name, call_name_fragment);
  params->call_name.Set(
      call_name_fragment.is_null() ? nullptr : call_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->call_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null call_name in RendererHost.AddEventToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_args, args_fragment);
  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in RendererHost.AddEventToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->extra)::BaseType> extra_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extra, extra_fragment);
  params->extra.Set(
      extra_fragment.is_null() ? nullptr : extra_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extra.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extra in RendererHost.AddEventToActivityLog request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("AddEventToActivityLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RendererHostProxy::AddDOMActionToActivityLog(
    const std::string& in_extension_id, const std::string& in_call_name, ::base::Value::List in_args, const ::GURL& in_url, const ::std::u16string& in_url_title, int32_t in_call_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::RendererHost::AddDOMActionToActivityLog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_name"), in_call_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("args"), in_args,
                        "<value of type ::base::Value::List>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url_title"), in_url_title,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("call_type"), in_call_type,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kAddDOMActionToActivityLog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::RendererHost_AddDOMActionToActivityLog_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in RendererHost.AddDOMActionToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->call_name)::BaseType> call_name_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_call_name, call_name_fragment);
  params->call_name.Set(
      call_name_fragment.is_null() ? nullptr : call_name_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->call_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null call_name in RendererHost.AddDOMActionToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->args)::BaseType> args_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::ListValueDataView>(
      in_args, args_fragment);
  params->args.Set(
      args_fragment.is_null() ? nullptr : args_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->args.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null args in RendererHost.AddDOMActionToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, url_fragment);
  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RendererHost.AddDOMActionToActivityLog request");
  mojo::internal::MessageFragment<
      typename decltype(params->url_title)::BaseType> url_title_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_url_title, url_title_fragment);
  params->url_title.Set(
      url_title_fragment.is_null() ? nullptr : url_title_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url_title.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_title in RendererHost.AddDOMActionToActivityLog request");
  params->call_type = in_call_type;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("AddDOMActionToActivityLog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool RendererHostProxy::GetMessageBundle(
    const std::string& param_extension_id, base::flat_map<std::string, std::string>* out_param_message_map) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call extensions::mojom::RendererHost::GetMessageBundle (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), param_extension_id,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "RendererHost::GetMessageBundle");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kGetMessageBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::RendererHost_GetMessageBundle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      param_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in RendererHost.GetMessageBundle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetMessageBundle");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_GetMessageBundle_HandleSyncResponse(
          &result, out_param_message_map));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RendererHost::GetMessageBundle", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_map"), out_param_message_map,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif
  return result;
}

void RendererHostProxy::GetMessageBundle(
    const std::string& in_extension_id, GetMessageBundleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send extensions::mojom::RendererHost::GetMessageBundle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension_id"), in_extension_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kGetMessageBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::RendererHost_GetMessageBundle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension_id)::BaseType> extension_id_fragment(
          params.message());
  mojo::internal::Serialize<mojo::StringDataView>(
      in_extension_id, extension_id_fragment);
  params->extension_id.Set(
      extension_id_fragment.is_null() ? nullptr : extension_id_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->extension_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null extension_id in RendererHost.GetMessageBundle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetMessageBundle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RendererHost_GetMessageBundle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RendererHost_GetMessageBundle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RendererHost::GetMessageBundleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RendererHost_GetMessageBundle_ProxyToResponder> proxy(
        new RendererHost_GetMessageBundle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RendererHost_GetMessageBundle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RendererHost_GetMessageBundle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RendererHost_GetMessageBundle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "RendererHost::GetMessageBundleCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<std::string, std::string>& in_message_map);
};

bool RendererHost_GetMessageBundle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RendererHost_GetMessageBundle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RendererHost_GetMessageBundle_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for RendererHost.3
  bool success = true;
  base::flat_map<std::string, std::string> p_message_map{};
  RendererHost_GetMessageBundle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMessageMap(&p_message_map))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_message_map));
  return true;
}

void RendererHost_GetMessageBundle_ProxyToResponder::Run(
    const base::flat_map<std::string, std::string>& in_message_map) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply extensions::mojom::RendererHost::GetMessageBundle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message_map"), in_message_map,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RendererHost::kGetMessageBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::extensions::mojom::internal::RendererHost_GetMessageBundle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message_map)::BaseType>
      message_map_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& message_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_message_map, message_map_fragment, &message_map_validate_params);
  params->message_map.Set(
      message_map_fragment.is_null() ? nullptr : message_map_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->message_map.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message_map in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RendererHost::Name_);
  message.set_method_name("GetMessageBundle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RendererHost_GetMessageBundle_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RendererHost_GetMessageBundle_ResponseParams_Data* params =
      reinterpret_cast<internal::RendererHost_GetMessageBundle_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for RendererHost.3
  bool success = true;
  base::flat_map<std::string, std::string> p_message_map{};
  RendererHost_GetMessageBundle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMessageMap(&p_message_map))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RendererHost::Name_, 3, true);
    return false;
  }
  *out_message_map_ = std::move(p_message_map);
  *result_ = true;
  return true;
}

// static
bool RendererHostStubDispatch::Accept(
    RendererHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RendererHost>(message->header()->name)) {
    case messages::RendererHost::kAddAPIActionToActivityLog: {
      DCHECK(message->is_serialized());
      internal::RendererHost_AddAPIActionToActivityLog_Params_Data* params =
          reinterpret_cast<internal::RendererHost_AddAPIActionToActivityLog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RendererHost.0
      bool success = true;
      std::string p_extension_id{};
      std::string p_call_name{};
      ::base::Value::List p_args{};
      std::string p_extra{};
      RendererHost_AddAPIActionToActivityLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadCallName(&p_call_name))
        success = false;
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadExtra(&p_extra))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddAPIActionToActivityLog(        
        std::move(p_extension_id), 
        std::move(p_call_name), 
        std::move(p_args), 
        std::move(p_extra));
      return true;
    }
    case messages::RendererHost::kAddEventToActivityLog: {
      DCHECK(message->is_serialized());
      internal::RendererHost_AddEventToActivityLog_Params_Data* params =
          reinterpret_cast<internal::RendererHost_AddEventToActivityLog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RendererHost.1
      bool success = true;
      std::string p_extension_id{};
      std::string p_call_name{};
      ::base::Value::List p_args{};
      std::string p_extra{};
      RendererHost_AddEventToActivityLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadCallName(&p_call_name))
        success = false;
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadExtra(&p_extra))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddEventToActivityLog(        
        std::move(p_extension_id), 
        std::move(p_call_name), 
        std::move(p_args), 
        std::move(p_extra));
      return true;
    }
    case messages::RendererHost::kAddDOMActionToActivityLog: {
      DCHECK(message->is_serialized());
      internal::RendererHost_AddDOMActionToActivityLog_Params_Data* params =
          reinterpret_cast<internal::RendererHost_AddDOMActionToActivityLog_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for RendererHost.2
      bool success = true;
      std::string p_extension_id{};
      std::string p_call_name{};
      ::base::Value::List p_args{};
      ::GURL p_url{};
      ::std::u16string p_url_title{};
      int32_t p_call_type{};
      RendererHost_AddDOMActionToActivityLog_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (success && !input_data_view.ReadCallName(&p_call_name))
        success = false;
      if (success && !input_data_view.ReadArgs(&p_args))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadUrlTitle(&p_url_title))
        success = false;
      if (success)
        p_call_type = input_data_view.call_type();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddDOMActionToActivityLog(        
        std::move(p_extension_id), 
        std::move(p_call_name), 
        std::move(p_args), 
        std::move(p_url), 
        std::move(p_url_title), 
        std::move(p_call_type));
      return true;
    }
    case messages::RendererHost::kGetMessageBundle: {
      break;
    }
  }
  return false;
}

// static
bool RendererHostStubDispatch::AcceptWithResponder(
    RendererHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RendererHost>(message->header()->name)) {
    case messages::RendererHost::kAddAPIActionToActivityLog: {
      break;
    }
    case messages::RendererHost::kAddEventToActivityLog: {
      break;
    }
    case messages::RendererHost::kAddDOMActionToActivityLog: {
      break;
    }
    case messages::RendererHost::kGetMessageBundle: {
      internal::RendererHost_GetMessageBundle_Params_Data* params =
          reinterpret_cast<
              internal::RendererHost_GetMessageBundle_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for RendererHost.3
      bool success = true;
      std::string p_extension_id{};
      RendererHost_GetMessageBundle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtensionId(&p_extension_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RendererHost::Name_, 3, false);
        return false;
      }
      RendererHost::GetMessageBundleCallback callback =
          RendererHost_GetMessageBundle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMessageBundle(        
        std::move(p_extension_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kRendererHostValidationInfo[] = {
    {base::to_underlying(messages::RendererHost::kAddAPIActionToActivityLog),
     { &internal::RendererHost_AddAPIActionToActivityLog_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RendererHost::kAddEventToActivityLog),
     { &internal::RendererHost_AddEventToActivityLog_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RendererHost::kAddDOMActionToActivityLog),
     { &internal::RendererHost_AddDOMActionToActivityLog_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::RendererHost::kGetMessageBundle),
     { &internal::RendererHost_GetMessageBundle_Params_Data::Validate,
      &internal::RendererHost_GetMessageBundle_ResponseParams_Data::Validate}},
};

bool RendererHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::RendererHost::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kRendererHostValidationInfo);
}

bool RendererHostResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::extensions::mojom::RendererHost::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kRendererHostValidationInfo);

}


}  // extensions::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace extensions::mojom {


void RendererHostInterceptorForTesting::AddAPIActionToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const std::string& extra) {
  GetForwardingInterface()->AddAPIActionToActivityLog(
    std::move(extension_id)
    , 
    std::move(call_name)
    , 
    std::move(args)
    , 
    std::move(extra)
    );
}
void RendererHostInterceptorForTesting::AddEventToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const std::string& extra) {
  GetForwardingInterface()->AddEventToActivityLog(
    std::move(extension_id)
    , 
    std::move(call_name)
    , 
    std::move(args)
    , 
    std::move(extra)
    );
}
void RendererHostInterceptorForTesting::AddDOMActionToActivityLog(const std::string& extension_id, const std::string& call_name, ::base::Value::List args, const ::GURL& url, const ::std::u16string& url_title, int32_t call_type) {
  GetForwardingInterface()->AddDOMActionToActivityLog(
    std::move(extension_id)
    , 
    std::move(call_name)
    , 
    std::move(args)
    , 
    std::move(url)
    , 
    std::move(url_title)
    , 
    std::move(call_type)
    );
}
void RendererHostInterceptorForTesting::GetMessageBundle(const std::string& extension_id, GetMessageBundleCallback callback) {
  GetForwardingInterface()->GetMessageBundle(
    std::move(extension_id)
    , std::move(callback));
}
RendererHostAsyncWaiter::RendererHostAsyncWaiter(
    RendererHost* proxy) : proxy_(proxy) {}

RendererHostAsyncWaiter::~RendererHostAsyncWaiter() = default;

void RendererHostAsyncWaiter::GetMessageBundle(
    const std::string& extension_id, base::flat_map<std::string, std::string>* out_message_map) {
  base::RunLoop loop;
  proxy_->GetMessageBundle(
      std::move(extension_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, std::string>* out_message_map
,
             const base::flat_map<std::string, std::string>& message_map) {*out_message_map = std::move(message_map);
            loop->Quit();
          },
          &loop,
          out_message_map));
  loop.Run();
}

base::flat_map<std::string, std::string> RendererHostAsyncWaiter::GetMessageBundle(
    const std::string& extension_id) {
  base::flat_map<std::string, std::string> async_wait_result;
  GetMessageBundle(std::move(extension_id),&async_wait_result);
  return async_wait_result;
}






}  // extensions::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif