// components/spellcheck/common/spellcheck.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SHARED_H_
#define COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/spellcheck/common/spellcheck.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace spellcheck::mojom {
class SpellCheckBDictLanguageDataView;

class SpellCheckResultDataView;



}  // spellcheck::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::spellcheck::mojom::SpellCheckBDictLanguageDataView> {
  using Data = ::spellcheck::mojom::internal::SpellCheckBDictLanguage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::spellcheck::mojom::SpellCheckResultDataView> {
  using Data = ::spellcheck::mojom::internal::SpellCheckResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace spellcheck::mojom {


enum class Decoration : int32_t {
  
  kSpelling = 0,
  
  kGrammar = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, Decoration value);
inline bool IsKnownEnumValue(Decoration value) {
  return internal::Decoration_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SpellCheckerInterfaceBase {};

using SpellCheckerPtrDataView =
    mojo::InterfacePtrDataView<SpellCheckerInterfaceBase>;
using SpellCheckerRequestDataView =
    mojo::InterfaceRequestDataView<SpellCheckerInterfaceBase>;
using SpellCheckerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpellCheckerInterfaceBase>;
using SpellCheckerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpellCheckerInterfaceBase>;
class SpellCheckInitializationHostInterfaceBase {};

using SpellCheckInitializationHostPtrDataView =
    mojo::InterfacePtrDataView<SpellCheckInitializationHostInterfaceBase>;
using SpellCheckInitializationHostRequestDataView =
    mojo::InterfaceRequestDataView<SpellCheckInitializationHostInterfaceBase>;
using SpellCheckInitializationHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpellCheckInitializationHostInterfaceBase>;
using SpellCheckInitializationHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpellCheckInitializationHostInterfaceBase>;
class SpellCheckHostInterfaceBase {};

using SpellCheckHostPtrDataView =
    mojo::InterfacePtrDataView<SpellCheckHostInterfaceBase>;
using SpellCheckHostRequestDataView =
    mojo::InterfaceRequestDataView<SpellCheckHostInterfaceBase>;
using SpellCheckHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SpellCheckHostInterfaceBase>;
using SpellCheckHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SpellCheckHostInterfaceBase>;


class SpellCheckBDictLanguageDataView {
 public:
  SpellCheckBDictLanguageDataView() = default;

  SpellCheckBDictLanguageDataView(
      internal::SpellCheckBDictLanguage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFileDataView(
      ::mojo_base::mojom::ReadOnlyFileDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFile(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::ReadOnlyFileDataView, UserType>(),
    "Attempting to read the optional `file` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFile` instead "
    "of `ReadFile if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        pointer, output, message_);
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SpellCheckBDictLanguage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SpellCheckResultDataView {
 public:
  SpellCheckResultDataView() = default;

  SpellCheckResultDataView(
      internal::SpellCheckResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadDecoration(UserType* output) const {
    auto data_value = data_->decoration;
    return mojo::internal::Deserialize<::spellcheck::mojom::Decoration>(
        data_value, output);
  }
  Decoration decoration() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::spellcheck::mojom::Decoration>(data_->decoration));
  }
  int32_t location() const {
    return data_->location;
  }
  int32_t length() const {
    return data_->length;
  }
  inline void GetReplacementsDataView(
      mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacements(UserType* output) {
    
    auto* pointer = data_->replacements.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        pointer, output, message_);
  }
 private:
  internal::SpellCheckResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // spellcheck::mojom

namespace std {

template <>
struct hash<::spellcheck::mojom::Decoration>
    : public mojo::internal::EnumHashImpl<::spellcheck::mojom::Decoration> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::spellcheck::mojom::Decoration, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::spellcheck::mojom::Decoration, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::spellcheck::mojom::Decoration>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::spellcheck::mojom::SpellCheckBDictLanguageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::spellcheck::mojom::SpellCheckBDictLanguageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::spellcheck::mojom::internal::SpellCheckBDictLanguage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::file(input)) in_file = Traits::file(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->file)::BaseType> file_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
        in_file, file_fragment);
    fragment->file.Set(
        file_fragment.is_null() ? nullptr : file_fragment.data());
    decltype(Traits::language(input)) in_language = Traits::language(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->language)::BaseType> language_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_language, language_fragment);
    fragment->language.Set(
        language_fragment.is_null() ? nullptr : language_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->language.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null language in SpellCheckBDictLanguage struct");
  }

  static bool Deserialize(::spellcheck::mojom::internal::SpellCheckBDictLanguage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::spellcheck::mojom::SpellCheckBDictLanguageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::spellcheck::mojom::SpellCheckResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::spellcheck::mojom::SpellCheckResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::spellcheck::mojom::internal::SpellCheckResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::spellcheck::mojom::Decoration>(
        Traits::decoration(input), &fragment->decoration);
    fragment->location = Traits::location(input);
    fragment->length = Traits::length(input);
    decltype(Traits::replacements(input)) in_replacements = Traits::replacements(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->replacements)::BaseType>
        replacements_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& replacements_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
        in_replacements, replacements_fragment, &replacements_validate_params);
    fragment->replacements.Set(
        replacements_fragment.is_null() ? nullptr : replacements_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->replacements.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null replacements in SpellCheckResult struct");
  }

  static bool Deserialize(::spellcheck::mojom::internal::SpellCheckResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::spellcheck::mojom::SpellCheckResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace spellcheck::mojom {

inline void SpellCheckBDictLanguageDataView::GetFileDataView(
    ::mojo_base::mojom::ReadOnlyFileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::ReadOnlyFileDataView(pointer, message_);
}
inline void SpellCheckBDictLanguageDataView::GetLanguageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->language.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SpellCheckResultDataView::GetReplacementsDataView(
    mojo::ArrayDataView<::mojo_base::mojom::String16DataView>* output) {
  auto pointer = data_->replacements.Get();
  *output = mojo::ArrayDataView<::mojo_base::mojom::String16DataView>(pointer, message_);
}



}  // spellcheck::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::spellcheck::mojom::Decoration> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::spellcheck::mojom::Decoration value);
};

} // namespace perfetto

#endif  // COMPONENTS_SPELLCHECK_COMMON_SPELLCHECK_MOJOM_SHARED_H_