// components/services/storage/public/mojom/filesystem/directory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/filesystem/directory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/filesystem/directory.mojom-params-data.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/filesystem/directory.mojom-import-headers.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-test-utils.h"


namespace storage::mojom {
StrictRelativePath::StrictRelativePath()
    : path() {}

StrictRelativePath::StrictRelativePath(
    const ::base::FilePath& path_in)
    : path(std::move(path_in)) {}

StrictRelativePath::~StrictRelativePath() = default;

void StrictRelativePath::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::FilePath&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool StrictRelativePath::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PathAccessInfo::PathAccessInfo()
    : can_read(),
      can_write() {}

PathAccessInfo::PathAccessInfo(
    bool can_read_in,
    bool can_write_in)
    : can_read(std::move(can_read_in)),
      can_write(std::move(can_write_in)) {}

PathAccessInfo::~PathAccessInfo() = default;
size_t PathAccessInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->can_read);
  seed = mojo::internal::Hash(seed, this->can_write);
  return seed;
}

void PathAccessInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_read"), this->can_read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_write"), this->can_write,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PathAccessInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char FileLock::Name_[] = "storage.mojom.FileLock";

FileLock::IPCStableHashFunction FileLock::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::FileLock>(message.name())) {
    case messages::FileLock::kRelease: {
      return &FileLock::Release_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* FileLock::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::FileLock>(message.name())) {
      case messages::FileLock::kRelease:
            return "Receive storage::mojom::FileLock::Release";
    }
  } else {
    switch (static_cast<messages::FileLock>(message.name())) {
      case messages::FileLock::kRelease:
            return "Receive reply storage::mojom::FileLock::Release";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t FileLock::Release_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::FileLock::Release");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool FileLock::Release(::base::File::Error* out_error) {
  NOTREACHED();
}
class FileLock_Release_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FileLock_Release_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  FileLock_Release_HandleSyncResponse(const FileLock_Release_HandleSyncResponse&) = delete;
  FileLock_Release_HandleSyncResponse& operator=(const FileLock_Release_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class FileLock_Release_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FileLock_Release_ForwardToCallback(
      FileLock::ReleaseCallback callback
      ) : callback_(std::move(callback)) {
  }

  FileLock_Release_ForwardToCallback(const FileLock_Release_ForwardToCallback&) = delete;
  FileLock_Release_ForwardToCallback& operator=(const FileLock_Release_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  FileLock::ReleaseCallback callback_;
};

FileLockProxy::FileLockProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool FileLockProxy::Release(
    ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call storage::mojom::FileLock::Release (sync)");
#else
  TRACE_EVENT0("mojom", "FileLock::Release");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileLock::kRelease), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileLock_Release_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileLock::Name_);
  message.set_method_name("Release");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileLock_Release_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "FileLock::Release", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void FileLockProxy::Release(
    ReleaseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send storage::mojom::FileLock::Release");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileLock::kRelease), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileLock_Release_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileLock::Name_);
  message.set_method_name("Release");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FileLock_Release_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class FileLock_Release_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static FileLock::ReleaseCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<FileLock_Release_ProxyToResponder> proxy(
        new FileLock_Release_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&FileLock_Release_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FileLock_Release_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  FileLock_Release_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FileLock::ReleaseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool FileLock_Release_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileLock_Release_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FileLock_Release_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for FileLock.0
  bool success = true;
  ::base::File::Error p_error{};
  FileLock_Release_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileLock::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void FileLock_Release_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::FileLock::Release", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::FileLock::kRelease), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::FileLock_Release_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FileLock::Name_);
  message.set_method_name("Release");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FileLock_Release_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::FileLock_Release_ResponseParams_Data* params =
      reinterpret_cast<internal::FileLock_Release_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for FileLock.0
  bool success = true;
  ::base::File::Error p_error{};
  FileLock_Release_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FileLock::Name_, 0, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}

// static
bool FileLockStubDispatch::Accept(
    FileLock* impl,
    mojo::Message* message) {
  switch (static_cast<messages::FileLock>(message->header()->name)) {
    case messages::FileLock::kRelease: {
      break;
    }
  }
  return false;
}

// static
bool FileLockStubDispatch::AcceptWithResponder(
    FileLock* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::FileLock>(message->header()->name)) {
    case messages::FileLock::kRelease: {
      internal::FileLock_Release_Params_Data* params =
          reinterpret_cast<
              internal::FileLock_Release_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for FileLock.0
      bool success = true;
      FileLock_Release_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FileLock::Name_, 0, false);
        return false;
      }
      FileLock::ReleaseCallback callback =
          FileLock_Release_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Release(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFileLockValidationInfo[] = {
    {base::to_underlying(messages::FileLock::kRelease),
     { &internal::FileLock_Release_Params_Data::Validate,
      &internal::FileLock_Release_ResponseParams_Data::Validate}},
};

bool FileLockRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::FileLock::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFileLockValidationInfo);
}

bool FileLockResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::FileLock::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFileLockValidationInfo);

}
const char Directory::Name_[] = "storage.mojom.Directory";

Directory::IPCStableHashFunction Directory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Directory>(message.name())) {
    case messages::Directory::kClone: {
      return &Directory::Clone_Sym::IPCStableHash;
    }
    case messages::Directory::kPathExists: {
      return &Directory::PathExists_Sym::IPCStableHash;
    }
    case messages::Directory::kGetEntries: {
      return &Directory::GetEntries_Sym::IPCStableHash;
    }
    case messages::Directory::kOpenFile: {
      return &Directory::OpenFile_Sym::IPCStableHash;
    }
    case messages::Directory::kCreateDirectory: {
      return &Directory::CreateDirectory_Sym::IPCStableHash;
    }
    case messages::Directory::kDeleteFile: {
      return &Directory::DeleteFile_Sym::IPCStableHash;
    }
    case messages::Directory::kGetFileInfo: {
      return &Directory::GetFileInfo_Sym::IPCStableHash;
    }
    case messages::Directory::kGetPathAccess: {
      return &Directory::GetPathAccess_Sym::IPCStableHash;
    }
    case messages::Directory::kRenameFile: {
      return &Directory::RenameFile_Sym::IPCStableHash;
    }
    case messages::Directory::kLockFile: {
      return &Directory::LockFile_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Directory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Directory>(message.name())) {
      case messages::Directory::kClone:
            return "Receive storage::mojom::Directory::Clone";
      case messages::Directory::kPathExists:
            return "Receive storage::mojom::Directory::PathExists";
      case messages::Directory::kGetEntries:
            return "Receive storage::mojom::Directory::GetEntries";
      case messages::Directory::kOpenFile:
            return "Receive storage::mojom::Directory::OpenFile";
      case messages::Directory::kCreateDirectory:
            return "Receive storage::mojom::Directory::CreateDirectory";
      case messages::Directory::kDeleteFile:
            return "Receive storage::mojom::Directory::DeleteFile";
      case messages::Directory::kGetFileInfo:
            return "Receive storage::mojom::Directory::GetFileInfo";
      case messages::Directory::kGetPathAccess:
            return "Receive storage::mojom::Directory::GetPathAccess";
      case messages::Directory::kRenameFile:
            return "Receive storage::mojom::Directory::RenameFile";
      case messages::Directory::kLockFile:
            return "Receive storage::mojom::Directory::LockFile";
    }
  } else {
    switch (static_cast<messages::Directory>(message.name())) {
      case messages::Directory::kClone:
            return "Receive reply storage::mojom::Directory::Clone";
      case messages::Directory::kPathExists:
            return "Receive reply storage::mojom::Directory::PathExists";
      case messages::Directory::kGetEntries:
            return "Receive reply storage::mojom::Directory::GetEntries";
      case messages::Directory::kOpenFile:
            return "Receive reply storage::mojom::Directory::OpenFile";
      case messages::Directory::kCreateDirectory:
            return "Receive reply storage::mojom::Directory::CreateDirectory";
      case messages::Directory::kDeleteFile:
            return "Receive reply storage::mojom::Directory::DeleteFile";
      case messages::Directory::kGetFileInfo:
            return "Receive reply storage::mojom::Directory::GetFileInfo";
      case messages::Directory::kGetPathAccess:
            return "Receive reply storage::mojom::Directory::GetPathAccess";
      case messages::Directory::kRenameFile:
            return "Receive reply storage::mojom::Directory::RenameFile";
      case messages::Directory::kLockFile:
            return "Receive reply storage::mojom::Directory::LockFile";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Directory::Clone_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::Clone");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::PathExists_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::PathExists");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::GetEntries_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::GetEntries");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::OpenFile_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::OpenFile");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::CreateDirectory_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::CreateDirectory");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::DeleteFile_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::DeleteFile");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::GetFileInfo_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::GetFileInfo");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::GetPathAccess_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::GetPathAccess");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::RenameFile_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::RenameFile");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Directory::LockFile_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::Directory::LockFile");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool Directory::PathExists(const ::base::FilePath& path, bool* out_exists) {
  NOTREACHED();
}
bool Directory::GetEntries(const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries) {
  NOTREACHED();
}
bool Directory::OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file) {
  NOTREACHED();
}
bool Directory::CreateDirectory(const ::base::FilePath& path, ::base::File::Error* out_error) {
  NOTREACHED();
}
bool Directory::DeleteFile(const ::base::FilePath& path, bool* out_success) {
  NOTREACHED();
}
bool Directory::GetFileInfo(const ::base::FilePath& path, std::optional<::base::File::Info>* out_info) {
  NOTREACHED();
}
bool Directory::GetPathAccess(const ::base::FilePath& path, PathAccessInfoPtr* out_info) {
  NOTREACHED();
}
bool Directory::RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error) {
  NOTREACHED();
}
bool Directory::LockFile(const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock) {
  NOTREACHED();
}
class Directory_PathExists_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_PathExists_HandleSyncResponse(
      bool* result, bool* out_exists)
      : result_(result), out_exists_(out_exists) {
    DCHECK(!*result_);
  }

  Directory_PathExists_HandleSyncResponse(const Directory_PathExists_HandleSyncResponse&) = delete;
  Directory_PathExists_HandleSyncResponse& operator=(const Directory_PathExists_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_exists_;};

class Directory_PathExists_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_PathExists_ForwardToCallback(
      Directory::PathExistsCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_PathExists_ForwardToCallback(const Directory_PathExists_ForwardToCallback&) = delete;
  Directory_PathExists_ForwardToCallback& operator=(const Directory_PathExists_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::PathExistsCallback callback_;
};
class Directory_GetEntries_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_GetEntries_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries)
      : result_(result), out_error_(out_error), out_entries_(out_entries) {
    DCHECK(!*result_);
  }

  Directory_GetEntries_HandleSyncResponse(const Directory_GetEntries_HandleSyncResponse&) = delete;
  Directory_GetEntries_HandleSyncResponse& operator=(const Directory_GetEntries_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  std::vector<::base::FilePath>* out_entries_;};

class Directory_GetEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_GetEntries_ForwardToCallback(
      Directory::GetEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_GetEntries_ForwardToCallback(const Directory_GetEntries_ForwardToCallback&) = delete;
  Directory_GetEntries_ForwardToCallback& operator=(const Directory_GetEntries_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::GetEntriesCallback callback_;
};
class Directory_OpenFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::base::File* out_file)
      : result_(result), out_error_(out_error), out_file_(out_file) {
    DCHECK(!*result_);
  }

  Directory_OpenFile_HandleSyncResponse(const Directory_OpenFile_HandleSyncResponse&) = delete;
  Directory_OpenFile_HandleSyncResponse& operator=(const Directory_OpenFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::base::File* out_file_;};

class Directory_OpenFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_OpenFile_ForwardToCallback(
      Directory::OpenFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_OpenFile_ForwardToCallback(const Directory_OpenFile_ForwardToCallback&) = delete;
  Directory_OpenFile_ForwardToCallback& operator=(const Directory_OpenFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::OpenFileCallback callback_;
};
class Directory_CreateDirectory_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_CreateDirectory_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_CreateDirectory_HandleSyncResponse(const Directory_CreateDirectory_HandleSyncResponse&) = delete;
  Directory_CreateDirectory_HandleSyncResponse& operator=(const Directory_CreateDirectory_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_CreateDirectory_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_CreateDirectory_ForwardToCallback(
      Directory::CreateDirectoryCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_CreateDirectory_ForwardToCallback(const Directory_CreateDirectory_ForwardToCallback&) = delete;
  Directory_CreateDirectory_ForwardToCallback& operator=(const Directory_CreateDirectory_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::CreateDirectoryCallback callback_;
};
class Directory_DeleteFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_DeleteFile_HandleSyncResponse(
      bool* result, bool* out_success)
      : result_(result), out_success_(out_success) {
    DCHECK(!*result_);
  }

  Directory_DeleteFile_HandleSyncResponse(const Directory_DeleteFile_HandleSyncResponse&) = delete;
  Directory_DeleteFile_HandleSyncResponse& operator=(const Directory_DeleteFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_success_;};

class Directory_DeleteFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_DeleteFile_ForwardToCallback(
      Directory::DeleteFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_DeleteFile_ForwardToCallback(const Directory_DeleteFile_ForwardToCallback&) = delete;
  Directory_DeleteFile_ForwardToCallback& operator=(const Directory_DeleteFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::DeleteFileCallback callback_;
};
class Directory_GetFileInfo_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_GetFileInfo_HandleSyncResponse(
      bool* result, std::optional<::base::File::Info>* out_info)
      : result_(result), out_info_(out_info) {
    DCHECK(!*result_);
  }

  Directory_GetFileInfo_HandleSyncResponse(const Directory_GetFileInfo_HandleSyncResponse&) = delete;
  Directory_GetFileInfo_HandleSyncResponse& operator=(const Directory_GetFileInfo_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  std::optional<::base::File::Info>* out_info_;};

class Directory_GetFileInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_GetFileInfo_ForwardToCallback(
      Directory::GetFileInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_GetFileInfo_ForwardToCallback(const Directory_GetFileInfo_ForwardToCallback&) = delete;
  Directory_GetFileInfo_ForwardToCallback& operator=(const Directory_GetFileInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::GetFileInfoCallback callback_;
};
class Directory_GetPathAccess_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_GetPathAccess_HandleSyncResponse(
      bool* result, PathAccessInfoPtr* out_info)
      : result_(result), out_info_(out_info) {
    DCHECK(!*result_);
  }

  Directory_GetPathAccess_HandleSyncResponse(const Directory_GetPathAccess_HandleSyncResponse&) = delete;
  Directory_GetPathAccess_HandleSyncResponse& operator=(const Directory_GetPathAccess_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  PathAccessInfoPtr* out_info_;};

class Directory_GetPathAccess_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_GetPathAccess_ForwardToCallback(
      Directory::GetPathAccessCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_GetPathAccess_ForwardToCallback(const Directory_GetPathAccess_ForwardToCallback&) = delete;
  Directory_GetPathAccess_ForwardToCallback& operator=(const Directory_GetPathAccess_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::GetPathAccessCallback callback_;
};
class Directory_RenameFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_RenameFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error)
      : result_(result), out_error_(out_error) {
    DCHECK(!*result_);
  }

  Directory_RenameFile_HandleSyncResponse(const Directory_RenameFile_HandleSyncResponse&) = delete;
  Directory_RenameFile_HandleSyncResponse& operator=(const Directory_RenameFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;};

class Directory_RenameFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_RenameFile_ForwardToCallback(
      Directory::RenameFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_RenameFile_ForwardToCallback(const Directory_RenameFile_ForwardToCallback&) = delete;
  Directory_RenameFile_ForwardToCallback& operator=(const Directory_RenameFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::RenameFileCallback callback_;
};
class Directory_LockFile_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  Directory_LockFile_HandleSyncResponse(
      bool* result, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock)
      : result_(result), out_error_(out_error), out_lock_(out_lock) {
    DCHECK(!*result_);
  }

  Directory_LockFile_HandleSyncResponse(const Directory_LockFile_HandleSyncResponse&) = delete;
  Directory_LockFile_HandleSyncResponse& operator=(const Directory_LockFile_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::base::File::Error* out_error_;
  ::mojo::PendingRemote<FileLock>* out_lock_;};

class Directory_LockFile_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Directory_LockFile_ForwardToCallback(
      Directory::LockFileCallback callback
      ) : callback_(std::move(callback)) {
  }

  Directory_LockFile_ForwardToCallback(const Directory_LockFile_ForwardToCallback&) = delete;
  Directory_LockFile_ForwardToCallback& operator=(const Directory_LockFile_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Directory::LockFileCallback callback_;
};

DirectoryProxy::DirectoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void DirectoryProxy::Clone(
    ::mojo::PendingReceiver<Directory> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::Clone", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Directory>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kClone), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_Clone_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::storage::mojom::DirectoryInterfaceBase>>(
      in_receiver, &params->receiver, &params.message());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in Directory.Clone request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
bool DirectoryProxy::PathExists(
    const ::base::FilePath& param_path, bool* out_param_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::PathExists (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::PathExists");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kPathExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_PathExists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.PathExists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("PathExists");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_PathExists_HandleSyncResponse(
          &result, out_param_exists));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::PathExists", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), out_param_exists,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::PathExists(
    const ::base::FilePath& in_path, PathExistsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::PathExists", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kPathExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_PathExists_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.PathExists request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("PathExists");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_PathExists_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::GetEntries(
    const ::base::FilePath& param_path, GetEntriesMode param_mode, ::base::File::Error* out_param_error, std::vector<::base::FilePath>* out_param_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::GetEntries (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), param_mode,
                        "<value of type GetEntriesMode>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::GetEntries");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetEntries request");
  mojo::internal::Serialize<::storage::mojom::GetEntriesMode>(
      param_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetEntries");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetEntries_HandleSyncResponse(
          &result, out_param_error, out_param_entries));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::GetEntries", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), out_param_entries,
                        "<value of type const std::vector<::base::FilePath>&>");
   });
#endif
  return result;
}

void DirectoryProxy::GetEntries(
    const ::base::FilePath& in_path, GetEntriesMode in_mode, GetEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::GetEntries", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type GetEntriesMode>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetEntries_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetEntries request");
  mojo::internal::Serialize<::storage::mojom::GetEntriesMode>(
      in_mode, &params->mode);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetEntries_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::OpenFile(
    const ::base::FilePath& param_path, FileOpenMode param_mode, FileReadAccess param_read_access, FileWriteAccess param_write_access, ::base::File::Error* out_param_error, ::base::File* out_param_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::OpenFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), param_mode,
                        "<value of type FileOpenMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("read_access"), param_read_access,
                        "<value of type FileReadAccess>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_access"), param_write_access,
                        "<value of type FileWriteAccess>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::OpenFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFile request");
  mojo::internal::Serialize<::storage::mojom::FileOpenMode>(
      param_mode, &params->mode);
  mojo::internal::Serialize<::storage::mojom::FileReadAccess>(
      param_read_access, &params->read_access);
  mojo::internal::Serialize<::storage::mojom::FileWriteAccess>(
      param_write_access, &params->write_access);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFile_HandleSyncResponse(
          &result, out_param_error, out_param_file));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::OpenFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), out_param_file,
                        "<value of type ::base::File>");
   });
#endif
  return result;
}

void DirectoryProxy::OpenFile(
    const ::base::FilePath& in_path, FileOpenMode in_mode, FileReadAccess in_read_access, FileWriteAccess in_write_access, OpenFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::OpenFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mode"), in_mode,
                        "<value of type FileOpenMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("read_access"), in_read_access,
                        "<value of type FileReadAccess>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("write_access"), in_write_access,
                        "<value of type FileWriteAccess>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_OpenFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.OpenFile request");
  mojo::internal::Serialize<::storage::mojom::FileOpenMode>(
      in_mode, &params->mode);
  mojo::internal::Serialize<::storage::mojom::FileReadAccess>(
      in_read_access, &params->read_access);
  mojo::internal::Serialize<::storage::mojom::FileWriteAccess>(
      in_write_access, &params->write_access);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_OpenFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::CreateDirectory(
    const ::base::FilePath& param_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::CreateDirectory (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::CreateDirectory");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kCreateDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_CreateDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.CreateDirectory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("CreateDirectory");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_CreateDirectory_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::CreateDirectory", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::CreateDirectory(
    const ::base::FilePath& in_path, CreateDirectoryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::CreateDirectory", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kCreateDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_CreateDirectory_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.CreateDirectory request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("CreateDirectory");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_CreateDirectory_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::DeleteFile(
    const ::base::FilePath& param_path, bool* out_param_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::DeleteFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::DeleteFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kDeleteFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.DeleteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeleteFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_DeleteFile_HandleSyncResponse(
          &result, out_param_success));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::DeleteFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), out_param_success,
                        "<value of type bool>");
   });
#endif
  return result;
}

void DirectoryProxy::DeleteFile(
    const ::base::FilePath& in_path, DeleteFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::DeleteFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kDeleteFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeleteFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.DeleteFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeleteFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_DeleteFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::GetFileInfo(
    const ::base::FilePath& param_path, std::optional<::base::File::Info>* out_param_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::GetFileInfo (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::GetFileInfo");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetFileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetFileInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetFileInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetFileInfo");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetFileInfo_HandleSyncResponse(
          &result, out_param_info));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::GetFileInfo", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), out_param_info,
                        "<value of type const std::optional<::base::File::Info>&>");
   });
#endif
  return result;
}

void DirectoryProxy::GetFileInfo(
    const ::base::FilePath& in_path, GetFileInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::GetFileInfo", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetFileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetFileInfo_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetFileInfo request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetFileInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetFileInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::GetPathAccess(
    const ::base::FilePath& param_path, PathAccessInfoPtr* out_param_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::GetPathAccess (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::GetPathAccess");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetPathAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetPathAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetPathAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetPathAccess");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetPathAccess_HandleSyncResponse(
          &result, out_param_info));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::GetPathAccess", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), out_param_info,
                        "<value of type PathAccessInfoPtr>");
   });
#endif
  return result;
}

void DirectoryProxy::GetPathAccess(
    const ::base::FilePath& in_path, GetPathAccessCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::GetPathAccess", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetPathAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetPathAccess_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.GetPathAccess request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetPathAccess");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_GetPathAccess_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::RenameFile(
    const ::base::FilePath& param_old_path, const ::base::FilePath& param_new_path, ::base::File::Error* out_param_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::RenameFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_path"), param_old_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), param_new_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::RenameFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRenameFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_RenameFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_path)::BaseType> old_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_old_path, old_path_fragment);
  params->old_path.Set(
      old_path_fragment.is_null() ? nullptr : old_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_path in Directory.RenameFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.RenameFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("RenameFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_RenameFile_HandleSyncResponse(
          &result, out_param_error));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::RenameFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
   });
#endif
  return result;
}

void DirectoryProxy::RenameFile(
    const ::base::FilePath& in_old_path, const ::base::FilePath& in_new_path, RenameFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::RenameFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("old_path"), in_old_path,
                        "<value of type const ::base::FilePath&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_path"), in_new_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRenameFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_RenameFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->old_path)::BaseType> old_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_old_path, old_path_fragment);
  params->old_path.Set(
      old_path_fragment.is_null() ? nullptr : old_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->old_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null old_path in Directory.RenameFile request");
  mojo::internal::MessageFragment<
      typename decltype(params->new_path)::BaseType> new_path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_new_path, new_path_fragment);
  params->new_path.Set(
      new_path_fragment.is_null() ? nullptr : new_path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_path in Directory.RenameFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("RenameFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_RenameFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool DirectoryProxy::LockFile(
    const ::base::FilePath& param_path, ::base::File::Error* out_param_error, ::mojo::PendingRemote<FileLock>* out_param_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call storage::mojom::Directory::LockFile (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), param_path,
                        "<value of type const ::base::FilePath&>");
   });
#else
  TRACE_EVENT0("mojom", "Directory::LockFile");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kLockFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_LockFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      param_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.LockFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("LockFile");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_LockFile_HandleSyncResponse(
          &result, out_param_error, out_param_lock));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "Directory::LockFile", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), out_param_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lock"), out_param_lock,
                        "<value of type ::mojo::PendingRemote<FileLock>>");
   });
#endif
  return result;
}

void DirectoryProxy::LockFile(
    const ::base::FilePath& in_path, LockFileCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::Directory::LockFile", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("path"), in_path,
                        "<value of type const ::base::FilePath&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kLockFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_LockFile_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->path)::BaseType> path_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::StrictRelativePathDataView>(
      in_path, path_fragment);
  params->path.Set(
      path_fragment.is_null() ? nullptr : path_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in Directory.LockFile request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("LockFile");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Directory_LockFile_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Directory_PathExists_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::PathExistsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_PathExists_ProxyToResponder> proxy(
        new Directory_PathExists_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_PathExists_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_PathExists_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_PathExists_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::PathExistsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_exists);
};

bool Directory_PathExists_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_PathExists_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_PathExists_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.1
  bool success = true;
  bool p_exists{};
  Directory_PathExists_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_exists));
  return true;
}

void Directory_PathExists_ProxyToResponder::Run(
    bool in_exists) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::PathExists", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("exists"), in_exists,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kPathExists), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_PathExists_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->exists = in_exists;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("PathExists");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_PathExists_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_PathExists_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_PathExists_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.1
  bool success = true;
  bool p_exists{};
  Directory_PathExists_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_exists = input_data_view.exists();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 1, true);
    return false;
  }
  *out_exists_ = std::move(p_exists);
  *result_ = true;
  return true;
}
class Directory_GetEntries_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::GetEntriesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_GetEntries_ProxyToResponder> proxy(
        new Directory_GetEntries_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_GetEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_GetEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_GetEntries_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::GetEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, const std::vector<::base::FilePath>& in_entries);
};

bool Directory_GetEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_GetEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_GetEntries_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.2
  bool success = true;
  ::base::File::Error p_error{};
  std::vector<::base::FilePath> p_entries{};
  Directory_GetEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_entries));
  return true;
}

void Directory_GetEntries_ProxyToResponder::Run(
    ::base::File::Error in_error, const std::vector<::base::FilePath>& in_entries) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::GetEntries", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("entries"), in_entries,
                        "<value of type const std::vector<::base::FilePath>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetEntries), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetEntries_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->entries)::BaseType>
      entries_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_entries, entries_fragment, &entries_validate_params);
  params->entries.Set(
      entries_fragment.is_null() ? nullptr : entries_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->entries.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null entries in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetEntries");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_GetEntries_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_GetEntries_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_GetEntries_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.2
  bool success = true;
  ::base::File::Error p_error{};
  std::vector<::base::FilePath> p_entries{};
  Directory_GetEntries_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadEntries(&p_entries))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 2, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_entries_ = std::move(p_entries);
  *result_ = true;
  return true;
}
class Directory_OpenFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::OpenFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_OpenFile_ProxyToResponder> proxy(
        new Directory_OpenFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_OpenFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_OpenFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_OpenFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::OpenFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::base::File in_file);
};

bool Directory_OpenFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_OpenFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.3
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file{};
  Directory_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_file));
  return true;
}

void Directory_OpenFile_ProxyToResponder::Run(
    ::base::File::Error in_error, ::base::File in_file) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::OpenFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("file"), in_file,
                        "<value of type ::base::File>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kOpenFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_OpenFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::MessageFragment<
      typename decltype(params->file)::BaseType> file_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
      in_file, file_fragment);
  params->file.Set(
      file_fragment.is_null() ? nullptr : file_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("OpenFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_OpenFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_OpenFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_OpenFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.3
  bool success = true;
  ::base::File::Error p_error{};
  ::base::File p_file{};
  Directory_OpenFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success && !input_data_view.ReadFile(&p_file))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 3, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_file_ = std::move(p_file);
  *result_ = true;
  return true;
}
class Directory_CreateDirectory_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::CreateDirectoryCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_CreateDirectory_ProxyToResponder> proxy(
        new Directory_CreateDirectory_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_CreateDirectory_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_CreateDirectory_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_CreateDirectory_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::CreateDirectoryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_CreateDirectory_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_CreateDirectory_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_CreateDirectory_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.4
  bool success = true;
  ::base::File::Error p_error{};
  Directory_CreateDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_CreateDirectory_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::CreateDirectory", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kCreateDirectory), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_CreateDirectory_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("CreateDirectory");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_CreateDirectory_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_CreateDirectory_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_CreateDirectory_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.4
  bool success = true;
  ::base::File::Error p_error{};
  Directory_CreateDirectory_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 4, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_DeleteFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::DeleteFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_DeleteFile_ProxyToResponder> proxy(
        new Directory_DeleteFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_DeleteFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_DeleteFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_DeleteFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::DeleteFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool Directory_DeleteFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_DeleteFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.5
  bool success = true;
  bool p_success{};
  Directory_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void Directory_DeleteFile_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::DeleteFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kDeleteFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_DeleteFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("DeleteFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_DeleteFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_DeleteFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_DeleteFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.5
  bool success = true;
  bool p_success{};
  Directory_DeleteFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 5, true);
    return false;
  }
  *out_success_ = std::move(p_success);
  *result_ = true;
  return true;
}
class Directory_GetFileInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::GetFileInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_GetFileInfo_ProxyToResponder> proxy(
        new Directory_GetFileInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_GetFileInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_GetFileInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_GetFileInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::GetFileInfoCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::optional<::base::File::Info>& in_info);
};

bool Directory_GetFileInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_GetFileInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_GetFileInfo_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.6
  bool success = true;
  std::optional<::base::File::Info> p_info{};
  Directory_GetFileInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void Directory_GetFileInfo_ProxyToResponder::Run(
    const std::optional<::base::File::Info>& in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::GetFileInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type const std::optional<::base::File::Info>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetFileInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetFileInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::mojo_base::mojom::FileInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetFileInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_GetFileInfo_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_GetFileInfo_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_GetFileInfo_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.6
  bool success = true;
  std::optional<::base::File::Info> p_info{};
  Directory_GetFileInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 6, true);
    return false;
  }
  *out_info_ = std::move(p_info);
  *result_ = true;
  return true;
}
class Directory_GetPathAccess_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::GetPathAccessCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_GetPathAccess_ProxyToResponder> proxy(
        new Directory_GetPathAccess_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_GetPathAccess_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_GetPathAccess_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_GetPathAccess_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::GetPathAccessCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      PathAccessInfoPtr in_info);
};

bool Directory_GetPathAccess_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_GetPathAccess_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_GetPathAccess_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.7
  bool success = true;
  PathAccessInfoPtr p_info{};
  Directory_GetPathAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_info));
  return true;
}

void Directory_GetPathAccess_ProxyToResponder::Run(
    PathAccessInfoPtr in_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::GetPathAccess", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("info"), in_info,
                        "<value of type PathAccessInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kGetPathAccess), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_GetPathAccess_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->info)::BaseType> info_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::PathAccessInfoDataView>(
      in_info, info_fragment);
  params->info.Set(
      info_fragment.is_null() ? nullptr : info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("GetPathAccess");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_GetPathAccess_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_GetPathAccess_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_GetPathAccess_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.7
  bool success = true;
  PathAccessInfoPtr p_info{};
  Directory_GetPathAccess_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInfo(&p_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 7, true);
    return false;
  }
  *out_info_ = std::move(p_info);
  *result_ = true;
  return true;
}
class Directory_RenameFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::RenameFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_RenameFile_ProxyToResponder> proxy(
        new Directory_RenameFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_RenameFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_RenameFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_RenameFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::RenameFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error);
};

bool Directory_RenameFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_RenameFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.8
  bool success = true;
  ::base::File::Error p_error{};
  Directory_RenameFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error));
  return true;
}

void Directory_RenameFile_ProxyToResponder::Run(
    ::base::File::Error in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::RenameFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kRenameFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_RenameFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("RenameFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_RenameFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_RenameFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_RenameFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.8
  bool success = true;
  ::base::File::Error p_error{};
  Directory_RenameFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 8, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *result_ = true;
  return true;
}
class Directory_LockFile_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Directory::LockFileCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Directory_LockFile_ProxyToResponder> proxy(
        new Directory_LockFile_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Directory_LockFile_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Directory_LockFile_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Directory_LockFile_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Directory::LockFileCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::File::Error in_error, ::mojo::PendingRemote<FileLock> in_lock);
};

bool Directory_LockFile_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_LockFile_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Directory_LockFile_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Directory.9
  bool success = true;
  ::base::File::Error p_error{};
  ::mojo::PendingRemote<FileLock> p_lock{};
  Directory_LockFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success) {
    p_lock =
        input_data_view.TakeLock<decltype(p_lock)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error), 
std::move(p_lock));
  return true;
}

void Directory_LockFile_ProxyToResponder::Run(
    ::base::File::Error in_error, ::mojo::PendingRemote<FileLock> in_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::Directory::LockFile", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type ::base::File::Error>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("lock"), in_lock,
                        "<value of type ::mojo::PendingRemote<FileLock>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Directory::kLockFile), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::Directory_LockFile_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::mojo_base::mojom::FileError>(
      in_error, &params->error);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::storage::mojom::FileLockInterfaceBase>>(
      in_lock, &params->lock, &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Directory::Name_);
  message.set_method_name("LockFile");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool Directory_LockFile_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Directory_LockFile_ResponseParams_Data* params =
      reinterpret_cast<internal::Directory_LockFile_ResponseParams_Data*>(
          message->mutable_payload());
  
  
  // Validation for Directory.9
  bool success = true;
  ::base::File::Error p_error{};
  ::mojo::PendingRemote<FileLock> p_lock{};
  Directory_LockFile_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (success) {
    p_lock =
        input_data_view.TakeLock<decltype(p_lock)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Directory::Name_, 9, true);
    return false;
  }
  *out_error_ = std::move(p_error);
  *out_lock_ = std::move(p_lock);
  *result_ = true;
  return true;
}

// static
bool DirectoryStubDispatch::Accept(
    Directory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Directory>(message->header()->name)) {
    case messages::Directory::kClone: {
      DCHECK(message->is_serialized());
      internal::Directory_Clone_Params_Data* params =
          reinterpret_cast<internal::Directory_Clone_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Directory.0
      bool success = true;
      ::mojo::PendingReceiver<Directory> p_receiver{};
      Directory_Clone_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(        
        std::move(p_receiver));
      return true;
    }
    case messages::Directory::kPathExists: {
      break;
    }
    case messages::Directory::kGetEntries: {
      break;
    }
    case messages::Directory::kOpenFile: {
      break;
    }
    case messages::Directory::kCreateDirectory: {
      break;
    }
    case messages::Directory::kDeleteFile: {
      break;
    }
    case messages::Directory::kGetFileInfo: {
      break;
    }
    case messages::Directory::kGetPathAccess: {
      break;
    }
    case messages::Directory::kRenameFile: {
      break;
    }
    case messages::Directory::kLockFile: {
      break;
    }
  }
  return false;
}

// static
bool DirectoryStubDispatch::AcceptWithResponder(
    Directory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Directory>(message->header()->name)) {
    case messages::Directory::kClone: {
      break;
    }
    case messages::Directory::kPathExists: {
      internal::Directory_PathExists_Params_Data* params =
          reinterpret_cast<
              internal::Directory_PathExists_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.1
      bool success = true;
      ::base::FilePath p_path{};
      Directory_PathExists_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 1, false);
        return false;
      }
      Directory::PathExistsCallback callback =
          Directory_PathExists_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PathExists(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kGetEntries: {
      internal::Directory_GetEntries_Params_Data* params =
          reinterpret_cast<
              internal::Directory_GetEntries_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.2
      bool success = true;
      ::base::FilePath p_path{};
      GetEntriesMode p_mode{};
      Directory_GetEntries_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 2, false);
        return false;
      }
      Directory::GetEntriesCallback callback =
          Directory_GetEntries_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetEntries(        
        std::move(p_path), 
        std::move(p_mode), std::move(callback));
      return true;
    }
    case messages::Directory::kOpenFile: {
      internal::Directory_OpenFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_OpenFile_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.3
      bool success = true;
      ::base::FilePath p_path{};
      FileOpenMode p_mode{};
      FileReadAccess p_read_access{};
      FileWriteAccess p_write_access{};
      Directory_OpenFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (success && !input_data_view.ReadReadAccess(&p_read_access))
        success = false;
      if (success && !input_data_view.ReadWriteAccess(&p_write_access))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 3, false);
        return false;
      }
      Directory::OpenFileCallback callback =
          Directory_OpenFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OpenFile(        
        std::move(p_path), 
        std::move(p_mode), 
        std::move(p_read_access), 
        std::move(p_write_access), std::move(callback));
      return true;
    }
    case messages::Directory::kCreateDirectory: {
      internal::Directory_CreateDirectory_Params_Data* params =
          reinterpret_cast<
              internal::Directory_CreateDirectory_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.4
      bool success = true;
      ::base::FilePath p_path{};
      Directory_CreateDirectory_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 4, false);
        return false;
      }
      Directory::CreateDirectoryCallback callback =
          Directory_CreateDirectory_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateDirectory(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kDeleteFile: {
      internal::Directory_DeleteFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_DeleteFile_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.5
      bool success = true;
      ::base::FilePath p_path{};
      Directory_DeleteFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 5, false);
        return false;
      }
      Directory::DeleteFileCallback callback =
          Directory_DeleteFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteFile(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kGetFileInfo: {
      internal::Directory_GetFileInfo_Params_Data* params =
          reinterpret_cast<
              internal::Directory_GetFileInfo_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.6
      bool success = true;
      ::base::FilePath p_path{};
      Directory_GetFileInfo_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 6, false);
        return false;
      }
      Directory::GetFileInfoCallback callback =
          Directory_GetFileInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFileInfo(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kGetPathAccess: {
      internal::Directory_GetPathAccess_Params_Data* params =
          reinterpret_cast<
              internal::Directory_GetPathAccess_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.7
      bool success = true;
      ::base::FilePath p_path{};
      Directory_GetPathAccess_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 7, false);
        return false;
      }
      Directory::GetPathAccessCallback callback =
          Directory_GetPathAccess_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetPathAccess(        
        std::move(p_path), std::move(callback));
      return true;
    }
    case messages::Directory::kRenameFile: {
      internal::Directory_RenameFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_RenameFile_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.8
      bool success = true;
      ::base::FilePath p_old_path{};
      ::base::FilePath p_new_path{};
      Directory_RenameFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOldPath(&p_old_path))
        success = false;
      if (success && !input_data_view.ReadNewPath(&p_new_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 8, false);
        return false;
      }
      Directory::RenameFileCallback callback =
          Directory_RenameFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RenameFile(        
        std::move(p_old_path), 
        std::move(p_new_path), std::move(callback));
      return true;
    }
    case messages::Directory::kLockFile: {
      internal::Directory_LockFile_Params_Data* params =
          reinterpret_cast<
              internal::Directory_LockFile_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Directory.9
      bool success = true;
      ::base::FilePath p_path{};
      Directory_LockFile_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPath(&p_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Directory::Name_, 9, false);
        return false;
      }
      Directory::LockFileCallback callback =
          Directory_LockFile_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LockFile(        
        std::move(p_path), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kDirectoryValidationInfo[] = {
    {base::to_underlying(messages::Directory::kClone),
     { &internal::Directory_Clone_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::Directory::kPathExists),
     { &internal::Directory_PathExists_Params_Data::Validate,
      &internal::Directory_PathExists_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kGetEntries),
     { &internal::Directory_GetEntries_Params_Data::Validate,
      &internal::Directory_GetEntries_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kOpenFile),
     { &internal::Directory_OpenFile_Params_Data::Validate,
      &internal::Directory_OpenFile_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kCreateDirectory),
     { &internal::Directory_CreateDirectory_Params_Data::Validate,
      &internal::Directory_CreateDirectory_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kDeleteFile),
     { &internal::Directory_DeleteFile_Params_Data::Validate,
      &internal::Directory_DeleteFile_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kGetFileInfo),
     { &internal::Directory_GetFileInfo_Params_Data::Validate,
      &internal::Directory_GetFileInfo_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kGetPathAccess),
     { &internal::Directory_GetPathAccess_Params_Data::Validate,
      &internal::Directory_GetPathAccess_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kRenameFile),
     { &internal::Directory_RenameFile_Params_Data::Validate,
      &internal::Directory_RenameFile_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::Directory::kLockFile),
     { &internal::Directory_LockFile_Params_Data::Validate,
      &internal::Directory_LockFile_ResponseParams_Data::Validate}},
};

bool DirectoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::Directory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kDirectoryValidationInfo);
}

bool DirectoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::Directory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kDirectoryValidationInfo);

}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::StrictRelativePath::DataView, ::storage::mojom::StrictRelativePathPtr>::Read(
    ::storage::mojom::StrictRelativePath::DataView input,
    ::storage::mojom::StrictRelativePathPtr* output) {
  bool success = true;
  ::storage::mojom::StrictRelativePathPtr result(::storage::mojom::StrictRelativePath::New());
  
      if (success && !input.ReadPath(&result->path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::PathAccessInfo::DataView, ::storage::mojom::PathAccessInfoPtr>::Read(
    ::storage::mojom::PathAccessInfo::DataView input,
    ::storage::mojom::PathAccessInfoPtr* output) {
  bool success = true;
  ::storage::mojom::PathAccessInfoPtr result(::storage::mojom::PathAccessInfo::New());
  
      if (success)
        result->can_read = input.can_read();
      if (success)
        result->can_write = input.can_write();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void FileLockInterceptorForTesting::Release(ReleaseCallback callback) {
  GetForwardingInterface()->Release(std::move(callback));
}
FileLockAsyncWaiter::FileLockAsyncWaiter(
    FileLock* proxy) : proxy_(proxy) {}

FileLockAsyncWaiter::~FileLockAsyncWaiter() = default;

void FileLockAsyncWaiter::Release(
    ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->Release(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error FileLockAsyncWaiter::Release(
    ) {
  ::base::File::Error async_wait_result;
  Release(&async_wait_result);
  return async_wait_result;
}




void DirectoryInterceptorForTesting::Clone(::mojo::PendingReceiver<Directory> receiver) {
  GetForwardingInterface()->Clone(
    std::move(receiver)
    );
}
void DirectoryInterceptorForTesting::PathExists(const ::base::FilePath& path, PathExistsCallback callback) {
  GetForwardingInterface()->PathExists(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::GetEntries(const ::base::FilePath& path, GetEntriesMode mode, GetEntriesCallback callback) {
  GetForwardingInterface()->GetEntries(
    std::move(path)
    , 
    std::move(mode)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, OpenFileCallback callback) {
  GetForwardingInterface()->OpenFile(
    std::move(path)
    , 
    std::move(mode)
    , 
    std::move(read_access)
    , 
    std::move(write_access)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) {
  GetForwardingInterface()->CreateDirectory(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::DeleteFile(const ::base::FilePath& path, DeleteFileCallback callback) {
  GetForwardingInterface()->DeleteFile(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) {
  GetForwardingInterface()->GetFileInfo(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::GetPathAccess(const ::base::FilePath& path, GetPathAccessCallback callback) {
  GetForwardingInterface()->GetPathAccess(
    std::move(path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, RenameFileCallback callback) {
  GetForwardingInterface()->RenameFile(
    std::move(old_path)
    , 
    std::move(new_path)
    , std::move(callback));
}
void DirectoryInterceptorForTesting::LockFile(const ::base::FilePath& path, LockFileCallback callback) {
  GetForwardingInterface()->LockFile(
    std::move(path)
    , std::move(callback));
}
DirectoryAsyncWaiter::DirectoryAsyncWaiter(
    Directory* proxy) : proxy_(proxy) {}

DirectoryAsyncWaiter::~DirectoryAsyncWaiter() = default;

void DirectoryAsyncWaiter::PathExists(
    const ::base::FilePath& path, bool* out_exists) {
  base::RunLoop loop;
  proxy_->PathExists(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_exists
,
             bool exists) {*out_exists = std::move(exists);
            loop->Quit();
          },
          &loop,
          out_exists));
  loop.Run();
}

bool DirectoryAsyncWaiter::PathExists(
    const ::base::FilePath& path) {
  bool async_wait_result;
  PathExists(std::move(path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::GetEntries(
    const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries) {
  base::RunLoop loop;
  proxy_->GetEntries(
      std::move(path),
      std::move(mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             std::vector<::base::FilePath>* out_entries
,
             ::base::File::Error error,
             const std::vector<::base::FilePath>& entries) {*out_error = std::move(error);*out_entries = std::move(entries);
            loop->Quit();
          },
          &loop,
          out_error,
          out_entries));
  loop.Run();
}



void DirectoryAsyncWaiter::OpenFile(
    const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file) {
  base::RunLoop loop;
  proxy_->OpenFile(
      std::move(path),
      std::move(mode),
      std::move(read_access),
      std::move(write_access),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File* out_file
,
             ::base::File::Error error,
             ::base::File file) {*out_error = std::move(error);*out_file = std::move(file);
            loop->Quit();
          },
          &loop,
          out_error,
          out_file));
  loop.Run();
}



void DirectoryAsyncWaiter::CreateDirectory(
    const ::base::FilePath& path, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->CreateDirectory(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::CreateDirectory(
    const ::base::FilePath& path) {
  ::base::File::Error async_wait_result;
  CreateDirectory(std::move(path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::DeleteFile(
    const ::base::FilePath& path, bool* out_success) {
  base::RunLoop loop;
  proxy_->DeleteFile(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool DirectoryAsyncWaiter::DeleteFile(
    const ::base::FilePath& path) {
  bool async_wait_result;
  DeleteFile(std::move(path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::GetFileInfo(
    const ::base::FilePath& path, std::optional<::base::File::Info>* out_info) {
  base::RunLoop loop;
  proxy_->GetFileInfo(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::base::File::Info>* out_info
,
             const std::optional<::base::File::Info>& info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

std::optional<::base::File::Info> DirectoryAsyncWaiter::GetFileInfo(
    const ::base::FilePath& path) {
  std::optional<::base::File::Info> async_wait_result;
  GetFileInfo(std::move(path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::GetPathAccess(
    const ::base::FilePath& path, PathAccessInfoPtr* out_info) {
  base::RunLoop loop;
  proxy_->GetPathAccess(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             PathAccessInfoPtr* out_info
,
             PathAccessInfoPtr info) {*out_info = std::move(info);
            loop->Quit();
          },
          &loop,
          out_info));
  loop.Run();
}

PathAccessInfoPtr DirectoryAsyncWaiter::GetPathAccess(
    const ::base::FilePath& path) {
  PathAccessInfoPtr async_wait_result;
  GetPathAccess(std::move(path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::RenameFile(
    const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error) {
  base::RunLoop loop;
  proxy_->RenameFile(
      std::move(old_path),
      std::move(new_path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::base::File::Error error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

::base::File::Error DirectoryAsyncWaiter::RenameFile(
    const ::base::FilePath& old_path, const ::base::FilePath& new_path) {
  ::base::File::Error async_wait_result;
  RenameFile(std::move(old_path),std::move(new_path),&async_wait_result);
  return async_wait_result;
}

void DirectoryAsyncWaiter::LockFile(
    const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock) {
  base::RunLoop loop;
  proxy_->LockFile(
      std::move(path),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::File::Error* out_error
,
             ::mojo::PendingRemote<FileLock>* out_lock
,
             ::base::File::Error error,
             ::mojo::PendingRemote<FileLock> lock) {*out_error = std::move(error);*out_lock = std::move(lock);
            loop->Quit();
          },
          &loop,
          out_error,
          out_lock));
  loop.Run();
}








}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif