/* PlaybackManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PlaybackManager.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021-2022 elementary, Inc. (https://elementary.io)
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gst/gst.h>
#include <gst/pbutils/pbutils.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gst/tag/tag.h>
#include <glib/gstdio.h>

#define MUSIC_APPLICATION_ACTION_CLEAR_QUEUE "action-clear-queue"
#define MUSIC_APPLICATION_ACTION_NEXT "action-next"
#define MUSIC_APPLICATION_ACTION_PLAY_PAUSE "action-play-pause"
#define MUSIC_APPLICATION_ACTION_PREVIOUS "action-previous"
#define MUSIC_APPLICATION_ACTION_SHUFFLE "action-shuffle"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MUSIC_TYPE_PLAYBACK_MANAGER (music_playback_manager_get_type ())
#define MUSIC_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager))
#define MUSIC_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))
#define MUSIC_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))

typedef struct _MusicPlaybackManager MusicPlaybackManager;
typedef struct _MusicPlaybackManagerClass MusicPlaybackManagerClass;
typedef struct _MusicPlaybackManagerPrivate MusicPlaybackManagerPrivate;

#define MUSIC_TYPE_AUDIO_OBJECT (music_audio_object_get_type ())
#define MUSIC_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject))
#define MUSIC_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))
#define MUSIC_IS_AUDIO_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_IS_AUDIO_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_AUDIO_OBJECT))
#define MUSIC_AUDIO_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObjectClass))

typedef struct _MusicAudioObject MusicAudioObject;
typedef struct _MusicAudioObjectClass MusicAudioObjectClass;
typedef enum  {
	MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE,
	MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT,
	MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS
} MusicPlaybackManagerDirection;

#define MUSIC_PLAYBACK_MANAGER_TYPE_DIRECTION (music_playback_manager_direction_get_type ())
enum  {
	MUSIC_PLAYBACK_MANAGER_0_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_HAS_ITEMS_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_N_ITEMS_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY,
	MUSIC_PLAYBACK_MANAGER_NUM_PROPERTIES
};
static GParamSpec* music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _MusicPlaybackManagerSaveArtFileData MusicPlaybackManagerSaveArtFileData;
enum  {
	MUSIC_PLAYBACK_MANAGER_INVALIDS_FOUND_SIGNAL,
	MUSIC_PLAYBACK_MANAGER_NUM_SIGNALS
};
static guint music_playback_manager_signals[MUSIC_PLAYBACK_MANAGER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MusicPlaybackManager {
	GObject parent_instance;
	MusicPlaybackManagerPrivate * priv;
};

struct _MusicPlaybackManagerClass {
	GObjectClass parent_class;
};

struct _MusicPlaybackManagerPrivate {
	MusicAudioObject* _current_audio;
	GListStore* _queue_liststore;
	gboolean _has_items;
	gint64 _playback_position;
	GstElement* playbin;
	GstDiscoverer* discoverer;
	guint progress_timer;
	GSettings* settings;
	gboolean next_by_eos;
	MusicPlaybackManagerDirection direction;
	GSimpleAction* next_action;
	GSimpleAction* play_pause_action;
	GSimpleAction* previous_action;
	GSimpleAction* shuffle_action;
};

struct _Block4Data {
	int _ref_count_;
	MusicPlaybackManager* self;
	MusicAudioObject* audio_object;
};

struct _MusicPlaybackManagerSaveArtFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MusicPlaybackManager* self;
	GdkTexture* texture;
	GFile* file;
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFileOutputStream* ostream;
	GFileOutputStream* _tmp2_;
	GFileOutputStream* _tmp3_;
	GBytes* _tmp4_;
	GBytes* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_;
};

static gint MusicPlaybackManager_private_offset;
static gpointer music_playback_manager_parent_class = NULL;
static GOnce music_playback_manager_instance;
static GOnce music_playback_manager_instance = G_ONCE_INIT;

VALA_EXTERN GType music_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaybackManager, g_object_unref)
VALA_EXTERN GType music_audio_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicAudioObject, g_object_unref)
static GType music_playback_manager_direction_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN MusicPlaybackManager* music_playback_manager_get_default (void);
static MusicPlaybackManager* __lambda4_ (void);
static MusicPlaybackManager* music_playback_manager_new (void);
static MusicPlaybackManager* music_playback_manager_construct (GType object_type);
static gpointer ___lambda4__gthread_func (gpointer self);
VALA_EXTERN void music_playback_manager_seek_to_progress (MusicPlaybackManager* self,
                                              gdouble percent);
VALA_EXTERN MusicAudioObject* music_playback_manager_get_current_audio (MusicPlaybackManager* self);
VALA_EXTERN gint64 music_audio_object_get_duration (MusicAudioObject* self);
VALA_EXTERN void music_playback_manager_queue_files (MusicPlaybackManager* self,
                                         GFile** files,
                                         gint files_length1);
VALA_EXTERN MusicAudioObject* music_audio_object_new (const gchar* uri);
VALA_EXTERN MusicAudioObject* music_audio_object_construct (GType object_type,
                                                const gchar* uri);
VALA_EXTERN void music_audio_object_set_title (MusicAudioObject* self,
                                   const gchar* value);
VALA_EXTERN const gchar* music_audio_object_get_uri (MusicAudioObject* self);
VALA_EXTERN GListStore* music_playback_manager_get_queue_liststore (MusicPlaybackManager* self);
VALA_EXTERN void music_playback_manager_set_current_audio (MusicPlaybackManager* self,
                                               MusicAudioObject* value);
static void music_playback_manager_clear_queue (MusicPlaybackManager* self);
VALA_EXTERN void music_playback_manager_remove (MusicPlaybackManager* self,
                                    MusicAudioObject* song);
static void music_playback_manager_update_metadata (MusicPlaybackManager* self,
                                             GstDiscovererInfo* info,
                                             GError* err);
static gboolean __lambda5_ (const gchar* a,
                     const gchar* b);
static gboolean ___lambda5__gequal_func (gconstpointer a,
                                  gconstpointer b);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN void music_audio_object_set_duration (MusicAudioObject* self,
                                      gint64 value);
VALA_EXTERN void music_audio_object_set_album (MusicAudioObject* self,
                                   const gchar* value);
VALA_EXTERN void music_audio_object_set_artist (MusicAudioObject* self,
                                    const gchar* value);
static gchar* music_playback_manager_get_art_cache_dir (MusicPlaybackManager* self);
VALA_EXTERN void music_audio_object_set_art_url (MusicAudioObject* self,
                                     const gchar* value);
VALA_EXTERN void music_audio_object_set_texture (MusicAudioObject* self,
                                     GdkTexture* value);
static GstSample* music_playback_manager_get_cover_sample (MusicPlaybackManager* self,
                                                    GstTagList* tag_list);
static GdkPixbuf* music_playback_manager_get_pixbuf_from_buffer (MusicPlaybackManager* self,
                                                          GstBuffer* buffer);
static void music_playback_manager_save_art_file (MusicPlaybackManager* self,
                                           GdkTexture* texture,
                                           GFile* file,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
static gchar* music_playback_manager_save_art_file_finish (MusicPlaybackManager* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static void ______lambda6_ (Block4Data* _data4_,
                     GObject* obj,
                     GAsyncResult* res);
static void _______lambda6__gasync_ready_callback (GObject* source_object,
                                            GAsyncResult* res,
                                            gpointer self);
static gboolean music_playback_manager_bus_callback (MusicPlaybackManager* self,
                                              GstBus* bus,
                                              GstMessage* message);
static void music_playback_manager_next (MusicPlaybackManager* self,
                                  gboolean eos);
static void music_playback_manager_previous (MusicPlaybackManager* self);
static GVariant* _variant_new1 (gboolean value);
static gboolean ____lambda7_ (MusicPlaybackManager* self);
static void music_playback_manager_set_playback_position (MusicPlaybackManager* self,
                                                   gint64 value);
static gboolean _____lambda7__gsource_func (gpointer self);
static GVariant* _variant_new2 (gboolean value);
static void music_playback_manager_play_pause (MusicPlaybackManager* self,
                                        GSimpleAction* action,
                                        GVariant* value);
static void music_playback_manager_shuffle (MusicPlaybackManager* self);
static void music_playback_manager_update_next_previous_sensitivity (MusicPlaybackManager* self);
static void music_playback_manager_save_art_file_data_free (gpointer _data);
static gboolean music_playback_manager_save_art_file_co (MusicPlaybackManagerSaveArtFileData* _data_);
static void music_playback_manager_save_art_file_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_);
static void music_playback_manager_on_items_changed (MusicPlaybackManager* self);
static void music_playback_manager_set_has_items (MusicPlaybackManager* self,
                                           gboolean value);
static void music_playback_manager_save_queue (MusicPlaybackManager* self);
static void music_playback_manager_on_audio_changed (MusicPlaybackManager* self);
VALA_EXTERN void music_playback_manager_restore_queue (MusicPlaybackManager* self);
VALA_EXTERN GFile** music_application_loop_through_files (GFile** files,
                                              gint files_length1,
                                              gint* result_length1);
VALA_EXTERN gboolean music_audio_object_equal_func (MusicAudioObject* a,
                                        MusicAudioObject* b);
static void music_playback_manager_set_queue_liststore (MusicPlaybackManager* self,
                                                 GListStore* value);
VALA_EXTERN gboolean music_playback_manager_get_has_items (MusicPlaybackManager* self);
VALA_EXTERN guint music_playback_manager_get_n_items (MusicPlaybackManager* self);
VALA_EXTERN gint64 music_playback_manager_get_playback_position (MusicPlaybackManager* self);
static GObject * music_playback_manager_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gboolean _music_playback_manager_bus_callback_gst_bus_func (GstBus* bus,
                                                            GstMessage* message,
                                                            gpointer self);
static void _music_playback_manager_update_metadata_gst_discoverer_discovered (GstDiscoverer* _sender,
                                                                        GstDiscovererInfo* info,
                                                                        GError* err,
                                                                        gpointer self);
static void _gst_discoverer_stop_gst_discoverer_finished (GstDiscoverer* _sender,
                                                   gpointer self);
static void _music_playback_manager_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                          guint position,
                                                                          guint removed,
                                                                          guint added,
                                                                          gpointer self);
static void _music_playback_manager_on_audio_changed_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self);
static void _music_playback_manager_clear_queue_g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _music_playback_manager___lambda8_ (MusicPlaybackManager* self);
static void __music_playback_manager___lambda8__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _music_playback_manager_play_pause_g_simple_action_change_state (GSimpleAction* _sender,
                                                                      GVariant* value,
                                                                      gpointer self);
static void _music_playback_manager_previous_g_simple_action_activate (GSimpleAction* _sender,
                                                                GVariant* parameter,
                                                                gpointer self);
static void _music_playback_manager_shuffle_g_simple_action_activate (GSimpleAction* _sender,
                                                               GVariant* parameter,
                                                               gpointer self);
static void music_playback_manager_finalize (GObject * obj);
static GType music_playback_manager_get_type_once (void);
static void _vala_music_playback_manager_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_music_playback_manager_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
music_playback_manager_get_instance_private (MusicPlaybackManager* self)
{
	return G_STRUCT_MEMBER_P (self, MusicPlaybackManager_private_offset);
}

static GType
music_playback_manager_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE, "MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE", "none"}, {MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT, "MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT", "next"}, {MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS, "MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS", "previous"}, {0, NULL, NULL}};
	GType music_playback_manager_direction_type_id;
	music_playback_manager_direction_type_id = g_enum_register_static ("MusicPlaybackManagerDirection", values);
	return music_playback_manager_direction_type_id;
}

static GType
music_playback_manager_direction_get_type (void)
{
	static volatile gsize music_playback_manager_direction_type_id__once = 0;
	if (g_once_init_enter (&music_playback_manager_direction_type_id__once)) {
		GType music_playback_manager_direction_type_id;
		music_playback_manager_direction_type_id = music_playback_manager_direction_get_type_once ();
		g_once_init_leave (&music_playback_manager_direction_type_id__once, music_playback_manager_direction_type_id);
	}
	return music_playback_manager_direction_type_id__once;
}

static MusicPlaybackManager*
__lambda4_ (void)
{
	MusicPlaybackManager* _tmp0_;
	MusicPlaybackManager* result;
	_tmp0_ = music_playback_manager_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda4_ ();
	return result;
}

MusicPlaybackManager*
music_playback_manager_get_default (void)
{
	gconstpointer _tmp0_;
	MusicPlaybackManager* result;
	_tmp0_ = g_once (&music_playback_manager_instance, ___lambda4__gthread_func, NULL);
	result = (MusicPlaybackManager*) _tmp0_;
	return result;
}

static MusicPlaybackManager*
music_playback_manager_construct (GType object_type)
{
	MusicPlaybackManager * self = NULL;
	self = (MusicPlaybackManager*) g_object_new (object_type, NULL);
	return self;
}

static MusicPlaybackManager*
music_playback_manager_new (void)
{
	return music_playback_manager_construct (MUSIC_TYPE_PLAYBACK_MANAGER);
}

void
music_playback_manager_seek_to_progress (MusicPlaybackManager* self,
                                         gdouble percent)
{
	GstElement* _tmp0_;
	MusicAudioObject* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	_tmp1_ = self->priv->_current_audio;
	_tmp2_ = music_audio_object_get_duration (_tmp1_);
	_tmp3_ = _tmp2_;
	gst_element_seek_simple (_tmp0_, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, (gint64) (percent * _tmp3_));
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
music_playback_manager_queue_files (MusicPlaybackManager* self,
                                    GFile** files,
                                    gint files_length1)
{
	GstDiscoverer* _tmp0_;
	gint invalids = 0;
	MusicAudioObject* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->discoverer;
	gst_discoverer_start (_tmp0_);
	invalids = 0;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* file = NULL;
			file = file_collection[file_it];
			{
				gboolean _tmp1_ = FALSE;
				GFile* _tmp2_;
				_tmp2_ = file;
				if (g_file_query_exists (_tmp2_, NULL)) {
					GFile* _tmp3_;
					gchar* _tmp4_;
					gchar* _tmp5_;
					gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp3_ = file;
					_tmp4_ = g_file_get_uri (_tmp3_);
					_tmp5_ = _tmp4_;
					_tmp6_ = g_content_type_guess (_tmp5_, NULL, (gsize) 0, NULL);
					_tmp7_ = _tmp6_;
					_tmp1_ = string_contains (_tmp7_, "audio");
					_g_free0 (_tmp7_);
					_g_free0 (_tmp5_);
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					MusicAudioObject* audio_object = NULL;
					GFile* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					MusicAudioObject* _tmp11_;
					MusicAudioObject* _tmp12_;
					gchar* basename = NULL;
					GFile* _tmp13_;
					gchar* _tmp14_;
					const gchar* _tmp15_;
					GstDiscoverer* _tmp22_;
					MusicAudioObject* _tmp23_;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					GListStore* _tmp26_;
					MusicAudioObject* _tmp27_;
					_tmp8_ = file;
					_tmp9_ = g_file_get_uri (_tmp8_);
					_tmp10_ = _tmp9_;
					_tmp11_ = music_audio_object_new (_tmp10_);
					_tmp12_ = _tmp11_;
					_g_free0 (_tmp10_);
					audio_object = _tmp12_;
					_tmp13_ = file;
					_tmp14_ = g_file_get_basename (_tmp13_);
					basename = _tmp14_;
					_tmp15_ = basename;
					if (_tmp15_ != NULL) {
						MusicAudioObject* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = audio_object;
						_tmp17_ = basename;
						music_audio_object_set_title (_tmp16_, _tmp17_);
					} else {
						MusicAudioObject* _tmp18_;
						MusicAudioObject* _tmp19_;
						const gchar* _tmp20_;
						const gchar* _tmp21_;
						_tmp18_ = audio_object;
						_tmp19_ = audio_object;
						_tmp20_ = music_audio_object_get_uri (_tmp19_);
						_tmp21_ = _tmp20_;
						music_audio_object_set_title (_tmp18_, _tmp21_);
					}
					_tmp22_ = self->priv->discoverer;
					_tmp23_ = audio_object;
					_tmp24_ = music_audio_object_get_uri (_tmp23_);
					_tmp25_ = _tmp24_;
					gst_discoverer_discover_uri_async (_tmp22_, _tmp25_);
					_tmp26_ = self->priv->_queue_liststore;
					_tmp27_ = audio_object;
					g_list_store_append (_tmp26_, (GObject*) _tmp27_);
					_g_free0 (basename);
					_g_object_unref0 (audio_object);
				} else {
					gint _tmp28_;
					_tmp28_ = invalids;
					invalids = _tmp28_ + 1;
					continue;
				}
			}
		}
	}
	if (invalids > 0) {
		g_signal_emit (self, music_playback_manager_signals[MUSIC_PLAYBACK_MANAGER_INVALIDS_FOUND_SIGNAL], 0, invalids);
	}
	_tmp29_ = self->priv->_current_audio;
	if (_tmp29_ == NULL) {
		MusicAudioObject* audio_object = NULL;
		GListStore* _tmp30_;
		GObject* _tmp31_;
		MusicAudioObject* _tmp32_;
		_tmp30_ = self->priv->_queue_liststore;
		_tmp31_ = g_list_model_get_object ((GListModel*) _tmp30_, (guint) 0);
		audio_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		_tmp32_ = audio_object;
		if (_tmp32_ != NULL) {
			MusicAudioObject* _tmp33_;
			_tmp33_ = audio_object;
			music_playback_manager_set_current_audio (self, _tmp33_);
		}
		_g_object_unref0 (audio_object);
	} else {
		GtkApplication* application = NULL;
		GApplication* _tmp34_;
		GtkApplication* _tmp35_;
		gint added_tracks = 0;
		gboolean _tmp36_ = FALSE;
		GtkApplication* _tmp37_;
		GtkWindow* _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp40_;
		_tmp34_ = g_application_get_default ();
		_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_application_get_type (), GtkApplication));
		application = _tmp35_;
		added_tracks = files_length1 - invalids;
		_tmp37_ = application;
		_tmp38_ = gtk_application_get_active_window (_tmp37_);
		g_object_get (_tmp38_, "is-active", &_tmp39_, NULL);
		_tmp40_ = _tmp39_;
		if (!_tmp40_) {
			_tmp36_ = added_tracks > 0;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			GNotification* notification = NULL;
			gchar* _tmp41_;
			gchar* _tmp42_;
			GNotification* _tmp43_;
			GNotification* _tmp44_;
			GNotification* _tmp45_;
			GThemedIcon* _tmp46_;
			GThemedIcon* _tmp47_;
			GtkApplication* _tmp48_;
			GNotification* _tmp49_;
			_tmp41_ = g_strdup_printf (ngettext ("%d track was added to the queue", "%d tracks were added to the queue", (gulong) added_tracks), added_tracks);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_notification_new (_tmp42_);
			_tmp44_ = _tmp43_;
			_g_free0 (_tmp42_);
			notification = _tmp44_;
			_tmp45_ = notification;
			_tmp46_ = (GThemedIcon*) g_themed_icon_new ("playlist-queue");
			_tmp47_ = _tmp46_;
			g_notification_set_icon (_tmp45_, (GIcon*) _tmp47_);
			_g_object_unref0 (_tmp47_);
			_tmp48_ = application;
			_tmp49_ = notification;
			g_application_send_notification ((GApplication*) _tmp48_, "queue-files", _tmp49_);
			_g_object_unref0 (notification);
		}
		_g_object_unref0 (application);
	}
}

static void
music_playback_manager_clear_queue (MusicPlaybackManager* self)
{
	GstElement* _tmp0_;
	GListStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	music_playback_manager_set_current_audio (self, NULL);
	_tmp1_ = self->priv->_queue_liststore;
	g_list_store_remove_all (_tmp1_);
}

void
music_playback_manager_remove (MusicPlaybackManager* self,
                               MusicAudioObject* song)
{
	MusicAudioObject* _tmp0_;
	guint position = 0U;
	GListStore* _tmp2_;
	guint _tmp3_ = 0U;
	GListStore* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (song != NULL);
	_tmp0_ = self->priv->_current_audio;
	if (song == _tmp0_) {
		GstElement* _tmp1_;
		_tmp1_ = self->priv->playbin;
		gst_element_set_state (_tmp1_, GST_STATE_NULL);
		music_playback_manager_set_current_audio (self, NULL);
	}
	_tmp2_ = self->priv->_queue_liststore;
	g_list_store_find (_tmp2_, (GObject*) song, &_tmp3_);
	position = _tmp3_;
	_tmp4_ = self->priv->_queue_liststore;
	g_list_store_remove (_tmp4_, position);
}

static gboolean
__lambda5_ (const gchar* a,
            const gchar* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = music_audio_object_get_uri (G_TYPE_CHECK_INSTANCE_CAST (a, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject));
	_tmp1_ = _tmp0_;
	_tmp2_ = music_audio_object_get_uri (G_TYPE_CHECK_INSTANCE_CAST (b, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject));
	_tmp3_ = _tmp2_;
	result = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	return result;
}

static gboolean
___lambda5__gequal_func (gconstpointer a,
                         gconstpointer b)
{
	gboolean result;
	result = __lambda5_ ((const gchar*) a, (const gchar*) b);
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		MusicPlaybackManager* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->audio_object);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_gst_buffer_ref0 (gpointer self)
{
	return self ? gst_buffer_ref (self) : NULL;
}

static void
______lambda6_ (Block4Data* _data4_,
                GObject* obj,
                GAsyncResult* res)
{
	MusicPlaybackManager* self;
	GError* _inner_error0_ = NULL;
	self = _data4_->self;
	g_return_if_fail (res != NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		MusicAudioObject* _tmp2_;
		_tmp1_ = music_playback_manager_save_art_file_finish (self, res, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _data4_->audio_object;
		music_audio_object_set_art_url (_tmp2_, _tmp0_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("PlaybackManager.vala:260: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_______lambda6__gasync_ready_callback (GObject* source_object,
                                       GAsyncResult* res,
                                       gpointer self)
{
	______lambda6_ (self, source_object, res);
	block4_data_unref (self);
}

static void
music_playback_manager_update_metadata (MusicPlaybackManager* self,
                                        GstDiscovererInfo* info,
                                        GError* err)
{
	gchar* uri = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GEqualFunc equal_func = NULL;
	MusicAudioObject* temp_audio_object = NULL;
	const gchar* _tmp8_;
	MusicAudioObject* _tmp9_;
	guint position = 0U;
	GListStore* _tmp10_;
	MusicAudioObject* _tmp11_;
	GEqualFunc _tmp12_;
	guint _tmp13_ = 0U;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = gst_discoverer_info_get_uri (info);
	_tmp1_ = g_strdup (_tmp0_);
	uri = _tmp1_;
	switch (gst_discoverer_info_get_result (info)) {
		case GST_DISCOVERER_URI_INVALID:
		{
			const gchar* _tmp2_;
			_tmp2_ = uri;
			g_critical ("PlaybackManager.vala:180: Couldn't read metadata for '%s': invalid URI" \
".", _tmp2_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_ERROR:
		{
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = uri;
			_tmp4_ = err->message;
			g_critical ("PlaybackManager.vala:183: Couldn't read metadata for '%s': %s", _tmp3_, _tmp4_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_TIMEOUT:
		{
			const gchar* _tmp5_;
			_tmp5_ = uri;
			g_critical ("PlaybackManager.vala:186: Couldn't read metadata for '%s': Discovery t" \
"imed out.", _tmp5_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_BUSY:
		{
			const gchar* _tmp6_;
			_tmp6_ = uri;
			g_critical ("PlaybackManager.vala:189: Couldn't read metadata for '%s': Already dis" \
"covering a file.", _tmp6_);
			_g_free0 (uri);
			return;
		}
		case GST_DISCOVERER_MISSING_PLUGINS:
		{
			const gchar* _tmp7_;
			_tmp7_ = uri;
			g_critical ("PlaybackManager.vala:192: Couldn't read metadata for '%s': Missing plu" \
"gins.", _tmp7_);
			_g_free0 (uri);
			return;
		}
		default:
		{
			break;
		}
	}
	equal_func = ___lambda5__gequal_func;
	_tmp8_ = uri;
	_tmp9_ = music_audio_object_new (_tmp8_);
	temp_audio_object = _tmp9_;
	position = (guint) -1;
	_tmp10_ = self->priv->_queue_liststore;
	_tmp11_ = temp_audio_object;
	_tmp12_ = equal_func;
	g_list_store_find_with_equal_func (_tmp10_, (GObject*) _tmp11_, _tmp12_, &_tmp13_);
	position = _tmp13_;
	if (position != ((guint) -1)) {
		Block4Data* _data4_;
		GListStore* _tmp14_;
		GObject* _tmp15_;
		MusicAudioObject* _tmp16_;
		GstTagList* tag_list = NULL;
		GstTagList* _tmp17_;
		gchar* _album = NULL;
		GstTagList* _tmp18_;
		gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		gchar* _title = NULL;
		GstTagList* _tmp23_;
		gchar* _tmp24_ = NULL;
		const gchar* _tmp25_;
		gchar* _artist = NULL;
		GstTagList* _tmp28_;
		gchar* _tmp29_ = NULL;
		const gchar* _tmp30_;
		gchar* art_hash = NULL;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gboolean _tmp37_ = FALSE;
		const gchar* _tmp38_;
		GFile* art_file = NULL;
		gchar* _tmp43_;
		gchar* _tmp44_;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		GFile* _tmp50_;
		GFile* _tmp51_;
		GFile* _tmp52_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_tmp14_ = self->priv->_queue_liststore;
		_tmp15_ = g_list_model_get_item ((GListModel*) _tmp14_, position);
		_data4_->audio_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		_tmp16_ = _data4_->audio_object;
		music_audio_object_set_duration (_tmp16_, (gint64) gst_discoverer_info_get_duration (info));
		_tmp17_ = gst_discoverer_info_get_tags (info);
		tag_list = _tmp17_;
		_tmp18_ = tag_list;
		gst_tag_list_get_string (_tmp18_, GST_TAG_ALBUM, &_tmp19_);
		_g_free0 (_album);
		_album = _tmp19_;
		_tmp20_ = _album;
		if (_tmp20_ != NULL) {
			MusicAudioObject* _tmp21_;
			const gchar* _tmp22_;
			_tmp21_ = _data4_->audio_object;
			_tmp22_ = _album;
			music_audio_object_set_album (_tmp21_, _tmp22_);
		}
		_tmp23_ = tag_list;
		gst_tag_list_get_string (_tmp23_, GST_TAG_TITLE, &_tmp24_);
		_g_free0 (_title);
		_title = _tmp24_;
		_tmp25_ = _title;
		if (_tmp25_ != NULL) {
			MusicAudioObject* _tmp26_;
			const gchar* _tmp27_;
			_tmp26_ = _data4_->audio_object;
			_tmp27_ = _title;
			music_audio_object_set_title (_tmp26_, _tmp27_);
		}
		_tmp28_ = tag_list;
		gst_tag_list_get_string (_tmp28_, GST_TAG_ARTIST, &_tmp29_);
		_g_free0 (_artist);
		_artist = _tmp29_;
		_tmp30_ = _artist;
		if (_tmp30_ != NULL) {
			MusicAudioObject* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = _data4_->audio_object;
			_tmp32_ = _artist;
			music_audio_object_set_artist (_tmp31_, _tmp32_);
		} else {
			const gchar* _tmp33_;
			_tmp33_ = _title;
			if (_tmp33_ != NULL) {
				MusicAudioObject* _tmp34_;
				_tmp34_ = _data4_->audio_object;
				music_audio_object_set_artist (_tmp34_, _ ("Unknown"));
			}
		}
		_tmp35_ = uri;
		_tmp36_ = g_strdup (_tmp35_);
		art_hash = _tmp36_;
		_tmp38_ = _artist;
		if (_tmp38_ != NULL) {
			const gchar* _tmp39_;
			_tmp39_ = _album;
			_tmp37_ = _tmp39_ != NULL;
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			gchar* _tmp42_;
			_tmp40_ = _artist;
			_tmp41_ = _album;
			_tmp42_ = g_strdup_printf ("%s:%s", _tmp40_, _tmp41_);
			_g_free0 (art_hash);
			art_hash = _tmp42_;
		}
		_tmp43_ = music_playback_manager_get_art_cache_dir (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = art_hash;
		_tmp46_ = g_compute_checksum_for_string (G_CHECKSUM_SHA256, _tmp45_, (gsize) -1);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_build_path (G_DIR_SEPARATOR_S, _tmp44_, _tmp47_, NULL);
		_tmp49_ = _tmp48_;
		_tmp50_ = g_file_new_for_path (_tmp49_);
		_tmp51_ = _tmp50_;
		_g_free0 (_tmp49_);
		_g_free0 (_tmp47_);
		_g_free0 (_tmp44_);
		art_file = _tmp51_;
		_tmp52_ = art_file;
		if (g_file_query_exists (_tmp52_, NULL)) {
			MusicAudioObject* _tmp53_;
			GFile* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			GdkTexture* _tmp57_ = NULL;
			GFile* _tmp58_;
			GdkTexture* _tmp59_;
			MusicAudioObject* _tmp60_;
			_tmp53_ = _data4_->audio_object;
			_tmp54_ = art_file;
			_tmp55_ = g_file_get_uri (_tmp54_);
			_tmp56_ = _tmp55_;
			music_audio_object_set_art_url (_tmp53_, _tmp56_);
			_g_free0 (_tmp56_);
			_tmp58_ = art_file;
			_tmp59_ = gdk_texture_new_from_file (_tmp58_, &_inner_error0_);
			_tmp57_ = _tmp59_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (art_file);
				_g_free0 (art_hash);
				_g_free0 (_artist);
				_g_free0 (_title);
				_g_free0 (_album);
				block4_data_unref (_data4_);
				_data4_ = NULL;
				_g_object_unref0 (temp_audio_object);
				_g_free0 (uri);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp60_ = _data4_->audio_object;
			music_audio_object_set_texture (_tmp60_, _tmp57_);
			_g_object_unref0 (_tmp57_);
		} else {
			GstSample* sample = NULL;
			GstTagList* _tmp61_;
			GstSample* _tmp62_;
			GstSample* _tmp63_;
			_tmp61_ = tag_list;
			_tmp62_ = music_playback_manager_get_cover_sample (self, _tmp61_);
			sample = _tmp62_;
			_tmp63_ = sample;
			if (_tmp63_ != NULL) {
				GstBuffer* buffer = NULL;
				GstSample* _tmp64_;
				GstBuffer* _tmp65_;
				GstBuffer* _tmp66_;
				GstBuffer* _tmp67_;
				_tmp64_ = sample;
				_tmp65_ = gst_sample_get_buffer (_tmp64_);
				_tmp66_ = _gst_buffer_ref0 (_tmp65_);
				buffer = _tmp66_;
				_tmp67_ = buffer;
				if (_tmp67_ != NULL) {
					GdkTexture* texture = NULL;
					GstBuffer* _tmp68_;
					GdkPixbuf* _tmp69_;
					GdkPixbuf* _tmp70_;
					GdkTexture* _tmp71_;
					GdkTexture* _tmp72_;
					MusicAudioObject* _tmp73_;
					GdkTexture* _tmp74_;
					GdkTexture* _tmp75_;
					GFile* _tmp76_;
					_tmp68_ = buffer;
					_tmp69_ = music_playback_manager_get_pixbuf_from_buffer (self, _tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = gdk_texture_new_for_pixbuf (_tmp70_);
					_tmp72_ = _tmp71_;
					_g_object_unref0 (_tmp70_);
					texture = _tmp72_;
					_tmp73_ = _data4_->audio_object;
					_tmp74_ = texture;
					music_audio_object_set_texture (_tmp73_, _tmp74_);
					_tmp75_ = texture;
					_tmp76_ = art_file;
					music_playback_manager_save_art_file (self, _tmp75_, _tmp76_, _______lambda6__gasync_ready_callback, block4_data_ref (_data4_));
					_g_object_unref0 (texture);
				}
				_gst_buffer_unref0 (buffer);
			}
			_gst_sample_unref0 (sample);
		}
		_g_object_unref0 (art_file);
		_g_free0 (art_hash);
		_g_free0 (_artist);
		_g_free0 (_title);
		_g_free0 (_album);
		block4_data_unref (_data4_);
		_data4_ = NULL;
	} else {
		const gchar* _tmp77_;
		_tmp77_ = uri;
		g_critical ("PlaybackManager.vala:267: Couldn't find '%s' in queue", _tmp77_);
	}
	_g_object_unref0 (temp_audio_object);
	_g_free0 (uri);
}

static GVariant*
_variant_new1 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gboolean
____lambda7_ (MusicPlaybackManager* self)
{
	gint64 position = 0LL;
	GstElement* _tmp0_;
	gint64 _tmp1_ = 0LL;
	MusicAudioObject* _tmp2_;
	gint64 _tmp3_;
	gint64 _tmp4_;
	gboolean result;
	position = (gint64) 0;
	_tmp0_ = self->priv->playbin;
	gst_element_query_position (_tmp0_, GST_FORMAT_TIME, &_tmp1_);
	position = _tmp1_;
	_tmp2_ = self->priv->_current_audio;
	_tmp3_ = music_audio_object_get_duration (_tmp2_);
	_tmp4_ = _tmp3_;
	music_playback_manager_set_playback_position (self, CLAMP (position, (gint64) 0, _tmp4_));
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
_____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ____lambda7_ ((MusicPlaybackManager*) self);
	return result;
}

static GVariant*
_variant_new2 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static gboolean
music_playback_manager_bus_callback (MusicPlaybackManager* self,
                                     GstBus* bus,
                                     GstMessage* message)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bus != NULL, FALSE);
	g_return_val_if_fail (message != NULL, FALSE);
	switch (message->type) {
		case GST_MESSAGE_EOS:
		{
			music_playback_manager_next (self, TRUE);
			break;
		}
		case GST_MESSAGE_ERROR:
		{
			switch (self->priv->direction) {
				case MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT:
				{
					music_playback_manager_next (self, self->priv->next_by_eos);
					break;
				}
				case MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS:
				{
					music_playback_manager_previous (self);
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		case GST_MESSAGE_STATE_CHANGED:
		{
			GstState old_state = 0;
			GstState new_state = 0;
			GstState pending_state = 0;
			GstState _tmp0_ = 0;
			GstState _tmp1_ = 0;
			GstState _tmp2_ = 0;
			if (self->priv->progress_timer != ((guint) 0)) {
				g_source_remove (self->priv->progress_timer);
				self->priv->progress_timer = (guint) 0;
			}
			gst_message_parse_state_changed (message, &_tmp0_, &_tmp1_, &_tmp2_);
			old_state = _tmp0_;
			new_state = _tmp1_;
			pending_state = _tmp2_;
			if (new_state == GST_STATE_PLAYING) {
				GSimpleAction* _tmp3_;
				GVariant* _tmp4_;
				_tmp3_ = self->priv->play_pause_action;
				_tmp4_ = _variant_new1 (TRUE);
				g_simple_action_set_state (_tmp3_, _tmp4_);
				_g_variant_unref0 (_tmp4_);
				self->priv->progress_timer = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _____lambda7__gsource_func, g_object_ref (self), g_object_unref);
			} else {
				GSimpleAction* _tmp5_;
				GVariant* _tmp6_;
				_tmp5_ = self->priv->play_pause_action;
				_tmp6_ = _variant_new2 (FALSE);
				g_simple_action_set_state (_tmp5_, _tmp6_);
				_g_variant_unref0 (_tmp6_);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	result = TRUE;
	return result;
}

static void
music_playback_manager_play_pause (MusicPlaybackManager* self,
                                   GSimpleAction* action,
                                   GVariant* value)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_simple_action_set_state (action, value);
	if (g_variant_get_boolean (value)) {
		GstElement* _tmp0_;
		_tmp0_ = self->priv->playbin;
		gst_element_set_state (_tmp0_, GST_STATE_PLAYING);
	} else {
		GstElement* _tmp1_;
		_tmp1_ = self->priv->playbin;
		gst_element_set_state (_tmp1_, GST_STATE_PAUSED);
	}
}

static void
music_playback_manager_next (MusicPlaybackManager* self,
                             gboolean eos)
{
	guint position = 0U;
	GListStore* _tmp0_;
	MusicAudioObject* _tmp1_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	self->priv->direction = MUSIC_PLAYBACK_MANAGER_DIRECTION_NEXT;
	self->priv->next_by_eos = eos;
	position = (guint) -1;
	_tmp0_ = self->priv->_queue_liststore;
	_tmp1_ = self->priv->_current_audio;
	g_list_store_find (_tmp0_, (GObject*) _tmp1_, &_tmp2_);
	position = _tmp2_;
	if (position != ((guint) -1)) {
		GSettings* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GQuark _tmp14_ = 0U;
		static GQuark _tmp13_label0 = 0;
		static GQuark _tmp13_label1 = 0;
		static GQuark _tmp13_label2 = 0;
		if (!self->priv->next_by_eos) {
			GListStore* _tmp3_;
			_tmp3_ = self->priv->_queue_liststore;
			if (position == (g_list_model_get_n_items ((GListModel*) _tmp3_) - 1)) {
				GListStore* _tmp4_;
				GObject* _tmp5_;
				MusicAudioObject* _tmp6_;
				_tmp4_ = self->priv->_queue_liststore;
				_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, (guint) 0);
				_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
				music_playback_manager_set_current_audio (self, _tmp6_);
				_g_object_unref0 (_tmp6_);
				if (position == ((guint) 0)) {
					music_playback_manager_seek_to_progress (self, (gdouble) 0);
				}
			} else {
				GListStore* _tmp7_;
				GObject* _tmp8_;
				MusicAudioObject* _tmp9_;
				_tmp7_ = self->priv->_queue_liststore;
				_tmp8_ = g_list_model_get_item ((GListModel*) _tmp7_, position + 1);
				_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
				music_playback_manager_set_current_audio (self, _tmp9_);
				_g_object_unref0 (_tmp9_);
			}
			return;
		}
		_tmp10_ = self->priv->settings;
		_tmp11_ = g_settings_get_string (_tmp10_, "repeat-mode");
		_tmp12_ = _tmp11_;
		_tmp14_ = (NULL == _tmp12_) ? 0 : g_quark_from_string (_tmp12_);
		g_free (_tmp12_);
		if (_tmp14_ == ((0 != _tmp13_label0) ? _tmp13_label0 : (_tmp13_label0 = g_quark_from_static_string ("disabled")))) {
			switch (0) {
				default:
				{
					GListStore* _tmp15_;
					GListStore* _tmp16_;
					GObject* _tmp17_;
					MusicAudioObject* _tmp18_;
					_tmp15_ = self->priv->_queue_liststore;
					if (position == (g_list_model_get_n_items ((GListModel*) _tmp15_) - 1)) {
						music_playback_manager_set_current_audio (self, NULL);
						return;
					}
					_tmp16_ = self->priv->_queue_liststore;
					_tmp17_ = g_list_model_get_item ((GListModel*) _tmp16_, position + 1);
					_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
					music_playback_manager_set_current_audio (self, _tmp18_);
					_g_object_unref0 (_tmp18_);
					break;
				}
			}
		} else if (_tmp14_ == ((0 != _tmp13_label1) ? _tmp13_label1 : (_tmp13_label1 = g_quark_from_static_string ("all")))) {
			switch (0) {
				default:
				{
					GListStore* _tmp19_;
					_tmp19_ = self->priv->_queue_liststore;
					if (position == (g_list_model_get_n_items ((GListModel*) _tmp19_) - 1)) {
						GListStore* _tmp20_;
						GObject* _tmp21_;
						MusicAudioObject* _tmp22_;
						_tmp20_ = self->priv->_queue_liststore;
						_tmp21_ = g_list_model_get_item ((GListModel*) _tmp20_, (guint) 0);
						_tmp22_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
						music_playback_manager_set_current_audio (self, _tmp22_);
						_g_object_unref0 (_tmp22_);
						if (position == ((guint) 0)) {
							music_playback_manager_seek_to_progress (self, (gdouble) 0);
						}
					} else {
						GListStore* _tmp23_;
						GObject* _tmp24_;
						MusicAudioObject* _tmp25_;
						_tmp23_ = self->priv->_queue_liststore;
						_tmp24_ = g_list_model_get_item ((GListModel*) _tmp23_, position + 1);
						_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
						music_playback_manager_set_current_audio (self, _tmp25_);
						_g_object_unref0 (_tmp25_);
					}
					break;
				}
			}
		} else if (_tmp14_ == ((0 != _tmp13_label2) ? _tmp13_label2 : (_tmp13_label2 = g_quark_from_static_string ("one")))) {
			switch (0) {
				default:
				{
					music_playback_manager_seek_to_progress (self, (gdouble) 0);
					break;
				}
			}
		}
	}
}

static void
music_playback_manager_previous (MusicPlaybackManager* self)
{
	guint position = 0U;
	GListStore* _tmp0_;
	MusicAudioObject* _tmp1_;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->direction = MUSIC_PLAYBACK_MANAGER_DIRECTION_PREVIOUS;
	position = (guint) -1;
	_tmp0_ = self->priv->_queue_liststore;
	_tmp1_ = self->priv->_current_audio;
	g_list_store_find (_tmp0_, (GObject*) _tmp1_, &_tmp2_);
	position = _tmp2_;
	if (position != ((guint) -1)) {
		_tmp3_ = position != ((guint) 0);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GListStore* _tmp4_;
		GObject* _tmp5_;
		MusicAudioObject* _tmp6_;
		_tmp4_ = self->priv->_queue_liststore;
		_tmp5_ = g_list_model_get_item ((GListModel*) _tmp4_, position - 1);
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		music_playback_manager_set_current_audio (self, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	if (position == ((guint) 0)) {
		guint n_items = 0U;
		GListStore* _tmp7_;
		_tmp7_ = self->priv->_queue_liststore;
		n_items = g_list_model_get_n_items ((GListModel*) _tmp7_);
		if (n_items == ((guint) 1)) {
			music_playback_manager_seek_to_progress (self, (gdouble) 0);
		} else {
			GListStore* _tmp8_;
			GObject* _tmp9_;
			MusicAudioObject* _tmp10_;
			_tmp8_ = self->priv->_queue_liststore;
			_tmp9_ = g_list_model_get_item ((GListModel*) _tmp8_, n_items - 1);
			_tmp10_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
			music_playback_manager_set_current_audio (self, _tmp10_);
			_g_object_unref0 (_tmp10_);
		}
	}
}

static void
music_playback_manager_shuffle (MusicPlaybackManager* self)
{
	GListStore* temp_list = NULL;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	MusicAudioObject* _tmp2_;
	guint position = 0U;
	GListStore* _tmp3_;
	MusicAudioObject* _tmp4_;
	guint _tmp5_ = 0U;
	GListStore* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_list_store_new (MUSIC_TYPE_AUDIO_OBJECT);
	temp_list = _tmp0_;
	_tmp1_ = temp_list;
	_tmp2_ = self->priv->_current_audio;
	g_list_store_append (_tmp1_, (GObject*) _tmp2_);
	position = (guint) -1;
	_tmp3_ = self->priv->_queue_liststore;
	_tmp4_ = self->priv->_current_audio;
	g_list_store_find (_tmp3_, (GObject*) _tmp4_, &_tmp5_);
	position = _tmp5_;
	_tmp6_ = self->priv->_queue_liststore;
	g_list_store_remove (_tmp6_, position);
	while (TRUE) {
		GListStore* _tmp7_;
		gint32 random_position = 0;
		GListStore* _tmp8_;
		GListStore* _tmp9_;
		GListStore* _tmp10_;
		GObject* _tmp11_;
		GObject* _tmp12_;
		GListStore* _tmp13_;
		_tmp7_ = self->priv->_queue_liststore;
		if (!(g_list_model_get_n_items ((GListModel*) _tmp7_) > ((guint) 0))) {
			break;
		}
		_tmp8_ = self->priv->_queue_liststore;
		random_position = g_random_int_range ((gint32) 0, (gint32) g_list_model_get_n_items ((GListModel*) _tmp8_));
		_tmp9_ = temp_list;
		_tmp10_ = self->priv->_queue_liststore;
		_tmp11_ = g_list_model_get_item ((GListModel*) _tmp10_, (guint) random_position);
		_tmp12_ = _tmp11_;
		g_list_store_append (_tmp9_, _tmp12_);
		_g_object_unref0 (_tmp12_);
		_tmp13_ = self->priv->_queue_liststore;
		g_list_store_remove (_tmp13_, (guint) random_position);
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				GListStore* _tmp16_;
				GListStore* _tmp17_;
				GListStore* _tmp18_;
				GObject* _tmp19_;
				GObject* _tmp20_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = temp_list;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp16_))) {
					break;
				}
				_tmp17_ = self->priv->_queue_liststore;
				_tmp18_ = temp_list;
				_tmp19_ = g_list_model_get_item ((GListModel*) _tmp18_, (guint) i);
				_tmp20_ = _tmp19_;
				g_list_store_append (_tmp17_, _tmp20_);
				_g_object_unref0 (_tmp20_);
			}
		}
	}
	_g_object_unref0 (temp_list);
}

static void
music_playback_manager_update_next_previous_sensitivity (MusicPlaybackManager* self)
{
	gboolean next_sensitive = FALSE;
	gboolean previous_sensitive = FALSE;
	MusicAudioObject* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	next_sensitive = FALSE;
	previous_sensitive = FALSE;
	_tmp0_ = self->priv->_current_audio;
	previous_sensitive = _tmp0_ != NULL;
	next_sensitive = previous_sensitive;
	_tmp1_ = self->priv->next_action;
	g_simple_action_set_enabled (_tmp1_, next_sensitive);
	_tmp2_ = self->priv->previous_action;
	g_simple_action_set_enabled (_tmp2_, previous_sensitive);
}

static gpointer
_gst_caps_ref0 (gpointer self)
{
	return self ? gst_caps_ref (self) : NULL;
}

static gpointer
_gst_sample_ref0 (gpointer self)
{
	return self ? gst_sample_ref (self) : NULL;
}

static GstSample*
music_playback_manager_get_cover_sample (MusicPlaybackManager* self,
                                         GstTagList* tag_list)
{
	GstSample* cover_sample = NULL;
	GstSample* sample = NULL;
	GstSample* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag_list != NULL, NULL);
	cover_sample = NULL;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GstSample* _tmp2_ = NULL;
				gboolean _tmp3_;
				GstCaps* caps = NULL;
				GstSample* _tmp4_;
				GstCaps* _tmp5_;
				GstCaps* _tmp6_;
				GstStructure* caps_struct = NULL;
				GstCaps* _tmp7_;
				GstStructure* _tmp8_;
				gint image_type = 0;
				GstStructure* _tmp9_;
				gint _tmp10_ = 0;
				gboolean _tmp11_ = FALSE;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = gst_tag_list_get_sample_index (tag_list, GST_TAG_IMAGE, (guint) i, &_tmp2_);
				_gst_sample_unref0 (sample);
				sample = _tmp2_;
				if (!_tmp3_) {
					break;
				}
				_tmp4_ = sample;
				_tmp5_ = gst_sample_get_caps (_tmp4_);
				_tmp6_ = _gst_caps_ref0 (_tmp5_);
				caps = _tmp6_;
				_tmp7_ = caps;
				_tmp8_ = gst_caps_get_structure (_tmp7_, (guint) 0);
				caps_struct = _tmp8_;
				image_type = (gint) GST_TAG_IMAGE_TYPE_UNDEFINED;
				_tmp9_ = caps_struct;
				gst_structure_get_enum (_tmp9_, "image-type", gst_tag_image_type_get_type (), &_tmp10_);
				image_type = _tmp10_;
				if (image_type == ((gint) GST_TAG_IMAGE_TYPE_UNDEFINED)) {
					GstSample* _tmp12_;
					_tmp12_ = cover_sample;
					_tmp11_ = _tmp12_ == NULL;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GstSample* _tmp13_;
					GstSample* _tmp14_;
					_tmp13_ = sample;
					_tmp14_ = _gst_sample_ref0 (_tmp13_);
					_gst_sample_unref0 (cover_sample);
					cover_sample = _tmp14_;
				} else {
					if (image_type == ((gint) GST_TAG_IMAGE_TYPE_FRONT_COVER)) {
						result = sample;
						_gst_caps_unref0 (caps);
						_gst_sample_unref0 (cover_sample);
						return result;
					}
				}
				_gst_caps_unref0 (caps);
			}
		}
	}
	result = cover_sample;
	_gst_sample_unref0 (sample);
	return result;
}

static GdkPixbuf*
music_playback_manager_get_pixbuf_from_buffer (MusicPlaybackManager* self,
                                               GstBuffer* buffer)
{
	GstMapInfo map_info = {0};
	GstMapInfo _tmp0_ = {0};
	gboolean _tmp1_;
	GdkPixbuf* pix = NULL;
	GstMapInfo _tmp15_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	_tmp1_ = gst_buffer_map (buffer, &_tmp0_, GST_MAP_READ);
	map_info = _tmp0_;
	if (!_tmp1_) {
		g_warning ("PlaybackManager.vala:447: Could not map memory buffer");
		result = NULL;
		return result;
	}
	pix = NULL;
	{
		GdkPixbufLoader* loader = NULL;
		GdkPixbufLoader* _tmp2_;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		GdkPixbufLoader* _tmp5_;
		GstMapInfo _tmp6_;
		guint8* _tmp7_;
		gint _tmp7__length1;
		_tmp2_ = gdk_pixbuf_loader_new ();
		loader = _tmp2_;
		_tmp5_ = loader;
		_tmp6_ = map_info;
		_tmp7_ = _tmp6_.data;
		_tmp7__length1 = _tmp6_.size;
		_tmp4_ = gdk_pixbuf_loader_write (_tmp5_, _tmp7_, (gsize) _tmp7__length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (loader);
			goto __catch0_g_error;
		}
		if (_tmp4_) {
			gboolean _tmp8_ = FALSE;
			GdkPixbufLoader* _tmp9_;
			_tmp9_ = loader;
			_tmp8_ = gdk_pixbuf_loader_close (_tmp9_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (loader);
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp8_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GdkPixbufLoader* _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			_tmp10_ = loader;
			_tmp11_ = gdk_pixbuf_loader_get_pixbuf (_tmp10_);
			_tmp12_ = _g_object_ref0 (_tmp11_);
			_g_object_unref0 (pix);
			pix = _tmp12_;
		}
		_g_object_unref0 (loader);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		g_warning ("PlaybackManager.vala:460: Error processing image data: %s", _tmp14_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pix);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp15_ = map_info;
	gst_buffer_unmap (buffer, &_tmp15_);
	result = pix;
	return result;
}

static void
music_playback_manager_save_art_file_data_free (gpointer _data)
{
	MusicPlaybackManagerSaveArtFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->texture);
	_g_object_unref0 (_data_->file);
	_g_free0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MusicPlaybackManagerSaveArtFileData, _data_);
}

static void
music_playback_manager_save_art_file (MusicPlaybackManager* self,
                                      GdkTexture* texture,
                                      GFile* file,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	MusicPlaybackManagerSaveArtFileData* _data_;
	MusicPlaybackManager* _tmp0_;
	GdkTexture* _tmp1_;
	GFile* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (texture != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (MusicPlaybackManagerSaveArtFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, music_playback_manager_save_art_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (texture);
	_g_object_unref0 (_data_->texture);
	_data_->texture = _tmp1_;
	_tmp2_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	music_playback_manager_save_art_file_co (_data_);
}

static gchar*
music_playback_manager_save_art_file_finish (MusicPlaybackManager* self,
                                             GAsyncResult* _res_,
                                             GError** error)
{
	gchar* result;
	MusicPlaybackManagerSaveArtFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
music_playback_manager_save_art_file_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_)
{
	MusicPlaybackManagerSaveArtFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	music_playback_manager_save_art_file_co (_data_);
}

static gboolean
music_playback_manager_save_art_file_co (MusicPlaybackManagerSaveArtFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_vala_return_val_if_fail (_data_->texture != NULL, "texture != null", FALSE);
	_data_->_tmp0_ = music_playback_manager_get_art_cache_dir (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	g_mkdir_with_parents (_data_->_tmp1_, 0755);
	_g_free0 (_data_->_tmp1_);
	_data_->_state_ = 1;
	g_file_create_async (_data_->file, G_FILE_CREATE_NONE, G_PRIORITY_DEFAULT, NULL, music_playback_manager_save_art_file_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = g_file_create_finish (_data_->file, _data_->_res_, &_data_->_inner_error0_);
	_data_->ostream = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->ostream;
	_data_->_tmp4_ = gdk_texture_save_to_png_bytes (_data_->texture);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_state_ = 2;
	g_output_stream_write_bytes_async ((GOutputStream*) _data_->_tmp3_, _data_->_tmp5_, G_PRIORITY_DEFAULT, NULL, music_playback_manager_save_art_file_ready, _data_);
	return FALSE;
	_state_2:
	g_output_stream_write_bytes_finish ((GOutputStream*) _data_->_tmp3_, _data_->_res_, &_data_->_inner_error0_);
	_g_bytes_unref0 (_data_->_tmp5_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->ostream);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = g_file_get_uri (_data_->file);
	_data_->result = _data_->_tmp6_;
	_g_object_unref0 (_data_->ostream);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
music_playback_manager_get_art_cache_dir (MusicPlaybackManager* self)
{
	const gchar* _tmp0_;
	GApplication* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_application_get_default ();
	_tmp2_ = g_application_get_application_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_path (G_DIR_SEPARATOR_S, _tmp0_, _tmp3_, "art", NULL);
	result = _tmp4_;
	return result;
}

static void
music_playback_manager_on_items_changed (MusicPlaybackManager* self)
{
	GListStore* _tmp0_;
	GSimpleAction* _tmp1_;
	GListStore* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_queue_liststore;
	music_playback_manager_set_has_items (self, g_list_model_get_n_items ((GListModel*) _tmp0_) > ((guint) 0));
	_tmp1_ = self->priv->shuffle_action;
	_tmp2_ = self->priv->_queue_liststore;
	g_simple_action_set_enabled (_tmp1_, g_list_model_get_n_items ((GListModel*) _tmp2_) > ((guint) 1));
	music_playback_manager_update_next_previous_sensitivity (self);
	music_playback_manager_save_queue (self);
}

static void
music_playback_manager_on_audio_changed (MusicPlaybackManager* self)
{
	GstElement* _tmp0_;
	MusicAudioObject* _tmp1_;
	GSimpleAction* _tmp8_;
	MusicAudioObject* _tmp9_;
	const gchar* _tmp10_ = NULL;
	MusicAudioObject* _tmp11_;
	gchar* uri_last_played = NULL;
	gchar* _tmp15_;
	GSettings* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playbin;
	gst_element_set_state (_tmp0_, GST_STATE_NULL);
	_tmp1_ = self->priv->_current_audio;
	if (_tmp1_ != NULL) {
		GstElement* _tmp2_;
		MusicAudioObject* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GstElement* _tmp6_;
		_tmp2_ = self->priv->playbin;
		_tmp3_ = self->priv->_current_audio;
		_tmp4_ = music_audio_object_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		g_object_set (_tmp2_, "uri", _tmp5_, NULL);
		_tmp6_ = self->priv->playbin;
		gst_element_set_state (_tmp6_, GST_STATE_PLAYING);
	} else {
		GstElement* _tmp7_;
		_tmp7_ = self->priv->playbin;
		g_object_set (_tmp7_, "uri", "", NULL);
		music_playback_manager_set_playback_position (self, (gint64) 0);
		if (self->priv->progress_timer != ((guint) 0)) {
			g_source_remove (self->priv->progress_timer);
			self->priv->progress_timer = (guint) 0;
		}
	}
	music_playback_manager_update_next_previous_sensitivity (self);
	_tmp8_ = self->priv->play_pause_action;
	_tmp9_ = self->priv->_current_audio;
	g_simple_action_set_enabled (_tmp8_, _tmp9_ != NULL);
	_tmp11_ = self->priv->_current_audio;
	if (_tmp11_ != NULL) {
		MusicAudioObject* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp12_ = self->priv->_current_audio;
		_tmp13_ = music_audio_object_get_uri (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp10_ = _tmp14_;
	} else {
		_tmp10_ = "";
	}
	_tmp15_ = g_strdup (_tmp10_);
	uri_last_played = _tmp15_;
	_tmp16_ = self->priv->settings;
	g_settings_set_string (_tmp16_, "uri-last-played", uri_last_played);
	_g_free0 (uri_last_played);
}

static void
music_playback_manager_save_queue (MusicPlaybackManager* self)
{
	gchar** list_uri = NULL;
	GListStore* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gchar** _tmp3_;
	gint list_uri_length1;
	gint _list_uri_size_;
	GSettings* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_queue_liststore;
	g_object_get (_tmp0_, "n-items", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gchar*, _tmp2_ + 1);
	list_uri = _tmp3_;
	list_uri_length1 = _tmp2_;
	_list_uri_size_ = list_uri_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				GListStore* _tmp6_;
				guint _tmp7_;
				guint _tmp8_;
				MusicAudioObject* item = NULL;
				GListStore* _tmp9_;
				GObject* _tmp10_;
				gchar** _tmp11_;
				gint _tmp11__length1;
				MusicAudioObject* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = self->priv->_queue_liststore;
				g_object_get (_tmp6_, "n-items", &_tmp7_, NULL);
				_tmp8_ = _tmp7_;
				if (!(((guint) i) < _tmp8_)) {
					break;
				}
				_tmp9_ = self->priv->_queue_liststore;
				_tmp10_ = g_list_model_get_item ((GListModel*) _tmp9_, (guint) i);
				item = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
				_tmp11_ = list_uri;
				_tmp11__length1 = list_uri_length1;
				_tmp12_ = item;
				_tmp13_ = music_audio_object_get_uri (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_strdup (_tmp14_);
				_g_free0 (_tmp11_[i]);
				_tmp11_[i] = _tmp15_;
				_g_object_unref0 (item);
			}
		}
	}
	_tmp16_ = self->priv->settings;
	_tmp17_ = list_uri;
	_tmp17__length1 = list_uri_length1;
	g_settings_set_strv (_tmp16_, "previous-queue", _tmp17_);
	list_uri = (_vala_array_free (list_uri, list_uri_length1, (GDestroyNotify) g_free), NULL);
}

void
music_playback_manager_restore_queue (MusicPlaybackManager* self)
{
	gchar* uri_last_played = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	GFile* file_last_played = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar** last_session_uri = NULL;
	GSettings* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint last_session_uri_length1;
	gint _last_session_uri_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GFile** last_session_files = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	GFile** _tmp9_;
	gint last_session_files_length1;
	gint _last_session_files_size_;
	GFile** files_to_play = NULL;
	GFile** _tmp21_;
	gint _tmp21__length1;
	gint _tmp22_ = 0;
	GFile** _tmp23_;
	gint files_to_play_length1;
	gint _files_to_play_size_;
	GFile** _tmp24_;
	gint _tmp24__length1;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "uri-last-played");
	uri_last_played = _tmp1_;
	_tmp2_ = uri_last_played;
	_tmp3_ = g_file_new_for_uri (_tmp2_);
	file_last_played = _tmp3_;
	_tmp4_ = self->priv->settings;
	_tmp6_ = _tmp5_ = g_settings_get_strv (_tmp4_, "previous-queue");
	last_session_uri = _tmp6_;
	last_session_uri_length1 = _vala_array_length (_tmp5_);
	_last_session_uri_size_ = last_session_uri_length1;
	_tmp7_ = last_session_uri;
	_tmp7__length1 = last_session_uri_length1;
	if (_tmp7__length1 == 0) {
		last_session_uri = (_vala_array_free (last_session_uri, last_session_uri_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (file_last_played);
		_g_free0 (uri_last_played);
		return;
	}
	_tmp8_ = last_session_uri;
	_tmp8__length1 = last_session_uri_length1;
	_tmp9_ = g_new0 (GFile*, _tmp8__length1 + 1);
	last_session_files = _tmp9_;
	last_session_files_length1 = _tmp8__length1;
	_last_session_files_size_ = last_session_files_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gchar** _tmp12_;
				gint _tmp12__length1;
				gchar* uri = NULL;
				gchar** _tmp13_;
				gint _tmp13__length1;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				GFile* file = NULL;
				const gchar* _tmp16_;
				GFile* _tmp17_;
				GFile** _tmp18_;
				gint _tmp18__length1;
				GFile* _tmp19_;
				GFile* _tmp20_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = last_session_uri;
				_tmp12__length1 = last_session_uri_length1;
				if (!(i < _tmp12__length1)) {
					break;
				}
				_tmp13_ = last_session_uri;
				_tmp13__length1 = last_session_uri_length1;
				_tmp14_ = _tmp13_[i];
				_tmp15_ = g_strdup (_tmp14_);
				uri = _tmp15_;
				_tmp16_ = uri;
				_tmp17_ = g_file_new_for_uri (_tmp16_);
				file = _tmp17_;
				_tmp18_ = last_session_files;
				_tmp18__length1 = last_session_files_length1;
				_tmp19_ = file;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (_tmp18_[i]);
				_tmp18_[i] = _tmp20_;
				_g_object_unref0 (file);
				_g_free0 (uri);
			}
		}
	}
	_tmp21_ = last_session_files;
	_tmp21__length1 = last_session_files_length1;
	_tmp23_ = music_application_loop_through_files (_tmp21_, (gint) _tmp21__length1, &_tmp22_);
	files_to_play = _tmp23_;
	files_to_play_length1 = _tmp22_;
	_files_to_play_size_ = files_to_play_length1;
	_tmp24_ = files_to_play;
	_tmp24__length1 = files_to_play_length1;
	music_playback_manager_queue_files (self, _tmp24_, (gint) _tmp24__length1);
	_tmp26_ = uri_last_played;
	if (g_strcmp0 (_tmp26_, "") != 0) {
		GFile* _tmp27_;
		_tmp27_ = file_last_played;
		_tmp25_ = g_file_query_exists (_tmp27_, NULL);
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		MusicAudioObject* audio_object = NULL;
		const gchar* _tmp28_;
		MusicAudioObject* _tmp29_;
		guint position = 0U;
		GListStore* _tmp30_;
		MusicAudioObject* _tmp31_;
		guint _tmp32_ = 0U;
		gboolean _tmp33_;
		GListStore* _tmp34_;
		GObject* _tmp35_;
		MusicAudioObject* _tmp36_;
		_tmp28_ = uri_last_played;
		_tmp29_ = music_audio_object_new (_tmp28_);
		audio_object = _tmp29_;
		position = (guint) -1;
		_tmp30_ = self->priv->_queue_liststore;
		_tmp31_ = audio_object;
		_tmp33_ = g_list_store_find_with_equal_func (_tmp30_, (GObject*) _tmp31_, (GEqualFunc) music_audio_object_equal_func, &_tmp32_);
		position = _tmp32_;
		if (!_tmp33_) {
			_g_object_unref0 (audio_object);
			files_to_play = (_vala_array_free (files_to_play, files_to_play_length1, (GDestroyNotify) g_object_unref), NULL);
			last_session_files = (_vala_array_free (last_session_files, last_session_files_length1, (GDestroyNotify) g_object_unref), NULL);
			last_session_uri = (_vala_array_free (last_session_uri, last_session_uri_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (file_last_played);
			_g_free0 (uri_last_played);
			return;
		}
		_tmp34_ = self->priv->_queue_liststore;
		_tmp35_ = g_list_model_get_item ((GListModel*) _tmp34_, position);
		_tmp36_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, MUSIC_TYPE_AUDIO_OBJECT, MusicAudioObject);
		music_playback_manager_set_current_audio (self, _tmp36_);
		_g_object_unref0 (_tmp36_);
		_g_object_unref0 (audio_object);
	}
	files_to_play = (_vala_array_free (files_to_play, files_to_play_length1, (GDestroyNotify) g_object_unref), NULL);
	last_session_files = (_vala_array_free (last_session_files, last_session_files_length1, (GDestroyNotify) g_object_unref), NULL);
	last_session_uri = (_vala_array_free (last_session_uri, last_session_uri_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (file_last_played);
	_g_free0 (uri_last_played);
}

MusicAudioObject*
music_playback_manager_get_current_audio (MusicPlaybackManager* self)
{
	MusicAudioObject* result;
	MusicAudioObject* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_current_audio;
	result = _tmp0_;
	return result;
}

void
music_playback_manager_set_current_audio (MusicPlaybackManager* self,
                                          MusicAudioObject* value)
{
	MusicAudioObject* old_value;
	g_return_if_fail (self != NULL);
	old_value = music_playback_manager_get_current_audio (self);
	if (old_value != value) {
		MusicAudioObject* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_current_audio);
		self->priv->_current_audio = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY]);
	}
}

GListStore*
music_playback_manager_get_queue_liststore (MusicPlaybackManager* self)
{
	GListStore* result;
	GListStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_queue_liststore;
	result = _tmp0_;
	return result;
}

static void
music_playback_manager_set_queue_liststore (MusicPlaybackManager* self,
                                            GListStore* value)
{
	GListStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = music_playback_manager_get_queue_liststore (self);
	if (old_value != value) {
		GListStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_queue_liststore);
		self->priv->_queue_liststore = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY]);
	}
}

gboolean
music_playback_manager_get_has_items (MusicPlaybackManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_items;
	return result;
}

static void
music_playback_manager_set_has_items (MusicPlaybackManager* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = music_playback_manager_get_has_items (self);
	if (old_value != value) {
		self->priv->_has_items = value;
		g_object_notify_by_pspec ((GObject *) self, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_HAS_ITEMS_PROPERTY]);
	}
}

guint
music_playback_manager_get_n_items (MusicPlaybackManager* self)
{
	guint result;
	guint _tmp0_ = 0U;
	GListStore* _tmp1_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = self->priv->_queue_liststore;
	if (_tmp1_ != NULL) {
		GListStore* _tmp2_;
		_tmp2_ = self->priv->_queue_liststore;
		_tmp0_ = g_list_model_get_n_items ((GListModel*) _tmp2_);
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

gint64
music_playback_manager_get_playback_position (MusicPlaybackManager* self)
{
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	result = self->priv->_playback_position;
	return result;
}

static void
music_playback_manager_set_playback_position (MusicPlaybackManager* self,
                                              gint64 value)
{
	gint64 old_value;
	g_return_if_fail (self != NULL);
	old_value = music_playback_manager_get_playback_position (self);
	if (old_value != value) {
		self->priv->_playback_position = value;
		g_object_notify_by_pspec ((GObject *) self, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY]);
	}
}

static gboolean
_music_playback_manager_bus_callback_gst_bus_func (GstBus* bus,
                                                   GstMessage* message,
                                                   gpointer self)
{
	gboolean result;
	result = music_playback_manager_bus_callback ((MusicPlaybackManager*) self, bus, message);
	return result;
}

static void
_music_playback_manager_update_metadata_gst_discoverer_discovered (GstDiscoverer* _sender,
                                                                   GstDiscovererInfo* info,
                                                                   GError* err,
                                                                   gpointer self)
{
	music_playback_manager_update_metadata ((MusicPlaybackManager*) self, info, err);
}

static void
_gst_discoverer_stop_gst_discoverer_finished (GstDiscoverer* _sender,
                                              gpointer self)
{
	gst_discoverer_stop ((GstDiscoverer*) self);
}

static void
_music_playback_manager_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                     guint position,
                                                                     guint removed,
                                                                     guint added,
                                                                     gpointer self)
{
	music_playback_manager_on_items_changed ((MusicPlaybackManager*) self);
}

static void
_music_playback_manager_on_audio_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self)
{
	music_playback_manager_on_audio_changed ((MusicPlaybackManager*) self);
}

static void
_music_playback_manager_clear_queue_g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	music_playback_manager_clear_queue ((MusicPlaybackManager*) self);
}

static void
_music_playback_manager___lambda8_ (MusicPlaybackManager* self)
{
	music_playback_manager_next (self, FALSE);
}

static void
__music_playback_manager___lambda8__g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	_music_playback_manager___lambda8_ ((MusicPlaybackManager*) self);
}

static void
_music_playback_manager_play_pause_g_simple_action_change_state (GSimpleAction* _sender,
                                                                 GVariant* value,
                                                                 gpointer self)
{
	music_playback_manager_play_pause ((MusicPlaybackManager*) self, _sender, value);
}

static void
_music_playback_manager_previous_g_simple_action_activate (GSimpleAction* _sender,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	music_playback_manager_previous ((MusicPlaybackManager*) self);
}

static void
_music_playback_manager_shuffle_g_simple_action_activate (GSimpleAction* _sender,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	music_playback_manager_shuffle ((MusicPlaybackManager*) self);
}

static GObject *
music_playback_manager_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MusicPlaybackManager * self;
	GSettings* _tmp0_;
	GListStore* _tmp1_;
	GListStore* _tmp2_;
	GstElement* _tmp3_;
	GstBus* bus = NULL;
	GstElement* _tmp4_;
	GstBus* _tmp5_;
	GstBus* _tmp6_;
	GstBus* _tmp7_;
	GListStore* _tmp16_;
	GSettings* _tmp17_;
	GSimpleAction* clear_action = NULL;
	GSimpleAction* _tmp18_;
	GSimpleAction* _tmp19_;
	GSimpleAction* _tmp20_;
	GSimpleAction* _tmp21_;
	GVariant* _tmp22_;
	GVariant* _tmp23_;
	GSimpleAction* _tmp24_;
	GSimpleAction* _tmp25_;
	GSimpleAction* _tmp26_;
	GSimpleAction* _tmp27_;
	GSimpleAction* _tmp28_;
	GSimpleAction* _tmp29_;
	GSimpleAction* _tmp30_;
	GSimpleAction* _tmp31_;
	GSimpleAction* _tmp32_;
	GSimpleAction* _tmp33_;
	GApplication* app = NULL;
	GApplication* _tmp34_;
	GApplication* _tmp35_;
	GSimpleAction* _tmp36_;
	GApplication* _tmp37_;
	GSimpleAction* _tmp38_;
	GApplication* _tmp39_;
	GSimpleAction* _tmp40_;
	GApplication* _tmp41_;
	GSimpleAction* _tmp42_;
	GApplication* _tmp43_;
	GSimpleAction* _tmp44_;
	GSimpleAction* _tmp45_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (music_playback_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	_tmp0_ = g_settings_new ("io.elementary.music");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = g_list_store_new (MUSIC_TYPE_AUDIO_OBJECT);
	_tmp2_ = _tmp1_;
	music_playback_manager_set_queue_liststore (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = gst_element_factory_make ("playbin", "playbin");
	if (_tmp3_ != NULL) {
		g_object_ref_sink (_tmp3_);
	}
	_g_object_unref0 (self->priv->playbin);
	self->priv->playbin = _tmp3_;
	_tmp4_ = self->priv->playbin;
	_tmp5_ = gst_element_get_bus (_tmp4_);
	bus = _tmp5_;
	_tmp6_ = bus;
	gst_bus_add_watch_full (_tmp6_, 0, _music_playback_manager_bus_callback_gst_bus_func, g_object_ref (self), g_object_unref);
	_tmp7_ = bus;
	gst_bus_enable_sync_message_emission (_tmp7_);
	{
		GstDiscoverer* _tmp8_ = NULL;
		GstDiscoverer* _tmp9_;
		GstDiscoverer* _tmp10_;
		GstDiscoverer* _tmp11_;
		GstDiscoverer* _tmp12_;
		GstDiscoverer* _tmp13_;
		_tmp9_ = gst_discoverer_new ((GstClockTime) (5 * GST_SECOND), &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (self->priv->discoverer);
		self->priv->discoverer = _tmp10_;
		_tmp11_ = self->priv->discoverer;
		g_signal_connect_object (_tmp11_, "discovered", (GCallback) _music_playback_manager_update_metadata_gst_discoverer_discovered, self, 0);
		_tmp12_ = self->priv->discoverer;
		_tmp13_ = self->priv->discoverer;
		g_signal_connect_object (_tmp12_, "finished", (GCallback) _gst_discoverer_stop_gst_discoverer_finished, _tmp13_, 0);
		_g_object_unref0 (_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_critical ("PlaybackManager.vala:60: Unable to start Gstreamer Discoverer: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp16_ = self->priv->_queue_liststore;
	g_signal_connect_object ((GListModel*) _tmp16_, "items-changed", (GCallback) _music_playback_manager_on_items_changed_g_list_model_items_changed, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::current-audio", (GCallback) _music_playback_manager_on_audio_changed_g_object_notify, self, 0);
	_tmp17_ = g_settings_new ("io.elementary.music");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp17_;
	_tmp18_ = g_simple_action_new (MUSIC_APPLICATION_ACTION_CLEAR_QUEUE, NULL);
	clear_action = _tmp18_;
	_tmp19_ = clear_action;
	g_signal_connect_object (_tmp19_, "activate", (GCallback) _music_playback_manager_clear_queue_g_simple_action_activate, self, 0);
	_tmp20_ = g_simple_action_new (MUSIC_APPLICATION_ACTION_NEXT, NULL);
	_g_object_unref0 (self->priv->next_action);
	self->priv->next_action = _tmp20_;
	_tmp21_ = self->priv->next_action;
	g_signal_connect_object (_tmp21_, "activate", (GCallback) __music_playback_manager___lambda8__g_simple_action_activate, self, 0);
	_tmp22_ = g_variant_new_boolean (FALSE);
	g_variant_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_simple_action_new_stateful (MUSIC_APPLICATION_ACTION_PLAY_PAUSE, NULL, _tmp23_);
	_g_object_unref0 (self->priv->play_pause_action);
	self->priv->play_pause_action = _tmp24_;
	_g_variant_unref0 (_tmp23_);
	_tmp25_ = self->priv->play_pause_action;
	g_signal_connect_object (_tmp25_, "change-state", (GCallback) _music_playback_manager_play_pause_g_simple_action_change_state, self, 0);
	_tmp26_ = g_simple_action_new (MUSIC_APPLICATION_ACTION_PREVIOUS, NULL);
	_g_object_unref0 (self->priv->previous_action);
	self->priv->previous_action = _tmp26_;
	_tmp27_ = self->priv->previous_action;
	g_signal_connect_object (_tmp27_, "activate", (GCallback) _music_playback_manager_previous_g_simple_action_activate, self, 0);
	_tmp28_ = g_simple_action_new (MUSIC_APPLICATION_ACTION_SHUFFLE, NULL);
	_g_object_unref0 (self->priv->shuffle_action);
	self->priv->shuffle_action = _tmp28_;
	_tmp29_ = self->priv->shuffle_action;
	g_signal_connect_object (_tmp29_, "activate", (GCallback) _music_playback_manager_shuffle_g_simple_action_activate, self, 0);
	_tmp30_ = self->priv->next_action;
	g_simple_action_set_enabled (_tmp30_, FALSE);
	_tmp31_ = self->priv->play_pause_action;
	g_simple_action_set_enabled (_tmp31_, FALSE);
	_tmp32_ = self->priv->previous_action;
	g_simple_action_set_enabled (_tmp32_, FALSE);
	_tmp33_ = self->priv->shuffle_action;
	g_simple_action_set_enabled (_tmp33_, FALSE);
	_tmp34_ = g_application_get_default ();
	app = _tmp34_;
	_tmp35_ = app;
	_tmp36_ = clear_action;
	g_action_map_add_action ((GActionMap*) _tmp35_, (GAction*) _tmp36_);
	_tmp37_ = app;
	_tmp38_ = self->priv->next_action;
	g_action_map_add_action ((GActionMap*) _tmp37_, (GAction*) _tmp38_);
	_tmp39_ = app;
	_tmp40_ = self->priv->play_pause_action;
	g_action_map_add_action ((GActionMap*) _tmp39_, (GAction*) _tmp40_);
	_tmp41_ = app;
	_tmp42_ = self->priv->previous_action;
	g_action_map_add_action ((GActionMap*) _tmp41_, (GAction*) _tmp42_);
	_tmp43_ = app;
	_tmp44_ = self->priv->shuffle_action;
	g_action_map_add_action ((GActionMap*) _tmp43_, (GAction*) _tmp44_);
	_tmp45_ = clear_action;
	g_object_bind_property_with_closures ((GObject*) self, "has-items", (GObject*) _tmp45_, "enabled", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (clear_action);
	_g_object_unref0 (bus);
	return obj;
}

static void
music_playback_manager_class_init (MusicPlaybackManagerClass * klass,
                                   gpointer klass_data)
{
	music_playback_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MusicPlaybackManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_music_playback_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_music_playback_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = music_playback_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_playback_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY] = g_param_spec_object ("current-audio", "current-audio", "current-audio", MUSIC_TYPE_AUDIO_OBJECT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY] = g_param_spec_object ("queue-liststore", "queue-liststore", "queue-liststore", g_list_store_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_HAS_ITEMS_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_HAS_ITEMS_PROPERTY] = g_param_spec_boolean ("has-items", "has-items", "has-items", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_N_ITEMS_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_N_ITEMS_PROPERTY] = g_param_spec_uint ("n-items", "n-items", "n-items", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY, music_playback_manager_properties[MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY] = g_param_spec_int64 ("playback-position", "playback-position", "playback-position", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	music_playback_manager_signals[MUSIC_PLAYBACK_MANAGER_INVALIDS_FOUND_SIGNAL] = g_signal_new ("invalids-found", MUSIC_TYPE_PLAYBACK_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}

static void
music_playback_manager_instance_init (MusicPlaybackManager * self,
                                      gpointer klass)
{
	self->priv = music_playback_manager_get_instance_private (self);
	self->priv->_current_audio = NULL;
	self->priv->progress_timer = (guint) 0;
	self->priv->next_by_eos = FALSE;
	self->priv->direction = MUSIC_PLAYBACK_MANAGER_DIRECTION_NONE;
}

static void
music_playback_manager_finalize (GObject * obj)
{
	MusicPlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	_g_object_unref0 (self->priv->_current_audio);
	_g_object_unref0 (self->priv->_queue_liststore);
	_g_object_unref0 (self->priv->playbin);
	_g_object_unref0 (self->priv->discoverer);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->next_action);
	_g_object_unref0 (self->priv->play_pause_action);
	_g_object_unref0 (self->priv->previous_action);
	_g_object_unref0 (self->priv->shuffle_action);
	G_OBJECT_CLASS (music_playback_manager_parent_class)->finalize (obj);
}

static GType
music_playback_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MusicPlaybackManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_playback_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicPlaybackManager), 0, (GInstanceInitFunc) music_playback_manager_instance_init, NULL };
	GType music_playback_manager_type_id;
	music_playback_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "MusicPlaybackManager", &g_define_type_info, 0);
	MusicPlaybackManager_private_offset = g_type_add_instance_private (music_playback_manager_type_id, sizeof (MusicPlaybackManagerPrivate));
	return music_playback_manager_type_id;
}

GType
music_playback_manager_get_type (void)
{
	static volatile gsize music_playback_manager_type_id__once = 0;
	if (g_once_init_enter (&music_playback_manager_type_id__once)) {
		GType music_playback_manager_type_id;
		music_playback_manager_type_id = music_playback_manager_get_type_once ();
		g_once_init_leave (&music_playback_manager_type_id__once, music_playback_manager_type_id);
	}
	return music_playback_manager_type_id__once;
}

static void
_vala_music_playback_manager_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	MusicPlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	switch (property_id) {
		case MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY:
		g_value_set_object (value, music_playback_manager_get_current_audio (self));
		break;
		case MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY:
		g_value_set_object (value, music_playback_manager_get_queue_liststore (self));
		break;
		case MUSIC_PLAYBACK_MANAGER_HAS_ITEMS_PROPERTY:
		g_value_set_boolean (value, music_playback_manager_get_has_items (self));
		break;
		case MUSIC_PLAYBACK_MANAGER_N_ITEMS_PROPERTY:
		g_value_set_uint (value, music_playback_manager_get_n_items (self));
		break;
		case MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY:
		g_value_set_int64 (value, music_playback_manager_get_playback_position (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_music_playback_manager_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	MusicPlaybackManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager);
	switch (property_id) {
		case MUSIC_PLAYBACK_MANAGER_CURRENT_AUDIO_PROPERTY:
		music_playback_manager_set_current_audio (self, g_value_get_object (value));
		break;
		case MUSIC_PLAYBACK_MANAGER_QUEUE_LISTSTORE_PROPERTY:
		music_playback_manager_set_queue_liststore (self, g_value_get_object (value));
		break;
		case MUSIC_PLAYBACK_MANAGER_HAS_ITEMS_PROPERTY:
		music_playback_manager_set_has_items (self, g_value_get_boolean (value));
		break;
		case MUSIC_PLAYBACK_MANAGER_PLAYBACK_POSITION_PROPERTY:
		music_playback_manager_set_playback_position (self, g_value_get_int64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

