{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Associates a string with a bit flag.
-- Used in 'GI.GLib.Functions.parseDebugString'.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GLib.Structs.DebugKey
    ( 

-- * Exported types
    DebugKey(..)                            ,
    newZeroDebugKey                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveDebugKeyMethod                   ,
#endif



 -- * Properties


-- ** key #attr:key#
-- | the string

    clearDebugKeyKey                        ,
#if defined(ENABLE_OVERLOADING)
    debugKey_key                            ,
#endif
    getDebugKeyKey                          ,
    setDebugKeyKey                          ,


-- ** value #attr:value#
-- | the flag

#if defined(ENABLE_OVERLOADING)
    debugKey_value                          ,
#endif
    getDebugKeyValue                        ,
    setDebugKeyValue                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype DebugKey = DebugKey (SP.ManagedPtr DebugKey)
    deriving (Eq)

instance SP.ManagedPtrNewtype DebugKey where
    toManagedPtr (DebugKey p) = p

instance BoxedPtr DebugKey where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 16 >=> B.ManagedPtr.wrapPtr DebugKey)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr DebugKey where
    boxedPtrCalloc = callocBytes 16


-- | Construct a t'DebugKey' struct initialized to zero.
newZeroDebugKey :: MonadIO m => m DebugKey
newZeroDebugKey = liftIO $ boxedPtrCalloc >>= wrapPtr DebugKey

instance tag ~ 'AttrSet => Constructible DebugKey tag where
    new _ attrs = do
        o <- newZeroDebugKey
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@key@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' debugKey #key
-- @
getDebugKeyKey :: MonadIO m => DebugKey -> m (Maybe T.Text)
getDebugKeyKey s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CString
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- cstringToText val'
        return val''
    return result

-- | Set the value of the “@key@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' debugKey [ #key 'Data.GI.Base.Attributes.:=' value ]
-- @
setDebugKeyKey :: MonadIO m => DebugKey -> CString -> m ()
setDebugKeyKey s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: CString)

-- | Set the value of the “@key@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #key
-- @
clearDebugKeyKey :: MonadIO m => DebugKey -> m ()
clearDebugKeyKey s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (FP.nullPtr :: CString)

#if defined(ENABLE_OVERLOADING)
data DebugKeyKeyFieldInfo
instance AttrInfo DebugKeyKeyFieldInfo where
    type AttrBaseTypeConstraint DebugKeyKeyFieldInfo = (~) DebugKey
    type AttrAllowedOps DebugKeyKeyFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint DebugKeyKeyFieldInfo = (~) CString
    type AttrTransferTypeConstraint DebugKeyKeyFieldInfo = (~)CString
    type AttrTransferType DebugKeyKeyFieldInfo = CString
    type AttrGetType DebugKeyKeyFieldInfo = Maybe T.Text
    type AttrLabel DebugKeyKeyFieldInfo = "key"
    type AttrOrigin DebugKeyKeyFieldInfo = DebugKey
    attrGet = getDebugKeyKey
    attrSet = setDebugKeyKey
    attrConstruct = undefined
    attrClear = clearDebugKeyKey
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.DebugKey.key"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-DebugKey.html#g:attr:key"
        })

debugKey_key :: AttrLabelProxy "key"
debugKey_key = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' debugKey #value
-- @
getDebugKeyValue :: MonadIO m => DebugKey -> m Word32
getDebugKeyValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' debugKey [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setDebugKeyValue :: MonadIO m => DebugKey -> Word32 -> m ()
setDebugKeyValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data DebugKeyValueFieldInfo
instance AttrInfo DebugKeyValueFieldInfo where
    type AttrBaseTypeConstraint DebugKeyValueFieldInfo = (~) DebugKey
    type AttrAllowedOps DebugKeyValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint DebugKeyValueFieldInfo = (~) Word32
    type AttrTransferTypeConstraint DebugKeyValueFieldInfo = (~)Word32
    type AttrTransferType DebugKeyValueFieldInfo = Word32
    type AttrGetType DebugKeyValueFieldInfo = Word32
    type AttrLabel DebugKeyValueFieldInfo = "value"
    type AttrOrigin DebugKeyValueFieldInfo = DebugKey
    attrGet = getDebugKeyValue
    attrSet = setDebugKeyValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.GLib.Structs.DebugKey.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-glib-2.0.30/docs/GI-GLib-Structs-DebugKey.html#g:attr:value"
        })

debugKey_value :: AttrLabelProxy "value"
debugKey_value = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DebugKey
type instance O.AttributeList DebugKey = DebugKeyAttributeList
type DebugKeyAttributeList = ('[ '("key", DebugKeyKeyFieldInfo), '("value", DebugKeyValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveDebugKeyMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDebugKeyMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDebugKeyMethod t DebugKey, O.OverloadedMethod info DebugKey p) => OL.IsLabel t (DebugKey -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDebugKeyMethod t DebugKey, O.OverloadedMethod info DebugKey p, R.HasField t DebugKey p) => R.HasField t DebugKey p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDebugKeyMethod t DebugKey, O.OverloadedMethodInfo info DebugKey) => OL.IsLabel t (O.MethodProxy info DebugKey) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


