/* memory-row.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from memory-row.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <handy.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <osinfo/osinfo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_MEMORY_ROW (boxes_memory_row_get_type ())
#define BOXES_MEMORY_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MEMORY_ROW, BoxesMemoryRow))
#define BOXES_MEMORY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MEMORY_ROW, BoxesMemoryRowClass))
#define BOXES_IS_MEMORY_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MEMORY_ROW))
#define BOXES_IS_MEMORY_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MEMORY_ROW))
#define BOXES_MEMORY_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MEMORY_ROW, BoxesMemoryRowClass))

typedef struct _BoxesMemoryRow BoxesMemoryRow;
typedef struct _BoxesMemoryRowClass BoxesMemoryRowClass;
typedef struct _BoxesMemoryRowPrivate BoxesMemoryRowPrivate;
enum  {
	BOXES_MEMORY_ROW_0_PROPERTY,
	BOXES_MEMORY_ROW_MEMORY_PROPERTY,
	BOXES_MEMORY_ROW_NUM_PROPERTIES
};
static GParamSpec* boxes_memory_row_properties[BOXES_MEMORY_ROW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BoxesMemoryRow {
	HdyActionRow parent_instance;
	BoxesMemoryRowPrivate * priv;
	GtkStack* stack;
	GtkLabel* used_label;
	GtkSpinButton* spin_button;
};

struct _BoxesMemoryRowClass {
	HdyActionRowClass parent_class;
};

static gpointer boxes_memory_row_parent_class = NULL;

VALA_EXTERN GType boxes_memory_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMemoryRow, g_object_unref)
static gint boxes_memory_row_on_spin_button_input (BoxesMemoryRow* self,
                                            GtkSpinButton* spin_button,
                                            gdouble* new_value);
static gint64 boxes_memory_row_parse_iec_unit (BoxesMemoryRow* self,
                                        const gchar* text);
static gint _boxes_memory_row_on_spin_button_input_gtk_spin_button_input (GtkSpinButton* _sender,
                                                                   gdouble* new_value,
                                                                   gpointer self);
static gboolean boxes_memory_row_on_spin_button_output (BoxesMemoryRow* self,
                                                 GtkSpinButton* spin_button);
static gboolean _boxes_memory_row_on_spin_button_output_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                         gpointer self);
VALA_EXTERN BoxesMemoryRow* boxes_memory_row_new (void);
VALA_EXTERN BoxesMemoryRow* boxes_memory_row_construct (GType object_type);
VALA_EXTERN guint64 boxes_memory_row_get_memory (BoxesMemoryRow* self);
VALA_EXTERN void boxes_memory_row_set_memory (BoxesMemoryRow* self,
                                  guint64 value);
static GObject * boxes_memory_row_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static void _boxes_memory_row___lambda38_ (BoxesMemoryRow* self);
static void __boxes_memory_row___lambda38__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                                   gpointer self);
static void boxes_memory_row_finalize (GObject * obj);
static GType boxes_memory_row_get_type_once (void);
static void _vala_boxes_memory_row_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_boxes_memory_row_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gint
boxes_memory_row_on_spin_button_input (BoxesMemoryRow* self,
                                       GtkSpinButton* spin_button,
                                       gdouble* new_value)
{
	gdouble _vala_new_value = 0.0;
	guint64 current_value = 0ULL;
	gchar* text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gdouble user_input_value = 0.0;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gdouble _tmp6_;
	gint64 iec_unit = 0LL;
	const gchar* _tmp7_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (spin_button != NULL, 0);
	current_value = (guint64) gtk_spin_button_get_value (spin_button);
	_vala_new_value = (gdouble) current_value;
	_tmp0_ = gtk_entry_get_text ((GtkEntry*) spin_button);
	_tmp1_ = g_strdup (_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	if (_tmp2_ == NULL) {
		result = 1;
		_g_free0 (text);
		if (new_value) {
			*new_value = _vala_new_value;
		}
		return result;
	}
	_tmp3_ = text;
	_tmp4_ = string_replace (_tmp3_, ",", ".");
	_tmp5_ = _tmp4_;
	_tmp6_ = double_parse (_tmp5_);
	_g_free0 (_tmp5_);
	user_input_value = _tmp6_;
	if (user_input_value == ((gdouble) 0)) {
		result = 1;
		_g_free0 (text);
		if (new_value) {
			*new_value = _vala_new_value;
		}
		return result;
	}
	_tmp7_ = text;
	iec_unit = boxes_memory_row_parse_iec_unit (self, _tmp7_);
	_vala_new_value = user_input_value * iec_unit;
	result = 1;
	_g_free0 (text);
	if (new_value) {
		*new_value = _vala_new_value;
	}
	return result;
}

static gint
_boxes_memory_row_on_spin_button_input_gtk_spin_button_input (GtkSpinButton* _sender,
                                                              gdouble* new_value,
                                                              gpointer self)
{
	gint result;
	result = boxes_memory_row_on_spin_button_input ((BoxesMemoryRow*) self, _sender, new_value);
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint64
boxes_memory_row_parse_iec_unit (BoxesMemoryRow* self,
                                 const gchar* text)
{
	gint64 iec_unit = 0LL;
	gint64 result;
	g_return_val_if_fail (self != NULL, 0LL);
	iec_unit = (gint64) OSINFO_GIBIBYTES;
	if (string_contains (text, "MiB")) {
		iec_unit = (gint64) OSINFO_MEBIBYTES;
	} else {
		if (string_contains (text, "KiB")) {
			iec_unit = (gint64) OSINFO_KIBIBYTES;
		}
	}
	result = iec_unit;
	return result;
}

static gboolean
boxes_memory_row_on_spin_button_output (BoxesMemoryRow* self,
                                        GtkSpinButton* spin_button)
{
	guint64 current_value = 0ULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (spin_button != NULL, FALSE);
	current_value = (guint64) gtk_spin_button_get_value (spin_button);
	_tmp0_ = g_format_size_full (current_value, G_FORMAT_SIZE_IEC_UNITS);
	_tmp1_ = _tmp0_;
	gtk_entry_set_text ((GtkEntry*) spin_button, _tmp1_);
	_g_free0 (_tmp1_);
	result = TRUE;
	return result;
}

static gboolean
_boxes_memory_row_on_spin_button_output_gtk_spin_button_output (GtkSpinButton* _sender,
                                                                gpointer self)
{
	gboolean result;
	result = boxes_memory_row_on_spin_button_output ((BoxesMemoryRow*) self, _sender);
	return result;
}

BoxesMemoryRow*
boxes_memory_row_construct (GType object_type)
{
	BoxesMemoryRow * self = NULL;
	self = (BoxesMemoryRow*) g_object_new (object_type, NULL);
	return self;
}

BoxesMemoryRow*
boxes_memory_row_new (void)
{
	return boxes_memory_row_construct (BOXES_TYPE_MEMORY_ROW);
}

guint64
boxes_memory_row_get_memory (BoxesMemoryRow* self)
{
	guint64 result;
	GtkSpinButton* _tmp0_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = self->spin_button;
	result = ((guint64) gtk_spin_button_get_value (_tmp0_)) / OSINFO_KIBIBYTES;
	return result;
}

void
boxes_memory_row_set_memory (BoxesMemoryRow* self,
                             guint64 value)
{
	GtkSpinButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->spin_button;
	gtk_spin_button_set_value (_tmp0_, (gdouble) (value * OSINFO_KIBIBYTES));
	g_object_notify_by_pspec ((GObject *) self, boxes_memory_row_properties[BOXES_MEMORY_ROW_MEMORY_PROPERTY]);
}

static void
_boxes_memory_row___lambda38_ (BoxesMemoryRow* self)
{
	g_object_notify ((GObject*) self, "memory");
}

static void
__boxes_memory_row___lambda38__gtk_spin_button_value_changed (GtkSpinButton* _sender,
                                                              gpointer self)
{
	_boxes_memory_row___lambda38_ ((BoxesMemoryRow*) self);
}

static GObject *
boxes_memory_row_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesMemoryRow * self;
	GtkSpinButton* _tmp0_;
	parent_class = G_OBJECT_CLASS (boxes_memory_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_MEMORY_ROW, BoxesMemoryRow);
	_tmp0_ = self->spin_button;
	g_signal_connect_object (_tmp0_, "value-changed", (GCallback) __boxes_memory_row___lambda38__gtk_spin_button_value_changed, self, 0);
	return obj;
}

static void
boxes_memory_row_class_init (BoxesMemoryRowClass * klass,
                             gpointer klass_data)
{
	boxes_memory_row_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_memory_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_memory_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = boxes_memory_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_memory_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MEMORY_ROW_MEMORY_PROPERTY, boxes_memory_row_properties[BOXES_MEMORY_ROW_MEMORY_PROPERTY] = g_param_spec_uint64 ("memory", "memory", "memory", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Boxes/ui/preferences/memory-row.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, G_STRUCT_OFFSET (BoxesMemoryRow, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "used_label", FALSE, G_STRUCT_OFFSET (BoxesMemoryRow, used_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "spin_button", FALSE, G_STRUCT_OFFSET (BoxesMemoryRow, spin_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_spin_button_input", G_CALLBACK(_boxes_memory_row_on_spin_button_input_gtk_spin_button_input));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_spin_button_output", G_CALLBACK(_boxes_memory_row_on_spin_button_output_gtk_spin_button_output));
}

static void
boxes_memory_row_instance_init (BoxesMemoryRow * self,
                                gpointer klass)
{
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
boxes_memory_row_finalize (GObject * obj)
{
	BoxesMemoryRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_MEMORY_ROW, BoxesMemoryRow);
	G_OBJECT_CLASS (boxes_memory_row_parent_class)->finalize (obj);
}

static GType
boxes_memory_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesMemoryRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_memory_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesMemoryRow), 0, (GInstanceInitFunc) boxes_memory_row_instance_init, NULL };
	GType boxes_memory_row_type_id;
	boxes_memory_row_type_id = g_type_register_static (hdy_action_row_get_type (), "BoxesMemoryRow", &g_define_type_info, 0);
	return boxes_memory_row_type_id;
}

GType
boxes_memory_row_get_type (void)
{
	static volatile gsize boxes_memory_row_type_id__once = 0;
	if (g_once_init_enter (&boxes_memory_row_type_id__once)) {
		GType boxes_memory_row_type_id;
		boxes_memory_row_type_id = boxes_memory_row_get_type_once ();
		g_once_init_leave (&boxes_memory_row_type_id__once, boxes_memory_row_type_id);
	}
	return boxes_memory_row_type_id__once;
}

static void
_vala_boxes_memory_row_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	BoxesMemoryRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_MEMORY_ROW, BoxesMemoryRow);
	switch (property_id) {
		case BOXES_MEMORY_ROW_MEMORY_PROPERTY:
		g_value_set_uint64 (value, boxes_memory_row_get_memory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_memory_row_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	BoxesMemoryRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_MEMORY_ROW, BoxesMemoryRow);
	switch (property_id) {
		case BOXES_MEMORY_ROW_MEMORY_PROPERTY:
		boxes_memory_row_set_memory (self, g_value_get_uint64 (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

