/* do not edit automatically generated by mc from m2convert.  */
/* m2convert.def definition module for m2convert.cc.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_m2convert_H)
#   define _m2convert_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "Ggcctypes.h"

#   if defined (_m2convert_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   ToWord - converts an expression (Integer or Ordinal type) into
            a WORD.
*/

EXTERN tree m2convert_ToWord (location_t location, tree expr);

/*
   ToCardinal - convert an expression, expr, to a CARDINAL.
*/

EXTERN tree m2convert_ToCardinal (location_t location, tree expr);

/*
   ToInteger - convert an expression, expr, to an INTEGER.
*/

EXTERN tree m2convert_ToInteger (location_t location, tree expr);

/*
   ToBitset - convert an expression, expr, to a BITSET.
*/

EXTERN tree m2convert_ToBitset (location_t location, tree expr);

/*
   ConvertToPtr - convert an expression to a void *.
*/

EXTERN tree m2convert_ConvertToPtr (tree p);

/*
    BuildConvert - build and return tree VAL(type, value)
                   checkOverflow determines whether we
                   should suppress overflow checking.
*/

EXTERN tree m2convert_BuildConvert (location_t location, tree type, tree value, bool checkOverflow);

/*
   ConvertConstantAndCheck - in Modula-2 sementics: return( VAL(type, expr) )
                             Only to be used for a constant expr,
                             overflow checking is performed.
*/

EXTERN tree m2convert_ConvertConstantAndCheck (location_t location, tree type, tree expr);

/*
   ConvertString - converts string, expr, into a string of type, type.
*/

EXTERN tree m2convert_ConvertString (tree type, tree expr);

/*
   GenericToType - converts, expr, into, type, providing that expr is
                   a generic system type (byte, word etc).  Otherwise
                   expr is returned unaltered.
*/

EXTERN tree m2convert_GenericToType (location_t location, tree type, tree expr);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
