
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in FacetPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Mesh;

/// Type structure of FacetPy
PyTypeObject FacetPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Mesh.Facet",     /*tp_name*/
    sizeof(FacetPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "Facet in mesh\n"
    "This is a facet in a MeshObject. You can get it by e.g. iterating a\n"
    "mesh. The facet has a connection to its mesh and allows therefore\n"
    "topological operations. It is also possible to create an unbounded facet e.g. to create\n"
    "a mesh. In this case the topological operations will fail. The same is\n"
    "when you cut the bound to the mesh by calling unbound().",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Mesh::FacetPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Mesh::FacetPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Mesh::FacetPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of FacetPy
PyMethodDef FacetPy::Methods[] = {
    {"unbound",
        reinterpret_cast<PyCFunction>( staticCallback_unbound ),
        METH_VARARGS,
        "method unbound()\n"
        "Cut the connection to a MeshObject. The facet becomes\n"
        "free and is more or less a simple facet.\n"
        "After calling unbound() no topological operation will\n"
        "work!"
    },
    {"intersect",
        reinterpret_cast<PyCFunction>( staticCallback_intersect ),
        METH_VARARGS,
        "intersect(Facet) -> list\n"
        "Get a list of intersection points with another triangle."
    },
    {"isDegenerated",
        reinterpret_cast<PyCFunction>( staticCallback_isDegenerated ),
        METH_VARARGS,
        "isDegenerated([float]) -> boolean\n"
        "Returns true if the facet is degenerated, otherwise false."
    },
    {"isDeformed",
        reinterpret_cast<PyCFunction>( staticCallback_isDeformed ),
        METH_VARARGS,
        "isDegenerated(MinAngle, MaxAngle) -> boolean\n"
        "Returns true if the facet is deformed, otherwise false.\n"
        "A triangle is considered deformed if an angle is less than MinAngle\n"
        "or higher than MaxAngle.\n"
        "The two angles are given in radian."
    },
    {"getEdge",
        reinterpret_cast<PyCFunction>( staticCallback_getEdge ),
        METH_VARARGS,
        "getEdge(int) -> Edge\n"
        "Returns the edge of the facet."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of FacetPy
PyGetSetDef FacetPy::GetterSetter[] = {
    {"Index",
        (getter) staticCallback_getIndex,
        (setter) staticCallback_setIndex,
        "The index of this facet in the MeshObject",
        nullptr
    },
    {"Bound",
        (getter) staticCallback_getBound,
        (setter) staticCallback_setBound,
        "Bound state of the facet",
        nullptr
    },
    {"Normal",
        (getter) staticCallback_getNormal,
        (setter) staticCallback_setNormal,
        "Normal vector of the facet.",
        nullptr
    },
    {"Points",
        (getter) staticCallback_getPoints,
        (setter) staticCallback_setPoints,
        "A list of points of the facet",
        nullptr
    },
    {"PointIndices",
        (getter) staticCallback_getPointIndices,
        (setter) staticCallback_setPointIndices,
        "The index tuple of point vertices of the mesh this facet is built of",
        nullptr
    },
    {"NeighbourIndices",
        (getter) staticCallback_getNeighbourIndices,
        (setter) staticCallback_setNeighbourIndices,
        "The index tuple of neighbour facets of the mesh this facet is adjacent with",
        nullptr
    },
    {"Area",
        (getter) staticCallback_getArea,
        (setter) staticCallback_setArea,
        "The area of the facet",
        nullptr
    },
    {"AspectRatio",
        (getter) staticCallback_getAspectRatio,
        (setter) staticCallback_setAspectRatio,
        "The aspect ratio of the facet computed by longest edge and its height",
        nullptr
    },
    {"AspectRatio2",
        (getter) staticCallback_getAspectRatio2,
        (setter) staticCallback_setAspectRatio2,
        "The aspect ratio of the facet computed by radius of circum-circle and in-circle",
        nullptr
    },
    {"Roundness",
        (getter) staticCallback_getRoundness,
        (setter) staticCallback_setRoundness,
        "The roundness of the facet",
        nullptr
    },
    {"CircumCircle",
        (getter) staticCallback_getCircumCircle,
        (setter) staticCallback_setCircumCircle,
        "The center and radius of the circum-circle",
        nullptr
    },
    {"InCircle",
        (getter) staticCallback_getInCircle,
        (setter) staticCallback_setInCircle,
        "The center and radius of the in-circle",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// unbound() callback and implementer
// PyObject*  FacetPy::unbound(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_unbound (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'unbound' of 'Mesh.Facet' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<FacetPy*>(self)->unbound(args);
        if (ret != nullptr)
            static_cast<FacetPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// intersect() callback and implementer
// PyObject*  FacetPy::intersect(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_intersect (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'intersect' of 'Mesh.Facet' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<FacetPy*>(self)->intersect(args);
        if (ret != nullptr)
            static_cast<FacetPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isDegenerated() callback and implementer
// PyObject*  FacetPy::isDegenerated(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_isDegenerated (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isDegenerated' of 'Mesh.Facet' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<FacetPy*>(self)->isDegenerated(args);
        if (ret != nullptr)
            static_cast<FacetPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// isDeformed() callback and implementer
// PyObject*  FacetPy::isDeformed(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_isDeformed (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'isDeformed' of 'Mesh.Facet' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<FacetPy*>(self)->isDeformed(args);
        if (ret != nullptr)
            static_cast<FacetPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// getEdge() callback and implementer
// PyObject*  FacetPy::getEdge(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getEdge (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'getEdge' of 'Mesh.Facet' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<FacetPy*>(self)->getEdge(args);
        if (ret != nullptr)
            static_cast<FacetPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Index() callback and implementer
// PyObject*  FacetPy::Index(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getIndex (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getIndex());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Index' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setIndex (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Index' of object 'Facet' is read-only");
    return -1;
}

// Bound() callback and implementer
// PyObject*  FacetPy::Bound(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getBound (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getBound());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Bound' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setBound (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Bound' of object 'Facet' is read-only");
    return -1;
}

// Normal() callback and implementer
// PyObject*  FacetPy::Normal(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getNormal (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getNormal());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Normal' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setNormal (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Normal' of object 'Facet' is read-only");
    return -1;
}

// Points() callback and implementer
// PyObject*  FacetPy::Points(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getPoints (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getPoints());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Points' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setPoints (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Points' of object 'Facet' is read-only");
    return -1;
}

// PointIndices() callback and implementer
// PyObject*  FacetPy::PointIndices(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getPointIndices (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getPointIndices());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'PointIndices' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setPointIndices (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'PointIndices' of object 'Facet' is read-only");
    return -1;
}

// NeighbourIndices() callback and implementer
// PyObject*  FacetPy::NeighbourIndices(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getNeighbourIndices (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getNeighbourIndices());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'NeighbourIndices' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setNeighbourIndices (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'NeighbourIndices' of object 'Facet' is read-only");
    return -1;
}

// Area() callback and implementer
// PyObject*  FacetPy::Area(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getArea (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getArea());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Area' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setArea (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Area' of object 'Facet' is read-only");
    return -1;
}

// AspectRatio() callback and implementer
// PyObject*  FacetPy::AspectRatio(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getAspectRatio (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getAspectRatio());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AspectRatio' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setAspectRatio (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'AspectRatio' of object 'Facet' is read-only");
    return -1;
}

// AspectRatio2() callback and implementer
// PyObject*  FacetPy::AspectRatio2(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getAspectRatio2 (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getAspectRatio2());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'AspectRatio2' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setAspectRatio2 (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'AspectRatio2' of object 'Facet' is read-only");
    return -1;
}

// Roundness() callback and implementer
// PyObject*  FacetPy::Roundness(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getRoundness (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getRoundness());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Roundness' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setRoundness (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'Roundness' of object 'Facet' is read-only");
    return -1;
}

// CircumCircle() callback and implementer
// PyObject*  FacetPy::CircumCircle(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getCircumCircle (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getCircumCircle());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'CircumCircle' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setCircumCircle (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'CircumCircle' of object 'Facet' is read-only");
    return -1;
}

// InCircle() callback and implementer
// PyObject*  FacetPy::InCircle(PyObject *args){};
// has to be implemented in FacetPyImp.cpp
PyObject * FacetPy::staticCallback_getInCircle (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<FacetPy*>(self)->getInCircle());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'InCircle' of object 'Facet'");
        return nullptr;
    }
}

int FacetPy::staticCallback_setInCircle (PyObject *self, PyObject * /*value*/, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }

    PyErr_SetString(PyExc_AttributeError, "Attribute 'InCircle' of object 'Facet' is read-only");
    return -1;
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
FacetPy::FacetPy(Facet *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
FacetPy::~FacetPy()                                // Everything handled in parent
{
    // delete the handled object when the PyObject dies
    FacetPy::PointerType ptr = static_cast<FacetPy::PointerType>(_pcTwinPointer);
    delete ptr;
}

//--------------------------------------------------------------------------
// FacetPy representation
//--------------------------------------------------------------------------
PyObject *FacetPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// FacetPy Attributes
//--------------------------------------------------------------------------
PyObject *FacetPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int FacetPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

Facet *FacetPy::getFacetPtr() const
{
    return static_cast<Facet *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in FacetPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *FacetPy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of FacetPy and the Twin object
    return new FacetPy(new Facet);
}

// constructor method
int FacetPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string FacetPy::representation() const
{
    return {"<Facet object>"};
}

PyObject* FacetPy::unbound(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* FacetPy::intersect(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* FacetPy::isDegenerated(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* FacetPy::isDeformed(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* FacetPy::getEdge(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Long FacetPy::getIndex() const
{
    //return Py::Long();
    throw Py::AttributeError("Not yet implemented");
}

Py::Boolean FacetPy::getBound() const
{
    //return Py::Boolean();
    throw Py::AttributeError("Not yet implemented");
}

Py::Object FacetPy::getNormal() const
{
    //return Py::Object();
    throw Py::AttributeError("Not yet implemented");
}

Py::List FacetPy::getPoints() const
{
    //return Py::List();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple FacetPy::getPointIndices() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple FacetPy::getNeighbourIndices() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float FacetPy::getArea() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float FacetPy::getAspectRatio() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float FacetPy::getAspectRatio2() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Float FacetPy::getRoundness() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple FacetPy::getCircumCircle() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

Py::Tuple FacetPy::getInCircle() const
{
    //return Py::Tuple();
    throw Py::AttributeError("Not yet implemented");
}

PyObject *FacetPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int FacetPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



