
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "pluginproxy_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

// Wrappers
#include "plugins_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_PluginProxy_Type = nullptr;
static PyTypeObject *Sbk_PluginProxy_TypeF(void)
{
    return _Sbk_PluginProxy_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void PluginProxyWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::PluginProxy::EventHandlerType >("PluginProxy::EventHandlerType");
}

void PluginProxyWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

PluginProxyWrapper::PluginProxyWrapper(::QObject * parent) : PluginProxy(parent)
{
}

void PluginProxyWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginProxy_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("PluginProxy", funcName, gil, pyOverride, event);
}

void PluginProxyWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginProxy_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("PluginProxy", funcName, gil, pyOverride, signal);
}

void PluginProxyWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginProxy_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("PluginProxy", funcName, gil, pyOverride, event);
}

void PluginProxyWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginProxy_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("PluginProxy", funcName, gil, pyOverride, signal);
}

bool PluginProxyWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginProxy_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("PluginProxy", funcName, gil, pyOverride, event);
}

bool PluginProxyWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginProxy_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("PluginProxy", funcName, gil, pyOverride, watched, event);
}

void PluginProxyWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PluginProxy_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("PluginProxy", funcName, gil, pyOverride, event);
}

const QMetaObject *PluginProxyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return PluginProxy::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int PluginProxyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = PluginProxy::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *PluginProxyWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< PluginProxyWrapper *>(this));
    }
    return PluginProxy::qt_metacast(_clname);
}

PluginProxyWrapper::~PluginProxyWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_PluginProxy_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PluginProxy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PluginProxy >()))
        return -1;

    PluginProxyWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:PluginProxy", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: PluginProxy::PluginProxy(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // PluginProxy(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // PluginProxy(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // PluginProxy(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) PluginProxyWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new PluginProxyWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< PluginProxy >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);
    };


    return 1;
}

static PyObject *Sbk_PluginProxyFunc_acceptNavigationRequest(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "acceptNavigationRequest", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)->bool
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEnginePage_NavigationType_IDX])))->converter, (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))) {
        overloadId = 0; // acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "acceptNavigationRequest", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QUrl cppArg1_local;
        ::QUrl *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QWebEnginePage::NavigationType cppArg2{QWebEnginePage::NavigationTypeLinkClicked};
        pythonToCpp[2](pyArgs[2], &cppArg2);
        bool cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // acceptNavigationRequest(WebPage*,QUrl,QWebEnginePage::NavigationType,bool)
            bool cppResult = cppSelf->acceptNavigationRequest(cppArg0, *cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_emitMainWindowCreated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitMainWindowCreated(BrowserWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArg)))) {
        overloadId = 0; // emitMainWindowCreated(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "emitMainWindowCreated", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // emitMainWindowCreated(BrowserWindow*)
            cppSelf->emitMainWindowCreated(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginProxyFunc_emitMainWindowDeleted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitMainWindowDeleted(BrowserWindow*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArg)))) {
        overloadId = 0; // emitMainWindowDeleted(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "emitMainWindowDeleted", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // emitMainWindowDeleted(BrowserWindow*)
            cppSelf->emitMainWindowDeleted(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginProxyFunc_emitWebPageCreated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitWebPageCreated(WebPage*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArg)))) {
        overloadId = 0; // emitWebPageCreated(WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "emitWebPageCreated", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // emitWebPageCreated(WebPage*)
            cppSelf->emitWebPageCreated(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginProxyFunc_emitWebPageDeleted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::emitWebPageDeleted(WebPage*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArg)))) {
        overloadId = 0; // emitWebPageDeleted(WebPage*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "emitWebPageDeleted", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // emitWebPageDeleted(WebPage*)
            cppSelf->emitWebPageDeleted(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginProxyFunc_newWindowRequested(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "newWindowRequested", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::newWindowRequested(WebPage*,QWebEngineNewWindowRequest&)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebPage_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineNewWindowRequest_IDX]), (pyArgs[1])))) {
        overloadId = 0; // newWindowRequested(WebPage*,QWebEngineNewWindowRequest&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "newWindowRequested", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::WebPage *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWebEngineNewWindowRequest *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // newWindowRequested(WebPage*,QWebEngineNewWindowRequest&)
            bool cppResult = cppSelf->newWindowRequested(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_populateExtensionsMenu(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PluginProxy::populateExtensionsMenu(QMenu*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArg)))) {
        overloadId = 0; // populateExtensionsMenu(QMenu*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "populateExtensionsMenu", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // populateExtensionsMenu(QMenu*)
            cppSelf->populateExtensionsMenu(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginProxyFunc_populateWebViewMenu(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "populateWebViewMenu", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebHitTestResult_IDX]), (pyArgs[2])))) {
        overloadId = 0; // populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "populateWebViewMenu", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QMenu *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::WebView *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::WebHitTestResult cppArg2_local = ::WebHitTestResult(static_cast<::WebPage*>(nullptr), ::QPoint());
        ::WebHitTestResult *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2].isValue())
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (Shiboken::Errors::occurred() == nullptr) {
            // populateWebViewMenu(QMenu*,WebView*,WebHitTestResult)
            cppSelf->populateWebViewMenu(cppArg0, cppArg1, *cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PluginProxyFunc_processKeyPress(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processKeyPress", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processKeyPress(Qz::ObjectName,QObject*,QKeyEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processKeyPress(Qz::ObjectName,QObject*,QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processKeyPress", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeyEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processKeyPress(Qz::ObjectName,QObject*,QKeyEvent*)
            bool cppResult = cppSelf->processKeyPress(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_processKeyRelease(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processKeyRelease", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processKeyRelease(Qz::ObjectName,QObject*,QKeyEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processKeyRelease(Qz::ObjectName,QObject*,QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processKeyRelease", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QKeyEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processKeyRelease(Qz::ObjectName,QObject*,QKeyEvent*)
            bool cppResult = cppSelf->processKeyRelease(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_processMouseDoubleClick(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processMouseDoubleClick", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processMouseDoubleClick", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processMouseDoubleClick(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMouseDoubleClick(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_processMouseMove(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processMouseMove", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMouseMove(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMouseMove(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processMouseMove", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processMouseMove(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMouseMove(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_processMousePress(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processMousePress", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMousePress(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMousePress(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processMousePress", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processMousePress(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMousePress(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_processMouseRelease(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processMouseRelease", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processMouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processMouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processMouseRelease", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QMouseEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processMouseRelease(Qz::ObjectName,QObject*,QMouseEvent*)
            bool cppResult = cppSelf->processMouseRelease(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_processWheelEvent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "processWheelEvent", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::processWheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Qz_ObjectName_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QWheelEvent_IDX]), (pyArgs[2])))) {
        overloadId = 0; // processWheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "processWheelEvent", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::Qz::ObjectName cppArg0{Qz::ON_WebView};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QObject *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWheelEvent *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processWheelEvent(Qz::ObjectName,QObject*,QWheelEvent*)
            bool cppResult = cppSelf->processWheelEvent(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PluginProxyFunc_registerAppEventHandler(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<PluginProxyWrapper *>(reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "registerAppEventHandler", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: PluginProxy::registerAppEventHandler(PluginProxy::EventHandlerType,PluginInterface*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_EventHandlerType_IDX])))->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginInterface_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerAppEventHandler(PluginProxy::EventHandlerType,PluginInterface*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "registerAppEventHandler", errInfo, SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]);

    // Call function/method
    {
        ::PluginProxy::EventHandlerType cppArg0{PluginProxy::MouseDoubleClickHandler};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::PluginInterface *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerAppEventHandler(PluginProxy::EventHandlerType,PluginInterface*)
            cppSelf->registerAppEventHandler(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_PluginProxy_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_PluginProxy_EnumFlagInfo[] = {
    "EventHandlerType:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_PluginProxy_methods[] = {
    {"acceptNavigationRequest", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_acceptNavigationRequest), METH_VARARGS, nullptr},
    {"emitMainWindowCreated", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitMainWindowCreated), METH_O, nullptr},
    {"emitMainWindowDeleted", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitMainWindowDeleted), METH_O, nullptr},
    {"emitWebPageCreated", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitWebPageCreated), METH_O, nullptr},
    {"emitWebPageDeleted", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_emitWebPageDeleted), METH_O, nullptr},
    {"newWindowRequested", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_newWindowRequested), METH_VARARGS, nullptr},
    {"populateExtensionsMenu", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_populateExtensionsMenu), METH_O, nullptr},
    {"populateWebViewMenu", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_populateWebViewMenu), METH_VARARGS, nullptr},
    {"processKeyPress", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processKeyPress), METH_VARARGS, nullptr},
    {"processKeyRelease", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processKeyRelease), METH_VARARGS, nullptr},
    {"processMouseDoubleClick", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMouseDoubleClick), METH_VARARGS, nullptr},
    {"processMouseMove", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMouseMove), METH_VARARGS, nullptr},
    {"processMousePress", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMousePress), METH_VARARGS, nullptr},
    {"processMouseRelease", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processMouseRelease), METH_VARARGS, nullptr},
    {"processWheelEvent", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_processWheelEvent), METH_VARARGS, nullptr},
    {"registerAppEventHandler", reinterpret_cast<PyCFunction>(Sbk_PluginProxyFunc_registerAppEventHandler), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_PluginProxy_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::PluginProxy *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<PluginProxyWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_PluginProxy_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_PluginProxy_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_PluginProxy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_PluginProxy_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PluginProxy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PluginProxy_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PluginProxy_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PluginProxy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_PluginProxy_spec = {
    "1:PyFalkon.PluginProxy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_PluginProxy_slots
};

} //extern "C"

static void *Sbk_PluginProxy_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::PluginProxy *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_PluginProxy_EventHandlerType(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::PluginProxy::EventHandlerType>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::PluginProxy::EventHandlerType *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_PluginProxy_EventHandlerType_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PluginProxy_EventHandlerType_IDX])))
        return Enum_PythonToCpp_PluginProxy_EventHandlerType;
    return {};
}

static PyObject *PluginProxy_EventHandlerType_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::PluginProxy::EventHandlerType>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::PluginProxy::EventHandlerType *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PluginProxy_PythonToCpp_PluginProxy_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_PluginProxy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PluginProxy_PythonToCpp_PluginProxy_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_PluginProxy_TypeF()))
        return PluginProxy_PythonToCpp_PluginProxy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PluginProxy_PTR_CppToPython_PluginProxy(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::PluginProxy *>(const_cast<void *>(cppIn)), Sbk_PluginProxy_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PluginProxy_SignatureStrings[] = {
    "PyFalkon.PluginProxy(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.PluginProxy.acceptNavigationRequest(self,page:PyFalkon.WebPage,url:typing.Union[PySide6.QtCore.QUrl, QString],type:PySide6.QtWebEngineCore.QWebEnginePage.NavigationType,isMainFrame:bool)->bool",
    "PyFalkon.PluginProxy.emitMainWindowCreated(self,window:PyFalkon.BrowserWindow)",
    "PyFalkon.PluginProxy.emitMainWindowDeleted(self,window:PyFalkon.BrowserWindow)",
    "PyFalkon.PluginProxy.emitWebPageCreated(self,page:PyFalkon.WebPage)",
    "PyFalkon.PluginProxy.emitWebPageDeleted(self,page:PyFalkon.WebPage)",
    "PyFalkon.PluginProxy.newWindowRequested(self,page:PyFalkon.WebPage,request:PySide6.QtWebEngineCore.QWebEngineNewWindowRequest)->bool",
    "PyFalkon.PluginProxy.populateExtensionsMenu(self,menu:PySide6.QtWidgets.QMenu)",
    "PyFalkon.PluginProxy.populateWebViewMenu(self,menu:PySide6.QtWidgets.QMenu,view:PyFalkon.WebView,r:PyFalkon.WebHitTestResult)",
    "PyFalkon.PluginProxy.processKeyPress(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QKeyEvent)->bool",
    "PyFalkon.PluginProxy.processKeyRelease(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QKeyEvent)->bool",
    "PyFalkon.PluginProxy.processMouseDoubleClick(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processMouseMove(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processMousePress(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processMouseRelease(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QMouseEvent)->bool",
    "PyFalkon.PluginProxy.processWheelEvent(self,type:PyFalkon.Qz.ObjectName,obj:PySide6.QtCore.QObject,event:PySide6.QtGui.QWheelEvent)->bool",
    "PyFalkon.PluginProxy.registerAppEventHandler(self,type:PyFalkon.PluginProxy.EventHandlerType,obj:PyFalkon.PluginInterface)",
    nullptr}; // Sentinel
#else
static constexpr size_t PluginProxy_SignatureByteSize = 461;
static constexpr uint8_t PluginProxy_SignatureBytes[461] = {
    0x78, 0xda, 0xcd, 0x95, 0xcb, 0x6e, 0xdb, 0x30, 0x10, 0x45, 0xf7, 0xfd, 0x8a, 0x2e, 0x6b, 0x80,
    0xe5, 0xb2, 0x0b, 0x03, 0x09, 0xd0, 0x3a, 0xce, 0x03, 0x85, 0x5d, 0xc9, 0x49, 0xea, 0x45, 0xd1,
    0x05, 0x25, 0xdd, 0xa8, 0x4c, 0x68, 0x52, 0xe5, 0xc3, 0x8a, 0xfa, 0xf5, 0x1d, 0x49, 0xae, 0x6d,
    0x05, 0x8e, 0x62, 0xb7, 0x09, 0xd2, 0x95, 0xa4, 0xc1, 0x9d, 0x3b, 0x67, 0xc8, 0x21, 0x15, 0x55,
    0xa7, 0x42, 0xdd, 0x19, 0xcd, 0x23, 0x15, 0x72, 0xa9, 0x23, 0x6b, 0xee, 0xab, 0x77, 0x0e, 0xea,
    0x86, 0x15, 0xc2, 0x42, 0xfb, 0x61, 0x54, 0x5d, 0xca, 0x0c, 0x1f, 0x78, 0xec, 0x47, 0xc6, 0x82,
    0xc7, 0x5f, 0x92, 0x5b, 0xa4, 0xfe, 0x48, 0x07, 0xa5, 0x0a, 0x6f, 0x07, 0x6f, 0xa2, 0x1d, 0x06,
    0x5c, 0xa4, 0x29, 0x0a, 0x3f, 0x15, 0x4b, 0x99, 0x0b, 0x2f, 0x8d, 0x9e, 0xe1, 0x67, 0x80, 0xf3,
    0x7f, 0x8c, 0x73, 0x0c, 0xd7, 0x69, 0x73, 0x24, 0x11, 0x05, 0x58, 0xb0, 0x6a, 0xe8, 0xab, 0x42,
    0xea, 0x9c, 0x5f, 0x6b, 0x4a, 0xf9, 0xf6, 0xb0, 0xf0, 0xb5, 0x55, 0xec, 0x6d, 0x7c, 0xe9, 0x2d,
    0x49, 0xbe, 0x33, 0x92, 0x62, 0x8b, 0x8d, 0x5c, 0xc6, 0x9a, 0xca, 0xa3, 0xd5, 0xae, 0x3f, 0x6b,
    0x6b, 0xbe, 0xe1, 0xb8, 0xa2, 0x2c, 0x26, 0xdd, 0x44, 0x48, 0x7d, 0x6a, 0xc5, 0x02, 0xc3, 0xc4,
    0x18, 0x35, 0x78, 0x7f, 0x5c, 0x3f, 0x76, 0x77, 0x82, 0x85, 0xf4, 0xb5, 0x7c, 0x2e, 0x75, 0x66,
    0xca, 0x91, 0x85, 0xf0, 0xc8, 0xda, 0x3e, 0xca, 0x26, 0xb4, 0xe9, 0xe4, 0x93, 0x35, 0xa5, 0x83,
    0x6d, 0x95, 0x83, 0x7d, 0xec, 0x4e, 0xa0, 0xf0, 0xcf, 0x76, 0xab, 0x05, 0xec, 0xa0, 0xed, 0x5c,
    0xe2, 0xa7, 0x3d, 0x3a, 0x3c, 0x87, 0x78, 0x68, 0x94, 0x2d, 0xe7, 0x6a, 0xa3, 0x7b, 0x3d, 0x98,
    0x6d, 0x45, 0x7b, 0x6c, 0xdf, 0xf4, 0x81, 0x6f, 0xef, 0x56, 0x15, 0xa6, 0x08, 0x8a, 0xd6, 0x60,
    0x7c, 0xef, 0xa1, 0x1d, 0xed, 0xb6, 0x9b, 0x40, 0x87, 0x16, 0x64, 0x41, 0x6f, 0xdb, 0xf5, 0x64,
    0x96, 0xc3, 0x3b, 0x1e, 0xd7, 0x8a, 0x41, 0xbf, 0x1d, 0xc1, 0x7c, 0x95, 0x28, 0xf7, 0xf3, 0x62,
    0x4b, 0x92, 0x76, 0x3a, 0xae, 0x73, 0x99, 0xed, 0x84, 0xce, 0xa5, 0xbf, 0xa2, 0x66, 0x66, 0x70,
    0x41, 0xf9, 0xc7, 0xaa, 0x5b, 0x93, 0xc2, 0xb9, 0xcf, 0xa8, 0x22, 0x4b, 0xcf, 0xb6, 0xf2, 0x6a,
    0xe8, 0x57, 0xf2, 0xf8, 0x17, 0x6f, 0x0f, 0xe3, 0x94, 0x26, 0x99, 0x99, 0xe4, 0xf6, 0x91, 0xb3,
    0xca, 0xb0, 0xec, 0x1e, 0xe4, 0xb3, 0x20, 0x79, 0x4c, 0xce, 0xe3, 0x3a, 0xde, 0xbf, 0xa4, 0x6b,
    0x8a, 0x19, 0x8d, 0x86, 0x70, 0x78, 0x5d, 0x8e, 0x89, 0x09, 0x0e, 0x27, 0x26, 0x24, 0x0a, 0x23,
    0x25, 0xd3, 0xbb, 0xe7, 0xa7, 0x69, 0x2a, 0x1c, 0xc6, 0x33, 0x31, 0x4b, 0xfc, 0x17, 0x20, 0x2f,
    0x34, 0x28, 0x7f, 0x41, 0xf2, 0x62, 0xc3, 0x72, 0x18, 0xcb, 0xfc, 0x07, 0xa0, 0x1a, 0xf5, 0xf3,
    0x93, 0x6c, 0xbc, 0x7b, 0x49, 0x2c, 0x72, 0x49, 0xd7, 0xa1, 0xfd, 0x58, 0x14, 0x8d, 0xf8, 0x5c,
    0xe8, 0x4c, 0xc1, 0xee, 0xe2, 0xd9, 0x4e, 0xdb, 0xd6, 0x36, 0xff, 0xac, 0x16, 0xaf, 0xa3, 0xbc,
    0xd0, 0xe4, 0x7b, 0x23, 0x52, 0xba, 0x93, 0x7f, 0x03, 0x9b, 0xaa, 0xe1, 0x40
};
#endif

PyTypeObject *init_PluginProxy(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX].type;

    Shiboken::AutoDecRef Sbk_PluginProxy_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_Plugins_IDX]))));

    _Sbk_PluginProxy_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PluginProxy",
        "PluginProxy*",
        &Sbk_PluginProxy_spec,
        &Shiboken::callCppDestructor< PluginProxy >,
        Sbk_PluginProxy_Type_bases.object(),
        0);
    auto *pyType = _Sbk_PluginProxy_Type; // references _Sbk_PluginProxy_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, PluginProxy_SignatureStrings);
#else
    InitSignatureBytes(pyType, PluginProxy_SignatureBytes, PluginProxy_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_PluginProxy_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_PluginProxy_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        PluginProxy_PythonToCpp_PluginProxy_PTR,
        is_PluginProxy_PythonToCpp_PluginProxy_PTR_Convertible,
        PluginProxy_PTR_CppToPython_PluginProxy);

    Shiboken::Conversions::registerConverterName(converter, "PluginProxy");
    Shiboken::Conversions::registerConverterName(converter, "PluginProxy*");
    Shiboken::Conversions::registerConverterName(converter, "PluginProxy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PluginProxy).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(PluginProxyWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_PluginProxy_TypeF(), &Sbk_PluginProxy_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_PluginProxy_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'EventHandlerType'.
    const char *EventHandlerType_Initializer[] = {
        "MouseDoubleClickHandler",
        "MousePressHandler",
        "MouseReleaseHandler",
        "MouseMoveHandler",
        "KeyPressHandler",
        "KeyReleaseHandler",
        "WheelEventHandler",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t EventHandlerType_InitializerValues[] = {
        uint8_t(PluginProxy::EventHandlerType::MouseDoubleClickHandler), //  0x00  0
        uint8_t(PluginProxy::EventHandlerType::MousePressHandler),       //  0x01  1
        uint8_t(PluginProxy::EventHandlerType::MouseReleaseHandler),     //  0x02  2
        uint8_t(PluginProxy::EventHandlerType::MouseMoveHandler),        //  0x03  3
        uint8_t(PluginProxy::EventHandlerType::KeyPressHandler),         //  0x04  4
        uint8_t(PluginProxy::EventHandlerType::KeyReleaseHandler),       //  0x05  5
        uint8_t(PluginProxy::EventHandlerType::WheelEventHandler)        //  0x06  6
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_PluginProxy_TypeF(),
        "1:PyFalkon.PluginProxy.EventHandlerType",
        EventHandlerType_Initializer, EventHandlerType_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_PluginProxy_EventHandlerType_IDX].type = EType;
    // Register converter for enum 'PluginProxy::EventHandlerType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            PluginProxy_EventHandlerType_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_PluginProxy_EventHandlerType,
            is_Enum_PythonToCpp_PluginProxy_EventHandlerType_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "PluginProxy::EventHandlerType");
        Shiboken::Conversions::registerConverterAlias(converter, "EventHandlerType");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'EventHandlerType' enum.

    PySide::Signal::registerSignals(pyType, &::PluginProxy::staticMetaObject);
    PluginProxyWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::PluginProxy::staticMetaObject, sizeof(PluginProxyWrapper));

    return pyType;
}
