
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "clickablelabel_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"
#include "squeezelabelv2_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_ClickableLabel_Type = nullptr;
static PyTypeObject *Sbk_ClickableLabel_TypeF(void)
{
    return _Sbk_ClickableLabel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void ClickableLabelWrapper::pysideInitQtMetaTypes()
{
}

void ClickableLabelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

ClickableLabelWrapper::ClickableLabelWrapper(::QWidget * parent) : ClickableLabel(parent)
{
}

void ClickableLabelWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::changeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_changeEvent("ClickableLabel", funcName, gil, pyOverride, arg__1);
}

void ClickableLabelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ClickableLabel", funcName, gil, pyOverride, signal);
}

void ClickableLabelWrapper::contextMenuEvent(::QContextMenuEvent * ev)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::contextMenuEvent(ev);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("ClickableLabel", funcName, gil, pyOverride, ev);
}

void ClickableLabelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

int ClickableLabelWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("ClickableLabel", funcName, gil, pyOverride);
}

void ClickableLabelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("ClickableLabel", funcName, gil, pyOverride, signal);
}

void ClickableLabelWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

bool ClickableLabelWrapper::event(::QEvent * e)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::event(e);
    }
    return WebViewWrapper::sbk_o_event("ClickableLabel", funcName, gil, pyOverride, e);
}

bool ClickableLabelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("ClickableLabel", funcName, gil, pyOverride, watched, event);
}

void ClickableLabelWrapper::focusInEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusInEvent(ev);
    }
    WebViewWrapper::sbk_o_focusInEvent("ClickableLabel", funcName, gil, pyOverride, ev);
}

bool ClickableLabelWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("ClickableLabel", funcName, gil, pyOverride, next);
}

void ClickableLabelWrapper::focusOutEvent(::QFocusEvent * ev)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::focusOutEvent(ev);
    }
    WebViewWrapper::sbk_o_focusOutEvent("ClickableLabel", funcName, gil, pyOverride, ev);
}

bool ClickableLabelWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("ClickableLabel", funcName, gil, pyOverride);
}

int ClickableLabelWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("ClickableLabel", funcName, gil, pyOverride, arg__1);
}

void ClickableLabelWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("ClickableLabel", funcName, gil, pyOverride, painter);
}

void ClickableLabelWrapper::initStyleOption(::QStyleOptionFrame * option) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QFrame::initStyleOption(option);
    }
    SqueezeLabelV2Wrapper::sbk_o_initStyleOption("ClickableLabel", funcName, gil, pyOverride, option);
}

void ClickableLabelWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

::QVariant ClickableLabelWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("ClickableLabel", funcName, gil, pyOverride, arg__1);
}

void ClickableLabelWrapper::keyPressEvent(::QKeyEvent * ev)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::keyPressEvent(ev);
    }
    WebViewWrapper::sbk_o_keyPressEvent("ClickableLabel", funcName, gil, pyOverride, ev);
}

void ClickableLabelWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

int ClickableLabelWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("ClickableLabel", funcName, gil, pyOverride, arg__1);
}

::QSize ClickableLabelWrapper::minimumSizeHint() const
{
    static const char *funcName = "minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("ClickableLabel", funcName, gil, pyOverride);
}

void ClickableLabelWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::mouseMoveEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mouseMoveEvent(ev);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("ClickableLabel", funcName, gil, pyOverride, ev);
}

void ClickableLabelWrapper::mousePressEvent(::QMouseEvent * ev)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::mousePressEvent(ev);
    }
    WebViewWrapper::sbk_o_mousePressEvent("ClickableLabel", funcName, gil, pyOverride, ev);
}

void ClickableLabelWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

bool ClickableLabelWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("ClickableLabel", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * ClickableLabelWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("ClickableLabel", funcName, gil, pyOverride);
}

void ClickableLabelWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::paintEvent(arg__1);
    }
    WebViewWrapper::sbk_o_paintEvent("ClickableLabel", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * ClickableLabelWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("ClickableLabel", funcName, gil, pyOverride, offset);
}

void ClickableLabelWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("ClickableLabel", funcName, gil, pyOverride, visible);
}

::QPainter * ClickableLabelWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("ClickableLabel", funcName, gil, pyOverride);
}

void ClickableLabelWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

::QSize ClickableLabelWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QLabel::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("ClickableLabel", funcName, gil, pyOverride);
}

void ClickableLabelWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

void ClickableLabelWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_ClickableLabel_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("ClickableLabel", funcName, gil, pyOverride, event);
}

const QMetaObject *ClickableLabelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return ClickableLabel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int ClickableLabelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = ClickableLabel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *ClickableLabelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< ClickableLabelWrapper *>(this));
    }
    return ClickableLabel::qt_metacast(_clname);
}

ClickableLabelWrapper::~ClickableLabelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_ClickableLabel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_ClickableLabel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::ClickableLabel >()))
        return -1;

    ClickableLabelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:ClickableLabel", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: ClickableLabel::ClickableLabel(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // ClickableLabel(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // ClickableLabel(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ClickableLabel(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) ClickableLabelWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new ClickableLabelWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ClickableLabel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);
    };


    return 1;
}

static PyObject *Sbk_ClickableLabelFunc_fallbackIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ClickableLabelWrapper *>(reinterpret_cast< ::ClickableLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fallbackIcon()const
        QIcon cppResult = const_cast<const ClickableLabelWrapper *>(cppSelf)->fallbackIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_ClickableLabelFunc_mouseReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ClickableLabelWrapper *>(reinterpret_cast< ::ClickableLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::mouseReleaseEvent(QMouseEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QMouseEvent_IDX]), (pyArg)))) {
        overloadId = 0; // mouseReleaseEvent(QMouseEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "mouseReleaseEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("mouseReleaseEvent(QMouseEvent *ev)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ClickableLabelFunc_resizeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ClickableLabelWrapper *>(reinterpret_cast< ::ClickableLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::resizeEvent(QResizeEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QResizeEvent_IDX]), (pyArg)))) {
        overloadId = 0; // resizeEvent(QResizeEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "resizeEvent", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("resizeEvent(QResizeEvent *ev)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ClickableLabelFunc_setFallbackIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ClickableLabelWrapper *>(reinterpret_cast< ::ClickableLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ClickableLabel::setFallbackIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setFallbackIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFallbackIcon", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setFallbackIcon(QIcon)
            cppSelf->setFallbackIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ClickableLabelFunc_setThemeIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ClickableLabelWrapper *>(reinterpret_cast< ::ClickableLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: ClickableLabel::setThemeIcon(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setThemeIcon(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setThemeIcon", errInfo, SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setThemeIcon(QString)
            cppSelf->setThemeIcon(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_ClickableLabelFunc_themeIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<ClickableLabelWrapper *>(reinterpret_cast< ::ClickableLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // themeIcon()const
        QString cppResult = const_cast<const ClickableLabelWrapper *>(cppSelf)->themeIcon();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_ClickableLabel_PropertyStrings[] = {
    "fallbackIcon::",
    "fixedheight:height:setFixedHeight",
    "fixedsize:size:setFixedSize",
    "fixedwidth:width:setFixedWidth",
    "themeIcon::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_ClickableLabel_methods[] = {
    {"fallbackIcon", reinterpret_cast<PyCFunction>(Sbk_ClickableLabelFunc_fallbackIcon), METH_NOARGS, nullptr},
    {"mouseReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_ClickableLabelFunc_mouseReleaseEvent), METH_O, nullptr},
    {"resizeEvent", reinterpret_cast<PyCFunction>(Sbk_ClickableLabelFunc_resizeEvent), METH_O, nullptr},
    {"setFallbackIcon", reinterpret_cast<PyCFunction>(Sbk_ClickableLabelFunc_setFallbackIcon), METH_O, nullptr},
    {"setThemeIcon", reinterpret_cast<PyCFunction>(Sbk_ClickableLabelFunc_setThemeIcon), METH_O, nullptr},
    {"themeIcon", reinterpret_cast<PyCFunction>(Sbk_ClickableLabelFunc_themeIcon), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_ClickableLabel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::ClickableLabel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<ClickableLabelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_ClickableLabel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_ClickableLabel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_ClickableLabelSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::ClickableLabel *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))
        return static_cast< ::QLabel *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QFrame_IDX]))
        return static_cast< ::QFrame *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_ClickableLabel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_ClickableLabel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_ClickableLabel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_ClickableLabel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_ClickableLabel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_ClickableLabel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_ClickableLabel_spec = {
    "1:PyFalkon.ClickableLabel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_ClickableLabel_slots
};

} //extern "C"

static void *Sbk_ClickableLabel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::ClickableLabel *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::ClickableLabel *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::ClickableLabel *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ClickableLabel_PythonToCpp_ClickableLabel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_ClickableLabel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ClickableLabel_PythonToCpp_ClickableLabel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_ClickableLabel_TypeF()))
        return ClickableLabel_PythonToCpp_ClickableLabel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ClickableLabel_PTR_CppToPython_ClickableLabel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::ClickableLabel *>(const_cast<void *>(cppIn)), Sbk_ClickableLabel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *ClickableLabel_SignatureStrings[] = {
    "PyFalkon.ClickableLabel(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,fixedsize:QSize=None,fixedwidth:int=None,fixedheight:int=None,themeIcon:QString=None,fallbackIcon:QIcon=None)",
    "PyFalkon.ClickableLabel.fallbackIcon(self)->PySide6.QtGui.QIcon",
    "PyFalkon.ClickableLabel.mouseReleaseEvent(self,ev:PySide6.QtGui.QMouseEvent)",
    "PyFalkon.ClickableLabel.resizeEvent(self,ev:PySide6.QtGui.QResizeEvent)",
    "PyFalkon.ClickableLabel.setFallbackIcon(self,fallbackIcon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "PyFalkon.ClickableLabel.setThemeIcon(self,name:QString)",
    "PyFalkon.ClickableLabel.themeIcon(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t ClickableLabel_SignatureByteSize = 264;
static constexpr uint8_t ClickableLabel_SignatureBytes[264] = {
    0x78, 0xda, 0x7d, 0x51, 0xcb, 0x6e, 0x83, 0x30, 0x10, 0xbc, 0xe7, 0x2b, 0x7a, 0x6c, 0x2a, 0xea,
    0x63, 0x0f, 0x48, 0xe9, 0xa5, 0x6a, 0xaa, 0xaa, 0x2f, 0x48, 0x5a, 0xf5, 0x50, 0xf5, 0x60, 0x60,
    0x03, 0x2b, 0x96, 0x35, 0xc2, 0x4b, 0x12, 0xfa, 0xf5, 0xe5, 0x91, 0x08, 0x82, 0x42, 0x2e, 0x2b,
    0x6b, 0x3c, 0x33, 0xeb, 0x19, 0x7b, 0xd5, 0x52, 0x53, 0x6a, 0x58, 0x3d, 0x10, 0x86, 0xa9, 0x0e,
    0x08, 0x5e, 0x75, 0x00, 0x74, 0x6d, 0x81, 0x36, 0x4e, 0xae, 0x0b, 0x60, 0x71, 0xbd, 0x6a, 0x8d,
    0x11, 0xdc, 0x29, 0x5f, 0xbe, 0x31, 0x8a, 0x41, 0xac, 0xf2, 0xbb, 0xc3, 0x82, 0x4b, 0xa2, 0x5c,
    0x0a, 0xe7, 0xc6, 0x7d, 0x81, 0x6a, 0x67, 0x8a, 0xe8, 0x83, 0xa9, 0x5a, 0xbc, 0x1b, 0x06, 0x67,
    0x83, 0x7b, 0x88, 0x2c, 0xfe, 0x81, 0xeb, 0xaf, 0xeb, 0x39, 0x00, 0x77, 0x18, 0x49, 0xe2, 0x22,
    0xcb, 0x00, 0x4b, 0x00, 0xe3, 0x44, 0x7a, 0x50, 0x12, 0xc8, 0xe0, 0x39, 0x34, 0x5c, 0xab, 0xa5,
    0x40, 0x8e, 0x0f, 0x5c, 0x4d, 0x14, 0xe8, 0x30, 0xed, 0x6e, 0x9a, 0xd9, 0xe2, 0xf3, 0x99, 0x77,
    0x3e, 0x86, 0x1a, 0x0a, 0xda, 0x4c, 0xf3, 0xdb, 0xfb, 0x3e, 0xce, 0x53, 0x89, 0xaa, 0x75, 0x99,
    0xd4, 0x67, 0xa6, 0xb4, 0xb0, 0x02, 0x02, 0x6d, 0xe1, 0x71, 0x5b, 0x97, 0xd1, 0x15, 0x03, 0x5b,
    0x77, 0xe4, 0xf2, 0xd6, 0x10, 0x5b, 0xc6, 0xf4, 0x63, 0x0a, 0x68, 0xfa, 0xb8, 0x68, 0xb3, 0xea,
    0x29, 0xd3, 0x3e, 0x16, 0x64, 0x39, 0xce, 0x75, 0x5a, 0x8d, 0x54, 0x79, 0xdd, 0x99, 0xfa, 0x62,
    0x34, 0xfc, 0x73, 0x26, 0xaf, 0x73, 0x35, 0x02, 0x3d, 0xdc, 0x67, 0x3a, 0xff, 0xbd, 0xb8, 0xf3,
    0xf3, 0xf8, 0x27, 0xdd, 0x42, 0xd6, 0x19, 0x1c, 0x7f, 0x67, 0x5a, 0x27, 0x27, 0xa2, 0xba, 0xfd,
    0x83, 0x62, 0xf6, 0x0f, 0x87, 0x5f, 0xe7, 0x28
};
#endif

PyTypeObject *init_ClickableLabel(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX].type;

    Shiboken::AutoDecRef Sbk_ClickableLabel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QLabel_IDX]))));

    _Sbk_ClickableLabel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "ClickableLabel",
        "ClickableLabel*",
        &Sbk_ClickableLabel_spec,
        &Shiboken::callCppDestructor< ClickableLabel >,
        Sbk_ClickableLabel_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_ClickableLabel_Type; // references _Sbk_ClickableLabel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, ClickableLabel_SignatureStrings);
#else
    InitSignatureBytes(pyType, ClickableLabel_SignatureBytes, ClickableLabel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_ClickableLabel_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_ClickableLabel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        ClickableLabel_PythonToCpp_ClickableLabel_PTR,
        is_ClickableLabel_PythonToCpp_ClickableLabel_PTR_Convertible,
        ClickableLabel_PTR_CppToPython_ClickableLabel);

    Shiboken::Conversions::registerConverterName(converter, "ClickableLabel");
    Shiboken::Conversions::registerConverterName(converter, "ClickableLabel*");
    Shiboken::Conversions::registerConverterName(converter, "ClickableLabel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::ClickableLabel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(ClickableLabelWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_ClickableLabel_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_ClickableLabel_TypeF(), &Sbk_ClickableLabelSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_ClickableLabel_TypeF(), &Sbk_ClickableLabel_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::ClickableLabel::staticMetaObject);
    ClickableLabelWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::ClickableLabel::staticMetaObject, sizeof(ClickableLabelWrapper));

    return pyType;
}
