/* Generated by wayland-scanner 1.24.0 */

#ifndef PLASMA_SHELL_SERVER_PROTOCOL_H
#define PLASMA_SHELL_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_plasma_shell The plasma_shell protocol
 * @section page_ifaces_plasma_shell Interfaces
 * - @subpage page_iface_org_kde_plasma_shell - create shell windows and helpers
 * - @subpage page_iface_org_kde_plasma_surface - metadata interface
 * @section page_copyright_plasma_shell Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2013-2014 Pier Luigi Fiorini
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * </pre>
 */
struct org_kde_plasma_shell;
struct org_kde_plasma_surface;
struct wl_output;
struct wl_surface;

#ifndef ORG_KDE_PLASMA_SHELL_INTERFACE
#define ORG_KDE_PLASMA_SHELL_INTERFACE
/**
 * @page page_iface_org_kde_plasma_shell org_kde_plasma_shell
 * @section page_iface_org_kde_plasma_shell_desc Description
 *
 * This interface is used by KF5 powered Wayland shells to communicate with
 * the compositor and can only be bound one time.
 * @section page_iface_org_kde_plasma_shell_api API
 * See @ref iface_org_kde_plasma_shell.
 */
/**
 * @defgroup iface_org_kde_plasma_shell The org_kde_plasma_shell interface
 *
 * This interface is used by KF5 powered Wayland shells to communicate with
 * the compositor and can only be bound one time.
 */
extern const struct wl_interface org_kde_plasma_shell_interface;
#endif
#ifndef ORG_KDE_PLASMA_SURFACE_INTERFACE
#define ORG_KDE_PLASMA_SURFACE_INTERFACE
/**
 * @page page_iface_org_kde_plasma_surface org_kde_plasma_surface
 * @section page_iface_org_kde_plasma_surface_desc Description
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface roles, assign an output
 * or set the position in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * org_kde_plasma_surface.destroy() must be called before
 * destroying the wl_surface object.
 * @section page_iface_org_kde_plasma_surface_api API
 * See @ref iface_org_kde_plasma_surface.
 */
/**
 * @defgroup iface_org_kde_plasma_surface The org_kde_plasma_surface interface
 *
 * An interface that may be implemented by a wl_surface, for
 * implementations that provide the shell user interface.
 *
 * It provides requests to set surface roles, assign an output
 * or set the position in output coordinates.
 *
 * On the server side the object is automatically destroyed when
 * the related wl_surface is destroyed.  On client side,
 * org_kde_plasma_surface.destroy() must be called before
 * destroying the wl_surface object.
 */
extern const struct wl_interface org_kde_plasma_surface_interface;
#endif

/**
 * @ingroup iface_org_kde_plasma_shell
 * @struct org_kde_plasma_shell_interface
 */
struct org_kde_plasma_shell_interface {
	/**
	 * create a shell surface from a surface
	 *
	 * Create a shell surface for an existing surface.
	 *
	 * Only one shell surface can be associated with a given surface.
	 */
	void (*get_surface)(struct wl_client *client,
			    struct wl_resource *resource,
			    uint32_t id,
			    struct wl_resource *surface);
};


/**
 * @ingroup iface_org_kde_plasma_shell
 */
#define ORG_KDE_PLASMA_SHELL_GET_SURFACE_SINCE_VERSION 1

#ifndef ORG_KDE_PLASMA_SURFACE_ROLE_ENUM
#define ORG_KDE_PLASMA_SURFACE_ROLE_ENUM
enum org_kde_plasma_surface_role {
	ORG_KDE_PLASMA_SURFACE_ROLE_NORMAL = 0,
	ORG_KDE_PLASMA_SURFACE_ROLE_DESKTOP = 1,
	ORG_KDE_PLASMA_SURFACE_ROLE_PANEL = 2,
	ORG_KDE_PLASMA_SURFACE_ROLE_ONSCREENDISPLAY = 3,
	ORG_KDE_PLASMA_SURFACE_ROLE_NOTIFICATION = 4,
	ORG_KDE_PLASMA_SURFACE_ROLE_TOOLTIP = 5,
	/**
	 * @since 6
	 */
	ORG_KDE_PLASMA_SURFACE_ROLE_CRITICALNOTIFICATION = 6,
	/**
	 * @since 8
	 */
	ORG_KDE_PLASMA_SURFACE_ROLE_APPLETPOPUP = 7,
	ORG_KDE_PLASMA_SURFACE_ROLE_STANDALONE = 8,
	ORG_KDE_PLASMA_SURFACE_ROLE_OVERRIDE = 9,
	ORG_KDE_PLASMA_SURFACE_ROLE_ACTIVEFULLSCREEN = 10,
};
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_ROLE_CRITICALNOTIFICATION_SINCE_VERSION 6
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_ROLE_APPLETPOPUP_SINCE_VERSION 8
#endif /* ORG_KDE_PLASMA_SURFACE_ROLE_ENUM */

#ifndef ORG_KDE_PLASMA_SURFACE_ROLE_ENUM_IS_VALID
#define ORG_KDE_PLASMA_SURFACE_ROLE_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_plasma_surface
 * Validate a org_kde_plasma_surface role value.
 *
 * @return true on success, false on error.
 * @ref org_kde_plasma_surface_role
 */
static inline bool
org_kde_plasma_surface_role_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_PLASMA_SURFACE_ROLE_NORMAL:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_DESKTOP:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_PANEL:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_ONSCREENDISPLAY:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_NOTIFICATION:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_TOOLTIP:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_CRITICALNOTIFICATION:
		return version >= 6;
	case ORG_KDE_PLASMA_SURFACE_ROLE_APPLETPOPUP:
		return version >= 8;
	case ORG_KDE_PLASMA_SURFACE_ROLE_STANDALONE:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_OVERRIDE:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_ROLE_ACTIVEFULLSCREEN:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ORG_KDE_PLASMA_SURFACE_ROLE_ENUM_IS_VALID */

#ifndef ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM
#define ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM
/**
 * @ingroup iface_org_kde_plasma_surface
 * Behavior for panel surface
 *
 */
enum org_kde_plasma_surface_panel_behavior {
	/**
	 * normal panel visibility
	 *
	 * The panel is on top of other surfaces, windows cannot cover
	 * (full screen windows excluded).
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ALWAYS_VISIBLE = 1,
	/**
	 * hide automatically
	 *
	 * The panel is hidden automatically and restored when the mouse
	 * is over.
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_AUTO_HIDE = 2,
	/**
	 * windows can cover
	 *
	 * Windows can cover the panel.
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_WINDOWS_CAN_COVER = 3,
	/**
	 * windows go below
	 *
	 * Maximized windows take the whole screen space but the panel is
	 * above the windows.
	 */
	ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_WINDOWS_GO_BELOW = 4,
};
#endif /* ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM */

#ifndef ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM_IS_VALID
#define ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_plasma_surface
 * Validate a org_kde_plasma_surface panel_behavior value.
 *
 * @return true on success, false on error.
 * @ref org_kde_plasma_surface_panel_behavior
 */
static inline bool
org_kde_plasma_surface_panel_behavior_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ALWAYS_VISIBLE:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_AUTO_HIDE:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_WINDOWS_CAN_COVER:
		return version >= 1;
	case ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_WINDOWS_GO_BELOW:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ORG_KDE_PLASMA_SURFACE_PANEL_BEHAVIOR_ENUM_IS_VALID */

#ifndef ORG_KDE_PLASMA_SURFACE_ERROR_ENUM
#define ORG_KDE_PLASMA_SURFACE_ERROR_ENUM
enum org_kde_plasma_surface_error {
	/**
	 * Request panel_auto_hide performed on a surface which does not correspond to an auto-hide panel.
	 */
	ORG_KDE_PLASMA_SURFACE_ERROR_PANEL_NOT_AUTO_HIDE = 0,
};
#endif /* ORG_KDE_PLASMA_SURFACE_ERROR_ENUM */

#ifndef ORG_KDE_PLASMA_SURFACE_ERROR_ENUM_IS_VALID
#define ORG_KDE_PLASMA_SURFACE_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_org_kde_plasma_surface
 * Validate a org_kde_plasma_surface error value.
 *
 * @return true on success, false on error.
 * @ref org_kde_plasma_surface_error
 */
static inline bool
org_kde_plasma_surface_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case ORG_KDE_PLASMA_SURFACE_ERROR_PANEL_NOT_AUTO_HIDE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* ORG_KDE_PLASMA_SURFACE_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_org_kde_plasma_surface
 * @struct org_kde_plasma_surface_interface
 */
struct org_kde_plasma_surface_interface {
	/**
	 * remove org_kde_plasma_surface interface
	 *
	 * The org_kde_plasma_surface interface is removed from the
	 * wl_surface object that was turned into a shell surface with the
	 * org_kde_plasma_shell.get_surface request. The shell surface role
	 * is lost and wl_surface is unmapped.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * assign an output to this shell surface
	 *
	 * Assign an output to this shell surface. The compositor will
	 * use this information to set the position when
	 * org_kde_plasma_surface.set_position request is called.
	 */
	void (*set_output)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *output);
	/**
	 * change the shell surface position
	 *
	 * Move the surface to new coordinates.
	 *
	 * Coordinates are global, for example 50,50 for a 1920,0+1920x1080
	 * output is 1970,50 in global coordinates space.
	 *
	 * Use org_kde_plasma_surface.set_output to assign an output to
	 * this surface.
	 * @param x x coordinate in global space
	 * @param y y coordinate in global space
	 */
	void (*set_position)(struct wl_client *client,
			     struct wl_resource *resource,
			     int32_t x,
			     int32_t y);
	/**
	 * assign a role to this surface
	 *
	 * Assign a role to a shell surface.
	 *
	 * The compositor handles surfaces depending on their role. See the
	 * explanation below.
	 *
	 * This request fails if the surface already has a role, this means
	 * the surface role may be assigned only once.
	 *
	 * == Surfaces with splash role ==
	 *
	 * Splash surfaces are placed above every other surface during the
	 * shell startup phase.
	 *
	 * The surfaces are placed according to the output coordinates. No
	 * size is imposed to those surfaces, the shell has to resize them
	 * according to output size.
	 *
	 * These surfaces are meant to hide the desktop during the startup
	 * phase so that the user will always see a ready to work desktop.
	 *
	 * A shell might not create splash surfaces if the compositor
	 * reveals the desktop in an alternative fashion, for example with
	 * a fade in effect.
	 *
	 * That depends on how much time the desktop usually need to
	 * prepare the workspace or specific design decisions. This
	 * specification doesn't impose any particular design.
	 *
	 * When the startup phase is finished, the shell will send the
	 * org_kde_plasma.desktop_ready request to the compositor.
	 *
	 * == Surfaces with desktop role ==
	 *
	 * Desktop surfaces are placed below all other surfaces and are
	 * used to show the actual desktop view with icons, search results
	 * or controls the user will interact with. What to show depends on
	 * the shell implementation.
	 *
	 * The surfaces are placed according to the output coordinates. No
	 * size is imposed to those surfaces, the shell has to resize them
	 * according to output size.
	 *
	 * Only one surface per output can have the desktop role.
	 *
	 * == Surfaces with dashboard role ==
	 *
	 * Dashboard surfaces are placed above desktop surfaces and are
	 * used to show additional widgets and controls.
	 *
	 * The surfaces are placed according to the output coordinates. No
	 * size is imposed to those surfaces, the shell has to resize them
	 * according to output size.
	 *
	 * Only one surface per output can have the dashboard role.
	 *
	 * == Surfaces with config role ==
	 *
	 * A configuration surface is shown when the user wants to
	 * configure panel or desktop views.
	 *
	 * Only one surface per output can have the config role.
	 *
	 * TODO: This should grab the input like popup menus, right?
	 *
	 * == Surfaces with overlay role ==
	 *
	 * Overlays are special surfaces that shows for a limited amount of
	 * time. Such surfaces are useful to display things like volume,
	 * brightness and status changes.
	 *
	 * Compositors may decide to show those surfaces in a layer above
	 * all surfaces, even full screen ones if so is desired.
	 *
	 * == Surfaces with notification role ==
	 *
	 * Notification surfaces display informative content for a limited
	 * amount of time. The compositor may decide to show them in a
	 * corner depending on the configuration.
	 *
	 * These surfaces are shown in a layer above all other surfaces
	 * except for full screen ones.
	 *
	 * == Surfaces with lock role ==
	 *
	 * The lock surface is shown by the compositor when the session is
	 * locked, users interact with it to unlock the session.
	 *
	 * Compositors should move lock surfaces to 0,0 in output
	 * coordinates space and hide all other surfaces for security sake.
	 * For the same reason it is recommended that clients make the lock
	 * surface as big as the screen.
	 *
	 * Only one surface per output can have the lock role.
	 */
	void (*set_role)(struct wl_client *client,
			 struct wl_resource *resource,
			 uint32_t role);
	/**
	 * set or unset the panel 
	 *
	 * Set flags bitmask as described by the flag enum. Pass 0 to
	 * unset any flag, the surface will adjust its behavior to the
	 * default.
	 * @param flag panel_behavior enum value
	 */
	void (*set_panel_behavior)(struct wl_client *client,
				   struct wl_resource *resource,
				   uint32_t flag);
	/**
	 * make the window skip the taskbar
	 *
	 * Setting this bit to the window, will make it say it prefers to
	 * not be listed in the taskbar. Taskbar implementations may or may
	 * not follow this hint.
	 * @param skip Boolean value that sets whether to skip the taskbar
	 * @since 2
	 */
	void (*set_skip_taskbar)(struct wl_client *client,
				 struct wl_resource *resource,
				 uint32_t skip);
	/**
	 * Hide the auto-hiding panel
	 *
	 * A panel surface with panel_behavior auto_hide can perform this
	 * request to hide the panel on a screen edge without unmapping it.
	 * The compositor informs the client about the panel being hidden
	 * with the event auto_hidden_panel_hidden.
	 *
	 * The compositor will restore the visibility state of the surface
	 * when the pointer touches the screen edge the panel borders. Once
	 * the compositor restores the visibility the event
	 * auto_hidden_panel_shown will be sent. This event will also be
	 * sent if the compositor is unable to hide the panel.
	 *
	 * The client can also request to show the panel again with the
	 * request panel_auto_hide_show.
	 * @since 4
	 */
	void (*panel_auto_hide_hide)(struct wl_client *client,
				     struct wl_resource *resource);
	/**
	 * Show the auto-hiding panel
	 *
	 * A panel surface with panel_behavior auto_hide can perform this
	 * request to show the panel again which got hidden with
	 * panel_auto_hide_hide.
	 * @since 4
	 */
	void (*panel_auto_hide_show)(struct wl_client *client,
				     struct wl_resource *resource);
	/**
	 * Whether a panel takes focus
	 *
	 * By default various org_kde_plasma_surface roles do not take
	 * focus and cannot be activated. With this request the compositor
	 * can be instructed to pass focus also to this
	 * org_kde_plasma_surface.
	 * @param takes_focus Boolean value that sets whether the panel takes focus
	 * @since 4
	 */
	void (*set_panel_takes_focus)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t takes_focus);
	/**
	 * make the window not appear in a switcher
	 *
	 * Setting this bit will indicate that the window prefers not to
	 * be listed in a switcher.
	 * @param skip Boolean value that sets whether to skip the window switcher.
	 * @since 5
	 */
	void (*set_skip_switcher)(struct wl_client *client,
				  struct wl_resource *resource,
				  uint32_t skip);
	/**
	 * open under cursor
	 *
	 * Request the initial position of this surface to be under the
	 * current cursor position. Has to be called before attaching any
	 * buffer to this surface.
	 * @since 7
	 */
	void (*open_under_cursor)(struct wl_client *client,
				  struct wl_resource *resource);
};

#define ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_HIDDEN 0
#define ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_SHOWN 1

/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_HIDDEN_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_SHOWN_SINCE_VERSION 4

/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_ROLE_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_PANEL_BEHAVIOR_SINCE_VERSION 1
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_SKIP_TASKBAR_SINCE_VERSION 2
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_HIDE_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_PANEL_AUTO_HIDE_SHOW_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_PANEL_TAKES_FOCUS_SINCE_VERSION 4
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_SET_SKIP_SWITCHER_SINCE_VERSION 5
/**
 * @ingroup iface_org_kde_plasma_surface
 */
#define ORG_KDE_PLASMA_SURFACE_OPEN_UNDER_CURSOR_SINCE_VERSION 7

/**
 * @ingroup iface_org_kde_plasma_surface
 * Sends an auto_hidden_panel_hidden event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_surface_send_auto_hidden_panel_hidden(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_HIDDEN);
}

/**
 * @ingroup iface_org_kde_plasma_surface
 * Sends an auto_hidden_panel_shown event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
org_kde_plasma_surface_send_auto_hidden_panel_shown(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, ORG_KDE_PLASMA_SURFACE_AUTO_HIDDEN_PANEL_SHOWN);
}

#ifdef  __cplusplus
}
#endif

#endif
