/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.CancelSmResp;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.QuerySmResp;
import org.jsmpp.bean.ReplaceSmResp;
import org.jsmpp.bean.SubmitMultiResp;
import org.jsmpp.bean.SubmitSmResp;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.state.SMPPSessionBound;
import org.jsmpp.session.state.SMPPSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPSessionBoundTX
extends SMPPSessionBound
implements SMPPSessionState {
    private static final String NO_REQUEST_FIND_FOR_SEQUENCE_NUMBER = "No request found for sequence_number ";
    private static final Logger logger = LoggerFactory.getLogger(SMPPSessionBoundTX.class);

    SMPPSessionBoundTX() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.BOUND_TX;
    }

    @Override
    public void processSubmitSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                SubmitSmResp resp = pduDecomposer.submitSmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                logger.error("Failed decomposing submit_sm_resp", (Throwable)e);
                responseHandler.sendGenerickNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            logger.warn("No request with sequence_number " + pduHeader.getSequenceNumber() + " found");
        }
    }

    @Override
    public void processSubmitMultiResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                SubmitMultiResp resp = pduDecomposer.submitMultiResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                logger.error("Failed decomposing submit_multi_resp", (Throwable)e);
                responseHandler.sendGenerickNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            logger.warn("No request with sequence_number " + pduHeader.getSequenceNumber() + " found");
        }
    }

    @Override
    public void processQuerySmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                QuerySmResp resp = pduDecomposer.querySmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                logger.error("Failed decomposing submit_sm_resp", (Throwable)e);
                responseHandler.sendGenerickNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            logger.error(NO_REQUEST_FIND_FOR_SEQUENCE_NUMBER + pduHeader.getSequenceNumber());
            responseHandler.sendGenerickNack(99, pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processCancelSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            CancelSmResp resp = pduDecomposer.cancelSmResp(pdu);
            pendingResp.done(resp);
        } else {
            logger.error(NO_REQUEST_FIND_FOR_SEQUENCE_NUMBER + pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processReplaceSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            ReplaceSmResp resp = pduDecomposer.replaceSmResp(pdu);
            pendingResp.done(resp);
        } else {
            logger.error(NO_REQUEST_FIND_FOR_SEQUENCE_NUMBER + pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processDeliverSm(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    @Override
    public void processAlertNotification(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) {
        logger.error("Receiving alert_notification while on invalid bound state (transmitter)");
    }
}

