/*++

Copyright (C) 2024 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.8.0-alpha.

Abstract: This is an autogenerated C++ Header file for the Node wrapper class 
 of the 3MF Library

Interface version: 2.4.1

*/


#ifndef LIB3MF_NODEWRAPPER_H
#define LIB3MF_NODEWRAPPER_H

#include "lib3mf_dynamic.h"
#include <node.h>
#include <node_object_wrap.h>
#include <string>
#include <stdexcept>

#define NODEWRAPPER_FIELDCOUNT 4
#define NODEWRAPPER_TABLEINDEX 2
#define NODEWRAPPER_HANDLEINDEX 3
/*************************************************************************************************************************
 Forward declarations 
**************************************************************************************************************************/

class CLib3MFWrapper;

/*************************************************************************************************************************
 Class CLib3MFBaseClass 
**************************************************************************************************************************/

class CLib3MFBaseClass : public node::ObjectWrap {
private:
protected:
public:
	CLib3MFBaseClass();
	static void RaiseError(v8::Isolate * isolate, std::string Message);
	static void CheckError(v8::Isolate * isolate, sLib3MFDynamicWrapperTable * sWrapperTable, Lib3MFHandle pInstance, Lib3MFResult errorCode);
	static void setHandle(Lib3MFHandle pHandle);
	static Lib3MFHandle getHandle(v8::Local<v8::Object> objecthandle);
	static sLib3MFDynamicWrapperTable * getDynamicWrapperTable(v8::Local<v8::Object> objecthandle);
};


/*************************************************************************************************************************
 Class CLib3MFBase 
**************************************************************************************************************************/
class CLib3MFBase : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void ClassTypeId(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBase();
	~CLib3MFBase();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFWriter 
**************************************************************************************************************************/
class CLib3MFWriter : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void WriteToFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStreamSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetProgressCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDecimalPrecision(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetDecimalPrecision(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarning(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarningCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddKeyWrappingCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetContentEncryptionCallback(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFWriter();
	~CLib3MFWriter();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFReader 
**************************************************************************************************************************/
class CLib3MFReader : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void ReadFromFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetProgressCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddRelationToRead(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveRelationToRead(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStrictModeActive(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarning(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWarningCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddKeyWrappingCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetContentEncryptionCallback(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFReader();
	~CLib3MFReader();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFPackagePart 
**************************************************************************************************************************/
class CLib3MFPackagePart : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPath(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFPackagePart();
	~CLib3MFPackagePart();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResource 
**************************************************************************************************************************/
class CLib3MFResource : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUniqueResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void PackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetModelResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResource();
	~CLib3MFResource();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResourceIterator 
**************************************************************************************************************************/
class CLib3MFResourceIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void MoveNext(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MovePrevious(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCurrent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Clone(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Count(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResourceIterator();
	~CLib3MFResourceIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSliceStackIterator 
**************************************************************************************************************************/
class CLib3MFSliceStackIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFSliceStackIterator();
	~CLib3MFSliceStackIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFObjectIterator 
**************************************************************************************************************************/
class CLib3MFObjectIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentObject(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFObjectIterator();
	~CLib3MFObjectIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMeshObjectIterator 
**************************************************************************************************************************/
class CLib3MFMeshObjectIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentMeshObject(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMeshObjectIterator();
	~CLib3MFMeshObjectIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComponentsObjectIterator 
**************************************************************************************************************************/
class CLib3MFComponentsObjectIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentComponentsObject(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComponentsObjectIterator();
	~CLib3MFComponentsObjectIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2DIterator 
**************************************************************************************************************************/
class CLib3MFTexture2DIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentTexture2D(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2DIterator();
	~CLib3MFTexture2DIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroupIterator 
**************************************************************************************************************************/
class CLib3MFBaseMaterialGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBaseMaterialGroupIterator();
	~CLib3MFBaseMaterialGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFColorGroupIterator 
**************************************************************************************************************************/
class CLib3MFColorGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentColorGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFColorGroupIterator();
	~CLib3MFColorGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroupIterator 
**************************************************************************************************************************/
class CLib3MFTexture2DGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentTexture2DGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2DGroupIterator();
	~CLib3MFTexture2DGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterialsIterator 
**************************************************************************************************************************/
class CLib3MFCompositeMaterialsIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentCompositeMaterials(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFCompositeMaterialsIterator();
	~CLib3MFCompositeMaterialsIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroupIterator 
**************************************************************************************************************************/
class CLib3MFMultiPropertyGroupIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentMultiPropertyGroup(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMultiPropertyGroupIterator();
	~CLib3MFMultiPropertyGroupIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFImage3DIterator 
**************************************************************************************************************************/
class CLib3MFImage3DIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentImage3D(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFImage3DIterator();
	~CLib3MFImage3DIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFunctionIterator 
**************************************************************************************************************************/
class CLib3MFFunctionIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentFunction(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFFunctionIterator();
	~CLib3MFFunctionIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFLevelSetIterator 
**************************************************************************************************************************/
class CLib3MFLevelSetIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrentLevelSet(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFLevelSetIterator();
	~CLib3MFLevelSetIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMetaData 
**************************************************************************************************************************/
class CLib3MFMetaData : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetNameSpace(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetNameSpace(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKey(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMustPreserve(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMustPreserve(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetValue(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetValue(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMetaData();
	~CLib3MFMetaData();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMetaDataGroup 
**************************************************************************************************************************/
class CLib3MFMetaDataGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetMetaDataCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataByKey(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMetaDataByIndex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMetaData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMetaData(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMetaDataGroup();
	~CLib3MFMetaDataGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTriangleSet 
**************************************************************************************************************************/
class CLib3MFTriangleSet : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Clear(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTriangleList(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleList(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTriangleList(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Merge(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void DeleteSet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Duplicate(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTriangleSet();
	~CLib3MFTriangleSet();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFObject 
**************************************************************************************************************************/
class CLib3MFObject : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsMeshObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsComponentsObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsLevelSetObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsValid(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAttachmentAsThumbnail(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ClearThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutbox(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetSlicesMeshResolution(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSlicesMeshResolution(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasSlices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ClearSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AssignSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFObject();
	~CLib3MFObject();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMeshObject 
**************************************************************************************************************************/
class CLib3MFMeshObject : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetVertexCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetVertex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddVertex(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTriangle(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleIndices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetObjectLevelProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectLevelProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAllTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllTriangleProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ClearAllProperties(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetGeometry(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsManifoldAndOriented(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void BeamLattice(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVolumeData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetVolumeData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTriangleSet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasTriangleSet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindTriangleSet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleSetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTriangleSet(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMeshObject();
	~CLib3MFMeshObject();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFLevelSet 
**************************************************************************************************************************/
class CLib3MFLevelSet : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetFunction(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetFunction(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetChannelName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetChannelName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMinFeatureSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMinFeatureSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetFallBackValue(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetFallBackValue(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMeshBBoxOnly(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMeshBBoxOnly(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMesh(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMesh(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVolumeData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetVolumeData(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFLevelSet();
	~CLib3MFLevelSet();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBeamLattice 
**************************************************************************************************************************/
class CLib3MFBeamLattice : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetMinLength(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMinLength(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetClipping(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetClipping(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetRepresentation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetRepresentation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallOptions(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBallOptions(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeamCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeam(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBeam(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBeam(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBeams(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeams(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBall(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBall(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBall(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBalls(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBalls(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeamSetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBeamSet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBeamSet(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBeamLattice();
	~CLib3MFBeamLattice();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFunctionReference 
**************************************************************************************************************************/
class CLib3MFFunctionReference : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetFunctionResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetFunctionResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetChannelName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetChannelName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMinFeatureSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMinFeatureSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetFallBackValue(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetFallBackValue(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFFunctionReference();
	~CLib3MFFunctionReference();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFVolumeDataColor 
**************************************************************************************************************************/
class CLib3MFVolumeDataColor : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFVolumeDataColor();
	~CLib3MFVolumeDataColor();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMaterialMapping 
**************************************************************************************************************************/
class CLib3MFMaterialMapping : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFMaterialMapping();
	~CLib3MFMaterialMapping();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFVolumeDataComposite 
**************************************************************************************************************************/
class CLib3MFVolumeDataComposite : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMaterialMappingCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMaterialMapping(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMaterialMapping(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMaterialMapping(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFVolumeDataComposite();
	~CLib3MFVolumeDataComposite();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFVolumeDataProperty 
**************************************************************************************************************************/
class CLib3MFVolumeDataProperty : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetIsRequired(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsRequired(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFVolumeDataProperty();
	~CLib3MFVolumeDataProperty();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFVolumeData 
**************************************************************************************************************************/
class CLib3MFVolumeData : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetComposite(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreateNewComposite(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveComposite(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreateNewColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPropertyCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddPropertyFromFunction(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveProperty(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFVolumeData();
	~CLib3MFVolumeData();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComponent 
**************************************************************************************************************************/
class CLib3MFComponent : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetObjectResource(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTransform(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComponent();
	~CLib3MFComponent();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComponentsObject 
**************************************************************************************************************************/
class CLib3MFComponentsObject : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void AddComponent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponentCount(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComponentsObject();
	~CLib3MFComponentsObject();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBeamSet 
**************************************************************************************************************************/
class CLib3MFBeamSet : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetReferenceCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallReferenceCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBallReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBallReferences(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBeamSet();
	~CLib3MFBeamSet();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBaseMaterialGroup 
**************************************************************************************************************************/
class CLib3MFBaseMaterialGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMaterial(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMaterial(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetDisplayColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDisplayColor(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBaseMaterialGroup();
	~CLib3MFBaseMaterialGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFColorGroup 
**************************************************************************************************************************/
class CLib3MFColorGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColor(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFColorGroup();
	~CLib3MFColorGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2DGroup 
**************************************************************************************************************************/
class CLib3MFTexture2DGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTex2Coord(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTex2Coord(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveTex2Coord(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2D(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2DGroup();
	~CLib3MFTexture2DGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCompositeMaterials 
**************************************************************************************************************************/
class CLib3MFCompositeMaterials : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddComposite(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveComposite(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComposite(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFCompositeMaterials();
	~CLib3MFCompositeMaterials();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMultiPropertyGroup 
**************************************************************************************************************************/
class CLib3MFMultiPropertyGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAllPropertyIDs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveMultiProperty(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLayerCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLayer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLayer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveLayer(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMultiPropertyGroup();
	~CLib3MFMultiPropertyGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFImage3D 
**************************************************************************************************************************/
class CLib3MFImage3D : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void IsImageStack(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFImage3D();
	~CLib3MFImage3D();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFImageStack 
**************************************************************************************************************************/
class CLib3MFImageStack : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetRowCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetRowCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColumnCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetColumnCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSheetCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSheet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetSheet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreateEmptySheet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreateSheetFromBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreateSheetFromFile(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFImageStack();
	~CLib3MFImageStack();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFAttachment 
**************************************************************************************************************************/
class CLib3MFAttachment : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void PackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetRelationShipType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetRelationShipType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromFile(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetStreamSize(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void WriteToBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ReadFromBuffer(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFAttachment();
	~CLib3MFAttachment();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTexture2D 
**************************************************************************************************************************/
class CLib3MFTexture2D : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTileStyleUV(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTileStyleUV(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetFilter(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetFilter(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTexture2D();
	~CLib3MFTexture2D();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFImplicitPort 
**************************************************************************************************************************/
class CLib3MFImplicitPort : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDisplayName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetDisplayName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetReference(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetReference(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFImplicitPort();
	~CLib3MFImplicitPort();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFIterator 
**************************************************************************************************************************/
class CLib3MFIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void MoveNext(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MovePrevious(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Count(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFIterator();
	~CLib3MFIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFImplicitPortIterator 
**************************************************************************************************************************/
class CLib3MFImplicitPortIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrent(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFImplicitPortIterator();
	~CLib3MFImplicitPortIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFImplicitNode 
**************************************************************************************************************************/
class CLib3MFImplicitNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDisplayName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetDisplayName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTag(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTag(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetNodeType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddInput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddOutput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindInput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindOutput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AreTypesValid(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFImplicitNode();
	~CLib3MFImplicitNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFOneInputNode 
**************************************************************************************************************************/
class CLib3MFOneInputNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputResult(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFOneInputNode();
	~CLib3MFOneInputNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSinNode 
**************************************************************************************************************************/
class CLib3MFSinNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFSinNode();
	~CLib3MFSinNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCosNode 
**************************************************************************************************************************/
class CLib3MFCosNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFCosNode();
	~CLib3MFCosNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTanNode 
**************************************************************************************************************************/
class CLib3MFTanNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFTanNode();
	~CLib3MFTanNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFArcSinNode 
**************************************************************************************************************************/
class CLib3MFArcSinNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFArcSinNode();
	~CLib3MFArcSinNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFArcCosNode 
**************************************************************************************************************************/
class CLib3MFArcCosNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFArcCosNode();
	~CLib3MFArcCosNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFArcTanNode 
**************************************************************************************************************************/
class CLib3MFArcTanNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFArcTanNode();
	~CLib3MFArcTanNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSinhNode 
**************************************************************************************************************************/
class CLib3MFSinhNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFSinhNode();
	~CLib3MFSinhNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCoshNode 
**************************************************************************************************************************/
class CLib3MFCoshNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFCoshNode();
	~CLib3MFCoshNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTanhNode 
**************************************************************************************************************************/
class CLib3MFTanhNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFTanhNode();
	~CLib3MFTanhNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFRoundNode 
**************************************************************************************************************************/
class CLib3MFRoundNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFRoundNode();
	~CLib3MFRoundNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCeilNode 
**************************************************************************************************************************/
class CLib3MFCeilNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFCeilNode();
	~CLib3MFCeilNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFloorNode 
**************************************************************************************************************************/
class CLib3MFFloorNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFFloorNode();
	~CLib3MFFloorNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSignNode 
**************************************************************************************************************************/
class CLib3MFSignNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFSignNode();
	~CLib3MFSignNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFractNode 
**************************************************************************************************************************/
class CLib3MFFractNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFFractNode();
	~CLib3MFFractNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFAbsNode 
**************************************************************************************************************************/
class CLib3MFAbsNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFAbsNode();
	~CLib3MFAbsNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFExpNode 
**************************************************************************************************************************/
class CLib3MFExpNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFExpNode();
	~CLib3MFExpNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFLogNode 
**************************************************************************************************************************/
class CLib3MFLogNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFLogNode();
	~CLib3MFLogNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFLog2Node 
**************************************************************************************************************************/
class CLib3MFLog2Node : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFLog2Node();
	~CLib3MFLog2Node();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFLog10Node 
**************************************************************************************************************************/
class CLib3MFLog10Node : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFLog10Node();
	~CLib3MFLog10Node();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFLengthNode 
**************************************************************************************************************************/
class CLib3MFLengthNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFLengthNode();
	~CLib3MFLengthNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTransposeNode 
**************************************************************************************************************************/
class CLib3MFTransposeNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFTransposeNode();
	~CLib3MFTransposeNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFInverseNode 
**************************************************************************************************************************/
class CLib3MFInverseNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFInverseNode();
	~CLib3MFInverseNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSqrtNode 
**************************************************************************************************************************/
class CLib3MFSqrtNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFSqrtNode();
	~CLib3MFSqrtNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResourceIdNode 
**************************************************************************************************************************/
class CLib3MFResourceIdNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetResource(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResource(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputValue(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResourceIdNode();
	~CLib3MFResourceIdNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFTwoInputNode 
**************************************************************************************************************************/
class CLib3MFTwoInputNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputB(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFTwoInputNode();
	~CLib3MFTwoInputNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFAdditionNode 
**************************************************************************************************************************/
class CLib3MFAdditionNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFAdditionNode();
	~CLib3MFAdditionNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSubtractionNode 
**************************************************************************************************************************/
class CLib3MFSubtractionNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFSubtractionNode();
	~CLib3MFSubtractionNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMultiplicationNode 
**************************************************************************************************************************/
class CLib3MFMultiplicationNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFMultiplicationNode();
	~CLib3MFMultiplicationNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFDivisionNode 
**************************************************************************************************************************/
class CLib3MFDivisionNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFDivisionNode();
	~CLib3MFDivisionNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFDotNode 
**************************************************************************************************************************/
class CLib3MFDotNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFDotNode();
	~CLib3MFDotNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFCrossNode 
**************************************************************************************************************************/
class CLib3MFCrossNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFCrossNode();
	~CLib3MFCrossNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFArcTan2Node 
**************************************************************************************************************************/
class CLib3MFArcTan2Node : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFArcTan2Node();
	~CLib3MFArcTan2Node();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMatVecMultiplicationNode 
**************************************************************************************************************************/
class CLib3MFMatVecMultiplicationNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFMatVecMultiplicationNode();
	~CLib3MFMatVecMultiplicationNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMinNode 
**************************************************************************************************************************/
class CLib3MFMinNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFMinNode();
	~CLib3MFMinNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMaxNode 
**************************************************************************************************************************/
class CLib3MFMaxNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFMaxNode();
	~CLib3MFMaxNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFmodNode 
**************************************************************************************************************************/
class CLib3MFFmodNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFFmodNode();
	~CLib3MFFmodNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFModNode 
**************************************************************************************************************************/
class CLib3MFModNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFModNode();
	~CLib3MFModNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFPowNode 
**************************************************************************************************************************/
class CLib3MFPowNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFPowNode();
	~CLib3MFPowNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSelectNode 
**************************************************************************************************************************/
class CLib3MFSelectNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputB(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputC(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputD(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFSelectNode();
	~CLib3MFSelectNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFClampNode 
**************************************************************************************************************************/
class CLib3MFClampNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputMin(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputMax(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFClampNode();
	~CLib3MFClampNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComposeVectorNode 
**************************************************************************************************************************/
class CLib3MFComposeVectorNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputX(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputY(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputZ(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputResult(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComposeVectorNode();
	~CLib3MFComposeVectorNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFVectorFromScalarNode 
**************************************************************************************************************************/
class CLib3MFVectorFromScalarNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;

public:
	CLib3MFVectorFromScalarNode();
	~CLib3MFVectorFromScalarNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFDecomposeVectorNode 
**************************************************************************************************************************/
class CLib3MFDecomposeVectorNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputX(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputY(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputZ(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFDecomposeVectorNode();
	~CLib3MFDecomposeVectorNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFComposeMatrixNode 
**************************************************************************************************************************/
class CLib3MFComposeMatrixNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputM00(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM01(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM02(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM03(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM10(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM11(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM12(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM13(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM20(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM21(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM22(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM23(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM30(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM31(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM32(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputM33(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputResult(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFComposeMatrixNode();
	~CLib3MFComposeMatrixNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMatrixFromRowsNode 
**************************************************************************************************************************/
class CLib3MFMatrixFromRowsNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputB(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputC(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputD(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputResult(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMatrixFromRowsNode();
	~CLib3MFMatrixFromRowsNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMatrixFromColumnsNode 
**************************************************************************************************************************/
class CLib3MFMatrixFromColumnsNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputB(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputC(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputD(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputResult(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMatrixFromColumnsNode();
	~CLib3MFMatrixFromColumnsNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFConstantNode 
**************************************************************************************************************************/
class CLib3MFConstantNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetConstant(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetConstant(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputValue(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFConstantNode();
	~CLib3MFConstantNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFConstVecNode 
**************************************************************************************************************************/
class CLib3MFConstVecNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetVector(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVector(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputVector(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFConstVecNode();
	~CLib3MFConstVecNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFConstMatNode 
**************************************************************************************************************************/
class CLib3MFConstMatNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetMatrix(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMatrix(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputMatrix(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFConstMatNode();
	~CLib3MFConstMatNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFMeshNode 
**************************************************************************************************************************/
class CLib3MFMeshNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputMesh(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputPos(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputDistance(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFMeshNode();
	~CLib3MFMeshNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFUnsignedMeshNode 
**************************************************************************************************************************/
class CLib3MFUnsignedMeshNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputMesh(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputPos(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputDistance(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFUnsignedMeshNode();
	~CLib3MFUnsignedMeshNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFunctionCallNode 
**************************************************************************************************************************/
class CLib3MFFunctionCallNode : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetInputFunctionID(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFFunctionCallNode();
	~CLib3MFFunctionCallNode();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFNodeIterator 
**************************************************************************************************************************/
class CLib3MFNodeIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetCurrent(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFNodeIterator();
	~CLib3MFNodeIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFunction 
**************************************************************************************************************************/
class CLib3MFFunction : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetDisplayName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetDisplayName(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddInput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInputs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveInput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddOutput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutputs(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveOutput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindInput(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindOutput(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFFunction();
	~CLib3MFFunction();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFImplicitFunction 
**************************************************************************************************************************/
class CLib3MFImplicitFunction : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetIdentifier(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSinNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCosNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTanNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddArcSinNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddArcCosNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddArcTan2Node(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSinhNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCoshNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTanhNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddRoundNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCeilNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddFloorNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSignNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddFractNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddAbsNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddExpNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLogNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLog2Node(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLog10Node(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLengthNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTransposeNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddInverseNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSqrtNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddResourceIdNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddAdditionNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSubtractionNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMultiplicationNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddDivisionNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddDotNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCrossNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMatVecMultiplicationNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMinNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMaxNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddFmodNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddPowNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSelectNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddClampNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddComposeVectorNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddVectorFromScalarNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddDecomposeVectorNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddComposeMatrixNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMatrixFromRowsNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMatrixFromColumnsNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddConstantNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddConstVecNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddConstMatNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMeshNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddUnsignedMeshNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddFunctionCallNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetNodes(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveNode(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLink(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLinkByNames(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Clear(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SortNodesTopologically(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFImplicitFunction();
	~CLib3MFImplicitFunction();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFFunctionFromImage3D 
**************************************************************************************************************************/
class CLib3MFFunctionFromImage3D : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetImage3D(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetImage3D(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetFilter(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetFilter(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetTileStyles(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTileStyles(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOffset(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetOffset(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetScale(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetScale(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFFunctionFromImage3D();
	~CLib3MFFunctionFromImage3D();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBuildItem 
**************************************************************************************************************************/
class CLib3MFBuildItem : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetObjectResource(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectResourceID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasObjectTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjectTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetObjectTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPartNumber(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutbox(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBuildItem();
	~CLib3MFBuildItem();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFBuildItemIterator 
**************************************************************************************************************************/
class CLib3MFBuildItemIterator : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void MoveNext(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MovePrevious(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCurrent(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Clone(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Count(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFBuildItemIterator();
	~CLib3MFBuildItemIterator();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSlice 
**************************************************************************************************************************/
class CLib3MFSlice : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void SetVertices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetVertexCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddPolygon(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPolygonCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetPolygonIndices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPolygonIndices(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPolygonIndexCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetZTop(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFSlice();
	~CLib3MFSlice();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFSliceStack 
**************************************************************************************************************************/
class CLib3MFSliceStack : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetBottomZ(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSlice(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSlice(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceRefCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSliceStackReference(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStackReference(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CollapseSliceReferences(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetOwnPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOwnPath(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFSliceStack();
	~CLib3MFSliceStack();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFConsumer 
**************************************************************************************************************************/
class CLib3MFConsumer : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetConsumerID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyValue(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFConsumer();
	~CLib3MFConsumer();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFAccessRight 
**************************************************************************************************************************/
class CLib3MFAccessRight : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetWrappingAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMgfAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDigestMethod(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFAccessRight();
	~CLib3MFAccessRight();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFContentEncryptionParams 
**************************************************************************************************************************/
class CLib3MFContentEncryptionParams : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetEncryptionAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKey(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetInitializationVector(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAuthenticationTag(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetAuthenticationTag(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAdditionalAuthenticationData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetDescriptor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyUUID(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFContentEncryptionParams();
	~CLib3MFContentEncryptionParams();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResourceData 
**************************************************************************************************************************/
class CLib3MFResourceData : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetPath(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetEncryptionAlgorithm(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCompression(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAdditionalAuthenticationData(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResourceData();
	~CLib3MFResourceData();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFResourceDataGroup 
**************************************************************************************************************************/
class CLib3MFResourceDataGroup : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetKeyUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddAccessRight(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindAccessRightByConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveAccessRight(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFResourceDataGroup();
	~CLib3MFResourceDataGroup();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFKeyStore 
**************************************************************************************************************************/
class CLib3MFKeyStore : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void AddConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetConsumerCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindConsumer(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceDataGroupCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindResourceDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceDataCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUUID(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFKeyStore();
	~CLib3MFKeyStore();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFModel 
**************************************************************************************************************************/
class CLib3MFModel : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void RootModelPart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindOrCreatePackagePart(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetUnit(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUnit(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLanguage(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetLanguage(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void QueryWriter(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void QueryReader(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResourceByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2DByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPropertyTypeByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBaseMaterialGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2DGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCompositeMaterialsByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMultiPropertyGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMeshObjectByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponentsObjectByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColorGroupByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStackByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLevelSetByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBuildUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetBuildUUID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBuildItems(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetOutbox(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetResources(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetObjects(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMeshObjects(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetComponentsObjects(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2Ds(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBaseMaterialGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetColorGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTexture2DGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetCompositeMaterials(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMultiPropertyGroups(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSliceStacks(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetImage3Ds(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MergeToModel(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void MergeFromModel(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMeshObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddComponentsObject(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddSliceStack(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTexture2DFromAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBaseMaterialGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddColorGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddTexture2DGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCompositeMaterials(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddMultiPropertyGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddImageStack(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetImageStackByID(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddBuildItem(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveBuildItem(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetMetaDataGroup(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FindAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetAttachmentCount(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void HasPackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreatePackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemovePackageThumbnailAttachment(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddCustomContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveCustomContentType(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetRandomNumberCallback(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetKeyStore(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetFunctions(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddImplicitFunction(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddFunctionFromImage3D(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddVolumeData(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void AddLevelSet(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLevelSets(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RemoveResource(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFModel();
	~CLib3MFModel();
	
	static void Init();
	static v8::Local<v8::Object> NewInstance(v8::Local<v8::Object>, Lib3MFHandle pHandle);
	
};

/*************************************************************************************************************************
 Class CLib3MFWrapper 
**************************************************************************************************************************/

class CLib3MFWrapper : public CLib3MFBaseClass {
private:
	static void New(const v8::FunctionCallbackInfo<v8::Value>& args);
	static v8::Persistent<v8::Function> constructor;
	static void GetLibraryVersion(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetPrereleaseInformation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetBuildInformation(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSpecificationVersion(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void CreateModel(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Release(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void Acquire(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void SetJournal(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetLastError(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetSymbolLookupMethod(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RetrieveProgressMessage(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void RGBAToColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void FloatRGBAToColor(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ColorToRGBA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void ColorToFloatRGBA(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetIdentityTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetUniformScaleTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetScaleTransform(const v8::FunctionCallbackInfo<v8::Value>& args);
	static void GetTranslationTransform(const v8::FunctionCallbackInfo<v8::Value>& args);

public:
	CLib3MFWrapper();
	~CLib3MFWrapper();
	static void Init();
	static v8::Local<v8::Object> NewInstance(const v8::FunctionCallbackInfo<v8::Value>& args);
};

#endif // LIB3MF_NODEWRAPPER_H

