/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.CSSFontFace;
import io.sf.carte.echosvg.bridge.FontFace;
import io.sf.carte.echosvg.bridge.FontFamilyResolver;
import io.sf.carte.echosvg.gvt.font.AWTFontFamily;
import io.sf.carte.echosvg.gvt.font.AWTGVTFont;
import io.sf.carte.echosvg.gvt.font.GVTFontFace;
import io.sf.carte.echosvg.gvt.font.GVTFontFamily;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class DefaultFontFamilyResolver
implements FontFamilyResolver {
    public static final DefaultFontFamilyResolver SINGLETON;
    private static final AWTFontFamily DEFAULT_FONT_FAMILY;
    protected static final Map<String, String> fonts;
    protected static final List<AWTFontFamily> awtFontFamilies;
    protected static final List<AWTGVTFont> awtFonts;
    protected static final Map<String, GVTFontFamily> resolvedFontFamilies;

    private DefaultFontFamilyResolver() {
    }

    public static DefaultFontFamilyResolver getInstance() {
        return SINGLETON;
    }

    public void registerFont(Font font) {
        String fontName = font.getFontName();
        String lcFontName = fontName.toLowerCase();
        fonts.putIfAbsent(lcFontName, fontName);
        String fontFamily = font.getFamily();
        String lcFontFamily = fontFamily.toLowerCase();
        if (!fonts.containsKey(lcFontFamily)) {
            fonts.put(lcFontFamily, fontFamily);
            StringTokenizer st = new StringTokenizer(lcFontFamily);
            StringBuilder fontNameWithoutSpaces = new StringBuilder(lcFontFamily.length());
            while (st.hasMoreTokens()) {
                fontNameWithoutSpaces.append(st.nextToken());
            }
            if (fontNameWithoutSpaces.length() != lcFontFamily.length()) {
                fonts.put(fontNameWithoutSpaces.toString(), fontFamily);
                String fontNameWithDashes = lcFontFamily.replace(' ', '-');
                fonts.put(fontNameWithDashes, fontFamily);
            }
            AWTFontFamily awtFontFamily = new AWTFontFamily(fontFamily);
            awtFontFamilies.add(awtFontFamily);
            AWTGVTFont gvtFont = new AWTGVTFont(fontFamily, 0, 12);
            awtFonts.add(gvtFont);
        }
    }

    public AWTFontFamily resolve(String familyName, FontFace fontFace) {
        String fontName = fonts.get(fontFace.getFamilyName().toLowerCase());
        if (fontName == null) {
            return null;
        }
        CSSFontFace face = FontFace.createFontFace(fontName, fontFace);
        return new AWTFontFamily((GVTFontFace)face);
    }

    @Override
    public GVTFontFamily loadFont(InputStream in, FontFace ff) throws Exception {
        Font font = Font.createFont(0, in);
        return new AWTFontFamily((GVTFontFace)ff, font);
    }

    @Override
    public GVTFontFamily resolve(String familyName) {
        GVTFontFamily resolvedFF = resolvedFontFamilies.get(familyName = familyName.toLowerCase());
        if (resolvedFF == null) {
            String awtFamilyName = fonts.get(familyName);
            if (awtFamilyName != null) {
                resolvedFF = new AWTFontFamily(awtFamilyName);
            }
            resolvedFontFamilies.put(familyName, resolvedFF);
        }
        return resolvedFF;
    }

    @Override
    public GVTFontFamily getFamilyThatCanDisplay(char c) {
        for (int i = 0; i < awtFontFamilies.size(); ++i) {
            AWTFontFamily fontFamily = awtFontFamilies.get(i);
            AWTGVTFont font = awtFonts.get(i);
            if (!font.canDisplay(c) || fontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return fontFamily;
        }
        return null;
    }

    @Override
    public GVTFontFamily getDefault() {
        return DEFAULT_FONT_FAMILY;
    }

    static {
        Font[] allFonts;
        SINGLETON = new DefaultFontFamilyResolver();
        DEFAULT_FONT_FAMILY = new AWTFontFamily("SansSerif");
        fonts = new HashMap<String, String>();
        awtFontFamilies = new ArrayList<AWTFontFamily>();
        awtFonts = new ArrayList<AWTGVTFont>();
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] fontNames = env.getAvailableFontFamilyNames();
        int nFonts = fontNames != null ? fontNames.length : 0;
        for (int i = 0; i < nFonts; ++i) {
            Font[] lcFontName = fontNames[i].toLowerCase();
            fonts.put((String)lcFontName, fontNames[i]);
            StringTokenizer st = new StringTokenizer((String)lcFontName);
            StringBuilder fontNameWithoutSpaces = new StringBuilder(lcFontName.length());
            while (st.hasMoreTokens()) {
                fontNameWithoutSpaces.append(st.nextToken());
            }
            if (fontNameWithoutSpaces.length() == lcFontName.length()) continue;
            fonts.put(fontNameWithoutSpaces.toString(), fontNames[i]);
            String fontNameWithDashes = lcFontName.replace(' ', '-');
            fonts.put(fontNameWithDashes, fontNames[i]);
        }
        for (Font f : allFonts = env.getAllFonts()) {
            fonts.put(f.getFontName().toLowerCase(), f.getFontName());
        }
        awtFontFamilies.add(DEFAULT_FONT_FAMILY);
        awtFonts.add(new AWTGVTFont(DEFAULT_FONT_FAMILY.getFamilyName(), 0, 12));
        Collection<String> fontValues = fonts.values();
        for (String fontFamily : fontValues) {
            AWTFontFamily awtFontFamily = new AWTFontFamily(fontFamily);
            awtFontFamilies.add(awtFontFamily);
            AWTGVTFont font = new AWTGVTFont(fontFamily, 0, 12);
            awtFonts.add(font);
        }
        resolvedFontFamilies = new HashMap<String, GVTFontFamily>();
    }
}

