/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util;

import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLEventListenerState;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLRunnable;
import jogamp.opengl.Debug;

public class GLDrawableUtil {
    protected static final boolean DEBUG = Debug.debug("GLDrawable");
    private static final GLRunnable setViewport = new GLRunnable(){

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            gLAutoDrawable.getGL().glViewport(0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
            return false;
        }
    };

    public static final boolean isAnimatorStartedOnOtherThread(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isStarted() && gLAnimatorControl.getThread() != Thread.currentThread() : false;
    }

    public static final boolean isAnimatorStarted(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isStarted() : false;
    }

    public static final boolean isAnimatorAnimatingOnOtherThread(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isAnimating() && gLAnimatorControl.getThread() != Thread.currentThread() : false;
    }

    public static final boolean isAnimatorAnimating(GLAnimatorControl gLAnimatorControl) {
        return null != gLAnimatorControl ? gLAnimatorControl.isAnimating() : false;
    }

    public static final void moveGLEventListener(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2, GLEventListener gLEventListener, boolean bl) {
        boolean bl2 = gLAutoDrawable.getGLEventListenerInitState(gLEventListener);
        if (bl) {
            gLAutoDrawable.removeGLEventListener(gLEventListener);
            gLAutoDrawable2.addGLEventListener(gLEventListener);
            if (bl2) {
                gLAutoDrawable2.setGLEventListenerInitState(gLEventListener, true);
                gLAutoDrawable2.invoke(false, new ReshapeGLEventListener(gLEventListener, true));
            }
        } else {
            gLAutoDrawable.disposeGLEventListener(gLEventListener, true);
            gLAutoDrawable2.addGLEventListener(gLEventListener);
        }
    }

    public static final void moveAllGLEventListener(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2, boolean bl) {
        for (int i = gLAutoDrawable.getGLEventListenerCount(); 0 < i; --i) {
            GLEventListener gLEventListener = gLAutoDrawable.getGLEventListener(0);
            GLDrawableUtil.moveGLEventListener(gLAutoDrawable, gLAutoDrawable2, gLEventListener, bl);
        }
    }

    public static boolean isSwapGLContextSafe(GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesImmutable gLCapabilitiesImmutable2, GLCapabilitiesImmutable gLCapabilitiesImmutable3) {
        boolean bl;
        boolean bl2 = bl = gLCapabilitiesImmutable.getAccumAlphaBits() > 0 || gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0;
        return (!gLCapabilitiesImmutable2.isOnscreen() || gLCapabilitiesImmutable3.isOnscreen()) && (gLCapabilitiesImmutable2.isOnscreen() || !gLCapabilitiesImmutable3.isOnscreen()) || !gLCapabilitiesImmutable2.getSampleBuffers() && !gLCapabilitiesImmutable3.getSampleBuffers() && !gLCapabilitiesImmutable2.getStereo() && !gLCapabilitiesImmutable3.getStereo() && !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void swapGLContextAndAllGLEventListener(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2) {
        GLEventListenerState gLEventListenerState = GLEventListenerState.moveFrom(gLAutoDrawable, true);
        GLEventListenerState gLEventListenerState2 = GLEventListenerState.moveFrom(gLAutoDrawable2, true);
        Runnable runnable = gLEventListenerState.getUnlockSurfaceOp();
        Runnable runnable2 = gLEventListenerState2.getUnlockSurfaceOp();
        try {
            gLEventListenerState.moveTo(gLAutoDrawable2, runnable2);
            gLEventListenerState2.moveTo(gLAutoDrawable, runnable);
        }
        finally {
            runnable2.run();
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void swapGLContext(GLAutoDrawable gLAutoDrawable, GLAutoDrawable gLAutoDrawable2) {
        GLAnimatorControl gLAnimatorControl = gLAutoDrawable.getAnimator();
        GLAnimatorControl gLAnimatorControl2 = gLAutoDrawable2.getAnimator();
        boolean bl = GLDrawableUtil.isAnimatorAnimatingOnOtherThread(gLAnimatorControl) && gLAnimatorControl.pause();
        boolean bl2 = GLDrawableUtil.isAnimatorAnimatingOnOtherThread(gLAnimatorControl2) && gLAnimatorControl2.pause();
        RecursiveLock recursiveLock = gLAutoDrawable.getUpstreamLock();
        RecursiveLock recursiveLock2 = gLAutoDrawable2.getUpstreamLock();
        recursiveLock.lock();
        recursiveLock2.lock();
        try {
            boolean bl3;
            boolean bl4;
            NativeSurface nativeSurface = gLAutoDrawable.getNativeSurface();
            boolean bl5 = bl4 = 1 < nativeSurface.lockSurface();
            if (gLAutoDrawable.isRealized() && !bl4) {
                throw new GLException("Could not lock realized a surface " + gLAutoDrawable);
            }
            NativeSurface nativeSurface2 = gLAutoDrawable2.getNativeSurface();
            boolean bl6 = bl3 = 1 < nativeSurface2.lockSurface();
            if (gLAutoDrawable2.isRealized() && !bl3) {
                throw new GLException("Could not lock realized b surface " + gLAutoDrawable2);
            }
            try {
                int n;
                for (n = gLAutoDrawable.getGLEventListenerCount() - 1; 0 <= n; --n) {
                    gLAutoDrawable.disposeGLEventListener(gLAutoDrawable.getGLEventListener(n), false);
                }
                for (n = gLAutoDrawable2.getGLEventListenerCount() - 1; 0 <= n; --n) {
                    gLAutoDrawable2.disposeGLEventListener(gLAutoDrawable2.getGLEventListener(n), false);
                }
                gLAutoDrawable2.setContext(gLAutoDrawable.setContext(gLAutoDrawable2.getContext(), false), false);
            }
            finally {
                if (bl3) {
                    nativeSurface2.unlockSurface();
                }
                if (bl4) {
                    nativeSurface.unlockSurface();
                }
            }
        }
        finally {
            recursiveLock2.unlock();
            recursiveLock.unlock();
        }
        gLAutoDrawable.invoke(true, setViewport);
        gLAutoDrawable2.invoke(true, setViewport);
        if (bl) {
            gLAnimatorControl.resume();
        }
        if (bl2) {
            gLAnimatorControl2.resume();
        }
    }

    public static final boolean swapBuffersBeforeRead(GLCapabilitiesImmutable gLCapabilitiesImmutable) {
        return gLCapabilitiesImmutable.isFBO() && gLCapabilitiesImmutable.getSampleBuffers();
    }

    public static class ReshapeGLEventListener
    implements GLRunnable {
        private final GLEventListener listener;
        private final boolean displayAfterReshape;

        public ReshapeGLEventListener(GLEventListener gLEventListener, boolean bl) {
            this.listener = gLEventListener;
            this.displayAfterReshape = bl;
        }

        @Override
        public boolean run(GLAutoDrawable gLAutoDrawable) {
            this.listener.reshape(gLAutoDrawable, 0, 0, gLAutoDrawable.getSurfaceWidth(), gLAutoDrawable.getSurfaceHeight());
            if (this.displayAfterReshape) {
                this.listener.display(gLAutoDrawable);
            }
            return true;
        }
    }
}

