/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStyleSheetNode;
import io.sf.carte.echosvg.css.engine.StyleSheet;
import io.sf.carte.echosvg.dom.AbstractDocument;
import io.sf.carte.echosvg.dom.StyleSheetFactory;
import io.sf.carte.echosvg.dom.StyleSheetProcessingInstruction;
import io.sf.carte.echosvg.util.ParsedURL;
import java.util.HashMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class SVGStyleSheetProcessingInstruction
extends StyleSheetProcessingInstruction
implements CSSStyleSheetNode {
    private static final long serialVersionUID = 1L;
    protected StyleSheet styleSheet;

    protected SVGStyleSheetProcessingInstruction() {
    }

    public SVGStyleSheetProcessingInstruction(String data, AbstractDocument owner, StyleSheetFactory f) {
        super(data, owner, f);
    }

    public String getStyleSheetURI() {
        SVGOMDocument svgDoc = (SVGOMDocument)((Object)this.getOwnerDocument());
        ParsedURL url = svgDoc.getParsedURL();
        String href = (String)this.getPseudoAttributes().get("href");
        if (url != null) {
            return new ParsedURL(url, href).toString();
        }
        return href;
    }

    public StyleSheet getCSSStyleSheet() {
        HashMap attrs;
        String type;
        if (this.styleSheet == null && "text/css".equals(type = (String)(attrs = this.getPseudoAttributes()).get("type"))) {
            String title = (String)attrs.get("title");
            String media = (String)attrs.get("media");
            String href = (String)attrs.get("href");
            String alternate = (String)attrs.get("alternate");
            SVGOMDocument doc = (SVGOMDocument)((Object)this.getOwnerDocument());
            ParsedURL durl = doc.getParsedURL();
            ParsedURL burl = new ParsedURL(durl, href);
            CSSEngine e = doc.getCSSEngine();
            this.styleSheet = e.parseStyleSheet(burl, media);
            this.styleSheet.setAlternate("yes".equals(alternate));
            this.styleSheet.setTitle(title);
        }
        return this.styleSheet;
    }

    public void setData(String data) throws DOMException {
        super.setData(data);
        this.styleSheet = null;
    }

    protected Node newNode() {
        return new SVGStyleSheetProcessingInstruction();
    }
}

