/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.DOMInvalidAccessException;
import io.sf.carte.doc.DOMNotSupportedException;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSKeyframeRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSBudgetException;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.KeyframesRule;
import io.sf.carte.doc.style.css.om.PropertyCSSHandler;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class KeyframeRule
extends BaseCSSDeclarationRule
implements CSSKeyframeRule {
    private static final long serialVersionUID = 1L;
    private final KeyframesRule parentRule;
    private LexicalUnit keyframeSelector;
    private String keyText;

    public KeyframeRule(KeyframesRule parentRule) {
        super(parentRule.getParentStyleSheet(), (short)8, parentRule.getOrigin());
        this.parentRule = parentRule;
    }

    @Override
    public String getKeyText() {
        return this.keyText;
    }

    void setKeyframeSelector(LexicalUnit keyframeSelector) throws DOMException {
        this.keyframeSelector = keyframeSelector;
        this.keyText = KeyframesRule.keyframeSelector(keyframeSelector);
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(50 + this.getStyle().getLength() * 24);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder buffer = new StringBuilder(64);
        KeyframeRule.miniKeyframeSelector(buffer, this.keyframeSelector);
        buffer.append('{');
        buffer.append(this.getStyle().getMinifiedCssText());
        buffer.append('}');
        return buffer.toString();
    }

    private static String miniKeyframeSelector(StringBuilder buffer, LexicalUnit selunit) {
        KeyframeRule.appendMiniSelector(buffer, selunit);
        LexicalUnit lu = selunit.getNextLexicalUnit();
        while (lu != null) {
            LexicalUnit nextlu = lu.getNextLexicalUnit();
            buffer.append(',');
            KeyframeRule.appendMiniSelector(buffer, nextlu);
            lu = nextlu.getNextLexicalUnit();
        }
        return buffer.toString();
    }

    private static void appendMiniSelector(StringBuilder buffer, LexicalUnit selunit) {
        LexicalUnit.LexicalType type = selunit.getLexicalUnitType();
        if (type == LexicalUnit.LexicalType.IDENT || type == LexicalUnit.LexicalType.STRING) {
            buffer.append(selunit.getStringValue());
        } else if (type == LexicalUnit.LexicalType.PERCENTAGE) {
            float floatValue = selunit.getFloatValue();
            if (floatValue == 0.0f) {
                buffer.append('0');
                return;
            }
            if (floatValue % 1.0f != 0.0f) {
                buffer.append(String.format(Locale.ROOT, "%s", Float.valueOf(floatValue)));
            } else {
                buffer.append(String.format(Locale.ROOT, "%.0f", Float.valueOf(floatValue)));
            }
            buffer.append('%');
        } else if (type == LexicalUnit.LexicalType.INTEGER && selunit.getIntegerValue() == 0) {
            buffer.append('0');
        } else {
            buffer.append('?');
        }
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        context.startRule(wri, this.getPrecedingComments());
        wri.write((CharSequence)this.getKeyText());
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        context.startStyleDeclaration(wri);
        this.getStyle().writeCssText(wri, context);
        context.endCurrentContext(this);
        context.endStyleDeclaration(wri);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri, this.getTrailingComments());
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        MyKFHandler handler = new MyKFHandler();
        handler.setLexicalPropertyListener(this.getStyle());
        StringReader re = new StringReader("@keyframes x {" + cssText + "}");
        Parser parser = this.createSACParser();
        parser.setErrorHandler(handler);
        parser.setDocumentHandler(handler);
        this.clear();
        try {
            parser.parseRule(re);
        }
        catch (CSSParseException e) {
            throw new DOMSyntaxException(e);
        }
        catch (CSSBudgetException e) {
            throw new DOMNotSupportedException(e.getMessage(), e);
        }
        catch (CSSException e) {
            throw new DOMInvalidAccessException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            String href;
            String message = e.getMessage();
            AbstractCSSStyleSheet parentSS = this.getParentStyleSheet();
            if (parentSS != null && (href = parentSS.getHref()) != null) {
                message = "Error in stylesheet at " + href + ": " + message;
            }
            DOMException ex = new DOMException(11, message);
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
    }

    @Override
    public KeyframesRule getParentRule() {
        return this.parentRule;
    }

    @Override
    public AbstractCSSStyleSheet getParentStyleSheet() {
        return this.parentRule.getParentStyleSheet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.keyText == null ? 0 : this.keyText.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyframeRule other = (KeyframeRule)obj;
        return !(this.keyText == null ? other.keyText != null : !this.keyText.equals(other.keyText));
    }

    @Override
    public KeyframeRule clone(AbstractCSSStyleSheet parentSheet) {
        KeyframeRule rule = new KeyframeRule(this.getParentRule());
        rule.keyframeSelector = this.keyframeSelector;
        rule.keyText = this.keyText;
        String oldHrefContext = this.getParentStyleSheet().getHref();
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle(), oldHrefContext);
        return rule;
    }

    private class MyKFHandler
    extends PropertyCSSHandler
    implements CSSHandler {
        private MyKFHandler() {
        }

        @Override
        public void startKeyframe(LexicalUnit keyframeSelector) {
            KeyframeRule.this.setKeyframeSelector(keyframeSelector);
        }

        @Override
        public void endKeyframe() {
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            if (important) {
                CSSPropertyValueException ex = new CSSPropertyValueException("Important declarations in a keyframe rule are not valid");
                ex.setValueText(value.toString() + " !important");
                KeyframeRule.this.getStyleDeclarationErrorHandler().wrongValue(name, ex);
            } else {
                super.property(name, value, important);
            }
        }
    }
}

