/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.ArrayStringList;
import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.LinkedStringList;
import io.sf.carte.doc.StringList;
import io.sf.carte.doc.style.css.CSSFontFeatureValuesMap;
import io.sf.carte.doc.style.css.CSSFontFeatureValuesRule;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.CSSException;
import io.sf.carte.doc.style.css.nsac.CSSHandler;
import io.sf.carte.doc.style.css.nsac.CSSParseException;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.nsac.Locator;
import io.sf.carte.doc.style.css.nsac.ParserControl;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSRule;
import io.sf.carte.doc.style.css.om.CSSParentHandler;
import io.sf.carte.doc.style.css.parser.EmptyCSSHandler;
import io.sf.carte.doc.style.css.property.NumberValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.BufferSimpleWriter;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.w3c.dom.DOMException;

public class FontFeatureValuesRule
extends BaseCSSRule
implements CSSFontFeatureValuesRule {
    private static final long serialVersionUID = 1L;
    private String[] fontFamily = null;
    private CSSFontFeatureValuesMapImpl annotation = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl ornaments = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl stylistic = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl swash = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl characterVariant = new CSSFontFeatureValuesMapImpl();
    private CSSFontFeatureValuesMapImpl styleset = new CSSFontFeatureValuesMapImpl();
    private HashMap<String, CSSFontFeatureValuesMapImpl> mapmap = null;

    protected FontFeatureValuesRule(AbstractCSSStyleSheet parentSheet, int origin) {
        super(parentSheet, (short)14, origin);
    }

    @Override
    public String[] getFontFamily() {
        return this.fontFamily;
    }

    void setFontFamily(String[] fontFamily) {
        this.fontFamily = fontFamily;
    }

    @Override
    public CSSFontFeatureValuesMap getAnnotation() {
        return this.annotation;
    }

    @Override
    public CSSFontFeatureValuesMap getOrnaments() {
        return this.ornaments;
    }

    @Override
    public CSSFontFeatureValuesMap getStylistic() {
        return this.stylistic;
    }

    @Override
    public CSSFontFeatureValuesMap getSwash() {
        return this.swash;
    }

    @Override
    public CSSFontFeatureValuesMap getCharacterVariant() {
        return this.characterVariant;
    }

    @Override
    public CSSFontFeatureValuesMap getStyleset() {
        return this.styleset;
    }

    @Override
    public void enableMap(String featureValueName) {
        featureValueName = featureValueName.toLowerCase(Locale.ROOT);
        FontFeatureValuesRule.enableMap(featureValueName, this.mapmap);
    }

    private static void enableMap(String featureValueName, HashMap<String, CSSFontFeatureValuesMapImpl> mapmap) {
        if (!(featureValueName.equals("annotation") || featureValueName.equals("ornaments") || featureValueName.equals("stylistic") || featureValueName.equals("swash") || featureValueName.equals("character-variant") || featureValueName.equals("styleset"))) {
            if (mapmap == null) {
                mapmap = new HashMap();
            }
            mapmap.put(featureValueName, new CSSFontFeatureValuesMapImpl());
        }
    }

    @Override
    public CSSFontFeatureValuesMap getFeatureValuesMap(String featureValueName) {
        Object map = (featureValueName = featureValueName.toLowerCase(Locale.ROOT)).equals("annotation") ? this.annotation : (featureValueName.equals("ornaments") ? this.ornaments : (featureValueName.equals("stylistic") ? this.stylistic : (featureValueName.equals("swash") ? this.swash : (featureValueName.equals("character-variant") ? this.characterVariant : (featureValueName.equals("styleset") ? this.styleset : (this.mapmap == null ? null : (CSSFontFeatureValuesMap)this.mapmap.get(featureValueName)))))));
        return map;
    }

    @Override
    public String getCssText() {
        StyleFormattingContext context = this.getStyleFormattingContext();
        context.setParentContext(this.getParentRule());
        BufferSimpleWriter sw = new BufferSimpleWriter(256);
        try {
            this.writeCssText((SimpleWriter)sw, context);
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return sw.toString();
    }

    @Override
    public String getMinifiedCssText() {
        if (this.fontFamily == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder(128);
        buf.append("@font-feature-values ");
        buf.append(this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            buf.append(',').append(this.fontFamily[i]);
        }
        buf.append('{');
        if (!this.swash.isEmpty()) {
            buf.append("@swash{");
            this.appendMinifiedFeatureString(buf, this.swash);
            buf.append('}');
        }
        if (!this.annotation.isEmpty()) {
            buf.append("@annotation{");
            this.appendMinifiedFeatureString(buf, this.annotation);
            buf.append('}');
        }
        if (!this.ornaments.isEmpty()) {
            buf.append("@ornaments{");
            this.appendMinifiedFeatureString(buf, this.ornaments);
            buf.append('}');
        }
        if (!this.stylistic.isEmpty()) {
            buf.append("@stylistic{");
            this.appendMinifiedFeatureString(buf, this.stylistic);
            buf.append('}');
        }
        if (!this.styleset.isEmpty()) {
            buf.append("@styleset{");
            this.appendMinifiedFeatureString(buf, this.styleset);
            buf.append('}');
        }
        if (!this.characterVariant.isEmpty()) {
            buf.append("@character-variant{");
            this.appendMinifiedFeatureString(buf, this.characterVariant);
            buf.append('}');
        }
        if (this.mapmap != null) {
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> me : this.mapmap.entrySet()) {
                buf.append('@').append(me.getKey()).append('{');
                this.appendMinifiedFeatureString(buf, me.getValue());
                buf.append('}');
            }
        }
        buf.append('}');
        return buf.toString();
    }

    private void appendMinifiedFeatureString(StringBuilder buf, CSSFontFeatureValuesMapImpl featureMap) {
        int szm1 = featureMap.featureMap.size() - 1;
        String[] names = featureMap.featureMap.keySet().toArray(new String[0]);
        for (int i = 0; i <= szm1; ++i) {
            String name = names[i];
            buf.append(name).append(':');
            PrimitiveValue[] values = (PrimitiveValue[])featureMap.featureMap.get(name);
            buf.append(values[0].getMinifiedCssText(name));
            for (int j = 1; j < values.length; ++j) {
                buf.append(' ').append(values[j].getMinifiedCssText(name));
            }
            if (i == szm1) continue;
            buf.append(';');
        }
    }

    @Override
    public void writeCssText(SimpleWriter wri, StyleFormattingContext context) throws IOException {
        if (this.fontFamily == null) {
            return;
        }
        context.startRule(wri, this.getPrecedingComments());
        wri.write((CharSequence)"@font-feature-values ");
        FontFeatureValuesRule.writeFontFamily(wri, this.fontFamily[0]);
        for (int i = 1; i < this.fontFamily.length; ++i) {
            context.writeComma(wri);
            FontFeatureValuesRule.writeFontFamily(wri, this.fontFamily[i]);
        }
        context.updateContext(this);
        context.writeLeftCurlyBracket(wri);
        this.writeFeatureBlock(wri, context, "@swash", this.swash);
        this.writeFeatureBlock(wri, context, "@annotation", this.annotation);
        this.writeFeatureBlock(wri, context, "@ornaments", this.ornaments);
        this.writeFeatureBlock(wri, context, "@stylistic", this.stylistic);
        this.writeFeatureBlock(wri, context, "@styleset", this.styleset);
        this.writeFeatureBlock(wri, context, "@character-variant", this.characterVariant);
        if (this.mapmap != null) {
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> me : this.mapmap.entrySet()) {
                CSSFontFeatureValuesMapImpl ffvmap = me.getValue();
                context.startRule(wri, ffvmap.precedingComments);
                wri.write('@');
                wri.write((CharSequence)me.getKey());
                context.writeLeftCurlyBracket(wri);
                this.appendFeatureString(wri, context, ffvmap);
                context.writeRightCurlyBracket(wri);
                context.endRule(wri, ffvmap.trailingComments);
            }
        }
        context.endCurrentContext(this);
        context.writeRightCurlyBracket(wri);
        context.endRule(wri, this.getTrailingComments());
    }

    private static void writeFontFamily(SimpleWriter wri, String ff) throws IOException {
        if (ff.indexOf(32) == -1) {
            wri.write((CharSequence)ff);
        } else {
            wri.write('\'');
            wri.write((CharSequence)ff);
            wri.write('\'');
        }
    }

    private void writeFeatureBlock(SimpleWriter wri, StyleFormattingContext context, String atFeatureType, CSSFontFeatureValuesMapImpl featureMap) throws IOException {
        if (!featureMap.isEmpty()) {
            context.startRule(wri, featureMap.precedingComments);
            wri.write((CharSequence)atFeatureType);
            context.writeLeftCurlyBracket(wri);
            this.appendFeatureString(wri, context, featureMap);
            context.writeRightCurlyBracket(wri);
            context.endRule(wri, featureMap.trailingComments);
        }
    }

    private void appendFeatureString(SimpleWriter wri, StyleFormattingContext context, CSSFontFeatureValuesMapImpl featureMap) throws IOException {
        context.deepenCurrentContext();
        context.startStyleDeclaration(wri);
        for (Map.Entry me : featureMap.featureMap.entrySet()) {
            context.startPropertyDeclaration(wri);
            wri.write((CharSequence)me.getKey());
            context.writeColon(wri);
            PrimitiveValue[] values = (PrimitiveValue[])me.getValue();
            values[0].writeCssText(wri);
            for (int i = 1; i < values.length; ++i) {
                wri.write(' ');
                values[i].writeCssText(wri);
            }
            context.writeSemiColon(wri);
            context.endPropertyDeclaration(wri);
        }
        context.updateContext(this);
        context.endStyleDeclaration(wri);
    }

    CSSHandler createFontFeatureValuesHandler(CSSParentHandler parentHandler, ParserControl parserctl) {
        return new MyFontFeatureValuesHandler(parentHandler, parserctl);
    }

    public int hashCode() {
        int prime = 31;
        int result = this.annotation == null ? 0 : this.annotation.hashCode();
        result = 31 * result + (this.characterVariant == null ? 0 : this.characterVariant.hashCode());
        result = 31 * result + Arrays.hashCode(this.fontFamily);
        result = 31 * result + (this.mapmap == null ? 0 : this.mapmap.hashCode());
        result = 31 * result + (this.ornaments == null ? 0 : this.ornaments.hashCode());
        result = 31 * result + (this.styleset == null ? 0 : this.styleset.hashCode());
        result = 31 * result + (this.stylistic == null ? 0 : this.stylistic.hashCode());
        result = 31 * result + (this.swash == null ? 0 : this.swash.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FontFeatureValuesRule other = (FontFeatureValuesRule)obj;
        if (this.annotation == null ? other.annotation != null : !this.annotation.equals(other.annotation)) {
            return false;
        }
        if (this.characterVariant == null ? other.characterVariant != null : !this.characterVariant.equals(other.characterVariant)) {
            return false;
        }
        if (!Arrays.equals(this.fontFamily, other.fontFamily)) {
            return false;
        }
        if (this.mapmap == null ? other.mapmap != null : !this.mapmap.equals(other.mapmap)) {
            return false;
        }
        if (this.ornaments == null ? other.ornaments != null : !this.ornaments.equals(other.ornaments)) {
            return false;
        }
        if (this.styleset == null ? other.styleset != null : !this.styleset.equals(other.styleset)) {
            return false;
        }
        if (this.stylistic == null ? other.stylistic != null : !this.stylistic.equals(other.stylistic)) {
            return false;
        }
        return !(this.swash == null ? other.swash != null : !this.swash.equals(other.swash));
    }

    @Override
    public FontFeatureValuesRule clone(AbstractCSSStyleSheet parentSheet) {
        FontFeatureValuesRule rule = new FontFeatureValuesRule(parentSheet, this.getOrigin());
        rule.fontFamily = this.fontFamily;
        rule.annotation = this.annotation;
        rule.ornaments = this.ornaments;
        rule.stylistic = this.stylistic;
        rule.swash = this.swash;
        rule.styleset = this.styleset;
        rule.characterVariant = this.characterVariant;
        rule.mapmap = this.deepClone(this.mapmap);
        return rule;
    }

    private HashMap<String, CSSFontFeatureValuesMapImpl> deepClone(HashMap<String, CSSFontFeatureValuesMapImpl> cloneFrom) {
        HashMap<String, CSSFontFeatureValuesMapImpl> propValue = null;
        if (cloneFrom != null) {
            propValue = new HashMap<String, CSSFontFeatureValuesMapImpl>(cloneFrom.size());
            for (Map.Entry<String, CSSFontFeatureValuesMapImpl> entry : cloneFrom.entrySet()) {
                CSSFontFeatureValuesMapImpl value = entry.getValue();
                if (value != null) {
                    value = value.clone();
                }
                propValue.put(entry.getKey(), value);
            }
        }
        return propValue;
    }

    static /* synthetic */ String[] access$402(FontFeatureValuesRule x0, String[] x1) {
        x0.fontFamily = x1;
        return x1;
    }

    private static class CSSFontFeatureValuesMapImpl
    implements CSSFontFeatureValuesMap,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final LinkedHashMap<String, PrimitiveValue[]> featureMap = new LinkedHashMap();
        private StringList precedingComments = null;
        private StringList trailingComments = null;

        CSSFontFeatureValuesMapImpl() {
        }

        CSSFontFeatureValuesMapImpl(CSSFontFeatureValuesMapImpl copyMe) {
            this.setPrecedingComments(copyMe.precedingComments);
            this.trailingComments = copyMe.trailingComments;
        }

        void addAll(CSSFontFeatureValuesMapImpl othermap) {
            this.featureMap.putAll(othermap.featureMap);
        }

        void clear() {
            this.featureMap.clear();
        }

        @Override
        public PrimitiveValue[] get(String featureValueName) {
            return this.featureMap.get(featureValueName);
        }

        @Override
        public void set(String featureValueName, PrimitiveValue ... values) {
            if (values == null) {
                throw new DOMSyntaxException("Must provide at least one value");
            }
            for (PrimitiveValue pri : values) {
                if (pri == null) {
                    throw new DOMSyntaxException("Null value supplied.");
                }
                pri.setExpectInteger();
            }
            this.featureMap.put(featureValueName, values);
        }

        @Override
        public boolean isEmpty() {
            return this.featureMap.isEmpty();
        }

        @Override
        public int size() {
            return this.featureMap.size();
        }

        void setPrecedingComments(StringList ruleComments) {
            this.precedingComments = ruleComments;
        }

        void setTrailingComments(StringList ruleComments) {
            this.trailingComments = ruleComments;
        }

        @Override
        public StringList getPrecedingComments() {
            return this.precedingComments;
        }

        @Override
        public StringList getTrailingComments() {
            return this.trailingComments;
        }

        public int hashCode() {
            int prime = 31;
            if (this.featureMap == null) {
                return 0;
            }
            int result = 1;
            TreeSet<String> set = new TreeSet<String>(this.featureMap.keySet());
            for (String ffname : set) {
                result = 31 * result + ffname.hashCode();
                result = 31 * result + Arrays.hashCode(this.featureMap.get(ffname));
            }
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CSSFontFeatureValuesMapImpl other = (CSSFontFeatureValuesMapImpl)obj;
            if (this.featureMap == null) {
                if (other.featureMap != null) {
                    return false;
                }
            } else {
                if (other.featureMap == null || this.featureMap.size() != other.featureMap.size()) {
                    return false;
                }
                for (Map.Entry<String, PrimitiveValue[]> entry : this.featureMap.entrySet()) {
                    String ffname = entry.getKey();
                    Object[] values = entry.getValue();
                    Object[] ovalues = other.featureMap.get(ffname);
                    if (ovalues != null && Arrays.equals(values, ovalues)) continue;
                    return false;
                }
            }
            return true;
        }

        public CSSFontFeatureValuesMapImpl clone() {
            return new CSSFontFeatureValuesMapImpl(this);
        }
    }

    private class MyFontFeatureValuesHandler
    extends EmptyCSSHandler {
        private String[] fontFamily = null;
        private final CSSFontFeatureValuesMapImpl annotation = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl ornaments = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl stylistic = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl swash = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl characterVariant = new CSSFontFeatureValuesMapImpl();
        private final CSSFontFeatureValuesMapImpl styleset = new CSSFontFeatureValuesMapImpl();
        private final HashMap<String, CSSFontFeatureValuesMapImpl> mapmap = null;
        private CSSFontFeatureValuesMapImpl currentMap = null;
        private CSSFontFeatureValuesMapImpl lastMap = null;
        private LinkedList<String> comments = null;
        private final CSSParentHandler parentHandler;
        private final ParserControl parserctl;

        private MyFontFeatureValuesHandler() {
            this(null, null);
        }

        private MyFontFeatureValuesHandler(CSSParentHandler parentHandler, ParserControl parserctl) {
            this.parentHandler = parentHandler;
            this.parserctl = parserctl;
        }

        @Override
        public void startFontFeatures(String[] fontFamily) {
            this.fontFamily = fontFamily;
        }

        @Override
        public void endFontFeatures() {
            if (this.fontFamily != null) {
                FontFeatureValuesRule.access$402(FontFeatureValuesRule.this, this.fontFamily);
                FontFeatureValuesRule.this.annotation.clear();
                FontFeatureValuesRule.this.ornaments.clear();
                FontFeatureValuesRule.this.stylistic.clear();
                FontFeatureValuesRule.this.swash.clear();
                FontFeatureValuesRule.this.characterVariant.clear();
                FontFeatureValuesRule.this.styleset.clear();
                FontFeatureValuesRule.this.annotation.addAll(this.annotation);
                FontFeatureValuesRule.this.ornaments.addAll(this.ornaments);
                FontFeatureValuesRule.this.stylistic.addAll(this.stylistic);
                FontFeatureValuesRule.this.swash.addAll(this.swash);
                FontFeatureValuesRule.this.characterVariant.addAll(this.characterVariant);
                FontFeatureValuesRule.this.styleset.addAll(this.styleset);
                FontFeatureValuesRule.this.mapmap = this.mapmap;
                FontFeatureValuesRule.this.annotation.setPrecedingComments(this.annotation.getPrecedingComments());
                FontFeatureValuesRule.this.ornaments.setPrecedingComments(this.ornaments.getPrecedingComments());
                FontFeatureValuesRule.this.stylistic.setPrecedingComments(this.stylistic.getPrecedingComments());
                FontFeatureValuesRule.this.swash.setPrecedingComments(this.swash.getPrecedingComments());
                FontFeatureValuesRule.this.characterVariant.setPrecedingComments(this.characterVariant.getPrecedingComments());
                FontFeatureValuesRule.this.styleset.setPrecedingComments(this.styleset.getPrecedingComments());
                FontFeatureValuesRule.this.annotation.setTrailingComments(this.annotation.getTrailingComments());
                FontFeatureValuesRule.this.ornaments.setTrailingComments(this.ornaments.getTrailingComments());
                FontFeatureValuesRule.this.stylistic.setTrailingComments(this.stylistic.getTrailingComments());
                FontFeatureValuesRule.this.swash.setTrailingComments(this.swash.getTrailingComments());
                FontFeatureValuesRule.this.characterVariant.setTrailingComments(this.characterVariant.getTrailingComments());
                FontFeatureValuesRule.this.styleset.setTrailingComments(this.styleset.getTrailingComments());
            }
            if (this.parentHandler != null) {
                this.parentHandler.endSubHandler((short)14);
            }
        }

        @Override
        public void startFeatureMap(String mapname) {
            mapname = mapname.toLowerCase(Locale.ROOT);
            this.enableMap(mapname);
            this.currentMap = this.getFeatureValuesMap(mapname);
        }

        private void enableMap(String featureValueName) {
            FontFeatureValuesRule.enableMap(featureValueName, this.mapmap);
            this.lastMap = null;
        }

        private CSSFontFeatureValuesMapImpl getFeatureValuesMap(String featureValueName) {
            CSSFontFeatureValuesMapImpl map;
            if (featureValueName.equals("annotation")) {
                map = this.annotation;
            } else if (featureValueName.equals("ornaments")) {
                map = this.ornaments;
            } else if (featureValueName.equals("stylistic")) {
                map = this.stylistic;
            } else if (featureValueName.equals("swash")) {
                map = this.swash;
            } else if (featureValueName.equals("character-variant")) {
                map = this.characterVariant;
            } else if (featureValueName.equals("styleset")) {
                map = this.styleset;
            } else if (this.mapmap == null) {
                map = null;
            } else {
                map = this.mapmap.get(featureValueName);
                map.precedingComments = null;
            }
            return map;
        }

        @Override
        public void endFeatureMap() {
            this.setCommentsToCurrentMap();
            this.lastMap = this.currentMap;
            this.currentMap = null;
        }

        @Override
        public void property(String name, LexicalUnit value, boolean important) {
            LinkedList<PrimitiveValue> values = new LinkedList<PrimitiveValue>();
            while (value != null) {
                LexicalUnit.LexicalType lutype = value.getLexicalUnitType();
                if (lutype == LexicalUnit.LexicalType.INTEGER) {
                    NumberValue number = new NumberValue();
                    int ival = value.getIntegerValue();
                    number.setIntegerValue(ival);
                    values.add(number);
                } else if (lutype == LexicalUnit.LexicalType.VAR || lutype == LexicalUnit.LexicalType.CALC) {
                    ValueFactory valueFactory = new ValueFactory();
                    StyleValue cssval = valueFactory.createCSSValue(value);
                    PrimitiveValue pri = (PrimitiveValue)cssval;
                    pri.setExpectInteger();
                    values.add(pri);
                } else {
                    String msg = "Found non-integer value: " + value.toString();
                    if (this.parserctl != null) {
                        Locator locator = this.parserctl.createLocator();
                        CSSParseException ex = new CSSParseException(msg, locator);
                        this.parserctl.getErrorHandler().error(ex);
                    } else {
                        throw new CSSException(msg);
                    }
                }
                value = value.getNextLexicalUnit();
            }
            PrimitiveValue[] intvals = new PrimitiveValue[values.size()];
            for (int i = 0; i < intvals.length; ++i) {
                intvals[i] = (PrimitiveValue)values.get(i);
            }
            this.currentMap.set(name, intvals);
        }

        @Override
        public void comment(String text, boolean precededByLF) {
            if (this.lastMap != null && !precededByLF) {
                if (this.lastMap.trailingComments == null) {
                    this.lastMap.trailingComments = new LinkedStringList();
                }
                this.lastMap.trailingComments.add(text);
            } else if (this.currentMap == null) {
                if (this.comments == null) {
                    this.comments = new LinkedStringList();
                }
                this.comments.add(text);
            }
        }

        private void setCommentsToCurrentMap() {
            if (this.comments != null && !this.comments.isEmpty()) {
                ArrayStringList ruleComments = new ArrayStringList(this.comments.size());
                ruleComments.addAll(this.comments);
                this.currentMap.setPrecedingComments(ruleComments);
            }
            this.resetCommentStack();
        }

        private void resetCommentStack() {
            if (this.comments != null) {
                this.comments.clear();
            }
        }
    }
}

