/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public final class CompositeRevertAction
extends Action
implements IUpdate,
ISelectionChangedListener {
    private final IAction[] fActions;

    public CompositeRevertAction(ITextEditor editor, IAction[] actions) {
        this.fActions = new IAction[actions.length];
        IAction[] iActionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            Assert.isNotNull((Object)action);
            ++n2;
        }
        System.arraycopy(actions, 0, this.fActions, 0, actions.length);
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)selectionProvider).addPostSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.update();
    }

    public void update() {
        IAction[] iActionArray = this.fActions;
        int n = this.fActions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction fAction = iActionArray[n2];
            if (fAction instanceof IUpdate) {
                ((IUpdate)fAction).update();
            }
            ++n2;
        }
        IAction action = this.getEnabledAction();
        this.setEnabled(this.getEnabledAction() != null);
        if (action == null) {
            return;
        }
        this.setText(action.getText());
        this.setToolTipText(action.getToolTipText());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    public void run() {
        IAction action = this.getEnabledAction();
        if (action != null) {
            action.run();
        }
    }

    private IAction getEnabledAction() {
        IAction[] iActionArray = this.fActions;
        int n = this.fActions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction fAction = iActionArray[n2];
            if (fAction.isEnabled()) {
                return fAction;
            }
            ++n2;
        }
        return null;
    }
}

