/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ServiceLoader;
import org.jetbrains.annotations.ApiStatus;

public abstract class JpsServiceManager {
    public static JpsServiceManager getInstance() {
        return InstanceHolder.INSTANCE;
    }

    @ApiStatus.Internal
    protected JpsServiceManager() {
    }

    public abstract <T> T getService(Class<T> var1);

    public abstract <T> Iterable<T> getExtensions(Class<T> var1);

    private static final class InstanceHolder {
        private static final JpsServiceManager INSTANCE;

        private InstanceHolder() {
        }

        static {
            String implClass = System.getProperties().getProperty("jps.service.manager.impl");
            if (implClass == null || implClass.isEmpty()) {
                INSTANCE = ServiceLoader.load(JpsServiceManager.class, JpsServiceManager.class.getClassLoader()).iterator().next();
            } else {
                try {
                    Class<?> aClass = JpsServiceManager.class.getClassLoader().loadClass(implClass);
                    INSTANCE = (JpsServiceManager)aClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

