struct debug_font_common {
struct Samplers {
 sampler2D_impl sColor0_impl;
 int sColor0_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 2:
   sColor0_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aColor = NULL_ATTRIB;
 int aColorTexCoord = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aColor", name) == 0) { aColor = index; return; }
  if (strcmp("aColorTexCoord", name) == 0) { aColorTexCoord = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aColor", name) == 0) { return aColor != NULL_ATTRIB ? aColor : -1; }
  if (strcmp("aColorTexCoord", name) == 0) { return aColorTexCoord != NULL_ATTRIB ? aColorTexCoord : -1; }
  return -1;
 }
} attrib_locations;
sampler2D sColor0;
mat4_scalar uTransform;
void bind_textures() {
 sColor0 = lookup_sampler(&samplers.sColor0_impl, samplers.sColor0_slot);
}
};
struct debug_font_vert : VertexShaderImpl, debug_font_common {
private:
typedef debug_font_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
vec2 vColorTexCoord;
vec4 vColor;
vec4 aColor;
vec2 aColorTexCoord;
ALWAYS_INLINE void main(void) {
 vColor = aColor;
 vColorTexCoord = aColorTexCoord;
 vec4 pos = make_vec4(aPosition, 0.f, 1.f);
 (pos).lsel(X,Y) = floor(((pos).sel(X,Y))+(0.5f));
 gl_Position = (uTransform)*(pos);
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 2:
  assert(0); // sColor0
  break;
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 2:
  assert(0); // sColor0
  break;
 case 1:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 2:
  assert(0); // sColor0
  break;
 case 1:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_attrib(self->aColor, attribs[self->attrib_locations.aColor], start, instance, count);
 load_attrib(self->aColorTexCoord, attribs[self->attrib_locations.aColorTexCoord], start, instance, count);
}
public:
struct InterpOutputs {
vec2_scalar vColorTexCoord;
vec4_scalar vColor;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vColorTexCoord = get_nth(vColorTexCoord, n);
    dest->vColor = get_nth(vColor, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
debug_font_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct debug_font_frag : FragmentShaderImpl, debug_font_vert {
private:
typedef debug_font_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
// sampler2D sColor0;
// sampler2D sColor1;
// sampler2D sColor2;
vec2 vColorTexCoord;
vec4 vColor;
ALWAYS_INLINE void main(void) {
 Float alpha = (texture(sColor0, vColorTexCoord)).x;
 oFragColor = (vColor)*(alpha);
}
typedef debug_font_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec2 vColorTexCoord;
vec4 vColor;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vColorTexCoord = init_interp(init->vColorTexCoord, step->vColorTexCoord);
  self->interp_step.vColorTexCoord = step->vColorTexCoord * 4.0f;
  self->vColor = init_interp(init->vColor, step->vColor);
  self->interp_step.vColor = step->vColor * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vColorTexCoord = init_interp(init->vColorTexCoord, step->vColorTexCoord);
  self->vColorTexCoord = self->interp_perspective.vColorTexCoord * w;
  self->interp_step.vColorTexCoord = step->vColorTexCoord * 4.0f;
  self->interp_perspective.vColor = init_interp(init->vColor, step->vColor);
  self->vColor = self->interp_perspective.vColor * w;
  self->interp_step.vColor = step->vColor * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vColorTexCoord += interp_step.vColorTexCoord * chunks;
  vColor += interp_step.vColor * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vColorTexCoord += interp_step.vColorTexCoord * chunks;
  vColorTexCoord = w * interp_perspective.vColorTexCoord;
  interp_perspective.vColor += interp_step.vColor * chunks;
  vColor = w * interp_perspective.vColor;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
public:
debug_font_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct debug_font_program : ProgramImpl, debug_font_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sColor0", name) == 0) { return 2; }
 if (strcmp("uTransform", name) == 0) { return 1; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "debug_font"; }
static ProgramImpl* loader() { return new debug_font_program; }
};

