#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomPropertyRegisteredEvent = 975,
  CSSFontFaceRule = 1008,
  CSSFontFeatureValuesRule = 1024,
  CSSFontPaletteValuesRule = 1049,
  CSSGroupingRule = 1074,
  CSSHSL = 1090,
  CSSHWB = 1097,
  CSSImageValue = 1104,
  CSSImportRule = 1118,
  CSSKeyframeRule = 1132,
  CSSKeyframesRule = 1148,
  CSSKeywordValue = 1165,
  CSSLCH = 1181,
  CSSLab = 1188,
  CSSLayerBlockRule = 1195,
  CSSLayerStatementRule = 1213,
  CSSMarginRule = 1235,
  CSSMathClamp = 1249,
  CSSMathInvert = 1262,
  CSSMathMax = 1276,
  CSSMathMin = 1287,
  CSSMathNegate = 1298,
  CSSMathProduct = 1312,
  CSSMathSum = 1327,
  CSSMathValue = 1338,
  CSSMatrixComponent = 1351,
  CSSMediaRule = 1370,
  CSSMozDocumentRule = 1383,
  CSSNamespaceRule = 1402,
  CSSNestedDeclarations = 1419,
  CSSNumericArray = 1441,
  CSSNumericValue = 1457,
  CSSOKLCH = 1473,
  CSSOKLab = 1482,
  CSSPageDescriptors = 1491,
  CSSPageRule = 1510,
  CSSPerspective = 1522,
  CSSPositionTryDescriptors = 1537,
  CSSPositionTryRule = 1563,
  CSSPropertyRule = 1582,
  CSSPseudoElement = 1598,
  CSSRGB = 1615,
  CSSRotate = 1622,
  CSSRule = 1632,
  CSSRuleList = 1640,
  CSSScale = 1652,
  CSSScopeRule = 1661,
  CSSSkew = 1674,
  CSSSkewX = 1682,
  CSSSkewY = 1691,
  CSSStartingStyleRule = 1700,
  CSSStyleDeclaration = 1721,
  CSSStyleProperties = 1741,
  CSSStyleRule = 1760,
  CSSStyleSheet = 1773,
  CSSStyleValue = 1787,
  CSSSupportsRule = 1801,
  CSSTransformComponent = 1817,
  CSSTransformValue = 1839,
  CSSTransition = 1857,
  CSSTranslate = 1871,
  CSSUnitValue = 1884,
  CSSUnparsedValue = 1897,
  CSSVariableReferenceValue = 1914,
  Cache = 1940,
  CacheStorage = 1946,
  CallbackDebuggerNotification = 1959,
  CanonicalBrowsingContext = 1988,
  CanvasCaptureMediaStream = 2013,
  CanvasGradient = 2038,
  CanvasPattern = 2053,
  CanvasRenderingContext2D = 2067,
  CaretPosition = 2092,
  CaretStateChangedEvent = 2106,
  ChannelMergerNode = 2129,
  ChannelSplitterNode = 2147,
  ChannelWrapper = 2167,
  CharacterData = 2182,
  CheckerboardReportService = 2196,
  ChildProcessMessageManager = 2222,
  ChildSHistory = 2249,
  ChromeMessageBroadcaster = 2263,
  ChromeMessageSender = 2288,
  ChromeNodeList = 2308,
  ChromeUtils = 2323,
  ChromeWorker = 2335,
  Client = 2348,
  Clients = 2355,
  Clipboard = 2363,
  ClipboardEvent = 2373,
  ClipboardItem = 2388,
  ClonedErrorHolder = 2402,
  CloseEvent = 2420,
  CloseWatcher = 2431,
  CommandEvent = 2444,
  Comment = 2457,
  CompositionEvent = 2465,
  CompressionStream = 2482,
  ConsoleInstance = 2500,
  ConstantSourceNode = 2516,
  ContentFrameMessageManager = 2535,
  ContentProcessMessageManager = 2562,
  ContentVisibilityAutoStateChangeEvent = 2591,
  ConvolverNode = 2629,
  CookieChangeEvent = 2643,
  CookieStore = 2661,
  CookieStoreManager = 2673,
  CountQueuingStrategy = 2692,
  CreateOfferRequest = 2713,
  Credential = 2732,
  CredentialsContainer = 2743,
  Crypto = 2764,
  CryptoKey = 2771,
  CustomElementRegistry = 2781,
  CustomEvent = 2803,
  CustomStateSet = 2815,
  DOMException = 2830,
  DOMImplementation = 2843,
  DOMLocalization = 2861,
  DOMMatrix = 2877,
  DOMMatrixReadOnly = 2887,
  DOMParser = 2905,
  DOMPoint = 2915,
  DOMPointReadOnly = 2924,
  DOMQuad = 2941,
  DOMRect = 2949,
  DOMRectList = 2957,
  DOMRectReadOnly = 2969,
  DOMStringList = 2985,
  DOMStringMap = 2999,
  DOMTokenList = 3012,
  DataTransfer = 3025,
  DataTransferItem = 3038,
  DataTransferItemList = 3055,
  DebuggerNotification = 3076,
  DebuggerNotificationObserver = 3097,
  DecompressionStream = 3126,
  DedicatedWorkerGlobalScope = 3146,
  DelayNode = 3173,
  DeprecationReportBody = 3183,
  DeviceAcceleration = 3205,
  DeviceLightEvent = 3224,
  DeviceMotionEvent = 3241,
  DeviceOrientationEvent = 3259,
  DeviceRotationRate = 3282,
  Directory = 3301,
  Document = 3311,
  DocumentFragment = 3320,
  DocumentL10n = 3337,
  DocumentTimeline = 3350,
  DocumentType = 3367,
  DominatorTree = 3380,
  DragEvent = 3394,
  DynamicsCompressorNode = 3404,
  EXT_blend_minmax = 3427,
  EXT_color_buffer_float = 3444,
  EXT_color_buffer_half_float = 3467,
  EXT_depth_clamp = 3495,
  EXT_disjoint_timer_query = 3511,
  EXT_float_blend = 3536,
  EXT_frag_depth = 3552,
  EXT_sRGB = 3567,
  EXT_shader_texture_lod = 3576,
  EXT_texture_compression_bptc = 3599,
  EXT_texture_compression_rgtc = 3628,
  EXT_texture_filter_anisotropic = 3657,
  EXT_texture_norm16 = 3688,
  Element = 3707,
  ElementInternals = 3715,
  EncodedAudioChunk = 3732,
  EncodedVideoChunk = 3750,
  ErrorEvent = 3768,
  Event = 3779,
  EventCallbackDebuggerNotification = 3785,
  EventCounts = 3819,
  EventSource = 3831,
  EventTarget = 3843,
  Exception = 3855,
  ExtendableCookieChangeEvent = 3865,
  ExtendableEvent = 3893,
  ExtendableMessageEvent = 3909,
  ExtensionAlarms = 3932,
  ExtensionBrowser = 3948,
  ExtensionBrowserSettings = 3965,
  ExtensionBrowserSettingsColorManagement = 3990,
  ExtensionDns = 4030,
  ExtensionEventManager = 4043,
  ExtensionMockAPI = 4065,
  ExtensionPort = 4082,
  ExtensionProxy = 4096,
  ExtensionRuntime = 4111,
  ExtensionScripting = 4128,
  ExtensionSetting = 4147,
  ExtensionTest = 4164,
  External = 4178,
  FeaturePolicy = 4187,
  FeaturePolicyViolationReportBody = 4201,
  FetchEvent = 4234,
  FetchObserver = 4245,
  File = 4259,
  FileList = 4264,
  FileReader = 4273,
  FileReaderSync = 4284,
  FileSystem = 4299,
  FileSystemDirectoryEntry = 4310,
  FileSystemDirectoryHandle = 4335,
  FileSystemDirectoryHandle_AsyncIterator = 4361,
  FileSystemDirectoryIterator = 4401,
  FileSystemDirectoryReader = 4429,
  FileSystemEntry = 4455,
  FileSystemFileEntry = 4471,
  FileSystemFileHandle = 4491,
  FileSystemHandle = 4512,
  FileSystemSyncAccessHandle = 4529,
  FileSystemWritableFileStream = 4556,
  Flex = 4585,
  FlexItemValues = 4590,
  FlexLineValues = 4605,
  FluentBundle = 4620,
  FluentBundleAsyncIterator = 4633,
  FluentBundleIterator = 4659,
  FluentPattern = 4680,
  FluentResource = 4694,
  FocusEvent = 4709,
  FontFace = 4720,
  FontFaceSet = 4729,
  FontFaceSetIterator = 4741,
  FontFaceSetLoadEvent = 4761,
  FormData = 4782,
  FormData_Iterator = 4791,
  FormDataEvent = 4809,
  FragmentDirective = 4823,
  FrameCrashedEvent = 4841,
  FrameLoader = 4859,
  GPU = 4871,
  GPUAdapter = 4875,
  GPUAdapterInfo = 4886,
  GPUBindGroup = 4901,
  GPUBindGroupLayout = 4914,
  GPUBuffer = 4933,
  GPUBufferUsage = 4943,
  GPUCanvasContext = 4958,
  GPUColorWrite = 4975,
  GPUCommandBuffer = 4989,
  GPUCommandEncoder = 5006,
  GPUCompilationInfo = 5024,
  GPUCompilationMessage = 5043,
  GPUComputePassEncoder = 5065,
  GPUComputePipeline = 5087,
  GPUDevice = 5106,
  GPUDeviceLostInfo = 5116,
  GPUError = 5134,
  GPUExternalTexture = 5143,
  GPUInternalError = 5162,
  GPUMapMode = 5179,
  GPUOutOfMemoryError = 5190,
  GPUPipelineError = 5210,
  GPUPipelineLayout = 5227,
  GPUQuerySet = 5245,
  GPUQueue = 5257,
  GPURenderBundle = 5266,
  GPURenderBundleEncoder = 5282,
  GPURenderPassEncoder = 5305,
  GPURenderPipeline = 5326,
  GPUSampler = 5344,
  GPUShaderModule = 5355,
  GPUShaderStage = 5371,
  GPUSupportedFeatures = 5386,
  GPUSupportedLimits = 5407,
  GPUTexture = 5426,
  GPUTextureUsage = 5437,
  GPUTextureView = 5453,
  GPUUncapturedErrorEvent = 5468,
  GPUValidationError = 5492,
  GainNode = 5511,
  Gamepad = 5520,
  GamepadAxisMoveEvent = 5528,
  GamepadButton = 5549,
  GamepadButtonEvent = 5563,
  GamepadEvent = 5582,
  GamepadHapticActuator = 5595,
  GamepadLightIndicator = 5617,
  GamepadPose = 5639,
  GamepadServiceTest = 5651,
  GamepadTouch = 5670,
  Geolocation = 5683,
  GeolocationCoordinates = 5695,
  GeolocationPosition = 5718,
  GeolocationPositionError = 5738,
  GetUserMediaRequest = 5763,
  GleanBoolean = 5783,
  GleanCategory = 5796,
  GleanCounter = 5810,
  GleanCustomDistribution = 5823,
  GleanDatetime = 5847,
  GleanDenominator = 5861,
  GleanDualLabeledCounter = 5878,
  GleanEvent = 5902,
  GleanImpl = 5913,
  GleanLabeled = 5923,
  GleanMemoryDistribution = 5936,
  GleanMetric = 5960,
  GleanNumerator = 5972,
  GleanObject = 5987,
  GleanPingsImpl = 5999,
  GleanQuantity = 6014,
  GleanRate = 6028,
  GleanString = 6038,
  GleanStringList = 6050,
  GleanText = 6066,
  GleanTimespan = 6076,
  GleanTimingDistribution = 6090,
  GleanUrl = 6114,
  GleanUuid = 6123,
  Grid = 6133,
  GridArea = 6138,
  GridDimension = 6147,
  GridLine = 6161,
  GridLines = 6170,
  GridTrack = 6180,
  GridTracks = 6190,
  HTMLAllCollection = 6201,
  HTMLAnchorElement = 6219,
  HTMLAreaElement = 6237,
  HTMLAudioElement = 6253,
  HTMLBRElement = 6270,
  HTMLBaseElement = 6284,
  HTMLBodyElement = 6300,
  HTMLButtonElement = 6316,
  HTMLCanvasElement = 6334,
  HTMLCollection = 6352,
  HTMLDListElement = 6367,
  HTMLDataElement = 6384,
  HTMLDataListElement = 6400,
  HTMLDetailsElement = 6420,
  HTMLDialogElement = 6439,
  HTMLDirectoryElement = 6457,
  HTMLDivElement = 6478,
  HTMLDocument = 6493,
  HTMLElement = 6506,
  HTMLEmbedElement = 6518,
  HTMLFieldSetElement = 6535,
  HTMLFontElement = 6555,
  HTMLFormControlsCollection = 6571,
  HTMLFormElement = 6598,
  HTMLFrameElement = 6614,
  HTMLFrameSetElement = 6631,
  HTMLHRElement = 6651,
  HTMLHeadElement = 6665,
  HTMLHeadingElement = 6681,
  HTMLHtmlElement = 6700,
  HTMLIFrameElement = 6716,
  HTMLImageElement = 6734,
  HTMLInputElement = 6751,
  HTMLLIElement = 6768,
  HTMLLabelElement = 6782,
  HTMLLegendElement = 6799,
  HTMLLinkElement = 6817,
  HTMLMapElement = 6833,
  HTMLMarqueeElement = 6848,
  HTMLMediaElement = 6867,
  HTMLMenuElement = 6884,
  HTMLMetaElement = 6900,
  HTMLMeterElement = 6916,
  HTMLModElement = 6933,
  HTMLOListElement = 6948,
  HTMLObjectElement = 6965,
  HTMLOptGroupElement = 6983,
  HTMLOptionElement = 7003,
  HTMLOptionsCollection = 7021,
  HTMLOutputElement = 7043,
  HTMLParagraphElement = 7061,
  HTMLParamElement = 7082,
  HTMLPictureElement = 7099,
  HTMLPreElement = 7118,
  HTMLProgressElement = 7133,
  HTMLQuoteElement = 7153,
  HTMLScriptElement = 7170,
  HTMLSelectElement = 7188,
  HTMLSlotElement = 7206,
  HTMLSourceElement = 7222,
  HTMLSpanElement = 7240,
  HTMLStyleElement = 7256,
  HTMLTableCaptionElement = 7273,
  HTMLTableCellElement = 7297,
  HTMLTableColElement = 7318,
  HTMLTableElement = 7338,
  HTMLTableRowElement = 7355,
  HTMLTableSectionElement = 7375,
  HTMLTemplateElement = 7399,
  HTMLTextAreaElement = 7419,
  HTMLTimeElement = 7439,
  HTMLTitleElement = 7455,
  HTMLTrackElement = 7472,
  HTMLUListElement = 7489,
  HTMLUnknownElement = 7506,
  HTMLVideoElement = 7525,
  HashChangeEvent = 7542,
  Headers = 7558,
  Headers_Iterator = 7566,
  HeapSnapshot = 7583,
  Highlight = 7596,
  HighlightRegistry = 7606,
  History = 7624,
  IDBCursor = 7632,
  IDBCursorWithValue = 7642,
  IDBDatabase = 7661,
  IDBFactory = 7673,
  IDBIndex = 7684,
  IDBKeyRange = 7693,
  IDBObjectStore = 7705,
  IDBOpenDBRequest = 7720,
  IDBRequest = 7737,
  IDBTransaction = 7748,
  IDBVersionChangeEvent = 7763,
  IIRFilterNode = 7785,
  IOUtils = 7799,
  IdentityCredential = 7807,
  IdentityProvider = 7826,
  IdleDeadline = 7843,
  Image = 7856,
  ImageBitmap = 7862,
  ImageBitmapRenderingContext = 7874,
  ImageCapture = 7902,
  ImageCaptureError = 7915,
  ImageCaptureErrorEvent = 7933,
  ImageData = 7956,
  ImageDecoder = 7966,
  ImageDocument = 7979,
  ImageTrack = 7993,
  ImageTrackList = 8004,
  InferenceSession = 8019,
  InputEvent = 8036,
  InspectorCSSParser = 8047,
  InspectorFontFace = 8066,
  InspectorUtils = 8084,
  IntersectionObserver = 8099,
  IntersectionObserverEntry = 8120,
  IntlUtils = 8146,
  JSProcessActorChild = 8156,
  JSProcessActorParent = 8176,
  JSWindowActorChild = 8197,
  JSWindowActorParent = 8216,
  KeyEvent = 8236,
  KeyboardEvent = 8245,
  KeyframeEffect = 8259,
  L10nFileSource = 8274,
  L10nOverlays = 8289,
  L10nRegistry = 8302,
  LargestContentfulPaint = 8315,
  LegacyMozTCPSocket = 8338,
  LlamaRunner = 8357,
  Localization = 8369,
  Location = 8382,
  Lock = 8391,
  LockManager = 8396,
  MIDIAccess = 8408,
  MIDIConnectionEvent = 8419,
  MIDIInput = 8439,
  MIDIInputMap = 8449,
  MIDIMessageEvent = 8462,
  MIDIOutput = 8479,
  MIDIOutputMap = 8490,
  MIDIPort = 8504,
  MLS = 8513,
  MLSGroupView = 8517,
  MOZ_debug = 8530,
  MatchGlob = 8540,
  MatchPattern = 8550,
  MatchPatternSet = 8563,
  MathMLElement = 8579,
  MediaCapabilities = 8593,
  MediaControlService = 8611,
  MediaController = 8631,
  MediaDeviceInfo = 8647,
  MediaDevices = 8663,
  MediaElementAudioSourceNode = 8676,
  MediaEncryptedEvent = 8704,
  MediaError = 8724,
  MediaKeyError = 8735,
  MediaKeyMessageEvent = 8749,
  MediaKeySession = 8770,
  MediaKeyStatusMap = 8786,
  MediaKeyStatusMap_Iterator = 8804,
  MediaKeySystemAccess = 8831,
  MediaKeys = 8852,
  MediaList = 8862,
  MediaMetadata = 8872,
  MediaQueryList = 8886,
  MediaQueryListEvent = 8901,
  MediaRecorder = 8921,
  MediaRecorderErrorEvent = 8935,
  MediaSession = 8959,
  MediaSource = 8972,
  MediaStream = 8984,
  MediaStreamAudioDestinationNode = 8996,
  MediaStreamAudioSourceNode = 9028,
  MediaStreamError = 9055,
  MediaStreamEvent = 9072,
  MediaStreamTrack = 9089,
  MediaStreamTrackAudioSourceNode = 9106,
  MediaStreamTrackEvent = 9138,
  MerchantValidationEvent = 9160,
  MessageBroadcaster = 9184,
  MessageChannel = 9203,
  MessageEvent = 9218,
  MessageListenerManager = 9231,
  MessagePort = 9254,
  MessageSender = 9266,
  MimeType = 9280,
  MimeTypeArray = 9289,
  MouseEvent = 9303,
  MouseScrollEvent = 9314,
  MozCanvasPrintState = 9331,
  MozDocumentMatcher = 9351,
  MozDocumentObserver = 9370,
  MozQueryInterface = 9390,
  MozSharedMap = 9408,
  MozSharedMap_Iterator = 9421,
  MozSharedMapChangeEvent = 9443,
  MozStorageAsyncStatementParams = 9467,
  MozStorageStatementParams = 9498,
  MozStorageStatementRow = 9524,
  MozWritableSharedMap = 9547,
  MutationObserver = 9568,
  MutationRecord = 9585,
  NamedNodeMap = 9600,
  NavigateEvent = 9613,
  Navigation = 9627,
  NavigationActivation = 9638,
  NavigationCurrentEntryChangeEvent = 9659,
  NavigationDestination = 9693,
  NavigationHistoryEntry = 9715,
  NavigationPreloadManager = 9738,
  NavigationTransition = 9763,
  Navigator = 9784,
  NavigatorLogin = 9794,
  NetworkInformation = 9809,
  Node = 9828,
  NodeFilter = 9833,
  NodeIterator = 9844,
  NodeList = 9857,
  Notification = 9866,
  NotificationEvent = 9879,
  NotifyPaintEvent = 9897,
  OES_draw_buffers_indexed = 9914,
  OES_element_index_uint = 9939,
  OES_fbo_render_mipmap = 9962,
  OES_standard_derivatives = 9984,
  OES_texture_float = 10009,
  OES_texture_float_linear = 10027,
  OES_texture_half_float = 10052,
  OES_texture_half_float_linear = 10075,
  OES_vertex_array_object = 10105,
  OVR_multiview2 = 10129,
  OfflineAudioCompletionEvent = 10144,
  OfflineAudioContext = 10172,
  OffscreenCanvas = 10192,
  OffscreenCanvasRenderingContext2D = 10208,
  OnlyForUseInConstructor = 10242,
  Option = 10266,
  OscillatorNode = 10273,
  PageTransitionEvent = 10288,
  PaintRequest = 10308,
  PaintRequestList = 10321,
  PaintWorkletGlobalScope = 10338,
  PannerNode = 10362,
  ParentProcessMessageManager = 10373,
  Path2D = 10401,
  PathUtils = 10408,
  PaymentAddress = 10418,
  PaymentMethodChangeEvent = 10433,
  PaymentRequest = 10458,
  PaymentRequestUpdateEvent = 10473,
  PaymentResponse = 10499,
  PeerConnectionImpl = 10515,
  PeerConnectionObserver = 10534,
  Performance = 10557,
  PerformanceEntry = 10569,
  PerformanceEntryEvent = 10586,
  PerformanceEventTiming = 10608,
  PerformanceMark = 10631,
  PerformanceMeasure = 10647,
  PerformanceNavigation = 10666,
  PerformanceNavigationTiming = 10688,
  PerformanceObserver = 10716,
  PerformanceObserverEntryList = 10736,
  PerformancePaintTiming = 10765,
  PerformanceResourceTiming = 10788,
  PerformanceServerTiming = 10814,
  PerformanceTiming = 10838,
  PeriodicWave = 10856,
  PermissionStatus = 10869,
  Permissions = 10886,
  PlacesBookmark = 10898,
  PlacesBookmarkAddition = 10913,
  PlacesBookmarkChanged = 10936,
  PlacesBookmarkGuid = 10958,
  PlacesBookmarkKeyword = 10977,
  PlacesBookmarkMoved = 10999,
  PlacesBookmarkRemoved = 11019,
  PlacesBookmarkTags = 11041,
  PlacesBookmarkTime = 11060,
  PlacesBookmarkTitle = 11079,
  PlacesBookmarkUrl = 11099,
  PlacesEvent = 11117,
  PlacesEventCounts = 11129,
  PlacesFavicon = 11147,
  PlacesHistoryCleared = 11161,
  PlacesObservers = 11182,
  PlacesPurgeCaches = 11198,
  PlacesRanking = 11216,
  PlacesVisit = 11230,
  PlacesVisitRemoved = 11242,
  PlacesVisitTitle = 11261,
  PlacesWeakCallbackWrapper = 11278,
  Plugin = 11304,
  PluginArray = 11311,
  PluginCrashedEvent = 11323,
  PointerEvent = 11342,
  PopStateEvent = 11355,
  PopupBlockedEvent = 11369,
  PopupPositionedEvent = 11387,
  PositionStateEvent = 11408,
  PrecompiledScript = 11427,
  PrivateAttribution = 11445,
  ProcessMessageManager = 11464,
  ProcessingInstruction = 11486,
  ProgressEvent = 11508,
  PromiseDebugging = 11522,
  PromiseNativeHandler = 11539,
  PromiseRejectionEvent = 11560,
  PublicKeyCredential = 11582,
  PushEvent = 11602,
  PushManager = 11612,
  PushManagerImpl = 11624,
  PushMessageData = 11640,
  PushSubscription = 11656,
  PushSubscriptionChangeEvent = 11673,
  PushSubscriptionOptions = 11701,
  RTCCertificate = 11725,
  RTCDTMFSender = 11740,
  RTCDTMFToneChangeEvent = 11754,
  RTCDataChannel = 11777,
  RTCDataChannelEvent = 11792,
  RTCDtlsTransport = 11812,
  RTCEncodedAudioFrame = 11829,
  RTCEncodedVideoFrame = 11850,
  RTCIceCandidate = 11871,
  RTCIceTransport = 11887,
  RTCIdentityProviderRegistrar = 11903,
  RTCPeerConnection = 11932,
  RTCPeerConnectionIceEvent = 11950,
  RTCPeerConnectionStatic = 11976,
  RTCRtpReceiver = 12000,
  RTCRtpScriptTransform = 12015,
  RTCRtpScriptTransformer = 12037,
  RTCRtpSender = 12061,
  RTCRtpTransceiver = 12074,
  RTCSctpTransport = 12092,
  RTCSessionDescription = 12109,
  RTCStatsReport = 12131,
  RTCTrackEvent = 12146,
  RTCTransformEvent = 12160,
  RadioNodeList = 12178,
  Range = 12192,
  ReadableByteStreamController = 12198,
  ReadableStream = 12227,
  ReadableStream_AsyncIterator = 12242,
  ReadableStreamBYOBReader = 12271,
  ReadableStreamBYOBRequest = 12296,
  ReadableStreamDefaultController = 12322,
  ReadableStreamDefaultReader = 12354,
  RedirectBlockedEvent = 12382,
  Report = 12403,
  ReportBody = 12410,
  ReportingObserver = 12421,
  Request = 12439,
  ResizeObserver = 12447,
  ResizeObserverEntry = 12462,
  ResizeObserverSize = 12482,
  Response = 12501,
  SVGAElement = 12510,
  SVGAngle = 12522,
  SVGAnimateElement = 12531,
  SVGAnimateMotionElement = 12549,
  SVGAnimateTransformElement = 12573,
  SVGAnimatedAngle = 12600,
  SVGAnimatedBoolean = 12617,
  SVGAnimatedEnumeration = 12636,
  SVGAnimatedInteger = 12659,
  SVGAnimatedLength = 12678,
  SVGAnimatedLengthList = 12696,
  SVGAnimatedNumber = 12718,
  SVGAnimatedNumberList = 12736,
  SVGAnimatedPreserveAspectRatio = 12758,
  SVGAnimatedRect = 12789,
  SVGAnimatedString = 12805,
  SVGAnimatedTransformList = 12823,
  SVGAnimationElement = 12848,
  SVGCircleElement = 12868,
  SVGClipPathElement = 12885,
  SVGComponentTransferFunctionElement = 12904,
  SVGDefsElement = 12940,
  SVGDescElement = 12955,
  SVGElement = 12970,
  SVGEllipseElement = 12981,
  SVGFEBlendElement = 12999,
  SVGFEColorMatrixElement = 13017,
  SVGFEComponentTransferElement = 13041,
  SVGFECompositeElement = 13071,
  SVGFEConvolveMatrixElement = 13093,
  SVGFEDiffuseLightingElement = 13120,
  SVGFEDisplacementMapElement = 13148,
  SVGFEDistantLightElement = 13176,
  SVGFEDropShadowElement = 13201,
  SVGFEFloodElement = 13224,
  SVGFEFuncAElement = 13242,
  SVGFEFuncBElement = 13260,
  SVGFEFuncGElement = 13278,
  SVGFEFuncRElement = 13296,
  SVGFEGaussianBlurElement = 13314,
  SVGFEImageElement = 13339,
  SVGFEMergeElement = 13357,
  SVGFEMergeNodeElement = 13375,
  SVGFEMorphologyElement = 13397,
  SVGFEOffsetElement = 13420,
  SVGFEPointLightElement = 13439,
  SVGFESpecularLightingElement = 13462,
  SVGFESpotLightElement = 13491,
  SVGFETileElement = 13513,
  SVGFETurbulenceElement = 13530,
  SVGFilterElement = 13553,
  SVGForeignObjectElement = 13570,
  SVGGElement = 13594,
  SVGGeometryElement = 13606,
  SVGGradientElement = 13625,
  SVGGraphicsElement = 13644,
  SVGImageElement = 13663,
  SVGLength = 13679,
  SVGLengthList = 13689,
  SVGLineElement = 13703,
  SVGLinearGradientElement = 13718,
  SVGMPathElement = 13743,
  SVGMarkerElement = 13759,
  SVGMaskElement = 13776,
  SVGMatrix = 13791,
  SVGMetadataElement = 13801,
  SVGNumber = 13820,
  SVGNumberList = 13830,
  SVGPathElement = 13844,
  SVGPathSegment = 13859,
  SVGPatternElement = 13874,
  SVGPoint = 13892,
  SVGPointList = 13901,
  SVGPolygonElement = 13914,
  SVGPolylineElement = 13932,
  SVGPreserveAspectRatio = 13951,
  SVGRadialGradientElement = 13974,
  SVGRect = 13999,
  SVGRectElement = 14007,
  SVGSVGElement = 14022,
  SVGScriptElement = 14036,
  SVGSetElement = 14053,
  SVGStopElement = 14067,
  SVGStringList = 14082,
  SVGStyleElement = 14096,
  SVGSwitchElement = 14112,
  SVGSymbolElement = 14129,
  SVGTSpanElement = 14146,
  SVGTextContentElement = 14162,
  SVGTextElement = 14184,
  SVGTextPathElement = 14199,
  SVGTextPositioningElement = 14218,
  SVGTitleElement = 14244,
  SVGTransform = 14260,
  SVGTransformList = 14273,
  SVGUnitTypes = 14290,
  SVGUseElement = 14303,
  SVGViewElement = 14317,
  Sanitizer = 14332,
  Scheduler = 14342,
  Screen = 14352,
  ScreenLuminance = 14359,
  ScreenOrientation = 14375,
  ScriptProcessorNode = 14393,
  ScrollAreaEvent = 14413,
  SecurityPolicyViolationEvent = 14429,
  Selection = 14458,
  ServiceWorker = 14468,
  ServiceWorkerContainer = 14482,
  ServiceWorkerGlobalScope = 14505,
  ServiceWorkerRegistration = 14530,
  SessionStoreFormData = 14556,
  SessionStoreScrollData = 14577,
  SessionStoreUtils = 14600,
  ShadowRealmGlobalScope = 14618,
  ShadowRoot = 14641,
  SharedWorker = 14652,
  SharedWorkerGlobalScope = 14665,
  SimpleGestureEvent = 14689,
  SourceBuffer = 14708,
  SourceBufferList = 14721,
  SpeechGrammar = 14738,
  SpeechGrammarList = 14752,
  SpeechRecognition = 14770,
  SpeechRecognitionAlternative = 14788,
  SpeechRecognitionError = 14817,
  SpeechRecognitionEvent = 14840,
  SpeechRecognitionResult = 14863,
  SpeechRecognitionResultList = 14887,
  SpeechSynthesis = 14915,
  SpeechSynthesisErrorEvent = 14931,
  SpeechSynthesisEvent = 14957,
  SpeechSynthesisUtterance = 14978,
  SpeechSynthesisVoice = 15003,
  StaticRange = 15024,
  StereoPannerNode = 15036,
  Storage = 15053,
  StorageEvent = 15061,
  StorageManager = 15074,
  StreamFilter = 15089,
  StreamFilterDataEvent = 15102,
  StructuredCloneHolder = 15124,
  StructuredCloneTester = 15146,
  StylePropertyMap = 15168,
  StylePropertyMapReadOnly = 15185,
  StylePropertyMapReadOnly_Iterator = 15210,
  StyleSheet = 15244,
  StyleSheetApplicableStateChangeEvent = 15255,
  StyleSheetList = 15292,
  StyleSheetRemovedEvent = 15307,
  SubmitEvent = 15330,
  SubtleCrypto = 15342,
  SyncMessageSender = 15355,
  SyncReadFile = 15373,
  TCPServerSocket = 15386,
  TCPServerSocketEvent = 15402,
  TCPSocket = 15423,
  TCPSocketErrorEvent = 15433,
  TCPSocketEvent = 15453,
  TaskController = 15468,
  TaskPriorityChangeEvent = 15483,
  TaskSignal = 15507,
  Tensor = 15518,
  TestAttributesOnTypes = 15525,
  TestCEReactionsInterface = 15547,
  TestCImplementedInterface = 15572,
  TestCImplementedInterface2 = 15598,
  TestCallbackDictUnionOverload = 15625,
  TestChildInterface = 15655,
  TestConstructorForFuncInterface = 15674,
  TestConstructorForPrefInterface = 15706,
  TestConstructorForSCInterface = 15738,
  TestCppKeywordNamedMethodsInterface = 15768,
  TestDeprecatedInterface = 15804,
  TestExampleInterface = 15828,
  TestExampleProxyInterface = 15849,
  TestExampleThrowingConstructorInterface = 15875,
  TestExampleWorkerInterface = 15915,
  TestFuncConstructorForDifferentFuncInterface = 15942,
  TestFuncConstructorForInterface = 15987,
  TestHTMLConstructorInterface = 16019,
  TestIndexedAndNamedGetterAndSetterInterface = 16048,
  TestIndexedAndNamedGetterInterface = 16092,
  TestIndexedAndNamedSetterInterface = 16127,
  TestIndexedGetterAndSetterAndNamedGetterInterface = 16162,
  TestIndexedGetterInterface = 16212,
  TestIndexedSetterInterface = 16239,
  TestInterface = 16266,
  TestInterfaceWithPromiseConstructorArg = 16280,
  TestJSImplInterface = 16319,
  TestJSImplInterface2 = 16339,
  TestJSImplInterface3 = 16360,
  TestJSImplInterface4 = 16381,
  TestJSImplInterface5 = 16402,
  TestJSImplInterface6 = 16423,
  TestJSImplNoInterfaceObject = 16444,
  TestLegacyFactoryFunctionInterface = 16472,
  TestLegacyFactoryFunctionInterface2 = 16507,
  TestNamedDeleterInterface = 16543,
  TestNamedDeleterWithRetvalInterface = 16569,
  TestNamedGetterInterface = 16605,
  TestNamedSetterInterface = 16630,
  TestNamespace = 16655,
  TestNonWrapperCacheInterface = 16669,
  TestParentInterface = 16698,
  TestPrefChromeOnlySCFuncConstructorForInterface = 16718,
  TestPrefConstructorForDifferentPrefInterface = 16766,
  TestPrefConstructorForInterface = 16811,
  TestProtoObjectHackedNamespace = 16843,
  TestRenamedInterface = 16874,
  TestRenamedNamespace = 16895,
  TestSCConstructorForInterface = 16916,
  TestSecureContextInterface = 16946,
  TestThrowingConstructorInterface = 16973,
  TestUtils = 17006,
  TestWorkerExposedInterface = 17016,
  TestingDeprecatedInterface = 17043,
  Text = 17070,
  TextClause = 17075,
  TextDecoder = 17086,
  TextDecoderStream = 17098,
  TextEncoder = 17116,
  TextEncoderStream = 17128,
  TextEvent = 17146,
  TextMetrics = 17156,
  TextTrack = 17168,
  TextTrackCue = 17178,
  TextTrackCueList = 17191,
  TextTrackList = 17208,
  TimeEvent = 17222,
  TimeRanges = 17232,
  ToggleEvent = 17243,
  Touch = 17255,
  TouchEvent = 17261,
  TouchList = 17272,
  TrackEvent = 17282,
  TransformStream = 17293,
  TransformStreamDefaultController = 17309,
  TransitionEvent = 17342,
  TreeColumn = 17358,
  TreeColumns = 17369,
  TreeContentView = 17381,
  TreeWalker = 17397,
  TrustedHTML = 17408,
  TrustedScript = 17420,
  TrustedScriptURL = 17434,
  TrustedTypePolicy = 17451,
  TrustedTypePolicyFactory = 17469,
  UDPMessageEvent = 17494,
  UDPSocket = 17510,
  UIEvent = 17520,
  URL = 17528,
  URLPattern = 17532,
  URLSearchParams = 17543,
  URLSearchParams_Iterator = 17559,
  UniFFIPointer = 17584,
  UniFFIScaffolding = 17598,
  UserActivation = 17616,
  UserInteraction = 17631,
  UserProximityEvent = 17647,
  VRDisplay = 17666,
  VRDisplayCapabilities = 17676,
  VRDisplayEvent = 17698,
  VREyeParameters = 17713,
  VRFieldOfView = 17729,
  VRFrameData = 17743,
  VRMockController = 17755,
  VRMockDisplay = 17772,
  VRPose = 17786,
  VRServiceTest = 17793,
  VRStageParameters = 17807,
  VTTCue = 17825,
  VTTRegion = 17832,
  ValidityState = 17842,
  VideoColorSpace = 17856,
  VideoDecoder = 17872,
  VideoEncoder = 17885,
  VideoFrame = 17898,
  VideoPlaybackQuality = 17909,
  VideoTrack = 17930,
  VideoTrackList = 17941,
  ViewTransition = 17956,
  VisualViewport = 17971,
  WEBGL_color_buffer_float = 17986,
  WEBGL_compressed_texture_astc = 18011,
  WEBGL_compressed_texture_etc = 18041,
  WEBGL_compressed_texture_etc1 = 18070,
  WEBGL_compressed_texture_pvrtc = 18100,
  WEBGL_compressed_texture_s3tc = 18131,
  WEBGL_compressed_texture_s3tc_srgb = 18161,
  WEBGL_debug_renderer_info = 18196,
  WEBGL_debug_shaders = 18222,
  WEBGL_depth_texture = 18242,
  WEBGL_draw_buffers = 18262,
  WEBGL_explicit_present = 18281,
  WEBGL_lose_context = 18304,
  WEBGL_provoking_vertex = 18323,
  WGSLLanguageFeatures = 18346,
  WakeLock = 18367,
  WakeLockSentinel = 18376,
  WaveShaperNode = 18393,
  WebExtensionContentScript = 18408,
  WebExtensionPolicy = 18434,
  WebGL2RenderingContext = 18453,
  WebGLActiveInfo = 18476,
  WebGLBuffer = 18492,
  WebGLContextEvent = 18504,
  WebGLFramebuffer = 18522,
  WebGLProgram = 18539,
  WebGLQuery = 18552,
  WebGLRenderbuffer = 18563,
  WebGLRenderingContext = 18581,
  WebGLSampler = 18603,
  WebGLShader = 18616,
  WebGLShaderPrecisionFormat = 18628,
  WebGLSync = 18655,
  WebGLTexture = 18665,
  WebGLTransformFeedback = 18678,
  WebGLUniformLocation = 18701,
  WebGLVertexArrayObject = 18722,
  WebKitCSSMatrix = 18745,
  WebSocket = 18761,
  WebTransport = 18771,
  WebTransportBidirectionalStream = 18784,
  WebTransportDatagramDuplexStream = 18816,
  WebTransportError = 18849,
  WebTransportReceiveStream = 18867,
  WebTransportSendStream = 18893,
  WebrtcGlobalInformation = 18916,
  WheelEvent = 18940,
  Window = 18951,
  WindowClient = 18958,
  WindowContext = 18971,
  WindowGlobalChild = 18985,
  WindowGlobalParent = 19003,
  WindowRoot = 19022,
  Worker = 19033,
  WorkerDebuggerGlobalScope = 19040,
  WorkerGlobalScope = 19066,
  WorkerLocation = 19084,
  WorkerNavigator = 19099,
  WorkerTestUtils = 19115,
  Worklet = 19131,
  WorkletGlobalScope = 19139,
  WritableStream = 19158,
  WritableStreamDefaultController = 19173,
  WritableStreamDefaultWriter = 19205,
  XMLDocument = 19233,
  XMLHttpRequest = 19245,
  XMLHttpRequestEventTarget = 19260,
  XMLHttpRequestUpload = 19286,
  XMLSerializer = 19307,
  XPathEvaluator = 19321,
  XPathExpression = 19336,
  XPathResult = 19352,
  XRBoundedReferenceSpace = 19364,
  XRFrame = 19388,
  XRInputSource = 19396,
  XRInputSourceArray = 19410,
  XRInputSourceEvent = 19429,
  XRInputSourcesChangeEvent = 19448,
  XRPose = 19474,
  XRReferenceSpace = 19481,
  XRReferenceSpaceEvent = 19498,
  XRRenderState = 19520,
  XRRigidTransform = 19534,
  XRSession = 19551,
  XRSessionEvent = 19561,
  XRSpace = 19576,
  XRSystem = 19584,
  XRView = 19593,
  XRViewerPose = 19600,
  XRViewport = 19613,
  XRWebGLLayer = 19624,
  XSLTProcessor = 19637,
  XULCommandEvent = 19651,
  XULElement = 19667,
  XULFrameElement = 19678,
  XULMenuElement = 19694,
  XULPopupElement = 19709,
  XULResizerElement = 19725,
  XULTextElement = 19743,
  XULTreeElement = 19758,
  console = 19773,
  webkitSpeechGrammar = 19781,
  webkitSpeechGrammarList = 19801,
  webkitSpeechRecognition = 19825,
  webkitURL = 19849,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
