#ifdef GET_AccessQualifier_DECL
enum AccessQualifier {
  None = 3,
  ReadOnly = 0,
  ReadWrite = 2,
  WriteOnly = 1,
};
#endif

#ifdef GET_AddressingModel_DECL
enum AddressingModel {
  Logical = 0,
  Physical32 = 1,
  Physical64 = 2,
  PhysicalStorageBuffer64EXT = 5348,
};
#endif

#ifdef GET_BuiltIn_DECL
enum BuiltIn {
  BaryCoordNV = 5286,
  BaryCoordNoPerspAMD = 4492,
  BaryCoordNoPerspCentroidAMD = 4493,
  BaryCoordNoPerspNV = 5287,
  BaryCoordNoPerspSampleAMD = 4494,
  BaryCoordPullModel = 4498,
  BaryCoordSmoothAMD = 4495,
  BaryCoordSmoothCentroid = 4496,
  BaryCoordSmoothSample = 4497,
  BaseInstance = 4425,
  BaseVertex = 4424,
  ClipDistancePerViewNV = 5277,
  ClipDistanceVariable = 3,
  CullDistancePerViewNV = 5278,
  CullDistanceVariable = 4,
  DeviceIndex = 4438,
  DrawIndex = 4426,
  EnqueuedWorkgroupSize = 32,
  FragCoord = 15,
  FragDepth = 22,
  FragInvocationCountEXT = 5293,
  FragSizeEXT = 5292,
  FragStencilRefEXT = 5014,
  FrontFacing = 17,
  FullyCoveredEXT = 5264,
  GlobalInvocationId = 28,
  GlobalLinearId = 34,
  GlobalOffset = 33,
  GlobalSize = 31,
  HelperInvocation = 23,
  HitKindNV = 5333,
  HitTNV = 5332,
  IncomingRayFlagsNV = 5351,
  InstanceCustomIndexNV = 5327,
  InstanceId = 6,
  InstanceIndex = 43,
  InvocationId = 8,
  LaunchIdNV = 5319,
  LaunchSizeNV = 5320,
  Layer = 9,
  LayerPerViewNV = 5279,
  LocalInvocationId = 27,
  LocalInvocationIndex = 29,
  MeshViewCountNV = 5280,
  MeshViewIndices = 5281,
  NumEnqueuedSubgroups = 39,
  NumSubgroups = 38,
  NumWorkgroups = 24,
  ObjectRayDirectionNV = 5324,
  ObjectRayOriginNV = 5323,
  ObjectToWorldNV = 5330,
  PatchVertices = 14,
  PointCoord = 16,
  PointSize = 1,
  Position = 0,
  PositionPerViewNV = 5261,
  PrimitiveCountNV = 5275,
  PrimitiveId = 7,
  PrimitiveIndicesNV = 5276,
  RayTmaxNV = 5326,
  RayTminNV = 5325,
  SampleId = 18,
  SampleMask = 20,
  SamplePosition = 19,
  SecondaryPositionNV = 5257,
  SecondaryViewportMaskNV = 5258,
  SubgroupEqMask = 4416,
  SubgroupGeMask = 4417,
  SubgroupGtMask = 4418,
  SubgroupId = 40,
  SubgroupLeMask = 4419,
  SubgroupLocalInvocationId = 41,
  SubgroupLtMask = 4420,
  SubgroupMaxSize = 37,
  SubgroupSize = 36,
  TaskCountNV = 5274,
  TessCoord = 13,
  TessLevelInner = 12,
  TessLevelOuter = 11,
  VertexId = 5,
  VertexIndex = 42,
  ViewIndex = 4440,
  ViewportIndex = 10,
  ViewportMaskNV = 5253,
  ViewportMaskPerViewNV = 5262,
  WorkDim = 30,
  WorkgroupId = 26,
  WorkgroupSize = 25,
  WorldRayDirectionNV = 5322,
  WorldRayOriginNV = 5321,
  WorldToObjectNV = 5331,
};
#endif

#ifdef GET_BuiltinGroup_DECL
enum BuiltinGroup {
  AsyncCopy = 0,
  Atomic = 1,
  AtomicFloating = 2,
  Barrier = 3,
  CastToPtr = 4,
  Construct = 5,
  Convert = 6,
  CoopMatr = 7,
  Dot = 8,
  Enqueue = 9,
  Extended = 10,
  GetQuery = 11,
  Group = 12,
  GroupUniform = 13,
  ICarryBorrow = 14,
  ImageMiscQuery = 15,
  ImageSizeQuery = 16,
  IntelSubgroups = 17,
  KernelClock = 18,
  LoadStore = 19,
  ReadImage = 20,
  Relational = 21,
  SampleImage = 22,
  Select = 23,
  SpecConstant = 24,
  Variable = 25,
  VectorLoadStore = 26,
  Wave = 27,
  WriteImage = 28,
};
#endif

#ifdef GET_CLMemoryFenceFlags_DECL
enum CLMemoryFenceFlags {
  CLK_GLOBAL_MEM_FENCE = 2,
  CLK_IMAGE_MEM_FENCE = 4,
  CLK_LOCAL_MEM_FENCE = 1,
};
#endif

#ifdef GET_CLMemoryScope_DECL
enum CLMemoryScope {
  memory_scope_all_svm_devices = 3,
  memory_scope_device = 2,
  memory_scope_sub_group = 4,
  memory_scope_work_group = 1,
  memory_scope_work_item = 0,
};
#endif

#ifdef GET_CLSamplerAddressingMode_DECL
enum CLSamplerAddressingMode {
  CLK_ADDRESS_CLAMP = 4,
  CLK_ADDRESS_CLAMP_TO_EDGE = 2,
  CLK_ADDRESS_MIRRORED_REPEAT = 8,
  CLK_ADDRESS_MODE_MASK = 14,
  CLK_ADDRESS_NONE = 0,
  CLK_ADDRESS_REPEAT = 6,
  CLK_FILTER_LINEAR = 32,
  CLK_FILTER_NEAREST = 16,
  CLK_NORMALIZED_COORDS_FALSE = 0,
  CLK_NORMALIZED_COORDS_TRUE = 1,
};
#endif

#ifdef GET_Capability_DECL
enum Capability {
  Addresses = 4,
  ArbitraryPrecisionIntegersINTEL = 5844,
  ArithmeticFenceEXT = 6144,
  AsmINTEL = 5606,
  AtomicFloat16AddEXT = 6095,
  AtomicFloat16MinMaxEXT = 5616,
  AtomicFloat32AddEXT = 6033,
  AtomicFloat32MinMaxEXT = 5612,
  AtomicFloat64AddEXT = 6034,
  AtomicFloat64MinMaxEXT = 5613,
  AtomicStorage = 21,
  AtomicStorageOps = 4445,
  BFloat16ConversionINTEL = 6115,
  BitInstructions = 6025,
  CacheControlsINTEL = 6441,
  ClipDistance = 32,
  ComputeDerivativeGroupLinearNV = 5350,
  ComputeDerivativeGroupQuadsNV = 5288,
  CooperativeMatrixBFloat16ComponentTypeINTEL = 6437,
  CooperativeMatrixCheckedInstructionsINTEL = 6192,
  CooperativeMatrixInvocationInstructionsINTEL = 6435,
  CooperativeMatrixKHR = 6022,
  CooperativeMatrixNV = 5357,
  CooperativeMatrixPrefetchINTEL = 6411,
  CooperativeMatrixTF32ComponentTypeINTEL = 6436,
  CullDistance = 33,
  DemoteToHelperInvocation = 5379,
  DenormFlushToZero = 4465,
  DenormPreserve = 4464,
  DerivativeControl = 51,
  DeviceEnqueue = 19,
  DeviceGroup = 4437,
  DotProduct = 6019,
  DotProductInput4x8Bit = 6017,
  DotProductInput4x8BitPacked = 6018,
  DotProductInputAll = 6016,
  DrawParameters = 4427,
  ExpectAssumeKHR = 5629,
  Float16 = 9,
  Float16Buffer = 8,
  Float16ImageAMD = 5008,
  Float64 = 10,
  FloatingPointModeINTEL = 5583,
  FragmentBarycentricNV = 5284,
  FragmentDensityEXT = 5291,
  FragmentFullyCoveredEXT = 5265,
  FragmentMaskAMD = 5010,
  FunctionFloatControlINTEL = 5821,
  FunctionPointersINTEL = 5603,
  GenericPointer = 38,
  Geometry = 2,
  GeometryPointSize = 24,
  GeometryShaderPassthroughNV = 5251,
  GeometryStreams = 54,
  GlobalVariableFPGADecorationsINTEL = 6189,
  GlobalVariableHostAccessINTEL = 6187,
  GroupNonUniform = 61,
  GroupNonUniformArithmetic = 63,
  GroupNonUniformBallot = 64,
  GroupNonUniformClustered = 67,
  GroupNonUniformPartitionedNV = 5297,
  GroupNonUniformQuad = 68,
  GroupNonUniformRotateKHR = 6026,
  GroupNonUniformShuffle = 65,
  GroupNonUniformShuffleRelative = 66,
  GroupNonUniformVote = 62,
  GroupUniformArithmeticKHR = 6400,
  Groups = 18,
  HostAccessINTEL = 6188,
  Image1D = 44,
  ImageBasic = 13,
  ImageBuffer = 47,
  ImageCubeArray = 34,
  ImageFootprintNV = 5282,
  ImageGatherBiasLodAMD = 5009,
  ImageGatherExtended = 25,
  ImageMSArray = 48,
  ImageMipmap = 15,
  ImageQuery = 50,
  ImageReadWrite = 14,
  ImageReadWriteLodAMD = 5015,
  ImageRect = 36,
  IndirectReferencesINTEL = 5604,
  InputAttachment = 40,
  InputAttachmentArrayDynamicIndexingEXT = 5303,
  InputAttachmentArrayNonUniformIndexingEXT = 5310,
  Int8 = 39,
  Int16 = 22,
  Int64 = 11,
  Int64Atomics = 12,
  InterpolationFunction = 52,
  Kernel = 6,
  Linkage = 5,
  LiteralSampler = 20,
  Matrix = 0,
  MeshShadingNV = 5266,
  MinLod = 42,
  MultiView = 4439,
  MultiViewport = 57,
  NamedBarrier = 59,
  OptNoneEXT = 6094,
  OptNoneINTEL = 6094,
  PackedCooperativeMatrixINTEL = 6434,
  PerViewAttributesNV = 5260,
  PhysicalStorageBufferAddressesEXT = 5347,
  PipeStorage = 60,
  Pipes = 17,
  RayTracingNV = 5340,
  RoundToInfinityINTEL = 5582,
  RoundingModeRTE = 4467,
  RoundingModeRTZ = 4468,
  RuntimeDescriptorArrayEXT = 5302,
  SampleMaskOverrideCoverageNV = 5249,
  SampleMaskPostDepthCoverage = 4447,
  SampleRateShading = 35,
  Sampled1D = 43,
  SampledBuffer = 46,
  SampledCubeArray = 45,
  SampledImageArrayDynamicIndexing = 29,
  SampledImageArrayNonUniformIndexingEXT = 5307,
  SampledRect = 37,
  Shader = 1,
  ShaderClockKHR = 5055,
  ShaderNonUniformEXT = 5301,
  ShaderStereoViewNV = 5259,
  ShaderViewportIndexLayerEXT = 5254,
  ShaderViewportMaskNV = 5255,
  SignedZeroInfNanPreserve = 4466,
  SparseResidency = 41,
  SplitBarrierINTEL = 6141,
  StencilExportEXT = 5013,
  StorageBuffer8BitAccess = 4448,
  StorageBuffer16BitAccess = 4433,
  StorageBufferArrayDynamicIndexing = 30,
  StorageBufferArrayNonUniformIndexingEXT = 5308,
  StorageImageArrayDynamicIndexing = 31,
  StorageImageArrayNonUniformIndexingEXT = 5309,
  StorageImageExtendedFormats = 49,
  StorageImageMultisample = 27,
  StorageImageReadWithoutFormat = 55,
  StorageImageWriteWithoutFormat = 56,
  StorageInputOutput16 = 4436,
  StoragePushConstant8 = 4450,
  StoragePushConstant16 = 4435,
  StorageTexelBufferArrayDynamicIndexingEXT = 5305,
  StorageTexelBufferArrayNonUniformIndexingEXT = 5312,
  StorageUniform16 = 4434,
  SubgroupAvcMotionEstimationChromaINTEL = 5698,
  SubgroupAvcMotionEstimationINTEL = 5696,
  SubgroupAvcMotionEstimationIntraINTEL = 5697,
  SubgroupBallotKHR = 4423,
  SubgroupBufferBlockIOINTEL = 5569,
  SubgroupDispatch = 58,
  SubgroupImageBlockIOINTEL = 5570,
  SubgroupImageMediaBlockIOINTEL = 5579,
  SubgroupShuffleINTEL = 5568,
  SubgroupVoteKHR = 4431,
  Tessellation = 3,
  TessellationPointSize = 23,
  TransformFeedback = 53,
  USMStorageClassesINTEL = 5935,
  UniformAndStorageBuffer8BitAccess = 4449,
  UniformBufferArrayDynamicIndexing = 28,
  UniformBufferArrayNonUniformIndexingEXT = 5306,
  UniformTexelBufferArrayDynamicIndexingEXT = 5304,
  UniformTexelBufferArrayNonUniformIndexingEXT = 5311,
  VariableLengthArrayINTEL = 5817,
  VariablePointers = 4442,
  VariablePointersStorageBuffer = 4441,
  Vector16 = 7,
  VulkanMemoryModelDeviceScopeKHR = 5346,
  VulkanMemoryModelKHR = 5345,
};
#endif

#ifdef GET_CooperativeMatrixLayout_DECL
enum CooperativeMatrixLayout {
  RowMajorKHR = 0,
  ColumnMajorKHR = 1,
  PackedINTEL = 2,
};
#endif

#ifdef GET_CooperativeMatrixOperands_DECL
enum CooperativeMatrixOperands {
  NoneKHR = 0,
  MatrixASignedComponentsKHR = 1,
  MatrixBSignedComponentsKHR = 2,
  MatrixCSignedComponentsKHR = 4,
  MatrixResultSignedComponentsKHR = 8,
  SaturatingAccumulationKHR = 16,
  MatrixAAndBTF32ComponentsINTEL = 32,
  MatrixAAndBBFloat16ComponentsINTEL = 64,
  MatrixCBFloat16ComponentsINTEL = 128,
  MatrixResultBFloat16ComponentsINTEL = 256,
};
#endif

#ifdef GET_Decoration_DECL
enum Decoration {
  RelaxedPrecision = 0,
  SpecId = 1,
  Block = 2,
  BufferBlock = 3,
  RowMajor = 4,
  ColMajor = 5,
  ArrayStride = 6,
  MatrixStride = 7,
  GLSLShared = 8,
  GLSLPacked = 9,
  CPacked = 10,
  BuiltIn = 11,
  NoPerspective = 13,
  Flat = 14,
  Patch = 15,
  Centroid = 16,
  Sample = 17,
  Invariant = 18,
  Restrict = 19,
  Aliased = 20,
  Volatile = 21,
  Constant = 22,
  Coherent = 23,
  NonWritable = 24,
  NonReadable = 25,
  Uniform = 26,
  UniformId = 27,
  SaturatedConversion = 28,
  Stream = 29,
  Location = 30,
  Component = 31,
  Index = 32,
  Binding = 33,
  DescriptorSet = 34,
  Offset = 35,
  XfbBuffer = 36,
  XfbStride = 37,
  FuncParamAttr = 38,
  FPRoundingMode = 39,
  FPFastMathMode = 40,
  LinkageAttributes = 41,
  NoContraction = 42,
  InputAttachmentIndex = 43,
  Alignment = 44,
  MaxByteOffset = 45,
  AlignmentId = 46,
  MaxByteOffsetId = 47,
  NoSignedWrap = 4469,
  NoUnsignedWrap = 4470,
  ExplicitInterpAMD = 4999,
  OverrideCoverageNV = 5248,
  PassthroughNV = 5250,
  ViewportRelativeNV = 5252,
  SecondaryViewportRelativeNV = 5256,
  PerPrimitiveNV = 5271,
  PerViewNV = 5272,
  PerVertexNV = 5273,
  NonUniformEXT = 5300,
  CountBuffer = 5634,
  UserSemantic = 5635,
  RestrictPointerEXT = 5355,
  AliasedPointerEXT = 5356,
  ReferencedIndirectlyINTEL = 5602,
  ClobberINTEL = 5607,
  SideEffectsINTEL = 5608,
  ArgumentAttributeINTEL = 6409,
  CacheControlLoadINTEL = 6442,
  CacheControlStoreINTEL = 6443,
  HostAccessINTEL = 6188,
  InitModeINTEL = 6190,
  ImplementInRegisterMapINTEL = 6191,
  FunctionRoundingModeINTEL = 5822,
  FunctionDenormModeINTEL = 5823,
  FunctionFloatingPointModeINTEL = 6080,
};
#endif

#ifdef GET_Dim_DECL
enum Dim {
  DIM_1D = 0,
  DIM_2D = 1,
  DIM_3D = 2,
  DIM_Buffer = 5,
  DIM_Cube = 3,
  DIM_Rect = 4,
  DIM_SubpassData = 6,
};
#endif

#ifdef GET_ExecutionMode_DECL
enum ExecutionMode {
  Invocations = 0,
  SpacingEqual = 1,
  SpacingFractionalEven = 2,
  SpacingFractionalOdd = 3,
  VertexOrderCw = 4,
  VertexOrderCcw = 5,
  PixelCenterInteger = 6,
  OriginUpperLeft = 7,
  OriginLowerLeft = 8,
  EarlyFragmentTests = 9,
  PointMode = 10,
  Xfb = 11,
  DepthReplacing = 12,
  DepthGreater = 14,
  DepthLess = 15,
  DepthUnchanged = 16,
  LocalSize = 17,
  LocalSizeHint = 18,
  InputPoints = 19,
  InputLines = 20,
  InputLinesAdjacency = 21,
  Triangles = 22,
  InputTrianglesAdjacency = 23,
  Quads = 24,
  Isolines = 25,
  OutputVertices = 26,
  OutputPoints = 27,
  OutputLineStrip = 28,
  OutputTriangleStrip = 29,
  VecTypeHint = 30,
  ContractionOff = 31,
  Initializer = 33,
  Finalizer = 34,
  SubgroupSize = 35,
  SubgroupsPerWorkgroup = 36,
  SubgroupsPerWorkgroupId = 37,
  LocalSizeId = 38,
  LocalSizeHintId = 39,
  PostDepthCoverage = 4446,
  DenormPreserve = 4459,
  DenormFlushToZero = 4460,
  SignedZeroInfNanPreserve = 4461,
  RoundingModeRTE = 4462,
  RoundingModeRTZ = 4463,
  StencilRefReplacingEXT = 5027,
  OutputLinesNV = 5269,
  DerivativeGroupQuadsNV = 5289,
  DerivativeGroupLinearNV = 5290,
  OutputTrianglesNV = 5298,
  RoundingModeRTPINTEL = 5620,
  RoundingModeRTNINTEL = 5621,
  FloatingPointModeALTINTEL = 5622,
  FloatingPointModeIEEEINTEL = 5623,
};
#endif

#ifdef GET_ExecutionModel_DECL
enum ExecutionModel {
  Vertex = 0,
  TessellationControl = 1,
  TessellationEvaluation = 2,
  Geometry = 3,
  Fragment = 4,
  GLCompute = 5,
  Kernel = 6,
  TaskNV = 5267,
  MeshNV = 5268,
  RayGenerationNV = 5313,
  IntersectionNV = 5314,
  AnyHitNV = 5315,
  ClosestHitNV = 5316,
  MissNV = 5317,
  CallableNV = 5318,
};
#endif

#ifdef GET_Extension_DECL
enum Extension {
  SPV_AMD_gcn_shader = 3,
  SPV_AMD_gpu_shader_half_float = 6,
  SPV_AMD_gpu_shader_half_float_fetch = 28,
  SPV_AMD_gpu_shader_int16 = 20,
  SPV_AMD_shader_ballot = 5,
  SPV_AMD_shader_explicit_vertex_parameter = 1,
  SPV_AMD_shader_fragment_mask = 26,
  SPV_AMD_shader_image_load_store_lod = 25,
  SPV_AMD_shader_trinary_minmax_extension = 2,
  SPV_AMD_texture_gather_bias_lod = 17,
  SPV_ARM_core_builtins = 97,
  SPV_EXT_arithmetic_fence = 112,
  SPV_EXT_demote_to_helper_invocation = 56,
  SPV_EXT_descriptor_indexing = 32,
  SPV_EXT_fragment_fully_covered = 27,
  SPV_EXT_fragment_invocation_density = 44,
  SPV_EXT_fragment_shader_interlock = 52,
  SPV_EXT_mesh_shader = 96,
  SPV_EXT_opacity_micromap = 98,
  SPV_EXT_optnone = 113,
  SPV_EXT_physical_storage_buffer = 47,
  SPV_EXT_relaxed_printf_string_address_space = 94,
  SPV_EXT_shader_atomic_float16_add = 85,
  SPV_EXT_shader_atomic_float_add = 68,
  SPV_EXT_shader_atomic_float_min_max = 75,
  SPV_EXT_shader_image_int64 = 71,
  SPV_EXT_shader_stencil_export = 23,
  SPV_EXT_shader_viewport_index_layer = 24,
  SPV_EXT_ycbcr_attachments = 95,
  SPV_GOOGLE_decorate_string = 29,
  SPV_GOOGLE_hlsl_functionality1 = 30,
  SPV_GOOGLE_user_type = 59,
  SPV_HUAWEI_subpass_shading = 83,
  SPV_INTEL_arbitrary_precision_integers = 67,
  SPV_INTEL_bfloat16_conversion = 106,
  SPV_INTEL_blocking_pipes = 58,
  SPV_INTEL_cache_controls = 108,
  SPV_INTEL_float_controls2 = 115,
  SPV_INTEL_fp_fast_math_mode = 72,
  SPV_INTEL_fpga_argument_interfaces = 102,
  SPV_INTEL_fpga_cluster_attributes = 73,
  SPV_INTEL_fpga_dsp_control = 79,
  SPV_INTEL_fpga_invocation_pipelining_attributes = 81,
  SPV_INTEL_fpga_latency_control = 101,
  SPV_INTEL_fpga_loop_controls = 51,
  SPV_INTEL_fpga_memory_accesses = 66,
  SPV_INTEL_fpga_memory_attributes = 48,
  SPV_INTEL_fpga_reg = 57,
  SPV_INTEL_function_pointers = 104,
  SPV_INTEL_global_variable_fpga_decorations = 110,
  SPV_INTEL_global_variable_host_access = 109,
  SPV_INTEL_inline_assembly = 107,
  SPV_INTEL_io_pipes = 63,
  SPV_INTEL_joint_matrix = 114,
  SPV_INTEL_kernel_attributes = 61,
  SPV_INTEL_loop_fuse = 74,
  SPV_INTEL_media_block_io = 42,
  SPV_INTEL_optnone = 103,
  SPV_INTEL_runtime_aligned = 86,
  SPV_INTEL_shader_integer_functions2 = 50,
  SPV_INTEL_split_barrier = 91,
  SPV_INTEL_subgroups = 41,
  SPV_INTEL_unstructured_loop_controls = 55,
  SPV_INTEL_usm_storage_classes = 100,
  SPV_INTEL_variable_length_array = 105,
  SPV_KHR_8bit_storage = 33,
  SPV_KHR_16bit_storage = 9,
  SPV_KHR_bit_instructions = 87,
  SPV_KHR_cooperative_matrix = 111,
  SPV_KHR_device_group = 10,
  SPV_KHR_expect_assume = 78,
  SPV_KHR_float_controls = 46,
  SPV_KHR_fragment_shader_barycentric = 93,
  SPV_KHR_fragment_shading_rate = 70,
  SPV_KHR_integer_dot_product = 84,
  SPV_KHR_linkonce_odr = 77,
  SPV_KHR_multiview = 11,
  SPV_KHR_no_integer_wrap_decoration = 45,
  SPV_KHR_non_semantic_info = 62,
  SPV_KHR_physical_storage_buffer = 60,
  SPV_KHR_post_depth_coverage = 21,
  SPV_KHR_ray_cull_mask = 92,
  SPV_KHR_ray_query = 65,
  SPV_KHR_ray_tracing = 64,
  SPV_KHR_shader_atomic_counter_ops = 22,
  SPV_KHR_shader_ballot = 4,
  SPV_KHR_shader_clock = 54,
  SPV_KHR_shader_draw_parameters = 7,
  SPV_KHR_storage_buffer_storage_class = 18,
  SPV_KHR_subgroup_rotate = 90,
  SPV_KHR_subgroup_uniform_control_flow = 82,
  SPV_KHR_subgroup_vote = 8,
  SPV_KHR_terminate_invocation = 69,
  SPV_KHR_uniform_group_instructions = 89,
  SPV_KHR_variable_pointers = 19,
  SPV_KHR_vulkan_memory_model = 34,
  SPV_KHR_workgroup_memory_explicit_layout = 76,
  SPV_NVX_multiview_per_view_attributes = 12,
  SPV_NV_bindless_texture = 80,
  SPV_NV_compute_shader_derivatives = 36,
  SPV_NV_cooperative_matrix = 49,
  SPV_NV_fragment_shader_barycentric = 37,
  SPV_NV_geometry_shader_passthrough = 16,
  SPV_NV_mesh_shader = 38,
  SPV_NV_ray_tracing = 35,
  SPV_NV_ray_tracing_motion_blur = 88,
  SPV_NV_sample_mask_override_coverage = 15,
  SPV_NV_shader_image_footprint = 39,
  SPV_NV_shader_invocation_reorder = 99,
  SPV_NV_shader_sm_builtins = 53,
  SPV_NV_shader_subgroup_partitioned = 31,
  SPV_NV_shading_rate = 40,
  SPV_NV_stereo_view_rendering = 14,
  SPV_NV_viewport_array2 = 13,
};
#endif

#ifdef GET_FPFastMathMode_DECL
enum FPFastMathMode {
  None = 0,
  NotNaN = 1,
  NotInf = 2,
  NSZ = 4,
  AllowRecip = 8,
  Fast = 16,
};
#endif

#ifdef GET_FPRoundingMode_DECL
enum FPRoundingMode {
  RTE = 0,
  RTN = 3,
  RTP = 2,
  RTZ = 1,
};
#endif

#ifdef GET_FunctionControl_DECL
enum FunctionControl {
  None = 0,
  Inline = 1,
  DontInline = 2,
  Pure = 4,
  Const = 8,
  OptNoneEXT = 65536,
};
#endif

#ifdef GET_FunctionParameterAttribute_DECL
enum FunctionParameterAttribute {
  Zext = 0,
  Sext = 1,
  ByVal = 2,
  Sret = 3,
  NoAlias = 4,
  NoCapture = 5,
  NoWrite = 6,
  NoReadWrite = 7,
};
#endif

#ifdef GET_GLSLExtInst_DECL
enum GLSLExtInst {
  Round = 1,
  RoundEven = 2,
  Trunc = 3,
  FAbs = 4,
  SAbs = 5,
  FSign = 6,
  SSign = 7,
  Floor = 8,
  Ceil = 9,
  Fract = 10,
  Radians = 11,
  Degrees = 12,
  Sin = 13,
  Cos = 14,
  Tan = 15,
  Asin = 16,
  Acos = 17,
  Atan = 18,
  Sinh = 19,
  Cosh = 20,
  Tanh = 21,
  Asinh = 22,
  Acosh = 23,
  Atanh = 24,
  Atan2 = 25,
  Pow = 26,
  Exp = 27,
  Log = 28,
  Exp2 = 29,
  Log2 = 30,
  Sqrt = 31,
  InverseSqrt = 32,
  Determinant = 33,
  MatrixInverse = 34,
  Modf = 35,
  ModfStruct = 36,
  FMin = 37,
  UMin = 38,
  SMin = 39,
  FMax = 40,
  UMax = 41,
  SMax = 42,
  FClamp = 43,
  UClamp = 44,
  SClamp = 45,
  FMix = 46,
  Step = 48,
  SmoothStep = 49,
  Fma = 50,
  Frexp = 51,
  FrexpStruct = 52,
  Ldexp = 53,
  PackSnorm4x8 = 54,
  PackUnorm4x8 = 55,
  PackSnorm2x16 = 56,
  PackUnorm2x16 = 57,
  PackHalf2x16 = 58,
  PackDouble2x32 = 59,
  UnpackSnorm2x16 = 60,
  UnpackUnorm2x16 = 61,
  UnpackHalf2x16 = 62,
  UnpackSnorm4x8 = 63,
  UnpackUnorm4x8 = 64,
  UnpackDouble2x32 = 65,
  Length = 66,
  Distance = 67,
  Cross = 68,
  Normalize = 69,
  FaceForward = 70,
  Reflect = 71,
  Refract = 72,
  FindILsb = 73,
  FindSMsb = 74,
  FindUMsb = 75,
  InterpolateAtCentroid = 76,
  InterpolateAtSample = 77,
  InterpolateAtOffset = 78,
  NMin = 79,
  NMax = 80,
  NClamp = 81,
};
#endif

#ifdef GET_GroupOperation_DECL
enum GroupOperation {
  ClusteredReduce = 3,
  ExclusiveScan = 2,
  InclusiveScan = 1,
  PartitionedExclusiveScanNV = 8,
  PartitionedInclusiveScanNV = 7,
  PartitionedReduceNV = 6,
  Reduce = 0,
};
#endif

#ifdef GET_ImageChannelDataType_DECL
enum ImageChannelDataType {
  SnormInt8 = 0,
  SnormInt16 = 1,
  UnormInt8 = 2,
  UnormInt16 = 3,
  UnormShort565 = 4,
  UnormShort555 = 5,
  UnormInt101010 = 6,
  SignedInt8 = 7,
  SignedInt16 = 8,
  SignedInt32 = 9,
  UnsignedInt8 = 10,
  UnsignedInt16 = 11,
  UnsigendInt32 = 12,
  HalfFloat = 13,
  Float = 14,
  UnormInt24 = 15,
  UnormInt101010_2 = 16,
};
#endif

#ifdef GET_ImageChannelOrder_DECL
enum ImageChannelOrder {
  R = 0,
  A = 1,
  RG = 2,
  RA = 3,
  RGB = 4,
  RGBA = 5,
  BGRA = 6,
  ARGB = 7,
  Intensity = 8,
  Luminance = 9,
  Rx = 10,
  RGx = 11,
  RGBx = 12,
  Depth = 13,
  DepthStencil = 14,
  sRGB = 15,
  sRGBx = 16,
  sRGBA = 17,
  sBGRA = 18,
  ABGR = 19,
};
#endif

#ifdef GET_ImageFormat_DECL
enum ImageFormat {
  R8 = 15,
  R8Snorm = 20,
  R8i = 29,
  R8ui = 39,
  R11fG11fB10f = 8,
  R16 = 14,
  R16Snorm = 19,
  R16f = 9,
  R16i = 28,
  R16ui = 38,
  R32f = 3,
  R32i = 24,
  R32ui = 33,
  Rg8 = 13,
  Rg8Snorm = 18,
  Rg8i = 27,
  Rg8ui = 37,
  Rg16 = 12,
  Rg16Snorm = 17,
  Rg16f = 7,
  Rg16i = 26,
  Rg16ui = 36,
  Rg32f = 6,
  Rg32i = 25,
  Rg32ui = 35,
  Rgb10A2 = 11,
  Rgb10a2ui = 34,
  Rgba8 = 4,
  Rgba8Snorm = 5,
  Rgba8i = 23,
  Rgba8ui = 32,
  Rgba16 = 10,
  Rgba16Snorm = 16,
  Rgba16f = 2,
  Rgba16i = 22,
  Rgba16ui = 31,
  Rgba32f = 1,
  Rgba32i = 21,
  Rgba32ui = 30,
  Unknown = 0,
};
#endif

#ifdef GET_ImageOperand_DECL
enum ImageOperand {
  None = 0,
  Bias = 1,
  Lod = 2,
  Grad = 4,
  ConstOffset = 8,
  Offset = 16,
  ConstOffsets = 32,
  Sample = 64,
  MinLod = 128,
  MakeTexelAvailableKHR = 256,
  MakeTexelVisibleKHR = 512,
  NonPrivateTexelKHR = 1024,
  VolatileTexelKHR = 2048,
  SignExtend = 4096,
  ZeroExtend = 8192,
};
#endif

#ifdef GET_InstructionSet_DECL
enum InstructionSet {
  GLSL_std_450 = 1,
  NonSemantic_Shader_DebugInfo_100 = 3,
  OpenCL_std = 0,
  SPV_AMD_shader_trinary_minmax = 2,
};
#endif

#ifdef GET_KernelEnqueueFlags_DECL
enum KernelEnqueueFlags {
  NoWait = 0,
  WaitKernel = 1,
  WaitWorkGroup = 2,
};
#endif

#ifdef GET_KernelProfilingInfo_DECL
enum KernelProfilingInfo {
  None = 0,
  CmdExecTime = 1,
};
#endif

#ifdef GET_LinkageType_DECL
enum LinkageType {
  Export = 0,
  Import = 1,
  LinkOnceODR = 2,
};
#endif

#ifdef GET_LoopControl_DECL
enum LoopControl {
  None = 0,
  Unroll = 1,
  DontUnroll = 2,
  DependencyInfinite = 4,
  DependencyLength = 8,
  MinIterations = 16,
  MaxIterations = 32,
  IterationMultiple = 64,
  PeelCount = 128,
  PartialCount = 256,
};
#endif

#ifdef GET_MemoryModel_DECL
enum MemoryModel {
  Simple = 0,
  GLSL450 = 1,
  OpenCL = 2,
  VulkanKHR = 3,
};
#endif

#ifdef GET_MemoryOperand_DECL
enum MemoryOperand {
  None = 0,
  Volatile = 1,
  Aligned = 2,
  Nontemporal = 4,
  MakePointerAvailableKHR = 8,
  MakePointerVisibleKHR = 16,
  NonPrivatePointerKHR = 32,
};
#endif

#ifdef GET_MemorySemantics_DECL
enum MemorySemantics {
  None = 0,
  Acquire = 2,
  Release = 4,
  AcquireRelease = 8,
  SequentiallyConsistent = 16,
  UniformMemory = 64,
  SubgroupMemory = 128,
  WorkgroupMemory = 256,
  CrossWorkgroupMemory = 512,
  AtomicCounterMemory = 1024,
  ImageMemory = 2048,
  OutputMemoryKHR = 4096,
  MakeAvailableKHR = 8192,
  MakeVisibleKHR = 16384,
};
#endif

#ifdef GET_NonSemanticExtInst_DECL
enum NonSemanticExtInst {
  DebugInfoNone = 0,
  DebugCompilationUnit = 1,
  DebugTypeBasic = 2,
  DebugTypePointer = 3,
  DebugTypeQualifier = 4,
  DebugTypeArray = 5,
  DebugTypeVector = 6,
  DebugTypedef = 7,
  DebugTypeFunction = 8,
  DebugTypeEnum = 9,
  DebugTypeComposite = 10,
  DebugTypeMember = 11,
  DebugTypeInheritance = 12,
  DebugTypePtrToMember = 13,
  DebugTypeTemplate = 14,
  DebugTypeTemplateParameter = 15,
  DebugTypeTemplateTemplateParameter = 16,
  DebugTypeTemplateParameterPack = 17,
  DebugGlobalVariable = 18,
  DebugFunctionDeclaration = 19,
  DebugFunction = 20,
  DebugLexicalBlock = 21,
  DebugLexicalBlockDiscriminator = 22,
  DebugScope = 23,
  DebugNoScope = 24,
  DebugInlinedAt = 25,
  DebugLocalVariable = 26,
  DebugInlinedVariable = 27,
  DebugDeclare = 28,
  DebugValue = 29,
  DebugOperation = 30,
  DebugExpression = 31,
  DebugMacroDef = 32,
  DebugMacroUndef = 33,
  DebugImportedEntity = 34,
  DebugSource = 35,
  DebugFunctionDefinition = 101,
  DebugSourceContinued = 102,
  DebugLine = 103,
  DebugNoLine = 104,
  DebugBuildIdentifier = 105,
  DebugStoragePath = 106,
  DebugEntryPoint = 107,
  DebugTypeMatrix = 108,
};
#endif

#ifdef GET_Opcode_DECL
enum Opcode {
  InBoundsAccessChain = 66,
  InBoundsPtrAccessChain = 70,
  PtrCastToGeneric = 121,
  GenericCastToPtr = 122,
  Bitcast = 124,
  ConvertPtrToU = 117,
  ConvertUToPtr = 120,
};
#endif

#ifdef GET_OpenCLExtInst_DECL
enum OpenCLExtInst {
  acos = 0,
  acosh = 1,
  acospi = 2,
  asin = 3,
  asinh = 4,
  asinpi = 5,
  atan = 6,
  atan2 = 7,
  atanh = 8,
  atanpi = 9,
  atan2pi = 10,
  cbrt = 11,
  ceil = 12,
  copysign = 13,
  cos = 14,
  cosh = 15,
  cospi = 16,
  erfc = 17,
  erf = 18,
  exp = 19,
  exp2 = 20,
  exp10 = 21,
  expm1 = 22,
  fabs = 23,
  fdim = 24,
  floor = 25,
  fma = 26,
  fmax = 27,
  fmin = 28,
  fmod = 29,
  fract = 30,
  frexp = 31,
  hypot = 32,
  ilogb = 33,
  ldexp = 34,
  lgamma = 35,
  lgamma_r = 36,
  log = 37,
  log2 = 38,
  log10 = 39,
  log1p = 40,
  logb = 41,
  mad = 42,
  maxmag = 43,
  minmag = 44,
  modf = 45,
  nan = 46,
  nextafter = 47,
  pow = 48,
  pown = 49,
  powr = 50,
  remainder = 51,
  remquo = 52,
  rint = 53,
  rootn = 54,
  round = 55,
  rsqrt = 56,
  sin = 57,
  sincos = 58,
  sinh = 59,
  sinpi = 60,
  sqrt = 61,
  tan = 62,
  tanh = 63,
  tanpi = 64,
  tgamma = 65,
  trunc = 66,
  half_cos = 67,
  half_divide = 68,
  half_exp = 69,
  half_exp2 = 70,
  half_exp10 = 71,
  half_log = 72,
  half_log2 = 73,
  half_log10 = 74,
  half_powr = 75,
  half_recip = 76,
  half_rsqrt = 77,
  half_sin = 78,
  half_sqrt = 79,
  half_tan = 80,
  native_cos = 81,
  native_divide = 82,
  native_exp = 83,
  native_exp2 = 84,
  native_exp10 = 85,
  native_log = 86,
  native_log2 = 87,
  native_log10 = 88,
  native_powr = 89,
  native_recip = 90,
  native_rsqrt = 91,
  native_sin = 92,
  native_sqrt = 93,
  native_tan = 94,
  s_abs = 141,
  s_abs_diff = 142,
  s_add_sat = 143,
  u_add_sat = 144,
  s_hadd = 145,
  u_hadd = 146,
  s_rhadd = 147,
  u_rhadd = 148,
  s_clamp = 149,
  u_clamp = 150,
  clz = 151,
  ctz = 152,
  s_mad_hi = 153,
  u_mad_sat = 154,
  s_mad_sat = 155,
  s_max = 156,
  u_max = 157,
  s_min = 158,
  u_min = 159,
  s_mul_hi = 160,
  rotate = 161,
  s_sub_sat = 162,
  u_sub_sat = 163,
  u_upsample = 164,
  s_upsample = 165,
  popcount = 166,
  s_mad24 = 167,
  u_mad24 = 168,
  s_mul24 = 169,
  u_mul24 = 170,
  u_abs = 201,
  u_abs_diff = 202,
  u_mul_hi = 203,
  u_mad_hi = 204,
  fclamp = 95,
  degrees = 96,
  fmax_common = 97,
  fmin_common = 98,
  mix = 99,
  radians = 100,
  step = 101,
  smoothstep = 102,
  sign = 103,
  cross = 104,
  distance = 105,
  length = 106,
  normalize = 107,
  fast_distance = 108,
  fast_length = 109,
  fast_normalize = 110,
  bitselect = 186,
  select = 187,
  vloadn = 171,
  vstoren = 172,
  vload_half = 173,
  vload_halfn = 174,
  vstore_half = 175,
  vstore_half_r = 176,
  vstore_halfn = 177,
  vstore_halfn_r = 178,
  vloada_halfn = 179,
  vstorea_halfn = 180,
  vstorea_halfn_r = 181,
  shuffle = 182,
  shuffle2 = 183,
  printf = 184,
  prefetch = 185,
};
#endif

#ifdef GET_OperandCategory_DECL
enum OperandCategory {
  AccessQualifierOperand = 0,
  AddressingModelOperand = 1,
  BuiltInOperand = 2,
  CapabilityOperand = 3,
  CooperativeMatrixLayoutOperand = 4,
  CooperativeMatrixOperandsOperand = 5,
  DecorationOperand = 6,
  DimOperand = 7,
  ExecutionModeOperand = 8,
  ExecutionModelOperand = 9,
  ExtensionOperand = 10,
  FPFastMathModeOperand = 11,
  FPRoundingModeOperand = 12,
  FunctionControlOperand = 13,
  FunctionParameterAttributeOperand = 14,
  GroupOperationOperand = 15,
  ImageChannelDataTypeOperand = 16,
  ImageChannelOrderOperand = 17,
  ImageFormatOperand = 18,
  ImageOperandOperand = 19,
  KernelEnqueueFlagsOperand = 20,
  KernelProfilingInfoOperand = 21,
  LinkageTypeOperand = 22,
  LoopControlOperand = 23,
  MemoryModelOperand = 24,
  MemoryOperandOperand = 25,
  MemorySemanticsOperand = 26,
  OpcodeOperand = 27,
  SamplerAddressingModeOperand = 28,
  SamplerFilterModeOperand = 29,
  ScopeOperand = 30,
  SelectionControlOperand = 31,
  SourceLanguageOperand = 32,
  StorageClassOperand = 33,
};
#endif

#ifdef GET_SamplerAddressingMode_DECL
enum SamplerAddressingMode {
  None = 0,
  ClampToEdge = 1,
  Clamp = 2,
  Repeat = 3,
  RepeatMirrored = 4,
};
#endif

#ifdef GET_SamplerFilterMode_DECL
enum SamplerFilterMode {
  Nearest = 0,
  Linear = 1,
};
#endif

#ifdef GET_Scope_DECL
enum Scope {
  CrossDevice = 0,
  Device = 1,
  Workgroup = 2,
  Subgroup = 3,
  Invocation = 4,
  QueueFamilyKHR = 5,
};
#endif

#ifdef GET_SelectionControl_DECL
enum SelectionControl {
  None = 0,
  Flatten = 1,
  DontFlatten = 2,
};
#endif

#ifdef GET_SourceLanguage_DECL
enum SourceLanguage {
  Unknown = 0,
  ESSL = 1,
  GLSL = 2,
  OpenCL_C = 3,
  OpenCL_CPP = 4,
  HLSL = 5,
};
#endif

#ifdef GET_StorageClass_DECL
enum StorageClass {
  UniformConstant = 0,
  Input = 1,
  Uniform = 2,
  Output = 3,
  Workgroup = 4,
  CrossWorkgroup = 5,
  Private = 6,
  Function = 7,
  Generic = 8,
  PushConstant = 9,
  AtomicCounter = 10,
  Image = 11,
  StorageBuffer = 12,
  CallableDataNV = 5328,
  IncomingCallableDataNV = 5329,
  RayPayloadNV = 5338,
  HitAttributeNV = 5339,
  IncomingRayPayloadNV = 5342,
  ShaderRecordBufferNV = 5343,
  PhysicalStorageBufferEXT = 5349,
  CodeSectionINTEL = 5605,
  DeviceOnlyINTEL = 5936,
  HostOnlyINTEL = 5937,
};
#endif

#ifdef GET_AtomicFloatingBuiltins_DECL
const AtomicFloatingBuiltin *lookupAtomicFloatingBuiltin(StringRef Name);
#endif

#ifdef GET_AtomicFloatingBuiltins_IMPL
constexpr AtomicFloatingBuiltin AtomicFloatingBuiltins[] = {
  { "__spirv_AtomicFAddEXT", OpAtomicFAddEXT }, // 0
  { "__spirv_AtomicFMaxEXT", OpAtomicFMaxEXT }, // 1
  { "__spirv_AtomicFMinEXT", OpAtomicFMinEXT }, // 2
 };

const AtomicFloatingBuiltin *lookupAtomicFloatingBuiltin(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "__SPIRV_ATOMICFADDEXT", 0 },
    { "__SPIRV_ATOMICFMAXEXT", 1 },
    { "__SPIRV_ATOMICFMINEXT", 2 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;

  return &AtomicFloatingBuiltins[Idx->_index];
}
#endif

#ifdef GET_BuiltinTypes_DECL
const BuiltinType *lookupBuiltinType(StringRef Name);
#endif

#ifdef GET_BuiltinTypes_IMPL
constexpr BuiltinType BuiltinTypes[] = {
  { "spirv.CooperativeMatrixKHR", OpTypeCooperativeMatrixKHR }, // 0
  { "spirv.DeviceEvent", OpTypeDeviceEvent }, // 1
  { "spirv.Event", OpTypeEvent }, // 2
  { "spirv.Image", OpTypeImage }, // 3
  { "spirv.Pipe", OpTypePipe }, // 4
  { "spirv.PipeStorage", OpTypePipeStorage }, // 5
  { "spirv.Queue", OpTypeQueue }, // 6
  { "spirv.ReserveId", OpTypeReserveId }, // 7
  { "spirv.SampledImage", OpTypeSampledImage }, // 8
  { "spirv.Sampler", OpTypeSampler }, // 9
 };

const BuiltinType *lookupBuiltinType(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "SPIRV.COOPERATIVEMATRIXKHR", 0 },
    { "SPIRV.DEVICEEVENT", 1 },
    { "SPIRV.EVENT", 2 },
    { "SPIRV.IMAGE", 3 },
    { "SPIRV.PIPE", 4 },
    { "SPIRV.PIPESTORAGE", 5 },
    { "SPIRV.QUEUE", 6 },
    { "SPIRV.RESERVEID", 7 },
    { "SPIRV.SAMPLEDIMAGE", 8 },
    { "SPIRV.SAMPLER", 9 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;

  return &BuiltinTypes[Idx->_index];
}
#endif

#ifdef GET_CapabilityEntries_DECL
const CapabilityEntry *lookupCapabilityByCategoryAndValue(unsigned Category, uint32_t Value);
#endif

#ifdef GET_CapabilityEntries_IMPL
constexpr CapabilityEntry CapabilityEntries[] = {
  { AccessQualifierOperand, 0x0, Kernel }, // 0
  { AccessQualifierOperand, 0x1, Kernel }, // 1
  { AccessQualifierOperand, 0x2, Kernel }, // 2
  { AddressingModelOperand, 0x1, Addresses }, // 3
  { AddressingModelOperand, 0x2, Addresses }, // 4
  { AddressingModelOperand, 0x14E4, PhysicalStorageBufferAddressesEXT }, // 5
  { BuiltInOperand, 0x0, Shader }, // 6
  { BuiltInOperand, 0x1, Shader }, // 7
  { BuiltInOperand, 0x3, ClipDistance }, // 8
  { BuiltInOperand, 0x4, CullDistance }, // 9
  { BuiltInOperand, 0x5, Shader }, // 10
  { BuiltInOperand, 0x6, Shader }, // 11
  { BuiltInOperand, 0x7, Geometry }, // 12
  { BuiltInOperand, 0x7, Tessellation }, // 13
  { BuiltInOperand, 0x7, RayTracingNV }, // 14
  { BuiltInOperand, 0x8, Geometry }, // 15
  { BuiltInOperand, 0x8, Tessellation }, // 16
  { BuiltInOperand, 0x9, Geometry }, // 17
  { BuiltInOperand, 0xA, MultiViewport }, // 18
  { BuiltInOperand, 0xB, Tessellation }, // 19
  { BuiltInOperand, 0xC, Tessellation }, // 20
  { BuiltInOperand, 0xD, Tessellation }, // 21
  { BuiltInOperand, 0xE, Tessellation }, // 22
  { BuiltInOperand, 0xF, Shader }, // 23
  { BuiltInOperand, 0x10, Shader }, // 24
  { BuiltInOperand, 0x11, Shader }, // 25
  { BuiltInOperand, 0x12, SampleRateShading }, // 26
  { BuiltInOperand, 0x13, SampleRateShading }, // 27
  { BuiltInOperand, 0x14, Shader }, // 28
  { BuiltInOperand, 0x16, Shader }, // 29
  { BuiltInOperand, 0x17, Shader }, // 30
  { BuiltInOperand, 0x1E, Kernel }, // 31
  { BuiltInOperand, 0x1F, Kernel }, // 32
  { BuiltInOperand, 0x20, Kernel }, // 33
  { BuiltInOperand, 0x21, Kernel }, // 34
  { BuiltInOperand, 0x22, Kernel }, // 35
  { BuiltInOperand, 0x24, Kernel }, // 36
  { BuiltInOperand, 0x24, GroupNonUniform }, // 37
  { BuiltInOperand, 0x24, SubgroupBallotKHR }, // 38
  { BuiltInOperand, 0x25, Kernel }, // 39
  { BuiltInOperand, 0x26, Kernel }, // 40
  { BuiltInOperand, 0x26, GroupNonUniform }, // 41
  { BuiltInOperand, 0x27, Kernel }, // 42
  { BuiltInOperand, 0x28, Kernel }, // 43
  { BuiltInOperand, 0x28, GroupNonUniform }, // 44
  { BuiltInOperand, 0x29, Kernel }, // 45
  { BuiltInOperand, 0x29, GroupNonUniform }, // 46
  { BuiltInOperand, 0x29, SubgroupBallotKHR }, // 47
  { BuiltInOperand, 0x2A, Shader }, // 48
  { BuiltInOperand, 0x2B, Shader }, // 49
  { BuiltInOperand, 0x1140, GroupNonUniformBallot }, // 50
  { BuiltInOperand, 0x1140, SubgroupBallotKHR }, // 51
  { BuiltInOperand, 0x1141, GroupNonUniformBallot }, // 52
  { BuiltInOperand, 0x1141, SubgroupBallotKHR }, // 53
  { BuiltInOperand, 0x1142, GroupNonUniformBallot }, // 54
  { BuiltInOperand, 0x1142, SubgroupBallotKHR }, // 55
  { BuiltInOperand, 0x1143, GroupNonUniformBallot }, // 56
  { BuiltInOperand, 0x1143, SubgroupBallotKHR }, // 57
  { BuiltInOperand, 0x1144, GroupNonUniformBallot }, // 58
  { BuiltInOperand, 0x1144, SubgroupBallotKHR }, // 59
  { BuiltInOperand, 0x1148, DrawParameters }, // 60
  { BuiltInOperand, 0x1149, DrawParameters }, // 61
  { BuiltInOperand, 0x114A, DrawParameters }, // 62
  { BuiltInOperand, 0x114A, MeshShadingNV }, // 63
  { BuiltInOperand, 0x1156, DeviceGroup }, // 64
  { BuiltInOperand, 0x1158, MultiView }, // 65
  { BuiltInOperand, 0x1396, StencilExportEXT }, // 66
  { BuiltInOperand, 0x1485, ShaderViewportMaskNV }, // 67
  { BuiltInOperand, 0x1485, MeshShadingNV }, // 68
  { BuiltInOperand, 0x1489, ShaderStereoViewNV }, // 69
  { BuiltInOperand, 0x148A, ShaderStereoViewNV }, // 70
  { BuiltInOperand, 0x148D, PerViewAttributesNV }, // 71
  { BuiltInOperand, 0x148D, MeshShadingNV }, // 72
  { BuiltInOperand, 0x148E, PerViewAttributesNV }, // 73
  { BuiltInOperand, 0x148E, MeshShadingNV }, // 74
  { BuiltInOperand, 0x1490, FragmentFullyCoveredEXT }, // 75
  { BuiltInOperand, 0x149A, MeshShadingNV }, // 76
  { BuiltInOperand, 0x149B, MeshShadingNV }, // 77
  { BuiltInOperand, 0x149C, MeshShadingNV }, // 78
  { BuiltInOperand, 0x149D, MeshShadingNV }, // 79
  { BuiltInOperand, 0x149E, MeshShadingNV }, // 80
  { BuiltInOperand, 0x149F, MeshShadingNV }, // 81
  { BuiltInOperand, 0x14A0, MeshShadingNV }, // 82
  { BuiltInOperand, 0x14A1, MeshShadingNV }, // 83
  { BuiltInOperand, 0x14A6, FragmentBarycentricNV }, // 84
  { BuiltInOperand, 0x14A7, FragmentBarycentricNV }, // 85
  { BuiltInOperand, 0x14AC, FragmentDensityEXT }, // 86
  { BuiltInOperand, 0x14AD, FragmentDensityEXT }, // 87
  { BuiltInOperand, 0x14C7, RayTracingNV }, // 88
  { BuiltInOperand, 0x14C8, RayTracingNV }, // 89
  { BuiltInOperand, 0x14C9, RayTracingNV }, // 90
  { BuiltInOperand, 0x14CA, RayTracingNV }, // 91
  { BuiltInOperand, 0x14CB, RayTracingNV }, // 92
  { BuiltInOperand, 0x14CC, RayTracingNV }, // 93
  { BuiltInOperand, 0x14CD, RayTracingNV }, // 94
  { BuiltInOperand, 0x14CE, RayTracingNV }, // 95
  { BuiltInOperand, 0x14CF, RayTracingNV }, // 96
  { BuiltInOperand, 0x14D2, RayTracingNV }, // 97
  { BuiltInOperand, 0x14D3, RayTracingNV }, // 98
  { BuiltInOperand, 0x14D4, RayTracingNV }, // 99
  { BuiltInOperand, 0x14D5, RayTracingNV }, // 100
  { BuiltInOperand, 0x14E7, RayTracingNV }, // 101
  { CapabilityOperand, 0x1, Matrix }, // 102
  { CapabilityOperand, 0x2, Shader }, // 103
  { CapabilityOperand, 0x3, Shader }, // 104
  { CapabilityOperand, 0x7, Kernel }, // 105
  { CapabilityOperand, 0x8, Kernel }, // 106
  { CapabilityOperand, 0xC, Int64 }, // 107
  { CapabilityOperand, 0xD, Kernel }, // 108
  { CapabilityOperand, 0xE, ImageBasic }, // 109
  { CapabilityOperand, 0xF, ImageBasic }, // 110
  { CapabilityOperand, 0x11, Kernel }, // 111
  { CapabilityOperand, 0x14, Kernel }, // 112
  { CapabilityOperand, 0x15, Shader }, // 113
  { CapabilityOperand, 0x17, Tessellation }, // 114
  { CapabilityOperand, 0x18, Geometry }, // 115
  { CapabilityOperand, 0x19, Shader }, // 116
  { CapabilityOperand, 0x1B, Shader }, // 117
  { CapabilityOperand, 0x1C, Shader }, // 118
  { CapabilityOperand, 0x1D, Shader }, // 119
  { CapabilityOperand, 0x1E, Shader }, // 120
  { CapabilityOperand, 0x1F, Shader }, // 121
  { CapabilityOperand, 0x20, Shader }, // 122
  { CapabilityOperand, 0x21, Shader }, // 123
  { CapabilityOperand, 0x22, SampledCubeArray }, // 124
  { CapabilityOperand, 0x23, Shader }, // 125
  { CapabilityOperand, 0x24, SampledRect }, // 126
  { CapabilityOperand, 0x25, Shader }, // 127
  { CapabilityOperand, 0x26, Addresses }, // 128
  { CapabilityOperand, 0x28, Shader }, // 129
  { CapabilityOperand, 0x29, Shader }, // 130
  { CapabilityOperand, 0x2A, Shader }, // 131
  { CapabilityOperand, 0x2C, Sampled1D }, // 132
  { CapabilityOperand, 0x2D, Shader }, // 133
  { CapabilityOperand, 0x2F, SampledBuffer }, // 134
  { CapabilityOperand, 0x30, Shader }, // 135
  { CapabilityOperand, 0x31, Shader }, // 136
  { CapabilityOperand, 0x32, Shader }, // 137
  { CapabilityOperand, 0x33, Shader }, // 138
  { CapabilityOperand, 0x34, Shader }, // 139
  { CapabilityOperand, 0x35, Shader }, // 140
  { CapabilityOperand, 0x36, Geometry }, // 141
  { CapabilityOperand, 0x37, Shader }, // 142
  { CapabilityOperand, 0x38, Shader }, // 143
  { CapabilityOperand, 0x39, Geometry }, // 144
  { CapabilityOperand, 0x3A, DeviceEnqueue }, // 145
  { CapabilityOperand, 0x3B, Kernel }, // 146
  { CapabilityOperand, 0x3C, Pipes }, // 147
  { CapabilityOperand, 0x3E, GroupNonUniform }, // 148
  { CapabilityOperand, 0x3F, GroupNonUniform }, // 149
  { CapabilityOperand, 0x40, GroupNonUniform }, // 150
  { CapabilityOperand, 0x41, GroupNonUniform }, // 151
  { CapabilityOperand, 0x42, GroupNonUniform }, // 152
  { CapabilityOperand, 0x43, GroupNonUniform }, // 153
  { CapabilityOperand, 0x44, GroupNonUniform }, // 154
  { CapabilityOperand, 0x114B, Shader }, // 155
  { CapabilityOperand, 0x1152, StorageBuffer16BitAccess }, // 156
  { CapabilityOperand, 0x1157, Shader }, // 157
  { CapabilityOperand, 0x1159, Shader }, // 158
  { CapabilityOperand, 0x115A, VariablePointersStorageBuffer }, // 159
  { CapabilityOperand, 0x1161, StorageBuffer8BitAccess }, // 160
  { CapabilityOperand, 0x1390, Shader }, // 161
  { CapabilityOperand, 0x1391, Shader }, // 162
  { CapabilityOperand, 0x1392, Shader }, // 163
  { CapabilityOperand, 0x1395, Shader }, // 164
  { CapabilityOperand, 0x1397, Shader }, // 165
  { CapabilityOperand, 0x1481, SampleRateShading }, // 166
  { CapabilityOperand, 0x1483, Geometry }, // 167
  { CapabilityOperand, 0x1486, MultiViewport }, // 168
  { CapabilityOperand, 0x1487, ShaderViewportIndexLayerEXT }, // 169
  { CapabilityOperand, 0x148B, ShaderViewportMaskNV }, // 170
  { CapabilityOperand, 0x148C, MultiView }, // 171
  { CapabilityOperand, 0x1491, Shader }, // 172
  { CapabilityOperand, 0x1492, Shader }, // 173
  { CapabilityOperand, 0x14AB, Shader }, // 174
  { CapabilityOperand, 0x14B5, Shader }, // 175
  { CapabilityOperand, 0x14B6, Shader }, // 176
  { CapabilityOperand, 0x14B7, InputAttachment }, // 177
  { CapabilityOperand, 0x14B8, SampledBuffer }, // 178
  { CapabilityOperand, 0x14B9, ImageBuffer }, // 179
  { CapabilityOperand, 0x14BA, ShaderNonUniformEXT }, // 180
  { CapabilityOperand, 0x14BB, ShaderNonUniformEXT }, // 181
  { CapabilityOperand, 0x14BC, ShaderNonUniformEXT }, // 182
  { CapabilityOperand, 0x14BD, ShaderNonUniformEXT }, // 183
  { CapabilityOperand, 0x14BE, InputAttachment }, // 184
  { CapabilityOperand, 0x14BE, ShaderNonUniformEXT }, // 185
  { CapabilityOperand, 0x14BF, SampledBuffer }, // 186
  { CapabilityOperand, 0x14BF, ShaderNonUniformEXT }, // 187
  { CapabilityOperand, 0x14C0, ImageBuffer }, // 188
  { CapabilityOperand, 0x14C0, ShaderNonUniformEXT }, // 189
  { CapabilityOperand, 0x14DC, Shader }, // 190
  { CapabilityOperand, 0x14E3, Shader }, // 191
  { CapabilityOperand, 0x14ED, Shader }, // 192
  { CapabilityOperand, 0x16D4, Int16 }, // 193
  { CapabilityOperand, 0x16D4, Int8 }, // 194
  { CapabilityOperand, 0x172F, Kernel }, // 195
  { CapabilityOperand, 0x1781, Int8 }, // 196
  { CapabilityOperand, 0x178A, GroupNonUniform }, // 197
  { CooperativeMatrixLayoutOperand, 0x0, CooperativeMatrixKHR }, // 198
  { CooperativeMatrixLayoutOperand, 0x1, CooperativeMatrixKHR }, // 199
  { CooperativeMatrixLayoutOperand, 0x2, PackedCooperativeMatrixINTEL }, // 200
  { CooperativeMatrixOperandsOperand, 0x0, CooperativeMatrixKHR }, // 201
  { CooperativeMatrixOperandsOperand, 0x1, CooperativeMatrixKHR }, // 202
  { CooperativeMatrixOperandsOperand, 0x2, CooperativeMatrixKHR }, // 203
  { CooperativeMatrixOperandsOperand, 0x4, CooperativeMatrixKHR }, // 204
  { CooperativeMatrixOperandsOperand, 0x8, CooperativeMatrixKHR }, // 205
  { CooperativeMatrixOperandsOperand, 0x10, CooperativeMatrixKHR }, // 206
  { CooperativeMatrixOperandsOperand, 0x20, CooperativeMatrixTF32ComponentTypeINTEL }, // 207
  { CooperativeMatrixOperandsOperand, 0x40, CooperativeMatrixBFloat16ComponentTypeINTEL }, // 208
  { CooperativeMatrixOperandsOperand, 0x80, CooperativeMatrixBFloat16ComponentTypeINTEL }, // 209
  { CooperativeMatrixOperandsOperand, 0x100, CooperativeMatrixBFloat16ComponentTypeINTEL }, // 210
  { DecorationOperand, 0x0, Shader }, // 211
  { DecorationOperand, 0x1, Shader }, // 212
  { DecorationOperand, 0x1, Kernel }, // 213
  { DecorationOperand, 0x2, Shader }, // 214
  { DecorationOperand, 0x3, Shader }, // 215
  { DecorationOperand, 0x4, Matrix }, // 216
  { DecorationOperand, 0x5, Matrix }, // 217
  { DecorationOperand, 0x6, Shader }, // 218
  { DecorationOperand, 0x7, Matrix }, // 219
  { DecorationOperand, 0x8, Shader }, // 220
  { DecorationOperand, 0x9, Shader }, // 221
  { DecorationOperand, 0xA, Kernel }, // 222
  { DecorationOperand, 0xD, Shader }, // 223
  { DecorationOperand, 0xE, Shader }, // 224
  { DecorationOperand, 0xF, Tessellation }, // 225
  { DecorationOperand, 0x10, Shader }, // 226
  { DecorationOperand, 0x11, SampleRateShading }, // 227
  { DecorationOperand, 0x12, Shader }, // 228
  { DecorationOperand, 0x16, Kernel }, // 229
  { DecorationOperand, 0x1A, Shader }, // 230
  { DecorationOperand, 0x1B, Shader }, // 231
  { DecorationOperand, 0x1C, Kernel }, // 232
  { DecorationOperand, 0x1D, GeometryStreams }, // 233
  { DecorationOperand, 0x1E, Shader }, // 234
  { DecorationOperand, 0x1F, Shader }, // 235
  { DecorationOperand, 0x20, Shader }, // 236
  { DecorationOperand, 0x21, Shader }, // 237
  { DecorationOperand, 0x22, Shader }, // 238
  { DecorationOperand, 0x23, Shader }, // 239
  { DecorationOperand, 0x24, TransformFeedback }, // 240
  { DecorationOperand, 0x25, TransformFeedback }, // 241
  { DecorationOperand, 0x26, Kernel }, // 242
  { DecorationOperand, 0x28, Kernel }, // 243
  { DecorationOperand, 0x29, Linkage }, // 244
  { DecorationOperand, 0x2A, Shader }, // 245
  { DecorationOperand, 0x2B, InputAttachment }, // 246
  { DecorationOperand, 0x2C, Kernel }, // 247
  { DecorationOperand, 0x2D, Addresses }, // 248
  { DecorationOperand, 0x2E, Kernel }, // 249
  { DecorationOperand, 0x2F, Addresses }, // 250
  { DecorationOperand, 0x1480, SampleMaskOverrideCoverageNV }, // 251
  { DecorationOperand, 0x1482, GeometryShaderPassthroughNV }, // 252
  { DecorationOperand, 0x1484, ShaderViewportMaskNV }, // 253
  { DecorationOperand, 0x1488, ShaderStereoViewNV }, // 254
  { DecorationOperand, 0x1497, MeshShadingNV }, // 255
  { DecorationOperand, 0x1498, MeshShadingNV }, // 256
  { DecorationOperand, 0x1499, FragmentBarycentricNV }, // 257
  { DecorationOperand, 0x14B4, ShaderNonUniformEXT }, // 258
  { DecorationOperand, 0x14EB, PhysicalStorageBufferAddressesEXT }, // 259
  { DecorationOperand, 0x14EC, PhysicalStorageBufferAddressesEXT }, // 260
  { DecorationOperand, 0x15E2, IndirectReferencesINTEL }, // 261
  { DecorationOperand, 0x15E7, AsmINTEL }, // 262
  { DecorationOperand, 0x15E8, AsmINTEL }, // 263
  { DecorationOperand, 0x16BE, FunctionFloatControlINTEL }, // 264
  { DecorationOperand, 0x16BF, FunctionFloatControlINTEL }, // 265
  { DecorationOperand, 0x17C0, FunctionFloatControlINTEL }, // 266
  { DecorationOperand, 0x182C, GlobalVariableHostAccessINTEL }, // 267
  { DecorationOperand, 0x182E, GlobalVariableFPGADecorationsINTEL }, // 268
  { DecorationOperand, 0x182F, GlobalVariableFPGADecorationsINTEL }, // 269
  { DecorationOperand, 0x1909, FunctionPointersINTEL }, // 270
  { DecorationOperand, 0x192A, CacheControlsINTEL }, // 271
  { DecorationOperand, 0x192B, CacheControlsINTEL }, // 272
  { DimOperand, 0x0, Sampled1D }, // 273
  { DimOperand, 0x0, Image1D }, // 274
  { DimOperand, 0x1, Shader }, // 275
  { DimOperand, 0x1, Kernel }, // 276
  { DimOperand, 0x1, ImageMSArray }, // 277
  { DimOperand, 0x3, Shader }, // 278
  { DimOperand, 0x3, ImageCubeArray }, // 279
  { DimOperand, 0x4, ImageRect }, // 280
  { DimOperand, 0x4, SampledRect }, // 281
  { DimOperand, 0x5, SampledBuffer }, // 282
  { DimOperand, 0x5, ImageBuffer }, // 283
  { DimOperand, 0x6, InputAttachment }, // 284
  { ExecutionModeOperand, 0x0, Geometry }, // 285
  { ExecutionModeOperand, 0x1, Tessellation }, // 286
  { ExecutionModeOperand, 0x2, Tessellation }, // 287
  { ExecutionModeOperand, 0x3, Tessellation }, // 288
  { ExecutionModeOperand, 0x4, Tessellation }, // 289
  { ExecutionModeOperand, 0x5, Tessellation }, // 290
  { ExecutionModeOperand, 0x6, Shader }, // 291
  { ExecutionModeOperand, 0x7, Shader }, // 292
  { ExecutionModeOperand, 0x8, Shader }, // 293
  { ExecutionModeOperand, 0x9, Shader }, // 294
  { ExecutionModeOperand, 0xA, Tessellation }, // 295
  { ExecutionModeOperand, 0xB, TransformFeedback }, // 296
  { ExecutionModeOperand, 0xC, Shader }, // 297
  { ExecutionModeOperand, 0xE, Shader }, // 298
  { ExecutionModeOperand, 0xF, Shader }, // 299
  { ExecutionModeOperand, 0x10, Shader }, // 300
  { ExecutionModeOperand, 0x12, Kernel }, // 301
  { ExecutionModeOperand, 0x13, Geometry }, // 302
  { ExecutionModeOperand, 0x14, Geometry }, // 303
  { ExecutionModeOperand, 0x15, Geometry }, // 304
  { ExecutionModeOperand, 0x16, Geometry }, // 305
  { ExecutionModeOperand, 0x17, Geometry }, // 306
  { ExecutionModeOperand, 0x18, Tessellation }, // 307
  { ExecutionModeOperand, 0x19, Tessellation }, // 308
  { ExecutionModeOperand, 0x1A, Geometry }, // 309
  { ExecutionModeOperand, 0x1B, Geometry }, // 310
  { ExecutionModeOperand, 0x1C, Geometry }, // 311
  { ExecutionModeOperand, 0x1D, Geometry }, // 312
  { ExecutionModeOperand, 0x1E, Kernel }, // 313
  { ExecutionModeOperand, 0x1F, Kernel }, // 314
  { ExecutionModeOperand, 0x21, Kernel }, // 315
  { ExecutionModeOperand, 0x22, Kernel }, // 316
  { ExecutionModeOperand, 0x23, SubgroupDispatch }, // 317
  { ExecutionModeOperand, 0x24, SubgroupDispatch }, // 318
  { ExecutionModeOperand, 0x25, SubgroupDispatch }, // 319
  { ExecutionModeOperand, 0x27, Kernel }, // 320
  { ExecutionModeOperand, 0x115E, SampleMaskPostDepthCoverage }, // 321
  { ExecutionModeOperand, 0x116B, DenormPreserve }, // 322
  { ExecutionModeOperand, 0x116C, DenormFlushToZero }, // 323
  { ExecutionModeOperand, 0x116D, SignedZeroInfNanPreserve }, // 324
  { ExecutionModeOperand, 0x116E, RoundingModeRTE }, // 325
  { ExecutionModeOperand, 0x116F, RoundingModeRTZ }, // 326
  { ExecutionModeOperand, 0x13A3, StencilExportEXT }, // 327
  { ExecutionModeOperand, 0x1495, MeshShadingNV }, // 328
  { ExecutionModeOperand, 0x14A9, ComputeDerivativeGroupQuadsNV }, // 329
  { ExecutionModeOperand, 0x14AA, ComputeDerivativeGroupLinearNV }, // 330
  { ExecutionModeOperand, 0x14B2, MeshShadingNV }, // 331
  { ExecutionModeOperand, 0x15F4, RoundToInfinityINTEL }, // 332
  { ExecutionModeOperand, 0x15F5, RoundToInfinityINTEL }, // 333
  { ExecutionModeOperand, 0x15F6, FloatingPointModeINTEL }, // 334
  { ExecutionModeOperand, 0x15F7, FloatingPointModeINTEL }, // 335
  { ExecutionModelOperand, 0x0, Shader }, // 336
  { ExecutionModelOperand, 0x1, Tessellation }, // 337
  { ExecutionModelOperand, 0x2, Tessellation }, // 338
  { ExecutionModelOperand, 0x3, Geometry }, // 339
  { ExecutionModelOperand, 0x4, Shader }, // 340
  { ExecutionModelOperand, 0x5, Shader }, // 341
  { ExecutionModelOperand, 0x6, Kernel }, // 342
  { ExecutionModelOperand, 0x1493, MeshShadingNV }, // 343
  { ExecutionModelOperand, 0x1494, MeshShadingNV }, // 344
  { ExecutionModelOperand, 0x14C1, RayTracingNV }, // 345
  { ExecutionModelOperand, 0x14C2, RayTracingNV }, // 346
  { ExecutionModelOperand, 0x14C3, RayTracingNV }, // 347
  { ExecutionModelOperand, 0x14C4, RayTracingNV }, // 348
  { ExecutionModelOperand, 0x14C5, RayTracingNV }, // 349
  { ExecutionModelOperand, 0x14C6, RayTracingNV }, // 350
  { FPFastMathModeOperand, 0x1, Kernel }, // 351
  { FPFastMathModeOperand, 0x2, Kernel }, // 352
  { FPFastMathModeOperand, 0x4, Kernel }, // 353
  { FPFastMathModeOperand, 0x8, Kernel }, // 354
  { FPFastMathModeOperand, 0x10, Kernel }, // 355
  { FunctionParameterAttributeOperand, 0x0, Kernel }, // 356
  { FunctionParameterAttributeOperand, 0x1, Kernel }, // 357
  { FunctionParameterAttributeOperand, 0x2, Kernel }, // 358
  { FunctionParameterAttributeOperand, 0x3, Kernel }, // 359
  { FunctionParameterAttributeOperand, 0x4, Kernel }, // 360
  { FunctionParameterAttributeOperand, 0x5, Kernel }, // 361
  { FunctionParameterAttributeOperand, 0x6, Kernel }, // 362
  { FunctionParameterAttributeOperand, 0x7, Kernel }, // 363
  { GroupOperationOperand, 0x0, Kernel }, // 364
  { GroupOperationOperand, 0x0, GroupNonUniformArithmetic }, // 365
  { GroupOperationOperand, 0x0, GroupNonUniformBallot }, // 366
  { GroupOperationOperand, 0x1, Kernel }, // 367
  { GroupOperationOperand, 0x1, GroupNonUniformArithmetic }, // 368
  { GroupOperationOperand, 0x1, GroupNonUniformBallot }, // 369
  { GroupOperationOperand, 0x2, Kernel }, // 370
  { GroupOperationOperand, 0x2, GroupNonUniformArithmetic }, // 371
  { GroupOperationOperand, 0x2, GroupNonUniformBallot }, // 372
  { GroupOperationOperand, 0x3, GroupNonUniformClustered }, // 373
  { GroupOperationOperand, 0x6, GroupNonUniformPartitionedNV }, // 374
  { GroupOperationOperand, 0x7, GroupNonUniformPartitionedNV }, // 375
  { GroupOperationOperand, 0x8, GroupNonUniformPartitionedNV }, // 376
  { ImageChannelDataTypeOperand, 0x2, Kernel }, // 377
  { ImageChannelDataTypeOperand, 0x3, Kernel }, // 378
  { ImageChannelDataTypeOperand, 0x4, Kernel }, // 379
  { ImageChannelDataTypeOperand, 0x5, Kernel }, // 380
  { ImageChannelDataTypeOperand, 0x6, Kernel }, // 381
  { ImageChannelDataTypeOperand, 0x7, Kernel }, // 382
  { ImageChannelDataTypeOperand, 0x8, Kernel }, // 383
  { ImageChannelDataTypeOperand, 0x9, Kernel }, // 384
  { ImageChannelDataTypeOperand, 0xA, Kernel }, // 385
  { ImageChannelDataTypeOperand, 0xB, Kernel }, // 386
  { ImageChannelDataTypeOperand, 0xC, Kernel }, // 387
  { ImageChannelDataTypeOperand, 0xD, Kernel }, // 388
  { ImageChannelDataTypeOperand, 0xE, Kernel }, // 389
  { ImageChannelDataTypeOperand, 0xF, Kernel }, // 390
  { ImageChannelDataTypeOperand, 0x10, Kernel }, // 391
  { ImageChannelOrderOperand, 0x0, Kernel }, // 392
  { ImageChannelOrderOperand, 0x1, Kernel }, // 393
  { ImageChannelOrderOperand, 0x2, Kernel }, // 394
  { ImageChannelOrderOperand, 0x3, Kernel }, // 395
  { ImageChannelOrderOperand, 0x4, Kernel }, // 396
  { ImageChannelOrderOperand, 0x5, Kernel }, // 397
  { ImageChannelOrderOperand, 0x6, Kernel }, // 398
  { ImageChannelOrderOperand, 0x7, Kernel }, // 399
  { ImageChannelOrderOperand, 0x8, Kernel }, // 400
  { ImageChannelOrderOperand, 0x9, Kernel }, // 401
  { ImageChannelOrderOperand, 0xA, Kernel }, // 402
  { ImageChannelOrderOperand, 0xB, Kernel }, // 403
  { ImageChannelOrderOperand, 0xC, Kernel }, // 404
  { ImageChannelOrderOperand, 0xD, Kernel }, // 405
  { ImageChannelOrderOperand, 0xE, Kernel }, // 406
  { ImageChannelOrderOperand, 0xF, Kernel }, // 407
  { ImageChannelOrderOperand, 0x10, Kernel }, // 408
  { ImageChannelOrderOperand, 0x11, Kernel }, // 409
  { ImageChannelOrderOperand, 0x12, Kernel }, // 410
  { ImageChannelOrderOperand, 0x13, Kernel }, // 411
  { ImageFormatOperand, 0x1, Shader }, // 412
  { ImageFormatOperand, 0x2, Shader }, // 413
  { ImageFormatOperand, 0x3, Shader }, // 414
  { ImageFormatOperand, 0x4, Shader }, // 415
  { ImageFormatOperand, 0x5, Shader }, // 416
  { ImageFormatOperand, 0x6, StorageImageExtendedFormats }, // 417
  { ImageFormatOperand, 0x7, StorageImageExtendedFormats }, // 418
  { ImageFormatOperand, 0x8, StorageImageExtendedFormats }, // 419
  { ImageFormatOperand, 0x9, StorageImageExtendedFormats }, // 420
  { ImageFormatOperand, 0xA, StorageImageExtendedFormats }, // 421
  { ImageFormatOperand, 0xB, StorageImageExtendedFormats }, // 422
  { ImageFormatOperand, 0xC, StorageImageExtendedFormats }, // 423
  { ImageFormatOperand, 0xD, StorageImageExtendedFormats }, // 424
  { ImageFormatOperand, 0xE, StorageImageExtendedFormats }, // 425
  { ImageFormatOperand, 0xF, StorageImageExtendedFormats }, // 426
  { ImageFormatOperand, 0x10, StorageImageExtendedFormats }, // 427
  { ImageFormatOperand, 0x11, StorageImageExtendedFormats }, // 428
  { ImageFormatOperand, 0x12, StorageImageExtendedFormats }, // 429
  { ImageFormatOperand, 0x13, StorageImageExtendedFormats }, // 430
  { ImageFormatOperand, 0x14, StorageImageExtendedFormats }, // 431
  { ImageFormatOperand, 0x15, Shader }, // 432
  { ImageFormatOperand, 0x16, Shader }, // 433
  { ImageFormatOperand, 0x17, Shader }, // 434
  { ImageFormatOperand, 0x18, Shader }, // 435
  { ImageFormatOperand, 0x19, StorageImageExtendedFormats }, // 436
  { ImageFormatOperand, 0x1A, StorageImageExtendedFormats }, // 437
  { ImageFormatOperand, 0x1B, StorageImageExtendedFormats }, // 438
  { ImageFormatOperand, 0x1C, StorageImageExtendedFormats }, // 439
  { ImageFormatOperand, 0x1D, StorageImageExtendedFormats }, // 440
  { ImageFormatOperand, 0x1E, Shader }, // 441
  { ImageFormatOperand, 0x1F, Shader }, // 442
  { ImageFormatOperand, 0x20, Shader }, // 443
  { ImageFormatOperand, 0x21, Shader }, // 444
  { ImageFormatOperand, 0x22, StorageImageExtendedFormats }, // 445
  { ImageFormatOperand, 0x23, StorageImageExtendedFormats }, // 446
  { ImageFormatOperand, 0x24, StorageImageExtendedFormats }, // 447
  { ImageFormatOperand, 0x25, StorageImageExtendedFormats }, // 448
  { ImageFormatOperand, 0x26, StorageImageExtendedFormats }, // 449
  { ImageFormatOperand, 0x27, StorageImageExtendedFormats }, // 450
  { ImageOperandOperand, 0x1, Shader }, // 451
  { ImageOperandOperand, 0x10, ImageGatherExtended }, // 452
  { ImageOperandOperand, 0x20, ImageGatherExtended }, // 453
  { ImageOperandOperand, 0x80, MinLod }, // 454
  { ImageOperandOperand, 0x100, VulkanMemoryModelKHR }, // 455
  { ImageOperandOperand, 0x200, VulkanMemoryModelKHR }, // 456
  { ImageOperandOperand, 0x400, VulkanMemoryModelKHR }, // 457
  { ImageOperandOperand, 0x800, VulkanMemoryModelKHR }, // 458
  { KernelEnqueueFlagsOperand, 0x0, Kernel }, // 459
  { KernelEnqueueFlagsOperand, 0x1, Kernel }, // 460
  { KernelEnqueueFlagsOperand, 0x2, Kernel }, // 461
  { KernelProfilingInfoOperand, 0x1, Kernel }, // 462
  { LinkageTypeOperand, 0x0, Linkage }, // 463
  { LinkageTypeOperand, 0x1, Linkage }, // 464
  { LinkageTypeOperand, 0x2, Linkage }, // 465
  { MemoryModelOperand, 0x0, Shader }, // 466
  { MemoryModelOperand, 0x1, Shader }, // 467
  { MemoryModelOperand, 0x2, Kernel }, // 468
  { MemoryModelOperand, 0x3, VulkanMemoryModelKHR }, // 469
  { MemoryOperandOperand, 0x8, VulkanMemoryModelKHR }, // 470
  { MemoryOperandOperand, 0x10, VulkanMemoryModelKHR }, // 471
  { MemoryOperandOperand, 0x20, VulkanMemoryModelKHR }, // 472
  { MemorySemanticsOperand, 0x40, Shader }, // 473
  { MemorySemanticsOperand, 0x400, AtomicStorage }, // 474
  { MemorySemanticsOperand, 0x1000, VulkanMemoryModelKHR }, // 475
  { MemorySemanticsOperand, 0x2000, VulkanMemoryModelKHR }, // 476
  { MemorySemanticsOperand, 0x4000, VulkanMemoryModelKHR }, // 477
  { SamplerAddressingModeOperand, 0x0, Kernel }, // 478
  { SamplerAddressingModeOperand, 0x1, Kernel }, // 479
  { SamplerAddressingModeOperand, 0x2, Kernel }, // 480
  { SamplerAddressingModeOperand, 0x3, Kernel }, // 481
  { SamplerAddressingModeOperand, 0x4, Kernel }, // 482
  { SamplerFilterModeOperand, 0x0, Kernel }, // 483
  { SamplerFilterModeOperand, 0x1, Kernel }, // 484
  { ScopeOperand, 0x5, VulkanMemoryModelKHR }, // 485
  { StorageClassOperand, 0x2, Shader }, // 486
  { StorageClassOperand, 0x3, Shader }, // 487
  { StorageClassOperand, 0x6, Shader }, // 488
  { StorageClassOperand, 0x8, GenericPointer }, // 489
  { StorageClassOperand, 0x9, Shader }, // 490
  { StorageClassOperand, 0xA, AtomicStorage }, // 491
  { StorageClassOperand, 0xC, Shader }, // 492
  { StorageClassOperand, 0x14D0, RayTracingNV }, // 493
  { StorageClassOperand, 0x14D1, RayTracingNV }, // 494
  { StorageClassOperand, 0x14DA, RayTracingNV }, // 495
  { StorageClassOperand, 0x14DB, RayTracingNV }, // 496
  { StorageClassOperand, 0x14DE, RayTracingNV }, // 497
  { StorageClassOperand, 0x14DF, RayTracingNV }, // 498
  { StorageClassOperand, 0x14E5, PhysicalStorageBufferAddressesEXT }, // 499
  { StorageClassOperand, 0x15E5, FunctionPointersINTEL }, // 500
  { StorageClassOperand, 0x1730, USMStorageClassesINTEL }, // 501
  { StorageClassOperand, 0x1731, USMStorageClassesINTEL }, // 502
 };

const CapabilityEntry *lookupCapabilityByCategoryAndValue(unsigned Category, uint32_t Value) {
  struct KeyType {
    unsigned Category;
    uint32_t Value;
  };
  KeyType Key = {Category, Value};
  struct Comp {
    bool operator()(const CapabilityEntry &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Category < (unsigned)RHS.Category)
        return true;
      if ((unsigned)LHS.Category > (unsigned)RHS.Category)
        return false;
      if (LHS.Value < RHS.Value)
        return true;
      if (LHS.Value > RHS.Value)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(CapabilityEntries);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Category != Idx->Category ||
      Key.Value != Idx->Value)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_ConvertBuiltins_DECL
const ConvertBuiltin *lookupConvertBuiltin(StringRef Name, unsigned Set);
#endif

#ifdef GET_ConvertBuiltins_IMPL
constexpr ConvertBuiltin ConvertBuiltins[] = {
  { "convert_char", OpenCL_std, true, false, false, false, RTE }, // 0
  { "convert_char16", OpenCL_std, true, false, false, false, RTE }, // 1
  { "convert_char16_rte", OpenCL_std, true, false, true, false, RTE }, // 2
  { "convert_char16_rtn", OpenCL_std, true, false, true, false, RTN }, // 3
  { "convert_char16_rtp", OpenCL_std, true, false, true, false, RTP }, // 4
  { "convert_char16_rtz", OpenCL_std, true, false, true, false, RTZ }, // 5
  { "convert_char16_sat", OpenCL_std, true, true, false, false, RTE }, // 6
  { "convert_char16_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 7
  { "convert_char16_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 8
  { "convert_char16_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 9
  { "convert_char16_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 10
  { "convert_char2", OpenCL_std, true, false, false, false, RTE }, // 11
  { "convert_char2_rte", OpenCL_std, true, false, true, false, RTE }, // 12
  { "convert_char2_rtn", OpenCL_std, true, false, true, false, RTN }, // 13
  { "convert_char2_rtp", OpenCL_std, true, false, true, false, RTP }, // 14
  { "convert_char2_rtz", OpenCL_std, true, false, true, false, RTZ }, // 15
  { "convert_char2_sat", OpenCL_std, true, true, false, false, RTE }, // 16
  { "convert_char2_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 17
  { "convert_char2_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 18
  { "convert_char2_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 19
  { "convert_char2_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 20
  { "convert_char3", OpenCL_std, true, false, false, false, RTE }, // 21
  { "convert_char3_rte", OpenCL_std, true, false, true, false, RTE }, // 22
  { "convert_char3_rtn", OpenCL_std, true, false, true, false, RTN }, // 23
  { "convert_char3_rtp", OpenCL_std, true, false, true, false, RTP }, // 24
  { "convert_char3_rtz", OpenCL_std, true, false, true, false, RTZ }, // 25
  { "convert_char3_sat", OpenCL_std, true, true, false, false, RTE }, // 26
  { "convert_char3_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 27
  { "convert_char3_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 28
  { "convert_char3_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 29
  { "convert_char3_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 30
  { "convert_char4", OpenCL_std, true, false, false, false, RTE }, // 31
  { "convert_char4_rte", OpenCL_std, true, false, true, false, RTE }, // 32
  { "convert_char4_rtn", OpenCL_std, true, false, true, false, RTN }, // 33
  { "convert_char4_rtp", OpenCL_std, true, false, true, false, RTP }, // 34
  { "convert_char4_rtz", OpenCL_std, true, false, true, false, RTZ }, // 35
  { "convert_char4_sat", OpenCL_std, true, true, false, false, RTE }, // 36
  { "convert_char4_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 37
  { "convert_char4_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 38
  { "convert_char4_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 39
  { "convert_char4_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 40
  { "convert_char8", OpenCL_std, true, false, false, false, RTE }, // 41
  { "convert_char8_rte", OpenCL_std, true, false, true, false, RTE }, // 42
  { "convert_char8_rtn", OpenCL_std, true, false, true, false, RTN }, // 43
  { "convert_char8_rtp", OpenCL_std, true, false, true, false, RTP }, // 44
  { "convert_char8_rtz", OpenCL_std, true, false, true, false, RTZ }, // 45
  { "convert_char8_sat", OpenCL_std, true, true, false, false, RTE }, // 46
  { "convert_char8_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 47
  { "convert_char8_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 48
  { "convert_char8_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 49
  { "convert_char8_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 50
  { "convert_char_rte", OpenCL_std, true, false, true, false, RTE }, // 51
  { "convert_char_rtn", OpenCL_std, true, false, true, false, RTN }, // 52
  { "convert_char_rtp", OpenCL_std, true, false, true, false, RTP }, // 53
  { "convert_char_rtz", OpenCL_std, true, false, true, false, RTZ }, // 54
  { "convert_char_sat", OpenCL_std, true, true, false, false, RTE }, // 55
  { "convert_char_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 56
  { "convert_char_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 57
  { "convert_char_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 58
  { "convert_char_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 59
  { "convert_float", OpenCL_std, true, false, false, false, RTE }, // 60
  { "convert_float16", OpenCL_std, true, false, false, false, RTE }, // 61
  { "convert_float16_rte", OpenCL_std, true, false, true, false, RTE }, // 62
  { "convert_float16_rtn", OpenCL_std, true, false, true, false, RTN }, // 63
  { "convert_float16_rtp", OpenCL_std, true, false, true, false, RTP }, // 64
  { "convert_float16_rtz", OpenCL_std, true, false, true, false, RTZ }, // 65
  { "convert_float2", OpenCL_std, true, false, false, false, RTE }, // 66
  { "convert_float2_rte", OpenCL_std, true, false, true, false, RTE }, // 67
  { "convert_float2_rtn", OpenCL_std, true, false, true, false, RTN }, // 68
  { "convert_float2_rtp", OpenCL_std, true, false, true, false, RTP }, // 69
  { "convert_float2_rtz", OpenCL_std, true, false, true, false, RTZ }, // 70
  { "convert_float3", OpenCL_std, true, false, false, false, RTE }, // 71
  { "convert_float3_rte", OpenCL_std, true, false, true, false, RTE }, // 72
  { "convert_float3_rtn", OpenCL_std, true, false, true, false, RTN }, // 73
  { "convert_float3_rtp", OpenCL_std, true, false, true, false, RTP }, // 74
  { "convert_float3_rtz", OpenCL_std, true, false, true, false, RTZ }, // 75
  { "convert_float4", OpenCL_std, true, false, false, false, RTE }, // 76
  { "convert_float4_rte", OpenCL_std, true, false, true, false, RTE }, // 77
  { "convert_float4_rtn", OpenCL_std, true, false, true, false, RTN }, // 78
  { "convert_float4_rtp", OpenCL_std, true, false, true, false, RTP }, // 79
  { "convert_float4_rtz", OpenCL_std, true, false, true, false, RTZ }, // 80
  { "convert_float8", OpenCL_std, true, false, false, false, RTE }, // 81
  { "convert_float8_rte", OpenCL_std, true, false, true, false, RTE }, // 82
  { "convert_float8_rtn", OpenCL_std, true, false, true, false, RTN }, // 83
  { "convert_float8_rtp", OpenCL_std, true, false, true, false, RTP }, // 84
  { "convert_float8_rtz", OpenCL_std, true, false, true, false, RTZ }, // 85
  { "convert_float_rte", OpenCL_std, true, false, true, false, RTE }, // 86
  { "convert_float_rtn", OpenCL_std, true, false, true, false, RTN }, // 87
  { "convert_float_rtp", OpenCL_std, true, false, true, false, RTP }, // 88
  { "convert_float_rtz", OpenCL_std, true, false, true, false, RTZ }, // 89
  { "convert_int", OpenCL_std, true, false, false, false, RTE }, // 90
  { "convert_int16", OpenCL_std, true, false, false, false, RTE }, // 91
  { "convert_int16_rte", OpenCL_std, true, false, true, false, RTE }, // 92
  { "convert_int16_rtn", OpenCL_std, true, false, true, false, RTN }, // 93
  { "convert_int16_rtp", OpenCL_std, true, false, true, false, RTP }, // 94
  { "convert_int16_rtz", OpenCL_std, true, false, true, false, RTZ }, // 95
  { "convert_int16_sat", OpenCL_std, true, true, false, false, RTE }, // 96
  { "convert_int16_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 97
  { "convert_int16_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 98
  { "convert_int16_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 99
  { "convert_int16_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 100
  { "convert_int2", OpenCL_std, true, false, false, false, RTE }, // 101
  { "convert_int2_rte", OpenCL_std, true, false, true, false, RTE }, // 102
  { "convert_int2_rtn", OpenCL_std, true, false, true, false, RTN }, // 103
  { "convert_int2_rtp", OpenCL_std, true, false, true, false, RTP }, // 104
  { "convert_int2_rtz", OpenCL_std, true, false, true, false, RTZ }, // 105
  { "convert_int2_sat", OpenCL_std, true, true, false, false, RTE }, // 106
  { "convert_int2_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 107
  { "convert_int2_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 108
  { "convert_int2_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 109
  { "convert_int2_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 110
  { "convert_int3", OpenCL_std, true, false, false, false, RTE }, // 111
  { "convert_int3_rte", OpenCL_std, true, false, true, false, RTE }, // 112
  { "convert_int3_rtn", OpenCL_std, true, false, true, false, RTN }, // 113
  { "convert_int3_rtp", OpenCL_std, true, false, true, false, RTP }, // 114
  { "convert_int3_rtz", OpenCL_std, true, false, true, false, RTZ }, // 115
  { "convert_int3_sat", OpenCL_std, true, true, false, false, RTE }, // 116
  { "convert_int3_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 117
  { "convert_int3_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 118
  { "convert_int3_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 119
  { "convert_int3_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 120
  { "convert_int4", OpenCL_std, true, false, false, false, RTE }, // 121
  { "convert_int4_rte", OpenCL_std, true, false, true, false, RTE }, // 122
  { "convert_int4_rtn", OpenCL_std, true, false, true, false, RTN }, // 123
  { "convert_int4_rtp", OpenCL_std, true, false, true, false, RTP }, // 124
  { "convert_int4_rtz", OpenCL_std, true, false, true, false, RTZ }, // 125
  { "convert_int4_sat", OpenCL_std, true, true, false, false, RTE }, // 126
  { "convert_int4_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 127
  { "convert_int4_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 128
  { "convert_int4_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 129
  { "convert_int4_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 130
  { "convert_int8", OpenCL_std, true, false, false, false, RTE }, // 131
  { "convert_int8_rte", OpenCL_std, true, false, true, false, RTE }, // 132
  { "convert_int8_rtn", OpenCL_std, true, false, true, false, RTN }, // 133
  { "convert_int8_rtp", OpenCL_std, true, false, true, false, RTP }, // 134
  { "convert_int8_rtz", OpenCL_std, true, false, true, false, RTZ }, // 135
  { "convert_int8_sat", OpenCL_std, true, true, false, false, RTE }, // 136
  { "convert_int8_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 137
  { "convert_int8_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 138
  { "convert_int8_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 139
  { "convert_int8_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 140
  { "convert_int_rte", OpenCL_std, true, false, true, false, RTE }, // 141
  { "convert_int_rtn", OpenCL_std, true, false, true, false, RTN }, // 142
  { "convert_int_rtp", OpenCL_std, true, false, true, false, RTP }, // 143
  { "convert_int_rtz", OpenCL_std, true, false, true, false, RTZ }, // 144
  { "convert_int_sat", OpenCL_std, true, true, false, false, RTE }, // 145
  { "convert_int_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 146
  { "convert_int_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 147
  { "convert_int_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 148
  { "convert_int_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 149
  { "convert_long", OpenCL_std, true, false, false, false, RTE }, // 150
  { "convert_long16", OpenCL_std, true, false, false, false, RTE }, // 151
  { "convert_long16_rte", OpenCL_std, true, false, true, false, RTE }, // 152
  { "convert_long16_rtn", OpenCL_std, true, false, true, false, RTN }, // 153
  { "convert_long16_rtp", OpenCL_std, true, false, true, false, RTP }, // 154
  { "convert_long16_rtz", OpenCL_std, true, false, true, false, RTZ }, // 155
  { "convert_long16_sat", OpenCL_std, true, true, false, false, RTE }, // 156
  { "convert_long16_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 157
  { "convert_long16_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 158
  { "convert_long16_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 159
  { "convert_long16_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 160
  { "convert_long2", OpenCL_std, true, false, false, false, RTE }, // 161
  { "convert_long2_rte", OpenCL_std, true, false, true, false, RTE }, // 162
  { "convert_long2_rtn", OpenCL_std, true, false, true, false, RTN }, // 163
  { "convert_long2_rtp", OpenCL_std, true, false, true, false, RTP }, // 164
  { "convert_long2_rtz", OpenCL_std, true, false, true, false, RTZ }, // 165
  { "convert_long2_sat", OpenCL_std, true, true, false, false, RTE }, // 166
  { "convert_long2_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 167
  { "convert_long2_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 168
  { "convert_long2_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 169
  { "convert_long2_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 170
  { "convert_long3", OpenCL_std, true, false, false, false, RTE }, // 171
  { "convert_long3_rte", OpenCL_std, true, false, true, false, RTE }, // 172
  { "convert_long3_rtn", OpenCL_std, true, false, true, false, RTN }, // 173
  { "convert_long3_rtp", OpenCL_std, true, false, true, false, RTP }, // 174
  { "convert_long3_rtz", OpenCL_std, true, false, true, false, RTZ }, // 175
  { "convert_long3_sat", OpenCL_std, true, true, false, false, RTE }, // 176
  { "convert_long3_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 177
  { "convert_long3_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 178
  { "convert_long3_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 179
  { "convert_long3_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 180
  { "convert_long4", OpenCL_std, true, false, false, false, RTE }, // 181
  { "convert_long4_rte", OpenCL_std, true, false, true, false, RTE }, // 182
  { "convert_long4_rtn", OpenCL_std, true, false, true, false, RTN }, // 183
  { "convert_long4_rtp", OpenCL_std, true, false, true, false, RTP }, // 184
  { "convert_long4_rtz", OpenCL_std, true, false, true, false, RTZ }, // 185
  { "convert_long4_sat", OpenCL_std, true, true, false, false, RTE }, // 186
  { "convert_long4_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 187
  { "convert_long4_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 188
  { "convert_long4_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 189
  { "convert_long4_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 190
  { "convert_long8", OpenCL_std, true, false, false, false, RTE }, // 191
  { "convert_long8_rte", OpenCL_std, true, false, true, false, RTE }, // 192
  { "convert_long8_rtn", OpenCL_std, true, false, true, false, RTN }, // 193
  { "convert_long8_rtp", OpenCL_std, true, false, true, false, RTP }, // 194
  { "convert_long8_rtz", OpenCL_std, true, false, true, false, RTZ }, // 195
  { "convert_long8_sat", OpenCL_std, true, true, false, false, RTE }, // 196
  { "convert_long8_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 197
  { "convert_long8_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 198
  { "convert_long8_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 199
  { "convert_long8_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 200
  { "convert_long_rte", OpenCL_std, true, false, true, false, RTE }, // 201
  { "convert_long_rtn", OpenCL_std, true, false, true, false, RTN }, // 202
  { "convert_long_rtp", OpenCL_std, true, false, true, false, RTP }, // 203
  { "convert_long_rtz", OpenCL_std, true, false, true, false, RTZ }, // 204
  { "convert_long_sat", OpenCL_std, true, true, false, false, RTE }, // 205
  { "convert_long_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 206
  { "convert_long_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 207
  { "convert_long_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 208
  { "convert_long_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 209
  { "convert_short", OpenCL_std, true, false, false, false, RTE }, // 210
  { "convert_short16", OpenCL_std, true, false, false, false, RTE }, // 211
  { "convert_short16_rte", OpenCL_std, true, false, true, false, RTE }, // 212
  { "convert_short16_rtn", OpenCL_std, true, false, true, false, RTN }, // 213
  { "convert_short16_rtp", OpenCL_std, true, false, true, false, RTP }, // 214
  { "convert_short16_rtz", OpenCL_std, true, false, true, false, RTZ }, // 215
  { "convert_short16_sat", OpenCL_std, true, true, false, false, RTE }, // 216
  { "convert_short16_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 217
  { "convert_short16_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 218
  { "convert_short16_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 219
  { "convert_short16_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 220
  { "convert_short2", OpenCL_std, true, false, false, false, RTE }, // 221
  { "convert_short2_rte", OpenCL_std, true, false, true, false, RTE }, // 222
  { "convert_short2_rtn", OpenCL_std, true, false, true, false, RTN }, // 223
  { "convert_short2_rtp", OpenCL_std, true, false, true, false, RTP }, // 224
  { "convert_short2_rtz", OpenCL_std, true, false, true, false, RTZ }, // 225
  { "convert_short2_sat", OpenCL_std, true, true, false, false, RTE }, // 226
  { "convert_short2_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 227
  { "convert_short2_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 228
  { "convert_short2_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 229
  { "convert_short2_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 230
  { "convert_short3", OpenCL_std, true, false, false, false, RTE }, // 231
  { "convert_short3_rte", OpenCL_std, true, false, true, false, RTE }, // 232
  { "convert_short3_rtn", OpenCL_std, true, false, true, false, RTN }, // 233
  { "convert_short3_rtp", OpenCL_std, true, false, true, false, RTP }, // 234
  { "convert_short3_rtz", OpenCL_std, true, false, true, false, RTZ }, // 235
  { "convert_short3_sat", OpenCL_std, true, true, false, false, RTE }, // 236
  { "convert_short3_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 237
  { "convert_short3_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 238
  { "convert_short3_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 239
  { "convert_short3_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 240
  { "convert_short4", OpenCL_std, true, false, false, false, RTE }, // 241
  { "convert_short4_rte", OpenCL_std, true, false, true, false, RTE }, // 242
  { "convert_short4_rtn", OpenCL_std, true, false, true, false, RTN }, // 243
  { "convert_short4_rtp", OpenCL_std, true, false, true, false, RTP }, // 244
  { "convert_short4_rtz", OpenCL_std, true, false, true, false, RTZ }, // 245
  { "convert_short4_sat", OpenCL_std, true, true, false, false, RTE }, // 246
  { "convert_short4_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 247
  { "convert_short4_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 248
  { "convert_short4_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 249
  { "convert_short4_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 250
  { "convert_short8", OpenCL_std, true, false, false, false, RTE }, // 251
  { "convert_short8_rte", OpenCL_std, true, false, true, false, RTE }, // 252
  { "convert_short8_rtn", OpenCL_std, true, false, true, false, RTN }, // 253
  { "convert_short8_rtp", OpenCL_std, true, false, true, false, RTP }, // 254
  { "convert_short8_rtz", OpenCL_std, true, false, true, false, RTZ }, // 255
  { "convert_short8_sat", OpenCL_std, true, true, false, false, RTE }, // 256
  { "convert_short8_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 257
  { "convert_short8_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 258
  { "convert_short8_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 259
  { "convert_short8_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 260
  { "convert_short_rte", OpenCL_std, true, false, true, false, RTE }, // 261
  { "convert_short_rtn", OpenCL_std, true, false, true, false, RTN }, // 262
  { "convert_short_rtp", OpenCL_std, true, false, true, false, RTP }, // 263
  { "convert_short_rtz", OpenCL_std, true, false, true, false, RTZ }, // 264
  { "convert_short_sat", OpenCL_std, true, true, false, false, RTE }, // 265
  { "convert_short_sat_rte", OpenCL_std, true, true, true, false, RTE }, // 266
  { "convert_short_sat_rtn", OpenCL_std, true, true, true, false, RTN }, // 267
  { "convert_short_sat_rtp", OpenCL_std, true, true, true, false, RTP }, // 268
  { "convert_short_sat_rtz", OpenCL_std, true, true, true, false, RTZ }, // 269
  { "convert_uchar", OpenCL_std, false, false, false, false, RTE }, // 270
  { "convert_uchar16", OpenCL_std, false, false, false, false, RTE }, // 271
  { "convert_uchar16_rte", OpenCL_std, false, false, true, false, RTE }, // 272
  { "convert_uchar16_rtn", OpenCL_std, false, false, true, false, RTN }, // 273
  { "convert_uchar16_rtp", OpenCL_std, false, false, true, false, RTP }, // 274
  { "convert_uchar16_rtz", OpenCL_std, false, false, true, false, RTZ }, // 275
  { "convert_uchar16_sat", OpenCL_std, false, true, false, false, RTE }, // 276
  { "convert_uchar16_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 277
  { "convert_uchar16_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 278
  { "convert_uchar16_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 279
  { "convert_uchar16_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 280
  { "convert_uchar2", OpenCL_std, false, false, false, false, RTE }, // 281
  { "convert_uchar2_rte", OpenCL_std, false, false, true, false, RTE }, // 282
  { "convert_uchar2_rtn", OpenCL_std, false, false, true, false, RTN }, // 283
  { "convert_uchar2_rtp", OpenCL_std, false, false, true, false, RTP }, // 284
  { "convert_uchar2_rtz", OpenCL_std, false, false, true, false, RTZ }, // 285
  { "convert_uchar2_sat", OpenCL_std, false, true, false, false, RTE }, // 286
  { "convert_uchar2_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 287
  { "convert_uchar2_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 288
  { "convert_uchar2_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 289
  { "convert_uchar2_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 290
  { "convert_uchar3", OpenCL_std, false, false, false, false, RTE }, // 291
  { "convert_uchar3_rte", OpenCL_std, false, false, true, false, RTE }, // 292
  { "convert_uchar3_rtn", OpenCL_std, false, false, true, false, RTN }, // 293
  { "convert_uchar3_rtp", OpenCL_std, false, false, true, false, RTP }, // 294
  { "convert_uchar3_rtz", OpenCL_std, false, false, true, false, RTZ }, // 295
  { "convert_uchar3_sat", OpenCL_std, false, true, false, false, RTE }, // 296
  { "convert_uchar3_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 297
  { "convert_uchar3_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 298
  { "convert_uchar3_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 299
  { "convert_uchar3_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 300
  { "convert_uchar4", OpenCL_std, false, false, false, false, RTE }, // 301
  { "convert_uchar4_rte", OpenCL_std, false, false, true, false, RTE }, // 302
  { "convert_uchar4_rtn", OpenCL_std, false, false, true, false, RTN }, // 303
  { "convert_uchar4_rtp", OpenCL_std, false, false, true, false, RTP }, // 304
  { "convert_uchar4_rtz", OpenCL_std, false, false, true, false, RTZ }, // 305
  { "convert_uchar4_sat", OpenCL_std, false, true, false, false, RTE }, // 306
  { "convert_uchar4_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 307
  { "convert_uchar4_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 308
  { "convert_uchar4_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 309
  { "convert_uchar4_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 310
  { "convert_uchar8", OpenCL_std, false, false, false, false, RTE }, // 311
  { "convert_uchar8_rte", OpenCL_std, false, false, true, false, RTE }, // 312
  { "convert_uchar8_rtn", OpenCL_std, false, false, true, false, RTN }, // 313
  { "convert_uchar8_rtp", OpenCL_std, false, false, true, false, RTP }, // 314
  { "convert_uchar8_rtz", OpenCL_std, false, false, true, false, RTZ }, // 315
  { "convert_uchar8_sat", OpenCL_std, false, true, false, false, RTE }, // 316
  { "convert_uchar8_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 317
  { "convert_uchar8_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 318
  { "convert_uchar8_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 319
  { "convert_uchar8_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 320
  { "convert_uchar_rte", OpenCL_std, false, false, true, false, RTE }, // 321
  { "convert_uchar_rtn", OpenCL_std, false, false, true, false, RTN }, // 322
  { "convert_uchar_rtp", OpenCL_std, false, false, true, false, RTP }, // 323
  { "convert_uchar_rtz", OpenCL_std, false, false, true, false, RTZ }, // 324
  { "convert_uchar_sat", OpenCL_std, false, true, false, false, RTE }, // 325
  { "convert_uchar_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 326
  { "convert_uchar_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 327
  { "convert_uchar_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 328
  { "convert_uchar_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 329
  { "convert_uint", OpenCL_std, false, false, false, false, RTE }, // 330
  { "convert_uint16", OpenCL_std, false, false, false, false, RTE }, // 331
  { "convert_uint16_rte", OpenCL_std, false, false, true, false, RTE }, // 332
  { "convert_uint16_rtn", OpenCL_std, false, false, true, false, RTN }, // 333
  { "convert_uint16_rtp", OpenCL_std, false, false, true, false, RTP }, // 334
  { "convert_uint16_rtz", OpenCL_std, false, false, true, false, RTZ }, // 335
  { "convert_uint16_sat", OpenCL_std, false, true, false, false, RTE }, // 336
  { "convert_uint16_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 337
  { "convert_uint16_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 338
  { "convert_uint16_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 339
  { "convert_uint16_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 340
  { "convert_uint2", OpenCL_std, false, false, false, false, RTE }, // 341
  { "convert_uint2_rte", OpenCL_std, false, false, true, false, RTE }, // 342
  { "convert_uint2_rtn", OpenCL_std, false, false, true, false, RTN }, // 343
  { "convert_uint2_rtp", OpenCL_std, false, false, true, false, RTP }, // 344
  { "convert_uint2_rtz", OpenCL_std, false, false, true, false, RTZ }, // 345
  { "convert_uint2_sat", OpenCL_std, false, true, false, false, RTE }, // 346
  { "convert_uint2_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 347
  { "convert_uint2_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 348
  { "convert_uint2_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 349
  { "convert_uint2_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 350
  { "convert_uint3", OpenCL_std, false, false, false, false, RTE }, // 351
  { "convert_uint3_rte", OpenCL_std, false, false, true, false, RTE }, // 352
  { "convert_uint3_rtn", OpenCL_std, false, false, true, false, RTN }, // 353
  { "convert_uint3_rtp", OpenCL_std, false, false, true, false, RTP }, // 354
  { "convert_uint3_rtz", OpenCL_std, false, false, true, false, RTZ }, // 355
  { "convert_uint3_sat", OpenCL_std, false, true, false, false, RTE }, // 356
  { "convert_uint3_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 357
  { "convert_uint3_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 358
  { "convert_uint3_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 359
  { "convert_uint3_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 360
  { "convert_uint4", OpenCL_std, false, false, false, false, RTE }, // 361
  { "convert_uint4_rte", OpenCL_std, false, false, true, false, RTE }, // 362
  { "convert_uint4_rtn", OpenCL_std, false, false, true, false, RTN }, // 363
  { "convert_uint4_rtp", OpenCL_std, false, false, true, false, RTP }, // 364
  { "convert_uint4_rtz", OpenCL_std, false, false, true, false, RTZ }, // 365
  { "convert_uint4_sat", OpenCL_std, false, true, false, false, RTE }, // 366
  { "convert_uint4_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 367
  { "convert_uint4_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 368
  { "convert_uint4_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 369
  { "convert_uint4_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 370
  { "convert_uint8", OpenCL_std, false, false, false, false, RTE }, // 371
  { "convert_uint8_rte", OpenCL_std, false, false, true, false, RTE }, // 372
  { "convert_uint8_rtn", OpenCL_std, false, false, true, false, RTN }, // 373
  { "convert_uint8_rtp", OpenCL_std, false, false, true, false, RTP }, // 374
  { "convert_uint8_rtz", OpenCL_std, false, false, true, false, RTZ }, // 375
  { "convert_uint8_sat", OpenCL_std, false, true, false, false, RTE }, // 376
  { "convert_uint8_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 377
  { "convert_uint8_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 378
  { "convert_uint8_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 379
  { "convert_uint8_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 380
  { "convert_uint_rte", OpenCL_std, false, false, true, false, RTE }, // 381
  { "convert_uint_rtn", OpenCL_std, false, false, true, false, RTN }, // 382
  { "convert_uint_rtp", OpenCL_std, false, false, true, false, RTP }, // 383
  { "convert_uint_rtz", OpenCL_std, false, false, true, false, RTZ }, // 384
  { "convert_uint_sat", OpenCL_std, false, true, false, false, RTE }, // 385
  { "convert_uint_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 386
  { "convert_uint_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 387
  { "convert_uint_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 388
  { "convert_uint_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 389
  { "convert_ulong", OpenCL_std, false, false, false, false, RTE }, // 390
  { "convert_ulong16", OpenCL_std, false, false, false, false, RTE }, // 391
  { "convert_ulong16_rte", OpenCL_std, false, false, true, false, RTE }, // 392
  { "convert_ulong16_rtn", OpenCL_std, false, false, true, false, RTN }, // 393
  { "convert_ulong16_rtp", OpenCL_std, false, false, true, false, RTP }, // 394
  { "convert_ulong16_rtz", OpenCL_std, false, false, true, false, RTZ }, // 395
  { "convert_ulong16_sat", OpenCL_std, false, true, false, false, RTE }, // 396
  { "convert_ulong16_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 397
  { "convert_ulong16_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 398
  { "convert_ulong16_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 399
  { "convert_ulong16_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 400
  { "convert_ulong2", OpenCL_std, false, false, false, false, RTE }, // 401
  { "convert_ulong2_rte", OpenCL_std, false, false, true, false, RTE }, // 402
  { "convert_ulong2_rtn", OpenCL_std, false, false, true, false, RTN }, // 403
  { "convert_ulong2_rtp", OpenCL_std, false, false, true, false, RTP }, // 404
  { "convert_ulong2_rtz", OpenCL_std, false, false, true, false, RTZ }, // 405
  { "convert_ulong2_sat", OpenCL_std, false, true, false, false, RTE }, // 406
  { "convert_ulong2_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 407
  { "convert_ulong2_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 408
  { "convert_ulong2_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 409
  { "convert_ulong2_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 410
  { "convert_ulong3", OpenCL_std, false, false, false, false, RTE }, // 411
  { "convert_ulong3_rte", OpenCL_std, false, false, true, false, RTE }, // 412
  { "convert_ulong3_rtn", OpenCL_std, false, false, true, false, RTN }, // 413
  { "convert_ulong3_rtp", OpenCL_std, false, false, true, false, RTP }, // 414
  { "convert_ulong3_rtz", OpenCL_std, false, false, true, false, RTZ }, // 415
  { "convert_ulong3_sat", OpenCL_std, false, true, false, false, RTE }, // 416
  { "convert_ulong3_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 417
  { "convert_ulong3_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 418
  { "convert_ulong3_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 419
  { "convert_ulong3_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 420
  { "convert_ulong4", OpenCL_std, false, false, false, false, RTE }, // 421
  { "convert_ulong4_rte", OpenCL_std, false, false, true, false, RTE }, // 422
  { "convert_ulong4_rtn", OpenCL_std, false, false, true, false, RTN }, // 423
  { "convert_ulong4_rtp", OpenCL_std, false, false, true, false, RTP }, // 424
  { "convert_ulong4_rtz", OpenCL_std, false, false, true, false, RTZ }, // 425
  { "convert_ulong4_sat", OpenCL_std, false, true, false, false, RTE }, // 426
  { "convert_ulong4_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 427
  { "convert_ulong4_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 428
  { "convert_ulong4_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 429
  { "convert_ulong4_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 430
  { "convert_ulong8", OpenCL_std, false, false, false, false, RTE }, // 431
  { "convert_ulong8_rte", OpenCL_std, false, false, true, false, RTE }, // 432
  { "convert_ulong8_rtn", OpenCL_std, false, false, true, false, RTN }, // 433
  { "convert_ulong8_rtp", OpenCL_std, false, false, true, false, RTP }, // 434
  { "convert_ulong8_rtz", OpenCL_std, false, false, true, false, RTZ }, // 435
  { "convert_ulong8_sat", OpenCL_std, false, true, false, false, RTE }, // 436
  { "convert_ulong8_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 437
  { "convert_ulong8_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 438
  { "convert_ulong8_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 439
  { "convert_ulong8_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 440
  { "convert_ulong_rte", OpenCL_std, false, false, true, false, RTE }, // 441
  { "convert_ulong_rtn", OpenCL_std, false, false, true, false, RTN }, // 442
  { "convert_ulong_rtp", OpenCL_std, false, false, true, false, RTP }, // 443
  { "convert_ulong_rtz", OpenCL_std, false, false, true, false, RTZ }, // 444
  { "convert_ulong_sat", OpenCL_std, false, true, false, false, RTE }, // 445
  { "convert_ulong_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 446
  { "convert_ulong_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 447
  { "convert_ulong_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 448
  { "convert_ulong_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 449
  { "convert_ushort", OpenCL_std, false, false, false, false, RTE }, // 450
  { "convert_ushort16", OpenCL_std, false, false, false, false, RTE }, // 451
  { "convert_ushort16_rte", OpenCL_std, false, false, true, false, RTE }, // 452
  { "convert_ushort16_rtn", OpenCL_std, false, false, true, false, RTN }, // 453
  { "convert_ushort16_rtp", OpenCL_std, false, false, true, false, RTP }, // 454
  { "convert_ushort16_rtz", OpenCL_std, false, false, true, false, RTZ }, // 455
  { "convert_ushort16_sat", OpenCL_std, false, true, false, false, RTE }, // 456
  { "convert_ushort16_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 457
  { "convert_ushort16_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 458
  { "convert_ushort16_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 459
  { "convert_ushort16_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 460
  { "convert_ushort2", OpenCL_std, false, false, false, false, RTE }, // 461
  { "convert_ushort2_rte", OpenCL_std, false, false, true, false, RTE }, // 462
  { "convert_ushort2_rtn", OpenCL_std, false, false, true, false, RTN }, // 463
  { "convert_ushort2_rtp", OpenCL_std, false, false, true, false, RTP }, // 464
  { "convert_ushort2_rtz", OpenCL_std, false, false, true, false, RTZ }, // 465
  { "convert_ushort2_sat", OpenCL_std, false, true, false, false, RTE }, // 466
  { "convert_ushort2_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 467
  { "convert_ushort2_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 468
  { "convert_ushort2_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 469
  { "convert_ushort2_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 470
  { "convert_ushort3", OpenCL_std, false, false, false, false, RTE }, // 471
  { "convert_ushort3_rte", OpenCL_std, false, false, true, false, RTE }, // 472
  { "convert_ushort3_rtn", OpenCL_std, false, false, true, false, RTN }, // 473
  { "convert_ushort3_rtp", OpenCL_std, false, false, true, false, RTP }, // 474
  { "convert_ushort3_rtz", OpenCL_std, false, false, true, false, RTZ }, // 475
  { "convert_ushort3_sat", OpenCL_std, false, true, false, false, RTE }, // 476
  { "convert_ushort3_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 477
  { "convert_ushort3_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 478
  { "convert_ushort3_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 479
  { "convert_ushort3_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 480
  { "convert_ushort4", OpenCL_std, false, false, false, false, RTE }, // 481
  { "convert_ushort4_rte", OpenCL_std, false, false, true, false, RTE }, // 482
  { "convert_ushort4_rtn", OpenCL_std, false, false, true, false, RTN }, // 483
  { "convert_ushort4_rtp", OpenCL_std, false, false, true, false, RTP }, // 484
  { "convert_ushort4_rtz", OpenCL_std, false, false, true, false, RTZ }, // 485
  { "convert_ushort4_sat", OpenCL_std, false, true, false, false, RTE }, // 486
  { "convert_ushort4_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 487
  { "convert_ushort4_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 488
  { "convert_ushort4_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 489
  { "convert_ushort4_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 490
  { "convert_ushort8", OpenCL_std, false, false, false, false, RTE }, // 491
  { "convert_ushort8_rte", OpenCL_std, false, false, true, false, RTE }, // 492
  { "convert_ushort8_rtn", OpenCL_std, false, false, true, false, RTN }, // 493
  { "convert_ushort8_rtp", OpenCL_std, false, false, true, false, RTP }, // 494
  { "convert_ushort8_rtz", OpenCL_std, false, false, true, false, RTZ }, // 495
  { "convert_ushort8_sat", OpenCL_std, false, true, false, false, RTE }, // 496
  { "convert_ushort8_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 497
  { "convert_ushort8_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 498
  { "convert_ushort8_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 499
  { "convert_ushort8_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 500
  { "convert_ushort_rte", OpenCL_std, false, false, true, false, RTE }, // 501
  { "convert_ushort_rtn", OpenCL_std, false, false, true, false, RTN }, // 502
  { "convert_ushort_rtp", OpenCL_std, false, false, true, false, RTP }, // 503
  { "convert_ushort_rtz", OpenCL_std, false, false, true, false, RTZ }, // 504
  { "convert_ushort_sat", OpenCL_std, false, true, false, false, RTE }, // 505
  { "convert_ushort_sat_rte", OpenCL_std, false, true, true, false, RTE }, // 506
  { "convert_ushort_sat_rtn", OpenCL_std, false, true, true, false, RTN }, // 507
  { "convert_ushort_sat_rtp", OpenCL_std, false, true, true, false, RTP }, // 508
  { "convert_ushort_sat_rtz", OpenCL_std, false, true, true, false, RTZ }, // 509
  { "intel_convert_as_bfloat1616_float16", OpenCL_std, true, false, false, true, RTE }, // 510
  { "intel_convert_as_bfloat162_float2", OpenCL_std, true, false, false, true, RTE }, // 511
  { "intel_convert_as_bfloat163_float3", OpenCL_std, true, false, false, true, RTE }, // 512
  { "intel_convert_as_bfloat164_float4", OpenCL_std, true, false, false, true, RTE }, // 513
  { "intel_convert_as_bfloat168_float8", OpenCL_std, true, false, false, true, RTE }, // 514
  { "intel_convert_as_bfloat16_float", OpenCL_std, true, false, false, true, RTE }, // 515
  { "intel_convert_bfloat1616_as_ushort16", OpenCL_std, true, false, false, true, RTE }, // 516
  { "intel_convert_bfloat162_as_ushort2", OpenCL_std, true, false, false, true, RTE }, // 517
  { "intel_convert_bfloat163_as_ushort3", OpenCL_std, true, false, false, true, RTE }, // 518
  { "intel_convert_bfloat164_as_ushort4", OpenCL_std, true, false, false, true, RTE }, // 519
  { "intel_convert_bfloat168_as_ushort8", OpenCL_std, true, false, false, true, RTE }, // 520
  { "intel_convert_bfloat16_as_ushort", OpenCL_std, true, false, false, true, RTE }, // 521
  { "__spirv_ConvertBF16ToFINTEL", OpenCL_std, true, false, false, true, RTE }, // 522
  { "__spirv_ConvertFToBF16INTEL", OpenCL_std, true, false, false, true, RTE }, // 523
 };

const ConvertBuiltin *lookupConvertBuiltin(StringRef Name, unsigned Set) {
  struct IndexType {
    const char * Name;
    unsigned Set;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "CONVERT_CHAR", OpenCL_std, 0 },
    { "CONVERT_CHAR16", OpenCL_std, 1 },
    { "CONVERT_CHAR16_RTE", OpenCL_std, 2 },
    { "CONVERT_CHAR16_RTN", OpenCL_std, 3 },
    { "CONVERT_CHAR16_RTP", OpenCL_std, 4 },
    { "CONVERT_CHAR16_RTZ", OpenCL_std, 5 },
    { "CONVERT_CHAR16_SAT", OpenCL_std, 6 },
    { "CONVERT_CHAR16_SAT_RTE", OpenCL_std, 7 },
    { "CONVERT_CHAR16_SAT_RTN", OpenCL_std, 8 },
    { "CONVERT_CHAR16_SAT_RTP", OpenCL_std, 9 },
    { "CONVERT_CHAR16_SAT_RTZ", OpenCL_std, 10 },
    { "CONVERT_CHAR2", OpenCL_std, 11 },
    { "CONVERT_CHAR2_RTE", OpenCL_std, 12 },
    { "CONVERT_CHAR2_RTN", OpenCL_std, 13 },
    { "CONVERT_CHAR2_RTP", OpenCL_std, 14 },
    { "CONVERT_CHAR2_RTZ", OpenCL_std, 15 },
    { "CONVERT_CHAR2_SAT", OpenCL_std, 16 },
    { "CONVERT_CHAR2_SAT_RTE", OpenCL_std, 17 },
    { "CONVERT_CHAR2_SAT_RTN", OpenCL_std, 18 },
    { "CONVERT_CHAR2_SAT_RTP", OpenCL_std, 19 },
    { "CONVERT_CHAR2_SAT_RTZ", OpenCL_std, 20 },
    { "CONVERT_CHAR3", OpenCL_std, 21 },
    { "CONVERT_CHAR3_RTE", OpenCL_std, 22 },
    { "CONVERT_CHAR3_RTN", OpenCL_std, 23 },
    { "CONVERT_CHAR3_RTP", OpenCL_std, 24 },
    { "CONVERT_CHAR3_RTZ", OpenCL_std, 25 },
    { "CONVERT_CHAR3_SAT", OpenCL_std, 26 },
    { "CONVERT_CHAR3_SAT_RTE", OpenCL_std, 27 },
    { "CONVERT_CHAR3_SAT_RTN", OpenCL_std, 28 },
    { "CONVERT_CHAR3_SAT_RTP", OpenCL_std, 29 },
    { "CONVERT_CHAR3_SAT_RTZ", OpenCL_std, 30 },
    { "CONVERT_CHAR4", OpenCL_std, 31 },
    { "CONVERT_CHAR4_RTE", OpenCL_std, 32 },
    { "CONVERT_CHAR4_RTN", OpenCL_std, 33 },
    { "CONVERT_CHAR4_RTP", OpenCL_std, 34 },
    { "CONVERT_CHAR4_RTZ", OpenCL_std, 35 },
    { "CONVERT_CHAR4_SAT", OpenCL_std, 36 },
    { "CONVERT_CHAR4_SAT_RTE", OpenCL_std, 37 },
    { "CONVERT_CHAR4_SAT_RTN", OpenCL_std, 38 },
    { "CONVERT_CHAR4_SAT_RTP", OpenCL_std, 39 },
    { "CONVERT_CHAR4_SAT_RTZ", OpenCL_std, 40 },
    { "CONVERT_CHAR8", OpenCL_std, 41 },
    { "CONVERT_CHAR8_RTE", OpenCL_std, 42 },
    { "CONVERT_CHAR8_RTN", OpenCL_std, 43 },
    { "CONVERT_CHAR8_RTP", OpenCL_std, 44 },
    { "CONVERT_CHAR8_RTZ", OpenCL_std, 45 },
    { "CONVERT_CHAR8_SAT", OpenCL_std, 46 },
    { "CONVERT_CHAR8_SAT_RTE", OpenCL_std, 47 },
    { "CONVERT_CHAR8_SAT_RTN", OpenCL_std, 48 },
    { "CONVERT_CHAR8_SAT_RTP", OpenCL_std, 49 },
    { "CONVERT_CHAR8_SAT_RTZ", OpenCL_std, 50 },
    { "CONVERT_CHAR_RTE", OpenCL_std, 51 },
    { "CONVERT_CHAR_RTN", OpenCL_std, 52 },
    { "CONVERT_CHAR_RTP", OpenCL_std, 53 },
    { "CONVERT_CHAR_RTZ", OpenCL_std, 54 },
    { "CONVERT_CHAR_SAT", OpenCL_std, 55 },
    { "CONVERT_CHAR_SAT_RTE", OpenCL_std, 56 },
    { "CONVERT_CHAR_SAT_RTN", OpenCL_std, 57 },
    { "CONVERT_CHAR_SAT_RTP", OpenCL_std, 58 },
    { "CONVERT_CHAR_SAT_RTZ", OpenCL_std, 59 },
    { "CONVERT_FLOAT", OpenCL_std, 60 },
    { "CONVERT_FLOAT16", OpenCL_std, 61 },
    { "CONVERT_FLOAT16_RTE", OpenCL_std, 62 },
    { "CONVERT_FLOAT16_RTN", OpenCL_std, 63 },
    { "CONVERT_FLOAT16_RTP", OpenCL_std, 64 },
    { "CONVERT_FLOAT16_RTZ", OpenCL_std, 65 },
    { "CONVERT_FLOAT2", OpenCL_std, 66 },
    { "CONVERT_FLOAT2_RTE", OpenCL_std, 67 },
    { "CONVERT_FLOAT2_RTN", OpenCL_std, 68 },
    { "CONVERT_FLOAT2_RTP", OpenCL_std, 69 },
    { "CONVERT_FLOAT2_RTZ", OpenCL_std, 70 },
    { "CONVERT_FLOAT3", OpenCL_std, 71 },
    { "CONVERT_FLOAT3_RTE", OpenCL_std, 72 },
    { "CONVERT_FLOAT3_RTN", OpenCL_std, 73 },
    { "CONVERT_FLOAT3_RTP", OpenCL_std, 74 },
    { "CONVERT_FLOAT3_RTZ", OpenCL_std, 75 },
    { "CONVERT_FLOAT4", OpenCL_std, 76 },
    { "CONVERT_FLOAT4_RTE", OpenCL_std, 77 },
    { "CONVERT_FLOAT4_RTN", OpenCL_std, 78 },
    { "CONVERT_FLOAT4_RTP", OpenCL_std, 79 },
    { "CONVERT_FLOAT4_RTZ", OpenCL_std, 80 },
    { "CONVERT_FLOAT8", OpenCL_std, 81 },
    { "CONVERT_FLOAT8_RTE", OpenCL_std, 82 },
    { "CONVERT_FLOAT8_RTN", OpenCL_std, 83 },
    { "CONVERT_FLOAT8_RTP", OpenCL_std, 84 },
    { "CONVERT_FLOAT8_RTZ", OpenCL_std, 85 },
    { "CONVERT_FLOAT_RTE", OpenCL_std, 86 },
    { "CONVERT_FLOAT_RTN", OpenCL_std, 87 },
    { "CONVERT_FLOAT_RTP", OpenCL_std, 88 },
    { "CONVERT_FLOAT_RTZ", OpenCL_std, 89 },
    { "CONVERT_INT", OpenCL_std, 90 },
    { "CONVERT_INT16", OpenCL_std, 91 },
    { "CONVERT_INT16_RTE", OpenCL_std, 92 },
    { "CONVERT_INT16_RTN", OpenCL_std, 93 },
    { "CONVERT_INT16_RTP", OpenCL_std, 94 },
    { "CONVERT_INT16_RTZ", OpenCL_std, 95 },
    { "CONVERT_INT16_SAT", OpenCL_std, 96 },
    { "CONVERT_INT16_SAT_RTE", OpenCL_std, 97 },
    { "CONVERT_INT16_SAT_RTN", OpenCL_std, 98 },
    { "CONVERT_INT16_SAT_RTP", OpenCL_std, 99 },
    { "CONVERT_INT16_SAT_RTZ", OpenCL_std, 100 },
    { "CONVERT_INT2", OpenCL_std, 101 },
    { "CONVERT_INT2_RTE", OpenCL_std, 102 },
    { "CONVERT_INT2_RTN", OpenCL_std, 103 },
    { "CONVERT_INT2_RTP", OpenCL_std, 104 },
    { "CONVERT_INT2_RTZ", OpenCL_std, 105 },
    { "CONVERT_INT2_SAT", OpenCL_std, 106 },
    { "CONVERT_INT2_SAT_RTE", OpenCL_std, 107 },
    { "CONVERT_INT2_SAT_RTN", OpenCL_std, 108 },
    { "CONVERT_INT2_SAT_RTP", OpenCL_std, 109 },
    { "CONVERT_INT2_SAT_RTZ", OpenCL_std, 110 },
    { "CONVERT_INT3", OpenCL_std, 111 },
    { "CONVERT_INT3_RTE", OpenCL_std, 112 },
    { "CONVERT_INT3_RTN", OpenCL_std, 113 },
    { "CONVERT_INT3_RTP", OpenCL_std, 114 },
    { "CONVERT_INT3_RTZ", OpenCL_std, 115 },
    { "CONVERT_INT3_SAT", OpenCL_std, 116 },
    { "CONVERT_INT3_SAT_RTE", OpenCL_std, 117 },
    { "CONVERT_INT3_SAT_RTN", OpenCL_std, 118 },
    { "CONVERT_INT3_SAT_RTP", OpenCL_std, 119 },
    { "CONVERT_INT3_SAT_RTZ", OpenCL_std, 120 },
    { "CONVERT_INT4", OpenCL_std, 121 },
    { "CONVERT_INT4_RTE", OpenCL_std, 122 },
    { "CONVERT_INT4_RTN", OpenCL_std, 123 },
    { "CONVERT_INT4_RTP", OpenCL_std, 124 },
    { "CONVERT_INT4_RTZ", OpenCL_std, 125 },
    { "CONVERT_INT4_SAT", OpenCL_std, 126 },
    { "CONVERT_INT4_SAT_RTE", OpenCL_std, 127 },
    { "CONVERT_INT4_SAT_RTN", OpenCL_std, 128 },
    { "CONVERT_INT4_SAT_RTP", OpenCL_std, 129 },
    { "CONVERT_INT4_SAT_RTZ", OpenCL_std, 130 },
    { "CONVERT_INT8", OpenCL_std, 131 },
    { "CONVERT_INT8_RTE", OpenCL_std, 132 },
    { "CONVERT_INT8_RTN", OpenCL_std, 133 },
    { "CONVERT_INT8_RTP", OpenCL_std, 134 },
    { "CONVERT_INT8_RTZ", OpenCL_std, 135 },
    { "CONVERT_INT8_SAT", OpenCL_std, 136 },
    { "CONVERT_INT8_SAT_RTE", OpenCL_std, 137 },
    { "CONVERT_INT8_SAT_RTN", OpenCL_std, 138 },
    { "CONVERT_INT8_SAT_RTP", OpenCL_std, 139 },
    { "CONVERT_INT8_SAT_RTZ", OpenCL_std, 140 },
    { "CONVERT_INT_RTE", OpenCL_std, 141 },
    { "CONVERT_INT_RTN", OpenCL_std, 142 },
    { "CONVERT_INT_RTP", OpenCL_std, 143 },
    { "CONVERT_INT_RTZ", OpenCL_std, 144 },
    { "CONVERT_INT_SAT", OpenCL_std, 145 },
    { "CONVERT_INT_SAT_RTE", OpenCL_std, 146 },
    { "CONVERT_INT_SAT_RTN", OpenCL_std, 147 },
    { "CONVERT_INT_SAT_RTP", OpenCL_std, 148 },
    { "CONVERT_INT_SAT_RTZ", OpenCL_std, 149 },
    { "CONVERT_LONG", OpenCL_std, 150 },
    { "CONVERT_LONG16", OpenCL_std, 151 },
    { "CONVERT_LONG16_RTE", OpenCL_std, 152 },
    { "CONVERT_LONG16_RTN", OpenCL_std, 153 },
    { "CONVERT_LONG16_RTP", OpenCL_std, 154 },
    { "CONVERT_LONG16_RTZ", OpenCL_std, 155 },
    { "CONVERT_LONG16_SAT", OpenCL_std, 156 },
    { "CONVERT_LONG16_SAT_RTE", OpenCL_std, 157 },
    { "CONVERT_LONG16_SAT_RTN", OpenCL_std, 158 },
    { "CONVERT_LONG16_SAT_RTP", OpenCL_std, 159 },
    { "CONVERT_LONG16_SAT_RTZ", OpenCL_std, 160 },
    { "CONVERT_LONG2", OpenCL_std, 161 },
    { "CONVERT_LONG2_RTE", OpenCL_std, 162 },
    { "CONVERT_LONG2_RTN", OpenCL_std, 163 },
    { "CONVERT_LONG2_RTP", OpenCL_std, 164 },
    { "CONVERT_LONG2_RTZ", OpenCL_std, 165 },
    { "CONVERT_LONG2_SAT", OpenCL_std, 166 },
    { "CONVERT_LONG2_SAT_RTE", OpenCL_std, 167 },
    { "CONVERT_LONG2_SAT_RTN", OpenCL_std, 168 },
    { "CONVERT_LONG2_SAT_RTP", OpenCL_std, 169 },
    { "CONVERT_LONG2_SAT_RTZ", OpenCL_std, 170 },
    { "CONVERT_LONG3", OpenCL_std, 171 },
    { "CONVERT_LONG3_RTE", OpenCL_std, 172 },
    { "CONVERT_LONG3_RTN", OpenCL_std, 173 },
    { "CONVERT_LONG3_RTP", OpenCL_std, 174 },
    { "CONVERT_LONG3_RTZ", OpenCL_std, 175 },
    { "CONVERT_LONG3_SAT", OpenCL_std, 176 },
    { "CONVERT_LONG3_SAT_RTE", OpenCL_std, 177 },
    { "CONVERT_LONG3_SAT_RTN", OpenCL_std, 178 },
    { "CONVERT_LONG3_SAT_RTP", OpenCL_std, 179 },
    { "CONVERT_LONG3_SAT_RTZ", OpenCL_std, 180 },
    { "CONVERT_LONG4", OpenCL_std, 181 },
    { "CONVERT_LONG4_RTE", OpenCL_std, 182 },
    { "CONVERT_LONG4_RTN", OpenCL_std, 183 },
    { "CONVERT_LONG4_RTP", OpenCL_std, 184 },
    { "CONVERT_LONG4_RTZ", OpenCL_std, 185 },
    { "CONVERT_LONG4_SAT", OpenCL_std, 186 },
    { "CONVERT_LONG4_SAT_RTE", OpenCL_std, 187 },
    { "CONVERT_LONG4_SAT_RTN", OpenCL_std, 188 },
    { "CONVERT_LONG4_SAT_RTP", OpenCL_std, 189 },
    { "CONVERT_LONG4_SAT_RTZ", OpenCL_std, 190 },
    { "CONVERT_LONG8", OpenCL_std, 191 },
    { "CONVERT_LONG8_RTE", OpenCL_std, 192 },
    { "CONVERT_LONG8_RTN", OpenCL_std, 193 },
    { "CONVERT_LONG8_RTP", OpenCL_std, 194 },
    { "CONVERT_LONG8_RTZ", OpenCL_std, 195 },
    { "CONVERT_LONG8_SAT", OpenCL_std, 196 },
    { "CONVERT_LONG8_SAT_RTE", OpenCL_std, 197 },
    { "CONVERT_LONG8_SAT_RTN", OpenCL_std, 198 },
    { "CONVERT_LONG8_SAT_RTP", OpenCL_std, 199 },
    { "CONVERT_LONG8_SAT_RTZ", OpenCL_std, 200 },
    { "CONVERT_LONG_RTE", OpenCL_std, 201 },
    { "CONVERT_LONG_RTN", OpenCL_std, 202 },
    { "CONVERT_LONG_RTP", OpenCL_std, 203 },
    { "CONVERT_LONG_RTZ", OpenCL_std, 204 },
    { "CONVERT_LONG_SAT", OpenCL_std, 205 },
    { "CONVERT_LONG_SAT_RTE", OpenCL_std, 206 },
    { "CONVERT_LONG_SAT_RTN", OpenCL_std, 207 },
    { "CONVERT_LONG_SAT_RTP", OpenCL_std, 208 },
    { "CONVERT_LONG_SAT_RTZ", OpenCL_std, 209 },
    { "CONVERT_SHORT", OpenCL_std, 210 },
    { "CONVERT_SHORT16", OpenCL_std, 211 },
    { "CONVERT_SHORT16_RTE", OpenCL_std, 212 },
    { "CONVERT_SHORT16_RTN", OpenCL_std, 213 },
    { "CONVERT_SHORT16_RTP", OpenCL_std, 214 },
    { "CONVERT_SHORT16_RTZ", OpenCL_std, 215 },
    { "CONVERT_SHORT16_SAT", OpenCL_std, 216 },
    { "CONVERT_SHORT16_SAT_RTE", OpenCL_std, 217 },
    { "CONVERT_SHORT16_SAT_RTN", OpenCL_std, 218 },
    { "CONVERT_SHORT16_SAT_RTP", OpenCL_std, 219 },
    { "CONVERT_SHORT16_SAT_RTZ", OpenCL_std, 220 },
    { "CONVERT_SHORT2", OpenCL_std, 221 },
    { "CONVERT_SHORT2_RTE", OpenCL_std, 222 },
    { "CONVERT_SHORT2_RTN", OpenCL_std, 223 },
    { "CONVERT_SHORT2_RTP", OpenCL_std, 224 },
    { "CONVERT_SHORT2_RTZ", OpenCL_std, 225 },
    { "CONVERT_SHORT2_SAT", OpenCL_std, 226 },
    { "CONVERT_SHORT2_SAT_RTE", OpenCL_std, 227 },
    { "CONVERT_SHORT2_SAT_RTN", OpenCL_std, 228 },
    { "CONVERT_SHORT2_SAT_RTP", OpenCL_std, 229 },
    { "CONVERT_SHORT2_SAT_RTZ", OpenCL_std, 230 },
    { "CONVERT_SHORT3", OpenCL_std, 231 },
    { "CONVERT_SHORT3_RTE", OpenCL_std, 232 },
    { "CONVERT_SHORT3_RTN", OpenCL_std, 233 },
    { "CONVERT_SHORT3_RTP", OpenCL_std, 234 },
    { "CONVERT_SHORT3_RTZ", OpenCL_std, 235 },
    { "CONVERT_SHORT3_SAT", OpenCL_std, 236 },
    { "CONVERT_SHORT3_SAT_RTE", OpenCL_std, 237 },
    { "CONVERT_SHORT3_SAT_RTN", OpenCL_std, 238 },
    { "CONVERT_SHORT3_SAT_RTP", OpenCL_std, 239 },
    { "CONVERT_SHORT3_SAT_RTZ", OpenCL_std, 240 },
    { "CONVERT_SHORT4", OpenCL_std, 241 },
    { "CONVERT_SHORT4_RTE", OpenCL_std, 242 },
    { "CONVERT_SHORT4_RTN", OpenCL_std, 243 },
    { "CONVERT_SHORT4_RTP", OpenCL_std, 244 },
    { "CONVERT_SHORT4_RTZ", OpenCL_std, 245 },
    { "CONVERT_SHORT4_SAT", OpenCL_std, 246 },
    { "CONVERT_SHORT4_SAT_RTE", OpenCL_std, 247 },
    { "CONVERT_SHORT4_SAT_RTN", OpenCL_std, 248 },
    { "CONVERT_SHORT4_SAT_RTP", OpenCL_std, 249 },
    { "CONVERT_SHORT4_SAT_RTZ", OpenCL_std, 250 },
    { "CONVERT_SHORT8", OpenCL_std, 251 },
    { "CONVERT_SHORT8_RTE", OpenCL_std, 252 },
    { "CONVERT_SHORT8_RTN", OpenCL_std, 253 },
    { "CONVERT_SHORT8_RTP", OpenCL_std, 254 },
    { "CONVERT_SHORT8_RTZ", OpenCL_std, 255 },
    { "CONVERT_SHORT8_SAT", OpenCL_std, 256 },
    { "CONVERT_SHORT8_SAT_RTE", OpenCL_std, 257 },
    { "CONVERT_SHORT8_SAT_RTN", OpenCL_std, 258 },
    { "CONVERT_SHORT8_SAT_RTP", OpenCL_std, 259 },
    { "CONVERT_SHORT8_SAT_RTZ", OpenCL_std, 260 },
    { "CONVERT_SHORT_RTE", OpenCL_std, 261 },
    { "CONVERT_SHORT_RTN", OpenCL_std, 262 },
    { "CONVERT_SHORT_RTP", OpenCL_std, 263 },
    { "CONVERT_SHORT_RTZ", OpenCL_std, 264 },
    { "CONVERT_SHORT_SAT", OpenCL_std, 265 },
    { "CONVERT_SHORT_SAT_RTE", OpenCL_std, 266 },
    { "CONVERT_SHORT_SAT_RTN", OpenCL_std, 267 },
    { "CONVERT_SHORT_SAT_RTP", OpenCL_std, 268 },
    { "CONVERT_SHORT_SAT_RTZ", OpenCL_std, 269 },
    { "CONVERT_UCHAR", OpenCL_std, 270 },
    { "CONVERT_UCHAR16", OpenCL_std, 271 },
    { "CONVERT_UCHAR16_RTE", OpenCL_std, 272 },
    { "CONVERT_UCHAR16_RTN", OpenCL_std, 273 },
    { "CONVERT_UCHAR16_RTP", OpenCL_std, 274 },
    { "CONVERT_UCHAR16_RTZ", OpenCL_std, 275 },
    { "CONVERT_UCHAR16_SAT", OpenCL_std, 276 },
    { "CONVERT_UCHAR16_SAT_RTE", OpenCL_std, 277 },
    { "CONVERT_UCHAR16_SAT_RTN", OpenCL_std, 278 },
    { "CONVERT_UCHAR16_SAT_RTP", OpenCL_std, 279 },
    { "CONVERT_UCHAR16_SAT_RTZ", OpenCL_std, 280 },
    { "CONVERT_UCHAR2", OpenCL_std, 281 },
    { "CONVERT_UCHAR2_RTE", OpenCL_std, 282 },
    { "CONVERT_UCHAR2_RTN", OpenCL_std, 283 },
    { "CONVERT_UCHAR2_RTP", OpenCL_std, 284 },
    { "CONVERT_UCHAR2_RTZ", OpenCL_std, 285 },
    { "CONVERT_UCHAR2_SAT", OpenCL_std, 286 },
    { "CONVERT_UCHAR2_SAT_RTE", OpenCL_std, 287 },
    { "CONVERT_UCHAR2_SAT_RTN", OpenCL_std, 288 },
    { "CONVERT_UCHAR2_SAT_RTP", OpenCL_std, 289 },
    { "CONVERT_UCHAR2_SAT_RTZ", OpenCL_std, 290 },
    { "CONVERT_UCHAR3", OpenCL_std, 291 },
    { "CONVERT_UCHAR3_RTE", OpenCL_std, 292 },
    { "CONVERT_UCHAR3_RTN", OpenCL_std, 293 },
    { "CONVERT_UCHAR3_RTP", OpenCL_std, 294 },
    { "CONVERT_UCHAR3_RTZ", OpenCL_std, 295 },
    { "CONVERT_UCHAR3_SAT", OpenCL_std, 296 },
    { "CONVERT_UCHAR3_SAT_RTE", OpenCL_std, 297 },
    { "CONVERT_UCHAR3_SAT_RTN", OpenCL_std, 298 },
    { "CONVERT_UCHAR3_SAT_RTP", OpenCL_std, 299 },
    { "CONVERT_UCHAR3_SAT_RTZ", OpenCL_std, 300 },
    { "CONVERT_UCHAR4", OpenCL_std, 301 },
    { "CONVERT_UCHAR4_RTE", OpenCL_std, 302 },
    { "CONVERT_UCHAR4_RTN", OpenCL_std, 303 },
    { "CONVERT_UCHAR4_RTP", OpenCL_std, 304 },
    { "CONVERT_UCHAR4_RTZ", OpenCL_std, 305 },
    { "CONVERT_UCHAR4_SAT", OpenCL_std, 306 },
    { "CONVERT_UCHAR4_SAT_RTE", OpenCL_std, 307 },
    { "CONVERT_UCHAR4_SAT_RTN", OpenCL_std, 308 },
    { "CONVERT_UCHAR4_SAT_RTP", OpenCL_std, 309 },
    { "CONVERT_UCHAR4_SAT_RTZ", OpenCL_std, 310 },
    { "CONVERT_UCHAR8", OpenCL_std, 311 },
    { "CONVERT_UCHAR8_RTE", OpenCL_std, 312 },
    { "CONVERT_UCHAR8_RTN", OpenCL_std, 313 },
    { "CONVERT_UCHAR8_RTP", OpenCL_std, 314 },
    { "CONVERT_UCHAR8_RTZ", OpenCL_std, 315 },
    { "CONVERT_UCHAR8_SAT", OpenCL_std, 316 },
    { "CONVERT_UCHAR8_SAT_RTE", OpenCL_std, 317 },
    { "CONVERT_UCHAR8_SAT_RTN", OpenCL_std, 318 },
    { "CONVERT_UCHAR8_SAT_RTP", OpenCL_std, 319 },
    { "CONVERT_UCHAR8_SAT_RTZ", OpenCL_std, 320 },
    { "CONVERT_UCHAR_RTE", OpenCL_std, 321 },
    { "CONVERT_UCHAR_RTN", OpenCL_std, 322 },
    { "CONVERT_UCHAR_RTP", OpenCL_std, 323 },
    { "CONVERT_UCHAR_RTZ", OpenCL_std, 324 },
    { "CONVERT_UCHAR_SAT", OpenCL_std, 325 },
    { "CONVERT_UCHAR_SAT_RTE", OpenCL_std, 326 },
    { "CONVERT_UCHAR_SAT_RTN", OpenCL_std, 327 },
    { "CONVERT_UCHAR_SAT_RTP", OpenCL_std, 328 },
    { "CONVERT_UCHAR_SAT_RTZ", OpenCL_std, 329 },
    { "CONVERT_UINT", OpenCL_std, 330 },
    { "CONVERT_UINT16", OpenCL_std, 331 },
    { "CONVERT_UINT16_RTE", OpenCL_std, 332 },
    { "CONVERT_UINT16_RTN", OpenCL_std, 333 },
    { "CONVERT_UINT16_RTP", OpenCL_std, 334 },
    { "CONVERT_UINT16_RTZ", OpenCL_std, 335 },
    { "CONVERT_UINT16_SAT", OpenCL_std, 336 },
    { "CONVERT_UINT16_SAT_RTE", OpenCL_std, 337 },
    { "CONVERT_UINT16_SAT_RTN", OpenCL_std, 338 },
    { "CONVERT_UINT16_SAT_RTP", OpenCL_std, 339 },
    { "CONVERT_UINT16_SAT_RTZ", OpenCL_std, 340 },
    { "CONVERT_UINT2", OpenCL_std, 341 },
    { "CONVERT_UINT2_RTE", OpenCL_std, 342 },
    { "CONVERT_UINT2_RTN", OpenCL_std, 343 },
    { "CONVERT_UINT2_RTP", OpenCL_std, 344 },
    { "CONVERT_UINT2_RTZ", OpenCL_std, 345 },
    { "CONVERT_UINT2_SAT", OpenCL_std, 346 },
    { "CONVERT_UINT2_SAT_RTE", OpenCL_std, 347 },
    { "CONVERT_UINT2_SAT_RTN", OpenCL_std, 348 },
    { "CONVERT_UINT2_SAT_RTP", OpenCL_std, 349 },
    { "CONVERT_UINT2_SAT_RTZ", OpenCL_std, 350 },
    { "CONVERT_UINT3", OpenCL_std, 351 },
    { "CONVERT_UINT3_RTE", OpenCL_std, 352 },
    { "CONVERT_UINT3_RTN", OpenCL_std, 353 },
    { "CONVERT_UINT3_RTP", OpenCL_std, 354 },
    { "CONVERT_UINT3_RTZ", OpenCL_std, 355 },
    { "CONVERT_UINT3_SAT", OpenCL_std, 356 },
    { "CONVERT_UINT3_SAT_RTE", OpenCL_std, 357 },
    { "CONVERT_UINT3_SAT_RTN", OpenCL_std, 358 },
    { "CONVERT_UINT3_SAT_RTP", OpenCL_std, 359 },
    { "CONVERT_UINT3_SAT_RTZ", OpenCL_std, 360 },
    { "CONVERT_UINT4", OpenCL_std, 361 },
    { "CONVERT_UINT4_RTE", OpenCL_std, 362 },
    { "CONVERT_UINT4_RTN", OpenCL_std, 363 },
    { "CONVERT_UINT4_RTP", OpenCL_std, 364 },
    { "CONVERT_UINT4_RTZ", OpenCL_std, 365 },
    { "CONVERT_UINT4_SAT", OpenCL_std, 366 },
    { "CONVERT_UINT4_SAT_RTE", OpenCL_std, 367 },
    { "CONVERT_UINT4_SAT_RTN", OpenCL_std, 368 },
    { "CONVERT_UINT4_SAT_RTP", OpenCL_std, 369 },
    { "CONVERT_UINT4_SAT_RTZ", OpenCL_std, 370 },
    { "CONVERT_UINT8", OpenCL_std, 371 },
    { "CONVERT_UINT8_RTE", OpenCL_std, 372 },
    { "CONVERT_UINT8_RTN", OpenCL_std, 373 },
    { "CONVERT_UINT8_RTP", OpenCL_std, 374 },
    { "CONVERT_UINT8_RTZ", OpenCL_std, 375 },
    { "CONVERT_UINT8_SAT", OpenCL_std, 376 },
    { "CONVERT_UINT8_SAT_RTE", OpenCL_std, 377 },
    { "CONVERT_UINT8_SAT_RTN", OpenCL_std, 378 },
    { "CONVERT_UINT8_SAT_RTP", OpenCL_std, 379 },
    { "CONVERT_UINT8_SAT_RTZ", OpenCL_std, 380 },
    { "CONVERT_UINT_RTE", OpenCL_std, 381 },
    { "CONVERT_UINT_RTN", OpenCL_std, 382 },
    { "CONVERT_UINT_RTP", OpenCL_std, 383 },
    { "CONVERT_UINT_RTZ", OpenCL_std, 384 },
    { "CONVERT_UINT_SAT", OpenCL_std, 385 },
    { "CONVERT_UINT_SAT_RTE", OpenCL_std, 386 },
    { "CONVERT_UINT_SAT_RTN", OpenCL_std, 387 },
    { "CONVERT_UINT_SAT_RTP", OpenCL_std, 388 },
    { "CONVERT_UINT_SAT_RTZ", OpenCL_std, 389 },
    { "CONVERT_ULONG", OpenCL_std, 390 },
    { "CONVERT_ULONG16", OpenCL_std, 391 },
    { "CONVERT_ULONG16_RTE", OpenCL_std, 392 },
    { "CONVERT_ULONG16_RTN", OpenCL_std, 393 },
    { "CONVERT_ULONG16_RTP", OpenCL_std, 394 },
    { "CONVERT_ULONG16_RTZ", OpenCL_std, 395 },
    { "CONVERT_ULONG16_SAT", OpenCL_std, 396 },
    { "CONVERT_ULONG16_SAT_RTE", OpenCL_std, 397 },
    { "CONVERT_ULONG16_SAT_RTN", OpenCL_std, 398 },
    { "CONVERT_ULONG16_SAT_RTP", OpenCL_std, 399 },
    { "CONVERT_ULONG16_SAT_RTZ", OpenCL_std, 400 },
    { "CONVERT_ULONG2", OpenCL_std, 401 },
    { "CONVERT_ULONG2_RTE", OpenCL_std, 402 },
    { "CONVERT_ULONG2_RTN", OpenCL_std, 403 },
    { "CONVERT_ULONG2_RTP", OpenCL_std, 404 },
    { "CONVERT_ULONG2_RTZ", OpenCL_std, 405 },
    { "CONVERT_ULONG2_SAT", OpenCL_std, 406 },
    { "CONVERT_ULONG2_SAT_RTE", OpenCL_std, 407 },
    { "CONVERT_ULONG2_SAT_RTN", OpenCL_std, 408 },
    { "CONVERT_ULONG2_SAT_RTP", OpenCL_std, 409 },
    { "CONVERT_ULONG2_SAT_RTZ", OpenCL_std, 410 },
    { "CONVERT_ULONG3", OpenCL_std, 411 },
    { "CONVERT_ULONG3_RTE", OpenCL_std, 412 },
    { "CONVERT_ULONG3_RTN", OpenCL_std, 413 },
    { "CONVERT_ULONG3_RTP", OpenCL_std, 414 },
    { "CONVERT_ULONG3_RTZ", OpenCL_std, 415 },
    { "CONVERT_ULONG3_SAT", OpenCL_std, 416 },
    { "CONVERT_ULONG3_SAT_RTE", OpenCL_std, 417 },
    { "CONVERT_ULONG3_SAT_RTN", OpenCL_std, 418 },
    { "CONVERT_ULONG3_SAT_RTP", OpenCL_std, 419 },
    { "CONVERT_ULONG3_SAT_RTZ", OpenCL_std, 420 },
    { "CONVERT_ULONG4", OpenCL_std, 421 },
    { "CONVERT_ULONG4_RTE", OpenCL_std, 422 },
    { "CONVERT_ULONG4_RTN", OpenCL_std, 423 },
    { "CONVERT_ULONG4_RTP", OpenCL_std, 424 },
    { "CONVERT_ULONG4_RTZ", OpenCL_std, 425 },
    { "CONVERT_ULONG4_SAT", OpenCL_std, 426 },
    { "CONVERT_ULONG4_SAT_RTE", OpenCL_std, 427 },
    { "CONVERT_ULONG4_SAT_RTN", OpenCL_std, 428 },
    { "CONVERT_ULONG4_SAT_RTP", OpenCL_std, 429 },
    { "CONVERT_ULONG4_SAT_RTZ", OpenCL_std, 430 },
    { "CONVERT_ULONG8", OpenCL_std, 431 },
    { "CONVERT_ULONG8_RTE", OpenCL_std, 432 },
    { "CONVERT_ULONG8_RTN", OpenCL_std, 433 },
    { "CONVERT_ULONG8_RTP", OpenCL_std, 434 },
    { "CONVERT_ULONG8_RTZ", OpenCL_std, 435 },
    { "CONVERT_ULONG8_SAT", OpenCL_std, 436 },
    { "CONVERT_ULONG8_SAT_RTE", OpenCL_std, 437 },
    { "CONVERT_ULONG8_SAT_RTN", OpenCL_std, 438 },
    { "CONVERT_ULONG8_SAT_RTP", OpenCL_std, 439 },
    { "CONVERT_ULONG8_SAT_RTZ", OpenCL_std, 440 },
    { "CONVERT_ULONG_RTE", OpenCL_std, 441 },
    { "CONVERT_ULONG_RTN", OpenCL_std, 442 },
    { "CONVERT_ULONG_RTP", OpenCL_std, 443 },
    { "CONVERT_ULONG_RTZ", OpenCL_std, 444 },
    { "CONVERT_ULONG_SAT", OpenCL_std, 445 },
    { "CONVERT_ULONG_SAT_RTE", OpenCL_std, 446 },
    { "CONVERT_ULONG_SAT_RTN", OpenCL_std, 447 },
    { "CONVERT_ULONG_SAT_RTP", OpenCL_std, 448 },
    { "CONVERT_ULONG_SAT_RTZ", OpenCL_std, 449 },
    { "CONVERT_USHORT", OpenCL_std, 450 },
    { "CONVERT_USHORT16", OpenCL_std, 451 },
    { "CONVERT_USHORT16_RTE", OpenCL_std, 452 },
    { "CONVERT_USHORT16_RTN", OpenCL_std, 453 },
    { "CONVERT_USHORT16_RTP", OpenCL_std, 454 },
    { "CONVERT_USHORT16_RTZ", OpenCL_std, 455 },
    { "CONVERT_USHORT16_SAT", OpenCL_std, 456 },
    { "CONVERT_USHORT16_SAT_RTE", OpenCL_std, 457 },
    { "CONVERT_USHORT16_SAT_RTN", OpenCL_std, 458 },
    { "CONVERT_USHORT16_SAT_RTP", OpenCL_std, 459 },
    { "CONVERT_USHORT16_SAT_RTZ", OpenCL_std, 460 },
    { "CONVERT_USHORT2", OpenCL_std, 461 },
    { "CONVERT_USHORT2_RTE", OpenCL_std, 462 },
    { "CONVERT_USHORT2_RTN", OpenCL_std, 463 },
    { "CONVERT_USHORT2_RTP", OpenCL_std, 464 },
    { "CONVERT_USHORT2_RTZ", OpenCL_std, 465 },
    { "CONVERT_USHORT2_SAT", OpenCL_std, 466 },
    { "CONVERT_USHORT2_SAT_RTE", OpenCL_std, 467 },
    { "CONVERT_USHORT2_SAT_RTN", OpenCL_std, 468 },
    { "CONVERT_USHORT2_SAT_RTP", OpenCL_std, 469 },
    { "CONVERT_USHORT2_SAT_RTZ", OpenCL_std, 470 },
    { "CONVERT_USHORT3", OpenCL_std, 471 },
    { "CONVERT_USHORT3_RTE", OpenCL_std, 472 },
    { "CONVERT_USHORT3_RTN", OpenCL_std, 473 },
    { "CONVERT_USHORT3_RTP", OpenCL_std, 474 },
    { "CONVERT_USHORT3_RTZ", OpenCL_std, 475 },
    { "CONVERT_USHORT3_SAT", OpenCL_std, 476 },
    { "CONVERT_USHORT3_SAT_RTE", OpenCL_std, 477 },
    { "CONVERT_USHORT3_SAT_RTN", OpenCL_std, 478 },
    { "CONVERT_USHORT3_SAT_RTP", OpenCL_std, 479 },
    { "CONVERT_USHORT3_SAT_RTZ", OpenCL_std, 480 },
    { "CONVERT_USHORT4", OpenCL_std, 481 },
    { "CONVERT_USHORT4_RTE", OpenCL_std, 482 },
    { "CONVERT_USHORT4_RTN", OpenCL_std, 483 },
    { "CONVERT_USHORT4_RTP", OpenCL_std, 484 },
    { "CONVERT_USHORT4_RTZ", OpenCL_std, 485 },
    { "CONVERT_USHORT4_SAT", OpenCL_std, 486 },
    { "CONVERT_USHORT4_SAT_RTE", OpenCL_std, 487 },
    { "CONVERT_USHORT4_SAT_RTN", OpenCL_std, 488 },
    { "CONVERT_USHORT4_SAT_RTP", OpenCL_std, 489 },
    { "CONVERT_USHORT4_SAT_RTZ", OpenCL_std, 490 },
    { "CONVERT_USHORT8", OpenCL_std, 491 },
    { "CONVERT_USHORT8_RTE", OpenCL_std, 492 },
    { "CONVERT_USHORT8_RTN", OpenCL_std, 493 },
    { "CONVERT_USHORT8_RTP", OpenCL_std, 494 },
    { "CONVERT_USHORT8_RTZ", OpenCL_std, 495 },
    { "CONVERT_USHORT8_SAT", OpenCL_std, 496 },
    { "CONVERT_USHORT8_SAT_RTE", OpenCL_std, 497 },
    { "CONVERT_USHORT8_SAT_RTN", OpenCL_std, 498 },
    { "CONVERT_USHORT8_SAT_RTP", OpenCL_std, 499 },
    { "CONVERT_USHORT8_SAT_RTZ", OpenCL_std, 500 },
    { "CONVERT_USHORT_RTE", OpenCL_std, 501 },
    { "CONVERT_USHORT_RTN", OpenCL_std, 502 },
    { "CONVERT_USHORT_RTP", OpenCL_std, 503 },
    { "CONVERT_USHORT_RTZ", OpenCL_std, 504 },
    { "CONVERT_USHORT_SAT", OpenCL_std, 505 },
    { "CONVERT_USHORT_SAT_RTE", OpenCL_std, 506 },
    { "CONVERT_USHORT_SAT_RTN", OpenCL_std, 507 },
    { "CONVERT_USHORT_SAT_RTP", OpenCL_std, 508 },
    { "CONVERT_USHORT_SAT_RTZ", OpenCL_std, 509 },
    { "INTEL_CONVERT_AS_BFLOAT1616_FLOAT16", OpenCL_std, 510 },
    { "INTEL_CONVERT_AS_BFLOAT162_FLOAT2", OpenCL_std, 511 },
    { "INTEL_CONVERT_AS_BFLOAT163_FLOAT3", OpenCL_std, 512 },
    { "INTEL_CONVERT_AS_BFLOAT164_FLOAT4", OpenCL_std, 513 },
    { "INTEL_CONVERT_AS_BFLOAT168_FLOAT8", OpenCL_std, 514 },
    { "INTEL_CONVERT_AS_BFLOAT16_FLOAT", OpenCL_std, 515 },
    { "INTEL_CONVERT_BFLOAT1616_AS_USHORT16", OpenCL_std, 516 },
    { "INTEL_CONVERT_BFLOAT162_AS_USHORT2", OpenCL_std, 517 },
    { "INTEL_CONVERT_BFLOAT163_AS_USHORT3", OpenCL_std, 518 },
    { "INTEL_CONVERT_BFLOAT164_AS_USHORT4", OpenCL_std, 519 },
    { "INTEL_CONVERT_BFLOAT168_AS_USHORT8", OpenCL_std, 520 },
    { "INTEL_CONVERT_BFLOAT16_AS_USHORT", OpenCL_std, 521 },
    { "__SPIRV_CONVERTBF16TOFINTEL", OpenCL_std, 522 },
    { "__SPIRV_CONVERTFTOBF16INTEL", OpenCL_std, 523 },
  };

  struct KeyType {
    std::string Name;
    unsigned Set;
  };
  KeyType Key = {Name.upper(), Set};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name ||
      Key.Set != Idx->Set)
    return nullptr;

  return &ConvertBuiltins[Idx->_index];
}
#endif

#ifdef GET_DemangledBuiltins_DECL
const DemangledBuiltin *lookupBuiltin(StringRef Name, unsigned Set);
#endif

#ifdef GET_DemangledBuiltins_IMPL
constexpr DemangledBuiltin DemangledBuiltins[] = {
  { "acos", OpenCL_std, Extended, 0x1, 0x3 }, // 0
  { "Acos", GLSL_std_450, Extended, 0x1, 0x3 }, // 1
  { "acosh", OpenCL_std, Extended, 0x1, 0x3 }, // 2
  { "Acosh", GLSL_std_450, Extended, 0x1, 0x3 }, // 3
  { "acospi", OpenCL_std, Extended, 0x1, 0x3 }, // 4
  { "all", OpenCL_std, Relational, 0x1, 0x1 }, // 5
  { "any", OpenCL_std, Relational, 0x1, 0x1 }, // 6
  { "asin", OpenCL_std, Extended, 0x1, 0x3 }, // 7
  { "Asin", GLSL_std_450, Extended, 0x1, 0x3 }, // 8
  { "asinh", OpenCL_std, Extended, 0x1, 0x3 }, // 9
  { "Asinh", GLSL_std_450, Extended, 0x1, 0x3 }, // 10
  { "asinpi", OpenCL_std, Extended, 0x1, 0x3 }, // 11
  { "async_work_group_copy", OpenCL_std, AsyncCopy, 0x4, 0x4 }, // 12
  { "async_work_group_strided_copy", OpenCL_std, AsyncCopy, 0x5, 0x5 }, // 13
  { "atan", OpenCL_std, Extended, 0x1, 0x3 }, // 14
  { "Atan", GLSL_std_450, Extended, 0x1, 0x3 }, // 15
  { "atan2", OpenCL_std, Extended, 0x1, 0x3 }, // 16
  { "Atan2", GLSL_std_450, Extended, 0x1, 0x3 }, // 17
  { "atan2pi", OpenCL_std, Extended, 0x1, 0x3 }, // 18
  { "atanh", OpenCL_std, Extended, 0x1, 0x3 }, // 19
  { "Atanh", GLSL_std_450, Extended, 0x1, 0x3 }, // 20
  { "atanpi", OpenCL_std, Extended, 0x1, 0x3 }, // 21
  { "AtomicEx__spirv_change", OpenCL_std, Atomic, 0x2, 0x4 }, // 22
  { "atomic_add", OpenCL_std, Atomic, 0x2, 0x4 }, // 23
  { "atomic_and", OpenCL_std, Atomic, 0x2, 0x4 }, // 24
  { "atomic_cmpxchg", OpenCL_std, Atomic, 0x3, 0x6 }, // 25
  { "atomic_compare_exchange_strong", OpenCL_std, Atomic, 0x3, 0x6 }, // 26
  { "atomic_compare_exchange_strong_explicit", OpenCL_std, Atomic, 0x5, 0x6 }, // 27
  { "atomic_compare_exchange_weak", OpenCL_std, Atomic, 0x3, 0x6 }, // 28
  { "atomic_compare_exchange_weak_explicit", OpenCL_std, Atomic, 0x5, 0x6 }, // 29
  { "atomic_exchange", OpenCL_std, Atomic, 0x2, 0x4 }, // 30
  { "atomic_exchange_explicit", OpenCL_std, Atomic, 0x2, 0x4 }, // 31
  { "atomic_fetch_add", OpenCL_std, Atomic, 0x2, 0x4 }, // 32
  { "atomic_fetch_add_explicit", OpenCL_std, Atomic, 0x3, 0x4 }, // 33
  { "atomic_fetch_and", OpenCL_std, Atomic, 0x2, 0x4 }, // 34
  { "atomic_fetch_and_explicit", OpenCL_std, Atomic, 0x3, 0x4 }, // 35
  { "atomic_fetch_or", OpenCL_std, Atomic, 0x2, 0x4 }, // 36
  { "atomic_fetch_or_explicit", OpenCL_std, Atomic, 0x3, 0x4 }, // 37
  { "atomic_fetch_sub", OpenCL_std, Atomic, 0x2, 0x4 }, // 38
  { "atomic_fetch_sub_explicit", OpenCL_std, Atomic, 0x3, 0x4 }, // 39
  { "atomic_fetch_xor", OpenCL_std, Atomic, 0x2, 0x4 }, // 40
  { "atomic_fetch_xor_explicit", OpenCL_std, Atomic, 0x3, 0x4 }, // 41
  { "atomic_flag_clear", OpenCL_std, Atomic, 0x1, 0x1 }, // 42
  { "atomic_flag_clear_explicit", OpenCL_std, Atomic, 0x2, 0x3 }, // 43
  { "atomic_flag_test_and_set", OpenCL_std, Atomic, 0x1, 0x1 }, // 44
  { "atomic_flag_test_and_set_explicit", OpenCL_std, Atomic, 0x2, 0x3 }, // 45
  { "atomic_init", OpenCL_std, Atomic, 0x2, 0x2 }, // 46
  { "atomic_load", OpenCL_std, Atomic, 0x1, 0x1 }, // 47
  { "atomic_load_explicit", OpenCL_std, Atomic, 0x2, 0x3 }, // 48
  { "atomic_or", OpenCL_std, Atomic, 0x2, 0x4 }, // 49
  { "atomic_store", OpenCL_std, Atomic, 0x2, 0x2 }, // 50
  { "atomic_store_explicit", OpenCL_std, Atomic, 0x2, 0x4 }, // 51
  { "atomic_sub", OpenCL_std, Atomic, 0x2, 0x4 }, // 52
  { "atomic_work_item_fence", OpenCL_std, Atomic, 0x1, 0x3 }, // 53
  { "atomic_xor", OpenCL_std, Atomic, 0x2, 0x4 }, // 54
  { "atom_add", OpenCL_std, Atomic, 0x2, 0x4 }, // 55
  { "atom_and", OpenCL_std, Atomic, 0x2, 0x4 }, // 56
  { "atom_cmpxchg", OpenCL_std, Atomic, 0x3, 0x6 }, // 57
  { "atom_or", OpenCL_std, Atomic, 0x2, 0x4 }, // 58
  { "atom_sub", OpenCL_std, Atomic, 0x2, 0x4 }, // 59
  { "atom_xor", OpenCL_std, Atomic, 0x2, 0x4 }, // 60
  { "barrier", OpenCL_std, Barrier, 0x1, 0x3 }, // 61
  { "bitselect", OpenCL_std, Extended, 0x1, 0x3 }, // 62
  { "capture_event_profiling_info", OpenCL_std, Enqueue, 0x3, 0x3 }, // 63
  { "cbrt", OpenCL_std, Extended, 0x1, 0x3 }, // 64
  { "ceil", OpenCL_std, Extended, 0x1, 0x3 }, // 65
  { "Ceil", GLSL_std_450, Extended, 0x1, 0x3 }, // 66
  { "clock_read_device", OpenCL_std, KernelClock, 0x0, 0x0 }, // 67
  { "clock_read_hilo_device", OpenCL_std, KernelClock, 0x0, 0x0 }, // 68
  { "clock_read_hilo_sub_group", OpenCL_std, KernelClock, 0x0, 0x0 }, // 69
  { "clock_read_hilo_work_group", OpenCL_std, KernelClock, 0x0, 0x0 }, // 70
  { "clock_read_sub_group", OpenCL_std, KernelClock, 0x0, 0x0 }, // 71
  { "clock_read_work_group", OpenCL_std, KernelClock, 0x0, 0x0 }, // 72
  { "clz", OpenCL_std, Extended, 0x1, 0x3 }, // 73
  { "convert_char", OpenCL_std, Convert, 0x1, 0x1 }, // 74
  { "convert_char16", OpenCL_std, Convert, 0x1, 0x1 }, // 75
  { "convert_char16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 76
  { "convert_char16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 77
  { "convert_char16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 78
  { "convert_char16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 79
  { "convert_char16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 80
  { "convert_char16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 81
  { "convert_char16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 82
  { "convert_char16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 83
  { "convert_char16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 84
  { "convert_char2", OpenCL_std, Convert, 0x1, 0x1 }, // 85
  { "convert_char2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 86
  { "convert_char2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 87
  { "convert_char2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 88
  { "convert_char2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 89
  { "convert_char2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 90
  { "convert_char2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 91
  { "convert_char2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 92
  { "convert_char2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 93
  { "convert_char2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 94
  { "convert_char3", OpenCL_std, Convert, 0x1, 0x1 }, // 95
  { "convert_char3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 96
  { "convert_char3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 97
  { "convert_char3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 98
  { "convert_char3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 99
  { "convert_char3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 100
  { "convert_char3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 101
  { "convert_char3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 102
  { "convert_char3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 103
  { "convert_char3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 104
  { "convert_char4", OpenCL_std, Convert, 0x1, 0x1 }, // 105
  { "convert_char4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 106
  { "convert_char4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 107
  { "convert_char4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 108
  { "convert_char4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 109
  { "convert_char4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 110
  { "convert_char4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 111
  { "convert_char4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 112
  { "convert_char4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 113
  { "convert_char4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 114
  { "convert_char8", OpenCL_std, Convert, 0x1, 0x1 }, // 115
  { "convert_char8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 116
  { "convert_char8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 117
  { "convert_char8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 118
  { "convert_char8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 119
  { "convert_char8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 120
  { "convert_char8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 121
  { "convert_char8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 122
  { "convert_char8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 123
  { "convert_char8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 124
  { "convert_char_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 125
  { "convert_char_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 126
  { "convert_char_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 127
  { "convert_char_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 128
  { "convert_char_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 129
  { "convert_char_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 130
  { "convert_char_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 131
  { "convert_char_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 132
  { "convert_char_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 133
  { "convert_float", OpenCL_std, Convert, 0x1, 0x1 }, // 134
  { "convert_float16", OpenCL_std, Convert, 0x1, 0x1 }, // 135
  { "convert_float16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 136
  { "convert_float16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 137
  { "convert_float16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 138
  { "convert_float16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 139
  { "convert_float2", OpenCL_std, Convert, 0x1, 0x1 }, // 140
  { "convert_float2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 141
  { "convert_float2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 142
  { "convert_float2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 143
  { "convert_float2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 144
  { "convert_float3", OpenCL_std, Convert, 0x1, 0x1 }, // 145
  { "convert_float3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 146
  { "convert_float3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 147
  { "convert_float3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 148
  { "convert_float3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 149
  { "convert_float4", OpenCL_std, Convert, 0x1, 0x1 }, // 150
  { "convert_float4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 151
  { "convert_float4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 152
  { "convert_float4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 153
  { "convert_float4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 154
  { "convert_float8", OpenCL_std, Convert, 0x1, 0x1 }, // 155
  { "convert_float8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 156
  { "convert_float8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 157
  { "convert_float8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 158
  { "convert_float8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 159
  { "convert_float_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 160
  { "convert_float_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 161
  { "convert_float_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 162
  { "convert_float_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 163
  { "convert_int", OpenCL_std, Convert, 0x1, 0x1 }, // 164
  { "convert_int16", OpenCL_std, Convert, 0x1, 0x1 }, // 165
  { "convert_int16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 166
  { "convert_int16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 167
  { "convert_int16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 168
  { "convert_int16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 169
  { "convert_int16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 170
  { "convert_int16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 171
  { "convert_int16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 172
  { "convert_int16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 173
  { "convert_int16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 174
  { "convert_int2", OpenCL_std, Convert, 0x1, 0x1 }, // 175
  { "convert_int2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 176
  { "convert_int2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 177
  { "convert_int2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 178
  { "convert_int2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 179
  { "convert_int2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 180
  { "convert_int2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 181
  { "convert_int2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 182
  { "convert_int2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 183
  { "convert_int2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 184
  { "convert_int3", OpenCL_std, Convert, 0x1, 0x1 }, // 185
  { "convert_int3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 186
  { "convert_int3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 187
  { "convert_int3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 188
  { "convert_int3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 189
  { "convert_int3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 190
  { "convert_int3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 191
  { "convert_int3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 192
  { "convert_int3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 193
  { "convert_int3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 194
  { "convert_int4", OpenCL_std, Convert, 0x1, 0x1 }, // 195
  { "convert_int4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 196
  { "convert_int4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 197
  { "convert_int4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 198
  { "convert_int4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 199
  { "convert_int4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 200
  { "convert_int4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 201
  { "convert_int4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 202
  { "convert_int4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 203
  { "convert_int4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 204
  { "convert_int8", OpenCL_std, Convert, 0x1, 0x1 }, // 205
  { "convert_int8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 206
  { "convert_int8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 207
  { "convert_int8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 208
  { "convert_int8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 209
  { "convert_int8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 210
  { "convert_int8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 211
  { "convert_int8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 212
  { "convert_int8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 213
  { "convert_int8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 214
  { "convert_int_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 215
  { "convert_int_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 216
  { "convert_int_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 217
  { "convert_int_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 218
  { "convert_int_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 219
  { "convert_int_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 220
  { "convert_int_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 221
  { "convert_int_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 222
  { "convert_int_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 223
  { "convert_long", OpenCL_std, Convert, 0x1, 0x1 }, // 224
  { "convert_long16", OpenCL_std, Convert, 0x1, 0x1 }, // 225
  { "convert_long16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 226
  { "convert_long16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 227
  { "convert_long16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 228
  { "convert_long16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 229
  { "convert_long16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 230
  { "convert_long16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 231
  { "convert_long16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 232
  { "convert_long16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 233
  { "convert_long16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 234
  { "convert_long2", OpenCL_std, Convert, 0x1, 0x1 }, // 235
  { "convert_long2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 236
  { "convert_long2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 237
  { "convert_long2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 238
  { "convert_long2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 239
  { "convert_long2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 240
  { "convert_long2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 241
  { "convert_long2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 242
  { "convert_long2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 243
  { "convert_long2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 244
  { "convert_long3", OpenCL_std, Convert, 0x1, 0x1 }, // 245
  { "convert_long3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 246
  { "convert_long3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 247
  { "convert_long3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 248
  { "convert_long3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 249
  { "convert_long3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 250
  { "convert_long3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 251
  { "convert_long3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 252
  { "convert_long3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 253
  { "convert_long3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 254
  { "convert_long4", OpenCL_std, Convert, 0x1, 0x1 }, // 255
  { "convert_long4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 256
  { "convert_long4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 257
  { "convert_long4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 258
  { "convert_long4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 259
  { "convert_long4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 260
  { "convert_long4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 261
  { "convert_long4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 262
  { "convert_long4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 263
  { "convert_long4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 264
  { "convert_long8", OpenCL_std, Convert, 0x1, 0x1 }, // 265
  { "convert_long8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 266
  { "convert_long8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 267
  { "convert_long8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 268
  { "convert_long8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 269
  { "convert_long8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 270
  { "convert_long8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 271
  { "convert_long8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 272
  { "convert_long8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 273
  { "convert_long8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 274
  { "convert_long_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 275
  { "convert_long_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 276
  { "convert_long_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 277
  { "convert_long_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 278
  { "convert_long_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 279
  { "convert_long_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 280
  { "convert_long_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 281
  { "convert_long_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 282
  { "convert_long_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 283
  { "convert_short", OpenCL_std, Convert, 0x1, 0x1 }, // 284
  { "convert_short16", OpenCL_std, Convert, 0x1, 0x1 }, // 285
  { "convert_short16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 286
  { "convert_short16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 287
  { "convert_short16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 288
  { "convert_short16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 289
  { "convert_short16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 290
  { "convert_short16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 291
  { "convert_short16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 292
  { "convert_short16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 293
  { "convert_short16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 294
  { "convert_short2", OpenCL_std, Convert, 0x1, 0x1 }, // 295
  { "convert_short2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 296
  { "convert_short2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 297
  { "convert_short2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 298
  { "convert_short2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 299
  { "convert_short2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 300
  { "convert_short2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 301
  { "convert_short2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 302
  { "convert_short2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 303
  { "convert_short2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 304
  { "convert_short3", OpenCL_std, Convert, 0x1, 0x1 }, // 305
  { "convert_short3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 306
  { "convert_short3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 307
  { "convert_short3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 308
  { "convert_short3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 309
  { "convert_short3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 310
  { "convert_short3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 311
  { "convert_short3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 312
  { "convert_short3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 313
  { "convert_short3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 314
  { "convert_short4", OpenCL_std, Convert, 0x1, 0x1 }, // 315
  { "convert_short4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 316
  { "convert_short4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 317
  { "convert_short4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 318
  { "convert_short4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 319
  { "convert_short4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 320
  { "convert_short4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 321
  { "convert_short4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 322
  { "convert_short4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 323
  { "convert_short4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 324
  { "convert_short8", OpenCL_std, Convert, 0x1, 0x1 }, // 325
  { "convert_short8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 326
  { "convert_short8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 327
  { "convert_short8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 328
  { "convert_short8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 329
  { "convert_short8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 330
  { "convert_short8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 331
  { "convert_short8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 332
  { "convert_short8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 333
  { "convert_short8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 334
  { "convert_short_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 335
  { "convert_short_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 336
  { "convert_short_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 337
  { "convert_short_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 338
  { "convert_short_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 339
  { "convert_short_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 340
  { "convert_short_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 341
  { "convert_short_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 342
  { "convert_short_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 343
  { "convert_uchar", OpenCL_std, Convert, 0x1, 0x1 }, // 344
  { "convert_uchar16", OpenCL_std, Convert, 0x1, 0x1 }, // 345
  { "convert_uchar16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 346
  { "convert_uchar16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 347
  { "convert_uchar16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 348
  { "convert_uchar16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 349
  { "convert_uchar16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 350
  { "convert_uchar16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 351
  { "convert_uchar16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 352
  { "convert_uchar16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 353
  { "convert_uchar16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 354
  { "convert_uchar2", OpenCL_std, Convert, 0x1, 0x1 }, // 355
  { "convert_uchar2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 356
  { "convert_uchar2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 357
  { "convert_uchar2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 358
  { "convert_uchar2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 359
  { "convert_uchar2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 360
  { "convert_uchar2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 361
  { "convert_uchar2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 362
  { "convert_uchar2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 363
  { "convert_uchar2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 364
  { "convert_uchar3", OpenCL_std, Convert, 0x1, 0x1 }, // 365
  { "convert_uchar3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 366
  { "convert_uchar3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 367
  { "convert_uchar3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 368
  { "convert_uchar3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 369
  { "convert_uchar3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 370
  { "convert_uchar3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 371
  { "convert_uchar3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 372
  { "convert_uchar3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 373
  { "convert_uchar3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 374
  { "convert_uchar4", OpenCL_std, Convert, 0x1, 0x1 }, // 375
  { "convert_uchar4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 376
  { "convert_uchar4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 377
  { "convert_uchar4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 378
  { "convert_uchar4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 379
  { "convert_uchar4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 380
  { "convert_uchar4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 381
  { "convert_uchar4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 382
  { "convert_uchar4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 383
  { "convert_uchar4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 384
  { "convert_uchar8", OpenCL_std, Convert, 0x1, 0x1 }, // 385
  { "convert_uchar8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 386
  { "convert_uchar8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 387
  { "convert_uchar8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 388
  { "convert_uchar8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 389
  { "convert_uchar8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 390
  { "convert_uchar8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 391
  { "convert_uchar8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 392
  { "convert_uchar8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 393
  { "convert_uchar8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 394
  { "convert_uchar_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 395
  { "convert_uchar_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 396
  { "convert_uchar_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 397
  { "convert_uchar_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 398
  { "convert_uchar_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 399
  { "convert_uchar_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 400
  { "convert_uchar_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 401
  { "convert_uchar_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 402
  { "convert_uchar_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 403
  { "convert_uint", OpenCL_std, Convert, 0x1, 0x1 }, // 404
  { "convert_uint16", OpenCL_std, Convert, 0x1, 0x1 }, // 405
  { "convert_uint16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 406
  { "convert_uint16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 407
  { "convert_uint16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 408
  { "convert_uint16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 409
  { "convert_uint16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 410
  { "convert_uint16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 411
  { "convert_uint16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 412
  { "convert_uint16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 413
  { "convert_uint16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 414
  { "convert_uint2", OpenCL_std, Convert, 0x1, 0x1 }, // 415
  { "convert_uint2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 416
  { "convert_uint2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 417
  { "convert_uint2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 418
  { "convert_uint2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 419
  { "convert_uint2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 420
  { "convert_uint2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 421
  { "convert_uint2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 422
  { "convert_uint2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 423
  { "convert_uint2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 424
  { "convert_uint3", OpenCL_std, Convert, 0x1, 0x1 }, // 425
  { "convert_uint3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 426
  { "convert_uint3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 427
  { "convert_uint3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 428
  { "convert_uint3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 429
  { "convert_uint3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 430
  { "convert_uint3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 431
  { "convert_uint3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 432
  { "convert_uint3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 433
  { "convert_uint3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 434
  { "convert_uint4", OpenCL_std, Convert, 0x1, 0x1 }, // 435
  { "convert_uint4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 436
  { "convert_uint4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 437
  { "convert_uint4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 438
  { "convert_uint4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 439
  { "convert_uint4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 440
  { "convert_uint4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 441
  { "convert_uint4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 442
  { "convert_uint4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 443
  { "convert_uint4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 444
  { "convert_uint8", OpenCL_std, Convert, 0x1, 0x1 }, // 445
  { "convert_uint8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 446
  { "convert_uint8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 447
  { "convert_uint8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 448
  { "convert_uint8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 449
  { "convert_uint8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 450
  { "convert_uint8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 451
  { "convert_uint8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 452
  { "convert_uint8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 453
  { "convert_uint8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 454
  { "convert_uint_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 455
  { "convert_uint_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 456
  { "convert_uint_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 457
  { "convert_uint_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 458
  { "convert_uint_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 459
  { "convert_uint_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 460
  { "convert_uint_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 461
  { "convert_uint_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 462
  { "convert_uint_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 463
  { "convert_ulong", OpenCL_std, Convert, 0x1, 0x1 }, // 464
  { "convert_ulong16", OpenCL_std, Convert, 0x1, 0x1 }, // 465
  { "convert_ulong16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 466
  { "convert_ulong16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 467
  { "convert_ulong16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 468
  { "convert_ulong16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 469
  { "convert_ulong16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 470
  { "convert_ulong16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 471
  { "convert_ulong16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 472
  { "convert_ulong16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 473
  { "convert_ulong16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 474
  { "convert_ulong2", OpenCL_std, Convert, 0x1, 0x1 }, // 475
  { "convert_ulong2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 476
  { "convert_ulong2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 477
  { "convert_ulong2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 478
  { "convert_ulong2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 479
  { "convert_ulong2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 480
  { "convert_ulong2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 481
  { "convert_ulong2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 482
  { "convert_ulong2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 483
  { "convert_ulong2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 484
  { "convert_ulong3", OpenCL_std, Convert, 0x1, 0x1 }, // 485
  { "convert_ulong3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 486
  { "convert_ulong3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 487
  { "convert_ulong3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 488
  { "convert_ulong3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 489
  { "convert_ulong3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 490
  { "convert_ulong3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 491
  { "convert_ulong3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 492
  { "convert_ulong3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 493
  { "convert_ulong3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 494
  { "convert_ulong4", OpenCL_std, Convert, 0x1, 0x1 }, // 495
  { "convert_ulong4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 496
  { "convert_ulong4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 497
  { "convert_ulong4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 498
  { "convert_ulong4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 499
  { "convert_ulong4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 500
  { "convert_ulong4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 501
  { "convert_ulong4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 502
  { "convert_ulong4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 503
  { "convert_ulong4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 504
  { "convert_ulong8", OpenCL_std, Convert, 0x1, 0x1 }, // 505
  { "convert_ulong8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 506
  { "convert_ulong8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 507
  { "convert_ulong8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 508
  { "convert_ulong8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 509
  { "convert_ulong8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 510
  { "convert_ulong8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 511
  { "convert_ulong8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 512
  { "convert_ulong8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 513
  { "convert_ulong8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 514
  { "convert_ulong_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 515
  { "convert_ulong_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 516
  { "convert_ulong_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 517
  { "convert_ulong_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 518
  { "convert_ulong_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 519
  { "convert_ulong_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 520
  { "convert_ulong_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 521
  { "convert_ulong_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 522
  { "convert_ulong_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 523
  { "convert_ushort", OpenCL_std, Convert, 0x1, 0x1 }, // 524
  { "convert_ushort16", OpenCL_std, Convert, 0x1, 0x1 }, // 525
  { "convert_ushort16_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 526
  { "convert_ushort16_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 527
  { "convert_ushort16_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 528
  { "convert_ushort16_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 529
  { "convert_ushort16_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 530
  { "convert_ushort16_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 531
  { "convert_ushort16_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 532
  { "convert_ushort16_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 533
  { "convert_ushort16_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 534
  { "convert_ushort2", OpenCL_std, Convert, 0x1, 0x1 }, // 535
  { "convert_ushort2_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 536
  { "convert_ushort2_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 537
  { "convert_ushort2_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 538
  { "convert_ushort2_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 539
  { "convert_ushort2_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 540
  { "convert_ushort2_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 541
  { "convert_ushort2_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 542
  { "convert_ushort2_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 543
  { "convert_ushort2_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 544
  { "convert_ushort3", OpenCL_std, Convert, 0x1, 0x1 }, // 545
  { "convert_ushort3_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 546
  { "convert_ushort3_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 547
  { "convert_ushort3_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 548
  { "convert_ushort3_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 549
  { "convert_ushort3_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 550
  { "convert_ushort3_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 551
  { "convert_ushort3_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 552
  { "convert_ushort3_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 553
  { "convert_ushort3_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 554
  { "convert_ushort4", OpenCL_std, Convert, 0x1, 0x1 }, // 555
  { "convert_ushort4_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 556
  { "convert_ushort4_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 557
  { "convert_ushort4_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 558
  { "convert_ushort4_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 559
  { "convert_ushort4_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 560
  { "convert_ushort4_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 561
  { "convert_ushort4_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 562
  { "convert_ushort4_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 563
  { "convert_ushort4_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 564
  { "convert_ushort8", OpenCL_std, Convert, 0x1, 0x1 }, // 565
  { "convert_ushort8_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 566
  { "convert_ushort8_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 567
  { "convert_ushort8_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 568
  { "convert_ushort8_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 569
  { "convert_ushort8_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 570
  { "convert_ushort8_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 571
  { "convert_ushort8_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 572
  { "convert_ushort8_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 573
  { "convert_ushort8_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 574
  { "convert_ushort_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 575
  { "convert_ushort_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 576
  { "convert_ushort_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 577
  { "convert_ushort_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 578
  { "convert_ushort_sat", OpenCL_std, Convert, 0x1, 0x1 }, // 579
  { "convert_ushort_sat_rte", OpenCL_std, Convert, 0x1, 0x1 }, // 580
  { "convert_ushort_sat_rtn", OpenCL_std, Convert, 0x1, 0x1 }, // 581
  { "convert_ushort_sat_rtp", OpenCL_std, Convert, 0x1, 0x1 }, // 582
  { "convert_ushort_sat_rtz", OpenCL_std, Convert, 0x1, 0x1 }, // 583
  { "copysign", OpenCL_std, Extended, 0x1, 0x3 }, // 584
  { "cos", OpenCL_std, Extended, 0x1, 0x3 }, // 585
  { "Cos", GLSL_std_450, Extended, 0x1, 0x3 }, // 586
  { "cosh", OpenCL_std, Extended, 0x1, 0x3 }, // 587
  { "Cosh", GLSL_std_450, Extended, 0x1, 0x3 }, // 588
  { "cospi", OpenCL_std, Extended, 0x1, 0x3 }, // 589
  { "create_user_event", OpenCL_std, Enqueue, 0x0, 0x0 }, // 590
  { "cross", OpenCL_std, Extended, 0x1, 0x3 }, // 591
  { "Cross", GLSL_std_450, Extended, 0x1, 0x3 }, // 592
  { "ctz", OpenCL_std, Extended, 0x1, 0x3 }, // 593
  { "DebugBuildIdentifier", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 594
  { "DebugCompilationUnit", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 595
  { "DebugDeclare", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 596
  { "DebugEntryPoint", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 597
  { "DebugExpression", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 598
  { "DebugFunction", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 599
  { "DebugFunctionDeclaration", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 600
  { "DebugFunctionDefinition", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 601
  { "DebugGlobalVariable", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 602
  { "DebugImportedEntity", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 603
  { "DebugInfoNone", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 604
  { "DebugInlinedAt", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 605
  { "DebugInlinedVariable", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 606
  { "DebugLexicalBlock", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 607
  { "DebugLexicalBlockDiscriminator", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 608
  { "DebugLine", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 609
  { "DebugLocalVariable", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 610
  { "DebugMacroDef", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 611
  { "DebugMacroUndef", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 612
  { "DebugNoLine", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 613
  { "DebugNoScope", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 614
  { "DebugOperation", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 615
  { "DebugScope", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 616
  { "DebugSource", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 617
  { "DebugSourceContinued", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 618
  { "DebugStoragePath", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 619
  { "DebugTypeArray", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 620
  { "DebugTypeBasic", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 621
  { "DebugTypeComposite", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 622
  { "DebugTypedef", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 623
  { "DebugTypeEnum", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 624
  { "DebugTypeFunction", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 625
  { "DebugTypeInheritance", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 626
  { "DebugTypeMatrix", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 627
  { "DebugTypeMember", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 628
  { "DebugTypePointer", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 629
  { "DebugTypePtrToMember", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 630
  { "DebugTypeQualifier", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 631
  { "DebugTypeTemplate", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 632
  { "DebugTypeTemplateParameter", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 633
  { "DebugTypeTemplateParameterPack", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 634
  { "DebugTypeTemplateTemplateParameter", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 635
  { "DebugTypeVector", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 636
  { "DebugValue", NonSemantic_Shader_DebugInfo_100, Extended, 0x1, 0x3 }, // 637
  { "degrees", OpenCL_std, Extended, 0x1, 0x3 }, // 638
  { "Degrees", GLSL_std_450, Extended, 0x1, 0x3 }, // 639
  { "Determinant", GLSL_std_450, Extended, 0x1, 0x3 }, // 640
  { "distance", OpenCL_std, Extended, 0x1, 0x3 }, // 641
  { "Distance", GLSL_std_450, Extended, 0x1, 0x3 }, // 642
  { "dot", OpenCL_std, Dot, 0x2, 0x2 }, // 643
  { "erf", OpenCL_std, Extended, 0x1, 0x3 }, // 644
  { "erfc", OpenCL_std, Extended, 0x1, 0x3 }, // 645
  { "exp", OpenCL_std, Extended, 0x1, 0x3 }, // 646
  { "Exp", GLSL_std_450, Extended, 0x1, 0x3 }, // 647
  { "exp10", OpenCL_std, Extended, 0x1, 0x3 }, // 648
  { "exp2", OpenCL_std, Extended, 0x1, 0x3 }, // 649
  { "Exp2", GLSL_std_450, Extended, 0x1, 0x3 }, // 650
  { "expm1", OpenCL_std, Extended, 0x1, 0x3 }, // 651
  { "fabs", OpenCL_std, Extended, 0x1, 0x3 }, // 652
  { "FAbs", GLSL_std_450, Extended, 0x1, 0x3 }, // 653
  { "FaceForward", GLSL_std_450, Extended, 0x1, 0x3 }, // 654
  { "fast_distance", OpenCL_std, Extended, 0x1, 0x3 }, // 655
  { "fast_length", OpenCL_std, Extended, 0x1, 0x3 }, // 656
  { "fast_normalize", OpenCL_std, Extended, 0x1, 0x3 }, // 657
  { "fclamp", OpenCL_std, Extended, 0x1, 0x3 }, // 658
  { "FClamp", GLSL_std_450, Extended, 0x1, 0x3 }, // 659
  { "fdim", OpenCL_std, Extended, 0x1, 0x3 }, // 660
  { "FindILsb", GLSL_std_450, Extended, 0x1, 0x3 }, // 661
  { "FindSMsb", GLSL_std_450, Extended, 0x1, 0x3 }, // 662
  { "FindUMsb", GLSL_std_450, Extended, 0x1, 0x3 }, // 663
  { "floor", OpenCL_std, Extended, 0x1, 0x3 }, // 664
  { "Floor", GLSL_std_450, Extended, 0x1, 0x3 }, // 665
  { "fma", OpenCL_std, Extended, 0x1, 0x3 }, // 666
  { "Fma", GLSL_std_450, Extended, 0x1, 0x3 }, // 667
  { "fmax", OpenCL_std, Extended, 0x1, 0x3 }, // 668
  { "FMax", GLSL_std_450, Extended, 0x1, 0x3 }, // 669
  { "fmax_common", OpenCL_std, Extended, 0x1, 0x3 }, // 670
  { "fmin", OpenCL_std, Extended, 0x1, 0x3 }, // 671
  { "FMin", GLSL_std_450, Extended, 0x1, 0x3 }, // 672
  { "fmin_common", OpenCL_std, Extended, 0x1, 0x3 }, // 673
  { "FMix", GLSL_std_450, Extended, 0x1, 0x3 }, // 674
  { "fmod", OpenCL_std, Extended, 0x1, 0x3 }, // 675
  { "fract", OpenCL_std, Extended, 0x1, 0x3 }, // 676
  { "Fract", GLSL_std_450, Extended, 0x1, 0x3 }, // 677
  { "frexp", OpenCL_std, Extended, 0x1, 0x3 }, // 678
  { "Frexp", GLSL_std_450, Extended, 0x1, 0x3 }, // 679
  { "FrexpStruct", GLSL_std_450, Extended, 0x1, 0x3 }, // 680
  { "FSign", GLSL_std_450, Extended, 0x1, 0x3 }, // 681
  { "get_default_queue", OpenCL_std, Enqueue, 0x0, 0x0 }, // 682
  { "get_enqueued_local_size", OpenCL_std, GetQuery, 0x0, 0x1 }, // 683
  { "get_global_id", OpenCL_std, GetQuery, 0x0, 0x1 }, // 684
  { "get_global_size", OpenCL_std, GetQuery, 0x0, 0x1 }, // 685
  { "get_group_id", OpenCL_std, GetQuery, 0x0, 0x1 }, // 686
  { "get_image_array_size", OpenCL_std, ImageSizeQuery, 0x1, 0x1 }, // 687
  { "get_image_depth", OpenCL_std, ImageSizeQuery, 0x1, 0x1 }, // 688
  { "get_image_dim", OpenCL_std, ImageSizeQuery, 0x1, 0x1 }, // 689
  { "get_image_height", OpenCL_std, ImageSizeQuery, 0x1, 0x1 }, // 690
  { "get_image_num_mip_levels", OpenCL_std, ImageMiscQuery, 0x1, 0x1 }, // 691
  { "get_image_num_samples", OpenCL_std, ImageMiscQuery, 0x1, 0x1 }, // 692
  { "get_image_width", OpenCL_std, ImageSizeQuery, 0x1, 0x1 }, // 693
  { "get_local_id", OpenCL_std, GetQuery, 0x0, 0x1 }, // 694
  { "get_local_size", OpenCL_std, GetQuery, 0x0, 0x1 }, // 695
  { "get_num_groups", OpenCL_std, GetQuery, 0x0, 0x1 }, // 696
  { "get_sub_group_eq_mask", OpenCL_std, Variable, 0x0, 0x1 }, // 697
  { "get_sub_group_ge_mask", OpenCL_std, Variable, 0x0, 0x1 }, // 698
  { "get_sub_group_gt_mask", OpenCL_std, Variable, 0x0, 0x1 }, // 699
  { "get_sub_group_le_mask", OpenCL_std, Variable, 0x0, 0x1 }, // 700
  { "get_sub_group_lt_mask", OpenCL_std, Variable, 0x0, 0x1 }, // 701
  { "half_cos", OpenCL_std, Extended, 0x1, 0x3 }, // 702
  { "half_divide", OpenCL_std, Extended, 0x1, 0x3 }, // 703
  { "half_exp", OpenCL_std, Extended, 0x1, 0x3 }, // 704
  { "half_exp10", OpenCL_std, Extended, 0x1, 0x3 }, // 705
  { "half_exp2", OpenCL_std, Extended, 0x1, 0x3 }, // 706
  { "half_log", OpenCL_std, Extended, 0x1, 0x3 }, // 707
  { "half_log10", OpenCL_std, Extended, 0x1, 0x3 }, // 708
  { "half_log2", OpenCL_std, Extended, 0x1, 0x3 }, // 709
  { "half_powr", OpenCL_std, Extended, 0x1, 0x3 }, // 710
  { "half_recip", OpenCL_std, Extended, 0x1, 0x3 }, // 711
  { "half_rsqrt", OpenCL_std, Extended, 0x1, 0x3 }, // 712
  { "half_sin", OpenCL_std, Extended, 0x1, 0x3 }, // 713
  { "half_sqrt", OpenCL_std, Extended, 0x1, 0x3 }, // 714
  { "half_tan", OpenCL_std, Extended, 0x1, 0x3 }, // 715
  { "hypot", OpenCL_std, Extended, 0x1, 0x3 }, // 716
  { "ilogb", OpenCL_std, Extended, 0x1, 0x3 }, // 717
  { "intel_convert_as_bfloat1616_float16", OpenCL_std, Convert, 0x1, 0x1 }, // 718
  { "intel_convert_as_bfloat162_float2", OpenCL_std, Convert, 0x1, 0x1 }, // 719
  { "intel_convert_as_bfloat163_float3", OpenCL_std, Convert, 0x1, 0x1 }, // 720
  { "intel_convert_as_bfloat164_float4", OpenCL_std, Convert, 0x1, 0x1 }, // 721
  { "intel_convert_as_bfloat168_float8", OpenCL_std, Convert, 0x1, 0x1 }, // 722
  { "intel_convert_as_bfloat16_float", OpenCL_std, Convert, 0x1, 0x1 }, // 723
  { "intel_convert_bfloat1616_as_ushort16", OpenCL_std, Convert, 0x1, 0x1 }, // 724
  { "intel_convert_bfloat162_as_ushort2", OpenCL_std, Convert, 0x1, 0x1 }, // 725
  { "intel_convert_bfloat163_as_ushort3", OpenCL_std, Convert, 0x1, 0x1 }, // 726
  { "intel_convert_bfloat164_as_ushort4", OpenCL_std, Convert, 0x1, 0x1 }, // 727
  { "intel_convert_bfloat168_as_ushort8", OpenCL_std, Convert, 0x1, 0x1 }, // 728
  { "intel_convert_bfloat16_as_ushort", OpenCL_std, Convert, 0x1, 0x1 }, // 729
  { "intel_sub_group_block_read", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 730
  { "intel_sub_group_block_read2", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 731
  { "intel_sub_group_block_read4", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 732
  { "intel_sub_group_block_read8", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 733
  { "intel_sub_group_block_read_uc", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 734
  { "intel_sub_group_block_read_uc16", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 735
  { "intel_sub_group_block_read_uc2", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 736
  { "intel_sub_group_block_read_uc4", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 737
  { "intel_sub_group_block_read_uc8", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 738
  { "intel_sub_group_block_read_ui", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 739
  { "intel_sub_group_block_read_ui2", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 740
  { "intel_sub_group_block_read_ui4", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 741
  { "intel_sub_group_block_read_ui8", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 742
  { "intel_sub_group_block_read_ul", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 743
  { "intel_sub_group_block_read_ul16", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 744
  { "intel_sub_group_block_read_ul2", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 745
  { "intel_sub_group_block_read_ul4", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 746
  { "intel_sub_group_block_read_ul8", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 747
  { "intel_sub_group_block_read_us", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 748
  { "intel_sub_group_block_read_us16", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 749
  { "intel_sub_group_block_read_us2", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 750
  { "intel_sub_group_block_read_us4", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 751
  { "intel_sub_group_block_read_us8", OpenCL_std, IntelSubgroups, 0x1, 0x2 }, // 752
  { "intel_sub_group_block_write", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 753
  { "intel_sub_group_block_write2", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 754
  { "intel_sub_group_block_write4", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 755
  { "intel_sub_group_block_write8", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 756
  { "intel_sub_group_block_write_uc", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 757
  { "intel_sub_group_block_write_uc16", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 758
  { "intel_sub_group_block_write_uc2", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 759
  { "intel_sub_group_block_write_uc4", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 760
  { "intel_sub_group_block_write_uc8", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 761
  { "intel_sub_group_block_write_ui", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 762
  { "intel_sub_group_block_write_ui2", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 763
  { "intel_sub_group_block_write_ui4", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 764
  { "intel_sub_group_block_write_ui8", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 765
  { "intel_sub_group_block_write_ul", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 766
  { "intel_sub_group_block_write_ul16", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 767
  { "intel_sub_group_block_write_ul2", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 768
  { "intel_sub_group_block_write_ul4", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 769
  { "intel_sub_group_block_write_ul8", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 770
  { "intel_sub_group_block_write_us", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 771
  { "intel_sub_group_block_write_us16", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 772
  { "intel_sub_group_block_write_us2", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 773
  { "intel_sub_group_block_write_us4", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 774
  { "intel_sub_group_block_write_us8", OpenCL_std, IntelSubgroups, 0x2, 0x3 }, // 775
  { "intel_sub_group_media_block_read", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 776
  { "intel_sub_group_media_block_read2", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 777
  { "intel_sub_group_media_block_read4", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 778
  { "intel_sub_group_media_block_read8", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 779
  { "intel_sub_group_media_block_read_uc", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 780
  { "intel_sub_group_media_block_read_uc16", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 781
  { "intel_sub_group_media_block_read_uc2", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 782
  { "intel_sub_group_media_block_read_uc4", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 783
  { "intel_sub_group_media_block_read_uc8", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 784
  { "intel_sub_group_media_block_read_ui", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 785
  { "intel_sub_group_media_block_read_ui2", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 786
  { "intel_sub_group_media_block_read_ui4", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 787
  { "intel_sub_group_media_block_read_ui8", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 788
  { "intel_sub_group_media_block_read_ul", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 789
  { "intel_sub_group_media_block_read_ul16", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 790
  { "intel_sub_group_media_block_read_ul2", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 791
  { "intel_sub_group_media_block_read_ul4", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 792
  { "intel_sub_group_media_block_read_ul8", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 793
  { "intel_sub_group_media_block_read_us", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 794
  { "intel_sub_group_media_block_read_us16", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 795
  { "intel_sub_group_media_block_read_us2", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 796
  { "intel_sub_group_media_block_read_us4", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 797
  { "intel_sub_group_media_block_read_us8", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 798
  { "intel_sub_group_media_block_write", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 799
  { "intel_sub_group_media_block_write2", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 800
  { "intel_sub_group_media_block_write4", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 801
  { "intel_sub_group_media_block_write8", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 802
  { "intel_sub_group_media_block_write_uc", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 803
  { "intel_sub_group_media_block_write_uc16", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 804
  { "intel_sub_group_media_block_write_uc2", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 805
  { "intel_sub_group_media_block_write_uc4", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 806
  { "intel_sub_group_media_block_write_uc8", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 807
  { "intel_sub_group_media_block_write_ui", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 808
  { "intel_sub_group_media_block_write_ui2", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 809
  { "intel_sub_group_media_block_write_ui4", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 810
  { "intel_sub_group_media_block_write_ui8", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 811
  { "intel_sub_group_media_block_write_ul", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 812
  { "intel_sub_group_media_block_write_ul16", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 813
  { "intel_sub_group_media_block_write_ul2", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 814
  { "intel_sub_group_media_block_write_ul4", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 815
  { "intel_sub_group_media_block_write_ul8", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 816
  { "intel_sub_group_media_block_write_us", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 817
  { "intel_sub_group_media_block_write_us16", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 818
  { "intel_sub_group_media_block_write_us2", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 819
  { "intel_sub_group_media_block_write_us4", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 820
  { "intel_sub_group_media_block_write_us8", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 821
  { "intel_sub_group_shuffle", OpenCL_std, IntelSubgroups, 0x2, 0x2 }, // 822
  { "intel_sub_group_shuffle_down", OpenCL_std, IntelSubgroups, 0x3, 0x3 }, // 823
  { "intel_sub_group_shuffle_up", OpenCL_std, IntelSubgroups, 0x3, 0x3 }, // 824
  { "intel_sub_group_shuffle_xor", OpenCL_std, IntelSubgroups, 0x2, 0x2 }, // 825
  { "intel_work_group_barrier_arrive", OpenCL_std, Barrier, 0x1, 0x2 }, // 826
  { "intel_work_group_barrier_wait", OpenCL_std, Barrier, 0x1, 0x2 }, // 827
  { "InterpolateAtCentroid", GLSL_std_450, Extended, 0x1, 0x3 }, // 828
  { "InterpolateAtOffset", GLSL_std_450, Extended, 0x1, 0x3 }, // 829
  { "InterpolateAtSample", GLSL_std_450, Extended, 0x1, 0x3 }, // 830
  { "InverseSqrt", GLSL_std_450, Extended, 0x1, 0x3 }, // 831
  { "isequal", OpenCL_std, Relational, 0x2, 0x2 }, // 832
  { "isfinite", OpenCL_std, Relational, 0x1, 0x1 }, // 833
  { "isgreater", OpenCL_std, Relational, 0x2, 0x2 }, // 834
  { "isgreaterequal", OpenCL_std, Relational, 0x2, 0x2 }, // 835
  { "isinf", OpenCL_std, Relational, 0x1, 0x1 }, // 836
  { "isless", OpenCL_std, Relational, 0x2, 0x2 }, // 837
  { "islessequal", OpenCL_std, Relational, 0x2, 0x2 }, // 838
  { "islessgreater", OpenCL_std, Relational, 0x2, 0x2 }, // 839
  { "isnan", OpenCL_std, Relational, 0x1, 0x1 }, // 840
  { "isnormal", OpenCL_std, Relational, 0x1, 0x1 }, // 841
  { "isnotequal", OpenCL_std, Relational, 0x2, 0x2 }, // 842
  { "isordered", OpenCL_std, Relational, 0x2, 0x2 }, // 843
  { "isunordered", OpenCL_std, Relational, 0x2, 0x2 }, // 844
  { "is_valid_event", OpenCL_std, Enqueue, 0x1, 0x1 }, // 845
  { "ldexp", OpenCL_std, Extended, 0x1, 0x3 }, // 846
  { "Ldexp", GLSL_std_450, Extended, 0x1, 0x3 }, // 847
  { "length", OpenCL_std, Extended, 0x1, 0x3 }, // 848
  { "Length", GLSL_std_450, Extended, 0x1, 0x3 }, // 849
  { "lgamma", OpenCL_std, Extended, 0x1, 0x3 }, // 850
  { "lgamma_r", OpenCL_std, Extended, 0x1, 0x3 }, // 851
  { "log", OpenCL_std, Extended, 0x1, 0x3 }, // 852
  { "Log", GLSL_std_450, Extended, 0x1, 0x3 }, // 853
  { "log10", OpenCL_std, Extended, 0x1, 0x3 }, // 854
  { "log1p", OpenCL_std, Extended, 0x1, 0x3 }, // 855
  { "log2", OpenCL_std, Extended, 0x1, 0x3 }, // 856
  { "Log2", GLSL_std_450, Extended, 0x1, 0x3 }, // 857
  { "logb", OpenCL_std, Extended, 0x1, 0x3 }, // 858
  { "mad", OpenCL_std, Extended, 0x1, 0x3 }, // 859
  { "MatrixInverse", GLSL_std_450, Extended, 0x1, 0x3 }, // 860
  { "maxmag", OpenCL_std, Extended, 0x1, 0x3 }, // 861
  { "minmag", OpenCL_std, Extended, 0x1, 0x3 }, // 862
  { "mix", OpenCL_std, Extended, 0x1, 0x3 }, // 863
  { "modf", OpenCL_std, Extended, 0x1, 0x3 }, // 864
  { "Modf", GLSL_std_450, Extended, 0x1, 0x3 }, // 865
  { "ModfStruct", GLSL_std_450, Extended, 0x1, 0x3 }, // 866
  { "nan", OpenCL_std, Extended, 0x1, 0x3 }, // 867
  { "native_cos", OpenCL_std, Extended, 0x1, 0x3 }, // 868
  { "native_divide", OpenCL_std, Extended, 0x1, 0x3 }, // 869
  { "native_exp", OpenCL_std, Extended, 0x1, 0x3 }, // 870
  { "native_exp10", OpenCL_std, Extended, 0x1, 0x3 }, // 871
  { "native_exp2", OpenCL_std, Extended, 0x1, 0x3 }, // 872
  { "native_log", OpenCL_std, Extended, 0x1, 0x3 }, // 873
  { "native_log10", OpenCL_std, Extended, 0x1, 0x3 }, // 874
  { "native_log2", OpenCL_std, Extended, 0x1, 0x3 }, // 875
  { "native_powr", OpenCL_std, Extended, 0x1, 0x3 }, // 876
  { "native_recip", OpenCL_std, Extended, 0x1, 0x3 }, // 877
  { "native_rsqrt", OpenCL_std, Extended, 0x1, 0x3 }, // 878
  { "native_sin", OpenCL_std, Extended, 0x1, 0x3 }, // 879
  { "native_sqrt", OpenCL_std, Extended, 0x1, 0x3 }, // 880
  { "native_tan", OpenCL_std, Extended, 0x1, 0x3 }, // 881
  { "NClamp", GLSL_std_450, Extended, 0x1, 0x3 }, // 882
  { "ndrange_1D", OpenCL_std, Enqueue, 0x1, 0x3 }, // 883
  { "ndrange_2D", OpenCL_std, Enqueue, 0x1, 0x3 }, // 884
  { "ndrange_3D", OpenCL_std, Enqueue, 0x1, 0x3 }, // 885
  { "nextafter", OpenCL_std, Extended, 0x1, 0x3 }, // 886
  { "NMax", GLSL_std_450, Extended, 0x1, 0x3 }, // 887
  { "NMin", GLSL_std_450, Extended, 0x1, 0x3 }, // 888
  { "normalize", OpenCL_std, Extended, 0x1, 0x3 }, // 889
  { "Normalize", GLSL_std_450, Extended, 0x1, 0x3 }, // 890
  { "PackDouble2x32", GLSL_std_450, Extended, 0x1, 0x3 }, // 891
  { "PackHalf2x16", GLSL_std_450, Extended, 0x1, 0x3 }, // 892
  { "PackSnorm2x16", GLSL_std_450, Extended, 0x1, 0x3 }, // 893
  { "PackSnorm4x8", GLSL_std_450, Extended, 0x1, 0x3 }, // 894
  { "PackUnorm2x16", GLSL_std_450, Extended, 0x1, 0x3 }, // 895
  { "PackUnorm4x8", GLSL_std_450, Extended, 0x1, 0x3 }, // 896
  { "popcount", OpenCL_std, Extended, 0x1, 0x3 }, // 897
  { "pow", OpenCL_std, Extended, 0x1, 0x3 }, // 898
  { "Pow", GLSL_std_450, Extended, 0x1, 0x3 }, // 899
  { "pown", OpenCL_std, Extended, 0x1, 0x3 }, // 900
  { "powr", OpenCL_std, Extended, 0x1, 0x3 }, // 901
  { "prefetch", OpenCL_std, Extended, 0x1, 0x3 }, // 902
  { "printf", OpenCL_std, Extended, 0x1, 0x3 }, // 903
  { "radians", OpenCL_std, Extended, 0x1, 0x3 }, // 904
  { "Radians", GLSL_std_450, Extended, 0x1, 0x3 }, // 905
  { "read_imagef", OpenCL_std, ReadImage, 0x2, 0x4 }, // 906
  { "read_imagei", OpenCL_std, ReadImage, 0x2, 0x4 }, // 907
  { "read_imageui", OpenCL_std, ReadImage, 0x2, 0x4 }, // 908
  { "Reflect", GLSL_std_450, Extended, 0x1, 0x3 }, // 909
  { "Refract", GLSL_std_450, Extended, 0x1, 0x3 }, // 910
  { "release_event", OpenCL_std, Enqueue, 0x1, 0x1 }, // 911
  { "remainder", OpenCL_std, Extended, 0x1, 0x3 }, // 912
  { "remquo", OpenCL_std, Extended, 0x1, 0x3 }, // 913
  { "retain_event", OpenCL_std, Enqueue, 0x1, 0x1 }, // 914
  { "rint", OpenCL_std, Extended, 0x1, 0x3 }, // 915
  { "rootn", OpenCL_std, Extended, 0x1, 0x3 }, // 916
  { "rotate", OpenCL_std, Extended, 0x1, 0x3 }, // 917
  { "round", OpenCL_std, Extended, 0x1, 0x3 }, // 918
  { "Round", GLSL_std_450, Extended, 0x1, 0x3 }, // 919
  { "RoundEven", GLSL_std_450, Extended, 0x1, 0x3 }, // 920
  { "rsqrt", OpenCL_std, Extended, 0x1, 0x3 }, // 921
  { "SAbs", GLSL_std_450, Extended, 0x1, 0x3 }, // 922
  { "SClamp", GLSL_std_450, Extended, 0x1, 0x3 }, // 923
  { "select", OpenCL_std, Extended, 0x1, 0x3 }, // 924
  { "set_user_event_status", OpenCL_std, Enqueue, 0x2, 0x2 }, // 925
  { "shuffle", OpenCL_std, Extended, 0x1, 0x3 }, // 926
  { "shuffle2", OpenCL_std, Extended, 0x1, 0x3 }, // 927
  { "sign", OpenCL_std, Extended, 0x1, 0x3 }, // 928
  { "signbit", OpenCL_std, Relational, 0x1, 0x1 }, // 929
  { "sin", OpenCL_std, Extended, 0x1, 0x3 }, // 930
  { "Sin", GLSL_std_450, Extended, 0x1, 0x3 }, // 931
  { "sincos", OpenCL_std, Extended, 0x1, 0x3 }, // 932
  { "sinh", OpenCL_std, Extended, 0x1, 0x3 }, // 933
  { "Sinh", GLSL_std_450, Extended, 0x1, 0x3 }, // 934
  { "sinpi", OpenCL_std, Extended, 0x1, 0x3 }, // 935
  { "SMax", GLSL_std_450, Extended, 0x1, 0x3 }, // 936
  { "SMin", GLSL_std_450, Extended, 0x1, 0x3 }, // 937
  { "smoothstep", OpenCL_std, Extended, 0x1, 0x3 }, // 938
  { "SmoothStep", GLSL_std_450, Extended, 0x1, 0x3 }, // 939
  { "sqrt", OpenCL_std, Extended, 0x1, 0x3 }, // 940
  { "Sqrt", GLSL_std_450, Extended, 0x1, 0x3 }, // 941
  { "SSign", GLSL_std_450, Extended, 0x1, 0x3 }, // 942
  { "step", OpenCL_std, Extended, 0x1, 0x3 }, // 943
  { "Step", GLSL_std_450, Extended, 0x1, 0x3 }, // 944
  { "sub_group_all", OpenCL_std, Group, 0x0, 0x4 }, // 945
  { "sub_group_any", OpenCL_std, Group, 0x0, 0x4 }, // 946
  { "sub_group_ballot", OpenCL_std, Group, 0x0, 0x4 }, // 947
  { "sub_group_ballot_bit_count", OpenCL_std, Group, 0x0, 0x4 }, // 948
  { "sub_group_ballot_bit_extract", OpenCL_std, Group, 0x0, 0x4 }, // 949
  { "sub_group_ballot_exclusive_scan", OpenCL_std, Group, 0x0, 0x4 }, // 950
  { "sub_group_ballot_find_lsb", OpenCL_std, Group, 0x0, 0x4 }, // 951
  { "sub_group_ballot_find_msb", OpenCL_std, Group, 0x0, 0x4 }, // 952
  { "sub_group_ballot_inclusive_scan", OpenCL_std, Group, 0x0, 0x4 }, // 953
  { "sub_group_broadcast", OpenCL_std, Group, 0x0, 0x4 }, // 954
  { "sub_group_broadcast_first", OpenCL_std, Group, 0x0, 0x4 }, // 955
  { "sub_group_clustered_reduce_addd", OpenCL_std, Group, 0x0, 0x4 }, // 956
  { "sub_group_clustered_reduce_addf", OpenCL_std, Group, 0x0, 0x4 }, // 957
  { "sub_group_clustered_reduce_addh", OpenCL_std, Group, 0x0, 0x4 }, // 958
  { "sub_group_clustered_reduce_adds", OpenCL_std, Group, 0x0, 0x4 }, // 959
  { "sub_group_clustered_reduce_addu", OpenCL_std, Group, 0x0, 0x4 }, // 960
  { "sub_group_clustered_reduce_ands", OpenCL_std, Group, 0x0, 0x4 }, // 961
  { "sub_group_clustered_reduce_andu", OpenCL_std, Group, 0x0, 0x4 }, // 962
  { "sub_group_clustered_reduce_logical_and", OpenCL_std, Group, 0x0, 0x4 }, // 963
  { "sub_group_clustered_reduce_logical_or", OpenCL_std, Group, 0x0, 0x4 }, // 964
  { "sub_group_clustered_reduce_logical_xor", OpenCL_std, Group, 0x0, 0x4 }, // 965
  { "sub_group_clustered_reduce_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 966
  { "sub_group_clustered_reduce_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 967
  { "sub_group_clustered_reduce_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 968
  { "sub_group_clustered_reduce_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 969
  { "sub_group_clustered_reduce_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 970
  { "sub_group_clustered_reduce_mind", OpenCL_std, Group, 0x0, 0x4 }, // 971
  { "sub_group_clustered_reduce_minf", OpenCL_std, Group, 0x0, 0x4 }, // 972
  { "sub_group_clustered_reduce_minh", OpenCL_std, Group, 0x0, 0x4 }, // 973
  { "sub_group_clustered_reduce_mins", OpenCL_std, Group, 0x0, 0x4 }, // 974
  { "sub_group_clustered_reduce_minu", OpenCL_std, Group, 0x0, 0x4 }, // 975
  { "sub_group_clustered_reduce_muld", OpenCL_std, Group, 0x0, 0x4 }, // 976
  { "sub_group_clustered_reduce_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 977
  { "sub_group_clustered_reduce_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 978
  { "sub_group_clustered_reduce_muls", OpenCL_std, Group, 0x0, 0x4 }, // 979
  { "sub_group_clustered_reduce_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 980
  { "sub_group_clustered_reduce_ors", OpenCL_std, Group, 0x0, 0x4 }, // 981
  { "sub_group_clustered_reduce_oru", OpenCL_std, Group, 0x0, 0x4 }, // 982
  { "sub_group_clustered_reduce_xors", OpenCL_std, Group, 0x0, 0x4 }, // 983
  { "sub_group_clustered_reduce_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 984
  { "sub_group_clustered_rotate", OpenCL_std, Group, 0x0, 0x4 }, // 985
  { "sub_group_elect", OpenCL_std, Group, 0x0, 0x4 }, // 986
  { "sub_group_fadd", OpenCL_std, Group, 0x0, 0x4 }, // 987
  { "sub_group_fmax", OpenCL_std, Group, 0x0, 0x4 }, // 988
  { "sub_group_fmin", OpenCL_std, Group, 0x0, 0x4 }, // 989
  { "sub_group_iadd", OpenCL_std, Group, 0x0, 0x4 }, // 990
  { "sub_group_inverse_ballot", OpenCL_std, Group, 0x0, 0x4 }, // 991
  { "sub_group_non_uniform_all", OpenCL_std, Group, 0x0, 0x4 }, // 992
  { "sub_group_non_uniform_all_equal", OpenCL_std, Group, 0x0, 0x4 }, // 993
  { "sub_group_non_uniform_any", OpenCL_std, Group, 0x0, 0x4 }, // 994
  { "sub_group_non_uniform_broadcast", OpenCL_std, Group, 0x0, 0x4 }, // 995
  { "sub_group_non_uniform_fadd", OpenCL_std, Group, 0x0, 0x4 }, // 996
  { "sub_group_non_uniform_fmax", OpenCL_std, Group, 0x0, 0x4 }, // 997
  { "sub_group_non_uniform_fmin", OpenCL_std, Group, 0x0, 0x4 }, // 998
  { "sub_group_non_uniform_fmul", OpenCL_std, Group, 0x0, 0x4 }, // 999
  { "sub_group_non_uniform_iadd", OpenCL_std, Group, 0x0, 0x4 }, // 1000
  { "sub_group_non_uniform_iand", OpenCL_std, Group, 0x0, 0x4 }, // 1001
  { "sub_group_non_uniform_imul", OpenCL_std, Group, 0x0, 0x4 }, // 1002
  { "sub_group_non_uniform_ior", OpenCL_std, Group, 0x0, 0x4 }, // 1003
  { "sub_group_non_uniform_ixor", OpenCL_std, Group, 0x0, 0x4 }, // 1004
  { "sub_group_non_uniform_logical_iand", OpenCL_std, Group, 0x0, 0x4 }, // 1005
  { "sub_group_non_uniform_logical_ior", OpenCL_std, Group, 0x0, 0x4 }, // 1006
  { "sub_group_non_uniform_logical_ixor", OpenCL_std, Group, 0x0, 0x4 }, // 1007
  { "sub_group_non_uniform_reduce_addd", OpenCL_std, Group, 0x0, 0x4 }, // 1008
  { "sub_group_non_uniform_reduce_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1009
  { "sub_group_non_uniform_reduce_addh", OpenCL_std, Group, 0x0, 0x4 }, // 1010
  { "sub_group_non_uniform_reduce_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1011
  { "sub_group_non_uniform_reduce_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1012
  { "sub_group_non_uniform_reduce_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1013
  { "sub_group_non_uniform_reduce_andu", OpenCL_std, Group, 0x0, 0x4 }, // 1014
  { "sub_group_non_uniform_reduce_logical_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1015
  { "sub_group_non_uniform_reduce_logical_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1016
  { "sub_group_non_uniform_reduce_logical_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1017
  { "sub_group_non_uniform_reduce_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 1018
  { "sub_group_non_uniform_reduce_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1019
  { "sub_group_non_uniform_reduce_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 1020
  { "sub_group_non_uniform_reduce_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1021
  { "sub_group_non_uniform_reduce_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1022
  { "sub_group_non_uniform_reduce_mind", OpenCL_std, Group, 0x0, 0x4 }, // 1023
  { "sub_group_non_uniform_reduce_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1024
  { "sub_group_non_uniform_reduce_minh", OpenCL_std, Group, 0x0, 0x4 }, // 1025
  { "sub_group_non_uniform_reduce_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1026
  { "sub_group_non_uniform_reduce_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1027
  { "sub_group_non_uniform_reduce_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1028
  { "sub_group_non_uniform_reduce_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1029
  { "sub_group_non_uniform_reduce_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1030
  { "sub_group_non_uniform_reduce_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1031
  { "sub_group_non_uniform_reduce_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1032
  { "sub_group_non_uniform_reduce_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1033
  { "sub_group_non_uniform_reduce_oru", OpenCL_std, Group, 0x0, 0x4 }, // 1034
  { "sub_group_non_uniform_reduce_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1035
  { "sub_group_non_uniform_reduce_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 1036
  { "sub_group_non_uniform_scan_exclusive_addd", OpenCL_std, Group, 0x0, 0x4 }, // 1037
  { "sub_group_non_uniform_scan_exclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1038
  { "sub_group_non_uniform_scan_exclusive_addh", OpenCL_std, Group, 0x0, 0x4 }, // 1039
  { "sub_group_non_uniform_scan_exclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1040
  { "sub_group_non_uniform_scan_exclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1041
  { "sub_group_non_uniform_scan_exclusive_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1042
  { "sub_group_non_uniform_scan_exclusive_andu", OpenCL_std, Group, 0x0, 0x4 }, // 1043
  { "sub_group_non_uniform_scan_exclusive_logical_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1044
  { "sub_group_non_uniform_scan_exclusive_logical_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1045
  { "sub_group_non_uniform_scan_exclusive_logical_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1046
  { "sub_group_non_uniform_scan_exclusive_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 1047
  { "sub_group_non_uniform_scan_exclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1048
  { "sub_group_non_uniform_scan_exclusive_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 1049
  { "sub_group_non_uniform_scan_exclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1050
  { "sub_group_non_uniform_scan_exclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1051
  { "sub_group_non_uniform_scan_exclusive_mind", OpenCL_std, Group, 0x0, 0x4 }, // 1052
  { "sub_group_non_uniform_scan_exclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1053
  { "sub_group_non_uniform_scan_exclusive_minh", OpenCL_std, Group, 0x0, 0x4 }, // 1054
  { "sub_group_non_uniform_scan_exclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1055
  { "sub_group_non_uniform_scan_exclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1056
  { "sub_group_non_uniform_scan_exclusive_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1057
  { "sub_group_non_uniform_scan_exclusive_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1058
  { "sub_group_non_uniform_scan_exclusive_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1059
  { "sub_group_non_uniform_scan_exclusive_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1060
  { "sub_group_non_uniform_scan_exclusive_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1061
  { "sub_group_non_uniform_scan_exclusive_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1062
  { "sub_group_non_uniform_scan_exclusive_oru", OpenCL_std, Group, 0x0, 0x4 }, // 1063
  { "sub_group_non_uniform_scan_exclusive_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1064
  { "sub_group_non_uniform_scan_exclusive_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 1065
  { "sub_group_non_uniform_scan_inclusive_addd", OpenCL_std, Group, 0x0, 0x4 }, // 1066
  { "sub_group_non_uniform_scan_inclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1067
  { "sub_group_non_uniform_scan_inclusive_addh", OpenCL_std, Group, 0x0, 0x4 }, // 1068
  { "sub_group_non_uniform_scan_inclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1069
  { "sub_group_non_uniform_scan_inclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1070
  { "sub_group_non_uniform_scan_inclusive_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1071
  { "sub_group_non_uniform_scan_inclusive_andu", OpenCL_std, Group, 0x0, 0x4 }, // 1072
  { "sub_group_non_uniform_scan_inclusive_logical_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1073
  { "sub_group_non_uniform_scan_inclusive_logical_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1074
  { "sub_group_non_uniform_scan_inclusive_logical_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1075
  { "sub_group_non_uniform_scan_inclusive_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 1076
  { "sub_group_non_uniform_scan_inclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1077
  { "sub_group_non_uniform_scan_inclusive_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 1078
  { "sub_group_non_uniform_scan_inclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1079
  { "sub_group_non_uniform_scan_inclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1080
  { "sub_group_non_uniform_scan_inclusive_mind", OpenCL_std, Group, 0x0, 0x4 }, // 1081
  { "sub_group_non_uniform_scan_inclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1082
  { "sub_group_non_uniform_scan_inclusive_minh", OpenCL_std, Group, 0x0, 0x4 }, // 1083
  { "sub_group_non_uniform_scan_inclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1084
  { "sub_group_non_uniform_scan_inclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1085
  { "sub_group_non_uniform_scan_inclusive_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1086
  { "sub_group_non_uniform_scan_inclusive_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1087
  { "sub_group_non_uniform_scan_inclusive_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1088
  { "sub_group_non_uniform_scan_inclusive_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1089
  { "sub_group_non_uniform_scan_inclusive_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1090
  { "sub_group_non_uniform_scan_inclusive_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1091
  { "sub_group_non_uniform_scan_inclusive_oru", OpenCL_std, Group, 0x0, 0x4 }, // 1092
  { "sub_group_non_uniform_scan_inclusive_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1093
  { "sub_group_non_uniform_scan_inclusive_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 1094
  { "sub_group_non_uniform_smax", OpenCL_std, Group, 0x0, 0x4 }, // 1095
  { "sub_group_non_uniform_smin", OpenCL_std, Group, 0x0, 0x4 }, // 1096
  { "sub_group_non_uniform_umax", OpenCL_std, Group, 0x0, 0x4 }, // 1097
  { "sub_group_non_uniform_umin", OpenCL_std, Group, 0x0, 0x4 }, // 1098
  { "sub_group_reduce_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1099
  { "sub_group_reduce_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1100
  { "sub_group_reduce_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1101
  { "sub_group_reduce_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1102
  { "sub_group_reduce_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1103
  { "sub_group_reduce_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1104
  { "sub_group_reduce_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1105
  { "sub_group_reduce_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1106
  { "sub_group_reduce_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1107
  { "sub_group_rotate", OpenCL_std, Group, 0x0, 0x4 }, // 1108
  { "sub_group_scan_exclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1109
  { "sub_group_scan_exclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1110
  { "sub_group_scan_exclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1111
  { "sub_group_scan_exclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1112
  { "sub_group_scan_exclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1113
  { "sub_group_scan_exclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1114
  { "sub_group_scan_exclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1115
  { "sub_group_scan_exclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1116
  { "sub_group_scan_exclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1117
  { "sub_group_scan_inclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1118
  { "sub_group_scan_inclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1119
  { "sub_group_scan_inclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1120
  { "sub_group_scan_inclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1121
  { "sub_group_scan_inclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1122
  { "sub_group_scan_inclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1123
  { "sub_group_scan_inclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1124
  { "sub_group_scan_inclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1125
  { "sub_group_scan_inclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1126
  { "sub_group_shuffle", OpenCL_std, Group, 0x0, 0x4 }, // 1127
  { "sub_group_shuffle_down", OpenCL_std, Group, 0x0, 0x4 }, // 1128
  { "sub_group_shuffle_up", OpenCL_std, Group, 0x0, 0x4 }, // 1129
  { "sub_group_shuffle_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1130
  { "sub_group_smax", OpenCL_std, Group, 0x0, 0x4 }, // 1131
  { "sub_group_smin", OpenCL_std, Group, 0x0, 0x4 }, // 1132
  { "sub_group_umax", OpenCL_std, Group, 0x0, 0x4 }, // 1133
  { "sub_group_umin", OpenCL_std, Group, 0x0, 0x4 }, // 1134
  { "s_abs", OpenCL_std, Extended, 0x1, 0x3 }, // 1135
  { "s_abs_diff", OpenCL_std, Extended, 0x1, 0x3 }, // 1136
  { "s_add_sat", OpenCL_std, Extended, 0x1, 0x3 }, // 1137
  { "s_clamp", OpenCL_std, Extended, 0x1, 0x3 }, // 1138
  { "s_hadd", OpenCL_std, Extended, 0x1, 0x3 }, // 1139
  { "s_mad24", OpenCL_std, Extended, 0x1, 0x3 }, // 1140
  { "s_mad_hi", OpenCL_std, Extended, 0x1, 0x3 }, // 1141
  { "s_mad_sat", OpenCL_std, Extended, 0x1, 0x3 }, // 1142
  { "s_max", OpenCL_std, Extended, 0x1, 0x3 }, // 1143
  { "s_min", OpenCL_std, Extended, 0x1, 0x3 }, // 1144
  { "s_mul24", OpenCL_std, Extended, 0x1, 0x3 }, // 1145
  { "s_mul_hi", OpenCL_std, Extended, 0x1, 0x3 }, // 1146
  { "s_rhadd", OpenCL_std, Extended, 0x1, 0x3 }, // 1147
  { "s_sub_sat", OpenCL_std, Extended, 0x1, 0x3 }, // 1148
  { "s_upsample", OpenCL_std, Extended, 0x1, 0x3 }, // 1149
  { "tan", OpenCL_std, Extended, 0x1, 0x3 }, // 1150
  { "Tan", GLSL_std_450, Extended, 0x1, 0x3 }, // 1151
  { "tanh", OpenCL_std, Extended, 0x1, 0x3 }, // 1152
  { "Tanh", GLSL_std_450, Extended, 0x1, 0x3 }, // 1153
  { "tanpi", OpenCL_std, Extended, 0x1, 0x3 }, // 1154
  { "tgamma", OpenCL_std, Extended, 0x1, 0x3 }, // 1155
  { "to_global", OpenCL_std, CastToPtr, 0x1, 0x1 }, // 1156
  { "to_local", OpenCL_std, CastToPtr, 0x1, 0x1 }, // 1157
  { "to_private", OpenCL_std, CastToPtr, 0x1, 0x1 }, // 1158
  { "trunc", OpenCL_std, Extended, 0x1, 0x3 }, // 1159
  { "Trunc", GLSL_std_450, Extended, 0x1, 0x3 }, // 1160
  { "UClamp", GLSL_std_450, Extended, 0x1, 0x3 }, // 1161
  { "UMax", GLSL_std_450, Extended, 0x1, 0x3 }, // 1162
  { "UMin", GLSL_std_450, Extended, 0x1, 0x3 }, // 1163
  { "UnpackDouble2x32", GLSL_std_450, Extended, 0x1, 0x3 }, // 1164
  { "UnpackHalf2x16", GLSL_std_450, Extended, 0x1, 0x3 }, // 1165
  { "UnpackSnorm2x16", GLSL_std_450, Extended, 0x1, 0x3 }, // 1166
  { "UnpackSnorm4x8", GLSL_std_450, Extended, 0x1, 0x3 }, // 1167
  { "UnpackUnorm2x16", GLSL_std_450, Extended, 0x1, 0x3 }, // 1168
  { "UnpackUnorm4x8", GLSL_std_450, Extended, 0x1, 0x3 }, // 1169
  { "u_abs", OpenCL_std, Extended, 0x1, 0x3 }, // 1170
  { "u_abs_diff", OpenCL_std, Extended, 0x1, 0x3 }, // 1171
  { "u_add_sat", OpenCL_std, Extended, 0x1, 0x3 }, // 1172
  { "u_clamp", OpenCL_std, Extended, 0x1, 0x3 }, // 1173
  { "u_hadd", OpenCL_std, Extended, 0x1, 0x3 }, // 1174
  { "u_mad24", OpenCL_std, Extended, 0x1, 0x3 }, // 1175
  { "u_mad_hi", OpenCL_std, Extended, 0x1, 0x3 }, // 1176
  { "u_mad_sat", OpenCL_std, Extended, 0x1, 0x3 }, // 1177
  { "u_max", OpenCL_std, Extended, 0x1, 0x3 }, // 1178
  { "u_min", OpenCL_std, Extended, 0x1, 0x3 }, // 1179
  { "u_mul24", OpenCL_std, Extended, 0x1, 0x3 }, // 1180
  { "u_mul_hi", OpenCL_std, Extended, 0x1, 0x3 }, // 1181
  { "u_rhadd", OpenCL_std, Extended, 0x1, 0x3 }, // 1182
  { "u_sub_sat", OpenCL_std, Extended, 0x1, 0x3 }, // 1183
  { "u_upsample", OpenCL_std, Extended, 0x1, 0x3 }, // 1184
  { "vload", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1185
  { "vload16", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1186
  { "vload2", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1187
  { "vload3", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1188
  { "vload4", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1189
  { "vload8", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1190
  { "vloada_half", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1191
  { "vloada_half16", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1192
  { "vloada_half2", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1193
  { "vloada_half3", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1194
  { "vloada_half4", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1195
  { "vloada_half8", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1196
  { "vloada_halfn", OpenCL_std, Extended, 0x1, 0x3 }, // 1197
  { "vloadn", OpenCL_std, Extended, 0x1, 0x3 }, // 1198
  { "vload_half", OpenCL_std, Extended, 0x1, 0x3 }, // 1199
  { "vload_half", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1200
  { "vload_half16", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1201
  { "vload_half2", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1202
  { "vload_half3", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1203
  { "vload_half4", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1204
  { "vload_half8", OpenCL_std, VectorLoadStore, 0x2, 0x2 }, // 1205
  { "vload_halfn", OpenCL_std, Extended, 0x1, 0x3 }, // 1206
  { "vstore", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1207
  { "vstore16", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1208
  { "vstore2", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1209
  { "vstore3", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1210
  { "vstore4", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1211
  { "vstore8", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1212
  { "vstorea_half", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1213
  { "vstorea_half16", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1214
  { "vstorea_half16_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1215
  { "vstorea_half16_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1216
  { "vstorea_half16_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1217
  { "vstorea_half16_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1218
  { "vstorea_half2", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1219
  { "vstorea_half2_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1220
  { "vstorea_half2_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1221
  { "vstorea_half2_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1222
  { "vstorea_half2_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1223
  { "vstorea_half3", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1224
  { "vstorea_half3_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1225
  { "vstorea_half3_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1226
  { "vstorea_half3_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1227
  { "vstorea_half3_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1228
  { "vstorea_half4", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1229
  { "vstorea_half4_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1230
  { "vstorea_half4_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1231
  { "vstorea_half4_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1232
  { "vstorea_half4_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1233
  { "vstorea_half8", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1234
  { "vstorea_half8_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1235
  { "vstorea_half8_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1236
  { "vstorea_half8_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1237
  { "vstorea_half8_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1238
  { "vstorea_halfn", OpenCL_std, Extended, 0x1, 0x3 }, // 1239
  { "vstorea_halfn_r", OpenCL_std, Extended, 0x1, 0x3 }, // 1240
  { "vstorea_half_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1241
  { "vstorea_half_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1242
  { "vstorea_half_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1243
  { "vstorea_half_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1244
  { "vstoren", OpenCL_std, Extended, 0x1, 0x3 }, // 1245
  { "vstore_half", OpenCL_std, Extended, 0x1, 0x3 }, // 1246
  { "vstore_half", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1247
  { "vstore_half16", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1248
  { "vstore_half16_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1249
  { "vstore_half16_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1250
  { "vstore_half16_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1251
  { "vstore_half16_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1252
  { "vstore_half2", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1253
  { "vstore_half2_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1254
  { "vstore_half2_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1255
  { "vstore_half2_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1256
  { "vstore_half2_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1257
  { "vstore_half3", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1258
  { "vstore_half3_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1259
  { "vstore_half3_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1260
  { "vstore_half3_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1261
  { "vstore_half3_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1262
  { "vstore_half4", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1263
  { "vstore_half4_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1264
  { "vstore_half4_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1265
  { "vstore_half4_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1266
  { "vstore_half4_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1267
  { "vstore_half8", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1268
  { "vstore_half8_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1269
  { "vstore_half8_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1270
  { "vstore_half8_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1271
  { "vstore_half8_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1272
  { "vstore_halfn", OpenCL_std, Extended, 0x1, 0x3 }, // 1273
  { "vstore_halfn_r", OpenCL_std, Extended, 0x1, 0x3 }, // 1274
  { "vstore_half_r", OpenCL_std, Extended, 0x1, 0x3 }, // 1275
  { "vstore_half_rte", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1276
  { "vstore_half_rtn", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1277
  { "vstore_half_rtp", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1278
  { "vstore_half_rtz", OpenCL_std, VectorLoadStore, 0x3, 0x3 }, // 1279
  { "wait_group_events", OpenCL_std, AsyncCopy, 0x2, 0x2 }, // 1280
  { "work_group_all", OpenCL_std, Group, 0x0, 0x4 }, // 1281
  { "work_group_any", OpenCL_std, Group, 0x0, 0x4 }, // 1282
  { "work_group_barrier", OpenCL_std, Barrier, 0x1, 0x3 }, // 1283
  { "work_group_broadcast", OpenCL_std, Group, 0x0, 0x4 }, // 1284
  { "work_group_clustered_reduce_addd", OpenCL_std, Group, 0x0, 0x4 }, // 1285
  { "work_group_clustered_reduce_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1286
  { "work_group_clustered_reduce_addh", OpenCL_std, Group, 0x0, 0x4 }, // 1287
  { "work_group_clustered_reduce_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1288
  { "work_group_clustered_reduce_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1289
  { "work_group_clustered_reduce_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1290
  { "work_group_clustered_reduce_andu", OpenCL_std, Group, 0x0, 0x4 }, // 1291
  { "work_group_clustered_reduce_logical_and", OpenCL_std, Group, 0x0, 0x4 }, // 1292
  { "work_group_clustered_reduce_logical_or", OpenCL_std, Group, 0x0, 0x4 }, // 1293
  { "work_group_clustered_reduce_logical_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1294
  { "work_group_clustered_reduce_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 1295
  { "work_group_clustered_reduce_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1296
  { "work_group_clustered_reduce_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 1297
  { "work_group_clustered_reduce_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1298
  { "work_group_clustered_reduce_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1299
  { "work_group_clustered_reduce_mind", OpenCL_std, Group, 0x0, 0x4 }, // 1300
  { "work_group_clustered_reduce_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1301
  { "work_group_clustered_reduce_minh", OpenCL_std, Group, 0x0, 0x4 }, // 1302
  { "work_group_clustered_reduce_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1303
  { "work_group_clustered_reduce_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1304
  { "work_group_clustered_reduce_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1305
  { "work_group_clustered_reduce_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1306
  { "work_group_clustered_reduce_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1307
  { "work_group_clustered_reduce_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1308
  { "work_group_clustered_reduce_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1309
  { "work_group_clustered_reduce_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1310
  { "work_group_clustered_reduce_oru", OpenCL_std, Group, 0x0, 0x4 }, // 1311
  { "work_group_clustered_reduce_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1312
  { "work_group_clustered_reduce_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 1313
  { "work_group_fadd", OpenCL_std, Group, 0x0, 0x4 }, // 1314
  { "work_group_fmax", OpenCL_std, Group, 0x0, 0x4 }, // 1315
  { "work_group_fmin", OpenCL_std, Group, 0x0, 0x4 }, // 1316
  { "work_group_iadd", OpenCL_std, Group, 0x0, 0x4 }, // 1317
  { "work_group_non_uniform_fadd", OpenCL_std, Group, 0x0, 0x4 }, // 1318
  { "work_group_non_uniform_fmax", OpenCL_std, Group, 0x0, 0x4 }, // 1319
  { "work_group_non_uniform_fmin", OpenCL_std, Group, 0x0, 0x4 }, // 1320
  { "work_group_non_uniform_fmul", OpenCL_std, Group, 0x0, 0x4 }, // 1321
  { "work_group_non_uniform_iadd", OpenCL_std, Group, 0x0, 0x4 }, // 1322
  { "work_group_non_uniform_iand", OpenCL_std, Group, 0x0, 0x4 }, // 1323
  { "work_group_non_uniform_imul", OpenCL_std, Group, 0x0, 0x4 }, // 1324
  { "work_group_non_uniform_ior", OpenCL_std, Group, 0x0, 0x4 }, // 1325
  { "work_group_non_uniform_ixor", OpenCL_std, Group, 0x0, 0x4 }, // 1326
  { "work_group_non_uniform_logical_iand", OpenCL_std, Group, 0x0, 0x4 }, // 1327
  { "work_group_non_uniform_logical_ior", OpenCL_std, Group, 0x0, 0x4 }, // 1328
  { "work_group_non_uniform_logical_ixor", OpenCL_std, Group, 0x0, 0x4 }, // 1329
  { "work_group_non_uniform_reduce_addd", OpenCL_std, Group, 0x0, 0x4 }, // 1330
  { "work_group_non_uniform_reduce_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1331
  { "work_group_non_uniform_reduce_addh", OpenCL_std, Group, 0x0, 0x4 }, // 1332
  { "work_group_non_uniform_reduce_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1333
  { "work_group_non_uniform_reduce_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1334
  { "work_group_non_uniform_reduce_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1335
  { "work_group_non_uniform_reduce_andu", OpenCL_std, Group, 0x0, 0x4 }, // 1336
  { "work_group_non_uniform_reduce_logical_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1337
  { "work_group_non_uniform_reduce_logical_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1338
  { "work_group_non_uniform_reduce_logical_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1339
  { "work_group_non_uniform_reduce_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 1340
  { "work_group_non_uniform_reduce_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1341
  { "work_group_non_uniform_reduce_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 1342
  { "work_group_non_uniform_reduce_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1343
  { "work_group_non_uniform_reduce_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1344
  { "work_group_non_uniform_reduce_mind", OpenCL_std, Group, 0x0, 0x4 }, // 1345
  { "work_group_non_uniform_reduce_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1346
  { "work_group_non_uniform_reduce_minh", OpenCL_std, Group, 0x0, 0x4 }, // 1347
  { "work_group_non_uniform_reduce_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1348
  { "work_group_non_uniform_reduce_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1349
  { "work_group_non_uniform_reduce_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1350
  { "work_group_non_uniform_reduce_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1351
  { "work_group_non_uniform_reduce_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1352
  { "work_group_non_uniform_reduce_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1353
  { "work_group_non_uniform_reduce_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1354
  { "work_group_non_uniform_reduce_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1355
  { "work_group_non_uniform_reduce_oru", OpenCL_std, Group, 0x0, 0x4 }, // 1356
  { "work_group_non_uniform_reduce_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1357
  { "work_group_non_uniform_reduce_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 1358
  { "work_group_non_uniform_scan_exclusive_addd", OpenCL_std, Group, 0x0, 0x4 }, // 1359
  { "work_group_non_uniform_scan_exclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1360
  { "work_group_non_uniform_scan_exclusive_addh", OpenCL_std, Group, 0x0, 0x4 }, // 1361
  { "work_group_non_uniform_scan_exclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1362
  { "work_group_non_uniform_scan_exclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1363
  { "work_group_non_uniform_scan_exclusive_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1364
  { "work_group_non_uniform_scan_exclusive_andu", OpenCL_std, Group, 0x0, 0x4 }, // 1365
  { "work_group_non_uniform_scan_exclusive_logical_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1366
  { "work_group_non_uniform_scan_exclusive_logical_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1367
  { "work_group_non_uniform_scan_exclusive_logical_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1368
  { "work_group_non_uniform_scan_exclusive_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 1369
  { "work_group_non_uniform_scan_exclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1370
  { "work_group_non_uniform_scan_exclusive_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 1371
  { "work_group_non_uniform_scan_exclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1372
  { "work_group_non_uniform_scan_exclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1373
  { "work_group_non_uniform_scan_exclusive_mind", OpenCL_std, Group, 0x0, 0x4 }, // 1374
  { "work_group_non_uniform_scan_exclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1375
  { "work_group_non_uniform_scan_exclusive_minh", OpenCL_std, Group, 0x0, 0x4 }, // 1376
  { "work_group_non_uniform_scan_exclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1377
  { "work_group_non_uniform_scan_exclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1378
  { "work_group_non_uniform_scan_exclusive_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1379
  { "work_group_non_uniform_scan_exclusive_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1380
  { "work_group_non_uniform_scan_exclusive_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1381
  { "work_group_non_uniform_scan_exclusive_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1382
  { "work_group_non_uniform_scan_exclusive_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1383
  { "work_group_non_uniform_scan_exclusive_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1384
  { "work_group_non_uniform_scan_exclusive_oru", OpenCL_std, Group, 0x0, 0x4 }, // 1385
  { "work_group_non_uniform_scan_exclusive_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1386
  { "work_group_non_uniform_scan_exclusive_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 1387
  { "work_group_non_uniform_scan_inclusive_addd", OpenCL_std, Group, 0x0, 0x4 }, // 1388
  { "work_group_non_uniform_scan_inclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1389
  { "work_group_non_uniform_scan_inclusive_addh", OpenCL_std, Group, 0x0, 0x4 }, // 1390
  { "work_group_non_uniform_scan_inclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1391
  { "work_group_non_uniform_scan_inclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1392
  { "work_group_non_uniform_scan_inclusive_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1393
  { "work_group_non_uniform_scan_inclusive_andu", OpenCL_std, Group, 0x0, 0x4 }, // 1394
  { "work_group_non_uniform_scan_inclusive_logical_ands", OpenCL_std, Group, 0x0, 0x4 }, // 1395
  { "work_group_non_uniform_scan_inclusive_logical_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1396
  { "work_group_non_uniform_scan_inclusive_logical_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1397
  { "work_group_non_uniform_scan_inclusive_maxd", OpenCL_std, Group, 0x0, 0x4 }, // 1398
  { "work_group_non_uniform_scan_inclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1399
  { "work_group_non_uniform_scan_inclusive_maxh", OpenCL_std, Group, 0x0, 0x4 }, // 1400
  { "work_group_non_uniform_scan_inclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1401
  { "work_group_non_uniform_scan_inclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1402
  { "work_group_non_uniform_scan_inclusive_mind", OpenCL_std, Group, 0x0, 0x4 }, // 1403
  { "work_group_non_uniform_scan_inclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1404
  { "work_group_non_uniform_scan_inclusive_minh", OpenCL_std, Group, 0x0, 0x4 }, // 1405
  { "work_group_non_uniform_scan_inclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1406
  { "work_group_non_uniform_scan_inclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1407
  { "work_group_non_uniform_scan_inclusive_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1408
  { "work_group_non_uniform_scan_inclusive_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1409
  { "work_group_non_uniform_scan_inclusive_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1410
  { "work_group_non_uniform_scan_inclusive_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1411
  { "work_group_non_uniform_scan_inclusive_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1412
  { "work_group_non_uniform_scan_inclusive_ors", OpenCL_std, Group, 0x0, 0x4 }, // 1413
  { "work_group_non_uniform_scan_inclusive_oru", OpenCL_std, Group, 0x0, 0x4 }, // 1414
  { "work_group_non_uniform_scan_inclusive_xors", OpenCL_std, Group, 0x0, 0x4 }, // 1415
  { "work_group_non_uniform_scan_inclusive_xoru", OpenCL_std, Group, 0x0, 0x4 }, // 1416
  { "work_group_non_uniform_smax", OpenCL_std, Group, 0x0, 0x4 }, // 1417
  { "work_group_non_uniform_smin", OpenCL_std, Group, 0x0, 0x4 }, // 1418
  { "work_group_non_uniform_umax", OpenCL_std, Group, 0x0, 0x4 }, // 1419
  { "work_group_non_uniform_umin", OpenCL_std, Group, 0x0, 0x4 }, // 1420
  { "work_group_reduce_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1421
  { "work_group_reduce_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1422
  { "work_group_reduce_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1423
  { "work_group_reduce_and", OpenCL_std, Group, 0x0, 0x4 }, // 1424
  { "work_group_reduce_imul", OpenCL_std, Group, 0x0, 0x4 }, // 1425
  { "work_group_reduce_logical_and", OpenCL_std, Group, 0x0, 0x4 }, // 1426
  { "work_group_reduce_logical_or", OpenCL_std, Group, 0x0, 0x4 }, // 1427
  { "work_group_reduce_logical_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1428
  { "work_group_reduce_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1429
  { "work_group_reduce_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1430
  { "work_group_reduce_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1431
  { "work_group_reduce_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1432
  { "work_group_reduce_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1433
  { "work_group_reduce_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1434
  { "work_group_reduce_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1435
  { "work_group_reduce_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1436
  { "work_group_reduce_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1437
  { "work_group_reduce_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1438
  { "work_group_reduce_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1439
  { "work_group_reduce_or", OpenCL_std, Group, 0x0, 0x4 }, // 1440
  { "work_group_reduce_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1441
  { "work_group_scan_exclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1442
  { "work_group_scan_exclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1443
  { "work_group_scan_exclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1444
  { "work_group_scan_exclusive_and", OpenCL_std, Group, 0x0, 0x4 }, // 1445
  { "work_group_scan_exclusive_imul", OpenCL_std, Group, 0x0, 0x4 }, // 1446
  { "work_group_scan_exclusive_logical_and", OpenCL_std, Group, 0x0, 0x4 }, // 1447
  { "work_group_scan_exclusive_logical_or", OpenCL_std, Group, 0x0, 0x4 }, // 1448
  { "work_group_scan_exclusive_logical_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1449
  { "work_group_scan_exclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1450
  { "work_group_scan_exclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1451
  { "work_group_scan_exclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1452
  { "work_group_scan_exclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1453
  { "work_group_scan_exclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1454
  { "work_group_scan_exclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1455
  { "work_group_scan_exclusive_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1456
  { "work_group_scan_exclusive_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1457
  { "work_group_scan_exclusive_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1458
  { "work_group_scan_exclusive_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1459
  { "work_group_scan_exclusive_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1460
  { "work_group_scan_exclusive_or", OpenCL_std, Group, 0x0, 0x4 }, // 1461
  { "work_group_scan_exclusive_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1462
  { "work_group_scan_inclusive_addf", OpenCL_std, Group, 0x0, 0x4 }, // 1463
  { "work_group_scan_inclusive_adds", OpenCL_std, Group, 0x0, 0x4 }, // 1464
  { "work_group_scan_inclusive_addu", OpenCL_std, Group, 0x0, 0x4 }, // 1465
  { "work_group_scan_inclusive_and", OpenCL_std, Group, 0x0, 0x4 }, // 1466
  { "work_group_scan_inclusive_imul", OpenCL_std, Group, 0x0, 0x4 }, // 1467
  { "work_group_scan_inclusive_logical_and", OpenCL_std, Group, 0x0, 0x4 }, // 1468
  { "work_group_scan_inclusive_logical_or", OpenCL_std, Group, 0x0, 0x4 }, // 1469
  { "work_group_scan_inclusive_logical_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1470
  { "work_group_scan_inclusive_maxf", OpenCL_std, Group, 0x0, 0x4 }, // 1471
  { "work_group_scan_inclusive_maxs", OpenCL_std, Group, 0x0, 0x4 }, // 1472
  { "work_group_scan_inclusive_maxu", OpenCL_std, Group, 0x0, 0x4 }, // 1473
  { "work_group_scan_inclusive_minf", OpenCL_std, Group, 0x0, 0x4 }, // 1474
  { "work_group_scan_inclusive_mins", OpenCL_std, Group, 0x0, 0x4 }, // 1475
  { "work_group_scan_inclusive_minu", OpenCL_std, Group, 0x0, 0x4 }, // 1476
  { "work_group_scan_inclusive_muld", OpenCL_std, Group, 0x0, 0x4 }, // 1477
  { "work_group_scan_inclusive_mulf", OpenCL_std, Group, 0x0, 0x4 }, // 1478
  { "work_group_scan_inclusive_mulh", OpenCL_std, Group, 0x0, 0x4 }, // 1479
  { "work_group_scan_inclusive_muls", OpenCL_std, Group, 0x0, 0x4 }, // 1480
  { "work_group_scan_inclusive_mulu", OpenCL_std, Group, 0x0, 0x4 }, // 1481
  { "work_group_scan_inclusive_or", OpenCL_std, Group, 0x0, 0x4 }, // 1482
  { "work_group_scan_inclusive_xor", OpenCL_std, Group, 0x0, 0x4 }, // 1483
  { "work_group_smax", OpenCL_std, Group, 0x0, 0x4 }, // 1484
  { "work_group_smin", OpenCL_std, Group, 0x0, 0x4 }, // 1485
  { "work_group_umax", OpenCL_std, Group, 0x0, 0x4 }, // 1486
  { "work_group_umin", OpenCL_std, Group, 0x0, 0x4 }, // 1487
  { "write_imagef", OpenCL_std, WriteImage, 0x3, 0x4 }, // 1488
  { "write_imageh", OpenCL_std, WriteImage, 0x3, 0x4 }, // 1489
  { "write_imagei", OpenCL_std, WriteImage, 0x3, 0x4 }, // 1490
  { "write_imageui", OpenCL_std, WriteImage, 0x3, 0x4 }, // 1491
  { "__enqueue_kernel_basic", OpenCL_std, Enqueue, 0x5, 0x5 }, // 1492
  { "__enqueue_kernel_basic_events", OpenCL_std, Enqueue, 0x8, 0x8 }, // 1493
  { "__enqueue_kernel_events_varargs", OpenCL_std, Enqueue, 0xA, 0xA }, // 1494
  { "__enqueue_kernel_varargs", OpenCL_std, Enqueue, 0x7, 0x7 }, // 1495
  { "__hlsl_wave_get_lane_index", GLSL_std_450, Wave, 0x0, 0x1 }, // 1496
  { "__spirv_All", OpenCL_std, Relational, 0x1, 0x1 }, // 1497
  { "__spirv_Any", OpenCL_std, Relational, 0x1, 0x1 }, // 1498
  { "__spirv_AtomicAnd", OpenCL_std, Atomic, 0x4, 0x4 }, // 1499
  { "__spirv_AtomicCompareExchange", OpenCL_std, Atomic, 0x6, 0x6 }, // 1500
  { "__spirv_AtomicCompareExchangeWeak", OpenCL_std, Atomic, 0x6, 0x6 }, // 1501
  { "__spirv_AtomicExchange", OpenCL_std, Atomic, 0x4, 0x4 }, // 1502
  { "__spirv_AtomicFAddEXT", OpenCL_std, AtomicFloating, 0x4, 0x4 }, // 1503
  { "__spirv_AtomicFlagClear", OpenCL_std, Atomic, 0x3, 0x3 }, // 1504
  { "__spirv_AtomicFlagTestAndSet", OpenCL_std, Atomic, 0x3, 0x3 }, // 1505
  { "__spirv_AtomicFMaxEXT", OpenCL_std, AtomicFloating, 0x4, 0x4 }, // 1506
  { "__spirv_AtomicFMinEXT", OpenCL_std, AtomicFloating, 0x4, 0x4 }, // 1507
  { "__spirv_AtomicIAdd", OpenCL_std, Atomic, 0x4, 0x4 }, // 1508
  { "__spirv_AtomicISub", OpenCL_std, Atomic, 0x4, 0x4 }, // 1509
  { "__spirv_AtomicLoad", OpenCL_std, Atomic, 0x3, 0x3 }, // 1510
  { "__spirv_AtomicOr", OpenCL_std, Atomic, 0x4, 0x4 }, // 1511
  { "__spirv_AtomicSMax", OpenCL_std, Atomic, 0x4, 0x4 }, // 1512
  { "__spirv_AtomicSMin", OpenCL_std, Atomic, 0x4, 0x4 }, // 1513
  { "__spirv_AtomicStore", OpenCL_std, Atomic, 0x4, 0x4 }, // 1514
  { "__spirv_AtomicUMax", OpenCL_std, Atomic, 0x4, 0x4 }, // 1515
  { "__spirv_AtomicUMin", OpenCL_std, Atomic, 0x4, 0x4 }, // 1516
  { "__spirv_AtomicXor", OpenCL_std, Atomic, 0x4, 0x4 }, // 1517
  { "__spirv_BuiltInGlobalInvocationId", OpenCL_std, Variable, 0x0, 0x1 }, // 1518
  { "__spirv_BuiltInGlobalLinearId", OpenCL_std, Variable, 0x0, 0x1 }, // 1519
  { "__spirv_CaptureEventProfilingInfo", OpenCL_std, Enqueue, 0x3, 0x3 }, // 1520
  { "__spirv_CompositeConstruct", OpenCL_std, Construct, 0x1, 0x0 }, // 1521
  { "__spirv_ControlBarrier", OpenCL_std, Barrier, 0x3, 0x3 }, // 1522
  { "__spirv_ControlBarrierArriveINTEL", OpenCL_std, Barrier, 0x3, 0x3 }, // 1523
  { "__spirv_ControlBarrierWaitINTEL", OpenCL_std, Barrier, 0x3, 0x3 }, // 1524
  { "__spirv_ConvertBF16ToFINTEL", OpenCL_std, Convert, 0x1, 0x1 }, // 1525
  { "__spirv_ConvertFToBF16INTEL", OpenCL_std, Convert, 0x1, 0x1 }, // 1526
  { "__spirv_ConvertFToS", OpenCL_std, Convert, 0x1, 0x1 }, // 1527
  { "__spirv_ConvertFToU", OpenCL_std, Convert, 0x1, 0x1 }, // 1528
  { "__spirv_ConvertPtrToU", OpenCL_std, Convert, 0x1, 0x1 }, // 1529
  { "__spirv_ConvertSToF", OpenCL_std, Convert, 0x1, 0x1 }, // 1530
  { "__spirv_ConvertUToF", OpenCL_std, Convert, 0x1, 0x1 }, // 1531
  { "__spirv_ConvertUToPtr", OpenCL_std, Convert, 0x1, 0x1 }, // 1532
  { "__spirv_CooperativeMatrixConstructCheckedINTEL", OpenCL_std, CoopMatr, 0x5, 0x5 }, // 1533
  { "__spirv_CooperativeMatrixGetElementCoordINTEL", OpenCL_std, CoopMatr, 0x2, 0x2 }, // 1534
  { "__spirv_CooperativeMatrixLengthKHR", OpenCL_std, CoopMatr, 0x1, 0x1 }, // 1535
  { "__spirv_CooperativeMatrixLoadCheckedINTEL", OpenCL_std, CoopMatr, 0x6, 0x8 }, // 1536
  { "__spirv_CooperativeMatrixLoadKHR", OpenCL_std, CoopMatr, 0x2, 0x4 }, // 1537
  { "__spirv_CooperativeMatrixMulAddKHR", OpenCL_std, CoopMatr, 0x3, 0x4 }, // 1538
  { "__spirv_CooperativeMatrixPrefetchINTEL", OpenCL_std, CoopMatr, 0x5, 0x7 }, // 1539
  { "__spirv_CooperativeMatrixStoreCheckedINTEL", OpenCL_std, CoopMatr, 0x7, 0x9 }, // 1540
  { "__spirv_CooperativeMatrixStoreKHR", OpenCL_std, CoopMatr, 0x3, 0x5 }, // 1541
  { "__spirv_CreateUserEvent", OpenCL_std, Enqueue, 0x0, 0x0 }, // 1542
  { "__spirv_Dot", OpenCL_std, Dot, 0x2, 0x2 }, // 1543
  { "__spirv_EnqueueKernel", OpenCL_std, Enqueue, 0xA, 0x0 }, // 1544
  { "__spirv_FConvert", OpenCL_std, Convert, 0x1, 0x1 }, // 1545
  { "__spirv_FOrdEqual", OpenCL_std, Relational, 0x2, 0x2 }, // 1546
  { "__spirv_FOrdGreaterThan", OpenCL_std, Relational, 0x2, 0x2 }, // 1547
  { "__spirv_FOrdGreaterThanEqual", OpenCL_std, Relational, 0x2, 0x2 }, // 1548
  { "__spirv_FOrdLessThan", OpenCL_std, Relational, 0x2, 0x2 }, // 1549
  { "__spirv_FOrdLessThanEqual", OpenCL_std, Relational, 0x2, 0x2 }, // 1550
  { "__spirv_FOrdNotEqual", OpenCL_std, Relational, 0x2, 0x2 }, // 1551
  { "__spirv_FUnordNotEqual", OpenCL_std, Relational, 0x2, 0x2 }, // 1552
  { "__spirv_GenericCastToPtrExplicit_ToGlobal", OpenCL_std, CastToPtr, 0x2, 0x2 }, // 1553
  { "__spirv_GenericCastToPtrExplicit_ToLocal", OpenCL_std, CastToPtr, 0x2, 0x2 }, // 1554
  { "__spirv_GenericCastToPtrExplicit_ToPrivate", OpenCL_std, CastToPtr, 0x2, 0x2 }, // 1555
  { "__spirv_GenericCastToPtr_ToGlobal", OpenCL_std, CastToPtr, 0x2, 0x2 }, // 1556
  { "__spirv_GenericCastToPtr_ToLocal", OpenCL_std, CastToPtr, 0x2, 0x2 }, // 1557
  { "__spirv_GenericCastToPtr_ToPrivate", OpenCL_std, CastToPtr, 0x2, 0x2 }, // 1558
  { "__spirv_GetDefaultQueue", OpenCL_std, Enqueue, 0x0, 0x0 }, // 1559
  { "__spirv_GroupAll", OpenCL_std, Group, 0x2, 0x2 }, // 1560
  { "__spirv_GroupAny", OpenCL_std, Group, 0x2, 0x2 }, // 1561
  { "__spirv_GroupAsyncCopy", OpenCL_std, AsyncCopy, 0x6, 0x6 }, // 1562
  { "__spirv_GroupBitwiseAndKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1563
  { "__spirv_GroupBitwiseOrKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1564
  { "__spirv_GroupBitwiseXorKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1565
  { "__spirv_GroupBroadcast", OpenCL_std, Group, 0x3, 0x3 }, // 1566
  { "__spirv_GroupFAdd", OpenCL_std, Group, 0x3, 0x3 }, // 1567
  { "__spirv_GroupFMax", OpenCL_std, Group, 0x3, 0x3 }, // 1568
  { "__spirv_GroupFMin", OpenCL_std, Group, 0x3, 0x3 }, // 1569
  { "__spirv_GroupFMulKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1570
  { "__spirv_GroupIAdd", OpenCL_std, Group, 0x3, 0x3 }, // 1571
  { "__spirv_GroupIMulKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1572
  { "__spirv_GroupLogicalAndKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1573
  { "__spirv_GroupLogicalOrKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1574
  { "__spirv_GroupLogicalXorKHR", OpenCL_std, GroupUniform, 0x3, 0x3 }, // 1575
  { "__spirv_GroupNonUniformAll", OpenCL_std, Group, 0x2, 0x2 }, // 1576
  { "__spirv_GroupNonUniformAllEqual", OpenCL_std, Group, 0x2, 0x2 }, // 1577
  { "__spirv_GroupNonUniformAny", OpenCL_std, Group, 0x2, 0x2 }, // 1578
  { "__spirv_GroupNonUniformBallot", OpenCL_std, Group, 0x2, 0x2 }, // 1579
  { "__spirv_GroupNonUniformBallotBitCount", OpenCL_std, Group, 0x3, 0x3 }, // 1580
  { "__spirv_GroupNonUniformBallotBitExtract", OpenCL_std, Group, 0x3, 0x3 }, // 1581
  { "__spirv_GroupNonUniformBallotFindLSB", OpenCL_std, Group, 0x2, 0x2 }, // 1582
  { "__spirv_GroupNonUniformBallotFindMSB", OpenCL_std, Group, 0x2, 0x2 }, // 1583
  { "__spirv_GroupNonUniformBitwiseAnd", OpenCL_std, Group, 0x3, 0x4 }, // 1584
  { "__spirv_GroupNonUniformBitwiseOr", OpenCL_std, Group, 0x3, 0x4 }, // 1585
  { "__spirv_GroupNonUniformBitwiseXor", OpenCL_std, Group, 0x3, 0x4 }, // 1586
  { "__spirv_GroupNonUniformBroadcast", OpenCL_std, Group, 0x3, 0x3 }, // 1587
  { "__spirv_GroupNonUniformBroadcastFirst", OpenCL_std, Group, 0x2, 0x2 }, // 1588
  { "__spirv_GroupNonUniformElect", OpenCL_std, Group, 0x1, 0x1 }, // 1589
  { "__spirv_GroupNonUniformFAdd", OpenCL_std, Group, 0x3, 0x4 }, // 1590
  { "__spirv_GroupNonUniformFMax", OpenCL_std, Group, 0x3, 0x4 }, // 1591
  { "__spirv_GroupNonUniformFMin", OpenCL_std, Group, 0x3, 0x4 }, // 1592
  { "__spirv_GroupNonUniformFMul", OpenCL_std, Group, 0x3, 0x4 }, // 1593
  { "__spirv_GroupNonUniformIAdd", OpenCL_std, Group, 0x3, 0x4 }, // 1594
  { "__spirv_GroupNonUniformIMul", OpenCL_std, Group, 0x3, 0x4 }, // 1595
  { "__spirv_GroupNonUniformInverseBallot", OpenCL_std, Group, 0x2, 0x2 }, // 1596
  { "__spirv_GroupNonUniformLogicalAnd", OpenCL_std, Group, 0x3, 0x4 }, // 1597
  { "__spirv_GroupNonUniformLogicalOr", OpenCL_std, Group, 0x3, 0x4 }, // 1598
  { "__spirv_GroupNonUniformLogicalXor", OpenCL_std, Group, 0x3, 0x4 }, // 1599
  { "__spirv_GroupNonUniformShuffle", OpenCL_std, Group, 0x3, 0x3 }, // 1600
  { "__spirv_GroupNonUniformShuffleDown", OpenCL_std, Group, 0x3, 0x3 }, // 1601
  { "__spirv_GroupNonUniformShuffleUp", OpenCL_std, Group, 0x3, 0x3 }, // 1602
  { "__spirv_GroupNonUniformShuffleXor", OpenCL_std, Group, 0x3, 0x3 }, // 1603
  { "__spirv_GroupNonUniformSMax", OpenCL_std, Group, 0x3, 0x4 }, // 1604
  { "__spirv_GroupNonUniformSMin", OpenCL_std, Group, 0x3, 0x4 }, // 1605
  { "__spirv_GroupNonUniformUMax", OpenCL_std, Group, 0x3, 0x4 }, // 1606
  { "__spirv_GroupNonUniformUMin", OpenCL_std, Group, 0x3, 0x4 }, // 1607
  { "__spirv_GroupSMax", OpenCL_std, Group, 0x3, 0x3 }, // 1608
  { "__spirv_GroupSMin", OpenCL_std, Group, 0x3, 0x3 }, // 1609
  { "__spirv_GroupUMax", OpenCL_std, Group, 0x3, 0x3 }, // 1610
  { "__spirv_GroupUMin", OpenCL_std, Group, 0x3, 0x3 }, // 1611
  { "__spirv_GroupWaitEvents", OpenCL_std, AsyncCopy, 0x3, 0x3 }, // 1612
  { "__spirv_IAddCarry", OpenCL_std, ICarryBorrow, 0x3, 0x3 }, // 1613
  { "__spirv_ImageSampleExplicitLod", OpenCL_std, SampleImage, 0x3, 0x4 }, // 1614
  { "__spirv_IsFinite", OpenCL_std, Relational, 0x1, 0x1 }, // 1615
  { "__spirv_IsInf", OpenCL_std, Relational, 0x1, 0x1 }, // 1616
  { "__spirv_IsNan", OpenCL_std, Relational, 0x1, 0x1 }, // 1617
  { "__spirv_IsNormal", OpenCL_std, Relational, 0x1, 0x1 }, // 1618
  { "__spirv_ISubBorrow", OpenCL_std, ICarryBorrow, 0x3, 0x3 }, // 1619
  { "__spirv_IsValidEvent", OpenCL_std, Enqueue, 0x1, 0x1 }, // 1620
  { "__spirv_Load", OpenCL_std, LoadStore, 0x1, 0x3 }, // 1621
  { "__spirv_MemoryBarrier", OpenCL_std, Atomic, 0x2, 0x2 }, // 1622
  { "__spirv_Ordered", OpenCL_std, Relational, 0x2, 0x2 }, // 1623
  { "__spirv_QuantizeToF16", OpenCL_std, Convert, 0x1, 0x1 }, // 1624
  { "__spirv_ReleaseEvent", OpenCL_std, Enqueue, 0x1, 0x1 }, // 1625
  { "__spirv_RetainEvent", OpenCL_std, Enqueue, 0x1, 0x1 }, // 1626
  { "__spirv_SampledImage", OpenCL_std, SampleImage, 0x2, 0x2 }, // 1627
  { "__spirv_SatConvertSToU", OpenCL_std, Convert, 0x1, 0x1 }, // 1628
  { "__spirv_SatConvertUToS", OpenCL_std, Convert, 0x1, 0x1 }, // 1629
  { "__spirv_SConvert", OpenCL_std, Convert, 0x1, 0x1 }, // 1630
  { "__spirv_Select", OpenCL_std, Select, 0x3, 0x3 }, // 1631
  { "__spirv_SetUserEventStatus", OpenCL_std, Enqueue, 0x2, 0x2 }, // 1632
  { "__spirv_SignBitSet", OpenCL_std, Relational, 0x1, 0x1 }, // 1633
  { "__spirv_SpecConstant", OpenCL_std, SpecConstant, 0x2, 0x2 }, // 1634
  { "__spirv_SpecConstantComposite", OpenCL_std, SpecConstant, 0x1, 0x0 }, // 1635
  { "__spirv_Store", OpenCL_std, LoadStore, 0x2, 0x4 }, // 1636
  { "__spirv_SubgroupBlockReadINTEL", OpenCL_std, IntelSubgroups, 0x1, 0x1 }, // 1637
  { "__spirv_SubgroupBlockWriteINTEL", OpenCL_std, IntelSubgroups, 0x2, 0x2 }, // 1638
  { "__spirv_SubgroupImageBlockReadINTEL", OpenCL_std, IntelSubgroups, 0x2, 0x2 }, // 1639
  { "__spirv_SubgroupImageBlockWriteINTEL", OpenCL_std, IntelSubgroups, 0x3, 0x3 }, // 1640
  { "__spirv_SubgroupImageMediaBlockReadINTEL", OpenCL_std, IntelSubgroups, 0x4, 0x4 }, // 1641
  { "__spirv_SubgroupImageMediaBlockWriteINTEL", OpenCL_std, IntelSubgroups, 0x5, 0x5 }, // 1642
  { "__spirv_SubgroupShuffleDownINTEL", OpenCL_std, IntelSubgroups, 0x3, 0x3 }, // 1643
  { "__spirv_SubgroupShuffleINTEL", OpenCL_std, IntelSubgroups, 0x2, 0x2 }, // 1644
  { "__spirv_SubgroupShuffleUpINTEL", OpenCL_std, IntelSubgroups, 0x3, 0x3 }, // 1645
  { "__spirv_SubgroupShuffleXorINTEL", OpenCL_std, IntelSubgroups, 0x2, 0x2 }, // 1646
  { "__spirv_UConvert", OpenCL_std, Convert, 0x1, 0x1 }, // 1647
  { "__spirv_Unordered", OpenCL_std, Relational, 0x2, 0x2 }, // 1648
  { "__translate_sampler_initializer", OpenCL_std, SampleImage, 0x1, 0x1 }, // 1649
 };

const DemangledBuiltin *lookupBuiltin(StringRef Name, unsigned Set) {
  struct IndexType {
    const char * Name;
    unsigned Set;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ACOS", OpenCL_std, 0 },
    { "ACOS", GLSL_std_450, 1 },
    { "ACOSH", OpenCL_std, 2 },
    { "ACOSH", GLSL_std_450, 3 },
    { "ACOSPI", OpenCL_std, 4 },
    { "ALL", OpenCL_std, 5 },
    { "ANY", OpenCL_std, 6 },
    { "ASIN", OpenCL_std, 7 },
    { "ASIN", GLSL_std_450, 8 },
    { "ASINH", OpenCL_std, 9 },
    { "ASINH", GLSL_std_450, 10 },
    { "ASINPI", OpenCL_std, 11 },
    { "ASYNC_WORK_GROUP_COPY", OpenCL_std, 12 },
    { "ASYNC_WORK_GROUP_STRIDED_COPY", OpenCL_std, 13 },
    { "ATAN", OpenCL_std, 14 },
    { "ATAN", GLSL_std_450, 15 },
    { "ATAN2", OpenCL_std, 16 },
    { "ATAN2", GLSL_std_450, 17 },
    { "ATAN2PI", OpenCL_std, 18 },
    { "ATANH", OpenCL_std, 19 },
    { "ATANH", GLSL_std_450, 20 },
    { "ATANPI", OpenCL_std, 21 },
    { "ATOMICEX__SPIRV_CHANGE", OpenCL_std, 22 },
    { "ATOMIC_ADD", OpenCL_std, 23 },
    { "ATOMIC_AND", OpenCL_std, 24 },
    { "ATOMIC_CMPXCHG", OpenCL_std, 25 },
    { "ATOMIC_COMPARE_EXCHANGE_STRONG", OpenCL_std, 26 },
    { "ATOMIC_COMPARE_EXCHANGE_STRONG_EXPLICIT", OpenCL_std, 27 },
    { "ATOMIC_COMPARE_EXCHANGE_WEAK", OpenCL_std, 28 },
    { "ATOMIC_COMPARE_EXCHANGE_WEAK_EXPLICIT", OpenCL_std, 29 },
    { "ATOMIC_EXCHANGE", OpenCL_std, 30 },
    { "ATOMIC_EXCHANGE_EXPLICIT", OpenCL_std, 31 },
    { "ATOMIC_FETCH_ADD", OpenCL_std, 32 },
    { "ATOMIC_FETCH_ADD_EXPLICIT", OpenCL_std, 33 },
    { "ATOMIC_FETCH_AND", OpenCL_std, 34 },
    { "ATOMIC_FETCH_AND_EXPLICIT", OpenCL_std, 35 },
    { "ATOMIC_FETCH_OR", OpenCL_std, 36 },
    { "ATOMIC_FETCH_OR_EXPLICIT", OpenCL_std, 37 },
    { "ATOMIC_FETCH_SUB", OpenCL_std, 38 },
    { "ATOMIC_FETCH_SUB_EXPLICIT", OpenCL_std, 39 },
    { "ATOMIC_FETCH_XOR", OpenCL_std, 40 },
    { "ATOMIC_FETCH_XOR_EXPLICIT", OpenCL_std, 41 },
    { "ATOMIC_FLAG_CLEAR", OpenCL_std, 42 },
    { "ATOMIC_FLAG_CLEAR_EXPLICIT", OpenCL_std, 43 },
    { "ATOMIC_FLAG_TEST_AND_SET", OpenCL_std, 44 },
    { "ATOMIC_FLAG_TEST_AND_SET_EXPLICIT", OpenCL_std, 45 },
    { "ATOMIC_INIT", OpenCL_std, 46 },
    { "ATOMIC_LOAD", OpenCL_std, 47 },
    { "ATOMIC_LOAD_EXPLICIT", OpenCL_std, 48 },
    { "ATOMIC_OR", OpenCL_std, 49 },
    { "ATOMIC_STORE", OpenCL_std, 50 },
    { "ATOMIC_STORE_EXPLICIT", OpenCL_std, 51 },
    { "ATOMIC_SUB", OpenCL_std, 52 },
    { "ATOMIC_WORK_ITEM_FENCE", OpenCL_std, 53 },
    { "ATOMIC_XOR", OpenCL_std, 54 },
    { "ATOM_ADD", OpenCL_std, 55 },
    { "ATOM_AND", OpenCL_std, 56 },
    { "ATOM_CMPXCHG", OpenCL_std, 57 },
    { "ATOM_OR", OpenCL_std, 58 },
    { "ATOM_SUB", OpenCL_std, 59 },
    { "ATOM_XOR", OpenCL_std, 60 },
    { "BARRIER", OpenCL_std, 61 },
    { "BITSELECT", OpenCL_std, 62 },
    { "CAPTURE_EVENT_PROFILING_INFO", OpenCL_std, 63 },
    { "CBRT", OpenCL_std, 64 },
    { "CEIL", OpenCL_std, 65 },
    { "CEIL", GLSL_std_450, 66 },
    { "CLOCK_READ_DEVICE", OpenCL_std, 67 },
    { "CLOCK_READ_HILO_DEVICE", OpenCL_std, 68 },
    { "CLOCK_READ_HILO_SUB_GROUP", OpenCL_std, 69 },
    { "CLOCK_READ_HILO_WORK_GROUP", OpenCL_std, 70 },
    { "CLOCK_READ_SUB_GROUP", OpenCL_std, 71 },
    { "CLOCK_READ_WORK_GROUP", OpenCL_std, 72 },
    { "CLZ", OpenCL_std, 73 },
    { "CONVERT_CHAR", OpenCL_std, 74 },
    { "CONVERT_CHAR16", OpenCL_std, 75 },
    { "CONVERT_CHAR16_RTE", OpenCL_std, 76 },
    { "CONVERT_CHAR16_RTN", OpenCL_std, 77 },
    { "CONVERT_CHAR16_RTP", OpenCL_std, 78 },
    { "CONVERT_CHAR16_RTZ", OpenCL_std, 79 },
    { "CONVERT_CHAR16_SAT", OpenCL_std, 80 },
    { "CONVERT_CHAR16_SAT_RTE", OpenCL_std, 81 },
    { "CONVERT_CHAR16_SAT_RTN", OpenCL_std, 82 },
    { "CONVERT_CHAR16_SAT_RTP", OpenCL_std, 83 },
    { "CONVERT_CHAR16_SAT_RTZ", OpenCL_std, 84 },
    { "CONVERT_CHAR2", OpenCL_std, 85 },
    { "CONVERT_CHAR2_RTE", OpenCL_std, 86 },
    { "CONVERT_CHAR2_RTN", OpenCL_std, 87 },
    { "CONVERT_CHAR2_RTP", OpenCL_std, 88 },
    { "CONVERT_CHAR2_RTZ", OpenCL_std, 89 },
    { "CONVERT_CHAR2_SAT", OpenCL_std, 90 },
    { "CONVERT_CHAR2_SAT_RTE", OpenCL_std, 91 },
    { "CONVERT_CHAR2_SAT_RTN", OpenCL_std, 92 },
    { "CONVERT_CHAR2_SAT_RTP", OpenCL_std, 93 },
    { "CONVERT_CHAR2_SAT_RTZ", OpenCL_std, 94 },
    { "CONVERT_CHAR3", OpenCL_std, 95 },
    { "CONVERT_CHAR3_RTE", OpenCL_std, 96 },
    { "CONVERT_CHAR3_RTN", OpenCL_std, 97 },
    { "CONVERT_CHAR3_RTP", OpenCL_std, 98 },
    { "CONVERT_CHAR3_RTZ", OpenCL_std, 99 },
    { "CONVERT_CHAR3_SAT", OpenCL_std, 100 },
    { "CONVERT_CHAR3_SAT_RTE", OpenCL_std, 101 },
    { "CONVERT_CHAR3_SAT_RTN", OpenCL_std, 102 },
    { "CONVERT_CHAR3_SAT_RTP", OpenCL_std, 103 },
    { "CONVERT_CHAR3_SAT_RTZ", OpenCL_std, 104 },
    { "CONVERT_CHAR4", OpenCL_std, 105 },
    { "CONVERT_CHAR4_RTE", OpenCL_std, 106 },
    { "CONVERT_CHAR4_RTN", OpenCL_std, 107 },
    { "CONVERT_CHAR4_RTP", OpenCL_std, 108 },
    { "CONVERT_CHAR4_RTZ", OpenCL_std, 109 },
    { "CONVERT_CHAR4_SAT", OpenCL_std, 110 },
    { "CONVERT_CHAR4_SAT_RTE", OpenCL_std, 111 },
    { "CONVERT_CHAR4_SAT_RTN", OpenCL_std, 112 },
    { "CONVERT_CHAR4_SAT_RTP", OpenCL_std, 113 },
    { "CONVERT_CHAR4_SAT_RTZ", OpenCL_std, 114 },
    { "CONVERT_CHAR8", OpenCL_std, 115 },
    { "CONVERT_CHAR8_RTE", OpenCL_std, 116 },
    { "CONVERT_CHAR8_RTN", OpenCL_std, 117 },
    { "CONVERT_CHAR8_RTP", OpenCL_std, 118 },
    { "CONVERT_CHAR8_RTZ", OpenCL_std, 119 },
    { "CONVERT_CHAR8_SAT", OpenCL_std, 120 },
    { "CONVERT_CHAR8_SAT_RTE", OpenCL_std, 121 },
    { "CONVERT_CHAR8_SAT_RTN", OpenCL_std, 122 },
    { "CONVERT_CHAR8_SAT_RTP", OpenCL_std, 123 },
    { "CONVERT_CHAR8_SAT_RTZ", OpenCL_std, 124 },
    { "CONVERT_CHAR_RTE", OpenCL_std, 125 },
    { "CONVERT_CHAR_RTN", OpenCL_std, 126 },
    { "CONVERT_CHAR_RTP", OpenCL_std, 127 },
    { "CONVERT_CHAR_RTZ", OpenCL_std, 128 },
    { "CONVERT_CHAR_SAT", OpenCL_std, 129 },
    { "CONVERT_CHAR_SAT_RTE", OpenCL_std, 130 },
    { "CONVERT_CHAR_SAT_RTN", OpenCL_std, 131 },
    { "CONVERT_CHAR_SAT_RTP", OpenCL_std, 132 },
    { "CONVERT_CHAR_SAT_RTZ", OpenCL_std, 133 },
    { "CONVERT_FLOAT", OpenCL_std, 134 },
    { "CONVERT_FLOAT16", OpenCL_std, 135 },
    { "CONVERT_FLOAT16_RTE", OpenCL_std, 136 },
    { "CONVERT_FLOAT16_RTN", OpenCL_std, 137 },
    { "CONVERT_FLOAT16_RTP", OpenCL_std, 138 },
    { "CONVERT_FLOAT16_RTZ", OpenCL_std, 139 },
    { "CONVERT_FLOAT2", OpenCL_std, 140 },
    { "CONVERT_FLOAT2_RTE", OpenCL_std, 141 },
    { "CONVERT_FLOAT2_RTN", OpenCL_std, 142 },
    { "CONVERT_FLOAT2_RTP", OpenCL_std, 143 },
    { "CONVERT_FLOAT2_RTZ", OpenCL_std, 144 },
    { "CONVERT_FLOAT3", OpenCL_std, 145 },
    { "CONVERT_FLOAT3_RTE", OpenCL_std, 146 },
    { "CONVERT_FLOAT3_RTN", OpenCL_std, 147 },
    { "CONVERT_FLOAT3_RTP", OpenCL_std, 148 },
    { "CONVERT_FLOAT3_RTZ", OpenCL_std, 149 },
    { "CONVERT_FLOAT4", OpenCL_std, 150 },
    { "CONVERT_FLOAT4_RTE", OpenCL_std, 151 },
    { "CONVERT_FLOAT4_RTN", OpenCL_std, 152 },
    { "CONVERT_FLOAT4_RTP", OpenCL_std, 153 },
    { "CONVERT_FLOAT4_RTZ", OpenCL_std, 154 },
    { "CONVERT_FLOAT8", OpenCL_std, 155 },
    { "CONVERT_FLOAT8_RTE", OpenCL_std, 156 },
    { "CONVERT_FLOAT8_RTN", OpenCL_std, 157 },
    { "CONVERT_FLOAT8_RTP", OpenCL_std, 158 },
    { "CONVERT_FLOAT8_RTZ", OpenCL_std, 159 },
    { "CONVERT_FLOAT_RTE", OpenCL_std, 160 },
    { "CONVERT_FLOAT_RTN", OpenCL_std, 161 },
    { "CONVERT_FLOAT_RTP", OpenCL_std, 162 },
    { "CONVERT_FLOAT_RTZ", OpenCL_std, 163 },
    { "CONVERT_INT", OpenCL_std, 164 },
    { "CONVERT_INT16", OpenCL_std, 165 },
    { "CONVERT_INT16_RTE", OpenCL_std, 166 },
    { "CONVERT_INT16_RTN", OpenCL_std, 167 },
    { "CONVERT_INT16_RTP", OpenCL_std, 168 },
    { "CONVERT_INT16_RTZ", OpenCL_std, 169 },
    { "CONVERT_INT16_SAT", OpenCL_std, 170 },
    { "CONVERT_INT16_SAT_RTE", OpenCL_std, 171 },
    { "CONVERT_INT16_SAT_RTN", OpenCL_std, 172 },
    { "CONVERT_INT16_SAT_RTP", OpenCL_std, 173 },
    { "CONVERT_INT16_SAT_RTZ", OpenCL_std, 174 },
    { "CONVERT_INT2", OpenCL_std, 175 },
    { "CONVERT_INT2_RTE", OpenCL_std, 176 },
    { "CONVERT_INT2_RTN", OpenCL_std, 177 },
    { "CONVERT_INT2_RTP", OpenCL_std, 178 },
    { "CONVERT_INT2_RTZ", OpenCL_std, 179 },
    { "CONVERT_INT2_SAT", OpenCL_std, 180 },
    { "CONVERT_INT2_SAT_RTE", OpenCL_std, 181 },
    { "CONVERT_INT2_SAT_RTN", OpenCL_std, 182 },
    { "CONVERT_INT2_SAT_RTP", OpenCL_std, 183 },
    { "CONVERT_INT2_SAT_RTZ", OpenCL_std, 184 },
    { "CONVERT_INT3", OpenCL_std, 185 },
    { "CONVERT_INT3_RTE", OpenCL_std, 186 },
    { "CONVERT_INT3_RTN", OpenCL_std, 187 },
    { "CONVERT_INT3_RTP", OpenCL_std, 188 },
    { "CONVERT_INT3_RTZ", OpenCL_std, 189 },
    { "CONVERT_INT3_SAT", OpenCL_std, 190 },
    { "CONVERT_INT3_SAT_RTE", OpenCL_std, 191 },
    { "CONVERT_INT3_SAT_RTN", OpenCL_std, 192 },
    { "CONVERT_INT3_SAT_RTP", OpenCL_std, 193 },
    { "CONVERT_INT3_SAT_RTZ", OpenCL_std, 194 },
    { "CONVERT_INT4", OpenCL_std, 195 },
    { "CONVERT_INT4_RTE", OpenCL_std, 196 },
    { "CONVERT_INT4_RTN", OpenCL_std, 197 },
    { "CONVERT_INT4_RTP", OpenCL_std, 198 },
    { "CONVERT_INT4_RTZ", OpenCL_std, 199 },
    { "CONVERT_INT4_SAT", OpenCL_std, 200 },
    { "CONVERT_INT4_SAT_RTE", OpenCL_std, 201 },
    { "CONVERT_INT4_SAT_RTN", OpenCL_std, 202 },
    { "CONVERT_INT4_SAT_RTP", OpenCL_std, 203 },
    { "CONVERT_INT4_SAT_RTZ", OpenCL_std, 204 },
    { "CONVERT_INT8", OpenCL_std, 205 },
    { "CONVERT_INT8_RTE", OpenCL_std, 206 },
    { "CONVERT_INT8_RTN", OpenCL_std, 207 },
    { "CONVERT_INT8_RTP", OpenCL_std, 208 },
    { "CONVERT_INT8_RTZ", OpenCL_std, 209 },
    { "CONVERT_INT8_SAT", OpenCL_std, 210 },
    { "CONVERT_INT8_SAT_RTE", OpenCL_std, 211 },
    { "CONVERT_INT8_SAT_RTN", OpenCL_std, 212 },
    { "CONVERT_INT8_SAT_RTP", OpenCL_std, 213 },
    { "CONVERT_INT8_SAT_RTZ", OpenCL_std, 214 },
    { "CONVERT_INT_RTE", OpenCL_std, 215 },
    { "CONVERT_INT_RTN", OpenCL_std, 216 },
    { "CONVERT_INT_RTP", OpenCL_std, 217 },
    { "CONVERT_INT_RTZ", OpenCL_std, 218 },
    { "CONVERT_INT_SAT", OpenCL_std, 219 },
    { "CONVERT_INT_SAT_RTE", OpenCL_std, 220 },
    { "CONVERT_INT_SAT_RTN", OpenCL_std, 221 },
    { "CONVERT_INT_SAT_RTP", OpenCL_std, 222 },
    { "CONVERT_INT_SAT_RTZ", OpenCL_std, 223 },
    { "CONVERT_LONG", OpenCL_std, 224 },
    { "CONVERT_LONG16", OpenCL_std, 225 },
    { "CONVERT_LONG16_RTE", OpenCL_std, 226 },
    { "CONVERT_LONG16_RTN", OpenCL_std, 227 },
    { "CONVERT_LONG16_RTP", OpenCL_std, 228 },
    { "CONVERT_LONG16_RTZ", OpenCL_std, 229 },
    { "CONVERT_LONG16_SAT", OpenCL_std, 230 },
    { "CONVERT_LONG16_SAT_RTE", OpenCL_std, 231 },
    { "CONVERT_LONG16_SAT_RTN", OpenCL_std, 232 },
    { "CONVERT_LONG16_SAT_RTP", OpenCL_std, 233 },
    { "CONVERT_LONG16_SAT_RTZ", OpenCL_std, 234 },
    { "CONVERT_LONG2", OpenCL_std, 235 },
    { "CONVERT_LONG2_RTE", OpenCL_std, 236 },
    { "CONVERT_LONG2_RTN", OpenCL_std, 237 },
    { "CONVERT_LONG2_RTP", OpenCL_std, 238 },
    { "CONVERT_LONG2_RTZ", OpenCL_std, 239 },
    { "CONVERT_LONG2_SAT", OpenCL_std, 240 },
    { "CONVERT_LONG2_SAT_RTE", OpenCL_std, 241 },
    { "CONVERT_LONG2_SAT_RTN", OpenCL_std, 242 },
    { "CONVERT_LONG2_SAT_RTP", OpenCL_std, 243 },
    { "CONVERT_LONG2_SAT_RTZ", OpenCL_std, 244 },
    { "CONVERT_LONG3", OpenCL_std, 245 },
    { "CONVERT_LONG3_RTE", OpenCL_std, 246 },
    { "CONVERT_LONG3_RTN", OpenCL_std, 247 },
    { "CONVERT_LONG3_RTP", OpenCL_std, 248 },
    { "CONVERT_LONG3_RTZ", OpenCL_std, 249 },
    { "CONVERT_LONG3_SAT", OpenCL_std, 250 },
    { "CONVERT_LONG3_SAT_RTE", OpenCL_std, 251 },
    { "CONVERT_LONG3_SAT_RTN", OpenCL_std, 252 },
    { "CONVERT_LONG3_SAT_RTP", OpenCL_std, 253 },
    { "CONVERT_LONG3_SAT_RTZ", OpenCL_std, 254 },
    { "CONVERT_LONG4", OpenCL_std, 255 },
    { "CONVERT_LONG4_RTE", OpenCL_std, 256 },
    { "CONVERT_LONG4_RTN", OpenCL_std, 257 },
    { "CONVERT_LONG4_RTP", OpenCL_std, 258 },
    { "CONVERT_LONG4_RTZ", OpenCL_std, 259 },
    { "CONVERT_LONG4_SAT", OpenCL_std, 260 },
    { "CONVERT_LONG4_SAT_RTE", OpenCL_std, 261 },
    { "CONVERT_LONG4_SAT_RTN", OpenCL_std, 262 },
    { "CONVERT_LONG4_SAT_RTP", OpenCL_std, 263 },
    { "CONVERT_LONG4_SAT_RTZ", OpenCL_std, 264 },
    { "CONVERT_LONG8", OpenCL_std, 265 },
    { "CONVERT_LONG8_RTE", OpenCL_std, 266 },
    { "CONVERT_LONG8_RTN", OpenCL_std, 267 },
    { "CONVERT_LONG8_RTP", OpenCL_std, 268 },
    { "CONVERT_LONG8_RTZ", OpenCL_std, 269 },
    { "CONVERT_LONG8_SAT", OpenCL_std, 270 },
    { "CONVERT_LONG8_SAT_RTE", OpenCL_std, 271 },
    { "CONVERT_LONG8_SAT_RTN", OpenCL_std, 272 },
    { "CONVERT_LONG8_SAT_RTP", OpenCL_std, 273 },
    { "CONVERT_LONG8_SAT_RTZ", OpenCL_std, 274 },
    { "CONVERT_LONG_RTE", OpenCL_std, 275 },
    { "CONVERT_LONG_RTN", OpenCL_std, 276 },
    { "CONVERT_LONG_RTP", OpenCL_std, 277 },
    { "CONVERT_LONG_RTZ", OpenCL_std, 278 },
    { "CONVERT_LONG_SAT", OpenCL_std, 279 },
    { "CONVERT_LONG_SAT_RTE", OpenCL_std, 280 },
    { "CONVERT_LONG_SAT_RTN", OpenCL_std, 281 },
    { "CONVERT_LONG_SAT_RTP", OpenCL_std, 282 },
    { "CONVERT_LONG_SAT_RTZ", OpenCL_std, 283 },
    { "CONVERT_SHORT", OpenCL_std, 284 },
    { "CONVERT_SHORT16", OpenCL_std, 285 },
    { "CONVERT_SHORT16_RTE", OpenCL_std, 286 },
    { "CONVERT_SHORT16_RTN", OpenCL_std, 287 },
    { "CONVERT_SHORT16_RTP", OpenCL_std, 288 },
    { "CONVERT_SHORT16_RTZ", OpenCL_std, 289 },
    { "CONVERT_SHORT16_SAT", OpenCL_std, 290 },
    { "CONVERT_SHORT16_SAT_RTE", OpenCL_std, 291 },
    { "CONVERT_SHORT16_SAT_RTN", OpenCL_std, 292 },
    { "CONVERT_SHORT16_SAT_RTP", OpenCL_std, 293 },
    { "CONVERT_SHORT16_SAT_RTZ", OpenCL_std, 294 },
    { "CONVERT_SHORT2", OpenCL_std, 295 },
    { "CONVERT_SHORT2_RTE", OpenCL_std, 296 },
    { "CONVERT_SHORT2_RTN", OpenCL_std, 297 },
    { "CONVERT_SHORT2_RTP", OpenCL_std, 298 },
    { "CONVERT_SHORT2_RTZ", OpenCL_std, 299 },
    { "CONVERT_SHORT2_SAT", OpenCL_std, 300 },
    { "CONVERT_SHORT2_SAT_RTE", OpenCL_std, 301 },
    { "CONVERT_SHORT2_SAT_RTN", OpenCL_std, 302 },
    { "CONVERT_SHORT2_SAT_RTP", OpenCL_std, 303 },
    { "CONVERT_SHORT2_SAT_RTZ", OpenCL_std, 304 },
    { "CONVERT_SHORT3", OpenCL_std, 305 },
    { "CONVERT_SHORT3_RTE", OpenCL_std, 306 },
    { "CONVERT_SHORT3_RTN", OpenCL_std, 307 },
    { "CONVERT_SHORT3_RTP", OpenCL_std, 308 },
    { "CONVERT_SHORT3_RTZ", OpenCL_std, 309 },
    { "CONVERT_SHORT3_SAT", OpenCL_std, 310 },
    { "CONVERT_SHORT3_SAT_RTE", OpenCL_std, 311 },
    { "CONVERT_SHORT3_SAT_RTN", OpenCL_std, 312 },
    { "CONVERT_SHORT3_SAT_RTP", OpenCL_std, 313 },
    { "CONVERT_SHORT3_SAT_RTZ", OpenCL_std, 314 },
    { "CONVERT_SHORT4", OpenCL_std, 315 },
    { "CONVERT_SHORT4_RTE", OpenCL_std, 316 },
    { "CONVERT_SHORT4_RTN", OpenCL_std, 317 },
    { "CONVERT_SHORT4_RTP", OpenCL_std, 318 },
    { "CONVERT_SHORT4_RTZ", OpenCL_std, 319 },
    { "CONVERT_SHORT4_SAT", OpenCL_std, 320 },
    { "CONVERT_SHORT4_SAT_RTE", OpenCL_std, 321 },
    { "CONVERT_SHORT4_SAT_RTN", OpenCL_std, 322 },
    { "CONVERT_SHORT4_SAT_RTP", OpenCL_std, 323 },
    { "CONVERT_SHORT4_SAT_RTZ", OpenCL_std, 324 },
    { "CONVERT_SHORT8", OpenCL_std, 325 },
    { "CONVERT_SHORT8_RTE", OpenCL_std, 326 },
    { "CONVERT_SHORT8_RTN", OpenCL_std, 327 },
    { "CONVERT_SHORT8_RTP", OpenCL_std, 328 },
    { "CONVERT_SHORT8_RTZ", OpenCL_std, 329 },
    { "CONVERT_SHORT8_SAT", OpenCL_std, 330 },
    { "CONVERT_SHORT8_SAT_RTE", OpenCL_std, 331 },
    { "CONVERT_SHORT8_SAT_RTN", OpenCL_std, 332 },
    { "CONVERT_SHORT8_SAT_RTP", OpenCL_std, 333 },
    { "CONVERT_SHORT8_SAT_RTZ", OpenCL_std, 334 },
    { "CONVERT_SHORT_RTE", OpenCL_std, 335 },
    { "CONVERT_SHORT_RTN", OpenCL_std, 336 },
    { "CONVERT_SHORT_RTP", OpenCL_std, 337 },
    { "CONVERT_SHORT_RTZ", OpenCL_std, 338 },
    { "CONVERT_SHORT_SAT", OpenCL_std, 339 },
    { "CONVERT_SHORT_SAT_RTE", OpenCL_std, 340 },
    { "CONVERT_SHORT_SAT_RTN", OpenCL_std, 341 },
    { "CONVERT_SHORT_SAT_RTP", OpenCL_std, 342 },
    { "CONVERT_SHORT_SAT_RTZ", OpenCL_std, 343 },
    { "CONVERT_UCHAR", OpenCL_std, 344 },
    { "CONVERT_UCHAR16", OpenCL_std, 345 },
    { "CONVERT_UCHAR16_RTE", OpenCL_std, 346 },
    { "CONVERT_UCHAR16_RTN", OpenCL_std, 347 },
    { "CONVERT_UCHAR16_RTP", OpenCL_std, 348 },
    { "CONVERT_UCHAR16_RTZ", OpenCL_std, 349 },
    { "CONVERT_UCHAR16_SAT", OpenCL_std, 350 },
    { "CONVERT_UCHAR16_SAT_RTE", OpenCL_std, 351 },
    { "CONVERT_UCHAR16_SAT_RTN", OpenCL_std, 352 },
    { "CONVERT_UCHAR16_SAT_RTP", OpenCL_std, 353 },
    { "CONVERT_UCHAR16_SAT_RTZ", OpenCL_std, 354 },
    { "CONVERT_UCHAR2", OpenCL_std, 355 },
    { "CONVERT_UCHAR2_RTE", OpenCL_std, 356 },
    { "CONVERT_UCHAR2_RTN", OpenCL_std, 357 },
    { "CONVERT_UCHAR2_RTP", OpenCL_std, 358 },
    { "CONVERT_UCHAR2_RTZ", OpenCL_std, 359 },
    { "CONVERT_UCHAR2_SAT", OpenCL_std, 360 },
    { "CONVERT_UCHAR2_SAT_RTE", OpenCL_std, 361 },
    { "CONVERT_UCHAR2_SAT_RTN", OpenCL_std, 362 },
    { "CONVERT_UCHAR2_SAT_RTP", OpenCL_std, 363 },
    { "CONVERT_UCHAR2_SAT_RTZ", OpenCL_std, 364 },
    { "CONVERT_UCHAR3", OpenCL_std, 365 },
    { "CONVERT_UCHAR3_RTE", OpenCL_std, 366 },
    { "CONVERT_UCHAR3_RTN", OpenCL_std, 367 },
    { "CONVERT_UCHAR3_RTP", OpenCL_std, 368 },
    { "CONVERT_UCHAR3_RTZ", OpenCL_std, 369 },
    { "CONVERT_UCHAR3_SAT", OpenCL_std, 370 },
    { "CONVERT_UCHAR3_SAT_RTE", OpenCL_std, 371 },
    { "CONVERT_UCHAR3_SAT_RTN", OpenCL_std, 372 },
    { "CONVERT_UCHAR3_SAT_RTP", OpenCL_std, 373 },
    { "CONVERT_UCHAR3_SAT_RTZ", OpenCL_std, 374 },
    { "CONVERT_UCHAR4", OpenCL_std, 375 },
    { "CONVERT_UCHAR4_RTE", OpenCL_std, 376 },
    { "CONVERT_UCHAR4_RTN", OpenCL_std, 377 },
    { "CONVERT_UCHAR4_RTP", OpenCL_std, 378 },
    { "CONVERT_UCHAR4_RTZ", OpenCL_std, 379 },
    { "CONVERT_UCHAR4_SAT", OpenCL_std, 380 },
    { "CONVERT_UCHAR4_SAT_RTE", OpenCL_std, 381 },
    { "CONVERT_UCHAR4_SAT_RTN", OpenCL_std, 382 },
    { "CONVERT_UCHAR4_SAT_RTP", OpenCL_std, 383 },
    { "CONVERT_UCHAR4_SAT_RTZ", OpenCL_std, 384 },
    { "CONVERT_UCHAR8", OpenCL_std, 385 },
    { "CONVERT_UCHAR8_RTE", OpenCL_std, 386 },
    { "CONVERT_UCHAR8_RTN", OpenCL_std, 387 },
    { "CONVERT_UCHAR8_RTP", OpenCL_std, 388 },
    { "CONVERT_UCHAR8_RTZ", OpenCL_std, 389 },
    { "CONVERT_UCHAR8_SAT", OpenCL_std, 390 },
    { "CONVERT_UCHAR8_SAT_RTE", OpenCL_std, 391 },
    { "CONVERT_UCHAR8_SAT_RTN", OpenCL_std, 392 },
    { "CONVERT_UCHAR8_SAT_RTP", OpenCL_std, 393 },
    { "CONVERT_UCHAR8_SAT_RTZ", OpenCL_std, 394 },
    { "CONVERT_UCHAR_RTE", OpenCL_std, 395 },
    { "CONVERT_UCHAR_RTN", OpenCL_std, 396 },
    { "CONVERT_UCHAR_RTP", OpenCL_std, 397 },
    { "CONVERT_UCHAR_RTZ", OpenCL_std, 398 },
    { "CONVERT_UCHAR_SAT", OpenCL_std, 399 },
    { "CONVERT_UCHAR_SAT_RTE", OpenCL_std, 400 },
    { "CONVERT_UCHAR_SAT_RTN", OpenCL_std, 401 },
    { "CONVERT_UCHAR_SAT_RTP", OpenCL_std, 402 },
    { "CONVERT_UCHAR_SAT_RTZ", OpenCL_std, 403 },
    { "CONVERT_UINT", OpenCL_std, 404 },
    { "CONVERT_UINT16", OpenCL_std, 405 },
    { "CONVERT_UINT16_RTE", OpenCL_std, 406 },
    { "CONVERT_UINT16_RTN", OpenCL_std, 407 },
    { "CONVERT_UINT16_RTP", OpenCL_std, 408 },
    { "CONVERT_UINT16_RTZ", OpenCL_std, 409 },
    { "CONVERT_UINT16_SAT", OpenCL_std, 410 },
    { "CONVERT_UINT16_SAT_RTE", OpenCL_std, 411 },
    { "CONVERT_UINT16_SAT_RTN", OpenCL_std, 412 },
    { "CONVERT_UINT16_SAT_RTP", OpenCL_std, 413 },
    { "CONVERT_UINT16_SAT_RTZ", OpenCL_std, 414 },
    { "CONVERT_UINT2", OpenCL_std, 415 },
    { "CONVERT_UINT2_RTE", OpenCL_std, 416 },
    { "CONVERT_UINT2_RTN", OpenCL_std, 417 },
    { "CONVERT_UINT2_RTP", OpenCL_std, 418 },
    { "CONVERT_UINT2_RTZ", OpenCL_std, 419 },
    { "CONVERT_UINT2_SAT", OpenCL_std, 420 },
    { "CONVERT_UINT2_SAT_RTE", OpenCL_std, 421 },
    { "CONVERT_UINT2_SAT_RTN", OpenCL_std, 422 },
    { "CONVERT_UINT2_SAT_RTP", OpenCL_std, 423 },
    { "CONVERT_UINT2_SAT_RTZ", OpenCL_std, 424 },
    { "CONVERT_UINT3", OpenCL_std, 425 },
    { "CONVERT_UINT3_RTE", OpenCL_std, 426 },
    { "CONVERT_UINT3_RTN", OpenCL_std, 427 },
    { "CONVERT_UINT3_RTP", OpenCL_std, 428 },
    { "CONVERT_UINT3_RTZ", OpenCL_std, 429 },
    { "CONVERT_UINT3_SAT", OpenCL_std, 430 },
    { "CONVERT_UINT3_SAT_RTE", OpenCL_std, 431 },
    { "CONVERT_UINT3_SAT_RTN", OpenCL_std, 432 },
    { "CONVERT_UINT3_SAT_RTP", OpenCL_std, 433 },
    { "CONVERT_UINT3_SAT_RTZ", OpenCL_std, 434 },
    { "CONVERT_UINT4", OpenCL_std, 435 },
    { "CONVERT_UINT4_RTE", OpenCL_std, 436 },
    { "CONVERT_UINT4_RTN", OpenCL_std, 437 },
    { "CONVERT_UINT4_RTP", OpenCL_std, 438 },
    { "CONVERT_UINT4_RTZ", OpenCL_std, 439 },
    { "CONVERT_UINT4_SAT", OpenCL_std, 440 },
    { "CONVERT_UINT4_SAT_RTE", OpenCL_std, 441 },
    { "CONVERT_UINT4_SAT_RTN", OpenCL_std, 442 },
    { "CONVERT_UINT4_SAT_RTP", OpenCL_std, 443 },
    { "CONVERT_UINT4_SAT_RTZ", OpenCL_std, 444 },
    { "CONVERT_UINT8", OpenCL_std, 445 },
    { "CONVERT_UINT8_RTE", OpenCL_std, 446 },
    { "CONVERT_UINT8_RTN", OpenCL_std, 447 },
    { "CONVERT_UINT8_RTP", OpenCL_std, 448 },
    { "CONVERT_UINT8_RTZ", OpenCL_std, 449 },
    { "CONVERT_UINT8_SAT", OpenCL_std, 450 },
    { "CONVERT_UINT8_SAT_RTE", OpenCL_std, 451 },
    { "CONVERT_UINT8_SAT_RTN", OpenCL_std, 452 },
    { "CONVERT_UINT8_SAT_RTP", OpenCL_std, 453 },
    { "CONVERT_UINT8_SAT_RTZ", OpenCL_std, 454 },
    { "CONVERT_UINT_RTE", OpenCL_std, 455 },
    { "CONVERT_UINT_RTN", OpenCL_std, 456 },
    { "CONVERT_UINT_RTP", OpenCL_std, 457 },
    { "CONVERT_UINT_RTZ", OpenCL_std, 458 },
    { "CONVERT_UINT_SAT", OpenCL_std, 459 },
    { "CONVERT_UINT_SAT_RTE", OpenCL_std, 460 },
    { "CONVERT_UINT_SAT_RTN", OpenCL_std, 461 },
    { "CONVERT_UINT_SAT_RTP", OpenCL_std, 462 },
    { "CONVERT_UINT_SAT_RTZ", OpenCL_std, 463 },
    { "CONVERT_ULONG", OpenCL_std, 464 },
    { "CONVERT_ULONG16", OpenCL_std, 465 },
    { "CONVERT_ULONG16_RTE", OpenCL_std, 466 },
    { "CONVERT_ULONG16_RTN", OpenCL_std, 467 },
    { "CONVERT_ULONG16_RTP", OpenCL_std, 468 },
    { "CONVERT_ULONG16_RTZ", OpenCL_std, 469 },
    { "CONVERT_ULONG16_SAT", OpenCL_std, 470 },
    { "CONVERT_ULONG16_SAT_RTE", OpenCL_std, 471 },
    { "CONVERT_ULONG16_SAT_RTN", OpenCL_std, 472 },
    { "CONVERT_ULONG16_SAT_RTP", OpenCL_std, 473 },
    { "CONVERT_ULONG16_SAT_RTZ", OpenCL_std, 474 },
    { "CONVERT_ULONG2", OpenCL_std, 475 },
    { "CONVERT_ULONG2_RTE", OpenCL_std, 476 },
    { "CONVERT_ULONG2_RTN", OpenCL_std, 477 },
    { "CONVERT_ULONG2_RTP", OpenCL_std, 478 },
    { "CONVERT_ULONG2_RTZ", OpenCL_std, 479 },
    { "CONVERT_ULONG2_SAT", OpenCL_std, 480 },
    { "CONVERT_ULONG2_SAT_RTE", OpenCL_std, 481 },
    { "CONVERT_ULONG2_SAT_RTN", OpenCL_std, 482 },
    { "CONVERT_ULONG2_SAT_RTP", OpenCL_std, 483 },
    { "CONVERT_ULONG2_SAT_RTZ", OpenCL_std, 484 },
    { "CONVERT_ULONG3", OpenCL_std, 485 },
    { "CONVERT_ULONG3_RTE", OpenCL_std, 486 },
    { "CONVERT_ULONG3_RTN", OpenCL_std, 487 },
    { "CONVERT_ULONG3_RTP", OpenCL_std, 488 },
    { "CONVERT_ULONG3_RTZ", OpenCL_std, 489 },
    { "CONVERT_ULONG3_SAT", OpenCL_std, 490 },
    { "CONVERT_ULONG3_SAT_RTE", OpenCL_std, 491 },
    { "CONVERT_ULONG3_SAT_RTN", OpenCL_std, 492 },
    { "CONVERT_ULONG3_SAT_RTP", OpenCL_std, 493 },
    { "CONVERT_ULONG3_SAT_RTZ", OpenCL_std, 494 },
    { "CONVERT_ULONG4", OpenCL_std, 495 },
    { "CONVERT_ULONG4_RTE", OpenCL_std, 496 },
    { "CONVERT_ULONG4_RTN", OpenCL_std, 497 },
    { "CONVERT_ULONG4_RTP", OpenCL_std, 498 },
    { "CONVERT_ULONG4_RTZ", OpenCL_std, 499 },
    { "CONVERT_ULONG4_SAT", OpenCL_std, 500 },
    { "CONVERT_ULONG4_SAT_RTE", OpenCL_std, 501 },
    { "CONVERT_ULONG4_SAT_RTN", OpenCL_std, 502 },
    { "CONVERT_ULONG4_SAT_RTP", OpenCL_std, 503 },
    { "CONVERT_ULONG4_SAT_RTZ", OpenCL_std, 504 },
    { "CONVERT_ULONG8", OpenCL_std, 505 },
    { "CONVERT_ULONG8_RTE", OpenCL_std, 506 },
    { "CONVERT_ULONG8_RTN", OpenCL_std, 507 },
    { "CONVERT_ULONG8_RTP", OpenCL_std, 508 },
    { "CONVERT_ULONG8_RTZ", OpenCL_std, 509 },
    { "CONVERT_ULONG8_SAT", OpenCL_std, 510 },
    { "CONVERT_ULONG8_SAT_RTE", OpenCL_std, 511 },
    { "CONVERT_ULONG8_SAT_RTN", OpenCL_std, 512 },
    { "CONVERT_ULONG8_SAT_RTP", OpenCL_std, 513 },
    { "CONVERT_ULONG8_SAT_RTZ", OpenCL_std, 514 },
    { "CONVERT_ULONG_RTE", OpenCL_std, 515 },
    { "CONVERT_ULONG_RTN", OpenCL_std, 516 },
    { "CONVERT_ULONG_RTP", OpenCL_std, 517 },
    { "CONVERT_ULONG_RTZ", OpenCL_std, 518 },
    { "CONVERT_ULONG_SAT", OpenCL_std, 519 },
    { "CONVERT_ULONG_SAT_RTE", OpenCL_std, 520 },
    { "CONVERT_ULONG_SAT_RTN", OpenCL_std, 521 },
    { "CONVERT_ULONG_SAT_RTP", OpenCL_std, 522 },
    { "CONVERT_ULONG_SAT_RTZ", OpenCL_std, 523 },
    { "CONVERT_USHORT", OpenCL_std, 524 },
    { "CONVERT_USHORT16", OpenCL_std, 525 },
    { "CONVERT_USHORT16_RTE", OpenCL_std, 526 },
    { "CONVERT_USHORT16_RTN", OpenCL_std, 527 },
    { "CONVERT_USHORT16_RTP", OpenCL_std, 528 },
    { "CONVERT_USHORT16_RTZ", OpenCL_std, 529 },
    { "CONVERT_USHORT16_SAT", OpenCL_std, 530 },
    { "CONVERT_USHORT16_SAT_RTE", OpenCL_std, 531 },
    { "CONVERT_USHORT16_SAT_RTN", OpenCL_std, 532 },
    { "CONVERT_USHORT16_SAT_RTP", OpenCL_std, 533 },
    { "CONVERT_USHORT16_SAT_RTZ", OpenCL_std, 534 },
    { "CONVERT_USHORT2", OpenCL_std, 535 },
    { "CONVERT_USHORT2_RTE", OpenCL_std, 536 },
    { "CONVERT_USHORT2_RTN", OpenCL_std, 537 },
    { "CONVERT_USHORT2_RTP", OpenCL_std, 538 },
    { "CONVERT_USHORT2_RTZ", OpenCL_std, 539 },
    { "CONVERT_USHORT2_SAT", OpenCL_std, 540 },
    { "CONVERT_USHORT2_SAT_RTE", OpenCL_std, 541 },
    { "CONVERT_USHORT2_SAT_RTN", OpenCL_std, 542 },
    { "CONVERT_USHORT2_SAT_RTP", OpenCL_std, 543 },
    { "CONVERT_USHORT2_SAT_RTZ", OpenCL_std, 544 },
    { "CONVERT_USHORT3", OpenCL_std, 545 },
    { "CONVERT_USHORT3_RTE", OpenCL_std, 546 },
    { "CONVERT_USHORT3_RTN", OpenCL_std, 547 },
    { "CONVERT_USHORT3_RTP", OpenCL_std, 548 },
    { "CONVERT_USHORT3_RTZ", OpenCL_std, 549 },
    { "CONVERT_USHORT3_SAT", OpenCL_std, 550 },
    { "CONVERT_USHORT3_SAT_RTE", OpenCL_std, 551 },
    { "CONVERT_USHORT3_SAT_RTN", OpenCL_std, 552 },
    { "CONVERT_USHORT3_SAT_RTP", OpenCL_std, 553 },
    { "CONVERT_USHORT3_SAT_RTZ", OpenCL_std, 554 },
    { "CONVERT_USHORT4", OpenCL_std, 555 },
    { "CONVERT_USHORT4_RTE", OpenCL_std, 556 },
    { "CONVERT_USHORT4_RTN", OpenCL_std, 557 },
    { "CONVERT_USHORT4_RTP", OpenCL_std, 558 },
    { "CONVERT_USHORT4_RTZ", OpenCL_std, 559 },
    { "CONVERT_USHORT4_SAT", OpenCL_std, 560 },
    { "CONVERT_USHORT4_SAT_RTE", OpenCL_std, 561 },
    { "CONVERT_USHORT4_SAT_RTN", OpenCL_std, 562 },
    { "CONVERT_USHORT4_SAT_RTP", OpenCL_std, 563 },
    { "CONVERT_USHORT4_SAT_RTZ", OpenCL_std, 564 },
    { "CONVERT_USHORT8", OpenCL_std, 565 },
    { "CONVERT_USHORT8_RTE", OpenCL_std, 566 },
    { "CONVERT_USHORT8_RTN", OpenCL_std, 567 },
    { "CONVERT_USHORT8_RTP", OpenCL_std, 568 },
    { "CONVERT_USHORT8_RTZ", OpenCL_std, 569 },
    { "CONVERT_USHORT8_SAT", OpenCL_std, 570 },
    { "CONVERT_USHORT8_SAT_RTE", OpenCL_std, 571 },
    { "CONVERT_USHORT8_SAT_RTN", OpenCL_std, 572 },
    { "CONVERT_USHORT8_SAT_RTP", OpenCL_std, 573 },
    { "CONVERT_USHORT8_SAT_RTZ", OpenCL_std, 574 },
    { "CONVERT_USHORT_RTE", OpenCL_std, 575 },
    { "CONVERT_USHORT_RTN", OpenCL_std, 576 },
    { "CONVERT_USHORT_RTP", OpenCL_std, 577 },
    { "CONVERT_USHORT_RTZ", OpenCL_std, 578 },
    { "CONVERT_USHORT_SAT", OpenCL_std, 579 },
    { "CONVERT_USHORT_SAT_RTE", OpenCL_std, 580 },
    { "CONVERT_USHORT_SAT_RTN", OpenCL_std, 581 },
    { "CONVERT_USHORT_SAT_RTP", OpenCL_std, 582 },
    { "CONVERT_USHORT_SAT_RTZ", OpenCL_std, 583 },
    { "COPYSIGN", OpenCL_std, 584 },
    { "COS", OpenCL_std, 585 },
    { "COS", GLSL_std_450, 586 },
    { "COSH", OpenCL_std, 587 },
    { "COSH", GLSL_std_450, 588 },
    { "COSPI", OpenCL_std, 589 },
    { "CREATE_USER_EVENT", OpenCL_std, 590 },
    { "CROSS", OpenCL_std, 591 },
    { "CROSS", GLSL_std_450, 592 },
    { "CTZ", OpenCL_std, 593 },
    { "DEBUGBUILDIDENTIFIER", NonSemantic_Shader_DebugInfo_100, 594 },
    { "DEBUGCOMPILATIONUNIT", NonSemantic_Shader_DebugInfo_100, 595 },
    { "DEBUGDECLARE", NonSemantic_Shader_DebugInfo_100, 596 },
    { "DEBUGENTRYPOINT", NonSemantic_Shader_DebugInfo_100, 597 },
    { "DEBUGEXPRESSION", NonSemantic_Shader_DebugInfo_100, 598 },
    { "DEBUGFUNCTION", NonSemantic_Shader_DebugInfo_100, 599 },
    { "DEBUGFUNCTIONDECLARATION", NonSemantic_Shader_DebugInfo_100, 600 },
    { "DEBUGFUNCTIONDEFINITION", NonSemantic_Shader_DebugInfo_100, 601 },
    { "DEBUGGLOBALVARIABLE", NonSemantic_Shader_DebugInfo_100, 602 },
    { "DEBUGIMPORTEDENTITY", NonSemantic_Shader_DebugInfo_100, 603 },
    { "DEBUGINFONONE", NonSemantic_Shader_DebugInfo_100, 604 },
    { "DEBUGINLINEDAT", NonSemantic_Shader_DebugInfo_100, 605 },
    { "DEBUGINLINEDVARIABLE", NonSemantic_Shader_DebugInfo_100, 606 },
    { "DEBUGLEXICALBLOCK", NonSemantic_Shader_DebugInfo_100, 607 },
    { "DEBUGLEXICALBLOCKDISCRIMINATOR", NonSemantic_Shader_DebugInfo_100, 608 },
    { "DEBUGLINE", NonSemantic_Shader_DebugInfo_100, 609 },
    { "DEBUGLOCALVARIABLE", NonSemantic_Shader_DebugInfo_100, 610 },
    { "DEBUGMACRODEF", NonSemantic_Shader_DebugInfo_100, 611 },
    { "DEBUGMACROUNDEF", NonSemantic_Shader_DebugInfo_100, 612 },
    { "DEBUGNOLINE", NonSemantic_Shader_DebugInfo_100, 613 },
    { "DEBUGNOSCOPE", NonSemantic_Shader_DebugInfo_100, 614 },
    { "DEBUGOPERATION", NonSemantic_Shader_DebugInfo_100, 615 },
    { "DEBUGSCOPE", NonSemantic_Shader_DebugInfo_100, 616 },
    { "DEBUGSOURCE", NonSemantic_Shader_DebugInfo_100, 617 },
    { "DEBUGSOURCECONTINUED", NonSemantic_Shader_DebugInfo_100, 618 },
    { "DEBUGSTORAGEPATH", NonSemantic_Shader_DebugInfo_100, 619 },
    { "DEBUGTYPEARRAY", NonSemantic_Shader_DebugInfo_100, 620 },
    { "DEBUGTYPEBASIC", NonSemantic_Shader_DebugInfo_100, 621 },
    { "DEBUGTYPECOMPOSITE", NonSemantic_Shader_DebugInfo_100, 622 },
    { "DEBUGTYPEDEF", NonSemantic_Shader_DebugInfo_100, 623 },
    { "DEBUGTYPEENUM", NonSemantic_Shader_DebugInfo_100, 624 },
    { "DEBUGTYPEFUNCTION", NonSemantic_Shader_DebugInfo_100, 625 },
    { "DEBUGTYPEINHERITANCE", NonSemantic_Shader_DebugInfo_100, 626 },
    { "DEBUGTYPEMATRIX", NonSemantic_Shader_DebugInfo_100, 627 },
    { "DEBUGTYPEMEMBER", NonSemantic_Shader_DebugInfo_100, 628 },
    { "DEBUGTYPEPOINTER", NonSemantic_Shader_DebugInfo_100, 629 },
    { "DEBUGTYPEPTRTOMEMBER", NonSemantic_Shader_DebugInfo_100, 630 },
    { "DEBUGTYPEQUALIFIER", NonSemantic_Shader_DebugInfo_100, 631 },
    { "DEBUGTYPETEMPLATE", NonSemantic_Shader_DebugInfo_100, 632 },
    { "DEBUGTYPETEMPLATEPARAMETER", NonSemantic_Shader_DebugInfo_100, 633 },
    { "DEBUGTYPETEMPLATEPARAMETERPACK", NonSemantic_Shader_DebugInfo_100, 634 },
    { "DEBUGTYPETEMPLATETEMPLATEPARAMETER", NonSemantic_Shader_DebugInfo_100, 635 },
    { "DEBUGTYPEVECTOR", NonSemantic_Shader_DebugInfo_100, 636 },
    { "DEBUGVALUE", NonSemantic_Shader_DebugInfo_100, 637 },
    { "DEGREES", OpenCL_std, 638 },
    { "DEGREES", GLSL_std_450, 639 },
    { "DETERMINANT", GLSL_std_450, 640 },
    { "DISTANCE", OpenCL_std, 641 },
    { "DISTANCE", GLSL_std_450, 642 },
    { "DOT", OpenCL_std, 643 },
    { "ERF", OpenCL_std, 644 },
    { "ERFC", OpenCL_std, 645 },
    { "EXP", OpenCL_std, 646 },
    { "EXP", GLSL_std_450, 647 },
    { "EXP10", OpenCL_std, 648 },
    { "EXP2", OpenCL_std, 649 },
    { "EXP2", GLSL_std_450, 650 },
    { "EXPM1", OpenCL_std, 651 },
    { "FABS", OpenCL_std, 652 },
    { "FABS", GLSL_std_450, 653 },
    { "FACEFORWARD", GLSL_std_450, 654 },
    { "FAST_DISTANCE", OpenCL_std, 655 },
    { "FAST_LENGTH", OpenCL_std, 656 },
    { "FAST_NORMALIZE", OpenCL_std, 657 },
    { "FCLAMP", OpenCL_std, 658 },
    { "FCLAMP", GLSL_std_450, 659 },
    { "FDIM", OpenCL_std, 660 },
    { "FINDILSB", GLSL_std_450, 661 },
    { "FINDSMSB", GLSL_std_450, 662 },
    { "FINDUMSB", GLSL_std_450, 663 },
    { "FLOOR", OpenCL_std, 664 },
    { "FLOOR", GLSL_std_450, 665 },
    { "FMA", OpenCL_std, 666 },
    { "FMA", GLSL_std_450, 667 },
    { "FMAX", OpenCL_std, 668 },
    { "FMAX", GLSL_std_450, 669 },
    { "FMAX_COMMON", OpenCL_std, 670 },
    { "FMIN", OpenCL_std, 671 },
    { "FMIN", GLSL_std_450, 672 },
    { "FMIN_COMMON", OpenCL_std, 673 },
    { "FMIX", GLSL_std_450, 674 },
    { "FMOD", OpenCL_std, 675 },
    { "FRACT", OpenCL_std, 676 },
    { "FRACT", GLSL_std_450, 677 },
    { "FREXP", OpenCL_std, 678 },
    { "FREXP", GLSL_std_450, 679 },
    { "FREXPSTRUCT", GLSL_std_450, 680 },
    { "FSIGN", GLSL_std_450, 681 },
    { "GET_DEFAULT_QUEUE", OpenCL_std, 682 },
    { "GET_ENQUEUED_LOCAL_SIZE", OpenCL_std, 683 },
    { "GET_GLOBAL_ID", OpenCL_std, 684 },
    { "GET_GLOBAL_SIZE", OpenCL_std, 685 },
    { "GET_GROUP_ID", OpenCL_std, 686 },
    { "GET_IMAGE_ARRAY_SIZE", OpenCL_std, 687 },
    { "GET_IMAGE_DEPTH", OpenCL_std, 688 },
    { "GET_IMAGE_DIM", OpenCL_std, 689 },
    { "GET_IMAGE_HEIGHT", OpenCL_std, 690 },
    { "GET_IMAGE_NUM_MIP_LEVELS", OpenCL_std, 691 },
    { "GET_IMAGE_NUM_SAMPLES", OpenCL_std, 692 },
    { "GET_IMAGE_WIDTH", OpenCL_std, 693 },
    { "GET_LOCAL_ID", OpenCL_std, 694 },
    { "GET_LOCAL_SIZE", OpenCL_std, 695 },
    { "GET_NUM_GROUPS", OpenCL_std, 696 },
    { "GET_SUB_GROUP_EQ_MASK", OpenCL_std, 697 },
    { "GET_SUB_GROUP_GE_MASK", OpenCL_std, 698 },
    { "GET_SUB_GROUP_GT_MASK", OpenCL_std, 699 },
    { "GET_SUB_GROUP_LE_MASK", OpenCL_std, 700 },
    { "GET_SUB_GROUP_LT_MASK", OpenCL_std, 701 },
    { "HALF_COS", OpenCL_std, 702 },
    { "HALF_DIVIDE", OpenCL_std, 703 },
    { "HALF_EXP", OpenCL_std, 704 },
    { "HALF_EXP10", OpenCL_std, 705 },
    { "HALF_EXP2", OpenCL_std, 706 },
    { "HALF_LOG", OpenCL_std, 707 },
    { "HALF_LOG10", OpenCL_std, 708 },
    { "HALF_LOG2", OpenCL_std, 709 },
    { "HALF_POWR", OpenCL_std, 710 },
    { "HALF_RECIP", OpenCL_std, 711 },
    { "HALF_RSQRT", OpenCL_std, 712 },
    { "HALF_SIN", OpenCL_std, 713 },
    { "HALF_SQRT", OpenCL_std, 714 },
    { "HALF_TAN", OpenCL_std, 715 },
    { "HYPOT", OpenCL_std, 716 },
    { "ILOGB", OpenCL_std, 717 },
    { "INTEL_CONVERT_AS_BFLOAT1616_FLOAT16", OpenCL_std, 718 },
    { "INTEL_CONVERT_AS_BFLOAT162_FLOAT2", OpenCL_std, 719 },
    { "INTEL_CONVERT_AS_BFLOAT163_FLOAT3", OpenCL_std, 720 },
    { "INTEL_CONVERT_AS_BFLOAT164_FLOAT4", OpenCL_std, 721 },
    { "INTEL_CONVERT_AS_BFLOAT168_FLOAT8", OpenCL_std, 722 },
    { "INTEL_CONVERT_AS_BFLOAT16_FLOAT", OpenCL_std, 723 },
    { "INTEL_CONVERT_BFLOAT1616_AS_USHORT16", OpenCL_std, 724 },
    { "INTEL_CONVERT_BFLOAT162_AS_USHORT2", OpenCL_std, 725 },
    { "INTEL_CONVERT_BFLOAT163_AS_USHORT3", OpenCL_std, 726 },
    { "INTEL_CONVERT_BFLOAT164_AS_USHORT4", OpenCL_std, 727 },
    { "INTEL_CONVERT_BFLOAT168_AS_USHORT8", OpenCL_std, 728 },
    { "INTEL_CONVERT_BFLOAT16_AS_USHORT", OpenCL_std, 729 },
    { "INTEL_SUB_GROUP_BLOCK_READ", OpenCL_std, 730 },
    { "INTEL_SUB_GROUP_BLOCK_READ2", OpenCL_std, 731 },
    { "INTEL_SUB_GROUP_BLOCK_READ4", OpenCL_std, 732 },
    { "INTEL_SUB_GROUP_BLOCK_READ8", OpenCL_std, 733 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC", OpenCL_std, 734 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC16", OpenCL_std, 735 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC2", OpenCL_std, 736 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC4", OpenCL_std, 737 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC8", OpenCL_std, 738 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI", OpenCL_std, 739 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI2", OpenCL_std, 740 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI4", OpenCL_std, 741 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI8", OpenCL_std, 742 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL", OpenCL_std, 743 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL16", OpenCL_std, 744 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL2", OpenCL_std, 745 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL4", OpenCL_std, 746 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL8", OpenCL_std, 747 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US", OpenCL_std, 748 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US16", OpenCL_std, 749 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US2", OpenCL_std, 750 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US4", OpenCL_std, 751 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US8", OpenCL_std, 752 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE", OpenCL_std, 753 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE2", OpenCL_std, 754 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE4", OpenCL_std, 755 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE8", OpenCL_std, 756 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC", OpenCL_std, 757 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC16", OpenCL_std, 758 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC2", OpenCL_std, 759 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC4", OpenCL_std, 760 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC8", OpenCL_std, 761 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI", OpenCL_std, 762 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI2", OpenCL_std, 763 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI4", OpenCL_std, 764 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI8", OpenCL_std, 765 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL", OpenCL_std, 766 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL16", OpenCL_std, 767 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL2", OpenCL_std, 768 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL4", OpenCL_std, 769 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL8", OpenCL_std, 770 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US", OpenCL_std, 771 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US16", OpenCL_std, 772 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US2", OpenCL_std, 773 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US4", OpenCL_std, 774 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US8", OpenCL_std, 775 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ", OpenCL_std, 776 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ2", OpenCL_std, 777 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ4", OpenCL_std, 778 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ8", OpenCL_std, 779 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC", OpenCL_std, 780 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC16", OpenCL_std, 781 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC2", OpenCL_std, 782 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC4", OpenCL_std, 783 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC8", OpenCL_std, 784 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI", OpenCL_std, 785 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI2", OpenCL_std, 786 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI4", OpenCL_std, 787 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI8", OpenCL_std, 788 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL", OpenCL_std, 789 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL16", OpenCL_std, 790 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL2", OpenCL_std, 791 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL4", OpenCL_std, 792 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL8", OpenCL_std, 793 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US", OpenCL_std, 794 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US16", OpenCL_std, 795 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US2", OpenCL_std, 796 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US4", OpenCL_std, 797 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US8", OpenCL_std, 798 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE", OpenCL_std, 799 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE2", OpenCL_std, 800 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE4", OpenCL_std, 801 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE8", OpenCL_std, 802 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC", OpenCL_std, 803 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC16", OpenCL_std, 804 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC2", OpenCL_std, 805 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC4", OpenCL_std, 806 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC8", OpenCL_std, 807 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI", OpenCL_std, 808 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI2", OpenCL_std, 809 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI4", OpenCL_std, 810 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI8", OpenCL_std, 811 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL", OpenCL_std, 812 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL16", OpenCL_std, 813 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL2", OpenCL_std, 814 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL4", OpenCL_std, 815 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL8", OpenCL_std, 816 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US", OpenCL_std, 817 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US16", OpenCL_std, 818 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US2", OpenCL_std, 819 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US4", OpenCL_std, 820 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US8", OpenCL_std, 821 },
    { "INTEL_SUB_GROUP_SHUFFLE", OpenCL_std, 822 },
    { "INTEL_SUB_GROUP_SHUFFLE_DOWN", OpenCL_std, 823 },
    { "INTEL_SUB_GROUP_SHUFFLE_UP", OpenCL_std, 824 },
    { "INTEL_SUB_GROUP_SHUFFLE_XOR", OpenCL_std, 825 },
    { "INTEL_WORK_GROUP_BARRIER_ARRIVE", OpenCL_std, 826 },
    { "INTEL_WORK_GROUP_BARRIER_WAIT", OpenCL_std, 827 },
    { "INTERPOLATEATCENTROID", GLSL_std_450, 828 },
    { "INTERPOLATEATOFFSET", GLSL_std_450, 829 },
    { "INTERPOLATEATSAMPLE", GLSL_std_450, 830 },
    { "INVERSESQRT", GLSL_std_450, 831 },
    { "ISEQUAL", OpenCL_std, 832 },
    { "ISFINITE", OpenCL_std, 833 },
    { "ISGREATER", OpenCL_std, 834 },
    { "ISGREATEREQUAL", OpenCL_std, 835 },
    { "ISINF", OpenCL_std, 836 },
    { "ISLESS", OpenCL_std, 837 },
    { "ISLESSEQUAL", OpenCL_std, 838 },
    { "ISLESSGREATER", OpenCL_std, 839 },
    { "ISNAN", OpenCL_std, 840 },
    { "ISNORMAL", OpenCL_std, 841 },
    { "ISNOTEQUAL", OpenCL_std, 842 },
    { "ISORDERED", OpenCL_std, 843 },
    { "ISUNORDERED", OpenCL_std, 844 },
    { "IS_VALID_EVENT", OpenCL_std, 845 },
    { "LDEXP", OpenCL_std, 846 },
    { "LDEXP", GLSL_std_450, 847 },
    { "LENGTH", OpenCL_std, 848 },
    { "LENGTH", GLSL_std_450, 849 },
    { "LGAMMA", OpenCL_std, 850 },
    { "LGAMMA_R", OpenCL_std, 851 },
    { "LOG", OpenCL_std, 852 },
    { "LOG", GLSL_std_450, 853 },
    { "LOG10", OpenCL_std, 854 },
    { "LOG1P", OpenCL_std, 855 },
    { "LOG2", OpenCL_std, 856 },
    { "LOG2", GLSL_std_450, 857 },
    { "LOGB", OpenCL_std, 858 },
    { "MAD", OpenCL_std, 859 },
    { "MATRIXINVERSE", GLSL_std_450, 860 },
    { "MAXMAG", OpenCL_std, 861 },
    { "MINMAG", OpenCL_std, 862 },
    { "MIX", OpenCL_std, 863 },
    { "MODF", OpenCL_std, 864 },
    { "MODF", GLSL_std_450, 865 },
    { "MODFSTRUCT", GLSL_std_450, 866 },
    { "NAN", OpenCL_std, 867 },
    { "NATIVE_COS", OpenCL_std, 868 },
    { "NATIVE_DIVIDE", OpenCL_std, 869 },
    { "NATIVE_EXP", OpenCL_std, 870 },
    { "NATIVE_EXP10", OpenCL_std, 871 },
    { "NATIVE_EXP2", OpenCL_std, 872 },
    { "NATIVE_LOG", OpenCL_std, 873 },
    { "NATIVE_LOG10", OpenCL_std, 874 },
    { "NATIVE_LOG2", OpenCL_std, 875 },
    { "NATIVE_POWR", OpenCL_std, 876 },
    { "NATIVE_RECIP", OpenCL_std, 877 },
    { "NATIVE_RSQRT", OpenCL_std, 878 },
    { "NATIVE_SIN", OpenCL_std, 879 },
    { "NATIVE_SQRT", OpenCL_std, 880 },
    { "NATIVE_TAN", OpenCL_std, 881 },
    { "NCLAMP", GLSL_std_450, 882 },
    { "NDRANGE_1D", OpenCL_std, 883 },
    { "NDRANGE_2D", OpenCL_std, 884 },
    { "NDRANGE_3D", OpenCL_std, 885 },
    { "NEXTAFTER", OpenCL_std, 886 },
    { "NMAX", GLSL_std_450, 887 },
    { "NMIN", GLSL_std_450, 888 },
    { "NORMALIZE", OpenCL_std, 889 },
    { "NORMALIZE", GLSL_std_450, 890 },
    { "PACKDOUBLE2X32", GLSL_std_450, 891 },
    { "PACKHALF2X16", GLSL_std_450, 892 },
    { "PACKSNORM2X16", GLSL_std_450, 893 },
    { "PACKSNORM4X8", GLSL_std_450, 894 },
    { "PACKUNORM2X16", GLSL_std_450, 895 },
    { "PACKUNORM4X8", GLSL_std_450, 896 },
    { "POPCOUNT", OpenCL_std, 897 },
    { "POW", OpenCL_std, 898 },
    { "POW", GLSL_std_450, 899 },
    { "POWN", OpenCL_std, 900 },
    { "POWR", OpenCL_std, 901 },
    { "PREFETCH", OpenCL_std, 902 },
    { "PRINTF", OpenCL_std, 903 },
    { "RADIANS", OpenCL_std, 904 },
    { "RADIANS", GLSL_std_450, 905 },
    { "READ_IMAGEF", OpenCL_std, 906 },
    { "READ_IMAGEI", OpenCL_std, 907 },
    { "READ_IMAGEUI", OpenCL_std, 908 },
    { "REFLECT", GLSL_std_450, 909 },
    { "REFRACT", GLSL_std_450, 910 },
    { "RELEASE_EVENT", OpenCL_std, 911 },
    { "REMAINDER", OpenCL_std, 912 },
    { "REMQUO", OpenCL_std, 913 },
    { "RETAIN_EVENT", OpenCL_std, 914 },
    { "RINT", OpenCL_std, 915 },
    { "ROOTN", OpenCL_std, 916 },
    { "ROTATE", OpenCL_std, 917 },
    { "ROUND", OpenCL_std, 918 },
    { "ROUND", GLSL_std_450, 919 },
    { "ROUNDEVEN", GLSL_std_450, 920 },
    { "RSQRT", OpenCL_std, 921 },
    { "SABS", GLSL_std_450, 922 },
    { "SCLAMP", GLSL_std_450, 923 },
    { "SELECT", OpenCL_std, 924 },
    { "SET_USER_EVENT_STATUS", OpenCL_std, 925 },
    { "SHUFFLE", OpenCL_std, 926 },
    { "SHUFFLE2", OpenCL_std, 927 },
    { "SIGN", OpenCL_std, 928 },
    { "SIGNBIT", OpenCL_std, 929 },
    { "SIN", OpenCL_std, 930 },
    { "SIN", GLSL_std_450, 931 },
    { "SINCOS", OpenCL_std, 932 },
    { "SINH", OpenCL_std, 933 },
    { "SINH", GLSL_std_450, 934 },
    { "SINPI", OpenCL_std, 935 },
    { "SMAX", GLSL_std_450, 936 },
    { "SMIN", GLSL_std_450, 937 },
    { "SMOOTHSTEP", OpenCL_std, 938 },
    { "SMOOTHSTEP", GLSL_std_450, 939 },
    { "SQRT", OpenCL_std, 940 },
    { "SQRT", GLSL_std_450, 941 },
    { "SSIGN", GLSL_std_450, 942 },
    { "STEP", OpenCL_std, 943 },
    { "STEP", GLSL_std_450, 944 },
    { "SUB_GROUP_ALL", OpenCL_std, 945 },
    { "SUB_GROUP_ANY", OpenCL_std, 946 },
    { "SUB_GROUP_BALLOT", OpenCL_std, 947 },
    { "SUB_GROUP_BALLOT_BIT_COUNT", OpenCL_std, 948 },
    { "SUB_GROUP_BALLOT_BIT_EXTRACT", OpenCL_std, 949 },
    { "SUB_GROUP_BALLOT_EXCLUSIVE_SCAN", OpenCL_std, 950 },
    { "SUB_GROUP_BALLOT_FIND_LSB", OpenCL_std, 951 },
    { "SUB_GROUP_BALLOT_FIND_MSB", OpenCL_std, 952 },
    { "SUB_GROUP_BALLOT_INCLUSIVE_SCAN", OpenCL_std, 953 },
    { "SUB_GROUP_BROADCAST", OpenCL_std, 954 },
    { "SUB_GROUP_BROADCAST_FIRST", OpenCL_std, 955 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDD", OpenCL_std, 956 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDF", OpenCL_std, 957 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDH", OpenCL_std, 958 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDS", OpenCL_std, 959 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDU", OpenCL_std, 960 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ANDS", OpenCL_std, 961 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ANDU", OpenCL_std, 962 },
    { "SUB_GROUP_CLUSTERED_REDUCE_LOGICAL_AND", OpenCL_std, 963 },
    { "SUB_GROUP_CLUSTERED_REDUCE_LOGICAL_OR", OpenCL_std, 964 },
    { "SUB_GROUP_CLUSTERED_REDUCE_LOGICAL_XOR", OpenCL_std, 965 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXD", OpenCL_std, 966 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXF", OpenCL_std, 967 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXH", OpenCL_std, 968 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXS", OpenCL_std, 969 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXU", OpenCL_std, 970 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MIND", OpenCL_std, 971 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINF", OpenCL_std, 972 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINH", OpenCL_std, 973 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINS", OpenCL_std, 974 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINU", OpenCL_std, 975 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULD", OpenCL_std, 976 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULF", OpenCL_std, 977 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULH", OpenCL_std, 978 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULS", OpenCL_std, 979 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULU", OpenCL_std, 980 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ORS", OpenCL_std, 981 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ORU", OpenCL_std, 982 },
    { "SUB_GROUP_CLUSTERED_REDUCE_XORS", OpenCL_std, 983 },
    { "SUB_GROUP_CLUSTERED_REDUCE_XORU", OpenCL_std, 984 },
    { "SUB_GROUP_CLUSTERED_ROTATE", OpenCL_std, 985 },
    { "SUB_GROUP_ELECT", OpenCL_std, 986 },
    { "SUB_GROUP_FADD", OpenCL_std, 987 },
    { "SUB_GROUP_FMAX", OpenCL_std, 988 },
    { "SUB_GROUP_FMIN", OpenCL_std, 989 },
    { "SUB_GROUP_IADD", OpenCL_std, 990 },
    { "SUB_GROUP_INVERSE_BALLOT", OpenCL_std, 991 },
    { "SUB_GROUP_NON_UNIFORM_ALL", OpenCL_std, 992 },
    { "SUB_GROUP_NON_UNIFORM_ALL_EQUAL", OpenCL_std, 993 },
    { "SUB_GROUP_NON_UNIFORM_ANY", OpenCL_std, 994 },
    { "SUB_GROUP_NON_UNIFORM_BROADCAST", OpenCL_std, 995 },
    { "SUB_GROUP_NON_UNIFORM_FADD", OpenCL_std, 996 },
    { "SUB_GROUP_NON_UNIFORM_FMAX", OpenCL_std, 997 },
    { "SUB_GROUP_NON_UNIFORM_FMIN", OpenCL_std, 998 },
    { "SUB_GROUP_NON_UNIFORM_FMUL", OpenCL_std, 999 },
    { "SUB_GROUP_NON_UNIFORM_IADD", OpenCL_std, 1000 },
    { "SUB_GROUP_NON_UNIFORM_IAND", OpenCL_std, 1001 },
    { "SUB_GROUP_NON_UNIFORM_IMUL", OpenCL_std, 1002 },
    { "SUB_GROUP_NON_UNIFORM_IOR", OpenCL_std, 1003 },
    { "SUB_GROUP_NON_UNIFORM_IXOR", OpenCL_std, 1004 },
    { "SUB_GROUP_NON_UNIFORM_LOGICAL_IAND", OpenCL_std, 1005 },
    { "SUB_GROUP_NON_UNIFORM_LOGICAL_IOR", OpenCL_std, 1006 },
    { "SUB_GROUP_NON_UNIFORM_LOGICAL_IXOR", OpenCL_std, 1007 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDD", OpenCL_std, 1008 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDF", OpenCL_std, 1009 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDH", OpenCL_std, 1010 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDS", OpenCL_std, 1011 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDU", OpenCL_std, 1012 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ANDS", OpenCL_std, 1013 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ANDU", OpenCL_std, 1014 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ANDS", OpenCL_std, 1015 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ORS", OpenCL_std, 1016 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_LOGICAL_XORS", OpenCL_std, 1017 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXD", OpenCL_std, 1018 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXF", OpenCL_std, 1019 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXH", OpenCL_std, 1020 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXS", OpenCL_std, 1021 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXU", OpenCL_std, 1022 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MIND", OpenCL_std, 1023 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINF", OpenCL_std, 1024 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINH", OpenCL_std, 1025 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINS", OpenCL_std, 1026 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINU", OpenCL_std, 1027 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULD", OpenCL_std, 1028 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULF", OpenCL_std, 1029 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULH", OpenCL_std, 1030 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULS", OpenCL_std, 1031 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULU", OpenCL_std, 1032 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ORS", OpenCL_std, 1033 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ORU", OpenCL_std, 1034 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_XORS", OpenCL_std, 1035 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_XORU", OpenCL_std, 1036 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDD", OpenCL_std, 1037 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDF", OpenCL_std, 1038 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDH", OpenCL_std, 1039 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDS", OpenCL_std, 1040 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDU", OpenCL_std, 1041 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDS", OpenCL_std, 1042 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDU", OpenCL_std, 1043 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ANDS", OpenCL_std, 1044 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ORS", OpenCL_std, 1045 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_XORS", OpenCL_std, 1046 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXD", OpenCL_std, 1047 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXF", OpenCL_std, 1048 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXH", OpenCL_std, 1049 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXS", OpenCL_std, 1050 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXU", OpenCL_std, 1051 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MIND", OpenCL_std, 1052 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINF", OpenCL_std, 1053 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINH", OpenCL_std, 1054 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINS", OpenCL_std, 1055 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINU", OpenCL_std, 1056 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULD", OpenCL_std, 1057 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULF", OpenCL_std, 1058 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULH", OpenCL_std, 1059 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULS", OpenCL_std, 1060 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULU", OpenCL_std, 1061 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORS", OpenCL_std, 1062 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORU", OpenCL_std, 1063 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORS", OpenCL_std, 1064 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORU", OpenCL_std, 1065 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDD", OpenCL_std, 1066 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDF", OpenCL_std, 1067 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDH", OpenCL_std, 1068 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDS", OpenCL_std, 1069 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDU", OpenCL_std, 1070 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDS", OpenCL_std, 1071 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDU", OpenCL_std, 1072 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ANDS", OpenCL_std, 1073 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ORS", OpenCL_std, 1074 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_XORS", OpenCL_std, 1075 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXD", OpenCL_std, 1076 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXF", OpenCL_std, 1077 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXH", OpenCL_std, 1078 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXS", OpenCL_std, 1079 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXU", OpenCL_std, 1080 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MIND", OpenCL_std, 1081 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINF", OpenCL_std, 1082 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINH", OpenCL_std, 1083 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINS", OpenCL_std, 1084 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINU", OpenCL_std, 1085 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULD", OpenCL_std, 1086 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULF", OpenCL_std, 1087 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULH", OpenCL_std, 1088 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULS", OpenCL_std, 1089 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULU", OpenCL_std, 1090 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORS", OpenCL_std, 1091 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORU", OpenCL_std, 1092 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORS", OpenCL_std, 1093 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORU", OpenCL_std, 1094 },
    { "SUB_GROUP_NON_UNIFORM_SMAX", OpenCL_std, 1095 },
    { "SUB_GROUP_NON_UNIFORM_SMIN", OpenCL_std, 1096 },
    { "SUB_GROUP_NON_UNIFORM_UMAX", OpenCL_std, 1097 },
    { "SUB_GROUP_NON_UNIFORM_UMIN", OpenCL_std, 1098 },
    { "SUB_GROUP_REDUCE_ADDF", OpenCL_std, 1099 },
    { "SUB_GROUP_REDUCE_ADDS", OpenCL_std, 1100 },
    { "SUB_GROUP_REDUCE_ADDU", OpenCL_std, 1101 },
    { "SUB_GROUP_REDUCE_MAXF", OpenCL_std, 1102 },
    { "SUB_GROUP_REDUCE_MAXS", OpenCL_std, 1103 },
    { "SUB_GROUP_REDUCE_MAXU", OpenCL_std, 1104 },
    { "SUB_GROUP_REDUCE_MINF", OpenCL_std, 1105 },
    { "SUB_GROUP_REDUCE_MINS", OpenCL_std, 1106 },
    { "SUB_GROUP_REDUCE_MINU", OpenCL_std, 1107 },
    { "SUB_GROUP_ROTATE", OpenCL_std, 1108 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_ADDF", OpenCL_std, 1109 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_ADDS", OpenCL_std, 1110 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_ADDU", OpenCL_std, 1111 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MAXF", OpenCL_std, 1112 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MAXS", OpenCL_std, 1113 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MAXU", OpenCL_std, 1114 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MINF", OpenCL_std, 1115 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MINS", OpenCL_std, 1116 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MINU", OpenCL_std, 1117 },
    { "SUB_GROUP_SCAN_INCLUSIVE_ADDF", OpenCL_std, 1118 },
    { "SUB_GROUP_SCAN_INCLUSIVE_ADDS", OpenCL_std, 1119 },
    { "SUB_GROUP_SCAN_INCLUSIVE_ADDU", OpenCL_std, 1120 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MAXF", OpenCL_std, 1121 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MAXS", OpenCL_std, 1122 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MAXU", OpenCL_std, 1123 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MINF", OpenCL_std, 1124 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MINS", OpenCL_std, 1125 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MINU", OpenCL_std, 1126 },
    { "SUB_GROUP_SHUFFLE", OpenCL_std, 1127 },
    { "SUB_GROUP_SHUFFLE_DOWN", OpenCL_std, 1128 },
    { "SUB_GROUP_SHUFFLE_UP", OpenCL_std, 1129 },
    { "SUB_GROUP_SHUFFLE_XOR", OpenCL_std, 1130 },
    { "SUB_GROUP_SMAX", OpenCL_std, 1131 },
    { "SUB_GROUP_SMIN", OpenCL_std, 1132 },
    { "SUB_GROUP_UMAX", OpenCL_std, 1133 },
    { "SUB_GROUP_UMIN", OpenCL_std, 1134 },
    { "S_ABS", OpenCL_std, 1135 },
    { "S_ABS_DIFF", OpenCL_std, 1136 },
    { "S_ADD_SAT", OpenCL_std, 1137 },
    { "S_CLAMP", OpenCL_std, 1138 },
    { "S_HADD", OpenCL_std, 1139 },
    { "S_MAD24", OpenCL_std, 1140 },
    { "S_MAD_HI", OpenCL_std, 1141 },
    { "S_MAD_SAT", OpenCL_std, 1142 },
    { "S_MAX", OpenCL_std, 1143 },
    { "S_MIN", OpenCL_std, 1144 },
    { "S_MUL24", OpenCL_std, 1145 },
    { "S_MUL_HI", OpenCL_std, 1146 },
    { "S_RHADD", OpenCL_std, 1147 },
    { "S_SUB_SAT", OpenCL_std, 1148 },
    { "S_UPSAMPLE", OpenCL_std, 1149 },
    { "TAN", OpenCL_std, 1150 },
    { "TAN", GLSL_std_450, 1151 },
    { "TANH", OpenCL_std, 1152 },
    { "TANH", GLSL_std_450, 1153 },
    { "TANPI", OpenCL_std, 1154 },
    { "TGAMMA", OpenCL_std, 1155 },
    { "TO_GLOBAL", OpenCL_std, 1156 },
    { "TO_LOCAL", OpenCL_std, 1157 },
    { "TO_PRIVATE", OpenCL_std, 1158 },
    { "TRUNC", OpenCL_std, 1159 },
    { "TRUNC", GLSL_std_450, 1160 },
    { "UCLAMP", GLSL_std_450, 1161 },
    { "UMAX", GLSL_std_450, 1162 },
    { "UMIN", GLSL_std_450, 1163 },
    { "UNPACKDOUBLE2X32", GLSL_std_450, 1164 },
    { "UNPACKHALF2X16", GLSL_std_450, 1165 },
    { "UNPACKSNORM2X16", GLSL_std_450, 1166 },
    { "UNPACKSNORM4X8", GLSL_std_450, 1167 },
    { "UNPACKUNORM2X16", GLSL_std_450, 1168 },
    { "UNPACKUNORM4X8", GLSL_std_450, 1169 },
    { "U_ABS", OpenCL_std, 1170 },
    { "U_ABS_DIFF", OpenCL_std, 1171 },
    { "U_ADD_SAT", OpenCL_std, 1172 },
    { "U_CLAMP", OpenCL_std, 1173 },
    { "U_HADD", OpenCL_std, 1174 },
    { "U_MAD24", OpenCL_std, 1175 },
    { "U_MAD_HI", OpenCL_std, 1176 },
    { "U_MAD_SAT", OpenCL_std, 1177 },
    { "U_MAX", OpenCL_std, 1178 },
    { "U_MIN", OpenCL_std, 1179 },
    { "U_MUL24", OpenCL_std, 1180 },
    { "U_MUL_HI", OpenCL_std, 1181 },
    { "U_RHADD", OpenCL_std, 1182 },
    { "U_SUB_SAT", OpenCL_std, 1183 },
    { "U_UPSAMPLE", OpenCL_std, 1184 },
    { "VLOAD", OpenCL_std, 1185 },
    { "VLOAD16", OpenCL_std, 1186 },
    { "VLOAD2", OpenCL_std, 1187 },
    { "VLOAD3", OpenCL_std, 1188 },
    { "VLOAD4", OpenCL_std, 1189 },
    { "VLOAD8", OpenCL_std, 1190 },
    { "VLOADA_HALF", OpenCL_std, 1191 },
    { "VLOADA_HALF16", OpenCL_std, 1192 },
    { "VLOADA_HALF2", OpenCL_std, 1193 },
    { "VLOADA_HALF3", OpenCL_std, 1194 },
    { "VLOADA_HALF4", OpenCL_std, 1195 },
    { "VLOADA_HALF8", OpenCL_std, 1196 },
    { "VLOADA_HALFN", OpenCL_std, 1197 },
    { "VLOADN", OpenCL_std, 1198 },
    { "VLOAD_HALF", OpenCL_std, 1199 },
    { "VLOAD_HALF", OpenCL_std, 1200 },
    { "VLOAD_HALF16", OpenCL_std, 1201 },
    { "VLOAD_HALF2", OpenCL_std, 1202 },
    { "VLOAD_HALF3", OpenCL_std, 1203 },
    { "VLOAD_HALF4", OpenCL_std, 1204 },
    { "VLOAD_HALF8", OpenCL_std, 1205 },
    { "VLOAD_HALFN", OpenCL_std, 1206 },
    { "VSTORE", OpenCL_std, 1207 },
    { "VSTORE16", OpenCL_std, 1208 },
    { "VSTORE2", OpenCL_std, 1209 },
    { "VSTORE3", OpenCL_std, 1210 },
    { "VSTORE4", OpenCL_std, 1211 },
    { "VSTORE8", OpenCL_std, 1212 },
    { "VSTOREA_HALF", OpenCL_std, 1213 },
    { "VSTOREA_HALF16", OpenCL_std, 1214 },
    { "VSTOREA_HALF16_RTE", OpenCL_std, 1215 },
    { "VSTOREA_HALF16_RTN", OpenCL_std, 1216 },
    { "VSTOREA_HALF16_RTP", OpenCL_std, 1217 },
    { "VSTOREA_HALF16_RTZ", OpenCL_std, 1218 },
    { "VSTOREA_HALF2", OpenCL_std, 1219 },
    { "VSTOREA_HALF2_RTE", OpenCL_std, 1220 },
    { "VSTOREA_HALF2_RTN", OpenCL_std, 1221 },
    { "VSTOREA_HALF2_RTP", OpenCL_std, 1222 },
    { "VSTOREA_HALF2_RTZ", OpenCL_std, 1223 },
    { "VSTOREA_HALF3", OpenCL_std, 1224 },
    { "VSTOREA_HALF3_RTE", OpenCL_std, 1225 },
    { "VSTOREA_HALF3_RTN", OpenCL_std, 1226 },
    { "VSTOREA_HALF3_RTP", OpenCL_std, 1227 },
    { "VSTOREA_HALF3_RTZ", OpenCL_std, 1228 },
    { "VSTOREA_HALF4", OpenCL_std, 1229 },
    { "VSTOREA_HALF4_RTE", OpenCL_std, 1230 },
    { "VSTOREA_HALF4_RTN", OpenCL_std, 1231 },
    { "VSTOREA_HALF4_RTP", OpenCL_std, 1232 },
    { "VSTOREA_HALF4_RTZ", OpenCL_std, 1233 },
    { "VSTOREA_HALF8", OpenCL_std, 1234 },
    { "VSTOREA_HALF8_RTE", OpenCL_std, 1235 },
    { "VSTOREA_HALF8_RTN", OpenCL_std, 1236 },
    { "VSTOREA_HALF8_RTP", OpenCL_std, 1237 },
    { "VSTOREA_HALF8_RTZ", OpenCL_std, 1238 },
    { "VSTOREA_HALFN", OpenCL_std, 1239 },
    { "VSTOREA_HALFN_R", OpenCL_std, 1240 },
    { "VSTOREA_HALF_RTE", OpenCL_std, 1241 },
    { "VSTOREA_HALF_RTN", OpenCL_std, 1242 },
    { "VSTOREA_HALF_RTP", OpenCL_std, 1243 },
    { "VSTOREA_HALF_RTZ", OpenCL_std, 1244 },
    { "VSTOREN", OpenCL_std, 1245 },
    { "VSTORE_HALF", OpenCL_std, 1246 },
    { "VSTORE_HALF", OpenCL_std, 1247 },
    { "VSTORE_HALF16", OpenCL_std, 1248 },
    { "VSTORE_HALF16_RTE", OpenCL_std, 1249 },
    { "VSTORE_HALF16_RTN", OpenCL_std, 1250 },
    { "VSTORE_HALF16_RTP", OpenCL_std, 1251 },
    { "VSTORE_HALF16_RTZ", OpenCL_std, 1252 },
    { "VSTORE_HALF2", OpenCL_std, 1253 },
    { "VSTORE_HALF2_RTE", OpenCL_std, 1254 },
    { "VSTORE_HALF2_RTN", OpenCL_std, 1255 },
    { "VSTORE_HALF2_RTP", OpenCL_std, 1256 },
    { "VSTORE_HALF2_RTZ", OpenCL_std, 1257 },
    { "VSTORE_HALF3", OpenCL_std, 1258 },
    { "VSTORE_HALF3_RTE", OpenCL_std, 1259 },
    { "VSTORE_HALF3_RTN", OpenCL_std, 1260 },
    { "VSTORE_HALF3_RTP", OpenCL_std, 1261 },
    { "VSTORE_HALF3_RTZ", OpenCL_std, 1262 },
    { "VSTORE_HALF4", OpenCL_std, 1263 },
    { "VSTORE_HALF4_RTE", OpenCL_std, 1264 },
    { "VSTORE_HALF4_RTN", OpenCL_std, 1265 },
    { "VSTORE_HALF4_RTP", OpenCL_std, 1266 },
    { "VSTORE_HALF4_RTZ", OpenCL_std, 1267 },
    { "VSTORE_HALF8", OpenCL_std, 1268 },
    { "VSTORE_HALF8_RTE", OpenCL_std, 1269 },
    { "VSTORE_HALF8_RTN", OpenCL_std, 1270 },
    { "VSTORE_HALF8_RTP", OpenCL_std, 1271 },
    { "VSTORE_HALF8_RTZ", OpenCL_std, 1272 },
    { "VSTORE_HALFN", OpenCL_std, 1273 },
    { "VSTORE_HALFN_R", OpenCL_std, 1274 },
    { "VSTORE_HALF_R", OpenCL_std, 1275 },
    { "VSTORE_HALF_RTE", OpenCL_std, 1276 },
    { "VSTORE_HALF_RTN", OpenCL_std, 1277 },
    { "VSTORE_HALF_RTP", OpenCL_std, 1278 },
    { "VSTORE_HALF_RTZ", OpenCL_std, 1279 },
    { "WAIT_GROUP_EVENTS", OpenCL_std, 1280 },
    { "WORK_GROUP_ALL", OpenCL_std, 1281 },
    { "WORK_GROUP_ANY", OpenCL_std, 1282 },
    { "WORK_GROUP_BARRIER", OpenCL_std, 1283 },
    { "WORK_GROUP_BROADCAST", OpenCL_std, 1284 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDD", OpenCL_std, 1285 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDF", OpenCL_std, 1286 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDH", OpenCL_std, 1287 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDS", OpenCL_std, 1288 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDU", OpenCL_std, 1289 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ANDS", OpenCL_std, 1290 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ANDU", OpenCL_std, 1291 },
    { "WORK_GROUP_CLUSTERED_REDUCE_LOGICAL_AND", OpenCL_std, 1292 },
    { "WORK_GROUP_CLUSTERED_REDUCE_LOGICAL_OR", OpenCL_std, 1293 },
    { "WORK_GROUP_CLUSTERED_REDUCE_LOGICAL_XOR", OpenCL_std, 1294 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXD", OpenCL_std, 1295 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXF", OpenCL_std, 1296 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXH", OpenCL_std, 1297 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXS", OpenCL_std, 1298 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXU", OpenCL_std, 1299 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MIND", OpenCL_std, 1300 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINF", OpenCL_std, 1301 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINH", OpenCL_std, 1302 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINS", OpenCL_std, 1303 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINU", OpenCL_std, 1304 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULD", OpenCL_std, 1305 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULF", OpenCL_std, 1306 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULH", OpenCL_std, 1307 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULS", OpenCL_std, 1308 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULU", OpenCL_std, 1309 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ORS", OpenCL_std, 1310 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ORU", OpenCL_std, 1311 },
    { "WORK_GROUP_CLUSTERED_REDUCE_XORS", OpenCL_std, 1312 },
    { "WORK_GROUP_CLUSTERED_REDUCE_XORU", OpenCL_std, 1313 },
    { "WORK_GROUP_FADD", OpenCL_std, 1314 },
    { "WORK_GROUP_FMAX", OpenCL_std, 1315 },
    { "WORK_GROUP_FMIN", OpenCL_std, 1316 },
    { "WORK_GROUP_IADD", OpenCL_std, 1317 },
    { "WORK_GROUP_NON_UNIFORM_FADD", OpenCL_std, 1318 },
    { "WORK_GROUP_NON_UNIFORM_FMAX", OpenCL_std, 1319 },
    { "WORK_GROUP_NON_UNIFORM_FMIN", OpenCL_std, 1320 },
    { "WORK_GROUP_NON_UNIFORM_FMUL", OpenCL_std, 1321 },
    { "WORK_GROUP_NON_UNIFORM_IADD", OpenCL_std, 1322 },
    { "WORK_GROUP_NON_UNIFORM_IAND", OpenCL_std, 1323 },
    { "WORK_GROUP_NON_UNIFORM_IMUL", OpenCL_std, 1324 },
    { "WORK_GROUP_NON_UNIFORM_IOR", OpenCL_std, 1325 },
    { "WORK_GROUP_NON_UNIFORM_IXOR", OpenCL_std, 1326 },
    { "WORK_GROUP_NON_UNIFORM_LOGICAL_IAND", OpenCL_std, 1327 },
    { "WORK_GROUP_NON_UNIFORM_LOGICAL_IOR", OpenCL_std, 1328 },
    { "WORK_GROUP_NON_UNIFORM_LOGICAL_IXOR", OpenCL_std, 1329 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDD", OpenCL_std, 1330 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDF", OpenCL_std, 1331 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDH", OpenCL_std, 1332 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDS", OpenCL_std, 1333 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDU", OpenCL_std, 1334 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ANDS", OpenCL_std, 1335 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ANDU", OpenCL_std, 1336 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ANDS", OpenCL_std, 1337 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ORS", OpenCL_std, 1338 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_LOGICAL_XORS", OpenCL_std, 1339 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXD", OpenCL_std, 1340 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXF", OpenCL_std, 1341 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXH", OpenCL_std, 1342 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXS", OpenCL_std, 1343 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXU", OpenCL_std, 1344 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MIND", OpenCL_std, 1345 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINF", OpenCL_std, 1346 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINH", OpenCL_std, 1347 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINS", OpenCL_std, 1348 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINU", OpenCL_std, 1349 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULD", OpenCL_std, 1350 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULF", OpenCL_std, 1351 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULH", OpenCL_std, 1352 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULS", OpenCL_std, 1353 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULU", OpenCL_std, 1354 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ORS", OpenCL_std, 1355 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ORU", OpenCL_std, 1356 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_XORS", OpenCL_std, 1357 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_XORU", OpenCL_std, 1358 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDD", OpenCL_std, 1359 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDF", OpenCL_std, 1360 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDH", OpenCL_std, 1361 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDS", OpenCL_std, 1362 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDU", OpenCL_std, 1363 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDS", OpenCL_std, 1364 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDU", OpenCL_std, 1365 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ANDS", OpenCL_std, 1366 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ORS", OpenCL_std, 1367 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_XORS", OpenCL_std, 1368 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXD", OpenCL_std, 1369 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXF", OpenCL_std, 1370 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXH", OpenCL_std, 1371 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXS", OpenCL_std, 1372 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXU", OpenCL_std, 1373 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MIND", OpenCL_std, 1374 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINF", OpenCL_std, 1375 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINH", OpenCL_std, 1376 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINS", OpenCL_std, 1377 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINU", OpenCL_std, 1378 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULD", OpenCL_std, 1379 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULF", OpenCL_std, 1380 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULH", OpenCL_std, 1381 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULS", OpenCL_std, 1382 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULU", OpenCL_std, 1383 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORS", OpenCL_std, 1384 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORU", OpenCL_std, 1385 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORS", OpenCL_std, 1386 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORU", OpenCL_std, 1387 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDD", OpenCL_std, 1388 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDF", OpenCL_std, 1389 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDH", OpenCL_std, 1390 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDS", OpenCL_std, 1391 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDU", OpenCL_std, 1392 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDS", OpenCL_std, 1393 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDU", OpenCL_std, 1394 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ANDS", OpenCL_std, 1395 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ORS", OpenCL_std, 1396 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_XORS", OpenCL_std, 1397 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXD", OpenCL_std, 1398 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXF", OpenCL_std, 1399 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXH", OpenCL_std, 1400 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXS", OpenCL_std, 1401 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXU", OpenCL_std, 1402 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MIND", OpenCL_std, 1403 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINF", OpenCL_std, 1404 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINH", OpenCL_std, 1405 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINS", OpenCL_std, 1406 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINU", OpenCL_std, 1407 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULD", OpenCL_std, 1408 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULF", OpenCL_std, 1409 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULH", OpenCL_std, 1410 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULS", OpenCL_std, 1411 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULU", OpenCL_std, 1412 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORS", OpenCL_std, 1413 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORU", OpenCL_std, 1414 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORS", OpenCL_std, 1415 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORU", OpenCL_std, 1416 },
    { "WORK_GROUP_NON_UNIFORM_SMAX", OpenCL_std, 1417 },
    { "WORK_GROUP_NON_UNIFORM_SMIN", OpenCL_std, 1418 },
    { "WORK_GROUP_NON_UNIFORM_UMAX", OpenCL_std, 1419 },
    { "WORK_GROUP_NON_UNIFORM_UMIN", OpenCL_std, 1420 },
    { "WORK_GROUP_REDUCE_ADDF", OpenCL_std, 1421 },
    { "WORK_GROUP_REDUCE_ADDS", OpenCL_std, 1422 },
    { "WORK_GROUP_REDUCE_ADDU", OpenCL_std, 1423 },
    { "WORK_GROUP_REDUCE_AND", OpenCL_std, 1424 },
    { "WORK_GROUP_REDUCE_IMUL", OpenCL_std, 1425 },
    { "WORK_GROUP_REDUCE_LOGICAL_AND", OpenCL_std, 1426 },
    { "WORK_GROUP_REDUCE_LOGICAL_OR", OpenCL_std, 1427 },
    { "WORK_GROUP_REDUCE_LOGICAL_XOR", OpenCL_std, 1428 },
    { "WORK_GROUP_REDUCE_MAXF", OpenCL_std, 1429 },
    { "WORK_GROUP_REDUCE_MAXS", OpenCL_std, 1430 },
    { "WORK_GROUP_REDUCE_MAXU", OpenCL_std, 1431 },
    { "WORK_GROUP_REDUCE_MINF", OpenCL_std, 1432 },
    { "WORK_GROUP_REDUCE_MINS", OpenCL_std, 1433 },
    { "WORK_GROUP_REDUCE_MINU", OpenCL_std, 1434 },
    { "WORK_GROUP_REDUCE_MULD", OpenCL_std, 1435 },
    { "WORK_GROUP_REDUCE_MULF", OpenCL_std, 1436 },
    { "WORK_GROUP_REDUCE_MULH", OpenCL_std, 1437 },
    { "WORK_GROUP_REDUCE_MULS", OpenCL_std, 1438 },
    { "WORK_GROUP_REDUCE_MULU", OpenCL_std, 1439 },
    { "WORK_GROUP_REDUCE_OR", OpenCL_std, 1440 },
    { "WORK_GROUP_REDUCE_XOR", OpenCL_std, 1441 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_ADDF", OpenCL_std, 1442 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_ADDS", OpenCL_std, 1443 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_ADDU", OpenCL_std, 1444 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_AND", OpenCL_std, 1445 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_IMUL", OpenCL_std, 1446 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_LOGICAL_AND", OpenCL_std, 1447 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_LOGICAL_OR", OpenCL_std, 1448 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_LOGICAL_XOR", OpenCL_std, 1449 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MAXF", OpenCL_std, 1450 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MAXS", OpenCL_std, 1451 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MAXU", OpenCL_std, 1452 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MINF", OpenCL_std, 1453 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MINS", OpenCL_std, 1454 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MINU", OpenCL_std, 1455 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULD", OpenCL_std, 1456 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULF", OpenCL_std, 1457 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULH", OpenCL_std, 1458 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULS", OpenCL_std, 1459 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULU", OpenCL_std, 1460 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_OR", OpenCL_std, 1461 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_XOR", OpenCL_std, 1462 },
    { "WORK_GROUP_SCAN_INCLUSIVE_ADDF", OpenCL_std, 1463 },
    { "WORK_GROUP_SCAN_INCLUSIVE_ADDS", OpenCL_std, 1464 },
    { "WORK_GROUP_SCAN_INCLUSIVE_ADDU", OpenCL_std, 1465 },
    { "WORK_GROUP_SCAN_INCLUSIVE_AND", OpenCL_std, 1466 },
    { "WORK_GROUP_SCAN_INCLUSIVE_IMUL", OpenCL_std, 1467 },
    { "WORK_GROUP_SCAN_INCLUSIVE_LOGICAL_AND", OpenCL_std, 1468 },
    { "WORK_GROUP_SCAN_INCLUSIVE_LOGICAL_OR", OpenCL_std, 1469 },
    { "WORK_GROUP_SCAN_INCLUSIVE_LOGICAL_XOR", OpenCL_std, 1470 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MAXF", OpenCL_std, 1471 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MAXS", OpenCL_std, 1472 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MAXU", OpenCL_std, 1473 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MINF", OpenCL_std, 1474 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MINS", OpenCL_std, 1475 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MINU", OpenCL_std, 1476 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULD", OpenCL_std, 1477 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULF", OpenCL_std, 1478 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULH", OpenCL_std, 1479 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULS", OpenCL_std, 1480 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULU", OpenCL_std, 1481 },
    { "WORK_GROUP_SCAN_INCLUSIVE_OR", OpenCL_std, 1482 },
    { "WORK_GROUP_SCAN_INCLUSIVE_XOR", OpenCL_std, 1483 },
    { "WORK_GROUP_SMAX", OpenCL_std, 1484 },
    { "WORK_GROUP_SMIN", OpenCL_std, 1485 },
    { "WORK_GROUP_UMAX", OpenCL_std, 1486 },
    { "WORK_GROUP_UMIN", OpenCL_std, 1487 },
    { "WRITE_IMAGEF", OpenCL_std, 1488 },
    { "WRITE_IMAGEH", OpenCL_std, 1489 },
    { "WRITE_IMAGEI", OpenCL_std, 1490 },
    { "WRITE_IMAGEUI", OpenCL_std, 1491 },
    { "__ENQUEUE_KERNEL_BASIC", OpenCL_std, 1492 },
    { "__ENQUEUE_KERNEL_BASIC_EVENTS", OpenCL_std, 1493 },
    { "__ENQUEUE_KERNEL_EVENTS_VARARGS", OpenCL_std, 1494 },
    { "__ENQUEUE_KERNEL_VARARGS", OpenCL_std, 1495 },
    { "__HLSL_WAVE_GET_LANE_INDEX", GLSL_std_450, 1496 },
    { "__SPIRV_ALL", OpenCL_std, 1497 },
    { "__SPIRV_ANY", OpenCL_std, 1498 },
    { "__SPIRV_ATOMICAND", OpenCL_std, 1499 },
    { "__SPIRV_ATOMICCOMPAREEXCHANGE", OpenCL_std, 1500 },
    { "__SPIRV_ATOMICCOMPAREEXCHANGEWEAK", OpenCL_std, 1501 },
    { "__SPIRV_ATOMICEXCHANGE", OpenCL_std, 1502 },
    { "__SPIRV_ATOMICFADDEXT", OpenCL_std, 1503 },
    { "__SPIRV_ATOMICFLAGCLEAR", OpenCL_std, 1504 },
    { "__SPIRV_ATOMICFLAGTESTANDSET", OpenCL_std, 1505 },
    { "__SPIRV_ATOMICFMAXEXT", OpenCL_std, 1506 },
    { "__SPIRV_ATOMICFMINEXT", OpenCL_std, 1507 },
    { "__SPIRV_ATOMICIADD", OpenCL_std, 1508 },
    { "__SPIRV_ATOMICISUB", OpenCL_std, 1509 },
    { "__SPIRV_ATOMICLOAD", OpenCL_std, 1510 },
    { "__SPIRV_ATOMICOR", OpenCL_std, 1511 },
    { "__SPIRV_ATOMICSMAX", OpenCL_std, 1512 },
    { "__SPIRV_ATOMICSMIN", OpenCL_std, 1513 },
    { "__SPIRV_ATOMICSTORE", OpenCL_std, 1514 },
    { "__SPIRV_ATOMICUMAX", OpenCL_std, 1515 },
    { "__SPIRV_ATOMICUMIN", OpenCL_std, 1516 },
    { "__SPIRV_ATOMICXOR", OpenCL_std, 1517 },
    { "__SPIRV_BUILTINGLOBALINVOCATIONID", OpenCL_std, 1518 },
    { "__SPIRV_BUILTINGLOBALLINEARID", OpenCL_std, 1519 },
    { "__SPIRV_CAPTUREEVENTPROFILINGINFO", OpenCL_std, 1520 },
    { "__SPIRV_COMPOSITECONSTRUCT", OpenCL_std, 1521 },
    { "__SPIRV_CONTROLBARRIER", OpenCL_std, 1522 },
    { "__SPIRV_CONTROLBARRIERARRIVEINTEL", OpenCL_std, 1523 },
    { "__SPIRV_CONTROLBARRIERWAITINTEL", OpenCL_std, 1524 },
    { "__SPIRV_CONVERTBF16TOFINTEL", OpenCL_std, 1525 },
    { "__SPIRV_CONVERTFTOBF16INTEL", OpenCL_std, 1526 },
    { "__SPIRV_CONVERTFTOS", OpenCL_std, 1527 },
    { "__SPIRV_CONVERTFTOU", OpenCL_std, 1528 },
    { "__SPIRV_CONVERTPTRTOU", OpenCL_std, 1529 },
    { "__SPIRV_CONVERTSTOF", OpenCL_std, 1530 },
    { "__SPIRV_CONVERTUTOF", OpenCL_std, 1531 },
    { "__SPIRV_CONVERTUTOPTR", OpenCL_std, 1532 },
    { "__SPIRV_COOPERATIVEMATRIXCONSTRUCTCHECKEDINTEL", OpenCL_std, 1533 },
    { "__SPIRV_COOPERATIVEMATRIXGETELEMENTCOORDINTEL", OpenCL_std, 1534 },
    { "__SPIRV_COOPERATIVEMATRIXLENGTHKHR", OpenCL_std, 1535 },
    { "__SPIRV_COOPERATIVEMATRIXLOADCHECKEDINTEL", OpenCL_std, 1536 },
    { "__SPIRV_COOPERATIVEMATRIXLOADKHR", OpenCL_std, 1537 },
    { "__SPIRV_COOPERATIVEMATRIXMULADDKHR", OpenCL_std, 1538 },
    { "__SPIRV_COOPERATIVEMATRIXPREFETCHINTEL", OpenCL_std, 1539 },
    { "__SPIRV_COOPERATIVEMATRIXSTORECHECKEDINTEL", OpenCL_std, 1540 },
    { "__SPIRV_COOPERATIVEMATRIXSTOREKHR", OpenCL_std, 1541 },
    { "__SPIRV_CREATEUSEREVENT", OpenCL_std, 1542 },
    { "__SPIRV_DOT", OpenCL_std, 1543 },
    { "__SPIRV_ENQUEUEKERNEL", OpenCL_std, 1544 },
    { "__SPIRV_FCONVERT", OpenCL_std, 1545 },
    { "__SPIRV_FORDEQUAL", OpenCL_std, 1546 },
    { "__SPIRV_FORDGREATERTHAN", OpenCL_std, 1547 },
    { "__SPIRV_FORDGREATERTHANEQUAL", OpenCL_std, 1548 },
    { "__SPIRV_FORDLESSTHAN", OpenCL_std, 1549 },
    { "__SPIRV_FORDLESSTHANEQUAL", OpenCL_std, 1550 },
    { "__SPIRV_FORDNOTEQUAL", OpenCL_std, 1551 },
    { "__SPIRV_FUNORDNOTEQUAL", OpenCL_std, 1552 },
    { "__SPIRV_GENERICCASTTOPTREXPLICIT_TOGLOBAL", OpenCL_std, 1553 },
    { "__SPIRV_GENERICCASTTOPTREXPLICIT_TOLOCAL", OpenCL_std, 1554 },
    { "__SPIRV_GENERICCASTTOPTREXPLICIT_TOPRIVATE", OpenCL_std, 1555 },
    { "__SPIRV_GENERICCASTTOPTR_TOGLOBAL", OpenCL_std, 1556 },
    { "__SPIRV_GENERICCASTTOPTR_TOLOCAL", OpenCL_std, 1557 },
    { "__SPIRV_GENERICCASTTOPTR_TOPRIVATE", OpenCL_std, 1558 },
    { "__SPIRV_GETDEFAULTQUEUE", OpenCL_std, 1559 },
    { "__SPIRV_GROUPALL", OpenCL_std, 1560 },
    { "__SPIRV_GROUPANY", OpenCL_std, 1561 },
    { "__SPIRV_GROUPASYNCCOPY", OpenCL_std, 1562 },
    { "__SPIRV_GROUPBITWISEANDKHR", OpenCL_std, 1563 },
    { "__SPIRV_GROUPBITWISEORKHR", OpenCL_std, 1564 },
    { "__SPIRV_GROUPBITWISEXORKHR", OpenCL_std, 1565 },
    { "__SPIRV_GROUPBROADCAST", OpenCL_std, 1566 },
    { "__SPIRV_GROUPFADD", OpenCL_std, 1567 },
    { "__SPIRV_GROUPFMAX", OpenCL_std, 1568 },
    { "__SPIRV_GROUPFMIN", OpenCL_std, 1569 },
    { "__SPIRV_GROUPFMULKHR", OpenCL_std, 1570 },
    { "__SPIRV_GROUPIADD", OpenCL_std, 1571 },
    { "__SPIRV_GROUPIMULKHR", OpenCL_std, 1572 },
    { "__SPIRV_GROUPLOGICALANDKHR", OpenCL_std, 1573 },
    { "__SPIRV_GROUPLOGICALORKHR", OpenCL_std, 1574 },
    { "__SPIRV_GROUPLOGICALXORKHR", OpenCL_std, 1575 },
    { "__SPIRV_GROUPNONUNIFORMALL", OpenCL_std, 1576 },
    { "__SPIRV_GROUPNONUNIFORMALLEQUAL", OpenCL_std, 1577 },
    { "__SPIRV_GROUPNONUNIFORMANY", OpenCL_std, 1578 },
    { "__SPIRV_GROUPNONUNIFORMBALLOT", OpenCL_std, 1579 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTBITCOUNT", OpenCL_std, 1580 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTBITEXTRACT", OpenCL_std, 1581 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTFINDLSB", OpenCL_std, 1582 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTFINDMSB", OpenCL_std, 1583 },
    { "__SPIRV_GROUPNONUNIFORMBITWISEAND", OpenCL_std, 1584 },
    { "__SPIRV_GROUPNONUNIFORMBITWISEOR", OpenCL_std, 1585 },
    { "__SPIRV_GROUPNONUNIFORMBITWISEXOR", OpenCL_std, 1586 },
    { "__SPIRV_GROUPNONUNIFORMBROADCAST", OpenCL_std, 1587 },
    { "__SPIRV_GROUPNONUNIFORMBROADCASTFIRST", OpenCL_std, 1588 },
    { "__SPIRV_GROUPNONUNIFORMELECT", OpenCL_std, 1589 },
    { "__SPIRV_GROUPNONUNIFORMFADD", OpenCL_std, 1590 },
    { "__SPIRV_GROUPNONUNIFORMFMAX", OpenCL_std, 1591 },
    { "__SPIRV_GROUPNONUNIFORMFMIN", OpenCL_std, 1592 },
    { "__SPIRV_GROUPNONUNIFORMFMUL", OpenCL_std, 1593 },
    { "__SPIRV_GROUPNONUNIFORMIADD", OpenCL_std, 1594 },
    { "__SPIRV_GROUPNONUNIFORMIMUL", OpenCL_std, 1595 },
    { "__SPIRV_GROUPNONUNIFORMINVERSEBALLOT", OpenCL_std, 1596 },
    { "__SPIRV_GROUPNONUNIFORMLOGICALAND", OpenCL_std, 1597 },
    { "__SPIRV_GROUPNONUNIFORMLOGICALOR", OpenCL_std, 1598 },
    { "__SPIRV_GROUPNONUNIFORMLOGICALXOR", OpenCL_std, 1599 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLE", OpenCL_std, 1600 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLEDOWN", OpenCL_std, 1601 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLEUP", OpenCL_std, 1602 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLEXOR", OpenCL_std, 1603 },
    { "__SPIRV_GROUPNONUNIFORMSMAX", OpenCL_std, 1604 },
    { "__SPIRV_GROUPNONUNIFORMSMIN", OpenCL_std, 1605 },
    { "__SPIRV_GROUPNONUNIFORMUMAX", OpenCL_std, 1606 },
    { "__SPIRV_GROUPNONUNIFORMUMIN", OpenCL_std, 1607 },
    { "__SPIRV_GROUPSMAX", OpenCL_std, 1608 },
    { "__SPIRV_GROUPSMIN", OpenCL_std, 1609 },
    { "__SPIRV_GROUPUMAX", OpenCL_std, 1610 },
    { "__SPIRV_GROUPUMIN", OpenCL_std, 1611 },
    { "__SPIRV_GROUPWAITEVENTS", OpenCL_std, 1612 },
    { "__SPIRV_IADDCARRY", OpenCL_std, 1613 },
    { "__SPIRV_IMAGESAMPLEEXPLICITLOD", OpenCL_std, 1614 },
    { "__SPIRV_ISFINITE", OpenCL_std, 1615 },
    { "__SPIRV_ISINF", OpenCL_std, 1616 },
    { "__SPIRV_ISNAN", OpenCL_std, 1617 },
    { "__SPIRV_ISNORMAL", OpenCL_std, 1618 },
    { "__SPIRV_ISUBBORROW", OpenCL_std, 1619 },
    { "__SPIRV_ISVALIDEVENT", OpenCL_std, 1620 },
    { "__SPIRV_LOAD", OpenCL_std, 1621 },
    { "__SPIRV_MEMORYBARRIER", OpenCL_std, 1622 },
    { "__SPIRV_ORDERED", OpenCL_std, 1623 },
    { "__SPIRV_QUANTIZETOF16", OpenCL_std, 1624 },
    { "__SPIRV_RELEASEEVENT", OpenCL_std, 1625 },
    { "__SPIRV_RETAINEVENT", OpenCL_std, 1626 },
    { "__SPIRV_SAMPLEDIMAGE", OpenCL_std, 1627 },
    { "__SPIRV_SATCONVERTSTOU", OpenCL_std, 1628 },
    { "__SPIRV_SATCONVERTUTOS", OpenCL_std, 1629 },
    { "__SPIRV_SCONVERT", OpenCL_std, 1630 },
    { "__SPIRV_SELECT", OpenCL_std, 1631 },
    { "__SPIRV_SETUSEREVENTSTATUS", OpenCL_std, 1632 },
    { "__SPIRV_SIGNBITSET", OpenCL_std, 1633 },
    { "__SPIRV_SPECCONSTANT", OpenCL_std, 1634 },
    { "__SPIRV_SPECCONSTANTCOMPOSITE", OpenCL_std, 1635 },
    { "__SPIRV_STORE", OpenCL_std, 1636 },
    { "__SPIRV_SUBGROUPBLOCKREADINTEL", OpenCL_std, 1637 },
    { "__SPIRV_SUBGROUPBLOCKWRITEINTEL", OpenCL_std, 1638 },
    { "__SPIRV_SUBGROUPIMAGEBLOCKREADINTEL", OpenCL_std, 1639 },
    { "__SPIRV_SUBGROUPIMAGEBLOCKWRITEINTEL", OpenCL_std, 1640 },
    { "__SPIRV_SUBGROUPIMAGEMEDIABLOCKREADINTEL", OpenCL_std, 1641 },
    { "__SPIRV_SUBGROUPIMAGEMEDIABLOCKWRITEINTEL", OpenCL_std, 1642 },
    { "__SPIRV_SUBGROUPSHUFFLEDOWNINTEL", OpenCL_std, 1643 },
    { "__SPIRV_SUBGROUPSHUFFLEINTEL", OpenCL_std, 1644 },
    { "__SPIRV_SUBGROUPSHUFFLEUPINTEL", OpenCL_std, 1645 },
    { "__SPIRV_SUBGROUPSHUFFLEXORINTEL", OpenCL_std, 1646 },
    { "__SPIRV_UCONVERT", OpenCL_std, 1647 },
    { "__SPIRV_UNORDERED", OpenCL_std, 1648 },
    { "__TRANSLATE_SAMPLER_INITIALIZER", OpenCL_std, 1649 },
  };

  struct KeyType {
    std::string Name;
    unsigned Set;
  };
  KeyType Key = {Name.upper(), Set};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name ||
      Key.Set != Idx->Set)
    return nullptr;

  return &DemangledBuiltins[Idx->_index];
}
#endif

#ifdef GET_ExtendedBuiltins_DECL
const ExtendedBuiltin *lookupExtendedBuiltin(StringRef Name, unsigned Set);
const ExtendedBuiltin *lookupExtendedBuiltinBySetAndNumber(unsigned Set, uint32_t Number);
#endif

#ifdef GET_ExtendedBuiltins_IMPL
constexpr ExtendedBuiltin ExtendedBuiltins[] = {
  { "acos", OpenCL_std, 0x0 }, // 0
  { "Acos", GLSL_std_450, 0x11 }, // 1
  { "acosh", OpenCL_std, 0x1 }, // 2
  { "Acosh", GLSL_std_450, 0x17 }, // 3
  { "acospi", OpenCL_std, 0x2 }, // 4
  { "asin", OpenCL_std, 0x3 }, // 5
  { "Asin", GLSL_std_450, 0x10 }, // 6
  { "asinh", OpenCL_std, 0x4 }, // 7
  { "Asinh", GLSL_std_450, 0x16 }, // 8
  { "asinpi", OpenCL_std, 0x5 }, // 9
  { "atan", OpenCL_std, 0x6 }, // 10
  { "Atan", GLSL_std_450, 0x12 }, // 11
  { "atan2", OpenCL_std, 0x7 }, // 12
  { "Atan2", GLSL_std_450, 0x19 }, // 13
  { "atan2pi", OpenCL_std, 0xA }, // 14
  { "atanh", OpenCL_std, 0x8 }, // 15
  { "Atanh", GLSL_std_450, 0x18 }, // 16
  { "atanpi", OpenCL_std, 0x9 }, // 17
  { "bitselect", OpenCL_std, 0xBA }, // 18
  { "cbrt", OpenCL_std, 0xB }, // 19
  { "ceil", OpenCL_std, 0xC }, // 20
  { "Ceil", GLSL_std_450, 0x9 }, // 21
  { "clz", OpenCL_std, 0x97 }, // 22
  { "copysign", OpenCL_std, 0xD }, // 23
  { "cos", OpenCL_std, 0xE }, // 24
  { "Cos", GLSL_std_450, 0xE }, // 25
  { "cosh", OpenCL_std, 0xF }, // 26
  { "Cosh", GLSL_std_450, 0x14 }, // 27
  { "cospi", OpenCL_std, 0x10 }, // 28
  { "cross", OpenCL_std, 0x68 }, // 29
  { "Cross", GLSL_std_450, 0x44 }, // 30
  { "ctz", OpenCL_std, 0x98 }, // 31
  { "DebugBuildIdentifier", NonSemantic_Shader_DebugInfo_100, 0x69 }, // 32
  { "DebugCompilationUnit", NonSemantic_Shader_DebugInfo_100, 0x1 }, // 33
  { "DebugDeclare", NonSemantic_Shader_DebugInfo_100, 0x1C }, // 34
  { "DebugEntryPoint", NonSemantic_Shader_DebugInfo_100, 0x6B }, // 35
  { "DebugExpression", NonSemantic_Shader_DebugInfo_100, 0x1F }, // 36
  { "DebugFunction", NonSemantic_Shader_DebugInfo_100, 0x14 }, // 37
  { "DebugFunctionDeclaration", NonSemantic_Shader_DebugInfo_100, 0x13 }, // 38
  { "DebugFunctionDefinition", NonSemantic_Shader_DebugInfo_100, 0x65 }, // 39
  { "DebugGlobalVariable", NonSemantic_Shader_DebugInfo_100, 0x12 }, // 40
  { "DebugImportedEntity", NonSemantic_Shader_DebugInfo_100, 0x22 }, // 41
  { "DebugInfoNone", NonSemantic_Shader_DebugInfo_100, 0x0 }, // 42
  { "DebugInlinedAt", NonSemantic_Shader_DebugInfo_100, 0x19 }, // 43
  { "DebugInlinedVariable", NonSemantic_Shader_DebugInfo_100, 0x1B }, // 44
  { "DebugLexicalBlock", NonSemantic_Shader_DebugInfo_100, 0x15 }, // 45
  { "DebugLexicalBlockDiscriminator", NonSemantic_Shader_DebugInfo_100, 0x16 }, // 46
  { "DebugLine", NonSemantic_Shader_DebugInfo_100, 0x67 }, // 47
  { "DebugLocalVariable", NonSemantic_Shader_DebugInfo_100, 0x1A }, // 48
  { "DebugMacroDef", NonSemantic_Shader_DebugInfo_100, 0x20 }, // 49
  { "DebugMacroUndef", NonSemantic_Shader_DebugInfo_100, 0x21 }, // 50
  { "DebugNoLine", NonSemantic_Shader_DebugInfo_100, 0x68 }, // 51
  { "DebugNoScope", NonSemantic_Shader_DebugInfo_100, 0x18 }, // 52
  { "DebugOperation", NonSemantic_Shader_DebugInfo_100, 0x1E }, // 53
  { "DebugScope", NonSemantic_Shader_DebugInfo_100, 0x17 }, // 54
  { "DebugSource", NonSemantic_Shader_DebugInfo_100, 0x23 }, // 55
  { "DebugSourceContinued", NonSemantic_Shader_DebugInfo_100, 0x66 }, // 56
  { "DebugStoragePath", NonSemantic_Shader_DebugInfo_100, 0x6A }, // 57
  { "DebugTypeArray", NonSemantic_Shader_DebugInfo_100, 0x5 }, // 58
  { "DebugTypeBasic", NonSemantic_Shader_DebugInfo_100, 0x2 }, // 59
  { "DebugTypeComposite", NonSemantic_Shader_DebugInfo_100, 0xA }, // 60
  { "DebugTypedef", NonSemantic_Shader_DebugInfo_100, 0x7 }, // 61
  { "DebugTypeEnum", NonSemantic_Shader_DebugInfo_100, 0x9 }, // 62
  { "DebugTypeFunction", NonSemantic_Shader_DebugInfo_100, 0x8 }, // 63
  { "DebugTypeInheritance", NonSemantic_Shader_DebugInfo_100, 0xC }, // 64
  { "DebugTypeMatrix", NonSemantic_Shader_DebugInfo_100, 0x6C }, // 65
  { "DebugTypeMember", NonSemantic_Shader_DebugInfo_100, 0xB }, // 66
  { "DebugTypePointer", NonSemantic_Shader_DebugInfo_100, 0x3 }, // 67
  { "DebugTypePtrToMember", NonSemantic_Shader_DebugInfo_100, 0xD }, // 68
  { "DebugTypeQualifier", NonSemantic_Shader_DebugInfo_100, 0x4 }, // 69
  { "DebugTypeTemplate", NonSemantic_Shader_DebugInfo_100, 0xE }, // 70
  { "DebugTypeTemplateParameter", NonSemantic_Shader_DebugInfo_100, 0xF }, // 71
  { "DebugTypeTemplateParameterPack", NonSemantic_Shader_DebugInfo_100, 0x11 }, // 72
  { "DebugTypeTemplateTemplateParameter", NonSemantic_Shader_DebugInfo_100, 0x10 }, // 73
  { "DebugTypeVector", NonSemantic_Shader_DebugInfo_100, 0x6 }, // 74
  { "DebugValue", NonSemantic_Shader_DebugInfo_100, 0x1D }, // 75
  { "degrees", OpenCL_std, 0x60 }, // 76
  { "Degrees", GLSL_std_450, 0xC }, // 77
  { "Determinant", GLSL_std_450, 0x21 }, // 78
  { "distance", OpenCL_std, 0x69 }, // 79
  { "Distance", GLSL_std_450, 0x43 }, // 80
  { "erf", OpenCL_std, 0x12 }, // 81
  { "erfc", OpenCL_std, 0x11 }, // 82
  { "exp", OpenCL_std, 0x13 }, // 83
  { "Exp", GLSL_std_450, 0x1B }, // 84
  { "exp10", OpenCL_std, 0x15 }, // 85
  { "exp2", OpenCL_std, 0x14 }, // 86
  { "Exp2", GLSL_std_450, 0x1D }, // 87
  { "expm1", OpenCL_std, 0x16 }, // 88
  { "fabs", OpenCL_std, 0x17 }, // 89
  { "FAbs", GLSL_std_450, 0x4 }, // 90
  { "FaceForward", GLSL_std_450, 0x46 }, // 91
  { "fast_distance", OpenCL_std, 0x6C }, // 92
  { "fast_length", OpenCL_std, 0x6D }, // 93
  { "fast_normalize", OpenCL_std, 0x6E }, // 94
  { "fclamp", OpenCL_std, 0x5F }, // 95
  { "FClamp", GLSL_std_450, 0x2B }, // 96
  { "fdim", OpenCL_std, 0x18 }, // 97
  { "FindILsb", GLSL_std_450, 0x49 }, // 98
  { "FindSMsb", GLSL_std_450, 0x4A }, // 99
  { "FindUMsb", GLSL_std_450, 0x4B }, // 100
  { "floor", OpenCL_std, 0x19 }, // 101
  { "Floor", GLSL_std_450, 0x8 }, // 102
  { "fma", OpenCL_std, 0x1A }, // 103
  { "Fma", GLSL_std_450, 0x32 }, // 104
  { "fmax", OpenCL_std, 0x1B }, // 105
  { "FMax", GLSL_std_450, 0x28 }, // 106
  { "fmax_common", OpenCL_std, 0x61 }, // 107
  { "fmin", OpenCL_std, 0x1C }, // 108
  { "FMin", GLSL_std_450, 0x25 }, // 109
  { "fmin_common", OpenCL_std, 0x62 }, // 110
  { "FMix", GLSL_std_450, 0x2E }, // 111
  { "fmod", OpenCL_std, 0x1D }, // 112
  { "fract", OpenCL_std, 0x1E }, // 113
  { "Fract", GLSL_std_450, 0xA }, // 114
  { "frexp", OpenCL_std, 0x1F }, // 115
  { "Frexp", GLSL_std_450, 0x33 }, // 116
  { "FrexpStruct", GLSL_std_450, 0x34 }, // 117
  { "FSign", GLSL_std_450, 0x6 }, // 118
  { "half_cos", OpenCL_std, 0x43 }, // 119
  { "half_divide", OpenCL_std, 0x44 }, // 120
  { "half_exp", OpenCL_std, 0x45 }, // 121
  { "half_exp10", OpenCL_std, 0x47 }, // 122
  { "half_exp2", OpenCL_std, 0x46 }, // 123
  { "half_log", OpenCL_std, 0x48 }, // 124
  { "half_log10", OpenCL_std, 0x4A }, // 125
  { "half_log2", OpenCL_std, 0x49 }, // 126
  { "half_powr", OpenCL_std, 0x4B }, // 127
  { "half_recip", OpenCL_std, 0x4C }, // 128
  { "half_rsqrt", OpenCL_std, 0x4D }, // 129
  { "half_sin", OpenCL_std, 0x4E }, // 130
  { "half_sqrt", OpenCL_std, 0x4F }, // 131
  { "half_tan", OpenCL_std, 0x50 }, // 132
  { "hypot", OpenCL_std, 0x20 }, // 133
  { "ilogb", OpenCL_std, 0x21 }, // 134
  { "InterpolateAtCentroid", GLSL_std_450, 0x4C }, // 135
  { "InterpolateAtOffset", GLSL_std_450, 0x4E }, // 136
  { "InterpolateAtSample", GLSL_std_450, 0x4D }, // 137
  { "InverseSqrt", GLSL_std_450, 0x20 }, // 138
  { "ldexp", OpenCL_std, 0x22 }, // 139
  { "Ldexp", GLSL_std_450, 0x35 }, // 140
  { "length", OpenCL_std, 0x6A }, // 141
  { "Length", GLSL_std_450, 0x42 }, // 142
  { "lgamma", OpenCL_std, 0x23 }, // 143
  { "lgamma_r", OpenCL_std, 0x24 }, // 144
  { "log", OpenCL_std, 0x25 }, // 145
  { "Log", GLSL_std_450, 0x1C }, // 146
  { "log10", OpenCL_std, 0x27 }, // 147
  { "log1p", OpenCL_std, 0x28 }, // 148
  { "log2", OpenCL_std, 0x26 }, // 149
  { "Log2", GLSL_std_450, 0x1E }, // 150
  { "logb", OpenCL_std, 0x29 }, // 151
  { "mad", OpenCL_std, 0x2A }, // 152
  { "MatrixInverse", GLSL_std_450, 0x22 }, // 153
  { "maxmag", OpenCL_std, 0x2B }, // 154
  { "minmag", OpenCL_std, 0x2C }, // 155
  { "mix", OpenCL_std, 0x63 }, // 156
  { "modf", OpenCL_std, 0x2D }, // 157
  { "Modf", GLSL_std_450, 0x23 }, // 158
  { "ModfStruct", GLSL_std_450, 0x24 }, // 159
  { "nan", OpenCL_std, 0x2E }, // 160
  { "native_cos", OpenCL_std, 0x51 }, // 161
  { "native_divide", OpenCL_std, 0x52 }, // 162
  { "native_exp", OpenCL_std, 0x53 }, // 163
  { "native_exp10", OpenCL_std, 0x55 }, // 164
  { "native_exp2", OpenCL_std, 0x54 }, // 165
  { "native_log", OpenCL_std, 0x56 }, // 166
  { "native_log10", OpenCL_std, 0x58 }, // 167
  { "native_log2", OpenCL_std, 0x57 }, // 168
  { "native_powr", OpenCL_std, 0x59 }, // 169
  { "native_recip", OpenCL_std, 0x5A }, // 170
  { "native_rsqrt", OpenCL_std, 0x5B }, // 171
  { "native_sin", OpenCL_std, 0x5C }, // 172
  { "native_sqrt", OpenCL_std, 0x5D }, // 173
  { "native_tan", OpenCL_std, 0x5E }, // 174
  { "NClamp", GLSL_std_450, 0x51 }, // 175
  { "nextafter", OpenCL_std, 0x2F }, // 176
  { "NMax", GLSL_std_450, 0x50 }, // 177
  { "NMin", GLSL_std_450, 0x4F }, // 178
  { "normalize", OpenCL_std, 0x6B }, // 179
  { "Normalize", GLSL_std_450, 0x45 }, // 180
  { "PackDouble2x32", GLSL_std_450, 0x3B }, // 181
  { "PackHalf2x16", GLSL_std_450, 0x3A }, // 182
  { "PackSnorm2x16", GLSL_std_450, 0x38 }, // 183
  { "PackSnorm4x8", GLSL_std_450, 0x36 }, // 184
  { "PackUnorm2x16", GLSL_std_450, 0x39 }, // 185
  { "PackUnorm4x8", GLSL_std_450, 0x37 }, // 186
  { "popcount", OpenCL_std, 0xA6 }, // 187
  { "pow", OpenCL_std, 0x30 }, // 188
  { "Pow", GLSL_std_450, 0x1A }, // 189
  { "pown", OpenCL_std, 0x31 }, // 190
  { "powr", OpenCL_std, 0x32 }, // 191
  { "prefetch", OpenCL_std, 0xB9 }, // 192
  { "printf", OpenCL_std, 0xB8 }, // 193
  { "radians", OpenCL_std, 0x64 }, // 194
  { "Radians", GLSL_std_450, 0xB }, // 195
  { "Reflect", GLSL_std_450, 0x47 }, // 196
  { "Refract", GLSL_std_450, 0x48 }, // 197
  { "remainder", OpenCL_std, 0x33 }, // 198
  { "remquo", OpenCL_std, 0x34 }, // 199
  { "rint", OpenCL_std, 0x35 }, // 200
  { "rootn", OpenCL_std, 0x36 }, // 201
  { "rotate", OpenCL_std, 0xA1 }, // 202
  { "round", OpenCL_std, 0x37 }, // 203
  { "Round", GLSL_std_450, 0x1 }, // 204
  { "RoundEven", GLSL_std_450, 0x2 }, // 205
  { "rsqrt", OpenCL_std, 0x38 }, // 206
  { "SAbs", GLSL_std_450, 0x5 }, // 207
  { "SClamp", GLSL_std_450, 0x2D }, // 208
  { "select", OpenCL_std, 0xBB }, // 209
  { "shuffle", OpenCL_std, 0xB6 }, // 210
  { "shuffle2", OpenCL_std, 0xB7 }, // 211
  { "sign", OpenCL_std, 0x67 }, // 212
  { "sin", OpenCL_std, 0x39 }, // 213
  { "Sin", GLSL_std_450, 0xD }, // 214
  { "sincos", OpenCL_std, 0x3A }, // 215
  { "sinh", OpenCL_std, 0x3B }, // 216
  { "Sinh", GLSL_std_450, 0x13 }, // 217
  { "sinpi", OpenCL_std, 0x3C }, // 218
  { "SMax", GLSL_std_450, 0x2A }, // 219
  { "SMin", GLSL_std_450, 0x27 }, // 220
  { "smoothstep", OpenCL_std, 0x66 }, // 221
  { "SmoothStep", GLSL_std_450, 0x31 }, // 222
  { "sqrt", OpenCL_std, 0x3D }, // 223
  { "Sqrt", GLSL_std_450, 0x1F }, // 224
  { "SSign", GLSL_std_450, 0x7 }, // 225
  { "step", OpenCL_std, 0x65 }, // 226
  { "Step", GLSL_std_450, 0x30 }, // 227
  { "s_abs", OpenCL_std, 0x8D }, // 228
  { "s_abs_diff", OpenCL_std, 0x8E }, // 229
  { "s_add_sat", OpenCL_std, 0x8F }, // 230
  { "s_clamp", OpenCL_std, 0x95 }, // 231
  { "s_hadd", OpenCL_std, 0x91 }, // 232
  { "s_mad24", OpenCL_std, 0xA7 }, // 233
  { "s_mad_hi", OpenCL_std, 0x99 }, // 234
  { "s_mad_sat", OpenCL_std, 0x9B }, // 235
  { "s_max", OpenCL_std, 0x9C }, // 236
  { "s_min", OpenCL_std, 0x9E }, // 237
  { "s_mul24", OpenCL_std, 0xA9 }, // 238
  { "s_mul_hi", OpenCL_std, 0xA0 }, // 239
  { "s_rhadd", OpenCL_std, 0x93 }, // 240
  { "s_sub_sat", OpenCL_std, 0xA2 }, // 241
  { "s_upsample", OpenCL_std, 0xA5 }, // 242
  { "tan", OpenCL_std, 0x3E }, // 243
  { "Tan", GLSL_std_450, 0xF }, // 244
  { "tanh", OpenCL_std, 0x3F }, // 245
  { "Tanh", GLSL_std_450, 0x15 }, // 246
  { "tanpi", OpenCL_std, 0x40 }, // 247
  { "tgamma", OpenCL_std, 0x41 }, // 248
  { "trunc", OpenCL_std, 0x42 }, // 249
  { "Trunc", GLSL_std_450, 0x3 }, // 250
  { "UClamp", GLSL_std_450, 0x2C }, // 251
  { "UMax", GLSL_std_450, 0x29 }, // 252
  { "UMin", GLSL_std_450, 0x26 }, // 253
  { "UnpackDouble2x32", GLSL_std_450, 0x41 }, // 254
  { "UnpackHalf2x16", GLSL_std_450, 0x3E }, // 255
  { "UnpackSnorm2x16", GLSL_std_450, 0x3C }, // 256
  { "UnpackSnorm4x8", GLSL_std_450, 0x3F }, // 257
  { "UnpackUnorm2x16", GLSL_std_450, 0x3D }, // 258
  { "UnpackUnorm4x8", GLSL_std_450, 0x40 }, // 259
  { "u_abs", OpenCL_std, 0xC9 }, // 260
  { "u_abs_diff", OpenCL_std, 0xCA }, // 261
  { "u_add_sat", OpenCL_std, 0x90 }, // 262
  { "u_clamp", OpenCL_std, 0x96 }, // 263
  { "u_hadd", OpenCL_std, 0x92 }, // 264
  { "u_mad24", OpenCL_std, 0xA8 }, // 265
  { "u_mad_hi", OpenCL_std, 0xCC }, // 266
  { "u_mad_sat", OpenCL_std, 0x9A }, // 267
  { "u_max", OpenCL_std, 0x9D }, // 268
  { "u_min", OpenCL_std, 0x9F }, // 269
  { "u_mul24", OpenCL_std, 0xAA }, // 270
  { "u_mul_hi", OpenCL_std, 0xCB }, // 271
  { "u_rhadd", OpenCL_std, 0x94 }, // 272
  { "u_sub_sat", OpenCL_std, 0xA3 }, // 273
  { "u_upsample", OpenCL_std, 0xA4 }, // 274
  { "vloada_halfn", OpenCL_std, 0xB3 }, // 275
  { "vloadn", OpenCL_std, 0xAB }, // 276
  { "vload_half", OpenCL_std, 0xAD }, // 277
  { "vload_halfn", OpenCL_std, 0xAE }, // 278
  { "vstorea_halfn", OpenCL_std, 0xB4 }, // 279
  { "vstorea_halfn_r", OpenCL_std, 0xB5 }, // 280
  { "vstoren", OpenCL_std, 0xAC }, // 281
  { "vstore_half", OpenCL_std, 0xAF }, // 282
  { "vstore_halfn", OpenCL_std, 0xB1 }, // 283
  { "vstore_halfn_r", OpenCL_std, 0xB2 }, // 284
  { "vstore_half_r", OpenCL_std, 0xB0 }, // 285
 };

const ExtendedBuiltin *lookupExtendedBuiltin(StringRef Name, unsigned Set) {
  struct IndexType {
    const char * Name;
    unsigned Set;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ACOS", OpenCL_std, 0 },
    { "ACOS", GLSL_std_450, 1 },
    { "ACOSH", OpenCL_std, 2 },
    { "ACOSH", GLSL_std_450, 3 },
    { "ACOSPI", OpenCL_std, 4 },
    { "ASIN", OpenCL_std, 5 },
    { "ASIN", GLSL_std_450, 6 },
    { "ASINH", OpenCL_std, 7 },
    { "ASINH", GLSL_std_450, 8 },
    { "ASINPI", OpenCL_std, 9 },
    { "ATAN", OpenCL_std, 10 },
    { "ATAN", GLSL_std_450, 11 },
    { "ATAN2", OpenCL_std, 12 },
    { "ATAN2", GLSL_std_450, 13 },
    { "ATAN2PI", OpenCL_std, 14 },
    { "ATANH", OpenCL_std, 15 },
    { "ATANH", GLSL_std_450, 16 },
    { "ATANPI", OpenCL_std, 17 },
    { "BITSELECT", OpenCL_std, 18 },
    { "CBRT", OpenCL_std, 19 },
    { "CEIL", OpenCL_std, 20 },
    { "CEIL", GLSL_std_450, 21 },
    { "CLZ", OpenCL_std, 22 },
    { "COPYSIGN", OpenCL_std, 23 },
    { "COS", OpenCL_std, 24 },
    { "COS", GLSL_std_450, 25 },
    { "COSH", OpenCL_std, 26 },
    { "COSH", GLSL_std_450, 27 },
    { "COSPI", OpenCL_std, 28 },
    { "CROSS", OpenCL_std, 29 },
    { "CROSS", GLSL_std_450, 30 },
    { "CTZ", OpenCL_std, 31 },
    { "DEBUGBUILDIDENTIFIER", NonSemantic_Shader_DebugInfo_100, 32 },
    { "DEBUGCOMPILATIONUNIT", NonSemantic_Shader_DebugInfo_100, 33 },
    { "DEBUGDECLARE", NonSemantic_Shader_DebugInfo_100, 34 },
    { "DEBUGENTRYPOINT", NonSemantic_Shader_DebugInfo_100, 35 },
    { "DEBUGEXPRESSION", NonSemantic_Shader_DebugInfo_100, 36 },
    { "DEBUGFUNCTION", NonSemantic_Shader_DebugInfo_100, 37 },
    { "DEBUGFUNCTIONDECLARATION", NonSemantic_Shader_DebugInfo_100, 38 },
    { "DEBUGFUNCTIONDEFINITION", NonSemantic_Shader_DebugInfo_100, 39 },
    { "DEBUGGLOBALVARIABLE", NonSemantic_Shader_DebugInfo_100, 40 },
    { "DEBUGIMPORTEDENTITY", NonSemantic_Shader_DebugInfo_100, 41 },
    { "DEBUGINFONONE", NonSemantic_Shader_DebugInfo_100, 42 },
    { "DEBUGINLINEDAT", NonSemantic_Shader_DebugInfo_100, 43 },
    { "DEBUGINLINEDVARIABLE", NonSemantic_Shader_DebugInfo_100, 44 },
    { "DEBUGLEXICALBLOCK", NonSemantic_Shader_DebugInfo_100, 45 },
    { "DEBUGLEXICALBLOCKDISCRIMINATOR", NonSemantic_Shader_DebugInfo_100, 46 },
    { "DEBUGLINE", NonSemantic_Shader_DebugInfo_100, 47 },
    { "DEBUGLOCALVARIABLE", NonSemantic_Shader_DebugInfo_100, 48 },
    { "DEBUGMACRODEF", NonSemantic_Shader_DebugInfo_100, 49 },
    { "DEBUGMACROUNDEF", NonSemantic_Shader_DebugInfo_100, 50 },
    { "DEBUGNOLINE", NonSemantic_Shader_DebugInfo_100, 51 },
    { "DEBUGNOSCOPE", NonSemantic_Shader_DebugInfo_100, 52 },
    { "DEBUGOPERATION", NonSemantic_Shader_DebugInfo_100, 53 },
    { "DEBUGSCOPE", NonSemantic_Shader_DebugInfo_100, 54 },
    { "DEBUGSOURCE", NonSemantic_Shader_DebugInfo_100, 55 },
    { "DEBUGSOURCECONTINUED", NonSemantic_Shader_DebugInfo_100, 56 },
    { "DEBUGSTORAGEPATH", NonSemantic_Shader_DebugInfo_100, 57 },
    { "DEBUGTYPEARRAY", NonSemantic_Shader_DebugInfo_100, 58 },
    { "DEBUGTYPEBASIC", NonSemantic_Shader_DebugInfo_100, 59 },
    { "DEBUGTYPECOMPOSITE", NonSemantic_Shader_DebugInfo_100, 60 },
    { "DEBUGTYPEDEF", NonSemantic_Shader_DebugInfo_100, 61 },
    { "DEBUGTYPEENUM", NonSemantic_Shader_DebugInfo_100, 62 },
    { "DEBUGTYPEFUNCTION", NonSemantic_Shader_DebugInfo_100, 63 },
    { "DEBUGTYPEINHERITANCE", NonSemantic_Shader_DebugInfo_100, 64 },
    { "DEBUGTYPEMATRIX", NonSemantic_Shader_DebugInfo_100, 65 },
    { "DEBUGTYPEMEMBER", NonSemantic_Shader_DebugInfo_100, 66 },
    { "DEBUGTYPEPOINTER", NonSemantic_Shader_DebugInfo_100, 67 },
    { "DEBUGTYPEPTRTOMEMBER", NonSemantic_Shader_DebugInfo_100, 68 },
    { "DEBUGTYPEQUALIFIER", NonSemantic_Shader_DebugInfo_100, 69 },
    { "DEBUGTYPETEMPLATE", NonSemantic_Shader_DebugInfo_100, 70 },
    { "DEBUGTYPETEMPLATEPARAMETER", NonSemantic_Shader_DebugInfo_100, 71 },
    { "DEBUGTYPETEMPLATEPARAMETERPACK", NonSemantic_Shader_DebugInfo_100, 72 },
    { "DEBUGTYPETEMPLATETEMPLATEPARAMETER", NonSemantic_Shader_DebugInfo_100, 73 },
    { "DEBUGTYPEVECTOR", NonSemantic_Shader_DebugInfo_100, 74 },
    { "DEBUGVALUE", NonSemantic_Shader_DebugInfo_100, 75 },
    { "DEGREES", OpenCL_std, 76 },
    { "DEGREES", GLSL_std_450, 77 },
    { "DETERMINANT", GLSL_std_450, 78 },
    { "DISTANCE", OpenCL_std, 79 },
    { "DISTANCE", GLSL_std_450, 80 },
    { "ERF", OpenCL_std, 81 },
    { "ERFC", OpenCL_std, 82 },
    { "EXP", OpenCL_std, 83 },
    { "EXP", GLSL_std_450, 84 },
    { "EXP10", OpenCL_std, 85 },
    { "EXP2", OpenCL_std, 86 },
    { "EXP2", GLSL_std_450, 87 },
    { "EXPM1", OpenCL_std, 88 },
    { "FABS", OpenCL_std, 89 },
    { "FABS", GLSL_std_450, 90 },
    { "FACEFORWARD", GLSL_std_450, 91 },
    { "FAST_DISTANCE", OpenCL_std, 92 },
    { "FAST_LENGTH", OpenCL_std, 93 },
    { "FAST_NORMALIZE", OpenCL_std, 94 },
    { "FCLAMP", OpenCL_std, 95 },
    { "FCLAMP", GLSL_std_450, 96 },
    { "FDIM", OpenCL_std, 97 },
    { "FINDILSB", GLSL_std_450, 98 },
    { "FINDSMSB", GLSL_std_450, 99 },
    { "FINDUMSB", GLSL_std_450, 100 },
    { "FLOOR", OpenCL_std, 101 },
    { "FLOOR", GLSL_std_450, 102 },
    { "FMA", OpenCL_std, 103 },
    { "FMA", GLSL_std_450, 104 },
    { "FMAX", OpenCL_std, 105 },
    { "FMAX", GLSL_std_450, 106 },
    { "FMAX_COMMON", OpenCL_std, 107 },
    { "FMIN", OpenCL_std, 108 },
    { "FMIN", GLSL_std_450, 109 },
    { "FMIN_COMMON", OpenCL_std, 110 },
    { "FMIX", GLSL_std_450, 111 },
    { "FMOD", OpenCL_std, 112 },
    { "FRACT", OpenCL_std, 113 },
    { "FRACT", GLSL_std_450, 114 },
    { "FREXP", OpenCL_std, 115 },
    { "FREXP", GLSL_std_450, 116 },
    { "FREXPSTRUCT", GLSL_std_450, 117 },
    { "FSIGN", GLSL_std_450, 118 },
    { "HALF_COS", OpenCL_std, 119 },
    { "HALF_DIVIDE", OpenCL_std, 120 },
    { "HALF_EXP", OpenCL_std, 121 },
    { "HALF_EXP10", OpenCL_std, 122 },
    { "HALF_EXP2", OpenCL_std, 123 },
    { "HALF_LOG", OpenCL_std, 124 },
    { "HALF_LOG10", OpenCL_std, 125 },
    { "HALF_LOG2", OpenCL_std, 126 },
    { "HALF_POWR", OpenCL_std, 127 },
    { "HALF_RECIP", OpenCL_std, 128 },
    { "HALF_RSQRT", OpenCL_std, 129 },
    { "HALF_SIN", OpenCL_std, 130 },
    { "HALF_SQRT", OpenCL_std, 131 },
    { "HALF_TAN", OpenCL_std, 132 },
    { "HYPOT", OpenCL_std, 133 },
    { "ILOGB", OpenCL_std, 134 },
    { "INTERPOLATEATCENTROID", GLSL_std_450, 135 },
    { "INTERPOLATEATOFFSET", GLSL_std_450, 136 },
    { "INTERPOLATEATSAMPLE", GLSL_std_450, 137 },
    { "INVERSESQRT", GLSL_std_450, 138 },
    { "LDEXP", OpenCL_std, 139 },
    { "LDEXP", GLSL_std_450, 140 },
    { "LENGTH", OpenCL_std, 141 },
    { "LENGTH", GLSL_std_450, 142 },
    { "LGAMMA", OpenCL_std, 143 },
    { "LGAMMA_R", OpenCL_std, 144 },
    { "LOG", OpenCL_std, 145 },
    { "LOG", GLSL_std_450, 146 },
    { "LOG10", OpenCL_std, 147 },
    { "LOG1P", OpenCL_std, 148 },
    { "LOG2", OpenCL_std, 149 },
    { "LOG2", GLSL_std_450, 150 },
    { "LOGB", OpenCL_std, 151 },
    { "MAD", OpenCL_std, 152 },
    { "MATRIXINVERSE", GLSL_std_450, 153 },
    { "MAXMAG", OpenCL_std, 154 },
    { "MINMAG", OpenCL_std, 155 },
    { "MIX", OpenCL_std, 156 },
    { "MODF", OpenCL_std, 157 },
    { "MODF", GLSL_std_450, 158 },
    { "MODFSTRUCT", GLSL_std_450, 159 },
    { "NAN", OpenCL_std, 160 },
    { "NATIVE_COS", OpenCL_std, 161 },
    { "NATIVE_DIVIDE", OpenCL_std, 162 },
    { "NATIVE_EXP", OpenCL_std, 163 },
    { "NATIVE_EXP10", OpenCL_std, 164 },
    { "NATIVE_EXP2", OpenCL_std, 165 },
    { "NATIVE_LOG", OpenCL_std, 166 },
    { "NATIVE_LOG10", OpenCL_std, 167 },
    { "NATIVE_LOG2", OpenCL_std, 168 },
    { "NATIVE_POWR", OpenCL_std, 169 },
    { "NATIVE_RECIP", OpenCL_std, 170 },
    { "NATIVE_RSQRT", OpenCL_std, 171 },
    { "NATIVE_SIN", OpenCL_std, 172 },
    { "NATIVE_SQRT", OpenCL_std, 173 },
    { "NATIVE_TAN", OpenCL_std, 174 },
    { "NCLAMP", GLSL_std_450, 175 },
    { "NEXTAFTER", OpenCL_std, 176 },
    { "NMAX", GLSL_std_450, 177 },
    { "NMIN", GLSL_std_450, 178 },
    { "NORMALIZE", OpenCL_std, 179 },
    { "NORMALIZE", GLSL_std_450, 180 },
    { "PACKDOUBLE2X32", GLSL_std_450, 181 },
    { "PACKHALF2X16", GLSL_std_450, 182 },
    { "PACKSNORM2X16", GLSL_std_450, 183 },
    { "PACKSNORM4X8", GLSL_std_450, 184 },
    { "PACKUNORM2X16", GLSL_std_450, 185 },
    { "PACKUNORM4X8", GLSL_std_450, 186 },
    { "POPCOUNT", OpenCL_std, 187 },
    { "POW", OpenCL_std, 188 },
    { "POW", GLSL_std_450, 189 },
    { "POWN", OpenCL_std, 190 },
    { "POWR", OpenCL_std, 191 },
    { "PREFETCH", OpenCL_std, 192 },
    { "PRINTF", OpenCL_std, 193 },
    { "RADIANS", OpenCL_std, 194 },
    { "RADIANS", GLSL_std_450, 195 },
    { "REFLECT", GLSL_std_450, 196 },
    { "REFRACT", GLSL_std_450, 197 },
    { "REMAINDER", OpenCL_std, 198 },
    { "REMQUO", OpenCL_std, 199 },
    { "RINT", OpenCL_std, 200 },
    { "ROOTN", OpenCL_std, 201 },
    { "ROTATE", OpenCL_std, 202 },
    { "ROUND", OpenCL_std, 203 },
    { "ROUND", GLSL_std_450, 204 },
    { "ROUNDEVEN", GLSL_std_450, 205 },
    { "RSQRT", OpenCL_std, 206 },
    { "SABS", GLSL_std_450, 207 },
    { "SCLAMP", GLSL_std_450, 208 },
    { "SELECT", OpenCL_std, 209 },
    { "SHUFFLE", OpenCL_std, 210 },
    { "SHUFFLE2", OpenCL_std, 211 },
    { "SIGN", OpenCL_std, 212 },
    { "SIN", OpenCL_std, 213 },
    { "SIN", GLSL_std_450, 214 },
    { "SINCOS", OpenCL_std, 215 },
    { "SINH", OpenCL_std, 216 },
    { "SINH", GLSL_std_450, 217 },
    { "SINPI", OpenCL_std, 218 },
    { "SMAX", GLSL_std_450, 219 },
    { "SMIN", GLSL_std_450, 220 },
    { "SMOOTHSTEP", OpenCL_std, 221 },
    { "SMOOTHSTEP", GLSL_std_450, 222 },
    { "SQRT", OpenCL_std, 223 },
    { "SQRT", GLSL_std_450, 224 },
    { "SSIGN", GLSL_std_450, 225 },
    { "STEP", OpenCL_std, 226 },
    { "STEP", GLSL_std_450, 227 },
    { "S_ABS", OpenCL_std, 228 },
    { "S_ABS_DIFF", OpenCL_std, 229 },
    { "S_ADD_SAT", OpenCL_std, 230 },
    { "S_CLAMP", OpenCL_std, 231 },
    { "S_HADD", OpenCL_std, 232 },
    { "S_MAD24", OpenCL_std, 233 },
    { "S_MAD_HI", OpenCL_std, 234 },
    { "S_MAD_SAT", OpenCL_std, 235 },
    { "S_MAX", OpenCL_std, 236 },
    { "S_MIN", OpenCL_std, 237 },
    { "S_MUL24", OpenCL_std, 238 },
    { "S_MUL_HI", OpenCL_std, 239 },
    { "S_RHADD", OpenCL_std, 240 },
    { "S_SUB_SAT", OpenCL_std, 241 },
    { "S_UPSAMPLE", OpenCL_std, 242 },
    { "TAN", OpenCL_std, 243 },
    { "TAN", GLSL_std_450, 244 },
    { "TANH", OpenCL_std, 245 },
    { "TANH", GLSL_std_450, 246 },
    { "TANPI", OpenCL_std, 247 },
    { "TGAMMA", OpenCL_std, 248 },
    { "TRUNC", OpenCL_std, 249 },
    { "TRUNC", GLSL_std_450, 250 },
    { "UCLAMP", GLSL_std_450, 251 },
    { "UMAX", GLSL_std_450, 252 },
    { "UMIN", GLSL_std_450, 253 },
    { "UNPACKDOUBLE2X32", GLSL_std_450, 254 },
    { "UNPACKHALF2X16", GLSL_std_450, 255 },
    { "UNPACKSNORM2X16", GLSL_std_450, 256 },
    { "UNPACKSNORM4X8", GLSL_std_450, 257 },
    { "UNPACKUNORM2X16", GLSL_std_450, 258 },
    { "UNPACKUNORM4X8", GLSL_std_450, 259 },
    { "U_ABS", OpenCL_std, 260 },
    { "U_ABS_DIFF", OpenCL_std, 261 },
    { "U_ADD_SAT", OpenCL_std, 262 },
    { "U_CLAMP", OpenCL_std, 263 },
    { "U_HADD", OpenCL_std, 264 },
    { "U_MAD24", OpenCL_std, 265 },
    { "U_MAD_HI", OpenCL_std, 266 },
    { "U_MAD_SAT", OpenCL_std, 267 },
    { "U_MAX", OpenCL_std, 268 },
    { "U_MIN", OpenCL_std, 269 },
    { "U_MUL24", OpenCL_std, 270 },
    { "U_MUL_HI", OpenCL_std, 271 },
    { "U_RHADD", OpenCL_std, 272 },
    { "U_SUB_SAT", OpenCL_std, 273 },
    { "U_UPSAMPLE", OpenCL_std, 274 },
    { "VLOADA_HALFN", OpenCL_std, 275 },
    { "VLOADN", OpenCL_std, 276 },
    { "VLOAD_HALF", OpenCL_std, 277 },
    { "VLOAD_HALFN", OpenCL_std, 278 },
    { "VSTOREA_HALFN", OpenCL_std, 279 },
    { "VSTOREA_HALFN_R", OpenCL_std, 280 },
    { "VSTOREN", OpenCL_std, 281 },
    { "VSTORE_HALF", OpenCL_std, 282 },
    { "VSTORE_HALFN", OpenCL_std, 283 },
    { "VSTORE_HALFN_R", OpenCL_std, 284 },
    { "VSTORE_HALF_R", OpenCL_std, 285 },
  };

  struct KeyType {
    std::string Name;
    unsigned Set;
  };
  KeyType Key = {Name.upper(), Set};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name ||
      Key.Set != Idx->Set)
    return nullptr;

  return &ExtendedBuiltins[Idx->_index];
}

const ExtendedBuiltin *lookupExtendedBuiltinBySetAndNumber(unsigned Set, uint32_t Number) {
  struct IndexType {
    unsigned Set;
    uint32_t Number;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { OpenCL_std, 0x0, 0 },
    { OpenCL_std, 0x1, 2 },
    { OpenCL_std, 0x2, 4 },
    { OpenCL_std, 0x3, 5 },
    { OpenCL_std, 0x4, 7 },
    { OpenCL_std, 0x5, 9 },
    { OpenCL_std, 0x6, 10 },
    { OpenCL_std, 0x7, 12 },
    { OpenCL_std, 0x8, 15 },
    { OpenCL_std, 0x9, 17 },
    { OpenCL_std, 0xA, 14 },
    { OpenCL_std, 0xB, 19 },
    { OpenCL_std, 0xC, 20 },
    { OpenCL_std, 0xD, 23 },
    { OpenCL_std, 0xE, 24 },
    { OpenCL_std, 0xF, 26 },
    { OpenCL_std, 0x10, 28 },
    { OpenCL_std, 0x11, 82 },
    { OpenCL_std, 0x12, 81 },
    { OpenCL_std, 0x13, 83 },
    { OpenCL_std, 0x14, 86 },
    { OpenCL_std, 0x15, 85 },
    { OpenCL_std, 0x16, 88 },
    { OpenCL_std, 0x17, 89 },
    { OpenCL_std, 0x18, 97 },
    { OpenCL_std, 0x19, 101 },
    { OpenCL_std, 0x1A, 103 },
    { OpenCL_std, 0x1B, 105 },
    { OpenCL_std, 0x1C, 108 },
    { OpenCL_std, 0x1D, 112 },
    { OpenCL_std, 0x1E, 113 },
    { OpenCL_std, 0x1F, 115 },
    { OpenCL_std, 0x20, 133 },
    { OpenCL_std, 0x21, 134 },
    { OpenCL_std, 0x22, 139 },
    { OpenCL_std, 0x23, 143 },
    { OpenCL_std, 0x24, 144 },
    { OpenCL_std, 0x25, 145 },
    { OpenCL_std, 0x26, 149 },
    { OpenCL_std, 0x27, 147 },
    { OpenCL_std, 0x28, 148 },
    { OpenCL_std, 0x29, 151 },
    { OpenCL_std, 0x2A, 152 },
    { OpenCL_std, 0x2B, 154 },
    { OpenCL_std, 0x2C, 155 },
    { OpenCL_std, 0x2D, 157 },
    { OpenCL_std, 0x2E, 160 },
    { OpenCL_std, 0x2F, 176 },
    { OpenCL_std, 0x30, 188 },
    { OpenCL_std, 0x31, 190 },
    { OpenCL_std, 0x32, 191 },
    { OpenCL_std, 0x33, 198 },
    { OpenCL_std, 0x34, 199 },
    { OpenCL_std, 0x35, 200 },
    { OpenCL_std, 0x36, 201 },
    { OpenCL_std, 0x37, 203 },
    { OpenCL_std, 0x38, 206 },
    { OpenCL_std, 0x39, 213 },
    { OpenCL_std, 0x3A, 215 },
    { OpenCL_std, 0x3B, 216 },
    { OpenCL_std, 0x3C, 218 },
    { OpenCL_std, 0x3D, 223 },
    { OpenCL_std, 0x3E, 243 },
    { OpenCL_std, 0x3F, 245 },
    { OpenCL_std, 0x40, 247 },
    { OpenCL_std, 0x41, 248 },
    { OpenCL_std, 0x42, 249 },
    { OpenCL_std, 0x43, 119 },
    { OpenCL_std, 0x44, 120 },
    { OpenCL_std, 0x45, 121 },
    { OpenCL_std, 0x46, 123 },
    { OpenCL_std, 0x47, 122 },
    { OpenCL_std, 0x48, 124 },
    { OpenCL_std, 0x49, 126 },
    { OpenCL_std, 0x4A, 125 },
    { OpenCL_std, 0x4B, 127 },
    { OpenCL_std, 0x4C, 128 },
    { OpenCL_std, 0x4D, 129 },
    { OpenCL_std, 0x4E, 130 },
    { OpenCL_std, 0x4F, 131 },
    { OpenCL_std, 0x50, 132 },
    { OpenCL_std, 0x51, 161 },
    { OpenCL_std, 0x52, 162 },
    { OpenCL_std, 0x53, 163 },
    { OpenCL_std, 0x54, 165 },
    { OpenCL_std, 0x55, 164 },
    { OpenCL_std, 0x56, 166 },
    { OpenCL_std, 0x57, 168 },
    { OpenCL_std, 0x58, 167 },
    { OpenCL_std, 0x59, 169 },
    { OpenCL_std, 0x5A, 170 },
    { OpenCL_std, 0x5B, 171 },
    { OpenCL_std, 0x5C, 172 },
    { OpenCL_std, 0x5D, 173 },
    { OpenCL_std, 0x5E, 174 },
    { OpenCL_std, 0x5F, 95 },
    { OpenCL_std, 0x60, 76 },
    { OpenCL_std, 0x61, 107 },
    { OpenCL_std, 0x62, 110 },
    { OpenCL_std, 0x63, 156 },
    { OpenCL_std, 0x64, 194 },
    { OpenCL_std, 0x65, 226 },
    { OpenCL_std, 0x66, 221 },
    { OpenCL_std, 0x67, 212 },
    { OpenCL_std, 0x68, 29 },
    { OpenCL_std, 0x69, 79 },
    { OpenCL_std, 0x6A, 141 },
    { OpenCL_std, 0x6B, 179 },
    { OpenCL_std, 0x6C, 92 },
    { OpenCL_std, 0x6D, 93 },
    { OpenCL_std, 0x6E, 94 },
    { OpenCL_std, 0x8D, 228 },
    { OpenCL_std, 0x8E, 229 },
    { OpenCL_std, 0x8F, 230 },
    { OpenCL_std, 0x90, 262 },
    { OpenCL_std, 0x91, 232 },
    { OpenCL_std, 0x92, 264 },
    { OpenCL_std, 0x93, 240 },
    { OpenCL_std, 0x94, 272 },
    { OpenCL_std, 0x95, 231 },
    { OpenCL_std, 0x96, 263 },
    { OpenCL_std, 0x97, 22 },
    { OpenCL_std, 0x98, 31 },
    { OpenCL_std, 0x99, 234 },
    { OpenCL_std, 0x9A, 267 },
    { OpenCL_std, 0x9B, 235 },
    { OpenCL_std, 0x9C, 236 },
    { OpenCL_std, 0x9D, 268 },
    { OpenCL_std, 0x9E, 237 },
    { OpenCL_std, 0x9F, 269 },
    { OpenCL_std, 0xA0, 239 },
    { OpenCL_std, 0xA1, 202 },
    { OpenCL_std, 0xA2, 241 },
    { OpenCL_std, 0xA3, 273 },
    { OpenCL_std, 0xA4, 274 },
    { OpenCL_std, 0xA5, 242 },
    { OpenCL_std, 0xA6, 187 },
    { OpenCL_std, 0xA7, 233 },
    { OpenCL_std, 0xA8, 265 },
    { OpenCL_std, 0xA9, 238 },
    { OpenCL_std, 0xAA, 270 },
    { OpenCL_std, 0xAB, 276 },
    { OpenCL_std, 0xAC, 281 },
    { OpenCL_std, 0xAD, 277 },
    { OpenCL_std, 0xAE, 278 },
    { OpenCL_std, 0xAF, 282 },
    { OpenCL_std, 0xB0, 285 },
    { OpenCL_std, 0xB1, 283 },
    { OpenCL_std, 0xB2, 284 },
    { OpenCL_std, 0xB3, 275 },
    { OpenCL_std, 0xB4, 279 },
    { OpenCL_std, 0xB5, 280 },
    { OpenCL_std, 0xB6, 210 },
    { OpenCL_std, 0xB7, 211 },
    { OpenCL_std, 0xB8, 193 },
    { OpenCL_std, 0xB9, 192 },
    { OpenCL_std, 0xBA, 18 },
    { OpenCL_std, 0xBB, 209 },
    { OpenCL_std, 0xC9, 260 },
    { OpenCL_std, 0xCA, 261 },
    { OpenCL_std, 0xCB, 271 },
    { OpenCL_std, 0xCC, 266 },
    { GLSL_std_450, 0x1, 204 },
    { GLSL_std_450, 0x2, 205 },
    { GLSL_std_450, 0x3, 250 },
    { GLSL_std_450, 0x4, 90 },
    { GLSL_std_450, 0x5, 207 },
    { GLSL_std_450, 0x6, 118 },
    { GLSL_std_450, 0x7, 225 },
    { GLSL_std_450, 0x8, 102 },
    { GLSL_std_450, 0x9, 21 },
    { GLSL_std_450, 0xA, 114 },
    { GLSL_std_450, 0xB, 195 },
    { GLSL_std_450, 0xC, 77 },
    { GLSL_std_450, 0xD, 214 },
    { GLSL_std_450, 0xE, 25 },
    { GLSL_std_450, 0xF, 244 },
    { GLSL_std_450, 0x10, 6 },
    { GLSL_std_450, 0x11, 1 },
    { GLSL_std_450, 0x12, 11 },
    { GLSL_std_450, 0x13, 217 },
    { GLSL_std_450, 0x14, 27 },
    { GLSL_std_450, 0x15, 246 },
    { GLSL_std_450, 0x16, 8 },
    { GLSL_std_450, 0x17, 3 },
    { GLSL_std_450, 0x18, 16 },
    { GLSL_std_450, 0x19, 13 },
    { GLSL_std_450, 0x1A, 189 },
    { GLSL_std_450, 0x1B, 84 },
    { GLSL_std_450, 0x1C, 146 },
    { GLSL_std_450, 0x1D, 87 },
    { GLSL_std_450, 0x1E, 150 },
    { GLSL_std_450, 0x1F, 224 },
    { GLSL_std_450, 0x20, 138 },
    { GLSL_std_450, 0x21, 78 },
    { GLSL_std_450, 0x22, 153 },
    { GLSL_std_450, 0x23, 158 },
    { GLSL_std_450, 0x24, 159 },
    { GLSL_std_450, 0x25, 109 },
    { GLSL_std_450, 0x26, 253 },
    { GLSL_std_450, 0x27, 220 },
    { GLSL_std_450, 0x28, 106 },
    { GLSL_std_450, 0x29, 252 },
    { GLSL_std_450, 0x2A, 219 },
    { GLSL_std_450, 0x2B, 96 },
    { GLSL_std_450, 0x2C, 251 },
    { GLSL_std_450, 0x2D, 208 },
    { GLSL_std_450, 0x2E, 111 },
    { GLSL_std_450, 0x30, 227 },
    { GLSL_std_450, 0x31, 222 },
    { GLSL_std_450, 0x32, 104 },
    { GLSL_std_450, 0x33, 116 },
    { GLSL_std_450, 0x34, 117 },
    { GLSL_std_450, 0x35, 140 },
    { GLSL_std_450, 0x36, 184 },
    { GLSL_std_450, 0x37, 186 },
    { GLSL_std_450, 0x38, 183 },
    { GLSL_std_450, 0x39, 185 },
    { GLSL_std_450, 0x3A, 182 },
    { GLSL_std_450, 0x3B, 181 },
    { GLSL_std_450, 0x3C, 256 },
    { GLSL_std_450, 0x3D, 258 },
    { GLSL_std_450, 0x3E, 255 },
    { GLSL_std_450, 0x3F, 257 },
    { GLSL_std_450, 0x40, 259 },
    { GLSL_std_450, 0x41, 254 },
    { GLSL_std_450, 0x42, 142 },
    { GLSL_std_450, 0x43, 80 },
    { GLSL_std_450, 0x44, 30 },
    { GLSL_std_450, 0x45, 180 },
    { GLSL_std_450, 0x46, 91 },
    { GLSL_std_450, 0x47, 196 },
    { GLSL_std_450, 0x48, 197 },
    { GLSL_std_450, 0x49, 98 },
    { GLSL_std_450, 0x4A, 99 },
    { GLSL_std_450, 0x4B, 100 },
    { GLSL_std_450, 0x4C, 135 },
    { GLSL_std_450, 0x4D, 137 },
    { GLSL_std_450, 0x4E, 136 },
    { GLSL_std_450, 0x4F, 178 },
    { GLSL_std_450, 0x50, 177 },
    { GLSL_std_450, 0x51, 175 },
    { NonSemantic_Shader_DebugInfo_100, 0x0, 42 },
    { NonSemantic_Shader_DebugInfo_100, 0x1, 33 },
    { NonSemantic_Shader_DebugInfo_100, 0x2, 59 },
    { NonSemantic_Shader_DebugInfo_100, 0x3, 67 },
    { NonSemantic_Shader_DebugInfo_100, 0x4, 69 },
    { NonSemantic_Shader_DebugInfo_100, 0x5, 58 },
    { NonSemantic_Shader_DebugInfo_100, 0x6, 74 },
    { NonSemantic_Shader_DebugInfo_100, 0x7, 61 },
    { NonSemantic_Shader_DebugInfo_100, 0x8, 63 },
    { NonSemantic_Shader_DebugInfo_100, 0x9, 62 },
    { NonSemantic_Shader_DebugInfo_100, 0xA, 60 },
    { NonSemantic_Shader_DebugInfo_100, 0xB, 66 },
    { NonSemantic_Shader_DebugInfo_100, 0xC, 64 },
    { NonSemantic_Shader_DebugInfo_100, 0xD, 68 },
    { NonSemantic_Shader_DebugInfo_100, 0xE, 70 },
    { NonSemantic_Shader_DebugInfo_100, 0xF, 71 },
    { NonSemantic_Shader_DebugInfo_100, 0x10, 73 },
    { NonSemantic_Shader_DebugInfo_100, 0x11, 72 },
    { NonSemantic_Shader_DebugInfo_100, 0x12, 40 },
    { NonSemantic_Shader_DebugInfo_100, 0x13, 38 },
    { NonSemantic_Shader_DebugInfo_100, 0x14, 37 },
    { NonSemantic_Shader_DebugInfo_100, 0x15, 45 },
    { NonSemantic_Shader_DebugInfo_100, 0x16, 46 },
    { NonSemantic_Shader_DebugInfo_100, 0x17, 54 },
    { NonSemantic_Shader_DebugInfo_100, 0x18, 52 },
    { NonSemantic_Shader_DebugInfo_100, 0x19, 43 },
    { NonSemantic_Shader_DebugInfo_100, 0x1A, 48 },
    { NonSemantic_Shader_DebugInfo_100, 0x1B, 44 },
    { NonSemantic_Shader_DebugInfo_100, 0x1C, 34 },
    { NonSemantic_Shader_DebugInfo_100, 0x1D, 75 },
    { NonSemantic_Shader_DebugInfo_100, 0x1E, 53 },
    { NonSemantic_Shader_DebugInfo_100, 0x1F, 36 },
    { NonSemantic_Shader_DebugInfo_100, 0x20, 49 },
    { NonSemantic_Shader_DebugInfo_100, 0x21, 50 },
    { NonSemantic_Shader_DebugInfo_100, 0x22, 41 },
    { NonSemantic_Shader_DebugInfo_100, 0x23, 55 },
    { NonSemantic_Shader_DebugInfo_100, 0x65, 39 },
    { NonSemantic_Shader_DebugInfo_100, 0x66, 56 },
    { NonSemantic_Shader_DebugInfo_100, 0x67, 47 },
    { NonSemantic_Shader_DebugInfo_100, 0x68, 51 },
    { NonSemantic_Shader_DebugInfo_100, 0x69, 32 },
    { NonSemantic_Shader_DebugInfo_100, 0x6A, 57 },
    { NonSemantic_Shader_DebugInfo_100, 0x6B, 35 },
    { NonSemantic_Shader_DebugInfo_100, 0x6C, 65 },
  };

  struct KeyType {
    unsigned Set;
    uint32_t Number;
  };
  KeyType Key = {Set, Number};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      if (LHS.Number < RHS.Number)
        return true;
      if (LHS.Number > RHS.Number)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Set != Idx->Set ||
      Key.Number != Idx->Number)
    return nullptr;

  return &ExtendedBuiltins[Idx->_index];
}
#endif

#ifdef GET_ExtensionEntries_DECL
const ExtensionEntry *lookupExtensionByCategoryAndValue(unsigned Category, uint32_t Value);
const ExtensionEntry *lookupSymbolicOperandsEnabledByExtension(unsigned ReqExtension, unsigned Category);
#endif

#ifdef GET_ExtensionEntries_IMPL
constexpr ExtensionEntry ExtensionEntries[] = {
  { CapabilityOperand, 0x1147, SPV_KHR_shader_ballot }, // 0
  { CapabilityOperand, 0x114B, SPV_KHR_shader_draw_parameters }, // 1
  { CapabilityOperand, 0x114F, SPV_KHR_subgroup_vote }, // 2
  { CapabilityOperand, 0x1151, SPV_KHR_16bit_storage }, // 3
  { CapabilityOperand, 0x1152, SPV_KHR_16bit_storage }, // 4
  { CapabilityOperand, 0x1153, SPV_KHR_16bit_storage }, // 5
  { CapabilityOperand, 0x1154, SPV_KHR_16bit_storage }, // 6
  { CapabilityOperand, 0x1155, SPV_KHR_device_group }, // 7
  { CapabilityOperand, 0x1157, SPV_KHR_multiview }, // 8
  { CapabilityOperand, 0x1159, SPV_KHR_variable_pointers }, // 9
  { CapabilityOperand, 0x115A, SPV_KHR_variable_pointers }, // 10
  { CapabilityOperand, 0x115D, SPV_KHR_shader_atomic_counter_ops }, // 11
  { CapabilityOperand, 0x115F, SPV_KHR_post_depth_coverage }, // 12
  { CapabilityOperand, 0x1160, SPV_KHR_8bit_storage }, // 13
  { CapabilityOperand, 0x1161, SPV_KHR_8bit_storage }, // 14
  { CapabilityOperand, 0x1162, SPV_KHR_8bit_storage }, // 15
  { CapabilityOperand, 0x1170, SPV_KHR_float_controls }, // 16
  { CapabilityOperand, 0x1171, SPV_KHR_float_controls }, // 17
  { CapabilityOperand, 0x1172, SPV_KHR_float_controls }, // 18
  { CapabilityOperand, 0x1173, SPV_KHR_float_controls }, // 19
  { CapabilityOperand, 0x1174, SPV_KHR_float_controls }, // 20
  { CapabilityOperand, 0x13BF, SPV_KHR_shader_clock }, // 21
  { CapabilityOperand, 0x1503, SPV_EXT_demote_to_helper_invocation }, // 22
  { CapabilityOperand, 0x15C0, SPV_INTEL_subgroups }, // 23
  { CapabilityOperand, 0x15C1, SPV_INTEL_subgroups }, // 24
  { CapabilityOperand, 0x15C2, SPV_INTEL_subgroups }, // 25
  { CapabilityOperand, 0x15CB, SPV_INTEL_media_block_io }, // 26
  { CapabilityOperand, 0x15CE, SPV_INTEL_float_controls2 }, // 27
  { CapabilityOperand, 0x15CF, SPV_INTEL_float_controls2 }, // 28
  { CapabilityOperand, 0x15E3, SPV_INTEL_function_pointers }, // 29
  { CapabilityOperand, 0x15E4, SPV_INTEL_function_pointers }, // 30
  { CapabilityOperand, 0x15E6, SPV_INTEL_inline_assembly }, // 31
  { CapabilityOperand, 0x15EC, SPV_EXT_shader_atomic_float_min_max }, // 32
  { CapabilityOperand, 0x15ED, SPV_EXT_shader_atomic_float_min_max }, // 33
  { CapabilityOperand, 0x15F0, SPV_EXT_shader_atomic_float_min_max }, // 34
  { CapabilityOperand, 0x15FD, SPV_KHR_expect_assume }, // 35
  { CapabilityOperand, 0x16B9, SPV_INTEL_variable_length_array }, // 36
  { CapabilityOperand, 0x16BD, SPV_INTEL_float_controls2 }, // 37
  { CapabilityOperand, 0x16D4, SPV_INTEL_arbitrary_precision_integers }, // 38
  { CapabilityOperand, 0x172F, SPV_INTEL_usm_storage_classes }, // 39
  { CapabilityOperand, 0x1780, SPV_KHR_integer_dot_product }, // 40
  { CapabilityOperand, 0x1781, SPV_KHR_integer_dot_product }, // 41
  { CapabilityOperand, 0x1782, SPV_KHR_integer_dot_product }, // 42
  { CapabilityOperand, 0x1783, SPV_KHR_integer_dot_product }, // 43
  { CapabilityOperand, 0x1786, SPV_KHR_cooperative_matrix }, // 44
  { CapabilityOperand, 0x1789, SPV_KHR_bit_instructions }, // 45
  { CapabilityOperand, 0x178A, SPV_KHR_subgroup_rotate }, // 46
  { CapabilityOperand, 0x1791, SPV_EXT_shader_atomic_float_add }, // 47
  { CapabilityOperand, 0x1792, SPV_EXT_shader_atomic_float_add }, // 48
  { CapabilityOperand, 0x17CE, SPV_INTEL_optnone }, // 49
  { CapabilityOperand, 0x17CE, SPV_EXT_optnone }, // 50
  { CapabilityOperand, 0x17CF, SPV_EXT_shader_atomic_float16_add }, // 51
  { CapabilityOperand, 0x17E3, SPV_INTEL_bfloat16_conversion }, // 52
  { CapabilityOperand, 0x17FD, SPV_INTEL_split_barrier }, // 53
  { CapabilityOperand, 0x1800, SPV_EXT_arithmetic_fence }, // 54
  { CapabilityOperand, 0x182B, SPV_INTEL_global_variable_host_access }, // 55
  { CapabilityOperand, 0x182C, SPV_INTEL_global_variable_host_access }, // 56
  { CapabilityOperand, 0x182D, SPV_INTEL_global_variable_fpga_decorations }, // 57
  { CapabilityOperand, 0x1830, SPV_INTEL_joint_matrix }, // 58
  { CapabilityOperand, 0x1900, SPV_KHR_uniform_group_instructions }, // 59
  { CapabilityOperand, 0x190B, SPV_INTEL_joint_matrix }, // 60
  { CapabilityOperand, 0x1922, SPV_INTEL_joint_matrix }, // 61
  { CapabilityOperand, 0x1923, SPV_INTEL_joint_matrix }, // 62
  { CapabilityOperand, 0x1924, SPV_INTEL_joint_matrix }, // 63
  { CapabilityOperand, 0x1925, SPV_INTEL_joint_matrix }, // 64
  { CapabilityOperand, 0x1929, SPV_INTEL_cache_controls }, // 65
  { CooperativeMatrixLayoutOperand, 0x0, SPV_KHR_cooperative_matrix }, // 66
  { CooperativeMatrixLayoutOperand, 0x1, SPV_KHR_cooperative_matrix }, // 67
  { CooperativeMatrixLayoutOperand, 0x2, SPV_INTEL_joint_matrix }, // 68
  { CooperativeMatrixOperandsOperand, 0x0, SPV_KHR_cooperative_matrix }, // 69
  { CooperativeMatrixOperandsOperand, 0x1, SPV_KHR_cooperative_matrix }, // 70
  { CooperativeMatrixOperandsOperand, 0x2, SPV_KHR_cooperative_matrix }, // 71
  { CooperativeMatrixOperandsOperand, 0x4, SPV_KHR_cooperative_matrix }, // 72
  { CooperativeMatrixOperandsOperand, 0x8, SPV_KHR_cooperative_matrix }, // 73
  { CooperativeMatrixOperandsOperand, 0x10, SPV_KHR_cooperative_matrix }, // 74
  { CooperativeMatrixOperandsOperand, 0x20, SPV_INTEL_joint_matrix }, // 75
  { CooperativeMatrixOperandsOperand, 0x40, SPV_INTEL_joint_matrix }, // 76
  { CooperativeMatrixOperandsOperand, 0x80, SPV_INTEL_joint_matrix }, // 77
  { CooperativeMatrixOperandsOperand, 0x100, SPV_INTEL_joint_matrix }, // 78
  { DecorationOperand, 0x1175, SPV_KHR_no_integer_wrap_decoration }, // 79
  { DecorationOperand, 0x1176, SPV_KHR_no_integer_wrap_decoration }, // 80
  { DecorationOperand, 0x15E7, SPV_INTEL_inline_assembly }, // 81
  { DecorationOperand, 0x15E8, SPV_INTEL_inline_assembly }, // 82
  { StorageClassOperand, 0x15E5, SPV_INTEL_function_pointers }, // 83
  { StorageClassOperand, 0x1730, SPV_INTEL_usm_storage_classes }, // 84
  { StorageClassOperand, 0x1731, SPV_INTEL_usm_storage_classes }, // 85
 };

const ExtensionEntry *lookupExtensionByCategoryAndValue(unsigned Category, uint32_t Value) {
  struct KeyType {
    unsigned Category;
    uint32_t Value;
  };
  KeyType Key = {Category, Value};
  struct Comp {
    bool operator()(const ExtensionEntry &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Category < (unsigned)RHS.Category)
        return true;
      if ((unsigned)LHS.Category > (unsigned)RHS.Category)
        return false;
      if (LHS.Value < RHS.Value)
        return true;
      if (LHS.Value > RHS.Value)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(ExtensionEntries);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Category != Idx->Category ||
      Key.Value != Idx->Value)
    return nullptr;

  return &*Idx;
}

const ExtensionEntry *lookupSymbolicOperandsEnabledByExtension(unsigned ReqExtension, unsigned Category) {
  struct IndexType {
    unsigned ReqExtension;
    unsigned Category;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { SPV_KHR_shader_ballot, CapabilityOperand, 0 },
    { SPV_KHR_shader_draw_parameters, CapabilityOperand, 1 },
    { SPV_KHR_subgroup_vote, CapabilityOperand, 2 },
    { SPV_KHR_16bit_storage, CapabilityOperand, 3 },
    { SPV_KHR_16bit_storage, CapabilityOperand, 4 },
    { SPV_KHR_16bit_storage, CapabilityOperand, 5 },
    { SPV_KHR_16bit_storage, CapabilityOperand, 6 },
    { SPV_KHR_device_group, CapabilityOperand, 7 },
    { SPV_KHR_multiview, CapabilityOperand, 8 },
    { SPV_KHR_variable_pointers, CapabilityOperand, 9 },
    { SPV_KHR_variable_pointers, CapabilityOperand, 10 },
    { SPV_KHR_post_depth_coverage, CapabilityOperand, 12 },
    { SPV_KHR_shader_atomic_counter_ops, CapabilityOperand, 11 },
    { SPV_KHR_8bit_storage, CapabilityOperand, 13 },
    { SPV_KHR_8bit_storage, CapabilityOperand, 14 },
    { SPV_KHR_8bit_storage, CapabilityOperand, 15 },
    { SPV_INTEL_subgroups, CapabilityOperand, 23 },
    { SPV_INTEL_subgroups, CapabilityOperand, 24 },
    { SPV_INTEL_subgroups, CapabilityOperand, 25 },
    { SPV_INTEL_media_block_io, CapabilityOperand, 26 },
    { SPV_KHR_no_integer_wrap_decoration, DecorationOperand, 79 },
    { SPV_KHR_no_integer_wrap_decoration, DecorationOperand, 80 },
    { SPV_KHR_float_controls, CapabilityOperand, 16 },
    { SPV_KHR_float_controls, CapabilityOperand, 17 },
    { SPV_KHR_float_controls, CapabilityOperand, 18 },
    { SPV_KHR_float_controls, CapabilityOperand, 19 },
    { SPV_KHR_float_controls, CapabilityOperand, 20 },
    { SPV_KHR_shader_clock, CapabilityOperand, 21 },
    { SPV_EXT_demote_to_helper_invocation, CapabilityOperand, 22 },
    { SPV_INTEL_arbitrary_precision_integers, CapabilityOperand, 38 },
    { SPV_EXT_shader_atomic_float_add, CapabilityOperand, 47 },
    { SPV_EXT_shader_atomic_float_add, CapabilityOperand, 48 },
    { SPV_EXT_shader_atomic_float_min_max, CapabilityOperand, 32 },
    { SPV_EXT_shader_atomic_float_min_max, CapabilityOperand, 33 },
    { SPV_EXT_shader_atomic_float_min_max, CapabilityOperand, 34 },
    { SPV_KHR_expect_assume, CapabilityOperand, 35 },
    { SPV_KHR_integer_dot_product, CapabilityOperand, 40 },
    { SPV_KHR_integer_dot_product, CapabilityOperand, 41 },
    { SPV_KHR_integer_dot_product, CapabilityOperand, 42 },
    { SPV_KHR_integer_dot_product, CapabilityOperand, 43 },
    { SPV_EXT_shader_atomic_float16_add, CapabilityOperand, 51 },
    { SPV_KHR_bit_instructions, CapabilityOperand, 45 },
    { SPV_KHR_uniform_group_instructions, CapabilityOperand, 59 },
    { SPV_KHR_subgroup_rotate, CapabilityOperand, 46 },
    { SPV_INTEL_split_barrier, CapabilityOperand, 53 },
    { SPV_INTEL_usm_storage_classes, CapabilityOperand, 39 },
    { SPV_INTEL_usm_storage_classes, StorageClassOperand, 84 },
    { SPV_INTEL_usm_storage_classes, StorageClassOperand, 85 },
    { SPV_INTEL_optnone, CapabilityOperand, 49 },
    { SPV_INTEL_function_pointers, CapabilityOperand, 29 },
    { SPV_INTEL_function_pointers, CapabilityOperand, 30 },
    { SPV_INTEL_function_pointers, StorageClassOperand, 83 },
    { SPV_INTEL_variable_length_array, CapabilityOperand, 36 },
    { SPV_INTEL_bfloat16_conversion, CapabilityOperand, 52 },
    { SPV_INTEL_inline_assembly, CapabilityOperand, 31 },
    { SPV_INTEL_inline_assembly, DecorationOperand, 81 },
    { SPV_INTEL_inline_assembly, DecorationOperand, 82 },
    { SPV_INTEL_cache_controls, CapabilityOperand, 65 },
    { SPV_INTEL_global_variable_host_access, CapabilityOperand, 55 },
    { SPV_INTEL_global_variable_host_access, CapabilityOperand, 56 },
    { SPV_INTEL_global_variable_fpga_decorations, CapabilityOperand, 57 },
    { SPV_KHR_cooperative_matrix, CapabilityOperand, 44 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixLayoutOperand, 66 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixLayoutOperand, 67 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixOperandsOperand, 69 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixOperandsOperand, 70 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixOperandsOperand, 71 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixOperandsOperand, 72 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixOperandsOperand, 73 },
    { SPV_KHR_cooperative_matrix, CooperativeMatrixOperandsOperand, 74 },
    { SPV_EXT_arithmetic_fence, CapabilityOperand, 54 },
    { SPV_EXT_optnone, CapabilityOperand, 50 },
    { SPV_INTEL_joint_matrix, CapabilityOperand, 58 },
    { SPV_INTEL_joint_matrix, CapabilityOperand, 60 },
    { SPV_INTEL_joint_matrix, CapabilityOperand, 61 },
    { SPV_INTEL_joint_matrix, CapabilityOperand, 62 },
    { SPV_INTEL_joint_matrix, CapabilityOperand, 63 },
    { SPV_INTEL_joint_matrix, CapabilityOperand, 64 },
    { SPV_INTEL_joint_matrix, CooperativeMatrixLayoutOperand, 68 },
    { SPV_INTEL_joint_matrix, CooperativeMatrixOperandsOperand, 75 },
    { SPV_INTEL_joint_matrix, CooperativeMatrixOperandsOperand, 76 },
    { SPV_INTEL_joint_matrix, CooperativeMatrixOperandsOperand, 77 },
    { SPV_INTEL_joint_matrix, CooperativeMatrixOperandsOperand, 78 },
    { SPV_INTEL_float_controls2, CapabilityOperand, 27 },
    { SPV_INTEL_float_controls2, CapabilityOperand, 28 },
    { SPV_INTEL_float_controls2, CapabilityOperand, 37 },
  };

  struct KeyType {
    unsigned ReqExtension;
    unsigned Category;
  };
  KeyType Key = {ReqExtension, Category};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.ReqExtension < (unsigned)RHS.ReqExtension)
        return true;
      if ((unsigned)LHS.ReqExtension > (unsigned)RHS.ReqExtension)
        return false;
      if ((unsigned)LHS.Category < (unsigned)RHS.Category)
        return true;
      if ((unsigned)LHS.Category > (unsigned)RHS.Category)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.ReqExtension != Idx->ReqExtension ||
      Key.Category != Idx->Category)
    return nullptr;

  return &ExtensionEntries[Idx->_index];
}
#endif

#ifdef GET_GetBuiltins_DECL
const GetBuiltin *lookupGetBuiltin(StringRef Name, unsigned Set);
#endif

#ifdef GET_GetBuiltins_IMPL
constexpr GetBuiltin GetBuiltins[] = {
  { "get_enqueued_local_size", OpenCL_std, EnqueuedWorkgroupSize }, // 0
  { "get_global_id", OpenCL_std, GlobalInvocationId }, // 1
  { "get_global_size", OpenCL_std, GlobalSize }, // 2
  { "get_group_id", OpenCL_std, WorkgroupId }, // 3
  { "get_local_id", OpenCL_std, LocalInvocationId }, // 4
  { "get_local_size", OpenCL_std, WorkgroupSize }, // 5
  { "get_num_groups", OpenCL_std, NumWorkgroups }, // 6
  { "get_sub_group_eq_mask", OpenCL_std, SubgroupEqMask }, // 7
  { "get_sub_group_ge_mask", OpenCL_std, SubgroupGeMask }, // 8
  { "get_sub_group_gt_mask", OpenCL_std, SubgroupGtMask }, // 9
  { "get_sub_group_le_mask", OpenCL_std, SubgroupLeMask }, // 10
  { "get_sub_group_lt_mask", OpenCL_std, SubgroupLtMask }, // 11
  { "__hlsl_wave_get_lane_index", GLSL_std_450, SubgroupLocalInvocationId }, // 12
  { "__spirv_BuiltInGlobalInvocationId", OpenCL_std, GlobalInvocationId }, // 13
  { "__spirv_BuiltInGlobalLinearId", OpenCL_std, GlobalLinearId }, // 14
 };

const GetBuiltin *lookupGetBuiltin(StringRef Name, unsigned Set) {
  struct IndexType {
    const char * Name;
    unsigned Set;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "GET_ENQUEUED_LOCAL_SIZE", OpenCL_std, 0 },
    { "GET_GLOBAL_ID", OpenCL_std, 1 },
    { "GET_GLOBAL_SIZE", OpenCL_std, 2 },
    { "GET_GROUP_ID", OpenCL_std, 3 },
    { "GET_LOCAL_ID", OpenCL_std, 4 },
    { "GET_LOCAL_SIZE", OpenCL_std, 5 },
    { "GET_NUM_GROUPS", OpenCL_std, 6 },
    { "GET_SUB_GROUP_EQ_MASK", OpenCL_std, 7 },
    { "GET_SUB_GROUP_GE_MASK", OpenCL_std, 8 },
    { "GET_SUB_GROUP_GT_MASK", OpenCL_std, 9 },
    { "GET_SUB_GROUP_LE_MASK", OpenCL_std, 10 },
    { "GET_SUB_GROUP_LT_MASK", OpenCL_std, 11 },
    { "__HLSL_WAVE_GET_LANE_INDEX", GLSL_std_450, 12 },
    { "__SPIRV_BUILTINGLOBALINVOCATIONID", OpenCL_std, 13 },
    { "__SPIRV_BUILTINGLOBALLINEARID", OpenCL_std, 14 },
  };

  struct KeyType {
    std::string Name;
    unsigned Set;
  };
  KeyType Key = {Name.upper(), Set};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name ||
      Key.Set != Idx->Set)
    return nullptr;

  return &GetBuiltins[Idx->_index];
}
#endif

#ifdef GET_GroupBuiltins_DECL
const GroupBuiltin *lookupGroupBuiltin(StringRef Name);
#endif

#ifdef GET_GroupBuiltins_IMPL
constexpr GroupBuiltin GroupBuiltins[] = {
  { "sub_group_all", OpGroupAll, 0x0, false, true, false, false, false, false, false, false, true, true }, // 0
  { "sub_group_any", OpGroupAny, 0x0, false, true, false, false, false, false, false, false, true, true }, // 1
  { "sub_group_ballot", OpGroupNonUniformBallot, 0x0, false, false, false, true, false, false, false, false, true, true }, // 2
  { "sub_group_ballot_bit_count", OpGroupNonUniformBallotBitCount, 0x0, false, false, false, false, false, false, false, false, false, false }, // 3
  { "sub_group_ballot_bit_extract", OpGroupNonUniformBallotBitExtract, 0x0, false, false, false, false, false, true, false, false, true, false }, // 4
  { "sub_group_ballot_exclusive_scan", OpGroupNonUniformBallotBitCount, 0x2, false, false, false, false, false, false, false, false, false, false }, // 5
  { "sub_group_ballot_find_lsb", OpGroupNonUniformBallotFindLSB, 0x0, false, false, false, false, false, false, true, false, true, false }, // 6
  { "sub_group_ballot_find_msb", OpGroupNonUniformBallotFindMSB, 0x0, false, false, false, false, false, false, true, false, true, false }, // 7
  { "sub_group_ballot_inclusive_scan", OpGroupNonUniformBallotBitCount, 0x1, false, false, false, false, false, false, false, false, false, false }, // 8
  { "sub_group_broadcast", OpGroupBroadcast, 0x0, false, false, false, false, false, false, false, false, true, false }, // 9
  { "sub_group_broadcast_first", OpGroupNonUniformBroadcastFirst, 0x0, false, false, false, false, false, false, false, false, true, false }, // 10
  { "sub_group_clustered_reduce_addd", OpGroupNonUniformFAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 11
  { "sub_group_clustered_reduce_addf", OpGroupNonUniformFAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 12
  { "sub_group_clustered_reduce_addh", OpGroupNonUniformFAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 13
  { "sub_group_clustered_reduce_adds", OpGroupNonUniformIAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 14
  { "sub_group_clustered_reduce_addu", OpGroupNonUniformIAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 15
  { "sub_group_clustered_reduce_ands", OpGroupNonUniformBitwiseAnd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 16
  { "sub_group_clustered_reduce_andu", OpGroupNonUniformBitwiseAnd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 17
  { "sub_group_clustered_reduce_logical_and", OpGroupNonUniformLogicalAnd, 0x3, false, false, false, false, false, false, false, true, false, true }, // 18
  { "sub_group_clustered_reduce_logical_or", OpGroupNonUniformLogicalOr, 0x3, false, false, false, false, false, false, false, true, false, true }, // 19
  { "sub_group_clustered_reduce_logical_xor", OpGroupNonUniformLogicalXor, 0x3, false, false, false, false, false, false, false, true, false, true }, // 20
  { "sub_group_clustered_reduce_maxd", OpGroupNonUniformFMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 21
  { "sub_group_clustered_reduce_maxf", OpGroupNonUniformFMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 22
  { "sub_group_clustered_reduce_maxh", OpGroupNonUniformFMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 23
  { "sub_group_clustered_reduce_maxs", OpGroupNonUniformSMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 24
  { "sub_group_clustered_reduce_maxu", OpGroupNonUniformUMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 25
  { "sub_group_clustered_reduce_mind", OpGroupNonUniformFMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 26
  { "sub_group_clustered_reduce_minf", OpGroupNonUniformFMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 27
  { "sub_group_clustered_reduce_minh", OpGroupNonUniformFMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 28
  { "sub_group_clustered_reduce_mins", OpGroupNonUniformSMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 29
  { "sub_group_clustered_reduce_minu", OpGroupNonUniformUMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 30
  { "sub_group_clustered_reduce_muld", OpGroupNonUniformFMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 31
  { "sub_group_clustered_reduce_mulf", OpGroupNonUniformFMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 32
  { "sub_group_clustered_reduce_mulh", OpGroupNonUniformFMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 33
  { "sub_group_clustered_reduce_muls", OpGroupNonUniformIMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 34
  { "sub_group_clustered_reduce_mulu", OpGroupNonUniformIMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 35
  { "sub_group_clustered_reduce_ors", OpGroupNonUniformBitwiseOr, 0x3, false, false, false, false, false, false, false, false, false, false }, // 36
  { "sub_group_clustered_reduce_oru", OpGroupNonUniformBitwiseOr, 0x3, false, false, false, false, false, false, false, false, false, false }, // 37
  { "sub_group_clustered_reduce_xors", OpGroupNonUniformBitwiseXor, 0x3, false, false, false, false, false, false, false, false, false, false }, // 38
  { "sub_group_clustered_reduce_xoru", OpGroupNonUniformBitwiseXor, 0x3, false, false, false, false, false, false, false, false, false, false }, // 39
  { "sub_group_clustered_rotate", OpGroupNonUniformRotateKHR, 0x0, false, false, false, false, false, false, false, false, true, false }, // 40
  { "sub_group_elect", OpGroupNonUniformElect, 0x0, true, false, false, false, false, false, false, false, true, false }, // 41
  { "sub_group_fadd", OpGroupFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 42
  { "sub_group_fmax", OpGroupFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 43
  { "sub_group_fmin", OpGroupFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 44
  { "sub_group_iadd", OpGroupIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 45
  { "sub_group_inverse_ballot", OpGroupNonUniformInverseBallot, 0x0, false, false, false, false, true, false, false, false, true, false }, // 46
  { "sub_group_non_uniform_all", OpGroupNonUniformAll, 0x0, false, true, false, false, false, false, false, false, true, true }, // 47
  { "sub_group_non_uniform_all_equal", OpGroupNonUniformAllEqual, 0x0, false, false, true, false, false, false, false, false, true, false }, // 48
  { "sub_group_non_uniform_any", OpGroupNonUniformAny, 0x0, false, true, false, false, false, false, false, false, true, true }, // 49
  { "sub_group_non_uniform_broadcast", OpGroupNonUniformBroadcast, 0x0, false, false, false, false, false, false, false, false, true, false }, // 50
  { "sub_group_non_uniform_fadd", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 51
  { "sub_group_non_uniform_fmax", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 52
  { "sub_group_non_uniform_fmin", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 53
  { "sub_group_non_uniform_fmul", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 54
  { "sub_group_non_uniform_iadd", OpGroupNonUniformIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 55
  { "sub_group_non_uniform_iand", OpGroupNonUniformBitwiseAnd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 56
  { "sub_group_non_uniform_imul", OpGroupNonUniformIMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 57
  { "sub_group_non_uniform_ior", OpGroupNonUniformBitwiseOr, 0x0, false, false, false, false, false, false, false, false, false, false }, // 58
  { "sub_group_non_uniform_ixor", OpGroupNonUniformBitwiseXor, 0x0, false, false, false, false, false, false, false, false, false, false }, // 59
  { "sub_group_non_uniform_logical_iand", OpGroupNonUniformLogicalAnd, 0x0, false, false, false, false, false, false, false, true, false, true }, // 60
  { "sub_group_non_uniform_logical_ior", OpGroupNonUniformLogicalOr, 0x0, false, false, false, false, false, false, false, true, false, true }, // 61
  { "sub_group_non_uniform_logical_ixor", OpGroupNonUniformLogicalXor, 0x0, false, false, false, false, false, false, false, true, false, true }, // 62
  { "sub_group_non_uniform_reduce_addd", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 63
  { "sub_group_non_uniform_reduce_addf", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 64
  { "sub_group_non_uniform_reduce_addh", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 65
  { "sub_group_non_uniform_reduce_adds", OpGroupNonUniformIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 66
  { "sub_group_non_uniform_reduce_addu", OpGroupNonUniformIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 67
  { "sub_group_non_uniform_reduce_ands", OpGroupNonUniformBitwiseAnd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 68
  { "sub_group_non_uniform_reduce_andu", OpGroupNonUniformBitwiseAnd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 69
  { "sub_group_non_uniform_reduce_logical_ands", OpGroupNonUniformLogicalAnd, 0x0, false, false, false, false, false, false, false, true, false, true }, // 70
  { "sub_group_non_uniform_reduce_logical_ors", OpGroupNonUniformLogicalOr, 0x0, false, false, false, false, false, false, false, true, false, true }, // 71
  { "sub_group_non_uniform_reduce_logical_xors", OpGroupNonUniformLogicalXor, 0x0, false, false, false, false, false, false, false, true, false, true }, // 72
  { "sub_group_non_uniform_reduce_maxd", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 73
  { "sub_group_non_uniform_reduce_maxf", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 74
  { "sub_group_non_uniform_reduce_maxh", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 75
  { "sub_group_non_uniform_reduce_maxs", OpGroupNonUniformSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 76
  { "sub_group_non_uniform_reduce_maxu", OpGroupNonUniformUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 77
  { "sub_group_non_uniform_reduce_mind", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 78
  { "sub_group_non_uniform_reduce_minf", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 79
  { "sub_group_non_uniform_reduce_minh", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 80
  { "sub_group_non_uniform_reduce_mins", OpGroupNonUniformSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 81
  { "sub_group_non_uniform_reduce_minu", OpGroupNonUniformUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 82
  { "sub_group_non_uniform_reduce_muld", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 83
  { "sub_group_non_uniform_reduce_mulf", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 84
  { "sub_group_non_uniform_reduce_mulh", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 85
  { "sub_group_non_uniform_reduce_muls", OpGroupNonUniformIMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 86
  { "sub_group_non_uniform_reduce_mulu", OpGroupNonUniformIMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 87
  { "sub_group_non_uniform_reduce_ors", OpGroupNonUniformBitwiseOr, 0x0, false, false, false, false, false, false, false, false, false, false }, // 88
  { "sub_group_non_uniform_reduce_oru", OpGroupNonUniformBitwiseOr, 0x0, false, false, false, false, false, false, false, false, false, false }, // 89
  { "sub_group_non_uniform_reduce_xors", OpGroupNonUniformBitwiseXor, 0x0, false, false, false, false, false, false, false, false, false, false }, // 90
  { "sub_group_non_uniform_reduce_xoru", OpGroupNonUniformBitwiseXor, 0x0, false, false, false, false, false, false, false, false, false, false }, // 91
  { "sub_group_non_uniform_scan_exclusive_addd", OpGroupNonUniformFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 92
  { "sub_group_non_uniform_scan_exclusive_addf", OpGroupNonUniformFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 93
  { "sub_group_non_uniform_scan_exclusive_addh", OpGroupNonUniformFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 94
  { "sub_group_non_uniform_scan_exclusive_adds", OpGroupNonUniformIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 95
  { "sub_group_non_uniform_scan_exclusive_addu", OpGroupNonUniformIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 96
  { "sub_group_non_uniform_scan_exclusive_ands", OpGroupNonUniformBitwiseAnd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 97
  { "sub_group_non_uniform_scan_exclusive_andu", OpGroupNonUniformBitwiseAnd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 98
  { "sub_group_non_uniform_scan_exclusive_logical_ands", OpGroupNonUniformLogicalAnd, 0x2, false, false, false, false, false, false, false, true, false, true }, // 99
  { "sub_group_non_uniform_scan_exclusive_logical_ors", OpGroupNonUniformLogicalOr, 0x2, false, false, false, false, false, false, false, true, false, true }, // 100
  { "sub_group_non_uniform_scan_exclusive_logical_xors", OpGroupNonUniformLogicalXor, 0x2, false, false, false, false, false, false, false, true, false, true }, // 101
  { "sub_group_non_uniform_scan_exclusive_maxd", OpGroupNonUniformFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 102
  { "sub_group_non_uniform_scan_exclusive_maxf", OpGroupNonUniformFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 103
  { "sub_group_non_uniform_scan_exclusive_maxh", OpGroupNonUniformFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 104
  { "sub_group_non_uniform_scan_exclusive_maxs", OpGroupNonUniformSMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 105
  { "sub_group_non_uniform_scan_exclusive_maxu", OpGroupNonUniformUMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 106
  { "sub_group_non_uniform_scan_exclusive_mind", OpGroupNonUniformFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 107
  { "sub_group_non_uniform_scan_exclusive_minf", OpGroupNonUniformFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 108
  { "sub_group_non_uniform_scan_exclusive_minh", OpGroupNonUniformFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 109
  { "sub_group_non_uniform_scan_exclusive_mins", OpGroupNonUniformSMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 110
  { "sub_group_non_uniform_scan_exclusive_minu", OpGroupNonUniformUMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 111
  { "sub_group_non_uniform_scan_exclusive_muld", OpGroupNonUniformFMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 112
  { "sub_group_non_uniform_scan_exclusive_mulf", OpGroupNonUniformFMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 113
  { "sub_group_non_uniform_scan_exclusive_mulh", OpGroupNonUniformFMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 114
  { "sub_group_non_uniform_scan_exclusive_muls", OpGroupNonUniformIMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 115
  { "sub_group_non_uniform_scan_exclusive_mulu", OpGroupNonUniformIMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 116
  { "sub_group_non_uniform_scan_exclusive_ors", OpGroupNonUniformBitwiseOr, 0x2, false, false, false, false, false, false, false, false, false, false }, // 117
  { "sub_group_non_uniform_scan_exclusive_oru", OpGroupNonUniformBitwiseOr, 0x2, false, false, false, false, false, false, false, false, false, false }, // 118
  { "sub_group_non_uniform_scan_exclusive_xors", OpGroupNonUniformBitwiseXor, 0x2, false, false, false, false, false, false, false, false, false, false }, // 119
  { "sub_group_non_uniform_scan_exclusive_xoru", OpGroupNonUniformBitwiseXor, 0x2, false, false, false, false, false, false, false, false, false, false }, // 120
  { "sub_group_non_uniform_scan_inclusive_addd", OpGroupNonUniformFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 121
  { "sub_group_non_uniform_scan_inclusive_addf", OpGroupNonUniformFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 122
  { "sub_group_non_uniform_scan_inclusive_addh", OpGroupNonUniformFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 123
  { "sub_group_non_uniform_scan_inclusive_adds", OpGroupNonUniformIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 124
  { "sub_group_non_uniform_scan_inclusive_addu", OpGroupNonUniformIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 125
  { "sub_group_non_uniform_scan_inclusive_ands", OpGroupNonUniformBitwiseAnd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 126
  { "sub_group_non_uniform_scan_inclusive_andu", OpGroupNonUniformBitwiseAnd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 127
  { "sub_group_non_uniform_scan_inclusive_logical_ands", OpGroupNonUniformLogicalAnd, 0x1, false, false, false, false, false, false, false, true, false, true }, // 128
  { "sub_group_non_uniform_scan_inclusive_logical_ors", OpGroupNonUniformLogicalOr, 0x1, false, false, false, false, false, false, false, true, false, true }, // 129
  { "sub_group_non_uniform_scan_inclusive_logical_xors", OpGroupNonUniformLogicalXor, 0x1, false, false, false, false, false, false, false, true, false, true }, // 130
  { "sub_group_non_uniform_scan_inclusive_maxd", OpGroupNonUniformFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 131
  { "sub_group_non_uniform_scan_inclusive_maxf", OpGroupNonUniformFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 132
  { "sub_group_non_uniform_scan_inclusive_maxh", OpGroupNonUniformFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 133
  { "sub_group_non_uniform_scan_inclusive_maxs", OpGroupNonUniformSMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 134
  { "sub_group_non_uniform_scan_inclusive_maxu", OpGroupNonUniformUMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 135
  { "sub_group_non_uniform_scan_inclusive_mind", OpGroupNonUniformFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 136
  { "sub_group_non_uniform_scan_inclusive_minf", OpGroupNonUniformFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 137
  { "sub_group_non_uniform_scan_inclusive_minh", OpGroupNonUniformFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 138
  { "sub_group_non_uniform_scan_inclusive_mins", OpGroupNonUniformSMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 139
  { "sub_group_non_uniform_scan_inclusive_minu", OpGroupNonUniformUMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 140
  { "sub_group_non_uniform_scan_inclusive_muld", OpGroupNonUniformFMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 141
  { "sub_group_non_uniform_scan_inclusive_mulf", OpGroupNonUniformFMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 142
  { "sub_group_non_uniform_scan_inclusive_mulh", OpGroupNonUniformFMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 143
  { "sub_group_non_uniform_scan_inclusive_muls", OpGroupNonUniformIMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 144
  { "sub_group_non_uniform_scan_inclusive_mulu", OpGroupNonUniformIMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 145
  { "sub_group_non_uniform_scan_inclusive_ors", OpGroupNonUniformBitwiseOr, 0x1, false, false, false, false, false, false, false, false, false, false }, // 146
  { "sub_group_non_uniform_scan_inclusive_oru", OpGroupNonUniformBitwiseOr, 0x1, false, false, false, false, false, false, false, false, false, false }, // 147
  { "sub_group_non_uniform_scan_inclusive_xors", OpGroupNonUniformBitwiseXor, 0x1, false, false, false, false, false, false, false, false, false, false }, // 148
  { "sub_group_non_uniform_scan_inclusive_xoru", OpGroupNonUniformBitwiseXor, 0x1, false, false, false, false, false, false, false, false, false, false }, // 149
  { "sub_group_non_uniform_smax", OpGroupNonUniformSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 150
  { "sub_group_non_uniform_smin", OpGroupNonUniformSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 151
  { "sub_group_non_uniform_umax", OpGroupNonUniformUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 152
  { "sub_group_non_uniform_umin", OpGroupNonUniformUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 153
  { "sub_group_reduce_addf", OpGroupFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 154
  { "sub_group_reduce_adds", OpGroupIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 155
  { "sub_group_reduce_addu", OpGroupIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 156
  { "sub_group_reduce_maxf", OpGroupFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 157
  { "sub_group_reduce_maxs", OpGroupSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 158
  { "sub_group_reduce_maxu", OpGroupUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 159
  { "sub_group_reduce_minf", OpGroupFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 160
  { "sub_group_reduce_mins", OpGroupSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 161
  { "sub_group_reduce_minu", OpGroupUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 162
  { "sub_group_rotate", OpGroupNonUniformRotateKHR, 0x0, false, false, false, false, false, false, false, false, true, false }, // 163
  { "sub_group_scan_exclusive_addf", OpGroupFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 164
  { "sub_group_scan_exclusive_adds", OpGroupIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 165
  { "sub_group_scan_exclusive_addu", OpGroupIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 166
  { "sub_group_scan_exclusive_maxf", OpGroupFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 167
  { "sub_group_scan_exclusive_maxs", OpGroupSMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 168
  { "sub_group_scan_exclusive_maxu", OpGroupUMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 169
  { "sub_group_scan_exclusive_minf", OpGroupFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 170
  { "sub_group_scan_exclusive_mins", OpGroupSMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 171
  { "sub_group_scan_exclusive_minu", OpGroupUMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 172
  { "sub_group_scan_inclusive_addf", OpGroupFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 173
  { "sub_group_scan_inclusive_adds", OpGroupIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 174
  { "sub_group_scan_inclusive_addu", OpGroupIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 175
  { "sub_group_scan_inclusive_maxf", OpGroupFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 176
  { "sub_group_scan_inclusive_maxs", OpGroupSMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 177
  { "sub_group_scan_inclusive_maxu", OpGroupUMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 178
  { "sub_group_scan_inclusive_minf", OpGroupFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 179
  { "sub_group_scan_inclusive_mins", OpGroupSMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 180
  { "sub_group_scan_inclusive_minu", OpGroupUMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 181
  { "sub_group_shuffle", OpGroupNonUniformShuffle, 0x0, false, false, false, false, false, false, false, false, true, false }, // 182
  { "sub_group_shuffle_down", OpGroupNonUniformShuffleDown, 0x0, false, false, false, false, false, false, false, false, true, false }, // 183
  { "sub_group_shuffle_up", OpGroupNonUniformShuffleUp, 0x0, false, false, false, false, false, false, false, false, true, false }, // 184
  { "sub_group_shuffle_xor", OpGroupNonUniformShuffleXor, 0x0, false, false, false, false, false, false, false, false, true, false }, // 185
  { "sub_group_smax", OpGroupSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 186
  { "sub_group_smin", OpGroupSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 187
  { "sub_group_umax", OpGroupUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 188
  { "sub_group_umin", OpGroupUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 189
  { "work_group_all", OpGroupAll, 0x0, false, true, false, false, false, false, false, false, true, true }, // 190
  { "work_group_any", OpGroupAny, 0x0, false, true, false, false, false, false, false, false, true, true }, // 191
  { "work_group_broadcast", OpGroupBroadcast, 0x0, false, false, false, false, false, false, false, false, true, false }, // 192
  { "work_group_clustered_reduce_addd", OpGroupNonUniformFAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 193
  { "work_group_clustered_reduce_addf", OpGroupNonUniformFAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 194
  { "work_group_clustered_reduce_addh", OpGroupNonUniformFAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 195
  { "work_group_clustered_reduce_adds", OpGroupNonUniformIAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 196
  { "work_group_clustered_reduce_addu", OpGroupNonUniformIAdd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 197
  { "work_group_clustered_reduce_ands", OpGroupNonUniformBitwiseAnd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 198
  { "work_group_clustered_reduce_andu", OpGroupNonUniformBitwiseAnd, 0x3, false, false, false, false, false, false, false, false, false, false }, // 199
  { "work_group_clustered_reduce_logical_and", OpGroupNonUniformLogicalAnd, 0x3, false, false, false, false, false, false, false, true, false, true }, // 200
  { "work_group_clustered_reduce_logical_or", OpGroupNonUniformLogicalOr, 0x3, false, false, false, false, false, false, false, true, false, true }, // 201
  { "work_group_clustered_reduce_logical_xor", OpGroupNonUniformLogicalXor, 0x3, false, false, false, false, false, false, false, true, false, true }, // 202
  { "work_group_clustered_reduce_maxd", OpGroupNonUniformFMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 203
  { "work_group_clustered_reduce_maxf", OpGroupNonUniformFMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 204
  { "work_group_clustered_reduce_maxh", OpGroupNonUniformFMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 205
  { "work_group_clustered_reduce_maxs", OpGroupNonUniformSMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 206
  { "work_group_clustered_reduce_maxu", OpGroupNonUniformUMax, 0x3, false, false, false, false, false, false, false, false, false, false }, // 207
  { "work_group_clustered_reduce_mind", OpGroupNonUniformFMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 208
  { "work_group_clustered_reduce_minf", OpGroupNonUniformFMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 209
  { "work_group_clustered_reduce_minh", OpGroupNonUniformFMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 210
  { "work_group_clustered_reduce_mins", OpGroupNonUniformSMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 211
  { "work_group_clustered_reduce_minu", OpGroupNonUniformUMin, 0x3, false, false, false, false, false, false, false, false, false, false }, // 212
  { "work_group_clustered_reduce_muld", OpGroupNonUniformFMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 213
  { "work_group_clustered_reduce_mulf", OpGroupNonUniformFMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 214
  { "work_group_clustered_reduce_mulh", OpGroupNonUniformFMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 215
  { "work_group_clustered_reduce_muls", OpGroupNonUniformIMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 216
  { "work_group_clustered_reduce_mulu", OpGroupNonUniformIMul, 0x3, false, false, false, false, false, false, false, false, false, false }, // 217
  { "work_group_clustered_reduce_ors", OpGroupNonUniformBitwiseOr, 0x3, false, false, false, false, false, false, false, false, false, false }, // 218
  { "work_group_clustered_reduce_oru", OpGroupNonUniformBitwiseOr, 0x3, false, false, false, false, false, false, false, false, false, false }, // 219
  { "work_group_clustered_reduce_xors", OpGroupNonUniformBitwiseXor, 0x3, false, false, false, false, false, false, false, false, false, false }, // 220
  { "work_group_clustered_reduce_xoru", OpGroupNonUniformBitwiseXor, 0x3, false, false, false, false, false, false, false, false, false, false }, // 221
  { "work_group_fadd", OpGroupFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 222
  { "work_group_fmax", OpGroupFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 223
  { "work_group_fmin", OpGroupFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 224
  { "work_group_iadd", OpGroupIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 225
  { "work_group_non_uniform_fadd", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 226
  { "work_group_non_uniform_fmax", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 227
  { "work_group_non_uniform_fmin", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 228
  { "work_group_non_uniform_fmul", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 229
  { "work_group_non_uniform_iadd", OpGroupNonUniformIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 230
  { "work_group_non_uniform_iand", OpGroupNonUniformBitwiseAnd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 231
  { "work_group_non_uniform_imul", OpGroupNonUniformIMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 232
  { "work_group_non_uniform_ior", OpGroupNonUniformBitwiseOr, 0x0, false, false, false, false, false, false, false, false, false, false }, // 233
  { "work_group_non_uniform_ixor", OpGroupNonUniformBitwiseXor, 0x0, false, false, false, false, false, false, false, false, false, false }, // 234
  { "work_group_non_uniform_logical_iand", OpGroupNonUniformLogicalAnd, 0x0, false, false, false, false, false, false, false, true, false, true }, // 235
  { "work_group_non_uniform_logical_ior", OpGroupNonUniformLogicalOr, 0x0, false, false, false, false, false, false, false, true, false, true }, // 236
  { "work_group_non_uniform_logical_ixor", OpGroupNonUniformLogicalXor, 0x0, false, false, false, false, false, false, false, true, false, true }, // 237
  { "work_group_non_uniform_reduce_addd", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 238
  { "work_group_non_uniform_reduce_addf", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 239
  { "work_group_non_uniform_reduce_addh", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 240
  { "work_group_non_uniform_reduce_adds", OpGroupNonUniformIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 241
  { "work_group_non_uniform_reduce_addu", OpGroupNonUniformIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 242
  { "work_group_non_uniform_reduce_ands", OpGroupNonUniformBitwiseAnd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 243
  { "work_group_non_uniform_reduce_andu", OpGroupNonUniformBitwiseAnd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 244
  { "work_group_non_uniform_reduce_logical_ands", OpGroupNonUniformLogicalAnd, 0x0, false, false, false, false, false, false, false, true, false, true }, // 245
  { "work_group_non_uniform_reduce_logical_ors", OpGroupNonUniformLogicalOr, 0x0, false, false, false, false, false, false, false, true, false, true }, // 246
  { "work_group_non_uniform_reduce_logical_xors", OpGroupNonUniformLogicalXor, 0x0, false, false, false, false, false, false, false, true, false, true }, // 247
  { "work_group_non_uniform_reduce_maxd", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 248
  { "work_group_non_uniform_reduce_maxf", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 249
  { "work_group_non_uniform_reduce_maxh", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 250
  { "work_group_non_uniform_reduce_maxs", OpGroupNonUniformSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 251
  { "work_group_non_uniform_reduce_maxu", OpGroupNonUniformUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 252
  { "work_group_non_uniform_reduce_mind", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 253
  { "work_group_non_uniform_reduce_minf", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 254
  { "work_group_non_uniform_reduce_minh", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 255
  { "work_group_non_uniform_reduce_mins", OpGroupNonUniformSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 256
  { "work_group_non_uniform_reduce_minu", OpGroupNonUniformUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 257
  { "work_group_non_uniform_reduce_muld", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 258
  { "work_group_non_uniform_reduce_mulf", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 259
  { "work_group_non_uniform_reduce_mulh", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 260
  { "work_group_non_uniform_reduce_muls", OpGroupNonUniformIMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 261
  { "work_group_non_uniform_reduce_mulu", OpGroupNonUniformIMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 262
  { "work_group_non_uniform_reduce_ors", OpGroupNonUniformBitwiseOr, 0x0, false, false, false, false, false, false, false, false, false, false }, // 263
  { "work_group_non_uniform_reduce_oru", OpGroupNonUniformBitwiseOr, 0x0, false, false, false, false, false, false, false, false, false, false }, // 264
  { "work_group_non_uniform_reduce_xors", OpGroupNonUniformBitwiseXor, 0x0, false, false, false, false, false, false, false, false, false, false }, // 265
  { "work_group_non_uniform_reduce_xoru", OpGroupNonUniformBitwiseXor, 0x0, false, false, false, false, false, false, false, false, false, false }, // 266
  { "work_group_non_uniform_scan_exclusive_addd", OpGroupNonUniformFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 267
  { "work_group_non_uniform_scan_exclusive_addf", OpGroupNonUniformFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 268
  { "work_group_non_uniform_scan_exclusive_addh", OpGroupNonUniformFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 269
  { "work_group_non_uniform_scan_exclusive_adds", OpGroupNonUniformIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 270
  { "work_group_non_uniform_scan_exclusive_addu", OpGroupNonUniformIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 271
  { "work_group_non_uniform_scan_exclusive_ands", OpGroupNonUniformBitwiseAnd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 272
  { "work_group_non_uniform_scan_exclusive_andu", OpGroupNonUniformBitwiseAnd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 273
  { "work_group_non_uniform_scan_exclusive_logical_ands", OpGroupNonUniformLogicalAnd, 0x2, false, false, false, false, false, false, false, true, false, true }, // 274
  { "work_group_non_uniform_scan_exclusive_logical_ors", OpGroupNonUniformLogicalOr, 0x2, false, false, false, false, false, false, false, true, false, true }, // 275
  { "work_group_non_uniform_scan_exclusive_logical_xors", OpGroupNonUniformLogicalXor, 0x2, false, false, false, false, false, false, false, true, false, true }, // 276
  { "work_group_non_uniform_scan_exclusive_maxd", OpGroupNonUniformFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 277
  { "work_group_non_uniform_scan_exclusive_maxf", OpGroupNonUniformFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 278
  { "work_group_non_uniform_scan_exclusive_maxh", OpGroupNonUniformFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 279
  { "work_group_non_uniform_scan_exclusive_maxs", OpGroupNonUniformSMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 280
  { "work_group_non_uniform_scan_exclusive_maxu", OpGroupNonUniformUMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 281
  { "work_group_non_uniform_scan_exclusive_mind", OpGroupNonUniformFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 282
  { "work_group_non_uniform_scan_exclusive_minf", OpGroupNonUniformFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 283
  { "work_group_non_uniform_scan_exclusive_minh", OpGroupNonUniformFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 284
  { "work_group_non_uniform_scan_exclusive_mins", OpGroupNonUniformSMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 285
  { "work_group_non_uniform_scan_exclusive_minu", OpGroupNonUniformUMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 286
  { "work_group_non_uniform_scan_exclusive_muld", OpGroupNonUniformFMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 287
  { "work_group_non_uniform_scan_exclusive_mulf", OpGroupNonUniformFMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 288
  { "work_group_non_uniform_scan_exclusive_mulh", OpGroupNonUniformFMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 289
  { "work_group_non_uniform_scan_exclusive_muls", OpGroupNonUniformIMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 290
  { "work_group_non_uniform_scan_exclusive_mulu", OpGroupNonUniformIMul, 0x2, false, false, false, false, false, false, false, false, false, false }, // 291
  { "work_group_non_uniform_scan_exclusive_ors", OpGroupNonUniformBitwiseOr, 0x2, false, false, false, false, false, false, false, false, false, false }, // 292
  { "work_group_non_uniform_scan_exclusive_oru", OpGroupNonUniformBitwiseOr, 0x2, false, false, false, false, false, false, false, false, false, false }, // 293
  { "work_group_non_uniform_scan_exclusive_xors", OpGroupNonUniformBitwiseXor, 0x2, false, false, false, false, false, false, false, false, false, false }, // 294
  { "work_group_non_uniform_scan_exclusive_xoru", OpGroupNonUniformBitwiseXor, 0x2, false, false, false, false, false, false, false, false, false, false }, // 295
  { "work_group_non_uniform_scan_inclusive_addd", OpGroupNonUniformFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 296
  { "work_group_non_uniform_scan_inclusive_addf", OpGroupNonUniformFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 297
  { "work_group_non_uniform_scan_inclusive_addh", OpGroupNonUniformFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 298
  { "work_group_non_uniform_scan_inclusive_adds", OpGroupNonUniformIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 299
  { "work_group_non_uniform_scan_inclusive_addu", OpGroupNonUniformIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 300
  { "work_group_non_uniform_scan_inclusive_ands", OpGroupNonUniformBitwiseAnd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 301
  { "work_group_non_uniform_scan_inclusive_andu", OpGroupNonUniformBitwiseAnd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 302
  { "work_group_non_uniform_scan_inclusive_logical_ands", OpGroupNonUniformLogicalAnd, 0x1, false, false, false, false, false, false, false, true, false, true }, // 303
  { "work_group_non_uniform_scan_inclusive_logical_ors", OpGroupNonUniformLogicalOr, 0x1, false, false, false, false, false, false, false, true, false, true }, // 304
  { "work_group_non_uniform_scan_inclusive_logical_xors", OpGroupNonUniformLogicalXor, 0x1, false, false, false, false, false, false, false, true, false, true }, // 305
  { "work_group_non_uniform_scan_inclusive_maxd", OpGroupNonUniformFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 306
  { "work_group_non_uniform_scan_inclusive_maxf", OpGroupNonUniformFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 307
  { "work_group_non_uniform_scan_inclusive_maxh", OpGroupNonUniformFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 308
  { "work_group_non_uniform_scan_inclusive_maxs", OpGroupNonUniformSMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 309
  { "work_group_non_uniform_scan_inclusive_maxu", OpGroupNonUniformUMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 310
  { "work_group_non_uniform_scan_inclusive_mind", OpGroupNonUniformFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 311
  { "work_group_non_uniform_scan_inclusive_minf", OpGroupNonUniformFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 312
  { "work_group_non_uniform_scan_inclusive_minh", OpGroupNonUniformFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 313
  { "work_group_non_uniform_scan_inclusive_mins", OpGroupNonUniformSMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 314
  { "work_group_non_uniform_scan_inclusive_minu", OpGroupNonUniformUMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 315
  { "work_group_non_uniform_scan_inclusive_muld", OpGroupNonUniformFMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 316
  { "work_group_non_uniform_scan_inclusive_mulf", OpGroupNonUniformFMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 317
  { "work_group_non_uniform_scan_inclusive_mulh", OpGroupNonUniformFMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 318
  { "work_group_non_uniform_scan_inclusive_muls", OpGroupNonUniformIMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 319
  { "work_group_non_uniform_scan_inclusive_mulu", OpGroupNonUniformIMul, 0x1, false, false, false, false, false, false, false, false, false, false }, // 320
  { "work_group_non_uniform_scan_inclusive_ors", OpGroupNonUniformBitwiseOr, 0x1, false, false, false, false, false, false, false, false, false, false }, // 321
  { "work_group_non_uniform_scan_inclusive_oru", OpGroupNonUniformBitwiseOr, 0x1, false, false, false, false, false, false, false, false, false, false }, // 322
  { "work_group_non_uniform_scan_inclusive_xors", OpGroupNonUniformBitwiseXor, 0x1, false, false, false, false, false, false, false, false, false, false }, // 323
  { "work_group_non_uniform_scan_inclusive_xoru", OpGroupNonUniformBitwiseXor, 0x1, false, false, false, false, false, false, false, false, false, false }, // 324
  { "work_group_non_uniform_smax", OpGroupNonUniformSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 325
  { "work_group_non_uniform_smin", OpGroupNonUniformSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 326
  { "work_group_non_uniform_umax", OpGroupNonUniformUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 327
  { "work_group_non_uniform_umin", OpGroupNonUniformUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 328
  { "work_group_reduce_addf", OpGroupFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 329
  { "work_group_reduce_adds", OpGroupIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 330
  { "work_group_reduce_addu", OpGroupIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 331
  { "work_group_reduce_and", OpGroupBitwiseAndKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 332
  { "work_group_reduce_imul", OpGroupIMulKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 333
  { "work_group_reduce_logical_and", OpGroupLogicalAndKHR, 0x0, false, false, false, false, false, false, false, true, false, true }, // 334
  { "work_group_reduce_logical_or", OpGroupLogicalOrKHR, 0x0, false, false, false, false, false, false, false, true, false, true }, // 335
  { "work_group_reduce_logical_xor", OpGroupLogicalXorKHR, 0x0, false, false, false, false, false, false, false, true, false, true }, // 336
  { "work_group_reduce_maxf", OpGroupFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 337
  { "work_group_reduce_maxs", OpGroupSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 338
  { "work_group_reduce_maxu", OpGroupUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 339
  { "work_group_reduce_minf", OpGroupFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 340
  { "work_group_reduce_mins", OpGroupSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 341
  { "work_group_reduce_minu", OpGroupUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 342
  { "work_group_reduce_muld", OpGroupFMulKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 343
  { "work_group_reduce_mulf", OpGroupFMulKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 344
  { "work_group_reduce_mulh", OpGroupFMulKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 345
  { "work_group_reduce_muls", OpGroupIMulKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 346
  { "work_group_reduce_mulu", OpGroupIMulKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 347
  { "work_group_reduce_or", OpGroupBitwiseOrKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 348
  { "work_group_reduce_xor", OpGroupBitwiseXorKHR, 0x0, false, false, false, false, false, false, false, false, false, false }, // 349
  { "work_group_scan_exclusive_addf", OpGroupFAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 350
  { "work_group_scan_exclusive_adds", OpGroupIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 351
  { "work_group_scan_exclusive_addu", OpGroupIAdd, 0x2, false, false, false, false, false, false, false, false, false, false }, // 352
  { "work_group_scan_exclusive_and", OpGroupBitwiseAndKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 353
  { "work_group_scan_exclusive_imul", OpGroupIMulKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 354
  { "work_group_scan_exclusive_logical_and", OpGroupLogicalAndKHR, 0x2, false, false, false, false, false, false, false, true, false, true }, // 355
  { "work_group_scan_exclusive_logical_or", OpGroupLogicalOrKHR, 0x2, false, false, false, false, false, false, false, true, false, true }, // 356
  { "work_group_scan_exclusive_logical_xor", OpGroupLogicalXorKHR, 0x2, false, false, false, false, false, false, false, true, false, true }, // 357
  { "work_group_scan_exclusive_maxf", OpGroupFMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 358
  { "work_group_scan_exclusive_maxs", OpGroupSMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 359
  { "work_group_scan_exclusive_maxu", OpGroupUMax, 0x2, false, false, false, false, false, false, false, false, false, false }, // 360
  { "work_group_scan_exclusive_minf", OpGroupFMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 361
  { "work_group_scan_exclusive_mins", OpGroupSMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 362
  { "work_group_scan_exclusive_minu", OpGroupUMin, 0x2, false, false, false, false, false, false, false, false, false, false }, // 363
  { "work_group_scan_exclusive_muld", OpGroupFMulKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 364
  { "work_group_scan_exclusive_mulf", OpGroupFMulKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 365
  { "work_group_scan_exclusive_mulh", OpGroupFMulKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 366
  { "work_group_scan_exclusive_muls", OpGroupIMulKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 367
  { "work_group_scan_exclusive_mulu", OpGroupIMulKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 368
  { "work_group_scan_exclusive_or", OpGroupBitwiseOrKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 369
  { "work_group_scan_exclusive_xor", OpGroupBitwiseXorKHR, 0x2, false, false, false, false, false, false, false, false, false, false }, // 370
  { "work_group_scan_inclusive_addf", OpGroupFAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 371
  { "work_group_scan_inclusive_adds", OpGroupIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 372
  { "work_group_scan_inclusive_addu", OpGroupIAdd, 0x1, false, false, false, false, false, false, false, false, false, false }, // 373
  { "work_group_scan_inclusive_and", OpGroupBitwiseAndKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 374
  { "work_group_scan_inclusive_imul", OpGroupIMulKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 375
  { "work_group_scan_inclusive_logical_and", OpGroupLogicalAndKHR, 0x1, false, false, false, false, false, false, false, true, false, true }, // 376
  { "work_group_scan_inclusive_logical_or", OpGroupLogicalOrKHR, 0x1, false, false, false, false, false, false, false, true, false, true }, // 377
  { "work_group_scan_inclusive_logical_xor", OpGroupLogicalXorKHR, 0x1, false, false, false, false, false, false, false, true, false, true }, // 378
  { "work_group_scan_inclusive_maxf", OpGroupFMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 379
  { "work_group_scan_inclusive_maxs", OpGroupSMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 380
  { "work_group_scan_inclusive_maxu", OpGroupUMax, 0x1, false, false, false, false, false, false, false, false, false, false }, // 381
  { "work_group_scan_inclusive_minf", OpGroupFMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 382
  { "work_group_scan_inclusive_mins", OpGroupSMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 383
  { "work_group_scan_inclusive_minu", OpGroupUMin, 0x1, false, false, false, false, false, false, false, false, false, false }, // 384
  { "work_group_scan_inclusive_muld", OpGroupFMulKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 385
  { "work_group_scan_inclusive_mulf", OpGroupFMulKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 386
  { "work_group_scan_inclusive_mulh", OpGroupFMulKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 387
  { "work_group_scan_inclusive_muls", OpGroupIMulKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 388
  { "work_group_scan_inclusive_mulu", OpGroupIMulKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 389
  { "work_group_scan_inclusive_or", OpGroupBitwiseOrKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 390
  { "work_group_scan_inclusive_xor", OpGroupBitwiseXorKHR, 0x1, false, false, false, false, false, false, false, false, false, false }, // 391
  { "work_group_smax", OpGroupSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 392
  { "work_group_smin", OpGroupSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 393
  { "work_group_umax", OpGroupUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 394
  { "work_group_umin", OpGroupUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 395
  { "__spirv_GroupAll", OpGroupAll, 0x0, false, true, false, false, false, false, false, false, true, true }, // 396
  { "__spirv_GroupAny", OpGroupAny, 0x0, false, true, false, false, false, false, false, false, true, true }, // 397
  { "__spirv_GroupBroadcast", OpGroupBroadcast, 0x0, false, false, false, false, false, false, false, false, true, false }, // 398
  { "__spirv_GroupFAdd", OpGroupFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 399
  { "__spirv_GroupFMax", OpGroupFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 400
  { "__spirv_GroupFMin", OpGroupFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 401
  { "__spirv_GroupIAdd", OpGroupIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 402
  { "__spirv_GroupNonUniformAll", OpGroupNonUniformAll, 0x0, false, true, false, false, false, false, false, false, true, true }, // 403
  { "__spirv_GroupNonUniformAllEqual", OpGroupNonUniformAllEqual, 0x0, false, false, true, false, false, false, false, false, true, false }, // 404
  { "__spirv_GroupNonUniformAny", OpGroupNonUniformAny, 0x0, false, true, false, false, false, false, false, false, true, true }, // 405
  { "__spirv_GroupNonUniformBallot", OpGroupNonUniformBallot, 0x0, false, false, false, true, false, false, false, false, true, true }, // 406
  { "__spirv_GroupNonUniformBallotBitCount", OpGroupNonUniformBallotBitCount, 0x0, false, false, false, false, false, false, false, false, false, false }, // 407
  { "__spirv_GroupNonUniformBallotBitExtract", OpGroupNonUniformBallotBitExtract, 0x0, false, false, false, false, false, true, false, false, true, false }, // 408
  { "__spirv_GroupNonUniformBallotFindLSB", OpGroupNonUniformBallotFindLSB, 0x0, false, false, false, false, false, false, true, false, true, false }, // 409
  { "__spirv_GroupNonUniformBallotFindMSB", OpGroupNonUniformBallotFindMSB, 0x0, false, false, false, false, false, false, true, false, true, false }, // 410
  { "__spirv_GroupNonUniformBitwiseAnd", OpGroupNonUniformBitwiseAnd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 411
  { "__spirv_GroupNonUniformBitwiseOr", OpGroupNonUniformBitwiseOr, 0x0, false, false, false, false, false, false, false, false, false, false }, // 412
  { "__spirv_GroupNonUniformBitwiseXor", OpGroupNonUniformBitwiseXor, 0x0, false, false, false, false, false, false, false, false, false, false }, // 413
  { "__spirv_GroupNonUniformBroadcast", OpGroupNonUniformBroadcast, 0x0, false, false, false, false, false, false, false, false, true, false }, // 414
  { "__spirv_GroupNonUniformBroadcastFirst", OpGroupNonUniformBroadcastFirst, 0x0, false, false, false, false, false, false, false, false, true, false }, // 415
  { "__spirv_GroupNonUniformElect", OpGroupNonUniformElect, 0x0, true, false, false, false, false, false, false, false, true, false }, // 416
  { "__spirv_GroupNonUniformFAdd", OpGroupNonUniformFAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 417
  { "__spirv_GroupNonUniformFMax", OpGroupNonUniformFMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 418
  { "__spirv_GroupNonUniformFMin", OpGroupNonUniformFMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 419
  { "__spirv_GroupNonUniformFMul", OpGroupNonUniformFMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 420
  { "__spirv_GroupNonUniformIAdd", OpGroupNonUniformIAdd, 0x0, false, false, false, false, false, false, false, false, false, false }, // 421
  { "__spirv_GroupNonUniformIMul", OpGroupNonUniformIMul, 0x0, false, false, false, false, false, false, false, false, false, false }, // 422
  { "__spirv_GroupNonUniformInverseBallot", OpGroupNonUniformInverseBallot, 0x0, false, false, false, false, true, false, false, false, true, false }, // 423
  { "__spirv_GroupNonUniformLogicalAnd", OpGroupNonUniformLogicalAnd, 0x0, false, false, false, false, false, false, false, true, false, true }, // 424
  { "__spirv_GroupNonUniformLogicalOr", OpGroupNonUniformLogicalOr, 0x0, false, false, false, false, false, false, false, true, false, true }, // 425
  { "__spirv_GroupNonUniformLogicalXor", OpGroupNonUniformLogicalXor, 0x0, false, false, false, false, false, false, false, true, false, true }, // 426
  { "__spirv_GroupNonUniformShuffle", OpGroupNonUniformShuffle, 0x0, false, false, false, false, false, false, false, false, true, false }, // 427
  { "__spirv_GroupNonUniformShuffleDown", OpGroupNonUniformShuffleDown, 0x0, false, false, false, false, false, false, false, false, true, false }, // 428
  { "__spirv_GroupNonUniformShuffleUp", OpGroupNonUniformShuffleUp, 0x0, false, false, false, false, false, false, false, false, true, false }, // 429
  { "__spirv_GroupNonUniformShuffleXor", OpGroupNonUniformShuffleXor, 0x0, false, false, false, false, false, false, false, false, true, false }, // 430
  { "__spirv_GroupNonUniformSMax", OpGroupNonUniformSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 431
  { "__spirv_GroupNonUniformSMin", OpGroupNonUniformSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 432
  { "__spirv_GroupNonUniformUMax", OpGroupNonUniformUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 433
  { "__spirv_GroupNonUniformUMin", OpGroupNonUniformUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 434
  { "__spirv_GroupSMax", OpGroupSMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 435
  { "__spirv_GroupSMin", OpGroupSMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 436
  { "__spirv_GroupUMax", OpGroupUMax, 0x0, false, false, false, false, false, false, false, false, false, false }, // 437
  { "__spirv_GroupUMin", OpGroupUMin, 0x0, false, false, false, false, false, false, false, false, false, false }, // 438
 };

const GroupBuiltin *lookupGroupBuiltin(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "SUB_GROUP_ALL", 0 },
    { "SUB_GROUP_ANY", 1 },
    { "SUB_GROUP_BALLOT", 2 },
    { "SUB_GROUP_BALLOT_BIT_COUNT", 3 },
    { "SUB_GROUP_BALLOT_BIT_EXTRACT", 4 },
    { "SUB_GROUP_BALLOT_EXCLUSIVE_SCAN", 5 },
    { "SUB_GROUP_BALLOT_FIND_LSB", 6 },
    { "SUB_GROUP_BALLOT_FIND_MSB", 7 },
    { "SUB_GROUP_BALLOT_INCLUSIVE_SCAN", 8 },
    { "SUB_GROUP_BROADCAST", 9 },
    { "SUB_GROUP_BROADCAST_FIRST", 10 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDD", 11 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDF", 12 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDH", 13 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDS", 14 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ADDU", 15 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ANDS", 16 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ANDU", 17 },
    { "SUB_GROUP_CLUSTERED_REDUCE_LOGICAL_AND", 18 },
    { "SUB_GROUP_CLUSTERED_REDUCE_LOGICAL_OR", 19 },
    { "SUB_GROUP_CLUSTERED_REDUCE_LOGICAL_XOR", 20 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXD", 21 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXF", 22 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXH", 23 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXS", 24 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MAXU", 25 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MIND", 26 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINF", 27 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINH", 28 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINS", 29 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MINU", 30 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULD", 31 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULF", 32 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULH", 33 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULS", 34 },
    { "SUB_GROUP_CLUSTERED_REDUCE_MULU", 35 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ORS", 36 },
    { "SUB_GROUP_CLUSTERED_REDUCE_ORU", 37 },
    { "SUB_GROUP_CLUSTERED_REDUCE_XORS", 38 },
    { "SUB_GROUP_CLUSTERED_REDUCE_XORU", 39 },
    { "SUB_GROUP_CLUSTERED_ROTATE", 40 },
    { "SUB_GROUP_ELECT", 41 },
    { "SUB_GROUP_FADD", 42 },
    { "SUB_GROUP_FMAX", 43 },
    { "SUB_GROUP_FMIN", 44 },
    { "SUB_GROUP_IADD", 45 },
    { "SUB_GROUP_INVERSE_BALLOT", 46 },
    { "SUB_GROUP_NON_UNIFORM_ALL", 47 },
    { "SUB_GROUP_NON_UNIFORM_ALL_EQUAL", 48 },
    { "SUB_GROUP_NON_UNIFORM_ANY", 49 },
    { "SUB_GROUP_NON_UNIFORM_BROADCAST", 50 },
    { "SUB_GROUP_NON_UNIFORM_FADD", 51 },
    { "SUB_GROUP_NON_UNIFORM_FMAX", 52 },
    { "SUB_GROUP_NON_UNIFORM_FMIN", 53 },
    { "SUB_GROUP_NON_UNIFORM_FMUL", 54 },
    { "SUB_GROUP_NON_UNIFORM_IADD", 55 },
    { "SUB_GROUP_NON_UNIFORM_IAND", 56 },
    { "SUB_GROUP_NON_UNIFORM_IMUL", 57 },
    { "SUB_GROUP_NON_UNIFORM_IOR", 58 },
    { "SUB_GROUP_NON_UNIFORM_IXOR", 59 },
    { "SUB_GROUP_NON_UNIFORM_LOGICAL_IAND", 60 },
    { "SUB_GROUP_NON_UNIFORM_LOGICAL_IOR", 61 },
    { "SUB_GROUP_NON_UNIFORM_LOGICAL_IXOR", 62 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDD", 63 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDF", 64 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDH", 65 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDS", 66 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ADDU", 67 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ANDS", 68 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ANDU", 69 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ANDS", 70 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ORS", 71 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_LOGICAL_XORS", 72 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXD", 73 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXF", 74 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXH", 75 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXS", 76 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MAXU", 77 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MIND", 78 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINF", 79 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINH", 80 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINS", 81 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MINU", 82 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULD", 83 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULF", 84 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULH", 85 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULS", 86 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_MULU", 87 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ORS", 88 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_ORU", 89 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_XORS", 90 },
    { "SUB_GROUP_NON_UNIFORM_REDUCE_XORU", 91 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDD", 92 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDF", 93 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDH", 94 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDS", 95 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDU", 96 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDS", 97 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDU", 98 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ANDS", 99 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ORS", 100 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_XORS", 101 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXD", 102 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXF", 103 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXH", 104 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXS", 105 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXU", 106 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MIND", 107 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINF", 108 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINH", 109 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINS", 110 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINU", 111 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULD", 112 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULF", 113 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULH", 114 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULS", 115 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULU", 116 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORS", 117 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORU", 118 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORS", 119 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORU", 120 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDD", 121 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDF", 122 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDH", 123 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDS", 124 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDU", 125 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDS", 126 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDU", 127 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ANDS", 128 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ORS", 129 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_XORS", 130 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXD", 131 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXF", 132 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXH", 133 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXS", 134 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXU", 135 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MIND", 136 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINF", 137 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINH", 138 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINS", 139 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINU", 140 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULD", 141 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULF", 142 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULH", 143 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULS", 144 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULU", 145 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORS", 146 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORU", 147 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORS", 148 },
    { "SUB_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORU", 149 },
    { "SUB_GROUP_NON_UNIFORM_SMAX", 150 },
    { "SUB_GROUP_NON_UNIFORM_SMIN", 151 },
    { "SUB_GROUP_NON_UNIFORM_UMAX", 152 },
    { "SUB_GROUP_NON_UNIFORM_UMIN", 153 },
    { "SUB_GROUP_REDUCE_ADDF", 154 },
    { "SUB_GROUP_REDUCE_ADDS", 155 },
    { "SUB_GROUP_REDUCE_ADDU", 156 },
    { "SUB_GROUP_REDUCE_MAXF", 157 },
    { "SUB_GROUP_REDUCE_MAXS", 158 },
    { "SUB_GROUP_REDUCE_MAXU", 159 },
    { "SUB_GROUP_REDUCE_MINF", 160 },
    { "SUB_GROUP_REDUCE_MINS", 161 },
    { "SUB_GROUP_REDUCE_MINU", 162 },
    { "SUB_GROUP_ROTATE", 163 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_ADDF", 164 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_ADDS", 165 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_ADDU", 166 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MAXF", 167 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MAXS", 168 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MAXU", 169 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MINF", 170 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MINS", 171 },
    { "SUB_GROUP_SCAN_EXCLUSIVE_MINU", 172 },
    { "SUB_GROUP_SCAN_INCLUSIVE_ADDF", 173 },
    { "SUB_GROUP_SCAN_INCLUSIVE_ADDS", 174 },
    { "SUB_GROUP_SCAN_INCLUSIVE_ADDU", 175 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MAXF", 176 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MAXS", 177 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MAXU", 178 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MINF", 179 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MINS", 180 },
    { "SUB_GROUP_SCAN_INCLUSIVE_MINU", 181 },
    { "SUB_GROUP_SHUFFLE", 182 },
    { "SUB_GROUP_SHUFFLE_DOWN", 183 },
    { "SUB_GROUP_SHUFFLE_UP", 184 },
    { "SUB_GROUP_SHUFFLE_XOR", 185 },
    { "SUB_GROUP_SMAX", 186 },
    { "SUB_GROUP_SMIN", 187 },
    { "SUB_GROUP_UMAX", 188 },
    { "SUB_GROUP_UMIN", 189 },
    { "WORK_GROUP_ALL", 190 },
    { "WORK_GROUP_ANY", 191 },
    { "WORK_GROUP_BROADCAST", 192 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDD", 193 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDF", 194 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDH", 195 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDS", 196 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ADDU", 197 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ANDS", 198 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ANDU", 199 },
    { "WORK_GROUP_CLUSTERED_REDUCE_LOGICAL_AND", 200 },
    { "WORK_GROUP_CLUSTERED_REDUCE_LOGICAL_OR", 201 },
    { "WORK_GROUP_CLUSTERED_REDUCE_LOGICAL_XOR", 202 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXD", 203 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXF", 204 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXH", 205 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXS", 206 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MAXU", 207 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MIND", 208 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINF", 209 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINH", 210 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINS", 211 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MINU", 212 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULD", 213 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULF", 214 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULH", 215 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULS", 216 },
    { "WORK_GROUP_CLUSTERED_REDUCE_MULU", 217 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ORS", 218 },
    { "WORK_GROUP_CLUSTERED_REDUCE_ORU", 219 },
    { "WORK_GROUP_CLUSTERED_REDUCE_XORS", 220 },
    { "WORK_GROUP_CLUSTERED_REDUCE_XORU", 221 },
    { "WORK_GROUP_FADD", 222 },
    { "WORK_GROUP_FMAX", 223 },
    { "WORK_GROUP_FMIN", 224 },
    { "WORK_GROUP_IADD", 225 },
    { "WORK_GROUP_NON_UNIFORM_FADD", 226 },
    { "WORK_GROUP_NON_UNIFORM_FMAX", 227 },
    { "WORK_GROUP_NON_UNIFORM_FMIN", 228 },
    { "WORK_GROUP_NON_UNIFORM_FMUL", 229 },
    { "WORK_GROUP_NON_UNIFORM_IADD", 230 },
    { "WORK_GROUP_NON_UNIFORM_IAND", 231 },
    { "WORK_GROUP_NON_UNIFORM_IMUL", 232 },
    { "WORK_GROUP_NON_UNIFORM_IOR", 233 },
    { "WORK_GROUP_NON_UNIFORM_IXOR", 234 },
    { "WORK_GROUP_NON_UNIFORM_LOGICAL_IAND", 235 },
    { "WORK_GROUP_NON_UNIFORM_LOGICAL_IOR", 236 },
    { "WORK_GROUP_NON_UNIFORM_LOGICAL_IXOR", 237 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDD", 238 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDF", 239 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDH", 240 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDS", 241 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ADDU", 242 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ANDS", 243 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ANDU", 244 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ANDS", 245 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_LOGICAL_ORS", 246 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_LOGICAL_XORS", 247 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXD", 248 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXF", 249 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXH", 250 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXS", 251 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MAXU", 252 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MIND", 253 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINF", 254 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINH", 255 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINS", 256 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MINU", 257 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULD", 258 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULF", 259 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULH", 260 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULS", 261 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_MULU", 262 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ORS", 263 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_ORU", 264 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_XORS", 265 },
    { "WORK_GROUP_NON_UNIFORM_REDUCE_XORU", 266 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDD", 267 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDF", 268 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDH", 269 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDS", 270 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ADDU", 271 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDS", 272 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ANDU", 273 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ANDS", 274 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_ORS", 275 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_LOGICAL_XORS", 276 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXD", 277 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXF", 278 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXH", 279 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXS", 280 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MAXU", 281 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MIND", 282 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINF", 283 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINH", 284 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINS", 285 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MINU", 286 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULD", 287 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULF", 288 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULH", 289 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULS", 290 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_MULU", 291 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORS", 292 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_ORU", 293 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORS", 294 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_EXCLUSIVE_XORU", 295 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDD", 296 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDF", 297 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDH", 298 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDS", 299 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ADDU", 300 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDS", 301 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ANDU", 302 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ANDS", 303 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_ORS", 304 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_LOGICAL_XORS", 305 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXD", 306 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXF", 307 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXH", 308 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXS", 309 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MAXU", 310 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MIND", 311 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINF", 312 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINH", 313 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINS", 314 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MINU", 315 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULD", 316 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULF", 317 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULH", 318 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULS", 319 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_MULU", 320 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORS", 321 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_ORU", 322 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORS", 323 },
    { "WORK_GROUP_NON_UNIFORM_SCAN_INCLUSIVE_XORU", 324 },
    { "WORK_GROUP_NON_UNIFORM_SMAX", 325 },
    { "WORK_GROUP_NON_UNIFORM_SMIN", 326 },
    { "WORK_GROUP_NON_UNIFORM_UMAX", 327 },
    { "WORK_GROUP_NON_UNIFORM_UMIN", 328 },
    { "WORK_GROUP_REDUCE_ADDF", 329 },
    { "WORK_GROUP_REDUCE_ADDS", 330 },
    { "WORK_GROUP_REDUCE_ADDU", 331 },
    { "WORK_GROUP_REDUCE_AND", 332 },
    { "WORK_GROUP_REDUCE_IMUL", 333 },
    { "WORK_GROUP_REDUCE_LOGICAL_AND", 334 },
    { "WORK_GROUP_REDUCE_LOGICAL_OR", 335 },
    { "WORK_GROUP_REDUCE_LOGICAL_XOR", 336 },
    { "WORK_GROUP_REDUCE_MAXF", 337 },
    { "WORK_GROUP_REDUCE_MAXS", 338 },
    { "WORK_GROUP_REDUCE_MAXU", 339 },
    { "WORK_GROUP_REDUCE_MINF", 340 },
    { "WORK_GROUP_REDUCE_MINS", 341 },
    { "WORK_GROUP_REDUCE_MINU", 342 },
    { "WORK_GROUP_REDUCE_MULD", 343 },
    { "WORK_GROUP_REDUCE_MULF", 344 },
    { "WORK_GROUP_REDUCE_MULH", 345 },
    { "WORK_GROUP_REDUCE_MULS", 346 },
    { "WORK_GROUP_REDUCE_MULU", 347 },
    { "WORK_GROUP_REDUCE_OR", 348 },
    { "WORK_GROUP_REDUCE_XOR", 349 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_ADDF", 350 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_ADDS", 351 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_ADDU", 352 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_AND", 353 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_IMUL", 354 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_LOGICAL_AND", 355 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_LOGICAL_OR", 356 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_LOGICAL_XOR", 357 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MAXF", 358 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MAXS", 359 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MAXU", 360 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MINF", 361 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MINS", 362 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MINU", 363 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULD", 364 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULF", 365 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULH", 366 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULS", 367 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_MULU", 368 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_OR", 369 },
    { "WORK_GROUP_SCAN_EXCLUSIVE_XOR", 370 },
    { "WORK_GROUP_SCAN_INCLUSIVE_ADDF", 371 },
    { "WORK_GROUP_SCAN_INCLUSIVE_ADDS", 372 },
    { "WORK_GROUP_SCAN_INCLUSIVE_ADDU", 373 },
    { "WORK_GROUP_SCAN_INCLUSIVE_AND", 374 },
    { "WORK_GROUP_SCAN_INCLUSIVE_IMUL", 375 },
    { "WORK_GROUP_SCAN_INCLUSIVE_LOGICAL_AND", 376 },
    { "WORK_GROUP_SCAN_INCLUSIVE_LOGICAL_OR", 377 },
    { "WORK_GROUP_SCAN_INCLUSIVE_LOGICAL_XOR", 378 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MAXF", 379 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MAXS", 380 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MAXU", 381 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MINF", 382 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MINS", 383 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MINU", 384 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULD", 385 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULF", 386 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULH", 387 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULS", 388 },
    { "WORK_GROUP_SCAN_INCLUSIVE_MULU", 389 },
    { "WORK_GROUP_SCAN_INCLUSIVE_OR", 390 },
    { "WORK_GROUP_SCAN_INCLUSIVE_XOR", 391 },
    { "WORK_GROUP_SMAX", 392 },
    { "WORK_GROUP_SMIN", 393 },
    { "WORK_GROUP_UMAX", 394 },
    { "WORK_GROUP_UMIN", 395 },
    { "__SPIRV_GROUPALL", 396 },
    { "__SPIRV_GROUPANY", 397 },
    { "__SPIRV_GROUPBROADCAST", 398 },
    { "__SPIRV_GROUPFADD", 399 },
    { "__SPIRV_GROUPFMAX", 400 },
    { "__SPIRV_GROUPFMIN", 401 },
    { "__SPIRV_GROUPIADD", 402 },
    { "__SPIRV_GROUPNONUNIFORMALL", 403 },
    { "__SPIRV_GROUPNONUNIFORMALLEQUAL", 404 },
    { "__SPIRV_GROUPNONUNIFORMANY", 405 },
    { "__SPIRV_GROUPNONUNIFORMBALLOT", 406 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTBITCOUNT", 407 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTBITEXTRACT", 408 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTFINDLSB", 409 },
    { "__SPIRV_GROUPNONUNIFORMBALLOTFINDMSB", 410 },
    { "__SPIRV_GROUPNONUNIFORMBITWISEAND", 411 },
    { "__SPIRV_GROUPNONUNIFORMBITWISEOR", 412 },
    { "__SPIRV_GROUPNONUNIFORMBITWISEXOR", 413 },
    { "__SPIRV_GROUPNONUNIFORMBROADCAST", 414 },
    { "__SPIRV_GROUPNONUNIFORMBROADCASTFIRST", 415 },
    { "__SPIRV_GROUPNONUNIFORMELECT", 416 },
    { "__SPIRV_GROUPNONUNIFORMFADD", 417 },
    { "__SPIRV_GROUPNONUNIFORMFMAX", 418 },
    { "__SPIRV_GROUPNONUNIFORMFMIN", 419 },
    { "__SPIRV_GROUPNONUNIFORMFMUL", 420 },
    { "__SPIRV_GROUPNONUNIFORMIADD", 421 },
    { "__SPIRV_GROUPNONUNIFORMIMUL", 422 },
    { "__SPIRV_GROUPNONUNIFORMINVERSEBALLOT", 423 },
    { "__SPIRV_GROUPNONUNIFORMLOGICALAND", 424 },
    { "__SPIRV_GROUPNONUNIFORMLOGICALOR", 425 },
    { "__SPIRV_GROUPNONUNIFORMLOGICALXOR", 426 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLE", 427 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLEDOWN", 428 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLEUP", 429 },
    { "__SPIRV_GROUPNONUNIFORMSHUFFLEXOR", 430 },
    { "__SPIRV_GROUPNONUNIFORMSMAX", 431 },
    { "__SPIRV_GROUPNONUNIFORMSMIN", 432 },
    { "__SPIRV_GROUPNONUNIFORMUMAX", 433 },
    { "__SPIRV_GROUPNONUNIFORMUMIN", 434 },
    { "__SPIRV_GROUPSMAX", 435 },
    { "__SPIRV_GROUPSMIN", 436 },
    { "__SPIRV_GROUPUMAX", 437 },
    { "__SPIRV_GROUPUMIN", 438 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;

  return &GroupBuiltins[Idx->_index];
}
#endif

#ifdef GET_GroupUniformBuiltins_DECL
const GroupUniformBuiltin *lookupGroupUniformBuiltin(StringRef Name);
#endif

#ifdef GET_GroupUniformBuiltins_IMPL
constexpr GroupUniformBuiltin GroupUniformBuiltins[] = {
  { "__spirv_GroupBitwiseAndKHR", OpGroupBitwiseAndKHR, false }, // 0
  { "__spirv_GroupBitwiseOrKHR", OpGroupBitwiseOrKHR, false }, // 1
  { "__spirv_GroupBitwiseXorKHR", OpGroupBitwiseXorKHR, false }, // 2
  { "__spirv_GroupFMulKHR", OpGroupFMulKHR, false }, // 3
  { "__spirv_GroupIMulKHR", OpGroupIMulKHR, false }, // 4
  { "__spirv_GroupLogicalAndKHR", OpGroupLogicalAndKHR, true }, // 5
  { "__spirv_GroupLogicalOrKHR", OpGroupLogicalOrKHR, true }, // 6
  { "__spirv_GroupLogicalXorKHR", OpGroupLogicalXorKHR, true }, // 7
 };

const GroupUniformBuiltin *lookupGroupUniformBuiltin(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "__SPIRV_GROUPBITWISEANDKHR", 0 },
    { "__SPIRV_GROUPBITWISEORKHR", 1 },
    { "__SPIRV_GROUPBITWISEXORKHR", 2 },
    { "__SPIRV_GROUPFMULKHR", 3 },
    { "__SPIRV_GROUPIMULKHR", 4 },
    { "__SPIRV_GROUPLOGICALANDKHR", 5 },
    { "__SPIRV_GROUPLOGICALORKHR", 6 },
    { "__SPIRV_GROUPLOGICALXORKHR", 7 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;

  return &GroupUniformBuiltins[Idx->_index];
}
#endif

#ifdef GET_ImageQueryBuiltins_DECL
const ImageQueryBuiltin *lookupImageQueryBuiltin(StringRef Name, unsigned Set);
#endif

#ifdef GET_ImageQueryBuiltins_IMPL
constexpr ImageQueryBuiltin ImageQueryBuiltins[] = {
  { "get_image_array_size", OpenCL_std, 0x3 }, // 0
  { "get_image_depth", OpenCL_std, 0x2 }, // 1
  { "get_image_dim", OpenCL_std, 0x0 }, // 2
  { "get_image_height", OpenCL_std, 0x1 }, // 3
  { "get_image_width", OpenCL_std, 0x0 }, // 4
 };

const ImageQueryBuiltin *lookupImageQueryBuiltin(StringRef Name, unsigned Set) {
  struct IndexType {
    const char * Name;
    unsigned Set;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "GET_IMAGE_ARRAY_SIZE", OpenCL_std, 0 },
    { "GET_IMAGE_DEPTH", OpenCL_std, 1 },
    { "GET_IMAGE_DIM", OpenCL_std, 2 },
    { "GET_IMAGE_HEIGHT", OpenCL_std, 3 },
    { "GET_IMAGE_WIDTH", OpenCL_std, 4 },
  };

  struct KeyType {
    std::string Name;
    unsigned Set;
  };
  KeyType Key = {Name.upper(), Set};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name ||
      Key.Set != Idx->Set)
    return nullptr;

  return &ImageQueryBuiltins[Idx->_index];
}
#endif

#ifdef GET_IntelSubgroupsBuiltins_DECL
const IntelSubgroupsBuiltin *lookupIntelSubgroupsBuiltin(StringRef Name);
#endif

#ifdef GET_IntelSubgroupsBuiltins_IMPL
constexpr IntelSubgroupsBuiltin IntelSubgroupsBuiltins[] = {
  { "intel_sub_group_block_read", OpSubgroupBlockReadINTEL, true, false, false }, // 0
  { "intel_sub_group_block_read2", OpSubgroupBlockReadINTEL, true, false, false }, // 1
  { "intel_sub_group_block_read4", OpSubgroupBlockReadINTEL, true, false, false }, // 2
  { "intel_sub_group_block_read8", OpSubgroupBlockReadINTEL, true, false, false }, // 3
  { "intel_sub_group_block_read_uc", OpSubgroupBlockReadINTEL, true, false, false }, // 4
  { "intel_sub_group_block_read_uc16", OpSubgroupBlockReadINTEL, true, false, false }, // 5
  { "intel_sub_group_block_read_uc2", OpSubgroupBlockReadINTEL, true, false, false }, // 6
  { "intel_sub_group_block_read_uc4", OpSubgroupBlockReadINTEL, true, false, false }, // 7
  { "intel_sub_group_block_read_uc8", OpSubgroupBlockReadINTEL, true, false, false }, // 8
  { "intel_sub_group_block_read_ui", OpSubgroupBlockReadINTEL, true, false, false }, // 9
  { "intel_sub_group_block_read_ui2", OpSubgroupBlockReadINTEL, true, false, false }, // 10
  { "intel_sub_group_block_read_ui4", OpSubgroupBlockReadINTEL, true, false, false }, // 11
  { "intel_sub_group_block_read_ui8", OpSubgroupBlockReadINTEL, true, false, false }, // 12
  { "intel_sub_group_block_read_ul", OpSubgroupBlockReadINTEL, true, false, false }, // 13
  { "intel_sub_group_block_read_ul16", OpSubgroupBlockReadINTEL, true, false, false }, // 14
  { "intel_sub_group_block_read_ul2", OpSubgroupBlockReadINTEL, true, false, false }, // 15
  { "intel_sub_group_block_read_ul4", OpSubgroupBlockReadINTEL, true, false, false }, // 16
  { "intel_sub_group_block_read_ul8", OpSubgroupBlockReadINTEL, true, false, false }, // 17
  { "intel_sub_group_block_read_us", OpSubgroupBlockReadINTEL, true, false, false }, // 18
  { "intel_sub_group_block_read_us16", OpSubgroupBlockReadINTEL, true, false, false }, // 19
  { "intel_sub_group_block_read_us2", OpSubgroupBlockReadINTEL, true, false, false }, // 20
  { "intel_sub_group_block_read_us4", OpSubgroupBlockReadINTEL, true, false, false }, // 21
  { "intel_sub_group_block_read_us8", OpSubgroupBlockReadINTEL, true, false, false }, // 22
  { "intel_sub_group_block_write", OpSubgroupBlockWriteINTEL, true, true, false }, // 23
  { "intel_sub_group_block_write2", OpSubgroupBlockWriteINTEL, true, true, false }, // 24
  { "intel_sub_group_block_write4", OpSubgroupBlockWriteINTEL, true, true, false }, // 25
  { "intel_sub_group_block_write8", OpSubgroupBlockWriteINTEL, true, true, false }, // 26
  { "intel_sub_group_block_write_uc", OpSubgroupBlockWriteINTEL, true, true, false }, // 27
  { "intel_sub_group_block_write_uc16", OpSubgroupBlockWriteINTEL, true, true, false }, // 28
  { "intel_sub_group_block_write_uc2", OpSubgroupBlockWriteINTEL, true, true, false }, // 29
  { "intel_sub_group_block_write_uc4", OpSubgroupBlockWriteINTEL, true, true, false }, // 30
  { "intel_sub_group_block_write_uc8", OpSubgroupBlockWriteINTEL, true, true, false }, // 31
  { "intel_sub_group_block_write_ui", OpSubgroupBlockWriteINTEL, true, true, false }, // 32
  { "intel_sub_group_block_write_ui2", OpSubgroupBlockWriteINTEL, true, true, false }, // 33
  { "intel_sub_group_block_write_ui4", OpSubgroupBlockWriteINTEL, true, true, false }, // 34
  { "intel_sub_group_block_write_ui8", OpSubgroupBlockWriteINTEL, true, true, false }, // 35
  { "intel_sub_group_block_write_ul", OpSubgroupBlockWriteINTEL, true, true, false }, // 36
  { "intel_sub_group_block_write_ul16", OpSubgroupBlockWriteINTEL, true, true, false }, // 37
  { "intel_sub_group_block_write_ul2", OpSubgroupBlockWriteINTEL, true, true, false }, // 38
  { "intel_sub_group_block_write_ul4", OpSubgroupBlockWriteINTEL, true, true, false }, // 39
  { "intel_sub_group_block_write_ul8", OpSubgroupBlockWriteINTEL, true, true, false }, // 40
  { "intel_sub_group_block_write_us", OpSubgroupBlockWriteINTEL, true, true, false }, // 41
  { "intel_sub_group_block_write_us16", OpSubgroupBlockWriteINTEL, true, true, false }, // 42
  { "intel_sub_group_block_write_us2", OpSubgroupBlockWriteINTEL, true, true, false }, // 43
  { "intel_sub_group_block_write_us4", OpSubgroupBlockWriteINTEL, true, true, false }, // 44
  { "intel_sub_group_block_write_us8", OpSubgroupBlockWriteINTEL, true, true, false }, // 45
  { "intel_sub_group_media_block_read", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 46
  { "intel_sub_group_media_block_read2", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 47
  { "intel_sub_group_media_block_read4", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 48
  { "intel_sub_group_media_block_read8", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 49
  { "intel_sub_group_media_block_read_uc", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 50
  { "intel_sub_group_media_block_read_uc16", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 51
  { "intel_sub_group_media_block_read_uc2", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 52
  { "intel_sub_group_media_block_read_uc4", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 53
  { "intel_sub_group_media_block_read_uc8", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 54
  { "intel_sub_group_media_block_read_ui", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 55
  { "intel_sub_group_media_block_read_ui2", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 56
  { "intel_sub_group_media_block_read_ui4", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 57
  { "intel_sub_group_media_block_read_ui8", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 58
  { "intel_sub_group_media_block_read_ul", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 59
  { "intel_sub_group_media_block_read_ul16", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 60
  { "intel_sub_group_media_block_read_ul2", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 61
  { "intel_sub_group_media_block_read_ul4", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 62
  { "intel_sub_group_media_block_read_ul8", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 63
  { "intel_sub_group_media_block_read_us", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 64
  { "intel_sub_group_media_block_read_us16", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 65
  { "intel_sub_group_media_block_read_us2", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 66
  { "intel_sub_group_media_block_read_us4", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 67
  { "intel_sub_group_media_block_read_us8", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 68
  { "intel_sub_group_media_block_write", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 69
  { "intel_sub_group_media_block_write2", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 70
  { "intel_sub_group_media_block_write4", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 71
  { "intel_sub_group_media_block_write8", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 72
  { "intel_sub_group_media_block_write_uc", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 73
  { "intel_sub_group_media_block_write_uc16", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 74
  { "intel_sub_group_media_block_write_uc2", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 75
  { "intel_sub_group_media_block_write_uc4", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 76
  { "intel_sub_group_media_block_write_uc8", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 77
  { "intel_sub_group_media_block_write_ui", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 78
  { "intel_sub_group_media_block_write_ui2", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 79
  { "intel_sub_group_media_block_write_ui4", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 80
  { "intel_sub_group_media_block_write_ui8", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 81
  { "intel_sub_group_media_block_write_ul", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 82
  { "intel_sub_group_media_block_write_ul16", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 83
  { "intel_sub_group_media_block_write_ul2", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 84
  { "intel_sub_group_media_block_write_ul4", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 85
  { "intel_sub_group_media_block_write_ul8", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 86
  { "intel_sub_group_media_block_write_us", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 87
  { "intel_sub_group_media_block_write_us16", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 88
  { "intel_sub_group_media_block_write_us2", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 89
  { "intel_sub_group_media_block_write_us4", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 90
  { "intel_sub_group_media_block_write_us8", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 91
  { "intel_sub_group_shuffle", OpSubgroupShuffleINTEL, false, false, false }, // 92
  { "intel_sub_group_shuffle_down", OpSubgroupShuffleDownINTEL, false, false, false }, // 93
  { "intel_sub_group_shuffle_up", OpSubgroupShuffleUpINTEL, false, false, false }, // 94
  { "intel_sub_group_shuffle_xor", OpSubgroupShuffleXorINTEL, false, false, false }, // 95
  { "__spirv_SubgroupBlockReadINTEL", OpSubgroupBlockReadINTEL, true, false, false }, // 96
  { "__spirv_SubgroupBlockWriteINTEL", OpSubgroupBlockWriteINTEL, true, true, false }, // 97
  { "__spirv_SubgroupImageBlockReadINTEL", OpSubgroupImageBlockReadINTEL, false, false, false }, // 98
  { "__spirv_SubgroupImageBlockWriteINTEL", OpSubgroupImageBlockWriteINTEL, false, false, false }, // 99
  { "__spirv_SubgroupImageMediaBlockReadINTEL", OpSubgroupImageMediaBlockReadINTEL, true, false, true }, // 100
  { "__spirv_SubgroupImageMediaBlockWriteINTEL", OpSubgroupImageMediaBlockWriteINTEL, true, true, true }, // 101
  { "__spirv_SubgroupShuffleDownINTEL", OpSubgroupShuffleDownINTEL, false, false, false }, // 102
  { "__spirv_SubgroupShuffleINTEL", OpSubgroupShuffleINTEL, false, false, false }, // 103
  { "__spirv_SubgroupShuffleUpINTEL", OpSubgroupShuffleUpINTEL, false, false, false }, // 104
  { "__spirv_SubgroupShuffleXorINTEL", OpSubgroupShuffleXorINTEL, false, false, false }, // 105
 };

const IntelSubgroupsBuiltin *lookupIntelSubgroupsBuiltin(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "INTEL_SUB_GROUP_BLOCK_READ", 0 },
    { "INTEL_SUB_GROUP_BLOCK_READ2", 1 },
    { "INTEL_SUB_GROUP_BLOCK_READ4", 2 },
    { "INTEL_SUB_GROUP_BLOCK_READ8", 3 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC", 4 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC16", 5 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC2", 6 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC4", 7 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UC8", 8 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI", 9 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI2", 10 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI4", 11 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UI8", 12 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL", 13 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL16", 14 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL2", 15 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL4", 16 },
    { "INTEL_SUB_GROUP_BLOCK_READ_UL8", 17 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US", 18 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US16", 19 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US2", 20 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US4", 21 },
    { "INTEL_SUB_GROUP_BLOCK_READ_US8", 22 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE", 23 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE2", 24 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE4", 25 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE8", 26 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC", 27 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC16", 28 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC2", 29 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC4", 30 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UC8", 31 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI", 32 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI2", 33 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI4", 34 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UI8", 35 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL", 36 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL16", 37 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL2", 38 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL4", 39 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_UL8", 40 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US", 41 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US16", 42 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US2", 43 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US4", 44 },
    { "INTEL_SUB_GROUP_BLOCK_WRITE_US8", 45 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ", 46 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ2", 47 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ4", 48 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ8", 49 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC", 50 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC16", 51 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC2", 52 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC4", 53 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UC8", 54 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI", 55 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI2", 56 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI4", 57 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UI8", 58 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL", 59 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL16", 60 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL2", 61 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL4", 62 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_UL8", 63 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US", 64 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US16", 65 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US2", 66 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US4", 67 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_READ_US8", 68 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE", 69 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE2", 70 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE4", 71 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE8", 72 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC", 73 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC16", 74 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC2", 75 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC4", 76 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UC8", 77 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI", 78 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI2", 79 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI4", 80 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UI8", 81 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL", 82 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL16", 83 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL2", 84 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL4", 85 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_UL8", 86 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US", 87 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US16", 88 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US2", 89 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US4", 90 },
    { "INTEL_SUB_GROUP_MEDIA_BLOCK_WRITE_US8", 91 },
    { "INTEL_SUB_GROUP_SHUFFLE", 92 },
    { "INTEL_SUB_GROUP_SHUFFLE_DOWN", 93 },
    { "INTEL_SUB_GROUP_SHUFFLE_UP", 94 },
    { "INTEL_SUB_GROUP_SHUFFLE_XOR", 95 },
    { "__SPIRV_SUBGROUPBLOCKREADINTEL", 96 },
    { "__SPIRV_SUBGROUPBLOCKWRITEINTEL", 97 },
    { "__SPIRV_SUBGROUPIMAGEBLOCKREADINTEL", 98 },
    { "__SPIRV_SUBGROUPIMAGEBLOCKWRITEINTEL", 99 },
    { "__SPIRV_SUBGROUPIMAGEMEDIABLOCKREADINTEL", 100 },
    { "__SPIRV_SUBGROUPIMAGEMEDIABLOCKWRITEINTEL", 101 },
    { "__SPIRV_SUBGROUPSHUFFLEDOWNINTEL", 102 },
    { "__SPIRV_SUBGROUPSHUFFLEINTEL", 103 },
    { "__SPIRV_SUBGROUPSHUFFLEUPINTEL", 104 },
    { "__SPIRV_SUBGROUPSHUFFLEXORINTEL", 105 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;

  return &IntelSubgroupsBuiltins[Idx->_index];
}
#endif

#ifdef GET_NativeBuiltins_DECL
const NativeBuiltin *lookupNativeBuiltin(StringRef Name, unsigned Set);
#endif

#ifdef GET_NativeBuiltins_IMPL
constexpr NativeBuiltin NativeBuiltins[] = {
  { "all", OpenCL_std, OpAll }, // 0
  { "any", OpenCL_std, OpAny }, // 1
  { "async_work_group_copy", OpenCL_std, OpGroupAsyncCopy }, // 2
  { "async_work_group_strided_copy", OpenCL_std, OpGroupAsyncCopy }, // 3
  { "AtomicEx__spirv_change", OpenCL_std, OpAtomicExchange }, // 4
  { "atomic_add", OpenCL_std, OpAtomicIAdd }, // 5
  { "atomic_and", OpenCL_std, OpAtomicAnd }, // 6
  { "atomic_cmpxchg", OpenCL_std, OpAtomicCompareExchange }, // 7
  { "atomic_compare_exchange_strong", OpenCL_std, OpAtomicCompareExchange }, // 8
  { "atomic_compare_exchange_strong_explicit", OpenCL_std, OpAtomicCompareExchange }, // 9
  { "atomic_compare_exchange_weak", OpenCL_std, OpAtomicCompareExchangeWeak }, // 10
  { "atomic_compare_exchange_weak_explicit", OpenCL_std, OpAtomicCompareExchangeWeak }, // 11
  { "atomic_exchange", OpenCL_std, OpAtomicExchange }, // 12
  { "atomic_exchange_explicit", OpenCL_std, OpAtomicExchange }, // 13
  { "atomic_fetch_add", OpenCL_std, OpAtomicIAdd }, // 14
  { "atomic_fetch_add_explicit", OpenCL_std, OpAtomicIAdd }, // 15
  { "atomic_fetch_and", OpenCL_std, OpAtomicAnd }, // 16
  { "atomic_fetch_and_explicit", OpenCL_std, OpAtomicAnd }, // 17
  { "atomic_fetch_or", OpenCL_std, OpAtomicOr }, // 18
  { "atomic_fetch_or_explicit", OpenCL_std, OpAtomicOr }, // 19
  { "atomic_fetch_sub", OpenCL_std, OpAtomicISub }, // 20
  { "atomic_fetch_sub_explicit", OpenCL_std, OpAtomicISub }, // 21
  { "atomic_fetch_xor", OpenCL_std, OpAtomicXor }, // 22
  { "atomic_fetch_xor_explicit", OpenCL_std, OpAtomicXor }, // 23
  { "atomic_flag_clear", OpenCL_std, OpAtomicFlagClear }, // 24
  { "atomic_flag_clear_explicit", OpenCL_std, OpAtomicFlagClear }, // 25
  { "atomic_flag_test_and_set", OpenCL_std, OpAtomicFlagTestAndSet }, // 26
  { "atomic_flag_test_and_set_explicit", OpenCL_std, OpAtomicFlagTestAndSet }, // 27
  { "atomic_init", OpenCL_std, OpStore }, // 28
  { "atomic_load", OpenCL_std, OpAtomicLoad }, // 29
  { "atomic_load_explicit", OpenCL_std, OpAtomicLoad }, // 30
  { "atomic_or", OpenCL_std, OpAtomicOr }, // 31
  { "atomic_store", OpenCL_std, OpAtomicStore }, // 32
  { "atomic_store_explicit", OpenCL_std, OpAtomicStore }, // 33
  { "atomic_sub", OpenCL_std, OpAtomicISub }, // 34
  { "atomic_work_item_fence", OpenCL_std, OpMemoryBarrier }, // 35
  { "atomic_xor", OpenCL_std, OpAtomicXor }, // 36
  { "atom_add", OpenCL_std, OpAtomicIAdd }, // 37
  { "atom_and", OpenCL_std, OpAtomicAnd }, // 38
  { "atom_cmpxchg", OpenCL_std, OpAtomicCompareExchange }, // 39
  { "atom_or", OpenCL_std, OpAtomicOr }, // 40
  { "atom_sub", OpenCL_std, OpAtomicISub }, // 41
  { "atom_xor", OpenCL_std, OpAtomicXor }, // 42
  { "barrier", OpenCL_std, OpControlBarrier }, // 43
  { "capture_event_profiling_info", OpenCL_std, OpCaptureEventProfilingInfo }, // 44
  { "clock_read_device", OpenCL_std, OpReadClockKHR }, // 45
  { "clock_read_hilo_device", OpenCL_std, OpReadClockKHR }, // 46
  { "clock_read_hilo_sub_group", OpenCL_std, OpReadClockKHR }, // 47
  { "clock_read_hilo_work_group", OpenCL_std, OpReadClockKHR }, // 48
  { "clock_read_sub_group", OpenCL_std, OpReadClockKHR }, // 49
  { "clock_read_work_group", OpenCL_std, OpReadClockKHR }, // 50
  { "create_user_event", OpenCL_std, OpCreateUserEvent }, // 51
  { "get_default_queue", OpenCL_std, OpGetDefaultQueue }, // 52
  { "get_image_num_mip_levels", OpenCL_std, OpImageQueryLevels }, // 53
  { "get_image_num_samples", OpenCL_std, OpImageQuerySamples }, // 54
  { "intel_work_group_barrier_arrive", OpenCL_std, OpControlBarrierArriveINTEL }, // 55
  { "intel_work_group_barrier_wait", OpenCL_std, OpControlBarrierWaitINTEL }, // 56
  { "isequal", OpenCL_std, OpFOrdEqual }, // 57
  { "isfinite", OpenCL_std, OpIsFinite }, // 58
  { "isgreater", OpenCL_std, OpFOrdGreaterThan }, // 59
  { "isgreaterequal", OpenCL_std, OpFOrdGreaterThanEqual }, // 60
  { "isinf", OpenCL_std, OpIsInf }, // 61
  { "isless", OpenCL_std, OpFOrdLessThan }, // 62
  { "islessequal", OpenCL_std, OpFOrdLessThanEqual }, // 63
  { "islessgreater", OpenCL_std, OpFOrdNotEqual }, // 64
  { "isnan", OpenCL_std, OpIsNan }, // 65
  { "isnormal", OpenCL_std, OpIsNormal }, // 66
  { "isnotequal", OpenCL_std, OpFUnordNotEqual }, // 67
  { "isordered", OpenCL_std, OpOrdered }, // 68
  { "isunordered", OpenCL_std, OpUnordered }, // 69
  { "is_valid_event", OpenCL_std, OpIsValidEvent }, // 70
  { "ndrange_1D", OpenCL_std, OpBuildNDRange }, // 71
  { "ndrange_2D", OpenCL_std, OpBuildNDRange }, // 72
  { "ndrange_3D", OpenCL_std, OpBuildNDRange }, // 73
  { "release_event", OpenCL_std, OpReleaseEvent }, // 74
  { "retain_event", OpenCL_std, OpRetainEvent }, // 75
  { "set_user_event_status", OpenCL_std, OpSetUserEventStatus }, // 76
  { "signbit", OpenCL_std, OpSignBitSet }, // 77
  { "to_global", OpenCL_std, OpGenericCastToPtr }, // 78
  { "to_local", OpenCL_std, OpGenericCastToPtr }, // 79
  { "to_private", OpenCL_std, OpGenericCastToPtr }, // 80
  { "wait_group_events", OpenCL_std, OpGroupWaitEvents }, // 81
  { "work_group_barrier", OpenCL_std, OpControlBarrier }, // 82
  { "__enqueue_kernel_basic", OpenCL_std, OpEnqueueKernel }, // 83
  { "__enqueue_kernel_basic_events", OpenCL_std, OpEnqueueKernel }, // 84
  { "__enqueue_kernel_events_varargs", OpenCL_std, OpEnqueueKernel }, // 85
  { "__enqueue_kernel_varargs", OpenCL_std, OpEnqueueKernel }, // 86
  { "__spirv_All", OpenCL_std, OpAll }, // 87
  { "__spirv_Any", OpenCL_std, OpAny }, // 88
  { "__spirv_AtomicAnd", OpenCL_std, OpAtomicAnd }, // 89
  { "__spirv_AtomicCompareExchange", OpenCL_std, OpAtomicCompareExchange }, // 90
  { "__spirv_AtomicCompareExchangeWeak", OpenCL_std, OpAtomicCompareExchangeWeak }, // 91
  { "__spirv_AtomicExchange", OpenCL_std, OpAtomicExchange }, // 92
  { "__spirv_AtomicFlagClear", OpenCL_std, OpAtomicFlagClear }, // 93
  { "__spirv_AtomicFlagTestAndSet", OpenCL_std, OpAtomicFlagTestAndSet }, // 94
  { "__spirv_AtomicIAdd", OpenCL_std, OpAtomicIAdd }, // 95
  { "__spirv_AtomicISub", OpenCL_std, OpAtomicISub }, // 96
  { "__spirv_AtomicLoad", OpenCL_std, OpAtomicLoad }, // 97
  { "__spirv_AtomicOr", OpenCL_std, OpAtomicOr }, // 98
  { "__spirv_AtomicSMax", OpenCL_std, OpAtomicSMax }, // 99
  { "__spirv_AtomicSMin", OpenCL_std, OpAtomicSMin }, // 100
  { "__spirv_AtomicStore", OpenCL_std, OpAtomicStore }, // 101
  { "__spirv_AtomicUMax", OpenCL_std, OpAtomicUMax }, // 102
  { "__spirv_AtomicUMin", OpenCL_std, OpAtomicUMin }, // 103
  { "__spirv_AtomicXor", OpenCL_std, OpAtomicXor }, // 104
  { "__spirv_CaptureEventProfilingInfo", OpenCL_std, OpCaptureEventProfilingInfo }, // 105
  { "__spirv_ControlBarrier", OpenCL_std, OpControlBarrier }, // 106
  { "__spirv_ControlBarrierArriveINTEL", OpenCL_std, OpControlBarrierArriveINTEL }, // 107
  { "__spirv_ControlBarrierWaitINTEL", OpenCL_std, OpControlBarrierWaitINTEL }, // 108
  { "__spirv_ConvertFToS", OpenCL_std, OpConvertFToS }, // 109
  { "__spirv_ConvertFToU", OpenCL_std, OpConvertFToU }, // 110
  { "__spirv_ConvertPtrToU", OpenCL_std, OpConvertPtrToU }, // 111
  { "__spirv_ConvertSToF", OpenCL_std, OpConvertSToF }, // 112
  { "__spirv_ConvertUToF", OpenCL_std, OpConvertUToF }, // 113
  { "__spirv_ConvertUToPtr", OpenCL_std, OpConvertUToPtr }, // 114
  { "__spirv_CooperativeMatrixConstructCheckedINTEL", OpenCL_std, OpCooperativeMatrixConstructCheckedINTEL }, // 115
  { "__spirv_CooperativeMatrixGetElementCoordINTEL", OpenCL_std, OpCooperativeMatrixGetElementCoordINTEL }, // 116
  { "__spirv_CooperativeMatrixLengthKHR", OpenCL_std, OpCooperativeMatrixLengthKHR }, // 117
  { "__spirv_CooperativeMatrixLoadCheckedINTEL", OpenCL_std, OpCooperativeMatrixLoadCheckedINTEL }, // 118
  { "__spirv_CooperativeMatrixLoadKHR", OpenCL_std, OpCooperativeMatrixLoadKHR }, // 119
  { "__spirv_CooperativeMatrixMulAddKHR", OpenCL_std, OpCooperativeMatrixMulAddKHR }, // 120
  { "__spirv_CooperativeMatrixPrefetchINTEL", OpenCL_std, OpCooperativeMatrixPrefetchINTEL }, // 121
  { "__spirv_CooperativeMatrixStoreCheckedINTEL", OpenCL_std, OpCooperativeMatrixStoreCheckedINTEL }, // 122
  { "__spirv_CooperativeMatrixStoreKHR", OpenCL_std, OpCooperativeMatrixStoreKHR }, // 123
  { "__spirv_CreateUserEvent", OpenCL_std, OpCreateUserEvent }, // 124
  { "__spirv_EnqueueKernel", OpenCL_std, OpEnqueueKernel }, // 125
  { "__spirv_FConvert", OpenCL_std, OpFConvert }, // 126
  { "__spirv_FOrdEqual", OpenCL_std, OpFOrdEqual }, // 127
  { "__spirv_FOrdGreaterThan", OpenCL_std, OpFOrdGreaterThan }, // 128
  { "__spirv_FOrdGreaterThanEqual", OpenCL_std, OpFOrdGreaterThanEqual }, // 129
  { "__spirv_FOrdLessThan", OpenCL_std, OpFOrdLessThan }, // 130
  { "__spirv_FOrdLessThanEqual", OpenCL_std, OpFOrdLessThanEqual }, // 131
  { "__spirv_FOrdNotEqual", OpenCL_std, OpFOrdNotEqual }, // 132
  { "__spirv_FUnordNotEqual", OpenCL_std, OpFUnordNotEqual }, // 133
  { "__spirv_GenericCastToPtrExplicit_ToGlobal", OpenCL_std, OpGenericCastToPtr }, // 134
  { "__spirv_GenericCastToPtrExplicit_ToLocal", OpenCL_std, OpGenericCastToPtr }, // 135
  { "__spirv_GenericCastToPtrExplicit_ToPrivate", OpenCL_std, OpGenericCastToPtr }, // 136
  { "__spirv_GenericCastToPtr_ToGlobal", OpenCL_std, OpGenericCastToPtr }, // 137
  { "__spirv_GenericCastToPtr_ToLocal", OpenCL_std, OpGenericCastToPtr }, // 138
  { "__spirv_GenericCastToPtr_ToPrivate", OpenCL_std, OpGenericCastToPtr }, // 139
  { "__spirv_GetDefaultQueue", OpenCL_std, OpGetDefaultQueue }, // 140
  { "__spirv_GroupAsyncCopy", OpenCL_std, OpGroupAsyncCopy }, // 141
  { "__spirv_GroupWaitEvents", OpenCL_std, OpGroupWaitEvents }, // 142
  { "__spirv_IAddCarry", OpenCL_std, OpIAddCarryS }, // 143
  { "__spirv_IsFinite", OpenCL_std, OpIsFinite }, // 144
  { "__spirv_IsInf", OpenCL_std, OpIsInf }, // 145
  { "__spirv_IsNan", OpenCL_std, OpIsNan }, // 146
  { "__spirv_IsNormal", OpenCL_std, OpIsNormal }, // 147
  { "__spirv_ISubBorrow", OpenCL_std, OpISubBorrowS }, // 148
  { "__spirv_IsValidEvent", OpenCL_std, OpIsValidEvent }, // 149
  { "__spirv_Load", OpenCL_std, OpLoad }, // 150
  { "__spirv_MemoryBarrier", OpenCL_std, OpMemoryBarrier }, // 151
  { "__spirv_Ordered", OpenCL_std, OpOrdered }, // 152
  { "__spirv_QuantizeToF16", OpenCL_std, OpQuantizeToF16 }, // 153
  { "__spirv_ReleaseEvent", OpenCL_std, OpReleaseEvent }, // 154
  { "__spirv_RetainEvent", OpenCL_std, OpRetainEvent }, // 155
  { "__spirv_SatConvertSToU", OpenCL_std, OpSatConvertSToU }, // 156
  { "__spirv_SatConvertUToS", OpenCL_std, OpSatConvertUToS }, // 157
  { "__spirv_SConvert", OpenCL_std, OpSConvert }, // 158
  { "__spirv_SetUserEventStatus", OpenCL_std, OpSetUserEventStatus }, // 159
  { "__spirv_SignBitSet", OpenCL_std, OpSignBitSet }, // 160
  { "__spirv_SpecConstant", OpenCL_std, OpSpecConstant }, // 161
  { "__spirv_SpecConstantComposite", OpenCL_std, OpSpecConstantComposite }, // 162
  { "__spirv_Store", OpenCL_std, OpStore }, // 163
  { "__spirv_UConvert", OpenCL_std, OpUConvert }, // 164
  { "__spirv_Unordered", OpenCL_std, OpUnordered }, // 165
 };

const NativeBuiltin *lookupNativeBuiltin(StringRef Name, unsigned Set) {
  struct IndexType {
    const char * Name;
    unsigned Set;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "ALL", OpenCL_std, 0 },
    { "ANY", OpenCL_std, 1 },
    { "ASYNC_WORK_GROUP_COPY", OpenCL_std, 2 },
    { "ASYNC_WORK_GROUP_STRIDED_COPY", OpenCL_std, 3 },
    { "ATOMICEX__SPIRV_CHANGE", OpenCL_std, 4 },
    { "ATOMIC_ADD", OpenCL_std, 5 },
    { "ATOMIC_AND", OpenCL_std, 6 },
    { "ATOMIC_CMPXCHG", OpenCL_std, 7 },
    { "ATOMIC_COMPARE_EXCHANGE_STRONG", OpenCL_std, 8 },
    { "ATOMIC_COMPARE_EXCHANGE_STRONG_EXPLICIT", OpenCL_std, 9 },
    { "ATOMIC_COMPARE_EXCHANGE_WEAK", OpenCL_std, 10 },
    { "ATOMIC_COMPARE_EXCHANGE_WEAK_EXPLICIT", OpenCL_std, 11 },
    { "ATOMIC_EXCHANGE", OpenCL_std, 12 },
    { "ATOMIC_EXCHANGE_EXPLICIT", OpenCL_std, 13 },
    { "ATOMIC_FETCH_ADD", OpenCL_std, 14 },
    { "ATOMIC_FETCH_ADD_EXPLICIT", OpenCL_std, 15 },
    { "ATOMIC_FETCH_AND", OpenCL_std, 16 },
    { "ATOMIC_FETCH_AND_EXPLICIT", OpenCL_std, 17 },
    { "ATOMIC_FETCH_OR", OpenCL_std, 18 },
    { "ATOMIC_FETCH_OR_EXPLICIT", OpenCL_std, 19 },
    { "ATOMIC_FETCH_SUB", OpenCL_std, 20 },
    { "ATOMIC_FETCH_SUB_EXPLICIT", OpenCL_std, 21 },
    { "ATOMIC_FETCH_XOR", OpenCL_std, 22 },
    { "ATOMIC_FETCH_XOR_EXPLICIT", OpenCL_std, 23 },
    { "ATOMIC_FLAG_CLEAR", OpenCL_std, 24 },
    { "ATOMIC_FLAG_CLEAR_EXPLICIT", OpenCL_std, 25 },
    { "ATOMIC_FLAG_TEST_AND_SET", OpenCL_std, 26 },
    { "ATOMIC_FLAG_TEST_AND_SET_EXPLICIT", OpenCL_std, 27 },
    { "ATOMIC_INIT", OpenCL_std, 28 },
    { "ATOMIC_LOAD", OpenCL_std, 29 },
    { "ATOMIC_LOAD_EXPLICIT", OpenCL_std, 30 },
    { "ATOMIC_OR", OpenCL_std, 31 },
    { "ATOMIC_STORE", OpenCL_std, 32 },
    { "ATOMIC_STORE_EXPLICIT", OpenCL_std, 33 },
    { "ATOMIC_SUB", OpenCL_std, 34 },
    { "ATOMIC_WORK_ITEM_FENCE", OpenCL_std, 35 },
    { "ATOMIC_XOR", OpenCL_std, 36 },
    { "ATOM_ADD", OpenCL_std, 37 },
    { "ATOM_AND", OpenCL_std, 38 },
    { "ATOM_CMPXCHG", OpenCL_std, 39 },
    { "ATOM_OR", OpenCL_std, 40 },
    { "ATOM_SUB", OpenCL_std, 41 },
    { "ATOM_XOR", OpenCL_std, 42 },
    { "BARRIER", OpenCL_std, 43 },
    { "CAPTURE_EVENT_PROFILING_INFO", OpenCL_std, 44 },
    { "CLOCK_READ_DEVICE", OpenCL_std, 45 },
    { "CLOCK_READ_HILO_DEVICE", OpenCL_std, 46 },
    { "CLOCK_READ_HILO_SUB_GROUP", OpenCL_std, 47 },
    { "CLOCK_READ_HILO_WORK_GROUP", OpenCL_std, 48 },
    { "CLOCK_READ_SUB_GROUP", OpenCL_std, 49 },
    { "CLOCK_READ_WORK_GROUP", OpenCL_std, 50 },
    { "CREATE_USER_EVENT", OpenCL_std, 51 },
    { "GET_DEFAULT_QUEUE", OpenCL_std, 52 },
    { "GET_IMAGE_NUM_MIP_LEVELS", OpenCL_std, 53 },
    { "GET_IMAGE_NUM_SAMPLES", OpenCL_std, 54 },
    { "INTEL_WORK_GROUP_BARRIER_ARRIVE", OpenCL_std, 55 },
    { "INTEL_WORK_GROUP_BARRIER_WAIT", OpenCL_std, 56 },
    { "ISEQUAL", OpenCL_std, 57 },
    { "ISFINITE", OpenCL_std, 58 },
    { "ISGREATER", OpenCL_std, 59 },
    { "ISGREATEREQUAL", OpenCL_std, 60 },
    { "ISINF", OpenCL_std, 61 },
    { "ISLESS", OpenCL_std, 62 },
    { "ISLESSEQUAL", OpenCL_std, 63 },
    { "ISLESSGREATER", OpenCL_std, 64 },
    { "ISNAN", OpenCL_std, 65 },
    { "ISNORMAL", OpenCL_std, 66 },
    { "ISNOTEQUAL", OpenCL_std, 67 },
    { "ISORDERED", OpenCL_std, 68 },
    { "ISUNORDERED", OpenCL_std, 69 },
    { "IS_VALID_EVENT", OpenCL_std, 70 },
    { "NDRANGE_1D", OpenCL_std, 71 },
    { "NDRANGE_2D", OpenCL_std, 72 },
    { "NDRANGE_3D", OpenCL_std, 73 },
    { "RELEASE_EVENT", OpenCL_std, 74 },
    { "RETAIN_EVENT", OpenCL_std, 75 },
    { "SET_USER_EVENT_STATUS", OpenCL_std, 76 },
    { "SIGNBIT", OpenCL_std, 77 },
    { "TO_GLOBAL", OpenCL_std, 78 },
    { "TO_LOCAL", OpenCL_std, 79 },
    { "TO_PRIVATE", OpenCL_std, 80 },
    { "WAIT_GROUP_EVENTS", OpenCL_std, 81 },
    { "WORK_GROUP_BARRIER", OpenCL_std, 82 },
    { "__ENQUEUE_KERNEL_BASIC", OpenCL_std, 83 },
    { "__ENQUEUE_KERNEL_BASIC_EVENTS", OpenCL_std, 84 },
    { "__ENQUEUE_KERNEL_EVENTS_VARARGS", OpenCL_std, 85 },
    { "__ENQUEUE_KERNEL_VARARGS", OpenCL_std, 86 },
    { "__SPIRV_ALL", OpenCL_std, 87 },
    { "__SPIRV_ANY", OpenCL_std, 88 },
    { "__SPIRV_ATOMICAND", OpenCL_std, 89 },
    { "__SPIRV_ATOMICCOMPAREEXCHANGE", OpenCL_std, 90 },
    { "__SPIRV_ATOMICCOMPAREEXCHANGEWEAK", OpenCL_std, 91 },
    { "__SPIRV_ATOMICEXCHANGE", OpenCL_std, 92 },
    { "__SPIRV_ATOMICFLAGCLEAR", OpenCL_std, 93 },
    { "__SPIRV_ATOMICFLAGTESTANDSET", OpenCL_std, 94 },
    { "__SPIRV_ATOMICIADD", OpenCL_std, 95 },
    { "__SPIRV_ATOMICISUB", OpenCL_std, 96 },
    { "__SPIRV_ATOMICLOAD", OpenCL_std, 97 },
    { "__SPIRV_ATOMICOR", OpenCL_std, 98 },
    { "__SPIRV_ATOMICSMAX", OpenCL_std, 99 },
    { "__SPIRV_ATOMICSMIN", OpenCL_std, 100 },
    { "__SPIRV_ATOMICSTORE", OpenCL_std, 101 },
    { "__SPIRV_ATOMICUMAX", OpenCL_std, 102 },
    { "__SPIRV_ATOMICUMIN", OpenCL_std, 103 },
    { "__SPIRV_ATOMICXOR", OpenCL_std, 104 },
    { "__SPIRV_CAPTUREEVENTPROFILINGINFO", OpenCL_std, 105 },
    { "__SPIRV_CONTROLBARRIER", OpenCL_std, 106 },
    { "__SPIRV_CONTROLBARRIERARRIVEINTEL", OpenCL_std, 107 },
    { "__SPIRV_CONTROLBARRIERWAITINTEL", OpenCL_std, 108 },
    { "__SPIRV_CONVERTFTOS", OpenCL_std, 109 },
    { "__SPIRV_CONVERTFTOU", OpenCL_std, 110 },
    { "__SPIRV_CONVERTPTRTOU", OpenCL_std, 111 },
    { "__SPIRV_CONVERTSTOF", OpenCL_std, 112 },
    { "__SPIRV_CONVERTUTOF", OpenCL_std, 113 },
    { "__SPIRV_CONVERTUTOPTR", OpenCL_std, 114 },
    { "__SPIRV_COOPERATIVEMATRIXCONSTRUCTCHECKEDINTEL", OpenCL_std, 115 },
    { "__SPIRV_COOPERATIVEMATRIXGETELEMENTCOORDINTEL", OpenCL_std, 116 },
    { "__SPIRV_COOPERATIVEMATRIXLENGTHKHR", OpenCL_std, 117 },
    { "__SPIRV_COOPERATIVEMATRIXLOADCHECKEDINTEL", OpenCL_std, 118 },
    { "__SPIRV_COOPERATIVEMATRIXLOADKHR", OpenCL_std, 119 },
    { "__SPIRV_COOPERATIVEMATRIXMULADDKHR", OpenCL_std, 120 },
    { "__SPIRV_COOPERATIVEMATRIXPREFETCHINTEL", OpenCL_std, 121 },
    { "__SPIRV_COOPERATIVEMATRIXSTORECHECKEDINTEL", OpenCL_std, 122 },
    { "__SPIRV_COOPERATIVEMATRIXSTOREKHR", OpenCL_std, 123 },
    { "__SPIRV_CREATEUSEREVENT", OpenCL_std, 124 },
    { "__SPIRV_ENQUEUEKERNEL", OpenCL_std, 125 },
    { "__SPIRV_FCONVERT", OpenCL_std, 126 },
    { "__SPIRV_FORDEQUAL", OpenCL_std, 127 },
    { "__SPIRV_FORDGREATERTHAN", OpenCL_std, 128 },
    { "__SPIRV_FORDGREATERTHANEQUAL", OpenCL_std, 129 },
    { "__SPIRV_FORDLESSTHAN", OpenCL_std, 130 },
    { "__SPIRV_FORDLESSTHANEQUAL", OpenCL_std, 131 },
    { "__SPIRV_FORDNOTEQUAL", OpenCL_std, 132 },
    { "__SPIRV_FUNORDNOTEQUAL", OpenCL_std, 133 },
    { "__SPIRV_GENERICCASTTOPTREXPLICIT_TOGLOBAL", OpenCL_std, 134 },
    { "__SPIRV_GENERICCASTTOPTREXPLICIT_TOLOCAL", OpenCL_std, 135 },
    { "__SPIRV_GENERICCASTTOPTREXPLICIT_TOPRIVATE", OpenCL_std, 136 },
    { "__SPIRV_GENERICCASTTOPTR_TOGLOBAL", OpenCL_std, 137 },
    { "__SPIRV_GENERICCASTTOPTR_TOLOCAL", OpenCL_std, 138 },
    { "__SPIRV_GENERICCASTTOPTR_TOPRIVATE", OpenCL_std, 139 },
    { "__SPIRV_GETDEFAULTQUEUE", OpenCL_std, 140 },
    { "__SPIRV_GROUPASYNCCOPY", OpenCL_std, 141 },
    { "__SPIRV_GROUPWAITEVENTS", OpenCL_std, 142 },
    { "__SPIRV_IADDCARRY", OpenCL_std, 143 },
    { "__SPIRV_ISFINITE", OpenCL_std, 144 },
    { "__SPIRV_ISINF", OpenCL_std, 145 },
    { "__SPIRV_ISNAN", OpenCL_std, 146 },
    { "__SPIRV_ISNORMAL", OpenCL_std, 147 },
    { "__SPIRV_ISUBBORROW", OpenCL_std, 148 },
    { "__SPIRV_ISVALIDEVENT", OpenCL_std, 149 },
    { "__SPIRV_LOAD", OpenCL_std, 150 },
    { "__SPIRV_MEMORYBARRIER", OpenCL_std, 151 },
    { "__SPIRV_ORDERED", OpenCL_std, 152 },
    { "__SPIRV_QUANTIZETOF16", OpenCL_std, 153 },
    { "__SPIRV_RELEASEEVENT", OpenCL_std, 154 },
    { "__SPIRV_RETAINEVENT", OpenCL_std, 155 },
    { "__SPIRV_SATCONVERTSTOU", OpenCL_std, 156 },
    { "__SPIRV_SATCONVERTUTOS", OpenCL_std, 157 },
    { "__SPIRV_SCONVERT", OpenCL_std, 158 },
    { "__SPIRV_SETUSEREVENTSTATUS", OpenCL_std, 159 },
    { "__SPIRV_SIGNBITSET", OpenCL_std, 160 },
    { "__SPIRV_SPECCONSTANT", OpenCL_std, 161 },
    { "__SPIRV_SPECCONSTANTCOMPOSITE", OpenCL_std, 162 },
    { "__SPIRV_STORE", OpenCL_std, 163 },
    { "__SPIRV_UCONVERT", OpenCL_std, 164 },
    { "__SPIRV_UNORDERED", OpenCL_std, 165 },
  };

  struct KeyType {
    std::string Name;
    unsigned Set;
  };
  KeyType Key = {Name.upper(), Set};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name ||
      Key.Set != Idx->Set)
    return nullptr;

  return &NativeBuiltins[Idx->_index];
}
#endif

#ifdef GET_OpenCLTypes_DECL
const OpenCLType *lookupOpenCLType(StringRef Name);
#endif

#ifdef GET_OpenCLTypes_IMPL
constexpr OpenCLType OpenCLTypes[] = {
  { "opencl.clk_event_t", "spirv.DeviceEvent" }, // 0
  { "opencl.event_t", "spirv.Event" }, // 1
  { "opencl.image1d_array_ro_t", "spirv.Image._void_0_0_1_0_0_0_0" }, // 2
  { "opencl.image1d_array_rw_t", "spirv.Image._void_0_0_1_0_0_0_2" }, // 3
  { "opencl.image1d_array_t", "spirv.Image._void_0_0_1_0_0_0_0" }, // 4
  { "opencl.image1d_array_wo_t", "spirv.Image._void_0_0_1_0_0_0_1" }, // 5
  { "opencl.image1d_buffer_ro_t", "spirv.Image._void_5_0_0_0_0_0_0" }, // 6
  { "opencl.image1d_buffer_rw_t", "spirv.Image._void_5_0_0_0_0_0_2" }, // 7
  { "opencl.image1d_buffer_t", "spirv.Image._void_5_0_0_0_0_0_0" }, // 8
  { "opencl.image1d_buffer_wo_t", "spirv.Image._void_5_0_0_0_0_0_1" }, // 9
  { "opencl.image1d_ro_t", "spirv.Image._void_0_0_0_0_0_0_0" }, // 10
  { "opencl.image1d_rw_t", "spirv.Image._void_0_0_0_0_0_0_2" }, // 11
  { "opencl.image1d_t", "spirv.Image._void_0_0_0_0_0_0_0" }, // 12
  { "opencl.image1d_wo_t", "spirv.Image._void_0_0_0_0_0_0_1" }, // 13
  { "opencl.image2d_array_depth_ro_t", "spirv.Image._void_1_1_1_0_0_0_0" }, // 14
  { "opencl.image2d_array_depth_rw_t", "spirv.Image._void_1_1_1_0_0_0_2" }, // 15
  { "opencl.image2d_array_depth_t", "spirv.Image._void_1_1_1_0_0_0_0" }, // 16
  { "opencl.image2d_array_depth_wo_t", "spirv.Image._void_1_1_1_0_0_0_1" }, // 17
  { "opencl.image2d_array_msaa_depth_ro_t", "spirv.Image._void_1_1_1_1_0_0_0" }, // 18
  { "opencl.image2d_array_msaa_depth_rw_t", "spirv.Image._void_1_1_1_1_0_0_2" }, // 19
  { "opencl.image2d_array_msaa_depth_t", "spirv.Image._void_1_1_1_1_0_0_0" }, // 20
  { "opencl.image2d_array_msaa_depth_wo_t", "spirv.Image._void_1_1_1_1_0_0_1" }, // 21
  { "opencl.image2d_array_msaa_ro_t", "spirv.Image._void_1_0_1_1_0_0_0" }, // 22
  { "opencl.image2d_array_msaa_rw_t", "spirv.Image._void_1_0_1_1_0_0_2" }, // 23
  { "opencl.image2d_array_msaa_t", "spirv.Image._void_1_0_1_1_0_0_0" }, // 24
  { "opencl.image2d_array_msaa_wo_t", "spirv.Image._void_1_0_1_1_0_0_1" }, // 25
  { "opencl.image2d_array_ro_t", "spirv.Image._void_1_0_1_0_0_0_0" }, // 26
  { "opencl.image2d_array_rw_t", "spirv.Image._void_1_0_1_0_0_0_2" }, // 27
  { "opencl.image2d_array_t", "spirv.Image._void_1_0_1_0_0_0_0" }, // 28
  { "opencl.image2d_array_wo_t", "spirv.Image._void_1_0_1_0_0_0_1" }, // 29
  { "opencl.image2d_depth_ro_t", "spirv.Image._void_1_1_0_0_0_0_0" }, // 30
  { "opencl.image2d_depth_rw_t", "spirv.Image._void_1_1_0_0_0_0_2" }, // 31
  { "opencl.image2d_depth_t", "spirv.Image._void_1_1_0_0_0_0_0" }, // 32
  { "opencl.image2d_depth_wo_t", "spirv.Image._void_1_1_0_0_0_0_1" }, // 33
  { "opencl.image2d_msaa_depth_ro_t", "spirv.Image._void_1_1_0_1_0_0_0" }, // 34
  { "opencl.image2d_msaa_depth_rw_t", "spirv.Image._void_1_1_0_1_0_0_2" }, // 35
  { "opencl.image2d_msaa_depth_t", "spirv.Image._void_1_1_0_1_0_0_0" }, // 36
  { "opencl.image2d_msaa_depth_wo_t", "spirv.Image._void_1_1_0_1_0_0_1" }, // 37
  { "opencl.image2d_msaa_ro_t", "spirv.Image._void_1_0_0_1_0_0_0" }, // 38
  { "opencl.image2d_msaa_rw_t", "spirv.Image._void_1_0_0_1_0_0_2" }, // 39
  { "opencl.image2d_msaa_t", "spirv.Image._void_1_0_0_1_0_0_0" }, // 40
  { "opencl.image2d_msaa_wo_t", "spirv.Image._void_1_0_0_1_0_0_1" }, // 41
  { "opencl.image2d_ro_t", "spirv.Image._void_1_0_0_0_0_0_0" }, // 42
  { "opencl.image2d_rw_t", "spirv.Image._void_1_0_0_0_0_0_2" }, // 43
  { "opencl.image2d_t", "spirv.Image._void_1_0_0_0_0_0_0" }, // 44
  { "opencl.image2d_wo_t", "spirv.Image._void_1_0_0_0_0_0_1" }, // 45
  { "opencl.image3d_ro_t", "spirv.Image._void_2_0_0_0_0_0_0" }, // 46
  { "opencl.image3d_rw_t", "spirv.Image._void_2_0_0_0_0_0_2" }, // 47
  { "opencl.image3d_t", "spirv.Image._void_2_0_0_0_0_0_0" }, // 48
  { "opencl.image3d_wo_t", "spirv.Image._void_2_0_0_0_0_0_1" }, // 49
  { "opencl.pipe_ro_t", "spirv.Pipe._0" }, // 50
  { "opencl.pipe_rw_t", "spirv.Pipe._2" }, // 51
  { "opencl.pipe_t", "spirv.Pipe._0" }, // 52
  { "opencl.pipe_wo_t", "spirv.Pipe._1" }, // 53
  { "opencl.queue_t", "spirv.Queue" }, // 54
  { "opencl.reserve_id_t", "spirv.ReserveId" }, // 55
  { "opencl.sampler_t", "spirv.Sampler" }, // 56
 };

const OpenCLType *lookupOpenCLType(StringRef Name) {
  struct IndexType {
    const char * Name;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "OPENCL.CLK_EVENT_T", 0 },
    { "OPENCL.EVENT_T", 1 },
    { "OPENCL.IMAGE1D_ARRAY_RO_T", 2 },
    { "OPENCL.IMAGE1D_ARRAY_RW_T", 3 },
    { "OPENCL.IMAGE1D_ARRAY_T", 4 },
    { "OPENCL.IMAGE1D_ARRAY_WO_T", 5 },
    { "OPENCL.IMAGE1D_BUFFER_RO_T", 6 },
    { "OPENCL.IMAGE1D_BUFFER_RW_T", 7 },
    { "OPENCL.IMAGE1D_BUFFER_T", 8 },
    { "OPENCL.IMAGE1D_BUFFER_WO_T", 9 },
    { "OPENCL.IMAGE1D_RO_T", 10 },
    { "OPENCL.IMAGE1D_RW_T", 11 },
    { "OPENCL.IMAGE1D_T", 12 },
    { "OPENCL.IMAGE1D_WO_T", 13 },
    { "OPENCL.IMAGE2D_ARRAY_DEPTH_RO_T", 14 },
    { "OPENCL.IMAGE2D_ARRAY_DEPTH_RW_T", 15 },
    { "OPENCL.IMAGE2D_ARRAY_DEPTH_T", 16 },
    { "OPENCL.IMAGE2D_ARRAY_DEPTH_WO_T", 17 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_DEPTH_RO_T", 18 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_DEPTH_RW_T", 19 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_DEPTH_T", 20 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_DEPTH_WO_T", 21 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_RO_T", 22 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_RW_T", 23 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_T", 24 },
    { "OPENCL.IMAGE2D_ARRAY_MSAA_WO_T", 25 },
    { "OPENCL.IMAGE2D_ARRAY_RO_T", 26 },
    { "OPENCL.IMAGE2D_ARRAY_RW_T", 27 },
    { "OPENCL.IMAGE2D_ARRAY_T", 28 },
    { "OPENCL.IMAGE2D_ARRAY_WO_T", 29 },
    { "OPENCL.IMAGE2D_DEPTH_RO_T", 30 },
    { "OPENCL.IMAGE2D_DEPTH_RW_T", 31 },
    { "OPENCL.IMAGE2D_DEPTH_T", 32 },
    { "OPENCL.IMAGE2D_DEPTH_WO_T", 33 },
    { "OPENCL.IMAGE2D_MSAA_DEPTH_RO_T", 34 },
    { "OPENCL.IMAGE2D_MSAA_DEPTH_RW_T", 35 },
    { "OPENCL.IMAGE2D_MSAA_DEPTH_T", 36 },
    { "OPENCL.IMAGE2D_MSAA_DEPTH_WO_T", 37 },
    { "OPENCL.IMAGE2D_MSAA_RO_T", 38 },
    { "OPENCL.IMAGE2D_MSAA_RW_T", 39 },
    { "OPENCL.IMAGE2D_MSAA_T", 40 },
    { "OPENCL.IMAGE2D_MSAA_WO_T", 41 },
    { "OPENCL.IMAGE2D_RO_T", 42 },
    { "OPENCL.IMAGE2D_RW_T", 43 },
    { "OPENCL.IMAGE2D_T", 44 },
    { "OPENCL.IMAGE2D_WO_T", 45 },
    { "OPENCL.IMAGE3D_RO_T", 46 },
    { "OPENCL.IMAGE3D_RW_T", 47 },
    { "OPENCL.IMAGE3D_T", 48 },
    { "OPENCL.IMAGE3D_WO_T", 49 },
    { "OPENCL.PIPE_RO_T", 50 },
    { "OPENCL.PIPE_RW_T", 51 },
    { "OPENCL.PIPE_T", 52 },
    { "OPENCL.PIPE_WO_T", 53 },
    { "OPENCL.QUEUE_T", 54 },
    { "OPENCL.RESERVE_ID_T", 55 },
    { "OPENCL.SAMPLER_T", 56 },
  };

  struct KeyType {
    std::string Name;
  };
  KeyType Key = {Name.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name)
    return nullptr;

  return &OpenCLTypes[Idx->_index];
}
#endif

#ifdef GET_SymbolicOperands_DECL
const SymbolicOperand *lookupSymbolicOperandByCategoryAndValue(unsigned Category, uint32_t Value);
const SymbolicOperand *lookupSymbolicOperandByCategory(unsigned Category);
const SymbolicOperand *lookupSymbolicOperandByCategoryAndMnemonic(unsigned Category, StringRef Mnemonic);
#endif

#ifdef GET_SymbolicOperands_IMPL
constexpr SymbolicOperand SymbolicOperands[] = {
  { AccessQualifierOperand, 0x0, "ReadOnly", 0x0, 0x0 }, // 0
  { AccessQualifierOperand, 0x1, "WriteOnly", 0x0, 0x0 }, // 1
  { AccessQualifierOperand, 0x2, "ReadWrite", 0x0, 0x0 }, // 2
  { AccessQualifierOperand, 0x3, "None", 0x0, 0x0 }, // 3
  { AddressingModelOperand, 0x0, "Logical", 0x0, 0x0 }, // 4
  { AddressingModelOperand, 0x1, "Physical32", 0x0, 0x0 }, // 5
  { AddressingModelOperand, 0x2, "Physical64", 0x0, 0x0 }, // 6
  { AddressingModelOperand, 0x14E4, "PhysicalStorageBuffer64EXT", 0x0, 0x0 }, // 7
  { BuiltInOperand, 0x0, "Position", 0x0, 0x0 }, // 8
  { BuiltInOperand, 0x1, "PointSize", 0x0, 0x0 }, // 9
  { BuiltInOperand, 0x3, "ClipDistanceVariable", 0x0, 0x0 }, // 10
  { BuiltInOperand, 0x4, "CullDistanceVariable", 0x0, 0x0 }, // 11
  { BuiltInOperand, 0x5, "VertexId", 0x0, 0x0 }, // 12
  { BuiltInOperand, 0x6, "InstanceId", 0x0, 0x0 }, // 13
  { BuiltInOperand, 0x7, "PrimitiveId", 0x0, 0x0 }, // 14
  { BuiltInOperand, 0x8, "InvocationId", 0x0, 0x0 }, // 15
  { BuiltInOperand, 0x9, "Layer", 0x0, 0x0 }, // 16
  { BuiltInOperand, 0xA, "ViewportIndex", 0x0, 0x0 }, // 17
  { BuiltInOperand, 0xB, "TessLevelOuter", 0x0, 0x0 }, // 18
  { BuiltInOperand, 0xC, "TessLevelInner", 0x0, 0x0 }, // 19
  { BuiltInOperand, 0xD, "TessCoord", 0x0, 0x0 }, // 20
  { BuiltInOperand, 0xE, "PatchVertices", 0x0, 0x0 }, // 21
  { BuiltInOperand, 0xF, "FragCoord", 0x0, 0x0 }, // 22
  { BuiltInOperand, 0x10, "PointCoord", 0x0, 0x0 }, // 23
  { BuiltInOperand, 0x11, "FrontFacing", 0x0, 0x0 }, // 24
  { BuiltInOperand, 0x12, "SampleId", 0x0, 0x0 }, // 25
  { BuiltInOperand, 0x13, "SamplePosition", 0x0, 0x0 }, // 26
  { BuiltInOperand, 0x14, "SampleMask", 0x0, 0x0 }, // 27
  { BuiltInOperand, 0x16, "FragDepth", 0x0, 0x0 }, // 28
  { BuiltInOperand, 0x17, "HelperInvocation", 0x0, 0x0 }, // 29
  { BuiltInOperand, 0x18, "NumWorkgroups", 0x0, 0x0 }, // 30
  { BuiltInOperand, 0x19, "WorkgroupSize", 0x0, 0x0 }, // 31
  { BuiltInOperand, 0x1A, "WorkgroupId", 0x0, 0x0 }, // 32
  { BuiltInOperand, 0x1B, "LocalInvocationId", 0x0, 0x0 }, // 33
  { BuiltInOperand, 0x1C, "GlobalInvocationId", 0x0, 0x0 }, // 34
  { BuiltInOperand, 0x1D, "LocalInvocationIndex", 0x0, 0x0 }, // 35
  { BuiltInOperand, 0x1E, "WorkDim", 0x0, 0x0 }, // 36
  { BuiltInOperand, 0x1F, "GlobalSize", 0x0, 0x0 }, // 37
  { BuiltInOperand, 0x20, "EnqueuedWorkgroupSize", 0x0, 0x0 }, // 38
  { BuiltInOperand, 0x21, "GlobalOffset", 0x0, 0x0 }, // 39
  { BuiltInOperand, 0x22, "GlobalLinearId", 0x0, 0x0 }, // 40
  { BuiltInOperand, 0x24, "SubgroupSize", 0x0, 0x0 }, // 41
  { BuiltInOperand, 0x25, "SubgroupMaxSize", 0x0, 0x0 }, // 42
  { BuiltInOperand, 0x26, "NumSubgroups", 0x0, 0x0 }, // 43
  { BuiltInOperand, 0x27, "NumEnqueuedSubgroups", 0x0, 0x0 }, // 44
  { BuiltInOperand, 0x28, "SubgroupId", 0x0, 0x0 }, // 45
  { BuiltInOperand, 0x29, "SubgroupLocalInvocationId", 0x0, 0x0 }, // 46
  { BuiltInOperand, 0x2A, "VertexIndex", 0x0, 0x0 }, // 47
  { BuiltInOperand, 0x2B, "InstanceIndex", 0x0, 0x0 }, // 48
  { BuiltInOperand, 0x1140, "SubgroupEqMask", 0x0, 0x0 }, // 49
  { BuiltInOperand, 0x1141, "SubgroupGeMask", 0x0, 0x0 }, // 50
  { BuiltInOperand, 0x1142, "SubgroupGtMask", 0x0, 0x0 }, // 51
  { BuiltInOperand, 0x1143, "SubgroupLeMask", 0x0, 0x0 }, // 52
  { BuiltInOperand, 0x1144, "SubgroupLtMask", 0x0, 0x0 }, // 53
  { BuiltInOperand, 0x1148, "BaseVertex", 0x0, 0x0 }, // 54
  { BuiltInOperand, 0x1149, "BaseInstance", 0x0, 0x0 }, // 55
  { BuiltInOperand, 0x114A, "DrawIndex", 0x0, 0x0 }, // 56
  { BuiltInOperand, 0x1156, "DeviceIndex", 0x0, 0x0 }, // 57
  { BuiltInOperand, 0x1158, "ViewIndex", 0x0, 0x0 }, // 58
  { BuiltInOperand, 0x118C, "BaryCoordNoPerspAMD", 0x0, 0x0 }, // 59
  { BuiltInOperand, 0x118D, "BaryCoordNoPerspCentroidAMD", 0x0, 0x0 }, // 60
  { BuiltInOperand, 0x118E, "BaryCoordNoPerspSampleAMD", 0x0, 0x0 }, // 61
  { BuiltInOperand, 0x118F, "BaryCoordSmoothAMD", 0x0, 0x0 }, // 62
  { BuiltInOperand, 0x1190, "BaryCoordSmoothCentroid", 0x0, 0x0 }, // 63
  { BuiltInOperand, 0x1191, "BaryCoordSmoothSample", 0x0, 0x0 }, // 64
  { BuiltInOperand, 0x1192, "BaryCoordPullModel", 0x0, 0x0 }, // 65
  { BuiltInOperand, 0x1396, "FragStencilRefEXT", 0x0, 0x0 }, // 66
  { BuiltInOperand, 0x1485, "ViewportMaskNV", 0x0, 0x0 }, // 67
  { BuiltInOperand, 0x1489, "SecondaryPositionNV", 0x0, 0x0 }, // 68
  { BuiltInOperand, 0x148A, "SecondaryViewportMaskNV", 0x0, 0x0 }, // 69
  { BuiltInOperand, 0x148D, "PositionPerViewNV", 0x0, 0x0 }, // 70
  { BuiltInOperand, 0x148E, "ViewportMaskPerViewNV", 0x0, 0x0 }, // 71
  { BuiltInOperand, 0x1490, "FullyCoveredEXT", 0x0, 0x0 }, // 72
  { BuiltInOperand, 0x149A, "TaskCountNV", 0x0, 0x0 }, // 73
  { BuiltInOperand, 0x149B, "PrimitiveCountNV", 0x0, 0x0 }, // 74
  { BuiltInOperand, 0x149C, "PrimitiveIndicesNV", 0x0, 0x0 }, // 75
  { BuiltInOperand, 0x149D, "ClipDistancePerViewNV", 0x0, 0x0 }, // 76
  { BuiltInOperand, 0x149E, "CullDistancePerViewNV", 0x0, 0x0 }, // 77
  { BuiltInOperand, 0x149F, "LayerPerViewNV", 0x0, 0x0 }, // 78
  { BuiltInOperand, 0x14A0, "MeshViewCountNV", 0x0, 0x0 }, // 79
  { BuiltInOperand, 0x14A1, "MeshViewIndices", 0x0, 0x0 }, // 80
  { BuiltInOperand, 0x14A6, "BaryCoordNV", 0x0, 0x0 }, // 81
  { BuiltInOperand, 0x14A7, "BaryCoordNoPerspNV", 0x0, 0x0 }, // 82
  { BuiltInOperand, 0x14AC, "FragSizeEXT", 0x0, 0x0 }, // 83
  { BuiltInOperand, 0x14AD, "FragInvocationCountEXT", 0x0, 0x0 }, // 84
  { BuiltInOperand, 0x14C7, "LaunchIdNV", 0x0, 0x0 }, // 85
  { BuiltInOperand, 0x14C8, "LaunchSizeNV", 0x0, 0x0 }, // 86
  { BuiltInOperand, 0x14C9, "WorldRayOriginNV", 0x0, 0x0 }, // 87
  { BuiltInOperand, 0x14CA, "WorldRayDirectionNV", 0x0, 0x0 }, // 88
  { BuiltInOperand, 0x14CB, "ObjectRayOriginNV", 0x0, 0x0 }, // 89
  { BuiltInOperand, 0x14CC, "ObjectRayDirectionNV", 0x0, 0x0 }, // 90
  { BuiltInOperand, 0x14CD, "RayTminNV", 0x0, 0x0 }, // 91
  { BuiltInOperand, 0x14CE, "RayTmaxNV", 0x0, 0x0 }, // 92
  { BuiltInOperand, 0x14CF, "InstanceCustomIndexNV", 0x0, 0x0 }, // 93
  { BuiltInOperand, 0x14D2, "ObjectToWorldNV", 0x0, 0x0 }, // 94
  { BuiltInOperand, 0x14D3, "WorldToObjectNV", 0x0, 0x0 }, // 95
  { BuiltInOperand, 0x14D4, "HitTNV", 0x0, 0x0 }, // 96
  { BuiltInOperand, 0x14D5, "HitKindNV", 0x0, 0x0 }, // 97
  { BuiltInOperand, 0x14E7, "IncomingRayFlagsNV", 0x0, 0x0 }, // 98
  { CapabilityOperand, 0x0, "Matrix", 0x0, 0x0 }, // 99
  { CapabilityOperand, 0x1, "Shader", 0x0, 0x0 }, // 100
  { CapabilityOperand, 0x2, "Geometry", 0x0, 0x0 }, // 101
  { CapabilityOperand, 0x3, "Tessellation", 0x0, 0x0 }, // 102
  { CapabilityOperand, 0x4, "Addresses", 0x0, 0x0 }, // 103
  { CapabilityOperand, 0x5, "Linkage", 0x0, 0x0 }, // 104
  { CapabilityOperand, 0x6, "Kernel", 0x0, 0x0 }, // 105
  { CapabilityOperand, 0x7, "Vector16", 0x0, 0x0 }, // 106
  { CapabilityOperand, 0x8, "Float16Buffer", 0x0, 0x0 }, // 107
  { CapabilityOperand, 0x9, "Float16", 0x0, 0x0 }, // 108
  { CapabilityOperand, 0xA, "Float64", 0x0, 0x0 }, // 109
  { CapabilityOperand, 0xB, "Int64", 0x0, 0x0 }, // 110
  { CapabilityOperand, 0xC, "Int64Atomics", 0x0, 0x0 }, // 111
  { CapabilityOperand, 0xD, "ImageBasic", 0x0, 0x0 }, // 112
  { CapabilityOperand, 0xE, "ImageReadWrite", 0x0, 0x0 }, // 113
  { CapabilityOperand, 0xF, "ImageMipmap", 0x0, 0x0 }, // 114
  { CapabilityOperand, 0x11, "Pipes", 0x0, 0x0 }, // 115
  { CapabilityOperand, 0x12, "Groups", 0x0, 0x0 }, // 116
  { CapabilityOperand, 0x13, "DeviceEnqueue", 0x0, 0x0 }, // 117
  { CapabilityOperand, 0x14, "LiteralSampler", 0x0, 0x0 }, // 118
  { CapabilityOperand, 0x15, "AtomicStorage", 0x0, 0x0 }, // 119
  { CapabilityOperand, 0x16, "Int16", 0x0, 0x0 }, // 120
  { CapabilityOperand, 0x17, "TessellationPointSize", 0x0, 0x0 }, // 121
  { CapabilityOperand, 0x18, "GeometryPointSize", 0x0, 0x0 }, // 122
  { CapabilityOperand, 0x19, "ImageGatherExtended", 0x0, 0x0 }, // 123
  { CapabilityOperand, 0x1B, "StorageImageMultisample", 0x0, 0x0 }, // 124
  { CapabilityOperand, 0x1C, "UniformBufferArrayDynamicIndexing", 0x0, 0x0 }, // 125
  { CapabilityOperand, 0x1D, "SampledImageArrayDynamicIndexing", 0x0, 0x0 }, // 126
  { CapabilityOperand, 0x1E, "StorageBufferArrayDynamicIndexing", 0x0, 0x0 }, // 127
  { CapabilityOperand, 0x1F, "StorageImageArrayDynamicIndexing", 0x0, 0x0 }, // 128
  { CapabilityOperand, 0x20, "ClipDistance", 0x0, 0x0 }, // 129
  { CapabilityOperand, 0x21, "CullDistance", 0x0, 0x0 }, // 130
  { CapabilityOperand, 0x22, "ImageCubeArray", 0x0, 0x0 }, // 131
  { CapabilityOperand, 0x23, "SampleRateShading", 0x0, 0x0 }, // 132
  { CapabilityOperand, 0x24, "ImageRect", 0x0, 0x0 }, // 133
  { CapabilityOperand, 0x25, "SampledRect", 0x0, 0x0 }, // 134
  { CapabilityOperand, 0x26, "GenericPointer", 0x0, 0x0 }, // 135
  { CapabilityOperand, 0x27, "Int8", 0x0, 0x0 }, // 136
  { CapabilityOperand, 0x28, "InputAttachment", 0x0, 0x0 }, // 137
  { CapabilityOperand, 0x29, "SparseResidency", 0x0, 0x0 }, // 138
  { CapabilityOperand, 0x2A, "MinLod", 0x0, 0x0 }, // 139
  { CapabilityOperand, 0x2B, "Sampled1D", 0x0, 0x0 }, // 140
  { CapabilityOperand, 0x2C, "Image1D", 0x0, 0x0 }, // 141
  { CapabilityOperand, 0x2D, "SampledCubeArray", 0x0, 0x0 }, // 142
  { CapabilityOperand, 0x2E, "SampledBuffer", 0x0, 0x0 }, // 143
  { CapabilityOperand, 0x2F, "ImageBuffer", 0x0, 0x0 }, // 144
  { CapabilityOperand, 0x30, "ImageMSArray", 0x0, 0x0 }, // 145
  { CapabilityOperand, 0x31, "StorageImageExtendedFormats", 0x0, 0x0 }, // 146
  { CapabilityOperand, 0x32, "ImageQuery", 0x0, 0x0 }, // 147
  { CapabilityOperand, 0x33, "DerivativeControl", 0x0, 0x0 }, // 148
  { CapabilityOperand, 0x34, "InterpolationFunction", 0x0, 0x0 }, // 149
  { CapabilityOperand, 0x35, "TransformFeedback", 0x0, 0x0 }, // 150
  { CapabilityOperand, 0x36, "GeometryStreams", 0x0, 0x0 }, // 151
  { CapabilityOperand, 0x37, "StorageImageReadWithoutFormat", 0x0, 0x0 }, // 152
  { CapabilityOperand, 0x38, "StorageImageWriteWithoutFormat", 0x0, 0x0 }, // 153
  { CapabilityOperand, 0x39, "MultiViewport", 0x0, 0x0 }, // 154
  { CapabilityOperand, 0x3A, "SubgroupDispatch", 0x10100, 0x0 }, // 155
  { CapabilityOperand, 0x3B, "NamedBarrier", 0x10100, 0x0 }, // 156
  { CapabilityOperand, 0x3C, "PipeStorage", 0x10100, 0x0 }, // 157
  { CapabilityOperand, 0x3D, "GroupNonUniform", 0x10300, 0x0 }, // 158
  { CapabilityOperand, 0x3E, "GroupNonUniformVote", 0x10300, 0x0 }, // 159
  { CapabilityOperand, 0x3F, "GroupNonUniformArithmetic", 0x10300, 0x0 }, // 160
  { CapabilityOperand, 0x40, "GroupNonUniformBallot", 0x10300, 0x0 }, // 161
  { CapabilityOperand, 0x41, "GroupNonUniformShuffle", 0x10300, 0x0 }, // 162
  { CapabilityOperand, 0x42, "GroupNonUniformShuffleRelative", 0x10300, 0x0 }, // 163
  { CapabilityOperand, 0x43, "GroupNonUniformClustered", 0x10300, 0x0 }, // 164
  { CapabilityOperand, 0x44, "GroupNonUniformQuad", 0x10300, 0x0 }, // 165
  { CapabilityOperand, 0x1147, "SubgroupBallotKHR", 0x0, 0x0 }, // 166
  { CapabilityOperand, 0x114B, "DrawParameters", 0x10300, 0x0 }, // 167
  { CapabilityOperand, 0x114F, "SubgroupVoteKHR", 0x0, 0x0 }, // 168
  { CapabilityOperand, 0x1151, "StorageBuffer16BitAccess", 0x10300, 0x0 }, // 169
  { CapabilityOperand, 0x1152, "StorageUniform16", 0x10300, 0x0 }, // 170
  { CapabilityOperand, 0x1153, "StoragePushConstant16", 0x10300, 0x0 }, // 171
  { CapabilityOperand, 0x1154, "StorageInputOutput16", 0x10300, 0x0 }, // 172
  { CapabilityOperand, 0x1155, "DeviceGroup", 0x10300, 0x0 }, // 173
  { CapabilityOperand, 0x1157, "MultiView", 0x10300, 0x0 }, // 174
  { CapabilityOperand, 0x1159, "VariablePointersStorageBuffer", 0x10300, 0x0 }, // 175
  { CapabilityOperand, 0x115A, "VariablePointers", 0x10300, 0x0 }, // 176
  { CapabilityOperand, 0x115D, "AtomicStorageOps", 0x0, 0x0 }, // 177
  { CapabilityOperand, 0x115F, "SampleMaskPostDepthCoverage", 0x0, 0x0 }, // 178
  { CapabilityOperand, 0x1160, "StorageBuffer8BitAccess", 0x0, 0x0 }, // 179
  { CapabilityOperand, 0x1161, "UniformAndStorageBuffer8BitAccess", 0x0, 0x0 }, // 180
  { CapabilityOperand, 0x1162, "StoragePushConstant8", 0x0, 0x0 }, // 181
  { CapabilityOperand, 0x1170, "DenormPreserve", 0x10400, 0x0 }, // 182
  { CapabilityOperand, 0x1171, "DenormFlushToZero", 0x10400, 0x0 }, // 183
  { CapabilityOperand, 0x1172, "SignedZeroInfNanPreserve", 0x10400, 0x0 }, // 184
  { CapabilityOperand, 0x1173, "RoundingModeRTE", 0x10400, 0x0 }, // 185
  { CapabilityOperand, 0x1174, "RoundingModeRTZ", 0x10400, 0x0 }, // 186
  { CapabilityOperand, 0x1390, "Float16ImageAMD", 0x0, 0x0 }, // 187
  { CapabilityOperand, 0x1391, "ImageGatherBiasLodAMD", 0x0, 0x0 }, // 188
  { CapabilityOperand, 0x1392, "FragmentMaskAMD", 0x0, 0x0 }, // 189
  { CapabilityOperand, 0x1395, "StencilExportEXT", 0x0, 0x0 }, // 190
  { CapabilityOperand, 0x1397, "ImageReadWriteLodAMD", 0x0, 0x0 }, // 191
  { CapabilityOperand, 0x13BF, "ShaderClockKHR", 0x0, 0x0 }, // 192
  { CapabilityOperand, 0x1481, "SampleMaskOverrideCoverageNV", 0x0, 0x0 }, // 193
  { CapabilityOperand, 0x1483, "GeometryShaderPassthroughNV", 0x0, 0x0 }, // 194
  { CapabilityOperand, 0x1486, "ShaderViewportIndexLayerEXT", 0x0, 0x0 }, // 195
  { CapabilityOperand, 0x1487, "ShaderViewportMaskNV", 0x0, 0x0 }, // 196
  { CapabilityOperand, 0x148B, "ShaderStereoViewNV", 0x0, 0x0 }, // 197
  { CapabilityOperand, 0x148C, "PerViewAttributesNV", 0x0, 0x0 }, // 198
  { CapabilityOperand, 0x1491, "FragmentFullyCoveredEXT", 0x0, 0x0 }, // 199
  { CapabilityOperand, 0x1492, "MeshShadingNV", 0x0, 0x0 }, // 200
  { CapabilityOperand, 0x14A2, "ImageFootprintNV", 0x0, 0x0 }, // 201
  { CapabilityOperand, 0x14A4, "FragmentBarycentricNV", 0x0, 0x0 }, // 202
  { CapabilityOperand, 0x14A8, "ComputeDerivativeGroupQuadsNV", 0x0, 0x0 }, // 203
  { CapabilityOperand, 0x14AB, "FragmentDensityEXT", 0x0, 0x0 }, // 204
  { CapabilityOperand, 0x14B1, "GroupNonUniformPartitionedNV", 0x0, 0x0 }, // 205
  { CapabilityOperand, 0x14B5, "ShaderNonUniformEXT", 0x0, 0x0 }, // 206
  { CapabilityOperand, 0x14B6, "RuntimeDescriptorArrayEXT", 0x0, 0x0 }, // 207
  { CapabilityOperand, 0x14B7, "InputAttachmentArrayDynamicIndexingEXT", 0x0, 0x0 }, // 208
  { CapabilityOperand, 0x14B8, "UniformTexelBufferArrayDynamicIndexingEXT", 0x0, 0x0 }, // 209
  { CapabilityOperand, 0x14B9, "StorageTexelBufferArrayDynamicIndexingEXT", 0x0, 0x0 }, // 210
  { CapabilityOperand, 0x14BA, "UniformBufferArrayNonUniformIndexingEXT", 0x0, 0x0 }, // 211
  { CapabilityOperand, 0x14BB, "SampledImageArrayNonUniformIndexingEXT", 0x0, 0x0 }, // 212
  { CapabilityOperand, 0x14BC, "StorageBufferArrayNonUniformIndexingEXT", 0x0, 0x0 }, // 213
  { CapabilityOperand, 0x14BD, "StorageImageArrayNonUniformIndexingEXT", 0x0, 0x0 }, // 214
  { CapabilityOperand, 0x14BE, "InputAttachmentArrayNonUniformIndexingEXT", 0x0, 0x0 }, // 215
  { CapabilityOperand, 0x14BF, "UniformTexelBufferArrayNonUniformIndexingEXT", 0x0, 0x0 }, // 216
  { CapabilityOperand, 0x14C0, "StorageTexelBufferArrayNonUniformIndexingEXT", 0x0, 0x0 }, // 217
  { CapabilityOperand, 0x14DC, "RayTracingNV", 0x0, 0x0 }, // 218
  { CapabilityOperand, 0x14E1, "VulkanMemoryModelKHR", 0x0, 0x0 }, // 219
  { CapabilityOperand, 0x14E2, "VulkanMemoryModelDeviceScopeKHR", 0x0, 0x0 }, // 220
  { CapabilityOperand, 0x14E3, "PhysicalStorageBufferAddressesEXT", 0x0, 0x0 }, // 221
  { CapabilityOperand, 0x14E6, "ComputeDerivativeGroupLinearNV", 0x0, 0x0 }, // 222
  { CapabilityOperand, 0x14ED, "CooperativeMatrixNV", 0x0, 0x0 }, // 223
  { CapabilityOperand, 0x1503, "DemoteToHelperInvocation", 0x10600, 0x0 }, // 224
  { CapabilityOperand, 0x15C0, "SubgroupShuffleINTEL", 0x0, 0x0 }, // 225
  { CapabilityOperand, 0x15C1, "SubgroupBufferBlockIOINTEL", 0x0, 0x0 }, // 226
  { CapabilityOperand, 0x15C2, "SubgroupImageBlockIOINTEL", 0x0, 0x0 }, // 227
  { CapabilityOperand, 0x15CB, "SubgroupImageMediaBlockIOINTEL", 0x0, 0x0 }, // 228
  { CapabilityOperand, 0x15CE, "RoundToInfinityINTEL", 0x0, 0x0 }, // 229
  { CapabilityOperand, 0x15CF, "FloatingPointModeINTEL", 0x0, 0x0 }, // 230
  { CapabilityOperand, 0x15E3, "FunctionPointersINTEL", 0x0, 0x0 }, // 231
  { CapabilityOperand, 0x15E4, "IndirectReferencesINTEL", 0x0, 0x0 }, // 232
  { CapabilityOperand, 0x15E6, "AsmINTEL", 0x0, 0x0 }, // 233
  { CapabilityOperand, 0x15EC, "AtomicFloat32MinMaxEXT", 0x0, 0x0 }, // 234
  { CapabilityOperand, 0x15ED, "AtomicFloat64MinMaxEXT", 0x0, 0x0 }, // 235
  { CapabilityOperand, 0x15F0, "AtomicFloat16MinMaxEXT", 0x0, 0x0 }, // 236
  { CapabilityOperand, 0x15FD, "ExpectAssumeKHR", 0x0, 0x0 }, // 237
  { CapabilityOperand, 0x1640, "SubgroupAvcMotionEstimationINTEL", 0x0, 0x0 }, // 238
  { CapabilityOperand, 0x1641, "SubgroupAvcMotionEstimationIntraINTEL", 0x0, 0x0 }, // 239
  { CapabilityOperand, 0x1642, "SubgroupAvcMotionEstimationChromaINTEL", 0x0, 0x0 }, // 240
  { CapabilityOperand, 0x16B9, "VariableLengthArrayINTEL", 0x0, 0x0 }, // 241
  { CapabilityOperand, 0x16BD, "FunctionFloatControlINTEL", 0x0, 0x0 }, // 242
  { CapabilityOperand, 0x16D4, "ArbitraryPrecisionIntegersINTEL", 0x0, 0x0 }, // 243
  { CapabilityOperand, 0x172F, "USMStorageClassesINTEL", 0x0, 0x0 }, // 244
  { CapabilityOperand, 0x1780, "DotProductInputAll", 0x10600, 0x0 }, // 245
  { CapabilityOperand, 0x1781, "DotProductInput4x8Bit", 0x10600, 0x0 }, // 246
  { CapabilityOperand, 0x1782, "DotProductInput4x8BitPacked", 0x10600, 0x0 }, // 247
  { CapabilityOperand, 0x1783, "DotProduct", 0x10600, 0x0 }, // 248
  { CapabilityOperand, 0x1786, "CooperativeMatrixKHR", 0x0, 0x0 }, // 249
  { CapabilityOperand, 0x1789, "BitInstructions", 0x0, 0x0 }, // 250
  { CapabilityOperand, 0x178A, "GroupNonUniformRotateKHR", 0x0, 0x0 }, // 251
  { CapabilityOperand, 0x1791, "AtomicFloat32AddEXT", 0x0, 0x0 }, // 252
  { CapabilityOperand, 0x1792, "AtomicFloat64AddEXT", 0x0, 0x0 }, // 253
  { CapabilityOperand, 0x17CE, "OptNoneEXT", 0x0, 0x0 }, // 254
  { CapabilityOperand, 0x17CE, "OptNoneINTEL", 0x0, 0x0 }, // 255
  { CapabilityOperand, 0x17CF, "AtomicFloat16AddEXT", 0x0, 0x0 }, // 256
  { CapabilityOperand, 0x17E3, "BFloat16ConversionINTEL", 0x0, 0x0 }, // 257
  { CapabilityOperand, 0x17FD, "SplitBarrierINTEL", 0x0, 0x0 }, // 258
  { CapabilityOperand, 0x1800, "ArithmeticFenceEXT", 0x0, 0x0 }, // 259
  { CapabilityOperand, 0x182B, "GlobalVariableHostAccessINTEL", 0x0, 0x0 }, // 260
  { CapabilityOperand, 0x182C, "HostAccessINTEL", 0x0, 0x0 }, // 261
  { CapabilityOperand, 0x182D, "GlobalVariableFPGADecorationsINTEL", 0x0, 0x0 }, // 262
  { CapabilityOperand, 0x1830, "CooperativeMatrixCheckedInstructionsINTEL", 0x0, 0x0 }, // 263
  { CapabilityOperand, 0x1900, "GroupUniformArithmeticKHR", 0x0, 0x0 }, // 264
  { CapabilityOperand, 0x190B, "CooperativeMatrixPrefetchINTEL", 0x0, 0x0 }, // 265
  { CapabilityOperand, 0x1922, "PackedCooperativeMatrixINTEL", 0x0, 0x0 }, // 266
  { CapabilityOperand, 0x1923, "CooperativeMatrixInvocationInstructionsINTEL", 0x0, 0x0 }, // 267
  { CapabilityOperand, 0x1924, "CooperativeMatrixTF32ComponentTypeINTEL", 0x0, 0x0 }, // 268
  { CapabilityOperand, 0x1925, "CooperativeMatrixBFloat16ComponentTypeINTEL", 0x0, 0x0 }, // 269
  { CapabilityOperand, 0x1929, "CacheControlsINTEL", 0x0, 0x0 }, // 270
  { CooperativeMatrixLayoutOperand, 0x0, "RowMajorKHR", 0x0, 0x0 }, // 271
  { CooperativeMatrixLayoutOperand, 0x1, "ColumnMajorKHR", 0x0, 0x0 }, // 272
  { CooperativeMatrixLayoutOperand, 0x2, "PackedINTEL", 0x0, 0x0 }, // 273
  { CooperativeMatrixOperandsOperand, 0x0, "NoneKHR", 0x0, 0x0 }, // 274
  { CooperativeMatrixOperandsOperand, 0x1, "MatrixASignedComponentsKHR", 0x0, 0x0 }, // 275
  { CooperativeMatrixOperandsOperand, 0x2, "MatrixBSignedComponentsKHR", 0x0, 0x0 }, // 276
  { CooperativeMatrixOperandsOperand, 0x4, "MatrixCSignedComponentsKHR", 0x0, 0x0 }, // 277
  { CooperativeMatrixOperandsOperand, 0x8, "MatrixResultSignedComponentsKHR", 0x0, 0x0 }, // 278
  { CooperativeMatrixOperandsOperand, 0x10, "SaturatingAccumulationKHR", 0x0, 0x0 }, // 279
  { CooperativeMatrixOperandsOperand, 0x20, "MatrixAAndBTF32ComponentsINTEL", 0x0, 0x0 }, // 280
  { CooperativeMatrixOperandsOperand, 0x40, "MatrixAAndBBFloat16ComponentsINTEL", 0x0, 0x0 }, // 281
  { CooperativeMatrixOperandsOperand, 0x80, "MatrixCBFloat16ComponentsINTEL", 0x0, 0x0 }, // 282
  { CooperativeMatrixOperandsOperand, 0x100, "MatrixResultBFloat16ComponentsINTEL", 0x0, 0x0 }, // 283
  { DecorationOperand, 0x0, "RelaxedPrecision", 0x0, 0x0 }, // 284
  { DecorationOperand, 0x1, "SpecId", 0x0, 0x0 }, // 285
  { DecorationOperand, 0x2, "Block", 0x0, 0x0 }, // 286
  { DecorationOperand, 0x3, "BufferBlock", 0x0, 0x0 }, // 287
  { DecorationOperand, 0x4, "RowMajor", 0x0, 0x0 }, // 288
  { DecorationOperand, 0x5, "ColMajor", 0x0, 0x0 }, // 289
  { DecorationOperand, 0x6, "ArrayStride", 0x0, 0x0 }, // 290
  { DecorationOperand, 0x7, "MatrixStride", 0x0, 0x0 }, // 291
  { DecorationOperand, 0x8, "GLSLShared", 0x0, 0x0 }, // 292
  { DecorationOperand, 0x9, "GLSLPacked", 0x0, 0x0 }, // 293
  { DecorationOperand, 0xA, "CPacked", 0x0, 0x0 }, // 294
  { DecorationOperand, 0xB, "BuiltIn", 0x0, 0x0 }, // 295
  { DecorationOperand, 0xD, "NoPerspective", 0x0, 0x0 }, // 296
  { DecorationOperand, 0xE, "Flat", 0x0, 0x0 }, // 297
  { DecorationOperand, 0xF, "Patch", 0x0, 0x0 }, // 298
  { DecorationOperand, 0x10, "Centroid", 0x0, 0x0 }, // 299
  { DecorationOperand, 0x11, "Sample", 0x0, 0x0 }, // 300
  { DecorationOperand, 0x12, "Invariant", 0x0, 0x0 }, // 301
  { DecorationOperand, 0x13, "Restrict", 0x0, 0x0 }, // 302
  { DecorationOperand, 0x14, "Aliased", 0x0, 0x0 }, // 303
  { DecorationOperand, 0x15, "Volatile", 0x0, 0x0 }, // 304
  { DecorationOperand, 0x16, "Constant", 0x0, 0x0 }, // 305
  { DecorationOperand, 0x17, "Coherent", 0x0, 0x0 }, // 306
  { DecorationOperand, 0x18, "NonWritable", 0x0, 0x0 }, // 307
  { DecorationOperand, 0x19, "NonReadable", 0x0, 0x0 }, // 308
  { DecorationOperand, 0x1A, "Uniform", 0x0, 0x0 }, // 309
  { DecorationOperand, 0x1B, "UniformId", 0x0, 0x0 }, // 310
  { DecorationOperand, 0x1C, "SaturatedConversion", 0x0, 0x0 }, // 311
  { DecorationOperand, 0x1D, "Stream", 0x0, 0x0 }, // 312
  { DecorationOperand, 0x1E, "Location", 0x0, 0x0 }, // 313
  { DecorationOperand, 0x1F, "Component", 0x0, 0x0 }, // 314
  { DecorationOperand, 0x20, "Index", 0x0, 0x0 }, // 315
  { DecorationOperand, 0x21, "Binding", 0x0, 0x0 }, // 316
  { DecorationOperand, 0x22, "DescriptorSet", 0x0, 0x0 }, // 317
  { DecorationOperand, 0x23, "Offset", 0x0, 0x0 }, // 318
  { DecorationOperand, 0x24, "XfbBuffer", 0x0, 0x0 }, // 319
  { DecorationOperand, 0x25, "XfbStride", 0x0, 0x0 }, // 320
  { DecorationOperand, 0x26, "FuncParamAttr", 0x0, 0x0 }, // 321
  { DecorationOperand, 0x27, "FPRoundingMode", 0x0, 0x0 }, // 322
  { DecorationOperand, 0x28, "FPFastMathMode", 0x0, 0x0 }, // 323
  { DecorationOperand, 0x29, "LinkageAttributes", 0x0, 0x0 }, // 324
  { DecorationOperand, 0x2A, "NoContraction", 0x0, 0x0 }, // 325
  { DecorationOperand, 0x2B, "InputAttachmentIndex", 0x0, 0x0 }, // 326
  { DecorationOperand, 0x2C, "Alignment", 0x0, 0x0 }, // 327
  { DecorationOperand, 0x2D, "MaxByteOffset", 0x0, 0x0 }, // 328
  { DecorationOperand, 0x2E, "AlignmentId", 0x0, 0x0 }, // 329
  { DecorationOperand, 0x2F, "MaxByteOffsetId", 0x0, 0x0 }, // 330
  { DecorationOperand, 0x1175, "NoSignedWrap", 0x10400, 0x0 }, // 331
  { DecorationOperand, 0x1176, "NoUnsignedWrap", 0x10400, 0x0 }, // 332
  { DecorationOperand, 0x1387, "ExplicitInterpAMD", 0x0, 0x0 }, // 333
  { DecorationOperand, 0x1480, "OverrideCoverageNV", 0x0, 0x0 }, // 334
  { DecorationOperand, 0x1482, "PassthroughNV", 0x0, 0x0 }, // 335
  { DecorationOperand, 0x1484, "ViewportRelativeNV", 0x0, 0x0 }, // 336
  { DecorationOperand, 0x1488, "SecondaryViewportRelativeNV", 0x0, 0x0 }, // 337
  { DecorationOperand, 0x1497, "PerPrimitiveNV", 0x0, 0x0 }, // 338
  { DecorationOperand, 0x1498, "PerViewNV", 0x0, 0x0 }, // 339
  { DecorationOperand, 0x1499, "PerVertexNV", 0x0, 0x0 }, // 340
  { DecorationOperand, 0x14B4, "NonUniformEXT", 0x0, 0x0 }, // 341
  { DecorationOperand, 0x14EB, "RestrictPointerEXT", 0x0, 0x0 }, // 342
  { DecorationOperand, 0x14EC, "AliasedPointerEXT", 0x0, 0x0 }, // 343
  { DecorationOperand, 0x15E2, "ReferencedIndirectlyINTEL", 0x0, 0x0 }, // 344
  { DecorationOperand, 0x15E7, "ClobberINTEL", 0x0, 0x0 }, // 345
  { DecorationOperand, 0x15E8, "SideEffectsINTEL", 0x0, 0x0 }, // 346
  { DecorationOperand, 0x1602, "CountBuffer", 0x0, 0x0 }, // 347
  { DecorationOperand, 0x1603, "UserSemantic", 0x0, 0x0 }, // 348
  { DecorationOperand, 0x16BE, "FunctionRoundingModeINTEL", 0x0, 0x0 }, // 349
  { DecorationOperand, 0x16BF, "FunctionDenormModeINTEL", 0x0, 0x0 }, // 350
  { DecorationOperand, 0x17C0, "FunctionFloatingPointModeINTEL", 0x0, 0x0 }, // 351
  { DecorationOperand, 0x182C, "HostAccessINTEL", 0x0, 0x0 }, // 352
  { DecorationOperand, 0x182E, "InitModeINTEL", 0x0, 0x0 }, // 353
  { DecorationOperand, 0x182F, "ImplementInRegisterMapINTEL", 0x0, 0x0 }, // 354
  { DecorationOperand, 0x1909, "ArgumentAttributeINTEL", 0x0, 0x0 }, // 355
  { DecorationOperand, 0x192A, "CacheControlLoadINTEL", 0x0, 0x0 }, // 356
  { DecorationOperand, 0x192B, "CacheControlStoreINTEL", 0x0, 0x0 }, // 357
  { DimOperand, 0x0, "1D", 0x0, 0x0 }, // 358
  { DimOperand, 0x1, "2D", 0x0, 0x0 }, // 359
  { DimOperand, 0x2, "3D", 0x0, 0x0 }, // 360
  { DimOperand, 0x3, "Cube", 0x0, 0x0 }, // 361
  { DimOperand, 0x4, "Rect", 0x0, 0x0 }, // 362
  { DimOperand, 0x5, "Buffer", 0x0, 0x0 }, // 363
  { DimOperand, 0x6, "SubpassData", 0x0, 0x0 }, // 364
  { ExecutionModeOperand, 0x0, "Invocations", 0x0, 0x0 }, // 365
  { ExecutionModeOperand, 0x1, "SpacingEqual", 0x0, 0x0 }, // 366
  { ExecutionModeOperand, 0x2, "SpacingFractionalEven", 0x0, 0x0 }, // 367
  { ExecutionModeOperand, 0x3, "SpacingFractionalOdd", 0x0, 0x0 }, // 368
  { ExecutionModeOperand, 0x4, "VertexOrderCw", 0x0, 0x0 }, // 369
  { ExecutionModeOperand, 0x5, "VertexOrderCcw", 0x0, 0x0 }, // 370
  { ExecutionModeOperand, 0x6, "PixelCenterInteger", 0x0, 0x0 }, // 371
  { ExecutionModeOperand, 0x7, "OriginUpperLeft", 0x0, 0x0 }, // 372
  { ExecutionModeOperand, 0x8, "OriginLowerLeft", 0x0, 0x0 }, // 373
  { ExecutionModeOperand, 0x9, "EarlyFragmentTests", 0x0, 0x0 }, // 374
  { ExecutionModeOperand, 0xA, "PointMode", 0x0, 0x0 }, // 375
  { ExecutionModeOperand, 0xB, "Xfb", 0x0, 0x0 }, // 376
  { ExecutionModeOperand, 0xC, "DepthReplacing", 0x0, 0x0 }, // 377
  { ExecutionModeOperand, 0xE, "DepthGreater", 0x0, 0x0 }, // 378
  { ExecutionModeOperand, 0xF, "DepthLess", 0x0, 0x0 }, // 379
  { ExecutionModeOperand, 0x10, "DepthUnchanged", 0x0, 0x0 }, // 380
  { ExecutionModeOperand, 0x11, "LocalSize", 0x0, 0x0 }, // 381
  { ExecutionModeOperand, 0x12, "LocalSizeHint", 0x0, 0x0 }, // 382
  { ExecutionModeOperand, 0x13, "InputPoints", 0x0, 0x0 }, // 383
  { ExecutionModeOperand, 0x14, "InputLines", 0x0, 0x0 }, // 384
  { ExecutionModeOperand, 0x15, "InputLinesAdjacency", 0x0, 0x0 }, // 385
  { ExecutionModeOperand, 0x16, "Triangles", 0x0, 0x0 }, // 386
  { ExecutionModeOperand, 0x17, "InputTrianglesAdjacency", 0x0, 0x0 }, // 387
  { ExecutionModeOperand, 0x18, "Quads", 0x0, 0x0 }, // 388
  { ExecutionModeOperand, 0x19, "Isolines", 0x0, 0x0 }, // 389
  { ExecutionModeOperand, 0x1A, "OutputVertices", 0x0, 0x0 }, // 390
  { ExecutionModeOperand, 0x1B, "OutputPoints", 0x0, 0x0 }, // 391
  { ExecutionModeOperand, 0x1C, "OutputLineStrip", 0x0, 0x0 }, // 392
  { ExecutionModeOperand, 0x1D, "OutputTriangleStrip", 0x0, 0x0 }, // 393
  { ExecutionModeOperand, 0x1E, "VecTypeHint", 0x0, 0x0 }, // 394
  { ExecutionModeOperand, 0x1F, "ContractionOff", 0x0, 0x0 }, // 395
  { ExecutionModeOperand, 0x21, "Initializer", 0x0, 0x0 }, // 396
  { ExecutionModeOperand, 0x22, "Finalizer", 0x0, 0x0 }, // 397
  { ExecutionModeOperand, 0x23, "SubgroupSize", 0x0, 0x0 }, // 398
  { ExecutionModeOperand, 0x24, "SubgroupsPerWorkgroup", 0x0, 0x0 }, // 399
  { ExecutionModeOperand, 0x25, "SubgroupsPerWorkgroupId", 0x0, 0x0 }, // 400
  { ExecutionModeOperand, 0x26, "LocalSizeId", 0x0, 0x0 }, // 401
  { ExecutionModeOperand, 0x27, "LocalSizeHintId", 0x0, 0x0 }, // 402
  { ExecutionModeOperand, 0x115E, "PostDepthCoverage", 0x0, 0x0 }, // 403
  { ExecutionModeOperand, 0x116B, "DenormPreserve", 0x0, 0x0 }, // 404
  { ExecutionModeOperand, 0x116C, "DenormFlushToZero", 0x0, 0x0 }, // 405
  { ExecutionModeOperand, 0x116D, "SignedZeroInfNanPreserve", 0x0, 0x0 }, // 406
  { ExecutionModeOperand, 0x116E, "RoundingModeRTE", 0x0, 0x0 }, // 407
  { ExecutionModeOperand, 0x116F, "RoundingModeRTZ", 0x0, 0x0 }, // 408
  { ExecutionModeOperand, 0x13A3, "StencilRefReplacingEXT", 0x0, 0x0 }, // 409
  { ExecutionModeOperand, 0x1495, "OutputLinesNV", 0x0, 0x0 }, // 410
  { ExecutionModeOperand, 0x14A9, "DerivativeGroupQuadsNV", 0x0, 0x0 }, // 411
  { ExecutionModeOperand, 0x14AA, "DerivativeGroupLinearNV", 0x0, 0x0 }, // 412
  { ExecutionModeOperand, 0x14B2, "OutputTrianglesNV", 0x0, 0x0 }, // 413
  { ExecutionModeOperand, 0x15F4, "RoundingModeRTPINTEL", 0x0, 0x0 }, // 414
  { ExecutionModeOperand, 0x15F5, "RoundingModeRTNINTEL", 0x0, 0x0 }, // 415
  { ExecutionModeOperand, 0x15F6, "FloatingPointModeALTINTEL", 0x0, 0x0 }, // 416
  { ExecutionModeOperand, 0x15F7, "FloatingPointModeIEEEINTEL", 0x0, 0x0 }, // 417
  { ExecutionModelOperand, 0x0, "Vertex", 0x0, 0x0 }, // 418
  { ExecutionModelOperand, 0x1, "TessellationControl", 0x0, 0x0 }, // 419
  { ExecutionModelOperand, 0x2, "TessellationEvaluation", 0x0, 0x0 }, // 420
  { ExecutionModelOperand, 0x3, "Geometry", 0x0, 0x0 }, // 421
  { ExecutionModelOperand, 0x4, "Fragment", 0x0, 0x0 }, // 422
  { ExecutionModelOperand, 0x5, "GLCompute", 0x0, 0x0 }, // 423
  { ExecutionModelOperand, 0x6, "Kernel", 0x0, 0x0 }, // 424
  { ExecutionModelOperand, 0x1493, "TaskNV", 0x0, 0x0 }, // 425
  { ExecutionModelOperand, 0x1494, "MeshNV", 0x0, 0x0 }, // 426
  { ExecutionModelOperand, 0x14C1, "RayGenerationNV", 0x0, 0x0 }, // 427
  { ExecutionModelOperand, 0x14C2, "IntersectionNV", 0x0, 0x0 }, // 428
  { ExecutionModelOperand, 0x14C3, "AnyHitNV", 0x0, 0x0 }, // 429
  { ExecutionModelOperand, 0x14C4, "ClosestHitNV", 0x0, 0x0 }, // 430
  { ExecutionModelOperand, 0x14C5, "MissNV", 0x0, 0x0 }, // 431
  { ExecutionModelOperand, 0x14C6, "CallableNV", 0x0, 0x0 }, // 432
  { ExtensionOperand, 0x1, "SPV_AMD_shader_explicit_vertex_parameter", 0x0, 0x0 }, // 433
  { ExtensionOperand, 0x2, "SPV_AMD_shader_trinary_minmax_extension", 0x0, 0x0 }, // 434
  { ExtensionOperand, 0x3, "SPV_AMD_gcn_shader", 0x0, 0x0 }, // 435
  { ExtensionOperand, 0x4, "SPV_KHR_shader_ballot", 0x0, 0x0 }, // 436
  { ExtensionOperand, 0x5, "SPV_AMD_shader_ballot", 0x0, 0x0 }, // 437
  { ExtensionOperand, 0x6, "SPV_AMD_gpu_shader_half_float", 0x0, 0x0 }, // 438
  { ExtensionOperand, 0x7, "SPV_KHR_shader_draw_parameters", 0x0, 0x0 }, // 439
  { ExtensionOperand, 0x8, "SPV_KHR_subgroup_vote", 0x0, 0x0 }, // 440
  { ExtensionOperand, 0x9, "SPV_KHR_16bit_storage", 0x0, 0x0 }, // 441
  { ExtensionOperand, 0xA, "SPV_KHR_device_group", 0x0, 0x0 }, // 442
  { ExtensionOperand, 0xB, "SPV_KHR_multiview", 0x0, 0x0 }, // 443
  { ExtensionOperand, 0xC, "SPV_NVX_multiview_per_view_attributes", 0x0, 0x0 }, // 444
  { ExtensionOperand, 0xD, "SPV_NV_viewport_array2", 0x0, 0x0 }, // 445
  { ExtensionOperand, 0xE, "SPV_NV_stereo_view_rendering", 0x0, 0x0 }, // 446
  { ExtensionOperand, 0xF, "SPV_NV_sample_mask_override_coverage", 0x0, 0x0 }, // 447
  { ExtensionOperand, 0x10, "SPV_NV_geometry_shader_passthrough", 0x0, 0x0 }, // 448
  { ExtensionOperand, 0x11, "SPV_AMD_texture_gather_bias_lod", 0x0, 0x0 }, // 449
  { ExtensionOperand, 0x12, "SPV_KHR_storage_buffer_storage_class", 0x0, 0x0 }, // 450
  { ExtensionOperand, 0x13, "SPV_KHR_variable_pointers", 0x0, 0x0 }, // 451
  { ExtensionOperand, 0x14, "SPV_AMD_gpu_shader_int16", 0x0, 0x0 }, // 452
  { ExtensionOperand, 0x15, "SPV_KHR_post_depth_coverage", 0x0, 0x0 }, // 453
  { ExtensionOperand, 0x16, "SPV_KHR_shader_atomic_counter_ops", 0x0, 0x0 }, // 454
  { ExtensionOperand, 0x17, "SPV_EXT_shader_stencil_export", 0x0, 0x0 }, // 455
  { ExtensionOperand, 0x18, "SPV_EXT_shader_viewport_index_layer", 0x0, 0x0 }, // 456
  { ExtensionOperand, 0x19, "SPV_AMD_shader_image_load_store_lod", 0x0, 0x0 }, // 457
  { ExtensionOperand, 0x1A, "SPV_AMD_shader_fragment_mask", 0x0, 0x0 }, // 458
  { ExtensionOperand, 0x1B, "SPV_EXT_fragment_fully_covered", 0x0, 0x0 }, // 459
  { ExtensionOperand, 0x1C, "SPV_AMD_gpu_shader_half_float_fetch", 0x0, 0x0 }, // 460
  { ExtensionOperand, 0x1D, "SPV_GOOGLE_decorate_string", 0x0, 0x0 }, // 461
  { ExtensionOperand, 0x1E, "SPV_GOOGLE_hlsl_functionality1", 0x0, 0x0 }, // 462
  { ExtensionOperand, 0x1F, "SPV_NV_shader_subgroup_partitioned", 0x0, 0x0 }, // 463
  { ExtensionOperand, 0x20, "SPV_EXT_descriptor_indexing", 0x0, 0x0 }, // 464
  { ExtensionOperand, 0x21, "SPV_KHR_8bit_storage", 0x0, 0x0 }, // 465
  { ExtensionOperand, 0x22, "SPV_KHR_vulkan_memory_model", 0x0, 0x0 }, // 466
  { ExtensionOperand, 0x23, "SPV_NV_ray_tracing", 0x0, 0x0 }, // 467
  { ExtensionOperand, 0x24, "SPV_NV_compute_shader_derivatives", 0x0, 0x0 }, // 468
  { ExtensionOperand, 0x25, "SPV_NV_fragment_shader_barycentric", 0x0, 0x0 }, // 469
  { ExtensionOperand, 0x26, "SPV_NV_mesh_shader", 0x0, 0x0 }, // 470
  { ExtensionOperand, 0x27, "SPV_NV_shader_image_footprint", 0x0, 0x0 }, // 471
  { ExtensionOperand, 0x28, "SPV_NV_shading_rate", 0x0, 0x0 }, // 472
  { ExtensionOperand, 0x29, "SPV_INTEL_subgroups", 0x0, 0x0 }, // 473
  { ExtensionOperand, 0x2A, "SPV_INTEL_media_block_io", 0x0, 0x0 }, // 474
  { ExtensionOperand, 0x2C, "SPV_EXT_fragment_invocation_density", 0x0, 0x0 }, // 475
  { ExtensionOperand, 0x2D, "SPV_KHR_no_integer_wrap_decoration", 0x0, 0x0 }, // 476
  { ExtensionOperand, 0x2E, "SPV_KHR_float_controls", 0x0, 0x0 }, // 477
  { ExtensionOperand, 0x2F, "SPV_EXT_physical_storage_buffer", 0x0, 0x0 }, // 478
  { ExtensionOperand, 0x30, "SPV_INTEL_fpga_memory_attributes", 0x0, 0x0 }, // 479
  { ExtensionOperand, 0x31, "SPV_NV_cooperative_matrix", 0x0, 0x0 }, // 480
  { ExtensionOperand, 0x32, "SPV_INTEL_shader_integer_functions2", 0x0, 0x0 }, // 481
  { ExtensionOperand, 0x33, "SPV_INTEL_fpga_loop_controls", 0x0, 0x0 }, // 482
  { ExtensionOperand, 0x34, "SPV_EXT_fragment_shader_interlock", 0x0, 0x0 }, // 483
  { ExtensionOperand, 0x35, "SPV_NV_shader_sm_builtins", 0x0, 0x0 }, // 484
  { ExtensionOperand, 0x36, "SPV_KHR_shader_clock", 0x0, 0x0 }, // 485
  { ExtensionOperand, 0x37, "SPV_INTEL_unstructured_loop_controls", 0x0, 0x0 }, // 486
  { ExtensionOperand, 0x38, "SPV_EXT_demote_to_helper_invocation", 0x0, 0x0 }, // 487
  { ExtensionOperand, 0x39, "SPV_INTEL_fpga_reg", 0x0, 0x0 }, // 488
  { ExtensionOperand, 0x3A, "SPV_INTEL_blocking_pipes", 0x0, 0x0 }, // 489
  { ExtensionOperand, 0x3B, "SPV_GOOGLE_user_type", 0x0, 0x0 }, // 490
  { ExtensionOperand, 0x3C, "SPV_KHR_physical_storage_buffer", 0x0, 0x0 }, // 491
  { ExtensionOperand, 0x3D, "SPV_INTEL_kernel_attributes", 0x0, 0x0 }, // 492
  { ExtensionOperand, 0x3E, "SPV_KHR_non_semantic_info", 0x0, 0x0 }, // 493
  { ExtensionOperand, 0x3F, "SPV_INTEL_io_pipes", 0x0, 0x0 }, // 494
  { ExtensionOperand, 0x40, "SPV_KHR_ray_tracing", 0x0, 0x0 }, // 495
  { ExtensionOperand, 0x41, "SPV_KHR_ray_query", 0x0, 0x0 }, // 496
  { ExtensionOperand, 0x42, "SPV_INTEL_fpga_memory_accesses", 0x0, 0x0 }, // 497
  { ExtensionOperand, 0x43, "SPV_INTEL_arbitrary_precision_integers", 0x0, 0x0 }, // 498
  { ExtensionOperand, 0x44, "SPV_EXT_shader_atomic_float_add", 0x0, 0x0 }, // 499
  { ExtensionOperand, 0x45, "SPV_KHR_terminate_invocation", 0x0, 0x0 }, // 500
  { ExtensionOperand, 0x46, "SPV_KHR_fragment_shading_rate", 0x0, 0x0 }, // 501
  { ExtensionOperand, 0x47, "SPV_EXT_shader_image_int64", 0x0, 0x0 }, // 502
  { ExtensionOperand, 0x48, "SPV_INTEL_fp_fast_math_mode", 0x0, 0x0 }, // 503
  { ExtensionOperand, 0x49, "SPV_INTEL_fpga_cluster_attributes", 0x0, 0x0 }, // 504
  { ExtensionOperand, 0x4A, "SPV_INTEL_loop_fuse", 0x0, 0x0 }, // 505
  { ExtensionOperand, 0x4B, "SPV_EXT_shader_atomic_float_min_max", 0x0, 0x0 }, // 506
  { ExtensionOperand, 0x4C, "SPV_KHR_workgroup_memory_explicit_layout", 0x0, 0x0 }, // 507
  { ExtensionOperand, 0x4D, "SPV_KHR_linkonce_odr", 0x0, 0x0 }, // 508
  { ExtensionOperand, 0x4E, "SPV_KHR_expect_assume", 0x0, 0x0 }, // 509
  { ExtensionOperand, 0x4F, "SPV_INTEL_fpga_dsp_control", 0x0, 0x0 }, // 510
  { ExtensionOperand, 0x50, "SPV_NV_bindless_texture", 0x0, 0x0 }, // 511
  { ExtensionOperand, 0x51, "SPV_INTEL_fpga_invocation_pipelining_attributes", 0x0, 0x0 }, // 512
  { ExtensionOperand, 0x52, "SPV_KHR_subgroup_uniform_control_flow", 0x0, 0x0 }, // 513
  { ExtensionOperand, 0x53, "SPV_HUAWEI_subpass_shading", 0x0, 0x0 }, // 514
  { ExtensionOperand, 0x54, "SPV_KHR_integer_dot_product", 0x0, 0x0 }, // 515
  { ExtensionOperand, 0x55, "SPV_EXT_shader_atomic_float16_add", 0x0, 0x0 }, // 516
  { ExtensionOperand, 0x56, "SPV_INTEL_runtime_aligned", 0x0, 0x0 }, // 517
  { ExtensionOperand, 0x57, "SPV_KHR_bit_instructions", 0x0, 0x0 }, // 518
  { ExtensionOperand, 0x58, "SPV_NV_ray_tracing_motion_blur", 0x0, 0x0 }, // 519
  { ExtensionOperand, 0x59, "SPV_KHR_uniform_group_instructions", 0x0, 0x0 }, // 520
  { ExtensionOperand, 0x5A, "SPV_KHR_subgroup_rotate", 0x0, 0x0 }, // 521
  { ExtensionOperand, 0x5B, "SPV_INTEL_split_barrier", 0x0, 0x0 }, // 522
  { ExtensionOperand, 0x5C, "SPV_KHR_ray_cull_mask", 0x0, 0x0 }, // 523
  { ExtensionOperand, 0x5D, "SPV_KHR_fragment_shader_barycentric", 0x0, 0x0 }, // 524
  { ExtensionOperand, 0x5E, "SPV_EXT_relaxed_printf_string_address_space", 0x0, 0x0 }, // 525
  { ExtensionOperand, 0x5F, "SPV_EXT_ycbcr_attachments", 0x0, 0x0 }, // 526
  { ExtensionOperand, 0x60, "SPV_EXT_mesh_shader", 0x0, 0x0 }, // 527
  { ExtensionOperand, 0x61, "SPV_ARM_core_builtins", 0x0, 0x0 }, // 528
  { ExtensionOperand, 0x62, "SPV_EXT_opacity_micromap", 0x0, 0x0 }, // 529
  { ExtensionOperand, 0x63, "SPV_NV_shader_invocation_reorder", 0x0, 0x0 }, // 530
  { ExtensionOperand, 0x64, "SPV_INTEL_usm_storage_classes", 0x0, 0x0 }, // 531
  { ExtensionOperand, 0x65, "SPV_INTEL_fpga_latency_control", 0x0, 0x0 }, // 532
  { ExtensionOperand, 0x66, "SPV_INTEL_fpga_argument_interfaces", 0x0, 0x0 }, // 533
  { ExtensionOperand, 0x67, "SPV_INTEL_optnone", 0x0, 0x0 }, // 534
  { ExtensionOperand, 0x68, "SPV_INTEL_function_pointers", 0x0, 0x0 }, // 535
  { ExtensionOperand, 0x69, "SPV_INTEL_variable_length_array", 0x0, 0x0 }, // 536
  { ExtensionOperand, 0x6A, "SPV_INTEL_bfloat16_conversion", 0x0, 0x0 }, // 537
  { ExtensionOperand, 0x6B, "SPV_INTEL_inline_assembly", 0x0, 0x0 }, // 538
  { ExtensionOperand, 0x6C, "SPV_INTEL_cache_controls", 0x0, 0x0 }, // 539
  { ExtensionOperand, 0x6D, "SPV_INTEL_global_variable_host_access", 0x0, 0x0 }, // 540
  { ExtensionOperand, 0x6E, "SPV_INTEL_global_variable_fpga_decorations", 0x0, 0x0 }, // 541
  { ExtensionOperand, 0x6F, "SPV_KHR_cooperative_matrix", 0x0, 0x0 }, // 542
  { ExtensionOperand, 0x70, "SPV_EXT_arithmetic_fence", 0x0, 0x0 }, // 543
  { ExtensionOperand, 0x71, "SPV_EXT_optnone", 0x0, 0x0 }, // 544
  { ExtensionOperand, 0x72, "SPV_INTEL_joint_matrix", 0x0, 0x0 }, // 545
  { ExtensionOperand, 0x73, "SPV_INTEL_float_controls2", 0x0, 0x0 }, // 546
  { FPFastMathModeOperand, 0x0, "None", 0x0, 0x0 }, // 547
  { FPFastMathModeOperand, 0x1, "NotNaN", 0x0, 0x0 }, // 548
  { FPFastMathModeOperand, 0x2, "NotInf", 0x0, 0x0 }, // 549
  { FPFastMathModeOperand, 0x4, "NSZ", 0x0, 0x0 }, // 550
  { FPFastMathModeOperand, 0x8, "AllowRecip", 0x0, 0x0 }, // 551
  { FPFastMathModeOperand, 0x10, "Fast", 0x0, 0x0 }, // 552
  { FPRoundingModeOperand, 0x0, "RTE", 0x0, 0x0 }, // 553
  { FPRoundingModeOperand, 0x1, "RTZ", 0x0, 0x0 }, // 554
  { FPRoundingModeOperand, 0x2, "RTP", 0x0, 0x0 }, // 555
  { FPRoundingModeOperand, 0x3, "RTN", 0x0, 0x0 }, // 556
  { FunctionControlOperand, 0x0, "None", 0x0, 0x0 }, // 557
  { FunctionControlOperand, 0x1, "Inline", 0x0, 0x0 }, // 558
  { FunctionControlOperand, 0x2, "DontInline", 0x0, 0x0 }, // 559
  { FunctionControlOperand, 0x4, "Pure", 0x0, 0x0 }, // 560
  { FunctionControlOperand, 0x8, "Const", 0x0, 0x0 }, // 561
  { FunctionControlOperand, 0x10000, "OptNoneEXT", 0x0, 0x0 }, // 562
  { FunctionParameterAttributeOperand, 0x0, "Zext", 0x0, 0x0 }, // 563
  { FunctionParameterAttributeOperand, 0x1, "Sext", 0x0, 0x0 }, // 564
  { FunctionParameterAttributeOperand, 0x2, "ByVal", 0x0, 0x0 }, // 565
  { FunctionParameterAttributeOperand, 0x3, "Sret", 0x0, 0x0 }, // 566
  { FunctionParameterAttributeOperand, 0x4, "NoAlias", 0x0, 0x0 }, // 567
  { FunctionParameterAttributeOperand, 0x5, "NoCapture", 0x0, 0x0 }, // 568
  { FunctionParameterAttributeOperand, 0x6, "NoWrite", 0x0, 0x0 }, // 569
  { FunctionParameterAttributeOperand, 0x7, "NoReadWrite", 0x0, 0x0 }, // 570
  { GroupOperationOperand, 0x0, "Reduce", 0x0, 0x0 }, // 571
  { GroupOperationOperand, 0x1, "InclusiveScan", 0x0, 0x0 }, // 572
  { GroupOperationOperand, 0x2, "ExclusiveScan", 0x0, 0x0 }, // 573
  { GroupOperationOperand, 0x3, "ClusteredReduce", 0x0, 0x0 }, // 574
  { GroupOperationOperand, 0x6, "PartitionedReduceNV", 0x0, 0x0 }, // 575
  { GroupOperationOperand, 0x7, "PartitionedInclusiveScanNV", 0x0, 0x0 }, // 576
  { GroupOperationOperand, 0x8, "PartitionedExclusiveScanNV", 0x0, 0x0 }, // 577
  { ImageChannelDataTypeOperand, 0x0, "SnormInt8", 0x0, 0x0 }, // 578
  { ImageChannelDataTypeOperand, 0x1, "SnormInt16", 0x0, 0x0 }, // 579
  { ImageChannelDataTypeOperand, 0x2, "UnormInt8", 0x0, 0x0 }, // 580
  { ImageChannelDataTypeOperand, 0x3, "UnormInt16", 0x0, 0x0 }, // 581
  { ImageChannelDataTypeOperand, 0x4, "UnormShort565", 0x0, 0x0 }, // 582
  { ImageChannelDataTypeOperand, 0x5, "UnormShort555", 0x0, 0x0 }, // 583
  { ImageChannelDataTypeOperand, 0x6, "UnormInt101010", 0x0, 0x0 }, // 584
  { ImageChannelDataTypeOperand, 0x7, "SignedInt8", 0x0, 0x0 }, // 585
  { ImageChannelDataTypeOperand, 0x8, "SignedInt16", 0x0, 0x0 }, // 586
  { ImageChannelDataTypeOperand, 0x9, "SignedInt32", 0x0, 0x0 }, // 587
  { ImageChannelDataTypeOperand, 0xA, "UnsignedInt8", 0x0, 0x0 }, // 588
  { ImageChannelDataTypeOperand, 0xB, "UnsignedInt16", 0x0, 0x0 }, // 589
  { ImageChannelDataTypeOperand, 0xC, "UnsigendInt32", 0x0, 0x0 }, // 590
  { ImageChannelDataTypeOperand, 0xD, "HalfFloat", 0x0, 0x0 }, // 591
  { ImageChannelDataTypeOperand, 0xE, "Float", 0x0, 0x0 }, // 592
  { ImageChannelDataTypeOperand, 0xF, "UnormInt24", 0x0, 0x0 }, // 593
  { ImageChannelDataTypeOperand, 0x10, "UnormInt101010_2", 0x0, 0x0 }, // 594
  { ImageChannelOrderOperand, 0x0, "R", 0x0, 0x0 }, // 595
  { ImageChannelOrderOperand, 0x1, "A", 0x0, 0x0 }, // 596
  { ImageChannelOrderOperand, 0x2, "RG", 0x0, 0x0 }, // 597
  { ImageChannelOrderOperand, 0x3, "RA", 0x0, 0x0 }, // 598
  { ImageChannelOrderOperand, 0x4, "RGB", 0x0, 0x0 }, // 599
  { ImageChannelOrderOperand, 0x5, "RGBA", 0x0, 0x0 }, // 600
  { ImageChannelOrderOperand, 0x6, "BGRA", 0x0, 0x0 }, // 601
  { ImageChannelOrderOperand, 0x7, "ARGB", 0x0, 0x0 }, // 602
  { ImageChannelOrderOperand, 0x8, "Intensity", 0x0, 0x0 }, // 603
  { ImageChannelOrderOperand, 0x9, "Luminance", 0x0, 0x0 }, // 604
  { ImageChannelOrderOperand, 0xA, "Rx", 0x0, 0x0 }, // 605
  { ImageChannelOrderOperand, 0xB, "RGx", 0x0, 0x0 }, // 606
  { ImageChannelOrderOperand, 0xC, "RGBx", 0x0, 0x0 }, // 607
  { ImageChannelOrderOperand, 0xD, "Depth", 0x0, 0x0 }, // 608
  { ImageChannelOrderOperand, 0xE, "DepthStencil", 0x0, 0x0 }, // 609
  { ImageChannelOrderOperand, 0xF, "sRGB", 0x0, 0x0 }, // 610
  { ImageChannelOrderOperand, 0x10, "sRGBx", 0x0, 0x0 }, // 611
  { ImageChannelOrderOperand, 0x11, "sRGBA", 0x0, 0x0 }, // 612
  { ImageChannelOrderOperand, 0x12, "sBGRA", 0x0, 0x0 }, // 613
  { ImageChannelOrderOperand, 0x13, "ABGR", 0x0, 0x0 }, // 614
  { ImageFormatOperand, 0x0, "Unknown", 0x0, 0x0 }, // 615
  { ImageFormatOperand, 0x1, "Rgba32f", 0x0, 0x0 }, // 616
  { ImageFormatOperand, 0x2, "Rgba16f", 0x0, 0x0 }, // 617
  { ImageFormatOperand, 0x3, "R32f", 0x0, 0x0 }, // 618
  { ImageFormatOperand, 0x4, "Rgba8", 0x0, 0x0 }, // 619
  { ImageFormatOperand, 0x5, "Rgba8Snorm", 0x0, 0x0 }, // 620
  { ImageFormatOperand, 0x6, "Rg32f", 0x0, 0x0 }, // 621
  { ImageFormatOperand, 0x7, "Rg16f", 0x0, 0x0 }, // 622
  { ImageFormatOperand, 0x8, "R11fG11fB10f", 0x0, 0x0 }, // 623
  { ImageFormatOperand, 0x9, "R16f", 0x0, 0x0 }, // 624
  { ImageFormatOperand, 0xA, "Rgba16", 0x0, 0x0 }, // 625
  { ImageFormatOperand, 0xB, "Rgb10A2", 0x0, 0x0 }, // 626
  { ImageFormatOperand, 0xC, "Rg16", 0x0, 0x0 }, // 627
  { ImageFormatOperand, 0xD, "Rg8", 0x0, 0x0 }, // 628
  { ImageFormatOperand, 0xE, "R16", 0x0, 0x0 }, // 629
  { ImageFormatOperand, 0xF, "R8", 0x0, 0x0 }, // 630
  { ImageFormatOperand, 0x10, "Rgba16Snorm", 0x0, 0x0 }, // 631
  { ImageFormatOperand, 0x11, "Rg16Snorm", 0x0, 0x0 }, // 632
  { ImageFormatOperand, 0x12, "Rg8Snorm", 0x0, 0x0 }, // 633
  { ImageFormatOperand, 0x13, "R16Snorm", 0x0, 0x0 }, // 634
  { ImageFormatOperand, 0x14, "R8Snorm", 0x0, 0x0 }, // 635
  { ImageFormatOperand, 0x15, "Rgba32i", 0x0, 0x0 }, // 636
  { ImageFormatOperand, 0x16, "Rgba16i", 0x0, 0x0 }, // 637
  { ImageFormatOperand, 0x17, "Rgba8i", 0x0, 0x0 }, // 638
  { ImageFormatOperand, 0x18, "R32i", 0x0, 0x0 }, // 639
  { ImageFormatOperand, 0x19, "Rg32i", 0x0, 0x0 }, // 640
  { ImageFormatOperand, 0x1A, "Rg16i", 0x0, 0x0 }, // 641
  { ImageFormatOperand, 0x1B, "Rg8i", 0x0, 0x0 }, // 642
  { ImageFormatOperand, 0x1C, "R16i", 0x0, 0x0 }, // 643
  { ImageFormatOperand, 0x1D, "R8i", 0x0, 0x0 }, // 644
  { ImageFormatOperand, 0x1E, "Rgba32ui", 0x0, 0x0 }, // 645
  { ImageFormatOperand, 0x1F, "Rgba16ui", 0x0, 0x0 }, // 646
  { ImageFormatOperand, 0x20, "Rgba8ui", 0x0, 0x0 }, // 647
  { ImageFormatOperand, 0x21, "R32ui", 0x0, 0x0 }, // 648
  { ImageFormatOperand, 0x22, "Rgb10a2ui", 0x0, 0x0 }, // 649
  { ImageFormatOperand, 0x23, "Rg32ui", 0x0, 0x0 }, // 650
  { ImageFormatOperand, 0x24, "Rg16ui", 0x0, 0x0 }, // 651
  { ImageFormatOperand, 0x25, "Rg8ui", 0x0, 0x0 }, // 652
  { ImageFormatOperand, 0x26, "R16ui", 0x0, 0x0 }, // 653
  { ImageFormatOperand, 0x27, "R8ui", 0x0, 0x0 }, // 654
  { ImageOperandOperand, 0x0, "None", 0x0, 0x0 }, // 655
  { ImageOperandOperand, 0x1, "Bias", 0x0, 0x0 }, // 656
  { ImageOperandOperand, 0x2, "Lod", 0x0, 0x0 }, // 657
  { ImageOperandOperand, 0x4, "Grad", 0x0, 0x0 }, // 658
  { ImageOperandOperand, 0x8, "ConstOffset", 0x0, 0x0 }, // 659
  { ImageOperandOperand, 0x10, "Offset", 0x0, 0x0 }, // 660
  { ImageOperandOperand, 0x20, "ConstOffsets", 0x0, 0x0 }, // 661
  { ImageOperandOperand, 0x40, "Sample", 0x0, 0x0 }, // 662
  { ImageOperandOperand, 0x80, "MinLod", 0x0, 0x0 }, // 663
  { ImageOperandOperand, 0x100, "MakeTexelAvailableKHR", 0x0, 0x0 }, // 664
  { ImageOperandOperand, 0x200, "MakeTexelVisibleKHR", 0x0, 0x0 }, // 665
  { ImageOperandOperand, 0x400, "NonPrivateTexelKHR", 0x0, 0x0 }, // 666
  { ImageOperandOperand, 0x800, "VolatileTexelKHR", 0x0, 0x0 }, // 667
  { ImageOperandOperand, 0x1000, "SignExtend", 0x0, 0x0 }, // 668
  { ImageOperandOperand, 0x2000, "ZeroExtend", 0x0, 0x0 }, // 669
  { KernelEnqueueFlagsOperand, 0x0, "NoWait", 0x0, 0x0 }, // 670
  { KernelEnqueueFlagsOperand, 0x1, "WaitKernel", 0x0, 0x0 }, // 671
  { KernelEnqueueFlagsOperand, 0x2, "WaitWorkGroup", 0x0, 0x0 }, // 672
  { KernelProfilingInfoOperand, 0x0, "None", 0x0, 0x0 }, // 673
  { KernelProfilingInfoOperand, 0x1, "CmdExecTime", 0x0, 0x0 }, // 674
  { LinkageTypeOperand, 0x0, "Export", 0x0, 0x0 }, // 675
  { LinkageTypeOperand, 0x1, "Import", 0x0, 0x0 }, // 676
  { LinkageTypeOperand, 0x2, "LinkOnceODR", 0x0, 0x0 }, // 677
  { LoopControlOperand, 0x0, "None", 0x0, 0x0 }, // 678
  { LoopControlOperand, 0x1, "Unroll", 0x0, 0x0 }, // 679
  { LoopControlOperand, 0x2, "DontUnroll", 0x0, 0x0 }, // 680
  { LoopControlOperand, 0x4, "DependencyInfinite", 0x0, 0x0 }, // 681
  { LoopControlOperand, 0x8, "DependencyLength", 0x0, 0x0 }, // 682
  { LoopControlOperand, 0x10, "MinIterations", 0x0, 0x0 }, // 683
  { LoopControlOperand, 0x20, "MaxIterations", 0x0, 0x0 }, // 684
  { LoopControlOperand, 0x40, "IterationMultiple", 0x0, 0x0 }, // 685
  { LoopControlOperand, 0x80, "PeelCount", 0x0, 0x0 }, // 686
  { LoopControlOperand, 0x100, "PartialCount", 0x0, 0x0 }, // 687
  { MemoryModelOperand, 0x0, "Simple", 0x0, 0x0 }, // 688
  { MemoryModelOperand, 0x1, "GLSL450", 0x0, 0x0 }, // 689
  { MemoryModelOperand, 0x2, "OpenCL", 0x0, 0x0 }, // 690
  { MemoryModelOperand, 0x3, "VulkanKHR", 0x0, 0x0 }, // 691
  { MemoryOperandOperand, 0x0, "None", 0x0, 0x0 }, // 692
  { MemoryOperandOperand, 0x1, "Volatile", 0x0, 0x0 }, // 693
  { MemoryOperandOperand, 0x2, "Aligned", 0x0, 0x0 }, // 694
  { MemoryOperandOperand, 0x4, "Nontemporal", 0x0, 0x0 }, // 695
  { MemoryOperandOperand, 0x8, "MakePointerAvailableKHR", 0x0, 0x0 }, // 696
  { MemoryOperandOperand, 0x10, "MakePointerVisibleKHR", 0x0, 0x0 }, // 697
  { MemoryOperandOperand, 0x20, "NonPrivatePointerKHR", 0x0, 0x0 }, // 698
  { MemorySemanticsOperand, 0x0, "None", 0x0, 0x0 }, // 699
  { MemorySemanticsOperand, 0x2, "Acquire", 0x0, 0x0 }, // 700
  { MemorySemanticsOperand, 0x4, "Release", 0x0, 0x0 }, // 701
  { MemorySemanticsOperand, 0x8, "AcquireRelease", 0x0, 0x0 }, // 702
  { MemorySemanticsOperand, 0x10, "SequentiallyConsistent", 0x0, 0x0 }, // 703
  { MemorySemanticsOperand, 0x40, "UniformMemory", 0x0, 0x0 }, // 704
  { MemorySemanticsOperand, 0x80, "SubgroupMemory", 0x0, 0x0 }, // 705
  { MemorySemanticsOperand, 0x100, "WorkgroupMemory", 0x0, 0x0 }, // 706
  { MemorySemanticsOperand, 0x200, "CrossWorkgroupMemory", 0x0, 0x0 }, // 707
  { MemorySemanticsOperand, 0x400, "AtomicCounterMemory", 0x0, 0x0 }, // 708
  { MemorySemanticsOperand, 0x800, "ImageMemory", 0x0, 0x0 }, // 709
  { MemorySemanticsOperand, 0x1000, "OutputMemoryKHR", 0x0, 0x0 }, // 710
  { MemorySemanticsOperand, 0x2000, "MakeAvailableKHR", 0x0, 0x0 }, // 711
  { MemorySemanticsOperand, 0x4000, "MakeVisibleKHR", 0x0, 0x0 }, // 712
  { OpcodeOperand, 0x42, "InBoundsAccessChain", 0x0, 0x0 }, // 713
  { OpcodeOperand, 0x46, "InBoundsPtrAccessChain", 0x0, 0x0 }, // 714
  { OpcodeOperand, 0x75, "ConvertPtrToU", 0x0, 0x0 }, // 715
  { OpcodeOperand, 0x78, "ConvertUToPtr", 0x0, 0x0 }, // 716
  { OpcodeOperand, 0x79, "PtrCastToGeneric", 0x0, 0x0 }, // 717
  { OpcodeOperand, 0x7A, "GenericCastToPtr", 0x0, 0x0 }, // 718
  { OpcodeOperand, 0x7C, "Bitcast", 0x0, 0x0 }, // 719
  { SamplerAddressingModeOperand, 0x0, "None", 0x0, 0x0 }, // 720
  { SamplerAddressingModeOperand, 0x1, "ClampToEdge", 0x0, 0x0 }, // 721
  { SamplerAddressingModeOperand, 0x2, "Clamp", 0x0, 0x0 }, // 722
  { SamplerAddressingModeOperand, 0x3, "Repeat", 0x0, 0x0 }, // 723
  { SamplerAddressingModeOperand, 0x4, "RepeatMirrored", 0x0, 0x0 }, // 724
  { SamplerFilterModeOperand, 0x0, "Nearest", 0x0, 0x0 }, // 725
  { SamplerFilterModeOperand, 0x1, "Linear", 0x0, 0x0 }, // 726
  { ScopeOperand, 0x0, "CrossDevice", 0x0, 0x0 }, // 727
  { ScopeOperand, 0x1, "Device", 0x0, 0x0 }, // 728
  { ScopeOperand, 0x2, "Workgroup", 0x0, 0x0 }, // 729
  { ScopeOperand, 0x3, "Subgroup", 0x0, 0x0 }, // 730
  { ScopeOperand, 0x4, "Invocation", 0x0, 0x0 }, // 731
  { ScopeOperand, 0x5, "QueueFamilyKHR", 0x0, 0x0 }, // 732
  { SelectionControlOperand, 0x0, "None", 0x0, 0x0 }, // 733
  { SelectionControlOperand, 0x1, "Flatten", 0x0, 0x0 }, // 734
  { SelectionControlOperand, 0x2, "DontFlatten", 0x0, 0x0 }, // 735
  { SourceLanguageOperand, 0x0, "Unknown", 0x0, 0x0 }, // 736
  { SourceLanguageOperand, 0x1, "ESSL", 0x0, 0x0 }, // 737
  { SourceLanguageOperand, 0x2, "GLSL", 0x0, 0x0 }, // 738
  { SourceLanguageOperand, 0x3, "OpenCL_C", 0x0, 0x0 }, // 739
  { SourceLanguageOperand, 0x4, "OpenCL_CPP", 0x0, 0x0 }, // 740
  { SourceLanguageOperand, 0x5, "HLSL", 0x0, 0x0 }, // 741
  { StorageClassOperand, 0x0, "UniformConstant", 0x0, 0x0 }, // 742
  { StorageClassOperand, 0x1, "Input", 0x0, 0x0 }, // 743
  { StorageClassOperand, 0x2, "Uniform", 0x0, 0x0 }, // 744
  { StorageClassOperand, 0x3, "Output", 0x0, 0x0 }, // 745
  { StorageClassOperand, 0x4, "Workgroup", 0x0, 0x0 }, // 746
  { StorageClassOperand, 0x5, "CrossWorkgroup", 0x0, 0x0 }, // 747
  { StorageClassOperand, 0x6, "Private", 0x0, 0x0 }, // 748
  { StorageClassOperand, 0x7, "Function", 0x0, 0x0 }, // 749
  { StorageClassOperand, 0x8, "Generic", 0x0, 0x0 }, // 750
  { StorageClassOperand, 0x9, "PushConstant", 0x0, 0x0 }, // 751
  { StorageClassOperand, 0xA, "AtomicCounter", 0x0, 0x0 }, // 752
  { StorageClassOperand, 0xB, "Image", 0x0, 0x0 }, // 753
  { StorageClassOperand, 0xC, "StorageBuffer", 0x0, 0x0 }, // 754
  { StorageClassOperand, 0x14D0, "CallableDataNV", 0x0, 0x0 }, // 755
  { StorageClassOperand, 0x14D1, "IncomingCallableDataNV", 0x0, 0x0 }, // 756
  { StorageClassOperand, 0x14DA, "RayPayloadNV", 0x0, 0x0 }, // 757
  { StorageClassOperand, 0x14DB, "HitAttributeNV", 0x0, 0x0 }, // 758
  { StorageClassOperand, 0x14DE, "IncomingRayPayloadNV", 0x0, 0x0 }, // 759
  { StorageClassOperand, 0x14DF, "ShaderRecordBufferNV", 0x0, 0x0 }, // 760
  { StorageClassOperand, 0x14E5, "PhysicalStorageBufferEXT", 0x0, 0x0 }, // 761
  { StorageClassOperand, 0x15E5, "CodeSectionINTEL", 0x0, 0x0 }, // 762
  { StorageClassOperand, 0x1730, "DeviceOnlyINTEL", 0x0, 0x0 }, // 763
  { StorageClassOperand, 0x1731, "HostOnlyINTEL", 0x0, 0x0 }, // 764
 };

const SymbolicOperand *lookupSymbolicOperandByCategoryAndValue(unsigned Category, uint32_t Value) {
  struct KeyType {
    unsigned Category;
    uint32_t Value;
  };
  KeyType Key = {Category, Value};
  struct Comp {
    bool operator()(const SymbolicOperand &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Category < (unsigned)RHS.Category)
        return true;
      if ((unsigned)LHS.Category > (unsigned)RHS.Category)
        return false;
      if (LHS.Value < RHS.Value)
        return true;
      if (LHS.Value > RHS.Value)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(SymbolicOperands);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Category != Idx->Category ||
      Key.Value != Idx->Value)
    return nullptr;

  return &*Idx;
}

const SymbolicOperand *lookupSymbolicOperandByCategory(unsigned Category) {
  struct IndexType {
    unsigned Category;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { AccessQualifierOperand, 0 },
    { AccessQualifierOperand, 1 },
    { AccessQualifierOperand, 2 },
    { AccessQualifierOperand, 3 },
    { AddressingModelOperand, 4 },
    { AddressingModelOperand, 5 },
    { AddressingModelOperand, 6 },
    { AddressingModelOperand, 7 },
    { BuiltInOperand, 8 },
    { BuiltInOperand, 9 },
    { BuiltInOperand, 10 },
    { BuiltInOperand, 11 },
    { BuiltInOperand, 12 },
    { BuiltInOperand, 13 },
    { BuiltInOperand, 14 },
    { BuiltInOperand, 15 },
    { BuiltInOperand, 16 },
    { BuiltInOperand, 17 },
    { BuiltInOperand, 18 },
    { BuiltInOperand, 19 },
    { BuiltInOperand, 20 },
    { BuiltInOperand, 21 },
    { BuiltInOperand, 22 },
    { BuiltInOperand, 23 },
    { BuiltInOperand, 24 },
    { BuiltInOperand, 25 },
    { BuiltInOperand, 26 },
    { BuiltInOperand, 27 },
    { BuiltInOperand, 28 },
    { BuiltInOperand, 29 },
    { BuiltInOperand, 30 },
    { BuiltInOperand, 31 },
    { BuiltInOperand, 32 },
    { BuiltInOperand, 33 },
    { BuiltInOperand, 34 },
    { BuiltInOperand, 35 },
    { BuiltInOperand, 36 },
    { BuiltInOperand, 37 },
    { BuiltInOperand, 38 },
    { BuiltInOperand, 39 },
    { BuiltInOperand, 40 },
    { BuiltInOperand, 41 },
    { BuiltInOperand, 42 },
    { BuiltInOperand, 43 },
    { BuiltInOperand, 44 },
    { BuiltInOperand, 45 },
    { BuiltInOperand, 46 },
    { BuiltInOperand, 47 },
    { BuiltInOperand, 48 },
    { BuiltInOperand, 49 },
    { BuiltInOperand, 50 },
    { BuiltInOperand, 51 },
    { BuiltInOperand, 52 },
    { BuiltInOperand, 53 },
    { BuiltInOperand, 54 },
    { BuiltInOperand, 55 },
    { BuiltInOperand, 56 },
    { BuiltInOperand, 57 },
    { BuiltInOperand, 58 },
    { BuiltInOperand, 59 },
    { BuiltInOperand, 60 },
    { BuiltInOperand, 61 },
    { BuiltInOperand, 62 },
    { BuiltInOperand, 63 },
    { BuiltInOperand, 64 },
    { BuiltInOperand, 65 },
    { BuiltInOperand, 66 },
    { BuiltInOperand, 67 },
    { BuiltInOperand, 68 },
    { BuiltInOperand, 69 },
    { BuiltInOperand, 70 },
    { BuiltInOperand, 71 },
    { BuiltInOperand, 72 },
    { BuiltInOperand, 73 },
    { BuiltInOperand, 74 },
    { BuiltInOperand, 75 },
    { BuiltInOperand, 76 },
    { BuiltInOperand, 77 },
    { BuiltInOperand, 78 },
    { BuiltInOperand, 79 },
    { BuiltInOperand, 80 },
    { BuiltInOperand, 81 },
    { BuiltInOperand, 82 },
    { BuiltInOperand, 83 },
    { BuiltInOperand, 84 },
    { BuiltInOperand, 85 },
    { BuiltInOperand, 86 },
    { BuiltInOperand, 87 },
    { BuiltInOperand, 88 },
    { BuiltInOperand, 89 },
    { BuiltInOperand, 90 },
    { BuiltInOperand, 91 },
    { BuiltInOperand, 92 },
    { BuiltInOperand, 93 },
    { BuiltInOperand, 94 },
    { BuiltInOperand, 95 },
    { BuiltInOperand, 96 },
    { BuiltInOperand, 97 },
    { BuiltInOperand, 98 },
    { CapabilityOperand, 99 },
    { CapabilityOperand, 100 },
    { CapabilityOperand, 101 },
    { CapabilityOperand, 102 },
    { CapabilityOperand, 103 },
    { CapabilityOperand, 104 },
    { CapabilityOperand, 105 },
    { CapabilityOperand, 106 },
    { CapabilityOperand, 107 },
    { CapabilityOperand, 108 },
    { CapabilityOperand, 109 },
    { CapabilityOperand, 110 },
    { CapabilityOperand, 111 },
    { CapabilityOperand, 112 },
    { CapabilityOperand, 113 },
    { CapabilityOperand, 114 },
    { CapabilityOperand, 115 },
    { CapabilityOperand, 116 },
    { CapabilityOperand, 117 },
    { CapabilityOperand, 118 },
    { CapabilityOperand, 119 },
    { CapabilityOperand, 120 },
    { CapabilityOperand, 121 },
    { CapabilityOperand, 122 },
    { CapabilityOperand, 123 },
    { CapabilityOperand, 124 },
    { CapabilityOperand, 125 },
    { CapabilityOperand, 126 },
    { CapabilityOperand, 127 },
    { CapabilityOperand, 128 },
    { CapabilityOperand, 129 },
    { CapabilityOperand, 130 },
    { CapabilityOperand, 131 },
    { CapabilityOperand, 132 },
    { CapabilityOperand, 133 },
    { CapabilityOperand, 134 },
    { CapabilityOperand, 135 },
    { CapabilityOperand, 136 },
    { CapabilityOperand, 137 },
    { CapabilityOperand, 138 },
    { CapabilityOperand, 139 },
    { CapabilityOperand, 140 },
    { CapabilityOperand, 141 },
    { CapabilityOperand, 142 },
    { CapabilityOperand, 143 },
    { CapabilityOperand, 144 },
    { CapabilityOperand, 145 },
    { CapabilityOperand, 146 },
    { CapabilityOperand, 147 },
    { CapabilityOperand, 148 },
    { CapabilityOperand, 149 },
    { CapabilityOperand, 150 },
    { CapabilityOperand, 151 },
    { CapabilityOperand, 152 },
    { CapabilityOperand, 153 },
    { CapabilityOperand, 154 },
    { CapabilityOperand, 155 },
    { CapabilityOperand, 156 },
    { CapabilityOperand, 157 },
    { CapabilityOperand, 158 },
    { CapabilityOperand, 159 },
    { CapabilityOperand, 160 },
    { CapabilityOperand, 161 },
    { CapabilityOperand, 162 },
    { CapabilityOperand, 163 },
    { CapabilityOperand, 164 },
    { CapabilityOperand, 165 },
    { CapabilityOperand, 166 },
    { CapabilityOperand, 167 },
    { CapabilityOperand, 168 },
    { CapabilityOperand, 169 },
    { CapabilityOperand, 170 },
    { CapabilityOperand, 171 },
    { CapabilityOperand, 172 },
    { CapabilityOperand, 173 },
    { CapabilityOperand, 174 },
    { CapabilityOperand, 175 },
    { CapabilityOperand, 176 },
    { CapabilityOperand, 177 },
    { CapabilityOperand, 178 },
    { CapabilityOperand, 179 },
    { CapabilityOperand, 180 },
    { CapabilityOperand, 181 },
    { CapabilityOperand, 182 },
    { CapabilityOperand, 183 },
    { CapabilityOperand, 184 },
    { CapabilityOperand, 185 },
    { CapabilityOperand, 186 },
    { CapabilityOperand, 187 },
    { CapabilityOperand, 188 },
    { CapabilityOperand, 189 },
    { CapabilityOperand, 190 },
    { CapabilityOperand, 191 },
    { CapabilityOperand, 192 },
    { CapabilityOperand, 193 },
    { CapabilityOperand, 194 },
    { CapabilityOperand, 195 },
    { CapabilityOperand, 196 },
    { CapabilityOperand, 197 },
    { CapabilityOperand, 198 },
    { CapabilityOperand, 199 },
    { CapabilityOperand, 200 },
    { CapabilityOperand, 201 },
    { CapabilityOperand, 202 },
    { CapabilityOperand, 203 },
    { CapabilityOperand, 204 },
    { CapabilityOperand, 205 },
    { CapabilityOperand, 206 },
    { CapabilityOperand, 207 },
    { CapabilityOperand, 208 },
    { CapabilityOperand, 209 },
    { CapabilityOperand, 210 },
    { CapabilityOperand, 211 },
    { CapabilityOperand, 212 },
    { CapabilityOperand, 213 },
    { CapabilityOperand, 214 },
    { CapabilityOperand, 215 },
    { CapabilityOperand, 216 },
    { CapabilityOperand, 217 },
    { CapabilityOperand, 218 },
    { CapabilityOperand, 219 },
    { CapabilityOperand, 220 },
    { CapabilityOperand, 221 },
    { CapabilityOperand, 222 },
    { CapabilityOperand, 223 },
    { CapabilityOperand, 224 },
    { CapabilityOperand, 225 },
    { CapabilityOperand, 226 },
    { CapabilityOperand, 227 },
    { CapabilityOperand, 228 },
    { CapabilityOperand, 229 },
    { CapabilityOperand, 230 },
    { CapabilityOperand, 231 },
    { CapabilityOperand, 232 },
    { CapabilityOperand, 233 },
    { CapabilityOperand, 234 },
    { CapabilityOperand, 235 },
    { CapabilityOperand, 236 },
    { CapabilityOperand, 237 },
    { CapabilityOperand, 238 },
    { CapabilityOperand, 239 },
    { CapabilityOperand, 240 },
    { CapabilityOperand, 241 },
    { CapabilityOperand, 242 },
    { CapabilityOperand, 243 },
    { CapabilityOperand, 244 },
    { CapabilityOperand, 245 },
    { CapabilityOperand, 246 },
    { CapabilityOperand, 247 },
    { CapabilityOperand, 248 },
    { CapabilityOperand, 249 },
    { CapabilityOperand, 250 },
    { CapabilityOperand, 251 },
    { CapabilityOperand, 252 },
    { CapabilityOperand, 253 },
    { CapabilityOperand, 254 },
    { CapabilityOperand, 255 },
    { CapabilityOperand, 256 },
    { CapabilityOperand, 257 },
    { CapabilityOperand, 258 },
    { CapabilityOperand, 259 },
    { CapabilityOperand, 260 },
    { CapabilityOperand, 261 },
    { CapabilityOperand, 262 },
    { CapabilityOperand, 263 },
    { CapabilityOperand, 264 },
    { CapabilityOperand, 265 },
    { CapabilityOperand, 266 },
    { CapabilityOperand, 267 },
    { CapabilityOperand, 268 },
    { CapabilityOperand, 269 },
    { CapabilityOperand, 270 },
    { CooperativeMatrixLayoutOperand, 271 },
    { CooperativeMatrixLayoutOperand, 272 },
    { CooperativeMatrixLayoutOperand, 273 },
    { CooperativeMatrixOperandsOperand, 274 },
    { CooperativeMatrixOperandsOperand, 275 },
    { CooperativeMatrixOperandsOperand, 276 },
    { CooperativeMatrixOperandsOperand, 277 },
    { CooperativeMatrixOperandsOperand, 278 },
    { CooperativeMatrixOperandsOperand, 279 },
    { CooperativeMatrixOperandsOperand, 280 },
    { CooperativeMatrixOperandsOperand, 281 },
    { CooperativeMatrixOperandsOperand, 282 },
    { CooperativeMatrixOperandsOperand, 283 },
    { DecorationOperand, 284 },
    { DecorationOperand, 285 },
    { DecorationOperand, 286 },
    { DecorationOperand, 287 },
    { DecorationOperand, 288 },
    { DecorationOperand, 289 },
    { DecorationOperand, 290 },
    { DecorationOperand, 291 },
    { DecorationOperand, 292 },
    { DecorationOperand, 293 },
    { DecorationOperand, 294 },
    { DecorationOperand, 295 },
    { DecorationOperand, 296 },
    { DecorationOperand, 297 },
    { DecorationOperand, 298 },
    { DecorationOperand, 299 },
    { DecorationOperand, 300 },
    { DecorationOperand, 301 },
    { DecorationOperand, 302 },
    { DecorationOperand, 303 },
    { DecorationOperand, 304 },
    { DecorationOperand, 305 },
    { DecorationOperand, 306 },
    { DecorationOperand, 307 },
    { DecorationOperand, 308 },
    { DecorationOperand, 309 },
    { DecorationOperand, 310 },
    { DecorationOperand, 311 },
    { DecorationOperand, 312 },
    { DecorationOperand, 313 },
    { DecorationOperand, 314 },
    { DecorationOperand, 315 },
    { DecorationOperand, 316 },
    { DecorationOperand, 317 },
    { DecorationOperand, 318 },
    { DecorationOperand, 319 },
    { DecorationOperand, 320 },
    { DecorationOperand, 321 },
    { DecorationOperand, 322 },
    { DecorationOperand, 323 },
    { DecorationOperand, 324 },
    { DecorationOperand, 325 },
    { DecorationOperand, 326 },
    { DecorationOperand, 327 },
    { DecorationOperand, 328 },
    { DecorationOperand, 329 },
    { DecorationOperand, 330 },
    { DecorationOperand, 331 },
    { DecorationOperand, 332 },
    { DecorationOperand, 333 },
    { DecorationOperand, 334 },
    { DecorationOperand, 335 },
    { DecorationOperand, 336 },
    { DecorationOperand, 337 },
    { DecorationOperand, 338 },
    { DecorationOperand, 339 },
    { DecorationOperand, 340 },
    { DecorationOperand, 341 },
    { DecorationOperand, 342 },
    { DecorationOperand, 343 },
    { DecorationOperand, 344 },
    { DecorationOperand, 345 },
    { DecorationOperand, 346 },
    { DecorationOperand, 347 },
    { DecorationOperand, 348 },
    { DecorationOperand, 349 },
    { DecorationOperand, 350 },
    { DecorationOperand, 351 },
    { DecorationOperand, 352 },
    { DecorationOperand, 353 },
    { DecorationOperand, 354 },
    { DecorationOperand, 355 },
    { DecorationOperand, 356 },
    { DecorationOperand, 357 },
    { DimOperand, 358 },
    { DimOperand, 359 },
    { DimOperand, 360 },
    { DimOperand, 361 },
    { DimOperand, 362 },
    { DimOperand, 363 },
    { DimOperand, 364 },
    { ExecutionModeOperand, 365 },
    { ExecutionModeOperand, 366 },
    { ExecutionModeOperand, 367 },
    { ExecutionModeOperand, 368 },
    { ExecutionModeOperand, 369 },
    { ExecutionModeOperand, 370 },
    { ExecutionModeOperand, 371 },
    { ExecutionModeOperand, 372 },
    { ExecutionModeOperand, 373 },
    { ExecutionModeOperand, 374 },
    { ExecutionModeOperand, 375 },
    { ExecutionModeOperand, 376 },
    { ExecutionModeOperand, 377 },
    { ExecutionModeOperand, 378 },
    { ExecutionModeOperand, 379 },
    { ExecutionModeOperand, 380 },
    { ExecutionModeOperand, 381 },
    { ExecutionModeOperand, 382 },
    { ExecutionModeOperand, 383 },
    { ExecutionModeOperand, 384 },
    { ExecutionModeOperand, 385 },
    { ExecutionModeOperand, 386 },
    { ExecutionModeOperand, 387 },
    { ExecutionModeOperand, 388 },
    { ExecutionModeOperand, 389 },
    { ExecutionModeOperand, 390 },
    { ExecutionModeOperand, 391 },
    { ExecutionModeOperand, 392 },
    { ExecutionModeOperand, 393 },
    { ExecutionModeOperand, 394 },
    { ExecutionModeOperand, 395 },
    { ExecutionModeOperand, 396 },
    { ExecutionModeOperand, 397 },
    { ExecutionModeOperand, 398 },
    { ExecutionModeOperand, 399 },
    { ExecutionModeOperand, 400 },
    { ExecutionModeOperand, 401 },
    { ExecutionModeOperand, 402 },
    { ExecutionModeOperand, 403 },
    { ExecutionModeOperand, 404 },
    { ExecutionModeOperand, 405 },
    { ExecutionModeOperand, 406 },
    { ExecutionModeOperand, 407 },
    { ExecutionModeOperand, 408 },
    { ExecutionModeOperand, 409 },
    { ExecutionModeOperand, 410 },
    { ExecutionModeOperand, 411 },
    { ExecutionModeOperand, 412 },
    { ExecutionModeOperand, 413 },
    { ExecutionModeOperand, 414 },
    { ExecutionModeOperand, 415 },
    { ExecutionModeOperand, 416 },
    { ExecutionModeOperand, 417 },
    { ExecutionModelOperand, 418 },
    { ExecutionModelOperand, 419 },
    { ExecutionModelOperand, 420 },
    { ExecutionModelOperand, 421 },
    { ExecutionModelOperand, 422 },
    { ExecutionModelOperand, 423 },
    { ExecutionModelOperand, 424 },
    { ExecutionModelOperand, 425 },
    { ExecutionModelOperand, 426 },
    { ExecutionModelOperand, 427 },
    { ExecutionModelOperand, 428 },
    { ExecutionModelOperand, 429 },
    { ExecutionModelOperand, 430 },
    { ExecutionModelOperand, 431 },
    { ExecutionModelOperand, 432 },
    { ExtensionOperand, 433 },
    { ExtensionOperand, 434 },
    { ExtensionOperand, 435 },
    { ExtensionOperand, 436 },
    { ExtensionOperand, 437 },
    { ExtensionOperand, 438 },
    { ExtensionOperand, 439 },
    { ExtensionOperand, 440 },
    { ExtensionOperand, 441 },
    { ExtensionOperand, 442 },
    { ExtensionOperand, 443 },
    { ExtensionOperand, 444 },
    { ExtensionOperand, 445 },
    { ExtensionOperand, 446 },
    { ExtensionOperand, 447 },
    { ExtensionOperand, 448 },
    { ExtensionOperand, 449 },
    { ExtensionOperand, 450 },
    { ExtensionOperand, 451 },
    { ExtensionOperand, 452 },
    { ExtensionOperand, 453 },
    { ExtensionOperand, 454 },
    { ExtensionOperand, 455 },
    { ExtensionOperand, 456 },
    { ExtensionOperand, 457 },
    { ExtensionOperand, 458 },
    { ExtensionOperand, 459 },
    { ExtensionOperand, 460 },
    { ExtensionOperand, 461 },
    { ExtensionOperand, 462 },
    { ExtensionOperand, 463 },
    { ExtensionOperand, 464 },
    { ExtensionOperand, 465 },
    { ExtensionOperand, 466 },
    { ExtensionOperand, 467 },
    { ExtensionOperand, 468 },
    { ExtensionOperand, 469 },
    { ExtensionOperand, 470 },
    { ExtensionOperand, 471 },
    { ExtensionOperand, 472 },
    { ExtensionOperand, 473 },
    { ExtensionOperand, 474 },
    { ExtensionOperand, 475 },
    { ExtensionOperand, 476 },
    { ExtensionOperand, 477 },
    { ExtensionOperand, 478 },
    { ExtensionOperand, 479 },
    { ExtensionOperand, 480 },
    { ExtensionOperand, 481 },
    { ExtensionOperand, 482 },
    { ExtensionOperand, 483 },
    { ExtensionOperand, 484 },
    { ExtensionOperand, 485 },
    { ExtensionOperand, 486 },
    { ExtensionOperand, 487 },
    { ExtensionOperand, 488 },
    { ExtensionOperand, 489 },
    { ExtensionOperand, 490 },
    { ExtensionOperand, 491 },
    { ExtensionOperand, 492 },
    { ExtensionOperand, 493 },
    { ExtensionOperand, 494 },
    { ExtensionOperand, 495 },
    { ExtensionOperand, 496 },
    { ExtensionOperand, 497 },
    { ExtensionOperand, 498 },
    { ExtensionOperand, 499 },
    { ExtensionOperand, 500 },
    { ExtensionOperand, 501 },
    { ExtensionOperand, 502 },
    { ExtensionOperand, 503 },
    { ExtensionOperand, 504 },
    { ExtensionOperand, 505 },
    { ExtensionOperand, 506 },
    { ExtensionOperand, 507 },
    { ExtensionOperand, 508 },
    { ExtensionOperand, 509 },
    { ExtensionOperand, 510 },
    { ExtensionOperand, 511 },
    { ExtensionOperand, 512 },
    { ExtensionOperand, 513 },
    { ExtensionOperand, 514 },
    { ExtensionOperand, 515 },
    { ExtensionOperand, 516 },
    { ExtensionOperand, 517 },
    { ExtensionOperand, 518 },
    { ExtensionOperand, 519 },
    { ExtensionOperand, 520 },
    { ExtensionOperand, 521 },
    { ExtensionOperand, 522 },
    { ExtensionOperand, 523 },
    { ExtensionOperand, 524 },
    { ExtensionOperand, 525 },
    { ExtensionOperand, 526 },
    { ExtensionOperand, 527 },
    { ExtensionOperand, 528 },
    { ExtensionOperand, 529 },
    { ExtensionOperand, 530 },
    { ExtensionOperand, 531 },
    { ExtensionOperand, 532 },
    { ExtensionOperand, 533 },
    { ExtensionOperand, 534 },
    { ExtensionOperand, 535 },
    { ExtensionOperand, 536 },
    { ExtensionOperand, 537 },
    { ExtensionOperand, 538 },
    { ExtensionOperand, 539 },
    { ExtensionOperand, 540 },
    { ExtensionOperand, 541 },
    { ExtensionOperand, 542 },
    { ExtensionOperand, 543 },
    { ExtensionOperand, 544 },
    { ExtensionOperand, 545 },
    { ExtensionOperand, 546 },
    { FPFastMathModeOperand, 547 },
    { FPFastMathModeOperand, 548 },
    { FPFastMathModeOperand, 549 },
    { FPFastMathModeOperand, 550 },
    { FPFastMathModeOperand, 551 },
    { FPFastMathModeOperand, 552 },
    { FPRoundingModeOperand, 553 },
    { FPRoundingModeOperand, 554 },
    { FPRoundingModeOperand, 555 },
    { FPRoundingModeOperand, 556 },
    { FunctionControlOperand, 557 },
    { FunctionControlOperand, 558 },
    { FunctionControlOperand, 559 },
    { FunctionControlOperand, 560 },
    { FunctionControlOperand, 561 },
    { FunctionControlOperand, 562 },
    { FunctionParameterAttributeOperand, 563 },
    { FunctionParameterAttributeOperand, 564 },
    { FunctionParameterAttributeOperand, 565 },
    { FunctionParameterAttributeOperand, 566 },
    { FunctionParameterAttributeOperand, 567 },
    { FunctionParameterAttributeOperand, 568 },
    { FunctionParameterAttributeOperand, 569 },
    { FunctionParameterAttributeOperand, 570 },
    { GroupOperationOperand, 571 },
    { GroupOperationOperand, 572 },
    { GroupOperationOperand, 573 },
    { GroupOperationOperand, 574 },
    { GroupOperationOperand, 575 },
    { GroupOperationOperand, 576 },
    { GroupOperationOperand, 577 },
    { ImageChannelDataTypeOperand, 578 },
    { ImageChannelDataTypeOperand, 579 },
    { ImageChannelDataTypeOperand, 580 },
    { ImageChannelDataTypeOperand, 581 },
    { ImageChannelDataTypeOperand, 582 },
    { ImageChannelDataTypeOperand, 583 },
    { ImageChannelDataTypeOperand, 584 },
    { ImageChannelDataTypeOperand, 585 },
    { ImageChannelDataTypeOperand, 586 },
    { ImageChannelDataTypeOperand, 587 },
    { ImageChannelDataTypeOperand, 588 },
    { ImageChannelDataTypeOperand, 589 },
    { ImageChannelDataTypeOperand, 590 },
    { ImageChannelDataTypeOperand, 591 },
    { ImageChannelDataTypeOperand, 592 },
    { ImageChannelDataTypeOperand, 593 },
    { ImageChannelDataTypeOperand, 594 },
    { ImageChannelOrderOperand, 595 },
    { ImageChannelOrderOperand, 596 },
    { ImageChannelOrderOperand, 597 },
    { ImageChannelOrderOperand, 598 },
    { ImageChannelOrderOperand, 599 },
    { ImageChannelOrderOperand, 600 },
    { ImageChannelOrderOperand, 601 },
    { ImageChannelOrderOperand, 602 },
    { ImageChannelOrderOperand, 603 },
    { ImageChannelOrderOperand, 604 },
    { ImageChannelOrderOperand, 605 },
    { ImageChannelOrderOperand, 606 },
    { ImageChannelOrderOperand, 607 },
    { ImageChannelOrderOperand, 608 },
    { ImageChannelOrderOperand, 609 },
    { ImageChannelOrderOperand, 610 },
    { ImageChannelOrderOperand, 611 },
    { ImageChannelOrderOperand, 612 },
    { ImageChannelOrderOperand, 613 },
    { ImageChannelOrderOperand, 614 },
    { ImageFormatOperand, 615 },
    { ImageFormatOperand, 616 },
    { ImageFormatOperand, 617 },
    { ImageFormatOperand, 618 },
    { ImageFormatOperand, 619 },
    { ImageFormatOperand, 620 },
    { ImageFormatOperand, 621 },
    { ImageFormatOperand, 622 },
    { ImageFormatOperand, 623 },
    { ImageFormatOperand, 624 },
    { ImageFormatOperand, 625 },
    { ImageFormatOperand, 626 },
    { ImageFormatOperand, 627 },
    { ImageFormatOperand, 628 },
    { ImageFormatOperand, 629 },
    { ImageFormatOperand, 630 },
    { ImageFormatOperand, 631 },
    { ImageFormatOperand, 632 },
    { ImageFormatOperand, 633 },
    { ImageFormatOperand, 634 },
    { ImageFormatOperand, 635 },
    { ImageFormatOperand, 636 },
    { ImageFormatOperand, 637 },
    { ImageFormatOperand, 638 },
    { ImageFormatOperand, 639 },
    { ImageFormatOperand, 640 },
    { ImageFormatOperand, 641 },
    { ImageFormatOperand, 642 },
    { ImageFormatOperand, 643 },
    { ImageFormatOperand, 644 },
    { ImageFormatOperand, 645 },
    { ImageFormatOperand, 646 },
    { ImageFormatOperand, 647 },
    { ImageFormatOperand, 648 },
    { ImageFormatOperand, 649 },
    { ImageFormatOperand, 650 },
    { ImageFormatOperand, 651 },
    { ImageFormatOperand, 652 },
    { ImageFormatOperand, 653 },
    { ImageFormatOperand, 654 },
    { ImageOperandOperand, 655 },
    { ImageOperandOperand, 656 },
    { ImageOperandOperand, 657 },
    { ImageOperandOperand, 658 },
    { ImageOperandOperand, 659 },
    { ImageOperandOperand, 660 },
    { ImageOperandOperand, 661 },
    { ImageOperandOperand, 662 },
    { ImageOperandOperand, 663 },
    { ImageOperandOperand, 664 },
    { ImageOperandOperand, 665 },
    { ImageOperandOperand, 666 },
    { ImageOperandOperand, 667 },
    { ImageOperandOperand, 668 },
    { ImageOperandOperand, 669 },
    { KernelEnqueueFlagsOperand, 670 },
    { KernelEnqueueFlagsOperand, 671 },
    { KernelEnqueueFlagsOperand, 672 },
    { KernelProfilingInfoOperand, 673 },
    { KernelProfilingInfoOperand, 674 },
    { LinkageTypeOperand, 675 },
    { LinkageTypeOperand, 676 },
    { LinkageTypeOperand, 677 },
    { LoopControlOperand, 678 },
    { LoopControlOperand, 679 },
    { LoopControlOperand, 680 },
    { LoopControlOperand, 681 },
    { LoopControlOperand, 682 },
    { LoopControlOperand, 683 },
    { LoopControlOperand, 684 },
    { LoopControlOperand, 685 },
    { LoopControlOperand, 686 },
    { LoopControlOperand, 687 },
    { MemoryModelOperand, 688 },
    { MemoryModelOperand, 689 },
    { MemoryModelOperand, 690 },
    { MemoryModelOperand, 691 },
    { MemoryOperandOperand, 692 },
    { MemoryOperandOperand, 693 },
    { MemoryOperandOperand, 694 },
    { MemoryOperandOperand, 695 },
    { MemoryOperandOperand, 696 },
    { MemoryOperandOperand, 697 },
    { MemoryOperandOperand, 698 },
    { MemorySemanticsOperand, 699 },
    { MemorySemanticsOperand, 700 },
    { MemorySemanticsOperand, 701 },
    { MemorySemanticsOperand, 702 },
    { MemorySemanticsOperand, 703 },
    { MemorySemanticsOperand, 704 },
    { MemorySemanticsOperand, 705 },
    { MemorySemanticsOperand, 706 },
    { MemorySemanticsOperand, 707 },
    { MemorySemanticsOperand, 708 },
    { MemorySemanticsOperand, 709 },
    { MemorySemanticsOperand, 710 },
    { MemorySemanticsOperand, 711 },
    { MemorySemanticsOperand, 712 },
    { OpcodeOperand, 713 },
    { OpcodeOperand, 714 },
    { OpcodeOperand, 715 },
    { OpcodeOperand, 716 },
    { OpcodeOperand, 717 },
    { OpcodeOperand, 718 },
    { OpcodeOperand, 719 },
    { SamplerAddressingModeOperand, 720 },
    { SamplerAddressingModeOperand, 721 },
    { SamplerAddressingModeOperand, 722 },
    { SamplerAddressingModeOperand, 723 },
    { SamplerAddressingModeOperand, 724 },
    { SamplerFilterModeOperand, 725 },
    { SamplerFilterModeOperand, 726 },
    { ScopeOperand, 727 },
    { ScopeOperand, 728 },
    { ScopeOperand, 729 },
    { ScopeOperand, 730 },
    { ScopeOperand, 731 },
    { ScopeOperand, 732 },
    { SelectionControlOperand, 733 },
    { SelectionControlOperand, 734 },
    { SelectionControlOperand, 735 },
    { SourceLanguageOperand, 736 },
    { SourceLanguageOperand, 737 },
    { SourceLanguageOperand, 738 },
    { SourceLanguageOperand, 739 },
    { SourceLanguageOperand, 740 },
    { SourceLanguageOperand, 741 },
    { StorageClassOperand, 742 },
    { StorageClassOperand, 743 },
    { StorageClassOperand, 744 },
    { StorageClassOperand, 745 },
    { StorageClassOperand, 746 },
    { StorageClassOperand, 747 },
    { StorageClassOperand, 748 },
    { StorageClassOperand, 749 },
    { StorageClassOperand, 750 },
    { StorageClassOperand, 751 },
    { StorageClassOperand, 752 },
    { StorageClassOperand, 753 },
    { StorageClassOperand, 754 },
    { StorageClassOperand, 755 },
    { StorageClassOperand, 756 },
    { StorageClassOperand, 757 },
    { StorageClassOperand, 758 },
    { StorageClassOperand, 759 },
    { StorageClassOperand, 760 },
    { StorageClassOperand, 761 },
    { StorageClassOperand, 762 },
    { StorageClassOperand, 763 },
    { StorageClassOperand, 764 },
  };

  struct KeyType {
    unsigned Category;
  };
  KeyType Key = {Category};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Category < (unsigned)RHS.Category)
        return true;
      if ((unsigned)LHS.Category > (unsigned)RHS.Category)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Category != Idx->Category)
    return nullptr;

  return &SymbolicOperands[Idx->_index];
}

const SymbolicOperand *lookupSymbolicOperandByCategoryAndMnemonic(unsigned Category, StringRef Mnemonic) {
  struct IndexType {
    unsigned Category;
    const char * Mnemonic;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { AccessQualifierOperand, "NONE", 3 },
    { AccessQualifierOperand, "READONLY", 0 },
    { AccessQualifierOperand, "READWRITE", 2 },
    { AccessQualifierOperand, "WRITEONLY", 1 },
    { AddressingModelOperand, "LOGICAL", 4 },
    { AddressingModelOperand, "PHYSICAL32", 5 },
    { AddressingModelOperand, "PHYSICAL64", 6 },
    { AddressingModelOperand, "PHYSICALSTORAGEBUFFER64EXT", 7 },
    { BuiltInOperand, "BARYCOORDNOPERSPAMD", 59 },
    { BuiltInOperand, "BARYCOORDNOPERSPCENTROIDAMD", 60 },
    { BuiltInOperand, "BARYCOORDNOPERSPNV", 82 },
    { BuiltInOperand, "BARYCOORDNOPERSPSAMPLEAMD", 61 },
    { BuiltInOperand, "BARYCOORDNV", 81 },
    { BuiltInOperand, "BARYCOORDPULLMODEL", 65 },
    { BuiltInOperand, "BARYCOORDSMOOTHAMD", 62 },
    { BuiltInOperand, "BARYCOORDSMOOTHCENTROID", 63 },
    { BuiltInOperand, "BARYCOORDSMOOTHSAMPLE", 64 },
    { BuiltInOperand, "BASEINSTANCE", 55 },
    { BuiltInOperand, "BASEVERTEX", 54 },
    { BuiltInOperand, "CLIPDISTANCEPERVIEWNV", 76 },
    { BuiltInOperand, "CLIPDISTANCEVARIABLE", 10 },
    { BuiltInOperand, "CULLDISTANCEPERVIEWNV", 77 },
    { BuiltInOperand, "CULLDISTANCEVARIABLE", 11 },
    { BuiltInOperand, "DEVICEINDEX", 57 },
    { BuiltInOperand, "DRAWINDEX", 56 },
    { BuiltInOperand, "ENQUEUEDWORKGROUPSIZE", 38 },
    { BuiltInOperand, "FRAGCOORD", 22 },
    { BuiltInOperand, "FRAGDEPTH", 28 },
    { BuiltInOperand, "FRAGINVOCATIONCOUNTEXT", 84 },
    { BuiltInOperand, "FRAGSIZEEXT", 83 },
    { BuiltInOperand, "FRAGSTENCILREFEXT", 66 },
    { BuiltInOperand, "FRONTFACING", 24 },
    { BuiltInOperand, "FULLYCOVEREDEXT", 72 },
    { BuiltInOperand, "GLOBALINVOCATIONID", 34 },
    { BuiltInOperand, "GLOBALLINEARID", 40 },
    { BuiltInOperand, "GLOBALOFFSET", 39 },
    { BuiltInOperand, "GLOBALSIZE", 37 },
    { BuiltInOperand, "HELPERINVOCATION", 29 },
    { BuiltInOperand, "HITKINDNV", 97 },
    { BuiltInOperand, "HITTNV", 96 },
    { BuiltInOperand, "INCOMINGRAYFLAGSNV", 98 },
    { BuiltInOperand, "INSTANCECUSTOMINDEXNV", 93 },
    { BuiltInOperand, "INSTANCEID", 13 },
    { BuiltInOperand, "INSTANCEINDEX", 48 },
    { BuiltInOperand, "INVOCATIONID", 15 },
    { BuiltInOperand, "LAUNCHIDNV", 85 },
    { BuiltInOperand, "LAUNCHSIZENV", 86 },
    { BuiltInOperand, "LAYER", 16 },
    { BuiltInOperand, "LAYERPERVIEWNV", 78 },
    { BuiltInOperand, "LOCALINVOCATIONID", 33 },
    { BuiltInOperand, "LOCALINVOCATIONINDEX", 35 },
    { BuiltInOperand, "MESHVIEWCOUNTNV", 79 },
    { BuiltInOperand, "MESHVIEWINDICES", 80 },
    { BuiltInOperand, "NUMENQUEUEDSUBGROUPS", 44 },
    { BuiltInOperand, "NUMSUBGROUPS", 43 },
    { BuiltInOperand, "NUMWORKGROUPS", 30 },
    { BuiltInOperand, "OBJECTRAYDIRECTIONNV", 90 },
    { BuiltInOperand, "OBJECTRAYORIGINNV", 89 },
    { BuiltInOperand, "OBJECTTOWORLDNV", 94 },
    { BuiltInOperand, "PATCHVERTICES", 21 },
    { BuiltInOperand, "POINTCOORD", 23 },
    { BuiltInOperand, "POINTSIZE", 9 },
    { BuiltInOperand, "POSITION", 8 },
    { BuiltInOperand, "POSITIONPERVIEWNV", 70 },
    { BuiltInOperand, "PRIMITIVECOUNTNV", 74 },
    { BuiltInOperand, "PRIMITIVEID", 14 },
    { BuiltInOperand, "PRIMITIVEINDICESNV", 75 },
    { BuiltInOperand, "RAYTMAXNV", 92 },
    { BuiltInOperand, "RAYTMINNV", 91 },
    { BuiltInOperand, "SAMPLEID", 25 },
    { BuiltInOperand, "SAMPLEMASK", 27 },
    { BuiltInOperand, "SAMPLEPOSITION", 26 },
    { BuiltInOperand, "SECONDARYPOSITIONNV", 68 },
    { BuiltInOperand, "SECONDARYVIEWPORTMASKNV", 69 },
    { BuiltInOperand, "SUBGROUPEQMASK", 49 },
    { BuiltInOperand, "SUBGROUPGEMASK", 50 },
    { BuiltInOperand, "SUBGROUPGTMASK", 51 },
    { BuiltInOperand, "SUBGROUPID", 45 },
    { BuiltInOperand, "SUBGROUPLEMASK", 52 },
    { BuiltInOperand, "SUBGROUPLOCALINVOCATIONID", 46 },
    { BuiltInOperand, "SUBGROUPLTMASK", 53 },
    { BuiltInOperand, "SUBGROUPMAXSIZE", 42 },
    { BuiltInOperand, "SUBGROUPSIZE", 41 },
    { BuiltInOperand, "TASKCOUNTNV", 73 },
    { BuiltInOperand, "TESSCOORD", 20 },
    { BuiltInOperand, "TESSLEVELINNER", 19 },
    { BuiltInOperand, "TESSLEVELOUTER", 18 },
    { BuiltInOperand, "VERTEXID", 12 },
    { BuiltInOperand, "VERTEXINDEX", 47 },
    { BuiltInOperand, "VIEWINDEX", 58 },
    { BuiltInOperand, "VIEWPORTINDEX", 17 },
    { BuiltInOperand, "VIEWPORTMASKNV", 67 },
    { BuiltInOperand, "VIEWPORTMASKPERVIEWNV", 71 },
    { BuiltInOperand, "WORKDIM", 36 },
    { BuiltInOperand, "WORKGROUPID", 32 },
    { BuiltInOperand, "WORKGROUPSIZE", 31 },
    { BuiltInOperand, "WORLDRAYDIRECTIONNV", 88 },
    { BuiltInOperand, "WORLDRAYORIGINNV", 87 },
    { BuiltInOperand, "WORLDTOOBJECTNV", 95 },
    { CapabilityOperand, "ADDRESSES", 103 },
    { CapabilityOperand, "ARBITRARYPRECISIONINTEGERSINTEL", 243 },
    { CapabilityOperand, "ARITHMETICFENCEEXT", 259 },
    { CapabilityOperand, "ASMINTEL", 233 },
    { CapabilityOperand, "ATOMICFLOAT16ADDEXT", 256 },
    { CapabilityOperand, "ATOMICFLOAT16MINMAXEXT", 236 },
    { CapabilityOperand, "ATOMICFLOAT32ADDEXT", 252 },
    { CapabilityOperand, "ATOMICFLOAT32MINMAXEXT", 234 },
    { CapabilityOperand, "ATOMICFLOAT64ADDEXT", 253 },
    { CapabilityOperand, "ATOMICFLOAT64MINMAXEXT", 235 },
    { CapabilityOperand, "ATOMICSTORAGE", 119 },
    { CapabilityOperand, "ATOMICSTORAGEOPS", 177 },
    { CapabilityOperand, "BFLOAT16CONVERSIONINTEL", 257 },
    { CapabilityOperand, "BITINSTRUCTIONS", 250 },
    { CapabilityOperand, "CACHECONTROLSINTEL", 270 },
    { CapabilityOperand, "CLIPDISTANCE", 129 },
    { CapabilityOperand, "COMPUTEDERIVATIVEGROUPLINEARNV", 222 },
    { CapabilityOperand, "COMPUTEDERIVATIVEGROUPQUADSNV", 203 },
    { CapabilityOperand, "COOPERATIVEMATRIXBFLOAT16COMPONENTTYPEINTEL", 269 },
    { CapabilityOperand, "COOPERATIVEMATRIXCHECKEDINSTRUCTIONSINTEL", 263 },
    { CapabilityOperand, "COOPERATIVEMATRIXINVOCATIONINSTRUCTIONSINTEL", 267 },
    { CapabilityOperand, "COOPERATIVEMATRIXKHR", 249 },
    { CapabilityOperand, "COOPERATIVEMATRIXNV", 223 },
    { CapabilityOperand, "COOPERATIVEMATRIXPREFETCHINTEL", 265 },
    { CapabilityOperand, "COOPERATIVEMATRIXTF32COMPONENTTYPEINTEL", 268 },
    { CapabilityOperand, "CULLDISTANCE", 130 },
    { CapabilityOperand, "DEMOTETOHELPERINVOCATION", 224 },
    { CapabilityOperand, "DENORMFLUSHTOZERO", 183 },
    { CapabilityOperand, "DENORMPRESERVE", 182 },
    { CapabilityOperand, "DERIVATIVECONTROL", 148 },
    { CapabilityOperand, "DEVICEENQUEUE", 117 },
    { CapabilityOperand, "DEVICEGROUP", 173 },
    { CapabilityOperand, "DOTPRODUCT", 248 },
    { CapabilityOperand, "DOTPRODUCTINPUT4X8BIT", 246 },
    { CapabilityOperand, "DOTPRODUCTINPUT4X8BITPACKED", 247 },
    { CapabilityOperand, "DOTPRODUCTINPUTALL", 245 },
    { CapabilityOperand, "DRAWPARAMETERS", 167 },
    { CapabilityOperand, "EXPECTASSUMEKHR", 237 },
    { CapabilityOperand, "FLOAT16", 108 },
    { CapabilityOperand, "FLOAT16BUFFER", 107 },
    { CapabilityOperand, "FLOAT16IMAGEAMD", 187 },
    { CapabilityOperand, "FLOAT64", 109 },
    { CapabilityOperand, "FLOATINGPOINTMODEINTEL", 230 },
    { CapabilityOperand, "FRAGMENTBARYCENTRICNV", 202 },
    { CapabilityOperand, "FRAGMENTDENSITYEXT", 204 },
    { CapabilityOperand, "FRAGMENTFULLYCOVEREDEXT", 199 },
    { CapabilityOperand, "FRAGMENTMASKAMD", 189 },
    { CapabilityOperand, "FUNCTIONFLOATCONTROLINTEL", 242 },
    { CapabilityOperand, "FUNCTIONPOINTERSINTEL", 231 },
    { CapabilityOperand, "GENERICPOINTER", 135 },
    { CapabilityOperand, "GEOMETRY", 101 },
    { CapabilityOperand, "GEOMETRYPOINTSIZE", 122 },
    { CapabilityOperand, "GEOMETRYSHADERPASSTHROUGHNV", 194 },
    { CapabilityOperand, "GEOMETRYSTREAMS", 151 },
    { CapabilityOperand, "GLOBALVARIABLEFPGADECORATIONSINTEL", 262 },
    { CapabilityOperand, "GLOBALVARIABLEHOSTACCESSINTEL", 260 },
    { CapabilityOperand, "GROUPNONUNIFORM", 158 },
    { CapabilityOperand, "GROUPNONUNIFORMARITHMETIC", 160 },
    { CapabilityOperand, "GROUPNONUNIFORMBALLOT", 161 },
    { CapabilityOperand, "GROUPNONUNIFORMCLUSTERED", 164 },
    { CapabilityOperand, "GROUPNONUNIFORMPARTITIONEDNV", 205 },
    { CapabilityOperand, "GROUPNONUNIFORMQUAD", 165 },
    { CapabilityOperand, "GROUPNONUNIFORMROTATEKHR", 251 },
    { CapabilityOperand, "GROUPNONUNIFORMSHUFFLE", 162 },
    { CapabilityOperand, "GROUPNONUNIFORMSHUFFLERELATIVE", 163 },
    { CapabilityOperand, "GROUPNONUNIFORMVOTE", 159 },
    { CapabilityOperand, "GROUPS", 116 },
    { CapabilityOperand, "GROUPUNIFORMARITHMETICKHR", 264 },
    { CapabilityOperand, "HOSTACCESSINTEL", 261 },
    { CapabilityOperand, "IMAGE1D", 141 },
    { CapabilityOperand, "IMAGEBASIC", 112 },
    { CapabilityOperand, "IMAGEBUFFER", 144 },
    { CapabilityOperand, "IMAGECUBEARRAY", 131 },
    { CapabilityOperand, "IMAGEFOOTPRINTNV", 201 },
    { CapabilityOperand, "IMAGEGATHERBIASLODAMD", 188 },
    { CapabilityOperand, "IMAGEGATHEREXTENDED", 123 },
    { CapabilityOperand, "IMAGEMIPMAP", 114 },
    { CapabilityOperand, "IMAGEMSARRAY", 145 },
    { CapabilityOperand, "IMAGEQUERY", 147 },
    { CapabilityOperand, "IMAGEREADWRITE", 113 },
    { CapabilityOperand, "IMAGEREADWRITELODAMD", 191 },
    { CapabilityOperand, "IMAGERECT", 133 },
    { CapabilityOperand, "INDIRECTREFERENCESINTEL", 232 },
    { CapabilityOperand, "INPUTATTACHMENT", 137 },
    { CapabilityOperand, "INPUTATTACHMENTARRAYDYNAMICINDEXINGEXT", 208 },
    { CapabilityOperand, "INPUTATTACHMENTARRAYNONUNIFORMINDEXINGEXT", 215 },
    { CapabilityOperand, "INT16", 120 },
    { CapabilityOperand, "INT64", 110 },
    { CapabilityOperand, "INT64ATOMICS", 111 },
    { CapabilityOperand, "INT8", 136 },
    { CapabilityOperand, "INTERPOLATIONFUNCTION", 149 },
    { CapabilityOperand, "KERNEL", 105 },
    { CapabilityOperand, "LINKAGE", 104 },
    { CapabilityOperand, "LITERALSAMPLER", 118 },
    { CapabilityOperand, "MATRIX", 99 },
    { CapabilityOperand, "MESHSHADINGNV", 200 },
    { CapabilityOperand, "MINLOD", 139 },
    { CapabilityOperand, "MULTIVIEW", 174 },
    { CapabilityOperand, "MULTIVIEWPORT", 154 },
    { CapabilityOperand, "NAMEDBARRIER", 156 },
    { CapabilityOperand, "OPTNONEEXT", 254 },
    { CapabilityOperand, "OPTNONEINTEL", 255 },
    { CapabilityOperand, "PACKEDCOOPERATIVEMATRIXINTEL", 266 },
    { CapabilityOperand, "PERVIEWATTRIBUTESNV", 198 },
    { CapabilityOperand, "PHYSICALSTORAGEBUFFERADDRESSESEXT", 221 },
    { CapabilityOperand, "PIPES", 115 },
    { CapabilityOperand, "PIPESTORAGE", 157 },
    { CapabilityOperand, "RAYTRACINGNV", 218 },
    { CapabilityOperand, "ROUNDINGMODERTE", 185 },
    { CapabilityOperand, "ROUNDINGMODERTZ", 186 },
    { CapabilityOperand, "ROUNDTOINFINITYINTEL", 229 },
    { CapabilityOperand, "RUNTIMEDESCRIPTORARRAYEXT", 207 },
    { CapabilityOperand, "SAMPLED1D", 140 },
    { CapabilityOperand, "SAMPLEDBUFFER", 143 },
    { CapabilityOperand, "SAMPLEDCUBEARRAY", 142 },
    { CapabilityOperand, "SAMPLEDIMAGEARRAYDYNAMICINDEXING", 126 },
    { CapabilityOperand, "SAMPLEDIMAGEARRAYNONUNIFORMINDEXINGEXT", 212 },
    { CapabilityOperand, "SAMPLEDRECT", 134 },
    { CapabilityOperand, "SAMPLEMASKOVERRIDECOVERAGENV", 193 },
    { CapabilityOperand, "SAMPLEMASKPOSTDEPTHCOVERAGE", 178 },
    { CapabilityOperand, "SAMPLERATESHADING", 132 },
    { CapabilityOperand, "SHADER", 100 },
    { CapabilityOperand, "SHADERCLOCKKHR", 192 },
    { CapabilityOperand, "SHADERNONUNIFORMEXT", 206 },
    { CapabilityOperand, "SHADERSTEREOVIEWNV", 197 },
    { CapabilityOperand, "SHADERVIEWPORTINDEXLAYEREXT", 195 },
    { CapabilityOperand, "SHADERVIEWPORTMASKNV", 196 },
    { CapabilityOperand, "SIGNEDZEROINFNANPRESERVE", 184 },
    { CapabilityOperand, "SPARSERESIDENCY", 138 },
    { CapabilityOperand, "SPLITBARRIERINTEL", 258 },
    { CapabilityOperand, "STENCILEXPORTEXT", 190 },
    { CapabilityOperand, "STORAGEBUFFER16BITACCESS", 169 },
    { CapabilityOperand, "STORAGEBUFFER8BITACCESS", 179 },
    { CapabilityOperand, "STORAGEBUFFERARRAYDYNAMICINDEXING", 127 },
    { CapabilityOperand, "STORAGEBUFFERARRAYNONUNIFORMINDEXINGEXT", 213 },
    { CapabilityOperand, "STORAGEIMAGEARRAYDYNAMICINDEXING", 128 },
    { CapabilityOperand, "STORAGEIMAGEARRAYNONUNIFORMINDEXINGEXT", 214 },
    { CapabilityOperand, "STORAGEIMAGEEXTENDEDFORMATS", 146 },
    { CapabilityOperand, "STORAGEIMAGEMULTISAMPLE", 124 },
    { CapabilityOperand, "STORAGEIMAGEREADWITHOUTFORMAT", 152 },
    { CapabilityOperand, "STORAGEIMAGEWRITEWITHOUTFORMAT", 153 },
    { CapabilityOperand, "STORAGEINPUTOUTPUT16", 172 },
    { CapabilityOperand, "STORAGEPUSHCONSTANT16", 171 },
    { CapabilityOperand, "STORAGEPUSHCONSTANT8", 181 },
    { CapabilityOperand, "STORAGETEXELBUFFERARRAYDYNAMICINDEXINGEXT", 210 },
    { CapabilityOperand, "STORAGETEXELBUFFERARRAYNONUNIFORMINDEXINGEXT", 217 },
    { CapabilityOperand, "STORAGEUNIFORM16", 170 },
    { CapabilityOperand, "SUBGROUPAVCMOTIONESTIMATIONCHROMAINTEL", 240 },
    { CapabilityOperand, "SUBGROUPAVCMOTIONESTIMATIONINTEL", 238 },
    { CapabilityOperand, "SUBGROUPAVCMOTIONESTIMATIONINTRAINTEL", 239 },
    { CapabilityOperand, "SUBGROUPBALLOTKHR", 166 },
    { CapabilityOperand, "SUBGROUPBUFFERBLOCKIOINTEL", 226 },
    { CapabilityOperand, "SUBGROUPDISPATCH", 155 },
    { CapabilityOperand, "SUBGROUPIMAGEBLOCKIOINTEL", 227 },
    { CapabilityOperand, "SUBGROUPIMAGEMEDIABLOCKIOINTEL", 228 },
    { CapabilityOperand, "SUBGROUPSHUFFLEINTEL", 225 },
    { CapabilityOperand, "SUBGROUPVOTEKHR", 168 },
    { CapabilityOperand, "TESSELLATION", 102 },
    { CapabilityOperand, "TESSELLATIONPOINTSIZE", 121 },
    { CapabilityOperand, "TRANSFORMFEEDBACK", 150 },
    { CapabilityOperand, "UNIFORMANDSTORAGEBUFFER8BITACCESS", 180 },
    { CapabilityOperand, "UNIFORMBUFFERARRAYDYNAMICINDEXING", 125 },
    { CapabilityOperand, "UNIFORMBUFFERARRAYNONUNIFORMINDEXINGEXT", 211 },
    { CapabilityOperand, "UNIFORMTEXELBUFFERARRAYDYNAMICINDEXINGEXT", 209 },
    { CapabilityOperand, "UNIFORMTEXELBUFFERARRAYNONUNIFORMINDEXINGEXT", 216 },
    { CapabilityOperand, "USMSTORAGECLASSESINTEL", 244 },
    { CapabilityOperand, "VARIABLELENGTHARRAYINTEL", 241 },
    { CapabilityOperand, "VARIABLEPOINTERS", 176 },
    { CapabilityOperand, "VARIABLEPOINTERSSTORAGEBUFFER", 175 },
    { CapabilityOperand, "VECTOR16", 106 },
    { CapabilityOperand, "VULKANMEMORYMODELDEVICESCOPEKHR", 220 },
    { CapabilityOperand, "VULKANMEMORYMODELKHR", 219 },
    { CooperativeMatrixLayoutOperand, "COLUMNMAJORKHR", 272 },
    { CooperativeMatrixLayoutOperand, "PACKEDINTEL", 273 },
    { CooperativeMatrixLayoutOperand, "ROWMAJORKHR", 271 },
    { CooperativeMatrixOperandsOperand, "MATRIXAANDBBFLOAT16COMPONENTSINTEL", 281 },
    { CooperativeMatrixOperandsOperand, "MATRIXAANDBTF32COMPONENTSINTEL", 280 },
    { CooperativeMatrixOperandsOperand, "MATRIXASIGNEDCOMPONENTSKHR", 275 },
    { CooperativeMatrixOperandsOperand, "MATRIXBSIGNEDCOMPONENTSKHR", 276 },
    { CooperativeMatrixOperandsOperand, "MATRIXCBFLOAT16COMPONENTSINTEL", 282 },
    { CooperativeMatrixOperandsOperand, "MATRIXCSIGNEDCOMPONENTSKHR", 277 },
    { CooperativeMatrixOperandsOperand, "MATRIXRESULTBFLOAT16COMPONENTSINTEL", 283 },
    { CooperativeMatrixOperandsOperand, "MATRIXRESULTSIGNEDCOMPONENTSKHR", 278 },
    { CooperativeMatrixOperandsOperand, "NONEKHR", 274 },
    { CooperativeMatrixOperandsOperand, "SATURATINGACCUMULATIONKHR", 279 },
    { DecorationOperand, "ALIASED", 303 },
    { DecorationOperand, "ALIASEDPOINTEREXT", 343 },
    { DecorationOperand, "ALIGNMENT", 327 },
    { DecorationOperand, "ALIGNMENTID", 329 },
    { DecorationOperand, "ARGUMENTATTRIBUTEINTEL", 355 },
    { DecorationOperand, "ARRAYSTRIDE", 290 },
    { DecorationOperand, "BINDING", 316 },
    { DecorationOperand, "BLOCK", 286 },
    { DecorationOperand, "BUFFERBLOCK", 287 },
    { DecorationOperand, "BUILTIN", 295 },
    { DecorationOperand, "CACHECONTROLLOADINTEL", 356 },
    { DecorationOperand, "CACHECONTROLSTOREINTEL", 357 },
    { DecorationOperand, "CENTROID", 299 },
    { DecorationOperand, "CLOBBERINTEL", 345 },
    { DecorationOperand, "COHERENT", 306 },
    { DecorationOperand, "COLMAJOR", 289 },
    { DecorationOperand, "COMPONENT", 314 },
    { DecorationOperand, "CONSTANT", 305 },
    { DecorationOperand, "COUNTBUFFER", 347 },
    { DecorationOperand, "CPACKED", 294 },
    { DecorationOperand, "DESCRIPTORSET", 317 },
    { DecorationOperand, "EXPLICITINTERPAMD", 333 },
    { DecorationOperand, "FLAT", 297 },
    { DecorationOperand, "FPFASTMATHMODE", 323 },
    { DecorationOperand, "FPROUNDINGMODE", 322 },
    { DecorationOperand, "FUNCPARAMATTR", 321 },
    { DecorationOperand, "FUNCTIONDENORMMODEINTEL", 350 },
    { DecorationOperand, "FUNCTIONFLOATINGPOINTMODEINTEL", 351 },
    { DecorationOperand, "FUNCTIONROUNDINGMODEINTEL", 349 },
    { DecorationOperand, "GLSLPACKED", 293 },
    { DecorationOperand, "GLSLSHARED", 292 },
    { DecorationOperand, "HOSTACCESSINTEL", 352 },
    { DecorationOperand, "IMPLEMENTINREGISTERMAPINTEL", 354 },
    { DecorationOperand, "INDEX", 315 },
    { DecorationOperand, "INITMODEINTEL", 353 },
    { DecorationOperand, "INPUTATTACHMENTINDEX", 326 },
    { DecorationOperand, "INVARIANT", 301 },
    { DecorationOperand, "LINKAGEATTRIBUTES", 324 },
    { DecorationOperand, "LOCATION", 313 },
    { DecorationOperand, "MATRIXSTRIDE", 291 },
    { DecorationOperand, "MAXBYTEOFFSET", 328 },
    { DecorationOperand, "MAXBYTEOFFSETID", 330 },
    { DecorationOperand, "NOCONTRACTION", 325 },
    { DecorationOperand, "NONREADABLE", 308 },
    { DecorationOperand, "NONUNIFORMEXT", 341 },
    { DecorationOperand, "NONWRITABLE", 307 },
    { DecorationOperand, "NOPERSPECTIVE", 296 },
    { DecorationOperand, "NOSIGNEDWRAP", 331 },
    { DecorationOperand, "NOUNSIGNEDWRAP", 332 },
    { DecorationOperand, "OFFSET", 318 },
    { DecorationOperand, "OVERRIDECOVERAGENV", 334 },
    { DecorationOperand, "PASSTHROUGHNV", 335 },
    { DecorationOperand, "PATCH", 298 },
    { DecorationOperand, "PERPRIMITIVENV", 338 },
    { DecorationOperand, "PERVERTEXNV", 340 },
    { DecorationOperand, "PERVIEWNV", 339 },
    { DecorationOperand, "REFERENCEDINDIRECTLYINTEL", 344 },
    { DecorationOperand, "RELAXEDPRECISION", 284 },
    { DecorationOperand, "RESTRICT", 302 },
    { DecorationOperand, "RESTRICTPOINTEREXT", 342 },
    { DecorationOperand, "ROWMAJOR", 288 },
    { DecorationOperand, "SAMPLE", 300 },
    { DecorationOperand, "SATURATEDCONVERSION", 311 },
    { DecorationOperand, "SECONDARYVIEWPORTRELATIVENV", 337 },
    { DecorationOperand, "SIDEEFFECTSINTEL", 346 },
    { DecorationOperand, "SPECID", 285 },
    { DecorationOperand, "STREAM", 312 },
    { DecorationOperand, "UNIFORM", 309 },
    { DecorationOperand, "UNIFORMID", 310 },
    { DecorationOperand, "USERSEMANTIC", 348 },
    { DecorationOperand, "VIEWPORTRELATIVENV", 336 },
    { DecorationOperand, "VOLATILE", 304 },
    { DecorationOperand, "XFBBUFFER", 319 },
    { DecorationOperand, "XFBSTRIDE", 320 },
    { DimOperand, "1D", 358 },
    { DimOperand, "2D", 359 },
    { DimOperand, "3D", 360 },
    { DimOperand, "BUFFER", 363 },
    { DimOperand, "CUBE", 361 },
    { DimOperand, "RECT", 362 },
    { DimOperand, "SUBPASSDATA", 364 },
    { ExecutionModeOperand, "CONTRACTIONOFF", 395 },
    { ExecutionModeOperand, "DENORMFLUSHTOZERO", 405 },
    { ExecutionModeOperand, "DENORMPRESERVE", 404 },
    { ExecutionModeOperand, "DEPTHGREATER", 378 },
    { ExecutionModeOperand, "DEPTHLESS", 379 },
    { ExecutionModeOperand, "DEPTHREPLACING", 377 },
    { ExecutionModeOperand, "DEPTHUNCHANGED", 380 },
    { ExecutionModeOperand, "DERIVATIVEGROUPLINEARNV", 412 },
    { ExecutionModeOperand, "DERIVATIVEGROUPQUADSNV", 411 },
    { ExecutionModeOperand, "EARLYFRAGMENTTESTS", 374 },
    { ExecutionModeOperand, "FINALIZER", 397 },
    { ExecutionModeOperand, "FLOATINGPOINTMODEALTINTEL", 416 },
    { ExecutionModeOperand, "FLOATINGPOINTMODEIEEEINTEL", 417 },
    { ExecutionModeOperand, "INITIALIZER", 396 },
    { ExecutionModeOperand, "INPUTLINES", 384 },
    { ExecutionModeOperand, "INPUTLINESADJACENCY", 385 },
    { ExecutionModeOperand, "INPUTPOINTS", 383 },
    { ExecutionModeOperand, "INPUTTRIANGLESADJACENCY", 387 },
    { ExecutionModeOperand, "INVOCATIONS", 365 },
    { ExecutionModeOperand, "ISOLINES", 389 },
    { ExecutionModeOperand, "LOCALSIZE", 381 },
    { ExecutionModeOperand, "LOCALSIZEHINT", 382 },
    { ExecutionModeOperand, "LOCALSIZEHINTID", 402 },
    { ExecutionModeOperand, "LOCALSIZEID", 401 },
    { ExecutionModeOperand, "ORIGINLOWERLEFT", 373 },
    { ExecutionModeOperand, "ORIGINUPPERLEFT", 372 },
    { ExecutionModeOperand, "OUTPUTLINESNV", 410 },
    { ExecutionModeOperand, "OUTPUTLINESTRIP", 392 },
    { ExecutionModeOperand, "OUTPUTPOINTS", 391 },
    { ExecutionModeOperand, "OUTPUTTRIANGLESNV", 413 },
    { ExecutionModeOperand, "OUTPUTTRIANGLESTRIP", 393 },
    { ExecutionModeOperand, "OUTPUTVERTICES", 390 },
    { ExecutionModeOperand, "PIXELCENTERINTEGER", 371 },
    { ExecutionModeOperand, "POINTMODE", 375 },
    { ExecutionModeOperand, "POSTDEPTHCOVERAGE", 403 },
    { ExecutionModeOperand, "QUADS", 388 },
    { ExecutionModeOperand, "ROUNDINGMODERTE", 407 },
    { ExecutionModeOperand, "ROUNDINGMODERTNINTEL", 415 },
    { ExecutionModeOperand, "ROUNDINGMODERTPINTEL", 414 },
    { ExecutionModeOperand, "ROUNDINGMODERTZ", 408 },
    { ExecutionModeOperand, "SIGNEDZEROINFNANPRESERVE", 406 },
    { ExecutionModeOperand, "SPACINGEQUAL", 366 },
    { ExecutionModeOperand, "SPACINGFRACTIONALEVEN", 367 },
    { ExecutionModeOperand, "SPACINGFRACTIONALODD", 368 },
    { ExecutionModeOperand, "STENCILREFREPLACINGEXT", 409 },
    { ExecutionModeOperand, "SUBGROUPSIZE", 398 },
    { ExecutionModeOperand, "SUBGROUPSPERWORKGROUP", 399 },
    { ExecutionModeOperand, "SUBGROUPSPERWORKGROUPID", 400 },
    { ExecutionModeOperand, "TRIANGLES", 386 },
    { ExecutionModeOperand, "VECTYPEHINT", 394 },
    { ExecutionModeOperand, "VERTEXORDERCCW", 370 },
    { ExecutionModeOperand, "VERTEXORDERCW", 369 },
    { ExecutionModeOperand, "XFB", 376 },
    { ExecutionModelOperand, "ANYHITNV", 429 },
    { ExecutionModelOperand, "CALLABLENV", 432 },
    { ExecutionModelOperand, "CLOSESTHITNV", 430 },
    { ExecutionModelOperand, "FRAGMENT", 422 },
    { ExecutionModelOperand, "GEOMETRY", 421 },
    { ExecutionModelOperand, "GLCOMPUTE", 423 },
    { ExecutionModelOperand, "INTERSECTIONNV", 428 },
    { ExecutionModelOperand, "KERNEL", 424 },
    { ExecutionModelOperand, "MESHNV", 426 },
    { ExecutionModelOperand, "MISSNV", 431 },
    { ExecutionModelOperand, "RAYGENERATIONNV", 427 },
    { ExecutionModelOperand, "TASKNV", 425 },
    { ExecutionModelOperand, "TESSELLATIONCONTROL", 419 },
    { ExecutionModelOperand, "TESSELLATIONEVALUATION", 420 },
    { ExecutionModelOperand, "VERTEX", 418 },
    { ExtensionOperand, "SPV_AMD_GCN_SHADER", 435 },
    { ExtensionOperand, "SPV_AMD_GPU_SHADER_HALF_FLOAT", 438 },
    { ExtensionOperand, "SPV_AMD_GPU_SHADER_HALF_FLOAT_FETCH", 460 },
    { ExtensionOperand, "SPV_AMD_GPU_SHADER_INT16", 452 },
    { ExtensionOperand, "SPV_AMD_SHADER_BALLOT", 437 },
    { ExtensionOperand, "SPV_AMD_SHADER_EXPLICIT_VERTEX_PARAMETER", 433 },
    { ExtensionOperand, "SPV_AMD_SHADER_FRAGMENT_MASK", 458 },
    { ExtensionOperand, "SPV_AMD_SHADER_IMAGE_LOAD_STORE_LOD", 457 },
    { ExtensionOperand, "SPV_AMD_SHADER_TRINARY_MINMAX_EXTENSION", 434 },
    { ExtensionOperand, "SPV_AMD_TEXTURE_GATHER_BIAS_LOD", 449 },
    { ExtensionOperand, "SPV_ARM_CORE_BUILTINS", 528 },
    { ExtensionOperand, "SPV_EXT_ARITHMETIC_FENCE", 543 },
    { ExtensionOperand, "SPV_EXT_DEMOTE_TO_HELPER_INVOCATION", 487 },
    { ExtensionOperand, "SPV_EXT_DESCRIPTOR_INDEXING", 464 },
    { ExtensionOperand, "SPV_EXT_FRAGMENT_FULLY_COVERED", 459 },
    { ExtensionOperand, "SPV_EXT_FRAGMENT_INVOCATION_DENSITY", 475 },
    { ExtensionOperand, "SPV_EXT_FRAGMENT_SHADER_INTERLOCK", 483 },
    { ExtensionOperand, "SPV_EXT_MESH_SHADER", 527 },
    { ExtensionOperand, "SPV_EXT_OPACITY_MICROMAP", 529 },
    { ExtensionOperand, "SPV_EXT_OPTNONE", 544 },
    { ExtensionOperand, "SPV_EXT_PHYSICAL_STORAGE_BUFFER", 478 },
    { ExtensionOperand, "SPV_EXT_RELAXED_PRINTF_STRING_ADDRESS_SPACE", 525 },
    { ExtensionOperand, "SPV_EXT_SHADER_ATOMIC_FLOAT16_ADD", 516 },
    { ExtensionOperand, "SPV_EXT_SHADER_ATOMIC_FLOAT_ADD", 499 },
    { ExtensionOperand, "SPV_EXT_SHADER_ATOMIC_FLOAT_MIN_MAX", 506 },
    { ExtensionOperand, "SPV_EXT_SHADER_IMAGE_INT64", 502 },
    { ExtensionOperand, "SPV_EXT_SHADER_STENCIL_EXPORT", 455 },
    { ExtensionOperand, "SPV_EXT_SHADER_VIEWPORT_INDEX_LAYER", 456 },
    { ExtensionOperand, "SPV_EXT_YCBCR_ATTACHMENTS", 526 },
    { ExtensionOperand, "SPV_GOOGLE_DECORATE_STRING", 461 },
    { ExtensionOperand, "SPV_GOOGLE_HLSL_FUNCTIONALITY1", 462 },
    { ExtensionOperand, "SPV_GOOGLE_USER_TYPE", 490 },
    { ExtensionOperand, "SPV_HUAWEI_SUBPASS_SHADING", 514 },
    { ExtensionOperand, "SPV_INTEL_ARBITRARY_PRECISION_INTEGERS", 498 },
    { ExtensionOperand, "SPV_INTEL_BFLOAT16_CONVERSION", 537 },
    { ExtensionOperand, "SPV_INTEL_BLOCKING_PIPES", 489 },
    { ExtensionOperand, "SPV_INTEL_CACHE_CONTROLS", 539 },
    { ExtensionOperand, "SPV_INTEL_FLOAT_CONTROLS2", 546 },
    { ExtensionOperand, "SPV_INTEL_FPGA_ARGUMENT_INTERFACES", 533 },
    { ExtensionOperand, "SPV_INTEL_FPGA_CLUSTER_ATTRIBUTES", 504 },
    { ExtensionOperand, "SPV_INTEL_FPGA_DSP_CONTROL", 510 },
    { ExtensionOperand, "SPV_INTEL_FPGA_INVOCATION_PIPELINING_ATTRIBUTES", 512 },
    { ExtensionOperand, "SPV_INTEL_FPGA_LATENCY_CONTROL", 532 },
    { ExtensionOperand, "SPV_INTEL_FPGA_LOOP_CONTROLS", 482 },
    { ExtensionOperand, "SPV_INTEL_FPGA_MEMORY_ACCESSES", 497 },
    { ExtensionOperand, "SPV_INTEL_FPGA_MEMORY_ATTRIBUTES", 479 },
    { ExtensionOperand, "SPV_INTEL_FPGA_REG", 488 },
    { ExtensionOperand, "SPV_INTEL_FP_FAST_MATH_MODE", 503 },
    { ExtensionOperand, "SPV_INTEL_FUNCTION_POINTERS", 535 },
    { ExtensionOperand, "SPV_INTEL_GLOBAL_VARIABLE_FPGA_DECORATIONS", 541 },
    { ExtensionOperand, "SPV_INTEL_GLOBAL_VARIABLE_HOST_ACCESS", 540 },
    { ExtensionOperand, "SPV_INTEL_INLINE_ASSEMBLY", 538 },
    { ExtensionOperand, "SPV_INTEL_IO_PIPES", 494 },
    { ExtensionOperand, "SPV_INTEL_JOINT_MATRIX", 545 },
    { ExtensionOperand, "SPV_INTEL_KERNEL_ATTRIBUTES", 492 },
    { ExtensionOperand, "SPV_INTEL_LOOP_FUSE", 505 },
    { ExtensionOperand, "SPV_INTEL_MEDIA_BLOCK_IO", 474 },
    { ExtensionOperand, "SPV_INTEL_OPTNONE", 534 },
    { ExtensionOperand, "SPV_INTEL_RUNTIME_ALIGNED", 517 },
    { ExtensionOperand, "SPV_INTEL_SHADER_INTEGER_FUNCTIONS2", 481 },
    { ExtensionOperand, "SPV_INTEL_SPLIT_BARRIER", 522 },
    { ExtensionOperand, "SPV_INTEL_SUBGROUPS", 473 },
    { ExtensionOperand, "SPV_INTEL_UNSTRUCTURED_LOOP_CONTROLS", 486 },
    { ExtensionOperand, "SPV_INTEL_USM_STORAGE_CLASSES", 531 },
    { ExtensionOperand, "SPV_INTEL_VARIABLE_LENGTH_ARRAY", 536 },
    { ExtensionOperand, "SPV_KHR_16BIT_STORAGE", 441 },
    { ExtensionOperand, "SPV_KHR_8BIT_STORAGE", 465 },
    { ExtensionOperand, "SPV_KHR_BIT_INSTRUCTIONS", 518 },
    { ExtensionOperand, "SPV_KHR_COOPERATIVE_MATRIX", 542 },
    { ExtensionOperand, "SPV_KHR_DEVICE_GROUP", 442 },
    { ExtensionOperand, "SPV_KHR_EXPECT_ASSUME", 509 },
    { ExtensionOperand, "SPV_KHR_FLOAT_CONTROLS", 477 },
    { ExtensionOperand, "SPV_KHR_FRAGMENT_SHADER_BARYCENTRIC", 524 },
    { ExtensionOperand, "SPV_KHR_FRAGMENT_SHADING_RATE", 501 },
    { ExtensionOperand, "SPV_KHR_INTEGER_DOT_PRODUCT", 515 },
    { ExtensionOperand, "SPV_KHR_LINKONCE_ODR", 508 },
    { ExtensionOperand, "SPV_KHR_MULTIVIEW", 443 },
    { ExtensionOperand, "SPV_KHR_NON_SEMANTIC_INFO", 493 },
    { ExtensionOperand, "SPV_KHR_NO_INTEGER_WRAP_DECORATION", 476 },
    { ExtensionOperand, "SPV_KHR_PHYSICAL_STORAGE_BUFFER", 491 },
    { ExtensionOperand, "SPV_KHR_POST_DEPTH_COVERAGE", 453 },
    { ExtensionOperand, "SPV_KHR_RAY_CULL_MASK", 523 },
    { ExtensionOperand, "SPV_KHR_RAY_QUERY", 496 },
    { ExtensionOperand, "SPV_KHR_RAY_TRACING", 495 },
    { ExtensionOperand, "SPV_KHR_SHADER_ATOMIC_COUNTER_OPS", 454 },
    { ExtensionOperand, "SPV_KHR_SHADER_BALLOT", 436 },
    { ExtensionOperand, "SPV_KHR_SHADER_CLOCK", 485 },
    { ExtensionOperand, "SPV_KHR_SHADER_DRAW_PARAMETERS", 439 },
    { ExtensionOperand, "SPV_KHR_STORAGE_BUFFER_STORAGE_CLASS", 450 },
    { ExtensionOperand, "SPV_KHR_SUBGROUP_ROTATE", 521 },
    { ExtensionOperand, "SPV_KHR_SUBGROUP_UNIFORM_CONTROL_FLOW", 513 },
    { ExtensionOperand, "SPV_KHR_SUBGROUP_VOTE", 440 },
    { ExtensionOperand, "SPV_KHR_TERMINATE_INVOCATION", 500 },
    { ExtensionOperand, "SPV_KHR_UNIFORM_GROUP_INSTRUCTIONS", 520 },
    { ExtensionOperand, "SPV_KHR_VARIABLE_POINTERS", 451 },
    { ExtensionOperand, "SPV_KHR_VULKAN_MEMORY_MODEL", 466 },
    { ExtensionOperand, "SPV_KHR_WORKGROUP_MEMORY_EXPLICIT_LAYOUT", 507 },
    { ExtensionOperand, "SPV_NVX_MULTIVIEW_PER_VIEW_ATTRIBUTES", 444 },
    { ExtensionOperand, "SPV_NV_BINDLESS_TEXTURE", 511 },
    { ExtensionOperand, "SPV_NV_COMPUTE_SHADER_DERIVATIVES", 468 },
    { ExtensionOperand, "SPV_NV_COOPERATIVE_MATRIX", 480 },
    { ExtensionOperand, "SPV_NV_FRAGMENT_SHADER_BARYCENTRIC", 469 },
    { ExtensionOperand, "SPV_NV_GEOMETRY_SHADER_PASSTHROUGH", 448 },
    { ExtensionOperand, "SPV_NV_MESH_SHADER", 470 },
    { ExtensionOperand, "SPV_NV_RAY_TRACING", 467 },
    { ExtensionOperand, "SPV_NV_RAY_TRACING_MOTION_BLUR", 519 },
    { ExtensionOperand, "SPV_NV_SAMPLE_MASK_OVERRIDE_COVERAGE", 447 },
    { ExtensionOperand, "SPV_NV_SHADER_IMAGE_FOOTPRINT", 471 },
    { ExtensionOperand, "SPV_NV_SHADER_INVOCATION_REORDER", 530 },
    { ExtensionOperand, "SPV_NV_SHADER_SM_BUILTINS", 484 },
    { ExtensionOperand, "SPV_NV_SHADER_SUBGROUP_PARTITIONED", 463 },
    { ExtensionOperand, "SPV_NV_SHADING_RATE", 472 },
    { ExtensionOperand, "SPV_NV_STEREO_VIEW_RENDERING", 446 },
    { ExtensionOperand, "SPV_NV_VIEWPORT_ARRAY2", 445 },
    { FPFastMathModeOperand, "ALLOWRECIP", 551 },
    { FPFastMathModeOperand, "FAST", 552 },
    { FPFastMathModeOperand, "NONE", 547 },
    { FPFastMathModeOperand, "NOTINF", 549 },
    { FPFastMathModeOperand, "NOTNAN", 548 },
    { FPFastMathModeOperand, "NSZ", 550 },
    { FPRoundingModeOperand, "RTE", 553 },
    { FPRoundingModeOperand, "RTN", 556 },
    { FPRoundingModeOperand, "RTP", 555 },
    { FPRoundingModeOperand, "RTZ", 554 },
    { FunctionControlOperand, "CONST", 561 },
    { FunctionControlOperand, "DONTINLINE", 559 },
    { FunctionControlOperand, "INLINE", 558 },
    { FunctionControlOperand, "NONE", 557 },
    { FunctionControlOperand, "OPTNONEEXT", 562 },
    { FunctionControlOperand, "PURE", 560 },
    { FunctionParameterAttributeOperand, "BYVAL", 565 },
    { FunctionParameterAttributeOperand, "NOALIAS", 567 },
    { FunctionParameterAttributeOperand, "NOCAPTURE", 568 },
    { FunctionParameterAttributeOperand, "NOREADWRITE", 570 },
    { FunctionParameterAttributeOperand, "NOWRITE", 569 },
    { FunctionParameterAttributeOperand, "SEXT", 564 },
    { FunctionParameterAttributeOperand, "SRET", 566 },
    { FunctionParameterAttributeOperand, "ZEXT", 563 },
    { GroupOperationOperand, "CLUSTEREDREDUCE", 574 },
    { GroupOperationOperand, "EXCLUSIVESCAN", 573 },
    { GroupOperationOperand, "INCLUSIVESCAN", 572 },
    { GroupOperationOperand, "PARTITIONEDEXCLUSIVESCANNV", 577 },
    { GroupOperationOperand, "PARTITIONEDINCLUSIVESCANNV", 576 },
    { GroupOperationOperand, "PARTITIONEDREDUCENV", 575 },
    { GroupOperationOperand, "REDUCE", 571 },
    { ImageChannelDataTypeOperand, "FLOAT", 592 },
    { ImageChannelDataTypeOperand, "HALFFLOAT", 591 },
    { ImageChannelDataTypeOperand, "SIGNEDINT16", 586 },
    { ImageChannelDataTypeOperand, "SIGNEDINT32", 587 },
    { ImageChannelDataTypeOperand, "SIGNEDINT8", 585 },
    { ImageChannelDataTypeOperand, "SNORMINT16", 579 },
    { ImageChannelDataTypeOperand, "SNORMINT8", 578 },
    { ImageChannelDataTypeOperand, "UNORMINT101010", 584 },
    { ImageChannelDataTypeOperand, "UNORMINT101010_2", 594 },
    { ImageChannelDataTypeOperand, "UNORMINT16", 581 },
    { ImageChannelDataTypeOperand, "UNORMINT24", 593 },
    { ImageChannelDataTypeOperand, "UNORMINT8", 580 },
    { ImageChannelDataTypeOperand, "UNORMSHORT555", 583 },
    { ImageChannelDataTypeOperand, "UNORMSHORT565", 582 },
    { ImageChannelDataTypeOperand, "UNSIGENDINT32", 590 },
    { ImageChannelDataTypeOperand, "UNSIGNEDINT16", 589 },
    { ImageChannelDataTypeOperand, "UNSIGNEDINT8", 588 },
    { ImageChannelOrderOperand, "A", 596 },
    { ImageChannelOrderOperand, "ABGR", 614 },
    { ImageChannelOrderOperand, "ARGB", 602 },
    { ImageChannelOrderOperand, "BGRA", 601 },
    { ImageChannelOrderOperand, "DEPTH", 608 },
    { ImageChannelOrderOperand, "DEPTHSTENCIL", 609 },
    { ImageChannelOrderOperand, "INTENSITY", 603 },
    { ImageChannelOrderOperand, "LUMINANCE", 604 },
    { ImageChannelOrderOperand, "R", 595 },
    { ImageChannelOrderOperand, "RA", 598 },
    { ImageChannelOrderOperand, "RG", 597 },
    { ImageChannelOrderOperand, "RGB", 599 },
    { ImageChannelOrderOperand, "RGBA", 600 },
    { ImageChannelOrderOperand, "RGBX", 607 },
    { ImageChannelOrderOperand, "RGX", 606 },
    { ImageChannelOrderOperand, "RX", 605 },
    { ImageChannelOrderOperand, "SBGRA", 613 },
    { ImageChannelOrderOperand, "SRGB", 610 },
    { ImageChannelOrderOperand, "SRGBA", 612 },
    { ImageChannelOrderOperand, "SRGBX", 611 },
    { ImageFormatOperand, "R11FG11FB10F", 623 },
    { ImageFormatOperand, "R16", 629 },
    { ImageFormatOperand, "R16F", 624 },
    { ImageFormatOperand, "R16I", 643 },
    { ImageFormatOperand, "R16SNORM", 634 },
    { ImageFormatOperand, "R16UI", 653 },
    { ImageFormatOperand, "R32F", 618 },
    { ImageFormatOperand, "R32I", 639 },
    { ImageFormatOperand, "R32UI", 648 },
    { ImageFormatOperand, "R8", 630 },
    { ImageFormatOperand, "R8I", 644 },
    { ImageFormatOperand, "R8SNORM", 635 },
    { ImageFormatOperand, "R8UI", 654 },
    { ImageFormatOperand, "RG16", 627 },
    { ImageFormatOperand, "RG16F", 622 },
    { ImageFormatOperand, "RG16I", 641 },
    { ImageFormatOperand, "RG16SNORM", 632 },
    { ImageFormatOperand, "RG16UI", 651 },
    { ImageFormatOperand, "RG32F", 621 },
    { ImageFormatOperand, "RG32I", 640 },
    { ImageFormatOperand, "RG32UI", 650 },
    { ImageFormatOperand, "RG8", 628 },
    { ImageFormatOperand, "RG8I", 642 },
    { ImageFormatOperand, "RG8SNORM", 633 },
    { ImageFormatOperand, "RG8UI", 652 },
    { ImageFormatOperand, "RGB10A2", 626 },
    { ImageFormatOperand, "RGB10A2UI", 649 },
    { ImageFormatOperand, "RGBA16", 625 },
    { ImageFormatOperand, "RGBA16F", 617 },
    { ImageFormatOperand, "RGBA16I", 637 },
    { ImageFormatOperand, "RGBA16SNORM", 631 },
    { ImageFormatOperand, "RGBA16UI", 646 },
    { ImageFormatOperand, "RGBA32F", 616 },
    { ImageFormatOperand, "RGBA32I", 636 },
    { ImageFormatOperand, "RGBA32UI", 645 },
    { ImageFormatOperand, "RGBA8", 619 },
    { ImageFormatOperand, "RGBA8I", 638 },
    { ImageFormatOperand, "RGBA8SNORM", 620 },
    { ImageFormatOperand, "RGBA8UI", 647 },
    { ImageFormatOperand, "UNKNOWN", 615 },
    { ImageOperandOperand, "BIAS", 656 },
    { ImageOperandOperand, "CONSTOFFSET", 659 },
    { ImageOperandOperand, "CONSTOFFSETS", 661 },
    { ImageOperandOperand, "GRAD", 658 },
    { ImageOperandOperand, "LOD", 657 },
    { ImageOperandOperand, "MAKETEXELAVAILABLEKHR", 664 },
    { ImageOperandOperand, "MAKETEXELVISIBLEKHR", 665 },
    { ImageOperandOperand, "MINLOD", 663 },
    { ImageOperandOperand, "NONE", 655 },
    { ImageOperandOperand, "NONPRIVATETEXELKHR", 666 },
    { ImageOperandOperand, "OFFSET", 660 },
    { ImageOperandOperand, "SAMPLE", 662 },
    { ImageOperandOperand, "SIGNEXTEND", 668 },
    { ImageOperandOperand, "VOLATILETEXELKHR", 667 },
    { ImageOperandOperand, "ZEROEXTEND", 669 },
    { KernelEnqueueFlagsOperand, "NOWAIT", 670 },
    { KernelEnqueueFlagsOperand, "WAITKERNEL", 671 },
    { KernelEnqueueFlagsOperand, "WAITWORKGROUP", 672 },
    { KernelProfilingInfoOperand, "CMDEXECTIME", 674 },
    { KernelProfilingInfoOperand, "NONE", 673 },
    { LinkageTypeOperand, "EXPORT", 675 },
    { LinkageTypeOperand, "IMPORT", 676 },
    { LinkageTypeOperand, "LINKONCEODR", 677 },
    { LoopControlOperand, "DEPENDENCYINFINITE", 681 },
    { LoopControlOperand, "DEPENDENCYLENGTH", 682 },
    { LoopControlOperand, "DONTUNROLL", 680 },
    { LoopControlOperand, "ITERATIONMULTIPLE", 685 },
    { LoopControlOperand, "MAXITERATIONS", 684 },
    { LoopControlOperand, "MINITERATIONS", 683 },
    { LoopControlOperand, "NONE", 678 },
    { LoopControlOperand, "PARTIALCOUNT", 687 },
    { LoopControlOperand, "PEELCOUNT", 686 },
    { LoopControlOperand, "UNROLL", 679 },
    { MemoryModelOperand, "GLSL450", 689 },
    { MemoryModelOperand, "OPENCL", 690 },
    { MemoryModelOperand, "SIMPLE", 688 },
    { MemoryModelOperand, "VULKANKHR", 691 },
    { MemoryOperandOperand, "ALIGNED", 694 },
    { MemoryOperandOperand, "MAKEPOINTERAVAILABLEKHR", 696 },
    { MemoryOperandOperand, "MAKEPOINTERVISIBLEKHR", 697 },
    { MemoryOperandOperand, "NONE", 692 },
    { MemoryOperandOperand, "NONPRIVATEPOINTERKHR", 698 },
    { MemoryOperandOperand, "NONTEMPORAL", 695 },
    { MemoryOperandOperand, "VOLATILE", 693 },
    { MemorySemanticsOperand, "ACQUIRE", 700 },
    { MemorySemanticsOperand, "ACQUIRERELEASE", 702 },
    { MemorySemanticsOperand, "ATOMICCOUNTERMEMORY", 708 },
    { MemorySemanticsOperand, "CROSSWORKGROUPMEMORY", 707 },
    { MemorySemanticsOperand, "IMAGEMEMORY", 709 },
    { MemorySemanticsOperand, "MAKEAVAILABLEKHR", 711 },
    { MemorySemanticsOperand, "MAKEVISIBLEKHR", 712 },
    { MemorySemanticsOperand, "NONE", 699 },
    { MemorySemanticsOperand, "OUTPUTMEMORYKHR", 710 },
    { MemorySemanticsOperand, "RELEASE", 701 },
    { MemorySemanticsOperand, "SEQUENTIALLYCONSISTENT", 703 },
    { MemorySemanticsOperand, "SUBGROUPMEMORY", 705 },
    { MemorySemanticsOperand, "UNIFORMMEMORY", 704 },
    { MemorySemanticsOperand, "WORKGROUPMEMORY", 706 },
    { OpcodeOperand, "BITCAST", 719 },
    { OpcodeOperand, "CONVERTPTRTOU", 715 },
    { OpcodeOperand, "CONVERTUTOPTR", 716 },
    { OpcodeOperand, "GENERICCASTTOPTR", 718 },
    { OpcodeOperand, "INBOUNDSACCESSCHAIN", 713 },
    { OpcodeOperand, "INBOUNDSPTRACCESSCHAIN", 714 },
    { OpcodeOperand, "PTRCASTTOGENERIC", 717 },
    { SamplerAddressingModeOperand, "CLAMP", 722 },
    { SamplerAddressingModeOperand, "CLAMPTOEDGE", 721 },
    { SamplerAddressingModeOperand, "NONE", 720 },
    { SamplerAddressingModeOperand, "REPEAT", 723 },
    { SamplerAddressingModeOperand, "REPEATMIRRORED", 724 },
    { SamplerFilterModeOperand, "LINEAR", 726 },
    { SamplerFilterModeOperand, "NEAREST", 725 },
    { ScopeOperand, "CROSSDEVICE", 727 },
    { ScopeOperand, "DEVICE", 728 },
    { ScopeOperand, "INVOCATION", 731 },
    { ScopeOperand, "QUEUEFAMILYKHR", 732 },
    { ScopeOperand, "SUBGROUP", 730 },
    { ScopeOperand, "WORKGROUP", 729 },
    { SelectionControlOperand, "DONTFLATTEN", 735 },
    { SelectionControlOperand, "FLATTEN", 734 },
    { SelectionControlOperand, "NONE", 733 },
    { SourceLanguageOperand, "ESSL", 737 },
    { SourceLanguageOperand, "GLSL", 738 },
    { SourceLanguageOperand, "HLSL", 741 },
    { SourceLanguageOperand, "OPENCL_C", 739 },
    { SourceLanguageOperand, "OPENCL_CPP", 740 },
    { SourceLanguageOperand, "UNKNOWN", 736 },
    { StorageClassOperand, "ATOMICCOUNTER", 752 },
    { StorageClassOperand, "CALLABLEDATANV", 755 },
    { StorageClassOperand, "CODESECTIONINTEL", 762 },
    { StorageClassOperand, "CROSSWORKGROUP", 747 },
    { StorageClassOperand, "DEVICEONLYINTEL", 763 },
    { StorageClassOperand, "FUNCTION", 749 },
    { StorageClassOperand, "GENERIC", 750 },
    { StorageClassOperand, "HITATTRIBUTENV", 758 },
    { StorageClassOperand, "HOSTONLYINTEL", 764 },
    { StorageClassOperand, "IMAGE", 753 },
    { StorageClassOperand, "INCOMINGCALLABLEDATANV", 756 },
    { StorageClassOperand, "INCOMINGRAYPAYLOADNV", 759 },
    { StorageClassOperand, "INPUT", 743 },
    { StorageClassOperand, "OUTPUT", 745 },
    { StorageClassOperand, "PHYSICALSTORAGEBUFFEREXT", 761 },
    { StorageClassOperand, "PRIVATE", 748 },
    { StorageClassOperand, "PUSHCONSTANT", 751 },
    { StorageClassOperand, "RAYPAYLOADNV", 757 },
    { StorageClassOperand, "SHADERRECORDBUFFERNV", 760 },
    { StorageClassOperand, "STORAGEBUFFER", 754 },
    { StorageClassOperand, "UNIFORM", 744 },
    { StorageClassOperand, "UNIFORMCONSTANT", 742 },
    { StorageClassOperand, "WORKGROUP", 746 },
  };

  struct KeyType {
    unsigned Category;
    std::string Mnemonic;
  };
  KeyType Key = {Category, Mnemonic.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Category < (unsigned)RHS.Category)
        return true;
      if ((unsigned)LHS.Category > (unsigned)RHS.Category)
        return false;
      int CmpMnemonic = StringRef(LHS.Mnemonic).compare(RHS.Mnemonic);
      if (CmpMnemonic < 0) return true;
      if (CmpMnemonic > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Category != Idx->Category ||
      Key.Mnemonic != Idx->Mnemonic)
    return nullptr;

  return &SymbolicOperands[Idx->_index];
}
#endif

#ifdef GET_VectorLoadStoreBuiltins_DECL
const VectorLoadStoreBuiltin *lookupVectorLoadStoreBuiltin(StringRef Name, unsigned Set);
#endif

#ifdef GET_VectorLoadStoreBuiltins_IMPL
constexpr VectorLoadStoreBuiltin VectorLoadStoreBuiltins[] = {
  { "vload", OpenCL_std, 0xAB, 0x1, false, RTE }, // 0
  { "vload16", OpenCL_std, 0xAB, 0x10, false, RTE }, // 1
  { "vload2", OpenCL_std, 0xAB, 0x2, false, RTE }, // 2
  { "vload3", OpenCL_std, 0xAB, 0x3, false, RTE }, // 3
  { "vload4", OpenCL_std, 0xAB, 0x4, false, RTE }, // 4
  { "vload8", OpenCL_std, 0xAB, 0x8, false, RTE }, // 5
  { "vloada_half", OpenCL_std, 0xAE, 0x1, false, RTE }, // 6
  { "vloada_half16", OpenCL_std, 0xAE, 0x10, false, RTE }, // 7
  { "vloada_half2", OpenCL_std, 0xAE, 0x2, false, RTE }, // 8
  { "vloada_half3", OpenCL_std, 0xAE, 0x3, false, RTE }, // 9
  { "vloada_half4", OpenCL_std, 0xAE, 0x4, false, RTE }, // 10
  { "vloada_half8", OpenCL_std, 0xAE, 0x8, false, RTE }, // 11
  { "vload_half", OpenCL_std, 0xAD, 0x1, false, RTE }, // 12
  { "vload_half16", OpenCL_std, 0xAE, 0x10, false, RTE }, // 13
  { "vload_half2", OpenCL_std, 0xAE, 0x2, false, RTE }, // 14
  { "vload_half3", OpenCL_std, 0xAE, 0x3, false, RTE }, // 15
  { "vload_half4", OpenCL_std, 0xAE, 0x4, false, RTE }, // 16
  { "vload_half8", OpenCL_std, 0xAE, 0x8, false, RTE }, // 17
  { "vstore", OpenCL_std, 0xAC, 0x1, false, RTE }, // 18
  { "vstore16", OpenCL_std, 0xAC, 0x10, false, RTE }, // 19
  { "vstore2", OpenCL_std, 0xAC, 0x2, false, RTE }, // 20
  { "vstore3", OpenCL_std, 0xAC, 0x3, false, RTE }, // 21
  { "vstore4", OpenCL_std, 0xAC, 0x4, false, RTE }, // 22
  { "vstore8", OpenCL_std, 0xAC, 0x8, false, RTE }, // 23
  { "vstorea_half", OpenCL_std, 0xB4, 0x1, false, RTE }, // 24
  { "vstorea_half16", OpenCL_std, 0xB4, 0x10, false, RTE }, // 25
  { "vstorea_half16_rte", OpenCL_std, 0xB5, 0x10, true, RTE }, // 26
  { "vstorea_half16_rtn", OpenCL_std, 0xB5, 0x10, true, RTN }, // 27
  { "vstorea_half16_rtp", OpenCL_std, 0xB5, 0x10, true, RTP }, // 28
  { "vstorea_half16_rtz", OpenCL_std, 0xB5, 0x10, true, RTZ }, // 29
  { "vstorea_half2", OpenCL_std, 0xB4, 0x2, false, RTE }, // 30
  { "vstorea_half2_rte", OpenCL_std, 0xB5, 0x2, true, RTE }, // 31
  { "vstorea_half2_rtn", OpenCL_std, 0xB5, 0x2, true, RTN }, // 32
  { "vstorea_half2_rtp", OpenCL_std, 0xB5, 0x2, true, RTP }, // 33
  { "vstorea_half2_rtz", OpenCL_std, 0xB5, 0x2, true, RTZ }, // 34
  { "vstorea_half3", OpenCL_std, 0xB4, 0x3, false, RTE }, // 35
  { "vstorea_half3_rte", OpenCL_std, 0xB5, 0x3, true, RTE }, // 36
  { "vstorea_half3_rtn", OpenCL_std, 0xB5, 0x3, true, RTN }, // 37
  { "vstorea_half3_rtp", OpenCL_std, 0xB5, 0x3, true, RTP }, // 38
  { "vstorea_half3_rtz", OpenCL_std, 0xB5, 0x3, true, RTZ }, // 39
  { "vstorea_half4", OpenCL_std, 0xB4, 0x4, false, RTE }, // 40
  { "vstorea_half4_rte", OpenCL_std, 0xB5, 0x4, true, RTE }, // 41
  { "vstorea_half4_rtn", OpenCL_std, 0xB5, 0x4, true, RTN }, // 42
  { "vstorea_half4_rtp", OpenCL_std, 0xB5, 0x4, true, RTP }, // 43
  { "vstorea_half4_rtz", OpenCL_std, 0xB5, 0x4, true, RTZ }, // 44
  { "vstorea_half8", OpenCL_std, 0xB4, 0x8, false, RTE }, // 45
  { "vstorea_half8_rte", OpenCL_std, 0xB5, 0x8, true, RTE }, // 46
  { "vstorea_half8_rtn", OpenCL_std, 0xB5, 0x8, true, RTN }, // 47
  { "vstorea_half8_rtp", OpenCL_std, 0xB5, 0x8, true, RTP }, // 48
  { "vstorea_half8_rtz", OpenCL_std, 0xB5, 0x8, true, RTZ }, // 49
  { "vstorea_half_rte", OpenCL_std, 0xB5, 0x1, true, RTE }, // 50
  { "vstorea_half_rtn", OpenCL_std, 0xB5, 0x1, true, RTN }, // 51
  { "vstorea_half_rtp", OpenCL_std, 0xB5, 0x1, true, RTP }, // 52
  { "vstorea_half_rtz", OpenCL_std, 0xB5, 0x1, true, RTZ }, // 53
  { "vstore_half", OpenCL_std, 0xAF, 0x1, false, RTE }, // 54
  { "vstore_half16", OpenCL_std, 0xB1, 0x10, false, RTE }, // 55
  { "vstore_half16_rte", OpenCL_std, 0xB2, 0x10, true, RTE }, // 56
  { "vstore_half16_rtn", OpenCL_std, 0xB2, 0x10, true, RTN }, // 57
  { "vstore_half16_rtp", OpenCL_std, 0xB2, 0x10, true, RTP }, // 58
  { "vstore_half16_rtz", OpenCL_std, 0xB2, 0x10, true, RTZ }, // 59
  { "vstore_half2", OpenCL_std, 0xB1, 0x2, false, RTE }, // 60
  { "vstore_half2_rte", OpenCL_std, 0xB2, 0x2, true, RTE }, // 61
  { "vstore_half2_rtn", OpenCL_std, 0xB2, 0x2, true, RTN }, // 62
  { "vstore_half2_rtp", OpenCL_std, 0xB2, 0x2, true, RTP }, // 63
  { "vstore_half2_rtz", OpenCL_std, 0xB2, 0x2, true, RTZ }, // 64
  { "vstore_half3", OpenCL_std, 0xB1, 0x3, false, RTE }, // 65
  { "vstore_half3_rte", OpenCL_std, 0xB2, 0x3, true, RTE }, // 66
  { "vstore_half3_rtn", OpenCL_std, 0xB2, 0x3, true, RTN }, // 67
  { "vstore_half3_rtp", OpenCL_std, 0xB2, 0x3, true, RTP }, // 68
  { "vstore_half3_rtz", OpenCL_std, 0xB2, 0x3, true, RTZ }, // 69
  { "vstore_half4", OpenCL_std, 0xB1, 0x4, false, RTE }, // 70
  { "vstore_half4_rte", OpenCL_std, 0xB2, 0x4, true, RTE }, // 71
  { "vstore_half4_rtn", OpenCL_std, 0xB2, 0x4, true, RTN }, // 72
  { "vstore_half4_rtp", OpenCL_std, 0xB2, 0x4, true, RTP }, // 73
  { "vstore_half4_rtz", OpenCL_std, 0xB2, 0x4, true, RTZ }, // 74
  { "vstore_half8", OpenCL_std, 0xB1, 0x8, false, RTE }, // 75
  { "vstore_half8_rte", OpenCL_std, 0xB2, 0x8, true, RTE }, // 76
  { "vstore_half8_rtn", OpenCL_std, 0xB2, 0x8, true, RTN }, // 77
  { "vstore_half8_rtp", OpenCL_std, 0xB2, 0x8, true, RTP }, // 78
  { "vstore_half8_rtz", OpenCL_std, 0xB2, 0x8, true, RTZ }, // 79
  { "vstore_half_rte", OpenCL_std, 0xB0, 0x1, true, RTE }, // 80
  { "vstore_half_rtn", OpenCL_std, 0xB0, 0x1, true, RTN }, // 81
  { "vstore_half_rtp", OpenCL_std, 0xB0, 0x1, true, RTP }, // 82
  { "vstore_half_rtz", OpenCL_std, 0xB0, 0x1, true, RTZ }, // 83
 };

const VectorLoadStoreBuiltin *lookupVectorLoadStoreBuiltin(StringRef Name, unsigned Set) {
  struct IndexType {
    const char * Name;
    unsigned Set;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "VLOAD", OpenCL_std, 0 },
    { "VLOAD16", OpenCL_std, 1 },
    { "VLOAD2", OpenCL_std, 2 },
    { "VLOAD3", OpenCL_std, 3 },
    { "VLOAD4", OpenCL_std, 4 },
    { "VLOAD8", OpenCL_std, 5 },
    { "VLOADA_HALF", OpenCL_std, 6 },
    { "VLOADA_HALF16", OpenCL_std, 7 },
    { "VLOADA_HALF2", OpenCL_std, 8 },
    { "VLOADA_HALF3", OpenCL_std, 9 },
    { "VLOADA_HALF4", OpenCL_std, 10 },
    { "VLOADA_HALF8", OpenCL_std, 11 },
    { "VLOAD_HALF", OpenCL_std, 12 },
    { "VLOAD_HALF16", OpenCL_std, 13 },
    { "VLOAD_HALF2", OpenCL_std, 14 },
    { "VLOAD_HALF3", OpenCL_std, 15 },
    { "VLOAD_HALF4", OpenCL_std, 16 },
    { "VLOAD_HALF8", OpenCL_std, 17 },
    { "VSTORE", OpenCL_std, 18 },
    { "VSTORE16", OpenCL_std, 19 },
    { "VSTORE2", OpenCL_std, 20 },
    { "VSTORE3", OpenCL_std, 21 },
    { "VSTORE4", OpenCL_std, 22 },
    { "VSTORE8", OpenCL_std, 23 },
    { "VSTOREA_HALF", OpenCL_std, 24 },
    { "VSTOREA_HALF16", OpenCL_std, 25 },
    { "VSTOREA_HALF16_RTE", OpenCL_std, 26 },
    { "VSTOREA_HALF16_RTN", OpenCL_std, 27 },
    { "VSTOREA_HALF16_RTP", OpenCL_std, 28 },
    { "VSTOREA_HALF16_RTZ", OpenCL_std, 29 },
    { "VSTOREA_HALF2", OpenCL_std, 30 },
    { "VSTOREA_HALF2_RTE", OpenCL_std, 31 },
    { "VSTOREA_HALF2_RTN", OpenCL_std, 32 },
    { "VSTOREA_HALF2_RTP", OpenCL_std, 33 },
    { "VSTOREA_HALF2_RTZ", OpenCL_std, 34 },
    { "VSTOREA_HALF3", OpenCL_std, 35 },
    { "VSTOREA_HALF3_RTE", OpenCL_std, 36 },
    { "VSTOREA_HALF3_RTN", OpenCL_std, 37 },
    { "VSTOREA_HALF3_RTP", OpenCL_std, 38 },
    { "VSTOREA_HALF3_RTZ", OpenCL_std, 39 },
    { "VSTOREA_HALF4", OpenCL_std, 40 },
    { "VSTOREA_HALF4_RTE", OpenCL_std, 41 },
    { "VSTOREA_HALF4_RTN", OpenCL_std, 42 },
    { "VSTOREA_HALF4_RTP", OpenCL_std, 43 },
    { "VSTOREA_HALF4_RTZ", OpenCL_std, 44 },
    { "VSTOREA_HALF8", OpenCL_std, 45 },
    { "VSTOREA_HALF8_RTE", OpenCL_std, 46 },
    { "VSTOREA_HALF8_RTN", OpenCL_std, 47 },
    { "VSTOREA_HALF8_RTP", OpenCL_std, 48 },
    { "VSTOREA_HALF8_RTZ", OpenCL_std, 49 },
    { "VSTOREA_HALF_RTE", OpenCL_std, 50 },
    { "VSTOREA_HALF_RTN", OpenCL_std, 51 },
    { "VSTOREA_HALF_RTP", OpenCL_std, 52 },
    { "VSTOREA_HALF_RTZ", OpenCL_std, 53 },
    { "VSTORE_HALF", OpenCL_std, 54 },
    { "VSTORE_HALF16", OpenCL_std, 55 },
    { "VSTORE_HALF16_RTE", OpenCL_std, 56 },
    { "VSTORE_HALF16_RTN", OpenCL_std, 57 },
    { "VSTORE_HALF16_RTP", OpenCL_std, 58 },
    { "VSTORE_HALF16_RTZ", OpenCL_std, 59 },
    { "VSTORE_HALF2", OpenCL_std, 60 },
    { "VSTORE_HALF2_RTE", OpenCL_std, 61 },
    { "VSTORE_HALF2_RTN", OpenCL_std, 62 },
    { "VSTORE_HALF2_RTP", OpenCL_std, 63 },
    { "VSTORE_HALF2_RTZ", OpenCL_std, 64 },
    { "VSTORE_HALF3", OpenCL_std, 65 },
    { "VSTORE_HALF3_RTE", OpenCL_std, 66 },
    { "VSTORE_HALF3_RTN", OpenCL_std, 67 },
    { "VSTORE_HALF3_RTP", OpenCL_std, 68 },
    { "VSTORE_HALF3_RTZ", OpenCL_std, 69 },
    { "VSTORE_HALF4", OpenCL_std, 70 },
    { "VSTORE_HALF4_RTE", OpenCL_std, 71 },
    { "VSTORE_HALF4_RTN", OpenCL_std, 72 },
    { "VSTORE_HALF4_RTP", OpenCL_std, 73 },
    { "VSTORE_HALF4_RTZ", OpenCL_std, 74 },
    { "VSTORE_HALF8", OpenCL_std, 75 },
    { "VSTORE_HALF8_RTE", OpenCL_std, 76 },
    { "VSTORE_HALF8_RTN", OpenCL_std, 77 },
    { "VSTORE_HALF8_RTP", OpenCL_std, 78 },
    { "VSTORE_HALF8_RTZ", OpenCL_std, 79 },
    { "VSTORE_HALF_RTE", OpenCL_std, 80 },
    { "VSTORE_HALF_RTN", OpenCL_std, 81 },
    { "VSTORE_HALF_RTP", OpenCL_std, 82 },
    { "VSTORE_HALF_RTZ", OpenCL_std, 83 },
  };

  struct KeyType {
    std::string Name;
    unsigned Set;
  };
  KeyType Key = {Name.upper(), Set};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpName = StringRef(LHS.Name).compare(RHS.Name);
      if (CmpName < 0) return true;
      if (CmpName > 0) return false;
      if ((unsigned)LHS.Set < (unsigned)RHS.Set)
        return true;
      if ((unsigned)LHS.Set > (unsigned)RHS.Set)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Name != Idx->Name ||
      Key.Set != Idx->Set)
    return nullptr;

  return &VectorLoadStoreBuiltins[Idx->_index];
}
#endif

#undef GET_AccessQualifier_DECL
#undef GET_AddressingModel_DECL
#undef GET_AtomicFloatingBuiltins_DECL
#undef GET_AtomicFloatingBuiltins_IMPL
#undef GET_BuiltIn_DECL
#undef GET_BuiltinGroup_DECL
#undef GET_BuiltinTypes_DECL
#undef GET_BuiltinTypes_IMPL
#undef GET_CLMemoryFenceFlags_DECL
#undef GET_CLMemoryScope_DECL
#undef GET_CLSamplerAddressingMode_DECL
#undef GET_CapabilityEntries_DECL
#undef GET_CapabilityEntries_IMPL
#undef GET_Capability_DECL
#undef GET_ConvertBuiltins_DECL
#undef GET_ConvertBuiltins_IMPL
#undef GET_CooperativeMatrixLayout_DECL
#undef GET_CooperativeMatrixOperands_DECL
#undef GET_Decoration_DECL
#undef GET_DemangledBuiltins_DECL
#undef GET_DemangledBuiltins_IMPL
#undef GET_Dim_DECL
#undef GET_ExecutionMode_DECL
#undef GET_ExecutionModel_DECL
#undef GET_ExtendedBuiltins_DECL
#undef GET_ExtendedBuiltins_IMPL
#undef GET_ExtensionEntries_DECL
#undef GET_ExtensionEntries_IMPL
#undef GET_Extension_DECL
#undef GET_FPFastMathMode_DECL
#undef GET_FPRoundingMode_DECL
#undef GET_FunctionControl_DECL
#undef GET_FunctionParameterAttribute_DECL
#undef GET_GLSLExtInst_DECL
#undef GET_GetBuiltins_DECL
#undef GET_GetBuiltins_IMPL
#undef GET_GroupBuiltins_DECL
#undef GET_GroupBuiltins_IMPL
#undef GET_GroupOperation_DECL
#undef GET_GroupUniformBuiltins_DECL
#undef GET_GroupUniformBuiltins_IMPL
#undef GET_ImageChannelDataType_DECL
#undef GET_ImageChannelOrder_DECL
#undef GET_ImageFormat_DECL
#undef GET_ImageOperand_DECL
#undef GET_ImageQueryBuiltins_DECL
#undef GET_ImageQueryBuiltins_IMPL
#undef GET_InstructionSet_DECL
#undef GET_IntelSubgroupsBuiltins_DECL
#undef GET_IntelSubgroupsBuiltins_IMPL
#undef GET_KernelEnqueueFlags_DECL
#undef GET_KernelProfilingInfo_DECL
#undef GET_LinkageType_DECL
#undef GET_LoopControl_DECL
#undef GET_MemoryModel_DECL
#undef GET_MemoryOperand_DECL
#undef GET_MemorySemantics_DECL
#undef GET_NativeBuiltins_DECL
#undef GET_NativeBuiltins_IMPL
#undef GET_NonSemanticExtInst_DECL
#undef GET_Opcode_DECL
#undef GET_OpenCLExtInst_DECL
#undef GET_OpenCLTypes_DECL
#undef GET_OpenCLTypes_IMPL
#undef GET_OperandCategory_DECL
#undef GET_SamplerAddressingMode_DECL
#undef GET_SamplerFilterMode_DECL
#undef GET_Scope_DECL
#undef GET_SelectionControl_DECL
#undef GET_SourceLanguage_DECL
#undef GET_StorageClass_DECL
#undef GET_SymbolicOperands_DECL
#undef GET_SymbolicOperands_IMPL
#undef GET_VectorLoadStoreBuiltins_DECL
#undef GET_VectorLoadStoreBuiltins_IMPL
