#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0065\x0073";
static constexpr OUStringLiteral langDefaultName = u"\x0053\x0070\x0061\x006e\x0069\x0073\x0068";
static constexpr OUStringLiteral countryID = u"\x0056\x0045";
static constexpr OUStringLiteral countryDefaultName = u"\x0056\x0065\x006e\x0065\x007a\x0075\x0065\x006c\x0061";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_es_VE(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_es_AR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_es_VE(sal_Int16& count)
{
	return getLocaleItem_es_AR(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x42, 0x73, 0x2d, 0x32, 0x30, 0x30, 0x41, 0x5d, 0x0};
extern OUString const * getAllFormats0_es_AR(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_es_VE(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_es_AR(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_es_AR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_es_VE(sal_Int16& count)
{
	return getDateAcceptancePatterns_es_AR(count);
}
extern const OUString *  getCollatorImplementation_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_es_VE(sal_Int16& count)
{
	return getCollatorImplementation_en_US(count);
}
extern const OUString *  getCollationOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_es_VE(sal_Int16& count)
{
	return getCollationOptions_en_US(count);
}
extern const OUString *  getSearchOptions_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_es_VE(sal_Int16& count)
{
	return getSearchOptions_en_US(count);
}
extern const OUString *  getIndexAlgorithm_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_es_VE(sal_Int16& count)
{
	return getIndexAlgorithm_es_ES(count);
}
extern const OUString *  getUnicodeScripts_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_es_VE(sal_Int16& count)
{
	return getUnicodeScripts_es_ES(count);
}
extern const OUString *  getFollowPageWords_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_es_VE(sal_Int16& count)
{
	return getFollowPageWords_es_ES(count);
}
extern const OUString *  getAllCalendars_es_AR(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_es_VE(sal_Int16& count)
{
	return getAllCalendars_es_AR(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x0";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0056\x0045\x0042";
static constexpr OUStringLiteral currencySymbol0 = u"\x0042\x0073";
static constexpr OUStringLiteral bankSymbol0 = u"\x0056\x0045\x0042";
static constexpr OUStringLiteral currencyName0 = u"\x0042\x006f\x006c\x0069\x0076\x0061\x0072";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static constexpr OUStringLiteral defaultCurrency1 = u"\x0";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes1 = u"\x0";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly1 = u"\x0";
static constexpr OUStringLiteral currencyID1 = u"\x0056\x0045\x0046";
static constexpr OUStringLiteral currencySymbol1 = u"\x0042\x0073\x0046";
static constexpr OUStringLiteral bankSymbol1 = u"\x0056\x0045\x0046";
static constexpr OUStringLiteral currencyName1 = u"\x0042\x006f\x006c\x0069\x0076\x0061\x0072\x0020\x0046\x0075\x0065\x0072\x0074\x0065";
static constexpr OUStringLiteral currencyDecimalPlaces1 = u"\x2";

static constexpr OUStringLiteral defaultCurrency2 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes2 = u"\x0";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly2 = u"\x0";
static constexpr OUStringLiteral currencyID2 = u"\x0056\x0045\x0053";
static constexpr OUStringLiteral currencySymbol2 = u"\x0042\x0073\x002e\x0053\x002e";
static constexpr OUStringLiteral bankSymbol2 = u"\x0056\x0045\x0053";
static constexpr OUStringLiteral currencyName2 = u"\x0042\x006f\x006c\x0069\x0076\x0061\x0072\x0020\x0053\x006f\x0062\x0065\x0072\x0061\x006e\x006f";
static constexpr OUStringLiteral currencyDecimalPlaces2 = u"\x2";

static const sal_Int16 currencyCount = 3;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
	currencyID1,
	currencySymbol1,
	bankSymbol1,
	currencyName1,
	defaultCurrency1,
	defaultCurrencyUsedInCompatibleFormatCodes1,
	currencyDecimalPlaces1,
	defaultCurrencyLegacyOnly1,
	currencyID2,
	currencySymbol2,
	bankSymbol2,
	currencyName2,
	defaultCurrency2,
	defaultCurrencyUsedInCompatibleFormatCodes2,
	currencyDecimalPlaces2,
	defaultCurrencyLegacyOnly2,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_es_VE(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_en_US(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_es_VE(sal_Int16& count)
{
	return getTransliterations_en_US(count);
}
extern const OUString *  getForbiddenCharacters_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_es_VE(sal_Int16& count)
{
	return getForbiddenCharacters_es_ES(count);
}
extern const OUString *  getBreakIteratorRules_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_es_VE(sal_Int16& count)
{
	return getBreakIteratorRules_es_ES(count);
}
extern const OUString *  getReservedWords_es_ES(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_es_VE(sal_Int16& count)
{
	return getReservedWords_es_ES(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_es_VE(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_en_US(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_en_US(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_es_VE(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_en_US(nStyles, nLevels, nAttributes);
}
} // extern "C"

