#ifndef itkPointSetSwigInterface_h
#define itkPointSetSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkDefaultStaticMeshTraits.h"
#include "itkDefaultDynamicMeshTraits.h"
#include "itkPointSet.h"

using itkPointSetSC2 = itk::PointSet< signed char,2 >;
using itkPointSetSC2_Pointer = itk::PointSet< signed char,2 >::Pointer;
using itkPointSetSS2 = itk::PointSet< signed short,2 >;
using itkPointSetSS2_Pointer = itk::PointSet< signed short,2 >::Pointer;
using itkPointSetUC2 = itk::PointSet< unsigned char,2 >;
using itkPointSetUC2_Pointer = itk::PointSet< unsigned char,2 >::Pointer;
using itkPointSetULL2 = itk::PointSet< unsigned long long,2 >;
using itkPointSetULL2_Pointer = itk::PointSet< unsigned long long,2 >::Pointer;
using itkPointSetUS2 = itk::PointSet< unsigned short,2 >;
using itkPointSetUS2_Pointer = itk::PointSet< unsigned short,2 >::Pointer;
using itkPointSetF2 = itk::PointSet< float,2 >;
using itkPointSetF2_Pointer = itk::PointSet< float,2 >::Pointer;
using itkPointSetD2 = itk::PointSet< double,2 >;
using itkPointSetD2_Pointer = itk::PointSet< double,2 >::Pointer;
using itkPointSetSC3 = itk::PointSet< signed char,3 >;
using itkPointSetSC3_Pointer = itk::PointSet< signed char,3 >::Pointer;
using itkPointSetSS3 = itk::PointSet< signed short,3 >;
using itkPointSetSS3_Pointer = itk::PointSet< signed short,3 >::Pointer;
using itkPointSetUC3 = itk::PointSet< unsigned char,3 >;
using itkPointSetUC3_Pointer = itk::PointSet< unsigned char,3 >::Pointer;
using itkPointSetULL3 = itk::PointSet< unsigned long long,3 >;
using itkPointSetULL3_Pointer = itk::PointSet< unsigned long long,3 >::Pointer;
using itkPointSetUS3 = itk::PointSet< unsigned short,3 >;
using itkPointSetUS3_Pointer = itk::PointSet< unsigned short,3 >::Pointer;
using itkPointSetF3 = itk::PointSet< float,3 >;
using itkPointSetF3_Pointer = itk::PointSet< float,3 >::Pointer;
using itkPointSetD3 = itk::PointSet< double,3 >;
using itkPointSetD3_Pointer = itk::PointSet< double,3 >::Pointer;
using itkPointSetSC4 = itk::PointSet< signed char,4 >;
using itkPointSetSC4_Pointer = itk::PointSet< signed char,4 >::Pointer;
using itkPointSetSS4 = itk::PointSet< signed short,4 >;
using itkPointSetSS4_Pointer = itk::PointSet< signed short,4 >::Pointer;
using itkPointSetUC4 = itk::PointSet< unsigned char,4 >;
using itkPointSetUC4_Pointer = itk::PointSet< unsigned char,4 >::Pointer;
using itkPointSetULL4 = itk::PointSet< unsigned long long,4 >;
using itkPointSetULL4_Pointer = itk::PointSet< unsigned long long,4 >::Pointer;
using itkPointSetUS4 = itk::PointSet< unsigned short,4 >;
using itkPointSetUS4_Pointer = itk::PointSet< unsigned short,4 >::Pointer;
using itkPointSetF4 = itk::PointSet< float,4 >;
using itkPointSetF4_Pointer = itk::PointSet< float,4 >::Pointer;
using itkPointSetD4 = itk::PointSet< double,4 >;
using itkPointSetD4_Pointer = itk::PointSet< double,4 >::Pointer;
using itkPointSetPD22STD22DD = itk::PointSet< itk::Point< double,2 >,2,itk::DefaultStaticMeshTraits< double,2,2,double,double,double > >;
using itkPointSetPD22STD22DD_Pointer = itk::PointSet< itk::Point< double,2 >,2,itk::DefaultStaticMeshTraits< double,2,2,double,double,double > >::Pointer;
using itkPointSetUI2DSMUI22FFUI = itk::PointSet< unsigned int,2,itk::DefaultStaticMeshTraits<unsigned int,2,2,float,float,unsigned int > >;
using itkPointSetUI2DSMUI22FFUI_Pointer = itk::PointSet< unsigned int,2,itk::DefaultStaticMeshTraits<unsigned int,2,2,float,float,unsigned int > >::Pointer;
using itkPointSetPD33STD33DD = itk::PointSet< itk::Point< double,3 >,3,itk::DefaultStaticMeshTraits< double,3,3,double,double,double > >;
using itkPointSetPD33STD33DD_Pointer = itk::PointSet< itk::Point< double,3 >,3,itk::DefaultStaticMeshTraits< double,3,3,double,double,double > >::Pointer;
using itkPointSetUI3DSMUI33FFUI = itk::PointSet< unsigned int,3,itk::DefaultStaticMeshTraits<unsigned int,3,3,float,float,unsigned int > >;
using itkPointSetUI3DSMUI33FFUI_Pointer = itk::PointSet< unsigned int,3,itk::DefaultStaticMeshTraits<unsigned int,3,3,float,float,unsigned int > >::Pointer;
using itkPointSetPD44STD44DD = itk::PointSet< itk::Point< double,4 >,4,itk::DefaultStaticMeshTraits< double,4,4,double,double,double > >;
using itkPointSetPD44STD44DD_Pointer = itk::PointSet< itk::Point< double,4 >,4,itk::DefaultStaticMeshTraits< double,4,4,double,double,double > >::Pointer;
using itkPointSetUI4DSMUI44FFUI = itk::PointSet< unsigned int,4,itk::DefaultStaticMeshTraits<unsigned int,4,4,float,float,unsigned int > >;
using itkPointSetUI4DSMUI44FFUI_Pointer = itk::PointSet< unsigned int,4,itk::DefaultStaticMeshTraits<unsigned int,4,4,float,float,unsigned int > >::Pointer;
using itkPointSetMD22 = itk::PointSet< itk::Matrix <double,2,2>,2 >;
using itkPointSetMD22_Pointer = itk::PointSet< itk::Matrix <double,2,2>,2 >::Pointer;
using itkPointSetAD2 = itk::PointSet< itk::Array <double>,2 >;
using itkPointSetAD2_Pointer = itk::PointSet< itk::Array <double>,2 >::Pointer;
using itkPointSetMD33 = itk::PointSet< itk::Matrix <double,3,3>,3 >;
using itkPointSetMD33_Pointer = itk::PointSet< itk::Matrix <double,3,3>,3 >::Pointer;
using itkPointSetAD3 = itk::PointSet< itk::Array <double>,3 >;
using itkPointSetAD3_Pointer = itk::PointSet< itk::Array <double>,3 >::Pointer;
using itkPointSetMD44 = itk::PointSet< itk::Matrix <double,4,4>,4 >;
using itkPointSetMD44_Pointer = itk::PointSet< itk::Matrix <double,4,4>,4 >::Pointer;
using itkPointSetAD4 = itk::PointSet< itk::Array <double>,4 >;
using itkPointSetAD4_Pointer = itk::PointSet< itk::Array <double>,4 >::Pointer;
using itkPointSetVF33 = itk::PointSet< itk::Vector< float, 3 >, 3 >;
using itkPointSetVF33_Pointer = itk::PointSet< itk::Vector< float, 3 >, 3 >::Pointer;


#include "itkArraySwigInterface.h"
#include "ITKCommonBaseSwigInterface.h"
#include "itkVectorSwigInterface.h"
#include "itkVectorContainerSwigInterface.h"
#include "itkPointSetSwigInterface.h"
#include "itkPointSwigInterface.h"
#include "itkMatrixSwigInterface.h"
#endif
