/* Indicator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
 * Copyright 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street - Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "power.h"
#include <glib.h>
#include <gio/gio.h>
#include <wingpanel.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <granite.h>
#include <libnotify/notify.h>
#include <gmodule.h>

#define POWER_INDICATOR_LOW_BATTERY_PERCENTAGE 20.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	POWER_INDICATOR_0_PROPERTY,
	POWER_INDICATOR_IS_IN_SESSION_PROPERTY,
	POWER_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY,
	POWER_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY,
	POWER_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* power_indicator_properties[POWER_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PowerIndicatorPrivate {
	gboolean _is_in_session;
	gboolean _natural_scroll_touchpad;
	gboolean _natural_scroll_mouse;
	PowerWidgetsDisplayWidget* display_widget;
	PowerWidgetsPopoverWidget* popover_widget;
	PowerServicesDevice* display_device;
	PowerServicesDeviceManager* dm;
	GSettings* settings;
};

static gint PowerIndicator_private_offset;
static gpointer power_indicator_parent_class = NULL;

static GtkWidget* power_indicator_real_get_display_widget (WingpanelIndicator* base);
static void power_indicator_update_visibility (PowerIndicator* self);
static void _power_indicator_update_visibility_g_object_notify (GObject* _sender,
                                                         GParamSpec* pspec,
                                                         gpointer self);
static void power_indicator_update_display_device (PowerIndicator* self);
static void _power_indicator_update_display_device_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self);
static void power_indicator_update_tooltip (PowerIndicator* self);
static void _power_indicator_update_tooltip_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self);
static gboolean ____lambda21_ (PowerIndicator* self,
                        GdkEventScroll* e);
static gboolean power_indicator_show_notification (PowerIndicator* self);
static gboolean _____lambda21__gtk_widget_scroll_event (GtkWidget* _sender,
                                                 GdkEventScroll* event,
                                                 gpointer self);
static void _power_indicator_update_tooltip_power_services_device_manager_brightness_changed (PowerServicesDeviceManager* _sender,
                                                                                       gint brightness,
                                                                                       gpointer self);
static GtkWidget* power_indicator_real_get_widget (WingpanelIndicator* base);
static void power_indicator_real_opened (WingpanelIndicator* base);
static void power_indicator_real_closed (WingpanelIndicator* base);
static void power_indicator_show_backlight_data (PowerIndicator* self);
static void power_indicator_show_display_device_data (PowerIndicator* self);
static void _power_indicator_show_display_device_data_power_services_device_properties_updated (PowerServicesDevice* _sender,
                                                                                         gpointer self);
static GObject * power_indicator_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void power_indicator_finalize (GObject * obj);
static GType power_indicator_get_type_once (void);
static void _vala_power_indicator_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_power_indicator_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
power_indicator_get_instance_private (PowerIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, PowerIndicator_private_offset);
}

PowerIndicator*
power_indicator_construct (GType object_type,
                           gboolean is_in_session)
{
	PowerIndicator * self = NULL;
	self = (PowerIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_POWER, "is-in-session", is_in_session, NULL);
	return self;
}

PowerIndicator*
power_indicator_new (gboolean is_in_session)
{
	return power_indicator_construct (POWER_TYPE_INDICATOR, is_in_session);
}

static void
_power_indicator_update_visibility_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self)
{
	power_indicator_update_visibility ((PowerIndicator*) self);
}

static void
_power_indicator_update_display_device_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self)
{
	power_indicator_update_display_device ((PowerIndicator*) self);
}

static void
_power_indicator_update_tooltip_g_settings_changed (GSettings* _sender,
                                                    const gchar* key,
                                                    gpointer self)
{
	power_indicator_update_tooltip ((PowerIndicator*) self);
}

static gboolean
____lambda21_ (PowerIndicator* self,
               GdkEventScroll* e)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_natural_scroll_mouse;
	_tmp1_ = self->priv->_natural_scroll_touchpad;
	if (power_utils_handle_scroll_event (e, _tmp0_, _tmp1_)) {
		gboolean _tmp2_ = FALSE;
		PowerWidgetsPopoverWidget* _tmp3_;
		_tmp3_ = self->priv->popover_widget;
		if (_tmp3_ == NULL) {
			_tmp2_ = TRUE;
		} else {
			PowerWidgetsPopoverWidget* _tmp4_;
			_tmp4_ = self->priv->popover_widget;
			_tmp2_ = !gtk_widget_is_visible ((GtkWidget*) _tmp4_);
		}
		if (_tmp2_) {
			power_indicator_show_notification (self);
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
_____lambda21__gtk_widget_scroll_event (GtkWidget* _sender,
                                        GdkEventScroll* event,
                                        gpointer self)
{
	gboolean result;
	result = ____lambda21_ ((PowerIndicator*) self, event);
	return result;
}

static void
_power_indicator_update_tooltip_power_services_device_manager_brightness_changed (PowerServicesDeviceManager* _sender,
                                                                                  gint brightness,
                                                                                  gpointer self)
{
	power_indicator_update_tooltip ((PowerIndicator*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
power_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	PowerIndicator * self;
	PowerWidgetsDisplayWidget* _tmp0_;
	PowerWidgetsDisplayWidget* _tmp21_;
	GtkWidget* _tmp22_;
	GtkWidget* result;
	self = (PowerIndicator*) base;
	_tmp0_ = self->priv->display_widget;
	if (_tmp0_ == NULL) {
		PowerWidgetsDisplayWidget* _tmp1_;
		gboolean _tmp2_ = FALSE;
		PowerServicesDeviceManager* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		PowerServicesDeviceManager* _tmp11_;
		PowerServicesDeviceManager* _tmp12_;
		GSettings* _tmp13_;
		PowerServicesDeviceManager* _tmp14_;
		PowerServicesBacklight* _tmp15_;
		PowerServicesBacklight* _tmp16_;
		gboolean _tmp17_;
		gboolean _tmp18_;
		_tmp1_ = power_widgets_display_widget_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->display_widget);
		self->priv->display_widget = _tmp1_;
		_tmp3_ = self->priv->dm;
		_tmp4_ = power_services_device_manager_get_has_battery (_tmp3_);
		_tmp5_ = _tmp4_;
		if (_tmp5_) {
			_tmp2_ = TRUE;
		} else {
			PowerServicesDeviceManager* _tmp6_;
			PowerServicesBacklight* _tmp7_;
			PowerServicesBacklight* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = self->priv->dm;
			_tmp7_ = power_services_device_manager_get_backlight (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = power_services_backlight_get_present (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp2_ = _tmp10_;
		}
		if (_tmp2_) {
			power_indicator_update_visibility (self);
		}
		_tmp11_ = self->priv->dm;
		g_signal_connect_object ((GObject*) _tmp11_, "notify::has-battery", (GCallback) _power_indicator_update_visibility_g_object_notify, self, 0);
		_tmp12_ = self->priv->dm;
		g_signal_connect_object ((GObject*) _tmp12_, "notify::display-device", (GCallback) _power_indicator_update_display_device_g_object_notify, self, 0);
		_tmp13_ = self->priv->settings;
		g_signal_connect_object (_tmp13_, "changed::show-percentage", (GCallback) _power_indicator_update_tooltip_g_settings_changed, self, 0);
		_tmp14_ = self->priv->dm;
		_tmp15_ = power_services_device_manager_get_backlight (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = power_services_backlight_get_present (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_) {
			PowerWidgetsDisplayWidget* _tmp19_;
			PowerServicesDeviceManager* _tmp20_;
			_tmp19_ = self->priv->display_widget;
			g_signal_connect_object ((GtkWidget*) _tmp19_, "scroll-event", (GCallback) _____lambda21__gtk_widget_scroll_event, self, 0);
			_tmp20_ = self->priv->dm;
			g_signal_connect_object (_tmp20_, "brightness-changed", (GCallback) _power_indicator_update_tooltip_power_services_device_manager_brightness_changed, self, 0);
		}
	}
	_tmp21_ = self->priv->display_widget;
	_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
	result = _tmp22_;
	return result;
}

static GtkWidget*
power_indicator_real_get_widget (WingpanelIndicator* base)
{
	PowerIndicator * self;
	PowerWidgetsPopoverWidget* _tmp0_;
	PowerWidgetsPopoverWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result;
	self = (PowerIndicator*) base;
	_tmp0_ = self->priv->popover_widget;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		PowerWidgetsPopoverWidget* _tmp2_;
		_tmp1_ = self->priv->_is_in_session;
		_tmp2_ = power_widgets_popover_widget_new (_tmp1_);
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (self->priv->popover_widget);
		self->priv->popover_widget = _tmp2_;
	}
	_tmp3_ = self->priv->popover_widget;
	_tmp4_ = _g_object_ref0 ((GtkWidget*) _tmp3_);
	result = _tmp4_;
	return result;
}

static void
power_indicator_real_opened (WingpanelIndicator* base)
{
	PowerIndicator * self;
	PowerWidgetsPopoverWidget* _tmp0_;
	self = (PowerIndicator*) base;
	_tmp0_ = self->priv->popover_widget;
	power_widgets_popover_widget_update_power_mode (_tmp0_);
}

static void
power_indicator_real_closed (WingpanelIndicator* base)
{
	PowerIndicator * self;
	self = (PowerIndicator*) base;
}

static void
power_indicator_update_visibility (PowerIndicator* self)
{
	PowerServicesDeviceManager* dm = NULL;
	PowerServicesDeviceManager* _tmp0_;
	PowerServicesDeviceManager* _tmp1_;
	gboolean _tmp2_ = FALSE;
	PowerServicesDeviceManager* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean should_be_visible = FALSE;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = power_services_device_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	dm = _tmp1_;
	_tmp3_ = dm;
	_tmp4_ = power_services_device_manager_get_has_battery (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp2_ = TRUE;
	} else {
		PowerServicesDeviceManager* _tmp6_;
		PowerServicesBacklight* _tmp7_;
		PowerServicesBacklight* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp6_ = dm;
		_tmp7_ = power_services_device_manager_get_backlight (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = power_services_backlight_get_present (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp2_ = _tmp10_;
	}
	should_be_visible = _tmp2_;
	_tmp11_ = wingpanel_indicator_get_visible ((WingpanelIndicator*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != should_be_visible) {
		wingpanel_indicator_set_visible ((WingpanelIndicator*) self, should_be_visible);
	}
	_tmp13_ = wingpanel_indicator_get_visible ((WingpanelIndicator*) self);
	_tmp14_ = _tmp13_;
	if (_tmp14_) {
		PowerServicesDeviceManager* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp15_ = dm;
		_tmp16_ = power_services_device_manager_get_has_battery (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_) {
			power_indicator_update_display_device (self);
		} else {
			power_indicator_show_backlight_data (self);
		}
	}
	power_indicator_update_tooltip (self);
	_g_object_unref0 (dm);
}

static void
_power_indicator_show_display_device_data_power_services_device_properties_updated (PowerServicesDevice* _sender,
                                                                                    gpointer self)
{
	power_indicator_show_display_device_data ((PowerIndicator*) self);
}

static void
power_indicator_update_display_device (PowerIndicator* self)
{
	PowerServicesDevice* _tmp0_;
	PowerServicesDeviceManager* _tmp3_;
	PowerServicesDevice* _tmp4_;
	PowerServicesDevice* _tmp5_;
	PowerServicesDevice* _tmp6_;
	PowerServicesDevice* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display_device;
	if (_tmp0_ != NULL) {
		PowerServicesDevice* _tmp1_;
		guint _tmp2_;
		_tmp1_ = self->priv->display_device;
		g_signal_parse_name ("properties-updated", POWER_SERVICES_TYPE_DEVICE, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _power_indicator_show_display_device_data_power_services_device_properties_updated, self);
	}
	_tmp3_ = power_services_device_manager_get_default ();
	_tmp4_ = power_services_device_manager_get_display_device (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->display_device);
	self->priv->display_device = _tmp6_;
	_tmp7_ = self->priv->display_device;
	if (_tmp7_ != NULL) {
		PowerServicesDevice* _tmp8_;
		power_indicator_show_display_device_data (self);
		_tmp8_ = self->priv->display_device;
		g_signal_connect_object (_tmp8_, "properties-updated", (GCallback) _power_indicator_show_display_device_data_power_services_device_properties_updated, self, 0);
	}
	power_indicator_update_tooltip (self);
}

static void
power_indicator_show_display_device_data (PowerIndicator* self)
{
	gboolean _tmp0_ = FALSE;
	PowerServicesDevice* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->display_device;
	if (_tmp1_ != NULL) {
		PowerWidgetsDisplayWidget* _tmp2_;
		_tmp2_ = self->priv->display_widget;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* icon_name = NULL;
		PowerServicesDevice* _tmp3_;
		gchar* _tmp4_;
		PowerWidgetsDisplayWidget* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		PowerServicesDevice* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		_tmp3_ = self->priv->display_device;
		_tmp4_ = power_services_device_get_symbolic_icon_name_for_battery (_tmp3_);
		icon_name = _tmp4_;
		_tmp5_ = self->priv->display_widget;
		_tmp6_ = icon_name;
		power_widgets_display_widget_set_icon_name (_tmp5_, _tmp6_);
		_tmp7_ = icon_name;
		g_debug ("Indicator.vala:147: Icon changed to \"%s\"", _tmp7_);
		_tmp8_ = self->priv->display_device;
		_tmp9_ = power_services_device_get_percentage (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ <= ((gdouble) 0)) {
			PowerWidgetsDisplayWidget* _tmp11_;
			_tmp11_ = self->priv->display_widget;
			power_widgets_display_widget_set_allow_percent (_tmp11_, FALSE);
		} else {
			PowerWidgetsDisplayWidget* _tmp12_;
			PowerServicesDevice* _tmp13_;
			gdouble _tmp14_;
			gdouble _tmp15_;
			PowerWidgetsDisplayWidget* _tmp16_;
			_tmp12_ = self->priv->display_widget;
			_tmp13_ = self->priv->display_device;
			_tmp14_ = power_services_device_get_percentage (_tmp13_);
			_tmp15_ = _tmp14_;
			power_widgets_display_widget_set_percentage (_tmp12_, (gint) round (_tmp15_));
			_tmp16_ = self->priv->display_widget;
			power_widgets_display_widget_set_allow_percent (_tmp16_, TRUE);
		}
		power_indicator_update_tooltip (self);
		_g_free0 (icon_name);
	}
}

static void
power_indicator_show_backlight_data (PowerIndicator* self)
{
	PowerWidgetsDisplayWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->display_widget;
	if (_tmp0_ != NULL) {
		PowerWidgetsDisplayWidget* _tmp1_;
		PowerWidgetsDisplayWidget* _tmp2_;
		_tmp1_ = self->priv->display_widget;
		power_widgets_display_widget_set_icon_name (_tmp1_, "display-brightness-symbolic");
		_tmp2_ = self->priv->display_widget;
		power_widgets_display_widget_set_allow_percent (_tmp2_, FALSE);
	}
}

static void
power_indicator_update_tooltip (PowerIndicator* self)
{
	gchar* primary_text = NULL;
	gchar* secondary_text = NULL;
	PowerServicesDevice* _tmp0_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp34_;
	const gchar* _tmp45_;
	g_return_if_fail (self != NULL);
	primary_text = NULL;
	secondary_text = NULL;
	_tmp0_ = self->priv->display_device;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		PowerServicesDevice* _tmp2_;
		gdouble _tmp3_;
		gdouble _tmp4_;
		gboolean is_showing_percent = FALSE;
		GSettings* _tmp9_;
		gboolean _tmp10_ = FALSE;
		PowerServicesDevice* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		PowerServicesDevice* _tmp15_;
		gboolean _tmp16_;
		gboolean _tmp17_;
		_tmp2_ = self->priv->display_device;
		_tmp3_ = power_services_device_get_percentage (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ <= POWER_INDICATOR_LOW_BATTERY_PERCENTAGE) {
			PowerServicesDevice* _tmp5_;
			gboolean _tmp6_;
			gboolean _tmp7_;
			_tmp5_ = self->priv->display_device;
			_tmp6_ = power_services_device_get_is_charging (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp1_ = !_tmp7_;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			PowerWidgetsDisplayWidget* _tmp8_;
			_tmp8_ = self->priv->display_widget;
			power_widgets_display_widget_show_percentage (_tmp8_, TRUE);
		}
		_tmp9_ = self->priv->settings;
		is_showing_percent = g_settings_get_boolean (_tmp9_, "show-percentage");
		_tmp11_ = self->priv->display_device;
		_tmp12_ = power_services_device_get_is_charging (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			_tmp10_ = !is_showing_percent;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			PowerWidgetsDisplayWidget* _tmp14_;
			_tmp14_ = self->priv->display_widget;
			power_widgets_display_widget_show_percentage (_tmp14_, FALSE);
		}
		_tmp15_ = self->priv->display_device;
		_tmp16_ = power_services_device_get_is_a_battery (_tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_) {
			PowerServicesDevice* _tmp18_;
			PowerServicesDeviceType _tmp19_;
			PowerServicesDeviceType _tmp20_;
			const gchar* _tmp21_;
			PowerServicesDevice* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			_tmp18_ = self->priv->display_device;
			_tmp19_ = power_services_device_get_device_type (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = power_services_device_type_get_name (_tmp20_);
			_tmp22_ = self->priv->display_device;
			_tmp23_ = power_services_device_get_description (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strdup_printf (_ ("%s: %s"), _tmp21_, _tmp24_);
			_g_free0 (primary_text);
			primary_text = _tmp25_;
			if (is_showing_percent) {
				_tmp26_ = _ ("Middle-click to hide percentage");
			} else {
				_tmp26_ = _ ("Middle-click to show percentage");
			}
			_tmp27_ = g_strdup (_tmp26_);
			_g_free0 (secondary_text);
			secondary_text = _tmp27_;
		} else {
			PowerServicesDevice* _tmp28_;
			PowerServicesDeviceType _tmp29_;
			PowerServicesDeviceType _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp28_ = self->priv->display_device;
			_tmp29_ = power_services_device_get_device_type (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = power_services_device_type_get_name (_tmp30_);
			_tmp32_ = g_strdup (_tmp31_);
			_g_free0 (primary_text);
			primary_text = _tmp32_;
		}
	}
	_tmp34_ = primary_text;
	if (_tmp34_ == NULL) {
		PowerServicesDeviceManager* _tmp35_;
		PowerServicesBacklight* _tmp36_;
		PowerServicesBacklight* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp35_ = self->priv->dm;
		_tmp36_ = power_services_device_manager_get_backlight (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = power_services_backlight_get_present (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp33_ = _tmp39_;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		PowerServicesDeviceManager* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		_tmp40_ = self->priv->dm;
		_tmp41_ = power_services_device_manager_get_brightness (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_strdup_printf (_ ("Screen brightness: %i"), (gint) _tmp42_);
		_g_free0 (primary_text);
		primary_text = _tmp43_;
		_tmp44_ = g_strdup (_ ("Scroll to change screen brightness"));
		_g_free0 (secondary_text);
		secondary_text = _tmp44_;
	}
	_tmp45_ = primary_text;
	if (_tmp45_ == NULL) {
		PowerWidgetsDisplayWidget* _tmp46_;
		_tmp46_ = self->priv->display_widget;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp46_, NULL);
	} else {
		const gchar* _tmp47_;
		_tmp47_ = secondary_text;
		if (_tmp47_ == NULL) {
			PowerWidgetsDisplayWidget* _tmp48_;
			const gchar* _tmp49_;
			_tmp48_ = self->priv->display_widget;
			_tmp49_ = primary_text;
			gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp48_, _tmp49_);
		} else {
			PowerWidgetsDisplayWidget* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp50_ = self->priv->display_widget;
			_tmp51_ = primary_text;
			_tmp52_ = secondary_text;
			_tmp53_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strdup_printf ("%s\n%s", _tmp51_, _tmp54_);
			_tmp56_ = _tmp55_;
			gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp50_, _tmp56_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp54_);
		}
	}
	_g_free0 (secondary_text);
	_g_free0 (primary_text);
}

static gboolean
power_indicator_show_notification (PowerIndicator* self)
{
	gboolean _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_in_session;
	if (_tmp0_) {
		NotifyNotification* notification = NULL;
		NotifyNotification* _tmp1_;
		NotifyNotification* _tmp2_;
		GVariant* _tmp3_;
		GVariant* _tmp4_;
		NotifyNotification* _tmp5_;
		PowerServicesDeviceManager* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		_tmp1_ = notify_notification_new ("indicator-power", "", "display-brightness-symbolic");
		notification = _tmp1_;
		_tmp2_ = notification;
		_tmp3_ = g_variant_new_string ("indicator-power");
		g_variant_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		notify_notification_set_hint (_tmp2_, "x-canonical-private-synchronous", _tmp4_);
		_g_variant_unref0 (_tmp4_);
		_tmp5_ = notification;
		_tmp6_ = self->priv->dm;
		_tmp7_ = power_services_device_manager_get_brightness (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_variant_new_int32 ((gint32) _tmp8_);
		g_variant_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		notify_notification_set_hint (_tmp5_, "value", _tmp10_);
		_g_variant_unref0 (_tmp10_);
		{
			NotifyNotification* _tmp11_;
			_tmp11_ = notification;
			notify_notification_show (_tmp11_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			result = TRUE;
			_g_object_unref0 (notification);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			g_warning ("Indicator.vala:215: Unable to show notification: %s", _tmp13_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp14_ = FALSE;
			_g_object_unref0 (notification);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp14_;
		}
		_g_object_unref0 (notification);
	}
	result = FALSE;
	return result;
}

gboolean
power_indicator_get_is_in_session (PowerIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_in_session;
	return result;
}

static void
power_indicator_set_is_in_session (PowerIndicator* self,
                                   gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_indicator_get_is_in_session (self);
	if (old_value != value) {
		self->priv->_is_in_session = value;
		g_object_notify_by_pspec ((GObject *) self, power_indicator_properties[POWER_INDICATOR_IS_IN_SESSION_PROPERTY]);
	}
}

gboolean
power_indicator_get_natural_scroll_touchpad (PowerIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_natural_scroll_touchpad;
	return result;
}

void
power_indicator_set_natural_scroll_touchpad (PowerIndicator* self,
                                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_indicator_get_natural_scroll_touchpad (self);
	if (old_value != value) {
		self->priv->_natural_scroll_touchpad = value;
		g_object_notify_by_pspec ((GObject *) self, power_indicator_properties[POWER_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY]);
	}
}

gboolean
power_indicator_get_natural_scroll_mouse (PowerIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_natural_scroll_mouse;
	return result;
}

void
power_indicator_set_natural_scroll_mouse (PowerIndicator* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = power_indicator_get_natural_scroll_mouse (self);
	if (old_value != value) {
		self->priv->_natural_scroll_mouse = value;
		g_object_notify_by_pspec ((GObject *) self, power_indicator_properties[POWER_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY]);
	}
}

static GObject *
power_indicator_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	PowerIndicator * self;
	GtkIconTheme* _tmp0_;
	PowerServicesDeviceManager* _tmp1_;
	PowerServicesDeviceManager* _tmp2_;
	GSettings* mouse_settings = NULL;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* touchpad_settings = NULL;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	parent_class = G_OBJECT_CLASS (power_indicator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_INDICATOR, PowerIndicator);
	bindtextdomain (CONSTANTS_GETTEXT_PACKAGE, CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gtk_icon_theme_get_default ();
	gtk_icon_theme_add_resource_path (_tmp0_, "/io/elementary/desktop/wingpanel/power");
	_tmp1_ = power_services_device_manager_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->dm);
	self->priv->dm = _tmp2_;
	_tmp3_ = g_settings_new ("org.gnome.desktop.peripherals.mouse");
	mouse_settings = _tmp3_;
	_tmp4_ = mouse_settings;
	g_settings_bind (_tmp4_, "natural-scroll", (GObject*) self, "natural-scroll-mouse", G_SETTINGS_BIND_DEFAULT);
	_tmp5_ = g_settings_new ("org.gnome.desktop.peripherals.touchpad");
	touchpad_settings = _tmp5_;
	_tmp6_ = touchpad_settings;
	g_settings_bind (_tmp6_, "natural-scroll", (GObject*) self, "natural-scroll-touchpad", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = g_settings_new ("io.elementary.desktop.wingpanel.power");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp7_;
	_g_object_unref0 (touchpad_settings);
	_g_object_unref0 (mouse_settings);
	return obj;
}

static void
power_indicator_class_init (PowerIndicatorClass * klass,
                            gpointer klass_data)
{
	power_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PowerIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) power_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) power_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) power_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) power_indicator_real_closed;
	G_OBJECT_CLASS (klass)->get_property = _vala_power_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_power_indicator_set_property;
	G_OBJECT_CLASS (klass)->constructor = power_indicator_constructor;
	G_OBJECT_CLASS (klass)->finalize = power_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_IS_IN_SESSION_PROPERTY, power_indicator_properties[POWER_INDICATOR_IS_IN_SESSION_PROPERTY] = g_param_spec_boolean ("is-in-session", "is-in-session", "is-in-session", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY, power_indicator_properties[POWER_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY] = g_param_spec_boolean ("natural-scroll-touchpad", "natural-scroll-touchpad", "natural-scroll-touchpad", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POWER_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY, power_indicator_properties[POWER_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY] = g_param_spec_boolean ("natural-scroll-mouse", "natural-scroll-mouse", "natural-scroll-mouse", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
power_indicator_instance_init (PowerIndicator * self,
                               gpointer klass)
{
	self->priv = power_indicator_get_instance_private (self);
	self->priv->_is_in_session = FALSE;
	self->priv->display_widget = NULL;
	self->priv->popover_widget = NULL;
	self->priv->display_device = NULL;
}

static void
power_indicator_finalize (GObject * obj)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_INDICATOR, PowerIndicator);
	_g_object_unref0 (self->priv->display_widget);
	_g_object_unref0 (self->priv->popover_widget);
	_g_object_unref0 (self->priv->display_device);
	_g_object_unref0 (self->priv->dm);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (power_indicator_parent_class)->finalize (obj);
}

static GType
power_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PowerIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerIndicator), 0, (GInstanceInitFunc) power_indicator_instance_init, NULL };
	GType power_indicator_type_id;
	power_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "PowerIndicator", &g_define_type_info, 0);
	PowerIndicator_private_offset = g_type_add_instance_private (power_indicator_type_id, sizeof (PowerIndicatorPrivate));
	return power_indicator_type_id;
}

GType
power_indicator_get_type (void)
{
	static volatile gsize power_indicator_type_id__once = 0;
	if (g_once_init_enter (&power_indicator_type_id__once)) {
		GType power_indicator_type_id;
		power_indicator_type_id = power_indicator_get_type_once ();
		g_once_init_leave (&power_indicator_type_id__once, power_indicator_type_id);
	}
	return power_indicator_type_id__once;
}

static void
_vala_power_indicator_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_IS_IN_SESSION_PROPERTY:
		g_value_set_boolean (value, power_indicator_get_is_in_session (self));
		break;
		case POWER_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY:
		g_value_set_boolean (value, power_indicator_get_natural_scroll_touchpad (self));
		break;
		case POWER_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY:
		g_value_set_boolean (value, power_indicator_get_natural_scroll_mouse (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_power_indicator_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	PowerIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, POWER_TYPE_INDICATOR, PowerIndicator);
	switch (property_id) {
		case POWER_INDICATOR_IS_IN_SESSION_PROPERTY:
		power_indicator_set_is_in_session (self, g_value_get_boolean (value));
		break;
		case POWER_INDICATOR_NATURAL_SCROLL_TOUCHPAD_PROPERTY:
		power_indicator_set_natural_scroll_touchpad (self, g_value_get_boolean (value));
		break;
		case POWER_INDICATOR_NATURAL_SCROLL_MOUSE_PROPERTY:
		power_indicator_set_natural_scroll_mouse (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	PowerIndicator* indicator = NULL;
	PowerIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:225: Activating Power Indicator");
	_tmp0_ = power_indicator_new (server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION);
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

