/* Indicator.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Indicator.vala, do not modify */

/*
* Copyright (c) 2015-2018 elementary LLC (http://launchpad.net/wingpanel-indicator-network)
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU Library General Public License as published by
* the Free Software Foundation, either version 2.1 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Library General Public License for more details.
*
* You should have received a copy of the GNU Library General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#include "network.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <wingpanel.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <granite.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_INDICATOR_0_PROPERTY,
	NETWORK_INDICATOR_IS_IN_SESSION_PROPERTY,
	NETWORK_INDICATOR_NUM_PROPERTIES
};
static GParamSpec* network_indicator_properties[NETWORK_INDICATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetworkIndicatorPrivate {
	NetworkWidgetsDisplayWidget* display_widget;
	NetworkWidgetsPopoverWidget* popover_widget;
	GNetworkMonitor* network_monitor;
	RFKillManager* rfkill;
	GtkGestureMultiPress* gesture_click;
	GSimpleAction* airplane_action;
	gboolean _is_in_session;
};

static gint NetworkIndicator_private_offset;
static gpointer network_indicator_parent_class = NULL;

static void network_indicator_on_state_changed (NetworkIndicator* self);
static void _network_indicator_on_state_changed_g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void __lambda34_ (NetworkIndicator* self);
static void ___lambda34__network_widgets_popover_widget_settings_shown (NetworkWidgetsPopoverWidget* _sender,
                                                                 gpointer self);
static void ___lambda35_ (NetworkIndicator* self);
static void ____lambda35__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                                    gint n_press,
                                                    gdouble x,
                                                    gdouble y,
                                                    gpointer self);
static void __lambda36_ (NetworkIndicator* self);
static void ___lambda36__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda37_ (NetworkIndicator* self);
static void ___lambda37__rf_kill_manager_device_changed (RFKillManager* _sender,
                                                  RFKillDevice* device,
                                                  gpointer self);
static void network_indicator_update_tooltip (NetworkIndicator* self);
static void network_indicator_start_monitor (NetworkIndicator* self);
static GtkWidget* network_indicator_real_get_display_widget (WingpanelIndicator* base);
static GtkWidget* network_indicator_real_get_widget (WingpanelIndicator* base);
static void __lambda38_ (NetworkIndicator* self,
                  gboolean availabe);
static void ___lambda38__g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                     gboolean network_available,
                                                     gpointer self);
static void network_indicator_real_opened (WingpanelIndicator* base);
static void network_indicator_real_closed (WingpanelIndicator* base);
static gchar* network_indicator_get_active_wired_name (NetworkIndicator* self);
static gchar* network_indicator_get_active_wifi_name (NetworkIndicator* self);
static void network_indicator_finalize (GObject * obj);
static GType network_indicator_get_type_once (void);
static void _vala_network_indicator_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_network_indicator_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);

static inline gpointer
network_indicator_get_instance_private (NetworkIndicator* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkIndicator_private_offset);
}

static void
_network_indicator_on_state_changed_g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	network_indicator_on_state_changed ((NetworkIndicator*) self);
}

static void
__lambda34_ (NetworkIndicator* self)
{
	g_signal_emit_by_name ((WingpanelIndicator*) self, "close");
}

static void
___lambda34__network_widgets_popover_widget_settings_shown (NetworkWidgetsPopoverWidget* _sender,
                                                            gpointer self)
{
	__lambda34_ ((NetworkIndicator*) self);
}

static void
___lambda35_ (NetworkIndicator* self)
{
	GSimpleAction* _tmp0_;
	_tmp0_ = self->priv->airplane_action;
	g_signal_emit_by_name (_tmp0_, "activate", NULL);
}

static void
____lambda35__gtk_gesture_multi_press_pressed (GtkGestureMultiPress* _sender,
                                               gint n_press,
                                               gdouble x,
                                               gdouble y,
                                               gpointer self)
{
	___lambda35_ ((NetworkIndicator*) self);
}

static void
__lambda36_ (NetworkIndicator* self)
{
	RFKillManager* _tmp0_;
	RFKillManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = self->priv->rfkill;
	_tmp1_ = self->priv->rfkill;
	_tmp2_ = rf_kill_manager_get_airplane_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	rf_kill_manager_set_airplane_mode (_tmp0_, !_tmp3_);
}

static void
___lambda36__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
	__lambda36_ ((NetworkIndicator*) self);
}

static void
__lambda37_ (NetworkIndicator* self)
{
	GSimpleAction* _tmp0_;
	RFKillManager* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	_tmp0_ = self->priv->airplane_action;
	_tmp1_ = self->priv->rfkill;
	_tmp2_ = rf_kill_manager_get_airplane_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_variant_new_boolean (_tmp3_);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (_tmp0_, _tmp5_);
	_g_variant_unref0 (_tmp5_);
}

static void
___lambda37__rf_kill_manager_device_changed (RFKillManager* _sender,
                                             RFKillDevice* device,
                                             gpointer self)
{
	__lambda37_ ((NetworkIndicator*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NetworkIndicator*
network_indicator_construct (GType object_type,
                             gboolean is_in_session)
{
	NetworkIndicator * self = NULL;
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp0_;
	GtkIconTheme* _tmp1_;
	NetworkWidgetsDisplayWidget* _tmp2_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp3_;
	GtkCssProvider* _tmp4_;
	GdkScreen* _tmp5_;
	GtkCssProvider* _tmp6_;
	NetworkWidgetsPopoverWidget* _tmp7_;
	NetworkWidgetsPopoverWidget* _tmp8_;
	NetworkWidgetsPopoverWidget* _tmp9_;
	NetworkWidgetsPopoverWidget* _tmp10_;
	NetworkWidgetsPopoverWidget* _tmp11_;
	RFKillManager* _tmp16_;
	RFKillManager* _tmp17_;
	RFKillManager* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GVariant* _tmp21_;
	GVariant* _tmp22_;
	GSimpleAction* _tmp23_;
	GSimpleAction* _tmp24_;
	RFKillManager* _tmp25_;
	GSimpleActionGroup* action_group = NULL;
	NetworkWidgetsPopoverWidget* _tmp26_;
	GActionGroup* _tmp27_;
	GSimpleActionGroup* _tmp28_;
	GSimpleAction* _tmp29_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gtk_icon_theme_get_default ();
	icon_theme = _tmp0_;
	_tmp1_ = icon_theme;
	gtk_icon_theme_add_resource_path (_tmp1_, "/io/elementary/wingpanel/network");
	self = (NetworkIndicator*) g_object_new (object_type, "code-name", WINGPANEL_INDICATOR_NETWORK, "is-in-session", is_in_session, "visible", TRUE, NULL);
	_tmp2_ = network_widgets_display_widget_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->display_widget);
	self->priv->display_widget = _tmp2_;
	_tmp3_ = gtk_css_provider_new ();
	provider = _tmp3_;
	_tmp4_ = provider;
	gtk_css_provider_load_from_resource (_tmp4_, "io/elementary/wingpanel/network/Indicator.css");
	_tmp5_ = gdk_screen_get_default ();
	_tmp6_ = provider;
	gtk_style_context_add_provider_for_screen (_tmp5_, (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp7_ = network_widgets_popover_widget_new (is_in_session);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->popover_widget);
	self->priv->popover_widget = _tmp7_;
	_tmp8_ = self->priv->popover_widget;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::state", (GCallback) _network_indicator_on_state_changed_g_object_notify, self, 0);
	_tmp9_ = self->priv->popover_widget;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::secure", (GCallback) _network_indicator_on_state_changed_g_object_notify, self, 0);
	_tmp10_ = self->priv->popover_widget;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::extra-info", (GCallback) _network_indicator_on_state_changed_g_object_notify, self, 0);
	_tmp11_ = self->priv->popover_widget;
	g_signal_connect_object (_tmp11_, "settings-shown", (GCallback) ___lambda34__network_widgets_popover_widget_settings_shown, self, 0);
	if (is_in_session) {
		gint _tmp12_ = 0;
		NetworkWidgetsDisplayWidget* _tmp13_;
		GtkGestureMultiPress* _tmp14_ = NULL;
		GtkGestureMultiPress* _tmp15_;
		_tmp12_ = GDK_BUTTON_MIDDLE;
		_tmp13_ = self->priv->display_widget;
		_tmp14_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) _tmp13_);
		gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp14_, (guint) _tmp12_);
		gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp14_, (guint) _tmp12_);
		_g_object_unref0 (self->priv->gesture_click);
		self->priv->gesture_click = _tmp14_;
		_tmp15_ = self->priv->gesture_click;
		g_signal_connect_object (_tmp15_, "pressed", (GCallback) ____lambda35__gtk_gesture_multi_press_pressed, self, 0);
	}
	_tmp16_ = rf_kill_manager_new ();
	_g_object_unref0 (self->priv->rfkill);
	self->priv->rfkill = _tmp16_;
	_tmp17_ = self->priv->rfkill;
	rf_kill_manager_open (_tmp17_);
	_tmp18_ = self->priv->rfkill;
	_tmp19_ = rf_kill_manager_get_airplane_mode (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_variant_new_boolean (_tmp20_);
	g_variant_ref_sink (_tmp21_);
	_tmp22_ = _tmp21_;
	_tmp23_ = g_simple_action_new_stateful ("airplane-mode", NULL, _tmp22_);
	_g_object_unref0 (self->priv->airplane_action);
	self->priv->airplane_action = _tmp23_;
	_g_variant_unref0 (_tmp22_);
	_tmp24_ = self->priv->airplane_action;
	g_signal_connect_object (_tmp24_, "activate", (GCallback) ___lambda36__g_simple_action_activate, self, 0);
	_tmp25_ = self->priv->rfkill;
	g_signal_connect_object (_tmp25_, "device-changed", (GCallback) ___lambda37__rf_kill_manager_device_changed, self, 0);
	_tmp26_ = self->priv->popover_widget;
	_tmp27_ = gtk_widget_get_action_group ((GtkWidget*) _tmp26_, "network");
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, g_simple_action_group_get_type (), GSimpleActionGroup));
	action_group = _tmp28_;
	_tmp29_ = self->priv->airplane_action;
	g_action_map_add_action ((GActionMap*) action_group, (GAction*) _tmp29_);
	network_indicator_update_tooltip (self);
	network_indicator_on_state_changed (self);
	network_indicator_start_monitor (self);
	_g_object_unref0 (action_group);
	_g_object_unref0 (provider);
	return self;
}

NetworkIndicator*
network_indicator_new (gboolean is_in_session)
{
	return network_indicator_construct (NETWORK_TYPE_INDICATOR, is_in_session);
}

static GtkWidget*
network_indicator_real_get_display_widget (WingpanelIndicator* base)
{
	NetworkIndicator * self;
	NetworkWidgetsDisplayWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	self = (NetworkIndicator*) base;
	_tmp0_ = self->priv->display_widget;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

static GtkWidget*
network_indicator_real_get_widget (WingpanelIndicator* base)
{
	NetworkIndicator * self;
	NetworkWidgetsPopoverWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	self = (NetworkIndicator*) base;
	_tmp0_ = self->priv->popover_widget;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

static void
network_indicator_on_state_changed (NetworkIndicator* self)
{
	NetworkWidgetsPopoverWidget* _tmp0_;
	NetworkWidgetsDisplayWidget* _tmp1_;
	NetworkWidgetsDisplayWidget* _tmp2_;
	NetworkWidgetsPopoverWidget* _tmp3_;
	NetworkState _tmp4_;
	NetworkState _tmp5_;
	NetworkWidgetsPopoverWidget* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	NetworkWidgetsPopoverWidget* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover_widget;
	_vala_assert (_tmp0_ != NULL, "popover_widget != null");
	_tmp1_ = self->priv->display_widget;
	_vala_assert (_tmp1_ != NULL, "display_widget != null");
	_tmp2_ = self->priv->display_widget;
	_tmp3_ = self->priv->popover_widget;
	_tmp4_ = network_widgets_popover_widget_get_state (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->popover_widget;
	_tmp7_ = network_widgets_popover_widget_get_secure (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->popover_widget;
	_tmp10_ = network_widgets_popover_widget_get_extra_info (_tmp9_);
	_tmp11_ = _tmp10_;
	network_widgets_display_widget_update_state (_tmp2_, _tmp5_, _tmp8_, _tmp11_);
	network_indicator_update_tooltip (self);
}

static void
__lambda38_ (NetworkIndicator* self,
             gboolean availabe)
{
	gboolean _tmp0_;
	GNetworkMonitor* _tmp1_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->_is_in_session;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->network_monitor;
	if (g_network_monitor_get_connectivity (_tmp1_) == G_NETWORK_CONNECTIVITY_PORTAL) {
		{
			GDesktopAppInfo* appinfo = NULL;
			GDesktopAppInfo* _tmp2_;
			GDesktopAppInfo* _tmp3_;
			_tmp2_ = g_desktop_app_info_new ("io.elementary.capnet-assist.desktop");
			appinfo = _tmp2_;
			_tmp3_ = appinfo;
			g_app_info_launch ((GAppInfo*) _tmp3_, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (appinfo);
				goto __catch0_g_error;
			}
			_g_object_unref0 (appinfo);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp4_;
			const gchar* _tmp5_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("Indicator.vala:119: %s", _tmp5_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	network_indicator_update_tooltip (self);
}

static void
___lambda38__g_network_monitor_network_changed (GNetworkMonitor* _sender,
                                                gboolean network_available,
                                                gpointer self)
{
	__lambda38_ ((NetworkIndicator*) self, network_available);
}

static void
network_indicator_start_monitor (NetworkIndicator* self)
{
	GNetworkMonitor* _tmp0_;
	GNetworkMonitor* _tmp1_;
	GNetworkMonitor* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_network_monitor_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->network_monitor);
	self->priv->network_monitor = _tmp1_;
	_tmp2_ = self->priv->network_monitor;
	g_signal_connect_object (_tmp2_, "network-changed", (GCallback) ___lambda38__g_network_monitor_network_changed, self, 0);
}

static void
network_indicator_real_opened (WingpanelIndicator* base)
{
	NetworkIndicator * self;
	NetworkWidgetsPopoverWidget* _tmp0_;
	self = (NetworkIndicator*) base;
	_tmp0_ = self->priv->popover_widget;
	if (_tmp0_ != NULL) {
		NetworkWidgetsPopoverWidget* _tmp1_;
		_tmp1_ = self->priv->popover_widget;
		network_widgets_popover_widget_opened (_tmp1_);
	}
}

static void
network_indicator_real_closed (WingpanelIndicator* base)
{
	NetworkIndicator * self;
	NetworkWidgetsPopoverWidget* _tmp0_;
	self = (NetworkIndicator*) base;
	_tmp0_ = self->priv->popover_widget;
	if (_tmp0_ != NULL) {
		NetworkWidgetsPopoverWidget* _tmp1_;
		_tmp1_ = self->priv->popover_widget;
		network_widgets_popover_widget_closed (_tmp1_);
	}
}

static void
network_indicator_update_tooltip (NetworkIndicator* self)
{
	gchar* tooltip_markup = NULL;
	gchar* _tmp0_;
	NetworkWidgetsPopoverWidget* _tmp1_;
	NetworkState _tmp2_;
	NetworkState _tmp3_;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	tooltip_markup = _tmp0_;
	_tmp1_ = self->priv->popover_widget;
	_tmp2_ = network_widgets_popover_widget_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case NETWORK_STATE_CONNECTING_WIRED:
		{
			gchar* active_wired_name = NULL;
			gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = network_indicator_get_active_wired_name (self);
			active_wired_name = _tmp4_;
			_tmp5_ = active_wired_name;
			if (g_strcmp0 (_tmp5_, _ ("Wired")) == 0) {
				gchar* _tmp6_;
				_tmp6_ = g_strdup (_ ("Connecting to wired network"));
				_g_free0 (tooltip_markup);
				tooltip_markup = _tmp6_;
			} else {
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = active_wired_name;
				_tmp8_ = g_strdup_printf (_ ("Connecting to “%s”"), _tmp7_);
				_g_free0 (tooltip_markup);
				tooltip_markup = _tmp8_;
			}
			_g_free0 (active_wired_name);
			break;
		}
		case NETWORK_STATE_CONNECTING_WIFI:
		case NETWORK_STATE_CONNECTING_MOBILE:
		{
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp9_ = network_indicator_get_active_wifi_name (self);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup_printf (_ ("Connecting to “%s”"), _tmp10_);
			_g_free0 (tooltip_markup);
			tooltip_markup = _tmp11_;
			_g_free0 (_tmp10_);
			break;
		}
		case NETWORK_STATE_CONNECTED_WIRED:
		{
			gchar* active_wired_name = NULL;
			gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = network_indicator_get_active_wired_name (self);
			active_wired_name = _tmp12_;
			_tmp13_ = active_wired_name;
			if (g_strcmp0 (_tmp13_, _ ("Wired")) == 0) {
				gchar* _tmp14_;
				_tmp14_ = g_strdup (_ ("Connected to wired network"));
				_g_free0 (tooltip_markup);
				tooltip_markup = _tmp14_;
			} else {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = active_wired_name;
				_tmp16_ = g_strdup_printf (_ ("Connected to “%s”"), _tmp15_);
				_g_free0 (tooltip_markup);
				tooltip_markup = _tmp16_;
			}
			_g_free0 (active_wired_name);
			break;
		}
		case NETWORK_STATE_CONNECTED_WIFI_WEAK:
		case NETWORK_STATE_CONNECTED_WIFI_OK:
		case NETWORK_STATE_CONNECTED_WIFI_GOOD:
		case NETWORK_STATE_CONNECTED_WIFI_EXCELLENT:
		case NETWORK_STATE_CONNECTED_MOBILE_WEAK:
		case NETWORK_STATE_CONNECTED_MOBILE_OK:
		case NETWORK_STATE_CONNECTED_MOBILE_GOOD:
		case NETWORK_STATE_CONNECTED_MOBILE_EXCELLENT:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			_tmp17_ = network_indicator_get_active_wifi_name (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strdup_printf (_ ("Connected to “%s”"), _tmp18_);
			_g_free0 (tooltip_markup);
			tooltip_markup = _tmp19_;
			_g_free0 (_tmp18_);
			break;
		}
		case NETWORK_STATE_FAILED:
		case NETWORK_STATE_FAILED_WIFI:
		case NETWORK_STATE_FAILED_MOBILE:
		{
			gchar* _tmp20_;
			_tmp20_ = g_strdup (_ ("Failed to connect"));
			_g_free0 (tooltip_markup);
			tooltip_markup = _tmp20_;
			break;
		}
		case NETWORK_STATE_DISCONNECTED:
		case NETWORK_STATE_DISCONNECTED_AIRPLANE_MODE:
		{
			gchar* _tmp21_;
			_tmp21_ = g_strdup (_ ("Disconnected"));
			_g_free0 (tooltip_markup);
			tooltip_markup = _tmp21_;
			break;
		}
		default:
		{
			gchar* _tmp22_;
			_tmp22_ = g_strdup (_ ("Not connected"));
			_g_free0 (tooltip_markup);
			tooltip_markup = _tmp22_;
			break;
		}
	}
	_tmp23_ = self->priv->_is_in_session;
	if (_tmp23_) {
		const gchar* _tmp24_ = NULL;
		NetworkWidgetsPopoverWidget* _tmp25_;
		NetworkState _tmp26_;
		NetworkState _tmp27_;
		gchar* middle_click_markup = NULL;
		gchar* _tmp28_;
		NetworkWidgetsDisplayWidget* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		_tmp25_ = self->priv->popover_widget;
		_tmp26_ = network_widgets_popover_widget_get_state (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == NETWORK_STATE_DISCONNECTED_AIRPLANE_MODE) {
			_tmp24_ = _ ("Middle-click to turn airplane mode off");
		} else {
			_tmp24_ = _ ("Middle-click to turn airplane mode on");
		}
		_tmp28_ = g_strdup (_tmp24_);
		middle_click_markup = _tmp28_;
		_tmp29_ = self->priv->display_widget;
		_tmp30_ = tooltip_markup;
		_tmp31_ = middle_click_markup;
		_tmp32_ = g_strdup_printf (GRANITE_TOOLTIP_SECONDARY_TEXT_MARKUP, _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_strdup_printf ("%s\n%s", _tmp30_, _tmp33_);
		_tmp35_ = _tmp34_;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp29_, _tmp35_);
		_g_free0 (_tmp35_);
		_g_free0 (_tmp33_);
		_g_free0 (middle_click_markup);
	} else {
		NetworkWidgetsDisplayWidget* _tmp36_;
		const gchar* _tmp37_;
		_tmp36_ = self->priv->display_widget;
		_tmp37_ = tooltip_markup;
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp36_, _tmp37_);
	}
	_g_free0 (tooltip_markup);
}

static gchar*
network_indicator_get_active_wired_name (NetworkIndicator* self)
{
	NetworkWidgetsPopoverWidget* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->popover_widget;
	_tmp1_ = network_widgets_popover_widget_get_network_interface (_tmp0_);
	_tmp2_ = _tmp1_;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp2_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* iface = NULL;
			iface = (NetworkWidgetNMInterface*) iface_it->data;
			{
				NetworkWidgetNMInterface* _tmp3_;
				_tmp3_ = iface;
				if (NETWORK_IS_ETHER_INTERFACE (_tmp3_)) {
					gchar* active_wired_name = NULL;
					NetworkWidgetNMInterface* _tmp4_;
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp4_ = iface;
					_tmp5_ = network_widget_nm_interface_get_display_title (_tmp4_);
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strdup (_tmp6_);
					active_wired_name = _tmp7_;
					_tmp8_ = active_wired_name;
					_tmp9_ = g_strdup_printf ("Active network (Wired): %s", _tmp8_);
					_tmp10_ = _tmp9_;
					g_debug ("Indicator.vala:212: %s", _tmp10_);
					_g_free0 (_tmp10_);
					result = active_wired_name;
					return result;
				}
			}
		}
	}
	_tmp11_ = g_strdup (_ ("unknown network"));
	result = _tmp11_;
	return result;
}

static gchar*
network_indicator_get_active_wifi_name (NetworkIndicator* self)
{
	NetworkWidgetsPopoverWidget* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->popover_widget;
	_tmp1_ = network_widgets_popover_widget_get_network_interface (_tmp0_);
	_tmp2_ = _tmp1_;
	{
		GList* iface_collection = NULL;
		GList* iface_it = NULL;
		iface_collection = _tmp2_;
		for (iface_it = iface_collection; iface_it != NULL; iface_it = iface_it->next) {
			NetworkWidgetNMInterface* iface = NULL;
			iface = (NetworkWidgetNMInterface*) iface_it->data;
			{
				NetworkWidgetNMInterface* _tmp3_;
				_tmp3_ = iface;
				if (NETWORK_IS_WIFI_INTERFACE (_tmp3_)) {
					gchar* active_wifi_name = NULL;
					NetworkWidgetNMInterface* _tmp4_;
					const gchar* _tmp5_;
					const gchar* _tmp6_;
					gchar* _tmp7_;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp4_ = iface;
					_tmp5_ = network_wifi_interface_get_active_ap_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface));
					_tmp6_ = _tmp5_;
					_tmp7_ = g_strdup (_tmp6_);
					active_wifi_name = _tmp7_;
					_tmp8_ = active_wifi_name;
					_tmp9_ = g_strdup_printf ("Active network (WiFi): %s", _tmp8_);
					_tmp10_ = _tmp9_;
					g_debug ("Indicator.vala:224: %s", _tmp10_);
					_g_free0 (_tmp10_);
					result = active_wifi_name;
					return result;
				}
			}
		}
	}
	_tmp11_ = g_strdup (_ ("unknown network"));
	result = _tmp11_;
	return result;
}

gboolean
network_indicator_get_is_in_session (NetworkIndicator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_in_session;
	return result;
}

void
network_indicator_set_is_in_session (NetworkIndicator* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = network_indicator_get_is_in_session (self);
	if (old_value != value) {
		self->priv->_is_in_session = value;
		g_object_notify_by_pspec ((GObject *) self, network_indicator_properties[NETWORK_INDICATOR_IS_IN_SESSION_PROPERTY]);
	}
}

static void
network_indicator_class_init (NetworkIndicatorClass * klass,
                              gpointer klass_data)
{
	network_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkIndicator_private_offset);
	((WingpanelIndicatorClass *) klass)->get_display_widget = (GtkWidget* (*) (WingpanelIndicator*)) network_indicator_real_get_display_widget;
	((WingpanelIndicatorClass *) klass)->get_widget = (GtkWidget* (*) (WingpanelIndicator*)) network_indicator_real_get_widget;
	((WingpanelIndicatorClass *) klass)->opened = (void (*) (WingpanelIndicator*)) network_indicator_real_opened;
	((WingpanelIndicatorClass *) klass)->closed = (void (*) (WingpanelIndicator*)) network_indicator_real_closed;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_indicator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_indicator_set_property;
	G_OBJECT_CLASS (klass)->finalize = network_indicator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETWORK_INDICATOR_IS_IN_SESSION_PROPERTY, network_indicator_properties[NETWORK_INDICATOR_IS_IN_SESSION_PROPERTY] = g_param_spec_boolean ("is-in-session", "is-in-session", "is-in-session", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
network_indicator_instance_init (NetworkIndicator * self,
                                 gpointer klass)
{
	self->priv = network_indicator_get_instance_private (self);
	self->priv->display_widget = NULL;
	self->priv->popover_widget = NULL;
	self->priv->_is_in_session = FALSE;
}

static void
network_indicator_finalize (GObject * obj)
{
	NetworkIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_INDICATOR, NetworkIndicator);
	_g_object_unref0 (self->priv->display_widget);
	_g_object_unref0 (self->priv->popover_widget);
	_g_object_unref0 (self->priv->network_monitor);
	_g_object_unref0 (self->priv->rfkill);
	_g_object_unref0 (self->priv->gesture_click);
	_g_object_unref0 (self->priv->airplane_action);
	G_OBJECT_CLASS (network_indicator_parent_class)->finalize (obj);
}

static GType
network_indicator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkIndicator), 0, (GInstanceInitFunc) network_indicator_instance_init, NULL };
	GType network_indicator_type_id;
	network_indicator_type_id = g_type_register_static (WINGPANEL_TYPE_INDICATOR, "NetworkIndicator", &g_define_type_info, 0);
	NetworkIndicator_private_offset = g_type_add_instance_private (network_indicator_type_id, sizeof (NetworkIndicatorPrivate));
	return network_indicator_type_id;
}

GType
network_indicator_get_type (void)
{
	static volatile gsize network_indicator_type_id__once = 0;
	if (g_once_init_enter (&network_indicator_type_id__once)) {
		GType network_indicator_type_id;
		network_indicator_type_id = network_indicator_get_type_once ();
		g_once_init_leave (&network_indicator_type_id__once, network_indicator_type_id);
	}
	return network_indicator_type_id__once;
}

static void
_vala_network_indicator_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	NetworkIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_INDICATOR, NetworkIndicator);
	switch (property_id) {
		case NETWORK_INDICATOR_IS_IN_SESSION_PROPERTY:
		g_value_set_boolean (value, network_indicator_get_is_in_session (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_indicator_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	NetworkIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_INDICATOR, NetworkIndicator);
	switch (property_id) {
		case NETWORK_INDICATOR_IS_IN_SESSION_PROPERTY:
		network_indicator_set_is_in_session (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

WingpanelIndicator*
get_indicator (GModule* module,
               WingpanelIndicatorManagerServerType server_type)
{
	NetworkIndicator* indicator = NULL;
	NetworkIndicator* _tmp0_;
	WingpanelIndicator* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Indicator.vala:234: Activating Network Indicator");
	_tmp0_ = network_indicator_new (server_type == WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION);
	indicator = _tmp0_;
	result = (WingpanelIndicator*) indicator;
	return result;
}

