#ifndef HEXAGON_TCG_FUNCS_H
#define HEXAGON_TCG_FUNCS_H

#include "idef-generated-emitter.h.inc"

static void generate_J2_jump(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int riV = insn->immed[0];
    fGEN_TCG_J2_jump({fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);});
}

static void generate_J2_jumpr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumpr({fJUMPR(RsN,RsV,COF_TYPE_JUMPR);});
}

static void generate_J2_jumprh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprh({fJUMPR(RsN,RsV,COF_TYPE_JUMPR);});
}

static void generate_J2_jumpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumpt({fBRANCH_SPECULATE_STALL(fLSBOLD(PuV),,SPECULATE_NOT_TAKEN,12,0); if (fLSBOLD(PuV)) { fIMMEXT(riV);fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);; }});
}

static void generate_J2_jumpf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumpf({fBRANCH_SPECULATE_STALL(fLSBOLDNOT(PuV),,SPECULATE_NOT_TAKEN,12,0); if (fLSBOLDNOT(PuV)) { fIMMEXT(riV);fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);; }});
}

static void generate_J2_jumptpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumptpt({fBRANCH_SPECULATE_STALL(fLSBOLD(PuV),,SPECULATE_TAKEN,12,0); if (fLSBOLD(PuV)) { fIMMEXT(riV);fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);; }});
}

static void generate_J2_jumpfpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumpfpt({fBRANCH_SPECULATE_STALL(fLSBOLDNOT(PuV),,SPECULATE_TAKEN,12,0); if (fLSBOLDNOT(PuV)) { fIMMEXT(riV);fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);; }});
}

static void generate_J2_jumprt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprt({fBRANCH_SPECULATE_STALL(fLSBOLD(PuV),,SPECULATE_NOT_TAKEN,12,0); if (fLSBOLD(PuV)) { fJUMPR(RsN,RsV,COF_TYPE_JUMPR);; }});
}

static void generate_J2_jumprf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprf({fBRANCH_SPECULATE_STALL(fLSBOLDNOT(PuV),,SPECULATE_NOT_TAKEN,12,0); if (fLSBOLDNOT(PuV)) { fJUMPR(RsN,RsV,COF_TYPE_JUMPR);; }});
}

static void generate_J2_jumprtpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprtpt({fBRANCH_SPECULATE_STALL(fLSBOLD(PuV),,SPECULATE_TAKEN,12,0); if (fLSBOLD(PuV)) { fJUMPR(RsN,RsV,COF_TYPE_JUMPR);; }});
}

static void generate_J2_jumprfpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprfpt({fBRANCH_SPECULATE_STALL(fLSBOLDNOT(PuV),,SPECULATE_TAKEN,12,0); if (fLSBOLDNOT(PuV)) { fJUMPR(RsN,RsV,COF_TYPE_JUMPR);; }});
}

static void generate_J2_jumptnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumptnew({fBRANCH_SPECULATE_STALL(fLSBNEW(PuN),, SPECULATE_NOT_TAKEN , 12,0)} {if(fLSBNEW(PuN)){fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMPNEW);;}});
}

static void generate_J2_jumpfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumpfnew({fBRANCH_SPECULATE_STALL(fLSBNEWNOT(PuN),, SPECULATE_NOT_TAKEN , 12,0)} {if(fLSBNEWNOT(PuN)){fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMPNEW);;}});
}

static void generate_J2_jumptnewpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumptnewpt({fBRANCH_SPECULATE_STALL(fLSBNEW(PuN),, SPECULATE_TAKEN , 12,0)} {if(fLSBNEW(PuN)){fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMPNEW);;}});
}

static void generate_J2_jumpfnewpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumpfnewpt({fBRANCH_SPECULATE_STALL(fLSBNEWNOT(PuN),, SPECULATE_TAKEN , 12,0)} {if(fLSBNEWNOT(PuN)){fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMPNEW);;}});
}

static void generate_J2_jumprtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprtnew({fBRANCH_SPECULATE_STALL(fLSBNEW(PuN),, SPECULATE_NOT_TAKEN , 12,0)} {if(fLSBNEW(PuN)){fJUMPR(RsN,RsV,COF_TYPE_JUMPR);;}});
}

static void generate_J2_jumprfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprfnew({fBRANCH_SPECULATE_STALL(fLSBNEWNOT(PuN),, SPECULATE_NOT_TAKEN , 12,0)} {if(fLSBNEWNOT(PuN)){fJUMPR(RsN,RsV,COF_TYPE_JUMPR);;}});
}

static void generate_J2_jumprtnewpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprtnewpt({fBRANCH_SPECULATE_STALL(fLSBNEW(PuN),, SPECULATE_TAKEN , 12,0)} {if(fLSBNEW(PuN)){fJUMPR(RsN,RsV,COF_TYPE_JUMPR);;}});
}

static void generate_J2_jumprfnewpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_jumprfnewpt({fBRANCH_SPECULATE_STALL(fLSBNEWNOT(PuN),, SPECULATE_TAKEN , 12,0)} {if(fLSBNEWNOT(PuN)){fJUMPR(RsN,RsV,COF_TYPE_JUMPR);;}});
}

static void generate_J4_hintjumpr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    emit_J4_hintjumpr(ctx, ctx->insn, ctx->pkt, RsV);
}

static void generate_J2_jumprz(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprz({fBRANCH_SPECULATE_STALL((RsV!=0), , SPECULATE_NOT_TAKEN,12,0) if (RsV != 0) { fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_jumprnz(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprnz({fBRANCH_SPECULATE_STALL((RsV==0), , SPECULATE_NOT_TAKEN,12,0) if (RsV == 0) {fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_jumprzpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprzpt({fBRANCH_SPECULATE_STALL((RsV!=0), , SPECULATE_TAKEN,12,0) if (RsV != 0) { fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_jumprnzpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprnzpt({fBRANCH_SPECULATE_STALL((RsV==0), , SPECULATE_TAKEN,12,0) if (RsV == 0) {fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_jumprgtez(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprgtez({fBRANCH_SPECULATE_STALL((RsV>=0), , SPECULATE_NOT_TAKEN,12,0) if (RsV>=0) { fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_jumprgtezpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprgtezpt({fBRANCH_SPECULATE_STALL((RsV>=0), , SPECULATE_TAKEN,12,0) if (RsV>=0) { fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_jumprltez(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprltez({fBRANCH_SPECULATE_STALL((RsV<=0), , SPECULATE_NOT_TAKEN,12,0) if (RsV<=0) { fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_jumprltezpt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_jumprltezpt({fBRANCH_SPECULATE_STALL((RsV<=0), , SPECULATE_TAKEN,12,0) if (RsV<=0) { fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV==UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>UiV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV==-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV>-1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV & 1)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV==RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((RsV>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_tp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_tp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_fp0_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_fp0_jump_nt({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_tp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_tp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0,,SPECULATE_TAKEN,13,0) if (fLSBNEW0) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_fp0_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_fp0_jump_t({fPART1(fWRITE_P0(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW0NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_tp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_tp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_fp1_jump_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_fp1_jump_nt({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_NOT_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_tp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_tp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1,,SPECULATE_TAKEN,13,0) if (fLSBNEW1) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_fp1_jump_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_fp1_jump_t({fPART1(fWRITE_P1(f8BITSOF((fCAST4u(RsV)>RtV)))) fBRANCH_SPECULATE_STALL(fLSBNEW1NOT,,SPECULATE_TAKEN,13,0) if (fLSBNEW1NOT) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_jumpseti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_jumpseti({fIMMEXT(riV); fPCALIGN(riV); RdV=UiV; fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_J4_jumpsetr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_jumpsetr({fIMMEXT(riV); fPCALIGN(riV); RdV=RsV; fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_J4_cmpeqi_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)==(UiV)),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)==(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)==(UiV)),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)==(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_f_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)!=(UiV)),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)!=(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqi_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqi_f_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)!=(UiV)),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)!=(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)>(UiV)),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)>(UiV)),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!(fNEWREG(NsN)>(UiV)),,SPECULATE_TAKEN,13,0);if (!(fNEWREG(NsN)>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgti_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgti_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!(fNEWREG(NsN)>(UiV)),,SPECULATE_NOT_TAKEN,13,0); if (!(fNEWREG(NsN)>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fCAST4u(fNEWREG(NsN))>(UiV)),,SPECULATE_TAKEN,13,0);if ((fCAST4u(fNEWREG(NsN))>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fCAST4u(fNEWREG(NsN))>(UiV)),,SPECULATE_NOT_TAKEN,13,0); if ((fCAST4u(fNEWREG(NsN))>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!(fCAST4u(fNEWREG(NsN))>(UiV)),,SPECULATE_TAKEN,13,0);if (!(fCAST4u(fNEWREG(NsN))>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtui_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int UiV = insn->immed[1];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtui_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!(fCAST4u(fNEWREG(NsN))>(UiV)),,SPECULATE_NOT_TAKEN,13,0); if (!(fCAST4u(fNEWREG(NsN))>(UiV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)==(-1)),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)==(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)==(-1)),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)==(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_f_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)!=(-1)),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)!=(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeqn1_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeqn1_f_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)!=(-1)),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)!=(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)>(-1)),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)>(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)>(-1)),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)>(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!(fNEWREG(NsN)>(-1)),,SPECULATE_TAKEN,13,0);if (!(fNEWREG(NsN)>(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtn1_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtn1_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!(fNEWREG(NsN)>(-1)),,SPECULATE_NOT_TAKEN,13,0); if (!(fNEWREG(NsN)>(-1))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_t_jumpnv_t({fBRANCH_SPECULATE_STALL(((fNEWREG(NsN)) & 1),,SPECULATE_TAKEN,13,0);if (((fNEWREG(NsN)) & 1)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_t_jumpnv_nt({fBRANCH_SPECULATE_STALL(((fNEWREG(NsN)) & 1),,SPECULATE_NOT_TAKEN,13,0); if (((fNEWREG(NsN)) & 1)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!((fNEWREG(NsN)) & 1),,SPECULATE_TAKEN,13,0);if (!((fNEWREG(NsN)) & 1)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_tstbit0_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_tstbit0_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!((fNEWREG(NsN)) & 1),,SPECULATE_NOT_TAKEN,13,0); if (!((fNEWREG(NsN)) & 1)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)==RtV),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)==RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)==RtV),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)==RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)>RtV),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)>RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)>RtV),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)>RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fCAST4u(fNEWREG(NsN))>fCAST4u(RtV)),,SPECULATE_TAKEN,13,0);if ((fCAST4u(fNEWREG(NsN))>fCAST4u(RtV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fCAST4u(fNEWREG(NsN))>fCAST4u(RtV)),,SPECULATE_NOT_TAKEN,13,0); if ((fCAST4u(fNEWREG(NsN))>fCAST4u(RtV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmplt_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmplt_t_jumpnv_t({fBRANCH_SPECULATE_STALL((RtV>fNEWREG(NsN)),,SPECULATE_TAKEN,13,0);if ((RtV>fNEWREG(NsN))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmplt_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmplt_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((RtV>fNEWREG(NsN)),,SPECULATE_NOT_TAKEN,13,0); if ((RtV>fNEWREG(NsN))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpltu_t_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpltu_t_jumpnv_t({fBRANCH_SPECULATE_STALL((fCAST4u(RtV)>fCAST4u(fNEWREG(NsN))),,SPECULATE_TAKEN,13,0);if ((fCAST4u(RtV)>fCAST4u(fNEWREG(NsN)))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpltu_t_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpltu_t_jumpnv_nt({fBRANCH_SPECULATE_STALL((fCAST4u(RtV)>fCAST4u(fNEWREG(NsN))),,SPECULATE_NOT_TAKEN,13,0); if ((fCAST4u(RtV)>fCAST4u(fNEWREG(NsN)))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_f_jumpnv_t({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)!=RtV),,SPECULATE_TAKEN,13,0);if ((fNEWREG(NsN)!=RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpeq_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpeq_f_jumpnv_nt({fBRANCH_SPECULATE_STALL((fNEWREG(NsN)!=RtV),,SPECULATE_NOT_TAKEN,13,0); if ((fNEWREG(NsN)!=RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!(fNEWREG(NsN)>RtV),,SPECULATE_TAKEN,13,0);if (!(fNEWREG(NsN)>RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgt_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgt_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!(fNEWREG(NsN)>RtV),,SPECULATE_NOT_TAKEN,13,0); if (!(fNEWREG(NsN)>RtV)) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!(fCAST4u(fNEWREG(NsN))>fCAST4u(RtV)),,SPECULATE_TAKEN,13,0);if (!(fCAST4u(fNEWREG(NsN))>fCAST4u(RtV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpgtu_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv NsN = get_result_gpr(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpgtu_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!(fCAST4u(fNEWREG(NsN))>fCAST4u(RtV)),,SPECULATE_NOT_TAKEN,13,0); if (!(fCAST4u(fNEWREG(NsN))>fCAST4u(RtV))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmplt_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmplt_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!(RtV>fNEWREG(NsN)),,SPECULATE_TAKEN,13,0);if (!(RtV>fNEWREG(NsN))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmplt_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmplt_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!(RtV>fNEWREG(NsN)),,SPECULATE_NOT_TAKEN,13,0); if (!(RtV>fNEWREG(NsN))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpltu_f_jumpnv_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpltu_f_jumpnv_t({fBRANCH_SPECULATE_STALL(!(fCAST4u(RtV)>fCAST4u(fNEWREG(NsN))),,SPECULATE_TAKEN,13,0);if (!(fCAST4u(RtV)>fCAST4u(fNEWREG(NsN)))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J4_cmpltu_f_jumpnv_nt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    TCGv NsN = get_result_gpr(ctx, insn->regno[1]);
    int riV = insn->immed[0];
    fGEN_TCG_J4_cmpltu_f_jumpnv_nt({fBRANCH_SPECULATE_STALL(!(fCAST4u(RtV)>fCAST4u(fNEWREG(NsN))),,SPECULATE_NOT_TAKEN,13,0); if (!(fCAST4u(RtV)>fCAST4u(fNEWREG(NsN)))) {fIMMEXT(riV); fPCALIGN(riV); fBRANCH(fREAD_PC()+riV,COF_TYPE_JUMP);}});
}

static void generate_J2_call(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int riV = insn->immed[0];
    fGEN_TCG_J2_call({fIMMEXT(riV); fPCALIGN(riV); fCALL(fREAD_PC()+riV); });
}

static void generate_J2_callt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_callt({fIMMEXT(riV); fPCALIGN(riV); fBRANCH_SPECULATE_STALL(fLSBOLD(PuV),,SPECULATE_NOT_TAKEN,12,0); if (fLSBOLD(PuV)) { fCALL(fREAD_PC()+riV); }});
}

static void generate_J2_callf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    int riV = insn->immed[0];
    fGEN_TCG_J2_callf({fIMMEXT(riV); fPCALIGN(riV); fBRANCH_SPECULATE_STALL(fLSBOLDNOT(PuV),,SPECULATE_NOT_TAKEN,12,0);if (fLSBOLDNOT(PuV)) { fCALL(fREAD_PC()+riV); }});
}

static void generate_J2_callr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_callr({ fCALLR(RsV); });
}

static void generate_J2_callrt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_callrt({fBRANCH_SPECULATE_STALL(fLSBOLD(PuV),,SPECULATE_NOT_TAKEN,12,0);if (fLSBOLD(PuV)) { fCALLR(RsV); }});
}

static void generate_J2_callrf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_callrf({fBRANCH_SPECULATE_STALL(fLSBOLDNOT(PuV),,SPECULATE_NOT_TAKEN,12,0);if (fLSBOLDNOT(PuV)) { fCALLR(RsV); }});
}

static void generate_J2_callrh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_J2_callrh({ fCALLR(RsV); });
}

static void generate_J2_loop0r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    emit_J2_loop0r(ctx, ctx->insn, ctx->pkt, RsV, riV);
}

static void generate_J2_loop1r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    emit_J2_loop1r(ctx, ctx->insn, ctx->pkt, RsV, riV);
}

static void generate_J2_loop0i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_J2_loop0i(ctx, ctx->insn, ctx->pkt, riV, UiV);
}

static void generate_J2_loop1i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_J2_loop1i(ctx, ctx->insn, ctx->pkt, riV, UiV);
}

static void generate_J2_ploop1sr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    emit_J2_ploop1sr(ctx, ctx->insn, ctx->pkt, RsV, riV);
}

static void generate_J2_ploop1si(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_J2_ploop1si(ctx, ctx->insn, ctx->pkt, riV, UiV);
}

static void generate_J2_ploop2sr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    emit_J2_ploop2sr(ctx, ctx->insn, ctx->pkt, RsV, riV);
}

static void generate_J2_ploop2si(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_J2_ploop2si(ctx, ctx->insn, ctx->pkt, riV, UiV);
}

static void generate_J2_ploop3sr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int riV = insn->immed[0];
    emit_J2_ploop3sr(ctx, ctx->insn, ctx->pkt, RsV, riV);
}

static void generate_J2_ploop3si(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int riV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_J2_ploop3si(ctx, ctx->insn, ctx->pkt, riV, UiV);
}

static void generate_J2_endloop01(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_J2_endloop01({ if (fGET_LPCFG) { fHIDE( if (fGET_LPCFG >= 2) { } else ) if (fGET_LPCFG==1) { fWRITE_P3(0xff); } fSET_LPCFG(fGET_LPCFG-1); } if (fREAD_LC0>1) { fBRANCH(fREAD_SA0,COF_TYPE_LOOPEND0); fWRITE_LC0(fREAD_LC0-1); } else { if (fREAD_LC1>1) { fBRANCH(fREAD_SA1,COF_TYPE_LOOPEND1); fWRITE_LC1(fREAD_LC1-1); } } });
}

static void generate_J2_endloop0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_J2_endloop0({ if (fGET_LPCFG) { fHIDE( if (fGET_LPCFG >= 2) { } else ) if (fGET_LPCFG==1) { fWRITE_P3(0xff); } fSET_LPCFG(fGET_LPCFG-1); } if (fREAD_LC0>1) { fBRANCH(fREAD_SA0,COF_TYPE_LOOPEND0); fWRITE_LC0(fREAD_LC0-1); } });
}

static void generate_J2_endloop1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_J2_endloop1({ if (fREAD_LC1>1) { fBRANCH(fREAD_SA1,COF_TYPE_LOOPEND1); fWRITE_LC1(fREAD_LC1-1); } });
}

static void generate_L2_loadrub_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadrub_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrub_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadrub_ur(ctx, ctx->insn, ctx->pkt, RdV, RtV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrub_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadrub_ap(ctx, ctx->insn, ctx->pkt, RdV, ReV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadrub_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrub_pr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrub_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrub_pbr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrub_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadrub_pi(ctx, ctx->insn, ctx->pkt, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrub_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadrub_pci(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrub_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrub_pcr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadrb_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrb_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadrb_ur(ctx, ctx->insn, ctx->pkt, RdV, RtV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrb_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadrb_ap(ctx, ctx->insn, ctx->pkt, RdV, ReV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadrb_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrb_pr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrb_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrb_pbr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrb_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadrb_pi(ctx, ctx->insn, ctx->pkt, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrb_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadrb_pci(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrb_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrb_pcr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadruh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadruh_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadruh_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadruh_ur(ctx, ctx->insn, ctx->pkt, RdV, RtV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadruh_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadruh_ap(ctx, ctx->insn, ctx->pkt, RdV, ReV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadruh_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadruh_pr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadruh_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadruh_pbr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadruh_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadruh_pi(ctx, ctx->insn, ctx->pkt, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadruh_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadruh_pci(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadruh_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadruh_pcr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadrh_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrh_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadrh_ur(ctx, ctx->insn, ctx->pkt, RdV, RtV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrh_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadrh_ap(ctx, ctx->insn, ctx->pkt, RdV, ReV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadrh_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrh_pr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrh_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrh_pbr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrh_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadrh_pi(ctx, ctx->insn, ctx->pkt, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrh_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadrh_pci(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrh_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrh_pcr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadri_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadri_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadri_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadri_ur(ctx, ctx->insn, ctx->pkt, RdV, RtV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadri_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadri_ap(ctx, ctx->insn, ctx->pkt, RdV, ReV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadri_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadri_pr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadri_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadri_pbr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadri_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadri_pi(ctx, ctx->insn, ctx->pkt, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadri_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadri_pci(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadri_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadri_pcr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrd_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadrd_io(ctx, ctx->insn, ctx->pkt, RddV, RsV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_loadrd_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadrd_ur(ctx, ctx->insn, ctx->pkt, RddV, RtV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_loadrd_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadrd_ap(ctx, ctx->insn, ctx->pkt, RddV, ReV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadrd_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrd_pr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrd_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrd_pbr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrd_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadrd_pi(ctx, ctx->insn, ctx->pkt, RddV, RxV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrd_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadrd_pci(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadrd_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadrd_pcr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw2_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadbzw2_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadbzw2_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadbzw2_ur(ctx, ctx->insn, ctx->pkt, RdV, RtV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadbzw2_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadbzw2_ap(ctx, ctx->insn, ctx->pkt, RdV, ReV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadbzw2_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbzw2_pr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw2_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbzw2_pbr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw2_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadbzw2_pi(ctx, ctx->insn, ctx->pkt, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw2_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadbzw2_pci(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw2_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbzw2_pcr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw4_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadbzw4_io(ctx, ctx->insn, ctx->pkt, RddV, RsV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_loadbzw4_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadbzw4_ur(ctx, ctx->insn, ctx->pkt, RddV, RtV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_loadbzw4_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadbzw4_ap(ctx, ctx->insn, ctx->pkt, RddV, ReV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadbzw4_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbzw4_pr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw4_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbzw4_pbr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw4_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadbzw4_pi(ctx, ctx->insn, ctx->pkt, RddV, RxV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw4_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadbzw4_pci(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbzw4_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbzw4_pcr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw2_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadbsw2_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadbsw2_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadbsw2_ur(ctx, ctx->insn, ctx->pkt, RdV, RtV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadbsw2_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadbsw2_ap(ctx, ctx->insn, ctx->pkt, RdV, ReV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadbsw2_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbsw2_pr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw2_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbsw2_pbr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw2_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadbsw2_pi(ctx, ctx->insn, ctx->pkt, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw2_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadbsw2_pci(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw2_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbsw2_pcr(ctx, ctx->insn, ctx->pkt, RdV, RxV, MuV, CS);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw4_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadbsw4_io(ctx, ctx->insn, ctx->pkt, RddV, RsV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_loadbsw4_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadbsw4_ur(ctx, ctx->insn, ctx->pkt, RddV, RtV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_loadbsw4_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadbsw4_ap(ctx, ctx->insn, ctx->pkt, RddV, ReV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadbsw4_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbsw4_pr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw4_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbsw4_pbr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw4_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadbsw4_pi(ctx, ctx->insn, ctx->pkt, RddV, RxV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw4_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadbsw4_pci(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadbsw4_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadbsw4_pcr(ctx, ctx->insn, ctx->pkt, RddV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadalignh_io(ctx, ctx->insn, ctx->pkt, RyyV, RsV, siV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
}

static void generate_L4_loadalignh_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadalignh_ur(ctx, ctx->insn, ctx->pkt, RyyV, RtV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
}

static void generate_L4_loadalignh_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadalignh_ap(ctx, ctx->insn, ctx->pkt, RyyV, ReV, UiV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadalignh_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadalignh_pr(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignh_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadalignh_pbr(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignh_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadalignh_pi(ctx, ctx->insn, ctx->pkt, RyyV, RxV, siV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignh_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadalignh_pci(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS, siV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignh_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadalignh_pcr(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_L2_loadalignb_io(ctx, ctx->insn, ctx->pkt, RyyV, RsV, siV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
}

static void generate_L4_loadalignb_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_loadalignb_ur(ctx, ctx->insn, ctx->pkt, RyyV, RtV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
}

static void generate_L4_loadalignb_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int ReN = insn->regno[1];
    TCGv ReV = get_result_gpr(ctx, ReN);
    int UiV = insn->immed[1];
    emit_L4_loadalignb_ap(ctx, ctx->insn, ctx->pkt, RyyV, ReV, UiV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_L2_loadalignb_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadalignb_pr(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignb_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadalignb_pbr(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignb_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_L2_loadalignb_pi(ctx, ctx->insn, ctx->pkt, RyyV, RxV, siV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignb_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    int siV = insn->immed[0];
    emit_L2_loadalignb_pci(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS, siV);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadalignb_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RyyN = insn->regno[0];
    TCGv_i64 RyyV =
        get_result_gpr_pair(ctx, RyyN);
    tcg_gen_concat_i32_i64(RyyV,
                           hex_gpr[RyyN],
                           hex_gpr[RyyN + 1]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    emit_L2_loadalignb_pcr(ctx, ctx->insn, ctx->pkt, RyyV, RxV, MuV, CS);
    gen_log_reg_write_pair(ctx, RyyN, RyyV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerb_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, siV);
}

static void generate_S2_storerb_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerb_pi(ctx, ctx->insn, ctx->pkt, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerb_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int UiV = insn->immed[1];
    emit_S4_storerb_ap(ctx, ctx->insn, ctx->pkt, ReV, RtV, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storerb_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerb_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerb_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storerb_ur(ctx, ctx->insn, ctx->pkt, RuV, RtV, uiV, UiV);
}

static void generate_S2_storerb_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerb_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerb_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerb_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerb_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerb_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerh_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, siV);
}

static void generate_S2_storerh_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerh_pi(ctx, ctx->insn, ctx->pkt, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerh_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int UiV = insn->immed[1];
    emit_S4_storerh_ap(ctx, ctx->insn, ctx->pkt, ReV, RtV, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storerh_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerh_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerh_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storerh_ur(ctx, ctx->insn, ctx->pkt, RuV, RtV, uiV, UiV);
}

static void generate_S2_storerh_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerh_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerh_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerh_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerh_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerh_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerf_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, siV);
}

static void generate_S2_storerf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerf_pi(ctx, ctx->insn, ctx->pkt, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerf_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int UiV = insn->immed[1];
    emit_S4_storerf_ap(ctx, ctx->insn, ctx->pkt, ReV, RtV, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storerf_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerf_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerf_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storerf_ur(ctx, ctx->insn, ctx->pkt, RuV, RtV, uiV, UiV);
}

static void generate_S2_storerf_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerf_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerf_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storerf_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerf_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storerf_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storeri_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storeri_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, siV);
}

static void generate_S2_storeri_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storeri_pi(ctx, ctx->insn, ctx->pkt, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storeri_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int UiV = insn->immed[1];
    emit_S4_storeri_ap(ctx, ctx->insn, ctx->pkt, ReV, RtV, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storeri_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storeri_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storeri_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storeri_ur(ctx, ctx->insn, ctx->pkt, RuV, RtV, uiV, UiV);
}

static void generate_S2_storeri_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storeri_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storeri_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_storeri_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storeri_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storeri_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerd_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_S2_storerd_io(ctx, ctx->insn, ctx->pkt, RsV, RttV, siV);
}

static void generate_S2_storerd_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_S2_storerd_pi(ctx, ctx->insn, ctx->pkt, RxV, RttV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerd_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int UiV = insn->immed[1];
    emit_S4_storerd_ap(ctx, ctx->insn, ctx->pkt, ReV, RttV, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storerd_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_storerd_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RttV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerd_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storerd_ur(ctx, ctx->insn, ctx->pkt, RuV, RttV, uiV, UiV);
}

static void generate_S2_storerd_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_storerd_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RttV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerd_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_S2_storerd_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RttV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerd_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_storerd_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, RttV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerinew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int siV = insn->immed[0];
    emit_S2_storerinew_io(ctx, ctx->insn, ctx->pkt, RsV, NtN, siV);
}

static void generate_S2_storerinew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int siV = insn->immed[0];
    emit_S2_storerinew_pi(ctx, ctx->insn, ctx->pkt, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerinew_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int UiV = insn->immed[1];
    emit_S4_storerinew_ap(ctx, ctx->insn, ctx->pkt, ReV, NtN, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storerinew_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerinew_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerinew_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storerinew_ur(ctx, ctx->insn, ctx->pkt, RuV, NtN, uiV, UiV);
}

static void generate_S2_storerinew_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerinew_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerinew_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_storerinew_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerinew_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerinew_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerbnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int siV = insn->immed[0];
    emit_S2_storerbnew_io(ctx, ctx->insn, ctx->pkt, RsV, NtN, siV);
}

static void generate_S2_storerbnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int siV = insn->immed[0];
    emit_S2_storerbnew_pi(ctx, ctx->insn, ctx->pkt, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerbnew_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int UiV = insn->immed[1];
    emit_S4_storerbnew_ap(ctx, ctx->insn, ctx->pkt, ReV, NtN, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storerbnew_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerbnew_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerbnew_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storerbnew_ur(ctx, ctx->insn, ctx->pkt, RuV, NtN, uiV, UiV);
}

static void generate_S2_storerbnew_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerbnew_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerbnew_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_storerbnew_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerbnew_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerbnew_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerhnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int siV = insn->immed[0];
    emit_S2_storerhnew_io(ctx, ctx->insn, ctx->pkt, RsV, NtN, siV);
}

static void generate_S2_storerhnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int siV = insn->immed[0];
    emit_S2_storerhnew_pi(ctx, ctx->insn, ctx->pkt, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerhnew_ap(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int ReN = insn->regno[0];
    TCGv ReV = get_result_gpr(ctx, ReN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int UiV = insn->immed[1];
    emit_S4_storerhnew_ap(ctx, ctx->insn, ctx->pkt, ReV, NtN, UiV);
    gen_log_reg_write(ctx, ReN, ReV);
}

static void generate_S2_storerhnew_pr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerhnew_pr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_storerhnew_ur(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RuN = insn->regno[0];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_storerhnew_ur(ctx, ctx->insn, ctx->pkt, RuV, NtN, uiV, UiV);
}

static void generate_S2_storerhnew_pbr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerhnew_pbr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerhnew_pci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_storerhnew_pci(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_storerhnew_pcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    emit_S2_storerhnew_pcr(ctx, ctx->insn, ctx->pkt, RxV, MuV, CS, NtN);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_allocframe(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    emit_S2_allocframe(ctx, ctx->insn, ctx->pkt, RxV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_loadw_aq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_L2_loadw_aq(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadd_aq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_L4_loadd_aq(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_R6_release_at_vi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_R6_release_at_vi({fEA_REG(RsV); fSTORE(1,0,EA,RsV); });
}

static void generate_R6_release_st_vi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_R6_release_st_vi({fEA_REG(RsV); fSTORE(1,0,EA,RsV); });
}

static void generate_S2_storew_rl_at_vi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storew_rl_at_vi(ctx, ctx->insn, ctx->pkt, RsV, RtV);
}

static void generate_S4_stored_rl_at_vi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_stored_rl_at_vi(ctx, ctx->insn, ctx->pkt, RsV, RttV);
}

static void generate_S2_storew_rl_st_vi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_storew_rl_st_vi(ctx, ctx->insn, ctx->pkt, RsV, RtV);
}

static void generate_S4_stored_rl_st_vi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_stored_rl_st_vi(ctx, ctx->insn, ctx->pkt, RsV, RttV);
}

static void generate_L2_deallocframe(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_L2_deallocframe(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_return(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_return({ fHIDE(size8u_t tmp;) fEA_REG(RsV); fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,RddV),COF_TYPE_JUMPR);});
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_return_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_return_t({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBOLD(PvV),,SPECULATE_NOT_TAKEN,7,0); fEA_REG(RsV); if (fLSBOLD(PvV)) { fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,RddV),COF_TYPE_JUMPR); } else { LOAD_CANCEL(EA); } });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_return_f(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_return_f({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBOLDNOT(PvV),,SPECULATE_NOT_TAKEN,7,0); fEA_REG(RsV); if (fLSBOLDNOT(PvV)) { fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,RddV),COF_TYPE_JUMPR); } else { LOAD_CANCEL(EA); } });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_return_tnew_pt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_return_tnew_pt({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBNEW(PvN),,SPECULATE_TAKEN,12,0); fEA_REG(RsV); if (fLSBNEW(PvN)) { fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,RddV),COF_TYPE_JUMPR); } else { LOAD_CANCEL(EA); } });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_return_fnew_pt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_return_fnew_pt({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBNEWNOT(PvN),,SPECULATE_TAKEN,12,0); fEA_REG(RsV); if (fLSBNEWNOT(PvN)) { fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,RddV),COF_TYPE_JUMPR); } else { LOAD_CANCEL(EA); } });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_return_tnew_pnt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_return_tnew_pnt({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBNEW(PvN),,SPECULATE_NOT_TAKEN,12,0); fEA_REG(RsV); if (fLSBNEW(PvN)) { fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,RddV),COF_TYPE_JUMPR); } else { LOAD_CANCEL(EA); } });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_return_fnew_pnt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_return_fnew_pnt({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBNEWNOT(PvN),,SPECULATE_NOT_TAKEN,12,0); fEA_REG(RsV); if (fLSBNEWNOT(PvN)) { fLOAD(1,8,u,EA,tmp); RddV = fFRAME_UNSCRAMBLE(tmp); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,RddV),COF_TYPE_JUMPR); } else { LOAD_CANCEL(EA); } });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L2_loadw_locked(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L2_loadw_locked({ fEA_REG(RsV); fLOAD_LOCKED(1,4,u,EA,RdV) });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_storew_locked(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int PdN = insn->regno[1];
    TCGv PdV = tcg_temp_new();
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_S2_storew_locked({ fEA_REG(RsV); fSTORE_LOCKED(1,4,EA,RtV,PdV) });
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_L4_loadd_locked(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_L4_loadd_locked({ fEA_REG(RsV); fLOAD_LOCKED(1,8,u,EA,RddV) });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_stored_locked(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int PdN = insn->regno[1];
    TCGv PdV = tcg_temp_new();
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_S4_stored_locked({ fEA_REG(RsV); fSTORE_LOCKED(1,8,EA,RttV,PdV) });
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_L4_loadrub_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_loadrub_rr(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrubt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrubt_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrubt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrubt_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrubf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrubf_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrubf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrubf_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrubtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrubtnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrubfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrubfnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrubt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrubt_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrubf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrubf_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrubtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrubtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrubfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrubfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrubtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrubtnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrubfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrubfnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L4_ploadrubt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrubt_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrubf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrubf_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrubtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrubtnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrubfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrubfnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrb_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_loadrb_rr(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrbt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrbt_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrbt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrbt_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrbf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrbf_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrbf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrbf_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrbtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrbtnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrbfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrbfnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrbt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrbt_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrbf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrbf_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrbtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrbtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrbfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrbfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrbtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrbtnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrbfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrbfnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L4_ploadrbt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrbt_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrbf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrbf_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrbtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrbtnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrbfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrbfnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadruh_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_loadruh_rr(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadruht_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadruht_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadruht_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadruht_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadruhf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadruhf_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadruhf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadruhf_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadruhtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadruhtnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadruhfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadruhfnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadruht_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadruht_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadruhf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadruhf_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadruhtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadruhtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadruhfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadruhfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadruhtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadruhtnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadruhfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadruhfnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L4_ploadruht_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadruht_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadruhf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadruhf_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadruhtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadruhtnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadruhfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadruhfnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrh_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_loadrh_rr(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrht_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrht_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrht_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrht_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrhf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrhf_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrhf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrhf_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrhtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrhtnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrhfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrhfnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrht_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrht_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrhf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrhf_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrhtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrhtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrhfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrhfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrhtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrhtnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrhfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrhfnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L4_ploadrht_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrht_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrhf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrhf_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrhtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrhtnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrhfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrhfnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadri_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_loadri_rr(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrit_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrit_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrit_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrit_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrif_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrif_io(ctx, ctx->insn, ctx->pkt, PtV, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrif_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrif_pi(ctx, ctx->insn, ctx->pkt, PtV, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadritnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadritnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadrifnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrifnew_io(ctx, ctx->insn, ctx->pkt, PtN, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrit_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrit_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrif_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrif_rr(ctx, ctx->insn, ctx->pkt, PvV, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadritnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadritnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrifnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrifnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_ploadritnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadritnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrifnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrifnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RdV, RxV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L4_ploadrit_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrit_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrif_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrif_abs(ctx, ctx->insn, ctx->pkt, PtV, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadritnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadritnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_ploadrifnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L4_ploadrifnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L4_loadrd_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_loadrd_rr(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L2_ploadrdt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrdt_io(ctx, ctx->insn, ctx->pkt, PtV, RddV, RsV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L2_ploadrdt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrdt_pi(ctx, ctx->insn, ctx->pkt, PtV, RddV, RxV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrdf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrdf_io(ctx, ctx->insn, ctx->pkt, PtV, RddV, RsV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L2_ploadrdf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrdf_pi(ctx, ctx->insn, ctx->pkt, PtV, RddV, RxV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrdtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrdtnew_io(ctx, ctx->insn, ctx->pkt, PtN, RddV, RsV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L2_ploadrdfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_L2_ploadrdfnew_io(ctx, ctx->insn, ctx->pkt, PtN, RddV, RsV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_ploadrdt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrdt_rr(ctx, ctx->insn, ctx->pkt, PvV, RddV, RsV, RtV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_ploadrdf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrdf_rr(ctx, ctx->insn, ctx->pkt, PvV, RddV, RsV, RtV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_ploadrdtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrdtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RddV, RsV, RtV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_ploadrdfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_ploadrdfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RddV, RsV, RtV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L2_ploadrdtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrdtnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RddV, RxV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L2_ploadrdfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    emit_L2_ploadrdfnew_pi(ctx, ctx->insn, ctx->pkt, PtN, RddV, RxV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_L4_ploadrdt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_L4_ploadrdt_abs(ctx, ctx->insn, ctx->pkt, PtV, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_ploadrdf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PtN = insn->regno[0];
    TCGv PtV = hex_pred[PtN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_L4_ploadrdf_abs(ctx, ctx->insn, ctx->pkt, PtV, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_ploadrdtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_L4_ploadrdtnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_L4_ploadrdfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PtN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_L4_ploadrdfnew_abs(ctx, ctx->insn, ctx->pkt, PtN, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_storerb_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_storerb_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstorerbt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerbt_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerbt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerbt_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerbf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerbf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerbf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerbf_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerbt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbt_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerbf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbf_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerbtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstorerbfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstorerbtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerbfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstorerbtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerbtnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerbfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerbfnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerbt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbt_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstorerbf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbf_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstorerbtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbtnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_pstorerbfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerbfnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_storerh_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_storerh_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstorerht_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerht_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerht_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerht_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerhf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerhf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerhf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerhf_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerht_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerht_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerhf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhf_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerhtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstorerhfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstorerhtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerhfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstorerhtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerhtnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerhfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerhfnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerht_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerht_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstorerhf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhf_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstorerhtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhtnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_pstorerhfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerhfnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_storerf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_storerf_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstorerft_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerft_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerft_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerft_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerff_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerff_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerff_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerff_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerft_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerft_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerff_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerff_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerftnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerftnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstorerffnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerffnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstorerftnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerftnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerffnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerffnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstorerftnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerftnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerffnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerffnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerft_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerft_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstorerff_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerff_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstorerftnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerftnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_pstorerffnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerffnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_storeri_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_storeri_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstorerit_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerit_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerit_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerit_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerif_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_pstorerif_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RtV, uiV);
}

static void generate_S2_pstorerif_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerif_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerit_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerit_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerif_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerif_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstoreritnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstoreritnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstorerifnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerifnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RtV, uiV);
}

static void generate_S4_pstoreritnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstoreritnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S4_pstorerifnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerifnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RtV, uiV);
}

static void generate_S2_pstoreritnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstoreritnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerifnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S2_pstorerifnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RtV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerit_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerit_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstorerif_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerif_abs(ctx, ctx->insn, ctx->pkt, PvV, RtV, uiV);
}

static void generate_S4_pstoreritnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstoreritnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_pstorerifnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S4_pstorerifnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RtV, uiV);
}

static void generate_S4_storerd_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_storerd_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, RttV, uiV);
}

static void generate_S2_pstorerdt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S2_pstorerdt_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RttV, uiV);
}

static void generate_S2_pstorerdt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_S2_pstorerdt_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RttV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerdf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S2_pstorerdf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, RttV, uiV);
}

static void generate_S2_pstorerdf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_S2_pstorerdf_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, RttV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerdt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RttN = insn->regno[3];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdt_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RttV, uiV);
}

static void generate_S4_pstorerdf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RttN = insn->regno[3];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdf_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, RttV, uiV);
}

static void generate_S4_pstorerdtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RttV, uiV);
}

static void generate_S4_pstorerdfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, RttV, uiV);
}

static void generate_S4_pstorerdtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RttN = insn->regno[3];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RttV, uiV);
}

static void generate_S4_pstorerdfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    const int RttN = insn->regno[3];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, RttV, uiV);
}

static void generate_S2_pstorerdtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_S2_pstorerdtnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RttV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerdfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_S2_pstorerdfnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, RttV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerdt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdt_abs(ctx, ctx->insn, ctx->pkt, PvV, RttV, uiV);
}

static void generate_S4_pstorerdf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdf_abs(ctx, ctx->insn, ctx->pkt, PvV, RttV, uiV);
}

static void generate_S4_pstorerdtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdtnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RttV, uiV);
}

static void generate_S4_pstorerdfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerdfnew_abs(ctx, ctx->insn, ctx->pkt, PvN, RttV, uiV);
}

static void generate_S4_storerinew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_storerinew_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, NtN, uiV);
}

static void generate_S2_pstorerinewt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S2_pstorerinewt_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, NtN, uiV);
}

static void generate_S2_pstorerinewt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerinewt_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerinewf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S2_pstorerinewf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, NtN, uiV);
}

static void generate_S2_pstorerinewf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerinewf_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerinewt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewt_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerinewf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewf_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerinewtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, NtN, uiV);
}

static void generate_S4_pstorerinewfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, NtN, uiV);
}

static void generate_S4_pstorerinewtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerinewfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, NtN, uiV);
}

static void generate_S2_pstorerinewtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerinewtnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerinewfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerinewfnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerinewt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewt_abs(ctx, ctx->insn, ctx->pkt, PvV, NtN, uiV);
}

static void generate_S4_pstorerinewf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewf_abs(ctx, ctx->insn, ctx->pkt, PvV, NtN, uiV);
}

static void generate_S4_pstorerinewtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewtnew_abs(ctx, ctx->insn, ctx->pkt, PvN, NtN, uiV);
}

static void generate_S4_pstorerinewfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerinewfnew_abs(ctx, ctx->insn, ctx->pkt, PvN, NtN, uiV);
}

static void generate_S4_storerbnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_storerbnew_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, NtN, uiV);
}

static void generate_S2_pstorerbnewt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S2_pstorerbnewt_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, NtN, uiV);
}

static void generate_S2_pstorerbnewt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerbnewt_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerbnewf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S2_pstorerbnewf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, NtN, uiV);
}

static void generate_S2_pstorerbnewf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerbnewf_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerbnewt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewt_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerbnewf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewf_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerbnewtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, NtN, uiV);
}

static void generate_S4_pstorerbnewfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, NtN, uiV);
}

static void generate_S4_pstorerbnewtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerbnewfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, NtN, uiV);
}

static void generate_S2_pstorerbnewtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerbnewtnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerbnewfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerbnewfnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerbnewt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewt_abs(ctx, ctx->insn, ctx->pkt, PvV, NtN, uiV);
}

static void generate_S4_pstorerbnewf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewf_abs(ctx, ctx->insn, ctx->pkt, PvV, NtN, uiV);
}

static void generate_S4_pstorerbnewtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewtnew_abs(ctx, ctx->insn, ctx->pkt, PvN, NtN, uiV);
}

static void generate_S4_pstorerbnewfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerbnewfnew_abs(ctx, ctx->insn, ctx->pkt, PvN, NtN, uiV);
}

static void generate_S4_storerhnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_storerhnew_rr(ctx, ctx->insn, ctx->pkt, RsV, RuV, NtN, uiV);
}

static void generate_S2_pstorerhnewt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S2_pstorerhnewt_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, NtN, uiV);
}

static void generate_S2_pstorerhnewt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerhnewt_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerhnewf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S2_pstorerhnewf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, NtN, uiV);
}

static void generate_S2_pstorerhnewf_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerhnewf_pi(ctx, ctx->insn, ctx->pkt, PvV, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerhnewt_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewt_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerhnewf_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewf_rr(ctx, ctx->insn, ctx->pkt, PvV, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerhnewtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, NtN, uiV);
}

static void generate_S4_pstorerhnewfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, NtN, uiV);
}

static void generate_S4_pstorerhnewtnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewtnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, NtN, uiV);
}

static void generate_S4_pstorerhnewfnew_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[3]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewfnew_rr(ctx, ctx->insn, ctx->pkt, PvN, RsV, RuV, NtN, uiV);
}

static void generate_S2_pstorerhnewtnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerhnewtnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_pstorerhnewfnew_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    TCGv NtN = get_result_gpr(ctx, insn->regno[2]);
    int siV = insn->immed[0];
    emit_S2_pstorerhnewfnew_pi(ctx, ctx->insn, ctx->pkt, PvN, RxV, NtN, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_pstorerhnewt_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewt_abs(ctx, ctx->insn, ctx->pkt, PvV, NtN, uiV);
}

static void generate_S4_pstorerhnewf_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewf_abs(ctx, ctx->insn, ctx->pkt, PvV, NtN, uiV);
}

static void generate_S4_pstorerhnewtnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewtnew_abs(ctx, ctx->insn, ctx->pkt, PvN, NtN, uiV);
}

static void generate_S4_pstorerhnewfnew_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    TCGv NtN = get_result_gpr(ctx, insn->regno[1]);
    int uiV = insn->immed[0];
    emit_S4_pstorerhnewfnew_abs(ctx, ctx->insn, ctx->pkt, PvN, NtN, uiV);
}

static void generate_L4_add_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_add_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_add_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_add_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_add_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_add_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_sub_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_sub_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_sub_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_sub_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_sub_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_sub_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_and_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_and_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_and_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_and_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_and_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_and_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_or_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_or_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_or_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_or_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_or_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_L4_or_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_L4_iadd_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_iadd_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_iadd_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_iadd_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_iadd_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_iadd_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_isub_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_isub_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_isub_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_isub_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_isub_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_isub_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_iand_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_iand_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_iand_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_iand_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_iand_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_iand_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_ior_memopw_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_ior_memopw_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_ior_memopb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_ior_memopb_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_L4_ior_memoph_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_L4_ior_memoph_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, UiV);
}

static void generate_S4_storeirbt_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirbt_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, uiV, SiV);
}

static void generate_S4_storeirbf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirbf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, uiV, SiV);
}

static void generate_S4_storeirbtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirbtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, uiV, SiV);
}

static void generate_S4_storeirbfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirbfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, uiV, SiV);
}

static void generate_S4_storeirht_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirht_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, uiV, SiV);
}

static void generate_S4_storeirhf_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirhf_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, uiV, SiV);
}

static void generate_S4_storeirhtnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirhtnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, uiV, SiV);
}

static void generate_S4_storeirhfnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirhfnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, uiV, SiV);
}

static void generate_S4_storeirit_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirit_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, uiV, SiV);
}

static void generate_S4_storeirif_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirif_io(ctx, ctx->insn, ctx->pkt, PvV, RsV, uiV, SiV);
}

static void generate_S4_storeiritnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeiritnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, uiV, SiV);
}

static void generate_S4_storeirifnew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv PvN = get_result_pred(ctx, insn->regno[0]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirifnew_io(ctx, ctx->insn, ctx->pkt, PvN, RsV, uiV, SiV);
}

static void generate_S4_storeirb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirb_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, SiV);
}

static void generate_S4_storeirh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeirh_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, SiV);
}

static void generate_S4_storeiri_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S4_storeiri_io(ctx, ctx->insn, ctx->pkt, RsV, uiV, SiV);
}

static void generate_L2_loadrubgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L2_loadrubgp(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_loadrbgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L2_loadrbgp(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_loadruhgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L2_loadruhgp(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_loadrhgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L2_loadrhgp(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_loadrigp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_L2_loadrigp(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_L2_loadrdgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_L2_loadrdgp(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_storerbgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_storerbgp(ctx, ctx->insn, ctx->pkt, RtV, uiV);
}

static void generate_S2_storerhgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_storerhgp(ctx, ctx->insn, ctx->pkt, RtV, uiV);
}

static void generate_S2_storerfgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_storerfgp(ctx, ctx->insn, ctx->pkt, RtV, uiV);
}

static void generate_S2_storerigp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_S2_storerigp(ctx, ctx->insn, ctx->pkt, RtV, uiV);
}

static void generate_S2_storerdgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RttN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S2_storerdgp(ctx, ctx->insn, ctx->pkt, RttV, uiV);
}

static void generate_S2_storerinewgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv NtN = get_result_gpr(ctx, insn->regno[0]);
    int uiV = insn->immed[0];
    emit_S2_storerinewgp(ctx, ctx->insn, ctx->pkt, NtN, uiV);
}

static void generate_S2_storerbnewgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv NtN = get_result_gpr(ctx, insn->regno[0]);
    int uiV = insn->immed[0];
    emit_S2_storerbnewgp(ctx, ctx->insn, ctx->pkt, NtN, uiV);
}

static void generate_S2_storerhnewgp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    TCGv NtN = get_result_gpr(ctx, insn->regno[0]);
    int uiV = insn->immed[0];
    emit_S2_storerhnewgp(ctx, ctx->insn, ctx->pkt, NtN, uiV);
}

static void generate_C2_cmpeq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_cmpeq(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_cmpgt(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpgtu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_cmpgtu(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpeqp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_C2_cmpeqp(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpgtp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_C2_cmpgtp(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpgtup(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_C2_cmpgtup(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_rcmpeqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A4_rcmpeqi(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_rcmpneqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A4_rcmpneqi(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_rcmpeq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_rcmpeq(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_rcmpneq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_rcmpneq(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_bitsset(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_bitsset(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_bitsclr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_bitsclr(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_nbitsset(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C4_nbitsset(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_nbitsclr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C4_nbitsclr(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpeqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_C2_cmpeqi(ctx, ctx->insn, ctx->pkt, PdV, RsV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpgti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_C2_cmpgti(ctx, ctx->insn, ctx->pkt, PdV, RsV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_cmpgtui(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_C2_cmpgtui(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_bitsclri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_C2_bitsclri(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_nbitsclri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_C4_nbitsclri(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_cmpneqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_C4_cmpneqi(ctx, ctx->insn, ctx->pkt, PdV, RsV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_cmpltei(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_C4_cmpltei(ctx, ctx->insn, ctx->pkt, PdV, RsV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_cmplteui(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_C4_cmplteui(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_cmpneq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C4_cmpneq(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_cmplte(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C4_cmplte(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_cmplteu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_C4_cmplteu(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PtN = insn->regno[1];
    TCGv PtV = hex_pred[PtN];
    const int PsN = insn->regno[2];
    TCGv PsV = hex_pred[PsN];
    emit_C2_and(ctx, ctx->insn, ctx->pkt, PdV, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PtN = insn->regno[1];
    TCGv PtV = hex_pred[PtN];
    const int PsN = insn->regno[2];
    TCGv PsV = hex_pred[PsN];
    emit_C2_or(ctx, ctx->insn, ctx->pkt, PdV, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    emit_C2_xor(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_andn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PtN = insn->regno[1];
    TCGv PtV = hex_pred[PtN];
    const int PsN = insn->regno[2];
    TCGv PsV = hex_pred[PsN];
    emit_C2_andn(ctx, ctx->insn, ctx->pkt, PdV, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_not(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    emit_C2_not(ctx, ctx->insn, ctx->pkt, PdV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_orn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PtN = insn->regno[1];
    TCGv PtV = hex_pred[PtN];
    const int PsN = insn->regno[2];
    TCGv PsV = hex_pred[PsN];
    emit_C2_orn(ctx, ctx->insn, ctx->pkt, PdV, PtV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_and_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_and_and(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_and_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_and_or(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_or_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_or_and(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_or_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_or_or(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_and_andn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_and_andn(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_and_orn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_and_orn(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_or_andn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_or_andn(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_or_orn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_C4_or_orn(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV, PuV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_any8(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    emit_C2_any8(ctx, ctx->insn, ctx->pkt, PdV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_all8(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    emit_C2_all8(ctx, ctx->insn, ctx->pkt, PdV, PsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_vitpack(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    emit_C2_vitpack(ctx, ctx->insn, ctx->pkt, RdV, PsV, PtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_mux(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PuN = insn->regno[1];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_mux(ctx, ctx->insn, ctx->pkt, RdV, PuV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_cmovenewit(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int siV = insn->immed[0];
    emit_C2_cmovenewit(ctx, ctx->insn, ctx->pkt, PuN, RdV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_cmovenewif(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int siV = insn->immed[0];
    emit_C2_cmovenewif(ctx, ctx->insn, ctx->pkt, PuN, RdV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_cmoveit(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int siV = insn->immed[0];
    emit_C2_cmoveit(ctx, ctx->insn, ctx->pkt, PuV, RdV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_cmoveif(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int siV = insn->immed[0];
    emit_C2_cmoveif(ctx, ctx->insn, ctx->pkt, PuV, RdV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_ccombinewnewt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_ccombinewnewt(ctx, ctx->insn, ctx->pkt, PuN, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_C2_ccombinewnewf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_ccombinewnewf(ctx, ctx->insn, ctx->pkt, PuN, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_C2_ccombinewt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_ccombinewt(ctx, ctx->insn, ctx->pkt, PuV, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_C2_ccombinewf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RddN = insn->regno[1];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_C2_ccombinewf(ctx, ctx->insn, ctx->pkt, PuV, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_C2_muxii(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PuN = insn->regno[1];
    TCGv PuV = hex_pred[PuN];
    int siV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_C2_muxii(ctx, ctx->insn, ctx->pkt, RdV, PuV, siV, SiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_muxir(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PuN = insn->regno[1];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_C2_muxir(ctx, ctx->insn, ctx->pkt, RdV, PuV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_muxri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PuN = insn->regno[1];
    TCGv PuV = hex_pred[PuN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_C2_muxri(ctx, ctx->insn, ctx->pkt, RdV, PuV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_vmux(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int PuN = insn->regno[1];
    TCGv PuV = hex_pred[PuN];
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[3];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_C2_vmux(ctx, ctx->insn, ctx->pkt, RddV, PuV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_C2_mask(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int PtN = insn->regno[1];
    TCGv PtV = hex_pred[PtN];
    emit_C2_mask(ctx, ctx->insn, ctx->pkt, RddV, PtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vcmpbeq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmpbeq(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpbeqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_A4_vcmpbeqi(ctx, ctx->insn, ctx->pkt, PdV, RssV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpbeq_any(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A4_vcmpbeq_any(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A6_vcmpbeq_notany(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A6_vcmpbeq_notany(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A2_vcmpbgtu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmpbgtu(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpbgtui(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_A4_vcmpbgtui(ctx, ctx->insn, ctx->pkt, PdV, RssV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpbgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A4_vcmpbgt(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpbgti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int siV = insn->immed[0];
    emit_A4_vcmpbgti(ctx, ctx->insn, ctx->pkt, PdV, RssV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpbeq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_cmpbeq(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpbeqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A4_cmpbeqi(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpbgtu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_cmpbgtu(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpbgtui(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A4_cmpbgtui(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpbgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_cmpbgt(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpbgti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A4_cmpbgti(ctx, ctx->insn, ctx->pkt, PdV, RsV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A2_vcmpheq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmpheq(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A2_vcmphgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmphgt(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A2_vcmphgtu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmphgtu(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpheqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int siV = insn->immed[0];
    emit_A4_vcmpheqi(ctx, ctx->insn, ctx->pkt, PdV, RssV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmphgti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int siV = insn->immed[0];
    emit_A4_vcmphgti(ctx, ctx->insn, ctx->pkt, PdV, RssV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmphgtui(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_A4_vcmphgtui(ctx, ctx->insn, ctx->pkt, PdV, RssV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpheq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_cmpheq(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmphgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_cmphgt(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmphgtu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_cmphgtu(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmpheqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A4_cmpheqi(ctx, ctx->insn, ctx->pkt, PdV, RsV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmphgti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A4_cmphgti(ctx, ctx->insn, ctx->pkt, PdV, RsV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_cmphgtui(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A4_cmphgtui(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A2_vcmpweq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmpweq(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A2_vcmpwgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmpwgt(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A2_vcmpwgtu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vcmpwgtu(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpweqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int siV = insn->immed[0];
    emit_A4_vcmpweqi(ctx, ctx->insn, ctx->pkt, PdV, RssV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpwgti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int siV = insn->immed[0];
    emit_A4_vcmpwgti(ctx, ctx->insn, ctx->pkt, PdV, RssV, siV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_vcmpwgtui(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_A4_vcmpwgtui(ctx, ctx->insn, ctx->pkt, PdV, RssV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_boundscheck_hi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A4_boundscheck_hi(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_boundscheck_lo(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A4_boundscheck_lo(ctx, ctx->insn, ctx->pkt, PdV, RssV, RttV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_A4_tlbmatch(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_A4_tlbmatch(PdV, RssV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C2_tfrpr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    emit_C2_tfrpr(ctx, ctx->insn, ctx->pkt, RdV, PsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C2_tfrrp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_C2_tfrrp(ctx, ctx->insn, ctx->pkt, PdV, RsV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_fastcorner9(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    emit_C4_fastcorner9(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_C4_fastcorner9_not(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int PsN = insn->regno[1];
    TCGv PsV = hex_pred[PsN];
    const int PtN = insn->regno[2];
    TCGv PtV = hex_pred[PtN];
    emit_C4_fastcorner9_not(ctx, ctx->insn, ctx->pkt, PdV, PsV, PtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_M2_mpy_acc_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_hh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_hh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_hl_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_hl_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_lh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_lh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_ll_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_ll_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_hh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_hh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_hl_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_hl_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_lh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_lh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_ll_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_ll_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_hh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_hh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_hl_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_hl_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_lh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_lh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_ll_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_acc_sat_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_acc_sat_ll_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_hh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_hh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_hl_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_hl_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_lh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_lh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_ll_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_nac_sat_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_nac_sat_ll_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpy_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_hh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_hh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_hl_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_hl_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_lh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_lh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_ll_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_ll_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_hh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_hh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_hl_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_hl_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_lh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_lh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_ll_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_ll_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_hh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_hh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_hl_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_hl_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_lh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_lh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_ll_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_rnd_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_rnd_ll_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_hh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_hh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_hl_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_hl_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_lh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_lh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_ll_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_sat_rnd_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_sat_rnd_ll_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyd_acc_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_hh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_acc_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_hh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_acc_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_hl_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_acc_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_hl_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_acc_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_lh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_acc_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_lh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_acc_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_ll_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_acc_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_acc_ll_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_hh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_hh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_hl_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_hl_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_lh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_lh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_ll_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_nac_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_nac_ll_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyd_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_hh_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_hh_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_hl_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_hl_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_lh_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_lh_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_ll_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_ll_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_hh_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_hh_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_hl_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_hl_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_lh_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_lh_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_ll_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyd_rnd_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyd_rnd_ll_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyu_acc_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_hh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_acc_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_hh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_acc_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_hl_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_acc_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_hl_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_acc_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_lh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_acc_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_lh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_acc_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_ll_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_acc_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_acc_ll_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_hh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_hh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_hl_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_hl_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_lh_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_lh_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_ll_s0(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_nac_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_nac_ll_s1(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyu_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_hh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_hh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_hl_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_hl_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_lh_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_lh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_ll_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_ll_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyud_acc_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_hh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_acc_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_hh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_acc_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_hl_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_acc_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_hl_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_acc_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_lh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_acc_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_lh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_acc_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_ll_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_acc_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_acc_ll_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_hh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_hh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_hl_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_hl_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_lh_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_lh_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_ll_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_nac_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_nac_ll_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpyud_hh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_hh_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyud_hh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_hh_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyud_hl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_hl_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyud_hl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_hl_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyud_lh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_lh_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyud_lh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_lh_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyud_ll_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_ll_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpyud_ll_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyud_ll_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mpysip(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_M2_mpysip(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpysin(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_M2_mpysin(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_macsip(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_M2_macsip(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_macsin(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_M2_macsin(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_dpmpyss_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_dpmpyss_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_dpmpyss_acc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_dpmpyss_acc_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_dpmpyss_nac_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_dpmpyss_nac_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_dpmpyuu_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_dpmpyuu_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_dpmpyuu_acc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_dpmpyuu_acc_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_dpmpyuu_nac_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_dpmpyuu_nac_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mpy_up(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_up(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_up_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_up_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpy_up_s1_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpy_up_s1_sat(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpyu_up(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyu_up(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mpysu_up(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpysu_up(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_dpmpyss_rnd_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_dpmpyss_rnd_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_mac_up_s1_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_mac_up_s1_sat(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_nac_up_s1_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_nac_up_s1_sat(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mpyi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mpyi(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_maci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_maci(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_mnaci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_mnaci(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_acci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_acci(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_accii(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_M2_accii(ctx, ctx->insn, ctx->pkt, RxV, RsV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_nacci(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_nacci(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_naccii(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_M2_naccii(ctx, ctx->insn, ctx->pkt, RxV, RsV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M2_subacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_M2_subacc(ctx, ctx->insn, ctx->pkt, RxV, RtV, RsV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_mpyrr_addr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RyN = insn->regno[0];
    TCGv RyV = get_result_gpr(ctx, RyN);
    tcg_gen_mov_tl(RyV, hex_gpr[RyN]);
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_M4_mpyrr_addr(ctx, ctx->insn, ctx->pkt, RyV, RuV, RsV);
    gen_log_reg_write(ctx, RyN, RyV);
}

static void generate_M4_mpyri_addr_u2(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_M4_mpyri_addr_u2(ctx, ctx->insn, ctx->pkt, RdV, RuV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_mpyri_addr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_M4_mpyri_addr(ctx, ctx->insn, ctx->pkt, RdV, RuV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_mpyri_addi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_M4_mpyri_addi(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_mpyrr_addi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_M4_mpyrr_addi(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_vmpy2s_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmpy2s_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vmpy2s_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmpy2s_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vmac2s_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmac2s_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vmac2s_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmac2s_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vmpy2su_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmpy2su_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vmpy2su_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmpy2su_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vmac2su_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmac2su_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vmac2su_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmac2su_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vmpy2s_s0pack(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmpy2s_s0pack(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_vmpy2s_s1pack(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmpy2s_s1pack(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_vmac2(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_vmac2(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vmpy2es_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vmpy2es_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vmpy2es_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vmpy2es_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vmac2es_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vmac2es_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vmac2es_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vmac2es_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vmac2es(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vmac2es(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrmac_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrmac_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrmpy_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrmpy_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vdmpyrs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vdmpyrs_s0(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_vdmpyrs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vdmpyrs_s1(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M5_vrmpybuu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M5_vrmpybuu(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M5_vrmacbuu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M5_vrmacbuu(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M5_vrmpybsu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M5_vrmpybsu(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M5_vrmacbsu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M5_vrmacbsu(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M5_vmpybuu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M5_vmpybuu(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M5_vmpybsu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M5_vmpybsu(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M5_vmacbuu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M5_vmacbuu(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M5_vmacbsu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M5_vmacbsu(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M5_vdmpybsu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M5_vdmpybsu(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M5_vdmacbsu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M5_vdmacbsu(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vdmacs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vdmacs_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vdmacs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vdmacs_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vdmpys_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vdmpys_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vdmpys_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vdmpys_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_cmpyrs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpyrs_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_cmpyrs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpyrs_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_cmpyrsc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpyrsc_s0(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_cmpyrsc_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpyrsc_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_cmacs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmacs_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cmacs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmacs_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cmacsc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmacsc_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cmacsc_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmacsc_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cmpys_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpys_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_cmpys_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpys_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_cmpysc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpysc_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_cmpysc_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpysc_s1(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_cnacs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cnacs_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cnacs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cnacs_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cnacsc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cnacsc_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cnacsc_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cnacsc_s1(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrcmpys_s1_h(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpys_s1_h(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vrcmpys_s1_l(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpys_s1_l(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vrcmpys_acc_s1_h(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpys_acc_s1_h(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrcmpys_acc_s1_l(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpys_acc_s1_l(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrcmpys_s1rp_h(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpys_s1rp_h(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_vrcmpys_s1rp_l(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpys_s1rp_l(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mmacls_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacls_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmacls_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacls_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmachs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmachs_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmachs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmachs_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmpyl_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyl_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyl_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyh_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyh_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmacls_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacls_rs0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmacls_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacls_rs1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmachs_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmachs_rs0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmachs_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmachs_rs1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmpyl_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyl_rs0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyl_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyl_rs1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyh_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyh_rs0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyh_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyh_rs1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_vrmpyeh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyeh_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_vrmpyeh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyeh_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_vrmpyeh_acc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyeh_acc_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M4_vrmpyeh_acc_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyeh_acc_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M4_vrmpyoh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyoh_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_vrmpyoh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyoh_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_vrmpyoh_acc_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyoh_acc_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M4_vrmpyoh_acc_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_vrmpyoh_acc_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_hmmpyl_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_hmmpyl_rs1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_hmmpyh_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_hmmpyh_rs1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_hmmpyl_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_hmmpyl_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_hmmpyh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_hmmpyh_s1(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_mmaculs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmaculs_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmaculs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmaculs_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmacuhs_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacuhs_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmacuhs_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacuhs_s1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmpyul_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyul_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyul_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyul_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyuh_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyuh_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyuh_s1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyuh_s1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmaculs_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmaculs_rs0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmaculs_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmaculs_rs1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmacuhs_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacuhs_rs0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmacuhs_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmacuhs_rs1(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_mmpyul_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyul_rs0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyul_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyul_rs1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyuh_rs0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyuh_rs0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_mmpyuh_rs1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_mmpyuh_rs1(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vrcmaci_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmaci_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrcmacr_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmacr_s0(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrcmaci_s0c(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmaci_s0c(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrcmacr_s0c(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmacr_s0c(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cmaci_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmaci_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_cmacr_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmacr_s0(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vrcmpyi_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpyi_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vrcmpyr_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpyr_s0(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vrcmpyi_s0c(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpyi_s0c(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vrcmpyr_s0c(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vrcmpyr_s0c(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_cmpyi_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpyi_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_cmpyr_s0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_cmpyr_s0(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_cmpyi_wh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_cmpyi_wh(ctx, ctx->insn, ctx->pkt, RdV, RssV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_cmpyr_wh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_cmpyr_wh(ctx, ctx->insn, ctx->pkt, RdV, RssV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_cmpyi_whc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_cmpyi_whc(ctx, ctx->insn, ctx->pkt, RdV, RssV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_cmpyr_whc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_cmpyr_whc(ctx, ctx->insn, ctx->pkt, RdV, RssV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_vcmpy_s0_sat_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vcmpy_s0_sat_i(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vcmpy_s0_sat_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vcmpy_s0_sat_r(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vcmpy_s1_sat_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vcmpy_s1_sat_i(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vcmpy_s1_sat_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vcmpy_s1_sat_r(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vcmac_s0_sat_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vcmac_s0_sat_i(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vcmac_s0_sat_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vcmac_s0_sat_r(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_vcrotate(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_vcrotate(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_vrcrotate_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_S4_vrcrotate_acc(RxxV, RxxV, RssV, RtV, tcg_constant_tl(uiV));
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S4_vrcrotate(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_S4_vrcrotate(RddV, RssV, RtV, tcg_constant_tl(uiV));
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vcnegh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_vcnegh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vrcnegh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_vrcnegh(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M4_pmpyw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_pmpyw(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_vpmpyh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_vpmpyh(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M4_pmpyw_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_pmpyw_acc(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M4_vpmpyh_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_vpmpyh_acc(ctx, ctx->insn, ctx->pkt, RxxV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M7_dcmpyrw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyrw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M7_dcmpyrw_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyrw_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M7_dcmpyrwc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyrwc(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M7_dcmpyrwc_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyrwc_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M7_dcmpyiw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyiw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M7_dcmpyiw_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyiw_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M7_dcmpyiwc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyiwc(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M7_dcmpyiwc_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M7_dcmpyiwc_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M7_wcmpyrw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrw(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M7_wcmpyrwc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrwc(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M7_wcmpyiw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiw(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M7_wcmpyiwc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiwc(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M7_wcmpyrw_rnd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrw_rnd(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M7_wcmpyrwc_rnd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyrwc_rnd(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M7_wcmpyiw_rnd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiw_rnd(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M7_wcmpyiwc_rnd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    gen_helper_M7_wcmpyiwc_rnd(RdV, tcg_env, RssV, RttV, tcg_constant_tl(ctx->need_commit));
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_add(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_add(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_sub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_sub(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_paddt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_paddt(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_paddf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_paddf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_paddtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_paddtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_paddfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_paddfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_psubt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[3];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_psubt(ctx, ctx->insn, ctx->pkt, PuV, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_psubf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[3];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_psubf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_psubtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[3];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_psubtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_psubfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[3];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_psubfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_paddit(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_paddit(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_paddif(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_paddif(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_padditnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_padditnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_paddifnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_paddifnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pxort(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pxort(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pxorf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pxorf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pxortnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pxortnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pxorfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pxorfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pandt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pandt(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pandf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pandf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pandtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pandtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_pandfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_pandfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_port(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_port(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_porf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_porf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_portnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_portnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_porfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_porfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxtbt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxtbt(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxtbf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxtbf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxtbtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxtbtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxtbfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxtbfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxtbt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxtbt(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxtbf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxtbf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxtbtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxtbtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxtbfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxtbfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxtht(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxtht(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxthf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxthf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxthtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxthtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_psxthfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_psxthfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxtht(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxtht(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxthf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxthf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxthtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxthtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pzxthfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pzxthfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_paslht(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_paslht(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_paslhf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_paslhf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_paslhtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_paslhtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_paslhfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_paslhfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pasrht(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pasrht(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pasrhf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PuN = insn->regno[0];
    TCGv PuV = hex_pred[PuN];
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pasrhf(ctx, ctx->insn, ctx->pkt, PuV, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pasrhtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pasrhtnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_pasrhfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv PuN = get_result_pred(ctx, insn->regno[0]);
    const int RdN = insn->regno[1];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_pasrhfnew(ctx, ctx->insn, ctx->pkt, PuN, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_addsat(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subsat(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_addi(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_C4_addipc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_C4_addipc(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_l16_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_l16_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_l16_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_l16_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_l16_sat_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_l16_sat_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_l16_sat_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_l16_sat_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_l16_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_l16_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_l16_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_l16_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_l16_sat_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_l16_sat_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_l16_sat_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_l16_sat_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_lh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_lh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_hh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_hh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_sat_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_sat_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_sat_lh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_sat_lh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_sat_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_sat_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addh_h16_sat_hh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_addh_h16_sat_hh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_lh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_lh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_hh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_hh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_sat_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_sat_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_sat_lh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_sat_lh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_sat_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_sat_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_subh_h16_sat_hh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_subh_h16_sat_hh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_aslh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_aslh(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_asrh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_asrh(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_addp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_addp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_addpsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_addpsat(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_addspl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_addspl(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_addsph(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_addsph(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_subp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_subp(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_addp_c(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int PxN = insn->regno[3];
    TCGv PxV = tcg_temp_new();
    tcg_gen_mov_tl(PxV, hex_pred[PxN]);
    emit_A4_addp_c(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV, PxV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_pred_write(ctx, PxN, PxV);
}

static void generate_A4_subp_c(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int PxN = insn->regno[3];
    TCGv PxV = tcg_temp_new();
    tcg_gen_mov_tl(PxV, hex_pred[PxN]);
    emit_A4_subp_c(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV, PxV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_pred_write(ctx, PxN, PxV);
}

static void generate_A2_negsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_negsat(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_abs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_abs(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_abssat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_abssat(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_vconj(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vconj(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_negp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_negp(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_absp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_absp(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_max(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_max(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_maxu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_maxu(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_min(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_min(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_minu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_minu(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_maxp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_maxp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_maxup(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_maxup(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_minp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_minp(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_minup(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_minup(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_nop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    emit_A2_nop(ctx, ctx->insn, ctx->pkt);
}

static void generate_A4_ext(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int uiV = insn->immed[0];
    emit_A4_ext(ctx, ctx->insn, ctx->pkt, uiV);
}

static void generate_A2_tfr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_tfr(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_tfrsi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int siV = insn->immed[0];
    emit_A2_tfrsi(ctx, ctx->insn, ctx->pkt, RdV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_sxtb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_sxtb(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_zxth(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_zxth(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_sxth(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_sxth(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_combinew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_combinew(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_combineri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A4_combineri(ctx, ctx->insn, ctx->pkt, RddV, RsV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_combineir(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A4_combineir(ctx, ctx->insn, ctx->pkt, RddV, RsV, siV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_combineii(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int siV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_A2_combineii(ctx, ctx->insn, ctx->pkt, RddV, siV, SiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_combineii(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int siV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_A4_combineii(ctx, ctx->insn, ctx->pkt, RddV, siV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_combine_hh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_combine_hh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_combine_hl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_combine_hl(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_combine_lh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_combine_lh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_combine_ll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_combine_ll(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_tfril(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    emit_A2_tfril(ctx, ctx->insn, ctx->pkt, RxV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_A2_tfrih(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    emit_A2_tfrih(ctx, ctx->insn, ctx->pkt, RxV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_A2_tfrcrr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int CsN = insn->regno[1]  + HEX_REG_SA0;
    TCGv CsV = tcg_temp_new();
    gen_read_ctrl_reg(ctx, CsN, CsV);
    emit_A2_tfrcrr(ctx, ctx->insn, ctx->pkt, RdV, CsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_tfrrcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int CdN = insn->regno[0]  + HEX_REG_SA0;
    TCGv CdV = get_result_gpr(ctx, CdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_tfrrcr(ctx, ctx->insn, ctx->pkt, CdV, RsV);
    gen_write_ctrl_reg(ctx, CdN, CdV);
}

static void generate_A4_tfrcpp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int CssN = insn->regno[1] + HEX_REG_SA0;
    TCGv_i64 CssV = tcg_temp_new_i64();
    gen_read_ctrl_reg_pair(ctx, CssN, CssV);
    emit_A4_tfrcpp(ctx, ctx->insn, ctx->pkt, RddV, CssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_tfrpcp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int CddN = insn->regno[0] + HEX_REG_SA0;
    TCGv_i64 CddV =
        get_result_gpr_pair(ctx, CddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A4_tfrpcp(ctx, ctx->insn, ctx->pkt, CddV, RssV);
    gen_write_ctrl_reg_pair(ctx, CddN, CddV);
}

static void generate_A2_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_and(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_or(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_xor(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_xor_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M2_xor_xacc(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_xor_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M4_xor_xacc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_andn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_andn(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_orn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A4_orn(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_andnp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A4_andnp(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_ornp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A4_ornp(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_addaddi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    int siV = insn->immed[0];
    emit_S4_addaddi(ctx, ctx->insn, ctx->pkt, RdV, RsV, RuV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S4_subaddi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    int siV = insn->immed[0];
    emit_S4_subaddi(ctx, ctx->insn, ctx->pkt, RdV, RsV, RuV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M4_and_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_and_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_and_andn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_and_andn(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_and_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_and_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_and_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_and_xor(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_or_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_or_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_or_andn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_or_andn(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_or_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_or_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_or_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_or_xor(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_or_andix(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RuN = insn->regno[1];
    TCGv RuV = hex_gpr[RuN];
    int siV = insn->immed[0];
    emit_S4_or_andix(ctx, ctx->insn, ctx->pkt, RxV, RuV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_or_andi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_S4_or_andi(ctx, ctx->insn, ctx->pkt, RxV, RsV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_or_ori(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_S4_or_ori(ctx, ctx->insn, ctx->pkt, RxV, RsV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_xor_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_xor_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_xor_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_xor_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_M4_xor_andn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_M4_xor_andn(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_A2_subri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_subri(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_andir(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_andir(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_orir(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_A2_orir(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_andp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_andp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_orp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_orp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_xorp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_xorp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_notp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_notp(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_sxtw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_sxtw(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_sat(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_roundsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_roundsat(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_sath(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_sath(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_satuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_satuh(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_satub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_satub(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_satb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_satb(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_vaddub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vaddub(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vaddubs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vaddubs(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vaddh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vaddh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vaddhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vaddhs(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vadduhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vadduhs(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A5_vaddhubs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A5_vaddhubs(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_vaddw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vaddw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vaddws(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vaddws(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_vxaddsubw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_vxaddsubw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_vxsubaddw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_vxsubaddw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_vxaddsubh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_vxaddsubh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_vxsubaddh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_vxsubaddh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_vxaddsubhr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_vxaddsubhr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_vxsubaddhr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_vxsubaddhr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_svavgh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_svavgh(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svavghs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_svavghs(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svnavgh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_svnavgh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svaddh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_svaddh(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svaddhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_svaddhs(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svadduhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A2_svadduhs(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svsubh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_svsubh(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svsubhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_svsubhs(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_svsubuhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    emit_A2_svsubuhs(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_vraddub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vraddub(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vraddub_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vraddub_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_M2_vraddh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vraddh(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_M2_vradduh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_M2_vradduh(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A2_vsubub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vsubub(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vsububs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vsububs(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vsubh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vsubh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vsubhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vsubhs(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vsubuhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vsubuhs(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vsubw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vsubw(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vsubws(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vsubws(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vabsh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vabsh(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vabshsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vabshsat(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vabsw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vabsw(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vabswsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vabswsat(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vabsdiffw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_M2_vabsdiffw(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M2_vabsdiffh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_M2_vabsdiffh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M6_vabsdiffb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_M6_vabsdiffb(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_M6_vabsdiffub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_M6_vabsdiffub(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vrsadub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vrsadub(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vrsadub_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vrsadub_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A2_vavgub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavgub(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavguh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavguh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavgh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavgh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vnavgh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vnavgh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavgw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavgw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vnavgw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vnavgw(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavgwr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavgwr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vnavgwr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vnavgwr(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavgwcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavgwcr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vnavgwcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vnavgwcr(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavghcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavghcr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vnavghcr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vnavghcr(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavguw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavguw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavguwr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavguwr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavgubr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavgubr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavguhr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavguhr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vavghr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_A2_vavghr(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vnavghr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vnavghr(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_round_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A4_round_ri(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_round_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_round_rr(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_round_ri_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A4_round_ri_sat(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_round_rr_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_round_rr_sat(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_cround_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A4_cround_ri(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A4_cround_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_cround_rr(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A7_croundd_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    gen_helper_A7_croundd_ri(RddV, RssV, tcg_constant_tl(uiV));
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A7_croundd_rr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_A7_croundd_rr(RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A7_clip(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A7_clip(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_A7_vclip(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_A7_vclip(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_vrminh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrminh(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_vrmaxh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrmaxh(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_vrminuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrminuh(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_vrmaxuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrmaxuh(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_vrminw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrminw(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_vrmaxw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrmaxw(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_vrminuw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrminuw(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A4_vrmaxuw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RuN = insn->regno[2];
    TCGv RuV = hex_gpr[RuN];
    emit_A4_vrmaxuw(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RuV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_A2_vminb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vminb(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vmaxb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vmaxb(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vminub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vminub(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vmaxub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vmaxub(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vminh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vminh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vmaxh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vmaxh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vminuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vminuh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vmaxuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vmaxuh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vminw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vminw(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vmaxw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vmaxw(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vminuw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vminuw(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_vmaxuw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A2_vmaxuw(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A5_ACS(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int PeN = insn->regno[1];
    TCGv PeV = tcg_temp_new();
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[3];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_A5_ACS({ fHIDE(int i;) fHIDE(int xv;) fHIDE(int sv;) fHIDE(int tv;) for (i = 0; i < 4; i++) { xv = (int) fGETHALF(i,RxxV); sv = (int) fGETHALF(i,RssV); tv = (int) fGETHALF(i,RttV); xv = xv + tv; sv = sv - tv; fSETBIT(i*2, PeV, (xv > sv)); fSETBIT(i*2+1,PeV, (xv > sv)); fSETHALF(i, RxxV, fSATH(fMAX(xv,sv))); } });
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
    gen_log_pred_write(ctx, PeN, PeV);
}

static void generate_A6_vminub_RdP(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int PeN = insn->regno[1];
    TCGv PeV = tcg_temp_new();
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[3];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_A6_vminub_RdP(ctx, ctx->insn, ctx->pkt, RddV, PeV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
    gen_log_pred_write(ctx, PeN, PeV);
}

static void generate_A4_modwrapu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_modwrapu(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfadd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfadd({ RdV=fUNFLOAT(fFLOAT(RsV)+fFLOAT(RtV));});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfsub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfsub({ RdV=fUNFLOAT(fFLOAT(RsV)-fFLOAT(RtV));});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfmpy(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfmpy({ RdV=fUNFLOAT(fSFMPY(fFLOAT(RsV),fFLOAT(RtV)));});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sffma(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sffma({ RxV=fUNFLOAT(fFMAF(fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV)));});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_F2_sffma_sc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    fGEN_TCG_F2_sffma_sc({ fHIDE(size4s_t tmp;) fCHECKSFNAN3(RxV,RxV,RsV,RtV); tmp=fUNFLOAT(fFMAFX(fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV),PuV)); if (!((fFLOAT(RxV) == 0.0) && fISZEROPROD(fFLOAT(RsV),fFLOAT(RtV)))) RxV = tmp; });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_F2_sffms(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sffms({ RxV=fUNFLOAT(fFMAF(-fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV))); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_F2_sffma_lib(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sffma_lib({ fFPSETROUND_NEAREST(); fHIDE(int infinp; int infminusinf; size4s_t tmp;) infminusinf = ((isinf(fFLOAT(RxV))) && (fISINFPROD(fFLOAT(RsV),fFLOAT(RtV))) && (fGETBIT(31,RsV ^ RxV ^ RtV) != 0)); infinp = (isinf(fFLOAT(RxV))) || (isinf(fFLOAT(RtV))) || (isinf(fFLOAT(RsV))); fCHECKSFNAN3(RxV,RxV,RsV,RtV); tmp=fUNFLOAT(fFMAF(fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV))); if (!((fFLOAT(RxV) == 0.0) && fISZEROPROD(fFLOAT(RsV),fFLOAT(RtV)))) RxV = tmp; fFPCANCELFLAGS(); if (isinf(fFLOAT(RxV)) && !infinp) RxV = RxV - 1; if (infminusinf) RxV = 0; });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_F2_sffms_lib(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sffms_lib({ fFPSETROUND_NEAREST(); fHIDE(int infinp; int infminusinf; size4s_t tmp;) infminusinf = ((isinf(fFLOAT(RxV))) && (fISINFPROD(fFLOAT(RsV),fFLOAT(RtV))) && (fGETBIT(31,RsV ^ RxV ^ RtV) == 0)); infinp = (isinf(fFLOAT(RxV))) || (isinf(fFLOAT(RtV))) || (isinf(fFLOAT(RsV))); fCHECKSFNAN3(RxV,RxV,RsV,RtV); tmp=fUNFLOAT(fFMAF(-fFLOAT(RsV),fFLOAT(RtV),fFLOAT(RxV))); if (!((fFLOAT(RxV) == 0.0) && fISZEROPROD(fFLOAT(RsV),fFLOAT(RtV)))) RxV = tmp; fFPCANCELFLAGS(); if (isinf(fFLOAT(RxV)) && !infinp) RxV = RxV - 1; if (infminusinf) RxV = 0; });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_F2_sfcmpeq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfcmpeq({PdV=f8BITSOF(fFLOAT(RsV)==fFLOAT(RtV));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_sfcmpgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfcmpgt({PdV=f8BITSOF(fFLOAT(RsV)>fFLOAT(RtV));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_sfcmpge(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfcmpge({PdV=f8BITSOF(fFLOAT(RsV)>=fFLOAT(RtV));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_sfcmpuo(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfcmpuo({PdV=f8BITSOF(isunordered(fFLOAT(RsV),fFLOAT(RtV)));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_sfmax(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfmax({ RdV = fUNFLOAT(fSF_MAX(fFLOAT(RsV),fFLOAT(RtV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfmin(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfmin({ RdV = fUNFLOAT(fSF_MIN(fFLOAT(RsV),fFLOAT(RtV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfclass(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    fGEN_TCG_F2_sfclass({ fHIDE(int class;) PdV = 0; class = fpclassify(fFLOAT(RsV)); if (fGETBIT(0,uiV) && (class == FP_ZERO)) PdV = 0xff; if (fGETBIT(1,uiV) && (class == FP_NORMAL)) PdV = 0xff; if (fGETBIT(2,uiV) && (class == FP_SUBNORMAL)) PdV = 0xff; if (fGETBIT(3,uiV) && (class == FP_INFINITE)) PdV = 0xff; if (fGETBIT(4,uiV) && (class == FP_NAN)) PdV = 0xff; fFPCANCELFLAGS(); });
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_sfimm_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_F2_sfimm_p(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfimm_n(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_F2_sfimm_n(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfrecipa(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PeN = insn->regno[1];
    TCGv PeV = tcg_temp_new();
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sfrecipa({ fHIDE(int idx;) fHIDE(int adjust;) fHIDE(int mant;) fHIDE(int exp;) if (fSF_RECIP_COMMON(RsV,RtV,RdV,adjust)) { PeV = adjust; idx = (RtV >> 16) & 0x7f; mant = (fSF_RECIP_LOOKUP(idx) << 15) | 1; exp = fSF_BIAS() - (fSF_GETEXP(RtV) - fSF_BIAS()) - 1; RdV = fMAKESF(fGETBIT(31,RtV),exp,mant); } });
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_pred_write(ctx, PeN, PeV);
}

static void generate_F2_sffixupn(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sffixupn({ fHIDE(int adjust;) fSF_RECIP_COMMON(RsV,RtV,RdV,adjust); RdV = RsV; });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sffixupd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_F2_sffixupd({ fHIDE(int adjust;) fSF_RECIP_COMMON(RsV,RtV,RdV,adjust); RdV = RtV; });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_sfinvsqrta(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int PeN = insn->regno[1];
    TCGv PeV = tcg_temp_new();
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_sfinvsqrta({ fHIDE(int idx;) fHIDE(int adjust;) fHIDE(int mant;) fHIDE(int exp;) if (fSF_INVSQRT_COMMON(RsV,RdV,adjust)) { PeV = adjust; idx = (RsV >> 17) & 0x7f; mant = (fSF_INVSQRT_LOOKUP(idx) << 15); exp = fSF_BIAS() - ((fSF_GETEXP(RsV) - fSF_BIAS()) >> 1) - 1; RdV = fMAKESF(fGETBIT(31,RsV),exp,mant); } });
    gen_log_reg_write(ctx, RdN, RdV);
    gen_log_pred_write(ctx, PeN, PeV);
}

static void generate_F2_sffixupr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_sffixupr({ fHIDE(int adjust;) fSF_INVSQRT_COMMON(RsV,RdV,adjust); RdV = RsV; });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_dfadd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfadd({ RddV=fUNDOUBLE(fDOUBLE(RssV)+fDOUBLE(RttV));});
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_dfsub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfsub({ RddV=fUNDOUBLE(fDOUBLE(RssV)-fDOUBLE(RttV));});
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_dfmax(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmax({ RddV = fUNDOUBLE(fDF_MAX(fDOUBLE(RssV),fDOUBLE(RttV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_dfmin(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmin({ RddV = fUNDOUBLE(fDF_MIN(fDOUBLE(RssV),fDOUBLE(RttV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_dfmpyfix(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmpyfix({ if (fDF_ISDENORM(RssV) && fDF_ISBIG(RttV) && fDF_ISNORMAL(RttV)) RddV = fUNDOUBLE(fDOUBLE(RssV) * 0x1.0p52); else if (fDF_ISDENORM(RttV) && fDF_ISBIG(RssV) && fDF_ISNORMAL(RssV)) RddV = fUNDOUBLE(fDOUBLE(RssV) * 0x1.0p-52); else RddV = RssV; });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_dfmpyll(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_F2_dfmpyll(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_dfmpylh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_F2_dfmpylh(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_F2_dfmpyhh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfmpyhh({ RxxV = fUNDOUBLE(fDF_MPY_HH(fDOUBLE(RssV),fDOUBLE(RttV),RxxV)); });
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_F2_dfcmpeq(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpeq({PdV=f8BITSOF(fDOUBLE(RssV)==fDOUBLE(RttV));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_dfcmpgt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpgt({PdV=f8BITSOF(fDOUBLE(RssV)>fDOUBLE(RttV));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_dfcmpge(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpge({PdV=f8BITSOF(fDOUBLE(RssV)>=fDOUBLE(RttV));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_dfcmpuo(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_F2_dfcmpuo({PdV=f8BITSOF(isunordered(fDOUBLE(RssV),fDOUBLE(RttV)));});
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_dfclass(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    fGEN_TCG_F2_dfclass({ fHIDE(int class;) PdV = 0; class = fpclassify(fDOUBLE(RssV)); if (fGETBIT(0,uiV) && (class == FP_ZERO)) PdV = 0xff; if (fGETBIT(1,uiV) && (class == FP_NORMAL)) PdV = 0xff; if (fGETBIT(2,uiV) && (class == FP_SUBNORMAL)) PdV = 0xff; if (fGETBIT(3,uiV) && (class == FP_INFINITE)) PdV = 0xff; if (fGETBIT(4,uiV) && (class == FP_NAN)) PdV = 0xff; fFPCANCELFLAGS(); });
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_F2_dfimm_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_F2_dfimm_p(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_dfimm_n(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_F2_dfimm_n(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_sf2df(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2df({ RddV = fUNDOUBLE(conv_sf_to_df(fFLOAT(RsV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_df2sf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2sf({ RdV = fUNFLOAT(conv_df_to_sf(fDOUBLE(RssV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_uw2sf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_uw2sf({ RdV = fUNFLOAT(conv_4u_to_sf(fCAST4u(RsV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_uw2df(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_uw2df({ RddV = fUNDOUBLE(conv_4u_to_df(fCAST4u(RsV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_w2sf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_w2sf({ RdV = fUNFLOAT(conv_4s_to_sf(fCAST4s(RsV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_w2df(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_w2df({ RddV = fUNDOUBLE(conv_4s_to_df(fCAST4s(RsV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_ud2sf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_ud2sf({ RdV = fUNFLOAT(conv_8u_to_sf(fCAST8u(RssV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_ud2df(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_ud2df({ RddV = fUNDOUBLE(conv_8u_to_df(fCAST8u(RssV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_d2sf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_d2sf({ RdV = fUNFLOAT(conv_8s_to_sf(fCAST8s(RssV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_d2df(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_d2df({ RddV = fUNDOUBLE(conv_8s_to_df(fCAST8s(RssV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_sf2uw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2uw({ RdV = fCAST4u(conv_sf_to_4u(fFLOAT(RsV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_sf2w(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2w({ RdV = fCAST4s(conv_sf_to_4s(fFLOAT(RsV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_sf2ud(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2ud({ RddV = fCAST8u(conv_sf_to_8u(fFLOAT(RsV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_sf2d(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2d({ RddV = fCAST8s(conv_sf_to_8s(fFLOAT(RsV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_df2uw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2uw({ RdV = fCAST4u(conv_df_to_4u(fDOUBLE(RssV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_df2w(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2w({ RdV = fCAST4s(conv_df_to_4s(fDOUBLE(RssV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_df2ud(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2ud({ RddV = fCAST8u(conv_df_to_8u(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_df2d(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2d({ RddV = fCAST8s(conv_df_to_8s(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_sf2uw_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2uw_chop({ fFPSETROUND_CHOP(); RdV = fCAST4u(conv_sf_to_4u(fFLOAT(RsV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_sf2w_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2w_chop({ fFPSETROUND_CHOP(); RdV = fCAST4s(conv_sf_to_4s(fFLOAT(RsV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_sf2ud_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2ud_chop({ fFPSETROUND_CHOP(); RddV = fCAST8u(conv_sf_to_8u(fFLOAT(RsV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_sf2d_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_F2_conv_sf2d_chop({ fFPSETROUND_CHOP(); RddV = fCAST8s(conv_sf_to_8s(fFLOAT(RsV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_df2uw_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2uw_chop({ fFPSETROUND_CHOP(); RdV = fCAST4u(conv_df_to_4u(fDOUBLE(RssV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_df2w_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2w_chop({ fFPSETROUND_CHOP(); RdV = fCAST4s(conv_df_to_4s(fDOUBLE(RssV))); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_F2_conv_df2ud_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2ud_chop({ fFPSETROUND_CHOP(); RddV = fCAST8u(conv_df_to_8u(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_F2_conv_df2d_chop(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_F2_conv_df2d_chop({ fFPSETROUND_CHOP(); RddV = fCAST8s(conv_df_to_8s(fDOUBLE(RssV))); });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asr_r_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asl_r_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_lsr_r_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_lsl_r_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asr_r_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asl_r_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsr_r_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsl_r_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asr_r_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_r_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_r_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsl_r_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_r_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_r_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_r_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsl_r_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_r_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_r_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_r_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsl_r_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_r_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_r_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_r_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsl_r_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_r_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_r_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_r_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsl_r_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_r_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_r_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_r_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsl_r_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, RtV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_r_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_r_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_r_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsl_r_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_r_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_r_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_r_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsl_r_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_r_p_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_p_xor(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_r_p_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_p_xor(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_r_p_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_p_xor(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsl_r_p_xor(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_p_xor(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_r_r_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_S2_asr_r_r_sat({ fHIDE(size4s_t) shamt=fSXTN(7,32,RtV); RdV = fBIDIR_ASHIFTR_SAT(RsV,shamt,4_8); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asl_r_r_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_S2_asl_r_r_sat({ fHIDE(size4s_t) shamt=fSXTN(7,32,RtV); RdV = fBIDIR_ASHIFTL_SAT(RsV,shamt,4_8); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asr_i_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asr_i_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_lsr_i_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_lsr_i_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asl_i_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asl_i_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S6_rol_i_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S6_rol_i_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asr_i_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsr_i_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asl_i_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S6_rol_i_p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S6_rol_i_p(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asr_i_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asr_i_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_i_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_lsr_i_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_i_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asl_i_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S6_rol_i_r_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S6_rol_i_r_acc(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_i_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_i_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_i_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S6_rol_i_p_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S6_rol_i_p_acc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_i_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asr_i_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_i_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_lsr_i_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_i_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asl_i_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S6_rol_i_r_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S6_rol_i_r_nac(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_i_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_i_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_i_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S6_rol_i_p_nac(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S6_rol_i_p_nac(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_i_r_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_lsr_i_r_xacc(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_i_r_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asl_i_r_xacc(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S6_rol_i_r_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S6_rol_i_r_xacc(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_i_p_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_p_xacc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_i_p_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_p_xacc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S6_rol_i_p_xacc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S6_rol_i_p_xacc(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_i_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asr_i_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_i_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_lsr_i_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_i_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asl_i_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S6_rol_i_r_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S6_rol_i_r_and(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_i_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asr_i_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_lsr_i_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_lsr_i_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asl_i_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asl_i_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S6_rol_i_r_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S6_rol_i_r_or(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_asr_i_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_i_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_i_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S6_rol_i_p_and(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S6_rol_i_p_and(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asr_i_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_lsr_i_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_i_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S6_rol_i_p_or(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S6_rol_i_p_or(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S2_asl_i_r_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asl_i_r_sat(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asr_i_r_rnd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_asr_i_r_rnd(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asr_i_p_rnd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_p_rnd(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_lsli(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    emit_S4_lsli(ctx, ctx->insn, ctx->pkt, RdV, RtV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_addasl_rrri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int RsN = insn->regno[2];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_addasl_rrri(ctx, ctx->insn, ctx->pkt, RdV, RtV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S4_andi_asl_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_andi_asl_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_ori_asl_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_ori_asl_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_addi_asl_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_addi_asl_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_subi_asl_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_subi_asl_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_andi_lsr_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_andi_lsr_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_ori_lsr_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_ori_lsr_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_addi_lsr_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_addi_lsr_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_subi_lsr_ri(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_subi_lsr_ri(ctx, ctx->insn, ctx->pkt, RxV, uiV, UiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_valignib(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_valignib(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_valignrb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_S2_valignrb(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV, PuV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vspliceib(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int uiV = insn->immed[0];
    emit_S2_vspliceib(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsplicerb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int PuN = insn->regno[3];
    TCGv PuV = hex_pred[PuN];
    emit_S2_vsplicerb(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV, PuV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsplatrh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_vsplatrh(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsplatrb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_vsplatrb(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S6_vsplatrbp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S6_vsplatrbp(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_insert(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    fGEN_TCG_S2_insert({ fHIDE(int) width=uiV; fHIDE(int) offset=UiV; RxV &= ~(((fCONSTLL(1)<<width)-1)<<offset); RxV |= ((RsV & ((fCONSTLL(1)<<width)-1)) << offset); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_tableidxb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S2_tableidxb(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV, SiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_tableidxh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S2_tableidxh(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV, SiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_tableidxw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S2_tableidxw(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV, SiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S2_tableidxd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int SiV = insn->immed[1];
    emit_S2_tableidxd(ctx, ctx->insn, ctx->pkt, RxV, RsV, uiV, SiV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_A4_bitspliti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_A4_bitspliti(ctx, ctx->insn, ctx->pkt, RddV, RsV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A4_bitsplit(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_A4_bitsplit(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S4_extract(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_extract(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_extractu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S2_extractu(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_insertp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S2_insertp(ctx, ctx->insn, ctx->pkt, RxxV, RssV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S4_extractp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S4_extractp(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_extractup(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S2_extractup(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV, UiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_mask(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    int UiV = insn->immed[1];
    emit_S2_mask(ctx, ctx->insn, ctx->pkt, RdV, uiV, UiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_insert_rp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_S2_insert_rp({ fHIDE(int) width=fZXTN(6,32,(fGETWORD(1,RttV))); fHIDE(int) offset=fSXTN(7,32,(fGETWORD(0,RttV))); fHIDE(size8u_t) mask = ((fCONSTLL(1)<<width)-1); if (offset < 0) { RxV = 0; } else { RxV &= ~(mask<<offset); RxV |= ((RsV & mask) << offset); } });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_S4_extract_rp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_extract_rp(ctx, ctx->insn, ctx->pkt, RdV, RsV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_extractu_rp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_extractu_rp(ctx, ctx->insn, ctx->pkt, RdV, RsV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_insertp_rp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxxN = insn->regno[0];
    TCGv_i64 RxxV =
        get_result_gpr_pair(ctx, RxxN);
    tcg_gen_concat_i32_i64(RxxV,
                           hex_gpr[RxxN],
                           hex_gpr[RxxN + 1]);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_insertp_rp(ctx, ctx->insn, ctx->pkt, RxxV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RxxN, RxxV);
}

static void generate_S4_extractp_rp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S4_extractp_rp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_extractup_rp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_extractup_rp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_tstbit_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_tstbit_i(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_S4_ntstbit_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S4_ntstbit_i(ctx, ctx->insn, ctx->pkt, PdV, RsV, uiV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_S2_setbit_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_setbit_i(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_togglebit_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_togglebit_i(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_clrbit_i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_S2_clrbit_i(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_tstbit_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_tstbit_r(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_S4_ntstbit_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int PdN = insn->regno[0];
    TCGv PdV = tcg_temp_new();
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S4_ntstbit_r(ctx, ctx->insn, ctx->pkt, PdV, RsV, RtV);
    gen_log_pred_write(ctx, PdN, PdV);
}

static void generate_S2_setbit_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_setbit_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_togglebit_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_togglebit_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_clrbit_r(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_clrbit_r(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asr_i_vh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_vh(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsr_i_vh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_vh(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asl_i_vh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_vh(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asr_r_vh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_vh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S5_asrhub_rnd_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S5_asrhub_rnd_sat(ctx, ctx->insn, ctx->pkt, RdV, RssV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S5_asrhub_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S5_asrhub_sat(ctx, ctx->insn, ctx->pkt, RdV, RssV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S5_vasrhrnd(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S5_vasrhrnd(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asl_r_vh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_vh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsr_r_vh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_vh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsl_r_vh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_vh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asr_i_vw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_vw(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asr_i_svw_trun(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asr_i_svw_trun(ctx, ctx->insn, ctx->pkt, RdV, RssV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_asr_r_svw_trun(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_S2_asr_r_svw_trun({ fHIDE(int i;) for (i=0;i<2;i++) { fSETHALF(i,RdV,fGETHALF(0,fBIDIR_ASHIFTR(fGETWORD(i,RssV),fSXTN(7,32,RtV),4_8))); } });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_lsr_i_vw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_lsr_i_vw(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asl_i_vw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int uiV = insn->immed[0];
    emit_S2_asl_i_vw(ctx, ctx->insn, ctx->pkt, RddV, RssV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asr_r_vw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asr_r_vw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_asl_r_vw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_asl_r_vw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsr_r_vw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsr_r_vw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_lsl_r_vw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_lsl_r_vw(ctx, ctx->insn, ctx->pkt, RddV, RssV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vrndpackwh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vrndpackwh(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_vrndpackwhs(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vrndpackwhs(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_vsxtbh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_vsxtbh(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vzxtbh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_vzxtbh(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsathub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsathub(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_svsathub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_svsathub(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_svsathb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_svsathb(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_vsathb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsathb(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_vtrunohb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vtrunohb(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_vtrunewh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_vtrunewh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vtrunowh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_vtrunowh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vtrunehb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vtrunehb(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S6_vtrunehb_ppp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S6_vtrunehb_ppp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S6_vtrunohb_ppp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S6_vtrunohb_ppp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsxthw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_vsxthw(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vzxthw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_vzxthw(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsatwh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsatwh(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_vsatwuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsatwuh(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_packhl(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S2_packhl(ctx, ctx->insn, ctx->pkt, RddV, RsV, RtV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_A2_swiz(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_A2_swiz({ fSETBYTE(0,RdV,fGETBYTE(3,RsV)); fSETBYTE(1,RdV,fGETBYTE(2,RsV)); fSETBYTE(2,RdV,fGETBYTE(1,RsV)); fSETBYTE(3,RdV,fGETBYTE(0,RsV)); });
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_vsathub_nopack(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsathub_nopack(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsathb_nopack(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsathb_nopack(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsatwh_nopack(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsatwh_nopack(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_vsatwuh_nopack(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_vsatwuh_nopack(ctx, ctx->insn, ctx->pkt, RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_shuffob(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_shuffob(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_shuffeb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_shuffeb(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_shuffoh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    const int RssN = insn->regno[2];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_shuffoh(ctx, ctx->insn, ctx->pkt, RddV, RttV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_shuffeh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_shuffeh(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S5_popcountp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S5_popcountp(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S4_parity(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    emit_S4_parity(ctx, ctx->insn, ctx->pkt, RdV, RsV, RtV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_parityp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_parityp(ctx, ctx->insn, ctx->pkt, RdV, RssV, RttV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_lfsp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    emit_S2_lfsp(ctx, ctx->insn, ctx->pkt, RddV, RssV, RttV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_clbnorm(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_clbnorm(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S4_clbaddi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int siV = insn->immed[0];
    emit_S4_clbaddi(ctx, ctx->insn, ctx->pkt, RdV, RsV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S4_clbpnorm(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S4_clbpnorm(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S4_clbpaddi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    int siV = insn->immed[0];
    emit_S4_clbpaddi(ctx, ctx->insn, ctx->pkt, RdV, RssV, siV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_cabacdecbin(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    const int RttN = insn->regno[2];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_S2_cabacdecbin({ fHIDE(size4u_t state;) fHIDE(size4u_t valMPS;) fHIDE(size4u_t bitpos;) fHIDE(size4u_t range;) fHIDE(size4u_t offset;) fHIDE(size4u_t rLPS;) fHIDE(size4u_t rMPS;) state = fEXTRACTU_RANGE( fGETWORD(1,RttV) ,5,0); valMPS = fEXTRACTU_RANGE( fGETWORD(1,RttV) ,8,8); bitpos = fEXTRACTU_RANGE( fGETWORD(0,RttV) ,4,0); range = fGETWORD(0,RssV); offset = fGETWORD(1,RssV); range <<= bitpos; offset <<= bitpos; rLPS = rLPS_table_64x4[state][ (range >>29)&3]; rLPS = rLPS << 23; rMPS= (range&0xff800000) - rLPS; if (offset < rMPS) { RddV = AC_next_state_MPS_64[state]; fINSERT_RANGE(RddV,8,8,valMPS); fINSERT_RANGE(RddV,31,23,(rMPS>>23)); fSETWORD(1,RddV,offset); fWRITE_P0(valMPS); } else { RddV = AC_next_state_LPS_64[state]; fINSERT_RANGE(RddV,8,8,((!state)?(1-valMPS):(valMPS))); fINSERT_RANGE(RddV,31,23,(rLPS>>23)); fSETWORD(1,RddV,(offset-rMPS)); fWRITE_P0((valMPS^1)); } });
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_clb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_clb(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_cl0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_cl0(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_cl1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_S2_cl1(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_clbp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_clbp(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_cl0p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_cl0p(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_cl1p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    emit_S2_cl1p(ctx, ctx->insn, ctx->pkt, RdV, RssV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_brev(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    gen_helper_S2_brev(RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_brevp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    gen_helper_S2_brevp(RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_ct0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_S2_ct0({RdV = fCL1_4(~fBREV_4(RsV));});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_ct1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_S2_ct1({RdV = fCL1_4(fBREV_4(RsV));});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_ct0p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_S2_ct0p({RdV = fCL1_8(~fBREV_8(RssV));});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_ct1p(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    fGEN_TCG_S2_ct1p({RdV = fCL1_8(fBREV_8(RssV));});
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_S2_interleave(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    gen_helper_S2_interleave(RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_S2_deinterleave(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RssN = insn->regno[1];
    TCGv_i64 RssV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RssV,
                            hex_gpr[RssN],
                            hex_gpr[RssN + 1]);
    gen_helper_S2_deinterleave(RddV, RssV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_J2_trap0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int uiV = insn->immed[0];
    fGEN_TCG_J2_trap0(fTRAP(0,uiV););
}

static void generate_J2_pause(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    int uiV = insn->immed[0];
    fGEN_TCG_J2_pause({fPAUSE(uiV);});
}

static void generate_Y2_icinva(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_Y2_icinva({fEA_REG(RsV); fICINVA(EA);});
}

static void generate_Y2_isync(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_Y2_isync({fISYNC();});
}

static void generate_Y2_barrier(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_Y2_barrier({fBARRIER();});
}

static void generate_Y2_syncht(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_Y2_syncht({fSYNCH();});
}

static void generate_Y2_dcfetchbo(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    fGEN_TCG_Y2_dcfetchbo({fEA_RI(RsV,uiV); fDCFETCH(EA);});
}

static void generate_Y2_dczeroa(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_Y2_dczeroa({fEA_REG(RsV); fDCZEROA(EA);});
}

static void generate_Y2_dccleana(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_Y2_dccleana({fEA_REG(RsV); fDCCLEANA(EA);});
}

static void generate_Y2_dccleaninva(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_Y2_dccleaninva({fEA_REG(RsV); fDCCLEANINVA(EA);});
}

static void generate_Y2_dcinva(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    fGEN_TCG_Y2_dcinva({fEA_REG(RsV); fDCCLEANINVA(EA);});
}

static void generate_Y4_l2fetch(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_Y4_l2fetch({ fL2FETCH(RsV, (RtV&0xff), ((RtV>>8)&0xff), ((RtV>>16)&0xffff), 0); });
}

static void generate_Y5_l2fetch(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RttN = insn->regno[1];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    fGEN_TCG_Y5_l2fetch({ fL2FETCH(RsV, fGETUHALF(0,RttV), fGETUHALF(1,RttV), fGETUHALF(2,RttV), fGETUHALF(3,RttV)); });
}

static void generate_SA1_addi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    emit_SA1_addi(ctx, ctx->insn, ctx->pkt, RxV, siV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_SA1_tfr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_tfr(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_seti(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_SA1_seti(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_setin1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    emit_SA1_setin1(ctx, ctx->insn, ctx->pkt, RdV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_clrtnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    emit_SA1_clrtnew(ctx, ctx->insn, ctx->pkt, RdV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_clrfnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    emit_SA1_clrfnew(ctx, ctx->insn, ctx->pkt, RdV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_clrt(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    emit_SA1_clrt(ctx, ctx->insn, ctx->pkt, RdV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_clrf(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    emit_SA1_clrf(ctx, ctx->insn, ctx->pkt, RdV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_addsp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_SA1_addsp(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_inc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_inc(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_dec(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_dec(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_addrx(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_addrx(ctx, ctx->insn, ctx->pkt, RxV, RsV);
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_SA1_zxtb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_zxtb(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_and1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_and1(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_sxtb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_sxtb(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_zxth(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_zxth(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_sxth(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_sxth(ctx, ctx->insn, ctx->pkt, RdV, RsV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SA1_combinezr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_combinezr(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_SA1_combinerz(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    emit_SA1_combinerz(ctx, ctx->insn, ctx->pkt, RddV, RsV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_SA1_combine0i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_SA1_combine0i(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_SA1_combine1i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_SA1_combine1i(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_SA1_combine2i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_SA1_combine2i(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_SA1_combine3i(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_SA1_combine3i(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_SA1_cmpeqi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SA1_cmpeqi(ctx, ctx->insn, ctx->pkt, RsV, uiV);
}

static void generate_SL1_loadri_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SL1_loadri_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SL1_loadrub_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SL1_loadrub_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SL2_loadrh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SL2_loadrh_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SL2_loadruh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SL2_loadruh_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SL2_loadrb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    const int RsN = insn->regno[1];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SL2_loadrb_io(ctx, ctx->insn, ctx->pkt, RdV, RsV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SL2_loadri_sp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RdN = insn->regno[0];
    TCGv RdV = get_result_gpr(ctx, RdN);
    int uiV = insn->immed[0];
    emit_SL2_loadri_sp(ctx, ctx->insn, ctx->pkt, RdV, uiV);
    gen_log_reg_write(ctx, RdN, RdV);
}

static void generate_SL2_loadrd_sp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RddN = insn->regno[0];
    TCGv_i64 RddV =
        get_result_gpr_pair(ctx, RddN);
    int uiV = insn->immed[0];
    emit_SL2_loadrd_sp(ctx, ctx->insn, ctx->pkt, RddV, uiV);
    gen_log_reg_write_pair(ctx, RddN, RddV);
}

static void generate_SL2_deallocframe(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    emit_SL2_deallocframe(ctx, ctx->insn, ctx->pkt);
}

static void generate_SL2_return(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    fGEN_TCG_SL2_return({ fHIDE(size8u_t tmp;) fEA_REG(fREAD_FP()); fLOAD(1,8,u,EA,tmp); tmp = fFRAME_UNSCRAMBLE(tmp); fWRITE_LR(fGETWORD(1,tmp)); fWRITE_FP(fGETWORD(0,tmp)); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,tmp),COF_TYPE_JUMPR);});
}

static void generate_SL2_return_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    fGEN_TCG_SL2_return_t({ fHIDE(size8u_t tmp;); fBRANCH_SPECULATE_STALL(fLSBOLD(fREAD_P0()),, SPECULATE_NOT_TAKEN,4,0); fEA_REG(fREAD_FP()); if (fLSBOLD(fREAD_P0())) { fLOAD(1,8,u,EA,tmp); tmp = fFRAME_UNSCRAMBLE(tmp); fWRITE_LR(fGETWORD(1,tmp)); fWRITE_FP(fGETWORD(0,tmp)); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,tmp),COF_TYPE_JUMPR);} else {LOAD_CANCEL(EA);} });
}

static void generate_SL2_return_f(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    fGEN_TCG_SL2_return_f({ fHIDE(size8u_t tmp;);fBRANCH_SPECULATE_STALL(fLSBOLDNOT(fREAD_P0()),, SPECULATE_NOT_TAKEN,4,0); fEA_REG(fREAD_FP()); if (fLSBOLDNOT(fREAD_P0())) { fLOAD(1,8,u,EA,tmp); tmp = fFRAME_UNSCRAMBLE(tmp); fWRITE_LR(fGETWORD(1,tmp)); fWRITE_FP(fGETWORD(0,tmp)); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,tmp),COF_TYPE_JUMPR);} else {LOAD_CANCEL(EA);} });
}

static void generate_SL2_return_tnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    fGEN_TCG_SL2_return_tnew({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBNEW0,, SPECULATE_NOT_TAKEN , 4,3); fEA_REG(fREAD_FP()); if (fLSBNEW0) { fLOAD(1,8,u,EA,tmp); tmp = fFRAME_UNSCRAMBLE(tmp); fWRITE_LR(fGETWORD(1,tmp)); fWRITE_FP(fGETWORD(0,tmp)); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,tmp),COF_TYPE_JUMPR);} else {LOAD_CANCEL(EA);} });
}

static void generate_SL2_return_fnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    fGEN_TCG_SL2_return_fnew({ fHIDE(size8u_t tmp;) fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,, SPECULATE_NOT_TAKEN , 4,3); fEA_REG(fREAD_FP()); if (fLSBNEW0NOT) { fLOAD(1,8,u,EA,tmp); tmp = fFRAME_UNSCRAMBLE(tmp); fWRITE_LR(fGETWORD(1,tmp)); fWRITE_FP(fGETWORD(0,tmp)); fWRITE_SP(EA+8); fJUMPR(REG_LR,fGETWORD(1,tmp),COF_TYPE_JUMPR);} else {LOAD_CANCEL(EA);} });
}

static void generate_SL2_jumpr31(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_SL2_jumpr31({ fJUMPR(REG_LR,fREAD_LR(),COF_TYPE_JUMPR);});
}

static void generate_SL2_jumpr31_t(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_SL2_jumpr31_t({fBRANCH_SPECULATE_STALL(fLSBOLD(fREAD_P0()),, SPECULATE_TAKEN,4,0); if (fLSBOLD(fREAD_P0())) {fJUMPR(REG_LR,fREAD_LR(),COF_TYPE_JUMPR);}});
}

static void generate_SL2_jumpr31_f(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_SL2_jumpr31_f({fBRANCH_SPECULATE_STALL(fLSBOLDNOT(fREAD_P0()),, SPECULATE_TAKEN,4,0); if (fLSBOLDNOT(fREAD_P0())) {fJUMPR(REG_LR,fREAD_LR(),COF_TYPE_JUMPR);}});
}

static void generate_SL2_jumpr31_tnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_SL2_jumpr31_tnew({fBRANCH_SPECULATE_STALL(fLSBNEW0,, SPECULATE_NOT_TAKEN , 4,3); if (fLSBNEW0) {fJUMPR(REG_LR,fREAD_LR(),COF_TYPE_JUMPR);}});
}

static void generate_SL2_jumpr31_fnew(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    fGEN_TCG_SL2_jumpr31_fnew({fBRANCH_SPECULATE_STALL(fLSBNEW0NOT,, SPECULATE_NOT_TAKEN , 4,3); if (fLSBNEW0NOT) {fJUMPR(REG_LR,fREAD_LR(),COF_TYPE_JUMPR);}});
}

static void generate_SS1_storew_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_SS1_storew_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_SS1_storeb_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_SS1_storeb_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_SS2_storeh_io(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_SS2_storeh_io(ctx, ctx->insn, ctx->pkt, RsV, RtV, uiV);
}

static void generate_SS2_stored_sp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RttN = insn->regno[0];
    TCGv_i64 RttV = tcg_temp_new_i64();
    tcg_gen_concat_i32_i64(RttV,
                            hex_gpr[RttN],
                            hex_gpr[RttN + 1]);
    int siV = insn->immed[0];
    emit_SS2_stored_sp(ctx, ctx->insn, ctx->pkt, RttV, siV);
}

static void generate_SS2_storew_sp(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    emit_SS2_storew_sp(ctx, ctx->insn, ctx->pkt, RtV, uiV);
}

static void generate_SS2_storewi0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SS2_storewi0(ctx, ctx->insn, ctx->pkt, RsV, uiV);
}

static void generate_SS2_storebi0(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SS2_storebi0(ctx, ctx->insn, ctx->pkt, RsV, uiV);
}

static void generate_SS2_storewi1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SS2_storewi1(ctx, ctx->insn, ctx->pkt, RsV, uiV);
}

static void generate_SS2_storebi1(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RsN = insn->regno[0];
    TCGv RsV = hex_gpr[RsN];
    int uiV = insn->immed[0];
    emit_SS2_storebi1(ctx, ctx->insn, ctx->pkt, RsV, uiV);
}

static void generate_SS2_allocframe(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    int uiV = insn->immed[0];
    emit_SS2_allocframe(ctx, ctx->insn, ctx->pkt, uiV);
}

static void generate_V6_vL32b_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_pi({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_ai({ fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);});
}

static void generate_V6_vL32b_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_ppu({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_cur_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_cur_pi({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_cur_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_cur_ai({ fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);});
}

static void generate_V6_vL32b_cur_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_cur_ppu({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_tmp_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_tmp_pi({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_tmp_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_tmp_ai({ fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);});
}

static void generate_V6_vL32b_tmp_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_tmp_ppu({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_cur_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_cur_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_cur_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_cur_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_cur_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_cur_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_cur_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_cur_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_cur_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_cur_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_cur_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_cur_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_tmp_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_tmp_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_tmp_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_tmp_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_tmp_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_tmp_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_tmp_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_tmp_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_tmp_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_tmp_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_tmp_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_tmp_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int VsN = insn->regno[1];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_pi({ fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[1];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,VsV);});
}

static void generate_V6_vS32b_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_ppu({ fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,VsV);} else {CANCEL;}});
}

static void generate_V6_vS32b_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,VsV);} else {CANCEL;}});
}

static void generate_V6_vS32b_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_qpred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_qpred_pi({ fEA_REG(RxV); fSTOREMMVQ(EA,VsV,QvV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_qpred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_qpred_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMVQ(EA,VsV,QvV);});
}

static void generate_V6_vS32b_qpred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_qpred_ppu({ fEA_REG(RxV); fSTOREMMVQ(EA,VsV,QvV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nqpred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nqpred_pi({ fEA_REG(RxV); fSTOREMMVNQ(EA,VsV,QvV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nqpred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nqpred_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMVNQ(EA,VsV,QvV);});
}

static void generate_V6_vS32b_nqpred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_nqpred_ppu({ fEA_REG(RxV); fSTOREMMVNQ(EA,VsV,QvV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32Ub_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32Ub_pi({ fEA_REG(RxV); fLOADMMVU(EA,VdV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32Ub_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32Ub_ai({ fEA_RI(RtV,siV*fVECSIZE()); fLOADMMVU(EA,VdV);});
}

static void generate_V6_vL32Ub_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32Ub_ppu({ fEA_REG(RxV); fLOADMMVU(EA,VdV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32Ub_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int VsN = insn->regno[1];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32Ub_pi({ fEA_REG(RxV); fSTOREMMVU(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32Ub_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[1];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32Ub_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMVU(EA,VsV);});
}

static void generate_V6_vS32Ub_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32Ub_ppu({ fEA_REG(RxV); fSTOREMMVU(EA,VsV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32Ub_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32Ub_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMVU(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32Ub_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32Ub_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMVU(EA,VsV);} else {CANCEL;}});
}

static void generate_V6_vS32Ub_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32Ub_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMVU(EA,VsV); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32Ub_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32Ub_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMVU(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32Ub_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32Ub_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMVU(EA,VsV);} else {CANCEL;}});
}

static void generate_V6_vS32Ub_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32Ub_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMVU(EA,VsV); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_new_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int OsN = insn->regno[1];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_new_pi({ fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_new_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    const int OsN = insn->regno[1];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_new_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,fNEWVREG(OsN));});
}

static void generate_V6_vS32b_new_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    fGEN_TCG_V6_vS32b_new_ppu({ fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_srls_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_srls_pi({ fEA_REG(RxV); fSTORERELEASE(EA,0); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_srls_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_srls_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTORERELEASE(EA,0);});
}

static void generate_V6_vS32b_srls_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vS32b_srls_ppu({ fEA_REG(RxV); fSTORERELEASE(EA,0); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_new_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_new_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_new_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_new_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,fNEWVREG(OsN));} else {CANCEL;}});
}

static void generate_V6_vS32b_new_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int OsN = insn->regno[3];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    fGEN_TCG_V6_vS32b_new_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_new_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_new_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_new_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_new_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,fNEWVREG(OsN));} else {CANCEL;}});
}

static void generate_V6_vS32b_new_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int OsN = insn->regno[3];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    fGEN_TCG_V6_vS32b_new_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int VsN = insn->regno[1];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_pi({ fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[1];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,VsV);});
}

static void generate_V6_vS32b_nt_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_nt_ppu({ fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,VsV);} else {CANCEL;}});
}

static void generate_V6_vS32b_nt_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_nt_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,VsV);} else {CANCEL;}});
}

static void generate_V6_vS32b_nt_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_nt_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,VsV); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_new_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int OsN = insn->regno[1];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_new_pi({ fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_new_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RtN = insn->regno[0];
    TCGv RtV = hex_gpr[RtN];
    const int OsN = insn->regno[1];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_new_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,fNEWVREG(OsN));});
}

static void generate_V6_vS32b_nt_new_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int RxN = insn->regno[0];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[1] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    fGEN_TCG_V6_vS32b_nt_new_ppu({ fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_new_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_new_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_new_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_new_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,fNEWVREG(OsN));} else {CANCEL;}});
}

static void generate_V6_vS32b_nt_new_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int OsN = insn->regno[3];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    fGEN_TCG_V6_vS32b_nt_new_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_new_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_new_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_new_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int OsN = insn->regno[2];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_new_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMV(EA,fNEWVREG(OsN));} else {CANCEL;}});
}

static void generate_V6_vS32b_nt_new_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int OsN = insn->regno[3];
    const intptr_t OsN_off =
        ctx_future_vreg_off(ctx, OsN, 1, true);
    fGEN_TCG_V6_vS32b_nt_new_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fSTOREMMV(EA,fNEWVREG(OsN)); fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_qpred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_qpred_pi({ fEA_REG(RxV); fSTOREMMVQ(EA,VsV,QvV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_qpred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_qpred_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMVQ(EA,VsV,QvV);});
}

static void generate_V6_vS32b_nt_qpred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_nt_qpred_ppu({ fEA_REG(RxV); fSTOREMMVQ(EA,VsV,QvV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_nqpred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_nqpred_pi({ fEA_REG(RxV); fSTOREMMVNQ(EA,VsV,QvV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vS32b_nt_nqpred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    const int VsN = insn->regno[2];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vS32b_nt_nqpred_ai({ fEA_RI(RtV,siV*fVECSIZE()); fSTOREMMVNQ(EA,VsV,QvV);});
}

static void generate_V6_vS32b_nt_nqpred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int QvN = insn->regno[0];
    const intptr_t QvV_off =
        offsetof(CPUHexagonState, QRegs[QvN]);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    const int VsN = insn->regno[3];
    const intptr_t VsV_off = vreg_src_off(ctx, VsN);
    fGEN_TCG_V6_vS32b_nt_nqpred_ppu({ fEA_REG(RxV); fSTOREMMVNQ(EA,VsV,QvV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_pi({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_ai({ fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);});
}

static void generate_V6_vL32b_nt_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_ppu({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_cur_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_cur_pi({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_cur_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_cur_ai({ fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);});
}

static void generate_V6_vL32b_nt_cur_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_cur_ppu({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_tmp_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_tmp_pi({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_I(RxV,siV*fVECSIZE()); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_tmp_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[1];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_tmp_ai({ fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);});
}

static void generate_V6_vL32b_nt_tmp_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[1];
    TCGv RxV = get_result_gpr(ctx, RxN);
    tcg_gen_mov_tl(RxV, hex_gpr[RxN]);
    const int MuN = insn->regno[2] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_tmp_ppu({ fEA_REG(RxV); fLOADMMV(EA,VdV); fPM_M(RxV,MuV); });
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_nt_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_nt_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_cur_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_cur_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_cur_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_cur_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_nt_cur_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_cur_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_cur_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_cur_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_cur_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_cur_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_nt_cur_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_cur_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_tmp_pred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_tmp_pred_pi({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_tmp_pred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_tmp_pred_ai({ if (fLSBOLD(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_nt_tmp_pred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_tmp_pred_ppu({ if (fLSBOLD(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_tmp_npred_pi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_tmp_npred_pi({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_I(RxV,siV*fVECSIZE()); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_vL32b_nt_tmp_npred_ai(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int siV = insn->immed[0];
    fGEN_TCG_V6_vL32b_nt_tmp_npred_ai({ if (fLSBOLDNOT(PvV)) { fEA_RI(RtV,siV*fVECSIZE()); fLOADMMV(EA,VdV);;} else {CANCEL;}});
}

static void generate_V6_vL32b_nt_tmp_npred_ppu(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    TCGv EA G_GNUC_UNUSED = tcg_temp_new();
    const int PvN = insn->regno[0];
    TCGv PvV = hex_pred[PvN];
    const int VdN = insn->regno[1];
    const intptr_t VdV_off =
        ctx_tmp_vreg_off(ctx, VdN, 1, true);
    const int RxN = insn->regno[2];
    TCGv RxV = get_result_gpr(ctx, RxN);
    const int MuN = insn->regno[3] + HEX_REG_M0;
    TCGv MuV = hex_gpr[MuN];
    TCGv CS G_GNUC_UNUSED =
        hex_gpr[MuN - HEX_REG_M0 + HEX_REG_CS0];
    fGEN_TCG_V6_vL32b_nt_tmp_npred_ppu({ if (fLSBOLDNOT(PvV)) { fEA_REG(RxV); fLOADMMV(EA,VdV);; fPM_M(RxV,MuV); } else {CANCEL;}});
    gen_log_reg_write(ctx, RxN, RxV);
}

static void generate_V6_valignb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_valignb(VdV, VuV, VvV, RtV);
}

static void generate_V6_vlalignb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vlalignb(VdV, VuV, VvV, RtV);
}

static void generate_V6_valignbi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    int uiV = insn->immed[0];
    gen_helper_V6_valignbi(VdV, VuV, VvV, tcg_constant_tl(uiV));
}

static void generate_V6_vlalignbi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    int uiV = insn->immed[0];
    gen_helper_V6_vlalignbi(VdV, VuV, VvV, tcg_constant_tl(uiV));
}

static void generate_V6_vror(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vror(VdV, VuV, RtV);
}

static void generate_V6_vunpackub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vunpackub(VddV, VuV);
}

static void generate_V6_vunpackb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vunpackb(VddV, VuV);
}

static void generate_V6_vunpackuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vunpackuh(VddV, VuV);
}

static void generate_V6_vunpackh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vunpackh(VddV, VuV);
}

static void generate_V6_vunpackob(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vunpackob(VxxV, VuV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vunpackoh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vunpackoh(VxxV, VuV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vpackeb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackeb(VdV, VuV, VvV);
}

static void generate_V6_vpackeh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackeh(VdV, VuV, VvV);
}

static void generate_V6_vpackob(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackob(VdV, VuV, VvV);
}

static void generate_V6_vpackoh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackoh(VdV, VuV, VvV);
}

static void generate_V6_vpackhub_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackhub_sat(VdV, VuV, VvV);
}

static void generate_V6_vpackhb_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackhb_sat(VdV, VuV, VvV);
}

static void generate_V6_vpackwuh_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackwuh_sat(VdV, VuV, VvV);
}

static void generate_V6_vpackwh_sat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vpackwh_sat(VdV, VuV, VvV);
}

static void generate_V6_vzb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vzb(VddV, VuV);
}

static void generate_V6_vsb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vsb(VddV, VuV);
}

static void generate_V6_vzh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vzh(VddV, VuV);
}

static void generate_V6_vsh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    gen_helper_V6_vsh(VddV, VuV);
}

static void generate_V6_vdmpybus(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpybus(VdV, VuV, RtV);
}

static void generate_V6_vdmpybus_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpybus_acc(VxV, VuV, RtV);
}

static void generate_V6_vdmpybus_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpybus_dv(VddV, VuuV, RtV);
}

static void generate_V6_vdmpybus_dv_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpybus_dv_acc(VxxV, VuuV, RtV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vdmpyhb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhb(VdV, VuV, RtV);
}

static void generate_V6_vdmpyhb_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhb_acc(VxV, VuV, RtV);
}

static void generate_V6_vdmpyhb_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhb_dv(VddV, VuuV, RtV);
}

static void generate_V6_vdmpyhb_dv_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhb_dv_acc(VxxV, VuuV, RtV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vdmpyhvsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vdmpyhvsat(VdV, VuV, VvV);
}

static void generate_V6_vdmpyhvsat_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vdmpyhvsat_acc(VxV, VuV, VvV);
}

static void generate_V6_vdmpyhsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhsat(VdV, VuV, RtV);
}

static void generate_V6_vdmpyhsat_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhsat_acc(VxV, VuV, RtV);
}

static void generate_V6_vdmpyhisat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhisat(VdV, VuuV, RtV);
}

static void generate_V6_vdmpyhisat_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhisat_acc(VxV, VuuV, RtV);
}

static void generate_V6_vdmpyhsusat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhsusat(VdV, VuV, RtV);
}

static void generate_V6_vdmpyhsusat_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhsusat_acc(VxV, VuV, RtV);
}

static void generate_V6_vdmpyhsuisat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhsuisat(VdV, VuuV, RtV);
}

static void generate_V6_vdmpyhsuisat_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdmpyhsuisat_acc(VxV, VuuV, RtV);
}

static void generate_V6_vtmpyb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vtmpyb(VddV, VuuV, RtV);
}

static void generate_V6_vtmpyb_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vtmpyb_acc(VxxV, VuuV, RtV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vtmpybus(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vtmpybus(VddV, VuuV, RtV);
}

static void generate_V6_vtmpybus_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vtmpybus_acc(VxxV, VuuV, RtV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vtmpyhb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vtmpyhb(VddV, VuuV, RtV);
}

static void generate_V6_vtmpyhb_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vtmpyhb_acc(VxxV, VuuV, RtV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vrmpyub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vrmpyub(VdV, VuV, RtV);
}

static void generate_V6_vrmpyub_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vrmpyub_acc(VxV, VuV, RtV);
}

static void generate_V6_vrmpyubv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrmpyubv(VdV, VuV, VvV);
}

static void generate_V6_vrmpyubv_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrmpyubv_acc(VxV, VuV, VvV);
}

static void generate_V6_vrmpybv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrmpybv(VdV, VuV, VvV);
}

static void generate_V6_vrmpybv_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrmpybv_acc(VxV, VuV, VvV);
}

static void generate_V6_vrmpyubi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_V6_vrmpyubi(VddV, VuuV, RtV, tcg_constant_tl(uiV));
}

static void generate_V6_vrmpyubi_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_V6_vrmpyubi_acc(VxxV, VuuV, RtV, tcg_constant_tl(uiV));
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vrmpybus(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vrmpybus(VdV, VuV, RtV);
}

static void generate_V6_vrmpybus_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vrmpybus_acc(VxV, VuV, RtV);
}

static void generate_V6_vrmpybusi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_V6_vrmpybusi(VddV, VuuV, RtV, tcg_constant_tl(uiV));
}

static void generate_V6_vrmpybusi_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_V6_vrmpybusi_acc(VxxV, VuuV, RtV, tcg_constant_tl(uiV));
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vrmpybusv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrmpybusv(VdV, VuV, VvV);
}

static void generate_V6_vrmpybusv_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxV, tcg_env, VxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrmpybusv_acc(VxV, VuV, VvV);
}

static void generate_V6_vdsaduh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdsaduh(VddV, VuuV, RtV);
}

static void generate_V6_vdsaduh_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vdsaduh_acc(VxxV, VuuV, RtV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vrsadubi(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_V6_vrsadubi(VddV, VuuV, RtV, tcg_constant_tl(uiV));
}

static void generate_V6_vrsadubi_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    int uiV = insn->immed[0];
    gen_helper_V6_vrsadubi_acc(VxxV, VuuV, RtV, tcg_constant_tl(uiV));
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vasrw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vasrw({ fHIDE(int i;) fVFOREACH(32, i) { VdV.w[i] = (VuV.w[i] >> (RtV & (32-1))) ; } });
}

static void generate_V6_vaslw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vaslw({ fHIDE(int i;) fVFOREACH(32, i) { VdV.w[i] = (VuV.w[i] << (RtV & (32-1))) ; } });
}

static void generate_V6_vlsrw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vlsrw({ fHIDE(int i;) fVFOREACH(32, i) { VdV.uw[i] = (VuV.uw[i] >> (RtV & (32-1))) ; } });
}

static void generate_V6_vasrwv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vasrwv(VdV, VuV, VvV);
}

static void generate_V6_vaslwv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vaslwv(VdV, VuV, VvV);
}

static void generate_V6_vlsrwv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vlsrwv(VdV, VuV, VvV);
}

static void generate_V6_vasrh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vasrh({ fHIDE(int i;) fVFOREACH(16, i) { VdV.h[i] = (VuV.h[i] >> (RtV & (16-1))) ; } });
}

static void generate_V6_vaslh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vaslh({ fHIDE(int i;) fVFOREACH(16, i) { VdV.h[i] = (VuV.h[i] << (RtV & (16-1))) ; } });
}

static void generate_V6_vlsrh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vlsrh({ fHIDE(int i;) fVFOREACH(16, i) { VdV.uh[i] = (VuV.uh[i] >> (RtV & (16-1))) ; } });
}

static void generate_V6_vasrhv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vasrhv(VdV, VuV, VvV);
}

static void generate_V6_vaslhv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vaslhv(VdV, VuV, VvV);
}

static void generate_V6_vlsrhv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vlsrhv(VdV, VuV, VvV);
}

static void generate_V6_vlsrb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vlsrb({ fHIDE(int i;) fVFOREACH(8, i) { VdV.b[i] = VuV.ub[i] >> (RtV & 0x7) ; } });
}

static void generate_V6_vrotr(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrotr(VdV, VuV, VvV);
}

static void generate_V6_vasr_into(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxxN = insn->regno[0];
    const intptr_t VxxV_off =
        offsetof(CPUHexagonState, VxxV);
    tcg_gen_gvec_mov(MO_64, VxxV_off,
                     vreg_src_off(ctx, VxxN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VxxV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VxxN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VxxV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VxxV, tcg_env, VxxV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vasr_into(VxxV, VuV, VvV);
    gen_log_vreg_write_pair(ctx, VxxV_off, VxxN,
                            EXT_DFL);
}

static void generate_V6_vasrwh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrwh(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrwhsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrwhsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrwhrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrwhrndsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrwuhrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrwuhrndsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrwuhsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrwuhsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasruwuhrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasruwuhrndsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasruwuhsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasruwuhsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrhubsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrhubsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrhubrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrhubrndsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrhbsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrhbsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrhbrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasrhbrndsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasrvwuhsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vasrvwuhsat(VdV, VuuV, VvV);
}

static void generate_V6_vasrvwuhrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vasrvwuhrndsat(VdV, VuuV, VvV);
}

static void generate_V6_vasrvuhubsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vasrvuhubsat(VdV, VuuV, VvV);
}

static void generate_V6_vasrvuhubrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vasrvuhubrndsat(VdV, VuuV, VvV);
}

static void generate_V6_vasruhubsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasruhubsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vasruhubrndsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    const int RtN = insn->regno[3];
    TCGv RtV = hex_gpr[RtN];
    gen_helper_V6_vasruhubrndsat(VdV, VuV, VvV, RtV);
}

static void generate_V6_vroundwh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vroundwh(VdV, VuV, VvV);
}

static void generate_V6_vroundwuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vroundwuh(VdV, VuV, VvV);
}

static void generate_V6_vrounduwuh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrounduwuh(VdV, VuV, VvV);
}

static void generate_V6_vroundhb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vroundhb(VdV, VuV, VvV);
}

static void generate_V6_vroundhub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vroundhub(VdV, VuV, VvV);
}

static void generate_V6_vrounduhub(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vrounduhub(VdV, VuV, VvV);
}

static void generate_V6_vaslw_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vaslw_acc({ fHIDE(int i;) fVFOREACH(32, i) { VxV.w[i] += (VuV.w[i] << (RtV & (32-1))) ; } });
}

static void generate_V6_vasrw_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vasrw_acc({ fHIDE(int i;) fVFOREACH(32, i) { VxV.w[i] += (VuV.w[i] >> (RtV & (32-1))) ; } });
}

static void generate_V6_vaslh_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vaslh_acc({ fHIDE(int i;) fVFOREACH(16, i) { VxV.h[i] += (VuV.h[i] << (RtV & (16-1))) ; } });
}

static void generate_V6_vasrh_acc(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VxN = insn->regno[0];
    const intptr_t VxV_off =
        ctx_future_vreg_off(ctx, VxN, 1, true);
    tcg_gen_gvec_mov(MO_64, VxV_off,
                     vreg_src_off(ctx, VxN),
                     sizeof(MMVector), sizeof(MMVector));
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int RtN = insn->regno[2];
    TCGv RtV = hex_gpr[RtN];
    fGEN_TCG_V6_vasrh_acc({ fHIDE(int i;) fVFOREACH(16, i) { VxV.h[i] += (VuV.h[i] >> (RtV & (16-1))) ; } });
}

static void generate_V6_vaddb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    fGEN_TCG_V6_vaddb({ fHIDE(int i;) fVFOREACH(8, i) { VdV.b[i] = VuV.b[i] + VvV.b[i] ; } });
}

static void generate_V6_vsubb(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    fGEN_TCG_V6_vsubb({ fHIDE(int i;) fVFOREACH(8, i) { VdV.b[i] = VuV.b[i] - VvV.b[i] ; } });
}

static void generate_V6_vaddb_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    fGEN_TCG_V6_vaddb_dv({ fHIDE(int i;) fVFOREACH(8, i) { VddV.v[0].b[i] = VuuV.v[0].b[i] + VvvV.v[0].b[i]; VddV.v[1].b[i] = VuuV.v[1].b[i] + VvvV.v[1].b[i] ; } });
}

static void generate_V6_vsubb_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    fGEN_TCG_V6_vsubb_dv({ fHIDE(int i;) fVFOREACH(8, i) { VddV.v[0].b[i] = VuuV.v[0].b[i] - VvvV.v[0].b[i]; VddV.v[1].b[i] = VuuV.v[1].b[i] - VvvV.v[1].b[i] ; } });
}

static void generate_V6_vaddh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    fGEN_TCG_V6_vaddh({ fHIDE(int i;) fVFOREACH(16, i) { VdV.h[i] = VuV.h[i] + VvV.h[i] ; } });
}

static void generate_V6_vsubh(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    fGEN_TCG_V6_vsubh({ fHIDE(int i;) fVFOREACH(16, i) { VdV.h[i] = VuV.h[i] - VvV.h[i] ; } });
}

static void generate_V6_vaddh_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    fGEN_TCG_V6_vaddh_dv({ fHIDE(int i;) fVFOREACH(16, i) { VddV.v[0].h[i] = VuuV.v[0].h[i] + VvvV.v[0].h[i]; VddV.v[1].h[i] = VuuV.v[1].h[i] + VvvV.v[1].h[i] ; } });
}

static void generate_V6_vsubh_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    fGEN_TCG_V6_vsubh_dv({ fHIDE(int i;) fVFOREACH(16, i) { VddV.v[0].h[i] = VuuV.v[0].h[i] - VvvV.v[0].h[i]; VddV.v[1].h[i] = VuuV.v[1].h[i] - VvvV.v[1].h[i] ; } });
}

static void generate_V6_vaddw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    fGEN_TCG_V6_vaddw({ fHIDE(int i;) fVFOREACH(32, i) { VdV.w[i] = VuV.w[i] + VvV.w[i] ; } });
}

static void generate_V6_vsubw(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    fGEN_TCG_V6_vsubw({ fHIDE(int i;) fVFOREACH(32, i) { VdV.w[i] = VuV.w[i] - VvV.w[i] ; } });
}

static void generate_V6_vaddw_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    fGEN_TCG_V6_vaddw_dv({ fHIDE(int i;) fVFOREACH(32, i) { VddV.v[0].w[i] = VuuV.v[0].w[i] + VvvV.v[0].w[i]; VddV.v[1].w[i] = VuuV.v[1].w[i] + VvvV.v[1].w[i] ; } });
}

static void generate_V6_vsubw_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    fGEN_TCG_V6_vsubw_dv({ fHIDE(int i;) fVFOREACH(32, i) { VddV.v[0].w[i] = VuuV.v[0].w[i] - VvvV.v[0].w[i]; VddV.v[1].w[i] = VuuV.v[1].w[i] - VvvV.v[1].w[i] ; } });
}

static void generate_V6_vaddubsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vaddubsat(VdV, VuV, VvV);
}

static void generate_V6_vaddubsat_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VvvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvvV, tcg_env, VvvV_off);
    gen_helper_V6_vaddubsat_dv(VddV, VuuV, VvvV);
}

static void generate_V6_vsububsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vsububsat(VdV, VuV, VvV);
}

static void generate_V6_vsububsat_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VvvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvvV, tcg_env, VvvV_off);
    gen_helper_V6_vsububsat_dv(VddV, VuuV, VvvV);
}

static void generate_V6_vadduhsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vadduhsat(VdV, VuV, VvV);
}

static void generate_V6_vadduhsat_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VvvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvvV, tcg_env, VvvV_off);
    gen_helper_V6_vadduhsat_dv(VddV, VuuV, VvvV);
}

static void generate_V6_vsubuhsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vsubuhsat(VdV, VuV, VvV);
}

static void generate_V6_vsubuhsat_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VvvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvvV, tcg_env, VvvV_off);
    gen_helper_V6_vsubuhsat_dv(VddV, VuuV, VvvV);
}

static void generate_V6_vadduwsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vadduwsat(VdV, VuV, VvV);
}

static void generate_V6_vadduwsat_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VvvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvvV, tcg_env, VvvV_off);
    gen_helper_V6_vadduwsat_dv(VddV, VuuV, VvvV);
}

static void generate_V6_vsubuwsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vsubuwsat(VdV, VuV, VvV);
}

static void generate_V6_vsubuwsat_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuuV, tcg_env, VuuV_off);
    const int VvvN = insn->regno[2];
    const intptr_t VvvV_off =
        offsetof(CPUHexagonState, VvvV);
    tcg_gen_gvec_mov(MO_64, VvvV_off,
                     vreg_src_off(ctx, VvvN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VvvV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VvvN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VvvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvvV, tcg_env, VvvV_off);
    gen_helper_V6_vsubuwsat_dv(VddV, VuuV, VvvV);
}

static void generate_V6_vaddbsat(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VdN = insn->regno[0];
    const intptr_t VdV_off =
        ctx_future_vreg_off(ctx, VdN, 1, true);
    TCGv_ptr VdV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VdV, tcg_env, VdV_off);
    const int VuN = insn->regno[1];
    const intptr_t VuV_off = vreg_src_off(ctx, VuN);
    TCGv_ptr VuV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VuV, tcg_env, VuV_off);
    const int VvN = insn->regno[2];
    const intptr_t VvV_off = vreg_src_off(ctx, VvN);
    TCGv_ptr VvV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VvV, tcg_env, VvV_off);
    gen_helper_V6_vaddbsat(VdV, VuV, VvV);
}

static void generate_V6_vaddbsat_dv(DisasContext *ctx)
{
    Insn *insn G_GNUC_UNUSED = ctx->insn;
    const int VddN = insn->regno[0];
    const intptr_t VddV_off =
        ctx_future_vreg_off(ctx, VddN, 2, true);
    TCGv_ptr VddV = tcg_temp_new_ptr();
    tcg_gen_addi_ptr(VddV, tcg_env, VddV_off);
    const int VuuN = insn->regno[1];
    const intptr_t VuuV_off =
        offsetof(CPUHexagonState, VuuV);
    tcg_gen_gvec_mov(MO_64, VuuV_off,
                     vreg_src_off(ctx, VuuN),
                     sizeof(MMVector), sizeof(MMVector));
    tcg_gen_gvec_mov(MO_64, VuuV_off + sizeof(MMVector),
                     vreg_src_off(ctx, VuuN ^ 1),
                     sizeof(MMVector), sizeof(MMVector));
    TCGv_ptr VuuV = tcg_temp_new_ptr();
    tcg_