/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.14.0
 *
 * Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt6.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtQuick.h"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtQuick/qsggeometry.sip"
#include <qsggeometry.h>
#line 48 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtQuick/qsggeometry.sip"
#include <qsggeometry.h>
#include <QList>
#line 32 "/build/pyqt6/src/pyqt6-6.10.1/build/QtQuick/sipQtQuickQSGGeometryAttributeSet.cpp"

#line 26 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtQuick/qsggeometry.sip"
#include <qsggeometry.h>
#line 33 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtQuick/qsggeometry.sip"
#include <qsggeometry.h>
#line 38 "/build/pyqt6/src/pyqt6-6.10.1/build/QtQuick/sipQtQuickQSGGeometryAttributeSet.cpp"


/* Call the instance's destructor. */
extern "C" {static void release_QSGGeometry_AttributeSet(void *, int);}
static void release_QSGGeometry_AttributeSet(void *sipCppV, int)
{
    delete reinterpret_cast< ::QSGGeometry::AttributeSet *>(sipCppV);
}


extern "C" {static void dealloc_QSGGeometry_AttributeSet(sipSimpleWrapper *);}
static void dealloc_QSGGeometry_AttributeSet(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QSGGeometry_AttributeSet(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QSGGeometry_AttributeSet(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QSGGeometry_AttributeSet(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QSGGeometry::AttributeSet *sipCpp = SIP_NULLPTR;

    {
        PyObject * a0;
        int a1 = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_stride,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "P0|i", &a0, &a1))
        {
            sipErrorState sipError = sipErrorNone;

#line 54 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtQuick/qsggeometry.sip"
            PyObject *iter = PyObject_GetIter(a0);
            
            if (!iter || PyUnicode_Check(a0))
            {
                Py_XDECREF(iter);
                PyErr_SetString(PyExc_TypeError, "iterable object expected");
                sipError = sipErrorContinue;
            }
            else
            {
                QList<QSGGeometry::Attribute> attrs;
                int stride = 0;
            
                for (Py_ssize_t i = 0; ; ++i)
                {
                    PyErr_Clear();
                    PyObject *itm = PyIter_Next(iter);
            
                    if (!itm)
                    {
                        if (PyErr_Occurred())
                            sipError = sipErrorFail;
            
                        break;
                    }
            
                    int state, is_err = 0;
                    QSGGeometry::Attribute *attr;
            
                    attr = reinterpret_cast<QSGGeometry::Attribute *>(
                            sipForceConvertToType(itm, sipType_QSGGeometry_Attribute, 0,
                            SIP_NOT_NONE, &state, &is_err));
            
                    if (is_err)
                    {
                        PyErr_Format(PyExc_TypeError,
                                "index %zd has type '%s' but 'QSGGeometry.Attribute' is expected",
                                i, sipPyTypeName(Py_TYPE(itm)));
            
                        Py_DECREF(itm);
                        sipError = sipErrorFail;
            
                        break;
                    }
            
                    // Calculate the stride if there no explicit one.
                    if (a1 <= 0)
                    {
                        int size;
            
                        switch (attr->type)
                        {
                        case QSGGeometry::ByteType:
                            size = sizeof (qint8);
                            break;
            
                        case QSGGeometry::DoubleType:
                            size = sizeof (double);
                            break;
            
                        case QSGGeometry::FloatType:
                            size = sizeof (float);
                            break;
            
                        case QSGGeometry::IntType:
                            size = sizeof (qint32);
                            break;
            
                        default:
                            size = 0;
                        }
            
                        if (!size)
                        {
                            PyErr_Format(PyExc_TypeError,
                                    "index %zd has an unsupported primitive type",
                                    i);
            
                            sipReleaseType(attr, sipType_QSGGeometry_Attribute, state);
                            Py_DECREF(itm);
                            sipError = sipErrorFail;
            
                            break;
                        }
            
                        stride += attr->tupleSize * size;
                    }
            
                    attrs.append(*attr);
            
                    sipReleaseType(attr, sipType_QSGGeometry_Attribute, state);
                    Py_DECREF(itm);
                }
            
                Py_DECREF(iter);
            
                if (sipError == sipErrorNone)
                {
                    if (attrs.isEmpty())
                    {
                        PyErr_SetString(PyExc_TypeError, "no attributes defined");
                        sipError = sipErrorFail;
                    }
                    else
                    {
                        PyObject *bytes = PyBytes_FromStringAndSize(
                                reinterpret_cast<char *>(attrs.data()),
                                sizeof (QSGGeometry::Attribute) * attrs.size());
            
                        if (!bytes)
                        {
                            sipError = sipErrorFail;
                        }
                        else
                        {
                            sipCpp = new QSGGeometry::AttributeSet;
            
                            sipCpp->count = attrs.size();
                            sipCpp->stride = (a1 > 0 ? a1 : stride);
                            sipCpp->attributes = reinterpret_cast<QSGGeometry::Attribute *>(
                                    PyBytes_AsString(bytes));
            
                            sipSetUserObject(sipSelf, bytes);
                        }
                    }
                }
            }
#line 205 "/build/pyqt6/src/pyqt6-6.10.1/build/QtQuick/sipQtQuickQSGGeometryAttributeSet.cpp"

            if (sipError == sipErrorNone)
                return sipCpp;

            if (sipUnused)
            {
                Py_XDECREF(*sipUnused);
            }

            sipAddException(sipError, sipParseErr);

            if (sipError == sipErrorFail)
                return SIP_NULLPTR;
        }
    }

    return SIP_NULLPTR;
}


extern "C" {static PyObject *varget_QSGGeometry_AttributeSet_attributes(void *, PyObject *, PyObject *);}
static PyObject *varget_QSGGeometry_AttributeSet_attributes(void *sipSelf, PyObject *, PyObject *)
{
    PyObject *sipPy;
    ::QSGGeometry::AttributeSet *sipCpp = reinterpret_cast< ::QSGGeometry::AttributeSet *>(sipSelf);

#line 187 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtQuick/qsggeometry.sip"
            sipPy = sipConvertToTypedArray((void *)sipCpp->attributes,
                    sipType_QSGGeometry_Attribute, "iiiI", sizeof (QSGGeometry::Attribute),
                    sipCpp->count, SIP_READ_ONLY);
#line 236 "/build/pyqt6/src/pyqt6-6.10.1/build/QtQuick/sipQtQuickQSGGeometryAttributeSet.cpp"

    return sipPy;
}


extern "C" {static int varset_QSGGeometry_AttributeSet_attributes(void *, PyObject *, PyObject *);}
static int varset_QSGGeometry_AttributeSet_attributes(void *, PyObject *, PyObject *)
{
   int sipErr = 0;

#line 193 "/build/pyqt6/src/pyqt6-6.10.1/sip/QtQuick/qsggeometry.sip"
            sipErr = 1;
            PyErr_SetString(PyExc_ValueError, "array is read-only");
#line 250 "/build/pyqt6/src/pyqt6-6.10.1/build/QtQuick/sipQtQuickQSGGeometryAttributeSet.cpp"

    return (sipErr ? -1 : 0);
}


extern "C" {static PyObject *varget_QSGGeometry_AttributeSet_count(void *, PyObject *, PyObject *);}
static PyObject *varget_QSGGeometry_AttributeSet_count(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::QSGGeometry::AttributeSet *sipCpp = reinterpret_cast< ::QSGGeometry::AttributeSet *>(sipSelf);

    sipVal = sipCpp->count;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_QSGGeometry_AttributeSet_count(void *, PyObject *, PyObject *);}
static int varset_QSGGeometry_AttributeSet_count(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QSGGeometry::AttributeSet *sipCpp = reinterpret_cast< ::QSGGeometry::AttributeSet *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->count = sipVal;

    return 0;
}


extern "C" {static PyObject *varget_QSGGeometry_AttributeSet_stride(void *, PyObject *, PyObject *);}
static PyObject *varget_QSGGeometry_AttributeSet_stride(void *sipSelf, PyObject *, PyObject *)
{
    int sipVal;
    ::QSGGeometry::AttributeSet *sipCpp = reinterpret_cast< ::QSGGeometry::AttributeSet *>(sipSelf);

    sipVal = sipCpp->stride;

    return PyLong_FromLong(sipVal);
}


extern "C" {static int varset_QSGGeometry_AttributeSet_stride(void *, PyObject *, PyObject *);}
static int varset_QSGGeometry_AttributeSet_stride(void *sipSelf, PyObject *sipPy, PyObject *)
{
    int sipVal;
    ::QSGGeometry::AttributeSet *sipCpp = reinterpret_cast< ::QSGGeometry::AttributeSet *>(sipSelf);

    sipVal = sipLong_AsInt(sipPy);

    if (PyErr_Occurred() != SIP_NULLPTR)
        return -1;

    sipCpp->stride = sipVal;

    return 0;
}

sipVariableDef variables_QSGGeometry_AttributeSet[] = {
    {InstanceVariable, sipName_attributes, (PyMethodDef *)varget_QSGGeometry_AttributeSet_attributes, (PyMethodDef *)varset_QSGGeometry_AttributeSet_attributes, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_count, (PyMethodDef *)varget_QSGGeometry_AttributeSet_count, (PyMethodDef *)varset_QSGGeometry_AttributeSet_count, SIP_NULLPTR, SIP_NULLPTR},
    {InstanceVariable, sipName_stride, (PyMethodDef *)varget_QSGGeometry_AttributeSet_stride, (PyMethodDef *)varset_QSGGeometry_AttributeSet_stride, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_QSGGeometry_AttributeSet, "\1QSGGeometry.AttributeSet(attributes: Iterable[QSGGeometry.Attribute], stride: int = 0)");


sipClassTypeDef sipTypeDef_QtQuick_QSGGeometry_AttributeSet = {
    {
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QSGGeometry__AttributeSet,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_AttributeSet,
        {56, 255, 0},
        0, SIP_NULLPTR,
        3, variables_QSGGeometry_AttributeSet,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QSGGeometry_AttributeSet,
    -1,
    sipNameNr_PyQt6_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QSGGeometry_AttributeSet,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QSGGeometry_AttributeSet,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_QSGGeometry_AttributeSet,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    sizeof (::QSGGeometry::AttributeSet),
};
