#pragma once
// make cno/hpack-data.h
enum {
    CNO_HPACK_STATIC_TABLE_SIZE = 61,
    CNO_HUFFMAN_MIN_BITS_PER_CHAR = 5,
};
struct cno_huffman_state_t { uint32_t next : 13, accept : 1, emit1 : 1, emit2 : 1, byte1 : 8, byte2 : 8; };
static const struct cno_header_t CNO_HPACK_STATIC_TABLE[] = {{{":authority",10},{"",0},0},{{":method",7},{"GET",3},0},{{":method",7},{"POST",4},0},{{":path",5},{"/",1},0},{{":path",5},{"/index.html",11},0},{{":scheme",7},{"http",4},0},{{":scheme",7},{"https",5},0},{{":status",7},{"200",3},0},{{":status",7},{"204",3},0},{{":status",7},{"206",3},0},{{":status",7},{"304",3},0},{{":status",7},{"400",3},0},{{":status",7},{"404",3},0},{{":status",7},{"500",3},0},{{"accept-charset",14},{"",0},0},{{"accept-encoding",15},{"gzip, deflate",13},0},{{"accept-language",15},{"",0},0},{{"accept-ranges",13},{"",0},0},{{"accept",6},{"",0},0},{{"access-control-allow-origin",27},{"",0},0},{{"age",3},{"",0},0},{{"allow",5},{"",0},0},{{"authorization",13},{"",0},0},{{"cache-control",13},{"",0},0},{{"content-disposition",19},{"",0},0},{{"content-encoding",16},{"",0},0},{{"content-language",16},{"",0},0},{{"content-length",14},{"",0},0},{{"content-location",16},{"",0},0},{{"content-range",13},{"",0},0},{{"content-type",12},{"",0},0},{{"cookie",6},{"",0},0},{{"date",4},{"",0},0},{{"etag",4},{"",0},0},{{"expect",6},{"",0},0},{{"expires",7},{"",0},0},{{"from",4},{"",0},0},{{"host",4},{"",0},0},{{"if-match",8},{"",0},0},{{"if-modified-since",17},{"",0},0},{{"if-none-match",13},{"",0},0},{{"if-range",8},{"",0},0},{{"if-unmodified-since",19},{"",0},0},{{"last-modified",13},{"",0},0},{{"link",4},{"",0},0},{{"location",8},{"",0},0},{{"max-forwards",12},{"",0},0},{{"proxy-authenticate",18},{"",0},0},{{"proxy-authorization",19},{"",0},0},{{"range",5},{"",0},0},{{"referer",7},{"",0},0},{{"refresh",7},{"",0},0},{{"retry-after",11},{"",0},0},{{"server",6},{"",0},0},{{"set-cookie",10},{"",0},0},{{"strict-transport-security",25},{"",0},0},{{"transfer-encoding",17},{"",0},0},{{"user-agent",10},{"",0},0},{{"vary",4},{"",0},0},{{"via",3},{"",0},0},{{"www-authenticate",16},{"",0},0}};
static const uint32_t CNO_HUFFMAN_ENC[] = {8184UL,8388568UL,268435426UL,268435427UL,268435428UL,268435429UL,268435430UL,268435431UL,268435432UL,16777194UL,1073741820UL,268435433UL,268435434UL,1073741821UL,268435435UL,268435436UL,268435437UL,268435438UL,268435439UL,268435440UL,268435441UL,268435442UL,1073741822UL,268435443UL,268435444UL,268435445UL,268435446UL,268435447UL,268435448UL,268435449UL,268435450UL,268435451UL,20UL,1016UL,1017UL,4090UL,8185UL,21UL,248UL,2042UL,1018UL,1019UL,249UL,2043UL,250UL,22UL,23UL,24UL,0UL,1UL,2UL,25UL,26UL,27UL,28UL,29UL,30UL,31UL,92UL,251UL,32764UL,32UL,4091UL,1020UL,8186UL,33UL,93UL,94UL,95UL,96UL,97UL,98UL,99UL,100UL,101UL,102UL,103UL,104UL,105UL,106UL,107UL,108UL,109UL,110UL,111UL,112UL,113UL,114UL,252UL,115UL,253UL,8187UL,524272UL,8188UL,16380UL,34UL,32765UL,3UL,35UL,4UL,36UL,5UL,37UL,38UL,39UL,6UL,116UL,117UL,40UL,41UL,42UL,7UL,43UL,118UL,44UL,8UL,9UL,45UL,119UL,120UL,121UL,122UL,123UL,32766UL,2044UL,16381UL,8189UL,268435452UL,1048550UL,4194258UL,1048551UL,1048552UL,4194259UL,4194260UL,4194261UL,8388569UL,4194262UL,8388570UL,8388571UL,8388572UL,8388573UL,8388574UL,16777195UL,8388575UL,16777196UL,16777197UL,4194263UL,8388576UL,16777198UL,8388577UL,8388578UL,8388579UL,8388580UL,2097116UL,4194264UL,8388581UL,4194265UL,8388582UL,8388583UL,16777199UL,4194266UL,2097117UL,1048553UL,4194267UL,4194268UL,8388584UL,8388585UL,2097118UL,8388586UL,4194269UL,4194270UL,16777200UL,2097119UL,4194271UL,8388587UL,8388588UL,2097120UL,2097121UL,4194272UL,2097122UL,8388589UL,4194273UL,8388590UL,8388591UL,1048554UL,4194274UL,4194275UL,4194276UL,8388592UL,4194277UL,4194278UL,8388593UL,67108832UL,67108833UL,1048555UL,524273UL,4194279UL,8388594UL,4194280UL,33554412UL,67108834UL,67108835UL,67108836UL,134217694UL,134217695UL,67108837UL,16777201UL,33554413UL,524274UL,2097123UL,67108838UL,134217696UL,134217697UL,67108839UL,134217698UL,16777202UL,2097124UL,2097125UL,67108840UL,67108841UL,268435453UL,134217699UL,134217700UL,134217701UL,1048556UL,16777203UL,1048557UL,2097126UL,4194281UL,2097127UL,2097128UL,8388595UL,4194282UL,4194283UL,33554414UL,33554415UL,16777204UL,16777205UL,67108842UL,8388596UL,67108843UL,134217702UL,67108844UL,67108845UL,134217703UL,134217704UL,134217705UL,134217706UL,134217707UL,268435454UL,134217708UL,134217709UL,134217710UL,134217711UL,134217712UL,67108846UL};
static const uint8_t CNO_HUFFMAN_LEN[] = {13,23,28,28,28,28,28,28,28,24,30,28,28,30,28,28,28,28,28,28,28,28,30,28,28,28,28,28,28,28,28,28,6,10,10,12,13,6,8,11,10,10,8,11,8,6,6,6,5,5,5,6,6,6,6,6,6,6,7,8,15,6,12,10,13,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,7,8,13,19,13,14,6,15,5,6,5,6,5,6,6,6,5,7,7,6,6,6,5,6,7,6,5,5,6,7,7,7,7,7,15,11,14,13,28,20,22,20,20,22,22,22,23,22,23,23,23,23,23,24,23,24,24,22,23,24,23,23,23,23,21,22,23,22,23,23,24,22,21,20,22,22,23,23,21,23,22,22,24,21,22,23,23,21,21,22,21,23,22,23,23,20,22,22,22,23,22,22,23,26,26,20,19,22,23,22,25,26,26,26,27,27,26,24,25,19,21,26,27,27,26,27,24,21,21,26,26,28,27,27,27,20,24,20,21,22,21,21,23,22,22,25,25,24,24,26,23,26,27,26,26,27,27,27,27,27,28,27,27,27,27,27,26};
static const struct cno_huffman_state_t CNO_HUFFMAN_STATE[] = {{1,0,0,1,0,48},{2,0,0,1,0,48},{3,0,0,1,0,48},{4,0,0,1,0,48},{5,0,0,1,0,48},{6,0,0,1,0,48},{7,0,0,1,0,48},{8,1,0,1,0,48},{1,0,0,1,0,49},{2,0,0,1,0,49},{3,0,0,1,0,49},{4,0,0,1,0,49},{5,0,0,1,0,49},{6,0,0,1,0,49},{7,0,0,1,0,49},{8,1,0,1,0,49},{1,0,0,1,0,50},{2,0,0,1,0,50},{3,0,0,1,0,50},{4,0,0,1,0,50},{5,0,0,1,0,50},{6,0,0,1,0,50},{7,0,0,1,0,50},{8,1,0,1,0,50},{1,0,0,1,0,97},{2,0,0,1,0,97},{3,0,0,1,0,97},{4,0,0,1,0,97},{5,0,0,1,0,97},{6,0,0,1,0,97},{7,0,0,1,0,97},{8,1,0,1,0,97},{1,0,0,1,0,99},{2,0,0,1,0,99},{3,0,0,1,0,99},{4,0,0,1,0,99},{5,0,0,1,0,99},{6,0,0,1,0,99},{7,0,0,1,0,99},{8,1,0,1,0,99},{1,0,0,1,0,101},{2,0,0,1,0,101},{3,0,0,1,0,101},{4,0,0,1,0,101},{5,0,0,1,0,101},{6,0,0,1,0,101},{7,0,0,1,0,101},{8,1,0,1,0,101},{1,0,0,1,0,105},{2,0,0,1,0,105},{3,0,0,1,0,105},{4,0,0,1,0,105},{5,0,0,1,0,105},{6,0,0,1,0,105},{7,0,0,1,0,105},{8,1,0,1,0,105},{1,0,0,1,0,111},{2,0,0,1,0,111},{3,0,0,1,0,111},{4,0,0,1,0,111},{5,0,0,1,0,111},{6,0,0,1,0,111},{7,0,0,1,0,111},{8,1,0,1,0,111},{1,0,0,1,0,115},{2,0,0,1,0,115},{3,0,0,1,0,115},{4,0,0,1,0,115},{5,0,0,1,0,115},{6,0,0,1,0,115},{7,0,0,1,0,115},{8,1,0,1,0,115},{1,0,0,1,0,116},{2,0,0,1,0,116},{3,0,0,1,0,116},{4,0,0,1,0,116},{5,0,0,1,0,116},{6,0,0,1,0,116},{7,0,0,1,0,116},{8,1,0,1,0,116},{9,0,0,1,0,32},{10,0,0,1,0,32},{11,0,0,1,0,32},{12,1,0,1,0,32},{9,0,0,1,0,37},{10,0,0,1,0,37},{11,0,0,1,0,37},{12,1,0,1,0,37},{9,0,0,1,0,45},{10,0,0,1,0,45},{11,0,0,1,0,45},{12,1,0,1,0,45},{9,0,0,1,0,46},{10,0,0,1,0,46},{11,0,0,1,0,46},{12,1,0,1,0,46},{9,0,0,1,0,47},{10,0,0,1,0,47},{11,0,0,1,0,47},{12,1,0,1,0,47},{9,0,0,1,0,51},{10,0,0,1,0,51},{11,0,0,1,0,51},{12,1,0,1,0,51},{9,0,0,1,0,52},{10,0,0,1,0,52},{11,0,0,1,0,52},{12,1,0,1,0,52},{9,0,0,1,0,53},{10,0,0,1,0,53},{11,0,0,1,0,53},{12,1,0,1,0,53},{9,0,0,1,0,54},{10,0,0,1,0,54},{11,0,0,1,0,54},{12,1,0,1,0,54},{9,0,0,1,0,55},{10,0,0,1,0,55},{11,0,0,1,0,55},{12,1,0,1,0,55},{9,0,0,1,0,56},{10,0,0,1,0,56},{11,0,0,1,0,56},{12,1,0,1,0,56},{9,0,0,1,0,57},{10,0,0,1,0,57},{11,0,0,1,0,57},{12,1,0,1,0,57},{9,0,0,1,0,61},{10,0,0,1,0,61},{11,0,0,1,0,61},{12,1,0,1,0,61},{9,0,0,1,0,65},{10,0,0,1,0,65},{11,0,0,1,0,65},{12,1,0,1,0,65},{9,0,0,1,0,95},{10,0,0,1,0,95},{11,0,0,1,0,95},{12,1,0,1,0,95},{9,0,0,1,0,98},{10,0,0,1,0,98},{11,0,0,1,0,98},{12,1,0,1,0,98},{9,0,0,1,0,100},{10,0,0,1,0,100},{11,0,0,1,0,100},{12,1,0,1,0,100},{9,0,0,1,0,102},{10,0,0,1,0,102},{11,0,0,1,0,102},{12,1,0,1,0,102},{9,0,0,1,0,103},{10,0,0,1,0,103},{11,0,0,1,0,103},{12,1,0,1,0,103},{9,0,0,1,0,104},{10,0,0,1,0,104},{11,0,0,1,0,104},{12,1,0,1,0,104},{9,0,0,1,0,108},{10,0,0,1,0,108},{11,0,0,1,0,108},{12,1,0,1,0,108},{9,0,0,1,0,109},{10,0,0,1,0,109},{11,0,0,1,0,109},{12,1,0,1,0,109},{9,0,0,1,0,110},{10,0,0,1,0,110},{11,0,0,1,0,110},{12,1,0,1,0,110},{9,0,0,1,0,112},{10,0,0,1,0,112},{11,0,0,1,0,112},{12,1,0,1,0,112},{9,0,0,1,0,114},{10,0,0,1,0,114},{11,0,0,1,0,114},{12,1,0,1,0,114},{9,0,0,1,0,117},{10,0,0,1,0,117},{11,0,0,1,0,117},{12,1,0,1,0,117},{13,0,0,1,0,58},{14,1,0,1,0,58},{13,0,0,1,0,66},{14,1,0,1,0,66},{13,0,0,1,0,67},{14,1,0,1,0,67},{13,0,0,1,0,68},{14,1,0,1,0,68},{13,0,0,1,0,69},{14,1,0,1,0,69},{13,0,0,1,0,70},{14,1,0,1,0,70},{13,0,0,1,0,71},{14,1,0,1,0,71},{13,0,0,1,0,72},{14,1,0,1,0,72},{13,0,0,1,0,73},{14,1,0,1,0,73},{13,0,0,1,0,74},{14,1,0,1,0,74},{13,0,0,1,0,75},{14,1,0,1,0,75},{13,0,0,1,0,76},{14,1,0,1,0,76},{13,0,0,1,0,77},{14,1,0,1,0,77},{13,0,0,1,0,78},{14,1,0,1,0,78},{13,0,0,1,0,79},{14,1,0,1,0,79},{13,0,0,1,0,80},{14,1,0,1,0,80},{13,0,0,1,0,81},{14,1,0,1,0,81},{13,0,0,1,0,82},{14,1,0,1,0,82},{13,0,0,1,0,83},{14,1,0,1,0,83},{13,0,0,1,0,84},{14,1,0,1,0,84},{13,0,0,1,0,85},{14,1,0,1,0,85},{13,0,0,1,0,86},{14,1,0,1,0,86},{13,0,0,1,0,87},{14,1,0,1,0,87},{13,0,0,1,0,89},{14,1,0,1,0,89},{13,0,0,1,0,106},{14,1,0,1,0,106},{13,0,0,1,0,107},{14,1,0,1,0,107},{13,0,0,1,0,113},{14,1,0,1,0,113},{13,0,0,1,0,118},{14,1,0,1,0,118},{13,0,0,1,0,119},{14,1,0,1,0,119},{13,0,0,1,0,120},{14,1,0,1,0,120},{13,0,0,1,0,121},{14,1,0,1,0,121},{13,0,0,1,0,122},{14,1,0,1,0,122},{0,1,0,1,0,38},{0,1,0,1,0,42},{0,1,0,1,0,44},{0,1,0,1,0,59},{0,1,0,1,0,88},{0,1,0,1,0,90},{15,0,0,0,0,0},{16,0,0,0,0,0},{13,0,1,1,48,48},{14,1,1,1,48,48},{13,0,1,1,48,49},{14,1,1,1,48,49},{13,0,1,1,48,50},{14,1,1,1,48,50},{13,0,1,1,48,97},{14,1,1,1,48,97},{13,0,1,1,48,99},{14,1,1,1,48,99},{13,0,1,1,48,101},{14,1,1,1,48,101},{13,0,1,1,48,105},{14,1,1,1,48,105},{13,0,1,1,48,111},{14,1,1,1,48,111},{13,0,1,1,48,115},{14,1,1,1,48,115},{13,0,1,1,48,116},{14,1,1,1,48,116},{0,1,1,1,48,32},{0,1,1,1,48,37},{0,1,1,1,48,45},{0,1,1,1,48,46},{0,1,1,1,48,47},{0,1,1,1,48,51},{0,1,1,1,48,52},{0,1,1,1,48,53},{0,1,1,1,48,54},{0,1,1,1,48,55},{0,1,1,1,48,56},{0,1,1,1,48,57},{0,1,1,1,48,61},{0,1,1,1,48,65},{0,1,1,1,48,95},{0,1,1,1,48,98},{0,1,1,1,48,100},{0,1,1,1,48,102},{0,1,1,1,48,103},{0,1,1,1,48,104},{0,1,1,1,48,108},{0,1,1,1,48,109},{0,1,1,1,48,110},{0,1,1,1,48,112},{0,1,1,1,48,114},{0,1,1,1,48,117},{17,0,0,1,0,48},{18,0,0,1,0,48},{19,0,0,1,0,48},{20,0,0,1,0,48},{21,0,0,1,0,48},{22,0,0,1,0,48},{23,0,0,1,0,48},{24,0,0,1,0,48},{25,0,0,1,0,48},{26,0,0,1,0,48},{27,0,0,1,0,48},{28,0,0,1,0,48},{29,0,0,1,0,48},{30,0,0,1,0,48},{31,0,0,1,0,48},{32,0,0,1,0,48},{33,0,0,1,0,48},{34,1,0,1,0,48},{13,0,1,1,49,48},{14,1,1,1,49,48},{13,0,1,1,49,49},{14,1,1,1,49,49},{13,0,1,1,49,50},{14,1,1,1,49,50},{13,0,1,1,49,97},{14,1,1,1,49,97},{13,0,1,1,49,99},{14,1,1,1,49,99},{13,0,1,1,49,101},{14,1,1,1,49,101},{13,0,1,1,49,105},{14,1,1,1,49,105},{13,0,1,1,49,111},{14,1,1,1,49,111},{13,0,1,1,49,115},{14,1,1,1,49,115},{13,0,1,1,49,116},{14,1,1,1,49,116},{0,1,1,1,49,32},{0,1,1,1,49,37},{0,1,1,1,49,45},{0,1,1,1,49,46},{0,1,1,1,49,47},{0,1,1,1,49,51},{0,1,1,1,49,52},{0,1,1,1,49,53},{0,1,1,1,49,54},{0,1,1,1,49,55},{0,1,1,1,49,56},{0,1,1,1,49,57},{0,1,1,1,49,61},{0,1,1,1,49,65},{0,1,1,1,49,95},{0,1,1,1,49,98},{0,1,1,1,49,100},{0,1,1,1,49,102},{0,1,1,1,49,103},{0,1,1,1,49,104},{0,1,1,1,49,108},{0,1,1,1,49,109},{0,1,1,1,49,110},{0,1,1,1,49,112},{0,1,1,1,49,114},{0,1,1,1,49,117},{17,0,0,1,0,49},{18,0,0,1,0,49},{19,0,0,1,0,49},{20,0,0,1,0,49},{21,0,0,1,0,49},{22,0,0,1,0,49},{23,0,0,1,0,49},{24,0,0,1,0,49},{25,0,0,1,0,49},{26,0,0,1,0,49},{27,0,0,1,0,49},{28,0,0,1,0,49},{29,0,0,1,0,49},{30,0,0,1,0,49},{31,0,0,1,0,49},{32,0,0,1,0,49},{33,0,0,1,0,49},{34,1,0,1,0,49},{13,0,1,1,50,48},{14,1,1,1,50,48},{13,0,1,1,50,49},{14,1,1,1,50,49},{13,0,1,1,50,50},{14,1,1,1,50,50},{13,0,1,1,50,97},{14,1,1,1,50,97},{13,0,1,1,50,99},{14,1,1,1,50,99},{13,0,1,1,50,101},{14,1,1,1,50,101},{13,0,1,1,50,105},{14,1,1,1,50,105},{13,0,1,1,50,111},{14,1,1,1,50,111},{13,0,1,1,50,115},{14,1,1,1,50,115},{13,0,1,1,50,116},{14,1,1,1,50,116},{0,1,1,1,50,32},{0,1,1,1,50,37},{0,1,1,1,50,45},{0,1,1,1,50,46},{0,1,1,1,50,47},{0,1,1,1,50,51},{0,1,1,1,50,52},{0,1,1,1,50,53},{0,1,1,1,50,54},{0,1,1,1,50,55},{0,1,1,1,50,56},{0,1,1,1,50,57},{0,1,1,1,50,61},{0,1,1,1,50,65},{0,1,1,1,50,95},{0,1,1,1,50,98},{0,1,1,1,50,100},{0,1,1,1,50,102},{0,1,1,1,50,103},{0,1,1,1,50,104},{0,1,1,1,50,108},{0,1,1,1,50,109},{0,1,1,1,50,110},{0,1,1,1,50,112},{0,1,1,1,50,114},{0,1,1,1,50,117},{17,0,0,1,0,50},{18,0,0,1,0,50},{19,0,0,1,0,50},{20,0,0,1,0,50},{21,0,0,1,0,50},{22,0,0,1,0,50},{23,0,0,1,0,50},{24,0,0,1,0,50},{25,0,0,1,0,50},{26,0,0,1,0,50},{27,0,0,1,0,50},{28,0,0,1,0,50},{29,0,0,1,0,50},{30,0,0,1,0,50},{31,0,0,1,0,50},{32,0,0,1,0,50},{33,0,0,1,0,50},{34,1,0,1,0,50},{13,0,1,1,97,48},{14,1,1,1,97,48},{13,0,1,1,97,49},{14,1,1,1,97,49},{13,0,1,1,97,50},{14,1,1,1,97,50},{13,0,1,1,97,97},{14,1,1,1,97,97},{13,0,1,1,97,99},{14,1,1,1,97,99},{13,0,1,1,97,101},{14,1,1,1,97,101},{13,0,1,1,97,105},{14,1,1,1,97,105},{13,0,1,1,97,111},{14,1,1,1,97,111},{13,0,1,1,97,115},{14,1,1,1,97,115},{13,0,1,1,97,116},{14,1,1,1,97,116},{0,1,1,1,97,32},{0,1,1,1,97,37},{0,1,1,1,97,45},{0,1,1,1,97,46},{0,1,1,1,97,47},{0,1,1,1,97,51},{0,1,1,1,97,52},{0,1,1,1,97,53},{0,1,1,1,97,54},{0,1,1,1,97,55},{0,1,1,1,97,56},{0,1,1,1,97,57},{0,1,1,1,97,61},{0,1,1,1,97,65},{0,1,1,1,97,95},{0,1,1,1,97,98},{0,1,1,1,97,100},{0,1,1,1,97,102},{0,1,1,1,97,103},{0,1,1,1,97,104},{0,1,1,1,97,108},{0,1,1,1,97,109},{0,1,1,1,97,110},{0,1,1,1,97,112},{0,1,1,1,97,114},{0,1,1,1,97,117},{17,0,0,1,0,97},{18,0,0,1,0,97},{19,0,0,1,0,97},{20,0,0,1,0,97},{21,0,0,1,0,97},{22,0,0,1,0,97},{23,0,0,1,0,97},{24,0,0,1,0,97},{25,0,0,1,0,97},{26,0,0,1,0,97},{27,0,0,1,0,97},{28,0,0,1,0,97},{29,0,0,1,0,97},{30,0,0,1,0,97},{31,0,0,1,0,97},{32,0,0,1,0,97},{33,0,0,1,0,97},{34,1,0,1,0,97},{13,0,1,1,99,48},{14,1,1,1,99,48},{13,0,1,1,99,49},{14,1,1,1,99,49},{13,0,1,1,99,50},{14,1,1,1,99,50},{13,0,1,1,99,97},{14,1,1,1,99,97},{13,0,1,1,99,99},{14,1,1,1,99,99},{13,0,1,1,99,101},{14,1,1,1,99,101},{13,0,1,1,99,105},{14,1,1,1,99,105},{13,0,1,1,99,111},{14,1,1,1,99,111},{13,0,1,1,99,115},{14,1,1,1,99,115},{13,0,1,1,99,116},{14,1,1,1,99,116},{0,1,1,1,99,32},{0,1,1,1,99,37},{0,1,1,1,99,45},{0,1,1,1,99,46},{0,1,1,1,99,47},{0,1,1,1,99,51},{0,1,1,1,99,52},{0,1,1,1,99,53},{0,1,1,1,99,54},{0,1,1,1,99,55},{0,1,1,1,99,56},{0,1,1,1,99,57},{0,1,1,1,99,61},{0,1,1,1,99,65},{0,1,1,1,99,95},{0,1,1,1,99,98},{0,1,1,1,99,100},{0,1,1,1,99,102},{0,1,1,1,99,103},{0,1,1,1,99,104},{0,1,1,1,99,108},{0,1,1,1,99,109},{0,1,1,1,99,110},{0,1,1,1,99,112},{0,1,1,1,99,114},{0,1,1,1,99,117},{17,0,0,1,0,99},{18,0,0,1,0,99},{19,0,0,1,0,99},{20,0,0,1,0,99},{21,0,0,1,0,99},{22,0,0,1,0,99},{23,0,0,1,0,99},{24,0,0,1,0,99},{25,0,0,1,0,99},{26,0,0,1,0,99},{27,0,0,1,0,99},{28,0,0,1,0,99},{29,0,0,1,0,99},{30,0,0,1,0,99},{31,0,0,1,0,99},{32,0,0,1,0,99},{33,0,0,1,0,99},{34,1,0,1,0,99},{13,0,1,1,101,48},{14,1,1,1,101,48},{13,0,1,1,101,49},{14,1,1,1,101,49},{13,0,1,1,101,50},{14,1,1,1,101,50},{13,0,1,1,101,97},{14,1,1,1,101,97},{13,0,1,1,101,99},{14,1,1,1,101,99},{13,0,1,1,101,101},{14,1,1,1,101,101},{13,0,1,1,101,105},{14,1,1,1,101,105},{13,0,1,1,101,111},{14,1,1,1,101,111},{13,0,1,1,101,115},{14,1,1,1,101,115},{13,0,1,1,101,116},{14,1,1,1,101,116},{0,1,1,1,101,32},{0,1,1,1,101,37},{0,1,1,1,101,45},{0,1,1,1,101,46},{0,1,1,1,101,47},{0,1,1,1,101,51},{0,1,1,1,101,52},{0,1,1,1,101,53},{0,1,1,1,101,54},{0,1,1,1,101,55},{0,1,1,1,101,56},{0,1,1,1,101,57},{0,1,1,1,101,61},{0,1,1,1,101,65},{0,1,1,1,101,95},{0,1,1,1,101,98},{0,1,1,1,101,100},{0,1,1,1,101,102},{0,1,1,1,101,103},{0,1,1,1,101,104},{0,1,1,1,101,108},{0,1,1,1,101,109},{0,1,1,1,101,110},{0,1,1,1,101,112},{0,1,1,1,101,114},{0,1,1,1,101,117},{17,0,0,1,0,101},{18,0,0,1,0,101},{19,0,0,1,0,101},{20,0,0,1,0,101},{21,0,0,1,0,101},{22,0,0,1,0,101},{23,0,0,1,0,101},{24,0,0,1,0,101},{25,0,0,1,0,101},{26,0,0,1,0,101},{27,0,0,1,0,101},{28,0,0,1,0,101},{29,0,0,1,0,101},{30,0,0,1,0,101},{31,0,0,1,0,101},{32,0,0,1,0,101},{33,0,0,1,0,101},{34,1,0,1,0,101},{13,0,1,1,105,48},{14,1,1,1,105,48},{13,0,1,1,105,49},{14,1,1,1,105,49},{13,0,1,1,105,50},{14,1,1,1,105,50},{13,0,1,1,105,97},{14,1,1,1,105,97},{13,0,1,1,105,99},{14,1,1,1,105,99},{13,0,1,1,105,101},{14,1,1,1,105,101},{13,0,1,1,105,105},{14,1,1,1,105,105},{13,0,1,1,105,111},{14,1,1,1,105,111},{13,0,1,1,105,115},{14,1,1,1,105,115},{13,0,1,1,105,116},{14,1,1,1,105,116},{0,1,1,1,105,32},{0,1,1,1,105,37},{0,1,1,1,105,45},{0,1,1,1,105,46},{0,1,1,1,105,47},{0,1,1,1,105,51},{0,1,1,1,105,52},{0,1,1,1,105,53},{0,1,1,1,105,54},{0,1,1,1,105,55},{0,1,1,1,105,56},{0,1,1,1,105,57},{0,1,1,1,105,61},{0,1,1,1,105,65},{0,1,1,1,105,95},{0,1,1,1,105,98},{0,1,1,1,105,100},{0,1,1,1,105,102},{0,1,1,1,105,103},{0,1,1,1,105,104},{0,1,1,1,105,108},{0,1,1,1,105,109},{0,1,1,1,105,110},{0,1,1,1,105,112},{0,1,1,1,105,114},{0,1,1,1,105,117},{17,0,0,1,0,105},{18,0,0,1,0,105},{19,0,0,1,0,105},{20,0,0,1,0,105},{21,0,0,1,0,105},{22,0,0,1,0,105},{23,0,0,1,0,105},{24,0,0,1,0,105},{25,0,0,1,0,105},{26,0,0,1,0,105},{27,0,0,1,0,105},{28,0,0,1,0,105},{29,0,0,1,0,105},{30,0,0,1,0,105},{31,0,0,1,0,105},{32,0,0,1,0,105},{33,0,0,1,0,105},{34,1,0,1,0,105},{13,0,1,1,111,48},{14,1,1,1,111,48},{13,0,1,1,111,49},{14,1,1,1,111,49},{13,0,1,1,111,50},{14,1,1,1,111,50},{13,0,1,1,111,97},{14,1,1,1,111,97},{13,0,1,1,111,99},{14,1,1,1,111,99},{13,0,1,1,111,101},{14,1,1,1,111,101},{13,0,1,1,111,105},{14,1,1,1,111,105},{13,0,1,1,111,111},{14,1,1,1,111,111},{13,0,1,1,111,115},{14,1,1,1,111,115},{13,0,1,1,111,116},{14,1,1,1,111,116},{0,1,1,1,111,32},{0,1,1,1,111,37},{0,1,1,1,111,45},{0,1,1,1,111,46},{0,1,1,1,111,47},{0,1,1,1,111,51},{0,1,1,1,111,52},{0,1,1,1,111,53},{0,1,1,1,111,54},{0,1,1,1,111,55},{0,1,1,1,111,56},{0,1,1,1,111,57},{0,1,1,1,111,61},{0,1,1,1,111,65},{0,1,1,1,111,95},{0,1,1,1,111,98},{0,1,1,1,111,100},{0,1,1,1,111,102},{0,1,1,1,111,103},{0,1,1,1,111,104},{0,1,1,1,111,108},{0,1,1,1,111,109},{0,1,1,1,111,110},{0,1,1,1,111,112},{0,1,1,1,111,114},{0,1,1,1,111,117},{17,0,0,1,0,111},{18,0,0,1,0,111},{19,0,0,1,0,111},{20,0,0,1,0,111},{21,0,0,1,0,111},{22,0,0,1,0,111},{23,0,0,1,0,111},{24,0,0,1,0,111},{25,0,0,1,0,111},{26,0,0,1,0,111},{27,0,0,1,0,111},{28,0,0,1,0,111},{29,0,0,1,0,111},{30,0,0,1,0,111},{31,0,0,1,0,111},{32,0,0,1,0,111},{33,0,0,1,0,111},{34,1,0,1,0,111},{13,0,1,1,115,48},{14,1,1,1,115,48},{13,0,1,1,115,49},{14,1,1,1,115,49},{13,0,1,1,115,50},{14,1,1,1,115,50},{13,0,1,1,115,97},{14,1,1,1,115,97},{13,0,1,1,115,99},{14,1,1,1,115,99},{13,0,1,1,115,101},{14,1,1,1,115,101},{13,0,1,1,115,105},{14,1,1,1,115,105},{13,0,1,1,115,111},{14,1,1,1,115,111},{13,0,1,1,115,115},{14,1,1,1,115,115},{13,0,1,1,115,116},{14,1,1,1,115,116},{0,1,1,1,115,32},{0,1,1,1,115,37},{0,1,1,1,115,45},{0,1,1,1,115,46},{0,1,1,1,115,47},{0,1,1,1,115,51},{0,1,1,1,115,52},{0,1,1,1,115,53},{0,1,1,1,115,54},{0,1,1,1,115,55},{0,1,1,1,115,56},{0,1,1,1,115,57},{0,1,1,1,115,61},{0,1,1,1,115,65},{0,1,1,1,115,95},{0,1,1,1,115,98},{0,1,1,1,115,100},{0,1,1,1,115,102},{0,1,1,1,115,103},{0,1,1,1,115,104},{0,1,1,1,115,108},{0,1,1,1,115,109},{0,1,1,1,115,110},{0,1,1,1,115,112},{0,1,1,1,115,114},{0,1,1,1,115,117},{17,0,0,1,0,115},{18,0,0,1,0,115},{19,0,0,1,0,115},{20,0,0,1,0,115},{21,0,0,1,0,115},{22,0,0,1,0,115},{23,0,0,1,0,115},{24,0,0,1,0,115},{25,0,0,1,0,115},{26,0,0,1,0,115},{27,0,0,1,0,115},{28,0,0,1,0,115},{29,0,0,1,0,115},{30,0,0,1,0,115},{31,0,0,1,0,115},{32,0,0,1,0,115},{33,0,0,1,0,115},{34,1,0,1,0,115},{13,0,1,1,116,48},{14,1,1,1,116,48},{13,0,1,1,116,49},{14,1,1,1,116,49},{13,0,1,1,116,50},{14,1,1,1,116,50},{13,0,1,1,116,97},{14,1,1,1,116,97},{13,0,1,1,116,99},{14,1,1,1,116,99},{13,0,1,1,116,101},{14,1,1,1,116,101},{13,0,1,1,116,105},{14,1,1,1,116,105},{13,0,1,1,116,111},{14,1,1,1,116,111},{13,0,1,1,116,115},{14,1,1,1,116,115},{13,0,1,1,116,116},{14,1,1,1,116,116},{0,1,1,1,116,32},{0,1,1,1,116,37},{0,1,1,1,116,45},{0,1,1,1,116,46},{0,1,1,1,116,47},{0,1,1,1,116,51},{0,1,1,1,116,52},{0,1,1,1,116,53},{0,1,1,1,116,54},{0,1,1,1,116,55},{0,1,1,1,116,56},{0,1,1,1,116,57},{0,1,1,1,116,61},{0,1,1,1,116,65},{0,1,1,1,116,95},{0,1,1,1,116,98},{0,1,1,1,116,100},{0,1,1,1,116,102},{0,1,1,1,116,103},{0,1,1,1,116,104},{0,1,1,1,116,108},{0,1,1,1,116,109},{0,1,1,1,116,110},{0,1,1,1,116,112},{0,1,1,1,116,114},{0,1,1,1,116,117},{17,0,0,1,0,116},{18,0,0,1,0,116},{19,0,0,1,0,116},{20,0,0,1,0,116},{21,0,0,1,0,116},{22,0,0,1,0,116},{23,0,0,1,0,116},{24,0,0,1,0,116},{25,0,0,1,0,116},{26,0,0,1,0,116},{27,0,0,1,0,116},{28,0,0,1,0,116},{29,0,0,1,0,116},{30,0,0,1,0,116},{31,0,0,1,0,116},{32,0,0,1,0,116},{33,0,0,1,0,116},{34,1,0,1,0,116},{0,1,1,1,32,48},{0,1,1,1,32,49},{0,1,1,1,32,50},{0,1,1,1,32,97},{0,1,1,1,32,99},{0,1,1,1,32,101},{0,1,1,1,32,105},{0,1,1,1,32,111},{0,1,1,1,32,115},{0,1,1,1,32,116},{35,0,0,1,0,32},{36,0,0,1,0,32},{37,0,0,1,0,32},{38,0,0,1,0,32},{39,0,0,1,0,32},{40,0,0,1,0,32},{41,0,0,1,0,32},{42,0,0,1,0,32},{43,0,0,1,0,32},{44,0,0,1,0,32},{45,0,0,1,0,32},{46,0,0,1,0,32},{47,0,0,1,0,32},{48,0,0,1,0,32},{49,0,0,1,0,32},{50,0,0,1,0,32},{51,0,0,1,0,32},{52,0,0,1,0,32},{53,0,0,1,0,32},{54,0,0,1,0,32},{55,0,0,1,0,32},{56,1,0,1,0,32},{0,1,1,1,37,48},{0,1,1,1,37,49},{0,1,1,1,37,50},{0,1,1,1,37,97},{0,1,1,1,37,99},{0,1,1,1,37,101},{0,1,1,1,37,105},{0,1,1,1,37,111},{0,1,1,1,37,115},{0,1,1,1,37,116},{35,0,0,1,0,37},{36,0,0,1,0,37},{37,0,0,1,0,37},{38,0,0,1,0,37},{39,0,0,1,0,37},{40,0,0,1,0,37},{41,0,0,1,0,37},{42,0,0,1,0,37},{43,0,0,1,0,37},{44,0,0,1,0,37},{45,0,0,1,0,37},{46,0,0,1,0,37},{47,0,0,1,0,37},{48,0,0,1,0,37},{49,0,0,1,0,37},{50,0,0,1,0,37},{51,0,0,1,0,37},{52,0,0,1,0,37},{53,0,0,1,0,37},{54,0,0,1,0,37},{55,0,0,1,0,37},{56,1,0,1,0,37},{0,1,1,1,45,48},{0,1,1,1,45,49},{0,1,1,1,45,50},{0,1,1,1,45,97},{0,1,1,1,45,99},{0,1,1,1,45,101},{0,1,1,1,45,105},{0,1,1,1,45,111},{0,1,1,1,45,115},{0,1,1,1,45,116},{35,0,0,1,0,45},{36,0,0,1,0,45},{37,0,0,1,0,45},{38,0,0,1,0,45},{39,0,0,1,0,45},{40,0,0,1,0,45},{41,0,0,1,0,45},{42,0,0,1,0,45},{43,0,0,1,0,45},{44,0,0,1,0,45},{45,0,0,1,0,45},{46,0,0,1,0,45},{47,0,0,1,0,45},{48,0,0,1,0,45},{49,0,0,1,0,45},{50,0,0,1,0,45},{51,0,0,1,0,45},{52,0,0,1,0,45},{53,0,0,1,0,45},{54,0,0,1,0,45},{55,0,0,1,0,45},{56,1,0,1,0,45},{0,1,1,1,46,48},{0,1,1,1,46,49},{0,1,1,1,46,50},{0,1,1,1,46,97},{0,1,1,1,46,99},{0,1,1,1,46,101},{0,1,1,1,46,105},{0,1,1,1,46,111},{0,1,1,1,46,115},{0,1,1,1,46,116},{35,0,0,1,0,46},{36,0,0,1,0,46},{37,0,0,1,0,46},{38,0,0,1,0,46},{39,0,0,1,0,46},{40,0,0,1,0,46},{41,0,0,1,0,46},{42,0,0,1,0,46},{43,0,0,1,0,46},{44,0,0,1,0,46},{45,0,0,1,0,46},{46,0,0,1,0,46},{47,0,0,1,0,46},{48,0,0,1,0,46},{49,0,0,1,0,46},{50,0,0,1,0,46},{51,0,0,1,0,46},{52,0,0,1,0,46},{53,0,0,1,0,46},{54,0,0,1,0,46},{55,0,0,1,0,46},{56,1,0,1,0,46},{0,1,1,1,47,48},{0,1,1,1,47,49},{0,1,1,1,47,50},{0,1,1,1,47,97},{0,1,1,1,47,99},{0,1,1,1,47,101},{0,1,1,1,47,105},{0,1,1,1,47,111},{0,1,1,1,47,115},{0,1,1,1,47,116},{35,0,0,1,0,47},{36,0,0,1,0,47},{37,0,0,1,0,47},{38,0,0,1,0,47},{39,0,0,1,0,47},{40,0,0,1,0,47},{41,0,0,1,0,47},{42,0,0,1,0,47},{43,0,0,1,0,47},{44,0,0,1,0,47},{45,0,0,1,0,47},{46,0,0,1,0,47},{47,0,0,1,0,47},{48,0,0,1,0,47},{49,0,0,1,0,47},{50,0,0,1,0,47},{51,0,0,1,0,47},{52,0,0,1,0,47},{53,0,0,1,0,47},{54,0,0,1,0,47},{55,0,0,1,0,47},{56,1,0,1,0,47},{0,1,1,1,51,48},{0,1,1,1,51,49},{0,1,1,1,51,50},{0,1,1,1,51,97},{0,1,1,1,51,99},{0,1,1,1,51,101},{0,1,1,1,51,105},{0,1,1,1,51,111},{0,1,1,1,51,115},{0,1,1,1,51,116},{35,0,0,1,0,51},{36,0,0,1,0,51},{37,0,0,1,0,51},{38,0,0,1,0,51},{39,0,0,1,0,51},{40,0,0,1,0,51},{41,0,0,1,0,51},{42,0,0,1,0,51},{43,0,0,1,0,51},{44,0,0,1,0,51},{45,0,0,1,0,51},{46,0,0,1,0,51},{47,0,0,1,0,51},{48,0,0,1,0,51},{49,0,0,1,0,51},{50,0,0,1,0,51},{51,0,0,1,0,51},{52,0,0,1,0,51},{53,0,0,1,0,51},{54,0,0,1,0,51},{55,0,0,1,0,51},{56,1,0,1,0,51},{0,1,1,1,52,48},{0,1,1,1,52,49},{0,1,1,1,52,50},{0,1,1,1,52,97},{0,1,1,1,52,99},{0,1,1,1,52,101},{0,1,1,1,52,105},{0,1,1,1,52,111},{0,1,1,1,52,115},{0,1,1,1,52,116},{35,0,0,1,0,52},{36,0,0,1,0,52},{37,0,0,1,0,52},{38,0,0,1,0,52},{39,0,0,1,0,52},{40,0,0,1,0,52},{41,0,0,1,0,52},{42,0,0,1,0,52},{43,0,0,1,0,52},{44,0,0,1,0,52},{45,0,0,1,0,52},{46,0,0,1,0,52},{47,0,0,1,0,52},{48,0,0,1,0,52},{49,0,0,1,0,52},{50,0,0,1,0,52},{51,0,0,1,0,52},{52,0,0,1,0,52},{53,0,0,1,0,52},{54,0,0,1,0,52},{55,0,0,1,0,52},{56,1,0,1,0,52},{0,1,1,1,53,48},{0,1,1,1,53,49},{0,1,1,1,53,50},{0,1,1,1,53,97},{0,1,1,1,53,99},{0,1,1,1,53,101},{0,1,1,1,53,105},{0,1,1,1,53,111},{0,1,1,1,53,115},{0,1,1,1,53,116},{35,0,0,1,0,53},{36,0,0,1,0,53},{37,0,0,1,0,53},{38,0,0,1,0,53},{39,0,0,1,0,53},{40,0,0,1,0,53},{41,0,0,1,0,53},{42,0,0,1,0,53},{43,0,0,1,0,53},{44,0,0,1,0,53},{45,0,0,1,0,53},{46,0,0,1,0,53},{47,0,0,1,0,53},{48,0,0,1,0,53},{49,0,0,1,0,53},{50,0,0,1,0,53},{51,0,0,1,0,53},{52,0,0,1,0,53},{53,0,0,1,0,53},{54,0,0,1,0,53},{55,0,0,1,0,53},{56,1,0,1,0,53},{0,1,1,1,54,48},{0,1,1,1,54,49},{0,1,1,1,54,50},{0,1,1,1,54,97},{0,1,1,1,54,99},{0,1,1,1,54,101},{0,1,1,1,54,105},{0,1,1,1,54,111},{0,1,1,1,54,115},{0,1,1,1,54,116},{35,0,0,1,0,54},{36,0,0,1,0,54},{37,0,0,1,0,54},{38,0,0,1,0,54},{39,0,0,1,0,54},{40,0,0,1,0,54},{41,0,0,1,0,54},{42,0,0,1,0,54},{43,0,0,1,0,54},{44,0,0,1,0,54},{45,0,0,1,0,54},{46,0,0,1,0,54},{47,0,0,1,0,54},{48,0,0,1,0,54},{49,0,0,1,0,54},{50,0,0,1,0,54},{51,0,0,1,0,54},{52,0,0,1,0,54},{53,0,0,1,0,54},{54,0,0,1,0,54},{55,0,0,1,0,54},{56,1,0,1,0,54},{0,1,1,1,55,48},{0,1,1,1,55,49},{0,1,1,1,55,50},{0,1,1,1,55,97},{0,1,1,1,55,99},{0,1,1,1,55,101},{0,1,1,1,55,105},{0,1,1,1,55,111},{0,1,1,1,55,115},{0,1,1,1,55,116},{35,0,0,1,0,55},{36,0,0,1,0,55},{37,0,0,1,0,55},{38,0,0,1,0,55},{39,0,0,1,0,55},{40,0,0,1,0,55},{41,0,0,1,0,55},{42,0,0,1,0,55},{43,0,0,1,0,55},{44,0,0,1,0,55},{45,0,0,1,0,55},{46,0,0,1,0,55},{47,0,0,1,0,55},{48,0,0,1,0,55},{49,0,0,1,0,55},{50,0,0,1,0,55},{51,0,0,1,0,55},{52,0,0,1,0,55},{53,0,0,1,0,55},{54,0,0,1,0,55},{55,0,0,1,0,55},{56,1,0,1,0,55},{0,1,1,1,56,48},{0,1,1,1,56,49},{0,1,1,1,56,50},{0,1,1,1,56,97},{0,1,1,1,56,99},{0,1,1,1,56,101},{0,1,1,1,56,105},{0,1,1,1,56,111},{0,1,1,1,56,115},{0,1,1,1,56,116},{35,0,0,1,0,56},{36,0,0,1,0,56},{37,0,0,1,0,56},{38,0,0,1,0,56},{39,0,0,1,0,56},{40,0,0,1,0,56},{41,0,0,1,0,56},{42,0,0,1,0,56},{43,0,0,1,0,56},{44,0,0,1,0,56},{45,0,0,1,0,56},{46,0,0,1,0,56},{47,0,0,1,0,56},{48,0,0,1,0,56},{49,0,0,1,0,56},{50,0,0,1,0,56},{51,0,0,1,0,56},{52,0,0,1,0,56},{53,0,0,1,0,56},{54,0,0,1,0,56},{55,0,0,1,0,56},{56,1,0,1,0,56},{0,1,1,1,57,48},{0,1,1,1,57,49},{0,1,1,1,57,50},{0,1,1,1,57,97},{0,1,1,1,57,99},{0,1,1,1,57,101},{0,1,1,1,57,105},{0,1,1,1,57,111},{0,1,1,1,57,115},{0,1,1,1,57,116},{35,0,0,1,0,57},{36,0,0,1,0,57},{37,0,0,1,0,57},{38,0,0,1,0,57},{39,0,0,1,0,57},{40,0,0,1,0,57},{41,0,0,1,0,57},{42,0,0,1,0,57},{43,0,0,1,0,57},{44,0,0,1,0,57},{45,0,0,1,0,57},{46,0,0,1,0,57},{47,0,0,1,0,57},{48,0,0,1,0,57},{49,0,0,1,0,57},{50,0,0,1,0,57},{51,0,0,1,0,57},{52,0,0,1,0,57},{53,0,0,1,0,57},{54,0,0,1,0,57},{55,0,0,1,0,57},{56,1,0,1,0,57},{0,1,1,1,61,48},{0,1,1,1,61,49},{0,1,1,1,61,50},{0,1,1,1,61,97},{0,1,1,1,61,99},{0,1,1,1,61,101},{0,1,1,1,61,105},{0,1,1,1,61,111},{0,1,1,1,61,115},{0,1,1,1,61,116},{35,0,0,1,0,61},{36,0,0,1,0,61},{37,0,0,1,0,61},{38,0,0,1,0,61},{39,0,0,1,0,61},{40,0,0,1,0,61},{41,0,0,1,0,61},{42,0,0,1,0,61},{43,0,0,1,0,61},{44,0,0,1,0,61},{45,0,0,1,0,61},{46,0,0,1,0,61},{47,0,0,1,0,61},{48,0,0,1,0,61},{49,0,0,1,0,61},{50,0,0,1,0,61},{51,0,0,1,0,61},{52,0,0,1,0,61},{53,0,0,1,0,61},{54,0,0,1,0,61},{55,0,0,1,0,61},{56,1,0,1,0,61},{0,1,1,1,65,48},{0,1,1,1,65,49},{0,1,1,1,65,50},{0,1,1,1,65,97},{0,1,1,1,65,99},{0,1,1,1,65,101},{0,1,1,1,65,105},{0,1,1,1,65,111},{0,1,1,1,65,115},{0,1,1,1,65,116},{35,0,0,1,0,65},{36,0,0,1,0,65},{37,0,0,1,0,65},{38,0,0,1,0,65},{39,0,0,1,0,65},{40,0,0,1,0,65},{41,0,0,1,0,65},{42,0,0,1,0,65},{43,0,0,1,0,65},{44,0,0,1,0,65},{45,0,0,1,0,65},{46,0,0,1,0,65},{47,0,0,1,0,65},{48,0,0,1,0,65},{49,0,0,1,0,65},{50,0,0,1,0,65},{51,0,0,1,0,65},{52,0,0,1,0,65},{53,0,0,1,0,65},{54,0,0,1,0,65},{55,0,0,1,0,65},{56,1,0,1,0,65},{0,1,1,1,95,48},{0,1,1,1,95,49},{0,1,1,1,95,50},{0,1,1,1,95,97},{0,1,1,1,95,99},{0,1,1,1,95,101},{0,1,1,1,95,105},{0,1,1,1,95,111},{0,1,1,1,95,115},{0,1,1,1,95,116},{35,0,0,1,0,95},{36,0,0,1,0,95},{37,0,0,1,0,95},{38,0,0,1,0,95},{39,0,0,1,0,95},{40,0,0,1,0,95},{41,0,0,1,0,95},{42,0,0,1,0,95},{43,0,0,1,0,95},{44,0,0,1,0,95},{45,0,0,1,0,95},{46,0,0,1,0,95},{47,0,0,1,0,95},{48,0,0,1,0,95},{49,0,0,1,0,95},{50,0,0,1,0,95},{51,0,0,1,0,95},{52,0,0,1,0,95},{53,0,0,1,0,95},{54,0,0,1,0,95},{55,0,0,1,0,95},{56,1,0,1,0,95},{0,1,1,1,98,48},{0,1,1,1,98,49},{0,1,1,1,98,50},{0,1,1,1,98,97},{0,1,1,1,98,99},{0,1,1,1,98,101},{0,1,1,1,98,105},{0,1,1,1,98,111},{0,1,1,1,98,115},{0,1,1,1,98,116},{35,0,0,1,0,98},{36,0,0,1,0,98},{37,0,0,1,0,98},{38,0,0,1,0,98},{39,0,0,1,0,98},{40,0,0,1,0,98},{41,0,0,1,0,98},{42,0,0,1,0,98},{43,0,0,1,0,98},{44,0,0,1,0,98},{45,0,0,1,0,98},{46,0,0,1,0,98},{47,0,0,1,0,98},{48,0,0,1,0,98},{49,0,0,1,0,98},{50,0,0,1,0,98},{51,0,0,1,0,98},{52,0,0,1,0,98},{53,0,0,1,0,98},{54,0,0,1,0,98},{55,0,0,1,0,98},{56,1,0,1,0,98},{0,1,1,1,100,48},{0,1,1,1,100,49},{0,1,1,1,100,50},{0,1,1,1,100,97},{0,1,1,1,100,99},{0,1,1,1,100,101},{0,1,1,1,100,105},{0,1,1,1,100,111},{0,1,1,1,100,115},{0,1,1,1,100,116},{35,0,0,1,0,100},{36,0,0,1,0,100},{37,0,0,1,0,100},{38,0,0,1,0,100},{39,0,0,1,0,100},{40,0,0,1,0,100},{41,0,0,1,0,100},{42,0,0,1,0,100},{43,0,0,1,0,100},{44,0,0,1,0,100},{45,0,0,1,0,100},{46,0,0,1,0,100},{47,0,0,1,0,100},{48,0,0,1,0,100},{49,0,0,1,0,100},{50,0,0,1,0,100},{51,0,0,1,0,100},{52,0,0,1,0,100},{53,0,0,1,0,100},{54,0,0,1,0,100},{55,0,0,1,0,100},{56,1,0,1,0,100},{0,1,1,1,102,48},{0,1,1,1,102,49},{0,1,1,1,102,50},{0,1,1,1,102,97},{0,1,1,1,102,99},{0,1,1,1,102,101},{0,1,1,1,102,105},{0,1,1,1,102,111},{0,1,1,1,102,115},{0,1,1,1,102,116},{35,0,0,1,0,102},{36,0,0,1,0,102},{37,0,0,1,0,102},{38,0,0,1,0,102},{39,0,0,1,0,102},{40,0,0,1,0,102},{41,0,0,1,0,102},{42,0,0,1,0,102},{43,0,0,1,0,102},{44,0,0,1,0,102},{45,0,0,1,0,102},{46,0,0,1,0,102},{47,0,0,1,0,102},{48,0,0,1,0,102},{49,0,0,1,0,102},{50,0,0,1,0,102},{51,0,0,1,0,102},{52,0,0,1,0,102},{53,0,0,1,0,102},{54,0,0,1,0,102},{55,0,0,1,0,102},{56,1,0,1,0,102},{0,1,1,1,103,48},{0,1,1,1,103,49},{0,1,1,1,103,50},{0,1,1,1,103,97},{0,1,1,1,103,99},{0,1,1,1,103,101},{0,1,1,1,103,105},{0,1,1,1,103,111},{0,1,1,1,103,115},{0,1,1,1,103,116},{35,0,0,1,0,103},{36,0,0,1,0,103},{37,0,0,1,0,103},{38,0,0,1,0,103},{39,0,0,1,0,103},{40,0,0,1,0,103},{41,0,0,1,0,103},{42,0,0,1,0,103},{43,0,0,1,0,103},{44,0,0,1,0,103},{45,0,0,1,0,103},{46,0,0,1,0,103},{47,0,0,1,0,103},{48,0,0,1,0,103},{49,0,0,1,0,103},{50,0,0,1,0,103},{51,0,0,1,0,103},{52,0,0,1,0,103},{53,0,0,1,0,103},{54,0,0,1,0,103},{55,0,0,1,0,103},{56,1,0,1,0,103},{0,1,1,1,104,48},{0,1,1,1,104,49},{0,1,1,1,104,50},{0,1,1,1,104,97},{0,1,1,1,104,99},{0,1,1,1,104,101},{0,1,1,1,104,105},{0,1,1,1,104,111},{0,1,1,1,104,115},{0,1,1,1,104,116},{35,0,0,1,0,104},{36,0,0,1,0,104},{37,0,0,1,0,104},{38,0,0,1,0,104},{39,0,0,1,0,104},{40,0,0,1,0,104},{41,0,0,1,0,104},{42,0,0,1,0,104},{43,0,0,1,0,104},{44,0,0,1,0,104},{45,0,0,1,0,104},{46,0,0,1,0,104},{47,0,0,1,0,104},{48,0,0,1,0,104},{49,0,0,1,0,104},{50,0,0,1,0,104},{51,0,0,1,0,104},{52,0,0,1,0,104},{53,0,0,1,0,104},{54,0,0,1,0,104},{55,0,0,1,0,104},{56,1,0,1,0,104},{0,1,1,1,108,48},{0,1,1,1,108,49},{0,1,1,1,108,50},{0,1,1,1,108,97},{0,1,1,1,108,99},{0,1,1,1,108,101},{0,1,1,1,108,105},{0,1,1,1,108,111},{0,1,1,1,108,115},{0,1,1,1,108,116},{35,0,0,1,0,108},{36,0,0,1,0,108},{37,0,0,1,0,108},{38,0,0,1,0,108},{39,0,0,1,0,108},{40,0,0,1,0,108},{41,0,0,1,0,108},{42,0,0,1,0,108},{43,0,0,1,0,108},{44,0,0,1,0,108},{45,0,0,1,0,108},{46,0,0,1,0,108},{47,0,0,1,0,108},{48,0,0,1,0,108},{49,0,0,1,0,108},{50,0,0,1,0,108},{51,0,0,1,0,108},{52,0,0,1,0,108},{53,0,0,1,0,108},{54,0,0,1,0,108},{55,0,0,1,0,108},{56,1,0,1,0,108},{0,1,1,1,109,48},{0,1,1,1,109,49},{0,1,1,1,109,50},{0,1,1,1,109,97},{0,1,1,1,109,99},{0,1,1,1,109,101},{0,1,1,1,109,105},{0,1,1,1,109,111},{0,1,1,1,109,115},{0,1,1,1,109,116},{35,0,0,1,0,109},{36,0,0,1,0,109},{37,0,0,1,0,109},{38,0,0,1,0,109},{39,0,0,1,0,109},{40,0,0,1,0,109},{41,0,0,1,0,109},{42,0,0,1,0,109},{43,0,0,1,0,109},{44,0,0,1,0,109},{45,0,0,1,0,109},{46,0,0,1,0,109},{47,0,0,1,0,109},{48,0,0,1,0,109},{49,0,0,1,0,109},{50,0,0,1,0,109},{51,0,0,1,0,109},{52,0,0,1,0,109},{53,0,0,1,0,109},{54,0,0,1,0,109},{55,0,0,1,0,109},{56,1,0,1,0,109},{0,1,1,1,110,48},{0,1,1,1,110,49},{0,1,1,1,110,50},{0,1,1,1,110,97},{0,1,1,1,110,99},{0,1,1,1,110,101},{0,1,1,1,110,105},{0,1,1,1,110,111},{0,1,1,1,110,115},{0,1,1,1,110,116},{35,0,0,1,0,110},{36,0,0,1,0,110},{37,0,0,1,0,110},{38,0,0,1,0,110},{39,0,0,1,0,110},{40,0,0,1,0,110},{41,0,0,1,0,110},{42,0,0,1,0,110},{43,0,0,1,0,110},{44,0,0,1,0,110},{45,0,0,1,0,110},{46,0,0,1,0,110},{47,0,0,1,0,110},{48,0,0,1,0,110},{49,0,0,1,0,110},{50,0,0,1,0,110},{51,0,0,1,0,110},{52,0,0,1,0,110},{53,0,0,1,0,110},{54,0,0,1,0,110},{55,0,0,1,0,110},{56,1,0,1,0,110},{0,1,1,1,112,48},{0,1,1,1,112,49},{0,1,1,1,112,50},{0,1,1,1,112,97},{0,1,1,1,112,99},{0,1,1,1,112,101},{0,1,1,1,112,105},{0,1,1,1,112,111},{0,1,1,1,112,115},{0,1,1,1,112,116},{35,0,0,1,0,112},{36,0,0,1,0,112},{37,0,0,1,0,112},{38,0,0,1,0,112},{39,0,0,1,0,112},{40,0,0,1,0,112},{41,0,0,1,0,112},{42,0,0,1,0,112},{43,0,0,1,0,112},{44,0,0,1,0,112},{45,0,0,1,0,112},{46,0,0,1,0,112},{47,0,0,1,0,112},{48,0,0,1,0,112},{49,0,0,1,0,112},{50,0,0,1,0,112},{51,0,0,1,0,112},{52,0,0,1,0,112},{53,0,0,1,0,112},{54,0,0,1,0,112},{55,0,0,1,0,112},{56,1,0,1,0,112},{0,1,1,1,114,48},{0,1,1,1,114,49},{0,1,1,1,114,50},{0,1,1,1,114,97},{0,1,1,1,114,99},{0,1,1,1,114,101},{0,1,1,1,114,105},{0,1,1,1,114,111},{0,1,1,1,114,115},{0,1,1,1,114,116},{35,0,0,1,0,114},{36,0,0,1,0,114},{37,0,0,1,0,114},{38,0,0,1,0,114},{39,0,0,1,0,114},{40,0,0,1,0,114},{41,0,0,1,0,114},{42,0,0,1,0,114},{43,0,0,1,0,114},{44,0,0,1,0,114},{45,0,0,1,0,114},{46,0,0,1,0,114},{47,0,0,1,0,114},{48,0,0,1,0,114},{49,0,0,1,0,114},{50,0,0,1,0,114},{51,0,0,1,0,114},{52,0,0,1,0,114},{53,0,0,1,0,114},{54,0,0,1,0,114},{55,0,0,1,0,114},{56,1,0,1,0,114},{0,1,1,1,117,48},{0,1,1,1,117,49},{0,1,1,1,117,50},{0,1,1,1,117,97},{0,1,1,1,117,99},{0,1,1,1,117,101},{0,1,1,1,117,105},{0,1,1,1,117,111},{0,1,1,1,117,115},{0,1,1,1,117,116},{35,0,0,1,0,117},{36,0,0,1,0,117},{37,0,0,1,0,117},{38,0,0,1,0,117},{39,0,0,1,0,117},{40,0,0,1,0,117},{41,0,0,1,0,117},{42,0,0,1,0,117},{43,0,0,1,0,117},{44,0,0,1,0,117},{45,0,0,1,0,117},{46,0,0,1,0,117},{47,0,0,1,0,117},{48,0,0,1,0,117},{49,0,0,1,0,117},{50,0,0,1,0,117},{51,0,0,1,0,117},{52,0,0,1,0,117},{53,0,0,1,0,117},{54,0,0,1,0,117},{55,0,0,1,0,117},{56,1,0,1,0,117},{57,0,0,1,0,58},{58,0,0,1,0,58},{59,0,0,1,0,58},{60,0,0,1,0,58},{61,0,0,1,0,58},{62,0,0,1,0,58},{63,0,0,1,0,58},{64,0,0,1,0,58},{65,0,0,1,0,58},{66,0,0,1,0,58},{67,0,0,1,0,58},{68,0,0,1,0,58},{69,0,0,1,0,58},{70,0,0,1,0,58},{71,0,0,1,0,58},{72,1,0,1,0,58},{57,0,0,1,0,66},{58,0,0,1,0,66},{59,0,0,1,0,66},{60,0,0,1,0,66},{61,0,0,1,0,66},{62,0,0,1,0,66},{63,0,0,1,0,66},{64,0,0,1,0,66},{65,0,0,1,0,66},{66,0,0,1,0,66},{67,0,0,1,0,66},{68,0,0,1,0,66},{69,0,0,1,0,66},{70,0,0,1,0,66},{71,0,0,1,0,66},{72,1,0,1,0,66},{57,0,0,1,0,67},{58,0,0,1,0,67},{59,0,0,1,0,67},{60,0,0,1,0,67},{61,0,0,1,0,67},{62,0,0,1,0,67},{63,0,0,1,0,67},{64,0,0,1,0,67},{65,0,0,1,0,67},{66,0,0,1,0,67},{67,0,0,1,0,67},{68,0,0,1,0,67},{69,0,0,1,0,67},{70,0,0,1,0,67},{71,0,0,1,0,67},{72,1,0,1,0,67},{57,0,0,1,0,68},{58,0,0,1,0,68},{59,0,0,1,0,68},{60,0,0,1,0,68},{61,0,0,1,0,68},{62,0,0,1,0,68},{63,0,0,1,0,68},{64,0,0,1,0,68},{65,0,0,1,0,68},{66,0,0,1,0,68},{67,0,0,1,0,68},{68,0,0,1,0,68},{69,0,0,1,0,68},{70,0,0,1,0,68},{71,0,0,1,0,68},{72,1,0,1,0,68},{57,0,0,1,0,69},{58,0,0,1,0,69},{59,0,0,1,0,69},{60,0,0,1,0,69},{61,0,0,1,0,69},{62,0,0,1,0,69},{63,0,0,1,0,69},{64,0,0,1,0,69},{65,0,0,1,0,69},{66,0,0,1,0,69},{67,0,0,1,0,69},{68,0,0,1,0,69},{69,0,0,1,0,69},{70,0,0,1,0,69},{71,0,0,1,0,69},{72,1,0,1,0,69},{57,0,0,1,0,70},{58,0,0,1,0,70},{59,0,0,1,0,70},{60,0,0,1,0,70},{61,0,0,1,0,70},{62,0,0,1,0,70},{63,0,0,1,0,70},{64,0,0,1,0,70},{65,0,0,1,0,70},{66,0,0,1,0,70},{67,0,0,1,0,70},{68,0,0,1,0,70},{69,0,0,1,0,70},{70,0,0,1,0,70},{71,0,0,1,0,70},{72,1,0,1,0,70},{57,0,0,1,0,71},{58,0,0,1,0,71},{59,0,0,1,0,71},{60,0,0,1,0,71},{61,0,0,1,0,71},{62,0,0,1,0,71},{63,0,0,1,0,71},{64,0,0,1,0,71},{65,0,0,1,0,71},{66,0,0,1,0,71},{67,0,0,1,0,71},{68,0,0,1,0,71},{69,0,0,1,0,71},{70,0,0,1,0,71},{71,0,0,1,0,71},{72,1,0,1,0,71},{57,0,0,1,0,72},{58,0,0,1,0,72},{59,0,0,1,0,72},{60,0,0,1,0,72},{61,0,0,1,0,72},{62,0,0,1,0,72},{63,0,0,1,0,72},{64,0,0,1,0,72},{65,0,0,1,0,72},{66,0,0,1,0,72},{67,0,0,1,0,72},{68,0,0,1,0,72},{69,0,0,1,0,72},{70,0,0,1,0,72},{71,0,0,1,0,72},{72,1,0,1,0,72},{57,0,0,1,0,73},{58,0,0,1,0,73},{59,0,0,1,0,73},{60,0,0,1,0,73},{61,0,0,1,0,73},{62,0,0,1,0,73},{63,0,0,1,0,73},{64,0,0,1,0,73},{65,0,0,1,0,73},{66,0,0,1,0,73},{67,0,0,1,0,73},{68,0,0,1,0,73},{69,0,0,1,0,73},{70,0,0,1,0,73},{71,0,0,1,0,73},{72,1,0,1,0,73},{57,0,0,1,0,74},{58,0,0,1,0,74},{59,0,0,1,0,74},{60,0,0,1,0,74},{61,0,0,1,0,74},{62,0,0,1,0,74},{63,0,0,1,0,74},{64,0,0,1,0,74},{65,0,0,1,0,74},{66,0,0,1,0,74},{67,0,0,1,0,74},{68,0,0,1,0,74},{69,0,0,1,0,74},{70,0,0,1,0,74},{71,0,0,1,0,74},{72,1,0,1,0,74},{57,0,0,1,0,75},{58,0,0,1,0,75},{59,0,0,1,0,75},{60,0,0,1,0,75},{61,0,0,1,0,75},{62,0,0,1,0,75},{63,0,0,1,0,75},{64,0,0,1,0,75},{65,0,0,1,0,75},{66,0,0,1,0,75},{67,0,0,1,0,75},{68,0,0,1,0,75},{69,0,0,1,0,75},{70,0,0,1,0,75},{71,0,0,1,0,75},{72,1,0,1,0,75},{57,0,0,1,0,76},{58,0,0,1,0,76},{59,0,0,1,0,76},{60,0,0,1,0,76},{61,0,0,1,0,76},{62,0,0,1,0,76},{63,0,0,1,0,76},{64,0,0,1,0,76},{65,0,0,1,0,76},{66,0,0,1,0,76},{67,0,0,1,0,76},{68,0,0,1,0,76},{69,0,0,1,0,76},{70,0,0,1,0,76},{71,0,0,1,0,76},{72,1,0,1,0,76},{57,0,0,1,0,77},{58,0,0,1,0,77},{59,0,0,1,0,77},{60,0,0,1,0,77},{61,0,0,1,0,77},{62,0,0,1,0,77},{63,0,0,1,0,77},{64,0,0,1,0,77},{65,0,0,1,0,77},{66,0,0,1,0,77},{67,0,0,1,0,77},{68,0,0,1,0,77},{69,0,0,1,0,77},{70,0,0,1,0,77},{71,0,0,1,0,77},{72,1,0,1,0,77},{57,0,0,1,0,78},{58,0,0,1,0,78},{59,0,0,1,0,78},{60,0,0,1,0,78},{61,0,0,1,0,78},{62,0,0,1,0,78},{63,0,0,1,0,78},{64,0,0,1,0,78},{65,0,0,1,0,78},{66,0,0,1,0,78},{67,0,0,1,0,78},{68,0,0,1,0,78},{69,0,0,1,0,78},{70,0,0,1,0,78},{71,0,0,1,0,78},{72,1,0,1,0,78},{57,0,0,1,0,79},{58,0,0,1,0,79},{59,0,0,1,0,79},{60,0,0,1,0,79},{61,0,0,1,0,79},{62,0,0,1,0,79},{63,0,0,1,0,79},{64,0,0,1,0,79},{65,0,0,1,0,79},{66,0,0,1,0,79},{67,0,0,1,0,79},{68,0,0,1,0,79},{69,0,0,1,0,79},{70,0,0,1,0,79},{71,0,0,1,0,79},{72,1,0,1,0,79},{57,0,0,1,0,80},{58,0,0,1,0,80},{59,0,0,1,0,80},{60,0,0,1,0,80},{61,0,0,1,0,80},{62,0,0,1,0,80},{63,0,0,1,0,80},{64,0,0,1,0,80},{65,0,0,1,0,80},{66,0,0,1,0,80},{67,0,0,1,0,80},{68,0,0,1,0,80},{69,0,0,1,0,80},{70,0,0,1,0,80},{71,0,0,1,0,80},{72,1,0,1,0,80},{57,0,0,1,0,81},{58,0,0,1,0,81},{59,0,0,1,0,81},{60,0,0,1,0,81},{61,0,0,1,0,81},{62,0,0,1,0,81},{63,0,0,1,0,81},{64,0,0,1,0,81},{65,0,0,1,0,81},{66,0,0,1,0,81},{67,0,0,1,0,81},{68,0,0,1,0,81},{69,0,0,1,0,81},{70,0,0,1,0,81},{71,0,0,1,0,81},{72,1,0,1,0,81},{57,0,0,1,0,82},{58,0,0,1,0,82},{59,0,0,1,0,82},{60,0,0,1,0,82},{61,0,0,1,0,82},{62,0,0,1,0,82},{63,0,0,1,0,82},{64,0,0,1,0,82},{65,0,0,1,0,82},{66,0,0,1,0,82},{67,0,0,1,0,82},{68,0,0,1,0,82},{69,0,0,1,0,82},{70,0,0,1,0,82},{71,0,0,1,0,82},{72,1,0,1,0,82},{57,0,0,1,0,83},{58,0,0,1,0,83},{59,0,0,1,0,83},{60,0,0,1,0,83},{61,0,0,1,0,83},{62,0,0,1,0,83},{63,0,0,1,0,83},{64,0,0,1,0,83},{65,0,0,1,0,83},{66,0,0,1,0,83},{67,0,0,1,0,83},{68,0,0,1,0,83},{69,0,0,1,0,83},{70,0,0,1,0,83},{71,0,0,1,0,83},{72,1,0,1,0,83},{57,0,0,1,0,84},{58,0,0,1,0,84},{59,0,0,1,0,84},{60,0,0,1,0,84},{61,0,0,1,0,84},{62,0,0,1,0,84},{63,0,0,1,0,84},{64,0,0,1,0,84},{65,0,0,1,0,84},{66,0,0,1,0,84},{67,0,0,1,0,84},{68,0,0,1,0,84},{69,0,0,1,0,84},{70,0,0,1,0,84},{71,0,0,1,0,84},{72,1,0,1,0,84},{57,0,0,1,0,85},{58,0,0,1,0,85},{59,0,0,1,0,85},{60,0,0,1,0,85},{61,0,0,1,0,85},{62,0,0,1,0,85},{63,0,0,1,0,85},{64,0,0,1,0,85},{65,0,0,1,0,85},{66,0,0,1,0,85},{67,0,0,1,0,85},{68,0,0,1,0,85},{69,0,0,1,0,85},{70,0,0,1,0,85},{71,0,0,1,0,85},{72,1,0,1,0,85},{57,0,0,1,0,86},{58,0,0,1,0,86},{59,0,0,1,0,86},{60,0,0,1,0,86},{61,0,0,1,0,86},{62,0,0,1,0,86},{63,0,0,1,0,86},{64,0,0,1,0,86},{65,0,0,1,0,86},{66,0,0,1,0,86},{67,0,0,1,0,86},{68,0,0,1,0,86},{69,0,0,1,0,86},{70,0,0,1,0,86},{71,0,0,1,0,86},{72,1,0,1,0,86},{57,0,0,1,0,87},{58,0,0,1,0,87},{59,0,0,1,0,87},{60,0,0,1,0,87},{61,0,0,1,0,87},{62,0,0,1,0,87},{63,0,0,1,0,87},{64,0,0,1,0,87},{65,0,0,1,0,87},{66,0,0,1,0,87},{67,0,0,1,0,87},{68,0,0,1,0,87},{69,0,0,1,0,87},{70,0,0,1,0,87},{71,0,0,1,0,87},{72,1,0,1,0,87},{57,0,0,1,0,89},{58,0,0,1,0,89},{59,0,0,1,0,89},{60,0,0,1,0,89},{61,0,0,1,0,89},{62,0,0,1,0,89},{63,0,0,1,0,89},{64,0,0,1,0,89},{65,0,0,1,0,89},{66,0,0,1,0,89},{67,0,0,1,0,89},{68,0,0,1,0,89},{69,0,0,1,0,89},{70,0,0,1,0,89},{71,0,0,1,0,89},{72,1,0,1,0,89},{57,0,0,1,0,106},{58,0,0,1,0,106},{59,0,0,1,0,106},{60,0,0,1,0,106},{61,0,0,1,0,106},{62,0,0,1,0,106},{63,0,0,1,0,106},{64,0,0,1,0,106},{65,0,0,1,0,106},{66,0,0,1,0,106},{67,0,0,1,0,106},{68,0,0,1,0,106},{69,0,0,1,0,106},{70,0,0,1,0,106},{71,0,0,1,0,106},{72,1,0,1,0,106},{57,0,0,1,0,107},{58,0,0,1,0,107},{59,0,0,1,0,107},{60,0,0,1,0,107},{61,0,0,1,0,107},{62,0,0,1,0,107},{63,0,0,1,0,107},{64,0,0,1,0,107},{65,0,0,1,0,107},{66,0,0,1,0,107},{67,0,0,1,0,107},{68,0,0,1,0,107},{69,0,0,1,0,107},{70,0,0,1,0,107},{71,0,0,1,0,107},{72,1,0,1,0,107},{57,0,0,1,0,113},{58,0,0,1,0,113},{59,0,0,1,0,113},{60,0,0,1,0,113},{61,0,0,1,0,113},{62,0,0,1,0,113},{63,0,0,1,0,113},{64,0,0,1,0,113},{65,0,0,1,0,113},{66,0,0,1,0,113},{67,0,0,1,0,113},{68,0,0,1,0,113},{69,0,0,1,0,113},{70,0,0,1,0,113},{71,0,0,1,0,113},{72,1,0,1,0,113},{57,0,0,1,0,118},{58,0,0,1,0,118},{59,0,0,1,0,118},{60,0,0,1,0,118},{61,0,0,1,0,118},{62,0,0,1,0,118},{63,0,0,1,0,118},{64,0,0,1,0,118},{65,0,0,1,0,118},{66,0,0,1,0,118},{67,0,0,1,0,118},{68,0,0,1,0,118},{69,0,0,1,0,118},{70,0,0,1,0,118},{71,0,0,1,0,118},{72,1,0,1,0,118},{57,0,0,1,0,119},{58,0,0,1,0,119},{59,0,0,1,0,119},{60,0,0,1,0,119},{61,0,0,1,0,119},{62,0,0,1,0,119},{63,0,0,1,0,119},{64,0,0,1,0,119},{65,0,0,1,0,119},{66,0,0,1,0,119},{67,0,0,1,0,119},{68,0,0,1,0,119},{69,0,0,1,0,119},{70,0,0,1,0,119},{71,0,0,1,0,119},{72,1,0,1,0,119},{57,0,0,1,0,120},{58,0,0,1,0,120},{59,0,0,1,0,120},{60,0,0,1,0,120},{61,0,0,1,0,120},{62,0,0,1,0,120},{63,0,0,1,0,120},{64,0,0,1,0,120},{65,0,0,1,0,120},{66,0,0,1,0,120},{67,0,0,1,0,120},{68,0,0,1,0,120},{69,0,0,1,0,120},{70,0,0,1,0,120},{71,0,0,1,0,120},{72,1,0,1,0,120},{57,0,0,1,0,121},{58,0,0,1,0,121},{59,0,0,1,0,121},{60,0,0,1,0,121},{61,0,0,1,0,121},{62,0,0,1,0,121},{63,0,0,1,0,121},{64,0,0,1,0,121},{65,0,0,1,0,121},{66,0,0,1,0,121},{67,0,0,1,0,121},{68,0,0,1,0,121},{69,0,0,1,0,121},{70,0,0,1,0,121},{71,0,0,1,0,121},{72,1,0,1,0,121},{57,0,0,1,0,122},{58,0,0,1,0,122},{59,0,0,1,0,122},{60,0,0,1,0,122},{61,0,0,1,0,122},{62,0,0,1,0,122},{63,0,0,1,0,122},{64,0,0,1,0,122},{65,0,0,1,0,122},{66,0,0,1,0,122},{67,0,0,1,0,122},{68,0,0,1,0,122},{69,0,0,1,0,122},{70,0,0,1,0,122},{71,0,0,1,0,122},{72,1,0,1,0,122},{1,0,0,1,0,38},{2,0,0,1,0,38},{3,0,0,1,0,38},{4,0,0,1,0,38},{5,0,0,1,0,38},{6,0,0,1,0,38},{7,0,0,1,0,38},{8,1,0,1,0,38},{1,0,0,1,0,42},{2,0,0,1,0,42},{3,0,0,1,0,42},{4,0,0,1,0,42},{5,0,0,1,0,42},{6,0,0,1,0,42},{7,0,0,1,0,42},{8,1,0,1,0,42},{1,0,0,1,0,44},{2,0,0,1,0,44},{3,0,0,1,0,44},{4,0,0,1,0,44},{5,0,0,1,0,44},{6,0,0,1,0,44},{7,0,0,1,0,44},{8,1,0,1,0,44},{1,0,0,1,0,59},{2,0,0,1,0,59},{3,0,0,1,0,59},{4,0,0,1,0,59},{5,0,0,1,0,59},{6,0,0,1,0,59},{7,0,0,1,0,59},{8,1,0,1,0,59},{1,0,0,1,0,88},{2,0,0,1,0,88},{3,0,0,1,0,88},{4,0,0,1,0,88},{5,0,0,1,0,88},{6,0,0,1,0,88},{7,0,0,1,0,88},{8,1,0,1,0,88},{1,0,0,1,0,90},{2,0,0,1,0,90},{3,0,0,1,0,90},{4,0,0,1,0,90},{5,0,0,1,0,90},{6,0,0,1,0,90},{7,0,0,1,0,90},{8,1,0,1,0,90},{13,0,0,1,0,33},{14,1,0,1,0,33},{13,0,0,1,0,34},{14,1,0,1,0,34},{13,0,0,1,0,40},{14,1,0,1,0,40},{13,0,0,1,0,41},{14,1,0,1,0,41},{13,0,0,1,0,63},{14,1,0,1,0,63},{0,1,0,1,0,39},{0,1,0,1,0,43},{0,1,0,1,0,124},{73,0,0,0,0,0},{74,0,0,0,0,0},{75,0,0,0,0,0},{0,1,1,1,48,48},{0,1,1,1,48,49},{0,1,1,1,48,50},{0,1,1,1,48,97},{0,1,1,1,48,99},{0,1,1,1,48,101},{0,1,1,1,48,105},{0,1,1,1,48,111},{0,1,1,1,48,115},{0,1,1,1,48,116},{35,0,0,1,0,48},{36,0,0,1,0,48},{37,0,0,1,0,48},{38,0,0,1,0,48},{39,0,0,1,0,48},{40,0,0,1,0,48},{41,0,0,1,0,48},{42,0,0,1,0,48},{43,0,0,1,0,48},{44,0,0,1,0,48},{45,0,0,1,0,48},{46,0,0,1,0,48},{47,0,0,1,0,48},{48,0,0,1,0,48},{49,0,0,1,0,48},{50,0,0,1,0,48},{51,0,0,1,0,48},{52,0,0,1,0,48},{53,0,0,1,0,48},{54,0,0,1,0,48},{55,0,0,1,0,48},{56,1,0,1,0,48},{0,1,1,1,49,48},{0,1,1,1,49,49},{0,1,1,1,49,50},{0,1,1,1,49,97},{0,1,1,1,49,99},{0,1,1,1,49,101},{0,1,1,1,49,105},{0,1,1,1,49,111},{0,1,1,1,49,115},{0,1,1,1,49,116},{35,0,0,1,0,49},{36,0,0,1,0,49},{37,0,0,1,0,49},{38,0,0,1,0,49},{39,0,0,1,0,49},{40,0,0,1,0,49},{41,0,0,1,0,49},{42,0,0,1,0,49},{43,0,0,1,0,49},{44,0,0,1,0,49},{45,0,0,1,0,49},{46,0,0,1,0,49},{47,0,0,1,0,49},{48,0,0,1,0,49},{49,0,0,1,0,49},{50,0,0,1,0,49},{51,0,0,1,0,49},{52,0,0,1,0,49},{53,0,0,1,0,49},{54,0,0,1,0,49},{55,0,0,1,0,49},{56,1,0,1,0,49},{0,1,1,1,50,48},{0,1,1,1,50,49},{0,1,1,1,50,50},{0,1,1,1,50,97},{0,1,1,1,50,99},{0,1,1,1,50,101},{0,1,1,1,50,105},{0,1,1,1,50,111},{0,1,1,1,50,115},{0,1,1,1,50,116},{35,0,0,1,0,50},{36,0,0,1,0,50},{37,0,0,1,0,50},{38,0,0,1,0,50},{39,0,0,1,0,50},{40,0,0,1,0,50},{41,0,0,1,0,50},{42,0,0,1,0,50},{43,0,0,1,0,50},{44,0,0,1,0,50},{45,0,0,1,0,50},{46,0,0,1,0,50},{47,0,0,1,0,50},{48,0,0,1,0,50},{49,0,0,1,0,50},{50,0,0,1,0,50},{51,0,0,1,0,50},{52,0,0,1,0,50},{53,0,0,1,0,50},{54,0,0,1,0,50},{55,0,0,1,0,50},{56,1,0,1,0,50},{0,1,1,1,97,48},{0,1,1,1,97,49},{0,1,1,1,97,50},{0,1,1,1,97,97},{0,1,1,1,97,99},{0,1,1,1,97,101},{0,1,1,1,97,105},{0,1,1,1,97,111},{0,1,1,1,97,115},{0,1,1,1,97,116},{35,0,0,1,0,97},{36,0,0,1,0,97},{37,0,0,1,0,97},{38,0,0,1,0,97},{39,0,0,1,0,97},{40,0,0,1,0,97},{41,0,0,1,0,97},{42,0,0,1,0,97},{43,0,0,1,0,97},{44,0,0,1,0,97},{45,0,0,1,0,97},{46,0,0,1,0,97},{47,0,0,1,0,97},{48,0,0,1,0,97},{49,0,0,1,0,97},{50,0,0,1,0,97},{51,0,0,1,0,97},{52,0,0,1,0,97},{53,0,0,1,0,97},{54,0,0,1,0,97},{55,0,0,1,0,97},{56,1,0,1,0,97},{0,1,1,1,99,48},{0,1,1,1,99,49},{0,1,1,1,99,50},{0,1,1,1,99,97},{0,1,1,1,99,99},{0,1,1,1,99,101},{0,1,1,1,99,105},{0,1,1,1,99,111},{0,1,1,1,99,115},{0,1,1,1,99,116},{35,0,0,1,0,99},{36,0,0,1,0,99},{37,0,0,1,0,99},{38,0,0,1,0,99},{39,0,0,1,0,99},{40,0,0,1,0,99},{41,0,0,1,0,99},{42,0,0,1,0,99},{43,0,0,1,0,99},{44,0,0,1,0,99},{45,0,0,1,0,99},{46,0,0,1,0,99},{47,0,0,1,0,99},{48,0,0,1,0,99},{49,0,0,1,0,99},{50,0,0,1,0,99},{51,0,0,1,0,99},{52,0,0,1,0,99},{53,0,0,1,0,99},{54,0,0,1,0,99},{55,0,0,1,0,99},{56,1,0,1,0,99},{0,1,1,1,101,48},{0,1,1,1,101,49},{0,1,1,1,101,50},{0,1,1,1,101,97},{0,1,1,1,101,99},{0,1,1,1,101,101},{0,1,1,1,101,105},{0,1,1,1,101,111},{0,1,1,1,101,115},{0,1,1,1,101,116},{35,0,0,1,0,101},{36,0,0,1,0,101},{37,0,0,1,0,101},{38,0,0,1,0,101},{39,0,0,1,0,101},{40,0,0,1,0,101},{41,0,0,1,0,101},{42,0,0,1,0,101},{43,0,0,1,0,101},{44,0,0,1,0,101},{45,0,0,1,0,101},{46,0,0,1,0,101},{47,0,0,1,0,101},{48,0,0,1,0,101},{49,0,0,1,0,101},{50,0,0,1,0,101},{51,0,0,1,0,101},{52,0,0,1,0,101},{53,0,0,1,0,101},{54,0,0,1,0,101},{55,0,0,1,0,101},{56,1,0,1,0,101},{0,1,1,1,105,48},{0,1,1,1,105,49},{0,1,1,1,105,50},{0,1,1,1,105,97},{0,1,1,1,105,99},{0,1,1,1,105,101},{0,1,1,1,105,105},{0,1,1,1,105,111},{0,1,1,1,105,115},{0,1,1,1,105,116},{35,0,0,1,0,105},{36,0,0,1,0,105},{37,0,0,1,0,105},{38,0,0,1,0,105},{39,0,0,1,0,105},{40,0,0,1,0,105},{41,0,0,1,0,105},{42,0,0,1,0,105},{43,0,0,1,0,105},{44,0,0,1,0,105},{45,0,0,1,0,105},{46,0,0,1,0,105},{47,0,0,1,0,105},{48,0,0,1,0,105},{49,0,0,1,0,105},{50,0,0,1,0,105},{51,0,0,1,0,105},{52,0,0,1,0,105},{53,0,0,1,0,105},{54,0,0,1,0,105},{55,0,0,1,0,105},{56,1,0,1,0,105},{0,1,1,1,111,48},{0,1,1,1,111,49},{0,1,1,1,111,50},{0,1,1,1,111,97},{0,1,1,1,111,99},{0,1,1,1,111,101},{0,1,1,1,111,105},{0,1,1,1,111,111},{0,1,1,1,111,115},{0,1,1,1,111,116},{35,0,0,1,0,111},{36,0,0,1,0,111},{37,0,0,1,0,111},{38,0,0,1,0,111},{39,0,0,1,0,111},{40,0,0,1,0,111},{41,0,0,1,0,111},{42,0,0,1,0,111},{43,0,0,1,0,111},{44,0,0,1,0,111},{45,0,0,1,0,111},{46,0,0,1,0,111},{47,0,0,1,0,111},{48,0,0,1,0,111},{49,0,0,1,0,111},{50,0,0,1,0,111},{51,0,0,1,0,111},{52,0,0,1,0,111},{53,0,0,1,0,111},{54,0,0,1,0,111},{55,0,0,1,0,111},{56,1,0,1,0,111},{0,1,1,1,115,48},{0,1,1,1,115,49},{0,1,1,1,115,50},{0,1,1,1,115,97},{0,1,1,1,115,99},{0,1,1,1,115,101},{0,1,1,1,115,105},{0,1,1,1,115,111},{0,1,1,1,115,115},{0,1,1,1,115,116},{35,0,0,1,0,115},{36,0,0,1,0,115},{37,0,0,1,0,115},{38,0,0,1,0,115},{39,0,0,1,0,115},{40,0,0,1,0,115},{41,0,0,1,0,115},{42,0,0,1,0,115},{43,0,0,1,0,115},{44,0,0,1,0,115},{45,0,0,1,0,115},{46,0,0,1,0,115},{47,0,0,1,0,115},{48,0,0,1,0,115},{49,0,0,1,0,115},{50,0,0,1,0,115},{51,0,0,1,0,115},{52,0,0,1,0,115},{53,0,0,1,0,115},{54,0,0,1,0,115},{55,0,0,1,0,115},{56,1,0,1,0,115},{0,1,1,1,116,48},{0,1,1,1,116,49},{0,1,1,1,116,50},{0,1,1,1,116,97},{0,1,1,1,116,99},{0,1,1,1,116,101},{0,1,1,1,116,105},{0,1,1,1,116,111},{0,1,1,1,116,115},{0,1,1,1,116,116},{35,0,0,1,0,116},{36,0,0,1,0,116},{37,0,0,1,0,116},{38,0,0,1,0,116},{39,0,0,1,0,116},{40,0,0,1,0,116},{41,0,0,1,0,116},{42,0,0,1,0,116},{43,0,0,1,0,116},{44,0,0,1,0,116},{45,0,0,1,0,116},{46,0,0,1,0,116},{47,0,0,1,0,116},{48,0,0,1,0,116},{49,0,0,1,0,116},{50,0,0,1,0,116},{51,0,0,1,0,116},{52,0,0,1,0,116},{53,0,0,1,0,116},{54,0,0,1,0,116},{55,0,0,1,0,116},{56,1,0,1,0,116},{57,0,0,1,0,32},{58,0,0,1,0,32},{59,0,0,1,0,32},{60,0,0,1,0,32},{61,0,0,1,0,32},{62,0,0,1,0,32},{63,0,0,1,0,32},{64,0,0,1,0,32},{65,0,0,1,0,32},{66,0,0,1,0,32},{67,0,0,1,0,32},{68,0,0,1,0,32},{69,0,0,1,0,32},{70,0,0,1,0,32},{71,0,0,1,0,32},{72,1,0,1,0,32},{57,0,0,1,0,37},{58,0,0,1,0,37},{59,0,0,1,0,37},{60,0,0,1,0,37},{61,0,0,1,0,37},{62,0,0,1,0,37},{63,0,0,1,0,37},{64,0,0,1,0,37},{65,0,0,1,0,37},{66,0,0,1,0,37},{67,0,0,1,0,37},{68,0,0,1,0,37},{69,0,0,1,0,37},{70,0,0,1,0,37},{71,0,0,1,0,37},{72,1,0,1,0,37},{57,0,0,1,0,45},{58,0,0,1,0,45},{59,0,0,1,0,45},{60,0,0,1,0,45},{61,0,0,1,0,45},{62,0,0,1,0,45},{63,0,0,1,0,45},{64,0,0,1,0,45},{65,0,0,1,0,45},{66,0,0,1,0,45},{67,0,0,1,0,45},{68,0,0,1,0,45},{69,0,0,1,0,45},{70,0,0,1,0,45},{71,0,0,1,0,45},{72,1,0,1,0,45},{57,0,0,1,0,46},{58,0,0,1,0,46},{59,0,0,1,0,46},{60,0,0,1,0,46},{61,0,0,1,0,46},{62,0,0,1,0,46},{63,0,0,1,0,46},{64,0,0,1,0,46},{65,0,0,1,0,46},{66,0,0,1,0,46},{67,0,0,1,0,46},{68,0,0,1,0,46},{69,0,0,1,0,46},{70,0,0,1,0,46},{71,0,0,1,0,46},{72,1,0,1,0,46},{57,0,0,1,0,47},{58,0,0,1,0,47},{59,0,0,1,0,47},{60,0,0,1,0,47},{61,0,0,1,0,47},{62,0,0,1,0,47},{63,0,0,1,0,47},{64,0,0,1,0,47},{65,0,0,1,0,47},{66,0,0,1,0,47},{67,0,0,1,0,47},{68,0,0,1,0,47},{69,0,0,1,0,47},{70,0,0,1,0,47},{71,0,0,1,0,47},{72,1,0,1,0,47},{57,0,0,1,0,51},{58,0,0,1,0,51},{59,0,0,1,0,51},{60,0,0,1,0,51},{61,0,0,1,0,51},{62,0,0,1,0,51},{63,0,0,1,0,51},{64,0,0,1,0,51},{65,0,0,1,0,51},{66,0,0,1,0,51},{67,0,0,1,0,51},{68,0,0,1,0,51},{69,0,0,1,0,51},{70,0,0,1,0,51},{71,0,0,1,0,51},{72,1,0,1,0,51},{57,0,0,1,0,52},{58,0,0,1,0,52},{59,0,0,1,0,52},{60,0,0,1,0,52},{61,0,0,1,0,52},{62,0,0,1,0,52},{63,0,0,1,0,52},{64,0,0,1,0,52},{65,0,0,1,0,52},{66,0,0,1,0,52},{67,0,0,1,0,52},{68,0,0,1,0,52},{69,0,0,1,0,52},{70,0,0,1,0,52},{71,0,0,1,0,52},{72,1,0,1,0,52},{57,0,0,1,0,53},{58,0,0,1,0,53},{59,0,0,1,0,53},{60,0,0,1,0,53},{61,0,0,1,0,53},{62,0,0,1,0,53},{63,0,0,1,0,53},{64,0,0,1,0,53},{65,0,0,1,0,53},{66,0,0,1,0,53},{67,0,0,1,0,53},{68,0,0,1,0,53},{69,0,0,1,0,53},{70,0,0,1,0,53},{71,0,0,1,0,53},{72,1,0,1,0,53},{57,0,0,1,0,54},{58,0,0,1,0,54},{59,0,0,1,0,54},{60,0,0,1,0,54},{61,0,0,1,0,54},{62,0,0,1,0,54},{63,0,0,1,0,54},{64,0,0,1,0,54},{65,0,0,1,0,54},{66,0,0,1,0,54},{67,0,0,1,0,54},{68,0,0,1,0,54},{69,0,0,1,0,54},{70,0,0,1,0,54},{71,0,0,1,0,54},{72,1,0,1,0,54},{57,0,0,1,0,55},{58,0,0,1,0,55},{59,0,0,1,0,55},{60,0,0,1,0,55},{61,0,0,1,0,55},{62,0,0,1,0,55},{63,0,0,1,0,55},{64,0,0,1,0,55},{65,0,0,1,0,55},{66,0,0,1,0,55},{67,0,0,1,0,55},{68,0,0,1,0,55},{69,0,0,1,0,55},{70,0,0,1,0,55},{71,0,0,1,0,55},{72,1,0,1,0,55},{57,0,0,1,0,56},{58,0,0,1,0,56},{59,0,0,1,0,56},{60,0,0,1,0,56},{61,0,0,1,0,56},{62,0,0,1,0,56},{63,0,0,1,0,56},{64,0,0,1,0,56},{65,0,0,1,0,56},{66,0,0,1,0,56},{67,0,0,1,0,56},{68,0,0,1,0,56},{69,0,0,1,0,56},{70,0,0,1,0,56},{71,0,0,1,0,56},{72,1,0,1,0,56},{57,0,0,1,0,57},{58,0,0,1,0,57},{59,0,0,1,0,57},{60,0,0,1,0,57},{61,0,0,1,0,57},{62,0,0,1,0,57},{63,0,0,1,0,57},{64,0,0,1,0,57},{65,0,0,1,0,57},{66,0,0,1,0,57},{67,0,0,1,0,57},{68,0,0,1,0,57},{69,0,0,1,0,57},{70,0,0,1,0,57},{71,0,0,1,0,57},{72,1,0,1,0,57},{57,0,0,1,0,61},{58,0,0,1,0,61},{59,0,0,1,0,61},{60,0,0,1,0,61},{61,0,0,1,0,61},{62,0,0,1,0,61},{63,0,0,1,0,61},{64,0,0,1,0,61},{65,0,0,1,0,61},{66,0,0,1,0,61},{67,0,0,1,0,61},{68,0,0,1,0,61},{69,0,0,1,0,61},{70,0,0,1,0,61},{71,0,0,1,0,61},{72,1,0,1,0,61},{57,0,0,1,0,65},{58,0,0,1,0,65},{59,0,0,1,0,65},{60,0,0,1,0,65},{61,0,0,1,0,65},{62,0,0,1,0,65},{63,0,0,1,0,65},{64,0,0,1,0,65},{65,0,0,1,0,65},{66,0,0,1,0,65},{67,0,0,1,0,65},{68,0,0,1,0,65},{69,0,0,1,0,65},{70,0,0,1,0,65},{71,0,0,1,0,65},{72,1,0,1,0,65},{57,0,0,1,0,95},{58,0,0,1,0,95},{59,0,0,1,0,95},{60,0,0,1,0,95},{61,0,0,1,0,95},{62,0,0,1,0,95},{63,0,0,1,0,95},{64,0,0,1,0,95},{65,0,0,1,0,95},{66,0,0,1,0,95},{67,0,0,1,0,95},{68,0,0,1,0,95},{69,0,0,1,0,95},{70,0,0,1,0,95},{71,0,0,1,0,95},{72,1,0,1,0,95},{57,0,0,1,0,98},{58,0,0,1,0,98},{59,0,0,1,0,98},{60,0,0,1,0,98},{61,0,0,1,0,98},{62,0,0,1,0,98},{63,0,0,1,0,98},{64,0,0,1,0,98},{65,0,0,1,0,98},{66,0,0,1,0,98},{67,0,0,1,0,98},{68,0,0,1,0,98},{69,0,0,1,0,98},{70,0,0,1,0,98},{71,0,0,1,0,98},{72,1,0,1,0,98},{57,0,0,1,0,100},{58,0,0,1,0,100},{59,0,0,1,0,100},{60,0,0,1,0,100},{61,0,0,1,0,100},{62,0,0,1,0,100},{63,0,0,1,0,100},{64,0,0,1,0,100},{65,0,0,1,0,100},{66,0,0,1,0,100},{67,0,0,1,0,100},{68,0,0,1,0,100},{69,0,0,1,0,100},{70,0,0,1,0,100},{71,0,0,1,0,100},{72,1,0,1,0,100},{57,0,0,1,0,102},{58,0,0,1,0,102},{59,0,0,1,0,102},{60,0,0,1,0,102},{61,0,0,1,0,102},{62,0,0,1,0,102},{63,0,0,1,0,102},{64,0,0,1,0,102},{65,0,0,1,0,102},{66,0,0,1,0,102},{67,0,0,1,0,102},{68,0,0,1,0,102},{69,0,0,1,0,102},{70,0,0,1,0,102},{71,0,0,1,0,102},{72,1,0,1,0,102},{57,0,0,1,0,103},{58,0,0,1,0,103},{59,0,0,1,0,103},{60,0,0,1,0,103},{61,0,0,1,0,103},{62,0,0,1,0,103},{63,0,0,1,0,103},{64,0,0,1,0,103},{65,0,0,1,0,103},{66,0,0,1,0,103},{67,0,0,1,0,103},{68,0,0,1,0,103},{69,0,0,1,0,103},{70,0,0,1,0,103},{71,0,0,1,0,103},{72,1,0,1,0,103},{57,0,0,1,0,104},{58,0,0,1,0,104},{59,0,0,1,0,104},{60,0,0,1,0,104},{61,0,0,1,0,104},{62,0,0,1,0,104},{63,0,0,1,0,104},{64,0,0,1,0,104},{65,0,0,1,0,104},{66,0,0,1,0,104},{67,0,0,1,0,104},{68,0,0,1,0,104},{69,0,0,1,0,104},{70,0,0,1,0,104},{71,0,0,1,0,104},{72,1,0,1,0,104},{57,0,0,1,0,108},{58,0,0,1,0,108},{59,0,0,1,0,108},{60,0,0,1,0,108},{61,0,0,1,0,108},{62,0,0,1,0,108},{63,0,0,1,0,108},{64,0,0,1,0,108},{65,0,0,1,0,108},{66,0,0,1,0,108},{67,0,0,1,0,108},{68,0,0,1,0,108},{69,0,0,1,0,108},{70,0,0,1,0,108},{71,0,0,1,0,108},{72,1,0,1,0,108},{57,0,0,1,0,109},{58,0,0,1,0,109},{59,0,0,1,0,109},{60,0,0,1,0,109},{61,0,0,1,0,109},{62,0,0,1,0,109},{63,0,0,1,0,109},{64,0,0,1,0,109},{65,0,0,1,0,109},{66,0,0,1,0,109},{67,0,0,1,0,109},{68,0,0,1,0,109},{69,0,0,1,0,109},{70,0,0,1,0,109},{71,0,0,1,0,109},{72,1,0,1,0,109},{57,0,0,1,0,110},{58,0,0,1,0,110},{59,0,0,1,0,110},{60,0,0,1,0,110},{61,0,0,1,0,110},{62,0,0,1,0,110},{63,0,0,1,0,110},{64,0,0,1,0,110},{65,0,0,1,0,110},{66,0,0,1,0,110},{67,0,0,1,0,110},{68,0,0,1,0,110},{69,0,0,1,0,110},{70,0,0,1,0,110},{71,0,0,1,0,110},{72,1,0,1,0,110},{57,0,0,1,0,112},{58,0,0,1,0,112},{59,0,0,1,0,112},{60,0,0,1,0,112},{61,0,0,1,0,112},{62,0,0,1,0,112},{63,0,0,1,0,112},{64,0,0,1,0,112},{65,0,0,1,0,112},{66,0,0,1,0,112},{67,0,0,1,0,112},{68,0,0,1,0,112},{69,0,0,1,0,112},{70,0,0,1,0,112},{71,0,0,1,0,112},{72,1,0,1,0,112},{57,0,0,1,0,114},{58,0,0,1,0,114},{59,0,0,1,0,114},{60,0,0,1,0,114},{61,0,0,1,0,114},{62,0,0,1,0,114},{63,0,0,1,0,114},{64,0,0,1,0,114},{65,0,0,1,0,114},{66,0,0,1,0,114},{67,0,0,1,0,114},{68,0,0,1,0,114},{69,0,0,1,0,114},{70,0,0,1,0,114},{71,0,0,1,0,114},{72,1,0,1,0,114},{57,0,0,1,0,117},{58,0,0,1,0,117},{59,0,0,1,0,117},{60,0,0,1,0,117},{61,0,0,1,0,117},{62,0,0,1,0,117},{63,0,0,1,0,117},{64,0,0,1,0,117},{65,0,0,1,0,117},{66,0,0,1,0,117},{67,0,0,1,0,117},{68,0,0,1,0,117},{69,0,0,1,0,117},{70,0,0,1,0,117},{71,0,0,1,0,117},{72,1,0,1,0,117},{1,0,0,1,0,58},{2,0,0,1,0,58},{3,0,0,1,0,58},{4,0,0,1,0,58},{5,0,0,1,0,58},{6,0,0,1,0,58},{7,0,0,1,0,58},{8,1,0,1,0,58},{1,0,0,1,0,66},{2,0,0,1,0,66},{3,0,0,1,0,66},{4,0,0,1,0,66},{5,0,0,1,0,66},{6,0,0,1,0,66},{7,0,0,1,0,66},{8,1,0,1,0,66},{1,0,0,1,0,67},{2,0,0,1,0,67},{3,0,0,1,0,67},{4,0,0,1,0,67},{5,0,0,1,0,67},{6,0,0,1,0,67},{7,0,0,1,0,67},{8,1,0,1,0,67},{1,0,0,1,0,68},{2,0,0,1,0,68},{3,0,0,1,0,68},{4,0,0,1,0,68},{5,0,0,1,0,68},{6,0,0,1,0,68},{7,0,0,1,0,68},{8,1,0,1,0,68},{1,0,0,1,0,69},{2,0,0,1,0,69},{3,0,0,1,0,69},{4,0,0,1,0,69},{5,0,0,1,0,69},{6,0,0,1,0,69},{7,0,0,1,0,69},{8,1,0,1,0,69},{1,0,0,1,0,70},{2,0,0,1,0,70},{3,0,0,1,0,70},{4,0,0,1,0,70},{5,0,0,1,0,70},{6,0,0,1,0,70},{7,0,0,1,0,70},{8,1,0,1,0,70},{1,0,0,1,0,71},{2,0,0,1,0,71},{3,0,0,1,0,71},{4,0,0,1,0,71},{5,0,0,1,0,71},{6,0,0,1,0,71},{7,0,0,1,0,71},{8,1,0,1,0,71},{1,0,0,1,0,72},{2,0,0,1,0,72},{3,0,0,1,0,72},{4,0,0,1,0,72},{5,0,0,1,0,72},{6,0,0,1,0,72},{7,0,0,1,0,72},{8,1,0,1,0,72},{1,0,0,1,0,73},{2,0,0,1,0,73},{3,0,0,1,0,73},{4,0,0,1,0,73},{5,0,0,1,0,73},{6,0,0,1,0,73},{7,0,0,1,0,73},{8,1,0,1,0,73},{1,0,0,1,0,74},{2,0,0,1,0,74},{3,0,0,1,0,74},{4,0,0,1,0,74},{5,0,0,1,0,74},{6,0,0,1,0,74},{7,0,0,1,0,74},{8,1,0,1,0,74},{1,0,0,1,0,75},{2,0,0,1,0,75},{3,0,0,1,0,75},{4,0,0,1,0,75},{5,0,0,1,0,75},{6,0,0,1,0,75},{7,0,0,1,0,75},{8,1,0,1,0,75},{1,0,0,1,0,76},{2,0,0,1,0,76},{3,0,0,1,0,76},{4,0,0,1,0,76},{5,0,0,1,0,76},{6,0,0,1,0,76},{7,0,0,1,0,76},{8,1,0,1,0,76},{1,0,0,1,0,77},{2,0,0,1,0,77},{3,0,0,1,0,77},{4,0,0,1,0,77},{5,0,0,1,0,77},{6,0,0,1,0,77},{7,0,0,1,0,77},{8,1,0,1,0,77},{1,0,0,1,0,78},{2,0,0,1,0,78},{3,0,0,1,0,78},{4,0,0,1,0,78},{5,0,0,1,0,78},{6,0,0,1,0,78},{7,0,0,1,0,78},{8,1,0,1,0,78},{1,0,0,1,0,79},{2,0,0,1,0,79},{3,0,0,1,0,79},{4,0,0,1,0,79},{5,0,0,1,0,79},{6,0,0,1,0,79},{7,0,0,1,0,79},{8,1,0,1,0,79},{1,0,0,1,0,80},{2,0,0,1,0,80},{3,0,0,1,0,80},{4,0,0,1,0,80},{5,0,0,1,0,80},{6,0,0,1,0,80},{7,0,0,1,0,80},{8,1,0,1,0,80},{1,0,0,1,0,81},{2,0,0,1,0,81},{3,0,0,1,0,81},{4,0,0,1,0,81},{5,0,0,1,0,81},{6,0,0,1,0,81},{7,0,0,1,0,81},{8,1,0,1,0,81},{1,0,0,1,0,82},{2,0,0,1,0,82},{3,0,0,1,0,82},{4,0,0,1,0,82},{5,0,0,1,0,82},{6,0,0,1,0,82},{7,0,0,1,0,82},{8,1,0,1,0,82},{1,0,0,1,0,83},{2,0,0,1,0,83},{3,0,0,1,0,83},{4,0,0,1,0,83},{5,0,0,1,0,83},{6,0,0,1,0,83},{7,0,0,1,0,83},{8,1,0,1,0,83},{1,0,0,1,0,84},{2,0,0,1,0,84},{3,0,0,1,0,84},{4,0,0,1,0,84},{5,0,0,1,0,84},{6,0,0,1,0,84},{7,0,0,1,0,84},{8,1,0,1,0,84},{1,0,0,1,0,85},{2,0,0,1,0,85},{3,0,0,1,0,85},{4,0,0,1,0,85},{5,0,0,1,0,85},{6,0,0,1,0,85},{7,0,0,1,0,85},{8,1,0,1,0,85},{1,0,0,1,0,86},{2,0,0,1,0,86},{3,0,0,1,0,86},{4,0,0,1,0,86},{5,0,0,1,0,86},{6,0,0,1,0,86},{7,0,0,1,0,86},{8,1,0,1,0,86},{1,0,0,1,0,87},{2,0,0,1,0,87},{3,0,0,1,0,87},{4,0,0,1,0,87},{5,0,0,1,0,87},{6,0,0,1,0,87},{7,0,0,1,0,87},{8,1,0,1,0,87},{1,0,0,1,0,89},{2,0,0,1,0,89},{3,0,0,1,0,89},{4,0,0,1,0,89},{5,0,0,1,0,89},{6,0,0,1,0,89},{7,0,0,1,0,89},{8,1,0,1,0,89},{1,0,0,1,0,106},{2,0,0,1,0,106},{3,0,0,1,0,106},{4,0,0,1,0,106},{5,0,0,1,0,106},{6,0,0,1,0,106},{7,0,0,1,0,106},{8,1,0,1,0,106},{1,0,0,1,0,107},{2,0,0,1,0,107},{3,0,0,1,0,107},{4,0,0,1,0,107},{5,0,0,1,0,107},{6,0,0,1,0,107},{7,0,0,1,0,107},{8,1,0,1,0,107},{1,0,0,1,0,113},{2,0,0,1,0,113},{3,0,0,1,0,113},{4,0,0,1,0,113},{5,0,0,1,0,113},{6,0,0,1,0,113},{7,0,0,1,0,113},{8,1,0,1,0,113},{1,0,0,1,0,118},{2,0,0,1,0,118},{3,0,0,1,0,118},{4,0,0,1,0,118},{5,0,0,1,0,118},{6,0,0,1,0,118},{7,0,0,1,0,118},{8,1,0,1,0,118},{1,0,0,1,0,119},{2,0,0,1,0,119},{3,0,0,1,0,119},{4,0,0,1,0,119},{5,0,0,1,0,119},{6,0,0,1,0,119},{7,0,0,1,0,119},{8,1,0,1,0,119},{1,0,0,1,0,120},{2,0,0,1,0,120},{3,0,0,1,0,120},{4,0,0,1,0,120},{5,0,0,1,0,120},{6,0,0,1,0,120},{7,0,0,1,0,120},{8,1,0,1,0,120},{1,0,0,1,0,121},{2,0,0,1,0,121},{3,0,0,1,0,121},{4,0,0,1,0,121},{5,0,0,1,0,121},{6,0,0,1,0,121},{7,0,0,1,0,121},{8,1,0,1,0,121},{1,0,0,1,0,122},{2,0,0,1,0,122},{3,0,0,1,0,122},{4,0,0,1,0,122},{5,0,0,1,0,122},{6,0,0,1,0,122},{7,0,0,1,0,122},{8,1,0,1,0,122},{9,0,0,1,0,38},{10,0,0,1,0,38},{11,0,0,1,0,38},{12,1,0,1,0,38},{9,0,0,1,0,42},{10,0,0,1,0,42},{11,0,0,1,0,42},{12,1,0,1,0,42},{9,0,0,1,0,44},{10,0,0,1,0,44},{11,0,0,1,0,44},{12,1,0,1,0,44},{9,0,0,1,0,59},{10,0,0,1,0,59},{11,0,0,1,0,59},{12,1,0,1,0,59},{9,0,0,1,0,88},{10,0,0,1,0,88},{11,0,0,1,0,88},{12,1,0,1,0,88},{9,0,0,1,0,90},{10,0,0,1,0,90},{11,0,0,1,0,90},{12,1,0,1,0,90},{0,1,0,1,0,33},{0,1,0,1,0,34},{0,1,0,1,0,40},{0,1,0,1,0,41},{0,1,0,1,0,63},{76,0,0,0,0,0},{77,0,0,0,0,0},{78,0,0,0,0,0},{57,0,0,1,0,48},{58,0,0,1,0,48},{59,0,0,1,0,48},{60,0,0,1,0,48},{61,0,0,1,0,48},{62,0,0,1,0,48},{63,0,0,1,0,48},{64,0,0,1,0,48},{65,0,0,1,0,48},{66,0,0,1,0,48},{67,0,0,1,0,48},{68,0,0,1,0,48},{69,0,0,1,0,48},{70,0,0,1,0,48},{71,0,0,1,0,48},{72,1,0,1,0,48},{57,0,0,1,0,49},{58,0,0,1,0,49},{59,0,0,1,0,49},{60,0,0,1,0,49},{61,0,0,1,0,49},{62,0,0,1,0,49},{63,0,0,1,0,49},{64,0,0,1,0,49},{65,0,0,1,0,49},{66,0,0,1,0,49},{67,0,0,1,0,49},{68,0,0,1,0,49},{69,0,0,1,0,49},{70,0,0,1,0,49},{71,0,0,1,0,49},{72,1,0,1,0,49},{57,0,0,1,0,50},{58,0,0,1,0,50},{59,0,0,1,0,50},{60,0,0,1,0,50},{61,0,0,1,0,50},{62,0,0,1,0,50},{63,0,0,1,0,50},{64,0,0,1,0,50},{65,0,0,1,0,50},{66,0,0,1,0,50},{67,0,0,1,0,50},{68,0,0,1,0,50},{69,0,0,1,0,50},{70,0,0,1,0,50},{71,0,0,1,0,50},{72,1,0,1,0,50},{57,0,0,1,0,97},{58,0,0,1,0,97},{59,0,0,1,0,97},{60,0,0,1,0,97},{61,0,0,1,0,97},{62,0,0,1,0,97},{63,0,0,1,0,97},{64,0,0,1,0,97},{65,0,0,1,0,97},{66,0,0,1,0,97},{67,0,0,1,0,97},{68,0,0,1,0,97},{69,0,0,1,0,97},{70,0,0,1,0,97},{71,0,0,1,0,97},{72,1,0,1,0,97},{57,0,0,1,0,99},{58,0,0,1,0,99},{59,0,0,1,0,99},{60,0,0,1,0,99},{61,0,0,1,0,99},{62,0,0,1,0,99},{63,0,0,1,0,99},{64,0,0,1,0,99},{65,0,0,1,0,99},{66,0,0,1,0,99},{67,0,0,1,0,99},{68,0,0,1,0,99},{69,0,0,1,0,99},{70,0,0,1,0,99},{71,0,0,1,0,99},{72,1,0,1,0,99},{57,0,0,1,0,101},{58,0,0,1,0,101},{59,0,0,1,0,101},{60,0,0,1,0,101},{61,0,0,1,0,101},{62,0,0,1,0,101},{63,0,0,1,0,101},{64,0,0,1,0,101},{65,0,0,1,0,101},{66,0,0,1,0,101},{67,0,0,1,0,101},{68,0,0,1,0,101},{69,0,0,1,0,101},{70,0,0,1,0,101},{71,0,0,1,0,101},{72,1,0,1,0,101},{57,0,0,1,0,105},{58,0,0,1,0,105},{59,0,0,1,0,105},{60,0,0,1,0,105},{61,0,0,1,0,105},{62,0,0,1,0,105},{63,0,0,1,0,105},{64,0,0,1,0,105},{65,0,0,1,0,105},{66,0,0,1,0,105},{67,0,0,1,0,105},{68,0,0,1,0,105},{69,0,0,1,0,105},{70,0,0,1,0,105},{71,0,0,1,0,105},{72,1,0,1,0,105},{57,0,0,1,0,111},{58,0,0,1,0,111},{59,0,0,1,0,111},{60,0,0,1,0,111},{61,0,0,1,0,111},{62,0,0,1,0,111},{63,0,0,1,0,111},{64,0,0,1,0,111},{65,0,0,1,0,111},{66,0,0,1,0,111},{67,0,0,1,0,111},{68,0,0,1,0,111},{69,0,0,1,0,111},{70,0,0,1,0,111},{71,0,0,1,0,111},{72,1,0,1,0,111},{57,0,0,1,0,115},{58,0,0,1,0,115},{59,0,0,1,0,115},{60,0,0,1,0,115},{61,0,0,1,0,115},{62,0,0,1,0,115},{63,0,0,1,0,115},{64,0,0,1,0,115},{65,0,0,1,0,115},{66,0,0,1,0,115},{67,0,0,1,0,115},{68,0,0,1,0,115},{69,0,0,1,0,115},{70,0,0,1,0,115},{71,0,0,1,0,115},{72,1,0,1,0,115},{57,0,0,1,0,116},{58,0,0,1,0,116},{59,0,0,1,0,116},{60,0,0,1,0,116},{61,0,0,1,0,116},{62,0,0,1,0,116},{63,0,0,1,0,116},{64,0,0,1,0,116},{65,0,0,1,0,116},{66,0,0,1,0,116},{67,0,0,1,0,116},{68,0,0,1,0,116},{69,0,0,1,0,116},{70,0,0,1,0,116},{71,0,0,1,0,116},{72,1,0,1,0,116},{1,0,0,1,0,32},{2,0,0,1,0,32},{3,0,0,1,0,32},{4,0,0,1,0,32},{5,0,0,1,0,32},{6,0,0,1,0,32},{7,0,0,1,0,32},{8,1,0,1,0,32},{1,0,0,1,0,37},{2,0,0,1,0,37},{3,0,0,1,0,37},{4,0,0,1,0,37},{5,0,0,1,0,37},{6,0,0,1,0,37},{7,0,0,1,0,37},{8,1,0,1,0,37},{1,0,0,1,0,45},{2,0,0,1,0,45},{3,0,0,1,0,45},{4,0,0,1,0,45},{5,0,0,1,0,45},{6,0,0,1,0,45},{7,0,0,1,0,45},{8,1,0,1,0,45},{1,0,0,1,0,46},{2,0,0,1,0,46},{3,0,0,1,0,46},{4,0,0,1,0,46},{5,0,0,1,0,46},{6,0,0,1,0,46},{7,0,0,1,0,46},{8,1,0,1,0,46},{1,0,0,1,0,47},{2,0,0,1,0,47},{3,0,0,1,0,47},{4,0,0,1,0,47},{5,0,0,1,0,47},{6,0,0,1,0,47},{7,0,0,1,0,47},{8,1,0,1,0,47},{1,0,0,1,0,51},{2,0,0,1,0,51},{3,0,0,1,0,51},{4,0,0,1,0,51},{5,0,0,1,0,51},{6,0,0,1,0,51},{7,0,0,1,0,51},{8,1,0,1,0,51},{1,0,0,1,0,52},{2,0,0,1,0,52},{3,0,0,1,0,52},{4,0,0,1,0,52},{5,0,0,1,0,52},{6,0,0,1,0,52},{7,0,0,1,0,52},{8,1,0,1,0,52},{1,0,0,1,0,53},{2,0,0,1,0,53},{3,0,0,1,0,53},{4,0,0,1,0,53},{5,0,0,1,0,53},{6,0,0,1,0,53},{7,0,0,1,0,53},{8,1,0,1,0,53},{1,0,0,1,0,54},{2,0,0,1,0,54},{3,0,0,1,0,54},{4,0,0,1,0,54},{5,0,0,1,0,54},{6,0,0,1,0,54},{7,0,0,1,0,54},{8,1,0,1,0,54},{1,0,0,1,0,55},{2,0,0,1,0,55},{3,0,0,1,0,55},{4,0,0,1,0,55},{5,0,0,1,0,55},{6,0,0,1,0,55},{7,0,0,1,0,55},{8,1,0,1,0,55},{1,0,0,1,0,56},{2,0,0,1,0,56},{3,0,0,1,0,56},{4,0,0,1,0,56},{5,0,0,1,0,56},{6,0,0,1,0,56},{7,0,0,1,0,56},{8,1,0,1,0,56},{1,0,0,1,0,57},{2,0,0,1,0,57},{3,0,0,1,0,57},{4,0,0,1,0,57},{5,0,0,1,0,57},{6,0,0,1,0,57},{7,0,0,1,0,57},{8,1,0,1,0,57},{1,0,0,1,0,61},{2,0,0,1,0,61},{3,0,0,1,0,61},{4,0,0,1,0,61},{5,0,0,1,0,61},{6,0,0,1,0,61},{7,0,0,1,0,61},{8,1,0,1,0,61},{1,0,0,1,0,65},{2,0,0,1,0,65},{3,0,0,1,0,65},{4,0,0,1,0,65},{5,0,0,1,0,65},{6,0,0,1,0,65},{7,0,0,1,0,65},{8,1,0,1,0,65},{1,0,0,1,0,95},{2,0,0,1,0,95},{3,0,0,1,0,95},{4,0,0,1,0,95},{5,0,0,1,0,95},{6,0,0,1,0,95},{7,0,0,1,0,95},{8,1,0,1,0,95},{1,0,0,1,0,98},{2,0,0,1,0,98},{3,0,0,1,0,98},{4,0,0,1,0,98},{5,0,0,1,0,98},{6,0,0,1,0,98},{7,0,0,1,0,98},{8,1,0,1,0,98},{1,0,0,1,0,100},{2,0,0,1,0,100},{3,0,0,1,0,100},{4,0,0,1,0,100},{5,0,0,1,0,100},{6,0,0,1,0,100},{7,0,0,1,0,100},{8,1,0,1,0,100},{1,0,0,1,0,102},{2,0,0,1,0,102},{3,0,0,1,0,102},{4,0,0,1,0,102},{5,0,0,1,0,102},{6,0,0,1,0,102},{7,0,0,1,0,102},{8,1,0,1,0,102},{1,0,0,1,0,103},{2,0,0,1,0,103},{3,0,0,1,0,103},{4,0,0,1,0,103},{5,0,0,1,0,103},{6,0,0,1,0,103},{7,0,0,1,0,103},{8,1,0,1,0,103},{1,0,0,1,0,104},{2,0,0,1,0,104},{3,0,0,1,0,104},{4,0,0,1,0,104},{5,0,0,1,0,104},{6,0,0,1,0,104},{7,0,0,1,0,104},{8,1,0,1,0,104},{1,0,0,1,0,108},{2,0,0,1,0,108},{3,0,0,1,0,108},{4,0,0,1,0,108},{5,0,0,1,0,108},{6,0,0,1,0,108},{7,0,0,1,0,108},{8,1,0,1,0,108},{1,0,0,1,0,109},{2,0,0,1,0,109},{3,0,0,1,0,109},{4,0,0,1,0,109},{5,0,0,1,0,109},{6,0,0,1,0,109},{7,0,0,1,0,109},{8,1,0,1,0,109},{1,0,0,1,0,110},{2,0,0,1,0,110},{3,0,0,1,0,110},{4,0,0,1,0,110},{5,0,0,1,0,110},{6,0,0,1,0,110},{7,0,0,1,0,110},{8,1,0,1,0,110},{1,0,0,1,0,112},{2,0,0,1,0,112},{3,0,0,1,0,112},{4,0,0,1,0,112},{5,0,0,1,0,112},{6,0,0,1,0,112},{7,0,0,1,0,112},{8,1,0,1,0,112},{1,0,0,1,0,114},{2,0,0,1,0,114},{3,0,0,1,0,114},{4,0,0,1,0,114},{5,0,0,1,0,114},{6,0,0,1,0,114},{7,0,0,1,0,114},{8,1,0,1,0,114},{1,0,0,1,0,117},{2,0,0,1,0,117},{3,0,0,1,0,117},{4,0,0,1,0,117},{5,0,0,1,0,117},{6,0,0,1,0,117},{7,0,0,1,0,117},{8,1,0,1,0,117},{9,0,0,1,0,58},{10,0,0,1,0,58},{11,0,0,1,0,58},{12,1,0,1,0,58},{9,0,0,1,0,66},{10,0,0,1,0,66},{11,0,0,1,0,66},{12,1,0,1,0,66},{9,0,0,1,0,67},{10,0,0,1,0,67},{11,0,0,1,0,67},{12,1,0,1,0,67},{9,0,0,1,0,68},{10,0,0,1,0,68},{11,0,0,1,0,68},{12,1,0,1,0,68},{9,0,0,1,0,69},{10,0,0,1,0,69},{11,0,0,1,0,69},{12,1,0,1,0,69},{9,0,0,1,0,70},{10,0,0,1,0,70},{11,0,0,1,0,70},{12,1,0,1,0,70},{9,0,0,1,0,71},{10,0,0,1,0,71},{11,0,0,1,0,71},{12,1,0,1,0,71},{9,0,0,1,0,72},{10,0,0,1,0,72},{11,0,0,1,0,72},{12,1,0,1,0,72},{9,0,0,1,0,73},{10,0,0,1,0,73},{11,0,0,1,0,73},{12,1,0,1,0,73},{9,0,0,1,0,74},{10,0,0,1,0,74},{11,0,0,1,0,74},{12,1,0,1,0,74},{9,0,0,1,0,75},{10,0,0,1,0,75},{11,0,0,1,0,75},{12,1,0,1,0,75},{9,0,0,1,0,76},{10,0,0,1,0,76},{11,0,0,1,0,76},{12,1,0,1,0,76},{9,0,0,1,0,77},{10,0,0,1,0,77},{11,0,0,1,0,77},{12,1,0,1,0,77},{9,0,0,1,0,78},{10,0,0,1,0,78},{11,0,0,1,0,78},{12,1,0,1,0,78},{9,0,0,1,0,79},{10,0,0,1,0,79},{11,0,0,1,0,79},{12,1,0,1,0,79},{9,0,0,1,0,80},{10,0,0,1,0,80},{11,0,0,1,0,80},{12,1,0,1,0,80},{9,0,0,1,0,81},{10,0,0,1,0,81},{11,0,0,1,0,81},{12,1,0,1,0,81},{9,0,0,1,0,82},{10,0,0,1,0,82},{11,0,0,1,0,82},{12,1,0,1,0,82},{9,0,0,1,0,83},{10,0,0,1,0,83},{11,0,0,1,0,83},{12,1,0,1,0,83},{9,0,0,1,0,84},{10,0,0,1,0,84},{11,0,0,1,0,84},{12,1,0,1,0,84},{9,0,0,1,0,85},{10,0,0,1,0,85},{11,0,0,1,0,85},{12,1,0,1,0,85},{9,0,0,1,0,86},{10,0,0,1,0,86},{11,0,0,1,0,86},{12,1,0,1,0,86},{9,0,0,1,0,87},{10,0,0,1,0,87},{11,0,0,1,0,87},{12,1,0,1,0,87},{9,0,0,1,0,89},{10,0,0,1,0,89},{11,0,0,1,0,89},{12,1,0,1,0,89},{9,0,0,1,0,106},{10,0,0,1,0,106},{11,0,0,1,0,106},{12,1,0,1,0,106},{9,0,0,1,0,107},{10,0,0,1,0,107},{11,0,0,1,0,107},{12,1,0,1,0,107},{9,0,0,1,0,113},{10,0,0,1,0,113},{11,0,0,1,0,113},{12,1,0,1,0,113},{9,0,0,1,0,118},{10,0,0,1,0,118},{11,0,0,1,0,118},{12,1,0,1,0,118},{9,0,0,1,0,119},{10,0,0,1,0,119},{11,0,0,1,0,119},{12,1,0,1,0,119},{9,0,0,1,0,120},{10,0,0,1,0,120},{11,0,0,1,0,120},{12,1,0,1,0,120},{9,0,0,1,0,121},{10,0,0,1,0,121},{11,0,0,1,0,121},{12,1,0,1,0,121},{9,0,0,1,0,122},{10,0,0,1,0,122},{11,0,0,1,0,122},{12,1,0,1,0,122},{13,0,0,1,0,38},{14,1,0,1,0,38},{13,0,0,1,0,42},{14,1,0,1,0,42},{13,0,0,1,0,44},{14,1,0,1,0,44},{13,0,0,1,0,59},{14,1,0,1,0,59},{13,0,0,1,0,88},{14,1,0,1,0,88},{13,0,0,1,0,90},{14,1,0,1,0,90},{79,0,0,0,0,0},{80,0,0,0,0,0},{81,0,0,0,0,0},{82,0,0,0,0,0},{13,0,1,1,33,48},{14,1,1,1,33,48},{13,0,1,1,33,49},{14,1,1,1,33,49},{13,0,1,1,33,50},{14,1,1,1,33,50},{13,0,1,1,33,97},{14,1,1,1,33,97},{13,0,1,1,33,99},{14,1,1,1,33,99},{13,0,1,1,33,101},{14,1,1,1,33,101},{13,0,1,1,33,105},{14,1,1,1,33,105},{13,0,1,1,33,111},{14,1,1,1,33,111},{13,0,1,1,33,115},{14,1,1,1,33,115},{13,0,1,1,33,116},{14,1,1,1,33,116},{0,1,1,1,33,32},{0,1,1,1,33,37},{0,1,1,1,33,45},{0,1,1,1,33,46},{0,1,1,1,33,47},{0,1,1,1,33,51},{0,1,1,1,33,52},{0,1,1,1,33,53},{0,1,1,1,33,54},{0,1,1,1,33,55},{0,1,1,1,33,56},{0,1,1,1,33,57},{0,1,1,1,33,61},{0,1,1,1,33,65},{0,1,1,1,33,95},{0,1,1,1,33,98},{0,1,1,1,33,100},{0,1,1,1,33,102},{0,1,1,1,33,103},{0,1,1,1,33,104},{0,1,1,1,33,108},{0,1,1,1,33,109},{0,1,1,1,33,110},{0,1,1,1,33,112},{0,1,1,1,33,114},{0,1,1,1,33,117},{17,0,0,1,0,33},{18,0,0,1,0,33},{19,0,0,1,0,33},{20,0,0,1,0,33},{21,0,0,1,0,33},{22,0,0,1,0,33},{23,0,0,1,0,33},{24,0,0,1,0,33},{25,0,0,1,0,33},{26,0,0,1,0,33},{27,0,0,1,0,33},{28,0,0,1,0,33},{29,0,0,1,0,33},{30,0,0,1,0,33},{31,0,0,1,0,33},{32,0,0,1,0,33},{33,0,0,1,0,33},{34,1,0,1,0,33},{13,0,1,1,34,48},{14,1,1,1,34,48},{13,0,1,1,34,49},{14,1,1,1,34,49},{13,0,1,1,34,50},{14,1,1,1,34,50},{13,0,1,1,34,97},{14,1,1,1,34,97},{13,0,1,1,34,99},{14,1,1,1,34,99},{13,0,1,1,34,101},{14,1,1,1,34,101},{13,0,1,1,34,105},{14,1,1,1,34,105},{13,0,1,1,34,111},{14,1,1,1,34,111},{13,0,1,1,34,115},{14,1,1,1,34,115},{13,0,1,1,34,116},{14,1,1,1,34,116},{0,1,1,1,34,32},{0,1,1,1,34,37},{0,1,1,1,34,45},{0,1,1,1,34,46},{0,1,1,1,34,47},{0,1,1,1,34,51},{0,1,1,1,34,52},{0,1,1,1,34,53},{0,1,1,1,34,54},{0,1,1,1,34,55},{0,1,1,1,34,56},{0,1,1,1,34,57},{0,1,1,1,34,61},{0,1,1,1,34,65},{0,1,1,1,34,95},{0,1,1,1,34,98},{0,1,1,1,34,100},{0,1,1,1,34,102},{0,1,1,1,34,103},{0,1,1,1,34,104},{0,1,1,1,34,108},{0,1,1,1,34,109},{0,1,1,1,34,110},{0,1,1,1,34,112},{0,1,1,1,34,114},{0,1,1,1,34,117},{17,0,0,1,0,34},{18,0,0,1,0,34},{19,0,0,1,0,34},{20,0,0,1,0,34},{21,0,0,1,0,34},{22,0,0,1,0,34},{23,0,0,1,0,34},{24,0,0,1,0,34},{25,0,0,1,0,34},{26,0,0,1,0,34},{27,0,0,1,0,34},{28,0,0,1,0,34},{29,0,0,1,0,34},{30,0,0,1,0,34},{31,0,0,1,0,34},{32,0,0,1,0,34},{33,0,0,1,0,34},{34,1,0,1,0,34},{13,0,1,1,40,48},{14,1,1,1,40,48},{13,0,1,1,40,49},{14,1,1,1,40,49},{13,0,1,1,40,50},{14,1,1,1,40,50},{13,0,1,1,40,97},{14,1,1,1,40,97},{13,0,1,1,40,99},{14,1,1,1,40,99},{13,0,1,1,40,101},{14,1,1,1,40,101},{13,0,1,1,40,105},{14,1,1,1,40,105},{13,0,1,1,40,111},{14,1,1,1,40,111},{13,0,1,1,40,115},{14,1,1,1,40,115},{13,0,1,1,40,116},{14,1,1,1,40,116},{0,1,1,1,40,32},{0,1,1,1,40,37},{0,1,1,1,40,45},{0,1,1,1,40,46},{0,1,1,1,40,47},{0,1,1,1,40,51},{0,1,1,1,40,52},{0,1,1,1,40,53},{0,1,1,1,40,54},{0,1,1,1,40,55},{0,1,1,1,40,56},{0,1,1,1,40,57},{0,1,1,1,40,61},{0,1,1,1,40,65},{0,1,1,1,40,95},{0,1,1,1,40,98},{0,1,1,1,40,100},{0,1,1,1,40,102},{0,1,1,1,40,103},{0,1,1,1,40,104},{0,1,1,1,40,108},{0,1,1,1,40,109},{0,1,1,1,40,110},{0,1,1,1,40,112},{0,1,1,1,40,114},{0,1,1,1,40,117},{17,0,0,1,0,40},{18,0,0,1,0,40},{19,0,0,1,0,40},{20,0,0,1,0,40},{21,0,0,1,0,40},{22,0,0,1,0,40},{23,0,0,1,0,40},{24,0,0,1,0,40},{25,0,0,1,0,40},{26,0,0,1,0,40},{27,0,0,1,0,40},{28,0,0,1,0,40},{29,0,0,1,0,40},{30,0,0,1,0,40},{31,0,0,1,0,40},{32,0,0,1,0,40},{33,0,0,1,0,40},{34,1,0,1,0,40},{13,0,1,1,41,48},{14,1,1,1,41,48},{13,0,1,1,41,49},{14,1,1,1,41,49},{13,0,1,1,41,50},{14,1,1,1,41,50},{13,0,1,1,41,97},{14,1,1,1,41,97},{13,0,1,1,41,99},{14,1,1,1,41,99},{13,0,1,1,41,101},{14,1,1,1,41,101},{13,0,1,1,41,105},{14,1,1,1,41,105},{13,0,1,1,41,111},{14,1,1,1,41,111},{13,0,1,1,41,115},{14,1,1,1,41,115},{13,0,1,1,41,116},{14,1,1,1,41,116},{0,1,1,1,41,32},{0,1,1,1,41,37},{0,1,1,1,41,45},{0,1,1,1,41,46},{0,1,1,1,41,47},{0,1,1,1,41,51},{0,1,1,1,41,52},{0,1,1,1,41,53},{0,1,1,1,41,54},{0,1,1,1,41,55},{0,1,1,1,41,56},{0,1,1,1,41,57},{0,1,1,1,41,61},{0,1,1,1,41,65},{0,1,1,1,41,95},{0,1,1,1,41,98},{0,1,1,1,41,100},{0,1,1,1,41,102},{0,1,1,1,41,103},{0,1,1,1,41,104},{0,1,1,1,41,108},{0,1,1,1,41,109},{0,1,1,1,41,110},{0,1,1,1,41,112},{0,1,1,1,41,114},{0,1,1,1,41,117},{17,0,0,1,0,41},{18,0,0,1,0,41},{19,0,0,1,0,41},{20,0,0,1,0,41},{21,0,0,1,0,41},{22,0,0,1,0,41},{23,0,0,1,0,41},{24,0,0,1,0,41},{25,0,0,1,0,41},{26,0,0,1,0,41},{27,0,0,1,0,41},{28,0,0,1,0,41},{29,0,0,1,0,41},{30,0,0,1,0,41},{31,0,0,1,0,41},{32,0,0,1,0,41},{33,0,0,1,0,41},{34,1,0,1,0,41},{13,0,1,1,63,48},{14,1,1,1,63,48},{13,0,1,1,63,49},{14,1,1,1,63,49},{13,0,1,1,63,50},{14,1,1,1,63,50},{13,0,1,1,63,97},{14,1,1,1,63,97},{13,0,1,1,63,99},{14,1,1,1,63,99},{13,0,1,1,63,101},{14,1,1,1,63,101},{13,0,1,1,63,105},{14,1,1,1,63,105},{13,0,1,1,63,111},{14,1,1,1,63,111},{13,0,1,1,63,115},{14,1,1,1,63,115},{13,0,1,1,63,116},{14,1,1,1,63,116},{0,1,1,1,63,32},{0,1,1,1,63,37},{0,1,1,1,63,45},{0,1,1,1,63,46},{0,1,1,1,63,47},{0,1,1,1,63,51},{0,1,1,1,63,52},{0,1,1,1,63,53},{0,1,1,1,63,54},{0,1,1,1,63,55},{0,1,1,1,63,56},{0,1,1,1,63,57},{0,1,1,1,63,61},{0,1,1,1,63,65},{0,1,1,1,63,95},{0,1,1,1,63,98},{0,1,1,1,63,100},{0,1,1,1,63,102},{0,1,1,1,63,103},{0,1,1,1,63,104},{0,1,1,1,63,108},{0,1,1,1,63,109},{0,1,1,1,63,110},{0,1,1,1,63,112},{0,1,1,1,63,114},{0,1,1,1,63,117},{17,0,0,1,0,63},{18,0,0,1,0,63},{19,0,0,1,0,63},{20,0,0,1,0,63},{21,0,0,1,0,63},{22,0,0,1,0,63},{23,0,0,1,0,63},{24,0,0,1,0,63},{25,0,0,1,0,63},{26,0,0,1,0,63},{27,0,0,1,0,63},{28,0,0,1,0,63},{29,0,0,1,0,63},{30,0,0,1,0,63},{31,0,0,1,0,63},{32,0,0,1,0,63},{33,0,0,1,0,63},{34,1,0,1,0,63},{0,1,1,1,39,48},{0,1,1,1,39,49},{0,1,1,1,39,50},{0,1,1,1,39,97},{0,1,1,1,39,99},{0,1,1,1,39,101},{0,1,1,1,39,105},{0,1,1,1,39,111},{0,1,1,1,39,115},{0,1,1,1,39,116},{35,0,0,1,0,39},{36,0,0,1,0,39},{37,0,0,1,0,39},{38,0,0,1,0,39},{39,0,0,1,0,39},{40,0,0,1,0,39},{41,0,0,1,0,39},{42,0,0,1,0,39},{43,0,0,1,0,39},{44,0,0,1,0,39},{45,0,0,1,0,39},{46,0,0,1,0,39},{47,0,0,1,0,39},{48,0,0,1,0,39},{49,0,0,1,0,39},{50,0,0,1,0,39},{51,0,0,1,0,39},{52,0,0,1,0,39},{53,0,0,1,0,39},{54,0,0,1,0,39},{55,0,0,1,0,39},{56,1,0,1,0,39},{0,1,1,1,43,48},{0,1,1,1,43,49},{0,1,1,1,43,50},{0,1,1,1,43,97},{0,1,1,1,43,99},{0,1,1,1,43,101},{0,1,1,1,43,105},{0,1,1,1,43,111},{0,1,1,1,43,115},{0,1,1,1,43,116},{35,0,0,1,0,43},{36,0,0,1,0,43},{37,0,0,1,0,43},{38,0,0,1,0,43},{39,0,0,1,0,43},{40,0,0,1,0,43},{41,0,0,1,0,43},{42,0,0,1,0,43},{43,0,0,1,0,43},{44,0,0,1,0,43},{45,0,0,1,0,43},{46,0,0,1,0,43},{47,0,0,1,0,43},{48,0,0,1,0,43},{49,0,0,1,0,43},{50,0,0,1,0,43},{51,0,0,1,0,43},{52,0,0,1,0,43},{53,0,0,1,0,43},{54,0,0,1,0,43},{55,0,0,1,0,43},{56,1,0,1,0,43},{0,1,1,1,124,48},{0,1,1,1,124,49},{0,1,1,1,124,50},{0,1,1,1,124,97},{0,1,1,1,124,99},{0,1,1,1,124,101},{0,1,1,1,124,105},{0,1,1,1,124,111},{0,1,1,1,124,115},{0,1,1,1,124,116},{35,0,0,1,0,124},{36,0,0,1,0,124},{37,0,0,1,0,124},{38,0,0,1,0,124},{39,0,0,1,0,124},{40,0,0,1,0,124},{41,0,0,1,0,124},{42,0,0,1,0,124},{43,0,0,1,0,124},{44,0,0,1,0,124},{45,0,0,1,0,124},{46,0,0,1,0,124},{47,0,0,1,0,124},{48,0,0,1,0,124},{49,0,0,1,0,124},{50,0,0,1,0,124},{51,0,0,1,0,124},{52,0,0,1,0,124},{53,0,0,1,0,124},{54,0,0,1,0,124},{55,0,0,1,0,124},{56,1,0,1,0,124},{57,0,0,1,0,35},{58,0,0,1,0,35},{59,0,0,1,0,35},{60,0,0,1,0,35},{61,0,0,1,0,35},{62,0,0,1,0,35},{63,0,0,1,0,35},{64,0,0,1,0,35},{65,0,0,1,0,35},{66,0,0,1,0,35},{67,0,0,1,0,35},{68,0,0,1,0,35},{69,0,0,1,0,35},{70,0,0,1,0,35},{71,0,0,1,0,35},{72,1,0,1,0,35},{57,0,0,1,0,62},{58,0,0,1,0,62},{59,0,0,1,0,62},{60,0,0,1,0,62},{61,0,0,1,0,62},{62,0,0,1,0,62},{63,0,0,1,0,62},{64,0,0,1,0,62},{65,0,0,1,0,62},{66,0,0,1,0,62},{67,0,0,1,0,62},{68,0,0,1,0,62},{69,0,0,1,0,62},{70,0,0,1,0,62},{71,0,0,1,0,62},{72,1,0,1,0,62},{1,0,0,1,0,0},{2,0,0,1,0,0},{3,0,0,1,0,0},{4,0,0,1,0,0},{5,0,0,1,0,0},{6,0,0,1,0,0},{7,0,0,1,0,0},{8,1,0,1,0,0},{1,0,0,1,0,36},{2,0,0,1,0,36},{3,0,0,1,0,36},{4,0,0,1,0,36},{5,0,0,1,0,36},{6,0,0,1,0,36},{7,0,0,1,0,36},{8,1,0,1,0,36},{1,0,0,1,0,64},{2,0,0,1,0,64},{3,0,0,1,0,64},{4,0,0,1,0,64},{5,0,0,1,0,64},{6,0,0,1,0,64},{7,0,0,1,0,64},{8,1,0,1,0,64},{1,0,0,1,0,91},{2,0,0,1,0,91},{3,0,0,1,0,91},{4,0,0,1,0,91},{5,0,0,1,0,91},{6,0,0,1,0,91},{7,0,0,1,0,91},{8,1,0,1,0,91},{1,0,0,1,0,93},{2,0,0,1,0,93},{3,0,0,1,0,93},{4,0,0,1,0,93},{5,0,0,1,0,93},{6,0,0,1,0,93},{7,0,0,1,0,93},{8,1,0,1,0,93},{1,0,0,1,0,126},{2,0,0,1,0,126},{3,0,0,1,0,126},{4,0,0,1,0,126},{5,0,0,1,0,126},{6,0,0,1,0,126},{7,0,0,1,0,126},{8,1,0,1,0,126},{9,0,0,1,0,94},{10,0,0,1,0,94},{11,0,0,1,0,94},{12,1,0,1,0,94},{9,0,0,1,0,125},{10,0,0,1,0,125},{11,0,0,1,0,125},{12,1,0,1,0,125},{13,0,0,1,0,60},{14,1,0,1,0,60},{13,0,0,1,0,96},{14,1,0,1,0,96},{13,0,0,1,0,123},{14,1,0,1,0,123},{83,0,0,0,0,0},{84,0,0,0,0,0},{9,0,1,1,58,48},{10,0,1,1,58,48},{11,0,1,1,58,48},{12,1,1,1,58,48},{9,0,1,1,58,49},{10,0,1,1,58,49},{11,0,1,1,58,49},{12,1,1,1,58,49},{9,0,1,1,58,50},{10,0,1,1,58,50},{11,0,1,1,58,50},{12,1,1,1,58,50},{9,0,1,1,58,97},{10,0,1,1,58,97},{11,0,1,1,58,97},{12,1,1,1,58,97},{9,0,1,1,58,99},{10,0,1,1,58,99},{11,0,1,1,58,99},{12,1,1,1,58,99},{9,0,1,1,58,101},{10,0,1,1,58,101},{11,0,1,1,58,101},{12,1,1,1,58,101},{9,0,1,1,58,105},{10,0,1,1,58,105},{11,0,1,1,58,105},{12,1,1,1,58,105},{9,0,1,1,58,111},{10,0,1,1,58,111},{11,0,1,1,58,111},{12,1,1,1,58,111},{9,0,1,1,58,115},{10,0,1,1,58,115},{11,0,1,1,58,115},{12,1,1,1,58,115},{9,0,1,1,58,116},{10,0,1,1,58,116},{11,0,1,1,58,116},{12,1,1,1,58,116},{13,0,1,1,58,32},{14,1,1,1,58,32},{13,0,1,1,58,37},{14,1,1,1,58,37},{13,0,1,1,58,45},{14,1,1,1,58,45},{13,0,1,1,58,46},{14,1,1,1,58,46},{13,0,1,1,58,47},{14,1,1,1,58,47},{13,0,1,1,58,51},{14,1,1,1,58,51},{13,0,1,1,58,52},{14,1,1,1,58,52},{13,0,1,1,58,53},{14,1,1,1,58,53},{13,0,1,1,58,54},{14,1,1,1,58,54},{13,0,1,1,58,55},{14,1,1,1,58,55},{13,0,1,1,58,56},{14,1,1,1,58,56},{13,0,1,1,58,57},{14,1,1,1,58,57},{13,0,1,1,58,61},{14,1,1,1,58,61},{13,0,1,1,58,65},{14,1,1,1,58,65},{13,0,1,1,58,95},{14,1,1,1,58,95},{13,0,1,1,58,98},{14,1,1,1,58,98},{13,0,1,1,58,100},{14,1,1,1,58,100},{13,0,1,1,58,102},{14,1,1,1,58,102},{13,0,1,1,58,103},{14,1,1,1,58,103},{13,0,1,1,58,104},{14,1,1,1,58,104},{13,0,1,1,58,108},{14,1,1,1,58,108},{13,0,1,1,58,109},{14,1,1,1,58,109},{13,0,1,1,58,110},{14,1,1,1,58,110},{13,0,1,1,58,112},{14,1,1,1,58,112},{13,0,1,1,58,114},{14,1,1,1,58,114},{13,0,1,1,58,117},{14,1,1,1,58,117},{0,1,1,1,58,58},{0,1,1,1,58,66},{0,1,1,1,58,67},{0,1,1,1,58,68},{0,1,1,1,58,69},{0,1,1,1,58,70},{0,1,1,1,58,71},{0,1,1,1,58,72},{0,1,1,1,58,73},{0,1,1,1,58,74},{0,1,1,1,58,75},{0,1,1,1,58,76},{0,1,1,1,58,77},{0,1,1,1,58,78},{0,1,1,1,58,79},{0,1,1,1,58,80},{0,1,1,1,58,81},{0,1,1,1,58,82},{0,1,1,1,58,83},{0,1,1,1,58,84},{0,1,1,1,58,85},{0,1,1,1,58,86},{0,1,1,1,58,87},{0,1,1,1,58,89},{0,1,1,1,58,106},{0,1,1,1,58,107},{0,1,1,1,58,113},{0,1,1,1,58,118},{0,1,1,1,58,119},{0,1,1,1,58,120},{0,1,1,1,58,121},{0,1,1,1,58,122},{85,0,0,1,0,58},{86,0,0,1,0,58},{87,0,0,1,0,58},{88,1,0,1,0,58},{9,0,1,1,66,48},{10,0,1,1,66,48},{11,0,1,1,66,48},{12,1,1,1,66,48},{9,0,1,1,66,49},{10,0,1,1,66,49},{11,0,1,1,66,49},{12,1,1,1,66,49},{9,0,1,1,66,50},{10,0,1,1,66,50},{11,0,1,1,66,50},{12,1,1,1,66,50},{9,0,1,1,66,97},{10,0,1,1,66,97},{11,0,1,1,66,97},{12,1,1,1,66,97},{9,0,1,1,66,99},{10,0,1,1,66,99},{11,0,1,1,66,99},{12,1,1,1,66,99},{9,0,1,1,66,101},{10,0,1,1,66,101},{11,0,1,1,66,101},{12,1,1,1,66,101},{9,0,1,1,66,105},{10,0,1,1,66,105},{11,0,1,1,66,105},{12,1,1,1,66,105},{9,0,1,1,66,111},{10,0,1,1,66,111},{11,0,1,1,66,111},{12,1,1,1,66,111},{9,0,1,1,66,115},{10,0,1,1,66,115},{11,0,1,1,66,115},{12,1,1,1,66,115},{9,0,1,1,66,116},{10,0,1,1,66,116},{11,0,1,1,66,116},{12,1,1,1,66,116},{13,0,1,1,66,32},{14,1,1,1,66,32},{13,0,1,1,66,37},{14,1,1,1,66,37},{13,0,1,1,66,45},{14,1,1,1,66,45},{13,0,1,1,66,46},{14,1,1,1,66,46},{13,0,1,1,66,47},{14,1,1,1,66,47},{13,0,1,1,66,51},{14,1,1,1,66,51},{13,0,1,1,66,52},{14,1,1,1,66,52},{13,0,1,1,66,53},{14,1,1,1,66,53},{13,0,1,1,66,54},{14,1,1,1,66,54},{13,0,1,1,66,55},{14,1,1,1,66,55},{13,0,1,1,66,56},{14,1,1,1,66,56},{13,0,1,1,66,57},{14,1,1,1,66,57},{13,0,1,1,66,61},{14,1,1,1,66,61},{13,0,1,1,66,65},{14,1,1,1,66,65},{13,0,1,1,66,95},{14,1,1,1,66,95},{13,0,1,1,66,98},{14,1,1,1,66,98},{13,0,1,1,66,100},{14,1,1,1,66,100},{13,0,1,1,66,102},{14,1,1,1,66,102},{13,0,1,1,66,103},{14,1,1,1,66,103},{13,0,1,1,66,104},{14,1,1,1,66,104},{13,0,1,1,66,108},{14,1,1,1,66,108},{13,0,1,1,66,109},{14,1,1,1,66,109},{13,0,1,1,66,110},{14,1,1,1,66,110},{13,0,1,1,66,112},{14,1,1,1,66,112},{13,0,1,1,66,114},{14,1,1,1,66,114},{13,0,1,1,66,117},{14,1,1,1,66,117},{0,1,1,1,66,58},{0,1,1,1,66,66},{0,1,1,1,66,67},{0,1,1,1,66,68},{0,1,1,1,66,69},{0,1,1,1,66,70},{0,1,1,1,66,71},{0,1,1,1,66,72},{0,1,1,1,66,73},{0,1,1,1,66,74},{0,1,1,1,66,75},{0,1,1,1,66,76},{0,1,1,1,66,77},{0,1,1,1,66,78},{0,1,1,1,66,79},{0,1,1,1,66,80},{0,1,1,1,66,81},{0,1,1,1,66,82},{0,1,1,1,66,83},{0,1,1,1,66,84},{0,1,1,1,66,85},{0,1,1,1,66,86},{0,1,1,1,66,87},{0,1,1,1,66,89},{0,1,1,1,66,106},{0,1,1,1,66,107},{0,1,1,1,66,113},{0,1,1,1,66,118},{0,1,1,1,66,119},{0,1,1,1,66,120},{0,1,1,1,66,121},{0,1,1,1,66,122},{85,0,0,1,0,66},{86,0,0,1,0,66},{87,0,0,1,0,66},{88,1,0,1,0,66},{9,0,1,1,67,48},{10,0,1,1,67,48},{11,0,1,1,67,48},{12,1,1,1,67,48},{9,0,1,1,67,49},{10,0,1,1,67,49},{11,0,1,1,67,49},{12,1,1,1,67,49},{9,0,1,1,67,50},{10,0,1,1,67,50},{11,0,1,1,67,50},{12,1,1,1,67,50},{9,0,1,1,67,97},{10,0,1,1,67,97},{11,0,1,1,67,97},{12,1,1,1,67,97},{9,0,1,1,67,99},{10,0,1,1,67,99},{11,0,1,1,67,99},{12,1,1,1,67,99},{9,0,1,1,67,101},{10,0,1,1,67,101},{11,0,1,1,67,101},{12,1,1,1,67,101},{9,0,1,1,67,105},{10,0,1,1,67,105},{11,0,1,1,67,105},{12,1,1,1,67,105},{9,0,1,1,67,111},{10,0,1,1,67,111},{11,0,1,1,67,111},{12,1,1,1,67,111},{9,0,1,1,67,115},{10,0,1,1,67,115},{11,0,1,1,67,115},{12,1,1,1,67,115},{9,0,1,1,67,116},{10,0,1,1,67,116},{11,0,1,1,67,116},{12,1,1,1,67,116},{13,0,1,1,67,32},{14,1,1,1,67,32},{13,0,1,1,67,37},{14,1,1,1,67,37},{13,0,1,1,67,45},{14,1,1,1,67,45},{13,0,1,1,67,46},{14,1,1,1,67,46},{13,0,1,1,67,47},{14,1,1,1,67,47},{13,0,1,1,67,51},{14,1,1,1,67,51},{13,0,1,1,67,52},{14,1,1,1,67,52},{13,0,1,1,67,53},{14,1,1,1,67,53},{13,0,1,1,67,54},{14,1,1,1,67,54},{13,0,1,1,67,55},{14,1,1,1,67,55},{13,0,1,1,67,56},{14,1,1,1,67,56},{13,0,1,1,67,57},{14,1,1,1,67,57},{13,0,1,1,67,61},{14,1,1,1,67,61},{13,0,1,1,67,65},{14,1,1,1,67,65},{13,0,1,1,67,95},{14,1,1,1,67,95},{13,0,1,1,67,98},{14,1,1,1,67,98},{13,0,1,1,67,100},{14,1,1,1,67,100},{13,0,1,1,67,102},{14,1,1,1,67,102},{13,0,1,1,67,103},{14,1,1,1,67,103},{13,0,1,1,67,104},{14,1,1,1,67,104},{13,0,1,1,67,108},{14,1,1,1,67,108},{13,0,1,1,67,109},{14,1,1,1,67,109},{13,0,1,1,67,110},{14,1,1,1,67,110},{13,0,1,1,67,112},{14,1,1,1,67,112},{13,0,1,1,67,114},{14,1,1,1,67,114},{13,0,1,1,67,117},{14,1,1,1,67,117},{0,1,1,1,67,58},{0,1,1,1,67,66},{0,1,1,1,67,67},{0,1,1,1,67,68},{0,1,1,1,67,69},{0,1,1,1,67,70},{0,1,1,1,67,71},{0,1,1,1,67,72},{0,1,1,1,67,73},{0,1,1,1,67,74},{0,1,1,1,67,75},{0,1,1,1,67,76},{0,1,1,1,67,77},{0,1,1,1,67,78},{0,1,1,1,67,79},{0,1,1,1,67,80},{0,1,1,1,67,81},{0,1,1,1,67,82},{0,1,1,1,67,83},{0,1,1,1,67,84},{0,1,1,1,67,85},{0,1,1,1,67,86},{0,1,1,1,67,87},{0,1,1,1,67,89},{0,1,1,1,67,106},{0,1,1,1,67,107},{0,1,1,1,67,113},{0,1,1,1,67,118},{0,1,1,1,67,119},{0,1,1,1,67,120},{0,1,1,1,67,121},{0,1,1,1,67,122},{85,0,0,1,0,67},{86,0,0,1,0,67},{87,0,0,1,0,67},{88,1,0,1,0,67},{9,0,1,1,68,48},{10,0,1,1,68,48},{11,0,1,1,68,48},{12,1,1,1,68,48},{9,0,1,1,68,49},{10,0,1,1,68,49},{11,0,1,1,68,49},{12,1,1,1,68,49},{9,0,1,1,68,50},{10,0,1,1,68,50},{11,0,1,1,68,50},{12,1,1,1,68,50},{9,0,1,1,68,97},{10,0,1,1,68,97},{11,0,1,1,68,97},{12,1,1,1,68,97},{9,0,1,1,68,99},{10,0,1,1,68,99},{11,0,1,1,68,99},{12,1,1,1,68,99},{9,0,1,1,68,101},{10,0,1,1,68,101},{11,0,1,1,68,101},{12,1,1,1,68,101},{9,0,1,1,68,105},{10,0,1,1,68,105},{11,0,1,1,68,105},{12,1,1,1,68,105},{9,0,1,1,68,111},{10,0,1,1,68,111},{11,0,1,1,68,111},{12,1,1,1,68,111},{9,0,1,1,68,115},{10,0,1,1,68,115},{11,0,1,1,68,115},{12,1,1,1,68,115},{9,0,1,1,68,116},{10,0,1,1,68,116},{11,0,1,1,68,116},{12,1,1,1,68,116},{13,0,1,1,68,32},{14,1,1,1,68,32},{13,0,1,1,68,37},{14,1,1,1,68,37},{13,0,1,1,68,45},{14,1,1,1,68,45},{13,0,1,1,68,46},{14,1,1,1,68,46},{13,0,1,1,68,47},{14,1,1,1,68,47},{13,0,1,1,68,51},{14,1,1,1,68,51},{13,0,1,1,68,52},{14,1,1,1,68,52},{13,0,1,1,68,53},{14,1,1,1,68,53},{13,0,1,1,68,54},{14,1,1,1,68,54},{13,0,1,1,68,55},{14,1,1,1,68,55},{13,0,1,1,68,56},{14,1,1,1,68,56},{13,0,1,1,68,57},{14,1,1,1,68,57},{13,0,1,1,68,61},{14,1,1,1,68,61},{13,0,1,1,68,65},{14,1,1,1,68,65},{13,0,1,1,68,95},{14,1,1,1,68,95},{13,0,1,1,68,98},{14,1,1,1,68,98},{13,0,1,1,68,100},{14,1,1,1,68,100},{13,0,1,1,68,102},{14,1,1,1,68,102},{13,0,1,1,68,103},{14,1,1,1,68,103},{13,0,1,1,68,104},{14,1,1,1,68,104},{13,0,1,1,68,108},{14,1,1,1,68,108},{13,0,1,1,68,109},{14,1,1,1,68,109},{13,0,1,1,68,110},{14,1,1,1,68,110},{13,0,1,1,68,112},{14,1,1,1,68,112},{13,0,1,1,68,114},{14,1,1,1,68,114},{13,0,1,1,68,117},{14,1,1,1,68,117},{0,1,1,1,68,58},{0,1,1,1,68,66},{0,1,1,1,68,67},{0,1,1,1,68,68},{0,1,1,1,68,69},{0,1,1,1,68,70},{0,1,1,1,68,71},{0,1,1,1,68,72},{0,1,1,1,68,73},{0,1,1,1,68,74},{0,1,1,1,68,75},{0,1,1,1,68,76},{0,1,1,1,68,77},{0,1,1,1,68,78},{0,1,1,1,68,79},{0,1,1,1,68,80},{0,1,1,1,68,81},{0,1,1,1,68,82},{0,1,1,1,68,83},{0,1,1,1,68,84},{0,1,1,1,68,85},{0,1,1,1,68,86},{0,1,1,1,68,87},{0,1,1,1,68,89},{0,1,1,1,68,106},{0,1,1,1,68,107},{0,1,1,1,68,113},{0,1,1,1,68,118},{0,1,1,1,68,119},{0,1,1,1,68,120},{0,1,1,1,68,121},{0,1,1,1,68,122},{85,0,0,1,0,68},{86,0,0,1,0,68},{87,0,0,1,0,68},{88,1,0,1,0,68},{9,0,1,1,69,48},{10,0,1,1,69,48},{11,0,1,1,69,48},{12,1,1,1,69,48},{9,0,1,1,69,49},{10,0,1,1,69,49},{11,0,1,1,69,49},{12,1,1,1,69,49},{9,0,1,1,69,50},{10,0,1,1,69,50},{11,0,1,1,69,50},{12,1,1,1,69,50},{9,0,1,1,69,97},{10,0,1,1,69,97},{11,0,1,1,69,97},{12,1,1,1,69,97},{9,0,1,1,69,99},{10,0,1,1,69,99},{11,0,1,1,69,99},{12,1,1,1,69,99},{9,0,1,1,69,101},{10,0,1,1,69,101},{11,0,1,1,69,101},{12,1,1,1,69,101},{9,0,1,1,69,105},{10,0,1,1,69,105},{11,0,1,1,69,105},{12,1,1,1,69,105},{9,0,1,1,69,111},{10,0,1,1,69,111},{11,0,1,1,69,111},{12,1,1,1,69,111},{9,0,1,1,69,115},{10,0,1,1,69,115},{11,0,1,1,69,115},{12,1,1,1,69,115},{9,0,1,1,69,116},{10,0,1,1,69,116},{11,0,1,1,69,116},{12,1,1,1,69,116},{13,0,1,1,69,32},{14,1,1,1,69,32},{13,0,1,1,69,37},{14,1,1,1,69,37},{13,0,1,1,69,45},{14,1,1,1,69,45},{13,0,1,1,69,46},{14,1,1,1,69,46},{13,0,1,1,69,47},{14,1,1,1,69,47},{13,0,1,1,69,51},{14,1,1,1,69,51},{13,0,1,1,69,52},{14,1,1,1,69,52},{13,0,1,1,69,53},{14,1,1,1,69,53},{13,0,1,1,69,54},{14,1,1,1,69,54},{13,0,1,1,69,55},{14,1,1,1,69,55},{13,0,1,1,69,56},{14,1,1,1,69,56},{13,0,1,1,69,57},{14,1,1,1,69,57},{13,0,1,1,69,61},{14,1,1,1,69,61},{13,0,1,1,69,65},{14,1,1,1,69,65},{13,0,1,1,69,95},{14,1,1,1,69,95},{13,0,1,1,69,98},{14,1,1,1,69,98},{13,0,1,1,69,100},{14,1,1,1,69,100},{13,0,1,1,69,102},{14,1,1,1,69,102},{13,0,1,1,69,103},{14,1,1,1,69,103},{13,0,1,1,69,104},{14,1,1,1,69,104},{13,0,1,1,69,108},{14,1,1,1,69,108},{13,0,1,1,69,109},{14,1,1,1,69,109},{13,0,1,1,69,110},{14,1,1,1,69,110},{13,0,1,1,69,112},{14,1,1,1,69,112},{13,0,1,1,69,114},{14,1,1,1,69,114},{13,0,1,1,69,117},{14,1,1,1,69,117},{0,1,1,1,69,58},{0,1,1,1,69,66},{0,1,1,1,69,67},{0,1,1,1,69,68},{0,1,1,1,69,69},{0,1,1,1,69,70},{0,1,1,1,69,71},{0,1,1,1,69,72},{0,1,1,1,69,73},{0,1,1,1,69,74},{0,1,1,1,69,75},{0,1,1,1,69,76},{0,1,1,1,69,77},{0,1,1,1,69,78},{0,1,1,1,69,79},{0,1,1,1,69,80},{0,1,1,1,69,81},{0,1,1,1,69,82},{0,1,1,1,69,83},{0,1,1,1,69,84},{0,1,1,1,69,85},{0,1,1,1,69,86},{0,1,1,1,69,87},{0,1,1,1,69,89},{0,1,1,1,69,106},{0,1,1,1,69,107},{0,1,1,1,69,113},{0,1,1,1,69,118},{0,1,1,1,69,119},{0,1,1,1,69,120},{0,1,1,1,69,121},{0,1,1,1,69,122},{85,0,0,1,0,69},{86,0,0,1,0,69},{87,0,0,1,0,69},{88,1,0,1,0,69},{9,0,1,1,70,48},{10,0,1,1,70,48},{11,0,1,1,70,48},{12,1,1,1,70,48},{9,0,1,1,70,49},{10,0,1,1,70,49},{11,0,1,1,70,49},{12,1,1,1,70,49},{9,0,1,1,70,50},{10,0,1,1,70,50},{11,0,1,1,70,50},{12,1,1,1,70,50},{9,0,1,1,70,97},{10,0,1,1,70,97},{11,0,1,1,70,97},{12,1,1,1,70,97},{9,0,1,1,70,99},{10,0,1,1,70,99},{11,0,1,1,70,99},{12,1,1,1,70,99},{9,0,1,1,70,101},{10,0,1,1,70,101},{11,0,1,1,70,101},{12,1,1,1,70,101},{9,0,1,1,70,105},{10,0,1,1,70,105},{11,0,1,1,70,105},{12,1,1,1,70,105},{9,0,1,1,70,111},{10,0,1,1,70,111},{11,0,1,1,70,111},{12,1,1,1,70,111},{9,0,1,1,70,115},{10,0,1,1,70,115},{11,0,1,1,70,115},{12,1,1,1,70,115},{9,0,1,1,70,116},{10,0,1,1,70,116},{11,0,1,1,70,116},{12,1,1,1,70,116},{13,0,1,1,70,32},{14,1,1,1,70,32},{13,0,1,1,70,37},{14,1,1,1,70,37},{13,0,1,1,70,45},{14,1,1,1,70,45},{13,0,1,1,70,46},{14,1,1,1,70,46},{13,0,1,1,70,47},{14,1,1,1,70,47},{13,0,1,1,70,51},{14,1,1,1,70,51},{13,0,1,1,70,52},{14,1,1,1,70,52},{13,0,1,1,70,53},{14,1,1,1,70,53},{13,0,1,1,70,54},{14,1,1,1,70,54},{13,0,1,1,70,55},{14,1,1,1,70,55},{13,0,1,1,70,56},{14,1,1,1,70,56},{13,0,1,1,70,57},{14,1,1,1,70,57},{13,0,1,1,70,61},{14,1,1,1,70,61},{13,0,1,1,70,65},{14,1,1,1,70,65},{13,0,1,1,70,95},{14,1,1,1,70,95},{13,0,1,1,70,98},{14,1,1,1,70,98},{13,0,1,1,70,100},{14,1,1,1,70,100},{13,0,1,1,70,102},{14,1,1,1,70,102},{13,0,1,1,70,103},{14,1,1,1,70,103},{13,0,1,1,70,104},{14,1,1,1,70,104},{13,0,1,1,70,108},{14,1,1,1,70,108},{13,0,1,1,70,109},{14,1,1,1,70,109},{13,0,1,1,70,110},{14,1,1,1,70,110},{13,0,1,1,70,112},{14,1,1,1,70,112},{13,0,1,1,70,114},{14,1,1,1,70,114},{13,0,1,1,70,117},{14,1,1,1,70,117},{0,1,1,1,70,58},{0,1,1,1,70,66},{0,1,1,1,70,67},{0,1,1,1,70,68},{0,1,1,1,70,69},{0,1,1,1,70,70},{0,1,1,1,70,71},{0,1,1,1,70,72},{0,1,1,1,70,73},{0,1,1,1,70,74},{0,1,1,1,70,75},{0,1,1,1,70,76},{0,1,1,1,70,77},{0,1,1,1,70,78},{0,1,1,1,70,79},{0,1,1,1,70,80},{0,1,1,1,70,81},{0,1,1,1,70,82},{0,1,1,1,70,83},{0,1,1,1,70,84},{0,1,1,1,70,85},{0,1,1,1,70,86},{0,1,1,1,70,87},{0,1,1,1,70,89},{0,1,1,1,70,106},{0,1,1,1,70,107},{0,1,1,1,70,113},{0,1,1,1,70,118},{0,1,1,1,70,119},{0,1,1,1,70,120},{0,1,1,1,70,121},{0,1,1,1,70,122},{85,0,0,1,0,70},{86,0,0,1,0,70},{87,0,0,1,0,70},{88,1,0,1,0,70},{9,0,1,1,71,48},{10,0,1,1,71,48},{11,0,1,1,71,48},{12,1,1,1,71,48},{9,0,1,1,71,49},{10,0,1,1,71,49},{11,0,1,1,71,49},{12,1,1,1,71,49},{9,0,1,1,71,50},{10,0,1,1,71,50},{11,0,1,1,71,50},{12,1,1,1,71,50},{9,0,1,1,71,97},{10,0,1,1,71,97},{11,0,1,1,71,97},{12,1,1,1,71,97},{9,0,1,1,71,99},{10,0,1,1,71,99},{11,0,1,1,71,99},{12,1,1,1,71,99},{9,0,1,1,71,101},{10,0,1,1,71,101},{11,0,1,1,71,101},{12,1,1,1,71,101},{9,0,1,1,71,105},{10,0,1,1,71,105},{11,0,1,1,71,105},{12,1,1,1,71,105},{9,0,1,1,71,111},{10,0,1,1,71,111},{11,0,1,1,71,111},{12,1,1,1,71,111},{9,0,1,1,71,115},{10,0,1,1,71,115},{11,0,1,1,71,115},{12,1,1,1,71,115},{9,0,1,1,71,116},{10,0,1,1,71,116},{11,0,1,1,71,116},{12,1,1,1,71,116},{13,0,1,1,71,32},{14,1,1,1,71,32},{13,0,1,1,71,37},{14,1,1,1,71,37},{13,0,1,1,71,45},{14,1,1,1,71,45},{13,0,1,1,71,46},{14,1,1,1,71,46},{13,0,1,1,71,47},{14,1,1,1,71,47},{13,0,1,1,71,51},{14,1,1,1,71,51},{13,0,1,1,71,52},{14,1,1,1,71,52},{13,0,1,1,71,53},{14,1,1,1,71,53},{13,0,1,1,71,54},{14,1,1,1,71,54},{13,0,1,1,71,55},{14,1,1,1,71,55},{13,0,1,1,71,56},{14,1,1,1,71,56},{13,0,1,1,71,57},{14,1,1,1,71,57},{13,0,1,1,71,61},{14,1,1,1,71,61},{13,0,1,1,71,65},{14,1,1,1,71,65},{13,0,1,1,71,95},{14,1,1,1,71,95},{13,0,1,1,71,98},{14,1,1,1,71,98},{13,0,1,1,71,100},{14,1,1,1,71,100},{13,0,1,1,71,102},{14,1,1,1,71,102},{13,0,1,1,71,103},{14,1,1,1,71,103},{13,0,1,1,71,104},{14,1,1,1,71,104},{13,0,1,1,71,108},{14,1,1,1,71,108},{13,0,1,1,71,109},{14,1,1,1,71,109},{13,0,1,1,71,110},{14,1,1,1,71,110},{13,0,1,1,71,112},{14,1,1,1,71,112},{13,0,1,1,71,114},{14,1,1,1,71,114},{13,0,1,1,71,117},{14,1,1,1,71,117},{0,1,1,1,71,58},{0,1,1,1,71,66},{0,1,1,1,71,67},{0,1,1,1,71,68},{0,1,1,1,71,69},{0,1,1,1,71,70},{0,1,1,1,71,71},{0,1,1,1,71,72},{0,1,1,1,71,73},{0,1,1,1,71,74},{0,1,1,1,71,75},{0,1,1,1,71,76},{0,1,1,1,71,77},{0,1,1,1,71,78},{0,1,1,1,71,79},{0,1,1,1,71,80},{0,1,1,1,71,81},{0,1,1,1,71,82},{0,1,1,1,71,83},{0,1,1,1,71,84},{0,1,1,1,71,85},{0,1,1,1,71,86},{0,1,1,1,71,87},{0,1,1,1,71,89},{0,1,1,1,71,106},{0,1,1,1,71,107},{0,1,1,1,71,113},{0,1,1,1,71,118},{0,1,1,1,71,119},{0,1,1,1,71,120},{0,1,1,1,71,121},{0,1,1,1,71,122},{85,0,0,1,0,71},{86,0,0,1,0,71},{87,0,0,1,0,71},{88,1,0,1,0,71},{9,0,1,1,72,48},{10,0,1,1,72,48},{11,0,1,1,72,48},{12,1,1,1,72,48},{9,0,1,1,72,49},{10,0,1,1,72,49},{11,0,1,1,72,49},{12,1,1,1,72,49},{9,0,1,1,72,50},{10,0,1,1,72,50},{11,0,1,1,72,50},{12,1,1,1,72,50},{9,0,1,1,72,97},{10,0,1,1,72,97},{11,0,1,1,72,97},{12,1,1,1,72,97},{9,0,1,1,72,99},{10,0,1,1,72,99},{11,0,1,1,72,99},{12,1,1,1,72,99},{9,0,1,1,72,101},{10,0,1,1,72,101},{11,0,1,1,72,101},{12,1,1,1,72,101},{9,0,1,1,72,105},{10,0,1,1,72,105},{11,0,1,1,72,105},{12,1,1,1,72,105},{9,0,1,1,72,111},{10,0,1,1,72,111},{11,0,1,1,72,111},{12,1,1,1,72,111},{9,0,1,1,72,115},{10,0,1,1,72,115},{11,0,1,1,72,115},{12,1,1,1,72,115},{9,0,1,1,72,116},{10,0,1,1,72,116},{11,0,1,1,72,116},{12,1,1,1,72,116},{13,0,1,1,72,32},{14,1,1,1,72,32},{13,0,1,1,72,37},{14,1,1,1,72,37},{13,0,1,1,72,45},{14,1,1,1,72,45},{13,0,1,1,72,46},{14,1,1,1,72,46},{13,0,1,1,72,47},{14,1,1,1,72,47},{13,0,1,1,72,51},{14,1,1,1,72,51},{13,0,1,1,72,52},{14,1,1,1,72,52},{13,0,1,1,72,53},{14,1,1,1,72,53},{13,0,1,1,72,54},{14,1,1,1,72,54},{13,0,1,1,72,55},{14,1,1,1,72,55},{13,0,1,1,72,56},{14,1,1,1,72,56},{13,0,1,1,72,57},{14,1,1,1,72,57},{13,0,1,1,72,61},{14,1,1,1,72,61},{13,0,1,1,72,65},{14,1,1,1,72,65},{13,0,1,1,72,95},{14,1,1,1,72,95},{13,0,1,1,72,98},{14,1,1,1,72,98},{13,0,1,1,72,100},{14,1,1,1,72,100},{13,0,1,1,72,102},{14,1,1,1,72,102},{13,0,1,1,72,103},{14,1,1,1,72,103},{13,0,1,1,72,104},{14,1,1,1,72,104},{13,0,1,1,72,108},{14,1,1,1,72,108},{13,0,1,1,72,109},{14,1,1,1,72,109},{13,0,1,1,72,110},{14,1,1,1,72,110},{13,0,1,1,72,112},{14,1,1,1,72,112},{13,0,1,1,72,114},{14,1,1,1,72,114},{13,0,1,1,72,117},{14,1,1,1,72,117},{0,1,1,1,72,58},{0,1,1,1,72,66},{0,1,1,1,72,67},{0,1,1,1,72,68},{0,1,1,1,72,69},{0,1,1,1,72,70},{0,1,1,1,72,71},{0,1,1,1,72,72},{0,1,1,1,72,73},{0,1,1,1,72,74},{0,1,1,1,72,75},{0,1,1,1,72,76},{0,1,1,1,72,77},{0,1,1,1,72,78},{0,1,1,1,72,79},{0,1,1,1,72,80},{0,1,1,1,72,81},{0,1,1,1,72,82},{0,1,1,1,72,83},{0,1,1,1,72,84},{0,1,1,1,72,85},{0,1,1,1,72,86},{0,1,1,1,72,87},{0,1,1,1,72,89},{0,1,1,1,72,106},{0,1,1,1,72,107},{0,1,1,1,72,113},{0,1,1,1,72,118},{0,1,1,1,72,119},{0,1,1,1,72,120},{0,1,1,1,72,121},{0,1,1,1,72,122},{85,0,0,1,0,72},{86,0,0,1,0,72},{87,0,0,1,0,72},{88,1,0,1,0,72},{9,0,1,1,73,48},{10,0,1,1,73,48},{11,0,1,1,73,48},{12,1,1,1,73,48},{9,0,1,1,73,49},{10,0,1,1,73,49},{11,0,1,1,73,49},{12,1,1,1,73,49},{9,0,1,1,73,50},{10,0,1,1,73,50},{11,0,1,1,73,50},{12,1,1,1,73,50},{9,0,1,1,73,97},{10,0,1,1,73,97},{11,0,1,1,73,97},{12,1,1,1,73,97},{9,0,1,1,73,99},{10,0,1,1,73,99},{11,0,1,1,73,99},{12,1,1,1,73,99},{9,0,1,1,73,101},{10,0,1,1,73,101},{11,0,1,1,73,101},{12,1,1,1,73,101},{9,0,1,1,73,105},{10,0,1,1,73,105},{11,0,1,1,73,105},{12,1,1,1,73,105},{9,0,1,1,73,111},{10,0,1,1,73,111},{11,0,1,1,73,111},{12,1,1,1,73,111},{9,0,1,1,73,115},{10,0,1,1,73,115},{11,0,1,1,73,115},{12,1,1,1,73,115},{9,0,1,1,73,116},{10,0,1,1,73,116},{11,0,1,1,73,116},{12,1,1,1,73,116},{13,0,1,1,73,32},{14,1,1,1,73,32},{13,0,1,1,73,37},{14,1,1,1,73,37},{13,0,1,1,73,45},{14,1,1,1,73,45},{13,0,1,1,73,46},{14,1,1,1,73,46},{13,0,1,1,73,47},{14,1,1,1,73,47},{13,0,1,1,73,51},{14,1,1,1,73,51},{13,0,1,1,73,52},{14,1,1,1,73,52},{13,0,1,1,73,53},{14,1,1,1,73,53},{13,0,1,1,73,54},{14,1,1,1,73,54},{13,0,1,1,73,55},{14,1,1,1,73,55},{13,0,1,1,73,56},{14,1,1,1,73,56},{13,0,1,1,73,57},{14,1,1,1,73,57},{13,0,1,1,73,61},{14,1,1,1,73,61},{13,0,1,1,73,65},{14,1,1,1,73,65},{13,0,1,1,73,95},{14,1,1,1,73,95},{13,0,1,1,73,98},{14,1,1,1,73,98},{13,0,1,1,73,100},{14,1,1,1,73,100},{13,0,1,1,73,102},{14,1,1,1,73,102},{13,0,1,1,73,103},{14,1,1,1,73,103},{13,0,1,1,73,104},{14,1,1,1,73,104},{13,0,1,1,73,108},{14,1,1,1,73,108},{13,0,1,1,73,109},{14,1,1,1,73,109},{13,0,1,1,73,110},{14,1,1,1,73,110},{13,0,1,1,73,112},{14,1,1,1,73,112},{13,0,1,1,73,114},{14,1,1,1,73,114},{13,0,1,1,73,117},{14,1,1,1,73,117},{0,1,1,1,73,58},{0,1,1,1,73,66},{0,1,1,1,73,67},{0,1,1,1,73,68},{0,1,1,1,73,69},{0,1,1,1,73,70},{0,1,1,1,73,71},{0,1,1,1,73,72},{0,1,1,1,73,73},{0,1,1,1,73,74},{0,1,1,1,73,75},{0,1,1,1,73,76},{0,1,1,1,73,77},{0,1,1,1,73,78},{0,1,1,1,73,79},{0,1,1,1,73,80},{0,1,1,1,73,81},{0,1,1,1,73,82},{0,1,1,1,73,83},{0,1,1,1,73,84},{0,1,1,1,73,85},{0,1,1,1,73,86},{0,1,1,1,73,87},{0,1,1,1,73,89},{0,1,1,1,73,106},{0,1,1,1,73,107},{0,1,1,1,73,113},{0,1,1,1,73,118},{0,1,1,1,73,119},{0,1,1,1,73,120},{0,1,1,1,73,121},{0,1,1,1,73,122},{85,0,0,1,0,73},{86,0,0,1,0,73},{87,0,0,1,0,73},{88,1,0,1,0,73},{9,0,1,1,74,48},{10,0,1,1,74,48},{11,0,1,1,74,48},{12,1,1,1,74,48},{9,0,1,1,74,49},{10,0,1,1,74,49},{11,0,1,1,74,49},{12,1,1,1,74,49},{9,0,1,1,74,50},{10,0,1,1,74,50},{11,0,1,1,74,50},{12,1,1,1,74,50},{9,0,1,1,74,97},{10,0,1,1,74,97},{11,0,1,1,74,97},{12,1,1,1,74,97},{9,0,1,1,74,99},{10,0,1,1,74,99},{11,0,1,1,74,99},{12,1,1,1,74,99},{9,0,1,1,74,101},{10,0,1,1,74,101},{11,0,1,1,74,101},{12,1,1,1,74,101},{9,0,1,1,74,105},{10,0,1,1,74,105},{11,0,1,1,74,105},{12,1,1,1,74,105},{9,0,1,1,74,111},{10,0,1,1,74,111},{11,0,1,1,74,111},{12,1,1,1,74,111},{9,0,1,1,74,115},{10,0,1,1,74,115},{11,0,1,1,74,115},{12,1,1,1,74,115},{9,0,1,1,74,116},{10,0,1,1,74,116},{11,0,1,1,74,116},{12,1,1,1,74,116},{13,0,1,1,74,32},{14,1,1,1,74,32},{13,0,1,1,74,37},{14,1,1,1,74,37},{13,0,1,1,74,45},{14,1,1,1,74,45},{13,0,1,1,74,46},{14,1,1,1,74,46},{13,0,1,1,74,47},{14,1,1,1,74,47},{13,0,1,1,74,51},{14,1,1,1,74,51},{13,0,1,1,74,52},{14,1,1,1,74,52},{13,0,1,1,74,53},{14,1,1,1,74,53},{13,0,1,1,74,54},{14,1,1,1,74,54},{13,0,1,1,74,55},{14,1,1,1,74,55},{13,0,1,1,74,56},{14,1,1,1,74,56},{13,0,1,1,74,57},{14,1,1,1,74,57},{13,0,1,1,74,61},{14,1,1,1,74,61},{13,0,1,1,74,65},{14,1,1,1,74,65},{13,0,1,1,74,95},{14,1,1,1,74,95},{13,0,1,1,74,98},{14,1,1,1,74,98},{13,0,1,1,74,100},{14,1,1,1,74,100},{13,0,1,1,74,102},{14,1,1,1,74,102},{13,0,1,1,74,103},{14,1,1,1,74,103},{13,0,1,1,74,104},{14,1,1,1,74,104},{13,0,1,1,74,108},{14,1,1,1,74,108},{13,0,1,1,74,109},{14,1,1,1,74,109},{13,0,1,1,74,110},{14,1,1,1,74,110},{13,0,1,1,74,112},{14,1,1,1,74,112},{13,0,1,1,74,114},{14,1,1,1,74,114},{13,0,1,1,74,117},{14,1,1,1,74,117},{0,1,1,1,74,58},{0,1,1,1,74,66},{0,1,1,1,74,67},{0,1,1,1,74,68},{0,1,1,1,74,69},{0,1,1,1,74,70},{0,1,1,1,74,71},{0,1,1,1,74,72},{0,1,1,1,74,73},{0,1,1,1,74,74},{0,1,1,1,74,75},{0,1,1,1,74,76},{0,1,1,1,74,77},{0,1,1,1,74,78},{0,1,1,1,74,79},{0,1,1,1,74,80},{0,1,1,1,74,81},{0,1,1,1,74,82},{0,1,1,1,74,83},{0,1,1,1,74,84},{0,1,1,1,74,85},{0,1,1,1,74,86},{0,1,1,1,74,87},{0,1,1,1,74,89},{0,1,1,1,74,106},{0,1,1,1,74,107},{0,1,1,1,74,113},{0,1,1,1,74,118},{0,1,1,1,74,119},{0,1,1,1,74,120},{0,1,1,1,74,121},{0,1,1,1,74,122},{85,0,0,1,0,74},{86,0,0,1,0,74},{87,0,0,1,0,74},{88,1,0,1,0,74},{9,0,1,1,75,48},{10,0,1,1,75,48},{11,0,1,1,75,48},{12,1,1,1,75,48},{9,0,1,1,75,49},{10,0,1,1,75,49},{11,0,1,1,75,49},{12,1,1,1,75,49},{9,0,1,1,75,50},{10,0,1,1,75,50},{11,0,1,1,75,50},{12,1,1,1,75,50},{9,0,1,1,75,97},{10,0,1,1,75,97},{11,0,1,1,75,97},{12,1,1,1,75,97},{9,0,1,1,75,99},{10,0,1,1,75,99},{11,0,1,1,75,99},{12,1,1,1,75,99},{9,0,1,1,75,101},{10,0,1,1,75,101},{11,0,1,1,75,101},{12,1,1,1,75,101},{9,0,1,1,75,105},{10,0,1,1,75,105},{11,0,1,1,75,105},{12,1,1,1,75,105},{9,0,1,1,75,111},{10,0,1,1,75,111},{11,0,1,1,75,111},{12,1,1,1,75,111},{9,0,1,1,75,115},{10,0,1,1,75,115},{11,0,1,1,75,115},{12,1,1,1,75,115},{9,0,1,1,75,116},{10,0,1,1,75,116},{11,0,1,1,75,116},{12,1,1,1,75,116},{13,0,1,1,75,32},{14,1,1,1,75,32},{13,0,1,1,75,37},{14,1,1,1,75,37},{13,0,1,1,75,45},{14,1,1,1,75,45},{13,0,1,1,75,46},{14,1,1,1,75,46},{13,0,1,1,75,47},{14,1,1,1,75,47},{13,0,1,1,75,51},{14,1,1,1,75,51},{13,0,1,1,75,52},{14,1,1,1,75,52},{13,0,1,1,75,53},{14,1,1,1,75,53},{13,0,1,1,75,54},{14,1,1,1,75,54},{13,0,1,1,75,55},{14,1,1,1,75,55},{13,0,1,1,75,56},{14,1,1,1,75,56},{13,0,1,1,75,57},{14,1,1,1,75,57},{13,0,1,1,75,61},{14,1,1,1,75,61},{13,0,1,1,75,65},{14,1,1,1,75,65},{13,0,1,1,75,95},{14,1,1,1,75,95},{13,0,1,1,75,98},{14,1,1,1,75,98},{13,0,1,1,75,100},{14,1,1,1,75,100},{13,0,1,1,75,102},{14,1,1,1,75,102},{13,0,1,1,75,103},{14,1,1,1,75,103},{13,0,1,1,75,104},{14,1,1,1,75,104},{13,0,1,1,75,108},{14,1,1,1,75,108},{13,0,1,1,75,109},{14,1,1,1,75,109},{13,0,1,1,75,110},{14,1,1,1,75,110},{13,0,1,1,75,112},{14,1,1,1,75,112},{13,0,1,1,75,114},{14,1,1,1,75,114},{13,0,1,1,75,117},{14,1,1,1,75,117},{0,1,1,1,75,58},{0,1,1,1,75,66},{0,1,1,1,75,67},{0,1,1,1,75,68},{0,1,1,1,75,69},{0,1,1,1,75,70},{0,1,1,1,75,71},{0,1,1,1,75,72},{0,1,1,1,75,73},{0,1,1,1,75,74},{0,1,1,1,75,75},{0,1,1,1,75,76},{0,1,1,1,75,77},{0,1,1,1,75,78},{0,1,1,1,75,79},{0,1,1,1,75,80},{0,1,1,1,75,81},{0,1,1,1,75,82},{0,1,1,1,75,83},{0,1,1,1,75,84},{0,1,1,1,75,85},{0,1,1,1,75,86},{0,1,1,1,75,87},{0,1,1,1,75,89},{0,1,1,1,75,106},{0,1,1,1,75,107},{0,1,1,1,75,113},{0,1,1,1,75,118},{0,1,1,1,75,119},{0,1,1,1,75,120},{0,1,1,1,75,121},{0,1,1,1,75,122},{85,0,0,1,0,75},{86,0,0,1,0,75},{87,0,0,1,0,75},{88,1,0,1,0,75},{9,0,1,1,76,48},{10,0,1,1,76,48},{11,0,1,1,76,48},{12,1,1,1,76,48},{9,0,1,1,76,49},{10,0,1,1,76,49},{11,0,1,1,76,49},{12,1,1,1,76,49},{9,0,1,1,76,50},{10,0,1,1,76,50},{11,0,1,1,76,50},{12,1,1,1,76,50},{9,0,1,1,76,97},{10,0,1,1,76,97},{11,0,1,1,76,97},{12,1,1,1,76,97},{9,0,1,1,76,99},{10,0,1,1,76,99},{11,0,1,1,76,99},{12,1,1,1,76,99},{9,0,1,1,76,101},{10,0,1,1,76,101},{11,0,1,1,76,101},{12,1,1,1,76,101},{9,0,1,1,76,105},{10,0,1,1,76,105},{11,0,1,1,76,105},{12,1,1,1,76,105},{9,0,1,1,76,111},{10,0,1,1,76,111},{11,0,1,1,76,111},{12,1,1,1,76,111},{9,0,1,1,76,115},{10,0,1,1,76,115},{11,0,1,1,76,115},{12,1,1,1,76,115},{9,0,1,1,76,116},{10,0,1,1,76,116},{11,0,1,1,76,116},{12,1,1,1,76,116},{13,0,1,1,76,32},{14,1,1,1,76,32},{13,0,1,1,76,37},{14,1,1,1,76,37},{13,0,1,1,76,45},{14,1,1,1,76,45},{13,0,1,1,76,46},{14,1,1,1,76,46},{13,0,1,1,76,47},{14,1,1,1,76,47},{13,0,1,1,76,51},{14,1,1,1,76,51},{13,0,1,1,76,52},{14,1,1,1,76,52},{13,0,1,1,76,53},{14,1,1,1,76,53},{13,0,1,1,76,54},{14,1,1,1,76,54},{13,0,1,1,76,55},{14,1,1,1,76,55},{13,0,1,1,76,56},{14,1,1,1,76,56},{13,0,1,1,76,57},{14,1,1,1,76,57},{13,0,1,1,76,61},{14,1,1,1,76,61},{13,0,1,1,76,65},{14,1,1,1,76,65},{13,0,1,1,76,95},{14,1,1,1,76,95},{13,0,1,1,76,98},{14,1,1,1,76,98},{13,0,1,1,76,100},{14,1,1,1,76,100},{13,0,1,1,76,102},{14,1,1,1,76,102},{13,0,1,1,76,103},{14,1,1,1,76,103},{13,0,1,1,76,104},{14,1,1,1,76,104},{13,0,1,1,76,108},{14,1,1,1,76,108},{13,0,1,1,76,109},{14,1,1,1,76,109},{13,0,1,1,76,110},{14,1,1,1,76,110},{13,0,1,1,76,112},{14,1,1,1,76,112},{13,0,1,1,76,114},{14,1,1,1,76,114},{13,0,1,1,76,117},{14,1,1,1,76,117},{0,1,1,1,76,58},{0,1,1,1,76,66},{0,1,1,1,76,67},{0,1,1,1,76,68},{0,1,1,1,76,69},{0,1,1,1,76,70},{0,1,1,1,76,71},{0,1,1,1,76,72},{0,1,1,1,76,73},{0,1,1,1,76,74},{0,1,1,1,76,75},{0,1,1,1,76,76},{0,1,1,1,76,77},{0,1,1,1,76,78},{0,1,1,1,76,79},{0,1,1,1,76,80},{0,1,1,1,76,81},{0,1,1,1,76,82},{0,1,1,1,76,83},{0,1,1,1,76,84},{0,1,1,1,76,85},{0,1,1,1,76,86},{0,1,1,1,76,87},{0,1,1,1,76,89},{0,1,1,1,76,106},{0,1,1,1,76,107},{0,1,1,1,76,113},{0,1,1,1,76,118},{0,1,1,1,76,119},{0,1,1,1,76,120},{0,1,1,1,76,121},{0,1,1,1,76,122},{85,0,0,1,0,76},{86,0,0,1,0,76},{87,0,0,1,0,76},{88,1,0,1,0,76},{9,0,1,1,77,48},{10,0,1,1,77,48},{11,0,1,1,77,48},{12,1,1,1,77,48},{9,0,1,1,77,49},{10,0,1,1,77,49},{11,0,1,1,77,49},{12,1,1,1,77,49},{9,0,1,1,77,50},{10,0,1,1,77,50},{11,0,1,1,77,50},{12,1,1,1,77,50},{9,0,1,1,77,97},{10,0,1,1,77,97},{11,0,1,1,77,97},{12,1,1,1,77,97},{9,0,1,1,77,99},{10,0,1,1,77,99},{11,0,1,1,77,99},{12,1,1,1,77,99},{9,0,1,1,77,101},{10,0,1,1,77,101},{11,0,1,1,77,101},{12,1,1,1,77,101},{9,0,1,1,77,105},{10,0,1,1,77,105},{11,0,1,1,77,105},{12,1,1,1,77,105},{9,0,1,1,77,111},{10,0,1,1,77,111},{11,0,1,1,77,111},{12,1,1,1,77,111},{9,0,1,1,77,115},{10,0,1,1,77,115},{11,0,1,1,77,115},{12,1,1,1,77,115},{9,0,1,1,77,116},{10,0,1,1,77,116},{11,0,1,1,77,116},{12,1,1,1,77,116},{13,0,1,1,77,32},{14,1,1,1,77,32},{13,0,1,1,77,37},{14,1,1,1,77,37},{13,0,1,1,77,45},{14,1,1,1,77,45},{13,0,1,1,77,46},{14,1,1,1,77,46},{13,0,1,1,77,47},{14,1,1,1,77,47},{13,0,1,1,77,51},{14,1,1,1,77,51},{13,0,1,1,77,52},{14,1,1,1,77,52},{13,0,1,1,77,53},{14,1,1,1,77,53},{13,0,1,1,77,54},{14,1,1,1,77,54},{13,0,1,1,77,55},{14,1,1,1,77,55},{13,0,1,1,77,56},{14,1,1,1,77,56},{13,0,1,1,77,57},{14,1,1,1,77,57},{13,0,1,1,77,61},{14,1,1,1,77,61},{13,0,1,1,77,65},{14,1,1,1,77,65},{13,0,1,1,77,95},{14,1,1,1,77,95},{13,0,1,1,77,98},{14,1,1,1,77,98},{13,0,1,1,77,100},{14,1,1,1,77,100},{13,0,1,1,77,102},{14,1,1,1,77,102},{13,0,1,1,77,103},{14,1,1,1,77,103},{13,0,1,1,77,104},{14,1,1,1,77,104},{13,0,1,1,77,108},{14,1,1,1,77,108},{13,0,1,1,77,109},{14,1,1,1,77,109},{13,0,1,1,77,110},{14,1,1,1,77,110},{13,0,1,1,77,112},{14,1,1,1,77,112},{13,0,1,1,77,114},{14,1,1,1,77,114},{13,0,1,1,77,117},{14,1,1,1,77,117},{0,1,1,1,77,58},{0,1,1,1,77,66},{0,1,1,1,77,67},{0,1,1,1,77,68},{0,1,1,1,77,69},{0,1,1,1,77,70},{0,1,1,1,77,71},{0,1,1,1,77,72},{0,1,1,1,77,73},{0,1,1,1,77,74},{0,1,1,1,77,75},{0,1,1,1,77,76},{0,1,1,1,77,77},{0,1,1,1,77,78},{0,1,1,1,77,79},{0,1,1,1,77,80},{0,1,1,1,77,81},{0,1,1,1,77,82},{0,1,1,1,77,83},{0,1,1,1,77,84},{0,1,1,1,77,85},{0,1,1,1,77,86},{0,1,1,1,77,87},{0,1,1,1,77,89},{0,1,1,1,77,106},{0,1,1,1,77,107},{0,1,1,1,77,113},{0,1,1,1,77,118},{0,1,1,1,77,119},{0,1,1,1,77,120},{0,1,1,1,77,121},{0,1,1,1,77,122},{85,0,0,1,0,77},{86,0,0,1,0,77},{87,0,0,1,0,77},{88,1,0,1,0,77},{9,0,1,1,78,48},{10,0,1,1,78,48},{11,0,1,1,78,48},{12,1,1,1,78,48},{9,0,1,1,78,49},{10,0,1,1,78,49},{11,0,1,1,78,49},{12,1,1,1,78,49},{9,0,1,1,78,50},{10,0,1,1,78,50},{11,0,1,1,78,50},{12,1,1,1,78,50},{9,0,1,1,78,97},{10,0,1,1,78,97},{11,0,1,1,78,97},{12,1,1,1,78,97},{9,0,1,1,78,99},{10,0,1,1,78,99},{11,0,1,1,78,99},{12,1,1,1,78,99},{9,0,1,1,78,101},{10,0,1,1,78,101},{11,0,1,1,78,101},{12,1,1,1,78,101},{9,0,1,1,78,105},{10,0,1,1,78,105},{11,0,1,1,78,105},{12,1,1,1,78,105},{9,0,1,1,78,111},{10,0,1,1,78,111},{11,0,1,1,78,111},{12,1,1,1,78,111},{9,0,1,1,78,115},{10,0,1,1,78,115},{11,0,1,1,78,115},{12,1,1,1,78,115},{9,0,1,1,78,116},{10,0,1,1,78,116},{11,0,1,1,78,116},{12,1,1,1,78,116},{13,0,1,1,78,32},{14,1,1,1,78,32},{13,0,1,1,78,37},{14,1,1,1,78,37},{13,0,1,1,78,45},{14,1,1,1,78,45},{13,0,1,1,78,46},{14,1,1,1,78,46},{13,0,1,1,78,47},{14,1,1,1,78,47},{13,0,1,1,78,51},{14,1,1,1,78,51},{13,0,1,1,78,52},{14,1,1,1,78,52},{13,0,1,1,78,53},{14,1,1,1,78,53},{13,0,1,1,78,54},{14,1,1,1,78,54},{13,0,1,1,78,55},{14,1,1,1,78,55},{13,0,1,1,78,56},{14,1,1,1,78,56},{13,0,1,1,78,57},{14,1,1,1,78,57},{13,0,1,1,78,61},{14,1,1,1,78,61},{13,0,1,1,78,65},{14,1,1,1,78,65},{13,0,1,1,78,95},{14,1,1,1,78,95},{13,0,1,1,78,98},{14,1,1,1,78,98},{13,0,1,1,78,100},{14,1,1,1,78,100},{13,0,1,1,78,102},{14,1,1,1,78,102},{13,0,1,1,78,103},{14,1,1,1,78,103},{13,0,1,1,78,104},{14,1,1,1,78,104},{13,0,1,1,78,108},{14,1,1,1,78,108},{13,0,1,1,78,109},{14,1,1,1,78,109},{13,0,1,1,78,110},{14,1,1,1,78,110},{13,0,1,1,78,112},{14,1,1,1,78,112},{13,0,1,1,78,114},{14,1,1,1,78,114},{13,0,1,1,78,117},{14,1,1,1,78,117},{0,1,1,1,78,58},{0,1,1,1,78,66},{0,1,1,1,78,67},{0,1,1,1,78,68},{0,1,1,1,78,69},{0,1,1,1,78,70},{0,1,1,1,78,71},{0,1,1,1,78,72},{0,1,1,1,78,73},{0,1,1,1,78,74},{0,1,1,1,78,75},{0,1,1,1,78,76},{0,1,1,1,78,77},{0,1,1,1,78,78},{0,1,1,1,78,79},{0,1,1,1,78,80},{0,1,1,1,78,81},{0,1,1,1,78,82},{0,1,1,1,78,83},{0,1,1,1,78,84},{0,1,1,1,78,85},{0,1,1,1,78,86},{0,1,1,1,78,87},{0,1,1,1,78,89},{0,1,1,1,78,106},{0,1,1,1,78,107},{0,1,1,1,78,113},{0,1,1,1,78,118},{0,1,1,1,78,119},{0,1,1,1,78,120},{0,1,1,1,78,121},{0,1,1,1,78,122},{85,0,0,1,0,78},{86,0,0,1,0,78},{87,0,0,1,0,78},{88,1,0,1,0,78},{9,0,1,1,79,48},{10,0,1,1,79,48},{11,0,1,1,79,48},{12,1,1,1,79,48},{9,0,1,1,79,49},{10,0,1,1,79,49},{11,0,1,1,79,49},{12,1,1,1,79,49},{9,0,1,1,79,50},{10,0,1,1,79,50},{11,0,1,1,79,50},{12,1,1,1,79,50},{9,0,1,1,79,97},{10,0,1,1,79,97},{11,0,1,1,79,97},{12,1,1,1,79,97},{9,0,1,1,79,99},{10,0,1,1,79,99},{11,0,1,1,79,99},{12,1,1,1,79,99},{9,0,1,1,79,101},{10,0,1,1,79,101},{11,0,1,1,79,101},{12,1,1,1,79,101},{9,0,1,1,79,105},{10,0,1,1,79,105},{11,0,1,1,79,105},{12,1,1,1,79,105},{9,0,1,1,79,111},{10,0,1,1,79,111},{11,0,1,1,79,111},{12,1,1,1,79,111},{9,0,1,1,79,115},{10,0,1,1,79,115},{11,0,1,1,79,115},{12,1,1,1,79,115},{9,0,1,1,79,116},{10,0,1,1,79,116},{11,0,1,1,79,116},{12,1,1,1,79,116},{13,0,1,1,79,32},{14,1,1,1,79,32},{13,0,1,1,79,37},{14,1,1,1,79,37},{13,0,1,1,79,45},{14,1,1,1,79,45},{13,0,1,1,79,46},{14,1,1,1,79,46},{13,0,1,1,79,47},{14,1,1,1,79,47},{13,0,1,1,79,51},{14,1,1,1,79,51},{13,0,1,1,79,52},{14,1,1,1,79,52},{13,0,1,1,79,53},{14,1,1,1,79,53},{13,0,1,1,79,54},{14,1,1,1,79,54},{13,0,1,1,79,55},{14,1,1,1,79,55},{13,0,1,1,79,56},{14,1,1,1,79,56},{13,0,1,1,79,57},{14,1,1,1,79,57},{13,0,1,1,79,61},{14,1,1,1,79,61},{13,0,1,1,79,65},{14,1,1,1,79,65},{13,0,1,1,79,95},{14,1,1,1,79,95},{13,0,1,1,79,98},{14,1,1,1,79,98},{13,0,1,1,79,100},{14,1,1,1,79,100},{13,0,1,1,79,102},{14,1,1,1,79,102},{13,0,1,1,79,103},{14,1,1,1,79,103},{13,0,1,1,79,104},{14,1,1,1,79,104},{13,0,1,1,79,108},{14,1,1,1,79,108},{13,0,1,1,79,109},{14,1,1,1,79,109},{13,0,1,1,79,110},{14,1,1,1,79,110},{13,0,1,1,79,112},{14,1,1,1,79,112},{13,0,1,1,79,114},{14,1,1,1,79,114},{13,0,1,1,79,117},{14,1,1,1,79,117},{0,1,1,1,79,58},{0,1,1,1,79,66},{0,1,1,1,79,67},{0,1,1,1,79,68},{0,1,1,1,79,69},{0,1,1,1,79,70},{0,1,1,1,79,71},{0,1,1,1,79,72},{0,1,1,1,79,73},{0,1,1,1,79,74},{0,1,1,1,79,75},{0,1,1,1,79,76},{0,1,1,1,79,77},{0,1,1,1,79,78},{0,1,1,1,79,79},{0,1,1,1,79,80},{0,1,1,1,79,81},{0,1,1,1,79,82},{0,1,1,1,79,83},{0,1,1,1,79,84},{0,1,1,1,79,85},{0,1,1,1,79,86},{0,1,1,1,79,87},{0,1,1,1,79,89},{0,1,1,1,79,106},{0,1,1,1,79,107},{0,1,1,1,79,113},{0,1,1,1,79,118},{0,1,1,1,79,119},{0,1,1,1,79,120},{0,1,1,1,79,121},{0,1,1,1,79,122},{85,0,0,1,0,79},{86,0,0,1,0,79},{87,0,0,1,0,79},{88,1,0,1,0,79},{9,0,1,1,80,48},{10,0,1,1,80,48},{11,0,1,1,80,48},{12,1,1,1,80,48},{9,0,1,1,80,49},{10,0,1,1,80,49},{11,0,1,1,80,49},{12,1,1,1,80,49},{9,0,1,1,80,50},{10,0,1,1,80,50},{11,0,1,1,80,50},{12,1,1,1,80,50},{9,0,1,1,80,97},{10,0,1,1,80,97},{11,0,1,1,80,97},{12,1,1,1,80,97},{9,0,1,1,80,99},{10,0,1,1,80,99},{11,0,1,1,80,99},{12,1,1,1,80,99},{9,0,1,1,80,101},{10,0,1,1,80,101},{11,0,1,1,80,101},{12,1,1,1,80,101},{9,0,1,1,80,105},{10,0,1,1,80,105},{11,0,1,1,80,105},{12,1,1,1,80,105},{9,0,1,1,80,111},{10,0,1,1,80,111},{11,0,1,1,80,111},{12,1,1,1,80,111},{9,0,1,1,80,115},{10,0,1,1,80,115},{11,0,1,1,80,115},{12,1,1,1,80,115},{9,0,1,1,80,116},{10,0,1,1,80,116},{11,0,1,1,80,116},{12,1,1,1,80,116},{13,0,1,1,80,32},{14,1,1,1,80,32},{13,0,1,1,80,37},{14,1,1,1,80,37},{13,0,1,1,80,45},{14,1,1,1,80,45},{13,0,1,1,80,46},{14,1,1,1,80,46},{13,0,1,1,80,47},{14,1,1,1,80,47},{13,0,1,1,80,51},{14,1,1,1,80,51},{13,0,1,1,80,52},{14,1,1,1,80,52},{13,0,1,1,80,53},{14,1,1,1,80,53},{13,0,1,1,80,54},{14,1,1,1,80,54},{13,0,1,1,80,55},{14,1,1,1,80,55},{13,0,1,1,80,56},{14,1,1,1,80,56},{13,0,1,1,80,57},{14,1,1,1,80,57},{13,0,1,1,80,61},{14,1,1,1,80,61},{13,0,1,1,80,65},{14,1,1,1,80,65},{13,0,1,1,80,95},{14,1,1,1,80,95},{13,0,1,1,80,98},{14,1,1,1,80,98},{13,0,1,1,80,100},{14,1,1,1,80,100},{13,0,1,1,80,102},{14,1,1,1,80,102},{13,0,1,1,80,103},{14,1,1,1,80,103},{13,0,1,1,80,104},{14,1,1,1,80,104},{13,0,1,1,80,108},{14,1,1,1,80,108},{13,0,1,1,80,109},{14,1,1,1,80,109},{13,0,1,1,80,110},{14,1,1,1,80,110},{13,0,1,1,80,112},{14,1,1,1,80,112},{13,0,1,1,80,114},{14,1,1,1,80,114},{13,0,1,1,80,117},{14,1,1,1,80,117},{0,1,1,1,80,58},{0,1,1,1,80,66},{0,1,1,1,80,67},{0,1,1,1,80,68},{0,1,1,1,80,69},{0,1,1,1,80,70},{0,1,1,1,80,71},{0,1,1,1,80,72},{0,1,1,1,80,73},{0,1,1,1,80,74},{0,1,1,1,80,75},{0,1,1,1,80,76},{0,1,1,1,80,77},{0,1,1,1,80,78},{0,1,1,1,80,79},{0,1,1,1,80,80},{0,1,1,1,80,81},{0,1,1,1,80,82},{0,1,1,1,80,83},{0,1,1,1,80,84},{0,1,1,1,80,85},{0,1,1,1,80,86},{0,1,1,1,80,87},{0,1,1,1,80,89},{0,1,1,1,80,106},{0,1,1,1,80,107},{0,1,1,1,80,113},{0,1,1,1,80,118},{0,1,1,1,80,119},{0,1,1,1,80,120},{0,1,1,1,80,121},{0,1,1,1,80,122},{85,0,0,1,0,80},{86,0,0,1,0,80},{87,0,0,1,0,80},{88,1,0,1,0,80},{9,0,1,1,81,48},{10,0,1,1,81,48},{11,0,1,1,81,48},{12,1,1,1,81,48},{9,0,1,1,81,49},{10,0,1,1,81,49},{11,0,1,1,81,49},{12,1,1,1,81,49},{9,0,1,1,81,50},{10,0,1,1,81,50},{11,0,1,1,81,50},{12,1,1,1,81,50},{9,0,1,1,81,97},{10,0,1,1,81,97},{11,0,1,1,81,97},{12,1,1,1,81,97},{9,0,1,1,81,99},{10,0,1,1,81,99},{11,0,1,1,81,99},{12,1,1,1,81,99},{9,0,1,1,81,101},{10,0,1,1,81,101},{11,0,1,1,81,101},{12,1,1,1,81,101},{9,0,1,1,81,105},{10,0,1,1,81,105},{11,0,1,1,81,105},{12,1,1,1,81,105},{9,0,1,1,81,111},{10,0,1,1,81,111},{11,0,1,1,81,111},{12,1,1,1,81,111},{9,0,1,1,81,115},{10,0,1,1,81,115},{11,0,1,1,81,115},{12,1,1,1,81,115},{9,0,1,1,81,116},{10,0,1,1,81,116},{11,0,1,1,81,116},{12,1,1,1,81,116},{13,0,1,1,81,32},{14,1,1,1,81,32},{13,0,1,1,81,37},{14,1,1,1,81,37},{13,0,1,1,81,45},{14,1,1,1,81,45},{13,0,1,1,81,46},{14,1,1,1,81,46},{13,0,1,1,81,47},{14,1,1,1,81,47},{13,0,1,1,81,51},{14,1,1,1,81,51},{13,0,1,1,81,52},{14,1,1,1,81,52},{13,0,1,1,81,53},{14,1,1,1,81,53},{13,0,1,1,81,54},{14,1,1,1,81,54},{13,0,1,1,81,55},{14,1,1,1,81,55},{13,0,1,1,81,56},{14,1,1,1,81,56},{13,0,1,1,81,57},{14,1,1,1,81,57},{13,0,1,1,81,61},{14,1,1,1,81,61},{13,0,1,1,81,65},{14,1,1,1,81,65},{13,0,1,1,81,95},{14,1,1,1,81,95},{13,0,1,1,81,98},{14,1,1,1,81,98},{13,0,1,1,81,100},{14,1,1,1,81,100},{13,0,1,1,81,102},{14,1,1,1,81,102},{13,0,1,1,81,103},{14,1,1,1,81,103},{13,0,1,1,81,104},{14,1,1,1,81,104},{13,0,1,1,81,108},{14,1,1,1,81,108},{13,0,1,1,81,109},{14,1,1,1,81,109},{13,0,1,1,81,110},{14,1,1,1,81,110},{13,0,1,1,81,112},{14,1,1,1,81,112},{13,0,1,1,81,114},{14,1,1,1,81,114},{13,0,1,1,81,117},{14,1,1,1,81,117},{0,1,1,1,81,58},{0,1,1,1,81,66},{0,1,1,1,81,67},{0,1,1,1,81,68},{0,1,1,1,81,69},{0,1,1,1,81,70},{0,1,1,1,81,71},{0,1,1,1,81,72},{0,1,1,1,81,73},{0,1,1,1,81,74},{0,1,1,1,81,75},{0,1,1,1,81,76},{0,1,1,1,81,77},{0,1,1,1,81,78},{0,1,1,1,81,79},{0,1,1,1,81,80},{0,1,1,1,81,81},{0,1,1,1,81,82},{0,1,1,1,81,83},{0,1,1,1,81,84},{0,1,1,1,81,85},{0,1,1,1,81,86},{0,1,1,1,81,87},{0,1,1,1,81,89},{0,1,1,1,81,106},{0,1,1,1,81,107},{0,1,1,1,81,113},{0,1,1,1,81,118},{0,1,1,1,81,119},{0,1,1,1,81,120},{0,1,1,1,81,121},{0,1,1,1,81,122},{85,0,0,1,0,81},{86,0,0,1,0,81},{87,0,0,1,0,81},{88,1,0,1,0,81},{9,0,1,1,82,48},{10,0,1,1,82,48},{11,0,1,1,82,48},{12,1,1,1,82,48},{9,0,1,1,82,49},{10,0,1,1,82,49},{11,0,1,1,82,49},{12,1,1,1,82,49},{9,0,1,1,82,50},{10,0,1,1,82,50},{11,0,1,1,82,50},{12,1,1,1,82,50},{9,0,1,1,82,97},{10,0,1,1,82,97},{11,0,1,1,82,97},{12,1,1,1,82,97},{9,0,1,1,82,99},{10,0,1,1,82,99},{11,0,1,1,82,99},{12,1,1,1,82,99},{9,0,1,1,82,101},{10,0,1,1,82,101},{11,0,1,1,82,101},{12,1,1,1,82,101},{9,0,1,1,82,105},{10,0,1,1,82,105},{11,0,1,1,82,105},{12,1,1,1,82,105},{9,0,1,1,82,111},{10,0,1,1,82,111},{11,0,1,1,82,111},{12,1,1,1,82,111},{9,0,1,1,82,115},{10,0,1,1,82,115},{11,0,1,1,82,115},{12,1,1,1,82,115},{9,0,1,1,82,116},{10,0,1,1,82,116},{11,0,1,1,82,116},{12,1,1,1,82,116},{13,0,1,1,82,32},{14,1,1,1,82,32},{13,0,1,1,82,37},{14,1,1,1,82,37},{13,0,1,1,82,45},{14,1,1,1,82,45},{13,0,1,1,82,46},{14,1,1,1,82,46},{13,0,1,1,82,47},{14,1,1,1,82,47},{13,0,1,1,82,51},{14,1,1,1,82,51},{13,0,1,1,82,52},{14,1,1,1,82,52},{13,0,1,1,82,53},{14,1,1,1,82,53},{13,0,1,1,82,54},{14,1,1,1,82,54},{13,0,1,1,82,55},{14,1,1,1,82,55},{13,0,1,1,82,56},{14,1,1,1,82,56},{13,0,1,1,82,57},{14,1,1,1,82,57},{13,0,1,1,82,61},{14,1,1,1,82,61},{13,0,1,1,82,65},{14,1,1,1,82,65},{13,0,1,1,82,95},{14,1,1,1,82,95},{13,0,1,1,82,98},{14,1,1,1,82,98},{13,0,1,1,82,100},{14,1,1,1,82,100},{13,0,1,1,82,102},{14,1,1,1,82,102},{13,0,1,1,82,103},{14,1,1,1,82,103},{13,0,1,1,82,104},{14,1,1,1,82,104},{13,0,1,1,82,108},{14,1,1,1,82,108},{13,0,1,1,82,109},{14,1,1,1,82,109},{13,0,1,1,82,110},{14,1,1,1,82,110},{13,0,1,1,82,112},{14,1,1,1,82,112},{13,0,1,1,82,114},{14,1,1,1,82,114},{13,0,1,1,82,117},{14,1,1,1,82,117},{0,1,1,1,82,58},{0,1,1,1,82,66},{0,1,1,1,82,67},{0,1,1,1,82,68},{0,1,1,1,82,69},{0,1,1,1,82,70},{0,1,1,1,82,71},{0,1,1,1,82,72},{0,1,1,1,82,73},{0,1,1,1,82,74},{0,1,1,1,82,75},{0,1,1,1,82,76},{0,1,1,1,82,77},{0,1,1,1,82,78},{0,1,1,1,82,79},{0,1,1,1,82,80},{0,1,1,1,82,81},{0,1,1,1,82,82},{0,1,1,1,82,83},{0,1,1,1,82,84},{0,1,1,1,82,85},{0,1,1,1,82,86},{0,1,1,1,82,87},{0,1,1,1,82,89},{0,1,1,1,82,106},{0,1,1,1,82,107},{0,1,1,1,82,113},{0,1,1,1,82,118},{0,1,1,1,82,119},{0,1,1,1,82,120},{0,1,1,1,82,121},{0,1,1,1,82,122},{85,0,0,1,0,82},{86,0,0,1,0,82},{87,0,0,1,0,82},{88,1,0,1,0,82},{9,0,1,1,83,48},{10,0,1,1,83,48},{11,0,1,1,83,48},{12,1,1,1,83,48},{9,0,1,1,83,49},{10,0,1,1,83,49},{11,0,1,1,83,49},{12,1,1,1,83,49},{9,0,1,1,83,50},{10,0,1,1,83,50},{11,0,1,1,83,50},{12,1,1,1,83,50},{9,0,1,1,83,97},{10,0,1,1,83,97},{11,0,1,1,83,97},{12,1,1,1,83,97},{9,0,1,1,83,99},{10,0,1,1,83,99},{11,0,1,1,83,99},{12,1,1,1,83,99},{9,0,1,1,83,101},{10,0,1,1,83,101},{11,0,1,1,83,101},{12,1,1,1,83,101},{9,0,1,1,83,105},{10,0,1,1,83,105},{11,0,1,1,83,105},{12,1,1,1,83,105},{9,0,1,1,83,111},{10,0,1,1,83,111},{11,0,1,1,83,111},{12,1,1,1,83,111},{9,0,1,1,83,115},{10,0,1,1,83,115},{11,0,1,1,83,115},{12,1,1,1,83,115},{9,0,1,1,83,116},{10,0,1,1,83,116},{11,0,1,1,83,116},{12,1,1,1,83,116},{13,0,1,1,83,32},{14,1,1,1,83,32},{13,0,1,1,83,37},{14,1,1,1,83,37},{13,0,1,1,83,45},{14,1,1,1,83,45},{13,0,1,1,83,46},{14,1,1,1,83,46},{13,0,1,1,83,47},{14,1,1,1,83,47},{13,0,1,1,83,51},{14,1,1,1,83,51},{13,0,1,1,83,52},{14,1,1,1,83,52},{13,0,1,1,83,53},{14,1,1,1,83,53},{13,0,1,1,83,54},{14,1,1,1,83,54},{13,0,1,1,83,55},{14,1,1,1,83,55},{13,0,1,1,83,56},{14,1,1,1,83,56},{13,0,1,1,83,57},{14,1,1,1,83,57},{13,0,1,1,83,61},{14,1,1,1,83,61},{13,0,1,1,83,65},{14,1,1,1,83,65},{13,0,1,1,83,95},{14,1,1,1,83,95},{13,0,1,1,83,98},{14,1,1,1,83,98},{13,0,1,1,83,100},{14,1,1,1,83,100},{13,0,1,1,83,102},{14,1,1,1,83,102},{13,0,1,1,83,103},{14,1,1,1,83,103},{13,0,1,1,83,104},{14,1,1,1,83,104},{13,0,1,1,83,108},{14,1,1,1,83,108},{13,0,1,1,83,109},{14,1,1,1,83,109},{13,0,1,1,83,110},{14,1,1,1,83,110},{13,0,1,1,83,112},{14,1,1,1,83,112},{13,0,1,1,83,114},{14,1,1,1,83,114},{13,0,1,1,83,117},{14,1,1,1,83,117},{0,1,1,1,83,58},{0,1,1,1,83,66},{0,1,1,1,83,67},{0,1,1,1,83,68},{0,1,1,1,83,69},{0,1,1,1,83,70},{0,1,1,1,83,71},{0,1,1,1,83,72},{0,1,1,1,83,73},{0,1,1,1,83,74},{0,1,1,1,83,75},{0,1,1,1,83,76},{0,1,1,1,83,77},{0,1,1,1,83,78},{0,1,1,1,83,79},{0,1,1,1,83,80},{0,1,1,1,83,81},{0,1,1,1,83,82},{0,1,1,1,83,83},{0,1,1,1,83,84},{0,1,1,1,83,85},{0,1,1,1,83,86},{0,1,1,1,83,87},{0,1,1,1,83,89},{0,1,1,1,83,106},{0,1,1,1,83,107},{0,1,1,1,83,113},{0,1,1,1,83,118},{0,1,1,1,83,119},{0,1,1,1,83,120},{0,1,1,1,83,121},{0,1,1,1,83,122},{85,0,0,1,0,83},{86,0,0,1,0,83},{87,0,0,1,0,83},{88,1,0,1,0,83},{9,0,1,1,84,48},{10,0,1,1,84,48},{11,0,1,1,84,48},{12,1,1,1,84,48},{9,0,1,1,84,49},{10,0,1,1,84,49},{11,0,1,1,84,49},{12,1,1,1,84,49},{9,0,1,1,84,50},{10,0,1,1,84,50},{11,0,1,1,84,50},{12,1,1,1,84,50},{9,0,1,1,84,97},{10,0,1,1,84,97},{11,0,1,1,84,97},{12,1,1,1,84,97},{9,0,1,1,84,99},{10,0,1,1,84,99},{11,0,1,1,84,99},{12,1,1,1,84,99},{9,0,1,1,84,101},{10,0,1,1,84,101},{11,0,1,1,84,101},{12,1,1,1,84,101},{9,0,1,1,84,105},{10,0,1,1,84,105},{11,0,1,1,84,105},{12,1,1,1,84,105},{9,0,1,1,84,111},{10,0,1,1,84,111},{11,0,1,1,84,111},{12,1,1,1,84,111},{9,0,1,1,84,115},{10,0,1,1,84,115},{11,0,1,1,84,115},{12,1,1,1,84,115},{9,0,1,1,84,116},{10,0,1,1,84,116},{11,0,1,1,84,116},{12,1,1,1,84,116},{13,0,1,1,84,32},{14,1,1,1,84,32},{13,0,1,1,84,37},{14,1,1,1,84,37},{13,0,1,1,84,45},{14,1,1,1,84,45},{13,0,1,1,84,46},{14,1,1,1,84,46},{13,0,1,1,84,47},{14,1,1,1,84,47},{13,0,1,1,84,51},{14,1,1,1,84,51},{13,0,1,1,84,52},{14,1,1,1,84,52},{13,0,1,1,84,53},{14,1,1,1,84,53},{13,0,1,1,84,54},{14,1,1,1,84,54},{13,0,1,1,84,55},{14,1,1,1,84,55},{13,0,1,1,84,56},{14,1,1,1,84,56},{13,0,1,1,84,57},{14,1,1,1,84,57},{13,0,1,1,84,61},{14,1,1,1,84,61},{13,0,1,1,84,65},{14,1,1,1,84,65},{13,0,1,1,84,95},{14,1,1,1,84,95},{13,0,1,1,84,98},{14,1,1,1,84,98},{13,0,1,1,84,100},{14,1,1,1,84,100},{13,0,1,1,84,102},{14,1,1,1,84,102},{13,0,1,1,84,103},{14,1,1,1,84,103},{13,0,1,1,84,104},{14,1,1,1,84,104},{13,0,1,1,84,108},{14,1,1,1,84,108},{13,0,1,1,84,109},{14,1,1,1,84,109},{13,0,1,1,84,110},{14,1,1,1,84,110},{13,0,1,1,84,112},{14,1,1,1,84,112},{13,0,1,1,84,114},{14,1,1,1,84,114},{13,0,1,1,84,117},{14,1,1,1,84,117},{0,1,1,1,84,58},{0,1,1,1,84,66},{0,1,1,1,84,67},{0,1,1,1,84,68},{0,1,1,1,84,69},{0,1,1,1,84,70},{0,1,1,1,84,71},{0,1,1,1,84,72},{0,1,1,1,84,73},{0,1,1,1,84,74},{0,1,1,1,84,75},{0,1,1,1,84,76},{0,1,1,1,84,77},{0,1,1,1,84,78},{0,1,1,1,84,79},{0,1,1,1,84,80},{0,1,1,1,84,81},{0,1,1,1,84,82},{0,1,1,1,84,83},{0,1,1,1,84,84},{0,1,1,1,84,85},{0,1,1,1,84,86},{0,1,1,1,84,87},{0,1,1,1,84,89},{0,1,1,1,84,106},{0,1,1,1,84,107},{0,1,1,1,84,113},{0,1,1,1,84,118},{0,1,1,1,84,119},{0,1,1,1,84,120},{0,1,1,1,84,121},{0,1,1,1,84,122},{85,0,0,1,0,84},{86,0,0,1,0,84},{87,0,0,1,0,84},{88,1,0,1,0,84},{9,0,1,1,85,48},{10,0,1,1,85,48},{11,0,1,1,85,48},{12,1,1,1,85,48},{9,0,1,1,85,49},{10,0,1,1,85,49},{11,0,1,1,85,49},{12,1,1,1,85,49},{9,0,1,1,85,50},{10,0,1,1,85,50},{11,0,1,1,85,50},{12,1,1,1,85,50},{9,0,1,1,85,97},{10,0,1,1,85,97},{11,0,1,1,85,97},{12,1,1,1,85,97},{9,0,1,1,85,99},{10,0,1,1,85,99},{11,0,1,1,85,99},{12,1,1,1,85,99},{9,0,1,1,85,101},{10,0,1,1,85,101},{11,0,1,1,85,101},{12,1,1,1,85,101},{9,0,1,1,85,105},{10,0,1,1,85,105},{11,0,1,1,85,105},{12,1,1,1,85,105},{9,0,1,1,85,111},{10,0,1,1,85,111},{11,0,1,1,85,111},{12,1,1,1,85,111},{9,0,1,1,85,115},{10,0,1,1,85,115},{11,0,1,1,85,115},{12,1,1,1,85,115},{9,0,1,1,85,116},{10,0,1,1,85,116},{11,0,1,1,85,116},{12,1,1,1,85,116},{13,0,1,1,85,32},{14,1,1,1,85,32},{13,0,1,1,85,37},{14,1,1,1,85,37},{13,0,1,1,85,45},{14,1,1,1,85,45},{13,0,1,1,85,46},{14,1,1,1,85,46},{13,0,1,1,85,47},{14,1,1,1,85,47},{13,0,1,1,85,51},{14,1,1,1,85,51},{13,0,1,1,85,52},{14,1,1,1,85,52},{13,0,1,1,85,53},{14,1,1,1,85,53},{13,0,1,1,85,54},{14,1,1,1,85,54},{13,0,1,1,85,55},{14,1,1,1,85,55},{13,0,1,1,85,56},{14,1,1,1,85,56},{13,0,1,1,85,57},{14,1,1,1,85,57},{13,0,1,1,85,61},{14,1,1,1,85,61},{13,0,1,1,85,65},{14,1,1,1,85,65},{13,0,1,1,85,95},{14,1,1,1,85,95},{13,0,1,1,85,98},{14,1,1,1,85,98},{13,0,1,1,85,100},{14,1,1,1,85,100},{13,0,1,1,85,102},{14,1,1,1,85,102},{13,0,1,1,85,103},{14,1,1,1,85,103},{13,0,1,1,85,104},{14,1,1,1,85,104},{13,0,1,1,85,108},{14,1,1,1,85,108},{13,0,1,1,85,109},{14,1,1,1,85,109},{13,0,1,1,85,110},{14,1,1,1,85,110},{13,0,1,1,85,112},{14,1,1,1,85,112},{13,0,1,1,85,114},{14,1,1,1,85,114},{13,0,1,1,85,117},{14,1,1,1,85,117},{0,1,1,1,85,58},{0,1,1,1,85,66},{0,1,1,1,85,67},{0,1,1,1,85,68},{0,1,1,1,85,69},{0,1,1,1,85,70},{0,1,1,1,85,71},{0,1,1,1,85,72},{0,1,1,1,85,73},{0,1,1,1,85,74},{0,1,1,1,85,75},{0,1,1,1,85,76},{0,1,1,1,85,77},{0,1,1,1,85,78},{0,1,1,1,85,79},{0,1,1,1,85,80},{0,1,1,1,85,81},{0,1,1,1,85,82},{0,1,1,1,85,83},{0,1,1,1,85,84},{0,1,1,1,85,85},{0,1,1,1,85,86},{0,1,1,1,85,87},{0,1,1,1,85,89},{0,1,1,1,85,106},{0,1,1,1,85,107},{0,1,1,1,85,113},{0,1,1,1,85,118},{0,1,1,1,85,119},{0,1,1,1,85,120},{0,1,1,1,85,121},{0,1,1,1,85,122},{85,0,0,1,0,85},{86,0,0,1,0,85},{87,0,0,1,0,85},{88,1,0,1,0,85},{9,0,1,1,86,48},{10,0,1,1,86,48},{11,0,1,1,86,48},{12,1,1,1,86,48},{9,0,1,1,86,49},{10,0,1,1,86,49},{11,0,1,1,86,49},{12,1,1,1,86,49},{9,0,1,1,86,50},{10,0,1,1,86,50},{11,0,1,1,86,50},{12,1,1,1,86,50},{9,0,1,1,86,97},{10,0,1,1,86,97},{11,0,1,1,86,97},{12,1,1,1,86,97},{9,0,1,1,86,99},{10,0,1,1,86,99},{11,0,1,1,86,99},{12,1,1,1,86,99},{9,0,1,1,86,101},{10,0,1,1,86,101},{11,0,1,1,86,101},{12,1,1,1,86,101},{9,0,1,1,86,105},{10,0,1,1,86,105},{11,0,1,1,86,105},{12,1,1,1,86,105},{9,0,1,1,86,111},{10,0,1,1,86,111},{11,0,1,1,86,111},{12,1,1,1,86,111},{9,0,1,1,86,115},{10,0,1,1,86,115},{11,0,1,1,86,115},{12,1,1,1,86,115},{9,0,1,1,86,116},{10,0,1,1,86,116},{11,0,1,1,86,116},{12,1,1,1,86,116},{13,0,1,1,86,32},{14,1,1,1,86,32},{13,0,1,1,86,37},{14,1,1,1,86,37},{13,0,1,1,86,45},{14,1,1,1,86,45},{13,0,1,1,86,46},{14,1,1,1,86,46},{13,0,1,1,86,47},{14,1,1,1,86,47},{13,0,1,1,86,51},{14,1,1,1,86,51},{13,0,1,1,86,52},{14,1,1,1,86,52},{13,0,1,1,86,53},{14,1,1,1,86,53},{13,0,1,1,86,54},{14,1,1,1,86,54},{13,0,1,1,86,55},{14,1,1,1,86,55},{13,0,1,1,86,56},{14,1,1,1,86,56},{13,0,1,1,86,57},{14,1,1,1,86,57},{13,0,1,1,86,61},{14,1,1,1,86,61},{13,0,1,1,86,65},{14,1,1,1,86,65},{13,0,1,1,86,95},{14,1,1,1,86,95},{13,0,1,1,86,98},{14,1,1,1,86,98},{13,0,1,1,86,100},{14,1,1,1,86,100},{13,0,1,1,86,102},{14,1,1,1,86,102},{13,0,1,1,86,103},{14,1,1,1,86,103},{13,0,1,1,86,104},{14,1,1,1,86,104},{13,0,1,1,86,108},{14,1,1,1,86,108},{13,0,1,1,86,109},{14,1,1,1,86,109},{13,0,1,1,86,110},{14,1,1,1,86,110},{13,0,1,1,86,112},{14,1,1,1,86,112},{13,0,1,1,86,114},{14,1,1,1,86,114},{13,0,1,1,86,117},{14,1,1,1,86,117},{0,1,1,1,86,58},{0,1,1,1,86,66},{0,1,1,1,86,67},{0,1,1,1,86,68},{0,1,1,1,86,69},{0,1,1,1,86,70},{0,1,1,1,86,71},{0,1,1,1,86,72},{0,1,1,1,86,73},{0,1,1,1,86,74},{0,1,1,1,86,75},{0,1,1,1,86,76},{0,1,1,1,86,77},{0,1,1,1,86,78},{0,1,1,1,86,79},{0,1,1,1,86,80},{0,1,1,1,86,81},{0,1,1,1,86,82},{0,1,1,1,86,83},{0,1,1,1,86,84},{0,1,1,1,86,85},{0,1,1,1,86,86},{0,1,1,1,86,87},{0,1,1,1,86,89},{0,1,1,1,86,106},{0,1,1,1,86,107},{0,1,1,1,86,113},{0,1,1,1,86,118},{0,1,1,1,86,119},{0,1,1,1,86,120},{0,1,1,1,86,121},{0,1,1,1,86,122},{85,0,0,1,0,86},{86,0,0,1,0,86},{87,0,0,1,0,86},{88,1,0,1,0,86},{9,0,1,1,87,48},{10,0,1,1,87,48},{11,0,1,1,87,48},{12,1,1,1,87,48},{9,0,1,1,87,49},{10,0,1,1,87,49},{11,0,1,1,87,49},{12,1,1,1,87,49},{9,0,1,1,87,50},{10,0,1,1,87,50},{11,0,1,1,87,50},{12,1,1,1,87,50},{9,0,1,1,87,97},{10,0,1,1,87,97},{11,0,1,1,87,97},{12,1,1,1,87,97},{9,0,1,1,87,99},{10,0,1,1,87,99},{11,0,1,1,87,99},{12,1,1,1,87,99},{9,0,1,1,87,101},{10,0,1,1,87,101},{11,0,1,1,87,101},{12,1,1,1,87,101},{9,0,1,1,87,105},{10,0,1,1,87,105},{11,0,1,1,87,105},{12,1,1,1,87,105},{9,0,1,1,87,111},{10,0,1,1,87,111},{11,0,1,1,87,111},{12,1,1,1,87,111},{9,0,1,1,87,115},{10,0,1,1,87,115},{11,0,1,1,87,115},{12,1,1,1,87,115},{9,0,1,1,87,116},{10,0,1,1,87,116},{11,0,1,1,87,116},{12,1,1,1,87,116},{13,0,1,1,87,32},{14,1,1,1,87,32},{13,0,1,1,87,37},{14,1,1,1,87,37},{13,0,1,1,87,45},{14,1,1,1,87,45},{13,0,1,1,87,46},{14,1,1,1,87,46},{13,0,1,1,87,47},{14,1,1,1,87,47},{13,0,1,1,87,51},{14,1,1,1,87,51},{13,0,1,1,87,52},{14,1,1,1,87,52},{13,0,1,1,87,53},{14,1,1,1,87,53},{13,0,1,1,87,54},{14,1,1,1,87,54},{13,0,1,1,87,55},{14,1,1,1,87,55},{13,0,1,1,87,56},{14,1,1,1,87,56},{13,0,1,1,87,57},{14,1,1,1,87,57},{13,0,1,1,87,61},{14,1,1,1,87,61},{13,0,1,1,87,65},{14,1,1,1,87,65},{13,0,1,1,87,95},{14,1,1,1,87,95},{13,0,1,1,87,98},{14,1,1,1,87,98},{13,0,1,1,87,100},{14,1,1,1,87,100},{13,0,1,1,87,102},{14,1,1,1,87,102},{13,0,1,1,87,103},{14,1,1,1,87,103},{13,0,1,1,87,104},{14,1,1,1,87,104},{13,0,1,1,87,108},{14,1,1,1,87,108},{13,0,1,1,87,109},{14,1,1,1,87,109},{13,0,1,1,87,110},{14,1,1,1,87,110},{13,0,1,1,87,112},{14,1,1,1,87,112},{13,0,1,1,87,114},{14,1,1,1,87,114},{13,0,1,1,87,117},{14,1,1,1,87,117},{0,1,1,1,87,58},{0,1,1,1,87,66},{0,1,1,1,87,67},{0,1,1,1,87,68},{0,1,1,1,87,69},{0,1,1,1,87,70},{0,1,1,1,87,71},{0,1,1,1,87,72},{0,1,1,1,87,73},{0,1,1,1,87,74},{0,1,1,1,87,75},{0,1,1,1,87,76},{0,1,1,1,87,77},{0,1,1,1,87,78},{0,1,1,1,87,79},{0,1,1,1,87,80},{0,1,1,1,87,81},{0,1,1,1,87,82},{0,1,1,1,87,83},{0,1,1,1,87,84},{0,1,1,1,87,85},{0,1,1,1,87,86},{0,1,1,1,87,87},{0,1,1,1,87,89},{0,1,1,1,87,106},{0,1,1,1,87,107},{0,1,1,1,87,113},{0,1,1,1,87,118},{0,1,1,1,87,119},{0,1,1,1,87,120},{0,1,1,1,87,121},{0,1,1,1,87,122},{85,0,0,1,0,87},{86,0,0,1,0,87},{87,0,0,1,0,87},{88,1,0,1,0,87},{9,0,1,1,89,48},{10,0,1,1,89,48},{11,0,1,1,89,48},{12,1,1,1,89,48},{9,0,1,1,89,49},{10,0,1,1,89,49},{11,0,1,1,89,49},{12,1,1,1,89,49},{9,0,1,1,89,50},{10,0,1,1,89,50},{11,0,1,1,89,50},{12,1,1,1,89,50},{9,0,1,1,89,97},{10,0,1,1,89,97},{11,0,1,1,89,97},{12,1,1,1,89,97},{9,0,1,1,89,99},{10,0,1,1,89,99},{11,0,1,1,89,99},{12,1,1,1,89,99},{9,0,1,1,89,101},{10,0,1,1,89,101},{11,0,1,1,89,101},{12,1,1,1,89,101},{9,0,1,1,89,105},{10,0,1,1,89,105},{11,0,1,1,89,105},{12,1,1,1,89,105},{9,0,1,1,89,111},{10,0,1,1,89,111},{11,0,1,1,89,111},{12,1,1,1,89,111},{9,0,1,1,89,115},{10,0,1,1,89,115},{11,0,1,1,89,115},{12,1,1,1,89,115},{9,0,1,1,89,116},{10,0,1,1,89,116},{11,0,1,1,89,116},{12,1,1,1,89,116},{13,0,1,1,89,32},{14,1,1,1,89,32},{13,0,1,1,89,37},{14,1,1,1,89,37},{13,0,1,1,89,45},{14,1,1,1,89,45},{13,0,1,1,89,46},{14,1,1,1,89,46},{13,0,1,1,89,47},{14,1,1,1,89,47},{13,0,1,1,89,51},{14,1,1,1,89,51},{13,0,1,1,89,52},{14,1,1,1,89,52},{13,0,1,1,89,53},{14,1,1,1,89,53},{13,0,1,1,89,54},{14,1,1,1,89,54},{13,0,1,1,89,55},{14,1,1,1,89,55},{13,0,1,1,89,56},{14,1,1,1,89,56},{13,0,1,1,89,57},{14,1,1,1,89,57},{13,0,1,1,89,61},{14,1,1,1,89,61},{13,0,1,1,89,65},{14,1,1,1,89,65},{13,0,1,1,89,95},{14,1,1,1,89,95},{13,0,1,1,89,98},{14,1,1,1,89,98},{13,0,1,1,89,100},{14,1,1,1,89,100},{13,0,1,1,89,102},{14,1,1,1,89,102},{13,0,1,1,89,103},{14,1,1,1,89,103},{13,0,1,1,89,104},{14,1,1,1,89,104},{13,0,1,1,89,108},{14,1,1,1,89,108},{13,0,1,1,89,109},{14,1,1,1,89,109},{13,0,1,1,89,110},{14,1,1,1,89,110},{13,0,1,1,89,112},{14,1,1,1,89,112},{13,0,1,1,89,114},{14,1,1,1,89,114},{13,0,1,1,89,117},{14,1,1,1,89,117},{0,1,1,1,89,58},{0,1,1,1,89,66},{0,1,1,1,89,67},{0,1,1,1,89,68},{0,1,1,1,89,69},{0,1,1,1,89,70},{0,1,1,1,89,71},{0,1,1,1,89,72},{0,1,1,1,89,73},{0,1,1,1,89,74},{0,1,1,1,89,75},{0,1,1,1,89,76},{0,1,1,1,89,77},{0,1,1,1,89,78},{0,1,1,1,89,79},{0,1,1,1,89,80},{0,1,1,1,89,81},{0,1,1,1,89,82},{0,1,1,1,89,83},{0,1,1,1,89,84},{0,1,1,1,89,85},{0,1,1,1,89,86},{0,1,1,1,89,87},{0,1,1,1,89,89},{0,1,1,1,89,106},{0,1,1,1,89,107},{0,1,1,1,89,113},{0,1,1,1,89,118},{0,1,1,1,89,119},{0,1,1,1,89,120},{0,1,1,1,89,121},{0,1,1,1,89,122},{85,0,0,1,0,89},{86,0,0,1,0,89},{87,0,0,1,0,89},{88,1,0,1,0,89},{9,0,1,1,106,48},{10,0,1,1,106,48},{11,0,1,1,106,48},{12,1,1,1,106,48},{9,0,1,1,106,49},{10,0,1,1,106,49},{11,0,1,1,106,49},{12,1,1,1,106,49},{9,0,1,1,106,50},{10,0,1,1,106,50},{11,0,1,1,106,50},{12,1,1,1,106,50},{9,0,1,1,106,97},{10,0,1,1,106,97},{11,0,1,1,106,97},{12,1,1,1,106,97},{9,0,1,1,106,99},{10,0,1,1,106,99},{11,0,1,1,106,99},{12,1,1,1,106,99},{9,0,1,1,106,101},{10,0,1,1,106,101},{11,0,1,1,106,101},{12,1,1,1,106,101},{9,0,1,1,106,105},{10,0,1,1,106,105},{11,0,1,1,106,105},{12,1,1,1,106,105},{9,0,1,1,106,111},{10,0,1,1,106,111},{11,0,1,1,106,111},{12,1,1,1,106,111},{9,0,1,1,106,115},{10,0,1,1,106,115},{11,0,1,1,106,115},{12,1,1,1,106,115},{9,0,1,1,106,116},{10,0,1,1,106,116},{11,0,1,1,106,116},{12,1,1,1,106,116},{13,0,1,1,106,32},{14,1,1,1,106,32},{13,0,1,1,106,37},{14,1,1,1,106,37},{13,0,1,1,106,45},{14,1,1,1,106,45},{13,0,1,1,106,46},{14,1,1,1,106,46},{13,0,1,1,106,47},{14,1,1,1,106,47},{13,0,1,1,106,51},{14,1,1,1,106,51},{13,0,1,1,106,52},{14,1,1,1,106,52},{13,0,1,1,106,53},{14,1,1,1,106,53},{13,0,1,1,106,54},{14,1,1,1,106,54},{13,0,1,1,106,55},{14,1,1,1,106,55},{13,0,1,1,106,56},{14,1,1,1,106,56},{13,0,1,1,106,57},{14,1,1,1,106,57},{13,0,1,1,106,61},{14,1,1,1,106,61},{13,0,1,1,106,65},{14,1,1,1,106,65},{13,0,1,1,106,95},{14,1,1,1,106,95},{13,0,1,1,106,98},{14,1,1,1,106,98},{13,0,1,1,106,100},{14,1,1,1,106,100},{13,0,1,1,106,102},{14,1,1,1,106,102},{13,0,1,1,106,103},{14,1,1,1,106,103},{13,0,1,1,106,104},{14,1,1,1,106,104},{13,0,1,1,106,108},{14,1,1,1,106,108},{13,0,1,1,106,109},{14,1,1,1,106,109},{13,0,1,1,106,110},{14,1,1,1,106,110},{13,0,1,1,106,112},{14,1,1,1,106,112},{13,0,1,1,106,114},{14,1,1,1,106,114},{13,0,1,1,106,117},{14,1,1,1,106,117},{0,1,1,1,106,58},{0,1,1,1,106,66},{0,1,1,1,106,67},{0,1,1,1,106,68},{0,1,1,1,106,69},{0,1,1,1,106,70},{0,1,1,1,106,71},{0,1,1,1,106,72},{0,1,1,1,106,73},{0,1,1,1,106,74},{0,1,1,1,106,75},{0,1,1,1,106,76},{0,1,1,1,106,77},{0,1,1,1,106,78},{0,1,1,1,106,79},{0,1,1,1,106,80},{0,1,1,1,106,81},{0,1,1,1,106,82},{0,1,1,1,106,83},{0,1,1,1,106,84},{0,1,1,1,106,85},{0,1,1,1,106,86},{0,1,1,1,106,87},{0,1,1,1,106,89},{0,1,1,1,106,106},{0,1,1,1,106,107},{0,1,1,1,106,113},{0,1,1,1,106,118},{0,1,1,1,106,119},{0,1,1,1,106,120},{0,1,1,1,106,121},{0,1,1,1,106,122},{85,0,0,1,0,106},{86,0,0,1,0,106},{87,0,0,1,0,106},{88,1,0,1,0,106},{9,0,1,1,107,48},{10,0,1,1,107,48},{11,0,1,1,107,48},{12,1,1,1,107,48},{9,0,1,1,107,49},{10,0,1,1,107,49},{11,0,1,1,107,49},{12,1,1,1,107,49},{9,0,1,1,107,50},{10,0,1,1,107,50},{11,0,1,1,107,50},{12,1,1,1,107,50},{9,0,1,1,107,97},{10,0,1,1,107,97},{11,0,1,1,107,97},{12,1,1,1,107,97},{9,0,1,1,107,99},{10,0,1,1,107,99},{11,0,1,1,107,99},{12,1,1,1,107,99},{9,0,1,1,107,101},{10,0,1,1,107,101},{11,0,1,1,107,101},{12,1,1,1,107,101},{9,0,1,1,107,105},{10,0,1,1,107,105},{11,0,1,1,107,105},{12,1,1,1,107,105},{9,0,1,1,107,111},{10,0,1,1,107,111},{11,0,1,1,107,111},{12,1,1,1,107,111},{9,0,1,1,107,115},{10,0,1,1,107,115},{11,0,1,1,107,115},{12,1,1,1,107,115},{9,0,1,1,107,116},{10,0,1,1,107,116},{11,0,1,1,107,116},{12,1,1,1,107,116},{13,0,1,1,107,32},{14,1,1,1,107,32},{13,0,1,1,107,37},{14,1,1,1,107,37},{13,0,1,1,107,45},{14,1,1,1,107,45},{13,0,1,1,107,46},{14,1,1,1,107,46},{13,0,1,1,107,47},{14,1,1,1,107,47},{13,0,1,1,107,51},{14,1,1,1,107,51},{13,0,1,1,107,52},{14,1,1,1,107,52},{13,0,1,1,107,53},{14,1,1,1,107,53},{13,0,1,1,107,54},{14,1,1,1,107,54},{13,0,1,1,107,55},{14,1,1,1,107,55},{13,0,1,1,107,56},{14,1,1,1,107,56},{13,0,1,1,107,57},{14,1,1,1,107,57},{13,0,1,1,107,61},{14,1,1,1,107,61},{13,0,1,1,107,65},{14,1,1,1,107,65},{13,0,1,1,107,95},{14,1,1,1,107,95},{13,0,1,1,107,98},{14,1,1,1,107,98},{13,0,1,1,107,100},{14,1,1,1,107,100},{13,0,1,1,107,102},{14,1,1,1,107,102},{13,0,1,1,107,103},{14,1,1,1,107,103},{13,0,1,1,107,104},{14,1,1,1,107,104},{13,0,1,1,107,108},{14,1,1,1,107,108},{13,0,1,1,107,109},{14,1,1,1,107,109},{13,0,1,1,107,110},{14,1,1,1,107,110},{13,0,1,1,107,112},{14,1,1,1,107,112},{13,0,1,1,107,114},{14,1,1,1,107,114},{13,0,1,1,107,117},{14,1,1,1,107,117},{0,1,1,1,107,58},{0,1,1,1,107,66},{0,1,1,1,107,67},{0,1,1,1,107,68},{0,1,1,1,107,69},{0,1,1,1,107,70},{0,1,1,1,107,71},{0,1,1,1,107,72},{0,1,1,1,107,73},{0,1,1,1,107,74},{0,1,1,1,107,75},{0,1,1,1,107,76},{0,1,1,1,107,77},{0,1,1,1,107,78},{0,1,1,1,107,79},{0,1,1,1,107,80},{0,1,1,1,107,81},{0,1,1,1,107,82},{0,1,1,1,107,83},{0,1,1,1,107,84},{0,1,1,1,107,85},{0,1,1,1,107,86},{0,1,1,1,107,87},{0,1,1,1,107,89},{0,1,1,1,107,106},{0,1,1,1,107,107},{0,1,1,1,107,113},{0,1,1,1,107,118},{0,1,1,1,107,119},{0,1,1,1,107,120},{0,1,1,1,107,121},{0,1,1,1,107,122},{85,0,0,1,0,107},{86,0,0,1,0,107},{87,0,0,1,0,107},{88,1,0,1,0,107},{9,0,1,1,113,48},{10,0,1,1,113,48},{11,0,1,1,113,48},{12,1,1,1,113,48},{9,0,1,1,113,49},{10,0,1,1,113,49},{11,0,1,1,113,49},{12,1,1,1,113,49},{9,0,1,1,113,50},{10,0,1,1,113,50},{11,0,1,1,113,50},{12,1,1,1,113,50},{9,0,1,1,113,97},{10,0,1,1,113,97},{11,0,1,1,113,97},{12,1,1,1,113,97},{9,0,1,1,113,99},{10,0,1,1,113,99},{11,0,1,1,113,99},{12,1,1,1,113,99},{9,0,1,1,113,101},{10,0,1,1,113,101},{11,0,1,1,113,101},{12,1,1,1,113,101},{9,0,1,1,113,105},{10,0,1,1,113,105},{11,0,1,1,113,105},{12,1,1,1,113,105},{9,0,1,1,113,111},{10,0,1,1,113,111},{11,0,1,1,113,111},{12,1,1,1,113,111},{9,0,1,1,113,115},{10,0,1,1,113,115},{11,0,1,1,113,115},{12,1,1,1,113,115},{9,0,1,1,113,116},{10,0,1,1,113,116},{11,0,1,1,113,116},{12,1,1,1,113,116},{13,0,1,1,113,32},{14,1,1,1,113,32},{13,0,1,1,113,37},{14,1,1,1,113,37},{13,0,1,1,113,45},{14,1,1,1,113,45},{13,0,1,1,113,46},{14,1,1,1,113,46},{13,0,1,1,113,47},{14,1,1,1,113,47},{13,0,1,1,113,51},{14,1,1,1,113,51},{13,0,1,1,113,52},{14,1,1,1,113,52},{13,0,1,1,113,53},{14,1,1,1,113,53},{13,0,1,1,113,54},{14,1,1,1,113,54},{13,0,1,1,113,55},{14,1,1,1,113,55},{13,0,1,1,113,56},{14,1,1,1,113,56},{13,0,1,1,113,57},{14,1,1,1,113,57},{13,0,1,1,113,61},{14,1,1,1,113,61},{13,0,1,1,113,65},{14,1,1,1,113,65},{13,0,1,1,113,95},{14,1,1,1,113,95},{13,0,1,1,113,98},{14,1,1,1,113,98},{13,0,1,1,113,100},{14,1,1,1,113,100},{13,0,1,1,113,102},{14,1,1,1,113,102},{13,0,1,1,113,103},{14,1,1,1,113,103},{13,0,1,1,113,104},{14,1,1,1,113,104},{13,0,1,1,113,108},{14,1,1,1,113,108},{13,0,1,1,113,109},{14,1,1,1,113,109},{13,0,1,1,113,110},{14,1,1,1,113,110},{13,0,1,1,113,112},{14,1,1,1,113,112},{13,0,1,1,113,114},{14,1,1,1,113,114},{13,0,1,1,113,117},{14,1,1,1,113,117},{0,1,1,1,113,58},{0,1,1,1,113,66},{0,1,1,1,113,67},{0,1,1,1,113,68},{0,1,1,1,113,69},{0,1,1,1,113,70},{0,1,1,1,113,71},{0,1,1,1,113,72},{0,1,1,1,113,73},{0,1,1,1,113,74},{0,1,1,1,113,75},{0,1,1,1,113,76},{0,1,1,1,113,77},{0,1,1,1,113,78},{0,1,1,1,113,79},{0,1,1,1,113,80},{0,1,1,1,113,81},{0,1,1,1,113,82},{0,1,1,1,113,83},{0,1,1,1,113,84},{0,1,1,1,113,85},{0,1,1,1,113,86},{0,1,1,1,113,87},{0,1,1,1,113,89},{0,1,1,1,113,106},{0,1,1,1,113,107},{0,1,1,1,113,113},{0,1,1,1,113,118},{0,1,1,1,113,119},{0,1,1,1,113,120},{0,1,1,1,113,121},{0,1,1,1,113,122},{85,0,0,1,0,113},{86,0,0,1,0,113},{87,0,0,1,0,113},{88,1,0,1,0,113},{9,0,1,1,118,48},{10,0,1,1,118,48},{11,0,1,1,118,48},{12,1,1,1,118,48},{9,0,1,1,118,49},{10,0,1,1,118,49},{11,0,1,1,118,49},{12,1,1,1,118,49},{9,0,1,1,118,50},{10,0,1,1,118,50},{11,0,1,1,118,50},{12,1,1,1,118,50},{9,0,1,1,118,97},{10,0,1,1,118,97},{11,0,1,1,118,97},{12,1,1,1,118,97},{9,0,1,1,118,99},{10,0,1,1,118,99},{11,0,1,1,118,99},{12,1,1,1,118,99},{9,0,1,1,118,101},{10,0,1,1,118,101},{11,0,1,1,118,101},{12,1,1,1,118,101},{9,0,1,1,118,105},{10,0,1,1,118,105},{11,0,1,1,118,105},{12,1,1,1,118,105},{9,0,1,1,118,111},{10,0,1,1,118,111},{11,0,1,1,118,111},{12,1,1,1,118,111},{9,0,1,1,118,115},{10,0,1,1,118,115},{11,0,1,1,118,115},{12,1,1,1,118,115},{9,0,1,1,118,116},{10,0,1,1,118,116},{11,0,1,1,118,116},{12,1,1,1,118,116},{13,0,1,1,118,32},{14,1,1,1,118,32},{13,0,1,1,118,37},{14,1,1,1,118,37},{13,0,1,1,118,45},{14,1,1,1,118,45},{13,0,1,1,118,46},{14,1,1,1,118,46},{13,0,1,1,118,47},{14,1,1,1,118,47},{13,0,1,1,118,51},{14,1,1,1,118,51},{13,0,1,1,118,52},{14,1,1,1,118,52},{13,0,1,1,118,53},{14,1,1,1,118,53},{13,0,1,1,118,54},{14,1,1,1,118,54},{13,0,1,1,118,55},{14,1,1,1,118,55},{13,0,1,1,118,56},{14,1,1,1,118,56},{13,0,1,1,118,57},{14,1,1,1,118,57},{13,0,1,1,118,61},{14,1,1,1,118,61},{13,0,1,1,118,65},{14,1,1,1,118,65},{13,0,1,1,118,95},{14,1,1,1,118,95},{13,0,1,1,118,98},{14,1,1,1,118,98},{13,0,1,1,118,100},{14,1,1,1,118,100},{13,0,1,1,118,102},{14,1,1,1,118,102},{13,0,1,1,118,103},{14,1,1,1,118,103},{13,0,1,1,118,104},{14,1,1,1,118,104},{13,0,1,1,118,108},{14,1,1,1,118,108},{13,0,1,1,118,109},{14,1,1,1,118,109},{13,0,1,1,118,110},{14,1,1,1,118,110},{13,0,1,1,118,112},{14,1,1,1,118,112},{13,0,1,1,118,114},{14,1,1,1,118,114},{13,0,1,1,118,117},{14,1,1,1,118,117},{0,1,1,1,118,58},{0,1,1,1,118,66},{0,1,1,1,118,67},{0,1,1,1,118,68},{0,1,1,1,118,69},{0,1,1,1,118,70},{0,1,1,1,118,71},{0,1,1,1,118,72},{0,1,1,1,118,73},{0,1,1,1,118,74},{0,1,1,1,118,75},{0,1,1,1,118,76},{0,1,1,1,118,77},{0,1,1,1,118,78},{0,1,1,1,118,79},{0,1,1,1,118,80},{0,1,1,1,118,81},{0,1,1,1,118,82},{0,1,1,1,118,83},{0,1,1,1,118,84},{0,1,1,1,118,85},{0,1,1,1,118,86},{0,1,1,1,118,87},{0,1,1,1,118,89},{0,1,1,1,118,106},{0,1,1,1,118,107},{0,1,1,1,118,113},{0,1,1,1,118,118},{0,1,1,1,118,119},{0,1,1,1,118,120},{0,1,1,1,118,121},{0,1,1,1,118,122},{85,0,0,1,0,118},{86,0,0,1,0,118},{87,0,0,1,0,118},{88,1,0,1,0,118},{9,0,1,1,119,48},{10,0,1,1,119,48},{11,0,1,1,119,48},{12,1,1,1,119,48},{9,0,1,1,119,49},{10,0,1,1,119,49},{11,0,1,1,119,49},{12,1,1,1,119,49},{9,0,1,1,119,50},{10,0,1,1,119,50},{11,0,1,1,119,50},{12,1,1,1,119,50},{9,0,1,1,119,97},{10,0,1,1,119,97},{11,0,1,1,119,97},{12,1,1,1,119,97},{9,0,1,1,119,99},{10,0,1,1,119,99},{11,0,1,1,119,99},{12,1,1,1,119,99},{9,0,1,1,119,101},{10,0,1,1,119,101},{11,0,1,1,119,101},{12,1,1,1,119,101},{9,0,1,1,119,105},{10,0,1,1,119,105},{11,0,1,1,119,105},{12,1,1,1,119,105},{9,0,1,1,119,111},{10,0,1,1,119,111},{11,0,1,1,119,111},{12,1,1,1,119,111},{9,0,1,1,119,115},{10,0,1,1,119,115},{11,0,1,1,119,115},{12,1,1,1,119,115},{9,0,1,1,119,116},{10,0,1,1,119,116},{11,0,1,1,119,116},{12,1,1,1,119,116},{13,0,1,1,119,32},{14,1,1,1,119,32},{13,0,1,1,119,37},{14,1,1,1,119,37},{13,0,1,1,119,45},{14,1,1,1,119,45},{13,0,1,1,119,46},{14,1,1,1,119,46},{13,0,1,1,119,47},{14,1,1,1,119,47},{13,0,1,1,119,51},{14,1,1,1,119,51},{13,0,1,1,119,52},{14,1,1,1,119,52},{13,0,1,1,119,53},{14,1,1,1,119,53},{13,0,1,1,119,54},{14,1,1,1,119,54},{13,0,1,1,119,55},{14,1,1,1,119,55},{13,0,1,1,119,56},{14,1,1,1,119,56},{13,0,1,1,119,57},{14,1,1,1,119,57},{13,0,1,1,119,61},{14,1,1,1,119,61},{13,0,1,1,119,65},{14,1,1,1,119,65},{13,0,1,1,119,95},{14,1,1,1,119,95},{13,0,1,1,119,98},{14,1,1,1,119,98},{13,0,1,1,119,100},{14,1,1,1,119,100},{13,0,1,1,119,102},{14,1,1,1,119,102},{13,0,1,1,119,103},{14,1,1,1,119,103},{13,0,1,1,119,104},{14,1,1,1,119,104},{13,0,1,1,119,108},{14,1,1,1,119,108},{13,0,1,1,119,109},{14,1,1,1,119,109},{13,0,1,1,119,110},{14,1,1,1,119,110},{13,0,1,1,119,112},{14,1,1,1,119,112},{13,0,1,1,119,114},{14,1,1,1,119,114},{13,0,1,1,119,117},{14,1,1,1,119,117},{0,1,1,1,119,58},{0,1,1,1,119,66},{0,1,1,1,119,67},{0,1,1,1,119,68},{0,1,1,1,119,69},{0,1,1,1,119,70},{0,1,1,1,119,71},{0,1,1,1,119,72},{0,1,1,1,119,73},{0,1,1,1,119,74},{0,1,1,1,119,75},{0,1,1,1,119,76},{0,1,1,1,119,77},{0,1,1,1,119,78},{0,1,1,1,119,79},{0,1,1,1,119,80},{0,1,1,1,119,81},{0,1,1,1,119,82},{0,1,1,1,119,83},{0,1,1,1,119,84},{0,1,1,1,119,85},{0,1,1,1,119,86},{0,1,1,1,119,87},{0,1,1,1,119,89},{0,1,1,1,119,106},{0,1,1,1,119,107},{0,1,1,1,119,113},{0,1,1,1,119,118},{0,1,1,1,119,119},{0,1,1,1,119,120},{0,1,1,1,119,121},{0,1,1,1,119,122},{85,0,0,1,0,119},{86,0,0,1,0,119},{87,0,0,1,0,119},{88,1,0,1,0,119},{9,0,1,1,120,48},{10,0,1,1,120,48},{11,0,1,1,120,48},{12,1,1,1,120,48},{9,0,1,1,120,49},{10,0,1,1,120,49},{11,0,1,1,120,49},{12,1,1,1,120,49},{9,0,1,1,120,50},{10,0,1,1,120,50},{11,0,1,1,120,50},{12,1,1,1,120,50},{9,0,1,1,120,97},{10,0,1,1,120,97},{11,0,1,1,120,97},{12,1,1,1,120,97},{9,0,1,1,120,99},{10,0,1,1,120,99},{11,0,1,1,120,99},{12,1,1,1,120,99},{9,0,1,1,120,101},{10,0,1,1,120,101},{11,0,1,1,120,101},{12,1,1,1,120,101},{9,0,1,1,120,105},{10,0,1,1,120,105},{11,0,1,1,120,105},{12,1,1,1,120,105},{9,0,1,1,120,111},{10,0,1,1,120,111},{11,0,1,1,120,111},{12,1,1,1,120,111},{9,0,1,1,120,115},{10,0,1,1,120,115},{11,0,1,1,120,115},{12,1,1,1,120,115},{9,0,1,1,120,116},{10,0,1,1,120,116},{11,0,1,1,120,116},{12,1,1,1,120,116},{13,0,1,1,120,32},{14,1,1,1,120,32},{13,0,1,1,120,37},{14,1,1,1,120,37},{13,0,1,1,120,45},{14,1,1,1,120,45},{13,0,1,1,120,46},{14,1,1,1,120,46},{13,0,1,1,120,47},{14,1,1,1,120,47},{13,0,1,1,120,51},{14,1,1,1,120,51},{13,0,1,1,120,52},{14,1,1,1,120,52},{13,0,1,1,120,53},{14,1,1,1,120,53},{13,0,1,1,120,54},{14,1,1,1,120,54},{13,0,1,1,120,55},{14,1,1,1,120,55},{13,0,1,1,120,56},{14,1,1,1,120,56},{13,0,1,1,120,57},{14,1,1,1,120,57},{13,0,1,1,120,61},{14,1,1,1,120,61},{13,0,1,1,120,65},{14,1,1,1,120,65},{13,0,1,1,120,95},{14,1,1,1,120,95},{13,0,1,1,120,98},{14,1,1,1,120,98},{13,0,1,1,120,100},{14,1,1,1,120,100},{13,0,1,1,120,102},{14,1,1,1,120,102},{13,0,1,1,120,103},{14,1,1,1,120,103},{13,0,1,1,120,104},{14,1,1,1,120,104},{13,0,1,1,120,108},{14,1,1,1,120,108},{13,0,1,1,120,109},{14,1,1,1,120,109},{13,0,1,1,120,110},{14,1,1,1,120,110},{13,0,1,1,120,112},{14,1,1,1,120,112},{13,0,1,1,120,114},{14,1,1,1,120,114},{13,0,1,1,120,117},{14,1,1,1,120,117},{0,1,1,1,120,58},{0,1,1,1,120,66},{0,1,1,1,120,67},{0,1,1,1,120,68},{0,1,1,1,120,69},{0,1,1,1,120,70},{0,1,1,1,120,71},{0,1,1,1,120,72},{0,1,1,1,120,73},{0,1,1,1,120,74},{0,1,1,1,120,75},{0,1,1,1,120,76},{0,1,1,1,120,77},{0,1,1,1,120,78},{0,1,1,1,120,79},{0,1,1,1,120,80},{0,1,1,1,120,81},{0,1,1,1,120,82},{0,1,1,1,120,83},{0,1,1,1,120,84},{0,1,1,1,120,85},{0,1,1,1,120,86},{0,1,1,1,120,87},{0,1,1,1,120,89},{0,1,1,1,120,106},{0,1,1,1,120,107},{0,1,1,1,120,113},{0,1,1,1,120,118},{0,1,1,1,120,119},{0,1,1,1,120,120},{0,1,1,1,120,121},{0,1,1,1,120,122},{85,0,0,1,0,120},{86,0,0,1,0,120},{87,0,0,1,0,120},{88,1,0,1,0,120},{9,0,1,1,121,48},{10,0,1,1,121,48},{11,0,1,1,121,48},{12,1,1,1,121,48},{9,0,1,1,121,49},{10,0,1,1,121,49},{11,0,1,1,121,49},{12,1,1,1,121,49},{9,0,1,1,121,50},{10,0,1,1,121,50},{11,0,1,1,121,50},{12,1,1,1,121,50},{9,0,1,1,121,97},{10,0,1,1,121,97},{11,0,1,1,121,97},{12,1,1,1,121,97},{9,0,1,1,121,99},{10,0,1,1,121,99},{11,0,1,1,121,99},{12,1,1,1,121,99},{9,0,1,1,121,101},{10,0,1,1,121,101},{11,0,1,1,121,101},{12,1,1,1,121,101},{9,0,1,1,121,105},{10,0,1,1,121,105},{11,0,1,1,121,105},{12,1,1,1,121,105},{9,0,1,1,121,111},{10,0,1,1,121,111},{11,0,1,1,121,111},{12,1,1,1,121,111},{9,0,1,1,121,115},{10,0,1,1,121,115},{11,0,1,1,121,115},{12,1,1,1,121,115},{9,0,1,1,121,116},{10,0,1,1,121,116},{11,0,1,1,121,116},{12,1,1,1,121,116},{13,0,1,1,121,32},{14,1,1,1,121,32},{13,0,1,1,121,37},{14,1,1,1,121,37},{13,0,1,1,121,45},{14,1,1,1,121,45},{13,0,1,1,121,46},{14,1,1,1,121,46},{13,0,1,1,121,47},{14,1,1,1,121,47},{13,0,1,1,121,51},{14,1,1,1,121,51},{13,0,1,1,121,52},{14,1,1,1,121,52},{13,0,1,1,121,53},{14,1,1,1,121,53},{13,0,1,1,121,54},{14,1,1,1,121,54},{13,0,1,1,121,55},{14,1,1,1,121,55},{13,0,1,1,121,56},{14,1,1,1,121,56},{13,0,1,1,121,57},{14,1,1,1,121,57},{13,0,1,1,121,61},{14,1,1,1,121,61},{13,0,1,1,121,65},{14,1,1,1,121,65},{13,0,1,1,121,95},{14,1,1,1,121,95},{13,0,1,1,121,98},{14,1,1,1,121,98},{13,0,1,1,121,100},{14,1,1,1,121,100},{13,0,1,1,121,102},{14,1,1,1,121,102},{13,0,1,1,121,103},{14,1,1,1,121,103},{13,0,1,1,121,104},{14,1,1,1,121,104},{13,0,1,1,121,108},{14,1,1,1,121,108},{13,0,1,1,121,109},{14,1,1,1,121,109},{13,0,1,1,121,110},{14,1,1,1,121,110},{13,0,1,1,121,112},{14,1,1,1,121,112},{13,0,1,1,121,114},{14,1,1,1,121,114},{13,0,1,1,121,117},{14,1,1,1,121,117},{0,1,1,1,121,58},{0,1,1,1,121,66},{0,1,1,1,121,67},{0,1,1,1,121,68},{0,1,1,1,121,69},{0,1,1,1,121,70},{0,1,1,1,121,71},{0,1,1,1,121,72},{0,1,1,1,121,73},{0,1,1,1,121,74},{0,1,1,1,121,75},{0,1,1,1,121,76},{0,1,1,1,121,77},{0,1,1,1,121,78},{0,1,1,1,121,79},{0,1,1,1,121,80},{0,1,1,1,121,81},{0,1,1,1,121,82},{0,1,1,1,121,83},{0,1,1,1,121,84},{0,1,1,1,121,85},{0,1,1,1,121,86},{0,1,1,1,121,87},{0,1,1,1,121,89},{0,1,1,1,121,106},{0,1,1,1,121,107},{0,1,1,1,121,113},{0,1,1,1,121,118},{0,1,1,1,121,119},{0,1,1,1,121,120},{0,1,1,1,121,121},{0,1,1,1,121,122},{85,0,0,1,0,121},{86,0,0,1,0,121},{87,0,0,1,0,121},{88,1,0,1,0,121},{9,0,1,1,122,48},{10,0,1,1,122,48},{11,0,1,1,122,48},{12,1,1,1,122,48},{9,0,1,1,122,49},{10,0,1,1,122,49},{11,0,1,1,122,49},{12,1,1,1,122,49},{9,0,1,1,122,50},{10,0,1,1,122,50},{11,0,1,1,122,50},{12,1,1,1,122,50},{9,0,1,1,122,97},{10,0,1,1,122,97},{11,0,1,1,122,97},{12,1,1,1,122,97},{9,0,1,1,122,99},{10,0,1,1,122,99},{11,0,1,1,122,99},{12,1,1,1,122,99},{9,0,1,1,122,101},{10,0,1,1,122,101},{11,0,1,1,122,101},{12,1,1,1,122,101},{9,0,1,1,122,105},{10,0,1,1,122,105},{11,0,1,1,122,105},{12,1,1,1,122,105},{9,0,1,1,122,111},{10,0,1,1,122,111},{11,0,1,1,122,111},{12,1,1,1,122,111},{9,0,1,1,122,115},{10,0,1,1,122,115},{11,0,1,1,122,115},{12,1,1,1,122,115},{9,0,1,1,122,116},{10,0,1,1,122,116},{11,0,1,1,122,116},{12,1,1,1,122,116},{13,0,1,1,122,32},{14,1,1,1,122,32},{13,0,1,1,122,37},{14,1,1,1,122,37},{13,0,1,1,122,45},{14,1,1,1,122,45},{13,0,1,1,122,46},{14,1,1,1,122,46},{13,0,1,1,122,47},{14,1,1,1,122,47},{13,0,1,1,122,51},{14,1,1,1,122,51},{13,0,1,1,122,52},{14,1,1,1,122,52},{13,0,1,1,122,53},{14,1,1,1,122,53},{13,0,1,1,122,54},{14,1,1,1,122,54},{13,0,1,1,122,55},{14,1,1,1,122,55},{13,0,1,1,122,56},{14,1,1,1,122,56},{13,0,1,1,122,57},{14,1,1,1,122,57},{13,0,1,1,122,61},{14,1,1,1,122,61},{13,0,1,1,122,65},{14,1,1,1,122,65},{13,0,1,1,122,95},{14,1,1,1,122,95},{13,0,1,1,122,98},{14,1,1,1,122,98},{13,0,1,1,122,100},{14,1,1,1,122,100},{13,0,1,1,122,102},{14,1,1,1,122,102},{13,0,1,1,122,103},{14,1,1,1,122,103},{13,0,1,1,122,104},{14,1,1,1,122,104},{13,0,1,1,122,108},{14,1,1,1,122,108},{13,0,1,1,122,109},{14,1,1,1,122,109},{13,0,1,1,122,110},{14,1,1,1,122,110},{13,0,1,1,122,112},{14,1,1,1,122,112},{13,0,1,1,122,114},{14,1,1,1,122,114},{13,0,1,1,122,117},{14,1,1,1,122,117},{0,1,1,1,122,58},{0,1,1,1,122,66},{0,1,1,1,122,67},{0,1,1,1,122,68},{0,1,1,1,122,69},{0,1,1,1,122,70},{0,1,1,1,122,71},{0,1,1,1,122,72},{0,1,1,1,122,73},{0,1,1,1,122,74},{0,1,1,1,122,75},{0,1,1,1,122,76},{0,1,1,1,122,77},{0,1,1,1,122,78},{0,1,1,1,122,79},{0,1,1,1,122,80},{0,1,1,1,122,81},{0,1,1,1,122,82},{0,1,1,1,122,83},{0,1,1,1,122,84},{0,1,1,1,122,85},{0,1,1,1,122,86},{0,1,1,1,122,87},{0,1,1,1,122,89},{0,1,1,1,122,106},{0,1,1,1,122,107},{0,1,1,1,122,113},{0,1,1,1,122,118},{0,1,1,1,122,119},{0,1,1,1,122,120},{0,1,1,1,122,121},{0,1,1,1,122,122},{85,0,0,1,0,122},{86,0,0,1,0,122},{87,0,0,1,0,122},{88,1,0,1,0,122},{13,0,1,1,38,48},{14,1,1,1,38,48},{13,0,1,1,38,49},{14,1,1,1,38,49},{13,0,1,1,38,50},{14,1,1,1,38,50},{13,0,1,1,38,97},{14,1,1,1,38,97},{13,0,1,1,38,99},{14,1,1,1,38,99},{13,0,1,1,38,101},{14,1,1,1,38,101},{13,0,1,1,38,105},{14,1,1,1,38,105},{13,0,1,1,38,111},{14,1,1,1,38,111},{13,0,1,1,38,115},{14,1,1,1,38,115},{13,0,1,1,38,116},{14,1,1,1,38,116},{0,1,1,1,38,32},{0,1,1,1,38,37},{0,1,1,1,38,45},{0,1,1,1,38,46},{0,1,1,1,38,47},{0,1,1,1,38,51},{0,1,1,1,38,52},{0,1,1,1,38,53},{0,1,1,1,38,54},{0,1,1,1,38,55},{0,1,1,1,38,56},{0,1,1,1,38,57},{0,1,1,1,38,61},{0,1,1,1,38,65},{0,1,1,1,38,95},{0,1,1,1,38,98},{0,1,1,1,38,100},{0,1,1,1,38,102},{0,1,1,1,38,103},{0,1,1,1,38,104},{0,1,1,1,38,108},{0,1,1,1,38,109},{0,1,1,1,38,110},{0,1,1,1,38,112},{0,1,1,1,38,114},{0,1,1,1,38,117},{17,0,0,1,0,38},{18,0,0,1,0,38},{19,0,0,1,0,38},{20,0,0,1,0,38},{21,0,0,1,0,38},{22,0,0,1,0,38},{23,0,0,1,0,38},{24,0,0,1,0,38},{25,0,0,1,0,38},{26,0,0,1,0,38},{27,0,0,1,0,38},{28,0,0,1,0,38},{29,0,0,1,0,38},{30,0,0,1,0,38},{31,0,0,1,0,38},{32,0,0,1,0,38},{33,0,0,1,0,38},{34,1,0,1,0,38},{13,0,1,1,42,48},{14,1,1,1,42,48},{13,0,1,1,42,49},{14,1,1,1,42,49},{13,0,1,1,42,50},{14,1,1,1,42,50},{13,0,1,1,42,97},{14,1,1,1,42,97},{13,0,1,1,42,99},{14,1,1,1,42,99},{13,0,1,1,42,101},{14,1,1,1,42,101},{13,0,1,1,42,105},{14,1,1,1,42,105},{13,0,1,1,42,111},{14,1,1,1,42,111},{13,0,1,1,42,115},{14,1,1,1,42,115},{13,0,1,1,42,116},{14,1,1,1,42,116},{0,1,1,1,42,32},{0,1,1,1,42,37},{0,1,1,1,42,45},{0,1,1,1,42,46},{0,1,1,1,42,47},{0,1,1,1,42,51},{0,1,1,1,42,52},{0,1,1,1,42,53},{0,1,1,1,42,54},{0,1,1,1,42,55},{0,1,1,1,42,56},{0,1,1,1,42,57},{0,1,1,1,42,61},{0,1,1,1,42,65},{0,1,1,1,42,95},{0,1,1,1,42,98},{0,1,1,1,42,100},{0,1,1,1,42,102},{0,1,1,1,42,103},{0,1,1,1,42,104},{0,1,1,1,42,108},{0,1,1,1,42,109},{0,1,1,1,42,110},{0,1,1,1,42,112},{0,1,1,1,42,114},{0,1,1,1,42,117},{17,0,0,1,0,42},{18,0,0,1,0,42},{19,0,0,1,0,42},{20,0,0,1,0,42},{21,0,0,1,0,42},{22,0,0,1,0,42},{23,0,0,1,0,42},{24,0,0,1,0,42},{25,0,0,1,0,42},{26,0,0,1,0,42},{27,0,0,1,0,42},{28,0,0,1,0,42},{29,0,0,1,0,42},{30,0,0,1,0,42},{31,0,0,1,0,42},{32,0,0,1,0,42},{33,0,0,1,0,42},{34,1,0,1,0,42},{13,0,1,1,44,48},{14,1,1,1,44,48},{13,0,1,1,44,49},{14,1,1,1,44,49},{13,0,1,1,44,50},{14,1,1,1,44,50},{13,0,1,1,44,97},{14,1,1,1,44,97},{13,0,1,1,44,99},{14,1,1,1,44,99},{13,0,1,1,44,101},{14,1,1,1,44,101},{13,0,1,1,44,105},{14,1,1,1,44,105},{13,0,1,1,44,111},{14,1,1,1,44,111},{13,0,1,1,44,115},{14,1,1,1,44,115},{13,0,1,1,44,116},{14,1,1,1,44,116},{0,1,1,1,44,32},{0,1,1,1,44,37},{0,1,1,1,44,45},{0,1,1,1,44,46},{0,1,1,1,44,47},{0,1,1,1,44,51},{0,1,1,1,44,52},{0,1,1,1,44,53},{0,1,1,1,44,54},{0,1,1,1,44,55},{0,1,1,1,44,56},{0,1,1,1,44,57},{0,1,1,1,44,61},{0,1,1,1,44,65},{0,1,1,1,44,95},{0,1,1,1,44,98},{0,1,1,1,44,100},{0,1,1,1,44,102},{0,1,1,1,44,103},{0,1,1,1,44,104},{0,1,1,1,44,108},{0,1,1,1,44,109},{0,1,1,1,44,110},{0,1,1,1,44,112},{0,1,1,1,44,114},{0,1,1,1,44,117},{17,0,0,1,0,44},{18,0,0,1,0,44},{19,0,0,1,0,44},{20,0,0,1,0,44},{21,0,0,1,0,44},{22,0,0,1,0,44},{23,0,0,1,0,44},{24,0,0,1,0,44},{25,0,0,1,0,44},{26,0,0,1,0,44},{27,0,0,1,0,44},{28,0,0,1,0,44},{29,0,0,1,0,44},{30,0,0,1,0,44},{31,0,0,1,0,44},{32,0,0,1,0,44},{33,0,0,1,0,44},{34,1,0,1,0,44},{13,0,1,1,59,48},{14,1,1,1,59,48},{13,0,1,1,59,49},{14,1,1,1,59,49},{13,0,1,1,59,50},{14,1,1,1,59,50},{13,0,1,1,59,97},{14,1,1,1,59,97},{13,0,1,1,59,99},{14,1,1,1,59,99},{13,0,1,1,59,101},{14,1,1,1,59,101},{13,0,1,1,59,105},{14,1,1,1,59,105},{13,0,1,1,59,111},{14,1,1,1,59,111},{13,0,1,1,59,115},{14,1,1,1,59,115},{13,0,1,1,59,116},{14,1,1,1,59,116},{0,1,1,1,59,32},{0,1,1,1,59,37},{0,1,1,1,59,45},{0,1,1,1,59,46},{0,1,1,1,59,47},{0,1,1,1,59,51},{0,1,1,1,59,52},{0,1,1,1,59,53},{0,1,1,1,59,54},{0,1,1,1,59,55},{0,1,1,1,59,56},{0,1,1,1,59,57},{0,1,1,1,59,61},{0,1,1,1,59,65},{0,1,1,1,59,95},{0,1,1,1,59,98},{0,1,1,1,59,100},{0,1,1,1,59,102},{0,1,1,1,59,103},{0,1,1,1,59,104},{0,1,1,1,59,108},{0,1,1,1,59,109},{0,1,1,1,59,110},{0,1,1,1,59,112},{0,1,1,1,59,114},{0,1,1,1,59,117},{17,0,0,1,0,59},{18,0,0,1,0,59},{19,0,0,1,0,59},{20,0,0,1,0,59},{21,0,0,1,0,59},{22,0,0,1,0,59},{23,0,0,1,0,59},{24,0,0,1,0,59},{25,0,0,1,0,59},{26,0,0,1,0,59},{27,0,0,1,0,59},{28,0,0,1,0,59},{29,0,0,1,0,59},{30,0,0,1,0,59},{31,0,0,1,0,59},{32,0,0,1,0,59},{33,0,0,1,0,59},{34,1,0,1,0,59},{13,0,1,1,88,48},{14,1,1,1,88,48},{13,0,1,1,88,49},{14,1,1,1,88,49},{13,0,1,1,88,50},{14,1,1,1,88,50},{13,0,1,1,88,97},{14,1,1,1,88,97},{13,0,1,1,88,99},{14,1,1,1,88,99},{13,0,1,1,88,101},{14,1,1,1,88,101},{13,0,1,1,88,105},{14,1,1,1,88,105},{13,0,1,1,88,111},{14,1,1,1,88,111},{13,0,1,1,88,115},{14,1,1,1,88,115},{13,0,1,1,88,116},{14,1,1,1,88,116},{0,1,1,1,88,32},{0,1,1,1,88,37},{0,1,1,1,88,45},{0,1,1,1,88,46},{0,1,1,1,88,47},{0,1,1,1,88,51},{0,1,1,1,88,52},{0,1,1,1,88,53},{0,1,1,1,88,54},{0,1,1,1,88,55},{0,1,1,1,88,56},{0,1,1,1,88,57},{0,1,1,1,88,61},{0,1,1,1,88,65},{0,1,1,1,88,95},{0,1,1,1,88,98},{0,1,1,1,88,100},{0,1,1,1,88,102},{0,1,1,1,88,103},{0,1,1,1,88,104},{0,1,1,1,88,108},{0,1,1,1,88,109},{0,1,1,1,88,110},{0,1,1,1,88,112},{0,1,1,1,88,114},{0,1,1,1,88,117},{17,0,0,1,0,88},{18,0,0,1,0,88},{19,0,0,1,0,88},{20,0,0,1,0,88},{21,0,0,1,0,88},{22,0,0,1,0,88},{23,0,0,1,0,88},{24,0,0,1,0,88},{25,0,0,1,0,88},{26,0,0,1,0,88},{27,0,0,1,0,88},{28,0,0,1,0,88},{29,0,0,1,0,88},{30,0,0,1,0,88},{31,0,0,1,0,88},{32,0,0,1,0,88},{33,0,0,1,0,88},{34,1,0,1,0,88},{13,0,1,1,90,48},{14,1,1,1,90,48},{13,0,1,1,90,49},{14,1,1,1,90,49},{13,0,1,1,90,50},{14,1,1,1,90,50},{13,0,1,1,90,97},{14,1,1,1,90,97},{13,0,1,1,90,99},{14,1,1,1,90,99},{13,0,1,1,90,101},{14,1,1,1,90,101},{13,0,1,1,90,105},{14,1,1,1,90,105},{13,0,1,1,90,111},{14,1,1,1,90,111},{13,0,1,1,90,115},{14,1,1,1,90,115},{13,0,1,1,90,116},{14,1,1,1,90,116},{0,1,1,1,90,32},{0,1,1,1,90,37},{0,1,1,1,90,45},{0,1,1,1,90,46},{0,1,1,1,90,47},{0,1,1,1,90,51},{0,1,1,1,90,52},{0,1,1,1,90,53},{0,1,1,1,90,54},{0,1,1,1,90,55},{0,1,1,1,90,56},{0,1,1,1,90,57},{0,1,1,1,90,61},{0,1,1,1,90,65},{0,1,1,1,90,95},{0,1,1,1,90,98},{0,1,1,1,90,100},{0,1,1,1,90,102},{0,1,1,1,90,103},{0,1,1,1,90,104},{0,1,1,1,90,108},{0,1,1,1,90,109},{0,1,1,1,90,110},{0,1,1,1,90,112},{0,1,1,1,90,114},{0,1,1,1,90,117},{17,0,0,1,0,90},{18,0,0,1,0,90},{19,0,0,1,0,90},{20,0,0,1,0,90},{21,0,0,1,0,90},{22,0,0,1,0,90},{23,0,0,1,0,90},{24,0,0,1,0,90},{25,0,0,1,0,90},{26,0,0,1,0,90},{27,0,0,1,0,90},{28,0,0,1,0,90},{29,0,0,1,0,90},{30,0,0,1,0,90},{31,0,0,1,0,90},{32,0,0,1,0,90},{33,0,0,1,0,90},{34,1,0,1,0,90},{57,0,0,1,0,33},{58,0,0,1,0,33},{59,0,0,1,0,33},{60,0,0,1,0,33},{61,0,0,1,0,33},{62,0,0,1,0,33},{63,0,0,1,0,33},{64,0,0,1,0,33},{65,0,0,1,0,33},{66,0,0,1,0,33},{67,0,0,1,0,33},{68,0,0,1,0,33},{69,0,0,1,0,33},{70,0,0,1,0,33},{71,0,0,1,0,33},{72,1,0,1,0,33},{57,0,0,1,0,34},{58,0,0,1,0,34},{59,0,0,1,0,34},{60,0,0,1,0,34},{61,0,0,1,0,34},{62,0,0,1,0,34},{63,0,0,1,0,34},{64,0,0,1,0,34},{65,0,0,1,0,34},{66,0,0,1,0,34},{67,0,0,1,0,34},{68,0,0,1,0,34},{69,0,0,1,0,34},{70,0,0,1,0,34},{71,0,0,1,0,34},{72,1,0,1,0,34},{57,0,0,1,0,40},{58,0,0,1,0,40},{59,0,0,1,0,40},{60,0,0,1,0,40},{61,0,0,1,0,40},{62,0,0,1,0,40},{63,0,0,1,0,40},{64,0,0,1,0,40},{65,0,0,1,0,40},{66,0,0,1,0,40},{67,0,0,1,0,40},{68,0,0,1,0,40},{69,0,0,1,0,40},{70,0,0,1,0,40},{71,0,0,1,0,40},{72,1,0,1,0,40},{57,0,0,1,0,41},{58,0,0,1,0,41},{59,0,0,1,0,41},{60,0,0,1,0,41},{61,0,0,1,0,41},{62,0,0,1,0,41},{63,0,0,1,0,41},{64,0,0,1,0,41},{65,0,0,1,0,41},{66,0,0,1,0,41},{67,0,0,1,0,41},{68,0,0,1,0,41},{69,0,0,1,0,41},{70,0,0,1,0,41},{71,0,0,1,0,41},{72,1,0,1,0,41},{57,0,0,1,0,63},{58,0,0,1,0,63},{59,0,0,1,0,63},{60,0,0,1,0,63},{61,0,0,1,0,63},{62,0,0,1,0,63},{63,0,0,1,0,63},{64,0,0,1,0,63},{65,0,0,1,0,63},{66,0,0,1,0,63},{67,0,0,1,0,63},{68,0,0,1,0,63},{69,0,0,1,0,63},{70,0,0,1,0,63},{71,0,0,1,0,63},{72,1,0,1,0,63},{1,0,0,1,0,39},{2,0,0,1,0,39},{3,0,0,1,0,39},{4,0,0,1,0,39},{5,0,0,1,0,39},{6,0,0,1,0,39},{7,0,0,1,0,39},{8,1,0,1,0,39},{1,0,0,1,0,43},{2,0,0,1,0,43},{3,0,0,1,0,43},{4,0,0,1,0,43},{5,0,0,1,0,43},{6,0,0,1,0,43},{7,0,0,1,0,43},{8,1,0,1,0,43},{1,0,0,1,0,124},{2,0,0,1,0,124},{3,0,0,1,0,124},{4,0,0,1,0,124},{5,0,0,1,0,124},{6,0,0,1,0,124},{7,0,0,1,0,124},{8,1,0,1,0,124},{9,0,0,1,0,35},{10,0,0,1,0,35},{11,0,0,1,0,35},{12,1,0,1,0,35},{9,0,0,1,0,62},{10,0,0,1,0,62},{11,0,0,1,0,62},{12,1,0,1,0,62},{13,0,0,1,0,0},{14,1,0,1,0,0},{13,0,0,1,0,36},{14,1,0,1,0,36},{13,0,0,1,0,64},{14,1,0,1,0,64},{13,0,0,1,0,91},{14,1,0,1,0,91},{13,0,0,1,0,93},{14,1,0,1,0,93},{13,0,0,1,0,126},{14,1,0,1,0,126},{0,1,0,1,0,94},{0,1,0,1,0,125},{89,0,0,0,0,0},{90,0,0,0,0,0},{9,0,1,1,32,48},{10,0,1,1,32,48},{11,0,1,1,32,48},{12,1,1,1,32,48},{9,0,1,1,32,49},{10,0,1,1,32,49},{11,0,1,1,32,49},{12,1,1,1,32,49},{9,0,1,1,32,50},{10,0,1,1,32,50},{11,0,1,1,32,50},{12,1,1,1,32,50},{9,0,1,1,32,97},{10,0,1,1,32,97},{11,0,1,1,32,97},{12,1,1,1,32,97},{9,0,1,1,32,99},{10,0,1,1,32,99},{11,0,1,1,32,99},{12,1,1,1,32,99},{9,0,1,1,32,101},{10,0,1,1,32,101},{11,0,1,1,32,101},{12,1,1,1,32,101},{9,0,1,1,32,105},{10,0,1,1,32,105},{11,0,1,1,32,105},{12,1,1,1,32,105},{9,0,1,1,32,111},{10,0,1,1,32,111},{11,0,1,1,32,111},{12,1,1,1,32,111},{9,0,1,1,32,115},{10,0,1,1,32,115},{11,0,1,1,32,115},{12,1,1,1,32,115},{9,0,1,1,32,116},{10,0,1,1,32,116},{11,0,1,1,32,116},{12,1,1,1,32,116},{13,0,1,1,32,32},{14,1,1,1,32,32},{13,0,1,1,32,37},{14,1,1,1,32,37},{13,0,1,1,32,45},{14,1,1,1,32,45},{13,0,1,1,32,46},{14,1,1,1,32,46},{13,0,1,1,32,47},{14,1,1,1,32,47},{13,0,1,1,32,51},{14,1,1,1,32,51},{13,0,1,1,32,52},{14,1,1,1,32,52},{13,0,1,1,32,53},{14,1,1,1,32,53},{13,0,1,1,32,54},{14,1,1,1,32,54},{13,0,1,1,32,55},{14,1,1,1,32,55},{13,0,1,1,32,56},{14,1,1,1,32,56},{13,0,1,1,32,57},{14,1,1,1,32,57},{13,0,1,1,32,61},{14,1,1,1,32,61},{13,0,1,1,32,65},{14,1,1,1,32,65},{13,0,1,1,32,95},{14,1,1,1,32,95},{13,0,1,1,32,98},{14,1,1,1,32,98},{13,0,1,1,32,100},{14,1,1,1,32,100},{13,0,1,1,32,102},{14,1,1,1,32,102},{13,0,1,1,32,103},{14,1,1,1,32,103},{13,0,1,1,32,104},{14,1,1,1,32,104},{13,0,1,1,32,108},{14,1,1,1,32,108},{13,0,1,1,32,109},{14,1,1,1,32,109},{13,0,1,1,32,110},{14,1,1,1,32,110},{13,0,1,1,32,112},{14,1,1,1,32,112},{13,0,1,1,32,114},{14,1,1,1,32,114},{13,0,1,1,32,117},{14,1,1,1,32,117},{0,1,1,1,32,58},{0,1,1,1,32,66},{0,1,1,1,32,67},{0,1,1,1,32,68},{0,1,1,1,32,69},{0,1,1,1,32,70},{0,1,1,1,32,71},{0,1,1,1,32,72},{0,1,1,1,32,73},{0,1,1,1,32,74},{0,1,1,1,32,75},{0,1,1,1,32,76},{0,1,1,1,32,77},{0,1,1,1,32,78},{0,1,1,1,32,79},{0,1,1,1,32,80},{0,1,1,1,32,81},{0,1,1,1,32,82},{0,1,1,1,32,83},{0,1,1,1,32,84},{0,1,1,1,32,85},{0,1,1,1,32,86},{0,1,1,1,32,87},{0,1,1,1,32,89},{0,1,1,1,32,106},{0,1,1,1,32,107},{0,1,1,1,32,113},{0,1,1,1,32,118},{0,1,1,1,32,119},{0,1,1,1,32,120},{0,1,1,1,32,121},{0,1,1,1,32,122},{85,0,0,1,0,32},{86,0,0,1,0,32},{87,0,0,1,0,32},{88,1,0,1,0,32},{9,0,1,1,37,48},{10,0,1,1,37,48},{11,0,1,1,37,48},{12,1,1,1,37,48},{9,0,1,1,37,49},{10,0,1,1,37,49},{11,0,1,1,37,49},{12,1,1,1,37,49},{9,0,1,1,37,50},{10,0,1,1,37,50},{11,0,1,1,37,50},{12,1,1,1,37,50},{9,0,1,1,37,97},{10,0,1,1,37,97},{11,0,1,1,37,97},{12,1,1,1,37,97},{9,0,1,1,37,99},{10,0,1,1,37,99},{11,0,1,1,37,99},{12,1,1,1,37,99},{9,0,1,1,37,101},{10,0,1,1,37,101},{11,0,1,1,37,101},{12,1,1,1,37,101},{9,0,1,1,37,105},{10,0,1,1,37,105},{11,0,1,1,37,105},{12,1,1,1,37,105},{9,0,1,1,37,111},{10,0,1,1,37,111},{11,0,1,1,37,111},{12,1,1,1,37,111},{9,0,1,1,37,115},{10,0,1,1,37,115},{11,0,1,1,37,115},{12,1,1,1,37,115},{9,0,1,1,37,116},{10,0,1,1,37,116},{11,0,1,1,37,116},{12,1,1,1,37,116},{13,0,1,1,37,32},{14,1,1,1,37,32},{13,0,1,1,37,37},{14,1,1,1,37,37},{13,0,1,1,37,45},{14,1,1,1,37,45},{13,0,1,1,37,46},{14,1,1,1,37,46},{13,0,1,1,37,47},{14,1,1,1,37,47},{13,0,1,1,37,51},{14,1,1,1,37,51},{13,0,1,1,37,52},{14,1,1,1,37,52},{13,0,1,1,37,53},{14,1,1,1,37,53},{13,0,1,1,37,54},{14,1,1,1,37,54},{13,0,1,1,37,55},{14,1,1,1,37,55},{13,0,1,1,37,56},{14,1,1,1,37,56},{13,0,1,1,37,57},{14,1,1,1,37,57},{13,0,1,1,37,61},{14,1,1,1,37,61},{13,0,1,1,37,65},{14,1,1,1,37,65},{13,0,1,1,37,95},{14,1,1,1,37,95},{13,0,1,1,37,98},{14,1,1,1,37,98},{13,0,1,1,37,100},{14,1,1,1,37,100},{13,0,1,1,37,102},{14,1,1,1,37,102},{13,0,1,1,37,103},{14,1,1,1,37,103},{13,0,1,1,37,104},{14,1,1,1,37,104},{13,0,1,1,37,108},{14,1,1,1,37,108},{13,0,1,1,37,109},{14,1,1,1,37,109},{13,0,1,1,37,110},{14,1,1,1,37,110},{13,0,1,1,37,112},{14,1,1,1,37,112},{13,0,1,1,37,114},{14,1,1,1,37,114},{13,0,1,1,37,117},{14,1,1,1,37,117},{0,1,1,1,37,58},{0,1,1,1,37,66},{0,1,1,1,37,67},{0,1,1,1,37,68},{0,1,1,1,37,69},{0,1,1,1,37,70},{0,1,1,1,37,71},{0,1,1,1,37,72},{0,1,1,1,37,73},{0,1,1,1,37,74},{0,1,1,1,37,75},{0,1,1,1,37,76},{0,1,1,1,37,77},{0,1,1,1,37,78},{0,1,1,1,37,79},{0,1,1,1,37,80},{0,1,1,1,37,81},{0,1,1,1,37,82},{0,1,1,1,37,83},{0,1,1,1,37,84},{0,1,1,1,37,85},{0,1,1,1,37,86},{0,1,1,1,37,87},{0,1,1,1,37,89},{0,1,1,1,37,106},{0,1,1,1,37,107},{0,1,1,1,37,113},{0,1,1,1,37,118},{0,1,1,1,37,119},{0,1,1,1,37,120},{0,1,1,1,37,121},{0,1,1,1,37,122},{85,0,0,1,0,37},{86,0,0,1,0,37},{87,0,0,1,0,37},{88,1,0,1,0,37},{9,0,1,1,45,48},{10,0,1,1,45,48},{11,0,1,1,45,48},{12,1,1,1,45,48},{9,0,1,1,45,49},{10,0,1,1,45,49},{11,0,1,1,45,49},{12,1,1,1,45,49},{9,0,1,1,45,50},{10,0,1,1,45,50},{11,0,1,1,45,50},{12,1,1,1,45,50},{9,0,1,1,45,97},{10,0,1,1,45,97},{11,0,1,1,45,97},{12,1,1,1,45,97},{9,0,1,1,45,99},{10,0,1,1,45,99},{11,0,1,1,45,99},{12,1,1,1,45,99},{9,0,1,1,45,101},{10,0,1,1,45,101},{11,0,1,1,45,101},{12,1,1,1,45,101},{9,0,1,1,45,105},{10,0,1,1,45,105},{11,0,1,1,45,105},{12,1,1,1,45,105},{9,0,1,1,45,111},{10,0,1,1,45,111},{11,0,1,1,45,111},{12,1,1,1,45,111},{9,0,1,1,45,115},{10,0,1,1,45,115},{11,0,1,1,45,115},{12,1,1,1,45,115},{9,0,1,1,45,116},{10,0,1,1,45,116},{11,0,1,1,45,116},{12,1,1,1,45,116},{13,0,1,1,45,32},{14,1,1,1,45,32},{13,0,1,1,45,37},{14,1,1,1,45,37},{13,0,1,1,45,45},{14,1,1,1,45,45},{13,0,1,1,45,46},{14,1,1,1,45,46},{13,0,1,1,45,47},{14,1,1,1,45,47},{13,0,1,1,45,51},{14,1,1,1,45,51},{13,0,1,1,45,52},{14,1,1,1,45,52},{13,0,1,1,45,53},{14,1,1,1,45,53},{13,0,1,1,45,54},{14,1,1,1,45,54},{13,0,1,1,45,55},{14,1,1,1,45,55},{13,0,1,1,45,56},{14,1,1,1,45,56},{13,0,1,1,45,57},{14,1,1,1,45,57},{13,0,1,1,45,61},{14,1,1,1,45,61},{13,0,1,1,45,65},{14,1,1,1,45,65},{13,0,1,1,45,95},{14,1,1,1,45,95},{13,0,1,1,45,98},{14,1,1,1,45,98},{13,0,1,1,45,100},{14,1,1,1,45,100},{13,0,1,1,45,102},{14,1,1,1,45,102},{13,0,1,1,45,103},{14,1,1,1,45,103},{13,0,1,1,45,104},{14,1,1,1,45,104},{13,0,1,1,45,108},{14,1,1,1,45,108},{13,0,1,1,45,109},{14,1,1,1,45,109},{13,0,1,1,45,110},{14,1,1,1,45,110},{13,0,1,1,45,112},{14,1,1,1,45,112},{13,0,1,1,45,114},{14,1,1,1,45,114},{13,0,1,1,45,117},{14,1,1,1,45,117},{0,1,1,1,45,58},{0,1,1,1,45,66},{0,1,1,1,45,67},{0,1,1,1,45,68},{0,1,1,1,45,69},{0,1,1,1,45,70},{0,1,1,1,45,71},{0,1,1,1,45,72},{0,1,1,1,45,73},{0,1,1,1,45,74},{0,1,1,1,45,75},{0,1,1,1,45,76},{0,1,1,1,45,77},{0,1,1,1,45,78},{0,1,1,1,45,79},{0,1,1,1,45,80},{0,1,1,1,45,81},{0,1,1,1,45,82},{0,1,1,1,45,83},{0,1,1,1,45,84},{0,1,1,1,45,85},{0,1,1,1,45,86},{0,1,1,1,45,87},{0,1,1,1,45,89},{0,1,1,1,45,106},{0,1,1,1,45,107},{0,1,1,1,45,113},{0,1,1,1,45,118},{0,1,1,1,45,119},{0,1,1,1,45,120},{0,1,1,1,45,121},{0,1,1,1,45,122},{85,0,0,1,0,45},{86,0,0,1,0,45},{87,0,0,1,0,45},{88,1,0,1,0,45},{9,0,1,1,46,48},{10,0,1,1,46,48},{11,0,1,1,46,48},{12,1,1,1,46,48},{9,0,1,1,46,49},{10,0,1,1,46,49},{11,0,1,1,46,49},{12,1,1,1,46,49},{9,0,1,1,46,50},{10,0,1,1,46,50},{11,0,1,1,46,50},{12,1,1,1,46,50},{9,0,1,1,46,97},{10,0,1,1,46,97},{11,0,1,1,46,97},{12,1,1,1,46,97},{9,0,1,1,46,99},{10,0,1,1,46,99},{11,0,1,1,46,99},{12,1,1,1,46,99},{9,0,1,1,46,101},{10,0,1,1,46,101},{11,0,1,1,46,101},{12,1,1,1,46,101},{9,0,1,1,46,105},{10,0,1,1,46,105},{11,0,1,1,46,105},{12,1,1,1,46,105},{9,0,1,1,46,111},{10,0,1,1,46,111},{11,0,1,1,46,111},{12,1,1,1,46,111},{9,0,1,1,46,115},{10,0,1,1,46,115},{11,0,1,1,46,115},{12,1,1,1,46,115},{9,0,1,1,46,116},{10,0,1,1,46,116},{11,0,1,1,46,116},{12,1,1,1,46,116},{13,0,1,1,46,32},{14,1,1,1,46,32},{13,0,1,1,46,37},{14,1,1,1,46,37},{13,0,1,1,46,45},{14,1,1,1,46,45},{13,0,1,1,46,46},{14,1,1,1,46,46},{13,0,1,1,46,47},{14,1,1,1,46,47},{13,0,1,1,46,51},{14,1,1,1,46,51},{13,0,1,1,46,52},{14,1,1,1,46,52},{13,0,1,1,46,53},{14,1,1,1,46,53},{13,0,1,1,46,54},{14,1,1,1,46,54},{13,0,1,1,46,55},{14,1,1,1,46,55},{13,0,1,1,46,56},{14,1,1,1,46,56},{13,0,1,1,46,57},{14,1,1,1,46,57},{13,0,1,1,46,61},{14,1,1,1,46,61},{13,0,1,1,46,65},{14,1,1,1,46,65},{13,0,1,1,46,95},{14,1,1,1,46,95},{13,0,1,1,46,98},{14,1,1,1,46,98},{13,0,1,1,46,100},{14,1,1,1,46,100},{13,0,1,1,46,102},{14,1,1,1,46,102},{13,0,1,1,46,103},{14,1,1,1,46,103},{13,0,1,1,46,104},{14,1,1,1,46,104},{13,0,1,1,46,108},{14,1,1,1,46,108},{13,0,1,1,46,109},{14,1,1,1,46,109},{13,0,1,1,46,110},{14,1,1,1,46,110},{13,0,1,1,46,112},{14,1,1,1,46,112},{13,0,1,1,46,114},{14,1,1,1,46,114},{13,0,1,1,46,117},{14,1,1,1,46,117},{0,1,1,1,46,58},{0,1,1,1,46,66},{0,1,1,1,46,67},{0,1,1,1,46,68},{0,1,1,1,46,69},{0,1,1,1,46,70},{0,1,1,1,46,71},{0,1,1,1,46,72},{0,1,1,1,46,73},{0,1,1,1,46,74},{0,1,1,1,46,75},{0,1,1,1,46,76},{0,1,1,1,46,77},{0,1,1,1,46,78},{0,1,1,1,46,79},{0,1,1,1,46,80},{0,1,1,1,46,81},{0,1,1,1,46,82},{0,1,1,1,46,83},{0,1,1,1,46,84},{0,1,1,1,46,85},{0,1,1,1,46,86},{0,1,1,1,46,87},{0,1,1,1,46,89},{0,1,1,1,46,106},{0,1,1,1,46,107},{0,1,1,1,46,113},{0,1,1,1,46,118},{0,1,1,1,46,119},{0,1,1,1,46,120},{0,1,1,1,46,121},{0,1,1,1,46,122},{85,0,0,1,0,46},{86,0,0,1,0,46},{87,0,0,1,0,46},{88,1,0,1,0,46},{9,0,1,1,47,48},{10,0,1,1,47,48},{11,0,1,1,47,48},{12,1,1,1,47,48},{9,0,1,1,47,49},{10,0,1,1,47,49},{11,0,1,1,47,49},{12,1,1,1,47,49},{9,0,1,1,47,50},{10,0,1,1,47,50},{11,0,1,1,47,50},{12,1,1,1,47,50},{9,0,1,1,47,97},{10,0,1,1,47,97},{11,0,1,1,47,97},{12,1,1,1,47,97},{9,0,1,1,47,99},{10,0,1,1,47,99},{11,0,1,1,47,99},{12,1,1,1,47,99},{9,0,1,1,47,101},{10,0,1,1,47,101},{11,0,1,1,47,101},{12,1,1,1,47,101},{9,0,1,1,47,105},{10,0,1,1,47,105},{11,0,1,1,47,105},{12,1,1,1,47,105},{9,0,1,1,47,111},{10,0,1,1,47,111},{11,0,1,1,47,111},{12,1,1,1,47,111},{9,0,1,1,47,115},{10,0,1,1,47,115},{11,0,1,1,47,115},{12,1,1,1,47,115},{9,0,1,1,47,116},{10,0,1,1,47,116},{11,0,1,1,47,116},{12,1,1,1,47,116},{13,0,1,1,47,32},{14,1,1,1,47,32},{13,0,1,1,47,37},{14,1,1,1,47,37},{13,0,1,1,47,45},{14,1,1,1,47,45},{13,0,1,1,47,46},{14,1,1,1,47,46},{13,0,1,1,47,47},{14,1,1,1,47,47},{13,0,1,1,47,51},{14,1,1,1,47,51},{13,0,1,1,47,52},{14,1,1,1,47,52},{13,0,1,1,47,53},{14,1,1,1,47,53},{13,0,1,1,47,54},{14,1,1,1,47,54},{13,0,1,1,47,55},{14,1,1,1,47,55},{13,0,1,1,47,56},{14,1,1,1,47,56},{13,0,1,1,47,57},{14,1,1,1,47,57},{13,0,1,1,47,61},{14,1,1,1,47,61},{13,0,1,1,47,65},{14,1,1,1,47,65},{13,0,1,1,47,95},{14,1,1,1,47,95},{13,0,1,1,47,98},{14,1,1,1,47,98},{13,0,1,1,47,100},{14,1,1,1,47,100},{13,0,1,1,47,102},{14,1,1,1,47,102},{13,0,1,1,47,103},{14,1,1,1,47,103},{13,0,1,1,47,104},{14,1,1,1,47,104},{13,0,1,1,47,108},{14,1,1,1,47,108},{13,0,1,1,47,109},{14,1,1,1,47,109},{13,0,1,1,47,110},{14,1,1,1,47,110},{13,0,1,1,47,112},{14,1,1,1,47,112},{13,0,1,1,47,114},{14,1,1,1,47,114},{13,0,1,1,47,117},{14,1,1,1,47,117},{0,1,1,1,47,58},{0,1,1,1,47,66},{0,1,1,1,47,67},{0,1,1,1,47,68},{0,1,1,1,47,69},{0,1,1,1,47,70},{0,1,1,1,47,71},{0,1,1,1,47,72},{0,1,1,1,47,73},{0,1,1,1,47,74},{0,1,1,1,47,75},{0,1,1,1,47,76},{0,1,1,1,47,77},{0,1,1,1,47,78},{0,1,1,1,47,79},{0,1,1,1,47,80},{0,1,1,1,47,81},{0,1,1,1,47,82},{0,1,1,1,47,83},{0,1,1,1,47,84},{0,1,1,1,47,85},{0,1,1,1,47,86},{0,1,1,1,47,87},{0,1,1,1,47,89},{0,1,1,1,47,106},{0,1,1,1,47,107},{0,1,1,1,47,113},{0,1,1,1,47,118},{0,1,1,1,47,119},{0,1,1,1,47,120},{0,1,1,1,47,121},{0,1,1,1,47,122},{85,0,0,1,0,47},{86,0,0,1,0,47},{87,0,0,1,0,47},{88,1,0,1,0,47},{9,0,1,1,51,48},{10,0,1,1,51,48},{11,0,1,1,51,48},{12,1,1,1,51,48},{9,0,1,1,51,49},{10,0,1,1,51,49},{11,0,1,1,51,49},{12,1,1,1,51,49},{9,0,1,1,51,50},{10,0,1,1,51,50},{11,0,1,1,51,50},{12,1,1,1,51,50},{9,0,1,1,51,97},{10,0,1,1,51,97},{11,0,1,1,51,97},{12,1,1,1,51,97},{9,0,1,1,51,99},{10,0,1,1,51,99},{11,0,1,1,51,99},{12,1,1,1,51,99},{9,0,1,1,51,101},{10,0,1,1,51,101},{11,0,1,1,51,101},{12,1,1,1,51,101},{9,0,1,1,51,105},{10,0,1,1,51,105},{11,0,1,1,51,105},{12,1,1,1,51,105},{9,0,1,1,51,111},{10,0,1,1,51,111},{11,0,1,1,51,111},{12,1,1,1,51,111},{9,0,1,1,51,115},{10,0,1,1,51,115},{11,0,1,1,51,115},{12,1,1,1,51,115},{9,0,1,1,51,116},{10,0,1,1,51,116},{11,0,1,1,51,116},{12,1,1,1,51,116},{13,0,1,1,51,32},{14,1,1,1,51,32},{13,0,1,1,51,37},{14,1,1,1,51,37},{13,0,1,1,51,45},{14,1,1,1,51,45},{13,0,1,1,51,46},{14,1,1,1,51,46},{13,0,1,1,51,47},{14,1,1,1,51,47},{13,0,1,1,51,51},{14,1,1,1,51,51},{13,0,1,1,51,52},{14,1,1,1,51,52},{13,0,1,1,51,53},{14,1,1,1,51,53},{13,0,1,1,51,54},{14,1,1,1,51,54},{13,0,1,1,51,55},{14,1,1,1,51,55},{13,0,1,1,51,56},{14,1,1,1,51,56},{13,0,1,1,51,57},{14,1,1,1,51,57},{13,0,1,1,51,61},{14,1,1,1,51,61},{13,0,1,1,51,65},{14,1,1,1,51,65},{13,0,1,1,51,95},{14,1,1,1,51,95},{13,0,1,1,51,98},{14,1,1,1,51,98},{13,0,1,1,51,100},{14,1,1,1,51,100},{13,0,1,1,51,102},{14,1,1,1,51,102},{13,0,1,1,51,103},{14,1,1,1,51,103},{13,0,1,1,51,104},{14,1,1,1,51,104},{13,0,1,1,51,108},{14,1,1,1,51,108},{13,0,1,1,51,109},{14,1,1,1,51,109},{13,0,1,1,51,110},{14,1,1,1,51,110},{13,0,1,1,51,112},{14,1,1,1,51,112},{13,0,1,1,51,114},{14,1,1,1,51,114},{13,0,1,1,51,117},{14,1,1,1,51,117},{0,1,1,1,51,58},{0,1,1,1,51,66},{0,1,1,1,51,67},{0,1,1,1,51,68},{0,1,1,1,51,69},{0,1,1,1,51,70},{0,1,1,1,51,71},{0,1,1,1,51,72},{0,1,1,1,51,73},{0,1,1,1,51,74},{0,1,1,1,51,75},{0,1,1,1,51,76},{0,1,1,1,51,77},{0,1,1,1,51,78},{0,1,1,1,51,79},{0,1,1,1,51,80},{0,1,1,1,51,81},{0,1,1,1,51,82},{0,1,1,1,51,83},{0,1,1,1,51,84},{0,1,1,1,51,85},{0,1,1,1,51,86},{0,1,1,1,51,87},{0,1,1,1,51,89},{0,1,1,1,51,106},{0,1,1,1,51,107},{0,1,1,1,51,113},{0,1,1,1,51,118},{0,1,1,1,51,119},{0,1,1,1,51,120},{0,1,1,1,51,121},{0,1,1,1,51,122},{85,0,0,1,0,51},{86,0,0,1,0,51},{87,0,0,1,0,51},{88,1,0,1,0,51},{9,0,1,1,52,48},{10,0,1,1,52,48},{11,0,1,1,52,48},{12,1,1,1,52,48},{9,0,1,1,52,49},{10,0,1,1,52,49},{11,0,1,1,52,49},{12,1,1,1,52,49},{9,0,1,1,52,50},{10,0,1,1,52,50},{11,0,1,1,52,50},{12,1,1,1,52,50},{9,0,1,1,52,97},{10,0,1,1,52,97},{11,0,1,1,52,97},{12,1,1,1,52,97},{9,0,1,1,52,99},{10,0,1,1,52,99},{11,0,1,1,52,99},{12,1,1,1,52,99},{9,0,1,1,52,101},{10,0,1,1,52,101},{11,0,1,1,52,101},{12,1,1,1,52,101},{9,0,1,1,52,105},{10,0,1,1,52,105},{11,0,1,1,52,105},{12,1,1,1,52,105},{9,0,1,1,52,111},{10,0,1,1,52,111},{11,0,1,1,52,111},{12,1,1,1,52,111},{9,0,1,1,52,115},{10,0,1,1,52,115},{11,0,1,1,52,115},{12,1,1,1,52,115},{9,0,1,1,52,116},{10,0,1,1,52,116},{11,0,1,1,52,116},{12,1,1,1,52,116},{13,0,1,1,52,32},{14,1,1,1,52,32},{13,0,1,1,52,37},{14,1,1,1,52,37},{13,0,1,1,52,45},{14,1,1,1,52,45},{13,0,1,1,52,46},{14,1,1,1,52,46},{13,0,1,1,52,47},{14,1,1,1,52,47},{13,0,1,1,52,51},{14,1,1,1,52,51},{13,0,1,1,52,52},{14,1,1,1,52,52},{13,0,1,1,52,53},{14,1,1,1,52,53},{13,0,1,1,52,54},{14,1,1,1,52,54},{13,0,1,1,52,55},{14,1,1,1,52,55},{13,0,1,1,52,56},{14,1,1,1,52,56},{13,0,1,1,52,57},{14,1,1,1,52,57},{13,0,1,1,52,61},{14,1,1,1,52,61},{13,0,1,1,52,65},{14,1,1,1,52,65},{13,0,1,1,52,95},{14,1,1,1,52,95},{13,0,1,1,52,98},{14,1,1,1,52,98},{13,0,1,1,52,100},{14,1,1,1,52,100},{13,0,1,1,52,102},{14,1,1,1,52,102},{13,0,1,1,52,103},{14,1,1,1,52,103},{13,0,1,1,52,104},{14,1,1,1,52,104},{13,0,1,1,52,108},{14,1,1,1,52,108},{13,0,1,1,52,109},{14,1,1,1,52,109},{13,0,1,1,52,110},{14,1,1,1,52,110},{13,0,1,1,52,112},{14,1,1,1,52,112},{13,0,1,1,52,114},{14,1,1,1,52,114},{13,0,1,1,52,117},{14,1,1,1,52,117},{0,1,1,1,52,58},{0,1,1,1,52,66},{0,1,1,1,52,67},{0,1,1,1,52,68},{0,1,1,1,52,69},{0,1,1,1,52,70},{0,1,1,1,52,71},{0,1,1,1,52,72},{0,1,1,1,52,73},{0,1,1,1,52,74},{0,1,1,1,52,75},{0,1,1,1,52,76},{0,1,1,1,52,77},{0,1,1,1,52,78},{0,1,1,1,52,79},{0,1,1,1,52,80},{0,1,1,1,52,81},{0,1,1,1,52,82},{0,1,1,1,52,83},{0,1,1,1,52,84},{0,1,1,1,52,85},{0,1,1,1,52,86},{0,1,1,1,52,87},{0,1,1,1,52,89},{0,1,1,1,52,106},{0,1,1,1,52,107},{0,1,1,1,52,113},{0,1,1,1,52,118},{0,1,1,1,52,119},{0,1,1,1,52,120},{0,1,1,1,52,121},{0,1,1,1,52,122},{85,0,0,1,0,52},{86,0,0,1,0,52},{87,0,0,1,0,52},{88,1,0,1,0,52},{9,0,1,1,53,48},{10,0,1,1,53,48},{11,0,1,1,53,48},{12,1,1,1,53,48},{9,0,1,1,53,49},{10,0,1,1,53,49},{11,0,1,1,53,49},{12,1,1,1,53,49},{9,0,1,1,53,50},{10,0,1,1,53,50},{11,0,1,1,53,50},{12,1,1,1,53,50},{9,0,1,1,53,97},{10,0,1,1,53,97},{11,0,1,1,53,97},{12,1,1,1,53,97},{9,0,1,1,53,99},{10,0,1,1,53,99},{11,0,1,1,53,99},{12,1,1,1,53,99},{9,0,1,1,53,101},{10,0,1,1,53,101},{11,0,1,1,53,101},{12,1,1,1,53,101},{9,0,1,1,53,105},{10,0,1,1,53,105},{11,0,1,1,53,105},{12,1,1,1,53,105},{9,0,1,1,53,111},{10,0,1,1,53,111},{11,0,1,1,53,111},{12,1,1,1,53,111},{9,0,1,1,53,115},{10,0,1,1,53,115},{11,0,1,1,53,115},{12,1,1,1,53,115},{9,0,1,1,53,116},{10,0,1,1,53,116},{11,0,1,1,53,116},{12,1,1,1,53,116},{13,0,1,1,53,32},{14,1,1,1,53,32},{13,0,1,1,53,37},{14,1,1,1,53,37},{13,0,1,1,53,45},{14,1,1,1,53,45},{13,0,1,1,53,46},{14,1,1,1,53,46},{13,0,1,1,53,47},{14,1,1,1,53,47},{13,0,1,1,53,51},{14,1,1,1,53,51},{13,0,1,1,53,52},{14,1,1,1,53,52},{13,0,1,1,53,53},{14,1,1,1,53,53},{13,0,1,1,53,54},{14,1,1,1,53,54},{13,0,1,1,53,55},{14,1,1,1,53,55},{13,0,1,1,53,56},{14,1,1,1,53,56},{13,0,1,1,53,57},{14,1,1,1,53,57},{13,0,1,1,53,61},{14,1,1,1,53,61},{13,0,1,1,53,65},{14,1,1,1,53,65},{13,0,1,1,53,95},{14,1,1,1,53,95},{13,0,1,1,53,98},{14,1,1,1,53,98},{13,0,1,1,53,100},{14,1,1,1,53,100},{13,0,1,1,53,102},{14,1,1,1,53,102},{13,0,1,1,53,103},{14,1,1,1,53,103},{13,0,1,1,53,104},{14,1,1,1,53,104},{13,0,1,1,53,108},{14,1,1,1,53,108},{13,0,1,1,53,109},{14,1,1,1,53,109},{13,0,1,1,53,110},{14,1,1,1,53,110},{13,0,1,1,53,112},{14,1,1,1,53,112},{13,0,1,1,53,114},{14,1,1,1,53,114},{13,0,1,1,53,117},{14,1,1,1,53,117},{0,1,1,1,53,58},{0,1,1,1,53,66},{0,1,1,1,53,67},{0,1,1,1,53,68},{0,1,1,1,53,69},{0,1,1,1,53,70},{0,1,1,1,53,71},{0,1,1,1,53,72},{0,1,1,1,53,73},{0,1,1,1,53,74},{0,1,1,1,53,75},{0,1,1,1,53,76},{0,1,1,1,53,77},{0,1,1,1,53,78},{0,1,1,1,53,79},{0,1,1,1,53,80},{0,1,1,1,53,81},{0,1,1,1,53,82},{0,1,1,1,53,83},{0,1,1,1,53,84},{0,1,1,1,53,85},{0,1,1,1,53,86},{0,1,1,1,53,87},{0,1,1,1,53,89},{0,1,1,1,53,106},{0,1,1,1,53,107},{0,1,1,1,53,113},{0,1,1,1,53,118},{0,1,1,1,53,119},{0,1,1,1,53,120},{0,1,1,1,53,121},{0,1,1,1,53,122},{85,0,0,1,0,53},{86,0,0,1,0,53},{87,0,0,1,0,53},{88,1,0,1,0,53},{9,0,1,1,54,48},{10,0,1,1,54,48},{11,0,1,1,54,48},{12,1,1,1,54,48},{9,0,1,1,54,49},{10,0,1,1,54,49},{11,0,1,1,54,49},{12,1,1,1,54,49},{9,0,1,1,54,50},{10,0,1,1,54,50},{11,0,1,1,54,50},{12,1,1,1,54,50},{9,0,1,1,54,97},{10,0,1,1,54,97},{11,0,1,1,54,97},{12,1,1,1,54,97},{9,0,1,1,54,99},{10,0,1,1,54,99},{11,0,1,1,54,99},{12,1,1,1,54,99},{9,0,1,1,54,101},{10,0,1,1,54,101},{11,0,1,1,54,101},{12,1,1,1,54,101},{9,0,1,1,54,105},{10,0,1,1,54,105},{11,0,1,1,54,105},{12,1,1,1,54,105},{9,0,1,1,54,111},{10,0,1,1,54,111},{11,0,1,1,54,111},{12,1,1,1,54,111},{9,0,1,1,54,115},{10,0,1,1,54,115},{11,0,1,1,54,115},{12,1,1,1,54,115},{9,0,1,1,54,116},{10,0,1,1,54,116},{11,0,1,1,54,116},{12,1,1,1,54,116},{13,0,1,1,54,32},{14,1,1,1,54,32},{13,0,1,1,54,37},{14,1,1,1,54,37},{13,0,1,1,54,45},{14,1,1,1,54,45},{13,0,1,1,54,46},{14,1,1,1,54,46},{13,0,1,1,54,47},{14,1,1,1,54,47},{13,0,1,1,54,51},{14,1,1,1,54,51},{13,0,1,1,54,52},{14,1,1,1,54,52},{13,0,1,1,54,53},{14,1,1,1,54,53},{13,0,1,1,54,54},{14,1,1,1,54,54},{13,0,1,1,54,55},{14,1,1,1,54,55},{13,0,1,1,54,56},{14,1,1,1,54,56},{13,0,1,1,54,57},{14,1,1,1,54,57},{13,0,1,1,54,61},{14,1,1,1,54,61},{13,0,1,1,54,65},{14,1,1,1,54,65},{13,0,1,1,54,95},{14,1,1,1,54,95},{13,0,1,1,54,98},{14,1,1,1,54,98},{13,0,1,1,54,100},{14,1,1,1,54,100},{13,0,1,1,54,102},{14,1,1,1,54,102},{13,0,1,1,54,103},{14,1,1,1,54,103},{13,0,1,1,54,104},{14,1,1,1,54,104},{13,0,1,1,54,108},{14,1,1,1,54,108},{13,0,1,1,54,109},{14,1,1,1,54,109},{13,0,1,1,54,110},{14,1,1,1,54,110},{13,0,1,1,54,112},{14,1,1,1,54,112},{13,0,1,1,54,114},{14,1,1,1,54,114},{13,0,1,1,54,117},{14,1,1,1,54,117},{0,1,1,1,54,58},{0,1,1,1,54,66},{0,1,1,1,54,67},{0,1,1,1,54,68},{0,1,1,1,54,69},{0,1,1,1,54,70},{0,1,1,1,54,71},{0,1,1,1,54,72},{0,1,1,1,54,73},{0,1,1,1,54,74},{0,1,1,1,54,75},{0,1,1,1,54,76},{0,1,1,1,54,77},{0,1,1,1,54,78},{0,1,1,1,54,79},{0,1,1,1,54,80},{0,1,1,1,54,81},{0,1,1,1,54,82},{0,1,1,1,54,83},{0,1,1,1,54,84},{0,1,1,1,54,85},{0,1,1,1,54,86},{0,1,1,1,54,87},{0,1,1,1,54,89},{0,1,1,1,54,106},{0,1,1,1,54,107},{0,1,1,1,54,113},{0,1,1,1,54,118},{0,1,1,1,54,119},{0,1,1,1,54,120},{0,1,1,1,54,121},{0,1,1,1,54,122},{85,0,0,1,0,54},{86,0,0,1,0,54},{87,0,0,1,0,54},{88,1,0,1,0,54},{9,0,1,1,55,48},{10,0,1,1,55,48},{11,0,1,1,55,48},{12,1,1,1,55,48},{9,0,1,1,55,49},{10,0,1,1,55,49},{11,0,1,1,55,49},{12,1,1,1,55,49},{9,0,1,1,55,50},{10,0,1,1,55,50},{11,0,1,1,55,50},{12,1,1,1,55,50},{9,0,1,1,55,97},{10,0,1,1,55,97},{11,0,1,1,55,97},{12,1,1,1,55,97},{9,0,1,1,55,99},{10,0,1,1,55,99},{11,0,1,1,55,99},{12,1,1,1,55,99},{9,0,1,1,55,101},{10,0,1,1,55,101},{11,0,1,1,55,101},{12,1,1,1,55,101},{9,0,1,1,55,105},{10,0,1,1,55,105},{11,0,1,1,55,105},{12,1,1,1,55,105},{9,0,1,1,55,111},{10,0,1,1,55,111},{11,0,1,1,55,111},{12,1,1,1,55,111},{9,0,1,1,55,115},{10,0,1,1,55,115},{11,0,1,1,55,115},{12,1,1,1,55,115},{9,0,1,1,55,116},{10,0,1,1,55,116},{11,0,1,1,55,116},{12,1,1,1,55,116},{13,0,1,1,55,32},{14,1,1,1,55,32},{13,0,1,1,55,37},{14,1,1,1,55,37},{13,0,1,1,55,45},{14,1,1,1,55,45},{13,0,1,1,55,46},{14,1,1,1,55,46},{13,0,1,1,55,47},{14,1,1,1,55,47},{13,0,1,1,55,51},{14,1,1,1,55,51},{13,0,1,1,55,52},{14,1,1,1,55,52},{13,0,1,1,55,53},{14,1,1,1,55,53},{13,0,1,1,55,54},{14,1,1,1,55,54},{13,0,1,1,55,55},{14,1,1,1,55,55},{13,0,1,1,55,56},{14,1,1,1,55,56},{13,0,1,1,55,57},{14,1,1,1,55,57},{13,0,1,1,55,61},{14,1,1,1,55,61},{13,0,1,1,55,65},{14,1,1,1,55,65},{13,0,1,1,55,95},{14,1,1,1,55,95},{13,0,1,1,55,98},{14,1,1,1,55,98},{13,0,1,1,55,100},{14,1,1,1,55,100},{13,0,1,1,55,102},{14,1,1,1,55,102},{13,0,1,1,55,103},{14,1,1,1,55,103},{13,0,1,1,55,104},{14,1,1,1,55,104},{13,0,1,1,55,108},{14,1,1,1,55,108},{13,0,1,1,55,109},{14,1,1,1,55,109},{13,0,1,1,55,110},{14,1,1,1,55,110},{13,0,1,1,55,112},{14,1,1,1,55,112},{13,0,1,1,55,114},{14,1,1,1,55,114},{13,0,1,1,55,117},{14,1,1,1,55,117},{0,1,1,1,55,58},{0,1,1,1,55,66},{0,1,1,1,55,67},{0,1,1,1,55,68},{0,1,1,1,55,69},{0,1,1,1,55,70},{0,1,1,1,55,71},{0,1,1,1,55,72},{0,1,1,1,55,73},{0,1,1,1,55,74},{0,1,1,1,55,75},{0,1,1,1,55,76},{0,1,1,1,55,77},{0,1,1,1,55,78},{0,1,1,1,55,79},{0,1,1,1,55,80},{0,1,1,1,55,81},{0,1,1,1,55,82},{0,1,1,1,55,83},{0,1,1,1,55,84},{0,1,1,1,55,85},{0,1,1,1,55,86},{0,1,1,1,55,87},{0,1,1,1,55,89},{0,1,1,1,55,106},{0,1,1,1,55,107},{0,1,1,1,55,113},{0,1,1,1,55,118},{0,1,1,1,55,119},{0,1,1,1,55,120},{0,1,1,1,55,121},{0,1,1,1,55,122},{85,0,0,1,0,55},{86,0,0,1,0,55},{87,0,0,1,0,55},{88,1,0,1,0,55},{9,0,1,1,56,48},{10,0,1,1,56,48},{11,0,1,1,56,48},{12,1,1,1,56,48},{9,0,1,1,56,49},{10,0,1,1,56,49},{11,0,1,1,56,49},{12,1,1,1,56,49},{9,0,1,1,56,50},{10,0,1,1,56,50},{11,0,1,1,56,50},{12,1,1,1,56,50},{9,0,1,1,56,97},{10,0,1,1,56,97},{11,0,1,1,56,97},{12,1,1,1,56,97},{9,0,1,1,56,99},{10,0,1,1,56,99},{11,0,1,1,56,99},{12,1,1,1,56,99},{9,0,1,1,56,101},{10,0,1,1,56,101},{11,0,1,1,56,101},{12,1,1,1,56,101},{9,0,1,1,56,105},{10,0,1,1,56,105},{11,0,1,1,56,105},{12,1,1,1,56,105},{9,0,1,1,56,111},{10,0,1,1,56,111},{11,0,1,1,56,111},{12,1,1,1,56,111},{9,0,1,1,56,115},{10,0,1,1,56,115},{11,0,1,1,56,115},{12,1,1,1,56,115},{9,0,1,1,56,116},{10,0,1,1,56,116},{11,0,1,1,56,116},{12,1,1,1,56,116},{13,0,1,1,56,32},{14,1,1,1,56,32},{13,0,1,1,56,37},{14,1,1,1,56,37},{13,0,1,1,56,45},{14,1,1,1,56,45},{13,0,1,1,56,46},{14,1,1,1,56,46},{13,0,1,1,56,47},{14,1,1,1,56,47},{13,0,1,1,56,51},{14,1,1,1,56,51},{13,0,1,1,56,52},{14,1,1,1,56,52},{13,0,1,1,56,53},{14,1,1,1,56,53},{13,0,1,1,56,54},{14,1,1,1,56,54},{13,0,1,1,56,55},{14,1,1,1,56,55},{13,0,1,1,56,56},{14,1,1,1,56,56},{13,0,1,1,56,57},{14,1,1,1,56,57},{13,0,1,1,56,61},{14,1,1,1,56,61},{13,0,1,1,56,65},{14,1,1,1,56,65},{13,0,1,1,56,95},{14,1,1,1,56,95},{13,0,1,1,56,98},{14,1,1,1,56,98},{13,0,1,1,56,100},{14,1,1,1,56,100},{13,0,1,1,56,102},{14,1,1,1,56,102},{13,0,1,1,56,103},{14,1,1,1,56,103},{13,0,1,1,56,104},{14,1,1,1,56,104},{13,0,1,1,56,108},{14,1,1,1,56,108},{13,0,1,1,56,109},{14,1,1,1,56,109},{13,0,1,1,56,110},{14,1,1,1,56,110},{13,0,1,1,56,112},{14,1,1,1,56,112},{13,0,1,1,56,114},{14,1,1,1,56,114},{13,0,1,1,56,117},{14,1,1,1,56,117},{0,1,1,1,56,58},{0,1,1,1,56,66},{0,1,1,1,56,67},{0,1,1,1,56,68},{0,1,1,1,56,69},{0,1,1,1,56,70},{0,1,1,1,56,71},{0,1,1,1,56,72},{0,1,1,1,56,73},{0,1,1,1,56,74},{0,1,1,1,56,75},{0,1,1,1,56,76},{0,1,1,1,56,77},{0,1,1,1,56,78},{0,1,1,1,56,79},{0,1,1,1,56,80},{0,1,1,1,56,81},{0,1,1,1,56,82},{0,1,1,1,56,83},{0,1,1,1,56,84},{0,1,1,1,56,85},{0,1,1,1,56,86},{0,1,1,1,56,87},{0,1,1,1,56,89},{0,1,1,1,56,106},{0,1,1,1,56,107},{0,1,1,1,56,113},{0,1,1,1,56,118},{0,1,1,1,56,119},{0,1,1,1,56,120},{0,1,1,1,56,121},{0,1,1,1,56,122},{85,0,0,1,0,56},{86,0,0,1,0,56},{87,0,0,1,0,56},{88,1,0,1,0,56},{9,0,1,1,57,48},{10,0,1,1,57,48},{11,0,1,1,57,48},{12,1,1,1,57,48},{9,0,1,1,57,49},{10,0,1,1,57,49},{11,0,1,1,57,49},{12,1,1,1,57,49},{9,0,1,1,57,50},{10,0,1,1,57,50},{11,0,1,1,57,50},{12,1,1,1,57,50},{9,0,1,1,57,97},{10,0,1,1,57,97},{11,0,1,1,57,97},{12,1,1,1,57,97},{9,0,1,1,57,99},{10,0,1,1,57,99},{11,0,1,1,57,99},{12,1,1,1,57,99},{9,0,1,1,57,101},{10,0,1,1,57,101},{11,0,1,1,57,101},{12,1,1,1,57,101},{9,0,1,1,57,105},{10,0,1,1,57,105},{11,0,1,1,57,105},{12,1,1,1,57,105},{9,0,1,1,57,111},{10,0,1,1,57,111},{11,0,1,1,57,111},{12,1,1,1,57,111},{9,0,1,1,57,115},{10,0,1,1,57,115},{11,0,1,1,57,115},{12,1,1,1,57,115},{9,0,1,1,57,116},{10,0,1,1,57,116},{11,0,1,1,57,116},{12,1,1,1,57,116},{13,0,1,1,57,32},{14,1,1,1,57,32},{13,0,1,1,57,37},{14,1,1,1,57,37},{13,0,1,1,57,45},{14,1,1,1,57,45},{13,0,1,1,57,46},{14,1,1,1,57,46},{13,0,1,1,57,47},{14,1,1,1,57,47},{13,0,1,1,57,51},{14,1,1,1,57,51},{13,0,1,1,57,52},{14,1,1,1,57,52},{13,0,1,1,57,53},{14,1,1,1,57,53},{13,0,1,1,57,54},{14,1,1,1,57,54},{13,0,1,1,57,55},{14,1,1,1,57,55},{13,0,1,1,57,56},{14,1,1,1,57,56},{13,0,1,1,57,57},{14,1,1,1,57,57},{13,0,1,1,57,61},{14,1,1,1,57,61},{13,0,1,1,57,65},{14,1,1,1,57,65},{13,0,1,1,57,95},{14,1,1,1,57,95},{13,0,1,1,57,98},{14,1,1,1,57,98},{13,0,1,1,57,100},{14,1,1,1,57,100},{13,0,1,1,57,102},{14,1,1,1,57,102},{13,0,1,1,57,103},{14,1,1,1,57,103},{13,0,1,1,57,104},{14,1,1,1,57,104},{13,0,1,1,57,108},{14,1,1,1,57,108},{13,0,1,1,57,109},{14,1,1,1,57,109},{13,0,1,1,57,110},{14,1,1,1,57,110},{13,0,1,1,57,112},{14,1,1,1,57,112},{13,0,1,1,57,114},{14,1,1,1,57,114},{13,0,1,1,57,117},{14,1,1,1,57,117},{0,1,1,1,57,58},{0,1,1,1,57,66},{0,1,1,1,57,67},{0,1,1,1,57,68},{0,1,1,1,57,69},{0,1,1,1,57,70},{0,1,1,1,57,71},{0,1,1,1,57,72},{0,1,1,1,57,73},{0,1,1,1,57,74},{0,1,1,1,57,75},{0,1,1,1,57,76},{0,1,1,1,57,77},{0,1,1,1,57,78},{0,1,1,1,57,79},{0,1,1,1,57,80},{0,1,1,1,57,81},{0,1,1,1,57,82},{0,1,1,1,57,83},{0,1,1,1,57,84},{0,1,1,1,57,85},{0,1,1,1,57,86},{0,1,1,1,57,87},{0,1,1,1,57,89},{0,1,1,1,57,106},{0,1,1,1,57,107},{0,1,1,1,57,113},{0,1,1,1,57,118},{0,1,1,1,57,119},{0,1,1,1,57,120},{0,1,1,1,57,121},{0,1,1,1,57,122},{85,0,0,1,0,57},{86,0,0,1,0,57},{87,0,0,1,0,57},{88,1,0,1,0,57},{9,0,1,1,61,48},{10,0,1,1,61,48},{11,0,1,1,61,48},{12,1,1,1,61,48},{9,0,1,1,61,49},{10,0,1,1,61,49},{11,0,1,1,61,49},{12,1,1,1,61,49},{9,0,1,1,61,50},{10,0,1,1,61,50},{11,0,1,1,61,50},{12,1,1,1,61,50},{9,0,1,1,61,97},{10,0,1,1,61,97},{11,0,1,1,61,97},{12,1,1,1,61,97},{9,0,1,1,61,99},{10,0,1,1,61,99},{11,0,1,1,61,99},{12,1,1,1,61,99},{9,0,1,1,61,101},{10,0,1,1,61,101},{11,0,1,1,61,101},{12,1,1,1,61,101},{9,0,1,1,61,105},{10,0,1,1,61,105},{11,0,1,1,61,105},{12,1,1,1,61,105},{9,0,1,1,61,111},{10,0,1,1,61,111},{11,0,1,1,61,111},{12,1,1,1,61,111},{9,0,1,1,61,115},{10,0,1,1,61,115},{11,0,1,1,61,115},{12,1,1,1,61,115},{9,0,1,1,61,116},{10,0,1,1,61,116},{11,0,1,1,61,116},{12,1,1,1,61,116},{13,0,1,1,61,32},{14,1,1,1,61,32},{13,0,1,1,61,37},{14,1,1,1,61,37},{13,0,1,1,61,45},{14,1,1,1,61,45},{13,0,1,1,61,46},{14,1,1,1,61,46},{13,0,1,1,61,47},{14,1,1,1,61,47},{13,0,1,1,61,51},{14,1,1,1,61,51},{13,0,1,1,61,52},{14,1,1,1,61,52},{13,0,1,1,61,53},{14,1,1,1,61,53},{13,0,1,1,61,54},{14,1,1,1,61,54},{13,0,1,1,61,55},{14,1,1,1,61,55},{13,0,1,1,61,56},{14,1,1,1,61,56},{13,0,1,1,61,57},{14,1,1,1,61,57},{13,0,1,1,61,61},{14,1,1,1,61,61},{13,0,1,1,61,65},{14,1,1,1,61,65},{13,0,1,1,61,95},{14,1,1,1,61,95},{13,0,1,1,61,98},{14,1,1,1,61,98},{13,0,1,1,61,100},{14,1,1,1,61,100},{13,0,1,1,61,102},{14,1,1,1,61,102},{13,0,1,1,61,103},{14,1,1,1,61,103},{13,0,1,1,61,104},{14,1,1,1,61,104},{13,0,1,1,61,108},{14,1,1,1,61,108},{13,0,1,1,61,109},{14,1,1,1,61,109},{13,0,1,1,61,110},{14,1,1,1,61,110},{13,0,1,1,61,112},{14,1,1,1,61,112},{13,0,1,1,61,114},{14,1,1,1,61,114},{13,0,1,1,61,117},{14,1,1,1,61,117},{0,1,1,1,61,58},{0,1,1,1,61,66},{0,1,1,1,61,67},{0,1,1,1,61,68},{0,1,1,1,61,69},{0,1,1,1,61,70},{0,1,1,1,61,71},{0,1,1,1,61,72},{0,1,1,1,61,73},{0,1,1,1,61,74},{0,1,1,1,61,75},{0,1,1,1,61,76},{0,1,1,1,61,77},{0,1,1,1,61,78},{0,1,1,1,61,79},{0,1,1,1,61,80},{0,1,1,1,61,81},{0,1,1,1,61,82},{0,1,1,1,61,83},{0,1,1,1,61,84},{0,1,1,1,61,85},{0,1,1,1,61,86},{0,1,1,1,61,87},{0,1,1,1,61,89},{0,1,1,1,61,106},{0,1,1,1,61,107},{0,1,1,1,61,113},{0,1,1,1,61,118},{0,1,1,1,61,119},{0,1,1,1,61,120},{0,1,1,1,61,121},{0,1,1,1,61,122},{85,0,0,1,0,61},{86,0,0,1,0,61},{87,0,0,1,0,61},{88,1,0,1,0,61},{9,0,1,1,65,48},{10,0,1,1,65,48},{11,0,1,1,65,48},{12,1,1,1,65,48},{9,0,1,1,65,49},{10,0,1,1,65,49},{11,0,1,1,65,49},{12,1,1,1,65,49},{9,0,1,1,65,50},{10,0,1,1,65,50},{11,0,1,1,65,50},{12,1,1,1,65,50},{9,0,1,1,65,97},{10,0,1,1,65,97},{11,0,1,1,65,97},{12,1,1,1,65,97},{9,0,1,1,65,99},{10,0,1,1,65,99},{11,0,1,1,65,99},{12,1,1,1,65,99},{9,0,1,1,65,101},{10,0,1,1,65,101},{11,0,1,1,65,101},{12,1,1,1,65,101},{9,0,1,1,65,105},{10,0,1,1,65,105},{11,0,1,1,65,105},{12,1,1,1,65,105},{9,0,1,1,65,111},{10,0,1,1,65,111},{11,0,1,1,65,111},{12,1,1,1,65,111},{9,0,1,1,65,115},{10,0,1,1,65,115},{11,0,1,1,65,115},{12,1,1,1,65,115},{9,0,1,1,65,116},{10,0,1,1,65,116},{11,0,1,1,65,116},{12,1,1,1,65,116},{13,0,1,1,65,32},{14,1,1,1,65,32},{13,0,1,1,65,37},{14,1,1,1,65,37},{13,0,1,1,65,45},{14,1,1,1,65,45},{13,0,1,1,65,46},{14,1,1,1,65,46},{13,0,1,1,65,47},{14,1,1,1,65,47},{13,0,1,1,65,51},{14,1,1,1,65,51},{13,0,1,1,65,52},{14,1,1,1,65,52},{13,0,1,1,65,53},{14,1,1,1,65,53},{13,0,1,1,65,54},{14,1,1,1,65,54},{13,0,1,1,65,55},{14,1,1,1,65,55},{13,0,1,1,65,56},{14,1,1,1,65,56},{13,0,1,1,65,57},{14,1,1,1,65,57},{13,0,1,1,65,61},{14,1,1,1,65,61},{13,0,1,1,65,65},{14,1,1,1,65,65},{13,0,1,1,65,95},{14,1,1,1,65,95},{13,0,1,1,65,98},{14,1,1,1,65,98},{13,0,1,1,65,100},{14,1,1,1,65,100},{13,0,1,1,65,102},{14,1,1,1,65,102},{13,0,1,1,65,103},{14,1,1,1,65,103},{13,0,1,1,65,104},{14,1,1,1,65,104},{13,0,1,1,65,108},{14,1,1,1,65,108},{13,0,1,1,65,109},{14,1,1,1,65,109},{13,0,1,1,65,110},{14,1,1,1,65,110},{13,0,1,1,65,112},{14,1,1,1,65,112},{13,0,1,1,65,114},{14,1,1,1,65,114},{13,0,1,1,65,117},{14,1,1,1,65,117},{0,1,1,1,65,58},{0,1,1,1,65,66},{0,1,1,1,65,67},{0,1,1,1,65,68},{0,1,1,1,65,69},{0,1,1,1,65,70},{0,1,1,1,65,71},{0,1,1,1,65,72},{0,1,1,1,65,73},{0,1,1,1,65,74},{0,1,1,1,65,75},{0,1,1,1,65,76},{0,1,1,1,65,77},{0,1,1,1,65,78},{0,1,1,1,65,79},{0,1,1,1,65,80},{0,1,1,1,65,81},{0,1,1,1,65,82},{0,1,1,1,65,83},{0,1,1,1,65,84},{0,1,1,1,65,85},{0,1,1,1,65,86},{0,1,1,1,65,87},{0,1,1,1,65,89},{0,1,1,1,65,106},{0,1,1,1,65,107},{0,1,1,1,65,113},{0,1,1,1,65,118},{0,1,1,1,65,119},{0,1,1,1,65,120},{0,1,1,1,65,121},{0,1,1,1,65,122},{85,0,0,1,0,65},{86,0,0,1,0,65},{87,0,0,1,0,65},{88,1,0,1,0,65},{9,0,1,1,95,48},{10,0,1,1,95,48},{11,0,1,1,95,48},{12,1,1,1,95,48},{9,0,1,1,95,49},{10,0,1,1,95,49},{11,0,1,1,95,49},{12,1,1,1,95,49},{9,0,1,1,95,50},{10,0,1,1,95,50},{11,0,1,1,95,50},{12,1,1,1,95,50},{9,0,1,1,95,97},{10,0,1,1,95,97},{11,0,1,1,95,97},{12,1,1,1,95,97},{9,0,1,1,95,99},{10,0,1,1,95,99},{11,0,1,1,95,99},{12,1,1,1,95,99},{9,0,1,1,95,101},{10,0,1,1,95,101},{11,0,1,1,95,101},{12,1,1,1,95,101},{9,0,1,1,95,105},{10,0,1,1,95,105},{11,0,1,1,95,105},{12,1,1,1,95,105},{9,0,1,1,95,111},{10,0,1,1,95,111},{11,0,1,1,95,111},{12,1,1,1,95,111},{9,0,1,1,95,115},{10,0,1,1,95,115},{11,0,1,1,95,115},{12,1,1,1,95,115},{9,0,1,1,95,116},{10,0,1,1,95,116},{11,0,1,1,95,116},{12,1,1,1,95,116},{13,0,1,1,95,32},{14,1,1,1,95,32},{13,0,1,1,95,37},{14,1,1,1,95,37},{13,0,1,1,95,45},{14,1,1,1,95,45},{13,0,1,1,95,46},{14,1,1,1,95,46},{13,0,1,1,95,47},{14,1,1,1,95,47},{13,0,1,1,95,51},{14,1,1,1,95,51},{13,0,1,1,95,52},{14,1,1,1,95,52},{13,0,1,1,95,53},{14,1,1,1,95,53},{13,0,1,1,95,54},{14,1,1,1,95,54},{13,0,1,1,95,55},{14,1,1,1,95,55},{13,0,1,1,95,56},{14,1,1,1,95,56},{13,0,1,1,95,57},{14,1,1,1,95,57},{13,0,1,1,95,61},{14,1,1,1,95,61},{13,0,1,1,95,65},{14,1,1,1,95,65},{13,0,1,1,95,95},{14,1,1,1,95,95},{13,0,1,1,95,98},{14,1,1,1,95,98},{13,0,1,1,95,100},{14,1,1,1,95,100},{13,0,1,1,95,102},{14,1,1,1,95,102},{13,0,1,1,95,103},{14,1,1,1,95,103},{13,0,1,1,95,104},{14,1,1,1,95,104},{13,0,1,1,95,108},{14,1,1,1,95,108},{13,0,1,1,95,109},{14,1,1,1,95,109},{13,0,1,1,95,110},{14,1,1,1,95,110},{13,0,1,1,95,112},{14,1,1,1,95,112},{13,0,1,1,95,114},{14,1,1,1,95,114},{13,0,1,1,95,117},{14,1,1,1,95,117},{0,1,1,1,95,58},{0,1,1,1,95,66},{0,1,1,1,95,67},{0,1,1,1,95,68},{0,1,1,1,95,69},{0,1,1,1,95,70},{0,1,1,1,95,71},{0,1,1,1,95,72},{0,1,1,1,95,73},{0,1,1,1,95,74},{0,1,1,1,95,75},{0,1,1,1,95,76},{0,1,1,1,95,77},{0,1,1,1,95,78},{0,1,1,1,95,79},{0,1,1,1,95,80},{0,1,1,1,95,81},{0,1,1,1,95,82},{0,1,1,1,95,83},{0,1,1,1,95,84},{0,1,1,1,95,85},{0,1,1,1,95,86},{0,1,1,1,95,87},{0,1,1,1,95,89},{0,1,1,1,95,106},{0,1,1,1,95,107},{0,1,1,1,95,113},{0,1,1,1,95,118},{0,1,1,1,95,119},{0,1,1,1,95,120},{0,1,1,1,95,121},{0,1,1,1,95,122},{85,0,0,1,0,95},{86,0,0,1,0,95},{87,0,0,1,0,95},{88,1,0,1,0,95},{9,0,1,1,98,48},{10,0,1,1,98,48},{11,0,1,1,98,48},{12,1,1,1,98,48},{9,0,1,1,98,49},{10,0,1,1,98,49},{11,0,1,1,98,49},{12,1,1,1,98,49},{9,0,1,1,98,50},{10,0,1,1,98,50},{11,0,1,1,98,50},{12,1,1,1,98,50},{9,0,1,1,98,97},{10,0,1,1,98,97},{11,0,1,1,98,97},{12,1,1,1,98,97},{9,0,1,1,98,99},{10,0,1,1,98,99},{11,0,1,1,98,99},{12,1,1,1,98,99},{9,0,1,1,98,101},{10,0,1,1,98,101},{11,0,1,1,98,101},{12,1,1,1,98,101},{9,0,1,1,98,105},{10,0,1,1,98,105},{11,0,1,1,98,105},{12,1,1,1,98,105},{9,0,1,1,98,111},{10,0,1,1,98,111},{11,0,1,1,98,111},{12,1,1,1,98,111},{9,0,1,1,98,115},{10,0,1,1,98,115},{11,0,1,1,98,115},{12,1,1,1,98,115},{9,0,1,1,98,116},{10,0,1,1,98,116},{11,0,1,1,98,116},{12,1,1,1,98,116},{13,0,1,1,98,32},{14,1,1,1,98,32},{13,0,1,1,98,37},{14,1,1,1,98,37},{13,0,1,1,98,45},{14,1,1,1,98,45},{13,0,1,1,98,46},{14,1,1,1,98,46},{13,0,1,1,98,47},{14,1,1,1,98,47},{13,0,1,1,98,51},{14,1,1,1,98,51},{13,0,1,1,98,52},{14,1,1,1,98,52},{13,0,1,1,98,53},{14,1,1,1,98,53},{13,0,1,1,98,54},{14,1,1,1,98,54},{13,0,1,1,98,55},{14,1,1,1,98,55},{13,0,1,1,98,56},{14,1,1,1,98,56},{13,0,1,1,98,57},{14,1,1,1,98,57},{13,0,1,1,98,61},{14,1,1,1,98,61},{13,0,1,1,98,65},{14,1,1,1,98,65},{13,0,1,1,98,95},{14,1,1,1,98,95},{13,0,1,1,98,98},{14,1,1,1,98,98},{13,0,1,1,98,100},{14,1,1,1,98,100},{13,0,1,1,98,102},{14,1,1,1,98,102},{13,0,1,1,98,103},{14,1,1,1,98,103},{13,0,1,1,98,104},{14,1,1,1,98,104},{13,0,1,1,98,108},{14,1,1,1,98,108},{13,0,1,1,98,109},{14,1,1,1,98,109},{13,0,1,1,98,110},{14,1,1,1,98,110},{13,0,1,1,98,112},{14,1,1,1,98,112},{13,0,1,1,98,114},{14,1,1,1,98,114},{13,0,1,1,98,117},{14,1,1,1,98,117},{0,1,1,1,98,58},{0,1,1,1,98,66},{0,1,1,1,98,67},{0,1,1,1,98,68},{0,1,1,1,98,69},{0,1,1,1,98,70},{0,1,1,1,98,71},{0,1,1,1,98,72},{0,1,1,1,98,73},{0,1,1,1,98,74},{0,1,1,1,98,75},{0,1,1,1,98,76},{0,1,1,1,98,77},{0,1,1,1,98,78},{0,1,1,1,98,79},{0,1,1,1,98,80},{0,1,1,1,98,81},{0,1,1,1,98,82},{0,1,1,1,98,83},{0,1,1,1,98,84},{0,1,1,1,98,85},{0,1,1,1,98,86},{0,1,1,1,98,87},{0,1,1,1,98,89},{0,1,1,1,98,106},{0,1,1,1,98,107},{0,1,1,1,98,113},{0,1,1,1,98,118},{0,1,1,1,98,119},{0,1,1,1,98,120},{0,1,1,1,98,121},{0,1,1,1,98,122},{85,0,0,1,0,98},{86,0,0,1,0,98},{87,0,0,1,0,98},{88,1,0,1,0,98},{9,0,1,1,100,48},{10,0,1,1,100,48},{11,0,1,1,100,48},{12,1,1,1,100,48},{9,0,1,1,100,49},{10,0,1,1,100,49},{11,0,1,1,100,49},{12,1,1,1,100,49},{9,0,1,1,100,50},{10,0,1,1,100,50},{11,0,1,1,100,50},{12,1,1,1,100,50},{9,0,1,1,100,97},{10,0,1,1,100,97},{11,0,1,1,100,97},{12,1,1,1,100,97},{9,0,1,1,100,99},{10,0,1,1,100,99},{11,0,1,1,100,99},{12,1,1,1,100,99},{9,0,1,1,100,101},{10,0,1,1,100,101},{11,0,1,1,100,101},{12,1,1,1,100,101},{9,0,1,1,100,105},{10,0,1,1,100,105},{11,0,1,1,100,105},{12,1,1,1,100,105},{9,0,1,1,100,111},{10,0,1,1,100,111},{11,0,1,1,100,111},{12,1,1,1,100,111},{9,0,1,1,100,115},{10,0,1,1,100,115},{11,0,1,1,100,115},{12,1,1,1,100,115},{9,0,1,1,100,116},{10,0,1,1,100,116},{11,0,1,1,100,116},{12,1,1,1,100,116},{13,0,1,1,100,32},{14,1,1,1,100,32},{13,0,1,1,100,37},{14,1,1,1,100,37},{13,0,1,1,100,45},{14,1,1,1,100,45},{13,0,1,1,100,46},{14,1,1,1,100,46},{13,0,1,1,100,47},{14,1,1,1,100,47},{13,0,1,1,100,51},{14,1,1,1,100,51},{13,0,1,1,100,52},{14,1,1,1,100,52},{13,0,1,1,100,53},{14,1,1,1,100,53},{13,0,1,1,100,54},{14,1,1,1,100,54},{13,0,1,1,100,55},{14,1,1,1,100,55},{13,0,1,1,100,56},{14,1,1,1,100,56},{13,0,1,1,100,57},{14,1,1,1,100,57},{13,0,1,1,100,61},{14,1,1,1,100,61},{13,0,1,1,100,65},{14,1,1,1,100,65},{13,0,1,1,100,95},{14,1,1,1,100,95},{13,0,1,1,100,98},{14,1,1,1,100,98},{13,0,1,1,100,100},{14,1,1,1,100,100},{13,0,1,1,100,102},{14,1,1,1,100,102},{13,0,1,1,100,103},{14,1,1,1,100,103},{13,0,1,1,100,104},{14,1,1,1,100,104},{13,0,1,1,100,108},{14,1,1,1,100,108},{13,0,1,1,100,109},{14,1,1,1,100,109},{13,0,1,1,100,110},{14,1,1,1,100,110},{13,0,1,1,100,112},{14,1,1,1,100,112},{13,0,1,1,100,114},{14,1,1,1,100,114},{13,0,1,1,100,117},{14,1,1,1,100,117},{0,1,1,1,100,58},{0,1,1,1,100,66},{0,1,1,1,100,67},{0,1,1,1,100,68},{0,1,1,1,100,69},{0,1,1,1,100,70},{0,1,1,1,100,71},{0,1,1,1,100,72},{0,1,1,1,100,73},{0,1,1,1,100,74},{0,1,1,1,100,75},{0,1,1,1,100,76},{0,1,1,1,100,77},{0,1,1,1,100,78},{0,1,1,1,100,79},{0,1,1,1,100,80},{0,1,1,1,100,81},{0,1,1,1,100,82},{0,1,1,1,100,83},{0,1,1,1,100,84},{0,1,1,1,100,85},{0,1,1,1,100,86},{0,1,1,1,100,87},{0,1,1,1,100,89},{0,1,1,1,100,106},{0,1,1,1,100,107},{0,1,1,1,100,113},{0,1,1,1,100,118},{0,1,1,1,100,119},{0,1,1,1,100,120},{0,1,1,1,100,121},{0,1,1,1,100,122},{85,0,0,1,0,100},{86,0,0,1,0,100},{87,0,0,1,0,100},{88,1,0,1,0,100},{9,0,1,1,102,48},{10,0,1,1,102,48},{11,0,1,1,102,48},{12,1,1,1,102,48},{9,0,1,1,102,49},{10,0,1,1,102,49},{11,0,1,1,102,49},{12,1,1,1,102,49},{9,0,1,1,102,50},{10,0,1,1,102,50},{11,0,1,1,102,50},{12,1,1,1,102,50},{9,0,1,1,102,97},{10,0,1,1,102,97},{11,0,1,1,102,97},{12,1,1,1,102,97},{9,0,1,1,102,99},{10,0,1,1,102,99},{11,0,1,1,102,99},{12,1,1,1,102,99},{9,0,1,1,102,101},{10,0,1,1,102,101},{11,0,1,1,102,101},{12,1,1,1,102,101},{9,0,1,1,102,105},{10,0,1,1,102,105},{11,0,1,1,102,105},{12,1,1,1,102,105},{9,0,1,1,102,111},{10,0,1,1,102,111},{11,0,1,1,102,111},{12,1,1,1,102,111},{9,0,1,1,102,115},{10,0,1,1,102,115},{11,0,1,1,102,115},{12,1,1,1,102,115},{9,0,1,1,102,116},{10,0,1,1,102,116},{11,0,1,1,102,116},{12,1,1,1,102,116},{13,0,1,1,102,32},{14,1,1,1,102,32},{13,0,1,1,102,37},{14,1,1,1,102,37},{13,0,1,1,102,45},{14,1,1,1,102,45},{13,0,1,1,102,46},{14,1,1,1,102,46},{13,0,1,1,102,47},{14,1,1,1,102,47},{13,0,1,1,102,51},{14,1,1,1,102,51},{13,0,1,1,102,52},{14,1,1,1,102,52},{13,0,1,1,102,53},{14,1,1,1,102,53},{13,0,1,1,102,54},{14,1,1,1,102,54},{13,0,1,1,102,55},{14,1,1,1,102,55},{13,0,1,1,102,56},{14,1,1,1,102,56},{13,0,1,1,102,57},{14,1,1,1,102,57},{13,0,1,1,102,61},{14,1,1,1,102,61},{13,0,1,1,102,65},{14,1,1,1,102,65},{13,0,1,1,102,95},{14,1,1,1,102,95},{13,0,1,1,102,98},{14,1,1,1,102,98},{13,0,1,1,102,100},{14,1,1,1,102,100},{13,0,1,1,102,102},{14,1,1,1,102,102},{13,0,1,1,102,103},{14,1,1,1,102,103},{13,0,1,1,102,104},{14,1,1,1,102,104},{13,0,1,1,102,108},{14,1,1,1,102,108},{13,0,1,1,102,109},{14,1,1,1,102,109},{13,0,1,1,102,110},{14,1,1,1,102,110},{13,0,1,1,102,112},{14,1,1,1,102,112},{13,0,1,1,102,114},{14,1,1,1,102,114},{13,0,1,1,102,117},{14,1,1,1,102,117},{0,1,1,1,102,58},{0,1,1,1,102,66},{0,1,1,1,102,67},{0,1,1,1,102,68},{0,1,1,1,102,69},{0,1,1,1,102,70},{0,1,1,1,102,71},{0,1,1,1,102,72},{0,1,1,1,102,73},{0,1,1,1,102,74},{0,1,1,1,102,75},{0,1,1,1,102,76},{0,1,1,1,102,77},{0,1,1,1,102,78},{0,1,1,1,102,79},{0,1,1,1,102,80},{0,1,1,1,102,81},{0,1,1,1,102,82},{0,1,1,1,102,83},{0,1,1,1,102,84},{0,1,1,1,102,85},{0,1,1,1,102,86},{0,1,1,1,102,87},{0,1,1,1,102,89},{0,1,1,1,102,106},{0,1,1,1,102,107},{0,1,1,1,102,113},{0,1,1,1,102,118},{0,1,1,1,102,119},{0,1,1,1,102,120},{0,1,1,1,102,121},{0,1,1,1,102,122},{85,0,0,1,0,102},{86,0,0,1,0,102},{87,0,0,1,0,102},{88,1,0,1,0,102},{9,0,1,1,103,48},{10,0,1,1,103,48},{11,0,1,1,103,48},{12,1,1,1,103,48},{9,0,1,1,103,49},{10,0,1,1,103,49},{11,0,1,1,103,49},{12,1,1,1,103,49},{9,0,1,1,103,50},{10,0,1,1,103,50},{11,0,1,1,103,50},{12,1,1,1,103,50},{9,0,1,1,103,97},{10,0,1,1,103,97},{11,0,1,1,103,97},{12,1,1,1,103,97},{9,0,1,1,103,99},{10,0,1,1,103,99},{11,0,1,1,103,99},{12,1,1,1,103,99},{9,0,1,1,103,101},{10,0,1,1,103,101},{11,0,1,1,103,101},{12,1,1,1,103,101},{9,0,1,1,103,105},{10,0,1,1,103,105},{11,0,1,1,103,105},{12,1,1,1,103,105},{9,0,1,1,103,111},{10,0,1,1,103,111},{11,0,1,1,103,111},{12,1,1,1,103,111},{9,0,1,1,103,115},{10,0,1,1,103,115},{11,0,1,1,103,115},{12,1,1,1,103,115},{9,0,1,1,103,116},{10,0,1,1,103,116},{11,0,1,1,103,116},{12,1,1,1,103,116},{13,0,1,1,103,32},{14,1,1,1,103,32},{13,0,1,1,103,37},{14,1,1,1,103,37},{13,0,1,1,103,45},{14,1,1,1,103,45},{13,0,1,1,103,46},{14,1,1,1,103,46},{13,0,1,1,103,47},{14,1,1,1,103,47},{13,0,1,1,103,51},{14,1,1,1,103,51},{13,0,1,1,103,52},{14,1,1,1,103,52},{13,0,1,1,103,53},{14,1,1,1,103,53},{13,0,1,1,103,54},{14,1,1,1,103,54},{13,0,1,1,103,55},{14,1,1,1,103,55},{13,0,1,1,103,56},{14,1,1,1,103,56},{13,0,1,1,103,57},{14,1,1,1,103,57},{13,0,1,1,103,61},{14,1,1,1,103,61},{13,0,1,1,103,65},{14,1,1,1,103,65},{13,0,1,1,103,95},{14,1,1,1,103,95},{13,0,1,1,103,98},{14,1,1,1,103,98},{13,0,1,1,103,100},{14,1,1,1,103,100},{13,0,1,1,103,102},{14,1,1,1,103,102},{13,0,1,1,103,103},{14,1,1,1,103,103},{13,0,1,1,103,104},{14,1,1,1,103,104},{13,0,1,1,103,108},{14,1,1,1,103,108},{13,0,1,1,103,109},{14,1,1,1,103,109},{13,0,1,1,103,110},{14,1,1,1,103,110},{13,0,1,1,103,112},{14,1,1,1,103,112},{13,0,1,1,103,114},{14,1,1,1,103,114},{13,0,1,1,103,117},{14,1,1,1,103,117},{0,1,1,1,103,58},{0,1,1,1,103,66},{0,1,1,1,103,67},{0,1,1,1,103,68},{0,1,1,1,103,69},{0,1,1,1,103,70},{0,1,1,1,103,71},{0,1,1,1,103,72},{0,1,1,1,103,73},{0,1,1,1,103,74},{0,1,1,1,103,75},{0,1,1,1,103,76},{0,1,1,1,103,77},{0,1,1,1,103,78},{0,1,1,1,103,79},{0,1,1,1,103,80},{0,1,1,1,103,81},{0,1,1,1,103,82},{0,1,1,1,103,83},{0,1,1,1,103,84},{0,1,1,1,103,85},{0,1,1,1,103,86},{0,1,1,1,103,87},{0,1,1,1,103,89},{0,1,1,1,103,106},{0,1,1,1,103,107},{0,1,1,1,103,113},{0,1,1,1,103,118},{0,1,1,1,103,119},{0,1,1,1,103,120},{0,1,1,1,103,121},{0,1,1,1,103,122},{85,0,0,1,0,103},{86,0,0,1,0,103},{87,0,0,1,0,103},{88,1,0,1,0,103},{9,0,1,1,104,48},{10,0,1,1,104,48},{11,0,1,1,104,48},{12,1,1,1,104,48},{9,0,1,1,104,49},{10,0,1,1,104,49},{11,0,1,1,104,49},{12,1,1,1,104,49},{9,0,1,1,104,50},{10,0,1,1,104,50},{11,0,1,1,104,50},{12,1,1,1,104,50},{9,0,1,1,104,97},{10,0,1,1,104,97},{11,0,1,1,104,97},{12,1,1,1,104,97},{9,0,1,1,104,99},{10,0,1,1,104,99},{11,0,1,1,104,99},{12,1,1,1,104,99},{9,0,1,1,104,101},{10,0,1,1,104,101},{11,0,1,1,104,101},{12,1,1,1,104,101},{9,0,1,1,104,105},{10,0,1,1,104,105},{11,0,1,1,104,105},{12,1,1,1,104,105},{9,0,1,1,104,111},{10,0,1,1,104,111},{11,0,1,1,104,111},{12,1,1,1,104,111},{9,0,1,1,104,115},{10,0,1,1,104,115},{11,0,1,1,104,115},{12,1,1,1,104,115},{9,0,1,1,104,116},{10,0,1,1,104,116},{11,0,1,1,104,116},{12,1,1,1,104,116},{13,0,1,1,104,32},{14,1,1,1,104,32},{13,0,1,1,104,37},{14,1,1,1,104,37},{13,0,1,1,104,45},{14,1,1,1,104,45},{13,0,1,1,104,46},{14,1,1,1,104,46},{13,0,1,1,104,47},{14,1,1,1,104,47},{13,0,1,1,104,51},{14,1,1,1,104,51},{13,0,1,1,104,52},{14,1,1,1,104,52},{13,0,1,1,104,53},{14,1,1,1,104,53},{13,0,1,1,104,54},{14,1,1,1,104,54},{13,0,1,1,104,55},{14,1,1,1,104,55},{13,0,1,1,104,56},{14,1,1,1,104,56},{13,0,1,1,104,57},{14,1,1,1,104,57},{13,0,1,1,104,61},{14,1,1,1,104,61},{13,0,1,1,104,65},{14,1,1,1,104,65},{13,0,1,1,104,95},{14,1,1,1,104,95},{13,0,1,1,104,98},{14,1,1,1,104,98},{13,0,1,1,104,100},{14,1,1,1,104,100},{13,0,1,1,104,102},{14,1,1,1,104,102},{13,0,1,1,104,103},{14,1,1,1,104,103},{13,0,1,1,104,104},{14,1,1,1,104,104},{13,0,1,1,104,108},{14,1,1,1,104,108},{13,0,1,1,104,109},{14,1,1,1,104,109},{13,0,1,1,104,110},{14,1,1,1,104,110},{13,0,1,1,104,112},{14,1,1,1,104,112},{13,0,1,1,104,114},{14,1,1,1,104,114},{13,0,1,1,104,117},{14,1,1,1,104,117},{0,1,1,1,104,58},{0,1,1,1,104,66},{0,1,1,1,104,67},{0,1,1,1,104,68},{0,1,1,1,104,69},{0,1,1,1,104,70},{0,1,1,1,104,71},{0,1,1,1,104,72},{0,1,1,1,104,73},{0,1,1,1,104,74},{0,1,1,1,104,75},{0,1,1,1,104,76},{0,1,1,1,104,77},{0,1,1,1,104,78},{0,1,1,1,104,79},{0,1,1,1,104,80},{0,1,1,1,104,81},{0,1,1,1,104,82},{0,1,1,1,104,83},{0,1,1,1,104,84},{0,1,1,1,104,85},{0,1,1,1,104,86},{0,1,1,1,104,87},{0,1,1,1,104,89},{0,1,1,1,104,106},{0,1,1,1,104,107},{0,1,1,1,104,113},{0,1,1,1,104,118},{0,1,1,1,104,119},{0,1,1,1,104,120},{0,1,1,1,104,121},{0,1,1,1,104,122},{85,0,0,1,0,104},{86,0,0,1,0,104},{87,0,0,1,0,104},{88,1,0,1,0,104},{9,0,1,1,108,48},{10,0,1,1,108,48},{11,0,1,1,108,48},{12,1,1,1,108,48},{9,0,1,1,108,49},{10,0,1,1,108,49},{11,0,1,1,108,49},{12,1,1,1,108,49},{9,0,1,1,108,50},{10,0,1,1,108,50},{11,0,1,1,108,50},{12,1,1,1,108,50},{9,0,1,1,108,97},{10,0,1,1,108,97},{11,0,1,1,108,97},{12,1,1,1,108,97},{9,0,1,1,108,99},{10,0,1,1,108,99},{11,0,1,1,108,99},{12,1,1,1,108,99},{9,0,1,1,108,101},{10,0,1,1,108,101},{11,0,1,1,108,101},{12,1,1,1,108,101},{9,0,1,1,108,105},{10,0,1,1,108,105},{11,0,1,1,108,105},{12,1,1,1,108,105},{9,0,1,1,108,111},{10,0,1,1,108,111},{11,0,1,1,108,111},{12,1,1,1,108,111},{9,0,1,1,108,115},{10,0,1,1,108,115},{11,0,1,1,108,115},{12,1,1,1,108,115},{9,0,1,1,108,116},{10,0,1,1,108,116},{11,0,1,1,108,116},{12,1,1,1,108,116},{13,0,1,1,108,32},{14,1,1,1,108,32},{13,0,1,1,108,37},{14,1,1,1,108,37},{13,0,1,1,108,45},{14,1,1,1,108,45},{13,0,1,1,108,46},{14,1,1,1,108,46},{13,0,1,1,108,47},{14,1,1,1,108,47},{13,0,1,1,108,51},{14,1,1,1,108,51},{13,0,1,1,108,52},{14,1,1,1,108,52},{13,0,1,1,108,53},{14,1,1,1,108,53},{13,0,1,1,108,54},{14,1,1,1,108,54},{13,0,1,1,108,55},{14,1,1,1,108,55},{13,0,1,1,108,56},{14,1,1,1,108,56},{13,0,1,1,108,57},{14,1,1,1,108,57},{13,0,1,1,108,61},{14,1,1,1,108,61},{13,0,1,1,108,65},{14,1,1,1,108,65},{13,0,1,1,108,95},{14,1,1,1,108,95},{13,0,1,1,108,98},{14,1,1,1,108,98},{13,0,1,1,108,100},{14,1,1,1,108,100},{13,0,1,1,108,102},{14,1,1,1,108,102},{13,0,1,1,108,103},{14,1,1,1,108,103},{13,0,1,1,108,104},{14,1,1,1,108,104},{13,0,1,1,108,108},{14,1,1,1,108,108},{13,0,1,1,108,109},{14,1,1,1,108,109},{13,0,1,1,108,110},{14,1,1,1,108,110},{13,0,1,1,108,112},{14,1,1,1,108,112},{13,0,1,1,108,114},{14,1,1,1,108,114},{13,0,1,1,108,117},{14,1,1,1,108,117},{0,1,1,1,108,58},{0,1,1,1,108,66},{0,1,1,1,108,67},{0,1,1,1,108,68},{0,1,1,1,108,69},{0,1,1,1,108,70},{0,1,1,1,108,71},{0,1,1,1,108,72},{0,1,1,1,108,73},{0,1,1,1,108,74},{0,1,1,1,108,75},{0,1,1,1,108,76},{0,1,1,1,108,77},{0,1,1,1,108,78},{0,1,1,1,108,79},{0,1,1,1,108,80},{0,1,1,1,108,81},{0,1,1,1,108,82},{0,1,1,1,108,83},{0,1,1,1,108,84},{0,1,1,1,108,85},{0,1,1,1,108,86},{0,1,1,1,108,87},{0,1,1,1,108,89},{0,1,1,1,108,106},{0,1,1,1,108,107},{0,1,1,1,108,113},{0,1,1,1,108,118},{0,1,1,1,108,119},{0,1,1,1,108,120},{0,1,1,1,108,121},{0,1,1,1,108,122},{85,0,0,1,0,108},{86,0,0,1,0,108},{87,0,0,1,0,108},{88,1,0,1,0,108},{9,0,1,1,109,48},{10,0,1,1,109,48},{11,0,1,1,109,48},{12,1,1,1,109,48},{9,0,1,1,109,49},{10,0,1,1,109,49},{11,0,1,1,109,49},{12,1,1,1,109,49},{9,0,1,1,109,50},{10,0,1,1,109,50},{11,0,1,1,109,50},{12,1,1,1,109,50},{9,0,1,1,109,97},{10,0,1,1,109,97},{11,0,1,1,109,97},{12,1,1,1,109,97},{9,0,1,1,109,99},{10,0,1,1,109,99},{11,0,1,1,109,99},{12,1,1,1,109,99},{9,0,1,1,109,101},{10,0,1,1,109,101},{11,0,1,1,109,101},{12,1,1,1,109,101},{9,0,1,1,109,105},{10,0,1,1,109,105},{11,0,1,1,109,105},{12,1,1,1,109,105},{9,0,1,1,109,111},{10,0,1,1,109,111},{11,0,1,1,109,111},{12,1,1,1,109,111},{9,0,1,1,109,115},{10,0,1,1,109,115},{11,0,1,1,109,115},{12,1,1,1,109,115},{9,0,1,1,109,116},{10,0,1,1,109,116},{11,0,1,1,109,116},{12,1,1,1,109,116},{13,0,1,1,109,32},{14,1,1,1,109,32},{13,0,1,1,109,37},{14,1,1,1,109,37},{13,0,1,1,109,45},{14,1,1,1,109,45},{13,0,1,1,109,46},{14,1,1,1,109,46},{13,0,1,1,109,47},{14,1,1,1,109,47},{13,0,1,1,109,51},{14,1,1,1,109,51},{13,0,1,1,109,52},{14,1,1,1,109,52},{13,0,1,1,109,53},{14,1,1,1,109,53},{13,0,1,1,109,54},{14,1,1,1,109,54},{13,0,1,1,109,55},{14,1,1,1,109,55},{13,0,1,1,109,56},{14,1,1,1,109,56},{13,0,1,1,109,57},{14,1,1,1,109,57},{13,0,1,1,109,61},{14,1,1,1,109,61},{13,0,1,1,109,65},{14,1,1,1,109,65},{13,0,1,1,109,95},{14,1,1,1,109,95},{13,0,1,1,109,98},{14,1,1,1,109,98},{13,0,1,1,109,100},{14,1,1,1,109,100},{13,0,1,1,109,102},{14,1,1,1,109,102},{13,0,1,1,109,103},{14,1,1,1,109,103},{13,0,1,1,109,104},{14,1,1,1,109,104},{13,0,1,1,109,108},{14,1,1,1,109,108},{13,0,1,1,109,109},{14,1,1,1,109,109},{13,0,1,1,109,110},{14,1,1,1,109,110},{13,0,1,1,109,112},{14,1,1,1,109,112},{13,0,1,1,109,114},{14,1,1,1,109,114},{13,0,1,1,109,117},{14,1,1,1,109,117},{0,1,1,1,109,58},{0,1,1,1,109,66},{0,1,1,1,109,67},{0,1,1,1,109,68},{0,1,1,1,109,69},{0,1,1,1,109,70},{0,1,1,1,109,71},{0,1,1,1,109,72},{0,1,1,1,109,73},{0,1,1,1,109,74},{0,1,1,1,109,75},{0,1,1,1,109,76},{0,1,1,1,109,77},{0,1,1,1,109,78},{0,1,1,1,109,79},{0,1,1,1,109,80},{0,1,1,1,109,81},{0,1,1,1,109,82},{0,1,1,1,109,83},{0,1,1,1,109,84},{0,1,1,1,109,85},{0,1,1,1,109,86},{0,1,1,1,109,87},{0,1,1,1,109,89},{0,1,1,1,109,106},{0,1,1,1,109,107},{0,1,1,1,109,113},{0,1,1,1,109,118},{0,1,1,1,109,119},{0,1,1,1,109,120},{0,1,1,1,109,121},{0,1,1,1,109,122},{85,0,0,1,0,109},{86,0,0,1,0,109},{87,0,0,1,0,109},{88,1,0,1,0,109},{9,0,1,1,110,48},{10,0,1,1,110,48},{11,0,1,1,110,48},{12,1,1,1,110,48},{9,0,1,1,110,49},{10,0,1,1,110,49},{11,0,1,1,110,49},{12,1,1,1,110,49},{9,0,1,1,110,50},{10,0,1,1,110,50},{11,0,1,1,110,50},{12,1,1,1,110,50},{9,0,1,1,110,97},{10,0,1,1,110,97},{11,0,1,1,110,97},{12,1,1,1,110,97},{9,0,1,1,110,99},{10,0,1,1,110,99},{11,0,1,1,110,99},{12,1,1,1,110,99},{9,0,1,1,110,101},{10,0,1,1,110,101},{11,0,1,1,110,101},{12,1,1,1,110,101},{9,0,1,1,110,105},{10,0,1,1,110,105},{11,0,1,1,110,105},{12,1,1,1,110,105},{9,0,1,1,110,111},{10,0,1,1,110,111},{11,0,1,1,110,111},{12,1,1,1,110,111},{9,0,1,1,110,115},{10,0,1,1,110,115},{11,0,1,1,110,115},{12,1,1,1,110,115},{9,0,1,1,110,116},{10,0,1,1,110,116},{11,0,1,1,110,116},{12,1,1,1,110,116},{13,0,1,1,110,32},{14,1,1,1,110,32},{13,0,1,1,110,37},{14,1,1,1,110,37},{13,0,1,1,110,45},{14,1,1,1,110,45},{13,0,1,1,110,46},{14,1,1,1,110,46},{13,0,1,1,110,47},{14,1,1,1,110,47},{13,0,1,1,110,51},{14,1,1,1,110,51},{13,0,1,1,110,52},{14,1,1,1,110,52},{13,0,1,1,110,53},{14,1,1,1,110,53},{13,0,1,1,110,54},{14,1,1,1,110,54},{13,0,1,1,110,55},{14,1,1,1,110,55},{13,0,1,1,110,56},{14,1,1,1,110,56},{13,0,1,1,110,57},{14,1,1,1,110,57},{13,0,1,1,110,61},{14,1,1,1,110,61},{13,0,1,1,110,65},{14,1,1,1,110,65},{13,0,1,1,110,95},{14,1,1,1,110,95},{13,0,1,1,110,98},{14,1,1,1,110,98},{13,0,1,1,110,100},{14,1,1,1,110,100},{13,0,1,1,110,102},{14,1,1,1,110,102},{13,0,1,1,110,103},{14,1,1,1,110,103},{13,0,1,1,110,104},{14,1,1,1,110,104},{13,0,1,1,110,108},{14,1,1,1,110,108},{13,0,1,1,110,109},{14,1,1,1,110,109},{13,0,1,1,110,110},{14,1,1,1,110,110},{13,0,1,1,110,112},{14,1,1,1,110,112},{13,0,1,1,110,114},{14,1,1,1,110,114},{13,0,1,1,110,117},{14,1,1,1,110,117},{0,1,1,1,110,58},{0,1,1,1,110,66},{0,1,1,1,110,67},{0,1,1,1,110,68},{0,1,1,1,110,69},{0,1,1,1,110,70},{0,1,1,1,110,71},{0,1,1,1,110,72},{0,1,1,1,110,73},{0,1,1,1,110,74},{0,1,1,1,110,75},{0,1,1,1,110,76},{0,1,1,1,110,77},{0,1,1,1,110,78},{0,1,1,1,110,79},{0,1,1,1,110,80},{0,1,1,1,110,81},{0,1,1,1,110,82},{0,1,1,1,110,83},{0,1,1,1,110,84},{0,1,1,1,110,85},{0,1,1,1,110,86},{0,1,1,1,110,87},{0,1,1,1,110,89},{0,1,1,1,110,106},{0,1,1,1,110,107},{0,1,1,1,110,113},{0,1,1,1,110,118},{0,1,1,1,110,119},{0,1,1,1,110,120},{0,1,1,1,110,121},{0,1,1,1,110,122},{85,0,0,1,0,110},{86,0,0,1,0,110},{87,0,0,1,0,110},{88,1,0,1,0,110},{9,0,1,1,112,48},{10,0,1,1,112,48},{11,0,1,1,112,48},{12,1,1,1,112,48},{9,0,1,1,112,49},{10,0,1,1,112,49},{11,0,1,1,112,49},{12,1,1,1,112,49},{9,0,1,1,112,50},{10,0,1,1,112,50},{11,0,1,1,112,50},{12,1,1,1,112,50},{9,0,1,1,112,97},{10,0,1,1,112,97},{11,0,1,1,112,97},{12,1,1,1,112,97},{9,0,1,1,112,99},{10,0,1,1,112,99},{11,0,1,1,112,99},{12,1,1,1,112,99},{9,0,1,1,112,101},{10,0,1,1,112,101},{11,0,1,1,112,101},{12,1,1,1,112,101},{9,0,1,1,112,105},{10,0,1,1,112,105},{11,0,1,1,112,105},{12,1,1,1,112,105},{9,0,1,1,112,111},{10,0,1,1,112,111},{11,0,1,1,112,111},{12,1,1,1,112,111},{9,0,1,1,112,115},{10,0,1,1,112,115},{11,0,1,1,112,115},{12,1,1,1,112,115},{9,0,1,1,112,116},{10,0,1,1,112,116},{11,0,1,1,112,116},{12,1,1,1,112,116},{13,0,1,1,112,32},{14,1,1,1,112,32},{13,0,1,1,112,37},{14,1,1,1,112,37},{13,0,1,1,112,45},{14,1,1,1,112,45},{13,0,1,1,112,46},{14,1,1,1,112,46},{13,0,1,1,112,47},{14,1,1,1,112,47},{13,0,1,1,112,51},{14,1,1,1,112,51},{13,0,1,1,112,52},{14,1,1,1,112,52},{13,0,1,1,112,53},{14,1,1,1,112,53},{13,0,1,1,112,54},{14,1,1,1,112,54},{13,0,1,1,112,55},{14,1,1,1,112,55},{13,0,1,1,112,56},{14,1,1,1,112,56},{13,0,1,1,112,57},{14,1,1,1,112,57},{13,0,1,1,112,61},{14,1,1,1,112,61},{13,0,1,1,112,65},{14,1,1,1,112,65},{13,0,1,1,112,95},{14,1,1,1,112,95},{13,0,1,1,112,98},{14,1,1,1,112,98},{13,0,1,1,112,100},{14,1,1,1,112,100},{13,0,1,1,112,102},{14,1,1,1,112,102},{13,0,1,1,112,103},{14,1,1,1,112,103},{13,0,1,1,112,104},{14,1,1,1,112,104},{13,0,1,1,112,108},{14,1,1,1,112,108},{13,0,1,1,112,109},{14,1,1,1,112,109},{13,0,1,1,112,110},{14,1,1,1,112,110},{13,0,1,1,112,112},{14,1,1,1,112,112},{13,0,1,1,112,114},{14,1,1,1,112,114},{13,0,1,1,112,117},{14,1,1,1,112,117},{0,1,1,1,112,58},{0,1,1,1,112,66},{0,1,1,1,112,67},{0,1,1,1,112,68},{0,1,1,1,112,69},{0,1,1,1,112,70},{0,1,1,1,112,71},{0,1,1,1,112,72},{0,1,1,1,112,73},{0,1,1,1,112,74},{0,1,1,1,112,75},{0,1,1,1,112,76},{0,1,1,1,112,77},{0,1,1,1,112,78},{0,1,1,1,112,79},{0,1,1,1,112,80},{0,1,1,1,112,81},{0,1,1,1,112,82},{0,1,1,1,112,83},{0,1,1,1,112,84},{0,1,1,1,112,85},{0,1,1,1,112,86},{0,1,1,1,112,87},{0,1,1,1,112,89},{0,1,1,1,112,106},{0,1,1,1,112,107},{0,1,1,1,112,113},{0,1,1,1,112,118},{0,1,1,1,112,119},{0,1,1,1,112,120},{0,1,1,1,112,121},{0,1,1,1,112,122},{85,0,0,1,0,112},{86,0,0,1,0,112},{87,0,0,1,0,112},{88,1,0,1,0,112},{9,0,1,1,114,48},{10,0,1,1,114,48},{11,0,1,1,114,48},{12,1,1,1,114,48},{9,0,1,1,114,49},{10,0,1,1,114,49},{11,0,1,1,114,49},{12,1,1,1,114,49},{9,0,1,1,114,50},{10,0,1,1,114,50},{11,0,1,1,114,50},{12,1,1,1,114,50},{9,0,1,1,114,97},{10,0,1,1,114,97},{11,0,1,1,114,97},{12,1,1,1,114,97},{9,0,1,1,114,99},{10,0,1,1,114,99},{11,0,1,1,114,99},{12,1,1,1,114,99},{9,0,1,1,114,101},{10,0,1,1,114,101},{11,0,1,1,114,101},{12,1,1,1,114,101},{9,0,1,1,114,105},{10,0,1,1,114,105},{11,0,1,1,114,105},{12,1,1,1,114,105},{9,0,1,1,114,111},{10,0,1,1,114,111},{11,0,1,1,114,111},{12,1,1,1,114,111},{9,0,1,1,114,115},{10,0,1,1,114,115},{11,0,1,1,114,115},{12,1,1,1,114,115},{9,0,1,1,114,116},{10,0,1,1,114,116},{11,0,1,1,114,116},{12,1,1,1,114,116},{13,0,1,1,114,32},{14,1,1,1,114,32},{13,0,1,1,114,37},{14,1,1,1,114,37},{13,0,1,1,114,45},{14,1,1,1,114,45},{13,0,1,1,114,46},{14,1,1,1,114,46},{13,0,1,1,114,47},{14,1,1,1,114,47},{13,0,1,1,114,51},{14,1,1,1,114,51},{13,0,1,1,114,52},{14,1,1,1,114,52},{13,0,1,1,114,53},{14,1,1,1,114,53},{13,0,1,1,114,54},{14,1,1,1,114,54},{13,0,1,1,114,55},{14,1,1,1,114,55},{13,0,1,1,114,56},{14,1,1,1,114,56},{13,0,1,1,114,57},{14,1,1,1,114,57},{13,0,1,1,114,61},{14,1,1,1,114,61},{13,0,1,1,114,65},{14,1,1,1,114,65},{13,0,1,1,114,95},{14,1,1,1,114,95},{13,0,1,1,114,98},{14,1,1,1,114,98},{13,0,1,1,114,100},{14,1,1,1,114,100},{13,0,1,1,114,102},{14,1,1,1,114,102},{13,0,1,1,114,103},{14,1,1,1,114,103},{13,0,1,1,114,104},{14,1,1,1,114,104},{13,0,1,1,114,108},{14,1,1,1,114,108},{13,0,1,1,114,109},{14,1,1,1,114,109},{13,0,1,1,114,110},{14,1,1,1,114,110},{13,0,1,1,114,112},{14,1,1,1,114,112},{13,0,1,1,114,114},{14,1,1,1,114,114},{13,0,1,1,114,117},{14,1,1,1,114,117},{0,1,1,1,114,58},{0,1,1,1,114,66},{0,1,1,1,114,67},{0,1,1,1,114,68},{0,1,1,1,114,69},{0,1,1,1,114,70},{0,1,1,1,114,71},{0,1,1,1,114,72},{0,1,1,1,114,73},{0,1,1,1,114,74},{0,1,1,1,114,75},{0,1,1,1,114,76},{0,1,1,1,114,77},{0,1,1,1,114,78},{0,1,1,1,114,79},{0,1,1,1,114,80},{0,1,1,1,114,81},{0,1,1,1,114,82},{0,1,1,1,114,83},{0,1,1,1,114,84},{0,1,1,1,114,85},{0,1,1,1,114,86},{0,1,1,1,114,87},{0,1,1,1,114,89},{0,1,1,1,114,106},{0,1,1,1,114,107},{0,1,1,1,114,113},{0,1,1,1,114,118},{0,1,1,1,114,119},{0,1,1,1,114,120},{0,1,1,1,114,121},{0,1,1,1,114,122},{85,0,0,1,0,114},{86,0,0,1,0,114},{87,0,0,1,0,114},{88,1,0,1,0,114},{9,0,1,1,117,48},{10,0,1,1,117,48},{11,0,1,1,117,48},{12,1,1,1,117,48},{9,0,1,1,117,49},{10,0,1,1,117,49},{11,0,1,1,117,49},{12,1,1,1,117,49},{9,0,1,1,117,50},{10,0,1,1,117,50},{11,0,1,1,117,50},{12,1,1,1,117,50},{9,0,1,1,117,97},{10,0,1,1,117,97},{11,0,1,1,117,97},{12,1,1,1,117,97},{9,0,1,1,117,99},{10,0,1,1,117,99},{11,0,1,1,117,99},{12,1,1,1,117,99},{9,0,1,1,117,101},{10,0,1,1,117,101},{11,0,1,1,117,101},{12,1,1,1,117,101},{9,0,1,1,117,105},{10,0,1,1,117,105},{11,0,1,1,117,105},{12,1,1,1,117,105},{9,0,1,1,117,111},{10,0,1,1,117,111},{11,0,1,1,117,111},{12,1,1,1,117,111},{9,0,1,1,117,115},{10,0,1,1,117,115},{11,0,1,1,117,115},{12,1,1,1,117,115},{9,0,1,1,117,116},{10,0,1,1,117,116},{11,0,1,1,117,116},{12,1,1,1,117,116},{13,0,1,1,117,32},{14,1,1,1,117,32},{13,0,1,1,117,37},{14,1,1,1,117,37},{13,0,1,1,117,45},{14,1,1,1,117,45},{13,0,1,1,117,46},{14,1,1,1,117,46},{13,0,1,1,117,47},{14,1,1,1,117,47},{13,0,1,1,117,51},{14,1,1,1,117,51},{13,0,1,1,117,52},{14,1,1,1,117,52},{13,0,1,1,117,53},{14,1,1,1,117,53},{13,0,1,1,117,54},{14,1,1,1,117,54},{13,0,1,1,117,55},{14,1,1,1,117,55},{13,0,1,1,117,56},{14,1,1,1,117,56},{13,0,1,1,117,57},{14,1,1,1,117,57},{13,0,1,1,117,61},{14,1,1,1,117,61},{13,0,1,1,117,65},{14,1,1,1,117,65},{13,0,1,1,117,95},{14,1,1,1,117,95},{13,0,1,1,117,98},{14,1,1,1,117,98},{13,0,1,1,117,100},{14,1,1,1,117,100},{13,0,1,1,117,102},{14,1,1,1,117,102},{13,0,1,1,117,103},{14,1,1,1,117,103},{13,0,1,1,117,104},{14,1,1,1,117,104},{13,0,1,1,117,108},{14,1,1,1,117,108},{13,0,1,1,117,109},{14,1,1,1,117,109},{13,0,1,1,117,110},{14,1,1,1,117,110},{13,0,1,1,117,112},{14,1,1,1,117,112},{13,0,1,1,117,114},{14,1,1,1,117,114},{13,0,1,1,117,117},{14,1,1,1,117,117},{0,1,1,1,117,58},{0,1,1,1,117,66},{0,1,1,1,117,67},{0,1,1,1,117,68},{0,1,1,1,117,69},{0,1,1,1,117,70},{0,1,1,1,117,71},{0,1,1,1,117,72},{0,1,1,1,117,73},{0,1,1,1,117,74},{0,1,1,1,117,75},{0,1,1,1,117,76},{0,1,1,1,117,77},{0,1,1,1,117,78},{0,1,1,1,117,79},{0,1,1,1,117,80},{0,1,1,1,117,81},{0,1,1,1,117,82},{0,1,1,1,117,83},{0,1,1,1,117,84},{0,1,1,1,117,85},{0,1,1,1,117,86},{0,1,1,1,117,87},{0,1,1,1,117,89},{0,1,1,1,117,106},{0,1,1,1,117,107},{0,1,1,1,117,113},{0,1,1,1,117,118},{0,1,1,1,117,119},{0,1,1,1,117,120},{0,1,1,1,117,121},{0,1,1,1,117,122},{85,0,0,1,0,117},{86,0,0,1,0,117},{87,0,0,1,0,117},{88,1,0,1,0,117},{13,0,1,1,58,48},{14,1,1,1,58,48},{13,0,1,1,58,49},{14,1,1,1,58,49},{13,0,1,1,58,50},{14,1,1,1,58,50},{13,0,1,1,58,97},{14,1,1,1,58,97},{13,0,1,1,58,99},{14,1,1,1,58,99},{13,0,1,1,58,101},{14,1,1,1,58,101},{13,0,1,1,58,105},{14,1,1,1,58,105},{13,0,1,1,58,111},{14,1,1,1,58,111},{13,0,1,1,58,115},{14,1,1,1,58,115},{13,0,1,1,58,116},{14,1,1,1,58,116},{0,1,1,1,58,32},{0,1,1,1,58,37},{0,1,1,1,58,45},{0,1,1,1,58,46},{0,1,1,1,58,47},{0,1,1,1,58,51},{0,1,1,1,58,52},{0,1,1,1,58,53},{0,1,1,1,58,54},{0,1,1,1,58,55},{0,1,1,1,58,56},{0,1,1,1,58,57},{0,1,1,1,58,61},{0,1,1,1,58,65},{0,1,1,1,58,95},{0,1,1,1,58,98},{0,1,1,1,58,100},{0,1,1,1,58,102},{0,1,1,1,58,103},{0,1,1,1,58,104},{0,1,1,1,58,108},{0,1,1,1,58,109},{0,1,1,1,58,110},{0,1,1,1,58,112},{0,1,1,1,58,114},{0,1,1,1,58,117},{17,0,0,1,0,58},{18,0,0,1,0,58},{19,0,0,1,0,58},{20,0,0,1,0,58},{21,0,0,1,0,58},{22,0,0,1,0,58},{23,0,0,1,0,58},{24,0,0,1,0,58},{25,0,0,1,0,58},{26,0,0,1,0,58},{27,0,0,1,0,58},{28,0,0,1,0,58},{29,0,0,1,0,58},{30,0,0,1,0,58},{31,0,0,1,0,58},{32,0,0,1,0,58},{33,0,0,1,0,58},{34,1,0,1,0,58},{13,0,1,1,66,48},{14,1,1,1,66,48},{13,0,1,1,66,49},{14,1,1,1,66,49},{13,0,1,1,66,50},{14,1,1,1,66,50},{13,0,1,1,66,97},{14,1,1,1,66,97},{13,0,1,1,66,99},{14,1,1,1,66,99},{13,0,1,1,66,101},{14,1,1,1,66,101},{13,0,1,1,66,105},{14,1,1,1,66,105},{13,0,1,1,66,111},{14,1,1,1,66,111},{13,0,1,1,66,115},{14,1,1,1,66,115},{13,0,1,1,66,116},{14,1,1,1,66,116},{0,1,1,1,66,32},{0,1,1,1,66,37},{0,1,1,1,66,45},{0,1,1,1,66,46},{0,1,1,1,66,47},{0,1,1,1,66,51},{0,1,1,1,66,52},{0,1,1,1,66,53},{0,1,1,1,66,54},{0,1,1,1,66,55},{0,1,1,1,66,56},{0,1,1,1,66,57},{0,1,1,1,66,61},{0,1,1,1,66,65},{0,1,1,1,66,95},{0,1,1,1,66,98},{0,1,1,1,66,100},{0,1,1,1,66,102},{0,1,1,1,66,103},{0,1,1,1,66,104},{0,1,1,1,66,108},{0,1,1,1,66,109},{0,1,1,1,66,110},{0,1,1,1,66,112},{0,1,1,1,66,114},{0,1,1,1,66,117},{17,0,0,1,0,66},{18,0,0,1,0,66},{19,0,0,1,0,66},{20,0,0,1,0,66},{21,0,0,1,0,66},{22,0,0,1,0,66},{23,0,0,1,0,66},{24,0,0,1,0,66},{25,0,0,1,0,66},{26,0,0,1,0,66},{27,0,0,1,0,66},{28,0,0,1,0,66},{29,0,0,1,0,66},{30,0,0,1,0,66},{31,0,0,1,0,66},{32,0,0,1,0,66},{33,0,0,1,0,66},{34,1,0,1,0,66},{13,0,1,1,67,48},{14,1,1,1,67,48},{13,0,1,1,67,49},{14,1,1,1,67,49},{13,0,1,1,67,50},{14,1,1,1,67,50},{13,0,1,1,67,97},{14,1,1,1,67,97},{13,0,1,1,67,99},{14,1,1,1,67,99},{13,0,1,1,67,101},{14,1,1,1,67,101},{13,0,1,1,67,105},{14,1,1,1,67,105},{13,0,1,1,67,111},{14,1,1,1,67,111},{13,0,1,1,67,115},{14,1,1,1,67,115},{13,0,1,1,67,116},{14,1,1,1,67,116},{0,1,1,1,67,32},{0,1,1,1,67,37},{0,1,1,1,67,45},{0,1,1,1,67,46},{0,1,1,1,67,47},{0,1,1,1,67,51},{0,1,1,1,67,52},{0,1,1,1,67,53},{0,1,1,1,67,54},{0,1,1,1,67,55},{0,1,1,1,67,56},{0,1,1,1,67,57},{0,1,1,1,67,61},{0,1,1,1,67,65},{0,1,1,1,67,95},{0,1,1,1,67,98},{0,1,1,1,67,100},{0,1,1,1,67,102},{0,1,1,1,67,103},{0,1,1,1,67,104},{0,1,1,1,67,108},{0,1,1,1,67,109},{0,1,1,1,67,110},{0,1,1,1,67,112},{0,1,1,1,67,114},{0,1,1,1,67,117},{17,0,0,1,0,67},{18,0,0,1,0,67},{19,0,0,1,0,67},{20,0,0,1,0,67},{21,0,0,1,0,67},{22,0,0,1,0,67},{23,0,0,1,0,67},{24,0,0,1,0,67},{25,0,0,1,0,67},{26,0,0,1,0,67},{27,0,0,1,0,67},{28,0,0,1,0,67},{29,0,0,1,0,67},{30,0,0,1,0,67},{31,0,0,1,0,67},{32,0,0,1,0,67},{33,0,0,1,0,67},{34,1,0,1,0,67},{13,0,1,1,68,48},{14,1,1,1,68,48},{13,0,1,1,68,49},{14,1,1,1,68,49},{13,0,1,1,68,50},{14,1,1,1,68,50},{13,0,1,1,68,97},{14,1,1,1,68,97},{13,0,1,1,68,99},{14,1,1,1,68,99},{13,0,1,1,68,101},{14,1,1,1,68,101},{13,0,1,1,68,105},{14,1,1,1,68,105},{13,0,1,1,68,111},{14,1,1,1,68,111},{13,0,1,1,68,115},{14,1,1,1,68,115},{13,0,1,1,68,116},{14,1,1,1,68,116},{0,1,1,1,68,32},{0,1,1,1,68,37},{0,1,1,1,68,45},{0,1,1,1,68,46},{0,1,1,1,68,47},{0,1,1,1,68,51},{0,1,1,1,68,52},{0,1,1,1,68,53},{0,1,1,1,68,54},{0,1,1,1,68,55},{0,1,1,1,68,56},{0,1,1,1,68,57},{0,1,1,1,68,61},{0,1,1,1,68,65},{0,1,1,1,68,95},{0,1,1,1,68,98},{0,1,1,1,68,100},{0,1,1,1,68,102},{0,1,1,1,68,103},{0,1,1,1,68,104},{0,1,1,1,68,108},{0,1,1,1,68,109},{0,1,1,1,68,110},{0,1,1,1,68,112},{0,1,1,1,68,114},{0,1,1,1,68,117},{17,0,0,1,0,68},{18,0,0,1,0,68},{19,0,0,1,0,68},{20,0,0,1,0,68},{21,0,0,1,0,68},{22,0,0,1,0,68},{23,0,0,1,0,68},{24,0,0,1,0,68},{25,0,0,1,0,68},{26,0,0,1,0,68},{27,0,0,1,0,68},{28,0,0,1,0,68},{29,0,0,1,0,68},{30,0,0,1,0,68},{31,0,0,1,0,68},{32,0,0,1,0,68},{33,0,0,1,0,68},{34,1,0,1,0,68},{13,0,1,1,69,48},{14,1,1,1,69,48},{13,0,1,1,69,49},{14,1,1,1,69,49},{13,0,1,1,69,50},{14,1,1,1,69,50},{13,0,1,1,69,97},{14,1,1,1,69,97},{13,0,1,1,69,99},{14,1,1,1,69,99},{13,0,1,1,69,101},{14,1,1,1,69,101},{13,0,1,1,69,105},{14,1,1,1,69,105},{13,0,1,1,69,111},{14,1,1,1,69,111},{13,0,1,1,69,115},{14,1,1,1,69,115},{13,0,1,1,69,116},{14,1,1,1,69,116},{0,1,1,1,69,32},{0,1,1,1,69,37},{0,1,1,1,69,45},{0,1,1,1,69,46},{0,1,1,1,69,47},{0,1,1,1,69,51},{0,1,1,1,69,52},{0,1,1,1,69,53},{0,1,1,1,69,54},{0,1,1,1,69,55},{0,1,1,1,69,56},{0,1,1,1,69,57},{0,1,1,1,69,61},{0,1,1,1,69,65},{0,1,1,1,69,95},{0,1,1,1,69,98},{0,1,1,1,69,100},{0,1,1,1,69,102},{0,1,1,1,69,103},{0,1,1,1,69,104},{0,1,1,1,69,108},{0,1,1,1,69,109},{0,1,1,1,69,110},{0,1,1,1,69,112},{0,1,1,1,69,114},{0,1,1,1,69,117},{17,0,0,1,0,69},{18,0,0,1,0,69},{19,0,0,1,0,69},{20,0,0,1,0,69},{21,0,0,1,0,69},{22,0,0,1,0,69},{23,0,0,1,0,69},{24,0,0,1,0,69},{25,0,0,1,0,69},{26,0,0,1,0,69},{27,0,0,1,0,69},{28,0,0,1,0,69},{29,0,0,1,0,69},{30,0,0,1,0,69},{31,0,0,1,0,69},{32,0,0,1,0,69},{33,0,0,1,0,69},{34,1,0,1,0,69},{13,0,1,1,70,48},{14,1,1,1,70,48},{13,0,1,1,70,49},{14,1,1,1,70,49},{13,0,1,1,70,50},{14,1,1,1,70,50},{13,0,1,1,70,97},{14,1,1,1,70,97},{13,0,1,1,70,99},{14,1,1,1,70,99},{13,0,1,1,70,101},{14,1,1,1,70,101},{13,0,1,1,70,105},{14,1,1,1,70,105},{13,0,1,1,70,111},{14,1,1,1,70,111},{13,0,1,1,70,115},{14,1,1,1,70,115},{13,0,1,1,70,116},{14,1,1,1,70,116},{0,1,1,1,70,32},{0,1,1,1,70,37},{0,1,1,1,70,45},{0,1,1,1,70,46},{0,1,1,1,70,47},{0,1,1,1,70,51},{0,1,1,1,70,52},{0,1,1,1,70,53},{0,1,1,1,70,54},{0,1,1,1,70,55},{0,1,1,1,70,56},{0,1,1,1,70,57},{0,1,1,1,70,61},{0,1,1,1,70,65},{0,1,1,1,70,95},{0,1,1,1,70,98},{0,1,1,1,70,100},{0,1,1,1,70,102},{0,1,1,1,70,103},{0,1,1,1,70,104},{0,1,1,1,70,108},{0,1,1,1,70,109},{0,1,1,1,70,110},{0,1,1,1,70,112},{0,1,1,1,70,114},{0,1,1,1,70,117},{17,0,0,1,0,70},{18,0,0,1,0,70},{19,0,0,1,0,70},{20,0,0,1,0,70},{21,0,0,1,0,70},{22,0,0,1,0,70},{23,0,0,1,0,70},{24,0,0,1,0,70},{25,0,0,1,0,70},{26,0,0,1,0,70},{27,0,0,1,0,70},{28,0,0,1,0,70},{29,0,0,1,0,70},{30,0,0,1,0,70},{31,0,0,1,0,70},{32,0,0,1,0,70},{33,0,0,1,0,70},{34,1,0,1,0,70},{13,0,1,1,71,48},{14,1,1,1,71,48},{13,0,1,1,71,49},{14,1,1,1,71,49},{13,0,1,1,71,50},{14,1,1,1,71,50},{13,0,1,1,71,97},{14,1,1,1,71,97},{13,0,1,1,71,99},{14,1,1,1,71,99},{13,0,1,1,71,101},{14,1,1,1,71,101},{13,0,1,1,71,105},{14,1,1,1,71,105},{13,0,1,1,71,111},{14,1,1,1,71,111},{13,0,1,1,71,115},{14,1,1,1,71,115},{13,0,1,1,71,116},{14,1,1,1,71,116},{0,1,1,1,71,32},{0,1,1,1,71,37},{0,1,1,1,71,45},{0,1,1,1,71,46},{0,1,1,1,71,47},{0,1,1,1,71,51},{0,1,1,1,71,52},{0,1,1,1,71,53},{0,1,1,1,71,54},{0,1,1,1,71,55},{0,1,1,1,71,56},{0,1,1,1,71,57},{0,1,1,1,71,61},{0,1,1,1,71,65},{0,1,1,1,71,95},{0,1,1,1,71,98},{0,1,1,1,71,100},{0,1,1,1,71,102},{0,1,1,1,71,103},{0,1,1,1,71,104},{0,1,1,1,71,108},{0,1,1,1,71,109},{0,1,1,1,71,110},{0,1,1,1,71,112},{0,1,1,1,71,114},{0,1,1,1,71,117},{17,0,0,1,0,71},{18,0,0,1,0,71},{19,0,0,1,0,71},{20,0,0,1,0,71},{21,0,0,1,0,71},{22,0,0,1,0,71},{23,0,0,1,0,71},{24,0,0,1,0,71},{25,0,0,1,0,71},{26,0,0,1,0,71},{27,0,0,1,0,71},{28,0,0,1,0,71},{29,0,0,1,0,71},{30,0,0,1,0,71},{31,0,0,1,0,71},{32,0,0,1,0,71},{33,0,0,1,0,71},{34,1,0,1,0,71},{13,0,1,1,72,48},{14,1,1,1,72,48},{13,0,1,1,72,49},{14,1,1,1,72,49},{13,0,1,1,72,50},{14,1,1,1,72,50},{13,0,1,1,72,97},{14,1,1,1,72,97},{13,0,1,1,72,99},{14,1,1,1,72,99},{13,0,1,1,72,101},{14,1,1,1,72,101},{13,0,1,1,72,105},{14,1,1,1,72,105},{13,0,1,1,72,111},{14,1,1,1,72,111},{13,0,1,1,72,115},{14,1,1,1,72,115},{13,0,1,1,72,116},{14,1,1,1,72,116},{0,1,1,1,72,32},{0,1,1,1,72,37},{0,1,1,1,72,45},{0,1,1,1,72,46},{0,1,1,1,72,47},{0,1,1,1,72,51},{0,1,1,1,72,52},{0,1,1,1,72,53},{0,1,1,1,72,54},{0,1,1,1,72,55},{0,1,1,1,72,56},{0,1,1,1,72,57},{0,1,1,1,72,61},{0,1,1,1,72,65},{0,1,1,1,72,95},{0,1,1,1,72,98},{0,1,1,1,72,100},{0,1,1,1,72,102},{0,1,1,1,72,103},{0,1,1,1,72,104},{0,1,1,1,72,108},{0,1,1,1,72,109},{0,1,1,1,72,110},{0,1,1,1,72,112},{0,1,1,1,72,114},{0,1,1,1,72,117},{17,0,0,1,0,72},{18,0,0,1,0,72},{19,0,0,1,0,72},{20,0,0,1,0,72},{21,0,0,1,0,72},{22,0,0,1,0,72},{23,0,0,1,0,72},{24,0,0,1,0,72},{25,0,0,1,0,72},{26,0,0,1,0,72},{27,0,0,1,0,72},{28,0,0,1,0,72},{29,0,0,1,0,72},{30,0,0,1,0,72},{31,0,0,1,0,72},{32,0,0,1,0,72},{33,0,0,1,0,72},{34,1,0,1,0,72},{13,0,1,1,73,48},{14,1,1,1,73,48},{13,0,1,1,73,49},{14,1,1,1,73,49},{13,0,1,1,73,50},{14,1,1,1,73,50},{13,0,1,1,73,97},{14,1,1,1,73,97},{13,0,1,1,73,99},{14,1,1,1,73,99},{13,0,1,1,73,101},{14,1,1,1,73,101},{13,0,1,1,73,105},{14,1,1,1,73,105},{13,0,1,1,73,111},{14,1,1,1,73,111},{13,0,1,1,73,115},{14,1,1,1,73,115},{13,0,1,1,73,116},{14,1,1,1,73,116},{0,1,1,1,73,32},{0,1,1,1,73,37},{0,1,1,1,73,45},{0,1,1,1,73,46},{0,1,1,1,73,47},{0,1,1,1,73,51},{0,1,1,1,73,52},{0,1,1,1,73,53},{0,1,1,1,73,54},{0,1,1,1,73,55},{0,1,1,1,73,56},{0,1,1,1,73,57},{0,1,1,1,73,61},{0,1,1,1,73,65},{0,1,1,1,73,95},{0,1,1,1,73,98},{0,1,1,1,73,100},{0,1,1,1,73,102},{0,1,1,1,73,103},{0,1,1,1,73,104},{0,1,1,1,73,108},{0,1,1,1,73,109},{0,1,1,1,73,110},{0,1,1,1,73,112},{0,1,1,1,73,114},{0,1,1,1,73,117},{17,0,0,1,0,73},{18,0,0,1,0,73},{19,0,0,1,0,73},{20,0,0,1,0,73},{21,0,0,1,0,73},{22,0,0,1,0,73},{23,0,0,1,0,73},{24,0,0,1,0,73},{25,0,0,1,0,73},{26,0,0,1,0,73},{27,0,0,1,0,73},{28,0,0,1,0,73},{29,0,0,1,0,73},{30,0,0,1,0,73},{31,0,0,1,0,73},{32,0,0,1,0,73},{33,0,0,1,0,73},{34,1,0,1,0,73},{13,0,1,1,74,48},{14,1,1,1,74,48},{13,0,1,1,74,49},{14,1,1,1,74,49},{13,0,1,1,74,50},{14,1,1,1,74,50},{13,0,1,1,74,97},{14,1,1,1,74,97},{13,0,1,1,74,99},{14,1,1,1,74,99},{13,0,1,1,74,101},{14,1,1,1,74,101},{13,0,1,1,74,105},{14,1,1,1,74,105},{13,0,1,1,74,111},{14,1,1,1,74,111},{13,0,1,1,74,115},{14,1,1,1,74,115},{13,0,1,1,74,116},{14,1,1,1,74,116},{0,1,1,1,74,32},{0,1,1,1,74,37},{0,1,1,1,74,45},{0,1,1,1,74,46},{0,1,1,1,74,47},{0,1,1,1,74,51},{0,1,1,1,74,52},{0,1,1,1,74,53},{0,1,1,1,74,54},{0,1,1,1,74,55},{0,1,1,1,74,56},{0,1,1,1,74,57},{0,1,1,1,74,61},{0,1,1,1,74,65},{0,1,1,1,74,95},{0,1,1,1,74,98},{0,1,1,1,74,100},{0,1,1,1,74,102},{0,1,1,1,74,103},{0,1,1,1,74,104},{0,1,1,1,74,108},{0,1,1,1,74,109},{0,1,1,1,74,110},{0,1,1,1,74,112},{0,1,1,1,74,114},{0,1,1,1,74,117},{17,0,0,1,0,74},{18,0,0,1,0,74},{19,0,0,1,0,74},{20,0,0,1,0,74},{21,0,0,1,0,74},{22,0,0,1,0,74},{23,0,0,1,0,74},{24,0,0,1,0,74},{25,0,0,1,0,74},{26,0,0,1,0,74},{27,0,0,1,0,74},{28,0,0,1,0,74},{29,0,0,1,0,74},{30,0,0,1,0,74},{31,0,0,1,0,74},{32,0,0,1,0,74},{33,0,0,1,0,74},{34,1,0,1,0,74},{13,0,1,1,75,48},{14,1,1,1,75,48},{13,0,1,1,75,49},{14,1,1,1,75,49},{13,0,1,1,75,50},{14,1,1,1,75,50},{13,0,1,1,75,97},{14,1,1,1,75,97},{13,0,1,1,75,99},{14,1,1,1,75,99},{13,0,1,1,75,101},{14,1,1,1,75,101},{13,0,1,1,75,105},{14,1,1,1,75,105},{13,0,1,1,75,111},{14,1,1,1,75,111},{13,0,1,1,75,115},{14,1,1,1,75,115},{13,0,1,1,75,116},{14,1,1,1,75,116},{0,1,1,1,75,32},{0,1,1,1,75,37},{0,1,1,1,75,45},{0,1,1,1,75,46},{0,1,1,1,75,47},{0,1,1,1,75,51},{0,1,1,1,75,52},{0,1,1,1,75,53},{0,1,1,1,75,54},{0,1,1,1,75,55},{0,1,1,1,75,56},{0,1,1,1,75,57},{0,1,1,1,75,61},{0,1,1,1,75,65},{0,1,1,1,75,95},{0,1,1,1,75,98},{0,1,1,1,75,100},{0,1,1,1,75,102},{0,1,1,1,75,103},{0,1,1,1,75,104},{0,1,1,1,75,108},{0,1,1,1,75,109},{0,1,1,1,75,110},{0,1,1,1,75,112},{0,1,1,1,75,114},{0,1,1,1,75,117},{17,0,0,1,0,75},{18,0,0,1,0,75},{19,0,0,1,0,75},{20,0,0,1,0,75},{21,0,0,1,0,75},{22,0,0,1,0,75},{23,0,0,1,0,75},{24,0,0,1,0,75},{25,0,0,1,0,75},{26,0,0,1,0,75},{27,0,0,1,0,75},{28,0,0,1,0,75},{29,0,0,1,0,75},{30,0,0,1,0,75},{31,0,0,1,0,75},{32,0,0,1,0,75},{33,0,0,1,0,75},{34,1,0,1,0,75},{13,0,1,1,76,48},{14,1,1,1,76,48},{13,0,1,1,76,49},{14,1,1,1,76,49},{13,0,1,1,76,50},{14,1,1,1,76,50},{13,0,1,1,76,97},{14,1,1,1,76,97},{13,0,1,1,76,99},{14,1,1,1,76,99},{13,0,1,1,76,101},{14,1,1,1,76,101},{13,0,1,1,76,105},{14,1,1,1,76,105},{13,0,1,1,76,111},{14,1,1,1,76,111},{13,0,1,1,76,115},{14,1,1,1,76,115},{13,0,1,1,76,116},{14,1,1,1,76,116},{0,1,1,1,76,32},{0,1,1,1,76,37},{0,1,1,1,76,45},{0,1,1,1,76,46},{0,1,1,1,76,47},{0,1,1,1,76,51},{0,1,1,1,76,52},{0,1,1,1,76,53},{0,1,1,1,76,54},{0,1,1,1,76,55},{0,1,1,1,76,56},{0,1,1,1,76,57},{0,1,1,1,76,61},{0,1,1,1,76,65},{0,1,1,1,76,95},{0,1,1,1,76,98},{0,1,1,1,76,100},{0,1,1,1,76,102},{0,1,1,1,76,103},{0,1,1,1,76,104},{0,1,1,1,76,108},{0,1,1,1,76,109},{0,1,1,1,76,110},{0,1,1,1,76,112},{0,1,1,1,76,114},{0,1,1,1,76,117},{17,0,0,1,0,76},{18,0,0,1,0,76},{19,0,0,1,0,76},{20,0,0,1,0,76},{21,0,0,1,0,76},{22,0,0,1,0,76},{23,0,0,1,0,76},{24,0,0,1,0,76},{25,0,0,1,0,76},{26,0,0,1,0,76},{27,0,0,1,0,76},{28,0,0,1,0,76},{29,0,0,1,0,76},{30,0,0,1,0,76},{31,0,0,1,0,76},{32,0,0,1,0,76},{33,0,0,1,0,76},{34,1,0,1,0,76},{13,0,1,1,77,48},{14,1,1,1,77,48},{13,0,1,1,77,49},{14,1,1,1,77,49},{13,0,1,1,77,50},{14,1,1,1,77,50},{13,0,1,1,77,97},{14,1,1,1,77,97},{13,0,1,1,77,99},{14,1,1,1,77,99},{13,0,1,1,77,101},{14,1,1,1,77,101},{13,0,1,1,77,105},{14,1,1,1,77,105},{13,0,1,1,77,111},{14,1,1,1,77,111},{13,0,1,1,77,115},{14,1,1,1,77,115},{13,0,1,1,77,116},{14,1,1,1,77,116},{0,1,1,1,77,32},{0,1,1,1,77,37},{0,1,1,1,77,45},{0,1,1,1,77,46},{0,1,1,1,77,47},{0,1,1,1,77,51},{0,1,1,1,77,52},{0,1,1,1,77,53},{0,1,1,1,77,54},{0,1,1,1,77,55},{0,1,1,1,77,56},{0,1,1,1,77,57},{0,1,1,1,77,61},{0,1,1,1,77,65},{0,1,1,1,77,95},{0,1,1,1,77,98},{0,1,1,1,77,100},{0,1,1,1,77,102},{0,1,1,1,77,103},{0,1,1,1,77,104},{0,1,1,1,77,108},{0,1,1,1,77,109},{0,1,1,1,77,110},{0,1,1,1,77,112},{0,1,1,1,77,114},{0,1,1,1,77,117},{17,0,0,1,0,77},{18,0,0,1,0,77},{19,0,0,1,0,77},{20,0,0,1,0,77},{21,0,0,1,0,77},{22,0,0,1,0,77},{23,0,0,1,0,77},{24,0,0,1,0,77},{25,0,0,1,0,77},{26,0,0,1,0,77},{27,0,0,1,0,77},{28,0,0,1,0,77},{29,0,0,1,0,77},{30,0,0,1,0,77},{31,0,0,1,0,77},{32,0,0,1,0,77},{33,0,0,1,0,77},{34,1,0,1,0,77},{13,0,1,1,78,48},{14,1,1,1,78,48},{13,0,1,1,78,49},{14,1,1,1,78,49},{13,0,1,1,78,50},{14,1,1,1,78,50},{13,0,1,1,78,97},{14,1,1,1,78,97},{13,0,1,1,78,99},{14,1,1,1,78,99},{13,0,1,1,78,101},{14,1,1,1,78,101},{13,0,1,1,78,105},{14,1,1,1,78,105},{13,0,1,1,78,111},{14,1,1,1,78,111},{13,0,1,1,78,115},{14,1,1,1,78,115},{13,0,1,1,78,116},{14,1,1,1,78,116},{0,1,1,1,78,32},{0,1,1,1,78,37},{0,1,1,1,78,45},{0,1,1,1,78,46},{0,1,1,1,78,47},{0,1,1,1,78,51},{0,1,1,1,78,52},{0,1,1,1,78,53},{0,1,1,1,78,54},{0,1,1,1,78,55},{0,1,1,1,78,56},{0,1,1,1,78,57},{0,1,1,1,78,61},{0,1,1,1,78,65},{0,1,1,1,78,95},{0,1,1,1,78,98},{0,1,1,1,78,100},{0,1,1,1,78,102},{0,1,1,1,78,103},{0,1,1,1,78,104},{0,1,1,1,78,108},{0,1,1,1,78,109},{0,1,1,1,78,110},{0,1,1,1,78,112},{0,1,1,1,78,114},{0,1,1,1,78,117},{17,0,0,1,0,78},{18,0,0,1,0,78},{19,0,0,1,0,78},{20,0,0,1,0,78},{21,0,0,1,0,78},{22,0,0,1,0,78},{23,0,0,1,0,78},{24,0,0,1,0,78},{25,0,0,1,0,78},{26,0,0,1,0,78},{27,0,0,1,0,78},{28,0,0,1,0,78},{29,0,0,1,0,78},{30,0,0,1,0,78},{31,0,0,1,0,78},{32,0,0,1,0,78},{33,0,0,1,0,78},{34,1,0,1,0,78},{13,0,1,1,79,48},{14,1,1,1,79,48},{13,0,1,1,79,49},{14,1,1,1,79,49},{13,0,1,1,79,50},{14,1,1,1,79,50},{13,0,1,1,79,97},{14,1,1,1,79,97},{13,0,1,1,79,99},{14,1,1,1,79,99},{13,0,1,1,79,101},{14,1,1,1,79,101},{13,0,1,1,79,105},{14,1,1,1,79,105},{13,0,1,1,79,111},{14,1,1,1,79,111},{13,0,1,1,79,115},{14,1,1,1,79,115},{13,0,1,1,79,116},{14,1,1,1,79,116},{0,1,1,1,79,32},{0,1,1,1,79,37},{0,1,1,1,79,45},{0,1,1,1,79,46},{0,1,1,1,79,47},{0,1,1,1,79,51},{0,1,1,1,79,52},{0,1,1,1,79,53},{0,1,1,1,79,54},{0,1,1,1,79,55},{0,1,1,1,79,56},{0,1,1,1,79,57},{0,1,1,1,79,61},{0,1,1,1,79,65},{0,1,1,1,79,95},{0,1,1,1,79,98},{0,1,1,1,79,100},{0,1,1,1,79,102},{0,1,1,1,79,103},{0,1,1,1,79,104},{0,1,1,1,79,108},{0,1,1,1,79,109},{0,1,1,1,79,110},{0,1,1,1,79,112},{0,1,1,1,79,114},{0,1,1,1,79,117},{17,0,0,1,0,79},{18,0,0,1,0,79},{19,0,0,1,0,79},{20,0,0,1,0,79},{21,0,0,1,0,79},{22,0,0,1,0,79},{23,0,0,1,0,79},{24,0,0,1,0,79},{25,0,0,1,0,79},{26,0,0,1,0,79},{27,0,0,1,0,79},{28,0,0,1,0,79},{29,0,0,1,0,79},{30,0,0,1,0,79},{31,0,0,1,0,79},{32,0,0,1,0,79},{33,0,0,1,0,79},{34,1,0,1,0,79},{13,0,1,1,80,48},{14,1,1,1,80,48},{13,0,1,1,80,49},{14,1,1,1,80,49},{13,0,1,1,80,50},{14,1,1,1,80,50},{13,0,1,1,80,97},{14,1,1,1,80,97},{13,0,1,1,80,99},{14,1,1,1,80,99},{13,0,1,1,80,101},{14,1,1,1,80,101},{13,0,1,1,80,105},{14,1,1,1,80,105},{13,0,1,1,80,111},{14,1,1,1,80,111},{13,0,1,1,80,115},{14,1,1,1,80,115},{13,0,1,1,80,116},{14,1,1,1,80,116},{0,1,1,1,80,32},{0,1,1,1,80,37},{0,1,1,1,80,45},{0,1,1,1,80,46},{0,1,1,1,80,47},{0,1,1,1,80,51},{0,1,1,1,80,52},{0,1,1,1,80,53},{0,1,1,1,80,54},{0,1,1,1,80,55},{0,1,1,1,80,56},{0,1,1,1,80,57},{0,1,1,1,80,61},{0,1,1,1,80,65},{0,1,1,1,80,95},{0,1,1,1,80,98},{0,1,1,1,80,100},{0,1,1,1,80,102},{0,1,1,1,80,103},{0,1,1,1,80,104},{0,1,1,1,80,108},{0,1,1,1,80,109},{0,1,1,1,80,110},{0,1,1,1,80,112},{0,1,1,1,80,114},{0,1,1,1,80,117},{17,0,0,1,0,80},{18,0,0,1,0,80},{19,0,0,1,0,80},{20,0,0,1,0,80},{21,0,0,1,0,80},{22,0,0,1,0,80},{23,0,0,1,0,80},{24,0,0,1,0,80},{25,0,0,1,0,80},{26,0,0,1,0,80},{27,0,0,1,0,80},{28,0,0,1,0,80},{29,0,0,1,0,80},{30,0,0,1,0,80},{31,0,0,1,0,80},{32,0,0,1,0,80},{33,0,0,1,0,80},{34,1,0,1,0,80},{13,0,1,1,81,48},{14,1,1,1,81,48},{13,0,1,1,81,49},{14,1,1,1,81,49},{13,0,1,1,81,50},{14,1,1,1,81,50},{13,0,1,1,81,97},{14,1,1,1,81,97},{13,0,1,1,81,99},{14,1,1,1,81,99},{13,0,1,1,81,101},{14,1,1,1,81,101},{13,0,1,1,81,105},{14,1,1,1,81,105},{13,0,1,1,81,111},{14,1,1,1,81,111},{13,0,1,1,81,115},{14,1,1,1,81,115},{13,0,1,1,81,116},{14,1,1,1,81,116},{0,1,1,1,81,32},{0,1,1,1,81,37},{0,1,1,1,81,45},{0,1,1,1,81,46},{0,1,1,1,81,47},{0,1,1,1,81,51},{0,1,1,1,81,52},{0,1,1,1,81,53},{0,1,1,1,81,54},{0,1,1,1,81,55},{0,1,1,1,81,56},{0,1,1,1,81,57},{0,1,1,1,81,61},{0,1,1,1,81,65},{0,1,1,1,81,95},{0,1,1,1,81,98},{0,1,1,1,81,100},{0,1,1,1,81,102},{0,1,1,1,81,103},{0,1,1,1,81,104},{0,1,1,1,81,108},{0,1,1,1,81,109},{0,1,1,1,81,110},{0,1,1,1,81,112},{0,1,1,1,81,114},{0,1,1,1,81,117},{17,0,0,1,0,81},{18,0,0,1,0,81},{19,0,0,1,0,81},{20,0,0,1,0,81},{21,0,0,1,0,81},{22,0,0,1,0,81},{23,0,0,1,0,81},{24,0,0,1,0,81},{25,0,0,1,0,81},{26,0,0,1,0,81},{27,0,0,1,0,81},{28,0,0,1,0,81},{29,0,0,1,0,81},{30,0,0,1,0,81},{31,0,0,1,0,81},{32,0,0,1,0,81},{33,0,0,1,0,81},{34,1,0,1,0,81},{13,0,1,1,82,48},{14,1,1,1,82,48},{13,0,1,1,82,49},{14,1,1,1,82,49},{13,0,1,1,82,50},{14,1,1,1,82,50},{13,0,1,1,82,97},{14,1,1,1,82,97},{13,0,1,1,82,99},{14,1,1,1,82,99},{13,0,1,1,82,101},{14,1,1,1,82,101},{13,0,1,1,82,105},{14,1,1,1,82,105},{13,0,1,1,82,111},{14,1,1,1,82,111},{13,0,1,1,82,115},{14,1,1,1,82,115},{13,0,1,1,82,116},{14,1,1,1,82,116},{0,1,1,1,82,32},{0,1,1,1,82,37},{0,1,1,1,82,45},{0,1,1,1,82,46},{0,1,1,1,82,47},{0,1,1,1,82,51},{0,1,1,1,82,52},{0,1,1,1,82,53},{0,1,1,1,82,54},{0,1,1,1,82,55},{0,1,1,1,82,56},{0,1,1,1,82,57},{0,1,1,1,82,61},{0,1,1,1,82,65},{0,1,1,1,82,95},{0,1,1,1,82,98},{0,1,1,1,82,100},{0,1,1,1,82,102},{0,1,1,1,82,103},{0,1,1,1,82,104},{0,1,1,1,82,108},{0,1,1,1,82,109},{0,1,1,1,82,110},{0,1,1,1,82,112},{0,1,1,1,82,114},{0,1,1,1,82,117},{17,0,0,1,0,82},{18,0,0,1,0,82},{19,0,0,1,0,82},{20,0,0,1,0,82},{21,0,0,1,0,82},{22,0,0,1,0,82},{23,0,0,1,0,82},{24,0,0,1,0,82},{25,0,0,1,0,82},{26,0,0,1,0,82},{27,0,0,1,0,82},{28,0,0,1,0,82},{29,0,0,1,0,82},{30,0,0,1,0,82},{31,0,0,1,0,82},{32,0,0,1,0,82},{33,0,0,1,0,82},{34,1,0,1,0,82},{13,0,1,1,83,48},{14,1,1,1,83,48},{13,0,1,1,83,49},{14,1,1,1,83,49},{13,0,1,1,83,50},{14,1,1,1,83,50},{13,0,1,1,83,97},{14,1,1,1,83,97},{13,0,1,1,83,99},{14,1,1,1,83,99},{13,0,1,1,83,101},{14,1,1,1,83,101},{13,0,1,1,83,105},{14,1,1,1,83,105},{13,0,1,1,83,111},{14,1,1,1,83,111},{13,0,1,1,83,115},{14,1,1,1,83,115},{13,0,1,1,83,116},{14,1,1,1,83,116},{0,1,1,1,83,32},{0,1,1,1,83,37},{0,1,1,1,83,45},{0,1,1,1,83,46},{0,1,1,1,83,47},{0,1,1,1,83,51},{0,1,1,1,83,52},{0,1,1,1,83,53},{0,1,1,1,83,54},{0,1,1,1,83,55},{0,1,1,1,83,56},{0,1,1,1,83,57},{0,1,1,1,83,61},{0,1,1,1,83,65},{0,1,1,1,83,95},{0,1,1,1,83,98},{0,1,1,1,83,100},{0,1,1,1,83,102},{0,1,1,1,83,103},{0,1,1,1,83,104},{0,1,1,1,83,108},{0,1,1,1,83,109},{0,1,1,1,83,110},{0,1,1,1,83,112},{0,1,1,1,83,114},{0,1,1,1,83,117},{17,0,0,1,0,83},{18,0,0,1,0,83},{19,0,0,1,0,83},{20,0,0,1,0,83},{21,0,0,1,0,83},{22,0,0,1,0,83},{23,0,0,1,0,83},{24,0,0,1,0,83},{25,0,0,1,0,83},{26,0,0,1,0,83},{27,0,0,1,0,83},{28,0,0,1,0,83},{29,0,0,1,0,83},{30,0,0,1,0,83},{31,0,0,1,0,83},{32,0,0,1,0,83},{33,0,0,1,0,83},{34,1,0,1,0,83},{13,0,1,1,84,48},{14,1,1,1,84,48},{13,0,1,1,84,49},{14,1,1,1,84,49},{13,0,1,1,84,50},{14,1,1,1,84,50},{13,0,1,1,84,97},{14,1,1,1,84,97},{13,0,1,1,84,99},{14,1,1,1,84,99},{13,0,1,1,84,101},{14,1,1,1,84,101},{13,0,1,1,84,105},{14,1,1,1,84,105},{13,0,1,1,84,111},{14,1,1,1,84,111},{13,0,1,1,84,115},{14,1,1,1,84,115},{13,0,1,1,84,116},{14,1,1,1,84,116},{0,1,1,1,84,32},{0,1,1,1,84,37},{0,1,1,1,84,45},{0,1,1,1,84,46},{0,1,1,1,84,47},{0,1,1,1,84,51},{0,1,1,1,84,52},{0,1,1,1,84,53},{0,1,1,1,84,54},{0,1,1,1,84,55},{0,1,1,1,84,56},{0,1,1,1,84,57},{0,1,1,1,84,61},{0,1,1,1,84,65},{0,1,1,1,84,95},{0,1,1,1,84,98},{0,1,1,1,84,100},{0,1,1,1,84,102},{0,1,1,1,84,103},{0,1,1,1,84,104},{0,1,1,1,84,108},{0,1,1,1,84,109},{0,1,1,1,84,110},{0,1,1,1,84,112},{0,1,1,1,84,114},{0,1,1,1,84,117},{17,0,0,1,0,84},{18,0,0,1,0,84},{19,0,0,1,0,84},{20,0,0,1,0,84},{21,0,0,1,0,84},{22,0,0,1,0,84},{23,0,0,1,0,84},{24,0,0,1,0,84},{25,0,0,1,0,84},{26,0,0,1,0,84},{27,0,0,1,0,84},{28,0,0,1,0,84},{29,0,0,1,0,84},{30,0,0,1,0,84},{31,0,0,1,0,84},{32,0,0,1,0,84},{33,0,0,1,0,84},{34,1,0,1,0,84},{13,0,1,1,85,48},{14,1,1,1,85,48},{13,0,1,1,85,49},{14,1,1,1,85,49},{13,0,1,1,85,50},{14,1,1,1,85,50},{13,0,1,1,85,97},{14,1,1,1,85,97},{13,0,1,1,85,99},{14,1,1,1,85,99},{13,0,1,1,85,101},{14,1,1,1,85,101},{13,0,1,1,85,105},{14,1,1,1,85,105},{13,0,1,1,85,111},{14,1,1,1,85,111},{13,0,1,1,85,115},{14,1,1,1,85,115},{13,0,1,1,85,116},{14,1,1,1,85,116},{0,1,1,1,85,32},{0,1,1,1,85,37},{0,1,1,1,85,45},{0,1,1,1,85,46},{0,1,1,1,85,47},{0,1,1,1,85,51},{0,1,1,1,85,52},{0,1,1,1,85,53},{0,1,1,1,85,54},{0,1,1,1,85,55},{0,1,1,1,85,56},{0,1,1,1,85,57},{0,1,1,1,85,61},{0,1,1,1,85,65},{0,1,1,1,85,95},{0,1,1,1,85,98},{0,1,1,1,85,100},{0,1,1,1,85,102},{0,1,1,1,85,103},{0,1,1,1,85,104},{0,1,1,1,85,108},{0,1,1,1,85,109},{0,1,1,1,85,110},{0,1,1,1,85,112},{0,1,1,1,85,114},{0,1,1,1,85,117},{17,0,0,1,0,85},{18,0,0,1,0,85},{19,0,0,1,0,85},{20,0,0,1,0,85},{21,0,0,1,0,85},{22,0,0,1,0,85},{23,0,0,1,0,85},{24,0,0,1,0,85},{25,0,0,1,0,85},{26,0,0,1,0,85},{27,0,0,1,0,85},{28,0,0,1,0,85},{29,0,0,1,0,85},{30,0,0,1,0,85},{31,0,0,1,0,85},{32,0,0,1,0,85},{33,0,0,1,0,85},{34,1,0,1,0,85},{13,0,1,1,86,48},{14,1,1,1,86,48},{13,0,1,1,86,49},{14,1,1,1,86,49},{13,0,1,1,86,50},{14,1,1,1,86,50},{13,0,1,1,86,97},{14,1,1,1,86,97},{13,0,1,1,86,99},{14,1,1,1,86,99},{13,0,1,1,86,101},{14,1,1,1,86,101},{13,0,1,1,86,105},{14,1,1,1,86,105},{13,0,1,1,86,111},{14,1,1,1,86,111},{13,0,1,1,86,115},{14,1,1,1,86,115},{13,0,1,1,86,116},{14,1,1,1,86,116},{0,1,1,1,86,32},{0,1,1,1,86,37},{0,1,1,1,86,45},{0,1,1,1,86,46},{0,1,1,1,86,47},{0,1,1,1,86,51},{0,1,1,1,86,52},{0,1,1,1,86,53},{0,1,1,1,86,54},{0,1,1,1,86,55},{0,1,1,1,86,56},{0,1,1,1,86,57},{0,1,1,1,86,61},{0,1,1,1,86,65},{0,1,1,1,86,95},{0,1,1,1,86,98},{0,1,1,1,86,100},{0,1,1,1,86,102},{0,1,1,1,86,103},{0,1,1,1,86,104},{0,1,1,1,86,108},{0,1,1,1,86,109},{0,1,1,1,86,110},{0,1,1,1,86,112},{0,1,1,1,86,114},{0,1,1,1,86,117},{17,0,0,1,0,86},{18,0,0,1,0,86},{19,0,0,1,0,86},{20,0,0,1,0,86},{21,0,0,1,0,86},{22,0,0,1,0,86},{23,0,0,1,0,86},{24,0,0,1,0,86},{25,0,0,1,0,86},{26,0,0,1,0,86},{27,0,0,1,0,86},{28,0,0,1,0,86},{29,0,0,1,0,86},{30,0,0,1,0,86},{31,0,0,1,0,86},{32,0,0,1,0,86},{33,0,0,1,0,86},{34,1,0,1,0,86},{13,0,1,1,87,48},{14,1,1,1,87,48},{13,0,1,1,87,49},{14,1,1,1,87,49},{13,0,1,1,87,50},{14,1,1,1,87,50},{13,0,1,1,87,97},{14,1,1,1,87,97},{13,0,1,1,87,99},{14,1,1,1,87,99},{13,0,1,1,87,101},{14,1,1,1,87,101},{13,0,1,1,87,105},{14,1,1,1,87,105},{13,0,1,1,87,111},{14,1,1,1,87,111},{13,0,1,1,87,115},{14,1,1,1,87,115},{13,0,1,1,87,116},{14,1,1,1,87,116},{0,1,1,1,87,32},{0,1,1,1,87,37},{0,1,1,1,87,45},{0,1,1,1,87,46},{0,1,1,1,87,47},{0,1,1,1,87,51},{0,1,1,1,87,52},{0,1,1,1,87,53},{0,1,1,1,87,54},{0,1,1,1,87,55},{0,1,1,1,87,56},{0,1,1,1,87,57},{0,1,1,1,87,61},{0,1,1,1,87,65},{0,1,1,1,87,95},{0,1,1,1,87,98},{0,1,1,1,87,100},{0,1,1,1,87,102},{0,1,1,1,87,103},{0,1,1,1,87,104},{0,1,1,1,87,108},{0,1,1,1,87,109},{0,1,1,1,87,110},{0,1,1,1,87,112},{0,1,1,1,87,114},{0,1,1,1,87,117},{17,0,0,1,0,87},{18,0,0,1,0,87},{19,0,0,1,0,87},{20,0,0,1,0,87},{21,0,0,1,0,87},{22,0,0,1,0,87},{23,0,0,1,0,87},{24,0,0,1,0,87},{25,0,0,1,0,87},{26,0,0,1,0,87},{27,0,0,1,0,87},{28,0,0,1,0,87},{29,0,0,1,0,87},{30,0,0,1,0,87},{31,0,0,1,0,87},{32,0,0,1,0,87},{33,0,0,1,0,87},{34,1,0,1,0,87},{13,0,1,1,89,48},{14,1,1,1,89,48},{13,0,1,1,89,49},{14,1,1,1,89,49},{13,0,1,1,89,50},{14,1,1,1,89,50},{13,0,1,1,89,97},{14,1,1,1,89,97},{13,0,1,1,89,99},{14,1,1,1,89,99},{13,0,1,1,89,101},{14,1,1,1,89,101},{13,0,1,1,89,105},{14,1,1,1,89,105},{13,0,1,1,89,111},{14,1,1,1,89,111},{13,0,1,1,89,115},{14,1,1,1,89,115},{13,0,1,1,89,116},{14,1,1,1,89,116},{0,1,1,1,89,32},{0,1,1,1,89,37},{0,1,1,1,89,45},{0,1,1,1,89,46},{0,1,1,1,89,47},{0,1,1,1,89,51},{0,1,1,1,89,52},{0,1,1,1,89,53},{0,1,1,1,89,54},{0,1,1,1,89,55},{0,1,1,1,89,56},{0,1,1,1,89,57},{0,1,1,1,89,61},{0,1,1,1,89,65},{0,1,1,1,89,95},{0,1,1,1,89,98},{0,1,1,1,89,100},{0,1,1,1,89,102},{0,1,1,1,89,103},{0,1,1,1,89,104},{0,1,1,1,89,108},{0,1,1,1,89,109},{0,1,1,1,89,110},{0,1,1,1,89,112},{0,1,1,1,89,114},{0,1,1,1,89,117},{17,0,0,1,0,89},{18,0,0,1,0,89},{19,0,0,1,0,89},{20,0,0,1,0,89},{21,0,0,1,0,89},{22,0,0,1,0,89},{23,0,0,1,0,89},{24,0,0,1,0,89},{25,0,0,1,0,89},{26,0,0,1,0,89},{27,0,0,1,0,89},{28,0,0,1,0,89},{29,0,0,1,0,89},{30,0,0,1,0,89},{31,0,0,1,0,89},{32,0,0,1,0,89},{33,0,0,1,0,89},{34,1,0,1,0,89},{13,0,1,1,106,48},{14,1,1,1,106,48},{13,0,1,1,106,49},{14,1,1,1,106,49},{13,0,1,1,106,50},{14,1,1,1,106,50},{13,0,1,1,106,97},{14,1,1,1,106,97},{13,0,1,1,106,99},{14,1,1,1,106,99},{13,0,1,1,106,101},{14,1,1,1,106,101},{13,0,1,1,106,105},{14,1,1,1,106,105},{13,0,1,1,106,111},{14,1,1,1,106,111},{13,0,1,1,106,115},{14,1,1,1,106,115},{13,0,1,1,106,116},{14,1,1,1,106,116},{0,1,1,1,106,32},{0,1,1,1,106,37},{0,1,1,1,106,45},{0,1,1,1,106,46},{0,1,1,1,106,47},{0,1,1,1,106,51},{0,1,1,1,106,52},{0,1,1,1,106,53},{0,1,1,1,106,54},{0,1,1,1,106,55},{0,1,1,1,106,56},{0,1,1,1,106,57},{0,1,1,1,106,61},{0,1,1,1,106,65},{0,1,1,1,106,95},{0,1,1,1,106,98},{0,1,1,1,106,100},{0,1,1,1,106,102},{0,1,1,1,106,103},{0,1,1,1,106,104},{0,1,1,1,106,108},{0,1,1,1,106,109},{0,1,1,1,106,110},{0,1,1,1,106,112},{0,1,1,1,106,114},{0,1,1,1,106,117},{17,0,0,1,0,106},{18,0,0,1,0,106},{19,0,0,1,0,106},{20,0,0,1,0,106},{21,0,0,1,0,106},{22,0,0,1,0,106},{23,0,0,1,0,106},{24,0,0,1,0,106},{25,0,0,1,0,106},{26,0,0,1,0,106},{27,0,0,1,0,106},{28,0,0,1,0,106},{29,0,0,1,0,106},{30,0,0,1,0,106},{31,0,0,1,0,106},{32,0,0,1,0,106},{33,0,0,1,0,106},{34,1,0,1,0,106},{13,0,1,1,107,48},{14,1,1,1,107,48},{13,0,1,1,107,49},{14,1,1,1,107,49},{13,0,1,1,107,50},{14,1,1,1,107,50},{13,0,1,1,107,97},{14,1,1,1,107,97},{13,0,1,1,107,99},{14,1,1,1,107,99},{13,0,1,1,107,101},{14,1,1,1,107,101},{13,0,1,1,107,105},{14,1,1,1,107,105},{13,0,1,1,107,111},{14,1,1,1,107,111},{13,0,1,1,107,115},{14,1,1,1,107,115},{13,0,1,1,107,116},{14,1,1,1,107,116},{0,1,1,1,107,32},{0,1,1,1,107,37},{0,1,1,1,107,45},{0,1,1,1,107,46},{0,1,1,1,107,47},{0,1,1,1,107,51},{0,1,1,1,107,52},{0,1,1,1,107,53},{0,1,1,1,107,54},{0,1,1,1,107,55},{0,1,1,1,107,56},{0,1,1,1,107,57},{0,1,1,1,107,61},{0,1,1,1,107,65},{0,1,1,1,107,95},{0,1,1,1,107,98},{0,1,1,1,107,100},{0,1,1,1,107,102},{0,1,1,1,107,103},{0,1,1,1,107,104},{0,1,1,1,107,108},{0,1,1,1,107,109},{0,1,1,1,107,110},{0,1,1,1,107,112},{0,1,1,1,107,114},{0,1,1,1,107,117},{17,0,0,1,0,107},{18,0,0,1,0,107},{19,0,0,1,0,107},{20,0,0,1,0,107},{21,0,0,1,0,107},{22,0,0,1,0,107},{23,0,0,1,0,107},{24,0,0,1,0,107},{25,0,0,1,0,107},{26,0,0,1,0,107},{27,0,0,1,0,107},{28,0,0,1,0,107},{29,0,0,1,0,107},{30,0,0,1,0,107},{31,0,0,1,0,107},{32,0,0,1,0,107},{33,0,0,1,0,107},{34,1,0,1,0,107},{13,0,1,1,113,48},{14,1,1,1,113,48},{13,0,1,1,113,49},{14,1,1,1,113,49},{13,0,1,1,113,50},{14,1,1,1,113,50},{13,0,1,1,113,97},{14,1,1,1,113,97},{13,0,1,1,113,99},{14,1,1,1,113,99},{13,0,1,1,113,101},{14,1,1,1,113,101},{13,0,1,1,113,105},{14,1,1,1,113,105},{13,0,1,1,113,111},{14,1,1,1,113,111},{13,0,1,1,113,115},{14,1,1,1,113,115},{13,0,1,1,113,116},{14,1,1,1,113,116},{0,1,1,1,113,32},{0,1,1,1,113,37},{0,1,1,1,113,45},{0,1,1,1,113,46},{0,1,1,1,113,47},{0,1,1,1,113,51},{0,1,1,1,113,52},{0,1,1,1,113,53},{0,1,1,1,113,54},{0,1,1,1,113,55},{0,1,1,1,113,56},{0,1,1,1,113,57},{0,1,1,1,113,61},{0,1,1,1,113,65},{0,1,1,1,113,95},{0,1,1,1,113,98},{0,1,1,1,113,100},{0,1,1,1,113,102},{0,1,1,1,113,103},{0,1,1,1,113,104},{0,1,1,1,113,108},{0,1,1,1,113,109},{0,1,1,1,113,110},{0,1,1,1,113,112},{0,1,1,1,113,114},{0,1,1,1,113,117},{17,0,0,1,0,113},{18,0,0,1,0,113},{19,0,0,1,0,113},{20,0,0,1,0,113},{21,0,0,1,0,113},{22,0,0,1,0,113},{23,0,0,1,0,113},{24,0,0,1,0,113},{25,0,0,1,0,113},{26,0,0,1,0,113},{27,0,0,1,0,113},{28,0,0,1,0,113},{29,0,0,1,0,113},{30,0,0,1,0,113},{31,0,0,1,0,113},{32,0,0,1,0,113},{33,0,0,1,0,113},{34,1,0,1,0,113},{13,0,1,1,118,48},{14,1,1,1,118,48},{13,0,1,1,118,49},{14,1,1,1,118,49},{13,0,1,1,118,50},{14,1,1,1,118,50},{13,0,1,1,118,97},{14,1,1,1,118,97},{13,0,1,1,118,99},{14,1,1,1,118,99},{13,0,1,1,118,101},{14,1,1,1,118,101},{13,0,1,1,118,105},{14,1,1,1,118,105},{13,0,1,1,118,111},{14,1,1,1,118,111},{13,0,1,1,118,115},{14,1,1,1,118,115},{13,0,1,1,118,116},{14,1,1,1,118,116},{0,1,1,1,118,32},{0,1,1,1,118,37},{0,1,1,1,118,45},{0,1,1,1,118,46},{0,1,1,1,118,47},{0,1,1,1,118,51},{0,1,1,1,118,52},{0,1,1,1,118,53},{0,1,1,1,118,54},{0,1,1,1,118,55},{0,1,1,1,118,56},{0,1,1,1,118,57},{0,1,1,1,118,61},{0,1,1,1,118,65},{0,1,1,1,118,95},{0,1,1,1,118,98},{0,1,1,1,118,100},{0,1,1,1,118,102},{0,1,1,1,118,103},{0,1,1,1,118,104},{0,1,1,1,118,108},{0,1,1,1,118,109},{0,1,1,1,118,110},{0,1,1,1,118,112},{0,1,1,1,118,114},{0,1,1,1,118,117},{17,0,0,1,0,118},{18,0,0,1,0,118},{19,0,0,1,0,118},{20,0,0,1,0,118},{21,0,0,1,0,118},{22,0,0,1,0,118},{23,0,0,1,0,118},{24,0,0,1,0,118},{25,0,0,1,0,118},{26,0,0,1,0,118},{27,0,0,1,0,118},{28,0,0,1,0,118},{29,0,0,1,0,118},{30,0,0,1,0,118},{31,0,0,1,0,118},{32,0,0,1,0,118},{33,0,0,1,0,118},{34,1,0,1,0,118},{13,0,1,1,119,48},{14,1,1,1,119,48},{13,0,1,1,119,49},{14,1,1,1,119,49},{13,0,1,1,119,50},{14,1,1,1,119,50},{13,0,1,1,119,97},{14,1,1,1,119,97},{13,0,1,1,119,99},{14,1,1,1,119,99},{13,0,1,1,119,101},{14,1,1,1,119,101},{13,0,1,1,119,105},{14,1,1,1,119,105},{13,0,1,1,119,111},{14,1,1,1,119,111},{13,0,1,1,119,115},{14,1,1,1,119,115},{13,0,1,1,119,116},{14,1,1,1,119,116},{0,1,1,1,119,32},{0,1,1,1,119,37},{0,1,1,1,119,45},{0,1,1,1,119,46},{0,1,1,1,119,47},{0,1,1,1,119,51},{0,1,1,1,119,52},{0,1,1,1,119,53},{0,1,1,1,119,54},{0,1,1,1,119,55},{0,1,1,1,119,56},{0,1,1,1,119,57},{0,1,1,1,119,61},{0,1,1,1,119,65},{0,1,1,1,119,95},{0,1,1,1,119,98},{0,1,1,1,119,100},{0,1,1,1,119,102},{0,1,1,1,119,103},{0,1,1,1,119,104},{0,1,1,1,119,108},{0,1,1,1,119,109},{0,1,1,1,119,110},{0,1,1,1,119,112},{0,1,1,1,119,114},{0,1,1,1,119,117},{17,0,0,1,0,119},{18,0,0,1,0,119},{19,0,0,1,0,119},{20,0,0,1,0,119},{21,0,0,1,0,119},{22,0,0,1,0,119},{23,0,0,1,0,119},{24,0,0,1,0,119},{25,0,0,1,0,119},{26,0,0,1,0,119},{27,0,0,1,0,119},{28,0,0,1,0,119},{29,0,0,1,0,119},{30,0,0,1,0,119},{31,0,0,1,0,119},{32,0,0,1,0,119},{33,0,0,1,0,119},{34,1,0,1,0,119},{13,0,1,1,120,48},{14,1,1,1,120,48},{13,0,1,1,120,49},{14,1,1,1,120,49},{13,0,1,1,120,50},{14,1,1,1,120,50},{13,0,1,1,120,97},{14,1,1,1,120,97},{13,0,1,1,120,99},{14,1,1,1,120,99},{13,0,1,1,120,101},{14,1,1,1,120,101},{13,0,1,1,120,105},{14,1,1,1,120,105},{13,0,1,1,120,111},{14,1,1,1,120,111},{13,0,1,1,120,115},{14,1,1,1,120,115},{13,0,1,1,120,116},{14,1,1,1,120,116},{0,1,1,1,120,32},{0,1,1,1,120,37},{0,1,1,1,120,45},{0,1,1,1,120,46},{0,1,1,1,120,47},{0,1,1,1,120,51},{0,1,1,1,120,52},{0,1,1,1,120,53},{0,1,1,1,120,54},{0,1,1,1,120,55},{0,1,1,1,120,56},{0,1,1,1,120,57},{0,1,1,1,120,61},{0,1,1,1,120,65},{0,1,1,1,120,95},{0,1,1,1,120,98},{0,1,1,1,120,100},{0,1,1,1,120,102},{0,1,1,1,120,103},{0,1,1,1,120,104},{0,1,1,1,120,108},{0,1,1,1,120,109},{0,1,1,1,120,110},{0,1,1,1,120,112},{0,1,1,1,120,114},{0,1,1,1,120,117},{17,0,0,1,0,120},{18,0,0,1,0,120},{19,0,0,1,0,120},{20,0,0,1,0,120},{21,0,0,1,0,120},{22,0,0,1,0,120},{23,0,0,1,0,120},{24,0,0,1,0,120},{25,0,0,1,0,120},{26,0,0,1,0,120},{27,0,0,1,0,120},{28,0,0,1,0,120},{29,0,0,1,0,120},{30,0,0,1,0,120},{31,0,0,1,0,120},{32,0,0,1,0,120},{33,0,0,1,0,120},{34,1,0,1,0,120},{13,0,1,1,121,48},{14,1,1,1,121,48},{13,0,1,1,121,49},{14,1,1,1,121,49},{13,0,1,1,121,50},{14,1,1,1,121,50},{13,0,1,1,121,97},{14,1,1,1,121,97},{13,0,1,1,121,99},{14,1,1,1,121,99},{13,0,1,1,121,101},{14,1,1,1,121,101},{13,0,1,1,121,105},{14,1,1,1,121,105},{13,0,1,1,121,111},{14,1,1,1,121,111},{13,0,1,1,121,115},{14,1,1,1,121,115},{13,0,1,1,121,116},{14,1,1,1,121,116},{0,1,1,1,121,32},{0,1,1,1,121,37},{0,1,1,1,121,45},{0,1,1,1,121,46},{0,1,1,1,121,47},{0,1,1,1,121,51},{0,1,1,1,121,52},{0,1,1,1,121,53},{0,1,1,1,121,54},{0,1,1,1,121,55},{0,1,1,1,121,56},{0,1,1,1,121,57},{0,1,1,1,121,61},{0,1,1,1,121,65},{0,1,1,1,121,95},{0,1,1,1,121,98},{0,1,1,1,121,100},{0,1,1,1,121,102},{0,1,1,1,121,103},{0,1,1,1,121,104},{0,1,1,1,121,108},{0,1,1,1,121,109},{0,1,1,1,121,110},{0,1,1,1,121,112},{0,1,1,1,121,114},{0,1,1,1,121,117},{17,0,0,1,0,121},{18,0,0,1,0,121},{19,0,0,1,0,121},{20,0,0,1,0,121},{21,0,0,1,0,121},{22,0,0,1,0,121},{23,0,0,1,0,121},{24,0,0,1,0,121},{25,0,0,1,0,121},{26,0,0,1,0,121},{27,0,0,1,0,121},{28,0,0,1,0,121},{29,0,0,1,0,121},{30,0,0,1,0,121},{31,0,0,1,0,121},{32,0,0,1,0,121},{33,0,0,1,0,121},{34,1,0,1,0,121},{13,0,1,1,122,48},{14,1,1,1,122,48},{13,0,1,1,122,49},{14,1,1,1,122,49},{13,0,1,1,122,50},{14,1,1,1,122,50},{13,0,1,1,122,97},{14,1,1,1,122,97},{13,0,1,1,122,99},{14,1,1,1,122,99},{13,0,1,1,122,101},{14,1,1,1,122,101},{13,0,1,1,122,105},{14,1,1,1,122,105},{13,0,1,1,122,111},{14,1,1,1,122,111},{13,0,1,1,122,115},{14,1,1,1,122,115},{13,0,1,1,122,116},{14,1,1,1,122,116},{0,1,1,1,122,32},{0,1,1,1,122,37},{0,1,1,1,122,45},{0,1,1,1,122,46},{0,1,1,1,122,47},{0,1,1,1,122,51},{0,1,1,1,122,52},{0,1,1,1,122,53},{0,1,1,1,122,54},{0,1,1,1,122,55},{0,1,1,1,122,56},{0,1,1,1,122,57},{0,1,1,1,122,61},{0,1,1,1,122,65},{0,1,1,1,122,95},{0,1,1,1,122,98},{0,1,1,1,122,100},{0,1,1,1,122,102},{0,1,1,1,122,103},{0,1,1,1,122,104},{0,1,1,1,122,108},{0,1,1,1,122,109},{0,1,1,1,122,110},{0,1,1,1,122,112},{0,1,1,1,122,114},{0,1,1,1,122,117},{17,0,0,1,0,122},{18,0,0,1,0,122},{19,0,0,1,0,122},{20,0,0,1,0,122},{21,0,0,1,0,122},{22,0,0,1,0,122},{23,0,0,1,0,122},{24,0,0,1,0,122},{25,0,0,1,0,122},{26,0,0,1,0,122},{27,0,0,1,0,122},{28,0,0,1,0,122},{29,0,0,1,0,122},{30,0,0,1,0,122},{31,0,0,1,0,122},{32,0,0,1,0,122},{33,0,0,1,0,122},{34,1,0,1,0,122},{0,1,1,1,38,48},{0,1,1,1,38,49},{0,1,1,1,38,50},{0,1,1,1,38,97},{0,1,1,1,38,99},{0,1,1,1,38,101},{0,1,1,1,38,105},{0,1,1,1,38,111},{0,1,1,1,38,115},{0,1,1,1,38,116},{35,0,0,1,0,38},{36,0,0,1,0,38},{37,0,0,1,0,38},{38,0,0,1,0,38},{39,0,0,1,0,38},{40,0,0,1,0,38},{41,0,0,1,0,38},{42,0,0,1,0,38},{43,0,0,1,0,38},{44,0,0,1,0,38},{45,0,0,1,0,38},{46,0,0,1,0,38},{47,0,0,1,0,38},{48,0,0,1,0,38},{49,0,0,1,0,38},{50,0,0,1,0,38},{51,0,0,1,0,38},{52,0,0,1,0,38},{53,0,0,1,0,38},{54,0,0,1,0,38},{55,0,0,1,0,38},{56,1,0,1,0,38},{0,1,1,1,42,48},{0,1,1,1,42,49},{0,1,1,1,42,50},{0,1,1,1,42,97},{0,1,1,1,42,99},{0,1,1,1,42,101},{0,1,1,1,42,105},{0,1,1,1,42,111},{0,1,1,1,42,115},{0,1,1,1,42,116},{35,0,0,1,0,42},{36,0,0,1,0,42},{37,0,0,1,0,42},{38,0,0,1,0,42},{39,0,0,1,0,42},{40,0,0,1,0,42},{41,0,0,1,0,42},{42,0,0,1,0,42},{43,0,0,1,0,42},{44,0,0,1,0,42},{45,0,0,1,0,42},{46,0,0,1,0,42},{47,0,0,1,0,42},{48,0,0,1,0,42},{49,0,0,1,0,42},{50,0,0,1,0,42},{51,0,0,1,0,42},{52,0,0,1,0,42},{53,0,0,1,0,42},{54,0,0,1,0,42},{55,0,0,1,0,42},{56,1,0,1,0,42},{0,1,1,1,44,48},{0,1,1,1,44,49},{0,1,1,1,44,50},{0,1,1,1,44,97},{0,1,1,1,44,99},{0,1,1,1,44,101},{0,1,1,1,44,105},{0,1,1,1,44,111},{0,1,1,1,44,115},{0,1,1,1,44,116},{35,0,0,1,0,44},{36,0,0,1,0,44},{37,0,0,1,0,44},{38,0,0,1,0,44},{39,0,0,1,0,44},{40,0,0,1,0,44},{41,0,0,1,0,44},{42,0,0,1,0,44},{43,0,0,1,0,44},{44,0,0,1,0,44},{45,0,0,1,0,44},{46,0,0,1,0,44},{47,0,0,1,0,44},{48,0,0,1,0,44},{49,0,0,1,0,44},{50,0,0,1,0,44},{51,0,0,1,0,44},{52,0,0,1,0,44},{53,0,0,1,0,44},{54,0,0,1,0,44},{55,0,0,1,0,44},{56,1,0,1,0,44},{0,1,1,1,59,48},{0,1,1,1,59,49},{0,1,1,1,59,50},{0,1,1,1,59,97},{0,1,1,1,59,99},{0,1,1,1,59,101},{0,1,1,1,59,105},{0,1,1,1,59,111},{0,1,1,1,59,115},{0,1,1,1,59,116},{35,0,0,1,0,59},{36,0,0,1,0,59},{37,0,0,1,0,59},{38,0,0,1,0,59},{39,0,0,1,0,59},{40,0,0,1,0,59},{41,0,0,1,0,59},{42,0,0,1,0,59},{43,0,0,1,0,59},{44,0,0,1,0,59},{45,0,0,1,0,59},{46,0,0,1,0,59},{47,0,0,1,0,59},{48,0,0,1,0,59},{49,0,0,1,0,59},{50,0,0,1,0,59},{51,0,0,1,0,59},{52,0,0,1,0,59},{53,0,0,1,0,59},{54,0,0,1,0,59},{55,0,0,1,0,59},{56,1,0,1,0,59},{0,1,1,1,88,48},{0,1,1,1,88,49},{0,1,1,1,88,50},{0,1,1,1,88,97},{0,1,1,1,88,99},{0,1,1,1,88,101},{0,1,1,1,88,105},{0,1,1,1,88,111},{0,1,1,1,88,115},{0,1,1,1,88,116},{35,0,0,1,0,88},{36,0,0,1,0,88},{37,0,0,1,0,88},{38,0,0,1,0,88},{39,0,0,1,0,88},{40,0,0,1,0,88},{41,0,0,1,0,88},{42,0,0,1,0,88},{43,0,0,1,0,88},{44,0,0,1,0,88},{45,0,0,1,0,88},{46,0,0,1,0,88},{47,0,0,1,0,88},{48,0,0,1,0,88},{49,0,0,1,0,88},{50,0,0,1,0,88},{51,0,0,1,0,88},{52,0,0,1,0,88},{53,0,0,1,0,88},{54,0,0,1,0,88},{55,0,0,1,0,88},{56,1,0,1,0,88},{0,1,1,1,90,48},{0,1,1,1,90,49},{0,1,1,1,90,50},{0,1,1,1,90,97},{0,1,1,1,90,99},{0,1,1,1,90,101},{0,1,1,1,90,105},{0,1,1,1,90,111},{0,1,1,1,90,115},{0,1,1,1,90,116},{35,0,0,1,0,90},{36,0,0,1,0,90},{37,0,0,1,0,90},{38,0,0,1,0,90},{39,0,0,1,0,90},{40,0,0,1,0,90},{41,0,0,1,0,90},{42,0,0,1,0,90},{43,0,0,1,0,90},{44,0,0,1,0,90},{45,0,0,1,0,90},{46,0,0,1,0,90},{47,0,0,1,0,90},{48,0,0,1,0,90},{49,0,0,1,0,90},{50,0,0,1,0,90},{51,0,0,1,0,90},{52,0,0,1,0,90},{53,0,0,1,0,90},{54,0,0,1,0,90},{55,0,0,1,0,90},{56,1,0,1,0,90},{1,0,0,1,0,33},{2,0,0,1,0,33},{3,0,0,1,0,33},{4,0,0,1,0,33},{5,0,0,1,0,33},{6,0,0,1,0,33},{7,0,0,1,0,33},{8,1,0,1,0,33},{1,0,0,1,0,34},{2,0,0,1,0,34},{3,0,0,1,0,34},{4,0,0,1,0,34},{5,0,0,1,0,34},{6,0,0,1,0,34},{7,0,0,1,0,34},{8,1,0,1,0,34},{1,0,0,1,0,40},{2,0,0,1,0,40},{3,0,0,1,0,40},{4,0,0,1,0,40},{5,0,0,1,0,40},{6,0,0,1,0,40},{7,0,0,1,0,40},{8,1,0,1,0,40},{1,0,0,1,0,41},{2,0,0,1,0,41},{3,0,0,1,0,41},{4,0,0,1,0,41},{5,0,0,1,0,41},{6,0,0,1,0,41},{7,0,0,1,0,41},{8,1,0,1,0,41},{1,0,0,1,0,63},{2,0,0,1,0,63},{3,0,0,1,0,63},{4,0,0,1,0,63},{5,0,0,1,0,63},{6,0,0,1,0,63},{7,0,0,1,0,63},{8,1,0,1,0,63},{9,0,0,1,0,39},{10,0,0,1,0,39},{11,0,0,1,0,39},{12,1,0,1,0,39},{9,0,0,1,0,43},{10,0,0,1,0,43},{11,0,0,1,0,43},{12,1,0,1,0,43},{9,0,0,1,0,124},{10,0,0,1,0,124},{11,0,0,1,0,124},{12,1,0,1,0,124},{13,0,0,1,0,35},{14,1,0,1,0,35},{13,0,0,1,0,62},{14,1,0,1,0,62},{0,1,0,1,0,0},{0,1,0,1,0,36},{0,1,0,1,0,64},{0,1,0,1,0,91},{0,1,0,1,0,93},{0,1,0,1,0,126},{91,0,0,0,0,0},{92,0,0,0,0,0},{9,0,1,1,48,48},{10,0,1,1,48,48},{11,0,1,1,48,48},{12,1,1,1,48,48},{9,0,1,1,48,49},{10,0,1,1,48,49},{11,0,1,1,48,49},{12,1,1,1,48,49},{9,0,1,1,48,50},{10,0,1,1,48,50},{11,0,1,1,48,50},{12,1,1,1,48,50},{9,0,1,1,48,97},{10,0,1,1,48,97},{11,0,1,1,48,97},{12,1,1,1,48,97},{9,0,1,1,48,99},{10,0,1,1,48,99},{11,0,1,1,48,99},{12,1,1,1,48,99},{9,0,1,1,48,101},{10,0,1,1,48,101},{11,0,1,1,48,101},{12,1,1,1,48,101},{9,0,1,1,48,105},{10,0,1,1,48,105},{11,0,1,1,48,105},{12,1,1,1,48,105},{9,0,1,1,48,111},{10,0,1,1,48,111},{11,0,1,1,48,111},{12,1,1,1,48,111},{9,0,1,1,48,115},{10,0,1,1,48,115},{11,0,1,1,48,115},{12,1,1,1,48,115},{9,0,1,1,48,116},{10,0,1,1,48,116},{11,0,1,1,48,116},{12,1,1,1,48,116},{13,0,1,1,48,32},{14,1,1,1,48,32},{13,0,1,1,48,37},{14,1,1,1,48,37},{13,0,1,1,48,45},{14,1,1,1,48,45},{13,0,1,1,48,46},{14,1,1,1,48,46},{13,0,1,1,48,47},{14,1,1,1,48,47},{13,0,1,1,48,51},{14,1,1,1,48,51},{13,0,1,1,48,52},{14,1,1,1,48,52},{13,0,1,1,48,53},{14,1,1,1,48,53},{13,0,1,1,48,54},{14,1,1,1,48,54},{13,0,1,1,48,55},{14,1,1,1,48,55},{13,0,1,1,48,56},{14,1,1,1,48,56},{13,0,1,1,48,57},{14,1,1,1,48,57},{13,0,1,1,48,61},{14,1,1,1,48,61},{13,0,1,1,48,65},{14,1,1,1,48,65},{13,0,1,1,48,95},{14,1,1,1,48,95},{13,0,1,1,48,98},{14,1,1,1,48,98},{13,0,1,1,48,100},{14,1,1,1,48,100},{13,0,1,1,48,102},{14,1,1,1,48,102},{13,0,1,1,48,103},{14,1,1,1,48,103},{13,0,1,1,48,104},{14,1,1,1,48,104},{13,0,1,1,48,108},{14,1,1,1,48,108},{13,0,1,1,48,109},{14,1,1,1,48,109},{13,0,1,1,48,110},{14,1,1,1,48,110},{13,0,1,1,48,112},{14,1,1,1,48,112},{13,0,1,1,48,114},{14,1,1,1,48,114},{13,0,1,1,48,117},{14,1,1,1,48,117},{0,1,1,1,48,58},{0,1,1,1,48,66},{0,1,1,1,48,67},{0,1,1,1,48,68},{0,1,1,1,48,69},{0,1,1,1,48,70},{0,1,1,1,48,71},{0,1,1,1,48,72},{0,1,1,1,48,73},{0,1,1,1,48,74},{0,1,1,1,48,75},{0,1,1,1,48,76},{0,1,1,1,48,77},{0,1,1,1,48,78},{0,1,1,1,48,79},{0,1,1,1,48,80},{0,1,1,1,48,81},{0,1,1,1,48,82},{0,1,1,1,48,83},{0,1,1,1,48,84},{0,1,1,1,48,85},{0,1,1,1,48,86},{0,1,1,1,48,87},{0,1,1,1,48,89},{0,1,1,1,48,106},{0,1,1,1,48,107},{0,1,1,1,48,113},{0,1,1,1,48,118},{0,1,1,1,48,119},{0,1,1,1,48,120},{0,1,1,1,48,121},{0,1,1,1,48,122},{85,0,0,1,0,48},{86,0,0,1,0,48},{87,0,0,1,0,48},{88,1,0,1,0,48},{9,0,1,1,49,48},{10,0,1,1,49,48},{11,0,1,1,49,48},{12,1,1,1,49,48},{9,0,1,1,49,49},{10,0,1,1,49,49},{11,0,1,1,49,49},{12,1,1,1,49,49},{9,0,1,1,49,50},{10,0,1,1,49,50},{11,0,1,1,49,50},{12,1,1,1,49,50},{9,0,1,1,49,97},{10,0,1,1,49,97},{11,0,1,1,49,97},{12,1,1,1,49,97},{9,0,1,1,49,99},{10,0,1,1,49,99},{11,0,1,1,49,99},{12,1,1,1,49,99},{9,0,1,1,49,101},{10,0,1,1,49,101},{11,0,1,1,49,101},{12,1,1,1,49,101},{9,0,1,1,49,105},{10,0,1,1,49,105},{11,0,1,1,49,105},{12,1,1,1,49,105},{9,0,1,1,49,111},{10,0,1,1,49,111},{11,0,1,1,49,111},{12,1,1,1,49,111},{9,0,1,1,49,115},{10,0,1,1,49,115},{11,0,1,1,49,115},{12,1,1,1,49,115},{9,0,1,1,49,116},{10,0,1,1,49,116},{11,0,1,1,49,116},{12,1,1,1,49,116},{13,0,1,1,49,32},{14,1,1,1,49,32},{13,0,1,1,49,37},{14,1,1,1,49,37},{13,0,1,1,49,45},{14,1,1,1,49,45},{13,0,1,1,49,46},{14,1,1,1,49,46},{13,0,1,1,49,47},{14,1,1,1,49,47},{13,0,1,1,49,51},{14,1,1,1,49,51},{13,0,1,1,49,52},{14,1,1,1,49,52},{13,0,1,1,49,53},{14,1,1,1,49,53},{13,0,1,1,49,54},{14,1,1,1,49,54},{13,0,1,1,49,55},{14,1,1,1,49,55},{13,0,1,1,49,56},{14,1,1,1,49,56},{13,0,1,1,49,57},{14,1,1,1,49,57},{13,0,1,1,49,61},{14,1,1,1,49,61},{13,0,1,1,49,65},{14,1,1,1,49,65},{13,0,1,1,49,95},{14,1,1,1,49,95},{13,0,1,1,49,98},{14,1,1,1,49,98},{13,0,1,1,49,100},{14,1,1,1,49,100},{13,0,1,1,49,102},{14,1,1,1,49,102},{13,0,1,1,49,103},{14,1,1,1,49,103},{13,0,1,1,49,104},{14,1,1,1,49,104},{13,0,1,1,49,108},{14,1,1,1,49,108},{13,0,1,1,49,109},{14,1,1,1,49,109},{13,0,1,1,49,110},{14,1,1,1,49,110},{13,0,1,1,49,112},{14,1,1,1,49,112},{13,0,1,1,49,114},{14,1,1,1,49,114},{13,0,1,1,49,117},{14,1,1,1,49,117},{0,1,1,1,49,58},{0,1,1,1,49,66},{0,1,1,1,49,67},{0,1,1,1,49,68},{0,1,1,1,49,69},{0,1,1,1,49,70},{0,1,1,1,49,71},{0,1,1,1,49,72},{0,1,1,1,49,73},{0,1,1,1,49,74},{0,1,1,1,49,75},{0,1,1,1,49,76},{0,1,1,1,49,77},{0,1,1,1,49,78},{0,1,1,1,49,79},{0,1,1,1,49,80},{0,1,1,1,49,81},{0,1,1,1,49,82},{0,1,1,1,49,83},{0,1,1,1,49,84},{0,1,1,1,49,85},{0,1,1,1,49,86},{0,1,1,1,49,87},{0,1,1,1,49,89},{0,1,1,1,49,106},{0,1,1,1,49,107},{0,1,1,1,49,113},{0,1,1,1,49,118},{0,1,1,1,49,119},{0,1,1,1,49,120},{0,1,1,1,49,121},{0,1,1,1,49,122},{85,0,0,1,0,49},{86,0,0,1,0,49},{87,0,0,1,0,49},{88,1,0,1,0,49},{9,0,1,1,50,48},{10,0,1,1,50,48},{11,0,1,1,50,48},{12,1,1,1,50,48},{9,0,1,1,50,49},{10,0,1,1,50,49},{11,0,1,1,50,49},{12,1,1,1,50,49},{9,0,1,1,50,50},{10,0,1,1,50,50},{11,0,1,1,50,50},{12,1,1,1,50,50},{9,0,1,1,50,97},{10,0,1,1,50,97},{11,0,1,1,50,97},{12,1,1,1,50,97},{9,0,1,1,50,99},{10,0,1,1,50,99},{11,0,1,1,50,99},{12,1,1,1,50,99},{9,0,1,1,50,101},{10,0,1,1,50,101},{11,0,1,1,50,101},{12,1,1,1,50,101},{9,0,1,1,50,105},{10,0,1,1,50,105},{11,0,1,1,50,105},{12,1,1,1,50,105},{9,0,1,1,50,111},{10,0,1,1,50,111},{11,0,1,1,50,111},{12,1,1,1,50,111},{9,0,1,1,50,115},{10,0,1,1,50,115},{11,0,1,1,50,115},{12,1,1,1,50,115},{9,0,1,1,50,116},{10,0,1,1,50,116},{11,0,1,1,50,116},{12,1,1,1,50,116},{13,0,1,1,50,32},{14,1,1,1,50,32},{13,0,1,1,50,37},{14,1,1,1,50,37},{13,0,1,1,50,45},{14,1,1,1,50,45},{13,0,1,1,50,46},{14,1,1,1,50,46},{13,0,1,1,50,47},{14,1,1,1,50,47},{13,0,1,1,50,51},{14,1,1,1,50,51},{13,0,1,1,50,52},{14,1,1,1,50,52},{13,0,1,1,50,53},{14,1,1,1,50,53},{13,0,1,1,50,54},{14,1,1,1,50,54},{13,0,1,1,50,55},{14,1,1,1,50,55},{13,0,1,1,50,56},{14,1,1,1,50,56},{13,0,1,1,50,57},{14,1,1,1,50,57},{13,0,1,1,50,61},{14,1,1,1,50,61},{13,0,1,1,50,65},{14,1,1,1,50,65},{13,0,1,1,50,95},{14,1,1,1,50,95},{13,0,1,1,50,98},{14,1,1,1,50,98},{13,0,1,1,50,100},{14,1,1,1,50,100},{13,0,1,1,50,102},{14,1,1,1,50,102},{13,0,1,1,50,103},{14,1,1,1,50,103},{13,0,1,1,50,104},{14,1,1,1,50,104},{13,0,1,1,50,108},{14,1,1,1,50,108},{13,0,1,1,50,109},{14,1,1,1,50,109},{13,0,1,1,50,110},{14,1,1,1,50,110},{13,0,1,1,50,112},{14,1,1,1,50,112},{13,0,1,1,50,114},{14,1,1,1,50,114},{13,0,1,1,50,117},{14,1,1,1,50,117},{0,1,1,1,50,58},{0,1,1,1,50,66},{0,1,1,1,50,67},{0,1,1,1,50,68},{0,1,1,1,50,69},{0,1,1,1,50,70},{0,1,1,1,50,71},{0,1,1,1,50,72},{0,1,1,1,50,73},{0,1,1,1,50,74},{0,1,1,1,50,75},{0,1,1,1,50,76},{0,1,1,1,50,77},{0,1,1,1,50,78},{0,1,1,1,50,79},{0,1,1,1,50,80},{0,1,1,1,50,81},{0,1,1,1,50,82},{0,1,1,1,50,83},{0,1,1,1,50,84},{0,1,1,1,50,85},{0,1,1,1,50,86},{0,1,1,1,50,87},{0,1,1,1,50,89},{0,1,1,1,50,106},{0,1,1,1,50,107},{0,1,1,1,50,113},{0,1,1,1,50,118},{0,1,1,1,50,119},{0,1,1,1,50,120},{0,1,1,1,50,121},{0,1,1,1,50,122},{85,0,0,1,0,50},{86,0,0,1,0,50},{87,0,0,1,0,50},{88,1,0,1,0,50},{9,0,1,1,97,48},{10,0,1,1,97,48},{11,0,1,1,97,48},{12,1,1,1,97,48},{9,0,1,1,97,49},{10,0,1,1,97,49},{11,0,1,1,97,49},{12,1,1,1,97,49},{9,0,1,1,97,50},{10,0,1,1,97,50},{11,0,1,1,97,50},{12,1,1,1,97,50},{9,0,1,1,97,97},{10,0,1,1,97,97},{11,0,1,1,97,97},{12,1,1,1,97,97},{9,0,1,1,97,99},{10,0,1,1,97,99},{11,0,1,1,97,99},{12,1,1,1,97,99},{9,0,1,1,97,101},{10,0,1,1,97,101},{11,0,1,1,97,101},{12,1,1,1,97,101},{9,0,1,1,97,105},{10,0,1,1,97,105},{11,0,1,1,97,105},{12,1,1,1,97,105},{9,0,1,1,97,111},{10,0,1,1,97,111},{11,0,1,1,97,111},{12,1,1,1,97,111},{9,0,1,1,97,115},{10,0,1,1,97,115},{11,0,1,1,97,115},{12,1,1,1,97,115},{9,0,1,1,97,116},{10,0,1,1,97,116},{11,0,1,1,97,116},{12,1,1,1,97,116},{13,0,1,1,97,32},{14,1,1,1,97,32},{13,0,1,1,97,37},{14,1,1,1,97,37},{13,0,1,1,97,45},{14,1,1,1,97,45},{13,0,1,1,97,46},{14,1,1,1,97,46},{13,0,1,1,97,47},{14,1,1,1,97,47},{13,0,1,1,97,51},{14,1,1,1,97,51},{13,0,1,1,97,52},{14,1,1,1,97,52},{13,0,1,1,97,53},{14,1,1,1,97,53},{13,0,1,1,97,54},{14,1,1,1,97,54},{13,0,1,1,97,55},{14,1,1,1,97,55},{13,0,1,1,97,56},{14,1,1,1,97,56},{13,0,1,1,97,57},{14,1,1,1,97,57},{13,0,1,1,97,61},{14,1,1,1,97,61},{13,0,1,1,97,65},{14,1,1,1,97,65},{13,0,1,1,97,95},{14,1,1,1,97,95},{13,0,1,1,97,98},{14,1,1,1,97,98},{13,0,1,1,97,100},{14,1,1,1,97,100},{13,0,1,1,97,102},{14,1,1,1,97,102},{13,0,1,1,97,103},{14,1,1,1,97,103},{13,0,1,1,97,104},{14,1,1,1,97,104},{13,0,1,1,97,108},{14,1,1,1,97,108},{13,0,1,1,97,109},{14,1,1,1,97,109},{13,0,1,1,97,110},{14,1,1,1,97,110},{13,0,1,1,97,112},{14,1,1,1,97,112},{13,0,1,1,97,114},{14,1,1,1,97,114},{13,0,1,1,97,117},{14,1,1,1,97,117},{0,1,1,1,97,58},{0,1,1,1,97,66},{0,1,1,1,97,67},{0,1,1,1,97,68},{0,1,1,1,97,69},{0,1,1,1,97,70},{0,1,1,1,97,71},{0,1,1,1,97,72},{0,1,1,1,97,73},{0,1,1,1,97,74},{0,1,1,1,97,75},{0,1,1,1,97,76},{0,1,1,1,97,77},{0,1,1,1,97,78},{0,1,1,1,97,79},{0,1,1,1,97,80},{0,1,1,1,97,81},{0,1,1,1,97,82},{0,1,1,1,97,83},{0,1,1,1,97,84},{0,1,1,1,97,85},{0,1,1,1,97,86},{0,1,1,1,97,87},{0,1,1,1,97,89},{0,1,1,1,97,106},{0,1,1,1,97,107},{0,1,1,1,97,113},{0,1,1,1,97,118},{0,1,1,1,97,119},{0,1,1,1,97,120},{0,1,1,1,97,121},{0,1,1,1,97,122},{85,0,0,1,0,97},{86,0,0,1,0,97},{87,0,0,1,0,97},{88,1,0,1,0,97},{9,0,1,1,99,48},{10,0,1,1,99,48},{11,0,1,1,99,48},{12,1,1,1,99,48},{9,0,1,1,99,49},{10,0,1,1,99,49},{11,0,1,1,99,49},{12,1,1,1,99,49},{9,0,1,1,99,50},{10,0,1,1,99,50},{11,0,1,1,99,50},{12,1,1,1,99,50},{9,0,1,1,99,97},{10,0,1,1,99,97},{11,0,1,1,99,97},{12,1,1,1,99,97},{9,0,1,1,99,99},{10,0,1,1,99,99},{11,0,1,1,99,99},{12,1,1,1,99,99},{9,0,1,1,99,101},{10,0,1,1,99,101},{11,0,1,1,99,101},{12,1,1,1,99,101},{9,0,1,1,99,105},{10,0,1,1,99,105},{11,0,1,1,99,105},{12,1,1,1,99,105},{9,0,1,1,99,111},{10,0,1,1,99,111},{11,0,1,1,99,111},{12,1,1,1,99,111},{9,0,1,1,99,115},{10,0,1,1,99,115},{11,0,1,1,99,115},{12,1,1,1,99,115},{9,0,1,1,99,116},{10,0,1,1,99,116},{11,0,1,1,99,116},{12,1,1,1,99,116},{13,0,1,1,99,32},{14,1,1,1,99,32},{13,0,1,1,99,37},{14,1,1,1,99,37},{13,0,1,1,99,45},{14,1,1,1,99,45},{13,0,1,1,99,46},{14,1,1,1,99,46},{13,0,1,1,99,47},{14,1,1,1,99,47},{13,0,1,1,99,51},{14,1,1,1,99,51},{13,0,1,1,99,52},{14,1,1,1,99,52},{13,0,1,1,99,53},{14,1,1,1,99,53},{13,0,1,1,99,54},{14,1,1,1,99,54},{13,0,1,1,99,55},{14,1,1,1,99,55},{13,0,1,1,99,56},{14,1,1,1,99,56},{13,0,1,1,99,57},{14,1,1,1,99,57},{13,0,1,1,99,61},{14,1,1,1,99,61},{13,0,1,1,99,65},{14,1,1,1,99,65},{13,0,1,1,99,95},{14,1,1,1,99,95},{13,0,1,1,99,98},{14,1,1,1,99,98},{13,0,1,1,99,100},{14,1,1,1,99,100},{13,0,1,1,99,102},{14,1,1,1,99,102},{13,0,1,1,99,103},{14,1,1,1,99,103},{13,0,1,1,99,104},{14,1,1,1,99,104},{13,0,1,1,99,108},{14,1,1,1,99,108},{13,0,1,1,99,109},{14,1,1,1,99,109},{13,0,1,1,99,110},{14,1,1,1,99,110},{13,0,1,1,99,112},{14,1,1,1,99,112},{13,0,1,1,99,114},{14,1,1,1,99,114},{13,0,1,1,99,117},{14,1,1,1,99,117},{0,1,1,1,99,58},{0,1,1,1,99,66},{0,1,1,1,99,67},{0,1,1,1,99,68},{0,1,1,1,99,69},{0,1,1,1,99,70},{0,1,1,1,99,71},{0,1,1,1,99,72},{0,1,1,1,99,73},{0,1,1,1,99,74},{0,1,1,1,99,75},{0,1,1,1,99,76},{0,1,1,1,99,77},{0,1,1,1,99,78},{0,1,1,1,99,79},{0,1,1,1,99,80},{0,1,1,1,99,81},{0,1,1,1,99,82},{0,1,1,1,99,83},{0,1,1,1,99,84},{0,1,1,1,99,85},{0,1,1,1,99,86},{0,1,1,1,99,87},{0,1,1,1,99,89},{0,1,1,1,99,106},{0,1,1,1,99,107},{0,1,1,1,99,113},{0,1,1,1,99,118},{0,1,1,1,99,119},{0,1,1,1,99,120},{0,1,1,1,99,121},{0,1,1,1,99,122},{85,0,0,1,0,99},{86,0,0,1,0,99},{87,0,0,1,0,99},{88,1,0,1,0,99},{9,0,1,1,101,48},{10,0,1,1,101,48},{11,0,1,1,101,48},{12,1,1,1,101,48},{9,0,1,1,101,49},{10,0,1,1,101,49},{11,0,1,1,101,49},{12,1,1,1,101,49},{9,0,1,1,101,50},{10,0,1,1,101,50},{11,0,1,1,101,50},{12,1,1,1,101,50},{9,0,1,1,101,97},{10,0,1,1,101,97},{11,0,1,1,101,97},{12,1,1,1,101,97},{9,0,1,1,101,99},{10,0,1,1,101,99},{11,0,1,1,101,99},{12,1,1,1,101,99},{9,0,1,1,101,101},{10,0,1,1,101,101},{11,0,1,1,101,101},{12,1,1,1,101,101},{9,0,1,1,101,105},{10,0,1,1,101,105},{11,0,1,1,101,105},{12,1,1,1,101,105},{9,0,1,1,101,111},{10,0,1,1,101,111},{11,0,1,1,101,111},{12,1,1,1,101,111},{9,0,1,1,101,115},{10,0,1,1,101,115},{11,0,1,1,101,115},{12,1,1,1,101,115},{9,0,1,1,101,116},{10,0,1,1,101,116},{11,0,1,1,101,116},{12,1,1,1,101,116},{13,0,1,1,101,32},{14,1,1,1,101,32},{13,0,1,1,101,37},{14,1,1,1,101,37},{13,0,1,1,101,45},{14,1,1,1,101,45},{13,0,1,1,101,46},{14,1,1,1,101,46},{13,0,1,1,101,47},{14,1,1,1,101,47},{13,0,1,1,101,51},{14,1,1,1,101,51},{13,0,1,1,101,52},{14,1,1,1,101,52},{13,0,1,1,101,53},{14,1,1,1,101,53},{13,0,1,1,101,54},{14,1,1,1,101,54},{13,0,1,1,101,55},{14,1,1,1,101,55},{13,0,1,1,101,56},{14,1,1,1,101,56},{13,0,1,1,101,57},{14,1,1,1,101,57},{13,0,1,1,101,61},{14,1,1,1,101,61},{13,0,1,1,101,65},{14,1,1,1,101,65},{13,0,1,1,101,95},{14,1,1,1,101,95},{13,0,1,1,101,98},{14,1,1,1,101,98},{13,0,1,1,101,100},{14,1,1,1,101,100},{13,0,1,1,101,102},{14,1,1,1,101,102},{13,0,1,1,101,103},{14,1,1,1,101,103},{13,0,1,1,101,104},{14,1,1,1,101,104},{13,0,1,1,101,108},{14,1,1,1,101,108},{13,0,1,1,101,109},{14,1,1,1,101,109},{13,0,1,1,101,110},{14,1,1,1,101,110},{13,0,1,1,101,112},{14,1,1,1,101,112},{13,0,1,1,101,114},{14,1,1,1,101,114},{13,0,1,1,101,117},{14,1,1,1,101,117},{0,1,1,1,101,58},{0,1,1,1,101,66},{0,1,1,1,101,67},{0,1,1,1,101,68},{0,1,1,1,101,69},{0,1,1,1,101,70},{0,1,1,1,101,71},{0,1,1,1,101,72},{0,1,1,1,101,73},{0,1,1,1,101,74},{0,1,1,1,101,75},{0,1,1,1,101,76},{0,1,1,1,101,77},{0,1,1,1,101,78},{0,1,1,1,101,79},{0,1,1,1,101,80},{0,1,1,1,101,81},{0,1,1,1,101,82},{0,1,1,1,101,83},{0,1,1,1,101,84},{0,1,1,1,101,85},{0,1,1,1,101,86},{0,1,1,1,101,87},{0,1,1,1,101,89},{0,1,1,1,101,106},{0,1,1,1,101,107},{0,1,1,1,101,113},{0,1,1,1,101,118},{0,1,1,1,101,119},{0,1,1,1,101,120},{0,1,1,1,101,121},{0,1,1,1,101,122},{85,0,0,1,0,101},{86,0,0,1,0,101},{87,0,0,1,0,101},{88,1,0,1,0,101},{9,0,1,1,105,48},{10,0,1,1,105,48},{11,0,1,1,105,48},{12,1,1,1,105,48},{9,0,1,1,105,49},{10,0,1,1,105,49},{11,0,1,1,105,49},{12,1,1,1,105,49},{9,0,1,1,105,50},{10,0,1,1,105,50},{11,0,1,1,105,50},{12,1,1,1,105,50},{9,0,1,1,105,97},{10,0,1,1,105,97},{11,0,1,1,105,97},{12,1,1,1,105,97},{9,0,1,1,105,99},{10,0,1,1,105,99},{11,0,1,1,105,99},{12,1,1,1,105,99},{9,0,1,1,105,101},{10,0,1,1,105,101},{11,0,1,1,105,101},{12,1,1,1,105,101},{9,0,1,1,105,105},{10,0,1,1,105,105},{11,0,1,1,105,105},{12,1,1,1,105,105},{9,0,1,1,105,111},{10,0,1,1,105,111},{11,0,1,1,105,111},{12,1,1,1,105,111},{9,0,1,1,105,115},{10,0,1,1,105,115},{11,0,1,1,105,115},{12,1,1,1,105,115},{9,0,1,1,105,116},{10,0,1,1,105,116},{11,0,1,1,105,116},{12,1,1,1,105,116},{13,0,1,1,105,32},{14,1,1,1,105,32},{13,0,1,1,105,37},{14,1,1,1,105,37},{13,0,1,1,105,45},{14,1,1,1,105,45},{13,0,1,1,105,46},{14,1,1,1,105,46},{13,0,1,1,105,47},{14,1,1,1,105,47},{13,0,1,1,105,51},{14,1,1,1,105,51},{13,0,1,1,105,52},{14,1,1,1,105,52},{13,0,1,1,105,53},{14,1,1,1,105,53},{13,0,1,1,105,54},{14,1,1,1,105,54},{13,0,1,1,105,55},{14,1,1,1,105,55},{13,0,1,1,105,56},{14,1,1,1,105,56},{13,0,1,1,105,57},{14,1,1,1,105,57},{13,0,1,1,105,61},{14,1,1,1,105,61},{13,0,1,1,105,65},{14,1,1,1,105,65},{13,0,1,1,105,95},{14,1,1,1,105,95},{13,0,1,1,105,98},{14,1,1,1,105,98},{13,0,1,1,105,100},{14,1,1,1,105,100},{13,0,1,1,105,102},{14,1,1,1,105,102},{13,0,1,1,105,103},{14,1,1,1,105,103},{13,0,1,1,105,104},{14,1,1,1,105,104},{13,0,1,1,105,108},{14,1,1,1,105,108},{13,0,1,1,105,109},{14,1,1,1,105,109},{13,0,1,1,105,110},{14,1,1,1,105,110},{13,0,1,1,105,112},{14,1,1,1,105,112},{13,0,1,1,105,114},{14,1,1,1,105,114},{13,0,1,1,105,117},{14,1,1,1,105,117},{0,1,1,1,105,58},{0,1,1,1,105,66},{0,1,1,1,105,67},{0,1,1,1,105,68},{0,1,1,1,105,69},{0,1,1,1,105,70},{0,1,1,1,105,71},{0,1,1,1,105,72},{0,1,1,1,105,73},{0,1,1,1,105,74},{0,1,1,1,105,75},{0,1,1,1,105,76},{0,1,1,1,105,77},{0,1,1,1,105,78},{0,1,1,1,105,79},{0,1,1,1,105,80},{0,1,1,1,105,81},{0,1,1,1,105,82},{0,1,1,1,105,83},{0,1,1,1,105,84},{0,1,1,1,105,85},{0,1,1,1,105,86},{0,1,1,1,105,87},{0,1,1,1,105,89},{0,1,1,1,105,106},{0,1,1,1,105,107},{0,1,1,1,105,113},{0,1,1,1,105,118},{0,1,1,1,105,119},{0,1,1,1,105,120},{0,1,1,1,105,121},{0,1,1,1,105,122},{85,0,0,1,0,105},{86,0,0,1,0,105},{87,0,0,1,0,105},{88,1,0,1,0,105},{9,0,1,1,111,48},{10,0,1,1,111,48},{11,0,1,1,111,48},{12,1,1,1,111,48},{9,0,1,1,111,49},{10,0,1,1,111,49},{11,0,1,1,111,49},{12,1,1,1,111,49},{9,0,1,1,111,50},{10,0,1,1,111,50},{11,0,1,1,111,50},{12,1,1,1,111,50},{9,0,1,1,111,97},{10,0,1,1,111,97},{11,0,1,1,111,97},{12,1,1,1,111,97},{9,0,1,1,111,99},{10,0,1,1,111,99},{11,0,1,1,111,99},{12,1,1,1,111,99},{9,0,1,1,111,101},{10,0,1,1,111,101},{11,0,1,1,111,101},{12,1,1,1,111,101},{9,0,1,1,111,105},{10,0,1,1,111,105},{11,0,1,1,111,105},{12,1,1,1,111,105},{9,0,1,1,111,111},{10,0,1,1,111,111},{11,0,1,1,111,111},{12,1,1,1,111,111},{9,0,1,1,111,115},{10,0,1,1,111,115},{11,0,1,1,111,115},{12,1,1,1,111,115},{9,0,1,1,111,116},{10,0,1,1,111,116},{11,0,1,1,111,116},{12,1,1,1,111,116},{13,0,1,1,111,32},{14,1,1,1,111,32},{13,0,1,1,111,37},{14,1,1,1,111,37},{13,0,1,1,111,45},{14,1,1,1,111,45},{13,0,1,1,111,46},{14,1,1,1,111,46},{13,0,1,1,111,47},{14,1,1,1,111,47},{13,0,1,1,111,51},{14,1,1,1,111,51},{13,0,1,1,111,52},{14,1,1,1,111,52},{13,0,1,1,111,53},{14,1,1,1,111,53},{13,0,1,1,111,54},{14,1,1,1,111,54},{13,0,1,1,111,55},{14,1,1,1,111,55},{13,0,1,1,111,56},{14,1,1,1,111,56},{13,0,1,1,111,57},{14,1,1,1,111,57},{13,0,1,1,111,61},{14,1,1,1,111,61},{13,0,1,1,111,65},{14,1,1,1,111,65},{13,0,1,1,111,95},{14,1,1,1,111,95},{13,0,1,1,111,98},{14,1,1,1,111,98},{13,0,1,1,111,100},{14,1,1,1,111,100},{13,0,1,1,111,102},{14,1,1,1,111,102},{13,0,1,1,111,103},{14,1,1,1,111,103},{13,0,1,1,111,104},{14,1,1,1,111,104},{13,0,1,1,111,108},{14,1,1,1,111,108},{13,0,1,1,111,109},{14,1,1,1,111,109},{13,0,1,1,111,110},{14,1,1,1,111,110},{13,0,1,1,111,112},{14,1,1,1,111,112},{13,0,1,1,111,114},{14,1,1,1,111,114},{13,0,1,1,111,117},{14,1,1,1,111,117},{0,1,1,1,111,58},{0,1,1,1,111,66},{0,1,1,1,111,67},{0,1,1,1,111,68},{0,1,1,1,111,69},{0,1,1,1,111,70},{0,1,1,1,111,71},{0,1,1,1,111,72},{0,1,1,1,111,73},{0,1,1,1,111,74},{0,1,1,1,111,75},{0,1,1,1,111,76},{0,1,1,1,111,77},{0,1,1,1,111,78},{0,1,1,1,111,79},{0,1,1,1,111,80},{0,1,1,1,111,81},{0,1,1,1,111,82},{0,1,1,1,111,83},{0,1,1,1,111,84},{0,1,1,1,111,85},{0,1,1,1,111,86},{0,1,1,1,111,87},{0,1,1,1,111,89},{0,1,1,1,111,106},{0,1,1,1,111,107},{0,1,1,1,111,113},{0,1,1,1,111,118},{0,1,1,1,111,119},{0,1,1,1,111,120},{0,1,1,1,111,121},{0,1,1,1,111,122},{85,0,0,1,0,111},{86,0,0,1,0,111},{87,0,0,1,0,111},{88,1,0,1,0,111},{9,0,1,1,115,48},{10,0,1,1,115,48},{11,0,1,1,115,48},{12,1,1,1,115,48},{9,0,1,1,115,49},{10,0,1,1,115,49},{11,0,1,1,115,49},{12,1,1,1,115,49},{9,0,1,1,115,50},{10,0,1,1,115,50},{11,0,1,1,115,50},{12,1,1,1,115,50},{9,0,1,1,115,97},{10,0,1,1,115,97},{11,0,1,1,115,97},{12,1,1,1,115,97},{9,0,1,1,115,99},{10,0,1,1,115,99},{11,0,1,1,115,99},{12,1,1,1,115,99},{9,0,1,1,115,101},{10,0,1,1,115,101},{11,0,1,1,115,101},{12,1,1,1,115,101},{9,0,1,1,115,105},{10,0,1,1,115,105},{11,0,1,1,115,105},{12,1,1,1,115,105},{9,0,1,1,115,111},{10,0,1,1,115,111},{11,0,1,1,115,111},{12,1,1,1,115,111},{9,0,1,1,115,115},{10,0,1,1,115,115},{11,0,1,1,115,115},{12,1,1,1,115,115},{9,0,1,1,115,116},{10,0,1,1,115,116},{11,0,1,1,115,116},{12,1,1,1,115,116},{13,0,1,1,115,32},{14,1,1,1,115,32},{13,0,1,1,115,37},{14,1,1,1,115,37},{13,0,1,1,115,45},{14,1,1,1,115,45},{13,0,1,1,115,46},{14,1,1,1,115,46},{13,0,1,1,115,47},{14,1,1,1,115,47},{13,0,1,1,115,51},{14,1,1,1,115,51},{13,0,1,1,115,52},{14,1,1,1,115,52},{13,0,1,1,115,53},{14,1,1,1,115,53},{13,0,1,1,115,54},{14,1,1,1,115,54},{13,0,1,1,115,55},{14,1,1,1,115,55},{13,0,1,1,115,56},{14,1,1,1,115,56},{13,0,1,1,115,57},{14,1,1,1,115,57},{13,0,1,1,115,61},{14,1,1,1,115,61},{13,0,1,1,115,65},{14,1,1,1,115,65},{13,0,1,1,115,95},{14,1,1,1,115,95},{13,0,1,1,115,98},{14,1,1,1,115,98},{13,0,1,1,115,100},{14,1,1,1,115,100},{13,0,1,1,115,102},{14,1,1,1,115,102},{13,0,1,1,115,103},{14,1,1,1,115,103},{13,0,1,1,115,104},{14,1,1,1,115,104},{13,0,1,1,115,108},{14,1,1,1,115,108},{13,0,1,1,115,109},{14,1,1,1,115,109},{13,0,1,1,115,110},{14,1,1,1,115,110},{13,0,1,1,115,112},{14,1,1,1,115,112},{13,0,1,1,115,114},{14,1,1,1,115,114},{13,0,1,1,115,117},{14,1,1,1,115,117},{0,1,1,1,115,58},{0,1,1,1,115,66},{0,1,1,1,115,67},{0,1,1,1,115,68},{0,1,1,1,115,69},{0,1,1,1,115,70},{0,1,1,1,115,71},{0,1,1,1,115,72},{0,1,1,1,115,73},{0,1,1,1,115,74},{0,1,1,1,115,75},{0,1,1,1,115,76},{0,1,1,1,115,77},{0,1,1,1,115,78},{0,1,1,1,115,79},{0,1,1,1,115,80},{0,1,1,1,115,81},{0,1,1,1,115,82},{0,1,1,1,115,83},{0,1,1,1,115,84},{0,1,1,1,115,85},{0,1,1,1,115,86},{0,1,1,1,115,87},{0,1,1,1,115,89},{0,1,1,1,115,106},{0,1,1,1,115,107},{0,1,1,1,115,113},{0,1,1,1,115,118},{0,1,1,1,115,119},{0,1,1,1,115,120},{0,1,1,1,115,121},{0,1,1,1,115,122},{85,0,0,1,0,115},{86,0,0,1,0,115},{87,0,0,1,0,115},{88,1,0,1,0,115},{9,0,1,1,116,48},{10,0,1,1,116,48},{11,0,1,1,116,48},{12,1,1,1,116,48},{9,0,1,1,116,49},{10,0,1,1,116,49},{11,0,1,1,116,49},{12,1,1,1,116,49},{9,0,1,1,116,50},{10,0,1,1,116,50},{11,0,1,1,116,50},{12,1,1,1,116,50},{9,0,1,1,116,97},{10,0,1,1,116,97},{11,0,1,1,116,97},{12,1,1,1,116,97},{9,0,1,1,116,99},{10,0,1,1,116,99},{11,0,1,1,116,99},{12,1,1,1,116,99},{9,0,1,1,116,101},{10,0,1,1,116,101},{11,0,1,1,116,101},{12,1,1,1,116,101},{9,0,1,1,116,105},{10,0,1,1,116,105},{11,0,1,1,116,105},{12,1,1,1,116,105},{9,0,1,1,116,111},{10,0,1,1,116,111},{11,0,1,1,116,111},{12,1,1,1,116,111},{9,0,1,1,116,115},{10,0,1,1,116,115},{11,0,1,1,116,115},{12,1,1,1,116,115},{9,0,1,1,116,116},{10,0,1,1,116,116},{11,0,1,1,116,116},{12,1,1,1,116,116},{13,0,1,1,116,32},{14,1,1,1,116,32},{13,0,1,1,116,37},{14,1,1,1,116,37},{13,0,1,1,116,45},{14,1,1,1,116,45},{13,0,1,1,116,46},{14,1,1,1,116,46},{13,0,1,1,116,47},{14,1,1,1,116,47},{13,0,1,1,116,51},{14,1,1,1,116,51},{13,0,1,1,116,52},{14,1,1,1,116,52},{13,0,1,1,116,53},{14,1,1,1,116,53},{13,0,1,1,116,54},{14,1,1,1,116,54},{13,0,1,1,116,55},{14,1,1,1,116,55},{13,0,1,1,116,56},{14,1,1,1,116,56},{13,0,1,1,116,57},{14,1,1,1,116,57},{13,0,1,1,116,61},{14,1,1,1,116,61},{13,0,1,1,116,65},{14,1,1,1,116,65},{13,0,1,1,116,95},{14,1,1,1,116,95},{13,0,1,1,116,98},{14,1,1,1,116,98},{13,0,1,1,116,100},{14,1,1,1,116,100},{13,0,1,1,116,102},{14,1,1,1,116,102},{13,0,1,1,116,103},{14,1,1,1,116,103},{13,0,1,1,116,104},{14,1,1,1,116,104},{13,0,1,1,116,108},{14,1,1,1,116,108},{13,0,1,1,116,109},{14,1,1,1,116,109},{13,0,1,1,116,110},{14,1,1,1,116,110},{13,0,1,1,116,112},{14,1,1,1,116,112},{13,0,1,1,116,114},{14,1,1,1,116,114},{13,0,1,1,116,117},{14,1,1,1,116,117},{0,1,1,1,116,58},{0,1,1,1,116,66},{0,1,1,1,116,67},{0,1,1,1,116,68},{0,1,1,1,116,69},{0,1,1,1,116,70},{0,1,1,1,116,71},{0,1,1,1,116,72},{0,1,1,1,116,73},{0,1,1,1,116,74},{0,1,1,1,116,75},{0,1,1,1,116,76},{0,1,1,1,116,77},{0,1,1,1,116,78},{0,1,1,1,116,79},{0,1,1,1,116,80},{0,1,1,1,116,81},{0,1,1,1,116,82},{0,1,1,1,116,83},{0,1,1,1,116,84},{0,1,1,1,116,85},{0,1,1,1,116,86},{0,1,1,1,116,87},{0,1,1,1,116,89},{0,1,1,1,116,106},{0,1,1,1,116,107},{0,1,1,1,116,113},{0,1,1,1,116,118},{0,1,1,1,116,119},{0,1,1,1,116,120},{0,1,1,1,116,121},{0,1,1,1,116,122},{85,0,0,1,0,116},{86,0,0,1,0,116},{87,0,0,1,0,116},{88,1,0,1,0,116},{13,0,1,1,32,48},{14,1,1,1,32,48},{13,0,1,1,32,49},{14,1,1,1,32,49},{13,0,1,1,32,50},{14,1,1,1,32,50},{13,0,1,1,32,97},{14,1,1,1,32,97},{13,0,1,1,32,99},{14,1,1,1,32,99},{13,0,1,1,32,101},{14,1,1,1,32,101},{13,0,1,1,32,105},{14,1,1,1,32,105},{13,0,1,1,32,111},{14,1,1,1,32,111},{13,0,1,1,32,115},{14,1,1,1,32,115},{13,0,1,1,32,116},{14,1,1,1,32,116},{0,1,1,1,32,32},{0,1,1,1,32,37},{0,1,1,1,32,45},{0,1,1,1,32,46},{0,1,1,1,32,47},{0,1,1,1,32,51},{0,1,1,1,32,52},{0,1,1,1,32,53},{0,1,1,1,32,54},{0,1,1,1,32,55},{0,1,1,1,32,56},{0,1,1,1,32,57},{0,1,1,1,32,61},{0,1,1,1,32,65},{0,1,1,1,32,95},{0,1,1,1,32,98},{0,1,1,1,32,100},{0,1,1,1,32,102},{0,1,1,1,32,103},{0,1,1,1,32,104},{0,1,1,1,32,108},{0,1,1,1,32,109},{0,1,1,1,32,110},{0,1,1,1,32,112},{0,1,1,1,32,114},{0,1,1,1,32,117},{17,0,0,1,0,32},{18,0,0,1,0,32},{19,0,0,1,0,32},{20,0,0,1,0,32},{21,0,0,1,0,32},{22,0,0,1,0,32},{23,0,0,1,0,32},{24,0,0,1,0,32},{25,0,0,1,0,32},{26,0,0,1,0,32},{27,0,0,1,0,32},{28,0,0,1,0,32},{29,0,0,1,0,32},{30,0,0,1,0,32},{31,0,0,1,0,32},{32,0,0,1,0,32},{33,0,0,1,0,32},{34,1,0,1,0,32},{13,0,1,1,37,48},{14,1,1,1,37,48},{13,0,1,1,37,49},{14,1,1,1,37,49},{13,0,1,1,37,50},{14,1,1,1,37,50},{13,0,1,1,37,97},{14,1,1,1,37,97},{13,0,1,1,37,99},{14,1,1,1,37,99},{13,0,1,1,37,101},{14,1,1,1,37,101},{13,0,1,1,37,105},{14,1,1,1,37,105},{13,0,1,1,37,111},{14,1,1,1,37,111},{13,0,1,1,37,115},{14,1,1,1,37,115},{13,0,1,1,37,116},{14,1,1,1,37,116},{0,1,1,1,37,32},{0,1,1,1,37,37},{0,1,1,1,37,45},{0,1,1,1,37,46},{0,1,1,1,37,47},{0,1,1,1,37,51},{0,1,1,1,37,52},{0,1,1,1,37,53},{0,1,1,1,37,54},{0,1,1,1,37,55},{0,1,1,1,37,56},{0,1,1,1,37,57},{0,1,1,1,37,61},{0,1,1,1,37,65},{0,1,1,1,37,95},{0,1,1,1,37,98},{0,1,1,1,37,100},{0,1,1,1,37,102},{0,1,1,1,37,103},{0,1,1,1,37,104},{0,1,1,1,37,108},{0,1,1,1,37,109},{0,1,1,1,37,110},{0,1,1,1,37,112},{0,1,1,1,37,114},{0,1,1,1,37,117},{17,0,0,1,0,37},{18,0,0,1,0,37},{19,0,0,1,0,37},{20,0,0,1,0,37},{21,0,0,1,0,37},{22,0,0,1,0,37},{23,0,0,1,0,37},{24,0,0,1,0,37},{25,0,0,1,0,37},{26,0,0,1,0,37},{27,0,0,1,0,37},{28,0,0,1,0,37},{29,0,0,1,0,37},{30,0,0,1,0,37},{31,0,0,1,0,37},{32,0,0,1,0,37},{33,0,0,1,0,37},{34,1,0,1,0,37},{13,0,1,1,45,48},{14,1,1,1,45,48},{13,0,1,1,45,49},{14,1,1,1,45,49},{13,0,1,1,45,50},{14,1,1,1,45,50},{13,0,1,1,45,97},{14,1,1,1,45,97},{13,0,1,1,45,99},{14,1,1,1,45,99},{13,0,1,1,45,101},{14,1,1,1,45,101},{13,0,1,1,45,105},{14,1,1,1,45,105},{13,0,1,1,45,111},{14,1,1,1,45,111},{13,0,1,1,45,115},{14,1,1,1,45,115},{13,0,1,1,45,116},{14,1,1,1,45,116},{0,1,1,1,45,32},{0,1,1,1,45,37},{0,1,1,1,45,45},{0,1,1,1,45,46},{0,1,1,1,45,47},{0,1,1,1,45,51},{0,1,1,1,45,52},{0,1,1,1,45,53},{0,1,1,1,45,54},{0,1,1,1,45,55},{0,1,1,1,45,56},{0,1,1,1,45,57},{0,1,1,1,45,61},{0,1,1,1,45,65},{0,1,1,1,45,95},{0,1,1,1,45,98},{0,1,1,1,45,100},{0,1,1,1,45,102},{0,1,1,1,45,103},{0,1,1,1,45,104},{0,1,1,1,45,108},{0,1,1,1,45,109},{0,1,1,1,45,110},{0,1,1,1,45,112},{0,1,1,1,45,114},{0,1,1,1,45,117},{17,0,0,1,0,45},{18,0,0,1,0,45},{19,0,0,1,0,45},{20,0,0,1,0,45},{21,0,0,1,0,45},{22,0,0,1,0,45},{23,0,0,1,0,45},{24,0,0,1,0,45},{25,0,0,1,0,45},{26,0,0,1,0,45},{27,0,0,1,0,45},{28,0,0,1,0,45},{29,0,0,1,0,45},{30,0,0,1,0,45},{31,0,0,1,0,45},{32,0,0,1,0,45},{33,0,0,1,0,45},{34,1,0,1,0,45},{13,0,1,1,46,48},{14,1,1,1,46,48},{13,0,1,1,46,49},{14,1,1,1,46,49},{13,0,1,1,46,50},{14,1,1,1,46,50},{13,0,1,1,46,97},{14,1,1,1,46,97},{13,0,1,1,46,99},{14,1,1,1,46,99},{13,0,1,1,46,101},{14,1,1,1,46,101},{13,0,1,1,46,105},{14,1,1,1,46,105},{13,0,1,1,46,111},{14,1,1,1,46,111},{13,0,1,1,46,115},{14,1,1,1,46,115},{13,0,1,1,46,116},{14,1,1,1,46,116},{0,1,1,1,46,32},{0,1,1,1,46,37},{0,1,1,1,46,45},{0,1,1,1,46,46},{0,1,1,1,46,47},{0,1,1,1,46,51},{0,1,1,1,46,52},{0,1,1,1,46,53},{0,1,1,1,46,54},{0,1,1,1,46,55},{0,1,1,1,46,56},{0,1,1,1,46,57},{0,1,1,1,46,61},{0,1,1,1,46,65},{0,1,1,1,46,95},{0,1,1,1,46,98},{0,1,1,1,46,100},{0,1,1,1,46,102},{0,1,1,1,46,103},{0,1,1,1,46,104},{0,1,1,1,46,108},{0,1,1,1,46,109},{0,1,1,1,46,110},{0,1,1,1,46,112},{0,1,1,1,46,114},{0,1,1,1,46,117},{17,0,0,1,0,46},{18,0,0,1,0,46},{19,0,0,1,0,46},{20,0,0,1,0,46},{21,0,0,1,0,46},{22,0,0,1,0,46},{23,0,0,1,0,46},{24,0,0,1,0,46},{25,0,0,1,0,46},{26,0,0,1,0,46},{27,0,0,1,0,46},{28,0,0,1,0,46},{29,0,0,1,0,46},{30,0,0,1,0,46},{31,0,0,1,0,46},{32,0,0,1,0,46},{33,0,0,1,0,46},{34,1,0,1,0,46},{13,0,1,1,47,48},{14,1,1,1,47,48},{13,0,1,1,47,49},{14,1,1,1,47,49},{13,0,1,1,47,50},{14,1,1,1,47,50},{13,0,1,1,47,97},{14,1,1,1,47,97},{13,0,1,1,47,99},{14,1,1,1,47,99},{13,0,1,1,47,101},{14,1,1,1,47,101},{13,0,1,1,47,105},{14,1,1,1,47,105},{13,0,1,1,47,111},{14,1,1,1,47,111},{13,0,1,1,47,115},{14,1,1,1,47,115},{13,0,1,1,47,116},{14,1,1,1,47,116},{0,1,1,1,47,32},{0,1,1,1,47,37},{0,1,1,1,47,45},{0,1,1,1,47,46},{0,1,1,1,47,47},{0,1,1,1,47,51},{0,1,1,1,47,52},{0,1,1,1,47,53},{0,1,1,1,47,54},{0,1,1,1,47,55},{0,1,1,1,47,56},{0,1,1,1,47,57},{0,1,1,1,47,61},{0,1,1,1,47,65},{0,1,1,1,47,95},{0,1,1,1,47,98},{0,1,1,1,47,100},{0,1,1,1,47,102},{0,1,1,1,47,103},{0,1,1,1,47,104},{0,1,1,1,47,108},{0,1,1,1,47,109},{0,1,1,1,47,110},{0,1,1,1,47,112},{0,1,1,1,47,114},{0,1,1,1,47,117},{17,0,0,1,0,47},{18,0,0,1,0,47},{19,0,0,1,0,47},{20,0,0,1,0,47},{21,0,0,1,0,47},{22,0,0,1,0,47},{23,0,0,1,0,47},{24,0,0,1,0,47},{25,0,0,1,0,47},{26,0,0,1,0,47},{27,0,0,1,0,47},{28,0,0,1,0,47},{29,0,0,1,0,47},{30,0,0,1,0,47},{31,0,0,1,0,47},{32,0,0,1,0,47},{33,0,0,1,0,47},{34,1,0,1,0,47},{13,0,1,1,51,48},{14,1,1,1,51,48},{13,0,1,1,51,49},{14,1,1,1,51,49},{13,0,1,1,51,50},{14,1,1,1,51,50},{13,0,1,1,51,97},{14,1,1,1,51,97},{13,0,1,1,51,99},{14,1,1,1,51,99},{13,0,1,1,51,101},{14,1,1,1,51,101},{13,0,1,1,51,105},{14,1,1,1,51,105},{13,0,1,1,51,111},{14,1,1,1,51,111},{13,0,1,1,51,115},{14,1,1,1,51,115},{13,0,1,1,51,116},{14,1,1,1,51,116},{0,1,1,1,51,32},{0,1,1,1,51,37},{0,1,1,1,51,45},{0,1,1,1,51,46},{0,1,1,1,51,47},{0,1,1,1,51,51},{0,1,1,1,51,52},{0,1,1,1,51,53},{0,1,1,1,51,54},{0,1,1,1,51,55},{0,1,1,1,51,56},{0,1,1,1,51,57},{0,1,1,1,51,61},{0,1,1,1,51,65},{0,1,1,1,51,95},{0,1,1,1,51,98},{0,1,1,1,51,100},{0,1,1,1,51,102},{0,1,1,1,51,103},{0,1,1,1,51,104},{0,1,1,1,51,108},{0,1,1,1,51,109},{0,1,1,1,51,110},{0,1,1,1,51,112},{0,1,1,1,51,114},{0,1,1,1,51,117},{17,0,0,1,0,51},{18,0,0,1,0,51},{19,0,0,1,0,51},{20,0,0,1,0,51},{21,0,0,1,0,51},{22,0,0,1,0,51},{23,0,0,1,0,51},{24,0,0,1,0,51},{25,0,0,1,0,51},{26,0,0,1,0,51},{27,0,0,1,0,51},{28,0,0,1,0,51},{29,0,0,1,0,51},{30,0,0,1,0,51},{31,0,0,1,0,51},{32,0,0,1,0,51},{33,0,0,1,0,51},{34,1,0,1,0,51},{13,0,1,1,52,48},{14,1,1,1,52,48},{13,0,1,1,52,49},{14,1,1,1,52,49},{13,0,1,1,52,50},{14,1,1,1,52,50},{13,0,1,1,52,97},{14,1,1,1,52,97},{13,0,1,1,52,99},{14,1,1,1,52,99},{13,0,1,1,52,101},{14,1,1,1,52,101},{13,0,1,1,52,105},{14,1,1,1,52,105},{13,0,1,1,52,111},{14,1,1,1,52,111},{13,0,1,1,52,115},{14,1,1,1,52,115},{13,0,1,1,52,116},{14,1,1,1,52,116},{0,1,1,1,52,32},{0,1,1,1,52,37},{0,1,1,1,52,45},{0,1,1,1,52,46},{0,1,1,1,52,47},{0,1,1,1,52,51},{0,1,1,1,52,52},{0,1,1,1,52,53},{0,1,1,1,52,54},{0,1,1,1,52,55},{0,1,1,1,52,56},{0,1,1,1,52,57},{0,1,1,1,52,61},{0,1,1,1,52,65},{0,1,1,1,52,95},{0,1,1,1,52,98},{0,1,1,1,52,100},{0,1,1,1,52,102},{0,1,1,1,52,103},{0,1,1,1,52,104},{0,1,1,1,52,108},{0,1,1,1,52,109},{0,1,1,1,52,110},{0,1,1,1,52,112},{0,1,1,1,52,114},{0,1,1,1,52,117},{17,0,0,1,0,52},{18,0,0,1,0,52},{19,0,0,1,0,52},{20,0,0,1,0,52},{21,0,0,1,0,52},{22,0,0,1,0,52},{23,0,0,1,0,52},{24,0,0,1,0,52},{25,0,0,1,0,52},{26,0,0,1,0,52},{27,0,0,1,0,52},{28,0,0,1,0,52},{29,0,0,1,0,52},{30,0,0,1,0,52},{31,0,0,1,0,52},{32,0,0,1,0,52},{33,0,0,1,0,52},{34,1,0,1,0,52},{13,0,1,1,53,48},{14,1,1,1,53,48},{13,0,1,1,53,49},{14,1,1,1,53,49},{13,0,1,1,53,50},{14,1,1,1,53,50},{13,0,1,1,53,97},{14,1,1,1,53,97},{13,0,1,1,53,99},{14,1,1,1,53,99},{13,0,1,1,53,101},{14,1,1,1,53,101},{13,0,1,1,53,105},{14,1,1,1,53,105},{13,0,1,1,53,111},{14,1,1,1,53,111},{13,0,1,1,53,115},{14,1,1,1,53,115},{13,0,1,1,53,116},{14,1,1,1,53,116},{0,1,1,1,53,32},{0,1,1,1,53,37},{0,1,1,1,53,45},{0,1,1,1,53,46},{0,1,1,1,53,47},{0,1,1,1,53,51},{0,1,1,1,53,52},{0,1,1,1,53,53},{0,1,1,1,53,54},{0,1,1,1,53,55},{0,1,1,1,53,56},{0,1,1,1,53,57},{0,1,1,1,53,61},{0,1,1,1,53,65},{0,1,1,1,53,95},{0,1,1,1,53,98},{0,1,1,1,53,100},{0,1,1,1,53,102},{0,1,1,1,53,103},{0,1,1,1,53,104},{0,1,1,1,53,108},{0,1,1,1,53,109},{0,1,1,1,53,110},{0,1,1,1,53,112},{0,1,1,1,53,114},{0,1,1,1,53,117},{17,0,0,1,0,53},{18,0,0,1,0,53},{19,0,0,1,0,53},{20,0,0,1,0,53},{21,0,0,1,0,53},{22,0,0,1,0,53},{23,0,0,1,0,53},{24,0,0,1,0,53},{25,0,0,1,0,53},{26,0,0,1,0,53},{27,0,0,1,0,53},{28,0,0,1,0,53},{29,0,0,1,0,53},{30,0,0,1,0,53},{31,0,0,1,0,53},{32,0,0,1,0,53},{33,0,0,1,0,53},{34,1,0,1,0,53},{13,0,1,1,54,48},{14,1,1,1,54,48},{13,0,1,1,54,49},{14,1,1,1,54,49},{13,0,1,1,54,50},{14,1,1,1,54,50},{13,0,1,1,54,97},{14,1,1,1,54,97},{13,0,1,1,54,99},{14,1,1,1,54,99},{13,0,1,1,54,101},{14,1,1,1,54,101},{13,0,1,1,54,105},{14,1,1,1,54,105},{13,0,1,1,54,111},{14,1,1,1,54,111},{13,0,1,1,54,115},{14,1,1,1,54,115},{13,0,1,1,54,116},{14,1,1,1,54,116},{0,1,1,1,54,32},{0,1,1,1,54,37},{0,1,1,1,54,45},{0,1,1,1,54,46},{0,1,1,1,54,47},{0,1,1,1,54,51},{0,1,1,1,54,52},{0,1,1,1,54,53},{0,1,1,1,54,54},{0,1,1,1,54,55},{0,1,1,1,54,56},{0,1,1,1,54,57},{0,1,1,1,54,61},{0,1,1,1,54,65},{0,1,1,1,54,95},{0,1,1,1,54,98},{0,1,1,1,54,100},{0,1,1,1,54,102},{0,1,1,1,54,103},{0,1,1,1,54,104},{0,1,1,1,54,108},{0,1,1,1,54,109},{0,1,1,1,54,110},{0,1,1,1,54,112},{0,1,1,1,54,114},{0,1,1,1,54,117},{17,0,0,1,0,54},{18,0,0,1,0,54},{19,0,0,1,0,54},{20,0,0,1,0,54},{21,0,0,1,0,54},{22,0,0,1,0,54},{23,0,0,1,0,54},{24,0,0,1,0,54},{25,0,0,1,0,54},{26,0,0,1,0,54},{27,0,0,1,0,54},{28,0,0,1,0,54},{29,0,0,1,0,54},{30,0,0,1,0,54},{31,0,0,1,0,54},{32,0,0,1,0,54},{33,0,0,1,0,54},{34,1,0,1,0,54},{13,0,1,1,55,48},{14,1,1,1,55,48},{13,0,1,1,55,49},{14,1,1,1,55,49},{13,0,1,1,55,50},{14,1,1,1,55,50},{13,0,1,1,55,97},{14,1,1,1,55,97},{13,0,1,1,55,99},{14,1,1,1,55,99},{13,0,1,1,55,101},{14,1,1,1,55,101},{13,0,1,1,55,105},{14,1,1,1,55,105},{13,0,1,1,55,111},{14,1,1,1,55,111},{13,0,1,1,55,115},{14,1,1,1,55,115},{13,0,1,1,55,116},{14,1,1,1,55,116},{0,1,1,1,55,32},{0,1,1,1,55,37},{0,1,1,1,55,45},{0,1,1,1,55,46},{0,1,1,1,55,47},{0,1,1,1,55,51},{0,1,1,1,55,52},{0,1,1,1,55,53},{0,1,1,1,55,54},{0,1,1,1,55,55},{0,1,1,1,55,56},{0,1,1,1,55,57},{0,1,1,1,55,61},{0,1,1,1,55,65},{0,1,1,1,55,95},{0,1,1,1,55,98},{0,1,1,1,55,100},{0,1,1,1,55,102},{0,1,1,1,55,103},{0,1,1,1,55,104},{0,1,1,1,55,108},{0,1,1,1,55,109},{0,1,1,1,55,110},{0,1,1,1,55,112},{0,1,1,1,55,114},{0,1,1,1,55,117},{17,0,0,1,0,55},{18,0,0,1,0,55},{19,0,0,1,0,55},{20,0,0,1,0,55},{21,0,0,1,0,55},{22,0,0,1,0,55},{23,0,0,1,0,55},{24,0,0,1,0,55},{25,0,0,1,0,55},{26,0,0,1,0,55},{27,0,0,1,0,55},{28,0,0,1,0,55},{29,0,0,1,0,55},{30,0,0,1,0,55},{31,0,0,1,0,55},{32,0,0,1,0,55},{33,0,0,1,0,55},{34,1,0,1,0,55},{13,0,1,1,56,48},{14,1,1,1,56,48},{13,0,1,1,56,49},{14,1,1,1,56,49},{13,0,1,1,56,50},{14,1,1,1,56,50},{13,0,1,1,56,97},{14,1,1,1,56,97},{13,0,1,1,56,99},{14,1,1,1,56,99},{13,0,1,1,56,101},{14,1,1,1,56,101},{13,0,1,1,56,105},{14,1,1,1,56,105},{13,0,1,1,56,111},{14,1,1,1,56,111},{13,0,1,1,56,115},{14,1,1,1,56,115},{13,0,1,1,56,116},{14,1,1,1,56,116},{0,1,1,1,56,32},{0,1,1,1,56,37},{0,1,1,1,56,45},{0,1,1,1,56,46},{0,1,1,1,56,47},{0,1,1,1,56,51},{0,1,1,1,56,52},{0,1,1,1,56,53},{0,1,1,1,56,54},{0,1,1,1,56,55},{0,1,1,1,56,56},{0,1,1,1,56,57},{0,1,1,1,56,61},{0,1,1,1,56,65},{0,1,1,1,56,95},{0,1,1,1,56,98},{0,1,1,1,56,100},{0,1,1,1,56,102},{0,1,1,1,56,103},{0,1,1,1,56,104},{0,1,1,1,56,108},{0,1,1,1,56,109},{0,1,1,1,56,110},{0,1,1,1,56,112},{0,1,1,1,56,114},{0,1,1,1,56,117},{17,0,0,1,0,56},{18,0,0,1,0,56},{19,0,0,1,0,56},{20,0,0,1,0,56},{21,0,0,1,0,56},{22,0,0,1,0,56},{23,0,0,1,0,56},{24,0,0,1,0,56},{25,0,0,1,0,56},{26,0,0,1,0,56},{27,0,0,1,0,56},{28,0,0,1,0,56},{29,0,0,1,0,56},{30,0,0,1,0,56},{31,0,0,1,0,56},{32,0,0,1,0,56},{33,0,0,1,0,56},{34,1,0,1,0,56},{13,0,1,1,57,48},{14,1,1,1,57,48},{13,0,1,1,57,49},{14,1,1,1,57,49},{13,0,1,1,57,50},{14,1,1,1,57,50},{13,0,1,1,57,97},{14,1,1,1,57,97},{13,0,1,1,57,99},{14,1,1,1,57,99},{13,0,1,1,57,101},{14,1,1,1,57,101},{13,0,1,1,57,105},{14,1,1,1,57,105},{13,0,1,1,57,111},{14,1,1,1,57,111},{13,0,1,1,57,115},{14,1,1,1,57,115},{13,0,1,1,57,116},{14,1,1,1,57,116},{0,1,1,1,57,32},{0,1,1,1,57,37},{0,1,1,1,57,45},{0,1,1,1,57,46},{0,1,1,1,57,47},{0,1,1,1,57,51},{0,1,1,1,57,52},{0,1,1,1,57,53},{0,1,1,1,57,54},{0,1,1,1,57,55},{0,1,1,1,57,56},{0,1,1,1,57,57},{0,1,1,1,57,61},{0,1,1,1,57,65},{0,1,1,1,57,95},{0,1,1,1,57,98},{0,1,1,1,57,100},{0,1,1,1,57,102},{0,1,1,1,57,103},{0,1,1,1,57,104},{0,1,1,1,57,108},{0,1,1,1,57,109},{0,1,1,1,57,110},{0,1,1,1,57,112},{0,1,1,1,57,114},{0,1,1,1,57,117},{17,0,0,1,0,57},{18,0,0,1,0,57},{19,0,0,1,0,57},{20,0,0,1,0,57},{21,0,0,1,0,57},{22,0,0,1,0,57},{23,0,0,1,0,57},{24,0,0,1,0,57},{25,0,0,1,0,57},{26,0,0,1,0,57},{27,0,0,1,0,57},{28,0,0,1,0,57},{29,0,0,1,0,57},{30,0,0,1,0,57},{31,0,0,1,0,57},{32,0,0,1,0,57},{33,0,0,1,0,57},{34,1,0,1,0,57},{13,0,1,1,61,48},{14,1,1,1,61,48},{13,0,1,1,61,49},{14,1,1,1,61,49},{13,0,1,1,61,50},{14,1,1,1,61,50},{13,0,1,1,61,97},{14,1,1,1,61,97},{13,0,1,1,61,99},{14,1,1,1,61,99},{13,0,1,1,61,101},{14,1,1,1,61,101},{13,0,1,1,61,105},{14,1,1,1,61,105},{13,0,1,1,61,111},{14,1,1,1,61,111},{13,0,1,1,61,115},{14,1,1,1,61,115},{13,0,1,1,61,116},{14,1,1,1,61,116},{0,1,1,1,61,32},{0,1,1,1,61,37},{0,1,1,1,61,45},{0,1,1,1,61,46},{0,1,1,1,61,47},{0,1,1,1,61,51},{0,1,1,1,61,52},{0,1,1,1,61,53},{0,1,1,1,61,54},{0,1,1,1,61,55},{0,1,1,1,61,56},{0,1,1,1,61,57},{0,1,1,1,61,61},{0,1,1,1,61,65},{0,1,1,1,61,95},{0,1,1,1,61,98},{0,1,1,1,61,100},{0,1,1,1,61,102},{0,1,1,1,61,103},{0,1,1,1,61,104},{0,1,1,1,61,108},{0,1,1,1,61,109},{0,1,1,1,61,110},{0,1,1,1,61,112},{0,1,1,1,61,114},{0,1,1,1,61,117},{17,0,0,1,0,61},{18,0,0,1,0,61},{19,0,0,1,0,61},{20,0,0,1,0,61},{21,0,0,1,0,61},{22,0,0,1,0,61},{23,0,0,1,0,61},{24,0,0,1,0,61},{25,0,0,1,0,61},{26,0,0,1,0,61},{27,0,0,1,0,61},{28,0,0,1,0,61},{29,0,0,1,0,61},{30,0,0,1,0,61},{31,0,0,1,0,61},{32,0,0,1,0,61},{33,0,0,1,0,61},{34,1,0,1,0,61},{13,0,1,1,65,48},{14,1,1,1,65,48},{13,0,1,1,65,49},{14,1,1,1,65,49},{13,0,1,1,65,50},{14,1,1,1,65,50},{13,0,1,1,65,97},{14,1,1,1,65,97},{13,0,1,1,65,99},{14,1,1,1,65,99},{13,0,1,1,65,101},{14,1,1,1,65,101},{13,0,1,1,65,105},{14,1,1,1,65,105},{13,0,1,1,65,111},{14,1,1,1,65,111},{13,0,1,1,65,115},{14,1,1,1,65,115},{13,0,1,1,65,116},{14,1,1,1,65,116},{0,1,1,1,65,32},{0,1,1,1,65,37},{0,1,1,1,65,45},{0,1,1,1,65,46},{0,1,1,1,65,47},{0,1,1,1,65,51},{0,1,1,1,65,52},{0,1,1,1,65,53},{0,1,1,1,65,54},{0,1,1,1,65,55},{0,1,1,1,65,56},{0,1,1,1,65,57},{0,1,1,1,65,61},{0,1,1,1,65,65},{0,1,1,1,65,95},{0,1,1,1,65,98},{0,1,1,1,65,100},{0,1,1,1,65,102},{0,1,1,1,65,103},{0,1,1,1,65,104},{0,1,1,1,65,108},{0,1,1,1,65,109},{0,1,1,1,65,110},{0,1,1,1,65,112},{0,1,1,1,65,114},{0,1,1,1,65,117},{17,0,0,1,0,65},{18,0,0,1,0,65},{19,0,0,1,0,65},{20,0,0,1,0,65},{21,0,0,1,0,65},{22,0,0,1,0,65},{23,0,0,1,0,65},{24,0,0,1,0,65},{25,0,0,1,0,65},{26,0,0,1,0,65},{27,0,0,1,0,65},{28,0,0,1,0,65},{29,0,0,1,0,65},{30,0,0,1,0,65},{31,0,0,1,0,65},{32,0,0,1,0,65},{33,0,0,1,0,65},{34,1,0,1,0,65},{13,0,1,1,95,48},{14,1,1,1,95,48},{13,0,1,1,95,49},{14,1,1,1,95,49},{13,0,1,1,95,50},{14,1,1,1,95,50},{13,0,1,1,95,97},{14,1,1,1,95,97},{13,0,1,1,95,99},{14,1,1,1,95,99},{13,0,1,1,95,101},{14,1,1,1,95,101},{13,0,1,1,95,105},{14,1,1,1,95,105},{13,0,1,1,95,111},{14,1,1,1,95,111},{13,0,1,1,95,115},{14,1,1,1,95,115},{13,0,1,1,95,116},{14,1,1,1,95,116},{0,1,1,1,95,32},{0,1,1,1,95,37},{0,1,1,1,95,45},{0,1,1,1,95,46},{0,1,1,1,95,47},{0,1,1,1,95,51},{0,1,1,1,95,52},{0,1,1,1,95,53},{0,1,1,1,95,54},{0,1,1,1,95,55},{0,1,1,1,95,56},{0,1,1,1,95,57},{0,1,1,1,95,61},{0,1,1,1,95,65},{0,1,1,1,95,95},{0,1,1,1,95,98},{0,1,1,1,95,100},{0,1,1,1,95,102},{0,1,1,1,95,103},{0,1,1,1,95,104},{0,1,1,1,95,108},{0,1,1,1,95,109},{0,1,1,1,95,110},{0,1,1,1,95,112},{0,1,1,1,95,114},{0,1,1,1,95,117},{17,0,0,1,0,95},{18,0,0,1,0,95},{19,0,0,1,0,95},{20,0,0,1,0,95},{21,0,0,1,0,95},{22,0,0,1,0,95},{23,0,0,1,0,95},{24,0,0,1,0,95},{25,0,0,1,0,95},{26,0,0,1,0,95},{27,0,0,1,0,95},{28,0,0,1,0,95},{29,0,0,1,0,95},{30,0,0,1,0,95},{31,0,0,1,0,95},{32,0,0,1,0,95},{33,0,0,1,0,95},{34,1,0,1,0,95},{13,0,1,1,98,48},{14,1,1,1,98,48},{13,0,1,1,98,49},{14,1,1,1,98,49},{13,0,1,1,98,50},{14,1,1,1,98,50},{13,0,1,1,98,97},{14,1,1,1,98,97},{13,0,1,1,98,99},{14,1,1,1,98,99},{13,0,1,1,98,101},{14,1,1,1,98,101},{13,0,1,1,98,105},{14,1,1,1,98,105},{13,0,1,1,98,111},{14,1,1,1,98,111},{13,0,1,1,98,115},{14,1,1,1,98,115},{13,0,1,1,98,116},{14,1,1,1,98,116},{0,1,1,1,98,32},{0,1,1,1,98,37},{0,1,1,1,98,45},{0,1,1,1,98,46},{0,1,1,1,98,47},{0,1,1,1,98,51},{0,1,1,1,98,52},{0,1,1,1,98,53},{0,1,1,1,98,54},{0,1,1,1,98,55},{0,1,1,1,98,56},{0,1,1,1,98,57},{0,1,1,1,98,61},{0,1,1,1,98,65},{0,1,1,1,98,95},{0,1,1,1,98,98},{0,1,1,1,98,100},{0,1,1,1,98,102},{0,1,1,1,98,103},{0,1,1,1,98,104},{0,1,1,1,98,108},{0,1,1,1,98,109},{0,1,1,1,98,110},{0,1,1,1,98,112},{0,1,1,1,98,114},{0,1,1,1,98,117},{17,0,0,1,0,98},{18,0,0,1,0,98},{19,0,0,1,0,98},{20,0,0,1,0,98},{21,0,0,1,0,98},{22,0,0,1,0,98},{23,0,0,1,0,98},{24,0,0,1,0,98},{25,0,0,1,0,98},{26,0,0,1,0,98},{27,0,0,1,0,98},{28,0,0,1,0,98},{29,0,0,1,0,98},{30,0,0,1,0,98},{31,0,0,1,0,98},{32,0,0,1,0,98},{33,0,0,1,0,98},{34,1,0,1,0,98},{13,0,1,1,100,48},{14,1,1,1,100,48},{13,0,1,1,100,49},{14,1,1,1,100,49},{13,0,1,1,100,50},{14,1,1,1,100,50},{13,0,1,1,100,97},{14,1,1,1,100,97},{13,0,1,1,100,99},{14,1,1,1,100,99},{13,0,1,1,100,101},{14,1,1,1,100,101},{13,0,1,1,100,105},{14,1,1,1,100,105},{13,0,1,1,100,111},{14,1,1,1,100,111},{13,0,1,1,100,115},{14,1,1,1,100,115},{13,0,1,1,100,116},{14,1,1,1,100,116},{0,1,1,1,100,32},{0,1,1,1,100,37},{0,1,1,1,100,45},{0,1,1,1,100,46},{0,1,1,1,100,47},{0,1,1,1,100,51},{0,1,1,1,100,52},{0,1,1,1,100,53},{0,1,1,1,100,54},{0,1,1,1,100,55},{0,1,1,1,100,56},{0,1,1,1,100,57},{0,1,1,1,100,61},{0,1,1,1,100,65},{0,1,1,1,100,95},{0,1,1,1,100,98},{0,1,1,1,100,100},{0,1,1,1,100,102},{0,1,1,1,100,103},{0,1,1,1,100,104},{0,1,1,1,100,108},{0,1,1,1,100,109},{0,1,1,1,100,110},{0,1,1,1,100,112},{0,1,1,1,100,114},{0,1,1,1,100,117},{17,0,0,1,0,100},{18,0,0,1,0,100},{19,0,0,1,0,100},{20,0,0,1,0,100},{21,0,0,1,0,100},{22,0,0,1,0,100},{23,0,0,1,0,100},{24,0,0,1,0,100},{25,0,0,1,0,100},{26,0,0,1,0,100},{27,0,0,1,0,100},{28,0,0,1,0,100},{29,0,0,1,0,100},{30,0,0,1,0,100},{31,0,0,1,0,100},{32,0,0,1,0,100},{33,0,0,1,0,100},{34,1,0,1,0,100},{13,0,1,1,102,48},{14,1,1,1,102,48},{13,0,1,1,102,49},{14,1,1,1,102,49},{13,0,1,1,102,50},{14,1,1,1,102,50},{13,0,1,1,102,97},{14,1,1,1,102,97},{13,0,1,1,102,99},{14,1,1,1,102,99},{13,0,1,1,102,101},{14,1,1,1,102,101},{13,0,1,1,102,105},{14,1,1,1,102,105},{13,0,1,1,102,111},{14,1,1,1,102,111},{13,0,1,1,102,115},{14,1,1,1,102,115},{13,0,1,1,102,116},{14,1,1,1,102,116},{0,1,1,1,102,32},{0,1,1,1,102,37},{0,1,1,1,102,45},{0,1,1,1,102,46},{0,1,1,1,102,47},{0,1,1,1,102,51},{0,1,1,1,102,52},{0,1,1,1,102,53},{0,1,1,1,102,54},{0,1,1,1,102,55},{0,1,1,1,102,56},{0,1,1,1,102,57},{0,1,1,1,102,61},{0,1,1,1,102,65},{0,1,1,1,102,95},{0,1,1,1,102,98},{0,1,1,1,102,100},{0,1,1,1,102,102},{0,1,1,1,102,103},{0,1,1,1,102,104},{0,1,1,1,102,108},{0,1,1,1,102,109},{0,1,1,1,102,110},{0,1,1,1,102,112},{0,1,1,1,102,114},{0,1,1,1,102,117},{17,0,0,1,0,102},{18,0,0,1,0,102},{19,0,0,1,0,102},{20,0,0,1,0,102},{21,0,0,1,0,102},{22,0,0,1,0,102},{23,0,0,1,0,102},{24,0,0,1,0,102},{25,0,0,1,0,102},{26,0,0,1,0,102},{27,0,0,1,0,102},{28,0,0,1,0,102},{29,0,0,1,0,102},{30,0,0,1,0,102},{31,0,0,1,0,102},{32,0,0,1,0,102},{33,0,0,1,0,102},{34,1,0,1,0,102},{13,0,1,1,103,48},{14,1,1,1,103,48},{13,0,1,1,103,49},{14,1,1,1,103,49},{13,0,1,1,103,50},{14,1,1,1,103,50},{13,0,1,1,103,97},{14,1,1,1,103,97},{13,0,1,1,103,99},{14,1,1,1,103,99},{13,0,1,1,103,101},{14,1,1,1,103,101},{13,0,1,1,103,105},{14,1,1,1,103,105},{13,0,1,1,103,111},{14,1,1,1,103,111},{13,0,1,1,103,115},{14,1,1,1,103,115},{13,0,1,1,103,116},{14,1,1,1,103,116},{0,1,1,1,103,32},{0,1,1,1,103,37},{0,1,1,1,103,45},{0,1,1,1,103,46},{0,1,1,1,103,47},{0,1,1,1,103,51},{0,1,1,1,103,52},{0,1,1,1,103,53},{0,1,1,1,103,54},{0,1,1,1,103,55},{0,1,1,1,103,56},{0,1,1,1,103,57},{0,1,1,1,103,61},{0,1,1,1,103,65},{0,1,1,1,103,95},{0,1,1,1,103,98},{0,1,1,1,103,100},{0,1,1,1,103,102},{0,1,1,1,103,103},{0,1,1,1,103,104},{0,1,1,1,103,108},{0,1,1,1,103,109},{0,1,1,1,103,110},{0,1,1,1,103,112},{0,1,1,1,103,114},{0,1,1,1,103,117},{17,0,0,1,0,103},{18,0,0,1,0,103},{19,0,0,1,0,103},{20,0,0,1,0,103},{21,0,0,1,0,103},{22,0,0,1,0,103},{23,0,0,1,0,103},{24,0,0,1,0,103},{25,0,0,1,0,103},{26,0,0,1,0,103},{27,0,0,1,0,103},{28,0,0,1,0,103},{29,0,0,1,0,103},{30,0,0,1,0,103},{31,0,0,1,0,103},{32,0,0,1,0,103},{33,0,0,1,0,103},{34,1,0,1,0,103},{13,0,1,1,104,48},{14,1,1,1,104,48},{13,0,1,1,104,49},{14,1,1,1,104,49},{13,0,1,1,104,50},{14,1,1,1,104,50},{13,0,1,1,104,97},{14,1,1,1,104,97},{13,0,1,1,104,99},{14,1,1,1,104,99},{13,0,1,1,104,101},{14,1,1,1,104,101},{13,0,1,1,104,105},{14,1,1,1,104,105},{13,0,1,1,104,111},{14,1,1,1,104,111},{13,0,1,1,104,115},{14,1,1,1,104,115},{13,0,1,1,104,116},{14,1,1,1,104,116},{0,1,1,1,104,32},{0,1,1,1,104,37},{0,1,1,1,104,45},{0,1,1,1,104,46},{0,1,1,1,104,47},{0,1,1,1,104,51},{0,1,1,1,104,52},{0,1,1,1,104,53},{0,1,1,1,104,54},{0,1,1,1,104,55},{0,1,1,1,104,56},{0,1,1,1,104,57},{0,1,1,1,104,61},{0,1,1,1,104,65},{0,1,1,1,104,95},{0,1,1,1,104,98},{0,1,1,1,104,100},{0,1,1,1,104,102},{0,1,1,1,104,103},{0,1,1,1,104,104},{0,1,1,1,104,108},{0,1,1,1,104,109},{0,1,1,1,104,110},{0,1,1,1,104,112},{0,1,1,1,104,114},{0,1,1,1,104,117},{17,0,0,1,0,104},{18,0,0,1,0,104},{19,0,0,1,0,104},{20,0,0,1,0,104},{21,0,0,1,0,104},{22,0,0,1,0,104},{23,0,0,1,0,104},{24,0,0,1,0,104},{25,0,0,1,0,104},{26,0,0,1,0,104},{27,0,0,1,0,104},{28,0,0,1,0,104},{29,0,0,1,0,104},{30,0,0,1,0,104},{31,0,0,1,0,104},{32,0,0,1,0,104},{33,0,0,1,0,104},{34,1,0,1,0,104},{13,0,1,1,108,48},{14,1,1,1,108,48},{13,0,1,1,108,49},{14,1,1,1,108,49},{13,0,1,1,108,50},{14,1,1,1,108,50},{13,0,1,1,108,97},{14,1,1,1,108,97},{13,0,1,1,108,99},{14,1,1,1,108,99},{13,0,1,1,108,101},{14,1,1,1,108,101},{13,0,1,1,108,105},{14,1,1,1,108,105},{13,0,1,1,108,111},{14,1,1,1,108,111},{13,0,1,1,108,115},{14,1,1,1,108,115},{13,0,1,1,108,116},{14,1,1,1,108,116},{0,1,1,1,108,32},{0,1,1,1,108,37},{0,1,1,1,108,45},{0,1,1,1,108,46},{0,1,1,1,108,47},{0,1,1,1,108,51},{0,1,1,1,108,52},{0,1,1,1,108,53},{0,1,1,1,108,54},{0,1,1,1,108,55},{0,1,1,1,108,56},{0,1,1,1,108,57},{0,1,1,1,108,61},{0,1,1,1,108,65},{0,1,1,1,108,95},{0,1,1,1,108,98},{0,1,1,1,108,100},{0,1,1,1,108,102},{0,1,1,1,108,103},{0,1,1,1,108,104},{0,1,1,1,108,108},{0,1,1,1,108,109},{0,1,1,1,108,110},{0,1,1,1,108,112},{0,1,1,1,108,114},{0,1,1,1,108,117},{17,0,0,1,0,108},{18,0,0,1,0,108},{19,0,0,1,0,108},{20,0,0,1,0,108},{21,0,0,1,0,108},{22,0,0,1,0,108},{23,0,0,1,0,108},{24,0,0,1,0,108},{25,0,0,1,0,108},{26,0,0,1,0,108},{27,0,0,1,0,108},{28,0,0,1,0,108},{29,0,0,1,0,108},{30,0,0,1,0,108},{31,0,0,1,0,108},{32,0,0,1,0,108},{33,0,0,1,0,108},{34,1,0,1,0,108},{13,0,1,1,109,48},{14,1,1,1,109,48},{13,0,1,1,109,49},{14,1,1,1,109,49},{13,0,1,1,109,50},{14,1,1,1,109,50},{13,0,1,1,109,97},{14,1,1,1,109,97},{13,0,1,1,109,99},{14,1,1,1,109,99},{13,0,1,1,109,101},{14,1,1,1,109,101},{13,0,1,1,109,105},{14,1,1,1,109,105},{13,0,1,1,109,111},{14,1,1,1,109,111},{13,0,1,1,109,115},{14,1,1,1,109,115},{13,0,1,1,109,116},{14,1,1,1,109,116},{0,1,1,1,109,32},{0,1,1,1,109,37},{0,1,1,1,109,45},{0,1,1,1,109,46},{0,1,1,1,109,47},{0,1,1,1,109,51},{0,1,1,1,109,52},{0,1,1,1,109,53},{0,1,1,1,109,54},{0,1,1,1,109,55},{0,1,1,1,109,56},{0,1,1,1,109,57},{0,1,1,1,109,61},{0,1,1,1,109,65},{0,1,1,1,109,95},{0,1,1,1,109,98},{0,1,1,1,109,100},{0,1,1,1,109,102},{0,1,1,1,109,103},{0,1,1,1,109,104},{0,1,1,1,109,108},{0,1,1,1,109,109},{0,1,1,1,109,110},{0,1,1,1,109,112},{0,1,1,1,109,114},{0,1,1,1,109,117},{17,0,0,1,0,109},{18,0,0,1,0,109},{19,0,0,1,0,109},{20,0,0,1,0,109},{21,0,0,1,0,109},{22,0,0,1,0,109},{23,0,0,1,0,109},{24,0,0,1,0,109},{25,0,0,1,0,109},{26,0,0,1,0,109},{27,0,0,1,0,109},{28,0,0,1,0,109},{29,0,0,1,0,109},{30,0,0,1,0,109},{31,0,0,1,0,109},{32,0,0,1,0,109},{33,0,0,1,0,109},{34,1,0,1,0,109},{13,0,1,1,110,48},{14,1,1,1,110,48},{13,0,1,1,110,49},{14,1,1,1,110,49},{13,0,1,1,110,50},{14,1,1,1,110,50},{13,0,1,1,110,97},{14,1,1,1,110,97},{13,0,1,1,110,99},{14,1,1,1,110,99},{13,0,1,1,110,101},{14,1,1,1,110,101},{13,0,1,1,110,105},{14,1,1,1,110,105},{13,0,1,1,110,111},{14,1,1,1,110,111},{13,0,1,1,110,115},{14,1,1,1,110,115},{13,0,1,1,110,116},{14,1,1,1,110,116},{0,1,1,1,110,32},{0,1,1,1,110,37},{0,1,1,1,110,45},{0,1,1,1,110,46},{0,1,1,1,110,47},{0,1,1,1,110,51},{0,1,1,1,110,52},{0,1,1,1,110,53},{0,1,1,1,110,54},{0,1,1,1,110,55},{0,1,1,1,110,56},{0,1,1,1,110,57},{0,1,1,1,110,61},{0,1,1,1,110,65},{0,1,1,1,110,95},{0,1,1,1,110,98},{0,1,1,1,110,100},{0,1,1,1,110,102},{0,1,1,1,110,103},{0,1,1,1,110,104},{0,1,1,1,110,108},{0,1,1,1,110,109},{0,1,1,1,110,110},{0,1,1,1,110,112},{0,1,1,1,110,114},{0,1,1,1,110,117},{17,0,0,1,0,110},{18,0,0,1,0,110},{19,0,0,1,0,110},{20,0,0,1,0,110},{21,0,0,1,0,110},{22,0,0,1,0,110},{23,0,0,1,0,110},{24,0,0,1,0,110},{25,0,0,1,0,110},{26,0,0,1,0,110},{27,0,0,1,0,110},{28,0,0,1,0,110},{29,0,0,1,0,110},{30,0,0,1,0,110},{31,0,0,1,0,110},{32,0,0,1,0,110},{33,0,0,1,0,110},{34,1,0,1,0,110},{13,0,1,1,112,48},{14,1,1,1,112,48},{13,0,1,1,112,49},{14,1,1,1,112,49},{13,0,1,1,112,50},{14,1,1,1,112,50},{13,0,1,1,112,97},{14,1,1,1,112,97},{13,0,1,1,112,99},{14,1,1,1,112,99},{13,0,1,1,112,101},{14,1,1,1,112,101},{13,0,1,1,112,105},{14,1,1,1,112,105},{13,0,1,1,112,111},{14,1,1,1,112,111},{13,0,1,1,112,115},{14,1,1,1,112,115},{13,0,1,1,112,116},{14,1,1,1,112,116},{0,1,1,1,112,32},{0,1,1,1,112,37},{0,1,1,1,112,45},{0,1,1,1,112,46},{0,1,1,1,112,47},{0,1,1,1,112,51},{0,1,1,1,112,52},{0,1,1,1,112,53},{0,1,1,1,112,54},{0,1,1,1,112,55},{0,1,1,1,112,56},{0,1,1,1,112,57},{0,1,1,1,112,61},{0,1,1,1,112,65},{0,1,1,1,112,95},{0,1,1,1,112,98},{0,1,1,1,112,100},{0,1,1,1,112,102},{0,1,1,1,112,103},{0,1,1,1,112,104},{0,1,1,1,112,108},{0,1,1,1,112,109},{0,1,1,1,112,110},{0,1,1,1,112,112},{0,1,1,1,112,114},{0,1,1,1,112,117},{17,0,0,1,0,112},{18,0,0,1,0,112},{19,0,0,1,0,112},{20,0,0,1,0,112},{21,0,0,1,0,112},{22,0,0,1,0,112},{23,0,0,1,0,112},{24,0,0,1,0,112},{25,0,0,1,0,112},{26,0,0,1,0,112},{27,0,0,1,0,112},{28,0,0,1,0,112},{29,0,0,1,0,112},{30,0,0,1,0,112},{31,0,0,1,0,112},{32,0,0,1,0,112},{33,0,0,1,0,112},{34,1,0,1,0,112},{13,0,1,1,114,48},{14,1,1,1,114,48},{13,0,1,1,114,49},{14,1,1,1,114,49},{13,0,1,1,114,50},{14,1,1,1,114,50},{13,0,1,1,114,97},{14,1,1,1,114,97},{13,0,1,1,114,99},{14,1,1,1,114,99},{13,0,1,1,114,101},{14,1,1,1,114,101},{13,0,1,1,114,105},{14,1,1,1,114,105},{13,0,1,1,114,111},{14,1,1,1,114,111},{13,0,1,1,114,115},{14,1,1,1,114,115},{13,0,1,1,114,116},{14,1,1,1,114,116},{0,1,1,1,114,32},{0,1,1,1,114,37},{0,1,1,1,114,45},{0,1,1,1,114,46},{0,1,1,1,114,47},{0,1,1,1,114,51},{0,1,1,1,114,52},{0,1,1,1,114,53},{0,1,1,1,114,54},{0,1,1,1,114,55},{0,1,1,1,114,56},{0,1,1,1,114,57},{0,1,1,1,114,61},{0,1,1,1,114,65},{0,1,1,1,114,95},{0,1,1,1,114,98},{0,1,1,1,114,100},{0,1,1,1,114,102},{0,1,1,1,114,103},{0,1,1,1,114,104},{0,1,1,1,114,108},{0,1,1,1,114,109},{0,1,1,1,114,110},{0,1,1,1,114,112},{0,1,1,1,114,114},{0,1,1,1,114,117},{17,0,0,1,0,114},{18,0,0,1,0,114},{19,0,0,1,0,114},{20,0,0,1,0,114},{21,0,0,1,0,114},{22,0,0,1,0,114},{23,0,0,1,0,114},{24,0,0,1,0,114},{25,0,0,1,0,114},{26,0,0,1,0,114},{27,0,0,1,0,114},{28,0,0,1,0,114},{29,0,0,1,0,114},{30,0,0,1,0,114},{31,0,0,1,0,114},{32,0,0,1,0,114},{33,0,0,1,0,114},{34,1,0,1,0,114},{13,0,1,1,117,48},{14,1,1,1,117,48},{13,0,1,1,117,49},{14,1,1,1,117,49},{13,0,1,1,117,50},{14,1,1,1,117,50},{13,0,1,1,117,97},{14,1,1,1,117,97},{13,0,1,1,117,99},{14,1,1,1,117,99},{13,0,1,1,117,101},{14,1,1,1,117,101},{13,0,1,1,117,105},{14,1,1,1,117,105},{13,0,1,1,117,111},{14,1,1,1,117,111},{13,0,1,1,117,115},{14,1,1,1,117,115},{13,0,1,1,117,116},{14,1,1,1,117,116},{0,1,1,1,117,32},{0,1,1,1,117,37},{0,1,1,1,117,45},{0,1,1,1,117,46},{0,1,1,1,117,47},{0,1,1,1,117,51},{0,1,1,1,117,52},{0,1,1,1,117,53},{0,1,1,1,117,54},{0,1,1,1,117,55},{0,1,1,1,117,56},{0,1,1,1,117,57},{0,1,1,1,117,61},{0,1,1,1,117,65},{0,1,1,1,117,95},{0,1,1,1,117,98},{0,1,1,1,117,100},{0,1,1,1,117,102},{0,1,1,1,117,103},{0,1,1,1,117,104},{0,1,1,1,117,108},{0,1,1,1,117,109},{0,1,1,1,117,110},{0,1,1,1,117,112},{0,1,1,1,117,114},{0,1,1,1,117,117},{17,0,0,1,0,117},{18,0,0,1,0,117},{19,0,0,1,0,117},{20,0,0,1,0,117},{21,0,0,1,0,117},{22,0,0,1,0,117},{23,0,0,1,0,117},{24,0,0,1,0,117},{25,0,0,1,0,117},{26,0,0,1,0,117},{27,0,0,1,0,117},{28,0,0,1,0,117},{29,0,0,1,0,117},{30,0,0,1,0,117},{31,0,0,1,0,117},{32,0,0,1,0,117},{33,0,0,1,0,117},{34,1,0,1,0,117},{0,1,1,1,58,48},{0,1,1,1,58,49},{0,1,1,1,58,50},{0,1,1,1,58,97},{0,1,1,1,58,99},{0,1,1,1,58,101},{0,1,1,1,58,105},{0,1,1,1,58,111},{0,1,1,1,58,115},{0,1,1,1,58,116},{35,0,0,1,0,58},{36,0,0,1,0,58},{37,0,0,1,0,58},{38,0,0,1,0,58},{39,0,0,1,0,58},{40,0,0,1,0,58},{41,0,0,1,0,58},{42,0,0,1,0,58},{43,0,0,1,0,58},{44,0,0,1,0,58},{45,0,0,1,0,58},{46,0,0,1,0,58},{47,0,0,1,0,58},{48,0,0,1,0,58},{49,0,0,1,0,58},{50,0,0,1,0,58},{51,0,0,1,0,58},{52,0,0,1,0,58},{53,0,0,1,0,58},{54,0,0,1,0,58},{55,0,0,1,0,58},{56,1,0,1,0,58},{0,1,1,1,66,48},{0,1,1,1,66,49},{0,1,1,1,66,50},{0,1,1,1,66,97},{0,1,1,1,66,99},{0,1,1,1,66,101},{0,1,1,1,66,105},{0,1,1,1,66,111},{0,1,1,1,66,115},{0,1,1,1,66,116},{35,0,0,1,0,66},{36,0,0,1,0,66},{37,0,0,1,0,66},{38,0,0,1,0,66},{39,0,0,1,0,66},{40,0,0,1,0,66},{41,0,0,1,0,66},{42,0,0,1,0,66},{43,0,0,1,0,66},{44,0,0,1,0,66},{45,0,0,1,0,66},{46,0,0,1,0,66},{47,0,0,1,0,66},{48,0,0,1,0,66},{49,0,0,1,0,66},{50,0,0,1,0,66},{51,0,0,1,0,66},{52,0,0,1,0,66},{53,0,0,1,0,66},{54,0,0,1,0,66},{55,0,0,1,0,66},{56,1,0,1,0,66},{0,1,1,1,67,48},{0,1,1,1,67,49},{0,1,1,1,67,50},{0,1,1,1,67,97},{0,1,1,1,67,99},{0,1,1,1,67,101},{0,1,1,1,67,105},{0,1,1,1,67,111},{0,1,1,1,67,115},{0,1,1,1,67,116},{35,0,0,1,0,67},{36,0,0,1,0,67},{37,0,0,1,0,67},{38,0,0,1,0,67},{39,0,0,1,0,67},{40,0,0,1,0,67},{41,0,0,1,0,67},{42,0,0,1,0,67},{43,0,0,1,0,67},{44,0,0,1,0,67},{45,0,0,1,0,67},{46,0,0,1,0,67},{47,0,0,1,0,67},{48,0,0,1,0,67},{49,0,0,1,0,67},{50,0,0,1,0,67},{51,0,0,1,0,67},{52,0,0,1,0,67},{53,0,0,1,0,67},{54,0,0,1,0,67},{55,0,0,1,0,67},{56,1,0,1,0,67},{0,1,1,1,68,48},{0,1,1,1,68,49},{0,1,1,1,68,50},{0,1,1,1,68,97},{0,1,1,1,68,99},{0,1,1,1,68,101},{0,1,1,1,68,105},{0,1,1,1,68,111},{0,1,1,1,68,115},{0,1,1,1,68,116},{35,0,0,1,0,68},{36,0,0,1,0,68},{37,0,0,1,0,68},{38,0,0,1,0,68},{39,0,0,1,0,68},{40,0,0,1,0,68},{41,0,0,1,0,68},{42,0,0,1,0,68},{43,0,0,1,0,68},{44,0,0,1,0,68},{45,0,0,1,0,68},{46,0,0,1,0,68},{47,0,0,1,0,68},{48,0,0,1,0,68},{49,0,0,1,0,68},{50,0,0,1,0,68},{51,0,0,1,0,68},{52,0,0,1,0,68},{53,0,0,1,0,68},{54,0,0,1,0,68},{55,0,0,1,0,68},{56,1,0,1,0,68},{0,1,1,1,69,48},{0,1,1,1,69,49},{0,1,1,1,69,50},{0,1,1,1,69,97},{0,1,1,1,69,99},{0,1,1,1,69,101},{0,1,1,1,69,105},{0,1,1,1,69,111},{0,1,1,1,69,115},{0,1,1,1,69,116},{35,0,0,1,0,69},{36,0,0,1,0,69},{37,0,0,1,0,69},{38,0,0,1,0,69},{39,0,0,1,0,69},{40,0,0,1,0,69},{41,0,0,1,0,69},{42,0,0,1,0,69},{43,0,0,1,0,69},{44,0,0,1,0,69},{45,0,0,1,0,69},{46,0,0,1,0,69},{47,0,0,1,0,69},{48,0,0,1,0,69},{49,0,0,1,0,69},{50,0,0,1,0,69},{51,0,0,1,0,69},{52,0,0,1,0,69},{53,0,0,1,0,69},{54,0,0,1,0,69},{55,0,0,1,0,69},{56,1,0,1,0,69},{0,1,1,1,70,48},{0,1,1,1,70,49},{0,1,1,1,70,50},{0,1,1,1,70,97},{0,1,1,1,70,99},{0,1,1,1,70,101},{0,1,1,1,70,105},{0,1,1,1,70,111},{0,1,1,1,70,115},{0,1,1,1,70,116},{35,0,0,1,0,70},{36,0,0,1,0,70},{37,0,0,1,0,70},{38,0,0,1,0,70},{39,0,0,1,0,70},{40,0,0,1,0,70},{41,0,0,1,0,70},{42,0,0,1,0,70},{43,0,0,1,0,70},{44,0,0,1,0,70},{45,0,0,1,0,70},{46,0,0,1,0,70},{47,0,0,1,0,70},{48,0,0,1,0,70},{49,0,0,1,0,70},{50,0,0,1,0,70},{51,0,0,1,0,70},{52,0,0,1,0,70},{53,0,0,1,0,70},{54,0,0,1,0,70},{55,0,0,1,0,70},{56,1,0,1,0,70},{0,1,1,1,71,48},{0,1,1,1,71,49},{0,1,1,1,71,50},{0,1,1,1,71,97},{0,1,1,1,71,99},{0,1,1,1,71,101},{0,1,1,1,71,105},{0,1,1,1,71,111},{0,1,1,1,71,115},{0,1,1,1,71,116},{35,0,0,1,0,71},{36,0,0,1,0,71},{37,0,0,1,0,71},{38,0,0,1,0,71},{39,0,0,1,0,71},{40,0,0,1,0,71},{41,0,0,1,0,71},{42,0,0,1,0,71},{43,0,0,1,0,71},{44,0,0,1,0,71},{45,0,0,1,0,71},{46,0,0,1,0,71},{47,0,0,1,0,71},{48,0,0,1,0,71},{49,0,0,1,0,71},{50,0,0,1,0,71},{51,0,0,1,0,71},{52,0,0,1,0,71},{53,0,0,1,0,71},{54,0,0,1,0,71},{55,0,0,1,0,71},{56,1,0,1,0,71},{0,1,1,1,72,48},{0,1,1,1,72,49},{0,1,1,1,72,50},{0,1,1,1,72,97},{0,1,1,1,72,99},{0,1,1,1,72,101},{0,1,1,1,72,105},{0,1,1,1,72,111},{0,1,1,1,72,115},{0,1,1,1,72,116},{35,0,0,1,0,72},{36,0,0,1,0,72},{37,0,0,1,0,72},{38,0,0,1,0,72},{39,0,0,1,0,72},{40,0,0,1,0,72},{41,0,0,1,0,72},{42,0,0,1,0,72},{43,0,0,1,0,72},{44,0,0,1,0,72},{45,0,0,1,0,72},{46,0,0,1,0,72},{47,0,0,1,0,72},{48,0,0,1,0,72},{49,0,0,1,0,72},{50,0,0,1,0,72},{51,0,0,1,0,72},{52,0,0,1,0,72},{53,0,0,1,0,72},{54,0,0,1,0,72},{55,0,0,1,0,72},{56,1,0,1,0,72},{0,1,1,1,73,48},{0,1,1,1,73,49},{0,1,1,1,73,50},{0,1,1,1,73,97},{0,1,1,1,73,99},{0,1,1,1,73,101},{0,1,1,1,73,105},{0,1,1,1,73,111},{0,1,1,1,73,115},{0,1,1,1,73,116},{35,0,0,1,0,73},{36,0,0,1,0,73},{37,0,0,1,0,73},{38,0,0,1,0,73},{39,0,0,1,0,73},{40,0,0,1,0,73},{41,0,0,1,0,73},{42,0,0,1,0,73},{43,0,0,1,0,73},{44,0,0,1,0,73},{45,0,0,1,0,73},{46,0,0,1,0,73},{47,0,0,1,0,73},{48,0,0,1,0,73},{49,0,0,1,0,73},{50,0,0,1,0,73},{51,0,0,1,0,73},{52,0,0,1,0,73},{53,0,0,1,0,73},{54,0,0,1,0,73},{55,0,0,1,0,73},{56,1,0,1,0,73},{0,1,1,1,74,48},{0,1,1,1,74,49},{0,1,1,1,74,50},{0,1,1,1,74,97},{0,1,1,1,74,99},{0,1,1,1,74,101},{0,1,1,1,74,105},{0,1,1,1,74,111},{0,1,1,1,74,115},{0,1,1,1,74,116},{35,0,0,1,0,74},{36,0,0,1,0,74},{37,0,0,1,0,74},{38,0,0,1,0,74},{39,0,0,1,0,74},{40,0,0,1,0,74},{41,0,0,1,0,74},{42,0,0,1,0,74},{43,0,0,1,0,74},{44,0,0,1,0,74},{45,0,0,1,0,74},{46,0,0,1,0,74},{47,0,0,1,0,74},{48,0,0,1,0,74},{49,0,0,1,0,74},{50,0,0,1,0,74},{51,0,0,1,0,74},{52,0,0,1,0,74},{53,0,0,1,0,74},{54,0,0,1,0,74},{55,0,0,1,0,74},{56,1,0,1,0,74},{0,1,1,1,75,48},{0,1,1,1,75,49},{0,1,1,1,75,50},{0,1,1,1,75,97},{0,1,1,1,75,99},{0,1,1,1,75,101},{0,1,1,1,75,105},{0,1,1,1,75,111},{0,1,1,1,75,115},{0,1,1,1,75,116},{35,0,0,1,0,75},{36,0,0,1,0,75},{37,0,0,1,0,75},{38,0,0,1,0,75},{39,0,0,1,0,75},{40,0,0,1,0,75},{41,0,0,1,0,75},{42,0,0,1,0,75},{43,0,0,1,0,75},{44,0,0,1,0,75},{45,0,0,1,0,75},{46,0,0,1,0,75},{47,0,0,1,0,75},{48,0,0,1,0,75},{49,0,0,1,0,75},{50,0,0,1,0,75},{51,0,0,1,0,75},{52,0,0,1,0,75},{53,0,0,1,0,75},{54,0,0,1,0,75},{55,0,0,1,0,75},{56,1,0,1,0,75},{0,1,1,1,76,48},{0,1,1,1,76,49},{0,1,1,1,76,50},{0,1,1,1,76,97},{0,1,1,1,76,99},{0,1,1,1,76,101},{0,1,1,1,76,105},{0,1,1,1,76,111},{0,1,1,1,76,115},{0,1,1,1,76,116},{35,0,0,1,0,76},{36,0,0,1,0,76},{37,0,0,1,0,76},{38,0,0,1,0,76},{39,0,0,1,0,76},{40,0,0,1,0,76},{41,0,0,1,0,76},{42,0,0,1,0,76},{43,0,0,1,0,76},{44,0,0,1,0,76},{45,0,0,1,0,76},{46,0,0,1,0,76},{47,0,0,1,0,76},{48,0,0,1,0,76},{49,0,0,1,0,76},{50,0,0,1,0,76},{51,0,0,1,0,76},{52,0,0,1,0,76},{53,0,0,1,0,76},{54,0,0,1,0,76},{55,0,0,1,0,76},{56,1,0,1,0,76},{0,1,1,1,77,48},{0,1,1,1,77,49},{0,1,1,1,77,50},{0,1,1,1,77,97},{0,1,1,1,77,99},{0,1,1,1,77,101},{0,1,1,1,77,105},{0,1,1,1,77,111},{0,1,1,1,77,115},{0,1,1,1,77,116},{35,0,0,1,0,77},{36,0,0,1,0,77},{37,0,0,1,0,77},{38,0,0,1,0,77},{39,0,0,1,0,77},{40,0,0,1,0,77},{41,0,0,1,0,77},{42,0,0,1,0,77},{43,0,0,1,0,77},{44,0,0,1,0,77},{45,0,0,1,0,77},{46,0,0,1,0,77},{47,0,0,1,0,77},{48,0,0,1,0,77},{49,0,0,1,0,77},{50,0,0,1,0,77},{51,0,0,1,0,77},{52,0,0,1,0,77},{53,0,0,1,0,77},{54,0,0,1,0,77},{55,0,0,1,0,77},{56,1,0,1,0,77},{0,1,1,1,78,48},{0,1,1,1,78,49},{0,1,1,1,78,50},{0,1,1,1,78,97},{0,1,1,1,78,99},{0,1,1,1,78,101},{0,1,1,1,78,105},{0,1,1,1,78,111},{0,1,1,1,78,115},{0,1,1,1,78,116},{35,0,0,1,0,78},{36,0,0,1,0,78},{37,0,0,1,0,78},{38,0,0,1,0,78},{39,0,0,1,0,78},{40,0,0,1,0,78},{41,0,0,1,0,78},{42,0,0,1,0,78},{43,0,0,1,0,78},{44,0,0,1,0,78},{45,0,0,1,0,78},{46,0,0,1,0,78},{47,0,0,1,0,78},{48,0,0,1,0,78},{49,0,0,1,0,78},{50,0,0,1,0,78},{51,0,0,1,0,78},{52,0,0,1,0,78},{53,0,0,1,0,78},{54,0,0,1,0,78},{55,0,0,1,0,78},{56,1,0,1,0,78},{0,1,1,1,79,48},{0,1,1,1,79,49},{0,1,1,1,79,50},{0,1,1,1,79,97},{0,1,1,1,79,99},{0,1,1,1,79,101},{0,1,1,1,79,105},{0,1,1,1,79,111},{0,1,1,1,79,115},{0,1,1,1,79,116},{35,0,0,1,0,79},{36,0,0,1,0,79},{37,0,0,1,0,79},{38,0,0,1,0,79},{39,0,0,1,0,79},{40,0,0,1,0,79},{41,0,0,1,0,79},{42,0,0,1,0,79},{43,0,0,1,0,79},{44,0,0,1,0,79},{45,0,0,1,0,79},{46,0,0,1,0,79},{47,0,0,1,0,79},{48,0,0,1,0,79},{49,0,0,1,0,79},{50,0,0,1,0,79},{51,0,0,1,0,79},{52,0,0,1,0,79},{53,0,0,1,0,79},{54,0,0,1,0,79},{55,0,0,1,0,79},{56,1,0,1,0,79},{0,1,1,1,80,48},{0,1,1,1,80,49},{0,1,1,1,80,50},{0,1,1,1,80,97},{0,1,1,1,80,99},{0,1,1,1,80,101},{0,1,1,1,80,105},{0,1,1,1,80,111},{0,1,1,1,80,115},{0,1,1,1,80,116},{35,0,0,1,0,80},{36,0,0,1,0,80},{37,0,0,1,0,80},{38,0,0,1,0,80},{39,0,0,1,0,80},{40,0,0,1,0,80},{41,0,0,1,0,80},{42,0,0,1,0,80},{43,0,0,1,0,80},{44,0,0,1,0,80},{45,0,0,1,0,80},{46,0,0,1,0,80},{47,0,0,1,0,80},{48,0,0,1,0,80},{49,0,0,1,0,80},{50,0,0,1,0,80},{51,0,0,1,0,80},{52,0,0,1,0,80},{53,0,0,1,0,80},{54,0,0,1,0,80},{55,0,0,1,0,80},{56,1,0,1,0,80},{0,1,1,1,81,48},{0,1,1,1,81,49},{0,1,1,1,81,50},{0,1,1,1,81,97},{0,1,1,1,81,99},{0,1,1,1,81,101},{0,1,1,1,81,105},{0,1,1,1,81,111},{0,1,1,1,81,115},{0,1,1,1,81,116},{35,0,0,1,0,81},{36,0,0,1,0,81},{37,0,0,1,0,81},{38,0,0,1,0,81},{39,0,0,1,0,81},{40,0,0,1,0,81},{41,0,0,1,0,81},{42,0,0,1,0,81},{43,0,0,1,0,81},{44,0,0,1,0,81},{45,0,0,1,0,81},{46,0,0,1,0,81},{47,0,0,1,0,81},{48,0,0,1,0,81},{49,0,0,1,0,81},{50,0,0,1,0,81},{51,0,0,1,0,81},{52,0,0,1,0,81},{53,0,0,1,0,81},{54,0,0,1,0,81},{55,0,0,1,0,81},{56,1,0,1,0,81},{0,1,1,1,82,48},{0,1,1,1,82,49},{0,1,1,1,82,50},{0,1,1,1,82,97},{0,1,1,1,82,99},{0,1,1,1,82,101},{0,1,1,1,82,105},{0,1,1,1,82,111},{0,1,1,1,82,115},{0,1,1,1,82,116},{35,0,0,1,0,82},{36,0,0,1,0,82},{37,0,0,1,0,82},{38,0,0,1,0,82},{39,0,0,1,0,82},{40,0,0,1,0,82},{41,0,0,1,0,82},{42,0,0,1,0,82},{43,0,0,1,0,82},{44,0,0,1,0,82},{45,0,0,1,0,82},{46,0,0,1,0,82},{47,0,0,1,0,82},{48,0,0,1,0,82},{49,0,0,1,0,82},{50,0,0,1,0,82},{51,0,0,1,0,82},{52,0,0,1,0,82},{53,0,0,1,0,82},{54,0,0,1,0,82},{55,0,0,1,0,82},{56,1,0,1,0,82},{0,1,1,1,83,48},{0,1,1,1,83,49},{0,1,1,1,83,50},{0,1,1,1,83,97},{0,1,1,1,83,99},{0,1,1,1,83,101},{0,1,1,1,83,105},{0,1,1,1,83,111},{0,1,1,1,83,115},{0,1,1,1,83,116},{35,0,0,1,0,83},{36,0,0,1,0,83},{37,0,0,1,0,83},{38,0,0,1,0,83},{39,0,0,1,0,83},{40,0,0,1,0,83},{41,0,0,1,0,83},{42,0,0,1,0,83},{43,0,0,1,0,83},{44,0,0,1,0,83},{45,0,0,1,0,83},{46,0,0,1,0,83},{47,0,0,1,0,83},{48,0,0,1,0,83},{49,0,0,1,0,83},{50,0,0,1,0,83},{51,0,0,1,0,83},{52,0,0,1,0,83},{53,0,0,1,0,83},{54,0,0,1,0,83},{55,0,0,1,0,83},{56,1,0,1,0,83},{0,1,1,1,84,48},{0,1,1,1,84,49},{0,1,1,1,84,50},{0,1,1,1,84,97},{0,1,1,1,84,99},{0,1,1,1,84,101},{0,1,1,1,84,105},{0,1,1,1,84,111},{0,1,1,1,84,115},{0,1,1,1,84,116},{35,0,0,1,0,84},{36,0,0,1,0,84},{37,0,0,1,0,84},{38,0,0,1,0,84},{39,0,0,1,0,84},{40,0,0,1,0,84},{41,0,0,1,0,84},{42,0,0,1,0,84},{43,0,0,1,0,84},{44,0,0,1,0,84},{45,0,0,1,0,84},{46,0,0,1,0,84},{47,0,0,1,0,84},{48,0,0,1,0,84},{49,0,0,1,0,84},{50,0,0,1,0,84},{51,0,0,1,0,84},{52,0,0,1,0,84},{53,0,0,1,0,84},{54,0,0,1,0,84},{55,0,0,1,0,84},{56,1,0,1,0,84},{0,1,1,1,85,48},{0,1,1,1,85,49},{0,1,1,1,85,50},{0,1,1,1,85,97},{0,1,1,1,85,99},{0,1,1,1,85,101},{0,1,1,1,85,105},{0,1,1,1,85,111},{0,1,1,1,85,115},{0,1,1,1,85,116},{35,0,0,1,0,85},{36,0,0,1,0,85},{37,0,0,1,0,85},{38,0,0,1,0,85},{39,0,0,1,0,85},{40,0,0,1,0,85},{41,0,0,1,0,85},{42,0,0,1,0,85},{43,0,0,1,0,85},{44,0,0,1,0,85},{45,0,0,1,0,85},{46,0,0,1,0,85},{47,0,0,1,0,85},{48,0,0,1,0,85},{49,0,0,1,0,85},{50,0,0,1,0,85},{51,0,0,1,0,85},{52,0,0,1,0,85},{53,0,0,1,0,85},{54,0,0,1,0,85},{55,0,0,1,0,85},{56,1,0,1,0,85},{0,1,1,1,86,48},{0,1,1,1,86,49},{0,1,1,1,86,50},{0,1,1,1,86,97},{0,1,1,1,86,99},{0,1,1,1,86,101},{0,1,1,1,86,105},{0,1,1,1,86,111},{0,1,1,1,86,115},{0,1,1,1,86,116},{35,0,0,1,0,86},{36,0,0,1,0,86},{37,0,0,1,0,86},{38,0,0,1,0,86},{39,0,0,1,0,86},{40,0,0,1,0,86},{41,0,0,1,0,86},{42,0,0,1,0,86},{43,0,0,1,0,86},{44,0,0,1,0,86},{45,0,0,1,0,86},{46,0,0,1,0,86},{47,0,0,1,0,86},{48,0,0,1,0,86},{49,0,0,1,0,86},{50,0,0,1,0,86},{51,0,0,1,0,86},{52,0,0,1,0,86},{53,0,0,1,0,86},{54,0,0,1,0,86},{55,0,0,1,0,86},{56,1,0,1,0,86},{0,1,1,1,87,48},{0,1,1,1,87,49},{0,1,1,1,87,50},{0,1,1,1,87,97},{0,1,1,1,87,99},{0,1,1,1,87,101},{0,1,1,1,87,105},{0,1,1,1,87,111},{0,1,1,1,87,115},{0,1,1,1,87,116},{35,0,0,1,0,87},{36,0,0,1,0,87},{37,0,0,1,0,87},{38,0,0,1,0,87},{39,0,0,1,0,87},{40,0,0,1,0,87},{41,0,0,1,0,87},{42,0,0,1,0,87},{43,0,0,1,0,87},{44,0,0,1,0,87},{45,0,0,1,0,87},{46,0,0,1,0,87},{47,0,0,1,0,87},{48,0,0,1,0,87},{49,0,0,1,0,87},{50,0,0,1,0,87},{51,0,0,1,0,87},{52,0,0,1,0,87},{53,0,0,1,0,87},{54,0,0,1,0,87},{55,0,0,1,0,87},{56,1,0,1,0,87},{0,1,1,1,89,48},{0,1,1,1,89,49},{0,1,1,1,89,50},{0,1,1,1,89,97},{0,1,1,1,89,99},{0,1,1,1,89,101},{0,1,1,1,89,105},{0,1,1,1,89,111},{0,1,1,1,89,115},{0,1,1,1,89,116},{35,0,0,1,0,89},{36,0,0,1,0,89},{37,0,0,1,0,89},{38,0,0,1,0,89},{39,0,0,1,0,89},{40,0,0,1,0,89},{41,0,0,1,0,89},{42,0,0,1,0,89},{43,0,0,1,0,89},{44,0,0,1,0,89},{45,0,0,1,0,89},{46,0,0,1,0,89},{47,0,0,1,0,89},{48,0,0,1,0,89},{49,0,0,1,0,89},{50,0,0,1,0,89},{51,0,0,1,0,89},{52,0,0,1,0,89},{53,0,0,1,0,89},{54,0,0,1,0,89},{55,0,0,1,0,89},{56,1,0,1,0,89},{0,1,1,1,106,48},{0,1,1,1,106,49},{0,1,1,1,106,50},{0,1,1,1,106,97},{0,1,1,1,106,99},{0,1,1,1,106,101},{0,1,1,1,106,105},{0,1,1,1,106,111},{0,1,1,1,106,115},{0,1,1,1,106,116},{35,0,0,1,0,106},{36,0,0,1,0,106},{37,0,0,1,0,106},{38,0,0,1,0,106},{39,0,0,1,0,106},{40,0,0,1,0,106},{41,0,0,1,0,106},{42,0,0,1,0,106},{43,0,0,1,0,106},{44,0,0,1,0,106},{45,0,0,1,0,106},{46,0,0,1,0,106},{47,0,0,1,0,106},{48,0,0,1,0,106},{49,0,0,1,0,106},{50,0,0,1,0,106},{51,0,0,1,0,106},{52,0,0,1,0,106},{53,0,0,1,0,106},{54,0,0,1,0,106},{55,0,0,1,0,106},{56,1,0,1,0,106},{0,1,1,1,107,48},{0,1,1,1,107,49},{0,1,1,1,107,50},{0,1,1,1,107,97},{0,1,1,1,107,99},{0,1,1,1,107,101},{0,1,1,1,107,105},{0,1,1,1,107,111},{0,1,1,1,107,115},{0,1,1,1,107,116},{35,0,0,1,0,107},{36,0,0,1,0,107},{37,0,0,1,0,107},{38,0,0,1,0,107},{39,0,0,1,0,107},{40,0,0,1,0,107},{41,0,0,1,0,107},{42,0,0,1,0,107},{43,0,0,1,0,107},{44,0,0,1,0,107},{45,0,0,1,0,107},{46,0,0,1,0,107},{47,0,0,1,0,107},{48,0,0,1,0,107},{49,0,0,1,0,107},{50,0,0,1,0,107},{51,0,0,1,0,107},{52,0,0,1,0,107},{53,0,0,1,0,107},{54,0,0,1,0,107},{55,0,0,1,0,107},{56,1,0,1,0,107},{0,1,1,1,113,48},{0,1,1,1,113,49},{0,1,1,1,113,50},{0,1,1,1,113,97},{0,1,1,1,113,99},{0,1,1,1,113,101},{0,1,1,1,113,105},{0,1,1,1,113,111},{0,1,1,1,113,115},{0,1,1,1,113,116},{35,0,0,1,0,113},{36,0,0,1,0,113},{37,0,0,1,0,113},{38,0,0,1,0,113},{39,0,0,1,0,113},{40,0,0,1,0,113},{41,0,0,1,0,113},{42,0,0,1,0,113},{43,0,0,1,0,113},{44,0,0,1,0,113},{45,0,0,1,0,113},{46,0,0,1,0,113},{47,0,0,1,0,113},{48,0,0,1,0,113},{49,0,0,1,0,113},{50,0,0,1,0,113},{51,0,0,1,0,113},{52,0,0,1,0,113},{53,0,0,1,0,113},{54,0,0,1,0,113},{55,0,0,1,0,113},{56,1,0,1,0,113},{0,1,1,1,118,48},{0,1,1,1,118,49},{0,1,1,1,118,50},{0,1,1,1,118,97},{0,1,1,1,118,99},{0,1,1,1,118,101},{0,1,1,1,118,105},{0,1,1,1,118,111},{0,1,1,1,118,115},{0,1,1,1,118,116},{35,0,0,1,0,118},{36,0,0,1,0,118},{37,0,0,1,0,118},{38,0,0,1,0,118},{39,0,0,1,0,118},{40,0,0,1,0,118},{41,0,0,1,0,118},{42,0,0,1,0,118},{43,0,0,1,0,118},{44,0,0,1,0,118},{45,0,0,1,0,118},{46,0,0,1,0,118},{47,0,0,1,0,118},{48,0,0,1,0,118},{49,0,0,1,0,118},{50,0,0,1,0,118},{51,0,0,1,0,118},{52,0,0,1,0,118},{53,0,0,1,0,118},{54,0,0,1,0,118},{55,0,0,1,0,118},{56,1,0,1,0,118},{0,1,1,1,119,48},{0,1,1,1,119,49},{0,1,1,1,119,50},{0,1,1,1,119,97},{0,1,1,1,119,99},{0,1,1,1,119,101},{0,1,1,1,119,105},{0,1,1,1,119,111},{0,1,1,1,119,115},{0,1,1,1,119,116},{35,0,0,1,0,119},{36,0,0,1,0,119},{37,0,0,1,0,119},{38,0,0,1,0,119},{39,0,0,1,0,119},{40,0,0,1,0,119},{41,0,0,1,0,119},{42,0,0,1,0,119},{43,0,0,1,0,119},{44,0,0,1,0,119},{45,0,0,1,0,119},{46,0,0,1,0,119},{47,0,0,1,0,119},{48,0,0,1,0,119},{49,0,0,1,0,119},{50,0,0,1,0,119},{51,0,0,1,0,119},{52,0,0,1,0,119},{53,0,0,1,0,119},{54,0,0,1,0,119},{55,0,0,1,0,119},{56,1,0,1,0,119},{0,1,1,1,120,48},{0,1,1,1,120,49},{0,1,1,1,120,50},{0,1,1,1,120,97},{0,1,1,1,120,99},{0,1,1,1,120,101},{0,1,1,1,120,105},{0,1,1,1,120,111},{0,1,1,1,120,115},{0,1,1,1,120,116},{35,0,0,1,0,120},{36,0,0,1,0,120},{37,0,0,1,0,120},{38,0,0,1,0,120},{39,0,0,1,0,120},{40,0,0,1,0,120},{41,0,0,1,0,120},{42,0,0,1,0,120},{43,0,0,1,0,120},{44,0,0,1,0,120},{45,0,0,1,0,120},{46,0,0,1,0,120},{47,0,0,1,0,120},{48,0,0,1,0,120},{49,0,0,1,0,120},{50,0,0,1,0,120},{51,0,0,1,0,120},{52,0,0,1,0,120},{53,0,0,1,0,120},{54,0,0,1,0,120},{55,0,0,1,0,120},{56,1,0,1,0,120},{0,1,1,1,121,48},{0,1,1,1,121,49},{0,1,1,1,121,50},{0,1,1,1,121,97},{0,1,1,1,121,99},{0,1,1,1,121,101},{0,1,1,1,121,105},{0,1,1,1,121,111},{0,1,1,1,121,115},{0,1,1,1,121,116},{35,0,0,1,0,121},{36,0,0,1,0,121},{37,0,0,1,0,121},{38,0,0,1,0,121},{39,0,0,1,0,121},{40,0,0,1,0,121},{41,0,0,1,0,121},{42,0,0,1,0,121},{43,0,0,1,0,121},{44,0,0,1,0,121},{45,0,0,1,0,121},{46,0,0,1,0,121},{47,0,0,1,0,121},{48,0,0,1,0,121},{49,0,0,1,0,121},{50,0,0,1,0,121},{51,0,0,1,0,121},{52,0,0,1,0,121},{53,0,0,1,0,121},{54,0,0,1,0,121},{55,0,0,1,0,121},{56,1,0,1,0,121},{0,1,1,1,122,48},{0,1,1,1,122,49},{0,1,1,1,122,50},{0,1,1,1,122,97},{0,1,1,1,122,99},{0,1,1,1,122,101},{0,1,1,1,122,105},{0,1,1,1,122,111},{0,1,1,1,122,115},{0,1,1,1,122,116},{35,0,0,1,0,122},{36,0,0,1,0,122},{37,0,0,1,0,122},{38,0,0,1,0,122},{39,0,0,1,0,122},{40,0,0,1,0,122},{41,0,0,1,0,122},{42,0,0,1,0,122},{43,0,0,1,0,122},{44,0,0,1,0,122},{45,0,0,1,0,122},{46,0,0,1,0,122},{47,0,0,1,0,122},{48,0,0,1,0,122},{49,0,0,1,0,122},{50,0,0,1,0,122},{51,0,0,1,0,122},{52,0,0,1,0,122},{53,0,0,1,0,122},{54,0,0,1,0,122},{55,0,0,1,0,122},{56,1,0,1,0,122},{57,0,0,1,0,38},{58,0,0,1,0,38},{59,0,0,1,0,38},{60,0,0,1,0,38},{61,0,0,1,0,38},{62,0,0,1,0,38},{63,0,0,1,0,38},{64,0,0,1,0,38},{65,0,0,1,0,38},{66,0,0,1,0,38},{67,0,0,1,0,38},{68,0,0,1,0,38},{69,0,0,1,0,38},{70,0,0,1,0,38},{71,0,0,1,0,38},{72,1,0,1,0,38},{57,0,0,1,0,42},{58,0,0,1,0,42},{59,0,0,1,0,42},{60,0,0,1,0,42},{61,0,0,1,0,42},{62,0,0,1,0,42},{63,0,0,1,0,42},{64,0,0,1,0,42},{65,0,0,1,0,42},{66,0,0,1,0,42},{67,0,0,1,0,42},{68,0,0,1,0,42},{69,0,0,1,0,42},{70,0,0,1,0,42},{71,0,0,1,0,42},{72,1,0,1,0,42},{57,0,0,1,0,44},{58,0,0,1,0,44},{59,0,0,1,0,44},{60,0,0,1,0,44},{61,0,0,1,0,44},{62,0,0,1,0,44},{63,0,0,1,0,44},{64,0,0,1,0,44},{65,0,0,1,0,44},{66,0,0,1,0,44},{67,0,0,1,0,44},{68,0,0,1,0,44},{69,0,0,1,0,44},{70,0,0,1,0,44},{71,0,0,1,0,44},{72,1,0,1,0,44},{57,0,0,1,0,59},{58,0,0,1,0,59},{59,0,0,1,0,59},{60,0,0,1,0,59},{61,0,0,1,0,59},{62,0,0,1,0,59},{63,0,0,1,0,59},{64,0,0,1,0,59},{65,0,0,1,0,59},{66,0,0,1,0,59},{67,0,0,1,0,59},{68,0,0,1,0,59},{69,0,0,1,0,59},{70,0,0,1,0,59},{71,0,0,1,0,59},{72,1,0,1,0,59},{57,0,0,1,0,88},{58,0,0,1,0,88},{59,0,0,1,0,88},{60,0,0,1,0,88},{61,0,0,1,0,88},{62,0,0,1,0,88},{63,0,0,1,0,88},{64,0,0,1,0,88},{65,0,0,1,0,88},{66,0,0,1,0,88},{67,0,0,1,0,88},{68,0,0,1,0,88},{69,0,0,1,0,88},{70,0,0,1,0,88},{71,0,0,1,0,88},{72,1,0,1,0,88},{57,0,0,1,0,90},{58,0,0,1,0,90},{59,0,0,1,0,90},{60,0,0,1,0,90},{61,0,0,1,0,90},{62,0,0,1,0,90},{63,0,0,1,0,90},{64,0,0,1,0,90},{65,0,0,1,0,90},{66,0,0,1,0,90},{67,0,0,1,0,90},{68,0,0,1,0,90},{69,0,0,1,0,90},{70,0,0,1,0,90},{71,0,0,1,0,90},{72,1,0,1,0,90},{9,0,0,1,0,33},{10,0,0,1,0,33},{11,0,0,1,0,33},{12,1,0,1,0,33},{9,0,0,1,0,34},{10,0,0,1,0,34},{11,0,0,1,0,34},{12,1,0,1,0,34},{9,0,0,1,0,40},{10,0,0,1,0,40},{11,0,0,1,0,40},{12,1,0,1,0,40},{9,0,0,1,0,41},{10,0,0,1,0,41},{11,0,0,1,0,41},{12,1,0,1,0,41},{9,0,0,1,0,63},{10,0,0,1,0,63},{11,0,0,1,0,63},{12,1,0,1,0,63},{13,0,0,1,0,39},{14,1,0,1,0,39},{13,0,0,1,0,43},{14,1,0,1,0,43},{13,0,0,1,0,124},{14,1,0,1,0,124},{0,1,0,1,0,35},{0,1,0,1,0,62},{93,0,0,0,0,0},{94,0,0,0,0,0},{95,0,0,0,0,0},{96,0,0,0,0,0},{9,0,1,1,35,48},{10,0,1,1,35,48},{11,0,1,1,35,48},{12,1,1,1,35,48},{9,0,1,1,35,49},{10,0,1,1,35,49},{11,0,1,1,35,49},{12,1,1,1,35,49},{9,0,1,1,35,50},{10,0,1,1,35,50},{11,0,1,1,35,50},{12,1,1,1,35,50},{9,0,1,1,35,97},{10,0,1,1,35,97},{11,0,1,1,35,97},{12,1,1,1,35,97},{9,0,1,1,35,99},{10,0,1,1,35,99},{11,0,1,1,35,99},{12,1,1,1,35,99},{9,0,1,1,35,101},{10,0,1,1,35,101},{11,0,1,1,35,101},{12,1,1,1,35,101},{9,0,1,1,35,105},{10,0,1,1,35,105},{11,0,1,1,35,105},{12,1,1,1,35,105},{9,0,1,1,35,111},{10,0,1,1,35,111},{11,0,1,1,35,111},{12,1,1,1,35,111},{9,0,1,1,35,115},{10,0,1,1,35,115},{11,0,1,1,35,115},{12,1,1,1,35,115},{9,0,1,1,35,116},{10,0,1,1,35,116},{11,0,1,1,35,116},{12,1,1,1,35,116},{13,0,1,1,35,32},{14,1,1,1,35,32},{13,0,1,1,35,37},{14,1,1,1,35,37},{13,0,1,1,35,45},{14,1,1,1,35,45},{13,0,1,1,35,46},{14,1,1,1,35,46},{13,0,1,1,35,47},{14,1,1,1,35,47},{13,0,1,1,35,51},{14,1,1,1,35,51},{13,0,1,1,35,52},{14,1,1,1,35,52},{13,0,1,1,35,53},{14,1,1,1,35,53},{13,0,1,1,35,54},{14,1,1,1,35,54},{13,0,1,1,35,55},{14,1,1,1,35,55},{13,0,1,1,35,56},{14,1,1,1,35,56},{13,0,1,1,35,57},{14,1,1,1,35,57},{13,0,1,1,35,61},{14,1,1,1,35,61},{13,0,1,1,35,65},{14,1,1,1,35,65},{13,0,1,1,35,95},{14,1,1,1,35,95},{13,0,1,1,35,98},{14,1,1,1,35,98},{13,0,1,1,35,100},{14,1,1,1,35,100},{13,0,1,1,35,102},{14,1,1,1,35,102},{13,0,1,1,35,103},{14,1,1,1,35,103},{13,0,1,1,35,104},{14,1,1,1,35,104},{13,0,1,1,35,108},{14,1,1,1,35,108},{13,0,1,1,35,109},{14,1,1,1,35,109},{13,0,1,1,35,110},{14,1,1,1,35,110},{13,0,1,1,35,112},{14,1,1,1,35,112},{13,0,1,1,35,114},{14,1,1,1,35,114},{13,0,1,1,35,117},{14,1,1,1,35,117},{0,1,1,1,35,58},{0,1,1,1,35,66},{0,1,1,1,35,67},{0,1,1,1,35,68},{0,1,1,1,35,69},{0,1,1,1,35,70},{0,1,1,1,35,71},{0,1,1,1,35,72},{0,1,1,1,35,73},{0,1,1,1,35,74},{0,1,1,1,35,75},{0,1,1,1,35,76},{0,1,1,1,35,77},{0,1,1,1,35,78},{0,1,1,1,35,79},{0,1,1,1,35,80},{0,1,1,1,35,81},{0,1,1,1,35,82},{0,1,1,1,35,83},{0,1,1,1,35,84},{0,1,1,1,35,85},{0,1,1,1,35,86},{0,1,1,1,35,87},{0,1,1,1,35,89},{0,1,1,1,35,106},{0,1,1,1,35,107},{0,1,1,1,35,113},{0,1,1,1,35,118},{0,1,1,1,35,119},{0,1,1,1,35,120},{0,1,1,1,35,121},{0,1,1,1,35,122},{85,0,0,1,0,35},{86,0,0,1,0,35},{87,0,0,1,0,35},{88,1,0,1,0,35},{9,0,1,1,62,48},{10,0,1,1,62,48},{11,0,1,1,62,48},{12,1,1,1,62,48},{9,0,1,1,62,49},{10,0,1,1,62,49},{11,0,1,1,62,49},{12,1,1,1,62,49},{9,0,1,1,62,50},{10,0,1,1,62,50},{11,0,1,1,62,50},{12,1,1,1,62,50},{9,0,1,1,62,97},{10,0,1,1,62,97},{11,0,1,1,62,97},{12,1,1,1,62,97},{9,0,1,1,62,99},{10,0,1,1,62,99},{11,0,1,1,62,99},{12,1,1,1,62,99},{9,0,1,1,62,101},{10,0,1,1,62,101},{11,0,1,1,62,101},{12,1,1,1,62,101},{9,0,1,1,62,105},{10,0,1,1,62,105},{11,0,1,1,62,105},{12,1,1,1,62,105},{9,0,1,1,62,111},{10,0,1,1,62,111},{11,0,1,1,62,111},{12,1,1,1,62,111},{9,0,1,1,62,115},{10,0,1,1,62,115},{11,0,1,1,62,115},{12,1,1,1,62,115},{9,0,1,1,62,116},{10,0,1,1,62,116},{11,0,1,1,62,116},{12,1,1,1,62,116},{13,0,1,1,62,32},{14,1,1,1,62,32},{13,0,1,1,62,37},{14,1,1,1,62,37},{13,0,1,1,62,45},{14,1,1,1,62,45},{13,0,1,1,62,46},{14,1,1,1,62,46},{13,0,1,1,62,47},{14,1,1,1,62,47},{13,0,1,1,62,51},{14,1,1,1,62,51},{13,0,1,1,62,52},{14,1,1,1,62,52},{13,0,1,1,62,53},{14,1,1,1,62,53},{13,0,1,1,62,54},{14,1,1,1,62,54},{13,0,1,1,62,55},{14,1,1,1,62,55},{13,0,1,1,62,56},{14,1,1,1,62,56},{13,0,1,1,62,57},{14,1,1,1,62,57},{13,0,1,1,62,61},{14,1,1,1,62,61},{13,0,1,1,62,65},{14,1,1,1,62,65},{13,0,1,1,62,95},{14,1,1,1,62,95},{13,0,1,1,62,98},{14,1,1,1,62,98},{13,0,1,1,62,100},{14,1,1,1,62,100},{13,0,1,1,62,102},{14,1,1,1,62,102},{13,0,1,1,62,103},{14,1,1,1,62,103},{13,0,1,1,62,104},{14,1,1,1,62,104},{13,0,1,1,62,108},{14,1,1,1,62,108},{13,0,1,1,62,109},{14,1,1,1,62,109},{13,0,1,1,62,110},{14,1,1,1,62,110},{13,0,1,1,62,112},{14,1,1,1,62,112},{13,0,1,1,62,114},{14,1,1,1,62,114},{13,0,1,1,62,117},{14,1,1,1,62,117},{0,1,1,1,62,58},{0,1,1,1,62,66},{0,1,1,1,62,67},{0,1,1,1,62,68},{0,1,1,1,62,69},{0,1,1,1,62,70},{0,1,1,1,62,71},{0,1,1,1,62,72},{0,1,1,1,62,73},{0,1,1,1,62,74},{0,1,1,1,62,75},{0,1,1,1,62,76},{0,1,1,1,62,77},{0,1,1,1,62,78},{0,1,1,1,62,79},{0,1,1,1,62,80},{0,1,1,1,62,81},{0,1,1,1,62,82},{0,1,1,1,62,83},{0,1,1,1,62,84},{0,1,1,1,62,85},{0,1,1,1,62,86},{0,1,1,1,62,87},{0,1,1,1,62,89},{0,1,1,1,62,106},{0,1,1,1,62,107},{0,1,1,1,62,113},{0,1,1,1,62,118},{0,1,1,1,62,119},{0,1,1,1,62,120},{0,1,1,1,62,121},{0,1,1,1,62,122},{85,0,0,1,0,62},{86,0,0,1,0,62},{87,0,0,1,0,62},{88,1,0,1,0,62},{13,0,1,1,0,48},{14,1,1,1,0,48},{13,0,1,1,0,49},{14,1,1,1,0,49},{13,0,1,1,0,50},{14,1,1,1,0,50},{13,0,1,1,0,97},{14,1,1,1,0,97},{13,0,1,1,0,99},{14,1,1,1,0,99},{13,0,1,1,0,101},{14,1,1,1,0,101},{13,0,1,1,0,105},{14,1,1,1,0,105},{13,0,1,1,0,111},{14,1,1,1,0,111},{13,0,1,1,0,115},{14,1,1,1,0,115},{13,0,1,1,0,116},{14,1,1,1,0,116},{0,1,1,1,0,32},{0,1,1,1,0,37},{0,1,1,1,0,45},{0,1,1,1,0,46},{0,1,1,1,0,47},{0,1,1,1,0,51},{0,1,1,1,0,52},{0,1,1,1,0,53},{0,1,1,1,0,54},{0,1,1,1,0,55},{0,1,1,1,0,56},{0,1,1,1,0,57},{0,1,1,1,0,61},{0,1,1,1,0,65},{0,1,1,1,0,95},{0,1,1,1,0,98},{0,1,1,1,0,100},{0,1,1,1,0,102},{0,1,1,1,0,103},{0,1,1,1,0,104},{0,1,1,1,0,108},{0,1,1,1,0,109},{0,1,1,1,0,110},{0,1,1,1,0,112},{0,1,1,1,0,114},{0,1,1,1,0,117},{17,0,0,1,0,0},{18,0,0,1,0,0},{19,0,0,1,0,0},{20,0,0,1,0,0},{21,0,0,1,0,0},{22,0,0,1,0,0},{23,0,0,1,0,0},{24,0,0,1,0,0},{25,0,0,1,0,0},{26,0,0,1,0,0},{27,0,0,1,0,0},{28,0,0,1,0,0},{29,0,0,1,0,0},{30,0,0,1,0,0},{31,0,0,1,0,0},{32,0,0,1,0,0},{33,0,0,1,0,0},{34,1,0,1,0,0},{13,0,1,1,36,48},{14,1,1,1,36,48},{13,0,1,1,36,49},{14,1,1,1,36,49},{13,0,1,1,36,50},{14,1,1,1,36,50},{13,0,1,1,36,97},{14,1,1,1,36,97},{13,0,1,1,36,99},{14,1,1,1,36,99},{13,0,1,1,36,101},{14,1,1,1,36,101},{13,0,1,1,36,105},{14,1,1,1,36,105},{13,0,1,1,36,111},{14,1,1,1,36,111},{13,0,1,1,36,115},{14,1,1,1,36,115},{13,0,1,1,36,116},{14,1,1,1,36,116},{0,1,1,1,36,32},{0,1,1,1,36,37},{0,1,1,1,36,45},{0,1,1,1,36,46},{0,1,1,1,36,47},{0,1,1,1,36,51},{0,1,1,1,36,52},{0,1,1,1,36,53},{0,1,1,1,36,54},{0,1,1,1,36,55},{0,1,1,1,36,56},{0,1,1,1,36,57},{0,1,1,1,36,61},{0,1,1,1,36,65},{0,1,1,1,36,95},{0,1,1,1,36,98},{0,1,1,1,36,100},{0,1,1,1,36,102},{0,1,1,1,36,103},{0,1,1,1,36,104},{0,1,1,1,36,108},{0,1,1,1,36,109},{0,1,1,1,36,110},{0,1,1,1,36,112},{0,1,1,1,36,114},{0,1,1,1,36,117},{17,0,0,1,0,36},{18,0,0,1,0,36},{19,0,0,1,0,36},{20,0,0,1,0,36},{21,0,0,1,0,36},{22,0,0,1,0,36},{23,0,0,1,0,36},{24,0,0,1,0,36},{25,0,0,1,0,36},{26,0,0,1,0,36},{27,0,0,1,0,36},{28,0,0,1,0,36},{29,0,0,1,0,36},{30,0,0,1,0,36},{31,0,0,1,0,36},{32,0,0,1,0,36},{33,0,0,1,0,36},{34,1,0,1,0,36},{13,0,1,1,64,48},{14,1,1,1,64,48},{13,0,1,1,64,49},{14,1,1,1,64,49},{13,0,1,1,64,50},{14,1,1,1,64,50},{13,0,1,1,64,97},{14,1,1,1,64,97},{13,0,1,1,64,99},{14,1,1,1,64,99},{13,0,1,1,64,101},{14,1,1,1,64,101},{13,0,1,1,64,105},{14,1,1,1,64,105},{13,0,1,1,64,111},{14,1,1,1,64,111},{13,0,1,1,64,115},{14,1,1,1,64,115},{13,0,1,1,64,116},{14,1,1,1,64,116},{0,1,1,1,64,32},{0,1,1,1,64,37},{0,1,1,1,64,45},{0,1,1,1,64,46},{0,1,1,1,64,47},{0,1,1,1,64,51},{0,1,1,1,64,52},{0,1,1,1,64,53},{0,1,1,1,64,54},{0,1,1,1,64,55},{0,1,1,1,64,56},{0,1,1,1,64,57},{0,1,1,1,64,61},{0,1,1,1,64,65},{0,1,1,1,64,95},{0,1,1,1,64,98},{0,1,1,1,64,100},{0,1,1,1,64,102},{0,1,1,1,64,103},{0,1,1,1,64,104},{0,1,1,1,64,108},{0,1,1,1,64,109},{0,1,1,1,64,110},{0,1,1,1,64,112},{0,1,1,1,64,114},{0,1,1,1,64,117},{17,0,0,1,0,64},{18,0,0,1,0,64},{19,0,0,1,0,64},{20,0,0,1,0,64},{21,0,0,1,0,64},{22,0,0,1,0,64},{23,0,0,1,0,64},{24,0,0,1,0,64},{25,0,0,1,0,64},{26,0,0,1,0,64},{27,0,0,1,0,64},{28,0,0,1,0,64},{29,0,0,1,0,64},{30,0,0,1,0,64},{31,0,0,1,0,64},{32,0,0,1,0,64},{33,0,0,1,0,64},{34,1,0,1,0,64},{13,0,1,1,91,48},{14,1,1,1,91,48},{13,0,1,1,91,49},{14,1,1,1,91,49},{13,0,1,1,91,50},{14,1,1,1,91,50},{13,0,1,1,91,97},{14,1,1,1,91,97},{13,0,1,1,91,99},{14,1,1,1,91,99},{13,0,1,1,91,101},{14,1,1,1,91,101},{13,0,1,1,91,105},{14,1,1,1,91,105},{13,0,1,1,91,111},{14,1,1,1,91,111},{13,0,1,1,91,115},{14,1,1,1,91,115},{13,0,1,1,91,116},{14,1,1,1,91,116},{0,1,1,1,91,32},{0,1,1,1,91,37},{0,1,1,1,91,45},{0,1,1,1,91,46},{0,1,1,1,91,47},{0,1,1,1,91,51},{0,1,1,1,91,52},{0,1,1,1,91,53},{0,1,1,1,91,54},{0,1,1,1,91,55},{0,1,1,1,91,56},{0,1,1,1,91,57},{0,1,1,1,91,61},{0,1,1,1,91,65},{0,1,1,1,91,95},{0,1,1,1,91,98},{0,1,1,1,91,100},{0,1,1,1,91,102},{0,1,1,1,91,103},{0,1,1,1,91,104},{0,1,1,1,91,108},{0,1,1,1,91,109},{0,1,1,1,91,110},{0,1,1,1,91,112},{0,1,1,1,91,114},{0,1,1,1,91,117},{17,0,0,1,0,91},{18,0,0,1,0,91},{19,0,0,1,0,91},{20,0,0,1,0,91},{21,0,0,1,0,91},{22,0,0,1,0,91},{23,0,0,1,0,91},{24,0,0,1,0,91},{25,0,0,1,0,91},{26,0,0,1,0,91},{27,0,0,1,0,91},{28,0,0,1,0,91},{29,0,0,1,0,91},{30,0,0,1,0,91},{31,0,0,1,0,91},{32,0,0,1,0,91},{33,0,0,1,0,91},{34,1,0,1,0,91},{13,0,1,1,93,48},{14,1,1,1,93,48},{13,0,1,1,93,49},{14,1,1,1,93,49},{13,0,1,1,93,50},{14,1,1,1,93,50},{13,0,1,1,93,97},{14,1,1,1,93,97},{13,0,1,1,93,99},{14,1,1,1,93,99},{13,0,1,1,93,101},{14,1,1,1,93,101},{13,0,1,1,93,105},{14,1,1,1,93,105},{13,0,1,1,93,111},{14,1,1,1,93,111},{13,0,1,1,93,115},{14,1,1,1,93,115},{13,0,1,1,93,116},{14,1,1,1,93,116},{0,1,1,1,93,32},{0,1,1,1,93,37},{0,1,1,1,93,45},{0,1,1,1,93,46},{0,1,1,1,93,47},{0,1,1,1,93,51},{0,1,1,1,93,52},{0,1,1,1,93,53},{0,1,1,1,93,54},{0,1,1,1,93,55},{0,1,1,1,93,56},{0,1,1,1,93,57},{0,1,1,1,93,61},{0,1,1,1,93,65},{0,1,1,1,93,95},{0,1,1,1,93,98},{0,1,1,1,93,100},{0,1,1,1,93,102},{0,1,1,1,93,103},{0,1,1,1,93,104},{0,1,1,1,93,108},{0,1,1,1,93,109},{0,1,1,1,93,110},{0,1,1,1,93,112},{0,1,1,1,93,114},{0,1,1,1,93,117},{17,0,0,1,0,93},{18,0,0,1,0,93},{19,0,0,1,0,93},{20,0,0,1,0,93},{21,0,0,1,0,93},{22,0,0,1,0,93},{23,0,0,1,0,93},{24,0,0,1,0,93},{25,0,0,1,0,93},{26,0,0,1,0,93},{27,0,0,1,0,93},{28,0,0,1,0,93},{29,0,0,1,0,93},{30,0,0,1,0,93},{31,0,0,1,0,93},{32,0,0,1,0,93},{33,0,0,1,0,93},{34,1,0,1,0,93},{13,0,1,1,126,48},{14,1,1,1,126,48},{13,0,1,1,126,49},{14,1,1,1,126,49},{13,0,1,1,126,50},{14,1,1,1,126,50},{13,0,1,1,126,97},{14,1,1,1,126,97},{13,0,1,1,126,99},{14,1,1,1,126,99},{13,0,1,1,126,101},{14,1,1,1,126,101},{13,0,1,1,126,105},{14,1,1,1,126,105},{13,0,1,1,126,111},{14,1,1,1,126,111},{13,0,1,1,126,115},{14,1,1,1,126,115},{13,0,1,1,126,116},{14,1,1,1,126,116},{0,1,1,1,126,32},{0,1,1,1,126,37},{0,1,1,1,126,45},{0,1,1,1,126,46},{0,1,1,1,126,47},{0,1,1,1,126,51},{0,1,1,1,126,52},{0,1,1,1,126,53},{0,1,1,1,126,54},{0,1,1,1,126,55},{0,1,1,1,126,56},{0,1,1,1,126,57},{0,1,1,1,126,61},{0,1,1,1,126,65},{0,1,1,1,126,95},{0,1,1,1,126,98},{0,1,1,1,126,100},{0,1,1,1,126,102},{0,1,1,1,126,103},{0,1,1,1,126,104},{0,1,1,1,126,108},{0,1,1,1,126,109},{0,1,1,1,126,110},{0,1,1,1,126,112},{0,1,1,1,126,114},{0,1,1,1,126,117},{17,0,0,1,0,126},{18,0,0,1,0,126},{19,0,0,1,0,126},{20,0,0,1,0,126},{21,0,0,1,0,126},{22,0,0,1,0,126},{23,0,0,1,0,126},{24,0,0,1,0,126},{25,0,0,1,0,126},{26,0,0,1,0,126},{27,0,0,1,0,126},{28,0,0,1,0,126},{29,0,0,1,0,126},{30,0,0,1,0,126},{31,0,0,1,0,126},{32,0,0,1,0,126},{33,0,0,1,0,126},{34,1,0,1,0,126},{0,1,1,1,94,48},{0,1,1,1,94,49},{0,1,1,1,94,50},{0,1,1,1,94,97},{0,1,1,1,94,99},{0,1,1,1,94,101},{0,1,1,1,94,105},{0,1,1,1,94,111},{0,1,1,1,94,115},{0,1,1,1,94,116},{35,0,0,1,0,94},{36,0,0,1,0,94},{37,0,0,1,0,94},{38,0,0,1,0,94},{39,0,0,1,0,94},{40,0,0,1,0,94},{41,0,0,1,0,94},{42,0,0,1,0,94},{43,0,0,1,0,94},{44,0,0,1,0,94},{45,0,0,1,0,94},{46,0,0,1,0,94},{47,0,0,1,0,94},{48,0,0,1,0,94},{49,0,0,1,0,94},{50,0,0,1,0,94},{51,0,0,1,0,94},{52,0,0,1,0,94},{53,0,0,1,0,94},{54,0,0,1,0,94},{55,0,0,1,0,94},{56,1,0,1,0,94},{0,1,1,1,125,48},{0,1,1,1,125,49},{0,1,1,1,125,50},{0,1,1,1,125,97},{0,1,1,1,125,99},{0,1,1,1,125,101},{0,1,1,1,125,105},{0,1,1,1,125,111},{0,1,1,1,125,115},{0,1,1,1,125,116},{35,0,0,1,0,125},{36,0,0,1,0,125},{37,0,0,1,0,125},{38,0,0,1,0,125},{39,0,0,1,0,125},{40,0,0,1,0,125},{41,0,0,1,0,125},{42,0,0,1,0,125},{43,0,0,1,0,125},{44,0,0,1,0,125},{45,0,0,1,0,125},{46,0,0,1,0,125},{47,0,0,1,0,125},{48,0,0,1,0,125},{49,0,0,1,0,125},{50,0,0,1,0,125},{51,0,0,1,0,125},{52,0,0,1,0,125},{53,0,0,1,0,125},{54,0,0,1,0,125},{55,0,0,1,0,125},{56,1,0,1,0,125},{57,0,0,1,0,60},{58,0,0,1,0,60},{59,0,0,1,0,60},{60,0,0,1,0,60},{61,0,0,1,0,60},{62,0,0,1,0,60},{63,0,0,1,0,60},{64,0,0,1,0,60},{65,0,0,1,0,60},{66,0,0,1,0,60},{67,0,0,1,0,60},{68,0,0,1,0,60},{69,0,0,1,0,60},{70,0,0,1,0,60},{71,0,0,1,0,60},{72,1,0,1,0,60},{57,0,0,1,0,96},{58,0,0,1,0,96},{59,0,0,1,0,96},{60,0,0,1,0,96},{61,0,0,1,0,96},{62,0,0,1,0,96},{63,0,0,1,0,96},{64,0,0,1,0,96},{65,0,0,1,0,96},{66,0,0,1,0,96},{67,0,0,1,0,96},{68,0,0,1,0,96},{69,0,0,1,0,96},{70,0,0,1,0,96},{71,0,0,1,0,96},{72,1,0,1,0,96},{57,0,0,1,0,123},{58,0,0,1,0,123},{59,0,0,1,0,123},{60,0,0,1,0,123},{61,0,0,1,0,123},{62,0,0,1,0,123},{63,0,0,1,0,123},{64,0,0,1,0,123},{65,0,0,1,0,123},{66,0,0,1,0,123},{67,0,0,1,0,123},{68,0,0,1,0,123},{69,0,0,1,0,123},{70,0,0,1,0,123},{71,0,0,1,0,123},{72,1,0,1,0,123},{0,1,0,1,0,92},{0,1,0,1,0,195},{0,1,0,1,0,208},{97,0,0,0,0,0},{98,0,0,0,0,0},{99,0,0,0,0,0},{100,0,0,0,0,0},{101,0,0,0,0,0},{102,0,0,0,0,0},{103,0,0,0,0,0},{104,0,0,0,0,0},{105,0,0,0,0,0},{106,0,0,0,0,0},{107,0,0,0,0,0},{108,0,0,0,0,0},{109,0,0,0,0,0},{9,0,1,1,39,48},{10,0,1,1,39,48},{11,0,1,1,39,48},{12,1,1,1,39,48},{9,0,1,1,39,49},{10,0,1,1,39,49},{11,0,1,1,39,49},{12,1,1,1,39,49},{9,0,1,1,39,50},{10,0,1,1,39,50},{11,0,1,1,39,50},{12,1,1,1,39,50},{9,0,1,1,39,97},{10,0,1,1,39,97},{11,0,1,1,39,97},{12,1,1,1,39,97},{9,0,1,1,39,99},{10,0,1,1,39,99},{11,0,1,1,39,99},{12,1,1,1,39,99},{9,0,1,1,39,101},{10,0,1,1,39,101},{11,0,1,1,39,101},{12,1,1,1,39,101},{9,0,1,1,39,105},{10,0,1,1,39,105},{11,0,1,1,39,105},{12,1,1,1,39,105},{9,0,1,1,39,111},{10,0,1,1,39,111},{11,0,1,1,39,111},{12,1,1,1,39,111},{9,0,1,1,39,115},{10,0,1,1,39,115},{11,0,1,1,39,115},{12,1,1,1,39,115},{9,0,1,1,39,116},{10,0,1,1,39,116},{11,0,1,1,39,116},{12,1,1,1,39,116},{13,0,1,1,39,32},{14,1,1,1,39,32},{13,0,1,1,39,37},{14,1,1,1,39,37},{13,0,1,1,39,45},{14,1,1,1,39,45},{13,0,1,1,39,46},{14,1,1,1,39,46},{13,0,1,1,39,47},{14,1,1,1,39,47},{13,0,1,1,39,51},{14,1,1,1,39,51},{13,0,1,1,39,52},{14,1,1,1,39,52},{13,0,1,1,39,53},{14,1,1,1,39,53},{13,0,1,1,39,54},{14,1,1,1,39,54},{13,0,1,1,39,55},{14,1,1,1,39,55},{13,0,1,1,39,56},{14,1,1,1,39,56},{13,0,1,1,39,57},{14,1,1,1,39,57},{13,0,1,1,39,61},{14,1,1,1,39,61},{13,0,1,1,39,65},{14,1,1,1,39,65},{13,0,1,1,39,95},{14,1,1,1,39,95},{13,0,1,1,39,98},{14,1,1,1,39,98},{13,0,1,1,39,100},{14,1,1,1,39,100},{13,0,1,1,39,102},{14,1,1,1,39,102},{13,0,1,1,39,103},{14,1,1,1,39,103},{13,0,1,1,39,104},{14,1,1,1,39,104},{13,0,1,1,39,108},{14,1,1,1,39,108},{13,0,1,1,39,109},{14,1,1,1,39,109},{13,0,1,1,39,110},{14,1,1,1,39,110},{13,0,1,1,39,112},{14,1,1,1,39,112},{13,0,1,1,39,114},{14,1,1,1,39,114},{13,0,1,1,39,117},{14,1,1,1,39,117},{0,1,1,1,39,58},{0,1,1,1,39,66},{0,1,1,1,39,67},{0,1,1,1,39,68},{0,1,1,1,39,69},{0,1,1,1,39,70},{0,1,1,1,39,71},{0,1,1,1,39,72},{0,1,1,1,39,73},{0,1,1,1,39,74},{0,1,1,1,39,75},{0,1,1,1,39,76},{0,1,1,1,39,77},{0,1,1,1,39,78},{0,1,1,1,39,79},{0,1,1,1,39,80},{0,1,1,1,39,81},{0,1,1,1,39,82},{0,1,1,1,39,83},{0,1,1,1,39,84},{0,1,1,1,39,85},{0,1,1,1,39,86},{0,1,1,1,39,87},{0,1,1,1,39,89},{0,1,1,1,39,106},{0,1,1,1,39,107},{0,1,1,1,39,113},{0,1,1,1,39,118},{0,1,1,1,39,119},{0,1,1,1,39,120},{0,1,1,1,39,121},{0,1,1,1,39,122},{85,0,0,1,0,39},{86,0,0,1,0,39},{87,0,0,1,0,39},{88,1,0,1,0,39},{9,0,1,1,43,48},{10,0,1,1,43,48},{11,0,1,1,43,48},{12,1,1,1,43,48},{9,0,1,1,43,49},{10,0,1,1,43,49},{11,0,1,1,43,49},{12,1,1,1,43,49},{9,0,1,1,43,50},{10,0,1,1,43,50},{11,0,1,1,43,50},{12,1,1,1,43,50},{9,0,1,1,43,97},{10,0,1,1,43,97},{11,0,1,1,43,97},{12,1,1,1,43,97},{9,0,1,1,43,99},{10,0,1,1,43,99},{11,0,1,1,43,99},{12,1,1,1,43,99},{9,0,1,1,43,101},{10,0,1,1,43,101},{11,0,1,1,43,101},{12,1,1,1,43,101},{9,0,1,1,43,105},{10,0,1,1,43,105},{11,0,1,1,43,105},{12,1,1,1,43,105},{9,0,1,1,43,111},{10,0,1,1,43,111},{11,0,1,1,43,111},{12,1,1,1,43,111},{9,0,1,1,43,115},{10,0,1,1,43,115},{11,0,1,1,43,115},{12,1,1,1,43,115},{9,0,1,1,43,116},{10,0,1,1,43,116},{11,0,1,1,43,116},{12,1,1,1,43,116},{13,0,1,1,43,32},{14,1,1,1,43,32},{13,0,1,1,43,37},{14,1,1,1,43,37},{13,0,1,1,43,45},{14,1,1,1,43,45},{13,0,1,1,43,46},{14,1,1,1,43,46},{13,0,1,1,43,47},{14,1,1,1,43,47},{13,0,1,1,43,51},{14,1,1,1,43,51},{13,0,1,1,43,52},{14,1,1,1,43,52},{13,0,1,1,43,53},{14,1,1,1,43,53},{13,0,1,1,43,54},{14,1,1,1,43,54},{13,0,1,1,43,55},{14,1,1,1,43,55},{13,0,1,1,43,56},{14,1,1,1,43,56},{13,0,1,1,43,57},{14,1,1,1,43,57},{13,0,1,1,43,61},{14,1,1,1,43,61},{13,0,1,1,43,65},{14,1,1,1,43,65},{13,0,1,1,43,95},{14,1,1,1,43,95},{13,0,1,1,43,98},{14,1,1,1,43,98},{13,0,1,1,43,100},{14,1,1,1,43,100},{13,0,1,1,43,102},{14,1,1,1,43,102},{13,0,1,1,43,103},{14,1,1,1,43,103},{13,0,1,1,43,104},{14,1,1,1,43,104},{13,0,1,1,43,108},{14,1,1,1,43,108},{13,0,1,1,43,109},{14,1,1,1,43,109},{13,0,1,1,43,110},{14,1,1,1,43,110},{13,0,1,1,43,112},{14,1,1,1,43,112},{13,0,1,1,43,114},{14,1,1,1,43,114},{13,0,1,1,43,117},{14,1,1,1,43,117},{0,1,1,1,43,58},{0,1,1,1,43,66},{0,1,1,1,43,67},{0,1,1,1,43,68},{0,1,1,1,43,69},{0,1,1,1,43,70},{0,1,1,1,43,71},{0,1,1,1,43,72},{0,1,1,1,43,73},{0,1,1,1,43,74},{0,1,1,1,43,75},{0,1,1,1,43,76},{0,1,1,1,43,77},{0,1,1,1,43,78},{0,1,1,1,43,79},{0,1,1,1,43,80},{0,1,1,1,43,81},{0,1,1,1,43,82},{0,1,1,1,43,83},{0,1,1,1,43,84},{0,1,1,1,43,85},{0,1,1,1,43,86},{0,1,1,1,43,87},{0,1,1,1,43,89},{0,1,1,1,43,106},{0,1,1,1,43,107},{0,1,1,1,43,113},{0,1,1,1,43,118},{0,1,1,1,43,119},{0,1,1,1,43,120},{0,1,1,1,43,121},{0,1,1,1,43,122},{85,0,0,1,0,43},{86,0,0,1,0,43},{87,0,0,1,0,43},{88,1,0,1,0,43},{9,0,1,1,124,48},{10,0,1,1,124,48},{11,0,1,1,124,48},{12,1,1,1,124,48},{9,0,1,1,124,49},{10,0,1,1,124,49},{11,0,1,1,124,49},{12,1,1,1,124,49},{9,0,1,1,124,50},{10,0,1,1,124,50},{11,0,1,1,124,50},{12,1,1,1,124,50},{9,0,1,1,124,97},{10,0,1,1,124,97},{11,0,1,1,124,97},{12,1,1,1,124,97},{9,0,1,1,124,99},{10,0,1,1,124,99},{11,0,1,1,124,99},{12,1,1,1,124,99},{9,0,1,1,124,101},{10,0,1,1,124,101},{11,0,1,1,124,101},{12,1,1,1,124,101},{9,0,1,1,124,105},{10,0,1,1,124,105},{11,0,1,1,124,105},{12,1,1,1,124,105},{9,0,1,1,124,111},{10,0,1,1,124,111},{11,0,1,1,124,111},{12,1,1,1,124,111},{9,0,1,1,124,115},{10,0,1,1,124,115},{11,0,1,1,124,115},{12,1,1,1,124,115},{9,0,1,1,124,116},{10,0,1,1,124,116},{11,0,1,1,124,116},{12,1,1,1,124,116},{13,0,1,1,124,32},{14,1,1,1,124,32},{13,0,1,1,124,37},{14,1,1,1,124,37},{13,0,1,1,124,45},{14,1,1,1,124,45},{13,0,1,1,124,46},{14,1,1,1,124,46},{13,0,1,1,124,47},{14,1,1,1,124,47},{13,0,1,1,124,51},{14,1,1,1,124,51},{13,0,1,1,124,52},{14,1,1,1,124,52},{13,0,1,1,124,53},{14,1,1,1,124,53},{13,0,1,1,124,54},{14,1,1,1,124,54},{13,0,1,1,124,55},{14,1,1,1,124,55},{13,0,1,1,124,56},{14,1,1,1,124,56},{13,0,1,1,124,57},{14,1,1,1,124,57},{13,0,1,1,124,61},{14,1,1,1,124,61},{13,0,1,1,124,65},{14,1,1,1,124,65},{13,0,1,1,124,95},{14,1,1,1,124,95},{13,0,1,1,124,98},{14,1,1,1,124,98},{13,0,1,1,124,100},{14,1,1,1,124,100},{13,0,1,1,124,102},{14,1,1,1,124,102},{13,0,1,1,124,103},{14,1,1,1,124,103},{13,0,1,1,124,104},{14,1,1,1,124,104},{13,0,1,1,124,108},{14,1,1,1,124,108},{13,0,1,1,124,109},{14,1,1,1,124,109},{13,0,1,1,124,110},{14,1,1,1,124,110},{13,0,1,1,124,112},{14,1,1,1,124,112},{13,0,1,1,124,114},{14,1,1,1,124,114},{13,0,1,1,124,117},{14,1,1,1,124,117},{0,1,1,1,124,58},{0,1,1,1,124,66},{0,1,1,1,124,67},{0,1,1,1,124,68},{0,1,1,1,124,69},{0,1,1,1,124,70},{0,1,1,1,124,71},{0,1,1,1,124,72},{0,1,1,1,124,73},{0,1,1,1,124,74},{0,1,1,1,124,75},{0,1,1,1,124,76},{0,1,1,1,124,77},{0,1,1,1,124,78},{0,1,1,1,124,79},{0,1,1,1,124,80},{0,1,1,1,124,81},{0,1,1,1,124,82},{0,1,1,1,124,83},{0,1,1,1,124,84},{0,1,1,1,124,85},{0,1,1,1,124,86},{0,1,1,1,124,87},{0,1,1,1,124,89},{0,1,1,1,124,106},{0,1,1,1,124,107},{0,1,1,1,124,113},{0,1,1,1,124,118},{0,1,1,1,124,119},{0,1,1,1,124,120},{0,1,1,1,124,121},{0,1,1,1,124,122},{85,0,0,1,0,124},{86,0,0,1,0,124},{87,0,0,1,0,124},{88,1,0,1,0,124},{13,0,1,1,35,48},{14,1,1,1,35,48},{13,0,1,1,35,49},{14,1,1,1,35,49},{13,0,1,1,35,50},{14,1,1,1,35,50},{13,0,1,1,35,97},{14,1,1,1,35,97},{13,0,1,1,35,99},{14,1,1,1,35,99},{13,0,1,1,35,101},{14,1,1,1,35,101},{13,0,1,1,35,105},{14,1,1,1,35,105},{13,0,1,1,35,111},{14,1,1,1,35,111},{13,0,1,1,35,115},{14,1,1,1,35,115},{13,0,1,1,35,116},{14,1,1,1,35,116},{0,1,1,1,35,32},{0,1,1,1,35,37},{0,1,1,1,35,45},{0,1,1,1,35,46},{0,1,1,1,35,47},{0,1,1,1,35,51},{0,1,1,1,35,52},{0,1,1,1,35,53},{0,1,1,1,35,54},{0,1,1,1,35,55},{0,1,1,1,35,56},{0,1,1,1,35,57},{0,1,1,1,35,61},{0,1,1,1,35,65},{0,1,1,1,35,95},{0,1,1,1,35,98},{0,1,1,1,35,100},{0,1,1,1,35,102},{0,1,1,1,35,103},{0,1,1,1,35,104},{0,1,1,1,35,108},{0,1,1,1,35,109},{0,1,1,1,35,110},{0,1,1,1,35,112},{0,1,1,1,35,114},{0,1,1,1,35,117},{17,0,0,1,0,35},{18,0,0,1,0,35},{19,0,0,1,0,35},{20,0,0,1,0,35},{21,0,0,1,0,35},{22,0,0,1,0,35},{23,0,0,1,0,35},{24,0,0,1,0,35},{25,0,0,1,0,35},{26,0,0,1,0,35},{27,0,0,1,0,35},{28,0,0,1,0,35},{29,0,0,1,0,35},{30,0,0,1,0,35},{31,0,0,1,0,35},{32,0,0,1,0,35},{33,0,0,1,0,35},{34,1,0,1,0,35},{13,0,1,1,62,48},{14,1,1,1,62,48},{13,0,1,1,62,49},{14,1,1,1,62,49},{13,0,1,1,62,50},{14,1,1,1,62,50},{13,0,1,1,62,97},{14,1,1,1,62,97},{13,0,1,1,62,99},{14,1,1,1,62,99},{13,0,1,1,62,101},{14,1,1,1,62,101},{13,0,1,1,62,105},{14,1,1,1,62,105},{13,0,1,1,62,111},{14,1,1,1,62,111},{13,0,1,1,62,115},{14,1,1,1,62,115},{13,0,1,1,62,116},{14,1,1,1,62,116},{0,1,1,1,62,32},{0,1,1,1,62,37},{0,1,1,1,62,45},{0,1,1,1,62,46},{0,1,1,1,62,47},{0,1,1,1,62,51},{0,1,1,1,62,52},{0,1,1,1,62,53},{0,1,1,1,62,54},{0,1,1,1,62,55},{0,1,1,1,62,56},{0,1,1,1,62,57},{0,1,1,1,62,61},{0,1,1,1,62,65},{0,1,1,1,62,95},{0,1,1,1,62,98},{0,1,1,1,62,100},{0,1,1,1,62,102},{0,1,1,1,62,103},{0,1,1,1,62,104},{0,1,1,1,62,108},{0,1,1,1,62,109},{0,1,1,1,62,110},{0,1,1,1,62,112},{0,1,1,1,62,114},{0,1,1,1,62,117},{17,0,0,1,0,62},{18,0,0,1,0,62},{19,0,0,1,0,62},{20,0,0,1,0,62},{21,0,0,1,0,62},{22,0,0,1,0,62},{23,0,0,1,0,62},{24,0,0,1,0,62},{25,0,0,1,0,62},{26,0,0,1,0,62},{27,0,0,1,0,62},{28,0,0,1,0,62},{29,0,0,1,0,62},{30,0,0,1,0,62},{31,0,0,1,0,62},{32,0,0,1,0,62},{33,0,0,1,0,62},{34,1,0,1,0,62},{0,1,1,1,0,48},{0,1,1,1,0,49},{0,1,1,1,0,50},{0,1,1,1,0,97},{0,1,1,1,0,99},{0,1,1,1,0,101},{0,1,1,1,0,105},{0,1,1,1,0,111},{0,1,1,1,0,115},{0,1,1,1,0,116},{35,0,0,1,0,0},{36,0,0,1,0,0},{37,0,0,1,0,0},{38,0,0,1,0,0},{39,0,0,1,0,0},{40,0,0,1,0,0},{41,0,0,1,0,0},{42,0,0,1,0,0},{43,0,0,1,0,0},{44,0,0,1,0,0},{45,0,0,1,0,0},{46,0,0,1,0,0},{47,0,0,1,0,0},{48,0,0,1,0,0},{49,0,0,1,0,0},{50,0,0,1,0,0},{51,0,0,1,0,0},{52,0,0,1,0,0},{53,0,0,1,0,0},{54,0,0,1,0,0},{55,0,0,1,0,0},{56,1,0,1,0,0},{0,1,1,1,36,48},{0,1,1,1,36,49},{0,1,1,1,36,50},{0,1,1,1,36,97},{0,1,1,1,36,99},{0,1,1,1,36,101},{0,1,1,1,36,105},{0,1,1,1,36,111},{0,1,1,1,36,115},{0,1,1,1,36,116},{35,0,0,1,0,36},{36,0,0,1,0,36},{37,0,0,1,0,36},{38,0,0,1,0,36},{39,0,0,1,0,36},{40,0,0,1,0,36},{41,0,0,1,0,36},{42,0,0,1,0,36},{43,0,0,1,0,36},{44,0,0,1,0,36},{45,0,0,1,0,36},{46,0,0,1,0,36},{47,0,0,1,0,36},{48,0,0,1,0,36},{49,0,0,1,0,36},{50,0,0,1,0,36},{51,0,0,1,0,36},{52,0,0,1,0,36},{53,0,0,1,0,36},{54,0,0,1,0,36},{55,0,0,1,0,36},{56,1,0,1,0,36},{0,1,1,1,64,48},{0,1,1,1,64,49},{0,1,1,1,64,50},{0,1,1,1,64,97},{0,1,1,1,64,99},{0,1,1,1,64,101},{0,1,1,1,64,105},{0,1,1,1,64,111},{0,1,1,1,64,115},{0,1,1,1,64,116},{35,0,0,1,0,64},{36,0,0,1,0,64},{37,0,0,1,0,64},{38,0,0,1,0,64},{39,0,0,1,0,64},{40,0,0,1,0,64},{41,0,0,1,0,64},{42,0,0,1,0,64},{43,0,0,1,0,64},{44,0,0,1,0,64},{45,0,0,1,0,64},{46,0,0,1,0,64},{47,0,0,1,0,64},{48,0,0,1,0,64},{49,0,0,1,0,64},{50,0,0,1,0,64},{51,0,0,1,0,64},{52,0,0,1,0,64},{53,0,0,1,0,64},{54,0,0,1,0,64},{55,0,0,1,0,64},{56,1,0,1,0,64},{0,1,1,1,91,48},{0,1,1,1,91,49},{0,1,1,1,91,50},{0,1,1,1,91,97},{0,1,1,1,91,99},{0,1,1,1,91,101},{0,1,1,1,91,105},{0,1,1,1,91,111},{0,1,1,1,91,115},{0,1,1,1,91,116},{35,0,0,1,0,91},{36,0,0,1,0,91},{37,0,0,1,0,91},{38,0,0,1,0,91},{39,0,0,1,0,91},{40,0,0,1,0,91},{41,0,0,1,0,91},{42,0,0,1,0,91},{43,0,0,1,0,91},{44,0,0,1,0,91},{45,0,0,1,0,91},{46,0,0,1,0,91},{47,0,0,1,0,91},{48,0,0,1,0,91},{49,0,0,1,0,91},{50,0,0,1,0,91},{51,0,0,1,0,91},{52,0,0,1,0,91},{53,0,0,1,0,91},{54,0,0,1,0,91},{55,0,0,1,0,91},{56,1,0,1,0,91},{0,1,1,1,93,48},{0,1,1,1,93,49},{0,1,1,1,93,50},{0,1,1,1,93,97},{0,1,1,1,93,99},{0,1,1,1,93,101},{0,1,1,1,93,105},{0,1,1,1,93,111},{0,1,1,1,93,115},{0,1,1,1,93,116},{35,0,0,1,0,93},{36,0,0,1,0,93},{37,0,0,1,0,93},{38,0,0,1,0,93},{39,0,0,1,0,93},{40,0,0,1,0,93},{41,0,0,1,0,93},{42,0,0,1,0,93},{43,0,0,1,0,93},{44,0,0,1,0,93},{45,0,0,1,0,93},{46,0,0,1,0,93},{47,0,0,1,0,93},{48,0,0,1,0,93},{49,0,0,1,0,93},{50,0,0,1,0,93},{51,0,0,1,0,93},{52,0,0,1,0,93},{53,0,0,1,0,93},{54,0,0,1,0,93},{55,0,0,1,0,93},{56,1,0,1,0,93},{0,1,1,1,126,48},{0,1,1,1,126,49},{0,1,1,1,126,50},{0,1,1,1,126,97},{0,1,1,1,126,99},{0,1,1,1,126,101},{0,1,1,1,126,105},{0,1,1,1,126,111},{0,1,1,1,126,115},{0,1,1,1,126,116},{35,0,0,1,0,126},{36,0,0,1,0,126},{37,0,0,1,0,126},{38,0,0,1,0,126},{39,0,0,1,0,126},{40,0,0,1,0,126},{41,0,0,1,0,126},{42,0,0,1,0,126},{43,0,0,1,0,126},{44,0,0,1,0,126},{45,0,0,1,0,126},{46,0,0,1,0,126},{47,0,0,1,0,126},{48,0,0,1,0,126},{49,0,0,1,0,126},{50,0,0,1,0,126},{51,0,0,1,0,126},{52,0,0,1,0,126},{53,0,0,1,0,126},{54,0,0,1,0,126},{55,0,0,1,0,126},{56,1,0,1,0,126},{57,0,0,1,0,94},{58,0,0,1,0,94},{59,0,0,1,0,94},{60,0,0,1,0,94},{61,0,0,1,0,94},{62,0,0,1,0,94},{63,0,0,1,0,94},{64,0,0,1,0,94},{65,0,0,1,0,94},{66,0,0,1,0,94},{67,0,0,1,0,94},{68,0,0,1,0,94},{69,0,0,1,0,94},{70,0,0,1,0,94},{71,0,0,1,0,94},{72,1,0,1,0,94},{57,0,0,1,0,125},{58,0,0,1,0,125},{59,0,0,1,0,125},{60,0,0,1,0,125},{61,0,0,1,0,125},{62,0,0,1,0,125},{63,0,0,1,0,125},{64,0,0,1,0,125},{65,0,0,1,0,125},{66,0,0,1,0,125},{67,0,0,1,0,125},{68,0,0,1,0,125},{69,0,0,1,0,125},{70,0,0,1,0,125},{71,0,0,1,0,125},{72,1,0,1,0,125},{1,0,0,1,0,60},{2,0,0,1,0,60},{3,0,0,1,0,60},{4,0,0,1,0,60},{5,0,0,1,0,60},{6,0,0,1,0,60},{7,0,0,1,0,60},{8,1,0,1,0,60},{1,0,0,1,0,96},{2,0,0,1,0,96},{3,0,0,1,0,96},{4,0,0,1,0,96},{5,0,0,1,0,96},{6,0,0,1,0,96},{7,0,0,1,0,96},{8,1,0,1,0,96},{1,0,0,1,0,123},{2,0,0,1,0,123},{3,0,0,1,0,123},{4,0,0,1,0,123},{5,0,0,1,0,123},{6,0,0,1,0,123},{7,0,0,1,0,123},{8,1,0,1,0,123},{110,0,0,0,0,0},{111,0,0,0,0,0},{112,0,0,0,0,0},{113,0,0,0,0,0},{114,0,0,0,0,0},{115,0,0,0,0,0},{116,0,0,0,0,0},{117,0,0,0,0,0},{9,0,1,1,33,48},{10,0,1,1,33,48},{11,0,1,1,33,48},{12,1,1,1,33,48},{9,0,1,1,33,49},{10,0,1,1,33,49},{11,0,1,1,33,49},{12,1,1,1,33,49},{9,0,1,1,33,50},{10,0,1,1,33,50},{11,0,1,1,33,50},{12,1,1,1,33,50},{9,0,1,1,33,97},{10,0,1,1,33,97},{11,0,1,1,33,97},{12,1,1,1,33,97},{9,0,1,1,33,99},{10,0,1,1,33,99},{11,0,1,1,33,99},{12,1,1,1,33,99},{9,0,1,1,33,101},{10,0,1,1,33,101},{11,0,1,1,33,101},{12,1,1,1,33,101},{9,0,1,1,33,105},{10,0,1,1,33,105},{11,0,1,1,33,105},{12,1,1,1,33,105},{9,0,1,1,33,111},{10,0,1,1,33,111},{11,0,1,1,33,111},{12,1,1,1,33,111},{9,0,1,1,33,115},{10,0,1,1,33,115},{11,0,1,1,33,115},{12,1,1,1,33,115},{9,0,1,1,33,116},{10,0,1,1,33,116},{11,0,1,1,33,116},{12,1,1,1,33,116},{13,0,1,1,33,32},{14,1,1,1,33,32},{13,0,1,1,33,37},{14,1,1,1,33,37},{13,0,1,1,33,45},{14,1,1,1,33,45},{13,0,1,1,33,46},{14,1,1,1,33,46},{13,0,1,1,33,47},{14,1,1,1,33,47},{13,0,1,1,33,51},{14,1,1,1,33,51},{13,0,1,1,33,52},{14,1,1,1,33,52},{13,0,1,1,33,53},{14,1,1,1,33,53},{13,0,1,1,33,54},{14,1,1,1,33,54},{13,0,1,1,33,55},{14,1,1,1,33,55},{13,0,1,1,33,56},{14,1,1,1,33,56},{13,0,1,1,33,57},{14,1,1,1,33,57},{13,0,1,1,33,61},{14,1,1,1,33,61},{13,0,1,1,33,65},{14,1,1,1,33,65},{13,0,1,1,33,95},{14,1,1,1,33,95},{13,0,1,1,33,98},{14,1,1,1,33,98},{13,0,1,1,33,100},{14,1,1,1,33,100},{13,0,1,1,33,102},{14,1,1,1,33,102},{13,0,1,1,33,103},{14,1,1,1,33,103},{13,0,1,1,33,104},{14,1,1,1,33,104},{13,0,1,1,33,108},{14,1,1,1,33,108},{13,0,1,1,33,109},{14,1,1,1,33,109},{13,0,1,1,33,110},{14,1,1,1,33,110},{13,0,1,1,33,112},{14,1,1,1,33,112},{13,0,1,1,33,114},{14,1,1,1,33,114},{13,0,1,1,33,117},{14,1,1,1,33,117},{0,1,1,1,33,58},{0,1,1,1,33,66},{0,1,1,1,33,67},{0,1,1,1,33,68},{0,1,1,1,33,69},{0,1,1,1,33,70},{0,1,1,1,33,71},{0,1,1,1,33,72},{0,1,1,1,33,73},{0,1,1,1,33,74},{0,1,1,1,33,75},{0,1,1,1,33,76},{0,1,1,1,33,77},{0,1,1,1,33,78},{0,1,1,1,33,79},{0,1,1,1,33,80},{0,1,1,1,33,81},{0,1,1,1,33,82},{0,1,1,1,33,83},{0,1,1,1,33,84},{0,1,1,1,33,85},{0,1,1,1,33,86},{0,1,1,1,33,87},{0,1,1,1,33,89},{0,1,1,1,33,106},{0,1,1,1,33,107},{0,1,1,1,33,113},{0,1,1,1,33,118},{0,1,1,1,33,119},{0,1,1,1,33,120},{0,1,1,1,33,121},{0,1,1,1,33,122},{85,0,0,1,0,33},{86,0,0,1,0,33},{87,0,0,1,0,33},{88,1,0,1,0,33},{9,0,1,1,34,48},{10,0,1,1,34,48},{11,0,1,1,34,48},{12,1,1,1,34,48},{9,0,1,1,34,49},{10,0,1,1,34,49},{11,0,1,1,34,49},{12,1,1,1,34,49},{9,0,1,1,34,50},{10,0,1,1,34,50},{11,0,1,1,34,50},{12,1,1,1,34,50},{9,0,1,1,34,97},{10,0,1,1,34,97},{11,0,1,1,34,97},{12,1,1,1,34,97},{9,0,1,1,34,99},{10,0,1,1,34,99},{11,0,1,1,34,99},{12,1,1,1,34,99},{9,0,1,1,34,101},{10,0,1,1,34,101},{11,0,1,1,34,101},{12,1,1,1,34,101},{9,0,1,1,34,105},{10,0,1,1,34,105},{11,0,1,1,34,105},{12,1,1,1,34,105},{9,0,1,1,34,111},{10,0,1,1,34,111},{11,0,1,1,34,111},{12,1,1,1,34,111},{9,0,1,1,34,115},{10,0,1,1,34,115},{11,0,1,1,34,115},{12,1,1,1,34,115},{9,0,1,1,34,116},{10,0,1,1,34,116},{11,0,1,1,34,116},{12,1,1,1,34,116},{13,0,1,1,34,32},{14,1,1,1,34,32},{13,0,1,1,34,37},{14,1,1,1,34,37},{13,0,1,1,34,45},{14,1,1,1,34,45},{13,0,1,1,34,46},{14,1,1,1,34,46},{13,0,1,1,34,47},{14,1,1,1,34,47},{13,0,1,1,34,51},{14,1,1,1,34,51},{13,0,1,1,34,52},{14,1,1,1,34,52},{13,0,1,1,34,53},{14,1,1,1,34,53},{13,0,1,1,34,54},{14,1,1,1,34,54},{13,0,1,1,34,55},{14,1,1,1,34,55},{13,0,1,1,34,56},{14,1,1,1,34,56},{13,0,1,1,34,57},{14,1,1,1,34,57},{13,0,1,1,34,61},{14,1,1,1,34,61},{13,0,1,1,34,65},{14,1,1,1,34,65},{13,0,1,1,34,95},{14,1,1,1,34,95},{13,0,1,1,34,98},{14,1,1,1,34,98},{13,0,1,1,34,100},{14,1,1,1,34,100},{13,0,1,1,34,102},{14,1,1,1,34,102},{13,0,1,1,34,103},{14,1,1,1,34,103},{13,0,1,1,34,104},{14,1,1,1,34,104},{13,0,1,1,34,108},{14,1,1,1,34,108},{13,0,1,1,34,109},{14,1,1,1,34,109},{13,0,1,1,34,110},{14,1,1,1,34,110},{13,0,1,1,34,112},{14,1,1,1,34,112},{13,0,1,1,34,114},{14,1,1,1,34,114},{13,0,1,1,34,117},{14,1,1,1,34,117},{0,1,1,1,34,58},{0,1,1,1,34,66},{0,1,1,1,34,67},{0,1,1,1,34,68},{0,1,1,1,34,69},{0,1,1,1,34,70},{0,1,1,1,34,71},{0,1,1,1,34,72},{0,1,1,1,34,73},{0,1,1,1,34,74},{0,1,1,1,34,75},{0,1,1,1,34,76},{0,1,1,1,34,77},{0,1,1,1,34,78},{0,1,1,1,34,79},{0,1,1,1,34,80},{0,1,1,1,34,81},{0,1,1,1,34,82},{0,1,1,1,34,83},{0,1,1,1,34,84},{0,1,1,1,34,85},{0,1,1,1,34,86},{0,1,1,1,34,87},{0,1,1,1,34,89},{0,1,1,1,34,106},{0,1,1,1,34,107},{0,1,1,1,34,113},{0,1,1,1,34,118},{0,1,1,1,34,119},{0,1,1,1,34,120},{0,1,1,1,34,121},{0,1,1,1,34,122},{85,0,0,1,0,34},{86,0,0,1,0,34},{87,0,0,1,0,34},{88,1,0,1,0,34},{9,0,1,1,40,48},{10,0,1,1,40,48},{11,0,1,1,40,48},{12,1,1,1,40,48},{9,0,1,1,40,49},{10,0,1,1,40,49},{11,0,1,1,40,49},{12,1,1,1,40,49},{9,0,1,1,40,50},{10,0,1,1,40,50},{11,0,1,1,40,50},{12,1,1,1,40,50},{9,0,1,1,40,97},{10,0,1,1,40,97},{11,0,1,1,40,97},{12,1,1,1,40,97},{9,0,1,1,40,99},{10,0,1,1,40,99},{11,0,1,1,40,99},{12,1,1,1,40,99},{9,0,1,1,40,101},{10,0,1,1,40,101},{11,0,1,1,40,101},{12,1,1,1,40,101},{9,0,1,1,40,105},{10,0,1,1,40,105},{11,0,1,1,40,105},{12,1,1,1,40,105},{9,0,1,1,40,111},{10,0,1,1,40,111},{11,0,1,1,40,111},{12,1,1,1,40,111},{9,0,1,1,40,115},{10,0,1,1,40,115},{11,0,1,1,40,115},{12,1,1,1,40,115},{9,0,1,1,40,116},{10,0,1,1,40,116},{11,0,1,1,40,116},{12,1,1,1,40,116},{13,0,1,1,40,32},{14,1,1,1,40,32},{13,0,1,1,40,37},{14,1,1,1,40,37},{13,0,1,1,40,45},{14,1,1,1,40,45},{13,0,1,1,40,46},{14,1,1,1,40,46},{13,0,1,1,40,47},{14,1,1,1,40,47},{13,0,1,1,40,51},{14,1,1,1,40,51},{13,0,1,1,40,52},{14,1,1,1,40,52},{13,0,1,1,40,53},{14,1,1,1,40,53},{13,0,1,1,40,54},{14,1,1,1,40,54},{13,0,1,1,40,55},{14,1,1,1,40,55},{13,0,1,1,40,56},{14,1,1,1,40,56},{13,0,1,1,40,57},{14,1,1,1,40,57},{13,0,1,1,40,61},{14,1,1,1,40,61},{13,0,1,1,40,65},{14,1,1,1,40,65},{13,0,1,1,40,95},{14,1,1,1,40,95},{13,0,1,1,40,98},{14,1,1,1,40,98},{13,0,1,1,40,100},{14,1,1,1,40,100},{13,0,1,1,40,102},{14,1,1,1,40,102},{13,0,1,1,40,103},{14,1,1,1,40,103},{13,0,1,1,40,104},{14,1,1,1,40,104},{13,0,1,1,40,108},{14,1,1,1,40,108},{13,0,1,1,40,109},{14,1,1,1,40,109},{13,0,1,1,40,110},{14,1,1,1,40,110},{13,0,1,1,40,112},{14,1,1,1,40,112},{13,0,1,1,40,114},{14,1,1,1,40,114},{13,0,1,1,40,117},{14,1,1,1,40,117},{0,1,1,1,40,58},{0,1,1,1,40,66},{0,1,1,1,40,67},{0,1,1,1,40,68},{0,1,1,1,40,69},{0,1,1,1,40,70},{0,1,1,1,40,71},{0,1,1,1,40,72},{0,1,1,1,40,73},{0,1,1,1,40,74},{0,1,1,1,40,75},{0,1,1,1,40,76},{0,1,1,1,40,77},{0,1,1,1,40,78},{0,1,1,1,40,79},{0,1,1,1,40,80},{0,1,1,1,40,81},{0,1,1,1,40,82},{0,1,1,1,40,83},{0,1,1,1,40,84},{0,1,1,1,40,85},{0,1,1,1,40,86},{0,1,1,1,40,87},{0,1,1,1,40,89},{0,1,1,1,40,106},{0,1,1,1,40,107},{0,1,1,1,40,113},{0,1,1,1,40,118},{0,1,1,1,40,119},{0,1,1,1,40,120},{0,1,1,1,40,121},{0,1,1,1,40,122},{85,0,0,1,0,40},{86,0,0,1,0,40},{87,0,0,1,0,40},{88,1,0,1,0,40},{9,0,1,1,41,48},{10,0,1,1,41,48},{11,0,1,1,41,48},{12,1,1,1,41,48},{9,0,1,1,41,49},{10,0,1,1,41,49},{11,0,1,1,41,49},{12,1,1,1,41,49},{9,0,1,1,41,50},{10,0,1,1,41,50},{11,0,1,1,41,50},{12,1,1,1,41,50},{9,0,1,1,41,97},{10,0,1,1,41,97},{11,0,1,1,41,97},{12,1,1,1,41,97},{9,0,1,1,41,99},{10,0,1,1,41,99},{11,0,1,1,41,99},{12,1,1,1,41,99},{9,0,1,1,41,101},{10,0,1,1,41,101},{11,0,1,1,41,101},{12,1,1,1,41,101},{9,0,1,1,41,105},{10,0,1,1,41,105},{11,0,1,1,41,105},{12,1,1,1,41,105},{9,0,1,1,41,111},{10,0,1,1,41,111},{11,0,1,1,41,111},{12,1,1,1,41,111},{9,0,1,1,41,115},{10,0,1,1,41,115},{11,0,1,1,41,115},{12,1,1,1,41,115},{9,0,1,1,41,116},{10,0,1,1,41,116},{11,0,1,1,41,116},{12,1,1,1,41,116},{13,0,1,1,41,32},{14,1,1,1,41,32},{13,0,1,1,41,37},{14,1,1,1,41,37},{13,0,1,1,41,45},{14,1,1,1,41,45},{13,0,1,1,41,46},{14,1,1,1,41,46},{13,0,1,1,41,47},{14,1,1,1,41,47},{13,0,1,1,41,51},{14,1,1,1,41,51},{13,0,1,1,41,52},{14,1,1,1,41,52},{13,0,1,1,41,53},{14,1,1,1,41,53},{13,0,1,1,41,54},{14,1,1,1,41,54},{13,0,1,1,41,55},{14,1,1,1,41,55},{13,0,1,1,41,56},{14,1,1,1,41,56},{13,0,1,1,41,57},{14,1,1,1,41,57},{13,0,1,1,41,61},{14,1,1,1,41,61},{13,0,1,1,41,65},{14,1,1,1,41,65},{13,0,1,1,41,95},{14,1,1,1,41,95},{13,0,1,1,41,98},{14,1,1,1,41,98},{13,0,1,1,41,100},{14,1,1,1,41,100},{13,0,1,1,41,102},{14,1,1,1,41,102},{13,0,1,1,41,103},{14,1,1,1,41,103},{13,0,1,1,41,104},{14,1,1,1,41,104},{13,0,1,1,41,108},{14,1,1,1,41,108},{13,0,1,1,41,109},{14,1,1,1,41,109},{13,0,1,1,41,110},{14,1,1,1,41,110},{13,0,1,1,41,112},{14,1,1,1,41,112},{13,0,1,1,41,114},{14,1,1,1,41,114},{13,0,1,1,41,117},{14,1,1,1,41,117},{0,1,1,1,41,58},{0,1,1,1,41,66},{0,1,1,1,41,67},{0,1,1,1,41,68},{0,1,1,1,41,69},{0,1,1,1,41,70},{0,1,1,1,41,71},{0,1,1,1,41,72},{0,1,1,1,41,73},{0,1,1,1,41,74},{0,1,1,1,41,75},{0,1,1,1,41,76},{0,1,1,1,41,77},{0,1,1,1,41,78},{0,1,1,1,41,79},{0,1,1,1,41,80},{0,1,1,1,41,81},{0,1,1,1,41,82},{0,1,1,1,41,83},{0,1,1,1,41,84},{0,1,1,1,41,85},{0,1,1,1,41,86},{0,1,1,1,41,87},{0,1,1,1,41,89},{0,1,1,1,41,106},{0,1,1,1,41,107},{0,1,1,1,41,113},{0,1,1,1,41,118},{0,1,1,1,41,119},{0,1,1,1,41,120},{0,1,1,1,41,121},{0,1,1,1,41,122},{85,0,0,1,0,41},{86,0,0,1,0,41},{87,0,0,1,0,41},{88,1,0,1,0,41},{9,0,1,1,63,48},{10,0,1,1,63,48},{11,0,1,1,63,48},{12,1,1,1,63,48},{9,0,1,1,63,49},{10,0,1,1,63,49},{11,0,1,1,63,49},{12,1,1,1,63,49},{9,0,1,1,63,50},{10,0,1,1,63,50},{11,0,1,1,63,50},{12,1,1,1,63,50},{9,0,1,1,63,97},{10,0,1,1,63,97},{11,0,1,1,63,97},{12,1,1,1,63,97},{9,0,1,1,63,99},{10,0,1,1,63,99},{11,0,1,1,63,99},{12,1,1,1,63,99},{9,0,1,1,63,101},{10,0,1,1,63,101},{11,0,1,1,63,101},{12,1,1,1,63,101},{9,0,1,1,63,105},{10,0,1,1,63,105},{11,0,1,1,63,105},{12,1,1,1,63,105},{9,0,1,1,63,111},{10,0,1,1,63,111},{11,0,1,1,63,111},{12,1,1,1,63,111},{9,0,1,1,63,115},{10,0,1,1,63,115},{11,0,1,1,63,115},{12,1,1,1,63,115},{9,0,1,1,63,116},{10,0,1,1,63,116},{11,0,1,1,63,116},{12,1,1,1,63,116},{13,0,1,1,63,32},{14,1,1,1,63,32},{13,0,1,1,63,37},{14,1,1,1,63,37},{13,0,1,1,63,45},{14,1,1,1,63,45},{13,0,1,1,63,46},{14,1,1,1,63,46},{13,0,1,1,63,47},{14,1,1,1,63,47},{13,0,1,1,63,51},{14,1,1,1,63,51},{13,0,1,1,63,52},{14,1,1,1,63,52},{13,0,1,1,63,53},{14,1,1,1,63,53},{13,0,1,1,63,54},{14,1,1,1,63,54},{13,0,1,1,63,55},{14,1,1,1,63,55},{13,0,1,1,63,56},{14,1,1,1,63,56},{13,0,1,1,63,57},{14,1,1,1,63,57},{13,0,1,1,63,61},{14,1,1,1,63,61},{13,0,1,1,63,65},{14,1,1,1,63,65},{13,0,1,1,63,95},{14,1,1,1,63,95},{13,0,1,1,63,98},{14,1,1,1,63,98},{13,0,1,1,63,100},{14,1,1,1,63,100},{13,0,1,1,63,102},{14,1,1,1,63,102},{13,0,1,1,63,103},{14,1,1,1,63,103},{13,0,1,1,63,104},{14,1,1,1,63,104},{13,0,1,1,63,108},{14,1,1,1,63,108},{13,0,1,1,63,109},{14,1,1,1,63,109},{13,0,1,1,63,110},{14,1,1,1,63,110},{13,0,1,1,63,112},{14,1,1,1,63,112},{13,0,1,1,63,114},{14,1,1,1,63,114},{13,0,1,1,63,117},{14,1,1,1,63,117},{0,1,1,1,63,58},{0,1,1,1,63,66},{0,1,1,1,63,67},{0,1,1,1,63,68},{0,1,1,1,63,69},{0,1,1,1,63,70},{0,1,1,1,63,71},{0,1,1,1,63,72},{0,1,1,1,63,73},{0,1,1,1,63,74},{0,1,1,1,63,75},{0,1,1,1,63,76},{0,1,1,1,63,77},{0,1,1,1,63,78},{0,1,1,1,63,79},{0,1,1,1,63,80},{0,1,1,1,63,81},{0,1,1,1,63,82},{0,1,1,1,63,83},{0,1,1,1,63,84},{0,1,1,1,63,85},{0,1,1,1,63,86},{0,1,1,1,63,87},{0,1,1,1,63,89},{0,1,1,1,63,106},{0,1,1,1,63,107},{0,1,1,1,63,113},{0,1,1,1,63,118},{0,1,1,1,63,119},{0,1,1,1,63,120},{0,1,1,1,63,121},{0,1,1,1,63,122},{85,0,0,1,0,63},{86,0,0,1,0,63},{87,0,0,1,0,63},{88,1,0,1,0,63},{13,0,1,1,39,48},{14,1,1,1,39,48},{13,0,1,1,39,49},{14,1,1,1,39,49},{13,0,1,1,39,50},{14,1,1,1,39,50},{13,0,1,1,39,97},{14,1,1,1,39,97},{13,0,1,1,39,99},{14,1,1,1,39,99},{13,0,1,1,39,101},{14,1,1,1,39,101},{13,0,1,1,39,105},{14,1,1,1,39,105},{13,0,1,1,39,111},{14,1,1,1,39,111},{13,0,1,1,39,115},{14,1,1,1,39,115},{13,0,1,1,39,116},{14,1,1,1,39,116},{0,1,1,1,39,32},{0,1,1,1,39,37},{0,1,1,1,39,45},{0,1,1,1,39,46},{0,1,1,1,39,47},{0,1,1,1,39,51},{0,1,1,1,39,52},{0,1,1,1,39,53},{0,1,1,1,39,54},{0,1,1,1,39,55},{0,1,1,1,39,56},{0,1,1,1,39,57},{0,1,1,1,39,61},{0,1,1,1,39,65},{0,1,1,1,39,95},{0,1,1,1,39,98},{0,1,1,1,39,100},{0,1,1,1,39,102},{0,1,1,1,39,103},{0,1,1,1,39,104},{0,1,1,1,39,108},{0,1,1,1,39,109},{0,1,1,1,39,110},{0,1,1,1,39,112},{0,1,1,1,39,114},{0,1,1,1,39,117},{17,0,0,1,0,39},{18,0,0,1,0,39},{19,0,0,1,0,39},{20,0,0,1,0,39},{21,0,0,1,0,39},{22,0,0,1,0,39},{23,0,0,1,0,39},{24,0,0,1,0,39},{25,0,0,1,0,39},{26,0,0,1,0,39},{27,0,0,1,0,39},{28,0,0,1,0,39},{29,0,0,1,0,39},{30,0,0,1,0,39},{31,0,0,1,0,39},{32,0,0,1,0,39},{33,0,0,1,0,39},{34,1,0,1,0,39},{13,0,1,1,43,48},{14,1,1,1,43,48},{13,0,1,1,43,49},{14,1,1,1,43,49},{13,0,1,1,43,50},{14,1,1,1,43,50},{13,0,1,1,43,97},{14,1,1,1,43,97},{13,0,1,1,43,99},{14,1,1,1,43,99},{13,0,1,1,43,101},{14,1,1,1,43,101},{13,0,1,1,43,105},{14,1,1,1,43,105},{13,0,1,1,43,111},{14,1,1,1,43,111},{13,0,1,1,43,115},{14,1,1,1,43,115},{13,0,1,1,43,116},{14,1,1,1,43,116},{0,1,1,1,43,32},{0,1,1,1,43,37},{0,1,1,1,43,45},{0,1,1,1,43,46},{0,1,1,1,43,47},{0,1,1,1,43,51},{0,1,1,1,43,52},{0,1,1,1,43,53},{0,1,1,1,43,54},{0,1,1,1,43,55},{0,1,1,1,43,56},{0,1,1,1,43,57},{0,1,1,1,43,61},{0,1,1,1,43,65},{0,1,1,1,43,95},{0,1,1,1,43,98},{0,1,1,1,43,100},{0,1,1,1,43,102},{0,1,1,1,43,103},{0,1,1,1,43,104},{0,1,1,1,43,108},{0,1,1,1,43,109},{0,1,1,1,43,110},{0,1,1,1,43,112},{0,1,1,1,43,114},{0,1,1,1,43,117},{17,0,0,1,0,43},{18,0,0,1,0,43},{19,0,0,1,0,43},{20,0,0,1,0,43},{21,0,0,1,0,43},{22,0,0,1,0,43},{23,0,0,1,0,43},{24,0,0,1,0,43},{25,0,0,1,0,43},{26,0,0,1,0,43},{27,0,0,1,0,43},{28,0,0,1,0,43},{29,0,0,1,0,43},{30,0,0,1,0,43},{31,0,0,1,0,43},{32,0,0,1,0,43},{33,0,0,1,0,43},{34,1,0,1,0,43},{13,0,1,1,124,48},{14,1,1,1,124,48},{13,0,1,1,124,49},{14,1,1,1,124,49},{13,0,1,1,124,50},{14,1,1,1,124,50},{13,0,1,1,124,97},{14,1,1,1,124,97},{13,0,1,1,124,99},{14,1,1,1,124,99},{13,0,1,1,124,101},{14,1,1,1,124,101},{13,0,1,1,124,105},{14,1,1,1,124,105},{13,0,1,1,124,111},{14,1,1,1,124,111},{13,0,1,1,124,115},{14,1,1,1,124,115},{13,0,1,1,124,116},{14,1,1,1,124,116},{0,1,1,1,124,32},{0,1,1,1,124,37},{0,1,1,1,124,45},{0,1,1,1,124,46},{0,1,1,1,124,47},{0,1,1,1,124,51},{0,1,1,1,124,52},{0,1,1,1,124,53},{0,1,1,1,124,54},{0,1,1,1,124,55},{0,1,1,1,124,56},{0,1,1,1,124,57},{0,1,1,1,124,61},{0,1,1,1,124,65},{0,1,1,1,124,95},{0,1,1,1,124,98},{0,1,1,1,124,100},{0,1,1,1,124,102},{0,1,1,1,124,103},{0,1,1,1,124,104},{0,1,1,1,124,108},{0,1,1,1,124,109},{0,1,1,1,124,110},{0,1,1,1,124,112},{0,1,1,1,124,114},{0,1,1,1,124,117},{17,0,0,1,0,124},{18,0,0,1,0,124},{19,0,0,1,0,124},{20,0,0,1,0,124},{21,0,0,1,0,124},{22,0,0,1,0,124},{23,0,0,1,0,124},{24,0,0,1,0,124},{25,0,0,1,0,124},{26,0,0,1,0,124},{27,0,0,1,0,124},{28,0,0,1,0,124},{29,0,0,1,0,124},{30,0,0,1,0,124},{31,0,0,1,0,124},{32,0,0,1,0,124},{33,0,0,1,0,124},{34,1,0,1,0,124},{0,1,1,1,35,48},{0,1,1,1,35,49},{0,1,1,1,35,50},{0,1,1,1,35,97},{0,1,1,1,35,99},{0,1,1,1,35,101},{0,1,1,1,35,105},{0,1,1,1,35,111},{0,1,1,1,35,115},{0,1,1,1,35,116},{35,0,0,1,0,35},{36,0,0,1,0,35},{37,0,0,1,0,35},{38,0,0,1,0,35},{39,0,0,1,0,35},{40,0,0,1,0,35},{41,0,0,1,0,35},{42,0,0,1,0,35},{43,0,0,1,0,35},{44,0,0,1,0,35},{45,0,0,1,0,35},{46,0,0,1,0,35},{47,0,0,1,0,35},{48,0,0,1,0,35},{49,0,0,1,0,35},{50,0,0,1,0,35},{51,0,0,1,0,35},{52,0,0,1,0,35},{53,0,0,1,0,35},{54,0,0,1,0,35},{55,0,0,1,0,35},{56,1,0,1,0,35},{0,1,1,1,62,48},{0,1,1,1,62,49},{0,1,1,1,62,50},{0,1,1,1,62,97},{0,1,1,1,62,99},{0,1,1,1,62,101},{0,1,1,1,62,105},{0,1,1,1,62,111},{0,1,1,1,62,115},{0,1,1,1,62,116},{35,0,0,1,0,62},{36,0,0,1,0,62},{37,0,0,1,0,62},{38,0,0,1,0,62},{39,0,0,1,0,62},{40,0,0,1,0,62},{41,0,0,1,0,62},{42,0,0,1,0,62},{43,0,0,1,0,62},{44,0,0,1,0,62},{45,0,0,1,0,62},{46,0,0,1,0,62},{47,0,0,1,0,62},{48,0,0,1,0,62},{49,0,0,1,0,62},{50,0,0,1,0,62},{51,0,0,1,0,62},{52,0,0,1,0,62},{53,0,0,1,0,62},{54,0,0,1,0,62},{55,0,0,1,0,62},{56,1,0,1,0,62},{57,0,0,1,0,0},{58,0,0,1,0,0},{59,0,0,1,0,0},{60,0,0,1,0,0},{61,0,0,1,0,0},{62,0,0,1,0,0},{63,0,0,1,0,0},{64,0,0,1,0,0},{65,0,0,1,0,0},{66,0,0,1,0,0},{67,0,0,1,0,0},{68,0,0,1,0,0},{69,0,0,1,0,0},{70,0,0,1,0,0},{71,0,0,1,0,0},{72,1,0,1,0,0},{57,0,0,1,0,36},{58,0,0,1,0,36},{59,0,0,1,0,36},{60,0,0,1,0,36},{61,0,0,1,0,36},{62,0,0,1,0,36},{63,0,0,1,0,36},{64,0,0,1,0,36},{65,0,0,1,0,36},{66,0,0,1,0,36},{67,0,0,1,0,36},{68,0,0,1,0,36},{69,0,0,1,0,36},{70,0,0,1,0,36},{71,0,0,1,0,36},{72,1,0,1,0,36},{57,0,0,1,0,64},{58,0,0,1,0,64},{59,0,0,1,0,64},{60,0,0,1,0,64},{61,0,0,1,0,64},{62,0,0,1,0,64},{63,0,0,1,0,64},{64,0,0,1,0,64},{65,0,0,1,0,64},{66,0,0,1,0,64},{67,0,0,1,0,64},{68,0,0,1,0,64},{69,0,0,1,0,64},{70,0,0,1,0,64},{71,0,0,1,0,64},{72,1,0,1,0,64},{57,0,0,1,0,91},{58,0,0,1,0,91},{59,0,0,1,0,91},{60,0,0,1,0,91},{61,0,0,1,0,91},{62,0,0,1,0,91},{63,0,0,1,0,91},{64,0,0,1,0,91},{65,0,0,1,0,91},{66,0,0,1,0,91},{67,0,0,1,0,91},{68,0,0,1,0,91},{69,0,0,1,0,91},{70,0,0,1,0,91},{71,0,0,1,0,91},{72,1,0,1,0,91},{57,0,0,1,0,93},{58,0,0,1,0,93},{59,0,0,1,0,93},{60,0,0,1,0,93},{61,0,0,1,0,93},{62,0,0,1,0,93},{63,0,0,1,0,93},{64,0,0,1,0,93},{65,0,0,1,0,93},{66,0,0,1,0,93},{67,0,0,1,0,93},{68,0,0,1,0,93},{69,0,0,1,0,93},{70,0,0,1,0,93},{71,0,0,1,0,93},{72,1,0,1,0,93},{57,0,0,1,0,126},{58,0,0,1,0,126},{59,0,0,1,0,126},{60,0,0,1,0,126},{61,0,0,1,0,126},{62,0,0,1,0,126},{63,0,0,1,0,126},{64,0,0,1,0,126},{65,0,0,1,0,126},{66,0,0,1,0,126},{67,0,0,1,0,126},{68,0,0,1,0,126},{69,0,0,1,0,126},{70,0,0,1,0,126},{71,0,0,1,0,126},{72,1,0,1,0,126},{1,0,0,1,0,94},{2,0,0,1,0,94},{3,0,0,1,0,94},{4,0,0,1,0,94},{5,0,0,1,0,94},{6,0,0,1,0,94},{7,0,0,1,0,94},{8,1,0,1,0,94},{1,0,0,1,0,125},{2,0,0,1,0,125},{3,0,0,1,0,125},{4,0,0,1,0,125},{5,0,0,1,0,125},{6,0,0,1,0,125},{7,0,0,1,0,125},{8,1,0,1,0,125},{9,0,0,1,0,60},{10,0,0,1,0,60},{11,0,0,1,0,60},{12,1,0,1,0,60},{9,0,0,1,0,96},{10,0,0,1,0,96},{11,0,0,1,0,96},{12,1,0,1,0,96},{9,0,0,1,0,123},{10,0,0,1,0,123},{11,0,0,1,0,123},{12,1,0,1,0,123},{118,0,0,0,0,0},{119,0,0,0,0,0},{120,0,0,0,0,0},{121,0,0,0,0,0},{0,1,1,1,92,48},{0,1,1,1,92,49},{0,1,1,1,92,50},{0,1,1,1,92,97},{0,1,1,1,92,99},{0,1,1,1,92,101},{0,1,1,1,92,105},{0,1,1,1,92,111},{0,1,1,1,92,115},{0,1,1,1,92,116},{35,0,0,1,0,92},{36,0,0,1,0,92},{37,0,0,1,0,92},{38,0,0,1,0,92},{39,0,0,1,0,92},{40,0,0,1,0,92},{41,0,0,1,0,92},{42,0,0,1,0,92},{43,0,0,1,0,92},{44,0,0,1,0,92},{45,0,0,1,0,92},{46,0,0,1,0,92},{47,0,0,1,0,92},{48,0,0,1,0,92},{49,0,0,1,0,92},{50,0,0,1,0,92},{51,0,0,1,0,92},{52,0,0,1,0,92},{53,0,0,1,0,92},{54,0,0,1,0,92},{55,0,0,1,0,92},{56,1,0,1,0,92},{0,1,1,1,195,48},{0,1,1,1,195,49},{0,1,1,1,195,50},{0,1,1,1,195,97},{0,1,1,1,195,99},{0,1,1,1,195,101},{0,1,1,1,195,105},{0,1,1,1,195,111},{0,1,1,1,195,115},{0,1,1,1,195,116},{35,0,0,1,0,195},{36,0,0,1,0,195},{37,0,0,1,0,195},{38,0,0,1,0,195},{39,0,0,1,0,195},{40,0,0,1,0,195},{41,0,0,1,0,195},{42,0,0,1,0,195},{43,0,0,1,0,195},{44,0,0,1,0,195},{45,0,0,1,0,195},{46,0,0,1,0,195},{47,0,0,1,0,195},{48,0,0,1,0,195},{49,0,0,1,0,195},{50,0,0,1,0,195},{51,0,0,1,0,195},{52,0,0,1,0,195},{53,0,0,1,0,195},{54,0,0,1,0,195},{55,0,0,1,0,195},{56,1,0,1,0,195},{0,1,1,1,208,48},{0,1,1,1,208,49},{0,1,1,1,208,50},{0,1,1,1,208,97},{0,1,1,1,208,99},{0,1,1,1,208,101},{0,1,1,1,208,105},{0,1,1,1,208,111},{0,1,1,1,208,115},{0,1,1,1,208,116},{35,0,0,1,0,208},{36,0,0,1,0,208},{37,0,0,1,0,208},{38,0,0,1,0,208},{39,0,0,1,0,208},{40,0,0,1,0,208},{41,0,0,1,0,208},{42,0,0,1,0,208},{43,0,0,1,0,208},{44,0,0,1,0,208},{45,0,0,1,0,208},{46,0,0,1,0,208},{47,0,0,1,0,208},{48,0,0,1,0,208},{49,0,0,1,0,208},{50,0,0,1,0,208},{51,0,0,1,0,208},{52,0,0,1,0,208},{53,0,0,1,0,208},{54,0,0,1,0,208},{55,0,0,1,0,208},{56,1,0,1,0,208},{57,0,0,1,0,128},{58,0,0,1,0,128},{59,0,0,1,0,128},{60,0,0,1,0,128},{61,0,0,1,0,128},{62,0,0,1,0,128},{63,0,0,1,0,128},{64,0,0,1,0,128},{65,0,0,1,0,128},{66,0,0,1,0,128},{67,0,0,1,0,128},{68,0,0,1,0,128},{69,0,0,1,0,128},{70,0,0,1,0,128},{71,0,0,1,0,128},{72,1,0,1,0,128},{57,0,0,1,0,130},{58,0,0,1,0,130},{59,0,0,1,0,130},{60,0,0,1,0,130},{61,0,0,1,0,130},{62,0,0,1,0,130},{63,0,0,1,0,130},{64,0,0,1,0,130},{65,0,0,1,0,130},{66,0,0,1,0,130},{67,0,0,1,0,130},{68,0,0,1,0,130},{69,0,0,1,0,130},{70,0,0,1,0,130},{71,0,0,1,0,130},{72,1,0,1,0,130},{57,0,0,1,0,131},{58,0,0,1,0,131},{59,0,0,1,0,131},{60,0,0,1,0,131},{61,0,0,1,0,131},{62,0,0,1,0,131},{63,0,0,1,0,131},{64,0,0,1,0,131},{65,0,0,1,0,131},{66,0,0,1,0,131},{67,0,0,1,0,131},{68,0,0,1,0,131},{69,0,0,1,0,131},{70,0,0,1,0,131},{71,0,0,1,0,131},{72,1,0,1,0,131},{57,0,0,1,0,162},{58,0,0,1,0,162},{59,0,0,1,0,162},{60,0,0,1,0,162},{61,0,0,1,0,162},{62,0,0,1,0,162},{63,0,0,1,0,162},{64,0,0,1,0,162},{65,0,0,1,0,162},{66,0,0,1,0,162},{67,0,0,1,0,162},{68,0,0,1,0,162},{69,0,0,1,0,162},{70,0,0,1,0,162},{71,0,0,1,0,162},{72,1,0,1,0,162},{57,0,0,1,0,184},{58,0,0,1,0,184},{59,0,0,1,0,184},{60,0,0,1,0,184},{61,0,0,1,0,184},{62,0,0,1,0,184},{63,0,0,1,0,184},{64,0,0,1,0,184},{65,0,0,1,0,184},{66,0,0,1,0,184},{67,0,0,1,0,184},{68,0,0,1,0,184},{69,0,0,1,0,184},{70,0,0,1,0,184},{71,0,0,1,0,184},{72,1,0,1,0,184},{57,0,0,1,0,194},{58,0,0,1,0,194},{59,0,0,1,0,194},{60,0,0,1,0,194},{61,0,0,1,0,194},{62,0,0,1,0,194},{63,0,0,1,0,194},{64,0,0,1,0,194},{65,0,0,1,0,194},{66,0,0,1,0,194},{67,0,0,1,0,194},{68,0,0,1,0,194},{69,0,0,1,0,194},{70,0,0,1,0,194},{71,0,0,1,0,194},{72,1,0,1,0,194},{57,0,0,1,0,224},{58,0,0,1,0,224},{59,0,0,1,0,224},{60,0,0,1,0,224},{61,0,0,1,0,224},{62,0,0,1,0,224},{63,0,0,1,0,224},{64,0,0,1,0,224},{65,0,0,1,0,224},{66,0,0,1,0,224},{67,0,0,1,0,224},{68,0,0,1,0,224},{69,0,0,1,0,224},{70,0,0,1,0,224},{71,0,0,1,0,224},{72,1,0,1,0,224},{57,0,0,1,0,226},{58,0,0,1,0,226},{59,0,0,1,0,226},{60,0,0,1,0,226},{61,0,0,1,0,226},{62,0,0,1,0,226},{63,0,0,1,0,226},{64,0,0,1,0,226},{65,0,0,1,0,226},{66,0,0,1,0,226},{67,0,0,1,0,226},{68,0,0,1,0,226},{69,0,0,1,0,226},{70,0,0,1,0,226},{71,0,0,1,0,226},{72,1,0,1,0,226},{1,0,0,1,0,153},{2,0,0,1,0,153},{3,0,0,1,0,153},{4,0,0,1,0,153},{5,0,0,1,0,153},{6,0,0,1,0,153},{7,0,0,1,0,153},{8,1,0,1,0,153},{1,0,0,1,0,161},{2,0,0,1,0,161},{3,0,0,1,0,161},{4,0,0,1,0,161},{5,0,0,1,0,161},{6,0,0,1,0,161},{7,0,0,1,0,161},{8,1,0,1,0,161},{1,0,0,1,0,167},{2,0,0,1,0,167},{3,0,0,1,0,167},{4,0,0,1,0,167},{5,0,0,1,0,167},{6,0,0,1,0,167},{7,0,0,1,0,167},{8,1,0,1,0,167},{1,0,0,1,0,172},{2,0,0,1,0,172},{3,0,0,1,0,172},{4,0,0,1,0,172},{5,0,0,1,0,172},{6,0,0,1,0,172},{7,0,0,1,0,172},{8,1,0,1,0,172},{1,0,0,1,0,176},{2,0,0,1,0,176},{3,0,0,1,0,176},{4,0,0,1,0,176},{5,0,0,1,0,176},{6,0,0,1,0,176},{7,0,0,1,0,176},{8,1,0,1,0,176},{1,0,0,1,0,177},{2,0,0,1,0,177},{3,0,0,1,0,177},{4,0,0,1,0,177},{5,0,0,1,0,177},{6,0,0,1,0,177},{7,0,0,1,0,177},{8,1,0,1,0,177},{1,0,0,1,0,179},{2,0,0,1,0,179},{3,0,0,1,0,179},{4,0,0,1,0,179},{5,0,0,1,0,179},{6,0,0,1,0,179},{7,0,0,1,0,179},{8,1,0,1,0,179},{1,0,0,1,0,209},{2,0,0,1,0,209},{3,0,0,1,0,209},{4,0,0,1,0,209},{5,0,0,1,0,209},{6,0,0,1,0,209},{7,0,0,1,0,209},{8,1,0,1,0,209},{1,0,0,1,0,216},{2,0,0,1,0,216},{3,0,0,1,0,216},{4,0,0,1,0,216},{5,0,0,1,0,216},{6,0,0,1,0,216},{7,0,0,1,0,216},{8,1,0,1,0,216},{1,0,0,1,0,217},{2,0,0,1,0,217},{3,0,0,1,0,217},{4,0,0,1,0,217},{5,0,0,1,0,217},{6,0,0,1,0,217},{7,0,0,1,0,217},{8,1,0,1,0,217},{1,0,0,1,0,227},{2,0,0,1,0,227},{3,0,0,1,0,227},{4,0,0,1,0,227},{5,0,0,1,0,227},{6,0,0,1,0,227},{7,0,0,1,0,227},{8,1,0,1,0,227},{1,0,0,1,0,229},{2,0,0,1,0,229},{3,0,0,1,0,229},{4,0,0,1,0,229},{5,0,0,1,0,229},{6,0,0,1,0,229},{7,0,0,1,0,229},{8,1,0,1,0,229},{1,0,0,1,0,230},{2,0,0,1,0,230},{3,0,0,1,0,230},{4,0,0,1,0,230},{5,0,0,1,0,230},{6,0,0,1,0,230},{7,0,0,1,0,230},{8,1,0,1,0,230},{9,0,0,1,0,129},{10,0,0,1,0,129},{11,0,0,1,0,129},{12,1,0,1,0,129},{9,0,0,1,0,132},{10,0,0,1,0,132},{11,0,0,1,0,132},{12,1,0,1,0,132},{9,0,0,1,0,133},{10,0,0,1,0,133},{11,0,0,1,0,133},{12,1,0,1,0,133},{9,0,0,1,0,134},{10,0,0,1,0,134},{11,0,0,1,0,134},{12,1,0,1,0,134},{9,0,0,1,0,136},{10,0,0,1,0,136},{11,0,0,1,0,136},{12,1,0,1,0,136},{9,0,0,1,0,146},{10,0,0,1,0,146},{11,0,0,1,0,146},{12,1,0,1,0,146},{9,0,0,1,0,154},{10,0,0,1,0,154},{11,0,0,1,0,154},{12,1,0,1,0,154},{9,0,0,1,0,156},{10,0,0,1,0,156},{11,0,0,1,0,156},{12,1,0,1,0,156},{9,0,0,1,0,160},{10,0,0,1,0,160},{11,0,0,1,0,160},{12,1,0,1,0,160},{9,0,0,1,0,163},{10,0,0,1,0,163},{11,0,0,1,0,163},{12,1,0,1,0,163},{9,0,0,1,0,164},{10,0,0,1,0,164},{11,0,0,1,0,164},{12,1,0,1,0,164},{9,0,0,1,0,169},{10,0,0,1,0,169},{11,0,0,1,0,169},{12,1,0,1,0,169},{9,0,0,1,0,170},{10,0,0,1,0,170},{11,0,0,1,0,170},{12,1,0,1,0,170},{9,0,0,1,0,173},{10,0,0,1,0,173},{11,0,0,1,0,173},{12,1,0,1,0,173},{9,0,0,1,0,178},{10,0,0,1,0,178},{11,0,0,1,0,178},{12,1,0,1,0,178},{9,0,0,1,0,181},{10,0,0,1,0,181},{11,0,0,1,0,181},{12,1,0,1,0,181},{9,0,0,1,0,185},{10,0,0,1,0,185},{11,0,0,1,0,185},{12,1,0,1,0,185},{9,0,0,1,0,186},{10,0,0,1,0,186},{11,0,0,1,0,186},{12,1,0,1,0,186},{9,0,0,1,0,187},{10,0,0,1,0,187},{11,0,0,1,0,187},{12,1,0,1,0,187},{9,0,0,1,0,189},{10,0,0,1,0,189},{11,0,0,1,0,189},{12,1,0,1,0,189},{9,0,0,1,0,190},{10,0,0,1,0,190},{11,0,0,1,0,190},{12,1,0,1,0,190},{9,0,0,1,0,196},{10,0,0,1,0,196},{11,0,0,1,0,196},{12,1,0,1,0,196},{9,0,0,1,0,198},{10,0,0,1,0,198},{11,0,0,1,0,198},{12,1,0,1,0,198},{9,0,0,1,0,228},{10,0,0,1,0,228},{11,0,0,1,0,228},{12,1,0,1,0,228},{9,0,0,1,0,232},{10,0,0,1,0,232},{11,0,0,1,0,232},{12,1,0,1,0,232},{9,0,0,1,0,233},{10,0,0,1,0,233},{11,0,0,1,0,233},{12,1,0,1,0,233},{13,0,0,1,0,1},{14,1,0,1,0,1},{13,0,0,1,0,135},{14,1,0,1,0,135},{13,0,0,1,0,137},{14,1,0,1,0,137},{13,0,0,1,0,138},{14,1,0,1,0,138},{13,0,0,1,0,139},{14,1,0,1,0,139},{13,0,0,1,0,140},{14,1,0,1,0,140},{13,0,0,1,0,141},{14,1,0,1,0,141},{13,0,0,1,0,143},{14,1,0,1,0,143},{13,0,0,1,0,147},{14,1,0,1,0,147},{13,0,0,1,0,149},{14,1,0,1,0,149},{13,0,0,1,0,150},{14,1,0,1,0,150},{13,0,0,1,0,151},{14,1,0,1,0,151},{13,0,0,1,0,152},{14,1,0,1,0,152},{13,0,0,1,0,155},{14,1,0,1,0,155},{13,0,0,1,0,157},{14,1,0,1,0,157},{13,0,0,1,0,158},{14,1,0,1,0,158},{13,0,0,1,0,165},{14,1,0,1,0,165},{13,0,0,1,0,166},{14,1,0,1,0,166},{13,0,0,1,0,168},{14,1,0,1,0,168},{13,0,0,1,0,174},{14,1,0,1,0,174},{13,0,0,1,0,175},{14,1,0,1,0,175},{13,0,0,1,0,180},{14,1,0,1,0,180},{13,0,0,1,0,182},{14,1,0,1,0,182},{13,0,0,1,0,183},{14,1,0,1,0,183},{13,0,0,1,0,188},{14,1,0,1,0,188},{13,0,0,1,0,191},{14,1,0,1,0,191},{13,0,0,1,0,197},{14,1,0,1,0,197},{13,0,0,1,0,231},{14,1,0,1,0,231},{13,0,0,1,0,239},{14,1,0,1,0,239},{0,1,0,1,0,9},{0,1,0,1,0,142},{0,1,0,1,0,144},{0,1,0,1,0,145},{0,1,0,1,0,148},{0,1,0,1,0,159},{0,1,0,1,0,171},{0,1,0,1,0,206},{0,1,0,1,0,215},{0,1,0,1,0,225},{0,1,0,1,0,236},{0,1,0,1,0,237},{122,0,0,0,0,0},{123,0,0,0,0,0},{124,0,0,0,0,0},{125,0,0,0,0,0},{126,0,0,0,0,0},{127,0,0,0,0,0},{128,0,0,0,0,0},{129,0,0,0,0,0},{130,0,0,0,0,0},{131,0,0,0,0,0},{9,0,1,1,38,48},{10,0,1,1,38,48},{11,0,1,1,38,48},{12,1,1,1,38,48},{9,0,1,1,38,49},{10,0,1,1,38,49},{11,0,1,1,38,49},{12,1,1,1,38,49},{9,0,1,1,38,50},{10,0,1,1,38,50},{11,0,1,1,38,50},{12,1,1,1,38,50},{9,0,1,1,38,97},{10,0,1,1,38,97},{11,0,1,1,38,97},{12,1,1,1,38,97},{9,0,1,1,38,99},{10,0,1,1,38,99},{11,0,1,1,38,99},{12,1,1,1,38,99},{9,0,1,1,38,101},{10,0,1,1,38,101},{11,0,1,1,38,101},{12,1,1,1,38,101},{9,0,1,1,38,105},{10,0,1,1,38,105},{11,0,1,1,38,105},{12,1,1,1,38,105},{9,0,1,1,38,111},{10,0,1,1,38,111},{11,0,1,1,38,111},{12,1,1,1,38,111},{9,0,1,1,38,115},{10,0,1,1,38,115},{11,0,1,1,38,115},{12,1,1,1,38,115},{9,0,1,1,38,116},{10,0,1,1,38,116},{11,0,1,1,38,116},{12,1,1,1,38,116},{13,0,1,1,38,32},{14,1,1,1,38,32},{13,0,1,1,38,37},{14,1,1,1,38,37},{13,0,1,1,38,45},{14,1,1,1,38,45},{13,0,1,1,38,46},{14,1,1,1,38,46},{13,0,1,1,38,47},{14,1,1,1,38,47},{13,0,1,1,38,51},{14,1,1,1,38,51},{13,0,1,1,38,52},{14,1,1,1,38,52},{13,0,1,1,38,53},{14,1,1,1,38,53},{13,0,1,1,38,54},{14,1,1,1,38,54},{13,0,1,1,38,55},{14,1,1,1,38,55},{13,0,1,1,38,56},{14,1,1,1,38,56},{13,0,1,1,38,57},{14,1,1,1,38,57},{13,0,1,1,38,61},{14,1,1,1,38,61},{13,0,1,1,38,65},{14,1,1,1,38,65},{13,0,1,1,38,95},{14,1,1,1,38,95},{13,0,1,1,38,98},{14,1,1,1,38,98},{13,0,1,1,38,100},{14,1,1,1,38,100},{13,0,1,1,38,102},{14,1,1,1,38,102},{13,0,1,1,38,103},{14,1,1,1,38,103},{13,0,1,1,38,104},{14,1,1,1,38,104},{13,0,1,1,38,108},{14,1,1,1,38,108},{13,0,1,1,38,109},{14,1,1,1,38,109},{13,0,1,1,38,110},{14,1,1,1,38,110},{13,0,1,1,38,112},{14,1,1,1,38,112},{13,0,1,1,38,114},{14,1,1,1,38,114},{13,0,1,1,38,117},{14,1,1,1,38,117},{0,1,1,1,38,58},{0,1,1,1,38,66},{0,1,1,1,38,67},{0,1,1,1,38,68},{0,1,1,1,38,69},{0,1,1,1,38,70},{0,1,1,1,38,71},{0,1,1,1,38,72},{0,1,1,1,38,73},{0,1,1,1,38,74},{0,1,1,1,38,75},{0,1,1,1,38,76},{0,1,1,1,38,77},{0,1,1,1,38,78},{0,1,1,1,38,79},{0,1,1,1,38,80},{0,1,1,1,38,81},{0,1,1,1,38,82},{0,1,1,1,38,83},{0,1,1,1,38,84},{0,1,1,1,38,85},{0,1,1,1,38,86},{0,1,1,1,38,87},{0,1,1,1,38,89},{0,1,1,1,38,106},{0,1,1,1,38,107},{0,1,1,1,38,113},{0,1,1,1,38,118},{0,1,1,1,38,119},{0,1,1,1,38,120},{0,1,1,1,38,121},{0,1,1,1,38,122},{85,0,0,1,0,38},{86,0,0,1,0,38},{87,0,0,1,0,38},{88,1,0,1,0,38},{9,0,1,1,42,48},{10,0,1,1,42,48},{11,0,1,1,42,48},{12,1,1,1,42,48},{9,0,1,1,42,49},{10,0,1,1,42,49},{11,0,1,1,42,49},{12,1,1,1,42,49},{9,0,1,1,42,50},{10,0,1,1,42,50},{11,0,1,1,42,50},{12,1,1,1,42,50},{9,0,1,1,42,97},{10,0,1,1,42,97},{11,0,1,1,42,97},{12,1,1,1,42,97},{9,0,1,1,42,99},{10,0,1,1,42,99},{11,0,1,1,42,99},{12,1,1,1,42,99},{9,0,1,1,42,101},{10,0,1,1,42,101},{11,0,1,1,42,101},{12,1,1,1,42,101},{9,0,1,1,42,105},{10,0,1,1,42,105},{11,0,1,1,42,105},{12,1,1,1,42,105},{9,0,1,1,42,111},{10,0,1,1,42,111},{11,0,1,1,42,111},{12,1,1,1,42,111},{9,0,1,1,42,115},{10,0,1,1,42,115},{11,0,1,1,42,115},{12,1,1,1,42,115},{9,0,1,1,42,116},{10,0,1,1,42,116},{11,0,1,1,42,116},{12,1,1,1,42,116},{13,0,1,1,42,32},{14,1,1,1,42,32},{13,0,1,1,42,37},{14,1,1,1,42,37},{13,0,1,1,42,45},{14,1,1,1,42,45},{13,0,1,1,42,46},{14,1,1,1,42,46},{13,0,1,1,42,47},{14,1,1,1,42,47},{13,0,1,1,42,51},{14,1,1,1,42,51},{13,0,1,1,42,52},{14,1,1,1,42,52},{13,0,1,1,42,53},{14,1,1,1,42,53},{13,0,1,1,42,54},{14,1,1,1,42,54},{13,0,1,1,42,55},{14,1,1,1,42,55},{13,0,1,1,42,56},{14,1,1,1,42,56},{13,0,1,1,42,57},{14,1,1,1,42,57},{13,0,1,1,42,61},{14,1,1,1,42,61},{13,0,1,1,42,65},{14,1,1,1,42,65},{13,0,1,1,42,95},{14,1,1,1,42,95},{13,0,1,1,42,98},{14,1,1,1,42,98},{13,0,1,1,42,100},{14,1,1,1,42,100},{13,0,1,1,42,102},{14,1,1,1,42,102},{13,0,1,1,42,103},{14,1,1,1,42,103},{13,0,1,1,42,104},{14,1,1,1,42,104},{13,0,1,1,42,108},{14,1,1,1,42,108},{13,0,1,1,42,109},{14,1,1,1,42,109},{13,0,1,1,42,110},{14,1,1,1,42,110},{13,0,1,1,42,112},{14,1,1,1,42,112},{13,0,1,1,42,114},{14,1,1,1,42,114},{13,0,1,1,42,117},{14,1,1,1,42,117},{0,1,1,1,42,58},{0,1,1,1,42,66},{0,1,1,1,42,67},{0,1,1,1,42,68},{0,1,1,1,42,69},{0,1,1,1,42,70},{0,1,1,1,42,71},{0,1,1,1,42,72},{0,1,1,1,42,73},{0,1,1,1,42,74},{0,1,1,1,42,75},{0,1,1,1,42,76},{0,1,1,1,42,77},{0,1,1,1,42,78},{0,1,1,1,42,79},{0,1,1,1,42,80},{0,1,1,1,42,81},{0,1,1,1,42,82},{0,1,1,1,42,83},{0,1,1,1,42,84},{0,1,1,1,42,85},{0,1,1,1,42,86},{0,1,1,1,42,87},{0,1,1,1,42,89},{0,1,1,1,42,106},{0,1,1,1,42,107},{0,1,1,1,42,113},{0,1,1,1,42,118},{0,1,1,1,42,119},{0,1,1,1,42,120},{0,1,1,1,42,121},{0,1,1,1,42,122},{85,0,0,1,0,42},{86,0,0,1,0,42},{87,0,0,1,0,42},{88,1,0,1,0,42},{9,0,1,1,44,48},{10,0,1,1,44,48},{11,0,1,1,44,48},{12,1,1,1,44,48},{9,0,1,1,44,49},{10,0,1,1,44,49},{11,0,1,1,44,49},{12,1,1,1,44,49},{9,0,1,1,44,50},{10,0,1,1,44,50},{11,0,1,1,44,50},{12,1,1,1,44,50},{9,0,1,1,44,97},{10,0,1,1,44,97},{11,0,1,1,44,97},{12,1,1,1,44,97},{9,0,1,1,44,99},{10,0,1,1,44,99},{11,0,1,1,44,99},{12,1,1,1,44,99},{9,0,1,1,44,101},{10,0,1,1,44,101},{11,0,1,1,44,101},{12,1,1,1,44,101},{9,0,1,1,44,105},{10,0,1,1,44,105},{11,0,1,1,44,105},{12,1,1,1,44,105},{9,0,1,1,44,111},{10,0,1,1,44,111},{11,0,1,1,44,111},{12,1,1,1,44,111},{9,0,1,1,44,115},{10,0,1,1,44,115},{11,0,1,1,44,115},{12,1,1,1,44,115},{9,0,1,1,44,116},{10,0,1,1,44,116},{11,0,1,1,44,116},{12,1,1,1,44,116},{13,0,1,1,44,32},{14,1,1,1,44,32},{13,0,1,1,44,37},{14,1,1,1,44,37},{13,0,1,1,44,45},{14,1,1,1,44,45},{13,0,1,1,44,46},{14,1,1,1,44,46},{13,0,1,1,44,47},{14,1,1,1,44,47},{13,0,1,1,44,51},{14,1,1,1,44,51},{13,0,1,1,44,52},{14,1,1,1,44,52},{13,0,1,1,44,53},{14,1,1,1,44,53},{13,0,1,1,44,54},{14,1,1,1,44,54},{13,0,1,1,44,55},{14,1,1,1,44,55},{13,0,1,1,44,56},{14,1,1,1,44,56},{13,0,1,1,44,57},{14,1,1,1,44,57},{13,0,1,1,44,61},{14,1,1,1,44,61},{13,0,1,1,44,65},{14,1,1,1,44,65},{13,0,1,1,44,95},{14,1,1,1,44,95},{13,0,1,1,44,98},{14,1,1,1,44,98},{13,0,1,1,44,100},{14,1,1,1,44,100},{13,0,1,1,44,102},{14,1,1,1,44,102},{13,0,1,1,44,103},{14,1,1,1,44,103},{13,0,1,1,44,104},{14,1,1,1,44,104},{13,0,1,1,44,108},{14,1,1,1,44,108},{13,0,1,1,44,109},{14,1,1,1,44,109},{13,0,1,1,44,110},{14,1,1,1,44,110},{13,0,1,1,44,112},{14,1,1,1,44,112},{13,0,1,1,44,114},{14,1,1,1,44,114},{13,0,1,1,44,117},{14,1,1,1,44,117},{0,1,1,1,44,58},{0,1,1,1,44,66},{0,1,1,1,44,67},{0,1,1,1,44,68},{0,1,1,1,44,69},{0,1,1,1,44,70},{0,1,1,1,44,71},{0,1,1,1,44,72},{0,1,1,1,44,73},{0,1,1,1,44,74},{0,1,1,1,44,75},{0,1,1,1,44,76},{0,1,1,1,44,77},{0,1,1,1,44,78},{0,1,1,1,44,79},{0,1,1,1,44,80},{0,1,1,1,44,81},{0,1,1,1,44,82},{0,1,1,1,44,83},{0,1,1,1,44,84},{0,1,1,1,44,85},{0,1,1,1,44,86},{0,1,1,1,44,87},{0,1,1,1,44,89},{0,1,1,1,44,106},{0,1,1,1,44,107},{0,1,1,1,44,113},{0,1,1,1,44,118},{0,1,1,1,44,119},{0,1,1,1,44,120},{0,1,1,1,44,121},{0,1,1,1,44,122},{85,0,0,1,0,44},{86,0,0,1,0,44},{87,0,0,1,0,44},{88,1,0,1,0,44},{9,0,1,1,59,48},{10,0,1,1,59,48},{11,0,1,1,59,48},{12,1,1,1,59,48},{9,0,1,1,59,49},{10,0,1,1,59,49},{11,0,1,1,59,49},{12,1,1,1,59,49},{9,0,1,1,59,50},{10,0,1,1,59,50},{11,0,1,1,59,50},{12,1,1,1,59,50},{9,0,1,1,59,97},{10,0,1,1,59,97},{11,0,1,1,59,97},{12,1,1,1,59,97},{9,0,1,1,59,99},{10,0,1,1,59,99},{11,0,1,1,59,99},{12,1,1,1,59,99},{9,0,1,1,59,101},{10,0,1,1,59,101},{11,0,1,1,59,101},{12,1,1,1,59,101},{9,0,1,1,59,105},{10,0,1,1,59,105},{11,0,1,1,59,105},{12,1,1,1,59,105},{9,0,1,1,59,111},{10,0,1,1,59,111},{11,0,1,1,59,111},{12,1,1,1,59,111},{9,0,1,1,59,115},{10,0,1,1,59,115},{11,0,1,1,59,115},{12,1,1,1,59,115},{9,0,1,1,59,116},{10,0,1,1,59,116},{11,0,1,1,59,116},{12,1,1,1,59,116},{13,0,1,1,59,32},{14,1,1,1,59,32},{13,0,1,1,59,37},{14,1,1,1,59,37},{13,0,1,1,59,45},{14,1,1,1,59,45},{13,0,1,1,59,46},{14,1,1,1,59,46},{13,0,1,1,59,47},{14,1,1,1,59,47},{13,0,1,1,59,51},{14,1,1,1,59,51},{13,0,1,1,59,52},{14,1,1,1,59,52},{13,0,1,1,59,53},{14,1,1,1,59,53},{13,0,1,1,59,54},{14,1,1,1,59,54},{13,0,1,1,59,55},{14,1,1,1,59,55},{13,0,1,1,59,56},{14,1,1,1,59,56},{13,0,1,1,59,57},{14,1,1,1,59,57},{13,0,1,1,59,61},{14,1,1,1,59,61},{13,0,1,1,59,65},{14,1,1,1,59,65},{13,0,1,1,59,95},{14,1,1,1,59,95},{13,0,1,1,59,98},{14,1,1,1,59,98},{13,0,1,1,59,100},{14,1,1,1,59,100},{13,0,1,1,59,102},{14,1,1,1,59,102},{13,0,1,1,59,103},{14,1,1,1,59,103},{13,0,1,1,59,104},{14,1,1,1,59,104},{13,0,1,1,59,108},{14,1,1,1,59,108},{13,0,1,1,59,109},{14,1,1,1,59,109},{13,0,1,1,59,110},{14,1,1,1,59,110},{13,0,1,1,59,112},{14,1,1,1,59,112},{13,0,1,1,59,114},{14,1,1,1,59,114},{13,0,1,1,59,117},{14,1,1,1,59,117},{0,1,1,1,59,58},{0,1,1,1,59,66},{0,1,1,1,59,67},{0,1,1,1,59,68},{0,1,1,1,59,69},{0,1,1,1,59,70},{0,1,1,1,59,71},{0,1,1,1,59,72},{0,1,1,1,59,73},{0,1,1,1,59,74},{0,1,1,1,59,75},{0,1,1,1,59,76},{0,1,1,1,59,77},{0,1,1,1,59,78},{0,1,1,1,59,79},{0,1,1,1,59,80},{0,1,1,1,59,81},{0,1,1,1,59,82},{0,1,1,1,59,83},{0,1,1,1,59,84},{0,1,1,1,59,85},{0,1,1,1,59,86},{0,1,1,1,59,87},{0,1,1,1,59,89},{0,1,1,1,59,106},{0,1,1,1,59,107},{0,1,1,1,59,113},{0,1,1,1,59,118},{0,1,1,1,59,119},{0,1,1,1,59,120},{0,1,1,1,59,121},{0,1,1,1,59,122},{85,0,0,1,0,59},{86,0,0,1,0,59},{87,0,0,1,0,59},{88,1,0,1,0,59},{9,0,1,1,88,48},{10,0,1,1,88,48},{11,0,1,1,88,48},{12,1,1,1,88,48},{9,0,1,1,88,49},{10,0,1,1,88,49},{11,0,1,1,88,49},{12,1,1,1,88,49},{9,0,1,1,88,50},{10,0,1,1,88,50},{11,0,1,1,88,50},{12,1,1,1,88,50},{9,0,1,1,88,97},{10,0,1,1,88,97},{11,0,1,1,88,97},{12,1,1,1,88,97},{9,0,1,1,88,99},{10,0,1,1,88,99},{11,0,1,1,88,99},{12,1,1,1,88,99},{9,0,1,1,88,101},{10,0,1,1,88,101},{11,0,1,1,88,101},{12,1,1,1,88,101},{9,0,1,1,88,105},{10,0,1,1,88,105},{11,0,1,1,88,105},{12,1,1,1,88,105},{9,0,1,1,88,111},{10,0,1,1,88,111},{11,0,1,1,88,111},{12,1,1,1,88,111},{9,0,1,1,88,115},{10,0,1,1,88,115},{11,0,1,1,88,115},{12,1,1,1,88,115},{9,0,1,1,88,116},{10,0,1,1,88,116},{11,0,1,1,88,116},{12,1,1,1,88,116},{13,0,1,1,88,32},{14,1,1,1,88,32},{13,0,1,1,88,37},{14,1,1,1,88,37},{13,0,1,1,88,45},{14,1,1,1,88,45},{13,0,1,1,88,46},{14,1,1,1,88,46},{13,0,1,1,88,47},{14,1,1,1,88,47},{13,0,1,1,88,51},{14,1,1,1,88,51},{13,0,1,1,88,52},{14,1,1,1,88,52},{13,0,1,1,88,53},{14,1,1,1,88,53},{13,0,1,1,88,54},{14,1,1,1,88,54},{13,0,1,1,88,55},{14,1,1,1,88,55},{13,0,1,1,88,56},{14,1,1,1,88,56},{13,0,1,1,88,57},{14,1,1,1,88,57},{13,0,1,1,88,61},{14,1,1,1,88,61},{13,0,1,1,88,65},{14,1,1,1,88,65},{13,0,1,1,88,95},{14,1,1,1,88,95},{13,0,1,1,88,98},{14,1,1,1,88,98},{13,0,1,1,88,100},{14,1,1,1,88,100},{13,0,1,1,88,102},{14,1,1,1,88,102},{13,0,1,1,88,103},{14,1,1,1,88,103},{13,0,1,1,88,104},{14,1,1,1,88,104},{13,0,1,1,88,108},{14,1,1,1,88,108},{13,0,1,1,88,109},{14,1,1,1,88,109},{13,0,1,1,88,110},{14,1,1,1,88,110},{13,0,1,1,88,112},{14,1,1,1,88,112},{13,0,1,1,88,114},{14,1,1,1,88,114},{13,0,1,1,88,117},{14,1,1,1,88,117},{0,1,1,1,88,58},{0,1,1,1,88,66},{0,1,1,1,88,67},{0,1,1,1,88,68},{0,1,1,1,88,69},{0,1,1,1,88,70},{0,1,1,1,88,71},{0,1,1,1,88,72},{0,1,1,1,88,73},{0,1,1,1,88,74},{0,1,1,1,88,75},{0,1,1,1,88,76},{0,1,1,1,88,77},{0,1,1,1,88,78},{0,1,1,1,88,79},{0,1,1,1,88,80},{0,1,1,1,88,81},{0,1,1,1,88,82},{0,1,1,1,88,83},{0,1,1,1,88,84},{0,1,1,1,88,85},{0,1,1,1,88,86},{0,1,1,1,88,87},{0,1,1,1,88,89},{0,1,1,1,88,106},{0,1,1,1,88,107},{0,1,1,1,88,113},{0,1,1,1,88,118},{0,1,1,1,88,119},{0,1,1,1,88,120},{0,1,1,1,88,121},{0,1,1,1,88,122},{85,0,0,1,0,88},{86,0,0,1,0,88},{87,0,0,1,0,88},{88,1,0,1,0,88},{9,0,1,1,90,48},{10,0,1,1,90,48},{11,0,1,1,90,48},{12,1,1,1,90,48},{9,0,1,1,90,49},{10,0,1,1,90,49},{11,0,1,1,90,49},{12,1,1,1,90,49},{9,0,1,1,90,50},{10,0,1,1,90,50},{11,0,1,1,90,50},{12,1,1,1,90,50},{9,0,1,1,90,97},{10,0,1,1,90,97},{11,0,1,1,90,97},{12,1,1,1,90,97},{9,0,1,1,90,99},{10,0,1,1,90,99},{11,0,1,1,90,99},{12,1,1,1,90,99},{9,0,1,1,90,101},{10,0,1,1,90,101},{11,0,1,1,90,101},{12,1,1,1,90,101},{9,0,1,1,90,105},{10,0,1,1,90,105},{11,0,1,1,90,105},{12,1,1,1,90,105},{9,0,1,1,90,111},{10,0,1,1,90,111},{11,0,1,1,90,111},{12,1,1,1,90,111},{9,0,1,1,90,115},{10,0,1,1,90,115},{11,0,1,1,90,115},{12,1,1,1,90,115},{9,0,1,1,90,116},{10,0,1,1,90,116},{11,0,1,1,90,116},{12,1,1,1,90,116},{13,0,1,1,90,32},{14,1,1,1,90,32},{13,0,1,1,90,37},{14,1,1,1,90,37},{13,0,1,1,90,45},{14,1,1,1,90,45},{13,0,1,1,90,46},{14,1,1,1,90,46},{13,0,1,1,90,47},{14,1,1,1,90,47},{13,0,1,1,90,51},{14,1,1,1,90,51},{13,0,1,1,90,52},{14,1,1,1,90,52},{13,0,1,1,90,53},{14,1,1,1,90,53},{13,0,1,1,90,54},{14,1,1,1,90,54},{13,0,1,1,90,55},{14,1,1,1,90,55},{13,0,1,1,90,56},{14,1,1,1,90,56},{13,0,1,1,90,57},{14,1,1,1,90,57},{13,0,1,1,90,61},{14,1,1,1,90,61},{13,0,1,1,90,65},{14,1,1,1,90,65},{13,0,1,1,90,95},{14,1,1,1,90,95},{13,0,1,1,90,98},{14,1,1,1,90,98},{13,0,1,1,90,100},{14,1,1,1,90,100},{13,0,1,1,90,102},{14,1,1,1,90,102},{13,0,1,1,90,103},{14,1,1,1,90,103},{13,0,1,1,90,104},{14,1,1,1,90,104},{13,0,1,1,90,108},{14,1,1,1,90,108},{13,0,1,1,90,109},{14,1,1,1,90,109},{13,0,1,1,90,110},{14,1,1,1,90,110},{13,0,1,1,90,112},{14,1,1,1,90,112},{13,0,1,1,90,114},{14,1,1,1,90,114},{13,0,1,1,90,117},{14,1,1,1,90,117},{0,1,1,1,90,58},{0,1,1,1,90,66},{0,1,1,1,90,67},{0,1,1,1,90,68},{0,1,1,1,90,69},{0,1,1,1,90,70},{0,1,1,1,90,71},{0,1,1,1,90,72},{0,1,1,1,90,73},{0,1,1,1,90,74},{0,1,1,1,90,75},{0,1,1,1,90,76},{0,1,1,1,90,77},{0,1,1,1,90,78},{0,1,1,1,90,79},{0,1,1,1,90,80},{0,1,1,1,90,81},{0,1,1,1,90,82},{0,1,1,1,90,83},{0,1,1,1,90,84},{0,1,1,1,90,85},{0,1,1,1,90,86},{0,1,1,1,90,87},{0,1,1,1,90,89},{0,1,1,1,90,106},{0,1,1,1,90,107},{0,1,1,1,90,113},{0,1,1,1,90,118},{0,1,1,1,90,119},{0,1,1,1,90,120},{0,1,1,1,90,121},{0,1,1,1,90,122},{85,0,0,1,0,90},{86,0,0,1,0,90},{87,0,0,1,0,90},{88,1,0,1,0,90},{0,1,1,1,33,48},{0,1,1,1,33,49},{0,1,1,1,33,50},{0,1,1,1,33,97},{0,1,1,1,33,99},{0,1,1,1,33,101},{0,1,1,1,33,105},{0,1,1,1,33,111},{0,1,1,1,33,115},{0,1,1,1,33,116},{35,0,0,1,0,33},{36,0,0,1,0,33},{37,0,0,1,0,33},{38,0,0,1,0,33},{39,0,0,1,0,33},{40,0,0,1,0,33},{41,0,0,1,0,33},{42,0,0,1,0,33},{43,0,0,1,0,33},{44,0,0,1,0,33},{45,0,0,1,0,33},{46,0,0,1,0,33},{47,0,0,1,0,33},{48,0,0,1,0,33},{49,0,0,1,0,33},{50,0,0,1,0,33},{51,0,0,1,0,33},{52,0,0,1,0,33},{53,0,0,1,0,33},{54,0,0,1,0,33},{55,0,0,1,0,33},{56,1,0,1,0,33},{0,1,1,1,34,48},{0,1,1,1,34,49},{0,1,1,1,34,50},{0,1,1,1,34,97},{0,1,1,1,34,99},{0,1,1,1,34,101},{0,1,1,1,34,105},{0,1,1,1,34,111},{0,1,1,1,34,115},{0,1,1,1,34,116},{35,0,0,1,0,34},{36,0,0,1,0,34},{37,0,0,1,0,34},{38,0,0,1,0,34},{39,0,0,1,0,34},{40,0,0,1,0,34},{41,0,0,1,0,34},{42,0,0,1,0,34},{43,0,0,1,0,34},{44,0,0,1,0,34},{45,0,0,1,0,34},{46,0,0,1,0,34},{47,0,0,1,0,34},{48,0,0,1,0,34},{49,0,0,1,0,34},{50,0,0,1,0,34},{51,0,0,1,0,34},{52,0,0,1,0,34},{53,0,0,1,0,34},{54,0,0,1,0,34},{55,0,0,1,0,34},{56,1,0,1,0,34},{0,1,1,1,40,48},{0,1,1,1,40,49},{0,1,1,1,40,50},{0,1,1,1,40,97},{0,1,1,1,40,99},{0,1,1,1,40,101},{0,1,1,1,40,105},{0,1,1,1,40,111},{0,1,1,1,40,115},{0,1,1,1,40,116},{35,0,0,1,0,40},{36,0,0,1,0,40},{37,0,0,1,0,40},{38,0,0,1,0,40},{39,0,0,1,0,40},{40,0,0,1,0,40},{41,0,0,1,0,40},{42,0,0,1,0,40},{43,0,0,1,0,40},{44,0,0,1,0,40},{45,0,0,1,0,40},{46,0,0,1,0,40},{47,0,0,1,0,40},{48,0,0,1,0,40},{49,0,0,1,0,40},{50,0,0,1,0,40},{51,0,0,1,0,40},{52,0,0,1,0,40},{53,0,0,1,0,40},{54,0,0,1,0,40},{55,0,0,1,0,40},{56,1,0,1,0,40},{0,1,1,1,41,48},{0,1,1,1,41,49},{0,1,1,1,41,50},{0,1,1,1,41,97},{0,1,1,1,41,99},{0,1,1,1,41,101},{0,1,1,1,41,105},{0,1,1,1,41,111},{0,1,1,1,41,115},{0,1,1,1,41,116},{35,0,0,1,0,41},{36,0,0,1,0,41},{37,0,0,1,0,41},{38,0,0,1,0,41},{39,0,0,1,0,41},{40,0,0,1,0,41},{41,0,0,1,0,41},{42,0,0,1,0,41},{43,0,0,1,0,41},{44,0,0,1,0,41},{45,0,0,1,0,41},{46,0,0,1,0,41},{47,0,0,1,0,41},{48,0,0,1,0,41},{49,0,0,1,0,41},{50,0,0,1,0,41},{51,0,0,1,0,41},{52,0,0,1,0,41},{53,0,0,1,0,41},{54,0,0,1,0,41},{55,0,0,1,0,41},{56,1,0,1,0,41},{0,1,1,1,63,48},{0,1,1,1,63,49},{0,1,1,1,63,50},{0,1,1,1,63,97},{0,1,1,1,63,99},{0,1,1,1,63,101},{0,1,1,1,63,105},{0,1,1,1,63,111},{0,1,1,1,63,115},{0,1,1,1,63,116},{35,0,0,1,0,63},{36,0,0,1,0,63},{37,0,0,1,0,63},{38,0,0,1,0,63},{39,0,0,1,0,63},{40,0,0,1,0,63},{41,0,0,1,0,63},{42,0,0,1,0,63},{43,0,0,1,0,63},{44,0,0,1,0,63},{45,0,0,1,0,63},{46,0,0,1,0,63},{47,0,0,1,0,63},{48,0,0,1,0,63},{49,0,0,1,0,63},{50,0,0,1,0,63},{51,0,0,1,0,63},{52,0,0,1,0,63},{53,0,0,1,0,63},{54,0,0,1,0,63},{55,0,0,1,0,63},{56,1,0,1,0,63},{57,0,0,1,0,39},{58,0,0,1,0,39},{59,0,0,1,0,39},{60,0,0,1,0,39},{61,0,0,1,0,39},{62,0,0,1,0,39},{63,0,0,1,0,39},{64,0,0,1,0,39},{65,0,0,1,0,39},{66,0,0,1,0,39},{67,0,0,1,0,39},{68,0,0,1,0,39},{69,0,0,1,0,39},{70,0,0,1,0,39},{71,0,0,1,0,39},{72,1,0,1,0,39},{57,0,0,1,0,43},{58,0,0,1,0,43},{59,0,0,1,0,43},{60,0,0,1,0,43},{61,0,0,1,0,43},{62,0,0,1,0,43},{63,0,0,1,0,43},{64,0,0,1,0,43},{65,0,0,1,0,43},{66,0,0,1,0,43},{67,0,0,1,0,43},{68,0,0,1,0,43},{69,0,0,1,0,43},{70,0,0,1,0,43},{71,0,0,1,0,43},{72,1,0,1,0,43},{57,0,0,1,0,124},{58,0,0,1,0,124},{59,0,0,1,0,124},{60,0,0,1,0,124},{61,0,0,1,0,124},{62,0,0,1,0,124},{63,0,0,1,0,124},{64,0,0,1,0,124},{65,0,0,1,0,124},{66,0,0,1,0,124},{67,0,0,1,0,124},{68,0,0,1,0,124},{69,0,0,1,0,124},{70,0,0,1,0,124},{71,0,0,1,0,124},{72,1,0,1,0,124},{1,0,0,1,0,35},{2,0,0,1,0,35},{3,0,0,1,0,35},{4,0,0,1,0,35},{5,0,0,1,0,35},{6,0,0,1,0,35},{7,0,0,1,0,35},{8,1,0,1,0,35},{1,0,0,1,0,62},{2,0,0,1,0,62},{3,0,0,1,0,62},{4,0,0,1,0,62},{5,0,0,1,0,62},{6,0,0,1,0,62},{7,0,0,1,0,62},{8,1,0,1,0,62},{9,0,0,1,0,0},{10,0,0,1,0,0},{11,0,0,1,0,0},{12,1,0,1,0,0},{9,0,0,1,0,36},{10,0,0,1,0,36},{11,0,0,1,0,36},{12,1,0,1,0,36},{9,0,0,1,0,64},{10,0,0,1,0,64},{11,0,0,1,0,64},{12,1,0,1,0,64},{9,0,0,1,0,91},{10,0,0,1,0,91},{11,0,0,1,0,91},{12,1,0,1,0,91},{9,0,0,1,0,93},{10,0,0,1,0,93},{11,0,0,1,0,93},{12,1,0,1,0,93},{9,0,0,1,0,126},{10,0,0,1,0,126},{11,0,0,1,0,126},{12,1,0,1,0,126},{13,0,0,1,0,94},{14,1,0,1,0,94},{13,0,0,1,0,125},{14,1,0,1,0,125},{0,1,0,1,0,60},{0,1,0,1,0,96},{0,1,0,1,0,123},{132,0,0,0,0,0},{9,0,1,1,60,48},{10,0,1,1,60,48},{11,0,1,1,60,48},{12,1,1,1,60,48},{9,0,1,1,60,49},{10,0,1,1,60,49},{11,0,1,1,60,49},{12,1,1,1,60,49},{9,0,1,1,60,50},{10,0,1,1,60,50},{11,0,1,1,60,50},{12,1,1,1,60,50},{9,0,1,1,60,97},{10,0,1,1,60,97},{11,0,1,1,60,97},{12,1,1,1,60,97},{9,0,1,1,60,99},{10,0,1,1,60,99},{11,0,1,1,60,99},{12,1,1,1,60,99},{9,0,1,1,60,101},{10,0,1,1,60,101},{11,0,1,1,60,101},{12,1,1,1,60,101},{9,0,1,1,60,105},{10,0,1,1,60,105},{11,0,1,1,60,105},{12,1,1,1,60,105},{9,0,1,1,60,111},{10,0,1,1,60,111},{11,0,1,1,60,111},{12,1,1,1,60,111},{9,0,1,1,60,115},{10,0,1,1,60,115},{11,0,1,1,60,115},{12,1,1,1,60,115},{9,0,1,1,60,116},{10,0,1,1,60,116},{11,0,1,1,60,116},{12,1,1,1,60,116},{13,0,1,1,60,32},{14,1,1,1,60,32},{13,0,1,1,60,37},{14,1,1,1,60,37},{13,0,1,1,60,45},{14,1,1,1,60,45},{13,0,1,1,60,46},{14,1,1,1,60,46},{13,0,1,1,60,47},{14,1,1,1,60,47},{13,0,1,1,60,51},{14,1,1,1,60,51},{13,0,1,1,60,52},{14,1,1,1,60,52},{13,0,1,1,60,53},{14,1,1,1,60,53},{13,0,1,1,60,54},{14,1,1,1,60,54},{13,0,1,1,60,55},{14,1,1,1,60,55},{13,0,1,1,60,56},{14,1,1,1,60,56},{13,0,1,1,60,57},{14,1,1,1,60,57},{13,0,1,1,60,61},{14,1,1,1,60,61},{13,0,1,1,60,65},{14,1,1,1,60,65},{13,0,1,1,60,95},{14,1,1,1,60,95},{13,0,1,1,60,98},{14,1,1,1,60,98},{13,0,1,1,60,100},{14,1,1,1,60,100},{13,0,1,1,60,102},{14,1,1,1,60,102},{13,0,1,1,60,103},{14,1,1,1,60,103},{13,0,1,1,60,104},{14,1,1,1,60,104},{13,0,1,1,60,108},{14,1,1,1,60,108},{13,0,1,1,60,109},{14,1,1,1,60,109},{13,0,1,1,60,110},{14,1,1,1,60,110},{13,0,1,1,60,112},{14,1,1,1,60,112},{13,0,1,1,60,114},{14,1,1,1,60,114},{13,0,1,1,60,117},{14,1,1,1,60,117},{0,1,1,1,60,58},{0,1,1,1,60,66},{0,1,1,1,60,67},{0,1,1,1,60,68},{0,1,1,1,60,69},{0,1,1,1,60,70},{0,1,1,1,60,71},{0,1,1,1,60,72},{0,1,1,1,60,73},{0,1,1,1,60,74},{0,1,1,1,60,75},{0,1,1,1,60,76},{0,1,1,1,60,77},{0,1,1,1,60,78},{0,1,1,1,60,79},{0,1,1,1,60,80},{0,1,1,1,60,81},{0,1,1,1,60,82},{0,1,1,1,60,83},{0,1,1,1,60,84},{0,1,1,1,60,85},{0,1,1,1,60,86},{0,1,1,1,60,87},{0,1,1,1,60,89},{0,1,1,1,60,106},{0,1,1,1,60,107},{0,1,1,1,60,113},{0,1,1,1,60,118},{0,1,1,1,60,119},{0,1,1,1,60,120},{0,1,1,1,60,121},{0,1,1,1,60,122},{85,0,0,1,0,60},{86,0,0,1,0,60},{87,0,0,1,0,60},{88,1,0,1,0,60},{9,0,1,1,96,48},{10,0,1,1,96,48},{11,0,1,1,96,48},{12,1,1,1,96,48},{9,0,1,1,96,49},{10,0,1,1,96,49},{11,0,1,1,96,49},{12,1,1,1,96,49},{9,0,1,1,96,50},{10,0,1,1,96,50},{11,0,1,1,96,50},{12,1,1,1,96,50},{9,0,1,1,96,97},{10,0,1,1,96,97},{11,0,1,1,96,97},{12,1,1,1,96,97},{9,0,1,1,96,99},{10,0,1,1,96,99},{11,0,1,1,96,99},{12,1,1,1,96,99},{9,0,1,1,96,101},{10,0,1,1,96,101},{11,0,1,1,96,101},{12,1,1,1,96,101},{9,0,1,1,96,105},{10,0,1,1,96,105},{11,0,1,1,96,105},{12,1,1,1,96,105},{9,0,1,1,96,111},{10,0,1,1,96,111},{11,0,1,1,96,111},{12,1,1,1,96,111},{9,0,1,1,96,115},{10,0,1,1,96,115},{11,0,1,1,96,115},{12,1,1,1,96,115},{9,0,1,1,96,116},{10,0,1,1,96,116},{11,0,1,1,96,116},{12,1,1,1,96,116},{13,0,1,1,96,32},{14,1,1,1,96,32},{13,0,1,1,96,37},{14,1,1,1,96,37},{13,0,1,1,96,45},{14,1,1,1,96,45},{13,0,1,1,96,46},{14,1,1,1,96,46},{13,0,1,1,96,47},{14,1,1,1,96,47},{13,0,1,1,96,51},{14,1,1,1,96,51},{13,0,1,1,96,52},{14,1,1,1,96,52},{13,0,1,1,96,53},{14,1,1,1,96,53},{13,0,1,1,96,54},{14,1,1,1,96,54},{13,0,1,1,96,55},{14,1,1,1,96,55},{13,0,1,1,96,56},{14,1,1,1,96,56},{13,0,1,1,96,57},{14,1,1,1,96,57},{13,0,1,1,96,61},{14,1,1,1,96,61},{13,0,1,1,96,65},{14,1,1,1,96,65},{13,0,1,1,96,95},{14,1,1,1,96,95},{13,0,1,1,96,98},{14,1,1,1,96,98},{13,0,1,1,96,100},{14,1,1,1,96,100},{13,0,1,1,96,102},{14,1,1,1,96,102},{13,0,1,1,96,103},{14,1,1,1,96,103},{13,0,1,1,96,104},{14,1,1,1,96,104},{13,0,1,1,96,108},{14,1,1,1,96,108},{13,0,1,1,96,109},{14,1,1,1,96,109},{13,0,1,1,96,110},{14,1,1,1,96,110},{13,0,1,1,96,112},{14,1,1,1,96,112},{13,0,1,1,96,114},{14,1,1,1,96,114},{13,0,1,1,96,117},{14,1,1,1,96,117},{0,1,1,1,96,58},{0,1,1,1,96,66},{0,1,1,1,96,67},{0,1,1,1,96,68},{0,1,1,1,96,69},{0,1,1,1,96,70},{0,1,1,1,96,71},{0,1,1,1,96,72},{0,1,1,1,96,73},{0,1,1,1,96,74},{0,1,1,1,96,75},{0,1,1,1,96,76},{0,1,1,1,96,77},{0,1,1,1,96,78},{0,1,1,1,96,79},{0,1,1,1,96,80},{0,1,1,1,96,81},{0,1,1,1,96,82},{0,1,1,1,96,83},{0,1,1,1,96,84},{0,1,1,1,96,85},{0,1,1,1,96,86},{0,1,1,1,96,87},{0,1,1,1,96,89},{0,1,1,1,96,106},{0,1,1,1,96,107},{0,1,1,1,96,113},{0,1,1,1,96,118},{0,1,1,1,96,119},{0,1,1,1,96,120},{0,1,1,1,96,121},{0,1,1,1,96,122},{85,0,0,1,0,96},{86,0,0,1,0,96},{87,0,0,1,0,96},{88,1,0,1,0,96},{9,0,1,1,123,48},{10,0,1,1,123,48},{11,0,1,1,123,48},{12,1,1,1,123,48},{9,0,1,1,123,49},{10,0,1,1,123,49},{11,0,1,1,123,49},{12,1,1,1,123,49},{9,0,1,1,123,50},{10,0,1,1,123,50},{11,0,1,1,123,50},{12,1,1,1,123,50},{9,0,1,1,123,97},{10,0,1,1,123,97},{11,0,1,1,123,97},{12,1,1,1,123,97},{9,0,1,1,123,99},{10,0,1,1,123,99},{11,0,1,1,123,99},{12,1,1,1,123,99},{9,0,1,1,123,101},{10,0,1,1,123,101},{11,0,1,1,123,101},{12,1,1,1,123,101},{9,0,1,1,123,105},{10,0,1,1,123,105},{11,0,1,1,123,105},{12,1,1,1,123,105},{9,0,1,1,123,111},{10,0,1,1,123,111},{11,0,1,1,123,111},{12,1,1,1,123,111},{9,0,1,1,123,115},{10,0,1,1,123,115},{11,0,1,1,123,115},{12,1,1,1,123,115},{9,0,1,1,123,116},{10,0,1,1,123,116},{11,0,1,1,123,116},{12,1,1,1,123,116},{13,0,1,1,123,32},{14,1,1,1,123,32},{13,0,1,1,123,37},{14,1,1,1,123,37},{13,0,1,1,123,45},{14,1,1,1,123,45},{13,0,1,1,123,46},{14,1,1,1,123,46},{13,0,1,1,123,47},{14,1,1,1,123,47},{13,0,1,1,123,51},{14,1,1,1,123,51},{13,0,1,1,123,52},{14,1,1,1,123,52},{13,0,1,1,123,53},{14,1,1,1,123,53},{13,0,1,1,123,54},{14,1,1,1,123,54},{13,0,1,1,123,55},{14,1,1,1,123,55},{13,0,1,1,123,56},{14,1,1,1,123,56},{13,0,1,1,123,57},{14,1,1,1,123,57},{13,0,1,1,123,61},{14,1,1,1,123,61},{13,0,1,1,123,65},{14,1,1,1,123,65},{13,0,1,1,123,95},{14,1,1,1,123,95},{13,0,1,1,123,98},{14,1,1,1,123,98},{13,0,1,1,123,100},{14,1,1,1,123,100},{13,0,1,1,123,102},{14,1,1,1,123,102},{13,0,1,1,123,103},{14,1,1,1,123,103},{13,0,1,1,123,104},{14,1,1,1,123,104},{13,0,1,1,123,108},{14,1,1,1,123,108},{13,0,1,1,123,109},{14,1,1,1,123,109},{13,0,1,1,123,110},{14,1,1,1,123,110},{13,0,1,1,123,112},{14,1,1,1,123,112},{13,0,1,1,123,114},{14,1,1,1,123,114},{13,0,1,1,123,117},{14,1,1,1,123,117},{0,1,1,1,123,58},{0,1,1,1,123,66},{0,1,1,1,123,67},{0,1,1,1,123,68},{0,1,1,1,123,69},{0,1,1,1,123,70},{0,1,1,1,123,71},{0,1,1,1,123,72},{0,1,1,1,123,73},{0,1,1,1,123,74},{0,1,1,1,123,75},{0,1,1,1,123,76},{0,1,1,1,123,77},{0,1,1,1,123,78},{0,1,1,1,123,79},{0,1,1,1,123,80},{0,1,1,1,123,81},{0,1,1,1,123,82},{0,1,1,1,123,83},{0,1,1,1,123,84},{0,1,1,1,123,85},{0,1,1,1,123,86},{0,1,1,1,123,87},{0,1,1,1,123,89},{0,1,1,1,123,106},{0,1,1,1,123,107},{0,1,1,1,123,113},{0,1,1,1,123,118},{0,1,1,1,123,119},{0,1,1,1,123,120},{0,1,1,1,123,121},{0,1,1,1,123,122},{85,0,0,1,0,123},{86,0,0,1,0,123},{87,0,0,1,0,123},{88,1,0,1,0,123},{1,0,0,1,0,92},{2,0,0,1,0,92},{3,0,0,1,0,92},{4,0,0,1,0,92},{5,0,0,1,0,92},{6,0,0,1,0,92},{7,0,0,1,0,92},{8,1,0,1,0,92},{1,0,0,1,0,195},{2,0,0,1,0,195},{3,0,0,1,0,195},{4,0,0,1,0,195},{5,0,0,1,0,195},{6,0,0,1,0,195},{7,0,0,1,0,195},{8,1,0,1,0,195},{1,0,0,1,0,208},{2,0,0,1,0,208},{3,0,0,1,0,208},{4,0,0,1,0,208},{5,0,0,1,0,208},{6,0,0,1,0,208},{7,0,0,1,0,208},{8,1,0,1,0,208},{9,0,0,1,0,128},{10,0,0,1,0,128},{11,0,0,1,0,128},{12,1,0,1,0,128},{9,0,0,1,0,130},{10,0,0,1,0,130},{11,0,0,1,0,130},{12,1,0,1,0,130},{9,0,0,1,0,131},{10,0,0,1,0,131},{11,0,0,1,0,131},{12,1,0,1,0,131},{9,0,0,1,0,162},{10,0,0,1,0,162},{11,0,0,1,0,162},{12,1,0,1,0,162},{9,0,0,1,0,184},{10,0,0,1,0,184},{11,0,0,1,0,184},{12,1,0,1,0,184},{9,0,0,1,0,194},{10,0,0,1,0,194},{11,0,0,1,0,194},{12,1,0,1,0,194},{9,0,0,1,0,224},{10,0,0,1,0,224},{11,0,0,1,0,224},{12,1,0,1,0,224},{9,0,0,1,0,226},{10,0,0,1,0,226},{11,0,0,1,0,226},{12,1,0,1,0,226},{13,0,0,1,0,153},{14,1,0,1,0,153},{13,0,0,1,0,161},{14,1,0,1,0,161},{13,0,0,1,0,167},{14,1,0,1,0,167},{13,0,0,1,0,172},{14,1,0,1,0,172},{13,0,0,1,0,176},{14,1,0,1,0,176},{13,0,0,1,0,177},{14,1,0,1,0,177},{13,0,0,1,0,179},{14,1,0,1,0,179},{13,0,0,1,0,209},{14,1,0,1,0,209},{13,0,0,1,0,216},{14,1,0,1,0,216},{13,0,0,1,0,217},{14,1,0,1,0,217},{13,0,0,1,0,227},{14,1,0,1,0,227},{13,0,0,1,0,229},{14,1,0,1,0,229},{13,0,0,1,0,230},{14,1,0,1,0,230},{0,1,0,1,0,129},{0,1,0,1,0,132},{0,1,0,1,0,133},{0,1,0,1,0,134},{0,1,0,1,0,136},{0,1,0,1,0,146},{0,1,0,1,0,154},{0,1,0,1,0,156},{0,1,0,1,0,160},{0,1,0,1,0,163},{0,1,0,1,0,164},{0,1,0,1,0,169},{0,1,0,1,0,170},{0,1,0,1,0,173},{0,1,0,1,0,178},{0,1,0,1,0,181},{0,1,0,1,0,185},{0,1,0,1,0,186},{0,1,0,1,0,187},{0,1,0,1,0,189},{0,1,0,1,0,190},{0,1,0,1,0,196},{0,1,0,1,0,198},{0,1,0,1,0,228},{0,1,0,1,0,232},{0,1,0,1,0,233},{133,0,0,0,0,0},{134,0,0,0,0,0},{135,0,0,0,0,0},{136,0,0,0,0,0},{137,0,0,0,0,0},{138,0,0,0,0,0},{139,0,0,0,0,0},{140,0,0,0,0,0},{141,0,0,0,0,0},{142,0,0,0,0,0},{143,0,0,0,0,0},{144,0,0,0,0,0},{145,0,0,0,0,0},{146,0,0,0,0,0},{147,0,0,0,0,0},{148,0,0,0,0,0},{149,0,0,0,0,0},{150,0,0,0,0,0},{151,0,0,0,0,0},{152,0,0,0,0,0},{9,0,1,1,94,48},{10,0,1,1,94,48},{11,0,1,1,94,48},{12,1,1,1,94,48},{9,0,1,1,94,49},{10,0,1,1,94,49},{11,0,1,1,94,49},{12,1,1,1,94,49},{9,0,1,1,94,50},{10,0,1,1,94,50},{11,0,1,1,94,50},{12,1,1,1,94,50},{9,0,1,1,94,97},{10,0,1,1,94,97},{11,0,1,1,94,97},{12,1,1,1,94,97},{9,0,1,1,94,99},{10,0,1,1,94,99},{11,0,1,1,94,99},{12,1,1,1,94,99},{9,0,1,1,94,101},{10,0,1,1,94,101},{11,0,1,1,94,101},{12,1,1,1,94,101},{9,0,1,1,94,105},{10,0,1,1,94,105},{11,0,1,1,94,105},{12,1,1,1,94,105},{9,0,1,1,94,111},{10,0,1,1,94,111},{11,0,1,1,94,111},{12,1,1,1,94,111},{9,0,1,1,94,115},{10,0,1,1,94,115},{11,0,1,1,94,115},{12,1,1,1,94,115},{9,0,1,1,94,116},{10,0,1,1,94,116},{11,0,1,1,94,116},{12,1,1,1,94,116},{13,0,1,1,94,32},{14,1,1,1,94,32},{13,0,1,1,94,37},{14,1,1,1,94,37},{13,0,1,1,94,45},{14,1,1,1,94,45},{13,0,1,1,94,46},{14,1,1,1,94,46},{13,0,1,1,94,47},{14,1,1,1,94,47},{13,0,1,1,94,51},{14,1,1,1,94,51},{13,0,1,1,94,52},{14,1,1,1,94,52},{13,0,1,1,94,53},{14,1,1,1,94,53},{13,0,1,1,94,54},{14,1,1,1,94,54},{13,0,1,1,94,55},{14,1,1,1,94,55},{13,0,1,1,94,56},{14,1,1,1,94,56},{13,0,1,1,94,57},{14,1,1,1,94,57},{13,0,1,1,94,61},{14,1,1,1,94,61},{13,0,1,1,94,65},{14,1,1,1,94,65},{13,0,1,1,94,95},{14,1,1,1,94,95},{13,0,1,1,94,98},{14,1,1,1,94,98},{13,0,1,1,94,100},{14,1,1,1,94,100},{13,0,1,1,94,102},{14,1,1,1,94,102},{13,0,1,1,94,103},{14,1,1,1,94,103},{13,0,1,1,94,104},{14,1,1,1,94,104},{13,0,1,1,94,108},{14,1,1,1,94,108},{13,0,1,1,94,109},{14,1,1,1,94,109},{13,0,1,1,94,110},{14,1,1,1,94,110},{13,0,1,1,94,112},{14,1,1,1,94,112},{13,0,1,1,94,114},{14,1,1,1,94,114},{13,0,1,1,94,117},{14,1,1,1,94,117},{0,1,1,1,94,58},{0,1,1,1,94,66},{0,1,1,1,94,67},{0,1,1,1,94,68},{0,1,1,1,94,69},{0,1,1,1,94,70},{0,1,1,1,94,71},{0,1,1,1,94,72},{0,1,1,1,94,73},{0,1,1,1,94,74},{0,1,1,1,94,75},{0,1,1,1,94,76},{0,1,1,1,94,77},{0,1,1,1,94,78},{0,1,1,1,94,79},{0,1,1,1,94,80},{0,1,1,1,94,81},{0,1,1,1,94,82},{0,1,1,1,94,83},{0,1,1,1,94,84},{0,1,1,1,94,85},{0,1,1,1,94,86},{0,1,1,1,94,87},{0,1,1,1,94,89},{0,1,1,1,94,106},{0,1,1,1,94,107},{0,1,1,1,94,113},{0,1,1,1,94,118},{0,1,1,1,94,119},{0,1,1,1,94,120},{0,1,1,1,94,121},{0,1,1,1,94,122},{85,0,0,1,0,94},{86,0,0,1,0,94},{87,0,0,1,0,94},{88,1,0,1,0,94},{9,0,1,1,125,48},{10,0,1,1,125,48},{11,0,1,1,125,48},{12,1,1,1,125,48},{9,0,1,1,125,49},{10,0,1,1,125,49},{11,0,1,1,125,49},{12,1,1,1,125,49},{9,0,1,1,125,50},{10,0,1,1,125,50},{11,0,1,1,125,50},{12,1,1,1,125,50},{9,0,1,1,125,97},{10,0,1,1,125,97},{11,0,1,1,125,97},{12,1,1,1,125,97},{9,0,1,1,125,99},{10,0,1,1,125,99},{11,0,1,1,125,99},{12,1,1,1,125,99},{9,0,1,1,125,101},{10,0,1,1,125,101},{11,0,1,1,125,101},{12,1,1,1,125,101},{9,0,1,1,125,105},{10,0,1,1,125,105},{11,0,1,1,125,105},{12,1,1,1,125,105},{9,0,1,1,125,111},{10,0,1,1,125,111},{11,0,1,1,125,111},{12,1,1,1,125,111},{9,0,1,1,125,115},{10,0,1,1,125,115},{11,0,1,1,125,115},{12,1,1,1,125,115},{9,0,1,1,125,116},{10,0,1,1,125,116},{11,0,1,1,125,116},{12,1,1,1,125,116},{13,0,1,1,125,32},{14,1,1,1,125,32},{13,0,1,1,125,37},{14,1,1,1,125,37},{13,0,1,1,125,45},{14,1,1,1,125,45},{13,0,1,1,125,46},{14,1,1,1,125,46},{13,0,1,1,125,47},{14,1,1,1,125,47},{13,0,1,1,125,51},{14,1,1,1,125,51},{13,0,1,1,125,52},{14,1,1,1,125,52},{13,0,1,1,125,53},{14,1,1,1,125,53},{13,0,1,1,125,54},{14,1,1,1,125,54},{13,0,1,1,125,55},{14,1,1,1,125,55},{13,0,1,1,125,56},{14,1,1,1,125,56},{13,0,1,1,125,57},{14,1,1,1,125,57},{13,0,1,1,125,61},{14,1,1,1,125,61},{13,0,1,1,125,65},{14,1,1,1,125,65},{13,0,1,1,125,95},{14,1,1,1,125,95},{13,0,1,1,125,98},{14,1,1,1,125,98},{13,0,1,1,125,100},{14,1,1,1,125,100},{13,0,1,1,125,102},{14,1,1,1,125,102},{13,0,1,1,125,103},{14,1,1,1,125,103},{13,0,1,1,125,104},{14,1,1,1,125,104},{13,0,1,1,125,108},{14,1,1,1,125,108},{13,0,1,1,125,109},{14,1,1,1,125,109},{13,0,1,1,125,110},{14,1,1,1,125,110},{13,0,1,1,125,112},{14,1,1,1,125,112},{13,0,1,1,125,114},{14,1,1,1,125,114},{13,0,1,1,125,117},{14,1,1,1,125,117},{0,1,1,1,125,58},{0,1,1,1,125,66},{0,1,1,1,125,67},{0,1,1,1,125,68},{0,1,1,1,125,69},{0,1,1,1,125,70},{0,1,1,1,125,71},{0,1,1,1,125,72},{0,1,1,1,125,73},{0,1,1,1,125,74},{0,1,1,1,125,75},{0,1,1,1,125,76},{0,1,1,1,125,77},{0,1,1,1,125,78},{0,1,1,1,125,79},{0,1,1,1,125,80},{0,1,1,1,125,81},{0,1,1,1,125,82},{0,1,1,1,125,83},{0,1,1,1,125,84},{0,1,1,1,125,85},{0,1,1,1,125,86},{0,1,1,1,125,87},{0,1,1,1,125,89},{0,1,1,1,125,106},{0,1,1,1,125,107},{0,1,1,1,125,113},{0,1,1,1,125,118},{0,1,1,1,125,119},{0,1,1,1,125,120},{0,1,1,1,125,121},{0,1,1,1,125,122},{85,0,0,1,0,125},{86,0,0,1,0,125},{87,0,0,1,0,125},{88,1,0,1,0,125},{13,0,1,1,60,48},{14,1,1,1,60,48},{13,0,1,1,60,49},{14,1,1,1,60,49},{13,0,1,1,60,50},{14,1,1,1,60,50},{13,0,1,1,60,97},{14,1,1,1,60,97},{13,0,1,1,60,99},{14,1,1,1,60,99},{13,0,1,1,60,101},{14,1,1,1,60,101},{13,0,1,1,60,105},{14,1,1,1,60,105},{13,0,1,1,60,111},{14,1,1,1,60,111},{13,0,1,1,60,115},{14,1,1,1,60,115},{13,0,1,1,60,116},{14,1,1,1,60,116},{0,1,1,1,60,32},{0,1,1,1,60,37},{0,1,1,1,60,45},{0,1,1,1,60,46},{0,1,1,1,60,47},{0,1,1,1,60,51},{0,1,1,1,60,52},{0,1,1,1,60,53},{0,1,1,1,60,54},{0,1,1,1,60,55},{0,1,1,1,60,56},{0,1,1,1,60,57},{0,1,1,1,60,61},{0,1,1,1,60,65},{0,1,1,1,60,95},{0,1,1,1,60,98},{0,1,1,1,60,100},{0,1,1,1,60,102},{0,1,1,1,60,103},{0,1,1,1,60,104},{0,1,1,1,60,108},{0,1,1,1,60,109},{0,1,1,1,60,110},{0,1,1,1,60,112},{0,1,1,1,60,114},{0,1,1,1,60,117},{17,0,0,1,0,60},{18,0,0,1,0,60},{19,0,0,1,0,60},{20,0,0,1,0,60},{21,0,0,1,0,60},{22,0,0,1,0,60},{23,0,0,1,0,60},{24,0,0,1,0,60},{25,0,0,1,0,60},{26,0,0,1,0,60},{27,0,0,1,0,60},{28,0,0,1,0,60},{29,0,0,1,0,60},{30,0,0,1,0,60},{31,0,0,1,0,60},{32,0,0,1,0,60},{33,0,0,1,0,60},{34,1,0,1,0,60},{13,0,1,1,96,48},{14,1,1,1,96,48},{13,0,1,1,96,49},{14,1,1,1,96,49},{13,0,1,1,96,50},{14,1,1,1,96,50},{13,0,1,1,96,97},{14,1,1,1,96,97},{13,0,1,1,96,99},{14,1,1,1,96,99},{13,0,1,1,96,101},{14,1,1,1,96,101},{13,0,1,1,96,105},{14,1,1,1,96,105},{13,0,1,1,96,111},{14,1,1,1,96,111},{13,0,1,1,96,115},{14,1,1,1,96,115},{13,0,1,1,96,116},{14,1,1,1,96,116},{0,1,1,1,96,32},{0,1,1,1,96,37},{0,1,1,1,96,45},{0,1,1,1,96,46},{0,1,1,1,96,47},{0,1,1,1,96,51},{0,1,1,1,96,52},{0,1,1,1,96,53},{0,1,1,1,96,54},{0,1,1,1,96,55},{0,1,1,1,96,56},{0,1,1,1,96,57},{0,1,1,1,96,61},{0,1,1,1,96,65},{0,1,1,1,96,95},{0,1,1,1,96,98},{0,1,1,1,96,100},{0,1,1,1,96,102},{0,1,1,1,96,103},{0,1,1,1,96,104},{0,1,1,1,96,108},{0,1,1,1,96,109},{0,1,1,1,96,110},{0,1,1,1,96,112},{0,1,1,1,96,114},{0,1,1,1,96,117},{17,0,0,1,0,96},{18,0,0,1,0,96},{19,0,0,1,0,96},{20,0,0,1,0,96},{21,0,0,1,0,96},{22,0,0,1,0,96},{23,0,0,1,0,96},{24,0,0,1,0,96},{25,0,0,1,0,96},{26,0,0,1,0,96},{27,0,0,1,0,96},{28,0,0,1,0,96},{29,0,0,1,0,96},{30,0,0,1,0,96},{31,0,0,1,0,96},{32,0,0,1,0,96},{33,0,0,1,0,96},{34,1,0,1,0,96},{13,0,1,1,123,48},{14,1,1,1,123,48},{13,0,1,1,123,49},{14,1,1,1,123,49},{13,0,1,1,123,50},{14,1,1,1,123,50},{13,0,1,1,123,97},{14,1,1,1,123,97},{13,0,1,1,123,99},{14,1,1,1,123,99},{13,0,1,1,123,101},{14,1,1,1,123,101},{13,0,1,1,123,105},{14,1,1,1,123,105},{13,0,1,1,123,111},{14,1,1,1,123,111},{13,0,1,1,123,115},{14,1,1,1,123,115},{13,0,1,1,123,116},{14,1,1,1,123,116},{0,1,1,1,123,32},{0,1,1,1,123,37},{0,1,1,1,123,45},{0,1,1,1,123,46},{0,1,1,1,123,47},{0,1,1,1,123,51},{0,1,1,1,123,52},{0,1,1,1,123,53},{0,1,1,1,123,54},{0,1,1,1,123,55},{0,1,1,1,123,56},{0,1,1,1,123,57},{0,1,1,1,123,61},{0,1,1,1,123,65},{0,1,1,1,123,95},{0,1,1,1,123,98},{0,1,1,1,123,100},{0,1,1,1,123,102},{0,1,1,1,123,103},{0,1,1,1,123,104},{0,1,1,1,123,108},{0,1,1,1,123,109},{0,1,1,1,123,110},{0,1,1,1,123,112},{0,1,1,1,123,114},{0,1,1,1,123,117},{17,0,0,1,0,123},{18,0,0,1,0,123},{19,0,0,1,0,123},{20,0,0,1,0,123},{21,0,0,1,0,123},{22,0,0,1,0,123},{23,0,0,1,0,123},{24,0,0,1,0,123},{25,0,0,1,0,123},{26,0,0,1,0,123},{27,0,0,1,0,123},{28,0,0,1,0,123},{29,0,0,1,0,123},{30,0,0,1,0,123},{31,0,0,1,0,123},{32,0,0,1,0,123},{33,0,0,1,0,123},{34,1,0,1,0,123},{9,0,0,1,0,92},{10,0,0,1,0,92},{11,0,0,1,0,92},{12,1,0,1,0,92},{9,0,0,1,0,195},{10,0,0,1,0,195},{11,0,0,1,0,195},{12,1,0,1,0,195},{9,0,0,1,0,208},{10,0,0,1,0,208},{11,0,0,1,0,208},{12,1,0,1,0,208},{13,0,0,1,0,128},{14,1,0,1,0,128},{13,0,0,1,0,130},{14,1,0,1,0,130},{13,0,0,1,0,131},{14,1,0,1,0,131},{13,0,0,1,0,162},{14,1,0,1,0,162},{13,0,0,1,0,184},{14,1,0,1,0,184},{13,0,0,1,0,194},{14,1,0,1,0,194},{13,0,0,1,0,224},{14,1,0,1,0,224},{13,0,0,1,0,226},{14,1,0,1,0,226},{0,1,0,1,0,153},{0,1,0,1,0,161},{0,1,0,1,0,167},{0,1,0,1,0,172},{0,1,0,1,0,176},{0,1,0,1,0,177},{0,1,0,1,0,179},{0,1,0,1,0,209},{0,1,0,1,0,216},{0,1,0,1,0,217},{0,1,0,1,0,227},{0,1,0,1,0,229},{0,1,0,1,0,230},{153,0,0,0,0,0},{154,0,0,0,0,0},{155,0,0,0,0,0},{156,0,0,0,0,0},{157,0,0,0,0,0},{158,0,0,0,0,0},{159,0,0,0,0,0},{160,0,0,0,0,0},{161,0,0,0,0,0},{162,0,0,0,0,0},{163,0,0,0,0,0},{164,0,0,0,0,0},{165,0,0,0,0,0},{166,0,0,0,0,0},{167,0,0,0,0,0},{168,0,0,0,0,0},{169,0,0,0,0,0},{170,0,0,0,0,0},{171,0,0,0,0,0},{172,0,0,0,0,0},{173,0,0,0,0,0},{174,0,0,0,0,0},{175,0,0,0,0,0},{9,0,1,1,0,48},{10,0,1,1,0,48},{11,0,1,1,0,48},{12,1,1,1,0,48},{9,0,1,1,0,49},{10,0,1,1,0,49},{11,0,1,1,0,49},{12,1,1,1,0,49},{9,0,1,1,0,50},{10,0,1,1,0,50},{11,0,1,1,0,50},{12,1,1,1,0,50},{9,0,1,1,0,97},{10,0,1,1,0,97},{11,0,1,1,0,97},{12,1,1,1,0,97},{9,0,1,1,0,99},{10,0,1,1,0,99},{11,0,1,1,0,99},{12,1,1,1,0,99},{9,0,1,1,0,101},{10,0,1,1,0,101},{11,0,1,1,0,101},{12,1,1,1,0,101},{9,0,1,1,0,105},{10,0,1,1,0,105},{11,0,1,1,0,105},{12,1,1,1,0,105},{9,0,1,1,0,111},{10,0,1,1,0,111},{11,0,1,1,0,111},{12,1,1,1,0,111},{9,0,1,1,0,115},{10,0,1,1,0,115},{11,0,1,1,0,115},{12,1,1,1,0,115},{9,0,1,1,0,116},{10,0,1,1,0,116},{11,0,1,1,0,116},{12,1,1,1,0,116},{13,0,1,1,0,32},{14,1,1,1,0,32},{13,0,1,1,0,37},{14,1,1,1,0,37},{13,0,1,1,0,45},{14,1,1,1,0,45},{13,0,1,1,0,46},{14,1,1,1,0,46},{13,0,1,1,0,47},{14,1,1,1,0,47},{13,0,1,1,0,51},{14,1,1,1,0,51},{13,0,1,1,0,52},{14,1,1,1,0,52},{13,0,1,1,0,53},{14,1,1,1,0,53},{13,0,1,1,0,54},{14,1,1,1,0,54},{13,0,1,1,0,55},{14,1,1,1,0,55},{13,0,1,1,0,56},{14,1,1,1,0,56},{13,0,1,1,0,57},{14,1,1,1,0,57},{13,0,1,1,0,61},{14,1,1,1,0,61},{13,0,1,1,0,65},{14,1,1,1,0,65},{13,0,1,1,0,95},{14,1,1,1,0,95},{13,0,1,1,0,98},{14,1,1,1,0,98},{13,0,1,1,0,100},{14,1,1,1,0,100},{13,0,1,1,0,102},{14,1,1,1,0,102},{13,0,1,1,0,103},{14,1,1,1,0,103},{13,0,1,1,0,104},{14,1,1,1,0,104},{13,0,1,1,0,108},{14,1,1,1,0,108},{13,0,1,1,0,109},{14,1,1,1,0,109},{13,0,1,1,0,110},{14,1,1,1,0,110},{13,0,1,1,0,112},{14,1,1,1,0,112},{13,0,1,1,0,114},{14,1,1,1,0,114},{13,0,1,1,0,117},{14,1,1,1,0,117},{0,1,1,1,0,58},{0,1,1,1,0,66},{0,1,1,1,0,67},{0,1,1,1,0,68},{0,1,1,1,0,69},{0,1,1,1,0,70},{0,1,1,1,0,71},{0,1,1,1,0,72},{0,1,1,1,0,73},{0,1,1,1,0,74},{0,1,1,1,0,75},{0,1,1,1,0,76},{0,1,1,1,0,77},{0,1,1,1,0,78},{0,1,1,1,0,79},{0,1,1,1,0,80},{0,1,1,1,0,81},{0,1,1,1,0,82},{0,1,1,1,0,83},{0,1,1,1,0,84},{0,1,1,1,0,85},{0,1,1,1,0,86},{0,1,1,1,0,87},{0,1,1,1,0,89},{0,1,1,1,0,106},{0,1,1,1,0,107},{0,1,1,1,0,113},{0,1,1,1,0,118},{0,1,1,1,0,119},{0,1,1,1,0,120},{0,1,1,1,0,121},{0,1,1,1,0,122},{85,0,0,1,0,0},{86,0,0,1,0,0},{87,0,0,1,0,0},{88,1,0,1,0,0},{9,0,1,1,36,48},{10,0,1,1,36,48},{11,0,1,1,36,48},{12,1,1,1,36,48},{9,0,1,1,36,49},{10,0,1,1,36,49},{11,0,1,1,36,49},{12,1,1,1,36,49},{9,0,1,1,36,50},{10,0,1,1,36,50},{11,0,1,1,36,50},{12,1,1,1,36,50},{9,0,1,1,36,97},{10,0,1,1,36,97},{11,0,1,1,36,97},{12,1,1,1,36,97},{9,0,1,1,36,99},{10,0,1,1,36,99},{11,0,1,1,36,99},{12,1,1,1,36,99},{9,0,1,1,36,101},{10,0,1,1,36,101},{11,0,1,1,36,101},{12,1,1,1,36,101},{9,0,1,1,36,105},{10,0,1,1,36,105},{11,0,1,1,36,105},{12,1,1,1,36,105},{9,0,1,1,36,111},{10,0,1,1,36,111},{11,0,1,1,36,111},{12,1,1,1,36,111},{9,0,1,1,36,115},{10,0,1,1,36,115},{11,0,1,1,36,115},{12,1,1,1,36,115},{9,0,1,1,36,116},{10,0,1,1,36,116},{11,0,1,1,36,116},{12,1,1,1,36,116},{13,0,1,1,36,32},{14,1,1,1,36,32},{13,0,1,1,36,37},{14,1,1,1,36,37},{13,0,1,1,36,45},{14,1,1,1,36,45},{13,0,1,1,36,46},{14,1,1,1,36,46},{13,0,1,1,36,47},{14,1,1,1,36,47},{13,0,1,1,36,51},{14,1,1,1,36,51},{13,0,1,1,36,52},{14,1,1,1,36,52},{13,0,1,1,36,53},{14,1,1,1,36,53},{13,0,1,1,36,54},{14,1,1,1,36,54},{13,0,1,1,36,55},{14,1,1,1,36,55},{13,0,1,1,36,56},{14,1,1,1,36,56},{13,0,1,1,36,57},{14,1,1,1,36,57},{13,0,1,1,36,61},{14,1,1,1,36,61},{13,0,1,1,36,65},{14,1,1,1,36,65},{13,0,1,1,36,95},{14,1,1,1,36,95},{13,0,1,1,36,98},{14,1,1,1,36,98},{13,0,1,1,36,100},{14,1,1,1,36,100},{13,0,1,1,36,102},{14,1,1,1,36,102},{13,0,1,1,36,103},{14,1,1,1,36,103},{13,0,1,1,36,104},{14,1,1,1,36,104},{13,0,1,1,36,108},{14,1,1,1,36,108},{13,0,1,1,36,109},{14,1,1,1,36,109},{13,0,1,1,36,110},{14,1,1,1,36,110},{13,0,1,1,36,112},{14,1,1,1,36,112},{13,0,1,1,36,114},{14,1,1,1,36,114},{13,0,1,1,36,117},{14,1,1,1,36,117},{0,1,1,1,36,58},{0,1,1,1,36,66},{0,1,1,1,36,67},{0,1,1,1,36,68},{0,1,1,1,36,69},{0,1,1,1,36,70},{0,1,1,1,36,71},{0,1,1,1,36,72},{0,1,1,1,36,73},{0,1,1,1,36,74},{0,1,1,1,36,75},{0,1,1,1,36,76},{0,1,1,1,36,77},{0,1,1,1,36,78},{0,1,1,1,36,79},{0,1,1,1,36,80},{0,1,1,1,36,81},{0,1,1,1,36,82},{0,1,1,1,36,83},{0,1,1,1,36,84},{0,1,1,1,36,85},{0,1,1,1,36,86},{0,1,1,1,36,87},{0,1,1,1,36,89},{0,1,1,1,36,106},{0,1,1,1,36,107},{0,1,1,1,36,113},{0,1,1,1,36,118},{0,1,1,1,36,119},{0,1,1,1,36,120},{0,1,1,1,36,121},{0,1,1,1,36,122},{85,0,0,1,0,36},{86,0,0,1,0,36},{87,0,0,1,0,36},{88,1,0,1,0,36},{9,0,1,1,64,48},{10,0,1,1,64,48},{11,0,1,1,64,48},{12,1,1,1,64,48},{9,0,1,1,64,49},{10,0,1,1,64,49},{11,0,1,1,64,49},{12,1,1,1,64,49},{9,0,1,1,64,50},{10,0,1,1,64,50},{11,0,1,1,64,50},{12,1,1,1,64,50},{9,0,1,1,64,97},{10,0,1,1,64,97},{11,0,1,1,64,97},{12,1,1,1,64,97},{9,0,1,1,64,99},{10,0,1,1,64,99},{11,0,1,1,64,99},{12,1,1,1,64,99},{9,0,1,1,64,101},{10,0,1,1,64,101},{11,0,1,1,64,101},{12,1,1,1,64,101},{9,0,1,1,64,105},{10,0,1,1,64,105},{11,0,1,1,64,105},{12,1,1,1,64,105},{9,0,1,1,64,111},{10,0,1,1,64,111},{11,0,1,1,64,111},{12,1,1,1,64,111},{9,0,1,1,64,115},{10,0,1,1,64,115},{11,0,1,1,64,115},{12,1,1,1,64,115},{9,0,1,1,64,116},{10,0,1,1,64,116},{11,0,1,1,64,116},{12,1,1,1,64,116},{13,0,1,1,64,32},{14,1,1,1,64,32},{13,0,1,1,64,37},{14,1,1,1,64,37},{13,0,1,1,64,45},{14,1,1,1,64,45},{13,0,1,1,64,46},{14,1,1,1,64,46},{13,0,1,1,64,47},{14,1,1,1,64,47},{13,0,1,1,64,51},{14,1,1,1,64,51},{13,0,1,1,64,52},{14,1,1,1,64,52},{13,0,1,1,64,53},{14,1,1,1,64,53},{13,0,1,1,64,54},{14,1,1,1,64,54},{13,0,1,1,64,55},{14,1,1,1,64,55},{13,0,1,1,64,56},{14,1,1,1,64,56},{13,0,1,1,64,57},{14,1,1,1,64,57},{13,0,1,1,64,61},{14,1,1,1,64,61},{13,0,1,1,64,65},{14,1,1,1,64,65},{13,0,1,1,64,95},{14,1,1,1,64,95},{13,0,1,1,64,98},{14,1,1,1,64,98},{13,0,1,1,64,100},{14,1,1,1,64,100},{13,0,1,1,64,102},{14,1,1,1,64,102},{13,0,1,1,64,103},{14,1,1,1,64,103},{13,0,1,1,64,104},{14,1,1,1,64,104},{13,0,1,1,64,108},{14,1,1,1,64,108},{13,0,1,1,64,109},{14,1,1,1,64,109},{13,0,1,1,64,110},{14,1,1,1,64,110},{13,0,1,1,64,112},{14,1,1,1,64,112},{13,0,1,1,64,114},{14,1,1,1,64,114},{13,0,1,1,64,117},{14,1,1,1,64,117},{0,1,1,1,64,58},{0,1,1,1,64,66},{0,1,1,1,64,67},{0,1,1,1,64,68},{0,1,1,1,64,69},{0,1,1,1,64,70},{0,1,1,1,64,71},{0,1,1,1,64,72},{0,1,1,1,64,73},{0,1,1,1,64,74},{0,1,1,1,64,75},{0,1,1,1,64,76},{0,1,1,1,64,77},{0,1,1,1,64,78},{0,1,1,1,64,79},{0,1,1,1,64,80},{0,1,1,1,64,81},{0,1,1,1,64,82},{0,1,1,1,64,83},{0,1,1,1,64,84},{0,1,1,1,64,85},{0,1,1,1,64,86},{0,1,1,1,64,87},{0,1,1,1,64,89},{0,1,1,1,64,106},{0,1,1,1,64,107},{0,1,1,1,64,113},{0,1,1,1,64,118},{0,1,1,1,64,119},{0,1,1,1,64,120},{0,1,1,1,64,121},{0,1,1,1,64,122},{85,0,0,1,0,64},{86,0,0,1,0,64},{87,0,0,1,0,64},{88,1,0,1,0,64},{9,0,1,1,91,48},{10,0,1,1,91,48},{11,0,1,1,91,48},{12,1,1,1,91,48},{9,0,1,1,91,49},{10,0,1,1,91,49},{11,0,1,1,91,49},{12,1,1,1,91,49},{9,0,1,1,91,50},{10,0,1,1,91,50},{11,0,1,1,91,50},{12,1,1,1,91,50},{9,0,1,1,91,97},{10,0,1,1,91,97},{11,0,1,1,91,97},{12,1,1,1,91,97},{9,0,1,1,91,99},{10,0,1,1,91,99},{11,0,1,1,91,99},{12,1,1,1,91,99},{9,0,1,1,91,101},{10,0,1,1,91,101},{11,0,1,1,91,101},{12,1,1,1,91,101},{9,0,1,1,91,105},{10,0,1,1,91,105},{11,0,1,1,91,105},{12,1,1,1,91,105},{9,0,1,1,91,111},{10,0,1,1,91,111},{11,0,1,1,91,111},{12,1,1,1,91,111},{9,0,1,1,91,115},{10,0,1,1,91,115},{11,0,1,1,91,115},{12,1,1,1,91,115},{9,0,1,1,91,116},{10,0,1,1,91,116},{11,0,1,1,91,116},{12,1,1,1,91,116},{13,0,1,1,91,32},{14,1,1,1,91,32},{13,0,1,1,91,37},{14,1,1,1,91,37},{13,0,1,1,91,45},{14,1,1,1,91,45},{13,0,1,1,91,46},{14,1,1,1,91,46},{13,0,1,1,91,47},{14,1,1,1,91,47},{13,0,1,1,91,51},{14,1,1,1,91,51},{13,0,1,1,91,52},{14,1,1,1,91,52},{13,0,1,1,91,53},{14,1,1,1,91,53},{13,0,1,1,91,54},{14,1,1,1,91,54},{13,0,1,1,91,55},{14,1,1,1,91,55},{13,0,1,1,91,56},{14,1,1,1,91,56},{13,0,1,1,91,57},{14,1,1,1,91,57},{13,0,1,1,91,61},{14,1,1,1,91,61},{13,0,1,1,91,65},{14,1,1,1,91,65},{13,0,1,1,91,95},{14,1,1,1,91,95},{13,0,1,1,91,98},{14,1,1,1,91,98},{13,0,1,1,91,100},{14,1,1,1,91,100},{13,0,1,1,91,102},{14,1,1,1,91,102},{13,0,1,1,91,103},{14,1,1,1,91,103},{13,0,1,1,91,104},{14,1,1,1,91,104},{13,0,1,1,91,108},{14,1,1,1,91,108},{13,0,1,1,91,109},{14,1,1,1,91,109},{13,0,1,1,91,110},{14,1,1,1,91,110},{13,0,1,1,91,112},{14,1,1,1,91,112},{13,0,1,1,91,114},{14,1,1,1,91,114},{13,0,1,1,91,117},{14,1,1,1,91,117},{0,1,1,1,91,58},{0,1,1,1,91,66},{0,1,1,1,91,67},{0,1,1,1,91,68},{0,1,1,1,91,69},{0,1,1,1,91,70},{0,1,1,1,91,71},{0,1,1,1,91,72},{0,1,1,1,91,73},{0,1,1,1,91,74},{0,1,1,1,91,75},{0,1,1,1,91,76},{0,1,1,1,91,77},{0,1,1,1,91,78},{0,1,1,1,91,79},{0,1,1,1,91,80},{0,1,1,1,91,81},{0,1,1,1,91,82},{0,1,1,1,91,83},{0,1,1,1,91,84},{0,1,1,1,91,85},{0,1,1,1,91,86},{0,1,1,1,91,87},{0,1,1,1,91,89},{0,1,1,1,91,106},{0,1,1,1,91,107},{0,1,1,1,91,113},{0,1,1,1,91,118},{0,1,1,1,91,119},{0,1,1,1,91,120},{0,1,1,1,91,121},{0,1,1,1,91,122},{85,0,0,1,0,91},{86,0,0,1,0,91},{87,0,0,1,0,91},{88,1,0,1,0,91},{9,0,1,1,93,48},{10,0,1,1,93,48},{11,0,1,1,93,48},{12,1,1,1,93,48},{9,0,1,1,93,49},{10,0,1,1,93,49},{11,0,1,1,93,49},{12,1,1,1,93,49},{9,0,1,1,93,50},{10,0,1,1,93,50},{11,0,1,1,93,50},{12,1,1,1,93,50},{9,0,1,1,93,97},{10,0,1,1,93,97},{11,0,1,1,93,97},{12,1,1,1,93,97},{9,0,1,1,93,99},{10,0,1,1,93,99},{11,0,1,1,93,99},{12,1,1,1,93,99},{9,0,1,1,93,101},{10,0,1,1,93,101},{11,0,1,1,93,101},{12,1,1,1,93,101},{9,0,1,1,93,105},{10,0,1,1,93,105},{11,0,1,1,93,105},{12,1,1,1,93,105},{9,0,1,1,93,111},{10,0,1,1,93,111},{11,0,1,1,93,111},{12,1,1,1,93,111},{9,0,1,1,93,115},{10,0,1,1,93,115},{11,0,1,1,93,115},{12,1,1,1,93,115},{9,0,1,1,93,116},{10,0,1,1,93,116},{11,0,1,1,93,116},{12,1,1,1,93,116},{13,0,1,1,93,32},{14,1,1,1,93,32},{13,0,1,1,93,37},{14,1,1,1,93,37},{13,0,1,1,93,45},{14,1,1,1,93,45},{13,0,1,1,93,46},{14,1,1,1,93,46},{13,0,1,1,93,47},{14,1,1,1,93,47},{13,0,1,1,93,51},{14,1,1,1,93,51},{13,0,1,1,93,52},{14,1,1,1,93,52},{13,0,1,1,93,53},{14,1,1,1,93,53},{13,0,1,1,93,54},{14,1,1,1,93,54},{13,0,1,1,93,55},{14,1,1,1,93,55},{13,0,1,1,93,56},{14,1,1,1,93,56},{13,0,1,1,93,57},{14,1,1,1,93,57},{13,0,1,1,93,61},{14,1,1,1,93,61},{13,0,1,1,93,65},{14,1,1,1,93,65},{13,0,1,1,93,95},{14,1,1,1,93,95},{13,0,1,1,93,98},{14,1,1,1,93,98},{13,0,1,1,93,100},{14,1,1,1,93,100},{13,0,1,1,93,102},{14,1,1,1,93,102},{13,0,1,1,93,103},{14,1,1,1,93,103},{13,0,1,1,93,104},{14,1,1,1,93,104},{13,0,1,1,93,108},{14,1,1,1,93,108},{13,0,1,1,93,109},{14,1,1,1,93,109},{13,0,1,1,93,110},{14,1,1,1,93,110},{13,0,1,1,93,112},{14,1,1,1,93,112},{13,0,1,1,93,114},{14,1,1,1,93,114},{13,0,1,1,93,117},{14,1,1,1,93,117},{0,1,1,1,93,58},{0,1,1,1,93,66},{0,1,1,1,93,67},{0,1,1,1,93,68},{0,1,1,1,93,69},{0,1,1,1,93,70},{0,1,1,1,93,71},{0,1,1,1,93,72},{0,1,1,1,93,73},{0,1,1,1,93,74},{0,1,1,1,93,75},{0,1,1,1,93,76},{0,1,1,1,93,77},{0,1,1,1,93,78},{0,1,1,1,93,79},{0,1,1,1,93,80},{0,1,1,1,93,81},{0,1,1,1,93,82},{0,1,1,1,93,83},{0,1,1,1,93,84},{0,1,1,1,93,85},{0,1,1,1,93,86},{0,1,1,1,93,87},{0,1,1,1,93,89},{0,1,1,1,93,106},{0,1,1,1,93,107},{0,1,1,1,93,113},{0,1,1,1,93,118},{0,1,1,1,93,119},{0,1,1,1,93,120},{0,1,1,1,93,121},{0,1,1,1,93,122},{85,0,0,1,0,93},{86,0,0,1,0,93},{87,0,0,1,0,93},{88,1,0,1,0,93},{9,0,1,1,126,48},{10,0,1,1,126,48},{11,0,1,1,126,48},{12,1,1,1,126,48},{9,0,1,1,126,49},{10,0,1,1,126,49},{11,0,1,1,126,49},{12,1,1,1,126,49},{9,0,1,1,126,50},{10,0,1,1,126,50},{11,0,1,1,126,50},{12,1,1,1,126,50},{9,0,1,1,126,97},{10,0,1,1,126,97},{11,0,1,1,126,97},{12,1,1,1,126,97},{9,0,1,1,126,99},{10,0,1,1,126,99},{11,0,1,1,126,99},{12,1,1,1,126,99},{9,0,1,1,126,101},{10,0,1,1,126,101},{11,0,1,1,126,101},{12,1,1,1,126,101},{9,0,1,1,126,105},{10,0,1,1,126,105},{11,0,1,1,126,105},{12,1,1,1,126,105},{9,0,1,1,126,111},{10,0,1,1,126,111},{11,0,1,1,126,111},{12,1,1,1,126,111},{9,0,1,1,126,115},{10,0,1,1,126,115},{11,0,1,1,126,115},{12,1,1,1,126,115},{9,0,1,1,126,116},{10,0,1,1,126,116},{11,0,1,1,126,116},{12,1,1,1,126,116},{13,0,1,1,126,32},{14,1,1,1,126,32},{13,0,1,1,126,37},{14,1,1,1,126,37},{13,0,1,1,126,45},{14,1,1,1,126,45},{13,0,1,1,126,46},{14,1,1,1,126,46},{13,0,1,1,126,47},{14,1,1,1,126,47},{13,0,1,1,126,51},{14,1,1,1,126,51},{13,0,1,1,126,52},{14,1,1,1,126,52},{13,0,1,1,126,53},{14,1,1,1,126,53},{13,0,1,1,126,54},{14,1,1,1,126,54},{13,0,1,1,126,55},{14,1,1,1,126,55},{13,0,1,1,126,56},{14,1,1,1,126,56},{13,0,1,1,126,57},{14,1,1,1,126,57},{13,0,1,1,126,61},{14,1,1,1,126,61},{13,0,1,1,126,65},{14,1,1,1,126,65},{13,0,1,1,126,95},{14,1,1,1,126,95},{13,0,1,1,126,98},{14,1,1,1,126,98},{13,0,1,1,126,100},{14,1,1,1,126,100},{13,0,1,1,126,102},{14,1,1,1,126,102},{13,0,1,1,126,103},{14,1,1,1,126,103},{13,0,1,1,126,104},{14,1,1,1,126,104},{13,0,1,1,126,108},{14,1,1,1,126,108},{13,0,1,1,126,109},{14,1,1,1,126,109},{13,0,1,1,126,110},{14,1,1,1,126,110},{13,0,1,1,126,112},{14,1,1,1,126,112},{13,0,1,1,126,114},{14,1,1,1,126,114},{13,0,1,1,126,117},{14,1,1,1,126,117},{0,1,1,1,126,58},{0,1,1,1,126,66},{0,1,1,1,126,67},{0,1,1,1,126,68},{0,1,1,1,126,69},{0,1,1,1,126,70},{0,1,1,1,126,71},{0,1,1,1,126,72},{0,1,1,1,126,73},{0,1,1,1,126,74},{0,1,1,1,126,75},{0,1,1,1,126,76},{0,1,1,1,126,77},{0,1,1,1,126,78},{0,1,1,1,126,79},{0,1,1,1,126,80},{0,1,1,1,126,81},{0,1,1,1,126,82},{0,1,1,1,126,83},{0,1,1,1,126,84},{0,1,1,1,126,85},{0,1,1,1,126,86},{0,1,1,1,126,87},{0,1,1,1,126,89},{0,1,1,1,126,106},{0,1,1,1,126,107},{0,1,1,1,126,113},{0,1,1,1,126,118},{0,1,1,1,126,119},{0,1,1,1,126,120},{0,1,1,1,126,121},{0,1,1,1,126,122},{85,0,0,1,0,126},{86,0,0,1,0,126},{87,0,0,1,0,126},{88,1,0,1,0,126},{13,0,1,1,94,48},{14,1,1,1,94,48},{13,0,1,1,94,49},{14,1,1,1,94,49},{13,0,1,1,94,50},{14,1,1,1,94,50},{13,0,1,1,94,97},{14,1,1,1,94,97},{13,0,1,1,94,99},{14,1,1,1,94,99},{13,0,1,1,94,101},{14,1,1,1,94,101},{13,0,1,1,94,105},{14,1,1,1,94,105},{13,0,1,1,94,111},{14,1,1,1,94,111},{13,0,1,1,94,115},{14,1,1,1,94,115},{13,0,1,1,94,116},{14,1,1,1,94,116},{0,1,1,1,94,32},{0,1,1,1,94,37},{0,1,1,1,94,45},{0,1,1,1,94,46},{0,1,1,1,94,47},{0,1,1,1,94,51},{0,1,1,1,94,52},{0,1,1,1,94,53},{0,1,1,1,94,54},{0,1,1,1,94,55},{0,1,1,1,94,56},{0,1,1,1,94,57},{0,1,1,1,94,61},{0,1,1,1,94,65},{0,1,1,1,94,95},{0,1,1,1,94,98},{0,1,1,1,94,100},{0,1,1,1,94,102},{0,1,1,1,94,103},{0,1,1,1,94,104},{0,1,1,1,94,108},{0,1,1,1,94,109},{0,1,1,1,94,110},{0,1,1,1,94,112},{0,1,1,1,94,114},{0,1,1,1,94,117},{17,0,0,1,0,94},{18,0,0,1,0,94},{19,0,0,1,0,94},{20,0,0,1,0,94},{21,0,0,1,0,94},{22,0,0,1,0,94},{23,0,0,1,0,94},{24,0,0,1,0,94},{25,0,0,1,0,94},{26,0,0,1,0,94},{27,0,0,1,0,94},{28,0,0,1,0,94},{29,0,0,1,0,94},{30,0,0,1,0,94},{31,0,0,1,0,94},{32,0,0,1,0,94},{33,0,0,1,0,94},{34,1,0,1,0,94},{13,0,1,1,125,48},{14,1,1,1,125,48},{13,0,1,1,125,49},{14,1,1,1,125,49},{13,0,1,1,125,50},{14,1,1,1,125,50},{13,0,1,1,125,97},{14,1,1,1,125,97},{13,0,1,1,125,99},{14,1,1,1,125,99},{13,0,1,1,125,101},{14,1,1,1,125,101},{13,0,1,1,125,105},{14,1,1,1,125,105},{13,0,1,1,125,111},{14,1,1,1,125,111},{13,0,1,1,125,115},{14,1,1,1,125,115},{13,0,1,1,125,116},{14,1,1,1,125,116},{0,1,1,1,125,32},{0,1,1,1,125,37},{0,1,1,1,125,45},{0,1,1,1,125,46},{0,1,1,1,125,47},{0,1,1,1,125,51},{0,1,1,1,125,52},{0,1,1,1,125,53},{0,1,1,1,125,54},{0,1,1,1,125,55},{0,1,1,1,125,56},{0,1,1,1,125,57},{0,1,1,1,125,61},{0,1,1,1,125,65},{0,1,1,1,125,95},{0,1,1,1,125,98},{0,1,1,1,125,100},{0,1,1,1,125,102},{0,1,1,1,125,103},{0,1,1,1,125,104},{0,1,1,1,125,108},{0,1,1,1,125,109},{0,1,1,1,125,110},{0,1,1,1,125,112},{0,1,1,1,125,114},{0,1,1,1,125,117},{17,0,0,1,0,125},{18,0,0,1,0,125},{19,0,0,1,0,125},{20,0,0,1,0,125},{21,0,0,1,0,125},{22,0,0,1,0,125},{23,0,0,1,0,125},{24,0,0,1,0,125},{25,0,0,1,0,125},{26,0,0,1,0,125},{27,0,0,1,0,125},{28,0,0,1,0,125},{29,0,0,1,0,125},{30,0,0,1,0,125},{31,0,0,1,0,125},{32,0,0,1,0,125},{33,0,0,1,0,125},{34,1,0,1,0,125},{0,1,1,1,60,48},{0,1,1,1,60,49},{0,1,1,1,60,50},{0,1,1,1,60,97},{0,1,1,1,60,99},{0,1,1,1,60,101},{0,1,1,1,60,105},{0,1,1,1,60,111},{0,1,1,1,60,115},{0,1,1,1,60,116},{35,0,0,1,0,60},{36,0,0,1,0,60},{37,0,0,1,0,60},{38,0,0,1,0,60},{39,0,0,1,0,60},{40,0,0,1,0,60},{41,0,0,1,0,60},{42,0,0,1,0,60},{43,0,0,1,0,60},{44,0,0,1,0,60},{45,0,0,1,0,60},{46,0,0,1,0,60},{47,0,0,1,0,60},{48,0,0,1,0,60},{49,0,0,1,0,60},{50,0,0,1,0,60},{51,0,0,1,0,60},{52,0,0,1,0,60},{53,0,0,1,0,60},{54,0,0,1,0,60},{55,0,0,1,0,60},{56,1,0,1,0,60},{0,1,1,1,96,48},{0,1,1,1,96,49},{0,1,1,1,96,50},{0,1,1,1,96,97},{0,1,1,1,96,99},{0,1,1,1,96,101},{0,1,1,1,96,105},{0,1,1,1,96,111},{0,1,1,1,96,115},{0,1,1,1,96,116},{35,0,0,1,0,96},{36,0,0,1,0,96},{37,0,0,1,0,96},{38,0,0,1,0,96},{39,0,0,1,0,96},{40,0,0,1,0,96},{41,0,0,1,0,96},{42,0,0,1,0,96},{43,0,0,1,0,96},{44,0,0,1,0,96},{45,0,0,1,0,96},{46,0,0,1,0,96},{47,0,0,1,0,96},{48,0,0,1,0,96},{49,0,0,1,0,96},{50,0,0,1,0,96},{51,0,0,1,0,96},{52,0,0,1,0,96},{53,0,0,1,0,96},{54,0,0,1,0,96},{55,0,0,1,0,96},{56,1,0,1,0,96},{0,1,1,1,123,48},{0,1,1,1,123,49},{0,1,1,1,123,50},{0,1,1,1,123,97},{0,1,1,1,123,99},{0,1,1,1,123,101},{0,1,1,1,123,105},{0,1,1,1,123,111},{0,1,1,1,123,115},{0,1,1,1,123,116},{35,0,0,1,0,123},{36,0,0,1,0,123},{37,0,0,1,0,123},{38,0,0,1,0,123},{39,0,0,1,0,123},{40,0,0,1,0,123},{41,0,0,1,0,123},{42,0,0,1,0,123},{43,0,0,1,0,123},{44,0,0,1,0,123},{45,0,0,1,0,123},{46,0,0,1,0,123},{47,0,0,1,0,123},{48,0,0,1,0,123},{49,0,0,1,0,123},{50,0,0,1,0,123},{51,0,0,1,0,123},{52,0,0,1,0,123},{53,0,0,1,0,123},{54,0,0,1,0,123},{55,0,0,1,0,123},{56,1,0,1,0,123},{13,0,0,1,0,92},{14,1,0,1,0,92},{13,0,0,1,0,195},{14,1,0,1,0,195},{13,0,0,1,0,208},{14,1,0,1,0,208},{0,1,0,1,0,128},{0,1,0,1,0,130},{0,1,0,1,0,131},{0,1,0,1,0,162},{0,1,0,1,0,184},{0,1,0,1,0,194},{0,1,0,1,0,224},{0,1,0,1,0,226},{176,0,0,0,0,0},{177,0,0,0,0,0},{178,0,0,0,0,0},{179,0,0,0,0,0},{180,0,0,0,0,0},{181,0,0,0,0,0},{182,0,0,0,0,0},{183,0,0,0,0,0},{184,0,0,0,0,0},{185,0,0,0,0,0},{186,0,0,0,0,0},{187,0,0,0,0,0},{188,0,0,0,0,0},{189,0,0,0,0,0},{190,0,0,0,0,0},{191,0,0,0,0,0},{192,0,0,0,0,0},{193,0,0,0,0,0},{9,0,1,1,128,48},{10,0,1,1,128,48},{11,0,1,1,128,48},{12,1,1,1,128,48},{9,0,1,1,128,49},{10,0,1,1,128,49},{11,0,1,1,128,49},{12,1,1,1,128,49},{9,0,1,1,128,50},{10,0,1,1,128,50},{11,0,1,1,128,50},{12,1,1,1,128,50},{9,0,1,1,128,97},{10,0,1,1,128,97},{11,0,1,1,128,97},{12,1,1,1,128,97},{9,0,1,1,128,99},{10,0,1,1,128,99},{11,0,1,1,128,99},{12,1,1,1,128,99},{9,0,1,1,128,101},{10,0,1,1,128,101},{11,0,1,1,128,101},{12,1,1,1,128,101},{9,0,1,1,128,105},{10,0,1,1,128,105},{11,0,1,1,128,105},{12,1,1,1,128,105},{9,0,1,1,128,111},{10,0,1,1,128,111},{11,0,1,1,128,111},{12,1,1,1,128,111},{9,0,1,1,128,115},{10,0,1,1,128,115},{11,0,1,1,128,115},{12,1,1,1,128,115},{9,0,1,1,128,116},{10,0,1,1,128,116},{11,0,1,1,128,116},{12,1,1,1,128,116},{13,0,1,1,128,32},{14,1,1,1,128,32},{13,0,1,1,128,37},{14,1,1,1,128,37},{13,0,1,1,128,45},{14,1,1,1,128,45},{13,0,1,1,128,46},{14,1,1,1,128,46},{13,0,1,1,128,47},{14,1,1,1,128,47},{13,0,1,1,128,51},{14,1,1,1,128,51},{13,0,1,1,128,52},{14,1,1,1,128,52},{13,0,1,1,128,53},{14,1,1,1,128,53},{13,0,1,1,128,54},{14,1,1,1,128,54},{13,0,1,1,128,55},{14,1,1,1,128,55},{13,0,1,1,128,56},{14,1,1,1,128,56},{13,0,1,1,128,57},{14,1,1,1,128,57},{13,0,1,1,128,61},{14,1,1,1,128,61},{13,0,1,1,128,65},{14,1,1,1,128,65},{13,0,1,1,128,95},{14,1,1,1,128,95},{13,0,1,1,128,98},{14,1,1,1,128,98},{13,0,1,1,128,100},{14,1,1,1,128,100},{13,0,1,1,128,102},{14,1,1,1,128,102},{13,0,1,1,128,103},{14,1,1,1,128,103},{13,0,1,1,128,104},{14,1,1,1,128,104},{13,0,1,1,128,108},{14,1,1,1,128,108},{13,0,1,1,128,109},{14,1,1,1,128,109},{13,0,1,1,128,110},{14,1,1,1,128,110},{13,0,1,1,128,112},{14,1,1,1,128,112},{13,0,1,1,128,114},{14,1,1,1,128,114},{13,0,1,1,128,117},{14,1,1,1,128,117},{0,1,1,1,128,58},{0,1,1,1,128,66},{0,1,1,1,128,67},{0,1,1,1,128,68},{0,1,1,1,128,69},{0,1,1,1,128,70},{0,1,1,1,128,71},{0,1,1,1,128,72},{0,1,1,1,128,73},{0,1,1,1,128,74},{0,1,1,1,128,75},{0,1,1,1,128,76},{0,1,1,1,128,77},{0,1,1,1,128,78},{0,1,1,1,128,79},{0,1,1,1,128,80},{0,1,1,1,128,81},{0,1,1,1,128,82},{0,1,1,1,128,83},{0,1,1,1,128,84},{0,1,1,1,128,85},{0,1,1,1,128,86},{0,1,1,1,128,87},{0,1,1,1,128,89},{0,1,1,1,128,106},{0,1,1,1,128,107},{0,1,1,1,128,113},{0,1,1,1,128,118},{0,1,1,1,128,119},{0,1,1,1,128,120},{0,1,1,1,128,121},{0,1,1,1,128,122},{85,0,0,1,0,128},{86,0,0,1,0,128},{87,0,0,1,0,128},{88,1,0,1,0,128},{9,0,1,1,130,48},{10,0,1,1,130,48},{11,0,1,1,130,48},{12,1,1,1,130,48},{9,0,1,1,130,49},{10,0,1,1,130,49},{11,0,1,1,130,49},{12,1,1,1,130,49},{9,0,1,1,130,50},{10,0,1,1,130,50},{11,0,1,1,130,50},{12,1,1,1,130,50},{9,0,1,1,130,97},{10,0,1,1,130,97},{11,0,1,1,130,97},{12,1,1,1,130,97},{9,0,1,1,130,99},{10,0,1,1,130,99},{11,0,1,1,130,99},{12,1,1,1,130,99},{9,0,1,1,130,101},{10,0,1,1,130,101},{11,0,1,1,130,101},{12,1,1,1,130,101},{9,0,1,1,130,105},{10,0,1,1,130,105},{11,0,1,1,130,105},{12,1,1,1,130,105},{9,0,1,1,130,111},{10,0,1,1,130,111},{11,0,1,1,130,111},{12,1,1,1,130,111},{9,0,1,1,130,115},{10,0,1,1,130,115},{11,0,1,1,130,115},{12,1,1,1,130,115},{9,0,1,1,130,116},{10,0,1,1,130,116},{11,0,1,1,130,116},{12,1,1,1,130,116},{13,0,1,1,130,32},{14,1,1,1,130,32},{13,0,1,1,130,37},{14,1,1,1,130,37},{13,0,1,1,130,45},{14,1,1,1,130,45},{13,0,1,1,130,46},{14,1,1,1,130,46},{13,0,1,1,130,47},{14,1,1,1,130,47},{13,0,1,1,130,51},{14,1,1,1,130,51},{13,0,1,1,130,52},{14,1,1,1,130,52},{13,0,1,1,130,53},{14,1,1,1,130,53},{13,0,1,1,130,54},{14,1,1,1,130,54},{13,0,1,1,130,55},{14,1,1,1,130,55},{13,0,1,1,130,56},{14,1,1,1,130,56},{13,0,1,1,130,57},{14,1,1,1,130,57},{13,0,1,1,130,61},{14,1,1,1,130,61},{13,0,1,1,130,65},{14,1,1,1,130,65},{13,0,1,1,130,95},{14,1,1,1,130,95},{13,0,1,1,130,98},{14,1,1,1,130,98},{13,0,1,1,130,100},{14,1,1,1,130,100},{13,0,1,1,130,102},{14,1,1,1,130,102},{13,0,1,1,130,103},{14,1,1,1,130,103},{13,0,1,1,130,104},{14,1,1,1,130,104},{13,0,1,1,130,108},{14,1,1,1,130,108},{13,0,1,1,130,109},{14,1,1,1,130,109},{13,0,1,1,130,110},{14,1,1,1,130,110},{13,0,1,1,130,112},{14,1,1,1,130,112},{13,0,1,1,130,114},{14,1,1,1,130,114},{13,0,1,1,130,117},{14,1,1,1,130,117},{0,1,1,1,130,58},{0,1,1,1,130,66},{0,1,1,1,130,67},{0,1,1,1,130,68},{0,1,1,1,130,69},{0,1,1,1,130,70},{0,1,1,1,130,71},{0,1,1,1,130,72},{0,1,1,1,130,73},{0,1,1,1,130,74},{0,1,1,1,130,75},{0,1,1,1,130,76},{0,1,1,1,130,77},{0,1,1,1,130,78},{0,1,1,1,130,79},{0,1,1,1,130,80},{0,1,1,1,130,81},{0,1,1,1,130,82},{0,1,1,1,130,83},{0,1,1,1,130,84},{0,1,1,1,130,85},{0,1,1,1,130,86},{0,1,1,1,130,87},{0,1,1,1,130,89},{0,1,1,1,130,106},{0,1,1,1,130,107},{0,1,1,1,130,113},{0,1,1,1,130,118},{0,1,1,1,130,119},{0,1,1,1,130,120},{0,1,1,1,130,121},{0,1,1,1,130,122},{85,0,0,1,0,130},{86,0,0,1,0,130},{87,0,0,1,0,130},{88,1,0,1,0,130},{9,0,1,1,131,48},{10,0,1,1,131,48},{11,0,1,1,131,48},{12,1,1,1,131,48},{9,0,1,1,131,49},{10,0,1,1,131,49},{11,0,1,1,131,49},{12,1,1,1,131,49},{9,0,1,1,131,50},{10,0,1,1,131,50},{11,0,1,1,131,50},{12,1,1,1,131,50},{9,0,1,1,131,97},{10,0,1,1,131,97},{11,0,1,1,131,97},{12,1,1,1,131,97},{9,0,1,1,131,99},{10,0,1,1,131,99},{11,0,1,1,131,99},{12,1,1,1,131,99},{9,0,1,1,131,101},{10,0,1,1,131,101},{11,0,1,1,131,101},{12,1,1,1,131,101},{9,0,1,1,131,105},{10,0,1,1,131,105},{11,0,1,1,131,105},{12,1,1,1,131,105},{9,0,1,1,131,111},{10,0,1,1,131,111},{11,0,1,1,131,111},{12,1,1,1,131,111},{9,0,1,1,131,115},{10,0,1,1,131,115},{11,0,1,1,131,115},{12,1,1,1,131,115},{9,0,1,1,131,116},{10,0,1,1,131,116},{11,0,1,1,131,116},{12,1,1,1,131,116},{13,0,1,1,131,32},{14,1,1,1,131,32},{13,0,1,1,131,37},{14,1,1,1,131,37},{13,0,1,1,131,45},{14,1,1,1,131,45},{13,0,1,1,131,46},{14,1,1,1,131,46},{13,0,1,1,131,47},{14,1,1,1,131,47},{13,0,1,1,131,51},{14,1,1,1,131,51},{13,0,1,1,131,52},{14,1,1,1,131,52},{13,0,1,1,131,53},{14,1,1,1,131,53},{13,0,1,1,131,54},{14,1,1,1,131,54},{13,0,1,1,131,55},{14,1,1,1,131,55},{13,0,1,1,131,56},{14,1,1,1,131,56},{13,0,1,1,131,57},{14,1,1,1,131,57},{13,0,1,1,131,61},{14,1,1,1,131,61},{13,0,1,1,131,65},{14,1,1,1,131,65},{13,0,1,1,131,95},{14,1,1,1,131,95},{13,0,1,1,131,98},{14,1,1,1,131,98},{13,0,1,1,131,100},{14,1,1,1,131,100},{13,0,1,1,131,102},{14,1,1,1,131,102},{13,0,1,1,131,103},{14,1,1,1,131,103},{13,0,1,1,131,104},{14,1,1,1,131,104},{13,0,1,1,131,108},{14,1,1,1,131,108},{13,0,1,1,131,109},{14,1,1,1,131,109},{13,0,1,1,131,110},{14,1,1,1,131,110},{13,0,1,1,131,112},{14,1,1,1,131,112},{13,0,1,1,131,114},{14,1,1,1,131,114},{13,0,1,1,131,117},{14,1,1,1,131,117},{0,1,1,1,131,58},{0,1,1,1,131,66},{0,1,1,1,131,67},{0,1,1,1,131,68},{0,1,1,1,131,69},{0,1,1,1,131,70},{0,1,1,1,131,71},{0,1,1,1,131,72},{0,1,1,1,131,73},{0,1,1,1,131,74},{0,1,1,1,131,75},{0,1,1,1,131,76},{0,1,1,1,131,77},{0,1,1,1,131,78},{0,1,1,1,131,79},{0,1,1,1,131,80},{0,1,1,1,131,81},{0,1,1,1,131,82},{0,1,1,1,131,83},{0,1,1,1,131,84},{0,1,1,1,131,85},{0,1,1,1,131,86},{0,1,1,1,131,87},{0,1,1,1,131,89},{0,1,1,1,131,106},{0,1,1,1,131,107},{0,1,1,1,131,113},{0,1,1,1,131,118},{0,1,1,1,131,119},{0,1,1,1,131,120},{0,1,1,1,131,121},{0,1,1,1,131,122},{85,0,0,1,0,131},{86,0,0,1,0,131},{87,0,0,1,0,131},{88,1,0,1,0,131},{9,0,1,1,162,48},{10,0,1,1,162,48},{11,0,1,1,162,48},{12,1,1,1,162,48},{9,0,1,1,162,49},{10,0,1,1,162,49},{11,0,1,1,162,49},{12,1,1,1,162,49},{9,0,1,1,162,50},{10,0,1,1,162,50},{11,0,1,1,162,50},{12,1,1,1,162,50},{9,0,1,1,162,97},{10,0,1,1,162,97},{11,0,1,1,162,97},{12,1,1,1,162,97},{9,0,1,1,162,99},{10,0,1,1,162,99},{11,0,1,1,162,99},{12,1,1,1,162,99},{9,0,1,1,162,101},{10,0,1,1,162,101},{11,0,1,1,162,101},{12,1,1,1,162,101},{9,0,1,1,162,105},{10,0,1,1,162,105},{11,0,1,1,162,105},{12,1,1,1,162,105},{9,0,1,1,162,111},{10,0,1,1,162,111},{11,0,1,1,162,111},{12,1,1,1,162,111},{9,0,1,1,162,115},{10,0,1,1,162,115},{11,0,1,1,162,115},{12,1,1,1,162,115},{9,0,1,1,162,116},{10,0,1,1,162,116},{11,0,1,1,162,116},{12,1,1,1,162,116},{13,0,1,1,162,32},{14,1,1,1,162,32},{13,0,1,1,162,37},{14,1,1,1,162,37},{13,0,1,1,162,45},{14,1,1,1,162,45},{13,0,1,1,162,46},{14,1,1,1,162,46},{13,0,1,1,162,47},{14,1,1,1,162,47},{13,0,1,1,162,51},{14,1,1,1,162,51},{13,0,1,1,162,52},{14,1,1,1,162,52},{13,0,1,1,162,53},{14,1,1,1,162,53},{13,0,1,1,162,54},{14,1,1,1,162,54},{13,0,1,1,162,55},{14,1,1,1,162,55},{13,0,1,1,162,56},{14,1,1,1,162,56},{13,0,1,1,162,57},{14,1,1,1,162,57},{13,0,1,1,162,61},{14,1,1,1,162,61},{13,0,1,1,162,65},{14,1,1,1,162,65},{13,0,1,1,162,95},{14,1,1,1,162,95},{13,0,1,1,162,98},{14,1,1,1,162,98},{13,0,1,1,162,100},{14,1,1,1,162,100},{13,0,1,1,162,102},{14,1,1,1,162,102},{13,0,1,1,162,103},{14,1,1,1,162,103},{13,0,1,1,162,104},{14,1,1,1,162,104},{13,0,1,1,162,108},{14,1,1,1,162,108},{13,0,1,1,162,109},{14,1,1,1,162,109},{13,0,1,1,162,110},{14,1,1,1,162,110},{13,0,1,1,162,112},{14,1,1,1,162,112},{13,0,1,1,162,114},{14,1,1,1,162,114},{13,0,1,1,162,117},{14,1,1,1,162,117},{0,1,1,1,162,58},{0,1,1,1,162,66},{0,1,1,1,162,67},{0,1,1,1,162,68},{0,1,1,1,162,69},{0,1,1,1,162,70},{0,1,1,1,162,71},{0,1,1,1,162,72},{0,1,1,1,162,73},{0,1,1,1,162,74},{0,1,1,1,162,75},{0,1,1,1,162,76},{0,1,1,1,162,77},{0,1,1,1,162,78},{0,1,1,1,162,79},{0,1,1,1,162,80},{0,1,1,1,162,81},{0,1,1,1,162,82},{0,1,1,1,162,83},{0,1,1,1,162,84},{0,1,1,1,162,85},{0,1,1,1,162,86},{0,1,1,1,162,87},{0,1,1,1,162,89},{0,1,1,1,162,106},{0,1,1,1,162,107},{0,1,1,1,162,113},{0,1,1,1,162,118},{0,1,1,1,162,119},{0,1,1,1,162,120},{0,1,1,1,162,121},{0,1,1,1,162,122},{85,0,0,1,0,162},{86,0,0,1,0,162},{87,0,0,1,0,162},{88,1,0,1,0,162},{9,0,1,1,184,48},{10,0,1,1,184,48},{11,0,1,1,184,48},{12,1,1,1,184,48},{9,0,1,1,184,49},{10,0,1,1,184,49},{11,0,1,1,184,49},{12,1,1,1,184,49},{9,0,1,1,184,50},{10,0,1,1,184,50},{11,0,1,1,184,50},{12,1,1,1,184,50},{9,0,1,1,184,97},{10,0,1,1,184,97},{11,0,1,1,184,97},{12,1,1,1,184,97},{9,0,1,1,184,99},{10,0,1,1,184,99},{11,0,1,1,184,99},{12,1,1,1,184,99},{9,0,1,1,184,101},{10,0,1,1,184,101},{11,0,1,1,184,101},{12,1,1,1,184,101},{9,0,1,1,184,105},{10,0,1,1,184,105},{11,0,1,1,184,105},{12,1,1,1,184,105},{9,0,1,1,184,111},{10,0,1,1,184,111},{11,0,1,1,184,111},{12,1,1,1,184,111},{9,0,1,1,184,115},{10,0,1,1,184,115},{11,0,1,1,184,115},{12,1,1,1,184,115},{9,0,1,1,184,116},{10,0,1,1,184,116},{11,0,1,1,184,116},{12,1,1,1,184,116},{13,0,1,1,184,32},{14,1,1,1,184,32},{13,0,1,1,184,37},{14,1,1,1,184,37},{13,0,1,1,184,45},{14,1,1,1,184,45},{13,0,1,1,184,46},{14,1,1,1,184,46},{13,0,1,1,184,47},{14,1,1,1,184,47},{13,0,1,1,184,51},{14,1,1,1,184,51},{13,0,1,1,184,52},{14,1,1,1,184,52},{13,0,1,1,184,53},{14,1,1,1,184,53},{13,0,1,1,184,54},{14,1,1,1,184,54},{13,0,1,1,184,55},{14,1,1,1,184,55},{13,0,1,1,184,56},{14,1,1,1,184,56},{13,0,1,1,184,57},{14,1,1,1,184,57},{13,0,1,1,184,61},{14,1,1,1,184,61},{13,0,1,1,184,65},{14,1,1,1,184,65},{13,0,1,1,184,95},{14,1,1,1,184,95},{13,0,1,1,184,98},{14,1,1,1,184,98},{13,0,1,1,184,100},{14,1,1,1,184,100},{13,0,1,1,184,102},{14,1,1,1,184,102},{13,0,1,1,184,103},{14,1,1,1,184,103},{13,0,1,1,184,104},{14,1,1,1,184,104},{13,0,1,1,184,108},{14,1,1,1,184,108},{13,0,1,1,184,109},{14,1,1,1,184,109},{13,0,1,1,184,110},{14,1,1,1,184,110},{13,0,1,1,184,112},{14,1,1,1,184,112},{13,0,1,1,184,114},{14,1,1,1,184,114},{13,0,1,1,184,117},{14,1,1,1,184,117},{0,1,1,1,184,58},{0,1,1,1,184,66},{0,1,1,1,184,67},{0,1,1,1,184,68},{0,1,1,1,184,69},{0,1,1,1,184,70},{0,1,1,1,184,71},{0,1,1,1,184,72},{0,1,1,1,184,73},{0,1,1,1,184,74},{0,1,1,1,184,75},{0,1,1,1,184,76},{0,1,1,1,184,77},{0,1,1,1,184,78},{0,1,1,1,184,79},{0,1,1,1,184,80},{0,1,1,1,184,81},{0,1,1,1,184,82},{0,1,1,1,184,83},{0,1,1,1,184,84},{0,1,1,1,184,85},{0,1,1,1,184,86},{0,1,1,1,184,87},{0,1,1,1,184,89},{0,1,1,1,184,106},{0,1,1,1,184,107},{0,1,1,1,184,113},{0,1,1,1,184,118},{0,1,1,1,184,119},{0,1,1,1,184,120},{0,1,1,1,184,121},{0,1,1,1,184,122},{85,0,0,1,0,184},{86,0,0,1,0,184},{87,0,0,1,0,184},{88,1,0,1,0,184},{9,0,1,1,194,48},{10,0,1,1,194,48},{11,0,1,1,194,48},{12,1,1,1,194,48},{9,0,1,1,194,49},{10,0,1,1,194,49},{11,0,1,1,194,49},{12,1,1,1,194,49},{9,0,1,1,194,50},{10,0,1,1,194,50},{11,0,1,1,194,50},{12,1,1,1,194,50},{9,0,1,1,194,97},{10,0,1,1,194,97},{11,0,1,1,194,97},{12,1,1,1,194,97},{9,0,1,1,194,99},{10,0,1,1,194,99},{11,0,1,1,194,99},{12,1,1,1,194,99},{9,0,1,1,194,101},{10,0,1,1,194,101},{11,0,1,1,194,101},{12,1,1,1,194,101},{9,0,1,1,194,105},{10,0,1,1,194,105},{11,0,1,1,194,105},{12,1,1,1,194,105},{9,0,1,1,194,111},{10,0,1,1,194,111},{11,0,1,1,194,111},{12,1,1,1,194,111},{9,0,1,1,194,115},{10,0,1,1,194,115},{11,0,1,1,194,115},{12,1,1,1,194,115},{9,0,1,1,194,116},{10,0,1,1,194,116},{11,0,1,1,194,116},{12,1,1,1,194,116},{13,0,1,1,194,32},{14,1,1,1,194,32},{13,0,1,1,194,37},{14,1,1,1,194,37},{13,0,1,1,194,45},{14,1,1,1,194,45},{13,0,1,1,194,46},{14,1,1,1,194,46},{13,0,1,1,194,47},{14,1,1,1,194,47},{13,0,1,1,194,51},{14,1,1,1,194,51},{13,0,1,1,194,52},{14,1,1,1,194,52},{13,0,1,1,194,53},{14,1,1,1,194,53},{13,0,1,1,194,54},{14,1,1,1,194,54},{13,0,1,1,194,55},{14,1,1,1,194,55},{13,0,1,1,194,56},{14,1,1,1,194,56},{13,0,1,1,194,57},{14,1,1,1,194,57},{13,0,1,1,194,61},{14,1,1,1,194,61},{13,0,1,1,194,65},{14,1,1,1,194,65},{13,0,1,1,194,95},{14,1,1,1,194,95},{13,0,1,1,194,98},{14,1,1,1,194,98},{13,0,1,1,194,100},{14,1,1,1,194,100},{13,0,1,1,194,102},{14,1,1,1,194,102},{13,0,1,1,194,103},{14,1,1,1,194,103},{13,0,1,1,194,104},{14,1,1,1,194,104},{13,0,1,1,194,108},{14,1,1,1,194,108},{13,0,1,1,194,109},{14,1,1,1,194,109},{13,0,1,1,194,110},{14,1,1,1,194,110},{13,0,1,1,194,112},{14,1,1,1,194,112},{13,0,1,1,194,114},{14,1,1,1,194,114},{13,0,1,1,194,117},{14,1,1,1,194,117},{0,1,1,1,194,58},{0,1,1,1,194,66},{0,1,1,1,194,67},{0,1,1,1,194,68},{0,1,1,1,194,69},{0,1,1,1,194,70},{0,1,1,1,194,71},{0,1,1,1,194,72},{0,1,1,1,194,73},{0,1,1,1,194,74},{0,1,1,1,194,75},{0,1,1,1,194,76},{0,1,1,1,194,77},{0,1,1,1,194,78},{0,1,1,1,194,79},{0,1,1,1,194,80},{0,1,1,1,194,81},{0,1,1,1,194,82},{0,1,1,1,194,83},{0,1,1,1,194,84},{0,1,1,1,194,85},{0,1,1,1,194,86},{0,1,1,1,194,87},{0,1,1,1,194,89},{0,1,1,1,194,106},{0,1,1,1,194,107},{0,1,1,1,194,113},{0,1,1,1,194,118},{0,1,1,1,194,119},{0,1,1,1,194,120},{0,1,1,1,194,121},{0,1,1,1,194,122},{85,0,0,1,0,194},{86,0,0,1,0,194},{87,0,0,1,0,194},{88,1,0,1,0,194},{9,0,1,1,224,48},{10,0,1,1,224,48},{11,0,1,1,224,48},{12,1,1,1,224,48},{9,0,1,1,224,49},{10,0,1,1,224,49},{11,0,1,1,224,49},{12,1,1,1,224,49},{9,0,1,1,224,50},{10,0,1,1,224,50},{11,0,1,1,224,50},{12,1,1,1,224,50},{9,0,1,1,224,97},{10,0,1,1,224,97},{11,0,1,1,224,97},{12,1,1,1,224,97},{9,0,1,1,224,99},{10,0,1,1,224,99},{11,0,1,1,224,99},{12,1,1,1,224,99},{9,0,1,1,224,101},{10,0,1,1,224,101},{11,0,1,1,224,101},{12,1,1,1,224,101},{9,0,1,1,224,105},{10,0,1,1,224,105},{11,0,1,1,224,105},{12,1,1,1,224,105},{9,0,1,1,224,111},{10,0,1,1,224,111},{11,0,1,1,224,111},{12,1,1,1,224,111},{9,0,1,1,224,115},{10,0,1,1,224,115},{11,0,1,1,224,115},{12,1,1,1,224,115},{9,0,1,1,224,116},{10,0,1,1,224,116},{11,0,1,1,224,116},{12,1,1,1,224,116},{13,0,1,1,224,32},{14,1,1,1,224,32},{13,0,1,1,224,37},{14,1,1,1,224,37},{13,0,1,1,224,45},{14,1,1,1,224,45},{13,0,1,1,224,46},{14,1,1,1,224,46},{13,0,1,1,224,47},{14,1,1,1,224,47},{13,0,1,1,224,51},{14,1,1,1,224,51},{13,0,1,1,224,52},{14,1,1,1,224,52},{13,0,1,1,224,53},{14,1,1,1,224,53},{13,0,1,1,224,54},{14,1,1,1,224,54},{13,0,1,1,224,55},{14,1,1,1,224,55},{13,0,1,1,224,56},{14,1,1,1,224,56},{13,0,1,1,224,57},{14,1,1,1,224,57},{13,0,1,1,224,61},{14,1,1,1,224,61},{13,0,1,1,224,65},{14,1,1,1,224,65},{13,0,1,1,224,95},{14,1,1,1,224,95},{13,0,1,1,224,98},{14,1,1,1,224,98},{13,0,1,1,224,100},{14,1,1,1,224,100},{13,0,1,1,224,102},{14,1,1,1,224,102},{13,0,1,1,224,103},{14,1,1,1,224,103},{13,0,1,1,224,104},{14,1,1,1,224,104},{13,0,1,1,224,108},{14,1,1,1,224,108},{13,0,1,1,224,109},{14,1,1,1,224,109},{13,0,1,1,224,110},{14,1,1,1,224,110},{13,0,1,1,224,112},{14,1,1,1,224,112},{13,0,1,1,224,114},{14,1,1,1,224,114},{13,0,1,1,224,117},{14,1,1,1,224,117},{0,1,1,1,224,58},{0,1,1,1,224,66},{0,1,1,1,224,67},{0,1,1,1,224,68},{0,1,1,1,224,69},{0,1,1,1,224,70},{0,1,1,1,224,71},{0,1,1,1,224,72},{0,1,1,1,224,73},{0,1,1,1,224,74},{0,1,1,1,224,75},{0,1,1,1,224,76},{0,1,1,1,224,77},{0,1,1,1,224,78},{0,1,1,1,224,79},{0,1,1,1,224,80},{0,1,1,1,224,81},{0,1,1,1,224,82},{0,1,1,1,224,83},{0,1,1,1,224,84},{0,1,1,1,224,85},{0,1,1,1,224,86},{0,1,1,1,224,87},{0,1,1,1,224,89},{0,1,1,1,224,106},{0,1,1,1,224,107},{0,1,1,1,224,113},{0,1,1,1,224,118},{0,1,1,1,224,119},{0,1,1,1,224,120},{0,1,1,1,224,121},{0,1,1,1,224,122},{85,0,0,1,0,224},{86,0,0,1,0,224},{87,0,0,1,0,224},{88,1,0,1,0,224},{9,0,1,1,226,48},{10,0,1,1,226,48},{11,0,1,1,226,48},{12,1,1,1,226,48},{9,0,1,1,226,49},{10,0,1,1,226,49},{11,0,1,1,226,49},{12,1,1,1,226,49},{9,0,1,1,226,50},{10,0,1,1,226,50},{11,0,1,1,226,50},{12,1,1,1,226,50},{9,0,1,1,226,97},{10,0,1,1,226,97},{11,0,1,1,226,97},{12,1,1,1,226,97},{9,0,1,1,226,99},{10,0,1,1,226,99},{11,0,1,1,226,99},{12,1,1,1,226,99},{9,0,1,1,226,101},{10,0,1,1,226,101},{11,0,1,1,226,101},{12,1,1,1,226,101},{9,0,1,1,226,105},{10,0,1,1,226,105},{11,0,1,1,226,105},{12,1,1,1,226,105},{9,0,1,1,226,111},{10,0,1,1,226,111},{11,0,1,1,226,111},{12,1,1,1,226,111},{9,0,1,1,226,115},{10,0,1,1,226,115},{11,0,1,1,226,115},{12,1,1,1,226,115},{9,0,1,1,226,116},{10,0,1,1,226,116},{11,0,1,1,226,116},{12,1,1,1,226,116},{13,0,1,1,226,32},{14,1,1,1,226,32},{13,0,1,1,226,37},{14,1,1,1,226,37},{13,0,1,1,226,45},{14,1,1,1,226,45},{13,0,1,1,226,46},{14,1,1,1,226,46},{13,0,1,1,226,47},{14,1,1,1,226,47},{13,0,1,1,226,51},{14,1,1,1,226,51},{13,0,1,1,226,52},{14,1,1,1,226,52},{13,0,1,1,226,53},{14,1,1,1,226,53},{13,0,1,1,226,54},{14,1,1,1,226,54},{13,0,1,1,226,55},{14,1,1,1,226,55},{13,0,1,1,226,56},{14,1,1,1,226,56},{13,0,1,1,226,57},{14,1,1,1,226,57},{13,0,1,1,226,61},{14,1,1,1,226,61},{13,0,1,1,226,65},{14,1,1,1,226,65},{13,0,1,1,226,95},{14,1,1,1,226,95},{13,0,1,1,226,98},{14,1,1,1,226,98},{13,0,1,1,226,100},{14,1,1,1,226,100},{13,0,1,1,226,102},{14,1,1,1,226,102},{13,0,1,1,226,103},{14,1,1,1,226,103},{13,0,1,1,226,104},{14,1,1,1,226,104},{13,0,1,1,226,108},{14,1,1,1,226,108},{13,0,1,1,226,109},{14,1,1,1,226,109},{13,0,1,1,226,110},{14,1,1,1,226,110},{13,0,1,1,226,112},{14,1,1,1,226,112},{13,0,1,1,226,114},{14,1,1,1,226,114},{13,0,1,1,226,117},{14,1,1,1,226,117},{0,1,1,1,226,58},{0,1,1,1,226,66},{0,1,1,1,226,67},{0,1,1,1,226,68},{0,1,1,1,226,69},{0,1,1,1,226,70},{0,1,1,1,226,71},{0,1,1,1,226,72},{0,1,1,1,226,73},{0,1,1,1,226,74},{0,1,1,1,226,75},{0,1,1,1,226,76},{0,1,1,1,226,77},{0,1,1,1,226,78},{0,1,1,1,226,79},{0,1,1,1,226,80},{0,1,1,1,226,81},{0,1,1,1,226,82},{0,1,1,1,226,83},{0,1,1,1,226,84},{0,1,1,1,226,85},{0,1,1,1,226,86},{0,1,1,1,226,87},{0,1,1,1,226,89},{0,1,1,1,226,106},{0,1,1,1,226,107},{0,1,1,1,226,113},{0,1,1,1,226,118},{0,1,1,1,226,119},{0,1,1,1,226,120},{0,1,1,1,226,121},{0,1,1,1,226,122},{85,0,0,1,0,226},{86,0,0,1,0,226},{87,0,0,1,0,226},{88,1,0,1,0,226},{13,0,1,1,153,48},{14,1,1,1,153,48},{13,0,1,1,153,49},{14,1,1,1,153,49},{13,0,1,1,153,50},{14,1,1,1,153,50},{13,0,1,1,153,97},{14,1,1,1,153,97},{13,0,1,1,153,99},{14,1,1,1,153,99},{13,0,1,1,153,101},{14,1,1,1,153,101},{13,0,1,1,153,105},{14,1,1,1,153,105},{13,0,1,1,153,111},{14,1,1,1,153,111},{13,0,1,1,153,115},{14,1,1,1,153,115},{13,0,1,1,153,116},{14,1,1,1,153,116},{0,1,1,1,153,32},{0,1,1,1,153,37},{0,1,1,1,153,45},{0,1,1,1,153,46},{0,1,1,1,153,47},{0,1,1,1,153,51},{0,1,1,1,153,52},{0,1,1,1,153,53},{0,1,1,1,153,54},{0,1,1,1,153,55},{0,1,1,1,153,56},{0,1,1,1,153,57},{0,1,1,1,153,61},{0,1,1,1,153,65},{0,1,1,1,153,95},{0,1,1,1,153,98},{0,1,1,1,153,100},{0,1,1,1,153,102},{0,1,1,1,153,103},{0,1,1,1,153,104},{0,1,1,1,153,108},{0,1,1,1,153,109},{0,1,1,1,153,110},{0,1,1,1,153,112},{0,1,1,1,153,114},{0,1,1,1,153,117},{17,0,0,1,0,153},{18,0,0,1,0,153},{19,0,0,1,0,153},{20,0,0,1,0,153},{21,0,0,1,0,153},{22,0,0,1,0,153},{23,0,0,1,0,153},{24,0,0,1,0,153},{25,0,0,1,0,153},{26,0,0,1,0,153},{27,0,0,1,0,153},{28,0,0,1,0,153},{29,0,0,1,0,153},{30,0,0,1,0,153},{31,0,0,1,0,153},{32,0,0,1,0,153},{33,0,0,1,0,153},{34,1,0,1,0,153},{13,0,1,1,161,48},{14,1,1,1,161,48},{13,0,1,1,161,49},{14,1,1,1,161,49},{13,0,1,1,161,50},{14,1,1,1,161,50},{13,0,1,1,161,97},{14,1,1,1,161,97},{13,0,1,1,161,99},{14,1,1,1,161,99},{13,0,1,1,161,101},{14,1,1,1,161,101},{13,0,1,1,161,105},{14,1,1,1,161,105},{13,0,1,1,161,111},{14,1,1,1,161,111},{13,0,1,1,161,115},{14,1,1,1,161,115},{13,0,1,1,161,116},{14,1,1,1,161,116},{0,1,1,1,161,32},{0,1,1,1,161,37},{0,1,1,1,161,45},{0,1,1,1,161,46},{0,1,1,1,161,47},{0,1,1,1,161,51},{0,1,1,1,161,52},{0,1,1,1,161,53},{0,1,1,1,161,54},{0,1,1,1,161,55},{0,1,1,1,161,56},{0,1,1,1,161,57},{0,1,1,1,161,61},{0,1,1,1,161,65},{0,1,1,1,161,95},{0,1,1,1,161,98},{0,1,1,1,161,100},{0,1,1,1,161,102},{0,1,1,1,161,103},{0,1,1,1,161,104},{0,1,1,1,161,108},{0,1,1,1,161,109},{0,1,1,1,161,110},{0,1,1,1,161,112},{0,1,1,1,161,114},{0,1,1,1,161,117},{17,0,0,1,0,161},{18,0,0,1,0,161},{19,0,0,1,0,161},{20,0,0,1,0,161},{21,0,0,1,0,161},{22,0,0,1,0,161},{23,0,0,1,0,161},{24,0,0,1,0,161},{25,0,0,1,0,161},{26,0,0,1,0,161},{27,0,0,1,0,161},{28,0,0,1,0,161},{29,0,0,1,0,161},{30,0,0,1,0,161},{31,0,0,1,0,161},{32,0,0,1,0,161},{33,0,0,1,0,161},{34,1,0,1,0,161},{13,0,1,1,167,48},{14,1,1,1,167,48},{13,0,1,1,167,49},{14,1,1,1,167,49},{13,0,1,1,167,50},{14,1,1,1,167,50},{13,0,1,1,167,97},{14,1,1,1,167,97},{13,0,1,1,167,99},{14,1,1,1,167,99},{13,0,1,1,167,101},{14,1,1,1,167,101},{13,0,1,1,167,105},{14,1,1,1,167,105},{13,0,1,1,167,111},{14,1,1,1,167,111},{13,0,1,1,167,115},{14,1,1,1,167,115},{13,0,1,1,167,116},{14,1,1,1,167,116},{0,1,1,1,167,32},{0,1,1,1,167,37},{0,1,1,1,167,45},{0,1,1,1,167,46},{0,1,1,1,167,47},{0,1,1,1,167,51},{0,1,1,1,167,52},{0,1,1,1,167,53},{0,1,1,1,167,54},{0,1,1,1,167,55},{0,1,1,1,167,56},{0,1,1,1,167,57},{0,1,1,1,167,61},{0,1,1,1,167,65},{0,1,1,1,167,95},{0,1,1,1,167,98},{0,1,1,1,167,100},{0,1,1,1,167,102},{0,1,1,1,167,103},{0,1,1,1,167,104},{0,1,1,1,167,108},{0,1,1,1,167,109},{0,1,1,1,167,110},{0,1,1,1,167,112},{0,1,1,1,167,114},{0,1,1,1,167,117},{17,0,0,1,0,167},{18,0,0,1,0,167},{19,0,0,1,0,167},{20,0,0,1,0,167},{21,0,0,1,0,167},{22,0,0,1,0,167},{23,0,0,1,0,167},{24,0,0,1,0,167},{25,0,0,1,0,167},{26,0,0,1,0,167},{27,0,0,1,0,167},{28,0,0,1,0,167},{29,0,0,1,0,167},{30,0,0,1,0,167},{31,0,0,1,0,167},{32,0,0,1,0,167},{33,0,0,1,0,167},{34,1,0,1,0,167},{13,0,1,1,172,48},{14,1,1,1,172,48},{13,0,1,1,172,49},{14,1,1,1,172,49},{13,0,1,1,172,50},{14,1,1,1,172,50},{13,0,1,1,172,97},{14,1,1,1,172,97},{13,0,1,1,172,99},{14,1,1,1,172,99},{13,0,1,1,172,101},{14,1,1,1,172,101},{13,0,1,1,172,105},{14,1,1,1,172,105},{13,0,1,1,172,111},{14,1,1,1,172,111},{13,0,1,1,172,115},{14,1,1,1,172,115},{13,0,1,1,172,116},{14,1,1,1,172,116},{0,1,1,1,172,32},{0,1,1,1,172,37},{0,1,1,1,172,45},{0,1,1,1,172,46},{0,1,1,1,172,47},{0,1,1,1,172,51},{0,1,1,1,172,52},{0,1,1,1,172,53},{0,1,1,1,172,54},{0,1,1,1,172,55},{0,1,1,1,172,56},{0,1,1,1,172,57},{0,1,1,1,172,61},{0,1,1,1,172,65},{0,1,1,1,172,95},{0,1,1,1,172,98},{0,1,1,1,172,100},{0,1,1,1,172,102},{0,1,1,1,172,103},{0,1,1,1,172,104},{0,1,1,1,172,108},{0,1,1,1,172,109},{0,1,1,1,172,110},{0,1,1,1,172,112},{0,1,1,1,172,114},{0,1,1,1,172,117},{17,0,0,1,0,172},{18,0,0,1,0,172},{19,0,0,1,0,172},{20,0,0,1,0,172},{21,0,0,1,0,172},{22,0,0,1,0,172},{23,0,0,1,0,172},{24,0,0,1,0,172},{25,0,0,1,0,172},{26,0,0,1,0,172},{27,0,0,1,0,172},{28,0,0,1,0,172},{29,0,0,1,0,172},{30,0,0,1,0,172},{31,0,0,1,0,172},{32,0,0,1,0,172},{33,0,0,1,0,172},{34,1,0,1,0,172},{13,0,1,1,176,48},{14,1,1,1,176,48},{13,0,1,1,176,49},{14,1,1,1,176,49},{13,0,1,1,176,50},{14,1,1,1,176,50},{13,0,1,1,176,97},{14,1,1,1,176,97},{13,0,1,1,176,99},{14,1,1,1,176,99},{13,0,1,1,176,101},{14,1,1,1,176,101},{13,0,1,1,176,105},{14,1,1,1,176,105},{13,0,1,1,176,111},{14,1,1,1,176,111},{13,0,1,1,176,115},{14,1,1,1,176,115},{13,0,1,1,176,116},{14,1,1,1,176,116},{0,1,1,1,176,32},{0,1,1,1,176,37},{0,1,1,1,176,45},{0,1,1,1,176,46},{0,1,1,1,176,47},{0,1,1,1,176,51},{0,1,1,1,176,52},{0,1,1,1,176,53},{0,1,1,1,176,54},{0,1,1,1,176,55},{0,1,1,1,176,56},{0,1,1,1,176,57},{0,1,1,1,176,61},{0,1,1,1,176,65},{0,1,1,1,176,95},{0,1,1,1,176,98},{0,1,1,1,176,100},{0,1,1,1,176,102},{0,1,1,1,176,103},{0,1,1,1,176,104},{0,1,1,1,176,108},{0,1,1,1,176,109},{0,1,1,1,176,110},{0,1,1,1,176,112},{0,1,1,1,176,114},{0,1,1,1,176,117},{17,0,0,1,0,176},{18,0,0,1,0,176},{19,0,0,1,0,176},{20,0,0,1,0,176},{21,0,0,1,0,176},{22,0,0,1,0,176},{23,0,0,1,0,176},{24,0,0,1,0,176},{25,0,0,1,0,176},{26,0,0,1,0,176},{27,0,0,1,0,176},{28,0,0,1,0,176},{29,0,0,1,0,176},{30,0,0,1,0,176},{31,0,0,1,0,176},{32,0,0,1,0,176},{33,0,0,1,0,176},{34,1,0,1,0,176},{13,0,1,1,177,48},{14,1,1,1,177,48},{13,0,1,1,177,49},{14,1,1,1,177,49},{13,0,1,1,177,50},{14,1,1,1,177,50},{13,0,1,1,177,97},{14,1,1,1,177,97},{13,0,1,1,177,99},{14,1,1,1,177,99},{13,0,1,1,177,101},{14,1,1,1,177,101},{13,0,1,1,177,105},{14,1,1,1,177,105},{13,0,1,1,177,111},{14,1,1,1,177,111},{13,0,1,1,177,115},{14,1,1,1,177,115},{13,0,1,1,177,116},{14,1,1,1,177,116},{0,1,1,1,177,32},{0,1,1,1,177,37},{0,1,1,1,177,45},{0,1,1,1,177,46},{0,1,1,1,177,47},{0,1,1,1,177,51},{0,1,1,1,177,52},{0,1,1,1,177,53},{0,1,1,1,177,54},{0,1,1,1,177,55},{0,1,1,1,177,56},{0,1,1,1,177,57},{0,1,1,1,177,61},{0,1,1,1,177,65},{0,1,1,1,177,95},{0,1,1,1,177,98},{0,1,1,1,177,100},{0,1,1,1,177,102},{0,1,1,1,177,103},{0,1,1,1,177,104},{0,1,1,1,177,108},{0,1,1,1,177,109},{0,1,1,1,177,110},{0,1,1,1,177,112},{0,1,1,1,177,114},{0,1,1,1,177,117},{17,0,0,1,0,177},{18,0,0,1,0,177},{19,0,0,1,0,177},{20,0,0,1,0,177},{21,0,0,1,0,177},{22,0,0,1,0,177},{23,0,0,1,0,177},{24,0,0,1,0,177},{25,0,0,1,0,177},{26,0,0,1,0,177},{27,0,0,1,0,177},{28,0,0,1,0,177},{29,0,0,1,0,177},{30,0,0,1,0,177},{31,0,0,1,0,177},{32,0,0,1,0,177},{33,0,0,1,0,177},{34,1,0,1,0,177},{13,0,1,1,179,48},{14,1,1,1,179,48},{13,0,1,1,179,49},{14,1,1,1,179,49},{13,0,1,1,179,50},{14,1,1,1,179,50},{13,0,1,1,179,97},{14,1,1,1,179,97},{13,0,1,1,179,99},{14,1,1,1,179,99},{13,0,1,1,179,101},{14,1,1,1,179,101},{13,0,1,1,179,105},{14,1,1,1,179,105},{13,0,1,1,179,111},{14,1,1,1,179,111},{13,0,1,1,179,115},{14,1,1,1,179,115},{13,0,1,1,179,116},{14,1,1,1,179,116},{0,1,1,1,179,32},{0,1,1,1,179,37},{0,1,1,1,179,45},{0,1,1,1,179,46},{0,1,1,1,179,47},{0,1,1,1,179,51},{0,1,1,1,179,52},{0,1,1,1,179,53},{0,1,1,1,179,54},{0,1,1,1,179,55},{0,1,1,1,179,56},{0,1,1,1,179,57},{0,1,1,1,179,61},{0,1,1,1,179,65},{0,1,1,1,179,95},{0,1,1,1,179,98},{0,1,1,1,179,100},{0,1,1,1,179,102},{0,1,1,1,179,103},{0,1,1,1,179,104},{0,1,1,1,179,108},{0,1,1,1,179,109},{0,1,1,1,179,110},{0,1,1,1,179,112},{0,1,1,1,179,114},{0,1,1,1,179,117},{17,0,0,1,0,179},{18,0,0,1,0,179},{19,0,0,1,0,179},{20,0,0,1,0,179},{21,0,0,1,0,179},{22,0,0,1,0,179},{23,0,0,1,0,179},{24,0,0,1,0,179},{25,0,0,1,0,179},{26,0,0,1,0,179},{27,0,0,1,0,179},{28,0,0,1,0,179},{29,0,0,1,0,179},{30,0,0,1,0,179},{31,0,0,1,0,179},{32,0,0,1,0,179},{33,0,0,1,0,179},{34,1,0,1,0,179},{13,0,1,1,209,48},{14,1,1,1,209,48},{13,0,1,1,209,49},{14,1,1,1,209,49},{13,0,1,1,209,50},{14,1,1,1,209,50},{13,0,1,1,209,97},{14,1,1,1,209,97},{13,0,1,1,209,99},{14,1,1,1,209,99},{13,0,1,1,209,101},{14,1,1,1,209,101},{13,0,1,1,209,105},{14,1,1,1,209,105},{13,0,1,1,209,111},{14,1,1,1,209,111},{13,0,1,1,209,115},{14,1,1,1,209,115},{13,0,1,1,209,116},{14,1,1,1,209,116},{0,1,1,1,209,32},{0,1,1,1,209,37},{0,1,1,1,209,45},{0,1,1,1,209,46},{0,1,1,1,209,47},{0,1,1,1,209,51},{0,1,1,1,209,52},{0,1,1,1,209,53},{0,1,1,1,209,54},{0,1,1,1,209,55},{0,1,1,1,209,56},{0,1,1,1,209,57},{0,1,1,1,209,61},{0,1,1,1,209,65},{0,1,1,1,209,95},{0,1,1,1,209,98},{0,1,1,1,209,100},{0,1,1,1,209,102},{0,1,1,1,209,103},{0,1,1,1,209,104},{0,1,1,1,209,108},{0,1,1,1,209,109},{0,1,1,1,209,110},{0,1,1,1,209,112},{0,1,1,1,209,114},{0,1,1,1,209,117},{17,0,0,1,0,209},{18,0,0,1,0,209},{19,0,0,1,0,209},{20,0,0,1,0,209},{21,0,0,1,0,209},{22,0,0,1,0,209},{23,0,0,1,0,209},{24,0,0,1,0,209},{25,0,0,1,0,209},{26,0,0,1,0,209},{27,0,0,1,0,209},{28,0,0,1,0,209},{29,0,0,1,0,209},{30,0,0,1,0,209},{31,0,0,1,0,209},{32,0,0,1,0,209},{33,0,0,1,0,209},{34,1,0,1,0,209},{13,0,1,1,216,48},{14,1,1,1,216,48},{13,0,1,1,216,49},{14,1,1,1,216,49},{13,0,1,1,216,50},{14,1,1,1,216,50},{13,0,1,1,216,97},{14,1,1,1,216,97},{13,0,1,1,216,99},{14,1,1,1,216,99},{13,0,1,1,216,101},{14,1,1,1,216,101},{13,0,1,1,216,105},{14,1,1,1,216,105},{13,0,1,1,216,111},{14,1,1,1,216,111},{13,0,1,1,216,115},{14,1,1,1,216,115},{13,0,1,1,216,116},{14,1,1,1,216,116},{0,1,1,1,216,32},{0,1,1,1,216,37},{0,1,1,1,216,45},{0,1,1,1,216,46},{0,1,1,1,216,47},{0,1,1,1,216,51},{0,1,1,1,216,52},{0,1,1,1,216,53},{0,1,1,1,216,54},{0,1,1,1,216,55},{0,1,1,1,216,56},{0,1,1,1,216,57},{0,1,1,1,216,61},{0,1,1,1,216,65},{0,1,1,1,216,95},{0,1,1,1,216,98},{0,1,1,1,216,100},{0,1,1,1,216,102},{0,1,1,1,216,103},{0,1,1,1,216,104},{0,1,1,1,216,108},{0,1,1,1,216,109},{0,1,1,1,216,110},{0,1,1,1,216,112},{0,1,1,1,216,114},{0,1,1,1,216,117},{17,0,0,1,0,216},{18,0,0,1,0,216},{19,0,0,1,0,216},{20,0,0,1,0,216},{21,0,0,1,0,216},{22,0,0,1,0,216},{23,0,0,1,0,216},{24,0,0,1,0,216},{25,0,0,1,0,216},{26,0,0,1,0,216},{27,0,0,1,0,216},{28,0,0,1,0,216},{29,0,0,1,0,216},{30,0,0,1,0,216},{31,0,0,1,0,216},{32,0,0,1,0,216},{33,0,0,1,0,216},{34,1,0,1,0,216},{13,0,1,1,217,48},{14,1,1,1,217,48},{13,0,1,1,217,49},{14,1,1,1,217,49},{13,0,1,1,217,50},{14,1,1,1,217,50},{13,0,1,1,217,97},{14,1,1,1,217,97},{13,0,1,1,217,99},{14,1,1,1,217,99},{13,0,1,1,217,101},{14,1,1,1,217,101},{13,0,1,1,217,105},{14,1,1,1,217,105},{13,0,1,1,217,111},{14,1,1,1,217,111},{13,0,1,1,217,115},{14,1,1,1,217,115},{13,0,1,1,217,116},{14,1,1,1,217,116},{0,1,1,1,217,32},{0,1,1,1,217,37},{0,1,1,1,217,45},{0,1,1,1,217,46},{0,1,1,1,217,47},{0,1,1,1,217,51},{0,1,1,1,217,52},{0,1,1,1,217,53},{0,1,1,1,217,54},{0,1,1,1,217,55},{0,1,1,1,217,56},{0,1,1,1,217,57},{0,1,1,1,217,61},{0,1,1,1,217,65},{0,1,1,1,217,95},{0,1,1,1,217,98},{0,1,1,1,217,100},{0,1,1,1,217,102},{0,1,1,1,217,103},{0,1,1,1,217,104},{0,1,1,1,217,108},{0,1,1,1,217,109},{0,1,1,1,217,110},{0,1,1,1,217,112},{0,1,1,1,217,114},{0,1,1,1,217,117},{17,0,0,1,0,217},{18,0,0,1,0,217},{19,0,0,1,0,217},{20,0,0,1,0,217},{21,0,0,1,0,217},{22,0,0,1,0,217},{23,0,0,1,0,217},{24,0,0,1,0,217},{25,0,0,1,0,217},{26,0,0,1,0,217},{27,0,0,1,0,217},{28,0,0,1,0,217},{29,0,0,1,0,217},{30,0,0,1,0,217},{31,0,0,1,0,217},{32,0,0,1,0,217},{33,0,0,1,0,217},{34,1,0,1,0,217},{13,0,1,1,227,48},{14,1,1,1,227,48},{13,0,1,1,227,49},{14,1,1,1,227,49},{13,0,1,1,227,50},{14,1,1,1,227,50},{13,0,1,1,227,97},{14,1,1,1,227,97},{13,0,1,1,227,99},{14,1,1,1,227,99},{13,0,1,1,227,101},{14,1,1,1,227,101},{13,0,1,1,227,105},{14,1,1,1,227,105},{13,0,1,1,227,111},{14,1,1,1,227,111},{13,0,1,1,227,115},{14,1,1,1,227,115},{13,0,1,1,227,116},{14,1,1,1,227,116},{0,1,1,1,227,32},{0,1,1,1,227,37},{0,1,1,1,227,45},{0,1,1,1,227,46},{0,1,1,1,227,47},{0,1,1,1,227,51},{0,1,1,1,227,52},{0,1,1,1,227,53},{0,1,1,1,227,54},{0,1,1,1,227,55},{0,1,1,1,227,56},{0,1,1,1,227,57},{0,1,1,1,227,61},{0,1,1,1,227,65},{0,1,1,1,227,95},{0,1,1,1,227,98},{0,1,1,1,227,100},{0,1,1,1,227,102},{0,1,1,1,227,103},{0,1,1,1,227,104},{0,1,1,1,227,108},{0,1,1,1,227,109},{0,1,1,1,227,110},{0,1,1,1,227,112},{0,1,1,1,227,114},{0,1,1,1,227,117},{17,0,0,1,0,227},{18,0,0,1,0,227},{19,0,0,1,0,227},{20,0,0,1,0,227},{21,0,0,1,0,227},{22,0,0,1,0,227},{23,0,0,1,0,227},{24,0,0,1,0,227},{25,0,0,1,0,227},{26,0,0,1,0,227},{27,0,0,1,0,227},{28,0,0,1,0,227},{29,0,0,1,0,227},{30,0,0,1,0,227},{31,0,0,1,0,227},{32,0,0,1,0,227},{33,0,0,1,0,227},{34,1,0,1,0,227},{13,0,1,1,229,48},{14,1,1,1,229,48},{13,0,1,1,229,49},{14,1,1,1,229,49},{13,0,1,1,229,50},{14,1,1,1,229,50},{13,0,1,1,229,97},{14,1,1,1,229,97},{13,0,1,1,229,99},{14,1,1,1,229,99},{13,0,1,1,229,101},{14,1,1,1,229,101},{13,0,1,1,229,105},{14,1,1,1,229,105},{13,0,1,1,229,111},{14,1,1,1,229,111},{13,0,1,1,229,115},{14,1,1,1,229,115},{13,0,1,1,229,116},{14,1,1,1,229,116},{0,1,1,1,229,32},{0,1,1,1,229,37},{0,1,1,1,229,45},{0,1,1,1,229,46},{0,1,1,1,229,47},{0,1,1,1,229,51},{0,1,1,1,229,52},{0,1,1,1,229,53},{0,1,1,1,229,54},{0,1,1,1,229,55},{0,1,1,1,229,56},{0,1,1,1,229,57},{0,1,1,1,229,61},{0,1,1,1,229,65},{0,1,1,1,229,95},{0,1,1,1,229,98},{0,1,1,1,229,100},{0,1,1,1,229,102},{0,1,1,1,229,103},{0,1,1,1,229,104},{0,1,1,1,229,108},{0,1,1,1,229,109},{0,1,1,1,229,110},{0,1,1,1,229,112},{0,1,1,1,229,114},{0,1,1,1,229,117},{17,0,0,1,0,229},{18,0,0,1,0,229},{19,0,0,1,0,229},{20,0,0,1,0,229},{21,0,0,1,0,229},{22,0,0,1,0,229},{23,0,0,1,0,229},{24,0,0,1,0,229},{25,0,0,1,0,229},{26,0,0,1,0,229},{27,0,0,1,0,229},{28,0,0,1,0,229},{29,0,0,1,0,229},{30,0,0,1,0,229},{31,0,0,1,0,229},{32,0,0,1,0,229},{33,0,0,1,0,229},{34,1,0,1,0,229},{13,0,1,1,230,48},{14,1,1,1,230,48},{13,0,1,1,230,49},{14,1,1,1,230,49},{13,0,1,1,230,50},{14,1,1,1,230,50},{13,0,1,1,230,97},{14,1,1,1,230,97},{13,0,1,1,230,99},{14,1,1,1,230,99},{13,0,1,1,230,101},{14,1,1,1,230,101},{13,0,1,1,230,105},{14,1,1,1,230,105},{13,0,1,1,230,111},{14,1,1,1,230,111},{13,0,1,1,230,115},{14,1,1,1,230,115},{13,0,1,1,230,116},{14,1,1,1,230,116},{0,1,1,1,230,32},{0,1,1,1,230,37},{0,1,1,1,230,45},{0,1,1,1,230,46},{0,1,1,1,230,47},{0,1,1,1,230,51},{0,1,1,1,230,52},{0,1,1,1,230,53},{0,1,1,1,230,54},{0,1,1,1,230,55},{0,1,1,1,230,56},{0,1,1,1,230,57},{0,1,1,1,230,61},{0,1,1,1,230,65},{0,1,1,1,230,95},{0,1,1,1,230,98},{0,1,1,1,230,100},{0,1,1,1,230,102},{0,1,1,1,230,103},{0,1,1,1,230,104},{0,1,1,1,230,108},{0,1,1,1,230,109},{0,1,1,1,230,110},{0,1,1,1,230,112},{0,1,1,1,230,114},{0,1,1,1,230,117},{17,0,0,1,0,230},{18,0,0,1,0,230},{19,0,0,1,0,230},{20,0,0,1,0,230},{21,0,0,1,0,230},{22,0,0,1,0,230},{23,0,0,1,0,230},{24,0,0,1,0,230},{25,0,0,1,0,230},{26,0,0,1,0,230},{27,0,0,1,0,230},{28,0,0,1,0,230},{29,0,0,1,0,230},{30,0,0,1,0,230},{31,0,0,1,0,230},{32,0,0,1,0,230},{33,0,0,1,0,230},{34,1,0,1,0,230},{0,1,1,1,129,48},{0,1,1,1,129,49},{0,1,1,1,129,50},{0,1,1,1,129,97},{0,1,1,1,129,99},{0,1,1,1,129,101},{0,1,1,1,129,105},{0,1,1,1,129,111},{0,1,1,1,129,115},{0,1,1,1,129,116},{35,0,0,1,0,129},{36,0,0,1,0,129},{37,0,0,1,0,129},{38,0,0,1,0,129},{39,0,0,1,0,129},{40,0,0,1,0,129},{41,0,0,1,0,129},{42,0,0,1,0,129},{43,0,0,1,0,129},{44,0,0,1,0,129},{45,0,0,1,0,129},{46,0,0,1,0,129},{47,0,0,1,0,129},{48,0,0,1,0,129},{49,0,0,1,0,129},{50,0,0,1,0,129},{51,0,0,1,0,129},{52,0,0,1,0,129},{53,0,0,1,0,129},{54,0,0,1,0,129},{55,0,0,1,0,129},{56,1,0,1,0,129},{0,1,1,1,132,48},{0,1,1,1,132,49},{0,1,1,1,132,50},{0,1,1,1,132,97},{0,1,1,1,132,99},{0,1,1,1,132,101},{0,1,1,1,132,105},{0,1,1,1,132,111},{0,1,1,1,132,115},{0,1,1,1,132,116},{35,0,0,1,0,132},{36,0,0,1,0,132},{37,0,0,1,0,132},{38,0,0,1,0,132},{39,0,0,1,0,132},{40,0,0,1,0,132},{41,0,0,1,0,132},{42,0,0,1,0,132},{43,0,0,1,0,132},{44,0,0,1,0,132},{45,0,0,1,0,132},{46,0,0,1,0,132},{47,0,0,1,0,132},{48,0,0,1,0,132},{49,0,0,1,0,132},{50,0,0,1,0,132},{51,0,0,1,0,132},{52,0,0,1,0,132},{53,0,0,1,0,132},{54,0,0,1,0,132},{55,0,0,1,0,132},{56,1,0,1,0,132},{0,1,1,1,133,48},{0,1,1,1,133,49},{0,1,1,1,133,50},{0,1,1,1,133,97},{0,1,1,1,133,99},{0,1,1,1,133,101},{0,1,1,1,133,105},{0,1,1,1,133,111},{0,1,1,1,133,115},{0,1,1,1,133,116},{35,0,0,1,0,133},{36,0,0,1,0,133},{37,0,0,1,0,133},{38,0,0,1,0,133},{39,0,0,1,0,133},{40,0,0,1,0,133},{41,0,0,1,0,133},{42,0,0,1,0,133},{43,0,0,1,0,133},{44,0,0,1,0,133},{45,0,0,1,0,133},{46,0,0,1,0,133},{47,0,0,1,0,133},{48,0,0,1,0,133},{49,0,0,1,0,133},{50,0,0,1,0,133},{51,0,0,1,0,133},{52,0,0,1,0,133},{53,0,0,1,0,133},{54,0,0,1,0,133},{55,0,0,1,0,133},{56,1,0,1,0,133},{0,1,1,1,134,48},{0,1,1,1,134,49},{0,1,1,1,134,50},{0,1,1,1,134,97},{0,1,1,1,134,99},{0,1,1,1,134,101},{0,1,1,1,134,105},{0,1,1,1,134,111},{0,1,1,1,134,115},{0,1,1,1,134,116},{35,0,0,1,0,134},{36,0,0,1,0,134},{37,0,0,1,0,134},{38,0,0,1,0,134},{39,0,0,1,0,134},{40,0,0,1,0,134},{41,0,0,1,0,134},{42,0,0,1,0,134},{43,0,0,1,0,134},{44,0,0,1,0,134},{45,0,0,1,0,134},{46,0,0,1,0,134},{47,0,0,1,0,134},{48,0,0,1,0,134},{49,0,0,1,0,134},{50,0,0,1,0,134},{51,0,0,1,0,134},{52,0,0,1,0,134},{53,0,0,1,0,134},{54,0,0,1,0,134},{55,0,0,1,0,134},{56,1,0,1,0,134},{0,1,1,1,136,48},{0,1,1,1,136,49},{0,1,1,1,136,50},{0,1,1,1,136,97},{0,1,1,1,136,99},{0,1,1,1,136,101},{0,1,1,1,136,105},{0,1,1,1,136,111},{0,1,1,1,136,115},{0,1,1,1,136,116},{35,0,0,1,0,136},{36,0,0,1,0,136},{37,0,0,1,0,136},{38,0,0,1,0,136},{39,0,0,1,0,136},{40,0,0,1,0,136},{41,0,0,1,0,136},{42,0,0,1,0,136},{43,0,0,1,0,136},{44,0,0,1,0,136},{45,0,0,1,0,136},{46,0,0,1,0,136},{47,0,0,1,0,136},{48,0,0,1,0,136},{49,0,0,1,0,136},{50,0,0,1,0,136},{51,0,0,1,0,136},{52,0,0,1,0,136},{53,0,0,1,0,136},{54,0,0,1,0,136},{55,0,0,1,0,136},{56,1,0,1,0,136},{0,1,1,1,146,48},{0,1,1,1,146,49},{0,1,1,1,146,50},{0,1,1,1,146,97},{0,1,1,1,146,99},{0,1,1,1,146,101},{0,1,1,1,146,105},{0,1,1,1,146,111},{0,1,1,1,146,115},{0,1,1,1,146,116},{35,0,0,1,0,146},{36,0,0,1,0,146},{37,0,0,1,0,146},{38,0,0,1,0,146},{39,0,0,1,0,146},{40,0,0,1,0,146},{41,0,0,1,0,146},{42,0,0,1,0,146},{43,0,0,1,0,146},{44,0,0,1,0,146},{45,0,0,1,0,146},{46,0,0,1,0,146},{47,0,0,1,0,146},{48,0,0,1,0,146},{49,0,0,1,0,146},{50,0,0,1,0,146},{51,0,0,1,0,146},{52,0,0,1,0,146},{53,0,0,1,0,146},{54,0,0,1,0,146},{55,0,0,1,0,146},{56,1,0,1,0,146},{0,1,1,1,154,48},{0,1,1,1,154,49},{0,1,1,1,154,50},{0,1,1,1,154,97},{0,1,1,1,154,99},{0,1,1,1,154,101},{0,1,1,1,154,105},{0,1,1,1,154,111},{0,1,1,1,154,115},{0,1,1,1,154,116},{35,0,0,1,0,154},{36,0,0,1,0,154},{37,0,0,1,0,154},{38,0,0,1,0,154},{39,0,0,1,0,154},{40,0,0,1,0,154},{41,0,0,1,0,154},{42,0,0,1,0,154},{43,0,0,1,0,154},{44,0,0,1,0,154},{45,0,0,1,0,154},{46,0,0,1,0,154},{47,0,0,1,0,154},{48,0,0,1,0,154},{49,0,0,1,0,154},{50,0,0,1,0,154},{51,0,0,1,0,154},{52,0,0,1,0,154},{53,0,0,1,0,154},{54,0,0,1,0,154},{55,0,0,1,0,154},{56,1,0,1,0,154},{0,1,1,1,156,48},{0,1,1,1,156,49},{0,1,1,1,156,50},{0,1,1,1,156,97},{0,1,1,1,156,99},{0,1,1,1,156,101},{0,1,1,1,156,105},{0,1,1,1,156,111},{0,1,1,1,156,115},{0,1,1,1,156,116},{35,0,0,1,0,156},{36,0,0,1,0,156},{37,0,0,1,0,156},{38,0,0,1,0,156},{39,0,0,1,0,156},{40,0,0,1,0,156},{41,0,0,1,0,156},{42,0,0,1,0,156},{43,0,0,1,0,156},{44,0,0,1,0,156},{45,0,0,1,0,156},{46,0,0,1,0,156},{47,0,0,1,0,156},{48,0,0,1,0,156},{49,0,0,1,0,156},{50,0,0,1,0,156},{51,0,0,1,0,156},{52,0,0,1,0,156},{53,0,0,1,0,156},{54,0,0,1,0,156},{55,0,0,1,0,156},{56,1,0,1,0,156},{0,1,1,1,160,48},{0,1,1,1,160,49},{0,1,1,1,160,50},{0,1,1,1,160,97},{0,1,1,1,160,99},{0,1,1,1,160,101},{0,1,1,1,160,105},{0,1,1,1,160,111},{0,1,1,1,160,115},{0,1,1,1,160,116},{35,0,0,1,0,160},{36,0,0,1,0,160},{37,0,0,1,0,160},{38,0,0,1,0,160},{39,0,0,1,0,160},{40,0,0,1,0,160},{41,0,0,1,0,160},{42,0,0,1,0,160},{43,0,0,1,0,160},{44,0,0,1,0,160},{45,0,0,1,0,160},{46,0,0,1,0,160},{47,0,0,1,0,160},{48,0,0,1,0,160},{49,0,0,1,0,160},{50,0,0,1,0,160},{51,0,0,1,0,160},{52,0,0,1,0,160},{53,0,0,1,0,160},{54,0,0,1,0,160},{55,0,0,1,0,160},{56,1,0,1,0,160},{0,1,1,1,163,48},{0,1,1,1,163,49},{0,1,1,1,163,50},{0,1,1,1,163,97},{0,1,1,1,163,99},{0,1,1,1,163,101},{0,1,1,1,163,105},{0,1,1,1,163,111},{0,1,1,1,163,115},{0,1,1,1,163,116},{35,0,0,1,0,163},{36,0,0,1,0,163},{37,0,0,1,0,163},{38,0,0,1,0,163},{39,0,0,1,0,163},{40,0,0,1,0,163},{41,0,0,1,0,163},{42,0,0,1,0,163},{43,0,0,1,0,163},{44,0,0,1,0,163},{45,0,0,1,0,163},{46,0,0,1,0,163},{47,0,0,1,0,163},{48,0,0,1,0,163},{49,0,0,1,0,163},{50,0,0,1,0,163},{51,0,0,1,0,163},{52,0,0,1,0,163},{53,0,0,1,0,163},{54,0,0,1,0,163},{55,0,0,1,0,163},{56,1,0,1,0,163},{0,1,1,1,164,48},{0,1,1,1,164,49},{0,1,1,1,164,50},{0,1,1,1,164,97},{0,1,1,1,164,99},{0,1,1,1,164,101},{0,1,1,1,164,105},{0,1,1,1,164,111},{0,1,1,1,164,115},{0,1,1,1,164,116},{35,0,0,1,0,164},{36,0,0,1,0,164},{37,0,0,1,0,164},{38,0,0,1,0,164},{39,0,0,1,0,164},{40,0,0,1,0,164},{41,0,0,1,0,164},{42,0,0,1,0,164},{43,0,0,1,0,164},{44,0,0,1,0,164},{45,0,0,1,0,164},{46,0,0,1,0,164},{47,0,0,1,0,164},{48,0,0,1,0,164},{49,0,0,1,0,164},{50,0,0,1,0,164},{51,0,0,1,0,164},{52,0,0,1,0,164},{53,0,0,1,0,164},{54,0,0,1,0,164},{55,0,0,1,0,164},{56,1,0,1,0,164},{0,1,1,1,169,48},{0,1,1,1,169,49},{0,1,1,1,169,50},{0,1,1,1,169,97},{0,1,1,1,169,99},{0,1,1,1,169,101},{0,1,1,1,169,105},{0,1,1,1,169,111},{0,1,1,1,169,115},{0,1,1,1,169,116},{35,0,0,1,0,169},{36,0,0,1,0,169},{37,0,0,1,0,169},{38,0,0,1,0,169},{39,0,0,1,0,169},{40,0,0,1,0,169},{41,0,0,1,0,169},{42,0,0,1,0,169},{43,0,0,1,0,169},{44,0,0,1,0,169},{45,0,0,1,0,169},{46,0,0,1,0,169},{47,0,0,1,0,169},{48,0,0,1,0,169},{49,0,0,1,0,169},{50,0,0,1,0,169},{51,0,0,1,0,169},{52,0,0,1,0,169},{53,0,0,1,0,169},{54,0,0,1,0,169},{55,0,0,1,0,169},{56,1,0,1,0,169},{0,1,1,1,170,48},{0,1,1,1,170,49},{0,1,1,1,170,50},{0,1,1,1,170,97},{0,1,1,1,170,99},{0,1,1,1,170,101},{0,1,1,1,170,105},{0,1,1,1,170,111},{0,1,1,1,170,115},{0,1,1,1,170,116},{35,0,0,1,0,170},{36,0,0,1,0,170},{37,0,0,1,0,170},{38,0,0,1,0,170},{39,0,0,1,0,170},{40,0,0,1,0,170},{41,0,0,1,0,170},{42,0,0,1,0,170},{43,0,0,1,0,170},{44,0,0,1,0,170},{45,0,0,1,0,170},{46,0,0,1,0,170},{47,0,0,1,0,170},{48,0,0,1,0,170},{49,0,0,1,0,170},{50,0,0,1,0,170},{51,0,0,1,0,170},{52,0,0,1,0,170},{53,0,0,1,0,170},{54,0,0,1,0,170},{55,0,0,1,0,170},{56,1,0,1,0,170},{0,1,1,1,173,48},{0,1,1,1,173,49},{0,1,1,1,173,50},{0,1,1,1,173,97},{0,1,1,1,173,99},{0,1,1,1,173,101},{0,1,1,1,173,105},{0,1,1,1,173,111},{0,1,1,1,173,115},{0,1,1,1,173,116},{35,0,0,1,0,173},{36,0,0,1,0,173},{37,0,0,1,0,173},{38,0,0,1,0,173},{39,0,0,1,0,173},{40,0,0,1,0,173},{41,0,0,1,0,173},{42,0,0,1,0,173},{43,0,0,1,0,173},{44,0,0,1,0,173},{45,0,0,1,0,173},{46,0,0,1,0,173},{47,0,0,1,0,173},{48,0,0,1,0,173},{49,0,0,1,0,173},{50,0,0,1,0,173},{51,0,0,1,0,173},{52,0,0,1,0,173},{53,0,0,1,0,173},{54,0,0,1,0,173},{55,0,0,1,0,173},{56,1,0,1,0,173},{0,1,1,1,178,48},{0,1,1,1,178,49},{0,1,1,1,178,50},{0,1,1,1,178,97},{0,1,1,1,178,99},{0,1,1,1,178,101},{0,1,1,1,178,105},{0,1,1,1,178,111},{0,1,1,1,178,115},{0,1,1,1,178,116},{35,0,0,1,0,178},{36,0,0,1,0,178},{37,0,0,1,0,178},{38,0,0,1,0,178},{39,0,0,1,0,178},{40,0,0,1,0,178},{41,0,0,1,0,178},{42,0,0,1,0,178},{43,0,0,1,0,178},{44,0,0,1,0,178},{45,0,0,1,0,178},{46,0,0,1,0,178},{47,0,0,1,0,178},{48,0,0,1,0,178},{49,0,0,1,0,178},{50,0,0,1,0,178},{51,0,0,1,0,178},{52,0,0,1,0,178},{53,0,0,1,0,178},{54,0,0,1,0,178},{55,0,0,1,0,178},{56,1,0,1,0,178},{0,1,1,1,181,48},{0,1,1,1,181,49},{0,1,1,1,181,50},{0,1,1,1,181,97},{0,1,1,1,181,99},{0,1,1,1,181,101},{0,1,1,1,181,105},{0,1,1,1,181,111},{0,1,1,1,181,115},{0,1,1,1,181,116},{35,0,0,1,0,181},{36,0,0,1,0,181},{37,0,0,1,0,181},{38,0,0,1,0,181},{39,0,0,1,0,181},{40,0,0,1,0,181},{41,0,0,1,0,181},{42,0,0,1,0,181},{43,0,0,1,0,181},{44,0,0,1,0,181},{45,0,0,1,0,181},{46,0,0,1,0,181},{47,0,0,1,0,181},{48,0,0,1,0,181},{49,0,0,1,0,181},{50,0,0,1,0,181},{51,0,0,1,0,181},{52,0,0,1,0,181},{53,0,0,1,0,181},{54,0,0,1,0,181},{55,0,0,1,0,181},{56,1,0,1,0,181},{0,1,1,1,185,48},{0,1,1,1,185,49},{0,1,1,1,185,50},{0,1,1,1,185,97},{0,1,1,1,185,99},{0,1,1,1,185,101},{0,1,1,1,185,105},{0,1,1,1,185,111},{0,1,1,1,185,115},{0,1,1,1,185,116},{35,0,0,1,0,185},{36,0,0,1,0,185},{37,0,0,1,0,185},{38,0,0,1,0,185},{39,0,0,1,0,185},{40,0,0,1,0,185},{41,0,0,1,0,185},{42,0,0,1,0,185},{43,0,0,1,0,185},{44,0,0,1,0,185},{45,0,0,1,0,185},{46,0,0,1,0,185},{47,0,0,1,0,185},{48,0,0,1,0,185},{49,0,0,1,0,185},{50,0,0,1,0,185},{51,0,0,1,0,185},{52,0,0,1,0,185},{53,0,0,1,0,185},{54,0,0,1,0,185},{55,0,0,1,0,185},{56,1,0,1,0,185},{0,1,1,1,186,48},{0,1,1,1,186,49},{0,1,1,1,186,50},{0,1,1,1,186,97},{0,1,1,1,186,99},{0,1,1,1,186,101},{0,1,1,1,186,105},{0,1,1,1,186,111},{0,1,1,1,186,115},{0,1,1,1,186,116},{35,0,0,1,0,186},{36,0,0,1,0,186},{37,0,0,1,0,186},{38,0,0,1,0,186},{39,0,0,1,0,186},{40,0,0,1,0,186},{41,0,0,1,0,186},{42,0,0,1,0,186},{43,0,0,1,0,186},{44,0,0,1,0,186},{45,0,0,1,0,186},{46,0,0,1,0,186},{47,0,0,1,0,186},{48,0,0,1,0,186},{49,0,0,1,0,186},{50,0,0,1,0,186},{51,0,0,1,0,186},{52,0,0,1,0,186},{53,0,0,1,0,186},{54,0,0,1,0,186},{55,0,0,1,0,186},{56,1,0,1,0,186},{0,1,1,1,187,48},{0,1,1,1,187,49},{0,1,1,1,187,50},{0,1,1,1,187,97},{0,1,1,1,187,99},{0,1,1,1,187,101},{0,1,1,1,187,105},{0,1,1,1,187,111},{0,1,1,1,187,115},{0,1,1,1,187,116},{35,0,0,1,0,187},{36,0,0,1,0,187},{37,0,0,1,0,187},{38,0,0,1,0,187},{39,0,0,1,0,187},{40,0,0,1,0,187},{41,0,0,1,0,187},{42,0,0,1,0,187},{43,0,0,1,0,187},{44,0,0,1,0,187},{45,0,0,1,0,187},{46,0,0,1,0,187},{47,0,0,1,0,187},{48,0,0,1,0,187},{49,0,0,1,0,187},{50,0,0,1,0,187},{51,0,0,1,0,187},{52,0,0,1,0,187},{53,0,0,1,0,187},{54,0,0,1,0,187},{55,0,0,1,0,187},{56,1,0,1,0,187},{0,1,1,1,189,48},{0,1,1,1,189,49},{0,1,1,1,189,50},{0,1,1,1,189,97},{0,1,1,1,189,99},{0,1,1,1,189,101},{0,1,1,1,189,105},{0,1,1,1,189,111},{0,1,1,1,189,115},{0,1,1,1,189,116},{35,0,0,1,0,189},{36,0,0,1,0,189},{37,0,0,1,0,189},{38,0,0,1,0,189},{39,0,0,1,0,189},{40,0,0,1,0,189},{41,0,0,1,0,189},{42,0,0,1,0,189},{43,0,0,1,0,189},{44,0,0,1,0,189},{45,0,0,1,0,189},{46,0,0,1,0,189},{47,0,0,1,0,189},{48,0,0,1,0,189},{49,0,0,1,0,189},{50,0,0,1,0,189},{51,0,0,1,0,189},{52,0,0,1,0,189},{53,0,0,1,0,189},{54,0,0,1,0,189},{55,0,0,1,0,189},{56,1,0,1,0,189},{0,1,1,1,190,48},{0,1,1,1,190,49},{0,1,1,1,190,50},{0,1,1,1,190,97},{0,1,1,1,190,99},{0,1,1,1,190,101},{0,1,1,1,190,105},{0,1,1,1,190,111},{0,1,1,1,190,115},{0,1,1,1,190,116},{35,0,0,1,0,190},{36,0,0,1,0,190},{37,0,0,1,0,190},{38,0,0,1,0,190},{39,0,0,1,0,190},{40,0,0,1,0,190},{41,0,0,1,0,190},{42,0,0,1,0,190},{43,0,0,1,0,190},{44,0,0,1,0,190},{45,0,0,1,0,190},{46,0,0,1,0,190},{47,0,0,1,0,190},{48,0,0,1,0,190},{49,0,0,1,0,190},{50,0,0,1,0,190},{51,0,0,1,0,190},{52,0,0,1,0,190},{53,0,0,1,0,190},{54,0,0,1,0,190},{55,0,0,1,0,190},{56,1,0,1,0,190},{0,1,1,1,196,48},{0,1,1,1,196,49},{0,1,1,1,196,50},{0,1,1,1,196,97},{0,1,1,1,196,99},{0,1,1,1,196,101},{0,1,1,1,196,105},{0,1,1,1,196,111},{0,1,1,1,196,115},{0,1,1,1,196,116},{35,0,0,1,0,196},{36,0,0,1,0,196},{37,0,0,1,0,196},{38,0,0,1,0,196},{39,0,0,1,0,196},{40,0,0,1,0,196},{41,0,0,1,0,196},{42,0,0,1,0,196},{43,0,0,1,0,196},{44,0,0,1,0,196},{45,0,0,1,0,196},{46,0,0,1,0,196},{47,0,0,1,0,196},{48,0,0,1,0,196},{49,0,0,1,0,196},{50,0,0,1,0,196},{51,0,0,1,0,196},{52,0,0,1,0,196},{53,0,0,1,0,196},{54,0,0,1,0,196},{55,0,0,1,0,196},{56,1,0,1,0,196},{0,1,1,1,198,48},{0,1,1,1,198,49},{0,1,1,1,198,50},{0,1,1,1,198,97},{0,1,1,1,198,99},{0,1,1,1,198,101},{0,1,1,1,198,105},{0,1,1,1,198,111},{0,1,1,1,198,115},{0,1,1,1,198,116},{35,0,0,1,0,198},{36,0,0,1,0,198},{37,0,0,1,0,198},{38,0,0,1,0,198},{39,0,0,1,0,198},{40,0,0,1,0,198},{41,0,0,1,0,198},{42,0,0,1,0,198},{43,0,0,1,0,198},{44,0,0,1,0,198},{45,0,0,1,0,198},{46,0,0,1,0,198},{47,0,0,1,0,198},{48,0,0,1,0,198},{49,0,0,1,0,198},{50,0,0,1,0,198},{51,0,0,1,0,198},{52,0,0,1,0,198},{53,0,0,1,0,198},{54,0,0,1,0,198},{55,0,0,1,0,198},{56,1,0,1,0,198},{0,1,1,1,228,48},{0,1,1,1,228,49},{0,1,1,1,228,50},{0,1,1,1,228,97},{0,1,1,1,228,99},{0,1,1,1,228,101},{0,1,1,1,228,105},{0,1,1,1,228,111},{0,1,1,1,228,115},{0,1,1,1,228,116},{35,0,0,1,0,228},{36,0,0,1,0,228},{37,0,0,1,0,228},{38,0,0,1,0,228},{39,0,0,1,0,228},{40,0,0,1,0,228},{41,0,0,1,0,228},{42,0,0,1,0,228},{43,0,0,1,0,228},{44,0,0,1,0,228},{45,0,0,1,0,228},{46,0,0,1,0,228},{47,0,0,1,0,228},{48,0,0,1,0,228},{49,0,0,1,0,228},{50,0,0,1,0,228},{51,0,0,1,0,228},{52,0,0,1,0,228},{53,0,0,1,0,228},{54,0,0,1,0,228},{55,0,0,1,0,228},{56,1,0,1,0,228},{0,1,1,1,232,48},{0,1,1,1,232,49},{0,1,1,1,232,50},{0,1,1,1,232,97},{0,1,1,1,232,99},{0,1,1,1,232,101},{0,1,1,1,232,105},{0,1,1,1,232,111},{0,1,1,1,232,115},{0,1,1,1,232,116},{35,0,0,1,0,232},{36,0,0,1,0,232},{37,0,0,1,0,232},{38,0,0,1,0,232},{39,0,0,1,0,232},{40,0,0,1,0,232},{41,0,0,1,0,232},{42,0,0,1,0,232},{43,0,0,1,0,232},{44,0,0,1,0,232},{45,0,0,1,0,232},{46,0,0,1,0,232},{47,0,0,1,0,232},{48,0,0,1,0,232},{49,0,0,1,0,232},{50,0,0,1,0,232},{51,0,0,1,0,232},{52,0,0,1,0,232},{53,0,0,1,0,232},{54,0,0,1,0,232},{55,0,0,1,0,232},{56,1,0,1,0,232},{0,1,1,1,233,48},{0,1,1,1,233,49},{0,1,1,1,233,50},{0,1,1,1,233,97},{0,1,1,1,233,99},{0,1,1,1,233,101},{0,1,1,1,233,105},{0,1,1,1,233,111},{0,1,1,1,233,115},{0,1,1,1,233,116},{35,0,0,1,0,233},{36,0,0,1,0,233},{37,0,0,1,0,233},{38,0,0,1,0,233},{39,0,0,1,0,233},{40,0,0,1,0,233},{41,0,0,1,0,233},{42,0,0,1,0,233},{43,0,0,1,0,233},{44,0,0,1,0,233},{45,0,0,1,0,233},{46,0,0,1,0,233},{47,0,0,1,0,233},{48,0,0,1,0,233},{49,0,0,1,0,233},{50,0,0,1,0,233},{51,0,0,1,0,233},{52,0,0,1,0,233},{53,0,0,1,0,233},{54,0,0,1,0,233},{55,0,0,1,0,233},{56,1,0,1,0,233},{57,0,0,1,0,1},{58,0,0,1,0,1},{59,0,0,1,0,1},{60,0,0,1,0,1},{61,0,0,1,0,1},{62,0,0,1,0,1},{63,0,0,1,0,1},{64,0,0,1,0,1},{65,0,0,1,0,1},{66,0,0,1,0,1},{67,0,0,1,0,1},{68,0,0,1,0,1},{69,0,0,1,0,1},{70,0,0,1,0,1},{71,0,0,1,0,1},{72,1,0,1,0,1},{57,0,0,1,0,135},{58,0,0,1,0,135},{59,0,0,1,0,135},{60,0,0,1,0,135},{61,0,0,1,0,135},{62,0,0,1,0,135},{63,0,0,1,0,135},{64,0,0,1,0,135},{65,0,0,1,0,135},{66,0,0,1,0,135},{67,0,0,1,0,135},{68,0,0,1,0,135},{69,0,0,1,0,135},{70,0,0,1,0,135},{71,0,0,1,0,135},{72,1,0,1,0,135},{57,0,0,1,0,137},{58,0,0,1,0,137},{59,0,0,1,0,137},{60,0,0,1,0,137},{61,0,0,1,0,137},{62,0,0,1,0,137},{63,0,0,1,0,137},{64,0,0,1,0,137},{65,0,0,1,0,137},{66,0,0,1,0,137},{67,0,0,1,0,137},{68,0,0,1,0,137},{69,0,0,1,0,137},{70,0,0,1,0,137},{71,0,0,1,0,137},{72,1,0,1,0,137},{57,0,0,1,0,138},{58,0,0,1,0,138},{59,0,0,1,0,138},{60,0,0,1,0,138},{61,0,0,1,0,138},{62,0,0,1,0,138},{63,0,0,1,0,138},{64,0,0,1,0,138},{65,0,0,1,0,138},{66,0,0,1,0,138},{67,0,0,1,0,138},{68,0,0,1,0,138},{69,0,0,1,0,138},{70,0,0,1,0,138},{71,0,0,1,0,138},{72,1,0,1,0,138},{57,0,0,1,0,139},{58,0,0,1,0,139},{59,0,0,1,0,139},{60,0,0,1,0,139},{61,0,0,1,0,139},{62,0,0,1,0,139},{63,0,0,1,0,139},{64,0,0,1,0,139},{65,0,0,1,0,139},{66,0,0,1,0,139},{67,0,0,1,0,139},{68,0,0,1,0,139},{69,0,0,1,0,139},{70,0,0,1,0,139},{71,0,0,1,0,139},{72,1,0,1,0,139},{57,0,0,1,0,140},{58,0,0,1,0,140},{59,0,0,1,0,140},{60,0,0,1,0,140},{61,0,0,1,0,140},{62,0,0,1,0,140},{63,0,0,1,0,140},{64,0,0,1,0,140},{65,0,0,1,0,140},{66,0,0,1,0,140},{67,0,0,1,0,140},{68,0,0,1,0,140},{69,0,0,1,0,140},{70,0,0,1,0,140},{71,0,0,1,0,140},{72,1,0,1,0,140},{57,0,0,1,0,141},{58,0,0,1,0,141},{59,0,0,1,0,141},{60,0,0,1,0,141},{61,0,0,1,0,141},{62,0,0,1,0,141},{63,0,0,1,0,141},{64,0,0,1,0,141},{65,0,0,1,0,141},{66,0,0,1,0,141},{67,0,0,1,0,141},{68,0,0,1,0,141},{69,0,0,1,0,141},{70,0,0,1,0,141},{71,0,0,1,0,141},{72,1,0,1,0,141},{57,0,0,1,0,143},{58,0,0,1,0,143},{59,0,0,1,0,143},{60,0,0,1,0,143},{61,0,0,1,0,143},{62,0,0,1,0,143},{63,0,0,1,0,143},{64,0,0,1,0,143},{65,0,0,1,0,143},{66,0,0,1,0,143},{67,0,0,1,0,143},{68,0,0,1,0,143},{69,0,0,1,0,143},{70,0,0,1,0,143},{71,0,0,1,0,143},{72,1,0,1,0,143},{57,0,0,1,0,147},{58,0,0,1,0,147},{59,0,0,1,0,147},{60,0,0,1,0,147},{61,0,0,1,0,147},{62,0,0,1,0,147},{63,0,0,1,0,147},{64,0,0,1,0,147},{65,0,0,1,0,147},{66,0,0,1,0,147},{67,0,0,1,0,147},{68,0,0,1,0,147},{69,0,0,1,0,147},{70,0,0,1,0,147},{71,0,0,1,0,147},{72,1,0,1,0,147},{57,0,0,1,0,149},{58,0,0,1,0,149},{59,0,0,1,0,149},{60,0,0,1,0,149},{61,0,0,1,0,149},{62,0,0,1,0,149},{63,0,0,1,0,149},{64,0,0,1,0,149},{65,0,0,1,0,149},{66,0,0,1,0,149},{67,0,0,1,0,149},{68,0,0,1,0,149},{69,0,0,1,0,149},{70,0,0,1,0,149},{71,0,0,1,0,149},{72,1,0,1,0,149},{57,0,0,1,0,150},{58,0,0,1,0,150},{59,0,0,1,0,150},{60,0,0,1,0,150},{61,0,0,1,0,150},{62,0,0,1,0,150},{63,0,0,1,0,150},{64,0,0,1,0,150},{65,0,0,1,0,150},{66,0,0,1,0,150},{67,0,0,1,0,150},{68,0,0,1,0,150},{69,0,0,1,0,150},{70,0,0,1,0,150},{71,0,0,1,0,150},{72,1,0,1,0,150},{57,0,0,1,0,151},{58,0,0,1,0,151},{59,0,0,1,0,151},{60,0,0,1,0,151},{61,0,0,1,0,151},{62,0,0,1,0,151},{63,0,0,1,0,151},{64,0,0,1,0,151},{65,0,0,1,0,151},{66,0,0,1,0,151},{67,0,0,1,0,151},{68,0,0,1,0,151},{69,0,0,1,0,151},{70,0,0,1,0,151},{71,0,0,1,0,151},{72,1,0,1,0,151},{57,0,0,1,0,152},{58,0,0,1,0,152},{59,0,0,1,0,152},{60,0,0,1,0,152},{61,0,0,1,0,152},{62,0,0,1,0,152},{63,0,0,1,0,152},{64,0,0,1,0,152},{65,0,0,1,0,152},{66,0,0,1,0,152},{67,0,0,1,0,152},{68,0,0,1,0,152},{69,0,0,1,0,152},{70,0,0,1,0,152},{71,0,0,1,0,152},{72,1,0,1,0,152},{57,0,0,1,0,155},{58,0,0,1,0,155},{59,0,0,1,0,155},{60,0,0,1,0,155},{61,0,0,1,0,155},{62,0,0,1,0,155},{63,0,0,1,0,155},{64,0,0,1,0,155},{65,0,0,1,0,155},{66,0,0,1,0,155},{67,0,0,1,0,155},{68,0,0,1,0,155},{69,0,0,1,0,155},{70,0,0,1,0,155},{71,0,0,1,0,155},{72,1,0,1,0,155},{57,0,0,1,0,157},{58,0,0,1,0,157},{59,0,0,1,0,157},{60,0,0,1,0,157},{61,0,0,1,0,157},{62,0,0,1,0,157},{63,0,0,1,0,157},{64,0,0,1,0,157},{65,0,0,1,0,157},{66,0,0,1,0,157},{67,0,0,1,0,157},{68,0,0,1,0,157},{69,0,0,1,0,157},{70,0,0,1,0,157},{71,0,0,1,0,157},{72,1,0,1,0,157},{57,0,0,1,0,158},{58,0,0,1,0,158},{59,0,0,1,0,158},{60,0,0,1,0,158},{61,0,0,1,0,158},{62,0,0,1,0,158},{63,0,0,1,0,158},{64,0,0,1,0,158},{65,0,0,1,0,158},{66,0,0,1,0,158},{67,0,0,1,0,158},{68,0,0,1,0,158},{69,0,0,1,0,158},{70,0,0,1,0,158},{71,0,0,1,0,158},{72,1,0,1,0,158},{57,0,0,1,0,165},{58,0,0,1,0,165},{59,0,0,1,0,165},{60,0,0,1,0,165},{61,0,0,1,0,165},{62,0,0,1,0,165},{63,0,0,1,0,165},{64,0,0,1,0,165},{65,0,0,1,0,165},{66,0,0,1,0,165},{67,0,0,1,0,165},{68,0,0,1,0,165},{69,0,0,1,0,165},{70,0,0,1,0,165},{71,0,0,1,0,165},{72,1,0,1,0,165},{57,0,0,1,0,166},{58,0,0,1,0,166},{59,0,0,1,0,166},{60,0,0,1,0,166},{61,0,0,1,0,166},{62,0,0,1,0,166},{63,0,0,1,0,166},{64,0,0,1,0,166},{65,0,0,1,0,166},{66,0,0,1,0,166},{67,0,0,1,0,166},{68,0,0,1,0,166},{69,0,0,1,0,166},{70,0,0,1,0,166},{71,0,0,1,0,166},{72,1,0,1,0,166},{57,0,0,1,0,168},{58,0,0,1,0,168},{59,0,0,1,0,168},{60,0,0,1,0,168},{61,0,0,1,0,168},{62,0,0,1,0,168},{63,0,0,1,0,168},{64,0,0,1,0,168},{65,0,0,1,0,168},{66,0,0,1,0,168},{67,0,0,1,0,168},{68,0,0,1,0,168},{69,0,0,1,0,168},{70,0,0,1,0,168},{71,0,0,1,0,168},{72,1,0,1,0,168},{57,0,0,1,0,174},{58,0,0,1,0,174},{59,0,0,1,0,174},{60,0,0,1,0,174},{61,0,0,1,0,174},{62,0,0,1,0,174},{63,0,0,1,0,174},{64,0,0,1,0,174},{65,0,0,1,0,174},{66,0,0,1,0,174},{67,0,0,1,0,174},{68,0,0,1,0,174},{69,0,0,1,0,174},{70,0,0,1,0,174},{71,0,0,1,0,174},{72,1,0,1,0,174},{57,0,0,1,0,175},{58,0,0,1,0,175},{59,0,0,1,0,175},{60,0,0,1,0,175},{61,0,0,1,0,175},{62,0,0,1,0,175},{63,0,0,1,0,175},{64,0,0,1,0,175},{65,0,0,1,0,175},{66,0,0,1,0,175},{67,0,0,1,0,175},{68,0,0,1,0,175},{69,0,0,1,0,175},{70,0,0,1,0,175},{71,0,0,1,0,175},{72,1,0,1,0,175},{57,0,0,1,0,180},{58,0,0,1,0,180},{59,0,0,1,0,180},{60,0,0,1,0,180},{61,0,0,1,0,180},{62,0,0,1,0,180},{63,0,0,1,0,180},{64,0,0,1,0,180},{65,0,0,1,0,180},{66,0,0,1,0,180},{67,0,0,1,0,180},{68,0,0,1,0,180},{69,0,0,1,0,180},{70,0,0,1,0,180},{71,0,0,1,0,180},{72,1,0,1,0,180},{57,0,0,1,0,182},{58,0,0,1,0,182},{59,0,0,1,0,182},{60,0,0,1,0,182},{61,0,0,1,0,182},{62,0,0,1,0,182},{63,0,0,1,0,182},{64,0,0,1,0,182},{65,0,0,1,0,182},{66,0,0,1,0,182},{67,0,0,1,0,182},{68,0,0,1,0,182},{69,0,0,1,0,182},{70,0,0,1,0,182},{71,0,0,1,0,182},{72,1,0,1,0,182},{57,0,0,1,0,183},{58,0,0,1,0,183},{59,0,0,1,0,183},{60,0,0,1,0,183},{61,0,0,1,0,183},{62,0,0,1,0,183},{63,0,0,1,0,183},{64,0,0,1,0,183},{65,0,0,1,0,183},{66,0,0,1,0,183},{67,0,0,1,0,183},{68,0,0,1,0,183},{69,0,0,1,0,183},{70,0,0,1,0,183},{71,0,0,1,0,183},{72,1,0,1,0,183},{57,0,0,1,0,188},{58,0,0,1,0,188},{59,0,0,1,0,188},{60,0,0,1,0,188},{61,0,0,1,0,188},{62,0,0,1,0,188},{63,0,0,1,0,188},{64,0,0,1,0,188},{65,0,0,1,0,188},{66,0,0,1,0,188},{67,0,0,1,0,188},{68,0,0,1,0,188},{69,0,0,1,0,188},{70,0,0,1,0,188},{71,0,0,1,0,188},{72,1,0,1,0,188},{57,0,0,1,0,191},{58,0,0,1,0,191},{59,0,0,1,0,191},{60,0,0,1,0,191},{61,0,0,1,0,191},{62,0,0,1,0,191},{63,0,0,1,0,191},{64,0,0,1,0,191},{65,0,0,1,0,191},{66,0,0,1,0,191},{67,0,0,1,0,191},{68,0,0,1,0,191},{69,0,0,1,0,191},{70,0,0,1,0,191},{71,0,0,1,0,191},{72,1,0,1,0,191},{57,0,0,1,0,197},{58,0,0,1,0,197},{59,0,0,1,0,197},{60,0,0,1,0,197},{61,0,0,1,0,197},{62,0,0,1,0,197},{63,0,0,1,0,197},{64,0,0,1,0,197},{65,0,0,1,0,197},{66,0,0,1,0,197},{67,0,0,1,0,197},{68,0,0,1,0,197},{69,0,0,1,0,197},{70,0,0,1,0,197},{71,0,0,1,0,197},{72,1,0,1,0,197},{57,0,0,1,0,231},{58,0,0,1,0,231},{59,0,0,1,0,231},{60,0,0,1,0,231},{61,0,0,1,0,231},{62,0,0,1,0,231},{63,0,0,1,0,231},{64,0,0,1,0,231},{65,0,0,1,0,231},{66,0,0,1,0,231},{67,0,0,1,0,231},{68,0,0,1,0,231},{69,0,0,1,0,231},{70,0,0,1,0,231},{71,0,0,1,0,231},{72,1,0,1,0,231},{57,0,0,1,0,239},{58,0,0,1,0,239},{59,0,0,1,0,239},{60,0,0,1,0,239},{61,0,0,1,0,239},{62,0,0,1,0,239},{63,0,0,1,0,239},{64,0,0,1,0,239},{65,0,0,1,0,239},{66,0,0,1,0,239},{67,0,0,1,0,239},{68,0,0,1,0,239},{69,0,0,1,0,239},{70,0,0,1,0,239},{71,0,0,1,0,239},{72,1,0,1,0,239},{1,0,0,1,0,9},{2,0,0,1,0,9},{3,0,0,1,0,9},{4,0,0,1,0,9},{5,0,0,1,0,9},{6,0,0,1,0,9},{7,0,0,1,0,9},{8,1,0,1,0,9},{1,0,0,1,0,142},{2,0,0,1,0,142},{3,0,0,1,0,142},{4,0,0,1,0,142},{5,0,0,1,0,142},{6,0,0,1,0,142},{7,0,0,1,0,142},{8,1,0,1,0,142},{1,0,0,1,0,144},{2,0,0,1,0,144},{3,0,0,1,0,144},{4,0,0,1,0,144},{5,0,0,1,0,144},{6,0,0,1,0,144},{7,0,0,1,0,144},{8,1,0,1,0,144},{1,0,0,1,0,145},{2,0,0,1,0,145},{3,0,0,1,0,145},{4,0,0,1,0,145},{5,0,0,1,0,145},{6,0,0,1,0,145},{7,0,0,1,0,145},{8,1,0,1,0,145},{1,0,0,1,0,148},{2,0,0,1,0,148},{3,0,0,1,0,148},{4,0,0,1,0,148},{5,0,0,1,0,148},{6,0,0,1,0,148},{7,0,0,1,0,148},{8,1,0,1,0,148},{1,0,0,1,0,159},{2,0,0,1,0,159},{3,0,0,1,0,159},{4,0,0,1,0,159},{5,0,0,1,0,159},{6,0,0,1,0,159},{7,0,0,1,0,159},{8,1,0,1,0,159},{1,0,0,1,0,171},{2,0,0,1,0,171},{3,0,0,1,0,171},{4,0,0,1,0,171},{5,0,0,1,0,171},{6,0,0,1,0,171},{7,0,0,1,0,171},{8,1,0,1,0,171},{1,0,0,1,0,206},{2,0,0,1,0,206},{3,0,0,1,0,206},{4,0,0,1,0,206},{5,0,0,1,0,206},{6,0,0,1,0,206},{7,0,0,1,0,206},{8,1,0,1,0,206},{1,0,0,1,0,215},{2,0,0,1,0,215},{3,0,0,1,0,215},{4,0,0,1,0,215},{5,0,0,1,0,215},{6,0,0,1,0,215},{7,0,0,1,0,215},{8,1,0,1,0,215},{1,0,0,1,0,225},{2,0,0,1,0,225},{3,0,0,1,0,225},{4,0,0,1,0,225},{5,0,0,1,0,225},{6,0,0,1,0,225},{7,0,0,1,0,225},{8,1,0,1,0,225},{1,0,0,1,0,236},{2,0,0,1,0,236},{3,0,0,1,0,236},{4,0,0,1,0,236},{5,0,0,1,0,236},{6,0,0,1,0,236},{7,0,0,1,0,236},{8,1,0,1,0,236},{1,0,0,1,0,237},{2,0,0,1,0,237},{3,0,0,1,0,237},{4,0,0,1,0,237},{5,0,0,1,0,237},{6,0,0,1,0,237},{7,0,0,1,0,237},{8,1,0,1,0,237},{9,0,0,1,0,199},{10,0,0,1,0,199},{11,0,0,1,0,199},{12,1,0,1,0,199},{9,0,0,1,0,207},{10,0,0,1,0,207},{11,0,0,1,0,207},{12,1,0,1,0,207},{9,0,0,1,0,234},{10,0,0,1,0,234},{11,0,0,1,0,234},{12,1,0,1,0,234},{9,0,0,1,0,235},{10,0,0,1,0,235},{11,0,0,1,0,235},{12,1,0,1,0,235},{13,0,0,1,0,192},{14,1,0,1,0,192},{13,0,0,1,0,193},{14,1,0,1,0,193},{13,0,0,1,0,200},{14,1,0,1,0,200},{13,0,0,1,0,201},{14,1,0,1,0,201},{13,0,0,1,0,202},{14,1,0,1,0,202},{13,0,0,1,0,205},{14,1,0,1,0,205},{13,0,0,1,0,210},{14,1,0,1,0,210},{13,0,0,1,0,213},{14,1,0,1,0,213},{13,0,0,1,0,218},{14,1,0,1,0,218},{13,0,0,1,0,219},{14,1,0,1,0,219},{13,0,0,1,0,238},{14,1,0,1,0,238},{13,0,0,1,0,240},{14,1,0,1,0,240},{13,0,0,1,0,242},{14,1,0,1,0,242},{13,0,0,1,0,243},{14,1,0,1,0,243},{13,0,0,1,0,255},{14,1,0,1,0,255},{0,1,0,1,0,203},{0,1,0,1,0,204},{0,1,0,1,0,211},{0,1,0,1,0,212},{0,1,0,1,0,214},{0,1,0,1,0,221},{0,1,0,1,0,222},{0,1,0,1,0,223},{0,1,0,1,0,241},{0,1,0,1,0,244},{0,1,0,1,0,245},{0,1,0,1,0,246},{0,1,0,1,0,247},{0,1,0,1,0,248},{0,1,0,1,0,250},{0,1,0,1,0,251},{0,1,0,1,0,252},{0,1,0,1,0,253},{0,1,0,1,0,254},{194,0,0,0,0,0},{195,0,0,0,0,0},{196,0,0,0,0,0},{197,0,0,0,0,0},{198,0,0,0,0,0},{199,0,0,0,0,0},{200,0,0,0,0,0},{201,0,0,0,0,0},{202,0,0,0,0,0},{203,0,0,0,0,0},{204,0,0,0,0,0},{205,0,0,0,0,0},{206,0,0,0,0,0},{207,0,0,0,0,0},{208,0,0,0,0,0},{9,0,1,1,92,48},{10,0,1,1,92,48},{11,0,1,1,92,48},{12,1,1,1,92,48},{9,0,1,1,92,49},{10,0,1,1,92,49},{11,0,1,1,92,49},{12,1,1,1,92,49},{9,0,1,1,92,50},{10,0,1,1,92,50},{11,0,1,1,92,50},{12,1,1,1,92,50},{9,0,1,1,92,97},{10,0,1,1,92,97},{11,0,1,1,92,97},{12,1,1,1,92,97},{9,0,1,1,92,99},{10,0,1,1,92,99},{11,0,1,1,92,99},{12,1,1,1,92,99},{9,0,1,1,92,101},{10,0,1,1,92,101},{11,0,1,1,92,101},{12,1,1,1,92,101},{9,0,1,1,92,105},{10,0,1,1,92,105},{11,0,1,1,92,105},{12,1,1,1,92,105},{9,0,1,1,92,111},{10,0,1,1,92,111},{11,0,1,1,92,111},{12,1,1,1,92,111},{9,0,1,1,92,115},{10,0,1,1,92,115},{11,0,1,1,92,115},{12,1,1,1,92,115},{9,0,1,1,92,116},{10,0,1,1,92,116},{11,0,1,1,92,116},{12,1,1,1,92,116},{13,0,1,1,92,32},{14,1,1,1,92,32},{13,0,1,1,92,37},{14,1,1,1,92,37},{13,0,1,1,92,45},{14,1,1,1,92,45},{13,0,1,1,92,46},{14,1,1,1,92,46},{13,0,1,1,92,47},{14,1,1,1,92,47},{13,0,1,1,92,51},{14,1,1,1,92,51},{13,0,1,1,92,52},{14,1,1,1,92,52},{13,0,1,1,92,53},{14,1,1,1,92,53},{13,0,1,1,92,54},{14,1,1,1,92,54},{13,0,1,1,92,55},{14,1,1,1,92,55},{13,0,1,1,92,56},{14,1,1,1,92,56},{13,0,1,1,92,57},{14,1,1,1,92,57},{13,0,1,1,92,61},{14,1,1,1,92,61},{13,0,1,1,92,65},{14,1,1,1,92,65},{13,0,1,1,92,95},{14,1,1,1,92,95},{13,0,1,1,92,98},{14,1,1,1,92,98},{13,0,1,1,92,100},{14,1,1,1,92,100},{13,0,1,1,92,102},{14,1,1,1,92,102},{13,0,1,1,92,103},{14,1,1,1,92,103},{13,0,1,1,92,104},{14,1,1,1,92,104},{13,0,1,1,92,108},{14,1,1,1,92,108},{13,0,1,1,92,109},{14,1,1,1,92,109},{13,0,1,1,92,110},{14,1,1,1,92,110},{13,0,1,1,92,112},{14,1,1,1,92,112},{13,0,1,1,92,114},{14,1,1,1,92,114},{13,0,1,1,92,117},{14,1,1,1,92,117},{0,1,1,1,92,58},{0,1,1,1,92,66},{0,1,1,1,92,67},{0,1,1,1,92,68},{0,1,1,1,92,69},{0,1,1,1,92,70},{0,1,1,1,92,71},{0,1,1,1,92,72},{0,1,1,1,92,73},{0,1,1,1,92,74},{0,1,1,1,92,75},{0,1,1,1,92,76},{0,1,1,1,92,77},{0,1,1,1,92,78},{0,1,1,1,92,79},{0,1,1,1,92,80},{0,1,1,1,92,81},{0,1,1,1,92,82},{0,1,1,1,92,83},{0,1,1,1,92,84},{0,1,1,1,92,85},{0,1,1,1,92,86},{0,1,1,1,92,87},{0,1,1,1,92,89},{0,1,1,1,92,106},{0,1,1,1,92,107},{0,1,1,1,92,113},{0,1,1,1,92,118},{0,1,1,1,92,119},{0,1,1,1,92,120},{0,1,1,1,92,121},{0,1,1,1,92,122},{85,0,0,1,0,92},{86,0,0,1,0,92},{87,0,0,1,0,92},{88,1,0,1,0,92},{9,0,1,1,195,48},{10,0,1,1,195,48},{11,0,1,1,195,48},{12,1,1,1,195,48},{9,0,1,1,195,49},{10,0,1,1,195,49},{11,0,1,1,195,49},{12,1,1,1,195,49},{9,0,1,1,195,50},{10,0,1,1,195,50},{11,0,1,1,195,50},{12,1,1,1,195,50},{9,0,1,1,195,97},{10,0,1,1,195,97},{11,0,1,1,195,97},{12,1,1,1,195,97},{9,0,1,1,195,99},{10,0,1,1,195,99},{11,0,1,1,195,99},{12,1,1,1,195,99},{9,0,1,1,195,101},{10,0,1,1,195,101},{11,0,1,1,195,101},{12,1,1,1,195,101},{9,0,1,1,195,105},{10,0,1,1,195,105},{11,0,1,1,195,105},{12,1,1,1,195,105},{9,0,1,1,195,111},{10,0,1,1,195,111},{11,0,1,1,195,111},{12,1,1,1,195,111},{9,0,1,1,195,115},{10,0,1,1,195,115},{11,0,1,1,195,115},{12,1,1,1,195,115},{9,0,1,1,195,116},{10,0,1,1,195,116},{11,0,1,1,195,116},{12,1,1,1,195,116},{13,0,1,1,195,32},{14,1,1,1,195,32},{13,0,1,1,195,37},{14,1,1,1,195,37},{13,0,1,1,195,45},{14,1,1,1,195,45},{13,0,1,1,195,46},{14,1,1,1,195,46},{13,0,1,1,195,47},{14,1,1,1,195,47},{13,0,1,1,195,51},{14,1,1,1,195,51},{13,0,1,1,195,52},{14,1,1,1,195,52},{13,0,1,1,195,53},{14,1,1,1,195,53},{13,0,1,1,195,54},{14,1,1,1,195,54},{13,0,1,1,195,55},{14,1,1,1,195,55},{13,0,1,1,195,56},{14,1,1,1,195,56},{13,0,1,1,195,57},{14,1,1,1,195,57},{13,0,1,1,195,61},{14,1,1,1,195,61},{13,0,1,1,195,65},{14,1,1,1,195,65},{13,0,1,1,195,95},{14,1,1,1,195,95},{13,0,1,1,195,98},{14,1,1,1,195,98},{13,0,1,1,195,100},{14,1,1,1,195,100},{13,0,1,1,195,102},{14,1,1,1,195,102},{13,0,1,1,195,103},{14,1,1,1,195,103},{13,0,1,1,195,104},{14,1,1,1,195,104},{13,0,1,1,195,108},{14,1,1,1,195,108},{13,0,1,1,195,109},{14,1,1,1,195,109},{13,0,1,1,195,110},{14,1,1,1,195,110},{13,0,1,1,195,112},{14,1,1,1,195,112},{13,0,1,1,195,114},{14,1,1,1,195,114},{13,0,1,1,195,117},{14,1,1,1,195,117},{0,1,1,1,195,58},{0,1,1,1,195,66},{0,1,1,1,195,67},{0,1,1,1,195,68},{0,1,1,1,195,69},{0,1,1,1,195,70},{0,1,1,1,195,71},{0,1,1,1,195,72},{0,1,1,1,195,73},{0,1,1,1,195,74},{0,1,1,1,195,75},{0,1,1,1,195,76},{0,1,1,1,195,77},{0,1,1,1,195,78},{0,1,1,1,195,79},{0,1,1,1,195,80},{0,1,1,1,195,81},{0,1,1,1,195,82},{0,1,1,1,195,83},{0,1,1,1,195,84},{0,1,1,1,195,85},{0,1,1,1,195,86},{0,1,1,1,195,87},{0,1,1,1,195,89},{0,1,1,1,195,106},{0,1,1,1,195,107},{0,1,1,1,195,113},{0,1,1,1,195,118},{0,1,1,1,195,119},{0,1,1,1,195,120},{0,1,1,1,195,121},{0,1,1,1,195,122},{85,0,0,1,0,195},{86,0,0,1,0,195},{87,0,0,1,0,195},{88,1,0,1,0,195},{9,0,1,1,208,48},{10,0,1,1,208,48},{11,0,1,1,208,48},{12,1,1,1,208,48},{9,0,1,1,208,49},{10,0,1,1,208,49},{11,0,1,1,208,49},{12,1,1,1,208,49},{9,0,1,1,208,50},{10,0,1,1,208,50},{11,0,1,1,208,50},{12,1,1,1,208,50},{9,0,1,1,208,97},{10,0,1,1,208,97},{11,0,1,1,208,97},{12,1,1,1,208,97},{9,0,1,1,208,99},{10,0,1,1,208,99},{11,0,1,1,208,99},{12,1,1,1,208,99},{9,0,1,1,208,101},{10,0,1,1,208,101},{11,0,1,1,208,101},{12,1,1,1,208,101},{9,0,1,1,208,105},{10,0,1,1,208,105},{11,0,1,1,208,105},{12,1,1,1,208,105},{9,0,1,1,208,111},{10,0,1,1,208,111},{11,0,1,1,208,111},{12,1,1,1,208,111},{9,0,1,1,208,115},{10,0,1,1,208,115},{11,0,1,1,208,115},{12,1,1,1,208,115},{9,0,1,1,208,116},{10,0,1,1,208,116},{11,0,1,1,208,116},{12,1,1,1,208,116},{13,0,1,1,208,32},{14,1,1,1,208,32},{13,0,1,1,208,37},{14,1,1,1,208,37},{13,0,1,1,208,45},{14,1,1,1,208,45},{13,0,1,1,208,46},{14,1,1,1,208,46},{13,0,1,1,208,47},{14,1,1,1,208,47},{13,0,1,1,208,51},{14,1,1,1,208,51},{13,0,1,1,208,52},{14,1,1,1,208,52},{13,0,1,1,208,53},{14,1,1,1,208,53},{13,0,1,1,208,54},{14,1,1,1,208,54},{13,0,1,1,208,55},{14,1,1,1,208,55},{13,0,1,1,208,56},{14,1,1,1,208,56},{13,0,1,1,208,57},{14,1,1,1,208,57},{13,0,1,1,208,61},{14,1,1,1,208,61},{13,0,1,1,208,65},{14,1,1,1,208,65},{13,0,1,1,208,95},{14,1,1,1,208,95},{13,0,1,1,208,98},{14,1,1,1,208,98},{13,0,1,1,208,100},{14,1,1,1,208,100},{13,0,1,1,208,102},{14,1,1,1,208,102},{13,0,1,1,208,103},{14,1,1,1,208,103},{13,0,1,1,208,104},{14,1,1,1,208,104},{13,0,1,1,208,108},{14,1,1,1,208,108},{13,0,1,1,208,109},{14,1,1,1,208,109},{13,0,1,1,208,110},{14,1,1,1,208,110},{13,0,1,1,208,112},{14,1,1,1,208,112},{13,0,1,1,208,114},{14,1,1,1,208,114},{13,0,1,1,208,117},{14,1,1,1,208,117},{0,1,1,1,208,58},{0,1,1,1,208,66},{0,1,1,1,208,67},{0,1,1,1,208,68},{0,1,1,1,208,69},{0,1,1,1,208,70},{0,1,1,1,208,71},{0,1,1,1,208,72},{0,1,1,1,208,73},{0,1,1,1,208,74},{0,1,1,1,208,75},{0,1,1,1,208,76},{0,1,1,1,208,77},{0,1,1,1,208,78},{0,1,1,1,208,79},{0,1,1,1,208,80},{0,1,1,1,208,81},{0,1,1,1,208,82},{0,1,1,1,208,83},{0,1,1,1,208,84},{0,1,1,1,208,85},{0,1,1,1,208,86},{0,1,1,1,208,87},{0,1,1,1,208,89},{0,1,1,1,208,106},{0,1,1,1,208,107},{0,1,1,1,208,113},{0,1,1,1,208,118},{0,1,1,1,208,119},{0,1,1,1,208,120},{0,1,1,1,208,121},{0,1,1,1,208,122},{85,0,0,1,0,208},{86,0,0,1,0,208},{87,0,0,1,0,208},{88,1,0,1,0,208},{13,0,1,1,128,48},{14,1,1,1,128,48},{13,0,1,1,128,49},{14,1,1,1,128,49},{13,0,1,1,128,50},{14,1,1,1,128,50},{13,0,1,1,128,97},{14,1,1,1,128,97},{13,0,1,1,128,99},{14,1,1,1,128,99},{13,0,1,1,128,101},{14,1,1,1,128,101},{13,0,1,1,128,105},{14,1,1,1,128,105},{13,0,1,1,128,111},{14,1,1,1,128,111},{13,0,1,1,128,115},{14,1,1,1,128,115},{13,0,1,1,128,116},{14,1,1,1,128,116},{0,1,1,1,128,32},{0,1,1,1,128,37},{0,1,1,1,128,45},{0,1,1,1,128,46},{0,1,1,1,128,47},{0,1,1,1,128,51},{0,1,1,1,128,52},{0,1,1,1,128,53},{0,1,1,1,128,54},{0,1,1,1,128,55},{0,1,1,1,128,56},{0,1,1,1,128,57},{0,1,1,1,128,61},{0,1,1,1,128,65},{0,1,1,1,128,95},{0,1,1,1,128,98},{0,1,1,1,128,100},{0,1,1,1,128,102},{0,1,1,1,128,103},{0,1,1,1,128,104},{0,1,1,1,128,108},{0,1,1,1,128,109},{0,1,1,1,128,110},{0,1,1,1,128,112},{0,1,1,1,128,114},{0,1,1,1,128,117},{17,0,0,1,0,128},{18,0,0,1,0,128},{19,0,0,1,0,128},{20,0,0,1,0,128},{21,0,0,1,0,128},{22,0,0,1,0,128},{23,0,0,1,0,128},{24,0,0,1,0,128},{25,0,0,1,0,128},{26,0,0,1,0,128},{27,0,0,1,0,128},{28,0,0,1,0,128},{29,0,0,1,0,128},{30,0,0,1,0,128},{31,0,0,1,0,128},{32,0,0,1,0,128},{33,0,0,1,0,128},{34,1,0,1,0,128},{13,0,1,1,130,48},{14,1,1,1,130,48},{13,0,1,1,130,49},{14,1,1,1,130,49},{13,0,1,1,130,50},{14,1,1,1,130,50},{13,0,1,1,130,97},{14,1,1,1,130,97},{13,0,1,1,130,99},{14,1,1,1,130,99},{13,0,1,1,130,101},{14,1,1,1,130,101},{13,0,1,1,130,105},{14,1,1,1,130,105},{13,0,1,1,130,111},{14,1,1,1,130,111},{13,0,1,1,130,115},{14,1,1,1,130,115},{13,0,1,1,130,116},{14,1,1,1,130,116},{0,1,1,1,130,32},{0,1,1,1,130,37},{0,1,1,1,130,45},{0,1,1,1,130,46},{0,1,1,1,130,47},{0,1,1,1,130,51},{0,1,1,1,130,52},{0,1,1,1,130,53},{0,1,1,1,130,54},{0,1,1,1,130,55},{0,1,1,1,130,56},{0,1,1,1,130,57},{0,1,1,1,130,61},{0,1,1,1,130,65},{0,1,1,1,130,95},{0,1,1,1,130,98},{0,1,1,1,130,100},{0,1,1,1,130,102},{0,1,1,1,130,103},{0,1,1,1,130,104},{0,1,1,1,130,108},{0,1,1,1,130,109},{0,1,1,1,130,110},{0,1,1,1,130,112},{0,1,1,1,130,114},{0,1,1,1,130,117},{17,0,0,1,0,130},{18,0,0,1,0,130},{19,0,0,1,0,130},{20,0,0,1,0,130},{21,0,0,1,0,130},{22,0,0,1,0,130},{23,0,0,1,0,130},{24,0,0,1,0,130},{25,0,0,1,0,130},{26,0,0,1,0,130},{27,0,0,1,0,130},{28,0,0,1,0,130},{29,0,0,1,0,130},{30,0,0,1,0,130},{31,0,0,1,0,130},{32,0,0,1,0,130},{33,0,0,1,0,130},{34,1,0,1,0,130},{13,0,1,1,131,48},{14,1,1,1,131,48},{13,0,1,1,131,49},{14,1,1,1,131,49},{13,0,1,1,131,50},{14,1,1,1,131,50},{13,0,1,1,131,97},{14,1,1,1,131,97},{13,0,1,1,131,99},{14,1,1,1,131,99},{13,0,1,1,131,101},{14,1,1,1,131,101},{13,0,1,1,131,105},{14,1,1,1,131,105},{13,0,1,1,131,111},{14,1,1,1,131,111},{13,0,1,1,131,115},{14,1,1,1,131,115},{13,0,1,1,131,116},{14,1,1,1,131,116},{0,1,1,1,131,32},{0,1,1,1,131,37},{0,1,1,1,131,45},{0,1,1,1,131,46},{0,1,1,1,131,47},{0,1,1,1,131,51},{0,1,1,1,131,52},{0,1,1,1,131,53},{0,1,1,1,131,54},{0,1,1,1,131,55},{0,1,1,1,131,56},{0,1,1,1,131,57},{0,1,1,1,131,61},{0,1,1,1,131,65},{0,1,1,1,131,95},{0,1,1,1,131,98},{0,1,1,1,131,100},{0,1,1,1,131,102},{0,1,1,1,131,103},{0,1,1,1,131,104},{0,1,1,1,131,108},{0,1,1,1,131,109},{0,1,1,1,131,110},{0,1,1,1,131,112},{0,1,1,1,131,114},{0,1,1,1,131,117},{17,0,0,1,0,131},{18,0,0,1,0,131},{19,0,0,1,0,131},{20,0,0,1,0,131},{21,0,0,1,0,131},{22,0,0,1,0,131},{23,0,0,1,0,131},{24,0,0,1,0,131},{25,0,0,1,0,131},{26,0,0,1,0,131},{27,0,0,1,0,131},{28,0,0,1,0,131},{29,0,0,1,0,131},{30,0,0,1,0,131},{31,0,0,1,0,131},{32,0,0,1,0,131},{33,0,0,1,0,131},{34,1,0,1,0,131},{13,0,1,1,162,48},{14,1,1,1,162,48},{13,0,1,1,162,49},{14,1,1,1,162,49},{13,0,1,1,162,50},{14,1,1,1,162,50},{13,0,1,1,162,97},{14,1,1,1,162,97},{13,0,1,1,162,99},{14,1,1,1,162,99},{13,0,1,1,162,101},{14,1,1,1,162,101},{13,0,1,1,162,105},{14,1,1,1,162,105},{13,0,1,1,162,111},{14,1,1,1,162,111},{13,0,1,1,162,115},{14,1,1,1,162,115},{13,0,1,1,162,116},{14,1,1,1,162,116},{0,1,1,1,162,32},{0,1,1,1,162,37},{0,1,1,1,162,45},{0,1,1,1,162,46},{0,1,1,1,162,47},{0,1,1,1,162,51},{0,1,1,1,162,52},{0,1,1,1,162,53},{0,1,1,1,162,54},{0,1,1,1,162,55},{0,1,1,1,162,56},{0,1,1,1,162,57},{0,1,1,1,162,61},{0,1,1,1,162,65},{0,1,1,1,162,95},{0,1,1,1,162,98},{0,1,1,1,162,100},{0,1,1,1,162,102},{0,1,1,1,162,103},{0,1,1,1,162,104},{0,1,1,1,162,108},{0,1,1,1,162,109},{0,1,1,1,162,110},{0,1,1,1,162,112},{0,1,1,1,162,114},{0,1,1,1,162,117},{17,0,0,1,0,162},{18,0,0,1,0,162},{19,0,0,1,0,162},{20,0,0,1,0,162},{21,0,0,1,0,162},{22,0,0,1,0,162},{23,0,0,1,0,162},{24,0,0,1,0,162},{25,0,0,1,0,162},{26,0,0,1,0,162},{27,0,0,1,0,162},{28,0,0,1,0,162},{29,0,0,1,0,162},{30,0,0,1,0,162},{31,0,0,1,0,162},{32,0,0,1,0,162},{33,0,0,1,0,162},{34,1,0,1,0,162},{13,0,1,1,184,48},{14,1,1,1,184,48},{13,0,1,1,184,49},{14,1,1,1,184,49},{13,0,1,1,184,50},{14,1,1,1,184,50},{13,0,1,1,184,97},{14,1,1,1,184,97},{13,0,1,1,184,99},{14,1,1,1,184,99},{13,0,1,1,184,101},{14,1,1,1,184,101},{13,0,1,1,184,105},{14,1,1,1,184,105},{13,0,1,1,184,111},{14,1,1,1,184,111},{13,0,1,1,184,115},{14,1,1,1,184,115},{13,0,1,1,184,116},{14,1,1,1,184,116},{0,1,1,1,184,32},{0,1,1,1,184,37},{0,1,1,1,184,45},{0,1,1,1,184,46},{0,1,1,1,184,47},{0,1,1,1,184,51},{0,1,1,1,184,52},{0,1,1,1,184,53},{0,1,1,1,184,54},{0,1,1,1,184,55},{0,1,1,1,184,56},{0,1,1,1,184,57},{0,1,1,1,184,61},{0,1,1,1,184,65},{0,1,1,1,184,95},{0,1,1,1,184,98},{0,1,1,1,184,100},{0,1,1,1,184,102},{0,1,1,1,184,103},{0,1,1,1,184,104},{0,1,1,1,184,108},{0,1,1,1,184,109},{0,1,1,1,184,110},{0,1,1,1,184,112},{0,1,1,1,184,114},{0,1,1,1,184,117},{17,0,0,1,0,184},{18,0,0,1,0,184},{19,0,0,1,0,184},{20,0,0,1,0,184},{21,0,0,1,0,184},{22,0,0,1,0,184},{23,0,0,1,0,184},{24,0,0,1,0,184},{25,0,0,1,0,184},{26,0,0,1,0,184},{27,0,0,1,0,184},{28,0,0,1,0,184},{29,0,0,1,0,184},{30,0,0,1,0,184},{31,0,0,1,0,184},{32,0,0,1,0,184},{33,0,0,1,0,184},{34,1,0,1,0,184},{13,0,1,1,194,48},{14,1,1,1,194,48},{13,0,1,1,194,49},{14,1,1,1,194,49},{13,0,1,1,194,50},{14,1,1,1,194,50},{13,0,1,1,194,97},{14,1,1,1,194,97},{13,0,1,1,194,99},{14,1,1,1,194,99},{13,0,1,1,194,101},{14,1,1,1,194,101},{13,0,1,1,194,105},{14,1,1,1,194,105},{13,0,1,1,194,111},{14,1,1,1,194,111},{13,0,1,1,194,115},{14,1,1,1,194,115},{13,0,1,1,194,116},{14,1,1,1,194,116},{0,1,1,1,194,32},{0,1,1,1,194,37},{0,1,1,1,194,45},{0,1,1,1,194,46},{0,1,1,1,194,47},{0,1,1,1,194,51},{0,1,1,1,194,52},{0,1,1,1,194,53},{0,1,1,1,194,54},{0,1,1,1,194,55},{0,1,1,1,194,56},{0,1,1,1,194,57},{0,1,1,1,194,61},{0,1,1,1,194,65},{0,1,1,1,194,95},{0,1,1,1,194,98},{0,1,1,1,194,100},{0,1,1,1,194,102},{0,1,1,1,194,103},{0,1,1,1,194,104},{0,1,1,1,194,108},{0,1,1,1,194,109},{0,1,1,1,194,110},{0,1,1,1,194,112},{0,1,1,1,194,114},{0,1,1,1,194,117},{17,0,0,1,0,194},{18,0,0,1,0,194},{19,0,0,1,0,194},{20,0,0,1,0,194},{21,0,0,1,0,194},{22,0,0,1,0,194},{23,0,0,1,0,194},{24,0,0,1,0,194},{25,0,0,1,0,194},{26,0,0,1,0,194},{27,0,0,1,0,194},{28,0,0,1,0,194},{29,0,0,1,0,194},{30,0,0,1,0,194},{31,0,0,1,0,194},{32,0,0,1,0,194},{33,0,0,1,0,194},{34,1,0,1,0,194},{13,0,1,1,224,48},{14,1,1,1,224,48},{13,0,1,1,224,49},{14,1,1,1,224,49},{13,0,1,1,224,50},{14,1,1,1,224,50},{13,0,1,1,224,97},{14,1,1,1,224,97},{13,0,1,1,224,99},{14,1,1,1,224,99},{13,0,1,1,224,101},{14,1,1,1,224,101},{13,0,1,1,224,105},{14,1,1,1,224,105},{13,0,1,1,224,111},{14,1,1,1,224,111},{13,0,1,1,224,115},{14,1,1,1,224,115},{13,0,1,1,224,116},{14,1,1,1,224,116},{0,1,1,1,224,32},{0,1,1,1,224,37},{0,1,1,1,224,45},{0,1,1,1,224,46},{0,1,1,1,224,47},{0,1,1,1,224,51},{0,1,1,1,224,52},{0,1,1,1,224,53},{0,1,1,1,224,54},{0,1,1,1,224,55},{0,1,1,1,224,56},{0,1,1,1,224,57},{0,1,1,1,224,61},{0,1,1,1,224,65},{0,1,1,1,224,95},{0,1,1,1,224,98},{0,1,1,1,224,100},{0,1,1,1,224,102},{0,1,1,1,224,103},{0,1,1,1,224,104},{0,1,1,1,224,108},{0,1,1,1,224,109},{0,1,1,1,224,110},{0,1,1,1,224,112},{0,1,1,1,224,114},{0,1,1,1,224,117},{17,0,0,1,0,224},{18,0,0,1,0,224},{19,0,0,1,0,224},{20,0,0,1,0,224},{21,0,0,1,0,224},{22,0,0,1,0,224},{23,0,0,1,0,224},{24,0,0,1,0,224},{25,0,0,1,0,224},{26,0,0,1,0,224},{27,0,0,1,0,224},{28,0,0,1,0,224},{29,0,0,1,0,224},{30,0,0,1,0,224},{31,0,0,1,0,224},{32,0,0,1,0,224},{33,0,0,1,0,224},{34,1,0,1,0,224},{13,0,1,1,226,48},{14,1,1,1,226,48},{13,0,1,1,226,49},{14,1,1,1,226,49},{13,0,1,1,226,50},{14,1,1,1,226,50},{13,0,1,1,226,97},{14,1,1,1,226,97},{13,0,1,1,226,99},{14,1,1,1,226,99},{13,0,1,1,226,101},{14,1,1,1,226,101},{13,0,1,1,226,105},{14,1,1,1,226,105},{13,0,1,1,226,111},{14,1,1,1,226,111},{13,0,1,1,226,115},{14,1,1,1,226,115},{13,0,1,1,226,116},{14,1,1,1,226,116},{0,1,1,1,226,32},{0,1,1,1,226,37},{0,1,1,1,226,45},{0,1,1,1,226,46},{0,1,1,1,226,47},{0,1,1,1,226,51},{0,1,1,1,226,52},{0,1,1,1,226,53},{0,1,1,1,226,54},{0,1,1,1,226,55},{0,1,1,1,226,56},{0,1,1,1,226,57},{0,1,1,1,226,61},{0,1,1,1,226,65},{0,1,1,1,226,95},{0,1,1,1,226,98},{0,1,1,1,226,100},{0,1,1,1,226,102},{0,1,1,1,226,103},{0,1,1,1,226,104},{0,1,1,1,226,108},{0,1,1,1,226,109},{0,1,1,1,226,110},{0,1,1,1,226,112},{0,1,1,1,226,114},{0,1,1,1,226,117},{17,0,0,1,0,226},{18,0,0,1,0,226},{19,0,0,1,0,226},{20,0,0,1,0,226},{21,0,0,1,0,226},{22,0,0,1,0,226},{23,0,0,1,0,226},{24,0,0,1,0,226},{25,0,0,1,0,226},{26,0,0,1,0,226},{27,0,0,1,0,226},{28,0,0,1,0,226},{29,0,0,1,0,226},{30,0,0,1,0,226},{31,0,0,1,0,226},{32,0,0,1,0,226},{33,0,0,1,0,226},{34,1,0,1,0,226},{0,1,1,1,153,48},{0,1,1,1,153,49},{0,1,1,1,153,50},{0,1,1,1,153,97},{0,1,1,1,153,99},{0,1,1,1,153,101},{0,1,1,1,153,105},{0,1,1,1,153,111},{0,1,1,1,153,115},{0,1,1,1,153,116},{35,0,0,1,0,153},{36,0,0,1,0,153},{37,0,0,1,0,153},{38,0,0,1,0,153},{39,0,0,1,0,153},{40,0,0,1,0,153},{41,0,0,1,0,153},{42,0,0,1,0,153},{43,0,0,1,0,153},{44,0,0,1,0,153},{45,0,0,1,0,153},{46,0,0,1,0,153},{47,0,0,1,0,153},{48,0,0,1,0,153},{49,0,0,1,0,153},{50,0,0,1,0,153},{51,0,0,1,0,153},{52,0,0,1,0,153},{53,0,0,1,0,153},{54,0,0,1,0,153},{55,0,0,1,0,153},{56,1,0,1,0,153},{0,1,1,1,161,48},{0,1,1,1,161,49},{0,1,1,1,161,50},{0,1,1,1,161,97},{0,1,1,1,161,99},{0,1,1,1,161,101},{0,1,1,1,161,105},{0,1,1,1,161,111},{0,1,1,1,161,115},{0,1,1,1,161,116},{35,0,0,1,0,161},{36,0,0,1,0,161},{37,0,0,1,0,161},{38,0,0,1,0,161},{39,0,0,1,0,161},{40,0,0,1,0,161},{41,0,0,1,0,161},{42,0,0,1,0,161},{43,0,0,1,0,161},{44,0,0,1,0,161},{45,0,0,1,0,161},{46,0,0,1,0,161},{47,0,0,1,0,161},{48,0,0,1,0,161},{49,0,0,1,0,161},{50,0,0,1,0,161},{51,0,0,1,0,161},{52,0,0,1,0,161},{53,0,0,1,0,161},{54,0,0,1,0,161},{55,0,0,1,0,161},{56,1,0,1,0,161},{0,1,1,1,167,48},{0,1,1,1,167,49},{0,1,1,1,167,50},{0,1,1,1,167,97},{0,1,1,1,167,99},{0,1,1,1,167,101},{0,1,1,1,167,105},{0,1,1,1,167,111},{0,1,1,1,167,115},{0,1,1,1,167,116},{35,0,0,1,0,167},{36,0,0,1,0,167},{37,0,0,1,0,167},{38,0,0,1,0,167},{39,0,0,1,0,167},{40,0,0,1,0,167},{41,0,0,1,0,167},{42,0,0,1,0,167},{43,0,0,1,0,167},{44,0,0,1,0,167},{45,0,0,1,0,167},{46,0,0,1,0,167},{47,0,0,1,0,167},{48,0,0,1,0,167},{49,0,0,1,0,167},{50,0,0,1,0,167},{51,0,0,1,0,167},{52,0,0,1,0,167},{53,0,0,1,0,167},{54,0,0,1,0,167},{55,0,0,1,0,167},{56,1,0,1,0,167},{0,1,1,1,172,48},{0,1,1,1,172,49},{0,1,1,1,172,50},{0,1,1,1,172,97},{0,1,1,1,172,99},{0,1,1,1,172,101},{0,1,1,1,172,105},{0,1,1,1,172,111},{0,1,1,1,172,115},{0,1,1,1,172,116},{35,0,0,1,0,172},{36,0,0,1,0,172},{37,0,0,1,0,172},{38,0,0,1,0,172},{39,0,0,1,0,172},{40,0,0,1,0,172},{41,0,0,1,0,172},{42,0,0,1,0,172},{43,0,0,1,0,172},{44,0,0,1,0,172},{45,0,0,1,0,172},{46,0,0,1,0,172},{47,0,0,1,0,172},{48,0,0,1,0,172},{49,0,0,1,0,172},{50,0,0,1,0,172},{51,0,0,1,0,172},{52,0,0,1,0,172},{53,0,0,1,0,172},{54,0,0,1,0,172},{55,0,0,1,0,172},{56,1,0,1,0,172},{0,1,1,1,176,48},{0,1,1,1,176,49},{0,1,1,1,176,50},{0,1,1,1,176,97},{0,1,1,1,176,99},{0,1,1,1,176,101},{0,1,1,1,176,105},{0,1,1,1,176,111},{0,1,1,1,176,115},{0,1,1,1,176,116},{35,0,0,1,0,176},{36,0,0,1,0,176},{37,0,0,1,0,176},{38,0,0,1,0,176},{39,0,0,1,0,176},{40,0,0,1,0,176},{41,0,0,1,0,176},{42,0,0,1,0,176},{43,0,0,1,0,176},{44,0,0,1,0,176},{45,0,0,1,0,176},{46,0,0,1,0,176},{47,0,0,1,0,176},{48,0,0,1,0,176},{49,0,0,1,0,176},{50,0,0,1,0,176},{51,0,0,1,0,176},{52,0,0,1,0,176},{53,0,0,1,0,176},{54,0,0,1,0,176},{55,0,0,1,0,176},{56,1,0,1,0,176},{0,1,1,1,177,48},{0,1,1,1,177,49},{0,1,1,1,177,50},{0,1,1,1,177,97},{0,1,1,1,177,99},{0,1,1,1,177,101},{0,1,1,1,177,105},{0,1,1,1,177,111},{0,1,1,1,177,115},{0,1,1,1,177,116},{35,0,0,1,0,177},{36,0,0,1,0,177},{37,0,0,1,0,177},{38,0,0,1,0,177},{39,0,0,1,0,177},{40,0,0,1,0,177},{41,0,0,1,0,177},{42,0,0,1,0,177},{43,0,0,1,0,177},{44,0,0,1,0,177},{45,0,0,1,0,177},{46,0,0,1,0,177},{47,0,0,1,0,177},{48,0,0,1,0,177},{49,0,0,1,0,177},{50,0,0,1,0,177},{51,0,0,1,0,177},{52,0,0,1,0,177},{53,0,0,1,0,177},{54,0,0,1,0,177},{55,0,0,1,0,177},{56,1,0,1,0,177},{0,1,1,1,179,48},{0,1,1,1,179,49},{0,1,1,1,179,50},{0,1,1,1,179,97},{0,1,1,1,179,99},{0,1,1,1,179,101},{0,1,1,1,179,105},{0,1,1,1,179,111},{0,1,1,1,179,115},{0,1,1,1,179,116},{35,0,0,1,0,179},{36,0,0,1,0,179},{37,0,0,1,0,179},{38,0,0,1,0,179},{39,0,0,1,0,179},{40,0,0,1,0,179},{41,0,0,1,0,179},{42,0,0,1,0,179},{43,0,0,1,0,179},{44,0,0,1,0,179},{45,0,0,1,0,179},{46,0,0,1,0,179},{47,0,0,1,0,179},{48,0,0,1,0,179},{49,0,0,1,0,179},{50,0,0,1,0,179},{51,0,0,1,0,179},{52,0,0,1,0,179},{53,0,0,1,0,179},{54,0,0,1,0,179},{55,0,0,1,0,179},{56,1,0,1,0,179},{0,1,1,1,209,48},{0,1,1,1,209,49},{0,1,1,1,209,50},{0,1,1,1,209,97},{0,1,1,1,209,99},{0,1,1,1,209,101},{0,1,1,1,209,105},{0,1,1,1,209,111},{0,1,1,1,209,115},{0,1,1,1,209,116},{35,0,0,1,0,209},{36,0,0,1,0,209},{37,0,0,1,0,209},{38,0,0,1,0,209},{39,0,0,1,0,209},{40,0,0,1,0,209},{41,0,0,1,0,209},{42,0,0,1,0,209},{43,0,0,1,0,209},{44,0,0,1,0,209},{45,0,0,1,0,209},{46,0,0,1,0,209},{47,0,0,1,0,209},{48,0,0,1,0,209},{49,0,0,1,0,209},{50,0,0,1,0,209},{51,0,0,1,0,209},{52,0,0,1,0,209},{53,0,0,1,0,209},{54,0,0,1,0,209},{55,0,0,1,0,209},{56,1,0,1,0,209},{0,1,1,1,216,48},{0,1,1,1,216,49},{0,1,1,1,216,50},{0,1,1,1,216,97},{0,1,1,1,216,99},{0,1,1,1,216,101},{0,1,1,1,216,105},{0,1,1,1,216,111},{0,1,1,1,216,115},{0,1,1,1,216,116},{35,0,0,1,0,216},{36,0,0,1,0,216},{37,0,0,1,0,216},{38,0,0,1,0,216},{39,0,0,1,0,216},{40,0,0,1,0,216},{41,0,0,1,0,216},{42,0,0,1,0,216},{43,0,0,1,0,216},{44,0,0,1,0,216},{45,0,0,1,0,216},{46,0,0,1,0,216},{47,0,0,1,0,216},{48,0,0,1,0,216},{49,0,0,1,0,216},{50,0,0,1,0,216},{51,0,0,1,0,216},{52,0,0,1,0,216},{53,0,0,1,0,216},{54,0,0,1,0,216},{55,0,0,1,0,216},{56,1,0,1,0,216},{0,1,1,1,217,48},{0,1,1,1,217,49},{0,1,1,1,217,50},{0,1,1,1,217,97},{0,1,1,1,217,99},{0,1,1,1,217,101},{0,1,1,1,217,105},{0,1,1,1,217,111},{0,1,1,1,217,115},{0,1,1,1,217,116},{35,0,0,1,0,217},{36,0,0,1,0,217},{37,0,0,1,0,217},{38,0,0,1,0,217},{39,0,0,1,0,217},{40,0,0,1,0,217},{41,0,0,1,0,217},{42,0,0,1,0,217},{43,0,0,1,0,217},{44,0,0,1,0,217},{45,0,0,1,0,217},{46,0,0,1,0,217},{47,0,0,1,0,217},{48,0,0,1,0,217},{49,0,0,1,0,217},{50,0,0,1,0,217},{51,0,0,1,0,217},{52,0,0,1,0,217},{53,0,0,1,0,217},{54,0,0,1,0,217},{55,0,0,1,0,217},{56,1,0,1,0,217},{0,1,1,1,227,48},{0,1,1,1,227,49},{0,1,1,1,227,50},{0,1,1,1,227,97},{0,1,1,1,227,99},{0,1,1,1,227,101},{0,1,1,1,227,105},{0,1,1,1,227,111},{0,1,1,1,227,115},{0,1,1,1,227,116},{35,0,0,1,0,227},{36,0,0,1,0,227},{37,0,0,1,0,227},{38,0,0,1,0,227},{39,0,0,1,0,227},{40,0,0,1,0,227},{41,0,0,1,0,227},{42,0,0,1,0,227},{43,0,0,1,0,227},{44,0,0,1,0,227},{45,0,0,1,0,227},{46,0,0,1,0,227},{47,0,0,1,0,227},{48,0,0,1,0,227},{49,0,0,1,0,227},{50,0,0,1,0,227},{51,0,0,1,0,227},{52,0,0,1,0,227},{53,0,0,1,0,227},{54,0,0,1,0,227},{55,0,0,1,0,227},{56,1,0,1,0,227},{0,1,1,1,229,48},{0,1,1,1,229,49},{0,1,1,1,229,50},{0,1,1,1,229,97},{0,1,1,1,229,99},{0,1,1,1,229,101},{0,1,1,1,229,105},{0,1,1,1,229,111},{0,1,1,1,229,115},{0,1,1,1,229,116},{35,0,0,1,0,229},{36,0,0,1,0,229},{37,0,0,1,0,229},{38,0,0,1,0,229},{39,0,0,1,0,229},{40,0,0,1,0,229},{41,0,0,1,0,229},{42,0,0,1,0,229},{43,0,0,1,0,229},{44,0,0,1,0,229},{45,0,0,1,0,229},{46,0,0,1,0,229},{47,0,0,1,0,229},{48,0,0,1,0,229},{49,0,0,1,0,229},{50,0,0,1,0,229},{51,0,0,1,0,229},{52,0,0,1,0,229},{53,0,0,1,0,229},{54,0,0,1,0,229},{55,0,0,1,0,229},{56,1,0,1,0,229},{0,1,1,1,230,48},{0,1,1,1,230,49},{0,1,1,1,230,50},{0,1,1,1,230,97},{0,1,1,1,230,99},{0,1,1,1,230,101},{0,1,1,1,230,105},{0,1,1,1,230,111},{0,1,1,1,230,115},{0,1,1,1,230,116},{35,0,0,1,0,230},{36,0,0,1,0,230},{37,0,0,1,0,230},{38,0,0,1,0,230},{39,0,0,1,0,230},{40,0,0,1,0,230},{41,0,0,1,0,230},{42,0,0,1,0,230},{43,0,0,1,0,230},{44,0,0,1,0,230},{45,0,0,1,0,230},{46,0,0,1,0,230},{47,0,0,1,0,230},{48,0,0,1,0,230},{49,0,0,1,0,230},{50,0,0,1,0,230},{51,0,0,1,0,230},{52,0,0,1,0,230},{53,0,0,1,0,230},{54,0,0,1,0,230},{55,0,0,1,0,230},{56,1,0,1,0,230},{57,0,0,1,0,129},{58,0,0,1,0,129},{59,0,0,1,0,129},{60,0,0,1,0,129},{61,0,0,1,0,129},{62,0,0,1,0,129},{63,0,0,1,0,129},{64,0,0,1,0,129},{65,0,0,1,0,129},{66,0,0,1,0,129},{67,0,0,1,0,129},{68,0,0,1,0,129},{69,0,0,1,0,129},{70,0,0,1,0,129},{71,0,0,1,0,129},{72,1,0,1,0,129},{57,0,0,1,0,132},{58,0,0,1,0,132},{59,0,0,1,0,132},{60,0,0,1,0,132},{61,0,0,1,0,132},{62,0,0,1,0,132},{63,0,0,1,0,132},{64,0,0,1,0,132},{65,0,0,1,0,132},{66,0,0,1,0,132},{67,0,0,1,0,132},{68,0,0,1,0,132},{69,0,0,1,0,132},{70,0,0,1,0,132},{71,0,0,1,0,132},{72,1,0,1,0,132},{57,0,0,1,0,133},{58,0,0,1,0,133},{59,0,0,1,0,133},{60,0,0,1,0,133},{61,0,0,1,0,133},{62,0,0,1,0,133},{63,0,0,1,0,133},{64,0,0,1,0,133},{65,0,0,1,0,133},{66,0,0,1,0,133},{67,0,0,1,0,133},{68,0,0,1,0,133},{69,0,0,1,0,133},{70,0,0,1,0,133},{71,0,0,1,0,133},{72,1,0,1,0,133},{57,0,0,1,0,134},{58,0,0,1,0,134},{59,0,0,1,0,134},{60,0,0,1,0,134},{61,0,0,1,0,134},{62,0,0,1,0,134},{63,0,0,1,0,134},{64,0,0,1,0,134},{65,0,0,1,0,134},{66,0,0,1,0,134},{67,0,0,1,0,134},{68,0,0,1,0,134},{69,0,0,1,0,134},{70,0,0,1,0,134},{71,0,0,1,0,134},{72,1,0,1,0,134},{57,0,0,1,0,136},{58,0,0,1,0,136},{59,0,0,1,0,136},{60,0,0,1,0,136},{61,0,0,1,0,136},{62,0,0,1,0,136},{63,0,0,1,0,136},{64,0,0,1,0,136},{65,0,0,1,0,136},{66,0,0,1,0,136},{67,0,0,1,0,136},{68,0,0,1,0,136},{69,0,0,1,0,136},{70,0,0,1,0,136},{71,0,0,1,0,136},{72,1,0,1,0,136},{57,0,0,1,0,146},{58,0,0,1,0,146},{59,0,0,1,0,146},{60,0,0,1,0,146},{61,0,0,1,0,146},{62,0,0,1,0,146},{63,0,0,1,0,146},{64,0,0,1,0,146},{65,0,0,1,0,146},{66,0,0,1,0,146},{67,0,0,1,0,146},{68,0,0,1,0,146},{69,0,0,1,0,146},{70,0,0,1,0,146},{71,0,0,1,0,146},{72,1,0,1,0,146},{57,0,0,1,0,154},{58,0,0,1,0,154},{59,0,0,1,0,154},{60,0,0,1,0,154},{61,0,0,1,0,154},{62,0,0,1,0,154},{63,0,0,1,0,154},{64,0,0,1,0,154},{65,0,0,1,0,154},{66,0,0,1,0,154},{67,0,0,1,0,154},{68,0,0,1,0,154},{69,0,0,1,0,154},{70,0,0,1,0,154},{71,0,0,1,0,154},{72,1,0,1,0,154},{57,0,0,1,0,156},{58,0,0,1,0,156},{59,0,0,1,0,156},{60,0,0,1,0,156},{61,0,0,1,0,156},{62,0,0,1,0,156},{63,0,0,1,0,156},{64,0,0,1,0,156},{65,0,0,1,0,156},{66,0,0,1,0,156},{67,0,0,1,0,156},{68,0,0,1,0,156},{69,0,0,1,0,156},{70,0,0,1,0,156},{71,0,0,1,0,156},{72,1,0,1,0,156},{57,0,0,1,0,160},{58,0,0,1,0,160},{59,0,0,1,0,160},{60,0,0,1,0,160},{61,0,0,1,0,160},{62,0,0,1,0,160},{63,0,0,1,0,160},{64,0,0,1,0,160},{65,0,0,1,0,160},{66,0,0,1,0,160},{67,0,0,1,0,160},{68,0,0,1,0,160},{69,0,0,1,0,160},{70,0,0,1,0,160},{71,0,0,1,0,160},{72,1,0,1,0,160},{57,0,0,1,0,163},{58,0,0,1,0,163},{59,0,0,1,0,163},{60,0,0,1,0,163},{61,0,0,1,0,163},{62,0,0,1,0,163},{63,0,0,1,0,163},{64,0,0,1,0,163},{65,0,0,1,0,163},{66,0,0,1,0,163},{67,0,0,1,0,163},{68,0,0,1,0,163},{69,0,0,1,0,163},{70,0,0,1,0,163},{71,0,0,1,0,163},{72,1,0,1,0,163},{57,0,0,1,0,164},{58,0,0,1,0,164},{59,0,0,1,0,164},{60,0,0,1,0,164},{61,0,0,1,0,164},{62,0,0,1,0,164},{63,0,0,1,0,164},{64,0,0,1,0,164},{65,0,0,1,0,164},{66,0,0,1,0,164},{67,0,0,1,0,164},{68,0,0,1,0,164},{69,0,0,1,0,164},{70,0,0,1,0,164},{71,0,0,1,0,164},{72,1,0,1,0,164},{57,0,0,1,0,169},{58,0,0,1,0,169},{59,0,0,1,0,169},{60,0,0,1,0,169},{61,0,0,1,0,169},{62,0,0,1,0,169},{63,0,0,1,0,169},{64,0,0,1,0,169},{65,0,0,1,0,169},{66,0,0,1,0,169},{67,0,0,1,0,169},{68,0,0,1,0,169},{69,0,0,1,0,169},{70,0,0,1,0,169},{71,0,0,1,0,169},{72,1,0,1,0,169},{57,0,0,1,0,170},{58,0,0,1,0,170},{59,0,0,1,0,170},{60,0,0,1,0,170},{61,0,0,1,0,170},{62,0,0,1,0,170},{63,0,0,1,0,170},{64,0,0,1,0,170},{65,0,0,1,0,170},{66,0,0,1,0,170},{67,0,0,1,0,170},{68,0,0,1,0,170},{69,0,0,1,0,170},{70,0,0,1,0,170},{71,0,0,1,0,170},{72,1,0,1,0,170},{57,0,0,1,0,173},{58,0,0,1,0,173},{59,0,0,1,0,173},{60,0,0,1,0,173},{61,0,0,1,0,173},{62,0,0,1,0,173},{63,0,0,1,0,173},{64,0,0,1,0,173},{65,0,0,1,0,173},{66,0,0,1,0,173},{67,0,0,1,0,173},{68,0,0,1,0,173},{69,0,0,1,0,173},{70,0,0,1,0,173},{71,0,0,1,0,173},{72,1,0,1,0,173},{57,0,0,1,0,178},{58,0,0,1,0,178},{59,0,0,1,0,178},{60,0,0,1,0,178},{61,0,0,1,0,178},{62,0,0,1,0,178},{63,0,0,1,0,178},{64,0,0,1,0,178},{65,0,0,1,0,178},{66,0,0,1,0,178},{67,0,0,1,0,178},{68,0,0,1,0,178},{69,0,0,1,0,178},{70,0,0,1,0,178},{71,0,0,1,0,178},{72,1,0,1,0,178},{57,0,0,1,0,181},{58,0,0,1,0,181},{59,0,0,1,0,181},{60,0,0,1,0,181},{61,0,0,1,0,181},{62,0,0,1,0,181},{63,0,0,1,0,181},{64,0,0,1,0,181},{65,0,0,1,0,181},{66,0,0,1,0,181},{67,0,0,1,0,181},{68,0,0,1,0,181},{69,0,0,1,0,181},{70,0,0,1,0,181},{71,0,0,1,0,181},{72,1,0,1,0,181},{57,0,0,1,0,185},{58,0,0,1,0,185},{59,0,0,1,0,185},{60,0,0,1,0,185},{61,0,0,1,0,185},{62,0,0,1,0,185},{63,0,0,1,0,185},{64,0,0,1,0,185},{65,0,0,1,0,185},{66,0,0,1,0,185},{67,0,0,1,0,185},{68,0,0,1,0,185},{69,0,0,1,0,185},{70,0,0,1,0,185},{71,0,0,1,0,185},{72,1,0,1,0,185},{57,0,0,1,0,186},{58,0,0,1,0,186},{59,0,0,1,0,186},{60,0,0,1,0,186},{61,0,0,1,0,186},{62,0,0,1,0,186},{63,0,0,1,0,186},{64,0,0,1,0,186},{65,0,0,1,0,186},{66,0,0,1,0,186},{67,0,0,1,0,186},{68,0,0,1,0,186},{69,0,0,1,0,186},{70,0,0,1,0,186},{71,0,0,1,0,186},{72,1,0,1,0,186},{57,0,0,1,0,187},{58,0,0,1,0,187},{59,0,0,1,0,187},{60,0,0,1,0,187},{61,0,0,1,0,187},{62,0,0,1,0,187},{63,0,0,1,0,187},{64,0,0,1,0,187},{65,0,0,1,0,187},{66,0,0,1,0,187},{67,0,0,1,0,187},{68,0,0,1,0,187},{69,0,0,1,0,187},{70,0,0,1,0,187},{71,0,0,1,0,187},{72,1,0,1,0,187},{57,0,0,1,0,189},{58,0,0,1,0,189},{59,0,0,1,0,189},{60,0,0,1,0,189},{61,0,0,1,0,189},{62,0,0,1,0,189},{63,0,0,1,0,189},{64,0,0,1,0,189},{65,0,0,1,0,189},{66,0,0,1,0,189},{67,0,0,1,0,189},{68,0,0,1,0,189},{69,0,0,1,0,189},{70,0,0,1,0,189},{71,0,0,1,0,189},{72,1,0,1,0,189},{57,0,0,1,0,190},{58,0,0,1,0,190},{59,0,0,1,0,190},{60,0,0,1,0,190},{61,0,0,1,0,190},{62,0,0,1,0,190},{63,0,0,1,0,190},{64,0,0,1,0,190},{65,0,0,1,0,190},{66,0,0,1,0,190},{67,0,0,1,0,190},{68,0,0,1,0,190},{69,0,0,1,0,190},{70,0,0,1,0,190},{71,0,0,1,0,190},{72,1,0,1,0,190},{57,0,0,1,0,196},{58,0,0,1,0,196},{59,0,0,1,0,196},{60,0,0,1,0,196},{61,0,0,1,0,196},{62,0,0,1,0,196},{63,0,0,1,0,196},{64,0,0,1,0,196},{65,0,0,1,0,196},{66,0,0,1,0,196},{67,0,0,1,0,196},{68,0,0,1,0,196},{69,0,0,1,0,196},{70,0,0,1,0,196},{71,0,0,1,0,196},{72,1,0,1,0,196},{57,0,0,1,0,198},{58,0,0,1,0,198},{59,0,0,1,0,198},{60,0,0,1,0,198},{61,0,0,1,0,198},{62,0,0,1,0,198},{63,0,0,1,0,198},{64,0,0,1,0,198},{65,0,0,1,0,198},{66,0,0,1,0,198},{67,0,0,1,0,198},{68,0,0,1,0,198},{69,0,0,1,0,198},{70,0,0,1,0,198},{71,0,0,1,0,198},{72,1,0,1,0,198},{57,0,0,1,0,228},{58,0,0,1,0,228},{59,0,0,1,0,228},{60,0,0,1,0,228},{61,0,0,1,0,228},{62,0,0,1,0,228},{63,0,0,1,0,228},{64,0,0,1,0,228},{65,0,0,1,0,228},{66,0,0,1,0,228},{67,0,0,1,0,228},{68,0,0,1,0,228},{69,0,0,1,0,228},{70,0,0,1,0,228},{71,0,0,1,0,228},{72,1,0,1,0,228},{57,0,0,1,0,232},{58,0,0,1,0,232},{59,0,0,1,0,232},{60,0,0,1,0,232},{61,0,0,1,0,232},{62,0,0,1,0,232},{63,0,0,1,0,232},{64,0,0,1,0,232},{65,0,0,1,0,232},{66,0,0,1,0,232},{67,0,0,1,0,232},{68,0,0,1,0,232},{69,0,0,1,0,232},{70,0,0,1,0,232},{71,0,0,1,0,232},{72,1,0,1,0,232},{57,0,0,1,0,233},{58,0,0,1,0,233},{59,0,0,1,0,233},{60,0,0,1,0,233},{61,0,0,1,0,233},{62,0,0,1,0,233},{63,0,0,1,0,233},{64,0,0,1,0,233},{65,0,0,1,0,233},{66,0,0,1,0,233},{67,0,0,1,0,233},{68,0,0,1,0,233},{69,0,0,1,0,233},{70,0,0,1,0,233},{71,0,0,1,0,233},{72,1,0,1,0,233},{1,0,0,1,0,1},{2,0,0,1,0,1},{3,0,0,1,0,1},{4,0,0,1,0,1},{5,0,0,1,0,1},{6,0,0,1,0,1},{7,0,0,1,0,1},{8,1,0,1,0,1},{1,0,0,1,0,135},{2,0,0,1,0,135},{3,0,0,1,0,135},{4,0,0,1,0,135},{5,0,0,1,0,135},{6,0,0,1,0,135},{7,0,0,1,0,135},{8,1,0,1,0,135},{1,0,0,1,0,137},{2,0,0,1,0,137},{3,0,0,1,0,137},{4,0,0,1,0,137},{5,0,0,1,0,137},{6,0,0,1,0,137},{7,0,0,1,0,137},{8,1,0,1,0,137},{1,0,0,1,0,138},{2,0,0,1,0,138},{3,0,0,1,0,138},{4,0,0,1,0,138},{5,0,0,1,0,138},{6,0,0,1,0,138},{7,0,0,1,0,138},{8,1,0,1,0,138},{1,0,0,1,0,139},{2,0,0,1,0,139},{3,0,0,1,0,139},{4,0,0,1,0,139},{5,0,0,1,0,139},{6,0,0,1,0,139},{7,0,0,1,0,139},{8,1,0,1,0,139},{1,0,0,1,0,140},{2,0,0,1,0,140},{3,0,0,1,0,140},{4,0,0,1,0,140},{5,0,0,1,0,140},{6,0,0,1,0,140},{7,0,0,1,0,140},{8,1,0,1,0,140},{1,0,0,1,0,141},{2,0,0,1,0,141},{3,0,0,1,0,141},{4,0,0,1,0,141},{5,0,0,1,0,141},{6,0,0,1,0,141},{7,0,0,1,0,141},{8,1,0,1,0,141},{1,0,0,1,0,143},{2,0,0,1,0,143},{3,0,0,1,0,143},{4,0,0,1,0,143},{5,0,0,1,0,143},{6,0,0,1,0,143},{7,0,0,1,0,143},{8,1,0,1,0,143},{1,0,0,1,0,147},{2,0,0,1,0,147},{3,0,0,1,0,147},{4,0,0,1,0,147},{5,0,0,1,0,147},{6,0,0,1,0,147},{7,0,0,1,0,147},{8,1,0,1,0,147},{1,0,0,1,0,149},{2,0,0,1,0,149},{3,0,0,1,0,149},{4,0,0,1,0,149},{5,0,0,1,0,149},{6,0,0,1,0,149},{7,0,0,1,0,149},{8,1,0,1,0,149},{1,0,0,1,0,150},{2,0,0,1,0,150},{3,0,0,1,0,150},{4,0,0,1,0,150},{5,0,0,1,0,150},{6,0,0,1,0,150},{7,0,0,1,0,150},{8,1,0,1,0,150},{1,0,0,1,0,151},{2,0,0,1,0,151},{3,0,0,1,0,151},{4,0,0,1,0,151},{5,0,0,1,0,151},{6,0,0,1,0,151},{7,0,0,1,0,151},{8,1,0,1,0,151},{1,0,0,1,0,152},{2,0,0,1,0,152},{3,0,0,1,0,152},{4,0,0,1,0,152},{5,0,0,1,0,152},{6,0,0,1,0,152},{7,0,0,1,0,152},{8,1,0,1,0,152},{1,0,0,1,0,155},{2,0,0,1,0,155},{3,0,0,1,0,155},{4,0,0,1,0,155},{5,0,0,1,0,155},{6,0,0,1,0,155},{7,0,0,1,0,155},{8,1,0,1,0,155},{1,0,0,1,0,157},{2,0,0,1,0,157},{3,0,0,1,0,157},{4,0,0,1,0,157},{5,0,0,1,0,157},{6,0,0,1,0,157},{7,0,0,1,0,157},{8,1,0,1,0,157},{1,0,0,1,0,158},{2,0,0,1,0,158},{3,0,0,1,0,158},{4,0,0,1,0,158},{5,0,0,1,0,158},{6,0,0,1,0,158},{7,0,0,1,0,158},{8,1,0,1,0,158},{1,0,0,1,0,165},{2,0,0,1,0,165},{3,0,0,1,0,165},{4,0,0,1,0,165},{5,0,0,1,0,165},{6,0,0,1,0,165},{7,0,0,1,0,165},{8,1,0,1,0,165},{1,0,0,1,0,166},{2,0,0,1,0,166},{3,0,0,1,0,166},{4,0,0,1,0,166},{5,0,0,1,0,166},{6,0,0,1,0,166},{7,0,0,1,0,166},{8,1,0,1,0,166},{1,0,0,1,0,168},{2,0,0,1,0,168},{3,0,0,1,0,168},{4,0,0,1,0,168},{5,0,0,1,0,168},{6,0,0,1,0,168},{7,0,0,1,0,168},{8,1,0,1,0,168},{1,0,0,1,0,174},{2,0,0,1,0,174},{3,0,0,1,0,174},{4,0,0,1,0,174},{5,0,0,1,0,174},{6,0,0,1,0,174},{7,0,0,1,0,174},{8,1,0,1,0,174},{1,0,0,1,0,175},{2,0,0,1,0,175},{3,0,0,1,0,175},{4,0,0,1,0,175},{5,0,0,1,0,175},{6,0,0,1,0,175},{7,0,0,1,0,175},{8,1,0,1,0,175},{1,0,0,1,0,180},{2,0,0,1,0,180},{3,0,0,1,0,180},{4,0,0,1,0,180},{5,0,0,1,0,180},{6,0,0,1,0,180},{7,0,0,1,0,180},{8,1,0,1,0,180},{1,0,0,1,0,182},{2,0,0,1,0,182},{3,0,0,1,0,182},{4,0,0,1,0,182},{5,0,0,1,0,182},{6,0,0,1,0,182},{7,0,0,1,0,182},{8,1,0,1,0,182},{1,0,0,1,0,183},{2,0,0,1,0,183},{3,0,0,1,0,183},{4,0,0,1,0,183},{5,0,0,1,0,183},{6,0,0,1,0,183},{7,0,0,1,0,183},{8,1,0,1,0,183},{1,0,0,1,0,188},{2,0,0,1,0,188},{3,0,0,1,0,188},{4,0,0,1,0,188},{5,0,0,1,0,188},{6,0,0,1,0,188},{7,0,0,1,0,188},{8,1,0,1,0,188},{1,0,0,1,0,191},{2,0,0,1,0,191},{3,0,0,1,0,191},{4,0,0,1,0,191},{5,0,0,1,0,191},{6,0,0,1,0,191},{7,0,0,1,0,191},{8,1,0,1,0,191},{1,0,0,1,0,197},{2,0,0,1,0,197},{3,0,0,1,0,197},{4,0,0,1,0,197},{5,0,0,1,0,197},{6,0,0,1,0,197},{7,0,0,1,0,197},{8,1,0,1,0,197},{1,0,0,1,0,231},{2,0,0,1,0,231},{3,0,0,1,0,231},{4,0,0,1,0,231},{5,0,0,1,0,231},{6,0,0,1,0,231},{7,0,0,1,0,231},{8,1,0,1,0,231},{1,0,0,1,0,239},{2,0,0,1,0,239},{3,0,0,1,0,239},{4,0,0,1,0,239},{5,0,0,1,0,239},{6,0,0,1,0,239},{7,0,0,1,0,239},{8,1,0,1,0,239},{9,0,0,1,0,9},{10,0,0,1,0,9},{11,0,0,1,0,9},{12,1,0,1,0,9},{9,0,0,1,0,142},{10,0,0,1,0,142},{11,0,0,1,0,142},{12,1,0,1,0,142},{9,0,0,1,0,144},{10,0,0,1,0,144},{11,0,0,1,0,144},{12,1,0,1,0,144},{9,0,0,1,0,145},{10,0,0,1,0,145},{11,0,0,1,0,145},{12,1,0,1,0,145},{9,0,0,1,0,148},{10,0,0,1,0,148},{11,0,0,1,0,148},{12,1,0,1,0,148},{9,0,0,1,0,159},{10,0,0,1,0,159},{11,0,0,1,0,159},{12,1,0,1,0,159},{9,0,0,1,0,171},{10,0,0,1,0,171},{11,0,0,1,0,171},{12,1,0,1,0,171},{9,0,0,1,0,206},{10,0,0,1,0,206},{11,0,0,1,0,206},{12,1,0,1,0,206},{9,0,0,1,0,215},{10,0,0,1,0,215},{11,0,0,1,0,215},{12,1,0,1,0,215},{9,0,0,1,0,225},{10,0,0,1,0,225},{11,0,0,1,0,225},{12,1,0,1,0,225},{9,0,0,1,0,236},{10,0,0,1,0,236},{11,0,0,1,0,236},{12,1,0,1,0,236},{9,0,0,1,0,237},{10,0,0,1,0,237},{11,0,0,1,0,237},{12,1,0,1,0,237},{13,0,0,1,0,199},{14,1,0,1,0,199},{13,0,0,1,0,207},{14,1,0,1,0,207},{13,0,0,1,0,234},{14,1,0,1,0,234},{13,0,0,1,0,235},{14,1,0,1,0,235},{0,1,0,1,0,192},{0,1,0,1,0,193},{0,1,0,1,0,200},{0,1,0,1,0,201},{0,1,0,1,0,202},{0,1,0,1,0,205},{0,1,0,1,0,210},{0,1,0,1,0,213},{0,1,0,1,0,218},{0,1,0,1,0,219},{0,1,0,1,0,238},{0,1,0,1,0,240},{0,1,0,1,0,242},{0,1,0,1,0,243},{0,1,0,1,0,255},{209,0,0,0,0,0},{210,0,0,0,0,0},{211,0,0,0,0,0},{212,0,0,0,0,0},{213,0,0,0,0,0},{214,0,0,0,0,0},{215,0,0,0,0,0},{216,0,0,0,0,0},{217,0,0,0,0,0},{218,0,0,0,0,0},{219,0,0,0,0,0},{220,0,0,0,0,0},{221,0,0,0,0,0},{222,0,0,0,0,0},{223,0,0,0,0,0},{224,0,0,0,0,0},{225,0,0,0,0,0},{13,0,1,1,92,48},{14,1,1,1,92,48},{13,0,1,1,92,49},{14,1,1,1,92,49},{13,0,1,1,92,50},{14,1,1,1,92,50},{13,0,1,1,92,97},{14,1,1,1,92,97},{13,0,1,1,92,99},{14,1,1,1,92,99},{13,0,1,1,92,101},{14,1,1,1,92,101},{13,0,1,1,92,105},{14,1,1,1,92,105},{13,0,1,1,92,111},{14,1,1,1,92,111},{13,0,1,1,92,115},{14,1,1,1,92,115},{13,0,1,1,92,116},{14,1,1,1,92,116},{0,1,1,1,92,32},{0,1,1,1,92,37},{0,1,1,1,92,45},{0,1,1,1,92,46},{0,1,1,1,92,47},{0,1,1,1,92,51},{0,1,1,1,92,52},{0,1,1,1,92,53},{0,1,1,1,92,54},{0,1,1,1,92,55},{0,1,1,1,92,56},{0,1,1,1,92,57},{0,1,1,1,92,61},{0,1,1,1,92,65},{0,1,1,1,92,95},{0,1,1,1,92,98},{0,1,1,1,92,100},{0,1,1,1,92,102},{0,1,1,1,92,103},{0,1,1,1,92,104},{0,1,1,1,92,108},{0,1,1,1,92,109},{0,1,1,1,92,110},{0,1,1,1,92,112},{0,1,1,1,92,114},{0,1,1,1,92,117},{17,0,0,1,0,92},{18,0,0,1,0,92},{19,0,0,1,0,92},{20,0,0,1,0,92},{21,0,0,1,0,92},{22,0,0,1,0,92},{23,0,0,1,0,92},{24,0,0,1,0,92},{25,0,0,1,0,92},{26,0,0,1,0,92},{27,0,0,1,0,92},{28,0,0,1,0,92},{29,0,0,1,0,92},{30,0,0,1,0,92},{31,0,0,1,0,92},{32,0,0,1,0,92},{33,0,0,1,0,92},{34,1,0,1,0,92},{13,0,1,1,195,48},{14,1,1,1,195,48},{13,0,1,1,195,49},{14,1,1,1,195,49},{13,0,1,1,195,50},{14,1,1,1,195,50},{13,0,1,1,195,97},{14,1,1,1,195,97},{13,0,1,1,195,99},{14,1,1,1,195,99},{13,0,1,1,195,101},{14,1,1,1,195,101},{13,0,1,1,195,105},{14,1,1,1,195,105},{13,0,1,1,195,111},{14,1,1,1,195,111},{13,0,1,1,195,115},{14,1,1,1,195,115},{13,0,1,1,195,116},{14,1,1,1,195,116},{0,1,1,1,195,32},{0,1,1,1,195,37},{0,1,1,1,195,45},{0,1,1,1,195,46},{0,1,1,1,195,47},{0,1,1,1,195,51},{0,1,1,1,195,52},{0,1,1,1,195,53},{0,1,1,1,195,54},{0,1,1,1,195,55},{0,1,1,1,195,56},{0,1,1,1,195,57},{0,1,1,1,195,61},{0,1,1,1,195,65},{0,1,1,1,195,95},{0,1,1,1,195,98},{0,1,1,1,195,100},{0,1,1,1,195,102},{0,1,1,1,195,103},{0,1,1,1,195,104},{0,1,1,1,195,108},{0,1,1,1,195,109},{0,1,1,1,195,110},{0,1,1,1,195,112},{0,1,1,1,195,114},{0,1,1,1,195,117},{17,0,0,1,0,195},{18,0,0,1,0,195},{19,0,0,1,0,195},{20,0,0,1,0,195},{21,0,0,1,0,195},{22,0,0,1,0,195},{23,0,0,1,0,195},{24,0,0,1,0,195},{25,0,0,1,0,195},{26,0,0,1,0,195},{27,0,0,1,0,195},{28,0,0,1,0,195},{29,0,0,1,0,195},{30,0,0,1,0,195},{31,0,0,1,0,195},{32,0,0,1,0,195},{33,0,0,1,0,195},{34,1,0,1,0,195},{13,0,1,1,208,48},{14,1,1,1,208,48},{13,0,1,1,208,49},{14,1,1,1,208,49},{13,0,1,1,208,50},{14,1,1,1,208,50},{13,0,1,1,208,97},{14,1,1,1,208,97},{13,0,1,1,208,99},{14,1,1,1,208,99},{13,0,1,1,208,101},{14,1,1,1,208,101},{13,0,1,1,208,105},{14,1,1,1,208,105},{13,0,1,1,208,111},{14,1,1,1,208,111},{13,0,1,1,208,115},{14,1,1,1,208,115},{13,0,1,1,208,116},{14,1,1,1,208,116},{0,1,1,1,208,32},{0,1,1,1,208,37},{0,1,1,1,208,45},{0,1,1,1,208,46},{0,1,1,1,208,47},{0,1,1,1,208,51},{0,1,1,1,208,52},{0,1,1,1,208,53},{0,1,1,1,208,54},{0,1,1,1,208,55},{0,1,1,1,208,56},{0,1,1,1,208,57},{0,1,1,1,208,61},{0,1,1,1,208,65},{0,1,1,1,208,95},{0,1,1,1,208,98},{0,1,1,1,208,100},{0,1,1,1,208,102},{0,1,1,1,208,103},{0,1,1,1,208,104},{0,1,1,1,208,108},{0,1,1,1,208,109},{0,1,1,1,208,110},{0,1,1,1,208,112},{0,1,1,1,208,114},{0,1,1,1,208,117},{17,0,0,1,0,208},{18,0,0,1,0,208},{19,0,0,1,0,208},{20,0,0,1,0,208},{21,0,0,1,0,208},{22,0,0,1,0,208},{23,0,0,1,0,208},{24,0,0,1,0,208},{25,0,0,1,0,208},{26,0,0,1,0,208},{27,0,0,1,0,208},{28,0,0,1,0,208},{29,0,0,1,0,208},{30,0,0,1,0,208},{31,0,0,1,0,208},{32,0,0,1,0,208},{33,0,0,1,0,208},{34,1,0,1,0,208},{0,1,1,1,128,48},{0,1,1,1,128,49},{0,1,1,1,128,50},{0,1,1,1,128,97},{0,1,1,1,128,99},{0,1,1,1,128,101},{0,1,1,1,128,105},{0,1,1,1,128,111},{0,1,1,1,128,115},{0,1,1,1,128,116},{35,0,0,1,0,128},{36,0,0,1,0,128},{37,0,0,1,0,128},{38,0,0,1,0,128},{39,0,0,1,0,128},{40,0,0,1,0,128},{41,0,0,1,0,128},{42,0,0,1,0,128},{43,0,0,1,0,128},{44,0,0,1,0,128},{45,0,0,1,0,128},{46,0,0,1,0,128},{47,0,0,1,0,128},{48,0,0,1,0,128},{49,0,0,1,0,128},{50,0,0,1,0,128},{51,0,0,1,0,128},{52,0,0,1,0,128},{53,0,0,1,0,128},{54,0,0,1,0,128},{55,0,0,1,0,128},{56,1,0,1,0,128},{0,1,1,1,130,48},{0,1,1,1,130,49},{0,1,1,1,130,50},{0,1,1,1,130,97},{0,1,1,1,130,99},{0,1,1,1,130,101},{0,1,1,1,130,105},{0,1,1,1,130,111},{0,1,1,1,130,115},{0,1,1,1,130,116},{35,0,0,1,0,130},{36,0,0,1,0,130},{37,0,0,1,0,130},{38,0,0,1,0,130},{39,0,0,1,0,130},{40,0,0,1,0,130},{41,0,0,1,0,130},{42,0,0,1,0,130},{43,0,0,1,0,130},{44,0,0,1,0,130},{45,0,0,1,0,130},{46,0,0,1,0,130},{47,0,0,1,0,130},{48,0,0,1,0,130},{49,0,0,1,0,130},{50,0,0,1,0,130},{51,0,0,1,0,130},{52,0,0,1,0,130},{53,0,0,1,0,130},{54,0,0,1,0,130},{55,0,0,1,0,130},{56,1,0,1,0,130},{0,1,1,1,131,48},{0,1,1,1,131,49},{0,1,1,1,131,50},{0,1,1,1,131,97},{0,1,1,1,131,99},{0,1,1,1,131,101},{0,1,1,1,131,105},{0,1,1,1,131,111},{0,1,1,1,131,115},{0,1,1,1,131,116},{35,0,0,1,0,131},{36,0,0,1,0,131},{37,0,0,1,0,131},{38,0,0,1,0,131},{39,0,0,1,0,131},{40,0,0,1,0,131},{41,0,0,1,0,131},{42,0,0,1,0,131},{43,0,0,1,0,131},{44,0,0,1,0,131},{45,0,0,1,0,131},{46,0,0,1,0,131},{47,0,0,1,0,131},{48,0,0,1,0,131},{49,0,0,1,0,131},{50,0,0,1,0,131},{51,0,0,1,0,131},{52,0,0,1,0,131},{53,0,0,1,0,131},{54,0,0,1,0,131},{55,0,0,1,0,131},{56,1,0,1,0,131},{0,1,1,1,162,48},{0,1,1,1,162,49},{0,1,1,1,162,50},{0,1,1,1,162,97},{0,1,1,1,162,99},{0,1,1,1,162,101},{0,1,1,1,162,105},{0,1,1,1,162,111},{0,1,1,1,162,115},{0,1,1,1,162,116},{35,0,0,1,0,162},{36,0,0,1,0,162},{37,0,0,1,0,162},{38,0,0,1,0,162},{39,0,0,1,0,162},{40,0,0,1,0,162},{41,0,0,1,0,162},{42,0,0,1,0,162},{43,0,0,1,0,162},{44,0,0,1,0,162},{45,0,0,1,0,162},{46,0,0,1,0,162},{47,0,0,1,0,162},{48,0,0,1,0,162},{49,0,0,1,0,162},{50,0,0,1,0,162},{51,0,0,1,0,162},{52,0,0,1,0,162},{53,0,0,1,0,162},{54,0,0,1,0,162},{55,0,0,1,0,162},{56,1,0,1,0,162},{0,1,1,1,184,48},{0,1,1,1,184,49},{0,1,1,1,184,50},{0,1,1,1,184,97},{0,1,1,1,184,99},{0,1,1,1,184,101},{0,1,1,1,184,105},{0,1,1,1,184,111},{0,1,1,1,184,115},{0,1,1,1,184,116},{35,0,0,1,0,184},{36,0,0,1,0,184},{37,0,0,1,0,184},{38,0,0,1,0,184},{39,0,0,1,0,184},{40,0,0,1,0,184},{41,0,0,1,0,184},{42,0,0,1,0,184},{43,0,0,1,0,184},{44,0,0,1,0,184},{45,0,0,1,0,184},{46,0,0,1,0,184},{47,0,0,1,0,184},{48,0,0,1,0,184},{49,0,0,1,0,184},{50,0,0,1,0,184},{51,0,0,1,0,184},{52,0,0,1,0,184},{53,0,0,1,0,184},{54,0,0,1,0,184},{55,0,0,1,0,184},{56,1,0,1,0,184},{0,1,1,1,194,48},{0,1,1,1,194,49},{0,1,1,1,194,50},{0,1,1,1,194,97},{0,1,1,1,194,99},{0,1,1,1,194,101},{0,1,1,1,194,105},{0,1,1,1,194,111},{0,1,1,1,194,115},{0,1,1,1,194,116},{35,0,0,1,0,194},{36,0,0,1,0,194},{37,0,0,1,0,194},{38,0,0,1,0,194},{39,0,0,1,0,194},{40,0,0,1,0,194},{41,0,0,1,0,194},{42,0,0,1,0,194},{43,0,0,1,0,194},{44,0,0,1,0,194},{45,0,0,1,0,194},{46,0,0,1,0,194},{47,0,0,1,0,194},{48,0,0,1,0,194},{49,0,0,1,0,194},{50,0,0,1,0,194},{51,0,0,1,0,194},{52,0,0,1,0,194},{53,0,0,1,0,194},{54,0,0,1,0,194},{55,0,0,1,0,194},{56,1,0,1,0,194},{0,1,1,1,224,48},{0,1,1,1,224,49},{0,1,1,1,224,50},{0,1,1,1,224,97},{0,1,1,1,224,99},{0,1,1,1,224,101},{0,1,1,1,224,105},{0,1,1,1,224,111},{0,1,1,1,224,115},{0,1,1,1,224,116},{35,0,0,1,0,224},{36,0,0,1,0,224},{37,0,0,1,0,224},{38,0,0,1,0,224},{39,0,0,1,0,224},{40,0,0,1,0,224},{41,0,0,1,0,224},{42,0,0,1,0,224},{43,0,0,1,0,224},{44,0,0,1,0,224},{45,0,0,1,0,224},{46,0,0,1,0,224},{47,0,0,1,0,224},{48,0,0,1,0,224},{49,0,0,1,0,224},{50,0,0,1,0,224},{51,0,0,1,0,224},{52,0,0,1,0,224},{53,0,0,1,0,224},{54,0,0,1,0,224},{55,0,0,1,0,224},{56,1,0,1,0,224},{0,1,1,1,226,48},{0,1,1,1,226,49},{0,1,1,1,226,50},{0,1,1,1,226,97},{0,1,1,1,226,99},{0,1,1,1,226,101},{0,1,1,1,226,105},{0,1,1,1,226,111},{0,1,1,1,226,115},{0,1,1,1,226,116},{35,0,0,1,0,226},{36,0,0,1,0,226},{37,0,0,1,0,226},{38,0,0,1,0,226},{39,0,0,1,0,226},{40,0,0,1,0,226},{41,0,0,1,0,226},{42,0,0,1,0,226},{43,0,0,1,0,226},{44,0,0,1,0,226},{45,0,0,1,0,226},{46,0,0,1,0,226},{47,0,0,1,0,226},{48,0,0,1,0,226},{49,0,0,1,0,226},{50,0,0,1,0,226},{51,0,0,1,0,226},{52,0,0,1,0,226},{53,0,0,1,0,226},{54,0,0,1,0,226},{55,0,0,1,0,226},{56,1,0,1,0,226},{57,0,0,1,0,153},{58,0,0,1,0,153},{59,0,0,1,0,153},{60,0,0,1,0,153},{61,0,0,1,0,153},{62,0,0,1,0,153},{63,0,0,1,0,153},{64,0,0,1,0,153},{65,0,0,1,0,153},{66,0,0,1,0,153},{67,0,0,1,0,153},{68,0,0,1,0,153},{69,0,0,1,0,153},{70,0,0,1,0,153},{71,0,0,1,0,153},{72,1,0,1,0,153},{57,0,0,1,0,161},{58,0,0,1,0,161},{59,0,0,1,0,161},{60,0,0,1,0,161},{61,0,0,1,0,161},{62,0,0,1,0,161},{63,0,0,1,0,161},{64,0,0,1,0,161},{65,0,0,1,0,161},{66,0,0,1,0,161},{67,0,0,1,0,161},{68,0,0,1,0,161},{69,0,0,1,0,161},{70,0,0,1,0,161},{71,0,0,1,0,161},{72,1,0,1,0,161},{57,0,0,1,0,167},{58,0,0,1,0,167},{59,0,0,1,0,167},{60,0,0,1,0,167},{61,0,0,1,0,167},{62,0,0,1,0,167},{63,0,0,1,0,167},{64,0,0,1,0,167},{65,0,0,1,0,167},{66,0,0,1,0,167},{67,0,0,1,0,167},{68,0,0,1,0,167},{69,0,0,1,0,167},{70,0,0,1,0,167},{71,0,0,1,0,167},{72,1,0,1,0,167},{57,0,0,1,0,172},{58,0,0,1,0,172},{59,0,0,1,0,172},{60,0,0,1,0,172},{61,0,0,1,0,172},{62,0,0,1,0,172},{63,0,0,1,0,172},{64,0,0,1,0,172},{65,0,0,1,0,172},{66,0,0,1,0,172},{67,0,0,1,0,172},{68,0,0,1,0,172},{69,0,0,1,0,172},{70,0,0,1,0,172},{71,0,0,1,0,172},{72,1,0,1,0,172},{57,0,0,1,0,176},{58,0,0,1,0,176},{59,0,0,1,0,176},{60,0,0,1,0,176},{61,0,0,1,0,176},{62,0,0,1,0,176},{63,0,0,1,0,176},{64,0,0,1,0,176},{65,0,0,1,0,176},{66,0,0,1,0,176},{67,0,0,1,0,176},{68,0,0,1,0,176},{69,0,0,1,0,176},{70,0,0,1,0,176},{71,0,0,1,0,176},{72,1,0,1,0,176},{57,0,0,1,0,177},{58,0,0,1,0,177},{59,0,0,1,0,177},{60,0,0,1,0,177},{61,0,0,1,0,177},{62,0,0,1,0,177},{63,0,0,1,0,177},{64,0,0,1,0,177},{65,0,0,1,0,177},{66,0,0,1,0,177},{67,0,0,1,0,177},{68,0,0,1,0,177},{69,0,0,1,0,177},{70,0,0,1,0,177},{71,0,0,1,0,177},{72,1,0,1,0,177},{57,0,0,1,0,179},{58,0,0,1,0,179},{59,0,0,1,0,179},{60,0,0,1,0,179},{61,0,0,1,0,179},{62,0,0,1,0,179},{63,0,0,1,0,179},{64,0,0,1,0,179},{65,0,0,1,0,179},{66,0,0,1,0,179},{67,0,0,1,0,179},{68,0,0,1,0,179},{69,0,0,1,0,179},{70,0,0,1,0,179},{71,0,0,1,0,179},{72,1,0,1,0,179},{57,0,0,1,0,209},{58,0,0,1,0,209},{59,0,0,1,0,209},{60,0,0,1,0,209},{61,0,0,1,0,209},{62,0,0,1,0,209},{63,0,0,1,0,209},{64,0,0,1,0,209},{65,0,0,1,0,209},{66,0,0,1,0,209},{67,0,0,1,0,209},{68,0,0,1,0,209},{69,0,0,1,0,209},{70,0,0,1,0,209},{71,0,0,1,0,209},{72,1,0,1,0,209},{57,0,0,1,0,216},{58,0,0,1,0,216},{59,0,0,1,0,216},{60,0,0,1,0,216},{61,0,0,1,0,216},{62,0,0,1,0,216},{63,0,0,1,0,216},{64,0,0,1,0,216},{65,0,0,1,0,216},{66,0,0,1,0,216},{67,0,0,1,0,216},{68,0,0,1,0,216},{69,0,0,1,0,216},{70,0,0,1,0,216},{71,0,0,1,0,216},{72,1,0,1,0,216},{57,0,0,1,0,217},{58,0,0,1,0,217},{59,0,0,1,0,217},{60,0,0,1,0,217},{61,0,0,1,0,217},{62,0,0,1,0,217},{63,0,0,1,0,217},{64,0,0,1,0,217},{65,0,0,1,0,217},{66,0,0,1,0,217},{67,0,0,1,0,217},{68,0,0,1,0,217},{69,0,0,1,0,217},{70,0,0,1,0,217},{71,0,0,1,0,217},{72,1,0,1,0,217},{57,0,0,1,0,227},{58,0,0,1,0,227},{59,0,0,1,0,227},{60,0,0,1,0,227},{61,0,0,1,0,227},{62,0,0,1,0,227},{63,0,0,1,0,227},{64,0,0,1,0,227},{65,0,0,1,0,227},{66,0,0,1,0,227},{67,0,0,1,0,227},{68,0,0,1,0,227},{69,0,0,1,0,227},{70,0,0,1,0,227},{71,0,0,1,0,227},{72,1,0,1,0,227},{57,0,0,1,0,229},{58,0,0,1,0,229},{59,0,0,1,0,229},{60,0,0,1,0,229},{61,0,0,1,0,229},{62,0,0,1,0,229},{63,0,0,1,0,229},{64,0,0,1,0,229},{65,0,0,1,0,229},{66,0,0,1,0,229},{67,0,0,1,0,229},{68,0,0,1,0,229},{69,0,0,1,0,229},{70,0,0,1,0,229},{71,0,0,1,0,229},{72,1,0,1,0,229},{57,0,0,1,0,230},{58,0,0,1,0,230},{59,0,0,1,0,230},{60,0,0,1,0,230},{61,0,0,1,0,230},{62,0,0,1,0,230},{63,0,0,1,0,230},{64,0,0,1,0,230},{65,0,0,1,0,230},{66,0,0,1,0,230},{67,0,0,1,0,230},{68,0,0,1,0,230},{69,0,0,1,0,230},{70,0,0,1,0,230},{71,0,0,1,0,230},{72,1,0,1,0,230},{1,0,0,1,0,129},{2,0,0,1,0,129},{3,0,0,1,0,129},{4,0,0,1,0,129},{5,0,0,1,0,129},{6,0,0,1,0,129},{7,0,0,1,0,129},{8,1,0,1,0,129},{1,0,0,1,0,132},{2,0,0,1,0,132},{3,0,0,1,0,132},{4,0,0,1,0,132},{5,0,0,1,0,132},{6,0,0,1,0,132},{7,0,0,1,0,132},{8,1,0,1,0,132},{1,0,0,1,0,133},{2,0,0,1,0,133},{3,0,0,1,0,133},{4,0,0,1,0,133},{5,0,0,1,0,133},{6,0,0,1,0,133},{7,0,0,1,0,133},{8,1,0,1,0,133},{1,0,0,1,0,134},{2,0,0,1,0,134},{3,0,0,1,0,134},{4,0,0,1,0,134},{5,0,0,1,0,134},{6,0,0,1,0,134},{7,0,0,1,0,134},{8,1,0,1,0,134},{1,0,0,1,0,136},{2,0,0,1,0,136},{3,0,0,1,0,136},{4,0,0,1,0,136},{5,0,0,1,0,136},{6,0,0,1,0,136},{7,0,0,1,0,136},{8,1,0,1,0,136},{1,0,0,1,0,146},{2,0,0,1,0,146},{3,0,0,1,0,146},{4,0,0,1,0,146},{5,0,0,1,0,146},{6,0,0,1,0,146},{7,0,0,1,0,146},{8,1,0,1,0,146},{1,0,0,1,0,154},{2,0,0,1,0,154},{3,0,0,1,0,154},{4,0,0,1,0,154},{5,0,0,1,0,154},{6,0,0,1,0,154},{7,0,0,1,0,154},{8,1,0,1,0,154},{1,0,0,1,0,156},{2,0,0,1,0,156},{3,0,0,1,0,156},{4,0,0,1,0,156},{5,0,0,1,0,156},{6,0,0,1,0,156},{7,0,0,1,0,156},{8,1,0,1,0,156},{1,0,0,1,0,160},{2,0,0,1,0,160},{3,0,0,1,0,160},{4,0,0,1,0,160},{5,0,0,1,0,160},{6,0,0,1,0,160},{7,0,0,1,0,160},{8,1,0,1,0,160},{1,0,0,1,0,163},{2,0,0,1,0,163},{3,0,0,1,0,163},{4,0,0,1,0,163},{5,0,0,1,0,163},{6,0,0,1,0,163},{7,0,0,1,0,163},{8,1,0,1,0,163},{1,0,0,1,0,164},{2,0,0,1,0,164},{3,0,0,1,0,164},{4,0,0,1,0,164},{5,0,0,1,0,164},{6,0,0,1,0,164},{7,0,0,1,0,164},{8,1,0,1,0,164},{1,0,0,1,0,169},{2,0,0,1,0,169},{3,0,0,1,0,169},{4,0,0,1,0,169},{5,0,0,1,0,169},{6,0,0,1,0,169},{7,0,0,1,0,169},{8,1,0,1,0,169},{1,0,0,1,0,170},{2,0,0,1,0,170},{3,0,0,1,0,170},{4,0,0,1,0,170},{5,0,0,1,0,170},{6,0,0,1,0,170},{7,0,0,1,0,170},{8,1,0,1,0,170},{1,0,0,1,0,173},{2,0,0,1,0,173},{3,0,0,1,0,173},{4,0,0,1,0,173},{5,0,0,1,0,173},{6,0,0,1,0,173},{7,0,0,1,0,173},{8,1,0,1,0,173},{1,0,0,1,0,178},{2,0,0,1,0,178},{3,0,0,1,0,178},{4,0,0,1,0,178},{5,0,0,1,0,178},{6,0,0,1,0,178},{7,0,0,1,0,178},{8,1,0,1,0,178},{1,0,0,1,0,181},{2,0,0,1,0,181},{3,0,0,1,0,181},{4,0,0,1,0,181},{5,0,0,1,0,181},{6,0,0,1,0,181},{7,0,0,1,0,181},{8,1,0,1,0,181},{1,0,0,1,0,185},{2,0,0,1,0,185},{3,0,0,1,0,185},{4,0,0,1,0,185},{5,0,0,1,0,185},{6,0,0,1,0,185},{7,0,0,1,0,185},{8,1,0,1,0,185},{1,0,0,1,0,186},{2,0,0,1,0,186},{3,0,0,1,0,186},{4,0,0,1,0,186},{5,0,0,1,0,186},{6,0,0,1,0,186},{7,0,0,1,0,186},{8,1,0,1,0,186},{1,0,0,1,0,187},{2,0,0,1,0,187},{3,0,0,1,0,187},{4,0,0,1,0,187},{5,0,0,1,0,187},{6,0,0,1,0,187},{7,0,0,1,0,187},{8,1,0,1,0,187},{1,0,0,1,0,189},{2,0,0,1,0,189},{3,0,0,1,0,189},{4,0,0,1,0,189},{5,0,0,1,0,189},{6,0,0,1,0,189},{7,0,0,1,0,189},{8,1,0,1,0,189},{1,0,0,1,0,190},{2,0,0,1,0,190},{3,0,0,1,0,190},{4,0,0,1,0,190},{5,0,0,1,0,190},{6,0,0,1,0,190},{7,0,0,1,0,190},{8,1,0,1,0,190},{1,0,0,1,0,196},{2,0,0,1,0,196},{3,0,0,1,0,196},{4,0,0,1,0,196},{5,0,0,1,0,196},{6,0,0,1,0,196},{7,0,0,1,0,196},{8,1,0,1,0,196},{1,0,0,1,0,198},{2,0,0,1,0,198},{3,0,0,1,0,198},{4,0,0,1,0,198},{5,0,0,1,0,198},{6,0,0,1,0,198},{7,0,0,1,0,198},{8,1,0,1,0,198},{1,0,0,1,0,228},{2,0,0,1,0,228},{3,0,0,1,0,228},{4,0,0,1,0,228},{5,0,0,1,0,228},{6,0,0,1,0,228},{7,0,0,1,0,228},{8,1,0,1,0,228},{1,0,0,1,0,232},{2,0,0,1,0,232},{3,0,0,1,0,232},{4,0,0,1,0,232},{5,0,0,1,0,232},{6,0,0,1,0,232},{7,0,0,1,0,232},{8,1,0,1,0,232},{1,0,0,1,0,233},{2,0,0,1,0,233},{3,0,0,1,0,233},{4,0,0,1,0,233},{5,0,0,1,0,233},{6,0,0,1,0,233},{7,0,0,1,0,233},{8,1,0,1,0,233},{9,0,0,1,0,1},{10,0,0,1,0,1},{11,0,0,1,0,1},{12,1,0,1,0,1},{9,0,0,1,0,135},{10,0,0,1,0,135},{11,0,0,1,0,135},{12,1,0,1,0,135},{9,0,0,1,0,137},{10,0,0,1,0,137},{11,0,0,1,0,137},{12,1,0,1,0,137},{9,0,0,1,0,138},{10,0,0,1,0,138},{11,0,0,1,0,138},{12,1,0,1,0,138},{9,0,0,1,0,139},{10,0,0,1,0,139},{11,0,0,1,0,139},{12,1,0,1,0,139},{9,0,0,1,0,140},{10,0,0,1,0,140},{11,0,0,1,0,140},{12,1,0,1,0,140},{9,0,0,1,0,141},{10,0,0,1,0,141},{11,0,0,1,0,141},{12,1,0,1,0,141},{9,0,0,1,0,143},{10,0,0,1,0,143},{11,0,0,1,0,143},{12,1,0,1,0,143},{9,0,0,1,0,147},{10,0,0,1,0,147},{11,0,0,1,0,147},{12,1,0,1,0,147},{9,0,0,1,0,149},{10,0,0,1,0,149},{11,0,0,1,0,149},{12,1,0,1,0,149},{9,0,0,1,0,150},{10,0,0,1,0,150},{11,0,0,1,0,150},{12,1,0,1,0,150},{9,0,0,1,0,151},{10,0,0,1,0,151},{11,0,0,1,0,151},{12,1,0,1,0,151},{9,0,0,1,0,152},{10,0,0,1,0,152},{11,0,0,1,0,152},{12,1,0,1,0,152},{9,0,0,1,0,155},{10,0,0,1,0,155},{11,0,0,1,0,155},{12,1,0,1,0,155},{9,0,0,1,0,157},{10,0,0,1,0,157},{11,0,0,1,0,157},{12,1,0,1,0,157},{9,0,0,1,0,158},{10,0,0,1,0,158},{11,0,0,1,0,158},{12,1,0,1,0,158},{9,0,0,1,0,165},{10,0,0,1,0,165},{11,0,0,1,0,165},{12,1,0,1,0,165},{9,0,0,1,0,166},{10,0,0,1,0,166},{11,0,0,1,0,166},{12,1,0,1,0,166},{9,0,0,1,0,168},{10,0,0,1,0,168},{11,0,0,1,0,168},{12,1,0,1,0,168},{9,0,0,1,0,174},{10,0,0,1,0,174},{11,0,0,1,0,174},{12,1,0,1,0,174},{9,0,0,1,0,175},{10,0,0,1,0,175},{11,0,0,1,0,175},{12,1,0,1,0,175},{9,0,0,1,0,180},{10,0,0,1,0,180},{11,0,0,1,0,180},{12,1,0,1,0,180},{9,0,0,1,0,182},{10,0,0,1,0,182},{11,0,0,1,0,182},{12,1,0,1,0,182},{9,0,0,1,0,183},{10,0,0,1,0,183},{11,0,0,1,0,183},{12,1,0,1,0,183},{9,0,0,1,0,188},{10,0,0,1,0,188},{11,0,0,1,0,188},{12,1,0,1,0,188},{9,0,0,1,0,191},{10,0,0,1,0,191},{11,0,0,1,0,191},{12,1,0,1,0,191},{9,0,0,1,0,197},{10,0,0,1,0,197},{11,0,0,1,0,197},{12,1,0,1,0,197},{9,0,0,1,0,231},{10,0,0,1,0,231},{11,0,0,1,0,231},{12,1,0,1,0,231},{9,0,0,1,0,239},{10,0,0,1,0,239},{11,0,0,1,0,239},{12,1,0,1,0,239},{13,0,0,1,0,9},{14,1,0,1,0,9},{13,0,0,1,0,142},{14,1,0,1,0,142},{13,0,0,1,0,144},{14,1,0,1,0,144},{13,0,0,1,0,145},{14,1,0,1,0,145},{13,0,0,1,0,148},{14,1,0,1,0,148},{13,0,0,1,0,159},{14,1,0,1,0,159},{13,0,0,1,0,171},{14,1,0,1,0,171},{13,0,0,1,0,206},{14,1,0,1,0,206},{13,0,0,1,0,215},{14,1,0,1,0,215},{13,0,0,1,0,225},{14,1,0,1,0,225},{13,0,0,1,0,236},{14,1,0,1,0,236},{13,0,0,1,0,237},{14,1,0,1,0,237},{0,1,0,1,0,199},{0,1,0,1,0,207},{0,1,0,1,0,234},{0,1,0,1,0,235},{226,0,0,0,0,0},{227,0,0,0,0,0},{228,0,0,0,0,0},{229,0,0,0,0,0},{230,0,0,0,0,0},{231,0,0,0,0,0},{232,0,0,0,0,0},{233,0,0,0,0,0},{234,0,0,0,0,0},{235,0,0,0,0,0},{236,0,0,0,0,0},{237,0,0,0,0,0},{238,0,0,0,0,0},{239,0,0,0,0,0},{240,0,0,0,0,0},{241,0,0,0,0,0},{9,0,1,1,199,48},{10,0,1,1,199,48},{11,0,1,1,199,48},{12,1,1,1,199,48},{9,0,1,1,199,49},{10,0,1,1,199,49},{11,0,1,1,199,49},{12,1,1,1,199,49},{9,0,1,1,199,50},{10,0,1,1,199,50},{11,0,1,1,199,50},{12,1,1,1,199,50},{9,0,1,1,199,97},{10,0,1,1,199,97},{11,0,1,1,199,97},{12,1,1,1,199,97},{9,0,1,1,199,99},{10,0,1,1,199,99},{11,0,1,1,199,99},{12,1,1,1,199,99},{9,0,1,1,199,101},{10,0,1,1,199,101},{11,0,1,1,199,101},{12,1,1,1,199,101},{9,0,1,1,199,105},{10,0,1,1,199,105},{11,0,1,1,199,105},{12,1,1,1,199,105},{9,0,1,1,199,111},{10,0,1,1,199,111},{11,0,1,1,199,111},{12,1,1,1,199,111},{9,0,1,1,199,115},{10,0,1,1,199,115},{11,0,1,1,199,115},{12,1,1,1,199,115},{9,0,1,1,199,116},{10,0,1,1,199,116},{11,0,1,1,199,116},{12,1,1,1,199,116},{13,0,1,1,199,32},{14,1,1,1,199,32},{13,0,1,1,199,37},{14,1,1,1,199,37},{13,0,1,1,199,45},{14,1,1,1,199,45},{13,0,1,1,199,46},{14,1,1,1,199,46},{13,0,1,1,199,47},{14,1,1,1,199,47},{13,0,1,1,199,51},{14,1,1,1,199,51},{13,0,1,1,199,52},{14,1,1,1,199,52},{13,0,1,1,199,53},{14,1,1,1,199,53},{13,0,1,1,199,54},{14,1,1,1,199,54},{13,0,1,1,199,55},{14,1,1,1,199,55},{13,0,1,1,199,56},{14,1,1,1,199,56},{13,0,1,1,199,57},{14,1,1,1,199,57},{13,0,1,1,199,61},{14,1,1,1,199,61},{13,0,1,1,199,65},{14,1,1,1,199,65},{13,0,1,1,199,95},{14,1,1,1,199,95},{13,0,1,1,199,98},{14,1,1,1,199,98},{13,0,1,1,199,100},{14,1,1,1,199,100},{13,0,1,1,199,102},{14,1,1,1,199,102},{13,0,1,1,199,103},{14,1,1,1,199,103},{13,0,1,1,199,104},{14,1,1,1,199,104},{13,0,1,1,199,108},{14,1,1,1,199,108},{13,0,1,1,199,109},{14,1,1,1,199,109},{13,0,1,1,199,110},{14,1,1,1,199,110},{13,0,1,1,199,112},{14,1,1,1,199,112},{13,0,1,1,199,114},{14,1,1,1,199,114},{13,0,1,1,199,117},{14,1,1,1,199,117},{0,1,1,1,199,58},{0,1,1,1,199,66},{0,1,1,1,199,67},{0,1,1,1,199,68},{0,1,1,1,199,69},{0,1,1,1,199,70},{0,1,1,1,199,71},{0,1,1,1,199,72},{0,1,1,1,199,73},{0,1,1,1,199,74},{0,1,1,1,199,75},{0,1,1,1,199,76},{0,1,1,1,199,77},{0,1,1,1,199,78},{0,1,1,1,199,79},{0,1,1,1,199,80},{0,1,1,1,199,81},{0,1,1,1,199,82},{0,1,1,1,199,83},{0,1,1,1,199,84},{0,1,1,1,199,85},{0,1,1,1,199,86},{0,1,1,1,199,87},{0,1,1,1,199,89},{0,1,1,1,199,106},{0,1,1,1,199,107},{0,1,1,1,199,113},{0,1,1,1,199,118},{0,1,1,1,199,119},{0,1,1,1,199,120},{0,1,1,1,199,121},{0,1,1,1,199,122},{85,0,0,1,0,199},{86,0,0,1,0,199},{87,0,0,1,0,199},{88,1,0,1,0,199},{9,0,1,1,207,48},{10,0,1,1,207,48},{11,0,1,1,207,48},{12,1,1,1,207,48},{9,0,1,1,207,49},{10,0,1,1,207,49},{11,0,1,1,207,49},{12,1,1,1,207,49},{9,0,1,1,207,50},{10,0,1,1,207,50},{11,0,1,1,207,50},{12,1,1,1,207,50},{9,0,1,1,207,97},{10,0,1,1,207,97},{11,0,1,1,207,97},{12,1,1,1,207,97},{9,0,1,1,207,99},{10,0,1,1,207,99},{11,0,1,1,207,99},{12,1,1,1,207,99},{9,0,1,1,207,101},{10,0,1,1,207,101},{11,0,1,1,207,101},{12,1,1,1,207,101},{9,0,1,1,207,105},{10,0,1,1,207,105},{11,0,1,1,207,105},{12,1,1,1,207,105},{9,0,1,1,207,111},{10,0,1,1,207,111},{11,0,1,1,207,111},{12,1,1,1,207,111},{9,0,1,1,207,115},{10,0,1,1,207,115},{11,0,1,1,207,115},{12,1,1,1,207,115},{9,0,1,1,207,116},{10,0,1,1,207,116},{11,0,1,1,207,116},{12,1,1,1,207,116},{13,0,1,1,207,32},{14,1,1,1,207,32},{13,0,1,1,207,37},{14,1,1,1,207,37},{13,0,1,1,207,45},{14,1,1,1,207,45},{13,0,1,1,207,46},{14,1,1,1,207,46},{13,0,1,1,207,47},{14,1,1,1,207,47},{13,0,1,1,207,51},{14,1,1,1,207,51},{13,0,1,1,207,52},{14,1,1,1,207,52},{13,0,1,1,207,53},{14,1,1,1,207,53},{13,0,1,1,207,54},{14,1,1,1,207,54},{13,0,1,1,207,55},{14,1,1,1,207,55},{13,0,1,1,207,56},{14,1,1,1,207,56},{13,0,1,1,207,57},{14,1,1,1,207,57},{13,0,1,1,207,61},{14,1,1,1,207,61},{13,0,1,1,207,65},{14,1,1,1,207,65},{13,0,1,1,207,95},{14,1,1,1,207,95},{13,0,1,1,207,98},{14,1,1,1,207,98},{13,0,1,1,207,100},{14,1,1,1,207,100},{13,0,1,1,207,102},{14,1,1,1,207,102},{13,0,1,1,207,103},{14,1,1,1,207,103},{13,0,1,1,207,104},{14,1,1,1,207,104},{13,0,1,1,207,108},{14,1,1,1,207,108},{13,0,1,1,207,109},{14,1,1,1,207,109},{13,0,1,1,207,110},{14,1,1,1,207,110},{13,0,1,1,207,112},{14,1,1,1,207,112},{13,0,1,1,207,114},{14,1,1,1,207,114},{13,0,1,1,207,117},{14,1,1,1,207,117},{0,1,1,1,207,58},{0,1,1,1,207,66},{0,1,1,1,207,67},{0,1,1,1,207,68},{0,1,1,1,207,69},{0,1,1,1,207,70},{0,1,1,1,207,71},{0,1,1,1,207,72},{0,1,1,1,207,73},{0,1,1,1,207,74},{0,1,1,1,207,75},{0,1,1,1,207,76},{0,1,1,1,207,77},{0,1,1,1,207,78},{0,1,1,1,207,79},{0,1,1,1,207,80},{0,1,1,1,207,81},{0,1,1,1,207,82},{0,1,1,1,207,83},{0,1,1,1,207,84},{0,1,1,1,207,85},{0,1,1,1,207,86},{0,1,1,1,207,87},{0,1,1,1,207,89},{0,1,1,1,207,106},{0,1,1,1,207,107},{0,1,1,1,207,113},{0,1,1,1,207,118},{0,1,1,1,207,119},{0,1,1,1,207,120},{0,1,1,1,207,121},{0,1,1,1,207,122},{85,0,0,1,0,207},{86,0,0,1,0,207},{87,0,0,1,0,207},{88,1,0,1,0,207},{9,0,1,1,234,48},{10,0,1,1,234,48},{11,0,1,1,234,48},{12,1,1,1,234,48},{9,0,1,1,234,49},{10,0,1,1,234,49},{11,0,1,1,234,49},{12,1,1,1,234,49},{9,0,1,1,234,50},{10,0,1,1,234,50},{11,0,1,1,234,50},{12,1,1,1,234,50},{9,0,1,1,234,97},{10,0,1,1,234,97},{11,0,1,1,234,97},{12,1,1,1,234,97},{9,0,1,1,234,99},{10,0,1,1,234,99},{11,0,1,1,234,99},{12,1,1,1,234,99},{9,0,1,1,234,101},{10,0,1,1,234,101},{11,0,1,1,234,101},{12,1,1,1,234,101},{9,0,1,1,234,105},{10,0,1,1,234,105},{11,0,1,1,234,105},{12,1,1,1,234,105},{9,0,1,1,234,111},{10,0,1,1,234,111},{11,0,1,1,234,111},{12,1,1,1,234,111},{9,0,1,1,234,115},{10,0,1,1,234,115},{11,0,1,1,234,115},{12,1,1,1,234,115},{9,0,1,1,234,116},{10,0,1,1,234,116},{11,0,1,1,234,116},{12,1,1,1,234,116},{13,0,1,1,234,32},{14,1,1,1,234,32},{13,0,1,1,234,37},{14,1,1,1,234,37},{13,0,1,1,234,45},{14,1,1,1,234,45},{13,0,1,1,234,46},{14,1,1,1,234,46},{13,0,1,1,234,47},{14,1,1,1,234,47},{13,0,1,1,234,51},{14,1,1,1,234,51},{13,0,1,1,234,52},{14,1,1,1,234,52},{13,0,1,1,234,53},{14,1,1,1,234,53},{13,0,1,1,234,54},{14,1,1,1,234,54},{13,0,1,1,234,55},{14,1,1,1,234,55},{13,0,1,1,234,56},{14,1,1,1,234,56},{13,0,1,1,234,57},{14,1,1,1,234,57},{13,0,1,1,234,61},{14,1,1,1,234,61},{13,0,1,1,234,65},{14,1,1,1,234,65},{13,0,1,1,234,95},{14,1,1,1,234,95},{13,0,1,1,234,98},{14,1,1,1,234,98},{13,0,1,1,234,100},{14,1,1,1,234,100},{13,0,1,1,234,102},{14,1,1,1,234,102},{13,0,1,1,234,103},{14,1,1,1,234,103},{13,0,1,1,234,104},{14,1,1,1,234,104},{13,0,1,1,234,108},{14,1,1,1,234,108},{13,0,1,1,234,109},{14,1,1,1,234,109},{13,0,1,1,234,110},{14,1,1,1,234,110},{13,0,1,1,234,112},{14,1,1,1,234,112},{13,0,1,1,234,114},{14,1,1,1,234,114},{13,0,1,1,234,117},{14,1,1,1,234,117},{0,1,1,1,234,58},{0,1,1,1,234,66},{0,1,1,1,234,67},{0,1,1,1,234,68},{0,1,1,1,234,69},{0,1,1,1,234,70},{0,1,1,1,234,71},{0,1,1,1,234,72},{0,1,1,1,234,73},{0,1,1,1,234,74},{0,1,1,1,234,75},{0,1,1,1,234,76},{0,1,1,1,234,77},{0,1,1,1,234,78},{0,1,1,1,234,79},{0,1,1,1,234,80},{0,1,1,1,234,81},{0,1,1,1,234,82},{0,1,1,1,234,83},{0,1,1,1,234,84},{0,1,1,1,234,85},{0,1,1,1,234,86},{0,1,1,1,234,87},{0,1,1,1,234,89},{0,1,1,1,234,106},{0,1,1,1,234,107},{0,1,1,1,234,113},{0,1,1,1,234,118},{0,1,1,1,234,119},{0,1,1,1,234,120},{0,1,1,1,234,121},{0,1,1,1,234,122},{85,0,0,1,0,234},{86,0,0,1,0,234},{87,0,0,1,0,234},{88,1,0,1,0,234},{9,0,1,1,235,48},{10,0,1,1,235,48},{11,0,1,1,235,48},{12,1,1,1,235,48},{9,0,1,1,235,49},{10,0,1,1,235,49},{11,0,1,1,235,49},{12,1,1,1,235,49},{9,0,1,1,235,50},{10,0,1,1,235,50},{11,0,1,1,235,50},{12,1,1,1,235,50},{9,0,1,1,235,97},{10,0,1,1,235,97},{11,0,1,1,235,97},{12,1,1,1,235,97},{9,0,1,1,235,99},{10,0,1,1,235,99},{11,0,1,1,235,99},{12,1,1,1,235,99},{9,0,1,1,235,101},{10,0,1,1,235,101},{11,0,1,1,235,101},{12,1,1,1,235,101},{9,0,1,1,235,105},{10,0,1,1,235,105},{11,0,1,1,235,105},{12,1,1,1,235,105},{9,0,1,1,235,111},{10,0,1,1,235,111},{11,0,1,1,235,111},{12,1,1,1,235,111},{9,0,1,1,235,115},{10,0,1,1,235,115},{11,0,1,1,235,115},{12,1,1,1,235,115},{9,0,1,1,235,116},{10,0,1,1,235,116},{11,0,1,1,235,116},{12,1,1,1,235,116},{13,0,1,1,235,32},{14,1,1,1,235,32},{13,0,1,1,235,37},{14,1,1,1,235,37},{13,0,1,1,235,45},{14,1,1,1,235,45},{13,0,1,1,235,46},{14,1,1,1,235,46},{13,0,1,1,235,47},{14,1,1,1,235,47},{13,0,1,1,235,51},{14,1,1,1,235,51},{13,0,1,1,235,52},{14,1,1,1,235,52},{13,0,1,1,235,53},{14,1,1,1,235,53},{13,0,1,1,235,54},{14,1,1,1,235,54},{13,0,1,1,235,55},{14,1,1,1,235,55},{13,0,1,1,235,56},{14,1,1,1,235,56},{13,0,1,1,235,57},{14,1,1,1,235,57},{13,0,1,1,235,61},{14,1,1,1,235,61},{13,0,1,1,235,65},{14,1,1,1,235,65},{13,0,1,1,235,95},{14,1,1,1,235,95},{13,0,1,1,235,98},{14,1,1,1,235,98},{13,0,1,1,235,100},{14,1,1,1,235,100},{13,0,1,1,235,102},{14,1,1,1,235,102},{13,0,1,1,235,103},{14,1,1,1,235,103},{13,0,1,1,235,104},{14,1,1,1,235,104},{13,0,1,1,235,108},{14,1,1,1,235,108},{13,0,1,1,235,109},{14,1,1,1,235,109},{13,0,1,1,235,110},{14,1,1,1,235,110},{13,0,1,1,235,112},{14,1,1,1,235,112},{13,0,1,1,235,114},{14,1,1,1,235,114},{13,0,1,1,235,117},{14,1,1,1,235,117},{0,1,1,1,235,58},{0,1,1,1,235,66},{0,1,1,1,235,67},{0,1,1,1,235,68},{0,1,1,1,235,69},{0,1,1,1,235,70},{0,1,1,1,235,71},{0,1,1,1,235,72},{0,1,1,1,235,73},{0,1,1,1,235,74},{0,1,1,1,235,75},{0,1,1,1,235,76},{0,1,1,1,235,77},{0,1,1,1,235,78},{0,1,1,1,235,79},{0,1,1,1,235,80},{0,1,1,1,235,81},{0,1,1,1,235,82},{0,1,1,1,235,83},{0,1,1,1,235,84},{0,1,1,1,235,85},{0,1,1,1,235,86},{0,1,1,1,235,87},{0,1,1,1,235,89},{0,1,1,1,235,106},{0,1,1,1,235,107},{0,1,1,1,235,113},{0,1,1,1,235,118},{0,1,1,1,235,119},{0,1,1,1,235,120},{0,1,1,1,235,121},{0,1,1,1,235,122},{85,0,0,1,0,235},{86,0,0,1,0,235},{87,0,0,1,0,235},{88,1,0,1,0,235},{13,0,1,1,192,48},{14,1,1,1,192,48},{13,0,1,1,192,49},{14,1,1,1,192,49},{13,0,1,1,192,50},{14,1,1,1,192,50},{13,0,1,1,192,97},{14,1,1,1,192,97},{13,0,1,1,192,99},{14,1,1,1,192,99},{13,0,1,1,192,101},{14,1,1,1,192,101},{13,0,1,1,192,105},{14,1,1,1,192,105},{13,0,1,1,192,111},{14,1,1,1,192,111},{13,0,1,1,192,115},{14,1,1,1,192,115},{13,0,1,1,192,116},{14,1,1,1,192,116},{0,1,1,1,192,32},{0,1,1,1,192,37},{0,1,1,1,192,45},{0,1,1,1,192,46},{0,1,1,1,192,47},{0,1,1,1,192,51},{0,1,1,1,192,52},{0,1,1,1,192,53},{0,1,1,1,192,54},{0,1,1,1,192,55},{0,1,1,1,192,56},{0,1,1,1,192,57},{0,1,1,1,192,61},{0,1,1,1,192,65},{0,1,1,1,192,95},{0,1,1,1,192,98},{0,1,1,1,192,100},{0,1,1,1,192,102},{0,1,1,1,192,103},{0,1,1,1,192,104},{0,1,1,1,192,108},{0,1,1,1,192,109},{0,1,1,1,192,110},{0,1,1,1,192,112},{0,1,1,1,192,114},{0,1,1,1,192,117},{17,0,0,1,0,192},{18,0,0,1,0,192},{19,0,0,1,0,192},{20,0,0,1,0,192},{21,0,0,1,0,192},{22,0,0,1,0,192},{23,0,0,1,0,192},{24,0,0,1,0,192},{25,0,0,1,0,192},{26,0,0,1,0,192},{27,0,0,1,0,192},{28,0,0,1,0,192},{29,0,0,1,0,192},{30,0,0,1,0,192},{31,0,0,1,0,192},{32,0,0,1,0,192},{33,0,0,1,0,192},{34,1,0,1,0,192},{13,0,1,1,193,48},{14,1,1,1,193,48},{13,0,1,1,193,49},{14,1,1,1,193,49},{13,0,1,1,193,50},{14,1,1,1,193,50},{13,0,1,1,193,97},{14,1,1,1,193,97},{13,0,1,1,193,99},{14,1,1,1,193,99},{13,0,1,1,193,101},{14,1,1,1,193,101},{13,0,1,1,193,105},{14,1,1,1,193,105},{13,0,1,1,193,111},{14,1,1,1,193,111},{13,0,1,1,193,115},{14,1,1,1,193,115},{13,0,1,1,193,116},{14,1,1,1,193,116},{0,1,1,1,193,32},{0,1,1,1,193,37},{0,1,1,1,193,45},{0,1,1,1,193,46},{0,1,1,1,193,47},{0,1,1,1,193,51},{0,1,1,1,193,52},{0,1,1,1,193,53},{0,1,1,1,193,54},{0,1,1,1,193,55},{0,1,1,1,193,56},{0,1,1,1,193,57},{0,1,1,1,193,61},{0,1,1,1,193,65},{0,1,1,1,193,95},{0,1,1,1,193,98},{0,1,1,1,193,100},{0,1,1,1,193,102},{0,1,1,1,193,103},{0,1,1,1,193,104},{0,1,1,1,193,108},{0,1,1,1,193,109},{0,1,1,1,193,110},{0,1,1,1,193,112},{0,1,1,1,193,114},{0,1,1,1,193,117},{17,0,0,1,0,193},{18,0,0,1,0,193},{19,0,0,1,0,193},{20,0,0,1,0,193},{21,0,0,1,0,193},{22,0,0,1,0,193},{23,0,0,1,0,193},{24,0,0,1,0,193},{25,0,0,1,0,193},{26,0,0,1,0,193},{27,0,0,1,0,193},{28,0,0,1,0,193},{29,0,0,1,0,193},{30,0,0,1,0,193},{31,0,0,1,0,193},{32,0,0,1,0,193},{33,0,0,1,0,193},{34,1,0,1,0,193},{13,0,1,1,200,48},{14,1,1,1,200,48},{13,0,1,1,200,49},{14,1,1,1,200,49},{13,0,1,1,200,50},{14,1,1,1,200,50},{13,0,1,1,200,97},{14,1,1,1,200,97},{13,0,1,1,200,99},{14,1,1,1,200,99},{13,0,1,1,200,101},{14,1,1,1,200,101},{13,0,1,1,200,105},{14,1,1,1,200,105},{13,0,1,1,200,111},{14,1,1,1,200,111},{13,0,1,1,200,115},{14,1,1,1,200,115},{13,0,1,1,200,116},{14,1,1,1,200,116},{0,1,1,1,200,32},{0,1,1,1,200,37},{0,1,1,1,200,45},{0,1,1,1,200,46},{0,1,1,1,200,47},{0,1,1,1,200,51},{0,1,1,1,200,52},{0,1,1,1,200,53},{0,1,1,1,200,54},{0,1,1,1,200,55},{0,1,1,1,200,56},{0,1,1,1,200,57},{0,1,1,1,200,61},{0,1,1,1,200,65},{0,1,1,1,200,95},{0,1,1,1,200,98},{0,1,1,1,200,100},{0,1,1,1,200,102},{0,1,1,1,200,103},{0,1,1,1,200,104},{0,1,1,1,200,108},{0,1,1,1,200,109},{0,1,1,1,200,110},{0,1,1,1,200,112},{0,1,1,1,200,114},{0,1,1,1,200,117},{17,0,0,1,0,200},{18,0,0,1,0,200},{19,0,0,1,0,200},{20,0,0,1,0,200},{21,0,0,1,0,200},{22,0,0,1,0,200},{23,0,0,1,0,200},{24,0,0,1,0,200},{25,0,0,1,0,200},{26,0,0,1,0,200},{27,0,0,1,0,200},{28,0,0,1,0,200},{29,0,0,1,0,200},{30,0,0,1,0,200},{31,0,0,1,0,200},{32,0,0,1,0,200},{33,0,0,1,0,200},{34,1,0,1,0,200},{13,0,1,1,201,48},{14,1,1,1,201,48},{13,0,1,1,201,49},{14,1,1,1,201,49},{13,0,1,1,201,50},{14,1,1,1,201,50},{13,0,1,1,201,97},{14,1,1,1,201,97},{13,0,1,1,201,99},{14,1,1,1,201,99},{13,0,1,1,201,101},{14,1,1,1,201,101},{13,0,1,1,201,105},{14,1,1,1,201,105},{13,0,1,1,201,111},{14,1,1,1,201,111},{13,0,1,1,201,115},{14,1,1,1,201,115},{13,0,1,1,201,116},{14,1,1,1,201,116},{0,1,1,1,201,32},{0,1,1,1,201,37},{0,1,1,1,201,45},{0,1,1,1,201,46},{0,1,1,1,201,47},{0,1,1,1,201,51},{0,1,1,1,201,52},{0,1,1,1,201,53},{0,1,1,1,201,54},{0,1,1,1,201,55},{0,1,1,1,201,56},{0,1,1,1,201,57},{0,1,1,1,201,61},{0,1,1,1,201,65},{0,1,1,1,201,95},{0,1,1,1,201,98},{0,1,1,1,201,100},{0,1,1,1,201,102},{0,1,1,1,201,103},{0,1,1,1,201,104},{0,1,1,1,201,108},{0,1,1,1,201,109},{0,1,1,1,201,110},{0,1,1,1,201,112},{0,1,1,1,201,114},{0,1,1,1,201,117},{17,0,0,1,0,201},{18,0,0,1,0,201},{19,0,0,1,0,201},{20,0,0,1,0,201},{21,0,0,1,0,201},{22,0,0,1,0,201},{23,0,0,1,0,201},{24,0,0,1,0,201},{25,0,0,1,0,201},{26,0,0,1,0,201},{27,0,0,1,0,201},{28,0,0,1,0,201},{29,0,0,1,0,201},{30,0,0,1,0,201},{31,0,0,1,0,201},{32,0,0,1,0,201},{33,0,0,1,0,201},{34,1,0,1,0,201},{13,0,1,1,202,48},{14,1,1,1,202,48},{13,0,1,1,202,49},{14,1,1,1,202,49},{13,0,1,1,202,50},{14,1,1,1,202,50},{13,0,1,1,202,97},{14,1,1,1,202,97},{13,0,1,1,202,99},{14,1,1,1,202,99},{13,0,1,1,202,101},{14,1,1,1,202,101},{13,0,1,1,202,105},{14,1,1,1,202,105},{13,0,1,1,202,111},{14,1,1,1,202,111},{13,0,1,1,202,115},{14,1,1,1,202,115},{13,0,1,1,202,116},{14,1,1,1,202,116},{0,1,1,1,202,32},{0,1,1,1,202,37},{0,1,1,1,202,45},{0,1,1,1,202,46},{0,1,1,1,202,47},{0,1,1,1,202,51},{0,1,1,1,202,52},{0,1,1,1,202,53},{0,1,1,1,202,54},{0,1,1,1,202,55},{0,1,1,1,202,56},{0,1,1,1,202,57},{0,1,1,1,202,61},{0,1,1,1,202,65},{0,1,1,1,202,95},{0,1,1,1,202,98},{0,1,1,1,202,100},{0,1,1,1,202,102},{0,1,1,1,202,103},{0,1,1,1,202,104},{0,1,1,1,202,108},{0,1,1,1,202,109},{0,1,1,1,202,110},{0,1,1,1,202,112},{0,1,1,1,202,114},{0,1,1,1,202,117},{17,0,0,1,0,202},{18,0,0,1,0,202},{19,0,0,1,0,202},{20,0,0,1,0,202},{21,0,0,1,0,202},{22,0,0,1,0,202},{23,0,0,1,0,202},{24,0,0,1,0,202},{25,0,0,1,0,202},{26,0,0,1,0,202},{27,0,0,1,0,202},{28,0,0,1,0,202},{29,0,0,1,0,202},{30,0,0,1,0,202},{31,0,0,1,0,202},{32,0,0,1,0,202},{33,0,0,1,0,202},{34,1,0,1,0,202},{13,0,1,1,205,48},{14,1,1,1,205,48},{13,0,1,1,205,49},{14,1,1,1,205,49},{13,0,1,1,205,50},{14,1,1,1,205,50},{13,0,1,1,205,97},{14,1,1,1,205,97},{13,0,1,1,205,99},{14,1,1,1,205,99},{13,0,1,1,205,101},{14,1,1,1,205,101},{13,0,1,1,205,105},{14,1,1,1,205,105},{13,0,1,1,205,111},{14,1,1,1,205,111},{13,0,1,1,205,115},{14,1,1,1,205,115},{13,0,1,1,205,116},{14,1,1,1,205,116},{0,1,1,1,205,32},{0,1,1,1,205,37},{0,1,1,1,205,45},{0,1,1,1,205,46},{0,1,1,1,205,47},{0,1,1,1,205,51},{0,1,1,1,205,52},{0,1,1,1,205,53},{0,1,1,1,205,54},{0,1,1,1,205,55},{0,1,1,1,205,56},{0,1,1,1,205,57},{0,1,1,1,205,61},{0,1,1,1,205,65},{0,1,1,1,205,95},{0,1,1,1,205,98},{0,1,1,1,205,100},{0,1,1,1,205,102},{0,1,1,1,205,103},{0,1,1,1,205,104},{0,1,1,1,205,108},{0,1,1,1,205,109},{0,1,1,1,205,110},{0,1,1,1,205,112},{0,1,1,1,205,114},{0,1,1,1,205,117},{17,0,0,1,0,205},{18,0,0,1,0,205},{19,0,0,1,0,205},{20,0,0,1,0,205},{21,0,0,1,0,205},{22,0,0,1,0,205},{23,0,0,1,0,205},{24,0,0,1,0,205},{25,0,0,1,0,205},{26,0,0,1,0,205},{27,0,0,1,0,205},{28,0,0,1,0,205},{29,0,0,1,0,205},{30,0,0,1,0,205},{31,0,0,1,0,205},{32,0,0,1,0,205},{33,0,0,1,0,205},{34,1,0,1,0,205},{13,0,1,1,210,48},{14,1,1,1,210,48},{13,0,1,1,210,49},{14,1,1,1,210,49},{13,0,1,1,210,50},{14,1,1,1,210,50},{13,0,1,1,210,97},{14,1,1,1,210,97},{13,0,1,1,210,99},{14,1,1,1,210,99},{13,0,1,1,210,101},{14,1,1,1,210,101},{13,0,1,1,210,105},{14,1,1,1,210,105},{13,0,1,1,210,111},{14,1,1,1,210,111},{13,0,1,1,210,115},{14,1,1,1,210,115},{13,0,1,1,210,116},{14,1,1,1,210,116},{0,1,1,1,210,32},{0,1,1,1,210,37},{0,1,1,1,210,45},{0,1,1,1,210,46},{0,1,1,1,210,47},{0,1,1,1,210,51},{0,1,1,1,210,52},{0,1,1,1,210,53},{0,1,1,1,210,54},{0,1,1,1,210,55},{0,1,1,1,210,56},{0,1,1,1,210,57},{0,1,1,1,210,61},{0,1,1,1,210,65},{0,1,1,1,210,95},{0,1,1,1,210,98},{0,1,1,1,210,100},{0,1,1,1,210,102},{0,1,1,1,210,103},{0,1,1,1,210,104},{0,1,1,1,210,108},{0,1,1,1,210,109},{0,1,1,1,210,110},{0,1,1,1,210,112},{0,1,1,1,210,114},{0,1,1,1,210,117},{17,0,0,1,0,210},{18,0,0,1,0,210},{19,0,0,1,0,210},{20,0,0,1,0,210},{21,0,0,1,0,210},{22,0,0,1,0,210},{23,0,0,1,0,210},{24,0,0,1,0,210},{25,0,0,1,0,210},{26,0,0,1,0,210},{27,0,0,1,0,210},{28,0,0,1,0,210},{29,0,0,1,0,210},{30,0,0,1,0,210},{31,0,0,1,0,210},{32,0,0,1,0,210},{33,0,0,1,0,210},{34,1,0,1,0,210},{13,0,1,1,213,48},{14,1,1,1,213,48},{13,0,1,1,213,49},{14,1,1,1,213,49},{13,0,1,1,213,50},{14,1,1,1,213,50},{13,0,1,1,213,97},{14,1,1,1,213,97},{13,0,1,1,213,99},{14,1,1,1,213,99},{13,0,1,1,213,101},{14,1,1,1,213,101},{13,0,1,1,213,105},{14,1,1,1,213,105},{13,0,1,1,213,111},{14,1,1,1,213,111},{13,0,1,1,213,115},{14,1,1,1,213,115},{13,0,1,1,213,116},{14,1,1,1,213,116},{0,1,1,1,213,32},{0,1,1,1,213,37},{0,1,1,1,213,45},{0,1,1,1,213,46},{0,1,1,1,213,47},{0,1,1,1,213,51},{0,1,1,1,213,52},{0,1,1,1,213,53},{0,1,1,1,213,54},{0,1,1,1,213,55},{0,1,1,1,213,56},{0,1,1,1,213,57},{0,1,1,1,213,61},{0,1,1,1,213,65},{0,1,1,1,213,95},{0,1,1,1,213,98},{0,1,1,1,213,100},{0,1,1,1,213,102},{0,1,1,1,213,103},{0,1,1,1,213,104},{0,1,1,1,213,108},{0,1,1,1,213,109},{0,1,1,1,213,110},{0,1,1,1,213,112},{0,1,1,1,213,114},{0,1,1,1,213,117},{17,0,0,1,0,213},{18,0,0,1,0,213},{19,0,0,1,0,213},{20,0,0,1,0,213},{21,0,0,1,0,213},{22,0,0,1,0,213},{23,0,0,1,0,213},{24,0,0,1,0,213},{25,0,0,1,0,213},{26,0,0,1,0,213},{27,0,0,1,0,213},{28,0,0,1,0,213},{29,0,0,1,0,213},{30,0,0,1,0,213},{31,0,0,1,0,213},{32,0,0,1,0,213},{33,0,0,1,0,213},{34,1,0,1,0,213},{13,0,1,1,218,48},{14,1,1,1,218,48},{13,0,1,1,218,49},{14,1,1,1,218,49},{13,0,1,1,218,50},{14,1,1,1,218,50},{13,0,1,1,218,97},{14,1,1,1,218,97},{13,0,1,1,218,99},{14,1,1,1,218,99},{13,0,1,1,218,101},{14,1,1,1,218,101},{13,0,1,1,218,105},{14,1,1,1,218,105},{13,0,1,1,218,111},{14,1,1,1,218,111},{13,0,1,1,218,115},{14,1,1,1,218,115},{13,0,1,1,218,116},{14,1,1,1,218,116},{0,1,1,1,218,32},{0,1,1,1,218,37},{0,1,1,1,218,45},{0,1,1,1,218,46},{0,1,1,1,218,47},{0,1,1,1,218,51},{0,1,1,1,218,52},{0,1,1,1,218,53},{0,1,1,1,218,54},{0,1,1,1,218,55},{0,1,1,1,218,56},{0,1,1,1,218,57},{0,1,1,1,218,61},{0,1,1,1,218,65},{0,1,1,1,218,95},{0,1,1,1,218,98},{0,1,1,1,218,100},{0,1,1,1,218,102},{0,1,1,1,218,103},{0,1,1,1,218,104},{0,1,1,1,218,108},{0,1,1,1,218,109},{0,1,1,1,218,110},{0,1,1,1,218,112},{0,1,1,1,218,114},{0,1,1,1,218,117},{17,0,0,1,0,218},{18,0,0,1,0,218},{19,0,0,1,0,218},{20,0,0,1,0,218},{21,0,0,1,0,218},{22,0,0,1,0,218},{23,0,0,1,0,218},{24,0,0,1,0,218},{25,0,0,1,0,218},{26,0,0,1,0,218},{27,0,0,1,0,218},{28,0,0,1,0,218},{29,0,0,1,0,218},{30,0,0,1,0,218},{31,0,0,1,0,218},{32,0,0,1,0,218},{33,0,0,1,0,218},{34,1,0,1,0,218},{13,0,1,1,219,48},{14,1,1,1,219,48},{13,0,1,1,219,49},{14,1,1,1,219,49},{13,0,1,1,219,50},{14,1,1,1,219,50},{13,0,1,1,219,97},{14,1,1,1,219,97},{13,0,1,1,219,99},{14,1,1,1,219,99},{13,0,1,1,219,101},{14,1,1,1,219,101},{13,0,1,1,219,105},{14,1,1,1,219,105},{13,0,1,1,219,111},{14,1,1,1,219,111},{13,0,1,1,219,115},{14,1,1,1,219,115},{13,0,1,1,219,116},{14,1,1,1,219,116},{0,1,1,1,219,32},{0,1,1,1,219,37},{0,1,1,1,219,45},{0,1,1,1,219,46},{0,1,1,1,219,47},{0,1,1,1,219,51},{0,1,1,1,219,52},{0,1,1,1,219,53},{0,1,1,1,219,54},{0,1,1,1,219,55},{0,1,1,1,219,56},{0,1,1,1,219,57},{0,1,1,1,219,61},{0,1,1,1,219,65},{0,1,1,1,219,95},{0,1,1,1,219,98},{0,1,1,1,219,100},{0,1,1,1,219,102},{0,1,1,1,219,103},{0,1,1,1,219,104},{0,1,1,1,219,108},{0,1,1,1,219,109},{0,1,1,1,219,110},{0,1,1,1,219,112},{0,1,1,1,219,114},{0,1,1,1,219,117},{17,0,0,1,0,219},{18,0,0,1,0,219},{19,0,0,1,0,219},{20,0,0,1,0,219},{21,0,0,1,0,219},{22,0,0,1,0,219},{23,0,0,1,0,219},{24,0,0,1,0,219},{25,0,0,1,0,219},{26,0,0,1,0,219},{27,0,0,1,0,219},{28,0,0,1,0,219},{29,0,0,1,0,219},{30,0,0,1,0,219},{31,0,0,1,0,219},{32,0,0,1,0,219},{33,0,0,1,0,219},{34,1,0,1,0,219},{13,0,1,1,238,48},{14,1,1,1,238,48},{13,0,1,1,238,49},{14,1,1,1,238,49},{13,0,1,1,238,50},{14,1,1,1,238,50},{13,0,1,1,238,97},{14,1,1,1,238,97},{13,0,1,1,238,99},{14,1,1,1,238,99},{13,0,1,1,238,101},{14,1,1,1,238,101},{13,0,1,1,238,105},{14,1,1,1,238,105},{13,0,1,1,238,111},{14,1,1,1,238,111},{13,0,1,1,238,115},{14,1,1,1,238,115},{13,0,1,1,238,116},{14,1,1,1,238,116},{0,1,1,1,238,32},{0,1,1,1,238,37},{0,1,1,1,238,45},{0,1,1,1,238,46},{0,1,1,1,238,47},{0,1,1,1,238,51},{0,1,1,1,238,52},{0,1,1,1,238,53},{0,1,1,1,238,54},{0,1,1,1,238,55},{0,1,1,1,238,56},{0,1,1,1,238,57},{0,1,1,1,238,61},{0,1,1,1,238,65},{0,1,1,1,238,95},{0,1,1,1,238,98},{0,1,1,1,238,100},{0,1,1,1,238,102},{0,1,1,1,238,103},{0,1,1,1,238,104},{0,1,1,1,238,108},{0,1,1,1,238,109},{0,1,1,1,238,110},{0,1,1,1,238,112},{0,1,1,1,238,114},{0,1,1,1,238,117},{17,0,0,1,0,238},{18,0,0,1,0,238},{19,0,0,1,0,238},{20,0,0,1,0,238},{21,0,0,1,0,238},{22,0,0,1,0,238},{23,0,0,1,0,238},{24,0,0,1,0,238},{25,0,0,1,0,238},{26,0,0,1,0,238},{27,0,0,1,0,238},{28,0,0,1,0,238},{29,0,0,1,0,238},{30,0,0,1,0,238},{31,0,0,1,0,238},{32,0,0,1,0,238},{33,0,0,1,0,238},{34,1,0,1,0,238},{13,0,1,1,240,48},{14,1,1,1,240,48},{13,0,1,1,240,49},{14,1,1,1,240,49},{13,0,1,1,240,50},{14,1,1,1,240,50},{13,0,1,1,240,97},{14,1,1,1,240,97},{13,0,1,1,240,99},{14,1,1,1,240,99},{13,0,1,1,240,101},{14,1,1,1,240,101},{13,0,1,1,240,105},{14,1,1,1,240,105},{13,0,1,1,240,111},{14,1,1,1,240,111},{13,0,1,1,240,115},{14,1,1,1,240,115},{13,0,1,1,240,116},{14,1,1,1,240,116},{0,1,1,1,240,32},{0,1,1,1,240,37},{0,1,1,1,240,45},{0,1,1,1,240,46},{0,1,1,1,240,47},{0,1,1,1,240,51},{0,1,1,1,240,52},{0,1,1,1,240,53},{0,1,1,1,240,54},{0,1,1,1,240,55},{0,1,1,1,240,56},{0,1,1,1,240,57},{0,1,1,1,240,61},{0,1,1,1,240,65},{0,1,1,1,240,95},{0,1,1,1,240,98},{0,1,1,1,240,100},{0,1,1,1,240,102},{0,1,1,1,240,103},{0,1,1,1,240,104},{0,1,1,1,240,108},{0,1,1,1,240,109},{0,1,1,1,240,110},{0,1,1,1,240,112},{0,1,1,1,240,114},{0,1,1,1,240,117},{17,0,0,1,0,240},{18,0,0,1,0,240},{19,0,0,1,0,240},{20,0,0,1,0,240},{21,0,0,1,0,240},{22,0,0,1,0,240},{23,0,0,1,0,240},{24,0,0,1,0,240},{25,0,0,1,0,240},{26,0,0,1,0,240},{27,0,0,1,0,240},{28,0,0,1,0,240},{29,0,0,1,0,240},{30,0,0,1,0,240},{31,0,0,1,0,240},{32,0,0,1,0,240},{33,0,0,1,0,240},{34,1,0,1,0,240},{13,0,1,1,242,48},{14,1,1,1,242,48},{13,0,1,1,242,49},{14,1,1,1,242,49},{13,0,1,1,242,50},{14,1,1,1,242,50},{13,0,1,1,242,97},{14,1,1,1,242,97},{13,0,1,1,242,99},{14,1,1,1,242,99},{13,0,1,1,242,101},{14,1,1,1,242,101},{13,0,1,1,242,105},{14,1,1,1,242,105},{13,0,1,1,242,111},{14,1,1,1,242,111},{13,0,1,1,242,115},{14,1,1,1,242,115},{13,0,1,1,242,116},{14,1,1,1,242,116},{0,1,1,1,242,32},{0,1,1,1,242,37},{0,1,1,1,242,45},{0,1,1,1,242,46},{0,1,1,1,242,47},{0,1,1,1,242,51},{0,1,1,1,242,52},{0,1,1,1,242,53},{0,1,1,1,242,54},{0,1,1,1,242,55},{0,1,1,1,242,56},{0,1,1,1,242,57},{0,1,1,1,242,61},{0,1,1,1,242,65},{0,1,1,1,242,95},{0,1,1,1,242,98},{0,1,1,1,242,100},{0,1,1,1,242,102},{0,1,1,1,242,103},{0,1,1,1,242,104},{0,1,1,1,242,108},{0,1,1,1,242,109},{0,1,1,1,242,110},{0,1,1,1,242,112},{0,1,1,1,242,114},{0,1,1,1,242,117},{17,0,0,1,0,242},{18,0,0,1,0,242},{19,0,0,1,0,242},{20,0,0,1,0,242},{21,0,0,1,0,242},{22,0,0,1,0,242},{23,0,0,1,0,242},{24,0,0,1,0,242},{25,0,0,1,0,242},{26,0,0,1,0,242},{27,0,0,1,0,242},{28,0,0,1,0,242},{29,0,0,1,0,242},{30,0,0,1,0,242},{31,0,0,1,0,242},{32,0,0,1,0,242},{33,0,0,1,0,242},{34,1,0,1,0,242},{13,0,1,1,243,48},{14,1,1,1,243,48},{13,0,1,1,243,49},{14,1,1,1,243,49},{13,0,1,1,243,50},{14,1,1,1,243,50},{13,0,1,1,243,97},{14,1,1,1,243,97},{13,0,1,1,243,99},{14,1,1,1,243,99},{13,0,1,1,243,101},{14,1,1,1,243,101},{13,0,1,1,243,105},{14,1,1,1,243,105},{13,0,1,1,243,111},{14,1,1,1,243,111},{13,0,1,1,243,115},{14,1,1,1,243,115},{13,0,1,1,243,116},{14,1,1,1,243,116},{0,1,1,1,243,32},{0,1,1,1,243,37},{0,1,1,1,243,45},{0,1,1,1,243,46},{0,1,1,1,243,47},{0,1,1,1,243,51},{0,1,1,1,243,52},{0,1,1,1,243,53},{0,1,1,1,243,54},{0,1,1,1,243,55},{0,1,1,1,243,56},{0,1,1,1,243,57},{0,1,1,1,243,61},{0,1,1,1,243,65},{0,1,1,1,243,95},{0,1,1,1,243,98},{0,1,1,1,243,100},{0,1,1,1,243,102},{0,1,1,1,243,103},{0,1,1,1,243,104},{0,1,1,1,243,108},{0,1,1,1,243,109},{0,1,1,1,243,110},{0,1,1,1,243,112},{0,1,1,1,243,114},{0,1,1,1,243,117},{17,0,0,1,0,243},{18,0,0,1,0,243},{19,0,0,1,0,243},{20,0,0,1,0,243},{21,0,0,1,0,243},{22,0,0,1,0,243},{23,0,0,1,0,243},{24,0,0,1,0,243},{25,0,0,1,0,243},{26,0,0,1,0,243},{27,0,0,1,0,243},{28,0,0,1,0,243},{29,0,0,1,0,243},{30,0,0,1,0,243},{31,0,0,1,0,243},{32,0,0,1,0,243},{33,0,0,1,0,243},{34,1,0,1,0,243},{13,0,1,1,255,48},{14,1,1,1,255,48},{13,0,1,1,255,49},{14,1,1,1,255,49},{13,0,1,1,255,50},{14,1,1,1,255,50},{13,0,1,1,255,97},{14,1,1,1,255,97},{13,0,1,1,255,99},{14,1,1,1,255,99},{13,0,1,1,255,101},{14,1,1,1,255,101},{13,0,1,1,255,105},{14,1,1,1,255,105},{13,0,1,1,255,111},{14,1,1,1,255,111},{13,0,1,1,255,115},{14,1,1,1,255,115},{13,0,1,1,255,116},{14,1,1,1,255,116},{0,1,1,1,255,32},{0,1,1,1,255,37},{0,1,1,1,255,45},{0,1,1,1,255,46},{0,1,1,1,255,47},{0,1,1,1,255,51},{0,1,1,1,255,52},{0,1,1,1,255,53},{0,1,1,1,255,54},{0,1,1,1,255,55},{0,1,1,1,255,56},{0,1,1,1,255,57},{0,1,1,1,255,61},{0,1,1,1,255,65},{0,1,1,1,255,95},{0,1,1,1,255,98},{0,1,1,1,255,100},{0,1,1,1,255,102},{0,1,1,1,255,103},{0,1,1,1,255,104},{0,1,1,1,255,108},{0,1,1,1,255,109},{0,1,1,1,255,110},{0,1,1,1,255,112},{0,1,1,1,255,114},{0,1,1,1,255,117},{17,0,0,1,0,255},{18,0,0,1,0,255},{19,0,0,1,0,255},{20,0,0,1,0,255},{21,0,0,1,0,255},{22,0,0,1,0,255},{23,0,0,1,0,255},{24,0,0,1,0,255},{25,0,0,1,0,255},{26,0,0,1,0,255},{27,0,0,1,0,255},{28,0,0,1,0,255},{29,0,0,1,0,255},{30,0,0,1,0,255},{31,0,0,1,0,255},{32,0,0,1,0,255},{33,0,0,1,0,255},{34,1,0,1,0,255},{0,1,1,1,203,48},{0,1,1,1,203,49},{0,1,1,1,203,50},{0,1,1,1,203,97},{0,1,1,1,203,99},{0,1,1,1,203,101},{0,1,1,1,203,105},{0,1,1,1,203,111},{0,1,1,1,203,115},{0,1,1,1,203,116},{35,0,0,1,0,203},{36,0,0,1,0,203},{37,0,0,1,0,203},{38,0,0,1,0,203},{39,0,0,1,0,203},{40,0,0,1,0,203},{41,0,0,1,0,203},{42,0,0,1,0,203},{43,0,0,1,0,203},{44,0,0,1,0,203},{45,0,0,1,0,203},{46,0,0,1,0,203},{47,0,0,1,0,203},{48,0,0,1,0,203},{49,0,0,1,0,203},{50,0,0,1,0,203},{51,0,0,1,0,203},{52,0,0,1,0,203},{53,0,0,1,0,203},{54,0,0,1,0,203},{55,0,0,1,0,203},{56,1,0,1,0,203},{0,1,1,1,204,48},{0,1,1,1,204,49},{0,1,1,1,204,50},{0,1,1,1,204,97},{0,1,1,1,204,99},{0,1,1,1,204,101},{0,1,1,1,204,105},{0,1,1,1,204,111},{0,1,1,1,204,115},{0,1,1,1,204,116},{35,0,0,1,0,204},{36,0,0,1,0,204},{37,0,0,1,0,204},{38,0,0,1,0,204},{39,0,0,1,0,204},{40,0,0,1,0,204},{41,0,0,1,0,204},{42,0,0,1,0,204},{43,0,0,1,0,204},{44,0,0,1,0,204},{45,0,0,1,0,204},{46,0,0,1,0,204},{47,0,0,1,0,204},{48,0,0,1,0,204},{49,0,0,1,0,204},{50,0,0,1,0,204},{51,0,0,1,0,204},{52,0,0,1,0,204},{53,0,0,1,0,204},{54,0,0,1,0,204},{55,0,0,1,0,204},{56,1,0,1,0,204},{0,1,1,1,211,48},{0,1,1,1,211,49},{0,1,1,1,211,50},{0,1,1,1,211,97},{0,1,1,1,211,99},{0,1,1,1,211,101},{0,1,1,1,211,105},{0,1,1,1,211,111},{0,1,1,1,211,115},{0,1,1,1,211,116},{35,0,0,1,0,211},{36,0,0,1,0,211},{37,0,0,1,0,211},{38,0,0,1,0,211},{39,0,0,1,0,211},{40,0,0,1,0,211},{41,0,0,1,0,211},{42,0,0,1,0,211},{43,0,0,1,0,211},{44,0,0,1,0,211},{45,0,0,1,0,211},{46,0,0,1,0,211},{47,0,0,1,0,211},{48,0,0,1,0,211},{49,0,0,1,0,211},{50,0,0,1,0,211},{51,0,0,1,0,211},{52,0,0,1,0,211},{53,0,0,1,0,211},{54,0,0,1,0,211},{55,0,0,1,0,211},{56,1,0,1,0,211},{0,1,1,1,212,48},{0,1,1,1,212,49},{0,1,1,1,212,50},{0,1,1,1,212,97},{0,1,1,1,212,99},{0,1,1,1,212,101},{0,1,1,1,212,105},{0,1,1,1,212,111},{0,1,1,1,212,115},{0,1,1,1,212,116},{35,0,0,1,0,212},{36,0,0,1,0,212},{37,0,0,1,0,212},{38,0,0,1,0,212},{39,0,0,1,0,212},{40,0,0,1,0,212},{41,0,0,1,0,212},{42,0,0,1,0,212},{43,0,0,1,0,212},{44,0,0,1,0,212},{45,0,0,1,0,212},{46,0,0,1,0,212},{47,0,0,1,0,212},{48,0,0,1,0,212},{49,0,0,1,0,212},{50,0,0,1,0,212},{51,0,0,1,0,212},{52,0,0,1,0,212},{53,0,0,1,0,212},{54,0,0,1,0,212},{55,0,0,1,0,212},{56,1,0,1,0,212},{0,1,1,1,214,48},{0,1,1,1,214,49},{0,1,1,1,214,50},{0,1,1,1,214,97},{0,1,1,1,214,99},{0,1,1,1,214,101},{0,1,1,1,214,105},{0,1,1,1,214,111},{0,1,1,1,214,115},{0,1,1,1,214,116},{35,0,0,1,0,214},{36,0,0,1,0,214},{37,0,0,1,0,214},{38,0,0,1,0,214},{39,0,0,1,0,214},{40,0,0,1,0,214},{41,0,0,1,0,214},{42,0,0,1,0,214},{43,0,0,1,0,214},{44,0,0,1,0,214},{45,0,0,1,0,214},{46,0,0,1,0,214},{47,0,0,1,0,214},{48,0,0,1,0,214},{49,0,0,1,0,214},{50,0,0,1,0,214},{51,0,0,1,0,214},{52,0,0,1,0,214},{53,0,0,1,0,214},{54,0,0,1,0,214},{55,0,0,1,0,214},{56,1,0,1,0,214},{0,1,1,1,221,48},{0,1,1,1,221,49},{0,1,1,1,221,50},{0,1,1,1,221,97},{0,1,1,1,221,99},{0,1,1,1,221,101},{0,1,1,1,221,105},{0,1,1,1,221,111},{0,1,1,1,221,115},{0,1,1,1,221,116},{35,0,0,1,0,221},{36,0,0,1,0,221},{37,0,0,1,0,221},{38,0,0,1,0,221},{39,0,0,1,0,221},{40,0,0,1,0,221},{41,0,0,1,0,221},{42,0,0,1,0,221},{43,0,0,1,0,221},{44,0,0,1,0,221},{45,0,0,1,0,221},{46,0,0,1,0,221},{47,0,0,1,0,221},{48,0,0,1,0,221},{49,0,0,1,0,221},{50,0,0,1,0,221},{51,0,0,1,0,221},{52,0,0,1,0,221},{53,0,0,1,0,221},{54,0,0,1,0,221},{55,0,0,1,0,221},{56,1,0,1,0,221},{0,1,1,1,222,48},{0,1,1,1,222,49},{0,1,1,1,222,50},{0,1,1,1,222,97},{0,1,1,1,222,99},{0,1,1,1,222,101},{0,1,1,1,222,105},{0,1,1,1,222,111},{0,1,1,1,222,115},{0,1,1,1,222,116},{35,0,0,1,0,222},{36,0,0,1,0,222},{37,0,0,1,0,222},{38,0,0,1,0,222},{39,0,0,1,0,222},{40,0,0,1,0,222},{41,0,0,1,0,222},{42,0,0,1,0,222},{43,0,0,1,0,222},{44,0,0,1,0,222},{45,0,0,1,0,222},{46,0,0,1,0,222},{47,0,0,1,0,222},{48,0,0,1,0,222},{49,0,0,1,0,222},{50,0,0,1,0,222},{51,0,0,1,0,222},{52,0,0,1,0,222},{53,0,0,1,0,222},{54,0,0,1,0,222},{55,0,0,1,0,222},{56,1,0,1,0,222},{0,1,1,1,223,48},{0,1,1,1,223,49},{0,1,1,1,223,50},{0,1,1,1,223,97},{0,1,1,1,223,99},{0,1,1,1,223,101},{0,1,1,1,223,105},{0,1,1,1,223,111},{0,1,1,1,223,115},{0,1,1,1,223,116},{35,0,0,1,0,223},{36,0,0,1,0,223},{37,0,0,1,0,223},{38,0,0,1,0,223},{39,0,0,1,0,223},{40,0,0,1,0,223},{41,0,0,1,0,223},{42,0,0,1,0,223},{43,0,0,1,0,223},{44,0,0,1,0,223},{45,0,0,1,0,223},{46,0,0,1,0,223},{47,0,0,1,0,223},{48,0,0,1,0,223},{49,0,0,1,0,223},{50,0,0,1,0,223},{51,0,0,1,0,223},{52,0,0,1,0,223},{53,0,0,1,0,223},{54,0,0,1,0,223},{55,0,0,1,0,223},{56,1,0,1,0,223},{0,1,1,1,241,48},{0,1,1,1,241,49},{0,1,1,1,241,50},{0,1,1,1,241,97},{0,1,1,1,241,99},{0,1,1,1,241,101},{0,1,1,1,241,105},{0,1,1,1,241,111},{0,1,1,1,241,115},{0,1,1,1,241,116},{35,0,0,1,0,241},{36,0,0,1,0,241},{37,0,0,1,0,241},{38,0,0,1,0,241},{39,0,0,1,0,241},{40,0,0,1,0,241},{41,0,0,1,0,241},{42,0,0,1,0,241},{43,0,0,1,0,241},{44,0,0,1,0,241},{45,0,0,1,0,241},{46,0,0,1,0,241},{47,0,0,1,0,241},{48,0,0,1,0,241},{49,0,0,1,0,241},{50,0,0,1,0,241},{51,0,0,1,0,241},{52,0,0,1,0,241},{53,0,0,1,0,241},{54,0,0,1,0,241},{55,0,0,1,0,241},{56,1,0,1,0,241},{0,1,1,1,244,48},{0,1,1,1,244,49},{0,1,1,1,244,50},{0,1,1,1,244,97},{0,1,1,1,244,99},{0,1,1,1,244,101},{0,1,1,1,244,105},{0,1,1,1,244,111},{0,1,1,1,244,115},{0,1,1,1,244,116},{35,0,0,1,0,244},{36,0,0,1,0,244},{37,0,0,1,0,244},{38,0,0,1,0,244},{39,0,0,1,0,244},{40,0,0,1,0,244},{41,0,0,1,0,244},{42,0,0,1,0,244},{43,0,0,1,0,244},{44,0,0,1,0,244},{45,0,0,1,0,244},{46,0,0,1,0,244},{47,0,0,1,0,244},{48,0,0,1,0,244},{49,0,0,1,0,244},{50,0,0,1,0,244},{51,0,0,1,0,244},{52,0,0,1,0,244},{53,0,0,1,0,244},{54,0,0,1,0,244},{55,0,0,1,0,244},{56,1,0,1,0,244},{0,1,1,1,245,48},{0,1,1,1,245,49},{0,1,1,1,245,50},{0,1,1,1,245,97},{0,1,1,1,245,99},{0,1,1,1,245,101},{0,1,1,1,245,105},{0,1,1,1,245,111},{0,1,1,1,245,115},{0,1,1,1,245,116},{35,0,0,1,0,245},{36,0,0,1,0,245},{37,0,0,1,0,245},{38,0,0,1,0,245},{39,0,0,1,0,245},{40,0,0,1,0,245},{41,0,0,1,0,245},{42,0,0,1,0,245},{43,0,0,1,0,245},{44,0,0,1,0,245},{45,0,0,1,0,245},{46,0,0,1,0,245},{47,0,0,1,0,245},{48,0,0,1,0,245},{49,0,0,1,0,245},{50,0,0,1,0,245},{51,0,0,1,0,245},{52,0,0,1,0,245},{53,0,0,1,0,245},{54,0,0,1,0,245},{55,0,0,1,0,245},{56,1,0,1,0,245},{0,1,1,1,246,48},{0,1,1,1,246,49},{0,1,1,1,246,50},{0,1,1,1,246,97},{0,1,1,1,246,99},{0,1,1,1,246,101},{0,1,1,1,246,105},{0,1,1,1,246,111},{0,1,1,1,246,115},{0,1,1,1,246,116},{35,0,0,1,0,246},{36,0,0,1,0,246},{37,0,0,1,0,246},{38,0,0,1,0,246},{39,0,0,1,0,246},{40,0,0,1,0,246},{41,0,0,1,0,246},{42,0,0,1,0,246},{43,0,0,1,0,246},{44,0,0,1,0,246},{45,0,0,1,0,246},{46,0,0,1,0,246},{47,0,0,1,0,246},{48,0,0,1,0,246},{49,0,0,1,0,246},{50,0,0,1,0,246},{51,0,0,1,0,246},{52,0,0,1,0,246},{53,0,0,1,0,246},{54,0,0,1,0,246},{55,0,0,1,0,246},{56,1,0,1,0,246},{0,1,1,1,247,48},{0,1,1,1,247,49},{0,1,1,1,247,50},{0,1,1,1,247,97},{0,1,1,1,247,99},{0,1,1,1,247,101},{0,1,1,1,247,105},{0,1,1,1,247,111},{0,1,1,1,247,115},{0,1,1,1,247,116},{35,0,0,1,0,247},{36,0,0,1,0,247},{37,0,0,1,0,247},{38,0,0,1,0,247},{39,0,0,1,0,247},{40,0,0,1,0,247},{41,0,0,1,0,247},{42,0,0,1,0,247},{43,0,0,1,0,247},{44,0,0,1,0,247},{45,0,0,1,0,247},{46,0,0,1,0,247},{47,0,0,1,0,247},{48,0,0,1,0,247},{49,0,0,1,0,247},{50,0,0,1,0,247},{51,0,0,1,0,247},{52,0,0,1,0,247},{53,0,0,1,0,247},{54,0,0,1,0,247},{55,0,0,1,0,247},{56,1,0,1,0,247},{0,1,1,1,248,48},{0,1,1,1,248,49},{0,1,1,1,248,50},{0,1,1,1,248,97},{0,1,1,1,248,99},{0,1,1,1,248,101},{0,1,1,1,248,105},{0,1,1,1,248,111},{0,1,1,1,248,115},{0,1,1,1,248,116},{35,0,0,1,0,248},{36,0,0,1,0,248},{37,0,0,1,0,248},{38,0,0,1,0,248},{39,0,0,1,0,248},{40,0,0,1,0,248},{41,0,0,1,0,248},{42,0,0,1,0,248},{43,0,0,1,0,248},{44,0,0,1,0,248},{45,0,0,1,0,248},{46,0,0,1,0,248},{47,0,0,1,0,248},{48,0,0,1,0,248},{49,0,0,1,0,248},{50,0,0,1,0,248},{51,0,0,1,0,248},{52,0,0,1,0,248},{53,0,0,1,0,248},{54,0,0,1,0,248},{55,0,0,1,0,248},{56,1,0,1,0,248},{0,1,1,1,250,48},{0,1,1,1,250,49},{0,1,1,1,250,50},{0,1,1,1,250,97},{0,1,1,1,250,99},{0,1,1,1,250,101},{0,1,1,1,250,105},{0,1,1,1,250,111},{0,1,1,1,250,115},{0,1,1,1,250,116},{35,0,0,1,0,250},{36,0,0,1,0,250},{37,0,0,1,0,250},{38,0,0,1,0,250},{39,0,0,1,0,250},{40,0,0,1,0,250},{41,0,0,1,0,250},{42,0,0,1,0,250},{43,0,0,1,0,250},{44,0,0,1,0,250},{45,0,0,1,0,250},{46,0,0,1,0,250},{47,0,0,1,0,250},{48,0,0,1,0,250},{49,0,0,1,0,250},{50,0,0,1,0,250},{51,0,0,1,0,250},{52,0,0,1,0,250},{53,0,0,1,0,250},{54,0,0,1,0,250},{55,0,0,1,0,250},{56,1,0,1,0,250},{0,1,1,1,251,48},{0,1,1,1,251,49},{0,1,1,1,251,50},{0,1,1,1,251,97},{0,1,1,1,251,99},{0,1,1,1,251,101},{0,1,1,1,251,105},{0,1,1,1,251,111},{0,1,1,1,251,115},{0,1,1,1,251,116},{35,0,0,1,0,251},{36,0,0,1,0,251},{37,0,0,1,0,251},{38,0,0,1,0,251},{39,0,0,1,0,251},{40,0,0,1,0,251},{41,0,0,1,0,251},{42,0,0,1,0,251},{43,0,0,1,0,251},{44,0,0,1,0,251},{45,0,0,1,0,251},{46,0,0,1,0,251},{47,0,0,1,0,251},{48,0,0,1,0,251},{49,0,0,1,0,251},{50,0,0,1,0,251},{51,0,0,1,0,251},{52,0,0,1,0,251},{53,0,0,1,0,251},{54,0,0,1,0,251},{55,0,0,1,0,251},{56,1,0,1,0,251},{0,1,1,1,252,48},{0,1,1,1,252,49},{0,1,1,1,252,50},{0,1,1,1,252,97},{0,1,1,1,252,99},{0,1,1,1,252,101},{0,1,1,1,252,105},{0,1,1,1,252,111},{0,1,1,1,252,115},{0,1,1,1,252,116},{35,0,0,1,0,252},{36,0,0,1,0,252},{37,0,0,1,0,252},{38,0,0,1,0,252},{39,0,0,1,0,252},{40,0,0,1,0,252},{41,0,0,1,0,252},{42,0,0,1,0,252},{43,0,0,1,0,252},{44,0,0,1,0,252},{45,0,0,1,0,252},{46,0,0,1,0,252},{47,0,0,1,0,252},{48,0,0,1,0,252},{49,0,0,1,0,252},{50,0,0,1,0,252},{51,0,0,1,0,252},{52,0,0,1,0,252},{53,0,0,1,0,252},{54,0,0,1,0,252},{55,0,0,1,0,252},{56,1,0,1,0,252},{0,1,1,1,253,48},{0,1,1,1,253,49},{0,1,1,1,253,50},{0,1,1,1,253,97},{0,1,1,1,253,99},{0,1,1,1,253,101},{0,1,1,1,253,105},{0,1,1,1,253,111},{0,1,1,1,253,115},{0,1,1,1,253,116},{35,0,0,1,0,253},{36,0,0,1,0,253},{37,0,0,1,0,253},{38,0,0,1,0,253},{39,0,0,1,0,253},{40,0,0,1,0,253},{41,0,0,1,0,253},{42,0,0,1,0,253},{43,0,0,1,0,253},{44,0,0,1,0,253},{45,0,0,1,0,253},{46,0,0,1,0,253},{47,0,0,1,0,253},{48,0,0,1,0,253},{49,0,0,1,0,253},{50,0,0,1,0,253},{51,0,0,1,0,253},{52,0,0,1,0,253},{53,0,0,1,0,253},{54,0,0,1,0,253},{55,0,0,1,0,253},{56,1,0,1,0,253},{0,1,1,1,254,48},{0,1,1,1,254,49},{0,1,1,1,254,50},{0,1,1,1,254,97},{0,1,1,1,254,99},{0,1,1,1,254,101},{0,1,1,1,254,105},{0,1,1,1,254,111},{0,1,1,1,254,115},{0,1,1,1,254,116},{35,0,0,1,0,254},{36,0,0,1,0,254},{37,0,0,1,0,254},{38,0,0,1,0,254},{39,0,0,1,0,254},{40,0,0,1,0,254},{41,0,0,1,0,254},{42,0,0,1,0,254},{43,0,0,1,0,254},{44,0,0,1,0,254},{45,0,0,1,0,254},{46,0,0,1,0,254},{47,0,0,1,0,254},{48,0,0,1,0,254},{49,0,0,1,0,254},{50,0,0,1,0,254},{51,0,0,1,0,254},{52,0,0,1,0,254},{53,0,0,1,0,254},{54,0,0,1,0,254},{55,0,0,1,0,254},{56,1,0,1,0,254},{57,0,0,1,0,2},{58,0,0,1,0,2},{59,0,0,1,0,2},{60,0,0,1,0,2},{61,0,0,1,0,2},{62,0,0,1,0,2},{63,0,0,1,0,2},{64,0,0,1,0,2},{65,0,0,1,0,2},{66,0,0,1,0,2},{67,0,0,1,0,2},{68,0,0,1,0,2},{69,0,0,1,0,2},{70,0,0,1,0,2},{71,0,0,1,0,2},{72,1,0,1,0,2},{57,0,0,1,0,3},{58,0,0,1,0,3},{59,0,0,1,0,3},{60,0,0,1,0,3},{61,0,0,1,0,3},{62,0,0,1,0,3},{63,0,0,1,0,3},{64,0,0,1,0,3},{65,0,0,1,0,3},{66,0,0,1,0,3},{67,0,0,1,0,3},{68,0,0,1,0,3},{69,0,0,1,0,3},{70,0,0,1,0,3},{71,0,0,1,0,3},{72,1,0,1,0,3},{57,0,0,1,0,4},{58,0,0,1,0,4},{59,0,0,1,0,4},{60,0,0,1,0,4},{61,0,0,1,0,4},{62,0,0,1,0,4},{63,0,0,1,0,4},{64,0,0,1,0,4},{65,0,0,1,0,4},{66,0,0,1,0,4},{67,0,0,1,0,4},{68,0,0,1,0,4},{69,0,0,1,0,4},{70,0,0,1,0,4},{71,0,0,1,0,4},{72,1,0,1,0,4},{57,0,0,1,0,5},{58,0,0,1,0,5},{59,0,0,1,0,5},{60,0,0,1,0,5},{61,0,0,1,0,5},{62,0,0,1,0,5},{63,0,0,1,0,5},{64,0,0,1,0,5},{65,0,0,1,0,5},{66,0,0,1,0,5},{67,0,0,1,0,5},{68,0,0,1,0,5},{69,0,0,1,0,5},{70,0,0,1,0,5},{71,0,0,1,0,5},{72,1,0,1,0,5},{57,0,0,1,0,6},{58,0,0,1,0,6},{59,0,0,1,0,6},{60,0,0,1,0,6},{61,0,0,1,0,6},{62,0,0,1,0,6},{63,0,0,1,0,6},{64,0,0,1,0,6},{65,0,0,1,0,6},{66,0,0,1,0,6},{67,0,0,1,0,6},{68,0,0,1,0,6},{69,0,0,1,0,6},{70,0,0,1,0,6},{71,0,0,1,0,6},{72,1,0,1,0,6},{57,0,0,1,0,7},{58,0,0,1,0,7},{59,0,0,1,0,7},{60,0,0,1,0,7},{61,0,0,1,0,7},{62,0,0,1,0,7},{63,0,0,1,0,7},{64,0,0,1,0,7},{65,0,0,1,0,7},{66,0,0,1,0,7},{67,0,0,1,0,7},{68,0,0,1,0,7},{69,0,0,1,0,7},{70,0,0,1,0,7},{71,0,0,1,0,7},{72,1,0,1,0,7},{57,0,0,1,0,8},{58,0,0,1,0,8},{59,0,0,1,0,8},{60,0,0,1,0,8},{61,0,0,1,0,8},{62,0,0,1,0,8},{63,0,0,1,0,8},{64,0,0,1,0,8},{65,0,0,1,0,8},{66,0,0,1,0,8},{67,0,0,1,0,8},{68,0,0,1,0,8},{69,0,0,1,0,8},{70,0,0,1,0,8},{71,0,0,1,0,8},{72,1,0,1,0,8},{57,0,0,1,0,11},{58,0,0,1,0,11},{59,0,0,1,0,11},{60,0,0,1,0,11},{61,0,0,1,0,11},{62,0,0,1,0,11},{63,0,0,1,0,11},{64,0,0,1,0,11},{65,0,0,1,0,11},{66,0,0,1,0,11},{67,0,0,1,0,11},{68,0,0,1,0,11},{69,0,0,1,0,11},{70,0,0,1,0,11},{71,0,0,1,0,11},{72,1,0,1,0,11},{57,0,0,1,0,12},{58,0,0,1,0,12},{59,0,0,1,0,12},{60,0,0,1,0,12},{61,0,0,1,0,12},{62,0,0,1,0,12},{63,0,0,1,0,12},{64,0,0,1,0,12},{65,0,0,1,0,12},{66,0,0,1,0,12},{67,0,0,1,0,12},{68,0,0,1,0,12},{69,0,0,1,0,12},{70,0,0,1,0,12},{71,0,0,1,0,12},{72,1,0,1,0,12},{57,0,0,1,0,14},{58,0,0,1,0,14},{59,0,0,1,0,14},{60,0,0,1,0,14},{61,0,0,1,0,14},{62,0,0,1,0,14},{63,0,0,1,0,14},{64,0,0,1,0,14},{65,0,0,1,0,14},{66,0,0,1,0,14},{67,0,0,1,0,14},{68,0,0,1,0,14},{69,0,0,1,0,14},{70,0,0,1,0,14},{71,0,0,1,0,14},{72,1,0,1,0,14},{57,0,0,1,0,15},{58,0,0,1,0,15},{59,0,0,1,0,15},{60,0,0,1,0,15},{61,0,0,1,0,15},{62,0,0,1,0,15},{63,0,0,1,0,15},{64,0,0,1,0,15},{65,0,0,1,0,15},{66,0,0,1,0,15},{67,0,0,1,0,15},{68,0,0,1,0,15},{69,0,0,1,0,15},{70,0,0,1,0,15},{71,0,0,1,0,15},{72,1,0,1,0,15},{57,0,0,1,0,16},{58,0,0,1,0,16},{59,0,0,1,0,16},{60,0,0,1,0,16},{61,0,0,1,0,16},{62,0,0,1,0,16},{63,0,0,1,0,16},{64,0,0,1,0,16},{65,0,0,1,0,16},{66,0,0,1,0,16},{67,0,0,1,0,16},{68,0,0,1,0,16},{69,0,0,1,0,16},{70,0,0,1,0,16},{71,0,0,1,0,16},{72,1,0,1,0,16},{57,0,0,1,0,17},{58,0,0,1,0,17},{59,0,0,1,0,17},{60,0,0,1,0,17},{61,0,0,1,0,17},{62,0,0,1,0,17},{63,0,0,1,0,17},{64,0,0,1,0,17},{65,0,0,1,0,17},{66,0,0,1,0,17},{67,0,0,1,0,17},{68,0,0,1,0,17},{69,0,0,1,0,17},{70,0,0,1,0,17},{71,0,0,1,0,17},{72,1,0,1,0,17},{57,0,0,1,0,18},{58,0,0,1,0,18},{59,0,0,1,0,18},{60,0,0,1,0,18},{61,0,0,1,0,18},{62,0,0,1,0,18},{63,0,0,1,0,18},{64,0,0,1,0,18},{65,0,0,1,0,18},{66,0,0,1,0,18},{67,0,0,1,0,18},{68,0,0,1,0,18},{69,0,0,1,0,18},{70,0,0,1,0,18},{71,0,0,1,0,18},{72,1,0,1,0,18},{57,0,0,1,0,19},{58,0,0,1,0,19},{59,0,0,1,0,19},{60,0,0,1,0,19},{61,0,0,1,0,19},{62,0,0,1,0,19},{63,0,0,1,0,19},{64,0,0,1,0,19},{65,0,0,1,0,19},{66,0,0,1,0,19},{67,0,0,1,0,19},{68,0,0,1,0,19},{69,0,0,1,0,19},{70,0,0,1,0,19},{71,0,0,1,0,19},{72,1,0,1,0,19},{57,0,0,1,0,20},{58,0,0,1,0,20},{59,0,0,1,0,20},{60,0,0,1,0,20},{61,0,0,1,0,20},{62,0,0,1,0,20},{63,0,0,1,0,20},{64,0,0,1,0,20},{65,0,0,1,0,20},{66,0,0,1,0,20},{67,0,0,1,0,20},{68,0,0,1,0,20},{69,0,0,1,0,20},{70,0,0,1,0,20},{71,0,0,1,0,20},{72,1,0,1,0,20},{57,0,0,1,0,21},{58,0,0,1,0,21},{59,0,0,1,0,21},{60,0,0,1,0,21},{61,0,0,1,0,21},{62,0,0,1,0,21},{63,0,0,1,0,21},{64,0,0,1,0,21},{65,0,0,1,0,21},{66,0,0,1,0,21},{67,0,0,1,0,21},{68,0,0,1,0,21},{69,0,0,1,0,21},{70,0,0,1,0,21},{71,0,0,1,0,21},{72,1,0,1,0,21},{57,0,0,1,0,23},{58,0,0,1,0,23},{59,0,0,1,0,23},{60,0,0,1,0,23},{61,0,0,1,0,23},{62,0,0,1,0,23},{63,0,0,1,0,23},{64,0,0,1,0,23},{65,0,0,1,0,23},{66,0,0,1,0,23},{67,0,0,1,0,23},{68,0,0,1,0,23},{69,0,0,1,0,23},{70,0,0,1,0,23},{71,0,0,1,0,23},{72,1,0,1,0,23},{57,0,0,1,0,24},{58,0,0,1,0,24},{59,0,0,1,0,24},{60,0,0,1,0,24},{61,0,0,1,0,24},{62,0,0,1,0,24},{63,0,0,1,0,24},{64,0,0,1,0,24},{65,0,0,1,0,24},{66,0,0,1,0,24},{67,0,0,1,0,24},{68,0,0,1,0,24},{69,0,0,1,0,24},{70,0,0,1,0,24},{71,0,0,1,0,24},{72,1,0,1,0,24},{57,0,0,1,0,25},{58,0,0,1,0,25},{59,0,0,1,0,25},{60,0,0,1,0,25},{61,0,0,1,0,25},{62,0,0,1,0,25},{63,0,0,1,0,25},{64,0,0,1,0,25},{65,0,0,1,0,25},{66,0,0,1,0,25},{67,0,0,1,0,25},{68,0,0,1,0,25},{69,0,0,1,0,25},{70,0,0,1,0,25},{71,0,0,1,0,25},{72,1,0,1,0,25},{57,0,0,1,0,26},{58,0,0,1,0,26},{59,0,0,1,0,26},{60,0,0,1,0,26},{61,0,0,1,0,26},{62,0,0,1,0,26},{63,0,0,1,0,26},{64,0,0,1,0,26},{65,0,0,1,0,26},{66,0,0,1,0,26},{67,0,0,1,0,26},{68,0,0,1,0,26},{69,0,0,1,0,26},{70,0,0,1,0,26},{71,0,0,1,0,26},{72,1,0,1,0,26},{57,0,0,1,0,27},{58,0,0,1,0,27},{59,0,0,1,0,27},{60,0,0,1,0,27},{61,0,0,1,0,27},{62,0,0,1,0,27},{63,0,0,1,0,27},{64,0,0,1,0,27},{65,0,0,1,0,27},{66,0,0,1,0,27},{67,0,0,1,0,27},{68,0,0,1,0,27},{69,0,0,1,0,27},{70,0,0,1,0,27},{71,0,0,1,0,27},{72,1,0,1,0,27},{57,0,0,1,0,28},{58,0,0,1,0,28},{59,0,0,1,0,28},{60,0,0,1,0,28},{61,0,0,1,0,28},{62,0,0,1,0,28},{63,0,0,1,0,28},{64,0,0,1,0,28},{65,0,0,1,0,28},{66,0,0,1,0,28},{67,0,0,1,0,28},{68,0,0,1,0,28},{69,0,0,1,0,28},{70,0,0,1,0,28},{71,0,0,1,0,28},{72,1,0,1,0,28},{57,0,0,1,0,29},{58,0,0,1,0,29},{59,0,0,1,0,29},{60,0,0,1,0,29},{61,0,0,1,0,29},{62,0,0,1,0,29},{63,0,0,1,0,29},{64,0,0,1,0,29},{65,0,0,1,0,29},{66,0,0,1,0,29},{67,0,0,1,0,29},{68,0,0,1,0,29},{69,0,0,1,0,29},{70,0,0,1,0,29},{71,0,0,1,0,29},{72,1,0,1,0,29},{57,0,0,1,0,30},{58,0,0,1,0,30},{59,0,0,1,0,30},{60,0,0,1,0,30},{61,0,0,1,0,30},{62,0,0,1,0,30},{63,0,0,1,0,30},{64,0,0,1,0,30},{65,0,0,1,0,30},{66,0,0,1,0,30},{67,0,0,1,0,30},{68,0,0,1,0,30},{69,0,0,1,0,30},{70,0,0,1,0,30},{71,0,0,1,0,30},{72,1,0,1,0,30},{57,0,0,1,0,31},{58,0,0,1,0,31},{59,0,0,1,0,31},{60,0,0,1,0,31},{61,0,0,1,0,31},{62,0,0,1,0,31},{63,0,0,1,0,31},{64,0,0,1,0,31},{65,0,0,1,0,31},{66,0,0,1,0,31},{67,0,0,1,0,31},{68,0,0,1,0,31},{69,0,0,1,0,31},{70,0,0,1,0,31},{71,0,0,1,0,31},{72,1,0,1,0,31},{57,0,0,1,0,127},{58,0,0,1,0,127},{59,0,0,1,0,127},{60,0,0,1,0,127},{61,0,0,1,0,127},{62,0,0,1,0,127},{63,0,0,1,0,127},{64,0,0,1,0,127},{65,0,0,1,0,127},{66,0,0,1,0,127},{67,0,0,1,0,127},{68,0,0,1,0,127},{69,0,0,1,0,127},{70,0,0,1,0,127},{71,0,0,1,0,127},{72,1,0,1,0,127},{57,0,0,1,0,220},{58,0,0,1,0,220},{59,0,0,1,0,220},{60,0,0,1,0,220},{61,0,0,1,0,220},{62,0,0,1,0,220},{63,0,0,1,0,220},{64,0,0,1,0,220},{65,0,0,1,0,220},{66,0,0,1,0,220},{67,0,0,1,0,220},{68,0,0,1,0,220},{69,0,0,1,0,220},{70,0,0,1,0,220},{71,0,0,1,0,220},{72,1,0,1,0,220},{57,0,0,1,0,249},{58,0,0,1,0,249},{59,0,0,1,0,249},{60,0,0,1,0,249},{61,0,0,1,0,249},{62,0,0,1,0,249},{63,0,0,1,0,249},{64,0,0,1,0,249},{65,0,0,1,0,249},{66,0,0,1,0,249},{67,0,0,1,0,249},{68,0,0,1,0,249},{69,0,0,1,0,249},{70,0,0,1,0,249},{71,0,0,1,0,249},{72,1,0,1,0,249},{9,0,0,1,0,10},{10,0,0,1,0,10},{11,0,0,1,0,10},{12,1,0,1,0,10},{9,0,0,1,0,13},{10,0,0,1,0,13},{11,0,0,1,0,13},{12,1,0,1,0,13},{9,0,0,1,0,22},{10,0,0,1,0,22},{11,0,0,1,0,22},{12,1,0,1,0,22},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{57,0,0,1,0,92},{58,0,0,1,0,92},{59,0,0,1,0,92},{60,0,0,1,0,92},{61,0,0,1,0,92},{62,0,0,1,0,92},{63,0,0,1,0,92},{64,0,0,1,0,92},{65,0,0,1,0,92},{66,0,0,1,0,92},{67,0,0,1,0,92},{68,0,0,1,0,92},{69,0,0,1,0,92},{70,0,0,1,0,92},{71,0,0,1,0,92},{72,1,0,1,0,92},{57,0,0,1,0,195},{58,0,0,1,0,195},{59,0,0,1,0,195},{60,0,0,1,0,195},{61,0,0,1,0,195},{62,0,0,1,0,195},{63,0,0,1,0,195},{64,0,0,1,0,195},{65,0,0,1,0,195},{66,0,0,1,0,195},{67,0,0,1,0,195},{68,0,0,1,0,195},{69,0,0,1,0,195},{70,0,0,1,0,195},{71,0,0,1,0,195},{72,1,0,1,0,195},{57,0,0,1,0,208},{58,0,0,1,0,208},{59,0,0,1,0,208},{60,0,0,1,0,208},{61,0,0,1,0,208},{62,0,0,1,0,208},{63,0,0,1,0,208},{64,0,0,1,0,208},{65,0,0,1,0,208},{66,0,0,1,0,208},{67,0,0,1,0,208},{68,0,0,1,0,208},{69,0,0,1,0,208},{70,0,0,1,0,208},{71,0,0,1,0,208},{72,1,0,1,0,208},{1,0,0,1,0,128},{2,0,0,1,0,128},{3,0,0,1,0,128},{4,0,0,1,0,128},{5,0,0,1,0,128},{6,0,0,1,0,128},{7,0,0,1,0,128},{8,1,0,1,0,128},{1,0,0,1,0,130},{2,0,0,1,0,130},{3,0,0,1,0,130},{4,0,0,1,0,130},{5,0,0,1,0,130},{6,0,0,1,0,130},{7,0,0,1,0,130},{8,1,0,1,0,130},{1,0,0,1,0,131},{2,0,0,1,0,131},{3,0,0,1,0,131},{4,0,0,1,0,131},{5,0,0,1,0,131},{6,0,0,1,0,131},{7,0,0,1,0,131},{8,1,0,1,0,131},{1,0,0,1,0,162},{2,0,0,1,0,162},{3,0,0,1,0,162},{4,0,0,1,0,162},{5,0,0,1,0,162},{6,0,0,1,0,162},{7,0,0,1,0,162},{8,1,0,1,0,162},{1,0,0,1,0,184},{2,0,0,1,0,184},{3,0,0,1,0,184},{4,0,0,1,0,184},{5,0,0,1,0,184},{6,0,0,1,0,184},{7,0,0,1,0,184},{8,1,0,1,0,184},{1,0,0,1,0,194},{2,0,0,1,0,194},{3,0,0,1,0,194},{4,0,0,1,0,194},{5,0,0,1,0,194},{6,0,0,1,0,194},{7,0,0,1,0,194},{8,1,0,1,0,194},{1,0,0,1,0,224},{2,0,0,1,0,224},{3,0,0,1,0,224},{4,0,0,1,0,224},{5,0,0,1,0,224},{6,0,0,1,0,224},{7,0,0,1,0,224},{8,1,0,1,0,224},{1,0,0,1,0,226},{2,0,0,1,0,226},{3,0,0,1,0,226},{4,0,0,1,0,226},{5,0,0,1,0,226},{6,0,0,1,0,226},{7,0,0,1,0,226},{8,1,0,1,0,226},{9,0,0,1,0,153},{10,0,0,1,0,153},{11,0,0,1,0,153},{12,1,0,1,0,153},{9,0,0,1,0,161},{10,0,0,1,0,161},{11,0,0,1,0,161},{12,1,0,1,0,161},{9,0,0,1,0,167},{10,0,0,1,0,167},{11,0,0,1,0,167},{12,1,0,1,0,167},{9,0,0,1,0,172},{10,0,0,1,0,172},{11,0,0,1,0,172},{12,1,0,1,0,172},{9,0,0,1,0,176},{10,0,0,1,0,176},{11,0,0,1,0,176},{12,1,0,1,0,176},{9,0,0,1,0,177},{10,0,0,1,0,177},{11,0,0,1,0,177},{12,1,0,1,0,177},{9,0,0,1,0,179},{10,0,0,1,0,179},{11,0,0,1,0,179},{12,1,0,1,0,179},{9,0,0,1,0,209},{10,0,0,1,0,209},{11,0,0,1,0,209},{12,1,0,1,0,209},{9,0,0,1,0,216},{10,0,0,1,0,216},{11,0,0,1,0,216},{12,1,0,1,0,216},{9,0,0,1,0,217},{10,0,0,1,0,217},{11,0,0,1,0,217},{12,1,0,1,0,217},{9,0,0,1,0,227},{10,0,0,1,0,227},{11,0,0,1,0,227},{12,1,0,1,0,227},{9,0,0,1,0,229},{10,0,0,1,0,229},{11,0,0,1,0,229},{12,1,0,1,0,229},{9,0,0,1,0,230},{10,0,0,1,0,230},{11,0,0,1,0,230},{12,1,0,1,0,230},{13,0,0,1,0,129},{14,1,0,1,0,129},{13,0,0,1,0,132},{14,1,0,1,0,132},{13,0,0,1,0,133},{14,1,0,1,0,133},{13,0,0,1,0,134},{14,1,0,1,0,134},{13,0,0,1,0,136},{14,1,0,1,0,136},{13,0,0,1,0,146},{14,1,0,1,0,146},{13,0,0,1,0,154},{14,1,0,1,0,154},{13,0,0,1,0,156},{14,1,0,1,0,156},{13,0,0,1,0,160},{14,1,0,1,0,160},{13,0,0,1,0,163},{14,1,0,1,0,163},{13,0,0,1,0,164},{14,1,0,1,0,164},{13,0,0,1,0,169},{14,1,0,1,0,169},{13,0,0,1,0,170},{14,1,0,1,0,170},{13,0,0,1,0,173},{14,1,0,1,0,173},{13,0,0,1,0,178},{14,1,0,1,0,178},{13,0,0,1,0,181},{14,1,0,1,0,181},{13,0,0,1,0,185},{14,1,0,1,0,185},{13,0,0,1,0,186},{14,1,0,1,0,186},{13,0,0,1,0,187},{14,1,0,1,0,187},{13,0,0,1,0,189},{14,1,0,1,0,189},{13,0,0,1,0,190},{14,1,0,1,0,190},{13,0,0,1,0,196},{14,1,0,1,0,196},{13,0,0,1,0,198},{14,1,0,1,0,198},{13,0,0,1,0,228},{14,1,0,1,0,228},{13,0,0,1,0,232},{14,1,0,1,0,232},{13,0,0,1,0,233},{14,1,0,1,0,233},{0,1,0,1,0,1},{0,1,0,1,0,135},{0,1,0,1,0,137},{0,1,0,1,0,138},{0,1,0,1,0,139},{0,1,0,1,0,140},{0,1,0,1,0,141},{0,1,0,1,0,143},{0,1,0,1,0,147},{0,1,0,1,0,149},{0,1,0,1,0,150},{0,1,0,1,0,151},{0,1,0,1,0,152},{0,1,0,1,0,155},{0,1,0,1,0,157},{0,1,0,1,0,158},{0,1,0,1,0,165},{0,1,0,1,0,166},{0,1,0,1,0,168},{0,1,0,1,0,174},{0,1,0,1,0,175},{0,1,0,1,0,180},{0,1,0,1,0,182},{0,1,0,1,0,183},{0,1,0,1,0,188},{0,1,0,1,0,191},{0,1,0,1,0,197},{0,1,0,1,0,231},{0,1,0,1,0,239},{243,0,0,0,0,0},{244,0,0,0,0,0},{245,0,0,0,0,0},{246,0,0,0,0,0},{247,0,0,0,0,0},{248,0,0,0,0,0},{249,0,0,0,0,0},{250,0,0,0,0,0},{251,0,0,0,0,0},{252,0,0,0,0,0},{253,0,0,0,0,0},{9,0,1,1,1,48},{10,0,1,1,1,48},{11,0,1,1,1,48},{12,1,1,1,1,48},{9,0,1,1,1,49},{10,0,1,1,1,49},{11,0,1,1,1,49},{12,1,1,1,1,49},{9,0,1,1,1,50},{10,0,1,1,1,50},{11,0,1,1,1,50},{12,1,1,1,1,50},{9,0,1,1,1,97},{10,0,1,1,1,97},{11,0,1,1,1,97},{12,1,1,1,1,97},{9,0,1,1,1,99},{10,0,1,1,1,99},{11,0,1,1,1,99},{12,1,1,1,1,99},{9,0,1,1,1,101},{10,0,1,1,1,101},{11,0,1,1,1,101},{12,1,1,1,1,101},{9,0,1,1,1,105},{10,0,1,1,1,105},{11,0,1,1,1,105},{12,1,1,1,1,105},{9,0,1,1,1,111},{10,0,1,1,1,111},{11,0,1,1,1,111},{12,1,1,1,1,111},{9,0,1,1,1,115},{10,0,1,1,1,115},{11,0,1,1,1,115},{12,1,1,1,1,115},{9,0,1,1,1,116},{10,0,1,1,1,116},{11,0,1,1,1,116},{12,1,1,1,1,116},{13,0,1,1,1,32},{14,1,1,1,1,32},{13,0,1,1,1,37},{14,1,1,1,1,37},{13,0,1,1,1,45},{14,1,1,1,1,45},{13,0,1,1,1,46},{14,1,1,1,1,46},{13,0,1,1,1,47},{14,1,1,1,1,47},{13,0,1,1,1,51},{14,1,1,1,1,51},{13,0,1,1,1,52},{14,1,1,1,1,52},{13,0,1,1,1,53},{14,1,1,1,1,53},{13,0,1,1,1,54},{14,1,1,1,1,54},{13,0,1,1,1,55},{14,1,1,1,1,55},{13,0,1,1,1,56},{14,1,1,1,1,56},{13,0,1,1,1,57},{14,1,1,1,1,57},{13,0,1,1,1,61},{14,1,1,1,1,61},{13,0,1,1,1,65},{14,1,1,1,1,65},{13,0,1,1,1,95},{14,1,1,1,1,95},{13,0,1,1,1,98},{14,1,1,1,1,98},{13,0,1,1,1,100},{14,1,1,1,1,100},{13,0,1,1,1,102},{14,1,1,1,1,102},{13,0,1,1,1,103},{14,1,1,1,1,103},{13,0,1,1,1,104},{14,1,1,1,1,104},{13,0,1,1,1,108},{14,1,1,1,1,108},{13,0,1,1,1,109},{14,1,1,1,1,109},{13,0,1,1,1,110},{14,1,1,1,1,110},{13,0,1,1,1,112},{14,1,1,1,1,112},{13,0,1,1,1,114},{14,1,1,1,1,114},{13,0,1,1,1,117},{14,1,1,1,1,117},{0,1,1,1,1,58},{0,1,1,1,1,66},{0,1,1,1,1,67},{0,1,1,1,1,68},{0,1,1,1,1,69},{0,1,1,1,1,70},{0,1,1,1,1,71},{0,1,1,1,1,72},{0,1,1,1,1,73},{0,1,1,1,1,74},{0,1,1,1,1,75},{0,1,1,1,1,76},{0,1,1,1,1,77},{0,1,1,1,1,78},{0,1,1,1,1,79},{0,1,1,1,1,80},{0,1,1,1,1,81},{0,1,1,1,1,82},{0,1,1,1,1,83},{0,1,1,1,1,84},{0,1,1,1,1,85},{0,1,1,1,1,86},{0,1,1,1,1,87},{0,1,1,1,1,89},{0,1,1,1,1,106},{0,1,1,1,1,107},{0,1,1,1,1,113},{0,1,1,1,1,118},{0,1,1,1,1,119},{0,1,1,1,1,120},{0,1,1,1,1,121},{0,1,1,1,1,122},{85,0,0,1,0,1},{86,0,0,1,0,1},{87,0,0,1,0,1},{88,1,0,1,0,1},{9,0,1,1,135,48},{10,0,1,1,135,48},{11,0,1,1,135,48},{12,1,1,1,135,48},{9,0,1,1,135,49},{10,0,1,1,135,49},{11,0,1,1,135,49},{12,1,1,1,135,49},{9,0,1,1,135,50},{10,0,1,1,135,50},{11,0,1,1,135,50},{12,1,1,1,135,50},{9,0,1,1,135,97},{10,0,1,1,135,97},{11,0,1,1,135,97},{12,1,1,1,135,97},{9,0,1,1,135,99},{10,0,1,1,135,99},{11,0,1,1,135,99},{12,1,1,1,135,99},{9,0,1,1,135,101},{10,0,1,1,135,101},{11,0,1,1,135,101},{12,1,1,1,135,101},{9,0,1,1,135,105},{10,0,1,1,135,105},{11,0,1,1,135,105},{12,1,1,1,135,105},{9,0,1,1,135,111},{10,0,1,1,135,111},{11,0,1,1,135,111},{12,1,1,1,135,111},{9,0,1,1,135,115},{10,0,1,1,135,115},{11,0,1,1,135,115},{12,1,1,1,135,115},{9,0,1,1,135,116},{10,0,1,1,135,116},{11,0,1,1,135,116},{12,1,1,1,135,116},{13,0,1,1,135,32},{14,1,1,1,135,32},{13,0,1,1,135,37},{14,1,1,1,135,37},{13,0,1,1,135,45},{14,1,1,1,135,45},{13,0,1,1,135,46},{14,1,1,1,135,46},{13,0,1,1,135,47},{14,1,1,1,135,47},{13,0,1,1,135,51},{14,1,1,1,135,51},{13,0,1,1,135,52},{14,1,1,1,135,52},{13,0,1,1,135,53},{14,1,1,1,135,53},{13,0,1,1,135,54},{14,1,1,1,135,54},{13,0,1,1,135,55},{14,1,1,1,135,55},{13,0,1,1,135,56},{14,1,1,1,135,56},{13,0,1,1,135,57},{14,1,1,1,135,57},{13,0,1,1,135,61},{14,1,1,1,135,61},{13,0,1,1,135,65},{14,1,1,1,135,65},{13,0,1,1,135,95},{14,1,1,1,135,95},{13,0,1,1,135,98},{14,1,1,1,135,98},{13,0,1,1,135,100},{14,1,1,1,135,100},{13,0,1,1,135,102},{14,1,1,1,135,102},{13,0,1,1,135,103},{14,1,1,1,135,103},{13,0,1,1,135,104},{14,1,1,1,135,104},{13,0,1,1,135,108},{14,1,1,1,135,108},{13,0,1,1,135,109},{14,1,1,1,135,109},{13,0,1,1,135,110},{14,1,1,1,135,110},{13,0,1,1,135,112},{14,1,1,1,135,112},{13,0,1,1,135,114},{14,1,1,1,135,114},{13,0,1,1,135,117},{14,1,1,1,135,117},{0,1,1,1,135,58},{0,1,1,1,135,66},{0,1,1,1,135,67},{0,1,1,1,135,68},{0,1,1,1,135,69},{0,1,1,1,135,70},{0,1,1,1,135,71},{0,1,1,1,135,72},{0,1,1,1,135,73},{0,1,1,1,135,74},{0,1,1,1,135,75},{0,1,1,1,135,76},{0,1,1,1,135,77},{0,1,1,1,135,78},{0,1,1,1,135,79},{0,1,1,1,135,80},{0,1,1,1,135,81},{0,1,1,1,135,82},{0,1,1,1,135,83},{0,1,1,1,135,84},{0,1,1,1,135,85},{0,1,1,1,135,86},{0,1,1,1,135,87},{0,1,1,1,135,89},{0,1,1,1,135,106},{0,1,1,1,135,107},{0,1,1,1,135,113},{0,1,1,1,135,118},{0,1,1,1,135,119},{0,1,1,1,135,120},{0,1,1,1,135,121},{0,1,1,1,135,122},{85,0,0,1,0,135},{86,0,0,1,0,135},{87,0,0,1,0,135},{88,1,0,1,0,135},{9,0,1,1,137,48},{10,0,1,1,137,48},{11,0,1,1,137,48},{12,1,1,1,137,48},{9,0,1,1,137,49},{10,0,1,1,137,49},{11,0,1,1,137,49},{12,1,1,1,137,49},{9,0,1,1,137,50},{10,0,1,1,137,50},{11,0,1,1,137,50},{12,1,1,1,137,50},{9,0,1,1,137,97},{10,0,1,1,137,97},{11,0,1,1,137,97},{12,1,1,1,137,97},{9,0,1,1,137,99},{10,0,1,1,137,99},{11,0,1,1,137,99},{12,1,1,1,137,99},{9,0,1,1,137,101},{10,0,1,1,137,101},{11,0,1,1,137,101},{12,1,1,1,137,101},{9,0,1,1,137,105},{10,0,1,1,137,105},{11,0,1,1,137,105},{12,1,1,1,137,105},{9,0,1,1,137,111},{10,0,1,1,137,111},{11,0,1,1,137,111},{12,1,1,1,137,111},{9,0,1,1,137,115},{10,0,1,1,137,115},{11,0,1,1,137,115},{12,1,1,1,137,115},{9,0,1,1,137,116},{10,0,1,1,137,116},{11,0,1,1,137,116},{12,1,1,1,137,116},{13,0,1,1,137,32},{14,1,1,1,137,32},{13,0,1,1,137,37},{14,1,1,1,137,37},{13,0,1,1,137,45},{14,1,1,1,137,45},{13,0,1,1,137,46},{14,1,1,1,137,46},{13,0,1,1,137,47},{14,1,1,1,137,47},{13,0,1,1,137,51},{14,1,1,1,137,51},{13,0,1,1,137,52},{14,1,1,1,137,52},{13,0,1,1,137,53},{14,1,1,1,137,53},{13,0,1,1,137,54},{14,1,1,1,137,54},{13,0,1,1,137,55},{14,1,1,1,137,55},{13,0,1,1,137,56},{14,1,1,1,137,56},{13,0,1,1,137,57},{14,1,1,1,137,57},{13,0,1,1,137,61},{14,1,1,1,137,61},{13,0,1,1,137,65},{14,1,1,1,137,65},{13,0,1,1,137,95},{14,1,1,1,137,95},{13,0,1,1,137,98},{14,1,1,1,137,98},{13,0,1,1,137,100},{14,1,1,1,137,100},{13,0,1,1,137,102},{14,1,1,1,137,102},{13,0,1,1,137,103},{14,1,1,1,137,103},{13,0,1,1,137,104},{14,1,1,1,137,104},{13,0,1,1,137,108},{14,1,1,1,137,108},{13,0,1,1,137,109},{14,1,1,1,137,109},{13,0,1,1,137,110},{14,1,1,1,137,110},{13,0,1,1,137,112},{14,1,1,1,137,112},{13,0,1,1,137,114},{14,1,1,1,137,114},{13,0,1,1,137,117},{14,1,1,1,137,117},{0,1,1,1,137,58},{0,1,1,1,137,66},{0,1,1,1,137,67},{0,1,1,1,137,68},{0,1,1,1,137,69},{0,1,1,1,137,70},{0,1,1,1,137,71},{0,1,1,1,137,72},{0,1,1,1,137,73},{0,1,1,1,137,74},{0,1,1,1,137,75},{0,1,1,1,137,76},{0,1,1,1,137,77},{0,1,1,1,137,78},{0,1,1,1,137,79},{0,1,1,1,137,80},{0,1,1,1,137,81},{0,1,1,1,137,82},{0,1,1,1,137,83},{0,1,1,1,137,84},{0,1,1,1,137,85},{0,1,1,1,137,86},{0,1,1,1,137,87},{0,1,1,1,137,89},{0,1,1,1,137,106},{0,1,1,1,137,107},{0,1,1,1,137,113},{0,1,1,1,137,118},{0,1,1,1,137,119},{0,1,1,1,137,120},{0,1,1,1,137,121},{0,1,1,1,137,122},{85,0,0,1,0,137},{86,0,0,1,0,137},{87,0,0,1,0,137},{88,1,0,1,0,137},{9,0,1,1,138,48},{10,0,1,1,138,48},{11,0,1,1,138,48},{12,1,1,1,138,48},{9,0,1,1,138,49},{10,0,1,1,138,49},{11,0,1,1,138,49},{12,1,1,1,138,49},{9,0,1,1,138,50},{10,0,1,1,138,50},{11,0,1,1,138,50},{12,1,1,1,138,50},{9,0,1,1,138,97},{10,0,1,1,138,97},{11,0,1,1,138,97},{12,1,1,1,138,97},{9,0,1,1,138,99},{10,0,1,1,138,99},{11,0,1,1,138,99},{12,1,1,1,138,99},{9,0,1,1,138,101},{10,0,1,1,138,101},{11,0,1,1,138,101},{12,1,1,1,138,101},{9,0,1,1,138,105},{10,0,1,1,138,105},{11,0,1,1,138,105},{12,1,1,1,138,105},{9,0,1,1,138,111},{10,0,1,1,138,111},{11,0,1,1,138,111},{12,1,1,1,138,111},{9,0,1,1,138,115},{10,0,1,1,138,115},{11,0,1,1,138,115},{12,1,1,1,138,115},{9,0,1,1,138,116},{10,0,1,1,138,116},{11,0,1,1,138,116},{12,1,1,1,138,116},{13,0,1,1,138,32},{14,1,1,1,138,32},{13,0,1,1,138,37},{14,1,1,1,138,37},{13,0,1,1,138,45},{14,1,1,1,138,45},{13,0,1,1,138,46},{14,1,1,1,138,46},{13,0,1,1,138,47},{14,1,1,1,138,47},{13,0,1,1,138,51},{14,1,1,1,138,51},{13,0,1,1,138,52},{14,1,1,1,138,52},{13,0,1,1,138,53},{14,1,1,1,138,53},{13,0,1,1,138,54},{14,1,1,1,138,54},{13,0,1,1,138,55},{14,1,1,1,138,55},{13,0,1,1,138,56},{14,1,1,1,138,56},{13,0,1,1,138,57},{14,1,1,1,138,57},{13,0,1,1,138,61},{14,1,1,1,138,61},{13,0,1,1,138,65},{14,1,1,1,138,65},{13,0,1,1,138,95},{14,1,1,1,138,95},{13,0,1,1,138,98},{14,1,1,1,138,98},{13,0,1,1,138,100},{14,1,1,1,138,100},{13,0,1,1,138,102},{14,1,1,1,138,102},{13,0,1,1,138,103},{14,1,1,1,138,103},{13,0,1,1,138,104},{14,1,1,1,138,104},{13,0,1,1,138,108},{14,1,1,1,138,108},{13,0,1,1,138,109},{14,1,1,1,138,109},{13,0,1,1,138,110},{14,1,1,1,138,110},{13,0,1,1,138,112},{14,1,1,1,138,112},{13,0,1,1,138,114},{14,1,1,1,138,114},{13,0,1,1,138,117},{14,1,1,1,138,117},{0,1,1,1,138,58},{0,1,1,1,138,66},{0,1,1,1,138,67},{0,1,1,1,138,68},{0,1,1,1,138,69},{0,1,1,1,138,70},{0,1,1,1,138,71},{0,1,1,1,138,72},{0,1,1,1,138,73},{0,1,1,1,138,74},{0,1,1,1,138,75},{0,1,1,1,138,76},{0,1,1,1,138,77},{0,1,1,1,138,78},{0,1,1,1,138,79},{0,1,1,1,138,80},{0,1,1,1,138,81},{0,1,1,1,138,82},{0,1,1,1,138,83},{0,1,1,1,138,84},{0,1,1,1,138,85},{0,1,1,1,138,86},{0,1,1,1,138,87},{0,1,1,1,138,89},{0,1,1,1,138,106},{0,1,1,1,138,107},{0,1,1,1,138,113},{0,1,1,1,138,118},{0,1,1,1,138,119},{0,1,1,1,138,120},{0,1,1,1,138,121},{0,1,1,1,138,122},{85,0,0,1,0,138},{86,0,0,1,0,138},{87,0,0,1,0,138},{88,1,0,1,0,138},{9,0,1,1,139,48},{10,0,1,1,139,48},{11,0,1,1,139,48},{12,1,1,1,139,48},{9,0,1,1,139,49},{10,0,1,1,139,49},{11,0,1,1,139,49},{12,1,1,1,139,49},{9,0,1,1,139,50},{10,0,1,1,139,50},{11,0,1,1,139,50},{12,1,1,1,139,50},{9,0,1,1,139,97},{10,0,1,1,139,97},{11,0,1,1,139,97},{12,1,1,1,139,97},{9,0,1,1,139,99},{10,0,1,1,139,99},{11,0,1,1,139,99},{12,1,1,1,139,99},{9,0,1,1,139,101},{10,0,1,1,139,101},{11,0,1,1,139,101},{12,1,1,1,139,101},{9,0,1,1,139,105},{10,0,1,1,139,105},{11,0,1,1,139,105},{12,1,1,1,139,105},{9,0,1,1,139,111},{10,0,1,1,139,111},{11,0,1,1,139,111},{12,1,1,1,139,111},{9,0,1,1,139,115},{10,0,1,1,139,115},{11,0,1,1,139,115},{12,1,1,1,139,115},{9,0,1,1,139,116},{10,0,1,1,139,116},{11,0,1,1,139,116},{12,1,1,1,139,116},{13,0,1,1,139,32},{14,1,1,1,139,32},{13,0,1,1,139,37},{14,1,1,1,139,37},{13,0,1,1,139,45},{14,1,1,1,139,45},{13,0,1,1,139,46},{14,1,1,1,139,46},{13,0,1,1,139,47},{14,1,1,1,139,47},{13,0,1,1,139,51},{14,1,1,1,139,51},{13,0,1,1,139,52},{14,1,1,1,139,52},{13,0,1,1,139,53},{14,1,1,1,139,53},{13,0,1,1,139,54},{14,1,1,1,139,54},{13,0,1,1,139,55},{14,1,1,1,139,55},{13,0,1,1,139,56},{14,1,1,1,139,56},{13,0,1,1,139,57},{14,1,1,1,139,57},{13,0,1,1,139,61},{14,1,1,1,139,61},{13,0,1,1,139,65},{14,1,1,1,139,65},{13,0,1,1,139,95},{14,1,1,1,139,95},{13,0,1,1,139,98},{14,1,1,1,139,98},{13,0,1,1,139,100},{14,1,1,1,139,100},{13,0,1,1,139,102},{14,1,1,1,139,102},{13,0,1,1,139,103},{14,1,1,1,139,103},{13,0,1,1,139,104},{14,1,1,1,139,104},{13,0,1,1,139,108},{14,1,1,1,139,108},{13,0,1,1,139,109},{14,1,1,1,139,109},{13,0,1,1,139,110},{14,1,1,1,139,110},{13,0,1,1,139,112},{14,1,1,1,139,112},{13,0,1,1,139,114},{14,1,1,1,139,114},{13,0,1,1,139,117},{14,1,1,1,139,117},{0,1,1,1,139,58},{0,1,1,1,139,66},{0,1,1,1,139,67},{0,1,1,1,139,68},{0,1,1,1,139,69},{0,1,1,1,139,70},{0,1,1,1,139,71},{0,1,1,1,139,72},{0,1,1,1,139,73},{0,1,1,1,139,74},{0,1,1,1,139,75},{0,1,1,1,139,76},{0,1,1,1,139,77},{0,1,1,1,139,78},{0,1,1,1,139,79},{0,1,1,1,139,80},{0,1,1,1,139,81},{0,1,1,1,139,82},{0,1,1,1,139,83},{0,1,1,1,139,84},{0,1,1,1,139,85},{0,1,1,1,139,86},{0,1,1,1,139,87},{0,1,1,1,139,89},{0,1,1,1,139,106},{0,1,1,1,139,107},{0,1,1,1,139,113},{0,1,1,1,139,118},{0,1,1,1,139,119},{0,1,1,1,139,120},{0,1,1,1,139,121},{0,1,1,1,139,122},{85,0,0,1,0,139},{86,0,0,1,0,139},{87,0,0,1,0,139},{88,1,0,1,0,139},{9,0,1,1,140,48},{10,0,1,1,140,48},{11,0,1,1,140,48},{12,1,1,1,140,48},{9,0,1,1,140,49},{10,0,1,1,140,49},{11,0,1,1,140,49},{12,1,1,1,140,49},{9,0,1,1,140,50},{10,0,1,1,140,50},{11,0,1,1,140,50},{12,1,1,1,140,50},{9,0,1,1,140,97},{10,0,1,1,140,97},{11,0,1,1,140,97},{12,1,1,1,140,97},{9,0,1,1,140,99},{10,0,1,1,140,99},{11,0,1,1,140,99},{12,1,1,1,140,99},{9,0,1,1,140,101},{10,0,1,1,140,101},{11,0,1,1,140,101},{12,1,1,1,140,101},{9,0,1,1,140,105},{10,0,1,1,140,105},{11,0,1,1,140,105},{12,1,1,1,140,105},{9,0,1,1,140,111},{10,0,1,1,140,111},{11,0,1,1,140,111},{12,1,1,1,140,111},{9,0,1,1,140,115},{10,0,1,1,140,115},{11,0,1,1,140,115},{12,1,1,1,140,115},{9,0,1,1,140,116},{10,0,1,1,140,116},{11,0,1,1,140,116},{12,1,1,1,140,116},{13,0,1,1,140,32},{14,1,1,1,140,32},{13,0,1,1,140,37},{14,1,1,1,140,37},{13,0,1,1,140,45},{14,1,1,1,140,45},{13,0,1,1,140,46},{14,1,1,1,140,46},{13,0,1,1,140,47},{14,1,1,1,140,47},{13,0,1,1,140,51},{14,1,1,1,140,51},{13,0,1,1,140,52},{14,1,1,1,140,52},{13,0,1,1,140,53},{14,1,1,1,140,53},{13,0,1,1,140,54},{14,1,1,1,140,54},{13,0,1,1,140,55},{14,1,1,1,140,55},{13,0,1,1,140,56},{14,1,1,1,140,56},{13,0,1,1,140,57},{14,1,1,1,140,57},{13,0,1,1,140,61},{14,1,1,1,140,61},{13,0,1,1,140,65},{14,1,1,1,140,65},{13,0,1,1,140,95},{14,1,1,1,140,95},{13,0,1,1,140,98},{14,1,1,1,140,98},{13,0,1,1,140,100},{14,1,1,1,140,100},{13,0,1,1,140,102},{14,1,1,1,140,102},{13,0,1,1,140,103},{14,1,1,1,140,103},{13,0,1,1,140,104},{14,1,1,1,140,104},{13,0,1,1,140,108},{14,1,1,1,140,108},{13,0,1,1,140,109},{14,1,1,1,140,109},{13,0,1,1,140,110},{14,1,1,1,140,110},{13,0,1,1,140,112},{14,1,1,1,140,112},{13,0,1,1,140,114},{14,1,1,1,140,114},{13,0,1,1,140,117},{14,1,1,1,140,117},{0,1,1,1,140,58},{0,1,1,1,140,66},{0,1,1,1,140,67},{0,1,1,1,140,68},{0,1,1,1,140,69},{0,1,1,1,140,70},{0,1,1,1,140,71},{0,1,1,1,140,72},{0,1,1,1,140,73},{0,1,1,1,140,74},{0,1,1,1,140,75},{0,1,1,1,140,76},{0,1,1,1,140,77},{0,1,1,1,140,78},{0,1,1,1,140,79},{0,1,1,1,140,80},{0,1,1,1,140,81},{0,1,1,1,140,82},{0,1,1,1,140,83},{0,1,1,1,140,84},{0,1,1,1,140,85},{0,1,1,1,140,86},{0,1,1,1,140,87},{0,1,1,1,140,89},{0,1,1,1,140,106},{0,1,1,1,140,107},{0,1,1,1,140,113},{0,1,1,1,140,118},{0,1,1,1,140,119},{0,1,1,1,140,120},{0,1,1,1,140,121},{0,1,1,1,140,122},{85,0,0,1,0,140},{86,0,0,1,0,140},{87,0,0,1,0,140},{88,1,0,1,0,140},{9,0,1,1,141,48},{10,0,1,1,141,48},{11,0,1,1,141,48},{12,1,1,1,141,48},{9,0,1,1,141,49},{10,0,1,1,141,49},{11,0,1,1,141,49},{12,1,1,1,141,49},{9,0,1,1,141,50},{10,0,1,1,141,50},{11,0,1,1,141,50},{12,1,1,1,141,50},{9,0,1,1,141,97},{10,0,1,1,141,97},{11,0,1,1,141,97},{12,1,1,1,141,97},{9,0,1,1,141,99},{10,0,1,1,141,99},{11,0,1,1,141,99},{12,1,1,1,141,99},{9,0,1,1,141,101},{10,0,1,1,141,101},{11,0,1,1,141,101},{12,1,1,1,141,101},{9,0,1,1,141,105},{10,0,1,1,141,105},{11,0,1,1,141,105},{12,1,1,1,141,105},{9,0,1,1,141,111},{10,0,1,1,141,111},{11,0,1,1,141,111},{12,1,1,1,141,111},{9,0,1,1,141,115},{10,0,1,1,141,115},{11,0,1,1,141,115},{12,1,1,1,141,115},{9,0,1,1,141,116},{10,0,1,1,141,116},{11,0,1,1,141,116},{12,1,1,1,141,116},{13,0,1,1,141,32},{14,1,1,1,141,32},{13,0,1,1,141,37},{14,1,1,1,141,37},{13,0,1,1,141,45},{14,1,1,1,141,45},{13,0,1,1,141,46},{14,1,1,1,141,46},{13,0,1,1,141,47},{14,1,1,1,141,47},{13,0,1,1,141,51},{14,1,1,1,141,51},{13,0,1,1,141,52},{14,1,1,1,141,52},{13,0,1,1,141,53},{14,1,1,1,141,53},{13,0,1,1,141,54},{14,1,1,1,141,54},{13,0,1,1,141,55},{14,1,1,1,141,55},{13,0,1,1,141,56},{14,1,1,1,141,56},{13,0,1,1,141,57},{14,1,1,1,141,57},{13,0,1,1,141,61},{14,1,1,1,141,61},{13,0,1,1,141,65},{14,1,1,1,141,65},{13,0,1,1,141,95},{14,1,1,1,141,95},{13,0,1,1,141,98},{14,1,1,1,141,98},{13,0,1,1,141,100},{14,1,1,1,141,100},{13,0,1,1,141,102},{14,1,1,1,141,102},{13,0,1,1,141,103},{14,1,1,1,141,103},{13,0,1,1,141,104},{14,1,1,1,141,104},{13,0,1,1,141,108},{14,1,1,1,141,108},{13,0,1,1,141,109},{14,1,1,1,141,109},{13,0,1,1,141,110},{14,1,1,1,141,110},{13,0,1,1,141,112},{14,1,1,1,141,112},{13,0,1,1,141,114},{14,1,1,1,141,114},{13,0,1,1,141,117},{14,1,1,1,141,117},{0,1,1,1,141,58},{0,1,1,1,141,66},{0,1,1,1,141,67},{0,1,1,1,141,68},{0,1,1,1,141,69},{0,1,1,1,141,70},{0,1,1,1,141,71},{0,1,1,1,141,72},{0,1,1,1,141,73},{0,1,1,1,141,74},{0,1,1,1,141,75},{0,1,1,1,141,76},{0,1,1,1,141,77},{0,1,1,1,141,78},{0,1,1,1,141,79},{0,1,1,1,141,80},{0,1,1,1,141,81},{0,1,1,1,141,82},{0,1,1,1,141,83},{0,1,1,1,141,84},{0,1,1,1,141,85},{0,1,1,1,141,86},{0,1,1,1,141,87},{0,1,1,1,141,89},{0,1,1,1,141,106},{0,1,1,1,141,107},{0,1,1,1,141,113},{0,1,1,1,141,118},{0,1,1,1,141,119},{0,1,1,1,141,120},{0,1,1,1,141,121},{0,1,1,1,141,122},{85,0,0,1,0,141},{86,0,0,1,0,141},{87,0,0,1,0,141},{88,1,0,1,0,141},{9,0,1,1,143,48},{10,0,1,1,143,48},{11,0,1,1,143,48},{12,1,1,1,143,48},{9,0,1,1,143,49},{10,0,1,1,143,49},{11,0,1,1,143,49},{12,1,1,1,143,49},{9,0,1,1,143,50},{10,0,1,1,143,50},{11,0,1,1,143,50},{12,1,1,1,143,50},{9,0,1,1,143,97},{10,0,1,1,143,97},{11,0,1,1,143,97},{12,1,1,1,143,97},{9,0,1,1,143,99},{10,0,1,1,143,99},{11,0,1,1,143,99},{12,1,1,1,143,99},{9,0,1,1,143,101},{10,0,1,1,143,101},{11,0,1,1,143,101},{12,1,1,1,143,101},{9,0,1,1,143,105},{10,0,1,1,143,105},{11,0,1,1,143,105},{12,1,1,1,143,105},{9,0,1,1,143,111},{10,0,1,1,143,111},{11,0,1,1,143,111},{12,1,1,1,143,111},{9,0,1,1,143,115},{10,0,1,1,143,115},{11,0,1,1,143,115},{12,1,1,1,143,115},{9,0,1,1,143,116},{10,0,1,1,143,116},{11,0,1,1,143,116},{12,1,1,1,143,116},{13,0,1,1,143,32},{14,1,1,1,143,32},{13,0,1,1,143,37},{14,1,1,1,143,37},{13,0,1,1,143,45},{14,1,1,1,143,45},{13,0,1,1,143,46},{14,1,1,1,143,46},{13,0,1,1,143,47},{14,1,1,1,143,47},{13,0,1,1,143,51},{14,1,1,1,143,51},{13,0,1,1,143,52},{14,1,1,1,143,52},{13,0,1,1,143,53},{14,1,1,1,143,53},{13,0,1,1,143,54},{14,1,1,1,143,54},{13,0,1,1,143,55},{14,1,1,1,143,55},{13,0,1,1,143,56},{14,1,1,1,143,56},{13,0,1,1,143,57},{14,1,1,1,143,57},{13,0,1,1,143,61},{14,1,1,1,143,61},{13,0,1,1,143,65},{14,1,1,1,143,65},{13,0,1,1,143,95},{14,1,1,1,143,95},{13,0,1,1,143,98},{14,1,1,1,143,98},{13,0,1,1,143,100},{14,1,1,1,143,100},{13,0,1,1,143,102},{14,1,1,1,143,102},{13,0,1,1,143,103},{14,1,1,1,143,103},{13,0,1,1,143,104},{14,1,1,1,143,104},{13,0,1,1,143,108},{14,1,1,1,143,108},{13,0,1,1,143,109},{14,1,1,1,143,109},{13,0,1,1,143,110},{14,1,1,1,143,110},{13,0,1,1,143,112},{14,1,1,1,143,112},{13,0,1,1,143,114},{14,1,1,1,143,114},{13,0,1,1,143,117},{14,1,1,1,143,117},{0,1,1,1,143,58},{0,1,1,1,143,66},{0,1,1,1,143,67},{0,1,1,1,143,68},{0,1,1,1,143,69},{0,1,1,1,143,70},{0,1,1,1,143,71},{0,1,1,1,143,72},{0,1,1,1,143,73},{0,1,1,1,143,74},{0,1,1,1,143,75},{0,1,1,1,143,76},{0,1,1,1,143,77},{0,1,1,1,143,78},{0,1,1,1,143,79},{0,1,1,1,143,80},{0,1,1,1,143,81},{0,1,1,1,143,82},{0,1,1,1,143,83},{0,1,1,1,143,84},{0,1,1,1,143,85},{0,1,1,1,143,86},{0,1,1,1,143,87},{0,1,1,1,143,89},{0,1,1,1,143,106},{0,1,1,1,143,107},{0,1,1,1,143,113},{0,1,1,1,143,118},{0,1,1,1,143,119},{0,1,1,1,143,120},{0,1,1,1,143,121},{0,1,1,1,143,122},{85,0,0,1,0,143},{86,0,0,1,0,143},{87,0,0,1,0,143},{88,1,0,1,0,143},{9,0,1,1,147,48},{10,0,1,1,147,48},{11,0,1,1,147,48},{12,1,1,1,147,48},{9,0,1,1,147,49},{10,0,1,1,147,49},{11,0,1,1,147,49},{12,1,1,1,147,49},{9,0,1,1,147,50},{10,0,1,1,147,50},{11,0,1,1,147,50},{12,1,1,1,147,50},{9,0,1,1,147,97},{10,0,1,1,147,97},{11,0,1,1,147,97},{12,1,1,1,147,97},{9,0,1,1,147,99},{10,0,1,1,147,99},{11,0,1,1,147,99},{12,1,1,1,147,99},{9,0,1,1,147,101},{10,0,1,1,147,101},{11,0,1,1,147,101},{12,1,1,1,147,101},{9,0,1,1,147,105},{10,0,1,1,147,105},{11,0,1,1,147,105},{12,1,1,1,147,105},{9,0,1,1,147,111},{10,0,1,1,147,111},{11,0,1,1,147,111},{12,1,1,1,147,111},{9,0,1,1,147,115},{10,0,1,1,147,115},{11,0,1,1,147,115},{12,1,1,1,147,115},{9,0,1,1,147,116},{10,0,1,1,147,116},{11,0,1,1,147,116},{12,1,1,1,147,116},{13,0,1,1,147,32},{14,1,1,1,147,32},{13,0,1,1,147,37},{14,1,1,1,147,37},{13,0,1,1,147,45},{14,1,1,1,147,45},{13,0,1,1,147,46},{14,1,1,1,147,46},{13,0,1,1,147,47},{14,1,1,1,147,47},{13,0,1,1,147,51},{14,1,1,1,147,51},{13,0,1,1,147,52},{14,1,1,1,147,52},{13,0,1,1,147,53},{14,1,1,1,147,53},{13,0,1,1,147,54},{14,1,1,1,147,54},{13,0,1,1,147,55},{14,1,1,1,147,55},{13,0,1,1,147,56},{14,1,1,1,147,56},{13,0,1,1,147,57},{14,1,1,1,147,57},{13,0,1,1,147,61},{14,1,1,1,147,61},{13,0,1,1,147,65},{14,1,1,1,147,65},{13,0,1,1,147,95},{14,1,1,1,147,95},{13,0,1,1,147,98},{14,1,1,1,147,98},{13,0,1,1,147,100},{14,1,1,1,147,100},{13,0,1,1,147,102},{14,1,1,1,147,102},{13,0,1,1,147,103},{14,1,1,1,147,103},{13,0,1,1,147,104},{14,1,1,1,147,104},{13,0,1,1,147,108},{14,1,1,1,147,108},{13,0,1,1,147,109},{14,1,1,1,147,109},{13,0,1,1,147,110},{14,1,1,1,147,110},{13,0,1,1,147,112},{14,1,1,1,147,112},{13,0,1,1,147,114},{14,1,1,1,147,114},{13,0,1,1,147,117},{14,1,1,1,147,117},{0,1,1,1,147,58},{0,1,1,1,147,66},{0,1,1,1,147,67},{0,1,1,1,147,68},{0,1,1,1,147,69},{0,1,1,1,147,70},{0,1,1,1,147,71},{0,1,1,1,147,72},{0,1,1,1,147,73},{0,1,1,1,147,74},{0,1,1,1,147,75},{0,1,1,1,147,76},{0,1,1,1,147,77},{0,1,1,1,147,78},{0,1,1,1,147,79},{0,1,1,1,147,80},{0,1,1,1,147,81},{0,1,1,1,147,82},{0,1,1,1,147,83},{0,1,1,1,147,84},{0,1,1,1,147,85},{0,1,1,1,147,86},{0,1,1,1,147,87},{0,1,1,1,147,89},{0,1,1,1,147,106},{0,1,1,1,147,107},{0,1,1,1,147,113},{0,1,1,1,147,118},{0,1,1,1,147,119},{0,1,1,1,147,120},{0,1,1,1,147,121},{0,1,1,1,147,122},{85,0,0,1,0,147},{86,0,0,1,0,147},{87,0,0,1,0,147},{88,1,0,1,0,147},{9,0,1,1,149,48},{10,0,1,1,149,48},{11,0,1,1,149,48},{12,1,1,1,149,48},{9,0,1,1,149,49},{10,0,1,1,149,49},{11,0,1,1,149,49},{12,1,1,1,149,49},{9,0,1,1,149,50},{10,0,1,1,149,50},{11,0,1,1,149,50},{12,1,1,1,149,50},{9,0,1,1,149,97},{10,0,1,1,149,97},{11,0,1,1,149,97},{12,1,1,1,149,97},{9,0,1,1,149,99},{10,0,1,1,149,99},{11,0,1,1,149,99},{12,1,1,1,149,99},{9,0,1,1,149,101},{10,0,1,1,149,101},{11,0,1,1,149,101},{12,1,1,1,149,101},{9,0,1,1,149,105},{10,0,1,1,149,105},{11,0,1,1,149,105},{12,1,1,1,149,105},{9,0,1,1,149,111},{10,0,1,1,149,111},{11,0,1,1,149,111},{12,1,1,1,149,111},{9,0,1,1,149,115},{10,0,1,1,149,115},{11,0,1,1,149,115},{12,1,1,1,149,115},{9,0,1,1,149,116},{10,0,1,1,149,116},{11,0,1,1,149,116},{12,1,1,1,149,116},{13,0,1,1,149,32},{14,1,1,1,149,32},{13,0,1,1,149,37},{14,1,1,1,149,37},{13,0,1,1,149,45},{14,1,1,1,149,45},{13,0,1,1,149,46},{14,1,1,1,149,46},{13,0,1,1,149,47},{14,1,1,1,149,47},{13,0,1,1,149,51},{14,1,1,1,149,51},{13,0,1,1,149,52},{14,1,1,1,149,52},{13,0,1,1,149,53},{14,1,1,1,149,53},{13,0,1,1,149,54},{14,1,1,1,149,54},{13,0,1,1,149,55},{14,1,1,1,149,55},{13,0,1,1,149,56},{14,1,1,1,149,56},{13,0,1,1,149,57},{14,1,1,1,149,57},{13,0,1,1,149,61},{14,1,1,1,149,61},{13,0,1,1,149,65},{14,1,1,1,149,65},{13,0,1,1,149,95},{14,1,1,1,149,95},{13,0,1,1,149,98},{14,1,1,1,149,98},{13,0,1,1,149,100},{14,1,1,1,149,100},{13,0,1,1,149,102},{14,1,1,1,149,102},{13,0,1,1,149,103},{14,1,1,1,149,103},{13,0,1,1,149,104},{14,1,1,1,149,104},{13,0,1,1,149,108},{14,1,1,1,149,108},{13,0,1,1,149,109},{14,1,1,1,149,109},{13,0,1,1,149,110},{14,1,1,1,149,110},{13,0,1,1,149,112},{14,1,1,1,149,112},{13,0,1,1,149,114},{14,1,1,1,149,114},{13,0,1,1,149,117},{14,1,1,1,149,117},{0,1,1,1,149,58},{0,1,1,1,149,66},{0,1,1,1,149,67},{0,1,1,1,149,68},{0,1,1,1,149,69},{0,1,1,1,149,70},{0,1,1,1,149,71},{0,1,1,1,149,72},{0,1,1,1,149,73},{0,1,1,1,149,74},{0,1,1,1,149,75},{0,1,1,1,149,76},{0,1,1,1,149,77},{0,1,1,1,149,78},{0,1,1,1,149,79},{0,1,1,1,149,80},{0,1,1,1,149,81},{0,1,1,1,149,82},{0,1,1,1,149,83},{0,1,1,1,149,84},{0,1,1,1,149,85},{0,1,1,1,149,86},{0,1,1,1,149,87},{0,1,1,1,149,89},{0,1,1,1,149,106},{0,1,1,1,149,107},{0,1,1,1,149,113},{0,1,1,1,149,118},{0,1,1,1,149,119},{0,1,1,1,149,120},{0,1,1,1,149,121},{0,1,1,1,149,122},{85,0,0,1,0,149},{86,0,0,1,0,149},{87,0,0,1,0,149},{88,1,0,1,0,149},{9,0,1,1,150,48},{10,0,1,1,150,48},{11,0,1,1,150,48},{12,1,1,1,150,48},{9,0,1,1,150,49},{10,0,1,1,150,49},{11,0,1,1,150,49},{12,1,1,1,150,49},{9,0,1,1,150,50},{10,0,1,1,150,50},{11,0,1,1,150,50},{12,1,1,1,150,50},{9,0,1,1,150,97},{10,0,1,1,150,97},{11,0,1,1,150,97},{12,1,1,1,150,97},{9,0,1,1,150,99},{10,0,1,1,150,99},{11,0,1,1,150,99},{12,1,1,1,150,99},{9,0,1,1,150,101},{10,0,1,1,150,101},{11,0,1,1,150,101},{12,1,1,1,150,101},{9,0,1,1,150,105},{10,0,1,1,150,105},{11,0,1,1,150,105},{12,1,1,1,150,105},{9,0,1,1,150,111},{10,0,1,1,150,111},{11,0,1,1,150,111},{12,1,1,1,150,111},{9,0,1,1,150,115},{10,0,1,1,150,115},{11,0,1,1,150,115},{12,1,1,1,150,115},{9,0,1,1,150,116},{10,0,1,1,150,116},{11,0,1,1,150,116},{12,1,1,1,150,116},{13,0,1,1,150,32},{14,1,1,1,150,32},{13,0,1,1,150,37},{14,1,1,1,150,37},{13,0,1,1,150,45},{14,1,1,1,150,45},{13,0,1,1,150,46},{14,1,1,1,150,46},{13,0,1,1,150,47},{14,1,1,1,150,47},{13,0,1,1,150,51},{14,1,1,1,150,51},{13,0,1,1,150,52},{14,1,1,1,150,52},{13,0,1,1,150,53},{14,1,1,1,150,53},{13,0,1,1,150,54},{14,1,1,1,150,54},{13,0,1,1,150,55},{14,1,1,1,150,55},{13,0,1,1,150,56},{14,1,1,1,150,56},{13,0,1,1,150,57},{14,1,1,1,150,57},{13,0,1,1,150,61},{14,1,1,1,150,61},{13,0,1,1,150,65},{14,1,1,1,150,65},{13,0,1,1,150,95},{14,1,1,1,150,95},{13,0,1,1,150,98},{14,1,1,1,150,98},{13,0,1,1,150,100},{14,1,1,1,150,100},{13,0,1,1,150,102},{14,1,1,1,150,102},{13,0,1,1,150,103},{14,1,1,1,150,103},{13,0,1,1,150,104},{14,1,1,1,150,104},{13,0,1,1,150,108},{14,1,1,1,150,108},{13,0,1,1,150,109},{14,1,1,1,150,109},{13,0,1,1,150,110},{14,1,1,1,150,110},{13,0,1,1,150,112},{14,1,1,1,150,112},{13,0,1,1,150,114},{14,1,1,1,150,114},{13,0,1,1,150,117},{14,1,1,1,150,117},{0,1,1,1,150,58},{0,1,1,1,150,66},{0,1,1,1,150,67},{0,1,1,1,150,68},{0,1,1,1,150,69},{0,1,1,1,150,70},{0,1,1,1,150,71},{0,1,1,1,150,72},{0,1,1,1,150,73},{0,1,1,1,150,74},{0,1,1,1,150,75},{0,1,1,1,150,76},{0,1,1,1,150,77},{0,1,1,1,150,78},{0,1,1,1,150,79},{0,1,1,1,150,80},{0,1,1,1,150,81},{0,1,1,1,150,82},{0,1,1,1,150,83},{0,1,1,1,150,84},{0,1,1,1,150,85},{0,1,1,1,150,86},{0,1,1,1,150,87},{0,1,1,1,150,89},{0,1,1,1,150,106},{0,1,1,1,150,107},{0,1,1,1,150,113},{0,1,1,1,150,118},{0,1,1,1,150,119},{0,1,1,1,150,120},{0,1,1,1,150,121},{0,1,1,1,150,122},{85,0,0,1,0,150},{86,0,0,1,0,150},{87,0,0,1,0,150},{88,1,0,1,0,150},{9,0,1,1,151,48},{10,0,1,1,151,48},{11,0,1,1,151,48},{12,1,1,1,151,48},{9,0,1,1,151,49},{10,0,1,1,151,49},{11,0,1,1,151,49},{12,1,1,1,151,49},{9,0,1,1,151,50},{10,0,1,1,151,50},{11,0,1,1,151,50},{12,1,1,1,151,50},{9,0,1,1,151,97},{10,0,1,1,151,97},{11,0,1,1,151,97},{12,1,1,1,151,97},{9,0,1,1,151,99},{10,0,1,1,151,99},{11,0,1,1,151,99},{12,1,1,1,151,99},{9,0,1,1,151,101},{10,0,1,1,151,101},{11,0,1,1,151,101},{12,1,1,1,151,101},{9,0,1,1,151,105},{10,0,1,1,151,105},{11,0,1,1,151,105},{12,1,1,1,151,105},{9,0,1,1,151,111},{10,0,1,1,151,111},{11,0,1,1,151,111},{12,1,1,1,151,111},{9,0,1,1,151,115},{10,0,1,1,151,115},{11,0,1,1,151,115},{12,1,1,1,151,115},{9,0,1,1,151,116},{10,0,1,1,151,116},{11,0,1,1,151,116},{12,1,1,1,151,116},{13,0,1,1,151,32},{14,1,1,1,151,32},{13,0,1,1,151,37},{14,1,1,1,151,37},{13,0,1,1,151,45},{14,1,1,1,151,45},{13,0,1,1,151,46},{14,1,1,1,151,46},{13,0,1,1,151,47},{14,1,1,1,151,47},{13,0,1,1,151,51},{14,1,1,1,151,51},{13,0,1,1,151,52},{14,1,1,1,151,52},{13,0,1,1,151,53},{14,1,1,1,151,53},{13,0,1,1,151,54},{14,1,1,1,151,54},{13,0,1,1,151,55},{14,1,1,1,151,55},{13,0,1,1,151,56},{14,1,1,1,151,56},{13,0,1,1,151,57},{14,1,1,1,151,57},{13,0,1,1,151,61},{14,1,1,1,151,61},{13,0,1,1,151,65},{14,1,1,1,151,65},{13,0,1,1,151,95},{14,1,1,1,151,95},{13,0,1,1,151,98},{14,1,1,1,151,98},{13,0,1,1,151,100},{14,1,1,1,151,100},{13,0,1,1,151,102},{14,1,1,1,151,102},{13,0,1,1,151,103},{14,1,1,1,151,103},{13,0,1,1,151,104},{14,1,1,1,151,104},{13,0,1,1,151,108},{14,1,1,1,151,108},{13,0,1,1,151,109},{14,1,1,1,151,109},{13,0,1,1,151,110},{14,1,1,1,151,110},{13,0,1,1,151,112},{14,1,1,1,151,112},{13,0,1,1,151,114},{14,1,1,1,151,114},{13,0,1,1,151,117},{14,1,1,1,151,117},{0,1,1,1,151,58},{0,1,1,1,151,66},{0,1,1,1,151,67},{0,1,1,1,151,68},{0,1,1,1,151,69},{0,1,1,1,151,70},{0,1,1,1,151,71},{0,1,1,1,151,72},{0,1,1,1,151,73},{0,1,1,1,151,74},{0,1,1,1,151,75},{0,1,1,1,151,76},{0,1,1,1,151,77},{0,1,1,1,151,78},{0,1,1,1,151,79},{0,1,1,1,151,80},{0,1,1,1,151,81},{0,1,1,1,151,82},{0,1,1,1,151,83},{0,1,1,1,151,84},{0,1,1,1,151,85},{0,1,1,1,151,86},{0,1,1,1,151,87},{0,1,1,1,151,89},{0,1,1,1,151,106},{0,1,1,1,151,107},{0,1,1,1,151,113},{0,1,1,1,151,118},{0,1,1,1,151,119},{0,1,1,1,151,120},{0,1,1,1,151,121},{0,1,1,1,151,122},{85,0,0,1,0,151},{86,0,0,1,0,151},{87,0,0,1,0,151},{88,1,0,1,0,151},{9,0,1,1,152,48},{10,0,1,1,152,48},{11,0,1,1,152,48},{12,1,1,1,152,48},{9,0,1,1,152,49},{10,0,1,1,152,49},{11,0,1,1,152,49},{12,1,1,1,152,49},{9,0,1,1,152,50},{10,0,1,1,152,50},{11,0,1,1,152,50},{12,1,1,1,152,50},{9,0,1,1,152,97},{10,0,1,1,152,97},{11,0,1,1,152,97},{12,1,1,1,152,97},{9,0,1,1,152,99},{10,0,1,1,152,99},{11,0,1,1,152,99},{12,1,1,1,152,99},{9,0,1,1,152,101},{10,0,1,1,152,101},{11,0,1,1,152,101},{12,1,1,1,152,101},{9,0,1,1,152,105},{10,0,1,1,152,105},{11,0,1,1,152,105},{12,1,1,1,152,105},{9,0,1,1,152,111},{10,0,1,1,152,111},{11,0,1,1,152,111},{12,1,1,1,152,111},{9,0,1,1,152,115},{10,0,1,1,152,115},{11,0,1,1,152,115},{12,1,1,1,152,115},{9,0,1,1,152,116},{10,0,1,1,152,116},{11,0,1,1,152,116},{12,1,1,1,152,116},{13,0,1,1,152,32},{14,1,1,1,152,32},{13,0,1,1,152,37},{14,1,1,1,152,37},{13,0,1,1,152,45},{14,1,1,1,152,45},{13,0,1,1,152,46},{14,1,1,1,152,46},{13,0,1,1,152,47},{14,1,1,1,152,47},{13,0,1,1,152,51},{14,1,1,1,152,51},{13,0,1,1,152,52},{14,1,1,1,152,52},{13,0,1,1,152,53},{14,1,1,1,152,53},{13,0,1,1,152,54},{14,1,1,1,152,54},{13,0,1,1,152,55},{14,1,1,1,152,55},{13,0,1,1,152,56},{14,1,1,1,152,56},{13,0,1,1,152,57},{14,1,1,1,152,57},{13,0,1,1,152,61},{14,1,1,1,152,61},{13,0,1,1,152,65},{14,1,1,1,152,65},{13,0,1,1,152,95},{14,1,1,1,152,95},{13,0,1,1,152,98},{14,1,1,1,152,98},{13,0,1,1,152,100},{14,1,1,1,152,100},{13,0,1,1,152,102},{14,1,1,1,152,102},{13,0,1,1,152,103},{14,1,1,1,152,103},{13,0,1,1,152,104},{14,1,1,1,152,104},{13,0,1,1,152,108},{14,1,1,1,152,108},{13,0,1,1,152,109},{14,1,1,1,152,109},{13,0,1,1,152,110},{14,1,1,1,152,110},{13,0,1,1,152,112},{14,1,1,1,152,112},{13,0,1,1,152,114},{14,1,1,1,152,114},{13,0,1,1,152,117},{14,1,1,1,152,117},{0,1,1,1,152,58},{0,1,1,1,152,66},{0,1,1,1,152,67},{0,1,1,1,152,68},{0,1,1,1,152,69},{0,1,1,1,152,70},{0,1,1,1,152,71},{0,1,1,1,152,72},{0,1,1,1,152,73},{0,1,1,1,152,74},{0,1,1,1,152,75},{0,1,1,1,152,76},{0,1,1,1,152,77},{0,1,1,1,152,78},{0,1,1,1,152,79},{0,1,1,1,152,80},{0,1,1,1,152,81},{0,1,1,1,152,82},{0,1,1,1,152,83},{0,1,1,1,152,84},{0,1,1,1,152,85},{0,1,1,1,152,86},{0,1,1,1,152,87},{0,1,1,1,152,89},{0,1,1,1,152,106},{0,1,1,1,152,107},{0,1,1,1,152,113},{0,1,1,1,152,118},{0,1,1,1,152,119},{0,1,1,1,152,120},{0,1,1,1,152,121},{0,1,1,1,152,122},{85,0,0,1,0,152},{86,0,0,1,0,152},{87,0,0,1,0,152},{88,1,0,1,0,152},{9,0,1,1,155,48},{10,0,1,1,155,48},{11,0,1,1,155,48},{12,1,1,1,155,48},{9,0,1,1,155,49},{10,0,1,1,155,49},{11,0,1,1,155,49},{12,1,1,1,155,49},{9,0,1,1,155,50},{10,0,1,1,155,50},{11,0,1,1,155,50},{12,1,1,1,155,50},{9,0,1,1,155,97},{10,0,1,1,155,97},{11,0,1,1,155,97},{12,1,1,1,155,97},{9,0,1,1,155,99},{10,0,1,1,155,99},{11,0,1,1,155,99},{12,1,1,1,155,99},{9,0,1,1,155,101},{10,0,1,1,155,101},{11,0,1,1,155,101},{12,1,1,1,155,101},{9,0,1,1,155,105},{10,0,1,1,155,105},{11,0,1,1,155,105},{12,1,1,1,155,105},{9,0,1,1,155,111},{10,0,1,1,155,111},{11,0,1,1,155,111},{12,1,1,1,155,111},{9,0,1,1,155,115},{10,0,1,1,155,115},{11,0,1,1,155,115},{12,1,1,1,155,115},{9,0,1,1,155,116},{10,0,1,1,155,116},{11,0,1,1,155,116},{12,1,1,1,155,116},{13,0,1,1,155,32},{14,1,1,1,155,32},{13,0,1,1,155,37},{14,1,1,1,155,37},{13,0,1,1,155,45},{14,1,1,1,155,45},{13,0,1,1,155,46},{14,1,1,1,155,46},{13,0,1,1,155,47},{14,1,1,1,155,47},{13,0,1,1,155,51},{14,1,1,1,155,51},{13,0,1,1,155,52},{14,1,1,1,155,52},{13,0,1,1,155,53},{14,1,1,1,155,53},{13,0,1,1,155,54},{14,1,1,1,155,54},{13,0,1,1,155,55},{14,1,1,1,155,55},{13,0,1,1,155,56},{14,1,1,1,155,56},{13,0,1,1,155,57},{14,1,1,1,155,57},{13,0,1,1,155,61},{14,1,1,1,155,61},{13,0,1,1,155,65},{14,1,1,1,155,65},{13,0,1,1,155,95},{14,1,1,1,155,95},{13,0,1,1,155,98},{14,1,1,1,155,98},{13,0,1,1,155,100},{14,1,1,1,155,100},{13,0,1,1,155,102},{14,1,1,1,155,102},{13,0,1,1,155,103},{14,1,1,1,155,103},{13,0,1,1,155,104},{14,1,1,1,155,104},{13,0,1,1,155,108},{14,1,1,1,155,108},{13,0,1,1,155,109},{14,1,1,1,155,109},{13,0,1,1,155,110},{14,1,1,1,155,110},{13,0,1,1,155,112},{14,1,1,1,155,112},{13,0,1,1,155,114},{14,1,1,1,155,114},{13,0,1,1,155,117},{14,1,1,1,155,117},{0,1,1,1,155,58},{0,1,1,1,155,66},{0,1,1,1,155,67},{0,1,1,1,155,68},{0,1,1,1,155,69},{0,1,1,1,155,70},{0,1,1,1,155,71},{0,1,1,1,155,72},{0,1,1,1,155,73},{0,1,1,1,155,74},{0,1,1,1,155,75},{0,1,1,1,155,76},{0,1,1,1,155,77},{0,1,1,1,155,78},{0,1,1,1,155,79},{0,1,1,1,155,80},{0,1,1,1,155,81},{0,1,1,1,155,82},{0,1,1,1,155,83},{0,1,1,1,155,84},{0,1,1,1,155,85},{0,1,1,1,155,86},{0,1,1,1,155,87},{0,1,1,1,155,89},{0,1,1,1,155,106},{0,1,1,1,155,107},{0,1,1,1,155,113},{0,1,1,1,155,118},{0,1,1,1,155,119},{0,1,1,1,155,120},{0,1,1,1,155,121},{0,1,1,1,155,122},{85,0,0,1,0,155},{86,0,0,1,0,155},{87,0,0,1,0,155},{88,1,0,1,0,155},{9,0,1,1,157,48},{10,0,1,1,157,48},{11,0,1,1,157,48},{12,1,1,1,157,48},{9,0,1,1,157,49},{10,0,1,1,157,49},{11,0,1,1,157,49},{12,1,1,1,157,49},{9,0,1,1,157,50},{10,0,1,1,157,50},{11,0,1,1,157,50},{12,1,1,1,157,50},{9,0,1,1,157,97},{10,0,1,1,157,97},{11,0,1,1,157,97},{12,1,1,1,157,97},{9,0,1,1,157,99},{10,0,1,1,157,99},{11,0,1,1,157,99},{12,1,1,1,157,99},{9,0,1,1,157,101},{10,0,1,1,157,101},{11,0,1,1,157,101},{12,1,1,1,157,101},{9,0,1,1,157,105},{10,0,1,1,157,105},{11,0,1,1,157,105},{12,1,1,1,157,105},{9,0,1,1,157,111},{10,0,1,1,157,111},{11,0,1,1,157,111},{12,1,1,1,157,111},{9,0,1,1,157,115},{10,0,1,1,157,115},{11,0,1,1,157,115},{12,1,1,1,157,115},{9,0,1,1,157,116},{10,0,1,1,157,116},{11,0,1,1,157,116},{12,1,1,1,157,116},{13,0,1,1,157,32},{14,1,1,1,157,32},{13,0,1,1,157,37},{14,1,1,1,157,37},{13,0,1,1,157,45},{14,1,1,1,157,45},{13,0,1,1,157,46},{14,1,1,1,157,46},{13,0,1,1,157,47},{14,1,1,1,157,47},{13,0,1,1,157,51},{14,1,1,1,157,51},{13,0,1,1,157,52},{14,1,1,1,157,52},{13,0,1,1,157,53},{14,1,1,1,157,53},{13,0,1,1,157,54},{14,1,1,1,157,54},{13,0,1,1,157,55},{14,1,1,1,157,55},{13,0,1,1,157,56},{14,1,1,1,157,56},{13,0,1,1,157,57},{14,1,1,1,157,57},{13,0,1,1,157,61},{14,1,1,1,157,61},{13,0,1,1,157,65},{14,1,1,1,157,65},{13,0,1,1,157,95},{14,1,1,1,157,95},{13,0,1,1,157,98},{14,1,1,1,157,98},{13,0,1,1,157,100},{14,1,1,1,157,100},{13,0,1,1,157,102},{14,1,1,1,157,102},{13,0,1,1,157,103},{14,1,1,1,157,103},{13,0,1,1,157,104},{14,1,1,1,157,104},{13,0,1,1,157,108},{14,1,1,1,157,108},{13,0,1,1,157,109},{14,1,1,1,157,109},{13,0,1,1,157,110},{14,1,1,1,157,110},{13,0,1,1,157,112},{14,1,1,1,157,112},{13,0,1,1,157,114},{14,1,1,1,157,114},{13,0,1,1,157,117},{14,1,1,1,157,117},{0,1,1,1,157,58},{0,1,1,1,157,66},{0,1,1,1,157,67},{0,1,1,1,157,68},{0,1,1,1,157,69},{0,1,1,1,157,70},{0,1,1,1,157,71},{0,1,1,1,157,72},{0,1,1,1,157,73},{0,1,1,1,157,74},{0,1,1,1,157,75},{0,1,1,1,157,76},{0,1,1,1,157,77},{0,1,1,1,157,78},{0,1,1,1,157,79},{0,1,1,1,157,80},{0,1,1,1,157,81},{0,1,1,1,157,82},{0,1,1,1,157,83},{0,1,1,1,157,84},{0,1,1,1,157,85},{0,1,1,1,157,86},{0,1,1,1,157,87},{0,1,1,1,157,89},{0,1,1,1,157,106},{0,1,1,1,157,107},{0,1,1,1,157,113},{0,1,1,1,157,118},{0,1,1,1,157,119},{0,1,1,1,157,120},{0,1,1,1,157,121},{0,1,1,1,157,122},{85,0,0,1,0,157},{86,0,0,1,0,157},{87,0,0,1,0,157},{88,1,0,1,0,157},{9,0,1,1,158,48},{10,0,1,1,158,48},{11,0,1,1,158,48},{12,1,1,1,158,48},{9,0,1,1,158,49},{10,0,1,1,158,49},{11,0,1,1,158,49},{12,1,1,1,158,49},{9,0,1,1,158,50},{10,0,1,1,158,50},{11,0,1,1,158,50},{12,1,1,1,158,50},{9,0,1,1,158,97},{10,0,1,1,158,97},{11,0,1,1,158,97},{12,1,1,1,158,97},{9,0,1,1,158,99},{10,0,1,1,158,99},{11,0,1,1,158,99},{12,1,1,1,158,99},{9,0,1,1,158,101},{10,0,1,1,158,101},{11,0,1,1,158,101},{12,1,1,1,158,101},{9,0,1,1,158,105},{10,0,1,1,158,105},{11,0,1,1,158,105},{12,1,1,1,158,105},{9,0,1,1,158,111},{10,0,1,1,158,111},{11,0,1,1,158,111},{12,1,1,1,158,111},{9,0,1,1,158,115},{10,0,1,1,158,115},{11,0,1,1,158,115},{12,1,1,1,158,115},{9,0,1,1,158,116},{10,0,1,1,158,116},{11,0,1,1,158,116},{12,1,1,1,158,116},{13,0,1,1,158,32},{14,1,1,1,158,32},{13,0,1,1,158,37},{14,1,1,1,158,37},{13,0,1,1,158,45},{14,1,1,1,158,45},{13,0,1,1,158,46},{14,1,1,1,158,46},{13,0,1,1,158,47},{14,1,1,1,158,47},{13,0,1,1,158,51},{14,1,1,1,158,51},{13,0,1,1,158,52},{14,1,1,1,158,52},{13,0,1,1,158,53},{14,1,1,1,158,53},{13,0,1,1,158,54},{14,1,1,1,158,54},{13,0,1,1,158,55},{14,1,1,1,158,55},{13,0,1,1,158,56},{14,1,1,1,158,56},{13,0,1,1,158,57},{14,1,1,1,158,57},{13,0,1,1,158,61},{14,1,1,1,158,61},{13,0,1,1,158,65},{14,1,1,1,158,65},{13,0,1,1,158,95},{14,1,1,1,158,95},{13,0,1,1,158,98},{14,1,1,1,158,98},{13,0,1,1,158,100},{14,1,1,1,158,100},{13,0,1,1,158,102},{14,1,1,1,158,102},{13,0,1,1,158,103},{14,1,1,1,158,103},{13,0,1,1,158,104},{14,1,1,1,158,104},{13,0,1,1,158,108},{14,1,1,1,158,108},{13,0,1,1,158,109},{14,1,1,1,158,109},{13,0,1,1,158,110},{14,1,1,1,158,110},{13,0,1,1,158,112},{14,1,1,1,158,112},{13,0,1,1,158,114},{14,1,1,1,158,114},{13,0,1,1,158,117},{14,1,1,1,158,117},{0,1,1,1,158,58},{0,1,1,1,158,66},{0,1,1,1,158,67},{0,1,1,1,158,68},{0,1,1,1,158,69},{0,1,1,1,158,70},{0,1,1,1,158,71},{0,1,1,1,158,72},{0,1,1,1,158,73},{0,1,1,1,158,74},{0,1,1,1,158,75},{0,1,1,1,158,76},{0,1,1,1,158,77},{0,1,1,1,158,78},{0,1,1,1,158,79},{0,1,1,1,158,80},{0,1,1,1,158,81},{0,1,1,1,158,82},{0,1,1,1,158,83},{0,1,1,1,158,84},{0,1,1,1,158,85},{0,1,1,1,158,86},{0,1,1,1,158,87},{0,1,1,1,158,89},{0,1,1,1,158,106},{0,1,1,1,158,107},{0,1,1,1,158,113},{0,1,1,1,158,118},{0,1,1,1,158,119},{0,1,1,1,158,120},{0,1,1,1,158,121},{0,1,1,1,158,122},{85,0,0,1,0,158},{86,0,0,1,0,158},{87,0,0,1,0,158},{88,1,0,1,0,158},{9,0,1,1,165,48},{10,0,1,1,165,48},{11,0,1,1,165,48},{12,1,1,1,165,48},{9,0,1,1,165,49},{10,0,1,1,165,49},{11,0,1,1,165,49},{12,1,1,1,165,49},{9,0,1,1,165,50},{10,0,1,1,165,50},{11,0,1,1,165,50},{12,1,1,1,165,50},{9,0,1,1,165,97},{10,0,1,1,165,97},{11,0,1,1,165,97},{12,1,1,1,165,97},{9,0,1,1,165,99},{10,0,1,1,165,99},{11,0,1,1,165,99},{12,1,1,1,165,99},{9,0,1,1,165,101},{10,0,1,1,165,101},{11,0,1,1,165,101},{12,1,1,1,165,101},{9,0,1,1,165,105},{10,0,1,1,165,105},{11,0,1,1,165,105},{12,1,1,1,165,105},{9,0,1,1,165,111},{10,0,1,1,165,111},{11,0,1,1,165,111},{12,1,1,1,165,111},{9,0,1,1,165,115},{10,0,1,1,165,115},{11,0,1,1,165,115},{12,1,1,1,165,115},{9,0,1,1,165,116},{10,0,1,1,165,116},{11,0,1,1,165,116},{12,1,1,1,165,116},{13,0,1,1,165,32},{14,1,1,1,165,32},{13,0,1,1,165,37},{14,1,1,1,165,37},{13,0,1,1,165,45},{14,1,1,1,165,45},{13,0,1,1,165,46},{14,1,1,1,165,46},{13,0,1,1,165,47},{14,1,1,1,165,47},{13,0,1,1,165,51},{14,1,1,1,165,51},{13,0,1,1,165,52},{14,1,1,1,165,52},{13,0,1,1,165,53},{14,1,1,1,165,53},{13,0,1,1,165,54},{14,1,1,1,165,54},{13,0,1,1,165,55},{14,1,1,1,165,55},{13,0,1,1,165,56},{14,1,1,1,165,56},{13,0,1,1,165,57},{14,1,1,1,165,57},{13,0,1,1,165,61},{14,1,1,1,165,61},{13,0,1,1,165,65},{14,1,1,1,165,65},{13,0,1,1,165,95},{14,1,1,1,165,95},{13,0,1,1,165,98},{14,1,1,1,165,98},{13,0,1,1,165,100},{14,1,1,1,165,100},{13,0,1,1,165,102},{14,1,1,1,165,102},{13,0,1,1,165,103},{14,1,1,1,165,103},{13,0,1,1,165,104},{14,1,1,1,165,104},{13,0,1,1,165,108},{14,1,1,1,165,108},{13,0,1,1,165,109},{14,1,1,1,165,109},{13,0,1,1,165,110},{14,1,1,1,165,110},{13,0,1,1,165,112},{14,1,1,1,165,112},{13,0,1,1,165,114},{14,1,1,1,165,114},{13,0,1,1,165,117},{14,1,1,1,165,117},{0,1,1,1,165,58},{0,1,1,1,165,66},{0,1,1,1,165,67},{0,1,1,1,165,68},{0,1,1,1,165,69},{0,1,1,1,165,70},{0,1,1,1,165,71},{0,1,1,1,165,72},{0,1,1,1,165,73},{0,1,1,1,165,74},{0,1,1,1,165,75},{0,1,1,1,165,76},{0,1,1,1,165,77},{0,1,1,1,165,78},{0,1,1,1,165,79},{0,1,1,1,165,80},{0,1,1,1,165,81},{0,1,1,1,165,82},{0,1,1,1,165,83},{0,1,1,1,165,84},{0,1,1,1,165,85},{0,1,1,1,165,86},{0,1,1,1,165,87},{0,1,1,1,165,89},{0,1,1,1,165,106},{0,1,1,1,165,107},{0,1,1,1,165,113},{0,1,1,1,165,118},{0,1,1,1,165,119},{0,1,1,1,165,120},{0,1,1,1,165,121},{0,1,1,1,165,122},{85,0,0,1,0,165},{86,0,0,1,0,165},{87,0,0,1,0,165},{88,1,0,1,0,165},{9,0,1,1,166,48},{10,0,1,1,166,48},{11,0,1,1,166,48},{12,1,1,1,166,48},{9,0,1,1,166,49},{10,0,1,1,166,49},{11,0,1,1,166,49},{12,1,1,1,166,49},{9,0,1,1,166,50},{10,0,1,1,166,50},{11,0,1,1,166,50},{12,1,1,1,166,50},{9,0,1,1,166,97},{10,0,1,1,166,97},{11,0,1,1,166,97},{12,1,1,1,166,97},{9,0,1,1,166,99},{10,0,1,1,166,99},{11,0,1,1,166,99},{12,1,1,1,166,99},{9,0,1,1,166,101},{10,0,1,1,166,101},{11,0,1,1,166,101},{12,1,1,1,166,101},{9,0,1,1,166,105},{10,0,1,1,166,105},{11,0,1,1,166,105},{12,1,1,1,166,105},{9,0,1,1,166,111},{10,0,1,1,166,111},{11,0,1,1,166,111},{12,1,1,1,166,111},{9,0,1,1,166,115},{10,0,1,1,166,115},{11,0,1,1,166,115},{12,1,1,1,166,115},{9,0,1,1,166,116},{10,0,1,1,166,116},{11,0,1,1,166,116},{12,1,1,1,166,116},{13,0,1,1,166,32},{14,1,1,1,166,32},{13,0,1,1,166,37},{14,1,1,1,166,37},{13,0,1,1,166,45},{14,1,1,1,166,45},{13,0,1,1,166,46},{14,1,1,1,166,46},{13,0,1,1,166,47},{14,1,1,1,166,47},{13,0,1,1,166,51},{14,1,1,1,166,51},{13,0,1,1,166,52},{14,1,1,1,166,52},{13,0,1,1,166,53},{14,1,1,1,166,53},{13,0,1,1,166,54},{14,1,1,1,166,54},{13,0,1,1,166,55},{14,1,1,1,166,55},{13,0,1,1,166,56},{14,1,1,1,166,56},{13,0,1,1,166,57},{14,1,1,1,166,57},{13,0,1,1,166,61},{14,1,1,1,166,61},{13,0,1,1,166,65},{14,1,1,1,166,65},{13,0,1,1,166,95},{14,1,1,1,166,95},{13,0,1,1,166,98},{14,1,1,1,166,98},{13,0,1,1,166,100},{14,1,1,1,166,100},{13,0,1,1,166,102},{14,1,1,1,166,102},{13,0,1,1,166,103},{14,1,1,1,166,103},{13,0,1,1,166,104},{14,1,1,1,166,104},{13,0,1,1,166,108},{14,1,1,1,166,108},{13,0,1,1,166,109},{14,1,1,1,166,109},{13,0,1,1,166,110},{14,1,1,1,166,110},{13,0,1,1,166,112},{14,1,1,1,166,112},{13,0,1,1,166,114},{14,1,1,1,166,114},{13,0,1,1,166,117},{14,1,1,1,166,117},{0,1,1,1,166,58},{0,1,1,1,166,66},{0,1,1,1,166,67},{0,1,1,1,166,68},{0,1,1,1,166,69},{0,1,1,1,166,70},{0,1,1,1,166,71},{0,1,1,1,166,72},{0,1,1,1,166,73},{0,1,1,1,166,74},{0,1,1,1,166,75},{0,1,1,1,166,76},{0,1,1,1,166,77},{0,1,1,1,166,78},{0,1,1,1,166,79},{0,1,1,1,166,80},{0,1,1,1,166,81},{0,1,1,1,166,82},{0,1,1,1,166,83},{0,1,1,1,166,84},{0,1,1,1,166,85},{0,1,1,1,166,86},{0,1,1,1,166,87},{0,1,1,1,166,89},{0,1,1,1,166,106},{0,1,1,1,166,107},{0,1,1,1,166,113},{0,1,1,1,166,118},{0,1,1,1,166,119},{0,1,1,1,166,120},{0,1,1,1,166,121},{0,1,1,1,166,122},{85,0,0,1,0,166},{86,0,0,1,0,166},{87,0,0,1,0,166},{88,1,0,1,0,166},{9,0,1,1,168,48},{10,0,1,1,168,48},{11,0,1,1,168,48},{12,1,1,1,168,48},{9,0,1,1,168,49},{10,0,1,1,168,49},{11,0,1,1,168,49},{12,1,1,1,168,49},{9,0,1,1,168,50},{10,0,1,1,168,50},{11,0,1,1,168,50},{12,1,1,1,168,50},{9,0,1,1,168,97},{10,0,1,1,168,97},{11,0,1,1,168,97},{12,1,1,1,168,97},{9,0,1,1,168,99},{10,0,1,1,168,99},{11,0,1,1,168,99},{12,1,1,1,168,99},{9,0,1,1,168,101},{10,0,1,1,168,101},{11,0,1,1,168,101},{12,1,1,1,168,101},{9,0,1,1,168,105},{10,0,1,1,168,105},{11,0,1,1,168,105},{12,1,1,1,168,105},{9,0,1,1,168,111},{10,0,1,1,168,111},{11,0,1,1,168,111},{12,1,1,1,168,111},{9,0,1,1,168,115},{10,0,1,1,168,115},{11,0,1,1,168,115},{12,1,1,1,168,115},{9,0,1,1,168,116},{10,0,1,1,168,116},{11,0,1,1,168,116},{12,1,1,1,168,116},{13,0,1,1,168,32},{14,1,1,1,168,32},{13,0,1,1,168,37},{14,1,1,1,168,37},{13,0,1,1,168,45},{14,1,1,1,168,45},{13,0,1,1,168,46},{14,1,1,1,168,46},{13,0,1,1,168,47},{14,1,1,1,168,47},{13,0,1,1,168,51},{14,1,1,1,168,51},{13,0,1,1,168,52},{14,1,1,1,168,52},{13,0,1,1,168,53},{14,1,1,1,168,53},{13,0,1,1,168,54},{14,1,1,1,168,54},{13,0,1,1,168,55},{14,1,1,1,168,55},{13,0,1,1,168,56},{14,1,1,1,168,56},{13,0,1,1,168,57},{14,1,1,1,168,57},{13,0,1,1,168,61},{14,1,1,1,168,61},{13,0,1,1,168,65},{14,1,1,1,168,65},{13,0,1,1,168,95},{14,1,1,1,168,95},{13,0,1,1,168,98},{14,1,1,1,168,98},{13,0,1,1,168,100},{14,1,1,1,168,100},{13,0,1,1,168,102},{14,1,1,1,168,102},{13,0,1,1,168,103},{14,1,1,1,168,103},{13,0,1,1,168,104},{14,1,1,1,168,104},{13,0,1,1,168,108},{14,1,1,1,168,108},{13,0,1,1,168,109},{14,1,1,1,168,109},{13,0,1,1,168,110},{14,1,1,1,168,110},{13,0,1,1,168,112},{14,1,1,1,168,112},{13,0,1,1,168,114},{14,1,1,1,168,114},{13,0,1,1,168,117},{14,1,1,1,168,117},{0,1,1,1,168,58},{0,1,1,1,168,66},{0,1,1,1,168,67},{0,1,1,1,168,68},{0,1,1,1,168,69},{0,1,1,1,168,70},{0,1,1,1,168,71},{0,1,1,1,168,72},{0,1,1,1,168,73},{0,1,1,1,168,74},{0,1,1,1,168,75},{0,1,1,1,168,76},{0,1,1,1,168,77},{0,1,1,1,168,78},{0,1,1,1,168,79},{0,1,1,1,168,80},{0,1,1,1,168,81},{0,1,1,1,168,82},{0,1,1,1,168,83},{0,1,1,1,168,84},{0,1,1,1,168,85},{0,1,1,1,168,86},{0,1,1,1,168,87},{0,1,1,1,168,89},{0,1,1,1,168,106},{0,1,1,1,168,107},{0,1,1,1,168,113},{0,1,1,1,168,118},{0,1,1,1,168,119},{0,1,1,1,168,120},{0,1,1,1,168,121},{0,1,1,1,168,122},{85,0,0,1,0,168},{86,0,0,1,0,168},{87,0,0,1,0,168},{88,1,0,1,0,168},{9,0,1,1,174,48},{10,0,1,1,174,48},{11,0,1,1,174,48},{12,1,1,1,174,48},{9,0,1,1,174,49},{10,0,1,1,174,49},{11,0,1,1,174,49},{12,1,1,1,174,49},{9,0,1,1,174,50},{10,0,1,1,174,50},{11,0,1,1,174,50},{12,1,1,1,174,50},{9,0,1,1,174,97},{10,0,1,1,174,97},{11,0,1,1,174,97},{12,1,1,1,174,97},{9,0,1,1,174,99},{10,0,1,1,174,99},{11,0,1,1,174,99},{12,1,1,1,174,99},{9,0,1,1,174,101},{10,0,1,1,174,101},{11,0,1,1,174,101},{12,1,1,1,174,101},{9,0,1,1,174,105},{10,0,1,1,174,105},{11,0,1,1,174,105},{12,1,1,1,174,105},{9,0,1,1,174,111},{10,0,1,1,174,111},{11,0,1,1,174,111},{12,1,1,1,174,111},{9,0,1,1,174,115},{10,0,1,1,174,115},{11,0,1,1,174,115},{12,1,1,1,174,115},{9,0,1,1,174,116},{10,0,1,1,174,116},{11,0,1,1,174,116},{12,1,1,1,174,116},{13,0,1,1,174,32},{14,1,1,1,174,32},{13,0,1,1,174,37},{14,1,1,1,174,37},{13,0,1,1,174,45},{14,1,1,1,174,45},{13,0,1,1,174,46},{14,1,1,1,174,46},{13,0,1,1,174,47},{14,1,1,1,174,47},{13,0,1,1,174,51},{14,1,1,1,174,51},{13,0,1,1,174,52},{14,1,1,1,174,52},{13,0,1,1,174,53},{14,1,1,1,174,53},{13,0,1,1,174,54},{14,1,1,1,174,54},{13,0,1,1,174,55},{14,1,1,1,174,55},{13,0,1,1,174,56},{14,1,1,1,174,56},{13,0,1,1,174,57},{14,1,1,1,174,57},{13,0,1,1,174,61},{14,1,1,1,174,61},{13,0,1,1,174,65},{14,1,1,1,174,65},{13,0,1,1,174,95},{14,1,1,1,174,95},{13,0,1,1,174,98},{14,1,1,1,174,98},{13,0,1,1,174,100},{14,1,1,1,174,100},{13,0,1,1,174,102},{14,1,1,1,174,102},{13,0,1,1,174,103},{14,1,1,1,174,103},{13,0,1,1,174,104},{14,1,1,1,174,104},{13,0,1,1,174,108},{14,1,1,1,174,108},{13,0,1,1,174,109},{14,1,1,1,174,109},{13,0,1,1,174,110},{14,1,1,1,174,110},{13,0,1,1,174,112},{14,1,1,1,174,112},{13,0,1,1,174,114},{14,1,1,1,174,114},{13,0,1,1,174,117},{14,1,1,1,174,117},{0,1,1,1,174,58},{0,1,1,1,174,66},{0,1,1,1,174,67},{0,1,1,1,174,68},{0,1,1,1,174,69},{0,1,1,1,174,70},{0,1,1,1,174,71},{0,1,1,1,174,72},{0,1,1,1,174,73},{0,1,1,1,174,74},{0,1,1,1,174,75},{0,1,1,1,174,76},{0,1,1,1,174,77},{0,1,1,1,174,78},{0,1,1,1,174,79},{0,1,1,1,174,80},{0,1,1,1,174,81},{0,1,1,1,174,82},{0,1,1,1,174,83},{0,1,1,1,174,84},{0,1,1,1,174,85},{0,1,1,1,174,86},{0,1,1,1,174,87},{0,1,1,1,174,89},{0,1,1,1,174,106},{0,1,1,1,174,107},{0,1,1,1,174,113},{0,1,1,1,174,118},{0,1,1,1,174,119},{0,1,1,1,174,120},{0,1,1,1,174,121},{0,1,1,1,174,122},{85,0,0,1,0,174},{86,0,0,1,0,174},{87,0,0,1,0,174},{88,1,0,1,0,174},{9,0,1,1,175,48},{10,0,1,1,175,48},{11,0,1,1,175,48},{12,1,1,1,175,48},{9,0,1,1,175,49},{10,0,1,1,175,49},{11,0,1,1,175,49},{12,1,1,1,175,49},{9,0,1,1,175,50},{10,0,1,1,175,50},{11,0,1,1,175,50},{12,1,1,1,175,50},{9,0,1,1,175,97},{10,0,1,1,175,97},{11,0,1,1,175,97},{12,1,1,1,175,97},{9,0,1,1,175,99},{10,0,1,1,175,99},{11,0,1,1,175,99},{12,1,1,1,175,99},{9,0,1,1,175,101},{10,0,1,1,175,101},{11,0,1,1,175,101},{12,1,1,1,175,101},{9,0,1,1,175,105},{10,0,1,1,175,105},{11,0,1,1,175,105},{12,1,1,1,175,105},{9,0,1,1,175,111},{10,0,1,1,175,111},{11,0,1,1,175,111},{12,1,1,1,175,111},{9,0,1,1,175,115},{10,0,1,1,175,115},{11,0,1,1,175,115},{12,1,1,1,175,115},{9,0,1,1,175,116},{10,0,1,1,175,116},{11,0,1,1,175,116},{12,1,1,1,175,116},{13,0,1,1,175,32},{14,1,1,1,175,32},{13,0,1,1,175,37},{14,1,1,1,175,37},{13,0,1,1,175,45},{14,1,1,1,175,45},{13,0,1,1,175,46},{14,1,1,1,175,46},{13,0,1,1,175,47},{14,1,1,1,175,47},{13,0,1,1,175,51},{14,1,1,1,175,51},{13,0,1,1,175,52},{14,1,1,1,175,52},{13,0,1,1,175,53},{14,1,1,1,175,53},{13,0,1,1,175,54},{14,1,1,1,175,54},{13,0,1,1,175,55},{14,1,1,1,175,55},{13,0,1,1,175,56},{14,1,1,1,175,56},{13,0,1,1,175,57},{14,1,1,1,175,57},{13,0,1,1,175,61},{14,1,1,1,175,61},{13,0,1,1,175,65},{14,1,1,1,175,65},{13,0,1,1,175,95},{14,1,1,1,175,95},{13,0,1,1,175,98},{14,1,1,1,175,98},{13,0,1,1,175,100},{14,1,1,1,175,100},{13,0,1,1,175,102},{14,1,1,1,175,102},{13,0,1,1,175,103},{14,1,1,1,175,103},{13,0,1,1,175,104},{14,1,1,1,175,104},{13,0,1,1,175,108},{14,1,1,1,175,108},{13,0,1,1,175,109},{14,1,1,1,175,109},{13,0,1,1,175,110},{14,1,1,1,175,110},{13,0,1,1,175,112},{14,1,1,1,175,112},{13,0,1,1,175,114},{14,1,1,1,175,114},{13,0,1,1,175,117},{14,1,1,1,175,117},{0,1,1,1,175,58},{0,1,1,1,175,66},{0,1,1,1,175,67},{0,1,1,1,175,68},{0,1,1,1,175,69},{0,1,1,1,175,70},{0,1,1,1,175,71},{0,1,1,1,175,72},{0,1,1,1,175,73},{0,1,1,1,175,74},{0,1,1,1,175,75},{0,1,1,1,175,76},{0,1,1,1,175,77},{0,1,1,1,175,78},{0,1,1,1,175,79},{0,1,1,1,175,80},{0,1,1,1,175,81},{0,1,1,1,175,82},{0,1,1,1,175,83},{0,1,1,1,175,84},{0,1,1,1,175,85},{0,1,1,1,175,86},{0,1,1,1,175,87},{0,1,1,1,175,89},{0,1,1,1,175,106},{0,1,1,1,175,107},{0,1,1,1,175,113},{0,1,1,1,175,118},{0,1,1,1,175,119},{0,1,1,1,175,120},{0,1,1,1,175,121},{0,1,1,1,175,122},{85,0,0,1,0,175},{86,0,0,1,0,175},{87,0,0,1,0,175},{88,1,0,1,0,175},{9,0,1,1,180,48},{10,0,1,1,180,48},{11,0,1,1,180,48},{12,1,1,1,180,48},{9,0,1,1,180,49},{10,0,1,1,180,49},{11,0,1,1,180,49},{12,1,1,1,180,49},{9,0,1,1,180,50},{10,0,1,1,180,50},{11,0,1,1,180,50},{12,1,1,1,180,50},{9,0,1,1,180,97},{10,0,1,1,180,97},{11,0,1,1,180,97},{12,1,1,1,180,97},{9,0,1,1,180,99},{10,0,1,1,180,99},{11,0,1,1,180,99},{12,1,1,1,180,99},{9,0,1,1,180,101},{10,0,1,1,180,101},{11,0,1,1,180,101},{12,1,1,1,180,101},{9,0,1,1,180,105},{10,0,1,1,180,105},{11,0,1,1,180,105},{12,1,1,1,180,105},{9,0,1,1,180,111},{10,0,1,1,180,111},{11,0,1,1,180,111},{12,1,1,1,180,111},{9,0,1,1,180,115},{10,0,1,1,180,115},{11,0,1,1,180,115},{12,1,1,1,180,115},{9,0,1,1,180,116},{10,0,1,1,180,116},{11,0,1,1,180,116},{12,1,1,1,180,116},{13,0,1,1,180,32},{14,1,1,1,180,32},{13,0,1,1,180,37},{14,1,1,1,180,37},{13,0,1,1,180,45},{14,1,1,1,180,45},{13,0,1,1,180,46},{14,1,1,1,180,46},{13,0,1,1,180,47},{14,1,1,1,180,47},{13,0,1,1,180,51},{14,1,1,1,180,51},{13,0,1,1,180,52},{14,1,1,1,180,52},{13,0,1,1,180,53},{14,1,1,1,180,53},{13,0,1,1,180,54},{14,1,1,1,180,54},{13,0,1,1,180,55},{14,1,1,1,180,55},{13,0,1,1,180,56},{14,1,1,1,180,56},{13,0,1,1,180,57},{14,1,1,1,180,57},{13,0,1,1,180,61},{14,1,1,1,180,61},{13,0,1,1,180,65},{14,1,1,1,180,65},{13,0,1,1,180,95},{14,1,1,1,180,95},{13,0,1,1,180,98},{14,1,1,1,180,98},{13,0,1,1,180,100},{14,1,1,1,180,100},{13,0,1,1,180,102},{14,1,1,1,180,102},{13,0,1,1,180,103},{14,1,1,1,180,103},{13,0,1,1,180,104},{14,1,1,1,180,104},{13,0,1,1,180,108},{14,1,1,1,180,108},{13,0,1,1,180,109},{14,1,1,1,180,109},{13,0,1,1,180,110},{14,1,1,1,180,110},{13,0,1,1,180,112},{14,1,1,1,180,112},{13,0,1,1,180,114},{14,1,1,1,180,114},{13,0,1,1,180,117},{14,1,1,1,180,117},{0,1,1,1,180,58},{0,1,1,1,180,66},{0,1,1,1,180,67},{0,1,1,1,180,68},{0,1,1,1,180,69},{0,1,1,1,180,70},{0,1,1,1,180,71},{0,1,1,1,180,72},{0,1,1,1,180,73},{0,1,1,1,180,74},{0,1,1,1,180,75},{0,1,1,1,180,76},{0,1,1,1,180,77},{0,1,1,1,180,78},{0,1,1,1,180,79},{0,1,1,1,180,80},{0,1,1,1,180,81},{0,1,1,1,180,82},{0,1,1,1,180,83},{0,1,1,1,180,84},{0,1,1,1,180,85},{0,1,1,1,180,86},{0,1,1,1,180,87},{0,1,1,1,180,89},{0,1,1,1,180,106},{0,1,1,1,180,107},{0,1,1,1,180,113},{0,1,1,1,180,118},{0,1,1,1,180,119},{0,1,1,1,180,120},{0,1,1,1,180,121},{0,1,1,1,180,122},{85,0,0,1,0,180},{86,0,0,1,0,180},{87,0,0,1,0,180},{88,1,0,1,0,180},{9,0,1,1,182,48},{10,0,1,1,182,48},{11,0,1,1,182,48},{12,1,1,1,182,48},{9,0,1,1,182,49},{10,0,1,1,182,49},{11,0,1,1,182,49},{12,1,1,1,182,49},{9,0,1,1,182,50},{10,0,1,1,182,50},{11,0,1,1,182,50},{12,1,1,1,182,50},{9,0,1,1,182,97},{10,0,1,1,182,97},{11,0,1,1,182,97},{12,1,1,1,182,97},{9,0,1,1,182,99},{10,0,1,1,182,99},{11,0,1,1,182,99},{12,1,1,1,182,99},{9,0,1,1,182,101},{10,0,1,1,182,101},{11,0,1,1,182,101},{12,1,1,1,182,101},{9,0,1,1,182,105},{10,0,1,1,182,105},{11,0,1,1,182,105},{12,1,1,1,182,105},{9,0,1,1,182,111},{10,0,1,1,182,111},{11,0,1,1,182,111},{12,1,1,1,182,111},{9,0,1,1,182,115},{10,0,1,1,182,115},{11,0,1,1,182,115},{12,1,1,1,182,115},{9,0,1,1,182,116},{10,0,1,1,182,116},{11,0,1,1,182,116},{12,1,1,1,182,116},{13,0,1,1,182,32},{14,1,1,1,182,32},{13,0,1,1,182,37},{14,1,1,1,182,37},{13,0,1,1,182,45},{14,1,1,1,182,45},{13,0,1,1,182,46},{14,1,1,1,182,46},{13,0,1,1,182,47},{14,1,1,1,182,47},{13,0,1,1,182,51},{14,1,1,1,182,51},{13,0,1,1,182,52},{14,1,1,1,182,52},{13,0,1,1,182,53},{14,1,1,1,182,53},{13,0,1,1,182,54},{14,1,1,1,182,54},{13,0,1,1,182,55},{14,1,1,1,182,55},{13,0,1,1,182,56},{14,1,1,1,182,56},{13,0,1,1,182,57},{14,1,1,1,182,57},{13,0,1,1,182,61},{14,1,1,1,182,61},{13,0,1,1,182,65},{14,1,1,1,182,65},{13,0,1,1,182,95},{14,1,1,1,182,95},{13,0,1,1,182,98},{14,1,1,1,182,98},{13,0,1,1,182,100},{14,1,1,1,182,100},{13,0,1,1,182,102},{14,1,1,1,182,102},{13,0,1,1,182,103},{14,1,1,1,182,103},{13,0,1,1,182,104},{14,1,1,1,182,104},{13,0,1,1,182,108},{14,1,1,1,182,108},{13,0,1,1,182,109},{14,1,1,1,182,109},{13,0,1,1,182,110},{14,1,1,1,182,110},{13,0,1,1,182,112},{14,1,1,1,182,112},{13,0,1,1,182,114},{14,1,1,1,182,114},{13,0,1,1,182,117},{14,1,1,1,182,117},{0,1,1,1,182,58},{0,1,1,1,182,66},{0,1,1,1,182,67},{0,1,1,1,182,68},{0,1,1,1,182,69},{0,1,1,1,182,70},{0,1,1,1,182,71},{0,1,1,1,182,72},{0,1,1,1,182,73},{0,1,1,1,182,74},{0,1,1,1,182,75},{0,1,1,1,182,76},{0,1,1,1,182,77},{0,1,1,1,182,78},{0,1,1,1,182,79},{0,1,1,1,182,80},{0,1,1,1,182,81},{0,1,1,1,182,82},{0,1,1,1,182,83},{0,1,1,1,182,84},{0,1,1,1,182,85},{0,1,1,1,182,86},{0,1,1,1,182,87},{0,1,1,1,182,89},{0,1,1,1,182,106},{0,1,1,1,182,107},{0,1,1,1,182,113},{0,1,1,1,182,118},{0,1,1,1,182,119},{0,1,1,1,182,120},{0,1,1,1,182,121},{0,1,1,1,182,122},{85,0,0,1,0,182},{86,0,0,1,0,182},{87,0,0,1,0,182},{88,1,0,1,0,182},{9,0,1,1,183,48},{10,0,1,1,183,48},{11,0,1,1,183,48},{12,1,1,1,183,48},{9,0,1,1,183,49},{10,0,1,1,183,49},{11,0,1,1,183,49},{12,1,1,1,183,49},{9,0,1,1,183,50},{10,0,1,1,183,50},{11,0,1,1,183,50},{12,1,1,1,183,50},{9,0,1,1,183,97},{10,0,1,1,183,97},{11,0,1,1,183,97},{12,1,1,1,183,97},{9,0,1,1,183,99},{10,0,1,1,183,99},{11,0,1,1,183,99},{12,1,1,1,183,99},{9,0,1,1,183,101},{10,0,1,1,183,101},{11,0,1,1,183,101},{12,1,1,1,183,101},{9,0,1,1,183,105},{10,0,1,1,183,105},{11,0,1,1,183,105},{12,1,1,1,183,105},{9,0,1,1,183,111},{10,0,1,1,183,111},{11,0,1,1,183,111},{12,1,1,1,183,111},{9,0,1,1,183,115},{10,0,1,1,183,115},{11,0,1,1,183,115},{12,1,1,1,183,115},{9,0,1,1,183,116},{10,0,1,1,183,116},{11,0,1,1,183,116},{12,1,1,1,183,116},{13,0,1,1,183,32},{14,1,1,1,183,32},{13,0,1,1,183,37},{14,1,1,1,183,37},{13,0,1,1,183,45},{14,1,1,1,183,45},{13,0,1,1,183,46},{14,1,1,1,183,46},{13,0,1,1,183,47},{14,1,1,1,183,47},{13,0,1,1,183,51},{14,1,1,1,183,51},{13,0,1,1,183,52},{14,1,1,1,183,52},{13,0,1,1,183,53},{14,1,1,1,183,53},{13,0,1,1,183,54},{14,1,1,1,183,54},{13,0,1,1,183,55},{14,1,1,1,183,55},{13,0,1,1,183,56},{14,1,1,1,183,56},{13,0,1,1,183,57},{14,1,1,1,183,57},{13,0,1,1,183,61},{14,1,1,1,183,61},{13,0,1,1,183,65},{14,1,1,1,183,65},{13,0,1,1,183,95},{14,1,1,1,183,95},{13,0,1,1,183,98},{14,1,1,1,183,98},{13,0,1,1,183,100},{14,1,1,1,183,100},{13,0,1,1,183,102},{14,1,1,1,183,102},{13,0,1,1,183,103},{14,1,1,1,183,103},{13,0,1,1,183,104},{14,1,1,1,183,104},{13,0,1,1,183,108},{14,1,1,1,183,108},{13,0,1,1,183,109},{14,1,1,1,183,109},{13,0,1,1,183,110},{14,1,1,1,183,110},{13,0,1,1,183,112},{14,1,1,1,183,112},{13,0,1,1,183,114},{14,1,1,1,183,114},{13,0,1,1,183,117},{14,1,1,1,183,117},{0,1,1,1,183,58},{0,1,1,1,183,66},{0,1,1,1,183,67},{0,1,1,1,183,68},{0,1,1,1,183,69},{0,1,1,1,183,70},{0,1,1,1,183,71},{0,1,1,1,183,72},{0,1,1,1,183,73},{0,1,1,1,183,74},{0,1,1,1,183,75},{0,1,1,1,183,76},{0,1,1,1,183,77},{0,1,1,1,183,78},{0,1,1,1,183,79},{0,1,1,1,183,80},{0,1,1,1,183,81},{0,1,1,1,183,82},{0,1,1,1,183,83},{0,1,1,1,183,84},{0,1,1,1,183,85},{0,1,1,1,183,86},{0,1,1,1,183,87},{0,1,1,1,183,89},{0,1,1,1,183,106},{0,1,1,1,183,107},{0,1,1,1,183,113},{0,1,1,1,183,118},{0,1,1,1,183,119},{0,1,1,1,183,120},{0,1,1,1,183,121},{0,1,1,1,183,122},{85,0,0,1,0,183},{86,0,0,1,0,183},{87,0,0,1,0,183},{88,1,0,1,0,183},{9,0,1,1,188,48},{10,0,1,1,188,48},{11,0,1,1,188,48},{12,1,1,1,188,48},{9,0,1,1,188,49},{10,0,1,1,188,49},{11,0,1,1,188,49},{12,1,1,1,188,49},{9,0,1,1,188,50},{10,0,1,1,188,50},{11,0,1,1,188,50},{12,1,1,1,188,50},{9,0,1,1,188,97},{10,0,1,1,188,97},{11,0,1,1,188,97},{12,1,1,1,188,97},{9,0,1,1,188,99},{10,0,1,1,188,99},{11,0,1,1,188,99},{12,1,1,1,188,99},{9,0,1,1,188,101},{10,0,1,1,188,101},{11,0,1,1,188,101},{12,1,1,1,188,101},{9,0,1,1,188,105},{10,0,1,1,188,105},{11,0,1,1,188,105},{12,1,1,1,188,105},{9,0,1,1,188,111},{10,0,1,1,188,111},{11,0,1,1,188,111},{12,1,1,1,188,111},{9,0,1,1,188,115},{10,0,1,1,188,115},{11,0,1,1,188,115},{12,1,1,1,188,115},{9,0,1,1,188,116},{10,0,1,1,188,116},{11,0,1,1,188,116},{12,1,1,1,188,116},{13,0,1,1,188,32},{14,1,1,1,188,32},{13,0,1,1,188,37},{14,1,1,1,188,37},{13,0,1,1,188,45},{14,1,1,1,188,45},{13,0,1,1,188,46},{14,1,1,1,188,46},{13,0,1,1,188,47},{14,1,1,1,188,47},{13,0,1,1,188,51},{14,1,1,1,188,51},{13,0,1,1,188,52},{14,1,1,1,188,52},{13,0,1,1,188,53},{14,1,1,1,188,53},{13,0,1,1,188,54},{14,1,1,1,188,54},{13,0,1,1,188,55},{14,1,1,1,188,55},{13,0,1,1,188,56},{14,1,1,1,188,56},{13,0,1,1,188,57},{14,1,1,1,188,57},{13,0,1,1,188,61},{14,1,1,1,188,61},{13,0,1,1,188,65},{14,1,1,1,188,65},{13,0,1,1,188,95},{14,1,1,1,188,95},{13,0,1,1,188,98},{14,1,1,1,188,98},{13,0,1,1,188,100},{14,1,1,1,188,100},{13,0,1,1,188,102},{14,1,1,1,188,102},{13,0,1,1,188,103},{14,1,1,1,188,103},{13,0,1,1,188,104},{14,1,1,1,188,104},{13,0,1,1,188,108},{14,1,1,1,188,108},{13,0,1,1,188,109},{14,1,1,1,188,109},{13,0,1,1,188,110},{14,1,1,1,188,110},{13,0,1,1,188,112},{14,1,1,1,188,112},{13,0,1,1,188,114},{14,1,1,1,188,114},{13,0,1,1,188,117},{14,1,1,1,188,117},{0,1,1,1,188,58},{0,1,1,1,188,66},{0,1,1,1,188,67},{0,1,1,1,188,68},{0,1,1,1,188,69},{0,1,1,1,188,70},{0,1,1,1,188,71},{0,1,1,1,188,72},{0,1,1,1,188,73},{0,1,1,1,188,74},{0,1,1,1,188,75},{0,1,1,1,188,76},{0,1,1,1,188,77},{0,1,1,1,188,78},{0,1,1,1,188,79},{0,1,1,1,188,80},{0,1,1,1,188,81},{0,1,1,1,188,82},{0,1,1,1,188,83},{0,1,1,1,188,84},{0,1,1,1,188,85},{0,1,1,1,188,86},{0,1,1,1,188,87},{0,1,1,1,188,89},{0,1,1,1,188,106},{0,1,1,1,188,107},{0,1,1,1,188,113},{0,1,1,1,188,118},{0,1,1,1,188,119},{0,1,1,1,188,120},{0,1,1,1,188,121},{0,1,1,1,188,122},{85,0,0,1,0,188},{86,0,0,1,0,188},{87,0,0,1,0,188},{88,1,0,1,0,188},{9,0,1,1,191,48},{10,0,1,1,191,48},{11,0,1,1,191,48},{12,1,1,1,191,48},{9,0,1,1,191,49},{10,0,1,1,191,49},{11,0,1,1,191,49},{12,1,1,1,191,49},{9,0,1,1,191,50},{10,0,1,1,191,50},{11,0,1,1,191,50},{12,1,1,1,191,50},{9,0,1,1,191,97},{10,0,1,1,191,97},{11,0,1,1,191,97},{12,1,1,1,191,97},{9,0,1,1,191,99},{10,0,1,1,191,99},{11,0,1,1,191,99},{12,1,1,1,191,99},{9,0,1,1,191,101},{10,0,1,1,191,101},{11,0,1,1,191,101},{12,1,1,1,191,101},{9,0,1,1,191,105},{10,0,1,1,191,105},{11,0,1,1,191,105},{12,1,1,1,191,105},{9,0,1,1,191,111},{10,0,1,1,191,111},{11,0,1,1,191,111},{12,1,1,1,191,111},{9,0,1,1,191,115},{10,0,1,1,191,115},{11,0,1,1,191,115},{12,1,1,1,191,115},{9,0,1,1,191,116},{10,0,1,1,191,116},{11,0,1,1,191,116},{12,1,1,1,191,116},{13,0,1,1,191,32},{14,1,1,1,191,32},{13,0,1,1,191,37},{14,1,1,1,191,37},{13,0,1,1,191,45},{14,1,1,1,191,45},{13,0,1,1,191,46},{14,1,1,1,191,46},{13,0,1,1,191,47},{14,1,1,1,191,47},{13,0,1,1,191,51},{14,1,1,1,191,51},{13,0,1,1,191,52},{14,1,1,1,191,52},{13,0,1,1,191,53},{14,1,1,1,191,53},{13,0,1,1,191,54},{14,1,1,1,191,54},{13,0,1,1,191,55},{14,1,1,1,191,55},{13,0,1,1,191,56},{14,1,1,1,191,56},{13,0,1,1,191,57},{14,1,1,1,191,57},{13,0,1,1,191,61},{14,1,1,1,191,61},{13,0,1,1,191,65},{14,1,1,1,191,65},{13,0,1,1,191,95},{14,1,1,1,191,95},{13,0,1,1,191,98},{14,1,1,1,191,98},{13,0,1,1,191,100},{14,1,1,1,191,100},{13,0,1,1,191,102},{14,1,1,1,191,102},{13,0,1,1,191,103},{14,1,1,1,191,103},{13,0,1,1,191,104},{14,1,1,1,191,104},{13,0,1,1,191,108},{14,1,1,1,191,108},{13,0,1,1,191,109},{14,1,1,1,191,109},{13,0,1,1,191,110},{14,1,1,1,191,110},{13,0,1,1,191,112},{14,1,1,1,191,112},{13,0,1,1,191,114},{14,1,1,1,191,114},{13,0,1,1,191,117},{14,1,1,1,191,117},{0,1,1,1,191,58},{0,1,1,1,191,66},{0,1,1,1,191,67},{0,1,1,1,191,68},{0,1,1,1,191,69},{0,1,1,1,191,70},{0,1,1,1,191,71},{0,1,1,1,191,72},{0,1,1,1,191,73},{0,1,1,1,191,74},{0,1,1,1,191,75},{0,1,1,1,191,76},{0,1,1,1,191,77},{0,1,1,1,191,78},{0,1,1,1,191,79},{0,1,1,1,191,80},{0,1,1,1,191,81},{0,1,1,1,191,82},{0,1,1,1,191,83},{0,1,1,1,191,84},{0,1,1,1,191,85},{0,1,1,1,191,86},{0,1,1,1,191,87},{0,1,1,1,191,89},{0,1,1,1,191,106},{0,1,1,1,191,107},{0,1,1,1,191,113},{0,1,1,1,191,118},{0,1,1,1,191,119},{0,1,1,1,191,120},{0,1,1,1,191,121},{0,1,1,1,191,122},{85,0,0,1,0,191},{86,0,0,1,0,191},{87,0,0,1,0,191},{88,1,0,1,0,191},{9,0,1,1,197,48},{10,0,1,1,197,48},{11,0,1,1,197,48},{12,1,1,1,197,48},{9,0,1,1,197,49},{10,0,1,1,197,49},{11,0,1,1,197,49},{12,1,1,1,197,49},{9,0,1,1,197,50},{10,0,1,1,197,50},{11,0,1,1,197,50},{12,1,1,1,197,50},{9,0,1,1,197,97},{10,0,1,1,197,97},{11,0,1,1,197,97},{12,1,1,1,197,97},{9,0,1,1,197,99},{10,0,1,1,197,99},{11,0,1,1,197,99},{12,1,1,1,197,99},{9,0,1,1,197,101},{10,0,1,1,197,101},{11,0,1,1,197,101},{12,1,1,1,197,101},{9,0,1,1,197,105},{10,0,1,1,197,105},{11,0,1,1,197,105},{12,1,1,1,197,105},{9,0,1,1,197,111},{10,0,1,1,197,111},{11,0,1,1,197,111},{12,1,1,1,197,111},{9,0,1,1,197,115},{10,0,1,1,197,115},{11,0,1,1,197,115},{12,1,1,1,197,115},{9,0,1,1,197,116},{10,0,1,1,197,116},{11,0,1,1,197,116},{12,1,1,1,197,116},{13,0,1,1,197,32},{14,1,1,1,197,32},{13,0,1,1,197,37},{14,1,1,1,197,37},{13,0,1,1,197,45},{14,1,1,1,197,45},{13,0,1,1,197,46},{14,1,1,1,197,46},{13,0,1,1,197,47},{14,1,1,1,197,47},{13,0,1,1,197,51},{14,1,1,1,197,51},{13,0,1,1,197,52},{14,1,1,1,197,52},{13,0,1,1,197,53},{14,1,1,1,197,53},{13,0,1,1,197,54},{14,1,1,1,197,54},{13,0,1,1,197,55},{14,1,1,1,197,55},{13,0,1,1,197,56},{14,1,1,1,197,56},{13,0,1,1,197,57},{14,1,1,1,197,57},{13,0,1,1,197,61},{14,1,1,1,197,61},{13,0,1,1,197,65},{14,1,1,1,197,65},{13,0,1,1,197,95},{14,1,1,1,197,95},{13,0,1,1,197,98},{14,1,1,1,197,98},{13,0,1,1,197,100},{14,1,1,1,197,100},{13,0,1,1,197,102},{14,1,1,1,197,102},{13,0,1,1,197,103},{14,1,1,1,197,103},{13,0,1,1,197,104},{14,1,1,1,197,104},{13,0,1,1,197,108},{14,1,1,1,197,108},{13,0,1,1,197,109},{14,1,1,1,197,109},{13,0,1,1,197,110},{14,1,1,1,197,110},{13,0,1,1,197,112},{14,1,1,1,197,112},{13,0,1,1,197,114},{14,1,1,1,197,114},{13,0,1,1,197,117},{14,1,1,1,197,117},{0,1,1,1,197,58},{0,1,1,1,197,66},{0,1,1,1,197,67},{0,1,1,1,197,68},{0,1,1,1,197,69},{0,1,1,1,197,70},{0,1,1,1,197,71},{0,1,1,1,197,72},{0,1,1,1,197,73},{0,1,1,1,197,74},{0,1,1,1,197,75},{0,1,1,1,197,76},{0,1,1,1,197,77},{0,1,1,1,197,78},{0,1,1,1,197,79},{0,1,1,1,197,80},{0,1,1,1,197,81},{0,1,1,1,197,82},{0,1,1,1,197,83},{0,1,1,1,197,84},{0,1,1,1,197,85},{0,1,1,1,197,86},{0,1,1,1,197,87},{0,1,1,1,197,89},{0,1,1,1,197,106},{0,1,1,1,197,107},{0,1,1,1,197,113},{0,1,1,1,197,118},{0,1,1,1,197,119},{0,1,1,1,197,120},{0,1,1,1,197,121},{0,1,1,1,197,122},{85,0,0,1,0,197},{86,0,0,1,0,197},{87,0,0,1,0,197},{88,1,0,1,0,197},{9,0,1,1,231,48},{10,0,1,1,231,48},{11,0,1,1,231,48},{12,1,1,1,231,48},{9,0,1,1,231,49},{10,0,1,1,231,49},{11,0,1,1,231,49},{12,1,1,1,231,49},{9,0,1,1,231,50},{10,0,1,1,231,50},{11,0,1,1,231,50},{12,1,1,1,231,50},{9,0,1,1,231,97},{10,0,1,1,231,97},{11,0,1,1,231,97},{12,1,1,1,231,97},{9,0,1,1,231,99},{10,0,1,1,231,99},{11,0,1,1,231,99},{12,1,1,1,231,99},{9,0,1,1,231,101},{10,0,1,1,231,101},{11,0,1,1,231,101},{12,1,1,1,231,101},{9,0,1,1,231,105},{10,0,1,1,231,105},{11,0,1,1,231,105},{12,1,1,1,231,105},{9,0,1,1,231,111},{10,0,1,1,231,111},{11,0,1,1,231,111},{12,1,1,1,231,111},{9,0,1,1,231,115},{10,0,1,1,231,115},{11,0,1,1,231,115},{12,1,1,1,231,115},{9,0,1,1,231,116},{10,0,1,1,231,116},{11,0,1,1,231,116},{12,1,1,1,231,116},{13,0,1,1,231,32},{14,1,1,1,231,32},{13,0,1,1,231,37},{14,1,1,1,231,37},{13,0,1,1,231,45},{14,1,1,1,231,45},{13,0,1,1,231,46},{14,1,1,1,231,46},{13,0,1,1,231,47},{14,1,1,1,231,47},{13,0,1,1,231,51},{14,1,1,1,231,51},{13,0,1,1,231,52},{14,1,1,1,231,52},{13,0,1,1,231,53},{14,1,1,1,231,53},{13,0,1,1,231,54},{14,1,1,1,231,54},{13,0,1,1,231,55},{14,1,1,1,231,55},{13,0,1,1,231,56},{14,1,1,1,231,56},{13,0,1,1,231,57},{14,1,1,1,231,57},{13,0,1,1,231,61},{14,1,1,1,231,61},{13,0,1,1,231,65},{14,1,1,1,231,65},{13,0,1,1,231,95},{14,1,1,1,231,95},{13,0,1,1,231,98},{14,1,1,1,231,98},{13,0,1,1,231,100},{14,1,1,1,231,100},{13,0,1,1,231,102},{14,1,1,1,231,102},{13,0,1,1,231,103},{14,1,1,1,231,103},{13,0,1,1,231,104},{14,1,1,1,231,104},{13,0,1,1,231,108},{14,1,1,1,231,108},{13,0,1,1,231,109},{14,1,1,1,231,109},{13,0,1,1,231,110},{14,1,1,1,231,110},{13,0,1,1,231,112},{14,1,1,1,231,112},{13,0,1,1,231,114},{14,1,1,1,231,114},{13,0,1,1,231,117},{14,1,1,1,231,117},{0,1,1,1,231,58},{0,1,1,1,231,66},{0,1,1,1,231,67},{0,1,1,1,231,68},{0,1,1,1,231,69},{0,1,1,1,231,70},{0,1,1,1,231,71},{0,1,1,1,231,72},{0,1,1,1,231,73},{0,1,1,1,231,74},{0,1,1,1,231,75},{0,1,1,1,231,76},{0,1,1,1,231,77},{0,1,1,1,231,78},{0,1,1,1,231,79},{0,1,1,1,231,80},{0,1,1,1,231,81},{0,1,1,1,231,82},{0,1,1,1,231,83},{0,1,1,1,231,84},{0,1,1,1,231,85},{0,1,1,1,231,86},{0,1,1,1,231,87},{0,1,1,1,231,89},{0,1,1,1,231,106},{0,1,1,1,231,107},{0,1,1,1,231,113},{0,1,1,1,231,118},{0,1,1,1,231,119},{0,1,1,1,231,120},{0,1,1,1,231,121},{0,1,1,1,231,122},{85,0,0,1,0,231},{86,0,0,1,0,231},{87,0,0,1,0,231},{88,1,0,1,0,231},{9,0,1,1,239,48},{10,0,1,1,239,48},{11,0,1,1,239,48},{12,1,1,1,239,48},{9,0,1,1,239,49},{10,0,1,1,239,49},{11,0,1,1,239,49},{12,1,1,1,239,49},{9,0,1,1,239,50},{10,0,1,1,239,50},{11,0,1,1,239,50},{12,1,1,1,239,50},{9,0,1,1,239,97},{10,0,1,1,239,97},{11,0,1,1,239,97},{12,1,1,1,239,97},{9,0,1,1,239,99},{10,0,1,1,239,99},{11,0,1,1,239,99},{12,1,1,1,239,99},{9,0,1,1,239,101},{10,0,1,1,239,101},{11,0,1,1,239,101},{12,1,1,1,239,101},{9,0,1,1,239,105},{10,0,1,1,239,105},{11,0,1,1,239,105},{12,1,1,1,239,105},{9,0,1,1,239,111},{10,0,1,1,239,111},{11,0,1,1,239,111},{12,1,1,1,239,111},{9,0,1,1,239,115},{10,0,1,1,239,115},{11,0,1,1,239,115},{12,1,1,1,239,115},{9,0,1,1,239,116},{10,0,1,1,239,116},{11,0,1,1,239,116},{12,1,1,1,239,116},{13,0,1,1,239,32},{14,1,1,1,239,32},{13,0,1,1,239,37},{14,1,1,1,239,37},{13,0,1,1,239,45},{14,1,1,1,239,45},{13,0,1,1,239,46},{14,1,1,1,239,46},{13,0,1,1,239,47},{14,1,1,1,239,47},{13,0,1,1,239,51},{14,1,1,1,239,51},{13,0,1,1,239,52},{14,1,1,1,239,52},{13,0,1,1,239,53},{14,1,1,1,239,53},{13,0,1,1,239,54},{14,1,1,1,239,54},{13,0,1,1,239,55},{14,1,1,1,239,55},{13,0,1,1,239,56},{14,1,1,1,239,56},{13,0,1,1,239,57},{14,1,1,1,239,57},{13,0,1,1,239,61},{14,1,1,1,239,61},{13,0,1,1,239,65},{14,1,1,1,239,65},{13,0,1,1,239,95},{14,1,1,1,239,95},{13,0,1,1,239,98},{14,1,1,1,239,98},{13,0,1,1,239,100},{14,1,1,1,239,100},{13,0,1,1,239,102},{14,1,1,1,239,102},{13,0,1,1,239,103},{14,1,1,1,239,103},{13,0,1,1,239,104},{14,1,1,1,239,104},{13,0,1,1,239,108},{14,1,1,1,239,108},{13,0,1,1,239,109},{14,1,1,1,239,109},{13,0,1,1,239,110},{14,1,1,1,239,110},{13,0,1,1,239,112},{14,1,1,1,239,112},{13,0,1,1,239,114},{14,1,1,1,239,114},{13,0,1,1,239,117},{14,1,1,1,239,117},{0,1,1,1,239,58},{0,1,1,1,239,66},{0,1,1,1,239,67},{0,1,1,1,239,68},{0,1,1,1,239,69},{0,1,1,1,239,70},{0,1,1,1,239,71},{0,1,1,1,239,72},{0,1,1,1,239,73},{0,1,1,1,239,74},{0,1,1,1,239,75},{0,1,1,1,239,76},{0,1,1,1,239,77},{0,1,1,1,239,78},{0,1,1,1,239,79},{0,1,1,1,239,80},{0,1,1,1,239,81},{0,1,1,1,239,82},{0,1,1,1,239,83},{0,1,1,1,239,84},{0,1,1,1,239,85},{0,1,1,1,239,86},{0,1,1,1,239,87},{0,1,1,1,239,89},{0,1,1,1,239,106},{0,1,1,1,239,107},{0,1,1,1,239,113},{0,1,1,1,239,118},{0,1,1,1,239,119},{0,1,1,1,239,120},{0,1,1,1,239,121},{0,1,1,1,239,122},{85,0,0,1,0,239},{86,0,0,1,0,239},{87,0,0,1,0,239},{88,1,0,1,0,239},{13,0,1,1,9,48},{14,1,1,1,9,48},{13,0,1,1,9,49},{14,1,1,1,9,49},{13,0,1,1,9,50},{14,1,1,1,9,50},{13,0,1,1,9,97},{14,1,1,1,9,97},{13,0,1,1,9,99},{14,1,1,1,9,99},{13,0,1,1,9,101},{14,1,1,1,9,101},{13,0,1,1,9,105},{14,1,1,1,9,105},{13,0,1,1,9,111},{14,1,1,1,9,111},{13,0,1,1,9,115},{14,1,1,1,9,115},{13,0,1,1,9,116},{14,1,1,1,9,116},{0,1,1,1,9,32},{0,1,1,1,9,37},{0,1,1,1,9,45},{0,1,1,1,9,46},{0,1,1,1,9,47},{0,1,1,1,9,51},{0,1,1,1,9,52},{0,1,1,1,9,53},{0,1,1,1,9,54},{0,1,1,1,9,55},{0,1,1,1,9,56},{0,1,1,1,9,57},{0,1,1,1,9,61},{0,1,1,1,9,65},{0,1,1,1,9,95},{0,1,1,1,9,98},{0,1,1,1,9,100},{0,1,1,1,9,102},{0,1,1,1,9,103},{0,1,1,1,9,104},{0,1,1,1,9,108},{0,1,1,1,9,109},{0,1,1,1,9,110},{0,1,1,1,9,112},{0,1,1,1,9,114},{0,1,1,1,9,117},{17,0,0,1,0,9},{18,0,0,1,0,9},{19,0,0,1,0,9},{20,0,0,1,0,9},{21,0,0,1,0,9},{22,0,0,1,0,9},{23,0,0,1,0,9},{24,0,0,1,0,9},{25,0,0,1,0,9},{26,0,0,1,0,9},{27,0,0,1,0,9},{28,0,0,1,0,9},{29,0,0,1,0,9},{30,0,0,1,0,9},{31,0,0,1,0,9},{32,0,0,1,0,9},{33,0,0,1,0,9},{34,1,0,1,0,9},{13,0,1,1,142,48},{14,1,1,1,142,48},{13,0,1,1,142,49},{14,1,1,1,142,49},{13,0,1,1,142,50},{14,1,1,1,142,50},{13,0,1,1,142,97},{14,1,1,1,142,97},{13,0,1,1,142,99},{14,1,1,1,142,99},{13,0,1,1,142,101},{14,1,1,1,142,101},{13,0,1,1,142,105},{14,1,1,1,142,105},{13,0,1,1,142,111},{14,1,1,1,142,111},{13,0,1,1,142,115},{14,1,1,1,142,115},{13,0,1,1,142,116},{14,1,1,1,142,116},{0,1,1,1,142,32},{0,1,1,1,142,37},{0,1,1,1,142,45},{0,1,1,1,142,46},{0,1,1,1,142,47},{0,1,1,1,142,51},{0,1,1,1,142,52},{0,1,1,1,142,53},{0,1,1,1,142,54},{0,1,1,1,142,55},{0,1,1,1,142,56},{0,1,1,1,142,57},{0,1,1,1,142,61},{0,1,1,1,142,65},{0,1,1,1,142,95},{0,1,1,1,142,98},{0,1,1,1,142,100},{0,1,1,1,142,102},{0,1,1,1,142,103},{0,1,1,1,142,104},{0,1,1,1,142,108},{0,1,1,1,142,109},{0,1,1,1,142,110},{0,1,1,1,142,112},{0,1,1,1,142,114},{0,1,1,1,142,117},{17,0,0,1,0,142},{18,0,0,1,0,142},{19,0,0,1,0,142},{20,0,0,1,0,142},{21,0,0,1,0,142},{22,0,0,1,0,142},{23,0,0,1,0,142},{24,0,0,1,0,142},{25,0,0,1,0,142},{26,0,0,1,0,142},{27,0,0,1,0,142},{28,0,0,1,0,142},{29,0,0,1,0,142},{30,0,0,1,0,142},{31,0,0,1,0,142},{32,0,0,1,0,142},{33,0,0,1,0,142},{34,1,0,1,0,142},{13,0,1,1,144,48},{14,1,1,1,144,48},{13,0,1,1,144,49},{14,1,1,1,144,49},{13,0,1,1,144,50},{14,1,1,1,144,50},{13,0,1,1,144,97},{14,1,1,1,144,97},{13,0,1,1,144,99},{14,1,1,1,144,99},{13,0,1,1,144,101},{14,1,1,1,144,101},{13,0,1,1,144,105},{14,1,1,1,144,105},{13,0,1,1,144,111},{14,1,1,1,144,111},{13,0,1,1,144,115},{14,1,1,1,144,115},{13,0,1,1,144,116},{14,1,1,1,144,116},{0,1,1,1,144,32},{0,1,1,1,144,37},{0,1,1,1,144,45},{0,1,1,1,144,46},{0,1,1,1,144,47},{0,1,1,1,144,51},{0,1,1,1,144,52},{0,1,1,1,144,53},{0,1,1,1,144,54},{0,1,1,1,144,55},{0,1,1,1,144,56},{0,1,1,1,144,57},{0,1,1,1,144,61},{0,1,1,1,144,65},{0,1,1,1,144,95},{0,1,1,1,144,98},{0,1,1,1,144,100},{0,1,1,1,144,102},{0,1,1,1,144,103},{0,1,1,1,144,104},{0,1,1,1,144,108},{0,1,1,1,144,109},{0,1,1,1,144,110},{0,1,1,1,144,112},{0,1,1,1,144,114},{0,1,1,1,144,117},{17,0,0,1,0,144},{18,0,0,1,0,144},{19,0,0,1,0,144},{20,0,0,1,0,144},{21,0,0,1,0,144},{22,0,0,1,0,144},{23,0,0,1,0,144},{24,0,0,1,0,144},{25,0,0,1,0,144},{26,0,0,1,0,144},{27,0,0,1,0,144},{28,0,0,1,0,144},{29,0,0,1,0,144},{30,0,0,1,0,144},{31,0,0,1,0,144},{32,0,0,1,0,144},{33,0,0,1,0,144},{34,1,0,1,0,144},{13,0,1,1,145,48},{14,1,1,1,145,48},{13,0,1,1,145,49},{14,1,1,1,145,49},{13,0,1,1,145,50},{14,1,1,1,145,50},{13,0,1,1,145,97},{14,1,1,1,145,97},{13,0,1,1,145,99},{14,1,1,1,145,99},{13,0,1,1,145,101},{14,1,1,1,145,101},{13,0,1,1,145,105},{14,1,1,1,145,105},{13,0,1,1,145,111},{14,1,1,1,145,111},{13,0,1,1,145,115},{14,1,1,1,145,115},{13,0,1,1,145,116},{14,1,1,1,145,116},{0,1,1,1,145,32},{0,1,1,1,145,37},{0,1,1,1,145,45},{0,1,1,1,145,46},{0,1,1,1,145,47},{0,1,1,1,145,51},{0,1,1,1,145,52},{0,1,1,1,145,53},{0,1,1,1,145,54},{0,1,1,1,145,55},{0,1,1,1,145,56},{0,1,1,1,145,57},{0,1,1,1,145,61},{0,1,1,1,145,65},{0,1,1,1,145,95},{0,1,1,1,145,98},{0,1,1,1,145,100},{0,1,1,1,145,102},{0,1,1,1,145,103},{0,1,1,1,145,104},{0,1,1,1,145,108},{0,1,1,1,145,109},{0,1,1,1,145,110},{0,1,1,1,145,112},{0,1,1,1,145,114},{0,1,1,1,145,117},{17,0,0,1,0,145},{18,0,0,1,0,145},{19,0,0,1,0,145},{20,0,0,1,0,145},{21,0,0,1,0,145},{22,0,0,1,0,145},{23,0,0,1,0,145},{24,0,0,1,0,145},{25,0,0,1,0,145},{26,0,0,1,0,145},{27,0,0,1,0,145},{28,0,0,1,0,145},{29,0,0,1,0,145},{30,0,0,1,0,145},{31,0,0,1,0,145},{32,0,0,1,0,145},{33,0,0,1,0,145},{34,1,0,1,0,145},{13,0,1,1,148,48},{14,1,1,1,148,48},{13,0,1,1,148,49},{14,1,1,1,148,49},{13,0,1,1,148,50},{14,1,1,1,148,50},{13,0,1,1,148,97},{14,1,1,1,148,97},{13,0,1,1,148,99},{14,1,1,1,148,99},{13,0,1,1,148,101},{14,1,1,1,148,101},{13,0,1,1,148,105},{14,1,1,1,148,105},{13,0,1,1,148,111},{14,1,1,1,148,111},{13,0,1,1,148,115},{14,1,1,1,148,115},{13,0,1,1,148,116},{14,1,1,1,148,116},{0,1,1,1,148,32},{0,1,1,1,148,37},{0,1,1,1,148,45},{0,1,1,1,148,46},{0,1,1,1,148,47},{0,1,1,1,148,51},{0,1,1,1,148,52},{0,1,1,1,148,53},{0,1,1,1,148,54},{0,1,1,1,148,55},{0,1,1,1,148,56},{0,1,1,1,148,57},{0,1,1,1,148,61},{0,1,1,1,148,65},{0,1,1,1,148,95},{0,1,1,1,148,98},{0,1,1,1,148,100},{0,1,1,1,148,102},{0,1,1,1,148,103},{0,1,1,1,148,104},{0,1,1,1,148,108},{0,1,1,1,148,109},{0,1,1,1,148,110},{0,1,1,1,148,112},{0,1,1,1,148,114},{0,1,1,1,148,117},{17,0,0,1,0,148},{18,0,0,1,0,148},{19,0,0,1,0,148},{20,0,0,1,0,148},{21,0,0,1,0,148},{22,0,0,1,0,148},{23,0,0,1,0,148},{24,0,0,1,0,148},{25,0,0,1,0,148},{26,0,0,1,0,148},{27,0,0,1,0,148},{28,0,0,1,0,148},{29,0,0,1,0,148},{30,0,0,1,0,148},{31,0,0,1,0,148},{32,0,0,1,0,148},{33,0,0,1,0,148},{34,1,0,1,0,148},{13,0,1,1,159,48},{14,1,1,1,159,48},{13,0,1,1,159,49},{14,1,1,1,159,49},{13,0,1,1,159,50},{14,1,1,1,159,50},{13,0,1,1,159,97},{14,1,1,1,159,97},{13,0,1,1,159,99},{14,1,1,1,159,99},{13,0,1,1,159,101},{14,1,1,1,159,101},{13,0,1,1,159,105},{14,1,1,1,159,105},{13,0,1,1,159,111},{14,1,1,1,159,111},{13,0,1,1,159,115},{14,1,1,1,159,115},{13,0,1,1,159,116},{14,1,1,1,159,116},{0,1,1,1,159,32},{0,1,1,1,159,37},{0,1,1,1,159,45},{0,1,1,1,159,46},{0,1,1,1,159,47},{0,1,1,1,159,51},{0,1,1,1,159,52},{0,1,1,1,159,53},{0,1,1,1,159,54},{0,1,1,1,159,55},{0,1,1,1,159,56},{0,1,1,1,159,57},{0,1,1,1,159,61},{0,1,1,1,159,65},{0,1,1,1,159,95},{0,1,1,1,159,98},{0,1,1,1,159,100},{0,1,1,1,159,102},{0,1,1,1,159,103},{0,1,1,1,159,104},{0,1,1,1,159,108},{0,1,1,1,159,109},{0,1,1,1,159,110},{0,1,1,1,159,112},{0,1,1,1,159,114},{0,1,1,1,159,117},{17,0,0,1,0,159},{18,0,0,1,0,159},{19,0,0,1,0,159},{20,0,0,1,0,159},{21,0,0,1,0,159},{22,0,0,1,0,159},{23,0,0,1,0,159},{24,0,0,1,0,159},{25,0,0,1,0,159},{26,0,0,1,0,159},{27,0,0,1,0,159},{28,0,0,1,0,159},{29,0,0,1,0,159},{30,0,0,1,0,159},{31,0,0,1,0,159},{32,0,0,1,0,159},{33,0,0,1,0,159},{34,1,0,1,0,159},{13,0,1,1,171,48},{14,1,1,1,171,48},{13,0,1,1,171,49},{14,1,1,1,171,49},{13,0,1,1,171,50},{14,1,1,1,171,50},{13,0,1,1,171,97},{14,1,1,1,171,97},{13,0,1,1,171,99},{14,1,1,1,171,99},{13,0,1,1,171,101},{14,1,1,1,171,101},{13,0,1,1,171,105},{14,1,1,1,171,105},{13,0,1,1,171,111},{14,1,1,1,171,111},{13,0,1,1,171,115},{14,1,1,1,171,115},{13,0,1,1,171,116},{14,1,1,1,171,116},{0,1,1,1,171,32},{0,1,1,1,171,37},{0,1,1,1,171,45},{0,1,1,1,171,46},{0,1,1,1,171,47},{0,1,1,1,171,51},{0,1,1,1,171,52},{0,1,1,1,171,53},{0,1,1,1,171,54},{0,1,1,1,171,55},{0,1,1,1,171,56},{0,1,1,1,171,57},{0,1,1,1,171,61},{0,1,1,1,171,65},{0,1,1,1,171,95},{0,1,1,1,171,98},{0,1,1,1,171,100},{0,1,1,1,171,102},{0,1,1,1,171,103},{0,1,1,1,171,104},{0,1,1,1,171,108},{0,1,1,1,171,109},{0,1,1,1,171,110},{0,1,1,1,171,112},{0,1,1,1,171,114},{0,1,1,1,171,117},{17,0,0,1,0,171},{18,0,0,1,0,171},{19,0,0,1,0,171},{20,0,0,1,0,171},{21,0,0,1,0,171},{22,0,0,1,0,171},{23,0,0,1,0,171},{24,0,0,1,0,171},{25,0,0,1,0,171},{26,0,0,1,0,171},{27,0,0,1,0,171},{28,0,0,1,0,171},{29,0,0,1,0,171},{30,0,0,1,0,171},{31,0,0,1,0,171},{32,0,0,1,0,171},{33,0,0,1,0,171},{34,1,0,1,0,171},{13,0,1,1,206,48},{14,1,1,1,206,48},{13,0,1,1,206,49},{14,1,1,1,206,49},{13,0,1,1,206,50},{14,1,1,1,206,50},{13,0,1,1,206,97},{14,1,1,1,206,97},{13,0,1,1,206,99},{14,1,1,1,206,99},{13,0,1,1,206,101},{14,1,1,1,206,101},{13,0,1,1,206,105},{14,1,1,1,206,105},{13,0,1,1,206,111},{14,1,1,1,206,111},{13,0,1,1,206,115},{14,1,1,1,206,115},{13,0,1,1,206,116},{14,1,1,1,206,116},{0,1,1,1,206,32},{0,1,1,1,206,37},{0,1,1,1,206,45},{0,1,1,1,206,46},{0,1,1,1,206,47},{0,1,1,1,206,51},{0,1,1,1,206,52},{0,1,1,1,206,53},{0,1,1,1,206,54},{0,1,1,1,206,55},{0,1,1,1,206,56},{0,1,1,1,206,57},{0,1,1,1,206,61},{0,1,1,1,206,65},{0,1,1,1,206,95},{0,1,1,1,206,98},{0,1,1,1,206,100},{0,1,1,1,206,102},{0,1,1,1,206,103},{0,1,1,1,206,104},{0,1,1,1,206,108},{0,1,1,1,206,109},{0,1,1,1,206,110},{0,1,1,1,206,112},{0,1,1,1,206,114},{0,1,1,1,206,117},{17,0,0,1,0,206},{18,0,0,1,0,206},{19,0,0,1,0,206},{20,0,0,1,0,206},{21,0,0,1,0,206},{22,0,0,1,0,206},{23,0,0,1,0,206},{24,0,0,1,0,206},{25,0,0,1,0,206},{26,0,0,1,0,206},{27,0,0,1,0,206},{28,0,0,1,0,206},{29,0,0,1,0,206},{30,0,0,1,0,206},{31,0,0,1,0,206},{32,0,0,1,0,206},{33,0,0,1,0,206},{34,1,0,1,0,206},{13,0,1,1,215,48},{14,1,1,1,215,48},{13,0,1,1,215,49},{14,1,1,1,215,49},{13,0,1,1,215,50},{14,1,1,1,215,50},{13,0,1,1,215,97},{14,1,1,1,215,97},{13,0,1,1,215,99},{14,1,1,1,215,99},{13,0,1,1,215,101},{14,1,1,1,215,101},{13,0,1,1,215,105},{14,1,1,1,215,105},{13,0,1,1,215,111},{14,1,1,1,215,111},{13,0,1,1,215,115},{14,1,1,1,215,115},{13,0,1,1,215,116},{14,1,1,1,215,116},{0,1,1,1,215,32},{0,1,1,1,215,37},{0,1,1,1,215,45},{0,1,1,1,215,46},{0,1,1,1,215,47},{0,1,1,1,215,51},{0,1,1,1,215,52},{0,1,1,1,215,53},{0,1,1,1,215,54},{0,1,1,1,215,55},{0,1,1,1,215,56},{0,1,1,1,215,57},{0,1,1,1,215,61},{0,1,1,1,215,65},{0,1,1,1,215,95},{0,1,1,1,215,98},{0,1,1,1,215,100},{0,1,1,1,215,102},{0,1,1,1,215,103},{0,1,1,1,215,104},{0,1,1,1,215,108},{0,1,1,1,215,109},{0,1,1,1,215,110},{0,1,1,1,215,112},{0,1,1,1,215,114},{0,1,1,1,215,117},{17,0,0,1,0,215},{18,0,0,1,0,215},{19,0,0,1,0,215},{20,0,0,1,0,215},{21,0,0,1,0,215},{22,0,0,1,0,215},{23,0,0,1,0,215},{24,0,0,1,0,215},{25,0,0,1,0,215},{26,0,0,1,0,215},{27,0,0,1,0,215},{28,0,0,1,0,215},{29,0,0,1,0,215},{30,0,0,1,0,215},{31,0,0,1,0,215},{32,0,0,1,0,215},{33,0,0,1,0,215},{34,1,0,1,0,215},{13,0,1,1,225,48},{14,1,1,1,225,48},{13,0,1,1,225,49},{14,1,1,1,225,49},{13,0,1,1,225,50},{14,1,1,1,225,50},{13,0,1,1,225,97},{14,1,1,1,225,97},{13,0,1,1,225,99},{14,1,1,1,225,99},{13,0,1,1,225,101},{14,1,1,1,225,101},{13,0,1,1,225,105},{14,1,1,1,225,105},{13,0,1,1,225,111},{14,1,1,1,225,111},{13,0,1,1,225,115},{14,1,1,1,225,115},{13,0,1,1,225,116},{14,1,1,1,225,116},{0,1,1,1,225,32},{0,1,1,1,225,37},{0,1,1,1,225,45},{0,1,1,1,225,46},{0,1,1,1,225,47},{0,1,1,1,225,51},{0,1,1,1,225,52},{0,1,1,1,225,53},{0,1,1,1,225,54},{0,1,1,1,225,55},{0,1,1,1,225,56},{0,1,1,1,225,57},{0,1,1,1,225,61},{0,1,1,1,225,65},{0,1,1,1,225,95},{0,1,1,1,225,98},{0,1,1,1,225,100},{0,1,1,1,225,102},{0,1,1,1,225,103},{0,1,1,1,225,104},{0,1,1,1,225,108},{0,1,1,1,225,109},{0,1,1,1,225,110},{0,1,1,1,225,112},{0,1,1,1,225,114},{0,1,1,1,225,117},{17,0,0,1,0,225},{18,0,0,1,0,225},{19,0,0,1,0,225},{20,0,0,1,0,225},{21,0,0,1,0,225},{22,0,0,1,0,225},{23,0,0,1,0,225},{24,0,0,1,0,225},{25,0,0,1,0,225},{26,0,0,1,0,225},{27,0,0,1,0,225},{28,0,0,1,0,225},{29,0,0,1,0,225},{30,0,0,1,0,225},{31,0,0,1,0,225},{32,0,0,1,0,225},{33,0,0,1,0,225},{34,1,0,1,0,225},{13,0,1,1,236,48},{14,1,1,1,236,48},{13,0,1,1,236,49},{14,1,1,1,236,49},{13,0,1,1,236,50},{14,1,1,1,236,50},{13,0,1,1,236,97},{14,1,1,1,236,97},{13,0,1,1,236,99},{14,1,1,1,236,99},{13,0,1,1,236,101},{14,1,1,1,236,101},{13,0,1,1,236,105},{14,1,1,1,236,105},{13,0,1,1,236,111},{14,1,1,1,236,111},{13,0,1,1,236,115},{14,1,1,1,236,115},{13,0,1,1,236,116},{14,1,1,1,236,116},{0,1,1,1,236,32},{0,1,1,1,236,37},{0,1,1,1,236,45},{0,1,1,1,236,46},{0,1,1,1,236,47},{0,1,1,1,236,51},{0,1,1,1,236,52},{0,1,1,1,236,53},{0,1,1,1,236,54},{0,1,1,1,236,55},{0,1,1,1,236,56},{0,1,1,1,236,57},{0,1,1,1,236,61},{0,1,1,1,236,65},{0,1,1,1,236,95},{0,1,1,1,236,98},{0,1,1,1,236,100},{0,1,1,1,236,102},{0,1,1,1,236,103},{0,1,1,1,236,104},{0,1,1,1,236,108},{0,1,1,1,236,109},{0,1,1,1,236,110},{0,1,1,1,236,112},{0,1,1,1,236,114},{0,1,1,1,236,117},{17,0,0,1,0,236},{18,0,0,1,0,236},{19,0,0,1,0,236},{20,0,0,1,0,236},{21,0,0,1,0,236},{22,0,0,1,0,236},{23,0,0,1,0,236},{24,0,0,1,0,236},{25,0,0,1,0,236},{26,0,0,1,0,236},{27,0,0,1,0,236},{28,0,0,1,0,236},{29,0,0,1,0,236},{30,0,0,1,0,236},{31,0,0,1,0,236},{32,0,0,1,0,236},{33,0,0,1,0,236},{34,1,0,1,0,236},{13,0,1,1,237,48},{14,1,1,1,237,48},{13,0,1,1,237,49},{14,1,1,1,237,49},{13,0,1,1,237,50},{14,1,1,1,237,50},{13,0,1,1,237,97},{14,1,1,1,237,97},{13,0,1,1,237,99},{14,1,1,1,237,99},{13,0,1,1,237,101},{14,1,1,1,237,101},{13,0,1,1,237,105},{14,1,1,1,237,105},{13,0,1,1,237,111},{14,1,1,1,237,111},{13,0,1,1,237,115},{14,1,1,1,237,115},{13,0,1,1,237,116},{14,1,1,1,237,116},{0,1,1,1,237,32},{0,1,1,1,237,37},{0,1,1,1,237,45},{0,1,1,1,237,46},{0,1,1,1,237,47},{0,1,1,1,237,51},{0,1,1,1,237,52},{0,1,1,1,237,53},{0,1,1,1,237,54},{0,1,1,1,237,55},{0,1,1,1,237,56},{0,1,1,1,237,57},{0,1,1,1,237,61},{0,1,1,1,237,65},{0,1,1,1,237,95},{0,1,1,1,237,98},{0,1,1,1,237,100},{0,1,1,1,237,102},{0,1,1,1,237,103},{0,1,1,1,237,104},{0,1,1,1,237,108},{0,1,1,1,237,109},{0,1,1,1,237,110},{0,1,1,1,237,112},{0,1,1,1,237,114},{0,1,1,1,237,117},{17,0,0,1,0,237},{18,0,0,1,0,237},{19,0,0,1,0,237},{20,0,0,1,0,237},{21,0,0,1,0,237},{22,0,0,1,0,237},{23,0,0,1,0,237},{24,0,0,1,0,237},{25,0,0,1,0,237},{26,0,0,1,0,237},{27,0,0,1,0,237},{28,0,0,1,0,237},{29,0,0,1,0,237},{30,0,0,1,0,237},{31,0,0,1,0,237},{32,0,0,1,0,237},{33,0,0,1,0,237},{34,1,0,1,0,237},{0,1,1,1,199,48},{0,1,1,1,199,49},{0,1,1,1,199,50},{0,1,1,1,199,97},{0,1,1,1,199,99},{0,1,1,1,199,101},{0,1,1,1,199,105},{0,1,1,1,199,111},{0,1,1,1,199,115},{0,1,1,1,199,116},{35,0,0,1,0,199},{36,0,0,1,0,199},{37,0,0,1,0,199},{38,0,0,1,0,199},{39,0,0,1,0,199},{40,0,0,1,0,199},{41,0,0,1,0,199},{42,0,0,1,0,199},{43,0,0,1,0,199},{44,0,0,1,0,199},{45,0,0,1,0,199},{46,0,0,1,0,199},{47,0,0,1,0,199},{48,0,0,1,0,199},{49,0,0,1,0,199},{50,0,0,1,0,199},{51,0,0,1,0,199},{52,0,0,1,0,199},{53,0,0,1,0,199},{54,0,0,1,0,199},{55,0,0,1,0,199},{56,1,0,1,0,199},{0,1,1,1,207,48},{0,1,1,1,207,49},{0,1,1,1,207,50},{0,1,1,1,207,97},{0,1,1,1,207,99},{0,1,1,1,207,101},{0,1,1,1,207,105},{0,1,1,1,207,111},{0,1,1,1,207,115},{0,1,1,1,207,116},{35,0,0,1,0,207},{36,0,0,1,0,207},{37,0,0,1,0,207},{38,0,0,1,0,207},{39,0,0,1,0,207},{40,0,0,1,0,207},{41,0,0,1,0,207},{42,0,0,1,0,207},{43,0,0,1,0,207},{44,0,0,1,0,207},{45,0,0,1,0,207},{46,0,0,1,0,207},{47,0,0,1,0,207},{48,0,0,1,0,207},{49,0,0,1,0,207},{50,0,0,1,0,207},{51,0,0,1,0,207},{52,0,0,1,0,207},{53,0,0,1,0,207},{54,0,0,1,0,207},{55,0,0,1,0,207},{56,1,0,1,0,207},{0,1,1,1,234,48},{0,1,1,1,234,49},{0,1,1,1,234,50},{0,1,1,1,234,97},{0,1,1,1,234,99},{0,1,1,1,234,101},{0,1,1,1,234,105},{0,1,1,1,234,111},{0,1,1,1,234,115},{0,1,1,1,234,116},{35,0,0,1,0,234},{36,0,0,1,0,234},{37,0,0,1,0,234},{38,0,0,1,0,234},{39,0,0,1,0,234},{40,0,0,1,0,234},{41,0,0,1,0,234},{42,0,0,1,0,234},{43,0,0,1,0,234},{44,0,0,1,0,234},{45,0,0,1,0,234},{46,0,0,1,0,234},{47,0,0,1,0,234},{48,0,0,1,0,234},{49,0,0,1,0,234},{50,0,0,1,0,234},{51,0,0,1,0,234},{52,0,0,1,0,234},{53,0,0,1,0,234},{54,0,0,1,0,234},{55,0,0,1,0,234},{56,1,0,1,0,234},{0,1,1,1,235,48},{0,1,1,1,235,49},{0,1,1,1,235,50},{0,1,1,1,235,97},{0,1,1,1,235,99},{0,1,1,1,235,101},{0,1,1,1,235,105},{0,1,1,1,235,111},{0,1,1,1,235,115},{0,1,1,1,235,116},{35,0,0,1,0,235},{36,0,0,1,0,235},{37,0,0,1,0,235},{38,0,0,1,0,235},{39,0,0,1,0,235},{40,0,0,1,0,235},{41,0,0,1,0,235},{42,0,0,1,0,235},{43,0,0,1,0,235},{44,0,0,1,0,235},{45,0,0,1,0,235},{46,0,0,1,0,235},{47,0,0,1,0,235},{48,0,0,1,0,235},{49,0,0,1,0,235},{50,0,0,1,0,235},{51,0,0,1,0,235},{52,0,0,1,0,235},{53,0,0,1,0,235},{54,0,0,1,0,235},{55,0,0,1,0,235},{56,1,0,1,0,235},{57,0,0,1,0,192},{58,0,0,1,0,192},{59,0,0,1,0,192},{60,0,0,1,0,192},{61,0,0,1,0,192},{62,0,0,1,0,192},{63,0,0,1,0,192},{64,0,0,1,0,192},{65,0,0,1,0,192},{66,0,0,1,0,192},{67,0,0,1,0,192},{68,0,0,1,0,192},{69,0,0,1,0,192},{70,0,0,1,0,192},{71,0,0,1,0,192},{72,1,0,1,0,192},{57,0,0,1,0,193},{58,0,0,1,0,193},{59,0,0,1,0,193},{60,0,0,1,0,193},{61,0,0,1,0,193},{62,0,0,1,0,193},{63,0,0,1,0,193},{64,0,0,1,0,193},{65,0,0,1,0,193},{66,0,0,1,0,193},{67,0,0,1,0,193},{68,0,0,1,0,193},{69,0,0,1,0,193},{70,0,0,1,0,193},{71,0,0,1,0,193},{72,1,0,1,0,193},{57,0,0,1,0,200},{58,0,0,1,0,200},{59,0,0,1,0,200},{60,0,0,1,0,200},{61,0,0,1,0,200},{62,0,0,1,0,200},{63,0,0,1,0,200},{64,0,0,1,0,200},{65,0,0,1,0,200},{66,0,0,1,0,200},{67,0,0,1,0,200},{68,0,0,1,0,200},{69,0,0,1,0,200},{70,0,0,1,0,200},{71,0,0,1,0,200},{72,1,0,1,0,200},{57,0,0,1,0,201},{58,0,0,1,0,201},{59,0,0,1,0,201},{60,0,0,1,0,201},{61,0,0,1,0,201},{62,0,0,1,0,201},{63,0,0,1,0,201},{64,0,0,1,0,201},{65,0,0,1,0,201},{66,0,0,1,0,201},{67,0,0,1,0,201},{68,0,0,1,0,201},{69,0,0,1,0,201},{70,0,0,1,0,201},{71,0,0,1,0,201},{72,1,0,1,0,201},{57,0,0,1,0,202},{58,0,0,1,0,202},{59,0,0,1,0,202},{60,0,0,1,0,202},{61,0,0,1,0,202},{62,0,0,1,0,202},{63,0,0,1,0,202},{64,0,0,1,0,202},{65,0,0,1,0,202},{66,0,0,1,0,202},{67,0,0,1,0,202},{68,0,0,1,0,202},{69,0,0,1,0,202},{70,0,0,1,0,202},{71,0,0,1,0,202},{72,1,0,1,0,202},{57,0,0,1,0,205},{58,0,0,1,0,205},{59,0,0,1,0,205},{60,0,0,1,0,205},{61,0,0,1,0,205},{62,0,0,1,0,205},{63,0,0,1,0,205},{64,0,0,1,0,205},{65,0,0,1,0,205},{66,0,0,1,0,205},{67,0,0,1,0,205},{68,0,0,1,0,205},{69,0,0,1,0,205},{70,0,0,1,0,205},{71,0,0,1,0,205},{72,1,0,1,0,205},{57,0,0,1,0,210},{58,0,0,1,0,210},{59,0,0,1,0,210},{60,0,0,1,0,210},{61,0,0,1,0,210},{62,0,0,1,0,210},{63,0,0,1,0,210},{64,0,0,1,0,210},{65,0,0,1,0,210},{66,0,0,1,0,210},{67,0,0,1,0,210},{68,0,0,1,0,210},{69,0,0,1,0,210},{70,0,0,1,0,210},{71,0,0,1,0,210},{72,1,0,1,0,210},{57,0,0,1,0,213},{58,0,0,1,0,213},{59,0,0,1,0,213},{60,0,0,1,0,213},{61,0,0,1,0,213},{62,0,0,1,0,213},{63,0,0,1,0,213},{64,0,0,1,0,213},{65,0,0,1,0,213},{66,0,0,1,0,213},{67,0,0,1,0,213},{68,0,0,1,0,213},{69,0,0,1,0,213},{70,0,0,1,0,213},{71,0,0,1,0,213},{72,1,0,1,0,213},{57,0,0,1,0,218},{58,0,0,1,0,218},{59,0,0,1,0,218},{60,0,0,1,0,218},{61,0,0,1,0,218},{62,0,0,1,0,218},{63,0,0,1,0,218},{64,0,0,1,0,218},{65,0,0,1,0,218},{66,0,0,1,0,218},{67,0,0,1,0,218},{68,0,0,1,0,218},{69,0,0,1,0,218},{70,0,0,1,0,218},{71,0,0,1,0,218},{72,1,0,1,0,218},{57,0,0,1,0,219},{58,0,0,1,0,219},{59,0,0,1,0,219},{60,0,0,1,0,219},{61,0,0,1,0,219},{62,0,0,1,0,219},{63,0,0,1,0,219},{64,0,0,1,0,219},{65,0,0,1,0,219},{66,0,0,1,0,219},{67,0,0,1,0,219},{68,0,0,1,0,219},{69,0,0,1,0,219},{70,0,0,1,0,219},{71,0,0,1,0,219},{72,1,0,1,0,219},{57,0,0,1,0,238},{58,0,0,1,0,238},{59,0,0,1,0,238},{60,0,0,1,0,238},{61,0,0,1,0,238},{62,0,0,1,0,238},{63,0,0,1,0,238},{64,0,0,1,0,238},{65,0,0,1,0,238},{66,0,0,1,0,238},{67,0,0,1,0,238},{68,0,0,1,0,238},{69,0,0,1,0,238},{70,0,0,1,0,238},{71,0,0,1,0,238},{72,1,0,1,0,238},{57,0,0,1,0,240},{58,0,0,1,0,240},{59,0,0,1,0,240},{60,0,0,1,0,240},{61,0,0,1,0,240},{62,0,0,1,0,240},{63,0,0,1,0,240},{64,0,0,1,0,240},{65,0,0,1,0,240},{66,0,0,1,0,240},{67,0,0,1,0,240},{68,0,0,1,0,240},{69,0,0,1,0,240},{70,0,0,1,0,240},{71,0,0,1,0,240},{72,1,0,1,0,240},{57,0,0,1,0,242},{58,0,0,1,0,242},{59,0,0,1,0,242},{60,0,0,1,0,242},{61,0,0,1,0,242},{62,0,0,1,0,242},{63,0,0,1,0,242},{64,0,0,1,0,242},{65,0,0,1,0,242},{66,0,0,1,0,242},{67,0,0,1,0,242},{68,0,0,1,0,242},{69,0,0,1,0,242},{70,0,0,1,0,242},{71,0,0,1,0,242},{72,1,0,1,0,242},{57,0,0,1,0,243},{58,0,0,1,0,243},{59,0,0,1,0,243},{60,0,0,1,0,243},{61,0,0,1,0,243},{62,0,0,1,0,243},{63,0,0,1,0,243},{64,0,0,1,0,243},{65,0,0,1,0,243},{66,0,0,1,0,243},{67,0,0,1,0,243},{68,0,0,1,0,243},{69,0,0,1,0,243},{70,0,0,1,0,243},{71,0,0,1,0,243},{72,1,0,1,0,243},{57,0,0,1,0,255},{58,0,0,1,0,255},{59,0,0,1,0,255},{60,0,0,1,0,255},{61,0,0,1,0,255},{62,0,0,1,0,255},{63,0,0,1,0,255},{64,0,0,1,0,255},{65,0,0,1,0,255},{66,0,0,1,0,255},{67,0,0,1,0,255},{68,0,0,1,0,255},{69,0,0,1,0,255},{70,0,0,1,0,255},{71,0,0,1,0,255},{72,1,0,1,0,255},{1,0,0,1,0,203},{2,0,0,1,0,203},{3,0,0,1,0,203},{4,0,0,1,0,203},{5,0,0,1,0,203},{6,0,0,1,0,203},{7,0,0,1,0,203},{8,1,0,1,0,203},{1,0,0,1,0,204},{2,0,0,1,0,204},{3,0,0,1,0,204},{4,0,0,1,0,204},{5,0,0,1,0,204},{6,0,0,1,0,204},{7,0,0,1,0,204},{8,1,0,1,0,204},{1,0,0,1,0,211},{2,0,0,1,0,211},{3,0,0,1,0,211},{4,0,0,1,0,211},{5,0,0,1,0,211},{6,0,0,1,0,211},{7,0,0,1,0,211},{8,1,0,1,0,211},{1,0,0,1,0,212},{2,0,0,1,0,212},{3,0,0,1,0,212},{4,0,0,1,0,212},{5,0,0,1,0,212},{6,0,0,1,0,212},{7,0,0,1,0,212},{8,1,0,1,0,212},{1,0,0,1,0,214},{2,0,0,1,0,214},{3,0,0,1,0,214},{4,0,0,1,0,214},{5,0,0,1,0,214},{6,0,0,1,0,214},{7,0,0,1,0,214},{8,1,0,1,0,214},{1,0,0,1,0,221},{2,0,0,1,0,221},{3,0,0,1,0,221},{4,0,0,1,0,221},{5,0,0,1,0,221},{6,0,0,1,0,221},{7,0,0,1,0,221},{8,1,0,1,0,221},{1,0,0,1,0,222},{2,0,0,1,0,222},{3,0,0,1,0,222},{4,0,0,1,0,222},{5,0,0,1,0,222},{6,0,0,1,0,222},{7,0,0,1,0,222},{8,1,0,1,0,222},{1,0,0,1,0,223},{2,0,0,1,0,223},{3,0,0,1,0,223},{4,0,0,1,0,223},{5,0,0,1,0,223},{6,0,0,1,0,223},{7,0,0,1,0,223},{8,1,0,1,0,223},{1,0,0,1,0,241},{2,0,0,1,0,241},{3,0,0,1,0,241},{4,0,0,1,0,241},{5,0,0,1,0,241},{6,0,0,1,0,241},{7,0,0,1,0,241},{8,1,0,1,0,241},{1,0,0,1,0,244},{2,0,0,1,0,244},{3,0,0,1,0,244},{4,0,0,1,0,244},{5,0,0,1,0,244},{6,0,0,1,0,244},{7,0,0,1,0,244},{8,1,0,1,0,244},{1,0,0,1,0,245},{2,0,0,1,0,245},{3,0,0,1,0,245},{4,0,0,1,0,245},{5,0,0,1,0,245},{6,0,0,1,0,245},{7,0,0,1,0,245},{8,1,0,1,0,245},{1,0,0,1,0,246},{2,0,0,1,0,246},{3,0,0,1,0,246},{4,0,0,1,0,246},{5,0,0,1,0,246},{6,0,0,1,0,246},{7,0,0,1,0,246},{8,1,0,1,0,246},{1,0,0,1,0,247},{2,0,0,1,0,247},{3,0,0,1,0,247},{4,0,0,1,0,247},{5,0,0,1,0,247},{6,0,0,1,0,247},{7,0,0,1,0,247},{8,1,0,1,0,247},{1,0,0,1,0,248},{2,0,0,1,0,248},{3,0,0,1,0,248},{4,0,0,1,0,248},{5,0,0,1,0,248},{6,0,0,1,0,248},{7,0,0,1,0,248},{8,1,0,1,0,248},{1,0,0,1,0,250},{2,0,0,1,0,250},{3,0,0,1,0,250},{4,0,0,1,0,250},{5,0,0,1,0,250},{6,0,0,1,0,250},{7,0,0,1,0,250},{8,1,0,1,0,250},{1,0,0,1,0,251},{2,0,0,1,0,251},{3,0,0,1,0,251},{4,0,0,1,0,251},{5,0,0,1,0,251},{6,0,0,1,0,251},{7,0,0,1,0,251},{8,1,0,1,0,251},{1,0,0,1,0,252},{2,0,0,1,0,252},{3,0,0,1,0,252},{4,0,0,1,0,252},{5,0,0,1,0,252},{6,0,0,1,0,252},{7,0,0,1,0,252},{8,1,0,1,0,252},{1,0,0,1,0,253},{2,0,0,1,0,253},{3,0,0,1,0,253},{4,0,0,1,0,253},{5,0,0,1,0,253},{6,0,0,1,0,253},{7,0,0,1,0,253},{8,1,0,1,0,253},{1,0,0,1,0,254},{2,0,0,1,0,254},{3,0,0,1,0,254},{4,0,0,1,0,254},{5,0,0,1,0,254},{6,0,0,1,0,254},{7,0,0,1,0,254},{8,1,0,1,0,254},{9,0,0,1,0,2},{10,0,0,1,0,2},{11,0,0,1,0,2},{12,1,0,1,0,2},{9,0,0,1,0,3},{10,0,0,1,0,3},{11,0,0,1,0,3},{12,1,0,1,0,3},{9,0,0,1,0,4},{10,0,0,1,0,4},{11,0,0,1,0,4},{12,1,0,1,0,4},{9,0,0,1,0,5},{10,0,0,1,0,5},{11,0,0,1,0,5},{12,1,0,1,0,5},{9,0,0,1,0,6},{10,0,0,1,0,6},{11,0,0,1,0,6},{12,1,0,1,0,6},{9,0,0,1,0,7},{10,0,0,1,0,7},{11,0,0,1,0,7},{12,1,0,1,0,7},{9,0,0,1,0,8},{10,0,0,1,0,8},{11,0,0,1,0,8},{12,1,0,1,0,8},{9,0,0,1,0,11},{10,0,0,1,0,11},{11,0,0,1,0,11},{12,1,0,1,0,11},{9,0,0,1,0,12},{10,0,0,1,0,12},{11,0,0,1,0,12},{12,1,0,1,0,12},{9,0,0,1,0,14},{10,0,0,1,0,14},{11,0,0,1,0,14},{12,1,0,1,0,14},{9,0,0,1,0,15},{10,0,0,1,0,15},{11,0,0,1,0,15},{12,1,0,1,0,15},{9,0,0,1,0,16},{10,0,0,1,0,16},{11,0,0,1,0,16},{12,1,0,1,0,16},{9,0,0,1,0,17},{10,0,0,1,0,17},{11,0,0,1,0,17},{12,1,0,1,0,17},{9,0,0,1,0,18},{10,0,0,1,0,18},{11,0,0,1,0,18},{12,1,0,1,0,18},{9,0,0,1,0,19},{10,0,0,1,0,19},{11,0,0,1,0,19},{12,1,0,1,0,19},{9,0,0,1,0,20},{10,0,0,1,0,20},{11,0,0,1,0,20},{12,1,0,1,0,20},{9,0,0,1,0,21},{10,0,0,1,0,21},{11,0,0,1,0,21},{12,1,0,1,0,21},{9,0,0,1,0,23},{10,0,0,1,0,23},{11,0,0,1,0,23},{12,1,0,1,0,23},{9,0,0,1,0,24},{10,0,0,1,0,24},{11,0,0,1,0,24},{12,1,0,1,0,24},{9,0,0,1,0,25},{10,0,0,1,0,25},{11,0,0,1,0,25},{12,1,0,1,0,25},{9,0,0,1,0,26},{10,0,0,1,0,26},{11,0,0,1,0,26},{12,1,0,1,0,26},{9,0,0,1,0,27},{10,0,0,1,0,27},{11,0,0,1,0,27},{12,1,0,1,0,27},{9,0,0,1,0,28},{10,0,0,1,0,28},{11,0,0,1,0,28},{12,1,0,1,0,28},{9,0,0,1,0,29},{10,0,0,1,0,29},{11,0,0,1,0,29},{12,1,0,1,0,29},{9,0,0,1,0,30},{10,0,0,1,0,30},{11,0,0,1,0,30},{12,1,0,1,0,30},{9,0,0,1,0,31},{10,0,0,1,0,31},{11,0,0,1,0,31},{12,1,0,1,0,31},{9,0,0,1,0,127},{10,0,0,1,0,127},{11,0,0,1,0,127},{12,1,0,1,0,127},{9,0,0,1,0,220},{10,0,0,1,0,220},{11,0,0,1,0,220},{12,1,0,1,0,220},{9,0,0,1,0,249},{10,0,0,1,0,249},{11,0,0,1,0,249},{12,1,0,1,0,249},{0,1,0,1,0,10},{0,1,0,1,0,13},{0,1,0,1,0,22},{242,0,0,0,0,0},{9,0,1,1,129,48},{10,0,1,1,129,48},{11,0,1,1,129,48},{12,1,1,1,129,48},{9,0,1,1,129,49},{10,0,1,1,129,49},{11,0,1,1,129,49},{12,1,1,1,129,49},{9,0,1,1,129,50},{10,0,1,1,129,50},{11,0,1,1,129,50},{12,1,1,1,129,50},{9,0,1,1,129,97},{10,0,1,1,129,97},{11,0,1,1,129,97},{12,1,1,1,129,97},{9,0,1,1,129,99},{10,0,1,1,129,99},{11,0,1,1,129,99},{12,1,1,1,129,99},{9,0,1,1,129,101},{10,0,1,1,129,101},{11,0,1,1,129,101},{12,1,1,1,129,101},{9,0,1,1,129,105},{10,0,1,1,129,105},{11,0,1,1,129,105},{12,1,1,1,129,105},{9,0,1,1,129,111},{10,0,1,1,129,111},{11,0,1,1,129,111},{12,1,1,1,129,111},{9,0,1,1,129,115},{10,0,1,1,129,115},{11,0,1,1,129,115},{12,1,1,1,129,115},{9,0,1,1,129,116},{10,0,1,1,129,116},{11,0,1,1,129,116},{12,1,1,1,129,116},{13,0,1,1,129,32},{14,1,1,1,129,32},{13,0,1,1,129,37},{14,1,1,1,129,37},{13,0,1,1,129,45},{14,1,1,1,129,45},{13,0,1,1,129,46},{14,1,1,1,129,46},{13,0,1,1,129,47},{14,1,1,1,129,47},{13,0,1,1,129,51},{14,1,1,1,129,51},{13,0,1,1,129,52},{14,1,1,1,129,52},{13,0,1,1,129,53},{14,1,1,1,129,53},{13,0,1,1,129,54},{14,1,1,1,129,54},{13,0,1,1,129,55},{14,1,1,1,129,55},{13,0,1,1,129,56},{14,1,1,1,129,56},{13,0,1,1,129,57},{14,1,1,1,129,57},{13,0,1,1,129,61},{14,1,1,1,129,61},{13,0,1,1,129,65},{14,1,1,1,129,65},{13,0,1,1,129,95},{14,1,1,1,129,95},{13,0,1,1,129,98},{14,1,1,1,129,98},{13,0,1,1,129,100},{14,1,1,1,129,100},{13,0,1,1,129,102},{14,1,1,1,129,102},{13,0,1,1,129,103},{14,1,1,1,129,103},{13,0,1,1,129,104},{14,1,1,1,129,104},{13,0,1,1,129,108},{14,1,1,1,129,108},{13,0,1,1,129,109},{14,1,1,1,129,109},{13,0,1,1,129,110},{14,1,1,1,129,110},{13,0,1,1,129,112},{14,1,1,1,129,112},{13,0,1,1,129,114},{14,1,1,1,129,114},{13,0,1,1,129,117},{14,1,1,1,129,117},{0,1,1,1,129,58},{0,1,1,1,129,66},{0,1,1,1,129,67},{0,1,1,1,129,68},{0,1,1,1,129,69},{0,1,1,1,129,70},{0,1,1,1,129,71},{0,1,1,1,129,72},{0,1,1,1,129,73},{0,1,1,1,129,74},{0,1,1,1,129,75},{0,1,1,1,129,76},{0,1,1,1,129,77},{0,1,1,1,129,78},{0,1,1,1,129,79},{0,1,1,1,129,80},{0,1,1,1,129,81},{0,1,1,1,129,82},{0,1,1,1,129,83},{0,1,1,1,129,84},{0,1,1,1,129,85},{0,1,1,1,129,86},{0,1,1,1,129,87},{0,1,1,1,129,89},{0,1,1,1,129,106},{0,1,1,1,129,107},{0,1,1,1,129,113},{0,1,1,1,129,118},{0,1,1,1,129,119},{0,1,1,1,129,120},{0,1,1,1,129,121},{0,1,1,1,129,122},{85,0,0,1,0,129},{86,0,0,1,0,129},{87,0,0,1,0,129},{88,1,0,1,0,129},{9,0,1,1,132,48},{10,0,1,1,132,48},{11,0,1,1,132,48},{12,1,1,1,132,48},{9,0,1,1,132,49},{10,0,1,1,132,49},{11,0,1,1,132,49},{12,1,1,1,132,49},{9,0,1,1,132,50},{10,0,1,1,132,50},{11,0,1,1,132,50},{12,1,1,1,132,50},{9,0,1,1,132,97},{10,0,1,1,132,97},{11,0,1,1,132,97},{12,1,1,1,132,97},{9,0,1,1,132,99},{10,0,1,1,132,99},{11,0,1,1,132,99},{12,1,1,1,132,99},{9,0,1,1,132,101},{10,0,1,1,132,101},{11,0,1,1,132,101},{12,1,1,1,132,101},{9,0,1,1,132,105},{10,0,1,1,132,105},{11,0,1,1,132,105},{12,1,1,1,132,105},{9,0,1,1,132,111},{10,0,1,1,132,111},{11,0,1,1,132,111},{12,1,1,1,132,111},{9,0,1,1,132,115},{10,0,1,1,132,115},{11,0,1,1,132,115},{12,1,1,1,132,115},{9,0,1,1,132,116},{10,0,1,1,132,116},{11,0,1,1,132,116},{12,1,1,1,132,116},{13,0,1,1,132,32},{14,1,1,1,132,32},{13,0,1,1,132,37},{14,1,1,1,132,37},{13,0,1,1,132,45},{14,1,1,1,132,45},{13,0,1,1,132,46},{14,1,1,1,132,46},{13,0,1,1,132,47},{14,1,1,1,132,47},{13,0,1,1,132,51},{14,1,1,1,132,51},{13,0,1,1,132,52},{14,1,1,1,132,52},{13,0,1,1,132,53},{14,1,1,1,132,53},{13,0,1,1,132,54},{14,1,1,1,132,54},{13,0,1,1,132,55},{14,1,1,1,132,55},{13,0,1,1,132,56},{14,1,1,1,132,56},{13,0,1,1,132,57},{14,1,1,1,132,57},{13,0,1,1,132,61},{14,1,1,1,132,61},{13,0,1,1,132,65},{14,1,1,1,132,65},{13,0,1,1,132,95},{14,1,1,1,132,95},{13,0,1,1,132,98},{14,1,1,1,132,98},{13,0,1,1,132,100},{14,1,1,1,132,100},{13,0,1,1,132,102},{14,1,1,1,132,102},{13,0,1,1,132,103},{14,1,1,1,132,103},{13,0,1,1,132,104},{14,1,1,1,132,104},{13,0,1,1,132,108},{14,1,1,1,132,108},{13,0,1,1,132,109},{14,1,1,1,132,109},{13,0,1,1,132,110},{14,1,1,1,132,110},{13,0,1,1,132,112},{14,1,1,1,132,112},{13,0,1,1,132,114},{14,1,1,1,132,114},{13,0,1,1,132,117},{14,1,1,1,132,117},{0,1,1,1,132,58},{0,1,1,1,132,66},{0,1,1,1,132,67},{0,1,1,1,132,68},{0,1,1,1,132,69},{0,1,1,1,132,70},{0,1,1,1,132,71},{0,1,1,1,132,72},{0,1,1,1,132,73},{0,1,1,1,132,74},{0,1,1,1,132,75},{0,1,1,1,132,76},{0,1,1,1,132,77},{0,1,1,1,132,78},{0,1,1,1,132,79},{0,1,1,1,132,80},{0,1,1,1,132,81},{0,1,1,1,132,82},{0,1,1,1,132,83},{0,1,1,1,132,84},{0,1,1,1,132,85},{0,1,1,1,132,86},{0,1,1,1,132,87},{0,1,1,1,132,89},{0,1,1,1,132,106},{0,1,1,1,132,107},{0,1,1,1,132,113},{0,1,1,1,132,118},{0,1,1,1,132,119},{0,1,1,1,132,120},{0,1,1,1,132,121},{0,1,1,1,132,122},{85,0,0,1,0,132},{86,0,0,1,0,132},{87,0,0,1,0,132},{88,1,0,1,0,132},{9,0,1,1,133,48},{10,0,1,1,133,48},{11,0,1,1,133,48},{12,1,1,1,133,48},{9,0,1,1,133,49},{10,0,1,1,133,49},{11,0,1,1,133,49},{12,1,1,1,133,49},{9,0,1,1,133,50},{10,0,1,1,133,50},{11,0,1,1,133,50},{12,1,1,1,133,50},{9,0,1,1,133,97},{10,0,1,1,133,97},{11,0,1,1,133,97},{12,1,1,1,133,97},{9,0,1,1,133,99},{10,0,1,1,133,99},{11,0,1,1,133,99},{12,1,1,1,133,99},{9,0,1,1,133,101},{10,0,1,1,133,101},{11,0,1,1,133,101},{12,1,1,1,133,101},{9,0,1,1,133,105},{10,0,1,1,133,105},{11,0,1,1,133,105},{12,1,1,1,133,105},{9,0,1,1,133,111},{10,0,1,1,133,111},{11,0,1,1,133,111},{12,1,1,1,133,111},{9,0,1,1,133,115},{10,0,1,1,133,115},{11,0,1,1,133,115},{12,1,1,1,133,115},{9,0,1,1,133,116},{10,0,1,1,133,116},{11,0,1,1,133,116},{12,1,1,1,133,116},{13,0,1,1,133,32},{14,1,1,1,133,32},{13,0,1,1,133,37},{14,1,1,1,133,37},{13,0,1,1,133,45},{14,1,1,1,133,45},{13,0,1,1,133,46},{14,1,1,1,133,46},{13,0,1,1,133,47},{14,1,1,1,133,47},{13,0,1,1,133,51},{14,1,1,1,133,51},{13,0,1,1,133,52},{14,1,1,1,133,52},{13,0,1,1,133,53},{14,1,1,1,133,53},{13,0,1,1,133,54},{14,1,1,1,133,54},{13,0,1,1,133,55},{14,1,1,1,133,55},{13,0,1,1,133,56},{14,1,1,1,133,56},{13,0,1,1,133,57},{14,1,1,1,133,57},{13,0,1,1,133,61},{14,1,1,1,133,61},{13,0,1,1,133,65},{14,1,1,1,133,65},{13,0,1,1,133,95},{14,1,1,1,133,95},{13,0,1,1,133,98},{14,1,1,1,133,98},{13,0,1,1,133,100},{14,1,1,1,133,100},{13,0,1,1,133,102},{14,1,1,1,133,102},{13,0,1,1,133,103},{14,1,1,1,133,103},{13,0,1,1,133,104},{14,1,1,1,133,104},{13,0,1,1,133,108},{14,1,1,1,133,108},{13,0,1,1,133,109},{14,1,1,1,133,109},{13,0,1,1,133,110},{14,1,1,1,133,110},{13,0,1,1,133,112},{14,1,1,1,133,112},{13,0,1,1,133,114},{14,1,1,1,133,114},{13,0,1,1,133,117},{14,1,1,1,133,117},{0,1,1,1,133,58},{0,1,1,1,133,66},{0,1,1,1,133,67},{0,1,1,1,133,68},{0,1,1,1,133,69},{0,1,1,1,133,70},{0,1,1,1,133,71},{0,1,1,1,133,72},{0,1,1,1,133,73},{0,1,1,1,133,74},{0,1,1,1,133,75},{0,1,1,1,133,76},{0,1,1,1,133,77},{0,1,1,1,133,78},{0,1,1,1,133,79},{0,1,1,1,133,80},{0,1,1,1,133,81},{0,1,1,1,133,82},{0,1,1,1,133,83},{0,1,1,1,133,84},{0,1,1,1,133,85},{0,1,1,1,133,86},{0,1,1,1,133,87},{0,1,1,1,133,89},{0,1,1,1,133,106},{0,1,1,1,133,107},{0,1,1,1,133,113},{0,1,1,1,133,118},{0,1,1,1,133,119},{0,1,1,1,133,120},{0,1,1,1,133,121},{0,1,1,1,133,122},{85,0,0,1,0,133},{86,0,0,1,0,133},{87,0,0,1,0,133},{88,1,0,1,0,133},{9,0,1,1,134,48},{10,0,1,1,134,48},{11,0,1,1,134,48},{12,1,1,1,134,48},{9,0,1,1,134,49},{10,0,1,1,134,49},{11,0,1,1,134,49},{12,1,1,1,134,49},{9,0,1,1,134,50},{10,0,1,1,134,50},{11,0,1,1,134,50},{12,1,1,1,134,50},{9,0,1,1,134,97},{10,0,1,1,134,97},{11,0,1,1,134,97},{12,1,1,1,134,97},{9,0,1,1,134,99},{10,0,1,1,134,99},{11,0,1,1,134,99},{12,1,1,1,134,99},{9,0,1,1,134,101},{10,0,1,1,134,101},{11,0,1,1,134,101},{12,1,1,1,134,101},{9,0,1,1,134,105},{10,0,1,1,134,105},{11,0,1,1,134,105},{12,1,1,1,134,105},{9,0,1,1,134,111},{10,0,1,1,134,111},{11,0,1,1,134,111},{12,1,1,1,134,111},{9,0,1,1,134,115},{10,0,1,1,134,115},{11,0,1,1,134,115},{12,1,1,1,134,115},{9,0,1,1,134,116},{10,0,1,1,134,116},{11,0,1,1,134,116},{12,1,1,1,134,116},{13,0,1,1,134,32},{14,1,1,1,134,32},{13,0,1,1,134,37},{14,1,1,1,134,37},{13,0,1,1,134,45},{14,1,1,1,134,45},{13,0,1,1,134,46},{14,1,1,1,134,46},{13,0,1,1,134,47},{14,1,1,1,134,47},{13,0,1,1,134,51},{14,1,1,1,134,51},{13,0,1,1,134,52},{14,1,1,1,134,52},{13,0,1,1,134,53},{14,1,1,1,134,53},{13,0,1,1,134,54},{14,1,1,1,134,54},{13,0,1,1,134,55},{14,1,1,1,134,55},{13,0,1,1,134,56},{14,1,1,1,134,56},{13,0,1,1,134,57},{14,1,1,1,134,57},{13,0,1,1,134,61},{14,1,1,1,134,61},{13,0,1,1,134,65},{14,1,1,1,134,65},{13,0,1,1,134,95},{14,1,1,1,134,95},{13,0,1,1,134,98},{14,1,1,1,134,98},{13,0,1,1,134,100},{14,1,1,1,134,100},{13,0,1,1,134,102},{14,1,1,1,134,102},{13,0,1,1,134,103},{14,1,1,1,134,103},{13,0,1,1,134,104},{14,1,1,1,134,104},{13,0,1,1,134,108},{14,1,1,1,134,108},{13,0,1,1,134,109},{14,1,1,1,134,109},{13,0,1,1,134,110},{14,1,1,1,134,110},{13,0,1,1,134,112},{14,1,1,1,134,112},{13,0,1,1,134,114},{14,1,1,1,134,114},{13,0,1,1,134,117},{14,1,1,1,134,117},{0,1,1,1,134,58},{0,1,1,1,134,66},{0,1,1,1,134,67},{0,1,1,1,134,68},{0,1,1,1,134,69},{0,1,1,1,134,70},{0,1,1,1,134,71},{0,1,1,1,134,72},{0,1,1,1,134,73},{0,1,1,1,134,74},{0,1,1,1,134,75},{0,1,1,1,134,76},{0,1,1,1,134,77},{0,1,1,1,134,78},{0,1,1,1,134,79},{0,1,1,1,134,80},{0,1,1,1,134,81},{0,1,1,1,134,82},{0,1,1,1,134,83},{0,1,1,1,134,84},{0,1,1,1,134,85},{0,1,1,1,134,86},{0,1,1,1,134,87},{0,1,1,1,134,89},{0,1,1,1,134,106},{0,1,1,1,134,107},{0,1,1,1,134,113},{0,1,1,1,134,118},{0,1,1,1,134,119},{0,1,1,1,134,120},{0,1,1,1,134,121},{0,1,1,1,134,122},{85,0,0,1,0,134},{86,0,0,1,0,134},{87,0,0,1,0,134},{88,1,0,1,0,134},{9,0,1,1,136,48},{10,0,1,1,136,48},{11,0,1,1,136,48},{12,1,1,1,136,48},{9,0,1,1,136,49},{10,0,1,1,136,49},{11,0,1,1,136,49},{12,1,1,1,136,49},{9,0,1,1,136,50},{10,0,1,1,136,50},{11,0,1,1,136,50},{12,1,1,1,136,50},{9,0,1,1,136,97},{10,0,1,1,136,97},{11,0,1,1,136,97},{12,1,1,1,136,97},{9,0,1,1,136,99},{10,0,1,1,136,99},{11,0,1,1,136,99},{12,1,1,1,136,99},{9,0,1,1,136,101},{10,0,1,1,136,101},{11,0,1,1,136,101},{12,1,1,1,136,101},{9,0,1,1,136,105},{10,0,1,1,136,105},{11,0,1,1,136,105},{12,1,1,1,136,105},{9,0,1,1,136,111},{10,0,1,1,136,111},{11,0,1,1,136,111},{12,1,1,1,136,111},{9,0,1,1,136,115},{10,0,1,1,136,115},{11,0,1,1,136,115},{12,1,1,1,136,115},{9,0,1,1,136,116},{10,0,1,1,136,116},{11,0,1,1,136,116},{12,1,1,1,136,116},{13,0,1,1,136,32},{14,1,1,1,136,32},{13,0,1,1,136,37},{14,1,1,1,136,37},{13,0,1,1,136,45},{14,1,1,1,136,45},{13,0,1,1,136,46},{14,1,1,1,136,46},{13,0,1,1,136,47},{14,1,1,1,136,47},{13,0,1,1,136,51},{14,1,1,1,136,51},{13,0,1,1,136,52},{14,1,1,1,136,52},{13,0,1,1,136,53},{14,1,1,1,136,53},{13,0,1,1,136,54},{14,1,1,1,136,54},{13,0,1,1,136,55},{14,1,1,1,136,55},{13,0,1,1,136,56},{14,1,1,1,136,56},{13,0,1,1,136,57},{14,1,1,1,136,57},{13,0,1,1,136,61},{14,1,1,1,136,61},{13,0,1,1,136,65},{14,1,1,1,136,65},{13,0,1,1,136,95},{14,1,1,1,136,95},{13,0,1,1,136,98},{14,1,1,1,136,98},{13,0,1,1,136,100},{14,1,1,1,136,100},{13,0,1,1,136,102},{14,1,1,1,136,102},{13,0,1,1,136,103},{14,1,1,1,136,103},{13,0,1,1,136,104},{14,1,1,1,136,104},{13,0,1,1,136,108},{14,1,1,1,136,108},{13,0,1,1,136,109},{14,1,1,1,136,109},{13,0,1,1,136,110},{14,1,1,1,136,110},{13,0,1,1,136,112},{14,1,1,1,136,112},{13,0,1,1,136,114},{14,1,1,1,136,114},{13,0,1,1,136,117},{14,1,1,1,136,117},{0,1,1,1,136,58},{0,1,1,1,136,66},{0,1,1,1,136,67},{0,1,1,1,136,68},{0,1,1,1,136,69},{0,1,1,1,136,70},{0,1,1,1,136,71},{0,1,1,1,136,72},{0,1,1,1,136,73},{0,1,1,1,136,74},{0,1,1,1,136,75},{0,1,1,1,136,76},{0,1,1,1,136,77},{0,1,1,1,136,78},{0,1,1,1,136,79},{0,1,1,1,136,80},{0,1,1,1,136,81},{0,1,1,1,136,82},{0,1,1,1,136,83},{0,1,1,1,136,84},{0,1,1,1,136,85},{0,1,1,1,136,86},{0,1,1,1,136,87},{0,1,1,1,136,89},{0,1,1,1,136,106},{0,1,1,1,136,107},{0,1,1,1,136,113},{0,1,1,1,136,118},{0,1,1,1,136,119},{0,1,1,1,136,120},{0,1,1,1,136,121},{0,1,1,1,136,122},{85,0,0,1,0,136},{86,0,0,1,0,136},{87,0,0,1,0,136},{88,1,0,1,0,136},{9,0,1,1,146,48},{10,0,1,1,146,48},{11,0,1,1,146,48},{12,1,1,1,146,48},{9,0,1,1,146,49},{10,0,1,1,146,49},{11,0,1,1,146,49},{12,1,1,1,146,49},{9,0,1,1,146,50},{10,0,1,1,146,50},{11,0,1,1,146,50},{12,1,1,1,146,50},{9,0,1,1,146,97},{10,0,1,1,146,97},{11,0,1,1,146,97},{12,1,1,1,146,97},{9,0,1,1,146,99},{10,0,1,1,146,99},{11,0,1,1,146,99},{12,1,1,1,146,99},{9,0,1,1,146,101},{10,0,1,1,146,101},{11,0,1,1,146,101},{12,1,1,1,146,101},{9,0,1,1,146,105},{10,0,1,1,146,105},{11,0,1,1,146,105},{12,1,1,1,146,105},{9,0,1,1,146,111},{10,0,1,1,146,111},{11,0,1,1,146,111},{12,1,1,1,146,111},{9,0,1,1,146,115},{10,0,1,1,146,115},{11,0,1,1,146,115},{12,1,1,1,146,115},{9,0,1,1,146,116},{10,0,1,1,146,116},{11,0,1,1,146,116},{12,1,1,1,146,116},{13,0,1,1,146,32},{14,1,1,1,146,32},{13,0,1,1,146,37},{14,1,1,1,146,37},{13,0,1,1,146,45},{14,1,1,1,146,45},{13,0,1,1,146,46},{14,1,1,1,146,46},{13,0,1,1,146,47},{14,1,1,1,146,47},{13,0,1,1,146,51},{14,1,1,1,146,51},{13,0,1,1,146,52},{14,1,1,1,146,52},{13,0,1,1,146,53},{14,1,1,1,146,53},{13,0,1,1,146,54},{14,1,1,1,146,54},{13,0,1,1,146,55},{14,1,1,1,146,55},{13,0,1,1,146,56},{14,1,1,1,146,56},{13,0,1,1,146,57},{14,1,1,1,146,57},{13,0,1,1,146,61},{14,1,1,1,146,61},{13,0,1,1,146,65},{14,1,1,1,146,65},{13,0,1,1,146,95},{14,1,1,1,146,95},{13,0,1,1,146,98},{14,1,1,1,146,98},{13,0,1,1,146,100},{14,1,1,1,146,100},{13,0,1,1,146,102},{14,1,1,1,146,102},{13,0,1,1,146,103},{14,1,1,1,146,103},{13,0,1,1,146,104},{14,1,1,1,146,104},{13,0,1,1,146,108},{14,1,1,1,146,108},{13,0,1,1,146,109},{14,1,1,1,146,109},{13,0,1,1,146,110},{14,1,1,1,146,110},{13,0,1,1,146,112},{14,1,1,1,146,112},{13,0,1,1,146,114},{14,1,1,1,146,114},{13,0,1,1,146,117},{14,1,1,1,146,117},{0,1,1,1,146,58},{0,1,1,1,146,66},{0,1,1,1,146,67},{0,1,1,1,146,68},{0,1,1,1,146,69},{0,1,1,1,146,70},{0,1,1,1,146,71},{0,1,1,1,146,72},{0,1,1,1,146,73},{0,1,1,1,146,74},{0,1,1,1,146,75},{0,1,1,1,146,76},{0,1,1,1,146,77},{0,1,1,1,146,78},{0,1,1,1,146,79},{0,1,1,1,146,80},{0,1,1,1,146,81},{0,1,1,1,146,82},{0,1,1,1,146,83},{0,1,1,1,146,84},{0,1,1,1,146,85},{0,1,1,1,146,86},{0,1,1,1,146,87},{0,1,1,1,146,89},{0,1,1,1,146,106},{0,1,1,1,146,107},{0,1,1,1,146,113},{0,1,1,1,146,118},{0,1,1,1,146,119},{0,1,1,1,146,120},{0,1,1,1,146,121},{0,1,1,1,146,122},{85,0,0,1,0,146},{86,0,0,1,0,146},{87,0,0,1,0,146},{88,1,0,1,0,146},{9,0,1,1,154,48},{10,0,1,1,154,48},{11,0,1,1,154,48},{12,1,1,1,154,48},{9,0,1,1,154,49},{10,0,1,1,154,49},{11,0,1,1,154,49},{12,1,1,1,154,49},{9,0,1,1,154,50},{10,0,1,1,154,50},{11,0,1,1,154,50},{12,1,1,1,154,50},{9,0,1,1,154,97},{10,0,1,1,154,97},{11,0,1,1,154,97},{12,1,1,1,154,97},{9,0,1,1,154,99},{10,0,1,1,154,99},{11,0,1,1,154,99},{12,1,1,1,154,99},{9,0,1,1,154,101},{10,0,1,1,154,101},{11,0,1,1,154,101},{12,1,1,1,154,101},{9,0,1,1,154,105},{10,0,1,1,154,105},{11,0,1,1,154,105},{12,1,1,1,154,105},{9,0,1,1,154,111},{10,0,1,1,154,111},{11,0,1,1,154,111},{12,1,1,1,154,111},{9,0,1,1,154,115},{10,0,1,1,154,115},{11,0,1,1,154,115},{12,1,1,1,154,115},{9,0,1,1,154,116},{10,0,1,1,154,116},{11,0,1,1,154,116},{12,1,1,1,154,116},{13,0,1,1,154,32},{14,1,1,1,154,32},{13,0,1,1,154,37},{14,1,1,1,154,37},{13,0,1,1,154,45},{14,1,1,1,154,45},{13,0,1,1,154,46},{14,1,1,1,154,46},{13,0,1,1,154,47},{14,1,1,1,154,47},{13,0,1,1,154,51},{14,1,1,1,154,51},{13,0,1,1,154,52},{14,1,1,1,154,52},{13,0,1,1,154,53},{14,1,1,1,154,53},{13,0,1,1,154,54},{14,1,1,1,154,54},{13,0,1,1,154,55},{14,1,1,1,154,55},{13,0,1,1,154,56},{14,1,1,1,154,56},{13,0,1,1,154,57},{14,1,1,1,154,57},{13,0,1,1,154,61},{14,1,1,1,154,61},{13,0,1,1,154,65},{14,1,1,1,154,65},{13,0,1,1,154,95},{14,1,1,1,154,95},{13,0,1,1,154,98},{14,1,1,1,154,98},{13,0,1,1,154,100},{14,1,1,1,154,100},{13,0,1,1,154,102},{14,1,1,1,154,102},{13,0,1,1,154,103},{14,1,1,1,154,103},{13,0,1,1,154,104},{14,1,1,1,154,104},{13,0,1,1,154,108},{14,1,1,1,154,108},{13,0,1,1,154,109},{14,1,1,1,154,109},{13,0,1,1,154,110},{14,1,1,1,154,110},{13,0,1,1,154,112},{14,1,1,1,154,112},{13,0,1,1,154,114},{14,1,1,1,154,114},{13,0,1,1,154,117},{14,1,1,1,154,117},{0,1,1,1,154,58},{0,1,1,1,154,66},{0,1,1,1,154,67},{0,1,1,1,154,68},{0,1,1,1,154,69},{0,1,1,1,154,70},{0,1,1,1,154,71},{0,1,1,1,154,72},{0,1,1,1,154,73},{0,1,1,1,154,74},{0,1,1,1,154,75},{0,1,1,1,154,76},{0,1,1,1,154,77},{0,1,1,1,154,78},{0,1,1,1,154,79},{0,1,1,1,154,80},{0,1,1,1,154,81},{0,1,1,1,154,82},{0,1,1,1,154,83},{0,1,1,1,154,84},{0,1,1,1,154,85},{0,1,1,1,154,86},{0,1,1,1,154,87},{0,1,1,1,154,89},{0,1,1,1,154,106},{0,1,1,1,154,107},{0,1,1,1,154,113},{0,1,1,1,154,118},{0,1,1,1,154,119},{0,1,1,1,154,120},{0,1,1,1,154,121},{0,1,1,1,154,122},{85,0,0,1,0,154},{86,0,0,1,0,154},{87,0,0,1,0,154},{88,1,0,1,0,154},{9,0,1,1,156,48},{10,0,1,1,156,48},{11,0,1,1,156,48},{12,1,1,1,156,48},{9,0,1,1,156,49},{10,0,1,1,156,49},{11,0,1,1,156,49},{12,1,1,1,156,49},{9,0,1,1,156,50},{10,0,1,1,156,50},{11,0,1,1,156,50},{12,1,1,1,156,50},{9,0,1,1,156,97},{10,0,1,1,156,97},{11,0,1,1,156,97},{12,1,1,1,156,97},{9,0,1,1,156,99},{10,0,1,1,156,99},{11,0,1,1,156,99},{12,1,1,1,156,99},{9,0,1,1,156,101},{10,0,1,1,156,101},{11,0,1,1,156,101},{12,1,1,1,156,101},{9,0,1,1,156,105},{10,0,1,1,156,105},{11,0,1,1,156,105},{12,1,1,1,156,105},{9,0,1,1,156,111},{10,0,1,1,156,111},{11,0,1,1,156,111},{12,1,1,1,156,111},{9,0,1,1,156,115},{10,0,1,1,156,115},{11,0,1,1,156,115},{12,1,1,1,156,115},{9,0,1,1,156,116},{10,0,1,1,156,116},{11,0,1,1,156,116},{12,1,1,1,156,116},{13,0,1,1,156,32},{14,1,1,1,156,32},{13,0,1,1,156,37},{14,1,1,1,156,37},{13,0,1,1,156,45},{14,1,1,1,156,45},{13,0,1,1,156,46},{14,1,1,1,156,46},{13,0,1,1,156,47},{14,1,1,1,156,47},{13,0,1,1,156,51},{14,1,1,1,156,51},{13,0,1,1,156,52},{14,1,1,1,156,52},{13,0,1,1,156,53},{14,1,1,1,156,53},{13,0,1,1,156,54},{14,1,1,1,156,54},{13,0,1,1,156,55},{14,1,1,1,156,55},{13,0,1,1,156,56},{14,1,1,1,156,56},{13,0,1,1,156,57},{14,1,1,1,156,57},{13,0,1,1,156,61},{14,1,1,1,156,61},{13,0,1,1,156,65},{14,1,1,1,156,65},{13,0,1,1,156,95},{14,1,1,1,156,95},{13,0,1,1,156,98},{14,1,1,1,156,98},{13,0,1,1,156,100},{14,1,1,1,156,100},{13,0,1,1,156,102},{14,1,1,1,156,102},{13,0,1,1,156,103},{14,1,1,1,156,103},{13,0,1,1,156,104},{14,1,1,1,156,104},{13,0,1,1,156,108},{14,1,1,1,156,108},{13,0,1,1,156,109},{14,1,1,1,156,109},{13,0,1,1,156,110},{14,1,1,1,156,110},{13,0,1,1,156,112},{14,1,1,1,156,112},{13,0,1,1,156,114},{14,1,1,1,156,114},{13,0,1,1,156,117},{14,1,1,1,156,117},{0,1,1,1,156,58},{0,1,1,1,156,66},{0,1,1,1,156,67},{0,1,1,1,156,68},{0,1,1,1,156,69},{0,1,1,1,156,70},{0,1,1,1,156,71},{0,1,1,1,156,72},{0,1,1,1,156,73},{0,1,1,1,156,74},{0,1,1,1,156,75},{0,1,1,1,156,76},{0,1,1,1,156,77},{0,1,1,1,156,78},{0,1,1,1,156,79},{0,1,1,1,156,80},{0,1,1,1,156,81},{0,1,1,1,156,82},{0,1,1,1,156,83},{0,1,1,1,156,84},{0,1,1,1,156,85},{0,1,1,1,156,86},{0,1,1,1,156,87},{0,1,1,1,156,89},{0,1,1,1,156,106},{0,1,1,1,156,107},{0,1,1,1,156,113},{0,1,1,1,156,118},{0,1,1,1,156,119},{0,1,1,1,156,120},{0,1,1,1,156,121},{0,1,1,1,156,122},{85,0,0,1,0,156},{86,0,0,1,0,156},{87,0,0,1,0,156},{88,1,0,1,0,156},{9,0,1,1,160,48},{10,0,1,1,160,48},{11,0,1,1,160,48},{12,1,1,1,160,48},{9,0,1,1,160,49},{10,0,1,1,160,49},{11,0,1,1,160,49},{12,1,1,1,160,49},{9,0,1,1,160,50},{10,0,1,1,160,50},{11,0,1,1,160,50},{12,1,1,1,160,50},{9,0,1,1,160,97},{10,0,1,1,160,97},{11,0,1,1,160,97},{12,1,1,1,160,97},{9,0,1,1,160,99},{10,0,1,1,160,99},{11,0,1,1,160,99},{12,1,1,1,160,99},{9,0,1,1,160,101},{10,0,1,1,160,101},{11,0,1,1,160,101},{12,1,1,1,160,101},{9,0,1,1,160,105},{10,0,1,1,160,105},{11,0,1,1,160,105},{12,1,1,1,160,105},{9,0,1,1,160,111},{10,0,1,1,160,111},{11,0,1,1,160,111},{12,1,1,1,160,111},{9,0,1,1,160,115},{10,0,1,1,160,115},{11,0,1,1,160,115},{12,1,1,1,160,115},{9,0,1,1,160,116},{10,0,1,1,160,116},{11,0,1,1,160,116},{12,1,1,1,160,116},{13,0,1,1,160,32},{14,1,1,1,160,32},{13,0,1,1,160,37},{14,1,1,1,160,37},{13,0,1,1,160,45},{14,1,1,1,160,45},{13,0,1,1,160,46},{14,1,1,1,160,46},{13,0,1,1,160,47},{14,1,1,1,160,47},{13,0,1,1,160,51},{14,1,1,1,160,51},{13,0,1,1,160,52},{14,1,1,1,160,52},{13,0,1,1,160,53},{14,1,1,1,160,53},{13,0,1,1,160,54},{14,1,1,1,160,54},{13,0,1,1,160,55},{14,1,1,1,160,55},{13,0,1,1,160,56},{14,1,1,1,160,56},{13,0,1,1,160,57},{14,1,1,1,160,57},{13,0,1,1,160,61},{14,1,1,1,160,61},{13,0,1,1,160,65},{14,1,1,1,160,65},{13,0,1,1,160,95},{14,1,1,1,160,95},{13,0,1,1,160,98},{14,1,1,1,160,98},{13,0,1,1,160,100},{14,1,1,1,160,100},{13,0,1,1,160,102},{14,1,1,1,160,102},{13,0,1,1,160,103},{14,1,1,1,160,103},{13,0,1,1,160,104},{14,1,1,1,160,104},{13,0,1,1,160,108},{14,1,1,1,160,108},{13,0,1,1,160,109},{14,1,1,1,160,109},{13,0,1,1,160,110},{14,1,1,1,160,110},{13,0,1,1,160,112},{14,1,1,1,160,112},{13,0,1,1,160,114},{14,1,1,1,160,114},{13,0,1,1,160,117},{14,1,1,1,160,117},{0,1,1,1,160,58},{0,1,1,1,160,66},{0,1,1,1,160,67},{0,1,1,1,160,68},{0,1,1,1,160,69},{0,1,1,1,160,70},{0,1,1,1,160,71},{0,1,1,1,160,72},{0,1,1,1,160,73},{0,1,1,1,160,74},{0,1,1,1,160,75},{0,1,1,1,160,76},{0,1,1,1,160,77},{0,1,1,1,160,78},{0,1,1,1,160,79},{0,1,1,1,160,80},{0,1,1,1,160,81},{0,1,1,1,160,82},{0,1,1,1,160,83},{0,1,1,1,160,84},{0,1,1,1,160,85},{0,1,1,1,160,86},{0,1,1,1,160,87},{0,1,1,1,160,89},{0,1,1,1,160,106},{0,1,1,1,160,107},{0,1,1,1,160,113},{0,1,1,1,160,118},{0,1,1,1,160,119},{0,1,1,1,160,120},{0,1,1,1,160,121},{0,1,1,1,160,122},{85,0,0,1,0,160},{86,0,0,1,0,160},{87,0,0,1,0,160},{88,1,0,1,0,160},{9,0,1,1,163,48},{10,0,1,1,163,48},{11,0,1,1,163,48},{12,1,1,1,163,48},{9,0,1,1,163,49},{10,0,1,1,163,49},{11,0,1,1,163,49},{12,1,1,1,163,49},{9,0,1,1,163,50},{10,0,1,1,163,50},{11,0,1,1,163,50},{12,1,1,1,163,50},{9,0,1,1,163,97},{10,0,1,1,163,97},{11,0,1,1,163,97},{12,1,1,1,163,97},{9,0,1,1,163,99},{10,0,1,1,163,99},{11,0,1,1,163,99},{12,1,1,1,163,99},{9,0,1,1,163,101},{10,0,1,1,163,101},{11,0,1,1,163,101},{12,1,1,1,163,101},{9,0,1,1,163,105},{10,0,1,1,163,105},{11,0,1,1,163,105},{12,1,1,1,163,105},{9,0,1,1,163,111},{10,0,1,1,163,111},{11,0,1,1,163,111},{12,1,1,1,163,111},{9,0,1,1,163,115},{10,0,1,1,163,115},{11,0,1,1,163,115},{12,1,1,1,163,115},{9,0,1,1,163,116},{10,0,1,1,163,116},{11,0,1,1,163,116},{12,1,1,1,163,116},{13,0,1,1,163,32},{14,1,1,1,163,32},{13,0,1,1,163,37},{14,1,1,1,163,37},{13,0,1,1,163,45},{14,1,1,1,163,45},{13,0,1,1,163,46},{14,1,1,1,163,46},{13,0,1,1,163,47},{14,1,1,1,163,47},{13,0,1,1,163,51},{14,1,1,1,163,51},{13,0,1,1,163,52},{14,1,1,1,163,52},{13,0,1,1,163,53},{14,1,1,1,163,53},{13,0,1,1,163,54},{14,1,1,1,163,54},{13,0,1,1,163,55},{14,1,1,1,163,55},{13,0,1,1,163,56},{14,1,1,1,163,56},{13,0,1,1,163,57},{14,1,1,1,163,57},{13,0,1,1,163,61},{14,1,1,1,163,61},{13,0,1,1,163,65},{14,1,1,1,163,65},{13,0,1,1,163,95},{14,1,1,1,163,95},{13,0,1,1,163,98},{14,1,1,1,163,98},{13,0,1,1,163,100},{14,1,1,1,163,100},{13,0,1,1,163,102},{14,1,1,1,163,102},{13,0,1,1,163,103},{14,1,1,1,163,103},{13,0,1,1,163,104},{14,1,1,1,163,104},{13,0,1,1,163,108},{14,1,1,1,163,108},{13,0,1,1,163,109},{14,1,1,1,163,109},{13,0,1,1,163,110},{14,1,1,1,163,110},{13,0,1,1,163,112},{14,1,1,1,163,112},{13,0,1,1,163,114},{14,1,1,1,163,114},{13,0,1,1,163,117},{14,1,1,1,163,117},{0,1,1,1,163,58},{0,1,1,1,163,66},{0,1,1,1,163,67},{0,1,1,1,163,68},{0,1,1,1,163,69},{0,1,1,1,163,70},{0,1,1,1,163,71},{0,1,1,1,163,72},{0,1,1,1,163,73},{0,1,1,1,163,74},{0,1,1,1,163,75},{0,1,1,1,163,76},{0,1,1,1,163,77},{0,1,1,1,163,78},{0,1,1,1,163,79},{0,1,1,1,163,80},{0,1,1,1,163,81},{0,1,1,1,163,82},{0,1,1,1,163,83},{0,1,1,1,163,84},{0,1,1,1,163,85},{0,1,1,1,163,86},{0,1,1,1,163,87},{0,1,1,1,163,89},{0,1,1,1,163,106},{0,1,1,1,163,107},{0,1,1,1,163,113},{0,1,1,1,163,118},{0,1,1,1,163,119},{0,1,1,1,163,120},{0,1,1,1,163,121},{0,1,1,1,163,122},{85,0,0,1,0,163},{86,0,0,1,0,163},{87,0,0,1,0,163},{88,1,0,1,0,163},{9,0,1,1,164,48},{10,0,1,1,164,48},{11,0,1,1,164,48},{12,1,1,1,164,48},{9,0,1,1,164,49},{10,0,1,1,164,49},{11,0,1,1,164,49},{12,1,1,1,164,49},{9,0,1,1,164,50},{10,0,1,1,164,50},{11,0,1,1,164,50},{12,1,1,1,164,50},{9,0,1,1,164,97},{10,0,1,1,164,97},{11,0,1,1,164,97},{12,1,1,1,164,97},{9,0,1,1,164,99},{10,0,1,1,164,99},{11,0,1,1,164,99},{12,1,1,1,164,99},{9,0,1,1,164,101},{10,0,1,1,164,101},{11,0,1,1,164,101},{12,1,1,1,164,101},{9,0,1,1,164,105},{10,0,1,1,164,105},{11,0,1,1,164,105},{12,1,1,1,164,105},{9,0,1,1,164,111},{10,0,1,1,164,111},{11,0,1,1,164,111},{12,1,1,1,164,111},{9,0,1,1,164,115},{10,0,1,1,164,115},{11,0,1,1,164,115},{12,1,1,1,164,115},{9,0,1,1,164,116},{10,0,1,1,164,116},{11,0,1,1,164,116},{12,1,1,1,164,116},{13,0,1,1,164,32},{14,1,1,1,164,32},{13,0,1,1,164,37},{14,1,1,1,164,37},{13,0,1,1,164,45},{14,1,1,1,164,45},{13,0,1,1,164,46},{14,1,1,1,164,46},{13,0,1,1,164,47},{14,1,1,1,164,47},{13,0,1,1,164,51},{14,1,1,1,164,51},{13,0,1,1,164,52},{14,1,1,1,164,52},{13,0,1,1,164,53},{14,1,1,1,164,53},{13,0,1,1,164,54},{14,1,1,1,164,54},{13,0,1,1,164,55},{14,1,1,1,164,55},{13,0,1,1,164,56},{14,1,1,1,164,56},{13,0,1,1,164,57},{14,1,1,1,164,57},{13,0,1,1,164,61},{14,1,1,1,164,61},{13,0,1,1,164,65},{14,1,1,1,164,65},{13,0,1,1,164,95},{14,1,1,1,164,95},{13,0,1,1,164,98},{14,1,1,1,164,98},{13,0,1,1,164,100},{14,1,1,1,164,100},{13,0,1,1,164,102},{14,1,1,1,164,102},{13,0,1,1,164,103},{14,1,1,1,164,103},{13,0,1,1,164,104},{14,1,1,1,164,104},{13,0,1,1,164,108},{14,1,1,1,164,108},{13,0,1,1,164,109},{14,1,1,1,164,109},{13,0,1,1,164,110},{14,1,1,1,164,110},{13,0,1,1,164,112},{14,1,1,1,164,112},{13,0,1,1,164,114},{14,1,1,1,164,114},{13,0,1,1,164,117},{14,1,1,1,164,117},{0,1,1,1,164,58},{0,1,1,1,164,66},{0,1,1,1,164,67},{0,1,1,1,164,68},{0,1,1,1,164,69},{0,1,1,1,164,70},{0,1,1,1,164,71},{0,1,1,1,164,72},{0,1,1,1,164,73},{0,1,1,1,164,74},{0,1,1,1,164,75},{0,1,1,1,164,76},{0,1,1,1,164,77},{0,1,1,1,164,78},{0,1,1,1,164,79},{0,1,1,1,164,80},{0,1,1,1,164,81},{0,1,1,1,164,82},{0,1,1,1,164,83},{0,1,1,1,164,84},{0,1,1,1,164,85},{0,1,1,1,164,86},{0,1,1,1,164,87},{0,1,1,1,164,89},{0,1,1,1,164,106},{0,1,1,1,164,107},{0,1,1,1,164,113},{0,1,1,1,164,118},{0,1,1,1,164,119},{0,1,1,1,164,120},{0,1,1,1,164,121},{0,1,1,1,164,122},{85,0,0,1,0,164},{86,0,0,1,0,164},{87,0,0,1,0,164},{88,1,0,1,0,164},{9,0,1,1,169,48},{10,0,1,1,169,48},{11,0,1,1,169,48},{12,1,1,1,169,48},{9,0,1,1,169,49},{10,0,1,1,169,49},{11,0,1,1,169,49},{12,1,1,1,169,49},{9,0,1,1,169,50},{10,0,1,1,169,50},{11,0,1,1,169,50},{12,1,1,1,169,50},{9,0,1,1,169,97},{10,0,1,1,169,97},{11,0,1,1,169,97},{12,1,1,1,169,97},{9,0,1,1,169,99},{10,0,1,1,169,99},{11,0,1,1,169,99},{12,1,1,1,169,99},{9,0,1,1,169,101},{10,0,1,1,169,101},{11,0,1,1,169,101},{12,1,1,1,169,101},{9,0,1,1,169,105},{10,0,1,1,169,105},{11,0,1,1,169,105},{12,1,1,1,169,105},{9,0,1,1,169,111},{10,0,1,1,169,111},{11,0,1,1,169,111},{12,1,1,1,169,111},{9,0,1,1,169,115},{10,0,1,1,169,115},{11,0,1,1,169,115},{12,1,1,1,169,115},{9,0,1,1,169,116},{10,0,1,1,169,116},{11,0,1,1,169,116},{12,1,1,1,169,116},{13,0,1,1,169,32},{14,1,1,1,169,32},{13,0,1,1,169,37},{14,1,1,1,169,37},{13,0,1,1,169,45},{14,1,1,1,169,45},{13,0,1,1,169,46},{14,1,1,1,169,46},{13,0,1,1,169,47},{14,1,1,1,169,47},{13,0,1,1,169,51},{14,1,1,1,169,51},{13,0,1,1,169,52},{14,1,1,1,169,52},{13,0,1,1,169,53},{14,1,1,1,169,53},{13,0,1,1,169,54},{14,1,1,1,169,54},{13,0,1,1,169,55},{14,1,1,1,169,55},{13,0,1,1,169,56},{14,1,1,1,169,56},{13,0,1,1,169,57},{14,1,1,1,169,57},{13,0,1,1,169,61},{14,1,1,1,169,61},{13,0,1,1,169,65},{14,1,1,1,169,65},{13,0,1,1,169,95},{14,1,1,1,169,95},{13,0,1,1,169,98},{14,1,1,1,169,98},{13,0,1,1,169,100},{14,1,1,1,169,100},{13,0,1,1,169,102},{14,1,1,1,169,102},{13,0,1,1,169,103},{14,1,1,1,169,103},{13,0,1,1,169,104},{14,1,1,1,169,104},{13,0,1,1,169,108},{14,1,1,1,169,108},{13,0,1,1,169,109},{14,1,1,1,169,109},{13,0,1,1,169,110},{14,1,1,1,169,110},{13,0,1,1,169,112},{14,1,1,1,169,112},{13,0,1,1,169,114},{14,1,1,1,169,114},{13,0,1,1,169,117},{14,1,1,1,169,117},{0,1,1,1,169,58},{0,1,1,1,169,66},{0,1,1,1,169,67},{0,1,1,1,169,68},{0,1,1,1,169,69},{0,1,1,1,169,70},{0,1,1,1,169,71},{0,1,1,1,169,72},{0,1,1,1,169,73},{0,1,1,1,169,74},{0,1,1,1,169,75},{0,1,1,1,169,76},{0,1,1,1,169,77},{0,1,1,1,169,78},{0,1,1,1,169,79},{0,1,1,1,169,80},{0,1,1,1,169,81},{0,1,1,1,169,82},{0,1,1,1,169,83},{0,1,1,1,169,84},{0,1,1,1,169,85},{0,1,1,1,169,86},{0,1,1,1,169,87},{0,1,1,1,169,89},{0,1,1,1,169,106},{0,1,1,1,169,107},{0,1,1,1,169,113},{0,1,1,1,169,118},{0,1,1,1,169,119},{0,1,1,1,169,120},{0,1,1,1,169,121},{0,1,1,1,169,122},{85,0,0,1,0,169},{86,0,0,1,0,169},{87,0,0,1,0,169},{88,1,0,1,0,169},{9,0,1,1,170,48},{10,0,1,1,170,48},{11,0,1,1,170,48},{12,1,1,1,170,48},{9,0,1,1,170,49},{10,0,1,1,170,49},{11,0,1,1,170,49},{12,1,1,1,170,49},{9,0,1,1,170,50},{10,0,1,1,170,50},{11,0,1,1,170,50},{12,1,1,1,170,50},{9,0,1,1,170,97},{10,0,1,1,170,97},{11,0,1,1,170,97},{12,1,1,1,170,97},{9,0,1,1,170,99},{10,0,1,1,170,99},{11,0,1,1,170,99},{12,1,1,1,170,99},{9,0,1,1,170,101},{10,0,1,1,170,101},{11,0,1,1,170,101},{12,1,1,1,170,101},{9,0,1,1,170,105},{10,0,1,1,170,105},{11,0,1,1,170,105},{12,1,1,1,170,105},{9,0,1,1,170,111},{10,0,1,1,170,111},{11,0,1,1,170,111},{12,1,1,1,170,111},{9,0,1,1,170,115},{10,0,1,1,170,115},{11,0,1,1,170,115},{12,1,1,1,170,115},{9,0,1,1,170,116},{10,0,1,1,170,116},{11,0,1,1,170,116},{12,1,1,1,170,116},{13,0,1,1,170,32},{14,1,1,1,170,32},{13,0,1,1,170,37},{14,1,1,1,170,37},{13,0,1,1,170,45},{14,1,1,1,170,45},{13,0,1,1,170,46},{14,1,1,1,170,46},{13,0,1,1,170,47},{14,1,1,1,170,47},{13,0,1,1,170,51},{14,1,1,1,170,51},{13,0,1,1,170,52},{14,1,1,1,170,52},{13,0,1,1,170,53},{14,1,1,1,170,53},{13,0,1,1,170,54},{14,1,1,1,170,54},{13,0,1,1,170,55},{14,1,1,1,170,55},{13,0,1,1,170,56},{14,1,1,1,170,56},{13,0,1,1,170,57},{14,1,1,1,170,57},{13,0,1,1,170,61},{14,1,1,1,170,61},{13,0,1,1,170,65},{14,1,1,1,170,65},{13,0,1,1,170,95},{14,1,1,1,170,95},{13,0,1,1,170,98},{14,1,1,1,170,98},{13,0,1,1,170,100},{14,1,1,1,170,100},{13,0,1,1,170,102},{14,1,1,1,170,102},{13,0,1,1,170,103},{14,1,1,1,170,103},{13,0,1,1,170,104},{14,1,1,1,170,104},{13,0,1,1,170,108},{14,1,1,1,170,108},{13,0,1,1,170,109},{14,1,1,1,170,109},{13,0,1,1,170,110},{14,1,1,1,170,110},{13,0,1,1,170,112},{14,1,1,1,170,112},{13,0,1,1,170,114},{14,1,1,1,170,114},{13,0,1,1,170,117},{14,1,1,1,170,117},{0,1,1,1,170,58},{0,1,1,1,170,66},{0,1,1,1,170,67},{0,1,1,1,170,68},{0,1,1,1,170,69},{0,1,1,1,170,70},{0,1,1,1,170,71},{0,1,1,1,170,72},{0,1,1,1,170,73},{0,1,1,1,170,74},{0,1,1,1,170,75},{0,1,1,1,170,76},{0,1,1,1,170,77},{0,1,1,1,170,78},{0,1,1,1,170,79},{0,1,1,1,170,80},{0,1,1,1,170,81},{0,1,1,1,170,82},{0,1,1,1,170,83},{0,1,1,1,170,84},{0,1,1,1,170,85},{0,1,1,1,170,86},{0,1,1,1,170,87},{0,1,1,1,170,89},{0,1,1,1,170,106},{0,1,1,1,170,107},{0,1,1,1,170,113},{0,1,1,1,170,118},{0,1,1,1,170,119},{0,1,1,1,170,120},{0,1,1,1,170,121},{0,1,1,1,170,122},{85,0,0,1,0,170},{86,0,0,1,0,170},{87,0,0,1,0,170},{88,1,0,1,0,170},{9,0,1,1,173,48},{10,0,1,1,173,48},{11,0,1,1,173,48},{12,1,1,1,173,48},{9,0,1,1,173,49},{10,0,1,1,173,49},{11,0,1,1,173,49},{12,1,1,1,173,49},{9,0,1,1,173,50},{10,0,1,1,173,50},{11,0,1,1,173,50},{12,1,1,1,173,50},{9,0,1,1,173,97},{10,0,1,1,173,97},{11,0,1,1,173,97},{12,1,1,1,173,97},{9,0,1,1,173,99},{10,0,1,1,173,99},{11,0,1,1,173,99},{12,1,1,1,173,99},{9,0,1,1,173,101},{10,0,1,1,173,101},{11,0,1,1,173,101},{12,1,1,1,173,101},{9,0,1,1,173,105},{10,0,1,1,173,105},{11,0,1,1,173,105},{12,1,1,1,173,105},{9,0,1,1,173,111},{10,0,1,1,173,111},{11,0,1,1,173,111},{12,1,1,1,173,111},{9,0,1,1,173,115},{10,0,1,1,173,115},{11,0,1,1,173,115},{12,1,1,1,173,115},{9,0,1,1,173,116},{10,0,1,1,173,116},{11,0,1,1,173,116},{12,1,1,1,173,116},{13,0,1,1,173,32},{14,1,1,1,173,32},{13,0,1,1,173,37},{14,1,1,1,173,37},{13,0,1,1,173,45},{14,1,1,1,173,45},{13,0,1,1,173,46},{14,1,1,1,173,46},{13,0,1,1,173,47},{14,1,1,1,173,47},{13,0,1,1,173,51},{14,1,1,1,173,51},{13,0,1,1,173,52},{14,1,1,1,173,52},{13,0,1,1,173,53},{14,1,1,1,173,53},{13,0,1,1,173,54},{14,1,1,1,173,54},{13,0,1,1,173,55},{14,1,1,1,173,55},{13,0,1,1,173,56},{14,1,1,1,173,56},{13,0,1,1,173,57},{14,1,1,1,173,57},{13,0,1,1,173,61},{14,1,1,1,173,61},{13,0,1,1,173,65},{14,1,1,1,173,65},{13,0,1,1,173,95},{14,1,1,1,173,95},{13,0,1,1,173,98},{14,1,1,1,173,98},{13,0,1,1,173,100},{14,1,1,1,173,100},{13,0,1,1,173,102},{14,1,1,1,173,102},{13,0,1,1,173,103},{14,1,1,1,173,103},{13,0,1,1,173,104},{14,1,1,1,173,104},{13,0,1,1,173,108},{14,1,1,1,173,108},{13,0,1,1,173,109},{14,1,1,1,173,109},{13,0,1,1,173,110},{14,1,1,1,173,110},{13,0,1,1,173,112},{14,1,1,1,173,112},{13,0,1,1,173,114},{14,1,1,1,173,114},{13,0,1,1,173,117},{14,1,1,1,173,117},{0,1,1,1,173,58},{0,1,1,1,173,66},{0,1,1,1,173,67},{0,1,1,1,173,68},{0,1,1,1,173,69},{0,1,1,1,173,70},{0,1,1,1,173,71},{0,1,1,1,173,72},{0,1,1,1,173,73},{0,1,1,1,173,74},{0,1,1,1,173,75},{0,1,1,1,173,76},{0,1,1,1,173,77},{0,1,1,1,173,78},{0,1,1,1,173,79},{0,1,1,1,173,80},{0,1,1,1,173,81},{0,1,1,1,173,82},{0,1,1,1,173,83},{0,1,1,1,173,84},{0,1,1,1,173,85},{0,1,1,1,173,86},{0,1,1,1,173,87},{0,1,1,1,173,89},{0,1,1,1,173,106},{0,1,1,1,173,107},{0,1,1,1,173,113},{0,1,1,1,173,118},{0,1,1,1,173,119},{0,1,1,1,173,120},{0,1,1,1,173,121},{0,1,1,1,173,122},{85,0,0,1,0,173},{86,0,0,1,0,173},{87,0,0,1,0,173},{88,1,0,1,0,173},{9,0,1,1,178,48},{10,0,1,1,178,48},{11,0,1,1,178,48},{12,1,1,1,178,48},{9,0,1,1,178,49},{10,0,1,1,178,49},{11,0,1,1,178,49},{12,1,1,1,178,49},{9,0,1,1,178,50},{10,0,1,1,178,50},{11,0,1,1,178,50},{12,1,1,1,178,50},{9,0,1,1,178,97},{10,0,1,1,178,97},{11,0,1,1,178,97},{12,1,1,1,178,97},{9,0,1,1,178,99},{10,0,1,1,178,99},{11,0,1,1,178,99},{12,1,1,1,178,99},{9,0,1,1,178,101},{10,0,1,1,178,101},{11,0,1,1,178,101},{12,1,1,1,178,101},{9,0,1,1,178,105},{10,0,1,1,178,105},{11,0,1,1,178,105},{12,1,1,1,178,105},{9,0,1,1,178,111},{10,0,1,1,178,111},{11,0,1,1,178,111},{12,1,1,1,178,111},{9,0,1,1,178,115},{10,0,1,1,178,115},{11,0,1,1,178,115},{12,1,1,1,178,115},{9,0,1,1,178,116},{10,0,1,1,178,116},{11,0,1,1,178,116},{12,1,1,1,178,116},{13,0,1,1,178,32},{14,1,1,1,178,32},{13,0,1,1,178,37},{14,1,1,1,178,37},{13,0,1,1,178,45},{14,1,1,1,178,45},{13,0,1,1,178,46},{14,1,1,1,178,46},{13,0,1,1,178,47},{14,1,1,1,178,47},{13,0,1,1,178,51},{14,1,1,1,178,51},{13,0,1,1,178,52},{14,1,1,1,178,52},{13,0,1,1,178,53},{14,1,1,1,178,53},{13,0,1,1,178,54},{14,1,1,1,178,54},{13,0,1,1,178,55},{14,1,1,1,178,55},{13,0,1,1,178,56},{14,1,1,1,178,56},{13,0,1,1,178,57},{14,1,1,1,178,57},{13,0,1,1,178,61},{14,1,1,1,178,61},{13,0,1,1,178,65},{14,1,1,1,178,65},{13,0,1,1,178,95},{14,1,1,1,178,95},{13,0,1,1,178,98},{14,1,1,1,178,98},{13,0,1,1,178,100},{14,1,1,1,178,100},{13,0,1,1,178,102},{14,1,1,1,178,102},{13,0,1,1,178,103},{14,1,1,1,178,103},{13,0,1,1,178,104},{14,1,1,1,178,104},{13,0,1,1,178,108},{14,1,1,1,178,108},{13,0,1,1,178,109},{14,1,1,1,178,109},{13,0,1,1,178,110},{14,1,1,1,178,110},{13,0,1,1,178,112},{14,1,1,1,178,112},{13,0,1,1,178,114},{14,1,1,1,178,114},{13,0,1,1,178,117},{14,1,1,1,178,117},{0,1,1,1,178,58},{0,1,1,1,178,66},{0,1,1,1,178,67},{0,1,1,1,178,68},{0,1,1,1,178,69},{0,1,1,1,178,70},{0,1,1,1,178,71},{0,1,1,1,178,72},{0,1,1,1,178,73},{0,1,1,1,178,74},{0,1,1,1,178,75},{0,1,1,1,178,76},{0,1,1,1,178,77},{0,1,1,1,178,78},{0,1,1,1,178,79},{0,1,1,1,178,80},{0,1,1,1,178,81},{0,1,1,1,178,82},{0,1,1,1,178,83},{0,1,1,1,178,84},{0,1,1,1,178,85},{0,1,1,1,178,86},{0,1,1,1,178,87},{0,1,1,1,178,89},{0,1,1,1,178,106},{0,1,1,1,178,107},{0,1,1,1,178,113},{0,1,1,1,178,118},{0,1,1,1,178,119},{0,1,1,1,178,120},{0,1,1,1,178,121},{0,1,1,1,178,122},{85,0,0,1,0,178},{86,0,0,1,0,178},{87,0,0,1,0,178},{88,1,0,1,0,178},{9,0,1,1,181,48},{10,0,1,1,181,48},{11,0,1,1,181,48},{12,1,1,1,181,48},{9,0,1,1,181,49},{10,0,1,1,181,49},{11,0,1,1,181,49},{12,1,1,1,181,49},{9,0,1,1,181,50},{10,0,1,1,181,50},{11,0,1,1,181,50},{12,1,1,1,181,50},{9,0,1,1,181,97},{10,0,1,1,181,97},{11,0,1,1,181,97},{12,1,1,1,181,97},{9,0,1,1,181,99},{10,0,1,1,181,99},{11,0,1,1,181,99},{12,1,1,1,181,99},{9,0,1,1,181,101},{10,0,1,1,181,101},{11,0,1,1,181,101},{12,1,1,1,181,101},{9,0,1,1,181,105},{10,0,1,1,181,105},{11,0,1,1,181,105},{12,1,1,1,181,105},{9,0,1,1,181,111},{10,0,1,1,181,111},{11,0,1,1,181,111},{12,1,1,1,181,111},{9,0,1,1,181,115},{10,0,1,1,181,115},{11,0,1,1,181,115},{12,1,1,1,181,115},{9,0,1,1,181,116},{10,0,1,1,181,116},{11,0,1,1,181,116},{12,1,1,1,181,116},{13,0,1,1,181,32},{14,1,1,1,181,32},{13,0,1,1,181,37},{14,1,1,1,181,37},{13,0,1,1,181,45},{14,1,1,1,181,45},{13,0,1,1,181,46},{14,1,1,1,181,46},{13,0,1,1,181,47},{14,1,1,1,181,47},{13,0,1,1,181,51},{14,1,1,1,181,51},{13,0,1,1,181,52},{14,1,1,1,181,52},{13,0,1,1,181,53},{14,1,1,1,181,53},{13,0,1,1,181,54},{14,1,1,1,181,54},{13,0,1,1,181,55},{14,1,1,1,181,55},{13,0,1,1,181,56},{14,1,1,1,181,56},{13,0,1,1,181,57},{14,1,1,1,181,57},{13,0,1,1,181,61},{14,1,1,1,181,61},{13,0,1,1,181,65},{14,1,1,1,181,65},{13,0,1,1,181,95},{14,1,1,1,181,95},{13,0,1,1,181,98},{14,1,1,1,181,98},{13,0,1,1,181,100},{14,1,1,1,181,100},{13,0,1,1,181,102},{14,1,1,1,181,102},{13,0,1,1,181,103},{14,1,1,1,181,103},{13,0,1,1,181,104},{14,1,1,1,181,104},{13,0,1,1,181,108},{14,1,1,1,181,108},{13,0,1,1,181,109},{14,1,1,1,181,109},{13,0,1,1,181,110},{14,1,1,1,181,110},{13,0,1,1,181,112},{14,1,1,1,181,112},{13,0,1,1,181,114},{14,1,1,1,181,114},{13,0,1,1,181,117},{14,1,1,1,181,117},{0,1,1,1,181,58},{0,1,1,1,181,66},{0,1,1,1,181,67},{0,1,1,1,181,68},{0,1,1,1,181,69},{0,1,1,1,181,70},{0,1,1,1,181,71},{0,1,1,1,181,72},{0,1,1,1,181,73},{0,1,1,1,181,74},{0,1,1,1,181,75},{0,1,1,1,181,76},{0,1,1,1,181,77},{0,1,1,1,181,78},{0,1,1,1,181,79},{0,1,1,1,181,80},{0,1,1,1,181,81},{0,1,1,1,181,82},{0,1,1,1,181,83},{0,1,1,1,181,84},{0,1,1,1,181,85},{0,1,1,1,181,86},{0,1,1,1,181,87},{0,1,1,1,181,89},{0,1,1,1,181,106},{0,1,1,1,181,107},{0,1,1,1,181,113},{0,1,1,1,181,118},{0,1,1,1,181,119},{0,1,1,1,181,120},{0,1,1,1,181,121},{0,1,1,1,181,122},{85,0,0,1,0,181},{86,0,0,1,0,181},{87,0,0,1,0,181},{88,1,0,1,0,181},{9,0,1,1,185,48},{10,0,1,1,185,48},{11,0,1,1,185,48},{12,1,1,1,185,48},{9,0,1,1,185,49},{10,0,1,1,185,49},{11,0,1,1,185,49},{12,1,1,1,185,49},{9,0,1,1,185,50},{10,0,1,1,185,50},{11,0,1,1,185,50},{12,1,1,1,185,50},{9,0,1,1,185,97},{10,0,1,1,185,97},{11,0,1,1,185,97},{12,1,1,1,185,97},{9,0,1,1,185,99},{10,0,1,1,185,99},{11,0,1,1,185,99},{12,1,1,1,185,99},{9,0,1,1,185,101},{10,0,1,1,185,101},{11,0,1,1,185,101},{12,1,1,1,185,101},{9,0,1,1,185,105},{10,0,1,1,185,105},{11,0,1,1,185,105},{12,1,1,1,185,105},{9,0,1,1,185,111},{10,0,1,1,185,111},{11,0,1,1,185,111},{12,1,1,1,185,111},{9,0,1,1,185,115},{10,0,1,1,185,115},{11,0,1,1,185,115},{12,1,1,1,185,115},{9,0,1,1,185,116},{10,0,1,1,185,116},{11,0,1,1,185,116},{12,1,1,1,185,116},{13,0,1,1,185,32},{14,1,1,1,185,32},{13,0,1,1,185,37},{14,1,1,1,185,37},{13,0,1,1,185,45},{14,1,1,1,185,45},{13,0,1,1,185,46},{14,1,1,1,185,46},{13,0,1,1,185,47},{14,1,1,1,185,47},{13,0,1,1,185,51},{14,1,1,1,185,51},{13,0,1,1,185,52},{14,1,1,1,185,52},{13,0,1,1,185,53},{14,1,1,1,185,53},{13,0,1,1,185,54},{14,1,1,1,185,54},{13,0,1,1,185,55},{14,1,1,1,185,55},{13,0,1,1,185,56},{14,1,1,1,185,56},{13,0,1,1,185,57},{14,1,1,1,185,57},{13,0,1,1,185,61},{14,1,1,1,185,61},{13,0,1,1,185,65},{14,1,1,1,185,65},{13,0,1,1,185,95},{14,1,1,1,185,95},{13,0,1,1,185,98},{14,1,1,1,185,98},{13,0,1,1,185,100},{14,1,1,1,185,100},{13,0,1,1,185,102},{14,1,1,1,185,102},{13,0,1,1,185,103},{14,1,1,1,185,103},{13,0,1,1,185,104},{14,1,1,1,185,104},{13,0,1,1,185,108},{14,1,1,1,185,108},{13,0,1,1,185,109},{14,1,1,1,185,109},{13,0,1,1,185,110},{14,1,1,1,185,110},{13,0,1,1,185,112},{14,1,1,1,185,112},{13,0,1,1,185,114},{14,1,1,1,185,114},{13,0,1,1,185,117},{14,1,1,1,185,117},{0,1,1,1,185,58},{0,1,1,1,185,66},{0,1,1,1,185,67},{0,1,1,1,185,68},{0,1,1,1,185,69},{0,1,1,1,185,70},{0,1,1,1,185,71},{0,1,1,1,185,72},{0,1,1,1,185,73},{0,1,1,1,185,74},{0,1,1,1,185,75},{0,1,1,1,185,76},{0,1,1,1,185,77},{0,1,1,1,185,78},{0,1,1,1,185,79},{0,1,1,1,185,80},{0,1,1,1,185,81},{0,1,1,1,185,82},{0,1,1,1,185,83},{0,1,1,1,185,84},{0,1,1,1,185,85},{0,1,1,1,185,86},{0,1,1,1,185,87},{0,1,1,1,185,89},{0,1,1,1,185,106},{0,1,1,1,185,107},{0,1,1,1,185,113},{0,1,1,1,185,118},{0,1,1,1,185,119},{0,1,1,1,185,120},{0,1,1,1,185,121},{0,1,1,1,185,122},{85,0,0,1,0,185},{86,0,0,1,0,185},{87,0,0,1,0,185},{88,1,0,1,0,185},{9,0,1,1,186,48},{10,0,1,1,186,48},{11,0,1,1,186,48},{12,1,1,1,186,48},{9,0,1,1,186,49},{10,0,1,1,186,49},{11,0,1,1,186,49},{12,1,1,1,186,49},{9,0,1,1,186,50},{10,0,1,1,186,50},{11,0,1,1,186,50},{12,1,1,1,186,50},{9,0,1,1,186,97},{10,0,1,1,186,97},{11,0,1,1,186,97},{12,1,1,1,186,97},{9,0,1,1,186,99},{10,0,1,1,186,99},{11,0,1,1,186,99},{12,1,1,1,186,99},{9,0,1,1,186,101},{10,0,1,1,186,101},{11,0,1,1,186,101},{12,1,1,1,186,101},{9,0,1,1,186,105},{10,0,1,1,186,105},{11,0,1,1,186,105},{12,1,1,1,186,105},{9,0,1,1,186,111},{10,0,1,1,186,111},{11,0,1,1,186,111},{12,1,1,1,186,111},{9,0,1,1,186,115},{10,0,1,1,186,115},{11,0,1,1,186,115},{12,1,1,1,186,115},{9,0,1,1,186,116},{10,0,1,1,186,116},{11,0,1,1,186,116},{12,1,1,1,186,116},{13,0,1,1,186,32},{14,1,1,1,186,32},{13,0,1,1,186,37},{14,1,1,1,186,37},{13,0,1,1,186,45},{14,1,1,1,186,45},{13,0,1,1,186,46},{14,1,1,1,186,46},{13,0,1,1,186,47},{14,1,1,1,186,47},{13,0,1,1,186,51},{14,1,1,1,186,51},{13,0,1,1,186,52},{14,1,1,1,186,52},{13,0,1,1,186,53},{14,1,1,1,186,53},{13,0,1,1,186,54},{14,1,1,1,186,54},{13,0,1,1,186,55},{14,1,1,1,186,55},{13,0,1,1,186,56},{14,1,1,1,186,56},{13,0,1,1,186,57},{14,1,1,1,186,57},{13,0,1,1,186,61},{14,1,1,1,186,61},{13,0,1,1,186,65},{14,1,1,1,186,65},{13,0,1,1,186,95},{14,1,1,1,186,95},{13,0,1,1,186,98},{14,1,1,1,186,98},{13,0,1,1,186,100},{14,1,1,1,186,100},{13,0,1,1,186,102},{14,1,1,1,186,102},{13,0,1,1,186,103},{14,1,1,1,186,103},{13,0,1,1,186,104},{14,1,1,1,186,104},{13,0,1,1,186,108},{14,1,1,1,186,108},{13,0,1,1,186,109},{14,1,1,1,186,109},{13,0,1,1,186,110},{14,1,1,1,186,110},{13,0,1,1,186,112},{14,1,1,1,186,112},{13,0,1,1,186,114},{14,1,1,1,186,114},{13,0,1,1,186,117},{14,1,1,1,186,117},{0,1,1,1,186,58},{0,1,1,1,186,66},{0,1,1,1,186,67},{0,1,1,1,186,68},{0,1,1,1,186,69},{0,1,1,1,186,70},{0,1,1,1,186,71},{0,1,1,1,186,72},{0,1,1,1,186,73},{0,1,1,1,186,74},{0,1,1,1,186,75},{0,1,1,1,186,76},{0,1,1,1,186,77},{0,1,1,1,186,78},{0,1,1,1,186,79},{0,1,1,1,186,80},{0,1,1,1,186,81},{0,1,1,1,186,82},{0,1,1,1,186,83},{0,1,1,1,186,84},{0,1,1,1,186,85},{0,1,1,1,186,86},{0,1,1,1,186,87},{0,1,1,1,186,89},{0,1,1,1,186,106},{0,1,1,1,186,107},{0,1,1,1,186,113},{0,1,1,1,186,118},{0,1,1,1,186,119},{0,1,1,1,186,120},{0,1,1,1,186,121},{0,1,1,1,186,122},{85,0,0,1,0,186},{86,0,0,1,0,186},{87,0,0,1,0,186},{88,1,0,1,0,186},{9,0,1,1,187,48},{10,0,1,1,187,48},{11,0,1,1,187,48},{12,1,1,1,187,48},{9,0,1,1,187,49},{10,0,1,1,187,49},{11,0,1,1,187,49},{12,1,1,1,187,49},{9,0,1,1,187,50},{10,0,1,1,187,50},{11,0,1,1,187,50},{12,1,1,1,187,50},{9,0,1,1,187,97},{10,0,1,1,187,97},{11,0,1,1,187,97},{12,1,1,1,187,97},{9,0,1,1,187,99},{10,0,1,1,187,99},{11,0,1,1,187,99},{12,1,1,1,187,99},{9,0,1,1,187,101},{10,0,1,1,187,101},{11,0,1,1,187,101},{12,1,1,1,187,101},{9,0,1,1,187,105},{10,0,1,1,187,105},{11,0,1,1,187,105},{12,1,1,1,187,105},{9,0,1,1,187,111},{10,0,1,1,187,111},{11,0,1,1,187,111},{12,1,1,1,187,111},{9,0,1,1,187,115},{10,0,1,1,187,115},{11,0,1,1,187,115},{12,1,1,1,187,115},{9,0,1,1,187,116},{10,0,1,1,187,116},{11,0,1,1,187,116},{12,1,1,1,187,116},{13,0,1,1,187,32},{14,1,1,1,187,32},{13,0,1,1,187,37},{14,1,1,1,187,37},{13,0,1,1,187,45},{14,1,1,1,187,45},{13,0,1,1,187,46},{14,1,1,1,187,46},{13,0,1,1,187,47},{14,1,1,1,187,47},{13,0,1,1,187,51},{14,1,1,1,187,51},{13,0,1,1,187,52},{14,1,1,1,187,52},{13,0,1,1,187,53},{14,1,1,1,187,53},{13,0,1,1,187,54},{14,1,1,1,187,54},{13,0,1,1,187,55},{14,1,1,1,187,55},{13,0,1,1,187,56},{14,1,1,1,187,56},{13,0,1,1,187,57},{14,1,1,1,187,57},{13,0,1,1,187,61},{14,1,1,1,187,61},{13,0,1,1,187,65},{14,1,1,1,187,65},{13,0,1,1,187,95},{14,1,1,1,187,95},{13,0,1,1,187,98},{14,1,1,1,187,98},{13,0,1,1,187,100},{14,1,1,1,187,100},{13,0,1,1,187,102},{14,1,1,1,187,102},{13,0,1,1,187,103},{14,1,1,1,187,103},{13,0,1,1,187,104},{14,1,1,1,187,104},{13,0,1,1,187,108},{14,1,1,1,187,108},{13,0,1,1,187,109},{14,1,1,1,187,109},{13,0,1,1,187,110},{14,1,1,1,187,110},{13,0,1,1,187,112},{14,1,1,1,187,112},{13,0,1,1,187,114},{14,1,1,1,187,114},{13,0,1,1,187,117},{14,1,1,1,187,117},{0,1,1,1,187,58},{0,1,1,1,187,66},{0,1,1,1,187,67},{0,1,1,1,187,68},{0,1,1,1,187,69},{0,1,1,1,187,70},{0,1,1,1,187,71},{0,1,1,1,187,72},{0,1,1,1,187,73},{0,1,1,1,187,74},{0,1,1,1,187,75},{0,1,1,1,187,76},{0,1,1,1,187,77},{0,1,1,1,187,78},{0,1,1,1,187,79},{0,1,1,1,187,80},{0,1,1,1,187,81},{0,1,1,1,187,82},{0,1,1,1,187,83},{0,1,1,1,187,84},{0,1,1,1,187,85},{0,1,1,1,187,86},{0,1,1,1,187,87},{0,1,1,1,187,89},{0,1,1,1,187,106},{0,1,1,1,187,107},{0,1,1,1,187,113},{0,1,1,1,187,118},{0,1,1,1,187,119},{0,1,1,1,187,120},{0,1,1,1,187,121},{0,1,1,1,187,122},{85,0,0,1,0,187},{86,0,0,1,0,187},{87,0,0,1,0,187},{88,1,0,1,0,187},{9,0,1,1,189,48},{10,0,1,1,189,48},{11,0,1,1,189,48},{12,1,1,1,189,48},{9,0,1,1,189,49},{10,0,1,1,189,49},{11,0,1,1,189,49},{12,1,1,1,189,49},{9,0,1,1,189,50},{10,0,1,1,189,50},{11,0,1,1,189,50},{12,1,1,1,189,50},{9,0,1,1,189,97},{10,0,1,1,189,97},{11,0,1,1,189,97},{12,1,1,1,189,97},{9,0,1,1,189,99},{10,0,1,1,189,99},{11,0,1,1,189,99},{12,1,1,1,189,99},{9,0,1,1,189,101},{10,0,1,1,189,101},{11,0,1,1,189,101},{12,1,1,1,189,101},{9,0,1,1,189,105},{10,0,1,1,189,105},{11,0,1,1,189,105},{12,1,1,1,189,105},{9,0,1,1,189,111},{10,0,1,1,189,111},{11,0,1,1,189,111},{12,1,1,1,189,111},{9,0,1,1,189,115},{10,0,1,1,189,115},{11,0,1,1,189,115},{12,1,1,1,189,115},{9,0,1,1,189,116},{10,0,1,1,189,116},{11,0,1,1,189,116},{12,1,1,1,189,116},{13,0,1,1,189,32},{14,1,1,1,189,32},{13,0,1,1,189,37},{14,1,1,1,189,37},{13,0,1,1,189,45},{14,1,1,1,189,45},{13,0,1,1,189,46},{14,1,1,1,189,46},{13,0,1,1,189,47},{14,1,1,1,189,47},{13,0,1,1,189,51},{14,1,1,1,189,51},{13,0,1,1,189,52},{14,1,1,1,189,52},{13,0,1,1,189,53},{14,1,1,1,189,53},{13,0,1,1,189,54},{14,1,1,1,189,54},{13,0,1,1,189,55},{14,1,1,1,189,55},{13,0,1,1,189,56},{14,1,1,1,189,56},{13,0,1,1,189,57},{14,1,1,1,189,57},{13,0,1,1,189,61},{14,1,1,1,189,61},{13,0,1,1,189,65},{14,1,1,1,189,65},{13,0,1,1,189,95},{14,1,1,1,189,95},{13,0,1,1,189,98},{14,1,1,1,189,98},{13,0,1,1,189,100},{14,1,1,1,189,100},{13,0,1,1,189,102},{14,1,1,1,189,102},{13,0,1,1,189,103},{14,1,1,1,189,103},{13,0,1,1,189,104},{14,1,1,1,189,104},{13,0,1,1,189,108},{14,1,1,1,189,108},{13,0,1,1,189,109},{14,1,1,1,189,109},{13,0,1,1,189,110},{14,1,1,1,189,110},{13,0,1,1,189,112},{14,1,1,1,189,112},{13,0,1,1,189,114},{14,1,1,1,189,114},{13,0,1,1,189,117},{14,1,1,1,189,117},{0,1,1,1,189,58},{0,1,1,1,189,66},{0,1,1,1,189,67},{0,1,1,1,189,68},{0,1,1,1,189,69},{0,1,1,1,189,70},{0,1,1,1,189,71},{0,1,1,1,189,72},{0,1,1,1,189,73},{0,1,1,1,189,74},{0,1,1,1,189,75},{0,1,1,1,189,76},{0,1,1,1,189,77},{0,1,1,1,189,78},{0,1,1,1,189,79},{0,1,1,1,189,80},{0,1,1,1,189,81},{0,1,1,1,189,82},{0,1,1,1,189,83},{0,1,1,1,189,84},{0,1,1,1,189,85},{0,1,1,1,189,86},{0,1,1,1,189,87},{0,1,1,1,189,89},{0,1,1,1,189,106},{0,1,1,1,189,107},{0,1,1,1,189,113},{0,1,1,1,189,118},{0,1,1,1,189,119},{0,1,1,1,189,120},{0,1,1,1,189,121},{0,1,1,1,189,122},{85,0,0,1,0,189},{86,0,0,1,0,189},{87,0,0,1,0,189},{88,1,0,1,0,189},{9,0,1,1,190,48},{10,0,1,1,190,48},{11,0,1,1,190,48},{12,1,1,1,190,48},{9,0,1,1,190,49},{10,0,1,1,190,49},{11,0,1,1,190,49},{12,1,1,1,190,49},{9,0,1,1,190,50},{10,0,1,1,190,50},{11,0,1,1,190,50},{12,1,1,1,190,50},{9,0,1,1,190,97},{10,0,1,1,190,97},{11,0,1,1,190,97},{12,1,1,1,190,97},{9,0,1,1,190,99},{10,0,1,1,190,99},{11,0,1,1,190,99},{12,1,1,1,190,99},{9,0,1,1,190,101},{10,0,1,1,190,101},{11,0,1,1,190,101},{12,1,1,1,190,101},{9,0,1,1,190,105},{10,0,1,1,190,105},{11,0,1,1,190,105},{12,1,1,1,190,105},{9,0,1,1,190,111},{10,0,1,1,190,111},{11,0,1,1,190,111},{12,1,1,1,190,111},{9,0,1,1,190,115},{10,0,1,1,190,115},{11,0,1,1,190,115},{12,1,1,1,190,115},{9,0,1,1,190,116},{10,0,1,1,190,116},{11,0,1,1,190,116},{12,1,1,1,190,116},{13,0,1,1,190,32},{14,1,1,1,190,32},{13,0,1,1,190,37},{14,1,1,1,190,37},{13,0,1,1,190,45},{14,1,1,1,190,45},{13,0,1,1,190,46},{14,1,1,1,190,46},{13,0,1,1,190,47},{14,1,1,1,190,47},{13,0,1,1,190,51},{14,1,1,1,190,51},{13,0,1,1,190,52},{14,1,1,1,190,52},{13,0,1,1,190,53},{14,1,1,1,190,53},{13,0,1,1,190,54},{14,1,1,1,190,54},{13,0,1,1,190,55},{14,1,1,1,190,55},{13,0,1,1,190,56},{14,1,1,1,190,56},{13,0,1,1,190,57},{14,1,1,1,190,57},{13,0,1,1,190,61},{14,1,1,1,190,61},{13,0,1,1,190,65},{14,1,1,1,190,65},{13,0,1,1,190,95},{14,1,1,1,190,95},{13,0,1,1,190,98},{14,1,1,1,190,98},{13,0,1,1,190,100},{14,1,1,1,190,100},{13,0,1,1,190,102},{14,1,1,1,190,102},{13,0,1,1,190,103},{14,1,1,1,190,103},{13,0,1,1,190,104},{14,1,1,1,190,104},{13,0,1,1,190,108},{14,1,1,1,190,108},{13,0,1,1,190,109},{14,1,1,1,190,109},{13,0,1,1,190,110},{14,1,1,1,190,110},{13,0,1,1,190,112},{14,1,1,1,190,112},{13,0,1,1,190,114},{14,1,1,1,190,114},{13,0,1,1,190,117},{14,1,1,1,190,117},{0,1,1,1,190,58},{0,1,1,1,190,66},{0,1,1,1,190,67},{0,1,1,1,190,68},{0,1,1,1,190,69},{0,1,1,1,190,70},{0,1,1,1,190,71},{0,1,1,1,190,72},{0,1,1,1,190,73},{0,1,1,1,190,74},{0,1,1,1,190,75},{0,1,1,1,190,76},{0,1,1,1,190,77},{0,1,1,1,190,78},{0,1,1,1,190,79},{0,1,1,1,190,80},{0,1,1,1,190,81},{0,1,1,1,190,82},{0,1,1,1,190,83},{0,1,1,1,190,84},{0,1,1,1,190,85},{0,1,1,1,190,86},{0,1,1,1,190,87},{0,1,1,1,190,89},{0,1,1,1,190,106},{0,1,1,1,190,107},{0,1,1,1,190,113},{0,1,1,1,190,118},{0,1,1,1,190,119},{0,1,1,1,190,120},{0,1,1,1,190,121},{0,1,1,1,190,122},{85,0,0,1,0,190},{86,0,0,1,0,190},{87,0,0,1,0,190},{88,1,0,1,0,190},{9,0,1,1,196,48},{10,0,1,1,196,48},{11,0,1,1,196,48},{12,1,1,1,196,48},{9,0,1,1,196,49},{10,0,1,1,196,49},{11,0,1,1,196,49},{12,1,1,1,196,49},{9,0,1,1,196,50},{10,0,1,1,196,50},{11,0,1,1,196,50},{12,1,1,1,196,50},{9,0,1,1,196,97},{10,0,1,1,196,97},{11,0,1,1,196,97},{12,1,1,1,196,97},{9,0,1,1,196,99},{10,0,1,1,196,99},{11,0,1,1,196,99},{12,1,1,1,196,99},{9,0,1,1,196,101},{10,0,1,1,196,101},{11,0,1,1,196,101},{12,1,1,1,196,101},{9,0,1,1,196,105},{10,0,1,1,196,105},{11,0,1,1,196,105},{12,1,1,1,196,105},{9,0,1,1,196,111},{10,0,1,1,196,111},{11,0,1,1,196,111},{12,1,1,1,196,111},{9,0,1,1,196,115},{10,0,1,1,196,115},{11,0,1,1,196,115},{12,1,1,1,196,115},{9,0,1,1,196,116},{10,0,1,1,196,116},{11,0,1,1,196,116},{12,1,1,1,196,116},{13,0,1,1,196,32},{14,1,1,1,196,32},{13,0,1,1,196,37},{14,1,1,1,196,37},{13,0,1,1,196,45},{14,1,1,1,196,45},{13,0,1,1,196,46},{14,1,1,1,196,46},{13,0,1,1,196,47},{14,1,1,1,196,47},{13,0,1,1,196,51},{14,1,1,1,196,51},{13,0,1,1,196,52},{14,1,1,1,196,52},{13,0,1,1,196,53},{14,1,1,1,196,53},{13,0,1,1,196,54},{14,1,1,1,196,54},{13,0,1,1,196,55},{14,1,1,1,196,55},{13,0,1,1,196,56},{14,1,1,1,196,56},{13,0,1,1,196,57},{14,1,1,1,196,57},{13,0,1,1,196,61},{14,1,1,1,196,61},{13,0,1,1,196,65},{14,1,1,1,196,65},{13,0,1,1,196,95},{14,1,1,1,196,95},{13,0,1,1,196,98},{14,1,1,1,196,98},{13,0,1,1,196,100},{14,1,1,1,196,100},{13,0,1,1,196,102},{14,1,1,1,196,102},{13,0,1,1,196,103},{14,1,1,1,196,103},{13,0,1,1,196,104},{14,1,1,1,196,104},{13,0,1,1,196,108},{14,1,1,1,196,108},{13,0,1,1,196,109},{14,1,1,1,196,109},{13,0,1,1,196,110},{14,1,1,1,196,110},{13,0,1,1,196,112},{14,1,1,1,196,112},{13,0,1,1,196,114},{14,1,1,1,196,114},{13,0,1,1,196,117},{14,1,1,1,196,117},{0,1,1,1,196,58},{0,1,1,1,196,66},{0,1,1,1,196,67},{0,1,1,1,196,68},{0,1,1,1,196,69},{0,1,1,1,196,70},{0,1,1,1,196,71},{0,1,1,1,196,72},{0,1,1,1,196,73},{0,1,1,1,196,74},{0,1,1,1,196,75},{0,1,1,1,196,76},{0,1,1,1,196,77},{0,1,1,1,196,78},{0,1,1,1,196,79},{0,1,1,1,196,80},{0,1,1,1,196,81},{0,1,1,1,196,82},{0,1,1,1,196,83},{0,1,1,1,196,84},{0,1,1,1,196,85},{0,1,1,1,196,86},{0,1,1,1,196,87},{0,1,1,1,196,89},{0,1,1,1,196,106},{0,1,1,1,196,107},{0,1,1,1,196,113},{0,1,1,1,196,118},{0,1,1,1,196,119},{0,1,1,1,196,120},{0,1,1,1,196,121},{0,1,1,1,196,122},{85,0,0,1,0,196},{86,0,0,1,0,196},{87,0,0,1,0,196},{88,1,0,1,0,196},{9,0,1,1,198,48},{10,0,1,1,198,48},{11,0,1,1,198,48},{12,1,1,1,198,48},{9,0,1,1,198,49},{10,0,1,1,198,49},{11,0,1,1,198,49},{12,1,1,1,198,49},{9,0,1,1,198,50},{10,0,1,1,198,50},{11,0,1,1,198,50},{12,1,1,1,198,50},{9,0,1,1,198,97},{10,0,1,1,198,97},{11,0,1,1,198,97},{12,1,1,1,198,97},{9,0,1,1,198,99},{10,0,1,1,198,99},{11,0,1,1,198,99},{12,1,1,1,198,99},{9,0,1,1,198,101},{10,0,1,1,198,101},{11,0,1,1,198,101},{12,1,1,1,198,101},{9,0,1,1,198,105},{10,0,1,1,198,105},{11,0,1,1,198,105},{12,1,1,1,198,105},{9,0,1,1,198,111},{10,0,1,1,198,111},{11,0,1,1,198,111},{12,1,1,1,198,111},{9,0,1,1,198,115},{10,0,1,1,198,115},{11,0,1,1,198,115},{12,1,1,1,198,115},{9,0,1,1,198,116},{10,0,1,1,198,116},{11,0,1,1,198,116},{12,1,1,1,198,116},{13,0,1,1,198,32},{14,1,1,1,198,32},{13,0,1,1,198,37},{14,1,1,1,198,37},{13,0,1,1,198,45},{14,1,1,1,198,45},{13,0,1,1,198,46},{14,1,1,1,198,46},{13,0,1,1,198,47},{14,1,1,1,198,47},{13,0,1,1,198,51},{14,1,1,1,198,51},{13,0,1,1,198,52},{14,1,1,1,198,52},{13,0,1,1,198,53},{14,1,1,1,198,53},{13,0,1,1,198,54},{14,1,1,1,198,54},{13,0,1,1,198,55},{14,1,1,1,198,55},{13,0,1,1,198,56},{14,1,1,1,198,56},{13,0,1,1,198,57},{14,1,1,1,198,57},{13,0,1,1,198,61},{14,1,1,1,198,61},{13,0,1,1,198,65},{14,1,1,1,198,65},{13,0,1,1,198,95},{14,1,1,1,198,95},{13,0,1,1,198,98},{14,1,1,1,198,98},{13,0,1,1,198,100},{14,1,1,1,198,100},{13,0,1,1,198,102},{14,1,1,1,198,102},{13,0,1,1,198,103},{14,1,1,1,198,103},{13,0,1,1,198,104},{14,1,1,1,198,104},{13,0,1,1,198,108},{14,1,1,1,198,108},{13,0,1,1,198,109},{14,1,1,1,198,109},{13,0,1,1,198,110},{14,1,1,1,198,110},{13,0,1,1,198,112},{14,1,1,1,198,112},{13,0,1,1,198,114},{14,1,1,1,198,114},{13,0,1,1,198,117},{14,1,1,1,198,117},{0,1,1,1,198,58},{0,1,1,1,198,66},{0,1,1,1,198,67},{0,1,1,1,198,68},{0,1,1,1,198,69},{0,1,1,1,198,70},{0,1,1,1,198,71},{0,1,1,1,198,72},{0,1,1,1,198,73},{0,1,1,1,198,74},{0,1,1,1,198,75},{0,1,1,1,198,76},{0,1,1,1,198,77},{0,1,1,1,198,78},{0,1,1,1,198,79},{0,1,1,1,198,80},{0,1,1,1,198,81},{0,1,1,1,198,82},{0,1,1,1,198,83},{0,1,1,1,198,84},{0,1,1,1,198,85},{0,1,1,1,198,86},{0,1,1,1,198,87},{0,1,1,1,198,89},{0,1,1,1,198,106},{0,1,1,1,198,107},{0,1,1,1,198,113},{0,1,1,1,198,118},{0,1,1,1,198,119},{0,1,1,1,198,120},{0,1,1,1,198,121},{0,1,1,1,198,122},{85,0,0,1,0,198},{86,0,0,1,0,198},{87,0,0,1,0,198},{88,1,0,1,0,198},{9,0,1,1,228,48},{10,0,1,1,228,48},{11,0,1,1,228,48},{12,1,1,1,228,48},{9,0,1,1,228,49},{10,0,1,1,228,49},{11,0,1,1,228,49},{12,1,1,1,228,49},{9,0,1,1,228,50},{10,0,1,1,228,50},{11,0,1,1,228,50},{12,1,1,1,228,50},{9,0,1,1,228,97},{10,0,1,1,228,97},{11,0,1,1,228,97},{12,1,1,1,228,97},{9,0,1,1,228,99},{10,0,1,1,228,99},{11,0,1,1,228,99},{12,1,1,1,228,99},{9,0,1,1,228,101},{10,0,1,1,228,101},{11,0,1,1,228,101},{12,1,1,1,228,101},{9,0,1,1,228,105},{10,0,1,1,228,105},{11,0,1,1,228,105},{12,1,1,1,228,105},{9,0,1,1,228,111},{10,0,1,1,228,111},{11,0,1,1,228,111},{12,1,1,1,228,111},{9,0,1,1,228,115},{10,0,1,1,228,115},{11,0,1,1,228,115},{12,1,1,1,228,115},{9,0,1,1,228,116},{10,0,1,1,228,116},{11,0,1,1,228,116},{12,1,1,1,228,116},{13,0,1,1,228,32},{14,1,1,1,228,32},{13,0,1,1,228,37},{14,1,1,1,228,37},{13,0,1,1,228,45},{14,1,1,1,228,45},{13,0,1,1,228,46},{14,1,1,1,228,46},{13,0,1,1,228,47},{14,1,1,1,228,47},{13,0,1,1,228,51},{14,1,1,1,228,51},{13,0,1,1,228,52},{14,1,1,1,228,52},{13,0,1,1,228,53},{14,1,1,1,228,53},{13,0,1,1,228,54},{14,1,1,1,228,54},{13,0,1,1,228,55},{14,1,1,1,228,55},{13,0,1,1,228,56},{14,1,1,1,228,56},{13,0,1,1,228,57},{14,1,1,1,228,57},{13,0,1,1,228,61},{14,1,1,1,228,61},{13,0,1,1,228,65},{14,1,1,1,228,65},{13,0,1,1,228,95},{14,1,1,1,228,95},{13,0,1,1,228,98},{14,1,1,1,228,98},{13,0,1,1,228,100},{14,1,1,1,228,100},{13,0,1,1,228,102},{14,1,1,1,228,102},{13,0,1,1,228,103},{14,1,1,1,228,103},{13,0,1,1,228,104},{14,1,1,1,228,104},{13,0,1,1,228,108},{14,1,1,1,228,108},{13,0,1,1,228,109},{14,1,1,1,228,109},{13,0,1,1,228,110},{14,1,1,1,228,110},{13,0,1,1,228,112},{14,1,1,1,228,112},{13,0,1,1,228,114},{14,1,1,1,228,114},{13,0,1,1,228,117},{14,1,1,1,228,117},{0,1,1,1,228,58},{0,1,1,1,228,66},{0,1,1,1,228,67},{0,1,1,1,228,68},{0,1,1,1,228,69},{0,1,1,1,228,70},{0,1,1,1,228,71},{0,1,1,1,228,72},{0,1,1,1,228,73},{0,1,1,1,228,74},{0,1,1,1,228,75},{0,1,1,1,228,76},{0,1,1,1,228,77},{0,1,1,1,228,78},{0,1,1,1,228,79},{0,1,1,1,228,80},{0,1,1,1,228,81},{0,1,1,1,228,82},{0,1,1,1,228,83},{0,1,1,1,228,84},{0,1,1,1,228,85},{0,1,1,1,228,86},{0,1,1,1,228,87},{0,1,1,1,228,89},{0,1,1,1,228,106},{0,1,1,1,228,107},{0,1,1,1,228,113},{0,1,1,1,228,118},{0,1,1,1,228,119},{0,1,1,1,228,120},{0,1,1,1,228,121},{0,1,1,1,228,122},{85,0,0,1,0,228},{86,0,0,1,0,228},{87,0,0,1,0,228},{88,1,0,1,0,228},{9,0,1,1,232,48},{10,0,1,1,232,48},{11,0,1,1,232,48},{12,1,1,1,232,48},{9,0,1,1,232,49},{10,0,1,1,232,49},{11,0,1,1,232,49},{12,1,1,1,232,49},{9,0,1,1,232,50},{10,0,1,1,232,50},{11,0,1,1,232,50},{12,1,1,1,232,50},{9,0,1,1,232,97},{10,0,1,1,232,97},{11,0,1,1,232,97},{12,1,1,1,232,97},{9,0,1,1,232,99},{10,0,1,1,232,99},{11,0,1,1,232,99},{12,1,1,1,232,99},{9,0,1,1,232,101},{10,0,1,1,232,101},{11,0,1,1,232,101},{12,1,1,1,232,101},{9,0,1,1,232,105},{10,0,1,1,232,105},{11,0,1,1,232,105},{12,1,1,1,232,105},{9,0,1,1,232,111},{10,0,1,1,232,111},{11,0,1,1,232,111},{12,1,1,1,232,111},{9,0,1,1,232,115},{10,0,1,1,232,115},{11,0,1,1,232,115},{12,1,1,1,232,115},{9,0,1,1,232,116},{10,0,1,1,232,116},{11,0,1,1,232,116},{12,1,1,1,232,116},{13,0,1,1,232,32},{14,1,1,1,232,32},{13,0,1,1,232,37},{14,1,1,1,232,37},{13,0,1,1,232,45},{14,1,1,1,232,45},{13,0,1,1,232,46},{14,1,1,1,232,46},{13,0,1,1,232,47},{14,1,1,1,232,47},{13,0,1,1,232,51},{14,1,1,1,232,51},{13,0,1,1,232,52},{14,1,1,1,232,52},{13,0,1,1,232,53},{14,1,1,1,232,53},{13,0,1,1,232,54},{14,1,1,1,232,54},{13,0,1,1,232,55},{14,1,1,1,232,55},{13,0,1,1,232,56},{14,1,1,1,232,56},{13,0,1,1,232,57},{14,1,1,1,232,57},{13,0,1,1,232,61},{14,1,1,1,232,61},{13,0,1,1,232,65},{14,1,1,1,232,65},{13,0,1,1,232,95},{14,1,1,1,232,95},{13,0,1,1,232,98},{14,1,1,1,232,98},{13,0,1,1,232,100},{14,1,1,1,232,100},{13,0,1,1,232,102},{14,1,1,1,232,102},{13,0,1,1,232,103},{14,1,1,1,232,103},{13,0,1,1,232,104},{14,1,1,1,232,104},{13,0,1,1,232,108},{14,1,1,1,232,108},{13,0,1,1,232,109},{14,1,1,1,232,109},{13,0,1,1,232,110},{14,1,1,1,232,110},{13,0,1,1,232,112},{14,1,1,1,232,112},{13,0,1,1,232,114},{14,1,1,1,232,114},{13,0,1,1,232,117},{14,1,1,1,232,117},{0,1,1,1,232,58},{0,1,1,1,232,66},{0,1,1,1,232,67},{0,1,1,1,232,68},{0,1,1,1,232,69},{0,1,1,1,232,70},{0,1,1,1,232,71},{0,1,1,1,232,72},{0,1,1,1,232,73},{0,1,1,1,232,74},{0,1,1,1,232,75},{0,1,1,1,232,76},{0,1,1,1,232,77},{0,1,1,1,232,78},{0,1,1,1,232,79},{0,1,1,1,232,80},{0,1,1,1,232,81},{0,1,1,1,232,82},{0,1,1,1,232,83},{0,1,1,1,232,84},{0,1,1,1,232,85},{0,1,1,1,232,86},{0,1,1,1,232,87},{0,1,1,1,232,89},{0,1,1,1,232,106},{0,1,1,1,232,107},{0,1,1,1,232,113},{0,1,1,1,232,118},{0,1,1,1,232,119},{0,1,1,1,232,120},{0,1,1,1,232,121},{0,1,1,1,232,122},{85,0,0,1,0,232},{86,0,0,1,0,232},{87,0,0,1,0,232},{88,1,0,1,0,232},{9,0,1,1,233,48},{10,0,1,1,233,48},{11,0,1,1,233,48},{12,1,1,1,233,48},{9,0,1,1,233,49},{10,0,1,1,233,49},{11,0,1,1,233,49},{12,1,1,1,233,49},{9,0,1,1,233,50},{10,0,1,1,233,50},{11,0,1,1,233,50},{12,1,1,1,233,50},{9,0,1,1,233,97},{10,0,1,1,233,97},{11,0,1,1,233,97},{12,1,1,1,233,97},{9,0,1,1,233,99},{10,0,1,1,233,99},{11,0,1,1,233,99},{12,1,1,1,233,99},{9,0,1,1,233,101},{10,0,1,1,233,101},{11,0,1,1,233,101},{12,1,1,1,233,101},{9,0,1,1,233,105},{10,0,1,1,233,105},{11,0,1,1,233,105},{12,1,1,1,233,105},{9,0,1,1,233,111},{10,0,1,1,233,111},{11,0,1,1,233,111},{12,1,1,1,233,111},{9,0,1,1,233,115},{10,0,1,1,233,115},{11,0,1,1,233,115},{12,1,1,1,233,115},{9,0,1,1,233,116},{10,0,1,1,233,116},{11,0,1,1,233,116},{12,1,1,1,233,116},{13,0,1,1,233,32},{14,1,1,1,233,32},{13,0,1,1,233,37},{14,1,1,1,233,37},{13,0,1,1,233,45},{14,1,1,1,233,45},{13,0,1,1,233,46},{14,1,1,1,233,46},{13,0,1,1,233,47},{14,1,1,1,233,47},{13,0,1,1,233,51},{14,1,1,1,233,51},{13,0,1,1,233,52},{14,1,1,1,233,52},{13,0,1,1,233,53},{14,1,1,1,233,53},{13,0,1,1,233,54},{14,1,1,1,233,54},{13,0,1,1,233,55},{14,1,1,1,233,55},{13,0,1,1,233,56},{14,1,1,1,233,56},{13,0,1,1,233,57},{14,1,1,1,233,57},{13,0,1,1,233,61},{14,1,1,1,233,61},{13,0,1,1,233,65},{14,1,1,1,233,65},{13,0,1,1,233,95},{14,1,1,1,233,95},{13,0,1,1,233,98},{14,1,1,1,233,98},{13,0,1,1,233,100},{14,1,1,1,233,100},{13,0,1,1,233,102},{14,1,1,1,233,102},{13,0,1,1,233,103},{14,1,1,1,233,103},{13,0,1,1,233,104},{14,1,1,1,233,104},{13,0,1,1,233,108},{14,1,1,1,233,108},{13,0,1,1,233,109},{14,1,1,1,233,109},{13,0,1,1,233,110},{14,1,1,1,233,110},{13,0,1,1,233,112},{14,1,1,1,233,112},{13,0,1,1,233,114},{14,1,1,1,233,114},{13,0,1,1,233,117},{14,1,1,1,233,117},{0,1,1,1,233,58},{0,1,1,1,233,66},{0,1,1,1,233,67},{0,1,1,1,233,68},{0,1,1,1,233,69},{0,1,1,1,233,70},{0,1,1,1,233,71},{0,1,1,1,233,72},{0,1,1,1,233,73},{0,1,1,1,233,74},{0,1,1,1,233,75},{0,1,1,1,233,76},{0,1,1,1,233,77},{0,1,1,1,233,78},{0,1,1,1,233,79},{0,1,1,1,233,80},{0,1,1,1,233,81},{0,1,1,1,233,82},{0,1,1,1,233,83},{0,1,1,1,233,84},{0,1,1,1,233,85},{0,1,1,1,233,86},{0,1,1,1,233,87},{0,1,1,1,233,89},{0,1,1,1,233,106},{0,1,1,1,233,107},{0,1,1,1,233,113},{0,1,1,1,233,118},{0,1,1,1,233,119},{0,1,1,1,233,120},{0,1,1,1,233,121},{0,1,1,1,233,122},{85,0,0,1,0,233},{86,0,0,1,0,233},{87,0,0,1,0,233},{88,1,0,1,0,233},{13,0,1,1,1,48},{14,1,1,1,1,48},{13,0,1,1,1,49},{14,1,1,1,1,49},{13,0,1,1,1,50},{14,1,1,1,1,50},{13,0,1,1,1,97},{14,1,1,1,1,97},{13,0,1,1,1,99},{14,1,1,1,1,99},{13,0,1,1,1,101},{14,1,1,1,1,101},{13,0,1,1,1,105},{14,1,1,1,1,105},{13,0,1,1,1,111},{14,1,1,1,1,111},{13,0,1,1,1,115},{14,1,1,1,1,115},{13,0,1,1,1,116},{14,1,1,1,1,116},{0,1,1,1,1,32},{0,1,1,1,1,37},{0,1,1,1,1,45},{0,1,1,1,1,46},{0,1,1,1,1,47},{0,1,1,1,1,51},{0,1,1,1,1,52},{0,1,1,1,1,53},{0,1,1,1,1,54},{0,1,1,1,1,55},{0,1,1,1,1,56},{0,1,1,1,1,57},{0,1,1,1,1,61},{0,1,1,1,1,65},{0,1,1,1,1,95},{0,1,1,1,1,98},{0,1,1,1,1,100},{0,1,1,1,1,102},{0,1,1,1,1,103},{0,1,1,1,1,104},{0,1,1,1,1,108},{0,1,1,1,1,109},{0,1,1,1,1,110},{0,1,1,1,1,112},{0,1,1,1,1,114},{0,1,1,1,1,117},{17,0,0,1,0,1},{18,0,0,1,0,1},{19,0,0,1,0,1},{20,0,0,1,0,1},{21,0,0,1,0,1},{22,0,0,1,0,1},{23,0,0,1,0,1},{24,0,0,1,0,1},{25,0,0,1,0,1},{26,0,0,1,0,1},{27,0,0,1,0,1},{28,0,0,1,0,1},{29,0,0,1,0,1},{30,0,0,1,0,1},{31,0,0,1,0,1},{32,0,0,1,0,1},{33,0,0,1,0,1},{34,1,0,1,0,1},{13,0,1,1,135,48},{14,1,1,1,135,48},{13,0,1,1,135,49},{14,1,1,1,135,49},{13,0,1,1,135,50},{14,1,1,1,135,50},{13,0,1,1,135,97},{14,1,1,1,135,97},{13,0,1,1,135,99},{14,1,1,1,135,99},{13,0,1,1,135,101},{14,1,1,1,135,101},{13,0,1,1,135,105},{14,1,1,1,135,105},{13,0,1,1,135,111},{14,1,1,1,135,111},{13,0,1,1,135,115},{14,1,1,1,135,115},{13,0,1,1,135,116},{14,1,1,1,135,116},{0,1,1,1,135,32},{0,1,1,1,135,37},{0,1,1,1,135,45},{0,1,1,1,135,46},{0,1,1,1,135,47},{0,1,1,1,135,51},{0,1,1,1,135,52},{0,1,1,1,135,53},{0,1,1,1,135,54},{0,1,1,1,135,55},{0,1,1,1,135,56},{0,1,1,1,135,57},{0,1,1,1,135,61},{0,1,1,1,135,65},{0,1,1,1,135,95},{0,1,1,1,135,98},{0,1,1,1,135,100},{0,1,1,1,135,102},{0,1,1,1,135,103},{0,1,1,1,135,104},{0,1,1,1,135,108},{0,1,1,1,135,109},{0,1,1,1,135,110},{0,1,1,1,135,112},{0,1,1,1,135,114},{0,1,1,1,135,117},{17,0,0,1,0,135},{18,0,0,1,0,135},{19,0,0,1,0,135},{20,0,0,1,0,135},{21,0,0,1,0,135},{22,0,0,1,0,135},{23,0,0,1,0,135},{24,0,0,1,0,135},{25,0,0,1,0,135},{26,0,0,1,0,135},{27,0,0,1,0,135},{28,0,0,1,0,135},{29,0,0,1,0,135},{30,0,0,1,0,135},{31,0,0,1,0,135},{32,0,0,1,0,135},{33,0,0,1,0,135},{34,1,0,1,0,135},{13,0,1,1,137,48},{14,1,1,1,137,48},{13,0,1,1,137,49},{14,1,1,1,137,49},{13,0,1,1,137,50},{14,1,1,1,137,50},{13,0,1,1,137,97},{14,1,1,1,137,97},{13,0,1,1,137,99},{14,1,1,1,137,99},{13,0,1,1,137,101},{14,1,1,1,137,101},{13,0,1,1,137,105},{14,1,1,1,137,105},{13,0,1,1,137,111},{14,1,1,1,137,111},{13,0,1,1,137,115},{14,1,1,1,137,115},{13,0,1,1,137,116},{14,1,1,1,137,116},{0,1,1,1,137,32},{0,1,1,1,137,37},{0,1,1,1,137,45},{0,1,1,1,137,46},{0,1,1,1,137,47},{0,1,1,1,137,51},{0,1,1,1,137,52},{0,1,1,1,137,53},{0,1,1,1,137,54},{0,1,1,1,137,55},{0,1,1,1,137,56},{0,1,1,1,137,57},{0,1,1,1,137,61},{0,1,1,1,137,65},{0,1,1,1,137,95},{0,1,1,1,137,98},{0,1,1,1,137,100},{0,1,1,1,137,102},{0,1,1,1,137,103},{0,1,1,1,137,104},{0,1,1,1,137,108},{0,1,1,1,137,109},{0,1,1,1,137,110},{0,1,1,1,137,112},{0,1,1,1,137,114},{0,1,1,1,137,117},{17,0,0,1,0,137},{18,0,0,1,0,137},{19,0,0,1,0,137},{20,0,0,1,0,137},{21,0,0,1,0,137},{22,0,0,1,0,137},{23,0,0,1,0,137},{24,0,0,1,0,137},{25,0,0,1,0,137},{26,0,0,1,0,137},{27,0,0,1,0,137},{28,0,0,1,0,137},{29,0,0,1,0,137},{30,0,0,1,0,137},{31,0,0,1,0,137},{32,0,0,1,0,137},{33,0,0,1,0,137},{34,1,0,1,0,137},{13,0,1,1,138,48},{14,1,1,1,138,48},{13,0,1,1,138,49},{14,1,1,1,138,49},{13,0,1,1,138,50},{14,1,1,1,138,50},{13,0,1,1,138,97},{14,1,1,1,138,97},{13,0,1,1,138,99},{14,1,1,1,138,99},{13,0,1,1,138,101},{14,1,1,1,138,101},{13,0,1,1,138,105},{14,1,1,1,138,105},{13,0,1,1,138,111},{14,1,1,1,138,111},{13,0,1,1,138,115},{14,1,1,1,138,115},{13,0,1,1,138,116},{14,1,1,1,138,116},{0,1,1,1,138,32},{0,1,1,1,138,37},{0,1,1,1,138,45},{0,1,1,1,138,46},{0,1,1,1,138,47},{0,1,1,1,138,51},{0,1,1,1,138,52},{0,1,1,1,138,53},{0,1,1,1,138,54},{0,1,1,1,138,55},{0,1,1,1,138,56},{0,1,1,1,138,57},{0,1,1,1,138,61},{0,1,1,1,138,65},{0,1,1,1,138,95},{0,1,1,1,138,98},{0,1,1,1,138,100},{0,1,1,1,138,102},{0,1,1,1,138,103},{0,1,1,1,138,104},{0,1,1,1,138,108},{0,1,1,1,138,109},{0,1,1,1,138,110},{0,1,1,1,138,112},{0,1,1,1,138,114},{0,1,1,1,138,117},{17,0,0,1,0,138},{18,0,0,1,0,138},{19,0,0,1,0,138},{20,0,0,1,0,138},{21,0,0,1,0,138},{22,0,0,1,0,138},{23,0,0,1,0,138},{24,0,0,1,0,138},{25,0,0,1,0,138},{26,0,0,1,0,138},{27,0,0,1,0,138},{28,0,0,1,0,138},{29,0,0,1,0,138},{30,0,0,1,0,138},{31,0,0,1,0,138},{32,0,0,1,0,138},{33,0,0,1,0,138},{34,1,0,1,0,138},{13,0,1,1,139,48},{14,1,1,1,139,48},{13,0,1,1,139,49},{14,1,1,1,139,49},{13,0,1,1,139,50},{14,1,1,1,139,50},{13,0,1,1,139,97},{14,1,1,1,139,97},{13,0,1,1,139,99},{14,1,1,1,139,99},{13,0,1,1,139,101},{14,1,1,1,139,101},{13,0,1,1,139,105},{14,1,1,1,139,105},{13,0,1,1,139,111},{14,1,1,1,139,111},{13,0,1,1,139,115},{14,1,1,1,139,115},{13,0,1,1,139,116},{14,1,1,1,139,116},{0,1,1,1,139,32},{0,1,1,1,139,37},{0,1,1,1,139,45},{0,1,1,1,139,46},{0,1,1,1,139,47},{0,1,1,1,139,51},{0,1,1,1,139,52},{0,1,1,1,139,53},{0,1,1,1,139,54},{0,1,1,1,139,55},{0,1,1,1,139,56},{0,1,1,1,139,57},{0,1,1,1,139,61},{0,1,1,1,139,65},{0,1,1,1,139,95},{0,1,1,1,139,98},{0,1,1,1,139,100},{0,1,1,1,139,102},{0,1,1,1,139,103},{0,1,1,1,139,104},{0,1,1,1,139,108},{0,1,1,1,139,109},{0,1,1,1,139,110},{0,1,1,1,139,112},{0,1,1,1,139,114},{0,1,1,1,139,117},{17,0,0,1,0,139},{18,0,0,1,0,139},{19,0,0,1,0,139},{20,0,0,1,0,139},{21,0,0,1,0,139},{22,0,0,1,0,139},{23,0,0,1,0,139},{24,0,0,1,0,139},{25,0,0,1,0,139},{26,0,0,1,0,139},{27,0,0,1,0,139},{28,0,0,1,0,139},{29,0,0,1,0,139},{30,0,0,1,0,139},{31,0,0,1,0,139},{32,0,0,1,0,139},{33,0,0,1,0,139},{34,1,0,1,0,139},{13,0,1,1,140,48},{14,1,1,1,140,48},{13,0,1,1,140,49},{14,1,1,1,140,49},{13,0,1,1,140,50},{14,1,1,1,140,50},{13,0,1,1,140,97},{14,1,1,1,140,97},{13,0,1,1,140,99},{14,1,1,1,140,99},{13,0,1,1,140,101},{14,1,1,1,140,101},{13,0,1,1,140,105},{14,1,1,1,140,105},{13,0,1,1,140,111},{14,1,1,1,140,111},{13,0,1,1,140,115},{14,1,1,1,140,115},{13,0,1,1,140,116},{14,1,1,1,140,116},{0,1,1,1,140,32},{0,1,1,1,140,37},{0,1,1,1,140,45},{0,1,1,1,140,46},{0,1,1,1,140,47},{0,1,1,1,140,51},{0,1,1,1,140,52},{0,1,1,1,140,53},{0,1,1,1,140,54},{0,1,1,1,140,55},{0,1,1,1,140,56},{0,1,1,1,140,57},{0,1,1,1,140,61},{0,1,1,1,140,65},{0,1,1,1,140,95},{0,1,1,1,140,98},{0,1,1,1,140,100},{0,1,1,1,140,102},{0,1,1,1,140,103},{0,1,1,1,140,104},{0,1,1,1,140,108},{0,1,1,1,140,109},{0,1,1,1,140,110},{0,1,1,1,140,112},{0,1,1,1,140,114},{0,1,1,1,140,117},{17,0,0,1,0,140},{18,0,0,1,0,140},{19,0,0,1,0,140},{20,0,0,1,0,140},{21,0,0,1,0,140},{22,0,0,1,0,140},{23,0,0,1,0,140},{24,0,0,1,0,140},{25,0,0,1,0,140},{26,0,0,1,0,140},{27,0,0,1,0,140},{28,0,0,1,0,140},{29,0,0,1,0,140},{30,0,0,1,0,140},{31,0,0,1,0,140},{32,0,0,1,0,140},{33,0,0,1,0,140},{34,1,0,1,0,140},{13,0,1,1,141,48},{14,1,1,1,141,48},{13,0,1,1,141,49},{14,1,1,1,141,49},{13,0,1,1,141,50},{14,1,1,1,141,50},{13,0,1,1,141,97},{14,1,1,1,141,97},{13,0,1,1,141,99},{14,1,1,1,141,99},{13,0,1,1,141,101},{14,1,1,1,141,101},{13,0,1,1,141,105},{14,1,1,1,141,105},{13,0,1,1,141,111},{14,1,1,1,141,111},{13,0,1,1,141,115},{14,1,1,1,141,115},{13,0,1,1,141,116},{14,1,1,1,141,116},{0,1,1,1,141,32},{0,1,1,1,141,37},{0,1,1,1,141,45},{0,1,1,1,141,46},{0,1,1,1,141,47},{0,1,1,1,141,51},{0,1,1,1,141,52},{0,1,1,1,141,53},{0,1,1,1,141,54},{0,1,1,1,141,55},{0,1,1,1,141,56},{0,1,1,1,141,57},{0,1,1,1,141,61},{0,1,1,1,141,65},{0,1,1,1,141,95},{0,1,1,1,141,98},{0,1,1,1,141,100},{0,1,1,1,141,102},{0,1,1,1,141,103},{0,1,1,1,141,104},{0,1,1,1,141,108},{0,1,1,1,141,109},{0,1,1,1,141,110},{0,1,1,1,141,112},{0,1,1,1,141,114},{0,1,1,1,141,117},{17,0,0,1,0,141},{18,0,0,1,0,141},{19,0,0,1,0,141},{20,0,0,1,0,141},{21,0,0,1,0,141},{22,0,0,1,0,141},{23,0,0,1,0,141},{24,0,0,1,0,141},{25,0,0,1,0,141},{26,0,0,1,0,141},{27,0,0,1,0,141},{28,0,0,1,0,141},{29,0,0,1,0,141},{30,0,0,1,0,141},{31,0,0,1,0,141},{32,0,0,1,0,141},{33,0,0,1,0,141},{34,1,0,1,0,141},{13,0,1,1,143,48},{14,1,1,1,143,48},{13,0,1,1,143,49},{14,1,1,1,143,49},{13,0,1,1,143,50},{14,1,1,1,143,50},{13,0,1,1,143,97},{14,1,1,1,143,97},{13,0,1,1,143,99},{14,1,1,1,143,99},{13,0,1,1,143,101},{14,1,1,1,143,101},{13,0,1,1,143,105},{14,1,1,1,143,105},{13,0,1,1,143,111},{14,1,1,1,143,111},{13,0,1,1,143,115},{14,1,1,1,143,115},{13,0,1,1,143,116},{14,1,1,1,143,116},{0,1,1,1,143,32},{0,1,1,1,143,37},{0,1,1,1,143,45},{0,1,1,1,143,46},{0,1,1,1,143,47},{0,1,1,1,143,51},{0,1,1,1,143,52},{0,1,1,1,143,53},{0,1,1,1,143,54},{0,1,1,1,143,55},{0,1,1,1,143,56},{0,1,1,1,143,57},{0,1,1,1,143,61},{0,1,1,1,143,65},{0,1,1,1,143,95},{0,1,1,1,143,98},{0,1,1,1,143,100},{0,1,1,1,143,102},{0,1,1,1,143,103},{0,1,1,1,143,104},{0,1,1,1,143,108},{0,1,1,1,143,109},{0,1,1,1,143,110},{0,1,1,1,143,112},{0,1,1,1,143,114},{0,1,1,1,143,117},{17,0,0,1,0,143},{18,0,0,1,0,143},{19,0,0,1,0,143},{20,0,0,1,0,143},{21,0,0,1,0,143},{22,0,0,1,0,143},{23,0,0,1,0,143},{24,0,0,1,0,143},{25,0,0,1,0,143},{26,0,0,1,0,143},{27,0,0,1,0,143},{28,0,0,1,0,143},{29,0,0,1,0,143},{30,0,0,1,0,143},{31,0,0,1,0,143},{32,0,0,1,0,143},{33,0,0,1,0,143},{34,1,0,1,0,143},{13,0,1,1,147,48},{14,1,1,1,147,48},{13,0,1,1,147,49},{14,1,1,1,147,49},{13,0,1,1,147,50},{14,1,1,1,147,50},{13,0,1,1,147,97},{14,1,1,1,147,97},{13,0,1,1,147,99},{14,1,1,1,147,99},{13,0,1,1,147,101},{14,1,1,1,147,101},{13,0,1,1,147,105},{14,1,1,1,147,105},{13,0,1,1,147,111},{14,1,1,1,147,111},{13,0,1,1,147,115},{14,1,1,1,147,115},{13,0,1,1,147,116},{14,1,1,1,147,116},{0,1,1,1,147,32},{0,1,1,1,147,37},{0,1,1,1,147,45},{0,1,1,1,147,46},{0,1,1,1,147,47},{0,1,1,1,147,51},{0,1,1,1,147,52},{0,1,1,1,147,53},{0,1,1,1,147,54},{0,1,1,1,147,55},{0,1,1,1,147,56},{0,1,1,1,147,57},{0,1,1,1,147,61},{0,1,1,1,147,65},{0,1,1,1,147,95},{0,1,1,1,147,98},{0,1,1,1,147,100},{0,1,1,1,147,102},{0,1,1,1,147,103},{0,1,1,1,147,104},{0,1,1,1,147,108},{0,1,1,1,147,109},{0,1,1,1,147,110},{0,1,1,1,147,112},{0,1,1,1,147,114},{0,1,1,1,147,117},{17,0,0,1,0,147},{18,0,0,1,0,147},{19,0,0,1,0,147},{20,0,0,1,0,147},{21,0,0,1,0,147},{22,0,0,1,0,147},{23,0,0,1,0,147},{24,0,0,1,0,147},{25,0,0,1,0,147},{26,0,0,1,0,147},{27,0,0,1,0,147},{28,0,0,1,0,147},{29,0,0,1,0,147},{30,0,0,1,0,147},{31,0,0,1,0,147},{32,0,0,1,0,147},{33,0,0,1,0,147},{34,1,0,1,0,147},{13,0,1,1,149,48},{14,1,1,1,149,48},{13,0,1,1,149,49},{14,1,1,1,149,49},{13,0,1,1,149,50},{14,1,1,1,149,50},{13,0,1,1,149,97},{14,1,1,1,149,97},{13,0,1,1,149,99},{14,1,1,1,149,99},{13,0,1,1,149,101},{14,1,1,1,149,101},{13,0,1,1,149,105},{14,1,1,1,149,105},{13,0,1,1,149,111},{14,1,1,1,149,111},{13,0,1,1,149,115},{14,1,1,1,149,115},{13,0,1,1,149,116},{14,1,1,1,149,116},{0,1,1,1,149,32},{0,1,1,1,149,37},{0,1,1,1,149,45},{0,1,1,1,149,46},{0,1,1,1,149,47},{0,1,1,1,149,51},{0,1,1,1,149,52},{0,1,1,1,149,53},{0,1,1,1,149,54},{0,1,1,1,149,55},{0,1,1,1,149,56},{0,1,1,1,149,57},{0,1,1,1,149,61},{0,1,1,1,149,65},{0,1,1,1,149,95},{0,1,1,1,149,98},{0,1,1,1,149,100},{0,1,1,1,149,102},{0,1,1,1,149,103},{0,1,1,1,149,104},{0,1,1,1,149,108},{0,1,1,1,149,109},{0,1,1,1,149,110},{0,1,1,1,149,112},{0,1,1,1,149,114},{0,1,1,1,149,117},{17,0,0,1,0,149},{18,0,0,1,0,149},{19,0,0,1,0,149},{20,0,0,1,0,149},{21,0,0,1,0,149},{22,0,0,1,0,149},{23,0,0,1,0,149},{24,0,0,1,0,149},{25,0,0,1,0,149},{26,0,0,1,0,149},{27,0,0,1,0,149},{28,0,0,1,0,149},{29,0,0,1,0,149},{30,0,0,1,0,149},{31,0,0,1,0,149},{32,0,0,1,0,149},{33,0,0,1,0,149},{34,1,0,1,0,149},{13,0,1,1,150,48},{14,1,1,1,150,48},{13,0,1,1,150,49},{14,1,1,1,150,49},{13,0,1,1,150,50},{14,1,1,1,150,50},{13,0,1,1,150,97},{14,1,1,1,150,97},{13,0,1,1,150,99},{14,1,1,1,150,99},{13,0,1,1,150,101},{14,1,1,1,150,101},{13,0,1,1,150,105},{14,1,1,1,150,105},{13,0,1,1,150,111},{14,1,1,1,150,111},{13,0,1,1,150,115},{14,1,1,1,150,115},{13,0,1,1,150,116},{14,1,1,1,150,116},{0,1,1,1,150,32},{0,1,1,1,150,37},{0,1,1,1,150,45},{0,1,1,1,150,46},{0,1,1,1,150,47},{0,1,1,1,150,51},{0,1,1,1,150,52},{0,1,1,1,150,53},{0,1,1,1,150,54},{0,1,1,1,150,55},{0,1,1,1,150,56},{0,1,1,1,150,57},{0,1,1,1,150,61},{0,1,1,1,150,65},{0,1,1,1,150,95},{0,1,1,1,150,98},{0,1,1,1,150,100},{0,1,1,1,150,102},{0,1,1,1,150,103},{0,1,1,1,150,104},{0,1,1,1,150,108},{0,1,1,1,150,109},{0,1,1,1,150,110},{0,1,1,1,150,112},{0,1,1,1,150,114},{0,1,1,1,150,117},{17,0,0,1,0,150},{18,0,0,1,0,150},{19,0,0,1,0,150},{20,0,0,1,0,150},{21,0,0,1,0,150},{22,0,0,1,0,150},{23,0,0,1,0,150},{24,0,0,1,0,150},{25,0,0,1,0,150},{26,0,0,1,0,150},{27,0,0,1,0,150},{28,0,0,1,0,150},{29,0,0,1,0,150},{30,0,0,1,0,150},{31,0,0,1,0,150},{32,0,0,1,0,150},{33,0,0,1,0,150},{34,1,0,1,0,150},{13,0,1,1,151,48},{14,1,1,1,151,48},{13,0,1,1,151,49},{14,1,1,1,151,49},{13,0,1,1,151,50},{14,1,1,1,151,50},{13,0,1,1,151,97},{14,1,1,1,151,97},{13,0,1,1,151,99},{14,1,1,1,151,99},{13,0,1,1,151,101},{14,1,1,1,151,101},{13,0,1,1,151,105},{14,1,1,1,151,105},{13,0,1,1,151,111},{14,1,1,1,151,111},{13,0,1,1,151,115},{14,1,1,1,151,115},{13,0,1,1,151,116},{14,1,1,1,151,116},{0,1,1,1,151,32},{0,1,1,1,151,37},{0,1,1,1,151,45},{0,1,1,1,151,46},{0,1,1,1,151,47},{0,1,1,1,151,51},{0,1,1,1,151,52},{0,1,1,1,151,53},{0,1,1,1,151,54},{0,1,1,1,151,55},{0,1,1,1,151,56},{0,1,1,1,151,57},{0,1,1,1,151,61},{0,1,1,1,151,65},{0,1,1,1,151,95},{0,1,1,1,151,98},{0,1,1,1,151,100},{0,1,1,1,151,102},{0,1,1,1,151,103},{0,1,1,1,151,104},{0,1,1,1,151,108},{0,1,1,1,151,109},{0,1,1,1,151,110},{0,1,1,1,151,112},{0,1,1,1,151,114},{0,1,1,1,151,117},{17,0,0,1,0,151},{18,0,0,1,0,151},{19,0,0,1,0,151},{20,0,0,1,0,151},{21,0,0,1,0,151},{22,0,0,1,0,151},{23,0,0,1,0,151},{24,0,0,1,0,151},{25,0,0,1,0,151},{26,0,0,1,0,151},{27,0,0,1,0,151},{28,0,0,1,0,151},{29,0,0,1,0,151},{30,0,0,1,0,151},{31,0,0,1,0,151},{32,0,0,1,0,151},{33,0,0,1,0,151},{34,1,0,1,0,151},{13,0,1,1,152,48},{14,1,1,1,152,48},{13,0,1,1,152,49},{14,1,1,1,152,49},{13,0,1,1,152,50},{14,1,1,1,152,50},{13,0,1,1,152,97},{14,1,1,1,152,97},{13,0,1,1,152,99},{14,1,1,1,152,99},{13,0,1,1,152,101},{14,1,1,1,152,101},{13,0,1,1,152,105},{14,1,1,1,152,105},{13,0,1,1,152,111},{14,1,1,1,152,111},{13,0,1,1,152,115},{14,1,1,1,152,115},{13,0,1,1,152,116},{14,1,1,1,152,116},{0,1,1,1,152,32},{0,1,1,1,152,37},{0,1,1,1,152,45},{0,1,1,1,152,46},{0,1,1,1,152,47},{0,1,1,1,152,51},{0,1,1,1,152,52},{0,1,1,1,152,53},{0,1,1,1,152,54},{0,1,1,1,152,55},{0,1,1,1,152,56},{0,1,1,1,152,57},{0,1,1,1,152,61},{0,1,1,1,152,65},{0,1,1,1,152,95},{0,1,1,1,152,98},{0,1,1,1,152,100},{0,1,1,1,152,102},{0,1,1,1,152,103},{0,1,1,1,152,104},{0,1,1,1,152,108},{0,1,1,1,152,109},{0,1,1,1,152,110},{0,1,1,1,152,112},{0,1,1,1,152,114},{0,1,1,1,152,117},{17,0,0,1,0,152},{18,0,0,1,0,152},{19,0,0,1,0,152},{20,0,0,1,0,152},{21,0,0,1,0,152},{22,0,0,1,0,152},{23,0,0,1,0,152},{24,0,0,1,0,152},{25,0,0,1,0,152},{26,0,0,1,0,152},{27,0,0,1,0,152},{28,0,0,1,0,152},{29,0,0,1,0,152},{30,0,0,1,0,152},{31,0,0,1,0,152},{32,0,0,1,0,152},{33,0,0,1,0,152},{34,1,0,1,0,152},{13,0,1,1,155,48},{14,1,1,1,155,48},{13,0,1,1,155,49},{14,1,1,1,155,49},{13,0,1,1,155,50},{14,1,1,1,155,50},{13,0,1,1,155,97},{14,1,1,1,155,97},{13,0,1,1,155,99},{14,1,1,1,155,99},{13,0,1,1,155,101},{14,1,1,1,155,101},{13,0,1,1,155,105},{14,1,1,1,155,105},{13,0,1,1,155,111},{14,1,1,1,155,111},{13,0,1,1,155,115},{14,1,1,1,155,115},{13,0,1,1,155,116},{14,1,1,1,155,116},{0,1,1,1,155,32},{0,1,1,1,155,37},{0,1,1,1,155,45},{0,1,1,1,155,46},{0,1,1,1,155,47},{0,1,1,1,155,51},{0,1,1,1,155,52},{0,1,1,1,155,53},{0,1,1,1,155,54},{0,1,1,1,155,55},{0,1,1,1,155,56},{0,1,1,1,155,57},{0,1,1,1,155,61},{0,1,1,1,155,65},{0,1,1,1,155,95},{0,1,1,1,155,98},{0,1,1,1,155,100},{0,1,1,1,155,102},{0,1,1,1,155,103},{0,1,1,1,155,104},{0,1,1,1,155,108},{0,1,1,1,155,109},{0,1,1,1,155,110},{0,1,1,1,155,112},{0,1,1,1,155,114},{0,1,1,1,155,117},{17,0,0,1,0,155},{18,0,0,1,0,155},{19,0,0,1,0,155},{20,0,0,1,0,155},{21,0,0,1,0,155},{22,0,0,1,0,155},{23,0,0,1,0,155},{24,0,0,1,0,155},{25,0,0,1,0,155},{26,0,0,1,0,155},{27,0,0,1,0,155},{28,0,0,1,0,155},{29,0,0,1,0,155},{30,0,0,1,0,155},{31,0,0,1,0,155},{32,0,0,1,0,155},{33,0,0,1,0,155},{34,1,0,1,0,155},{13,0,1,1,157,48},{14,1,1,1,157,48},{13,0,1,1,157,49},{14,1,1,1,157,49},{13,0,1,1,157,50},{14,1,1,1,157,50},{13,0,1,1,157,97},{14,1,1,1,157,97},{13,0,1,1,157,99},{14,1,1,1,157,99},{13,0,1,1,157,101},{14,1,1,1,157,101},{13,0,1,1,157,105},{14,1,1,1,157,105},{13,0,1,1,157,111},{14,1,1,1,157,111},{13,0,1,1,157,115},{14,1,1,1,157,115},{13,0,1,1,157,116},{14,1,1,1,157,116},{0,1,1,1,157,32},{0,1,1,1,157,37},{0,1,1,1,157,45},{0,1,1,1,157,46},{0,1,1,1,157,47},{0,1,1,1,157,51},{0,1,1,1,157,52},{0,1,1,1,157,53},{0,1,1,1,157,54},{0,1,1,1,157,55},{0,1,1,1,157,56},{0,1,1,1,157,57},{0,1,1,1,157,61},{0,1,1,1,157,65},{0,1,1,1,157,95},{0,1,1,1,157,98},{0,1,1,1,157,100},{0,1,1,1,157,102},{0,1,1,1,157,103},{0,1,1,1,157,104},{0,1,1,1,157,108},{0,1,1,1,157,109},{0,1,1,1,157,110},{0,1,1,1,157,112},{0,1,1,1,157,114},{0,1,1,1,157,117},{17,0,0,1,0,157},{18,0,0,1,0,157},{19,0,0,1,0,157},{20,0,0,1,0,157},{21,0,0,1,0,157},{22,0,0,1,0,157},{23,0,0,1,0,157},{24,0,0,1,0,157},{25,0,0,1,0,157},{26,0,0,1,0,157},{27,0,0,1,0,157},{28,0,0,1,0,157},{29,0,0,1,0,157},{30,0,0,1,0,157},{31,0,0,1,0,157},{32,0,0,1,0,157},{33,0,0,1,0,157},{34,1,0,1,0,157},{13,0,1,1,158,48},{14,1,1,1,158,48},{13,0,1,1,158,49},{14,1,1,1,158,49},{13,0,1,1,158,50},{14,1,1,1,158,50},{13,0,1,1,158,97},{14,1,1,1,158,97},{13,0,1,1,158,99},{14,1,1,1,158,99},{13,0,1,1,158,101},{14,1,1,1,158,101},{13,0,1,1,158,105},{14,1,1,1,158,105},{13,0,1,1,158,111},{14,1,1,1,158,111},{13,0,1,1,158,115},{14,1,1,1,158,115},{13,0,1,1,158,116},{14,1,1,1,158,116},{0,1,1,1,158,32},{0,1,1,1,158,37},{0,1,1,1,158,45},{0,1,1,1,158,46},{0,1,1,1,158,47},{0,1,1,1,158,51},{0,1,1,1,158,52},{0,1,1,1,158,53},{0,1,1,1,158,54},{0,1,1,1,158,55},{0,1,1,1,158,56},{0,1,1,1,158,57},{0,1,1,1,158,61},{0,1,1,1,158,65},{0,1,1,1,158,95},{0,1,1,1,158,98},{0,1,1,1,158,100},{0,1,1,1,158,102},{0,1,1,1,158,103},{0,1,1,1,158,104},{0,1,1,1,158,108},{0,1,1,1,158,109},{0,1,1,1,158,110},{0,1,1,1,158,112},{0,1,1,1,158,114},{0,1,1,1,158,117},{17,0,0,1,0,158},{18,0,0,1,0,158},{19,0,0,1,0,158},{20,0,0,1,0,158},{21,0,0,1,0,158},{22,0,0,1,0,158},{23,0,0,1,0,158},{24,0,0,1,0,158},{25,0,0,1,0,158},{26,0,0,1,0,158},{27,0,0,1,0,158},{28,0,0,1,0,158},{29,0,0,1,0,158},{30,0,0,1,0,158},{31,0,0,1,0,158},{32,0,0,1,0,158},{33,0,0,1,0,158},{34,1,0,1,0,158},{13,0,1,1,165,48},{14,1,1,1,165,48},{13,0,1,1,165,49},{14,1,1,1,165,49},{13,0,1,1,165,50},{14,1,1,1,165,50},{13,0,1,1,165,97},{14,1,1,1,165,97},{13,0,1,1,165,99},{14,1,1,1,165,99},{13,0,1,1,165,101},{14,1,1,1,165,101},{13,0,1,1,165,105},{14,1,1,1,165,105},{13,0,1,1,165,111},{14,1,1,1,165,111},{13,0,1,1,165,115},{14,1,1,1,165,115},{13,0,1,1,165,116},{14,1,1,1,165,116},{0,1,1,1,165,32},{0,1,1,1,165,37},{0,1,1,1,165,45},{0,1,1,1,165,46},{0,1,1,1,165,47},{0,1,1,1,165,51},{0,1,1,1,165,52},{0,1,1,1,165,53},{0,1,1,1,165,54},{0,1,1,1,165,55},{0,1,1,1,165,56},{0,1,1,1,165,57},{0,1,1,1,165,61},{0,1,1,1,165,65},{0,1,1,1,165,95},{0,1,1,1,165,98},{0,1,1,1,165,100},{0,1,1,1,165,102},{0,1,1,1,165,103},{0,1,1,1,165,104},{0,1,1,1,165,108},{0,1,1,1,165,109},{0,1,1,1,165,110},{0,1,1,1,165,112},{0,1,1,1,165,114},{0,1,1,1,165,117},{17,0,0,1,0,165},{18,0,0,1,0,165},{19,0,0,1,0,165},{20,0,0,1,0,165},{21,0,0,1,0,165},{22,0,0,1,0,165},{23,0,0,1,0,165},{24,0,0,1,0,165},{25,0,0,1,0,165},{26,0,0,1,0,165},{27,0,0,1,0,165},{28,0,0,1,0,165},{29,0,0,1,0,165},{30,0,0,1,0,165},{31,0,0,1,0,165},{32,0,0,1,0,165},{33,0,0,1,0,165},{34,1,0,1,0,165},{13,0,1,1,166,48},{14,1,1,1,166,48},{13,0,1,1,166,49},{14,1,1,1,166,49},{13,0,1,1,166,50},{14,1,1,1,166,50},{13,0,1,1,166,97},{14,1,1,1,166,97},{13,0,1,1,166,99},{14,1,1,1,166,99},{13,0,1,1,166,101},{14,1,1,1,166,101},{13,0,1,1,166,105},{14,1,1,1,166,105},{13,0,1,1,166,111},{14,1,1,1,166,111},{13,0,1,1,166,115},{14,1,1,1,166,115},{13,0,1,1,166,116},{14,1,1,1,166,116},{0,1,1,1,166,32},{0,1,1,1,166,37},{0,1,1,1,166,45},{0,1,1,1,166,46},{0,1,1,1,166,47},{0,1,1,1,166,51},{0,1,1,1,166,52},{0,1,1,1,166,53},{0,1,1,1,166,54},{0,1,1,1,166,55},{0,1,1,1,166,56},{0,1,1,1,166,57},{0,1,1,1,166,61},{0,1,1,1,166,65},{0,1,1,1,166,95},{0,1,1,1,166,98},{0,1,1,1,166,100},{0,1,1,1,166,102},{0,1,1,1,166,103},{0,1,1,1,166,104},{0,1,1,1,166,108},{0,1,1,1,166,109},{0,1,1,1,166,110},{0,1,1,1,166,112},{0,1,1,1,166,114},{0,1,1,1,166,117},{17,0,0,1,0,166},{18,0,0,1,0,166},{19,0,0,1,0,166},{20,0,0,1,0,166},{21,0,0,1,0,166},{22,0,0,1,0,166},{23,0,0,1,0,166},{24,0,0,1,0,166},{25,0,0,1,0,166},{26,0,0,1,0,166},{27,0,0,1,0,166},{28,0,0,1,0,166},{29,0,0,1,0,166},{30,0,0,1,0,166},{31,0,0,1,0,166},{32,0,0,1,0,166},{33,0,0,1,0,166},{34,1,0,1,0,166},{13,0,1,1,168,48},{14,1,1,1,168,48},{13,0,1,1,168,49},{14,1,1,1,168,49},{13,0,1,1,168,50},{14,1,1,1,168,50},{13,0,1,1,168,97},{14,1,1,1,168,97},{13,0,1,1,168,99},{14,1,1,1,168,99},{13,0,1,1,168,101},{14,1,1,1,168,101},{13,0,1,1,168,105},{14,1,1,1,168,105},{13,0,1,1,168,111},{14,1,1,1,168,111},{13,0,1,1,168,115},{14,1,1,1,168,115},{13,0,1,1,168,116},{14,1,1,1,168,116},{0,1,1,1,168,32},{0,1,1,1,168,37},{0,1,1,1,168,45},{0,1,1,1,168,46},{0,1,1,1,168,47},{0,1,1,1,168,51},{0,1,1,1,168,52},{0,1,1,1,168,53},{0,1,1,1,168,54},{0,1,1,1,168,55},{0,1,1,1,168,56},{0,1,1,1,168,57},{0,1,1,1,168,61},{0,1,1,1,168,65},{0,1,1,1,168,95},{0,1,1,1,168,98},{0,1,1,1,168,100},{0,1,1,1,168,102},{0,1,1,1,168,103},{0,1,1,1,168,104},{0,1,1,1,168,108},{0,1,1,1,168,109},{0,1,1,1,168,110},{0,1,1,1,168,112},{0,1,1,1,168,114},{0,1,1,1,168,117},{17,0,0,1,0,168},{18,0,0,1,0,168},{19,0,0,1,0,168},{20,0,0,1,0,168},{21,0,0,1,0,168},{22,0,0,1,0,168},{23,0,0,1,0,168},{24,0,0,1,0,168},{25,0,0,1,0,168},{26,0,0,1,0,168},{27,0,0,1,0,168},{28,0,0,1,0,168},{29,0,0,1,0,168},{30,0,0,1,0,168},{31,0,0,1,0,168},{32,0,0,1,0,168},{33,0,0,1,0,168},{34,1,0,1,0,168},{13,0,1,1,174,48},{14,1,1,1,174,48},{13,0,1,1,174,49},{14,1,1,1,174,49},{13,0,1,1,174,50},{14,1,1,1,174,50},{13,0,1,1,174,97},{14,1,1,1,174,97},{13,0,1,1,174,99},{14,1,1,1,174,99},{13,0,1,1,174,101},{14,1,1,1,174,101},{13,0,1,1,174,105},{14,1,1,1,174,105},{13,0,1,1,174,111},{14,1,1,1,174,111},{13,0,1,1,174,115},{14,1,1,1,174,115},{13,0,1,1,174,116},{14,1,1,1,174,116},{0,1,1,1,174,32},{0,1,1,1,174,37},{0,1,1,1,174,45},{0,1,1,1,174,46},{0,1,1,1,174,47},{0,1,1,1,174,51},{0,1,1,1,174,52},{0,1,1,1,174,53},{0,1,1,1,174,54},{0,1,1,1,174,55},{0,1,1,1,174,56},{0,1,1,1,174,57},{0,1,1,1,174,61},{0,1,1,1,174,65},{0,1,1,1,174,95},{0,1,1,1,174,98},{0,1,1,1,174,100},{0,1,1,1,174,102},{0,1,1,1,174,103},{0,1,1,1,174,104},{0,1,1,1,174,108},{0,1,1,1,174,109},{0,1,1,1,174,110},{0,1,1,1,174,112},{0,1,1,1,174,114},{0,1,1,1,174,117},{17,0,0,1,0,174},{18,0,0,1,0,174},{19,0,0,1,0,174},{20,0,0,1,0,174},{21,0,0,1,0,174},{22,0,0,1,0,174},{23,0,0,1,0,174},{24,0,0,1,0,174},{25,0,0,1,0,174},{26,0,0,1,0,174},{27,0,0,1,0,174},{28,0,0,1,0,174},{29,0,0,1,0,174},{30,0,0,1,0,174},{31,0,0,1,0,174},{32,0,0,1,0,174},{33,0,0,1,0,174},{34,1,0,1,0,174},{13,0,1,1,175,48},{14,1,1,1,175,48},{13,0,1,1,175,49},{14,1,1,1,175,49},{13,0,1,1,175,50},{14,1,1,1,175,50},{13,0,1,1,175,97},{14,1,1,1,175,97},{13,0,1,1,175,99},{14,1,1,1,175,99},{13,0,1,1,175,101},{14,1,1,1,175,101},{13,0,1,1,175,105},{14,1,1,1,175,105},{13,0,1,1,175,111},{14,1,1,1,175,111},{13,0,1,1,175,115},{14,1,1,1,175,115},{13,0,1,1,175,116},{14,1,1,1,175,116},{0,1,1,1,175,32},{0,1,1,1,175,37},{0,1,1,1,175,45},{0,1,1,1,175,46},{0,1,1,1,175,47},{0,1,1,1,175,51},{0,1,1,1,175,52},{0,1,1,1,175,53},{0,1,1,1,175,54},{0,1,1,1,175,55},{0,1,1,1,175,56},{0,1,1,1,175,57},{0,1,1,1,175,61},{0,1,1,1,175,65},{0,1,1,1,175,95},{0,1,1,1,175,98},{0,1,1,1,175,100},{0,1,1,1,175,102},{0,1,1,1,175,103},{0,1,1,1,175,104},{0,1,1,1,175,108},{0,1,1,1,175,109},{0,1,1,1,175,110},{0,1,1,1,175,112},{0,1,1,1,175,114},{0,1,1,1,175,117},{17,0,0,1,0,175},{18,0,0,1,0,175},{19,0,0,1,0,175},{20,0,0,1,0,175},{21,0,0,1,0,175},{22,0,0,1,0,175},{23,0,0,1,0,175},{24,0,0,1,0,175},{25,0,0,1,0,175},{26,0,0,1,0,175},{27,0,0,1,0,175},{28,0,0,1,0,175},{29,0,0,1,0,175},{30,0,0,1,0,175},{31,0,0,1,0,175},{32,0,0,1,0,175},{33,0,0,1,0,175},{34,1,0,1,0,175},{13,0,1,1,180,48},{14,1,1,1,180,48},{13,0,1,1,180,49},{14,1,1,1,180,49},{13,0,1,1,180,50},{14,1,1,1,180,50},{13,0,1,1,180,97},{14,1,1,1,180,97},{13,0,1,1,180,99},{14,1,1,1,180,99},{13,0,1,1,180,101},{14,1,1,1,180,101},{13,0,1,1,180,105},{14,1,1,1,180,105},{13,0,1,1,180,111},{14,1,1,1,180,111},{13,0,1,1,180,115},{14,1,1,1,180,115},{13,0,1,1,180,116},{14,1,1,1,180,116},{0,1,1,1,180,32},{0,1,1,1,180,37},{0,1,1,1,180,45},{0,1,1,1,180,46},{0,1,1,1,180,47},{0,1,1,1,180,51},{0,1,1,1,180,52},{0,1,1,1,180,53},{0,1,1,1,180,54},{0,1,1,1,180,55},{0,1,1,1,180,56},{0,1,1,1,180,57},{0,1,1,1,180,61},{0,1,1,1,180,65},{0,1,1,1,180,95},{0,1,1,1,180,98},{0,1,1,1,180,100},{0,1,1,1,180,102},{0,1,1,1,180,103},{0,1,1,1,180,104},{0,1,1,1,180,108},{0,1,1,1,180,109},{0,1,1,1,180,110},{0,1,1,1,180,112},{0,1,1,1,180,114},{0,1,1,1,180,117},{17,0,0,1,0,180},{18,0,0,1,0,180},{19,0,0,1,0,180},{20,0,0,1,0,180},{21,0,0,1,0,180},{22,0,0,1,0,180},{23,0,0,1,0,180},{24,0,0,1,0,180},{25,0,0,1,0,180},{26,0,0,1,0,180},{27,0,0,1,0,180},{28,0,0,1,0,180},{29,0,0,1,0,180},{30,0,0,1,0,180},{31,0,0,1,0,180},{32,0,0,1,0,180},{33,0,0,1,0,180},{34,1,0,1,0,180},{13,0,1,1,182,48},{14,1,1,1,182,48},{13,0,1,1,182,49},{14,1,1,1,182,49},{13,0,1,1,182,50},{14,1,1,1,182,50},{13,0,1,1,182,97},{14,1,1,1,182,97},{13,0,1,1,182,99},{14,1,1,1,182,99},{13,0,1,1,182,101},{14,1,1,1,182,101},{13,0,1,1,182,105},{14,1,1,1,182,105},{13,0,1,1,182,111},{14,1,1,1,182,111},{13,0,1,1,182,115},{14,1,1,1,182,115},{13,0,1,1,182,116},{14,1,1,1,182,116},{0,1,1,1,182,32},{0,1,1,1,182,37},{0,1,1,1,182,45},{0,1,1,1,182,46},{0,1,1,1,182,47},{0,1,1,1,182,51},{0,1,1,1,182,52},{0,1,1,1,182,53},{0,1,1,1,182,54},{0,1,1,1,182,55},{0,1,1,1,182,56},{0,1,1,1,182,57},{0,1,1,1,182,61},{0,1,1,1,182,65},{0,1,1,1,182,95},{0,1,1,1,182,98},{0,1,1,1,182,100},{0,1,1,1,182,102},{0,1,1,1,182,103},{0,1,1,1,182,104},{0,1,1,1,182,108},{0,1,1,1,182,109},{0,1,1,1,182,110},{0,1,1,1,182,112},{0,1,1,1,182,114},{0,1,1,1,182,117},{17,0,0,1,0,182},{18,0,0,1,0,182},{19,0,0,1,0,182},{20,0,0,1,0,182},{21,0,0,1,0,182},{22,0,0,1,0,182},{23,0,0,1,0,182},{24,0,0,1,0,182},{25,0,0,1,0,182},{26,0,0,1,0,182},{27,0,0,1,0,182},{28,0,0,1,0,182},{29,0,0,1,0,182},{30,0,0,1,0,182},{31,0,0,1,0,182},{32,0,0,1,0,182},{33,0,0,1,0,182},{34,1,0,1,0,182},{13,0,1,1,183,48},{14,1,1,1,183,48},{13,0,1,1,183,49},{14,1,1,1,183,49},{13,0,1,1,183,50},{14,1,1,1,183,50},{13,0,1,1,183,97},{14,1,1,1,183,97},{13,0,1,1,183,99},{14,1,1,1,183,99},{13,0,1,1,183,101},{14,1,1,1,183,101},{13,0,1,1,183,105},{14,1,1,1,183,105},{13,0,1,1,183,111},{14,1,1,1,183,111},{13,0,1,1,183,115},{14,1,1,1,183,115},{13,0,1,1,183,116},{14,1,1,1,183,116},{0,1,1,1,183,32},{0,1,1,1,183,37},{0,1,1,1,183,45},{0,1,1,1,183,46},{0,1,1,1,183,47},{0,1,1,1,183,51},{0,1,1,1,183,52},{0,1,1,1,183,53},{0,1,1,1,183,54},{0,1,1,1,183,55},{0,1,1,1,183,56},{0,1,1,1,183,57},{0,1,1,1,183,61},{0,1,1,1,183,65},{0,1,1,1,183,95},{0,1,1,1,183,98},{0,1,1,1,183,100},{0,1,1,1,183,102},{0,1,1,1,183,103},{0,1,1,1,183,104},{0,1,1,1,183,108},{0,1,1,1,183,109},{0,1,1,1,183,110},{0,1,1,1,183,112},{0,1,1,1,183,114},{0,1,1,1,183,117},{17,0,0,1,0,183},{18,0,0,1,0,183},{19,0,0,1,0,183},{20,0,0,1,0,183},{21,0,0,1,0,183},{22,0,0,1,0,183},{23,0,0,1,0,183},{24,0,0,1,0,183},{25,0,0,1,0,183},{26,0,0,1,0,183},{27,0,0,1,0,183},{28,0,0,1,0,183},{29,0,0,1,0,183},{30,0,0,1,0,183},{31,0,0,1,0,183},{32,0,0,1,0,183},{33,0,0,1,0,183},{34,1,0,1,0,183},{13,0,1,1,188,48},{14,1,1,1,188,48},{13,0,1,1,188,49},{14,1,1,1,188,49},{13,0,1,1,188,50},{14,1,1,1,188,50},{13,0,1,1,188,97},{14,1,1,1,188,97},{13,0,1,1,188,99},{14,1,1,1,188,99},{13,0,1,1,188,101},{14,1,1,1,188,101},{13,0,1,1,188,105},{14,1,1,1,188,105},{13,0,1,1,188,111},{14,1,1,1,188,111},{13,0,1,1,188,115},{14,1,1,1,188,115},{13,0,1,1,188,116},{14,1,1,1,188,116},{0,1,1,1,188,32},{0,1,1,1,188,37},{0,1,1,1,188,45},{0,1,1,1,188,46},{0,1,1,1,188,47},{0,1,1,1,188,51},{0,1,1,1,188,52},{0,1,1,1,188,53},{0,1,1,1,188,54},{0,1,1,1,188,55},{0,1,1,1,188,56},{0,1,1,1,188,57},{0,1,1,1,188,61},{0,1,1,1,188,65},{0,1,1,1,188,95},{0,1,1,1,188,98},{0,1,1,1,188,100},{0,1,1,1,188,102},{0,1,1,1,188,103},{0,1,1,1,188,104},{0,1,1,1,188,108},{0,1,1,1,188,109},{0,1,1,1,188,110},{0,1,1,1,188,112},{0,1,1,1,188,114},{0,1,1,1,188,117},{17,0,0,1,0,188},{18,0,0,1,0,188},{19,0,0,1,0,188},{20,0,0,1,0,188},{21,0,0,1,0,188},{22,0,0,1,0,188},{23,0,0,1,0,188},{24,0,0,1,0,188},{25,0,0,1,0,188},{26,0,0,1,0,188},{27,0,0,1,0,188},{28,0,0,1,0,188},{29,0,0,1,0,188},{30,0,0,1,0,188},{31,0,0,1,0,188},{32,0,0,1,0,188},{33,0,0,1,0,188},{34,1,0,1,0,188},{13,0,1,1,191,48},{14,1,1,1,191,48},{13,0,1,1,191,49},{14,1,1,1,191,49},{13,0,1,1,191,50},{14,1,1,1,191,50},{13,0,1,1,191,97},{14,1,1,1,191,97},{13,0,1,1,191,99},{14,1,1,1,191,99},{13,0,1,1,191,101},{14,1,1,1,191,101},{13,0,1,1,191,105},{14,1,1,1,191,105},{13,0,1,1,191,111},{14,1,1,1,191,111},{13,0,1,1,191,115},{14,1,1,1,191,115},{13,0,1,1,191,116},{14,1,1,1,191,116},{0,1,1,1,191,32},{0,1,1,1,191,37},{0,1,1,1,191,45},{0,1,1,1,191,46},{0,1,1,1,191,47},{0,1,1,1,191,51},{0,1,1,1,191,52},{0,1,1,1,191,53},{0,1,1,1,191,54},{0,1,1,1,191,55},{0,1,1,1,191,56},{0,1,1,1,191,57},{0,1,1,1,191,61},{0,1,1,1,191,65},{0,1,1,1,191,95},{0,1,1,1,191,98},{0,1,1,1,191,100},{0,1,1,1,191,102},{0,1,1,1,191,103},{0,1,1,1,191,104},{0,1,1,1,191,108},{0,1,1,1,191,109},{0,1,1,1,191,110},{0,1,1,1,191,112},{0,1,1,1,191,114},{0,1,1,1,191,117},{17,0,0,1,0,191},{18,0,0,1,0,191},{19,0,0,1,0,191},{20,0,0,1,0,191},{21,0,0,1,0,191},{22,0,0,1,0,191},{23,0,0,1,0,191},{24,0,0,1,0,191},{25,0,0,1,0,191},{26,0,0,1,0,191},{27,0,0,1,0,191},{28,0,0,1,0,191},{29,0,0,1,0,191},{30,0,0,1,0,191},{31,0,0,1,0,191},{32,0,0,1,0,191},{33,0,0,1,0,191},{34,1,0,1,0,191},{13,0,1,1,197,48},{14,1,1,1,197,48},{13,0,1,1,197,49},{14,1,1,1,197,49},{13,0,1,1,197,50},{14,1,1,1,197,50},{13,0,1,1,197,97},{14,1,1,1,197,97},{13,0,1,1,197,99},{14,1,1,1,197,99},{13,0,1,1,197,101},{14,1,1,1,197,101},{13,0,1,1,197,105},{14,1,1,1,197,105},{13,0,1,1,197,111},{14,1,1,1,197,111},{13,0,1,1,197,115},{14,1,1,1,197,115},{13,0,1,1,197,116},{14,1,1,1,197,116},{0,1,1,1,197,32},{0,1,1,1,197,37},{0,1,1,1,197,45},{0,1,1,1,197,46},{0,1,1,1,197,47},{0,1,1,1,197,51},{0,1,1,1,197,52},{0,1,1,1,197,53},{0,1,1,1,197,54},{0,1,1,1,197,55},{0,1,1,1,197,56},{0,1,1,1,197,57},{0,1,1,1,197,61},{0,1,1,1,197,65},{0,1,1,1,197,95},{0,1,1,1,197,98},{0,1,1,1,197,100},{0,1,1,1,197,102},{0,1,1,1,197,103},{0,1,1,1,197,104},{0,1,1,1,197,108},{0,1,1,1,197,109},{0,1,1,1,197,110},{0,1,1,1,197,112},{0,1,1,1,197,114},{0,1,1,1,197,117},{17,0,0,1,0,197},{18,0,0,1,0,197},{19,0,0,1,0,197},{20,0,0,1,0,197},{21,0,0,1,0,197},{22,0,0,1,0,197},{23,0,0,1,0,197},{24,0,0,1,0,197},{25,0,0,1,0,197},{26,0,0,1,0,197},{27,0,0,1,0,197},{28,0,0,1,0,197},{29,0,0,1,0,197},{30,0,0,1,0,197},{31,0,0,1,0,197},{32,0,0,1,0,197},{33,0,0,1,0,197},{34,1,0,1,0,197},{13,0,1,1,231,48},{14,1,1,1,231,48},{13,0,1,1,231,49},{14,1,1,1,231,49},{13,0,1,1,231,50},{14,1,1,1,231,50},{13,0,1,1,231,97},{14,1,1,1,231,97},{13,0,1,1,231,99},{14,1,1,1,231,99},{13,0,1,1,231,101},{14,1,1,1,231,101},{13,0,1,1,231,105},{14,1,1,1,231,105},{13,0,1,1,231,111},{14,1,1,1,231,111},{13,0,1,1,231,115},{14,1,1,1,231,115},{13,0,1,1,231,116},{14,1,1,1,231,116},{0,1,1,1,231,32},{0,1,1,1,231,37},{0,1,1,1,231,45},{0,1,1,1,231,46},{0,1,1,1,231,47},{0,1,1,1,231,51},{0,1,1,1,231,52},{0,1,1,1,231,53},{0,1,1,1,231,54},{0,1,1,1,231,55},{0,1,1,1,231,56},{0,1,1,1,231,57},{0,1,1,1,231,61},{0,1,1,1,231,65},{0,1,1,1,231,95},{0,1,1,1,231,98},{0,1,1,1,231,100},{0,1,1,1,231,102},{0,1,1,1,231,103},{0,1,1,1,231,104},{0,1,1,1,231,108},{0,1,1,1,231,109},{0,1,1,1,231,110},{0,1,1,1,231,112},{0,1,1,1,231,114},{0,1,1,1,231,117},{17,0,0,1,0,231},{18,0,0,1,0,231},{19,0,0,1,0,231},{20,0,0,1,0,231},{21,0,0,1,0,231},{22,0,0,1,0,231},{23,0,0,1,0,231},{24,0,0,1,0,231},{25,0,0,1,0,231},{26,0,0,1,0,231},{27,0,0,1,0,231},{28,0,0,1,0,231},{29,0,0,1,0,231},{30,0,0,1,0,231},{31,0,0,1,0,231},{32,0,0,1,0,231},{33,0,0,1,0,231},{34,1,0,1,0,231},{13,0,1,1,239,48},{14,1,1,1,239,48},{13,0,1,1,239,49},{14,1,1,1,239,49},{13,0,1,1,239,50},{14,1,1,1,239,50},{13,0,1,1,239,97},{14,1,1,1,239,97},{13,0,1,1,239,99},{14,1,1,1,239,99},{13,0,1,1,239,101},{14,1,1,1,239,101},{13,0,1,1,239,105},{14,1,1,1,239,105},{13,0,1,1,239,111},{14,1,1,1,239,111},{13,0,1,1,239,115},{14,1,1,1,239,115},{13,0,1,1,239,116},{14,1,1,1,239,116},{0,1,1,1,239,32},{0,1,1,1,239,37},{0,1,1,1,239,45},{0,1,1,1,239,46},{0,1,1,1,239,47},{0,1,1,1,239,51},{0,1,1,1,239,52},{0,1,1,1,239,53},{0,1,1,1,239,54},{0,1,1,1,239,55},{0,1,1,1,239,56},{0,1,1,1,239,57},{0,1,1,1,239,61},{0,1,1,1,239,65},{0,1,1,1,239,95},{0,1,1,1,239,98},{0,1,1,1,239,100},{0,1,1,1,239,102},{0,1,1,1,239,103},{0,1,1,1,239,104},{0,1,1,1,239,108},{0,1,1,1,239,109},{0,1,1,1,239,110},{0,1,1,1,239,112},{0,1,1,1,239,114},{0,1,1,1,239,117},{17,0,0,1,0,239},{18,0,0,1,0,239},{19,0,0,1,0,239},{20,0,0,1,0,239},{21,0,0,1,0,239},{22,0,0,1,0,239},{23,0,0,1,0,239},{24,0,0,1,0,239},{25,0,0,1,0,239},{26,0,0,1,0,239},{27,0,0,1,0,239},{28,0,0,1,0,239},{29,0,0,1,0,239},{30,0,0,1,0,239},{31,0,0,1,0,239},{32,0,0,1,0,239},{33,0,0,1,0,239},{34,1,0,1,0,239},{0,1,1,1,9,48},{0,1,1,1,9,49},{0,1,1,1,9,50},{0,1,1,1,9,97},{0,1,1,1,9,99},{0,1,1,1,9,101},{0,1,1,1,9,105},{0,1,1,1,9,111},{0,1,1,1,9,115},{0,1,1,1,9,116},{35,0,0,1,0,9},{36,0,0,1,0,9},{37,0,0,1,0,9},{38,0,0,1,0,9},{39,0,0,1,0,9},{40,0,0,1,0,9},{41,0,0,1,0,9},{42,0,0,1,0,9},{43,0,0,1,0,9},{44,0,0,1,0,9},{45,0,0,1,0,9},{46,0,0,1,0,9},{47,0,0,1,0,9},{48,0,0,1,0,9},{49,0,0,1,0,9},{50,0,0,1,0,9},{51,0,0,1,0,9},{52,0,0,1,0,9},{53,0,0,1,0,9},{54,0,0,1,0,9},{55,0,0,1,0,9},{56,1,0,1,0,9},{0,1,1,1,142,48},{0,1,1,1,142,49},{0,1,1,1,142,50},{0,1,1,1,142,97},{0,1,1,1,142,99},{0,1,1,1,142,101},{0,1,1,1,142,105},{0,1,1,1,142,111},{0,1,1,1,142,115},{0,1,1,1,142,116},{35,0,0,1,0,142},{36,0,0,1,0,142},{37,0,0,1,0,142},{38,0,0,1,0,142},{39,0,0,1,0,142},{40,0,0,1,0,142},{41,0,0,1,0,142},{42,0,0,1,0,142},{43,0,0,1,0,142},{44,0,0,1,0,142},{45,0,0,1,0,142},{46,0,0,1,0,142},{47,0,0,1,0,142},{48,0,0,1,0,142},{49,0,0,1,0,142},{50,0,0,1,0,142},{51,0,0,1,0,142},{52,0,0,1,0,142},{53,0,0,1,0,142},{54,0,0,1,0,142},{55,0,0,1,0,142},{56,1,0,1,0,142},{0,1,1,1,144,48},{0,1,1,1,144,49},{0,1,1,1,144,50},{0,1,1,1,144,97},{0,1,1,1,144,99},{0,1,1,1,144,101},{0,1,1,1,144,105},{0,1,1,1,144,111},{0,1,1,1,144,115},{0,1,1,1,144,116},{35,0,0,1,0,144},{36,0,0,1,0,144},{37,0,0,1,0,144},{38,0,0,1,0,144},{39,0,0,1,0,144},{40,0,0,1,0,144},{41,0,0,1,0,144},{42,0,0,1,0,144},{43,0,0,1,0,144},{44,0,0,1,0,144},{45,0,0,1,0,144},{46,0,0,1,0,144},{47,0,0,1,0,144},{48,0,0,1,0,144},{49,0,0,1,0,144},{50,0,0,1,0,144},{51,0,0,1,0,144},{52,0,0,1,0,144},{53,0,0,1,0,144},{54,0,0,1,0,144},{55,0,0,1,0,144},{56,1,0,1,0,144},{0,1,1,1,145,48},{0,1,1,1,145,49},{0,1,1,1,145,50},{0,1,1,1,145,97},{0,1,1,1,145,99},{0,1,1,1,145,101},{0,1,1,1,145,105},{0,1,1,1,145,111},{0,1,1,1,145,115},{0,1,1,1,145,116},{35,0,0,1,0,145},{36,0,0,1,0,145},{37,0,0,1,0,145},{38,0,0,1,0,145},{39,0,0,1,0,145},{40,0,0,1,0,145},{41,0,0,1,0,145},{42,0,0,1,0,145},{43,0,0,1,0,145},{44,0,0,1,0,145},{45,0,0,1,0,145},{46,0,0,1,0,145},{47,0,0,1,0,145},{48,0,0,1,0,145},{49,0,0,1,0,145},{50,0,0,1,0,145},{51,0,0,1,0,145},{52,0,0,1,0,145},{53,0,0,1,0,145},{54,0,0,1,0,145},{55,0,0,1,0,145},{56,1,0,1,0,145},{0,1,1,1,148,48},{0,1,1,1,148,49},{0,1,1,1,148,50},{0,1,1,1,148,97},{0,1,1,1,148,99},{0,1,1,1,148,101},{0,1,1,1,148,105},{0,1,1,1,148,111},{0,1,1,1,148,115},{0,1,1,1,148,116},{35,0,0,1,0,148},{36,0,0,1,0,148},{37,0,0,1,0,148},{38,0,0,1,0,148},{39,0,0,1,0,148},{40,0,0,1,0,148},{41,0,0,1,0,148},{42,0,0,1,0,148},{43,0,0,1,0,148},{44,0,0,1,0,148},{45,0,0,1,0,148},{46,0,0,1,0,148},{47,0,0,1,0,148},{48,0,0,1,0,148},{49,0,0,1,0,148},{50,0,0,1,0,148},{51,0,0,1,0,148},{52,0,0,1,0,148},{53,0,0,1,0,148},{54,0,0,1,0,148},{55,0,0,1,0,148},{56,1,0,1,0,148},{0,1,1,1,159,48},{0,1,1,1,159,49},{0,1,1,1,159,50},{0,1,1,1,159,97},{0,1,1,1,159,99},{0,1,1,1,159,101},{0,1,1,1,159,105},{0,1,1,1,159,111},{0,1,1,1,159,115},{0,1,1,1,159,116},{35,0,0,1,0,159},{36,0,0,1,0,159},{37,0,0,1,0,159},{38,0,0,1,0,159},{39,0,0,1,0,159},{40,0,0,1,0,159},{41,0,0,1,0,159},{42,0,0,1,0,159},{43,0,0,1,0,159},{44,0,0,1,0,159},{45,0,0,1,0,159},{46,0,0,1,0,159},{47,0,0,1,0,159},{48,0,0,1,0,159},{49,0,0,1,0,159},{50,0,0,1,0,159},{51,0,0,1,0,159},{52,0,0,1,0,159},{53,0,0,1,0,159},{54,0,0,1,0,159},{55,0,0,1,0,159},{56,1,0,1,0,159},{0,1,1,1,171,48},{0,1,1,1,171,49},{0,1,1,1,171,50},{0,1,1,1,171,97},{0,1,1,1,171,99},{0,1,1,1,171,101},{0,1,1,1,171,105},{0,1,1,1,171,111},{0,1,1,1,171,115},{0,1,1,1,171,116},{35,0,0,1,0,171},{36,0,0,1,0,171},{37,0,0,1,0,171},{38,0,0,1,0,171},{39,0,0,1,0,171},{40,0,0,1,0,171},{41,0,0,1,0,171},{42,0,0,1,0,171},{43,0,0,1,0,171},{44,0,0,1,0,171},{45,0,0,1,0,171},{46,0,0,1,0,171},{47,0,0,1,0,171},{48,0,0,1,0,171},{49,0,0,1,0,171},{50,0,0,1,0,171},{51,0,0,1,0,171},{52,0,0,1,0,171},{53,0,0,1,0,171},{54,0,0,1,0,171},{55,0,0,1,0,171},{56,1,0,1,0,171},{0,1,1,1,206,48},{0,1,1,1,206,49},{0,1,1,1,206,50},{0,1,1,1,206,97},{0,1,1,1,206,99},{0,1,1,1,206,101},{0,1,1,1,206,105},{0,1,1,1,206,111},{0,1,1,1,206,115},{0,1,1,1,206,116},{35,0,0,1,0,206},{36,0,0,1,0,206},{37,0,0,1,0,206},{38,0,0,1,0,206},{39,0,0,1,0,206},{40,0,0,1,0,206},{41,0,0,1,0,206},{42,0,0,1,0,206},{43,0,0,1,0,206},{44,0,0,1,0,206},{45,0,0,1,0,206},{46,0,0,1,0,206},{47,0,0,1,0,206},{48,0,0,1,0,206},{49,0,0,1,0,206},{50,0,0,1,0,206},{51,0,0,1,0,206},{52,0,0,1,0,206},{53,0,0,1,0,206},{54,0,0,1,0,206},{55,0,0,1,0,206},{56,1,0,1,0,206},{0,1,1,1,215,48},{0,1,1,1,215,49},{0,1,1,1,215,50},{0,1,1,1,215,97},{0,1,1,1,215,99},{0,1,1,1,215,101},{0,1,1,1,215,105},{0,1,1,1,215,111},{0,1,1,1,215,115},{0,1,1,1,215,116},{35,0,0,1,0,215},{36,0,0,1,0,215},{37,0,0,1,0,215},{38,0,0,1,0,215},{39,0,0,1,0,215},{40,0,0,1,0,215},{41,0,0,1,0,215},{42,0,0,1,0,215},{43,0,0,1,0,215},{44,0,0,1,0,215},{45,0,0,1,0,215},{46,0,0,1,0,215},{47,0,0,1,0,215},{48,0,0,1,0,215},{49,0,0,1,0,215},{50,0,0,1,0,215},{51,0,0,1,0,215},{52,0,0,1,0,215},{53,0,0,1,0,215},{54,0,0,1,0,215},{55,0,0,1,0,215},{56,1,0,1,0,215},{0,1,1,1,225,48},{0,1,1,1,225,49},{0,1,1,1,225,50},{0,1,1,1,225,97},{0,1,1,1,225,99},{0,1,1,1,225,101},{0,1,1,1,225,105},{0,1,1,1,225,111},{0,1,1,1,225,115},{0,1,1,1,225,116},{35,0,0,1,0,225},{36,0,0,1,0,225},{37,0,0,1,0,225},{38,0,0,1,0,225},{39,0,0,1,0,225},{40,0,0,1,0,225},{41,0,0,1,0,225},{42,0,0,1,0,225},{43,0,0,1,0,225},{44,0,0,1,0,225},{45,0,0,1,0,225},{46,0,0,1,0,225},{47,0,0,1,0,225},{48,0,0,1,0,225},{49,0,0,1,0,225},{50,0,0,1,0,225},{51,0,0,1,0,225},{52,0,0,1,0,225},{53,0,0,1,0,225},{54,0,0,1,0,225},{55,0,0,1,0,225},{56,1,0,1,0,225},{0,1,1,1,236,48},{0,1,1,1,236,49},{0,1,1,1,236,50},{0,1,1,1,236,97},{0,1,1,1,236,99},{0,1,1,1,236,101},{0,1,1,1,236,105},{0,1,1,1,236,111},{0,1,1,1,236,115},{0,1,1,1,236,116},{35,0,0,1,0,236},{36,0,0,1,0,236},{37,0,0,1,0,236},{38,0,0,1,0,236},{39,0,0,1,0,236},{40,0,0,1,0,236},{41,0,0,1,0,236},{42,0,0,1,0,236},{43,0,0,1,0,236},{44,0,0,1,0,236},{45,0,0,1,0,236},{46,0,0,1,0,236},{47,0,0,1,0,236},{48,0,0,1,0,236},{49,0,0,1,0,236},{50,0,0,1,0,236},{51,0,0,1,0,236},{52,0,0,1,0,236},{53,0,0,1,0,236},{54,0,0,1,0,236},{55,0,0,1,0,236},{56,1,0,1,0,236},{0,1,1,1,237,48},{0,1,1,1,237,49},{0,1,1,1,237,50},{0,1,1,1,237,97},{0,1,1,1,237,99},{0,1,1,1,237,101},{0,1,1,1,237,105},{0,1,1,1,237,111},{0,1,1,1,237,115},{0,1,1,1,237,116},{35,0,0,1,0,237},{36,0,0,1,0,237},{37,0,0,1,0,237},{38,0,0,1,0,237},{39,0,0,1,0,237},{40,0,0,1,0,237},{41,0,0,1,0,237},{42,0,0,1,0,237},{43,0,0,1,0,237},{44,0,0,1,0,237},{45,0,0,1,0,237},{46,0,0,1,0,237},{47,0,0,1,0,237},{48,0,0,1,0,237},{49,0,0,1,0,237},{50,0,0,1,0,237},{51,0,0,1,0,237},{52,0,0,1,0,237},{53,0,0,1,0,237},{54,0,0,1,0,237},{55,0,0,1,0,237},{56,1,0,1,0,237},{57,0,0,1,0,199},{58,0,0,1,0,199},{59,0,0,1,0,199},{60,0,0,1,0,199},{61,0,0,1,0,199},{62,0,0,1,0,199},{63,0,0,1,0,199},{64,0,0,1,0,199},{65,0,0,1,0,199},{66,0,0,1,0,199},{67,0,0,1,0,199},{68,0,0,1,0,199},{69,0,0,1,0,199},{70,0,0,1,0,199},{71,0,0,1,0,199},{72,1,0,1,0,199},{57,0,0,1,0,207},{58,0,0,1,0,207},{59,0,0,1,0,207},{60,0,0,1,0,207},{61,0,0,1,0,207},{62,0,0,1,0,207},{63,0,0,1,0,207},{64,0,0,1,0,207},{65,0,0,1,0,207},{66,0,0,1,0,207},{67,0,0,1,0,207},{68,0,0,1,0,207},{69,0,0,1,0,207},{70,0,0,1,0,207},{71,0,0,1,0,207},{72,1,0,1,0,207},{57,0,0,1,0,234},{58,0,0,1,0,234},{59,0,0,1,0,234},{60,0,0,1,0,234},{61,0,0,1,0,234},{62,0,0,1,0,234},{63,0,0,1,0,234},{64,0,0,1,0,234},{65,0,0,1,0,234},{66,0,0,1,0,234},{67,0,0,1,0,234},{68,0,0,1,0,234},{69,0,0,1,0,234},{70,0,0,1,0,234},{71,0,0,1,0,234},{72,1,0,1,0,234},{57,0,0,1,0,235},{58,0,0,1,0,235},{59,0,0,1,0,235},{60,0,0,1,0,235},{61,0,0,1,0,235},{62,0,0,1,0,235},{63,0,0,1,0,235},{64,0,0,1,0,235},{65,0,0,1,0,235},{66,0,0,1,0,235},{67,0,0,1,0,235},{68,0,0,1,0,235},{69,0,0,1,0,235},{70,0,0,1,0,235},{71,0,0,1,0,235},{72,1,0,1,0,235},{1,0,0,1,0,192},{2,0,0,1,0,192},{3,0,0,1,0,192},{4,0,0,1,0,192},{5,0,0,1,0,192},{6,0,0,1,0,192},{7,0,0,1,0,192},{8,1,0,1,0,192},{1,0,0,1,0,193},{2,0,0,1,0,193},{3,0,0,1,0,193},{4,0,0,1,0,193},{5,0,0,1,0,193},{6,0,0,1,0,193},{7,0,0,1,0,193},{8,1,0,1,0,193},{1,0,0,1,0,200},{2,0,0,1,0,200},{3,0,0,1,0,200},{4,0,0,1,0,200},{5,0,0,1,0,200},{6,0,0,1,0,200},{7,0,0,1,0,200},{8,1,0,1,0,200},{1,0,0,1,0,201},{2,0,0,1,0,201},{3,0,0,1,0,201},{4,0,0,1,0,201},{5,0,0,1,0,201},{6,0,0,1,0,201},{7,0,0,1,0,201},{8,1,0,1,0,201},{1,0,0,1,0,202},{2,0,0,1,0,202},{3,0,0,1,0,202},{4,0,0,1,0,202},{5,0,0,1,0,202},{6,0,0,1,0,202},{7,0,0,1,0,202},{8,1,0,1,0,202},{1,0,0,1,0,205},{2,0,0,1,0,205},{3,0,0,1,0,205},{4,0,0,1,0,205},{5,0,0,1,0,205},{6,0,0,1,0,205},{7,0,0,1,0,205},{8,1,0,1,0,205},{1,0,0,1,0,210},{2,0,0,1,0,210},{3,0,0,1,0,210},{4,0,0,1,0,210},{5,0,0,1,0,210},{6,0,0,1,0,210},{7,0,0,1,0,210},{8,1,0,1,0,210},{1,0,0,1,0,213},{2,0,0,1,0,213},{3,0,0,1,0,213},{4,0,0,1,0,213},{5,0,0,1,0,213},{6,0,0,1,0,213},{7,0,0,1,0,213},{8,1,0,1,0,213},{1,0,0,1,0,218},{2,0,0,1,0,218},{3,0,0,1,0,218},{4,0,0,1,0,218},{5,0,0,1,0,218},{6,0,0,1,0,218},{7,0,0,1,0,218},{8,1,0,1,0,218},{1,0,0,1,0,219},{2,0,0,1,0,219},{3,0,0,1,0,219},{4,0,0,1,0,219},{5,0,0,1,0,219},{6,0,0,1,0,219},{7,0,0,1,0,219},{8,1,0,1,0,219},{1,0,0,1,0,238},{2,0,0,1,0,238},{3,0,0,1,0,238},{4,0,0,1,0,238},{5,0,0,1,0,238},{6,0,0,1,0,238},{7,0,0,1,0,238},{8,1,0,1,0,238},{1,0,0,1,0,240},{2,0,0,1,0,240},{3,0,0,1,0,240},{4,0,0,1,0,240},{5,0,0,1,0,240},{6,0,0,1,0,240},{7,0,0,1,0,240},{8,1,0,1,0,240},{1,0,0,1,0,242},{2,0,0,1,0,242},{3,0,0,1,0,242},{4,0,0,1,0,242},{5,0,0,1,0,242},{6,0,0,1,0,242},{7,0,0,1,0,242},{8,1,0,1,0,242},{1,0,0,1,0,243},{2,0,0,1,0,243},{3,0,0,1,0,243},{4,0,0,1,0,243},{5,0,0,1,0,243},{6,0,0,1,0,243},{7,0,0,1,0,243},{8,1,0,1,0,243},{1,0,0,1,0,255},{2,0,0,1,0,255},{3,0,0,1,0,255},{4,0,0,1,0,255},{5,0,0,1,0,255},{6,0,0,1,0,255},{7,0,0,1,0,255},{8,1,0,1,0,255},{9,0,0,1,0,203},{10,0,0,1,0,203},{11,0,0,1,0,203},{12,1,0,1,0,203},{9,0,0,1,0,204},{10,0,0,1,0,204},{11,0,0,1,0,204},{12,1,0,1,0,204},{9,0,0,1,0,211},{10,0,0,1,0,211},{11,0,0,1,0,211},{12,1,0,1,0,211},{9,0,0,1,0,212},{10,0,0,1,0,212},{11,0,0,1,0,212},{12,1,0,1,0,212},{9,0,0,1,0,214},{10,0,0,1,0,214},{11,0,0,1,0,214},{12,1,0,1,0,214},{9,0,0,1,0,221},{10,0,0,1,0,221},{11,0,0,1,0,221},{12,1,0,1,0,221},{9,0,0,1,0,222},{10,0,0,1,0,222},{11,0,0,1,0,222},{12,1,0,1,0,222},{9,0,0,1,0,223},{10,0,0,1,0,223},{11,0,0,1,0,223},{12,1,0,1,0,223},{9,0,0,1,0,241},{10,0,0,1,0,241},{11,0,0,1,0,241},{12,1,0,1,0,241},{9,0,0,1,0,244},{10,0,0,1,0,244},{11,0,0,1,0,244},{12,1,0,1,0,244},{9,0,0,1,0,245},{10,0,0,1,0,245},{11,0,0,1,0,245},{12,1,0,1,0,245},{9,0,0,1,0,246},{10,0,0,1,0,246},{11,0,0,1,0,246},{12,1,0,1,0,246},{9,0,0,1,0,247},{10,0,0,1,0,247},{11,0,0,1,0,247},{12,1,0,1,0,247},{9,0,0,1,0,248},{10,0,0,1,0,248},{11,0,0,1,0,248},{12,1,0,1,0,248},{9,0,0,1,0,250},{10,0,0,1,0,250},{11,0,0,1,0,250},{12,1,0,1,0,250},{9,0,0,1,0,251},{10,0,0,1,0,251},{11,0,0,1,0,251},{12,1,0,1,0,251},{9,0,0,1,0,252},{10,0,0,1,0,252},{11,0,0,1,0,252},{12,1,0,1,0,252},{9,0,0,1,0,253},{10,0,0,1,0,253},{11,0,0,1,0,253},{12,1,0,1,0,253},{9,0,0,1,0,254},{10,0,0,1,0,254},{11,0,0,1,0,254},{12,1,0,1,0,254},{13,0,0,1,0,2},{14,1,0,1,0,2},{13,0,0,1,0,3},{14,1,0,1,0,3},{13,0,0,1,0,4},{14,1,0,1,0,4},{13,0,0,1,0,5},{14,1,0,1,0,5},{13,0,0,1,0,6},{14,1,0,1,0,6},{13,0,0,1,0,7},{14,1,0,1,0,7},{13,0,0,1,0,8},{14,1,0,1,0,8},{13,0,0,1,0,11},{14,1,0,1,0,11},{13,0,0,1,0,12},{14,1,0,1,0,12},{13,0,0,1,0,14},{14,1,0,1,0,14},{13,0,0,1,0,15},{14,1,0,1,0,15},{13,0,0,1,0,16},{14,1,0,1,0,16},{13,0,0,1,0,17},{14,1,0,1,0,17},{13,0,0,1,0,18},{14,1,0,1,0,18},{13,0,0,1,0,19},{14,1,0,1,0,19},{13,0,0,1,0,20},{14,1,0,1,0,20},{13,0,0,1,0,21},{14,1,0,1,0,21},{13,0,0,1,0,23},{14,1,0,1,0,23},{13,0,0,1,0,24},{14,1,0,1,0,24},{13,0,0,1,0,25},{14,1,0,1,0,25},{13,0,0,1,0,26},{14,1,0,1,0,26},{13,0,0,1,0,27},{14,1,0,1,0,27},{13,0,0,1,0,28},{14,1,0,1,0,28},{13,0,0,1,0,29},{14,1,0,1,0,29},{13,0,0,1,0,30},{14,1,0,1,0,30},{13,0,0,1,0,31},{14,1,0,1,0,31},{13,0,0,1,0,127},{14,1,0,1,0,127},{13,0,0,1,0,220},{14,1,0,1,0,220},{13,0,0,1,0,249},{14,1,0,1,0,249},{254,0,0,0,0,0},{255,0,0,0,0,0},{9,0,1,1,153,48},{10,0,1,1,153,48},{11,0,1,1,153,48},{12,1,1,1,153,48},{9,0,1,1,153,49},{10,0,1,1,153,49},{11,0,1,1,153,49},{12,1,1,1,153,49},{9,0,1,1,153,50},{10,0,1,1,153,50},{11,0,1,1,153,50},{12,1,1,1,153,50},{9,0,1,1,153,97},{10,0,1,1,153,97},{11,0,1,1,153,97},{12,1,1,1,153,97},{9,0,1,1,153,99},{10,0,1,1,153,99},{11,0,1,1,153,99},{12,1,1,1,153,99},{9,0,1,1,153,101},{10,0,1,1,153,101},{11,0,1,1,153,101},{12,1,1,1,153,101},{9,0,1,1,153,105},{10,0,1,1,153,105},{11,0,1,1,153,105},{12,1,1,1,153,105},{9,0,1,1,153,111},{10,0,1,1,153,111},{11,0,1,1,153,111},{12,1,1,1,153,111},{9,0,1,1,153,115},{10,0,1,1,153,115},{11,0,1,1,153,115},{12,1,1,1,153,115},{9,0,1,1,153,116},{10,0,1,1,153,116},{11,0,1,1,153,116},{12,1,1,1,153,116},{13,0,1,1,153,32},{14,1,1,1,153,32},{13,0,1,1,153,37},{14,1,1,1,153,37},{13,0,1,1,153,45},{14,1,1,1,153,45},{13,0,1,1,153,46},{14,1,1,1,153,46},{13,0,1,1,153,47},{14,1,1,1,153,47},{13,0,1,1,153,51},{14,1,1,1,153,51},{13,0,1,1,153,52},{14,1,1,1,153,52},{13,0,1,1,153,53},{14,1,1,1,153,53},{13,0,1,1,153,54},{14,1,1,1,153,54},{13,0,1,1,153,55},{14,1,1,1,153,55},{13,0,1,1,153,56},{14,1,1,1,153,56},{13,0,1,1,153,57},{14,1,1,1,153,57},{13,0,1,1,153,61},{14,1,1,1,153,61},{13,0,1,1,153,65},{14,1,1,1,153,65},{13,0,1,1,153,95},{14,1,1,1,153,95},{13,0,1,1,153,98},{14,1,1,1,153,98},{13,0,1,1,153,100},{14,1,1,1,153,100},{13,0,1,1,153,102},{14,1,1,1,153,102},{13,0,1,1,153,103},{14,1,1,1,153,103},{13,0,1,1,153,104},{14,1,1,1,153,104},{13,0,1,1,153,108},{14,1,1,1,153,108},{13,0,1,1,153,109},{14,1,1,1,153,109},{13,0,1,1,153,110},{14,1,1,1,153,110},{13,0,1,1,153,112},{14,1,1,1,153,112},{13,0,1,1,153,114},{14,1,1,1,153,114},{13,0,1,1,153,117},{14,1,1,1,153,117},{0,1,1,1,153,58},{0,1,1,1,153,66},{0,1,1,1,153,67},{0,1,1,1,153,68},{0,1,1,1,153,69},{0,1,1,1,153,70},{0,1,1,1,153,71},{0,1,1,1,153,72},{0,1,1,1,153,73},{0,1,1,1,153,74},{0,1,1,1,153,75},{0,1,1,1,153,76},{0,1,1,1,153,77},{0,1,1,1,153,78},{0,1,1,1,153,79},{0,1,1,1,153,80},{0,1,1,1,153,81},{0,1,1,1,153,82},{0,1,1,1,153,83},{0,1,1,1,153,84},{0,1,1,1,153,85},{0,1,1,1,153,86},{0,1,1,1,153,87},{0,1,1,1,153,89},{0,1,1,1,153,106},{0,1,1,1,153,107},{0,1,1,1,153,113},{0,1,1,1,153,118},{0,1,1,1,153,119},{0,1,1,1,153,120},{0,1,1,1,153,121},{0,1,1,1,153,122},{85,0,0,1,0,153},{86,0,0,1,0,153},{87,0,0,1,0,153},{88,1,0,1,0,153},{9,0,1,1,161,48},{10,0,1,1,161,48},{11,0,1,1,161,48},{12,1,1,1,161,48},{9,0,1,1,161,49},{10,0,1,1,161,49},{11,0,1,1,161,49},{12,1,1,1,161,49},{9,0,1,1,161,50},{10,0,1,1,161,50},{11,0,1,1,161,50},{12,1,1,1,161,50},{9,0,1,1,161,97},{10,0,1,1,161,97},{11,0,1,1,161,97},{12,1,1,1,161,97},{9,0,1,1,161,99},{10,0,1,1,161,99},{11,0,1,1,161,99},{12,1,1,1,161,99},{9,0,1,1,161,101},{10,0,1,1,161,101},{11,0,1,1,161,101},{12,1,1,1,161,101},{9,0,1,1,161,105},{10,0,1,1,161,105},{11,0,1,1,161,105},{12,1,1,1,161,105},{9,0,1,1,161,111},{10,0,1,1,161,111},{11,0,1,1,161,111},{12,1,1,1,161,111},{9,0,1,1,161,115},{10,0,1,1,161,115},{11,0,1,1,161,115},{12,1,1,1,161,115},{9,0,1,1,161,116},{10,0,1,1,161,116},{11,0,1,1,161,116},{12,1,1,1,161,116},{13,0,1,1,161,32},{14,1,1,1,161,32},{13,0,1,1,161,37},{14,1,1,1,161,37},{13,0,1,1,161,45},{14,1,1,1,161,45},{13,0,1,1,161,46},{14,1,1,1,161,46},{13,0,1,1,161,47},{14,1,1,1,161,47},{13,0,1,1,161,51},{14,1,1,1,161,51},{13,0,1,1,161,52},{14,1,1,1,161,52},{13,0,1,1,161,53},{14,1,1,1,161,53},{13,0,1,1,161,54},{14,1,1,1,161,54},{13,0,1,1,161,55},{14,1,1,1,161,55},{13,0,1,1,161,56},{14,1,1,1,161,56},{13,0,1,1,161,57},{14,1,1,1,161,57},{13,0,1,1,161,61},{14,1,1,1,161,61},{13,0,1,1,161,65},{14,1,1,1,161,65},{13,0,1,1,161,95},{14,1,1,1,161,95},{13,0,1,1,161,98},{14,1,1,1,161,98},{13,0,1,1,161,100},{14,1,1,1,161,100},{13,0,1,1,161,102},{14,1,1,1,161,102},{13,0,1,1,161,103},{14,1,1,1,161,103},{13,0,1,1,161,104},{14,1,1,1,161,104},{13,0,1,1,161,108},{14,1,1,1,161,108},{13,0,1,1,161,109},{14,1,1,1,161,109},{13,0,1,1,161,110},{14,1,1,1,161,110},{13,0,1,1,161,112},{14,1,1,1,161,112},{13,0,1,1,161,114},{14,1,1,1,161,114},{13,0,1,1,161,117},{14,1,1,1,161,117},{0,1,1,1,161,58},{0,1,1,1,161,66},{0,1,1,1,161,67},{0,1,1,1,161,68},{0,1,1,1,161,69},{0,1,1,1,161,70},{0,1,1,1,161,71},{0,1,1,1,161,72},{0,1,1,1,161,73},{0,1,1,1,161,74},{0,1,1,1,161,75},{0,1,1,1,161,76},{0,1,1,1,161,77},{0,1,1,1,161,78},{0,1,1,1,161,79},{0,1,1,1,161,80},{0,1,1,1,161,81},{0,1,1,1,161,82},{0,1,1,1,161,83},{0,1,1,1,161,84},{0,1,1,1,161,85},{0,1,1,1,161,86},{0,1,1,1,161,87},{0,1,1,1,161,89},{0,1,1,1,161,106},{0,1,1,1,161,107},{0,1,1,1,161,113},{0,1,1,1,161,118},{0,1,1,1,161,119},{0,1,1,1,161,120},{0,1,1,1,161,121},{0,1,1,1,161,122},{85,0,0,1,0,161},{86,0,0,1,0,161},{87,0,0,1,0,161},{88,1,0,1,0,161},{9,0,1,1,167,48},{10,0,1,1,167,48},{11,0,1,1,167,48},{12,1,1,1,167,48},{9,0,1,1,167,49},{10,0,1,1,167,49},{11,0,1,1,167,49},{12,1,1,1,167,49},{9,0,1,1,167,50},{10,0,1,1,167,50},{11,0,1,1,167,50},{12,1,1,1,167,50},{9,0,1,1,167,97},{10,0,1,1,167,97},{11,0,1,1,167,97},{12,1,1,1,167,97},{9,0,1,1,167,99},{10,0,1,1,167,99},{11,0,1,1,167,99},{12,1,1,1,167,99},{9,0,1,1,167,101},{10,0,1,1,167,101},{11,0,1,1,167,101},{12,1,1,1,167,101},{9,0,1,1,167,105},{10,0,1,1,167,105},{11,0,1,1,167,105},{12,1,1,1,167,105},{9,0,1,1,167,111},{10,0,1,1,167,111},{11,0,1,1,167,111},{12,1,1,1,167,111},{9,0,1,1,167,115},{10,0,1,1,167,115},{11,0,1,1,167,115},{12,1,1,1,167,115},{9,0,1,1,167,116},{10,0,1,1,167,116},{11,0,1,1,167,116},{12,1,1,1,167,116},{13,0,1,1,167,32},{14,1,1,1,167,32},{13,0,1,1,167,37},{14,1,1,1,167,37},{13,0,1,1,167,45},{14,1,1,1,167,45},{13,0,1,1,167,46},{14,1,1,1,167,46},{13,0,1,1,167,47},{14,1,1,1,167,47},{13,0,1,1,167,51},{14,1,1,1,167,51},{13,0,1,1,167,52},{14,1,1,1,167,52},{13,0,1,1,167,53},{14,1,1,1,167,53},{13,0,1,1,167,54},{14,1,1,1,167,54},{13,0,1,1,167,55},{14,1,1,1,167,55},{13,0,1,1,167,56},{14,1,1,1,167,56},{13,0,1,1,167,57},{14,1,1,1,167,57},{13,0,1,1,167,61},{14,1,1,1,167,61},{13,0,1,1,167,65},{14,1,1,1,167,65},{13,0,1,1,167,95},{14,1,1,1,167,95},{13,0,1,1,167,98},{14,1,1,1,167,98},{13,0,1,1,167,100},{14,1,1,1,167,100},{13,0,1,1,167,102},{14,1,1,1,167,102},{13,0,1,1,167,103},{14,1,1,1,167,103},{13,0,1,1,167,104},{14,1,1,1,167,104},{13,0,1,1,167,108},{14,1,1,1,167,108},{13,0,1,1,167,109},{14,1,1,1,167,109},{13,0,1,1,167,110},{14,1,1,1,167,110},{13,0,1,1,167,112},{14,1,1,1,167,112},{13,0,1,1,167,114},{14,1,1,1,167,114},{13,0,1,1,167,117},{14,1,1,1,167,117},{0,1,1,1,167,58},{0,1,1,1,167,66},{0,1,1,1,167,67},{0,1,1,1,167,68},{0,1,1,1,167,69},{0,1,1,1,167,70},{0,1,1,1,167,71},{0,1,1,1,167,72},{0,1,1,1,167,73},{0,1,1,1,167,74},{0,1,1,1,167,75},{0,1,1,1,167,76},{0,1,1,1,167,77},{0,1,1,1,167,78},{0,1,1,1,167,79},{0,1,1,1,167,80},{0,1,1,1,167,81},{0,1,1,1,167,82},{0,1,1,1,167,83},{0,1,1,1,167,84},{0,1,1,1,167,85},{0,1,1,1,167,86},{0,1,1,1,167,87},{0,1,1,1,167,89},{0,1,1,1,167,106},{0,1,1,1,167,107},{0,1,1,1,167,113},{0,1,1,1,167,118},{0,1,1,1,167,119},{0,1,1,1,167,120},{0,1,1,1,167,121},{0,1,1,1,167,122},{85,0,0,1,0,167},{86,0,0,1,0,167},{87,0,0,1,0,167},{88,1,0,1,0,167},{9,0,1,1,172,48},{10,0,1,1,172,48},{11,0,1,1,172,48},{12,1,1,1,172,48},{9,0,1,1,172,49},{10,0,1,1,172,49},{11,0,1,1,172,49},{12,1,1,1,172,49},{9,0,1,1,172,50},{10,0,1,1,172,50},{11,0,1,1,172,50},{12,1,1,1,172,50},{9,0,1,1,172,97},{10,0,1,1,172,97},{11,0,1,1,172,97},{12,1,1,1,172,97},{9,0,1,1,172,99},{10,0,1,1,172,99},{11,0,1,1,172,99},{12,1,1,1,172,99},{9,0,1,1,172,101},{10,0,1,1,172,101},{11,0,1,1,172,101},{12,1,1,1,172,101},{9,0,1,1,172,105},{10,0,1,1,172,105},{11,0,1,1,172,105},{12,1,1,1,172,105},{9,0,1,1,172,111},{10,0,1,1,172,111},{11,0,1,1,172,111},{12,1,1,1,172,111},{9,0,1,1,172,115},{10,0,1,1,172,115},{11,0,1,1,172,115},{12,1,1,1,172,115},{9,0,1,1,172,116},{10,0,1,1,172,116},{11,0,1,1,172,116},{12,1,1,1,172,116},{13,0,1,1,172,32},{14,1,1,1,172,32},{13,0,1,1,172,37},{14,1,1,1,172,37},{13,0,1,1,172,45},{14,1,1,1,172,45},{13,0,1,1,172,46},{14,1,1,1,172,46},{13,0,1,1,172,47},{14,1,1,1,172,47},{13,0,1,1,172,51},{14,1,1,1,172,51},{13,0,1,1,172,52},{14,1,1,1,172,52},{13,0,1,1,172,53},{14,1,1,1,172,53},{13,0,1,1,172,54},{14,1,1,1,172,54},{13,0,1,1,172,55},{14,1,1,1,172,55},{13,0,1,1,172,56},{14,1,1,1,172,56},{13,0,1,1,172,57},{14,1,1,1,172,57},{13,0,1,1,172,61},{14,1,1,1,172,61},{13,0,1,1,172,65},{14,1,1,1,172,65},{13,0,1,1,172,95},{14,1,1,1,172,95},{13,0,1,1,172,98},{14,1,1,1,172,98},{13,0,1,1,172,100},{14,1,1,1,172,100},{13,0,1,1,172,102},{14,1,1,1,172,102},{13,0,1,1,172,103},{14,1,1,1,172,103},{13,0,1,1,172,104},{14,1,1,1,172,104},{13,0,1,1,172,108},{14,1,1,1,172,108},{13,0,1,1,172,109},{14,1,1,1,172,109},{13,0,1,1,172,110},{14,1,1,1,172,110},{13,0,1,1,172,112},{14,1,1,1,172,112},{13,0,1,1,172,114},{14,1,1,1,172,114},{13,0,1,1,172,117},{14,1,1,1,172,117},{0,1,1,1,172,58},{0,1,1,1,172,66},{0,1,1,1,172,67},{0,1,1,1,172,68},{0,1,1,1,172,69},{0,1,1,1,172,70},{0,1,1,1,172,71},{0,1,1,1,172,72},{0,1,1,1,172,73},{0,1,1,1,172,74},{0,1,1,1,172,75},{0,1,1,1,172,76},{0,1,1,1,172,77},{0,1,1,1,172,78},{0,1,1,1,172,79},{0,1,1,1,172,80},{0,1,1,1,172,81},{0,1,1,1,172,82},{0,1,1,1,172,83},{0,1,1,1,172,84},{0,1,1,1,172,85},{0,1,1,1,172,86},{0,1,1,1,172,87},{0,1,1,1,172,89},{0,1,1,1,172,106},{0,1,1,1,172,107},{0,1,1,1,172,113},{0,1,1,1,172,118},{0,1,1,1,172,119},{0,1,1,1,172,120},{0,1,1,1,172,121},{0,1,1,1,172,122},{85,0,0,1,0,172},{86,0,0,1,0,172},{87,0,0,1,0,172},{88,1,0,1,0,172},{9,0,1,1,176,48},{10,0,1,1,176,48},{11,0,1,1,176,48},{12,1,1,1,176,48},{9,0,1,1,176,49},{10,0,1,1,176,49},{11,0,1,1,176,49},{12,1,1,1,176,49},{9,0,1,1,176,50},{10,0,1,1,176,50},{11,0,1,1,176,50},{12,1,1,1,176,50},{9,0,1,1,176,97},{10,0,1,1,176,97},{11,0,1,1,176,97},{12,1,1,1,176,97},{9,0,1,1,176,99},{10,0,1,1,176,99},{11,0,1,1,176,99},{12,1,1,1,176,99},{9,0,1,1,176,101},{10,0,1,1,176,101},{11,0,1,1,176,101},{12,1,1,1,176,101},{9,0,1,1,176,105},{10,0,1,1,176,105},{11,0,1,1,176,105},{12,1,1,1,176,105},{9,0,1,1,176,111},{10,0,1,1,176,111},{11,0,1,1,176,111},{12,1,1,1,176,111},{9,0,1,1,176,115},{10,0,1,1,176,115},{11,0,1,1,176,115},{12,1,1,1,176,115},{9,0,1,1,176,116},{10,0,1,1,176,116},{11,0,1,1,176,116},{12,1,1,1,176,116},{13,0,1,1,176,32},{14,1,1,1,176,32},{13,0,1,1,176,37},{14,1,1,1,176,37},{13,0,1,1,176,45},{14,1,1,1,176,45},{13,0,1,1,176,46},{14,1,1,1,176,46},{13,0,1,1,176,47},{14,1,1,1,176,47},{13,0,1,1,176,51},{14,1,1,1,176,51},{13,0,1,1,176,52},{14,1,1,1,176,52},{13,0,1,1,176,53},{14,1,1,1,176,53},{13,0,1,1,176,54},{14,1,1,1,176,54},{13,0,1,1,176,55},{14,1,1,1,176,55},{13,0,1,1,176,56},{14,1,1,1,176,56},{13,0,1,1,176,57},{14,1,1,1,176,57},{13,0,1,1,176,61},{14,1,1,1,176,61},{13,0,1,1,176,65},{14,1,1,1,176,65},{13,0,1,1,176,95},{14,1,1,1,176,95},{13,0,1,1,176,98},{14,1,1,1,176,98},{13,0,1,1,176,100},{14,1,1,1,176,100},{13,0,1,1,176,102},{14,1,1,1,176,102},{13,0,1,1,176,103},{14,1,1,1,176,103},{13,0,1,1,176,104},{14,1,1,1,176,104},{13,0,1,1,176,108},{14,1,1,1,176,108},{13,0,1,1,176,109},{14,1,1,1,176,109},{13,0,1,1,176,110},{14,1,1,1,176,110},{13,0,1,1,176,112},{14,1,1,1,176,112},{13,0,1,1,176,114},{14,1,1,1,176,114},{13,0,1,1,176,117},{14,1,1,1,176,117},{0,1,1,1,176,58},{0,1,1,1,176,66},{0,1,1,1,176,67},{0,1,1,1,176,68},{0,1,1,1,176,69},{0,1,1,1,176,70},{0,1,1,1,176,71},{0,1,1,1,176,72},{0,1,1,1,176,73},{0,1,1,1,176,74},{0,1,1,1,176,75},{0,1,1,1,176,76},{0,1,1,1,176,77},{0,1,1,1,176,78},{0,1,1,1,176,79},{0,1,1,1,176,80},{0,1,1,1,176,81},{0,1,1,1,176,82},{0,1,1,1,176,83},{0,1,1,1,176,84},{0,1,1,1,176,85},{0,1,1,1,176,86},{0,1,1,1,176,87},{0,1,1,1,176,89},{0,1,1,1,176,106},{0,1,1,1,176,107},{0,1,1,1,176,113},{0,1,1,1,176,118},{0,1,1,1,176,119},{0,1,1,1,176,120},{0,1,1,1,176,121},{0,1,1,1,176,122},{85,0,0,1,0,176},{86,0,0,1,0,176},{87,0,0,1,0,176},{88,1,0,1,0,176},{9,0,1,1,177,48},{10,0,1,1,177,48},{11,0,1,1,177,48},{12,1,1,1,177,48},{9,0,1,1,177,49},{10,0,1,1,177,49},{11,0,1,1,177,49},{12,1,1,1,177,49},{9,0,1,1,177,50},{10,0,1,1,177,50},{11,0,1,1,177,50},{12,1,1,1,177,50},{9,0,1,1,177,97},{10,0,1,1,177,97},{11,0,1,1,177,97},{12,1,1,1,177,97},{9,0,1,1,177,99},{10,0,1,1,177,99},{11,0,1,1,177,99},{12,1,1,1,177,99},{9,0,1,1,177,101},{10,0,1,1,177,101},{11,0,1,1,177,101},{12,1,1,1,177,101},{9,0,1,1,177,105},{10,0,1,1,177,105},{11,0,1,1,177,105},{12,1,1,1,177,105},{9,0,1,1,177,111},{10,0,1,1,177,111},{11,0,1,1,177,111},{12,1,1,1,177,111},{9,0,1,1,177,115},{10,0,1,1,177,115},{11,0,1,1,177,115},{12,1,1,1,177,115},{9,0,1,1,177,116},{10,0,1,1,177,116},{11,0,1,1,177,116},{12,1,1,1,177,116},{13,0,1,1,177,32},{14,1,1,1,177,32},{13,0,1,1,177,37},{14,1,1,1,177,37},{13,0,1,1,177,45},{14,1,1,1,177,45},{13,0,1,1,177,46},{14,1,1,1,177,46},{13,0,1,1,177,47},{14,1,1,1,177,47},{13,0,1,1,177,51},{14,1,1,1,177,51},{13,0,1,1,177,52},{14,1,1,1,177,52},{13,0,1,1,177,53},{14,1,1,1,177,53},{13,0,1,1,177,54},{14,1,1,1,177,54},{13,0,1,1,177,55},{14,1,1,1,177,55},{13,0,1,1,177,56},{14,1,1,1,177,56},{13,0,1,1,177,57},{14,1,1,1,177,57},{13,0,1,1,177,61},{14,1,1,1,177,61},{13,0,1,1,177,65},{14,1,1,1,177,65},{13,0,1,1,177,95},{14,1,1,1,177,95},{13,0,1,1,177,98},{14,1,1,1,177,98},{13,0,1,1,177,100},{14,1,1,1,177,100},{13,0,1,1,177,102},{14,1,1,1,177,102},{13,0,1,1,177,103},{14,1,1,1,177,103},{13,0,1,1,177,104},{14,1,1,1,177,104},{13,0,1,1,177,108},{14,1,1,1,177,108},{13,0,1,1,177,109},{14,1,1,1,177,109},{13,0,1,1,177,110},{14,1,1,1,177,110},{13,0,1,1,177,112},{14,1,1,1,177,112},{13,0,1,1,177,114},{14,1,1,1,177,114},{13,0,1,1,177,117},{14,1,1,1,177,117},{0,1,1,1,177,58},{0,1,1,1,177,66},{0,1,1,1,177,67},{0,1,1,1,177,68},{0,1,1,1,177,69},{0,1,1,1,177,70},{0,1,1,1,177,71},{0,1,1,1,177,72},{0,1,1,1,177,73},{0,1,1,1,177,74},{0,1,1,1,177,75},{0,1,1,1,177,76},{0,1,1,1,177,77},{0,1,1,1,177,78},{0,1,1,1,177,79},{0,1,1,1,177,80},{0,1,1,1,177,81},{0,1,1,1,177,82},{0,1,1,1,177,83},{0,1,1,1,177,84},{0,1,1,1,177,85},{0,1,1,1,177,86},{0,1,1,1,177,87},{0,1,1,1,177,89},{0,1,1,1,177,106},{0,1,1,1,177,107},{0,1,1,1,177,113},{0,1,1,1,177,118},{0,1,1,1,177,119},{0,1,1,1,177,120},{0,1,1,1,177,121},{0,1,1,1,177,122},{85,0,0,1,0,177},{86,0,0,1,0,177},{87,0,0,1,0,177},{88,1,0,1,0,177},{9,0,1,1,179,48},{10,0,1,1,179,48},{11,0,1,1,179,48},{12,1,1,1,179,48},{9,0,1,1,179,49},{10,0,1,1,179,49},{11,0,1,1,179,49},{12,1,1,1,179,49},{9,0,1,1,179,50},{10,0,1,1,179,50},{11,0,1,1,179,50},{12,1,1,1,179,50},{9,0,1,1,179,97},{10,0,1,1,179,97},{11,0,1,1,179,97},{12,1,1,1,179,97},{9,0,1,1,179,99},{10,0,1,1,179,99},{11,0,1,1,179,99},{12,1,1,1,179,99},{9,0,1,1,179,101},{10,0,1,1,179,101},{11,0,1,1,179,101},{12,1,1,1,179,101},{9,0,1,1,179,105},{10,0,1,1,179,105},{11,0,1,1,179,105},{12,1,1,1,179,105},{9,0,1,1,179,111},{10,0,1,1,179,111},{11,0,1,1,179,111},{12,1,1,1,179,111},{9,0,1,1,179,115},{10,0,1,1,179,115},{11,0,1,1,179,115},{12,1,1,1,179,115},{9,0,1,1,179,116},{10,0,1,1,179,116},{11,0,1,1,179,116},{12,1,1,1,179,116},{13,0,1,1,179,32},{14,1,1,1,179,32},{13,0,1,1,179,37},{14,1,1,1,179,37},{13,0,1,1,179,45},{14,1,1,1,179,45},{13,0,1,1,179,46},{14,1,1,1,179,46},{13,0,1,1,179,47},{14,1,1,1,179,47},{13,0,1,1,179,51},{14,1,1,1,179,51},{13,0,1,1,179,52},{14,1,1,1,179,52},{13,0,1,1,179,53},{14,1,1,1,179,53},{13,0,1,1,179,54},{14,1,1,1,179,54},{13,0,1,1,179,55},{14,1,1,1,179,55},{13,0,1,1,179,56},{14,1,1,1,179,56},{13,0,1,1,179,57},{14,1,1,1,179,57},{13,0,1,1,179,61},{14,1,1,1,179,61},{13,0,1,1,179,65},{14,1,1,1,179,65},{13,0,1,1,179,95},{14,1,1,1,179,95},{13,0,1,1,179,98},{14,1,1,1,179,98},{13,0,1,1,179,100},{14,1,1,1,179,100},{13,0,1,1,179,102},{14,1,1,1,179,102},{13,0,1,1,179,103},{14,1,1,1,179,103},{13,0,1,1,179,104},{14,1,1,1,179,104},{13,0,1,1,179,108},{14,1,1,1,179,108},{13,0,1,1,179,109},{14,1,1,1,179,109},{13,0,1,1,179,110},{14,1,1,1,179,110},{13,0,1,1,179,112},{14,1,1,1,179,112},{13,0,1,1,179,114},{14,1,1,1,179,114},{13,0,1,1,179,117},{14,1,1,1,179,117},{0,1,1,1,179,58},{0,1,1,1,179,66},{0,1,1,1,179,67},{0,1,1,1,179,68},{0,1,1,1,179,69},{0,1,1,1,179,70},{0,1,1,1,179,71},{0,1,1,1,179,72},{0,1,1,1,179,73},{0,1,1,1,179,74},{0,1,1,1,179,75},{0,1,1,1,179,76},{0,1,1,1,179,77},{0,1,1,1,179,78},{0,1,1,1,179,79},{0,1,1,1,179,80},{0,1,1,1,179,81},{0,1,1,1,179,82},{0,1,1,1,179,83},{0,1,1,1,179,84},{0,1,1,1,179,85},{0,1,1,1,179,86},{0,1,1,1,179,87},{0,1,1,1,179,89},{0,1,1,1,179,106},{0,1,1,1,179,107},{0,1,1,1,179,113},{0,1,1,1,179,118},{0,1,1,1,179,119},{0,1,1,1,179,120},{0,1,1,1,179,121},{0,1,1,1,179,122},{85,0,0,1,0,179},{86,0,0,1,0,179},{87,0,0,1,0,179},{88,1,0,1,0,179},{9,0,1,1,209,48},{10,0,1,1,209,48},{11,0,1,1,209,48},{12,1,1,1,209,48},{9,0,1,1,209,49},{10,0,1,1,209,49},{11,0,1,1,209,49},{12,1,1,1,209,49},{9,0,1,1,209,50},{10,0,1,1,209,50},{11,0,1,1,209,50},{12,1,1,1,209,50},{9,0,1,1,209,97},{10,0,1,1,209,97},{11,0,1,1,209,97},{12,1,1,1,209,97},{9,0,1,1,209,99},{10,0,1,1,209,99},{11,0,1,1,209,99},{12,1,1,1,209,99},{9,0,1,1,209,101},{10,0,1,1,209,101},{11,0,1,1,209,101},{12,1,1,1,209,101},{9,0,1,1,209,105},{10,0,1,1,209,105},{11,0,1,1,209,105},{12,1,1,1,209,105},{9,0,1,1,209,111},{10,0,1,1,209,111},{11,0,1,1,209,111},{12,1,1,1,209,111},{9,0,1,1,209,115},{10,0,1,1,209,115},{11,0,1,1,209,115},{12,1,1,1,209,115},{9,0,1,1,209,116},{10,0,1,1,209,116},{11,0,1,1,209,116},{12,1,1,1,209,116},{13,0,1,1,209,32},{14,1,1,1,209,32},{13,0,1,1,209,37},{14,1,1,1,209,37},{13,0,1,1,209,45},{14,1,1,1,209,45},{13,0,1,1,209,46},{14,1,1,1,209,46},{13,0,1,1,209,47},{14,1,1,1,209,47},{13,0,1,1,209,51},{14,1,1,1,209,51},{13,0,1,1,209,52},{14,1,1,1,209,52},{13,0,1,1,209,53},{14,1,1,1,209,53},{13,0,1,1,209,54},{14,1,1,1,209,54},{13,0,1,1,209,55},{14,1,1,1,209,55},{13,0,1,1,209,56},{14,1,1,1,209,56},{13,0,1,1,209,57},{14,1,1,1,209,57},{13,0,1,1,209,61},{14,1,1,1,209,61},{13,0,1,1,209,65},{14,1,1,1,209,65},{13,0,1,1,209,95},{14,1,1,1,209,95},{13,0,1,1,209,98},{14,1,1,1,209,98},{13,0,1,1,209,100},{14,1,1,1,209,100},{13,0,1,1,209,102},{14,1,1,1,209,102},{13,0,1,1,209,103},{14,1,1,1,209,103},{13,0,1,1,209,104},{14,1,1,1,209,104},{13,0,1,1,209,108},{14,1,1,1,209,108},{13,0,1,1,209,109},{14,1,1,1,209,109},{13,0,1,1,209,110},{14,1,1,1,209,110},{13,0,1,1,209,112},{14,1,1,1,209,112},{13,0,1,1,209,114},{14,1,1,1,209,114},{13,0,1,1,209,117},{14,1,1,1,209,117},{0,1,1,1,209,58},{0,1,1,1,209,66},{0,1,1,1,209,67},{0,1,1,1,209,68},{0,1,1,1,209,69},{0,1,1,1,209,70},{0,1,1,1,209,71},{0,1,1,1,209,72},{0,1,1,1,209,73},{0,1,1,1,209,74},{0,1,1,1,209,75},{0,1,1,1,209,76},{0,1,1,1,209,77},{0,1,1,1,209,78},{0,1,1,1,209,79},{0,1,1,1,209,80},{0,1,1,1,209,81},{0,1,1,1,209,82},{0,1,1,1,209,83},{0,1,1,1,209,84},{0,1,1,1,209,85},{0,1,1,1,209,86},{0,1,1,1,209,87},{0,1,1,1,209,89},{0,1,1,1,209,106},{0,1,1,1,209,107},{0,1,1,1,209,113},{0,1,1,1,209,118},{0,1,1,1,209,119},{0,1,1,1,209,120},{0,1,1,1,209,121},{0,1,1,1,209,122},{85,0,0,1,0,209},{86,0,0,1,0,209},{87,0,0,1,0,209},{88,1,0,1,0,209},{9,0,1,1,216,48},{10,0,1,1,216,48},{11,0,1,1,216,48},{12,1,1,1,216,48},{9,0,1,1,216,49},{10,0,1,1,216,49},{11,0,1,1,216,49},{12,1,1,1,216,49},{9,0,1,1,216,50},{10,0,1,1,216,50},{11,0,1,1,216,50},{12,1,1,1,216,50},{9,0,1,1,216,97},{10,0,1,1,216,97},{11,0,1,1,216,97},{12,1,1,1,216,97},{9,0,1,1,216,99},{10,0,1,1,216,99},{11,0,1,1,216,99},{12,1,1,1,216,99},{9,0,1,1,216,101},{10,0,1,1,216,101},{11,0,1,1,216,101},{12,1,1,1,216,101},{9,0,1,1,216,105},{10,0,1,1,216,105},{11,0,1,1,216,105},{12,1,1,1,216,105},{9,0,1,1,216,111},{10,0,1,1,216,111},{11,0,1,1,216,111},{12,1,1,1,216,111},{9,0,1,1,216,115},{10,0,1,1,216,115},{11,0,1,1,216,115},{12,1,1,1,216,115},{9,0,1,1,216,116},{10,0,1,1,216,116},{11,0,1,1,216,116},{12,1,1,1,216,116},{13,0,1,1,216,32},{14,1,1,1,216,32},{13,0,1,1,216,37},{14,1,1,1,216,37},{13,0,1,1,216,45},{14,1,1,1,216,45},{13,0,1,1,216,46},{14,1,1,1,216,46},{13,0,1,1,216,47},{14,1,1,1,216,47},{13,0,1,1,216,51},{14,1,1,1,216,51},{13,0,1,1,216,52},{14,1,1,1,216,52},{13,0,1,1,216,53},{14,1,1,1,216,53},{13,0,1,1,216,54},{14,1,1,1,216,54},{13,0,1,1,216,55},{14,1,1,1,216,55},{13,0,1,1,216,56},{14,1,1,1,216,56},{13,0,1,1,216,57},{14,1,1,1,216,57},{13,0,1,1,216,61},{14,1,1,1,216,61},{13,0,1,1,216,65},{14,1,1,1,216,65},{13,0,1,1,216,95},{14,1,1,1,216,95},{13,0,1,1,216,98},{14,1,1,1,216,98},{13,0,1,1,216,100},{14,1,1,1,216,100},{13,0,1,1,216,102},{14,1,1,1,216,102},{13,0,1,1,216,103},{14,1,1,1,216,103},{13,0,1,1,216,104},{14,1,1,1,216,104},{13,0,1,1,216,108},{14,1,1,1,216,108},{13,0,1,1,216,109},{14,1,1,1,216,109},{13,0,1,1,216,110},{14,1,1,1,216,110},{13,0,1,1,216,112},{14,1,1,1,216,112},{13,0,1,1,216,114},{14,1,1,1,216,114},{13,0,1,1,216,117},{14,1,1,1,216,117},{0,1,1,1,216,58},{0,1,1,1,216,66},{0,1,1,1,216,67},{0,1,1,1,216,68},{0,1,1,1,216,69},{0,1,1,1,216,70},{0,1,1,1,216,71},{0,1,1,1,216,72},{0,1,1,1,216,73},{0,1,1,1,216,74},{0,1,1,1,216,75},{0,1,1,1,216,76},{0,1,1,1,216,77},{0,1,1,1,216,78},{0,1,1,1,216,79},{0,1,1,1,216,80},{0,1,1,1,216,81},{0,1,1,1,216,82},{0,1,1,1,216,83},{0,1,1,1,216,84},{0,1,1,1,216,85},{0,1,1,1,216,86},{0,1,1,1,216,87},{0,1,1,1,216,89},{0,1,1,1,216,106},{0,1,1,1,216,107},{0,1,1,1,216,113},{0,1,1,1,216,118},{0,1,1,1,216,119},{0,1,1,1,216,120},{0,1,1,1,216,121},{0,1,1,1,216,122},{85,0,0,1,0,216},{86,0,0,1,0,216},{87,0,0,1,0,216},{88,1,0,1,0,216},{9,0,1,1,217,48},{10,0,1,1,217,48},{11,0,1,1,217,48},{12,1,1,1,217,48},{9,0,1,1,217,49},{10,0,1,1,217,49},{11,0,1,1,217,49},{12,1,1,1,217,49},{9,0,1,1,217,50},{10,0,1,1,217,50},{11,0,1,1,217,50},{12,1,1,1,217,50},{9,0,1,1,217,97},{10,0,1,1,217,97},{11,0,1,1,217,97},{12,1,1,1,217,97},{9,0,1,1,217,99},{10,0,1,1,217,99},{11,0,1,1,217,99},{12,1,1,1,217,99},{9,0,1,1,217,101},{10,0,1,1,217,101},{11,0,1,1,217,101},{12,1,1,1,217,101},{9,0,1,1,217,105},{10,0,1,1,217,105},{11,0,1,1,217,105},{12,1,1,1,217,105},{9,0,1,1,217,111},{10,0,1,1,217,111},{11,0,1,1,217,111},{12,1,1,1,217,111},{9,0,1,1,217,115},{10,0,1,1,217,115},{11,0,1,1,217,115},{12,1,1,1,217,115},{9,0,1,1,217,116},{10,0,1,1,217,116},{11,0,1,1,217,116},{12,1,1,1,217,116},{13,0,1,1,217,32},{14,1,1,1,217,32},{13,0,1,1,217,37},{14,1,1,1,217,37},{13,0,1,1,217,45},{14,1,1,1,217,45},{13,0,1,1,217,46},{14,1,1,1,217,46},{13,0,1,1,217,47},{14,1,1,1,217,47},{13,0,1,1,217,51},{14,1,1,1,217,51},{13,0,1,1,217,52},{14,1,1,1,217,52},{13,0,1,1,217,53},{14,1,1,1,217,53},{13,0,1,1,217,54},{14,1,1,1,217,54},{13,0,1,1,217,55},{14,1,1,1,217,55},{13,0,1,1,217,56},{14,1,1,1,217,56},{13,0,1,1,217,57},{14,1,1,1,217,57},{13,0,1,1,217,61},{14,1,1,1,217,61},{13,0,1,1,217,65},{14,1,1,1,217,65},{13,0,1,1,217,95},{14,1,1,1,217,95},{13,0,1,1,217,98},{14,1,1,1,217,98},{13,0,1,1,217,100},{14,1,1,1,217,100},{13,0,1,1,217,102},{14,1,1,1,217,102},{13,0,1,1,217,103},{14,1,1,1,217,103},{13,0,1,1,217,104},{14,1,1,1,217,104},{13,0,1,1,217,108},{14,1,1,1,217,108},{13,0,1,1,217,109},{14,1,1,1,217,109},{13,0,1,1,217,110},{14,1,1,1,217,110},{13,0,1,1,217,112},{14,1,1,1,217,112},{13,0,1,1,217,114},{14,1,1,1,217,114},{13,0,1,1,217,117},{14,1,1,1,217,117},{0,1,1,1,217,58},{0,1,1,1,217,66},{0,1,1,1,217,67},{0,1,1,1,217,68},{0,1,1,1,217,69},{0,1,1,1,217,70},{0,1,1,1,217,71},{0,1,1,1,217,72},{0,1,1,1,217,73},{0,1,1,1,217,74},{0,1,1,1,217,75},{0,1,1,1,217,76},{0,1,1,1,217,77},{0,1,1,1,217,78},{0,1,1,1,217,79},{0,1,1,1,217,80},{0,1,1,1,217,81},{0,1,1,1,217,82},{0,1,1,1,217,83},{0,1,1,1,217,84},{0,1,1,1,217,85},{0,1,1,1,217,86},{0,1,1,1,217,87},{0,1,1,1,217,89},{0,1,1,1,217,106},{0,1,1,1,217,107},{0,1,1,1,217,113},{0,1,1,1,217,118},{0,1,1,1,217,119},{0,1,1,1,217,120},{0,1,1,1,217,121},{0,1,1,1,217,122},{85,0,0,1,0,217},{86,0,0,1,0,217},{87,0,0,1,0,217},{88,1,0,1,0,217},{9,0,1,1,227,48},{10,0,1,1,227,48},{11,0,1,1,227,48},{12,1,1,1,227,48},{9,0,1,1,227,49},{10,0,1,1,227,49},{11,0,1,1,227,49},{12,1,1,1,227,49},{9,0,1,1,227,50},{10,0,1,1,227,50},{11,0,1,1,227,50},{12,1,1,1,227,50},{9,0,1,1,227,97},{10,0,1,1,227,97},{11,0,1,1,227,97},{12,1,1,1,227,97},{9,0,1,1,227,99},{10,0,1,1,227,99},{11,0,1,1,227,99},{12,1,1,1,227,99},{9,0,1,1,227,101},{10,0,1,1,227,101},{11,0,1,1,227,101},{12,1,1,1,227,101},{9,0,1,1,227,105},{10,0,1,1,227,105},{11,0,1,1,227,105},{12,1,1,1,227,105},{9,0,1,1,227,111},{10,0,1,1,227,111},{11,0,1,1,227,111},{12,1,1,1,227,111},{9,0,1,1,227,115},{10,0,1,1,227,115},{11,0,1,1,227,115},{12,1,1,1,227,115},{9,0,1,1,227,116},{10,0,1,1,227,116},{11,0,1,1,227,116},{12,1,1,1,227,116},{13,0,1,1,227,32},{14,1,1,1,227,32},{13,0,1,1,227,37},{14,1,1,1,227,37},{13,0,1,1,227,45},{14,1,1,1,227,45},{13,0,1,1,227,46},{14,1,1,1,227,46},{13,0,1,1,227,47},{14,1,1,1,227,47},{13,0,1,1,227,51},{14,1,1,1,227,51},{13,0,1,1,227,52},{14,1,1,1,227,52},{13,0,1,1,227,53},{14,1,1,1,227,53},{13,0,1,1,227,54},{14,1,1,1,227,54},{13,0,1,1,227,55},{14,1,1,1,227,55},{13,0,1,1,227,56},{14,1,1,1,227,56},{13,0,1,1,227,57},{14,1,1,1,227,57},{13,0,1,1,227,61},{14,1,1,1,227,61},{13,0,1,1,227,65},{14,1,1,1,227,65},{13,0,1,1,227,95},{14,1,1,1,227,95},{13,0,1,1,227,98},{14,1,1,1,227,98},{13,0,1,1,227,100},{14,1,1,1,227,100},{13,0,1,1,227,102},{14,1,1,1,227,102},{13,0,1,1,227,103},{14,1,1,1,227,103},{13,0,1,1,227,104},{14,1,1,1,227,104},{13,0,1,1,227,108},{14,1,1,1,227,108},{13,0,1,1,227,109},{14,1,1,1,227,109},{13,0,1,1,227,110},{14,1,1,1,227,110},{13,0,1,1,227,112},{14,1,1,1,227,112},{13,0,1,1,227,114},{14,1,1,1,227,114},{13,0,1,1,227,117},{14,1,1,1,227,117},{0,1,1,1,227,58},{0,1,1,1,227,66},{0,1,1,1,227,67},{0,1,1,1,227,68},{0,1,1,1,227,69},{0,1,1,1,227,70},{0,1,1,1,227,71},{0,1,1,1,227,72},{0,1,1,1,227,73},{0,1,1,1,227,74},{0,1,1,1,227,75},{0,1,1,1,227,76},{0,1,1,1,227,77},{0,1,1,1,227,78},{0,1,1,1,227,79},{0,1,1,1,227,80},{0,1,1,1,227,81},{0,1,1,1,227,82},{0,1,1,1,227,83},{0,1,1,1,227,84},{0,1,1,1,227,85},{0,1,1,1,227,86},{0,1,1,1,227,87},{0,1,1,1,227,89},{0,1,1,1,227,106},{0,1,1,1,227,107},{0,1,1,1,227,113},{0,1,1,1,227,118},{0,1,1,1,227,119},{0,1,1,1,227,120},{0,1,1,1,227,121},{0,1,1,1,227,122},{85,0,0,1,0,227},{86,0,0,1,0,227},{87,0,0,1,0,227},{88,1,0,1,0,227},{9,0,1,1,229,48},{10,0,1,1,229,48},{11,0,1,1,229,48},{12,1,1,1,229,48},{9,0,1,1,229,49},{10,0,1,1,229,49},{11,0,1,1,229,49},{12,1,1,1,229,49},{9,0,1,1,229,50},{10,0,1,1,229,50},{11,0,1,1,229,50},{12,1,1,1,229,50},{9,0,1,1,229,97},{10,0,1,1,229,97},{11,0,1,1,229,97},{12,1,1,1,229,97},{9,0,1,1,229,99},{10,0,1,1,229,99},{11,0,1,1,229,99},{12,1,1,1,229,99},{9,0,1,1,229,101},{10,0,1,1,229,101},{11,0,1,1,229,101},{12,1,1,1,229,101},{9,0,1,1,229,105},{10,0,1,1,229,105},{11,0,1,1,229,105},{12,1,1,1,229,105},{9,0,1,1,229,111},{10,0,1,1,229,111},{11,0,1,1,229,111},{12,1,1,1,229,111},{9,0,1,1,229,115},{10,0,1,1,229,115},{11,0,1,1,229,115},{12,1,1,1,229,115},{9,0,1,1,229,116},{10,0,1,1,229,116},{11,0,1,1,229,116},{12,1,1,1,229,116},{13,0,1,1,229,32},{14,1,1,1,229,32},{13,0,1,1,229,37},{14,1,1,1,229,37},{13,0,1,1,229,45},{14,1,1,1,229,45},{13,0,1,1,229,46},{14,1,1,1,229,46},{13,0,1,1,229,47},{14,1,1,1,229,47},{13,0,1,1,229,51},{14,1,1,1,229,51},{13,0,1,1,229,52},{14,1,1,1,229,52},{13,0,1,1,229,53},{14,1,1,1,229,53},{13,0,1,1,229,54},{14,1,1,1,229,54},{13,0,1,1,229,55},{14,1,1,1,229,55},{13,0,1,1,229,56},{14,1,1,1,229,56},{13,0,1,1,229,57},{14,1,1,1,229,57},{13,0,1,1,229,61},{14,1,1,1,229,61},{13,0,1,1,229,65},{14,1,1,1,229,65},{13,0,1,1,229,95},{14,1,1,1,229,95},{13,0,1,1,229,98},{14,1,1,1,229,98},{13,0,1,1,229,100},{14,1,1,1,229,100},{13,0,1,1,229,102},{14,1,1,1,229,102},{13,0,1,1,229,103},{14,1,1,1,229,103},{13,0,1,1,229,104},{14,1,1,1,229,104},{13,0,1,1,229,108},{14,1,1,1,229,108},{13,0,1,1,229,109},{14,1,1,1,229,109},{13,0,1,1,229,110},{14,1,1,1,229,110},{13,0,1,1,229,112},{14,1,1,1,229,112},{13,0,1,1,229,114},{14,1,1,1,229,114},{13,0,1,1,229,117},{14,1,1,1,229,117},{0,1,1,1,229,58},{0,1,1,1,229,66},{0,1,1,1,229,67},{0,1,1,1,229,68},{0,1,1,1,229,69},{0,1,1,1,229,70},{0,1,1,1,229,71},{0,1,1,1,229,72},{0,1,1,1,229,73},{0,1,1,1,229,74},{0,1,1,1,229,75},{0,1,1,1,229,76},{0,1,1,1,229,77},{0,1,1,1,229,78},{0,1,1,1,229,79},{0,1,1,1,229,80},{0,1,1,1,229,81},{0,1,1,1,229,82},{0,1,1,1,229,83},{0,1,1,1,229,84},{0,1,1,1,229,85},{0,1,1,1,229,86},{0,1,1,1,229,87},{0,1,1,1,229,89},{0,1,1,1,229,106},{0,1,1,1,229,107},{0,1,1,1,229,113},{0,1,1,1,229,118},{0,1,1,1,229,119},{0,1,1,1,229,120},{0,1,1,1,229,121},{0,1,1,1,229,122},{85,0,0,1,0,229},{86,0,0,1,0,229},{87,0,0,1,0,229},{88,1,0,1,0,229},{9,0,1,1,230,48},{10,0,1,1,230,48},{11,0,1,1,230,48},{12,1,1,1,230,48},{9,0,1,1,230,49},{10,0,1,1,230,49},{11,0,1,1,230,49},{12,1,1,1,230,49},{9,0,1,1,230,50},{10,0,1,1,230,50},{11,0,1,1,230,50},{12,1,1,1,230,50},{9,0,1,1,230,97},{10,0,1,1,230,97},{11,0,1,1,230,97},{12,1,1,1,230,97},{9,0,1,1,230,99},{10,0,1,1,230,99},{11,0,1,1,230,99},{12,1,1,1,230,99},{9,0,1,1,230,101},{10,0,1,1,230,101},{11,0,1,1,230,101},{12,1,1,1,230,101},{9,0,1,1,230,105},{10,0,1,1,230,105},{11,0,1,1,230,105},{12,1,1,1,230,105},{9,0,1,1,230,111},{10,0,1,1,230,111},{11,0,1,1,230,111},{12,1,1,1,230,111},{9,0,1,1,230,115},{10,0,1,1,230,115},{11,0,1,1,230,115},{12,1,1,1,230,115},{9,0,1,1,230,116},{10,0,1,1,230,116},{11,0,1,1,230,116},{12,1,1,1,230,116},{13,0,1,1,230,32},{14,1,1,1,230,32},{13,0,1,1,230,37},{14,1,1,1,230,37},{13,0,1,1,230,45},{14,1,1,1,230,45},{13,0,1,1,230,46},{14,1,1,1,230,46},{13,0,1,1,230,47},{14,1,1,1,230,47},{13,0,1,1,230,51},{14,1,1,1,230,51},{13,0,1,1,230,52},{14,1,1,1,230,52},{13,0,1,1,230,53},{14,1,1,1,230,53},{13,0,1,1,230,54},{14,1,1,1,230,54},{13,0,1,1,230,55},{14,1,1,1,230,55},{13,0,1,1,230,56},{14,1,1,1,230,56},{13,0,1,1,230,57},{14,1,1,1,230,57},{13,0,1,1,230,61},{14,1,1,1,230,61},{13,0,1,1,230,65},{14,1,1,1,230,65},{13,0,1,1,230,95},{14,1,1,1,230,95},{13,0,1,1,230,98},{14,1,1,1,230,98},{13,0,1,1,230,100},{14,1,1,1,230,100},{13,0,1,1,230,102},{14,1,1,1,230,102},{13,0,1,1,230,103},{14,1,1,1,230,103},{13,0,1,1,230,104},{14,1,1,1,230,104},{13,0,1,1,230,108},{14,1,1,1,230,108},{13,0,1,1,230,109},{14,1,1,1,230,109},{13,0,1,1,230,110},{14,1,1,1,230,110},{13,0,1,1,230,112},{14,1,1,1,230,112},{13,0,1,1,230,114},{14,1,1,1,230,114},{13,0,1,1,230,117},{14,1,1,1,230,117},{0,1,1,1,230,58},{0,1,1,1,230,66},{0,1,1,1,230,67},{0,1,1,1,230,68},{0,1,1,1,230,69},{0,1,1,1,230,70},{0,1,1,1,230,71},{0,1,1,1,230,72},{0,1,1,1,230,73},{0,1,1,1,230,74},{0,1,1,1,230,75},{0,1,1,1,230,76},{0,1,1,1,230,77},{0,1,1,1,230,78},{0,1,1,1,230,79},{0,1,1,1,230,80},{0,1,1,1,230,81},{0,1,1,1,230,82},{0,1,1,1,230,83},{0,1,1,1,230,84},{0,1,1,1,230,85},{0,1,1,1,230,86},{0,1,1,1,230,87},{0,1,1,1,230,89},{0,1,1,1,230,106},{0,1,1,1,230,107},{0,1,1,1,230,113},{0,1,1,1,230,118},{0,1,1,1,230,119},{0,1,1,1,230,120},{0,1,1,1,230,121},{0,1,1,1,230,122},{85,0,0,1,0,230},{86,0,0,1,0,230},{87,0,0,1,0,230},{88,1,0,1,0,230},{13,0,1,1,129,48},{14,1,1,1,129,48},{13,0,1,1,129,49},{14,1,1,1,129,49},{13,0,1,1,129,50},{14,1,1,1,129,50},{13,0,1,1,129,97},{14,1,1,1,129,97},{13,0,1,1,129,99},{14,1,1,1,129,99},{13,0,1,1,129,101},{14,1,1,1,129,101},{13,0,1,1,129,105},{14,1,1,1,129,105},{13,0,1,1,129,111},{14,1,1,1,129,111},{13,0,1,1,129,115},{14,1,1,1,129,115},{13,0,1,1,129,116},{14,1,1,1,129,116},{0,1,1,1,129,32},{0,1,1,1,129,37},{0,1,1,1,129,45},{0,1,1,1,129,46},{0,1,1,1,129,47},{0,1,1,1,129,51},{0,1,1,1,129,52},{0,1,1,1,129,53},{0,1,1,1,129,54},{0,1,1,1,129,55},{0,1,1,1,129,56},{0,1,1,1,129,57},{0,1,1,1,129,61},{0,1,1,1,129,65},{0,1,1,1,129,95},{0,1,1,1,129,98},{0,1,1,1,129,100},{0,1,1,1,129,102},{0,1,1,1,129,103},{0,1,1,1,129,104},{0,1,1,1,129,108},{0,1,1,1,129,109},{0,1,1,1,129,110},{0,1,1,1,129,112},{0,1,1,1,129,114},{0,1,1,1,129,117},{17,0,0,1,0,129},{18,0,0,1,0,129},{19,0,0,1,0,129},{20,0,0,1,0,129},{21,0,0,1,0,129},{22,0,0,1,0,129},{23,0,0,1,0,129},{24,0,0,1,0,129},{25,0,0,1,0,129},{26,0,0,1,0,129},{27,0,0,1,0,129},{28,0,0,1,0,129},{29,0,0,1,0,129},{30,0,0,1,0,129},{31,0,0,1,0,129},{32,0,0,1,0,129},{33,0,0,1,0,129},{34,1,0,1,0,129},{13,0,1,1,132,48},{14,1,1,1,132,48},{13,0,1,1,132,49},{14,1,1,1,132,49},{13,0,1,1,132,50},{14,1,1,1,132,50},{13,0,1,1,132,97},{14,1,1,1,132,97},{13,0,1,1,132,99},{14,1,1,1,132,99},{13,0,1,1,132,101},{14,1,1,1,132,101},{13,0,1,1,132,105},{14,1,1,1,132,105},{13,0,1,1,132,111},{14,1,1,1,132,111},{13,0,1,1,132,115},{14,1,1,1,132,115},{13,0,1,1,132,116},{14,1,1,1,132,116},{0,1,1,1,132,32},{0,1,1,1,132,37},{0,1,1,1,132,45},{0,1,1,1,132,46},{0,1,1,1,132,47},{0,1,1,1,132,51},{0,1,1,1,132,52},{0,1,1,1,132,53},{0,1,1,1,132,54},{0,1,1,1,132,55},{0,1,1,1,132,56},{0,1,1,1,132,57},{0,1,1,1,132,61},{0,1,1,1,132,65},{0,1,1,1,132,95},{0,1,1,1,132,98},{0,1,1,1,132,100},{0,1,1,1,132,102},{0,1,1,1,132,103},{0,1,1,1,132,104},{0,1,1,1,132,108},{0,1,1,1,132,109},{0,1,1,1,132,110},{0,1,1,1,132,112},{0,1,1,1,132,114},{0,1,1,1,132,117},{17,0,0,1,0,132},{18,0,0,1,0,132},{19,0,0,1,0,132},{20,0,0,1,0,132},{21,0,0,1,0,132},{22,0,0,1,0,132},{23,0,0,1,0,132},{24,0,0,1,0,132},{25,0,0,1,0,132},{26,0,0,1,0,132},{27,0,0,1,0,132},{28,0,0,1,0,132},{29,0,0,1,0,132},{30,0,0,1,0,132},{31,0,0,1,0,132},{32,0,0,1,0,132},{33,0,0,1,0,132},{34,1,0,1,0,132},{13,0,1,1,133,48},{14,1,1,1,133,48},{13,0,1,1,133,49},{14,1,1,1,133,49},{13,0,1,1,133,50},{14,1,1,1,133,50},{13,0,1,1,133,97},{14,1,1,1,133,97},{13,0,1,1,133,99},{14,1,1,1,133,99},{13,0,1,1,133,101},{14,1,1,1,133,101},{13,0,1,1,133,105},{14,1,1,1,133,105},{13,0,1,1,133,111},{14,1,1,1,133,111},{13,0,1,1,133,115},{14,1,1,1,133,115},{13,0,1,1,133,116},{14,1,1,1,133,116},{0,1,1,1,133,32},{0,1,1,1,133,37},{0,1,1,1,133,45},{0,1,1,1,133,46},{0,1,1,1,133,47},{0,1,1,1,133,51},{0,1,1,1,133,52},{0,1,1,1,133,53},{0,1,1,1,133,54},{0,1,1,1,133,55},{0,1,1,1,133,56},{0,1,1,1,133,57},{0,1,1,1,133,61},{0,1,1,1,133,65},{0,1,1,1,133,95},{0,1,1,1,133,98},{0,1,1,1,133,100},{0,1,1,1,133,102},{0,1,1,1,133,103},{0,1,1,1,133,104},{0,1,1,1,133,108},{0,1,1,1,133,109},{0,1,1,1,133,110},{0,1,1,1,133,112},{0,1,1,1,133,114},{0,1,1,1,133,117},{17,0,0,1,0,133},{18,0,0,1,0,133},{19,0,0,1,0,133},{20,0,0,1,0,133},{21,0,0,1,0,133},{22,0,0,1,0,133},{23,0,0,1,0,133},{24,0,0,1,0,133},{25,0,0,1,0,133},{26,0,0,1,0,133},{27,0,0,1,0,133},{28,0,0,1,0,133},{29,0,0,1,0,133},{30,0,0,1,0,133},{31,0,0,1,0,133},{32,0,0,1,0,133},{33,0,0,1,0,133},{34,1,0,1,0,133},{13,0,1,1,134,48},{14,1,1,1,134,48},{13,0,1,1,134,49},{14,1,1,1,134,49},{13,0,1,1,134,50},{14,1,1,1,134,50},{13,0,1,1,134,97},{14,1,1,1,134,97},{13,0,1,1,134,99},{14,1,1,1,134,99},{13,0,1,1,134,101},{14,1,1,1,134,101},{13,0,1,1,134,105},{14,1,1,1,134,105},{13,0,1,1,134,111},{14,1,1,1,134,111},{13,0,1,1,134,115},{14,1,1,1,134,115},{13,0,1,1,134,116},{14,1,1,1,134,116},{0,1,1,1,134,32},{0,1,1,1,134,37},{0,1,1,1,134,45},{0,1,1,1,134,46},{0,1,1,1,134,47},{0,1,1,1,134,51},{0,1,1,1,134,52},{0,1,1,1,134,53},{0,1,1,1,134,54},{0,1,1,1,134,55},{0,1,1,1,134,56},{0,1,1,1,134,57},{0,1,1,1,134,61},{0,1,1,1,134,65},{0,1,1,1,134,95},{0,1,1,1,134,98},{0,1,1,1,134,100},{0,1,1,1,134,102},{0,1,1,1,134,103},{0,1,1,1,134,104},{0,1,1,1,134,108},{0,1,1,1,134,109},{0,1,1,1,134,110},{0,1,1,1,134,112},{0,1,1,1,134,114},{0,1,1,1,134,117},{17,0,0,1,0,134},{18,0,0,1,0,134},{19,0,0,1,0,134},{20,0,0,1,0,134},{21,0,0,1,0,134},{22,0,0,1,0,134},{23,0,0,1,0,134},{24,0,0,1,0,134},{25,0,0,1,0,134},{26,0,0,1,0,134},{27,0,0,1,0,134},{28,0,0,1,0,134},{29,0,0,1,0,134},{30,0,0,1,0,134},{31,0,0,1,0,134},{32,0,0,1,0,134},{33,0,0,1,0,134},{34,1,0,1,0,134},{13,0,1,1,136,48},{14,1,1,1,136,48},{13,0,1,1,136,49},{14,1,1,1,136,49},{13,0,1,1,136,50},{14,1,1,1,136,50},{13,0,1,1,136,97},{14,1,1,1,136,97},{13,0,1,1,136,99},{14,1,1,1,136,99},{13,0,1,1,136,101},{14,1,1,1,136,101},{13,0,1,1,136,105},{14,1,1,1,136,105},{13,0,1,1,136,111},{14,1,1,1,136,111},{13,0,1,1,136,115},{14,1,1,1,136,115},{13,0,1,1,136,116},{14,1,1,1,136,116},{0,1,1,1,136,32},{0,1,1,1,136,37},{0,1,1,1,136,45},{0,1,1,1,136,46},{0,1,1,1,136,47},{0,1,1,1,136,51},{0,1,1,1,136,52},{0,1,1,1,136,53},{0,1,1,1,136,54},{0,1,1,1,136,55},{0,1,1,1,136,56},{0,1,1,1,136,57},{0,1,1,1,136,61},{0,1,1,1,136,65},{0,1,1,1,136,95},{0,1,1,1,136,98},{0,1,1,1,136,100},{0,1,1,1,136,102},{0,1,1,1,136,103},{0,1,1,1,136,104},{0,1,1,1,136,108},{0,1,1,1,136,109},{0,1,1,1,136,110},{0,1,1,1,136,112},{0,1,1,1,136,114},{0,1,1,1,136,117},{17,0,0,1,0,136},{18,0,0,1,0,136},{19,0,0,1,0,136},{20,0,0,1,0,136},{21,0,0,1,0,136},{22,0,0,1,0,136},{23,0,0,1,0,136},{24,0,0,1,0,136},{25,0,0,1,0,136},{26,0,0,1,0,136},{27,0,0,1,0,136},{28,0,0,1,0,136},{29,0,0,1,0,136},{30,0,0,1,0,136},{31,0,0,1,0,136},{32,0,0,1,0,136},{33,0,0,1,0,136},{34,1,0,1,0,136},{13,0,1,1,146,48},{14,1,1,1,146,48},{13,0,1,1,146,49},{14,1,1,1,146,49},{13,0,1,1,146,50},{14,1,1,1,146,50},{13,0,1,1,146,97},{14,1,1,1,146,97},{13,0,1,1,146,99},{14,1,1,1,146,99},{13,0,1,1,146,101},{14,1,1,1,146,101},{13,0,1,1,146,105},{14,1,1,1,146,105},{13,0,1,1,146,111},{14,1,1,1,146,111},{13,0,1,1,146,115},{14,1,1,1,146,115},{13,0,1,1,146,116},{14,1,1,1,146,116},{0,1,1,1,146,32},{0,1,1,1,146,37},{0,1,1,1,146,45},{0,1,1,1,146,46},{0,1,1,1,146,47},{0,1,1,1,146,51},{0,1,1,1,146,52},{0,1,1,1,146,53},{0,1,1,1,146,54},{0,1,1,1,146,55},{0,1,1,1,146,56},{0,1,1,1,146,57},{0,1,1,1,146,61},{0,1,1,1,146,65},{0,1,1,1,146,95},{0,1,1,1,146,98},{0,1,1,1,146,100},{0,1,1,1,146,102},{0,1,1,1,146,103},{0,1,1,1,146,104},{0,1,1,1,146,108},{0,1,1,1,146,109},{0,1,1,1,146,110},{0,1,1,1,146,112},{0,1,1,1,146,114},{0,1,1,1,146,117},{17,0,0,1,0,146},{18,0,0,1,0,146},{19,0,0,1,0,146},{20,0,0,1,0,146},{21,0,0,1,0,146},{22,0,0,1,0,146},{23,0,0,1,0,146},{24,0,0,1,0,146},{25,0,0,1,0,146},{26,0,0,1,0,146},{27,0,0,1,0,146},{28,0,0,1,0,146},{29,0,0,1,0,146},{30,0,0,1,0,146},{31,0,0,1,0,146},{32,0,0,1,0,146},{33,0,0,1,0,146},{34,1,0,1,0,146},{13,0,1,1,154,48},{14,1,1,1,154,48},{13,0,1,1,154,49},{14,1,1,1,154,49},{13,0,1,1,154,50},{14,1,1,1,154,50},{13,0,1,1,154,97},{14,1,1,1,154,97},{13,0,1,1,154,99},{14,1,1,1,154,99},{13,0,1,1,154,101},{14,1,1,1,154,101},{13,0,1,1,154,105},{14,1,1,1,154,105},{13,0,1,1,154,111},{14,1,1,1,154,111},{13,0,1,1,154,115},{14,1,1,1,154,115},{13,0,1,1,154,116},{14,1,1,1,154,116},{0,1,1,1,154,32},{0,1,1,1,154,37},{0,1,1,1,154,45},{0,1,1,1,154,46},{0,1,1,1,154,47},{0,1,1,1,154,51},{0,1,1,1,154,52},{0,1,1,1,154,53},{0,1,1,1,154,54},{0,1,1,1,154,55},{0,1,1,1,154,56},{0,1,1,1,154,57},{0,1,1,1,154,61},{0,1,1,1,154,65},{0,1,1,1,154,95},{0,1,1,1,154,98},{0,1,1,1,154,100},{0,1,1,1,154,102},{0,1,1,1,154,103},{0,1,1,1,154,104},{0,1,1,1,154,108},{0,1,1,1,154,109},{0,1,1,1,154,110},{0,1,1,1,154,112},{0,1,1,1,154,114},{0,1,1,1,154,117},{17,0,0,1,0,154},{18,0,0,1,0,154},{19,0,0,1,0,154},{20,0,0,1,0,154},{21,0,0,1,0,154},{22,0,0,1,0,154},{23,0,0,1,0,154},{24,0,0,1,0,154},{25,0,0,1,0,154},{26,0,0,1,0,154},{27,0,0,1,0,154},{28,0,0,1,0,154},{29,0,0,1,0,154},{30,0,0,1,0,154},{31,0,0,1,0,154},{32,0,0,1,0,154},{33,0,0,1,0,154},{34,1,0,1,0,154},{13,0,1,1,156,48},{14,1,1,1,156,48},{13,0,1,1,156,49},{14,1,1,1,156,49},{13,0,1,1,156,50},{14,1,1,1,156,50},{13,0,1,1,156,97},{14,1,1,1,156,97},{13,0,1,1,156,99},{14,1,1,1,156,99},{13,0,1,1,156,101},{14,1,1,1,156,101},{13,0,1,1,156,105},{14,1,1,1,156,105},{13,0,1,1,156,111},{14,1,1,1,156,111},{13,0,1,1,156,115},{14,1,1,1,156,115},{13,0,1,1,156,116},{14,1,1,1,156,116},{0,1,1,1,156,32},{0,1,1,1,156,37},{0,1,1,1,156,45},{0,1,1,1,156,46},{0,1,1,1,156,47},{0,1,1,1,156,51},{0,1,1,1,156,52},{0,1,1,1,156,53},{0,1,1,1,156,54},{0,1,1,1,156,55},{0,1,1,1,156,56},{0,1,1,1,156,57},{0,1,1,1,156,61},{0,1,1,1,156,65},{0,1,1,1,156,95},{0,1,1,1,156,98},{0,1,1,1,156,100},{0,1,1,1,156,102},{0,1,1,1,156,103},{0,1,1,1,156,104},{0,1,1,1,156,108},{0,1,1,1,156,109},{0,1,1,1,156,110},{0,1,1,1,156,112},{0,1,1,1,156,114},{0,1,1,1,156,117},{17,0,0,1,0,156},{18,0,0,1,0,156},{19,0,0,1,0,156},{20,0,0,1,0,156},{21,0,0,1,0,156},{22,0,0,1,0,156},{23,0,0,1,0,156},{24,0,0,1,0,156},{25,0,0,1,0,156},{26,0,0,1,0,156},{27,0,0,1,0,156},{28,0,0,1,0,156},{29,0,0,1,0,156},{30,0,0,1,0,156},{31,0,0,1,0,156},{32,0,0,1,0,156},{33,0,0,1,0,156},{34,1,0,1,0,156},{13,0,1,1,160,48},{14,1,1,1,160,48},{13,0,1,1,160,49},{14,1,1,1,160,49},{13,0,1,1,160,50},{14,1,1,1,160,50},{13,0,1,1,160,97},{14,1,1,1,160,97},{13,0,1,1,160,99},{14,1,1,1,160,99},{13,0,1,1,160,101},{14,1,1,1,160,101},{13,0,1,1,160,105},{14,1,1,1,160,105},{13,0,1,1,160,111},{14,1,1,1,160,111},{13,0,1,1,160,115},{14,1,1,1,160,115},{13,0,1,1,160,116},{14,1,1,1,160,116},{0,1,1,1,160,32},{0,1,1,1,160,37},{0,1,1,1,160,45},{0,1,1,1,160,46},{0,1,1,1,160,47},{0,1,1,1,160,51},{0,1,1,1,160,52},{0,1,1,1,160,53},{0,1,1,1,160,54},{0,1,1,1,160,55},{0,1,1,1,160,56},{0,1,1,1,160,57},{0,1,1,1,160,61},{0,1,1,1,160,65},{0,1,1,1,160,95},{0,1,1,1,160,98},{0,1,1,1,160,100},{0,1,1,1,160,102},{0,1,1,1,160,103},{0,1,1,1,160,104},{0,1,1,1,160,108},{0,1,1,1,160,109},{0,1,1,1,160,110},{0,1,1,1,160,112},{0,1,1,1,160,114},{0,1,1,1,160,117},{17,0,0,1,0,160},{18,0,0,1,0,160},{19,0,0,1,0,160},{20,0,0,1,0,160},{21,0,0,1,0,160},{22,0,0,1,0,160},{23,0,0,1,0,160},{24,0,0,1,0,160},{25,0,0,1,0,160},{26,0,0,1,0,160},{27,0,0,1,0,160},{28,0,0,1,0,160},{29,0,0,1,0,160},{30,0,0,1,0,160},{31,0,0,1,0,160},{32,0,0,1,0,160},{33,0,0,1,0,160},{34,1,0,1,0,160},{13,0,1,1,163,48},{14,1,1,1,163,48},{13,0,1,1,163,49},{14,1,1,1,163,49},{13,0,1,1,163,50},{14,1,1,1,163,50},{13,0,1,1,163,97},{14,1,1,1,163,97},{13,0,1,1,163,99},{14,1,1,1,163,99},{13,0,1,1,163,101},{14,1,1,1,163,101},{13,0,1,1,163,105},{14,1,1,1,163,105},{13,0,1,1,163,111},{14,1,1,1,163,111},{13,0,1,1,163,115},{14,1,1,1,163,115},{13,0,1,1,163,116},{14,1,1,1,163,116},{0,1,1,1,163,32},{0,1,1,1,163,37},{0,1,1,1,163,45},{0,1,1,1,163,46},{0,1,1,1,163,47},{0,1,1,1,163,51},{0,1,1,1,163,52},{0,1,1,1,163,53},{0,1,1,1,163,54},{0,1,1,1,163,55},{0,1,1,1,163,56},{0,1,1,1,163,57},{0,1,1,1,163,61},{0,1,1,1,163,65},{0,1,1,1,163,95},{0,1,1,1,163,98},{0,1,1,1,163,100},{0,1,1,1,163,102},{0,1,1,1,163,103},{0,1,1,1,163,104},{0,1,1,1,163,108},{0,1,1,1,163,109},{0,1,1,1,163,110},{0,1,1,1,163,112},{0,1,1,1,163,114},{0,1,1,1,163,117},{17,0,0,1,0,163},{18,0,0,1,0,163},{19,0,0,1,0,163},{20,0,0,1,0,163},{21,0,0,1,0,163},{22,0,0,1,0,163},{23,0,0,1,0,163},{24,0,0,1,0,163},{25,0,0,1,0,163},{26,0,0,1,0,163},{27,0,0,1,0,163},{28,0,0,1,0,163},{29,0,0,1,0,163},{30,0,0,1,0,163},{31,0,0,1,0,163},{32,0,0,1,0,163},{33,0,0,1,0,163},{34,1,0,1,0,163},{13,0,1,1,164,48},{14,1,1,1,164,48},{13,0,1,1,164,49},{14,1,1,1,164,49},{13,0,1,1,164,50},{14,1,1,1,164,50},{13,0,1,1,164,97},{14,1,1,1,164,97},{13,0,1,1,164,99},{14,1,1,1,164,99},{13,0,1,1,164,101},{14,1,1,1,164,101},{13,0,1,1,164,105},{14,1,1,1,164,105},{13,0,1,1,164,111},{14,1,1,1,164,111},{13,0,1,1,164,115},{14,1,1,1,164,115},{13,0,1,1,164,116},{14,1,1,1,164,116},{0,1,1,1,164,32},{0,1,1,1,164,37},{0,1,1,1,164,45},{0,1,1,1,164,46},{0,1,1,1,164,47},{0,1,1,1,164,51},{0,1,1,1,164,52},{0,1,1,1,164,53},{0,1,1,1,164,54},{0,1,1,1,164,55},{0,1,1,1,164,56},{0,1,1,1,164,57},{0,1,1,1,164,61},{0,1,1,1,164,65},{0,1,1,1,164,95},{0,1,1,1,164,98},{0,1,1,1,164,100},{0,1,1,1,164,102},{0,1,1,1,164,103},{0,1,1,1,164,104},{0,1,1,1,164,108},{0,1,1,1,164,109},{0,1,1,1,164,110},{0,1,1,1,164,112},{0,1,1,1,164,114},{0,1,1,1,164,117},{17,0,0,1,0,164},{18,0,0,1,0,164},{19,0,0,1,0,164},{20,0,0,1,0,164},{21,0,0,1,0,164},{22,0,0,1,0,164},{23,0,0,1,0,164},{24,0,0,1,0,164},{25,0,0,1,0,164},{26,0,0,1,0,164},{27,0,0,1,0,164},{28,0,0,1,0,164},{29,0,0,1,0,164},{30,0,0,1,0,164},{31,0,0,1,0,164},{32,0,0,1,0,164},{33,0,0,1,0,164},{34,1,0,1,0,164},{13,0,1,1,169,48},{14,1,1,1,169,48},{13,0,1,1,169,49},{14,1,1,1,169,49},{13,0,1,1,169,50},{14,1,1,1,169,50},{13,0,1,1,169,97},{14,1,1,1,169,97},{13,0,1,1,169,99},{14,1,1,1,169,99},{13,0,1,1,169,101},{14,1,1,1,169,101},{13,0,1,1,169,105},{14,1,1,1,169,105},{13,0,1,1,169,111},{14,1,1,1,169,111},{13,0,1,1,169,115},{14,1,1,1,169,115},{13,0,1,1,169,116},{14,1,1,1,169,116},{0,1,1,1,169,32},{0,1,1,1,169,37},{0,1,1,1,169,45},{0,1,1,1,169,46},{0,1,1,1,169,47},{0,1,1,1,169,51},{0,1,1,1,169,52},{0,1,1,1,169,53},{0,1,1,1,169,54},{0,1,1,1,169,55},{0,1,1,1,169,56},{0,1,1,1,169,57},{0,1,1,1,169,61},{0,1,1,1,169,65},{0,1,1,1,169,95},{0,1,1,1,169,98},{0,1,1,1,169,100},{0,1,1,1,169,102},{0,1,1,1,169,103},{0,1,1,1,169,104},{0,1,1,1,169,108},{0,1,1,1,169,109},{0,1,1,1,169,110},{0,1,1,1,169,112},{0,1,1,1,169,114},{0,1,1,1,169,117},{17,0,0,1,0,169},{18,0,0,1,0,169},{19,0,0,1,0,169},{20,0,0,1,0,169},{21,0,0,1,0,169},{22,0,0,1,0,169},{23,0,0,1,0,169},{24,0,0,1,0,169},{25,0,0,1,0,169},{26,0,0,1,0,169},{27,0,0,1,0,169},{28,0,0,1,0,169},{29,0,0,1,0,169},{30,0,0,1,0,169},{31,0,0,1,0,169},{32,0,0,1,0,169},{33,0,0,1,0,169},{34,1,0,1,0,169},{13,0,1,1,170,48},{14,1,1,1,170,48},{13,0,1,1,170,49},{14,1,1,1,170,49},{13,0,1,1,170,50},{14,1,1,1,170,50},{13,0,1,1,170,97},{14,1,1,1,170,97},{13,0,1,1,170,99},{14,1,1,1,170,99},{13,0,1,1,170,101},{14,1,1,1,170,101},{13,0,1,1,170,105},{14,1,1,1,170,105},{13,0,1,1,170,111},{14,1,1,1,170,111},{13,0,1,1,170,115},{14,1,1,1,170,115},{13,0,1,1,170,116},{14,1,1,1,170,116},{0,1,1,1,170,32},{0,1,1,1,170,37},{0,1,1,1,170,45},{0,1,1,1,170,46},{0,1,1,1,170,47},{0,1,1,1,170,51},{0,1,1,1,170,52},{0,1,1,1,170,53},{0,1,1,1,170,54},{0,1,1,1,170,55},{0,1,1,1,170,56},{0,1,1,1,170,57},{0,1,1,1,170,61},{0,1,1,1,170,65},{0,1,1,1,170,95},{0,1,1,1,170,98},{0,1,1,1,170,100},{0,1,1,1,170,102},{0,1,1,1,170,103},{0,1,1,1,170,104},{0,1,1,1,170,108},{0,1,1,1,170,109},{0,1,1,1,170,110},{0,1,1,1,170,112},{0,1,1,1,170,114},{0,1,1,1,170,117},{17,0,0,1,0,170},{18,0,0,1,0,170},{19,0,0,1,0,170},{20,0,0,1,0,170},{21,0,0,1,0,170},{22,0,0,1,0,170},{23,0,0,1,0,170},{24,0,0,1,0,170},{25,0,0,1,0,170},{26,0,0,1,0,170},{27,0,0,1,0,170},{28,0,0,1,0,170},{29,0,0,1,0,170},{30,0,0,1,0,170},{31,0,0,1,0,170},{32,0,0,1,0,170},{33,0,0,1,0,170},{34,1,0,1,0,170},{13,0,1,1,173,48},{14,1,1,1,173,48},{13,0,1,1,173,49},{14,1,1,1,173,49},{13,0,1,1,173,50},{14,1,1,1,173,50},{13,0,1,1,173,97},{14,1,1,1,173,97},{13,0,1,1,173,99},{14,1,1,1,173,99},{13,0,1,1,173,101},{14,1,1,1,173,101},{13,0,1,1,173,105},{14,1,1,1,173,105},{13,0,1,1,173,111},{14,1,1,1,173,111},{13,0,1,1,173,115},{14,1,1,1,173,115},{13,0,1,1,173,116},{14,1,1,1,173,116},{0,1,1,1,173,32},{0,1,1,1,173,37},{0,1,1,1,173,45},{0,1,1,1,173,46},{0,1,1,1,173,47},{0,1,1,1,173,51},{0,1,1,1,173,52},{0,1,1,1,173,53},{0,1,1,1,173,54},{0,1,1,1,173,55},{0,1,1,1,173,56},{0,1,1,1,173,57},{0,1,1,1,173,61},{0,1,1,1,173,65},{0,1,1,1,173,95},{0,1,1,1,173,98},{0,1,1,1,173,100},{0,1,1,1,173,102},{0,1,1,1,173,103},{0,1,1,1,173,104},{0,1,1,1,173,108},{0,1,1,1,173,109},{0,1,1,1,173,110},{0,1,1,1,173,112},{0,1,1,1,173,114},{0,1,1,1,173,117},{17,0,0,1,0,173},{18,0,0,1,0,173},{19,0,0,1,0,173},{20,0,0,1,0,173},{21,0,0,1,0,173},{22,0,0,1,0,173},{23,0,0,1,0,173},{24,0,0,1,0,173},{25,0,0,1,0,173},{26,0,0,1,0,173},{27,0,0,1,0,173},{28,0,0,1,0,173},{29,0,0,1,0,173},{30,0,0,1,0,173},{31,0,0,1,0,173},{32,0,0,1,0,173},{33,0,0,1,0,173},{34,1,0,1,0,173},{13,0,1,1,178,48},{14,1,1,1,178,48},{13,0,1,1,178,49},{14,1,1,1,178,49},{13,0,1,1,178,50},{14,1,1,1,178,50},{13,0,1,1,178,97},{14,1,1,1,178,97},{13,0,1,1,178,99},{14,1,1,1,178,99},{13,0,1,1,178,101},{14,1,1,1,178,101},{13,0,1,1,178,105},{14,1,1,1,178,105},{13,0,1,1,178,111},{14,1,1,1,178,111},{13,0,1,1,178,115},{14,1,1,1,178,115},{13,0,1,1,178,116},{14,1,1,1,178,116},{0,1,1,1,178,32},{0,1,1,1,178,37},{0,1,1,1,178,45},{0,1,1,1,178,46},{0,1,1,1,178,47},{0,1,1,1,178,51},{0,1,1,1,178,52},{0,1,1,1,178,53},{0,1,1,1,178,54},{0,1,1,1,178,55},{0,1,1,1,178,56},{0,1,1,1,178,57},{0,1,1,1,178,61},{0,1,1,1,178,65},{0,1,1,1,178,95},{0,1,1,1,178,98},{0,1,1,1,178,100},{0,1,1,1,178,102},{0,1,1,1,178,103},{0,1,1,1,178,104},{0,1,1,1,178,108},{0,1,1,1,178,109},{0,1,1,1,178,110},{0,1,1,1,178,112},{0,1,1,1,178,114},{0,1,1,1,178,117},{17,0,0,1,0,178},{18,0,0,1,0,178},{19,0,0,1,0,178},{20,0,0,1,0,178},{21,0,0,1,0,178},{22,0,0,1,0,178},{23,0,0,1,0,178},{24,0,0,1,0,178},{25,0,0,1,0,178},{26,0,0,1,0,178},{27,0,0,1,0,178},{28,0,0,1,0,178},{29,0,0,1,0,178},{30,0,0,1,0,178},{31,0,0,1,0,178},{32,0,0,1,0,178},{33,0,0,1,0,178},{34,1,0,1,0,178},{13,0,1,1,181,48},{14,1,1,1,181,48},{13,0,1,1,181,49},{14,1,1,1,181,49},{13,0,1,1,181,50},{14,1,1,1,181,50},{13,0,1,1,181,97},{14,1,1,1,181,97},{13,0,1,1,181,99},{14,1,1,1,181,99},{13,0,1,1,181,101},{14,1,1,1,181,101},{13,0,1,1,181,105},{14,1,1,1,181,105},{13,0,1,1,181,111},{14,1,1,1,181,111},{13,0,1,1,181,115},{14,1,1,1,181,115},{13,0,1,1,181,116},{14,1,1,1,181,116},{0,1,1,1,181,32},{0,1,1,1,181,37},{0,1,1,1,181,45},{0,1,1,1,181,46},{0,1,1,1,181,47},{0,1,1,1,181,51},{0,1,1,1,181,52},{0,1,1,1,181,53},{0,1,1,1,181,54},{0,1,1,1,181,55},{0,1,1,1,181,56},{0,1,1,1,181,57},{0,1,1,1,181,61},{0,1,1,1,181,65},{0,1,1,1,181,95},{0,1,1,1,181,98},{0,1,1,1,181,100},{0,1,1,1,181,102},{0,1,1,1,181,103},{0,1,1,1,181,104},{0,1,1,1,181,108},{0,1,1,1,181,109},{0,1,1,1,181,110},{0,1,1,1,181,112},{0,1,1,1,181,114},{0,1,1,1,181,117},{17,0,0,1,0,181},{18,0,0,1,0,181},{19,0,0,1,0,181},{20,0,0,1,0,181},{21,0,0,1,0,181},{22,0,0,1,0,181},{23,0,0,1,0,181},{24,0,0,1,0,181},{25,0,0,1,0,181},{26,0,0,1,0,181},{27,0,0,1,0,181},{28,0,0,1,0,181},{29,0,0,1,0,181},{30,0,0,1,0,181},{31,0,0,1,0,181},{32,0,0,1,0,181},{33,0,0,1,0,181},{34,1,0,1,0,181},{13,0,1,1,185,48},{14,1,1,1,185,48},{13,0,1,1,185,49},{14,1,1,1,185,49},{13,0,1,1,185,50},{14,1,1,1,185,50},{13,0,1,1,185,97},{14,1,1,1,185,97},{13,0,1,1,185,99},{14,1,1,1,185,99},{13,0,1,1,185,101},{14,1,1,1,185,101},{13,0,1,1,185,105},{14,1,1,1,185,105},{13,0,1,1,185,111},{14,1,1,1,185,111},{13,0,1,1,185,115},{14,1,1,1,185,115},{13,0,1,1,185,116},{14,1,1,1,185,116},{0,1,1,1,185,32},{0,1,1,1,185,37},{0,1,1,1,185,45},{0,1,1,1,185,46},{0,1,1,1,185,47},{0,1,1,1,185,51},{0,1,1,1,185,52},{0,1,1,1,185,53},{0,1,1,1,185,54},{0,1,1,1,185,55},{0,1,1,1,185,56},{0,1,1,1,185,57},{0,1,1,1,185,61},{0,1,1,1,185,65},{0,1,1,1,185,95},{0,1,1,1,185,98},{0,1,1,1,185,100},{0,1,1,1,185,102},{0,1,1,1,185,103},{0,1,1,1,185,104},{0,1,1,1,185,108},{0,1,1,1,185,109},{0,1,1,1,185,110},{0,1,1,1,185,112},{0,1,1,1,185,114},{0,1,1,1,185,117},{17,0,0,1,0,185},{18,0,0,1,0,185},{19,0,0,1,0,185},{20,0,0,1,0,185},{21,0,0,1,0,185},{22,0,0,1,0,185},{23,0,0,1,0,185},{24,0,0,1,0,185},{25,0,0,1,0,185},{26,0,0,1,0,185},{27,0,0,1,0,185},{28,0,0,1,0,185},{29,0,0,1,0,185},{30,0,0,1,0,185},{31,0,0,1,0,185},{32,0,0,1,0,185},{33,0,0,1,0,185},{34,1,0,1,0,185},{13,0,1,1,186,48},{14,1,1,1,186,48},{13,0,1,1,186,49},{14,1,1,1,186,49},{13,0,1,1,186,50},{14,1,1,1,186,50},{13,0,1,1,186,97},{14,1,1,1,186,97},{13,0,1,1,186,99},{14,1,1,1,186,99},{13,0,1,1,186,101},{14,1,1,1,186,101},{13,0,1,1,186,105},{14,1,1,1,186,105},{13,0,1,1,186,111},{14,1,1,1,186,111},{13,0,1,1,186,115},{14,1,1,1,186,115},{13,0,1,1,186,116},{14,1,1,1,186,116},{0,1,1,1,186,32},{0,1,1,1,186,37},{0,1,1,1,186,45},{0,1,1,1,186,46},{0,1,1,1,186,47},{0,1,1,1,186,51},{0,1,1,1,186,52},{0,1,1,1,186,53},{0,1,1,1,186,54},{0,1,1,1,186,55},{0,1,1,1,186,56},{0,1,1,1,186,57},{0,1,1,1,186,61},{0,1,1,1,186,65},{0,1,1,1,186,95},{0,1,1,1,186,98},{0,1,1,1,186,100},{0,1,1,1,186,102},{0,1,1,1,186,103},{0,1,1,1,186,104},{0,1,1,1,186,108},{0,1,1,1,186,109},{0,1,1,1,186,110},{0,1,1,1,186,112},{0,1,1,1,186,114},{0,1,1,1,186,117},{17,0,0,1,0,186},{18,0,0,1,0,186},{19,0,0,1,0,186},{20,0,0,1,0,186},{21,0,0,1,0,186},{22,0,0,1,0,186},{23,0,0,1,0,186},{24,0,0,1,0,186},{25,0,0,1,0,186},{26,0,0,1,0,186},{27,0,0,1,0,186},{28,0,0,1,0,186},{29,0,0,1,0,186},{30,0,0,1,0,186},{31,0,0,1,0,186},{32,0,0,1,0,186},{33,0,0,1,0,186},{34,1,0,1,0,186},{13,0,1,1,187,48},{14,1,1,1,187,48},{13,0,1,1,187,49},{14,1,1,1,187,49},{13,0,1,1,187,50},{14,1,1,1,187,50},{13,0,1,1,187,97},{14,1,1,1,187,97},{13,0,1,1,187,99},{14,1,1,1,187,99},{13,0,1,1,187,101},{14,1,1,1,187,101},{13,0,1,1,187,105},{14,1,1,1,187,105},{13,0,1,1,187,111},{14,1,1,1,187,111},{13,0,1,1,187,115},{14,1,1,1,187,115},{13,0,1,1,187,116},{14,1,1,1,187,116},{0,1,1,1,187,32},{0,1,1,1,187,37},{0,1,1,1,187,45},{0,1,1,1,187,46},{0,1,1,1,187,47},{0,1,1,1,187,51},{0,1,1,1,187,52},{0,1,1,1,187,53},{0,1,1,1,187,54},{0,1,1,1,187,55},{0,1,1,1,187,56},{0,1,1,1,187,57},{0,1,1,1,187,61},{0,1,1,1,187,65},{0,1,1,1,187,95},{0,1,1,1,187,98},{0,1,1,1,187,100},{0,1,1,1,187,102},{0,1,1,1,187,103},{0,1,1,1,187,104},{0,1,1,1,187,108},{0,1,1,1,187,109},{0,1,1,1,187,110},{0,1,1,1,187,112},{0,1,1,1,187,114},{0,1,1,1,187,117},{17,0,0,1,0,187},{18,0,0,1,0,187},{19,0,0,1,0,187},{20,0,0,1,0,187},{21,0,0,1,0,187},{22,0,0,1,0,187},{23,0,0,1,0,187},{24,0,0,1,0,187},{25,0,0,1,0,187},{26,0,0,1,0,187},{27,0,0,1,0,187},{28,0,0,1,0,187},{29,0,0,1,0,187},{30,0,0,1,0,187},{31,0,0,1,0,187},{32,0,0,1,0,187},{33,0,0,1,0,187},{34,1,0,1,0,187},{13,0,1,1,189,48},{14,1,1,1,189,48},{13,0,1,1,189,49},{14,1,1,1,189,49},{13,0,1,1,189,50},{14,1,1,1,189,50},{13,0,1,1,189,97},{14,1,1,1,189,97},{13,0,1,1,189,99},{14,1,1,1,189,99},{13,0,1,1,189,101},{14,1,1,1,189,101},{13,0,1,1,189,105},{14,1,1,1,189,105},{13,0,1,1,189,111},{14,1,1,1,189,111},{13,0,1,1,189,115},{14,1,1,1,189,115},{13,0,1,1,189,116},{14,1,1,1,189,116},{0,1,1,1,189,32},{0,1,1,1,189,37},{0,1,1,1,189,45},{0,1,1,1,189,46},{0,1,1,1,189,47},{0,1,1,1,189,51},{0,1,1,1,189,52},{0,1,1,1,189,53},{0,1,1,1,189,54},{0,1,1,1,189,55},{0,1,1,1,189,56},{0,1,1,1,189,57},{0,1,1,1,189,61},{0,1,1,1,189,65},{0,1,1,1,189,95},{0,1,1,1,189,98},{0,1,1,1,189,100},{0,1,1,1,189,102},{0,1,1,1,189,103},{0,1,1,1,189,104},{0,1,1,1,189,108},{0,1,1,1,189,109},{0,1,1,1,189,110},{0,1,1,1,189,112},{0,1,1,1,189,114},{0,1,1,1,189,117},{17,0,0,1,0,189},{18,0,0,1,0,189},{19,0,0,1,0,189},{20,0,0,1,0,189},{21,0,0,1,0,189},{22,0,0,1,0,189},{23,0,0,1,0,189},{24,0,0,1,0,189},{25,0,0,1,0,189},{26,0,0,1,0,189},{27,0,0,1,0,189},{28,0,0,1,0,189},{29,0,0,1,0,189},{30,0,0,1,0,189},{31,0,0,1,0,189},{32,0,0,1,0,189},{33,0,0,1,0,189},{34,1,0,1,0,189},{13,0,1,1,190,48},{14,1,1,1,190,48},{13,0,1,1,190,49},{14,1,1,1,190,49},{13,0,1,1,190,50},{14,1,1,1,190,50},{13,0,1,1,190,97},{14,1,1,1,190,97},{13,0,1,1,190,99},{14,1,1,1,190,99},{13,0,1,1,190,101},{14,1,1,1,190,101},{13,0,1,1,190,105},{14,1,1,1,190,105},{13,0,1,1,190,111},{14,1,1,1,190,111},{13,0,1,1,190,115},{14,1,1,1,190,115},{13,0,1,1,190,116},{14,1,1,1,190,116},{0,1,1,1,190,32},{0,1,1,1,190,37},{0,1,1,1,190,45},{0,1,1,1,190,46},{0,1,1,1,190,47},{0,1,1,1,190,51},{0,1,1,1,190,52},{0,1,1,1,190,53},{0,1,1,1,190,54},{0,1,1,1,190,55},{0,1,1,1,190,56},{0,1,1,1,190,57},{0,1,1,1,190,61},{0,1,1,1,190,65},{0,1,1,1,190,95},{0,1,1,1,190,98},{0,1,1,1,190,100},{0,1,1,1,190,102},{0,1,1,1,190,103},{0,1,1,1,190,104},{0,1,1,1,190,108},{0,1,1,1,190,109},{0,1,1,1,190,110},{0,1,1,1,190,112},{0,1,1,1,190,114},{0,1,1,1,190,117},{17,0,0,1,0,190},{18,0,0,1,0,190},{19,0,0,1,0,190},{20,0,0,1,0,190},{21,0,0,1,0,190},{22,0,0,1,0,190},{23,0,0,1,0,190},{24,0,0,1,0,190},{25,0,0,1,0,190},{26,0,0,1,0,190},{27,0,0,1,0,190},{28,0,0,1,0,190},{29,0,0,1,0,190},{30,0,0,1,0,190},{31,0,0,1,0,190},{32,0,0,1,0,190},{33,0,0,1,0,190},{34,1,0,1,0,190},{13,0,1,1,196,48},{14,1,1,1,196,48},{13,0,1,1,196,49},{14,1,1,1,196,49},{13,0,1,1,196,50},{14,1,1,1,196,50},{13,0,1,1,196,97},{14,1,1,1,196,97},{13,0,1,1,196,99},{14,1,1,1,196,99},{13,0,1,1,196,101},{14,1,1,1,196,101},{13,0,1,1,196,105},{14,1,1,1,196,105},{13,0,1,1,196,111},{14,1,1,1,196,111},{13,0,1,1,196,115},{14,1,1,1,196,115},{13,0,1,1,196,116},{14,1,1,1,196,116},{0,1,1,1,196,32},{0,1,1,1,196,37},{0,1,1,1,196,45},{0,1,1,1,196,46},{0,1,1,1,196,47},{0,1,1,1,196,51},{0,1,1,1,196,52},{0,1,1,1,196,53},{0,1,1,1,196,54},{0,1,1,1,196,55},{0,1,1,1,196,56},{0,1,1,1,196,57},{0,1,1,1,196,61},{0,1,1,1,196,65},{0,1,1,1,196,95},{0,1,1,1,196,98},{0,1,1,1,196,100},{0,1,1,1,196,102},{0,1,1,1,196,103},{0,1,1,1,196,104},{0,1,1,1,196,108},{0,1,1,1,196,109},{0,1,1,1,196,110},{0,1,1,1,196,112},{0,1,1,1,196,114},{0,1,1,1,196,117},{17,0,0,1,0,196},{18,0,0,1,0,196},{19,0,0,1,0,196},{20,0,0,1,0,196},{21,0,0,1,0,196},{22,0,0,1,0,196},{23,0,0,1,0,196},{24,0,0,1,0,196},{25,0,0,1,0,196},{26,0,0,1,0,196},{27,0,0,1,0,196},{28,0,0,1,0,196},{29,0,0,1,0,196},{30,0,0,1,0,196},{31,0,0,1,0,196},{32,0,0,1,0,196},{33,0,0,1,0,196},{34,1,0,1,0,196},{13,0,1,1,198,48},{14,1,1,1,198,48},{13,0,1,1,198,49},{14,1,1,1,198,49},{13,0,1,1,198,50},{14,1,1,1,198,50},{13,0,1,1,198,97},{14,1,1,1,198,97},{13,0,1,1,198,99},{14,1,1,1,198,99},{13,0,1,1,198,101},{14,1,1,1,198,101},{13,0,1,1,198,105},{14,1,1,1,198,105},{13,0,1,1,198,111},{14,1,1,1,198,111},{13,0,1,1,198,115},{14,1,1,1,198,115},{13,0,1,1,198,116},{14,1,1,1,198,116},{0,1,1,1,198,32},{0,1,1,1,198,37},{0,1,1,1,198,45},{0,1,1,1,198,46},{0,1,1,1,198,47},{0,1,1,1,198,51},{0,1,1,1,198,52},{0,1,1,1,198,53},{0,1,1,1,198,54},{0,1,1,1,198,55},{0,1,1,1,198,56},{0,1,1,1,198,57},{0,1,1,1,198,61},{0,1,1,1,198,65},{0,1,1,1,198,95},{0,1,1,1,198,98},{0,1,1,1,198,100},{0,1,1,1,198,102},{0,1,1,1,198,103},{0,1,1,1,198,104},{0,1,1,1,198,108},{0,1,1,1,198,109},{0,1,1,1,198,110},{0,1,1,1,198,112},{0,1,1,1,198,114},{0,1,1,1,198,117},{17,0,0,1,0,198},{18,0,0,1,0,198},{19,0,0,1,0,198},{20,0,0,1,0,198},{21,0,0,1,0,198},{22,0,0,1,0,198},{23,0,0,1,0,198},{24,0,0,1,0,198},{25,0,0,1,0,198},{26,0,0,1,0,198},{27,0,0,1,0,198},{28,0,0,1,0,198},{29,0,0,1,0,198},{30,0,0,1,0,198},{31,0,0,1,0,198},{32,0,0,1,0,198},{33,0,0,1,0,198},{34,1,0,1,0,198},{13,0,1,1,228,48},{14,1,1,1,228,48},{13,0,1,1,228,49},{14,1,1,1,228,49},{13,0,1,1,228,50},{14,1,1,1,228,50},{13,0,1,1,228,97},{14,1,1,1,228,97},{13,0,1,1,228,99},{14,1,1,1,228,99},{13,0,1,1,228,101},{14,1,1,1,228,101},{13,0,1,1,228,105},{14,1,1,1,228,105},{13,0,1,1,228,111},{14,1,1,1,228,111},{13,0,1,1,228,115},{14,1,1,1,228,115},{13,0,1,1,228,116},{14,1,1,1,228,116},{0,1,1,1,228,32},{0,1,1,1,228,37},{0,1,1,1,228,45},{0,1,1,1,228,46},{0,1,1,1,228,47},{0,1,1,1,228,51},{0,1,1,1,228,52},{0,1,1,1,228,53},{0,1,1,1,228,54},{0,1,1,1,228,55},{0,1,1,1,228,56},{0,1,1,1,228,57},{0,1,1,1,228,61},{0,1,1,1,228,65},{0,1,1,1,228,95},{0,1,1,1,228,98},{0,1,1,1,228,100},{0,1,1,1,228,102},{0,1,1,1,228,103},{0,1,1,1,228,104},{0,1,1,1,228,108},{0,1,1,1,228,109},{0,1,1,1,228,110},{0,1,1,1,228,112},{0,1,1,1,228,114},{0,1,1,1,228,117},{17,0,0,1,0,228},{18,0,0,1,0,228},{19,0,0,1,0,228},{20,0,0,1,0,228},{21,0,0,1,0,228},{22,0,0,1,0,228},{23,0,0,1,0,228},{24,0,0,1,0,228},{25,0,0,1,0,228},{26,0,0,1,0,228},{27,0,0,1,0,228},{28,0,0,1,0,228},{29,0,0,1,0,228},{30,0,0,1,0,228},{31,0,0,1,0,228},{32,0,0,1,0,228},{33,0,0,1,0,228},{34,1,0,1,0,228},{13,0,1,1,232,48},{14,1,1,1,232,48},{13,0,1,1,232,49},{14,1,1,1,232,49},{13,0,1,1,232,50},{14,1,1,1,232,50},{13,0,1,1,232,97},{14,1,1,1,232,97},{13,0,1,1,232,99},{14,1,1,1,232,99},{13,0,1,1,232,101},{14,1,1,1,232,101},{13,0,1,1,232,105},{14,1,1,1,232,105},{13,0,1,1,232,111},{14,1,1,1,232,111},{13,0,1,1,232,115},{14,1,1,1,232,115},{13,0,1,1,232,116},{14,1,1,1,232,116},{0,1,1,1,232,32},{0,1,1,1,232,37},{0,1,1,1,232,45},{0,1,1,1,232,46},{0,1,1,1,232,47},{0,1,1,1,232,51},{0,1,1,1,232,52},{0,1,1,1,232,53},{0,1,1,1,232,54},{0,1,1,1,232,55},{0,1,1,1,232,56},{0,1,1,1,232,57},{0,1,1,1,232,61},{0,1,1,1,232,65},{0,1,1,1,232,95},{0,1,1,1,232,98},{0,1,1,1,232,100},{0,1,1,1,232,102},{0,1,1,1,232,103},{0,1,1,1,232,104},{0,1,1,1,232,108},{0,1,1,1,232,109},{0,1,1,1,232,110},{0,1,1,1,232,112},{0,1,1,1,232,114},{0,1,1,1,232,117},{17,0,0,1,0,232},{18,0,0,1,0,232},{19,0,0,1,0,232},{20,0,0,1,0,232},{21,0,0,1,0,232},{22,0,0,1,0,232},{23,0,0,1,0,232},{24,0,0,1,0,232},{25,0,0,1,0,232},{26,0,0,1,0,232},{27,0,0,1,0,232},{28,0,0,1,0,232},{29,0,0,1,0,232},{30,0,0,1,0,232},{31,0,0,1,0,232},{32,0,0,1,0,232},{33,0,0,1,0,232},{34,1,0,1,0,232},{13,0,1,1,233,48},{14,1,1,1,233,48},{13,0,1,1,233,49},{14,1,1,1,233,49},{13,0,1,1,233,50},{14,1,1,1,233,50},{13,0,1,1,233,97},{14,1,1,1,233,97},{13,0,1,1,233,99},{14,1,1,1,233,99},{13,0,1,1,233,101},{14,1,1,1,233,101},{13,0,1,1,233,105},{14,1,1,1,233,105},{13,0,1,1,233,111},{14,1,1,1,233,111},{13,0,1,1,233,115},{14,1,1,1,233,115},{13,0,1,1,233,116},{14,1,1,1,233,116},{0,1,1,1,233,32},{0,1,1,1,233,37},{0,1,1,1,233,45},{0,1,1,1,233,46},{0,1,1,1,233,47},{0,1,1,1,233,51},{0,1,1,1,233,52},{0,1,1,1,233,53},{0,1,1,1,233,54},{0,1,1,1,233,55},{0,1,1,1,233,56},{0,1,1,1,233,57},{0,1,1,1,233,61},{0,1,1,1,233,65},{0,1,1,1,233,95},{0,1,1,1,233,98},{0,1,1,1,233,100},{0,1,1,1,233,102},{0,1,1,1,233,103},{0,1,1,1,233,104},{0,1,1,1,233,108},{0,1,1,1,233,109},{0,1,1,1,233,110},{0,1,1,1,233,112},{0,1,1,1,233,114},{0,1,1,1,233,117},{17,0,0,1,0,233},{18,0,0,1,0,233},{19,0,0,1,0,233},{20,0,0,1,0,233},{21,0,0,1,0,233},{22,0,0,1,0,233},{23,0,0,1,0,233},{24,0,0,1,0,233},{25,0,0,1,0,233},{26,0,0,1,0,233},{27,0,0,1,0,233},{28,0,0,1,0,233},{29,0,0,1,0,233},{30,0,0,1,0,233},{31,0,0,1,0,233},{32,0,0,1,0,233},{33,0,0,1,0,233},{34,1,0,1,0,233},{0,1,1,1,1,48},{0,1,1,1,1,49},{0,1,1,1,1,50},{0,1,1,1,1,97},{0,1,1,1,1,99},{0,1,1,1,1,101},{0,1,1,1,1,105},{0,1,1,1,1,111},{0,1,1,1,1,115},{0,1,1,1,1,116},{35,0,0,1,0,1},{36,0,0,1,0,1},{37,0,0,1,0,1},{38,0,0,1,0,1},{39,0,0,1,0,1},{40,0,0,1,0,1},{41,0,0,1,0,1},{42,0,0,1,0,1},{43,0,0,1,0,1},{44,0,0,1,0,1},{45,0,0,1,0,1},{46,0,0,1,0,1},{47,0,0,1,0,1},{48,0,0,1,0,1},{49,0,0,1,0,1},{50,0,0,1,0,1},{51,0,0,1,0,1},{52,0,0,1,0,1},{53,0,0,1,0,1},{54,0,0,1,0,1},{55,0,0,1,0,1},{56,1,0,1,0,1},{0,1,1,1,135,48},{0,1,1,1,135,49},{0,1,1,1,135,50},{0,1,1,1,135,97},{0,1,1,1,135,99},{0,1,1,1,135,101},{0,1,1,1,135,105},{0,1,1,1,135,111},{0,1,1,1,135,115},{0,1,1,1,135,116},{35,0,0,1,0,135},{36,0,0,1,0,135},{37,0,0,1,0,135},{38,0,0,1,0,135},{39,0,0,1,0,135},{40,0,0,1,0,135},{41,0,0,1,0,135},{42,0,0,1,0,135},{43,0,0,1,0,135},{44,0,0,1,0,135},{45,0,0,1,0,135},{46,0,0,1,0,135},{47,0,0,1,0,135},{48,0,0,1,0,135},{49,0,0,1,0,135},{50,0,0,1,0,135},{51,0,0,1,0,135},{52,0,0,1,0,135},{53,0,0,1,0,135},{54,0,0,1,0,135},{55,0,0,1,0,135},{56,1,0,1,0,135},{0,1,1,1,137,48},{0,1,1,1,137,49},{0,1,1,1,137,50},{0,1,1,1,137,97},{0,1,1,1,137,99},{0,1,1,1,137,101},{0,1,1,1,137,105},{0,1,1,1,137,111},{0,1,1,1,137,115},{0,1,1,1,137,116},{35,0,0,1,0,137},{36,0,0,1,0,137},{37,0,0,1,0,137},{38,0,0,1,0,137},{39,0,0,1,0,137},{40,0,0,1,0,137},{41,0,0,1,0,137},{42,0,0,1,0,137},{43,0,0,1,0,137},{44,0,0,1,0,137},{45,0,0,1,0,137},{46,0,0,1,0,137},{47,0,0,1,0,137},{48,0,0,1,0,137},{49,0,0,1,0,137},{50,0,0,1,0,137},{51,0,0,1,0,137},{52,0,0,1,0,137},{53,0,0,1,0,137},{54,0,0,1,0,137},{55,0,0,1,0,137},{56,1,0,1,0,137},{0,1,1,1,138,48},{0,1,1,1,138,49},{0,1,1,1,138,50},{0,1,1,1,138,97},{0,1,1,1,138,99},{0,1,1,1,138,101},{0,1,1,1,138,105},{0,1,1,1,138,111},{0,1,1,1,138,115},{0,1,1,1,138,116},{35,0,0,1,0,138},{36,0,0,1,0,138},{37,0,0,1,0,138},{38,0,0,1,0,138},{39,0,0,1,0,138},{40,0,0,1,0,138},{41,0,0,1,0,138},{42,0,0,1,0,138},{43,0,0,1,0,138},{44,0,0,1,0,138},{45,0,0,1,0,138},{46,0,0,1,0,138},{47,0,0,1,0,138},{48,0,0,1,0,138},{49,0,0,1,0,138},{50,0,0,1,0,138},{51,0,0,1,0,138},{52,0,0,1,0,138},{53,0,0,1,0,138},{54,0,0,1,0,138},{55,0,0,1,0,138},{56,1,0,1,0,138},{0,1,1,1,139,48},{0,1,1,1,139,49},{0,1,1,1,139,50},{0,1,1,1,139,97},{0,1,1,1,139,99},{0,1,1,1,139,101},{0,1,1,1,139,105},{0,1,1,1,139,111},{0,1,1,1,139,115},{0,1,1,1,139,116},{35,0,0,1,0,139},{36,0,0,1,0,139},{37,0,0,1,0,139},{38,0,0,1,0,139},{39,0,0,1,0,139},{40,0,0,1,0,139},{41,0,0,1,0,139},{42,0,0,1,0,139},{43,0,0,1,0,139},{44,0,0,1,0,139},{45,0,0,1,0,139},{46,0,0,1,0,139},{47,0,0,1,0,139},{48,0,0,1,0,139},{49,0,0,1,0,139},{50,0,0,1,0,139},{51,0,0,1,0,139},{52,0,0,1,0,139},{53,0,0,1,0,139},{54,0,0,1,0,139},{55,0,0,1,0,139},{56,1,0,1,0,139},{0,1,1,1,140,48},{0,1,1,1,140,49},{0,1,1,1,140,50},{0,1,1,1,140,97},{0,1,1,1,140,99},{0,1,1,1,140,101},{0,1,1,1,140,105},{0,1,1,1,140,111},{0,1,1,1,140,115},{0,1,1,1,140,116},{35,0,0,1,0,140},{36,0,0,1,0,140},{37,0,0,1,0,140},{38,0,0,1,0,140},{39,0,0,1,0,140},{40,0,0,1,0,140},{41,0,0,1,0,140},{42,0,0,1,0,140},{43,0,0,1,0,140},{44,0,0,1,0,140},{45,0,0,1,0,140},{46,0,0,1,0,140},{47,0,0,1,0,140},{48,0,0,1,0,140},{49,0,0,1,0,140},{50,0,0,1,0,140},{51,0,0,1,0,140},{52,0,0,1,0,140},{53,0,0,1,0,140},{54,0,0,1,0,140},{55,0,0,1,0,140},{56,1,0,1,0,140},{0,1,1,1,141,48},{0,1,1,1,141,49},{0,1,1,1,141,50},{0,1,1,1,141,97},{0,1,1,1,141,99},{0,1,1,1,141,101},{0,1,1,1,141,105},{0,1,1,1,141,111},{0,1,1,1,141,115},{0,1,1,1,141,116},{35,0,0,1,0,141},{36,0,0,1,0,141},{37,0,0,1,0,141},{38,0,0,1,0,141},{39,0,0,1,0,141},{40,0,0,1,0,141},{41,0,0,1,0,141},{42,0,0,1,0,141},{43,0,0,1,0,141},{44,0,0,1,0,141},{45,0,0,1,0,141},{46,0,0,1,0,141},{47,0,0,1,0,141},{48,0,0,1,0,141},{49,0,0,1,0,141},{50,0,0,1,0,141},{51,0,0,1,0,141},{52,0,0,1,0,141},{53,0,0,1,0,141},{54,0,0,1,0,141},{55,0,0,1,0,141},{56,1,0,1,0,141},{0,1,1,1,143,48},{0,1,1,1,143,49},{0,1,1,1,143,50},{0,1,1,1,143,97},{0,1,1,1,143,99},{0,1,1,1,143,101},{0,1,1,1,143,105},{0,1,1,1,143,111},{0,1,1,1,143,115},{0,1,1,1,143,116},{35,0,0,1,0,143},{36,0,0,1,0,143},{37,0,0,1,0,143},{38,0,0,1,0,143},{39,0,0,1,0,143},{40,0,0,1,0,143},{41,0,0,1,0,143},{42,0,0,1,0,143},{43,0,0,1,0,143},{44,0,0,1,0,143},{45,0,0,1,0,143},{46,0,0,1,0,143},{47,0,0,1,0,143},{48,0,0,1,0,143},{49,0,0,1,0,143},{50,0,0,1,0,143},{51,0,0,1,0,143},{52,0,0,1,0,143},{53,0,0,1,0,143},{54,0,0,1,0,143},{55,0,0,1,0,143},{56,1,0,1,0,143},{0,1,1,1,147,48},{0,1,1,1,147,49},{0,1,1,1,147,50},{0,1,1,1,147,97},{0,1,1,1,147,99},{0,1,1,1,147,101},{0,1,1,1,147,105},{0,1,1,1,147,111},{0,1,1,1,147,115},{0,1,1,1,147,116},{35,0,0,1,0,147},{36,0,0,1,0,147},{37,0,0,1,0,147},{38,0,0,1,0,147},{39,0,0,1,0,147},{40,0,0,1,0,147},{41,0,0,1,0,147},{42,0,0,1,0,147},{43,0,0,1,0,147},{44,0,0,1,0,147},{45,0,0,1,0,147},{46,0,0,1,0,147},{47,0,0,1,0,147},{48,0,0,1,0,147},{49,0,0,1,0,147},{50,0,0,1,0,147},{51,0,0,1,0,147},{52,0,0,1,0,147},{53,0,0,1,0,147},{54,0,0,1,0,147},{55,0,0,1,0,147},{56,1,0,1,0,147},{0,1,1,1,149,48},{0,1,1,1,149,49},{0,1,1,1,149,50},{0,1,1,1,149,97},{0,1,1,1,149,99},{0,1,1,1,149,101},{0,1,1,1,149,105},{0,1,1,1,149,111},{0,1,1,1,149,115},{0,1,1,1,149,116},{35,0,0,1,0,149},{36,0,0,1,0,149},{37,0,0,1,0,149},{38,0,0,1,0,149},{39,0,0,1,0,149},{40,0,0,1,0,149},{41,0,0,1,0,149},{42,0,0,1,0,149},{43,0,0,1,0,149},{44,0,0,1,0,149},{45,0,0,1,0,149},{46,0,0,1,0,149},{47,0,0,1,0,149},{48,0,0,1,0,149},{49,0,0,1,0,149},{50,0,0,1,0,149},{51,0,0,1,0,149},{52,0,0,1,0,149},{53,0,0,1,0,149},{54,0,0,1,0,149},{55,0,0,1,0,149},{56,1,0,1,0,149},{0,1,1,1,150,48},{0,1,1,1,150,49},{0,1,1,1,150,50},{0,1,1,1,150,97},{0,1,1,1,150,99},{0,1,1,1,150,101},{0,1,1,1,150,105},{0,1,1,1,150,111},{0,1,1,1,150,115},{0,1,1,1,150,116},{35,0,0,1,0,150},{36,0,0,1,0,150},{37,0,0,1,0,150},{38,0,0,1,0,150},{39,0,0,1,0,150},{40,0,0,1,0,150},{41,0,0,1,0,150},{42,0,0,1,0,150},{43,0,0,1,0,150},{44,0,0,1,0,150},{45,0,0,1,0,150},{46,0,0,1,0,150},{47,0,0,1,0,150},{48,0,0,1,0,150},{49,0,0,1,0,150},{50,0,0,1,0,150},{51,0,0,1,0,150},{52,0,0,1,0,150},{53,0,0,1,0,150},{54,0,0,1,0,150},{55,0,0,1,0,150},{56,1,0,1,0,150},{0,1,1,1,151,48},{0,1,1,1,151,49},{0,1,1,1,151,50},{0,1,1,1,151,97},{0,1,1,1,151,99},{0,1,1,1,151,101},{0,1,1,1,151,105},{0,1,1,1,151,111},{0,1,1,1,151,115},{0,1,1,1,151,116},{35,0,0,1,0,151},{36,0,0,1,0,151},{37,0,0,1,0,151},{38,0,0,1,0,151},{39,0,0,1,0,151},{40,0,0,1,0,151},{41,0,0,1,0,151},{42,0,0,1,0,151},{43,0,0,1,0,151},{44,0,0,1,0,151},{45,0,0,1,0,151},{46,0,0,1,0,151},{47,0,0,1,0,151},{48,0,0,1,0,151},{49,0,0,1,0,151},{50,0,0,1,0,151},{51,0,0,1,0,151},{52,0,0,1,0,151},{53,0,0,1,0,151},{54,0,0,1,0,151},{55,0,0,1,0,151},{56,1,0,1,0,151},{0,1,1,1,152,48},{0,1,1,1,152,49},{0,1,1,1,152,50},{0,1,1,1,152,97},{0,1,1,1,152,99},{0,1,1,1,152,101},{0,1,1,1,152,105},{0,1,1,1,152,111},{0,1,1,1,152,115},{0,1,1,1,152,116},{35,0,0,1,0,152},{36,0,0,1,0,152},{37,0,0,1,0,152},{38,0,0,1,0,152},{39,0,0,1,0,152},{40,0,0,1,0,152},{41,0,0,1,0,152},{42,0,0,1,0,152},{43,0,0,1,0,152},{44,0,0,1,0,152},{45,0,0,1,0,152},{46,0,0,1,0,152},{47,0,0,1,0,152},{48,0,0,1,0,152},{49,0,0,1,0,152},{50,0,0,1,0,152},{51,0,0,1,0,152},{52,0,0,1,0,152},{53,0,0,1,0,152},{54,0,0,1,0,152},{55,0,0,1,0,152},{56,1,0,1,0,152},{0,1,1,1,155,48},{0,1,1,1,155,49},{0,1,1,1,155,50},{0,1,1,1,155,97},{0,1,1,1,155,99},{0,1,1,1,155,101},{0,1,1,1,155,105},{0,1,1,1,155,111},{0,1,1,1,155,115},{0,1,1,1,155,116},{35,0,0,1,0,155},{36,0,0,1,0,155},{37,0,0,1,0,155},{38,0,0,1,0,155},{39,0,0,1,0,155},{40,0,0,1,0,155},{41,0,0,1,0,155},{42,0,0,1,0,155},{43,0,0,1,0,155},{44,0,0,1,0,155},{45,0,0,1,0,155},{46,0,0,1,0,155},{47,0,0,1,0,155},{48,0,0,1,0,155},{49,0,0,1,0,155},{50,0,0,1,0,155},{51,0,0,1,0,155},{52,0,0,1,0,155},{53,0,0,1,0,155},{54,0,0,1,0,155},{55,0,0,1,0,155},{56,1,0,1,0,155},{0,1,1,1,157,48},{0,1,1,1,157,49},{0,1,1,1,157,50},{0,1,1,1,157,97},{0,1,1,1,157,99},{0,1,1,1,157,101},{0,1,1,1,157,105},{0,1,1,1,157,111},{0,1,1,1,157,115},{0,1,1,1,157,116},{35,0,0,1,0,157},{36,0,0,1,0,157},{37,0,0,1,0,157},{38,0,0,1,0,157},{39,0,0,1,0,157},{40,0,0,1,0,157},{41,0,0,1,0,157},{42,0,0,1,0,157},{43,0,0,1,0,157},{44,0,0,1,0,157},{45,0,0,1,0,157},{46,0,0,1,0,157},{47,0,0,1,0,157},{48,0,0,1,0,157},{49,0,0,1,0,157},{50,0,0,1,0,157},{51,0,0,1,0,157},{52,0,0,1,0,157},{53,0,0,1,0,157},{54,0,0,1,0,157},{55,0,0,1,0,157},{56,1,0,1,0,157},{0,1,1,1,158,48},{0,1,1,1,158,49},{0,1,1,1,158,50},{0,1,1,1,158,97},{0,1,1,1,158,99},{0,1,1,1,158,101},{0,1,1,1,158,105},{0,1,1,1,158,111},{0,1,1,1,158,115},{0,1,1,1,158,116},{35,0,0,1,0,158},{36,0,0,1,0,158},{37,0,0,1,0,158},{38,0,0,1,0,158},{39,0,0,1,0,158},{40,0,0,1,0,158},{41,0,0,1,0,158},{42,0,0,1,0,158},{43,0,0,1,0,158},{44,0,0,1,0,158},{45,0,0,1,0,158},{46,0,0,1,0,158},{47,0,0,1,0,158},{48,0,0,1,0,158},{49,0,0,1,0,158},{50,0,0,1,0,158},{51,0,0,1,0,158},{52,0,0,1,0,158},{53,0,0,1,0,158},{54,0,0,1,0,158},{55,0,0,1,0,158},{56,1,0,1,0,158},{0,1,1,1,165,48},{0,1,1,1,165,49},{0,1,1,1,165,50},{0,1,1,1,165,97},{0,1,1,1,165,99},{0,1,1,1,165,101},{0,1,1,1,165,105},{0,1,1,1,165,111},{0,1,1,1,165,115},{0,1,1,1,165,116},{35,0,0,1,0,165},{36,0,0,1,0,165},{37,0,0,1,0,165},{38,0,0,1,0,165},{39,0,0,1,0,165},{40,0,0,1,0,165},{41,0,0,1,0,165},{42,0,0,1,0,165},{43,0,0,1,0,165},{44,0,0,1,0,165},{45,0,0,1,0,165},{46,0,0,1,0,165},{47,0,0,1,0,165},{48,0,0,1,0,165},{49,0,0,1,0,165},{50,0,0,1,0,165},{51,0,0,1,0,165},{52,0,0,1,0,165},{53,0,0,1,0,165},{54,0,0,1,0,165},{55,0,0,1,0,165},{56,1,0,1,0,165},{0,1,1,1,166,48},{0,1,1,1,166,49},{0,1,1,1,166,50},{0,1,1,1,166,97},{0,1,1,1,166,99},{0,1,1,1,166,101},{0,1,1,1,166,105},{0,1,1,1,166,111},{0,1,1,1,166,115},{0,1,1,1,166,116},{35,0,0,1,0,166},{36,0,0,1,0,166},{37,0,0,1,0,166},{38,0,0,1,0,166},{39,0,0,1,0,166},{40,0,0,1,0,166},{41,0,0,1,0,166},{42,0,0,1,0,166},{43,0,0,1,0,166},{44,0,0,1,0,166},{45,0,0,1,0,166},{46,0,0,1,0,166},{47,0,0,1,0,166},{48,0,0,1,0,166},{49,0,0,1,0,166},{50,0,0,1,0,166},{51,0,0,1,0,166},{52,0,0,1,0,166},{53,0,0,1,0,166},{54,0,0,1,0,166},{55,0,0,1,0,166},{56,1,0,1,0,166},{0,1,1,1,168,48},{0,1,1,1,168,49},{0,1,1,1,168,50},{0,1,1,1,168,97},{0,1,1,1,168,99},{0,1,1,1,168,101},{0,1,1,1,168,105},{0,1,1,1,168,111},{0,1,1,1,168,115},{0,1,1,1,168,116},{35,0,0,1,0,168},{36,0,0,1,0,168},{37,0,0,1,0,168},{38,0,0,1,0,168},{39,0,0,1,0,168},{40,0,0,1,0,168},{41,0,0,1,0,168},{42,0,0,1,0,168},{43,0,0,1,0,168},{44,0,0,1,0,168},{45,0,0,1,0,168},{46,0,0,1,0,168},{47,0,0,1,0,168},{48,0,0,1,0,168},{49,0,0,1,0,168},{50,0,0,1,0,168},{51,0,0,1,0,168},{52,0,0,1,0,168},{53,0,0,1,0,168},{54,0,0,1,0,168},{55,0,0,1,0,168},{56,1,0,1,0,168},{0,1,1,1,174,48},{0,1,1,1,174,49},{0,1,1,1,174,50},{0,1,1,1,174,97},{0,1,1,1,174,99},{0,1,1,1,174,101},{0,1,1,1,174,105},{0,1,1,1,174,111},{0,1,1,1,174,115},{0,1,1,1,174,116},{35,0,0,1,0,174},{36,0,0,1,0,174},{37,0,0,1,0,174},{38,0,0,1,0,174},{39,0,0,1,0,174},{40,0,0,1,0,174},{41,0,0,1,0,174},{42,0,0,1,0,174},{43,0,0,1,0,174},{44,0,0,1,0,174},{45,0,0,1,0,174},{46,0,0,1,0,174},{47,0,0,1,0,174},{48,0,0,1,0,174},{49,0,0,1,0,174},{50,0,0,1,0,174},{51,0,0,1,0,174},{52,0,0,1,0,174},{53,0,0,1,0,174},{54,0,0,1,0,174},{55,0,0,1,0,174},{56,1,0,1,0,174},{0,1,1,1,175,48},{0,1,1,1,175,49},{0,1,1,1,175,50},{0,1,1,1,175,97},{0,1,1,1,175,99},{0,1,1,1,175,101},{0,1,1,1,175,105},{0,1,1,1,175,111},{0,1,1,1,175,115},{0,1,1,1,175,116},{35,0,0,1,0,175},{36,0,0,1,0,175},{37,0,0,1,0,175},{38,0,0,1,0,175},{39,0,0,1,0,175},{40,0,0,1,0,175},{41,0,0,1,0,175},{42,0,0,1,0,175},{43,0,0,1,0,175},{44,0,0,1,0,175},{45,0,0,1,0,175},{46,0,0,1,0,175},{47,0,0,1,0,175},{48,0,0,1,0,175},{49,0,0,1,0,175},{50,0,0,1,0,175},{51,0,0,1,0,175},{52,0,0,1,0,175},{53,0,0,1,0,175},{54,0,0,1,0,175},{55,0,0,1,0,175},{56,1,0,1,0,175},{0,1,1,1,180,48},{0,1,1,1,180,49},{0,1,1,1,180,50},{0,1,1,1,180,97},{0,1,1,1,180,99},{0,1,1,1,180,101},{0,1,1,1,180,105},{0,1,1,1,180,111},{0,1,1,1,180,115},{0,1,1,1,180,116},{35,0,0,1,0,180},{36,0,0,1,0,180},{37,0,0,1,0,180},{38,0,0,1,0,180},{39,0,0,1,0,180},{40,0,0,1,0,180},{41,0,0,1,0,180},{42,0,0,1,0,180},{43,0,0,1,0,180},{44,0,0,1,0,180},{45,0,0,1,0,180},{46,0,0,1,0,180},{47,0,0,1,0,180},{48,0,0,1,0,180},{49,0,0,1,0,180},{50,0,0,1,0,180},{51,0,0,1,0,180},{52,0,0,1,0,180},{53,0,0,1,0,180},{54,0,0,1,0,180},{55,0,0,1,0,180},{56,1,0,1,0,180},{0,1,1,1,182,48},{0,1,1,1,182,49},{0,1,1,1,182,50},{0,1,1,1,182,97},{0,1,1,1,182,99},{0,1,1,1,182,101},{0,1,1,1,182,105},{0,1,1,1,182,111},{0,1,1,1,182,115},{0,1,1,1,182,116},{35,0,0,1,0,182},{36,0,0,1,0,182},{37,0,0,1,0,182},{38,0,0,1,0,182},{39,0,0,1,0,182},{40,0,0,1,0,182},{41,0,0,1,0,182},{42,0,0,1,0,182},{43,0,0,1,0,182},{44,0,0,1,0,182},{45,0,0,1,0,182},{46,0,0,1,0,182},{47,0,0,1,0,182},{48,0,0,1,0,182},{49,0,0,1,0,182},{50,0,0,1,0,182},{51,0,0,1,0,182},{52,0,0,1,0,182},{53,0,0,1,0,182},{54,0,0,1,0,182},{55,0,0,1,0,182},{56,1,0,1,0,182},{0,1,1,1,183,48},{0,1,1,1,183,49},{0,1,1,1,183,50},{0,1,1,1,183,97},{0,1,1,1,183,99},{0,1,1,1,183,101},{0,1,1,1,183,105},{0,1,1,1,183,111},{0,1,1,1,183,115},{0,1,1,1,183,116},{35,0,0,1,0,183},{36,0,0,1,0,183},{37,0,0,1,0,183},{38,0,0,1,0,183},{39,0,0,1,0,183},{40,0,0,1,0,183},{41,0,0,1,0,183},{42,0,0,1,0,183},{43,0,0,1,0,183},{44,0,0,1,0,183},{45,0,0,1,0,183},{46,0,0,1,0,183},{47,0,0,1,0,183},{48,0,0,1,0,183},{49,0,0,1,0,183},{50,0,0,1,0,183},{51,0,0,1,0,183},{52,0,0,1,0,183},{53,0,0,1,0,183},{54,0,0,1,0,183},{55,0,0,1,0,183},{56,1,0,1,0,183},{0,1,1,1,188,48},{0,1,1,1,188,49},{0,1,1,1,188,50},{0,1,1,1,188,97},{0,1,1,1,188,99},{0,1,1,1,188,101},{0,1,1,1,188,105},{0,1,1,1,188,111},{0,1,1,1,188,115},{0,1,1,1,188,116},{35,0,0,1,0,188},{36,0,0,1,0,188},{37,0,0,1,0,188},{38,0,0,1,0,188},{39,0,0,1,0,188},{40,0,0,1,0,188},{41,0,0,1,0,188},{42,0,0,1,0,188},{43,0,0,1,0,188},{44,0,0,1,0,188},{45,0,0,1,0,188},{46,0,0,1,0,188},{47,0,0,1,0,188},{48,0,0,1,0,188},{49,0,0,1,0,188},{50,0,0,1,0,188},{51,0,0,1,0,188},{52,0,0,1,0,188},{53,0,0,1,0,188},{54,0,0,1,0,188},{55,0,0,1,0,188},{56,1,0,1,0,188},{0,1,1,1,191,48},{0,1,1,1,191,49},{0,1,1,1,191,50},{0,1,1,1,191,97},{0,1,1,1,191,99},{0,1,1,1,191,101},{0,1,1,1,191,105},{0,1,1,1,191,111},{0,1,1,1,191,115},{0,1,1,1,191,116},{35,0,0,1,0,191},{36,0,0,1,0,191},{37,0,0,1,0,191},{38,0,0,1,0,191},{39,0,0,1,0,191},{40,0,0,1,0,191},{41,0,0,1,0,191},{42,0,0,1,0,191},{43,0,0,1,0,191},{44,0,0,1,0,191},{45,0,0,1,0,191},{46,0,0,1,0,191},{47,0,0,1,0,191},{48,0,0,1,0,191},{49,0,0,1,0,191},{50,0,0,1,0,191},{51,0,0,1,0,191},{52,0,0,1,0,191},{53,0,0,1,0,191},{54,0,0,1,0,191},{55,0,0,1,0,191},{56,1,0,1,0,191},{0,1,1,1,197,48},{0,1,1,1,197,49},{0,1,1,1,197,50},{0,1,1,1,197,97},{0,1,1,1,197,99},{0,1,1,1,197,101},{0,1,1,1,197,105},{0,1,1,1,197,111},{0,1,1,1,197,115},{0,1,1,1,197,116},{35,0,0,1,0,197},{36,0,0,1,0,197},{37,0,0,1,0,197},{38,0,0,1,0,197},{39,0,0,1,0,197},{40,0,0,1,0,197},{41,0,0,1,0,197},{42,0,0,1,0,197},{43,0,0,1,0,197},{44,0,0,1,0,197},{45,0,0,1,0,197},{46,0,0,1,0,197},{47,0,0,1,0,197},{48,0,0,1,0,197},{49,0,0,1,0,197},{50,0,0,1,0,197},{51,0,0,1,0,197},{52,0,0,1,0,197},{53,0,0,1,0,197},{54,0,0,1,0,197},{55,0,0,1,0,197},{56,1,0,1,0,197},{0,1,1,1,231,48},{0,1,1,1,231,49},{0,1,1,1,231,50},{0,1,1,1,231,97},{0,1,1,1,231,99},{0,1,1,1,231,101},{0,1,1,1,231,105},{0,1,1,1,231,111},{0,1,1,1,231,115},{0,1,1,1,231,116},{35,0,0,1,0,231},{36,0,0,1,0,231},{37,0,0,1,0,231},{38,0,0,1,0,231},{39,0,0,1,0,231},{40,0,0,1,0,231},{41,0,0,1,0,231},{42,0,0,1,0,231},{43,0,0,1,0,231},{44,0,0,1,0,231},{45,0,0,1,0,231},{46,0,0,1,0,231},{47,0,0,1,0,231},{48,0,0,1,0,231},{49,0,0,1,0,231},{50,0,0,1,0,231},{51,0,0,1,0,231},{52,0,0,1,0,231},{53,0,0,1,0,231},{54,0,0,1,0,231},{55,0,0,1,0,231},{56,1,0,1,0,231},{0,1,1,1,239,48},{0,1,1,1,239,49},{0,1,1,1,239,50},{0,1,1,1,239,97},{0,1,1,1,239,99},{0,1,1,1,239,101},{0,1,1,1,239,105},{0,1,1,1,239,111},{0,1,1,1,239,115},{0,1,1,1,239,116},{35,0,0,1,0,239},{36,0,0,1,0,239},{37,0,0,1,0,239},{38,0,0,1,0,239},{39,0,0,1,0,239},{40,0,0,1,0,239},{41,0,0,1,0,239},{42,0,0,1,0,239},{43,0,0,1,0,239},{44,0,0,1,0,239},{45,0,0,1,0,239},{46,0,0,1,0,239},{47,0,0,1,0,239},{48,0,0,1,0,239},{49,0,0,1,0,239},{50,0,0,1,0,239},{51,0,0,1,0,239},{52,0,0,1,0,239},{53,0,0,1,0,239},{54,0,0,1,0,239},{55,0,0,1,0,239},{56,1,0,1,0,239},{57,0,0,1,0,9},{58,0,0,1,0,9},{59,0,0,1,0,9},{60,0,0,1,0,9},{61,0,0,1,0,9},{62,0,0,1,0,9},{63,0,0,1,0,9},{64,0,0,1,0,9},{65,0,0,1,0,9},{66,0,0,1,0,9},{67,0,0,1,0,9},{68,0,0,1,0,9},{69,0,0,1,0,9},{70,0,0,1,0,9},{71,0,0,1,0,9},{72,1,0,1,0,9},{57,0,0,1,0,142},{58,0,0,1,0,142},{59,0,0,1,0,142},{60,0,0,1,0,142},{61,0,0,1,0,142},{62,0,0,1,0,142},{63,0,0,1,0,142},{64,0,0,1,0,142},{65,0,0,1,0,142},{66,0,0,1,0,142},{67,0,0,1,0,142},{68,0,0,1,0,142},{69,0,0,1,0,142},{70,0,0,1,0,142},{71,0,0,1,0,142},{72,1,0,1,0,142},{57,0,0,1,0,144},{58,0,0,1,0,144},{59,0,0,1,0,144},{60,0,0,1,0,144},{61,0,0,1,0,144},{62,0,0,1,0,144},{63,0,0,1,0,144},{64,0,0,1,0,144},{65,0,0,1,0,144},{66,0,0,1,0,144},{67,0,0,1,0,144},{68,0,0,1,0,144},{69,0,0,1,0,144},{70,0,0,1,0,144},{71,0,0,1,0,144},{72,1,0,1,0,144},{57,0,0,1,0,145},{58,0,0,1,0,145},{59,0,0,1,0,145},{60,0,0,1,0,145},{61,0,0,1,0,145},{62,0,0,1,0,145},{63,0,0,1,0,145},{64,0,0,1,0,145},{65,0,0,1,0,145},{66,0,0,1,0,145},{67,0,0,1,0,145},{68,0,0,1,0,145},{69,0,0,1,0,145},{70,0,0,1,0,145},{71,0,0,1,0,145},{72,1,0,1,0,145},{57,0,0,1,0,148},{58,0,0,1,0,148},{59,0,0,1,0,148},{60,0,0,1,0,148},{61,0,0,1,0,148},{62,0,0,1,0,148},{63,0,0,1,0,148},{64,0,0,1,0,148},{65,0,0,1,0,148},{66,0,0,1,0,148},{67,0,0,1,0,148},{68,0,0,1,0,148},{69,0,0,1,0,148},{70,0,0,1,0,148},{71,0,0,1,0,148},{72,1,0,1,0,148},{57,0,0,1,0,159},{58,0,0,1,0,159},{59,0,0,1,0,159},{60,0,0,1,0,159},{61,0,0,1,0,159},{62,0,0,1,0,159},{63,0,0,1,0,159},{64,0,0,1,0,159},{65,0,0,1,0,159},{66,0,0,1,0,159},{67,0,0,1,0,159},{68,0,0,1,0,159},{69,0,0,1,0,159},{70,0,0,1,0,159},{71,0,0,1,0,159},{72,1,0,1,0,159},{57,0,0,1,0,171},{58,0,0,1,0,171},{59,0,0,1,0,171},{60,0,0,1,0,171},{61,0,0,1,0,171},{62,0,0,1,0,171},{63,0,0,1,0,171},{64,0,0,1,0,171},{65,0,0,1,0,171},{66,0,0,1,0,171},{67,0,0,1,0,171},{68,0,0,1,0,171},{69,0,0,1,0,171},{70,0,0,1,0,171},{71,0,0,1,0,171},{72,1,0,1,0,171},{57,0,0,1,0,206},{58,0,0,1,0,206},{59,0,0,1,0,206},{60,0,0,1,0,206},{61,0,0,1,0,206},{62,0,0,1,0,206},{63,0,0,1,0,206},{64,0,0,1,0,206},{65,0,0,1,0,206},{66,0,0,1,0,206},{67,0,0,1,0,206},{68,0,0,1,0,206},{69,0,0,1,0,206},{70,0,0,1,0,206},{71,0,0,1,0,206},{72,1,0,1,0,206},{57,0,0,1,0,215},{58,0,0,1,0,215},{59,0,0,1,0,215},{60,0,0,1,0,215},{61,0,0,1,0,215},{62,0,0,1,0,215},{63,0,0,1,0,215},{64,0,0,1,0,215},{65,0,0,1,0,215},{66,0,0,1,0,215},{67,0,0,1,0,215},{68,0,0,1,0,215},{69,0,0,1,0,215},{70,0,0,1,0,215},{71,0,0,1,0,215},{72,1,0,1,0,215},{57,0,0,1,0,225},{58,0,0,1,0,225},{59,0,0,1,0,225},{60,0,0,1,0,225},{61,0,0,1,0,225},{62,0,0,1,0,225},{63,0,0,1,0,225},{64,0,0,1,0,225},{65,0,0,1,0,225},{66,0,0,1,0,225},{67,0,0,1,0,225},{68,0,0,1,0,225},{69,0,0,1,0,225},{70,0,0,1,0,225},{71,0,0,1,0,225},{72,1,0,1,0,225},{57,0,0,1,0,236},{58,0,0,1,0,236},{59,0,0,1,0,236},{60,0,0,1,0,236},{61,0,0,1,0,236},{62,0,0,1,0,236},{63,0,0,1,0,236},{64,0,0,1,0,236},{65,0,0,1,0,236},{66,0,0,1,0,236},{67,0,0,1,0,236},{68,0,0,1,0,236},{69,0,0,1,0,236},{70,0,0,1,0,236},{71,0,0,1,0,236},{72,1,0,1,0,236},{57,0,0,1,0,237},{58,0,0,1,0,237},{59,0,0,1,0,237},{60,0,0,1,0,237},{61,0,0,1,0,237},{62,0,0,1,0,237},{63,0,0,1,0,237},{64,0,0,1,0,237},{65,0,0,1,0,237},{66,0,0,1,0,237},{67,0,0,1,0,237},{68,0,0,1,0,237},{69,0,0,1,0,237},{70,0,0,1,0,237},{71,0,0,1,0,237},{72,1,0,1,0,237},{1,0,0,1,0,199},{2,0,0,1,0,199},{3,0,0,1,0,199},{4,0,0,1,0,199},{5,0,0,1,0,199},{6,0,0,1,0,199},{7,0,0,1,0,199},{8,1,0,1,0,199},{1,0,0,1,0,207},{2,0,0,1,0,207},{3,0,0,1,0,207},{4,0,0,1,0,207},{5,0,0,1,0,207},{6,0,0,1,0,207},{7,0,0,1,0,207},{8,1,0,1,0,207},{1,0,0,1,0,234},{2,0,0,1,0,234},{3,0,0,1,0,234},{4,0,0,1,0,234},{5,0,0,1,0,234},{6,0,0,1,0,234},{7,0,0,1,0,234},{8,1,0,1,0,234},{1,0,0,1,0,235},{2,0,0,1,0,235},{3,0,0,1,0,235},{4,0,0,1,0,235},{5,0,0,1,0,235},{6,0,0,1,0,235},{7,0,0,1,0,235},{8,1,0,1,0,235},{9,0,0,1,0,192},{10,0,0,1,0,192},{11,0,0,1,0,192},{12,1,0,1,0,192},{9,0,0,1,0,193},{10,0,0,1,0,193},{11,0,0,1,0,193},{12,1,0,1,0,193},{9,0,0,1,0,200},{10,0,0,1,0,200},{11,0,0,1,0,200},{12,1,0,1,0,200},{9,0,0,1,0,201},{10,0,0,1,0,201},{11,0,0,1,0,201},{12,1,0,1,0,201},{9,0,0,1,0,202},{10,0,0,1,0,202},{11,0,0,1,0,202},{12,1,0,1,0,202},{9,0,0,1,0,205},{10,0,0,1,0,205},{11,0,0,1,0,205},{12,1,0,1,0,205},{9,0,0,1,0,210},{10,0,0,1,0,210},{11,0,0,1,0,210},{12,1,0,1,0,210},{9,0,0,1,0,213},{10,0,0,1,0,213},{11,0,0,1,0,213},{12,1,0,1,0,213},{9,0,0,1,0,218},{10,0,0,1,0,218},{11,0,0,1,0,218},{12,1,0,1,0,218},{9,0,0,1,0,219},{10,0,0,1,0,219},{11,0,0,1,0,219},{12,1,0,1,0,219},{9,0,0,1,0,238},{10,0,0,1,0,238},{11,0,0,1,0,238},{12,1,0,1,0,238},{9,0,0,1,0,240},{10,0,0,1,0,240},{11,0,0,1,0,240},{12,1,0,1,0,240},{9,0,0,1,0,242},{10,0,0,1,0,242},{11,0,0,1,0,242},{12,1,0,1,0,242},{9,0,0,1,0,243},{10,0,0,1,0,243},{11,0,0,1,0,243},{12,1,0,1,0,243},{9,0,0,1,0,255},{10,0,0,1,0,255},{11,0,0,1,0,255},{12,1,0,1,0,255},{13,0,0,1,0,203},{14,1,0,1,0,203},{13,0,0,1,0,204},{14,1,0,1,0,204},{13,0,0,1,0,211},{14,1,0,1,0,211},{13,0,0,1,0,212},{14,1,0,1,0,212},{13,0,0,1,0,214},{14,1,0,1,0,214},{13,0,0,1,0,221},{14,1,0,1,0,221},{13,0,0,1,0,222},{14,1,0,1,0,222},{13,0,0,1,0,223},{14,1,0,1,0,223},{13,0,0,1,0,241},{14,1,0,1,0,241},{13,0,0,1,0,244},{14,1,0,1,0,244},{13,0,0,1,0,245},{14,1,0,1,0,245},{13,0,0,1,0,246},{14,1,0,1,0,246},{13,0,0,1,0,247},{14,1,0,1,0,247},{13,0,0,1,0,248},{14,1,0,1,0,248},{13,0,0,1,0,250},{14,1,0,1,0,250},{13,0,0,1,0,251},{14,1,0,1,0,251},{13,0,0,1,0,252},{14,1,0,1,0,252},{13,0,0,1,0,253},{14,1,0,1,0,253},{13,0,0,1,0,254},{14,1,0,1,0,254},{0,1,0,1,0,2},{0,1,0,1,0,3},{0,1,0,1,0,4},{0,1,0,1,0,5},{0,1,0,1,0,6},{0,1,0,1,0,7},{0,1,0,1,0,8},{0,1,0,1,0,11},{0,1,0,1,0,12},{0,1,0,1,0,14},{0,1,0,1,0,15},{0,1,0,1,0,16},{0,1,0,1,0,17},{0,1,0,1,0,18},{0,1,0,1,0,19},{0,1,0,1,0,20},{0,1,0,1,0,21},{0,1,0,1,0,23},{0,1,0,1,0,24},{0,1,0,1,0,25},{0,1,0,1,0,26},{0,1,0,1,0,27},{0,1,0,1,0,28},{0,1,0,1,0,29},{0,1,0,1,0,30},{0,1,0,1,0,31},{0,1,0,1,0,127},{0,1,0,1,0,220},{0,1,0,1,0,249},{256,0,0,0,0,0},{9,0,1,1,2,48},{10,0,1,1,2,48},{11,0,1,1,2,48},{12,1,1,1,2,48},{9,0,1,1,2,49},{10,0,1,1,2,49},{11,0,1,1,2,49},{12,1,1,1,2,49},{9,0,1,1,2,50},{10,0,1,1,2,50},{11,0,1,1,2,50},{12,1,1,1,2,50},{9,0,1,1,2,97},{10,0,1,1,2,97},{11,0,1,1,2,97},{12,1,1,1,2,97},{9,0,1,1,2,99},{10,0,1,1,2,99},{11,0,1,1,2,99},{12,1,1,1,2,99},{9,0,1,1,2,101},{10,0,1,1,2,101},{11,0,1,1,2,101},{12,1,1,1,2,101},{9,0,1,1,2,105},{10,0,1,1,2,105},{11,0,1,1,2,105},{12,1,1,1,2,105},{9,0,1,1,2,111},{10,0,1,1,2,111},{11,0,1,1,2,111},{12,1,1,1,2,111},{9,0,1,1,2,115},{10,0,1,1,2,115},{11,0,1,1,2,115},{12,1,1,1,2,115},{9,0,1,1,2,116},{10,0,1,1,2,116},{11,0,1,1,2,116},{12,1,1,1,2,116},{13,0,1,1,2,32},{14,1,1,1,2,32},{13,0,1,1,2,37},{14,1,1,1,2,37},{13,0,1,1,2,45},{14,1,1,1,2,45},{13,0,1,1,2,46},{14,1,1,1,2,46},{13,0,1,1,2,47},{14,1,1,1,2,47},{13,0,1,1,2,51},{14,1,1,1,2,51},{13,0,1,1,2,52},{14,1,1,1,2,52},{13,0,1,1,2,53},{14,1,1,1,2,53},{13,0,1,1,2,54},{14,1,1,1,2,54},{13,0,1,1,2,55},{14,1,1,1,2,55},{13,0,1,1,2,56},{14,1,1,1,2,56},{13,0,1,1,2,57},{14,1,1,1,2,57},{13,0,1,1,2,61},{14,1,1,1,2,61},{13,0,1,1,2,65},{14,1,1,1,2,65},{13,0,1,1,2,95},{14,1,1,1,2,95},{13,0,1,1,2,98},{14,1,1,1,2,98},{13,0,1,1,2,100},{14,1,1,1,2,100},{13,0,1,1,2,102},{14,1,1,1,2,102},{13,0,1,1,2,103},{14,1,1,1,2,103},{13,0,1,1,2,104},{14,1,1,1,2,104},{13,0,1,1,2,108},{14,1,1,1,2,108},{13,0,1,1,2,109},{14,1,1,1,2,109},{13,0,1,1,2,110},{14,1,1,1,2,110},{13,0,1,1,2,112},{14,1,1,1,2,112},{13,0,1,1,2,114},{14,1,1,1,2,114},{13,0,1,1,2,117},{14,1,1,1,2,117},{0,1,1,1,2,58},{0,1,1,1,2,66},{0,1,1,1,2,67},{0,1,1,1,2,68},{0,1,1,1,2,69},{0,1,1,1,2,70},{0,1,1,1,2,71},{0,1,1,1,2,72},{0,1,1,1,2,73},{0,1,1,1,2,74},{0,1,1,1,2,75},{0,1,1,1,2,76},{0,1,1,1,2,77},{0,1,1,1,2,78},{0,1,1,1,2,79},{0,1,1,1,2,80},{0,1,1,1,2,81},{0,1,1,1,2,82},{0,1,1,1,2,83},{0,1,1,1,2,84},{0,1,1,1,2,85},{0,1,1,1,2,86},{0,1,1,1,2,87},{0,1,1,1,2,89},{0,1,1,1,2,106},{0,1,1,1,2,107},{0,1,1,1,2,113},{0,1,1,1,2,118},{0,1,1,1,2,119},{0,1,1,1,2,120},{0,1,1,1,2,121},{0,1,1,1,2,122},{85,0,0,1,0,2},{86,0,0,1,0,2},{87,0,0,1,0,2},{88,1,0,1,0,2},{9,0,1,1,3,48},{10,0,1,1,3,48},{11,0,1,1,3,48},{12,1,1,1,3,48},{9,0,1,1,3,49},{10,0,1,1,3,49},{11,0,1,1,3,49},{12,1,1,1,3,49},{9,0,1,1,3,50},{10,0,1,1,3,50},{11,0,1,1,3,50},{12,1,1,1,3,50},{9,0,1,1,3,97},{10,0,1,1,3,97},{11,0,1,1,3,97},{12,1,1,1,3,97},{9,0,1,1,3,99},{10,0,1,1,3,99},{11,0,1,1,3,99},{12,1,1,1,3,99},{9,0,1,1,3,101},{10,0,1,1,3,101},{11,0,1,1,3,101},{12,1,1,1,3,101},{9,0,1,1,3,105},{10,0,1,1,3,105},{11,0,1,1,3,105},{12,1,1,1,3,105},{9,0,1,1,3,111},{10,0,1,1,3,111},{11,0,1,1,3,111},{12,1,1,1,3,111},{9,0,1,1,3,115},{10,0,1,1,3,115},{11,0,1,1,3,115},{12,1,1,1,3,115},{9,0,1,1,3,116},{10,0,1,1,3,116},{11,0,1,1,3,116},{12,1,1,1,3,116},{13,0,1,1,3,32},{14,1,1,1,3,32},{13,0,1,1,3,37},{14,1,1,1,3,37},{13,0,1,1,3,45},{14,1,1,1,3,45},{13,0,1,1,3,46},{14,1,1,1,3,46},{13,0,1,1,3,47},{14,1,1,1,3,47},{13,0,1,1,3,51},{14,1,1,1,3,51},{13,0,1,1,3,52},{14,1,1,1,3,52},{13,0,1,1,3,53},{14,1,1,1,3,53},{13,0,1,1,3,54},{14,1,1,1,3,54},{13,0,1,1,3,55},{14,1,1,1,3,55},{13,0,1,1,3,56},{14,1,1,1,3,56},{13,0,1,1,3,57},{14,1,1,1,3,57},{13,0,1,1,3,61},{14,1,1,1,3,61},{13,0,1,1,3,65},{14,1,1,1,3,65},{13,0,1,1,3,95},{14,1,1,1,3,95},{13,0,1,1,3,98},{14,1,1,1,3,98},{13,0,1,1,3,100},{14,1,1,1,3,100},{13,0,1,1,3,102},{14,1,1,1,3,102},{13,0,1,1,3,103},{14,1,1,1,3,103},{13,0,1,1,3,104},{14,1,1,1,3,104},{13,0,1,1,3,108},{14,1,1,1,3,108},{13,0,1,1,3,109},{14,1,1,1,3,109},{13,0,1,1,3,110},{14,1,1,1,3,110},{13,0,1,1,3,112},{14,1,1,1,3,112},{13,0,1,1,3,114},{14,1,1,1,3,114},{13,0,1,1,3,117},{14,1,1,1,3,117},{0,1,1,1,3,58},{0,1,1,1,3,66},{0,1,1,1,3,67},{0,1,1,1,3,68},{0,1,1,1,3,69},{0,1,1,1,3,70},{0,1,1,1,3,71},{0,1,1,1,3,72},{0,1,1,1,3,73},{0,1,1,1,3,74},{0,1,1,1,3,75},{0,1,1,1,3,76},{0,1,1,1,3,77},{0,1,1,1,3,78},{0,1,1,1,3,79},{0,1,1,1,3,80},{0,1,1,1,3,81},{0,1,1,1,3,82},{0,1,1,1,3,83},{0,1,1,1,3,84},{0,1,1,1,3,85},{0,1,1,1,3,86},{0,1,1,1,3,87},{0,1,1,1,3,89},{0,1,1,1,3,106},{0,1,1,1,3,107},{0,1,1,1,3,113},{0,1,1,1,3,118},{0,1,1,1,3,119},{0,1,1,1,3,120},{0,1,1,1,3,121},{0,1,1,1,3,122},{85,0,0,1,0,3},{86,0,0,1,0,3},{87,0,0,1,0,3},{88,1,0,1,0,3},{9,0,1,1,4,48},{10,0,1,1,4,48},{11,0,1,1,4,48},{12,1,1,1,4,48},{9,0,1,1,4,49},{10,0,1,1,4,49},{11,0,1,1,4,49},{12,1,1,1,4,49},{9,0,1,1,4,50},{10,0,1,1,4,50},{11,0,1,1,4,50},{12,1,1,1,4,50},{9,0,1,1,4,97},{10,0,1,1,4,97},{11,0,1,1,4,97},{12,1,1,1,4,97},{9,0,1,1,4,99},{10,0,1,1,4,99},{11,0,1,1,4,99},{12,1,1,1,4,99},{9,0,1,1,4,101},{10,0,1,1,4,101},{11,0,1,1,4,101},{12,1,1,1,4,101},{9,0,1,1,4,105},{10,0,1,1,4,105},{11,0,1,1,4,105},{12,1,1,1,4,105},{9,0,1,1,4,111},{10,0,1,1,4,111},{11,0,1,1,4,111},{12,1,1,1,4,111},{9,0,1,1,4,115},{10,0,1,1,4,115},{11,0,1,1,4,115},{12,1,1,1,4,115},{9,0,1,1,4,116},{10,0,1,1,4,116},{11,0,1,1,4,116},{12,1,1,1,4,116},{13,0,1,1,4,32},{14,1,1,1,4,32},{13,0,1,1,4,37},{14,1,1,1,4,37},{13,0,1,1,4,45},{14,1,1,1,4,45},{13,0,1,1,4,46},{14,1,1,1,4,46},{13,0,1,1,4,47},{14,1,1,1,4,47},{13,0,1,1,4,51},{14,1,1,1,4,51},{13,0,1,1,4,52},{14,1,1,1,4,52},{13,0,1,1,4,53},{14,1,1,1,4,53},{13,0,1,1,4,54},{14,1,1,1,4,54},{13,0,1,1,4,55},{14,1,1,1,4,55},{13,0,1,1,4,56},{14,1,1,1,4,56},{13,0,1,1,4,57},{14,1,1,1,4,57},{13,0,1,1,4,61},{14,1,1,1,4,61},{13,0,1,1,4,65},{14,1,1,1,4,65},{13,0,1,1,4,95},{14,1,1,1,4,95},{13,0,1,1,4,98},{14,1,1,1,4,98},{13,0,1,1,4,100},{14,1,1,1,4,100},{13,0,1,1,4,102},{14,1,1,1,4,102},{13,0,1,1,4,103},{14,1,1,1,4,103},{13,0,1,1,4,104},{14,1,1,1,4,104},{13,0,1,1,4,108},{14,1,1,1,4,108},{13,0,1,1,4,109},{14,1,1,1,4,109},{13,0,1,1,4,110},{14,1,1,1,4,110},{13,0,1,1,4,112},{14,1,1,1,4,112},{13,0,1,1,4,114},{14,1,1,1,4,114},{13,0,1,1,4,117},{14,1,1,1,4,117},{0,1,1,1,4,58},{0,1,1,1,4,66},{0,1,1,1,4,67},{0,1,1,1,4,68},{0,1,1,1,4,69},{0,1,1,1,4,70},{0,1,1,1,4,71},{0,1,1,1,4,72},{0,1,1,1,4,73},{0,1,1,1,4,74},{0,1,1,1,4,75},{0,1,1,1,4,76},{0,1,1,1,4,77},{0,1,1,1,4,78},{0,1,1,1,4,79},{0,1,1,1,4,80},{0,1,1,1,4,81},{0,1,1,1,4,82},{0,1,1,1,4,83},{0,1,1,1,4,84},{0,1,1,1,4,85},{0,1,1,1,4,86},{0,1,1,1,4,87},{0,1,1,1,4,89},{0,1,1,1,4,106},{0,1,1,1,4,107},{0,1,1,1,4,113},{0,1,1,1,4,118},{0,1,1,1,4,119},{0,1,1,1,4,120},{0,1,1,1,4,121},{0,1,1,1,4,122},{85,0,0,1,0,4},{86,0,0,1,0,4},{87,0,0,1,0,4},{88,1,0,1,0,4},{9,0,1,1,5,48},{10,0,1,1,5,48},{11,0,1,1,5,48},{12,1,1,1,5,48},{9,0,1,1,5,49},{10,0,1,1,5,49},{11,0,1,1,5,49},{12,1,1,1,5,49},{9,0,1,1,5,50},{10,0,1,1,5,50},{11,0,1,1,5,50},{12,1,1,1,5,50},{9,0,1,1,5,97},{10,0,1,1,5,97},{11,0,1,1,5,97},{12,1,1,1,5,97},{9,0,1,1,5,99},{10,0,1,1,5,99},{11,0,1,1,5,99},{12,1,1,1,5,99},{9,0,1,1,5,101},{10,0,1,1,5,101},{11,0,1,1,5,101},{12,1,1,1,5,101},{9,0,1,1,5,105},{10,0,1,1,5,105},{11,0,1,1,5,105},{12,1,1,1,5,105},{9,0,1,1,5,111},{10,0,1,1,5,111},{11,0,1,1,5,111},{12,1,1,1,5,111},{9,0,1,1,5,115},{10,0,1,1,5,115},{11,0,1,1,5,115},{12,1,1,1,5,115},{9,0,1,1,5,116},{10,0,1,1,5,116},{11,0,1,1,5,116},{12,1,1,1,5,116},{13,0,1,1,5,32},{14,1,1,1,5,32},{13,0,1,1,5,37},{14,1,1,1,5,37},{13,0,1,1,5,45},{14,1,1,1,5,45},{13,0,1,1,5,46},{14,1,1,1,5,46},{13,0,1,1,5,47},{14,1,1,1,5,47},{13,0,1,1,5,51},{14,1,1,1,5,51},{13,0,1,1,5,52},{14,1,1,1,5,52},{13,0,1,1,5,53},{14,1,1,1,5,53},{13,0,1,1,5,54},{14,1,1,1,5,54},{13,0,1,1,5,55},{14,1,1,1,5,55},{13,0,1,1,5,56},{14,1,1,1,5,56},{13,0,1,1,5,57},{14,1,1,1,5,57},{13,0,1,1,5,61},{14,1,1,1,5,61},{13,0,1,1,5,65},{14,1,1,1,5,65},{13,0,1,1,5,95},{14,1,1,1,5,95},{13,0,1,1,5,98},{14,1,1,1,5,98},{13,0,1,1,5,100},{14,1,1,1,5,100},{13,0,1,1,5,102},{14,1,1,1,5,102},{13,0,1,1,5,103},{14,1,1,1,5,103},{13,0,1,1,5,104},{14,1,1,1,5,104},{13,0,1,1,5,108},{14,1,1,1,5,108},{13,0,1,1,5,109},{14,1,1,1,5,109},{13,0,1,1,5,110},{14,1,1,1,5,110},{13,0,1,1,5,112},{14,1,1,1,5,112},{13,0,1,1,5,114},{14,1,1,1,5,114},{13,0,1,1,5,117},{14,1,1,1,5,117},{0,1,1,1,5,58},{0,1,1,1,5,66},{0,1,1,1,5,67},{0,1,1,1,5,68},{0,1,1,1,5,69},{0,1,1,1,5,70},{0,1,1,1,5,71},{0,1,1,1,5,72},{0,1,1,1,5,73},{0,1,1,1,5,74},{0,1,1,1,5,75},{0,1,1,1,5,76},{0,1,1,1,5,77},{0,1,1,1,5,78},{0,1,1,1,5,79},{0,1,1,1,5,80},{0,1,1,1,5,81},{0,1,1,1,5,82},{0,1,1,1,5,83},{0,1,1,1,5,84},{0,1,1,1,5,85},{0,1,1,1,5,86},{0,1,1,1,5,87},{0,1,1,1,5,89},{0,1,1,1,5,106},{0,1,1,1,5,107},{0,1,1,1,5,113},{0,1,1,1,5,118},{0,1,1,1,5,119},{0,1,1,1,5,120},{0,1,1,1,5,121},{0,1,1,1,5,122},{85,0,0,1,0,5},{86,0,0,1,0,5},{87,0,0,1,0,5},{88,1,0,1,0,5},{9,0,1,1,6,48},{10,0,1,1,6,48},{11,0,1,1,6,48},{12,1,1,1,6,48},{9,0,1,1,6,49},{10,0,1,1,6,49},{11,0,1,1,6,49},{12,1,1,1,6,49},{9,0,1,1,6,50},{10,0,1,1,6,50},{11,0,1,1,6,50},{12,1,1,1,6,50},{9,0,1,1,6,97},{10,0,1,1,6,97},{11,0,1,1,6,97},{12,1,1,1,6,97},{9,0,1,1,6,99},{10,0,1,1,6,99},{11,0,1,1,6,99},{12,1,1,1,6,99},{9,0,1,1,6,101},{10,0,1,1,6,101},{11,0,1,1,6,101},{12,1,1,1,6,101},{9,0,1,1,6,105},{10,0,1,1,6,105},{11,0,1,1,6,105},{12,1,1,1,6,105},{9,0,1,1,6,111},{10,0,1,1,6,111},{11,0,1,1,6,111},{12,1,1,1,6,111},{9,0,1,1,6,115},{10,0,1,1,6,115},{11,0,1,1,6,115},{12,1,1,1,6,115},{9,0,1,1,6,116},{10,0,1,1,6,116},{11,0,1,1,6,116},{12,1,1,1,6,116},{13,0,1,1,6,32},{14,1,1,1,6,32},{13,0,1,1,6,37},{14,1,1,1,6,37},{13,0,1,1,6,45},{14,1,1,1,6,45},{13,0,1,1,6,46},{14,1,1,1,6,46},{13,0,1,1,6,47},{14,1,1,1,6,47},{13,0,1,1,6,51},{14,1,1,1,6,51},{13,0,1,1,6,52},{14,1,1,1,6,52},{13,0,1,1,6,53},{14,1,1,1,6,53},{13,0,1,1,6,54},{14,1,1,1,6,54},{13,0,1,1,6,55},{14,1,1,1,6,55},{13,0,1,1,6,56},{14,1,1,1,6,56},{13,0,1,1,6,57},{14,1,1,1,6,57},{13,0,1,1,6,61},{14,1,1,1,6,61},{13,0,1,1,6,65},{14,1,1,1,6,65},{13,0,1,1,6,95},{14,1,1,1,6,95},{13,0,1,1,6,98},{14,1,1,1,6,98},{13,0,1,1,6,100},{14,1,1,1,6,100},{13,0,1,1,6,102},{14,1,1,1,6,102},{13,0,1,1,6,103},{14,1,1,1,6,103},{13,0,1,1,6,104},{14,1,1,1,6,104},{13,0,1,1,6,108},{14,1,1,1,6,108},{13,0,1,1,6,109},{14,1,1,1,6,109},{13,0,1,1,6,110},{14,1,1,1,6,110},{13,0,1,1,6,112},{14,1,1,1,6,112},{13,0,1,1,6,114},{14,1,1,1,6,114},{13,0,1,1,6,117},{14,1,1,1,6,117},{0,1,1,1,6,58},{0,1,1,1,6,66},{0,1,1,1,6,67},{0,1,1,1,6,68},{0,1,1,1,6,69},{0,1,1,1,6,70},{0,1,1,1,6,71},{0,1,1,1,6,72},{0,1,1,1,6,73},{0,1,1,1,6,74},{0,1,1,1,6,75},{0,1,1,1,6,76},{0,1,1,1,6,77},{0,1,1,1,6,78},{0,1,1,1,6,79},{0,1,1,1,6,80},{0,1,1,1,6,81},{0,1,1,1,6,82},{0,1,1,1,6,83},{0,1,1,1,6,84},{0,1,1,1,6,85},{0,1,1,1,6,86},{0,1,1,1,6,87},{0,1,1,1,6,89},{0,1,1,1,6,106},{0,1,1,1,6,107},{0,1,1,1,6,113},{0,1,1,1,6,118},{0,1,1,1,6,119},{0,1,1,1,6,120},{0,1,1,1,6,121},{0,1,1,1,6,122},{85,0,0,1,0,6},{86,0,0,1,0,6},{87,0,0,1,0,6},{88,1,0,1,0,6},{9,0,1,1,7,48},{10,0,1,1,7,48},{11,0,1,1,7,48},{12,1,1,1,7,48},{9,0,1,1,7,49},{10,0,1,1,7,49},{11,0,1,1,7,49},{12,1,1,1,7,49},{9,0,1,1,7,50},{10,0,1,1,7,50},{11,0,1,1,7,50},{12,1,1,1,7,50},{9,0,1,1,7,97},{10,0,1,1,7,97},{11,0,1,1,7,97},{12,1,1,1,7,97},{9,0,1,1,7,99},{10,0,1,1,7,99},{11,0,1,1,7,99},{12,1,1,1,7,99},{9,0,1,1,7,101},{10,0,1,1,7,101},{11,0,1,1,7,101},{12,1,1,1,7,101},{9,0,1,1,7,105},{10,0,1,1,7,105},{11,0,1,1,7,105},{12,1,1,1,7,105},{9,0,1,1,7,111},{10,0,1,1,7,111},{11,0,1,1,7,111},{12,1,1,1,7,111},{9,0,1,1,7,115},{10,0,1,1,7,115},{11,0,1,1,7,115},{12,1,1,1,7,115},{9,0,1,1,7,116},{10,0,1,1,7,116},{11,0,1,1,7,116},{12,1,1,1,7,116},{13,0,1,1,7,32},{14,1,1,1,7,32},{13,0,1,1,7,37},{14,1,1,1,7,37},{13,0,1,1,7,45},{14,1,1,1,7,45},{13,0,1,1,7,46},{14,1,1,1,7,46},{13,0,1,1,7,47},{14,1,1,1,7,47},{13,0,1,1,7,51},{14,1,1,1,7,51},{13,0,1,1,7,52},{14,1,1,1,7,52},{13,0,1,1,7,53},{14,1,1,1,7,53},{13,0,1,1,7,54},{14,1,1,1,7,54},{13,0,1,1,7,55},{14,1,1,1,7,55},{13,0,1,1,7,56},{14,1,1,1,7,56},{13,0,1,1,7,57},{14,1,1,1,7,57},{13,0,1,1,7,61},{14,1,1,1,7,61},{13,0,1,1,7,65},{14,1,1,1,7,65},{13,0,1,1,7,95},{14,1,1,1,7,95},{13,0,1,1,7,98},{14,1,1,1,7,98},{13,0,1,1,7,100},{14,1,1,1,7,100},{13,0,1,1,7,102},{14,1,1,1,7,102},{13,0,1,1,7,103},{14,1,1,1,7,103},{13,0,1,1,7,104},{14,1,1,1,7,104},{13,0,1,1,7,108},{14,1,1,1,7,108},{13,0,1,1,7,109},{14,1,1,1,7,109},{13,0,1,1,7,110},{14,1,1,1,7,110},{13,0,1,1,7,112},{14,1,1,1,7,112},{13,0,1,1,7,114},{14,1,1,1,7,114},{13,0,1,1,7,117},{14,1,1,1,7,117},{0,1,1,1,7,58},{0,1,1,1,7,66},{0,1,1,1,7,67},{0,1,1,1,7,68},{0,1,1,1,7,69},{0,1,1,1,7,70},{0,1,1,1,7,71},{0,1,1,1,7,72},{0,1,1,1,7,73},{0,1,1,1,7,74},{0,1,1,1,7,75},{0,1,1,1,7,76},{0,1,1,1,7,77},{0,1,1,1,7,78},{0,1,1,1,7,79},{0,1,1,1,7,80},{0,1,1,1,7,81},{0,1,1,1,7,82},{0,1,1,1,7,83},{0,1,1,1,7,84},{0,1,1,1,7,85},{0,1,1,1,7,86},{0,1,1,1,7,87},{0,1,1,1,7,89},{0,1,1,1,7,106},{0,1,1,1,7,107},{0,1,1,1,7,113},{0,1,1,1,7,118},{0,1,1,1,7,119},{0,1,1,1,7,120},{0,1,1,1,7,121},{0,1,1,1,7,122},{85,0,0,1,0,7},{86,0,0,1,0,7},{87,0,0,1,0,7},{88,1,0,1,0,7},{9,0,1,1,8,48},{10,0,1,1,8,48},{11,0,1,1,8,48},{12,1,1,1,8,48},{9,0,1,1,8,49},{10,0,1,1,8,49},{11,0,1,1,8,49},{12,1,1,1,8,49},{9,0,1,1,8,50},{10,0,1,1,8,50},{11,0,1,1,8,50},{12,1,1,1,8,50},{9,0,1,1,8,97},{10,0,1,1,8,97},{11,0,1,1,8,97},{12,1,1,1,8,97},{9,0,1,1,8,99},{10,0,1,1,8,99},{11,0,1,1,8,99},{12,1,1,1,8,99},{9,0,1,1,8,101},{10,0,1,1,8,101},{11,0,1,1,8,101},{12,1,1,1,8,101},{9,0,1,1,8,105},{10,0,1,1,8,105},{11,0,1,1,8,105},{12,1,1,1,8,105},{9,0,1,1,8,111},{10,0,1,1,8,111},{11,0,1,1,8,111},{12,1,1,1,8,111},{9,0,1,1,8,115},{10,0,1,1,8,115},{11,0,1,1,8,115},{12,1,1,1,8,115},{9,0,1,1,8,116},{10,0,1,1,8,116},{11,0,1,1,8,116},{12,1,1,1,8,116},{13,0,1,1,8,32},{14,1,1,1,8,32},{13,0,1,1,8,37},{14,1,1,1,8,37},{13,0,1,1,8,45},{14,1,1,1,8,45},{13,0,1,1,8,46},{14,1,1,1,8,46},{13,0,1,1,8,47},{14,1,1,1,8,47},{13,0,1,1,8,51},{14,1,1,1,8,51},{13,0,1,1,8,52},{14,1,1,1,8,52},{13,0,1,1,8,53},{14,1,1,1,8,53},{13,0,1,1,8,54},{14,1,1,1,8,54},{13,0,1,1,8,55},{14,1,1,1,8,55},{13,0,1,1,8,56},{14,1,1,1,8,56},{13,0,1,1,8,57},{14,1,1,1,8,57},{13,0,1,1,8,61},{14,1,1,1,8,61},{13,0,1,1,8,65},{14,1,1,1,8,65},{13,0,1,1,8,95},{14,1,1,1,8,95},{13,0,1,1,8,98},{14,1,1,1,8,98},{13,0,1,1,8,100},{14,1,1,1,8,100},{13,0,1,1,8,102},{14,1,1,1,8,102},{13,0,1,1,8,103},{14,1,1,1,8,103},{13,0,1,1,8,104},{14,1,1,1,8,104},{13,0,1,1,8,108},{14,1,1,1,8,108},{13,0,1,1,8,109},{14,1,1,1,8,109},{13,0,1,1,8,110},{14,1,1,1,8,110},{13,0,1,1,8,112},{14,1,1,1,8,112},{13,0,1,1,8,114},{14,1,1,1,8,114},{13,0,1,1,8,117},{14,1,1,1,8,117},{0,1,1,1,8,58},{0,1,1,1,8,66},{0,1,1,1,8,67},{0,1,1,1,8,68},{0,1,1,1,8,69},{0,1,1,1,8,70},{0,1,1,1,8,71},{0,1,1,1,8,72},{0,1,1,1,8,73},{0,1,1,1,8,74},{0,1,1,1,8,75},{0,1,1,1,8,76},{0,1,1,1,8,77},{0,1,1,1,8,78},{0,1,1,1,8,79},{0,1,1,1,8,80},{0,1,1,1,8,81},{0,1,1,1,8,82},{0,1,1,1,8,83},{0,1,1,1,8,84},{0,1,1,1,8,85},{0,1,1,1,8,86},{0,1,1,1,8,87},{0,1,1,1,8,89},{0,1,1,1,8,106},{0,1,1,1,8,107},{0,1,1,1,8,113},{0,1,1,1,8,118},{0,1,1,1,8,119},{0,1,1,1,8,120},{0,1,1,1,8,121},{0,1,1,1,8,122},{85,0,0,1,0,8},{86,0,0,1,0,8},{87,0,0,1,0,8},{88,1,0,1,0,8},{9,0,1,1,11,48},{10,0,1,1,11,48},{11,0,1,1,11,48},{12,1,1,1,11,48},{9,0,1,1,11,49},{10,0,1,1,11,49},{11,0,1,1,11,49},{12,1,1,1,11,49},{9,0,1,1,11,50},{10,0,1,1,11,50},{11,0,1,1,11,50},{12,1,1,1,11,50},{9,0,1,1,11,97},{10,0,1,1,11,97},{11,0,1,1,11,97},{12,1,1,1,11,97},{9,0,1,1,11,99},{10,0,1,1,11,99},{11,0,1,1,11,99},{12,1,1,1,11,99},{9,0,1,1,11,101},{10,0,1,1,11,101},{11,0,1,1,11,101},{12,1,1,1,11,101},{9,0,1,1,11,105},{10,0,1,1,11,105},{11,0,1,1,11,105},{12,1,1,1,11,105},{9,0,1,1,11,111},{10,0,1,1,11,111},{11,0,1,1,11,111},{12,1,1,1,11,111},{9,0,1,1,11,115},{10,0,1,1,11,115},{11,0,1,1,11,115},{12,1,1,1,11,115},{9,0,1,1,11,116},{10,0,1,1,11,116},{11,0,1,1,11,116},{12,1,1,1,11,116},{13,0,1,1,11,32},{14,1,1,1,11,32},{13,0,1,1,11,37},{14,1,1,1,11,37},{13,0,1,1,11,45},{14,1,1,1,11,45},{13,0,1,1,11,46},{14,1,1,1,11,46},{13,0,1,1,11,47},{14,1,1,1,11,47},{13,0,1,1,11,51},{14,1,1,1,11,51},{13,0,1,1,11,52},{14,1,1,1,11,52},{13,0,1,1,11,53},{14,1,1,1,11,53},{13,0,1,1,11,54},{14,1,1,1,11,54},{13,0,1,1,11,55},{14,1,1,1,11,55},{13,0,1,1,11,56},{14,1,1,1,11,56},{13,0,1,1,11,57},{14,1,1,1,11,57},{13,0,1,1,11,61},{14,1,1,1,11,61},{13,0,1,1,11,65},{14,1,1,1,11,65},{13,0,1,1,11,95},{14,1,1,1,11,95},{13,0,1,1,11,98},{14,1,1,1,11,98},{13,0,1,1,11,100},{14,1,1,1,11,100},{13,0,1,1,11,102},{14,1,1,1,11,102},{13,0,1,1,11,103},{14,1,1,1,11,103},{13,0,1,1,11,104},{14,1,1,1,11,104},{13,0,1,1,11,108},{14,1,1,1,11,108},{13,0,1,1,11,109},{14,1,1,1,11,109},{13,0,1,1,11,110},{14,1,1,1,11,110},{13,0,1,1,11,112},{14,1,1,1,11,112},{13,0,1,1,11,114},{14,1,1,1,11,114},{13,0,1,1,11,117},{14,1,1,1,11,117},{0,1,1,1,11,58},{0,1,1,1,11,66},{0,1,1,1,11,67},{0,1,1,1,11,68},{0,1,1,1,11,69},{0,1,1,1,11,70},{0,1,1,1,11,71},{0,1,1,1,11,72},{0,1,1,1,11,73},{0,1,1,1,11,74},{0,1,1,1,11,75},{0,1,1,1,11,76},{0,1,1,1,11,77},{0,1,1,1,11,78},{0,1,1,1,11,79},{0,1,1,1,11,80},{0,1,1,1,11,81},{0,1,1,1,11,82},{0,1,1,1,11,83},{0,1,1,1,11,84},{0,1,1,1,11,85},{0,1,1,1,11,86},{0,1,1,1,11,87},{0,1,1,1,11,89},{0,1,1,1,11,106},{0,1,1,1,11,107},{0,1,1,1,11,113},{0,1,1,1,11,118},{0,1,1,1,11,119},{0,1,1,1,11,120},{0,1,1,1,11,121},{0,1,1,1,11,122},{85,0,0,1,0,11},{86,0,0,1,0,11},{87,0,0,1,0,11},{88,1,0,1,0,11},{9,0,1,1,12,48},{10,0,1,1,12,48},{11,0,1,1,12,48},{12,1,1,1,12,48},{9,0,1,1,12,49},{10,0,1,1,12,49},{11,0,1,1,12,49},{12,1,1,1,12,49},{9,0,1,1,12,50},{10,0,1,1,12,50},{11,0,1,1,12,50},{12,1,1,1,12,50},{9,0,1,1,12,97},{10,0,1,1,12,97},{11,0,1,1,12,97},{12,1,1,1,12,97},{9,0,1,1,12,99},{10,0,1,1,12,99},{11,0,1,1,12,99},{12,1,1,1,12,99},{9,0,1,1,12,101},{10,0,1,1,12,101},{11,0,1,1,12,101},{12,1,1,1,12,101},{9,0,1,1,12,105},{10,0,1,1,12,105},{11,0,1,1,12,105},{12,1,1,1,12,105},{9,0,1,1,12,111},{10,0,1,1,12,111},{11,0,1,1,12,111},{12,1,1,1,12,111},{9,0,1,1,12,115},{10,0,1,1,12,115},{11,0,1,1,12,115},{12,1,1,1,12,115},{9,0,1,1,12,116},{10,0,1,1,12,116},{11,0,1,1,12,116},{12,1,1,1,12,116},{13,0,1,1,12,32},{14,1,1,1,12,32},{13,0,1,1,12,37},{14,1,1,1,12,37},{13,0,1,1,12,45},{14,1,1,1,12,45},{13,0,1,1,12,46},{14,1,1,1,12,46},{13,0,1,1,12,47},{14,1,1,1,12,47},{13,0,1,1,12,51},{14,1,1,1,12,51},{13,0,1,1,12,52},{14,1,1,1,12,52},{13,0,1,1,12,53},{14,1,1,1,12,53},{13,0,1,1,12,54},{14,1,1,1,12,54},{13,0,1,1,12,55},{14,1,1,1,12,55},{13,0,1,1,12,56},{14,1,1,1,12,56},{13,0,1,1,12,57},{14,1,1,1,12,57},{13,0,1,1,12,61},{14,1,1,1,12,61},{13,0,1,1,12,65},{14,1,1,1,12,65},{13,0,1,1,12,95},{14,1,1,1,12,95},{13,0,1,1,12,98},{14,1,1,1,12,98},{13,0,1,1,12,100},{14,1,1,1,12,100},{13,0,1,1,12,102},{14,1,1,1,12,102},{13,0,1,1,12,103},{14,1,1,1,12,103},{13,0,1,1,12,104},{14,1,1,1,12,104},{13,0,1,1,12,108},{14,1,1,1,12,108},{13,0,1,1,12,109},{14,1,1,1,12,109},{13,0,1,1,12,110},{14,1,1,1,12,110},{13,0,1,1,12,112},{14,1,1,1,12,112},{13,0,1,1,12,114},{14,1,1,1,12,114},{13,0,1,1,12,117},{14,1,1,1,12,117},{0,1,1,1,12,58},{0,1,1,1,12,66},{0,1,1,1,12,67},{0,1,1,1,12,68},{0,1,1,1,12,69},{0,1,1,1,12,70},{0,1,1,1,12,71},{0,1,1,1,12,72},{0,1,1,1,12,73},{0,1,1,1,12,74},{0,1,1,1,12,75},{0,1,1,1,12,76},{0,1,1,1,12,77},{0,1,1,1,12,78},{0,1,1,1,12,79},{0,1,1,1,12,80},{0,1,1,1,12,81},{0,1,1,1,12,82},{0,1,1,1,12,83},{0,1,1,1,12,84},{0,1,1,1,12,85},{0,1,1,1,12,86},{0,1,1,1,12,87},{0,1,1,1,12,89},{0,1,1,1,12,106},{0,1,1,1,12,107},{0,1,1,1,12,113},{0,1,1,1,12,118},{0,1,1,1,12,119},{0,1,1,1,12,120},{0,1,1,1,12,121},{0,1,1,1,12,122},{85,0,0,1,0,12},{86,0,0,1,0,12},{87,0,0,1,0,12},{88,1,0,1,0,12},{9,0,1,1,14,48},{10,0,1,1,14,48},{11,0,1,1,14,48},{12,1,1,1,14,48},{9,0,1,1,14,49},{10,0,1,1,14,49},{11,0,1,1,14,49},{12,1,1,1,14,49},{9,0,1,1,14,50},{10,0,1,1,14,50},{11,0,1,1,14,50},{12,1,1,1,14,50},{9,0,1,1,14,97},{10,0,1,1,14,97},{11,0,1,1,14,97},{12,1,1,1,14,97},{9,0,1,1,14,99},{10,0,1,1,14,99},{11,0,1,1,14,99},{12,1,1,1,14,99},{9,0,1,1,14,101},{10,0,1,1,14,101},{11,0,1,1,14,101},{12,1,1,1,14,101},{9,0,1,1,14,105},{10,0,1,1,14,105},{11,0,1,1,14,105},{12,1,1,1,14,105},{9,0,1,1,14,111},{10,0,1,1,14,111},{11,0,1,1,14,111},{12,1,1,1,14,111},{9,0,1,1,14,115},{10,0,1,1,14,115},{11,0,1,1,14,115},{12,1,1,1,14,115},{9,0,1,1,14,116},{10,0,1,1,14,116},{11,0,1,1,14,116},{12,1,1,1,14,116},{13,0,1,1,14,32},{14,1,1,1,14,32},{13,0,1,1,14,37},{14,1,1,1,14,37},{13,0,1,1,14,45},{14,1,1,1,14,45},{13,0,1,1,14,46},{14,1,1,1,14,46},{13,0,1,1,14,47},{14,1,1,1,14,47},{13,0,1,1,14,51},{14,1,1,1,14,51},{13,0,1,1,14,52},{14,1,1,1,14,52},{13,0,1,1,14,53},{14,1,1,1,14,53},{13,0,1,1,14,54},{14,1,1,1,14,54},{13,0,1,1,14,55},{14,1,1,1,14,55},{13,0,1,1,14,56},{14,1,1,1,14,56},{13,0,1,1,14,57},{14,1,1,1,14,57},{13,0,1,1,14,61},{14,1,1,1,14,61},{13,0,1,1,14,65},{14,1,1,1,14,65},{13,0,1,1,14,95},{14,1,1,1,14,95},{13,0,1,1,14,98},{14,1,1,1,14,98},{13,0,1,1,14,100},{14,1,1,1,14,100},{13,0,1,1,14,102},{14,1,1,1,14,102},{13,0,1,1,14,103},{14,1,1,1,14,103},{13,0,1,1,14,104},{14,1,1,1,14,104},{13,0,1,1,14,108},{14,1,1,1,14,108},{13,0,1,1,14,109},{14,1,1,1,14,109},{13,0,1,1,14,110},{14,1,1,1,14,110},{13,0,1,1,14,112},{14,1,1,1,14,112},{13,0,1,1,14,114},{14,1,1,1,14,114},{13,0,1,1,14,117},{14,1,1,1,14,117},{0,1,1,1,14,58},{0,1,1,1,14,66},{0,1,1,1,14,67},{0,1,1,1,14,68},{0,1,1,1,14,69},{0,1,1,1,14,70},{0,1,1,1,14,71},{0,1,1,1,14,72},{0,1,1,1,14,73},{0,1,1,1,14,74},{0,1,1,1,14,75},{0,1,1,1,14,76},{0,1,1,1,14,77},{0,1,1,1,14,78},{0,1,1,1,14,79},{0,1,1,1,14,80},{0,1,1,1,14,81},{0,1,1,1,14,82},{0,1,1,1,14,83},{0,1,1,1,14,84},{0,1,1,1,14,85},{0,1,1,1,14,86},{0,1,1,1,14,87},{0,1,1,1,14,89},{0,1,1,1,14,106},{0,1,1,1,14,107},{0,1,1,1,14,113},{0,1,1,1,14,118},{0,1,1,1,14,119},{0,1,1,1,14,120},{0,1,1,1,14,121},{0,1,1,1,14,122},{85,0,0,1,0,14},{86,0,0,1,0,14},{87,0,0,1,0,14},{88,1,0,1,0,14},{9,0,1,1,15,48},{10,0,1,1,15,48},{11,0,1,1,15,48},{12,1,1,1,15,48},{9,0,1,1,15,49},{10,0,1,1,15,49},{11,0,1,1,15,49},{12,1,1,1,15,49},{9,0,1,1,15,50},{10,0,1,1,15,50},{11,0,1,1,15,50},{12,1,1,1,15,50},{9,0,1,1,15,97},{10,0,1,1,15,97},{11,0,1,1,15,97},{12,1,1,1,15,97},{9,0,1,1,15,99},{10,0,1,1,15,99},{11,0,1,1,15,99},{12,1,1,1,15,99},{9,0,1,1,15,101},{10,0,1,1,15,101},{11,0,1,1,15,101},{12,1,1,1,15,101},{9,0,1,1,15,105},{10,0,1,1,15,105},{11,0,1,1,15,105},{12,1,1,1,15,105},{9,0,1,1,15,111},{10,0,1,1,15,111},{11,0,1,1,15,111},{12,1,1,1,15,111},{9,0,1,1,15,115},{10,0,1,1,15,115},{11,0,1,1,15,115},{12,1,1,1,15,115},{9,0,1,1,15,116},{10,0,1,1,15,116},{11,0,1,1,15,116},{12,1,1,1,15,116},{13,0,1,1,15,32},{14,1,1,1,15,32},{13,0,1,1,15,37},{14,1,1,1,15,37},{13,0,1,1,15,45},{14,1,1,1,15,45},{13,0,1,1,15,46},{14,1,1,1,15,46},{13,0,1,1,15,47},{14,1,1,1,15,47},{13,0,1,1,15,51},{14,1,1,1,15,51},{13,0,1,1,15,52},{14,1,1,1,15,52},{13,0,1,1,15,53},{14,1,1,1,15,53},{13,0,1,1,15,54},{14,1,1,1,15,54},{13,0,1,1,15,55},{14,1,1,1,15,55},{13,0,1,1,15,56},{14,1,1,1,15,56},{13,0,1,1,15,57},{14,1,1,1,15,57},{13,0,1,1,15,61},{14,1,1,1,15,61},{13,0,1,1,15,65},{14,1,1,1,15,65},{13,0,1,1,15,95},{14,1,1,1,15,95},{13,0,1,1,15,98},{14,1,1,1,15,98},{13,0,1,1,15,100},{14,1,1,1,15,100},{13,0,1,1,15,102},{14,1,1,1,15,102},{13,0,1,1,15,103},{14,1,1,1,15,103},{13,0,1,1,15,104},{14,1,1,1,15,104},{13,0,1,1,15,108},{14,1,1,1,15,108},{13,0,1,1,15,109},{14,1,1,1,15,109},{13,0,1,1,15,110},{14,1,1,1,15,110},{13,0,1,1,15,112},{14,1,1,1,15,112},{13,0,1,1,15,114},{14,1,1,1,15,114},{13,0,1,1,15,117},{14,1,1,1,15,117},{0,1,1,1,15,58},{0,1,1,1,15,66},{0,1,1,1,15,67},{0,1,1,1,15,68},{0,1,1,1,15,69},{0,1,1,1,15,70},{0,1,1,1,15,71},{0,1,1,1,15,72},{0,1,1,1,15,73},{0,1,1,1,15,74},{0,1,1,1,15,75},{0,1,1,1,15,76},{0,1,1,1,15,77},{0,1,1,1,15,78},{0,1,1,1,15,79},{0,1,1,1,15,80},{0,1,1,1,15,81},{0,1,1,1,15,82},{0,1,1,1,15,83},{0,1,1,1,15,84},{0,1,1,1,15,85},{0,1,1,1,15,86},{0,1,1,1,15,87},{0,1,1,1,15,89},{0,1,1,1,15,106},{0,1,1,1,15,107},{0,1,1,1,15,113},{0,1,1,1,15,118},{0,1,1,1,15,119},{0,1,1,1,15,120},{0,1,1,1,15,121},{0,1,1,1,15,122},{85,0,0,1,0,15},{86,0,0,1,0,15},{87,0,0,1,0,15},{88,1,0,1,0,15},{9,0,1,1,16,48},{10,0,1,1,16,48},{11,0,1,1,16,48},{12,1,1,1,16,48},{9,0,1,1,16,49},{10,0,1,1,16,49},{11,0,1,1,16,49},{12,1,1,1,16,49},{9,0,1,1,16,50},{10,0,1,1,16,50},{11,0,1,1,16,50},{12,1,1,1,16,50},{9,0,1,1,16,97},{10,0,1,1,16,97},{11,0,1,1,16,97},{12,1,1,1,16,97},{9,0,1,1,16,99},{10,0,1,1,16,99},{11,0,1,1,16,99},{12,1,1,1,16,99},{9,0,1,1,16,101},{10,0,1,1,16,101},{11,0,1,1,16,101},{12,1,1,1,16,101},{9,0,1,1,16,105},{10,0,1,1,16,105},{11,0,1,1,16,105},{12,1,1,1,16,105},{9,0,1,1,16,111},{10,0,1,1,16,111},{11,0,1,1,16,111},{12,1,1,1,16,111},{9,0,1,1,16,115},{10,0,1,1,16,115},{11,0,1,1,16,115},{12,1,1,1,16,115},{9,0,1,1,16,116},{10,0,1,1,16,116},{11,0,1,1,16,116},{12,1,1,1,16,116},{13,0,1,1,16,32},{14,1,1,1,16,32},{13,0,1,1,16,37},{14,1,1,1,16,37},{13,0,1,1,16,45},{14,1,1,1,16,45},{13,0,1,1,16,46},{14,1,1,1,16,46},{13,0,1,1,16,47},{14,1,1,1,16,47},{13,0,1,1,16,51},{14,1,1,1,16,51},{13,0,1,1,16,52},{14,1,1,1,16,52},{13,0,1,1,16,53},{14,1,1,1,16,53},{13,0,1,1,16,54},{14,1,1,1,16,54},{13,0,1,1,16,55},{14,1,1,1,16,55},{13,0,1,1,16,56},{14,1,1,1,16,56},{13,0,1,1,16,57},{14,1,1,1,16,57},{13,0,1,1,16,61},{14,1,1,1,16,61},{13,0,1,1,16,65},{14,1,1,1,16,65},{13,0,1,1,16,95},{14,1,1,1,16,95},{13,0,1,1,16,98},{14,1,1,1,16,98},{13,0,1,1,16,100},{14,1,1,1,16,100},{13,0,1,1,16,102},{14,1,1,1,16,102},{13,0,1,1,16,103},{14,1,1,1,16,103},{13,0,1,1,16,104},{14,1,1,1,16,104},{13,0,1,1,16,108},{14,1,1,1,16,108},{13,0,1,1,16,109},{14,1,1,1,16,109},{13,0,1,1,16,110},{14,1,1,1,16,110},{13,0,1,1,16,112},{14,1,1,1,16,112},{13,0,1,1,16,114},{14,1,1,1,16,114},{13,0,1,1,16,117},{14,1,1,1,16,117},{0,1,1,1,16,58},{0,1,1,1,16,66},{0,1,1,1,16,67},{0,1,1,1,16,68},{0,1,1,1,16,69},{0,1,1,1,16,70},{0,1,1,1,16,71},{0,1,1,1,16,72},{0,1,1,1,16,73},{0,1,1,1,16,74},{0,1,1,1,16,75},{0,1,1,1,16,76},{0,1,1,1,16,77},{0,1,1,1,16,78},{0,1,1,1,16,79},{0,1,1,1,16,80},{0,1,1,1,16,81},{0,1,1,1,16,82},{0,1,1,1,16,83},{0,1,1,1,16,84},{0,1,1,1,16,85},{0,1,1,1,16,86},{0,1,1,1,16,87},{0,1,1,1,16,89},{0,1,1,1,16,106},{0,1,1,1,16,107},{0,1,1,1,16,113},{0,1,1,1,16,118},{0,1,1,1,16,119},{0,1,1,1,16,120},{0,1,1,1,16,121},{0,1,1,1,16,122},{85,0,0,1,0,16},{86,0,0,1,0,16},{87,0,0,1,0,16},{88,1,0,1,0,16},{9,0,1,1,17,48},{10,0,1,1,17,48},{11,0,1,1,17,48},{12,1,1,1,17,48},{9,0,1,1,17,49},{10,0,1,1,17,49},{11,0,1,1,17,49},{12,1,1,1,17,49},{9,0,1,1,17,50},{10,0,1,1,17,50},{11,0,1,1,17,50},{12,1,1,1,17,50},{9,0,1,1,17,97},{10,0,1,1,17,97},{11,0,1,1,17,97},{12,1,1,1,17,97},{9,0,1,1,17,99},{10,0,1,1,17,99},{11,0,1,1,17,99},{12,1,1,1,17,99},{9,0,1,1,17,101},{10,0,1,1,17,101},{11,0,1,1,17,101},{12,1,1,1,17,101},{9,0,1,1,17,105},{10,0,1,1,17,105},{11,0,1,1,17,105},{12,1,1,1,17,105},{9,0,1,1,17,111},{10,0,1,1,17,111},{11,0,1,1,17,111},{12,1,1,1,17,111},{9,0,1,1,17,115},{10,0,1,1,17,115},{11,0,1,1,17,115},{12,1,1,1,17,115},{9,0,1,1,17,116},{10,0,1,1,17,116},{11,0,1,1,17,116},{12,1,1,1,17,116},{13,0,1,1,17,32},{14,1,1,1,17,32},{13,0,1,1,17,37},{14,1,1,1,17,37},{13,0,1,1,17,45},{14,1,1,1,17,45},{13,0,1,1,17,46},{14,1,1,1,17,46},{13,0,1,1,17,47},{14,1,1,1,17,47},{13,0,1,1,17,51},{14,1,1,1,17,51},{13,0,1,1,17,52},{14,1,1,1,17,52},{13,0,1,1,17,53},{14,1,1,1,17,53},{13,0,1,1,17,54},{14,1,1,1,17,54},{13,0,1,1,17,55},{14,1,1,1,17,55},{13,0,1,1,17,56},{14,1,1,1,17,56},{13,0,1,1,17,57},{14,1,1,1,17,57},{13,0,1,1,17,61},{14,1,1,1,17,61},{13,0,1,1,17,65},{14,1,1,1,17,65},{13,0,1,1,17,95},{14,1,1,1,17,95},{13,0,1,1,17,98},{14,1,1,1,17,98},{13,0,1,1,17,100},{14,1,1,1,17,100},{13,0,1,1,17,102},{14,1,1,1,17,102},{13,0,1,1,17,103},{14,1,1,1,17,103},{13,0,1,1,17,104},{14,1,1,1,17,104},{13,0,1,1,17,108},{14,1,1,1,17,108},{13,0,1,1,17,109},{14,1,1,1,17,109},{13,0,1,1,17,110},{14,1,1,1,17,110},{13,0,1,1,17,112},{14,1,1,1,17,112},{13,0,1,1,17,114},{14,1,1,1,17,114},{13,0,1,1,17,117},{14,1,1,1,17,117},{0,1,1,1,17,58},{0,1,1,1,17,66},{0,1,1,1,17,67},{0,1,1,1,17,68},{0,1,1,1,17,69},{0,1,1,1,17,70},{0,1,1,1,17,71},{0,1,1,1,17,72},{0,1,1,1,17,73},{0,1,1,1,17,74},{0,1,1,1,17,75},{0,1,1,1,17,76},{0,1,1,1,17,77},{0,1,1,1,17,78},{0,1,1,1,17,79},{0,1,1,1,17,80},{0,1,1,1,17,81},{0,1,1,1,17,82},{0,1,1,1,17,83},{0,1,1,1,17,84},{0,1,1,1,17,85},{0,1,1,1,17,86},{0,1,1,1,17,87},{0,1,1,1,17,89},{0,1,1,1,17,106},{0,1,1,1,17,107},{0,1,1,1,17,113},{0,1,1,1,17,118},{0,1,1,1,17,119},{0,1,1,1,17,120},{0,1,1,1,17,121},{0,1,1,1,17,122},{85,0,0,1,0,17},{86,0,0,1,0,17},{87,0,0,1,0,17},{88,1,0,1,0,17},{9,0,1,1,18,48},{10,0,1,1,18,48},{11,0,1,1,18,48},{12,1,1,1,18,48},{9,0,1,1,18,49},{10,0,1,1,18,49},{11,0,1,1,18,49},{12,1,1,1,18,49},{9,0,1,1,18,50},{10,0,1,1,18,50},{11,0,1,1,18,50},{12,1,1,1,18,50},{9,0,1,1,18,97},{10,0,1,1,18,97},{11,0,1,1,18,97},{12,1,1,1,18,97},{9,0,1,1,18,99},{10,0,1,1,18,99},{11,0,1,1,18,99},{12,1,1,1,18,99},{9,0,1,1,18,101},{10,0,1,1,18,101},{11,0,1,1,18,101},{12,1,1,1,18,101},{9,0,1,1,18,105},{10,0,1,1,18,105},{11,0,1,1,18,105},{12,1,1,1,18,105},{9,0,1,1,18,111},{10,0,1,1,18,111},{11,0,1,1,18,111},{12,1,1,1,18,111},{9,0,1,1,18,115},{10,0,1,1,18,115},{11,0,1,1,18,115},{12,1,1,1,18,115},{9,0,1,1,18,116},{10,0,1,1,18,116},{11,0,1,1,18,116},{12,1,1,1,18,116},{13,0,1,1,18,32},{14,1,1,1,18,32},{13,0,1,1,18,37},{14,1,1,1,18,37},{13,0,1,1,18,45},{14,1,1,1,18,45},{13,0,1,1,18,46},{14,1,1,1,18,46},{13,0,1,1,18,47},{14,1,1,1,18,47},{13,0,1,1,18,51},{14,1,1,1,18,51},{13,0,1,1,18,52},{14,1,1,1,18,52},{13,0,1,1,18,53},{14,1,1,1,18,53},{13,0,1,1,18,54},{14,1,1,1,18,54},{13,0,1,1,18,55},{14,1,1,1,18,55},{13,0,1,1,18,56},{14,1,1,1,18,56},{13,0,1,1,18,57},{14,1,1,1,18,57},{13,0,1,1,18,61},{14,1,1,1,18,61},{13,0,1,1,18,65},{14,1,1,1,18,65},{13,0,1,1,18,95},{14,1,1,1,18,95},{13,0,1,1,18,98},{14,1,1,1,18,98},{13,0,1,1,18,100},{14,1,1,1,18,100},{13,0,1,1,18,102},{14,1,1,1,18,102},{13,0,1,1,18,103},{14,1,1,1,18,103},{13,0,1,1,18,104},{14,1,1,1,18,104},{13,0,1,1,18,108},{14,1,1,1,18,108},{13,0,1,1,18,109},{14,1,1,1,18,109},{13,0,1,1,18,110},{14,1,1,1,18,110},{13,0,1,1,18,112},{14,1,1,1,18,112},{13,0,1,1,18,114},{14,1,1,1,18,114},{13,0,1,1,18,117},{14,1,1,1,18,117},{0,1,1,1,18,58},{0,1,1,1,18,66},{0,1,1,1,18,67},{0,1,1,1,18,68},{0,1,1,1,18,69},{0,1,1,1,18,70},{0,1,1,1,18,71},{0,1,1,1,18,72},{0,1,1,1,18,73},{0,1,1,1,18,74},{0,1,1,1,18,75},{0,1,1,1,18,76},{0,1,1,1,18,77},{0,1,1,1,18,78},{0,1,1,1,18,79},{0,1,1,1,18,80},{0,1,1,1,18,81},{0,1,1,1,18,82},{0,1,1,1,18,83},{0,1,1,1,18,84},{0,1,1,1,18,85},{0,1,1,1,18,86},{0,1,1,1,18,87},{0,1,1,1,18,89},{0,1,1,1,18,106},{0,1,1,1,18,107},{0,1,1,1,18,113},{0,1,1,1,18,118},{0,1,1,1,18,119},{0,1,1,1,18,120},{0,1,1,1,18,121},{0,1,1,1,18,122},{85,0,0,1,0,18},{86,0,0,1,0,18},{87,0,0,1,0,18},{88,1,0,1,0,18},{9,0,1,1,19,48},{10,0,1,1,19,48},{11,0,1,1,19,48},{12,1,1,1,19,48},{9,0,1,1,19,49},{10,0,1,1,19,49},{11,0,1,1,19,49},{12,1,1,1,19,49},{9,0,1,1,19,50},{10,0,1,1,19,50},{11,0,1,1,19,50},{12,1,1,1,19,50},{9,0,1,1,19,97},{10,0,1,1,19,97},{11,0,1,1,19,97},{12,1,1,1,19,97},{9,0,1,1,19,99},{10,0,1,1,19,99},{11,0,1,1,19,99},{12,1,1,1,19,99},{9,0,1,1,19,101},{10,0,1,1,19,101},{11,0,1,1,19,101},{12,1,1,1,19,101},{9,0,1,1,19,105},{10,0,1,1,19,105},{11,0,1,1,19,105},{12,1,1,1,19,105},{9,0,1,1,19,111},{10,0,1,1,19,111},{11,0,1,1,19,111},{12,1,1,1,19,111},{9,0,1,1,19,115},{10,0,1,1,19,115},{11,0,1,1,19,115},{12,1,1,1,19,115},{9,0,1,1,19,116},{10,0,1,1,19,116},{11,0,1,1,19,116},{12,1,1,1,19,116},{13,0,1,1,19,32},{14,1,1,1,19,32},{13,0,1,1,19,37},{14,1,1,1,19,37},{13,0,1,1,19,45},{14,1,1,1,19,45},{13,0,1,1,19,46},{14,1,1,1,19,46},{13,0,1,1,19,47},{14,1,1,1,19,47},{13,0,1,1,19,51},{14,1,1,1,19,51},{13,0,1,1,19,52},{14,1,1,1,19,52},{13,0,1,1,19,53},{14,1,1,1,19,53},{13,0,1,1,19,54},{14,1,1,1,19,54},{13,0,1,1,19,55},{14,1,1,1,19,55},{13,0,1,1,19,56},{14,1,1,1,19,56},{13,0,1,1,19,57},{14,1,1,1,19,57},{13,0,1,1,19,61},{14,1,1,1,19,61},{13,0,1,1,19,65},{14,1,1,1,19,65},{13,0,1,1,19,95},{14,1,1,1,19,95},{13,0,1,1,19,98},{14,1,1,1,19,98},{13,0,1,1,19,100},{14,1,1,1,19,100},{13,0,1,1,19,102},{14,1,1,1,19,102},{13,0,1,1,19,103},{14,1,1,1,19,103},{13,0,1,1,19,104},{14,1,1,1,19,104},{13,0,1,1,19,108},{14,1,1,1,19,108},{13,0,1,1,19,109},{14,1,1,1,19,109},{13,0,1,1,19,110},{14,1,1,1,19,110},{13,0,1,1,19,112},{14,1,1,1,19,112},{13,0,1,1,19,114},{14,1,1,1,19,114},{13,0,1,1,19,117},{14,1,1,1,19,117},{0,1,1,1,19,58},{0,1,1,1,19,66},{0,1,1,1,19,67},{0,1,1,1,19,68},{0,1,1,1,19,69},{0,1,1,1,19,70},{0,1,1,1,19,71},{0,1,1,1,19,72},{0,1,1,1,19,73},{0,1,1,1,19,74},{0,1,1,1,19,75},{0,1,1,1,19,76},{0,1,1,1,19,77},{0,1,1,1,19,78},{0,1,1,1,19,79},{0,1,1,1,19,80},{0,1,1,1,19,81},{0,1,1,1,19,82},{0,1,1,1,19,83},{0,1,1,1,19,84},{0,1,1,1,19,85},{0,1,1,1,19,86},{0,1,1,1,19,87},{0,1,1,1,19,89},{0,1,1,1,19,106},{0,1,1,1,19,107},{0,1,1,1,19,113},{0,1,1,1,19,118},{0,1,1,1,19,119},{0,1,1,1,19,120},{0,1,1,1,19,121},{0,1,1,1,19,122},{85,0,0,1,0,19},{86,0,0,1,0,19},{87,0,0,1,0,19},{88,1,0,1,0,19},{9,0,1,1,20,48},{10,0,1,1,20,48},{11,0,1,1,20,48},{12,1,1,1,20,48},{9,0,1,1,20,49},{10,0,1,1,20,49},{11,0,1,1,20,49},{12,1,1,1,20,49},{9,0,1,1,20,50},{10,0,1,1,20,50},{11,0,1,1,20,50},{12,1,1,1,20,50},{9,0,1,1,20,97},{10,0,1,1,20,97},{11,0,1,1,20,97},{12,1,1,1,20,97},{9,0,1,1,20,99},{10,0,1,1,20,99},{11,0,1,1,20,99},{12,1,1,1,20,99},{9,0,1,1,20,101},{10,0,1,1,20,101},{11,0,1,1,20,101},{12,1,1,1,20,101},{9,0,1,1,20,105},{10,0,1,1,20,105},{11,0,1,1,20,105},{12,1,1,1,20,105},{9,0,1,1,20,111},{10,0,1,1,20,111},{11,0,1,1,20,111},{12,1,1,1,20,111},{9,0,1,1,20,115},{10,0,1,1,20,115},{11,0,1,1,20,115},{12,1,1,1,20,115},{9,0,1,1,20,116},{10,0,1,1,20,116},{11,0,1,1,20,116},{12,1,1,1,20,116},{13,0,1,1,20,32},{14,1,1,1,20,32},{13,0,1,1,20,37},{14,1,1,1,20,37},{13,0,1,1,20,45},{14,1,1,1,20,45},{13,0,1,1,20,46},{14,1,1,1,20,46},{13,0,1,1,20,47},{14,1,1,1,20,47},{13,0,1,1,20,51},{14,1,1,1,20,51},{13,0,1,1,20,52},{14,1,1,1,20,52},{13,0,1,1,20,53},{14,1,1,1,20,53},{13,0,1,1,20,54},{14,1,1,1,20,54},{13,0,1,1,20,55},{14,1,1,1,20,55},{13,0,1,1,20,56},{14,1,1,1,20,56},{13,0,1,1,20,57},{14,1,1,1,20,57},{13,0,1,1,20,61},{14,1,1,1,20,61},{13,0,1,1,20,65},{14,1,1,1,20,65},{13,0,1,1,20,95},{14,1,1,1,20,95},{13,0,1,1,20,98},{14,1,1,1,20,98},{13,0,1,1,20,100},{14,1,1,1,20,100},{13,0,1,1,20,102},{14,1,1,1,20,102},{13,0,1,1,20,103},{14,1,1,1,20,103},{13,0,1,1,20,104},{14,1,1,1,20,104},{13,0,1,1,20,108},{14,1,1,1,20,108},{13,0,1,1,20,109},{14,1,1,1,20,109},{13,0,1,1,20,110},{14,1,1,1,20,110},{13,0,1,1,20,112},{14,1,1,1,20,112},{13,0,1,1,20,114},{14,1,1,1,20,114},{13,0,1,1,20,117},{14,1,1,1,20,117},{0,1,1,1,20,58},{0,1,1,1,20,66},{0,1,1,1,20,67},{0,1,1,1,20,68},{0,1,1,1,20,69},{0,1,1,1,20,70},{0,1,1,1,20,71},{0,1,1,1,20,72},{0,1,1,1,20,73},{0,1,1,1,20,74},{0,1,1,1,20,75},{0,1,1,1,20,76},{0,1,1,1,20,77},{0,1,1,1,20,78},{0,1,1,1,20,79},{0,1,1,1,20,80},{0,1,1,1,20,81},{0,1,1,1,20,82},{0,1,1,1,20,83},{0,1,1,1,20,84},{0,1,1,1,20,85},{0,1,1,1,20,86},{0,1,1,1,20,87},{0,1,1,1,20,89},{0,1,1,1,20,106},{0,1,1,1,20,107},{0,1,1,1,20,113},{0,1,1,1,20,118},{0,1,1,1,20,119},{0,1,1,1,20,120},{0,1,1,1,20,121},{0,1,1,1,20,122},{85,0,0,1,0,20},{86,0,0,1,0,20},{87,0,0,1,0,20},{88,1,0,1,0,20},{9,0,1,1,21,48},{10,0,1,1,21,48},{11,0,1,1,21,48},{12,1,1,1,21,48},{9,0,1,1,21,49},{10,0,1,1,21,49},{11,0,1,1,21,49},{12,1,1,1,21,49},{9,0,1,1,21,50},{10,0,1,1,21,50},{11,0,1,1,21,50},{12,1,1,1,21,50},{9,0,1,1,21,97},{10,0,1,1,21,97},{11,0,1,1,21,97},{12,1,1,1,21,97},{9,0,1,1,21,99},{10,0,1,1,21,99},{11,0,1,1,21,99},{12,1,1,1,21,99},{9,0,1,1,21,101},{10,0,1,1,21,101},{11,0,1,1,21,101},{12,1,1,1,21,101},{9,0,1,1,21,105},{10,0,1,1,21,105},{11,0,1,1,21,105},{12,1,1,1,21,105},{9,0,1,1,21,111},{10,0,1,1,21,111},{11,0,1,1,21,111},{12,1,1,1,21,111},{9,0,1,1,21,115},{10,0,1,1,21,115},{11,0,1,1,21,115},{12,1,1,1,21,115},{9,0,1,1,21,116},{10,0,1,1,21,116},{11,0,1,1,21,116},{12,1,1,1,21,116},{13,0,1,1,21,32},{14,1,1,1,21,32},{13,0,1,1,21,37},{14,1,1,1,21,37},{13,0,1,1,21,45},{14,1,1,1,21,45},{13,0,1,1,21,46},{14,1,1,1,21,46},{13,0,1,1,21,47},{14,1,1,1,21,47},{13,0,1,1,21,51},{14,1,1,1,21,51},{13,0,1,1,21,52},{14,1,1,1,21,52},{13,0,1,1,21,53},{14,1,1,1,21,53},{13,0,1,1,21,54},{14,1,1,1,21,54},{13,0,1,1,21,55},{14,1,1,1,21,55},{13,0,1,1,21,56},{14,1,1,1,21,56},{13,0,1,1,21,57},{14,1,1,1,21,57},{13,0,1,1,21,61},{14,1,1,1,21,61},{13,0,1,1,21,65},{14,1,1,1,21,65},{13,0,1,1,21,95},{14,1,1,1,21,95},{13,0,1,1,21,98},{14,1,1,1,21,98},{13,0,1,1,21,100},{14,1,1,1,21,100},{13,0,1,1,21,102},{14,1,1,1,21,102},{13,0,1,1,21,103},{14,1,1,1,21,103},{13,0,1,1,21,104},{14,1,1,1,21,104},{13,0,1,1,21,108},{14,1,1,1,21,108},{13,0,1,1,21,109},{14,1,1,1,21,109},{13,0,1,1,21,110},{14,1,1,1,21,110},{13,0,1,1,21,112},{14,1,1,1,21,112},{13,0,1,1,21,114},{14,1,1,1,21,114},{13,0,1,1,21,117},{14,1,1,1,21,117},{0,1,1,1,21,58},{0,1,1,1,21,66},{0,1,1,1,21,67},{0,1,1,1,21,68},{0,1,1,1,21,69},{0,1,1,1,21,70},{0,1,1,1,21,71},{0,1,1,1,21,72},{0,1,1,1,21,73},{0,1,1,1,21,74},{0,1,1,1,21,75},{0,1,1,1,21,76},{0,1,1,1,21,77},{0,1,1,1,21,78},{0,1,1,1,21,79},{0,1,1,1,21,80},{0,1,1,1,21,81},{0,1,1,1,21,82},{0,1,1,1,21,83},{0,1,1,1,21,84},{0,1,1,1,21,85},{0,1,1,1,21,86},{0,1,1,1,21,87},{0,1,1,1,21,89},{0,1,1,1,21,106},{0,1,1,1,21,107},{0,1,1,1,21,113},{0,1,1,1,21,118},{0,1,1,1,21,119},{0,1,1,1,21,120},{0,1,1,1,21,121},{0,1,1,1,21,122},{85,0,0,1,0,21},{86,0,0,1,0,21},{87,0,0,1,0,21},{88,1,0,1,0,21},{9,0,1,1,23,48},{10,0,1,1,23,48},{11,0,1,1,23,48},{12,1,1,1,23,48},{9,0,1,1,23,49},{10,0,1,1,23,49},{11,0,1,1,23,49},{12,1,1,1,23,49},{9,0,1,1,23,50},{10,0,1,1,23,50},{11,0,1,1,23,50},{12,1,1,1,23,50},{9,0,1,1,23,97},{10,0,1,1,23,97},{11,0,1,1,23,97},{12,1,1,1,23,97},{9,0,1,1,23,99},{10,0,1,1,23,99},{11,0,1,1,23,99},{12,1,1,1,23,99},{9,0,1,1,23,101},{10,0,1,1,23,101},{11,0,1,1,23,101},{12,1,1,1,23,101},{9,0,1,1,23,105},{10,0,1,1,23,105},{11,0,1,1,23,105},{12,1,1,1,23,105},{9,0,1,1,23,111},{10,0,1,1,23,111},{11,0,1,1,23,111},{12,1,1,1,23,111},{9,0,1,1,23,115},{10,0,1,1,23,115},{11,0,1,1,23,115},{12,1,1,1,23,115},{9,0,1,1,23,116},{10,0,1,1,23,116},{11,0,1,1,23,116},{12,1,1,1,23,116},{13,0,1,1,23,32},{14,1,1,1,23,32},{13,0,1,1,23,37},{14,1,1,1,23,37},{13,0,1,1,23,45},{14,1,1,1,23,45},{13,0,1,1,23,46},{14,1,1,1,23,46},{13,0,1,1,23,47},{14,1,1,1,23,47},{13,0,1,1,23,51},{14,1,1,1,23,51},{13,0,1,1,23,52},{14,1,1,1,23,52},{13,0,1,1,23,53},{14,1,1,1,23,53},{13,0,1,1,23,54},{14,1,1,1,23,54},{13,0,1,1,23,55},{14,1,1,1,23,55},{13,0,1,1,23,56},{14,1,1,1,23,56},{13,0,1,1,23,57},{14,1,1,1,23,57},{13,0,1,1,23,61},{14,1,1,1,23,61},{13,0,1,1,23,65},{14,1,1,1,23,65},{13,0,1,1,23,95},{14,1,1,1,23,95},{13,0,1,1,23,98},{14,1,1,1,23,98},{13,0,1,1,23,100},{14,1,1,1,23,100},{13,0,1,1,23,102},{14,1,1,1,23,102},{13,0,1,1,23,103},{14,1,1,1,23,103},{13,0,1,1,23,104},{14,1,1,1,23,104},{13,0,1,1,23,108},{14,1,1,1,23,108},{13,0,1,1,23,109},{14,1,1,1,23,109},{13,0,1,1,23,110},{14,1,1,1,23,110},{13,0,1,1,23,112},{14,1,1,1,23,112},{13,0,1,1,23,114},{14,1,1,1,23,114},{13,0,1,1,23,117},{14,1,1,1,23,117},{0,1,1,1,23,58},{0,1,1,1,23,66},{0,1,1,1,23,67},{0,1,1,1,23,68},{0,1,1,1,23,69},{0,1,1,1,23,70},{0,1,1,1,23,71},{0,1,1,1,23,72},{0,1,1,1,23,73},{0,1,1,1,23,74},{0,1,1,1,23,75},{0,1,1,1,23,76},{0,1,1,1,23,77},{0,1,1,1,23,78},{0,1,1,1,23,79},{0,1,1,1,23,80},{0,1,1,1,23,81},{0,1,1,1,23,82},{0,1,1,1,23,83},{0,1,1,1,23,84},{0,1,1,1,23,85},{0,1,1,1,23,86},{0,1,1,1,23,87},{0,1,1,1,23,89},{0,1,1,1,23,106},{0,1,1,1,23,107},{0,1,1,1,23,113},{0,1,1,1,23,118},{0,1,1,1,23,119},{0,1,1,1,23,120},{0,1,1,1,23,121},{0,1,1,1,23,122},{85,0,0,1,0,23},{86,0,0,1,0,23},{87,0,0,1,0,23},{88,1,0,1,0,23},{9,0,1,1,24,48},{10,0,1,1,24,48},{11,0,1,1,24,48},{12,1,1,1,24,48},{9,0,1,1,24,49},{10,0,1,1,24,49},{11,0,1,1,24,49},{12,1,1,1,24,49},{9,0,1,1,24,50},{10,0,1,1,24,50},{11,0,1,1,24,50},{12,1,1,1,24,50},{9,0,1,1,24,97},{10,0,1,1,24,97},{11,0,1,1,24,97},{12,1,1,1,24,97},{9,0,1,1,24,99},{10,0,1,1,24,99},{11,0,1,1,24,99},{12,1,1,1,24,99},{9,0,1,1,24,101},{10,0,1,1,24,101},{11,0,1,1,24,101},{12,1,1,1,24,101},{9,0,1,1,24,105},{10,0,1,1,24,105},{11,0,1,1,24,105},{12,1,1,1,24,105},{9,0,1,1,24,111},{10,0,1,1,24,111},{11,0,1,1,24,111},{12,1,1,1,24,111},{9,0,1,1,24,115},{10,0,1,1,24,115},{11,0,1,1,24,115},{12,1,1,1,24,115},{9,0,1,1,24,116},{10,0,1,1,24,116},{11,0,1,1,24,116},{12,1,1,1,24,116},{13,0,1,1,24,32},{14,1,1,1,24,32},{13,0,1,1,24,37},{14,1,1,1,24,37},{13,0,1,1,24,45},{14,1,1,1,24,45},{13,0,1,1,24,46},{14,1,1,1,24,46},{13,0,1,1,24,47},{14,1,1,1,24,47},{13,0,1,1,24,51},{14,1,1,1,24,51},{13,0,1,1,24,52},{14,1,1,1,24,52},{13,0,1,1,24,53},{14,1,1,1,24,53},{13,0,1,1,24,54},{14,1,1,1,24,54},{13,0,1,1,24,55},{14,1,1,1,24,55},{13,0,1,1,24,56},{14,1,1,1,24,56},{13,0,1,1,24,57},{14,1,1,1,24,57},{13,0,1,1,24,61},{14,1,1,1,24,61},{13,0,1,1,24,65},{14,1,1,1,24,65},{13,0,1,1,24,95},{14,1,1,1,24,95},{13,0,1,1,24,98},{14,1,1,1,24,98},{13,0,1,1,24,100},{14,1,1,1,24,100},{13,0,1,1,24,102},{14,1,1,1,24,102},{13,0,1,1,24,103},{14,1,1,1,24,103},{13,0,1,1,24,104},{14,1,1,1,24,104},{13,0,1,1,24,108},{14,1,1,1,24,108},{13,0,1,1,24,109},{14,1,1,1,24,109},{13,0,1,1,24,110},{14,1,1,1,24,110},{13,0,1,1,24,112},{14,1,1,1,24,112},{13,0,1,1,24,114},{14,1,1,1,24,114},{13,0,1,1,24,117},{14,1,1,1,24,117},{0,1,1,1,24,58},{0,1,1,1,24,66},{0,1,1,1,24,67},{0,1,1,1,24,68},{0,1,1,1,24,69},{0,1,1,1,24,70},{0,1,1,1,24,71},{0,1,1,1,24,72},{0,1,1,1,24,73},{0,1,1,1,24,74},{0,1,1,1,24,75},{0,1,1,1,24,76},{0,1,1,1,24,77},{0,1,1,1,24,78},{0,1,1,1,24,79},{0,1,1,1,24,80},{0,1,1,1,24,81},{0,1,1,1,24,82},{0,1,1,1,24,83},{0,1,1,1,24,84},{0,1,1,1,24,85},{0,1,1,1,24,86},{0,1,1,1,24,87},{0,1,1,1,24,89},{0,1,1,1,24,106},{0,1,1,1,24,107},{0,1,1,1,24,113},{0,1,1,1,24,118},{0,1,1,1,24,119},{0,1,1,1,24,120},{0,1,1,1,24,121},{0,1,1,1,24,122},{85,0,0,1,0,24},{86,0,0,1,0,24},{87,0,0,1,0,24},{88,1,0,1,0,24},{9,0,1,1,25,48},{10,0,1,1,25,48},{11,0,1,1,25,48},{12,1,1,1,25,48},{9,0,1,1,25,49},{10,0,1,1,25,49},{11,0,1,1,25,49},{12,1,1,1,25,49},{9,0,1,1,25,50},{10,0,1,1,25,50},{11,0,1,1,25,50},{12,1,1,1,25,50},{9,0,1,1,25,97},{10,0,1,1,25,97},{11,0,1,1,25,97},{12,1,1,1,25,97},{9,0,1,1,25,99},{10,0,1,1,25,99},{11,0,1,1,25,99},{12,1,1,1,25,99},{9,0,1,1,25,101},{10,0,1,1,25,101},{11,0,1,1,25,101},{12,1,1,1,25,101},{9,0,1,1,25,105},{10,0,1,1,25,105},{11,0,1,1,25,105},{12,1,1,1,25,105},{9,0,1,1,25,111},{10,0,1,1,25,111},{11,0,1,1,25,111},{12,1,1,1,25,111},{9,0,1,1,25,115},{10,0,1,1,25,115},{11,0,1,1,25,115},{12,1,1,1,25,115},{9,0,1,1,25,116},{10,0,1,1,25,116},{11,0,1,1,25,116},{12,1,1,1,25,116},{13,0,1,1,25,32},{14,1,1,1,25,32},{13,0,1,1,25,37},{14,1,1,1,25,37},{13,0,1,1,25,45},{14,1,1,1,25,45},{13,0,1,1,25,46},{14,1,1,1,25,46},{13,0,1,1,25,47},{14,1,1,1,25,47},{13,0,1,1,25,51},{14,1,1,1,25,51},{13,0,1,1,25,52},{14,1,1,1,25,52},{13,0,1,1,25,53},{14,1,1,1,25,53},{13,0,1,1,25,54},{14,1,1,1,25,54},{13,0,1,1,25,55},{14,1,1,1,25,55},{13,0,1,1,25,56},{14,1,1,1,25,56},{13,0,1,1,25,57},{14,1,1,1,25,57},{13,0,1,1,25,61},{14,1,1,1,25,61},{13,0,1,1,25,65},{14,1,1,1,25,65},{13,0,1,1,25,95},{14,1,1,1,25,95},{13,0,1,1,25,98},{14,1,1,1,25,98},{13,0,1,1,25,100},{14,1,1,1,25,100},{13,0,1,1,25,102},{14,1,1,1,25,102},{13,0,1,1,25,103},{14,1,1,1,25,103},{13,0,1,1,25,104},{14,1,1,1,25,104},{13,0,1,1,25,108},{14,1,1,1,25,108},{13,0,1,1,25,109},{14,1,1,1,25,109},{13,0,1,1,25,110},{14,1,1,1,25,110},{13,0,1,1,25,112},{14,1,1,1,25,112},{13,0,1,1,25,114},{14,1,1,1,25,114},{13,0,1,1,25,117},{14,1,1,1,25,117},{0,1,1,1,25,58},{0,1,1,1,25,66},{0,1,1,1,25,67},{0,1,1,1,25,68},{0,1,1,1,25,69},{0,1,1,1,25,70},{0,1,1,1,25,71},{0,1,1,1,25,72},{0,1,1,1,25,73},{0,1,1,1,25,74},{0,1,1,1,25,75},{0,1,1,1,25,76},{0,1,1,1,25,77},{0,1,1,1,25,78},{0,1,1,1,25,79},{0,1,1,1,25,80},{0,1,1,1,25,81},{0,1,1,1,25,82},{0,1,1,1,25,83},{0,1,1,1,25,84},{0,1,1,1,25,85},{0,1,1,1,25,86},{0,1,1,1,25,87},{0,1,1,1,25,89},{0,1,1,1,25,106},{0,1,1,1,25,107},{0,1,1,1,25,113},{0,1,1,1,25,118},{0,1,1,1,25,119},{0,1,1,1,25,120},{0,1,1,1,25,121},{0,1,1,1,25,122},{85,0,0,1,0,25},{86,0,0,1,0,25},{87,0,0,1,0,25},{88,1,0,1,0,25},{9,0,1,1,26,48},{10,0,1,1,26,48},{11,0,1,1,26,48},{12,1,1,1,26,48},{9,0,1,1,26,49},{10,0,1,1,26,49},{11,0,1,1,26,49},{12,1,1,1,26,49},{9,0,1,1,26,50},{10,0,1,1,26,50},{11,0,1,1,26,50},{12,1,1,1,26,50},{9,0,1,1,26,97},{10,0,1,1,26,97},{11,0,1,1,26,97},{12,1,1,1,26,97},{9,0,1,1,26,99},{10,0,1,1,26,99},{11,0,1,1,26,99},{12,1,1,1,26,99},{9,0,1,1,26,101},{10,0,1,1,26,101},{11,0,1,1,26,101},{12,1,1,1,26,101},{9,0,1,1,26,105},{10,0,1,1,26,105},{11,0,1,1,26,105},{12,1,1,1,26,105},{9,0,1,1,26,111},{10,0,1,1,26,111},{11,0,1,1,26,111},{12,1,1,1,26,111},{9,0,1,1,26,115},{10,0,1,1,26,115},{11,0,1,1,26,115},{12,1,1,1,26,115},{9,0,1,1,26,116},{10,0,1,1,26,116},{11,0,1,1,26,116},{12,1,1,1,26,116},{13,0,1,1,26,32},{14,1,1,1,26,32},{13,0,1,1,26,37},{14,1,1,1,26,37},{13,0,1,1,26,45},{14,1,1,1,26,45},{13,0,1,1,26,46},{14,1,1,1,26,46},{13,0,1,1,26,47},{14,1,1,1,26,47},{13,0,1,1,26,51},{14,1,1,1,26,51},{13,0,1,1,26,52},{14,1,1,1,26,52},{13,0,1,1,26,53},{14,1,1,1,26,53},{13,0,1,1,26,54},{14,1,1,1,26,54},{13,0,1,1,26,55},{14,1,1,1,26,55},{13,0,1,1,26,56},{14,1,1,1,26,56},{13,0,1,1,26,57},{14,1,1,1,26,57},{13,0,1,1,26,61},{14,1,1,1,26,61},{13,0,1,1,26,65},{14,1,1,1,26,65},{13,0,1,1,26,95},{14,1,1,1,26,95},{13,0,1,1,26,98},{14,1,1,1,26,98},{13,0,1,1,26,100},{14,1,1,1,26,100},{13,0,1,1,26,102},{14,1,1,1,26,102},{13,0,1,1,26,103},{14,1,1,1,26,103},{13,0,1,1,26,104},{14,1,1,1,26,104},{13,0,1,1,26,108},{14,1,1,1,26,108},{13,0,1,1,26,109},{14,1,1,1,26,109},{13,0,1,1,26,110},{14,1,1,1,26,110},{13,0,1,1,26,112},{14,1,1,1,26,112},{13,0,1,1,26,114},{14,1,1,1,26,114},{13,0,1,1,26,117},{14,1,1,1,26,117},{0,1,1,1,26,58},{0,1,1,1,26,66},{0,1,1,1,26,67},{0,1,1,1,26,68},{0,1,1,1,26,69},{0,1,1,1,26,70},{0,1,1,1,26,71},{0,1,1,1,26,72},{0,1,1,1,26,73},{0,1,1,1,26,74},{0,1,1,1,26,75},{0,1,1,1,26,76},{0,1,1,1,26,77},{0,1,1,1,26,78},{0,1,1,1,26,79},{0,1,1,1,26,80},{0,1,1,1,26,81},{0,1,1,1,26,82},{0,1,1,1,26,83},{0,1,1,1,26,84},{0,1,1,1,26,85},{0,1,1,1,26,86},{0,1,1,1,26,87},{0,1,1,1,26,89},{0,1,1,1,26,106},{0,1,1,1,26,107},{0,1,1,1,26,113},{0,1,1,1,26,118},{0,1,1,1,26,119},{0,1,1,1,26,120},{0,1,1,1,26,121},{0,1,1,1,26,122},{85,0,0,1,0,26},{86,0,0,1,0,26},{87,0,0,1,0,26},{88,1,0,1,0,26},{9,0,1,1,27,48},{10,0,1,1,27,48},{11,0,1,1,27,48},{12,1,1,1,27,48},{9,0,1,1,27,49},{10,0,1,1,27,49},{11,0,1,1,27,49},{12,1,1,1,27,49},{9,0,1,1,27,50},{10,0,1,1,27,50},{11,0,1,1,27,50},{12,1,1,1,27,50},{9,0,1,1,27,97},{10,0,1,1,27,97},{11,0,1,1,27,97},{12,1,1,1,27,97},{9,0,1,1,27,99},{10,0,1,1,27,99},{11,0,1,1,27,99},{12,1,1,1,27,99},{9,0,1,1,27,101},{10,0,1,1,27,101},{11,0,1,1,27,101},{12,1,1,1,27,101},{9,0,1,1,27,105},{10,0,1,1,27,105},{11,0,1,1,27,105},{12,1,1,1,27,105},{9,0,1,1,27,111},{10,0,1,1,27,111},{11,0,1,1,27,111},{12,1,1,1,27,111},{9,0,1,1,27,115},{10,0,1,1,27,115},{11,0,1,1,27,115},{12,1,1,1,27,115},{9,0,1,1,27,116},{10,0,1,1,27,116},{11,0,1,1,27,116},{12,1,1,1,27,116},{13,0,1,1,27,32},{14,1,1,1,27,32},{13,0,1,1,27,37},{14,1,1,1,27,37},{13,0,1,1,27,45},{14,1,1,1,27,45},{13,0,1,1,27,46},{14,1,1,1,27,46},{13,0,1,1,27,47},{14,1,1,1,27,47},{13,0,1,1,27,51},{14,1,1,1,27,51},{13,0,1,1,27,52},{14,1,1,1,27,52},{13,0,1,1,27,53},{14,1,1,1,27,53},{13,0,1,1,27,54},{14,1,1,1,27,54},{13,0,1,1,27,55},{14,1,1,1,27,55},{13,0,1,1,27,56},{14,1,1,1,27,56},{13,0,1,1,27,57},{14,1,1,1,27,57},{13,0,1,1,27,61},{14,1,1,1,27,61},{13,0,1,1,27,65},{14,1,1,1,27,65},{13,0,1,1,27,95},{14,1,1,1,27,95},{13,0,1,1,27,98},{14,1,1,1,27,98},{13,0,1,1,27,100},{14,1,1,1,27,100},{13,0,1,1,27,102},{14,1,1,1,27,102},{13,0,1,1,27,103},{14,1,1,1,27,103},{13,0,1,1,27,104},{14,1,1,1,27,104},{13,0,1,1,27,108},{14,1,1,1,27,108},{13,0,1,1,27,109},{14,1,1,1,27,109},{13,0,1,1,27,110},{14,1,1,1,27,110},{13,0,1,1,27,112},{14,1,1,1,27,112},{13,0,1,1,27,114},{14,1,1,1,27,114},{13,0,1,1,27,117},{14,1,1,1,27,117},{0,1,1,1,27,58},{0,1,1,1,27,66},{0,1,1,1,27,67},{0,1,1,1,27,68},{0,1,1,1,27,69},{0,1,1,1,27,70},{0,1,1,1,27,71},{0,1,1,1,27,72},{0,1,1,1,27,73},{0,1,1,1,27,74},{0,1,1,1,27,75},{0,1,1,1,27,76},{0,1,1,1,27,77},{0,1,1,1,27,78},{0,1,1,1,27,79},{0,1,1,1,27,80},{0,1,1,1,27,81},{0,1,1,1,27,82},{0,1,1,1,27,83},{0,1,1,1,27,84},{0,1,1,1,27,85},{0,1,1,1,27,86},{0,1,1,1,27,87},{0,1,1,1,27,89},{0,1,1,1,27,106},{0,1,1,1,27,107},{0,1,1,1,27,113},{0,1,1,1,27,118},{0,1,1,1,27,119},{0,1,1,1,27,120},{0,1,1,1,27,121},{0,1,1,1,27,122},{85,0,0,1,0,27},{86,0,0,1,0,27},{87,0,0,1,0,27},{88,1,0,1,0,27},{9,0,1,1,28,48},{10,0,1,1,28,48},{11,0,1,1,28,48},{12,1,1,1,28,48},{9,0,1,1,28,49},{10,0,1,1,28,49},{11,0,1,1,28,49},{12,1,1,1,28,49},{9,0,1,1,28,50},{10,0,1,1,28,50},{11,0,1,1,28,50},{12,1,1,1,28,50},{9,0,1,1,28,97},{10,0,1,1,28,97},{11,0,1,1,28,97},{12,1,1,1,28,97},{9,0,1,1,28,99},{10,0,1,1,28,99},{11,0,1,1,28,99},{12,1,1,1,28,99},{9,0,1,1,28,101},{10,0,1,1,28,101},{11,0,1,1,28,101},{12,1,1,1,28,101},{9,0,1,1,28,105},{10,0,1,1,28,105},{11,0,1,1,28,105},{12,1,1,1,28,105},{9,0,1,1,28,111},{10,0,1,1,28,111},{11,0,1,1,28,111},{12,1,1,1,28,111},{9,0,1,1,28,115},{10,0,1,1,28,115},{11,0,1,1,28,115},{12,1,1,1,28,115},{9,0,1,1,28,116},{10,0,1,1,28,116},{11,0,1,1,28,116},{12,1,1,1,28,116},{13,0,1,1,28,32},{14,1,1,1,28,32},{13,0,1,1,28,37},{14,1,1,1,28,37},{13,0,1,1,28,45},{14,1,1,1,28,45},{13,0,1,1,28,46},{14,1,1,1,28,46},{13,0,1,1,28,47},{14,1,1,1,28,47},{13,0,1,1,28,51},{14,1,1,1,28,51},{13,0,1,1,28,52},{14,1,1,1,28,52},{13,0,1,1,28,53},{14,1,1,1,28,53},{13,0,1,1,28,54},{14,1,1,1,28,54},{13,0,1,1,28,55},{14,1,1,1,28,55},{13,0,1,1,28,56},{14,1,1,1,28,56},{13,0,1,1,28,57},{14,1,1,1,28,57},{13,0,1,1,28,61},{14,1,1,1,28,61},{13,0,1,1,28,65},{14,1,1,1,28,65},{13,0,1,1,28,95},{14,1,1,1,28,95},{13,0,1,1,28,98},{14,1,1,1,28,98},{13,0,1,1,28,100},{14,1,1,1,28,100},{13,0,1,1,28,102},{14,1,1,1,28,102},{13,0,1,1,28,103},{14,1,1,1,28,103},{13,0,1,1,28,104},{14,1,1,1,28,104},{13,0,1,1,28,108},{14,1,1,1,28,108},{13,0,1,1,28,109},{14,1,1,1,28,109},{13,0,1,1,28,110},{14,1,1,1,28,110},{13,0,1,1,28,112},{14,1,1,1,28,112},{13,0,1,1,28,114},{14,1,1,1,28,114},{13,0,1,1,28,117},{14,1,1,1,28,117},{0,1,1,1,28,58},{0,1,1,1,28,66},{0,1,1,1,28,67},{0,1,1,1,28,68},{0,1,1,1,28,69},{0,1,1,1,28,70},{0,1,1,1,28,71},{0,1,1,1,28,72},{0,1,1,1,28,73},{0,1,1,1,28,74},{0,1,1,1,28,75},{0,1,1,1,28,76},{0,1,1,1,28,77},{0,1,1,1,28,78},{0,1,1,1,28,79},{0,1,1,1,28,80},{0,1,1,1,28,81},{0,1,1,1,28,82},{0,1,1,1,28,83},{0,1,1,1,28,84},{0,1,1,1,28,85},{0,1,1,1,28,86},{0,1,1,1,28,87},{0,1,1,1,28,89},{0,1,1,1,28,106},{0,1,1,1,28,107},{0,1,1,1,28,113},{0,1,1,1,28,118},{0,1,1,1,28,119},{0,1,1,1,28,120},{0,1,1,1,28,121},{0,1,1,1,28,122},{85,0,0,1,0,28},{86,0,0,1,0,28},{87,0,0,1,0,28},{88,1,0,1,0,28},{9,0,1,1,29,48},{10,0,1,1,29,48},{11,0,1,1,29,48},{12,1,1,1,29,48},{9,0,1,1,29,49},{10,0,1,1,29,49},{11,0,1,1,29,49},{12,1,1,1,29,49},{9,0,1,1,29,50},{10,0,1,1,29,50},{11,0,1,1,29,50},{12,1,1,1,29,50},{9,0,1,1,29,97},{10,0,1,1,29,97},{11,0,1,1,29,97},{12,1,1,1,29,97},{9,0,1,1,29,99},{10,0,1,1,29,99},{11,0,1,1,29,99},{12,1,1,1,29,99},{9,0,1,1,29,101},{10,0,1,1,29,101},{11,0,1,1,29,101},{12,1,1,1,29,101},{9,0,1,1,29,105},{10,0,1,1,29,105},{11,0,1,1,29,105},{12,1,1,1,29,105},{9,0,1,1,29,111},{10,0,1,1,29,111},{11,0,1,1,29,111},{12,1,1,1,29,111},{9,0,1,1,29,115},{10,0,1,1,29,115},{11,0,1,1,29,115},{12,1,1,1,29,115},{9,0,1,1,29,116},{10,0,1,1,29,116},{11,0,1,1,29,116},{12,1,1,1,29,116},{13,0,1,1,29,32},{14,1,1,1,29,32},{13,0,1,1,29,37},{14,1,1,1,29,37},{13,0,1,1,29,45},{14,1,1,1,29,45},{13,0,1,1,29,46},{14,1,1,1,29,46},{13,0,1,1,29,47},{14,1,1,1,29,47},{13,0,1,1,29,51},{14,1,1,1,29,51},{13,0,1,1,29,52},{14,1,1,1,29,52},{13,0,1,1,29,53},{14,1,1,1,29,53},{13,0,1,1,29,54},{14,1,1,1,29,54},{13,0,1,1,29,55},{14,1,1,1,29,55},{13,0,1,1,29,56},{14,1,1,1,29,56},{13,0,1,1,29,57},{14,1,1,1,29,57},{13,0,1,1,29,61},{14,1,1,1,29,61},{13,0,1,1,29,65},{14,1,1,1,29,65},{13,0,1,1,29,95},{14,1,1,1,29,95},{13,0,1,1,29,98},{14,1,1,1,29,98},{13,0,1,1,29,100},{14,1,1,1,29,100},{13,0,1,1,29,102},{14,1,1,1,29,102},{13,0,1,1,29,103},{14,1,1,1,29,103},{13,0,1,1,29,104},{14,1,1,1,29,104},{13,0,1,1,29,108},{14,1,1,1,29,108},{13,0,1,1,29,109},{14,1,1,1,29,109},{13,0,1,1,29,110},{14,1,1,1,29,110},{13,0,1,1,29,112},{14,1,1,1,29,112},{13,0,1,1,29,114},{14,1,1,1,29,114},{13,0,1,1,29,117},{14,1,1,1,29,117},{0,1,1,1,29,58},{0,1,1,1,29,66},{0,1,1,1,29,67},{0,1,1,1,29,68},{0,1,1,1,29,69},{0,1,1,1,29,70},{0,1,1,1,29,71},{0,1,1,1,29,72},{0,1,1,1,29,73},{0,1,1,1,29,74},{0,1,1,1,29,75},{0,1,1,1,29,76},{0,1,1,1,29,77},{0,1,1,1,29,78},{0,1,1,1,29,79},{0,1,1,1,29,80},{0,1,1,1,29,81},{0,1,1,1,29,82},{0,1,1,1,29,83},{0,1,1,1,29,84},{0,1,1,1,29,85},{0,1,1,1,29,86},{0,1,1,1,29,87},{0,1,1,1,29,89},{0,1,1,1,29,106},{0,1,1,1,29,107},{0,1,1,1,29,113},{0,1,1,1,29,118},{0,1,1,1,29,119},{0,1,1,1,29,120},{0,1,1,1,29,121},{0,1,1,1,29,122},{85,0,0,1,0,29},{86,0,0,1,0,29},{87,0,0,1,0,29},{88,1,0,1,0,29},{9,0,1,1,30,48},{10,0,1,1,30,48},{11,0,1,1,30,48},{12,1,1,1,30,48},{9,0,1,1,30,49},{10,0,1,1,30,49},{11,0,1,1,30,49},{12,1,1,1,30,49},{9,0,1,1,30,50},{10,0,1,1,30,50},{11,0,1,1,30,50},{12,1,1,1,30,50},{9,0,1,1,30,97},{10,0,1,1,30,97},{11,0,1,1,30,97},{12,1,1,1,30,97},{9,0,1,1,30,99},{10,0,1,1,30,99},{11,0,1,1,30,99},{12,1,1,1,30,99},{9,0,1,1,30,101},{10,0,1,1,30,101},{11,0,1,1,30,101},{12,1,1,1,30,101},{9,0,1,1,30,105},{10,0,1,1,30,105},{11,0,1,1,30,105},{12,1,1,1,30,105},{9,0,1,1,30,111},{10,0,1,1,30,111},{11,0,1,1,30,111},{12,1,1,1,30,111},{9,0,1,1,30,115},{10,0,1,1,30,115},{11,0,1,1,30,115},{12,1,1,1,30,115},{9,0,1,1,30,116},{10,0,1,1,30,116},{11,0,1,1,30,116},{12,1,1,1,30,116},{13,0,1,1,30,32},{14,1,1,1,30,32},{13,0,1,1,30,37},{14,1,1,1,30,37},{13,0,1,1,30,45},{14,1,1,1,30,45},{13,0,1,1,30,46},{14,1,1,1,30,46},{13,0,1,1,30,47},{14,1,1,1,30,47},{13,0,1,1,30,51},{14,1,1,1,30,51},{13,0,1,1,30,52},{14,1,1,1,30,52},{13,0,1,1,30,53},{14,1,1,1,30,53},{13,0,1,1,30,54},{14,1,1,1,30,54},{13,0,1,1,30,55},{14,1,1,1,30,55},{13,0,1,1,30,56},{14,1,1,1,30,56},{13,0,1,1,30,57},{14,1,1,1,30,57},{13,0,1,1,30,61},{14,1,1,1,30,61},{13,0,1,1,30,65},{14,1,1,1,30,65},{13,0,1,1,30,95},{14,1,1,1,30,95},{13,0,1,1,30,98},{14,1,1,1,30,98},{13,0,1,1,30,100},{14,1,1,1,30,100},{13,0,1,1,30,102},{14,1,1,1,30,102},{13,0,1,1,30,103},{14,1,1,1,30,103},{13,0,1,1,30,104},{14,1,1,1,30,104},{13,0,1,1,30,108},{14,1,1,1,30,108},{13,0,1,1,30,109},{14,1,1,1,30,109},{13,0,1,1,30,110},{14,1,1,1,30,110},{13,0,1,1,30,112},{14,1,1,1,30,112},{13,0,1,1,30,114},{14,1,1,1,30,114},{13,0,1,1,30,117},{14,1,1,1,30,117},{0,1,1,1,30,58},{0,1,1,1,30,66},{0,1,1,1,30,67},{0,1,1,1,30,68},{0,1,1,1,30,69},{0,1,1,1,30,70},{0,1,1,1,30,71},{0,1,1,1,30,72},{0,1,1,1,30,73},{0,1,1,1,30,74},{0,1,1,1,30,75},{0,1,1,1,30,76},{0,1,1,1,30,77},{0,1,1,1,30,78},{0,1,1,1,30,79},{0,1,1,1,30,80},{0,1,1,1,30,81},{0,1,1,1,30,82},{0,1,1,1,30,83},{0,1,1,1,30,84},{0,1,1,1,30,85},{0,1,1,1,30,86},{0,1,1,1,30,87},{0,1,1,1,30,89},{0,1,1,1,30,106},{0,1,1,1,30,107},{0,1,1,1,30,113},{0,1,1,1,30,118},{0,1,1,1,30,119},{0,1,1,1,30,120},{0,1,1,1,30,121},{0,1,1,1,30,122},{85,0,0,1,0,30},{86,0,0,1,0,30},{87,0,0,1,0,30},{88,1,0,1,0,30},{9,0,1,1,31,48},{10,0,1,1,31,48},{11,0,1,1,31,48},{12,1,1,1,31,48},{9,0,1,1,31,49},{10,0,1,1,31,49},{11,0,1,1,31,49},{12,1,1,1,31,49},{9,0,1,1,31,50},{10,0,1,1,31,50},{11,0,1,1,31,50},{12,1,1,1,31,50},{9,0,1,1,31,97},{10,0,1,1,31,97},{11,0,1,1,31,97},{12,1,1,1,31,97},{9,0,1,1,31,99},{10,0,1,1,31,99},{11,0,1,1,31,99},{12,1,1,1,31,99},{9,0,1,1,31,101},{10,0,1,1,31,101},{11,0,1,1,31,101},{12,1,1,1,31,101},{9,0,1,1,31,105},{10,0,1,1,31,105},{11,0,1,1,31,105},{12,1,1,1,31,105},{9,0,1,1,31,111},{10,0,1,1,31,111},{11,0,1,1,31,111},{12,1,1,1,31,111},{9,0,1,1,31,115},{10,0,1,1,31,115},{11,0,1,1,31,115},{12,1,1,1,31,115},{9,0,1,1,31,116},{10,0,1,1,31,116},{11,0,1,1,31,116},{12,1,1,1,31,116},{13,0,1,1,31,32},{14,1,1,1,31,32},{13,0,1,1,31,37},{14,1,1,1,31,37},{13,0,1,1,31,45},{14,1,1,1,31,45},{13,0,1,1,31,46},{14,1,1,1,31,46},{13,0,1,1,31,47},{14,1,1,1,31,47},{13,0,1,1,31,51},{14,1,1,1,31,51},{13,0,1,1,31,52},{14,1,1,1,31,52},{13,0,1,1,31,53},{14,1,1,1,31,53},{13,0,1,1,31,54},{14,1,1,1,31,54},{13,0,1,1,31,55},{14,1,1,1,31,55},{13,0,1,1,31,56},{14,1,1,1,31,56},{13,0,1,1,31,57},{14,1,1,1,31,57},{13,0,1,1,31,61},{14,1,1,1,31,61},{13,0,1,1,31,65},{14,1,1,1,31,65},{13,0,1,1,31,95},{14,1,1,1,31,95},{13,0,1,1,31,98},{14,1,1,1,31,98},{13,0,1,1,31,100},{14,1,1,1,31,100},{13,0,1,1,31,102},{14,1,1,1,31,102},{13,0,1,1,31,103},{14,1,1,1,31,103},{13,0,1,1,31,104},{14,1,1,1,31,104},{13,0,1,1,31,108},{14,1,1,1,31,108},{13,0,1,1,31,109},{14,1,1,1,31,109},{13,0,1,1,31,110},{14,1,1,1,31,110},{13,0,1,1,31,112},{14,1,1,1,31,112},{13,0,1,1,31,114},{14,1,1,1,31,114},{13,0,1,1,31,117},{14,1,1,1,31,117},{0,1,1,1,31,58},{0,1,1,1,31,66},{0,1,1,1,31,67},{0,1,1,1,31,68},{0,1,1,1,31,69},{0,1,1,1,31,70},{0,1,1,1,31,71},{0,1,1,1,31,72},{0,1,1,1,31,73},{0,1,1,1,31,74},{0,1,1,1,31,75},{0,1,1,1,31,76},{0,1,1,1,31,77},{0,1,1,1,31,78},{0,1,1,1,31,79},{0,1,1,1,31,80},{0,1,1,1,31,81},{0,1,1,1,31,82},{0,1,1,1,31,83},{0,1,1,1,31,84},{0,1,1,1,31,85},{0,1,1,1,31,86},{0,1,1,1,31,87},{0,1,1,1,31,89},{0,1,1,1,31,106},{0,1,1,1,31,107},{0,1,1,1,31,113},{0,1,1,1,31,118},{0,1,1,1,31,119},{0,1,1,1,31,120},{0,1,1,1,31,121},{0,1,1,1,31,122},{85,0,0,1,0,31},{86,0,0,1,0,31},{87,0,0,1,0,31},{88,1,0,1,0,31},{9,0,1,1,127,48},{10,0,1,1,127,48},{11,0,1,1,127,48},{12,1,1,1,127,48},{9,0,1,1,127,49},{10,0,1,1,127,49},{11,0,1,1,127,49},{12,1,1,1,127,49},{9,0,1,1,127,50},{10,0,1,1,127,50},{11,0,1,1,127,50},{12,1,1,1,127,50},{9,0,1,1,127,97},{10,0,1,1,127,97},{11,0,1,1,127,97},{12,1,1,1,127,97},{9,0,1,1,127,99},{10,0,1,1,127,99},{11,0,1,1,127,99},{12,1,1,1,127,99},{9,0,1,1,127,101},{10,0,1,1,127,101},{11,0,1,1,127,101},{12,1,1,1,127,101},{9,0,1,1,127,105},{10,0,1,1,127,105},{11,0,1,1,127,105},{12,1,1,1,127,105},{9,0,1,1,127,111},{10,0,1,1,127,111},{11,0,1,1,127,111},{12,1,1,1,127,111},{9,0,1,1,127,115},{10,0,1,1,127,115},{11,0,1,1,127,115},{12,1,1,1,127,115},{9,0,1,1,127,116},{10,0,1,1,127,116},{11,0,1,1,127,116},{12,1,1,1,127,116},{13,0,1,1,127,32},{14,1,1,1,127,32},{13,0,1,1,127,37},{14,1,1,1,127,37},{13,0,1,1,127,45},{14,1,1,1,127,45},{13,0,1,1,127,46},{14,1,1,1,127,46},{13,0,1,1,127,47},{14,1,1,1,127,47},{13,0,1,1,127,51},{14,1,1,1,127,51},{13,0,1,1,127,52},{14,1,1,1,127,52},{13,0,1,1,127,53},{14,1,1,1,127,53},{13,0,1,1,127,54},{14,1,1,1,127,54},{13,0,1,1,127,55},{14,1,1,1,127,55},{13,0,1,1,127,56},{14,1,1,1,127,56},{13,0,1,1,127,57},{14,1,1,1,127,57},{13,0,1,1,127,61},{14,1,1,1,127,61},{13,0,1,1,127,65},{14,1,1,1,127,65},{13,0,1,1,127,95},{14,1,1,1,127,95},{13,0,1,1,127,98},{14,1,1,1,127,98},{13,0,1,1,127,100},{14,1,1,1,127,100},{13,0,1,1,127,102},{14,1,1,1,127,102},{13,0,1,1,127,103},{14,1,1,1,127,103},{13,0,1,1,127,104},{14,1,1,1,127,104},{13,0,1,1,127,108},{14,1,1,1,127,108},{13,0,1,1,127,109},{14,1,1,1,127,109},{13,0,1,1,127,110},{14,1,1,1,127,110},{13,0,1,1,127,112},{14,1,1,1,127,112},{13,0,1,1,127,114},{14,1,1,1,127,114},{13,0,1,1,127,117},{14,1,1,1,127,117},{0,1,1,1,127,58},{0,1,1,1,127,66},{0,1,1,1,127,67},{0,1,1,1,127,68},{0,1,1,1,127,69},{0,1,1,1,127,70},{0,1,1,1,127,71},{0,1,1,1,127,72},{0,1,1,1,127,73},{0,1,1,1,127,74},{0,1,1,1,127,75},{0,1,1,1,127,76},{0,1,1,1,127,77},{0,1,1,1,127,78},{0,1,1,1,127,79},{0,1,1,1,127,80},{0,1,1,1,127,81},{0,1,1,1,127,82},{0,1,1,1,127,83},{0,1,1,1,127,84},{0,1,1,1,127,85},{0,1,1,1,127,86},{0,1,1,1,127,87},{0,1,1,1,127,89},{0,1,1,1,127,106},{0,1,1,1,127,107},{0,1,1,1,127,113},{0,1,1,1,127,118},{0,1,1,1,127,119},{0,1,1,1,127,120},{0,1,1,1,127,121},{0,1,1,1,127,122},{85,0,0,1,0,127},{86,0,0,1,0,127},{87,0,0,1,0,127},{88,1,0,1,0,127},{9,0,1,1,220,48},{10,0,1,1,220,48},{11,0,1,1,220,48},{12,1,1,1,220,48},{9,0,1,1,220,49},{10,0,1,1,220,49},{11,0,1,1,220,49},{12,1,1,1,220,49},{9,0,1,1,220,50},{10,0,1,1,220,50},{11,0,1,1,220,50},{12,1,1,1,220,50},{9,0,1,1,220,97},{10,0,1,1,220,97},{11,0,1,1,220,97},{12,1,1,1,220,97},{9,0,1,1,220,99},{10,0,1,1,220,99},{11,0,1,1,220,99},{12,1,1,1,220,99},{9,0,1,1,220,101},{10,0,1,1,220,101},{11,0,1,1,220,101},{12,1,1,1,220,101},{9,0,1,1,220,105},{10,0,1,1,220,105},{11,0,1,1,220,105},{12,1,1,1,220,105},{9,0,1,1,220,111},{10,0,1,1,220,111},{11,0,1,1,220,111},{12,1,1,1,220,111},{9,0,1,1,220,115},{10,0,1,1,220,115},{11,0,1,1,220,115},{12,1,1,1,220,115},{9,0,1,1,220,116},{10,0,1,1,220,116},{11,0,1,1,220,116},{12,1,1,1,220,116},{13,0,1,1,220,32},{14,1,1,1,220,32},{13,0,1,1,220,37},{14,1,1,1,220,37},{13,0,1,1,220,45},{14,1,1,1,220,45},{13,0,1,1,220,46},{14,1,1,1,220,46},{13,0,1,1,220,47},{14,1,1,1,220,47},{13,0,1,1,220,51},{14,1,1,1,220,51},{13,0,1,1,220,52},{14,1,1,1,220,52},{13,0,1,1,220,53},{14,1,1,1,220,53},{13,0,1,1,220,54},{14,1,1,1,220,54},{13,0,1,1,220,55},{14,1,1,1,220,55},{13,0,1,1,220,56},{14,1,1,1,220,56},{13,0,1,1,220,57},{14,1,1,1,220,57},{13,0,1,1,220,61},{14,1,1,1,220,61},{13,0,1,1,220,65},{14,1,1,1,220,65},{13,0,1,1,220,95},{14,1,1,1,220,95},{13,0,1,1,220,98},{14,1,1,1,220,98},{13,0,1,1,220,100},{14,1,1,1,220,100},{13,0,1,1,220,102},{14,1,1,1,220,102},{13,0,1,1,220,103},{14,1,1,1,220,103},{13,0,1,1,220,104},{14,1,1,1,220,104},{13,0,1,1,220,108},{14,1,1,1,220,108},{13,0,1,1,220,109},{14,1,1,1,220,109},{13,0,1,1,220,110},{14,1,1,1,220,110},{13,0,1,1,220,112},{14,1,1,1,220,112},{13,0,1,1,220,114},{14,1,1,1,220,114},{13,0,1,1,220,117},{14,1,1,1,220,117},{0,1,1,1,220,58},{0,1,1,1,220,66},{0,1,1,1,220,67},{0,1,1,1,220,68},{0,1,1,1,220,69},{0,1,1,1,220,70},{0,1,1,1,220,71},{0,1,1,1,220,72},{0,1,1,1,220,73},{0,1,1,1,220,74},{0,1,1,1,220,75},{0,1,1,1,220,76},{0,1,1,1,220,77},{0,1,1,1,220,78},{0,1,1,1,220,79},{0,1,1,1,220,80},{0,1,1,1,220,81},{0,1,1,1,220,82},{0,1,1,1,220,83},{0,1,1,1,220,84},{0,1,1,1,220,85},{0,1,1,1,220,86},{0,1,1,1,220,87},{0,1,1,1,220,89},{0,1,1,1,220,106},{0,1,1,1,220,107},{0,1,1,1,220,113},{0,1,1,1,220,118},{0,1,1,1,220,119},{0,1,1,1,220,120},{0,1,1,1,220,121},{0,1,1,1,220,122},{85,0,0,1,0,220},{86,0,0,1,0,220},{87,0,0,1,0,220},{88,1,0,1,0,220},{9,0,1,1,249,48},{10,0,1,1,249,48},{11,0,1,1,249,48},{12,1,1,1,249,48},{9,0,1,1,249,49},{10,0,1,1,249,49},{11,0,1,1,249,49},{12,1,1,1,249,49},{9,0,1,1,249,50},{10,0,1,1,249,50},{11,0,1,1,249,50},{12,1,1,1,249,50},{9,0,1,1,249,97},{10,0,1,1,249,97},{11,0,1,1,249,97},{12,1,1,1,249,97},{9,0,1,1,249,99},{10,0,1,1,249,99},{11,0,1,1,249,99},{12,1,1,1,249,99},{9,0,1,1,249,101},{10,0,1,1,249,101},{11,0,1,1,249,101},{12,1,1,1,249,101},{9,0,1,1,249,105},{10,0,1,1,249,105},{11,0,1,1,249,105},{12,1,1,1,249,105},{9,0,1,1,249,111},{10,0,1,1,249,111},{11,0,1,1,249,111},{12,1,1,1,249,111},{9,0,1,1,249,115},{10,0,1,1,249,115},{11,0,1,1,249,115},{12,1,1,1,249,115},{9,0,1,1,249,116},{10,0,1,1,249,116},{11,0,1,1,249,116},{12,1,1,1,249,116},{13,0,1,1,249,32},{14,1,1,1,249,32},{13,0,1,1,249,37},{14,1,1,1,249,37},{13,0,1,1,249,45},{14,1,1,1,249,45},{13,0,1,1,249,46},{14,1,1,1,249,46},{13,0,1,1,249,47},{14,1,1,1,249,47},{13,0,1,1,249,51},{14,1,1,1,249,51},{13,0,1,1,249,52},{14,1,1,1,249,52},{13,0,1,1,249,53},{14,1,1,1,249,53},{13,0,1,1,249,54},{14,1,1,1,249,54},{13,0,1,1,249,55},{14,1,1,1,249,55},{13,0,1,1,249,56},{14,1,1,1,249,56},{13,0,1,1,249,57},{14,1,1,1,249,57},{13,0,1,1,249,61},{14,1,1,1,249,61},{13,0,1,1,249,65},{14,1,1,1,249,65},{13,0,1,1,249,95},{14,1,1,1,249,95},{13,0,1,1,249,98},{14,1,1,1,249,98},{13,0,1,1,249,100},{14,1,1,1,249,100},{13,0,1,1,249,102},{14,1,1,1,249,102},{13,0,1,1,249,103},{14,1,1,1,249,103},{13,0,1,1,249,104},{14,1,1,1,249,104},{13,0,1,1,249,108},{14,1,1,1,249,108},{13,0,1,1,249,109},{14,1,1,1,249,109},{13,0,1,1,249,110},{14,1,1,1,249,110},{13,0,1,1,249,112},{14,1,1,1,249,112},{13,0,1,1,249,114},{14,1,1,1,249,114},{13,0,1,1,249,117},{14,1,1,1,249,117},{0,1,1,1,249,58},{0,1,1,1,249,66},{0,1,1,1,249,67},{0,1,1,1,249,68},{0,1,1,1,249,69},{0,1,1,1,249,70},{0,1,1,1,249,71},{0,1,1,1,249,72},{0,1,1,1,249,73},{0,1,1,1,249,74},{0,1,1,1,249,75},{0,1,1,1,249,76},{0,1,1,1,249,77},{0,1,1,1,249,78},{0,1,1,1,249,79},{0,1,1,1,249,80},{0,1,1,1,249,81},{0,1,1,1,249,82},{0,1,1,1,249,83},{0,1,1,1,249,84},{0,1,1,1,249,85},{0,1,1,1,249,86},{0,1,1,1,249,87},{0,1,1,1,249,89},{0,1,1,1,249,106},{0,1,1,1,249,107},{0,1,1,1,249,113},{0,1,1,1,249,118},{0,1,1,1,249,119},{0,1,1,1,249,120},{0,1,1,1,249,121},{0,1,1,1,249,122},{85,0,0,1,0,249},{86,0,0,1,0,249},{87,0,0,1,0,249},{88,1,0,1,0,249},{0,1,1,1,10,48},{0,1,1,1,10,49},{0,1,1,1,10,50},{0,1,1,1,10,97},{0,1,1,1,10,99},{0,1,1,1,10,101},{0,1,1,1,10,105},{0,1,1,1,10,111},{0,1,1,1,10,115},{0,1,1,1,10,116},{35,0,0,1,0,10},{36,0,0,1,0,10},{37,0,0,1,0,10},{38,0,0,1,0,10},{39,0,0,1,0,10},{40,0,0,1,0,10},{41,0,0,1,0,10},{42,0,0,1,0,10},{43,0,0,1,0,10},{44,0,0,1,0,10},{45,0,0,1,0,10},{46,0,0,1,0,10},{47,0,0,1,0,10},{48,0,0,1,0,10},{49,0,0,1,0,10},{50,0,0,1,0,10},{51,0,0,1,0,10},{52,0,0,1,0,10},{53,0,0,1,0,10},{54,0,0,1,0,10},{55,0,0,1,0,10},{56,1,0,1,0,10},{0,1,1,1,13,48},{0,1,1,1,13,49},{0,1,1,1,13,50},{0,1,1,1,13,97},{0,1,1,1,13,99},{0,1,1,1,13,101},{0,1,1,1,13,105},{0,1,1,1,13,111},{0,1,1,1,13,115},{0,1,1,1,13,116},{35,0,0,1,0,13},{36,0,0,1,0,13},{37,0,0,1,0,13},{38,0,0,1,0,13},{39,0,0,1,0,13},{40,0,0,1,0,13},{41,0,0,1,0,13},{42,0,0,1,0,13},{43,0,0,1,0,13},{44,0,0,1,0,13},{45,0,0,1,0,13},{46,0,0,1,0,13},{47,0,0,1,0,13},{48,0,0,1,0,13},{49,0,0,1,0,13},{50,0,0,1,0,13},{51,0,0,1,0,13},{52,0,0,1,0,13},{53,0,0,1,0,13},{54,0,0,1,0,13},{55,0,0,1,0,13},{56,1,0,1,0,13},{0,1,1,1,22,48},{0,1,1,1,22,49},{0,1,1,1,22,50},{0,1,1,1,22,97},{0,1,1,1,22,99},{0,1,1,1,22,101},{0,1,1,1,22,105},{0,1,1,1,22,111},{0,1,1,1,22,115},{0,1,1,1,22,116},{35,0,0,1,0,22},{36,0,0,1,0,22},{37,0,0,1,0,22},{38,0,0,1,0,22},{39,0,0,1,0,22},{40,0,0,1,0,22},{41,0,0,1,0,22},{42,0,0,1,0,22},{43,0,0,1,0,22},{44,0,0,1,0,22},{45,0,0,1,0,22},{46,0,0,1,0,22},{47,0,0,1,0,22},{48,0,0,1,0,22},{49,0,0,1,0,22},{50,0,0,1,0,22},{51,0,0,1,0,22},{52,0,0,1,0,22},{53,0,0,1,0,22},{54,0,0,1,0,22},{55,0,0,1,0,22},{56,1,0,1,0,22},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{9,0,1,1,203,48},{10,0,1,1,203,48},{11,0,1,1,203,48},{12,1,1,1,203,48},{9,0,1,1,203,49},{10,0,1,1,203,49},{11,0,1,1,203,49},{12,1,1,1,203,49},{9,0,1,1,203,50},{10,0,1,1,203,50},{11,0,1,1,203,50},{12,1,1,1,203,50},{9,0,1,1,203,97},{10,0,1,1,203,97},{11,0,1,1,203,97},{12,1,1,1,203,97},{9,0,1,1,203,99},{10,0,1,1,203,99},{11,0,1,1,203,99},{12,1,1,1,203,99},{9,0,1,1,203,101},{10,0,1,1,203,101},{11,0,1,1,203,101},{12,1,1,1,203,101},{9,0,1,1,203,105},{10,0,1,1,203,105},{11,0,1,1,203,105},{12,1,1,1,203,105},{9,0,1,1,203,111},{10,0,1,1,203,111},{11,0,1,1,203,111},{12,1,1,1,203,111},{9,0,1,1,203,115},{10,0,1,1,203,115},{11,0,1,1,203,115},{12,1,1,1,203,115},{9,0,1,1,203,116},{10,0,1,1,203,116},{11,0,1,1,203,116},{12,1,1,1,203,116},{13,0,1,1,203,32},{14,1,1,1,203,32},{13,0,1,1,203,37},{14,1,1,1,203,37},{13,0,1,1,203,45},{14,1,1,1,203,45},{13,0,1,1,203,46},{14,1,1,1,203,46},{13,0,1,1,203,47},{14,1,1,1,203,47},{13,0,1,1,203,51},{14,1,1,1,203,51},{13,0,1,1,203,52},{14,1,1,1,203,52},{13,0,1,1,203,53},{14,1,1,1,203,53},{13,0,1,1,203,54},{14,1,1,1,203,54},{13,0,1,1,203,55},{14,1,1,1,203,55},{13,0,1,1,203,56},{14,1,1,1,203,56},{13,0,1,1,203,57},{14,1,1,1,203,57},{13,0,1,1,203,61},{14,1,1,1,203,61},{13,0,1,1,203,65},{14,1,1,1,203,65},{13,0,1,1,203,95},{14,1,1,1,203,95},{13,0,1,1,203,98},{14,1,1,1,203,98},{13,0,1,1,203,100},{14,1,1,1,203,100},{13,0,1,1,203,102},{14,1,1,1,203,102},{13,0,1,1,203,103},{14,1,1,1,203,103},{13,0,1,1,203,104},{14,1,1,1,203,104},{13,0,1,1,203,108},{14,1,1,1,203,108},{13,0,1,1,203,109},{14,1,1,1,203,109},{13,0,1,1,203,110},{14,1,1,1,203,110},{13,0,1,1,203,112},{14,1,1,1,203,112},{13,0,1,1,203,114},{14,1,1,1,203,114},{13,0,1,1,203,117},{14,1,1,1,203,117},{0,1,1,1,203,58},{0,1,1,1,203,66},{0,1,1,1,203,67},{0,1,1,1,203,68},{0,1,1,1,203,69},{0,1,1,1,203,70},{0,1,1,1,203,71},{0,1,1,1,203,72},{0,1,1,1,203,73},{0,1,1,1,203,74},{0,1,1,1,203,75},{0,1,1,1,203,76},{0,1,1,1,203,77},{0,1,1,1,203,78},{0,1,1,1,203,79},{0,1,1,1,203,80},{0,1,1,1,203,81},{0,1,1,1,203,82},{0,1,1,1,203,83},{0,1,1,1,203,84},{0,1,1,1,203,85},{0,1,1,1,203,86},{0,1,1,1,203,87},{0,1,1,1,203,89},{0,1,1,1,203,106},{0,1,1,1,203,107},{0,1,1,1,203,113},{0,1,1,1,203,118},{0,1,1,1,203,119},{0,1,1,1,203,120},{0,1,1,1,203,121},{0,1,1,1,203,122},{85,0,0,1,0,203},{86,0,0,1,0,203},{87,0,0,1,0,203},{88,1,0,1,0,203},{9,0,1,1,204,48},{10,0,1,1,204,48},{11,0,1,1,204,48},{12,1,1,1,204,48},{9,0,1,1,204,49},{10,0,1,1,204,49},{11,0,1,1,204,49},{12,1,1,1,204,49},{9,0,1,1,204,50},{10,0,1,1,204,50},{11,0,1,1,204,50},{12,1,1,1,204,50},{9,0,1,1,204,97},{10,0,1,1,204,97},{11,0,1,1,204,97},{12,1,1,1,204,97},{9,0,1,1,204,99},{10,0,1,1,204,99},{11,0,1,1,204,99},{12,1,1,1,204,99},{9,0,1,1,204,101},{10,0,1,1,204,101},{11,0,1,1,204,101},{12,1,1,1,204,101},{9,0,1,1,204,105},{10,0,1,1,204,105},{11,0,1,1,204,105},{12,1,1,1,204,105},{9,0,1,1,204,111},{10,0,1,1,204,111},{11,0,1,1,204,111},{12,1,1,1,204,111},{9,0,1,1,204,115},{10,0,1,1,204,115},{11,0,1,1,204,115},{12,1,1,1,204,115},{9,0,1,1,204,116},{10,0,1,1,204,116},{11,0,1,1,204,116},{12,1,1,1,204,116},{13,0,1,1,204,32},{14,1,1,1,204,32},{13,0,1,1,204,37},{14,1,1,1,204,37},{13,0,1,1,204,45},{14,1,1,1,204,45},{13,0,1,1,204,46},{14,1,1,1,204,46},{13,0,1,1,204,47},{14,1,1,1,204,47},{13,0,1,1,204,51},{14,1,1,1,204,51},{13,0,1,1,204,52},{14,1,1,1,204,52},{13,0,1,1,204,53},{14,1,1,1,204,53},{13,0,1,1,204,54},{14,1,1,1,204,54},{13,0,1,1,204,55},{14,1,1,1,204,55},{13,0,1,1,204,56},{14,1,1,1,204,56},{13,0,1,1,204,57},{14,1,1,1,204,57},{13,0,1,1,204,61},{14,1,1,1,204,61},{13,0,1,1,204,65},{14,1,1,1,204,65},{13,0,1,1,204,95},{14,1,1,1,204,95},{13,0,1,1,204,98},{14,1,1,1,204,98},{13,0,1,1,204,100},{14,1,1,1,204,100},{13,0,1,1,204,102},{14,1,1,1,204,102},{13,0,1,1,204,103},{14,1,1,1,204,103},{13,0,1,1,204,104},{14,1,1,1,204,104},{13,0,1,1,204,108},{14,1,1,1,204,108},{13,0,1,1,204,109},{14,1,1,1,204,109},{13,0,1,1,204,110},{14,1,1,1,204,110},{13,0,1,1,204,112},{14,1,1,1,204,112},{13,0,1,1,204,114},{14,1,1,1,204,114},{13,0,1,1,204,117},{14,1,1,1,204,117},{0,1,1,1,204,58},{0,1,1,1,204,66},{0,1,1,1,204,67},{0,1,1,1,204,68},{0,1,1,1,204,69},{0,1,1,1,204,70},{0,1,1,1,204,71},{0,1,1,1,204,72},{0,1,1,1,204,73},{0,1,1,1,204,74},{0,1,1,1,204,75},{0,1,1,1,204,76},{0,1,1,1,204,77},{0,1,1,1,204,78},{0,1,1,1,204,79},{0,1,1,1,204,80},{0,1,1,1,204,81},{0,1,1,1,204,82},{0,1,1,1,204,83},{0,1,1,1,204,84},{0,1,1,1,204,85},{0,1,1,1,204,86},{0,1,1,1,204,87},{0,1,1,1,204,89},{0,1,1,1,204,106},{0,1,1,1,204,107},{0,1,1,1,204,113},{0,1,1,1,204,118},{0,1,1,1,204,119},{0,1,1,1,204,120},{0,1,1,1,204,121},{0,1,1,1,204,122},{85,0,0,1,0,204},{86,0,0,1,0,204},{87,0,0,1,0,204},{88,1,0,1,0,204},{9,0,1,1,211,48},{10,0,1,1,211,48},{11,0,1,1,211,48},{12,1,1,1,211,48},{9,0,1,1,211,49},{10,0,1,1,211,49},{11,0,1,1,211,49},{12,1,1,1,211,49},{9,0,1,1,211,50},{10,0,1,1,211,50},{11,0,1,1,211,50},{12,1,1,1,211,50},{9,0,1,1,211,97},{10,0,1,1,211,97},{11,0,1,1,211,97},{12,1,1,1,211,97},{9,0,1,1,211,99},{10,0,1,1,211,99},{11,0,1,1,211,99},{12,1,1,1,211,99},{9,0,1,1,211,101},{10,0,1,1,211,101},{11,0,1,1,211,101},{12,1,1,1,211,101},{9,0,1,1,211,105},{10,0,1,1,211,105},{11,0,1,1,211,105},{12,1,1,1,211,105},{9,0,1,1,211,111},{10,0,1,1,211,111},{11,0,1,1,211,111},{12,1,1,1,211,111},{9,0,1,1,211,115},{10,0,1,1,211,115},{11,0,1,1,211,115},{12,1,1,1,211,115},{9,0,1,1,211,116},{10,0,1,1,211,116},{11,0,1,1,211,116},{12,1,1,1,211,116},{13,0,1,1,211,32},{14,1,1,1,211,32},{13,0,1,1,211,37},{14,1,1,1,211,37},{13,0,1,1,211,45},{14,1,1,1,211,45},{13,0,1,1,211,46},{14,1,1,1,211,46},{13,0,1,1,211,47},{14,1,1,1,211,47},{13,0,1,1,211,51},{14,1,1,1,211,51},{13,0,1,1,211,52},{14,1,1,1,211,52},{13,0,1,1,211,53},{14,1,1,1,211,53},{13,0,1,1,211,54},{14,1,1,1,211,54},{13,0,1,1,211,55},{14,1,1,1,211,55},{13,0,1,1,211,56},{14,1,1,1,211,56},{13,0,1,1,211,57},{14,1,1,1,211,57},{13,0,1,1,211,61},{14,1,1,1,211,61},{13,0,1,1,211,65},{14,1,1,1,211,65},{13,0,1,1,211,95},{14,1,1,1,211,95},{13,0,1,1,211,98},{14,1,1,1,211,98},{13,0,1,1,211,100},{14,1,1,1,211,100},{13,0,1,1,211,102},{14,1,1,1,211,102},{13,0,1,1,211,103},{14,1,1,1,211,103},{13,0,1,1,211,104},{14,1,1,1,211,104},{13,0,1,1,211,108},{14,1,1,1,211,108},{13,0,1,1,211,109},{14,1,1,1,211,109},{13,0,1,1,211,110},{14,1,1,1,211,110},{13,0,1,1,211,112},{14,1,1,1,211,112},{13,0,1,1,211,114},{14,1,1,1,211,114},{13,0,1,1,211,117},{14,1,1,1,211,117},{0,1,1,1,211,58},{0,1,1,1,211,66},{0,1,1,1,211,67},{0,1,1,1,211,68},{0,1,1,1,211,69},{0,1,1,1,211,70},{0,1,1,1,211,71},{0,1,1,1,211,72},{0,1,1,1,211,73},{0,1,1,1,211,74},{0,1,1,1,211,75},{0,1,1,1,211,76},{0,1,1,1,211,77},{0,1,1,1,211,78},{0,1,1,1,211,79},{0,1,1,1,211,80},{0,1,1,1,211,81},{0,1,1,1,211,82},{0,1,1,1,211,83},{0,1,1,1,211,84},{0,1,1,1,211,85},{0,1,1,1,211,86},{0,1,1,1,211,87},{0,1,1,1,211,89},{0,1,1,1,211,106},{0,1,1,1,211,107},{0,1,1,1,211,113},{0,1,1,1,211,118},{0,1,1,1,211,119},{0,1,1,1,211,120},{0,1,1,1,211,121},{0,1,1,1,211,122},{85,0,0,1,0,211},{86,0,0,1,0,211},{87,0,0,1,0,211},{88,1,0,1,0,211},{9,0,1,1,212,48},{10,0,1,1,212,48},{11,0,1,1,212,48},{12,1,1,1,212,48},{9,0,1,1,212,49},{10,0,1,1,212,49},{11,0,1,1,212,49},{12,1,1,1,212,49},{9,0,1,1,212,50},{10,0,1,1,212,50},{11,0,1,1,212,50},{12,1,1,1,212,50},{9,0,1,1,212,97},{10,0,1,1,212,97},{11,0,1,1,212,97},{12,1,1,1,212,97},{9,0,1,1,212,99},{10,0,1,1,212,99},{11,0,1,1,212,99},{12,1,1,1,212,99},{9,0,1,1,212,101},{10,0,1,1,212,101},{11,0,1,1,212,101},{12,1,1,1,212,101},{9,0,1,1,212,105},{10,0,1,1,212,105},{11,0,1,1,212,105},{12,1,1,1,212,105},{9,0,1,1,212,111},{10,0,1,1,212,111},{11,0,1,1,212,111},{12,1,1,1,212,111},{9,0,1,1,212,115},{10,0,1,1,212,115},{11,0,1,1,212,115},{12,1,1,1,212,115},{9,0,1,1,212,116},{10,0,1,1,212,116},{11,0,1,1,212,116},{12,1,1,1,212,116},{13,0,1,1,212,32},{14,1,1,1,212,32},{13,0,1,1,212,37},{14,1,1,1,212,37},{13,0,1,1,212,45},{14,1,1,1,212,45},{13,0,1,1,212,46},{14,1,1,1,212,46},{13,0,1,1,212,47},{14,1,1,1,212,47},{13,0,1,1,212,51},{14,1,1,1,212,51},{13,0,1,1,212,52},{14,1,1,1,212,52},{13,0,1,1,212,53},{14,1,1,1,212,53},{13,0,1,1,212,54},{14,1,1,1,212,54},{13,0,1,1,212,55},{14,1,1,1,212,55},{13,0,1,1,212,56},{14,1,1,1,212,56},{13,0,1,1,212,57},{14,1,1,1,212,57},{13,0,1,1,212,61},{14,1,1,1,212,61},{13,0,1,1,212,65},{14,1,1,1,212,65},{13,0,1,1,212,95},{14,1,1,1,212,95},{13,0,1,1,212,98},{14,1,1,1,212,98},{13,0,1,1,212,100},{14,1,1,1,212,100},{13,0,1,1,212,102},{14,1,1,1,212,102},{13,0,1,1,212,103},{14,1,1,1,212,103},{13,0,1,1,212,104},{14,1,1,1,212,104},{13,0,1,1,212,108},{14,1,1,1,212,108},{13,0,1,1,212,109},{14,1,1,1,212,109},{13,0,1,1,212,110},{14,1,1,1,212,110},{13,0,1,1,212,112},{14,1,1,1,212,112},{13,0,1,1,212,114},{14,1,1,1,212,114},{13,0,1,1,212,117},{14,1,1,1,212,117},{0,1,1,1,212,58},{0,1,1,1,212,66},{0,1,1,1,212,67},{0,1,1,1,212,68},{0,1,1,1,212,69},{0,1,1,1,212,70},{0,1,1,1,212,71},{0,1,1,1,212,72},{0,1,1,1,212,73},{0,1,1,1,212,74},{0,1,1,1,212,75},{0,1,1,1,212,76},{0,1,1,1,212,77},{0,1,1,1,212,78},{0,1,1,1,212,79},{0,1,1,1,212,80},{0,1,1,1,212,81},{0,1,1,1,212,82},{0,1,1,1,212,83},{0,1,1,1,212,84},{0,1,1,1,212,85},{0,1,1,1,212,86},{0,1,1,1,212,87},{0,1,1,1,212,89},{0,1,1,1,212,106},{0,1,1,1,212,107},{0,1,1,1,212,113},{0,1,1,1,212,118},{0,1,1,1,212,119},{0,1,1,1,212,120},{0,1,1,1,212,121},{0,1,1,1,212,122},{85,0,0,1,0,212},{86,0,0,1,0,212},{87,0,0,1,0,212},{88,1,0,1,0,212},{9,0,1,1,214,48},{10,0,1,1,214,48},{11,0,1,1,214,48},{12,1,1,1,214,48},{9,0,1,1,214,49},{10,0,1,1,214,49},{11,0,1,1,214,49},{12,1,1,1,214,49},{9,0,1,1,214,50},{10,0,1,1,214,50},{11,0,1,1,214,50},{12,1,1,1,214,50},{9,0,1,1,214,97},{10,0,1,1,214,97},{11,0,1,1,214,97},{12,1,1,1,214,97},{9,0,1,1,214,99},{10,0,1,1,214,99},{11,0,1,1,214,99},{12,1,1,1,214,99},{9,0,1,1,214,101},{10,0,1,1,214,101},{11,0,1,1,214,101},{12,1,1,1,214,101},{9,0,1,1,214,105},{10,0,1,1,214,105},{11,0,1,1,214,105},{12,1,1,1,214,105},{9,0,1,1,214,111},{10,0,1,1,214,111},{11,0,1,1,214,111},{12,1,1,1,214,111},{9,0,1,1,214,115},{10,0,1,1,214,115},{11,0,1,1,214,115},{12,1,1,1,214,115},{9,0,1,1,214,116},{10,0,1,1,214,116},{11,0,1,1,214,116},{12,1,1,1,214,116},{13,0,1,1,214,32},{14,1,1,1,214,32},{13,0,1,1,214,37},{14,1,1,1,214,37},{13,0,1,1,214,45},{14,1,1,1,214,45},{13,0,1,1,214,46},{14,1,1,1,214,46},{13,0,1,1,214,47},{14,1,1,1,214,47},{13,0,1,1,214,51},{14,1,1,1,214,51},{13,0,1,1,214,52},{14,1,1,1,214,52},{13,0,1,1,214,53},{14,1,1,1,214,53},{13,0,1,1,214,54},{14,1,1,1,214,54},{13,0,1,1,214,55},{14,1,1,1,214,55},{13,0,1,1,214,56},{14,1,1,1,214,56},{13,0,1,1,214,57},{14,1,1,1,214,57},{13,0,1,1,214,61},{14,1,1,1,214,61},{13,0,1,1,214,65},{14,1,1,1,214,65},{13,0,1,1,214,95},{14,1,1,1,214,95},{13,0,1,1,214,98},{14,1,1,1,214,98},{13,0,1,1,214,100},{14,1,1,1,214,100},{13,0,1,1,214,102},{14,1,1,1,214,102},{13,0,1,1,214,103},{14,1,1,1,214,103},{13,0,1,1,214,104},{14,1,1,1,214,104},{13,0,1,1,214,108},{14,1,1,1,214,108},{13,0,1,1,214,109},{14,1,1,1,214,109},{13,0,1,1,214,110},{14,1,1,1,214,110},{13,0,1,1,214,112},{14,1,1,1,214,112},{13,0,1,1,214,114},{14,1,1,1,214,114},{13,0,1,1,214,117},{14,1,1,1,214,117},{0,1,1,1,214,58},{0,1,1,1,214,66},{0,1,1,1,214,67},{0,1,1,1,214,68},{0,1,1,1,214,69},{0,1,1,1,214,70},{0,1,1,1,214,71},{0,1,1,1,214,72},{0,1,1,1,214,73},{0,1,1,1,214,74},{0,1,1,1,214,75},{0,1,1,1,214,76},{0,1,1,1,214,77},{0,1,1,1,214,78},{0,1,1,1,214,79},{0,1,1,1,214,80},{0,1,1,1,214,81},{0,1,1,1,214,82},{0,1,1,1,214,83},{0,1,1,1,214,84},{0,1,1,1,214,85},{0,1,1,1,214,86},{0,1,1,1,214,87},{0,1,1,1,214,89},{0,1,1,1,214,106},{0,1,1,1,214,107},{0,1,1,1,214,113},{0,1,1,1,214,118},{0,1,1,1,214,119},{0,1,1,1,214,120},{0,1,1,1,214,121},{0,1,1,1,214,122},{85,0,0,1,0,214},{86,0,0,1,0,214},{87,0,0,1,0,214},{88,1,0,1,0,214},{9,0,1,1,221,48},{10,0,1,1,221,48},{11,0,1,1,221,48},{12,1,1,1,221,48},{9,0,1,1,221,49},{10,0,1,1,221,49},{11,0,1,1,221,49},{12,1,1,1,221,49},{9,0,1,1,221,50},{10,0,1,1,221,50},{11,0,1,1,221,50},{12,1,1,1,221,50},{9,0,1,1,221,97},{10,0,1,1,221,97},{11,0,1,1,221,97},{12,1,1,1,221,97},{9,0,1,1,221,99},{10,0,1,1,221,99},{11,0,1,1,221,99},{12,1,1,1,221,99},{9,0,1,1,221,101},{10,0,1,1,221,101},{11,0,1,1,221,101},{12,1,1,1,221,101},{9,0,1,1,221,105},{10,0,1,1,221,105},{11,0,1,1,221,105},{12,1,1,1,221,105},{9,0,1,1,221,111},{10,0,1,1,221,111},{11,0,1,1,221,111},{12,1,1,1,221,111},{9,0,1,1,221,115},{10,0,1,1,221,115},{11,0,1,1,221,115},{12,1,1,1,221,115},{9,0,1,1,221,116},{10,0,1,1,221,116},{11,0,1,1,221,116},{12,1,1,1,221,116},{13,0,1,1,221,32},{14,1,1,1,221,32},{13,0,1,1,221,37},{14,1,1,1,221,37},{13,0,1,1,221,45},{14,1,1,1,221,45},{13,0,1,1,221,46},{14,1,1,1,221,46},{13,0,1,1,221,47},{14,1,1,1,221,47},{13,0,1,1,221,51},{14,1,1,1,221,51},{13,0,1,1,221,52},{14,1,1,1,221,52},{13,0,1,1,221,53},{14,1,1,1,221,53},{13,0,1,1,221,54},{14,1,1,1,221,54},{13,0,1,1,221,55},{14,1,1,1,221,55},{13,0,1,1,221,56},{14,1,1,1,221,56},{13,0,1,1,221,57},{14,1,1,1,221,57},{13,0,1,1,221,61},{14,1,1,1,221,61},{13,0,1,1,221,65},{14,1,1,1,221,65},{13,0,1,1,221,95},{14,1,1,1,221,95},{13,0,1,1,221,98},{14,1,1,1,221,98},{13,0,1,1,221,100},{14,1,1,1,221,100},{13,0,1,1,221,102},{14,1,1,1,221,102},{13,0,1,1,221,103},{14,1,1,1,221,103},{13,0,1,1,221,104},{14,1,1,1,221,104},{13,0,1,1,221,108},{14,1,1,1,221,108},{13,0,1,1,221,109},{14,1,1,1,221,109},{13,0,1,1,221,110},{14,1,1,1,221,110},{13,0,1,1,221,112},{14,1,1,1,221,112},{13,0,1,1,221,114},{14,1,1,1,221,114},{13,0,1,1,221,117},{14,1,1,1,221,117},{0,1,1,1,221,58},{0,1,1,1,221,66},{0,1,1,1,221,67},{0,1,1,1,221,68},{0,1,1,1,221,69},{0,1,1,1,221,70},{0,1,1,1,221,71},{0,1,1,1,221,72},{0,1,1,1,221,73},{0,1,1,1,221,74},{0,1,1,1,221,75},{0,1,1,1,221,76},{0,1,1,1,221,77},{0,1,1,1,221,78},{0,1,1,1,221,79},{0,1,1,1,221,80},{0,1,1,1,221,81},{0,1,1,1,221,82},{0,1,1,1,221,83},{0,1,1,1,221,84},{0,1,1,1,221,85},{0,1,1,1,221,86},{0,1,1,1,221,87},{0,1,1,1,221,89},{0,1,1,1,221,106},{0,1,1,1,221,107},{0,1,1,1,221,113},{0,1,1,1,221,118},{0,1,1,1,221,119},{0,1,1,1,221,120},{0,1,1,1,221,121},{0,1,1,1,221,122},{85,0,0,1,0,221},{86,0,0,1,0,221},{87,0,0,1,0,221},{88,1,0,1,0,221},{9,0,1,1,222,48},{10,0,1,1,222,48},{11,0,1,1,222,48},{12,1,1,1,222,48},{9,0,1,1,222,49},{10,0,1,1,222,49},{11,0,1,1,222,49},{12,1,1,1,222,49},{9,0,1,1,222,50},{10,0,1,1,222,50},{11,0,1,1,222,50},{12,1,1,1,222,50},{9,0,1,1,222,97},{10,0,1,1,222,97},{11,0,1,1,222,97},{12,1,1,1,222,97},{9,0,1,1,222,99},{10,0,1,1,222,99},{11,0,1,1,222,99},{12,1,1,1,222,99},{9,0,1,1,222,101},{10,0,1,1,222,101},{11,0,1,1,222,101},{12,1,1,1,222,101},{9,0,1,1,222,105},{10,0,1,1,222,105},{11,0,1,1,222,105},{12,1,1,1,222,105},{9,0,1,1,222,111},{10,0,1,1,222,111},{11,0,1,1,222,111},{12,1,1,1,222,111},{9,0,1,1,222,115},{10,0,1,1,222,115},{11,0,1,1,222,115},{12,1,1,1,222,115},{9,0,1,1,222,116},{10,0,1,1,222,116},{11,0,1,1,222,116},{12,1,1,1,222,116},{13,0,1,1,222,32},{14,1,1,1,222,32},{13,0,1,1,222,37},{14,1,1,1,222,37},{13,0,1,1,222,45},{14,1,1,1,222,45},{13,0,1,1,222,46},{14,1,1,1,222,46},{13,0,1,1,222,47},{14,1,1,1,222,47},{13,0,1,1,222,51},{14,1,1,1,222,51},{13,0,1,1,222,52},{14,1,1,1,222,52},{13,0,1,1,222,53},{14,1,1,1,222,53},{13,0,1,1,222,54},{14,1,1,1,222,54},{13,0,1,1,222,55},{14,1,1,1,222,55},{13,0,1,1,222,56},{14,1,1,1,222,56},{13,0,1,1,222,57},{14,1,1,1,222,57},{13,0,1,1,222,61},{14,1,1,1,222,61},{13,0,1,1,222,65},{14,1,1,1,222,65},{13,0,1,1,222,95},{14,1,1,1,222,95},{13,0,1,1,222,98},{14,1,1,1,222,98},{13,0,1,1,222,100},{14,1,1,1,222,100},{13,0,1,1,222,102},{14,1,1,1,222,102},{13,0,1,1,222,103},{14,1,1,1,222,103},{13,0,1,1,222,104},{14,1,1,1,222,104},{13,0,1,1,222,108},{14,1,1,1,222,108},{13,0,1,1,222,109},{14,1,1,1,222,109},{13,0,1,1,222,110},{14,1,1,1,222,110},{13,0,1,1,222,112},{14,1,1,1,222,112},{13,0,1,1,222,114},{14,1,1,1,222,114},{13,0,1,1,222,117},{14,1,1,1,222,117},{0,1,1,1,222,58},{0,1,1,1,222,66},{0,1,1,1,222,67},{0,1,1,1,222,68},{0,1,1,1,222,69},{0,1,1,1,222,70},{0,1,1,1,222,71},{0,1,1,1,222,72},{0,1,1,1,222,73},{0,1,1,1,222,74},{0,1,1,1,222,75},{0,1,1,1,222,76},{0,1,1,1,222,77},{0,1,1,1,222,78},{0,1,1,1,222,79},{0,1,1,1,222,80},{0,1,1,1,222,81},{0,1,1,1,222,82},{0,1,1,1,222,83},{0,1,1,1,222,84},{0,1,1,1,222,85},{0,1,1,1,222,86},{0,1,1,1,222,87},{0,1,1,1,222,89},{0,1,1,1,222,106},{0,1,1,1,222,107},{0,1,1,1,222,113},{0,1,1,1,222,118},{0,1,1,1,222,119},{0,1,1,1,222,120},{0,1,1,1,222,121},{0,1,1,1,222,122},{85,0,0,1,0,222},{86,0,0,1,0,222},{87,0,0,1,0,222},{88,1,0,1,0,222},{9,0,1,1,223,48},{10,0,1,1,223,48},{11,0,1,1,223,48},{12,1,1,1,223,48},{9,0,1,1,223,49},{10,0,1,1,223,49},{11,0,1,1,223,49},{12,1,1,1,223,49},{9,0,1,1,223,50},{10,0,1,1,223,50},{11,0,1,1,223,50},{12,1,1,1,223,50},{9,0,1,1,223,97},{10,0,1,1,223,97},{11,0,1,1,223,97},{12,1,1,1,223,97},{9,0,1,1,223,99},{10,0,1,1,223,99},{11,0,1,1,223,99},{12,1,1,1,223,99},{9,0,1,1,223,101},{10,0,1,1,223,101},{11,0,1,1,223,101},{12,1,1,1,223,101},{9,0,1,1,223,105},{10,0,1,1,223,105},{11,0,1,1,223,105},{12,1,1,1,223,105},{9,0,1,1,223,111},{10,0,1,1,223,111},{11,0,1,1,223,111},{12,1,1,1,223,111},{9,0,1,1,223,115},{10,0,1,1,223,115},{11,0,1,1,223,115},{12,1,1,1,223,115},{9,0,1,1,223,116},{10,0,1,1,223,116},{11,0,1,1,223,116},{12,1,1,1,223,116},{13,0,1,1,223,32},{14,1,1,1,223,32},{13,0,1,1,223,37},{14,1,1,1,223,37},{13,0,1,1,223,45},{14,1,1,1,223,45},{13,0,1,1,223,46},{14,1,1,1,223,46},{13,0,1,1,223,47},{14,1,1,1,223,47},{13,0,1,1,223,51},{14,1,1,1,223,51},{13,0,1,1,223,52},{14,1,1,1,223,52},{13,0,1,1,223,53},{14,1,1,1,223,53},{13,0,1,1,223,54},{14,1,1,1,223,54},{13,0,1,1,223,55},{14,1,1,1,223,55},{13,0,1,1,223,56},{14,1,1,1,223,56},{13,0,1,1,223,57},{14,1,1,1,223,57},{13,0,1,1,223,61},{14,1,1,1,223,61},{13,0,1,1,223,65},{14,1,1,1,223,65},{13,0,1,1,223,95},{14,1,1,1,223,95},{13,0,1,1,223,98},{14,1,1,1,223,98},{13,0,1,1,223,100},{14,1,1,1,223,100},{13,0,1,1,223,102},{14,1,1,1,223,102},{13,0,1,1,223,103},{14,1,1,1,223,103},{13,0,1,1,223,104},{14,1,1,1,223,104},{13,0,1,1,223,108},{14,1,1,1,223,108},{13,0,1,1,223,109},{14,1,1,1,223,109},{13,0,1,1,223,110},{14,1,1,1,223,110},{13,0,1,1,223,112},{14,1,1,1,223,112},{13,0,1,1,223,114},{14,1,1,1,223,114},{13,0,1,1,223,117},{14,1,1,1,223,117},{0,1,1,1,223,58},{0,1,1,1,223,66},{0,1,1,1,223,67},{0,1,1,1,223,68},{0,1,1,1,223,69},{0,1,1,1,223,70},{0,1,1,1,223,71},{0,1,1,1,223,72},{0,1,1,1,223,73},{0,1,1,1,223,74},{0,1,1,1,223,75},{0,1,1,1,223,76},{0,1,1,1,223,77},{0,1,1,1,223,78},{0,1,1,1,223,79},{0,1,1,1,223,80},{0,1,1,1,223,81},{0,1,1,1,223,82},{0,1,1,1,223,83},{0,1,1,1,223,84},{0,1,1,1,223,85},{0,1,1,1,223,86},{0,1,1,1,223,87},{0,1,1,1,223,89},{0,1,1,1,223,106},{0,1,1,1,223,107},{0,1,1,1,223,113},{0,1,1,1,223,118},{0,1,1,1,223,119},{0,1,1,1,223,120},{0,1,1,1,223,121},{0,1,1,1,223,122},{85,0,0,1,0,223},{86,0,0,1,0,223},{87,0,0,1,0,223},{88,1,0,1,0,223},{9,0,1,1,241,48},{10,0,1,1,241,48},{11,0,1,1,241,48},{12,1,1,1,241,48},{9,0,1,1,241,49},{10,0,1,1,241,49},{11,0,1,1,241,49},{12,1,1,1,241,49},{9,0,1,1,241,50},{10,0,1,1,241,50},{11,0,1,1,241,50},{12,1,1,1,241,50},{9,0,1,1,241,97},{10,0,1,1,241,97},{11,0,1,1,241,97},{12,1,1,1,241,97},{9,0,1,1,241,99},{10,0,1,1,241,99},{11,0,1,1,241,99},{12,1,1,1,241,99},{9,0,1,1,241,101},{10,0,1,1,241,101},{11,0,1,1,241,101},{12,1,1,1,241,101},{9,0,1,1,241,105},{10,0,1,1,241,105},{11,0,1,1,241,105},{12,1,1,1,241,105},{9,0,1,1,241,111},{10,0,1,1,241,111},{11,0,1,1,241,111},{12,1,1,1,241,111},{9,0,1,1,241,115},{10,0,1,1,241,115},{11,0,1,1,241,115},{12,1,1,1,241,115},{9,0,1,1,241,116},{10,0,1,1,241,116},{11,0,1,1,241,116},{12,1,1,1,241,116},{13,0,1,1,241,32},{14,1,1,1,241,32},{13,0,1,1,241,37},{14,1,1,1,241,37},{13,0,1,1,241,45},{14,1,1,1,241,45},{13,0,1,1,241,46},{14,1,1,1,241,46},{13,0,1,1,241,47},{14,1,1,1,241,47},{13,0,1,1,241,51},{14,1,1,1,241,51},{13,0,1,1,241,52},{14,1,1,1,241,52},{13,0,1,1,241,53},{14,1,1,1,241,53},{13,0,1,1,241,54},{14,1,1,1,241,54},{13,0,1,1,241,55},{14,1,1,1,241,55},{13,0,1,1,241,56},{14,1,1,1,241,56},{13,0,1,1,241,57},{14,1,1,1,241,57},{13,0,1,1,241,61},{14,1,1,1,241,61},{13,0,1,1,241,65},{14,1,1,1,241,65},{13,0,1,1,241,95},{14,1,1,1,241,95},{13,0,1,1,241,98},{14,1,1,1,241,98},{13,0,1,1,241,100},{14,1,1,1,241,100},{13,0,1,1,241,102},{14,1,1,1,241,102},{13,0,1,1,241,103},{14,1,1,1,241,103},{13,0,1,1,241,104},{14,1,1,1,241,104},{13,0,1,1,241,108},{14,1,1,1,241,108},{13,0,1,1,241,109},{14,1,1,1,241,109},{13,0,1,1,241,110},{14,1,1,1,241,110},{13,0,1,1,241,112},{14,1,1,1,241,112},{13,0,1,1,241,114},{14,1,1,1,241,114},{13,0,1,1,241,117},{14,1,1,1,241,117},{0,1,1,1,241,58},{0,1,1,1,241,66},{0,1,1,1,241,67},{0,1,1,1,241,68},{0,1,1,1,241,69},{0,1,1,1,241,70},{0,1,1,1,241,71},{0,1,1,1,241,72},{0,1,1,1,241,73},{0,1,1,1,241,74},{0,1,1,1,241,75},{0,1,1,1,241,76},{0,1,1,1,241,77},{0,1,1,1,241,78},{0,1,1,1,241,79},{0,1,1,1,241,80},{0,1,1,1,241,81},{0,1,1,1,241,82},{0,1,1,1,241,83},{0,1,1,1,241,84},{0,1,1,1,241,85},{0,1,1,1,241,86},{0,1,1,1,241,87},{0,1,1,1,241,89},{0,1,1,1,241,106},{0,1,1,1,241,107},{0,1,1,1,241,113},{0,1,1,1,241,118},{0,1,1,1,241,119},{0,1,1,1,241,120},{0,1,1,1,241,121},{0,1,1,1,241,122},{85,0,0,1,0,241},{86,0,0,1,0,241},{87,0,0,1,0,241},{88,1,0,1,0,241},{9,0,1,1,244,48},{10,0,1,1,244,48},{11,0,1,1,244,48},{12,1,1,1,244,48},{9,0,1,1,244,49},{10,0,1,1,244,49},{11,0,1,1,244,49},{12,1,1,1,244,49},{9,0,1,1,244,50},{10,0,1,1,244,50},{11,0,1,1,244,50},{12,1,1,1,244,50},{9,0,1,1,244,97},{10,0,1,1,244,97},{11,0,1,1,244,97},{12,1,1,1,244,97},{9,0,1,1,244,99},{10,0,1,1,244,99},{11,0,1,1,244,99},{12,1,1,1,244,99},{9,0,1,1,244,101},{10,0,1,1,244,101},{11,0,1,1,244,101},{12,1,1,1,244,101},{9,0,1,1,244,105},{10,0,1,1,244,105},{11,0,1,1,244,105},{12,1,1,1,244,105},{9,0,1,1,244,111},{10,0,1,1,244,111},{11,0,1,1,244,111},{12,1,1,1,244,111},{9,0,1,1,244,115},{10,0,1,1,244,115},{11,0,1,1,244,115},{12,1,1,1,244,115},{9,0,1,1,244,116},{10,0,1,1,244,116},{11,0,1,1,244,116},{12,1,1,1,244,116},{13,0,1,1,244,32},{14,1,1,1,244,32},{13,0,1,1,244,37},{14,1,1,1,244,37},{13,0,1,1,244,45},{14,1,1,1,244,45},{13,0,1,1,244,46},{14,1,1,1,244,46},{13,0,1,1,244,47},{14,1,1,1,244,47},{13,0,1,1,244,51},{14,1,1,1,244,51},{13,0,1,1,244,52},{14,1,1,1,244,52},{13,0,1,1,244,53},{14,1,1,1,244,53},{13,0,1,1,244,54},{14,1,1,1,244,54},{13,0,1,1,244,55},{14,1,1,1,244,55},{13,0,1,1,244,56},{14,1,1,1,244,56},{13,0,1,1,244,57},{14,1,1,1,244,57},{13,0,1,1,244,61},{14,1,1,1,244,61},{13,0,1,1,244,65},{14,1,1,1,244,65},{13,0,1,1,244,95},{14,1,1,1,244,95},{13,0,1,1,244,98},{14,1,1,1,244,98},{13,0,1,1,244,100},{14,1,1,1,244,100},{13,0,1,1,244,102},{14,1,1,1,244,102},{13,0,1,1,244,103},{14,1,1,1,244,103},{13,0,1,1,244,104},{14,1,1,1,244,104},{13,0,1,1,244,108},{14,1,1,1,244,108},{13,0,1,1,244,109},{14,1,1,1,244,109},{13,0,1,1,244,110},{14,1,1,1,244,110},{13,0,1,1,244,112},{14,1,1,1,244,112},{13,0,1,1,244,114},{14,1,1,1,244,114},{13,0,1,1,244,117},{14,1,1,1,244,117},{0,1,1,1,244,58},{0,1,1,1,244,66},{0,1,1,1,244,67},{0,1,1,1,244,68},{0,1,1,1,244,69},{0,1,1,1,244,70},{0,1,1,1,244,71},{0,1,1,1,244,72},{0,1,1,1,244,73},{0,1,1,1,244,74},{0,1,1,1,244,75},{0,1,1,1,244,76},{0,1,1,1,244,77},{0,1,1,1,244,78},{0,1,1,1,244,79},{0,1,1,1,244,80},{0,1,1,1,244,81},{0,1,1,1,244,82},{0,1,1,1,244,83},{0,1,1,1,244,84},{0,1,1,1,244,85},{0,1,1,1,244,86},{0,1,1,1,244,87},{0,1,1,1,244,89},{0,1,1,1,244,106},{0,1,1,1,244,107},{0,1,1,1,244,113},{0,1,1,1,244,118},{0,1,1,1,244,119},{0,1,1,1,244,120},{0,1,1,1,244,121},{0,1,1,1,244,122},{85,0,0,1,0,244},{86,0,0,1,0,244},{87,0,0,1,0,244},{88,1,0,1,0,244},{9,0,1,1,245,48},{10,0,1,1,245,48},{11,0,1,1,245,48},{12,1,1,1,245,48},{9,0,1,1,245,49},{10,0,1,1,245,49},{11,0,1,1,245,49},{12,1,1,1,245,49},{9,0,1,1,245,50},{10,0,1,1,245,50},{11,0,1,1,245,50},{12,1,1,1,245,50},{9,0,1,1,245,97},{10,0,1,1,245,97},{11,0,1,1,245,97},{12,1,1,1,245,97},{9,0,1,1,245,99},{10,0,1,1,245,99},{11,0,1,1,245,99},{12,1,1,1,245,99},{9,0,1,1,245,101},{10,0,1,1,245,101},{11,0,1,1,245,101},{12,1,1,1,245,101},{9,0,1,1,245,105},{10,0,1,1,245,105},{11,0,1,1,245,105},{12,1,1,1,245,105},{9,0,1,1,245,111},{10,0,1,1,245,111},{11,0,1,1,245,111},{12,1,1,1,245,111},{9,0,1,1,245,115},{10,0,1,1,245,115},{11,0,1,1,245,115},{12,1,1,1,245,115},{9,0,1,1,245,116},{10,0,1,1,245,116},{11,0,1,1,245,116},{12,1,1,1,245,116},{13,0,1,1,245,32},{14,1,1,1,245,32},{13,0,1,1,245,37},{14,1,1,1,245,37},{13,0,1,1,245,45},{14,1,1,1,245,45},{13,0,1,1,245,46},{14,1,1,1,245,46},{13,0,1,1,245,47},{14,1,1,1,245,47},{13,0,1,1,245,51},{14,1,1,1,245,51},{13,0,1,1,245,52},{14,1,1,1,245,52},{13,0,1,1,245,53},{14,1,1,1,245,53},{13,0,1,1,245,54},{14,1,1,1,245,54},{13,0,1,1,245,55},{14,1,1,1,245,55},{13,0,1,1,245,56},{14,1,1,1,245,56},{13,0,1,1,245,57},{14,1,1,1,245,57},{13,0,1,1,245,61},{14,1,1,1,245,61},{13,0,1,1,245,65},{14,1,1,1,245,65},{13,0,1,1,245,95},{14,1,1,1,245,95},{13,0,1,1,245,98},{14,1,1,1,245,98},{13,0,1,1,245,100},{14,1,1,1,245,100},{13,0,1,1,245,102},{14,1,1,1,245,102},{13,0,1,1,245,103},{14,1,1,1,245,103},{13,0,1,1,245,104},{14,1,1,1,245,104},{13,0,1,1,245,108},{14,1,1,1,245,108},{13,0,1,1,245,109},{14,1,1,1,245,109},{13,0,1,1,245,110},{14,1,1,1,245,110},{13,0,1,1,245,112},{14,1,1,1,245,112},{13,0,1,1,245,114},{14,1,1,1,245,114},{13,0,1,1,245,117},{14,1,1,1,245,117},{0,1,1,1,245,58},{0,1,1,1,245,66},{0,1,1,1,245,67},{0,1,1,1,245,68},{0,1,1,1,245,69},{0,1,1,1,245,70},{0,1,1,1,245,71},{0,1,1,1,245,72},{0,1,1,1,245,73},{0,1,1,1,245,74},{0,1,1,1,245,75},{0,1,1,1,245,76},{0,1,1,1,245,77},{0,1,1,1,245,78},{0,1,1,1,245,79},{0,1,1,1,245,80},{0,1,1,1,245,81},{0,1,1,1,245,82},{0,1,1,1,245,83},{0,1,1,1,245,84},{0,1,1,1,245,85},{0,1,1,1,245,86},{0,1,1,1,245,87},{0,1,1,1,245,89},{0,1,1,1,245,106},{0,1,1,1,245,107},{0,1,1,1,245,113},{0,1,1,1,245,118},{0,1,1,1,245,119},{0,1,1,1,245,120},{0,1,1,1,245,121},{0,1,1,1,245,122},{85,0,0,1,0,245},{86,0,0,1,0,245},{87,0,0,1,0,245},{88,1,0,1,0,245},{9,0,1,1,246,48},{10,0,1,1,246,48},{11,0,1,1,246,48},{12,1,1,1,246,48},{9,0,1,1,246,49},{10,0,1,1,246,49},{11,0,1,1,246,49},{12,1,1,1,246,49},{9,0,1,1,246,50},{10,0,1,1,246,50},{11,0,1,1,246,50},{12,1,1,1,246,50},{9,0,1,1,246,97},{10,0,1,1,246,97},{11,0,1,1,246,97},{12,1,1,1,246,97},{9,0,1,1,246,99},{10,0,1,1,246,99},{11,0,1,1,246,99},{12,1,1,1,246,99},{9,0,1,1,246,101},{10,0,1,1,246,101},{11,0,1,1,246,101},{12,1,1,1,246,101},{9,0,1,1,246,105},{10,0,1,1,246,105},{11,0,1,1,246,105},{12,1,1,1,246,105},{9,0,1,1,246,111},{10,0,1,1,246,111},{11,0,1,1,246,111},{12,1,1,1,246,111},{9,0,1,1,246,115},{10,0,1,1,246,115},{11,0,1,1,246,115},{12,1,1,1,246,115},{9,0,1,1,246,116},{10,0,1,1,246,116},{11,0,1,1,246,116},{12,1,1,1,246,116},{13,0,1,1,246,32},{14,1,1,1,246,32},{13,0,1,1,246,37},{14,1,1,1,246,37},{13,0,1,1,246,45},{14,1,1,1,246,45},{13,0,1,1,246,46},{14,1,1,1,246,46},{13,0,1,1,246,47},{14,1,1,1,246,47},{13,0,1,1,246,51},{14,1,1,1,246,51},{13,0,1,1,246,52},{14,1,1,1,246,52},{13,0,1,1,246,53},{14,1,1,1,246,53},{13,0,1,1,246,54},{14,1,1,1,246,54},{13,0,1,1,246,55},{14,1,1,1,246,55},{13,0,1,1,246,56},{14,1,1,1,246,56},{13,0,1,1,246,57},{14,1,1,1,246,57},{13,0,1,1,246,61},{14,1,1,1,246,61},{13,0,1,1,246,65},{14,1,1,1,246,65},{13,0,1,1,246,95},{14,1,1,1,246,95},{13,0,1,1,246,98},{14,1,1,1,246,98},{13,0,1,1,246,100},{14,1,1,1,246,100},{13,0,1,1,246,102},{14,1,1,1,246,102},{13,0,1,1,246,103},{14,1,1,1,246,103},{13,0,1,1,246,104},{14,1,1,1,246,104},{13,0,1,1,246,108},{14,1,1,1,246,108},{13,0,1,1,246,109},{14,1,1,1,246,109},{13,0,1,1,246,110},{14,1,1,1,246,110},{13,0,1,1,246,112},{14,1,1,1,246,112},{13,0,1,1,246,114},{14,1,1,1,246,114},{13,0,1,1,246,117},{14,1,1,1,246,117},{0,1,1,1,246,58},{0,1,1,1,246,66},{0,1,1,1,246,67},{0,1,1,1,246,68},{0,1,1,1,246,69},{0,1,1,1,246,70},{0,1,1,1,246,71},{0,1,1,1,246,72},{0,1,1,1,246,73},{0,1,1,1,246,74},{0,1,1,1,246,75},{0,1,1,1,246,76},{0,1,1,1,246,77},{0,1,1,1,246,78},{0,1,1,1,246,79},{0,1,1,1,246,80},{0,1,1,1,246,81},{0,1,1,1,246,82},{0,1,1,1,246,83},{0,1,1,1,246,84},{0,1,1,1,246,85},{0,1,1,1,246,86},{0,1,1,1,246,87},{0,1,1,1,246,89},{0,1,1,1,246,106},{0,1,1,1,246,107},{0,1,1,1,246,113},{0,1,1,1,246,118},{0,1,1,1,246,119},{0,1,1,1,246,120},{0,1,1,1,246,121},{0,1,1,1,246,122},{85,0,0,1,0,246},{86,0,0,1,0,246},{87,0,0,1,0,246},{88,1,0,1,0,246},{9,0,1,1,247,48},{10,0,1,1,247,48},{11,0,1,1,247,48},{12,1,1,1,247,48},{9,0,1,1,247,49},{10,0,1,1,247,49},{11,0,1,1,247,49},{12,1,1,1,247,49},{9,0,1,1,247,50},{10,0,1,1,247,50},{11,0,1,1,247,50},{12,1,1,1,247,50},{9,0,1,1,247,97},{10,0,1,1,247,97},{11,0,1,1,247,97},{12,1,1,1,247,97},{9,0,1,1,247,99},{10,0,1,1,247,99},{11,0,1,1,247,99},{12,1,1,1,247,99},{9,0,1,1,247,101},{10,0,1,1,247,101},{11,0,1,1,247,101},{12,1,1,1,247,101},{9,0,1,1,247,105},{10,0,1,1,247,105},{11,0,1,1,247,105},{12,1,1,1,247,105},{9,0,1,1,247,111},{10,0,1,1,247,111},{11,0,1,1,247,111},{12,1,1,1,247,111},{9,0,1,1,247,115},{10,0,1,1,247,115},{11,0,1,1,247,115},{12,1,1,1,247,115},{9,0,1,1,247,116},{10,0,1,1,247,116},{11,0,1,1,247,116},{12,1,1,1,247,116},{13,0,1,1,247,32},{14,1,1,1,247,32},{13,0,1,1,247,37},{14,1,1,1,247,37},{13,0,1,1,247,45},{14,1,1,1,247,45},{13,0,1,1,247,46},{14,1,1,1,247,46},{13,0,1,1,247,47},{14,1,1,1,247,47},{13,0,1,1,247,51},{14,1,1,1,247,51},{13,0,1,1,247,52},{14,1,1,1,247,52},{13,0,1,1,247,53},{14,1,1,1,247,53},{13,0,1,1,247,54},{14,1,1,1,247,54},{13,0,1,1,247,55},{14,1,1,1,247,55},{13,0,1,1,247,56},{14,1,1,1,247,56},{13,0,1,1,247,57},{14,1,1,1,247,57},{13,0,1,1,247,61},{14,1,1,1,247,61},{13,0,1,1,247,65},{14,1,1,1,247,65},{13,0,1,1,247,95},{14,1,1,1,247,95},{13,0,1,1,247,98},{14,1,1,1,247,98},{13,0,1,1,247,100},{14,1,1,1,247,100},{13,0,1,1,247,102},{14,1,1,1,247,102},{13,0,1,1,247,103},{14,1,1,1,247,103},{13,0,1,1,247,104},{14,1,1,1,247,104},{13,0,1,1,247,108},{14,1,1,1,247,108},{13,0,1,1,247,109},{14,1,1,1,247,109},{13,0,1,1,247,110},{14,1,1,1,247,110},{13,0,1,1,247,112},{14,1,1,1,247,112},{13,0,1,1,247,114},{14,1,1,1,247,114},{13,0,1,1,247,117},{14,1,1,1,247,117},{0,1,1,1,247,58},{0,1,1,1,247,66},{0,1,1,1,247,67},{0,1,1,1,247,68},{0,1,1,1,247,69},{0,1,1,1,247,70},{0,1,1,1,247,71},{0,1,1,1,247,72},{0,1,1,1,247,73},{0,1,1,1,247,74},{0,1,1,1,247,75},{0,1,1,1,247,76},{0,1,1,1,247,77},{0,1,1,1,247,78},{0,1,1,1,247,79},{0,1,1,1,247,80},{0,1,1,1,247,81},{0,1,1,1,247,82},{0,1,1,1,247,83},{0,1,1,1,247,84},{0,1,1,1,247,85},{0,1,1,1,247,86},{0,1,1,1,247,87},{0,1,1,1,247,89},{0,1,1,1,247,106},{0,1,1,1,247,107},{0,1,1,1,247,113},{0,1,1,1,247,118},{0,1,1,1,247,119},{0,1,1,1,247,120},{0,1,1,1,247,121},{0,1,1,1,247,122},{85,0,0,1,0,247},{86,0,0,1,0,247},{87,0,0,1,0,247},{88,1,0,1,0,247},{9,0,1,1,248,48},{10,0,1,1,248,48},{11,0,1,1,248,48},{12,1,1,1,248,48},{9,0,1,1,248,49},{10,0,1,1,248,49},{11,0,1,1,248,49},{12,1,1,1,248,49},{9,0,1,1,248,50},{10,0,1,1,248,50},{11,0,1,1,248,50},{12,1,1,1,248,50},{9,0,1,1,248,97},{10,0,1,1,248,97},{11,0,1,1,248,97},{12,1,1,1,248,97},{9,0,1,1,248,99},{10,0,1,1,248,99},{11,0,1,1,248,99},{12,1,1,1,248,99},{9,0,1,1,248,101},{10,0,1,1,248,101},{11,0,1,1,248,101},{12,1,1,1,248,101},{9,0,1,1,248,105},{10,0,1,1,248,105},{11,0,1,1,248,105},{12,1,1,1,248,105},{9,0,1,1,248,111},{10,0,1,1,248,111},{11,0,1,1,248,111},{12,1,1,1,248,111},{9,0,1,1,248,115},{10,0,1,1,248,115},{11,0,1,1,248,115},{12,1,1,1,248,115},{9,0,1,1,248,116},{10,0,1,1,248,116},{11,0,1,1,248,116},{12,1,1,1,248,116},{13,0,1,1,248,32},{14,1,1,1,248,32},{13,0,1,1,248,37},{14,1,1,1,248,37},{13,0,1,1,248,45},{14,1,1,1,248,45},{13,0,1,1,248,46},{14,1,1,1,248,46},{13,0,1,1,248,47},{14,1,1,1,248,47},{13,0,1,1,248,51},{14,1,1,1,248,51},{13,0,1,1,248,52},{14,1,1,1,248,52},{13,0,1,1,248,53},{14,1,1,1,248,53},{13,0,1,1,248,54},{14,1,1,1,248,54},{13,0,1,1,248,55},{14,1,1,1,248,55},{13,0,1,1,248,56},{14,1,1,1,248,56},{13,0,1,1,248,57},{14,1,1,1,248,57},{13,0,1,1,248,61},{14,1,1,1,248,61},{13,0,1,1,248,65},{14,1,1,1,248,65},{13,0,1,1,248,95},{14,1,1,1,248,95},{13,0,1,1,248,98},{14,1,1,1,248,98},{13,0,1,1,248,100},{14,1,1,1,248,100},{13,0,1,1,248,102},{14,1,1,1,248,102},{13,0,1,1,248,103},{14,1,1,1,248,103},{13,0,1,1,248,104},{14,1,1,1,248,104},{13,0,1,1,248,108},{14,1,1,1,248,108},{13,0,1,1,248,109},{14,1,1,1,248,109},{13,0,1,1,248,110},{14,1,1,1,248,110},{13,0,1,1,248,112},{14,1,1,1,248,112},{13,0,1,1,248,114},{14,1,1,1,248,114},{13,0,1,1,248,117},{14,1,1,1,248,117},{0,1,1,1,248,58},{0,1,1,1,248,66},{0,1,1,1,248,67},{0,1,1,1,248,68},{0,1,1,1,248,69},{0,1,1,1,248,70},{0,1,1,1,248,71},{0,1,1,1,248,72},{0,1,1,1,248,73},{0,1,1,1,248,74},{0,1,1,1,248,75},{0,1,1,1,248,76},{0,1,1,1,248,77},{0,1,1,1,248,78},{0,1,1,1,248,79},{0,1,1,1,248,80},{0,1,1,1,248,81},{0,1,1,1,248,82},{0,1,1,1,248,83},{0,1,1,1,248,84},{0,1,1,1,248,85},{0,1,1,1,248,86},{0,1,1,1,248,87},{0,1,1,1,248,89},{0,1,1,1,248,106},{0,1,1,1,248,107},{0,1,1,1,248,113},{0,1,1,1,248,118},{0,1,1,1,248,119},{0,1,1,1,248,120},{0,1,1,1,248,121},{0,1,1,1,248,122},{85,0,0,1,0,248},{86,0,0,1,0,248},{87,0,0,1,0,248},{88,1,0,1,0,248},{9,0,1,1,250,48},{10,0,1,1,250,48},{11,0,1,1,250,48},{12,1,1,1,250,48},{9,0,1,1,250,49},{10,0,1,1,250,49},{11,0,1,1,250,49},{12,1,1,1,250,49},{9,0,1,1,250,50},{10,0,1,1,250,50},{11,0,1,1,250,50},{12,1,1,1,250,50},{9,0,1,1,250,97},{10,0,1,1,250,97},{11,0,1,1,250,97},{12,1,1,1,250,97},{9,0,1,1,250,99},{10,0,1,1,250,99},{11,0,1,1,250,99},{12,1,1,1,250,99},{9,0,1,1,250,101},{10,0,1,1,250,101},{11,0,1,1,250,101},{12,1,1,1,250,101},{9,0,1,1,250,105},{10,0,1,1,250,105},{11,0,1,1,250,105},{12,1,1,1,250,105},{9,0,1,1,250,111},{10,0,1,1,250,111},{11,0,1,1,250,111},{12,1,1,1,250,111},{9,0,1,1,250,115},{10,0,1,1,250,115},{11,0,1,1,250,115},{12,1,1,1,250,115},{9,0,1,1,250,116},{10,0,1,1,250,116},{11,0,1,1,250,116},{12,1,1,1,250,116},{13,0,1,1,250,32},{14,1,1,1,250,32},{13,0,1,1,250,37},{14,1,1,1,250,37},{13,0,1,1,250,45},{14,1,1,1,250,45},{13,0,1,1,250,46},{14,1,1,1,250,46},{13,0,1,1,250,47},{14,1,1,1,250,47},{13,0,1,1,250,51},{14,1,1,1,250,51},{13,0,1,1,250,52},{14,1,1,1,250,52},{13,0,1,1,250,53},{14,1,1,1,250,53},{13,0,1,1,250,54},{14,1,1,1,250,54},{13,0,1,1,250,55},{14,1,1,1,250,55},{13,0,1,1,250,56},{14,1,1,1,250,56},{13,0,1,1,250,57},{14,1,1,1,250,57},{13,0,1,1,250,61},{14,1,1,1,250,61},{13,0,1,1,250,65},{14,1,1,1,250,65},{13,0,1,1,250,95},{14,1,1,1,250,95},{13,0,1,1,250,98},{14,1,1,1,250,98},{13,0,1,1,250,100},{14,1,1,1,250,100},{13,0,1,1,250,102},{14,1,1,1,250,102},{13,0,1,1,250,103},{14,1,1,1,250,103},{13,0,1,1,250,104},{14,1,1,1,250,104},{13,0,1,1,250,108},{14,1,1,1,250,108},{13,0,1,1,250,109},{14,1,1,1,250,109},{13,0,1,1,250,110},{14,1,1,1,250,110},{13,0,1,1,250,112},{14,1,1,1,250,112},{13,0,1,1,250,114},{14,1,1,1,250,114},{13,0,1,1,250,117},{14,1,1,1,250,117},{0,1,1,1,250,58},{0,1,1,1,250,66},{0,1,1,1,250,67},{0,1,1,1,250,68},{0,1,1,1,250,69},{0,1,1,1,250,70},{0,1,1,1,250,71},{0,1,1,1,250,72},{0,1,1,1,250,73},{0,1,1,1,250,74},{0,1,1,1,250,75},{0,1,1,1,250,76},{0,1,1,1,250,77},{0,1,1,1,250,78},{0,1,1,1,250,79},{0,1,1,1,250,80},{0,1,1,1,250,81},{0,1,1,1,250,82},{0,1,1,1,250,83},{0,1,1,1,250,84},{0,1,1,1,250,85},{0,1,1,1,250,86},{0,1,1,1,250,87},{0,1,1,1,250,89},{0,1,1,1,250,106},{0,1,1,1,250,107},{0,1,1,1,250,113},{0,1,1,1,250,118},{0,1,1,1,250,119},{0,1,1,1,250,120},{0,1,1,1,250,121},{0,1,1,1,250,122},{85,0,0,1,0,250},{86,0,0,1,0,250},{87,0,0,1,0,250},{88,1,0,1,0,250},{9,0,1,1,251,48},{10,0,1,1,251,48},{11,0,1,1,251,48},{12,1,1,1,251,48},{9,0,1,1,251,49},{10,0,1,1,251,49},{11,0,1,1,251,49},{12,1,1,1,251,49},{9,0,1,1,251,50},{10,0,1,1,251,50},{11,0,1,1,251,50},{12,1,1,1,251,50},{9,0,1,1,251,97},{10,0,1,1,251,97},{11,0,1,1,251,97},{12,1,1,1,251,97},{9,0,1,1,251,99},{10,0,1,1,251,99},{11,0,1,1,251,99},{12,1,1,1,251,99},{9,0,1,1,251,101},{10,0,1,1,251,101},{11,0,1,1,251,101},{12,1,1,1,251,101},{9,0,1,1,251,105},{10,0,1,1,251,105},{11,0,1,1,251,105},{12,1,1,1,251,105},{9,0,1,1,251,111},{10,0,1,1,251,111},{11,0,1,1,251,111},{12,1,1,1,251,111},{9,0,1,1,251,115},{10,0,1,1,251,115},{11,0,1,1,251,115},{12,1,1,1,251,115},{9,0,1,1,251,116},{10,0,1,1,251,116},{11,0,1,1,251,116},{12,1,1,1,251,116},{13,0,1,1,251,32},{14,1,1,1,251,32},{13,0,1,1,251,37},{14,1,1,1,251,37},{13,0,1,1,251,45},{14,1,1,1,251,45},{13,0,1,1,251,46},{14,1,1,1,251,46},{13,0,1,1,251,47},{14,1,1,1,251,47},{13,0,1,1,251,51},{14,1,1,1,251,51},{13,0,1,1,251,52},{14,1,1,1,251,52},{13,0,1,1,251,53},{14,1,1,1,251,53},{13,0,1,1,251,54},{14,1,1,1,251,54},{13,0,1,1,251,55},{14,1,1,1,251,55},{13,0,1,1,251,56},{14,1,1,1,251,56},{13,0,1,1,251,57},{14,1,1,1,251,57},{13,0,1,1,251,61},{14,1,1,1,251,61},{13,0,1,1,251,65},{14,1,1,1,251,65},{13,0,1,1,251,95},{14,1,1,1,251,95},{13,0,1,1,251,98},{14,1,1,1,251,98},{13,0,1,1,251,100},{14,1,1,1,251,100},{13,0,1,1,251,102},{14,1,1,1,251,102},{13,0,1,1,251,103},{14,1,1,1,251,103},{13,0,1,1,251,104},{14,1,1,1,251,104},{13,0,1,1,251,108},{14,1,1,1,251,108},{13,0,1,1,251,109},{14,1,1,1,251,109},{13,0,1,1,251,110},{14,1,1,1,251,110},{13,0,1,1,251,112},{14,1,1,1,251,112},{13,0,1,1,251,114},{14,1,1,1,251,114},{13,0,1,1,251,117},{14,1,1,1,251,117},{0,1,1,1,251,58},{0,1,1,1,251,66},{0,1,1,1,251,67},{0,1,1,1,251,68},{0,1,1,1,251,69},{0,1,1,1,251,70},{0,1,1,1,251,71},{0,1,1,1,251,72},{0,1,1,1,251,73},{0,1,1,1,251,74},{0,1,1,1,251,75},{0,1,1,1,251,76},{0,1,1,1,251,77},{0,1,1,1,251,78},{0,1,1,1,251,79},{0,1,1,1,251,80},{0,1,1,1,251,81},{0,1,1,1,251,82},{0,1,1,1,251,83},{0,1,1,1,251,84},{0,1,1,1,251,85},{0,1,1,1,251,86},{0,1,1,1,251,87},{0,1,1,1,251,89},{0,1,1,1,251,106},{0,1,1,1,251,107},{0,1,1,1,251,113},{0,1,1,1,251,118},{0,1,1,1,251,119},{0,1,1,1,251,120},{0,1,1,1,251,121},{0,1,1,1,251,122},{85,0,0,1,0,251},{86,0,0,1,0,251},{87,0,0,1,0,251},{88,1,0,1,0,251},{9,0,1,1,252,48},{10,0,1,1,252,48},{11,0,1,1,252,48},{12,1,1,1,252,48},{9,0,1,1,252,49},{10,0,1,1,252,49},{11,0,1,1,252,49},{12,1,1,1,252,49},{9,0,1,1,252,50},{10,0,1,1,252,50},{11,0,1,1,252,50},{12,1,1,1,252,50},{9,0,1,1,252,97},{10,0,1,1,252,97},{11,0,1,1,252,97},{12,1,1,1,252,97},{9,0,1,1,252,99},{10,0,1,1,252,99},{11,0,1,1,252,99},{12,1,1,1,252,99},{9,0,1,1,252,101},{10,0,1,1,252,101},{11,0,1,1,252,101},{12,1,1,1,252,101},{9,0,1,1,252,105},{10,0,1,1,252,105},{11,0,1,1,252,105},{12,1,1,1,252,105},{9,0,1,1,252,111},{10,0,1,1,252,111},{11,0,1,1,252,111},{12,1,1,1,252,111},{9,0,1,1,252,115},{10,0,1,1,252,115},{11,0,1,1,252,115},{12,1,1,1,252,115},{9,0,1,1,252,116},{10,0,1,1,252,116},{11,0,1,1,252,116},{12,1,1,1,252,116},{13,0,1,1,252,32},{14,1,1,1,252,32},{13,0,1,1,252,37},{14,1,1,1,252,37},{13,0,1,1,252,45},{14,1,1,1,252,45},{13,0,1,1,252,46},{14,1,1,1,252,46},{13,0,1,1,252,47},{14,1,1,1,252,47},{13,0,1,1,252,51},{14,1,1,1,252,51},{13,0,1,1,252,52},{14,1,1,1,252,52},{13,0,1,1,252,53},{14,1,1,1,252,53},{13,0,1,1,252,54},{14,1,1,1,252,54},{13,0,1,1,252,55},{14,1,1,1,252,55},{13,0,1,1,252,56},{14,1,1,1,252,56},{13,0,1,1,252,57},{14,1,1,1,252,57},{13,0,1,1,252,61},{14,1,1,1,252,61},{13,0,1,1,252,65},{14,1,1,1,252,65},{13,0,1,1,252,95},{14,1,1,1,252,95},{13,0,1,1,252,98},{14,1,1,1,252,98},{13,0,1,1,252,100},{14,1,1,1,252,100},{13,0,1,1,252,102},{14,1,1,1,252,102},{13,0,1,1,252,103},{14,1,1,1,252,103},{13,0,1,1,252,104},{14,1,1,1,252,104},{13,0,1,1,252,108},{14,1,1,1,252,108},{13,0,1,1,252,109},{14,1,1,1,252,109},{13,0,1,1,252,110},{14,1,1,1,252,110},{13,0,1,1,252,112},{14,1,1,1,252,112},{13,0,1,1,252,114},{14,1,1,1,252,114},{13,0,1,1,252,117},{14,1,1,1,252,117},{0,1,1,1,252,58},{0,1,1,1,252,66},{0,1,1,1,252,67},{0,1,1,1,252,68},{0,1,1,1,252,69},{0,1,1,1,252,70},{0,1,1,1,252,71},{0,1,1,1,252,72},{0,1,1,1,252,73},{0,1,1,1,252,74},{0,1,1,1,252,75},{0,1,1,1,252,76},{0,1,1,1,252,77},{0,1,1,1,252,78},{0,1,1,1,252,79},{0,1,1,1,252,80},{0,1,1,1,252,81},{0,1,1,1,252,82},{0,1,1,1,252,83},{0,1,1,1,252,84},{0,1,1,1,252,85},{0,1,1,1,252,86},{0,1,1,1,252,87},{0,1,1,1,252,89},{0,1,1,1,252,106},{0,1,1,1,252,107},{0,1,1,1,252,113},{0,1,1,1,252,118},{0,1,1,1,252,119},{0,1,1,1,252,120},{0,1,1,1,252,121},{0,1,1,1,252,122},{85,0,0,1,0,252},{86,0,0,1,0,252},{87,0,0,1,0,252},{88,1,0,1,0,252},{9,0,1,1,253,48},{10,0,1,1,253,48},{11,0,1,1,253,48},{12,1,1,1,253,48},{9,0,1,1,253,49},{10,0,1,1,253,49},{11,0,1,1,253,49},{12,1,1,1,253,49},{9,0,1,1,253,50},{10,0,1,1,253,50},{11,0,1,1,253,50},{12,1,1,1,253,50},{9,0,1,1,253,97},{10,0,1,1,253,97},{11,0,1,1,253,97},{12,1,1,1,253,97},{9,0,1,1,253,99},{10,0,1,1,253,99},{11,0,1,1,253,99},{12,1,1,1,253,99},{9,0,1,1,253,101},{10,0,1,1,253,101},{11,0,1,1,253,101},{12,1,1,1,253,101},{9,0,1,1,253,105},{10,0,1,1,253,105},{11,0,1,1,253,105},{12,1,1,1,253,105},{9,0,1,1,253,111},{10,0,1,1,253,111},{11,0,1,1,253,111},{12,1,1,1,253,111},{9,0,1,1,253,115},{10,0,1,1,253,115},{11,0,1,1,253,115},{12,1,1,1,253,115},{9,0,1,1,253,116},{10,0,1,1,253,116},{11,0,1,1,253,116},{12,1,1,1,253,116},{13,0,1,1,253,32},{14,1,1,1,253,32},{13,0,1,1,253,37},{14,1,1,1,253,37},{13,0,1,1,253,45},{14,1,1,1,253,45},{13,0,1,1,253,46},{14,1,1,1,253,46},{13,0,1,1,253,47},{14,1,1,1,253,47},{13,0,1,1,253,51},{14,1,1,1,253,51},{13,0,1,1,253,52},{14,1,1,1,253,52},{13,0,1,1,253,53},{14,1,1,1,253,53},{13,0,1,1,253,54},{14,1,1,1,253,54},{13,0,1,1,253,55},{14,1,1,1,253,55},{13,0,1,1,253,56},{14,1,1,1,253,56},{13,0,1,1,253,57},{14,1,1,1,253,57},{13,0,1,1,253,61},{14,1,1,1,253,61},{13,0,1,1,253,65},{14,1,1,1,253,65},{13,0,1,1,253,95},{14,1,1,1,253,95},{13,0,1,1,253,98},{14,1,1,1,253,98},{13,0,1,1,253,100},{14,1,1,1,253,100},{13,0,1,1,253,102},{14,1,1,1,253,102},{13,0,1,1,253,103},{14,1,1,1,253,103},{13,0,1,1,253,104},{14,1,1,1,253,104},{13,0,1,1,253,108},{14,1,1,1,253,108},{13,0,1,1,253,109},{14,1,1,1,253,109},{13,0,1,1,253,110},{14,1,1,1,253,110},{13,0,1,1,253,112},{14,1,1,1,253,112},{13,0,1,1,253,114},{14,1,1,1,253,114},{13,0,1,1,253,117},{14,1,1,1,253,117},{0,1,1,1,253,58},{0,1,1,1,253,66},{0,1,1,1,253,67},{0,1,1,1,253,68},{0,1,1,1,253,69},{0,1,1,1,253,70},{0,1,1,1,253,71},{0,1,1,1,253,72},{0,1,1,1,253,73},{0,1,1,1,253,74},{0,1,1,1,253,75},{0,1,1,1,253,76},{0,1,1,1,253,77},{0,1,1,1,253,78},{0,1,1,1,253,79},{0,1,1,1,253,80},{0,1,1,1,253,81},{0,1,1,1,253,82},{0,1,1,1,253,83},{0,1,1,1,253,84},{0,1,1,1,253,85},{0,1,1,1,253,86},{0,1,1,1,253,87},{0,1,1,1,253,89},{0,1,1,1,253,106},{0,1,1,1,253,107},{0,1,1,1,253,113},{0,1,1,1,253,118},{0,1,1,1,253,119},{0,1,1,1,253,120},{0,1,1,1,253,121},{0,1,1,1,253,122},{85,0,0,1,0,253},{86,0,0,1,0,253},{87,0,0,1,0,253},{88,1,0,1,0,253},{9,0,1,1,254,48},{10,0,1,1,254,48},{11,0,1,1,254,48},{12,1,1,1,254,48},{9,0,1,1,254,49},{10,0,1,1,254,49},{11,0,1,1,254,49},{12,1,1,1,254,49},{9,0,1,1,254,50},{10,0,1,1,254,50},{11,0,1,1,254,50},{12,1,1,1,254,50},{9,0,1,1,254,97},{10,0,1,1,254,97},{11,0,1,1,254,97},{12,1,1,1,254,97},{9,0,1,1,254,99},{10,0,1,1,254,99},{11,0,1,1,254,99},{12,1,1,1,254,99},{9,0,1,1,254,101},{10,0,1,1,254,101},{11,0,1,1,254,101},{12,1,1,1,254,101},{9,0,1,1,254,105},{10,0,1,1,254,105},{11,0,1,1,254,105},{12,1,1,1,254,105},{9,0,1,1,254,111},{10,0,1,1,254,111},{11,0,1,1,254,111},{12,1,1,1,254,111},{9,0,1,1,254,115},{10,0,1,1,254,115},{11,0,1,1,254,115},{12,1,1,1,254,115},{9,0,1,1,254,116},{10,0,1,1,254,116},{11,0,1,1,254,116},{12,1,1,1,254,116},{13,0,1,1,254,32},{14,1,1,1,254,32},{13,0,1,1,254,37},{14,1,1,1,254,37},{13,0,1,1,254,45},{14,1,1,1,254,45},{13,0,1,1,254,46},{14,1,1,1,254,46},{13,0,1,1,254,47},{14,1,1,1,254,47},{13,0,1,1,254,51},{14,1,1,1,254,51},{13,0,1,1,254,52},{14,1,1,1,254,52},{13,0,1,1,254,53},{14,1,1,1,254,53},{13,0,1,1,254,54},{14,1,1,1,254,54},{13,0,1,1,254,55},{14,1,1,1,254,55},{13,0,1,1,254,56},{14,1,1,1,254,56},{13,0,1,1,254,57},{14,1,1,1,254,57},{13,0,1,1,254,61},{14,1,1,1,254,61},{13,0,1,1,254,65},{14,1,1,1,254,65},{13,0,1,1,254,95},{14,1,1,1,254,95},{13,0,1,1,254,98},{14,1,1,1,254,98},{13,0,1,1,254,100},{14,1,1,1,254,100},{13,0,1,1,254,102},{14,1,1,1,254,102},{13,0,1,1,254,103},{14,1,1,1,254,103},{13,0,1,1,254,104},{14,1,1,1,254,104},{13,0,1,1,254,108},{14,1,1,1,254,108},{13,0,1,1,254,109},{14,1,1,1,254,109},{13,0,1,1,254,110},{14,1,1,1,254,110},{13,0,1,1,254,112},{14,1,1,1,254,112},{13,0,1,1,254,114},{14,1,1,1,254,114},{13,0,1,1,254,117},{14,1,1,1,254,117},{0,1,1,1,254,58},{0,1,1,1,254,66},{0,1,1,1,254,67},{0,1,1,1,254,68},{0,1,1,1,254,69},{0,1,1,1,254,70},{0,1,1,1,254,71},{0,1,1,1,254,72},{0,1,1,1,254,73},{0,1,1,1,254,74},{0,1,1,1,254,75},{0,1,1,1,254,76},{0,1,1,1,254,77},{0,1,1,1,254,78},{0,1,1,1,254,79},{0,1,1,1,254,80},{0,1,1,1,254,81},{0,1,1,1,254,82},{0,1,1,1,254,83},{0,1,1,1,254,84},{0,1,1,1,254,85},{0,1,1,1,254,86},{0,1,1,1,254,87},{0,1,1,1,254,89},{0,1,1,1,254,106},{0,1,1,1,254,107},{0,1,1,1,254,113},{0,1,1,1,254,118},{0,1,1,1,254,119},{0,1,1,1,254,120},{0,1,1,1,254,121},{0,1,1,1,254,122},{85,0,0,1,0,254},{86,0,0,1,0,254},{87,0,0,1,0,254},{88,1,0,1,0,254},{13,0,1,1,2,48},{14,1,1,1,2,48},{13,0,1,1,2,49},{14,1,1,1,2,49},{13,0,1,1,2,50},{14,1,1,1,2,50},{13,0,1,1,2,97},{14,1,1,1,2,97},{13,0,1,1,2,99},{14,1,1,1,2,99},{13,0,1,1,2,101},{14,1,1,1,2,101},{13,0,1,1,2,105},{14,1,1,1,2,105},{13,0,1,1,2,111},{14,1,1,1,2,111},{13,0,1,1,2,115},{14,1,1,1,2,115},{13,0,1,1,2,116},{14,1,1,1,2,116},{0,1,1,1,2,32},{0,1,1,1,2,37},{0,1,1,1,2,45},{0,1,1,1,2,46},{0,1,1,1,2,47},{0,1,1,1,2,51},{0,1,1,1,2,52},{0,1,1,1,2,53},{0,1,1,1,2,54},{0,1,1,1,2,55},{0,1,1,1,2,56},{0,1,1,1,2,57},{0,1,1,1,2,61},{0,1,1,1,2,65},{0,1,1,1,2,95},{0,1,1,1,2,98},{0,1,1,1,2,100},{0,1,1,1,2,102},{0,1,1,1,2,103},{0,1,1,1,2,104},{0,1,1,1,2,108},{0,1,1,1,2,109},{0,1,1,1,2,110},{0,1,1,1,2,112},{0,1,1,1,2,114},{0,1,1,1,2,117},{17,0,0,1,0,2},{18,0,0,1,0,2},{19,0,0,1,0,2},{20,0,0,1,0,2},{21,0,0,1,0,2},{22,0,0,1,0,2},{23,0,0,1,0,2},{24,0,0,1,0,2},{25,0,0,1,0,2},{26,0,0,1,0,2},{27,0,0,1,0,2},{28,0,0,1,0,2},{29,0,0,1,0,2},{30,0,0,1,0,2},{31,0,0,1,0,2},{32,0,0,1,0,2},{33,0,0,1,0,2},{34,1,0,1,0,2},{13,0,1,1,3,48},{14,1,1,1,3,48},{13,0,1,1,3,49},{14,1,1,1,3,49},{13,0,1,1,3,50},{14,1,1,1,3,50},{13,0,1,1,3,97},{14,1,1,1,3,97},{13,0,1,1,3,99},{14,1,1,1,3,99},{13,0,1,1,3,101},{14,1,1,1,3,101},{13,0,1,1,3,105},{14,1,1,1,3,105},{13,0,1,1,3,111},{14,1,1,1,3,111},{13,0,1,1,3,115},{14,1,1,1,3,115},{13,0,1,1,3,116},{14,1,1,1,3,116},{0,1,1,1,3,32},{0,1,1,1,3,37},{0,1,1,1,3,45},{0,1,1,1,3,46},{0,1,1,1,3,47},{0,1,1,1,3,51},{0,1,1,1,3,52},{0,1,1,1,3,53},{0,1,1,1,3,54},{0,1,1,1,3,55},{0,1,1,1,3,56},{0,1,1,1,3,57},{0,1,1,1,3,61},{0,1,1,1,3,65},{0,1,1,1,3,95},{0,1,1,1,3,98},{0,1,1,1,3,100},{0,1,1,1,3,102},{0,1,1,1,3,103},{0,1,1,1,3,104},{0,1,1,1,3,108},{0,1,1,1,3,109},{0,1,1,1,3,110},{0,1,1,1,3,112},{0,1,1,1,3,114},{0,1,1,1,3,117},{17,0,0,1,0,3},{18,0,0,1,0,3},{19,0,0,1,0,3},{20,0,0,1,0,3},{21,0,0,1,0,3},{22,0,0,1,0,3},{23,0,0,1,0,3},{24,0,0,1,0,3},{25,0,0,1,0,3},{26,0,0,1,0,3},{27,0,0,1,0,3},{28,0,0,1,0,3},{29,0,0,1,0,3},{30,0,0,1,0,3},{31,0,0,1,0,3},{32,0,0,1,0,3},{33,0,0,1,0,3},{34,1,0,1,0,3},{13,0,1,1,4,48},{14,1,1,1,4,48},{13,0,1,1,4,49},{14,1,1,1,4,49},{13,0,1,1,4,50},{14,1,1,1,4,50},{13,0,1,1,4,97},{14,1,1,1,4,97},{13,0,1,1,4,99},{14,1,1,1,4,99},{13,0,1,1,4,101},{14,1,1,1,4,101},{13,0,1,1,4,105},{14,1,1,1,4,105},{13,0,1,1,4,111},{14,1,1,1,4,111},{13,0,1,1,4,115},{14,1,1,1,4,115},{13,0,1,1,4,116},{14,1,1,1,4,116},{0,1,1,1,4,32},{0,1,1,1,4,37},{0,1,1,1,4,45},{0,1,1,1,4,46},{0,1,1,1,4,47},{0,1,1,1,4,51},{0,1,1,1,4,52},{0,1,1,1,4,53},{0,1,1,1,4,54},{0,1,1,1,4,55},{0,1,1,1,4,56},{0,1,1,1,4,57},{0,1,1,1,4,61},{0,1,1,1,4,65},{0,1,1,1,4,95},{0,1,1,1,4,98},{0,1,1,1,4,100},{0,1,1,1,4,102},{0,1,1,1,4,103},{0,1,1,1,4,104},{0,1,1,1,4,108},{0,1,1,1,4,109},{0,1,1,1,4,110},{0,1,1,1,4,112},{0,1,1,1,4,114},{0,1,1,1,4,117},{17,0,0,1,0,4},{18,0,0,1,0,4},{19,0,0,1,0,4},{20,0,0,1,0,4},{21,0,0,1,0,4},{22,0,0,1,0,4},{23,0,0,1,0,4},{24,0,0,1,0,4},{25,0,0,1,0,4},{26,0,0,1,0,4},{27,0,0,1,0,4},{28,0,0,1,0,4},{29,0,0,1,0,4},{30,0,0,1,0,4},{31,0,0,1,0,4},{32,0,0,1,0,4},{33,0,0,1,0,4},{34,1,0,1,0,4},{13,0,1,1,5,48},{14,1,1,1,5,48},{13,0,1,1,5,49},{14,1,1,1,5,49},{13,0,1,1,5,50},{14,1,1,1,5,50},{13,0,1,1,5,97},{14,1,1,1,5,97},{13,0,1,1,5,99},{14,1,1,1,5,99},{13,0,1,1,5,101},{14,1,1,1,5,101},{13,0,1,1,5,105},{14,1,1,1,5,105},{13,0,1,1,5,111},{14,1,1,1,5,111},{13,0,1,1,5,115},{14,1,1,1,5,115},{13,0,1,1,5,116},{14,1,1,1,5,116},{0,1,1,1,5,32},{0,1,1,1,5,37},{0,1,1,1,5,45},{0,1,1,1,5,46},{0,1,1,1,5,47},{0,1,1,1,5,51},{0,1,1,1,5,52},{0,1,1,1,5,53},{0,1,1,1,5,54},{0,1,1,1,5,55},{0,1,1,1,5,56},{0,1,1,1,5,57},{0,1,1,1,5,61},{0,1,1,1,5,65},{0,1,1,1,5,95},{0,1,1,1,5,98},{0,1,1,1,5,100},{0,1,1,1,5,102},{0,1,1,1,5,103},{0,1,1,1,5,104},{0,1,1,1,5,108},{0,1,1,1,5,109},{0,1,1,1,5,110},{0,1,1,1,5,112},{0,1,1,1,5,114},{0,1,1,1,5,117},{17,0,0,1,0,5},{18,0,0,1,0,5},{19,0,0,1,0,5},{20,0,0,1,0,5},{21,0,0,1,0,5},{22,0,0,1,0,5},{23,0,0,1,0,5},{24,0,0,1,0,5},{25,0,0,1,0,5},{26,0,0,1,0,5},{27,0,0,1,0,5},{28,0,0,1,0,5},{29,0,0,1,0,5},{30,0,0,1,0,5},{31,0,0,1,0,5},{32,0,0,1,0,5},{33,0,0,1,0,5},{34,1,0,1,0,5},{13,0,1,1,6,48},{14,1,1,1,6,48},{13,0,1,1,6,49},{14,1,1,1,6,49},{13,0,1,1,6,50},{14,1,1,1,6,50},{13,0,1,1,6,97},{14,1,1,1,6,97},{13,0,1,1,6,99},{14,1,1,1,6,99},{13,0,1,1,6,101},{14,1,1,1,6,101},{13,0,1,1,6,105},{14,1,1,1,6,105},{13,0,1,1,6,111},{14,1,1,1,6,111},{13,0,1,1,6,115},{14,1,1,1,6,115},{13,0,1,1,6,116},{14,1,1,1,6,116},{0,1,1,1,6,32},{0,1,1,1,6,37},{0,1,1,1,6,45},{0,1,1,1,6,46},{0,1,1,1,6,47},{0,1,1,1,6,51},{0,1,1,1,6,52},{0,1,1,1,6,53},{0,1,1,1,6,54},{0,1,1,1,6,55},{0,1,1,1,6,56},{0,1,1,1,6,57},{0,1,1,1,6,61},{0,1,1,1,6,65},{0,1,1,1,6,95},{0,1,1,1,6,98},{0,1,1,1,6,100},{0,1,1,1,6,102},{0,1,1,1,6,103},{0,1,1,1,6,104},{0,1,1,1,6,108},{0,1,1,1,6,109},{0,1,1,1,6,110},{0,1,1,1,6,112},{0,1,1,1,6,114},{0,1,1,1,6,117},{17,0,0,1,0,6},{18,0,0,1,0,6},{19,0,0,1,0,6},{20,0,0,1,0,6},{21,0,0,1,0,6},{22,0,0,1,0,6},{23,0,0,1,0,6},{24,0,0,1,0,6},{25,0,0,1,0,6},{26,0,0,1,0,6},{27,0,0,1,0,6},{28,0,0,1,0,6},{29,0,0,1,0,6},{30,0,0,1,0,6},{31,0,0,1,0,6},{32,0,0,1,0,6},{33,0,0,1,0,6},{34,1,0,1,0,6},{13,0,1,1,7,48},{14,1,1,1,7,48},{13,0,1,1,7,49},{14,1,1,1,7,49},{13,0,1,1,7,50},{14,1,1,1,7,50},{13,0,1,1,7,97},{14,1,1,1,7,97},{13,0,1,1,7,99},{14,1,1,1,7,99},{13,0,1,1,7,101},{14,1,1,1,7,101},{13,0,1,1,7,105},{14,1,1,1,7,105},{13,0,1,1,7,111},{14,1,1,1,7,111},{13,0,1,1,7,115},{14,1,1,1,7,115},{13,0,1,1,7,116},{14,1,1,1,7,116},{0,1,1,1,7,32},{0,1,1,1,7,37},{0,1,1,1,7,45},{0,1,1,1,7,46},{0,1,1,1,7,47},{0,1,1,1,7,51},{0,1,1,1,7,52},{0,1,1,1,7,53},{0,1,1,1,7,54},{0,1,1,1,7,55},{0,1,1,1,7,56},{0,1,1,1,7,57},{0,1,1,1,7,61},{0,1,1,1,7,65},{0,1,1,1,7,95},{0,1,1,1,7,98},{0,1,1,1,7,100},{0,1,1,1,7,102},{0,1,1,1,7,103},{0,1,1,1,7,104},{0,1,1,1,7,108},{0,1,1,1,7,109},{0,1,1,1,7,110},{0,1,1,1,7,112},{0,1,1,1,7,114},{0,1,1,1,7,117},{17,0,0,1,0,7},{18,0,0,1,0,7},{19,0,0,1,0,7},{20,0,0,1,0,7},{21,0,0,1,0,7},{22,0,0,1,0,7},{23,0,0,1,0,7},{24,0,0,1,0,7},{25,0,0,1,0,7},{26,0,0,1,0,7},{27,0,0,1,0,7},{28,0,0,1,0,7},{29,0,0,1,0,7},{30,0,0,1,0,7},{31,0,0,1,0,7},{32,0,0,1,0,7},{33,0,0,1,0,7},{34,1,0,1,0,7},{13,0,1,1,8,48},{14,1,1,1,8,48},{13,0,1,1,8,49},{14,1,1,1,8,49},{13,0,1,1,8,50},{14,1,1,1,8,50},{13,0,1,1,8,97},{14,1,1,1,8,97},{13,0,1,1,8,99},{14,1,1,1,8,99},{13,0,1,1,8,101},{14,1,1,1,8,101},{13,0,1,1,8,105},{14,1,1,1,8,105},{13,0,1,1,8,111},{14,1,1,1,8,111},{13,0,1,1,8,115},{14,1,1,1,8,115},{13,0,1,1,8,116},{14,1,1,1,8,116},{0,1,1,1,8,32},{0,1,1,1,8,37},{0,1,1,1,8,45},{0,1,1,1,8,46},{0,1,1,1,8,47},{0,1,1,1,8,51},{0,1,1,1,8,52},{0,1,1,1,8,53},{0,1,1,1,8,54},{0,1,1,1,8,55},{0,1,1,1,8,56},{0,1,1,1,8,57},{0,1,1,1,8,61},{0,1,1,1,8,65},{0,1,1,1,8,95},{0,1,1,1,8,98},{0,1,1,1,8,100},{0,1,1,1,8,102},{0,1,1,1,8,103},{0,1,1,1,8,104},{0,1,1,1,8,108},{0,1,1,1,8,109},{0,1,1,1,8,110},{0,1,1,1,8,112},{0,1,1,1,8,114},{0,1,1,1,8,117},{17,0,0,1,0,8},{18,0,0,1,0,8},{19,0,0,1,0,8},{20,0,0,1,0,8},{21,0,0,1,0,8},{22,0,0,1,0,8},{23,0,0,1,0,8},{24,0,0,1,0,8},{25,0,0,1,0,8},{26,0,0,1,0,8},{27,0,0,1,0,8},{28,0,0,1,0,8},{29,0,0,1,0,8},{30,0,0,1,0,8},{31,0,0,1,0,8},{32,0,0,1,0,8},{33,0,0,1,0,8},{34,1,0,1,0,8},{13,0,1,1,11,48},{14,1,1,1,11,48},{13,0,1,1,11,49},{14,1,1,1,11,49},{13,0,1,1,11,50},{14,1,1,1,11,50},{13,0,1,1,11,97},{14,1,1,1,11,97},{13,0,1,1,11,99},{14,1,1,1,11,99},{13,0,1,1,11,101},{14,1,1,1,11,101},{13,0,1,1,11,105},{14,1,1,1,11,105},{13,0,1,1,11,111},{14,1,1,1,11,111},{13,0,1,1,11,115},{14,1,1,1,11,115},{13,0,1,1,11,116},{14,1,1,1,11,116},{0,1,1,1,11,32},{0,1,1,1,11,37},{0,1,1,1,11,45},{0,1,1,1,11,46},{0,1,1,1,11,47},{0,1,1,1,11,51},{0,1,1,1,11,52},{0,1,1,1,11,53},{0,1,1,1,11,54},{0,1,1,1,11,55},{0,1,1,1,11,56},{0,1,1,1,11,57},{0,1,1,1,11,61},{0,1,1,1,11,65},{0,1,1,1,11,95},{0,1,1,1,11,98},{0,1,1,1,11,100},{0,1,1,1,11,102},{0,1,1,1,11,103},{0,1,1,1,11,104},{0,1,1,1,11,108},{0,1,1,1,11,109},{0,1,1,1,11,110},{0,1,1,1,11,112},{0,1,1,1,11,114},{0,1,1,1,11,117},{17,0,0,1,0,11},{18,0,0,1,0,11},{19,0,0,1,0,11},{20,0,0,1,0,11},{21,0,0,1,0,11},{22,0,0,1,0,11},{23,0,0,1,0,11},{24,0,0,1,0,11},{25,0,0,1,0,11},{26,0,0,1,0,11},{27,0,0,1,0,11},{28,0,0,1,0,11},{29,0,0,1,0,11},{30,0,0,1,0,11},{31,0,0,1,0,11},{32,0,0,1,0,11},{33,0,0,1,0,11},{34,1,0,1,0,11},{13,0,1,1,12,48},{14,1,1,1,12,48},{13,0,1,1,12,49},{14,1,1,1,12,49},{13,0,1,1,12,50},{14,1,1,1,12,50},{13,0,1,1,12,97},{14,1,1,1,12,97},{13,0,1,1,12,99},{14,1,1,1,12,99},{13,0,1,1,12,101},{14,1,1,1,12,101},{13,0,1,1,12,105},{14,1,1,1,12,105},{13,0,1,1,12,111},{14,1,1,1,12,111},{13,0,1,1,12,115},{14,1,1,1,12,115},{13,0,1,1,12,116},{14,1,1,1,12,116},{0,1,1,1,12,32},{0,1,1,1,12,37},{0,1,1,1,12,45},{0,1,1,1,12,46},{0,1,1,1,12,47},{0,1,1,1,12,51},{0,1,1,1,12,52},{0,1,1,1,12,53},{0,1,1,1,12,54},{0,1,1,1,12,55},{0,1,1,1,12,56},{0,1,1,1,12,57},{0,1,1,1,12,61},{0,1,1,1,12,65},{0,1,1,1,12,95},{0,1,1,1,12,98},{0,1,1,1,12,100},{0,1,1,1,12,102},{0,1,1,1,12,103},{0,1,1,1,12,104},{0,1,1,1,12,108},{0,1,1,1,12,109},{0,1,1,1,12,110},{0,1,1,1,12,112},{0,1,1,1,12,114},{0,1,1,1,12,117},{17,0,0,1,0,12},{18,0,0,1,0,12},{19,0,0,1,0,12},{20,0,0,1,0,12},{21,0,0,1,0,12},{22,0,0,1,0,12},{23,0,0,1,0,12},{24,0,0,1,0,12},{25,0,0,1,0,12},{26,0,0,1,0,12},{27,0,0,1,0,12},{28,0,0,1,0,12},{29,0,0,1,0,12},{30,0,0,1,0,12},{31,0,0,1,0,12},{32,0,0,1,0,12},{33,0,0,1,0,12},{34,1,0,1,0,12},{13,0,1,1,14,48},{14,1,1,1,14,48},{13,0,1,1,14,49},{14,1,1,1,14,49},{13,0,1,1,14,50},{14,1,1,1,14,50},{13,0,1,1,14,97},{14,1,1,1,14,97},{13,0,1,1,14,99},{14,1,1,1,14,99},{13,0,1,1,14,101},{14,1,1,1,14,101},{13,0,1,1,14,105},{14,1,1,1,14,105},{13,0,1,1,14,111},{14,1,1,1,14,111},{13,0,1,1,14,115},{14,1,1,1,14,115},{13,0,1,1,14,116},{14,1,1,1,14,116},{0,1,1,1,14,32},{0,1,1,1,14,37},{0,1,1,1,14,45},{0,1,1,1,14,46},{0,1,1,1,14,47},{0,1,1,1,14,51},{0,1,1,1,14,52},{0,1,1,1,14,53},{0,1,1,1,14,54},{0,1,1,1,14,55},{0,1,1,1,14,56},{0,1,1,1,14,57},{0,1,1,1,14,61},{0,1,1,1,14,65},{0,1,1,1,14,95},{0,1,1,1,14,98},{0,1,1,1,14,100},{0,1,1,1,14,102},{0,1,1,1,14,103},{0,1,1,1,14,104},{0,1,1,1,14,108},{0,1,1,1,14,109},{0,1,1,1,14,110},{0,1,1,1,14,112},{0,1,1,1,14,114},{0,1,1,1,14,117},{17,0,0,1,0,14},{18,0,0,1,0,14},{19,0,0,1,0,14},{20,0,0,1,0,14},{21,0,0,1,0,14},{22,0,0,1,0,14},{23,0,0,1,0,14},{24,0,0,1,0,14},{25,0,0,1,0,14},{26,0,0,1,0,14},{27,0,0,1,0,14},{28,0,0,1,0,14},{29,0,0,1,0,14},{30,0,0,1,0,14},{31,0,0,1,0,14},{32,0,0,1,0,14},{33,0,0,1,0,14},{34,1,0,1,0,14},{13,0,1,1,15,48},{14,1,1,1,15,48},{13,0,1,1,15,49},{14,1,1,1,15,49},{13,0,1,1,15,50},{14,1,1,1,15,50},{13,0,1,1,15,97},{14,1,1,1,15,97},{13,0,1,1,15,99},{14,1,1,1,15,99},{13,0,1,1,15,101},{14,1,1,1,15,101},{13,0,1,1,15,105},{14,1,1,1,15,105},{13,0,1,1,15,111},{14,1,1,1,15,111},{13,0,1,1,15,115},{14,1,1,1,15,115},{13,0,1,1,15,116},{14,1,1,1,15,116},{0,1,1,1,15,32},{0,1,1,1,15,37},{0,1,1,1,15,45},{0,1,1,1,15,46},{0,1,1,1,15,47},{0,1,1,1,15,51},{0,1,1,1,15,52},{0,1,1,1,15,53},{0,1,1,1,15,54},{0,1,1,1,15,55},{0,1,1,1,15,56},{0,1,1,1,15,57},{0,1,1,1,15,61},{0,1,1,1,15,65},{0,1,1,1,15,95},{0,1,1,1,15,98},{0,1,1,1,15,100},{0,1,1,1,15,102},{0,1,1,1,15,103},{0,1,1,1,15,104},{0,1,1,1,15,108},{0,1,1,1,15,109},{0,1,1,1,15,110},{0,1,1,1,15,112},{0,1,1,1,15,114},{0,1,1,1,15,117},{17,0,0,1,0,15},{18,0,0,1,0,15},{19,0,0,1,0,15},{20,0,0,1,0,15},{21,0,0,1,0,15},{22,0,0,1,0,15},{23,0,0,1,0,15},{24,0,0,1,0,15},{25,0,0,1,0,15},{26,0,0,1,0,15},{27,0,0,1,0,15},{28,0,0,1,0,15},{29,0,0,1,0,15},{30,0,0,1,0,15},{31,0,0,1,0,15},{32,0,0,1,0,15},{33,0,0,1,0,15},{34,1,0,1,0,15},{13,0,1,1,16,48},{14,1,1,1,16,48},{13,0,1,1,16,49},{14,1,1,1,16,49},{13,0,1,1,16,50},{14,1,1,1,16,50},{13,0,1,1,16,97},{14,1,1,1,16,97},{13,0,1,1,16,99},{14,1,1,1,16,99},{13,0,1,1,16,101},{14,1,1,1,16,101},{13,0,1,1,16,105},{14,1,1,1,16,105},{13,0,1,1,16,111},{14,1,1,1,16,111},{13,0,1,1,16,115},{14,1,1,1,16,115},{13,0,1,1,16,116},{14,1,1,1,16,116},{0,1,1,1,16,32},{0,1,1,1,16,37},{0,1,1,1,16,45},{0,1,1,1,16,46},{0,1,1,1,16,47},{0,1,1,1,16,51},{0,1,1,1,16,52},{0,1,1,1,16,53},{0,1,1,1,16,54},{0,1,1,1,16,55},{0,1,1,1,16,56},{0,1,1,1,16,57},{0,1,1,1,16,61},{0,1,1,1,16,65},{0,1,1,1,16,95},{0,1,1,1,16,98},{0,1,1,1,16,100},{0,1,1,1,16,102},{0,1,1,1,16,103},{0,1,1,1,16,104},{0,1,1,1,16,108},{0,1,1,1,16,109},{0,1,1,1,16,110},{0,1,1,1,16,112},{0,1,1,1,16,114},{0,1,1,1,16,117},{17,0,0,1,0,16},{18,0,0,1,0,16},{19,0,0,1,0,16},{20,0,0,1,0,16},{21,0,0,1,0,16},{22,0,0,1,0,16},{23,0,0,1,0,16},{24,0,0,1,0,16},{25,0,0,1,0,16},{26,0,0,1,0,16},{27,0,0,1,0,16},{28,0,0,1,0,16},{29,0,0,1,0,16},{30,0,0,1,0,16},{31,0,0,1,0,16},{32,0,0,1,0,16},{33,0,0,1,0,16},{34,1,0,1,0,16},{13,0,1,1,17,48},{14,1,1,1,17,48},{13,0,1,1,17,49},{14,1,1,1,17,49},{13,0,1,1,17,50},{14,1,1,1,17,50},{13,0,1,1,17,97},{14,1,1,1,17,97},{13,0,1,1,17,99},{14,1,1,1,17,99},{13,0,1,1,17,101},{14,1,1,1,17,101},{13,0,1,1,17,105},{14,1,1,1,17,105},{13,0,1,1,17,111},{14,1,1,1,17,111},{13,0,1,1,17,115},{14,1,1,1,17,115},{13,0,1,1,17,116},{14,1,1,1,17,116},{0,1,1,1,17,32},{0,1,1,1,17,37},{0,1,1,1,17,45},{0,1,1,1,17,46},{0,1,1,1,17,47},{0,1,1,1,17,51},{0,1,1,1,17,52},{0,1,1,1,17,53},{0,1,1,1,17,54},{0,1,1,1,17,55},{0,1,1,1,17,56},{0,1,1,1,17,57},{0,1,1,1,17,61},{0,1,1,1,17,65},{0,1,1,1,17,95},{0,1,1,1,17,98},{0,1,1,1,17,100},{0,1,1,1,17,102},{0,1,1,1,17,103},{0,1,1,1,17,104},{0,1,1,1,17,108},{0,1,1,1,17,109},{0,1,1,1,17,110},{0,1,1,1,17,112},{0,1,1,1,17,114},{0,1,1,1,17,117},{17,0,0,1,0,17},{18,0,0,1,0,17},{19,0,0,1,0,17},{20,0,0,1,0,17},{21,0,0,1,0,17},{22,0,0,1,0,17},{23,0,0,1,0,17},{24,0,0,1,0,17},{25,0,0,1,0,17},{26,0,0,1,0,17},{27,0,0,1,0,17},{28,0,0,1,0,17},{29,0,0,1,0,17},{30,0,0,1,0,17},{31,0,0,1,0,17},{32,0,0,1,0,17},{33,0,0,1,0,17},{34,1,0,1,0,17},{13,0,1,1,18,48},{14,1,1,1,18,48},{13,0,1,1,18,49},{14,1,1,1,18,49},{13,0,1,1,18,50},{14,1,1,1,18,50},{13,0,1,1,18,97},{14,1,1,1,18,97},{13,0,1,1,18,99},{14,1,1,1,18,99},{13,0,1,1,18,101},{14,1,1,1,18,101},{13,0,1,1,18,105},{14,1,1,1,18,105},{13,0,1,1,18,111},{14,1,1,1,18,111},{13,0,1,1,18,115},{14,1,1,1,18,115},{13,0,1,1,18,116},{14,1,1,1,18,116},{0,1,1,1,18,32},{0,1,1,1,18,37},{0,1,1,1,18,45},{0,1,1,1,18,46},{0,1,1,1,18,47},{0,1,1,1,18,51},{0,1,1,1,18,52},{0,1,1,1,18,53},{0,1,1,1,18,54},{0,1,1,1,18,55},{0,1,1,1,18,56},{0,1,1,1,18,57},{0,1,1,1,18,61},{0,1,1,1,18,65},{0,1,1,1,18,95},{0,1,1,1,18,98},{0,1,1,1,18,100},{0,1,1,1,18,102},{0,1,1,1,18,103},{0,1,1,1,18,104},{0,1,1,1,18,108},{0,1,1,1,18,109},{0,1,1,1,18,110},{0,1,1,1,18,112},{0,1,1,1,18,114},{0,1,1,1,18,117},{17,0,0,1,0,18},{18,0,0,1,0,18},{19,0,0,1,0,18},{20,0,0,1,0,18},{21,0,0,1,0,18},{22,0,0,1,0,18},{23,0,0,1,0,18},{24,0,0,1,0,18},{25,0,0,1,0,18},{26,0,0,1,0,18},{27,0,0,1,0,18},{28,0,0,1,0,18},{29,0,0,1,0,18},{30,0,0,1,0,18},{31,0,0,1,0,18},{32,0,0,1,0,18},{33,0,0,1,0,18},{34,1,0,1,0,18},{13,0,1,1,19,48},{14,1,1,1,19,48},{13,0,1,1,19,49},{14,1,1,1,19,49},{13,0,1,1,19,50},{14,1,1,1,19,50},{13,0,1,1,19,97},{14,1,1,1,19,97},{13,0,1,1,19,99},{14,1,1,1,19,99},{13,0,1,1,19,101},{14,1,1,1,19,101},{13,0,1,1,19,105},{14,1,1,1,19,105},{13,0,1,1,19,111},{14,1,1,1,19,111},{13,0,1,1,19,115},{14,1,1,1,19,115},{13,0,1,1,19,116},{14,1,1,1,19,116},{0,1,1,1,19,32},{0,1,1,1,19,37},{0,1,1,1,19,45},{0,1,1,1,19,46},{0,1,1,1,19,47},{0,1,1,1,19,51},{0,1,1,1,19,52},{0,1,1,1,19,53},{0,1,1,1,19,54},{0,1,1,1,19,55},{0,1,1,1,19,56},{0,1,1,1,19,57},{0,1,1,1,19,61},{0,1,1,1,19,65},{0,1,1,1,19,95},{0,1,1,1,19,98},{0,1,1,1,19,100},{0,1,1,1,19,102},{0,1,1,1,19,103},{0,1,1,1,19,104},{0,1,1,1,19,108},{0,1,1,1,19,109},{0,1,1,1,19,110},{0,1,1,1,19,112},{0,1,1,1,19,114},{0,1,1,1,19,117},{17,0,0,1,0,19},{18,0,0,1,0,19},{19,0,0,1,0,19},{20,0,0,1,0,19},{21,0,0,1,0,19},{22,0,0,1,0,19},{23,0,0,1,0,19},{24,0,0,1,0,19},{25,0,0,1,0,19},{26,0,0,1,0,19},{27,0,0,1,0,19},{28,0,0,1,0,19},{29,0,0,1,0,19},{30,0,0,1,0,19},{31,0,0,1,0,19},{32,0,0,1,0,19},{33,0,0,1,0,19},{34,1,0,1,0,19},{13,0,1,1,20,48},{14,1,1,1,20,48},{13,0,1,1,20,49},{14,1,1,1,20,49},{13,0,1,1,20,50},{14,1,1,1,20,50},{13,0,1,1,20,97},{14,1,1,1,20,97},{13,0,1,1,20,99},{14,1,1,1,20,99},{13,0,1,1,20,101},{14,1,1,1,20,101},{13,0,1,1,20,105},{14,1,1,1,20,105},{13,0,1,1,20,111},{14,1,1,1,20,111},{13,0,1,1,20,115},{14,1,1,1,20,115},{13,0,1,1,20,116},{14,1,1,1,20,116},{0,1,1,1,20,32},{0,1,1,1,20,37},{0,1,1,1,20,45},{0,1,1,1,20,46},{0,1,1,1,20,47},{0,1,1,1,20,51},{0,1,1,1,20,52},{0,1,1,1,20,53},{0,1,1,1,20,54},{0,1,1,1,20,55},{0,1,1,1,20,56},{0,1,1,1,20,57},{0,1,1,1,20,61},{0,1,1,1,20,65},{0,1,1,1,20,95},{0,1,1,1,20,98},{0,1,1,1,20,100},{0,1,1,1,20,102},{0,1,1,1,20,103},{0,1,1,1,20,104},{0,1,1,1,20,108},{0,1,1,1,20,109},{0,1,1,1,20,110},{0,1,1,1,20,112},{0,1,1,1,20,114},{0,1,1,1,20,117},{17,0,0,1,0,20},{18,0,0,1,0,20},{19,0,0,1,0,20},{20,0,0,1,0,20},{21,0,0,1,0,20},{22,0,0,1,0,20},{23,0,0,1,0,20},{24,0,0,1,0,20},{25,0,0,1,0,20},{26,0,0,1,0,20},{27,0,0,1,0,20},{28,0,0,1,0,20},{29,0,0,1,0,20},{30,0,0,1,0,20},{31,0,0,1,0,20},{32,0,0,1,0,20},{33,0,0,1,0,20},{34,1,0,1,0,20},{13,0,1,1,21,48},{14,1,1,1,21,48},{13,0,1,1,21,49},{14,1,1,1,21,49},{13,0,1,1,21,50},{14,1,1,1,21,50},{13,0,1,1,21,97},{14,1,1,1,21,97},{13,0,1,1,21,99},{14,1,1,1,21,99},{13,0,1,1,21,101},{14,1,1,1,21,101},{13,0,1,1,21,105},{14,1,1,1,21,105},{13,0,1,1,21,111},{14,1,1,1,21,111},{13,0,1,1,21,115},{14,1,1,1,21,115},{13,0,1,1,21,116},{14,1,1,1,21,116},{0,1,1,1,21,32},{0,1,1,1,21,37},{0,1,1,1,21,45},{0,1,1,1,21,46},{0,1,1,1,21,47},{0,1,1,1,21,51},{0,1,1,1,21,52},{0,1,1,1,21,53},{0,1,1,1,21,54},{0,1,1,1,21,55},{0,1,1,1,21,56},{0,1,1,1,21,57},{0,1,1,1,21,61},{0,1,1,1,21,65},{0,1,1,1,21,95},{0,1,1,1,21,98},{0,1,1,1,21,100},{0,1,1,1,21,102},{0,1,1,1,21,103},{0,1,1,1,21,104},{0,1,1,1,21,108},{0,1,1,1,21,109},{0,1,1,1,21,110},{0,1,1,1,21,112},{0,1,1,1,21,114},{0,1,1,1,21,117},{17,0,0,1,0,21},{18,0,0,1,0,21},{19,0,0,1,0,21},{20,0,0,1,0,21},{21,0,0,1,0,21},{22,0,0,1,0,21},{23,0,0,1,0,21},{24,0,0,1,0,21},{25,0,0,1,0,21},{26,0,0,1,0,21},{27,0,0,1,0,21},{28,0,0,1,0,21},{29,0,0,1,0,21},{30,0,0,1,0,21},{31,0,0,1,0,21},{32,0,0,1,0,21},{33,0,0,1,0,21},{34,1,0,1,0,21},{13,0,1,1,23,48},{14,1,1,1,23,48},{13,0,1,1,23,49},{14,1,1,1,23,49},{13,0,1,1,23,50},{14,1,1,1,23,50},{13,0,1,1,23,97},{14,1,1,1,23,97},{13,0,1,1,23,99},{14,1,1,1,23,99},{13,0,1,1,23,101},{14,1,1,1,23,101},{13,0,1,1,23,105},{14,1,1,1,23,105},{13,0,1,1,23,111},{14,1,1,1,23,111},{13,0,1,1,23,115},{14,1,1,1,23,115},{13,0,1,1,23,116},{14,1,1,1,23,116},{0,1,1,1,23,32},{0,1,1,1,23,37},{0,1,1,1,23,45},{0,1,1,1,23,46},{0,1,1,1,23,47},{0,1,1,1,23,51},{0,1,1,1,23,52},{0,1,1,1,23,53},{0,1,1,1,23,54},{0,1,1,1,23,55},{0,1,1,1,23,56},{0,1,1,1,23,57},{0,1,1,1,23,61},{0,1,1,1,23,65},{0,1,1,1,23,95},{0,1,1,1,23,98},{0,1,1,1,23,100},{0,1,1,1,23,102},{0,1,1,1,23,103},{0,1,1,1,23,104},{0,1,1,1,23,108},{0,1,1,1,23,109},{0,1,1,1,23,110},{0,1,1,1,23,112},{0,1,1,1,23,114},{0,1,1,1,23,117},{17,0,0,1,0,23},{18,0,0,1,0,23},{19,0,0,1,0,23},{20,0,0,1,0,23},{21,0,0,1,0,23},{22,0,0,1,0,23},{23,0,0,1,0,23},{24,0,0,1,0,23},{25,0,0,1,0,23},{26,0,0,1,0,23},{27,0,0,1,0,23},{28,0,0,1,0,23},{29,0,0,1,0,23},{30,0,0,1,0,23},{31,0,0,1,0,23},{32,0,0,1,0,23},{33,0,0,1,0,23},{34,1,0,1,0,23},{13,0,1,1,24,48},{14,1,1,1,24,48},{13,0,1,1,24,49},{14,1,1,1,24,49},{13,0,1,1,24,50},{14,1,1,1,24,50},{13,0,1,1,24,97},{14,1,1,1,24,97},{13,0,1,1,24,99},{14,1,1,1,24,99},{13,0,1,1,24,101},{14,1,1,1,24,101},{13,0,1,1,24,105},{14,1,1,1,24,105},{13,0,1,1,24,111},{14,1,1,1,24,111},{13,0,1,1,24,115},{14,1,1,1,24,115},{13,0,1,1,24,116},{14,1,1,1,24,116},{0,1,1,1,24,32},{0,1,1,1,24,37},{0,1,1,1,24,45},{0,1,1,1,24,46},{0,1,1,1,24,47},{0,1,1,1,24,51},{0,1,1,1,24,52},{0,1,1,1,24,53},{0,1,1,1,24,54},{0,1,1,1,24,55},{0,1,1,1,24,56},{0,1,1,1,24,57},{0,1,1,1,24,61},{0,1,1,1,24,65},{0,1,1,1,24,95},{0,1,1,1,24,98},{0,1,1,1,24,100},{0,1,1,1,24,102},{0,1,1,1,24,103},{0,1,1,1,24,104},{0,1,1,1,24,108},{0,1,1,1,24,109},{0,1,1,1,24,110},{0,1,1,1,24,112},{0,1,1,1,24,114},{0,1,1,1,24,117},{17,0,0,1,0,24},{18,0,0,1,0,24},{19,0,0,1,0,24},{20,0,0,1,0,24},{21,0,0,1,0,24},{22,0,0,1,0,24},{23,0,0,1,0,24},{24,0,0,1,0,24},{25,0,0,1,0,24},{26,0,0,1,0,24},{27,0,0,1,0,24},{28,0,0,1,0,24},{29,0,0,1,0,24},{30,0,0,1,0,24},{31,0,0,1,0,24},{32,0,0,1,0,24},{33,0,0,1,0,24},{34,1,0,1,0,24},{13,0,1,1,25,48},{14,1,1,1,25,48},{13,0,1,1,25,49},{14,1,1,1,25,49},{13,0,1,1,25,50},{14,1,1,1,25,50},{13,0,1,1,25,97},{14,1,1,1,25,97},{13,0,1,1,25,99},{14,1,1,1,25,99},{13,0,1,1,25,101},{14,1,1,1,25,101},{13,0,1,1,25,105},{14,1,1,1,25,105},{13,0,1,1,25,111},{14,1,1,1,25,111},{13,0,1,1,25,115},{14,1,1,1,25,115},{13,0,1,1,25,116},{14,1,1,1,25,116},{0,1,1,1,25,32},{0,1,1,1,25,37},{0,1,1,1,25,45},{0,1,1,1,25,46},{0,1,1,1,25,47},{0,1,1,1,25,51},{0,1,1,1,25,52},{0,1,1,1,25,53},{0,1,1,1,25,54},{0,1,1,1,25,55},{0,1,1,1,25,56},{0,1,1,1,25,57},{0,1,1,1,25,61},{0,1,1,1,25,65},{0,1,1,1,25,95},{0,1,1,1,25,98},{0,1,1,1,25,100},{0,1,1,1,25,102},{0,1,1,1,25,103},{0,1,1,1,25,104},{0,1,1,1,25,108},{0,1,1,1,25,109},{0,1,1,1,25,110},{0,1,1,1,25,112},{0,1,1,1,25,114},{0,1,1,1,25,117},{17,0,0,1,0,25},{18,0,0,1,0,25},{19,0,0,1,0,25},{20,0,0,1,0,25},{21,0,0,1,0,25},{22,0,0,1,0,25},{23,0,0,1,0,25},{24,0,0,1,0,25},{25,0,0,1,0,25},{26,0,0,1,0,25},{27,0,0,1,0,25},{28,0,0,1,0,25},{29,0,0,1,0,25},{30,0,0,1,0,25},{31,0,0,1,0,25},{32,0,0,1,0,25},{33,0,0,1,0,25},{34,1,0,1,0,25},{13,0,1,1,26,48},{14,1,1,1,26,48},{13,0,1,1,26,49},{14,1,1,1,26,49},{13,0,1,1,26,50},{14,1,1,1,26,50},{13,0,1,1,26,97},{14,1,1,1,26,97},{13,0,1,1,26,99},{14,1,1,1,26,99},{13,0,1,1,26,101},{14,1,1,1,26,101},{13,0,1,1,26,105},{14,1,1,1,26,105},{13,0,1,1,26,111},{14,1,1,1,26,111},{13,0,1,1,26,115},{14,1,1,1,26,115},{13,0,1,1,26,116},{14,1,1,1,26,116},{0,1,1,1,26,32},{0,1,1,1,26,37},{0,1,1,1,26,45},{0,1,1,1,26,46},{0,1,1,1,26,47},{0,1,1,1,26,51},{0,1,1,1,26,52},{0,1,1,1,26,53},{0,1,1,1,26,54},{0,1,1,1,26,55},{0,1,1,1,26,56},{0,1,1,1,26,57},{0,1,1,1,26,61},{0,1,1,1,26,65},{0,1,1,1,26,95},{0,1,1,1,26,98},{0,1,1,1,26,100},{0,1,1,1,26,102},{0,1,1,1,26,103},{0,1,1,1,26,104},{0,1,1,1,26,108},{0,1,1,1,26,109},{0,1,1,1,26,110},{0,1,1,1,26,112},{0,1,1,1,26,114},{0,1,1,1,26,117},{17,0,0,1,0,26},{18,0,0,1,0,26},{19,0,0,1,0,26},{20,0,0,1,0,26},{21,0,0,1,0,26},{22,0,0,1,0,26},{23,0,0,1,0,26},{24,0,0,1,0,26},{25,0,0,1,0,26},{26,0,0,1,0,26},{27,0,0,1,0,26},{28,0,0,1,0,26},{29,0,0,1,0,26},{30,0,0,1,0,26},{31,0,0,1,0,26},{32,0,0,1,0,26},{33,0,0,1,0,26},{34,1,0,1,0,26},{13,0,1,1,27,48},{14,1,1,1,27,48},{13,0,1,1,27,49},{14,1,1,1,27,49},{13,0,1,1,27,50},{14,1,1,1,27,50},{13,0,1,1,27,97},{14,1,1,1,27,97},{13,0,1,1,27,99},{14,1,1,1,27,99},{13,0,1,1,27,101},{14,1,1,1,27,101},{13,0,1,1,27,105},{14,1,1,1,27,105},{13,0,1,1,27,111},{14,1,1,1,27,111},{13,0,1,1,27,115},{14,1,1,1,27,115},{13,0,1,1,27,116},{14,1,1,1,27,116},{0,1,1,1,27,32},{0,1,1,1,27,37},{0,1,1,1,27,45},{0,1,1,1,27,46},{0,1,1,1,27,47},{0,1,1,1,27,51},{0,1,1,1,27,52},{0,1,1,1,27,53},{0,1,1,1,27,54},{0,1,1,1,27,55},{0,1,1,1,27,56},{0,1,1,1,27,57},{0,1,1,1,27,61},{0,1,1,1,27,65},{0,1,1,1,27,95},{0,1,1,1,27,98},{0,1,1,1,27,100},{0,1,1,1,27,102},{0,1,1,1,27,103},{0,1,1,1,27,104},{0,1,1,1,27,108},{0,1,1,1,27,109},{0,1,1,1,27,110},{0,1,1,1,27,112},{0,1,1,1,27,114},{0,1,1,1,27,117},{17,0,0,1,0,27},{18,0,0,1,0,27},{19,0,0,1,0,27},{20,0,0,1,0,27},{21,0,0,1,0,27},{22,0,0,1,0,27},{23,0,0,1,0,27},{24,0,0,1,0,27},{25,0,0,1,0,27},{26,0,0,1,0,27},{27,0,0,1,0,27},{28,0,0,1,0,27},{29,0,0,1,0,27},{30,0,0,1,0,27},{31,0,0,1,0,27},{32,0,0,1,0,27},{33,0,0,1,0,27},{34,1,0,1,0,27},{13,0,1,1,28,48},{14,1,1,1,28,48},{13,0,1,1,28,49},{14,1,1,1,28,49},{13,0,1,1,28,50},{14,1,1,1,28,50},{13,0,1,1,28,97},{14,1,1,1,28,97},{13,0,1,1,28,99},{14,1,1,1,28,99},{13,0,1,1,28,101},{14,1,1,1,28,101},{13,0,1,1,28,105},{14,1,1,1,28,105},{13,0,1,1,28,111},{14,1,1,1,28,111},{13,0,1,1,28,115},{14,1,1,1,28,115},{13,0,1,1,28,116},{14,1,1,1,28,116},{0,1,1,1,28,32},{0,1,1,1,28,37},{0,1,1,1,28,45},{0,1,1,1,28,46},{0,1,1,1,28,47},{0,1,1,1,28,51},{0,1,1,1,28,52},{0,1,1,1,28,53},{0,1,1,1,28,54},{0,1,1,1,28,55},{0,1,1,1,28,56},{0,1,1,1,28,57},{0,1,1,1,28,61},{0,1,1,1,28,65},{0,1,1,1,28,95},{0,1,1,1,28,98},{0,1,1,1,28,100},{0,1,1,1,28,102},{0,1,1,1,28,103},{0,1,1,1,28,104},{0,1,1,1,28,108},{0,1,1,1,28,109},{0,1,1,1,28,110},{0,1,1,1,28,112},{0,1,1,1,28,114},{0,1,1,1,28,117},{17,0,0,1,0,28},{18,0,0,1,0,28},{19,0,0,1,0,28},{20,0,0,1,0,28},{21,0,0,1,0,28},{22,0,0,1,0,28},{23,0,0,1,0,28},{24,0,0,1,0,28},{25,0,0,1,0,28},{26,0,0,1,0,28},{27,0,0,1,0,28},{28,0,0,1,0,28},{29,0,0,1,0,28},{30,0,0,1,0,28},{31,0,0,1,0,28},{32,0,0,1,0,28},{33,0,0,1,0,28},{34,1,0,1,0,28},{13,0,1,1,29,48},{14,1,1,1,29,48},{13,0,1,1,29,49},{14,1,1,1,29,49},{13,0,1,1,29,50},{14,1,1,1,29,50},{13,0,1,1,29,97},{14,1,1,1,29,97},{13,0,1,1,29,99},{14,1,1,1,29,99},{13,0,1,1,29,101},{14,1,1,1,29,101},{13,0,1,1,29,105},{14,1,1,1,29,105},{13,0,1,1,29,111},{14,1,1,1,29,111},{13,0,1,1,29,115},{14,1,1,1,29,115},{13,0,1,1,29,116},{14,1,1,1,29,116},{0,1,1,1,29,32},{0,1,1,1,29,37},{0,1,1,1,29,45},{0,1,1,1,29,46},{0,1,1,1,29,47},{0,1,1,1,29,51},{0,1,1,1,29,52},{0,1,1,1,29,53},{0,1,1,1,29,54},{0,1,1,1,29,55},{0,1,1,1,29,56},{0,1,1,1,29,57},{0,1,1,1,29,61},{0,1,1,1,29,65},{0,1,1,1,29,95},{0,1,1,1,29,98},{0,1,1,1,29,100},{0,1,1,1,29,102},{0,1,1,1,29,103},{0,1,1,1,29,104},{0,1,1,1,29,108},{0,1,1,1,29,109},{0,1,1,1,29,110},{0,1,1,1,29,112},{0,1,1,1,29,114},{0,1,1,1,29,117},{17,0,0,1,0,29},{18,0,0,1,0,29},{19,0,0,1,0,29},{20,0,0,1,0,29},{21,0,0,1,0,29},{22,0,0,1,0,29},{23,0,0,1,0,29},{24,0,0,1,0,29},{25,0,0,1,0,29},{26,0,0,1,0,29},{27,0,0,1,0,29},{28,0,0,1,0,29},{29,0,0,1,0,29},{30,0,0,1,0,29},{31,0,0,1,0,29},{32,0,0,1,0,29},{33,0,0,1,0,29},{34,1,0,1,0,29},{13,0,1,1,30,48},{14,1,1,1,30,48},{13,0,1,1,30,49},{14,1,1,1,30,49},{13,0,1,1,30,50},{14,1,1,1,30,50},{13,0,1,1,30,97},{14,1,1,1,30,97},{13,0,1,1,30,99},{14,1,1,1,30,99},{13,0,1,1,30,101},{14,1,1,1,30,101},{13,0,1,1,30,105},{14,1,1,1,30,105},{13,0,1,1,30,111},{14,1,1,1,30,111},{13,0,1,1,30,115},{14,1,1,1,30,115},{13,0,1,1,30,116},{14,1,1,1,30,116},{0,1,1,1,30,32},{0,1,1,1,30,37},{0,1,1,1,30,45},{0,1,1,1,30,46},{0,1,1,1,30,47},{0,1,1,1,30,51},{0,1,1,1,30,52},{0,1,1,1,30,53},{0,1,1,1,30,54},{0,1,1,1,30,55},{0,1,1,1,30,56},{0,1,1,1,30,57},{0,1,1,1,30,61},{0,1,1,1,30,65},{0,1,1,1,30,95},{0,1,1,1,30,98},{0,1,1,1,30,100},{0,1,1,1,30,102},{0,1,1,1,30,103},{0,1,1,1,30,104},{0,1,1,1,30,108},{0,1,1,1,30,109},{0,1,1,1,30,110},{0,1,1,1,30,112},{0,1,1,1,30,114},{0,1,1,1,30,117},{17,0,0,1,0,30},{18,0,0,1,0,30},{19,0,0,1,0,30},{20,0,0,1,0,30},{21,0,0,1,0,30},{22,0,0,1,0,30},{23,0,0,1,0,30},{24,0,0,1,0,30},{25,0,0,1,0,30},{26,0,0,1,0,30},{27,0,0,1,0,30},{28,0,0,1,0,30},{29,0,0,1,0,30},{30,0,0,1,0,30},{31,0,0,1,0,30},{32,0,0,1,0,30},{33,0,0,1,0,30},{34,1,0,1,0,30},{13,0,1,1,31,48},{14,1,1,1,31,48},{13,0,1,1,31,49},{14,1,1,1,31,49},{13,0,1,1,31,50},{14,1,1,1,31,50},{13,0,1,1,31,97},{14,1,1,1,31,97},{13,0,1,1,31,99},{14,1,1,1,31,99},{13,0,1,1,31,101},{14,1,1,1,31,101},{13,0,1,1,31,105},{14,1,1,1,31,105},{13,0,1,1,31,111},{14,1,1,1,31,111},{13,0,1,1,31,115},{14,1,1,1,31,115},{13,0,1,1,31,116},{14,1,1,1,31,116},{0,1,1,1,31,32},{0,1,1,1,31,37},{0,1,1,1,31,45},{0,1,1,1,31,46},{0,1,1,1,31,47},{0,1,1,1,31,51},{0,1,1,1,31,52},{0,1,1,1,31,53},{0,1,1,1,31,54},{0,1,1,1,31,55},{0,1,1,1,31,56},{0,1,1,1,31,57},{0,1,1,1,31,61},{0,1,1,1,31,65},{0,1,1,1,31,95},{0,1,1,1,31,98},{0,1,1,1,31,100},{0,1,1,1,31,102},{0,1,1,1,31,103},{0,1,1,1,31,104},{0,1,1,1,31,108},{0,1,1,1,31,109},{0,1,1,1,31,110},{0,1,1,1,31,112},{0,1,1,1,31,114},{0,1,1,1,31,117},{17,0,0,1,0,31},{18,0,0,1,0,31},{19,0,0,1,0,31},{20,0,0,1,0,31},{21,0,0,1,0,31},{22,0,0,1,0,31},{23,0,0,1,0,31},{24,0,0,1,0,31},{25,0,0,1,0,31},{26,0,0,1,0,31},{27,0,0,1,0,31},{28,0,0,1,0,31},{29,0,0,1,0,31},{30,0,0,1,0,31},{31,0,0,1,0,31},{32,0,0,1,0,31},{33,0,0,1,0,31},{34,1,0,1,0,31},{13,0,1,1,127,48},{14,1,1,1,127,48},{13,0,1,1,127,49},{14,1,1,1,127,49},{13,0,1,1,127,50},{14,1,1,1,127,50},{13,0,1,1,127,97},{14,1,1,1,127,97},{13,0,1,1,127,99},{14,1,1,1,127,99},{13,0,1,1,127,101},{14,1,1,1,127,101},{13,0,1,1,127,105},{14,1,1,1,127,105},{13,0,1,1,127,111},{14,1,1,1,127,111},{13,0,1,1,127,115},{14,1,1,1,127,115},{13,0,1,1,127,116},{14,1,1,1,127,116},{0,1,1,1,127,32},{0,1,1,1,127,37},{0,1,1,1,127,45},{0,1,1,1,127,46},{0,1,1,1,127,47},{0,1,1,1,127,51},{0,1,1,1,127,52},{0,1,1,1,127,53},{0,1,1,1,127,54},{0,1,1,1,127,55},{0,1,1,1,127,56},{0,1,1,1,127,57},{0,1,1,1,127,61},{0,1,1,1,127,65},{0,1,1,1,127,95},{0,1,1,1,127,98},{0,1,1,1,127,100},{0,1,1,1,127,102},{0,1,1,1,127,103},{0,1,1,1,127,104},{0,1,1,1,127,108},{0,1,1,1,127,109},{0,1,1,1,127,110},{0,1,1,1,127,112},{0,1,1,1,127,114},{0,1,1,1,127,117},{17,0,0,1,0,127},{18,0,0,1,0,127},{19,0,0,1,0,127},{20,0,0,1,0,127},{21,0,0,1,0,127},{22,0,0,1,0,127},{23,0,0,1,0,127},{24,0,0,1,0,127},{25,0,0,1,0,127},{26,0,0,1,0,127},{27,0,0,1,0,127},{28,0,0,1,0,127},{29,0,0,1,0,127},{30,0,0,1,0,127},{31,0,0,1,0,127},{32,0,0,1,0,127},{33,0,0,1,0,127},{34,1,0,1,0,127},{13,0,1,1,220,48},{14,1,1,1,220,48},{13,0,1,1,220,49},{14,1,1,1,220,49},{13,0,1,1,220,50},{14,1,1,1,220,50},{13,0,1,1,220,97},{14,1,1,1,220,97},{13,0,1,1,220,99},{14,1,1,1,220,99},{13,0,1,1,220,101},{14,1,1,1,220,101},{13,0,1,1,220,105},{14,1,1,1,220,105},{13,0,1,1,220,111},{14,1,1,1,220,111},{13,0,1,1,220,115},{14,1,1,1,220,115},{13,0,1,1,220,116},{14,1,1,1,220,116},{0,1,1,1,220,32},{0,1,1,1,220,37},{0,1,1,1,220,45},{0,1,1,1,220,46},{0,1,1,1,220,47},{0,1,1,1,220,51},{0,1,1,1,220,52},{0,1,1,1,220,53},{0,1,1,1,220,54},{0,1,1,1,220,55},{0,1,1,1,220,56},{0,1,1,1,220,57},{0,1,1,1,220,61},{0,1,1,1,220,65},{0,1,1,1,220,95},{0,1,1,1,220,98},{0,1,1,1,220,100},{0,1,1,1,220,102},{0,1,1,1,220,103},{0,1,1,1,220,104},{0,1,1,1,220,108},{0,1,1,1,220,109},{0,1,1,1,220,110},{0,1,1,1,220,112},{0,1,1,1,220,114},{0,1,1,1,220,117},{17,0,0,1,0,220},{18,0,0,1,0,220},{19,0,0,1,0,220},{20,0,0,1,0,220},{21,0,0,1,0,220},{22,0,0,1,0,220},{23,0,0,1,0,220},{24,0,0,1,0,220},{25,0,0,1,0,220},{26,0,0,1,0,220},{27,0,0,1,0,220},{28,0,0,1,0,220},{29,0,0,1,0,220},{30,0,0,1,0,220},{31,0,0,1,0,220},{32,0,0,1,0,220},{33,0,0,1,0,220},{34,1,0,1,0,220},{13,0,1,1,249,48},{14,1,1,1,249,48},{13,0,1,1,249,49},{14,1,1,1,249,49},{13,0,1,1,249,50},{14,1,1,1,249,50},{13,0,1,1,249,97},{14,1,1,1,249,97},{13,0,1,1,249,99},{14,1,1,1,249,99},{13,0,1,1,249,101},{14,1,1,1,249,101},{13,0,1,1,249,105},{14,1,1,1,249,105},{13,0,1,1,249,111},{14,1,1,1,249,111},{13,0,1,1,249,115},{14,1,1,1,249,115},{13,0,1,1,249,116},{14,1,1,1,249,116},{0,1,1,1,249,32},{0,1,1,1,249,37},{0,1,1,1,249,45},{0,1,1,1,249,46},{0,1,1,1,249,47},{0,1,1,1,249,51},{0,1,1,1,249,52},{0,1,1,1,249,53},{0,1,1,1,249,54},{0,1,1,1,249,55},{0,1,1,1,249,56},{0,1,1,1,249,57},{0,1,1,1,249,61},{0,1,1,1,249,65},{0,1,1,1,249,95},{0,1,1,1,249,98},{0,1,1,1,249,100},{0,1,1,1,249,102},{0,1,1,1,249,103},{0,1,1,1,249,104},{0,1,1,1,249,108},{0,1,1,1,249,109},{0,1,1,1,249,110},{0,1,1,1,249,112},{0,1,1,1,249,114},{0,1,1,1,249,117},{17,0,0,1,0,249},{18,0,0,1,0,249},{19,0,0,1,0,249},{20,0,0,1,0,249},{21,0,0,1,0,249},{22,0,0,1,0,249},{23,0,0,1,0,249},{24,0,0,1,0,249},{25,0,0,1,0,249},{26,0,0,1,0,249},{27,0,0,1,0,249},{28,0,0,1,0,249},{29,0,0,1,0,249},{30,0,0,1,0,249},{31,0,0,1,0,249},{32,0,0,1,0,249},{33,0,0,1,0,249},{34,1,0,1,0,249},{57,0,0,1,0,10},{58,0,0,1,0,10},{59,0,0,1,0,10},{60,0,0,1,0,10},{61,0,0,1,0,10},{62,0,0,1,0,10},{63,0,0,1,0,10},{64,0,0,1,0,10},{65,0,0,1,0,10},{66,0,0,1,0,10},{67,0,0,1,0,10},{68,0,0,1,0,10},{69,0,0,1,0,10},{70,0,0,1,0,10},{71,0,0,1,0,10},{72,1,0,1,0,10},{57,0,0,1,0,13},{58,0,0,1,0,13},{59,0,0,1,0,13},{60,0,0,1,0,13},{61,0,0,1,0,13},{62,0,0,1,0,13},{63,0,0,1,0,13},{64,0,0,1,0,13},{65,0,0,1,0,13},{66,0,0,1,0,13},{67,0,0,1,0,13},{68,0,0,1,0,13},{69,0,0,1,0,13},{70,0,0,1,0,13},{71,0,0,1,0,13},{72,1,0,1,0,13},{57,0,0,1,0,22},{58,0,0,1,0,22},{59,0,0,1,0,22},{60,0,0,1,0,22},{61,0,0,1,0,22},{62,0,0,1,0,22},{63,0,0,1,0,22},{64,0,0,1,0,22},{65,0,0,1,0,22},{66,0,0,1,0,22},{67,0,0,1,0,22},{68,0,0,1,0,22},{69,0,0,1,0,22},{70,0,0,1,0,22},{71,0,0,1,0,22},{72,1,0,1,0,22},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,0,0,0,0},{242,0,