// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef node_inspector_protocol_Network_h
#define node_inspector_protocol_Network_h

#include "src/node/inspector/protocol/Protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "src/node/inspector/protocol/Runtime.h"

namespace node {
namespace inspector {
namespace protocol {
namespace Network {
using ResourceType = String;
using RequestId = String;
using TimeSinceEpoch = double;
using MonotonicTime = double;
class Initiator;
class Request;
class Response;
using Headers = Object;
class LoadNetworkResourcePageResult;
class WebSocketResponse;

// ------------- Forward and enum declarations.

namespace ResourceTypeEnum {
 extern const char Document[];
 extern const char Stylesheet[];
 extern const char Image[];
 extern const char Media[];
 extern const char Font[];
 extern const char Script[];
 extern const char TextTrack[];
 extern const char XHR[];
 extern const char Fetch[];
 extern const char Prefetch[];
 extern const char EventSource[];
 extern const char WebSocket[];
 extern const char Manifest[];
 extern const char SignedExchange[];
 extern const char Ping[];
 extern const char CSPViolationReport[];
 extern const char Preflight[];
 extern const char Other[];
} // namespace ResourceTypeEnum

// ------------- Type and builder declarations.

class  Initiator : public ::crdtp::ProtocolObject<Initiator> {
public:
    ~Initiator() override { }

    struct  TypeEnum {
        static const char* Parser;
        static const char* Script;
        static const char* Preload;
        static const char* SignedExchange;
        static const char* Preflight;
        static const char* Other;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value) { m_type = value; }

    bool hasStack() { return !!m_stack; }
    v8_inspector::protocol::Runtime::API::StackTrace* getStack(v8_inspector::protocol::Runtime::API::StackTrace* defaultValue) {
       return m_stack ? m_stack.get() : defaultValue;
    }
    const std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace>& getStack() const {
       return m_stack;
    }
    void setStack(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value) { m_stack = std::move(value); }

    bool hasUrl() { return !!m_url; }
    String getUrl(const String& defaultValue) const {
       return m_url.value_or(defaultValue);
    }
    const std::optional<String>& getUrl() const {
       return m_url;
    }
    void setUrl(const String& value) { m_url = value; }

    bool hasLineNumber() { return !!m_lineNumber; }
    double getLineNumber(double defaultValue) const {
       return m_lineNumber.value_or(defaultValue);
    }
    const std::optional<double>& getLineNumber() const {
       return m_lineNumber;
    }
    void setLineNumber(double value) { m_lineNumber = value; }

    bool hasColumnNumber() { return !!m_columnNumber; }
    double getColumnNumber(double defaultValue) const {
       return m_columnNumber.value_or(defaultValue);
    }
    const std::optional<double>& getColumnNumber() const {
       return m_columnNumber;
    }
    void setColumnNumber(double value) { m_columnNumber = value; }

    bool hasRequestId() { return !!m_requestId; }
    String getRequestId(const String& defaultValue) const {
       return m_requestId.value_or(defaultValue);
    }
    const std::optional<String>& getRequestId() const {
       return m_requestId;
    }
    void setRequestId(const String& value) { m_requestId = value; }

    template<int STATE>
    class InitiatorBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            AllFieldsSet = (TypeSet | 0)};


        InitiatorBuilder<STATE | TypeSet>& setType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->setType(value);
            return castState<TypeSet>();
        }

        InitiatorBuilder<STATE>& setStack(std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> value)
        {
            m_result->setStack(std::move(value));
            return *this;
        }

        InitiatorBuilder<STATE>& setUrl(const String& value)
        {
            m_result->setUrl(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setLineNumber(double value)
        {
            m_result->setLineNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setColumnNumber(double value)
        {
            m_result->setColumnNumber(value);
            return *this;
        }

        InitiatorBuilder<STATE>& setRequestId(const String& value)
        {
            m_result->setRequestId(value);
            return *this;
        }

        std::unique_ptr<Initiator> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Initiator;
        InitiatorBuilder() : m_result(new Initiator()) { }

        template<int STEP> InitiatorBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<InitiatorBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Initiator> m_result;
    };

    static InitiatorBuilder<0> create()
    {
        return InitiatorBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Initiator()
    {
    }

    String m_type;
    std::unique_ptr<v8_inspector::protocol::Runtime::API::StackTrace> m_stack;
    std::optional<String> m_url;
    std::optional<double> m_lineNumber;
    std::optional<double> m_columnNumber;
    std::optional<String> m_requestId;
};


class  Request : public ::crdtp::ProtocolObject<Request> {
public:
    ~Request() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    String getMethod() { return m_method; }
    void setMethod(const String& value) { m_method = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    bool getHasPostData() { return m_hasPostData; }
    void setHasPostData(bool value) { m_hasPostData = value; }

    template<int STATE>
    class RequestBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            MethodSet = 1 << 2,
            HeadersSet = 1 << 3,
            HasPostDataSet = 1 << 4,
            AllFieldsSet = (UrlSet | MethodSet | HeadersSet | HasPostDataSet | 0)};


        RequestBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        RequestBuilder<STATE | MethodSet>& setMethod(const String& value)
        {
            static_assert(!(STATE & MethodSet), "property method should not be set yet");
            m_result->setMethod(value);
            return castState<MethodSet>();
        }

        RequestBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        RequestBuilder<STATE | HasPostDataSet>& setHasPostData(bool value)
        {
            static_assert(!(STATE & HasPostDataSet), "property hasPostData should not be set yet");
            m_result->setHasPostData(value);
            return castState<HasPostDataSet>();
        }

        std::unique_ptr<Request> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Request;
        RequestBuilder() : m_result(new Request()) { }

        template<int STEP> RequestBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RequestBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Request> m_result;
    };

    static RequestBuilder<0> create()
    {
        return RequestBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Request()
    {
          m_hasPostData = false;
    }

    String m_url;
    String m_method;
    std::unique_ptr<protocol::Network::Headers> m_headers;
    bool m_hasPostData;
};


class  Response : public ::crdtp::ProtocolObject<Response> {
public:
    ~Response() override { }

    String getUrl() { return m_url; }
    void setUrl(const String& value) { m_url = value; }

    int getStatus() { return m_status; }
    void setStatus(int value) { m_status = value; }

    String getStatusText() { return m_statusText; }
    void setStatusText(const String& value) { m_statusText = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    String getMimeType() { return m_mimeType; }
    void setMimeType(const String& value) { m_mimeType = value; }

    String getCharset() { return m_charset; }
    void setCharset(const String& value) { m_charset = value; }

    template<int STATE>
    class ResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            UrlSet = 1 << 1,
            StatusSet = 1 << 2,
            StatusTextSet = 1 << 3,
            HeadersSet = 1 << 4,
            MimeTypeSet = 1 << 5,
            CharsetSet = 1 << 6,
            AllFieldsSet = (UrlSet | StatusSet | StatusTextSet | HeadersSet | MimeTypeSet | CharsetSet | 0)};


        ResponseBuilder<STATE | UrlSet>& setUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->setUrl(value);
            return castState<UrlSet>();
        }

        ResponseBuilder<STATE | StatusSet>& setStatus(int value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        ResponseBuilder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText should not be set yet");
            m_result->setStatusText(value);
            return castState<StatusTextSet>();
        }

        ResponseBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        ResponseBuilder<STATE | MimeTypeSet>& setMimeType(const String& value)
        {
            static_assert(!(STATE & MimeTypeSet), "property mimeType should not be set yet");
            m_result->setMimeType(value);
            return castState<MimeTypeSet>();
        }

        ResponseBuilder<STATE | CharsetSet>& setCharset(const String& value)
        {
            static_assert(!(STATE & CharsetSet), "property charset should not be set yet");
            m_result->setCharset(value);
            return castState<CharsetSet>();
        }

        std::unique_ptr<Response> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Response;
        ResponseBuilder() : m_result(new Response()) { }

        template<int STEP> ResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::Response> m_result;
    };

    static ResponseBuilder<0> create()
    {
        return ResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Response()
    {
          m_status = 0;
    }

    String m_url;
    int m_status;
    String m_statusText;
    std::unique_ptr<protocol::Network::Headers> m_headers;
    String m_mimeType;
    String m_charset;
};


class  LoadNetworkResourcePageResult : public ::crdtp::ProtocolObject<LoadNetworkResourcePageResult> {
public:
    ~LoadNetworkResourcePageResult() override { }

    bool getSuccess() { return m_success; }
    void setSuccess(bool value) { m_success = value; }

    bool hasStream() { return !!m_stream; }
    String getStream(const String& defaultValue) const {
       return m_stream.value_or(defaultValue);
    }
    const std::optional<String>& getStream() const {
       return m_stream;
    }
    void setStream(const String& value) { m_stream = value; }

    template<int STATE>
    class LoadNetworkResourcePageResultBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            SuccessSet = 1 << 1,
            AllFieldsSet = (SuccessSet | 0)};


        LoadNetworkResourcePageResultBuilder<STATE | SuccessSet>& setSuccess(bool value)
        {
            static_assert(!(STATE & SuccessSet), "property success should not be set yet");
            m_result->setSuccess(value);
            return castState<SuccessSet>();
        }

        LoadNetworkResourcePageResultBuilder<STATE>& setStream(const String& value)
        {
            m_result->setStream(value);
            return *this;
        }

        std::unique_ptr<LoadNetworkResourcePageResult> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class LoadNetworkResourcePageResult;
        LoadNetworkResourcePageResultBuilder() : m_result(new LoadNetworkResourcePageResult()) { }

        template<int STEP> LoadNetworkResourcePageResultBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LoadNetworkResourcePageResultBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::LoadNetworkResourcePageResult> m_result;
    };

    static LoadNetworkResourcePageResultBuilder<0> create()
    {
        return LoadNetworkResourcePageResultBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    LoadNetworkResourcePageResult()
    {
          m_success = false;
    }

    bool m_success;
    std::optional<String> m_stream;
};


class  WebSocketResponse : public ::crdtp::ProtocolObject<WebSocketResponse> {
public:
    ~WebSocketResponse() override { }

    int getStatus() { return m_status; }
    void setStatus(int value) { m_status = value; }

    String getStatusText() { return m_statusText; }
    void setStatusText(const String& value) { m_statusText = value; }

    protocol::Network::Headers* getHeaders() { return m_headers.get(); }
    void setHeaders(std::unique_ptr<protocol::Network::Headers> value) { m_headers = std::move(value); }

    template<int STATE>
    class WebSocketResponseBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StatusSet = 1 << 1,
            StatusTextSet = 1 << 2,
            HeadersSet = 1 << 3,
            AllFieldsSet = (StatusSet | StatusTextSet | HeadersSet | 0)};


        WebSocketResponseBuilder<STATE | StatusSet>& setStatus(int value)
        {
            static_assert(!(STATE & StatusSet), "property status should not be set yet");
            m_result->setStatus(value);
            return castState<StatusSet>();
        }

        WebSocketResponseBuilder<STATE | StatusTextSet>& setStatusText(const String& value)
        {
            static_assert(!(STATE & StatusTextSet), "property statusText should not be set yet");
            m_result->setStatusText(value);
            return castState<StatusTextSet>();
        }

        WebSocketResponseBuilder<STATE | HeadersSet>& setHeaders(std::unique_ptr<protocol::Network::Headers> value)
        {
            static_assert(!(STATE & HeadersSet), "property headers should not be set yet");
            m_result->setHeaders(std::move(value));
            return castState<HeadersSet>();
        }

        std::unique_ptr<WebSocketResponse> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class WebSocketResponse;
        WebSocketResponseBuilder() : m_result(new WebSocketResponse()) { }

        template<int STEP> WebSocketResponseBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<WebSocketResponseBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Network::WebSocketResponse> m_result;
    };

    static WebSocketResponseBuilder<0> create()
    {
        return WebSocketResponseBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    WebSocketResponse()
    {
          m_status = 0;
    }

    int m_status;
    String m_statusText;
    std::unique_ptr<protocol::Network::Headers> m_headers;
};


// ------------- Backend interface.

class  Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable(std::optional<int> in_maxTotalBufferSize, std::optional<int> in_maxResourceBufferSize) = 0;
    virtual DispatchResponse getRequestPostData(const String& in_requestId, String* out_postData) = 0;
    virtual DispatchResponse getResponseBody(const String& in_requestId, String* out_body, bool* out_base64Encoded) = 0;
    virtual DispatchResponse streamResourceContent(const String& in_requestId, Binary* out_bufferedData) = 0;
    virtual DispatchResponse loadNetworkResource(const String& in_url, std::unique_ptr<protocol::Network::LoadNetworkResourcePageResult>* out_resource) = 0;

};

// ------------- Frontend interface.

class  Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void requestWillBeSent(const String& requestId, std::unique_ptr<protocol::Network::Request> request, std::unique_ptr<protocol::Network::Initiator> initiator, double timestamp, double wallTime);
    void responseReceived(const String& requestId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response);
    void loadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText);
    void loadingFinished(const String& requestId, double timestamp);
    void dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength, std::optional<Binary> data = {});
    void webSocketCreated(const String& requestId, const String& url, std::unique_ptr<protocol::Network::Initiator> initiator);
    void webSocketClosed(const String& requestId, double timestamp);
    void webSocketHandshakeResponseReceived(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketResponse> response);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class  Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class  Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Network
} // namespace node
} // namespace inspector
} // namespace protocol

#endif // !defined(node_inspector_protocol_Network_h)
