use crate::gobject_models::GCategoryID;
use crate::main_window::MainWindow;
use glib::{Object, Properties, prelude::*, subclass::*};
use gtk4::{Accessible, Buildable, CompositeTemplate, ConstraintTarget, Widget, subclass::prelude::*};
use libadwaita::{Dialog, subclass::prelude::*};
use news_flash::models::Category;
use std::cell::RefCell;

mod imp {
    use super::*;
    #[derive(Debug, Default, CompositeTemplate, Properties)]
    #[properties(wrapper_type = super::EditCategoryDialog)]
    #[template(file = "data/resources/ui_templates/edit_dialogs/category.blp")]
    pub struct EditCategoryDialog {
        #[property(get, set, name = "category-id")]
        pub category_id: RefCell<GCategoryID>,

        #[property(get, set, name = "category-name")]
        pub category_name: RefCell<String>,
    }

    #[glib::object_subclass]
    impl ObjectSubclass for EditCategoryDialog {
        const NAME: &'static str = "EditCategoryDialog";
        type Type = super::EditCategoryDialog;
        type ParentType = Dialog;

        fn class_init(klass: &mut Self::Class) {
            klass.bind_template();
            klass.bind_template_callbacks();
        }

        fn instance_init(obj: &InitializingObject<Self>) {
            obj.init_template();
        }
    }

    #[glib::derived_properties]
    impl ObjectImpl for EditCategoryDialog {}

    impl WidgetImpl for EditCategoryDialog {}

    impl AdwDialogImpl for EditCategoryDialog {}

    #[gtk4::template_callbacks]
    impl EditCategoryDialog {
        #[template_callback]
        fn on_name_apply(&self) {
            let category_id = self.category_id.borrow().as_ref().as_str().to_string();
            let new_title = self.category_name.borrow().clone();
            MainWindow::activate_action("rename-category", Some(&(category_id, new_title).to_variant()));
        }
    }
}

glib::wrapper! {
    pub struct EditCategoryDialog(ObjectSubclass<imp::EditCategoryDialog>)
        @extends Widget, Dialog,
        @implements Accessible, Buildable, ConstraintTarget;
}

impl EditCategoryDialog {
    pub fn new(category: Category) -> Self {
        let category_id: GCategoryID = category.category_id.into();

        Object::builder()
            .property("category-id", category_id)
            .property("category-name", &category.label)
            .build()
    }
}
