{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Glyph paint callbacks.
-- 
-- The callbacks assume that the caller maintains a stack
-- of current transforms, clips and intermediate surfaces,
-- as evidenced by the pairs of push\/pop callbacks. The
-- push\/pop calls will be properly nested, so it is fine
-- to store the different kinds of object on a single stack.
-- 
-- Not all callbacks are required for all kinds of glyphs.
-- For rendering COLRv0 or non-color outline glyphs, the
-- gradient callbacks are not needed, and the composite
-- callback only needs to handle simple alpha compositing
-- (@/HB_PAINT_COMPOSITE_MODE_SRC_OVER/@).
-- 
-- The paint-image callback is only needed for glyphs
-- with image blobs in the CBDT, sbix or SVG tables.
-- 
-- The custom-palette-color callback is only necessary if
-- you want to override colors from the font palette with
-- custom colors.
-- 
-- /Since: 7.0.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.PaintFuncsT
    ( 

-- * Exported types
    PaintFuncsT(..)                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolvePaintFuncsTMethod                ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype PaintFuncsT = PaintFuncsT (SP.ManagedPtr PaintFuncsT)
    deriving (Eq)

instance SP.ManagedPtrNewtype PaintFuncsT where
    toManagedPtr (PaintFuncsT p) = p

foreign import ccall "hb_gobject_paint_funcs_get_type" c_hb_gobject_paint_funcs_get_type :: 
    IO GType

type instance O.ParentTypes PaintFuncsT = '[]
instance O.HasParentTypes PaintFuncsT

instance B.Types.TypedObject PaintFuncsT where
    glibType = c_hb_gobject_paint_funcs_get_type

instance B.Types.GBoxed PaintFuncsT

-- | Convert t'PaintFuncsT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PaintFuncsT) where
    gvalueGType_ = c_hb_gobject_paint_funcs_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr PaintFuncsT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr PaintFuncsT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed PaintFuncsT ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PaintFuncsT
type instance O.AttributeList PaintFuncsT = PaintFuncsTAttributeList
type PaintFuncsTAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePaintFuncsTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePaintFuncsTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePaintFuncsTMethod t PaintFuncsT, O.OverloadedMethod info PaintFuncsT p) => OL.IsLabel t (PaintFuncsT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePaintFuncsTMethod t PaintFuncsT, O.OverloadedMethod info PaintFuncsT p, R.HasField t PaintFuncsT p) => R.HasField t PaintFuncsT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePaintFuncsTMethod t PaintFuncsT, O.OverloadedMethodInfo info PaintFuncsT) => OL.IsLabel t (O.MethodProxy info PaintFuncsT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


