/* do not edit automatically generated by mc from SymbolTable.  */
/* SymbolTable.mod provides access to the symbol table.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _SymbolTable_C

#include "GSymbolTable.h"
#   include "GSYSTEM.h"
#   include "GStorage.h"
#   include "GM2Debug.h"
#   include "Glibc.h"
#   include "GASCII.h"
#   include "GIndexing.h"
#   include "GSets.h"
#   include "Ggcctypes.h"
#   include "GM2Options.h"
#   include "GM2LexBuf.h"
#   include "GM2ALU.h"
#   include "GM2Error.h"
#   include "GM2MetaError.h"
#   include "GFormatStrings.h"
#   include "GM2Printf.h"
#   include "GDynamicStrings.h"
#   include "GLists.h"
#   include "GNameKey.h"
#   include "GSymbolKey.h"
#   include "GM2Base.h"
#   include "GM2System.h"
#   include "Gm2expr.h"
#   include "Gm2linemap.h"
#   include "GStrLib.h"
#   include "Gm2builtins.h"
#   include "GM2Comp.h"
#   include "GM2Scaffold.h"
#   include "GM2SymInit.h"
#   include "GM2RTS.h"

#   define SymbolTable_NulSym 0
typedef struct SymbolTable_FamilyOperation_p SymbolTable_FamilyOperation;

#   define DebugUnknowns false
#   define DebugUnknownToken false
#   define UnboundedAddressName "_m2_contents"
#   define UnboundedHighName "_m2_high_%d"
typedef struct SymbolTable_ProcAnyBoolean_p SymbolTable_ProcAnyBoolean;

typedef struct SymbolTable_ProcAnyCardinal_p SymbolTable_ProcAnyCardinal;

typedef struct SymbolTable_LRLists_a SymbolTable_LRLists;

typedef struct SymbolTable_LRInitDesc_a SymbolTable_LRInitDesc;

typedef struct SymbolTable_Where_r SymbolTable_Where;

typedef struct SymbolTable_VarDecl_r SymbolTable_VarDecl;

typedef struct SymbolTable_PackedInfo_r SymbolTable_PackedInfo;

typedef struct SymbolTable_ModuleCtor_r SymbolTable_ModuleCtor;

typedef struct SymbolTable_SymImportStatement_r SymbolTable_SymImportStatement;

typedef struct SymbolTable_SymImport_r SymbolTable_SymImport;

typedef struct SymbolTable_SymEquiv_r SymbolTable_SymEquiv;

typedef struct SymbolTable_SymOAFamily_r SymbolTable_SymOAFamily;

typedef struct SymbolTable_SymTuple_r SymbolTable_SymTuple;

typedef struct SymbolTable_SymError_r SymbolTable_SymError;

typedef struct SymbolTable_SymObject_r SymbolTable_SymObject;

typedef struct SymbolTable_SymUndefined_r SymbolTable_SymUndefined;

typedef struct SymbolTable_SymGnuAsm_r SymbolTable_SymGnuAsm;

typedef struct SymbolTable_SymInterface_r SymbolTable_SymInterface;

typedef struct SymbolTable_SymVarient_r SymbolTable_SymVarient;

typedef struct SymbolTable_SymRecord_r SymbolTable_SymRecord;

typedef struct SymbolTable_SymSubrange_r SymbolTable_SymSubrange;

typedef struct SymbolTable_SymEnumeration_r SymbolTable_SymEnumeration;

typedef struct SymbolTable_SymArray_r SymbolTable_SymArray;

typedef struct SymbolTable_SymSubscript_r SymbolTable_SymSubscript;

typedef struct SymbolTable_SymUnbounded_r SymbolTable_SymUnbounded;

typedef struct SymbolTable_SymPartialUnbounded_r SymbolTable_SymPartialUnbounded;

typedef struct SymbolTable_ProcedureDeclaration_r SymbolTable_ProcedureDeclaration;

typedef struct SymbolTable_SymProcedure_r SymbolTable_SymProcedure;

typedef struct SymbolTable_SymProcType_r SymbolTable_SymProcType;

typedef struct SymbolTable_SymParam_r SymbolTable_SymParam;

typedef struct SymbolTable_SymVarParam_r SymbolTable_SymVarParam;

typedef struct SymbolTable_SymConstString_r SymbolTable_SymConstString;

typedef struct SymbolTable_SymConstLit_r SymbolTable_SymConstLit;

typedef struct SymbolTable_SymConstVar_r SymbolTable_SymConstVar;

typedef struct SymbolTable_SymVar_r SymbolTable_SymVar;

typedef struct SymbolTable_SymType_r SymbolTable_SymType;

typedef struct SymbolTable_SymPointer_r SymbolTable_SymPointer;

typedef struct SymbolTable_SymRecordField_r SymbolTable_SymRecordField;

typedef struct SymbolTable_SymVarientField_r SymbolTable_SymVarientField;

typedef struct SymbolTable_SymEnumerationField_r SymbolTable_SymEnumerationField;

typedef struct SymbolTable_SymSet_r SymbolTable_SymSet;

typedef struct SymbolTable_SymDefImp_r SymbolTable_SymDefImp;

typedef struct SymbolTable_SymModule_r SymbolTable_SymModule;

typedef struct SymbolTable_SymDummy_r SymbolTable_SymDummy;

typedef struct SymbolTable_Symbol_r SymbolTable_Symbol;

typedef struct SymbolTable_CallFrame_r SymbolTable_CallFrame;

typedef struct SymbolTable_CheckProcedure_p SymbolTable_CheckProcedure;

typedef SymbolTable_Symbol *SymbolTable_PtrToSymbol;

typedef SymbolTable_CallFrame *SymbolTable_PtrToCallFrame;

typedef struct SymbolTable__T4_r SymbolTable__T4;

typedef SymbolTable__T4 *SymbolTable_ConstLitPoolEntry;

typedef struct SymbolTable__T5_r SymbolTable__T5;

typedef SymbolTable__T5 *SymbolTable_PtrToAsmConstraint;

typedef struct SymbolTable__T6_a SymbolTable__T6;

typedef enum {SymbolTable_m2str, SymbolTable_cstr, SymbolTable_m2nulstr, SymbolTable_cnulstr} SymbolTable_ConstStringVariant;

typedef enum {SymbolTable_RecordSym, SymbolTable_VarientSym, SymbolTable_DummySym, SymbolTable_VarSym, SymbolTable_EnumerationSym, SymbolTable_SubrangeSym, SymbolTable_ArraySym, SymbolTable_ConstStringSym, SymbolTable_ConstVarSym, SymbolTable_ConstLitSym, SymbolTable_VarParamSym, SymbolTable_ParamSym, SymbolTable_PointerSym, SymbolTable_UndefinedSym, SymbolTable_TypeSym, SymbolTable_RecordFieldSym, SymbolTable_VarientFieldSym, SymbolTable_EnumerationFieldSym, SymbolTable_DefImpSym, SymbolTable_ModuleSym, SymbolTable_SetSym, SymbolTable_ProcedureSym, SymbolTable_ProcTypeSym, SymbolTable_SubscriptSym, SymbolTable_UnboundedSym, SymbolTable_GnuAsmSym, SymbolTable_InterfaceSym, SymbolTable_ObjectSym, SymbolTable_PartialUnboundedSym, SymbolTable_TupleSym, SymbolTable_OAFamilySym, SymbolTable_ImportSym, SymbolTable_ImportStatementSym, SymbolTable_EquivSym, SymbolTable_ErrorSym} SymbolTable_TypeOfSymbol;

typedef bool (*SymbolTable_ProcAnyBoolean_t) (unsigned int, SymbolTable_ProcedureKind);
struct SymbolTable_ProcAnyBoolean_p { SymbolTable_ProcAnyBoolean_t proc; };

typedef unsigned int (*SymbolTable_ProcAnyCardinal_t) (unsigned int, SymbolTable_ProcedureKind);
struct SymbolTable_ProcAnyCardinal_p { SymbolTable_ProcAnyCardinal_t proc; };

struct SymbolTable_LRLists_a { Lists_List array[SymbolTable_LeftValue-SymbolTable_RightValue+1]; };
struct SymbolTable_LRInitDesc_a { M2SymInit_InitDesc array[SymbolTable_LeftValue-SymbolTable_RightValue+1]; };
struct SymbolTable_Where_r {
                             unsigned int DefDeclared;
                             unsigned int FirstUsed;
                             unsigned int ModDeclared;
                           };

struct SymbolTable_VarDecl_r {
                               unsigned int FullTok;
                               unsigned int VarTok;
                               unsigned int TypeTok;
                             };

struct SymbolTable_PackedInfo_r {
                                  bool IsPacked;
                                  unsigned int PackedEquiv;
                                };

struct SymbolTable_ModuleCtor_r {
                                  unsigned int ctor;
                                  unsigned int init;
                                  unsigned int fini;
                                  unsigned int dep;
                                };

struct SymbolTable_SymOAFamily_r {
                                   unsigned int MaxDimensions;
                                   unsigned int SimpleType;
                                   Indexing_Index Dimensions;
                                 };

struct SymbolTable_SymPartialUnbounded_r {
                                           unsigned int Type;
                                           unsigned int NDim;
                                         };

struct SymbolTable_ProcedureDeclaration_r {
                                            Lists_List ListOfParam;
                                            bool Defined;
                                            bool ParamDefined;
                                            bool HasVarArgs;
                                            bool HasOptArg;
                                            bool IsNoReturn;
                                            bool ReturnOptional;
                                            unsigned int ReturnTypeTok;
                                            unsigned int ProcedureTok;
                                          };

struct SymbolTable_SymParam_r {
                                NameKey_Name name;
                                unsigned int Type;
                                bool IsUnbounded;
                                unsigned int Scope;
                                unsigned int ShadowVar;
                                unsigned int FullTok;
                                unsigned int At;
                              };

struct SymbolTable_SymVarParam_r {
                                   NameKey_Name name;
                                   unsigned int Type;
                                   bool IsUnbounded;
                                   unsigned int HeapVar;
                                   unsigned int Scope;
                                   unsigned int ShadowVar;
                                   unsigned int FullTok;
                                   unsigned int At;
                                 };

struct SymbolTable_SymDummy_r {
                                unsigned int NextFree;
                              };

struct SymbolTable_CallFrame_r {
                                 unsigned int Main;
                                 unsigned int Search;
                                 unsigned int Start;
                               };

typedef void (*SymbolTable_CheckProcedure_t) (unsigned int);
struct SymbolTable_CheckProcedure_p { SymbolTable_CheckProcedure_t proc; };

struct SymbolTable__T4_r {
                           unsigned int sym;
                           unsigned int tok;
                           NameKey_Name constName;
                           unsigned int constType;
                           SymbolTable_ConstLitPoolEntry next;
                         };

struct SymbolTable__T5_r {
                           unsigned int tokpos;
                           NameKey_Name name;
                           unsigned int str;
                           unsigned int obj;
                         };

struct SymbolTable_SymImportStatement_r {
                                          unsigned int listNo;
                                          Lists_List ListOfImports;
                                          SymbolTable_Where at;
                                        };

struct SymbolTable_SymImport_r {
                                 unsigned int module;
                                 unsigned int listNo;
                                 bool qualified;
                                 SymbolTable_Where at;
                               };

struct SymbolTable_SymEquiv_r {
                                SymbolTable_PackedInfo packedInfo;
                                unsigned int nonPacked;
                              };

struct SymbolTable_SymTuple_r {
                                SymbolTable_Where At;
                                unsigned int nTuple;
                                Indexing_Index list;
                              };

struct SymbolTable_SymError_r {
                                NameKey_Name name;
                                unsigned int Scope;
                                SymbolTable_Where At;
                              };

struct SymbolTable_SymObject_r {
                                 NameKey_Name name;
                                 SymbolTable_Where At;
                               };

struct SymbolTable_SymUndefined_r {
                                    NameKey_Name name;
                                    unsigned int oafamily;
                                    M2Error_ErrorScope errorScope;
                                    SymbolTable_Where At;
                                  };

struct SymbolTable_SymGnuAsm_r {
                                 unsigned int String;
                                 SymbolTable_Where At;
                                 unsigned int Inputs;
                                 unsigned int Outputs;
                                 unsigned int Trashed;
                                 bool Volatile;
                                 bool Simple;
                               };

struct SymbolTable_SymInterface_r {
                                    Indexing_Index Parameters;
                                    SymbolTable_Where At;
                                  };

struct SymbolTable_SymVarient_r {
                                  M2ALU_PtrToValue Size;
                                  Lists_List ListOfSons;
                                  bool DeclPacked;
                                  bool DeclResolved;
                                  unsigned int Parent;
                                  unsigned int Varient;
                                  unsigned int tag;
                                  unsigned int Scope;
                                  SymbolTable_Where At;
                                };

struct SymbolTable_SymRecord_r {
                                 NameKey_Name name;
                                 SymbolKey_SymbolTree LocalSymbols;
                                 M2ALU_PtrToValue Size;
                                 Lists_List ListOfSons;
                                 unsigned int Align;
                                 unsigned int DefaultAlign;
                                 bool DeclPacked;
                                 bool DeclResolved;
                                 unsigned int oafamily;
                                 unsigned int Parent;
                                 unsigned int Scope;
                                 SymbolTable_Where At;
                               };

struct SymbolTable_SymSubrange_r {
                                   NameKey_Name name;
                                   unsigned int Low;
                                   unsigned int High;
                                   M2ALU_PtrToValue Size;
                                   unsigned int Type;
                                   unsigned int Align;
                                   SymbolKey_SymbolTree ConstLitTree;
                                   SymbolTable_PackedInfo packedInfo;
                                   unsigned int oafamily;
                                   unsigned int Scope;
                                   SymbolTable_Where At;
                                 };

struct SymbolTable_SymEnumeration_r {
                                      NameKey_Name name;
                                      unsigned int NoOfElements;
                                      SymbolKey_SymbolTree LocalSymbols;
                                      Lists_List ListOfFields;
                                      M2ALU_PtrToValue Size;
                                      SymbolTable_PackedInfo packedInfo;
                                      unsigned int oafamily;
                                      unsigned int Scope;
                                      SymbolTable_Where At;
                                    };

struct SymbolTable_SymArray_r {
                                NameKey_Name name;
                                unsigned int Subscript;
                                M2ALU_PtrToValue Size;
                                M2ALU_PtrToValue Offset;
                                unsigned int Type;
                                unsigned int Align;
                                bool Large;
                                unsigned int oafamily;
                                unsigned int Scope;
                                SymbolTable_Where At;
                              };

struct SymbolTable_SymSubscript_r {
                                    unsigned int Type;
                                    M2ALU_PtrToValue Size;
                                    M2ALU_PtrToValue Offset;
                                    SymbolTable_Where At;
                                  };

struct SymbolTable_SymUnbounded_r {
                                    unsigned int Type;
                                    M2ALU_PtrToValue Size;
                                    unsigned int RecordType;
                                    unsigned int Dimensions;
                                    unsigned int Scope;
                                    SymbolTable_Where At;
                                  };

struct SymbolTable_SymProcType_r {
                                   NameKey_Name name;
                                   Lists_List ListOfParam;
                                   bool HasVarArgs;
                                   bool HasOptArg;
                                   unsigned int OptArgInit;
                                   unsigned int ReturnType;
                                   bool ReturnOptional;
                                   unsigned int ReturnTypeTok;
                                   unsigned int Scope;
                                   M2ALU_PtrToValue Size;
                                   M2ALU_PtrToValue TotalParamSize;
                                   unsigned int oafamily;
                                   SymbolTable_Where At;
                                 };

struct SymbolTable_SymConstString_r {
                                      NameKey_Name name;
                                      NameKey_Name Contents;
                                      unsigned int Length;
                                      SymbolTable_ConstStringVariant StringVariant;
                                      bool Known;
                                      unsigned int Scope;
                                      SymbolTable_Where At;
                                    };

struct SymbolTable_SymConstLit_r {
                                   NameKey_Name name;
                                   M2ALU_PtrToValue Value;
                                   unsigned int Type;
                                   bool IsSet;
                                   bool IsConstructor;
                                   bool IsInternal;
                                   unsigned int FromType;
                                   bool RangeError;
                                   bool UnresFromType;
                                   unsigned int Scope;
                                   SymbolTable_Where At;
                                 };

struct SymbolTable_SymConstVar_r {
                                   NameKey_Name name;
                                   M2ALU_PtrToValue Value;
                                   unsigned int Type;
                                   bool IsConditional;
                                   bool IsSet;
                                   bool IsConstructor;
                                   unsigned int FromType;
                                   bool UnresFromType;
                                   bool IsTemp;
                                   unsigned int Scope;
                                   SymbolTable_Where At;
                                 };

struct SymbolTable_SymVar_r {
                              NameKey_Name name;
                              unsigned int Type;
                              unsigned int BackType;
                              M2ALU_PtrToValue Size;
                              M2ALU_PtrToValue Offset;
                              SymbolTable_ModeOfAddr AddrMode;
                              unsigned int Scope;
                              bool AtAddress;
                              unsigned int Address;
                              bool IsComponentRef;
                              Indexing_Index list;
                              bool IsConditional;
                              bool IsTemp;
                              bool IsParam;
                              bool IsPointerCheck;
                              bool IsWritten;
                              bool IsSSA;
                              bool IsConst;
                              bool ArrayRef;
                              bool Heap;
                              SymbolTable_LRInitDesc InitState;
                              SymbolTable_VarDecl Declared;
                              SymbolTable_Where At;
                              SymbolTable_LRLists ReadUsageList;
                              SymbolTable_LRLists WriteUsageList;
                            };

struct SymbolTable_SymType_r {
                               NameKey_Name name;
                               unsigned int Type;
                               bool IsHidden;
                               SymbolKey_SymbolTree ConstLitTree;
                               M2ALU_PtrToValue Size;
                               SymbolTable_PackedInfo packedInfo;
                               unsigned int oafamily;
                               unsigned int Align;
                               unsigned int Scope;
                               SymbolTable_Where At;
                             };

struct SymbolTable_SymPointer_r {
                                  NameKey_Name name;
                                  unsigned int Type;
                                  M2ALU_PtrToValue Size;
                                  unsigned int Align;
                                  SymbolKey_SymbolTree ConstLitTree;
                                  unsigned int oafamily;
                                  unsigned int Scope;
                                  SymbolTable_Where At;
                                };

struct SymbolTable_SymRecordField_r {
                                      NameKey_Name name;
                                      unsigned int Type;
                                      bool Tag;
                                      M2ALU_PtrToValue Size;
                                      M2ALU_PtrToValue Offset;
                                      unsigned int Parent;
                                      unsigned int Varient;
                                      unsigned int Align;
                                      bool Used;
                                      bool DeclPacked;
                                      bool DeclResolved;
                                      unsigned int Scope;
                                      SymbolTable_Where At;
                                    };

struct SymbolTable_SymVarientField_r {
                                       NameKey_Name name;
                                       M2ALU_PtrToValue Size;
                                       M2ALU_PtrToValue Offset;
                                       unsigned int Parent;
                                       unsigned int Varient;
                                       Lists_List ListOfSons;
                                       bool DeclPacked;
                                       bool DeclResolved;
                                       unsigned int Scope;
                                       SymbolTable_Where At;
                                     };

struct SymbolTable_SymEnumerationField_r {
                                           NameKey_Name name;
                                           M2ALU_PtrToValue Value;
                                           unsigned int Type;
                                           unsigned int Scope;
                                           SymbolTable_Where At;
                                         };

struct SymbolTable_SymSet_r {
                              NameKey_Name name;
                              unsigned int Type;
                              SymbolTable_PackedInfo packedInfo;
                              bool ispacked;
                              M2ALU_PtrToValue Size;
                              unsigned int oafamily;
                              unsigned int Scope;
                              SymbolTable_Where At;
                            };

struct SymbolTable_SymDefImp_r {
                                 NameKey_Name name;
                                 NameKey_Name libname;
                                 SymbolTable_ModuleCtor ctors;
                                 Lists_List DefListOfDep;
                                 Lists_List ModListOfDep;
                                 SymbolKey_SymbolTree ExportQualifiedTree;
                                 SymbolKey_SymbolTree ExportUnQualifiedTree;
                                 SymbolKey_SymbolTree ExportRequest;
                                 Lists_List IncludeList;
                                 Lists_List DefIncludeList;
                                 SymbolKey_SymbolTree ImportTree;
                                 SymbolKey_SymbolTree ExportUndeclared;
                                 SymbolKey_SymbolTree NeedToBeImplemented;
                                 SymbolKey_SymbolTree LocalSymbols;
                                 Lists_List EnumerationScopeList;
                                 SymbolKey_SymbolTree NamedObjects;
                                 SymbolKey_SymbolTree NamedImports;
                                 SymbolKey_SymbolTree WhereImported;
                                 unsigned int Priority;
                                 SymbolKey_SymbolTree Unresolved;
                                 unsigned int StartQuad;
                                 unsigned int EndQuad;
                                 unsigned int StartFinishQuad;
                                 unsigned int EndFinishQuad;
                                 tree FinallyFunction;
                                 bool ExceptionFinally;
                                 bool ExceptionBlock;
                                 bool ContainsHiddenType;
                                 bool ContainsBuiltin;
                                 bool ForC;
                                 bool NeedExportList;
                                 bool ModLink;
                                 bool DefLink;
                                 bool Builtin;
                                 Lists_List ListOfVars;
                                 Lists_List ListOfProcs;
                                 Lists_List ListOfModules;
                                 M2Error_ErrorScope errorScope;
                                 SymbolTable_Where At;
                               };

struct SymbolTable_SymModule_r {
                                 NameKey_Name name;
                                 NameKey_Name libname;
                                 SymbolTable_ModuleCtor ctors;
                                 Lists_List ModListOfDep;
                                 SymbolKey_SymbolTree LocalSymbols;
                                 SymbolKey_SymbolTree ExportTree;
                                 Lists_List IncludeList;
                                 SymbolKey_SymbolTree ImportTree;
                                 SymbolKey_SymbolTree ExportUndeclared;
                                 Lists_List EnumerationScopeList;
                                 SymbolKey_SymbolTree NamedObjects;
                                 SymbolKey_SymbolTree NamedImports;
                                 SymbolKey_SymbolTree WhereImported;
                                 unsigned int Scope;
                                 unsigned int Priority;
                                 SymbolKey_SymbolTree Unresolved;
                                 unsigned int StartQuad;
                                 unsigned int EndQuad;
                                 unsigned int StartFinishQuad;
                                 unsigned int EndFinishQuad;
                                 tree FinallyFunction;
                                 bool ExceptionFinally;
                                 bool ExceptionBlock;
                                 bool ModLink;
                                 bool Builtin;
                                 Lists_List ListOfVars;
                                 Lists_List ListOfProcs;
                                 Lists_List ListOfModules;
                                 M2Error_ErrorScope errorScope;
                                 SymbolTable_Where At;
                               };

struct SymbolTable__T6_a { SymbolTable_ProcedureDeclaration array[SymbolTable_DefProcedure-SymbolTable_ProperProcedure+1]; };
struct SymbolTable_SymProcedure_r {
                                    NameKey_Name name;
                                    SymbolTable__T6 Decl;
                                    unsigned int OptArgInit;
                                    bool IsExtern;
                                    bool IsPublic;
                                    bool IsCtor;
                                    bool IsMonoName;
                                    bool BuildProcType;
                                    SymbolKey_SymbolTree Unresolved;
                                    unsigned int ScopeQuad;
                                    unsigned int StartQuad;
                                    unsigned int EndQuad;
                                    bool Reachable;
                                    bool SavePriority;
                                    unsigned int ReturnType;
                                    unsigned int ProcedureType;
                                    bool IsBuiltin;
                                    NameKey_Name BuiltinName;
                                    bool IsInline;
                                    SymbolKey_SymbolTree LocalSymbols;
                                    Lists_List EnumerationScopeList;
                                    Lists_List ListOfVars;
                                    Lists_List ListOfProcs;
                                    SymbolKey_SymbolTree NamedObjects;
                                    M2ALU_PtrToValue Size;
                                    M2ALU_PtrToValue TotalParamSize;
                                    bool ExceptionFinally;
                                    bool ExceptionBlock;
                                    unsigned int Scope;
                                    M2Error_ErrorScope errorScope;
                                    Lists_List ListOfModules;
                                    unsigned int Begin;
                                    unsigned int End;
                                    SymbolTable_Where At;
                                  };

struct SymbolTable_Symbol_r {
                              SymbolTable_TypeOfSymbol SymbolType;  /* case tag */
                              union {
                                      SymbolTable_SymOAFamily OAFamily;
                                      SymbolTable_SymObject Object;
                                      SymbolTable_SymEquiv Equiv;
                                      SymbolTable_SymRecord Record;
                                      SymbolTable_SymVarient Varient;
                                      SymbolTable_SymVar Var;
                                      SymbolTable_SymEnumeration Enumeration;
                                      SymbolTable_SymSubrange Subrange;
                                      SymbolTable_SymSubscript Subscript;
                                      SymbolTable_SymArray Array;
                                      SymbolTable_SymUnbounded Unbounded;
                                      SymbolTable_SymPartialUnbounded PartialUnbounded;
                                      SymbolTable_SymConstVar ConstVar;
                                      SymbolTable_SymConstLit ConstLit;
                                      SymbolTable_SymConstString ConstString;
                                      SymbolTable_SymVarParam VarParam;
                                      SymbolTable_SymParam Param;
                                      SymbolTable_SymError Error;
                                      SymbolTable_SymUndefined Undefined;
                                      SymbolTable_SymType Type;
                                      SymbolTable_SymPointer Pointer;
                                      SymbolTable_SymRecordField RecordField;
                                      SymbolTable_SymVarientField VarientField;
                                      SymbolTable_SymEnumerationField EnumerationField;
                                      SymbolTable_SymDefImp DefImp;
                                      SymbolTable_SymModule Module;
                                      SymbolTable_SymSet Set;
                                      SymbolTable_SymProcedure Procedure;
                                      SymbolTable_SymProcType ProcType;
                                      SymbolTable_SymImportStatement ImportStatement;
                                      SymbolTable_SymImport Import;
                                      SymbolTable_SymGnuAsm GnuAsm;
                                      SymbolTable_SymInterface Interface;
                                      SymbolTable_SymTuple Tuple;
                                      SymbolTable_SymDummy Dummy;
                                    };
                            };

static Indexing_Index Symbols;
static Indexing_Index ScopeCallFrame;
static unsigned int FreeSymbol;
static SymbolKey_SymbolTree DefModuleTree;
static SymbolKey_SymbolTree ModuleTree;
static unsigned int CurrentModule;
static unsigned int MainModule;
static unsigned int FileModule;
static unsigned int ScopePtr;
static unsigned int BaseScopePtr;
static unsigned int BaseModule;
static unsigned int TemporaryNo;
static M2Error_Error CurrentError;
static Lists_List AddressTypes;
static Lists_List UnresolvedConstructorType;
static unsigned int AnonymousName;
static Sets_Set ReportedUnknowns;
static SymbolKey_SymbolTree ConstLitPoolTree;
static Indexing_Index ConstLitArray;
static unsigned int BreakSym;
static unsigned int recordConsist;
static DynamicStrings_String ListifySentance;
static unsigned int ListifyTotal;
static unsigned int ListifyWordCount;
static unsigned int ExportRequestModule;
static unsigned int ResolveModule;

/*
   FinalSymbol - returns the highest number symbol used.
*/

extern "C" unsigned int SymbolTable_FinalSymbol (void);

/*
   MakeComponentRecord - make a temporary which will be used to reference and field
                         (or sub field) of record.
*/

extern "C" unsigned int SymbolTable_MakeComponentRecord (unsigned int tok, SymbolTable_ModeOfAddr Mode, unsigned int record);

/*
   MakeComponentRef - use, sym, to reference, field, sym is returned.
*/

extern "C" unsigned int SymbolTable_MakeComponentRef (unsigned int sym, unsigned int field);

/*
   IsComponent - returns TRUE if symbol, sym, is a temporary and a component
                 reference.
*/

extern "C" bool SymbolTable_IsComponent (unsigned int sym);

/*
   MakeTemporary - Makes a new temporary variable at the highest real scope.
                   The addressing mode of the temporary is set to NoValue.
*/

extern "C" unsigned int SymbolTable_MakeTemporary (unsigned int tok, SymbolTable_ModeOfAddr Mode);

/*
   MakeTemporaryFromExpression - makes a new temporary variable at the
                                 highest real scope.  The addressing
                                 mode of the temporary is set and the
                                 type is determined by expressions, e.
*/

extern "C" unsigned int SymbolTable_MakeTemporaryFromExpression (unsigned int tok, unsigned int e, SymbolTable_ModeOfAddr mode);

/*
   MakeTemporaryFromExpressions - makes a new temporary variable at the
                                  highest real scope.  The addressing
                                  mode of the temporary is set and the
                                  type is determined by expressions,
                                  e1 and e2.
*/

extern "C" unsigned int SymbolTable_MakeTemporaryFromExpressions (unsigned int tok, unsigned int e1, unsigned int e2, SymbolTable_ModeOfAddr mode);

/*
   PutMode - Puts the addressing mode, SymMode, into symbol Sym.
             The mode may only be altered if the mode
             is None.
*/

extern "C" void SymbolTable_PutMode (unsigned int Sym, SymbolTable_ModeOfAddr SymMode);

/*
   GetMode - Returns the addressing mode of a symbol.
*/

extern "C" SymbolTable_ModeOfAddr SymbolTable_GetMode (unsigned int Sym);

/*
   StartScope - starts a block scope at Sym. Transparent determines
                whether the search for a symbol will look at the
                previous ScopeCallFrame if Sym does not contain the
                symbol that GetSym is searching.

                WITH statements are partially implemented by calling
                StartScope. Therefore we must retain the old Main from
                the previous ScopePtr when a record is added to the scope
                stack. (Main contains the symbol where all identifiers
                should be added.)
*/

extern "C" void SymbolTable_StartScope (unsigned int Sym);

/*
   EndScope - ends a block scope started by StartScope. The current
              head of the symbol scope reverts back to the symbol
              which was the Head of the symbol scope before the
              last StartScope was called.
*/

extern "C" void SymbolTable_EndScope (void);

/*
   PseudoScope - starts a pseudo scope at Sym.
                 We always connect parent up to the last scope,
                 to determine the transparancy of a scope we call
                 TransparentScope.

                 A Pseudo scope has no end block,
                 but is terminated when the next EndScope is used.
                 The function of the pseudo scope is to provide an
                 automatic mechanism to solve enumeration types.
                 A declared enumeration type is a Pseudo scope and
                 identifiers used with the name of an enumeration
                 type field will find the enumeration symbol by
                 the scoping algorithm.
*/

extern "C" void SymbolTable_PseudoScope (unsigned int Sym);

/*
   GetCurrentScope - returns the symbol who is responsible for the current
                     scope. Note that it ignore pseudo scopes.
*/

extern "C" unsigned int SymbolTable_GetCurrentScope (void);

/*
   IsDeclaredIn - returns TRUE if a symbol was declared in, scope.
*/

extern "C" bool SymbolTable_IsDeclaredIn (unsigned int scope, unsigned int sym);

/*
   SetCurrentModule - Used to set the CurrentModule to a symbol, Sym.
                      This Sym must represent the module name of the
                      file currently being compiled.
*/

extern "C" void SymbolTable_SetCurrentModule (unsigned int Sym);

/*
   SetFileModule - Used to set the FileModule to a symbol, Sym.
                   This Sym must represent the current program module
                   file which is being parsed.
*/

extern "C" void SymbolTable_SetFileModule (unsigned int Sym);

/*
   SetMainModule - Used to set the MainModule to a symbol, Sym.
                   This Sym must represent the main module which was
                   envoked by the user to be compiled.
*/

extern "C" void SymbolTable_SetMainModule (unsigned int Sym);

/*
   CheckAnonymous - checks to see whether the name is NulName and if so
                    it creates a unique anonymous name.
*/

extern "C" NameKey_Name SymbolTable_CheckAnonymous (NameKey_Name name);

/*
   IsNameAnonymous - returns TRUE if the symbol, sym, has an anonymous name
                     or no name.
*/

extern "C" bool SymbolTable_IsNameAnonymous (unsigned int sym);

/*
   NoOfVariables - returns the number of variables in scope.  The scope maybe
                   a procedure, module or defimp scope.
*/

extern "C" unsigned int SymbolTable_NoOfVariables (unsigned int scope);

/*
   MakeModule - creates a module sym with ModuleName. It returns the
                symbol index.
*/

extern "C" unsigned int SymbolTable_MakeModule (unsigned int tok, NameKey_Name ModuleName);

/*
   MakeDefImp - creates a definition and implementation module sym
                with name DefImpName.  It returns the symbol index.
*/

extern "C" unsigned int SymbolTable_MakeDefImp (unsigned int tok, NameKey_Name DefImpName);

/*
   MakeInnerModule - creates an inner module sym with ModuleName. It returns the
                     symbol index.
*/

extern "C" unsigned int SymbolTable_MakeInnerModule (unsigned int tok, NameKey_Name ModuleName);

/*
   MakeProcedure - creates a procedure sym with name. It returns
                   the symbol index.
*/

extern "C" unsigned int SymbolTable_MakeProcedure (unsigned int tok, NameKey_Name ProcedureName);

/*
   MakeProcedureCtorExtern - creates an extern ctor procedure
*/

extern "C" unsigned int SymbolTable_MakeProcedureCtorExtern (unsigned int tokenno, NameKey_Name libname, NameKey_Name modulename);

/*
   PutLibName - places libname into defimp or module sym.
*/

extern "C" void SymbolTable_PutLibName (unsigned int sym, NameKey_Name libname);

/*
   GetLibName - returns libname associated with a defimp or module sym.
*/

extern "C" NameKey_Name SymbolTable_GetLibName (unsigned int sym);

/*
   PutMonoName - changes the IsMonoName boolean inside the procedure.
*/

extern "C" void SymbolTable_PutMonoName (unsigned int sym, bool value);

/*
   IsMonoName - returns the public boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsMonoName (unsigned int sym);

/*
   PutExtern - changes the extern boolean inside the procedure.
*/

extern "C" void SymbolTable_PutExtern (unsigned int sym, bool value);

/*
   IsExtern - returns the public boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsExtern (unsigned int sym);

/*
   PutPublic - changes the public boolean inside the procedure.
*/

extern "C" void SymbolTable_PutPublic (unsigned int sym, bool value);

/*
   IsPublic - returns the public boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsPublic (unsigned int sym);

/*
   PutCtor - changes the ctor boolean inside the procedure.
*/

extern "C" void SymbolTable_PutCtor (unsigned int sym, bool value);

/*
   IsCtor - returns the ctor boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsCtor (unsigned int sym);

/*
   GetModuleCtors - mod can be a DefImp or Module symbol.  ctor, init and fini
                    are assigned for this module.  An inner module ctor value will
                    be NulSym.
*/

extern "C" void SymbolTable_GetModuleCtors (unsigned int mod, unsigned int *ctor, unsigned int *init, unsigned int *fini, unsigned int *dep);

/*
   MakeModuleCtor - for a defimp or module symbol create all the ctor
                    related procedures.
*/

extern "C" void SymbolTable_MakeModuleCtor (unsigned int moduleTok, unsigned int beginTok, unsigned int finallyTok, unsigned int moduleSym);

/*
   PutModuleCtorExtern - for every ctor related procedure in module sym.
                         Make it external.  It will create any missing
                         init/fini procedures but not any missing dep/ctor
                         procedures.
*/

extern "C" void SymbolTable_PutModuleCtorExtern (unsigned int tok, unsigned int sym, bool external);

/*
   PutVarHeap - assigns ArrayRef field with value.
*/

extern "C" void SymbolTable_PutVarHeap (unsigned int sym, bool value);

/*
   IsVarHeap - returns ArrayRef field value.
*/

extern "C" bool SymbolTable_IsVarHeap (unsigned int sym);

/*
   MakeVar - creates a variable sym with VarName. It returns the
             symbol index.
*/

extern "C" unsigned int SymbolTable_MakeVar (unsigned int tok, NameKey_Name VarName);

/*
   PutVarConditional - assign IsConditional to value.
*/

extern "C" void SymbolTable_PutVarConditional (unsigned int sym, bool value);

/*
   IsVarConditional - return TRUE if the symbol is a var symbol
                      containing the result of a boolean conditional.
*/

extern "C" bool SymbolTable_IsVarConditional (unsigned int sym);

/*
   MakeRecord - makes a Record symbol with name RecordName.
*/

extern "C" unsigned int SymbolTable_MakeRecord (unsigned int tok, NameKey_Name RecordName);

/*
   MakeVarient - creates a new symbol, a varient symbol for record or varient field
                 symbol, RecOrVarFieldSym.
*/

extern "C" unsigned int SymbolTable_MakeVarient (unsigned int tok, unsigned int RecOrVarFieldSym);

/*
   MakeFieldVarient - returns a FieldVarient symbol which has been
                      assigned to the Varient symbol, Sym.
*/

extern "C" unsigned int SymbolTable_MakeFieldVarient (NameKey_Name n, unsigned int Sym);

/*
   MakeEnumeration - places a new symbol in the current scope, the symbol
                     is an enumeration symbol. The symbol index is returned.
*/

extern "C" unsigned int SymbolTable_MakeEnumeration (unsigned int tok, NameKey_Name EnumerationName);

/*
   MakeType - makes a type symbol with name TypeName.
*/

extern "C" unsigned int SymbolTable_MakeType (unsigned int tok, NameKey_Name TypeName);

/*
   MakeHiddenType - makes a type symbol that is hidden from the
                    definition module.
                    This symbol is placed into the UnImplemented list of
                    the definition/implementation module.
                    The type will be filled in when the implementation module
                    is reached.
*/

extern "C" unsigned int SymbolTable_MakeHiddenType (unsigned int tok, NameKey_Name TypeName);

/*
   MakeConstant - create a constant cardinal and return the symbol.
*/

extern "C" unsigned int SymbolTable_MakeConstant (unsigned int tok, unsigned int value);

/*
   MakeConstLit - returns a constant literal of type, constType, with a constName,
                  at location, tok.
*/

extern "C" unsigned int SymbolTable_MakeConstLit (unsigned int tok, NameKey_Name constName, unsigned int constType);

/*
   MakeConstVar - makes a ConstVar type with
                  name ConstVarName.
*/

extern "C" unsigned int SymbolTable_MakeConstVar (unsigned int tok, NameKey_Name ConstVarName);

/*
   MakeConstString - create a string constant in the symboltable.
*/

extern "C" unsigned int SymbolTable_MakeConstString (unsigned int tok, NameKey_Name ConstName);

/*
   MakeConstStringCnul - creates a constant string nul terminated string suitable for C.
                         If known is TRUE then name is assigned to the contents
                         and the escape sequences will be converted into characters.
*/

extern "C" unsigned int SymbolTable_MakeConstStringCnul (unsigned int tok, NameKey_Name name, bool known);

/*
   MakeConstStringM2nul - creates a constant string nul terminated string suitable for M2.
                          If known is TRUE then name is assigned to the contents
                          however the escape sequences are not converted into characters.
*/

extern "C" unsigned int SymbolTable_MakeConstStringM2nul (unsigned int tok, NameKey_Name name, bool known);

/*
   PutConstStringKnown - if sym is a constvar then convert it into a conststring.
                         If known is FALSE then contents is ignored and NulName is
                         stored.  If escape is TRUE then the contents will have
                         any escape sequences converted into single characters.
*/

extern "C" void SymbolTable_PutConstStringKnown (unsigned int tok, unsigned int sym, NameKey_Name contents, bool escape, bool known);

/*
   CopyConstString - copies string contents from expr to des
                     and retain the kind of string.
*/

extern "C" void SymbolTable_CopyConstString (unsigned int tok, unsigned int des, unsigned int expr);

/*
   IsConstStringKnown - returns TRUE if sym is a const string
                        and the contents are known.
*/

extern "C" bool SymbolTable_IsConstStringKnown (unsigned int sym);

/*
   IsConstStringM2 - returns whether this conststring is a
                     Modula-2 string.
*/

extern "C" bool SymbolTable_IsConstStringM2 (unsigned int sym);

/*
   IsConstStringC - returns whether this conststring is a C style string
                    which will have any escape translated.
*/

extern "C" bool SymbolTable_IsConstStringC (unsigned int sym);

/*
   IsConstStringM2nul - returns whether this conststring is a Modula-2 string which
                        contains a nul terminator.
*/

extern "C" bool SymbolTable_IsConstStringM2nul (unsigned int sym);

/*
   IsConstStringCnul - returns whether this conststring is a C style string
                       which will have any escape translated and also contains
                       a nul terminator.
*/

extern "C" bool SymbolTable_IsConstStringCnul (unsigned int sym);

/*
   MakeSubrange - makes a new symbol into a subrange type with
                  name SubrangeName.
*/

extern "C" unsigned int SymbolTable_MakeSubrange (unsigned int tok, NameKey_Name SubrangeName);

/*
   MakeSet - makes a set Symbol with name, SetName.
*/

extern "C" unsigned int SymbolTable_MakeSet (unsigned int tok, NameKey_Name SetName);

/*
   MakeArray - makes an Array symbol with name ArrayName.
*/

extern "C" unsigned int SymbolTable_MakeArray (unsigned int tok, NameKey_Name ArrayName);

/*
   PutArrayLarge - indicates that this is a large array in which case
                   the interface to gcc maps this array from 0..high-low,
                   using an integer indice.
*/

extern "C" void SymbolTable_PutArrayLarge (unsigned int array);

/*
   IsArrayLarge - returns TRUE if we need to treat this as a large array.
*/

extern "C" bool SymbolTable_IsArrayLarge (unsigned int array);

/*
   PutPriority - places a interrupt, priority, value into module, module.
*/

extern "C" void SymbolTable_PutPriority (unsigned int module, unsigned int priority);

/*
   GetPriority - returns the interrupt priority which was assigned to
                 module, module.
*/

extern "C" unsigned int SymbolTable_GetPriority (unsigned int module);

/*
   PutNeedSavePriority - set a boolean flag indicating that this procedure
                         needs to save and restore interrupts.
*/

extern "C" void SymbolTable_PutNeedSavePriority (unsigned int sym);

/*
   GetNeedSavePriority - returns the boolean flag indicating whether this procedure
                         needs to save and restore interrupts.
*/

extern "C" bool SymbolTable_GetNeedSavePriority (unsigned int sym);

/*
   PutVariableAtAddress - determines that a variable, sym, is declared at
                          a specific address.
*/

extern "C" void SymbolTable_PutVariableAtAddress (unsigned int sym, unsigned int address);

/*
   GetVariableAtAddress - returns the address at which variable, sym, is declared.
*/

extern "C" unsigned int SymbolTable_GetVariableAtAddress (unsigned int sym);

/*
   IsVariableAtAddress - returns TRUE if a variable, sym, was declared at
                         a specific address.
*/

extern "C" bool SymbolTable_IsVariableAtAddress (unsigned int sym);

/*
   PutVariableSSA - assigns value to the SSA field within variable sym.
*/

extern "C" void SymbolTable_PutVariableSSA (unsigned int sym, bool value);

/*
   IsVariableSSA - returns TRUE if variable is known to be a SSA.
*/

extern "C" bool SymbolTable_IsVariableSSA (unsigned int sym);

/*
   PutVarConst - sets the IsConst field to value indicating the variable is read only.
*/

extern "C" void SymbolTable_PutVarConst (unsigned int sym, bool value);

/*
   MakeGnuAsm - create a GnuAsm symbol.
*/

extern "C" unsigned int SymbolTable_MakeGnuAsm (void);

/*
   PutGnuAsm - places the instruction textual name into the GnuAsm symbol.
*/

extern "C" void SymbolTable_PutGnuAsm (unsigned int sym, unsigned int string);

/*
   PutGnuAsmOutput - places the interface object, out, into GnuAsm symbol, sym.
*/

extern "C" void SymbolTable_PutGnuAsmOutput (unsigned int sym, unsigned int out);

/*
   PutGnuAsmInput - places the interface object, in, into GnuAsm symbol, sym.
*/

extern "C" void SymbolTable_PutGnuAsmInput (unsigned int sym, unsigned int in);

/*
   PutGnuAsmTrash - places the interface object, trash, into GnuAsm symbol, sym.
*/

extern "C" void SymbolTable_PutGnuAsmTrash (unsigned int sym, unsigned int trash);

/*
   GetGnuAsm - returns the string symbol, representing the instruction textual
               of the GnuAsm symbol. It will return a ConstString.
*/

extern "C" unsigned int SymbolTable_GetGnuAsm (unsigned int sym);

/*
   GetGnuAsmInput - returns the input list of registers.
*/

extern "C" unsigned int SymbolTable_GetGnuAsmInput (unsigned int sym);

/*
   GetGnuAsmOutput - returns the output list of registers.
*/

extern "C" unsigned int SymbolTable_GetGnuAsmOutput (unsigned int sym);

/*
   GetGnuAsmTrash - returns the list of trashed registers.
*/

extern "C" unsigned int SymbolTable_GetGnuAsmTrash (unsigned int sym);

/*
   PutGnuAsmVolatile - defines a GnuAsm symbol as VOLATILE.
*/

extern "C" void SymbolTable_PutGnuAsmVolatile (unsigned int Sym);

/*
   PutGnuAsmSimple - defines a GnuAsm symbol as a simple kind.
*/

extern "C" void SymbolTable_PutGnuAsmSimple (unsigned int Sym);

/*
   MakeRegInterface - creates and returns a register interface symbol.
*/

extern "C" unsigned int SymbolTable_MakeRegInterface (void);

/*
   PutRegInterface - places a, name, string, and, object, into the interface array,
                     sym, at position, i.
                     The string symbol will either be a register name or a constraint.
                     The object is an optional Modula-2 variable or constant symbol.
                     read and write are the quadruple numbers representing any read
                     or write operation.
*/

extern "C" void SymbolTable_PutRegInterface (unsigned int tok, unsigned int sym, unsigned int i, NameKey_Name n, unsigned int string, unsigned int object, unsigned int read_, unsigned int write_);

/*
   GetRegInterface - gets a, name, string, and, object, from the interface array,
                     sym, from position, i.
*/

extern "C" void SymbolTable_GetRegInterface (unsigned int sym, unsigned int i, unsigned int *tok, NameKey_Name *n, unsigned int *string, unsigned int *object);

/*
   GetModule - Returns the Module symbol for the module with name, name.
*/

extern "C" unsigned int SymbolTable_GetModule (NameKey_Name name);

/*
   GetCurrentModule - returns the current module Sym that is being
                      compiled.
*/

extern "C" unsigned int SymbolTable_GetCurrentModule (void);

/*
   GetFileModule - returns the FileModule symbol that was requested by
                   the user to be compiled.
*/

extern "C" unsigned int SymbolTable_GetFileModule (void);

/*
   GetBaseModule - returns the base module symbol that contains Modula-2
                   base types, procedures and functions.
*/

extern "C" unsigned int SymbolTable_GetBaseModule (void);

/*
   GetMainModule - returns the main module symbol that was requested by
                   the user to be compiled.
*/

extern "C" unsigned int SymbolTable_GetMainModule (void);

/*
   GetCurrentModuleScope - returns the module symbol which forms the
                           current (possibly inner most) module.
*/

extern "C" unsigned int SymbolTable_GetCurrentModuleScope (void);

/*
   GetLastModuleScope - returns the last module scope encountered,
                        the module scope before the Current Module Scope.
*/

extern "C" unsigned int SymbolTable_GetLastModuleScope (void);

/*
   AddSymToModuleScope - adds a symbol, Sym, to the scope of the module
                         ModSym.
*/

extern "C" void SymbolTable_AddSymToModuleScope (unsigned int ModSym, unsigned int Sym);

/*
   GetType - Returns the symbol that is the TYPE symbol to Sym.
             If zero is returned then we assume type unknown.
*/

extern "C" unsigned int SymbolTable_GetType (unsigned int Sym);

/*
   SkipType - if sym is a TYPE foo = bar
              then call SkipType(bar)
              else return sym

              it does not skip over hidden types.
*/

extern "C" unsigned int SymbolTable_SkipType (unsigned int Sym);

/*
   SkipTypeAndSubrange - if sym is a TYPE foo = bar OR
                            sym is declared as a subrange of bar
                         then call SkipTypeAndSubrange(bar)
                         else return sym

                         it does not skip over hidden types.
*/

extern "C" unsigned int SymbolTable_SkipTypeAndSubrange (unsigned int Sym);

/*
   GetLowestType - Returns the lowest type in the type chain of
                   symbol Sym.
                   If NulSym is returned then we assume type unknown or
                   you have reqested the type of a base type.
*/

extern "C" unsigned int SymbolTable_GetLowestType (unsigned int Sym);

/*
   GetLType - get lowest type.  It returns the lowest type
              of symbol, sym.  It skips over type equivalences.
              It will not skip over base types.
*/

extern "C" unsigned int SymbolTable_GetLType (unsigned int sym);

/*
   GetSType - get source type.  It returns the type closest
              to the object.  It does not skip over type
              equivalences.  It will skip over base types.
*/

extern "C" unsigned int SymbolTable_GetSType (unsigned int sym);

/*
   GetDType - get gcc declared type.  It returns the type
              of the object which is declared to GCC.
              It does skip over type equivalences but only
              if they do not contain a user alignment.
              It does not skip over hidden types.
              It does not skip over base types.
*/

extern "C" unsigned int SymbolTable_GetDType (unsigned int sym);

/*
   GetTypeMode - return the type of sym, it returns Address is the
                 symbol is a LValue.
*/

extern "C" unsigned int SymbolTable_GetTypeMode (unsigned int sym);

/*
   GetSym - searches the current scope (and previous scopes if the
            scope tranparent allows) for a symbol with name.
*/

extern "C" unsigned int SymbolTable_GetSym (NameKey_Name name);

/*
   GetDeclareSym - searches for a symbol with a name SymName in the
                   current and previous scopes.
                   If the symbol is found then it is returned
                   else an unknown symbol is returned.
                   This procedure assumes that SymName is being
                   declared at this point and therefore it does
                   not examine the base scope (for pervasive
                   identifiers).
*/

extern "C" unsigned int SymbolTable_GetDeclareSym (unsigned int tok, NameKey_Name SymName);

/*
   GetLocalSym - only searches the scope Sym for a symbol with name
                 and returns the index to the symbol.
*/

extern "C" unsigned int SymbolTable_GetLocalSym (unsigned int Sym, NameKey_Name name);

/*
   GetRecord - fetches the record symbol from the parent of Sym.
               Sym maybe a varient symbol in which case its parent is searched
               etc.
*/

extern "C" unsigned int SymbolTable_GetRecord (unsigned int Sym);

/*
   FromModuleGetSym - attempts to find a symbol of name, n, in the
                      module, mod, scope.  An unknown symbol is created
                      at token position tok if necessary.
*/

extern "C" unsigned int SymbolTable_FromModuleGetSym (unsigned int tok, NameKey_Name n, unsigned int mod);

/*
   GetNth - returns the n th symbol in the list associated with the scope
            of Sym.  Sym may be a Module, DefImp, Procedure, Record or
            Enumeration symbol.
*/

extern "C" unsigned int SymbolTable_GetNth (unsigned int Sym, unsigned int n);

/*
   GetNthParam - returns the n th parameter of a procedure Sym.
*/

extern "C" unsigned int SymbolTable_GetNthParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo);

/*
   GetVarScope - returns the symbol which is the scope of variable Sym.
                 ie a Module, DefImp or Procedure Symbol.
*/

extern "C" unsigned int SymbolTable_GetVarScope (unsigned int Sym);

/*
   GetSubrange - returns HighSym and LowSym - two constants which make up the
                 subrange.
*/

extern "C" void SymbolTable_GetSubrange (unsigned int Sym, unsigned int *HighSym, unsigned int *LowSym);

/*
   GetParam - returns the ParamNo parameter from procedure ProcSym
*/

extern "C" unsigned int SymbolTable_GetParam (unsigned int Sym, unsigned int ParamNo);

/*
   GetString - returns the contents of the string symbol sym, note that
               this is not the same as GetName (unless it was a literal).
*/

extern "C" NameKey_Name SymbolTable_GetString (unsigned int Sym);

/*
   GetStringLength - returns the length of the string symbol Sym.
*/

extern "C" unsigned int SymbolTable_GetStringLength (unsigned int tok, unsigned int sym);

/*
   GetProcedureBuiltin - returns the builtin name for the equivalent procedure, Sym.
*/

extern "C" NameKey_Name SymbolTable_GetProcedureBuiltin (unsigned int Sym);

/*
   PutProcedureBuiltin - assigns the builtin name for the equivalent procedure, Sym.
*/

extern "C" void SymbolTable_PutProcedureBuiltin (unsigned int Sym, NameKey_Name name);

/*
   IsProcedureBuiltin - returns TRUE if this procedure has a builtin equivalent.
*/

extern "C" bool SymbolTable_IsProcedureBuiltin (unsigned int Sym);

/*
   PutProcedureInline - determines that procedure, Sym, has been requested to be inlined.
*/

extern "C" void SymbolTable_PutProcedureInline (unsigned int Sym);
extern "C" bool SymbolTable_IsProcedureInline (unsigned int Sym);

/*
   PutExceptionBlock - sets a BOOLEAN in block module/procedure/defimp,
                       sym, indicating that this block as an EXCEPT
                       statement sequence.
*/

extern "C" void SymbolTable_PutExceptionBlock (unsigned int sym);

/*
   HasExceptionBlock - returns a BOOLEAN determining whether
                       module/procedure/defimp, sym, has
                       an EXCEPT statement sequence.
*/

extern "C" bool SymbolTable_HasExceptionBlock (unsigned int sym);

/*
   PutExceptionFinally - sets a BOOLEAN in block module/defimp,
                         sym, indicating that this FINALLY block
                         as an EXCEPT statement sequence.
*/

extern "C" void SymbolTable_PutExceptionFinally (unsigned int sym);

/*
   HasExceptionFinally - returns a BOOLEAN determining whether
                         module/defimp, sym, has
                         an EXCEPT statement sequence.
*/

extern "C" bool SymbolTable_HasExceptionFinally (unsigned int sym);

/*
   PutVar - gives the VarSym symbol Sym a type Type.
*/

extern "C" void SymbolTable_PutVar (unsigned int Sym, unsigned int VarType);

/*
   PutVarTok - gives the VarSym symbol Sym a type Type at typetok.
*/

extern "C" void SymbolTable_PutVarTok (unsigned int Sym, unsigned int VarType, unsigned int typetok);

/*
   PutLeftValueFrontBackType - gives the variable symbol a front and backend type.
                               The variable must be a LeftValue.
*/

extern "C" void SymbolTable_PutLeftValueFrontBackType (unsigned int Sym, unsigned int FrontType, unsigned int BackType);

/*
   GetVarBackEndType - returns the back end type if specified.
*/

extern "C" unsigned int SymbolTable_GetVarBackEndType (unsigned int Sym);

/*
   PutVarPointerCheck - marks variable, sym, as requiring (or not
                        depending upon the, value), a NIL pointer check
                        when this symbol is dereferenced.
*/

extern "C" void SymbolTable_PutVarPointerCheck (unsigned int sym, bool value);

/*
   GetVarPointerCheck - returns TRUE if this symbol is a variable and
                        has been marked as needing a pointer via NIL check.
*/

extern "C" bool SymbolTable_GetVarPointerCheck (unsigned int sym);

/*
   PutVarWritten - marks variable, sym, as being written to (or not
                   depending upon the, value).
*/

extern "C" void SymbolTable_PutVarWritten (unsigned int sym, bool value);

/*
   GetVarWritten - returns TRUE if this symbol is a variable and
                   has been marked as being written.
*/

extern "C" bool SymbolTable_GetVarWritten (unsigned int sym);

/*
   PutConst - gives the constant symbol Sym a type ConstType.
*/

extern "C" void SymbolTable_PutConst (unsigned int Sym, unsigned int ConstType);

/*
   PutConstSet - informs the const var symbol, sym, that it is or will contain
                 a set value.
*/

extern "C" void SymbolTable_PutConstSet (unsigned int Sym);

/*
   IsConstSet - returns TRUE if the constant is declared as a set.
*/

extern "C" bool SymbolTable_IsConstSet (unsigned int Sym);

/*
   PutConstructor - informs the const var symbol, sym, that it is or
                    will contain a constructor (record, set or array)
                    value.
*/

extern "C" void SymbolTable_PutConstructor (unsigned int Sym);

/*
   PutConstructorFrom - sets the from type field in constructor,
                        Sym, to, from.
*/

extern "C" void SymbolTable_PutConstructorFrom (unsigned int Sym, unsigned int from);

/*
   PutFieldRecord - places a field, FieldName and FieldType into a record, Sym.
                    VarSym is a optional varient symbol which can be returned
                    by a call to GetVarient(fieldsymbol).  The created field
                    is returned.
*/

extern "C" unsigned int SymbolTable_PutFieldRecord (unsigned int Sym, NameKey_Name FieldName, unsigned int FieldType, unsigned int VarSym);

/*
   PutFieldVarient - places the field varient, Field, as a brother to, the
                     varient symbol, sym, and also tells Field that its varient
                     parent is Sym.
*/

extern "C" void SymbolTable_PutFieldVarient (unsigned int Field, unsigned int Sym);

/*
   GetVarient - returns the varient symbol associated with the
                record or varient field symbol, Field.
*/

extern "C" unsigned int SymbolTable_GetVarient (unsigned int Field);

/*
   IsRecordFieldAVarientTag - returns TRUE if record field, sym, is
                              a varient tag.
*/

extern "C" bool SymbolTable_IsRecordFieldAVarientTag (unsigned int sym);

/*
   IsEmptyFieldVarient - returns TRUE if the field variant has
                         no fields.  This will occur then the
                         compiler constructs 'else end' variants.
*/

extern "C" bool SymbolTable_IsEmptyFieldVarient (unsigned int sym);

/*
   GetVarientTag - returns the varient tag from, Sym.
*/

extern "C" unsigned int SymbolTable_GetVarientTag (unsigned int Sym);

/*
   PutVarientTag - places, Tag, into varient, Sym.
*/

extern "C" void SymbolTable_PutVarientTag (unsigned int Sym, unsigned int Tag);

/*
   PutFieldEnumeration - places a field into the enumeration type
                         Sym. The field has a name FieldName and a
                         value FieldVal.
*/

extern "C" void SymbolTable_PutFieldEnumeration (unsigned int tok, unsigned int Sym, NameKey_Name FieldName);

/*
   PutSubrange - places LowSym and HighSym as two symbols
                 which provide the limits of the range.
*/

extern "C" void SymbolTable_PutSubrange (unsigned int Sym, unsigned int LowSym, unsigned int HighSym, unsigned int TypeSymbol);

/*
   PutSet - places SimpleType as the type for set, Sym.
*/

extern "C" void SymbolTable_PutSet (unsigned int Sym, unsigned int SimpleType, bool packed);

/*
   IsSetPacked - returns TRUE if Sym is packed.
*/

extern "C" bool SymbolTable_IsSetPacked (unsigned int Sym);

/*
   GetArraySubscript - returns the subscript symbol for array, Sym.
*/

extern "C" unsigned int SymbolTable_GetArraySubscript (unsigned int Sym);

/*
   PutArraySubscript - places an index field into the array Sym. The
                       index field is a subscript sym.
*/

extern "C" void SymbolTable_PutArraySubscript (unsigned int Sym, unsigned int SubscriptSymbol);

/*
   PutType - gives a type symbol Sym type TypeSymbol.
*/

extern "C" void SymbolTable_PutType (unsigned int Sym, unsigned int TypeSymbol);

/*
   PutFunction - Places a TypeSym as the return type to a procedure Sym.
*/

extern "C" void SymbolTable_PutFunction (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int TypeSym);

/*
   PutOptFunction - places a TypeSym as the optional return type to a procedure Sym.
*/

extern "C" void SymbolTable_PutOptFunction (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int TypeSym);

/*
   IsReturnOptional - returns TRUE if the return value for, sym, is
                      optional.
*/

extern "C" bool SymbolTable_IsReturnOptional (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   IsReturnOptionalAny - returns TRUE if the return value for sym is
                         optional.
*/

extern "C" bool SymbolTable_IsReturnOptionalAny (unsigned int sym);

/*
   PutParam - Places a Non VAR parameter ParamName with type ParamType into
              procedure Sym:kind.  The parameter number is ParamNo.
              If the procedure Sym already has this parameter then
              the parameter is checked for consistancy and the
              consistancy test is returned.
*/

extern "C" bool SymbolTable_PutParam (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo, NameKey_Name ParamName, unsigned int ParamType, bool isUnbounded, unsigned int typetok);

/*
   PutVarParam - Places a Non VAR parameter ParamName with type
                 ParamType into procedure Sym:kind.
                 The parameter number is ParamNo.
                 If the procedure Sym already has this parameter then
                 the parameter is checked for consistancy and the
                 consistancy test is returned.
*/

extern "C" bool SymbolTable_PutVarParam (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo, NameKey_Name ParamName, unsigned int ParamType, bool isUnbounded, unsigned int typetok);

/*
   PutParamName - assigns a name to paramater no of procedure ProcSym:kind.
*/

extern "C" void SymbolTable_PutParamName (unsigned int tok, unsigned int ProcSym, SymbolTable_ProcedureKind kind, unsigned int no, NameKey_Name name, unsigned int ParamType, unsigned int typetok);

/*
   PutProcedureReachable - Sets the procedure, Sym, to be reachable by the
                           main Module.
*/

extern "C" void SymbolTable_PutProcedureReachable (unsigned int Sym);

/*
   IsProcedureReachable - Returns true if the procedure, Sym, is
                          reachable from the main Module.
*/

extern "C" bool SymbolTable_IsProcedureReachable (unsigned int Sym);

/*
   PutProcedureNoReturn - places value into the no return attribute
                          field of procedure sym.
*/

extern "C" void SymbolTable_PutProcedureNoReturn (unsigned int Sym, SymbolTable_ProcedureKind kind, bool value);

/*
   IsProcedureNoReturn - returns TRUE if this procedure never returns.
*/

extern "C" bool SymbolTable_IsProcedureNoReturn (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   GetProcedureProcType - returns the proctype matching procedure sym.
*/

extern "C" unsigned int SymbolTable_GetProcedureProcType (unsigned int sym);

/*
   PutModuleStartQuad - Places QuadNumber into the Module symbol, Sym.
                        QuadNumber is the start quad of Module,
                        Sym.
*/

extern "C" void SymbolTable_PutModuleStartQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutModuleEndQuad - Places QuadNumber into the Module symbol, Sym.
                      QuadNumber is the end quad of Module,
                      Sym.
*/

extern "C" void SymbolTable_PutModuleEndQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutModuleFinallyStartQuad - Places QuadNumber into the Module symbol, Sym.
                               QuadNumber is the finally start quad of
                               Module, Sym.
*/

extern "C" void SymbolTable_PutModuleFinallyStartQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutModuleFinallyEndQuad - Places QuadNumber into the Module symbol, Sym.
                             QuadNumber is the end quad of the finally block
                             in Module, Sym.
*/

extern "C" void SymbolTable_PutModuleFinallyEndQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   GetModuleQuads - Returns, StartInit EndInit StartFinish EndFinish,
                    Quads of a Module, Sym.
                    Start and End represent the initialization code
                    of the Module, Sym.
*/

extern "C" void SymbolTable_GetModuleQuads (unsigned int Sym, unsigned int *StartInit, unsigned int *EndInit, unsigned int *StartFinish, unsigned int *EndFinish);

/*
   PutModuleFinallyFunction - Places Tree, finally, into the Module symbol, Sym.
*/

extern "C" void SymbolTable_PutModuleFinallyFunction (unsigned int Sym, tree finally);

/*
   GetModuleFinallyFunction - returns the finally tree from the Module symbol, Sym.
*/

extern "C" tree SymbolTable_GetModuleFinallyFunction (unsigned int Sym);

/*
   PutProcedureScopeQuad - Places QuadNumber into the Procedure symbol, Sym.
                           QuadNumber is the start quad of scope for procedure,
                           Sym.
*/

extern "C" void SymbolTable_PutProcedureScopeQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutProcedureStartQuad - Places QuadNumber into the Procedure symbol, Sym.
                           QuadNumber is the start quad of procedure,
                           Sym.
*/

extern "C" void SymbolTable_PutProcedureStartQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   PutProcedureEndQuad - Places QuadNumber into the Procedure symbol, Sym.
                         QuadNumber is the end quad of procedure,
                         Sym.
*/

extern "C" void SymbolTable_PutProcedureEndQuad (unsigned int Sym, unsigned int QuadNumber);

/*
   GetProcedureQuads - Returns, Start and End, Quads of a procedure, Sym.
*/

extern "C" void SymbolTable_GetProcedureQuads (unsigned int Sym, unsigned int *scope, unsigned int *start, unsigned int *end);

/*
   GetQuads - assigns Start and End to the beginning and end of
              symbol, Sym, usage.
*/

extern "C" void SymbolTable_GetQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End);

/*
   GetReadQuads - assigns Start and End to the beginning and end of
                  symbol, Sym, read history usage.
*/

extern "C" void SymbolTable_GetReadQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End);

/*
   GetWriteQuads - assigns Start and End to the beginning and end of
                   symbol, Sym, usage.
*/

extern "C" void SymbolTable_GetWriteQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End);

/*
   PutReadQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_PutReadQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   RemoveReadQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_RemoveReadQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   PutWriteQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_PutWriteQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   RemoveWriteQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_RemoveWriteQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad);

/*
   GetReadLimitQuads - returns Start and End which have been assigned
                       the start and end of when the symbol was read
                       to within: StartLimit..EndLimit.
*/

extern "C" void SymbolTable_GetReadLimitQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End);

/*
   GetWriteLimitQuads - returns Start and End which have been assigned
                        the start and end of when the symbol was written
                        to within: StartLimit..EndLimit.
*/

extern "C" void SymbolTable_GetWriteLimitQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End);

/*
   GetNthProcedure - Returns the Nth procedure in Module, Sym.
*/

extern "C" unsigned int SymbolTable_GetNthProcedure (unsigned int Sym, unsigned int n);

/*
   GetDeclaredDef - returns the tokenno where the symbol was declared
                    in the definition module.  UnknownTokenNo is returned
                    if no declaration occurred.
*/

extern "C" unsigned int SymbolTable_GetDeclaredDef (unsigned int Sym);

/*
   GetDeclaredMod - returns the tokenno where the symbol was declared.
                    in the program or implementation module.
                    UnknownTokenNo is returned if no declaration occurred.
*/

extern "C" unsigned int SymbolTable_GetDeclaredMod (unsigned int Sym);

/*
   GetDeclaredFor - returns the token where this forward procedure symbol
                    was declared in the program or implementation module.
                    UnknownTokenNo is returned if no declaration occurred.
*/

extern "C" unsigned int SymbolTable_GetDeclaredFor (unsigned int Sym);

/*
   GetDeclaredDefinition - returns the token where this symbol
                           was declared in the definition module.
*/

extern "C" unsigned int SymbolTable_GetDeclaredDefinition (unsigned int Sym);

/*
   GetDeclaredModule - returns the token where this symbol was declared
                       in an implementation or program module.
*/

extern "C" unsigned int SymbolTable_GetDeclaredModule (unsigned int Sym);

/*
   PutDeclared - adds an entry to symbol, Sym, indicating that it
                 was declared at, tok.  This routine
                 may be called twice, once for definition module
                 partial declaration and once when parsing the
                 implementation module.
*/

extern "C" void SymbolTable_PutDeclared (unsigned int tok, unsigned int Sym);

/*
   GetFirstUsed - returns the token where this symbol was first used.
*/

extern "C" unsigned int SymbolTable_GetFirstUsed (unsigned int Sym);

/*
   PutProcedureBegin - assigns begin as the token number matching the
                       procedure BEGIN.
*/

extern "C" void SymbolTable_PutProcedureBegin (unsigned int Sym, unsigned int begin);

/*
   PutProcedureEnd - assigns end as the token number matching the
                     procedure END.
*/

extern "C" void SymbolTable_PutProcedureEnd (unsigned int Sym, unsigned int end);

/*
   GetProcedureBeginEnd - assigns, begin, end, to the stored token values.
*/

extern "C" void SymbolTable_GetProcedureBeginEnd (unsigned int Sym, unsigned int *begin, unsigned int *end);

/*
   ForeachProcedureDo - for each procedure in module, Sym, do procedure, P.
*/

extern "C" void SymbolTable_ForeachProcedureDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   ForeachModuleDo - for each module do procedure, P.
*/

extern "C" void SymbolTable_ForeachModuleDo (SymbolKey_PerformOperation P);

/*
   ForeachInnerModuleDo - for each inner module in module, Sym,
                          do procedure, P.
*/

extern "C" void SymbolTable_ForeachInnerModuleDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   IsVarParam - Returns a conditional depending whether parameter ParamNo
                is a VAR parameter.
*/

extern "C" bool SymbolTable_IsVarParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo);

/*
   IsVarParamAny - Returns a conditional depending whether parameter ParamNo
                   is a VAR parameter.
*/

extern "C" bool SymbolTable_IsVarParamAny (unsigned int Sym, unsigned int ParamNo);

/*
   IsUnboundedParam - Returns a conditional depending whether parameter
                      ParamNo is an unbounded array procedure parameter.
*/

extern "C" bool SymbolTable_IsUnboundedParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo);
extern "C" bool SymbolTable_IsUnboundedParamAny (unsigned int Sym, unsigned int ParamNo);

/*
   IsParameterUnbounded - returns TRUE if parameter, Sym, is
                          unbounded.
*/

extern "C" bool SymbolTable_IsParameterUnbounded (unsigned int Sym);

/*
   IsParameterVar - returns true if parameter symbol Sym
                    was declared as a VAR.
*/

extern "C" bool SymbolTable_IsParameterVar (unsigned int Sym);

/*
   GetParameterShadowVar - returns the local variable associated with the
                           parameter symbol, sym.
*/

extern "C" unsigned int SymbolTable_GetParameterShadowVar (unsigned int sym);

/*
   NoOfParam - Returns the number of parameters that procedure Sym contains.
*/

extern "C" unsigned int SymbolTable_NoOfParam (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   HasVarParameters - returns TRUE if procedure, p, has any VAR parameters.
*/

extern "C" bool SymbolTable_HasVarParameters (unsigned int p);

/*
   NoOfLocalVar - returns the number of local variables that exist in
                  procedure Sym. Parameters are NOT included in the
                  count.
*/

extern "C" unsigned int SymbolTable_NoOfLocalVar (unsigned int Sym);

/*
   IsDefImp - returns true is the Sym is a DefImp symbol.
              Definition/Implementation module symbol.
*/

extern "C" bool SymbolTable_IsDefImp (unsigned int Sym);

/*
   IsModule - returns true is the Sym is a Module symbol.
              Program module symbol.
*/

extern "C" bool SymbolTable_IsModule (unsigned int Sym);

/*
   IsInnerModule - returns true if the symbol, Sym, is an inner module.
*/

extern "C" bool SymbolTable_IsInnerModule (unsigned int Sym);

/*
   GetSymName - returns the symbol name.
*/

extern "C" NameKey_Name SymbolTable_GetSymName (unsigned int Sym);

/*
   RenameSym - renames a symbol, Sym, with SymName.
               It also checks the unknown tree for a symbol
               with this new name. Must only be renamed in
               the same scope of being declared.
*/

extern "C" void SymbolTable_RenameSym (unsigned int Sym, NameKey_Name SymName);

/*
   IsUnknown - returns true is the symbol Sym is unknown.
*/

extern "C" bool SymbolTable_IsUnknown (unsigned int Sym);

/*
   IsPartialUnbounded - returns TRUE if, sym, is a partially unbounded symbol.
*/

extern "C" bool SymbolTable_IsPartialUnbounded (unsigned int sym);

/*
   RequestSym - searches for a symbol with a name SymName in the
                current and previous scopes.
                If the symbol is found then it is returned
                else an unknown symbol is returned create at token
                position, tok.
                This procedure does search the base scope (for
                pervasive identifiers).
*/

extern "C" unsigned int SymbolTable_RequestSym (unsigned int tok, NameKey_Name SymName);

/*
   PutImported - places a symbol, Sym, into the current main scope.
*/

extern "C" void SymbolTable_PutImported (unsigned int Sym);

/*
   PutIncluded - places a symbol, Sym, into the included list of the
                 current module.
                 Symbols that are placed in this list are indirectly declared
                 by:

                 IMPORT modulename ;

                 modulename.identifier
*/

extern "C" void SymbolTable_PutIncluded (unsigned int Sym);

/*
   PutExported - places a symbol, Sym into the next level out module.
                 Sym is also placed in the ExportTree of the current inner
                 module.
*/

extern "C" void SymbolTable_PutExported (unsigned int Sym);

/*
   PutExportQualified - places a symbol with the name, SymName,
                        into the export tree of the
                        Definition module being compiled.
                        The symbol with name has been EXPORT QUALIFIED
                        by the definition module and therefore any reference
                        to this symbol in the code generation phase
                        will be in the form _Module_Name.
*/

extern "C" void SymbolTable_PutExportQualified (unsigned int tokenno, NameKey_Name SymName);

/*
   PutExportUnQualified - places a symbol with the name, SymName,
                          into the export tree of the
                          Definition module being compiled.
                          The symbol with Name has been EXPORT UNQUALIFIED
                          by the definition module and therefore any reference
                          to this symbol in the code generation phase
                          will be in the form _Name.
*/

extern "C" void SymbolTable_PutExportUnQualified (unsigned int tokenno, NameKey_Name SymName);

/*
   PutExportUnImplemented - places a symbol, Sym, into the currently compiled
                            DefImp module NeedToBeImplemented list.
*/

extern "C" void SymbolTable_PutExportUnImplemented (unsigned int tokenno, unsigned int Sym);

/*
   GetExported - returns the symbol which has a name SymName,
                 and is exported from the definition module ModSym.

*/

extern "C" unsigned int SymbolTable_GetExported (unsigned int tokenno, unsigned int ModSym, NameKey_Name SymName);

/*
   GetFromOuterModule - returns a symbol with name, SymName, which comes
                        from outside the current module.
*/

extern "C" unsigned int SymbolTable_GetFromOuterModule (unsigned int tokenno, NameKey_Name SymName);

/*
   TryMoveUndeclaredSymToInnerModule - attempts to move a symbol of
                                       name, name, which is
                                       currently undefined in the
                                       outer scope to the inner scope.
                                       If successful then the symbol is
                                       returned otherwise NulSym is
                                       returned.
*/

extern "C" unsigned int SymbolTable_TryMoveUndeclaredSymToInnerModule (unsigned int OuterScope, unsigned int InnerScope, NameKey_Name name);

/*
   IsExportQualified - returns true if a symbol, Sym, was defined as
                       being EXPORT QUALIFIED.
                       Sym is expected to be either a procedure or a
                       variable.
*/

extern "C" bool SymbolTable_IsExportQualified (unsigned int Sym);

/*
   IsExportUnQualified - returns true if a symbol, Sym, was defined as
                         being EXPORT UNQUALIFIED.
*/

extern "C" bool SymbolTable_IsExportUnQualified (unsigned int Sym);

/*
   IsExported - returns true if a symbol, Sym, is exported
                from module, ModSym.
                If ModSym is a DefImp symbol then its
                ExportQualified and ExportUnQualified lists are examined.
*/

extern "C" bool SymbolTable_IsExported (unsigned int ModSym, unsigned int Sym);

/*
   IsImplicityExported - returns TRUE if, Sym, is implicitly exported from module, ModSym.
                         ModSym must be a defimp symbol.
*/

extern "C" bool SymbolTable_IsImplicityExported (unsigned int ModSym, unsigned int Sym);

/*
   IsImported - returns true if a symbol, Sym, in module, ModSym,
                was imported.
*/

extern "C" bool SymbolTable_IsImported (unsigned int ModSym, unsigned int Sym);

/*
   PutIncludedByDefinition - places a module symbol, Sym, into the
                             included list of the current definition module.
*/

extern "C" void SymbolTable_PutIncludedByDefinition (unsigned int Sym);

/*
   IsIncludedByDefinition - returns TRUE if definition module symbol, Sym, was included
                            by ModSym's definition module.
*/

extern "C" bool SymbolTable_IsIncludedByDefinition (unsigned int ModSym, unsigned int Sym);

/*
   ForeachImportedDo - calls a procedure, P, foreach imported symbol
                       in module, ModSym.
*/

extern "C" void SymbolTable_ForeachImportedDo (unsigned int ModSym, SymbolKey_PerformOperation P);

/*
   ForeachExportedDo - calls a procedure, P, foreach imported symbol
                       in module, ModSym.
*/

extern "C" void SymbolTable_ForeachExportedDo (unsigned int ModSym, SymbolKey_PerformOperation P);

/*
   CheckForExportedImplementation - checks to see whether an implementation
                                    module is currently being compiled, if so,
                                    symbol, Sym, is removed from the
                                    NeedToBeImplemented list.
                                    This procedure is called whenever a symbol
                                    is declared, thus attempting to reduce
                                    the NeedToBeImplemented list.
                                    Only needs to be called when a TYPE or
                                    PROCEDURE is built since the implementation
                                    module can only implement these objects
                                    declared in the definition module.

                                    It also checks whether a definition module
                                    is currently being compiled and, if so,
                                    it will ensure that symbol, Sym, is removed
                                    from the ExportRequest list. If Sym is an
                                    enumerated type it ensures that its fields
                                    are also removed.
*/

extern "C" void SymbolTable_CheckForExportedImplementation (unsigned int Sym);

/*
   CheckForUnImplementedExports - displays an error and the offending symbols
                                  which have been exported but not implemented
                                  from the current compiled module.
*/

extern "C" void SymbolTable_CheckForUnImplementedExports (void);

/*
   CheckForUndeclaredExports - displays an error and the offending symbols
                               which have been exported but not declared
                               from module, ModSym.
*/

extern "C" void SymbolTable_CheckForUndeclaredExports (unsigned int ModSym);

/*
   CheckForUnknownInModule - checks for any unknown symbols in the
                             current module.
                             If any unknown symbols are found then
                             an error message is displayed.
*/

extern "C" void SymbolTable_CheckForUnknownInModule (void);

/*
   UnknownReported - if sym is an unknown symbol and has not been reported
                     then include it into the set of reported unknowns.
*/

extern "C" void SymbolTable_UnknownReported (unsigned int sym);

/*
   IsReallyPointer - returns TRUE is sym is a pointer, address or a
                     type declared as a pointer or address.
*/

extern "C" bool SymbolTable_IsReallyPointer (unsigned int Sym);

/*
   CheckHiddenTypeAreAddress - checks to see that any hidden types
                               which we have declared are actually
                               of type ADDRESS or map onto a POINTER type.
*/

extern "C" void SymbolTable_CheckHiddenTypeAreAddress (void);

/*
   PutDefinitionForC - sets a flag in the current compiled module which
                       indicates that this module is a wrapper for a C
                       file. Parameters passes to procedures in this module
                       will adopt the C calling convention.
*/

extern "C" void SymbolTable_PutDefinitionForC (unsigned int Sym);

/*
   IsDefinitionForC - returns true if this definition module was declared
                      as a DEFINITION MODULE FOR "C".
*/

extern "C" bool SymbolTable_IsDefinitionForC (unsigned int Sym);

/*
   PutDoesNeedExportList - sets a flag in module, Sym, which
                           indicates that this module requires an explicit
                           EXPORT QUALIFIED or UNQUALIFIED list. PIM-2
*/

extern "C" void SymbolTable_PutDoesNeedExportList (unsigned int Sym);

/*
   PutDoesNotNeedExportList - sets a flag in module, Sym, which
                              indicates that this module does not require an explicit
                              EXPORT QUALIFIED or UNQUALIFIED list. PIM-3|4
*/

extern "C" void SymbolTable_PutDoesNotNeedExportList (unsigned int Sym);

/*
   DoesNotNeedExportList - returns TRUE if module, Sym, does not require an explicit
                           EXPORT QUALIFIED list.
*/

extern "C" bool SymbolTable_DoesNotNeedExportList (unsigned int Sym);

/*
   CheckForEnumerationInCurrentModule - checks to see whether the enumeration
                                        type symbol, Sym, has been entered into
                                        the current modules scope list.
*/

extern "C" void SymbolTable_CheckForEnumerationInCurrentModule (unsigned int Sym);

/*
   SanityCheckConstants - must only be called once all constants, types, procedures
                          have been declared.  It checks to see that constants are
                          not used as procedure parameter types.
*/

extern "C" void SymbolTable_SanityCheckConstants (void);

/*
   ForeachLocalSymDo - foreach local symbol in module, Sym, or procedure, Sym,
                       perform the procedure, P.
*/

extern "C" void SymbolTable_ForeachLocalSymDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   ForeachParamSymDo - foreach parameter symbol in procedure Sym
                       perform the procedure P.  Each symbol
                       looked up will be VarParam or Param
                       (not the shadow variable).  Every parameter
                       from each KindProcedure is iterated over.
*/

extern "C" void SymbolTable_ForeachParamSymDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   ForeachFieldEnumerationDo - for each field in enumeration, Sym,
                               do procedure, P.  Each call to P contains
                               an enumeration field, the order is alphabetical.
                               Use ForeachLocalSymDo for declaration order.
*/

extern "C" void SymbolTable_ForeachFieldEnumerationDo (unsigned int Sym, SymbolKey_PerformOperation P);

/*
   IsType - returns true if the Sym is a type symbol.
*/

extern "C" bool SymbolTable_IsType (unsigned int Sym);

/*
   IsProcedure - returns true if Sym is a procedure symbol.
*/

extern "C" bool SymbolTable_IsProcedure (unsigned int Sym);

/*
   IsParameter - returns true if Sym is a parameter symbol.
*/

extern "C" bool SymbolTable_IsParameter (unsigned int Sym);

/*
   GetProcedureKind - returns the procedure kind given the declaration tok.
                      The declaration tok must match the ident tok in the
                      procedure name.  It is only safe to call this
                      procedure function during pass 2 onwards.
*/

extern "C" SymbolTable_ProcedureKind SymbolTable_GetProcedureKind (unsigned int sym, unsigned int tok);

/*
   GetProcedureDeclaredTok - return the token where the
                             declaration of procedure sym:kind
                             occurred.
*/

extern "C" unsigned int SymbolTable_GetProcedureDeclaredTok (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutProcedureDeclaredTok - places the tok where the
                             declaration of procedure sym:kind
                             occurred.
*/

extern "C" void SymbolTable_PutProcedureDeclaredTok (unsigned int sym, SymbolTable_ProcedureKind kind, unsigned int tok);

/*
   GetReturnTypeTok - return the token where the
                               return type procedure sym:kind or proctype
                               was defined.
*/

extern "C" unsigned int SymbolTable_GetReturnTypeTok (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutReturnTypeTok - places the tok where the
                      return type of procedure sym:kind or proctype
                      was defined.
*/

extern "C" void SymbolTable_PutReturnTypeTok (unsigned int sym, SymbolTable_ProcedureKind kind, unsigned int tok);

/*
   PutProcedureParametersDefined - the procedure symbol sym:kind
                                   parameters have been defined.
*/

extern "C" void SymbolTable_PutProcedureParametersDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   GetProcedureParametersDefined - returns true if procedure symbol sym:kind
                                   parameters are defined.
*/

extern "C" bool SymbolTable_GetProcedureParametersDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutProcedureDefined - the procedure symbol sym:kind is defined.
*/

extern "C" void SymbolTable_PutProcedureDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   GetProcedureDefined - returns true if procedure symbol sym:kind
                         is defined.
*/

extern "C" bool SymbolTable_GetProcedureDefined (unsigned int sym, SymbolTable_ProcedureKind kind);

/*
   PutUseVarArgs - tell the symbol table that this procedure, Sym,
                   uses varargs.
                   The procedure _must_ be declared inside a
                   DEFINITION FOR "C"

*/

extern "C" void SymbolTable_PutUseVarArgs (unsigned int Sym);

/*
   UsesVarArgs - returns TRUE if procedure, Sym, uses varargs.
                 The procedure _must_ be declared inside a
                 DEFINITION FOR "C"
*/

extern "C" bool SymbolTable_UsesVarArgs (unsigned int Sym);

/*
   PutUseOptArg - tell the symbol table that this procedure, Sym,
                  uses an optarg.
*/

extern "C" void SymbolTable_PutUseOptArg (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   UsesOptArg - returns TRUE if procedure, Sym, uses varargs.
*/

extern "C" bool SymbolTable_UsesOptArg (unsigned int Sym, SymbolTable_ProcedureKind kind);

/*
   PutOptArgInit - makes symbol, Sym, the initializer value to
                   procedure, ProcSym.
*/

extern "C" void SymbolTable_PutOptArgInit (unsigned int ProcSym, unsigned int Sym);

/*
   GetOptArgInit - returns the initializer value to the optional parameter in
                   procedure, ProcSym.
*/

extern "C" unsigned int SymbolTable_GetOptArgInit (unsigned int ProcSym);

/*
   MakePointer - returns a pointer symbol with PointerName.
*/

extern "C" unsigned int SymbolTable_MakePointer (unsigned int tok, NameKey_Name PointerName);

/*
   PutPointer - gives a pointer symbol a type, PointerType.
*/

extern "C" void SymbolTable_PutPointer (unsigned int Sym, unsigned int PointerType);

/*
   IsPointer - returns true is Sym is a pointer type symbol.
*/

extern "C" bool SymbolTable_IsPointer (unsigned int Sym);

/*
   IsRecord - returns true is Sym is a record type symbol.
*/

extern "C" bool SymbolTable_IsRecord (unsigned int Sym);

/*
   IsVarient - returns true if the symbol, Sym, is a
               varient symbol.
*/

extern "C" bool SymbolTable_IsVarient (unsigned int Sym);

/*
   IsFieldVarient - returns true if the symbol, Sym, is a
                    varient field.
*/

extern "C" bool SymbolTable_IsFieldVarient (unsigned int Sym);

/*
   IsFieldEnumeration - returns true if the symbol, Sym, is an
                        enumeration field.
*/

extern "C" bool SymbolTable_IsFieldEnumeration (unsigned int Sym);

/*
   IsArray - returns true is Sym is an array type symbol.
*/

extern "C" bool SymbolTable_IsArray (unsigned int Sym);

/*
   IsEnumeration - returns true if Sym is an enumeration symbol.
*/

extern "C" bool SymbolTable_IsEnumeration (unsigned int Sym);

/*
   IsSet - returns TRUE if Sym is a set symbol.
*/

extern "C" bool SymbolTable_IsSet (unsigned int Sym);

/*
   IsHiddenType - returns TRUE if, Sym, is a Type and is also declared as a hidden type.
*/

extern "C" bool SymbolTable_IsHiddenType (unsigned int Sym);

/*
   IsOAFamily - returns TRUE if, Sym, is an OAFamily symbol.
*/

extern "C" bool SymbolTable_IsOAFamily (unsigned int Sym);

/*
   GetDimension - return the number of dimensions associated with
                  this unbounded ARRAY parameter.
*/

extern "C" unsigned int SymbolTable_GetDimension (unsigned int sym);

/*
   MakeOAFamily - makes an OAFamily symbol based on SimpleType.
                  It returns the OAFamily symbol.  A new symbol
                  is created if one does not already exist for
                  SimpleType.
*/

extern "C" unsigned int SymbolTable_MakeOAFamily (unsigned int SimpleType);

/*
   GetOAFamily - returns the oafamily symbol associated with
                 SimpleType.
*/

extern "C" unsigned int SymbolTable_GetOAFamily (unsigned int SimpleType);

/*
   ForeachOAFamily - call, p[oaf, ndim, symbol] for every unbounded symbol,
                     sym, in the oaf.
*/

extern "C" void SymbolTable_ForeachOAFamily (unsigned int sym, SymbolTable_FamilyOperation p);

/*
   IsUnbounded - returns true if Sym is an unbounded symbol.
*/

extern "C" bool SymbolTable_IsUnbounded (unsigned int Sym);

/*
   GetUnbounded - returns the unbounded symbol associated with
                  the OAFamily symbol, oaf, and the number of
                  dimensions, ndim, of the open array.
*/

extern "C" unsigned int SymbolTable_GetUnbounded (unsigned int oaf, unsigned int ndim);

/*
   GetUnboundedRecordType - returns the record type used to
                            implement the unbounded array.
*/

extern "C" unsigned int SymbolTable_GetUnboundedRecordType (unsigned int Sym);

/*
   GetUnboundedAddressOffset - returns the offset of the address field
                               inside the record used to implement the
                               unbounded type.
*/

extern "C" unsigned int SymbolTable_GetUnboundedAddressOffset (unsigned int sym);

/*
   GetUnboundedHighOffset - returns the offset of the high field
                            inside the record used to implement the
                            unbounded type.
*/

extern "C" unsigned int SymbolTable_GetUnboundedHighOffset (unsigned int sym, unsigned int ndim);

/*
   MakeSubscript - makes a subscript Symbol.
                   No name is required.
*/

extern "C" unsigned int SymbolTable_MakeSubscript (void);

/*
   PutSubscript - gives a subscript symbol a type, SimpleType.
*/

extern "C" void SymbolTable_PutSubscript (unsigned int Sym, unsigned int SimpleType);

/*
   MakeUnbounded - makes an unbounded array Symbol.
                   ndim is the number of dimensions required.
                   No name is required.
*/

extern "C" unsigned int SymbolTable_MakeUnbounded (unsigned int tok, unsigned int SimpleType, unsigned int ndim);

/*
   NoOfElements - Returns the number of elements in array Sym,
                  or the number of elements in an enumeration Sym or
                  the number of interface symbols in an Interface list.
*/

extern "C" unsigned int SymbolTable_NoOfElements (unsigned int Sym);

/*
   PutArray - places a type symbol into an arraysym.
*/

extern "C" void SymbolTable_PutArray (unsigned int arraysym, unsigned int typesym);

/*
   ResolveImports - it examines the import list of all inner modules
                    and resolves all relative imports.
*/

extern "C" void SymbolTable_ResolveImports (void);

/*
   ResolveConstructorTypes - to be called at the end of pass three.  Its
                             purpose is to fix up all constructors whose
                             types are unknown.
*/

extern "C" void SymbolTable_ResolveConstructorTypes (void);

/*
   AddNameToScope - adds a Name, n, to the list of objects declared at the
                    current scope.
*/

extern "C" void SymbolTable_AddNameToScope (NameKey_Name n);

/*
   AddNameToImportList - adds a Name, n, to the import list of the current
                         module.
*/

extern "C" void SymbolTable_AddNameToImportList (NameKey_Name n);

/*
   GetScope - returns the declaration scope of the symbol.
*/

extern "C" unsigned int SymbolTable_GetScope (unsigned int Sym);

/*
   GetModuleScope - returns the module scope of symbol, sym.
                    If sym was declared within a nested procedure
                    then return the module which defines the
                    procedure.
*/

extern "C" unsigned int SymbolTable_GetModuleScope (unsigned int sym);

/*
   GetProcedureScope - returns the innermost procedure (if any)
                       in which the symbol, sym, resides.
                       A module inside the procedure is skipped
                       over.
*/

extern "C" unsigned int SymbolTable_GetProcedureScope (unsigned int sym);

/*
   IsModuleWithinProcedure - returns TRUE if module, sym, is
                             inside a procedure.
*/

extern "C" bool SymbolTable_IsModuleWithinProcedure (unsigned int sym);

/*
   GetParent - returns the parent of symbol, Sym.
*/

extern "C" unsigned int SymbolTable_GetParent (unsigned int Sym);

/*
   IsRecordField - returns true if Sym is a record field.
*/

extern "C" bool SymbolTable_IsRecordField (unsigned int Sym);

/*
   MakeProcType - returns a procedure type symbol with ProcTypeName.
*/

extern "C" unsigned int SymbolTable_MakeProcType (unsigned int tok, NameKey_Name ProcTypeName);

/*
   PutProcTypeParam - Places a Non VAR parameter ParamName with type
                      ParamType into ProcType Sym.
*/

extern "C" void SymbolTable_PutProcTypeParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded);

/*
   PutProcTypeVarParam - Places a Non VAR parameter ParamName with type
                         ParamType into ProcType Sym.
*/

extern "C" void SymbolTable_PutProcTypeVarParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded);

/*
   IsProcType - returns true if Sym is a ProcType Symbol.
*/

extern "C" bool SymbolTable_IsProcType (unsigned int Sym);

/*
   IsVar - returns true if Sym is a Var Symbol.
*/

extern "C" bool SymbolTable_IsVar (unsigned int Sym);

/*
   IsVarConst - returns the IsConst field indicating the variable is read only.
*/

extern "C" bool SymbolTable_IsVarConst (unsigned int sym);

/*
   IsConst - returns true if Sym contains a constant value.
*/

extern "C" bool SymbolTable_IsConst (unsigned int Sym);

/*
   IsConstString - returns whether sym is a conststring of any variant.
*/

extern "C" bool SymbolTable_IsConstString (unsigned int sym);

/*
   IsConstStringNulTerminated - returns TRUE if the constant string, sym,
                                should be created with a nul terminator.
*/

extern "C" bool SymbolTable_IsConstStringNulTerminated (unsigned int sym);

/*
   IsConstLit - returns true if Sym is a literal constant.
*/

extern "C" bool SymbolTable_IsConstLit (unsigned int Sym);

/*
   IsConstructor - returns TRUE if the constant is declared as a
                   constant set, array or record.
*/

extern "C" bool SymbolTable_IsConstructor (unsigned int Sym);

/*
   IsDummy - returns true if Sym is a Dummy symbol.
*/

extern "C" bool SymbolTable_IsDummy (unsigned int Sym);

/*
   IsTemporary - returns true if Sym is a Temporary symbol.
*/

extern "C" bool SymbolTable_IsTemporary (unsigned int Sym);

/*
   IsVarAParam - returns true if Sym is a variable declared as a parameter.
*/

extern "C" bool SymbolTable_IsVarAParam (unsigned int Sym);

/*
   IsSubscript - returns true if Sym is a subscript symbol.
*/

extern "C" bool SymbolTable_IsSubscript (unsigned int Sym);

/*
   IsSubrange - returns true if Sym is a subrange symbol.
*/

extern "C" bool SymbolTable_IsSubrange (unsigned int Sym);

/*
   IsProcedureVariable - returns true if a Sym is a variable and
                         it was declared within a procedure.
*/

extern "C" bool SymbolTable_IsProcedureVariable (unsigned int Sym);

/*
   IsProcedureNested - returns TRUE if procedure, Sym, was
                       declared as a nested procedure.
*/

extern "C" bool SymbolTable_IsProcedureNested (unsigned int Sym);

/*
   IsAModula2Type - returns true if Sym, is a:
                    IsType, IsPointer, IsRecord, IsEnumeration,
                    IsSubrange, IsArray, IsUnbounded, IsProcType.
                    NOTE that it different from IsType.
*/

extern "C" bool SymbolTable_IsAModula2Type (unsigned int Sym);

/*
   IsGnuAsmVolatile - returns TRUE if a GnuAsm symbol was defined as VOLATILE.
*/

extern "C" bool SymbolTable_IsGnuAsmVolatile (unsigned int Sym);

/*
   IsGnuAsmSimple - returns TRUE if a GnuAsm symbol is a simple kind.
*/

extern "C" bool SymbolTable_IsGnuAsmSimple (unsigned int Sym);

/*
   IsGnuAsm - returns TRUE if Sym is a GnuAsm symbol.
*/

extern "C" bool SymbolTable_IsGnuAsm (unsigned int Sym);

/*
   IsRegInterface - returns TRUE if Sym is a RegInterface symbol.
*/

extern "C" bool SymbolTable_IsRegInterface (unsigned int Sym);

/*
   IsSizeSolved - returns true if the size of Sym is solved.
*/

extern "C" bool SymbolTable_IsSizeSolved (unsigned int Sym);

/*
   IsOffsetSolved - returns true if the Offset of Sym is solved.
*/

extern "C" bool SymbolTable_IsOffsetSolved (unsigned int Sym);

/*
   IsValueSolved - returns true if the value of Sym is solved.
*/

extern "C" bool SymbolTable_IsValueSolved (unsigned int Sym);

/*
   IsConstructorConstant - returns TRUE if constructor, Sym, is
                           defined by only constants.
*/

extern "C" bool SymbolTable_IsConstructorConstant (unsigned int Sym);

/*
   IsComposite - returns TRUE if symbol, sym, is a composite
                 type:  ie an ARRAY or RECORD.
*/

extern "C" bool SymbolTable_IsComposite (unsigned int sym);

/*
   IsSumOfParamSizeSolved - has the sum of parameters been solved yet?
*/

extern "C" bool SymbolTable_IsSumOfParamSizeSolved (unsigned int Sym);

/*
   PutAlignment - assigns the alignment constant associated with,
                  type, with, align.
*/

extern "C" void SymbolTable_PutAlignment (unsigned int type, unsigned int align);

/*
   GetAlignment - returns the alignment constant associated with,
                  type.
*/

extern "C" unsigned int SymbolTable_GetAlignment (unsigned int type);

/*
   GetDefaultRecordFieldAlignment - assigns, align, as the default alignment
                                    to record, sym.
*/

extern "C" unsigned int SymbolTable_GetDefaultRecordFieldAlignment (unsigned int sym);

/*
   PutDefaultRecordFieldAlignment - assigns, align, as the default alignment
                                    to record, sym.
*/

extern "C" void SymbolTable_PutDefaultRecordFieldAlignment (unsigned int sym, unsigned int align);

/*
   PutUnused - sets, sym, as unused.  This is a gm2 pragma.
*/

extern "C" void SymbolTable_PutUnused (unsigned int sym);

/*
   IsUnused - returns TRUE if the symbol was declared as unused with a
              gm2 pragma.
*/

extern "C" bool SymbolTable_IsUnused (unsigned int sym);

/*
   PutDeclaredPacked - sets the Packed field of the record or record field symbol.
*/

extern "C" void SymbolTable_PutDeclaredPacked (unsigned int sym, bool b);

/*
   IsDeclaredPacked - was the record symbol or record field, sym,
                      declared as packed?
*/

extern "C" bool SymbolTable_IsDeclaredPacked (unsigned int sym);

/*
   IsDeclaredPackedResolved - do we know if the record symbol or record
                              field, sym, declared as packed or not packed?
*/

extern "C" bool SymbolTable_IsDeclaredPackedResolved (unsigned int sym);

/*
   GetPackedEquivalent - returns the packed equivalent of type, sym.
                         sym must be a type, subrange or enumerated type.
*/

extern "C" unsigned int SymbolTable_GetPackedEquivalent (unsigned int sym);

/*
   GetNonPackedEquivalent - returns the equivalent non packed symbol associated with, sym.
*/

extern "C" unsigned int SymbolTable_GetNonPackedEquivalent (unsigned int sym);

/*
   IsEquivalent - returns TRUE if, sym, is an equivalent symbol.
*/

extern "C" bool SymbolTable_IsEquivalent (unsigned int sym);

/*
   PushSize - pushes the size of Sym.
*/

extern "C" void SymbolTable_PushSize (unsigned int Sym);

/*
   PopSize - pops the ALU stack into Size of Sym.
*/

extern "C" void SymbolTable_PopSize (unsigned int Sym);

/*
   PushValue - pushes the Value of Sym onto the ALU stack.
*/

extern "C" void SymbolTable_PushValue (unsigned int Sym);

/*
   PushVarSize - pushes the size of a variable, Sym.
                 The runtime size of Sym will depend upon its addressing mode,
                 RightValue has size PushSize(GetType(Sym)) and
                 LeftValue has size PushSize(Address) since it points to a
                 variable.
*/

extern "C" void SymbolTable_PushVarSize (unsigned int Sym);

/*
   PopValue - pops the ALU stack into Value of Sym.
*/

extern "C" void SymbolTable_PopValue (unsigned int Sym);

/*
   IsObject - returns TRUE if the symbol is an object symbol.
*/

extern "C" bool SymbolTable_IsObject (unsigned int Sym);

/*
   IsTuple - returns TRUE if the symbol is a tuple symbol.
*/

extern "C" bool SymbolTable_IsTuple (unsigned int Sym);

/*
   Make2Tuple - creates and returns a 2 tuple from, a, and, b.
*/

extern "C" unsigned int SymbolTable_Make2Tuple (unsigned int a, unsigned int b);

/*
   MakeError - creates an error node, which can be used in MetaError messages.
               It will be removed from ExportUndeclared and Unknown trees.
*/

extern "C" unsigned int SymbolTable_MakeError (unsigned int tok, NameKey_Name name);

/*
   MakeErrorS - creates an error node from a string, which can be used
                in MetaError messages.
                It will be removed from ExportUndeclared and Unknown trees.
*/

extern "C" unsigned int SymbolTable_MakeErrorS (unsigned int tok, DynamicStrings_String name);

/*
   IsError - returns TRUE if the symbol is an error symbol.
*/

extern "C" bool SymbolTable_IsError (unsigned int Sym);

/*
   IsLegal - returns TRUE if, sym, is a legal symbol.
*/

extern "C" bool SymbolTable_IsLegal (unsigned int sym);

/*
   PutModuleContainsBuiltin - sets a flag in the current compiled module which
                              indicates that a builtin procedure is being declared.
                              This is only expected to be called when we are
                              parsing the definition module.
*/

extern "C" void SymbolTable_PutModuleContainsBuiltin (void);

/*
   IsBuiltinInModule - returns true if a module, Sym, has declared a builtin procedure.
*/

extern "C" bool SymbolTable_IsBuiltinInModule (unsigned int Sym);

/*
   PutHiddenTypeDeclared - sets a flag in the current compiled module which
                           indicates that a Hidden Type is declared within
                           the implementation part of the module.
                           This procedure is expected to be called while
                           compiling the associated definition module.
*/

extern "C" void SymbolTable_PutHiddenTypeDeclared (void);

/*
   IsHiddenTypeDeclared - returns true if a Hidden Type was declared in
                          the module, Sym.
*/

extern "C" bool SymbolTable_IsHiddenTypeDeclared (unsigned int Sym);

/*
   IsHiddenReallyPointer - returns TRUE is sym is a pointer, address or a
                           type declared as a pointer or address.
*/

extern "C" bool SymbolTable_IsHiddenReallyPointer (unsigned int Sym);

/*
   DisplayTrees - displays the SymbolTrees for Module symbol, ModSym.
*/

extern "C" void SymbolTable_DisplayTrees (unsigned int ModSym);

/*
   DebugLineNumbers - internal debugging, emit all procedure names in this module
                      together with the line numbers for the corresponding begin/end
                      tokens.
*/

extern "C" void SymbolTable_DebugLineNumbers (unsigned int sym);

/*
   GetErrorScope - returns the error scope for a symbol.
                   The error scope is the title scope which is used to
                   announce the symbol in the GCC error message.
*/

extern "C" M2Error_ErrorScope SymbolTable_GetErrorScope (unsigned int sym);

/*
   MakeImport - create and return an import symbol.
                moduleSym is the symbol being imported.
                isqualified is FALSE if it were IMPORT modulename and
                TRUE for the qualified FROM modulename IMPORT etc.
                listno is the import list count for this module.
                tok should match this modulename position.
*/

extern "C" unsigned int SymbolTable_MakeImport (unsigned int tok, unsigned int moduleSym, unsigned int listno, bool isqualified);

/*
   MakeImportStatement - return a dependent symbol which represents an import statement
                   or a qualified import statement.  The tok should either match
                   the FROM token or the IMPORT token.  listno is the import list
                   count for the module.
*/

extern "C" unsigned int SymbolTable_MakeImportStatement (unsigned int tok, unsigned int listno);

/*
   IsImport - returns TRUE if sym is an import symbol.
*/

extern "C" bool SymbolTable_IsImport (unsigned int sym);

/*
   IsImportStatement - returns TRUE if sym is a dependent symbol.
*/

extern "C" bool SymbolTable_IsImportStatement (unsigned int sym);

/*
   GetImportModule - returns the module associated with the import symbol.
*/

extern "C" unsigned int SymbolTable_GetImportModule (unsigned int sym);

/*
   GetImportDeclared - returns the token associated with the import symbol.
*/

extern "C" unsigned int SymbolTable_GetImportDeclared (unsigned int sym);

/*
   GetImportStatementList - returns the list of imports for this dependent.
                            Each import symbol corresponds to a module.
*/

extern "C" Lists_List SymbolTable_GetImportStatementList (unsigned int sym);

/*
   GetModuleDefImportStatementList - returns the list of dependents associated with
                                     the definition module.
*/

extern "C" Lists_List SymbolTable_GetModuleDefImportStatementList (unsigned int sym);

/*
   GetModuleModImportStatementList - returns the list of dependents associated with
                                     the implementation or program module.
*/

extern "C" Lists_List SymbolTable_GetModuleModImportStatementList (unsigned int sym);

/*
   AppendModuleImportStatement - appends the ImportStatement symbol onto the
                                 module import list.

                                 For example:

                                 FROM x IMPORT y, z ;
                                 ^^^^

                                 also:

                                 IMPORT p, q, r;
                                 ^^^^^^
                                 will result in a new ImportStatement symbol added
                                 to the current module import list.
                                 The statement symbol is expected to be created
                                 by MakeImportStatement using the token positions
                                 outlined above.
*/

extern "C" void SymbolTable_AppendModuleImportStatement (unsigned int module, unsigned int statement);

/*
   AppendModuleOnImportStatement - appends the import symbol onto the
                                   dependent list (chain).

                                   For example each:

                                   FROM x IMPORT y, z ;
                                        ^
                                   x are added to the dependent list.

                                   also:

                                   IMPORT p, q, r;
                                          ^  ^  ^
                                   will result in p, q and r added to
                                   to the dependent list.

                                   The import symbol is created by MakeImport
                                   and the token is expected to match the module
                                   name position outlined above.
*/

extern "C" void SymbolTable_AppendModuleOnImportStatement (unsigned int module, unsigned int import);

/*
   PutModLink - assigns link to module sym.
*/

extern "C" void SymbolTable_PutModLink (unsigned int sym, bool link);

/*
   IsModLink - returns the ModLink value associated with the module symbol.
*/

extern "C" bool SymbolTable_IsModLink (unsigned int sym);

/*
   PutDefLink - assigns link to the definition module sym.
*/

extern "C" void SymbolTable_PutDefLink (unsigned int sym, bool link);

/*
   IsDefLink - returns the DefLink value associated with the definition module symbol.
*/

extern "C" bool SymbolTable_IsDefLink (unsigned int sym);

/*
   IsModuleBuiltin - returns TRUE if the module is a builtin module.
                     (For example _BaseTypes).
*/

extern "C" bool SymbolTable_IsModuleBuiltin (unsigned int sym);

/*
   PutModuleBuiltin - sets the Builtin flag to value.
                      Currently the procedure expects sym to be a DefImp
                      module only.
*/

extern "C" void SymbolTable_PutModuleBuiltin (unsigned int sym, bool value);

/*
   PutVarArrayRef - assigns ArrayRef field with value.
*/

extern "C" void SymbolTable_PutVarArrayRef (unsigned int sym, bool value);

/*
   IsVarArrayRef - returns ArrayRef field value.
*/

extern "C" bool SymbolTable_IsVarArrayRef (unsigned int sym);

/*
   VarCheckReadInit - returns TRUE if sym has been initialized.
*/

extern "C" bool SymbolTable_VarCheckReadInit (unsigned int sym, SymbolTable_ModeOfAddr mode);

/*
   VarInitState - initializes the init state for variable sym.
*/

extern "C" void SymbolTable_VarInitState (unsigned int sym);

/*
   PutVarInitialized - set sym as initialized.
*/

extern "C" void SymbolTable_PutVarInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode);

/*
   PutVarFieldInitialized - records that field has been initialized with
                            variable sym.  TRUE is returned if the field
                            is detected and changed to initialized.
*/

extern "C" bool SymbolTable_PutVarFieldInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode, Lists_List fieldlist);

/*
   GetVarFieldInitialized - return TRUE if fieldlist has been initialized
                            within variable sym.
*/

extern "C" bool SymbolTable_GetVarFieldInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode, Lists_List fieldlist);

/*
   PrintInitialized - display variable sym initialization state.
*/

extern "C" void SymbolTable_PrintInitialized (unsigned int sym);

/*
   GetParameterHeapVar - return the heap variable associated with the
                         parameter or NulSym.
*/

extern "C" unsigned int SymbolTable_GetParameterHeapVar (unsigned int ParSym);

/*
   PutProcedureParameterHeapVars - creates heap variables for parameter sym.
*/

extern "C" void SymbolTable_PutProcedureParameterHeapVars (unsigned int sym);

/*
   IsProcedureBuiltinAvailable - return TRUE if procedure is available as a builtin
                                 for the target architecture.
*/

extern "C" bool SymbolTable_IsProcedureBuiltinAvailable (unsigned int procedure);

/*
   PutConstLitInternal - marks the sym as being an internal constant.
                         Currently this is used when generating a default
                         BY constant expression during a FOR loop.
                         A constant marked as internal will always pass
                         an expression type check.
*/

extern "C" void SymbolTable_PutConstLitInternal (unsigned int sym, bool value);

/*
   IsConstLitInternal - returns the value of the IsInternal field within
                        a constant expression.
*/

extern "C" bool SymbolTable_IsConstLitInternal (unsigned int sym);

/*
   GetVarDeclTypeTok - returns the TypeTok field associate with variable sym.
*/

extern "C" unsigned int SymbolTable_GetVarDeclTypeTok (unsigned int sym);

/*
   PutVarDeclTypeTok - assigns the TypeTok field to typetok.
                       sym can be a variable or parameter.
*/

extern "C" void SymbolTable_PutVarDeclTypeTok (unsigned int sym, unsigned int typetok);

/*
   GetVarDeclTok - returns the TypeTok field associate with variable sym.
*/

extern "C" unsigned int SymbolTable_GetVarDeclTok (unsigned int sym);

/*
   PutVarDeclTok - assigns the VarTok field to typetok.
                   sym can be a variable or parameter.
*/

extern "C" void SymbolTable_PutVarDeclTok (unsigned int sym, unsigned int vartok);

/*
   GetVarDeclFullTok - returns the full virtual token containing var: type.
*/

extern "C" unsigned int SymbolTable_GetVarDeclFullTok (unsigned int sym);

/*
   IsProcedureAnyNoReturn - return TRUE if any of the defined kinds
                            of procedure sym is declared no return.
*/

extern "C" bool SymbolTable_IsProcedureAnyNoReturn (unsigned int sym);

/*
   GetNthParamAny - returns the nth parameter from the order
                    proper procedure, forward declaration
                    or definition module procedure.
*/

extern "C" unsigned int SymbolTable_GetNthParamAny (unsigned int sym, unsigned int ParamNo);

/*
   NoOfParamAny - return the number of parameters for sym.
*/

extern "C" unsigned int SymbolTable_NoOfParamAny (unsigned int sym);

/*
   SetReturnOptional - sets the ReturnOptional field in the Procedure:kind or
                       ProcType symboltable entry.
*/

extern "C" void SymbolTable_SetReturnOptional (unsigned int sym, SymbolTable_ProcedureKind kind, bool isopt);

/*
   UsesOptArgAny - returns TRUE if procedure Sym:kind uses an optional argument.
*/

extern "C" bool SymbolTable_UsesOptArgAny (unsigned int Sym);

/*
   GetProcedureKindDesc - return a string describing kind.
*/

extern "C" DynamicStrings_String SymbolTable_GetProcedureKindDesc (SymbolTable_ProcedureKind kind);

/*
   GetNthParamAnyClosest - returns the nth parameter from the order
                           proper procedure, forward declaration
                           or definition module procedure.
                           It chooses the parameter which is closest
                           in source terms to currentmodule.
                           The same module will return using the order
                           proper procedure, forward procedure, definition module.
                           Whereas an imported procedure will choose from
                           DefProcedure, ProperProcedure, ForwardProcedure.
*/

extern "C" unsigned int SymbolTable_GetNthParamAnyClosest (unsigned int sym, unsigned int ParamNo, unsigned int currentmodule);
static void InitWhereDeclaredTok (unsigned int tok, SymbolTable_Where *at);

/*
   InitWhereDeclared - sets the Declared and FirstUsed fields of record, at.
*/

static void InitWhereDeclared (SymbolTable_Where *at);

/*
   InitWhereFirstUsed - sets the FirstUsed field of record, at.
*/

static void InitWhereFirstUsed (SymbolTable_Where *at);

/*
   InitWhereFirstUsedTok - sets the FirstUsed field of record, at.
*/

static void InitWhereFirstUsedTok (unsigned int tok, SymbolTable_Where *at);

/*
   gdbhook - a debugger convenience hook.
*/

static void gdbhook (void);

/*
   BreakWhenSymCreated - to be called interactively by gdb.
*/

static void BreakWhenSymCreated (unsigned int sym);

/*
   CheckBreak - if sym = BreakSym then call gdbhook.
*/

static void CheckBreak (unsigned int sym);

/*
   NewSym - Sets Sym to a new symbol index.
*/

static void NewSym (unsigned int *sym);

/*
   GetPsym - returns the pointer to, sym.
*/

static SymbolTable_PtrToSymbol GetPsym (unsigned int sym);

/*
   GetPcall - returns the pointer to the CallFrame.
*/

static SymbolTable_PtrToCallFrame GetPcall (unsigned int call);

/*
   DebugProcedureLineNumber -
*/

static void DebugProcedureLineNumber (unsigned int sym);

/*
   PutPartialUnbounded -
*/

static void PutPartialUnbounded (unsigned int sym, unsigned int type, unsigned int ndim);

/*
   AlreadyDeclaredError - generate an error message, a, and two areas of code showing
                          the places where the symbols were declared.
*/

static void AlreadyDeclaredError (DynamicStrings_String s, NameKey_Name name, unsigned int OtherOccurance);

/*
   MakeObject - creates an object node.
*/

static unsigned int MakeObject (NameKey_Name name);

/*
   DeclareSym - returns a symbol which was either in the unknown tree or
                a New symbol, since name is about to be declared.
*/

static unsigned int DeclareSym (unsigned int tok, NameKey_Name name);

/*
   Init - Initializes the data structures and variables in this module.
          Initialize the trees.
*/

static void Init (void);

/*
   AddSymToUnknown -
*/

static void AddSymToUnknown (unsigned int scope, NameKey_Name name, unsigned int Sym);

/*
   AddSymToUnknownTree - adds a symbol with name, name, and Sym to the
                         unknown tree.
*/

static void AddSymToUnknownTree (int ScopeId, NameKey_Name name, unsigned int Sym);

/*
   SubSymFromUnknownTree - removes a symbol with name, name, from the
                           unknown tree.
*/

static void SubSymFromUnknownTree (NameKey_Name name);

/*
   GetSymFromUnknownTree - returns a symbol with name, name, from the
                           unknown tree.
                           If no symbol with name is found then NulSym
                           is returned.
*/

static unsigned int GetSymFromUnknownTree (NameKey_Name name);

/*
   ExamineUnresolvedTree - returns a symbol with name, name, from the
                           unresolved tree of module, ModSym.
                           If no symbol with name is found then NulSym
                           is returned.
*/

static unsigned int ExamineUnresolvedTree (unsigned int ScopeSym, NameKey_Name name);

/*
   RemoveFromUnresolvedTree - removes a symbol with name, name, from the
                              unresolved tree of symbol, ScopeSym.
*/

static bool RemoveFromUnresolvedTree (unsigned int ScopeSym, NameKey_Name name);

/*
   FetchUnknownSym - returns a symbol from the unknown tree if one is
                     available. It also updates the unknown tree.
*/

static unsigned int FetchUnknownSym (NameKey_Name name);

/*
   TransparentScope - returns true is the scope symbol Sym is allowed
                      to look to an outer level for a symbol.
                      ie is the symbol allowed to look to the parent
                      scope for a symbol.
*/

static bool TransparentScope (unsigned int Sym);

/*
   GetLastModuleOrProcedureScope - returns the last module or procedure scope encountered,
                                   the scope before the current module scope.
*/

static unsigned int GetLastModuleOrProcedureScope (void);

/*
   AddSymToScope - adds a symbol Sym with name name to
                   the current scope symbol tree.
*/

static void AddSymToScope (unsigned int Sym, NameKey_Name name);

/*
   PlaceMajorScopesEnumerationListOntoStack - places the DefImp, Module and
                                              Procedure symbols enumeration
                                              list onto the scope stack.
*/

static void PlaceMajorScopesEnumerationListOntoStack (unsigned int Sym);

/*
   PlaceEnumerationListOntoScope - places an enumeration list, l, onto the
                                   scope stack. This list will automatically
                                   removed via one call to EndScope which
                                   matches the StartScope by which this
                                   procedure is invoked.
*/

static void PlaceEnumerationListOntoScope (Lists_List l);

/*
   SetFirstUsed - assigns the FirstUsed field in at to tok providing
                  it has not already been set.
*/

static void SetFirstUsed (unsigned int tok, SymbolTable_Where *at);

/*
   PutFirstUsed - sets tok to the first used providing it has not already been set.
                  It also includes the read and write quad into the usage list
                  providing the quad numbers are not 0.
*/

static void PutFirstUsed (unsigned int object, unsigned int tok, unsigned int read_, unsigned int write_);

/*
   CanLookThroughScope - by default this procedure returns TRUE.  It only returns
                         FALSE if, throughProcedure, is FALSE and the ScopeSym is
                         a procedure.
*/

static bool CanLookThroughScope (unsigned int ScopeSym, bool throughProcedure);

/*
   GetScopeSym - searches the current scope and below, providing that the
                 scopes are transparent, for a symbol with name, name.
                 It only passes over procedure scopes if, throughProcedure,
                 is TRUE.
*/

static unsigned int GetScopeSym (NameKey_Name name, bool throughProcedure);

/*
   CheckScopeForSym - checks the scope, ScopeSym, for an identifier
                      of name, name. CheckScopeForSym checks for
                      the symbol by the GetLocalSym and also
                      ExamineUnresolvedTree.
*/

static unsigned int CheckScopeForSym (unsigned int ScopeSym, NameKey_Name name);

/*
   GetModuleScopeId - returns the scope index to the next module starting
                      at index, Id.
                      Id will either point to a null scope (NulSym) or
                      alternatively point to a Module or DefImp symbol.
*/

static unsigned int GetModuleScopeId (unsigned int Id);

/*
   GetVisibleSym -
*/

static unsigned int GetVisibleSym (NameKey_Name name);

/*
   IsAlreadyDeclaredSym - returns true if Sym has already been declared
                          in the current main scope.
*/

static bool IsAlreadyDeclaredSym (NameKey_Name name);

/*
   GenName - returns a new name consisting of pre, name, post concatenation.
*/

static NameKey_Name GenName (NameKey_Name libname, const char *pre_, unsigned int _pre_high, NameKey_Name name, const char *post_, unsigned int _post_high);

/*
   InitCtor - initialize the ModuleCtor fields to NulSym.
*/

static void InitCtor (SymbolTable_ModuleCtor *ctor);

/*
   InitCtorFields - initialize the ModuleCtor fields.  An inner module has no
                    ctor procedure.
*/

static void InitCtorFields (unsigned int moduleTok, unsigned int beginTok, unsigned int finallyTok, unsigned int moduleSym, SymbolTable_ModuleCtor *ctor, NameKey_Name name, bool inner, bool pub);

/*
   CheckTok - checks to see that tok is at a known location.  If not
              it uses GetTokenNo as a fall back.
*/

static unsigned int CheckTok (unsigned int tok, const char *name_, unsigned int _name_high);

/*
   GetLink - returns TRUE if the current module is only used for linkage.
*/

static bool GetLink (void);

/*
   AddModuleToParent - adds symbol, Sym, to module, Parent.
*/

static void AddModuleToParent (unsigned int Sym, unsigned int Parent);

/*
   PutProcedureExternPublic - if procedure is not NulSym set extern
                              and public booleans.
*/

static void PutProcedureExternPublic (unsigned int procedure, bool extern_, bool pub);

/*
   PutCtorExtern -
*/

static void PutCtorExtern (unsigned int tok, unsigned int sym, SymbolTable_ModuleCtor *ctor, bool extern_);

/*
   InitProcedureDeclaration - initialize all the ProcedureDeclaration
                              fields.
*/

static void InitProcedureDeclaration (SymbolTable_ProcedureDeclaration *decl);

/*
   AddProcedureToList - adds a procedure, Proc, to the list of procedures
                        in module, Mod.
*/

static void AddProcedureToList (unsigned int Mod, unsigned int Proc);

/*
   AddVarToScopeList - adds symbol, sym, to, scope.
*/

static void AddVarToScopeList (unsigned int scope, unsigned int sym);

/*
   AddVarToList - add a variable symbol to the list of variables maintained
                  by the inner most scope. (Procedure or Module).
*/

static void AddVarToList (unsigned int Sym);

/*
   InitVarDecl - initialize the variable and type token location positions.
*/

static void InitVarDecl (SymbolTable_VarDecl *decl, unsigned int vartok);

/*
   doPutVarDeclTypeTok - places typetok into decl.TypeTok.
                         sym must be a variable.
*/

static void doPutVarDeclTypeTok (unsigned int sym, unsigned int typetok);

/*
   doPutVarDeclTok - places vartok into decl.VarTok.
                     sym must be a variable.
*/

static void doPutVarDeclTok (unsigned int sym, unsigned int vartok);

/*
   doGetVarDeclTok - return decl.VarTok for a variable.
*/

static unsigned int doGetVarDeclTok (unsigned int sym);

/*
   doGetVarDeclTypeTok - return decl.TypeTok for a variable.
*/

static unsigned int doGetVarDeclTypeTok (unsigned int sym);

/*
   doGetVarDeclFullTok - return the full declaration of var: type.
*/

static unsigned int doGetVarDeclFullTok (unsigned int sym);

/*
   FillInRecordFields - given a new symbol, sym, make it a record symbol
                        and initialize its fields.
*/

static void FillInRecordFields (unsigned int tok, unsigned int sym, NameKey_Name RecordName, unsigned int scope, unsigned int oaf);

/*
   HandleHiddenOrDeclare -
*/

static unsigned int HandleHiddenOrDeclare (unsigned int tok, NameKey_Name name, unsigned int *oaf);

/*
   CreateConstLit -
*/

static unsigned int CreateConstLit (unsigned int tok, NameKey_Name constName, unsigned int constType);

/*
   LookupConstLitPoolEntry - return a ConstLit symbol from the constant pool which
                             matches tok, constName and constType.
*/

static unsigned int LookupConstLitPoolEntry (unsigned int tok, NameKey_Name constName, unsigned int constType);

/*
   AddConstLitPoolEntry - adds sym to the constlit pool.
*/

static void AddConstLitPoolEntry (unsigned int sym, unsigned int tok, NameKey_Name constName, unsigned int constType);

/*
   InitConstString - initialize the constant string.
*/

static void InitConstString (unsigned int tok, unsigned int sym, NameKey_Name name, NameKey_Name contents, SymbolTable_ConstStringVariant kind, bool escape, bool known);

/*
   GetConstStringKind - return the StringVariant field associated with sym.
*/

static SymbolTable_ConstStringVariant GetConstStringKind (unsigned int sym);

/*
   CanUseBuiltin - returns TRUE if the procedure, Sym, can be
                   inlined via a builtin function.
*/

static bool CanUseBuiltin (unsigned int Sym);

/*
   InitPacked - initialise packedInfo to FALSE and NulSym.
*/

static void InitPacked (SymbolTable_PackedInfo *packedInfo);

/*
   doEquivalent - create a packed equivalent symbol for, sym, and return the
                  new symbol.  It sets both fields in packedInfo to FALSE
                  and the new symbol.
*/

static unsigned int doEquivalent (SymbolTable_PackedInfo *packedInfo, unsigned int sym);

/*
   MakeEquivalent - return the equivalent packed symbol for, sym.
*/

static unsigned int MakeEquivalent (unsigned int sym);

/*
   GetEquivalent -
*/

static unsigned int GetEquivalent (SymbolTable_PackedInfo *packedInfo, unsigned int sym);

/*
   doGetType - subsiduary helper procedure function of GetDType, GetSType and GetLType.
*/

static unsigned int doGetType (unsigned int sym, bool skipEquiv, bool skipAlign, bool skipHidden, bool skipBase);

/*
   GetTypeOfVar - returns the type of symbol, var.
*/

static unsigned int GetTypeOfVar (unsigned int var);

/*
   GetConstLitType - returns the type of the constant of, name.
                     All floating point constants have type LONGREAL.
                     Character constants are type CHAR.
                     Integer values are INTEGER, LONGINT or LONGCARD
                     depending upon their value.
*/

static unsigned int GetConstLitType (unsigned int tok, NameKey_Name name, bool *overflow, bool issueError);

/*
   GetNthFromComponent -
*/

static unsigned int GetNthFromComponent (unsigned int Sym, unsigned int n);

/*
   GetNthParamChoice - returns the parameter definition from
                       sym:ParamNo:kind or NulSym.
*/

static unsigned int GetNthParamChoice (unsigned int sym, unsigned int ParamNo, SymbolTable_ProcedureKind kind);

/*
   GetNthParamOrdered - returns the parameter definition from list {a, b, c}
                        in order.
                        sym:ParamNo:{a,b,c} or NulSym.
*/

static unsigned int GetNthParamOrdered (unsigned int sym, unsigned int ParamNo, SymbolTable_ProcedureKind a, SymbolTable_ProcedureKind b, SymbolTable_ProcedureKind c);

/*
   GetOuterModuleScope - returns the outer module symbol scope for sym.
*/

static unsigned int GetOuterModuleScope (unsigned int sym);

/*
   EnsureOrder - providing that both symbols, a, and, b, exist in
                 list, l.  Ensure that, b, is placed after a.
*/

static void EnsureOrder (Lists_List l, unsigned int a, unsigned int b);

/*
   DumpSons -
*/

static void DumpSons (unsigned int sym);

/*
   CheckListOfSons - checks to see that sym, is present in, recordConsist, ListOfSons.
*/

static void CheckListOfSons (unsigned int sym);

/*
   CheckRecordConsistency -
*/

static void CheckRecordConsistency (unsigned int sym);

/*
   PutConstVarTemporary - indicates that constant, sym, is a temporary.
*/

static void PutConstVarTemporary (unsigned int sym);

/*
   buildTemporary - builds the temporary filling in componentRef, record and sets mode.
*/

static unsigned int buildTemporary (unsigned int tok, SymbolTable_ModeOfAddr Mode, bool componentRef, unsigned int record);

/*
   AssertInRange - determines whether the Sym is a legal symbol.
*/

static void AssertInRange (unsigned int Sym);

/*
   CheckForHiddenType - scans the NeedToBeImplemented tree providing
                        that we are currently compiling an implementation
                        module. If a symbol is found with TypeName
                        then its Sym is returned.
                        Otherwise NulSym is returned.
                        CheckForHiddenType is called before any type is
                        created, therefore the compiler allows hidden
                        types to be implemented using any type.
*/

static unsigned int CheckForHiddenType (NameKey_Name TypeName);

/*
   RequestFromModule - returns a symbol from module ModSym with name, SymName.
*/

static unsigned int RequestFromModule (unsigned int tok, unsigned int ModSym, NameKey_Name SymName);

/*
   RequestFromDefinition - returns a symbol from module ModSym with name,
                           SymName.
*/

static unsigned int RequestFromDefinition (unsigned int tok, unsigned int ModSym, NameKey_Name SymName);

/*
   GetWhereImported - returns the token number where this symbol
                      was imported into the current module.
*/

static unsigned int GetWhereImported (unsigned int Sym);

/*
   DisplayName - displays the name.
*/

static void DisplayName (unsigned int sym);

/*
   DisplaySymbol - displays the name of a symbol
*/

static void DisplaySymbol (unsigned int sym);

/*
   FetchUnknownFromModule - returns an Unknown symbol from module, ModSym.
*/

static unsigned int FetchUnknownFromModule (unsigned int tok, unsigned int ModSym, NameKey_Name SymName);

/*
   FetchUnknownFromDefImp - returns an Unknown symbol from module, ModSym.
*/

static unsigned int FetchUnknownFromDefImp (unsigned int tok, unsigned int ModSym, NameKey_Name SymName);

/*
   FetchUnknownFromDefImp - returns an Unknown symbol from module, ModSym.
*/

static unsigned int FetchUnknownFrom (unsigned int tok, unsigned int scope, NameKey_Name SymName);

/*
   UnknownSymbolError - displays symbol name for symbol, sym.
*/

static void UnknownSymbolError (unsigned int sym);

/*
   IsUnreportedUnknown - returns TRUE if symbol, sym, has not been
                         reported and is an unknown symbol.
*/

static bool IsUnreportedUnknown (unsigned int sym);

/*
   AddListify -
*/

static void AddListify (unsigned int sym);

/*
   Listify - convert tree into a string list and return the result.
*/

static DynamicStrings_String Listify (SymbolKey_SymbolTree tree, SymbolKey_IsSymbol isCondition);

/*
   CheckForUnknowns - checks a binary tree, Tree, to see whether it contains
                      an unknown symbol. All unknown symbols are displayed
                      together with an error message.
*/

static void CheckForUnknowns (NameKey_Name name, SymbolKey_SymbolTree Tree, const char *a_, unsigned int _a_high);

/*
   SymbolError - displays symbol name for symbol, Sym.
*/

static void SymbolError (unsigned int Sym);

/*
   CheckForSymbols  - checks a binary tree, Tree, to see whether it contains
                      any symbol. The tree is expected to be empty, if not
                      then an error has occurred.
*/

static void CheckForSymbols (SymbolKey_SymbolTree Tree, const char *a_, unsigned int _a_high);

/*
   PutExportUndeclared - places a symbol, Sym, into module, ModSym,
                         ExportUndeclared list provided that Sym
                         is unknown.
*/

static void PutExportUndeclared (unsigned int ModSym, unsigned int Sym);

/*
   GetExportUndeclared - returns a symbol which has, name, from module, ModSym,
                         which is in the ExportUndeclared list.
*/

static unsigned int GetExportUndeclared (unsigned int ModSym, NameKey_Name name);

/*
   RemoveExportUndeclared - removes a symbol, Sym, from the module, ModSym,
                            ExportUndeclaredTree.
*/

static void RemoveExportUndeclared (unsigned int ModSym, unsigned int Sym);

/*
   CheckForExportedDeclaration - checks to see whether a definition module
                                 is currently being compiled, if so,
                                 symbol, Sym, is removed from the
                                 ExportUndeclared list.
                                 This procedure is called whenever a symbol
                                 is declared, thus attempting to reduce
                                 the ExportUndeclared list.
*/

static void CheckForExportedDeclaration (unsigned int Sym);

/*
   UndeclaredSymbolError - displays symbol name for symbol, Sym.
*/

static void UndeclaredSymbolError (unsigned int Sym);

/*
   RemoveExportUnImplemented - removes a symbol, Sym, from the module, ModSym,
                               NeedToBeImplemented list.
*/

static void RemoveExportUnImplemented (unsigned int ModSym, unsigned int Sym);

/*
   RemoveFromExportRequest -
*/

static void RemoveFromExportRequest (unsigned int Sym);

/*
   RemoveEnumerationFromExportRequest - removes enumeration symbol, sym,
                                        (and its fields) from the ExportRequest tree.
*/

static void RemoveEnumerationFromExportRequest (unsigned int ModSym, unsigned int Sym);

/*
   UnImplementedSymbolError - displays symbol name for symbol, Sym.
*/

static void UnImplementedSymbolError (unsigned int Sym);

/*
   CheckEnumerationInList - places symbol, Sym, in the list, l,
                            providing it does not already exist.
                            PseudoScope(Sym) is called if Sym needs to
                            be added to the enumeration list, l.
*/

static void CheckEnumerationInList (Lists_List l, unsigned int Sym);

/*
   CheckIfEnumerationExported - An outer module may use an enumeration that
                                is declared inside an inner module. The usage
                                may occur before definition. The first pass
                                exports a symbol, later the symbol is declared
                                as an emumeration type. At this stage the
                                CheckIfEnumerationExported procedure should be
                                called. This procedure ripples from the current
                                (inner) module to outer module and every time
                                it is exported it must be added to the outer
                                module EnumerationScopeList.
*/

static void CheckIfEnumerationExported (unsigned int Sym, unsigned int ScopeId);

/*
   CheckForEnumerationInOuterModule - checks to see whether the enumeration
                                      type symbol, Sym, has been entered into
                                      the outer module, OuterModule, scope list.
                                      OuterModule may be internal to the
                                      program module.
*/

static void CheckForEnumerationInOuterModule (unsigned int Sym, unsigned int OuterModule);

/*
   MakeVariableForParam -
*/

static unsigned int MakeVariableForParam (unsigned int tok, NameKey_Name ParamName, unsigned int ProcSym, SymbolTable_ProcedureKind kind, unsigned int no, unsigned int ParmType, unsigned int typetok);

/*
   AddParameter - adds a parameter ParSym to a procedure Sym.
*/

static void AddParameter (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParSym);

/*
   AddProcedureProcTypeParam - adds ParamType to the parameter ProcType
                               associated with procedure Sym.
*/

static void AddProcedureProcTypeParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded, bool isVarParam);

/*
   IsNthParamVar - returns true if the n th parameter of the parameter list,
                   List, is a VAR parameter.
*/

static bool IsNthParamVar (Lists_List Head, unsigned int n);

/*
   MakeParameterHeapVar - create a heap variable if sym is a pointer.
*/

static unsigned int MakeParameterHeapVar (unsigned int tok, unsigned int type, SymbolTable_ModeOfAddr mode);

/*
   PutParameterHeapVar - creates a heap variable associated with parameter sym.
*/

static void PutParameterHeapVar (unsigned int sym);

/*
   IsProcedureAnyBoolean - returns the boolean result from p
                           for any of procedure kind which is defined.
*/

static bool IsProcedureAnyBoolean (unsigned int sym, SymbolTable_ProcAnyBoolean p);

/*
   IsProcedureAnyDefaultBoolean - returns the boolean result from p
                                  for any of procedure kind which is defined.
*/

static bool IsProcedureAnyDefaultBoolean (unsigned int sym, bool default_, SymbolTable_ProcAnyBoolean p);

/*
   FillInUnknownFields -
*/

static void FillInUnknownFields (unsigned int tok, unsigned int sym, NameKey_Name SymName);

/*
   FillInPointerFields - given a new symbol, sym, make it a pointer symbol
                         and initialize its fields.
*/

static void FillInPointerFields (unsigned int Sym, NameKey_Name PointerName, unsigned int scope, unsigned int oaf);

/*
   ForeachParameterDo -
*/

static void ForeachParameterDo (SymbolTable_CheckProcedure p);

/*
   CheckUnbounded - checks to see if parameter, Sym, is now an unbounded parameter.
*/

static void CheckUnbounded (unsigned int Sym);

/*
   PutOAFamily - places the, oaf, into, SimpleType, oafamily field.
*/

static void PutOAFamily (unsigned int SimpleType, unsigned int oaf);

/*
   doFillInOAFamily -
*/

static void doFillInOAFamily (unsigned int oaf, unsigned int i, unsigned int unbounded);

/*
   FillInUnboundedFields -
*/

static void FillInUnboundedFields (unsigned int tok, unsigned int sym, unsigned int SimpleType, unsigned int ndim);

/*
   PutUnbounded - associates the unbounded symbol, open, with
                  SimpleType.
*/

static void PutUnbounded (unsigned int oaf, unsigned int sym, unsigned int ndim);

/*
   GetArrayDimension - returns the number of dimensions defined.
*/

static unsigned int GetArrayDimension (unsigned int sym);

/*
   ResolveConstructorType - if, sym, has an unresolved constructor type
                            then attempt to resolve it by examining the
                            from, type.
*/

static void ResolveConstructorType (unsigned int sym, unsigned int *type, unsigned int *from, bool *unres);

/*
   IsConstructorResolved - returns TRUE if the constructor does not
                           have an unresolved type.
*/

static bool IsConstructorResolved (unsigned int sym);

/*
   CanResolveConstructor - returns TRUE if the type of the constructor,
                           sym, is known.
*/

static bool CanResolveConstructor (unsigned int sym);

/*
   CheckAllConstructorsResolved - checks to see that the
                                  UnresolvedConstructorType list is
                                  empty and if it is not then it
                                  generates error messages.
*/

static void CheckAllConstructorsResolved (void);

/*
   SanityCheckParameters -
*/

static void SanityCheckParameters (unsigned int sym);

/*
   SanityCheckArray - checks to see that an array has a correct subrange type.
*/

static void SanityCheckArray (unsigned int sym);

/*
   ForeachSymbolDo - foreach symbol, call, P(sym).
*/

static void ForeachSymbolDo (SymbolKey_PerformOperation P);

/*
   SanityCheckProcedure - check to see that procedure parameters do not use constants
                          instead of types in their formal parameter section.
*/

static void SanityCheckProcedure (unsigned int sym);

/*
   SanityCheckModule -
*/

static void SanityCheckModule (unsigned int sym);

/*
   AddNameTo - adds Name, n, to tree, s.
*/

static void AddNameTo (SymbolKey_SymbolTree s, unsigned int o);

/*
   CollectSymbolFrom -
*/

static unsigned int CollectSymbolFrom (unsigned int tok, unsigned int scope, NameKey_Name n);

/*
   CollectUnknown -
*/

static unsigned int CollectUnknown (unsigned int tok, unsigned int sym, NameKey_Name n);

/*
   ResolveImport -
*/

static void ResolveImport (unsigned int o);

/*
   ResolveRelativeImport -
*/

static void ResolveRelativeImport (unsigned int sym);

/*
   Max -
*/

static unsigned int Max (unsigned int a, unsigned int b);

/*
   Min -
*/

static unsigned int Min (unsigned int a, unsigned int b);

/*
   DoFindLimits - assigns, Start, and, End, to the start and end
                  limits contained in the list, l.  It ensures that
                  Start and End are within StartLimit..EndLimit.
                  If StartLimit or EndLimit are 0 then Start is
                  is set to the first value and End to the last.
*/

static void DoFindLimits (unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End, Lists_List l);

/*
   PutDeclaredDefinition - associates the current tokenno with
                           the symbols declaration in the definition
                           module.
*/

static void PutDeclaredDefinition (unsigned int tok, unsigned int Sym);

/*
   PutDeclaredModule - returns the token where this symbol was declared
                       in an implementation or program module.
*/

static void PutDeclaredModule (unsigned int tok, unsigned int Sym);

/*
   DoIsConst - returns TRUE if Sym is defined as a constant
               or is an enumeration field or string.
*/

static bool DoIsConst (unsigned int Sym);

/*
   GetFromIndex - return a value from list, i, at position, n.
*/

static unsigned int GetFromIndex (Indexing_Index i, unsigned int n);

/*
   PutIntoIndex - places value, v, into list, i, at position, n.
*/

static void PutIntoIndex (Indexing_Index *i, unsigned int n, unsigned int v);

/*
   PushConstString - pushes the character string onto the ALU stack.
                     It assumes that the character string is only
                     one character long.
*/

static void PushConstString (unsigned int Sym);

static void InitWhereDeclaredTok (unsigned int tok, SymbolTable_Where *at)
{
  /* 
   InitWhereDeclared - sets the Declared and FirstUsed fields of record, at.
  */
  if (M2Comp_CompilingDefinitionModule ())
    {
      (*at).DefDeclared = tok;
      (*at).ModDeclared = M2LexBuf_UnknownTokenNo;
    }
  else
    {
      (*at).DefDeclared = M2LexBuf_UnknownTokenNo;
      (*at).ModDeclared = tok;
    }
  (*at).FirstUsed = tok;  /* we assign this field to something legal  */
}


/*
   InitWhereDeclared - sets the Declared and FirstUsed fields of record, at.
*/

static void InitWhereDeclared (SymbolTable_Where *at)
{
  InitWhereDeclaredTok (M2LexBuf_GetTokenNo (), at);
}


/*
   InitWhereFirstUsed - sets the FirstUsed field of record, at.
*/

static void InitWhereFirstUsed (SymbolTable_Where *at)
{
  InitWhereFirstUsedTok (M2LexBuf_GetTokenNo (), at);
}


/*
   InitWhereFirstUsedTok - sets the FirstUsed field of record, at.
*/

static void InitWhereFirstUsedTok (unsigned int tok, SymbolTable_Where *at)
{
  (*at).FirstUsed = tok;
}


/*
   gdbhook - a debugger convenience hook.
*/

static void gdbhook (void)
{
}


/*
   BreakWhenSymCreated - to be called interactively by gdb.
*/

static void BreakWhenSymCreated (unsigned int sym)
{
  BreakSym = sym;
}


/*
   CheckBreak - if sym = BreakSym then call gdbhook.
*/

static void CheckBreak (unsigned int sym)
{
  if (sym == BreakSym)
    {
      gdbhook ();
    }
}


/*
   NewSym - Sets Sym to a new symbol index.
*/

static void NewSym (unsigned int *sym)
{
  SymbolTable_PtrToSymbol pSym;

  (*sym) = FreeSymbol;
  Storage_ALLOCATE ((void **) &pSym, sizeof (SymbolTable_Symbol));
  pSym->SymbolType = SymbolTable_DummySym;
  Indexing_PutIndice (Symbols, (*sym), reinterpret_cast <void *> (pSym));
  CheckBreak ((*sym));
  FreeSymbol += 1;
}


/*
   GetPsym - returns the pointer to, sym.
*/

static SymbolTable_PtrToSymbol GetPsym (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (Indexing_InBounds (Symbols, sym))
    {
      pSym = static_cast<SymbolTable_PtrToSymbol> (Indexing_GetIndice (Symbols, sym));
      return pSym;
    }
  else
    {
      M2Error_InternalError ((const char *) "symbol out of bounds", 20);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetPcall - returns the pointer to the CallFrame.
*/

static SymbolTable_PtrToCallFrame GetPcall (unsigned int call)
{
  SymbolTable_PtrToCallFrame pCall;

  if (Indexing_InBounds (ScopeCallFrame, call))
    {
      pCall = static_cast<SymbolTable_PtrToCallFrame> (Indexing_GetIndice (ScopeCallFrame, call));
      return pCall;
    }
  else
    {
      M2Error_InternalError ((const char *) "symbol out of bounds", 20);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   DebugProcedureLineNumber -
*/

static void DebugProcedureLineNumber (unsigned int sym)
{
  unsigned int begin;
  unsigned int end;
  NameKey_Name n;
  DynamicStrings_String f;
  unsigned int l;

  SymbolTable_GetProcedureBeginEnd (sym, &begin, &end);
  n = SymbolTable_GetSymName (sym);
  if (begin != 0)
    {
      f = M2LexBuf_FindFileNameFromToken (begin, 0);
      l = M2LexBuf_TokenToLineNo (begin, 0);
      M2Printf_printf3 ((const char *) "%s:%d:%a:begin\\n", 16, (const unsigned char *) &f, (sizeof (f)-1), (const unsigned char *) &l, (sizeof (l)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  if (end != 0)
    {
      f = M2LexBuf_FindFileNameFromToken (end, 0);
      l = M2LexBuf_TokenToLineNo (end, 0);
      M2Printf_printf3 ((const char *) "%s:%d:%a:end\\n", 14, (const unsigned char *) &f, (sizeof (f)-1), (const unsigned char *) &l, (sizeof (l)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
}


/*
   PutPartialUnbounded -
*/

static void PutPartialUnbounded (unsigned int sym, unsigned int type, unsigned int ndim)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  if (SymbolTable_IsDummy (sym))
    {
      pSym->SymbolType = SymbolTable_PartialUnboundedSym;
    }
  switch (pSym->SymbolType)
    {
      case SymbolTable_PartialUnboundedSym:
        pSym->PartialUnbounded.Type = type;
        pSym->PartialUnbounded.NDim = ndim;
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this type", 23);
        break;
    }
}


/*
   AlreadyDeclaredError - generate an error message, a, and two areas of code showing
                          the places where the symbols were declared.
*/

static void AlreadyDeclaredError (DynamicStrings_String s, NameKey_Name name, unsigned int OtherOccurance)
{
  M2Error_Error e;

  if ((OtherOccurance == 0) || (OtherOccurance == (M2LexBuf_GetTokenNo ())))
    {
      e = M2Error_NewError (M2LexBuf_GetTokenNo ());
      M2Error_ErrorString (e, s);
    }
  else
    {
      e = M2Error_NewError (M2LexBuf_GetTokenNo ());
      M2Error_ErrorString (e, s);
      e = M2Error_ChainError (OtherOccurance, e);
      M2Error_ErrorFormat1 (e, (const char *) "and symbol (%a) is also declared here", 37, (const unsigned char *) &name, (sizeof (name)-1));
    }
}


/*
   MakeObject - creates an object node.
*/

static unsigned int MakeObject (NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_ObjectSym;
  pSym->Object.name = name;
  InitWhereDeclared (&pSym->Object.At);
  InitWhereFirstUsed (&pSym->Object.At);
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DeclareSym - returns a symbol which was either in the unknown tree or
                a New symbol, since name is about to be declared.
*/

static unsigned int DeclareSym (unsigned int tok, NameKey_Name name)
{
  unsigned int Sym;

  if (name == NameKey_NulName)
    {
      NewSym (&Sym);
    }
  else if (IsAlreadyDeclaredSym (name))
    {
      /* avoid dangling else.  */
      Sym = SymbolTable_GetSym (name);
      if (SymbolTable_IsImported (SymbolTable_GetCurrentModuleScope (), Sym))
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT1 (GetWhereImported (Sym), (const char *) "symbol {%1Rad} is already present in this scope, check both definition and implementation modules, use a different name or remove the import", 140, Sym);
          M2MetaError_MetaErrorT1 (tok, (const char *) "symbol {%1Cad} also declared in this module", 43, Sym);
          if (Sym != (GetVisibleSym (name)))
            {
              M2MetaError_MetaErrorT1 (tok, (const char *) "symbol {%1CMad} also declared in this module", 44, GetVisibleSym (name));
            }
        }
      else
        {
          M2MetaError_MetaErrorT1 (tok, (const char *) "symbol {%1RMad} is already declared in this scope, use a different name or remove the declaration", 97, Sym);
          M2MetaError_MetaErrorT1 (tok, (const char *) "symbol {%1Cad} also declared in this module", 43, Sym);
          if (Sym != (GetVisibleSym (name)))
            {
              M2MetaError_MetaErrorT1 (tok, (const char *) "symbol {%1CMad} also declared in this module", 44, GetVisibleSym (name));
            }
        }
      Sym = SymbolTable_MakeError (tok, name);
    }
  else
    {
      /* avoid dangling else.  */
      Sym = FetchUnknownSym (name);
      if (Sym == SymbolTable_NulSym)
        {
          NewSym (&Sym);
        }
      CheckForExportedDeclaration (Sym);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Init - Initializes the data structures and variables in this module.
          Initialize the trees.
*/

static void Init (void)
{
  SymbolTable_PtrToCallFrame pCall;

  BreakWhenSymCreated (SymbolTable_NulSym);  /* Disable the intereactive sym watch.  */
  /* To examine the symbol table when a symbol is created run cc1gm2 from gdb
      and set a break point on gdbhook.
      (gdb) break gdbhook
      (gdb) run
      Now below interactively call BreakWhenSymCreated with the symbol
      under investigation.  */
  gdbhook ();
  /* Now is the time to interactively call gdb, for example:
      (gdb) print BreakWhenSymCreated (1234)
      (gdb) cont
      and you will arrive at gdbhook when this symbol is created.  */
  AnonymousName = 0;
  CurrentError = static_cast<M2Error_Error> (NULL);
  SymbolKey_InitTree (&ConstLitPoolTree);
  SymbolKey_InitTree (&DefModuleTree);
  SymbolKey_InitTree (&ModuleTree);
  Symbols = Indexing_InitIndexTuned (1, (1024*1024) / 16, 16);
  ConstLitArray = Indexing_InitIndex (1);
  FreeSymbol = 1;
  ScopePtr = 1;
  ScopeCallFrame = Indexing_InitIndex (1);
  Storage_ALLOCATE ((void **) &pCall, sizeof (SymbolTable_CallFrame));
  pCall->Main = SymbolTable_NulSym;
  pCall->Search = SymbolTable_NulSym;
  Indexing_PutIndice (ScopeCallFrame, ScopePtr, reinterpret_cast <void *> (pCall));
  CurrentModule = SymbolTable_NulSym;
  MainModule = SymbolTable_NulSym;
  FileModule = SymbolTable_NulSym;
  TemporaryNo = 0;
  /* 
   InitList(FreeFVarientList) ;              Lists used to maintain GC of field 
   InitList(UsedFVarientList) ;              varients.                          
  */
  Lists_InitList (&UnresolvedConstructorType);
  M2Base_InitBase (m2linemap_BuiltinsLocation (), &BaseModule);
  SymbolTable_StartScope (BaseModule);  /* BaseModule scope placed at the bottom of the stack  */
  BaseScopePtr = ScopePtr;  /* BaseScopePtr points to the top of the BaseModule scope  */
  Lists_InitList (&AddressTypes);  /* BaseScopePtr points to the top of the BaseModule scope  */
  ReportedUnknowns = Sets_InitSet (1);
}


/*
   AddSymToUnknown -
*/

static void AddSymToUnknown (unsigned int scope, NameKey_Name name, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  NameKey_Name n;

  if (DebugUnknowns)
    {
      n = SymbolTable_GetSymName (scope);
      M2Printf_printf3 ((const char *) "adding unknown %a (%d) to scope %a\\n", 36, (const unsigned char *) &name, (sizeof (name)-1), (const unsigned char *) &Sym, (sizeof (Sym)-1), (const unsigned char *) &n, (sizeof (n)-1));
    }
  /* Add symbol to unknown tree  */
  pSym = GetPsym (scope);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        SymbolKey_PutSymKey (pSym->DefImp.Unresolved, name, Sym);
        break;

      case SymbolTable_ModuleSym:
        SymbolKey_PutSymKey (pSym->Module.Unresolved, name, Sym);
        break;

      case SymbolTable_ProcedureSym:
        SymbolKey_PutSymKey (pSym->Procedure.Unresolved, name, Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp, Module or Procedure symbol", 44);
        break;
    }
}


/*
   AddSymToUnknownTree - adds a symbol with name, name, and Sym to the
                         unknown tree.
*/

static void AddSymToUnknownTree (int ScopeId, NameKey_Name name, unsigned int Sym)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int ScopeSym;

  if (ScopeId > 0)
    {
      /* choose to place the unknown symbol in the first module scope
         outside the current scope  */
      do {
        pCall = GetPcall (static_cast<unsigned int> (ScopeId));
        ScopeSym = pCall->Main;
        if ((ScopeSym > 0) && ((SymbolTable_IsDefImp (ScopeSym)) || (SymbolTable_IsModule (ScopeSym))))
          {
            AddSymToUnknown (ScopeSym, name, Sym);
            return;
          }
        ScopeId -= 1;
      } while (! (ScopeId == 0));
    }
  AddSymToUnknown (CurrentModule, name, Sym);
}


/*
   SubSymFromUnknownTree - removes a symbol with name, name, from the
                           unknown tree.
*/

static void SubSymFromUnknownTree (NameKey_Name name)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int ScopeSym;
  unsigned int ScopeId;

  if (ScopePtr > 0)
    {
      ScopeId = ScopePtr;
      do {
        pCall = GetPcall (ScopeId);
        ScopeSym = pCall->Search;
        if (((SymbolTable_IsModule (ScopeSym)) || (SymbolTable_IsDefImp (ScopeSym))) || (SymbolTable_IsProcedure (ScopeSym)))
          {
            if (RemoveFromUnresolvedTree (ScopeSym, name))
              {
                return;
              }
          }
        ScopeId -= 1;
      } while (! ((ScopeId > 0) && ((SymbolTable_IsModule (ScopeSym)) || (SymbolTable_IsDefImp (ScopeSym)))));
    }
  if (RemoveFromUnresolvedTree (CurrentModule, name))
    {}  /* empty.  */
}


/*
   GetSymFromUnknownTree - returns a symbol with name, name, from the
                           unknown tree.
                           If no symbol with name is found then NulSym
                           is returned.
*/

static unsigned int GetSymFromUnknownTree (NameKey_Name name)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int ScopeSym;
  unsigned int ScopeId;
  unsigned int Sym;

  if (ScopePtr > 0)
    {
      ScopeId = ScopePtr;
      do {
        pCall = GetPcall (ScopeId);
        ScopeSym = pCall->Search;
        if (((SymbolTable_IsModule (ScopeSym)) || (SymbolTable_IsDefImp (ScopeSym))) || (SymbolTable_IsProcedure (ScopeSym)))
          {
            Sym = ExamineUnresolvedTree (ScopeSym, name);
            if (Sym != SymbolTable_NulSym)
              {
                return Sym;
              }
          }
        ScopeId -= 1;
      } while (! ((ScopeId > 0) && ((SymbolTable_IsModule (ScopeSym)) || (SymbolTable_IsDefImp (ScopeSym)))));
    }
  /* Get symbol from unknown tree  */
  return ExamineUnresolvedTree (CurrentModule, name);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ExamineUnresolvedTree - returns a symbol with name, name, from the
                           unresolved tree of module, ModSym.
                           If no symbol with name is found then NulSym
                           is returned.
*/

static unsigned int ExamineUnresolvedTree (unsigned int ScopeSym, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  /* Get symbol from unknown tree  */
  pSym = GetPsym (ScopeSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.Unresolved, name));
        break;

      case SymbolTable_ModuleSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Module.Unresolved, name));
        break;

      case SymbolTable_ProcedureSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Procedure.Unresolved, name));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp, Module or Procedure symbol", 44);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RemoveFromUnresolvedTree - removes a symbol with name, name, from the
                              unresolved tree of symbol, ScopeSym.
*/

static bool RemoveFromUnresolvedTree (unsigned int ScopeSym, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;

  /* Get symbol from unknown tree  */
  pSym = GetPsym (ScopeSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if ((SymbolKey_GetSymKey (pSym->DefImp.Unresolved, name)) != SymbolKey_NulKey)
          {
            SymbolKey_DelSymKey (pSym->DefImp.Unresolved, name);
            return true;
          }
        break;

      case SymbolTable_ModuleSym:
        if ((SymbolKey_GetSymKey (pSym->Module.Unresolved, name)) != SymbolKey_NulKey)
          {
            SymbolKey_DelSymKey (pSym->Module.Unresolved, name);
            return true;
          }
        break;

      case SymbolTable_ProcedureSym:
        if ((SymbolKey_GetSymKey (pSym->Procedure.Unresolved, name)) != SymbolKey_NulKey)
          {
            SymbolKey_DelSymKey (pSym->Procedure.Unresolved, name);
            return true;
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp, Module or Procedure symbol", 44);
        break;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FetchUnknownSym - returns a symbol from the unknown tree if one is
                     available. It also updates the unknown tree.
*/

static unsigned int FetchUnknownSym (NameKey_Name name)
{
  unsigned int Sym;

  Sym = GetSymFromUnknownTree (name);
  if (Sym != SymbolTable_NulSym)
    {
      SubSymFromUnknownTree (name);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TransparentScope - returns true is the scope symbol Sym is allowed
                      to look to an outer level for a symbol.
                      ie is the symbol allowed to look to the parent
                      scope for a symbol.
*/

static bool TransparentScope (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return (pSym->SymbolType != SymbolTable_DefImpSym) && (pSym->SymbolType != SymbolTable_ModuleSym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLastModuleOrProcedureScope - returns the last module or procedure scope encountered,
                                   the scope before the current module scope.
*/

static unsigned int GetLastModuleOrProcedureScope (void)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int i;

  /* find current inner module  */
  i = ScopePtr;
  pCall = GetPcall (i);
  while ((! (SymbolTable_IsModule (pCall->Search))) && (! (SymbolTable_IsDefImp (pCall->Search))))
    {
      M2Debug_Assert (i > 0);
      i -= 1;
      pCall = GetPcall (i);
    }
  /* found module at position, i.  */
  i -= 1;  /* Move to an outer level module or procedure scope  */
  pCall = GetPcall (i);  /* Move to an outer level module or procedure scope  */
  while (((! (SymbolTable_IsModule (pCall->Search))) && (! (SymbolTable_IsDefImp (pCall->Search)))) && (! (SymbolTable_IsProcedure (pCall->Search))))
    {
      M2Debug_Assert (i > 0);
      i -= 1;
      pCall = GetPcall (i);
    }
  /* Found module at position, i.  */
  return pCall->Search;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddSymToScope - adds a symbol Sym with name name to
                   the current scope symbol tree.
*/

static void AddSymToScope (unsigned int Sym, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;
  SymbolTable_PtrToCallFrame pCall;
  unsigned int ScopeId;

  pCall = GetPcall (ScopePtr);
  ScopeId = pCall->Main;
  /* 
      WriteString('Adding ') ; WriteKey(name) ; WriteString(' :') ; WriteCard(Sym, 4) ; WriteString(' to scope: ') ;
      WriteKey(GetSymName(ScopeId)) ; WriteLn ;
  */
  pSym = GetPsym (ScopeId);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if (name != NameKey_NulName)
          {
            SymbolKey_PutSymKey (pSym->DefImp.LocalSymbols, name, Sym);
          }
        if (SymbolTable_IsEnumeration (Sym))
          {
            CheckEnumerationInList (pSym->DefImp.EnumerationScopeList, Sym);
          }
        break;

      case SymbolTable_ModuleSym:
        if (name != NameKey_NulName)
          {
            SymbolKey_PutSymKey (pSym->Module.LocalSymbols, name, Sym);
          }
        if (SymbolTable_IsEnumeration (Sym))
          {
            CheckEnumerationInList (pSym->Module.EnumerationScopeList, Sym);
          }
        break;

      case SymbolTable_ProcedureSym:
        if (name != NameKey_NulName)
          {
            SymbolKey_PutSymKey (pSym->Procedure.LocalSymbols, name, Sym);
          }
        if (SymbolTable_IsEnumeration (Sym))
          {
            CheckEnumerationInList (pSym->Procedure.EnumerationScopeList, Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "should never get here", 21);
        break;
    }
}


/*
   PlaceMajorScopesEnumerationListOntoStack - places the DefImp, Module and
                                              Procedure symbols enumeration
                                              list onto the scope stack.
*/

static void PlaceMajorScopesEnumerationListOntoStack (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        PlaceEnumerationListOntoScope (pSym->DefImp.EnumerationScopeList);
        break;

      case SymbolTable_ModuleSym:
        PlaceEnumerationListOntoScope (pSym->Module.EnumerationScopeList);
        break;

      case SymbolTable_ProcedureSym:
        PlaceEnumerationListOntoScope (pSym->Procedure.EnumerationScopeList);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting - DefImp, Module or Procedure symbol", 46);
        break;
    }
}


/*
   PlaceEnumerationListOntoScope - places an enumeration list, l, onto the
                                   scope stack. This list will automatically
                                   removed via one call to EndScope which
                                   matches the StartScope by which this
                                   procedure is invoked.
*/

static void PlaceEnumerationListOntoScope (Lists_List l)
{
  unsigned int i;
  unsigned int n;

  n = Lists_NoOfItemsInList (l);
  i = 1;
  while (i <= n)
    {
      SymbolTable_PseudoScope (Lists_GetItemFromList (l, i));
      i += 1;
    }
}


/*
   SetFirstUsed - assigns the FirstUsed field in at to tok providing
                  it has not already been set.
*/

static void SetFirstUsed (unsigned int tok, SymbolTable_Where *at)
{
  if ((*at).FirstUsed == M2LexBuf_UnknownTokenNo)
    {
      (*at).FirstUsed = tok;
    }
}


/*
   PutFirstUsed - sets tok to the first used providing it has not already been set.
                  It also includes the read and write quad into the usage list
                  providing the quad numbers are not 0.
*/

static void PutFirstUsed (unsigned int object, unsigned int tok, unsigned int read_, unsigned int write_)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (object))
    {
      pSym = GetPsym (object);
      SetFirstUsed (tok, &pSym->Var.At);
      if (read_ != 0)
        {
          SymbolTable_PutReadQuad (object, SymbolTable_GetMode (object), read_);
        }
      if (write_ != 0)
        {
          SymbolTable_PutWriteQuad (object, SymbolTable_GetMode (object), write_);
        }
    }
}


/*
   CanLookThroughScope - by default this procedure returns TRUE.  It only returns
                         FALSE if, throughProcedure, is FALSE and the ScopeSym is
                         a procedure.
*/

static bool CanLookThroughScope (unsigned int ScopeSym, bool throughProcedure)
{
  if (SymbolTable_IsProcedure (ScopeSym))
    {
      return throughProcedure;
    }
  else
    {
      return true;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetScopeSym - searches the current scope and below, providing that the
                 scopes are transparent, for a symbol with name, name.
                 It only passes over procedure scopes if, throughProcedure,
                 is TRUE.
*/

static unsigned int GetScopeSym (NameKey_Name name, bool throughProcedure)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int ScopeSym;
  unsigned int ScopeId;
  unsigned int Sym;

  /* DisplayScopes ;  */
  ScopeId = ScopePtr;
  pCall = GetPcall (ScopeId);
  ScopeSym = pCall->Search;
  /* WriteString(' scope: ') ; WriteKey(GetSymName(ScopeSym)) ;  */
  Sym = CheckScopeForSym (ScopeSym, name);
  while ((((ScopeId > 0) && (Sym == SymbolTable_NulSym)) && (TransparentScope (ScopeSym))) && (CanLookThroughScope (ScopeSym, throughProcedure)))
    {
      ScopeId -= 1;
      pCall = GetPcall (ScopeId);
      ScopeSym = pCall->Search;
      Sym = CheckScopeForSym (ScopeSym, name);
    }
  /* WriteString(' scope: ') ; WriteKey(GetSymName(ScopeSym))  */
  /* IF Sym#NulSym THEN WriteKey(GetSymName(Sym)) END ; WriteLn ;  */
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckScopeForSym - checks the scope, ScopeSym, for an identifier
                      of name, name. CheckScopeForSym checks for
                      the symbol by the GetLocalSym and also
                      ExamineUnresolvedTree.
*/

static unsigned int CheckScopeForSym (unsigned int ScopeSym, NameKey_Name name)
{
  unsigned int Sym;

  Sym = SymbolTable_GetLocalSym (ScopeSym, name);
  if ((Sym == SymbolTable_NulSym) && (((SymbolTable_IsModule (ScopeSym)) || (SymbolTable_IsDefImp (ScopeSym))) || (SymbolTable_IsProcedure (ScopeSym))))
    {
      Sym = ExamineUnresolvedTree (ScopeSym, name);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetModuleScopeId - returns the scope index to the next module starting
                      at index, Id.
                      Id will either point to a null scope (NulSym) or
                      alternatively point to a Module or DefImp symbol.
*/

static unsigned int GetModuleScopeId (unsigned int Id)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int s;

  pCall = GetPcall (Id);
  s = pCall->Search;
  while (((Id > 0) && (s != SymbolTable_NulSym)) && ((! (SymbolTable_IsModule (s))) && (! (SymbolTable_IsDefImp (s)))))
    {
      Id -= 1;
      pCall = GetPcall (Id);
      s = pCall->Search;
    }
  return Id;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetVisibleSym -
*/

static unsigned int GetVisibleSym (NameKey_Name name)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int Sym;
  unsigned int i;

  i = ScopePtr;
  while (i >= 1)
    {
      pCall = GetPcall (i);
      if (pCall->Search == pCall->Main)
        {
          return SymbolTable_GetLocalSym (pCall->Main, name);
        }
      else
        {
          if (SymbolTable_IsEnumeration (pCall->Search))
            {
              Sym = SymbolTable_GetLocalSym (pCall->Search, name);
              if (Sym != SymbolTable_NulSym)
                {
                  return Sym;
                }
            }
        }
      i -= 1;
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsAlreadyDeclaredSym - returns true if Sym has already been declared
                          in the current main scope.
*/

static bool IsAlreadyDeclaredSym (NameKey_Name name)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int i;

  i = ScopePtr;
  while (i >= 1)
    {
      pCall = GetPcall (i);
      if (pCall->Search == pCall->Main)
        {
          return (SymbolTable_GetLocalSym (pCall->Main, name)) != SymbolTable_NulSym;
        }
      else
        {
          if ((SymbolTable_IsEnumeration (pCall->Search)) && ((SymbolTable_GetLocalSym (pCall->Search, name)) != SymbolTable_NulSym))
            {
              return true;
            }
        }
      i -= 1;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GenName - returns a new name consisting of pre, name, post concatenation.
*/

static NameKey_Name GenName (NameKey_Name libname, const char *pre_, unsigned int _pre_high, NameKey_Name name, const char *post_, unsigned int _post_high)
{
  DynamicStrings_String str;
  NameKey_Name result;
  char pre[_pre_high+1];
  char post[_post_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (pre, pre_, _pre_high+1);
  memcpy (post, post_, _post_high+1);

  str = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (libname));
  str = DynamicStrings_ConCat (str, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) pre, _pre_high)));
  str = DynamicStrings_ConCat (str, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name))));
  str = DynamicStrings_ConCat (str, DynamicStrings_InitString ((const char *) post, _post_high));
  result = NameKey_makekey (DynamicStrings_string (str));
  str = DynamicStrings_KillString (str);
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitCtor - initialize the ModuleCtor fields to NulSym.
*/

static void InitCtor (SymbolTable_ModuleCtor *ctor)
{
  (*ctor).ctor = SymbolTable_NulSym;
  (*ctor).dep = SymbolTable_NulSym;
  (*ctor).init = SymbolTable_NulSym;
  (*ctor).fini = SymbolTable_NulSym;
}


/*
   InitCtorFields - initialize the ModuleCtor fields.  An inner module has no
                    ctor procedure.
*/

static void InitCtorFields (unsigned int moduleTok, unsigned int beginTok, unsigned int finallyTok, unsigned int moduleSym, SymbolTable_ModuleCtor *ctor, NameKey_Name name, bool inner, bool pub)
{
  if (M2Options_ScaffoldDynamic && ! inner)
    {
      /* The ctor procedure must be public.  */
      (*ctor).ctor = SymbolTable_MakeProcedure (moduleTok, GenName (SymbolTable_GetLibName (moduleSym), (const char *) "_M2_", 4, name, (const char *) "_ctor", 5));
      SymbolTable_PutCtor ((*ctor).ctor, true);
      M2Debug_Assert (pub);
      SymbolTable_PutPublic ((*ctor).ctor, pub);
      SymbolTable_PutExtern ((*ctor).ctor, ! pub);
      SymbolTable_PutMonoName ((*ctor).ctor, true);
      /* The dep procedure is local to the module.  */
      (*ctor).dep = SymbolTable_MakeProcedure (moduleTok, GenName (SymbolTable_GetLibName (moduleSym), (const char *) "_M2_", 4, name, (const char *) "_dep", 4));
      SymbolTable_PutMonoName ((*ctor).dep, true);
    }
  else
    {
      (*ctor).ctor = SymbolTable_NulSym;
      (*ctor).dep = SymbolTable_NulSym;
    }
  /* The init/fini procedures must be public.  */
  (*ctor).init = SymbolTable_MakeProcedure (beginTok, GenName (SymbolTable_GetLibName (moduleSym), (const char *) "_M2_", 4, name, (const char *) "_init", 5));
  SymbolTable_PutPublic ((*ctor).init, pub);
  SymbolTable_PutExtern ((*ctor).init, ! pub);
  SymbolTable_PutMonoName ((*ctor).init, ! inner);
  M2Scaffold_DeclareArgEnvParams (beginTok, (*ctor).init);
  (*ctor).fini = SymbolTable_MakeProcedure (finallyTok, GenName (SymbolTable_GetLibName (moduleSym), (const char *) "_M2_", 4, name, (const char *) "_fini", 5));
  SymbolTable_PutPublic ((*ctor).fini, pub);
  SymbolTable_PutExtern ((*ctor).fini, ! pub);
  SymbolTable_PutMonoName ((*ctor).fini, ! inner);
  M2Scaffold_DeclareArgEnvParams (beginTok, (*ctor).fini);
}


/*
   CheckTok - checks to see that tok is at a known location.  If not
              it uses GetTokenNo as a fall back.
*/

static unsigned int CheckTok (unsigned int tok, const char *name_, unsigned int _name_high)
{
  DynamicStrings_String s;
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  if (tok == M2LexBuf_UnknownTokenNo)
    {
      tok = M2LexBuf_GetTokenNo ();
      if (DebugUnknownToken)
        {
          s = DynamicStrings_InitString ((const char *) name, _name_high);
          s = DynamicStrings_ConCat (s, DynamicStrings_InitString ((const char *) " symbol {%W} has been created with an unknown token location", 60));
          M2MetaError_MetaErrorStringT0 (M2LexBuf_GetTokenNo (), s);
        }
    }
  return tok;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLink - returns TRUE if the current module is only used for linkage.
*/

static bool GetLink (void)
{
  unsigned int OuterModule;

  OuterModule = SymbolTable_GetCurrentModule ();
  if (OuterModule != SymbolTable_NulSym)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (M2Comp_CompilingDefinitionModule ())
        {
          return SymbolTable_IsDefLink (OuterModule);
        }
      else
        {
          return SymbolTable_IsModLink (OuterModule);
        }
    }
  /* Default is that the module is for compiling.  */
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddModuleToParent - adds symbol, Sym, to module, Parent.
*/

static void AddModuleToParent (unsigned int Sym, unsigned int Parent)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Parent);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Lists_PutItemIntoList (pSym->DefImp.ListOfModules, Sym);
        break;

      case SymbolTable_ModuleSym:
        Lists_PutItemIntoList (pSym->Module.ListOfModules, Sym);
        break;

      case SymbolTable_ProcedureSym:
        Lists_PutItemIntoList (pSym->Procedure.ListOfModules, Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
}


/*
   PutProcedureExternPublic - if procedure is not NulSym set extern
                              and public booleans.
*/

static void PutProcedureExternPublic (unsigned int procedure, bool extern_, bool pub)
{
  if (procedure != SymbolTable_NulSym)
    {
      SymbolTable_PutExtern (procedure, extern_);
      SymbolTable_PutPublic (procedure, pub);
    }
}


/*
   PutCtorExtern -
*/

static void PutCtorExtern (unsigned int tok, unsigned int sym, SymbolTable_ModuleCtor *ctor, bool extern_)
{
  /* If the ctor does not exist then make it extern/ (~extern) public.  */
  if ((*ctor).ctor == SymbolTable_NulSym)
    {
      (*ctor).ctor = SymbolTable_MakeProcedure (tok, GenName (SymbolTable_GetLibName (sym), (const char *) "_M2_", 4, SymbolTable_GetSymName (sym), (const char *) "_ctor", 5));
      SymbolTable_PutMonoName ((*ctor).ctor, true);
    }
  PutProcedureExternPublic ((*ctor).ctor, extern_, ! extern_);
  SymbolTable_PutCtor ((*ctor).ctor, true);
  /* If the ctor does not exist then make it extern/ (~extern) public.  */
  if ((*ctor).dep == SymbolTable_NulSym)
    {
      (*ctor).dep = SymbolTable_MakeProcedure (tok, GenName (SymbolTable_GetLibName (sym), (const char *) "_M2_", 4, SymbolTable_GetSymName (sym), (const char *) "_dep", 4));
      SymbolTable_PutMonoName ((*ctor).dep, true);
    }
  PutProcedureExternPublic ((*ctor).dep, extern_, ! extern_);
  /* If init/fini do not exist then create them.  */
  if ((*ctor).init == SymbolTable_NulSym)
    {
      (*ctor).init = SymbolTable_MakeProcedure (tok, GenName (SymbolTable_GetLibName (sym), (const char *) "_M2_", 4, SymbolTable_GetSymName (sym), (const char *) "_init", 5));
      M2Scaffold_DeclareArgEnvParams (tok, (*ctor).init);
      SymbolTable_PutMonoName ((*ctor).init, ! (SymbolTable_IsInnerModule (sym)));
    }
  PutProcedureExternPublic ((*ctor).init, extern_, ! extern_);
  if ((*ctor).fini == SymbolTable_NulSym)
    {
      (*ctor).fini = SymbolTable_MakeProcedure (tok, GenName (SymbolTable_GetLibName (sym), (const char *) "_M2_", 4, SymbolTable_GetSymName (sym), (const char *) "_fini", 5));
      M2Scaffold_DeclareArgEnvParams (tok, (*ctor).fini);
      SymbolTable_PutMonoName ((*ctor).fini, ! (SymbolTable_IsInnerModule (sym)));
    }
  PutProcedureExternPublic ((*ctor).fini, extern_, ! extern_);
}


/*
   InitProcedureDeclaration - initialize all the ProcedureDeclaration
                              fields.
*/

static void InitProcedureDeclaration (SymbolTable_ProcedureDeclaration *decl)
{
  (*decl).Defined = false;  /* Has the procedure been  */
  /* declared yet?  */
  (*decl).ParamDefined = false;  /* Have the parameters been  */
  /* defined yet?  */
  (*decl).HasVarArgs = false;  /* Does the procedure use ... ?  */
  (*decl).HasOptArg = false;  /* Does this procedure use [ ] ?  */
  (*decl).IsNoReturn = false;  /* Declared attribute noreturn ?  */
  (*decl).ReturnOptional = false;  /* Is the return value optional?  */
  (*decl).ProcedureTok = M2LexBuf_UnknownTokenNo;  /* Is the return value optional?  */
}


/*
   AddProcedureToList - adds a procedure, Proc, to the list of procedures
                        in module, Mod.
*/

static void AddProcedureToList (unsigned int Mod, unsigned int Proc)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Mod);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Lists_PutItemIntoList (pSym->DefImp.ListOfProcs, Proc);
        break;

      case SymbolTable_ModuleSym:
        Lists_PutItemIntoList (pSym->Module.ListOfProcs, Proc);
        break;

      case SymbolTable_ProcedureSym:
        Lists_PutItemIntoList (pSym->Procedure.ListOfProcs, Proc);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ModuleSym, DefImpSym or ProcedureSym symbol", 53);
        break;
    }
}


/*
   AddVarToScopeList - adds symbol, sym, to, scope.
*/

static void AddVarToScopeList (unsigned int scope, unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (scope);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        Lists_PutItemIntoList (pSym->Procedure.ListOfVars, sym);
        break;

      case SymbolTable_ModuleSym:
        Lists_PutItemIntoList (pSym->Module.ListOfVars, sym);
        break;

      case SymbolTable_DefImpSym:
        Lists_PutItemIntoList (pSym->DefImp.ListOfVars, sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Procedure or Module symbol", 36);
        break;
    }
}


/*
   AddVarToList - add a variable symbol to the list of variables maintained
                  by the inner most scope. (Procedure or Module).
*/

static void AddVarToList (unsigned int Sym)
{
  SymbolTable_PtrToCallFrame pCall;

  pCall = GetPcall (ScopePtr);
  AddVarToScopeList (pCall->Main, Sym);
}


/*
   InitVarDecl - initialize the variable and type token location positions.
*/

static void InitVarDecl (SymbolTable_VarDecl *decl, unsigned int vartok)
{
  (*decl).FullTok = M2LexBuf_UnknownTokenNo;
  (*decl).VarTok = vartok;
  (*decl).TypeTok = M2LexBuf_UnknownTokenNo;
}


/*
   doPutVarDeclTypeTok - places typetok into decl.TypeTok.
                         sym must be a variable.
*/

static void doPutVarDeclTypeTok (unsigned int sym, unsigned int typetok)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsVar (sym));
  pSym = GetPsym (sym);
  pSym->Var.Declared.TypeTok = typetok;
}


/*
   doPutVarDeclTok - places vartok into decl.VarTok.
                     sym must be a variable.
*/

static void doPutVarDeclTok (unsigned int sym, unsigned int vartok)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsVar (sym));
  pSym = GetPsym (sym);
  pSym->Var.Declared.VarTok = vartok;
}


/*
   doGetVarDeclTok - return decl.VarTok for a variable.
*/

static unsigned int doGetVarDeclTok (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  M2Debug_Assert (SymbolTable_IsVar (sym));
  return pSym->Var.Declared.VarTok;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doGetVarDeclTypeTok - return decl.TypeTok for a variable.
*/

static unsigned int doGetVarDeclTypeTok (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  M2Debug_Assert (SymbolTable_IsVar (sym));
  return pSym->Var.Declared.TypeTok;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doGetVarDeclFullTok - return the full declaration of var: type.
*/

static unsigned int doGetVarDeclFullTok (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  M2Debug_Assert (SymbolTable_IsVar (sym));
  if (pSym->Var.Declared.FullTok == M2LexBuf_UnknownTokenNo)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (pSym->Var.Declared.TypeTok == M2LexBuf_UnknownTokenNo)
        {
          return pSym->Var.Declared.VarTok;
        }
      else
        {
          pSym->Var.Declared.FullTok = M2LexBuf_MakeVirtual2Tok (pSym->Var.Declared.VarTok, pSym->Var.Declared.TypeTok);
        }
    }
  return pSym->Var.Declared.FullTok;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FillInRecordFields - given a new symbol, sym, make it a record symbol
                        and initialize its fields.
*/

static void FillInRecordFields (unsigned int tok, unsigned int sym, NameKey_Name RecordName, unsigned int scope, unsigned int oaf)
{
  SymbolTable_PtrToSymbol pSym;

  if (! (SymbolTable_IsError (sym)))
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_RecordSym;
      pSym->Record.name = RecordName;
      SymbolKey_InitTree (&pSym->Record.LocalSymbols);
      pSym->Record.Size = M2ALU_InitValue ();
      Lists_InitList (&pSym->Record.ListOfSons);  /* List of RecordFieldSym and VarientSym  */
      pSym->Record.oafamily = oaf;  /* List of RecordFieldSym and VarientSym  */
      pSym->Record.Parent = SymbolTable_NulSym;
      pSym->Record.Align = SymbolTable_NulSym;
      pSym->Record.DefaultAlign = SymbolTable_NulSym;
      pSym->Record.DeclPacked = false;
      pSym->Record.DeclResolved = false;
      pSym->Record.Scope = scope;
      InitWhereDeclaredTok (tok, &pSym->Record.At);
    }
}


/*
   HandleHiddenOrDeclare -
*/

static unsigned int HandleHiddenOrDeclare (unsigned int tok, NameKey_Name name, unsigned int *oaf)
{
  unsigned int sym;

  sym = CheckForHiddenType (name);
  if (sym == SymbolTable_NulSym)
    {
      sym = DeclareSym (tok, name);
      if (! (SymbolTable_IsError (sym)))
        {
          /* Now add this type to the symbol table of the current scope  */
          AddSymToScope (sym, name);
        }
    }
  (*oaf) = SymbolTable_GetOAFamily (sym);
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CreateConstLit -
*/

static unsigned int CreateConstLit (unsigned int tok, NameKey_Name constName, unsigned int constType)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;
  bool overflow;

  overflow = false;
  if (constType == SymbolTable_NulSym)
    {
      constType = GetConstLitType (tok, constName, &overflow, true);
    }
  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_ConstLitSym;
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstLitSym:
        pSym->ConstLit.name = constName;
        pSym->ConstLit.Value = M2ALU_InitValue ();
        M2ALU_PushString (tok, constName, ! overflow);
        M2ALU_PopInto (pSym->ConstLit.Value);
        pSym->ConstLit.Type = constType;
        pSym->ConstLit.IsSet = false;
        pSym->ConstLit.IsInternal = false;  /* Is it a default BY constant
                                                        expression?  */
        pSym->ConstLit.IsConstructor = false;  /* Is it a default BY constant
                                                        expression?  */
        pSym->ConstLit.FromType = SymbolTable_NulSym;  /* type is determined FromType  */
        pSym->ConstLit.RangeError = overflow;  /* type is determined FromType  */
        pSym->ConstLit.UnresFromType = false;  /* is Type resolved?  */
        pSym->ConstLit.Scope = SymbolTable_GetCurrentScope ();  /* is Type resolved?  */
        InitWhereDeclaredTok (tok, &pSym->ConstLit.At);
        InitWhereFirstUsedTok (tok, &pSym->ConstLit.At);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstLit symbol", 25);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   LookupConstLitPoolEntry - return a ConstLit symbol from the constant pool which
                             matches tok, constName and constType.
*/

static unsigned int LookupConstLitPoolEntry (unsigned int tok, NameKey_Name constName, unsigned int constType)
{
  SymbolTable_ConstLitPoolEntry pe;
  unsigned int rootIndex;

  rootIndex = static_cast<unsigned int> (SymbolKey_GetSymKey (ConstLitPoolTree, constName));
  if (rootIndex != 0)
    {
      pe = static_cast<SymbolTable_ConstLitPoolEntry> (Indexing_GetIndice (ConstLitArray, rootIndex));
      while (pe != NULL)
        {
          if (((pe->tok == tok) && (pe->constName == constName)) && (pe->constType == constType))
            {
              return pe->sym;
            }
          pe = pe->next;
        }
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddConstLitPoolEntry - adds sym to the constlit pool.
*/

static void AddConstLitPoolEntry (unsigned int sym, unsigned int tok, NameKey_Name constName, unsigned int constType)
{
  SymbolTable_ConstLitPoolEntry pe;
  SymbolTable_ConstLitPoolEntry old;
  unsigned int rootIndex;
  unsigned int high;

  rootIndex = static_cast<unsigned int> (SymbolKey_GetSymKey (ConstLitPoolTree, constName));
  if (rootIndex == SymbolKey_NulKey)
    {
      high = Indexing_HighIndice (ConstLitArray);
      Storage_ALLOCATE ((void **) &pe, sizeof (SymbolTable__T4));
      if (pe == NULL)
        {
          M2Error_InternalError ((const char *) "out of memory", 13);
        }
      else
        {
          pe->sym = sym;
          pe->tok = tok;
          pe->constName = constName;
          pe->constType = constType;
          pe->next = NULL;
          SymbolKey_PutSymKey (ConstLitPoolTree, constName, high+1);
          Indexing_PutIndice (ConstLitArray, high+1, reinterpret_cast <void *> (pe));
        }
    }
  else
    {
      Storage_ALLOCATE ((void **) &pe, sizeof (SymbolTable__T4));
      if (pe == NULL)
        {
          M2Error_InternalError ((const char *) "out of memory", 13);
        }
      else
        {
          old = static_cast<SymbolTable_ConstLitPoolEntry> (Indexing_GetIndice (ConstLitArray, rootIndex));
          pe->sym = sym;
          pe->tok = tok;
          pe->constName = constName;
          pe->constType = constType;
          pe->next = old;
          Indexing_PutIndice (ConstLitArray, rootIndex, reinterpret_cast <void *> (pe));
        }
    }
}


/*
   InitConstString - initialize the constant string.
*/

static void InitConstString (unsigned int tok, unsigned int sym, NameKey_Name name, NameKey_Name contents, SymbolTable_ConstStringVariant kind, bool escape, bool known)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  pSym->SymbolType = SymbolTable_ConstStringSym;
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        pSym->ConstString.name = name;
        pSym->ConstString.StringVariant = kind;
        pSym->ConstString.Scope = SymbolTable_GetCurrentScope ();
        InitWhereDeclaredTok (tok, &pSym->ConstString.At);
        SymbolTable_PutConstStringKnown (tok, sym, contents, escape, known);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstStringSym", 24);
        break;
    }
}


/*
   GetConstStringKind - return the StringVariant field associated with sym.
*/

static SymbolTable_ConstStringVariant GetConstStringKind (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        return pSym->ConstString.StringVariant;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstString symbol", 28);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CanUseBuiltin - returns TRUE if the procedure, Sym, can be
                   inlined via a builtin function.
*/

static bool CanUseBuiltin (unsigned int Sym)
{
  return ! M2Options_DebugBuiltins && ((m2builtins_BuiltinExists (reinterpret_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetProcedureBuiltin (Sym))))) || (m2builtins_BuiltinExists (reinterpret_cast <char * > (NameKey_KeyToCharStar (SymbolTable_GetSymName (Sym))))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitPacked - initialise packedInfo to FALSE and NulSym.
*/

static void InitPacked (SymbolTable_PackedInfo *packedInfo)
{
  (*packedInfo).IsPacked = false;
  (*packedInfo).PackedEquiv = SymbolTable_NulSym;
}


/*
   doEquivalent - create a packed equivalent symbol for, sym, and return the
                  new symbol.  It sets both fields in packedInfo to FALSE
                  and the new symbol.
*/

static unsigned int doEquivalent (SymbolTable_PackedInfo *packedInfo, unsigned int sym)
{
  unsigned int nSym;
  SymbolTable_PtrToSymbol pSym;

  NewSym (&nSym);
  pSym = GetPsym (nSym);
  pSym->SymbolType = SymbolTable_EquivSym;
  pSym->Equiv.nonPacked = sym;
  pSym->Equiv.packedInfo.IsPacked = true;
  pSym->Equiv.packedInfo.PackedEquiv = SymbolTable_NulSym;
  (*packedInfo).IsPacked = false;
  (*packedInfo).PackedEquiv = nSym;
  return nSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeEquivalent - return the equivalent packed symbol for, sym.
*/

static unsigned int MakeEquivalent (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_EnumerationSym:
        return doEquivalent (&pSym->Enumeration.packedInfo, sym);
        break;

      case SymbolTable_SubrangeSym:
        return doEquivalent (&pSym->Subrange.packedInfo, sym);
        break;

      case SymbolTable_TypeSym:
        return doEquivalent (&pSym->Type.packedInfo, sym);
        break;

      case SymbolTable_SetSym:
        return doEquivalent (&pSym->Set.packedInfo, sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting type, subrange or enumerated type symbol", 50);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetEquivalent -
*/

static unsigned int GetEquivalent (SymbolTable_PackedInfo *packedInfo, unsigned int sym)
{
  if ((*packedInfo).IsPacked)
    {
      return sym;
    }
  else if ((*packedInfo).PackedEquiv == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      (*packedInfo).PackedEquiv = MakeEquivalent (sym);
    }
  return (*packedInfo).PackedEquiv;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doGetType - subsiduary helper procedure function of GetDType, GetSType and GetLType.
*/

static unsigned int doGetType (unsigned int sym, bool skipEquiv, bool skipAlign, bool skipHidden, bool skipBase)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int type;

  type = SymbolTable_NulSym;
  M2Debug_Assert (sym != SymbolTable_NulSym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_OAFamilySym:
        type = pSym->OAFamily.SimpleType;
        break;

      case SymbolTable_VarSym:
        type = GetTypeOfVar (sym);
        break;

      case SymbolTable_ConstLitSym:
        type = pSym->ConstLit.Type;
        break;

      case SymbolTable_ConstVarSym:
        type = pSym->ConstVar.Type;
        break;

      case SymbolTable_ConstStringSym:
        if (pSym->ConstString.Length == 1)
          {
            type = M2Base_Char;
          }
        else
          {
            type = SymbolTable_NulSym;  /* No type for a string  */
          }
        break;

      case SymbolTable_TypeSym:
        type = pSym->Type.Type;
        break;

      case SymbolTable_RecordFieldSym:
        type = pSym->RecordField.Type;
        break;

      case SymbolTable_RecordSym:
        type = SymbolTable_NulSym;  /* No type for a record  */
        break;

      case SymbolTable_VarientSym:
        type = SymbolTable_NulSym;  /* No type for a record  */
        break;

      case SymbolTable_EnumerationFieldSym:
        type = pSym->EnumerationField.Type;  /* No type for a record  */
        break;

      case SymbolTable_EnumerationSym:
        type = SymbolTable_NulSym;  /* No type for enumeration  */
        break;

      case SymbolTable_PointerSym:
        type = pSym->Pointer.Type;  /* No type for enumeration  */
        break;

      case SymbolTable_ProcedureSym:
        type = pSym->Procedure.ReturnType;
        break;

      case SymbolTable_ProcTypeSym:
        type = pSym->ProcType.ReturnType;
        break;

      case SymbolTable_ParamSym:
        type = pSym->Param.Type;
        break;

      case SymbolTable_VarParamSym:
        type = pSym->VarParam.Type;
        break;

      case SymbolTable_SubrangeSym:
        type = pSym->Subrange.Type;
        break;

      case SymbolTable_ArraySym:
        type = pSym->Array.Type;
        break;

      case SymbolTable_SubscriptSym:
        type = pSym->Subscript.Type;
        break;

      case SymbolTable_SetSym:
        type = pSym->Set.Type;
        break;

      case SymbolTable_UnboundedSym:
        type = pSym->Unbounded.Type;
        break;

      case SymbolTable_UndefinedSym:
        type = SymbolTable_NulSym;
        break;

      case SymbolTable_PartialUnboundedSym:
        type = pSym->PartialUnbounded.Type;
        break;

      case SymbolTable_ObjectSym:
        type = SymbolTable_NulSym;
        break;


      default:
        M2Error_InternalError ((const char *) "not implemented yet", 19);
        break;
    }
  if (((type == SymbolTable_NulSym) && (SymbolTable_IsType (sym))) && ! skipBase)
    {
      return sym;  /* sym is a base type  */
    }
  else if (type != SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsType (type)) && skipEquiv)
        {
          if ((! (SymbolTable_IsHiddenType (type))) || skipHidden)
            {
              if (((SymbolTable_GetAlignment (type)) == SymbolTable_NulSym) || skipAlign)
                {
                  return doGetType (type, skipEquiv, skipAlign, skipHidden, skipBase);
                }
            }
        }
    }
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTypeOfVar - returns the type of symbol, var.
*/

static unsigned int GetTypeOfVar (unsigned int var)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int high;

  pSym = GetPsym (var);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        if (pSym->Var.IsTemp && pSym->Var.IsComponentRef)
          {
            high = Indexing_HighIndice (pSym->Var.list);
            return SymbolTable_GetType (GetFromIndex (pSym->Var.list, high));
          }
        else
          {
            return pSym->Var.Type;
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a var symbol", 22);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetConstLitType - returns the type of the constant of, name.
                     All floating point constants have type LONGREAL.
                     Character constants are type CHAR.
                     Integer values are INTEGER, LONGINT or LONGCARD
                     depending upon their value.
*/

static unsigned int GetConstLitType (unsigned int tok, NameKey_Name name, bool *overflow, bool issueError)
{
  location_t loc;
  DynamicStrings_String s;

  s = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name));
  if ((DynamicStrings_char (s, -1)) == 'C')
    {
      s = DynamicStrings_KillString (s);
      return M2Base_Char;
    }
  else
    {
      if ((DynamicStrings_Index (s, '.', 0)) != -1)  /* found a '.' in our constant  */
        {
          s = DynamicStrings_KillString (s);
          return M2Base_RType;
        }
      loc = M2LexBuf_TokenToLocation (tok);
      switch (DynamicStrings_char (s, -1))
        {
          case 'H':
            (*overflow) = m2expr_OverflowZType (loc, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (s))), 16, issueError);
            break;

          case 'B':
            (*overflow) = m2expr_OverflowZType (loc, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (s))), 8, issueError);
            break;

          case 'A':
            (*overflow) = m2expr_OverflowZType (loc, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (s))), 2, issueError);
            break;


          default:
            (*overflow) = m2expr_OverflowZType (loc, const_cast <const char * > (static_cast <char * > (DynamicStrings_string (s))), 10, issueError);
            break;
        }
      s = DynamicStrings_KillString (s);
      return M2Base_ZType;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetNthFromComponent -
*/

static unsigned int GetNthFromComponent (unsigned int Sym, unsigned int n)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        if (SymbolTable_IsComponent (Sym))
          {
            if (Indexing_InBounds (pSym->Var.list, n))
              {
                return GetFromIndex (pSym->Var.list, n);
              }
            else
              {
                return SymbolTable_NulSym;
              }
          }
        else
          {
            M2Error_InternalError ((const char *) "cannot GetNth from this symbol", 30);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "cannot GetNth from this symbol", 30);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetNthParamChoice - returns the parameter definition from
                       sym:ParamNo:kind or NulSym.
*/

static unsigned int GetNthParamChoice (unsigned int sym, unsigned int ParamNo, SymbolTable_ProcedureKind kind)
{
  if (SymbolTable_GetProcedureParametersDefined (sym, kind))
    {
      return SymbolTable_GetNthParam (sym, kind, ParamNo);
    }
  else
    {
      return SymbolTable_NulSym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetNthParamOrdered - returns the parameter definition from list {a, b, c}
                        in order.
                        sym:ParamNo:{a,b,c} or NulSym.
*/

static unsigned int GetNthParamOrdered (unsigned int sym, unsigned int ParamNo, SymbolTable_ProcedureKind a, SymbolTable_ProcedureKind b, SymbolTable_ProcedureKind c)
{
  unsigned int param;

  param = GetNthParamChoice (sym, ParamNo, a);
  if (param == SymbolTable_NulSym)
    {
      param = GetNthParamChoice (sym, ParamNo, b);
      if (param == SymbolTable_NulSym)
        {
          param = GetNthParamChoice (sym, ParamNo, c);
        }
    }
  return param;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetOuterModuleScope - returns the outer module symbol scope for sym.
*/

static unsigned int GetOuterModuleScope (unsigned int sym)
{
  while (! ((SymbolTable_IsDefImp (sym)) || ((SymbolTable_IsModule (sym)) && ((SymbolTable_GetScope (sym)) == SymbolTable_NulSym))))
    {
      sym = SymbolTable_GetScope (sym);
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   EnsureOrder - providing that both symbols, a, and, b, exist in
                 list, l.  Ensure that, b, is placed after a.
*/

static void EnsureOrder (Lists_List l, unsigned int a, unsigned int b)
{
  unsigned int n;

  n = Lists_NoOfItemsInList (l);
  if ((Lists_IsItemInList (l, a)) && (Lists_IsItemInList (l, b)))
    {
      Lists_RemoveItemFromList (l, b);
      Lists_IncludeItemIntoList (l, b);
    }
  M2Debug_Assert (n == (Lists_NoOfItemsInList (l)));
}


/*
   DumpSons -
*/

static void DumpSons (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int f;
  unsigned int n;
  unsigned int i;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        n = Lists_NoOfItemsInList (pSym->Record.ListOfSons);
        i = 1;
        while (i <= n)
          {
            f = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Record.ListOfSons, i));
            M2Printf_printf3 ((const char *) "record %d field %d is %d\\n", 26, (const unsigned char *) &sym, (sizeof (sym)-1), (const unsigned char *) &i, (sizeof (i)-1), (const unsigned char *) &f, (sizeof (f)-1));
            i += 1;
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting record symbol", 23);
        break;
    }
}


/*
   CheckListOfSons - checks to see that sym, is present in, recordConsist, ListOfSons.
*/

static void CheckListOfSons (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (recordConsist);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        if (! (Lists_IsItemInList (pSym->Record.ListOfSons, sym)))
          {
            DumpSons (recordConsist);
            M2MetaError_MetaError1 ((const char *) "internal error:  expecting {%1ad} to exist in record ListOfSons", 63, sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting record symbol", 23);
        break;
    }
}


/*
   CheckRecordConsistency -
*/

static void CheckRecordConsistency (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  return;
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        recordConsist = sym;
        SymbolKey_ForeachNodeDo (pSym->Record.LocalSymbols, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CheckListOfSons});
        break;


      default:
        M2Error_InternalError ((const char *) "record symbol expected", 22);
        break;
    }
}


/*
   PutConstVarTemporary - indicates that constant, sym, is a temporary.
*/

static void PutConstVarTemporary (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        pSym->ConstVar.IsTemp = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
}


/*
   buildTemporary - builds the temporary filling in componentRef, record and sets mode.
*/

static unsigned int buildTemporary (unsigned int tok, SymbolTable_ModeOfAddr Mode, bool componentRef, unsigned int record)
{
  SymbolTable_PtrToSymbol pSym;
  DynamicStrings_String s;
  unsigned int Sym;

  TemporaryNo += 1;
  /* Make the name  */
  s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "_T%d", 4)), (const unsigned char *) &TemporaryNo, (sizeof (TemporaryNo)-1));
  if (Mode == SymbolTable_ImmediateValue)
    {
      Sym = SymbolTable_MakeConstVar (tok, NameKey_makekey (DynamicStrings_string (s)));
      PutConstVarTemporary (Sym);
    }
  else
    {
      Sym = SymbolTable_MakeVar (tok, NameKey_makekey (DynamicStrings_string (s)));
      pSym = GetPsym (Sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            pSym->Var.AddrMode = Mode;
            pSym->Var.IsComponentRef = componentRef;
            pSym->Var.IsTemp = true;  /* Variable is a temporary var  */
            if (componentRef)  /* Variable is a temporary var  */
              {
                pSym->Var.list = Indexing_InitIndex (1);
                PutIntoIndex (&pSym->Var.list, 1, record);
              }
            InitWhereDeclaredTok (tok, &pSym->Var.At);  /* Declared here  */
            InitWhereFirstUsedTok (tok, &pSym->Var.At);  /* Where symbol first used.  */
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a Var symbol", 22);  /* Where symbol first used.  */
            break;
        }
    }
  s = DynamicStrings_KillString (s);
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AssertInRange - determines whether the Sym is a legal symbol.
*/

static void AssertInRange (unsigned int Sym)
{
  if ((Sym < 1) || (Sym > (SymbolTable_FinalSymbol ())))
    {
      M2Error_InternalError ((const char *) "illegal symbol", 14);
    }
}


/*
   CheckForHiddenType - scans the NeedToBeImplemented tree providing
                        that we are currently compiling an implementation
                        module. If a symbol is found with TypeName
                        then its Sym is returned.
                        Otherwise NulSym is returned.
                        CheckForHiddenType is called before any type is
                        created, therefore the compiler allows hidden
                        types to be implemented using any type.
*/

static unsigned int CheckForHiddenType (NameKey_Name TypeName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  Sym = SymbolTable_NulSym;
  if ((((M2Comp_CompilingImplementationModule ()) && (SymbolTable_IsDefImp (CurrentModule))) && (SymbolTable_IsHiddenTypeDeclared (CurrentModule))) && (TypeName != NameKey_NulName))
    {
      /* Check to see whether we are declaring a HiddenType.  */
      pSym = GetPsym (CurrentModule);
      switch (pSym->SymbolType)
        {
          case SymbolTable_DefImpSym:
            Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.NeedToBeImplemented, TypeName));
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
            break;
        }
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RequestFromModule - returns a symbol from module ModSym with name, SymName.
*/

static unsigned int RequestFromModule (unsigned int tok, unsigned int ModSym, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.LocalSymbols, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            Sym = FetchUnknownFromDefImp (tok, ModSym, SymName);
          }
        break;

      case SymbolTable_ModuleSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Module.LocalSymbols, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            Sym = FetchUnknownFromModule (tok, ModSym, SymName);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RequestFromDefinition - returns a symbol from module ModSym with name,
                           SymName.
*/

static unsigned int RequestFromDefinition (unsigned int tok, unsigned int ModSym, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;
  unsigned int OldScopePtr;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.ExportQualifiedTree, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.ExportUnQualifiedTree, SymName));
            if (Sym == SymbolTable_NulSym)
              {
                Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymName));
                if (Sym == SymbolTable_NulSym)
                  {
                    OldScopePtr = ScopePtr;
                    SymbolTable_StartScope (ModSym);
                    Sym = GetScopeSym (SymName, true);
                    SymbolTable_EndScope ();
                    M2Debug_Assert (OldScopePtr == ScopePtr);
                    if (Sym == SymbolTable_NulSym)
                      {
                        Sym = FetchUnknownFromDefImp (tok, ModSym, SymName);
                      }
                    else
                      {
                        if (SymbolTable_IsFieldEnumeration (Sym))
                          {
                            if (SymbolTable_IsExported (ModSym, SymbolTable_GetType (Sym)))
                              {
                                return Sym;
                              }
                          }
                      }
                    SymbolKey_PutSymKey (pSym->DefImp.ExportRequest, SymName, Sym);
                  }
              }
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetWhereImported - returns the token number where this symbol
                      was imported into the current module.
*/

static unsigned int GetWhereImported (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (SymbolTable_GetCurrentModuleScope ());
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.WhereImported, Sym));
        break;

      case SymbolTable_ModuleSym:
        return static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Module.WhereImported, Sym));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   DisplayName - displays the name.
*/

static void DisplayName (unsigned int sym)
{
  M2Printf_printf1 ((const char *) "   %a", 5, (const unsigned char *) &sym, (sizeof (sym)-1));
}


/*
   DisplaySymbol - displays the name of a symbol
*/

static void DisplaySymbol (unsigned int sym)
{
  DynamicStrings_String s;

  s = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym))));
  M2Printf_printf2 ((const char *) "   %s (%d)", 10, (const unsigned char *) &s, (sizeof (s)-1), (const unsigned char *) &sym, (sizeof (sym)-1));
}


/*
   FetchUnknownFromModule - returns an Unknown symbol from module, ModSym.
*/

static unsigned int FetchUnknownFromModule (unsigned int tok, unsigned int ModSym, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Module.Unresolved, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            NewSym (&Sym);
            FillInUnknownFields (tok, Sym, SymName);
            SymbolKey_PutSymKey (pSym->Module.Unresolved, SymName, Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module symbol", 25);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FetchUnknownFromDefImp - returns an Unknown symbol from module, ModSym.
*/

static unsigned int FetchUnknownFromDefImp (unsigned int tok, unsigned int ModSym, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.Unresolved, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            NewSym (&Sym);
            FillInUnknownFields (tok, Sym, SymName);
            SymbolKey_PutSymKey (pSym->DefImp.Unresolved, SymName, Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FetchUnknownFromDefImp - returns an Unknown symbol from module, ModSym.
*/

static unsigned int FetchUnknownFrom (unsigned int tok, unsigned int scope, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  pSym = GetPsym (scope);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.Unresolved, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            NewSym (&Sym);
            FillInUnknownFields (tok, Sym, SymName);
            SymbolKey_PutSymKey (pSym->DefImp.Unresolved, SymName, Sym);
          }
        break;

      case SymbolTable_ModuleSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Module.Unresolved, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            NewSym (&Sym);
            FillInUnknownFields (tok, Sym, SymName);
            SymbolKey_PutSymKey (pSym->Module.Unresolved, SymName, Sym);
          }
        break;

      case SymbolTable_ProcedureSym:
        Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Procedure.Unresolved, SymName));
        if (Sym == SymbolTable_NulSym)
          {
            NewSym (&Sym);
            FillInUnknownFields (tok, Sym, SymName);
            SymbolKey_PutSymKey (pSym->Procedure.Unresolved, SymName, Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module or Procedure symbol", 48);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   UnknownSymbolError - displays symbol name for symbol, sym.
*/

static void UnknownSymbolError (unsigned int sym)
{
  if (IsUnreportedUnknown (sym))
    {
      Sets_IncludeElementIntoSet (ReportedUnknowns, sym);
      M2MetaError_MetaErrorStringT1 (SymbolTable_GetFirstUsed (sym), DynamicStrings_InitString ((const char *) "unknown symbol {%1EUad}", 23), sym);
    }
}


/*
   IsUnreportedUnknown - returns TRUE if symbol, sym, has not been
                         reported and is an unknown symbol.
*/

static bool IsUnreportedUnknown (unsigned int sym)
{
  return (SymbolTable_IsUnknown (sym)) && (! (Sets_IsElementInSet (ReportedUnknowns, sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddListify -
*/

static void AddListify (unsigned int sym)
{
  ListifyWordCount += 1;
  /* printf ("AddListify: ListifyWordCount = %d, ListifyTotal = %d
  ",
              ListifyWordCount, ListifyTotal) ;  */
  if (ListifyWordCount > 1)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (ListifyWordCount == ListifyTotal)
        {
          ListifySentance = DynamicStrings_ConCat (ListifySentance, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " and ", 5)));
        }
      else
        {
          ListifySentance = DynamicStrings_ConCat (ListifySentance, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ", ", 2)));
        }
    }
  ListifySentance = DynamicStrings_ConCat (ListifySentance, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (sym)))));
}


/*
   Listify - convert tree into a string list and return the result.
*/

static DynamicStrings_String Listify (SymbolKey_SymbolTree tree, SymbolKey_IsSymbol isCondition)
{
  ListifyTotal = SymbolKey_NoOfNodes (tree, isCondition);
  ListifyWordCount = 0;
  ListifySentance = DynamicStrings_InitString ((const char *) "", 0);
  SymbolKey_ForeachNodeConditionDo (tree, isCondition, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) AddListify});
  return ListifySentance;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckForUnknowns - checks a binary tree, Tree, to see whether it contains
                      an unknown symbol. All unknown symbols are displayed
                      together with an error message.
*/

static void CheckForUnknowns (NameKey_Name name, SymbolKey_SymbolTree Tree, const char *a_, unsigned int _a_high)
{
  DynamicStrings_String s;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  if (SymbolKey_DoesTreeContainAny (Tree, (SymbolKey_IsSymbol) {(SymbolKey_IsSymbol_t) IsUnreportedUnknown}))
    {
      CurrentError = M2Error_NewError (M2LexBuf_GetTokenNo ());
      s = DynamicStrings_InitString ((const char *) "{%E} the following unknown symbols in module %<", 47);
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name))));
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%> were ", 8)));
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)));
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) ": ", 2)));
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (Listify (Tree, (SymbolKey_IsSymbol) {(SymbolKey_IsSymbol_t) IsUnreportedUnknown})));
      M2MetaError_MetaErrorStringT0 (M2LexBuf_GetTokenNo (), s);
      SymbolKey_ForeachNodeDo (Tree, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) UnknownSymbolError});
    }
}


/*
   SymbolError - displays symbol name for symbol, Sym.
*/

static void SymbolError (unsigned int Sym)
{
  M2Error_Error e;
  NameKey_Name n;

  n = SymbolTable_GetSymName (Sym);
  e = M2Error_ChainError (SymbolTable_GetFirstUsed (Sym), CurrentError);
  M2Error_ErrorFormat1 (e, (const char *) "unknown symbol '%a' found", 25, (const unsigned char *) &n, (sizeof (n)-1));
}


/*
   CheckForSymbols  - checks a binary tree, Tree, to see whether it contains
                      any symbol. The tree is expected to be empty, if not
                      then an error has occurred.
*/

static void CheckForSymbols (SymbolKey_SymbolTree Tree, const char *a_, unsigned int _a_high)
{
  DynamicStrings_String s;
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  if (! (SymbolKey_IsEmptyTree (Tree)))
    {
      s = DynamicStrings_InitString ((const char *) "the symbols are unknown at the end of module {%1Ea} when ", 57);
      s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) a, _a_high)));
      M2MetaError_MetaErrorString1 (s, MainModule);
      SymbolKey_ForeachNodeDo (Tree, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SymbolError});
    }
}


/*
   PutExportUndeclared - places a symbol, Sym, into module, ModSym,
                         ExportUndeclared list provided that Sym
                         is unknown.
*/

static void PutExportUndeclared (unsigned int ModSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsUnknown (Sym))
    {
      pSym = GetPsym (ModSym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ModuleSym:
            SymbolKey_PutSymKey (pSym->Module.ExportUndeclared, SymbolTable_GetSymName (Sym), Sym);
            break;

          case SymbolTable_DefImpSym:
            SymbolKey_PutSymKey (pSym->DefImp.ExportUndeclared, SymbolTable_GetSymName (Sym), Sym);
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
            break;
        }
    }
}


/*
   GetExportUndeclared - returns a symbol which has, name, from module, ModSym,
                         which is in the ExportUndeclared list.
*/

static unsigned int GetExportUndeclared (unsigned int ModSym, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        return static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Module.ExportUndeclared, name));
        break;

      case SymbolTable_DefImpSym:
        return static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.ExportUndeclared, name));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   RemoveExportUndeclared - removes a symbol, Sym, from the module, ModSym,
                            ExportUndeclaredTree.
*/

static void RemoveExportUndeclared (unsigned int ModSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        if ((SymbolKey_GetSymKey (pSym->Module.ExportUndeclared, SymbolTable_GetSymName (Sym))) == Sym)
          {
            SymbolKey_DelSymKey (pSym->Module.ExportUndeclared, SymbolTable_GetSymName (Sym));
          }
        break;

      case SymbolTable_DefImpSym:
        if ((SymbolKey_GetSymKey (pSym->DefImp.ExportUndeclared, SymbolTable_GetSymName (Sym))) == Sym)
          {
            SymbolKey_DelSymKey (pSym->DefImp.ExportUndeclared, SymbolTable_GetSymName (Sym));
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
}


/*
   CheckForExportedDeclaration - checks to see whether a definition module
                                 is currently being compiled, if so,
                                 symbol, Sym, is removed from the
                                 ExportUndeclared list.
                                 This procedure is called whenever a symbol
                                 is declared, thus attempting to reduce
                                 the ExportUndeclared list.
*/

static void CheckForExportedDeclaration (unsigned int Sym)
{
  if (M2Comp_CompilingDefinitionModule ())
    {
      RemoveExportUndeclared (SymbolTable_GetCurrentModule (), Sym);
    }
}


/*
   UndeclaredSymbolError - displays symbol name for symbol, Sym.
*/

static void UndeclaredSymbolError (unsigned int Sym)
{
  if (DebugUnknowns)
    {
      M2Printf_printf1 ((const char *) "undeclared symbol (%d)\\n", 24, (const unsigned char *) &Sym, (sizeof (Sym)-1));
    }
  M2MetaError_MetaError1 ((const char *) "{%1UC} undeclared symbol {%1a}", 30, Sym);
}


/*
   RemoveExportUnImplemented - removes a symbol, Sym, from the module, ModSym,
                               NeedToBeImplemented list.
*/

static void RemoveExportUnImplemented (unsigned int ModSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if ((SymbolKey_GetSymKey (pSym->DefImp.NeedToBeImplemented, SymbolTable_GetSymName (Sym))) == Sym)
          {
            SymbolKey_DelSymKey (pSym->DefImp.NeedToBeImplemented, SymbolTable_GetSymName (Sym));
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   RemoveFromExportRequest -
*/

static void RemoveFromExportRequest (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ExportRequestModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if ((SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymbolTable_GetSymName (Sym))) == Sym)
          {
            SymbolKey_DelSymKey (pSym->DefImp.ExportRequest, SymbolTable_GetSymName (Sym));
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   RemoveEnumerationFromExportRequest - removes enumeration symbol, sym,
                                        (and its fields) from the ExportRequest tree.
*/

static void RemoveEnumerationFromExportRequest (unsigned int ModSym, unsigned int Sym)
{
  if (SymbolTable_IsEnumeration (Sym))
    {
      ExportRequestModule = ModSym;
      RemoveFromExportRequest (Sym);
      SymbolTable_ForeachLocalSymDo (Sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) RemoveFromExportRequest});
    }
}


/*
   UnImplementedSymbolError - displays symbol name for symbol, Sym.
*/

static void UnImplementedSymbolError (unsigned int Sym)
{
  NameKey_Name n;

  CurrentError = M2Error_ChainError (SymbolTable_GetFirstUsed (Sym), CurrentError);
  if (SymbolTable_IsType (Sym))
    {
      n = SymbolTable_GetSymName (Sym);
      M2Error_ErrorFormat1 (CurrentError, (const char *) "hidden type is undeclared (%a)", 30, (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsProcedure (Sym))
    {
      /* avoid dangling else.  */
      n = SymbolTable_GetSymName (Sym);
      M2Error_ErrorFormat1 (CurrentError, (const char *) "procedure is undeclared (%a)", 28, (const unsigned char *) &n, (sizeof (n)-1));
    }
  else if (SymbolTable_IsProcType (Sym))
    {
      /* avoid dangling else.  */
      n = SymbolTable_GetSymName (Sym);
      M2Error_ErrorFormat1 (CurrentError, (const char *) "procedure type is undeclared (%a)", 33, (const unsigned char *) &n, (sizeof (n)-1));
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_ErrorFormat0 (CurrentError, (const char *) "undeclared symbol", 17);
    }
}


/*
   CheckEnumerationInList - places symbol, Sym, in the list, l,
                            providing it does not already exist.
                            PseudoScope(Sym) is called if Sym needs to
                            be added to the enumeration list, l.
*/

static void CheckEnumerationInList (Lists_List l, unsigned int Sym)
{
  if (! (Lists_IsItemInList (l, Sym)))
    {
      Lists_PutItemIntoList (l, Sym);
      SymbolTable_PseudoScope (Sym);
    }
}


/*
   CheckIfEnumerationExported - An outer module may use an enumeration that
                                is declared inside an inner module. The usage
                                may occur before definition. The first pass
                                exports a symbol, later the symbol is declared
                                as an emumeration type. At this stage the
                                CheckIfEnumerationExported procedure should be
                                called. This procedure ripples from the current
                                (inner) module to outer module and every time
                                it is exported it must be added to the outer
                                module EnumerationScopeList.
*/

static void CheckIfEnumerationExported (unsigned int Sym, unsigned int ScopeId)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int InnerModId;
  unsigned int OuterModId;
  unsigned int InnerModSym;
  unsigned int OuterModSym;

  InnerModId = GetModuleScopeId (ScopeId);
  if (InnerModId > 0)
    {
      OuterModId = GetModuleScopeId (InnerModId-1);
      if (OuterModId > 0)
        {
          pCall = GetPcall (InnerModId);
          InnerModSym = pCall->Search;
          pCall = GetPcall (OuterModId);
          OuterModSym = pCall->Search;
          if ((InnerModSym != SymbolTable_NulSym) && (OuterModSym != SymbolTable_NulSym))
            {
              if (SymbolTable_IsExported (InnerModSym, Sym))
                {
                  CheckForEnumerationInOuterModule (Sym, OuterModSym);
                  CheckIfEnumerationExported (Sym, OuterModId);
                }
            }
        }
    }
}


/*
   CheckForEnumerationInOuterModule - checks to see whether the enumeration
                                      type symbol, Sym, has been entered into
                                      the outer module, OuterModule, scope list.
                                      OuterModule may be internal to the
                                      program module.
*/

static void CheckForEnumerationInOuterModule (unsigned int Sym, unsigned int OuterModule)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (OuterModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Lists_IncludeItemIntoList (pSym->DefImp.EnumerationScopeList, Sym);
        break;

      case SymbolTable_ModuleSym:
        Lists_IncludeItemIntoList (pSym->Module.EnumerationScopeList, Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
}


/*
   MakeVariableForParam -
*/

static unsigned int MakeVariableForParam (unsigned int tok, NameKey_Name ParamName, unsigned int ProcSym, SymbolTable_ProcedureKind kind, unsigned int no, unsigned int ParmType, unsigned int typetok)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int VariableSym;

  tok = CheckTok (tok, (const char *) "parameter", 9);
  VariableSym = SymbolTable_MakeVar (tok, ParamName);
  pSym = GetPsym (VariableSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return SymbolTable_NulSym;
        break;

      case SymbolTable_VarSym:
        pSym->Var.IsParam = true;  /* Variable is really a parameter.  */
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
  /* Note that the parameter is now treated as a local variable.  */
  SymbolTable_PutVarTok (VariableSym, ParmType, typetok);
  SymbolTable_PutDeclared (tok, VariableSym);
  /* 
      Normal VAR parameters have LeftValue,
      however Unbounded VAR parameters have RightValue.
      Non VAR parameters always have RightValue.
  */
  if ((SymbolTable_IsVarParam (ProcSym, kind, no)) && (! (SymbolTable_IsUnboundedParam (ProcSym, kind, no))))
    {
      SymbolTable_PutMode (VariableSym, SymbolTable_LeftValue);
    }
  else
    {
      SymbolTable_PutMode (VariableSym, SymbolTable_RightValue);
    }
  return VariableSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddParameter - adds a parameter ParSym to a procedure Sym.
*/

static void AddParameter (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParSym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        Lists_PutItemIntoList (pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ListOfParam, ParSym);
        break;

      case SymbolTable_ProcTypeSym:
        Lists_PutItemIntoList (pSym->ProcType.ListOfParam, ParSym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
}


/*
   AddProcedureProcTypeParam - adds ParamType to the parameter ProcType
                               associated with procedure Sym.
*/

static void AddProcedureProcTypeParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded, bool isVarParam)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        if (pSym->Procedure.BuildProcType)
          {
            /* avoid gcc warning by using compound statement even if not strictly necessary.  */
            if (isVarParam)
              {
                SymbolTable_PutProcTypeVarParam (tok, pSym->Procedure.ProcedureType, ParamType, isUnbounded);
              }
            else
              {
                SymbolTable_PutProcTypeParam (tok, pSym->Procedure.ProcedureType, ParamType, isUnbounded);
              }
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Sym to be a procedure", 31);
        break;
    }
}


/*
   IsNthParamVar - returns true if the n th parameter of the parameter list,
                   List, is a VAR parameter.
*/

static bool IsNthParamVar (Lists_List Head, unsigned int n)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int p;

  p = static_cast<unsigned int> (Lists_GetItemFromList (Head, n));
  if (p == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "parameter does not exist", 24);
    }
  else
    {
      pSym = GetPsym (p);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ErrorSym:
            return false;
            break;

          case SymbolTable_VarParamSym:
            return true;
            break;

          case SymbolTable_ParamSym:
            return false;
            break;


          default:
            M2Error_InternalError ((const char *) "expecting Param or VarParam symbol", 34);
            break;
        }
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   MakeParameterHeapVar - create a heap variable if sym is a pointer.
*/

static unsigned int MakeParameterHeapVar (unsigned int tok, unsigned int type, SymbolTable_ModeOfAddr mode)
{
  unsigned int heapvar;

  tok = CheckTok (tok, (const char *) "parameter heap var", 18);
  heapvar = SymbolTable_NulSym;
  type = SymbolTable_SkipType (type);
  if (SymbolTable_IsPointer (type))
    {
      heapvar = SymbolTable_MakeTemporary (tok, mode);
      SymbolTable_PutVar (heapvar, type);
      SymbolTable_PutVarHeap (heapvar, true);
    }
  return heapvar;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutParameterHeapVar - creates a heap variable associated with parameter sym.
*/

static void PutParameterHeapVar (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
        break;

      case SymbolTable_VarParamSym:
        pSym->VarParam.HeapVar = MakeParameterHeapVar (SymbolTable_GetDeclaredMod (sym), pSym->VarParam.Type, SymbolTable_LeftValue);  /* Nothing to do for the non var parameter.  */
        break;


      default:
        M2Error_InternalError ((const char *) "Param or VarParam symbol expected", 33);
        break;
    }
}


/*
   IsProcedureAnyBoolean - returns the boolean result from p
                           for any of procedure kind which is defined.
*/

static bool IsProcedureAnyBoolean (unsigned int sym, SymbolTable_ProcAnyBoolean p)
{
  SymbolTable_ProcedureKind kind;

  for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
    {
      if (SymbolTable_GetProcedureDefined (sym, kind))
        {
          return (*p.proc) (sym, kind);
        }
    }
  M2Error_InternalError ((const char *) "no procedure kind exists", 24);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsProcedureAnyDefaultBoolean - returns the boolean result from p
                                  for any of procedure kind which is defined.
*/

static bool IsProcedureAnyDefaultBoolean (unsigned int sym, bool default_, SymbolTable_ProcAnyBoolean p)
{
  SymbolTable_ProcedureKind kind;

  for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
    {
      if (SymbolTable_GetProcedureDefined (sym, kind))
        {
          return (*p.proc) (sym, kind);
        }
    }
  return default_;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FillInUnknownFields -
*/

static void FillInUnknownFields (unsigned int tok, unsigned int sym, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  pSym->SymbolType = SymbolTable_UndefinedSym;
  pSym->Undefined.name = SymName;
  pSym->Undefined.oafamily = SymbolTable_NulSym;
  pSym->Undefined.errorScope = M2Error_GetCurrentErrorScope ();
  InitWhereFirstUsedTok (tok, &pSym->Undefined.At);
}


/*
   FillInPointerFields - given a new symbol, sym, make it a pointer symbol
                         and initialize its fields.
*/

static void FillInPointerFields (unsigned int Sym, NameKey_Name PointerName, unsigned int scope, unsigned int oaf)
{
  SymbolTable_PtrToSymbol pSym;

  if (! (SymbolTable_IsError (Sym)))
    {
      pSym = GetPsym (Sym);
      pSym->SymbolType = SymbolTable_PointerSym;
      switch (pSym->SymbolType)
        {
          case SymbolTable_PointerSym:
            pSym->Pointer.Type = SymbolTable_NulSym;
            pSym->Pointer.name = PointerName;
            pSym->Pointer.oafamily = oaf;  /* The unbounded for this  */
            SymbolKey_InitTree (&pSym->Pointer.ConstLitTree);  /* constants of this type  */
            pSym->Pointer.Scope = scope;  /* Which scope created it  */
            pSym->Pointer.Size = M2ALU_InitValue ();  /* Which scope created it  */
            pSym->Pointer.Align = SymbolTable_NulSym;  /* Alignment of this type  */
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a Pointer symbol", 26);  /* Alignment of this type  */
            break;
        }
    }
}


/*
   ForeachParameterDo -
*/

static void ForeachParameterDo (SymbolTable_CheckProcedure p)
{
  unsigned int l;
  unsigned int h;

  l = Indexing_LowIndice (Symbols);
  h = Indexing_HighIndice (Symbols);
  while (l <= h)
    {
      if (SymbolTable_IsParameter (l))
        {
          (*p.proc) (l);
        }
      l += 1;
    }
}


/*
   CheckUnbounded - checks to see if parameter, Sym, is now an unbounded parameter.
*/

static void CheckUnbounded (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
        if (SymbolTable_IsUnbounded (pSym->Param.Type))
          {
            pSym->Param.IsUnbounded = true;
          }
        break;

      case SymbolTable_VarParamSym:
        if (SymbolTable_IsUnbounded (pSym->VarParam.Type))
          {
            pSym->VarParam.IsUnbounded = true;
          }
        break;


      default:
        M2RTS_HALT (-1);
        __builtin_unreachable ();
        break;
    }
}


/*
   PutOAFamily - places the, oaf, into, SimpleType, oafamily field.
*/

static void PutOAFamily (unsigned int SimpleType, unsigned int oaf)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (SimpleType);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_RecordSym:
        pSym->Record.oafamily = oaf;
        break;

      case SymbolTable_SubrangeSym:
        pSym->Subrange.oafamily = oaf;
        break;

      case SymbolTable_EnumerationSym:
        pSym->Enumeration.oafamily = oaf;
        break;

      case SymbolTable_ArraySym:
        pSym->Array.oafamily = oaf;
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.oafamily = oaf;
        break;

      case SymbolTable_TypeSym:
        pSym->Type.oafamily = oaf;
        break;

      case SymbolTable_PointerSym:
        pSym->Pointer.oafamily = oaf;
        break;

      case SymbolTable_SetSym:
        pSym->Set.oafamily = oaf;
        break;

      case SymbolTable_UndefinedSym:
        pSym->Undefined.oafamily = oaf;
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this SimpleType", 29);
        break;
    }
}


/*
   doFillInOAFamily -
*/

static void doFillInOAFamily (unsigned int oaf, unsigned int i, unsigned int unbounded)
{
  unsigned int SimpleType;

  SimpleType = SymbolTable_GetType (oaf);
  if (unbounded != SymbolTable_NulSym)
    {
      FillInUnboundedFields (M2LexBuf_GetTokenNo (), unbounded, SimpleType, i);
    }
}


/*
   FillInUnboundedFields -
*/

static void FillInUnboundedFields (unsigned int tok, unsigned int sym, unsigned int SimpleType, unsigned int ndim)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Contents;
  unsigned int i;

  if (sym != SymbolTable_NulSym)
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_UnboundedSym;
      pSym->Unbounded.Type = SimpleType;  /* Index to a simple type.  */
      pSym->Unbounded.Size = M2ALU_InitValue ();  /* Size in bytes for this sym  */
      pSym->Unbounded.Scope = SymbolTable_GetScope (SimpleType);  /* Which scope will create it  */
      InitWhereDeclaredTok (tok, &pSym->Unbounded.At);  /* Declared here  */
      NewSym (&pSym->Unbounded.RecordType);  /* Declared here  */
      FillInRecordFields (tok, pSym->Unbounded.RecordType, NameKey_NulName, SymbolTable_GetScope (SimpleType), SymbolTable_NulSym);
      NewSym (&Contents);
      FillInPointerFields (Contents, NameKey_NulName, SymbolTable_GetScope (SimpleType), SymbolTable_NulSym);
      SymbolTable_PutPointer (Contents, SimpleType);
      /* create the contents field for the unbounded array.  */
      M2Debug_Assert ((SymbolTable_PutFieldRecord (pSym->Unbounded.RecordType, NameKey_MakeKey ((const char *) "_m2_contents", 12), Contents, SymbolTable_NulSym)) != SymbolTable_NulSym);
      /* create all the high fields for the unbounded array.  */
      i = 1;
      while (i <= ndim)
        {
          M2Debug_Assert ((SymbolTable_PutFieldRecord (pSym->Unbounded.RecordType, NameKey_makekey (DynamicStrings_string (DynamicStrings_Mark (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "_m2_high_%d", 11)), (const unsigned char *) &i, (sizeof (i)-1))))), M2Base_Cardinal, SymbolTable_NulSym)) != SymbolTable_NulSym);
          i += 1;
        }
      pSym->Unbounded.Dimensions = ndim;
      ForeachParameterDo ((SymbolTable_CheckProcedure) {(SymbolTable_CheckProcedure_t) CheckUnbounded});
    }
}


/*
   PutUnbounded - associates the unbounded symbol, open, with
                  SimpleType.
*/

static void PutUnbounded (unsigned int oaf, unsigned int sym, unsigned int ndim)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (oaf);
  switch (pSym->SymbolType)
    {
      case SymbolTable_OAFamilySym:
        /* need to check to see if we need to add NulSym for all dimensions < ndim
                          which have not been used.  */
        while (pSym->OAFamily.MaxDimensions < ndim)
          {
            pSym->OAFamily.MaxDimensions += 1;
            if (pSym->OAFamily.MaxDimensions < ndim)
              {
                /* add NulSym to an unused dimension.  */
                PutIntoIndex (&pSym->OAFamily.Dimensions, pSym->OAFamily.MaxDimensions, SymbolTable_NulSym);
              }
          }
        /* and finally add the known sym.  */
        PutIntoIndex (&pSym->OAFamily.Dimensions, ndim, sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting OAFamily symbol", 25);
        break;
    }
}


/*
   GetArrayDimension - returns the number of dimensions defined.
*/

static unsigned int GetArrayDimension (unsigned int sym)
{
  unsigned int n;

  n = 0;
  while (SymbolTable_IsArray (sym))
    {
      sym = SymbolTable_SkipType (SymbolTable_GetType (sym));
      n += 1;
    }
  return n;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ResolveConstructorType - if, sym, has an unresolved constructor type
                            then attempt to resolve it by examining the
                            from, type.
*/

static void ResolveConstructorType (unsigned int sym, unsigned int *type, unsigned int *from, bool *unres)
{
  if ((*unres))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (SymbolTable_IsConstructor ((*from)))
        {
          /* avoid dangling else.  */
          if (IsConstructorResolved ((*from)))
            {
              (*unres) = false;
              (*type) = SymbolTable_GetType ((*from));
              if (((*type) != SymbolTable_NulSym) && (SymbolTable_IsSet (SymbolTable_SkipType ((*type)))))
                {
                  SymbolTable_PutConstSet (sym);
                }
            }
        }
      else if (((*from) != SymbolTable_NulSym) && (SymbolTable_IsSet (SymbolTable_SkipType ((*from)))))
        {
          /* avoid dangling else.  */
          (*unres) = false;
          (*type) = (*from);
          SymbolTable_PutConstSet (sym);
        }
      else if (((*from) != SymbolTable_NulSym) && ((SymbolTable_IsRecord (SymbolTable_SkipType ((*from)))) || (SymbolTable_IsArray (SymbolTable_SkipType ((*from))))))
        {
          /* avoid dangling else.  */
          (*unres) = false;
          (*type) = (*from);
        }
    }
}


/*
   IsConstructorResolved - returns TRUE if the constructor does not
                           have an unresolved type.
*/

static bool IsConstructorResolved (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        return ! pSym->ConstVar.UnresFromType;
        break;

      case SymbolTable_ConstLitSym:
        return ! pSym->ConstLit.UnresFromType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstVar or ConstLit symbol", 37);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CanResolveConstructor - returns TRUE if the type of the constructor,
                           sym, is known.
*/

static bool CanResolveConstructor (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (! (IsConstructorResolved (sym)))
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ConstVarSym:
            ResolveConstructorType (sym, &pSym->ConstVar.Type, &pSym->ConstVar.FromType, &pSym->ConstVar.UnresFromType);
            break;

          case SymbolTable_ConstLitSym:
            ResolveConstructorType (sym, &pSym->ConstLit.Type, &pSym->ConstLit.FromType, &pSym->ConstLit.UnresFromType);
            break;


          default:
            M2Error_InternalError ((const char *) "expecting ConstVar or ConstLit symbol", 37);
            break;
        }
    }
  return IsConstructorResolved (sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckAllConstructorsResolved - checks to see that the
                                  UnresolvedConstructorType list is
                                  empty and if it is not then it
                                  generates error messages.
*/

static void CheckAllConstructorsResolved (void)
{
  unsigned int i;
  unsigned int n;
  unsigned int s;
  M2Error_Error e;

  n = Lists_NoOfItemsInList (UnresolvedConstructorType);
  if (n > 0)
    {
      for (i=1; i<=n; i++)
        {
          s = static_cast<unsigned int> (Lists_GetItemFromList (UnresolvedConstructorType, i));
          e = M2Error_NewError (SymbolTable_GetDeclaredMod (s));
          M2Error_ErrorFormat0 (e, (const char *) "constructor has an unknown type", 31);
        }
      M2Error_FlushErrors ();
    }
}


/*
   SanityCheckParameters -
*/

static void SanityCheckParameters (unsigned int sym)
{
  unsigned int p;
  unsigned int i;
  unsigned int n;

  i = 1;
  n = SymbolTable_NoOfParamAny (sym);
  while (i <= n)
    {
      p = SymbolTable_GetType (SymbolTable_GetParam (sym, i));
      if (SymbolTable_IsConst (p))
        {
          M2MetaError_MetaError3 ((const char *) "the {%1N} formal parameter in procedure {%2Dad} should have a type rather than a constant {%3Dad}", 97, i, sym, p);
        }
      i += 1;
    }
}


/*
   SanityCheckArray - checks to see that an array has a correct subrange type.
*/

static void SanityCheckArray (unsigned int sym)
{
  unsigned int type;
  unsigned int subscript;

  if (SymbolTable_IsArray (sym))
    {
      subscript = SymbolTable_GetArraySubscript (sym);
      if (subscript != SymbolTable_NulSym)
        {
          type = SymbolTable_SkipType (SymbolTable_GetType (subscript));
          if (SymbolTable_IsAModula2Type (type))
            {}  /* empty.  */
          else
            {
              /* ok all is good  */
              M2MetaError_MetaError2 ((const char *) "the array {%1Dad} must be declared with a simpletype in the [..] component rather than a {%2d}", 94, sym, type);
            }
        }
    }
}


/*
   ForeachSymbolDo - foreach symbol, call, P(sym).
*/

static void ForeachSymbolDo (SymbolKey_PerformOperation P)
{
  unsigned int i;
  unsigned int n;

  i = Indexing_LowIndice (Symbols);
  n = Indexing_HighIndice (Symbols);
  while (i <= n)
    {
      (*P.proc) (i);
      i += 1;
    }
}


/*
   SanityCheckProcedure - check to see that procedure parameters do not use constants
                          instead of types in their formal parameter section.
*/

static void SanityCheckProcedure (unsigned int sym)
{
  SanityCheckParameters (sym);
}


/*
   SanityCheckModule -
*/

static void SanityCheckModule (unsigned int sym)
{
  SymbolTable_ForeachInnerModuleDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SanityCheckModule});
  SymbolTable_ForeachProcedureDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SanityCheckProcedure});
  SymbolTable_ForeachLocalSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SanityCheckArray});
}


/*
   AddNameTo - adds Name, n, to tree, s.
*/

static void AddNameTo (SymbolKey_SymbolTree s, unsigned int o)
{
  if ((SymbolKey_GetSymKey (s, SymbolTable_GetSymName (o))) == SymbolKey_NulKey)
    {
      SymbolKey_PutSymKey (s, SymbolTable_GetSymName (o), o);
    }
}


/*
   CollectSymbolFrom -
*/

static unsigned int CollectSymbolFrom (unsigned int tok, unsigned int scope, NameKey_Name n)
{
  NameKey_Name n1;
  unsigned int sym;

  n1 = SymbolTable_GetSymName (scope);
  if (DebugUnknowns)
    {
      M2Printf_printf2 ((const char *) "declaring %a in %a", 18, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &n1, (sizeof (n1)-1));
    }
  sym = CheckScopeForSym (scope, n);
  if (sym == SymbolTable_NulSym)
    {
      sym = FetchUnknownFrom (tok, scope, n);
    }
  if (DebugUnknowns)
    {
      M2Printf_printf1 ((const char *) " symbol created (%d)\\n", 22, (const unsigned char *) &sym, (sizeof (sym)-1));
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CollectUnknown -
*/

static unsigned int CollectUnknown (unsigned int tok, unsigned int sym, NameKey_Name n)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int s;

  s = SymbolTable_NulSym;
  if ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)))
    {
      return CollectSymbolFrom (tok, sym, n);
    }
  else if (SymbolTable_IsProcedure (sym))
    {
      /* avoid dangling else.  */
      s = CheckScopeForSym (sym, n);
      if (s == SymbolTable_NulSym)
        {
          pSym = GetPsym (sym);
          switch (pSym->SymbolType)
            {
              case SymbolTable_ProcedureSym:
                if ((SymbolKey_GetSymKey (pSym->Procedure.NamedObjects, n)) != SymbolKey_NulKey)
                  {
                    return CollectSymbolFrom (tok, sym, n);
                  }
                break;


              default:
                M2Error_InternalError ((const char *) "expecting - Procedure symbol", 28);
                break;
            }
          s = CollectUnknown (tok, SymbolTable_GetScope (sym), n);
        }
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ResolveImport -
*/

static void ResolveImport (unsigned int o)
{
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int tok;
  unsigned int sym;

  if (DebugUnknowns)
    {
      n1 = SymbolTable_GetSymName (o);
      M2Printf_printf1 ((const char *) "attempting to find out where %a was declared\\n", 46, (const unsigned char *) &n1, (sizeof (n1)-1));
      n1 = SymbolTable_GetSymName (ResolveModule);
      n2 = SymbolTable_GetSymName (SymbolTable_GetScope (ResolveModule));
      M2Printf_printf2 ((const char *) "scope of module %a is %a\\n", 26, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
    }
  tok = SymbolTable_GetFirstUsed (o);
  sym = CollectUnknown (tok, SymbolTable_GetScope (ResolveModule), SymbolTable_GetSymName (o));
  if (sym == SymbolTable_NulSym)
    {
      M2MetaError_MetaError2 ((const char *) "unknown symbol {%1Uad} found in import list of module {%2a}", 59, o, ResolveModule);
    }
  else
    {
      SymbolTable_AddSymToModuleScope (ResolveModule, sym);
    }
}


/*
   ResolveRelativeImport -
*/

static void ResolveRelativeImport (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsModule (sym))
    {
      ResolveModule = sym;
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ModuleSym:
            SymbolKey_ForeachNodeDo (pSym->Module.NamedImports, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) ResolveImport});
            break;


          default:
            M2Error_InternalError ((const char *) "expecting - Module symbol", 25);
            break;
        }
    }
  SymbolTable_ForeachProcedureDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) ResolveRelativeImport});
  SymbolTable_ForeachInnerModuleDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) ResolveRelativeImport});
}


/*
   Max -
*/

static unsigned int Max (unsigned int a, unsigned int b)
{
  if (a > b)
    {
      return a;
    }
  else
    {
      return b;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Min -
*/

static unsigned int Min (unsigned int a, unsigned int b)
{
  if (a < b)
    {
      return a;
    }
  else
    {
      return b;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DoFindLimits - assigns, Start, and, End, to the start and end
                  limits contained in the list, l.  It ensures that
                  Start and End are within StartLimit..EndLimit.
                  If StartLimit or EndLimit are 0 then Start is
                  is set to the first value and End to the last.
*/

static void DoFindLimits (unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End, Lists_List l)
{
  unsigned int i;
  unsigned int j;
  unsigned int n;

  (*End) = 0;
  (*Start) = 0;
  i = 1;
  n = Lists_NoOfItemsInList (l);
  while (i <= n)
    {
      j = static_cast<unsigned int> (Lists_GetItemFromList (l, i));
      if (((j > (*End)) && (j >= StartLimit)) && ((j <= EndLimit) || (EndLimit == 0)))
        {
          (*End) = j;
        }
      if ((((((*Start) == 0) || (j < (*Start))) && (j != 0)) && (j >= StartLimit)) && ((j <= EndLimit) || (EndLimit == 0)))
        {
          (*Start) = j;
        }
      i += 1;
    }
}


/*
   PutDeclaredDefinition - associates the current tokenno with
                           the symbols declaration in the definition
                           module.
*/

static void PutDeclaredDefinition (unsigned int tok, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        pSym->Error.At.DefDeclared = tok;
        break;

      case SymbolTable_ObjectSym:
        pSym->Object.At.DefDeclared = tok;
        break;

      case SymbolTable_VarientSym:
        pSym->Varient.At.DefDeclared = tok;
        break;

      case SymbolTable_RecordSym:
        pSym->Record.At.DefDeclared = tok;
        break;

      case SymbolTable_SubrangeSym:
        pSym->Subrange.At.DefDeclared = tok;
        break;

      case SymbolTable_EnumerationSym:
        pSym->Enumeration.At.DefDeclared = tok;
        break;

      case SymbolTable_ArraySym:
        pSym->Array.At.DefDeclared = tok;
        break;

      case SymbolTable_SubscriptSym:
        pSym->Subscript.At.DefDeclared = tok;
        break;

      case SymbolTable_UnboundedSym:
        pSym->Unbounded.At.DefDeclared = tok;
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.At.DefDeclared = tok;
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.At.DefDeclared = tok;
        break;

      case SymbolTable_ConstStringSym:
        pSym->ConstString.At.DefDeclared = tok;
        break;

      case SymbolTable_ConstLitSym:
        pSym->ConstLit.At.DefDeclared = tok;
        break;

      case SymbolTable_ConstVarSym:
        pSym->ConstVar.At.DefDeclared = tok;
        break;

      case SymbolTable_VarSym:
        pSym->Var.At.DefDeclared = tok;
        break;

      case SymbolTable_TypeSym:
        pSym->Type.At.DefDeclared = tok;
        break;

      case SymbolTable_PointerSym:
        pSym->Pointer.At.DefDeclared = tok;
        break;

      case SymbolTable_RecordFieldSym:
        pSym->RecordField.At.DefDeclared = tok;
        break;

      case SymbolTable_VarientFieldSym:
        pSym->VarientField.At.DefDeclared = tok;
        break;

      case SymbolTable_EnumerationFieldSym:
        pSym->EnumerationField.At.DefDeclared = tok;
        break;

      case SymbolTable_SetSym:
        pSym->Set.At.DefDeclared = tok;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.At.DefDeclared = tok;
        break;

      case SymbolTable_ModuleSym:
        pSym->Module.At.DefDeclared = tok;
        break;

      case SymbolTable_UndefinedSym:
        break;

      case SymbolTable_PartialUnboundedSym:
        PutDeclaredDefinition (tok, pSym->PartialUnbounded.Type);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this type of symbol", 33);
        break;
    }
}


/*
   PutDeclaredModule - returns the token where this symbol was declared
                       in an implementation or program module.
*/

static void PutDeclaredModule (unsigned int tok, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        pSym->Error.At.ModDeclared = tok;
        break;

      case SymbolTable_ObjectSym:
        pSym->Object.At.ModDeclared = tok;
        break;

      case SymbolTable_VarientSym:
        pSym->Varient.At.ModDeclared = tok;
        break;

      case SymbolTable_RecordSym:
        pSym->Record.At.ModDeclared = tok;
        break;

      case SymbolTable_SubrangeSym:
        pSym->Subrange.At.ModDeclared = tok;
        break;

      case SymbolTable_EnumerationSym:
        pSym->Enumeration.At.ModDeclared = tok;
        break;

      case SymbolTable_ArraySym:
        pSym->Array.At.ModDeclared = tok;
        break;

      case SymbolTable_SubscriptSym:
        pSym->Subscript.At.ModDeclared = tok;
        break;

      case SymbolTable_UnboundedSym:
        pSym->Unbounded.At.ModDeclared = tok;
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.At.ModDeclared = tok;
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.At.ModDeclared = tok;
        break;

      case SymbolTable_ConstStringSym:
        pSym->ConstString.At.ModDeclared = tok;
        break;

      case SymbolTable_ConstLitSym:
        pSym->ConstLit.At.ModDeclared = tok;
        break;

      case SymbolTable_ConstVarSym:
        pSym->ConstVar.At.ModDeclared = tok;
        break;

      case SymbolTable_VarSym:
        pSym->Var.At.ModDeclared = tok;
        break;

      case SymbolTable_TypeSym:
        pSym->Type.At.ModDeclared = tok;
        break;

      case SymbolTable_PointerSym:
        pSym->Pointer.At.ModDeclared = tok;
        break;

      case SymbolTable_RecordFieldSym:
        pSym->RecordField.At.ModDeclared = tok;
        break;

      case SymbolTable_VarientFieldSym:
        pSym->VarientField.At.ModDeclared = tok;
        break;

      case SymbolTable_EnumerationFieldSym:
        pSym->EnumerationField.At.ModDeclared = tok;
        break;

      case SymbolTable_SetSym:
        pSym->Set.At.ModDeclared = tok;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.At.ModDeclared = tok;
        break;

      case SymbolTable_ModuleSym:
        pSym->Module.At.ModDeclared = tok;
        break;

      case SymbolTable_UndefinedSym:
        break;

      case SymbolTable_PartialUnboundedSym:
        PutDeclaredModule (tok, pSym->PartialUnbounded.Type);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this type of symbol", 33);
        break;
    }
}


/*
   DoIsConst - returns TRUE if Sym is defined as a constant
               or is an enumeration field or string.
*/

static bool DoIsConst (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return ((((pSym->SymbolType == SymbolTable_ConstVarSym) || (pSym->SymbolType == SymbolTable_ConstLitSym)) || (pSym->SymbolType == SymbolTable_ConstStringSym)) || ((pSym->SymbolType == SymbolTable_VarSym) && (pSym->Var.AddrMode == SymbolTable_ImmediateValue))) || (pSym->SymbolType == SymbolTable_EnumerationFieldSym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFromIndex - return a value from list, i, at position, n.
*/

static unsigned int GetFromIndex (Indexing_Index i, unsigned int n)
{
  typedef unsigned int *GetFromIndex__T2;

  GetFromIndex__T2 p;

  p = static_cast<GetFromIndex__T2> (Indexing_GetIndice (i, n));
  return (*p);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutIntoIndex - places value, v, into list, i, at position, n.
*/

static void PutIntoIndex (Indexing_Index *i, unsigned int n, unsigned int v)
{
  typedef unsigned int *PutIntoIndex__T3;

  PutIntoIndex__T3 p;

  Storage_ALLOCATE ((void **) &p, sizeof (unsigned int));
  (*p) = v;
  Indexing_PutIndice ((*i), n, reinterpret_cast <void *> (p));
}


/*
   PushConstString - pushes the character string onto the ALU stack.
                     It assumes that the character string is only
                     one character long.
*/

static void PushConstString (unsigned int Sym)
{
  typedef struct PushConstString__T7_a PushConstString__T7;

  struct PushConstString__T7_a { char array[10+1]; };
  SymbolTable_PtrToSymbol pSym;
  PushConstString__T7 a;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        if (pSym->ConstString.Length == 0)
          {
            M2ALU_PushChar (ASCII_nul);
          }
        else if (pSym->ConstString.Length == 1)
          {
            /* avoid dangling else.  */
            NameKey_GetKey (pSym->ConstString.Contents, (char *) &a.array[0], 10);
            M2ALU_PushChar (a.array[0]);
          }
        else
          {
            /* avoid dangling else.  */
            M2Error_WriteFormat0 ((const char *) "ConstString must be length 0 or 1", 33);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstString symbol", 28);
        break;
    }
}


/*
   FinalSymbol - returns the highest number symbol used.
*/

extern "C" unsigned int SymbolTable_FinalSymbol (void)
{
  return FreeSymbol-1;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeComponentRecord - make a temporary which will be used to reference and field
                         (or sub field) of record.
*/

extern "C" unsigned int SymbolTable_MakeComponentRecord (unsigned int tok, SymbolTable_ModeOfAddr Mode, unsigned int record)
{
  return buildTemporary (tok, Mode, true, record);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeComponentRef - use, sym, to reference, field, sym is returned.
*/

extern "C" unsigned int SymbolTable_MakeComponentRef (unsigned int sym, unsigned int field)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int high;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        if (! pSym->Var.IsTemp)
          {
            M2Error_InternalError ((const char *) "variable must be a temporary", 28);
          }
        else if (pSym->Var.IsComponentRef)
          {
            /* avoid dangling else.  */
            high = Indexing_HighIndice (pSym->Var.list);
            PutIntoIndex (&pSym->Var.list, high+1, field);
          }
        else
          {
            /* avoid dangling else.  */
            M2Error_InternalError ((const char *) "temporary is not a component reference", 38);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a variable symbol", 27);
        break;
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsComponent - returns TRUE if symbol, sym, is a temporary and a component
                 reference.
*/

extern "C" bool SymbolTable_IsComponent (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.IsComponentRef;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeTemporary - Makes a new temporary variable at the highest real scope.
                   The addressing mode of the temporary is set to NoValue.
*/

extern "C" unsigned int SymbolTable_MakeTemporary (unsigned int tok, SymbolTable_ModeOfAddr Mode)
{
  tok = CheckTok (tok, (const char *) "temporary", 9);
  return buildTemporary (tok, Mode, false, SymbolTable_NulSym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeTemporaryFromExpression - makes a new temporary variable at the
                                 highest real scope.  The addressing
                                 mode of the temporary is set and the
                                 type is determined by expressions, e.
*/

extern "C" unsigned int SymbolTable_MakeTemporaryFromExpression (unsigned int tok, unsigned int e, SymbolTable_ModeOfAddr mode)
{
  return SymbolTable_MakeTemporaryFromExpressions (tok, e, e, mode);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeTemporaryFromExpressions - makes a new temporary variable at the
                                  highest real scope.  The addressing
                                  mode of the temporary is set and the
                                  type is determined by expressions,
                                  e1 and e2.
*/

extern "C" unsigned int SymbolTable_MakeTemporaryFromExpressions (unsigned int tok, unsigned int e1, unsigned int e2, SymbolTable_ModeOfAddr mode)
{
  SymbolTable_PtrToSymbol pSym;
  DynamicStrings_String s;
  unsigned int t;
  unsigned int Sym;

  TemporaryNo += 1;
  /* Make the name  */
  s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "_T%d", 4)), (const unsigned char *) &TemporaryNo, (sizeof (TemporaryNo)-1));
  if (mode == SymbolTable_ImmediateValue)
    {
      Sym = SymbolTable_MakeConstVar (tok, NameKey_makekey (DynamicStrings_string (s)));
      if (SymbolTable_IsConstructor (e1))
        {
          SymbolTable_PutConstructor (Sym);
          SymbolTable_PutConstructorFrom (Sym, e1);
        }
      else if (SymbolTable_IsConstructor (e2))
        {
          /* avoid dangling else.  */
          SymbolTable_PutConstructor (Sym);
          SymbolTable_PutConstructorFrom (Sym, e2);
        }
      else
        {
          /* avoid dangling else.  */
          SymbolTable_PutVar (Sym, M2Base_MixTypes (SymbolTable_GetType (e1), SymbolTable_GetType (e2), tok));
        }
      PutConstVarTemporary (Sym);
    }
  else
    {
      Sym = SymbolTable_MakeVar (tok, NameKey_makekey (DynamicStrings_string (s)));
      pSym = GetPsym (Sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            pSym->Var.AddrMode = mode;
            pSym->Var.IsComponentRef = false;
            pSym->Var.IsTemp = true;  /* Variable is a temporary var  */
            /* Declared here  */
            InitWhereDeclaredTok (tok, &pSym->Var.At);
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
            break;
        }
      t = M2Base_MixTypesDecl (e1, e2, SymbolTable_GetType (e1), SymbolTable_GetType (e2), tok);
      if (t != SymbolTable_NulSym)
        {
          M2Debug_Assert (! (SymbolTable_IsConstructor (t)));
          SymbolTable_PutVar (Sym, t);
        }
    }
  s = DynamicStrings_KillString (s);
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutMode - Puts the addressing mode, SymMode, into symbol Sym.
             The mode may only be altered if the mode
             is None.
*/

extern "C" void SymbolTable_PutMode (unsigned int Sym, SymbolTable_ModeOfAddr SymMode)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_VarSym:
        pSym->Var.AddrMode = SymMode;
        break;


      default:
        M2Error_InternalError ((const char *) "Expecting VarSym", 16);
        break;
    }
}


/*
   GetMode - Returns the addressing mode of a symbol.
*/

extern "C" SymbolTable_ModeOfAddr SymbolTable_GetMode (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        M2Error_ErrorAbort0 ((const char *) "", 0);
        break;

      case SymbolTable_VarSym:
        return pSym->Var.AddrMode;
        break;

      case SymbolTable_ConstLitSym:
        return SymbolTable_ImmediateValue;
        break;

      case SymbolTable_ConstVarSym:
        return SymbolTable_ImmediateValue;
        break;

      case SymbolTable_ConstStringSym:
        return SymbolTable_ImmediateValue;
        break;

      case SymbolTable_EnumerationFieldSym:
        return SymbolTable_ImmediateValue;
        break;

      case SymbolTable_ProcedureSym:
        return SymbolTable_ImmediateValue;
        break;

      case SymbolTable_RecordFieldSym:
        return SymbolTable_ImmediateValue;
        break;

      case SymbolTable_VarientFieldSym:
        return SymbolTable_ImmediateValue;
        break;

      case SymbolTable_TypeSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_ArraySym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_SubrangeSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_EnumerationSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_RecordSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_PointerSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_SetSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_ProcTypeSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_UnboundedSym:
        return SymbolTable_NoValue;
        break;

      case SymbolTable_UndefinedSym:
        return SymbolTable_NoValue;
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this type", 23);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   StartScope - starts a block scope at Sym. Transparent determines
                whether the search for a symbol will look at the
                previous ScopeCallFrame if Sym does not contain the
                symbol that GetSym is searching.

                WITH statements are partially implemented by calling
                StartScope. Therefore we must retain the old Main from
                the previous ScopePtr when a record is added to the scope
                stack. (Main contains the symbol where all identifiers
                should be added.)
*/

extern "C" void SymbolTable_StartScope (unsigned int Sym)
{
  SymbolTable_PtrToCallFrame oCall;
  SymbolTable_PtrToCallFrame pCall;

  Sym = SymbolTable_SkipType (Sym);
  /* 
   WriteString('New scope is: ') ; WriteKey(GetSymName(Sym)) ; WriteLn ;
  */
  ScopePtr += 1;
  if (Indexing_InBounds (ScopeCallFrame, ScopePtr))
    {
      pCall = GetPcall (ScopePtr);
    }
  else
    {
      Storage_ALLOCATE ((void **) &pCall, sizeof (SymbolTable_CallFrame));
      Indexing_PutIndice (ScopeCallFrame, ScopePtr, reinterpret_cast <void *> (pCall));
    }
  pCall->Start = ScopePtr-1;  /* Previous ScopePtr value before StartScope  */
  pCall->Search = Sym;
  /* new symbols to ie temporary variables.  */
  if (SymbolTable_IsRecord (Sym))
    {
      oCall = GetPcall (ScopePtr-1);
      pCall->Main = oCall->Main;
    }
  else
    {
      pCall->Main = Sym;
      PlaceMajorScopesEnumerationListOntoStack (Sym);
    }
}


/*
   EndScope - ends a block scope started by StartScope. The current
              head of the symbol scope reverts back to the symbol
              which was the Head of the symbol scope before the
              last StartScope was called.
*/

extern "C" void SymbolTable_EndScope (void)
{
  SymbolTable_PtrToCallFrame pCall;

  /* 
   ; WriteString('EndScope - ending scope: ') ;
   pCall := GetPcall(ScopePtr) ;
   ; WriteKey(GetSymName(pCall^.Search)) ; WriteLn ;
  */
  pCall = GetPcall (ScopePtr);
  /* ; DisplayScopes  */
  ScopePtr = pCall->Start;
}


/*
   PseudoScope - starts a pseudo scope at Sym.
                 We always connect parent up to the last scope,
                 to determine the transparancy of a scope we call
                 TransparentScope.

                 A Pseudo scope has no end block,
                 but is terminated when the next EndScope is used.
                 The function of the pseudo scope is to provide an
                 automatic mechanism to solve enumeration types.
                 A declared enumeration type is a Pseudo scope and
                 identifiers used with the name of an enumeration
                 type field will find the enumeration symbol by
                 the scoping algorithm.
*/

extern "C" void SymbolTable_PseudoScope (unsigned int Sym)
{
  SymbolTable_PtrToCallFrame oCall;
  SymbolTable_PtrToCallFrame pCall;

  if (SymbolTable_IsEnumeration (Sym))
    {
      ScopePtr += 1;
      if (Indexing_InBounds (ScopeCallFrame, ScopePtr))
        {
          pCall = GetPcall (ScopePtr);
        }
      else
        {
          Storage_ALLOCATE ((void **) &pCall, sizeof (SymbolTable_CallFrame));
          Indexing_PutIndice (ScopeCallFrame, ScopePtr, reinterpret_cast <void *> (pCall));
        }
      oCall = GetPcall (ScopePtr-1);
      pCall->Main = oCall->Main;
      pCall->Start = oCall->Start;
      pCall->Search = Sym;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting EnumerationSym", 24);
    }
}


/*
   GetCurrentScope - returns the symbol who is responsible for the current
                     scope. Note that it ignore pseudo scopes.
*/

extern "C" unsigned int SymbolTable_GetCurrentScope (void)
{
  SymbolTable_PtrToCallFrame pCall;

  pCall = GetPcall (ScopePtr);
  return pCall->Main;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsDeclaredIn - returns TRUE if a symbol was declared in, scope.
*/

extern "C" bool SymbolTable_IsDeclaredIn (unsigned int scope, unsigned int sym)
{
  unsigned int s;

  s = SymbolTable_GetScope (sym);
  while (s != scope)
    {
      if ((((s == SymbolTable_NulSym) || (SymbolTable_IsProcedure (s))) || (SymbolTable_IsModule (s))) || (SymbolTable_IsDefImp (s)))
        {
          return false;
        }
      else
        {
          s = SymbolTable_GetScope (s);
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetCurrentModule - Used to set the CurrentModule to a symbol, Sym.
                      This Sym must represent the module name of the
                      file currently being compiled.
*/

extern "C" void SymbolTable_SetCurrentModule (unsigned int Sym)
{
  CurrentModule = Sym;
}


/*
   SetFileModule - Used to set the FileModule to a symbol, Sym.
                   This Sym must represent the current program module
                   file which is being parsed.
*/

extern "C" void SymbolTable_SetFileModule (unsigned int Sym)
{
  FileModule = Sym;
}


/*
   SetMainModule - Used to set the MainModule to a symbol, Sym.
                   This Sym must represent the main module which was
                   envoked by the user to be compiled.
*/

extern "C" void SymbolTable_SetMainModule (unsigned int Sym)
{
  MainModule = Sym;
}


/*
   CheckAnonymous - checks to see whether the name is NulName and if so
                    it creates a unique anonymous name.
*/

extern "C" NameKey_Name SymbolTable_CheckAnonymous (NameKey_Name name)
{
  if (name == NameKey_NulName)
    {
      AnonymousName += 1;
      name = NameKey_makekey (DynamicStrings_string (DynamicStrings_Mark (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "__anon%d", 8)), (const unsigned char *) &AnonymousName, (sizeof (AnonymousName)-1)))));
    }
  return name;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsNameAnonymous - returns TRUE if the symbol, sym, has an anonymous name
                     or no name.
*/

extern "C" bool SymbolTable_IsNameAnonymous (unsigned int sym)
{
  typedef struct IsNameAnonymous__T8_a IsNameAnonymous__T8;

  struct IsNameAnonymous__T8_a { char array[5+1]; };
  IsNameAnonymous__T8 a;
  NameKey_Name n;

  n = SymbolTable_GetSymName (sym);
  if (n == NameKey_NulName)
    {
      return true;
    }
  else
    {
      NameKey_GetKey (n, (char *) &a.array[0], 5);
      return StrLib_StrEqual ((const char *) &a.array[0], 5, (const char *) "__anon", 6);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NoOfVariables - returns the number of variables in scope.  The scope maybe
                   a procedure, module or defimp scope.
*/

extern "C" unsigned int SymbolTable_NoOfVariables (unsigned int scope)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsProcedure (scope))
    {
      return SymbolTable_NoOfLocalVar (scope);
    }
  else if (SymbolTable_IsModule (scope))
    {
      /* avoid dangling else.  */
      pSym = GetPsym (scope);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ModuleSym:
            return Lists_NoOfItemsInList (pSym->Module.ListOfVars);
            break;


          default:
            M2Error_InternalError ((const char *) "expecting module symbol", 23);
            break;
        }
    }
  else if (SymbolTable_IsDefImp (scope))
    {
      /* avoid dangling else.  */
      pSym = GetPsym (scope);
      switch (pSym->SymbolType)
        {
          case SymbolTable_DefImpSym:
            return Lists_NoOfItemsInList (pSym->DefImp.ListOfVars);
            break;


          default:
            M2Error_InternalError ((const char *) "expecting defimp symbol", 23);
            break;
        }
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting procedure, module or defimp symbol", 44);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   MakeModule - creates a module sym with ModuleName. It returns the
                symbol index.
*/

extern "C" unsigned int SymbolTable_MakeModule (unsigned int tok, NameKey_Name ModuleName)
{
  SymbolTable_PtrToSymbol pSym;
  SymbolTable_PtrToCallFrame pCall;
  unsigned int Sym;

  /* 
      Make a new symbol since we are at the outer scope level.
      DeclareSym examines the current scope level for any symbols
      that have the correct name, but are yet undefined.
      Therefore we must not call DeclareSym but create a symbol
      directly.
  */
  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_ModuleSym;
  pSym->Module.name = ModuleName;  /* Index into name array, name  */
  /* of record field.  */
  pSym->Module.libname = NameKey_NulName;  /* Library association.  */
  InitCtor (&pSym->Module.ctors);  /* Init all ctor functions.  */
  Lists_InitList (&pSym->Module.ModListOfDep);  /* Vector of SymDependency.  */
  SymbolKey_InitTree (&pSym->Module.LocalSymbols);  /* The LocalSymbols hold all the  */
  /* END WeAreHere.  */
  SymbolKey_InitTree (&pSym->Module.ExportTree);  /* Holds all the exported  */
  /* deleted at the end of Pass 1.  */
  SymbolKey_InitTree (&pSym->Module.ImportTree);  /* Contains all IMPORTed  */
  /* identifiers.  */
  Lists_InitList (&pSym->Module.IncludeList);  /* Contains all included symbols  */
  /* modulename.Symbol  */
  SymbolKey_InitTree (&pSym->Module.ExportUndeclared);  /* ExportUndeclared contains all  */
  /* been declared.  */
  Lists_InitList (&pSym->Module.EnumerationScopeList);  /* Enumeration scope list which  */
  /* Outer Module.  */
  SymbolKey_InitTree (&pSym->Module.NamedObjects);  /* Names of all items declared.  */
  SymbolKey_InitTree (&pSym->Module.NamedImports);  /* Names of items imported.  */
  SymbolKey_InitTree (&pSym->Module.WhereImported);  /* Sym to TokenNo where import  */
  /* occurs. Error message use.  */
  pSym->Module.Priority = SymbolTable_NulSym;  /* Priority of the module. This  */
  /* is an index to a constant.  */
  SymbolKey_InitTree (&pSym->Module.Unresolved);  /* All symbols currently  */
  /* unresolved in this module.  */
  pSym->Module.StartQuad = 0;  /* Signify the initialization  */
  /* code.  */
  pSym->Module.EndQuad = 0;  /* EndQuad should point to a  */
  /* goto quad.  */
  pSym->Module.StartFinishQuad = 0;  /* Signify the finalization  */
  /* code.  */
  pSym->Module.EndFinishQuad = 0;  /* should point to a finish  */
  pSym->Module.FinallyFunction = NULL;  /* The GCC function for finally  */
  pSym->Module.ExceptionFinally = false;  /* does it have an exception?  */
  pSym->Module.ExceptionBlock = false;  /* does it have an exception?  */
  pSym->Module.ModLink = GetLink ();  /* Is this parsed for linkage?  */
  pSym->Module.Builtin = false;  /* Is the module builtin?  */
  Lists_InitList (&pSym->Module.ListOfVars);  /* List of variables in this  */
  /* scope.  */
  Lists_InitList (&pSym->Module.ListOfProcs);  /* List of all procedures  */
  /* declared within this module.  */
  Lists_InitList (&pSym->Module.ListOfModules);  /* List of all inner modules.  */
  InitWhereDeclaredTok (tok, &pSym->Module.At);  /* Where symbol declared.  */
  InitWhereFirstUsedTok (tok, &pSym->Module.At);  /* Where symbol first used.  */
  pCall = GetPcall (ScopePtr);  /* Where symbol first used.  */
  if (pCall->Main == (SymbolTable_GetBaseModule ()))
    {
      pSym->Module.Scope = SymbolTable_NulSym;
    }
  else
    {
      pSym->Module.Scope = pCall->Main;
    }
  pSym->Module.errorScope = M2Error_GetCurrentErrorScope ();  /* Title error scope.  */
  SymbolKey_PutSymKey (ModuleTree, ModuleName, Sym);  /* Title error scope.  */
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeDefImp - creates a definition and implementation module sym
                with name DefImpName.  It returns the symbol index.
*/

extern "C" unsigned int SymbolTable_MakeDefImp (unsigned int tok, NameKey_Name DefImpName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  /* tok := CheckTok (tok, 'defimp') ;  */
  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_DefImpSym;
  pSym->DefImp.name = DefImpName;  /* Index into name array, name  */
  /* of record field.  */
  pSym->DefImp.libname = NameKey_NulName;  /* Library association.  */
  InitCtor (&pSym->DefImp.ctors);
  /* Init all ctor functions.  */
  Lists_InitList (&pSym->DefImp.DefListOfDep);  /* Vector of SymDependency.  */
  Lists_InitList (&pSym->DefImp.ModListOfDep);  /* Vector of SymDependency.  */
  SymbolKey_InitTree (&pSym->DefImp.ExportQualifiedTree);
  /* deleted at the end of Pass 1.  */
  SymbolKey_InitTree (&pSym->DefImp.ExportUnQualifiedTree);
  /* deleted at the end of Pass 1.  */
  SymbolKey_InitTree (&pSym->DefImp.ExportRequest);  /* Contains all identifiers that  */
  /* this list.  */
  SymbolKey_InitTree (&pSym->DefImp.ImportTree);  /* Contains all IMPORTed  */
  /* identifiers.  */
  Lists_InitList (&pSym->DefImp.IncludeList);  /* Contains all included symbols  */
  /* modulename.Symbol  */
  Lists_InitList (&pSym->DefImp.DefIncludeList);  /* Contains all included symbols  */
  /* in the definition module only  */
  SymbolKey_InitTree (&pSym->DefImp.ExportUndeclared);  /* ExportUndeclared contains all  */
  /* been declared.  */
  SymbolKey_InitTree (&pSym->DefImp.NeedToBeImplemented);
  /* implemented.  */
  SymbolKey_InitTree (&pSym->DefImp.LocalSymbols);  /* The LocalSymbols hold all the  */
  /* END WeAreHere.  */
  Lists_InitList (&pSym->DefImp.EnumerationScopeList);
  /* visable within this scope.  */
  SymbolKey_InitTree (&pSym->DefImp.NamedObjects);  /* names of all items declared.  */
  SymbolKey_InitTree (&pSym->DefImp.NamedImports);  /* Names of items imported.  */
  SymbolKey_InitTree (&pSym->DefImp.WhereImported);  /* Sym to TokenNo where import  */
  /* occurs. Error message use.  */
  pSym->DefImp.Priority = SymbolTable_NulSym;  /* Priority of the module. This  */
  /* is an index to a constant.  */
  SymbolKey_InitTree (&pSym->DefImp.Unresolved);  /* All symbols currently  */
  /* unresolved in this module.  */
  pSym->DefImp.StartQuad = 0;  /* Signify the initialization  */
  /* code.  */
  pSym->DefImp.EndQuad = 0;  /* EndQuad should point to a  */
  /* goto quad.  */
  pSym->DefImp.StartFinishQuad = 0;  /* Signify the finalization  */
  /* code.  */
  pSym->DefImp.EndFinishQuad = 0;  /* should point to a finish  */
  pSym->DefImp.FinallyFunction = NULL;  /* The GCC function for finally  */
  pSym->DefImp.ExceptionFinally = false;  /* does it have an exception?  */
  pSym->DefImp.ExceptionBlock = false;  /* does it have an exception?  */
  pSym->DefImp.ContainsHiddenType = false;  /* True if this module  */
  /* implements a hidden type.  */
  pSym->DefImp.ContainsBuiltin = false;  /* Does module define a builtin  */
  /* procedure?  */
  pSym->DefImp.ForC = false;  /* Is it a definition for "C"  */
  pSym->DefImp.NeedExportList = false;  /* Must user supply export list?  */
  pSym->DefImp.DefLink = GetLink ();  /* Is the def/mod file only  */
  pSym->DefImp.ModLink = GetLink ();  /* parsed for linkage?  */
  pSym->DefImp.Builtin = false;  /* Is the module builtin?  */
  Lists_InitList (&pSym->DefImp.ListOfVars);  /* List of variables in this  */
  /* scope.  */
  Lists_InitList (&pSym->DefImp.ListOfProcs);  /* List of all procedures  */
  /* declared within this module.  */
  Lists_InitList (&pSym->DefImp.ListOfModules);  /* List of all inner modules.  */
  InitWhereDeclaredTok (tok, &pSym->DefImp.At);  /* Where symbol declared.  */
  InitWhereFirstUsedTok (tok, &pSym->DefImp.At);  /* Where symbol first used.  */
  pSym->DefImp.errorScope = M2Error_GetCurrentErrorScope ();  /* Title error scope.  */
  SymbolKey_PutSymKey (ModuleTree, DefImpName, Sym);  /* Title error scope.  */
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeInnerModule - creates an inner module sym with ModuleName. It returns the
                     symbol index.
*/

extern "C" unsigned int SymbolTable_MakeInnerModule (unsigned int tok, NameKey_Name ModuleName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  Sym = DeclareSym (tok, ModuleName);
  if (! (SymbolTable_IsError (Sym)))
    {
      pSym = GetPsym (Sym);
      pSym->SymbolType = SymbolTable_ModuleSym;
      pSym->Module.name = ModuleName;  /* Index into name array, name  */
      /* of record field.  */
      pSym->Module.libname = NameKey_NulName;  /* Library association.  */
      InitCtor (&pSym->Module.ctors);  /* Init all ctor functions.  */
      SymbolKey_InitTree (&pSym->Module.LocalSymbols);  /* The LocalSymbols hold all the  */
      /* END WeAreHere.  */
      SymbolKey_InitTree (&pSym->Module.ExportTree);  /* Holds all the exported  */
      /* deleted at the end of Pass 1.  */
      SymbolKey_InitTree (&pSym->Module.ImportTree);  /* Contains all IMPORTed  */
      /* identifiers.  */
      Lists_InitList (&pSym->Module.IncludeList);  /* Contains all included symbols  */
      /* modulename.Symbol  */
      SymbolKey_InitTree (&pSym->Module.ExportUndeclared);  /* ExportUndeclared contains all  */
      /* been declared.  */
      Lists_InitList (&pSym->Module.EnumerationScopeList);  /* Enumeration scope list which  */
      /* visable within this scope.  */
      SymbolKey_InitTree (&pSym->Module.NamedObjects);  /* Names of all items declared.  */
      SymbolKey_InitTree (&pSym->Module.NamedImports);  /* Names of items imported.  */
      SymbolKey_InitTree (&pSym->Module.WhereImported);
      /* occurs. Error message use.  */
      pSym->Module.Priority = SymbolTable_NulSym;  /* Priority of the module. This  */
      /* is an index to a constant.  */
      SymbolKey_InitTree (&pSym->Module.Unresolved);  /* All symbols currently  */
      /* unresolved in this module.  */
      pSym->Module.StartQuad = 0;  /* Signify the initialization  */
      /* code.  */
      pSym->Module.EndQuad = 0;  /* EndQuad should point to a  */
      /* goto quad.  */
      pSym->Module.StartFinishQuad = 0;  /* Signify the finalization  */
      /* code.  */
      pSym->Module.EndFinishQuad = 0;  /* should point to a finish  */
      pSym->Module.FinallyFunction = NULL;  /* The GCC function for finally  */
      pSym->Module.ExceptionFinally = false;  /* does it have an exception?  */
      pSym->Module.ExceptionBlock = false;  /* does it have an exception?  */
      pSym->Module.ModLink = GetLink ();  /* Is this parsed for linkage?  */
      Lists_InitList (&pSym->Module.ListOfVars);  /* List of variables in this  */
      /* scope.  */
      Lists_InitList (&pSym->Module.ListOfProcs);  /* List of all procedures  */
      /* declared within this module.  */
      Lists_InitList (&pSym->Module.ListOfModules);  /* List of all inner modules.  */
      InitWhereDeclaredTok (tok, &pSym->Module.At);  /* Where symbol declared.  */
      InitWhereFirstUsedTok (tok, &pSym->Module.At);  /* Where symbol first used.  */
      if ((SymbolTable_GetCurrentScope ()) == (SymbolTable_GetBaseModule ()))  /* Where symbol first used.  */
        {
          pSym->Module.Scope = SymbolTable_NulSym;
        }
      else
        {
          pSym->Module.Scope = SymbolTable_GetCurrentScope ();
          AddModuleToParent (Sym, pSym->Module.Scope);
        }
      pSym->Module.errorScope = M2Error_GetCurrentErrorScope ();  /* Title error scope.  */
      AddSymToScope (Sym, ModuleName);  /* Title error scope.  */
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeProcedure - creates a procedure sym with name. It returns
                   the symbol index.
*/

extern "C" unsigned int SymbolTable_MakeProcedure (unsigned int tok, NameKey_Name ProcedureName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;
  SymbolTable_ProcedureKind kind;

  tok = CheckTok (tok, (const char *) "procedure", 9);
  Sym = DeclareSym (tok, ProcedureName);
  CheckBreak (Sym);
  if (! (SymbolTable_IsError (Sym)))
    {
      pSym = GetPsym (Sym);
      pSym->SymbolType = SymbolTable_ProcedureSym;
      pSym->Procedure.name = ProcedureName;
      for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
        {
          InitProcedureDeclaration (&pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure]);
          Lists_InitList (&pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ListOfParam);
        }
      pSym->Procedure.OptArgInit = SymbolTable_NulSym;  /* The optional arg default  */
      /* value.  */
      pSym->Procedure.IsExtern = false;  /* Make this procedure external.  */
      pSym->Procedure.IsPublic = false;  /* Make this procedure visible.  */
      pSym->Procedure.IsCtor = false;  /* Is this procedure a ctor?  */
      pSym->Procedure.IsMonoName = false;  /* Overrides module name prefix.  */
      pSym->Procedure.BuildProcType = true;  /* Are we building the  */
      /* proctype associated with sym?  */
      pSym->Procedure.Scope = SymbolTable_GetCurrentScope ();  /* Scope of procedure.  */
      SymbolKey_InitTree (&pSym->Procedure.Unresolved);  /* All symbols currently  */
      /* unresolved in this procedure.  */
      pSym->Procedure.ScopeQuad = 0;  /* Index into list of quads,  */
      pSym->Procedure.StartQuad = 0;  /* defining the scope, start and  */
      pSym->Procedure.EndQuad = 0;  /* end of the procedure.  */
      pSym->Procedure.Reachable = false;  /* Procedure not known to be  */
      /* reachable.  */
      pSym->Procedure.SavePriority = false;  /* Does procedure need to save  */
      /* and restore interrupts?  */
      pSym->Procedure.ReturnType = SymbolTable_NulSym;  /* Not a function yet!  */
      /* The ProcType equivalent.  */
      pSym->Procedure.ProcedureType = SymbolTable_MakeProcType (tok, NameKey_NulName);
      SymbolKey_InitTree (&pSym->Procedure.LocalSymbols);
      Lists_InitList (&pSym->Procedure.EnumerationScopeList);
      /* visable within this scope.  */
      SymbolKey_InitTree (&pSym->Procedure.NamedObjects);  /* Names of all items declared.  */
      Lists_InitList (&pSym->Procedure.ListOfVars);  /* List of variables in this  */
      /* scope.  */
      Lists_InitList (&pSym->Procedure.ListOfProcs);  /* List of all procedures  */
      /* procedure.  */
      Lists_InitList (&pSym->Procedure.ListOfModules);  /* List of all inner modules.  */
      pSym->Procedure.ExceptionFinally = false;  /* does it have an exception?  */
      pSym->Procedure.ExceptionBlock = false;  /* does it have an exception?  */
      pSym->Procedure.IsBuiltin = false;  /* Was it declared __BUILTIN__ ?  */
      pSym->Procedure.BuiltinName = NameKey_NulName;  /* name of equivalent builtin  */
      pSym->Procedure.IsInline = false;  /* Was is declared __INLINE__ ?  */
      pSym->Procedure.Size = M2ALU_InitValue ();  /* Activation record size.  */
      pSym->Procedure.TotalParamSize = M2ALU_InitValue ();  /* size of all parameters.  */
      pSym->Procedure.Begin = 0;  /* token number for BEGIN  */
      pSym->Procedure.End = 0;  /* token number for END  */
      InitWhereDeclaredTok (tok, &pSym->Procedure.At);  /* Where the symbol was declared.  */
      pSym->Procedure.errorScope = M2Error_GetCurrentErrorScope ();  /* Title error scope.  */
      /* Now add this procedure to the symbol table of the current scope  */
      AddSymToScope (Sym, ProcedureName);
      AddProcedureToList (SymbolTable_GetCurrentScope (), Sym);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeProcedureCtorExtern - creates an extern ctor procedure
*/

extern "C" unsigned int SymbolTable_MakeProcedureCtorExtern (unsigned int tokenno, NameKey_Name libname, NameKey_Name modulename)
{
  unsigned int ctor;

  ctor = SymbolTable_MakeProcedure (tokenno, GenName (libname, (const char *) "_M2_", 4, modulename, (const char *) "_ctor", 5));
  SymbolTable_PutExtern (ctor, true);
  return ctor;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutLibName - places libname into defimp or module sym.
*/

extern "C" void SymbolTable_PutLibName (unsigned int sym, NameKey_Name libname)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)));
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        pSym->DefImp.libname = libname;
        break;

      case SymbolTable_ModuleSym:
        pSym->Module.libname = libname;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
}


/*
   GetLibName - returns libname associated with a defimp or module sym.
*/

extern "C" NameKey_Name SymbolTable_GetLibName (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)));
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return pSym->DefImp.libname;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.libname;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutMonoName - changes the IsMonoName boolean inside the procedure.
*/

extern "C" void SymbolTable_PutMonoName (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.IsMonoName = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
}


/*
   IsMonoName - returns the public boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsMonoName (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.IsMonoName;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutExtern - changes the extern boolean inside the procedure.
*/

extern "C" void SymbolTable_PutExtern (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.IsExtern = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
}


/*
   IsExtern - returns the public boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsExtern (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.IsExtern;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutPublic - changes the public boolean inside the procedure.
*/

extern "C" void SymbolTable_PutPublic (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.IsPublic = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
}


/*
   IsPublic - returns the public boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsPublic (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.IsPublic;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutCtor - changes the ctor boolean inside the procedure.
*/

extern "C" void SymbolTable_PutCtor (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.IsCtor = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
}


/*
   IsCtor - returns the ctor boolean associated with a procedure.
*/

extern "C" bool SymbolTable_IsCtor (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.IsCtor;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetModuleCtors - mod can be a DefImp or Module symbol.  ctor, init and fini
                    are assigned for this module.  An inner module ctor value will
                    be NulSym.
*/

extern "C" void SymbolTable_GetModuleCtors (unsigned int mod, unsigned int *ctor, unsigned int *init, unsigned int *fini, unsigned int *dep)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (mod);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        (*ctor) = pSym->Module.ctors.ctor;
        (*init) = pSym->Module.ctors.init;
        (*fini) = pSym->Module.ctors.fini;
        (*dep) = pSym->Module.ctors.dep;
        break;

      case SymbolTable_DefImpSym:
        (*ctor) = pSym->DefImp.ctors.ctor;
        (*init) = pSym->DefImp.ctors.init;
        (*fini) = pSym->DefImp.ctors.fini;
        (*dep) = pSym->DefImp.ctors.dep;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Module or DefImp symbol", 33);
        break;
    }
}


/*
   MakeModuleCtor - for a defimp or module symbol create all the ctor
                    related procedures.
*/

extern "C" void SymbolTable_MakeModuleCtor (unsigned int moduleTok, unsigned int beginTok, unsigned int finallyTok, unsigned int moduleSym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert ((SymbolTable_IsDefImp (moduleSym)) || (SymbolTable_IsModule (moduleSym)));
  pSym = GetPsym (moduleSym);
  if (SymbolTable_IsDefImp (moduleSym))
    {
      InitCtorFields (moduleTok, beginTok, finallyTok, moduleSym, &pSym->DefImp.ctors, SymbolTable_GetSymName (moduleSym), false, true);
    }
  else
    {
      InitCtorFields (moduleTok, beginTok, finallyTok, moduleSym, &pSym->Module.ctors, SymbolTable_GetSymName (moduleSym), SymbolTable_IsInnerModule (moduleSym), true);
    }
}


/*
   PutModuleCtorExtern - for every ctor related procedure in module sym.
                         Make it external.  It will create any missing
                         init/fini procedures but not any missing dep/ctor
                         procedures.
*/

extern "C" void SymbolTable_PutModuleCtorExtern (unsigned int tok, unsigned int sym, bool external)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)));
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        PutCtorExtern (tok, sym, &pSym->DefImp.ctors, external);
        break;

      case SymbolTable_ModuleSym:
        PutCtorExtern (tok, sym, &pSym->Module.ctors, external);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
}


/*
   PutVarHeap - assigns ArrayRef field with value.
*/

extern "C" void SymbolTable_PutVarHeap (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.Heap = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym", 16);
        break;
    }
}


/*
   IsVarHeap - returns ArrayRef field value.
*/

extern "C" bool SymbolTable_IsVarHeap (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.Heap;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym", 16);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   MakeVar - creates a variable sym with VarName. It returns the
             symbol index.
*/

extern "C" unsigned int SymbolTable_MakeVar (unsigned int tok, NameKey_Name VarName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  Sym = DeclareSym (tok, VarName);
  if (! (SymbolTable_IsError (Sym)))
    {
      pSym = GetPsym (Sym);
      pSym->SymbolType = SymbolTable_VarSym;
      pSym->Var.name = VarName;
      pSym->Var.Type = SymbolTable_NulSym;
      pSym->Var.BackType = SymbolTable_NulSym;
      pSym->Var.Size = M2ALU_InitValue ();
      pSym->Var.Offset = M2ALU_InitValue ();
      pSym->Var.AddrMode = SymbolTable_RightValue;
      pSym->Var.Scope = SymbolTable_GetCurrentScope ();  /* Procedure or Module?  */
      pSym->Var.AtAddress = false;  /* Procedure or Module?  */
      pSym->Var.Address = SymbolTable_NulSym;  /* Address at which declared.  */
      pSym->Var.IsConditional = false;  /* Address at which declared.  */
      pSym->Var.IsTemp = false;
      pSym->Var.IsComponentRef = false;
      pSym->Var.IsParam = false;
      pSym->Var.IsPointerCheck = false;
      pSym->Var.IsWritten = false;
      pSym->Var.IsSSA = false;
      pSym->Var.IsConst = false;
      pSym->Var.ArrayRef = false;
      pSym->Var.Heap = false;
      InitVarDecl (&pSym->Var.Declared, tok);
      InitWhereDeclaredTok (tok, &pSym->Var.At);
      InitWhereFirstUsedTok (tok, &pSym->Var.At);  /* Where symbol first used.  */
      Lists_InitList (&pSym->Var.ReadUsageList.array[SymbolTable_RightValue-SymbolTable_RightValue]);  /* Where symbol first used.  */
      Lists_InitList (&pSym->Var.WriteUsageList.array[SymbolTable_RightValue-SymbolTable_RightValue]);
      Lists_InitList (&pSym->Var.ReadUsageList.array[SymbolTable_LeftValue-SymbolTable_RightValue]);
      Lists_InitList (&pSym->Var.WriteUsageList.array[SymbolTable_LeftValue-SymbolTable_RightValue]);
      pSym->Var.InitState.array[SymbolTable_LeftValue-SymbolTable_RightValue] = M2SymInit_InitSymInit ();
      pSym->Var.InitState.array[SymbolTable_RightValue-SymbolTable_RightValue] = M2SymInit_InitSymInit ();
      /* Add Var to Procedure or Module variable list.  */
      AddVarToList (Sym);
      /* Now add this Var to the symbol table of the current scope.  */
      AddSymToScope (Sym, VarName);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutVarConditional - assign IsConditional to value.
*/

extern "C" void SymbolTable_PutVarConditional (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.IsConditional = value;
        break;

      case SymbolTable_ConstVarSym:
        pSym->ConstVar.IsConditional = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Var", 13);
        break;
    }
}


/*
   IsVarConditional - return TRUE if the symbol is a var symbol
                      containing the result of a boolean conditional.
*/

extern "C" bool SymbolTable_IsVarConditional (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.IsConditional;
        break;

      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.IsConditional;
        break;


      default:
        return false;
        break;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeRecord - makes a Record symbol with name RecordName.
*/

extern "C" unsigned int SymbolTable_MakeRecord (unsigned int tok, NameKey_Name RecordName)
{
  unsigned int oaf;
  unsigned int sym;

  tok = CheckTok (tok, (const char *) "record", 6);
  sym = HandleHiddenOrDeclare (tok, RecordName, &oaf);
  FillInRecordFields (tok, sym, RecordName, SymbolTable_GetCurrentScope (), oaf);
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeVarient - creates a new symbol, a varient symbol for record or varient field
                 symbol, RecOrVarFieldSym.
*/

extern "C" unsigned int SymbolTable_MakeVarient (unsigned int tok, unsigned int RecOrVarFieldSym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  tok = CheckTok (tok, (const char *) "varient", 7);
  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_VarientSym;
  pSym->Varient.Size = M2ALU_InitValue ();
  pSym->Varient.Parent = RecOrVarFieldSym;  /* GetRecord(RecOrVarFieldSym) ;  */
  if (SymbolTable_IsRecord (RecOrVarFieldSym))  /* GetRecord(RecOrVarFieldSym) ;  */
    {
      pSym->Varient.Varient = SymbolTable_NulSym;
    }
  else
    {
      pSym->Varient.Varient = RecOrVarFieldSym;
    }
  pSym->Varient.tag = SymbolTable_NulSym;
  pSym->Varient.DeclPacked = false;
  pSym->Varient.Scope = SymbolTable_GetCurrentScope ();
  Lists_InitList (&pSym->Varient.ListOfSons);
  InitWhereDeclaredTok (tok, &pSym->Varient.At);
  /* Now add Sym to the record RecSym field list  */
  pSym = GetPsym (RecOrVarFieldSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        Lists_PutItemIntoList (pSym->Record.ListOfSons, Sym);
        break;

      case SymbolTable_VarientFieldSym:
        Lists_PutItemIntoList (pSym->VarientField.ListOfSons, Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Record or VarientField symbol", 39);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeFieldVarient - returns a FieldVarient symbol which has been
                      assigned to the Varient symbol, Sym.
*/

extern "C" unsigned int SymbolTable_MakeFieldVarient (NameKey_Name n, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int SonSym;

  NewSym (&SonSym);
  /* Fill in Sym  */
  pSym = GetPsym (SonSym);
  pSym->SymbolType = SymbolTable_VarientFieldSym;
  pSym->VarientField.name = n;
  Lists_InitList (&pSym->VarientField.ListOfSons);
  pSym->VarientField.Parent = SymbolTable_GetRecord (Sym);
  pSym->VarientField.Varient = SymbolTable_NulSym;
  pSym->VarientField.Size = M2ALU_InitValue ();
  pSym->VarientField.Offset = M2ALU_InitValue ();
  pSym->VarientField.DeclPacked = false;
  pSym->VarientField.DeclResolved = false;
  pSym->VarientField.Scope = SymbolTable_GetCurrentScope ();
  InitWhereDeclared (&pSym->VarientField.At);
  return SonSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeEnumeration - places a new symbol in the current scope, the symbol
                     is an enumeration symbol. The symbol index is returned.
*/

extern "C" unsigned int SymbolTable_MakeEnumeration (unsigned int tok, NameKey_Name EnumerationName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int sym;
  unsigned int oaf;

  tok = CheckTok (tok, (const char *) "enumeration", 11);
  sym = CheckForHiddenType (EnumerationName);
  if (sym == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      sym = DeclareSym (tok, EnumerationName);
      oaf = SymbolTable_GetOAFamily (sym);
      if (! (SymbolTable_IsError (sym)))
        {
          pSym = GetPsym (sym);
          pSym->SymbolType = SymbolTable_EnumerationSym;  /* To satisfy AddSymToScope  */
          /* Now add this type to the symbol table of the current scope  */
          AddSymToScope (sym, EnumerationName);
        }
    }
  else
    {
      oaf = SymbolTable_GetOAFamily (sym);
    }
  if (! (SymbolTable_IsError (sym)))
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_EnumerationSym;
      pSym->Enumeration.name = EnumerationName;  /* Name of enumeration.  */
      pSym->Enumeration.NoOfElements = 0;  /* No of elements in the  */
      /* enumeration type.  */
      pSym->Enumeration.Size = M2ALU_InitValue ();  /* Size at runtime of sym  */
      SymbolKey_InitTree (&pSym->Enumeration.LocalSymbols);  /* Enumeration fields.  */
      Lists_InitList (&pSym->Enumeration.ListOfFields);  /* Ordered as declared.  */
      InitPacked (&pSym->Enumeration.packedInfo);  /* not packed and no  */
      /* equivalent (yet).  */
      pSym->Enumeration.oafamily = oaf;  /* The open array family  */
      pSym->Enumeration.Scope = SymbolTable_GetCurrentScope ();  /* Which scope created it  */
      InitWhereDeclaredTok (tok, &pSym->Enumeration.At);  /* Declared here  */
      CheckIfEnumerationExported (sym, ScopePtr);
    }
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeType - makes a type symbol with name TypeName.
*/

extern "C" unsigned int SymbolTable_MakeType (unsigned int tok, NameKey_Name TypeName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int sym;
  unsigned int oaf;

  sym = HandleHiddenOrDeclare (tok, TypeName, &oaf);
  if (! (SymbolTable_IsError (sym)))
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_TypeSym;
      pSym->Type.name = TypeName;  /* Index into name array, name  */
      /* of type.  */
      pSym->Type.Type = SymbolTable_NulSym;  /* Index to a type symbol.  */
      pSym->Type.IsHidden = false;  /* Was it declared as hidden?  */
      SymbolKey_InitTree (&pSym->Type.ConstLitTree);  /* constants of this type.  */
      pSym->Type.Size = M2ALU_InitValue ();  /* Runtime size of symbol.  */
      pSym->Type.Align = SymbolTable_NulSym;  /* Alignment of this type.  */
      InitPacked (&pSym->Type.packedInfo);  /* not packed and no  */
      /* equivalent yet.  */
      pSym->Type.oafamily = oaf;  /* The open array family.  */
      pSym->Type.Scope = SymbolTable_GetCurrentScope ();  /* Which scope created it  */
      InitWhereDeclaredTok (tok, &pSym->Type.At);  /* Declared here  */
    }
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeHiddenType - makes a type symbol that is hidden from the
                    definition module.
                    This symbol is placed into the UnImplemented list of
                    the definition/implementation module.
                    The type will be filled in when the implementation module
                    is reached.
*/

extern "C" unsigned int SymbolTable_MakeHiddenType (unsigned int tok, NameKey_Name TypeName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  tok = CheckTok (tok, (const char *) "hidden", 6);
  Sym = DeclareSym (tok, TypeName);
  if (! (SymbolTable_IsError (Sym)))
    {
      pSym = GetPsym (Sym);
      pSym->SymbolType = SymbolTable_TypeSym;
      pSym->Type.name = TypeName;  /* Index into name array, name  */
      /* of type.  */
      pSym->Type.IsHidden = (SymbolTable_GetMainModule ()) != (SymbolTable_GetCurrentScope ());
      if (M2Options_ExtendedOpaque || ! pSym->Type.IsHidden)
        {
          pSym->Type.Type = SymbolTable_NulSym;  /* will be filled in later  */
        }
      else
        {
          pSym->Type.Type = M2System_Address;
        }
      pSym->Type.Align = SymbolTable_NulSym;  /* Alignment of this type.  */
      pSym->Type.Scope = SymbolTable_GetCurrentScope ();  /* Which scope created it  */
      pSym->Type.oafamily = SymbolTable_NulSym;  /* Which scope created it  */
      if (! M2Options_ExtendedOpaque)
        {
          Lists_IncludeItemIntoList (AddressTypes, Sym);
        }
      pSym->Type.Size = M2ALU_InitValue ();  /* Runtime size of symbol.  */
      InitWhereDeclaredTok (tok, &pSym->Type.At);  /* Declared here  */
      SymbolTable_PutExportUnImplemented (tok, Sym);
      if (M2Options_ExtendedOpaque || ((SymbolTable_GetMainModule ()) == (SymbolTable_GetCurrentScope ())))
        {
          SymbolTable_PutHiddenTypeDeclared ();
        }
      /* Now add this type to the symbol table of the current scope  */
      AddSymToScope (Sym, TypeName);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeConstant - create a constant cardinal and return the symbol.
*/

extern "C" unsigned int SymbolTable_MakeConstant (unsigned int tok, unsigned int value)
{
  DynamicStrings_String str;
  unsigned int sym;

  tok = CheckTok (tok, (const char *) "constant", 8);
  str = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "%d", 2)), (const unsigned char *) &value, (sizeof (value)-1));
  sym = SymbolTable_MakeConstLit (tok, NameKey_makekey (DynamicStrings_string (str)), M2Base_Cardinal);
  str = DynamicStrings_KillString (str);
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeConstLit - returns a constant literal of type, constType, with a constName,
                  at location, tok.
*/

extern "C" unsigned int SymbolTable_MakeConstLit (unsigned int tok, NameKey_Name constName, unsigned int constType)
{
  unsigned int sym;

  tok = CheckTok (tok, (const char *) "constlit", 8);
  sym = LookupConstLitPoolEntry (tok, constName, constType);
  if (sym == SymbolTable_NulSym)
    {
      sym = CreateConstLit (tok, constName, constType);
      AddConstLitPoolEntry (sym, tok, constName, constType);
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeConstVar - makes a ConstVar type with
                  name ConstVarName.
*/

extern "C" unsigned int SymbolTable_MakeConstVar (unsigned int tok, NameKey_Name ConstVarName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;
  bool temp;

  temp = ConstVarName == NameKey_NulName;
  ConstVarName = SymbolTable_CheckAnonymous (ConstVarName);
  Sym = DeclareSym (tok, ConstVarName);
  if (! (SymbolTable_IsError (Sym)))
    {
      pSym = GetPsym (Sym);
      pSym->SymbolType = SymbolTable_ConstVarSym;
      pSym->ConstVar.name = ConstVarName;
      pSym->ConstVar.Value = M2ALU_InitValue ();
      pSym->ConstVar.Type = SymbolTable_NulSym;
      pSym->ConstVar.IsSet = false;
      pSym->ConstVar.IsConditional = false;
      pSym->ConstVar.IsConstructor = false;
      pSym->ConstVar.FromType = SymbolTable_NulSym;  /* type is determined FromType  */
      pSym->ConstVar.UnresFromType = false;  /* is Type resolved?  */
      pSym->ConstVar.IsTemp = temp;  /* is Type resolved?  */
      pSym->ConstVar.Scope = SymbolTable_GetCurrentScope ();
      InitWhereDeclaredTok (tok, &pSym->ConstVar.At);
      /* Now add this constant to the symbol table of the current scope  */
      AddSymToScope (Sym, ConstVarName);
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeConstString - create a string constant in the symboltable.
*/

extern "C" unsigned int SymbolTable_MakeConstString (unsigned int tok, NameKey_Name ConstName)
{
  unsigned int newstr;

  NewSym (&newstr);
  InitConstString (tok, newstr, ConstName, ConstName, SymbolTable_m2nulstr, false, true);
  return newstr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeConstStringCnul - creates a constant string nul terminated string suitable for C.
                         If known is TRUE then name is assigned to the contents
                         and the escape sequences will be converted into characters.
*/

extern "C" unsigned int SymbolTable_MakeConstStringCnul (unsigned int tok, NameKey_Name name, bool known)
{
  unsigned int newstr;

  tok = CheckTok (tok, (const char *) "conststringcnul", 15);
  NewSym (&newstr);
  InitConstString (tok, newstr, name, name, SymbolTable_cnulstr, true, known);
  return newstr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeConstStringM2nul - creates a constant string nul terminated string suitable for M2.
                          If known is TRUE then name is assigned to the contents
                          however the escape sequences are not converted into characters.
*/

extern "C" unsigned int SymbolTable_MakeConstStringM2nul (unsigned int tok, NameKey_Name name, bool known)
{
  unsigned int newstr;

  NewSym (&newstr);
  InitConstString (tok, newstr, name, name, SymbolTable_m2nulstr, false, known);
  return newstr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutConstStringKnown - if sym is a constvar then convert it into a conststring.
                         If known is FALSE then contents is ignored and NulName is
                         stored.  If escape is TRUE then the contents will have
                         any escape sequences converted into single characters.
*/

extern "C" void SymbolTable_PutConstStringKnown (unsigned int tok, unsigned int sym, NameKey_Name contents, bool escape, bool known)
{
  SymbolTable_PtrToSymbol pSym;
  DynamicStrings_String s;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        if (known)
          {
            if (escape)
              {
                s = FormatStrings_HandleEscape (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (contents)));
                contents = NameKey_makekey (DynamicStrings_string (s));
                s = DynamicStrings_KillString (s);
              }
            pSym->ConstString.Length = NameKey_LengthKey (contents);
            pSym->ConstString.Contents = contents;
          }
        else
          {
            pSym->ConstString.Length = 0;
            pSym->ConstString.Contents = NameKey_NulName;
          }
        pSym->ConstString.Known = known;
        InitWhereDeclaredTok (tok, &pSym->ConstString.At);
        InitWhereFirstUsedTok (tok, &pSym->ConstString.At);
        break;

      case SymbolTable_ConstVarSym:
        InitConstString (tok, sym, pSym->ConstVar.name, contents, SymbolTable_m2str, escape, known);  /* Change a ConstVar to a ConstString copy name
                         and alter symboltype.  */
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstString symbol", 28);
        break;
    }
}


/*
   CopyConstString - copies string contents from expr to des
                     and retain the kind of string.
*/

extern "C" void SymbolTable_CopyConstString (unsigned int tok, unsigned int des, unsigned int expr)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsConstStringKnown (expr));
  pSym = GetPsym (des);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        InitConstString (tok, des, pSym->ConstString.name, SymbolTable_GetString (expr), GetConstStringKind (expr), false, true);
        break;

      case SymbolTable_ConstVarSym:
        InitConstString (tok, des, pSym->ConstVar.name, SymbolTable_GetString (expr), GetConstStringKind (expr), false, true);  /* Change a ConstVar to a ConstString copy name
                         and alter symboltype.  */
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstString symbol", 28);
        break;
    }
}


/*
   IsConstStringKnown - returns TRUE if sym is a const string
                        and the contents are known.
*/

extern "C" bool SymbolTable_IsConstStringKnown (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        return pSym->ConstString.Known;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstStringM2 - returns whether this conststring is a
                     Modula-2 string.
*/

extern "C" bool SymbolTable_IsConstStringM2 (unsigned int sym)
{
  return (GetConstStringKind (sym)) == SymbolTable_m2str;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstStringC - returns whether this conststring is a C style string
                    which will have any escape translated.
*/

extern "C" bool SymbolTable_IsConstStringC (unsigned int sym)
{
  return (GetConstStringKind (sym)) == SymbolTable_cstr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstStringM2nul - returns whether this conststring is a Modula-2 string which
                        contains a nul terminator.
*/

extern "C" bool SymbolTable_IsConstStringM2nul (unsigned int sym)
{
  return (GetConstStringKind (sym)) == SymbolTable_m2nulstr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstStringCnul - returns whether this conststring is a C style string
                       which will have any escape translated and also contains
                       a nul terminator.
*/

extern "C" bool SymbolTable_IsConstStringCnul (unsigned int sym)
{
  return (GetConstStringKind (sym)) == SymbolTable_cnulstr;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeSubrange - makes a new symbol into a subrange type with
                  name SubrangeName.
*/

extern "C" unsigned int SymbolTable_MakeSubrange (unsigned int tok, NameKey_Name SubrangeName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int sym;
  unsigned int oaf;

  tok = CheckTok (tok, (const char *) "subrange", 8);
  sym = HandleHiddenOrDeclare (tok, SubrangeName, &oaf);
  if (! (SymbolTable_IsError (sym)))
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_SubrangeSym;
      pSym->Subrange.name = SubrangeName;
      pSym->Subrange.Low = SymbolTable_NulSym;  /* Index to a symbol determining  */
      /* ConstExpression.  */
      pSym->Subrange.High = SymbolTable_NulSym;  /* Index to a symbol determining  */
      /* ConstExpression.  */
      pSym->Subrange.Type = SymbolTable_NulSym;  /* Index to a type. Determines  */
      /* the type of subrange.  */
      pSym->Subrange.Align = SymbolTable_NulSym;  /* The alignment of this type.  */
      InitPacked (&pSym->Subrange.packedInfo);  /* not packed and no equivalent  */
      SymbolKey_InitTree (&pSym->Subrange.ConstLitTree);  /* constants of this type.  */
      pSym->Subrange.Size = M2ALU_InitValue ();  /* Size determines the type size  */
      pSym->Subrange.oafamily = oaf;  /* The unbounded sym for this  */
      pSym->Subrange.Scope = SymbolTable_GetCurrentScope ();  /* Which scope created it  */
      InitWhereDeclaredTok (tok, &pSym->Subrange.At);  /* Declared here  */
    }
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeSet - makes a set Symbol with name, SetName.
*/

extern "C" unsigned int SymbolTable_MakeSet (unsigned int tok, NameKey_Name SetName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int oaf;
  unsigned int sym;

  tok = CheckTok (tok, (const char *) "set", 3);
  sym = HandleHiddenOrDeclare (tok, SetName, &oaf);
  if (! (SymbolTable_IsError (sym)))
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_SetSym;
      pSym->Set.name = SetName;  /* The name of the set.  */
      pSym->Set.Type = SymbolTable_NulSym;  /* Index to a subrange symbol.  */
      pSym->Set.Size = M2ALU_InitValue ();  /* Size of this set  */
      InitPacked (&pSym->Set.packedInfo);  /* not packed and no  */
      /* equivalent (yet).  */
      pSym->Set.ispacked = false;  /* Not yet known to be packed.  */
      pSym->Set.oafamily = oaf;  /* The unbounded sym for this  */
      pSym->Set.Scope = SymbolTable_GetCurrentScope ();  /* Which scope created it  */
      InitWhereDeclaredTok (tok, &pSym->Set.At);  /* Declared here  */
    }
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeArray - makes an Array symbol with name ArrayName.
*/

extern "C" unsigned int SymbolTable_MakeArray (unsigned int tok, NameKey_Name ArrayName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int sym;
  unsigned int oaf;

  sym = HandleHiddenOrDeclare (tok, ArrayName, &oaf);
  if (! (SymbolTable_IsError (sym)))
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_ArraySym;
      pSym->Array.name = ArrayName;
      pSym->Array.Subscript = SymbolTable_NulSym;  /* Contains the array subscripts.  */
      pSym->Array.Size = M2ALU_InitValue ();  /* Size of array.  */
      pSym->Array.Offset = M2ALU_InitValue ();  /* Offset of array.  */
      pSym->Array.Type = SymbolTable_NulSym;  /* The Array Type. ARRAY OF Type.  */
      pSym->Array.Large = false;  /* is this array large?  */
      pSym->Array.Align = SymbolTable_NulSym;  /* The alignment of this type.  */
      pSym->Array.oafamily = oaf;  /* The unbounded for this array  */
      pSym->Array.Scope = SymbolTable_GetCurrentScope ();  /* Which scope created it  */
      InitWhereDeclaredTok (tok, &pSym->Array.At);  /* Declared here  */
    }
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutArrayLarge - indicates that this is a large array in which case
                   the interface to gcc maps this array from 0..high-low,
                   using an integer indice.
*/

extern "C" void SymbolTable_PutArrayLarge (unsigned int array)
{
  SymbolTable_PtrToSymbol pSym;

  if (! (SymbolTable_IsError (array)))
    {
      M2Debug_Assert (SymbolTable_IsArray (array));
      pSym = GetPsym (array);
      pSym->Array.Large = true;
    }
}


/*
   IsArrayLarge - returns TRUE if we need to treat this as a large array.
*/

extern "C" bool SymbolTable_IsArrayLarge (unsigned int array)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsArray (array));
  pSym = GetPsym (array);
  return pSym->Array.Large;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutPriority - places a interrupt, priority, value into module, module.
*/

extern "C" void SymbolTable_PutPriority (unsigned int module, unsigned int priority)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (module != SymbolTable_NulSym);
  pSym = GetPsym (module);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        pSym->DefImp.Priority = priority;
        break;

      case SymbolTable_ModuleSym:
        pSym->Module.Priority = priority;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
}


/*
   GetPriority - returns the interrupt priority which was assigned to
                 module, module.
*/

extern "C" unsigned int SymbolTable_GetPriority (unsigned int module)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (module != SymbolTable_NulSym);
  pSym = GetPsym (module);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return pSym->DefImp.Priority;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.Priority;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutNeedSavePriority - set a boolean flag indicating that this procedure
                         needs to save and restore interrupts.
*/

extern "C" void SymbolTable_PutNeedSavePriority (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.SavePriority = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
}


/*
   GetNeedSavePriority - returns the boolean flag indicating whether this procedure
                         needs to save and restore interrupts.
*/

extern "C" bool SymbolTable_GetNeedSavePriority (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.SavePriority;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutVariableAtAddress - determines that a variable, sym, is declared at
                          a specific address.
*/

extern "C" void SymbolTable_PutVariableAtAddress (unsigned int sym, unsigned int address)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (sym != SymbolTable_NulSym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.AtAddress = true;
        pSym->Var.Address = address;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a variable symbol", 27);
        break;
    }
}


/*
   GetVariableAtAddress - returns the address at which variable, sym, is declared.
*/

extern "C" unsigned int SymbolTable_GetVariableAtAddress (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (sym != SymbolTable_NulSym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.Address;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a variable symbol", 27);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsVariableAtAddress - returns TRUE if a variable, sym, was declared at
                         a specific address.
*/

extern "C" bool SymbolTable_IsVariableAtAddress (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (sym != SymbolTable_NulSym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.AtAddress;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a variable symbol", 27);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutVariableSSA - assigns value to the SSA field within variable sym.
*/

extern "C" void SymbolTable_PutVariableSSA (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (sym != SymbolTable_NulSym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.IsSSA = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a variable symbol", 27);
        break;
    }
}


/*
   IsVariableSSA - returns TRUE if variable is known to be a SSA.
*/

extern "C" bool SymbolTable_IsVariableSSA (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (sym != SymbolTable_NulSym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.IsSSA;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a variable symbol", 27);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutVarConst - sets the IsConst field to value indicating the variable is read only.
*/

extern "C" void SymbolTable_PutVarConst (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      pSym->Var.IsConst = value;
    }
}


/*
   MakeGnuAsm - create a GnuAsm symbol.
*/

extern "C" unsigned int SymbolTable_MakeGnuAsm (void)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_GnuAsmSym;
  pSym->GnuAsm.String = SymbolTable_NulSym;
  InitWhereDeclared (&pSym->GnuAsm.At);
  pSym->GnuAsm.Inputs = SymbolTable_NulSym;
  pSym->GnuAsm.Outputs = SymbolTable_NulSym;
  pSym->GnuAsm.Trashed = SymbolTable_NulSym;
  pSym->GnuAsm.Volatile = false;
  pSym->GnuAsm.Simple = false;
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutGnuAsm - places the instruction textual name into the GnuAsm symbol.
*/

extern "C" void SymbolTable_PutGnuAsm (unsigned int sym, unsigned int string)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsConstString (string));
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        pSym->GnuAsm.String = string;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PutGnuAsm symbol", 26);
        break;
    }
}


/*
   PutGnuAsmOutput - places the interface object, out, into GnuAsm symbol, sym.
*/

extern "C" void SymbolTable_PutGnuAsmOutput (unsigned int sym, unsigned int out)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        pSym->GnuAsm.Outputs = out;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PutGnuAsm symbol", 26);
        break;
    }
}


/*
   PutGnuAsmInput - places the interface object, in, into GnuAsm symbol, sym.
*/

extern "C" void SymbolTable_PutGnuAsmInput (unsigned int sym, unsigned int in)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        pSym->GnuAsm.Inputs = in;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PutGnuAsm symbol", 26);
        break;
    }
}


/*
   PutGnuAsmTrash - places the interface object, trash, into GnuAsm symbol, sym.
*/

extern "C" void SymbolTable_PutGnuAsmTrash (unsigned int sym, unsigned int trash)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        pSym->GnuAsm.Trashed = trash;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PutGnuAsm symbol", 26);
        break;
    }
}


/*
   GetGnuAsm - returns the string symbol, representing the instruction textual
               of the GnuAsm symbol. It will return a ConstString.
*/

extern "C" unsigned int SymbolTable_GetGnuAsm (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        return pSym->GnuAsm.String;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting GnuAsm symbol", 23);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetGnuAsmInput - returns the input list of registers.
*/

extern "C" unsigned int SymbolTable_GetGnuAsmInput (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        return pSym->GnuAsm.Inputs;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PutGnuAsm symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetGnuAsmOutput - returns the output list of registers.
*/

extern "C" unsigned int SymbolTable_GetGnuAsmOutput (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        return pSym->GnuAsm.Outputs;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PutGnuAsm symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetGnuAsmTrash - returns the list of trashed registers.
*/

extern "C" unsigned int SymbolTable_GetGnuAsmTrash (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        return pSym->GnuAsm.Trashed;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PutGnuAsm symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutGnuAsmVolatile - defines a GnuAsm symbol as VOLATILE.
*/

extern "C" void SymbolTable_PutGnuAsmVolatile (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        pSym->GnuAsm.Volatile = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting GnuAsm symbol", 23);
        break;
    }
}


/*
   PutGnuAsmSimple - defines a GnuAsm symbol as a simple kind.
*/

extern "C" void SymbolTable_PutGnuAsmSimple (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        pSym->GnuAsm.Simple = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting GnuAsm symbol", 23);
        break;
    }
}


/*
   MakeRegInterface - creates and returns a register interface symbol.
*/

extern "C" unsigned int SymbolTable_MakeRegInterface (void)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_InterfaceSym;
  pSym->Interface.Parameters = Indexing_InitIndex (1);
  InitWhereDeclared (&pSym->Interface.At);
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutRegInterface - places a, name, string, and, object, into the interface array,
                     sym, at position, i.
                     The string symbol will either be a register name or a constraint.
                     The object is an optional Modula-2 variable or constant symbol.
                     read and write are the quadruple numbers representing any read
                     or write operation.
*/

extern "C" void SymbolTable_PutRegInterface (unsigned int tok, unsigned int sym, unsigned int i, NameKey_Name n, unsigned int string, unsigned int object, unsigned int read_, unsigned int write_)
{
  SymbolTable_PtrToSymbol pSym;
  SymbolTable_PtrToAsmConstraint p;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_InterfaceSym:
        if (Indexing_InBounds (pSym->Interface.Parameters, i))
          {
            p = static_cast<SymbolTable_PtrToAsmConstraint> (Indexing_GetIndice (pSym->Interface.Parameters, i));
          }
        else if (i == ((Indexing_HighIndice (pSym->Interface.Parameters))+1))
          {
            /* avoid dangling else.  */
            Storage_ALLOCATE ((void **) &p, sizeof (SymbolTable__T5));
            Indexing_PutIndice (pSym->Interface.Parameters, i, reinterpret_cast <void *> (p));
          }
        else
          {
            /* avoid dangling else.  */
            M2Error_InternalError ((const char *) "expecting to add parameters sequentially", 40);
          }
        p->tokpos = tok;
        p->name = n;
        p->str = string;
        p->obj = object;
        PutFirstUsed (object, tok, read_, write_);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Interface symbol", 26);
        break;
    }
}


/*
   GetRegInterface - gets a, name, string, and, object, from the interface array,
                     sym, from position, i.
*/

extern "C" void SymbolTable_GetRegInterface (unsigned int sym, unsigned int i, unsigned int *tok, NameKey_Name *n, unsigned int *string, unsigned int *object)
{
  SymbolTable_PtrToSymbol pSym;
  SymbolTable_PtrToAsmConstraint p;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_InterfaceSym:
        if (Indexing_InBounds (pSym->Interface.Parameters, i))
          {
            p = static_cast<SymbolTable_PtrToAsmConstraint> (Indexing_GetIndice (pSym->Interface.Parameters, i));
            (*tok) = p->tokpos;
            (*n) = p->name;
            (*string) = p->str;
            (*object) = p->obj;
          }
        else
          {
            (*tok) = M2LexBuf_UnknownTokenNo;
            (*n) = NameKey_NulName;
            (*string) = SymbolTable_NulSym;
            (*object) = SymbolTable_NulSym;
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Interface symbol", 26);
        break;
    }
}


/*
   GetModule - Returns the Module symbol for the module with name, name.
*/

extern "C" unsigned int SymbolTable_GetModule (NameKey_Name name)
{
  return static_cast<unsigned int> (SymbolKey_GetSymKey (ModuleTree, name));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetCurrentModule - returns the current module Sym that is being
                      compiled.
*/

extern "C" unsigned int SymbolTable_GetCurrentModule (void)
{
  return CurrentModule;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFileModule - returns the FileModule symbol that was requested by
                   the user to be compiled.
*/

extern "C" unsigned int SymbolTable_GetFileModule (void)
{
  return FileModule;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetBaseModule - returns the base module symbol that contains Modula-2
                   base types, procedures and functions.
*/

extern "C" unsigned int SymbolTable_GetBaseModule (void)
{
  return BaseModule;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetMainModule - returns the main module symbol that was requested by
                   the user to be compiled.
*/

extern "C" unsigned int SymbolTable_GetMainModule (void)
{
  return MainModule;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetCurrentModuleScope - returns the module symbol which forms the
                           current (possibly inner most) module.
*/

extern "C" unsigned int SymbolTable_GetCurrentModuleScope (void)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int i;

  i = ScopePtr;
  pCall = GetPcall (i);
  while ((! (SymbolTable_IsModule (pCall->Search))) && (! (SymbolTable_IsDefImp (pCall->Search))))
    {
      M2Debug_Assert (i > 0);
      i -= 1;
      pCall = GetPcall (i);
    }
  return pCall->Search;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLastModuleScope - returns the last module scope encountered,
                        the module scope before the Current Module Scope.
*/

extern "C" unsigned int SymbolTable_GetLastModuleScope (void)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int i;

  i = ScopePtr;
  pCall = GetPcall (i);
  while ((! (SymbolTable_IsModule (pCall->Search))) && (! (SymbolTable_IsDefImp (pCall->Search))))
    {
      M2Debug_Assert (i > 0);
      i -= 1;
      pCall = GetPcall (i);
    }
  /* Found module at position, i.  */
  i -= 1;  /* Move to an outer level module scope  */
  pCall = GetPcall (i);  /* Move to an outer level module scope  */
  while ((! (SymbolTable_IsModule (pCall->Search))) && (! (SymbolTable_IsDefImp (pCall->Search))))
    {
      M2Debug_Assert (i > 0);
      i -= 1;
      pCall = GetPcall (i);
    }
  /* Found module at position, i.  */
  return pCall->Search;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddSymToModuleScope - adds a symbol, Sym, to the scope of the module
                         ModSym.
*/

extern "C" void SymbolTable_AddSymToModuleScope (unsigned int ModSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if ((SymbolKey_GetSymKey (pSym->DefImp.LocalSymbols, SymbolTable_GetSymName (Sym))) == SymbolKey_NulKey)
          {
            SymbolKey_PutSymKey (pSym->DefImp.LocalSymbols, SymbolTable_GetSymName (Sym), Sym);
          }
        else
          {
            M2MetaError_MetaError1 ((const char *) "{%kIMPORT} name clash with symbol {%1Ead} symbol already declared ", 66, Sym);
          }
        break;

      case SymbolTable_ModuleSym:
        if ((SymbolKey_GetSymKey (pSym->Module.LocalSymbols, SymbolTable_GetSymName (Sym))) == SymbolKey_NulKey)
          {
            SymbolKey_PutSymKey (pSym->Module.LocalSymbols, SymbolTable_GetSymName (Sym), Sym);
          }
        else
          {
            M2MetaError_MetaError1 ((const char *) "{%kIMPORT} name clash with symbol {%1Ead} symbol already declared ", 66, Sym);
          }
        break;

      case SymbolTable_ProcedureSym:
        if ((SymbolKey_GetSymKey (pSym->Procedure.LocalSymbols, SymbolTable_GetSymName (Sym))) == SymbolKey_NulKey)
          {
            SymbolKey_PutSymKey (pSym->Procedure.LocalSymbols, SymbolTable_GetSymName (Sym), Sym);
          }
        else
          {
            M2MetaError_MetaError1 ((const char *) "{%kIMPORT} name clash with symbol {%1Ead} symbol already declared ", 66, Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Module or DefImp symbol", 33);
        break;
    }
}


/*
   GetType - Returns the symbol that is the TYPE symbol to Sym.
             If zero is returned then we assume type unknown.
*/

extern "C" unsigned int SymbolTable_GetType (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int type;

  M2Debug_Assert (Sym != SymbolTable_NulSym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_OAFamilySym:
        type = pSym->OAFamily.SimpleType;
        break;

      case SymbolTable_VarSym:
        type = GetTypeOfVar (Sym);
        break;

      case SymbolTable_ConstLitSym:
        type = pSym->ConstLit.Type;
        break;

      case SymbolTable_ConstVarSym:
        type = pSym->ConstVar.Type;
        break;

      case SymbolTable_ConstStringSym:
        if (pSym->ConstString.Length == 1)
          {
            type = M2Base_Char;
          }
        else
          {
            type = SymbolTable_NulSym;  /* No type for a string  */
          }
        break;

      case SymbolTable_TypeSym:
        type = pSym->Type.Type;
        break;

      case SymbolTable_RecordFieldSym:
        type = pSym->RecordField.Type;
        break;

      case SymbolTable_RecordSym:
        type = SymbolTable_NulSym;  /* No type for a record  */
        break;

      case SymbolTable_VarientSym:
        type = SymbolTable_NulSym;  /* No type for a record  */
        break;

      case SymbolTable_EnumerationFieldSym:
        type = pSym->EnumerationField.Type;  /* No type for a record  */
        break;

      case SymbolTable_EnumerationSym:
        type = SymbolTable_NulSym;  /* No type for enumeration  */
        break;

      case SymbolTable_PointerSym:
        type = pSym->Pointer.Type;  /* No type for enumeration  */
        break;

      case SymbolTable_ProcedureSym:
        type = pSym->Procedure.ReturnType;
        break;

      case SymbolTable_ProcTypeSym:
        type = pSym->ProcType.ReturnType;
        break;

      case SymbolTable_ParamSym:
        type = pSym->Param.Type;
        break;

      case SymbolTable_VarParamSym:
        type = pSym->VarParam.Type;
        break;

      case SymbolTable_SubrangeSym:
        type = pSym->Subrange.Type;
        break;

      case SymbolTable_ArraySym:
        type = pSym->Array.Type;
        break;

      case SymbolTable_SubscriptSym:
        type = pSym->Subscript.Type;
        break;

      case SymbolTable_SetSym:
        type = pSym->Set.Type;
        break;

      case SymbolTable_UnboundedSym:
        type = pSym->Unbounded.Type;
        break;

      case SymbolTable_UndefinedSym:
        type = SymbolTable_NulSym;
        break;

      case SymbolTable_PartialUnboundedSym:
        type = pSym->PartialUnbounded.Type;
        break;

      case SymbolTable_ObjectSym:
        type = SymbolTable_NulSym;
        break;


      default:
        M2Error_InternalError ((const char *) "not implemented yet", 19);
        break;
    }
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SkipType - if sym is a TYPE foo = bar
              then call SkipType(bar)
              else return sym

              it does not skip over hidden types.
*/

extern "C" unsigned int SymbolTable_SkipType (unsigned int Sym)
{
  if ((((Sym != SymbolTable_NulSym) && (SymbolTable_IsType (Sym))) && (! (SymbolTable_IsHiddenType (Sym)))) && ((SymbolTable_GetType (Sym)) != SymbolTable_NulSym))
    {
      return SymbolTable_SkipType (SymbolTable_GetType (Sym));
    }
  else
    {
      return Sym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SkipTypeAndSubrange - if sym is a TYPE foo = bar OR
                            sym is declared as a subrange of bar
                         then call SkipTypeAndSubrange(bar)
                         else return sym

                         it does not skip over hidden types.
*/

extern "C" unsigned int SymbolTable_SkipTypeAndSubrange (unsigned int Sym)
{
  if ((((Sym != SymbolTable_NulSym) && ((SymbolTable_IsType (Sym)) || (SymbolTable_IsSubrange (Sym)))) && (! (SymbolTable_IsHiddenType (Sym)))) && ((SymbolTable_GetType (Sym)) != SymbolTable_NulSym))
    {
      return SymbolTable_SkipTypeAndSubrange (SymbolTable_GetType (Sym));
    }
  else
    {
      return Sym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLowestType - Returns the lowest type in the type chain of
                   symbol Sym.
                   If NulSym is returned then we assume type unknown or
                   you have reqested the type of a base type.
*/

extern "C" unsigned int SymbolTable_GetLowestType (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int type;

  M2Debug_Assert (Sym != SymbolTable_NulSym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        type = pSym->Var.Type;
        break;

      case SymbolTable_ConstLitSym:
        type = pSym->ConstLit.Type;
        break;

      case SymbolTable_ConstVarSym:
        type = pSym->ConstVar.Type;
        break;

      case SymbolTable_ConstStringSym:
        type = SymbolTable_NulSym;  /* No type for a string  */
        break;

      case SymbolTable_TypeSym:
        type = pSym->Type.Type;  /* No type for a string  */
        break;

      case SymbolTable_RecordFieldSym:
        type = pSym->RecordField.Type;
        break;

      case SymbolTable_RecordSym:
        type = SymbolTable_NulSym;  /* No type for a record  */
        break;

      case SymbolTable_EnumerationFieldSym:
        type = pSym->EnumerationField.Type;  /* No type for a record  */
        break;

      case SymbolTable_EnumerationSym:
        type = SymbolTable_NulSym;  /* No type for enumeration  */
        break;

      case SymbolTable_PointerSym:
        type = Sym;  /* we don't go to Pointer.Type  */
        break;

      case SymbolTable_ProcedureSym:
        type = pSym->Procedure.ReturnType;  /* we don't go to Pointer.Type  */
        break;

      case SymbolTable_ProcTypeSym:
        type = pSym->ProcType.ReturnType;
        break;

      case SymbolTable_ParamSym:
        type = pSym->Param.Type;
        break;

      case SymbolTable_VarParamSym:
        type = pSym->VarParam.Type;
        break;

      case SymbolTable_SubrangeSym:
        type = pSym->Subrange.Type;
        break;

      case SymbolTable_ArraySym:
        type = pSym->Array.Type;
        break;

      case SymbolTable_SubscriptSym:
        type = pSym->Subscript.Type;
        break;

      case SymbolTable_SetSym:
        type = Sym;  /* Stop at the set type.  */
        break;

      case SymbolTable_UnboundedSym:
        type = pSym->Unbounded.Type;  /* Stop at the set type.  */
        break;

      case SymbolTable_UndefinedSym:
        type = SymbolTable_NulSym;
        break;

      case SymbolTable_DummySym:
        type = SymbolTable_NulSym;
        break;


      default:
        M2Error_InternalError ((const char *) "not implemented yet", 19);
        break;
    }
  pSym = GetPsym (Sym);
  if ((pSym->SymbolType == SymbolTable_TypeSym) && (type == SymbolTable_NulSym))
    {
      type = Sym;  /* Base Type  */
    }
  else if (((type != SymbolTable_NulSym) && (SymbolTable_IsType (type))) && ((SymbolTable_GetAlignment (type)) == SymbolTable_NulSym))
    {
      /* avoid dangling else.  */
      type = SymbolTable_GetLowestType (type);  /* Type def  */
    }
  return type;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLType - get lowest type.  It returns the lowest type
              of symbol, sym.  It skips over type equivalences.
              It will not skip over base types.
*/

extern "C" unsigned int SymbolTable_GetLType (unsigned int sym)
{
  /* 
   Assert (doGetType (sym, TRUE, TRUE, TRUE, FALSE) = GetLowestType (sym)) ;
  */
  return doGetType (sym, true, true, true, false);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetSType - get source type.  It returns the type closest
              to the object.  It does not skip over type
              equivalences.  It will skip over base types.
*/

extern "C" unsigned int SymbolTable_GetSType (unsigned int sym)
{
  M2Debug_Assert ((doGetType (sym, false, false, false, true)) == (SymbolTable_GetType (sym)));
  return doGetType (sym, false, false, false, true);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDType - get gcc declared type.  It returns the type
              of the object which is declared to GCC.
              It does skip over type equivalences but only
              if they do not contain a user alignment.
              It does not skip over hidden types.
              It does not skip over base types.
*/

extern "C" unsigned int SymbolTable_GetDType (unsigned int sym)
{
  /* 
   Assert (doGetType (sym, TRUE, FALSE, FALSE, FALSE) = SkipType(GetType(sym))) ;
  */
  return doGetType (sym, true, false, false, false);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetTypeMode - return the type of sym, it returns Address is the
                 symbol is a LValue.
*/

extern "C" unsigned int SymbolTable_GetTypeMode (unsigned int sym)
{
  if ((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue)
    {
      return M2System_Address;
    }
  else
    {
      return SymbolTable_GetType (sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetSym - searches the current scope (and previous scopes if the
            scope tranparent allows) for a symbol with name.
*/

extern "C" unsigned int SymbolTable_GetSym (NameKey_Name name)
{
  unsigned int Sym;
  unsigned int OldScopePtr;

  Sym = GetScopeSym (name, true);
  if (Sym == SymbolTable_NulSym)
    {
      /* Check default base types for symbol  */
      OldScopePtr = ScopePtr;  /* Save ScopePtr  */
      ScopePtr = BaseScopePtr;  /* Alter ScopePtr to point to top of BaseModule  */
      Sym = GetScopeSym (name, false);  /* Search BaseModule for name  */
      ScopePtr = OldScopePtr;  /* Restored ScopePtr  */
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDeclareSym - searches for a symbol with a name SymName in the
                   current and previous scopes.
                   If the symbol is found then it is returned
                   else an unknown symbol is returned.
                   This procedure assumes that SymName is being
                   declared at this point and therefore it does
                   not examine the base scope (for pervasive
                   identifiers).
*/

extern "C" unsigned int SymbolTable_GetDeclareSym (unsigned int tok, NameKey_Name SymName)
{
  unsigned int Sym;

  Sym = GetScopeSym (SymName, false);  /* must not be allowed to fetch a symbol through a procedure scope  */
  if (Sym == SymbolTable_NulSym)  /* must not be allowed to fetch a symbol through a procedure scope  */
    {
      Sym = GetSymFromUnknownTree (SymName);
      if (Sym == SymbolTable_NulSym)
        {
          /* Make unknown  */
          NewSym (&Sym);
          FillInUnknownFields (tok, Sym, SymName);
          /* 
           ; WriteKey(SymName) ; WriteString(' unknown demanded') ; WriteLn
  */
          AddSymToUnknownTree (static_cast<int> (ScopePtr), SymName, Sym);
        }
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLocalSym - only searches the scope Sym for a symbol with name
                 and returns the index to the symbol.
*/

extern "C" unsigned int SymbolTable_GetLocalSym (unsigned int Sym, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int LocalSym;

  /* 
   WriteString('Attempting to retrieve symbol from ') ; WriteKey(GetSymName(Sym)) ;
   WriteString(' local symbol table') ; WriteLn ;
  */
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_EnumerationSym:
        LocalSym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Enumeration.LocalSymbols, name));
        break;

      case SymbolTable_RecordSym:
        LocalSym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Record.LocalSymbols, name));
        break;

      case SymbolTable_ProcedureSym:
        LocalSym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Procedure.LocalSymbols, name));
        break;

      case SymbolTable_ModuleSym:
        LocalSym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Module.LocalSymbols, name));
        break;

      case SymbolTable_DefImpSym:
        LocalSym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.LocalSymbols, name));
        break;


      default:
        M2Error_InternalError ((const char *) "symbol does not have a LocalSymbols field", 41);
        break;
    }
  return LocalSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetRecord - fetches the record symbol from the parent of Sym.
               Sym maybe a varient symbol in which case its parent is searched
               etc.
*/

extern "C" unsigned int SymbolTable_GetRecord (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        return Sym;
        break;

      case SymbolTable_VarientSym:
        return SymbolTable_GetRecord (pSym->Varient.Parent);
        break;

      case SymbolTable_VarientFieldSym:
        return SymbolTable_GetRecord (pSym->VarientField.Parent);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Record or Varient symbol", 34);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   FromModuleGetSym - attempts to find a symbol of name, n, in the
                      module, mod, scope.  An unknown symbol is created
                      at token position tok if necessary.
*/

extern "C" unsigned int SymbolTable_FromModuleGetSym (unsigned int tok, NameKey_Name n, unsigned int mod)
{
  NameKey_Name n1;
  unsigned int sym;
  unsigned int OldScopePtr;

  OldScopePtr = ScopePtr;
  SymbolTable_StartScope (mod);
  sym = SymbolTable_RequestSym (tok, n);
  SymbolTable_EndScope ();
  if (sym == SymbolTable_NulSym)
    {
      /* --fixme-- can sym ever be NulSym?  */
      n1 = SymbolTable_GetSymName (mod);
      M2Error_WriteFormat2 ((const char *) "cannot find procedure %a in module, %a", 38, (const unsigned char *) &n, (sizeof (n)-1), (const unsigned char *) &n1, (sizeof (n1)-1));
    }
  ScopePtr = OldScopePtr;
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetNth - returns the n th symbol in the list associated with the scope
            of Sym.  Sym may be a Module, DefImp, Procedure, Record or
            Enumeration symbol.
*/

extern "C" unsigned int SymbolTable_GetNth (unsigned int Sym, unsigned int n)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int i;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Record.ListOfSons, n));
        break;

      case SymbolTable_VarientSym:
        i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Varient.ListOfSons, n));
        break;

      case SymbolTable_VarientFieldSym:
        i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->VarientField.ListOfSons, n));
        break;

      case SymbolTable_ProcedureSym:
        i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Procedure.ListOfVars, n));
        break;

      case SymbolTable_DefImpSym:
        i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->DefImp.ListOfVars, n));
        break;

      case SymbolTable_ModuleSym:
        i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Module.ListOfVars, n));
        break;

      case SymbolTable_TupleSym:
        i = GetFromIndex (pSym->Tuple.list, n);
        break;

      case SymbolTable_VarSym:
        i = GetNthFromComponent (Sym, n);
        break;

      case SymbolTable_EnumerationSym:
        i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Enumeration.ListOfFields, n));
        break;


      default:
        M2Error_InternalError ((const char *) "cannot GetNth from this symbol", 30);
        break;
    }
  return i;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetNthParam - returns the n th parameter of a procedure Sym.
*/

extern "C" unsigned int SymbolTable_GetNthParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int i;

  if (ParamNo == 0)
    {
      /* The return type of the function  */
      i = SymbolTable_GetType (Sym);
    }
  else
    {
      pSym = GetPsym (Sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ProcedureSym:
            i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ListOfParam, ParamNo));
            break;

          case SymbolTable_ProcTypeSym:
            i = static_cast<unsigned int> (Lists_GetItemFromList (pSym->ProcType.ListOfParam, ParamNo));
            break;


          default:
            M2Error_InternalError ((const char *) "expecting ProcedureSym or ProcTypeSym", 37);
            break;
        }
    }
  return i;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetVarScope - returns the symbol which is the scope of variable Sym.
                 ie a Module, DefImp or Procedure Symbol.
*/

extern "C" unsigned int SymbolTable_GetVarScope (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return SymbolTable_NulSym;
        break;

      case SymbolTable_VarSym:
        return pSym->Var.Scope;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetSubrange - returns HighSym and LowSym - two constants which make up the
                 subrange.
*/

extern "C" void SymbolTable_GetSubrange (unsigned int Sym, unsigned int *HighSym, unsigned int *LowSym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_SubrangeSym:
        (*HighSym) = pSym->Subrange.High;
        (*LowSym) = pSym->Subrange.Low;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Subrange symbol", 25);
        break;
    }
}


/*
   GetParam - returns the ParamNo parameter from procedure ProcSym
*/

extern "C" unsigned int SymbolTable_GetParam (unsigned int Sym, unsigned int ParamNo)
{
  AssertInRange (Sym);
  if (ParamNo == 0)
    {
      /* Parameter Zero is the return argument for the Function  */
      return SymbolTable_GetType (Sym);
    }
  else
    {
      return SymbolTable_GetNthParamAny (Sym, ParamNo);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetString - returns the contents of the string symbol sym, note that
               this is not the same as GetName (unless it was a literal).
*/

extern "C" NameKey_Name SymbolTable_GetString (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        if (pSym->ConstString.Known)
          {
            return pSym->ConstString.Contents;
          }
        else
          {
            M2Error_InternalError ((const char *) "const string contents are unknown", 33);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstString symbol", 28);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetStringLength - returns the length of the string symbol Sym.
*/

extern "C" unsigned int SymbolTable_GetStringLength (unsigned int tok, unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        if (pSym->ConstString.Known)
          {
            return pSym->ConstString.Length;
          }
        else
          {
            M2MetaError_MetaErrorT0 (tok, (const char *) "const string contents are unknown", 33);
            return 0;
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstString symbol", 28);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetProcedureBuiltin - returns the builtin name for the equivalent procedure, Sym.
*/

extern "C" NameKey_Name SymbolTable_GetProcedureBuiltin (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.BuiltinName;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureBuiltin - assigns the builtin name for the equivalent procedure, Sym.
*/

extern "C" void SymbolTable_PutProcedureBuiltin (unsigned int Sym, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.BuiltinName = name;
        pSym->Procedure.IsBuiltin = true;
        /* we use the same extra pass method as hidden types for builtins  */
        SymbolTable_PutHiddenTypeDeclared ();
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
}


/*
   IsProcedureBuiltin - returns TRUE if this procedure has a builtin equivalent.
*/

extern "C" bool SymbolTable_IsProcedureBuiltin (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.IsBuiltin;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureInline - determines that procedure, Sym, has been requested to be inlined.
*/

extern "C" void SymbolTable_PutProcedureInline (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.IsInline = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
}

extern "C" bool SymbolTable_IsProcedureInline (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  /* 
   IsProcedureBuiltin - returns TRUE if this procedure was declared as inlined.
  */
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.IsInline;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutExceptionBlock - sets a BOOLEAN in block module/procedure/defimp,
                       sym, indicating that this block as an EXCEPT
                       statement sequence.
*/

extern "C" void SymbolTable_PutExceptionBlock (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.ExceptionBlock = true;
        break;

      case SymbolTable_ModuleSym:
        pSym->Module.ExceptionBlock = true;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.ExceptionBlock = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Procedure", 19);
        break;
    }
}


/*
   HasExceptionBlock - returns a BOOLEAN determining whether
                       module/procedure/defimp, sym, has
                       an EXCEPT statement sequence.
*/

extern "C" bool SymbolTable_HasExceptionBlock (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.ExceptionBlock;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.ExceptionBlock;
        break;

      case SymbolTable_DefImpSym:
        return pSym->DefImp.ExceptionBlock;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Procedure", 19);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutExceptionFinally - sets a BOOLEAN in block module/defimp,
                         sym, indicating that this FINALLY block
                         as an EXCEPT statement sequence.
*/

extern "C" void SymbolTable_PutExceptionFinally (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.ExceptionFinally = true;
        break;

      case SymbolTable_ModuleSym:
        pSym->Module.ExceptionFinally = true;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.ExceptionFinally = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
}


/*
   HasExceptionFinally - returns a BOOLEAN determining whether
                         module/defimp, sym, has
                         an EXCEPT statement sequence.
*/

extern "C" bool SymbolTable_HasExceptionFinally (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.ExceptionFinally;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.ExceptionFinally;
        break;

      case SymbolTable_DefImpSym:
        return pSym->DefImp.ExceptionFinally;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutVar - gives the VarSym symbol Sym a type Type.
*/

extern "C" void SymbolTable_PutVar (unsigned int Sym, unsigned int VarType)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.Type = VarType;
        M2SymInit_ConfigSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_LeftValue-SymbolTable_RightValue]), Sym);
        M2SymInit_ConfigSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_RightValue-SymbolTable_RightValue]), Sym);
        break;

      case SymbolTable_ConstVarSym:
        pSym->ConstVar.Type = VarType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym or ConstVarSym", 31);
        break;
    }
}


/*
   PutVarTok - gives the VarSym symbol Sym a type Type at typetok.
*/

extern "C" void SymbolTable_PutVarTok (unsigned int Sym, unsigned int VarType, unsigned int typetok)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.Type = VarType;
        pSym->Var.Declared.TypeTok = typetok;
        M2SymInit_ConfigSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_LeftValue-SymbolTable_RightValue]), Sym);
        M2SymInit_ConfigSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_RightValue-SymbolTable_RightValue]), Sym);
        break;

      case SymbolTable_ConstVarSym:
        pSym->ConstVar.Type = VarType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym or ConstVarSym", 31);
        break;
    }
}


/*
   PutLeftValueFrontBackType - gives the variable symbol a front and backend type.
                               The variable must be a LeftValue.
*/

extern "C" void SymbolTable_PutLeftValueFrontBackType (unsigned int Sym, unsigned int FrontType, unsigned int BackType)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert ((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.Type = FrontType;
        pSym->Var.BackType = BackType;
        SymbolTable_PushSize (M2System_Address);
        M2ALU_PopInto (pSym->Var.Size);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym", 16);
        break;
    }
}


/*
   GetVarBackEndType - returns the back end type if specified.
*/

extern "C" unsigned int SymbolTable_GetVarBackEndType (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (Sym != SymbolTable_NulSym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.BackType;
        break;


      default:
        return SymbolTable_NulSym;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutVarPointerCheck - marks variable, sym, as requiring (or not
                        depending upon the, value), a NIL pointer check
                        when this symbol is dereferenced.
*/

extern "C" void SymbolTable_PutVarPointerCheck (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      pSym->Var.IsPointerCheck = value;
    }
}


/*
   GetVarPointerCheck - returns TRUE if this symbol is a variable and
                        has been marked as needing a pointer via NIL check.
*/

extern "C" bool SymbolTable_GetVarPointerCheck (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      return pSym->Var.IsPointerCheck;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutVarWritten - marks variable, sym, as being written to (or not
                   depending upon the, value).
*/

extern "C" void SymbolTable_PutVarWritten (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      pSym->Var.IsWritten = value;
    }
}


/*
   GetVarWritten - returns TRUE if this symbol is a variable and
                   has been marked as being written.
*/

extern "C" bool SymbolTable_GetVarWritten (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.IsWritten;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym", 16);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutConst - gives the constant symbol Sym a type ConstType.
*/

extern "C" void SymbolTable_PutConst (unsigned int Sym, unsigned int ConstType)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  CheckBreak (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        pSym->ConstVar.Type = ConstType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstVarSym", 21);
        break;
    }
}


/*
   PutConstSet - informs the const var symbol, sym, that it is or will contain
                 a set value.
*/

extern "C" void SymbolTable_PutConstSet (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        pSym->ConstVar.IsSet = true;
        break;

      case SymbolTable_ConstLitSym:
        pSym->ConstLit.IsSet = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstVar symbol", 25);
        break;
    }
}


/*
   IsConstSet - returns TRUE if the constant is declared as a set.
*/

extern "C" bool SymbolTable_IsConstSet (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.IsSet;
        break;

      case SymbolTable_ConstLitSym:
        return pSym->ConstLit.IsSet;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutConstructor - informs the const var symbol, sym, that it is or
                    will contain a constructor (record, set or array)
                    value.
*/

extern "C" void SymbolTable_PutConstructor (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        pSym->ConstVar.IsConstructor = true;
        break;

      case SymbolTable_ConstLitSym:
        pSym->ConstLit.IsConstructor = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstVar or ConstLit symbol", 37);
        break;
    }
}


/*
   PutConstructorFrom - sets the from type field in constructor,
                        Sym, to, from.
*/

extern "C" void SymbolTable_PutConstructorFrom (unsigned int Sym, unsigned int from)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        pSym->ConstVar.FromType = from;
        pSym->ConstVar.UnresFromType = true;
        break;

      case SymbolTable_ConstLitSym:
        pSym->ConstLit.FromType = from;
        pSym->ConstLit.UnresFromType = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstVar or ConstLit symbol", 37);
        break;
    }
  Lists_IncludeItemIntoList (UnresolvedConstructorType, Sym);
}


/*
   PutFieldRecord - places a field, FieldName and FieldType into a record, Sym.
                    VarSym is a optional varient symbol which can be returned
                    by a call to GetVarient(fieldsymbol).  The created field
                    is returned.
*/

extern "C" unsigned int SymbolTable_PutFieldRecord (unsigned int Sym, NameKey_Name FieldName, unsigned int FieldType, unsigned int VarSym)
{
  SymbolTable_PtrToSymbol oSym;
  SymbolTable_PtrToSymbol pSym;
  unsigned int esym;
  unsigned int ParSym;
  unsigned int SonSym;

  NewSym (&SonSym);  /* Cannot be used before declared since use occurs  */
  /* ensure that it is connected its parent.  */
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        Lists_PutItemIntoList (pSym->Record.ListOfSons, SonSym);
        M2Debug_Assert (Lists_IsItemInList (pSym->Record.ListOfSons, SonSym));
        /* Ensure that the Field is in the Parents Local Symbols  */
        if (FieldName != NameKey_NulName)
          {
            /* avoid gcc warning by using compound statement even if not strictly necessary.  */
            if ((SymbolKey_GetSymKey (pSym->Record.LocalSymbols, FieldName)) == SymbolKey_NulKey)
              {
                SymbolKey_PutSymKey (pSym->Record.LocalSymbols, FieldName, SonSym);
              }
            else
              {
                esym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->Record.LocalSymbols, FieldName));
                M2MetaError_MetaErrors1 ((const char *) "field record {%1Dad} has already been declared", 46, (const char *) "field record duplicate", 22, esym);
              }
          }
        CheckRecordConsistency (Sym);
        break;

      case SymbolTable_VarientFieldSym:
        Lists_PutItemIntoList (pSym->VarientField.ListOfSons, SonSym);
        ParSym = SymbolTable_GetRecord (pSym->VarientField.Parent);
        oSym = GetPsym (ParSym);
        M2Debug_Assert (oSym->SymbolType == SymbolTable_RecordSym);
        if (FieldName != NameKey_NulName)
          {
            oSym = GetPsym (ParSym);
            SymbolKey_PutSymKey (oSym->Record.LocalSymbols, FieldName, SonSym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Record symbol", 23);
        break;
    }
  /* Fill in SonSym  */
  oSym = GetPsym (SonSym);
  oSym->SymbolType = SymbolTable_RecordFieldSym;
  oSym->RecordField.Type = FieldType;
  oSym->RecordField.name = FieldName;
  oSym->RecordField.Tag = false;
  oSym->RecordField.Parent = Sym;
  oSym->RecordField.Varient = VarSym;
  oSym->RecordField.Align = SymbolTable_NulSym;
  oSym->RecordField.Used = true;
  oSym->RecordField.DeclPacked = false;  /* not known as packed (yet).  */
  oSym->RecordField.DeclResolved = false;  /* not known as packed (yet).  */
  oSym->RecordField.Scope = SymbolTable_GetScope (Sym);
  oSym->RecordField.Size = M2ALU_InitValue ();
  oSym->RecordField.Offset = M2ALU_InitValue ();
  InitWhereDeclared (&oSym->RecordField.At);
  return SonSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutFieldVarient - places the field varient, Field, as a brother to, the
                     varient symbol, sym, and also tells Field that its varient
                     parent is Sym.
*/

extern "C" void SymbolTable_PutFieldVarient (unsigned int Field, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsVarient (Sym));
  M2Debug_Assert (SymbolTable_IsFieldVarient (Field));
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarientSym:
        Lists_IncludeItemIntoList (pSym->Varient.ListOfSons, Field);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Varient symbol", 24);
        break;
    }
  pSym = GetPsym (Field);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarientFieldSym:
        pSym->VarientField.Varient = Sym;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarientField symbol", 29);
        break;
    }
}


/*
   GetVarient - returns the varient symbol associated with the
                record or varient field symbol, Field.
*/

extern "C" unsigned int SymbolTable_GetVarient (unsigned int Field)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Field);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.Varient;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.Varient;
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.Varient;
        break;


      default:
        return SymbolTable_NulSym;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRecordFieldAVarientTag - returns TRUE if record field, sym, is
                              a varient tag.
*/

extern "C" bool SymbolTable_IsRecordFieldAVarientTag (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsRecordField (sym))
    {
      pSym = GetPsym (sym);
      return pSym->RecordField.Tag;
    }
  else
    {
      M2Error_InternalError ((const char *) "record field symbol expected", 28);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsEmptyFieldVarient - returns TRUE if the field variant has
                         no fields.  This will occur then the
                         compiler constructs 'else end' variants.
*/

extern "C" bool SymbolTable_IsEmptyFieldVarient (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarientFieldSym:
        return (Lists_NoOfItemsInList (pSym->VarientField.ListOfSons)) == 0;
        break;


      default:
        M2Error_InternalError ((const char *) "varient field symbol expected", 29);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetVarientTag - returns the varient tag from, Sym.
*/

extern "C" unsigned int SymbolTable_GetVarientTag (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarientSym:
        return pSym->Varient.tag;
        break;


      default:
        M2Error_InternalError ((const char *) "varient symbol expected", 23);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutVarientTag - places, Tag, into varient, Sym.
*/

extern "C" void SymbolTable_PutVarientTag (unsigned int Sym, unsigned int Tag)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int parent;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarientSym:
        pSym->Varient.tag = Tag;
        break;


      default:
        M2Error_InternalError ((const char *) "varient symbol expected", 23);
        break;
    }
  /* now ensure that if Tag is a RecordField then it must be
      placed before the varient symbol in its parent ListOfSons.
      This allows M2GCCDeclare to declare record fields in order
      and preserve the order of fields.  Otherwise it will add the
      tag field after the C union.  */
  if (SymbolTable_IsRecordField (Tag))
    {
      pSym = GetPsym (Tag);
      pSym->RecordField.Tag = true;
      parent = SymbolTable_GetParent (Sym);
      pSym = GetPsym (parent);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ErrorSym:
            break;

          case SymbolTable_VarientSym:
            EnsureOrder (pSym->Varient.ListOfSons, Tag, Sym);
            break;

          case SymbolTable_VarientFieldSym:
            EnsureOrder (pSym->VarientField.ListOfSons, Tag, Sym);
            break;

          case SymbolTable_RecordSym:
            EnsureOrder (pSym->Record.ListOfSons, Tag, Sym);
            CheckRecordConsistency (parent);
            break;


          default:
            M2Error_InternalError ((const char *) "not expecting this symbol type", 30);
            break;
        }
    }
}


/*
   PutFieldEnumeration - places a field into the enumeration type
                         Sym. The field has a name FieldName and a
                         value FieldVal.
*/

extern "C" void SymbolTable_PutFieldEnumeration (unsigned int tok, unsigned int Sym, NameKey_Name FieldName)
{
  SymbolTable_PtrToSymbol oSym;
  SymbolTable_PtrToSymbol pSym;
  DynamicStrings_String s;
  unsigned int Field;

  Field = CheckForHiddenType (FieldName);
  if (Field == SymbolTable_NulSym)
    {
      Field = DeclareSym (tok, FieldName);
    }
  if (! (SymbolTable_IsError (Field)))
    {
      pSym = GetPsym (Field);
      pSym->SymbolType = SymbolTable_EnumerationFieldSym;
      pSym->EnumerationField.name = FieldName;  /* Index into name array, name  */
      /* of type.  */
      oSym = GetPsym (Sym);
      M2ALU_PushCard (oSym->Enumeration.NoOfElements);
      pSym->EnumerationField.Value = M2ALU_InitValue ();
      M2ALU_PopInto (pSym->EnumerationField.Value);
      pSym->EnumerationField.Type = Sym;
      pSym->EnumerationField.Scope = SymbolTable_GetCurrentScope ();
      InitWhereDeclaredTok (tok, &pSym->EnumerationField.At);  /* Declared here  */
      pSym = GetPsym (Sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_EnumerationSym:
            pSym->Enumeration.NoOfElements += 1;
            if ((SymbolKey_GetSymKey (pSym->Enumeration.LocalSymbols, FieldName)) != SymbolTable_NulSym)
              {
                s = DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (FieldName)));
                AlreadyDeclaredError (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "enumeration field (%s) is already declared elsewhere, use a different name or remove the declaration", 100)), (const unsigned char *) &s, (sizeof (s)-1)), FieldName, SymbolTable_GetDeclaredMod (SymbolKey_GetSymKey (pSym->Enumeration.LocalSymbols, FieldName)));
              }
            else
              {
                SymbolKey_PutSymKey (pSym->Enumeration.LocalSymbols, FieldName, Field);
                Lists_IncludeItemIntoList (pSym->Enumeration.ListOfFields, Field);
              }
            break;


          default:
            M2Error_InternalError ((const char *) "expecting Sym=Enumeration", 25);
            break;
        }
    }
}


/*
   PutSubrange - places LowSym and HighSym as two symbols
                 which provide the limits of the range.
*/

extern "C" void SymbolTable_PutSubrange (unsigned int Sym, unsigned int LowSym, unsigned int HighSym, unsigned int TypeSymbol)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_SubrangeSym:
        pSym->Subrange.Low = LowSym;  /* Index to symbol for lower  */
        pSym->Subrange.High = HighSym;  /* Index to symbol for higher  */
        pSym->Subrange.Type = TypeSymbol;  /* Index to type symbol for  */
        break;


      default:
        /* the type of subrange.  */
        M2Error_InternalError ((const char *) "expecting Subrange symbol", 25);
        break;
    }
}


/*
   PutSet - places SimpleType as the type for set, Sym.
*/

extern "C" void SymbolTable_PutSet (unsigned int Sym, unsigned int SimpleType, bool packed)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_SetSym:
        pSym->Set.Type = SimpleType;  /* Index to a subrange symbol  */
        /* or an enumeration type.  */
        pSym->Set.ispacked = packed;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Set symbol", 22);
        break;
    }
}


/*
   IsSetPacked - returns TRUE if Sym is packed.
*/

extern "C" bool SymbolTable_IsSetPacked (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return (pSym->SymbolType == SymbolTable_SetSym) && pSym->Set.ispacked;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetArraySubscript - returns the subscript symbol for array, Sym.
*/

extern "C" unsigned int SymbolTable_GetArraySubscript (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return SymbolTable_NulSym;
        break;

      case SymbolTable_ArraySym:
        return pSym->Array.Subscript;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting an Array symbol", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutArraySubscript - places an index field into the array Sym. The
                       index field is a subscript sym.
*/

extern "C" void SymbolTable_PutArraySubscript (unsigned int Sym, unsigned int SubscriptSymbol)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ArraySym:
        pSym->Array.Subscript = SubscriptSymbol;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting an Array symbol", 25);
        break;
    }
}


/*
   PutType - gives a type symbol Sym type TypeSymbol.
*/

extern "C" void SymbolTable_PutType (unsigned int Sym, unsigned int TypeSymbol)
{
  SymbolTable_PtrToSymbol pSym;

  if (TypeSymbol == Sym)
    {
      M2Error_InternalError ((const char *) "not expecting a type to be declared as itself", 45);
    }
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_TypeSym:
        pSym->Type.Type = TypeSymbol;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Type symbol", 23);
        break;
    }
}


/*
   PutFunction - Places a TypeSym as the return type to a procedure Sym.
*/

extern "C" void SymbolTable_PutFunction (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int TypeSym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.ReturnType = TypeSym;
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ReturnTypeTok = tok;
        SymbolTable_PutFunction (tok, pSym->Procedure.ProcedureType, kind, TypeSym);
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.ReturnType = TypeSym;
        pSym->ProcType.ReturnTypeTok = tok;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
}


/*
   PutOptFunction - places a TypeSym as the optional return type to a procedure Sym.
*/

extern "C" void SymbolTable_PutOptFunction (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int TypeSym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.ReturnType = TypeSym;
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ReturnOptional = true;
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ReturnTypeTok = tok;
        SymbolTable_PutOptFunction (tok, pSym->Procedure.ProcedureType, kind, TypeSym);
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.ReturnType = TypeSym;
        pSym->ProcType.ReturnTypeTok = tok;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
}


/*
   IsReturnOptional - returns TRUE if the return value for, sym, is
                      optional.
*/

extern "C" bool SymbolTable_IsReturnOptional (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ReturnOptional;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.ReturnOptional;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsReturnOptionalAny - returns TRUE if the return value for sym is
                         optional.
*/

extern "C" bool SymbolTable_IsReturnOptionalAny (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return IsProcedureAnyBoolean (sym, (SymbolTable_ProcAnyBoolean) {(SymbolTable_ProcAnyBoolean_t) SymbolTable_IsReturnOptional});
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.ReturnOptional;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutParam - Places a Non VAR parameter ParamName with type ParamType into
              procedure Sym:kind.  The parameter number is ParamNo.
              If the procedure Sym already has this parameter then
              the parameter is checked for consistancy and the
              consistancy test is returned.
*/

extern "C" bool SymbolTable_PutParam (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo, NameKey_Name ParamName, unsigned int ParamType, bool isUnbounded, unsigned int typetok)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ParSym;
  unsigned int VariableSym;

  if (SymbolTable_GetProcedureParametersDefined (Sym, kind))
    {
      /* ParamNo <= NoOfParamAny (Sym)  */
      M2Error_InternalError ((const char *) "why are we trying to put parameters again", 41);
    }
  else
    {
      /* Add a new parameter  */
      NewSym (&ParSym);
      pSym = GetPsym (ParSym);
      pSym->SymbolType = SymbolTable_ParamSym;
      pSym->Param.name = ParamName;
      pSym->Param.Type = ParamType;
      pSym->Param.IsUnbounded = isUnbounded;
      pSym->Param.Scope = Sym;
      pSym->Param.ShadowVar = SymbolTable_NulSym;
      pSym->Param.FullTok = M2LexBuf_MakeVirtual2Tok (tok, typetok);
      pSym->Param.At = tok;
      AddParameter (Sym, kind, ParSym);
      /* Only declare a parameter as a local variable if it has not been done before.
         It might be declared during the definition module, forward declaration or
         proper procedure.  Name mismatches are checked in P2SymBuild.mod.  */
      if ((ParamName != NameKey_NulName) && ((SymbolTable_GetNth (Sym, ParamNo)) == SymbolTable_NulSym))
        {
          VariableSym = MakeVariableForParam (tok, ParamName, Sym, kind, ParamNo, ParamType, typetok);
          if (VariableSym == SymbolTable_NulSym)
            {
              return false;
            }
          else
            {
              pSym = GetPsym (ParSym);
              pSym->Param.ShadowVar = VariableSym;
            }
        }
      AddProcedureProcTypeParam (tok, Sym, ParamType, isUnbounded, false);
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutVarParam - Places a Non VAR parameter ParamName with type
                 ParamType into procedure Sym:kind.
                 The parameter number is ParamNo.
                 If the procedure Sym already has this parameter then
                 the parameter is checked for consistancy and the
                 consistancy test is returned.
*/

extern "C" bool SymbolTable_PutVarParam (unsigned int tok, unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo, NameKey_Name ParamName, unsigned int ParamType, bool isUnbounded, unsigned int typetok)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ParSym;
  unsigned int VariableSym;

  if (SymbolTable_GetProcedureParametersDefined (Sym, kind))
    {
      M2Error_InternalError ((const char *) "why are we trying to put parameters again", 41);
    }
  else
    {
      /* Add a new parameter  */
      NewSym (&ParSym);
      pSym = GetPsym (ParSym);
      pSym->SymbolType = SymbolTable_VarParamSym;
      pSym->VarParam.name = ParamName;
      pSym->VarParam.Type = ParamType;
      pSym->VarParam.IsUnbounded = isUnbounded;
      pSym->VarParam.Scope = Sym;
      pSym->VarParam.ShadowVar = SymbolTable_NulSym;
      pSym->VarParam.HeapVar = SymbolTable_NulSym;  /* Will contain a pointer value.  */
      pSym->VarParam.FullTok = M2LexBuf_MakeVirtual2Tok (tok, typetok);  /* Will contain a pointer value.  */
      pSym->VarParam.At = tok;
      AddParameter (Sym, kind, ParSym);
      /* Only declare a parameter as a local variable if it has not been done before.
         It might be declared during the definition module, forward declaration or
         proper procedure.  Name mismatches are checked in P2SymBuild.mod.  */
      if ((ParamName != NameKey_NulName) && ((SymbolTable_GetNth (Sym, ParamNo)) == SymbolTable_NulSym))
        {
          VariableSym = MakeVariableForParam (tok, ParamName, Sym, kind, ParamNo, ParamType, typetok);
          if (VariableSym == SymbolTable_NulSym)
            {
              return false;
            }
          else
            {
              pSym = GetPsym (ParSym);
              pSym->VarParam.ShadowVar = VariableSym;
            }
        }
      AddProcedureProcTypeParam (tok, Sym, ParamType, isUnbounded, true);
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutParamName - assigns a name to paramater no of procedure ProcSym:kind.
*/

extern "C" void SymbolTable_PutParamName (unsigned int tok, unsigned int ProcSym, SymbolTable_ProcedureKind kind, unsigned int no, NameKey_Name name, unsigned int ParamType, unsigned int typetok)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ParSym;

  pSym = GetPsym (ProcSym);
  ParSym = SymbolTable_NulSym;
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return;
        break;

      case SymbolTable_ProcedureSym:
        ParSym = static_cast<unsigned int> (Lists_GetItemFromList (pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ListOfParam, no));
        break;

      case SymbolTable_ProcTypeSym:
        ParSym = static_cast<unsigned int> (Lists_GetItemFromList (pSym->ProcType.ListOfParam, no));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
  pSym = GetPsym (ParSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
        if (pSym->Param.name == NameKey_NulName)
          {
            pSym->Param.name = name;
            pSym->Param.ShadowVar = MakeVariableForParam (tok, name, ProcSym, kind, no, ParamType, typetok);
          }
        else
          {
            M2Error_InternalError ((const char *) "name of parameter has already been assigned", 43);
          }
        break;

      case SymbolTable_VarParamSym:
        if (pSym->VarParam.name == NameKey_NulName)
          {
            pSym->VarParam.name = name;
            pSym->VarParam.ShadowVar = MakeVariableForParam (tok, name, ProcSym, kind, no, ParamType, typetok);
          }
        else
          {
            M2Error_InternalError ((const char *) "name of parameter has already been assigned", 43);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a VarParam or Param symbol", 36);
        break;
    }
}


/*
   PutProcedureReachable - Sets the procedure, Sym, to be reachable by the
                           main Module.
*/

extern "C" void SymbolTable_PutProcedureReachable (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.Reachable = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Procedure symbol", 26);
        break;
    }
}


/*
   IsProcedureReachable - Returns true if the procedure, Sym, is
                          reachable from the main Module.
*/

extern "C" bool SymbolTable_IsProcedureReachable (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Reachable;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureNoReturn - places value into the no return attribute
                          field of procedure sym.
*/

extern "C" void SymbolTable_PutProcedureNoReturn (unsigned int Sym, SymbolTable_ProcedureKind kind, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].IsNoReturn = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
}


/*
   IsProcedureNoReturn - returns TRUE if this procedure never returns.
*/

extern "C" bool SymbolTable_IsProcedureNoReturn (unsigned int Sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].IsNoReturn;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetProcedureProcType - returns the proctype matching procedure sym.
*/

extern "C" unsigned int SymbolTable_GetProcedureProcType (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.ProcedureType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutModuleStartQuad - Places QuadNumber into the Module symbol, Sym.
                        QuadNumber is the start quad of Module,
                        Sym.
*/

extern "C" void SymbolTable_PutModuleStartQuad (unsigned int Sym, unsigned int QuadNumber)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        pSym->Module.StartQuad = QuadNumber;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.StartQuad = QuadNumber;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   PutModuleEndQuad - Places QuadNumber into the Module symbol, Sym.
                      QuadNumber is the end quad of Module,
                      Sym.
*/

extern "C" void SymbolTable_PutModuleEndQuad (unsigned int Sym, unsigned int QuadNumber)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        pSym->Module.EndQuad = QuadNumber;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.EndQuad = QuadNumber;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   PutModuleFinallyStartQuad - Places QuadNumber into the Module symbol, Sym.
                               QuadNumber is the finally start quad of
                               Module, Sym.
*/

extern "C" void SymbolTable_PutModuleFinallyStartQuad (unsigned int Sym, unsigned int QuadNumber)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        pSym->Module.StartFinishQuad = QuadNumber;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.StartFinishQuad = QuadNumber;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   PutModuleFinallyEndQuad - Places QuadNumber into the Module symbol, Sym.
                             QuadNumber is the end quad of the finally block
                             in Module, Sym.
*/

extern "C" void SymbolTable_PutModuleFinallyEndQuad (unsigned int Sym, unsigned int QuadNumber)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        pSym->Module.EndFinishQuad = QuadNumber;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.EndFinishQuad = QuadNumber;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   GetModuleQuads - Returns, StartInit EndInit StartFinish EndFinish,
                    Quads of a Module, Sym.
                    Start and End represent the initialization code
                    of the Module, Sym.
*/

extern "C" void SymbolTable_GetModuleQuads (unsigned int Sym, unsigned int *StartInit, unsigned int *EndInit, unsigned int *StartFinish, unsigned int *EndFinish)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        (*StartInit) = pSym->Module.StartQuad;
        (*EndInit) = pSym->Module.EndQuad;
        (*StartFinish) = pSym->Module.StartFinishQuad;
        (*EndFinish) = pSym->Module.EndFinishQuad;
        break;

      case SymbolTable_DefImpSym:
        (*StartInit) = pSym->DefImp.StartQuad;
        (*EndInit) = pSym->DefImp.EndQuad;
        (*StartFinish) = pSym->DefImp.StartFinishQuad;
        (*EndFinish) = pSym->DefImp.EndFinishQuad;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   PutModuleFinallyFunction - Places Tree, finally, into the Module symbol, Sym.
*/

extern "C" void SymbolTable_PutModuleFinallyFunction (unsigned int Sym, tree finally)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        pSym->Module.FinallyFunction = finally;
        break;

      case SymbolTable_DefImpSym:
        pSym->DefImp.FinallyFunction = finally;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   GetModuleFinallyFunction - returns the finally tree from the Module symbol, Sym.
*/

extern "C" tree SymbolTable_GetModuleFinallyFunction (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        return pSym->Module.FinallyFunction;
        break;

      case SymbolTable_DefImpSym:
        return pSym->DefImp.FinallyFunction;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureScopeQuad - Places QuadNumber into the Procedure symbol, Sym.
                           QuadNumber is the start quad of scope for procedure,
                           Sym.
*/

extern "C" void SymbolTable_PutProcedureScopeQuad (unsigned int Sym, unsigned int QuadNumber)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.ScopeQuad = QuadNumber;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   PutProcedureStartQuad - Places QuadNumber into the Procedure symbol, Sym.
                           QuadNumber is the start quad of procedure,
                           Sym.
*/

extern "C" void SymbolTable_PutProcedureStartQuad (unsigned int Sym, unsigned int QuadNumber)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.StartQuad = QuadNumber;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   PutProcedureEndQuad - Places QuadNumber into the Procedure symbol, Sym.
                         QuadNumber is the end quad of procedure,
                         Sym.
*/

extern "C" void SymbolTable_PutProcedureEndQuad (unsigned int Sym, unsigned int QuadNumber)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.EndQuad = QuadNumber;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   GetProcedureQuads - Returns, Start and End, Quads of a procedure, Sym.
*/

extern "C" void SymbolTable_GetProcedureQuads (unsigned int Sym, unsigned int *scope, unsigned int *start, unsigned int *end)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        (*scope) = pSym->Procedure.ScopeQuad;
        (*start) = pSym->Procedure.StartQuad;
        (*end) = pSym->Procedure.EndQuad;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   GetQuads - assigns Start and End to the beginning and end of
              symbol, Sym, usage.
*/

extern "C" void SymbolTable_GetQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End)
{
  unsigned int StartRead;
  unsigned int EndRead;
  unsigned int StartWrite;
  unsigned int EndWrite;

  SymbolTable_GetReadQuads (Sym, m, &StartRead, &EndRead);
  SymbolTable_GetWriteQuads (Sym, m, &StartWrite, &EndWrite);
  if (StartRead == 0)
    {
      (*Start) = StartWrite;
    }
  else if (StartWrite == 0)
    {
      /* avoid dangling else.  */
      (*Start) = StartRead;
    }
  else
    {
      /* avoid dangling else.  */
      (*Start) = Min (StartRead, StartWrite);
    }
  if (EndRead == 0)
    {
      (*End) = EndWrite;
    }
  else if (EndWrite == 0)
    {
      /* avoid dangling else.  */
      (*End) = EndRead;
    }
  else
    {
      /* avoid dangling else.  */
      (*End) = Max (EndRead, EndWrite);
    }
}


/*
   GetReadQuads - assigns Start and End to the beginning and end of
                  symbol, Sym, read history usage.
*/

extern "C" void SymbolTable_GetReadQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End)
{
  SymbolTable_GetReadLimitQuads (Sym, m, 0, 0, Start, End);
}


/*
   GetWriteQuads - assigns Start and End to the beginning and end of
                   symbol, Sym, usage.
*/

extern "C" void SymbolTable_GetWriteQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int *Start, unsigned int *End)
{
  SymbolTable_GetWriteLimitQuads (Sym, m, 0, 0, Start, End);
}


/*
   PutReadQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_PutReadQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        Lists_IncludeItemIntoList (static_cast<Lists_List> (pSym->Var.ReadUsageList.array[m-SymbolTable_RightValue]), Quad);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
}


/*
   RemoveReadQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_RemoveReadQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        Lists_RemoveItemFromList (static_cast<Lists_List> (pSym->Var.ReadUsageList.array[m-SymbolTable_RightValue]), Quad);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
}


/*
   PutWriteQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_PutWriteQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        Lists_IncludeItemIntoList (static_cast<Lists_List> (pSym->Var.WriteUsageList.array[m-SymbolTable_RightValue]), Quad);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
}


/*
   RemoveWriteQuad - places Quad into the list of symbol usage.
*/

extern "C" void SymbolTable_RemoveWriteQuad (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int Quad)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        Lists_RemoveItemFromList (static_cast<Lists_List> (pSym->Var.WriteUsageList.array[m-SymbolTable_RightValue]), Quad);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
}


/*
   GetReadLimitQuads - returns Start and End which have been assigned
                       the start and end of when the symbol was read
                       to within: StartLimit..EndLimit.
*/

extern "C" void SymbolTable_GetReadLimitQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        DoFindLimits (StartLimit, EndLimit, Start, End, static_cast<Lists_List> (pSym->Var.ReadUsageList.array[m-SymbolTable_RightValue]));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
}


/*
   GetWriteLimitQuads - returns Start and End which have been assigned
                        the start and end of when the symbol was written
                        to within: StartLimit..EndLimit.
*/

extern "C" void SymbolTable_GetWriteLimitQuads (unsigned int Sym, SymbolTable_ModeOfAddr m, unsigned int StartLimit, unsigned int EndLimit, unsigned int *Start, unsigned int *End)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        DoFindLimits (StartLimit, EndLimit, Start, End, static_cast<Lists_List> (pSym->Var.WriteUsageList.array[m-SymbolTable_RightValue]));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Var symbol", 22);
        break;
    }
}


/*
   GetNthProcedure - Returns the Nth procedure in Module, Sym.
*/

extern "C" unsigned int SymbolTable_GetNthProcedure (unsigned int Sym, unsigned int n)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return static_cast<unsigned int> (Lists_GetItemFromList (pSym->DefImp.ListOfProcs, n));
        break;

      case SymbolTable_ModuleSym:
        return static_cast<unsigned int> (Lists_GetItemFromList (pSym->Module.ListOfProcs, n));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetDeclaredDef - returns the tokenno where the symbol was declared
                    in the definition module.  UnknownTokenNo is returned
                    if no declaration occurred.
*/

extern "C" unsigned int SymbolTable_GetDeclaredDef (unsigned int Sym)
{
  return SymbolTable_GetDeclaredDefinition (Sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDeclaredMod - returns the tokenno where the symbol was declared.
                    in the program or implementation module.
                    UnknownTokenNo is returned if no declaration occurred.
*/

extern "C" unsigned int SymbolTable_GetDeclaredMod (unsigned int Sym)
{
  return SymbolTable_GetDeclaredModule (Sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDeclaredFor - returns the token where this forward procedure symbol
                    was declared in the program or implementation module.
                    UnknownTokenNo is returned if no declaration occurred.
*/

extern "C" unsigned int SymbolTable_GetDeclaredFor (unsigned int Sym)
{
  if (SymbolTable_IsProcedure (Sym))
    {
      return SymbolTable_GetProcedureDeclaredTok (Sym, SymbolTable_ForwardProcedure);
    }
  else
    {
      return M2LexBuf_UnknownTokenNo;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDeclaredDefinition - returns the token where this symbol
                           was declared in the definition module.
*/

extern "C" unsigned int SymbolTable_GetDeclaredDefinition (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return pSym->Error.At.DefDeclared;
        break;

      case SymbolTable_ObjectSym:
        return pSym->Object.At.DefDeclared;
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.At.DefDeclared;
        break;

      case SymbolTable_RecordSym:
        return pSym->Record.At.DefDeclared;
        break;

      case SymbolTable_SubrangeSym:
        return pSym->Subrange.At.DefDeclared;
        break;

      case SymbolTable_EnumerationSym:
        return pSym->Enumeration.At.DefDeclared;
        break;

      case SymbolTable_ArraySym:
        return pSym->Array.At.DefDeclared;
        break;

      case SymbolTable_SubscriptSym:
        return pSym->Subscript.At.DefDeclared;
        break;

      case SymbolTable_UnboundedSym:
        return pSym->Unbounded.At.DefDeclared;
        break;

      case SymbolTable_ProcedureSym:
        return pSym->Procedure.At.DefDeclared;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.At.DefDeclared;
        break;

      case SymbolTable_ParamSym:
        return pSym->Param.At;
        break;

      case SymbolTable_VarParamSym:
        return pSym->VarParam.At;
        break;

      case SymbolTable_ConstStringSym:
        return pSym->ConstString.At.DefDeclared;
        break;

      case SymbolTable_ConstLitSym:
        return pSym->ConstLit.At.DefDeclared;
        break;

      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.At.DefDeclared;
        break;

      case SymbolTable_VarSym:
        return pSym->Var.At.DefDeclared;
        break;

      case SymbolTable_TypeSym:
        return pSym->Type.At.DefDeclared;
        break;

      case SymbolTable_PointerSym:
        return pSym->Pointer.At.DefDeclared;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.At.DefDeclared;
        break;

      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.At.DefDeclared;
        break;

      case SymbolTable_EnumerationFieldSym:
        return pSym->EnumerationField.At.DefDeclared;
        break;

      case SymbolTable_SetSym:
        return pSym->Set.At.DefDeclared;
        break;

      case SymbolTable_DefImpSym:
        return pSym->DefImp.At.DefDeclared;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.At.DefDeclared;
        break;

      case SymbolTable_UndefinedSym:
        return SymbolTable_GetFirstUsed (Sym);
        break;

      case SymbolTable_ImportSym:
        return pSym->Import.at.DefDeclared;
        break;

      case SymbolTable_ImportStatementSym:
        return pSym->ImportStatement.at.DefDeclared;
        break;

      case SymbolTable_PartialUnboundedSym:
        return SymbolTable_GetDeclaredDefinition (pSym->PartialUnbounded.Type);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this type of symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetDeclaredModule - returns the token where this symbol was declared
                       in an implementation or program module.
*/

extern "C" unsigned int SymbolTable_GetDeclaredModule (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return pSym->Error.At.ModDeclared;
        break;

      case SymbolTable_ObjectSym:
        return pSym->Object.At.ModDeclared;
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.At.ModDeclared;
        break;

      case SymbolTable_RecordSym:
        return pSym->Record.At.ModDeclared;
        break;

      case SymbolTable_SubrangeSym:
        return pSym->Subrange.At.ModDeclared;
        break;

      case SymbolTable_EnumerationSym:
        return pSym->Enumeration.At.ModDeclared;
        break;

      case SymbolTable_ArraySym:
        return pSym->Array.At.ModDeclared;
        break;

      case SymbolTable_SubscriptSym:
        return pSym->Subscript.At.ModDeclared;
        break;

      case SymbolTable_UnboundedSym:
        return pSym->Unbounded.At.ModDeclared;
        break;

      case SymbolTable_ProcedureSym:
        return pSym->Procedure.At.ModDeclared;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.At.ModDeclared;
        break;

      case SymbolTable_ParamSym:
        return pSym->Param.At;
        break;

      case SymbolTable_VarParamSym:
        return pSym->VarParam.At;
        break;

      case SymbolTable_ConstStringSym:
        return pSym->ConstString.At.ModDeclared;
        break;

      case SymbolTable_ConstLitSym:
        return pSym->ConstLit.At.ModDeclared;
        break;

      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.At.ModDeclared;
        break;

      case SymbolTable_VarSym:
        return pSym->Var.At.ModDeclared;
        break;

      case SymbolTable_TypeSym:
        return pSym->Type.At.ModDeclared;
        break;

      case SymbolTable_PointerSym:
        return pSym->Pointer.At.ModDeclared;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.At.ModDeclared;
        break;

      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.At.ModDeclared;
        break;

      case SymbolTable_EnumerationFieldSym:
        return pSym->EnumerationField.At.ModDeclared;
        break;

      case SymbolTable_SetSym:
        return pSym->Set.At.ModDeclared;
        break;

      case SymbolTable_DefImpSym:
        return pSym->DefImp.At.ModDeclared;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.At.ModDeclared;
        break;

      case SymbolTable_UndefinedSym:
        return SymbolTable_GetFirstUsed (Sym);
        break;

      case SymbolTable_ImportSym:
        return pSym->Import.at.ModDeclared;
        break;

      case SymbolTable_ImportStatementSym:
        return pSym->ImportStatement.at.ModDeclared;
        break;

      case SymbolTable_PartialUnboundedSym:
        return SymbolTable_GetDeclaredModule (pSym->PartialUnbounded.Type);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this type of symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutDeclared - adds an entry to symbol, Sym, indicating that it
                 was declared at, tok.  This routine
                 may be called twice, once for definition module
                 partial declaration and once when parsing the
                 implementation module.
*/

extern "C" void SymbolTable_PutDeclared (unsigned int tok, unsigned int Sym)
{
  if (M2Comp_CompilingDefinitionModule ())
    {
      PutDeclaredDefinition (tok, Sym);
    }
  else
    {
      PutDeclaredModule (tok, Sym);
    }
}


/*
   GetFirstUsed - returns the token where this symbol was first used.
*/

extern "C" unsigned int SymbolTable_GetFirstUsed (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return pSym->Error.At.FirstUsed;
        break;

      case SymbolTable_ObjectSym:
        return pSym->Object.At.FirstUsed;
        break;

      case SymbolTable_UndefinedSym:
        return pSym->Undefined.At.FirstUsed;
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.At.FirstUsed;
        break;

      case SymbolTable_RecordSym:
        return pSym->Record.At.FirstUsed;
        break;

      case SymbolTable_SubrangeSym:
        return pSym->Subrange.At.FirstUsed;
        break;

      case SymbolTable_EnumerationSym:
        return pSym->Enumeration.At.FirstUsed;
        break;

      case SymbolTable_ArraySym:
        return pSym->Array.At.FirstUsed;
        break;

      case SymbolTable_SubscriptSym:
        return pSym->Subscript.At.FirstUsed;
        break;

      case SymbolTable_UnboundedSym:
        return pSym->Unbounded.At.FirstUsed;
        break;

      case SymbolTable_ProcedureSym:
        return pSym->Procedure.At.FirstUsed;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.At.FirstUsed;
        break;

      case SymbolTable_ConstStringSym:
        /* 
      ParamSym           : RETURN( Param.At.FirstUsed ) |
      VarParamSym        : RETURN( VarParam.At.FirstUsed ) |
  */
        return pSym->ConstString.At.FirstUsed;
        break;

      case SymbolTable_ConstLitSym:
        return pSym->ConstLit.At.FirstUsed;
        break;

      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.At.FirstUsed;
        break;

      case SymbolTable_VarSym:
        return pSym->Var.At.FirstUsed;
        break;

      case SymbolTable_TypeSym:
        return pSym->Type.At.FirstUsed;
        break;

      case SymbolTable_PointerSym:
        return pSym->Pointer.At.FirstUsed;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.At.FirstUsed;
        break;

      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.At.FirstUsed;
        break;

      case SymbolTable_EnumerationFieldSym:
        return pSym->EnumerationField.At.FirstUsed;
        break;

      case SymbolTable_SetSym:
        return pSym->Set.At.FirstUsed;
        break;

      case SymbolTable_DefImpSym:
        return pSym->DefImp.At.FirstUsed;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.At.FirstUsed;
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this type of symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureBegin - assigns begin as the token number matching the
                       procedure BEGIN.
*/

extern "C" void SymbolTable_PutProcedureBegin (unsigned int Sym, unsigned int begin)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.Begin = begin;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   PutProcedureEnd - assigns end as the token number matching the
                     procedure END.
*/

extern "C" void SymbolTable_PutProcedureEnd (unsigned int Sym, unsigned int end)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.End = end;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   GetProcedureBeginEnd - assigns, begin, end, to the stored token values.
*/

extern "C" void SymbolTable_GetProcedureBeginEnd (unsigned int Sym, unsigned int *begin, unsigned int *end)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        (*begin) = pSym->Procedure.Begin;
        (*end) = pSym->Procedure.End;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   ForeachProcedureDo - for each procedure in module, Sym, do procedure, P.
*/

extern "C" void SymbolTable_ForeachProcedureDo (unsigned int Sym, SymbolKey_PerformOperation P)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Lists_ForeachItemInListDo (pSym->DefImp.ListOfProcs, P);
        break;

      case SymbolTable_ModuleSym:
        Lists_ForeachItemInListDo (pSym->Module.ListOfProcs, P);
        break;

      case SymbolTable_ProcedureSym:
        Lists_ForeachItemInListDo (pSym->Procedure.ListOfProcs, P);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
}


/*
   ForeachModuleDo - for each module do procedure, P.
*/

extern "C" void SymbolTable_ForeachModuleDo (SymbolKey_PerformOperation P)
{
  SymbolKey_ForeachNodeDo (ModuleTree, P);
}


/*
   ForeachInnerModuleDo - for each inner module in module, Sym,
                          do procedure, P.
*/

extern "C" void SymbolTable_ForeachInnerModuleDo (unsigned int Sym, SymbolKey_PerformOperation P)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Lists_ForeachItemInListDo (pSym->DefImp.ListOfModules, P);
        break;

      case SymbolTable_ModuleSym:
        Lists_ForeachItemInListDo (pSym->Module.ListOfModules, P);
        break;

      case SymbolTable_ProcedureSym:
        Lists_ForeachItemInListDo (pSym->Procedure.ListOfModules, P);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
        break;
    }
}


/*
   IsVarParam - Returns a conditional depending whether parameter ParamNo
                is a VAR parameter.
*/

extern "C" bool SymbolTable_IsVarParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo)
{
  SymbolTable_PtrToSymbol pSym;
  bool IsVar;

  IsVar = false;
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        IsVar = IsNthParamVar (pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ListOfParam, ParamNo);
        break;

      case SymbolTable_ProcTypeSym:
        IsVar = IsNthParamVar (pSym->ProcType.ListOfParam, ParamNo);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  return IsVar;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVarParamAny - Returns a conditional depending whether parameter ParamNo
                   is a VAR parameter.
*/

extern "C" bool SymbolTable_IsVarParamAny (unsigned int Sym, unsigned int ParamNo)
{
  SymbolTable_PtrToSymbol pSym;
  SymbolTable_ProcedureKind kind;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
          {
            if (SymbolTable_GetProcedureDefined (Sym, kind))
              {
                return IsNthParamVar (pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ListOfParam, ParamNo);
              }
          }
        break;

      case SymbolTable_ProcTypeSym:
        return IsNthParamVar (pSym->ProcType.ListOfParam, ParamNo);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsUnboundedParam - Returns a conditional depending whether parameter
                      ParamNo is an unbounded array procedure parameter.
*/

extern "C" bool SymbolTable_IsUnboundedParam (unsigned int Sym, SymbolTable_ProcedureKind kind, unsigned int ParamNo)
{
  unsigned int param;

  param = SymbolTable_GetNthParam (Sym, kind, ParamNo);
  return SymbolTable_IsParameterUnbounded (param);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" bool SymbolTable_IsUnboundedParamAny (unsigned int Sym, unsigned int ParamNo)
{
  SymbolTable_ProcedureKind kind;

  for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
    {
      /* 
   IsUnboundedParam - Returns a conditional depending whether parameter
                      ParamNo is an unbounded array procedure parameter.
  */
      if (SymbolTable_GetProcedureParametersDefined (Sym, kind))
        {
          return SymbolTable_IsUnboundedParam (Sym, kind, ParamNo);
        }
    }
  M2Error_InternalError ((const char *) "no procedure kind exists", 24);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsParameterUnbounded - returns TRUE if parameter, Sym, is
                          unbounded.
*/

extern "C" bool SymbolTable_IsParameterUnbounded (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
        return pSym->Param.IsUnbounded;
        break;

      case SymbolTable_VarParamSym:
        return pSym->VarParam.IsUnbounded;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Param or VarParam symbol", 34);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsParameterVar - returns true if parameter symbol Sym
                    was declared as a VAR.
*/

extern "C" bool SymbolTable_IsParameterVar (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
        return false;
        break;

      case SymbolTable_VarParamSym:
        return true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Param or VarParam symbol", 34);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetParameterShadowVar - returns the local variable associated with the
                           parameter symbol, sym.
*/

extern "C" unsigned int SymbolTable_GetParameterShadowVar (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
        return pSym->Param.ShadowVar;
        break;

      case SymbolTable_VarParamSym:
        return pSym->VarParam.ShadowVar;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a ParamSym or VarParamSym", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   NoOfParam - Returns the number of parameters that procedure Sym contains.
*/

extern "C" unsigned int SymbolTable_NoOfParam (unsigned int Sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int n;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        n = 0;
        break;

      case SymbolTable_ProcedureSym:
        n = Lists_NoOfItemsInList (pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ListOfParam);
        break;

      case SymbolTable_ProcTypeSym:
        n = Lists_NoOfItemsInList (pSym->ProcType.ListOfParam);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  return n;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   HasVarParameters - returns TRUE if procedure, p, has any VAR parameters.
*/

extern "C" bool SymbolTable_HasVarParameters (unsigned int p)
{
  unsigned int i;
  unsigned int n;

  n = SymbolTable_NoOfParamAny (p);
  i = 1;
  while (i <= n)
    {
      if (SymbolTable_IsParameterVar (SymbolTable_GetNthParamAny (p, i)))
        {
          return true;
        }
      i += 1;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NoOfLocalVar - returns the number of local variables that exist in
                  procedure Sym. Parameters are NOT included in the
                  count.
*/

extern "C" unsigned int SymbolTable_NoOfLocalVar (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int n;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        n = 0;
        break;

      case SymbolTable_ProcedureSym:
        n = Lists_NoOfItemsInList (pSym->Procedure.ListOfVars);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
  /* 
      Parameters are actually included in the list of local varaibles,
      therefore we must subtract the Parameter Number from local variable
      total.
  */
  return n-(SymbolTable_NoOfParamAny (Sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsDefImp - returns true is the Sym is a DefImp symbol.
              Definition/Implementation module symbol.
*/

extern "C" bool SymbolTable_IsDefImp (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_DefImpSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsModule - returns true is the Sym is a Module symbol.
              Program module symbol.
*/

extern "C" bool SymbolTable_IsModule (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_ModuleSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsInnerModule - returns true if the symbol, Sym, is an inner module.
*/

extern "C" bool SymbolTable_IsInnerModule (unsigned int Sym)
{
  if (SymbolTable_IsModule (Sym))
    {
      return (SymbolTable_GetScope (Sym)) != SymbolTable_NulSym;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetSymName - returns the symbol name.
*/

extern "C" NameKey_Name SymbolTable_GetSymName (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  NameKey_Name n;

  if (Sym == SymbolTable_NulSym)
    {
      n = SymbolKey_NulKey;
    }
  else
    {
      pSym = GetPsym (Sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ErrorSym:
            n = pSym->Error.name;
            break;

          case SymbolTable_ObjectSym:
            n = pSym->Object.name;
            break;

          case SymbolTable_DefImpSym:
            n = pSym->DefImp.name;
            break;

          case SymbolTable_ModuleSym:
            n = pSym->Module.name;
            break;

          case SymbolTable_TypeSym:
            n = pSym->Type.name;
            break;

          case SymbolTable_VarSym:
            n = pSym->Var.name;
            break;

          case SymbolTable_ConstLitSym:
            n = pSym->ConstLit.name;
            break;

          case SymbolTable_ConstVarSym:
            n = pSym->ConstVar.name;
            break;

          case SymbolTable_ConstStringSym:
            n = pSym->ConstString.name;
            break;

          case SymbolTable_EnumerationSym:
            n = pSym->Enumeration.name;
            break;

          case SymbolTable_EnumerationFieldSym:
            n = pSym->EnumerationField.name;
            break;

          case SymbolTable_UndefinedSym:
            n = pSym->Undefined.name;
            break;

          case SymbolTable_ProcedureSym:
            n = pSym->Procedure.name;
            break;

          case SymbolTable_ProcTypeSym:
            n = pSym->ProcType.name;
            break;

          case SymbolTable_RecordFieldSym:
            n = pSym->RecordField.name;
            break;

          case SymbolTable_RecordSym:
            n = pSym->Record.name;
            break;

          case SymbolTable_VarientSym:
            n = NameKey_NulName;
            break;

          case SymbolTable_VarientFieldSym:
            n = pSym->VarientField.name;
            break;

          case SymbolTable_VarParamSym:
            n = pSym->VarParam.name;
            break;

          case SymbolTable_ParamSym:
            n = pSym->Param.name;
            break;

          case SymbolTable_PointerSym:
            n = pSym->Pointer.name;
            break;

          case SymbolTable_ArraySym:
            n = pSym->Array.name;
            break;

          case SymbolTable_UnboundedSym:
            n = NameKey_NulName;
            break;

          case SymbolTable_SubrangeSym:
            n = pSym->Subrange.name;
            break;

          case SymbolTable_SetSym:
            n = pSym->Set.name;
            break;

          case SymbolTable_SubscriptSym:
            n = NameKey_NulName;
            break;

          case SymbolTable_DummySym:
            n = NameKey_NulName;
            break;

          case SymbolTable_PartialUnboundedSym:
            n = SymbolTable_GetSymName (pSym->PartialUnbounded.Type);
            break;

          case SymbolTable_TupleSym:
            n = NameKey_NulName;
            break;

          case SymbolTable_GnuAsmSym:
            n = NameKey_NulName;
            break;

          case SymbolTable_InterfaceSym:
            n = NameKey_NulName;
            break;

          case SymbolTable_ImportSym:
            n = NameKey_NulName;
            break;

          case SymbolTable_ImportStatementSym:
            n = NameKey_NulName;
            break;


          default:
            M2Error_InternalError ((const char *) "unexpected symbol type", 22);
            break;
        }
    }
  return n;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RenameSym - renames a symbol, Sym, with SymName.
               It also checks the unknown tree for a symbol
               with this new name. Must only be renamed in
               the same scope of being declared.
*/

extern "C" void SymbolTable_RenameSym (unsigned int Sym, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;

  if ((SymbolTable_GetSymName (Sym)) == NameKey_NulName)
    {
      pSym = GetPsym (Sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ErrorSym:
            M2Error_ErrorAbort0 ((const char *) "", 0);
            break;

          case SymbolTable_TypeSym:
            pSym->Type.name = SymName;
            break;

          case SymbolTable_VarSym:
            pSym->Var.name = SymName;
            break;

          case SymbolTable_ConstLitSym:
            pSym->ConstLit.name = SymName;
            break;

          case SymbolTable_ConstVarSym:
            pSym->ConstVar.name = SymName;
            break;

          case SymbolTable_UndefinedSym:
            pSym->Undefined.name = SymName;
            break;

          case SymbolTable_RecordSym:
            pSym->Record.name = SymName;
            break;

          case SymbolTable_PointerSym:
            pSym->Pointer.name = SymName;
            break;


          default:
            M2Error_InternalError ((const char *) "not implemented yet", 19);
            break;
        }
      AddSymToScope (Sym, SymName);
    }
  else
    {
      M2Error_InternalError ((const char *) "old name of symbol must be nul", 30);
    }
}


/*
   IsUnknown - returns true is the symbol Sym is unknown.
*/

extern "C" bool SymbolTable_IsUnknown (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_UndefinedSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsPartialUnbounded - returns TRUE if, sym, is a partially unbounded symbol.
*/

extern "C" bool SymbolTable_IsPartialUnbounded (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (sym > 0)
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_PartialUnboundedSym:
            return true;
            break;


          default:
            return false;
            break;
        }
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   RequestSym - searches for a symbol with a name SymName in the
                current and previous scopes.
                If the symbol is found then it is returned
                else an unknown symbol is returned create at token
                position, tok.
                This procedure does search the base scope (for
                pervasive identifiers).
*/

extern "C" unsigned int SymbolTable_RequestSym (unsigned int tok, NameKey_Name SymName)
{
  unsigned int Sym;

  /* 
      WriteString('RequestSym for: ') ; WriteKey(SymName) ; WriteLn ;
  */
  Sym = SymbolTable_GetSym (SymName);
  if (Sym == SymbolTable_NulSym)
    {
      Sym = GetSymFromUnknownTree (SymName);
      if (Sym == SymbolTable_NulSym)
        {
          /* Make unknown  */
          NewSym (&Sym);
          FillInUnknownFields (tok, Sym, SymName);
          /* 
           ; WriteKey(SymName) ; WriteString(' unknown demanded') ; WriteLn
  */
          AddSymToUnknownTree (static_cast<int> (ScopePtr), SymName, Sym);
        }
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutImported - places a symbol, Sym, into the current main scope.
*/

extern "C" void SymbolTable_PutImported (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ModSym;
  NameKey_Name n;

  /* 
      We have currently imported Sym, now place it into the current module.
  */
  ModSym = SymbolTable_GetCurrentModuleScope ();
  M2Debug_Assert ((SymbolTable_IsDefImp (ModSym)) || (SymbolTable_IsModule (ModSym)));
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        if ((SymbolKey_GetSymKey (pSym->Module.ImportTree, SymbolTable_GetSymName (Sym))) == Sym)
          {
            /* avoid dangling else.  */
            if (M2Options_Pedantic)
              {
                n = SymbolTable_GetSymName (Sym);
                M2Error_WriteFormat1 ((const char *) "symbol (%a) has already been imported", 37, (const unsigned char *) &n, (sizeof (n)-1));
              }
          }
        else if ((SymbolKey_GetSymKey (pSym->Module.ImportTree, SymbolTable_GetSymName (Sym))) == SymbolKey_NulKey)
          {
            /* avoid dangling else.  */
            if ((SymbolKey_GetSymKey (pSym->Module.WhereImported, Sym)) == SymbolKey_NulKey)
              {
                SymbolKey_PutSymKey (pSym->Module.WhereImported, Sym, M2LexBuf_GetTokenNo ());
              }
            SymbolKey_PutSymKey (pSym->Module.ImportTree, SymbolTable_GetSymName (Sym), Sym);
            SymbolTable_AddSymToModuleScope (ModSym, Sym);
          }
        else
          {
            /* avoid dangling else.  */
            n = SymbolTable_GetSymName (Sym);
            M2Error_WriteFormat1 ((const char *) "name clash when trying to import (%a)", 37, (const unsigned char *) &n, (sizeof (n)-1));
          }
        break;

      case SymbolTable_DefImpSym:
        if ((SymbolKey_GetSymKey (pSym->DefImp.ImportTree, SymbolTable_GetSymName (Sym))) == Sym)
          {
            /* avoid dangling else.  */
            if (M2Options_Pedantic)
              {
                n = SymbolTable_GetSymName (Sym);
                M2Error_WriteFormat1 ((const char *) "symbol (%a) has already been imported", 37, (const unsigned char *) &n, (sizeof (n)-1));
              }
          }
        else if ((SymbolKey_GetSymKey (pSym->DefImp.ImportTree, SymbolTable_GetSymName (Sym))) == SymbolKey_NulKey)
          {
            /* avoid dangling else.  */
            if ((SymbolKey_GetSymKey (pSym->DefImp.WhereImported, Sym)) == SymbolKey_NulKey)
              {
                SymbolKey_PutSymKey (pSym->DefImp.WhereImported, Sym, M2LexBuf_GetTokenNo ());
              }
            SymbolKey_PutSymKey (pSym->DefImp.ImportTree, SymbolTable_GetSymName (Sym), Sym);
            SymbolTable_AddSymToModuleScope (ModSym, Sym);
          }
        else
          {
            /* avoid dangling else.  */
            n = SymbolTable_GetSymName (Sym);
            M2Error_WriteFormat1 ((const char *) "name clash when trying to import (%a)", 37, (const unsigned char *) &n, (sizeof (n)-1));
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   PutIncluded - places a symbol, Sym, into the included list of the
                 current module.
                 Symbols that are placed in this list are indirectly declared
                 by:

                 IMPORT modulename ;

                 modulename.identifier
*/

extern "C" void SymbolTable_PutIncluded (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ModSym;
  NameKey_Name n1;
  NameKey_Name n2;

  /* 
      We have referenced Sym, via modulename.Sym
      now place it into the current module include list.
  */
  ModSym = SymbolTable_GetCurrentModuleScope ();
  M2Debug_Assert ((SymbolTable_IsDefImp (ModSym)) || (SymbolTable_IsModule (ModSym)));
  if (DebugUnknowns)
    {
      n1 = SymbolTable_GetSymName (Sym);
      n2 = SymbolTable_GetSymName (ModSym);
      M2Printf_printf2 ((const char *) "including %a into scope %a\\n", 28, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
    }
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        Lists_IncludeItemIntoList (pSym->Module.IncludeList, Sym);
        break;

      case SymbolTable_DefImpSym:
        Lists_IncludeItemIntoList (pSym->DefImp.IncludeList, Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module or DefImp symbol", 35);
        break;
    }
}


/*
   PutExported - places a symbol, Sym into the next level out module.
                 Sym is also placed in the ExportTree of the current inner
                 module.
*/

extern "C" void SymbolTable_PutExported (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  /* 
   WriteString('PutExported') ; WriteLn ;
  */
  SymbolTable_AddSymToModuleScope (GetLastModuleOrProcedureScope (), Sym);
  pSym = GetPsym (SymbolTable_GetCurrentModuleScope ());
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        SymbolKey_PutSymKey (pSym->Module.ExportTree, SymbolTable_GetSymName (Sym), Sym);
        if (SymbolTable_IsUnknown (Sym))
          {
            PutExportUndeclared (SymbolTable_GetCurrentModuleScope (), Sym);
          }
        /* 
                 ; WriteKey(Module.name) ; WriteString(' exports ') ;
                 ; WriteKey(GetSymName(Sym)) ; WriteLn ;
  */
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Module symbol", 25);
        break;
    }
}


/*
   PutExportQualified - places a symbol with the name, SymName,
                        into the export tree of the
                        Definition module being compiled.
                        The symbol with name has been EXPORT QUALIFIED
                        by the definition module and therefore any reference
                        to this symbol in the code generation phase
                        will be in the form _Module_Name.
*/

extern "C" void SymbolTable_PutExportQualified (unsigned int tokenno, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  NameKey_Name n;
  unsigned int Sym;
  unsigned int ModSym;

  ModSym = SymbolTable_GetCurrentModule ();
  M2Debug_Assert (SymbolTable_IsDefImp (ModSym));
  M2Debug_Assert ((M2Comp_CompilingDefinitionModule ()) || ((SymbolTable_GetSymName (ModSym)) == (NameKey_MakeKey ((const char *) "SYSTEM", 6))));
  /* 
   WriteString('1st MODULE ') ; WriteKey(GetSymName(ModSym)) ;
   WriteString(' identifier ') ; WriteKey(SymName) ; WriteLn ;
  */
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if (((SymbolKey_GetSymKey (pSym->DefImp.ExportQualifiedTree, SymName)) != SymbolKey_NulKey) && ((SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymName)) == SymbolKey_NulKey))
          {
            n = SymbolTable_GetSymName (ModSym);
            M2Error_WriteFormat2 ((const char *) "identifier (%a) has already been exported from MODULE %a", 56, (const unsigned char *) &SymName, (sizeof (SymName)-1), (const unsigned char *) &n, (sizeof (n)-1));
          }
        else if ((SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymName)) != SymbolKey_NulKey)
          {
            /* avoid dangling else.  */
            Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymName));
            SymbolKey_DelSymKey (pSym->DefImp.ExportRequest, SymName);
            SymbolKey_PutSymKey (pSym->DefImp.ExportQualifiedTree, SymName, Sym);
            PutExportUndeclared (ModSym, Sym);
          }
        else
          {
            /* avoid dangling else.  */
            Sym = SymbolTable_GetDeclareSym (tokenno, SymName);
            SymbolKey_PutSymKey (pSym->DefImp.ExportQualifiedTree, SymName, Sym);
            PutExportUndeclared (ModSym, Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   PutExportUnQualified - places a symbol with the name, SymName,
                          into the export tree of the
                          Definition module being compiled.
                          The symbol with Name has been EXPORT UNQUALIFIED
                          by the definition module and therefore any reference
                          to this symbol in the code generation phase
                          will be in the form _Name.
*/

extern "C" void SymbolTable_PutExportUnQualified (unsigned int tokenno, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  NameKey_Name n;
  unsigned int Sym;
  unsigned int ModSym;

  ModSym = SymbolTable_GetCurrentModule ();
  M2Debug_Assert (SymbolTable_IsDefImp (ModSym));
  M2Debug_Assert ((M2Comp_CompilingDefinitionModule ()) || ((SymbolTable_GetSymName (ModSym)) == (NameKey_MakeKey ((const char *) "SYSTEM", 6))));
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if (((SymbolKey_GetSymKey (pSym->DefImp.ExportUnQualifiedTree, SymName)) != SymbolKey_NulKey) && ((SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymName)) == SymbolKey_NulKey))
          {
            n = SymbolTable_GetSymName (ModSym);
            M2Error_WriteFormat2 ((const char *) "identifier (%a) has already been exported from MODULE %a", 56, (const unsigned char *) &SymName, (sizeof (SymName)-1), (const unsigned char *) &n, (sizeof (n)-1));
          }
        else if ((SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymName)) != SymbolKey_NulKey)
          {
            /* avoid dangling else.  */
            Sym = static_cast<unsigned int> (SymbolKey_GetSymKey (pSym->DefImp.ExportRequest, SymName));
            SymbolKey_DelSymKey (pSym->DefImp.ExportRequest, SymName);
            SymbolKey_PutSymKey (pSym->DefImp.ExportUnQualifiedTree, SymName, Sym);
            PutExportUndeclared (ModSym, Sym);
          }
        else
          {
            /* avoid dangling else.  */
            Sym = SymbolTable_GetDeclareSym (tokenno, SymName);
            SymbolKey_PutSymKey (pSym->DefImp.ExportUnQualifiedTree, SymName, Sym);
            PutExportUndeclared (ModSym, Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   PutExportUnImplemented - places a symbol, Sym, into the currently compiled
                            DefImp module NeedToBeImplemented list.
*/

extern "C" void SymbolTable_PutExportUnImplemented (unsigned int tokenno, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (CurrentModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if ((SymbolKey_GetSymKey (pSym->DefImp.NeedToBeImplemented, SymbolTable_GetSymName (Sym))) == Sym)
          {
            /* 
                    n1 := GetSymName (Sym) ;
                    n2 := GetSymName (CurrentModule) ;
                    WriteFormat2 ('symbol (%a) already exported from module (%a)', n1, n2)
  */
            M2MetaError_MetaErrorT2 (tokenno, (const char *) "symbol {%1a} is already exported from module {%2a}", 50, Sym, CurrentModule);
          }
        else
          {
            SymbolKey_PutSymKey (pSym->DefImp.NeedToBeImplemented, SymbolTable_GetSymName (Sym), Sym);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   GetExported - returns the symbol which has a name SymName,
                 and is exported from the definition module ModSym.

*/

extern "C" unsigned int SymbolTable_GetExported (unsigned int tokenno, unsigned int ModSym, NameKey_Name SymName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Sym = RequestFromDefinition (tokenno, ModSym, SymName);
        break;

      case SymbolTable_ModuleSym:
        Sym = RequestFromModule (tokenno, ModSym, SymName);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFromOuterModule - returns a symbol with name, SymName, which comes
                        from outside the current module.
*/

extern "C" unsigned int SymbolTable_GetFromOuterModule (unsigned int tokenno, NameKey_Name SymName)
{
  SymbolTable_PtrToCallFrame pCall;
  unsigned int ScopeId;
  unsigned int Sym;
  unsigned int ScopeSym;

  ScopeId = ScopePtr;
  pCall = GetPcall (ScopeId);
  while ((! (SymbolTable_IsModule (pCall->Search))) && (! (SymbolTable_IsDefImp (pCall->Search))))
    {
      M2Debug_Assert (ScopeId > 0);
      ScopeId -= 1;
      pCall = GetPcall (ScopeId);
    }
  ScopeId -= 1;
  /* we are now below the current module  */
  while (ScopeId > 0)
    {
      pCall = GetPcall (ScopeId);
      ScopeSym = pCall->Search;
      if (ScopeSym != SymbolTable_NulSym)
        {
          Sym = SymbolTable_GetLocalSym (ScopeSym, SymName);
          if (Sym == SymbolTable_NulSym)
            {
              /* avoid dangling else.  */
              if (((SymbolTable_IsModule (ScopeSym)) || (SymbolTable_IsProcedure (ScopeSym))) || (SymbolTable_IsDefImp (ScopeSym)))
                {
                  if (Sym == SymbolTable_NulSym)
                    {
                      Sym = ExamineUnresolvedTree (ScopeSym, SymName);
                      if (Sym != SymbolTable_NulSym)
                        {
                          return Sym;
                        }
                    }
                }
            }
          else
            {
              return Sym;
            }
        }
      ScopeId -= 1;
      pCall = GetPcall (ScopeId);
    }
  /* at this point we force an unknown from the last module scope  */
  return RequestFromModule (tokenno, SymbolTable_GetLastModuleScope (), SymName);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   TryMoveUndeclaredSymToInnerModule - attempts to move a symbol of
                                       name, name, which is
                                       currently undefined in the
                                       outer scope to the inner scope.
                                       If successful then the symbol is
                                       returned otherwise NulSym is
                                       returned.
*/

extern "C" unsigned int SymbolTable_TryMoveUndeclaredSymToInnerModule (unsigned int OuterScope, unsigned int InnerScope, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int sym;

  /* assume this should not be called if OuterScope was a procedure
      as this case is handled by the caller (P1SymBuild)
  */
  M2Debug_Assert ((SymbolTable_IsModule (OuterScope)) || (SymbolTable_IsDefImp (OuterScope)));
  sym = GetExportUndeclared (OuterScope, name);
  if (sym != SymbolTable_NulSym)
    {
      M2Debug_Assert (SymbolTable_IsUnknown (sym));
      RemoveExportUndeclared (OuterScope, sym);
      SymbolTable_AddSymToModuleScope (OuterScope, sym);
      AddVarToScopeList (OuterScope, sym);
      pSym = GetPsym (OuterScope);
      switch (pSym->SymbolType)
        {
          case SymbolTable_DefImpSym:
            if ((SymbolKey_GetSymKey (pSym->DefImp.Unresolved, name)) == sym)
              {
                SymbolKey_DelSymKey (pSym->DefImp.Unresolved, name);
              }
            break;

          case SymbolTable_ModuleSym:
            if ((SymbolKey_GetSymKey (pSym->Module.Unresolved, name)) == sym)
              {
                SymbolKey_DelSymKey (pSym->Module.Unresolved, name);
              }
            break;


          default:
            M2Error_InternalError ((const char *) "expecting DefImp, Module symbol", 31);
            break;
        }
      AddSymToUnknown (InnerScope, name, sym);
      PutExportUndeclared (InnerScope, sym);
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsExportQualified - returns true if a symbol, Sym, was defined as
                       being EXPORT QUALIFIED.
                       Sym is expected to be either a procedure or a
                       variable.
*/

extern "C" bool SymbolTable_IsExportQualified (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int OuterModule;

  OuterModule = Sym;
  do {
    OuterModule = SymbolTable_GetScope (OuterModule);
  } while (! ((SymbolTable_GetScope (OuterModule)) == SymbolTable_NulSym));
  pSym = GetPsym (OuterModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        return false;
        break;

      case SymbolTable_DefImpSym:
        return (SymbolKey_GetSymKey (pSym->DefImp.ExportQualifiedTree, SymbolTable_GetSymName (Sym))) == Sym;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsExportUnQualified - returns true if a symbol, Sym, was defined as
                         being EXPORT UNQUALIFIED.
*/

extern "C" bool SymbolTable_IsExportUnQualified (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int OuterModule;

  OuterModule = Sym;
  do {
    OuterModule = SymbolTable_GetScope (OuterModule);
  } while (! ((SymbolTable_GetScope (OuterModule)) == SymbolTable_NulSym));
  pSym = GetPsym (OuterModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        return false;
        break;

      case SymbolTable_DefImpSym:
        return (SymbolKey_GetSymKey (pSym->DefImp.ExportUnQualifiedTree, SymbolTable_GetSymName (Sym))) == Sym;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsExported - returns true if a symbol, Sym, is exported
                from module, ModSym.
                If ModSym is a DefImp symbol then its
                ExportQualified and ExportUnQualified lists are examined.
*/

extern "C" bool SymbolTable_IsExported (unsigned int ModSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  NameKey_Name SymName;

  SymName = SymbolTable_GetSymName (Sym);
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return ((SymbolKey_GetSymKey (pSym->DefImp.ExportQualifiedTree, SymName)) == Sym) || ((SymbolKey_GetSymKey (pSym->DefImp.ExportUnQualifiedTree, SymName)) == Sym);
        break;

      case SymbolTable_ModuleSym:
        return (SymbolKey_GetSymKey (pSym->Module.ExportTree, SymName)) == Sym;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsImplicityExported - returns TRUE if, Sym, is implicitly exported from module, ModSym.
                         ModSym must be a defimp symbol.
*/

extern "C" bool SymbolTable_IsImplicityExported (unsigned int ModSym, unsigned int Sym)
{
  unsigned int type;
  SymbolTable_PtrToSymbol pSym;

  if ((SymbolTable_IsDefImp (ModSym)) && (SymbolTable_IsFieldEnumeration (Sym)))
    {
      pSym = GetPsym (ModSym);
      type = SymbolTable_SkipType (SymbolTable_GetType (Sym));
      return Lists_IsItemInList (pSym->DefImp.EnumerationScopeList, type);
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsImported - returns true if a symbol, Sym, in module, ModSym,
                was imported.
*/

extern "C" bool SymbolTable_IsImported (unsigned int ModSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  NameKey_Name SymName;

  SymName = SymbolTable_GetSymName (Sym);
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return ((SymbolKey_GetSymKey (pSym->DefImp.ImportTree, SymName)) == Sym) || (Lists_IsItemInList (pSym->DefImp.IncludeList, Sym));
        break;

      case SymbolTable_ModuleSym:
        return ((SymbolKey_GetSymKey (pSym->Module.ImportTree, SymName)) == Sym) || (Lists_IsItemInList (pSym->Module.IncludeList, Sym));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutIncludedByDefinition - places a module symbol, Sym, into the
                             included list of the current definition module.
*/

extern "C" void SymbolTable_PutIncludedByDefinition (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ModSym;

  ModSym = SymbolTable_GetCurrentModuleScope ();
  M2Debug_Assert (SymbolTable_IsDefImp (ModSym));
  M2Debug_Assert (SymbolTable_IsDefImp (Sym));
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        Lists_IncludeItemIntoList (pSym->DefImp.DefIncludeList, Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   IsIncludedByDefinition - returns TRUE if definition module symbol, Sym, was included
                            by ModSym's definition module.
*/

extern "C" bool SymbolTable_IsIncludedByDefinition (unsigned int ModSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsDefImp (ModSym));
  M2Debug_Assert (SymbolTable_IsDefImp (Sym));
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return Lists_IsItemInList (pSym->DefImp.DefIncludeList, Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   ForeachImportedDo - calls a procedure, P, foreach imported symbol
                       in module, ModSym.
*/

extern "C" void SymbolTable_ForeachImportedDo (unsigned int ModSym, SymbolKey_PerformOperation P)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        SymbolKey_ForeachNodeDo (pSym->DefImp.ImportTree, P);
        Lists_ForeachItemInListDo (pSym->DefImp.IncludeList, P);
        break;

      case SymbolTable_ModuleSym:
        SymbolKey_ForeachNodeDo (pSym->Module.ImportTree, P);
        Lists_ForeachItemInListDo (pSym->Module.IncludeList, P);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
}


/*
   ForeachExportedDo - calls a procedure, P, foreach imported symbol
                       in module, ModSym.
*/

extern "C" void SymbolTable_ForeachExportedDo (unsigned int ModSym, SymbolKey_PerformOperation P)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        SymbolKey_ForeachNodeDo (pSym->DefImp.ExportQualifiedTree, P);
        SymbolKey_ForeachNodeDo (pSym->DefImp.ExportUnQualifiedTree, P);
        break;

      case SymbolTable_ModuleSym:
        SymbolKey_ForeachNodeDo (pSym->Module.ExportTree, P);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
}


/*
   CheckForExportedImplementation - checks to see whether an implementation
                                    module is currently being compiled, if so,
                                    symbol, Sym, is removed from the
                                    NeedToBeImplemented list.
                                    This procedure is called whenever a symbol
                                    is declared, thus attempting to reduce
                                    the NeedToBeImplemented list.
                                    Only needs to be called when a TYPE or
                                    PROCEDURE is built since the implementation
                                    module can only implement these objects
                                    declared in the definition module.

                                    It also checks whether a definition module
                                    is currently being compiled and, if so,
                                    it will ensure that symbol, Sym, is removed
                                    from the ExportRequest list. If Sym is an
                                    enumerated type it ensures that its fields
                                    are also removed.
*/

extern "C" void SymbolTable_CheckForExportedImplementation (unsigned int Sym)
{
  if (M2Comp_CompilingImplementationModule ())
    {
      RemoveExportUnImplemented (SymbolTable_GetCurrentModule (), Sym);
    }
  if ((M2Comp_CompilingDefinitionModule ()) && (SymbolTable_IsEnumeration (Sym)))
    {
      RemoveEnumerationFromExportRequest (SymbolTable_GetCurrentModule (), Sym);
    }
}


/*
   CheckForUnImplementedExports - displays an error and the offending symbols
                                  which have been exported but not implemented
                                  from the current compiled module.
*/

extern "C" void SymbolTable_CheckForUnImplementedExports (void)
{
  SymbolTable_PtrToSymbol pSym;

  /* WriteString('Inside CheckForImplementedExports') ; WriteLn ;  */
  pSym = GetPsym (CurrentModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        if (! (SymbolKey_IsEmptyTree (pSym->DefImp.NeedToBeImplemented)))
          {
            CurrentError = M2Error_NewError (M2LexBuf_GetTokenNo ());
            M2Error_ErrorFormat1 (CurrentError, (const char *) "unimplemented identifier(s) in EXPORT list of DEFINITION MODULE %a\\nthe implementation module fails to implement the following exported identifier(s)", 149, (const unsigned char *) &pSym->DefImp.name, (sizeof (pSym->DefImp.name)-1));
            SymbolKey_ForeachNodeDo (pSym->DefImp.NeedToBeImplemented, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) UnImplementedSymbolError});
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   CheckForUndeclaredExports - displays an error and the offending symbols
                               which have been exported but not declared
                               from module, ModSym.
*/

extern "C" void SymbolTable_CheckForUndeclaredExports (unsigned int ModSym)
{
  SymbolTable_PtrToSymbol pSym;

  /* WriteString('Inside CheckForUndeclaredExports') ; WriteLn ;  */
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        if (! (SymbolKey_IsEmptyTree (pSym->Module.ExportUndeclared)))
          {
            M2MetaError_MetaError1 ((const char *) "undeclared identifier(s) in EXPORT list of {%1ERd} {%1a}", 56, ModSym);
            SymbolKey_ForeachNodeDo (pSym->Module.ExportUndeclared, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) UndeclaredSymbolError});
          }
        break;

      case SymbolTable_DefImpSym:
        if (! (SymbolKey_IsEmptyTree (pSym->DefImp.ExportUndeclared)))
          {
            if (SymbolTable_DoesNotNeedExportList (ModSym))
              {
                M2MetaError_MetaError1 ((const char *) "undeclared identifier(s) in {%1ERd} {%1a}", 41, ModSym);
              }
            else
              {
                M2MetaError_MetaError1 ((const char *) "undeclared identifier(s) in export list of {%1ERd} {%1a}", 56, ModSym);
              }
            SymbolKey_ForeachNodeDo (pSym->DefImp.ExportUndeclared, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) UndeclaredSymbolError});
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
}


/*
   CheckForUnknownInModule - checks for any unknown symbols in the
                             current module.
                             If any unknown symbols are found then
                             an error message is displayed.
*/

extern "C" void SymbolTable_CheckForUnknownInModule (void)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (SymbolTable_GetCurrentModuleScope ());
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        CheckForUnknowns (pSym->DefImp.name, pSym->DefImp.ExportQualifiedTree, (const char *) "EXPORT QUALIFIED", 16);
        CheckForUnknowns (pSym->DefImp.name, pSym->DefImp.ExportUnQualifiedTree, (const char *) "EXPORT UNQUALIFIED", 18);
        CheckForSymbols (pSym->DefImp.ExportRequest, (const char *) "requested by another modules import (symbols have not been exported by the appropriate definition module)", 105);
        CheckForUnknowns (pSym->DefImp.name, pSym->DefImp.Unresolved, (const char *) "unresolved", 10);
        CheckForUnknowns (pSym->DefImp.name, pSym->DefImp.LocalSymbols, (const char *) "locally used", 12);
        break;

      case SymbolTable_ModuleSym:
        CheckForUnknowns (pSym->Module.name, pSym->Module.Unresolved, (const char *) "unresolved", 10);
        CheckForUnknowns (pSym->Module.name, pSym->Module.ExportUndeclared, (const char *) "exported but undeclared", 23);
        CheckForUnknowns (pSym->Module.name, pSym->Module.ExportTree, (const char *) "exported but undeclared", 23);
        CheckForUnknowns (pSym->Module.name, pSym->Module.LocalSymbols, (const char *) "locally used", 12);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
        break;
    }
}


/*
   UnknownReported - if sym is an unknown symbol and has not been reported
                     then include it into the set of reported unknowns.
*/

extern "C" void SymbolTable_UnknownReported (unsigned int sym)
{
  if (IsUnreportedUnknown (sym))
    {
      Sets_IncludeElementIntoSet (ReportedUnknowns, sym);
    }
}


/*
   IsReallyPointer - returns TRUE is sym is a pointer, address or a
                     type declared as a pointer or address.
*/

extern "C" bool SymbolTable_IsReallyPointer (unsigned int Sym)
{
  if (SymbolTable_IsVar (Sym))
    {
      Sym = SymbolTable_GetType (Sym);
    }
  Sym = SymbolTable_SkipType (Sym);
  return ((SymbolTable_IsPointer (Sym)) || (Sym == M2System_Address)) || (SymbolTable_IsHiddenReallyPointer (Sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CheckHiddenTypeAreAddress - checks to see that any hidden types
                               which we have declared are actually
                               of type ADDRESS or map onto a POINTER type.
*/

extern "C" void SymbolTable_CheckHiddenTypeAreAddress (void)
{
  NameKey_Name name;
  M2Error_Error e;
  unsigned int sym;
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Lists_NoOfItemsInList (AddressTypes);
  while (i <= n)
    {
      sym = static_cast<unsigned int> (Lists_GetItemFromList (AddressTypes, i));
      if (! (SymbolTable_IsHiddenReallyPointer (sym)))
        {
          name = SymbolTable_GetSymName (sym);
          e = M2Error_NewError (SymbolTable_GetDeclaredDef (sym));
          M2Error_ErrorFormat1 (e, (const char *) "opaque type (%a) should be equivalent to a POINTER or an ADDRESS", 64, (const unsigned char *) &name, (sizeof (name)-1));
          e = M2Error_NewError (SymbolTable_GetDeclaredMod (sym));
          M2Error_ErrorFormat0 (e, (const char *) "if you really need a non POINTER type use the -fextended-opaque switch", 70);
        }
      i += 1;
    }
}


/*
   PutDefinitionForC - sets a flag in the current compiled module which
                       indicates that this module is a wrapper for a C
                       file. Parameters passes to procedures in this module
                       will adopt the C calling convention.
*/

extern "C" void SymbolTable_PutDefinitionForC (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        pSym->DefImp.ForC = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   IsDefinitionForC - returns true if this definition module was declared
                      as a DEFINITION MODULE FOR "C".
*/

extern "C" bool SymbolTable_IsDefinitionForC (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return pSym->DefImp.ForC;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutDoesNeedExportList - sets a flag in module, Sym, which
                           indicates that this module requires an explicit
                           EXPORT QUALIFIED or UNQUALIFIED list. PIM-2
*/

extern "C" void SymbolTable_PutDoesNeedExportList (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        pSym->DefImp.NeedExportList = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   PutDoesNotNeedExportList - sets a flag in module, Sym, which
                              indicates that this module does not require an explicit
                              EXPORT QUALIFIED or UNQUALIFIED list. PIM-3|4
*/

extern "C" void SymbolTable_PutDoesNotNeedExportList (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        pSym->DefImp.NeedExportList = false;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   DoesNotNeedExportList - returns TRUE if module, Sym, does not require an explicit
                           EXPORT QUALIFIED list.
*/

extern "C" bool SymbolTable_DoesNotNeedExportList (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return ! pSym->DefImp.NeedExportList;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   CheckForEnumerationInCurrentModule - checks to see whether the enumeration
                                        type symbol, Sym, has been entered into
                                        the current modules scope list.
*/

extern "C" void SymbolTable_CheckForEnumerationInCurrentModule (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ModSym;

  if (((SymbolTable_SkipType (Sym)) != SymbolTable_NulSym) && (SymbolTable_IsEnumeration (SymbolTable_SkipType (Sym))))
    {
      Sym = SymbolTable_SkipType (Sym);
    }
  if (SymbolTable_IsEnumeration (Sym))
    {
      ModSym = SymbolTable_GetCurrentModuleScope ();
      pSym = GetPsym (ModSym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_DefImpSym:
            CheckEnumerationInList (pSym->DefImp.EnumerationScopeList, Sym);
            break;

          case SymbolTable_ModuleSym:
            CheckEnumerationInList (pSym->Module.EnumerationScopeList, Sym);
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
            break;
        }
    }
}


/*
   SanityCheckConstants - must only be called once all constants, types, procedures
                          have been declared.  It checks to see that constants are
                          not used as procedure parameter types.
*/

extern "C" void SymbolTable_SanityCheckConstants (void)
{
  SymbolTable_ForeachModuleDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SanityCheckModule});
  ForeachSymbolDo ((SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) SanityCheckArray});
}


/*
   ForeachLocalSymDo - foreach local symbol in module, Sym, or procedure, Sym,
                       perform the procedure, P.
*/

extern "C" void SymbolTable_ForeachLocalSymDo (unsigned int Sym, SymbolKey_PerformOperation P)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        SymbolKey_ForeachNodeDo (pSym->DefImp.LocalSymbols, P);
        break;

      case SymbolTable_ModuleSym:
        SymbolKey_ForeachNodeDo (pSym->Module.LocalSymbols, P);
        break;

      case SymbolTable_ProcedureSym:
        SymbolKey_ForeachNodeDo (pSym->Procedure.LocalSymbols, P);
        break;

      case SymbolTable_RecordSym:
        SymbolKey_ForeachNodeDo (pSym->Record.LocalSymbols, P);
        break;

      case SymbolTable_EnumerationSym:
        SymbolKey_ForeachNodeDo (pSym->Enumeration.LocalSymbols, P);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp, Module or Procedure symbol", 46);
        break;
    }
}


/*
   ForeachParamSymDo - foreach parameter symbol in procedure Sym
                       perform the procedure P.  Each symbol
                       looked up will be VarParam or Param
                       (not the shadow variable).  Every parameter
                       from each KindProcedure is iterated over.
*/

extern "C" void SymbolTable_ForeachParamSymDo (unsigned int Sym, SymbolKey_PerformOperation P)
{
  SymbolTable_ProcedureKind kind;
  unsigned int param;
  unsigned int p;
  unsigned int i;

  if (SymbolTable_IsProcedure (Sym))
    {
      for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
        {
          p = SymbolTable_NoOfParam (Sym, kind);
          i = p;
          while (i > 0)
            {
              param = SymbolTable_GetNthParam (Sym, kind, i);
              (*P.proc) (param);
              i -= 1;
            }
        }
    }
}


/*
   ForeachFieldEnumerationDo - for each field in enumeration, Sym,
                               do procedure, P.  Each call to P contains
                               an enumeration field, the order is alphabetical.
                               Use ForeachLocalSymDo for declaration order.
*/

extern "C" void SymbolTable_ForeachFieldEnumerationDo (unsigned int Sym, SymbolKey_PerformOperation P)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_EnumerationSym:
        SymbolKey_ForeachNodeDo (pSym->Enumeration.LocalSymbols, P);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Enumeration symbol", 28);
        break;
    }
}


/*
   IsType - returns true if the Sym is a type symbol.
*/

extern "C" bool SymbolTable_IsType (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_TypeSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsProcedure - returns true if Sym is a procedure symbol.
*/

extern "C" bool SymbolTable_IsProcedure (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_ProcedureSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsParameter - returns true if Sym is a parameter symbol.
*/

extern "C" bool SymbolTable_IsParameter (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
      case SymbolTable_VarParamSym:
        return true;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetProcedureKind - returns the procedure kind given the declaration tok.
                      The declaration tok must match the ident tok in the
                      procedure name.  It is only safe to call this
                      procedure function during pass 2 onwards.
*/

extern "C" SymbolTable_ProcedureKind SymbolTable_GetProcedureKind (unsigned int sym, unsigned int tok)
{
  SymbolTable_ProcedureKind kind;
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
          {
            if (pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ProcedureTok == tok)
              {
                return kind;
              }
          }
        break;

      case SymbolTable_ProcTypeSym:
        return SymbolTable_ProperProcedure;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ProcedureSym symbol", 29);
        break;
    }
  M2Error_InternalError ((const char *) "ProcedureSym kind has not yet been declared", 43);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetProcedureDeclaredTok - return the token where the
                             declaration of procedure sym:kind
                             occurred.
*/

extern "C" unsigned int SymbolTable_GetProcedureDeclaredTok (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ProcedureTok;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureDeclaredTok - places the tok where the
                             declaration of procedure sym:kind
                             occurred.
*/

extern "C" void SymbolTable_PutProcedureDeclaredTok (unsigned int sym, SymbolTable_ProcedureKind kind, unsigned int tok)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ProcedureTok = tok;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
}


/*
   GetReturnTypeTok - return the token where the
                               return type procedure sym:kind or proctype
                               was defined.
*/

extern "C" unsigned int SymbolTable_GetReturnTypeTok (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ReturnTypeTok;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.ReturnTypeTok;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutReturnTypeTok - places the tok where the
                      return type of procedure sym:kind or proctype
                      was defined.
*/

extern "C" void SymbolTable_PutReturnTypeTok (unsigned int sym, SymbolTable_ProcedureKind kind, unsigned int tok)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ReturnTypeTok = tok;
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.ReturnTypeTok = tok;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure symbol", 26);
        break;
    }
}


/*
   PutProcedureParametersDefined - the procedure symbol sym:kind
                                   parameters have been defined.
*/

extern "C" void SymbolTable_PutProcedureParametersDefined (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (sym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ParamDefined = true;
        pSym->Procedure.BuildProcType = false;
        break;

      case SymbolTable_ProcTypeSym:
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   GetProcedureParametersDefined - returns true if procedure symbol sym:kind
                                   parameters are defined.
*/

extern "C" bool SymbolTable_GetProcedureParametersDefined (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (sym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return false;
        break;

      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ParamDefined;
        break;

      case SymbolTable_ProcTypeSym:
        return true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureDefined - the procedure symbol sym:kind is defined.
*/

extern "C" void SymbolTable_PutProcedureDefined (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (sym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].Defined = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
}


/*
   GetProcedureDefined - returns true if procedure symbol sym:kind
                         is defined.
*/

extern "C" bool SymbolTable_GetProcedureDefined (unsigned int sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (sym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return false;
        break;

      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].Defined;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure symbol", 28);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutUseVarArgs - tell the symbol table that this procedure, Sym,
                   uses varargs.
                   The procedure _must_ be declared inside a
                   DEFINITION FOR "C"

*/

extern "C" void SymbolTable_PutUseVarArgs (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        /* Currently can only declare var args in a definition module.  */
        pSym->Procedure.Decl.array[SymbolTable_DefProcedure-SymbolTable_ProperProcedure].HasVarArgs = true;
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.HasVarArgs = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
}


/*
   UsesVarArgs - returns TRUE if procedure, Sym, uses varargs.
                 The procedure _must_ be declared inside a
                 DEFINITION FOR "C"
*/

extern "C" bool SymbolTable_UsesVarArgs (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return false;
        break;

      case SymbolTable_ProcedureSym:
        /* Currently can only declare var args in a definition module.  */
        return pSym->Procedure.Decl.array[SymbolTable_DefProcedure-SymbolTable_ProperProcedure].HasVarArgs;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.HasVarArgs;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutUseOptArg - tell the symbol table that this procedure, Sym,
                  uses an optarg.
*/

extern "C" void SymbolTable_PutUseOptArg (unsigned int Sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ProcedureSym:
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].HasOptArg = true;
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.HasOptArg = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
}


/*
   UsesOptArg - returns TRUE if procedure, Sym, uses varargs.
*/

extern "C" bool SymbolTable_UsesOptArg (unsigned int Sym, SymbolTable_ProcedureKind kind)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return false;
        break;

      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].HasOptArg;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.HasOptArg;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutOptArgInit - makes symbol, Sym, the initializer value to
                   procedure, ProcSym.
*/

extern "C" void SymbolTable_PutOptArgInit (unsigned int ProcSym, unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  if (! (SymbolTable_IsError (ProcSym)))
    {
      pSym = GetPsym (ProcSym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ErrorSym:
            break;

          case SymbolTable_ProcedureSym:
            pSym->Procedure.OptArgInit = Sym;
            break;

          case SymbolTable_ProcTypeSym:
            pSym->ProcType.OptArgInit = Sym;
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
            break;
        }
    }
}


/*
   GetOptArgInit - returns the initializer value to the optional parameter in
                   procedure, ProcSym.
*/

extern "C" unsigned int SymbolTable_GetOptArgInit (unsigned int ProcSym)
{
  SymbolTable_PtrToSymbol pSym;

  if (! (SymbolTable_IsError (ProcSym)))
    {
      pSym = GetPsym (ProcSym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ErrorSym:
            break;

          case SymbolTable_ProcedureSym:
            return pSym->Procedure.OptArgInit;
            break;

          case SymbolTable_ProcTypeSym:
            return pSym->ProcType.OptArgInit;
            break;


          default:
            M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
            break;
        }
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakePointer - returns a pointer symbol with PointerName.
*/

extern "C" unsigned int SymbolTable_MakePointer (unsigned int tok, NameKey_Name PointerName)
{
  unsigned int oaf;
  unsigned int sym;

  tok = CheckTok (tok, (const char *) "pointer", 7);
  sym = HandleHiddenOrDeclare (tok, PointerName, &oaf);
  FillInPointerFields (sym, PointerName, SymbolTable_GetCurrentScope (), oaf);
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutPointer - gives a pointer symbol a type, PointerType.
*/

extern "C" void SymbolTable_PutPointer (unsigned int Sym, unsigned int PointerType)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_PointerSym:
        pSym->Pointer.Type = PointerType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Pointer symbol", 26);
        break;
    }
}


/*
   IsPointer - returns true is Sym is a pointer type symbol.
*/

extern "C" bool SymbolTable_IsPointer (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_PointerSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRecord - returns true is Sym is a record type symbol.
*/

extern "C" bool SymbolTable_IsRecord (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_RecordSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVarient - returns true if the symbol, Sym, is a
               varient symbol.
*/

extern "C" bool SymbolTable_IsVarient (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_VarientSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsFieldVarient - returns true if the symbol, Sym, is a
                    varient field.
*/

extern "C" bool SymbolTable_IsFieldVarient (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_VarientFieldSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsFieldEnumeration - returns true if the symbol, Sym, is an
                        enumeration field.
*/

extern "C" bool SymbolTable_IsFieldEnumeration (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_EnumerationFieldSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsArray - returns true is Sym is an array type symbol.
*/

extern "C" bool SymbolTable_IsArray (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_ArraySym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsEnumeration - returns true if Sym is an enumeration symbol.
*/

extern "C" bool SymbolTable_IsEnumeration (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_EnumerationSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSet - returns TRUE if Sym is a set symbol.
*/

extern "C" bool SymbolTable_IsSet (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_SetSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsHiddenType - returns TRUE if, Sym, is a Type and is also declared as a hidden type.
*/

extern "C" bool SymbolTable_IsHiddenType (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_TypeSym:
        return pSym->Type.IsHidden;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsOAFamily - returns TRUE if, Sym, is an OAFamily symbol.
*/

extern "C" bool SymbolTable_IsOAFamily (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_OAFamilySym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDimension - return the number of dimensions associated with
                  this unbounded ARRAY parameter.
*/

extern "C" unsigned int SymbolTable_GetDimension (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_PartialUnboundedSym:
        return pSym->PartialUnbounded.NDim;
        break;

      case SymbolTable_UnboundedSym:
        return pSym->Unbounded.Dimensions;
        break;

      case SymbolTable_OAFamilySym:
        return pSym->OAFamily.MaxDimensions;
        break;

      case SymbolTable_ParamSym:
        if (pSym->Param.IsUnbounded)
          {
            return SymbolTable_GetDimension (SymbolTable_GetType (sym));
          }
        else
          {
            M2Error_InternalError ((const char *) "expecting unbounded paramater", 29);
          }
        break;

      case SymbolTable_VarParamSym:
        if (pSym->VarParam.IsUnbounded)
          {
            return SymbolTable_GetDimension (SymbolTable_GetType (sym));
          }
        else
          {
            M2Error_InternalError ((const char *) "expecting unbounded paramater", 29);
          }
        break;

      case SymbolTable_ArraySym:
        return GetArrayDimension (sym);
        break;

      case SymbolTable_TypeSym:
        return SymbolTable_GetDimension (SymbolTable_GetType (sym));
        break;

      case SymbolTable_VarSym:
        return SymbolTable_GetDimension (SymbolTable_GetType (sym));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting PartialUnbounded", 26);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   MakeOAFamily - makes an OAFamily symbol based on SimpleType.
                  It returns the OAFamily symbol.  A new symbol
                  is created if one does not already exist for
                  SimpleType.
*/

extern "C" unsigned int SymbolTable_MakeOAFamily (unsigned int SimpleType)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int sym;

  sym = SymbolTable_GetOAFamily (SimpleType);
  if (sym == SymbolTable_NulSym)
    {
      NewSym (&sym);
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_OAFamilySym;
      pSym->OAFamily.MaxDimensions = 0;
      pSym->OAFamily.SimpleType = SimpleType;
      pSym->OAFamily.Dimensions = Indexing_InitIndex (1);
      PutOAFamily (SimpleType, sym);
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetOAFamily - returns the oafamily symbol associated with
                 SimpleType.
*/

extern "C" unsigned int SymbolTable_GetOAFamily (unsigned int SimpleType)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (SimpleType);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return SymbolTable_NulSym;
        break;

      case SymbolTable_RecordSym:
        return pSym->Record.oafamily;
        break;

      case SymbolTable_SubrangeSym:
        return pSym->Subrange.oafamily;
        break;

      case SymbolTable_EnumerationSym:
        return pSym->Enumeration.oafamily;
        break;

      case SymbolTable_ArraySym:
        return pSym->Array.oafamily;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.oafamily;
        break;

      case SymbolTable_TypeSym:
        return pSym->Type.oafamily;
        break;

      case SymbolTable_PointerSym:
        return pSym->Pointer.oafamily;
        break;

      case SymbolTable_SetSym:
        return pSym->Set.oafamily;
        break;

      case SymbolTable_UndefinedSym:
        return pSym->Undefined.oafamily;
        break;


      default:
        return SymbolTable_NulSym;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ForeachOAFamily - call, p[oaf, ndim, symbol] for every unbounded symbol,
                     sym, in the oaf.
*/

extern "C" void SymbolTable_ForeachOAFamily (unsigned int sym, SymbolTable_FamilyOperation p)
{
  typedef unsigned int *ForeachOAFamily__T1;

  SymbolTable_PtrToSymbol pSym;
  unsigned int h;
  unsigned int i;
  ForeachOAFamily__T1 pc;

  if (sym != SymbolTable_NulSym)
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_OAFamilySym:
            h = Indexing_HighIndice (pSym->OAFamily.Dimensions);
            i = 1;
            while (i <= h)
              {
                pc = static_cast<ForeachOAFamily__T1> (Indexing_GetIndice (pSym->OAFamily.Dimensions, i));
                if (pc != NULL)
                  {
                    (*p.proc) (sym, i, (*pc));
                  }
                i += 1;
              }
            break;


          default:
            M2Error_InternalError ((const char *) "expecting OAFamily symbol", 25);
            break;
        }
    }
}


/*
   IsUnbounded - returns true if Sym is an unbounded symbol.
*/

extern "C" bool SymbolTable_IsUnbounded (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_UnboundedSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetUnbounded - returns the unbounded symbol associated with
                  the OAFamily symbol, oaf, and the number of
                  dimensions, ndim, of the open array.
*/

extern "C" unsigned int SymbolTable_GetUnbounded (unsigned int oaf, unsigned int ndim)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (oaf);
  switch (pSym->SymbolType)
    {
      case SymbolTable_OAFamilySym:
        if (ndim > pSym->OAFamily.MaxDimensions)
          {
            return SymbolTable_NulSym;
          }
        else
          {
            return GetFromIndex (pSym->OAFamily.Dimensions, ndim);
          }
        break;


      default:
        M2Error_InternalError ((const char *) "expecting OAFamily symbol", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetUnboundedRecordType - returns the record type used to
                            implement the unbounded array.
*/

extern "C" unsigned int SymbolTable_GetUnboundedRecordType (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_UnboundedSym:
        return pSym->Unbounded.RecordType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting an UnBounded symbol", 29);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetUnboundedAddressOffset - returns the offset of the address field
                               inside the record used to implement the
                               unbounded type.
*/

extern "C" unsigned int SymbolTable_GetUnboundedAddressOffset (unsigned int sym)
{
  unsigned int field;
  unsigned int rec;

  rec = SymbolTable_GetUnboundedRecordType (sym);
  if (rec == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "expecting record type to be declared", 36);
    }
  else
    {
      field = SymbolTable_GetLocalSym (rec, NameKey_MakeKey ((const char *) "_m2_contents", 12));
      if (field == SymbolTable_NulSym)
        {
          M2Error_InternalError ((const char *) "expecting address field to be present inside unbounded record", 61);
        }
      else
        {
          return field;
        }
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetUnboundedHighOffset - returns the offset of the high field
                            inside the record used to implement the
                            unbounded type.
*/

extern "C" unsigned int SymbolTable_GetUnboundedHighOffset (unsigned int sym, unsigned int ndim)
{
  unsigned int rec;

  rec = SymbolTable_GetUnboundedRecordType (sym);
  if (rec == SymbolTable_NulSym)
    {
      M2Error_InternalError ((const char *) "expecting record type to be declared", 36);
    }
  else
    {
      return SymbolTable_GetLocalSym (rec, NameKey_makekey (DynamicStrings_string (DynamicStrings_Mark (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "_m2_high_%d", 11)), (const unsigned char *) &ndim, (sizeof (ndim)-1))))));
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   MakeSubscript - makes a subscript Symbol.
                   No name is required.
*/

extern "C" unsigned int SymbolTable_MakeSubscript (void)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_SubscriptSym;
  pSym->Subscript.Type = SymbolTable_NulSym;  /* Index to a subrange symbol.  */
  pSym->Subscript.Size = M2ALU_InitValue ();  /* Size of this indice in*Size  */
  pSym->Subscript.Offset = M2ALU_InitValue ();  /* Offset at runtime of symbol  */
  InitWhereDeclared (&pSym->Subscript.At);  /* Declared here  */
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutSubscript - gives a subscript symbol a type, SimpleType.
*/

extern "C" void SymbolTable_PutSubscript (unsigned int Sym, unsigned int SimpleType)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_SubscriptSym:
        pSym->Subscript.Type = SimpleType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a SubScript symbol", 28);
        break;
    }
}


/*
   MakeUnbounded - makes an unbounded array Symbol.
                   ndim is the number of dimensions required.
                   No name is required.
*/

extern "C" unsigned int SymbolTable_MakeUnbounded (unsigned int tok, unsigned int SimpleType, unsigned int ndim)
{
  unsigned int sym;
  unsigned int oaf;

  tok = CheckTok (tok, (const char *) "unbounded", 9);
  oaf = SymbolTable_MakeOAFamily (SimpleType);
  sym = SymbolTable_GetUnbounded (oaf, ndim);
  if (sym == SymbolTable_NulSym)
    {
      NewSym (&sym);
      if (SymbolTable_IsUnknown (SimpleType))
        {
          PutPartialUnbounded (sym, SimpleType, ndim);
        }
      else
        {
          FillInUnboundedFields (tok, sym, SimpleType, ndim);
        }
      PutUnbounded (oaf, sym, ndim);
    }
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NoOfElements - Returns the number of elements in array Sym,
                  or the number of elements in an enumeration Sym or
                  the number of interface symbols in an Interface list.
*/

extern "C" unsigned int SymbolTable_NoOfElements (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int n;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        n = 0;
        break;

      case SymbolTable_EnumerationSym:
        /* 
      ArraySym      ,
      UnboundedSym  : n := 1 |    Standard language limitation 
  */
        n = pSym->Enumeration.NoOfElements;
        break;

      case SymbolTable_InterfaceSym:
        n = Indexing_HighIndice (pSym->Interface.Parameters);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting an Array or UnBounded symbol", 38);
        break;
    }
  return n;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutArray - places a type symbol into an arraysym.
*/

extern "C" void SymbolTable_PutArray (unsigned int arraysym, unsigned int typesym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (arraysym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        break;

      case SymbolTable_ArraySym:
        pSym->Array.Type = typesym;  /* The ARRAY OF typesym.  */
        break;


      default:
        M2Error_InternalError ((const char *) "expecting an Array symbol", 25);
        break;
    }
}


/*
   ResolveImports - it examines the import list of all inner modules
                    and resolves all relative imports.
*/

extern "C" void SymbolTable_ResolveImports (void)
{
  unsigned int scope;

  scope = SymbolTable_GetCurrentScope ();
  if (DebugUnknowns)
    {
      SymbolTable_DisplayTrees (scope);
    }
  SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) ResolveRelativeImport});
  SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) ResolveRelativeImport});
}


/*
   ResolveConstructorTypes - to be called at the end of pass three.  Its
                             purpose is to fix up all constructors whose
                             types are unknown.
*/

extern "C" void SymbolTable_ResolveConstructorTypes (void)
{
  bool finished;
  unsigned int i;
  unsigned int n;
  unsigned int s;

  do {
    n = Lists_NoOfItemsInList (UnresolvedConstructorType);
    finished = true;
    i = 1;
    while (i <= n)
      {
        s = static_cast<unsigned int> (Lists_GetItemFromList (UnresolvedConstructorType, i));
        M2Debug_Assert (SymbolTable_IsConstructor (s));
        if (CanResolveConstructor (s))
          {
            finished = false;
            Lists_RemoveItemFromList (UnresolvedConstructorType, s);
            i = n;
          }
        i += 1;
      }
  } while (! (finished));
  CheckAllConstructorsResolved ();
}


/*
   AddNameToScope - adds a Name, n, to the list of objects declared at the
                    current scope.
*/

extern "C" void SymbolTable_AddNameToScope (NameKey_Name n)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int scope;

  scope = SymbolTable_GetCurrentScope ();
  pSym = GetPsym (scope);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        AddNameTo (pSym->Procedure.NamedObjects, MakeObject (n));
        break;

      case SymbolTable_ModuleSym:
        AddNameTo (pSym->Module.NamedObjects, MakeObject (n));
        break;

      case SymbolTable_DefImpSym:
        AddNameTo (pSym->DefImp.NamedObjects, MakeObject (n));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting - DefImp", 18);
        break;
    }
}


/*
   AddNameToImportList - adds a Name, n, to the import list of the current
                         module.
*/

extern "C" void SymbolTable_AddNameToImportList (NameKey_Name n)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int scope;

  scope = SymbolTable_GetCurrentScope ();
  pSym = GetPsym (scope);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ModuleSym:
        AddNameTo (pSym->Module.NamedImports, MakeObject (n));
        break;

      case SymbolTable_DefImpSym:
        AddNameTo (pSym->DefImp.NamedImports, MakeObject (n));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting - DefImp or Module symbol", 35);
        break;
    }
}


/*
   GetScope - returns the declaration scope of the symbol.
*/

extern "C" unsigned int SymbolTable_GetScope (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return pSym->Error.Scope;
        break;

      case SymbolTable_DefImpSym:
        return SymbolTable_NulSym;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.Scope;
        break;

      case SymbolTable_VarSym:
        return pSym->Var.Scope;
        break;

      case SymbolTable_ProcedureSym:
        return pSym->Procedure.Scope;
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.Scope;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.Scope;
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.Scope;
        break;

      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.Scope;
        break;

      case SymbolTable_EnumerationSym:
        return pSym->Enumeration.Scope;
        break;

      case SymbolTable_EnumerationFieldSym:
        return pSym->EnumerationField.Scope;
        break;

      case SymbolTable_SubrangeSym:
        return pSym->Subrange.Scope;
        break;

      case SymbolTable_ArraySym:
        return pSym->Array.Scope;
        break;

      case SymbolTable_TypeSym:
        return pSym->Type.Scope;
        break;

      case SymbolTable_PointerSym:
        return pSym->Pointer.Scope;
        break;

      case SymbolTable_RecordSym:
        return pSym->Record.Scope;
        break;

      case SymbolTable_SetSym:
        return pSym->Set.Scope;
        break;

      case SymbolTable_UnboundedSym:
        return pSym->Unbounded.Scope;
        break;

      case SymbolTable_ConstLitSym:
        return pSym->ConstLit.Scope;
        break;

      case SymbolTable_ConstStringSym:
        return pSym->ConstString.Scope;
        break;

      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.Scope;
        break;

      case SymbolTable_ParamSym:
        return pSym->Param.Scope;
        break;

      case SymbolTable_VarParamSym:
        return pSym->VarParam.Scope;
        break;

      case SymbolTable_UndefinedSym:
        return SymbolTable_NulSym;
        break;

      case SymbolTable_PartialUnboundedSym:
        M2Error_InternalError ((const char *) "should not be requesting the scope of a PartialUnbounded symbol", 63);
        break;


      default:
        M2Error_InternalError ((const char *) "not implemented yet", 19);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetModuleScope - returns the module scope of symbol, sym.
                    If sym was declared within a nested procedure
                    then return the module which defines the
                    procedure.
*/

extern "C" unsigned int SymbolTable_GetModuleScope (unsigned int sym)
{
  unsigned int mod;

  mod = SymbolTable_GetScope (sym);
  while (((mod != SymbolTable_NulSym) && (! (SymbolTable_IsDefImp (mod)))) && (! (SymbolTable_IsModule (mod))))
    {
      mod = SymbolTable_GetScope (mod);
    }
  return mod;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetProcedureScope - returns the innermost procedure (if any)
                       in which the symbol, sym, resides.
                       A module inside the procedure is skipped
                       over.
*/

extern "C" unsigned int SymbolTable_GetProcedureScope (unsigned int sym)
{
  while ((sym != SymbolTable_NulSym) && (! (SymbolTable_IsProcedure (sym))))
    {
      sym = SymbolTable_GetScope (sym);
    }
  if ((sym != SymbolTable_NulSym) && (SymbolTable_IsProcedure (sym)))
    {
      return sym;
    }
  else
    {
      return SymbolTable_NulSym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsModuleWithinProcedure - returns TRUE if module, sym, is
                             inside a procedure.
*/

extern "C" bool SymbolTable_IsModuleWithinProcedure (unsigned int sym)
{
  return (SymbolTable_GetProcedureScope (sym)) != SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetParent - returns the parent of symbol, Sym.
*/

extern "C" unsigned int SymbolTable_GetParent (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        M2Error_ErrorAbort0 ((const char *) "", 0);
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.Parent;
        break;

      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.Parent;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.Parent;
        break;

      case SymbolTable_EnumerationFieldSym:
        return pSym->EnumerationField.Type;
        break;


      default:
        M2Error_InternalError ((const char *) "not implemented yet", 19);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsRecordField - returns true if Sym is a record field.
*/

extern "C" bool SymbolTable_IsRecordField (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_RecordFieldSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeProcType - returns a procedure type symbol with ProcTypeName.
*/

extern "C" unsigned int SymbolTable_MakeProcType (unsigned int tok, NameKey_Name ProcTypeName)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int oaf;
  unsigned int sym;

  tok = CheckTok (tok, (const char *) "proctype", 8);
  sym = HandleHiddenOrDeclare (tok, ProcTypeName, &oaf);
  if (! (SymbolTable_IsError (sym)))
    {
      pSym = GetPsym (sym);
      pSym->SymbolType = SymbolTable_ProcTypeSym;
      switch (pSym->SymbolType)
        {
          case SymbolTable_ProcTypeSym:
            pSym->ProcType.ReturnType = SymbolTable_NulSym;
            pSym->ProcType.name = ProcTypeName;
            Lists_InitList (&pSym->ProcType.ListOfParam);
            pSym->ProcType.HasVarArgs = false;  /* Does this proc type use ... ?  */
            pSym->ProcType.HasOptArg = false;  /* Does this proc type use [ ] ?  */
            pSym->ProcType.OptArgInit = SymbolTable_NulSym;  /* The optarg initial value.  */
            pSym->ProcType.ReturnOptional = false;  /* Is the return value optional?  */
            pSym->ProcType.ReturnTypeTok = M2LexBuf_UnknownTokenNo;  /* Is the return value optional?  */
            pSym->ProcType.Scope = SymbolTable_GetCurrentScope ();
            /* scope of procedure.  */
            pSym->ProcType.Size = M2ALU_InitValue ();
            pSym->ProcType.TotalParamSize = M2ALU_InitValue ();  /* size of all parameters  */
            pSym->ProcType.oafamily = oaf;  /* The oa family for this symbol  */
            InitWhereDeclaredTok (tok, &pSym->ProcType.At);  /* Declared here  */
            break;


          default:
            M2Error_InternalError ((const char *) "expecting ProcType symbol", 25);
            break;
        }
    }
  SymbolTable_ForeachOAFamily (oaf, (SymbolTable_FamilyOperation) {(SymbolTable_FamilyOperation_t) doFillInOAFamily});
  return sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutProcTypeParam - Places a Non VAR parameter ParamName with type
                      ParamType into ProcType Sym.
*/

extern "C" void SymbolTable_PutProcTypeParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ParSym;

  NewSym (&ParSym);
  pSym = GetPsym (ParSym);
  pSym->SymbolType = SymbolTable_ParamSym;
  pSym->Param.name = NameKey_NulName;
  pSym->Param.Type = ParamType;
  pSym->Param.IsUnbounded = isUnbounded;
  pSym->Param.ShadowVar = SymbolTable_NulSym;
  pSym->Param.FullTok = tok;
  pSym->Param.At = tok;
  AddParameter (Sym, SymbolTable_ProperProcedure, ParSym);
}


/*
   PutProcTypeVarParam - Places a Non VAR parameter ParamName with type
                         ParamType into ProcType Sym.
*/

extern "C" void SymbolTable_PutProcTypeVarParam (unsigned int tok, unsigned int Sym, unsigned int ParamType, bool isUnbounded)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int ParSym;

  NewSym (&ParSym);
  pSym = GetPsym (ParSym);
  pSym->SymbolType = SymbolTable_VarParamSym;
  pSym->Param.name = NameKey_NulName;
  pSym->Param.Type = ParamType;
  pSym->Param.IsUnbounded = isUnbounded;
  pSym->Param.ShadowVar = SymbolTable_NulSym;
  pSym->Param.FullTok = tok;
  pSym->Param.At = tok;
  AddParameter (Sym, SymbolTable_ProperProcedure, ParSym);
}


/*
   IsProcType - returns true if Sym is a ProcType Symbol.
*/

extern "C" bool SymbolTable_IsProcType (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_ProcTypeSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVar - returns true if Sym is a Var Symbol.
*/

extern "C" bool SymbolTable_IsVar (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_VarSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVarConst - returns the IsConst field indicating the variable is read only.
*/

extern "C" bool SymbolTable_IsVarConst (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.IsConst;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym", 16);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsConst - returns true if Sym contains a constant value.
*/

extern "C" bool SymbolTable_IsConst (unsigned int Sym)
{
  if (SymbolTable_IsConstructor (Sym))
    {
      return SymbolTable_IsConstructorConstant (Sym);
    }
  else
    {
      return DoIsConst (Sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstString - returns whether sym is a conststring of any variant.
*/

extern "C" bool SymbolTable_IsConstString (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  return pSym->SymbolType == SymbolTable_ConstStringSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstStringNulTerminated - returns TRUE if the constant string, sym,
                                should be created with a nul terminator.
*/

extern "C" bool SymbolTable_IsConstStringNulTerminated (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstStringSym:
        return (pSym->ConstString.StringVariant == SymbolTable_m2nulstr) || (pSym->ConstString.StringVariant == SymbolTable_cnulstr);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstStringSym", 24);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsConstLit - returns true if Sym is a literal constant.
*/

extern "C" bool SymbolTable_IsConstLit (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_ConstLitSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsConstructor - returns TRUE if the constant is declared as a
                   constant set, array or record.
*/

extern "C" bool SymbolTable_IsConstructor (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.IsConstructor;
        break;

      case SymbolTable_ConstLitSym:
        return pSym->ConstLit.IsConstructor;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsDummy - returns true if Sym is a Dummy symbol.
*/

extern "C" bool SymbolTable_IsDummy (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_DummySym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsTemporary - returns true if Sym is a Temporary symbol.
*/

extern "C" bool SymbolTable_IsTemporary (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.IsTemp;
        break;

      case SymbolTable_ConstVarSym:
        return pSym->ConstVar.IsTemp;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsVarAParam - returns true if Sym is a variable declared as a parameter.
*/

extern "C" bool SymbolTable_IsVarAParam (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.IsParam;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSubscript - returns true if Sym is a subscript symbol.
*/

extern "C" bool SymbolTable_IsSubscript (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_SubscriptSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSubrange - returns true if Sym is a subrange symbol.
*/

extern "C" bool SymbolTable_IsSubrange (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_SubrangeSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsProcedureVariable - returns true if a Sym is a variable and
                         it was declared within a procedure.
*/

extern "C" bool SymbolTable_IsProcedureVariable (unsigned int Sym)
{
  AssertInRange (Sym);
  return (SymbolTable_IsVar (Sym)) && (SymbolTable_IsProcedure (SymbolTable_GetVarScope (Sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsProcedureNested - returns TRUE if procedure, Sym, was
                       declared as a nested procedure.
*/

extern "C" bool SymbolTable_IsProcedureNested (unsigned int Sym)
{
  return (SymbolTable_IsProcedure (Sym)) && (SymbolTable_IsProcedure (SymbolTable_GetScope (Sym)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsAModula2Type - returns true if Sym, is a:
                    IsType, IsPointer, IsRecord, IsEnumeration,
                    IsSubrange, IsArray, IsUnbounded, IsProcType.
                    NOTE that it different from IsType.
*/

extern "C" bool SymbolTable_IsAModula2Type (unsigned int Sym)
{
  AssertInRange (Sym);
  return ((((((((SymbolTable_IsType (Sym)) || (SymbolTable_IsRecord (Sym))) || (SymbolTable_IsPointer (Sym))) || (SymbolTable_IsEnumeration (Sym))) || (SymbolTable_IsSubrange (Sym))) || (SymbolTable_IsArray (Sym))) || (SymbolTable_IsUnbounded (Sym))) || (SymbolTable_IsProcType (Sym))) || (SymbolTable_IsSet (Sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsGnuAsmVolatile - returns TRUE if a GnuAsm symbol was defined as VOLATILE.
*/

extern "C" bool SymbolTable_IsGnuAsmVolatile (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        return pSym->GnuAsm.Volatile;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting GnuAsm symbol", 23);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsGnuAsmSimple - returns TRUE if a GnuAsm symbol is a simple kind.
*/

extern "C" bool SymbolTable_IsGnuAsmSimple (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_GnuAsmSym:
        return pSym->GnuAsm.Simple;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting GnuAsm symbol", 23);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsGnuAsm - returns TRUE if Sym is a GnuAsm symbol.
*/

extern "C" bool SymbolTable_IsGnuAsm (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_GnuAsmSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsRegInterface - returns TRUE if Sym is a RegInterface symbol.
*/

extern "C" bool SymbolTable_IsRegInterface (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_InterfaceSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSizeSolved - returns true if the size of Sym is solved.
*/

extern "C" bool SymbolTable_IsSizeSolved (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return M2ALU_IsSolved (pSym->Procedure.Size);
        break;

      case SymbolTable_VarSym:
        return M2ALU_IsSolved (pSym->Var.Size);
        break;

      case SymbolTable_TypeSym:
        return M2ALU_IsSolved (pSym->Type.Size);
        break;

      case SymbolTable_SetSym:
        return M2ALU_IsSolved (pSym->Set.Size);
        break;

      case SymbolTable_RecordSym:
        return M2ALU_IsSolved (pSym->Record.Size);
        break;

      case SymbolTable_VarientSym:
        return M2ALU_IsSolved (pSym->Varient.Size);
        break;

      case SymbolTable_EnumerationSym:
        return M2ALU_IsSolved (pSym->Enumeration.Size);
        break;

      case SymbolTable_PointerSym:
        return M2ALU_IsSolved (pSym->Pointer.Size);
        break;

      case SymbolTable_ArraySym:
        return M2ALU_IsSolved (pSym->Array.Size);
        break;

      case SymbolTable_RecordFieldSym:
        return M2ALU_IsSolved (pSym->RecordField.Size);
        break;

      case SymbolTable_VarientFieldSym:
        return M2ALU_IsSolved (pSym->VarientField.Size);
        break;

      case SymbolTable_SubrangeSym:
        return M2ALU_IsSolved (pSym->Subrange.Size);
        break;

      case SymbolTable_SubscriptSym:
        return M2ALU_IsSolved (pSym->Subscript.Size);
        break;

      case SymbolTable_ProcTypeSym:
        return M2ALU_IsSolved (pSym->ProcType.Size);
        break;

      case SymbolTable_UnboundedSym:
        return M2ALU_IsSolved (pSym->Unbounded.Size);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this kind of symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsOffsetSolved - returns true if the Offset of Sym is solved.
*/

extern "C" bool SymbolTable_IsOffsetSolved (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return M2ALU_IsSolved (pSym->Var.Offset);
        break;

      case SymbolTable_RecordFieldSym:
        return M2ALU_IsSolved (pSym->RecordField.Offset);
        break;

      case SymbolTable_VarientFieldSym:
        return M2ALU_IsSolved (pSym->VarientField.Offset);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this kind of symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsValueSolved - returns true if the value of Sym is solved.
*/

extern "C" bool SymbolTable_IsValueSolved (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstLitSym:
        return M2ALU_IsSolved (pSym->ConstLit.Value);
        break;

      case SymbolTable_ConstVarSym:
        return M2ALU_IsSolved (pSym->ConstVar.Value);
        break;

      case SymbolTable_EnumerationFieldSym:
        return M2ALU_IsSolved (pSym->EnumerationField.Value);
        break;

      case SymbolTable_ConstStringSym:
        return true;
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this kind of symbol", 33);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsConstructorConstant - returns TRUE if constructor, Sym, is
                           defined by only constants.
*/

extern "C" bool SymbolTable_IsConstructorConstant (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  if ((SymbolTable_IsConstructor (Sym)) || (SymbolTable_IsConstSet (Sym)))
    {
      pSym = GetPsym (Sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_ConstVarSym:
            return M2ALU_IsValueConst (pSym->ConstVar.Value);
            break;

          case SymbolTable_ConstLitSym:
            return M2ALU_IsValueConst (pSym->ConstLit.Value);
            break;


          default:
            M2Error_InternalError ((const char *) "expecting Constructor", 21);
            break;
        }
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting Constructor", 21);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsComposite - returns TRUE if symbol, sym, is a composite
                 type:  ie an ARRAY or RECORD.
*/

extern "C" bool SymbolTable_IsComposite (unsigned int sym)
{
  if (sym == SymbolTable_NulSym)
    {
      return false;
    }
  else
    {
      sym = SymbolTable_SkipType (sym);
      return (SymbolTable_IsArray (sym)) || (SymbolTable_IsRecord (sym));
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsSumOfParamSizeSolved - has the sum of parameters been solved yet?
*/

extern "C" bool SymbolTable_IsSumOfParamSizeSolved (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return M2ALU_IsSolved (pSym->Procedure.TotalParamSize);
        break;

      case SymbolTable_ProcTypeSym:
        return M2ALU_IsSolved (pSym->ProcType.TotalParamSize);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Procedure or ProcType symbol", 38);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutAlignment - assigns the alignment constant associated with,
                  type, with, align.
*/

extern "C" void SymbolTable_PutAlignment (unsigned int type, unsigned int align)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (type);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        pSym->Record.Align = align;
        break;

      case SymbolTable_RecordFieldSym:
        pSym->RecordField.Align = align;
        break;

      case SymbolTable_TypeSym:
        pSym->Type.Align = align;
        break;

      case SymbolTable_ArraySym:
        pSym->Array.Align = align;
        break;

      case SymbolTable_PointerSym:
        pSym->Pointer.Align = align;
        break;

      case SymbolTable_SubrangeSym:
        pSym->Subrange.Align = align;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting record, field, pointer, type, subrange or an array symbol", 67);
        break;
    }
}


/*
   GetAlignment - returns the alignment constant associated with,
                  type.
*/

extern "C" unsigned int SymbolTable_GetAlignment (unsigned int type)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (type);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        return pSym->Record.Align;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.Align;
        break;

      case SymbolTable_TypeSym:
        return pSym->Type.Align;
        break;

      case SymbolTable_ArraySym:
        return pSym->Array.Align;
        break;

      case SymbolTable_PointerSym:
        return pSym->Pointer.Align;
        break;

      case SymbolTable_VarientFieldSym:
        return SymbolTable_GetAlignment (pSym->VarientField.Parent);
        break;

      case SymbolTable_VarientSym:
        return SymbolTable_GetAlignment (pSym->Varient.Parent);
        break;

      case SymbolTable_SubrangeSym:
        return pSym->Subrange.Align;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting record, field, pointer, type, subrange or an array symbol", 67);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetDefaultRecordFieldAlignment - assigns, align, as the default alignment
                                    to record, sym.
*/

extern "C" unsigned int SymbolTable_GetDefaultRecordFieldAlignment (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        return pSym->Record.DefaultAlign;
        break;

      case SymbolTable_VarientFieldSym:
        return SymbolTable_GetDefaultRecordFieldAlignment (SymbolTable_GetParent (sym));
        break;

      case SymbolTable_VarientSym:
        return SymbolTable_GetDefaultRecordFieldAlignment (SymbolTable_GetParent (sym));
        break;


      default:
        M2Error_InternalError ((const char *) "expecting record symbol", 23);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutDefaultRecordFieldAlignment - assigns, align, as the default alignment
                                    to record, sym.
*/

extern "C" void SymbolTable_PutDefaultRecordFieldAlignment (unsigned int sym, unsigned int align)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        pSym->Record.DefaultAlign = align;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting record symbol", 23);
        break;
    }
}


/*
   PutUnused - sets, sym, as unused.  This is a gm2 pragma.
*/

extern "C" void SymbolTable_PutUnused (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordFieldSym:
        pSym->RecordField.Used = false;
        break;


      default:
        M2MetaError_MetaError1 ((const char *) "cannot use pragma 'unused' on symbol {%1ad}", 43, sym);
        break;
    }
}


/*
   IsUnused - returns TRUE if the symbol was declared as unused with a
              gm2 pragma.
*/

extern "C" bool SymbolTable_IsUnused (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordFieldSym:
        return ! pSym->RecordField.Used;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a record field symbol", 31);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutDeclaredPacked - sets the Packed field of the record or record field symbol.
*/

extern "C" void SymbolTable_PutDeclaredPacked (unsigned int sym, bool b)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        pSym->Record.DeclPacked = b;
        pSym->Record.DeclResolved = true;
        break;

      case SymbolTable_RecordFieldSym:
        pSym->RecordField.DeclPacked = b;
        pSym->RecordField.DeclResolved = true;
        break;

      case SymbolTable_VarientFieldSym:
        pSym->VarientField.DeclPacked = b;
        pSym->VarientField.DeclResolved = true;
        break;

      case SymbolTable_VarientSym:
        pSym->Varient.DeclPacked = b;
        pSym->Varient.DeclResolved = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a record or field record symbol", 41);
        break;
    }
}


/*
   IsDeclaredPacked - was the record symbol or record field, sym,
                      declared as packed?
*/

extern "C" bool SymbolTable_IsDeclaredPacked (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        return pSym->Record.DeclPacked;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.DeclPacked;
        break;

      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.DeclPacked;
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.DeclPacked;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a record or a record field symbol", 43);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsDeclaredPackedResolved - do we know if the record symbol or record
                              field, sym, declared as packed or not packed?
*/

extern "C" bool SymbolTable_IsDeclaredPackedResolved (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_RecordSym:
        return pSym->Record.DeclResolved;
        break;

      case SymbolTable_RecordFieldSym:
        return pSym->RecordField.DeclResolved;
        break;

      case SymbolTable_VarientFieldSym:
        return pSym->VarientField.DeclResolved;
        break;

      case SymbolTable_VarientSym:
        return pSym->Varient.DeclResolved;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a record or a record field symbol", 43);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetPackedEquivalent - returns the packed equivalent of type, sym.
                         sym must be a type, subrange or enumerated type.
*/

extern "C" unsigned int SymbolTable_GetPackedEquivalent (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_EnumerationSym:
        return GetEquivalent (&pSym->Enumeration.packedInfo, sym);
        break;

      case SymbolTable_SubrangeSym:
        return GetEquivalent (&pSym->Subrange.packedInfo, sym);
        break;

      case SymbolTable_TypeSym:
        return GetEquivalent (&pSym->Type.packedInfo, sym);
        break;

      case SymbolTable_SetSym:
        return GetEquivalent (&pSym->Set.packedInfo, sym);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting type, subrange or enumerated type symbol", 50);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetNonPackedEquivalent - returns the equivalent non packed symbol associated with, sym.
*/

extern "C" unsigned int SymbolTable_GetNonPackedEquivalent (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_EquivSym:
        return pSym->Equiv.nonPacked;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting equivalent symbol", 27);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsEquivalent - returns TRUE if, sym, is an equivalent symbol.
*/

extern "C" bool SymbolTable_IsEquivalent (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_EquivSym:
        return true;
        break;


      default:
        return false;
        break;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushSize - pushes the size of Sym.
*/

extern "C" void SymbolTable_PushSize (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        M2ALU_PushFrom (pSym->Procedure.Size);
        break;

      case SymbolTable_VarSym:
        M2ALU_PushFrom (pSym->Var.Size);
        break;

      case SymbolTable_TypeSym:
        M2ALU_PushFrom (pSym->Type.Size);
        break;

      case SymbolTable_SetSym:
        M2ALU_PushFrom (pSym->Set.Size);
        break;

      case SymbolTable_VarientSym:
        M2ALU_PushFrom (pSym->Varient.Size);
        break;

      case SymbolTable_RecordSym:
        M2ALU_PushFrom (pSym->Record.Size);
        break;

      case SymbolTable_EnumerationSym:
        M2ALU_PushFrom (pSym->Enumeration.Size);
        break;

      case SymbolTable_PointerSym:
        M2ALU_PushFrom (pSym->Pointer.Size);
        break;

      case SymbolTable_ArraySym:
        M2ALU_PushFrom (pSym->Array.Size);
        break;

      case SymbolTable_RecordFieldSym:
        M2ALU_PushFrom (pSym->RecordField.Size);
        break;

      case SymbolTable_VarientFieldSym:
        M2ALU_PushFrom (pSym->VarientField.Size);
        break;

      case SymbolTable_SubrangeSym:
        M2ALU_PushFrom (pSym->Subrange.Size);
        break;

      case SymbolTable_SubscriptSym:
        M2ALU_PushFrom (pSym->Subscript.Size);
        break;

      case SymbolTable_ProcTypeSym:
        M2ALU_PushFrom (pSym->ProcType.Size);
        break;

      case SymbolTable_UnboundedSym:
        M2ALU_PushFrom (pSym->Unbounded.Size);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this kind of symbol", 33);
        break;
    }
}


/*
   PopSize - pops the ALU stack into Size of Sym.
*/

extern "C" void SymbolTable_PopSize (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        M2ALU_PopInto (pSym->Procedure.Size);
        break;

      case SymbolTable_VarSym:
        M2ALU_PopInto (pSym->Var.Size);
        break;

      case SymbolTable_TypeSym:
        M2ALU_PopInto (pSym->Type.Size);
        break;

      case SymbolTable_RecordSym:
        M2ALU_PopInto (pSym->Record.Size);
        break;

      case SymbolTable_VarientSym:
        M2ALU_PopInto (pSym->Varient.Size);
        break;

      case SymbolTable_EnumerationSym:
        M2ALU_PopInto (pSym->Enumeration.Size);
        break;

      case SymbolTable_PointerSym:
        M2ALU_PopInto (pSym->Pointer.Size);
        break;

      case SymbolTable_ArraySym:
        M2ALU_PopInto (pSym->Array.Size);
        break;

      case SymbolTable_RecordFieldSym:
        M2ALU_PopInto (pSym->RecordField.Size);
        break;

      case SymbolTable_VarientFieldSym:
        M2ALU_PopInto (pSym->VarientField.Size);
        break;

      case SymbolTable_SubrangeSym:
        M2ALU_PopInto (pSym->Subrange.Size);
        break;

      case SymbolTable_SubscriptSym:
        M2ALU_PopInto (pSym->Subscript.Size);
        break;

      case SymbolTable_ProcTypeSym:
        M2ALU_PopInto (pSym->ProcType.Size);
        break;

      case SymbolTable_UnboundedSym:
        M2ALU_PopInto (pSym->Unbounded.Size);
        break;

      case SymbolTable_SetSym:
        M2ALU_PopInto (pSym->Set.Size);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this kind of symbol", 33);
        break;
    }
}


/*
   PushValue - pushes the Value of Sym onto the ALU stack.
*/

extern "C" void SymbolTable_PushValue (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstLitSym:
        M2ALU_PushFrom (pSym->ConstLit.Value);
        break;

      case SymbolTable_ConstVarSym:
        M2ALU_PushFrom (pSym->ConstVar.Value);
        break;

      case SymbolTable_EnumerationFieldSym:
        M2ALU_PushFrom (pSym->EnumerationField.Value);
        break;

      case SymbolTable_ConstStringSym:
        PushConstString (Sym);
        break;


      default:
        M2Error_InternalError ((const char *) "not expecting this kind of symbol", 33);
        break;
    }
}


/*
   PushVarSize - pushes the size of a variable, Sym.
                 The runtime size of Sym will depend upon its addressing mode,
                 RightValue has size PushSize(GetType(Sym)) and
                 LeftValue has size PushSize(Address) since it points to a
                 variable.
*/

extern "C" void SymbolTable_PushVarSize (unsigned int Sym)
{
  AssertInRange (Sym);
  M2Debug_Assert (SymbolTable_IsVar (Sym));
  if ((SymbolTable_GetMode (Sym)) == SymbolTable_LeftValue)
    {
      SymbolTable_PushSize (M2System_Address);
    }
  else
    {
      M2Debug_Assert ((SymbolTable_GetMode (Sym)) == SymbolTable_RightValue);
      SymbolTable_PushSize (SymbolTable_GetType (Sym));
    }
}


/*
   PopValue - pops the ALU stack into Value of Sym.
*/

extern "C" void SymbolTable_PopValue (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstLitSym:
        M2ALU_PopInto (pSym->ConstLit.Value);
        break;

      case SymbolTable_ConstVarSym:
        M2ALU_PopInto (pSym->ConstVar.Value);
        break;

      case SymbolTable_EnumerationFieldSym:
        M2Error_InternalError ((const char *) "cannot pop into an enumeration field", 36);
        break;


      default:
        M2Error_InternalError ((const char *) "symbol type not expected", 24);
        break;
    }
}


/*
   IsObject - returns TRUE if the symbol is an object symbol.
*/

extern "C" bool SymbolTable_IsObject (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_ObjectSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsTuple - returns TRUE if the symbol is a tuple symbol.
*/

extern "C" bool SymbolTable_IsTuple (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_TupleSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Make2Tuple - creates and returns a 2 tuple from, a, and, b.
*/

extern "C" unsigned int SymbolTable_Make2Tuple (unsigned int a, unsigned int b)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  NewSym (&Sym);
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_TupleSym;
  pSym->Tuple.nTuple = 2;
  pSym->Tuple.list = Indexing_InitIndex (1);
  PutIntoIndex (&pSym->Tuple.list, 1, a);
  PutIntoIndex (&pSym->Tuple.list, 2, b);
  InitWhereDeclared (&pSym->Tuple.At);
  InitWhereFirstUsed (&pSym->Tuple.At);
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeError - creates an error node, which can be used in MetaError messages.
               It will be removed from ExportUndeclared and Unknown trees.
*/

extern "C" unsigned int SymbolTable_MakeError (unsigned int tok, NameKey_Name name)
{
  SymbolTable_PtrToSymbol pSym;
  unsigned int Sym;

  /* if Sym is present on the unknown tree then remove it  */
  Sym = FetchUnknownSym (name);
  if (Sym == SymbolTable_NulSym)
    {
      NewSym (&Sym);
    }
  else
    {
      /* 
         remove symbol from this tree as we have already generated
         a meaningful error message
  */
      RemoveExportUndeclared (SymbolTable_GetCurrentModuleScope (), Sym);
    }
  pSym = GetPsym (Sym);
  pSym->SymbolType = SymbolTable_ErrorSym;
  pSym->Error.name = name;
  pSym->Error.Scope = SymbolTable_GetCurrentScope ();
  InitWhereDeclaredTok (tok, &pSym->Error.At);
  InitWhereFirstUsedTok (tok, &pSym->Error.At);
  return Sym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeErrorS - creates an error node from a string, which can be used
                in MetaError messages.
                It will be removed from ExportUndeclared and Unknown trees.
*/

extern "C" unsigned int SymbolTable_MakeErrorS (unsigned int tok, DynamicStrings_String name)
{
  return SymbolTable_MakeError (tok, NameKey_makekey (DynamicStrings_string (name)));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsError - returns TRUE if the symbol is an error symbol.
*/

extern "C" bool SymbolTable_IsError (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (Sym);
  pSym = GetPsym (Sym);
  return pSym->SymbolType == SymbolTable_ErrorSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsLegal - returns TRUE if, sym, is a legal symbol.
*/

extern "C" bool SymbolTable_IsLegal (unsigned int sym)
{
  return sym < FreeSymbol;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutModuleContainsBuiltin - sets a flag in the current compiled module which
                              indicates that a builtin procedure is being declared.
                              This is only expected to be called when we are
                              parsing the definition module.
*/

extern "C" void SymbolTable_PutModuleContainsBuiltin (void)
{
  SymbolTable_PtrToSymbol pSym;

  SymbolTable_PutHiddenTypeDeclared ();
  pSym = GetPsym (CurrentModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        pSym->DefImp.ContainsBuiltin = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   IsBuiltinInModule - returns true if a module, Sym, has declared a builtin procedure.
*/

extern "C" bool SymbolTable_IsBuiltinInModule (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return pSym->DefImp.ContainsBuiltin;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutHiddenTypeDeclared - sets a flag in the current compiled module which
                           indicates that a Hidden Type is declared within
                           the implementation part of the module.
                           This procedure is expected to be called while
                           compiling the associated definition module.
*/

extern "C" void SymbolTable_PutHiddenTypeDeclared (void)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (CurrentModule);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        pSym->DefImp.ContainsHiddenType = true;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
}


/*
   IsHiddenTypeDeclared - returns true if a Hidden Type was declared in
                          the module, Sym.
*/

extern "C" bool SymbolTable_IsHiddenTypeDeclared (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        return pSym->DefImp.ContainsHiddenType;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsHiddenReallyPointer - returns TRUE is sym is a pointer, address or a
                           type declared as a pointer or address.
*/

extern "C" bool SymbolTable_IsHiddenReallyPointer (unsigned int Sym)
{
  if (SymbolTable_IsVar (Sym))
    {
      Sym = SymbolTable_GetType (Sym);
    }
  while ((Sym != SymbolTable_NulSym) && (SymbolTable_IsType (Sym)))
    {
      Sym = SymbolTable_SkipType (SymbolTable_GetType (Sym));
    }
  return (Sym != SymbolTable_NulSym) && ((SymbolTable_IsPointer (Sym)) || (Sym == M2System_Address));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DisplayTrees - displays the SymbolTrees for Module symbol, ModSym.
*/

extern "C" void SymbolTable_DisplayTrees (unsigned int ModSym)
{
  SymbolTable_PtrToSymbol pSym;
  NameKey_Name n;

  n = SymbolTable_GetSymName (ModSym);
  M2Printf_printf1 ((const char *) "Symbol trees for module/procedure: %a\\n", 39, (const unsigned char *) &n, (sizeof (n)-1));
  pSym = GetPsym (ModSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_DefImpSym:
        n = SymbolTable_GetSymName (ModSym);
        M2Printf_printf1 ((const char *) "%a  UndefinedTree", 17, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.Unresolved, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  Local symbols", 17, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.LocalSymbols, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ExportRequest", 17, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.ExportRequest, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ExportQualified", 19, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.ExportQualifiedTree, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ExportUnQualified", 21, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.ExportUnQualifiedTree, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ExportUndeclared", 20, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.ExportUndeclared, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  DeclaredObjects", 19, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.NamedObjects, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ImportedObjects", 19, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->DefImp.NamedImports, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplayName});
        M2Printf_printf0 ((const char *) "\\n", 2);
        break;

      case SymbolTable_ModuleSym:
        n = SymbolTable_GetSymName (ModSym);
        M2Printf_printf1 ((const char *) "%a  UndefinedTree", 17, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Module.Unresolved, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  Local symbols", 17, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Module.LocalSymbols, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ImportTree", 14, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Module.ImportTree, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ExportTree", 14, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Module.ExportTree, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ExportUndeclared", 20, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Module.ExportUndeclared, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  DeclaredObjects", 19, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Module.NamedObjects, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  ImportedObjects", 19, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Module.NamedImports, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplayName});
        M2Printf_printf0 ((const char *) "\\n", 2);
        break;

      case SymbolTable_ProcedureSym:
        n = SymbolTable_GetSymName (ModSym);
        M2Printf_printf1 ((const char *) "%a  UndefinedTree", 17, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Procedure.Unresolved, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  Local symbols", 17, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Procedure.LocalSymbols, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplaySymbol});
        M2Printf_printf0 ((const char *) "\\n", 2);
        M2Printf_printf1 ((const char *) "%a  DeclaredObjects", 19, (const unsigned char *) &n, (sizeof (n)-1));
        SymbolKey_ForeachNodeDo (pSym->Procedure.NamedObjects, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DisplayName});
        M2Printf_printf0 ((const char *) "\\n", 2);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting DefImp symbol", 23);
        break;
    }
}


/*
   DebugLineNumbers - internal debugging, emit all procedure names in this module
                      together with the line numbers for the corresponding begin/end
                      tokens.
*/

extern "C" void SymbolTable_DebugLineNumbers (unsigned int sym)
{
  if (M2Options_GetDebugFunctionLineNumbers ())
    {
      M2Printf_printf0 ((const char *) "<lines>\\n", 9);
      SymbolTable_ForeachProcedureDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) DebugProcedureLineNumber});
      M2Printf_printf0 ((const char *) "</lines>\\n", 10);
    }
}


/*
   GetErrorScope - returns the error scope for a symbol.
                   The error scope is the title scope which is used to
                   announce the symbol in the GCC error message.
*/

extern "C" M2Error_ErrorScope SymbolTable_GetErrorScope (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        return pSym->Procedure.errorScope;
        break;

      case SymbolTable_ModuleSym:
        return pSym->Module.errorScope;
        break;

      case SymbolTable_DefImpSym:
        return pSym->DefImp.errorScope;
        break;

      case SymbolTable_UndefinedSym:
        return pSym->Undefined.errorScope;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting procedure, module or defimp symbol", 44);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   MakeImport - create and return an import symbol.
                moduleSym is the symbol being imported.
                isqualified is FALSE if it were IMPORT modulename and
                TRUE for the qualified FROM modulename IMPORT etc.
                listno is the import list count for this module.
                tok should match this modulename position.
*/

extern "C" unsigned int SymbolTable_MakeImport (unsigned int tok, unsigned int moduleSym, unsigned int listno, bool isqualified)
{
  unsigned int importSym;
  SymbolTable_PtrToSymbol pSym;

  NewSym (&importSym);
  pSym = GetPsym (importSym);
  pSym->SymbolType = SymbolTable_ImportSym;
  pSym->Import.module = moduleSym;
  pSym->Import.listNo = listno;
  pSym->Import.qualified = isqualified;
  InitWhereDeclaredTok (tok, &pSym->Import.at);
  return importSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeImportStatement - return a dependent symbol which represents an import statement
                   or a qualified import statement.  The tok should either match
                   the FROM token or the IMPORT token.  listno is the import list
                   count for the module.
*/

extern "C" unsigned int SymbolTable_MakeImportStatement (unsigned int tok, unsigned int listno)
{
  unsigned int dependentSym;
  SymbolTable_PtrToSymbol pSym;

  NewSym (&dependentSym);
  pSym = GetPsym (dependentSym);
  pSym->SymbolType = SymbolTable_ImportStatementSym;
  pSym->ImportStatement.listNo = listno;
  Lists_InitList (&pSym->ImportStatement.ListOfImports);
  InitWhereDeclaredTok (tok, &pSym->ImportStatement.at);
  return dependentSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsImport - returns TRUE if sym is an import symbol.
*/

extern "C" bool SymbolTable_IsImport (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  return pSym->SymbolType == SymbolTable_ImportSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsImportStatement - returns TRUE if sym is a dependent symbol.
*/

extern "C" bool SymbolTable_IsImportStatement (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  return pSym->SymbolType == SymbolTable_ImportStatementSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetImportModule - returns the module associated with the import symbol.
*/

extern "C" unsigned int SymbolTable_GetImportModule (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsImport (sym));
  pSym = GetPsym (sym);
  return pSym->Import.module;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetImportDeclared - returns the token associated with the import symbol.
*/

extern "C" unsigned int SymbolTable_GetImportDeclared (unsigned int sym)
{
  unsigned int tok;

  M2Debug_Assert (SymbolTable_IsImport (sym));
  tok = SymbolTable_GetDeclaredDefinition (sym);
  if (tok == M2LexBuf_UnknownTokenNo)
    {
      return SymbolTable_GetDeclaredModule (sym);
    }
  return tok;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetImportStatementList - returns the list of imports for this dependent.
                            Each import symbol corresponds to a module.
*/

extern "C" Lists_List SymbolTable_GetImportStatementList (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert (SymbolTable_IsImportStatement (sym));
  pSym = GetPsym (sym);
  return pSym->ImportStatement.ListOfImports;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetModuleDefImportStatementList - returns the list of dependents associated with
                                     the definition module.
*/

extern "C" Lists_List SymbolTable_GetModuleDefImportStatementList (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)));
  if (SymbolTable_IsDefImp (sym))
    {
      pSym = GetPsym (sym);
      return pSym->DefImp.DefListOfDep;
    }
  return static_cast<Lists_List> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetModuleModImportStatementList - returns the list of dependents associated with
                                     the implementation or program module.
*/

extern "C" Lists_List SymbolTable_GetModuleModImportStatementList (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  M2Debug_Assert ((SymbolTable_IsModule (sym)) || (SymbolTable_IsDefImp (sym)));
  pSym = GetPsym (sym);
  if (SymbolTable_IsDefImp (sym))
    {
      return pSym->DefImp.ModListOfDep;
    }
  else
    {
      return pSym->Module.ModListOfDep;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AppendModuleImportStatement - appends the ImportStatement symbol onto the
                                 module import list.

                                 For example:

                                 FROM x IMPORT y, z ;
                                 ^^^^

                                 also:

                                 IMPORT p, q, r;
                                 ^^^^^^
                                 will result in a new ImportStatement symbol added
                                 to the current module import list.
                                 The statement symbol is expected to be created
                                 by MakeImportStatement using the token positions
                                 outlined above.
*/

extern "C" void SymbolTable_AppendModuleImportStatement (unsigned int module, unsigned int statement)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsDefImp (module))
    {
      pSym = GetPsym (module);
      if (M2Comp_CompilingDefinitionModule ())
        {
          Lists_IncludeItemIntoList (pSym->DefImp.DefListOfDep, statement);
        }
      else
        {
          Lists_IncludeItemIntoList (pSym->DefImp.ModListOfDep, statement);
        }
    }
  else if (SymbolTable_IsModule (module))
    {
      /* avoid dangling else.  */
      pSym = GetPsym (module);
      Lists_IncludeItemIntoList (pSym->Module.ModListOfDep, statement);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting DefImp or Module symbol", 33);
    }
}


/*
   AppendModuleOnImportStatement - appends the import symbol onto the
                                   dependent list (chain).

                                   For example each:

                                   FROM x IMPORT y, z ;
                                        ^
                                   x are added to the dependent list.

                                   also:

                                   IMPORT p, q, r;
                                          ^  ^  ^
                                   will result in p, q and r added to
                                   to the dependent list.

                                   The import symbol is created by MakeImport
                                   and the token is expected to match the module
                                   name position outlined above.
*/

extern "C" void SymbolTable_AppendModuleOnImportStatement (unsigned int module, unsigned int import)
{
  Lists_List l;
  unsigned int lastImportStatement;

  M2Debug_Assert (SymbolTable_IsImport (import));
  if (M2Comp_CompilingDefinitionModule ())
    {
      l = SymbolTable_GetModuleDefImportStatementList (module);
    }
  else
    {
      l = SymbolTable_GetModuleModImportStatementList (module);
    }
  M2Debug_Assert (l != NULL);
  M2Debug_Assert ((Lists_NoOfItemsInList (l)) > 0);  /* There should always be one on the list.  */
  lastImportStatement = static_cast<unsigned int> (Lists_GetItemFromList (l, Lists_NoOfItemsInList (l)));  /* There should always be one on the list.  */
  M2Debug_Assert (SymbolTable_IsImportStatement (lastImportStatement));
  l = SymbolTable_GetImportStatementList (lastImportStatement);
  Lists_IncludeItemIntoList (l, import);
}


/*
   PutModLink - assigns link to module sym.
*/

extern "C" void SymbolTable_PutModLink (unsigned int sym, bool link)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsModule (sym))
    {
      pSym = GetPsym (sym);
      pSym->Module.ModLink = link;
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      pSym = GetPsym (sym);
      pSym->DefImp.ModLink = link;
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
    }
}


/*
   IsModLink - returns the ModLink value associated with the module symbol.
*/

extern "C" bool SymbolTable_IsModLink (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsModule (sym))
    {
      pSym = GetPsym (sym);
      return pSym->Module.ModLink;
    }
  else if (SymbolTable_IsDefImp (sym))
    {
      /* avoid dangling else.  */
      pSym = GetPsym (sym);
      return pSym->DefImp.ModLink;
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting a DefImp or Module symbol", 35);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutDefLink - assigns link to the definition module sym.
*/

extern "C" void SymbolTable_PutDefLink (unsigned int sym, bool link)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsDefImp (sym))
    {
      pSym = GetPsym (sym);
      pSym->DefImp.DefLink = link;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
    }
}


/*
   IsDefLink - returns the DefLink value associated with the definition module symbol.
*/

extern "C" bool SymbolTable_IsDefLink (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsDefImp (sym))
    {
      pSym = GetPsym (sym);
      return pSym->DefImp.DefLink;
    }
  else
    {
      M2Error_InternalError ((const char *) "expecting a DefImp symbol", 25);
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   IsModuleBuiltin - returns TRUE if the module is a builtin module.
                     (For example _BaseTypes).
*/

extern "C" bool SymbolTable_IsModuleBuiltin (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsDefImp (sym))
    {
      pSym = GetPsym (sym);
      return pSym->DefImp.Builtin;
    }
  else if (SymbolTable_IsModule (sym))
    {
      /* avoid dangling else.  */
      pSym = GetPsym (sym);
      return pSym->Module.Builtin;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutModuleBuiltin - sets the Builtin flag to value.
                      Currently the procedure expects sym to be a DefImp
                      module only.
*/

extern "C" void SymbolTable_PutModuleBuiltin (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsDefImp (sym))
    {
      pSym = GetPsym (sym);
      pSym->DefImp.Builtin = value;
    }
  else if (SymbolTable_IsModule (sym))
    {
      /* avoid dangling else.  */
      pSym = GetPsym (sym);
      pSym->Module.Builtin = value;
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "expecting Module or DefImp symbol", 33);
    }
}


/*
   PutVarArrayRef - assigns ArrayRef field with value.
*/

extern "C" void SymbolTable_PutVarArrayRef (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        pSym->Var.ArrayRef = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym", 16);
        break;
    }
}


/*
   IsVarArrayRef - returns ArrayRef field value.
*/

extern "C" bool SymbolTable_IsVarArrayRef (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_VarSym:
        return pSym->Var.ArrayRef;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting VarSym", 16);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   VarCheckReadInit - returns TRUE if sym has been initialized.
*/

extern "C" bool SymbolTable_VarCheckReadInit (unsigned int sym, SymbolTable_ModeOfAddr mode)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            return M2SymInit_GetInitialized (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[mode-SymbolTable_RightValue]));
            break;


          default:
            break;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   VarInitState - initializes the init state for variable sym.
*/

extern "C" void SymbolTable_VarInitState (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            M2SymInit_ConfigSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_LeftValue-SymbolTable_RightValue]), sym);
            M2SymInit_ConfigSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_RightValue-SymbolTable_RightValue]), sym);
            break;


          default:
            break;
        }
    }
}


/*
   PutVarInitialized - set sym as initialized.
*/

extern "C" void SymbolTable_PutVarInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            M2SymInit_SetInitialized (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[mode-SymbolTable_RightValue]));
            break;


          default:
            break;
        }
    }
}


/*
   PutVarFieldInitialized - records that field has been initialized with
                            variable sym.  TRUE is returned if the field
                            is detected and changed to initialized.
*/

extern "C" bool SymbolTable_PutVarFieldInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode, Lists_List fieldlist)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            return M2SymInit_SetFieldInitialized (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[mode-SymbolTable_RightValue]), fieldlist);
            break;


          default:
            break;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetVarFieldInitialized - return TRUE if fieldlist has been initialized
                            within variable sym.
*/

extern "C" bool SymbolTable_GetVarFieldInitialized (unsigned int sym, SymbolTable_ModeOfAddr mode, Lists_List fieldlist)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            return M2SymInit_GetFieldInitialized (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[mode-SymbolTable_RightValue]), fieldlist);
            break;


          default:
            break;
        }
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PrintInitialized - display variable sym initialization state.
*/

extern "C" void SymbolTable_PrintInitialized (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsVar (sym))
    {
      pSym = GetPsym (sym);
      switch (pSym->SymbolType)
        {
          case SymbolTable_VarSym:
            M2Printf_printf0 ((const char *) "LeftMode init: ", 15);
            M2SymInit_PrintSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_LeftValue-SymbolTable_RightValue]));
            M2Printf_printf0 ((const char *) "RightMode init: ", 16);
            M2SymInit_PrintSymInit (static_cast<M2SymInit_InitDesc> (pSym->Var.InitState.array[SymbolTable_RightValue-SymbolTable_RightValue]));
            break;


          default:
            break;
        }
    }
}


/*
   GetParameterHeapVar - return the heap variable associated with the
                         parameter or NulSym.
*/

extern "C" unsigned int SymbolTable_GetParameterHeapVar (unsigned int ParSym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (ParSym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ParamSym:
        return SymbolTable_NulSym;  /* Only VarParam has the pointer.  */
        break;

      case SymbolTable_VarParamSym:
        return pSym->VarParam.HeapVar;  /* Only VarParam has the pointer.  */
        break;


      default:
        M2Error_InternalError ((const char *) "expecting Param or VarParam symbol", 34);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   PutProcedureParameterHeapVars - creates heap variables for parameter sym.
*/

extern "C" void SymbolTable_PutProcedureParameterHeapVars (unsigned int sym)
{
  M2Debug_Assert (SymbolTable_IsProcedure (sym));
  SymbolTable_ForeachParamSymDo (sym, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) PutParameterHeapVar});
}


/*
   IsProcedureBuiltinAvailable - return TRUE if procedure is available as a builtin
                                 for the target architecture.
*/

extern "C" bool SymbolTable_IsProcedureBuiltinAvailable (unsigned int procedure)
{
  return (SymbolTable_IsProcedureBuiltin (procedure)) && (CanUseBuiltin (procedure));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutConstLitInternal - marks the sym as being an internal constant.
                         Currently this is used when generating a default
                         BY constant expression during a FOR loop.
                         A constant marked as internal will always pass
                         an expression type check.
*/

extern "C" void SymbolTable_PutConstLitInternal (unsigned int sym, bool value)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstLitSym:
        pSym->ConstLit.IsInternal = value;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstLitSym", 21);
        break;
    }
}


/*
   IsConstLitInternal - returns the value of the IsInternal field within
                        a constant expression.
*/

extern "C" bool SymbolTable_IsConstLitInternal (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ConstLitSym:
        return pSym->ConstLit.IsInternal;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting ConstLitSym", 21);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetVarDeclTypeTok - returns the TypeTok field associate with variable sym.
*/

extern "C" unsigned int SymbolTable_GetVarDeclTypeTok (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsParameter (sym))
    {
      pSym = GetPsym (sym);
      if (SymbolTable_IsParameterVar (sym))
        {
          return SymbolTable_GetVarDeclTypeTok (pSym->VarParam.ShadowVar);
        }
      else
        {
          return SymbolTable_GetVarDeclTypeTok (pSym->Param.ShadowVar);
        }
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      return doGetVarDeclTypeTok (sym);
    }
  else
    {
      /* avoid dangling else.  */
      return M2LexBuf_UnknownTokenNo;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutVarDeclTypeTok - assigns the TypeTok field to typetok.
                       sym can be a variable or parameter.
*/

extern "C" void SymbolTable_PutVarDeclTypeTok (unsigned int sym, unsigned int typetok)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsParameter (sym))
    {
      pSym = GetPsym (sym);
      if (SymbolTable_IsParameterVar (sym))
        {
          SymbolTable_PutVarDeclTypeTok (pSym->VarParam.ShadowVar, typetok);
        }
      else
        {
          SymbolTable_PutVarDeclTypeTok (pSym->Param.ShadowVar, typetok);
        }
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      doPutVarDeclTypeTok (sym, typetok);
    }
}


/*
   GetVarDeclTok - returns the TypeTok field associate with variable sym.
*/

extern "C" unsigned int SymbolTable_GetVarDeclTok (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsParameter (sym))
    {
      pSym = GetPsym (sym);
      if (SymbolTable_IsParameterVar (sym))
        {
          if (pSym->VarParam.ShadowVar == SymbolTable_NulSym)
            {
              return pSym->VarParam.At;
            }
          else
            {
              return SymbolTable_GetVarDeclTok (pSym->VarParam.ShadowVar);
            }
        }
      else
        {
          if (pSym->Param.ShadowVar == SymbolTable_NulSym)
            {
              return pSym->Param.At;
            }
          else
            {
              return SymbolTable_GetVarDeclTok (pSym->Param.ShadowVar);
            }
        }
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      return doGetVarDeclTok (sym);
    }
  else
    {
      /* avoid dangling else.  */
      return M2LexBuf_UnknownTokenNo;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PutVarDeclTok - assigns the VarTok field to typetok.
                   sym can be a variable or parameter.
*/

extern "C" void SymbolTable_PutVarDeclTok (unsigned int sym, unsigned int vartok)
{
  SymbolTable_PtrToSymbol pSym;

  if (SymbolTable_IsParameter (sym))
    {
      pSym = GetPsym (sym);
      if (SymbolTable_IsParameterVar (sym))
        {
          SymbolTable_PutVarDeclTok (pSym->VarParam.ShadowVar, vartok);
        }
      else
        {
          SymbolTable_PutVarDeclTok (pSym->Param.ShadowVar, vartok);
        }
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      doPutVarDeclTok (sym, vartok);
    }
}


/*
   GetVarDeclFullTok - returns the full virtual token containing var: type.
*/

extern "C" unsigned int SymbolTable_GetVarDeclFullTok (unsigned int sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  if (SymbolTable_IsParameter (sym))
    {
      if (SymbolTable_IsParameterVar (sym))
        {
          return pSym->VarParam.FullTok;
        }
      else
        {
          return pSym->Param.FullTok;
        }
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      return doGetVarDeclFullTok (sym);
    }
  else
    {
      /* avoid dangling else.  */
      return M2LexBuf_UnknownTokenNo;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsProcedureAnyNoReturn - return TRUE if any of the defined kinds
                            of procedure sym is declared no return.
*/

extern "C" bool SymbolTable_IsProcedureAnyNoReturn (unsigned int sym)
{
  return IsProcedureAnyDefaultBoolean (sym, false, (SymbolTable_ProcAnyBoolean) {(SymbolTable_ProcAnyBoolean_t) SymbolTable_IsProcedureNoReturn});
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetNthParamAny - returns the nth parameter from the order
                    proper procedure, forward declaration
                    or definition module procedure.
*/

extern "C" unsigned int SymbolTable_GetNthParamAny (unsigned int sym, unsigned int ParamNo)
{
  SymbolTable_ProcedureKind kind;

  for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
    {
      if (SymbolTable_GetProcedureParametersDefined (sym, kind))
        {
          return SymbolTable_GetNthParam (sym, kind, ParamNo);
        }
    }
  M2Error_InternalError ((const char *) "no procedure kind exists", 24);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   NoOfParamAny - return the number of parameters for sym.
*/

extern "C" unsigned int SymbolTable_NoOfParamAny (unsigned int sym)
{
  SymbolTable_ProcedureKind kind;
  SymbolTable_PtrToSymbol pSym;

  AssertInRange (sym);
  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return 0;
        break;

      case SymbolTable_ProcedureSym:
        for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
          {
            if (SymbolTable_GetProcedureParametersDefined (sym, kind))
              {
                return SymbolTable_NoOfParam (sym, kind);
              }
          }
        break;

      case SymbolTable_ProcTypeSym:
        return Lists_NoOfItemsInList (pSym->ProcType.ListOfParam);
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  return 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetReturnOptional - sets the ReturnOptional field in the Procedure:kind or
                       ProcType symboltable entry.
*/

extern "C" void SymbolTable_SetReturnOptional (unsigned int sym, SymbolTable_ProcedureKind kind, bool isopt)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ProcedureSym:
        pSym->Procedure.Decl.array[kind-SymbolTable_ProperProcedure].ReturnOptional = isopt;
        break;

      case SymbolTable_ProcTypeSym:
        pSym->ProcType.ReturnOptional = isopt;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
}


/*
   UsesOptArgAny - returns TRUE if procedure Sym:kind uses an optional argument.
*/

extern "C" bool SymbolTable_UsesOptArgAny (unsigned int Sym)
{
  SymbolTable_PtrToSymbol pSym;

  pSym = GetPsym (Sym);
  switch (pSym->SymbolType)
    {
      case SymbolTable_ErrorSym:
        return false;
        break;

      case SymbolTable_ProcedureSym:
        return IsProcedureAnyDefaultBoolean (Sym, false, (SymbolTable_ProcAnyBoolean) {(SymbolTable_ProcAnyBoolean_t) SymbolTable_UsesOptArg});
        break;

      case SymbolTable_ProcTypeSym:
        return pSym->ProcType.HasOptArg;
        break;


      default:
        M2Error_InternalError ((const char *) "expecting a Procedure or ProcType symbol", 40);
        break;
    }
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetProcedureKindDesc - return a string describing kind.
*/

extern "C" DynamicStrings_String SymbolTable_GetProcedureKindDesc (SymbolTable_ProcedureKind kind)
{
  if (kind == SymbolTable_ProperProcedure)
    {
      return DynamicStrings_InitString ((const char *) "proper procedure", 16);
    }
  else if (kind == SymbolTable_ForwardProcedure)
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "forward procedure", 17);
    }
  else if (kind == SymbolTable_DefProcedure)
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "definition procedure", 20);
    }
  M2Error_InternalError ((const char *) "unknown kind value", 18);
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/SymbolTable.def", 20, 1);
  __builtin_unreachable ();
}


/*
   GetNthParamAnyClosest - returns the nth parameter from the order
                           proper procedure, forward declaration
                           or definition module procedure.
                           It chooses the parameter which is closest
                           in source terms to currentmodule.
                           The same module will return using the order
                           proper procedure, forward procedure, definition module.
                           Whereas an imported procedure will choose from
                           DefProcedure, ProperProcedure, ForwardProcedure.
*/

extern "C" unsigned int SymbolTable_GetNthParamAnyClosest (unsigned int sym, unsigned int ParamNo, unsigned int currentmodule)
{
  if ((GetOuterModuleScope (currentmodule)) == (GetOuterModuleScope (sym)))
    {
      /* Same module.  */
      return GetNthParamOrdered (sym, ParamNo, SymbolTable_ProperProcedure, SymbolTable_ForwardProcedure, SymbolTable_DefProcedure);
    }
  else
    {
      /* Procedure is imported.  */
      return GetNthParamOrdered (sym, ParamNo, SymbolTable_DefProcedure, SymbolTable_ProperProcedure, SymbolTable_ForwardProcedure);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_SymbolTable_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_SymbolTable_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
