/* do not edit automatically generated by mc from M2StateCheck.  */
/* M2StateCheck.mod provide state check tracking for declarations.

Copyright (C) 2024-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaiusmod2@gmail.com>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2StateCheck_C

#include "GM2StateCheck.h"
#   include "GStorage.h"
#   include "GM2MetaError.h"
#   include "GDynamicStrings.h"
#   include "GSymbolTable.h"

typedef struct M2StateCheck__T1_r M2StateCheck__T1;

typedef enum {M2StateCheck_const, M2StateCheck_var, M2StateCheck_type, M2StateCheck_constfunc, M2StateCheck_varparam, M2StateCheck_constructor} M2StateCheck_State;

typedef M2StateCheck__T1 *M2StateCheck_StateCheck__opaque;

typedef unsigned int M2StateCheck_StateSet;

struct M2StateCheck__T1_r {
                            M2StateCheck_StateSet state;
                            M2StateCheck_StateCheck__opaque stack;
                            M2StateCheck_StateCheck__opaque next;
                          };

static M2StateCheck_StateCheck__opaque FreeList;

/*
   InitState - returns a new initialized StateCheck.
*/

extern "C" M2StateCheck_StateCheck M2StateCheck_InitState (void);

/*
   KillState - destructor for StateCheck.
*/

extern "C" void M2StateCheck_KillState (M2StateCheck_StateCheck *s);

/*
   PushState - duplicates the StateCheck s and chains the new copy to s.
               Return the copy.
*/

extern "C" void M2StateCheck_PushState (M2StateCheck_StateCheck *s);

/*
   PopState - pops the current state.
*/

extern "C" void M2StateCheck_PopState (M2StateCheck_StateCheck *s);

/*
   InclVar - s := s + {var}.
*/

extern "C" void M2StateCheck_InclVar (M2StateCheck_StateCheck s);

/*
   InclConst - s := s + {const}.
*/

extern "C" void M2StateCheck_InclConst (M2StateCheck_StateCheck s);

/*
   InclType - s := s + {type}.
*/

extern "C" void M2StateCheck_InclType (M2StateCheck_StateCheck s);

/*
   InclConstFunc - s := s + {constfunc}.
*/

extern "C" void M2StateCheck_InclConstFunc (M2StateCheck_StateCheck s);

/*
   InclVarParam - s := s + {varparam}.
*/

extern "C" void M2StateCheck_InclVarParam (M2StateCheck_StateCheck s);

/*
   InclConstructor - s := s + {constructor}.
*/

extern "C" void M2StateCheck_InclConstructor (M2StateCheck_StateCheck s);

/*
   ExclVar - s := s - {var}.
*/

extern "C" void M2StateCheck_ExclVar (M2StateCheck_StateCheck s);

/*
   ExclConst - s := s - {const}.
*/

extern "C" void M2StateCheck_ExclConst (M2StateCheck_StateCheck s);

/*
   ExclType - s := s - {type}.
*/

extern "C" void M2StateCheck_ExclType (M2StateCheck_StateCheck s);

/*
   ExclConstFunc - s := s - {constfunc}.
*/

extern "C" void M2StateCheck_ExclConstFunc (M2StateCheck_StateCheck s);

/*
   ExclVarParam - s := s - {varparam}.
*/

extern "C" void M2StateCheck_ExclVarParam (M2StateCheck_StateCheck s);

/*
   ExclConstructor - s := s - {varparam}.
*/

extern "C" void M2StateCheck_ExclConstructor (M2StateCheck_StateCheck s);

/*
   CheckQualident - checks to see that qualident sym is allowed in the state s.
*/

extern "C" void M2StateCheck_CheckQualident (unsigned int tok, M2StateCheck_StateCheck s, unsigned int sym);

/*
   New - returns an uninitialized StateCheck.
*/

static M2StateCheck_StateCheck__opaque New (void);

/*
   Dispose - place s onto the FreeList and set s to NIL.
*/

static void Dispose (M2StateCheck_StateCheck__opaque *s);

/*
   GenerateError - generates an unrecoverable error string based on the state and sym.
*/

static void GenerateError (unsigned int tok, M2StateCheck_StateCheck__opaque s, unsigned int sym);

/*
   init - initialize the global variables in the module.
*/

static void init (void);


/*
   New - returns an uninitialized StateCheck.
*/

static M2StateCheck_StateCheck__opaque New (void)
{
  M2StateCheck_StateCheck__opaque s;

  if (FreeList == NULL)
    {
      Storage_ALLOCATE ((void **) &s, sizeof (M2StateCheck__T1));
    }
  else
    {
      s = FreeList;
      FreeList = FreeList->next;
    }
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Dispose - place s onto the FreeList and set s to NIL.
*/

static void Dispose (M2StateCheck_StateCheck__opaque *s)
{
  (*s)->next = FreeList;
  FreeList = (*s);
}


/*
   GenerateError - generates an unrecoverable error string based on the state and sym.
*/

static void GenerateError (unsigned int tok, M2StateCheck_StateCheck__opaque s, unsigned int sym)
{
  DynamicStrings_String str;

  str = DynamicStrings_InitString ((const char *) "not expecting the {%1Ad} {%1a} in a ", 36);
  if ((((1 << (M2StateCheck_const-M2StateCheck_const)) & (s->state)) != 0))
    {
      str = DynamicStrings_ConCat (str, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "{%kCONST} block", 15)));
    }
  else if ((((1 << (M2StateCheck_type-M2StateCheck_const)) & (s->state)) != 0))
    {
      /* avoid dangling else.  */
      str = DynamicStrings_ConCat (str, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "{%kTYPE} block", 14)));
    }
  else if ((((1 << (M2StateCheck_var-M2StateCheck_const)) & (s->state)) != 0))
    {
      /* avoid dangling else.  */
      str = DynamicStrings_ConCat (str, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "{%kVAR} block", 13)));
    }
  if ((((1 << (M2StateCheck_constfunc-M2StateCheck_const)) & (s->state)) != 0))
    {
      str = DynamicStrings_ConCat (str, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " and within a constant procedure function actual parameter", 58)));
    }
  if ((((1 << (M2StateCheck_constructor-M2StateCheck_const)) & (s->state)) != 0))
    {
      str = DynamicStrings_ConCat (str, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " and within a constructor", 25)));
    }
  M2MetaError_MetaErrorStringT1 (tok, str, sym);
}


/*
   init - initialize the global variables in the module.
*/

static void init (void)
{
  FreeList = static_cast<M2StateCheck_StateCheck__opaque> (NULL);
}


/*
   InitState - returns a new initialized StateCheck.
*/

extern "C" M2StateCheck_StateCheck M2StateCheck_InitState (void)
{
  M2StateCheck_StateCheck__opaque s;

  s = New ();
  s->state = (M2StateCheck_StateSet) 0;
  s->stack = static_cast<M2StateCheck_StateCheck__opaque> (NULL);
  s->next = static_cast<M2StateCheck_StateCheck__opaque> (NULL);
  return static_cast<M2StateCheck_StateCheck> (s);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillState - destructor for StateCheck.
*/

extern "C" void M2StateCheck_KillState (M2StateCheck_StateCheck *s)
{
  M2StateCheck_StateCheck__opaque t;

  while (static_cast<M2StateCheck_StateCheck__opaque> ((*s))->stack != NULL)
    {
      t = static_cast<M2StateCheck_StateCheck__opaque> ((*s))->stack;
      static_cast<M2StateCheck_StateCheck__opaque> ((*s))->stack = t->stack;
      Dispose (&t);
    }
  Dispose (reinterpret_cast<M2StateCheck_StateCheck__opaque *> (&(*s)));
}


/*
   PushState - duplicates the StateCheck s and chains the new copy to s.
               Return the copy.
*/

extern "C" void M2StateCheck_PushState (M2StateCheck_StateCheck *s)
{
  M2StateCheck_StateCheck__opaque copy;

  copy = static_cast<M2StateCheck_StateCheck__opaque> (M2StateCheck_InitState ());
  copy->state = static_cast<M2StateCheck_StateCheck__opaque> ((*s))->state;
  copy->stack = static_cast<M2StateCheck_StateCheck__opaque> ((*s));
  (*s) = static_cast<M2StateCheck_StateCheck> (copy);
}


/*
   PopState - pops the current state.
*/

extern "C" void M2StateCheck_PopState (M2StateCheck_StateCheck *s)
{
  M2StateCheck_StateCheck__opaque t;

  t = static_cast<M2StateCheck_StateCheck__opaque> ((*s));
  (*s) = static_cast<M2StateCheck_StateCheck> (static_cast<M2StateCheck_StateCheck__opaque> ((*s))->stack);
  t->stack = static_cast<M2StateCheck_StateCheck__opaque> (NULL);
  Dispose (&t);
}


/*
   InclVar - s := s + {var}.
*/

extern "C" void M2StateCheck_InclVar (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state |= (1 << (M2StateCheck_var-M2StateCheck_const ));
}


/*
   InclConst - s := s + {const}.
*/

extern "C" void M2StateCheck_InclConst (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state |= (1 << (M2StateCheck_const-M2StateCheck_const ));
}


/*
   InclType - s := s + {type}.
*/

extern "C" void M2StateCheck_InclType (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state |= (1 << (M2StateCheck_type-M2StateCheck_const ));
}


/*
   InclConstFunc - s := s + {constfunc}.
*/

extern "C" void M2StateCheck_InclConstFunc (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state |= (1 << (M2StateCheck_constfunc-M2StateCheck_const ));
}


/*
   InclVarParam - s := s + {varparam}.
*/

extern "C" void M2StateCheck_InclVarParam (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state |= (1 << (M2StateCheck_varparam-M2StateCheck_const ));
}


/*
   InclConstructor - s := s + {constructor}.
*/

extern "C" void M2StateCheck_InclConstructor (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state |= (1 << (M2StateCheck_constructor-M2StateCheck_const ));
}


/*
   ExclVar - s := s - {var}.
*/

extern "C" void M2StateCheck_ExclVar (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state &= (~(1 << (M2StateCheck_var-M2StateCheck_const )));
}


/*
   ExclConst - s := s - {const}.
*/

extern "C" void M2StateCheck_ExclConst (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state &= (~(1 << (M2StateCheck_const-M2StateCheck_const )));
}


/*
   ExclType - s := s - {type}.
*/

extern "C" void M2StateCheck_ExclType (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state &= (~(1 << (M2StateCheck_type-M2StateCheck_const )));
}


/*
   ExclConstFunc - s := s - {constfunc}.
*/

extern "C" void M2StateCheck_ExclConstFunc (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state &= (~(1 << (M2StateCheck_constfunc-M2StateCheck_const )));
}


/*
   ExclVarParam - s := s - {varparam}.
*/

extern "C" void M2StateCheck_ExclVarParam (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state &= (~(1 << (M2StateCheck_varparam-M2StateCheck_const )));
}


/*
   ExclConstructor - s := s - {varparam}.
*/

extern "C" void M2StateCheck_ExclConstructor (M2StateCheck_StateCheck s)
{
  static_cast<M2StateCheck_StateCheck__opaque> (s)->state &= (~(1 << (M2StateCheck_constructor-M2StateCheck_const )));
}


/*
   CheckQualident - checks to see that qualident sym is allowed in the state s.
*/

extern "C" void M2StateCheck_CheckQualident (unsigned int tok, M2StateCheck_StateCheck s, unsigned int sym)
{
  if (sym == SymbolTable_NulSym)
    {}  /* empty.  */
  else if (SymbolTable_IsType (sym))
    {
      /* avoid dangling else.  */
      if (((((1 << (M2StateCheck_constfunc-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)) || ((((1 << (M2StateCheck_constructor-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)))
        {}  /* empty.  */
      /* Ok.  */
      else if ((((1 << (M2StateCheck_const-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0))
        {
          /* avoid dangling else.  */
          GenerateError (tok, static_cast<M2StateCheck_StateCheck__opaque> (s), sym);
        }
    }
  else if (SymbolTable_IsConst (sym))
    {
      /* avoid dangling else.  */
      if (((((1 << (M2StateCheck_constfunc-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)) || ((((1 << (M2StateCheck_constructor-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)))
        {}  /* empty.  */
      /* Ok.  */
      else if (((((1 << (M2StateCheck_var-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)) || ((((1 << (M2StateCheck_type-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)))
        {
          /* avoid dangling else.  */
          GenerateError (tok, static_cast<M2StateCheck_StateCheck__opaque> (s), sym);
        }
    }
  else if (SymbolTable_IsVar (sym))
    {
      /* avoid dangling else.  */
      if ((((1 << (M2StateCheck_constfunc-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0))
        {}  /* empty.  */
      /* Ok.  */
      else if ((((((1 << (M2StateCheck_const-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)) || ((((1 << (M2StateCheck_type-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0))) || ((((1 << (M2StateCheck_var-M2StateCheck_const)) & (static_cast<M2StateCheck_StateCheck__opaque> (s)->state)) != 0)))
        {
          /* avoid dangling else.  */
          GenerateError (tok, static_cast<M2StateCheck_StateCheck__opaque> (s), sym);
        }
    }
}

extern "C" void _M2_M2StateCheck_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  init ();
}

extern "C" void _M2_M2StateCheck_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
