/* do not edit automatically generated by mc from P3SymBuild.  */
/* P3SymBuild.def pass 3 symbol creation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_P3SymBuild_H)
#   define _P3SymBuild_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif


#   if defined (_P3SymBuild_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

EXTERN void P3SymBuild_P3StartBuildDefModule (void);
EXTERN void P3SymBuild_P3EndBuildDefModule (void);
EXTERN void P3SymBuild_P3StartBuildImpModule (void);
EXTERN void P3SymBuild_P3EndBuildImpModule (void);
EXTERN void P3SymBuild_P3StartBuildProgModule (void);
EXTERN void P3SymBuild_P3EndBuildProgModule (void);

/*
   CheckCanBeImported - checks to see that it is legal to import, Sym, from, ModSym.
*/

EXTERN void P3SymBuild_CheckCanBeImported (unsigned int ModSym, unsigned int Sym);

/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

EXTERN void P3SymBuild_StartBuildInnerModule (void);

/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

EXTERN void P3SymBuild_EndBuildInnerModule (void);

/*
   CheckImportListOuterModule - checks to see that all identifiers are
                                exported from the definition module.

                                The Stack is expected:

                                Entry           OR    Entry

                         Ptr ->                Ptr ->
                                +------------+        +-----------+
                                | #          |        | #         |
                                |------------|        |-----------|
                                | Id1        |        | Id1       |
                                |------------|        |-----------|
                                .            .        .           .
                                .            .        .           .
                                .            .        .           .
                                |------------|        |-----------|
                                | Id#        |        | Id#       |
                                |------------|        |-----------|
                                | ImportTok  |        | Ident     |
                                |------------|        |-----------|

                                IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                                                      Error Condition
                                Exit

                                All above stack discarded
*/

EXTERN void P3SymBuild_CheckImportListOuterModule (void);

/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |              Empty
                           |------------|

*/

EXTERN void P3SymBuild_BuildProcedureHeading (void);

/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
*/

EXTERN void P3SymBuild_StartBuildProcedure (void);

/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:


                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

EXTERN void P3SymBuild_EndBuildProcedure (void);

/*
   EndBuildForward -
*/

EXTERN void P3SymBuild_EndBuildForward (void);

/*
   BuildSubrange - Builds a Subrange type Symbol.

                      Stack

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | High       |
                      |------------|
                      | Low        |                       <- Ptr
                      |------------|
*/

EXTERN void P3SymBuild_BuildSubrange (void);

/*
   BuildNulName - Pushes a NulKey onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulKey     |
                                           |------------|
*/

EXTERN void P3SymBuild_BuildNulName (void);

/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->                                      <- Ptr
                +------------+        +------------+
                | Name       |        | Sym        |
                |------------+        |------------|
*/

EXTERN void P3SymBuild_BuildConst (void);

/*
   BuildVarAtAddress - updates the symbol table entry of, variable sym, to be declared
                       at address, address.

                       Stack

                       Entry                 Exit

                Ptr ->
                       +--------------+
                       | Expr | EType |                         <- Ptr
                       |--------------+        +--------------+
                       | name | SType |        | name | SType |
                       |--------------+        |--------------|
*/

EXTERN void P3SymBuild_BuildVarAtAddress (void);

/*
   BuildOptArgInitializer - assigns the constant value symbol, const, to be the
                            initial value of the optional parameter should it be
                            absent.

                            Ptr ->
                                   +------------+
                                   | const      |
                                   |------------|                      <- Ptr
*/

EXTERN void P3SymBuild_BuildOptArgInitializer (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
