/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern1 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case AND:
      return pattern0 (x1, pnum_clobbers); /* [-1, 0] */

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 1;

    default:
      return -1;
    }
}

int
pattern16 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern25 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern27 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode)
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x1) != E_V4DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern36 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 8
      || GET_MODE (x3) != E_XFmode)
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 9
      || GET_MODE (x5) != E_XFmode)
    return -1;
  x6 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x6) != CLOBBER)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != REG
      || REGNO (x7) != 10
      || GET_MODE (x7) != E_XFmode)
    return -1;
  x8 = XVECEXP (x1, 0, 4);
  if (GET_CODE (x8) != CLOBBER)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_CODE (x9) != REG
      || REGNO (x9) != 11
      || GET_MODE (x9) != E_XFmode)
    return -1;
  x10 = XVECEXP (x1, 0, 5);
  if (GET_CODE (x10) != CLOBBER)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != REG
      || REGNO (x11) != 12
      || GET_MODE (x11) != E_XFmode)
    return -1;
  x12 = XVECEXP (x1, 0, 6);
  if (GET_CODE (x12) != CLOBBER)
    return -1;
  x13 = XEXP (x12, 0);
  if (GET_CODE (x13) != REG
      || REGNO (x13) != 13
      || GET_MODE (x13) != E_XFmode)
    return -1;
  x14 = XVECEXP (x1, 0, 7);
  if (GET_CODE (x14) != CLOBBER)
    return -1;
  x15 = XEXP (x14, 0);
  if (GET_CODE (x15) != REG
      || REGNO (x15) != 14
      || GET_MODE (x15) != E_XFmode)
    return -1;
  x16 = XVECEXP (x1, 0, 8);
  if (GET_CODE (x16) != CLOBBER)
    return -1;
  x17 = XEXP (x16, 0);
  if (GET_CODE (x17) != REG
      || REGNO (x17) != 15
      || GET_MODE (x17) != E_XFmode)
    return -1;
  return 0;
}

int
pattern47 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (x1))
    {
    case E_QImode:
      if (!nonimmediate_operand (operands[1], E_QImode)
          || !general_operand (operands[2], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !general_operand (operands[2], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !x86_64_general_operand (operands[2], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !x86_64_general_operand (operands[2], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern55 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_CCmode)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], i1))
    return -1;
  return 0;
}

int
pattern59 (rtx x1, int *pnum_clobbers, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i1))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern63 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], i1))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern69 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case ASHIFT:
      if (GET_MODE (x2) != E_TImode)
        return -1;
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != ZERO_EXTEND
          || GET_MODE (x3) != E_TImode)
        return -1;
      x4 = XEXP (x2, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 64]
          || !nonimmediate_operand (operands[0], E_TImode)
          || GET_MODE (x1) != E_TImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_TImode
          || !nonimmediate_operand (operands[1], E_TImode)
          || !const_scalar_int_operand (operands[3], E_TImode))
        return -1;
      x6 = XEXP (x3, 0);
      operands[2] = x6;
      if (!nonimmediate_operand (operands[2], E_DImode))
        return -1;
      return 0;

    case ZERO_EXTEND:
      x3 = XEXP (x2, 0);
      operands[2] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          if (!nonimmediate_operand (operands[0], E_TImode)
              || GET_MODE (x1) != E_TImode)
            return -1;
          x5 = XEXP (x1, 0);
          if (GET_MODE (x5) != E_TImode
              || !nonimmediate_operand (operands[1], E_TImode)
              || !const_scalar_int_operand (operands[3], E_TImode)
              || GET_MODE (x2) != E_TImode
              || !nonimmediate_operand (operands[2], E_DImode))
            return -1;
          return 1;

        case E_DImode:
          if (!nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x1) != E_DImode)
            return -1;
          x5 = XEXP (x1, 0);
          if (GET_MODE (x5) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode)
              || !const_int_operand (operands[3], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !nonimmediate_operand (operands[2], E_SImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern100 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 2);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V2QImode:
      return pattern97 (x1, 
E_V2QImode); /* [-1, 0] */

    case E_V4QImode:
      res = pattern98 (x1, 
E_V4QImode);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    case E_V8QImode:
      if (!memory_operand (operands[0], E_V8QImode)
          || GET_MODE (x1) != E_V8QImode
          || GET_MODE (x2) != E_V8QImode)
        return -1;
      res = pattern99 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    case E_V4HImode:
      res = pattern98 (x1, 
E_V4HImode);
      if (res >= 0)
        return res + 6; /* [6, 7] */
      return -1;

    case E_V2HImode:
      if (pattern97 (x1, 
E_V2HImode) != 0)
        return -1;
      return 8;

    case E_V2SImode:
      if (pattern97 (x1, 
E_V2SImode) != 0)
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern115 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 0;

    case E_SImode:
      if (!nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern124 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern131 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern139 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern146 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern148 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern146 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern146 (x1, 
E_V8SImode, 
E_QImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern146 (x1, 
E_V4SImode, 
E_QImode) != 0)
        return -1;
      return 2;

    case E_V8DImode:
      if (pattern146 (x1, 
E_V8DImode, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_V4DImode:
      if (pattern146 (x1, 
E_V4DImode, 
E_QImode) != 0)
        return -1;
      return 4;

    case E_V2DImode:
      if (pattern146 (x1, 
E_V2DImode, 
E_QImode) != 0)
        return -1;
      return 5;

    case E_V64QImode:
      if (pattern146 (x1, 
E_V64QImode, 
E_DImode) != 0)
        return -1;
      return 6;

    case E_V16QImode:
      if (pattern146 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 7;

    case E_V32QImode:
      if (pattern146 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 8;

    case E_V32HImode:
      if (pattern146 (x1, 
E_V32HImode, 
E_SImode) != 0)
        return -1;
      return 9;

    case E_V16HImode:
      if (pattern147 (x1, 
E_V16HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (pattern146 (x1, 
E_V8HImode, 
E_QImode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern161 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern152 (x3, 
E_V16SImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern152 (x3, 
E_V8SImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern152 (x3, 
E_V4SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern170 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V4SImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  if (!register_operand (operands[1], E_V4SImode))
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  operands[2] = x3;
  if (!register_operand (operands[2], E_V4SImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  operands[3] = x4;
  if (!vector_operand (operands[3], E_V4SImode))
    return -1;
  return 0;
}

int
pattern178 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SImode:
      return pattern172 (x3, 
E_V8SImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern172 (x3, 
E_V4SImode) != 0)
        return -1;
      return 1;

    case E_V16SImode:
      if (pattern172 (x3, 
E_V16SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern185 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !const0_operand (operands[3], i1)
      || !vector_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern191 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i3))
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern195 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || !ternlog_operand (operands[1], E_V32HFmode))
        return -1;
      return 0;

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || !ternlog_operand (operands[1], E_V16HFmode))
        return -1;
      return 1;

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || !ternlog_operand (operands[1], E_V8HFmode))
        return -1;
      return 2;

    case E_V32BFmode:
      if (!register_operand (operands[0], E_V32BFmode)
          || !ternlog_operand (operands[1], E_V32BFmode))
        return -1;
      return 3;

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || !ternlog_operand (operands[1], E_V16BFmode))
        return -1;
      return 4;

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || !ternlog_operand (operands[1], E_V8BFmode))
        return -1;
      return 5;

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || !ternlog_operand (operands[1], E_V16SFmode))
        return -1;
      return 6;

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !ternlog_operand (operands[1], E_V8SFmode))
        return -1;
      return 7;

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || !ternlog_operand (operands[1], E_V4SFmode))
        return -1;
      return 8;

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || !ternlog_operand (operands[1], E_V8DFmode))
        return -1;
      return 9;

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !ternlog_operand (operands[1], E_V4DFmode))
        return -1;
      return 10;

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || !ternlog_operand (operands[1], E_V2DFmode))
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern204 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  switch (GET_CODE (x6))
    {
    case REG:
    case SUBREG:
    case MEM:
      return pattern202 (x4); /* [-1, 7] */

    case ASHIFT:
      x7 = XEXP (x4, 0);
      operands[0] = x7;
      x8 = XEXP (x6, 0);
      operands[1] = x8;
      x9 = XEXP (x6, 1);
      operands[2] = x9;
      if (!const_int_operand (operands[2], E_QImode))
        return -1;
      x10 = XEXP (x5, 1);
      operands[3] = x10;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern203 (x5, 
E_DImode) != 0)
            return -1;
          return 8;

        case E_TImode:
          if (pattern203 (x5, 
E_TImode) != 0)
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern214 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x4, 1);
  operands[2] = x6;
  x7 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x7))
    {
    case CLOBBER:
      x8 = XEXP (x7, 0);
      if (GET_CODE (x8) != REG
          || REGNO (x8) != 17
          || GET_MODE (x8) != E_CCmode)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          return pattern211 (x4, 
E_DImode); /* [-1, 0] */

        case E_TImode:
          if (pattern211 (x4, 
E_TImode) != 0)
            return -1;
          return 1;

        case E_QImode:
          if (pattern211 (x4, 
E_QImode) != 0)
            return -1;
          return 2;

        case E_HImode:
          if (pattern211 (x4, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_SImode:
          if (pattern211 (x4, 
E_SImode) != 0)
            return -1;
          return 4;

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern213 (x1) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern231 (rtx x1, machine_mode i1, unsigned int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != CLOBBER)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != i2
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern237 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!mask_reg_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !mask_reg_operand (operands[1], i1)
      || !mask_reg_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern243 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  x7 = XEXP (x2, 1);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x7;
      x8 = XEXP (x2, 2);
      operands[3] = x8;
      return 0;

    case ZERO_EXTEND:
      if (GET_MODE (x7) != E_DImode)
        return -1;
      x8 = XEXP (x2, 2);
      if (GET_CODE (x8) != ZERO_EXTEND
          || GET_MODE (x8) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern258 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x2;
      return 0;

    case STRICT_LOW_PART:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      x4 = XEXP (x1, 1);
      res = pattern39 (x4);
      if (res >= 0)
        return res + 1; /* [1, 2] */
      return -1;

    default:
      return -1;
    }
}

int
pattern264 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return pattern263 (); /* [-1, 2] */
}

int
pattern269 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case SUBREG:
      if (pnum_clobbers == NULL
          || maybe_ne (SUBREG_BYTE (x2), 0)
          || GET_MODE (x2) != E_QImode)
        return -1;
      x3 = XEXP (x2, 0);
      switch (GET_CODE (x3))
        {
        case AND:
          x4 = XEXP (x3, 0);
          operands[2] = x4;
          if (!int248_register_operand (operands[2], E_VOIDmode))
            return -1;
          return pattern268 (x1); /* [-1, 1] */

        case PLUS:
          x4 = XEXP (x3, 0);
          operands[2] = x4;
          if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
            return -1;
          res = pattern268 (x1);
          if (res >= 0)
            return res + 2; /* [2, 3] */
          return -1;

        case MINUS:
          x4 = XEXP (x3, 0);
          operands[3] = x4;
          if (!const_int_operand (operands[3], E_VOIDmode))
            return -1;
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (!int_nonimmediate_operand (operands[2], E_VOIDmode))
            return -1;
          res = pattern2 (x1);
          if (res >= 0)
            return res + 4; /* [4, 5] */
          return -1;

        default:
          return -1;
        }

    case CONST_INT:
      return 6;

    default:
      return -1;
    }
}

int
pattern291 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  x5 = XEXP (x2, 1);
  switch (GET_CODE (x5))
    {
    case LTU:
    case UNLT:
      operands[4] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x5, 0);
      operands[3] = x7;
      if (!flags_reg_operand (operands[3], E_VOIDmode))
        return -1;
      return 0;

    case EQ:
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x5, 0);
      operands[3] = x7;
      if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern303 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_DImode
      || !register_operand (operands[0], E_DImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  if (!register_operand (operands[1], E_DImode))
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  operands[2] = x3;
  if (!register_mmxmem_operand (operands[2], E_DImode))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  operands[3] = x4;
  if (!const_0_to_255_mul_8_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern310 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_SImode
      || !nonimmediate_operand (operands[1], E_HImode)
      || !const0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern318 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !float_vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern323 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x2;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          return 0;

        case E_V16SImode:
          return 1;

        case E_V8DImode:
          return 2;

        case E_V16HImode:
          return 3;

        case E_V8SImode:
          return 4;

        case E_V4DImode:
          return 5;

        case E_V8HImode:
          return 6;

        case E_V4SImode:
          return 7;

        case E_V2DImode:
          return 8;

        default:
          return -1;
        }

    case VEC_SELECT:
      if (GET_MODE (x2) != E_V2SFmode)
        return -1;
      x3 = XEXP (x2, 1);
      if (GET_CODE (x3) != PARALLEL
          || XVECLEN (x3, 0) != 2)
        return -1;
      x4 = XVECEXP (x3, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x5 = XVECEXP (x3, 0, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DImode)
          || GET_MODE (x1) != E_V2DImode)
        return -1;
      x6 = XEXP (x2, 0);
      operands[1] = x6;
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern331 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      return pattern330 (x1, 
E_V8HImode); /* [-1, 0] */

    case E_V4SImode:
      if (pattern330 (x1, 
E_V4SImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern335 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != VEC_SELECT)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PARALLEL)
    return -1;
  x6 = XEXP (x2, 1);
  if (GET_CODE (x6) != i1)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != VEC_SELECT)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != PARALLEL)
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != PLUS)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != i1)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != VEC_SELECT)
    return -1;
  x12 = XEXP (x11, 1);
  if (GET_CODE (x12) != PARALLEL)
    return -1;
  x13 = XEXP (x9, 1);
  if (GET_CODE (x13) != i1)
    return -1;
  x14 = XEXP (x13, 0);
  if (GET_CODE (x14) != VEC_SELECT)
    return -1;
  x15 = XEXP (x14, 1);
  if (GET_CODE (x15) != PARALLEL)
    return -1;
  x16 = XEXP (x4, 0);
  operands[1] = x16;
  x17 = XEXP (x7, 0);
  if (!rtx_equal_p (x17, operands[1]))
    return -1;
  x18 = XEXP (x11, 0);
  if (!rtx_equal_p (x18, operands[1]))
    return -1;
  x19 = XEXP (x14, 0);
  if (!rtx_equal_p (x19, operands[1]))
    return -1;
  switch (XVECLEN (x5, 0))
    {
    case 4:
      x20 = XVECEXP (x5, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x21 = XVECEXP (x5, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x22 = XVECEXP (x5, 0, 2);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x23 = XVECEXP (x5, 0, 3);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 12]
          || XVECLEN (x8, 0) != 4)
        return -1;
      x24 = XVECEXP (x8, 0, 0);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x25 = XVECEXP (x8, 0, 1);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x26 = XVECEXP (x8, 0, 2);
      if (x26 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
        return -1;
      x27 = XVECEXP (x8, 0, 3);
      if (x27 != const_int_rtx[MAX_SAVED_CONST_INT + 13]
          || XVECLEN (x12, 0) != 4)
        return -1;
      x28 = XVECEXP (x12, 0, 0);
      if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x29 = XVECEXP (x12, 0, 1);
      if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x30 = XVECEXP (x12, 0, 2);
      if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
        return -1;
      x31 = XVECEXP (x12, 0, 3);
      if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x15, 0) != 4)
        return -1;
      x32 = XVECEXP (x15, 0, 0);
      if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x33 = XVECEXP (x15, 0, 1);
      if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x34 = XVECEXP (x15, 0, 2);
      if (x34 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
        return -1;
      x35 = XVECEXP (x15, 0, 3);
      if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 15]
          || pattern334 (x1, 
E_V4QImode, 
E_V4SImode, 
E_V16QImode) != 0)
        return -1;
      return 0;

    case 2:
      x20 = XVECEXP (x5, 0, 0);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x21 = XVECEXP (x5, 0, 1);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 4]
          || XVECLEN (x8, 0) != 2)
        return -1;
      x24 = XVECEXP (x8, 0, 0);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x25 = XVECEXP (x8, 0, 1);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 5]
          || XVECLEN (x12, 0) != 2)
        return -1;
      x28 = XVECEXP (x12, 0, 0);
      if (x28 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x29 = XVECEXP (x12, 0, 1);
      if (x29 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x15, 0) != 2)
        return -1;
      x32 = XVECEXP (x15, 0, 0);
      if (x32 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x33 = XVECEXP (x15, 0, 1);
      if (x33 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern334 (x1, 
E_V2HImode, 
E_V2DImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern374 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != CLOBBER)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17
      || GET_MODE (x2) != E_CCmode)
    return -1;
  return 0;
}

int
pattern378 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern383 (rtx x1, int i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != UNSPEC
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  return 0;
}

int
pattern388 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x1) != E_SFmode)
        return -1;
      return 0;

    case E_DFmode:
      if (!register_operand (operands[0], E_DFmode)
          || GET_MODE (x1) != E_DFmode)
        return -1;
      return 1;

    case E_XFmode:
      if (!register_operand (operands[0], E_XFmode)
          || GET_MODE (x1) != E_XFmode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern396 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (XINT (x1, 1) != i1
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 20
      || GET_MODE (x2) != E_V2DImode)
    return -1;
  return 0;
}

int
pattern404 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  switch (GET_CODE (x4))
    {
    case ASHIFT:
      x5 = XEXP (x4, 1);
      operands[3] = x5;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[2] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              return pattern400 (x1, 
E_DImode, 
E_SImode); /* [-1, 0] */

            case E_TImode:
              if (pattern400 (x1, 
E_TImode, 
E_DImode) != 0)
                return -1;
              return 1;

            default:
              return -1;
            }

        case SIGN_EXTEND:
          res = pattern402 (x1);
          if (res >= 0)
            return res + 2; /* [2, 3] */
          return -1;

        case ZERO_EXTEND:
          res = pattern402 (x1);
          if (res >= 0)
            return res + 4; /* [4, 5] */
          return -1;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[2] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern403 (x1, 
E_DImode, 
E_SImode) != 0)
            return -1;
          return 6;

        case E_TImode:
          if (pattern403 (x1, 
E_TImode, 
E_DImode) != 0)
            return -1;
          return 7;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern423 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !const0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern429 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern436 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x3, 0);
  operands[3] = x5;
  if (!int_nonimmediate_operand (operands[3], E_VOIDmode))
    return -1;
  x6 = XEXP (x2, 1);
  operands[1] = x6;
  x7 = XEXP (x1, 1);
  operands[2] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return 0;

    case E_HImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern446 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
      operands[3] = x3;
      x4 = XEXP (x1, 0);
      x5 = XEXP (x4, 0);
      operands[4] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      x7 = XEXP (x2, 0);
      operands[1] = x7;
      return pattern444 (x1); /* [-1, 1] */

    case MINUS:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_QImode)
        return -1;
      x8 = XEXP (x3, 0);
      if (GET_CODE (x8) != CONST_INT)
        return -1;
      x4 = XEXP (x1, 0);
      x6 = XEXP (x4, 1);
      if (!nonmemory_operand (x6, E_QImode))
        return -1;
      switch (XWINT (x8, 0))
        {
        case 64L:
          if (pattern445 (x1, 
E_DImode) != 0)
            return -1;
          return 2;

        case 32L:
          if (pattern445 (x1, 
E_SImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern461 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern467 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern460 (x1, 
E_V64QImode, 
E_DImode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern460 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern460 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern477 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1)
      || !register_operand (operands[5], i2))
    return -1;
  return 0;
}

int
pattern484 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  return 0;
}

int
pattern492 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
      operands[4] = x2;
      x3 = XEXP (x1, 1);
      operands[3] = x3;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return pattern491 (x1, 
E_V32HFmode, 
E_SImode); /* [-1, 0] */

        case E_V16HFmode:
          if (pattern491 (x1, 
E_V16HFmode, 
E_HImode) != 0)
            return -1;
          return 1;

        case E_V8HFmode:
          if (pattern491 (x1, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          return 2;

        case E_V16SFmode:
          if (pattern491 (x1, 
E_V16SFmode, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V8SFmode:
          if (pattern491 (x1, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          return 4;

        case E_V4SFmode:
          if (pattern491 (x1, 
E_V4SFmode, 
E_QImode) != 0)
            return -1;
          return 5;

        case E_V8DFmode:
          if (pattern491 (x1, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          return 6;

        case E_V4DFmode:
          if (pattern491 (x1, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          return 7;

        case E_V2DFmode:
          if (pattern491 (x1, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          return 8;

        case E_V16SImode:
          if (pattern128 (x1, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          return 9;

        case E_V8SImode:
          if (pattern128 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 10;

        case E_V4SImode:
          if (pattern128 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 11;

        case E_V8DImode:
          if (pattern128 (x1, 
E_V8DImode, 
E_QImode) != 0)
            return -1;
          return 12;

        case E_V4DImode:
          if (pattern128 (x1, 
E_V4DImode, 
E_QImode) != 0)
            return -1;
          return 13;

        case E_V2DImode:
          if (pattern128 (x1, 
E_V2DImode, 
E_QImode) != 0)
            return -1;
          return 14;

        case E_V64QImode:
          if (pattern128 (x1, 
E_V64QImode, 
E_DImode) != 0)
            return -1;
          return 15;

        case E_V16QImode:
          if (pattern128 (x1, 
E_V16QImode, 
E_HImode) != 0)
            return -1;
          return 16;

        case E_V32QImode:
          if (pattern128 (x1, 
E_V32QImode, 
E_SImode) != 0)
            return -1;
          return 17;

        case E_V32HImode:
          if (pattern128 (x1, 
E_V32HImode, 
E_SImode) != 0)
            return -1;
          return 18;

        case E_V16HImode:
          if (pattern128 (x1, 
E_V16HImode, 
E_HImode) != 0)
            return -1;
          return 19;

        case E_V8HImode:
          if (pattern128 (x1, 
E_V8HImode, 
E_QImode) != 0)
            return -1;
          return 20;

        case E_V32BFmode:
          if (pattern130 (x1, 
E_V32BFmode, 
E_SImode) != 0)
            return -1;
          return 21;

        case E_V16BFmode:
          if (pattern130 (x1, 
E_V16BFmode, 
E_HImode) != 0)
            return -1;
          return 22;

        case E_V8BFmode:
          if (pattern130 (x1, 
E_V8BFmode, 
E_QImode) != 0)
            return -1;
          return 23;

        default:
          return -1;
        }

    case CONST_INT:
      res = pattern132 (x1);
      if (res >= 0)
        return res + 24; /* [24, 26] */
      return -1;

    default:
      return -1;
    }
}

int
pattern523 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4SImode:
      if (!nonimmediate_operand (operands[1], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!nonimmediate_operand (operands[1], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern528 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !permvar_truncate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern533 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern531 (x1); /* [-1, 11] */

    case IOR:
      res = pattern531 (x1);
      if (res >= 0)
        return res + 12; /* [12, 23] */
      return -1;

    case XOR:
      res = pattern531 (x1);
      if (res >= 0)
        return res + 24; /* [24, 35] */
      return -1;

    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V64QImode:
          if (pattern532 (x1, 
E_V64QImode) != 0)
            return -1;
          return 36;

        case E_V32QImode:
          if (pattern532 (x1, 
E_V32QImode) != 0)
            return -1;
          return 37;

        case E_V16QImode:
          if (pattern532 (x1, 
E_V16QImode) != 0)
            return -1;
          return 38;

        case E_V32HImode:
          if (pattern532 (x1, 
E_V32HImode) != 0)
            return -1;
          return 39;

        case E_V16HImode:
          if (pattern532 (x1, 
E_V16HImode) != 0)
            return -1;
          return 40;

        case E_V8HImode:
          if (pattern532 (x1, 
E_V8HImode) != 0)
            return -1;
          return 41;

        case E_V16SImode:
          if (pattern532 (x1, 
E_V16SImode) != 0)
            return -1;
          return 42;

        case E_V8SImode:
          if (pattern532 (x1, 
E_V8SImode) != 0)
            return -1;
          return 43;

        case E_V4SImode:
          if (pattern532 (x1, 
E_V4SImode) != 0)
            return -1;
          return 44;

        case E_V8DImode:
          if (pattern532 (x1, 
E_V8DImode) != 0)
            return -1;
          return 45;

        case E_V4DImode:
          if (pattern532 (x1, 
E_V4DImode) != 0)
            return -1;
          return 46;

        case E_V2DImode:
          if (pattern532 (x1, 
E_V2DImode) != 0)
            return -1;
          return 47;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern545 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XVECEXP (x4, 0, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17
          || GET_MODE (x7) != E_CCmode)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x4) != E_SImode
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          return 0;

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x4) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          return 1;

        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x4) != E_HImode
              || !nonimmediate_operand (operands[1], E_HImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x6, 0) != 1
          || XINT (x6, 1) != 38)
        return -1;
      res = pattern544 (x1);
      if (res >= 0)
        return res + 3; /* [3, 4] */
      return -1;

    default:
      return -1;
    }
}

int
pattern559 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (maybe_ne (SUBREG_BYTE (x1), 0)
      || GET_MODE (x1) != E_QImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_CODE (x2))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x2;
      x3 = XEXP (x2, 1);
      if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x4 = XEXP (x2, 2);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      return 0;

    default:
      return -1;
    }
}

int
pattern568 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern573 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  if (!memory_operand (operands[2], E_DImode))
    return -1;
  x8 = XVECEXP (x1, 0, 2);
  x9 = XEXP (x8, 0);
  operands[3] = x9;
  if (!scratch_operand (operands[3], E_DImode))
    return -1;
  return pattern388 (x4); /* [-1, 2] */
}

int
pattern582 (rtx x1, rtx_code i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i2)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern587 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != USE)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x2, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern221 (x7, 
E_V8HFmode, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (GET_MODE (x7) != E_SFmode)
        return -1;
      return 1;

    case E_DFmode:
      if (GET_MODE (x7) != E_DFmode)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern594 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SUBREG
      || maybe_ne (SUBREG_BYTE (x2), 0))
    return -1;
  x3 = XVECEXP (x1, 0, 0);
  operands[1] = x3;
  return pattern593 (x1); /* [-1, 2] */
}

int
pattern598 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  if (!commutative_operator (x2, E_VOIDmode))
    return -1;
  operands[3] = x2;
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  if (!memory_operand (operands[2], E_VOIDmode))
    return -1;
  x4 = XEXP (x2, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  x5 = XEXP (x1, 0);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  return 0;
}

int
pattern605 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i2)
      || !const_int_operand (operands[2], E_QImode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[3] = x4;
  if (!nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern612 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern618 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern623 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonmemory_operand (operands[2], E_QImode))
    return -1;
  return 0;
}

int
pattern629 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  operands[3] = x2;
  x3 = XEXP (x1, 0);
  x4 = XVECEXP (x3, 0, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HImode:
          return 0;

        case E_V16SImode:
          return 1;

        case E_V8DImode:
          return 2;

        case E_V16HImode:
          return 3;

        case E_V8SImode:
          return 4;

        case E_V4DImode:
          return 5;

        case E_V8HImode:
          return 6;

        case E_V4SImode:
          return 7;

        case E_V2DImode:
          return 8;

        default:
          return -1;
        }

    case VEC_SELECT:
      if (GET_MODE (x4) != E_V2SFmode)
        return -1;
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != PARALLEL
          || XVECLEN (x5, 0) != 2)
        return -1;
      x6 = XVECEXP (x5, 0, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XVECEXP (x5, 0, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DImode)
          || GET_MODE (x1) != E_V2DImode
          || GET_MODE (x3) != E_V2DImode)
        return -1;
      x8 = XEXP (x4, 0);
      operands[1] = x8;
      if (!nonimmediate_operand (operands[1], E_V4SFmode)
          || !nonimm_or_0_operand (operands[2], E_V2DImode)
          || !register_operand (operands[3], E_QImode))
        return -1;
      return 9;

    default:
      return -1;
    }
}

int
pattern647 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 2);
  if (XWINT (x3, 0) != 1L)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  operands[3] = x4;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern646 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern646 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern646 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern655 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern661 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  operands[2] = x2;
  x3 = XVECEXP (x1, 0, 2);
  x4 = XEXP (x3, 0);
  operands[3] = x4;
  x5 = XEXP (x3, 1);
  operands[4] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V8SFmode:
      return pattern659 (x1, 
E_V8SImode, 
E_V8SFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern659 (x1, 
E_V4SImode, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V4DFmode:
      if (pattern659 (x1, 
E_V4DImode, 
E_V4DFmode) != 0)
        return -1;
      return 2;

    case E_V2DFmode:
      if (pattern659 (x1, 
E_V2DImode, 
E_V2DFmode) != 0)
        return -1;
      return 3;

    case E_V32QImode:
      if (pattern660 (x1, 
E_V32QImode) != 0)
        return -1;
      return 4;

    case E_V16QImode:
      if (pattern660 (x1, 
E_V16QImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern669 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  return 0;
}

int
pattern681 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (XVECLEN (x2, 0) != 1
      || XINT (x2, 1) != 110)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
      || !register_operand (operands[0], i2))
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern687 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !general_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern691 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  x7 = XEXP (x6, 0);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
      return 0;

    case ZERO_EXTRACT:
      return 1;

    default:
      return -1;
    }
}

int
pattern696 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern704 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC_VOLATILE
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != i1
      || GET_MODE (x5) != E_DImode
      || !register_operand (operands[0], E_DImode))
    return -1;
  x6 = XVECEXP (x3, 0, 0);
  operands[2] = x6;
  if (!register_operand (operands[2], E_SImode))
    return -1;
  x7 = XEXP (x4, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_DImode))
    return -1;
  x8 = XVECEXP (x5, 0, 0);
  if (!rtx_equal_p (x8, operands[2]))
    return -1;
  return 0;
}

int
pattern711 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  if (!register_operand (operands[0], E_SImode))
    return -1;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  x8 = XVECEXP (x1, 0, 1);
  x9 = XEXP (x8, 0);
  operands[2] = x9;
  if (!scratch_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern720 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !const_scalar_int_operand (operands[3], i2))
    return -1;
  x6 = XEXP (x3, 1);
  if (GET_MODE (x6) != i2)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1
      || !x86_64_hilo_general_operand (operands[2], i1)
      || !nonimmediate_operand (operands[0], i1))
    return -1;
  x8 = XVECEXP (x1, 0, 1);
  x9 = XEXP (x8, 1);
  if (GET_MODE (x9) != i1)
    return -1;
  return 0;
}

int
pattern728 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != 2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (!plusminuslogic_operator (x3, i1))
    return -1;
  operands[3] = x3;
  x4 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x4) != CLOBBER)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XEXP (x3, 1);
  operands[2] = x6;
  if (!nonmemory_operand (operands[2], i1)
      || pattern727 (x2) != 0)
    return -1;
  return 0;
}

int
pattern738 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonmemory_operand (operands[2], i2))
    return -1;
  return 0;
}

int
pattern744 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !sse_comparison_operator (operands[3], i1)
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern749 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !x86_64_immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern759 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern768 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  if (XWINT (x2, 0) != 1L)
    return -1;
  x3 = XEXP (x1, 0);
  x4 = XEXP (x3, 0);
  x5 = XVECEXP (x4, 0, 0);
  operands[1] = x5;
  x6 = XVECEXP (x4, 0, 1);
  operands[2] = x6;
  x7 = XEXP (x3, 1);
  operands[3] = x7;
  x8 = XEXP (x3, 2);
  operands[4] = x8;
  if (!register_operand (operands[4], E_QImode))
    return -1;
  x9 = XEXP (x1, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      return pattern767 (x1, 
E_V8HFmode); /* [-1, 0] */

    case E_V4SFmode:
      if (pattern767 (x1, 
E_V4SFmode) != 0)
        return -1;
      return 1;

    case E_V2DFmode:
      if (pattern767 (x1, 
E_V2DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern779 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern786 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i2))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  operands[2] = x2;
  if (!register_operand (operands[2], i1))
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (!rtx_equal_p (x3, operands[0]))
    return -1;
  return 0;
}

int
pattern797 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || !sse_comparison_operator (operands[3], i1)
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern804 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x1, 1);
  if (XVECLEN (x4, 0) < 1)
    return -1;
  operands[3] = x4;
  x5 = XVECEXP (x4, 0, 0);
  operands[4] = x5;
  if (!const_int_operand (operands[4], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      return pattern800 (x1, 
E_V32QImode, 
E_V64QImode); /* [-1, 0] */

    case E_V64QImode:
      if (pattern800 (x1, 
E_V64QImode, 
E_V128QImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern801 (x1, 
E_V16QImode, 
E_V32QImode) != 0)
        return -1;
      return 2;

    case E_V32HImode:
      if (pattern800 (x1, 
E_V32HImode, 
E_V64HImode) != 0)
        return -1;
      return 3;

    case E_V16HImode:
      if (pattern800 (x1, 
E_V16HImode, 
E_V32HImode) != 0)
        return -1;
      return 4;

    case E_V8HImode:
      if (pattern801 (x1, 
E_V8HImode, 
E_V16HImode) != 0)
        return -1;
      return 5;

    case E_V16SImode:
      if (pattern802 (x1, 
E_V16SImode, 
E_V32SImode) != 0)
        return -1;
      return 6;

    case E_V8SImode:
      if (pattern802 (x1, 
E_V8SImode, 
E_V16SImode) != 0)
        return -1;
      return 7;

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x1) != E_V4SImode
          || GET_MODE (x2) != E_V8SImode
          || !const0_operand (operands[2], E_V4SImode))
        return -1;
      return 8;

    case E_V8DImode:
      if (pattern803 (x1, 
E_V8DImode, 
E_V16DImode) != 0)
        return -1;
      return 9;

    case E_V4DImode:
      if (pattern803 (x1, 
E_V4DImode, 
E_V8DImode) != 0)
        return -1;
      return 10;

    case E_V2DImode:
      if (pattern803 (x1, 
E_V2DImode, 
E_V4DImode) != 0)
        return -1;
      return 11;

    case E_V32HFmode:
      if (pattern803 (x1, 
E_V32HFmode, 
E_V64HFmode) != 0)
        return -1;
      return 12;

    case E_V16HFmode:
      if (pattern803 (x1, 
E_V16HFmode, 
E_V32HFmode) != 0)
        return -1;
      return 13;

    case E_V8HFmode:
      if (pattern803 (x1, 
E_V8HFmode, 
E_V16HFmode) != 0)
        return -1;
      return 14;

    case E_V32BFmode:
      if (pattern803 (x1, 
E_V32BFmode, 
E_V64BFmode) != 0)
        return -1;
      return 15;

    case E_V16BFmode:
      if (pattern803 (x1, 
E_V16BFmode, 
E_V32BFmode) != 0)
        return -1;
      return 16;

    case E_V8BFmode:
      if (pattern803 (x1, 
E_V8BFmode, 
E_V16BFmode) != 0)
        return -1;
      return 17;

    case E_V16SFmode:
      if (pattern803 (x1, 
E_V16SFmode, 
E_V32SFmode) != 0)
        return -1;
      return 18;

    case E_V8SFmode:
      if (pattern803 (x1, 
E_V8SFmode, 
E_V16SFmode) != 0)
        return -1;
      return 19;

    case E_V4SFmode:
      if (pattern803 (x1, 
E_V4SFmode, 
E_V8SFmode) != 0)
        return -1;
      return 20;

    case E_V8DFmode:
      if (pattern803 (x1, 
E_V8DFmode, 
E_V16DFmode) != 0)
        return -1;
      return 21;

    case E_V4DFmode:
      if (pattern803 (x1, 
E_V4DFmode, 
E_V8DFmode) != 0)
        return -1;
      return 22;

    case E_V2DFmode:
      if (pattern803 (x1, 
E_V2DFmode, 
E_V4DFmode) != 0)
        return -1;
      return 23;

    default:
      return -1;
    }
}

int
pattern844 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !register_operand (operands[3], i1)
      || !nonmemory_operand (operands[4], i1)
      || !const0_operand (operands[5], i1))
    return -1;
  return 0;
}

int
pattern848 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern852 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern857 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !register_operand (operands[1], i1)
      || !const_0_to_15_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern860 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[2], i2)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern868 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern875 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 0);
  switch (GET_MODE (x3))
    {
    case E_DFmode:
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern882 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_SImode:
      if (!nonimmediate_operand (operands[2], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!nonimmediate_operand (operands[2], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern896 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[3], E_QImode))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  switch (XVECLEN (x4, 0))
    {
    case 8:
      x5 = XVECEXP (x4, 0, 0);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x7 = XVECEXP (x4, 0, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x8 = XVECEXP (x4, 0, 3);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x9 = XVECEXP (x4, 0, 4);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x10 = XVECEXP (x4, 0, 5);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x11 = XVECEXP (x4, 0, 6);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x12 = XVECEXP (x4, 0, 7);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || GET_MODE (x3) != E_V8QImode
          || !register_operand (operands[1], E_V16QImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HImode:
          return pattern137 (x1, 
E_V8HImode); /* [-1, 0] */

        case E_V8SImode:
          if (pattern137 (x1, 
E_V8SImode) != 0)
            return -1;
          return 1;

        case E_V8DImode:
          if (pattern137 (x1, 
E_V8DImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case 4:
      x5 = XVECEXP (x4, 0, 0);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x7 = XVECEXP (x4, 0, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x8 = XVECEXP (x4, 0, 3);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SImode:
          res = pattern895 (x1, 
E_V4SImode);
          if (res >= 0)
            return res + 3; /* [3, 4] */
          return -1;

        case E_V4DImode:
          res = pattern895 (x1, 
E_V4DImode);
          if (res >= 0)
            return res + 5; /* [5, 6] */
          return -1;

        default:
          return -1;
        }

    case 2:
      x5 = XVECEXP (x4, 0, 0);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DImode)
          || GET_MODE (x1) != E_V2DImode
          || GET_MODE (x2) != E_V2DImode
          || !nonimm_or_0_operand (operands[2], E_V2DImode))
        return -1;
      switch (GET_MODE (x3))
        {
        case E_V2QImode:
          if (!register_operand (operands[1], E_V16QImode))
            return -1;
          return 7;

        case E_V2HImode:
          if (!register_operand (operands[1], E_V8HImode))
            return -1;
          return 8;

        case E_V2SImode:
          if (!register_operand (operands[1], E_V4SImode))
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern942 (rtx x1, machine_mode i1, unsigned int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != CLOBBER)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != i2
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern947 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!immediate_operand (operands[1], i1)
      || GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 0);
  operands[2] = x2;
  if (!mask_reg_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (!rtx_equal_p (x3, operands[0]))
    return -1;
  return 0;
}

int
pattern954 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || !register_operand (operands[1], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || !register_operand (operands[1], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || !register_operand (operands[1], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || !register_operand (operands[1], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern960 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[3] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x1) != E_HImode)
        return -1;
      x3 = XEXP (x1, 0);
      if (GET_MODE (x3) != E_HImode
          || !register_operand (operands[3], E_HImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16QImode:
          if (!nonimm_or_0_operand (operands[1], E_V16QImode)
              || !nonimm_or_0_operand (operands[2], E_V16QImode))
            return -1;
          return 0;

        case E_V16HImode:
          if (!nonimm_or_0_operand (operands[1], E_V16HImode)
              || !nonimm_or_0_operand (operands[2], E_V16HImode))
            return -1;
          return 1;

        case E_V16SImode:
          if (!nonimm_or_0_operand (operands[1], E_V16SImode)
              || !nonimm_or_0_operand (operands[2], E_V16SImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x1) != E_QImode)
        return -1;
      x3 = XEXP (x1, 0);
      if (GET_MODE (x3) != E_QImode
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HImode:
          if (!nonimm_or_0_operand (operands[1], E_V8HImode)
              || !nonimm_or_0_operand (operands[2], E_V8HImode))
            return -1;
          return 3;

        case E_V8SImode:
          if (!nonimm_or_0_operand (operands[1], E_V8SImode)
              || !nonimm_or_0_operand (operands[2], E_V8SImode))
            return -1;
          return 4;

        case E_V4SImode:
          if (!nonimm_or_0_operand (operands[1], E_V4SImode)
              || !nonimm_or_0_operand (operands[2], E_V4SImode))
            return -1;
          return 5;

        case E_V8DImode:
          if (!nonimm_or_0_operand (operands[1], E_V8DImode)
              || !nonimm_or_0_operand (operands[2], E_V8DImode))
            return -1;
          return 6;

        case E_V4DImode:
          if (!nonimm_or_0_operand (operands[1], E_V4DImode)
              || !nonimm_or_0_operand (operands[2], E_V4DImode))
            return -1;
          return 7;

        case E_V2DImode:
          if (!nonimm_or_0_operand (operands[1], E_V2DImode)
              || !nonimm_or_0_operand (operands[2], E_V2DImode))
            return -1;
          return 8;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern980 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (x1))
    {
    case E_V8SFmode:
      if (!register_operand (operands[1], E_V8SImode)
          || !const0_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!register_operand (operands[1], E_V4SImode)
          || !const0_operand (operands[2], E_V4SImode))
        return -1;
      return 1;

    case E_V4DFmode:
      if (!register_operand (operands[1], E_V4DImode)
          || !const0_operand (operands[2], E_V4DImode))
        return -1;
      return 2;

    case E_V2DFmode:
      if (!register_operand (operands[1], E_V2DImode)
          || !const0_operand (operands[2], E_V2DImode))
        return -1;
      return 3;

    case E_V16QImode:
      if (!register_operand (operands[1], E_V16QImode)
          || !const0_operand (operands[2], E_V16QImode))
        return -1;
      return 4;

    default:
      return -1;
    }
}

int
pattern995 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1003 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1)
      || !register_operand (operands[4], E_QImode))
    return -1;
  return 0;
}

int
pattern1011 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!const48_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      return pattern1008 (x1, 
E_V8HFmode, 
E_V8HImode); /* [-1, 0] */

    case E_V16HImode:
      if (pattern1008 (x1, 
E_V16HFmode, 
E_V16HImode) != 0)
        return -1;
      return 1;

    case E_V32HImode:
      if (pattern1008 (x1, 
E_V32HFmode, 
E_V32HImode) != 0)
        return -1;
      return 2;

    case E_V8SImode:
      res = pattern1009 (x1);
      if (res >= 0)
        return res + 3; /* [3, 4] */
      return -1;

    case E_V16SImode:
      res = pattern1010 (x1);
      if (res >= 0)
        return res + 5; /* [5, 6] */
      return -1;

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x1) != E_V8DImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      if (GET_MODE (x2) != E_V8DImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!register_operand (operands[1], E_V8HFmode))
            return -1;
          return 7;

        case E_V8DFmode:
          if (!register_operand (operands[1], E_V8DFmode))
            return -1;
          return 8;

        case E_V8SFmode:
          if (!register_operand (operands[1], E_V8SFmode))
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1035 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[3]))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode)
          || !extract_operator (operands[4], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode)
          || !extract_operator (operands[4], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode)
          || !extract_operator (operands[4], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1040 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case AND:
      if (GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 1);
      if (GET_CODE (x4) != CONST_INT)
        return -1;
      x5 = XEXP (x1, 1);
      if (GET_CODE (x5) != SUBREG
          || maybe_ne (SUBREG_BYTE (x5), 0))
        return -1;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != i1)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != ZERO_EXTEND)
        return -1;
      x8 = XEXP (x6, 1);
      if (GET_CODE (x8) != MINUS
          || GET_MODE (x8) != E_QImode)
        return -1;
      x9 = XEXP (x8, 0);
      if (GET_CODE (x9) != CONST_INT)
        return -1;
      x10 = XEXP (x8, 1);
      if (GET_CODE (x10) != AND
          || GET_MODE (x10) != E_QImode)
        return -1;
      x11 = XEXP (x10, 1);
      if (GET_CODE (x11) != CONST_INT)
        return -1;
      x12 = XEXP (x3, 0);
      if (!nonmemory_operand (x12, E_QImode))
        return -1;
      switch (XWINT (x4, 0))
        {
        case 63L:
          if (XWINT (x9, 0) != 64L
              || XWINT (x11, 0) != 63L
              || pattern1039 (x1, 
E_DImode, 
E_TImode) != 0)
            return -1;
          return 0;

        case 31L:
          if (XWINT (x9, 0) != 32L
              || XWINT (x11, 0) != 31L)
            return -1;
          return 1;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      return 2;

    default:
      return -1;
    }
}

int
pattern1060 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  operands[2] = x2;
  if (!register_operand (operands[2], i1))
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[0]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1072 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (x1))
    {
    case E_DImode:
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_DImode
          || !register_operand (operands[1], E_V64QImode)
          || !nonimmediate_operand (operands[2], E_V64QImode)
          || !register_operand (operands[3], E_DImode))
        return -1;
      return 0;

    case E_SImode:
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_SImode
          || !register_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V32QImode:
          if (!register_operand (operands[1], E_V32QImode)
              || !nonimmediate_operand (operands[2], E_V32QImode))
            return -1;
          return 1;

        case E_V32HImode:
          if (!register_operand (operands[1], E_V32HImode)
              || !nonimmediate_operand (operands[2], E_V32HImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_HImode:
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_HImode
          || !register_operand (operands[3], E_HImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16QImode:
          if (!register_operand (operands[1], E_V16QImode)
              || !nonimmediate_operand (operands[2], E_V16QImode))
            return -1;
          return 3;

        case E_V16HImode:
          if (!register_operand (operands[1], E_V16HImode)
              || !nonimmediate_operand (operands[2], E_V16HImode))
            return -1;
          return 4;

        case E_V16SImode:
          if (!register_operand (operands[1], E_V16SImode)
              || !nonimmediate_operand (operands[2], E_V16SImode))
            return -1;
          return 5;

        default:
          return -1;
        }

    case E_QImode:
      x2 = XEXP (x1, 0);
      if (GET_MODE (x2) != E_QImode
          || !register_operand (operands[3], E_QImode))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HImode:
          if (!register_operand (operands[1], E_V8HImode)
              || !nonimmediate_operand (operands[2], E_V8HImode))
            return -1;
          return 6;

        case E_V8SImode:
          if (!register_operand (operands[1], E_V8SImode)
              || !nonimmediate_operand (operands[2], E_V8SImode))
            return -1;
          return 7;

        case E_V4SImode:
          if (!register_operand (operands[1], E_V4SImode)
              || !nonimmediate_operand (operands[2], E_V4SImode))
            return -1;
          return 8;

        case E_V8DImode:
          if (!register_operand (operands[1], E_V8DImode)
              || !nonimmediate_operand (operands[2], E_V8DImode))
            return -1;
          return 9;

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode)
              || !nonimmediate_operand (operands[2], E_V4DImode))
            return -1;
          return 10;

        case E_V2DImode:
          if (!register_operand (operands[1], E_V2DImode)
              || !nonimmediate_operand (operands[2], E_V2DImode))
            return -1;
          return 11;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1115 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i4
      || !vector_operand (operands[2], i3))
    return -1;
  x4 = XEXP (x2, 1);
  return pattern1113 (x4, 
i1, 
i2, 
i3, 
i4); /* [-1, 0] */
}

int
pattern1122 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V32HFmode
      || !register_operand (operands[0], E_V32HFmode)
      || GET_MODE (x1) != E_V32HFmode
      || !register_operand (operands[1], E_V32HFmode)
      || !register_operand (operands[2], E_V32HFmode)
      || !const_4_or_8_to_11_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1129 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1136 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[5], i1)
      || !immediate_operand (operands[3], i1)
      || !register_operand (operands[4], i1)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1142 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_CODE (x5) != ZERO_EXTEND)
    return -1;
  return pattern356 (x1); /* [-1, 3] */
}

int
pattern1147 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1155 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[3] = x4;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern205 (x1); /* [-1, 3] */
}

int
pattern1162 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_SImode
      || !register_operand (operands[0], E_DImode)
      || GET_MODE (x1) != E_DImode)
    return -1;
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_SImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  return 0;
}

int
pattern1170 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[4]))
    {
    case E_QImode:
      if (!register_operand (operands[4], E_QImode))
        return -1;
      return 0;

    case E_HImode:
      if (!register_operand (operands[4], E_HImode))
        return -1;
      return 1;

    case E_SImode:
      if (!register_operand (operands[4], E_SImode))
        return -1;
      return 2;

    case E_DImode:
      if (!register_operand (operands[4], E_DImode))
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1179 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PLUS)
    return -1;
  x7 = XEXP (x2, 0);
  if (GET_MODE (x7) != E_CCCmode
      || GET_MODE (x3) != E_CCCmode)
    return -1;
  x8 = XEXP (x4, 1);
  operands[2] = x8;
  if (!memory_operand (operands[2], i1))
    return -1;
  x9 = XEXP (x4, 0);
  if (!rtx_equal_p (x9, operands[0]))
    return -1;
  x10 = XEXP (x3, 1);
  if (!rtx_equal_p (x10, operands[0]))
    return -1;
  x11 = XEXP (x6, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  x12 = XEXP (x6, 1);
  if (!rtx_equal_p (x12, operands[2]))
    return -1;
  return 0;
}

int
pattern1189 (rtx x1, machine_mode i1, rtx_code i2, machine_mode i3, rtx_code i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != i4
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != i2
      || GET_MODE (x2) != i1)
    return -1;
  return 0;
}

int
pattern1193 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1197 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  switch (GET_CODE (x1))
    {
    case UNSPEC:
      if (XVECLEN (x1, 0) != 2
          || XINT (x1, 1) != 52
          || GET_MODE (x1) != E_V16QImode)
        return -1;
      x2 = XVECEXP (x1, 0, 0);
      operands[1] = x2;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x3 = XVECEXP (x1, 0, 1);
      operands[2] = x3;
      return 0;

    case VEC_SELECT:
      if (GET_MODE (x1) != E_V4SImode)
        return -1;
      x4 = XEXP (x1, 1);
      if (GET_CODE (x4) != PARALLEL
          || XVECLEN (x4, 0) != 4)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XVECEXP (x4, 0, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x7 = XVECEXP (x4, 0, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x8 = XVECEXP (x4, 0, 3);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x9 = XEXP (x1, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1216 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1219 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_CCGOCmode)
    return -1;
  return pattern364 (x1, 
E_CCGOCmode); /* [-1, 3] */
}

int
pattern1224 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (maybe_ne (SUBREG_BYTE (x2), 0))
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != ZERO_EXTEND)
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (GET_MODE (x1) != E_DImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_DImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_63_operand (x6, E_QImode))
        return -1;
      return 0;

    case E_SImode:
      if (GET_MODE (x1) != E_SImode)
        return -1;
      x5 = XEXP (x1, 0);
      if (GET_MODE (x5) != E_SImode)
        return -1;
      x6 = XEXP (x5, 1);
      if (!const_0_to_31_operand (x6, E_QImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1233 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode
      || !register_operand (operands[0], E_SImode))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XVECEXP (x7, 0, 0);
  operands[1] = x8;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x9 = XVECEXP (x7, 0, 1);
  operands[2] = x9;
  return 0;
}

int
pattern1245 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !fcmov_comparison_operator (operands[1], E_VOIDmode)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1249 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[3]))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1257 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1264 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i3)
      || pattern485 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1273 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i3))
    return -1;
  return 0;
}

int
pattern1283 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1294 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || GET_MODE (x2) != i2
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1)
      || !const_4_or_8_to_11_operand (operands[4], E_SImode))
    return -1;
  return 0;
}

int
pattern1300 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1304 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  if (!vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1310 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[1]))
    return -1;
  x5 = XEXP (x3, 1);
  if (!rtx_equal_p (x5, operands[2]))
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 1);
  x8 = XEXP (x7, 0);
  switch (GET_MODE (x8))
    {
    case E_QImode:
      return pattern1309 (x3, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern1309 (x3, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern1309 (x3, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !const_1_to_63_operand (operands[2], E_QImode)
          || !nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1330 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  x4 = PATTERN (peep2_next_insn (2));
  x5 = XEXP (x4, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  x6 = XEXP (x4, 0);
  if (!rtx_equal_p (x6, operands[2]))
    return -1;
  return 0;
}

int
pattern1337 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  if (!general_reg_operand (operands[0], i1))
    return -1;
  switch (GET_CODE (x1))
    {
    case SET:
      x2 = XEXP (x1, 1);
      switch (GET_CODE (x2))
        {
        case CONST_INT:
          if (XWINT (x2, 0) != 0L)
            return -1;
          x3 = XEXP (x1, 0);
          if (GET_CODE (x3) != ZERO_EXTRACT)
            return -1;
          x4 = XEXP (x3, 1);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x5 = XEXP (x3, 2);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x6 = XEXP (x3, 0);
          operands[1] = x6;
          if (!int248_register_operand (operands[1], E_VOIDmode))
            return -1;
          switch (GET_MODE (x3))
            {
            case E_HImode:
              return 0;

            case E_SImode:
              return 1;

            case E_DImode:
              return 2;

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x2;
          x3 = XEXP (x1, 0);
          if (GET_CODE (x3) != STRICT_LOW_PART)
            return -1;
          x6 = XEXP (x3, 0);
          operands[1] = x6;
          res = pattern1329 ();
          if (res >= 0)
            return res + 3; /* [3, 4] */
          return -1;

        default:
          return -1;
        }

    case PARALLEL:
      if (XVECLEN (x1, 0) != 2)
        return -1;
      x7 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x7) != SET)
        return -1;
      x8 = XEXP (x7, 1);
      switch (GET_CODE (x8))
        {
        case PLUS:
          if (GET_MODE (x8) != i1
              || pattern1332 (x1) != 0)
            return -1;
          return 5;

        case IOR:
          if (GET_MODE (x8) != i1
              || pattern1332 (x1) != 0)
            return -1;
          return 6;

        case XOR:
          if (GET_MODE (x8) != i1
              || pattern1332 (x1) != 0)
            return -1;
          return 7;

        case UNSPEC:
          if (peep2_current_count < 3
              || peep2_current_count < 4
              || XVECLEN (x8, 0) != 2
              || XINT (x8, 1) != 40
              || GET_MODE (x8) != E_CCCmode)
            return -1;
          x9 = XVECEXP (x8, 0, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XEXP (x7, 0);
          if (GET_CODE (x10) != REG
              || REGNO (x10) != 17
              || GET_MODE (x10) != E_CCCmode)
            return -1;
          x11 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x11) != SET)
            return -1;
          x12 = XEXP (x11, 1);
          if (GET_CODE (x12) != NEG
              || GET_MODE (x12) != i1)
            return -1;
          x13 = XVECEXP (x8, 0, 0);
          operands[1] = x13;
          if (!general_reg_operand (operands[1], i1))
            return -1;
          x14 = XEXP (x12, 0);
          if (!rtx_equal_p (x14, operands[1]))
            return -1;
          x15 = XEXP (x11, 0);
          if (!rtx_equal_p (x15, operands[1]))
            return -1;
          x16 = PATTERN (peep2_next_insn (2));
          if (pattern1184 (x16, 
i1) != 0)
            return -1;
          return 8;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1396 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 2);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
      operands[4] = x3;
      x4 = XVECEXP (x1, 0, 1);
      operands[5] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          return 0;

        case E_V16SFmode:
          return 1;

        case E_V8DFmode:
          return 2;

        case E_V16HFmode:
          return 3;

        case E_V8HFmode:
          return 4;

        case E_V8SFmode:
          return 5;

        case E_V4SFmode:
          return 6;

        case E_V4DFmode:
          return 7;

        case E_V2DFmode:
          return 8;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 1L)
        return -1;
      x4 = XVECEXP (x1, 0, 1);
      operands[4] = x4;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          return 9;

        case E_V4SFmode:
          return 10;

        case E_V2DFmode:
          return 11;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1415 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !scratch_operand (operands[0], i1))
    return -1;
  return 0;
}

int
pattern1423 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern1422 (x3); /* [-1, 1] */

    case PLUS:
      res = pattern1422 (x3);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    case MINUS:
      x6 = XEXP (x5, 0);
      operands[3] = x6;
      if (!const_int_operand (operands[3], E_VOIDmode))
        return -1;
      x7 = XEXP (x5, 1);
      operands[2] = x7;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      res = pattern198 (x3);
      if (res >= 0)
        return res + 4; /* [4, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1437 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const_int_operand (operands[2], E_VOIDmode))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_SImode:
      return pattern1436 (x3, 
E_SImode); /* [-1, 2] */

    case E_DImode:
      res = pattern1436 (x3, 
E_DImode);
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1447 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x3, 2);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1458 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 12);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x3 = XVECEXP (x1, 0, 13);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x4 = XVECEXP (x1, 0, 14);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x5 = XVECEXP (x1, 0, 15);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  return 0;
}

int
pattern1465 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1472 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 4);
  operands[2] = x2;
  if (!const_4_to_7_operand (operands[2], E_VOIDmode))
    return -1;
  x3 = XVECEXP (x1, 0, 5);
  operands[3] = x3;
  if (!const_4_to_7_operand (operands[3], E_VOIDmode))
    return -1;
  x4 = XVECEXP (x1, 0, 6);
  operands[4] = x4;
  if (!const_4_to_7_operand (operands[4], E_VOIDmode))
    return -1;
  x5 = XVECEXP (x1, 0, 7);
  operands[5] = x5;
  if (!const_4_to_7_operand (operands[5], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1483 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[2], i1)
      || !scratch_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1493 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 1);
  x6 = XVECEXP (x5, 0, 0);
  operands[1] = x6;
  return 0;
}

int
pattern1501 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[2], i2))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1514 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 2);
  return pattern1456 (x2, 
i1, 
i2); /* [-1, 0] */
}

int
pattern1518 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != COMPARE
      || GET_MODE (x2) != E_CCZmode)
    return -1;
  x3 = XEXP (x1, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCZmode)
    return -1;
  return 0;
}

int
pattern1523 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1)
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1529 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1537 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 1)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != VEC_SELECT
      || GET_MODE (x5) != i1)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 1)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  return 0;
}

int
pattern1550 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode)
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1558 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1))
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1563 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V4SFmode)
      || GET_MODE (x1) != E_V4SFmode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4SFmode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V8SFmode
      || !vector_operand (operands[1], E_V4SFmode))
    return -1;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  if (!nonimm_or_0_operand (operands[2], E_V4SFmode))
    return -1;
  x5 = XEXP (x1, 2);
  operands[3] = x5;
  x6 = XEXP (x3, 1);
  if (!rtx_equal_p (x6, operands[1]))
    return -1;
  return 0;
}

int
pattern1574 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[4], i2))
    return -1;
  x4 = XEXP (x2, 1);
  if (!rtx_equal_p (x4, operands[3]))
    return -1;
  return 0;
}

int
pattern1585 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1592 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[6], i2)
      || !register_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_SImode:
      if (!vsib_address_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!vsib_address_operand (operands[3], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1602 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  if (!nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1610 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !ix86_carry_flag_operator (operands[4], i1)
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1617 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !register_mmxmem_operand (operands[1], i1))
    return -1;
  x6 = XEXP (x4, 1);
  if (GET_MODE (x6) != i2
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1631 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1638 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[4], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1647 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1)
      || !x86_64_hilo_general_operand (operands[2], i1)
      || !nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  return 0;
}

int
pattern1655 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i2)
      || !const0_operand (operands[5], i1)
      || !register_operand (operands[6], i3))
    return -1;
  return 0;
}

int
pattern1668 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != SUBREG
      || maybe_ne (SUBREG_BYTE (x3), 0)
      || GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[4] = x4;
      x5 = XEXP (x4, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x6 = XEXP (x4, 2);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      return pattern1036 (x1); /* [-1, 5] */

    default:
      return -1;
    }
}

int
pattern1678 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[3]))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1685 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V16SImode:
      if (!register_operand (operands[2], E_V16SImode)
          || !register_operand (operands[6], E_HImode)
          || !register_operand (operands[3], E_V16SFmode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode)
          || !register_operand (operands[6], E_QImode)
          || !register_operand (operands[3], E_V8SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1697 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V4SImode:
      if (!register_operand (operands[2], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1705 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[2], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1712 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_SImode))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[2] = x4;
  if (!register_operand (operands[2], E_V16QImode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[3] = x5;
  if (!nonimmediate_operand (operands[3], E_V16QImode))
    return -1;
  x6 = XVECEXP (x3, 0, 2);
  operands[4] = x6;
  if (!const_0_to_255_operand (operands[4], E_SImode))
    return -1;
  x7 = XVECEXP (x1, 0, 1);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  if (!register_operand (operands[1], E_V16QImode))
    return -1;
  x9 = XEXP (x7, 1);
  x10 = XVECEXP (x9, 0, 0);
  if (!rtx_equal_p (x10, operands[2]))
    return -1;
  x11 = XVECEXP (x9, 0, 1);
  if (!rtx_equal_p (x11, operands[3]))
    return -1;
  x12 = XVECEXP (x9, 0, 2);
  if (!rtx_equal_p (x12, operands[4]))
    return -1;
  x13 = XVECEXP (x1, 0, 2);
  x14 = XEXP (x13, 1);
  x15 = XVECEXP (x14, 0, 0);
  if (!rtx_equal_p (x15, operands[2]))
    return -1;
  x16 = XVECEXP (x14, 0, 1);
  if (!rtx_equal_p (x16, operands[3]))
    return -1;
  x17 = XVECEXP (x14, 0, 2);
  if (!rtx_equal_p (x17, operands[4]))
    return -1;
  return 0;
}

int
pattern1731 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[4], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1739 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[11], i1))
    return -1;
  return 0;
}

int
pattern1748 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[1], i1))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_HImode:
      if (!register_operand (operands[2], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!register_operand (operands[2], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!register_operand (operands[2], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1757 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!register_operand (operands[3], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1765 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCZmode)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x2, 2);
  if (GET_CODE (x6) != PC)
    return -1;
  x7 = XEXP (x1, 0);
  if (GET_CODE (x7) != PC)
    return -1;
  return 0;
}

int
pattern1775 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vsib_mem_operator (operands[7], i2)
      || !register_operand (operands[5], i1)
      || !scratch_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1774 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1774 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1786 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != COMPARE)
    return -1;
  x3 = XEXP (x2, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x4 = XEXP (x1, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x2, 0);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  return 0;
}

int
pattern1793 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_3_operand (operands[2], E_VOIDmode)
      || !const_0_to_3_operand (operands[3], E_VOIDmode)
      || !const_0_to_3_operand (operands[4], E_VOIDmode)
      || !const_0_to_3_operand (operands[5], E_VOIDmode)
      || !const_4_to_7_operand (operands[6], E_VOIDmode)
      || !const_4_to_7_operand (operands[7], E_VOIDmode)
      || !const_4_to_7_operand (operands[8], E_VOIDmode)
      || !const_4_to_7_operand (operands[9], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1801 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  rtx x26, x27, x28, x29, x30, x31, x32, x33;
  rtx x34, x35, x36, x37, x38, x39, x40, x41;
  rtx x42, x43, x44, x45, x46, x47, x48, x49;
  rtx x50, x51, x52, x53, x54, x55;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != VEC_SELECT
      || GET_MODE (x5) != E_V2QImode)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != PARALLEL
      || XVECLEN (x6, 0) != 2)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x8 = XVECEXP (x6, 0, 1);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
    return -1;
  x9 = XEXP (x3, 1);
  if (GET_CODE (x9) != i1)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != E_V2QImode)
    return -1;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 2)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x14 = XEXP (x2, 1);
  x15 = XEXP (x14, 0);
  if (GET_CODE (x15) != i1)
    return -1;
  x16 = XEXP (x15, 0);
  if (GET_CODE (x16) != VEC_SELECT
      || GET_MODE (x16) != E_V2QImode)
    return -1;
  x17 = XEXP (x16, 1);
  if (GET_CODE (x17) != PARALLEL
      || XVECLEN (x17, 0) != 2)
    return -1;
  x18 = XVECEXP (x17, 0, 0);
  if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x19 = XVECEXP (x17, 0, 1);
  if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
    return -1;
  x20 = XEXP (x14, 1);
  if (GET_CODE (x20) != i1)
    return -1;
  x21 = XEXP (x20, 0);
  if (GET_CODE (x21) != VEC_SELECT
      || GET_MODE (x21) != E_V2QImode)
    return -1;
  x22 = XEXP (x21, 1);
  if (GET_CODE (x22) != PARALLEL
      || XVECLEN (x22, 0) != 2)
    return -1;
  x23 = XVECEXP (x22, 0, 0);
  if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x24 = XVECEXP (x22, 0, 1);
  if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  x25 = XEXP (x1, 1);
  x26 = XEXP (x25, 0);
  x27 = XEXP (x26, 0);
  if (GET_CODE (x27) != i1)
    return -1;
  x28 = XEXP (x27, 0);
  if (GET_CODE (x28) != VEC_SELECT
      || GET_MODE (x28) != E_V2QImode)
    return -1;
  x29 = XEXP (x28, 1);
  if (GET_CODE (x29) != PARALLEL
      || XVECLEN (x29, 0) != 2)
    return -1;
  x30 = XVECEXP (x29, 0, 0);
  if (x30 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x31 = XVECEXP (x29, 0, 1);
  if (x31 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
    return -1;
  x32 = XEXP (x26, 1);
  if (GET_CODE (x32) != i1)
    return -1;
  x33 = XEXP (x32, 0);
  if (GET_CODE (x33) != VEC_SELECT
      || GET_MODE (x33) != E_V2QImode)
    return -1;
  x34 = XEXP (x33, 1);
  if (GET_CODE (x34) != PARALLEL
      || XVECLEN (x34, 0) != 2)
    return -1;
  x35 = XVECEXP (x34, 0, 0);
  if (x35 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x36 = XVECEXP (x34, 0, 1);
  if (x36 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x37 = XEXP (x25, 1);
  x38 = XEXP (x37, 0);
  if (GET_CODE (x38) != i1)
    return -1;
  x39 = XEXP (x38, 0);
  if (GET_CODE (x39) != VEC_SELECT
      || GET_MODE (x39) != E_V2QImode)
    return -1;
  x40 = XEXP (x39, 1);
  if (GET_CODE (x40) != PARALLEL
      || XVECLEN (x40, 0) != 2)
    return -1;
  x41 = XVECEXP (x40, 0, 0);
  if (x41 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x42 = XVECEXP (x40, 0, 1);
  if (x42 != const_int_rtx[MAX_SAVED_CONST_INT + 14])
    return -1;
  x43 = XEXP (x37, 1);
  if (GET_CODE (x43) != i1)
    return -1;
  x44 = XEXP (x43, 0);
  if (GET_CODE (x44) != VEC_SELECT
      || GET_MODE (x44) != E_V2QImode)
    return -1;
  x45 = XEXP (x44, 1);
  if (GET_CODE (x45) != PARALLEL
      || XVECLEN (x45, 0) != 2)
    return -1;
  x46 = XVECEXP (x45, 0, 0);
  if (x46 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x47 = XVECEXP (x45, 0, 1);
  if (x47 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  x48 = XEXP (x5, 0);
  operands[1] = x48;
  if (!nonimmediate_operand (operands[1], E_V16QImode))
    return -1;
  x49 = XEXP (x10, 0);
  if (!rtx_equal_p (x49, operands[1]))
    return -1;
  x50 = XEXP (x16, 0);
  if (!rtx_equal_p (x50, operands[1]))
    return -1;
  x51 = XEXP (x21, 0);
  if (!rtx_equal_p (x51, operands[1]))
    return -1;
  x52 = XEXP (x28, 0);
  if (!rtx_equal_p (x52, operands[1]))
    return -1;
  x53 = XEXP (x33, 0);
  if (!rtx_equal_p (x53, operands[1]))
    return -1;
  x54 = XEXP (x39, 0);
  if (!rtx_equal_p (x54, operands[1]))
    return -1;
  x55 = XEXP (x44, 0);
  if (!rtx_equal_p (x55, operands[1]))
    return -1;
  return 0;
}

int
pattern1856 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x4, 1);
  if (GET_MODE (x7) != i2
      || !sext_operand (operands[2], i1)
      || pattern1855 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1863 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1)
      || !ix86_carry_flag_operator (operands[4], i2)
      || !const_int_operand (operands[6], i2))
    return -1;
  x7 = XEXP (x3, 1);
  if (GET_MODE (x7) != i2)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_MODE (x9) != i1
      || !ix86_carry_flag_operator (operands[5], i1))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  x11 = XEXP (x10, 1);
  return pattern1858 (x11, 
i1); /* [-1, 0] */
}

int
pattern1873 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 24);
  if (XWINT (x2, 0) != 28L)
    return -1;
  x3 = XVECEXP (x1, 0, 25);
  if (XWINT (x3, 0) != 60L)
    return -1;
  x4 = XVECEXP (x1, 0, 26);
  if (XWINT (x4, 0) != 29L)
    return -1;
  x5 = XVECEXP (x1, 0, 27);
  if (XWINT (x5, 0) != 61L)
    return -1;
  x6 = XVECEXP (x1, 0, 28);
  if (XWINT (x6, 0) != 30L)
    return -1;
  x7 = XVECEXP (x1, 0, 29);
  if (XWINT (x7, 0) != 62L)
    return -1;
  x8 = XVECEXP (x1, 0, 30);
  if (XWINT (x8, 0) != 31L)
    return -1;
  x9 = XVECEXP (x1, 0, 31);
  if (XWINT (x9, 0) != 63L)
    return -1;
  return 0;
}

 int
recog_7 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!register_operand (operands[0], E_HImode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  if (GET_MODE (x4) != E_CCFPmode)
    return -1;
  switch (GET_CODE (x4))
    {
    case COMPARE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      switch (GET_CODE (x6))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case REG:
        case SUBREG:
        case MEM:
          operands[2] = x6;
          switch (GET_MODE (operands[1]))
            {
            case E_XFmode:
              if (!register_operand (operands[1], E_XFmode)
                  || !reg_or_0_operand (operands[2], E_XFmode)
                  || !
#line 1936 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 35; /* *cmpxf_i387 */

            case E_SFmode:
              if (!register_operand (operands[1], E_SFmode)
                  || !nonimm_or_0_operand (operands[2], E_SFmode)
                  || !
#line 1949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 36; /* *cmpsf_i387 */

            case E_DFmode:
              if (!register_operand (operands[1], E_DFmode)
                  || !nonimm_or_0_operand (operands[2], E_DFmode)
                  || !
#line 1949 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
                return -1;
              return 37; /* *cmpdf_i387 */

            default:
              return -1;
            }

        case FLOAT:
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          switch (GET_MODE (operands[1]))
            {
            case E_SFmode:
              switch (pattern1248 (x6, 
E_SFmode))
                {
                case 0:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 38; /* *cmpsf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 41; /* *cmpsf_si_i387 */

                default:
                  return -1;
                }

            case E_DFmode:
              switch (pattern1248 (x6, 
E_DFmode))
                {
                case 0:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 39; /* *cmpdf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 42; /* *cmpdf_si_i387 */

                default:
                  return -1;
                }

            case E_XFmode:
              switch (pattern1248 (x6, 
E_XFmode))
                {
                case 0:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_HIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 40; /* *cmpxf_hi_i387 */

                case 1:
                  if (!
#line 1963 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387
   && (TARGET_USE_SIMODE_FIOP
       || optimize_function_for_size_p (cfun))))
                    return -1;
                  return 43; /* *cmpxf_si_i387 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 26)
        return -1;
      x8 = XVECEXP (x4, 0, 0);
      if (GET_CODE (x8) != COMPARE
          || GET_MODE (x8) != E_CCFPmode)
        return -1;
      x9 = XEXP (x8, 0);
      operands[1] = x9;
      x10 = XEXP (x8, 1);
      operands[2] = x10;
      switch (GET_MODE (operands[1]))
        {
        case E_SFmode:
          if (!register_operand (operands[1], E_SFmode)
              || !register_operand (operands[2], E_SFmode)
              || !
#line 1981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 44; /* *cmpusf_i387 */

        case E_DFmode:
          if (!register_operand (operands[1], E_DFmode)
              || !register_operand (operands[2], E_DFmode)
              || !
#line 1981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 45; /* *cmpudf_i387 */

        case E_XFmode:
          if (!register_operand (operands[1], E_XFmode)
              || !register_operand (operands[2], E_XFmode)
              || !
#line 1981 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 46; /* *cmpuxf_i387 */

        default:
          return -1;
        }

    case REG:
      if (REGNO (x4) != 18
          || !
#line 23896 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 1714; /* x86_fnstsw_1 */

    default:
      return -1;
    }
}

 int
recog_15 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V1TImode:
      if (!push_operand (operands[0], E_V1TImode)
          || !register_operand (operands[1], E_V1TImode))
        return -1;
      if ((
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
        return 65; /* *pushv1ti2 */
      if (!(
#line 2175 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_STV) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
        return -1;
      return 66; /* *pushv1ti2 */

    case E_DImode:
      if (push_operand (operands[0], E_DImode)
          && general_no_elim_operand (operands[1], E_DImode))
        {
          if (
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 67; /* *pushdi2 */
          if (
#line 2206 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 69; /* *pushdi2_rex64 */
        }
      if (nonimmediate_operand (operands[0], E_DImode)
          && pop_operand (operands[1], E_DImode)
          && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
        return 77; /* *popdi1 */
      if (pnum_clobbers != NULL
          && const0_operand (operands[1], E_DImode))
        {
          if (register_operand (operands[0], E_DImode)
              && (
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 85; /* *movdi_xor */
            }
          if (memory_operand (operands[0], E_DImode)
              && (
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 88; /* *movdi_and */
            }
        }
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_DImode)
          && (
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pnum_clobbers = 1;
          return 91; /* *movdi_or */
        }
      if (!general_operand (operands[1], E_DImode)
          || !
#line 2594 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 95; /* *movdi_internal */

    case E_TImode:
      if (push_operand (operands[0], E_TImode)
          && general_no_elim_operand (operands[1], E_TImode)
          && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return 68; /* *pushti2 */
      if (!nonimmediate_operand (operands[0], E_TImode)
          || !general_operand (operands[1], E_TImode)
          || !
#line 2510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_64BIT
    && !(MEM_P (operands[0]) && MEM_P (operands[1])))
   || (TARGET_SSE
       && nonimmediate_or_sse_const_operand (operands[1], TImode)
       && (register_operand (operands[0], TImode)
	   || register_operand (operands[1], TImode)))))
        return -1;
      return 94; /* *movti_internal */

    case E_SImode:
      if (push_operand (operands[0], E_SImode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_SImode)
              && 
#line 2249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 70; /* *pushsi2_rex64 */
          if (general_no_elim_operand (operands[1], E_SImode)
              && 
#line 2259 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 71; /* *pushsi2 */
        }
      if (nonimmediate_operand (operands[0], E_SImode)
          && pop_operand (operands[1], E_SImode)
          && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
        return 76; /* *popsi1 */
      if (pnum_clobbers != NULL
          && const0_operand (operands[1], E_SImode))
        {
          if (register_operand (operands[0], E_SImode)
              && 
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            {
              *pnum_clobbers = 1;
              return 84; /* *movsi_xor */
            }
          if (memory_operand (operands[0], E_SImode)
              && 
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
            {
              *pnum_clobbers = 1;
              return 87; /* *movsi_and */
            }
        }
      if (!nonimmediate_operand (operands[0], E_SImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_SImode)
          && 
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 90; /* *movsi_or */
        }
      if (!general_operand (operands[1], E_SImode)
          || !
#line 2834 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 96; /* *movsi_internal */

    case E_QImode:
      if (push_operand (operands[0], E_QImode)
          && nonmemory_no_elim_operand (operands[1], E_QImode))
        return 72; /* *pushqi2 */
      if (!nonimmediate_operand (operands[0], E_QImode)
          || !general_operand (operands[1], E_QImode)
          || !
#line 3156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 98; /* *movqi_internal */

    case E_HImode:
      if (push_operand (operands[0], E_HImode)
          && nonmemory_no_elim_operand (operands[1], E_HImode))
        return 73; /* *pushhi2 */
      if (pnum_clobbers != NULL
          && memory_operand (operands[0], E_HImode)
          && const0_operand (operands[1], E_HImode)
          && 
#line 2436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 86; /* *movhi_and */
        }
      if (!nonimmediate_operand (operands[0], E_HImode))
        return -1;
      if (pnum_clobbers != NULL
          && constm1_operand (operands[1], E_HImode)
          && 
#line 2451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
        {
          *pnum_clobbers = 1;
          return 89; /* *movhi_or */
        }
      if (!general_operand (operands[1], E_HImode)
          || !
#line 2993 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 97; /* *movhi_internal */

    case E_TFmode:
      if (push_operand (operands[0], E_TFmode)
          && general_no_elim_operand (operands[1], E_TFmode)
          && 
#line 3777 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT || TARGET_SSE))
        return 152; /* *pushtf */
      if (!nonimmediate_operand (operands[0], E_TFmode)
          || !general_operand (operands[1], E_TFmode)
          || !
#line 4046 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_64BIT || TARGET_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || (standard_sse_constant_p (operands[1], TFmode) == 1
	   && !memory_operand (operands[0], TFmode))
       || (!TARGET_MEMORY_MISMATCH_STALL
	   && memory_operand (operands[0], TFmode)))))
        return -1;
      return 167; /* *movtf_internal */

    case E_XFmode:
      if (push_operand (operands[0], E_XFmode)
          && general_no_elim_operand (operands[1], E_XFmode))
        return 153; /* *pushxf */
      if (!nonimmediate_operand (operands[0], E_XFmode)
          || !general_operand (operands[1], E_XFmode)
          || !
#line 4106 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && standard_80387_constant_p (operands[1]) > 0
	   && !memory_operand (operands[0], XFmode))
       || (!TARGET_MEMORY_MISMATCH_STALL
	   && memory_operand (operands[0], XFmode))
       || !TARGET_HARD_XF_REGS)))
        return -1;
      return 168; /* *movxf_internal */

    case E_DFmode:
      if (push_operand (operands[0], E_DFmode)
          && general_no_elim_operand (operands[1], E_DFmode))
        return 154; /* *pushdf */
      if (!nonimmediate_operand (operands[0], E_DFmode)
          || !general_operand (operands[1], E_DFmode)
          || !
#line 4178 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && IS_STACK_MODE (DFmode)
	   && standard_80387_constant_p (operands[1]) > 0
	   && !memory_operand (operands[0], DFmode))
       || (TARGET_SSE2 && TARGET_SSE_MATH
	   && standard_sse_constant_p (operands[1], DFmode) == 1
	   && !memory_operand (operands[0], DFmode))
       || ((TARGET_64BIT || !TARGET_MEMORY_MISMATCH_STALL)
	   && memory_operand (operands[0], DFmode))
       || !TARGET_HARD_DF_REGS)))
        return -1;
      return 169; /* *movdf_internal */

    case E_HFmode:
      if (push_operand (operands[0], E_HFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_HFmode)
              && 
#line 3873 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 155; /* *pushhf_rex64 */
          if (general_no_elim_operand (operands[1], E_HFmode)
              && 
#line 3886 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 157; /* *pushhf */
        }
      if (!nonimmediate_operand (operands[0], E_HFmode)
          || !general_operand (operands[1], E_HFmode)
          || !
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
  && (lra_in_progress
      || reload_completed
      || !CONST_DOUBLE_P (operands[1])
      || (TARGET_SSE2
	  && standard_sse_constant_p (operands[1], HFmode) == 1)
      || memory_operand (operands[0], HFmode))))
        return -1;
      return 171; /* *movhf_internal */

    case E_BFmode:
      if (push_operand (operands[0], E_BFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_BFmode)
              && 
#line 3873 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 156; /* *pushbf_rex64 */
          if (general_no_elim_operand (operands[1], E_BFmode)
              && 
#line 3886 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 158; /* *pushbf */
        }
      if (!nonimmediate_operand (operands[0], E_BFmode)
          || !general_operand (operands[1], E_BFmode)
          || !
#line 4490 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
  && (lra_in_progress
      || reload_completed
      || !CONST_DOUBLE_P (operands[1])
      || (TARGET_SSE2
	  && standard_sse_constant_p (operands[1], BFmode) == 1)
      || memory_operand (operands[0], BFmode))))
        return -1;
      return 172; /* *movbf_internal */

    case E_SFmode:
      if (push_operand (operands[0], E_SFmode))
        {
          if (nonmemory_no_elim_operand (operands[1], E_SFmode)
              && 
#line 3961 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 165; /* *pushsf_rex64 */
          if (general_no_elim_operand (operands[1], E_SFmode)
              && 
#line 3975 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return 166; /* *pushsf */
        }
      if (!nonimmediate_operand (operands[0], E_SFmode)
          || !general_operand (operands[1], E_SFmode)
          || !
#line 4355 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && (lra_in_progress || reload_completed
       || !CONST_DOUBLE_P (operands[1])
       || ((optimize_function_for_size_p (cfun)
	    || (ix86_cmodel == CM_LARGE || ix86_cmodel == CM_LARGE_PIC))
	   && IS_STACK_MODE (SFmode)
	   && standard_80387_constant_p (operands[1]) > 0)
       || (TARGET_SSE && TARGET_SSE_MATH
	   && standard_sse_constant_p (operands[1], SFmode) == 1)
       || memory_operand (operands[0], SFmode)
       || !TARGET_HARD_SF_REGS)))
        return -1;
      return 170; /* *movsf_internal */

    case E_V8QImode:
      if (nonimmediate_operand (operands[0], E_V8QImode)
          && nonimm_or_0_operand (operands[1], E_V8QImode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2019; /* *movv8qi_internal */
      if (!memory_operand (operands[0], E_V8QImode)
          || !x86_64_const_vector_operand (operands[1], E_V8QImode)
          || !
#line 87 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2035; /* *movv8qi_imm */

    case E_V4HImode:
      if (nonimmediate_operand (operands[0], E_V4HImode)
          && nonimm_or_0_operand (operands[1], E_V4HImode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2020; /* *movv4hi_internal */
      if (!memory_operand (operands[0], E_V4HImode)
          || !x86_64_const_vector_operand (operands[1], E_V4HImode)
          || !
#line 87 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2036; /* *movv4hi_imm */

    case E_V2SImode:
      if (nonimmediate_operand (operands[0], E_V2SImode)
          && nonimm_or_0_operand (operands[1], E_V2SImode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2021; /* *movv2si_internal */
      if (!memory_operand (operands[0], E_V2SImode)
          || !x86_64_const_vector_operand (operands[1], E_V2SImode)
          || !
#line 89 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2039; /* *movv2si_imm */

    case E_V1DImode:
      if (!nonimmediate_operand (operands[0], E_V1DImode)
          || !nonimm_or_0_operand (operands[1], E_V1DImode)
          || !
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return -1;
      return 2022; /* *movv1di_internal */

    case E_V2SFmode:
      if (nonimmediate_operand (operands[0], E_V2SFmode)
          && nonimm_or_0_operand (operands[1], E_V2SFmode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2023; /* *movv2sf_internal */
      if (!memory_operand (operands[0], E_V2SFmode)
          || !x86_64_const_vector_operand (operands[1], E_V2SFmode)
          || !
#line 89 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2040; /* *movv2sf_imm */

    case E_V4HFmode:
      if (nonimmediate_operand (operands[0], E_V4HFmode)
          && nonimm_or_0_operand (operands[1], E_V4HFmode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2024; /* *movv4hf_internal */
      if (!memory_operand (operands[0], E_V4HFmode)
          || !x86_64_const_vector_operand (operands[1], E_V4HFmode)
          || !
#line 88 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2037; /* *movv4hf_imm */

    case E_V4BFmode:
      if (nonimmediate_operand (operands[0], E_V4BFmode)
          && nonimm_or_0_operand (operands[1], E_V4BFmode)
          && 
#line 189 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2025; /* *movv4bf_internal */
      if (!memory_operand (operands[0], E_V4BFmode)
          || !x86_64_const_vector_operand (operands[1], E_V4BFmode)
          || !
#line 88 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2038; /* *movv4bf_imm */

    case E_V4QImode:
      if (nonimmediate_operand (operands[0], E_V4QImode)
          && general_operand (operands[1], E_V4QImode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2026; /* *movv4qi_internal */
      if (memory_operand (operands[0], E_V4QImode)
          && x86_64_const_vector_operand (operands[1], E_V4QImode))
        return 2032; /* *movv4qi_imm */
      if (!push_operand (operands[0], E_V4QImode)
          || !nonmemory_no_elim_operand (operands[1], E_V4QImode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2041; /* *pushv4qi2_rex64 */

    case E_V2HImode:
      if (nonimmediate_operand (operands[0], E_V2HImode)
          && general_operand (operands[1], E_V2HImode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2027; /* *movv2hi_internal */
      if (memory_operand (operands[0], E_V2HImode)
          && x86_64_const_vector_operand (operands[1], E_V2HImode))
        return 2033; /* *movv2hi_imm */
      if (!push_operand (operands[0], E_V2HImode)
          || !nonmemory_no_elim_operand (operands[1], E_V2HImode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2042; /* *pushv2hi2_rex64 */

    case E_V1SImode:
      if (nonimmediate_operand (operands[0], E_V1SImode)
          && general_operand (operands[1], E_V1SImode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2028; /* *movv1si_internal */
      if (!push_operand (operands[0], E_V1SImode)
          || !nonmemory_no_elim_operand (operands[1], E_V1SImode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2043; /* *pushv1si2_rex64 */

    case E_V2HFmode:
      if (nonimmediate_operand (operands[0], E_V2HFmode)
          && general_operand (operands[1], E_V2HFmode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2029; /* *movv2hf_internal */
      if (memory_operand (operands[0], E_V2HFmode)
          && x86_64_const_vector_operand (operands[1], E_V2HFmode))
        return 2034; /* *movv2hf_imm */
      if (!push_operand (operands[0], E_V2HFmode)
          || !nonmemory_no_elim_operand (operands[1], E_V2HFmode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2044; /* *pushv2hf2_rex64 */

    case E_V2BFmode:
      if (nonimmediate_operand (operands[0], E_V2BFmode)
          && general_operand (operands[1], E_V2BFmode)
          && 
#line 344 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))
   && ix86_hardreg_mov_ok (operands[0], operands[1])))
        return 2030; /* *movv2bf_internal */
      if (!push_operand (operands[0], E_V2BFmode)
          || !nonmemory_no_elim_operand (operands[1], E_V2BFmode)
          || !
#line 430 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_64BIT))
        return -1;
      return 2045; /* *pushv2bf2_rex64 */

    case E_V2QImode:
      if (memory_operand (operands[0], E_V2QImode)
          && x86_64_const_vector_operand (operands[1], E_V2QImode))
        return 2031; /* *movv2qi_imm */
      if (nonimmediate_operand (operands[0], E_V2QImode)
          && general_operand (operands[1], E_V2QImode)
          && 
#line 472 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return 2046; /* *movv2qi_internal */
      if (!push_operand (operands[0], E_V2QImode)
          || !nonmemory_no_elim_operand (operands[1], E_V2QImode))
        return -1;
      return 2047; /* *pushv2qi2 */

    case E_P2QImode:
      if (!nonimmediate_operand (operands[0], E_P2QImode)
          || !nonimmediate_operand (operands[1], E_P2QImode)
          || !
#line 31203 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return -1;
      return 10258; /* *movp2qi_internal */

    case E_P2HImode:
      if (!nonimmediate_operand (operands[0], E_P2HImode)
          || !nonimmediate_operand (operands[1], E_P2HImode)
          || !
#line 31203 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VP2INTERSECT
   && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
        return -1;
      return 10259; /* *movp2hi_internal */

    default:
      return -1;
    }
}

 int
recog_29 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (GET_MODE (x3) != E_SFmode)
        return -1;
      if (nonimm_ssenomem_operand (operands[0], E_SFmode)
          && register_ssemem_operand (operands[1], E_DFmode)
          && 
#line 5542 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)))
        return 206; /* truncdfsf2 */
      if (!nonimmediate_operand (operands[0], E_SFmode)
          || !register_operand (operands[1], E_XFmode)
          || !
#line 5670 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 207; /* truncxfsf2 */

    case E_DFmode:
      if (!nonimmediate_operand (operands[0], E_DFmode)
          || GET_MODE (x3) != E_DFmode
          || !register_operand (operands[1], E_XFmode)
          || !
#line 5670 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
        return -1;
      return 208; /* truncxfdf2 */

    case E_HFmode:
      if (!register_operand (operands[0], E_HFmode))
        return -1;
      switch (pattern429 (x3, 
E_HFmode))
        {
        case 0:
          if (!
#line 5711 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 209; /* *truncsfhf2 */

        case 1:
          if (!
#line 5711 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 210; /* *truncdfhf2 */

        default:
          return -1;
        }

    case E_BFmode:
      if (!register_operand (operands[0], E_BFmode)
          || GET_MODE (x3) != E_BFmode
          || !register_operand (operands[1], E_SFmode)
          || !
#line 5727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE2 && !HONOR_NANS (BFmode) && !flag_rounding_math
   && (flag_unsafe_math_optimizations
       || TARGET_AVXNECONVERT
       || (TARGET_AVX512BF16 && TARGET_AVX512VL))))
        return -1;
      return 211; /* truncsfbf2 */

    case E_V2SFmode:
      if (!register_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 10138 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_MMX_WITH_SSE))
        return -1;
      return 5088; /* truncv2dfv2sf2 */

    default:
      return -1;
    }
}

 int
recog_34 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (pattern82 (x1, pnum_clobbers))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          x2 = XEXP (x1, 1);
          if (pattern73 (x2, pnum_clobbers) != 0
              || !(
#line 12515 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 704; /* *andti3_doubleword */

        case E_HImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          if (
#line 12685 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 719; /* *andhi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 12685 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, HImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 720; /* *andhi_1 */

        case E_QImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_QImode) != 0)
            return -1;
          if (
#line 12723 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 723; /* *andqi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 12723 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, QImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 724; /* *andqi_1 */

        case E_V2SFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2SFmode) != 0
              || !
#line 1357 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
            return -1;
          return 2077; /* andv2sf3 */

        case E_V2BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2BFmode) != 0
              || !
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return -1;
          return 2111; /* andv2bf3 */

        case E_V4BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4BFmode) != 0
              || !(
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return -1;
          return 2114; /* andv4bf3 */

        case E_V2HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2HFmode) != 0
              || !
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
            return -1;
          return 2117; /* andv2hf3 */

        case E_V4HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4HFmode) != 0
              || !(
#line 2583 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2226 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return -1;
          return 2120; /* andv4hf3 */

        case E_V8QImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V8QImode) != 0
              || !
#line 4692 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V8QImode, operands)))
            return -1;
          return 2274; /* *mmx_andv8qi3 */

        case E_V4HImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V4HImode) != 0
              || !
#line 4692 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V4HImode, operands)))
            return -1;
          return 2277; /* *mmx_andv4hi3 */

        case E_V2SImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V2SImode) != 0
              || !
#line 4692 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (AND, V2SImode, operands)))
            return -1;
          return 2280; /* *mmx_andv2si3 */

        case E_V4QImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V4QImode) != 0
              || !
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V4QImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2283; /* *andv4qi3 */

        case E_V2QImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V2QImode) != 0
              || !
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2QImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2286; /* *andv2qi3 */

        case E_V2HImode:
          x2 = XEXP (x1, 1);
          if (pattern75 (x2, pnum_clobbers, 
E_V2HImode) != 0
              || !
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2HImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 2289; /* *andv2hi3 */

        case E_BFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_BFmode) != 0
              || !
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3745; /* andbf3 */

        case E_HFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_HFmode) != 0
              || !
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3748; /* andhf3 */

        case E_SFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_SFmode) != 0
              || !
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3751; /* andsf3 */

        case E_DFmode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_DFmode) != 0
              || !(
#line 5666 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1352 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE2)))
            return -1;
          return 3754; /* anddf3 */

        case E_TFmode:
          x2 = XEXP (x1, 1);
          if (pattern25 (x2, 
E_TFmode) != 0
              || !
#line 5740 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 3757; /* *andtf3 */

        default:
          return -1;
        }

    case 1:
      if (!
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 725; /* *andqi_1_slp */

    case 2:
      if (!
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 728; /* *andhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_41 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x3;
      x4 = XEXP (x2, 1);
      switch (GET_CODE (x4))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          if (pnum_clobbers != NULL
              && GET_CODE (x4) == SUBREG
              && pattern427 (x1, 
E_TImode) == 0
              && (
#line 15217 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1053; /* *ashlti3_doubleword_mask */
            }
          operands[2] = x4;
          switch (pattern258 (x1, pnum_clobbers))
            {
            case 0:
              switch (GET_MODE (operands[0]))
                {
                case E_TImode:
                  if (pnum_clobbers == NULL
                      || !register_operand (operands[0], E_TImode)
                      || GET_MODE (x2) != E_TImode
                      || !reg_or_pm1_operand (operands[1], E_TImode)
                      || !nonmemory_operand (operands[2], E_QImode)
                      || !
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1057; /* ashlti3_doubleword */

                case E_HImode:
                  if (pattern623 (x2, 
E_HImode) != 0)
                    return -1;
                  if (
#line 16109 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, HImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                    return 1104; /* *ashlhi3_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 16109 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, HImode, operands, TARGET_APX_NDD)
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1105; /* *ashlhi3_1 */

                case E_QImode:
                  if (pattern623 (x2, 
E_QImode) != 0)
                    return -1;
                  if (
#line 16168 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, QImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
                    return 1106; /* *ashlqi3_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 16168 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFT, QImode, operands, TARGET_APX_NDD)
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1107; /* *ashlqi3_1 */

                case E_V4HImode:
                  if (pattern738 (x2, 
E_V4HImode, 
E_DImode) != 0
                      || !
#line 3896 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2202; /* mmx_ashlv4hi3 */

                case E_V2SImode:
                  if (pattern738 (x2, 
E_V2SImode, 
E_DImode) != 0
                      || !
#line 3896 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2204; /* mmx_ashlv2si3 */

                case E_V1DImode:
                  if (pattern738 (x2, 
E_V1DImode, 
E_DImode) != 0
                      || !
#line 3896 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return -1;
                  return 2206; /* mmx_ashlv1di3 */

                case E_V1SImode:
                  if (pattern738 (x2, 
E_V1SImode, 
E_DImode) != 0
                      || !
#line 3933 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2208; /* mmx_ashlv1si3 */

                case E_V2HImode:
                  if (pattern738 (x2, 
E_V2HImode, 
E_DImode) != 0
                      || !
#line 3950 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2210; /* ashlv2hi3 */

                case E_V2QImode:
                  if (pnum_clobbers == NULL
                      || pattern738 (x2, 
E_V2QImode, 
E_QImode) != 0
                      || !
#line 4012 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size))
                    return -1;
                  *pnum_clobbers = 1;
                  return 2214; /* ashlv2qi3 */

                default:
                  return -1;
                }

            case 1:
              if (!
#line 16247 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 1108; /* *ashlqi3_1_slp */

            case 2:
              if (!
#line 16247 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 1109; /* *ashlhi3_1_slp */

            default:
              return -1;
            }

        case AND:
          if (pattern0 (x1, pnum_clobbers) != 0
              || !(
#line 15278 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1055; /* *ashlti3_doubleword_mask_1 */

        default:
          return -1;
        }

    case SIGN_EXTEND:
      if (pattern42 (x1, pnum_clobbers) != 0
          || !(
#line 15379 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1060; /* *ashlti3_doubleword_highpart */

    case ZERO_EXTEND:
      if (pattern42 (x1, pnum_clobbers) != 0
          || !(
#line 15379 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) >= 8 * BITS_PER_UNIT
   && INTVAL (operands[2]) < 8 * BITS_PER_UNIT * 2) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1061; /* *ashlti3_doubleword_highpart */

    default:
      return -1;
    }
}

 int
recog_47 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (GET_CODE (x3))
    {
    case NE:
    case EQ:
    case GE:
    case GT:
    case LE:
    case LT:
      res = recog_46 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      break;

    default:
      break;
    }
  operands[3] = x3;
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_SFmode:
      if (pattern744 (
E_SFmode) != 0
          || !
#line 19708 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)))
        return -1;
      return 1455; /* setcc_sf_sse */

    case E_DFmode:
      if (pattern744 (
E_DFmode) != 0
          || !
#line 19708 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)))
        return -1;
      return 1456; /* setcc_df_sse */

    default:
      return -1;
    }
}

 int
recog_51 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (pattern82 (x1, pnum_clobbers))
    {
    case 0:
      switch (GET_MODE (operands[0]))
        {
        case E_TImode:
          x2 = XEXP (x1, 1);
          if (pattern73 (x2, pnum_clobbers) != 0
              || !(
#line 6477 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 267; /* *addti3_doubleword */

        case E_HImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_HImode) != 0)
            return -1;
          if (
#line 6825 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && TARGET_APX_NF))
            return 297; /* *addhi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 6825 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          *pnum_clobbers = 1;
          return 298; /* *addhi_1 */

        case E_QImode:
          x2 = XEXP (x1, 1);
          if (pattern74 (x2, 
E_QImode) != 0)
            return -1;
          if (
#line 6882 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && TARGET_APX_NF))
            return 299; /* *addqi_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 6882 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
  && true))
            return -1;
          *pnum_clobbers = 1;
          return 300; /* *addqi_1 */

        case E_HFmode:
          x2 = XEXP (x1, 1);
          if (pattern5 (x2, 
E_HFmode) != 0
              || !
#line 23483 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          return 1676; /* *addhf */

        case E_V8QImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V8QImode) != 0
              || !
#line 3216 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V8QImode, operands)))
            return -1;
          return 2124; /* *mmx_addv8qi3 */

        case E_V4HImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V4HImode) != 0
              || !
#line 3216 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V4HImode, operands)))
            return -1;
          return 2126; /* *mmx_addv4hi3 */

        case E_V2SImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V2SImode) != 0
              || !
#line 3216 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V2SImode, operands)))
            return -1;
          return 2128; /* *mmx_addv2si3 */

        case E_V1DImode:
          x2 = XEXP (x1, 1);
          if (pattern8 (x2, 
E_V1DImode) != 0
              || !(
#line 3216 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (PLUS, V1DImode, operands)) && 
#line 50 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2)))
            return -1;
          return 2130; /* *mmx_addv1di3 */

        case E_V4QImode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V4QImode) != 0
              || !
#line 3232 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2132; /* addv4qi3 */

        case E_V2HImode:
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2HImode) != 0
              || !
#line 3232 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2134; /* addv2hi3 */

        case E_V2QImode:
          if (pnum_clobbers == NULL)
            return -1;
          x2 = XEXP (x1, 1);
          if (pattern7 (x2, 
E_V2QImode) != 0
              || !
#line 3246 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size || TARGET_SSE2))
            return -1;
          *pnum_clobbers = 1;
          return 2136; /* addv2qi3 */

        default:
          return -1;
        }

    case 1:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 301; /* *addqi_1_slp */

    case 2:
      if (!
#line 6958 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      *pnum_clobbers = 1;
      return 302; /* *addhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_59 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      if (pattern95 (x3, 
E_V2SFmode, 
E_SFmode) != 0)
        return -1;
      x5 = XEXP (x3, 1);
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      if (!nonimmediate_operand (operands[2], E_V2SFmode)
          || pattern1833 (x3) != 0
          || !
#line 995 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW
   && INTVAL (operands[3]) != INTVAL (operands[4])
   && INTVAL (operands[5]) != INTVAL (operands[6])))
        return -1;
      return 2064; /* *mmx_haddv2sf3 */

    case MINUS:
      if (pattern96 (x4, 
E_SFmode) != 0
          || !register_operand (operands[0], E_V2SFmode)
          || GET_MODE (x3) != E_V2SFmode)
        return -1;
      x8 = XEXP (x4, 0);
      x9 = XEXP (x8, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_V2SFmode))
        return -1;
      x5 = XEXP (x3, 1);
      if (GET_MODE (x5) != E_SFmode)
        return -1;
      x10 = XEXP (x4, 1);
      x11 = XEXP (x10, 0);
      if (!rtx_equal_p (x11, operands[1]))
        return -1;
      switch (GET_CODE (x5))
        {
        case MINUS:
          if (pattern1537 (x5, 
E_SFmode) != 0)
            return -1;
          x6 = XEXP (x5, 0);
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_V2SFmode))
            return -1;
          x12 = XEXP (x5, 1);
          x13 = XEXP (x12, 0);
          if (!rtx_equal_p (x13, operands[2])
              || !
#line 1043 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW_A))
            return -1;
          return 2066; /* mmx_hsubv2sf3 */

        case PLUS:
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != VEC_SELECT
              || GET_MODE (x6) != E_SFmode)
            return -1;
          x14 = XEXP (x6, 1);
          if (GET_CODE (x14) != PARALLEL
              || XVECLEN (x14, 0) != 1)
            return -1;
          x12 = XEXP (x5, 1);
          if (GET_CODE (x12) != VEC_SELECT
              || GET_MODE (x12) != E_SFmode)
            return -1;
          x15 = XEXP (x12, 1);
          if (GET_CODE (x15) != PARALLEL
              || XVECLEN (x15, 0) != 1)
            return -1;
          x7 = XEXP (x6, 0);
          operands[2] = x7;
          if (!nonimmediate_operand (operands[2], E_V2SFmode))
            return -1;
          x16 = XVECEXP (x14, 0, 0);
          operands[3] = x16;
          if (!const_0_to_1_operand (operands[3], E_SImode))
            return -1;
          x17 = XVECEXP (x15, 0, 0);
          operands[4] = x17;
          if (!const_0_to_1_operand (operands[4], E_SImode))
            return -1;
          x13 = XEXP (x12, 0);
          if (!rtx_equal_p (x13, operands[2])
              || !
#line 1105 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW_A
   && INTVAL (operands[3]) != INTVAL (operands[4])))
            return -1;
          return 2068; /* *mmx_haddsubv2sf3 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V2SFmode:
          if (!register_operand (operands[0], E_V2SFmode)
              || GET_MODE (x3) != E_V2SFmode
              || !nonimmediate_operand (operands[1], E_SFmode))
            return -1;
          if (nonimm_or_0_operand (operands[2], E_SFmode))
            {
              if (
#line 1755 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX && !TARGET_SSE))
                return 2092; /* *mmx_concatv2sf */
              if (
#line 11739 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return 5190; /* *vec_concatv2sf_sse4_1 */
            }
          if (!reg_or_0_operand (operands[2], E_SFmode)
              || !
#line 11803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 5191; /* *vec_concatv2sf_sse */

        case E_V2SImode:
          if (!register_operand (operands[0], E_V2SImode)
              || GET_MODE (x3) != E_V2SImode
              || !nonimmediate_operand (operands[1], E_SImode))
            return -1;
          if (nonimm_or_0_operand (operands[2], E_SImode))
            {
              if (
#line 5706 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX && !TARGET_SSE))
                return 2348; /* *mmx_concatv2si */
              if (
#line 21493 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                return 8406; /* *vec_concatv2si_sse4_1 */
            }
          if (!reg_or_0_operand (operands[2], E_SImode)
              || !
#line 21542 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && !TARGET_SSE4_1))
            return -1;
          return 8407; /* *vec_concatv2si */

        default:
          return -1;
        }

    case SS_TRUNCATE:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SS_TRUNCATE)
        return -1;
      switch (pattern272 (x3))
        {
        case 0:
          if (!
#line 4776 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2292; /* mmx_packsswb */

        case 1:
          if (!
#line 4817 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2294; /* mmx_packssdw */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_65 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case LSHIFTRT:
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case MULT:
          if (XWINT (x5, 0) != 16L)
            return -1;
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case SIGN_EXTEND:
              switch (pattern748 (x3, 
SIGN_EXTEND))
                {
                case 0:
                  if (!
#line 3452 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                    return -1;
                  return 2161; /* *mmx_smulv4hi3_highpart */

                case 1:
                  if (!
#line 3521 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2163; /* smulv2hi3_highpart */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              switch (pattern748 (x3, 
ZERO_EXTEND))
                {
                case 0:
                  if (!
#line 3487 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                    return -1;
                  return 2162; /* *mmx_umulv4hi3_highpart */

                case 1:
                  if (!
#line 3521 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                    return -1;
                  return 2164; /* umulv2hi3_highpart */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case PLUS:
          x7 = XEXP (x6, 0);
          switch (GET_CODE (x7))
            {
            case MULT:
              if (GET_MODE (x7) != E_V4SImode)
                return -1;
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != SIGN_EXTEND
                  || GET_MODE (x8) != E_V4SImode)
                return -1;
              x9 = XEXP (x7, 1);
              if (GET_CODE (x9) != SIGN_EXTEND
                  || GET_MODE (x9) != E_V4SImode)
                return -1;
              x10 = XEXP (x6, 1);
              if (GET_CODE (x10) != CONST_VECTOR
                  || XVECLEN (x10, 0) != 4
                  || GET_MODE (x10) != E_V4SImode)
                return -1;
              x11 = XVECEXP (x10, 0, 0);
              if (GET_CODE (x11) != CONST_INT
                  || XWINT (x11, 0) != 32768L)
                return -1;
              x12 = XVECEXP (x10, 0, 1);
              if (GET_CODE (x12) != CONST_INT
                  || XWINT (x12, 0) != 32768L)
                return -1;
              x13 = XVECEXP (x10, 0, 2);
              if (GET_CODE (x13) != CONST_INT
                  || XWINT (x13, 0) != 32768L)
                return -1;
              x14 = XVECEXP (x10, 0, 3);
              if (GET_CODE (x14) != CONST_INT
                  || XWINT (x14, 0) != 32768L
                  || XWINT (x5, 0) != 16L
                  || !register_operand (operands[0], E_V4HImode)
                  || GET_MODE (x3) != E_V4HImode
                  || GET_MODE (x4) != E_V4SImode
                  || GET_MODE (x6) != E_V4SImode)
                return -1;
              x15 = XEXP (x8, 0);
              operands[1] = x15;
              if (!nonimmediate_operand (operands[1], E_V4HImode))
                return -1;
              x16 = XEXP (x9, 0);
              operands[2] = x16;
              if (!nonimmediate_operand (operands[2], E_V4HImode)
                  || !
#line 3610 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (MULT, V4HImode, operands)))
                return -1;
              return 2166; /* *mmx_pmulhrwv4hi3 */

            case PLUS:
              x8 = XEXP (x7, 0);
              if (GET_CODE (x8) != ZERO_EXTEND)
                return -1;
              x9 = XEXP (x7, 1);
              if (GET_CODE (x9) != ZERO_EXTEND)
                return -1;
              x10 = XEXP (x6, 1);
              if (GET_CODE (x10) != CONST_VECTOR
                  || XWINT (x5, 0) != 1L)
                return -1;
              x15 = XEXP (x8, 0);
              operands[1] = x15;
              x16 = XEXP (x9, 0);
              operands[2] = x16;
              switch (XVECLEN (x10, 0))
                {
                case 8:
                  if (pattern1347 (x10, 
E_V8HImode) != 0
                      || pattern1617 (x3, 
E_V8QImode, 
E_V8HImode) != 0
                      || !
#line 6337 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 2378; /* *mmx_uavgv8qi3 */

                case 4:
                  x11 = XVECEXP (x10, 0, 0);
                  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x12 = XVECEXP (x10, 0, 1);
                  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x13 = XVECEXP (x10, 0, 2);
                  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x14 = XVECEXP (x10, 0, 3);
                  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V4HImode:
                      if (pattern1617 (x3, 
E_V4HImode, 
E_V4SImode) != 0
                          || GET_MODE (x10) != E_V4SImode
                          || !
#line 6381 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                        return -1;
                      return 2379; /* *mmx_uavgv4hi3 */

                    case E_V4QImode:
                      if (pattern1520 (x3, 
E_V4HImode, 
E_V4QImode) != 0
                          || !
#line 6421 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2380; /* uavgv4qi3_ceil */

                    default:
                      return -1;
                    }

                case 2:
                  x11 = XVECEXP (x10, 0, 0);
                  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  x12 = XVECEXP (x10, 0, 1);
                  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                    return -1;
                  switch (GET_MODE (operands[0]))
                    {
                    case E_V2QImode:
                      if (pattern1520 (x3, 
E_V2HImode, 
E_V2QImode) != 0
                          || !
#line 6441 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2381; /* uavgv2qi3_ceil */

                    case E_V2HImode:
                      if (pattern1520 (x3, 
E_V2SImode, 
E_V2HImode) != 0
                          || !
#line 6461 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                        return -1;
                      return 2382; /* uavgv2hi3_ceil */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case LSHIFTRT:
              if (pattern616 (x7) != 0
                  || XWINT (x5, 0) != 1L)
                return -1;
              x8 = XEXP (x7, 0);
              x15 = XEXP (x8, 0);
              x17 = XEXP (x15, 0);
              operands[1] = x17;
              x18 = XEXP (x8, 1);
              x19 = XEXP (x18, 0);
              operands[2] = x19;
              x10 = XEXP (x6, 1);
              operands[3] = x10;
              switch (GET_MODE (operands[0]))
                {
                case E_V4HImode:
                  if (pattern1497 (x3, 
E_V4SImode, 
E_V4HImode) != 0
                      || !register_mmxmem_operand (operands[1], E_V4HImode)
                      || GET_MODE (x18) != E_V4SImode
                      || !register_mmxmem_operand (operands[2], E_V4HImode)
                      || !const1_operand (operands[3], E_V4HImode)
                      || !
#line 23058 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_SSSE3
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8549; /* *ssse3_pmulhrswv4hi3 */

                case E_V2HImode:
                  if (pattern1497 (x3, 
E_V2SImode, 
E_V2HImode) != 0
                      || !register_operand (operands[1], E_V2HImode)
                      || GET_MODE (x18) != E_V2SImode
                      || !register_operand (operands[2], E_V2HImode)
                      || !const1_operand (operands[3], E_V2HImode)
                      || !
#line 23103 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
                    return -1;
                  return 8550; /* *smulhrsv2hi3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V4QImode:
          if (GET_MODE (x3) != E_V4QImode)
            return -1;
          if (register_operand (operands[0], E_V4QImode)
              && register_operand (operands[1], E_V4HImode)
              && (
#line 5149 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_AVX512BW) && 
#line 73 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
            return 2312; /* avx512vl_truncv4hiv4qi2 */
          if (!memory_operand (operands[0], E_V4QImode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode)
                  || !
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7238; /* *avx512vl_truncatev4siv4qi2_store_1 */

            case E_V4DImode:
              if (!register_operand (operands[1], E_V4DImode)
                  || !
#line 15481 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7241; /* *avx512vl_truncatev4div4qi2_store_1 */

            default:
              return -1;
            }

        case E_V2QImode:
          if (GET_MODE (x3) != E_V2QImode)
            return -1;
          if (register_operand (operands[0], E_V2QImode))
            {
              switch (GET_MODE (operands[1]))
                {
                case E_V2HImode:
                  if (register_operand (operands[1], E_V2HImode)
                      && 
#line 5149 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_AVX512BW))
                    return 2313; /* avx512vl_truncv2hiv2qi2 */
                  break;

                case E_V2SImode:
                  if (register_operand (operands[1], E_V2SImode)
                      && 
#line 5175 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_MMX_WITH_SSE))
                    return 2314; /* avx512vl_truncv2siv2qi2 */
                  break;

                default:
                  break;
                }
            }
          if (!memory_operand (operands[0], E_V2QImode)
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15386 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7223; /* *avx512vl_truncatev2div2qi2_store_1 */

        case E_V2HImode:
          if (GET_MODE (x3) != E_V2HImode)
            return -1;
          if (register_operand (operands[0], E_V2HImode)
              && register_operand (operands[1], E_V2SImode)
              && 
#line 5175 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_AVX512VL && TARGET_MMX_WITH_SSE))
            return 2315; /* avx512vl_truncv2siv2hi2 */
          if (!memory_operand (operands[0], E_V2HImode)
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7338; /* *avx512vl_truncatev2div2hi2_store_1 */

        case E_V8QImode:
          switch (pattern12 (x3))
            {
            case 0:
              if (!(
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 15573 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return -1;
              return 7268; /* *avx512vl_truncatev8hiv8qi2_store_1 */

            case 1:
              if (!
#line 15579 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7271; /* *avx512vl_truncatev8siv8qi2_store_1 */

            case 2:
              if (!
#line 16095 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 7375; /* *avx512f_truncatev8div16qi2_store_1 */

            default:
              return -1;
            }

        case E_V4HImode:
          switch (pattern11 (x3, 
E_V4HImode))
            {
            case 0:
              if (!
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7308; /* *avx512vl_truncatev4siv4hi2_store_1 */

            case 1:
              if (!
#line 15741 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                return -1;
              return 7311; /* *avx512vl_truncatev4div4hi2_store_1 */

            default:
              return -1;
            }

        case E_V2SImode:
          if (!memory_operand (operands[0], E_V2SImode)
              || GET_MODE (x3) != E_V2SImode
              || !register_operand (operands[1], E_V2DImode)
              || !
#line 15982 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 7357; /* *avx512vl_truncatev2div2si2_store_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_75 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case PLUS:
      return recog_70 (x1, insn, pnum_clobbers);

    case MINUS:
      return recog_72 (x1, insn, pnum_clobbers);

    case MULT:
      return recog_74 (x1, insn, pnum_clobbers);

    case SMUL_HIGHPART:
      if (pattern106 (x3, pnum_clobbers) != 0
          || !
#line 11162 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 2;
      return 631; /* *smulsi3_highpart_zext */

    case UMUL_HIGHPART:
      if (pattern106 (x3, pnum_clobbers) != 0
          || !
#line 11162 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 2;
      return 632; /* *umulsi3_highpart_zext */

    case TRUNCATE:
      if (pnum_clobbers == NULL
          || GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != LSHIFTRT
          || GET_MODE (x5) != E_DImode)
        return -1;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != MULT
          || GET_MODE (x6) != E_DImode)
        return -1;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 32]
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x8 = XEXP (x6, 0);
      if (GET_MODE (x8) != E_DImode)
        return -1;
      x9 = XEXP (x6, 1);
      if (GET_MODE (x9) != E_DImode)
        return -1;
      switch (GET_CODE (x8))
        {
        case SIGN_EXTEND:
          if (GET_CODE (x9) != SIGN_EXTEND)
            return -1;
          x10 = XEXP (x8, 0);
          operands[1] = x10;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x11 = XEXP (x9, 0);
          operands[2] = x11;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 635; /* *smulsi3_highpart_zext */

        case ZERO_EXTEND:
          if (GET_CODE (x9) != ZERO_EXTEND)
            return -1;
          x10 = XEXP (x8, 0);
          operands[1] = x10;
          if (!nonimmediate_operand (operands[1], E_SImode))
            return -1;
          x11 = XEXP (x9, 0);
          operands[2] = x11;
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !
#line 11210 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 2;
          return 636; /* *umulsi3_highpart_zext */

        default:
          return -1;
        }

    case AND:
      return recog_71 (x1, insn, pnum_clobbers);

    case IOR:
      switch (pattern108 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 847; /* *iorqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 848; /* *iorqi_1_zextsi */

        case 1:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 855; /* *iorhi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 856; /* *iorhi_1_zextsi */

        case 2:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 851; /* *iorqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 852; /* *iorqi_1_zextdi */

        case 3:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 859; /* *iorhi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 860; /* *iorhi_1_zextdi */

        case 4:
          if (!
#line 13759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (IOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 863; /* *iorsi_1_zext */

        default:
          return -1;
        }

    case XOR:
      switch (pattern108 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 849; /* *xorqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 850; /* *xorqi_1_zextsi */

        case 1:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 857; /* *xorhi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 858; /* *xorhi_1_zextsi */

        case 2:
          if (
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 853; /* *xorqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 854; /* *xorqi_1_zextdi */

        case 3:
          if (
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return 861; /* *xorhi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 13743 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))))
            return -1;
          *pnum_clobbers = 1;
          return 862; /* *xorhi_1_zextdi */

        case 4:
          if (!
#line 13759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (XOR, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 864; /* *xorsi_1_zext */

        default:
          return -1;
        }

    case NEG:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern283 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 964; /* *negqi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 965; /* *negqi_1_zextsi */

        case 1:
          if (
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 968; /* *neghi_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 969; /* *neghi_1_zextsi */

        case 2:
          if (
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 966; /* *negqi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14374 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 967; /* *negqi_1_zextdi */

        case 3:
          if (
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 970; /* *neghi_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 14384 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 971; /* *neghi_1_zextdi */

        case 4:
          if (!
#line 14395 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NEG, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 972; /* *negsi_1_zext */

        default:
          return -1;
        }

    case NOT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          switch (pattern282 (x3))
            {
            case 0:
              if (!
#line 15016 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1036; /* *one_cmplqi2_1_zextsi */

            case 1:
              if (!
#line 15025 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1038; /* *one_cmplhi2_1_zextsi */

            default:
              return -1;
            }

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_QImode:
              if (!nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 15016 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1037; /* *one_cmplqi2_1_zextdi */

            case E_HImode:
              if (!nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 15025 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD))
                return -1;
              return 1039; /* *one_cmplhi2_1_zextdi */

            case E_SImode:
              if (!nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 15034 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_unary_operator_ok (NOT, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1040; /* *one_cmplsi2_1_zext */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case ASHIFT:
      switch (pattern109 (x3))
        {
        case 0:
          if (register_operand (operands[2], E_SImode)
              && 
#line 16012 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return 1092; /* *bmi2_ashlsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 16045 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1103; /* *ashlsi3_1_zext */

        case 1:
          if (
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1097; /* *ashlqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1098; /* *ashlqi3_1_zextdi */

        case 2:
          if (
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1101; /* *ashlhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1102; /* *ashlhi3_1_zextdi */

        case 3:
          if (
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1095; /* *ashlqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16022 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1096; /* *ashlqi3_1_zextsi */

        case 4:
          if (
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1099; /* *ashlhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 16033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1100; /* *ashlhi3_1_zextsi */

        default:
          return -1;
        }

    case ASHIFTRT:
      if (GET_MODE (x4) == E_SImode
          && register_operand (operands[0], E_DImode))
        {
          res = recog_68 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
        }
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern284 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1192; /* *ashrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1193; /* *ashrqi3_1_zextsi */

        case 1:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1200; /* *ashrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1201; /* *ashrhi3_1_zextsi */

        case 2:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1196; /* *ashrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1197; /* *ashrqi3_1_zextdi */

        case 3:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1204; /* *ashrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1205; /* *ashrhi3_1_zextdi */

        case 4:
          if (!
#line 17492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1207; /* *ashrsi3_1_zext */

        default:
          return -1;
        }

    case LSHIFTRT:
      switch (pattern109 (x3))
        {
        case 0:
          if (register_operand (operands[2], E_SImode)
              && 
#line 17459 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2))
            return 1184; /* *bmi2_lshrsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 17492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (LSHIFTRT, SImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 1206; /* *lshrsi3_1_zext */

        case 1:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1194; /* *lshrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1195; /* *lshrqi3_1_zextdi */

        case 2:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1202; /* *lshrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1203; /* *lshrhi3_1_zextdi */

        case 3:
          if (
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1190; /* *lshrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1191; /* *lshrqi3_1_zextsi */

        case 4:
          if (
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1198; /* *lshrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 17480 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1199; /* *lshrhi3_1_zextsi */

        default:
          return -1;
        }

    case ROTATERT:
      switch (pattern109 (x3))
        {
        case 0:
          if (const_0_to_31_operand (operands[2], E_QImode)
              && 
#line 18592 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && !optimize_function_for_size_p (cfun)))
            return 1350; /* *bmi2_rorxsi3_1_zext */
          if (pnum_clobbers == NULL
              || !nonmemory_operand (operands[2], E_QImode)
              || !
#line 18625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATERT, SImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 1372; /* *rotrsi3_1_zext */

        case 1:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1361; /* *rotrqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1362; /* *rotrqi3_1_zextdi */

        case 2:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1369; /* *rotrhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1370; /* *rotrhi3_1_zextdi */

        case 3:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1357; /* *rotrqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1358; /* *rotrqi3_1_zextsi */

        case 4:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1365; /* *rotrhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1366; /* *rotrhi3_1_zextsi */

        default:
          return -1;
        }

    case ROTATE:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern284 (x3, pnum_clobbers))
        {
        case 0:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1355; /* *rotlqi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1356; /* *rotlqi3_1_zextsi */

        case 1:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1363; /* *rotlhi3_1_zextsi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1364; /* *rotlhi3_1_zextsi */

        case 2:
          if (
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1359; /* *rotlqi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18602 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1360; /* *rotlqi3_1_zextdi */

        case 3:
          if (
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
            return 1367; /* *rotlhi3_1_zextdi_nf */
          if (pnum_clobbers == NULL
              || !
#line 18613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
            return -1;
          *pnum_clobbers = 1;
          return 1368; /* *rotlhi3_1_zextdi */

        case 4:
          if (!
#line 18625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_binary_operator_ok (ROTATE, SImode, operands)))
            return -1;
          *pnum_clobbers = 1;
          return 1371; /* *rotlsi3_1_zext */

        default:
          return -1;
        }

    case CTZ:
      if (pattern110 (x3, pnum_clobbers, 
E_SImode, 
E_DImode) != 0
          || !
#line 21193 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 1521; /* *ctzsidi2_uext */

    case CLZ:
      if (pattern110 (x3, pnum_clobbers, 
E_SImode, 
E_DImode) != 0
          || !
#line 21628 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT))
        return -1;
      *pnum_clobbers = 1;
      return 1543; /* *clzsi2_lzcnt_zext_2 */

    case POPCOUNT:
      if (pnum_clobbers == NULL)
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern617 (x3, 
E_DImode, 
E_SImode) != 0
              || !
#line 22465 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1634; /* *popcountsi2_zext_2 */

        case E_SImode:
          if (pattern617 (x3, 
E_SImode, 
E_HImode) != 0
              || !
#line 22531 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1637; /* *popcounthi2_2 */

        default:
          return -1;
        }

    case UNSPEC:
      return recog_69 (x1, insn, pnum_clobbers);

    case IF_THEN_ELSE:
      if (GET_MODE (x4) != E_SImode)
        return -1;
      x5 = XEXP (x4, 0);
      if (!ix86_comparison_operator (x5, E_VOIDmode))
        return -1;
      operands[1] = x5;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17)
        return -1;
      x7 = XEXP (x5, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || !nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x12 = XEXP (x4, 1);
      operands[2] = x12;
      if (!nonimmediate_operand (operands[2], E_SImode))
        return -1;
      x13 = XEXP (x4, 2);
      operands[3] = x13;
      if (!nonimmediate_operand (operands[3], E_SImode)
          || !
#line 26393 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_CMOVE && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
        return -1;
      return 1807; /* *movsicc_noc_zext_1 */

    case VEC_SELECT:
      return recog_73 (x1, insn, pnum_clobbers);

    case SUBREG:
      if (pattern111 (x3) != 0
          || !
#line 22139 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
        return -1;
      return 8488; /* *sse2_pmovskb_zexthisi */

    default:
      return -1;
    }
}

 int
recog_102 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  switch (pattern20 (x1, pnum_clobbers))
    {
    case 0:
      if (!
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1297; /* *rotrsi3_mask_1 */

    case 1:
      if (!(
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1299; /* *rotrdi3_mask_1 */

    case 2:
      if (!
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1313; /* *rotrsi3_add_1 */

    case 3:
      if (!(
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1315; /* *rotrdi3_add_1 */

    case 4:
      if (!
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1329; /* *rotrsi3_sub_1 */

    case 5:
      if (!(
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1331; /* *rotrdi3_sub_1 */

    case 6:
      x2 = XEXP (x1, 1);
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case SUBREG:
          switch (pattern454 (x2, pnum_clobbers))
            {
            case 0:
              if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1289; /* *rotrsi3_mask */
                }
              break;

            case 1:
              if ((
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1291; /* *rotrdi3_mask */
                }
              break;

            case 2:
              if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1305; /* *rotrsi3_add */
                }
              break;

            case 3:
              if ((
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1307; /* *rotrdi3_add */
                }
              break;

            case 4:
              if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                {
                  *pnum_clobbers = 1;
                  return 1321; /* *rotrsi3_sub */
                }
              break;

            case 5:
              if ((
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                {
                  *pnum_clobbers = 1;
                  return 1323; /* *rotrdi3_sub */
                }
              break;

            default:
              break;
            }
          break;

        case CONST_INT:
          operands[2] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (pattern613 (x2, pnum_clobbers, 
E_DImode) == 0
                  && const_1_to_31_operand (operands[2], E_QImode)
                  && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                {
                  *pnum_clobbers = 2;
                  return 1334; /* ix86_rotrdi3_doubleword */
                }
              break;

            case E_SImode:
              if (register_operand (operands[0], E_SImode)
                  && GET_MODE (x2) == E_SImode
                  && nonimmediate_operand (operands[1], E_SImode)
                  && const_0_to_31_operand (operands[2], E_QImode)
                  && 
#line 18500 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && !optimize_function_for_size_p (cfun)))
                return 1340; /* *bmi2_rorxsi3_1 */
              break;

            default:
              break;
            }
          if (register_operand (operands[0], E_DImode)
              && GET_MODE (x2) == E_DImode)
            {
              if (XWINT (x3, 0) == 32L
                  && register_operand (operands[1], E_DImode)
                  && 
#line 18459 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return 1337; /* rotr32di2_doubleword */
              if (nonimmediate_operand (operands[1], E_DImode))
                {
                  operands[2] = x3;
                  if (const_0_to_63_operand (operands[2], E_QImode)
                      && (
#line 18500 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2 && !optimize_function_for_size_p (cfun)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1341; /* *bmi2_rorxdi3_1 */
                }
            }
          break;

        default:
          break;
        }
      operands[2] = x3;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      switch (pattern16 (x2))
        {
        case 0:
          if (
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
            return 1344; /* *rotrsi3_1_nf */
          if (pnum_clobbers == NULL
              || !
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          *pnum_clobbers = 1;
          return 1345; /* *rotrsi3_1 */

        case 1:
          if ((
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1348; /* *rotrdi3_1_nf */
          if (pnum_clobbers == NULL
              || !(
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1349; /* *rotrdi3_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_113 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (pattern126 (x3))
    {
    case 0:
      if (
#line 21517 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_LZCNT))
        return 1532; /* clzsi2_lzcnt_nf */
      if (pnum_clobbers == NULL
          || !
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
        return -1;
      *pnum_clobbers = 1;
      return 1534; /* clzsi2_lzcnt */

    case 1:
      if ((
#line 21517 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1533; /* clzdi2_lzcnt_nf */
      if (pnum_clobbers == NULL
          || !(
#line 21536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1535; /* clzdi2_lzcnt */

    default:
      return -1;
    }
}

 int
recog_116 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  switch (XVECLEN (x3, 0))
    {
    case 1:
      switch (XINT (x3, 1))
        {
        case 2:
          if (pnum_clobbers == NULL)
            return -1;
          switch (pattern304 (x3))
            {
            case 0:
              if (!(
#line 27234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              *pnum_clobbers = 1;
              return 1859; /* allocate_stack_worker_probe_si */

            case 1:
              if (!(
#line 27234 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_target_stack_probe ()) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              *pnum_clobbers = 1;
              return 1860; /* allocate_stack_worker_probe_di */

            default:
              return -1;
            }

        case 11:
          if (GET_MODE (x3) != E_DImode
              || !register_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 29107 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1895; /* rdpmc */

        case 9:
          if (GET_MODE (x3) != E_DImode)
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !register_operand (operands[0], E_DImode)
              || !
#line 29126 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 1897; /* rdtsc */

        case 36:
          if (GET_MODE (x3) != E_DImode
              || !register_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          if (!register_operand (operands[1], E_SImode)
              || !
#line 29350 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_XSAVE))
            return -1;
          return 1925; /* xgetbv */

        case 13:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!(
#line 29444 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1933; /* lwp_slwpcbsi */

            case 1:
              if (!(
#line 29444 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LWP) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1934; /* lwp_slwpcbdi */

            default:
              return -1;
            }

        case 16:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1939; /* rdfsbasesi */

            case 1:
              if (!(
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1941; /* rdfsbasedi */

            default:
              return -1;
            }

        case 17:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE))
                return -1;
              return 1940; /* rdgsbasesi */

            case 1:
              if (!(
#line 29492 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_FSGSBASE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1942; /* rdgsbasedi */

            default:
              return -1;
            }

        case 59:
          switch (pattern304 (x3))
            {
            case 0:
              if (!
#line 29560 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)))
                return -1;
              return 1956; /* rdsspsi */

            case 1:
              if (!(
#line 29560 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SHSTK || (flag_cf_protection & CF_RETURN)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1957; /* rdsspdi */

            default:
              return -1;
            }

        case 57:
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (pattern23 (x3))
            {
            case 0:
              if (!
#line 29800 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_RDPID))
                return -1;
              return 1982; /* rdpid */

            case 1:
              if (!
#line 29807 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_RDPID))
                return -1;
              return 1983; /* rdpid_rex64 */

            default:
              return -1;
            }

        case 85:
          if (GET_MODE (x3) != E_DImode
              || !register_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          if (!x86_64_szext_nonmemory_operand (operands[1], E_DImode)
              || !
#line 30083 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USER_MSR && TARGET_64BIT))
            return -1;
          return 2011; /* urdmsr */

        case 89:
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (!register_operand (operands[0], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !memory_operand (operands[1], E_SImode)
                  || !
#line 30121 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVRS && TARGET_64BIT))
                return -1;
              return 2017; /* movrssi */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x3) != E_DImode
                  || !memory_operand (operands[1], E_DImode)
                  || !
#line 30121 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVRS && TARGET_64BIT))
                return -1;
              return 2018; /* movrsdi */

            default:
              return -1;
            }

        case 93:
          if (GET_MODE (x3) != E_SImode)
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
              || !memory_operand (operands[0], E_SImode)
              || !
#line 22498 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 8509; /* sse_stmxcsr */

        default:
          return -1;
        }

    case 2:
      switch (XINT (x3, 1))
        {
        case 3:
          if (pnum_clobbers == NULL)
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          operands[1] = x4;
          x5 = XVECEXP (x3, 0, 1);
          operands[2] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern877 (x3, 
E_SImode) != 0
                  || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))
                return -1;
              *pnum_clobbers = 1;
              return 1865; /* probe_stack_range_si */

            case E_DImode:
              if (pattern877 (x3, 
E_DImode) != 0
                  || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))
                return -1;
              *pnum_clobbers = 1;
              return 1866; /* probe_stack_range_di */

            default:
              return -1;
            }

        case 113:
          x5 = XVECEXP (x3, 0, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          switch (GET_CODE (x4))
            {
            case AND:
              switch (pattern625 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10936; /* rao_aandsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10940; /* rao_aanddi */

                default:
                  return -1;
                }

            case IOR:
              switch (pattern625 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10937; /* rao_aorsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10941; /* rao_aordi */

                default:
                  return -1;
                }

            case XOR:
              switch (pattern625 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10938; /* rao_axorsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10942; /* rao_axordi */

                default:
                  return -1;
                }

            case PLUS:
              switch (pattern625 (x3))
                {
                case 0:
                  if (!
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT))
                    return -1;
                  return 10939; /* rao_aaddsi */

                case 1:
                  if (!(
#line 821 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_RAOINT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 10943; /* rao_aadddi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 111:
          if (pnum_clobbers == NULL)
            return -1;
          x5 = XVECEXP (x3, 0, 1);
          operands[2] = x5;
          if (!const_int_operand (operands[2], E_SImode))
            return -1;
          x4 = XVECEXP (x3, 0, 0);
          switch (GET_CODE (x4))
            {
            case PLUS:
              switch (pattern878 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10946; /* atomic_addsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10947; /* atomic_adddi */

                default:
                  return -1;
                }

            case MINUS:
              switch (pattern878 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10950; /* atomic_subsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10951; /* atomic_subdi */

                default:
                  return -1;
                }

            case AND:
              switch (pattern878 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10958; /* atomic_andsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10961; /* atomic_anddi */

                default:
                  return -1;
                }

            case IOR:
              switch (pattern878 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10959; /* atomic_orsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10962; /* atomic_ordi */

                default:
                  return -1;
                }

            case XOR:
              switch (pattern878 (x3))
                {
                case 0:
                  *pnum_clobbers = 1;
                  return 10960; /* atomic_xorsi */

                case 1:
                  if (!
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                    return -1;
                  *pnum_clobbers = 1;
                  return 10963; /* atomic_xordi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_130 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!const_0_to_15_operand (operands[2], E_SImode))
    return -1;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (pattern472 (x2, 
E_V32HFmode, 
E_SImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
        return -1;
      return 9936; /* avx512bw_getmantv32hf_mask */

    case E_V16HFmode:
      if (pattern472 (x2, 
E_V16HFmode, 
E_HImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 9940; /* avx512vl_getmantv16hf_mask */

    case E_V8HFmode:
      if (pattern472 (x2, 
E_V8HFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 9944; /* avx512fp16_getmantv8hf_mask */

    case E_V16SFmode:
      if (pattern472 (x2, 
E_V16SFmode, 
E_HImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9948; /* avx512f_getmantv16sf_mask */

    case E_V8SFmode:
      if (pattern472 (x2, 
E_V8SFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9952; /* avx512vl_getmantv8sf_mask */

    case E_V4SFmode:
      if (pattern472 (x2, 
E_V4SFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9956; /* avx512vl_getmantv4sf_mask */

    case E_V8DFmode:
      if (pattern472 (x2, 
E_V8DFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9960; /* avx512f_getmantv8df_mask */

    case E_V4DFmode:
      if (pattern472 (x2, 
E_V4DFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9964; /* avx512vl_getmantv4df_mask */

    case E_V2DFmode:
      if (pattern472 (x2, 
E_V2DFmode, 
E_QImode) != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9968; /* avx512vl_getmantv2df_mask */

    default:
      return -1;
    }
}

 int
recog_135 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern487 (x2))
    {
    case 0:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10156; /* vpshrdv_v32hi_mask */

    case 1:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10157; /* vpshrdv_v16si_mask */

    case 2:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10158; /* vpshrdv_v8di_mask */

    case 3:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10159; /* vpshrdv_v16hi_mask */

    case 4:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10160; /* vpshrdv_v8si_mask */

    case 5:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10161; /* vpshrdv_v4di_mask */

    case 6:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10162; /* vpshrdv_v8hi_mask */

    case 7:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10163; /* vpshrdv_v4si_mask */

    case 8:
      if (!(
#line 30675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10164; /* vpshrdv_v2di_mask */

    case 9:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10165; /* vpshrdv_v32hi_maskz_1 */

    case 10:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10166; /* vpshrdv_v16si_maskz_1 */

    case 11:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10167; /* vpshrdv_v8di_maskz_1 */

    case 12:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10168; /* vpshrdv_v16hi_maskz_1 */

    case 13:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10169; /* vpshrdv_v8si_maskz_1 */

    case 14:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10170; /* vpshrdv_v4di_maskz_1 */

    case 15:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10171; /* vpshrdv_v8hi_maskz_1 */

    case 16:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10172; /* vpshrdv_v4si_maskz_1 */

    case 17:
      if (!(
#line 30705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10173; /* vpshrdv_v2di_maskz_1 */

    default:
      return -1;
    }
}

 int
recog_141 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern483 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10130; /* vpshld_v32hi_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10132; /* vpshld_v16si_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 10134; /* vpshld_v8di_mask */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10136; /* vpshld_v16hi_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10138; /* vpshld_v8si_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10140; /* vpshld_v4di_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10142; /* vpshld_v8hi_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10144; /* vpshld_v4si_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30649 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 10146; /* vpshld_v2di_mask */

    default:
      return -1;
    }
}

 int
recog_149 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V8BFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_QImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V8BFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V8BFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V8BFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2529; /* avx512vl_blendmv8bf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V8BFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V8BFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2553; /* *avx512vl_storev8bf_mask */
}

 int
recog_150 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V16BFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_HImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V16BFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V16BFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V16BFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2528; /* avx512vl_blendmv16bf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V16BFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V16BFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2552; /* *avx512vl_storev16bf_mask */
}

 int
recog_151 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V32BFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_SImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V32BFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V32BFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V32BFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 2527; /* avx512bw_blendmv32bf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V32BFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V32BFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 324 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
    return -1;
  return 2551; /* *avx512bw_storev32bf_mask */
}

 int
recog_152 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V8HFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_QImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V8HFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V8HFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V8HFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2526; /* avx512fp16_blendmv8hf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V8HFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V8HFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2550; /* *avx512fp16_storev8hf_mask */
}

 int
recog_153 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V16HFmode)
    return -1;
  x3 = XEXP (x2, 2);
  if (!register_operand (x3, E_HImode))
    return -1;
  operands[3] = x3;
  if (register_operand (operands[0], E_V16HFmode))
    {
      x4 = XEXP (x2, 0);
      operands[2] = x4;
      if (nonimmediate_operand (operands[2], E_V16HFmode))
        {
          x5 = XEXP (x2, 1);
          operands[1] = x5;
          if (nonimm_or_0_operand (operands[1], E_V16HFmode)
              && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 2525; /* avx512vl_blendmv16hf */
        }
    }
  operands[2] = x3;
  if (!memory_operand (operands[0], E_V16HFmode))
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_V16HFmode))
    return -1;
  x5 = XEXP (x2, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
    return -1;
  return 2549; /* *avx512vl_storev16hf_mask */
}

 int
recog_154 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16SImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16SImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16SImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16SImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2506; /* avx512f_blendmv16si */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16SImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2530; /* *avx512f_storev16si_mask */

    case E_V8SImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8SImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8SImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8SImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8SImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2507; /* avx512vl_blendmv8si */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2531; /* *avx512vl_storev8si_mask */

    case E_V4SImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4SImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4SImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4SImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4SImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2508; /* avx512vl_blendmv4si */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4SImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2532; /* *avx512vl_storev4si_mask */

    case E_V8DImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8DImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8DImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8DImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8DImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2509; /* avx512f_blendmv8di */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8DImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8DImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2533; /* *avx512f_storev8di_mask */

    case E_V4DImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4DImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4DImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4DImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4DImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2510; /* avx512vl_blendmv4di */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4DImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2534; /* *avx512vl_storev4di_mask */

    case E_V2DImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V2DImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V2DImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V2DImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V2DImode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2511; /* avx512vl_blendmv2di */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2535; /* *avx512vl_storev2di_mask */

    case E_V16SFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16SFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16SFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16SFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16SFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2512; /* avx512f_blendmv16sf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16SFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16SFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2536; /* *avx512f_storev16sf_mask */

    case E_V8SFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8SFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8SFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8SFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8SFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2513; /* avx512vl_blendmv8sf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8SFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8SFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2537; /* *avx512vl_storev8sf_mask */

    case E_V4SFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4SFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4SFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4SFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4SFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2514; /* avx512vl_blendmv4sf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4SFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2538; /* *avx512vl_storev4sf_mask */

    case E_V8DFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8DFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8DFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8DFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8DFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2515; /* avx512f_blendmv8df */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8DFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8DFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2539; /* *avx512f_storev8df_mask */

    case E_V4DFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V4DFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V4DFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V4DFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V4DFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2516; /* avx512vl_blendmv4df */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V4DFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V4DFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2540; /* *avx512vl_storev4df_mask */

    case E_V2DFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V2DFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V2DFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V2DFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V2DFmode)
                  && (
#line 1753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2517; /* avx512vl_blendmv2df */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V2DFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2541; /* *avx512vl_storev2df_mask */

    case E_V64QImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V64QImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_DImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V64QImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V64QImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V64QImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2518; /* avx512bw_blendmv64qi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V64QImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V64QImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2542; /* *avx512bw_storev64qi_mask */

    case E_V16QImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16QImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16QImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16QImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16QImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2519; /* avx512vl_blendmv16qi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16QImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2543; /* *avx512vl_storev16qi_mask */

    case E_V32QImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V32QImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_SImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V32QImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V32QImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V32QImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2520; /* avx512vl_blendmv32qi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V32QImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V32QImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 321 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2544; /* *avx512vl_storev32qi_mask */

    case E_V32HImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V32HImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_SImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V32HImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V32HImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V32HImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2521; /* avx512bw_blendmv32hi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V32HImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V32HImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2545; /* *avx512bw_storev32hi_mask */

    case E_V16HImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V16HImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_HImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V16HImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V16HImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V16HImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2522; /* avx512vl_blendmv16hi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V16HImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V16HImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2546; /* *avx512vl_storev16hi_mask */

    case E_V8HImode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V8HImode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_QImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V8HImode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V8HImode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V8HImode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return 2523; /* avx512vl_blendmv8hi */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V8HImode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 322 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 2547; /* *avx512vl_storev8hi_mask */

    case E_V32HFmode:
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_V32HFmode)
        return -1;
      x3 = XEXP (x2, 2);
      if (!register_operand (x3, E_SImode))
        return -1;
      operands[3] = x3;
      if (register_operand (operands[0], E_V32HFmode))
        {
          x4 = XEXP (x2, 0);
          operands[2] = x4;
          if (nonimmediate_operand (operands[2], E_V32HFmode))
            {
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (nonimm_or_0_operand (operands[1], E_V32HFmode)
                  && (
#line 1784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return 2524; /* avx512bw_blendmv32hf */
            }
        }
      operands[2] = x3;
      if (!memory_operand (operands[0], E_V32HFmode))
        return -1;
      x4 = XEXP (x2, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V32HFmode))
        return -1;
      x5 = XEXP (x2, 1);
      if (!rtx_equal_p (x5, operands[0])
          || !(
#line 1826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 2548; /* *avx512bw_storev32hf_mask */

    case E_V16HFmode:
      return recog_153 (x1, insn, pnum_clobbers);

    case E_V8HFmode:
      return recog_152 (x1, insn, pnum_clobbers);

    case E_V32BFmode:
      return recog_151 (x1, insn, pnum_clobbers);

    case E_V16BFmode:
      return recog_150 (x1, insn, pnum_clobbers);

    case E_V8BFmode:
      return recog_149 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_162 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 2);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  x6 = XVECEXP (x4, 0, 3);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XEXP (x2, 2);
  if (!register_operand (x7, E_QImode))
    return -1;
  x8 = XVECEXP (x4, 0, 0);
  switch (XWINT (x8, 0))
    {
    case 2L:
      x9 = XVECEXP (x4, 0, 1);
      if (XWINT (x9, 0) != 6L
          || XWINT (x5, 0) != 3L
          || XWINT (x6, 0) != 7L)
        return -1;
      x10 = XEXP (x3, 0);
      x11 = XEXP (x10, 1);
      operands[2] = x11;
      x12 = XEXP (x2, 1);
      operands[3] = x12;
      operands[4] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SFmode:
          if (pattern1565 (x2, 
E_V4SFmode, 
E_V8SFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11203 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && TARGET_AVX512VL)))
            return -1;
          return 5155; /* vec_interleave_highv4sf_mask */

        case E_V4SImode:
          if (pattern1565 (x2, 
E_V4SImode, 
E_V8SImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19745 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
            return -1;
          return 8299; /* vec_interleave_highv4si_mask */

        default:
          return -1;
        }

    case 0L:
      x9 = XVECEXP (x4, 0, 1);
      switch (XWINT (x9, 0))
        {
        case 4L:
          switch (XWINT (x5, 0))
            {
            case 1L:
              if (XWINT (x6, 0) != 5L)
                return -1;
              x10 = XEXP (x3, 0);
              x11 = XEXP (x10, 1);
              operands[2] = x11;
              x12 = XEXP (x2, 1);
              operands[3] = x12;
              operands[4] = x7;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1564 (x2, 
E_V4SFmode, 
E_V8SFmode) != 0
                      || !
#line 11260 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
                    return -1;
                  return 5160; /* unpcklps128_mask */

                case E_V4SImode:
                  if (pattern1565 (x2, 
E_V4SImode, 
E_V8SImode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19799 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
                    return -1;
                  return 8305; /* vec_interleave_lowv4si_mask */

                default:
                  return -1;
                }

            case 2L:
              if (XWINT (x6, 0) != 6L)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4DFmode:
                  if (pattern1621 (x2, 
E_V4DFmode, 
E_V8DFmode) != 0)
                    return -1;
                  x12 = XEXP (x2, 1);
                  operands[2] = x12;
                  if (nonimmediate_operand (operands[1], E_V4DFmode))
                    {
                      operands[3] = x7;
                      x10 = XEXP (x3, 0);
                      x11 = XEXP (x10, 1);
                      if (rtx_equal_p (x11, operands[1])
                          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13455 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
                        return 5315; /* avx_movddup256_mask */
                    }
                  operands[3] = x12;
                  if (!register_operand (operands[1], E_V4DFmode))
                    return -1;
                  x10 = XEXP (x3, 0);
                  x11 = XEXP (x10, 1);
                  operands[2] = x11;
                  if (!nonimmediate_operand (operands[2], E_V4DFmode))
                    return -1;
                  operands[4] = x7;
                  if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13469 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
                    return -1;
                  return 5317; /* avx_unpcklpd256_mask */

                case E_V4DImode:
                  if (pattern1622 (x2, 
E_V4DImode, 
E_V8DImode) != 0
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 14501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
                    return -1;
                  return 7130; /* avx2_interleave_lowv4di_mask */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 0L:
          if (XWINT (x5, 0) != 6L
              || XWINT (x6, 0) != 6L
              || pattern1563 (x2) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11398 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_AVX512VL)))
            return -1;
          return 5171; /* sse3_movsldup_mask */

        default:
          return -1;
        }

    case 1L:
      if (XWINT (x6, 0) != 7L)
        return -1;
      x9 = XVECEXP (x4, 0, 1);
      switch (XWINT (x9, 0))
        {
        case 1L:
          if (XWINT (x5, 0) != 7L
              || pattern1563 (x2) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 11345 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_AVX512VL)))
            return -1;
          return 5165; /* sse3_movshdup_mask */

        case 5L:
          if (XWINT (x5, 0) != 3L)
            return -1;
          x10 = XEXP (x3, 0);
          x11 = XEXP (x10, 1);
          operands[2] = x11;
          x12 = XEXP (x2, 1);
          operands[3] = x12;
          operands[4] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DFmode:
              if (pattern1564 (x2, 
E_V4DFmode, 
E_V8DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 13325 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512VL)))
                return -1;
              return 5307; /* avx_unpckhpd256_mask */

            case E_V4DImode:
              if (pattern1564 (x2, 
E_V4DImode, 
E_V8DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 14451 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
                return -1;
              return 7124; /* avx2_interleave_highv4di_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_170 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x4, 0, 2);
  operands[4] = x6;
  x7 = XVECEXP (x4, 0, 3);
  operands[5] = x7;
  x8 = XVECEXP (x4, 0, 5);
  operands[7] = x8;
  x9 = XVECEXP (x4, 0, 6);
  operands[8] = x9;
  x10 = XVECEXP (x4, 0, 7);
  operands[9] = x10;
  x11 = XEXP (x2, 1);
  operands[10] = x11;
  x12 = XEXP (x2, 2);
  operands[11] = x12;
  if (!register_operand (operands[11], E_QImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x2) != E_V8DFmode
          || GET_MODE (x3) != E_V8DFmode
          || !register_operand (operands[1], E_V8DFmode)
          || pattern1792 () != 0
          || !nonimm_or_0_operand (operands[10], E_V8DFmode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20259 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 1) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (INTVAL (operands[4]) & 1) == 0
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1
   && (INTVAL (operands[6]) & 1) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && (INTVAL (operands[8]) & 1) == 0
   && INTVAL (operands[8]) == INTVAL (operands[9]) - 1) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 8349; /* *avx512f_shuf_f64x2_1_mask_1 */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x2) != E_V8DImode
          || GET_MODE (x3) != E_V8DImode
          || !nonimm_or_0_operand (operands[10], E_V8DImode))
        return -1;
      if (register_operand (operands[1], E_V8DImode)
          && pattern1792 () == 0
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20259 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 1) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (INTVAL (operands[4]) & 1) == 0
   && INTVAL (operands[4]) == INTVAL (operands[5]) - 1
   && (INTVAL (operands[6]) & 1) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && (INTVAL (operands[8]) & 1) == 0
   && INTVAL (operands[8]) == INTVAL (operands[9]) - 1) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 8351; /* *avx512f_shuf_i64x2_1_mask_1 */
      if (!nonimmediate_operand (operands[1], E_V8DImode)
          || pattern1793 () != 0
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 27864 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL)
   && (INTVAL (operands[2]) == (INTVAL (operands[6]) - 4)
       && INTVAL (operands[3]) == (INTVAL (operands[7]) - 4)
       && INTVAL (operands[4]) == (INTVAL (operands[8]) - 4)
       && INTVAL (operands[5]) == (INTVAL (operands[9]) - 4))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9105; /* avx512f_permv8di_1_mask */

    case E_V8SImode:
      if (pattern755 (x2, 
E_V8SImode) != 0
          || pattern1793 () != 0
          || !nonimm_or_0_operand (operands[10], E_V8SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 20616 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   && TARGET_AVX512VL
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9]))))
        return -1;
      return 8367; /* avx2_pshufd_1_mask */

    default:
      return -1;
    }
}

 int
recog_182 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case SS_TRUNCATE:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != SS_TRUNCATE)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x7 = XEXP (x5, 0);
      operands[2] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_V16QImode:
          if (pattern1112 (x2, 
E_HImode, 
E_V16QImode, 
E_V8HImode, 
E_V8QImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19198 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8229; /* sse2_packsswb_mask */

        case E_V8HImode:
          if (pattern1112 (x2, 
E_QImode, 
E_V8HImode, 
E_V4SImode, 
E_V4HImode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 19292 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL && TARGET_AVX512BW)))
            return -1;
          return 8235; /* sse2_packssdw_mask */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x4;
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != VEC_SELECT)
        return -1;
      x10 = XEXP (x5, 1);
      if (GET_CODE (x10) != PARALLEL)
        return -1;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (XVECLEN (x10, 0))
        {
        case 8:
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x12 = XVECEXP (x10, 0, 1);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
            return -1;
          x13 = XVECEXP (x10, 0, 2);
          if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 10]
              || pattern1401 (x10, 
15, 
14, 
13, 
12, 
11) != 0
              || !register_operand (operands[4], E_HImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SFmode:
              if (pattern1501 (x2, 
E_V16SFmode, 
E_V8SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20081 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8325; /* vec_set_lo_v16sf_mask */

            case E_V16SImode:
              if (pattern1501 (x2, 
E_V16SImode, 
E_V8SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20081 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8327; /* vec_set_lo_v16si_mask */

            default:
              return -1;
            }

        case 4:
          if (pattern1204 (x10, 
7, 
6, 
5, 
4) != 0
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1501 (x2, 
E_V8DFmode, 
E_V4DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8333; /* vec_set_lo_v8df_mask */

            case E_V8DImode:
              if (pattern1501 (x2, 
E_V8DImode, 
E_V4DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20113 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8335; /* vec_set_lo_v8di_mask */

            case E_V8SImode:
              if (pattern1501 (x2, 
E_V8SImode, 
E_V4SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28724 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9399; /* vec_set_lo_v8si_mask */

            case E_V8SFmode:
              if (pattern1501 (x2, 
E_V8SFmode, 
E_V4SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28724 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9401; /* vec_set_lo_v8sf_mask */

            default:
              return -1;
            }

        case 2:
          x11 = XVECEXP (x10, 0, 0);
          if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
            return -1;
          x12 = XVECEXP (x10, 0, 1);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DImode:
              if (pattern1501 (x2, 
E_V4DImode, 
E_V2DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9391; /* vec_set_lo_v4di_mask */

            case E_V4DFmode:
              if (pattern1501 (x2, 
E_V4DFmode, 
E_V2DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28675 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9393; /* vec_set_lo_v4df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x14 = XEXP (x4, 1);
      if (GET_CODE (x14) != PARALLEL)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (XVECLEN (x14, 0))
        {
        case 8:
          if (pattern639 (x14) != 0)
            return -1;
          x15 = XVECEXP (x14, 0, 4);
          if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
            return -1;
          x16 = XVECEXP (x14, 0, 5);
          if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
            return -1;
          x17 = XVECEXP (x14, 0, 6);
          if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
            return -1;
          x18 = XVECEXP (x14, 0, 7);
          if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
              || !register_operand (operands[4], E_HImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SFmode:
              if (pattern1459 (x2, 
E_V16SFmode, 
E_V8SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20098 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8329; /* vec_set_hi_v16sf_mask */

            case E_V16SImode:
              if (pattern1459 (x2, 
E_V16SImode, 
E_V8SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20098 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8331; /* vec_set_hi_v16si_mask */

            default:
              return -1;
            }

        case 4:
          if (pattern639 (x14) != 0
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8DFmode:
              if (pattern1459 (x2, 
E_V8DFmode, 
E_V4DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20128 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8337; /* vec_set_hi_v8df_mask */

            case E_V8DImode:
              if (pattern1459 (x2, 
E_V8DImode, 
E_V4DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20128 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 8339; /* vec_set_hi_v8di_mask */

            case E_V8SImode:
              if (pattern1459 (x2, 
E_V8SImode, 
E_V4SImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28747 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9403; /* vec_set_hi_v8si_mask */

            case E_V8SFmode:
              if (pattern1459 (x2, 
E_V8SFmode, 
E_V4SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28747 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 9405; /* vec_set_hi_v8sf_mask */

            default:
              return -1;
            }

        case 2:
          x19 = XVECEXP (x14, 0, 0);
          if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x20 = XVECEXP (x14, 0, 1);
          if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || !register_operand (operands[4], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DImode:
              if (pattern1459 (x2, 
E_V4DImode, 
E_V2DImode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28699 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9395; /* vec_set_hi_v4di_mask */

            case E_V4DFmode:
              if (pattern1459 (x2, 
E_V4DFmode, 
E_V2DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 28699 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && TARGET_AVX512DQ)))
                return -1;
              return 9397; /* vec_set_hi_v4df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      if (XVECLEN (x4, 0) != 2
          || XINT (x4, 1) != 150
          || GET_MODE (x4) != E_V4HImode
          || !register_operand (operands[0], E_V8HImode)
          || GET_MODE (x2) != E_V8HImode
          || GET_MODE (x3) != E_V8HImode)
        return -1;
      x21 = XVECEXP (x4, 0, 0);
      operands[1] = x21;
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      x22 = XVECEXP (x4, 0, 1);
      operands[2] = x22;
      if (!const_0_to_255_operand (operands[2], E_SImode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[3] = x5;
      if (!const0_operand (operands[3], E_V4HImode))
        return -1;
      x8 = XEXP (x2, 1);
      operands[4] = x8;
      if (!nonimm_or_0_operand (operands[4], E_V8HImode))
        return -1;
      x9 = XEXP (x2, 2);
      operands[5] = x9;
      if (!register_operand (operands[5], E_QImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_F16C || TARGET_AVX512VL) && TARGET_AVX512VL)))
        return -1;
      return 9586; /* *vcvtps2ph_mask */

    case FLOAT_TRUNCATE:
      x5 = XEXP (x3, 1);
      if (GET_CODE (x5) != FLOAT_TRUNCATE)
        return -1;
      x6 = XEXP (x4, 0);
      operands[2] = x6;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      x8 = XEXP (x2, 1);
      operands[3] = x8;
      x9 = XEXP (x2, 2);
      operands[4] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_V32BFmode:
          if (pattern1114 (x2, 
E_SImode, 
E_V32BFmode, 
E_V16SFmode, 
E_V16BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31267 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 31233 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 10267; /* avx512f_cvtne2ps2bf16_v32bf_mask */

        case E_V16BFmode:
          if (pattern1114 (x2, 
E_HImode, 
E_V16BFmode, 
E_V8SFmode, 
E_V8BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31267 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 31233 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10269; /* avx512f_cvtne2ps2bf16_v16bf_mask */

        case E_V8BFmode:
          if (pattern1114 (x2, 
E_QImode, 
E_V8BFmode, 
E_V4SFmode, 
E_V4BFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31267 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 31233 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 10271; /* avx512f_cvtne2ps2bf16_v8bf_mask */

        case E_V32HFmode:
          if (pattern1115 (x2, 
E_SImode, 
E_V32HFmode, 
E_V16SFmode, 
E_V16HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 31966 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1) && 
#line 561 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
            return -1;
          return 10367; /* avx10_2_cvt2ps2phx_v32hf_mask */

        case E_V16HFmode:
          if (pattern1115 (x2, 
E_HImode, 
E_V16HFmode, 
E_V8SFmode, 
E_V8HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31966 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10370; /* avx10_2_cvt2ps2phx_v16hf_mask */

        case E_V8HFmode:
          if (pattern1115 (x2, 
E_QImode, 
E_V8HFmode, 
E_V4SFmode, 
E_V4HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 31966 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2 && 1)))
            return -1;
          return 10372; /* avx10_2_cvt2ps2phx_v8hf_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_188 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      x5 = XEXP (x2, 1);
      operands[2] = x5;
      x6 = XEXP (x2, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DFmode:
          if (pattern136 (x2, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!vector_operand (operands[1], E_V8HFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4648; /* avx512fp16_float_extend_phv8df2_mask */

            case E_V8SFmode:
              if (!vector_operand (operands[1], E_V8SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 10207 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
                return -1;
              return 5093; /* avx512f_cvtps2pd512_mask */

            default:
              return -1;
            }

        case E_V16SFmode:
          if (pattern135 (x2, 
E_V16SFmode, 
E_HImode, 
E_V16HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
            return -1;
          return 4652; /* avx512fp16_float_extend_phv16sf2_mask */

        case E_V8SFmode:
          if (pattern135 (x2, 
E_V8SFmode, 
E_QImode, 
E_V8HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4656; /* avx512fp16_float_extend_phv8sf2_mask */

        case E_V4DFmode:
          if (pattern136 (x2, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4HFmode:
              if (!memory_operand (operands[1], E_V4HFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4663; /* *avx512fp16_float_extend_phv4df2_load_mask */

            case E_V4SFmode:
              if (!vector_operand (operands[1], E_V4SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10207 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && (32 == 64 || TARGET_AVX512VL) && 1)))
                return -1;
              return 5096; /* avx_cvtps2pd256_mask */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (pattern150 (x2, 
E_V4SFmode, 
E_V4HFmode) != 0
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4665; /* *avx512fp16_float_extend_phv4sf2_load_mask */

        case E_V2DFmode:
          if (pattern136 (x2, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V2HFmode:
              if (!memory_operand (operands[1], E_V2HFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4669; /* *avx512fp16_float_extend_phv2df2_load_mask */

            case E_V2SFmode:
              if (!memory_operand (operands[1], E_V2SFmode)
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
                return -1;
              return 5144; /* sse2_cvtps2pd_mask_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x7 = XEXP (x4, 1);
      if (GET_CODE (x7) != PARALLEL)
        return -1;
      switch (XVECLEN (x7, 0))
        {
        case 4:
          if (pattern639 (x7) != 0
              || GET_MODE (x4) != E_V4HFmode)
            return -1;
          x8 = XEXP (x4, 0);
          operands[1] = x8;
          if (!register_operand (operands[1], E_V8HFmode))
            return -1;
          x5 = XEXP (x2, 1);
          operands[2] = x5;
          x6 = XEXP (x2, 2);
          operands[3] = x6;
          if (!register_operand (operands[3], E_QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4DFmode:
              if (pattern137 (x2, 
E_V4DFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4659; /* avx512fp16_float_extend_phv4df2_mask */

            case E_V4SFmode:
              if (pattern137 (x2, 
E_V4SFmode) != 0
                  || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 4661; /* avx512fp16_float_extend_phv4sf2_mask */

            default:
              return -1;
            }

        case 2:
          x9 = XVECEXP (x7, 0, 0);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x10 = XVECEXP (x7, 0, 1);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || !register_operand (operands[0], E_V2DFmode)
              || GET_MODE (x2) != E_V2DFmode
              || GET_MODE (x3) != E_V2DFmode)
            return -1;
          x6 = XEXP (x2, 2);
          switch (GET_CODE (x6))
            {
            case REG:
            case SUBREG:
              operands[3] = x6;
              if (!register_operand (operands[3], E_QImode))
                return -1;
              x8 = XEXP (x4, 0);
              operands[1] = x8;
              x5 = XEXP (x2, 1);
              operands[2] = x5;
              if (!nonimm_or_0_operand (operands[2], E_V2DFmode))
                return -1;
              switch (GET_MODE (x4))
                {
                case E_V2HFmode:
                  if (!register_operand (operands[1], E_V8HFmode)
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8090 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 4667; /* avx512fp16_float_extend_phv2df2_mask */

                case E_V2SFmode:
                  if (!register_operand (operands[1], E_V4SFmode)
                      || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_AVX512VL)))
                    return -1;
                  return 5142; /* sse2_cvtps2pd_mask */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x6, 0) != 1L
                  || GET_MODE (x4) != E_V2SFmode)
                return -1;
              x8 = XEXP (x4, 0);
              operands[2] = x8;
              if (!nonimmediate_operand (operands[2], E_V4SFmode))
                return -1;
              x5 = XEXP (x2, 1);
              operands[1] = x5;
              if (!register_operand (operands[1], E_V2DFmode)
                  || !
#line 10034 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return -1;
              return 5076; /* sse2_cvtss2sd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_196 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern133 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512))))
        return -1;
      return 2988; /* *sminv32hf3_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2993; /* *sminv16hf3_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))))
        return -1;
      return 2997; /* *sminv8hf3_mask */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 3004; /* *sminv16sf3_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3009; /* *sminv8sf3_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1)))
        return -1;
      return 3013; /* *sminv4sf3_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (64 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 3020; /* *sminv8df3_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (32 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
        return -1;
      return 3025; /* *sminv4df3_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE
   && !(MEM_P (operands[1]) && MEM_P (operands[2]))
   && (16 == 64 || TARGET_AVX512VL)
   && 1) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
        return -1;
      return 3029; /* *sminv2df3_mask */

    case 9:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7700; /* *avx512f_sminv16si3_mask */

    case 10:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7708; /* *avx512f_sminv8si3_mask */

    case 11:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonimmediate_operand (operands[2], E_V4SImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7716; /* *avx512f_sminv4si3_mask */
      if (!vector_operand (operands[1], E_V4SImode)
          || !vector_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
        return -1;
      return 7800; /* *sse4_1_sminv4si3_mask */

    case 12:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7724; /* *avx512f_sminv8di3_mask */

    case 13:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7732; /* *avx512f_sminv4di3_mask */

    case 14:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7740; /* *avx512f_sminv2di3_mask */

    case 15:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7748; /* *avx512bw_sminv64qi3_mask */

    case 16:
      if (nonimmediate_operand (operands[1], E_V16QImode)
          && nonimmediate_operand (operands[2], E_V16QImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7756; /* *avx512bw_sminv16qi3_mask */
      if (!vector_operand (operands[1], E_V16QImode)
          || !vector_operand (operands[2], E_V16QImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17797 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1
   && (16 == 64 || TARGET_AVX512VL)
   && !(MEM_P (operands[1]) && MEM_P (operands[2])))))
        return -1;
      return 7796; /* *sse4_1_sminv16qi3_mask */

    case 17:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7764; /* *avx512bw_sminv32qi3_mask */

    case 18:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 7772; /* *avx512bw_sminv32hi3_mask */

    case 19:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7780; /* *avx512bw_sminv16hi3_mask */

    case 20:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 7788; /* *avx512bw_sminv8hi3_mask */

    case 21:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32360 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10523; /* avx10_2_sminbf16_v32bf_mask */

    case 22:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32360 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10527; /* avx10_2_sminbf16_v16bf_mask */

    case 23:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32360 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
        return -1;
      return 10531; /* avx10_2_sminbf16_v8bf_mask */

    case 24:
      if (!(
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
        return -1;
      return 3101; /* *avx512fp16_vmsminv8hf3 */

    case 25:
      if (!
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 3109; /* *sse_vmsminv4sf3 */

    case 26:
      if (!(
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 3117; /* *sse2_vmsminv2df3 */

    default:
      return -1;
    }
}

 int
recog_209 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern323 (x2))
    {
    case 0:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x2) != E_V32HImode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4336; /* avx512fp16_vcvtph2uw_v32hi */

    case 1:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16HFmode:
          if (!vector_operand (operands[1], E_V16HFmode)
              || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4344; /* avx512fp16_vcvtph2udq_v16si */

        case E_V16SFmode:
          if (!nonimmediate_operand (operands[1], E_V16SFmode)
              || !(
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4772; /* *avx512f_fixuns_notruncv16sfv16si */

        default:
          return -1;
        }

    case 2:
      switch (pattern773 (x2, 
E_V8DImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4352; /* avx512fp16_vcvtph2uqq_v8di */

        case 1:
          if (!(
#line 8730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4792; /* *avx512dq_cvtps2uqqv8di */

        case 2:
          if (!(
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5018; /* fixuns_notruncv8dfv8di2 */

        default:
          return -1;
        }

    case 3:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x2) != E_V16HImode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4360; /* avx512fp16_vcvtph2uw_v16hi */

    case 4:
      switch (pattern773 (x2, 
E_V8SImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4368; /* avx512fp16_vcvtph2udq_v8si */

        case 1:
          if (!(
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4776; /* *avx512vl_fixuns_notruncv8sfv8si */

        case 2:
          if (!(
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4938; /* fixuns_notruncv8dfv8si2 */

        default:
          return -1;
        }

    case 5:
      switch (pattern774 (x2, 
E_V4DImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4376; /* avx512fp16_vcvtph2uqq_v4di */

        case 1:
          if (!(
#line 8730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4796; /* *avx512dq_cvtps2uqqv4di */

        case 2:
          if (!(
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5022; /* fixuns_notruncv4dfv4di2 */

        default:
          return -1;
        }

    case 6:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x2) != E_V8HImode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4384; /* avx512fp16_vcvtph2uw_v8hi */

    case 7:
      switch (pattern774 (x2, 
E_V4SImode))
        {
        case 0:
          if (!(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4392; /* avx512fp16_vcvtph2udq_v4si */

        case 1:
          if (!(
#line 8697 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4780; /* *avx512vl_fixuns_notruncv4sfv4si */

        case 2:
          if (!(
#line 9489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4942; /* fixuns_notruncv4dfv4si2 */

        default:
          return -1;
        }

    case 8:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x2) != E_V2DImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 7634 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4400; /* avx512fp16_vcvtph2uqq_v2di */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[1], E_V2DFmode)
              || !(
#line 9708 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5024; /* fixuns_notruncv2dfv2di2 */

        default:
          return -1;
        }

    case 9:
      if (!
#line 8743 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
        return -1;
      return 4798; /* *avx512dq_cvtps2uqqv2di */

    default:
      return -1;
    }
}

 int
recog_223 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 0);
  switch (XVECLEN (x4, 0))
    {
    case 2:
      return recog_218 (x1, insn, pnum_clobbers);

    case 3:
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      switch (XINT (x4, 1))
        {
        case 192:
          x7 = XEXP (x3, 2);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          switch (pattern1395 (x2))
            {
            case 0:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3197; /* reducesv8hf_round */

            case 1:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode)))))
                return -1;
              return 3201; /* reducesv4sf_round */

            case 2:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3205; /* reducesv2df_round */

            default:
              return -1;
            }

        case 133:
          return recog_217 (x1, insn, pnum_clobbers);

        case 217:
          switch (pattern1119 (x2))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4255; /* fma_fmaddc_v32hf_maskz_1_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4293; /* avx512bw_fmaddc_v32hf_mask_round */

            case 2:
              if (!(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4318; /* avx512fp16_fma_fmaddcsh_v8hf_round */

            default:
              return -1;
            }

        case 219:
          switch (pattern1119 (x2))
            {
            case 0:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (64 == 64 || TARGET_AVX512VL) && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4259; /* fma_fcmaddc_v32hf_maskz_1_round */

            case 1:
              if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7302 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && (V32HFmode == V16SFmode
							      || V32HFmode == V8DFmode
							      || V32HFmode == V8DImode
							      || V32HFmode == V16SImode
							      || V32HFmode == V32HFmode)) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 4295; /* avx512bw_fcmaddc_v32hf_mask_round */

            case 2:
              if (!(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4322; /* avx512fp16_fma_fcmaddcsh_v8hf_round */

            default:
              return -1;
            }

        case 194:
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          x9 = XVECEXP (x2, 0, 1);
          if (!const48_operand (x9, E_SImode))
            return -1;
          x7 = XEXP (x3, 2);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[5] = x7;
              x10 = XEXP (x3, 1);
              operands[4] = x10;
              operands[6] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SFmode:
                  if (pattern1630 (x2, 
E_V16SFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V16SFmode == V16SFmode
									      || V16SFmode == V8DFmode
									      || V16SFmode == V8DImode
									      || V16SFmode == V16SImode
									      || V16SFmode == V32HFmode)) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                    return -1;
                  return 9889; /* avx512dq_rangepv16sf_mask_round */

                case E_V8DFmode:
                  if (pattern1630 (x2, 
E_V8DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && (V8DFmode == V16SFmode
									      || V8DFmode == V8DFmode
									      || V8DFmode == V8DImode
									      || V8DFmode == V16SImode
									      || V8DFmode == V32HFmode)) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))))
                    return -1;
                  return 9897; /* avx512dq_rangepv8df_mask_round */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x7, 0) != 1L)
                return -1;
              operands[4] = x9;
              x10 = XEXP (x3, 1);
              if (!rtx_equal_p (x10, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1393 (x2, 
E_V4SFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 30077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                    return -1;
                  return 9904; /* avx512dq_rangesv4sf_round */

                case E_V2DFmode:
                  if (pattern1393 (x2, 
E_V2DFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return -1;
                  return 9908; /* avx512dq_rangesv2df_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 166:
          x7 = XEXP (x3, 2);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          switch (pattern1395 (x2))
            {
            case 0:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30145 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 9972; /* avx512f_vgetmantv8hf_round */

            case 1:
              if (!
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 9976; /* avx512f_vgetmantv4sf_round */

            case 2:
              if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30145 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9980; /* avx512f_vgetmantv2df_round */

            default:
              return -1;
            }

        case 278:
          x8 = XVECEXP (x4, 0, 2);
          operands[3] = x8;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          x9 = XVECEXP (x2, 0, 1);
          if (!const48_operand (x9, E_SImode))
            return -1;
          x7 = XEXP (x3, 2);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[5] = x7;
              x10 = XEXP (x3, 1);
              operands[4] = x10;
              operands[6] = x9;
              switch (GET_MODE (operands[0]))
                {
                case E_V32HFmode:
                  if (pattern1630 (x2, 
E_V32HFmode, 
E_SImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10835; /* avx10_2_minmaxpv32hf_mask_round */

                case E_V16HFmode:
                  if (pattern1630 (x2, 
E_V16HFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10839; /* avx10_2_minmaxpv16hf_mask_round */

                case E_V8HFmode:
                  if (pattern1630 (x2, 
E_V8HFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10843; /* avx10_2_minmaxpv8hf_mask_round */

                case E_V16SFmode:
                  if (pattern1630 (x2, 
E_V16SFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10847; /* avx10_2_minmaxpv16sf_mask_round */

                case E_V8SFmode:
                  if (pattern1630 (x2, 
E_V8SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10851; /* avx10_2_minmaxpv8sf_mask_round */

                case E_V4SFmode:
                  if (pattern1630 (x2, 
E_V4SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10855; /* avx10_2_minmaxpv4sf_mask_round */

                case E_V8DFmode:
                  if (pattern1630 (x2, 
E_V8DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10859; /* avx10_2_minmaxpv8df_mask_round */

                case E_V4DFmode:
                  if (pattern1630 (x2, 
E_V4DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10863; /* avx10_2_minmaxpv4df_mask_round */

                case E_V2DFmode:
                  if (pattern1630 (x2, 
E_V2DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10867; /* avx10_2_minmaxpv2df_mask_round */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x7, 0) != 1L)
                return -1;
              operands[4] = x9;
              switch (pattern1394 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                    return -1;
                  return 10870; /* avx10_2_minmaxsv8hf_round */

                case 1:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                    return -1;
                  return 10874; /* avx10_2_minmaxsv4sf_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return -1;
                  return 10878; /* avx10_2_minmaxsv2df_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 1:
      return recog_219 (x1, insn, pnum_clobbers);

    case 4:
      if (XINT (x4, 1) != 163)
        return -1;
      x5 = XVECEXP (x4, 0, 0);
      operands[1] = x5;
      x6 = XVECEXP (x4, 0, 1);
      operands[2] = x6;
      x8 = XVECEXP (x4, 0, 2);
      operands[3] = x8;
      x11 = XVECEXP (x4, 0, 3);
      operands[4] = x11;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x9 = XVECEXP (x2, 0, 1);
      if (!const48_operand (x9, E_SImode))
        return -1;
      x10 = XEXP (x3, 1);
      switch (GET_CODE (x10))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[5] = x10;
          x7 = XEXP (x3, 2);
          operands[6] = x7;
          operands[7] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SFmode:
              if (pattern1655 (x2, 
E_V16SFmode, 
E_V16SImode, 
E_HImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 7017; /* avx512f_fixupimmv16sf_maskz_1_round */

            case E_V8SFmode:
              if (pattern1655 (x2, 
E_V8SFmode, 
E_V8SImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7021; /* avx512vl_fixupimmv8sf_maskz_1_round */

            case E_V4SFmode:
              if (pattern1655 (x2, 
E_V4SFmode, 
E_V4SImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7025; /* avx512vl_fixupimmv4sf_maskz_1_round */

            case E_V8DFmode:
              if (pattern1655 (x2, 
E_V8DFmode, 
E_V8DImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                return -1;
              return 7029; /* avx512f_fixupimmv8df_maskz_1_round */

            case E_V4DFmode:
              if (pattern1655 (x2, 
E_V4DFmode, 
E_V4DImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7033; /* avx512vl_fixupimmv4df_maskz_1_round */

            case E_V2DFmode:
              if (pattern1655 (x2, 
E_V2DFmode, 
E_V2DImode, 
E_QImode) != 0
                  || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14132 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                return -1;
              return 7037; /* avx512vl_fixupimmv2df_maskz_1_round */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          x7 = XEXP (x3, 2);
          switch (GET_CODE (x7))
            {
            case REG:
            case SUBREG:
              operands[5] = x7;
              operands[6] = x9;
              if (!rtx_equal_p (x10, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V16SFmode:
                  if (pattern1682 (x2, 
E_V16SImode, 
E_V16SFmode, 
E_HImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 7039; /* avx512f_fixupimmv16sf_mask_round */

                case E_V8SFmode:
                  if (pattern1682 (x2, 
E_V8SImode, 
E_V8SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7041; /* avx512vl_fixupimmv8sf_mask_round */

                case E_V4SFmode:
                  if (pattern1682 (x2, 
E_V4SImode, 
E_V4SFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7043; /* avx512vl_fixupimmv4sf_mask_round */

                case E_V8DFmode:
                  if (pattern1682 (x2, 
E_V8DImode, 
E_V8DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
                    return -1;
                  return 7045; /* avx512f_fixupimmv8df_mask_round */

                case E_V4DFmode:
                  if (pattern1682 (x2, 
E_V4DImode, 
E_V4DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7047; /* avx512vl_fixupimmv4df_mask_round */

                case E_V2DFmode:
                  if (pattern1682 (x2, 
E_V2DImode, 
E_V2DFmode, 
E_QImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14148 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
                    return -1;
                  return 7049; /* avx512vl_fixupimmv2df_mask_round */

                default:
                  return -1;
                }

            case CONST_INT:
              if (XWINT (x7, 0) != 1L)
                return -1;
              operands[5] = x9;
              if (!rtx_equal_p (x10, operands[2]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1683 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
                      || !
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 7051; /* avx512f_sfixupimmv4sf_round */

                case E_V2DFmode:
                  if (pattern1683 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14180 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return -1;
                  return 7055; /* avx512f_sfixupimmv2df_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_231 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return -1;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[0] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[1] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || !vector_operand (operands[1], E_V16QImode)
          || !
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8867; /* *sse4_1_ptestv16qi */

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || !vector_operand (operands[1], E_V8HImode)
          || !
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8868; /* *sse4_1_ptestv8hi */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || !vector_operand (operands[1], E_V4SImode)
          || !
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8869; /* *sse4_1_ptestv4si */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || !vector_operand (operands[1], E_V2DImode)
          || !
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8870; /* *sse4_1_ptestv2di */

    case E_V1TImode:
      if (!register_operand (operands[0], E_V1TImode)
          || !vector_operand (operands[1], E_V1TImode)
          || !
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8871; /* *sse4_1_ptestv1ti */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || !vector_operand (operands[1], E_V4SFmode)
          || !
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8872; /* *sse4_1_ptestv4sf */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)))
        return -1;
      return 8873; /* *sse4_1_ptestv2df */

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || !vector_operand (operands[1], E_V32QImode)
          || !(
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8874; /* *avx_ptestv32qi */

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || !vector_operand (operands[1], E_V16HImode)
          || !(
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8875; /* *avx_ptestv16hi */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || !vector_operand (operands[1], E_V8SImode)
          || !(
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8876; /* *avx_ptestv8si */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || !vector_operand (operands[1], E_V4DImode)
          || !(
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8877; /* *avx_ptestv4di */

    case E_V2TImode:
      if (!register_operand (operands[0], E_V2TImode)
          || !vector_operand (operands[1], E_V2TImode)
          || !(
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 606 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8878; /* *avx_ptestv2ti */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !vector_operand (operands[1], E_V8SFmode)
          || !(
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 607 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8879; /* *avx_ptestv8sf */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !vector_operand (operands[1], E_V4DFmode)
          || !(
#line 25557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && ix86_match_ptest_ccmode (insn)) && 
#line 607 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8880; /* *avx_ptestv4df */

    default:
      return -1;
    }
}

 int
recog_232 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (pattern779 (x3, 
E_V32HFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 7062; /* avx512bw_rndscalev32hf */

    case E_V16HFmode:
      if (pattern779 (x3, 
E_V16HFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 7066; /* avx512vl_rndscalev16hf */

    case E_V8HFmode:
      if (pattern779 (x3, 
E_V8HFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 7070; /* avx512fp16_rndscalev8hf */

    case E_V16SFmode:
      if (pattern779 (x3, 
E_V16SFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7074; /* avx512f_rndscalev16sf */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8SFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7078; /* avx512vl_rndscalev8sf */
      if (!vector_operand (operands[1], E_V8SFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !(
#line 25718 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8896; /* avx_roundps256 */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7082; /* avx512vl_rndscalev4sf */
      if (!vector_operand (operands[1], E_V4SFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !
#line 25718 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
        return -1;
      return 8897; /* sse4_1_roundps */

    case E_V8DFmode:
      if (pattern779 (x3, 
E_V8DFmode) != 0
          || !(
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7086; /* avx512f_rndscalev8df */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x3) != E_V4DFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4DFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7090; /* avx512vl_rndscalev4df */
      if (!vector_operand (operands[1], E_V4DFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !(
#line 25718 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 8898; /* avx_roundpd256 */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DFmode)
          && const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 14210 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7094; /* avx512vl_rndscalev2df */
      if (!vector_operand (operands[1], E_V2DFmode)
          || !const_0_to_15_operand (operands[2], E_SImode)
          || !(
#line 25718 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 8899; /* sse4_1_roundpd */

    default:
      return -1;
    }
}

 int
recog_235 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || GET_MODE (x3) != E_V32HFmode
          || !vector_operand (operands[1], E_V32HFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V32HFmode))) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
        return -1;
      return 3159; /* *reducepv32hf */

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || GET_MODE (x3) != E_V16HFmode
          || !vector_operand (operands[1], E_V16HFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16HFmode))) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3163; /* *reducepv16hf */

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x3) != E_V8HFmode
          || !vector_operand (operands[1], E_V8HFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 3167; /* *reducepv8hf */

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x3) != E_V16SFmode
          || !vector_operand (operands[1], E_V16SFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V16SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3171; /* *reducepv16sf */

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || GET_MODE (x3) != E_V8SFmode
          || !vector_operand (operands[1], E_V8SFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3175; /* *reducepv8sf */

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode)
          || GET_MODE (x3) != E_V4SFmode
          || !vector_operand (operands[1], E_V4SFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode))) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3179; /* *reducepv4sf */

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || GET_MODE (x3) != E_V8DFmode
          || !vector_operand (operands[1], E_V8DFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 3183; /* *reducepv8df */

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || GET_MODE (x3) != E_V4DFmode
          || !vector_operand (operands[1], E_V4DFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3187; /* *reducepv4df */

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode
          || !vector_operand (operands[1], E_V2DFmode)
          || !(
#line 4028 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 3191; /* *reducepv2df */

    default:
      return -1;
    }
}

 int
recog_240 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      if (pattern152 (x3, 
E_V32QImode) != 0
          || !(
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 752 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8558; /* avx2_psignv32qi3 */

    case E_V16QImode:
      if (pattern152 (x3, 
E_V16QImode) != 0
          || !
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8559; /* ssse3_psignv16qi3 */

    case E_V16HImode:
      if (pattern152 (x3, 
E_V16HImode) != 0
          || !(
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 753 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8560; /* avx2_psignv16hi3 */

    case E_V8HImode:
      if (pattern152 (x3, 
E_V8HImode) != 0
          || !
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8561; /* ssse3_psignv8hi3 */

    case E_V8SImode:
      if (pattern152 (x3, 
E_V8SImode) != 0
          || !(
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 754 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
        return -1;
      return 8562; /* avx2_psignv8si3 */

    case E_V4SImode:
      if (pattern152 (x3, 
E_V4SImode) != 0
          || !
#line 23187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
        return -1;
      return 8563; /* ssse3_psignv4si3 */

    default:
      return -1;
    }
}

 int
recog_246 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_CODE (operands[3]))
    {
    case REG:
    case SUBREG:
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern1021 (x3, 
E_HImode, 
E_V16SImode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9850; /* expandv16si_mask */

        case E_V16SFmode:
          if (pattern1021 (x3, 
E_HImode, 
E_V16SFmode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9851; /* expandv16sf_mask */

        case E_V8DImode:
          if (pattern1021 (x3, 
E_QImode, 
E_V8DImode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9852; /* expandv8di_mask */

        case E_V8DFmode:
          if (pattern1021 (x3, 
E_QImode, 
E_V8DFmode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9853; /* expandv8df_mask */

        case E_V8SImode:
          if (pattern1021 (x3, 
E_QImode, 
E_V8SImode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9854; /* expandv8si_mask */

        case E_V8SFmode:
          if (pattern1021 (x3, 
E_QImode, 
E_V8SFmode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9855; /* expandv8sf_mask */

        case E_V4DImode:
          if (pattern1021 (x3, 
E_QImode, 
E_V4DImode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9856; /* expandv4di_mask */

        case E_V4DFmode:
          if (pattern1021 (x3, 
E_QImode, 
E_V4DFmode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9857; /* expandv4df_mask */

        case E_V4SImode:
          if (pattern1021 (x3, 
E_QImode, 
E_V4SImode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9858; /* expandv4si_mask */

        case E_V4SFmode:
          if (pattern1021 (x3, 
E_QImode, 
E_V4SFmode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9859; /* expandv4sf_mask */

        case E_V2DImode:
          if (pattern1021 (x3, 
E_QImode, 
E_V2DImode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9860; /* expandv2di_mask */

        case E_V2DFmode:
          if (pattern1021 (x3, 
E_QImode, 
E_V2DFmode) != 0
              || !(
#line 29960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9861; /* expandv2df_mask */

        case E_V64QImode:
          if (pattern1021 (x3, 
E_DImode, 
E_V64QImode) != 0
              || !(
#line 29974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9862; /* expandv64qi_mask */

        case E_V16QImode:
          if (pattern1021 (x3, 
E_HImode, 
E_V16QImode) != 0
              || !(
#line 29974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9863; /* expandv16qi_mask */

        case E_V32QImode:
          if (pattern1021 (x3, 
E_SImode, 
E_V32QImode) != 0
              || !(
#line 29974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9864; /* expandv32qi_mask */

        case E_V32HImode:
          if (pattern1021 (x3, 
E_SImode, 
E_V32HImode) != 0
              || !(
#line 29974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9865; /* expandv32hi_mask */

        case E_V16HImode:
          if (pattern1021 (x3, 
E_HImode, 
E_V16HImode) != 0
              || !(
#line 29974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9866; /* expandv16hi_mask */

        case E_V8HImode:
          if (pattern1021 (x3, 
E_QImode, 
E_V8HImode) != 0
              || !(
#line 29974 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9867; /* expandv8hi_mask */

        default:
          return -1;
        }

    case CONST_INT:
      switch (pattern907 (x3))
        {
        case 0:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16SImode)) >= 4)) && 
#line 1016 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9868; /* *expandv16si_mask */

        case 1:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16SFmode)) >= 4)) && 
#line 1017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9869; /* *expandv16sf_mask */

        case 2:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8DImode)) >= 4)) && 
#line 1018 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9870; /* *expandv8di_mask */

        case 3:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8DFmode)) >= 4)) && 
#line 1019 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 9871; /* *expandv8df_mask */

        case 4:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8SImode)) >= 4)) && 
#line 1020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9872; /* *expandv8si_mask */

        case 5:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8SFmode)) >= 4)) && 
#line 1020 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9873; /* *expandv8sf_mask */

        case 6:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4DImode)) >= 4)) && 
#line 1021 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9874; /* *expandv4di_mask */

        case 7:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4DFmode)) >= 4)) && 
#line 1021 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9875; /* *expandv4df_mask */

        case 8:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4SImode)) >= 4)) && 
#line 1022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9876; /* *expandv4si_mask */

        case 9:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V4SFmode)) >= 4)) && 
#line 1022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9877; /* *expandv4sf_mask */

        case 10:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V2DImode)) >= 4)) && 
#line 1023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9878; /* *expandv2di_mask */

        case 11:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V2DFmode)) >= 4)) && 
#line 1023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9879; /* *expandv2df_mask */

        case 12:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V64QImode)) >= 4)) && 
#line 1024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9880; /* *expandv64qi_mask */

        case 13:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16QImode)) >= 4)) && 
#line 1024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9881; /* *expandv16qi_mask */

        case 14:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V32QImode)) >= 4)) && 
#line 1024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9882; /* *expandv32qi_mask */

        case 15:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V32HImode)) >= 4)) && 
#line 1025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9883; /* *expandv32hi_mask */

        case 16:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V16HImode)) >= 4)) && 
#line 1025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9884; /* *expandv16hi_mask */

        case 17:
          if (!(
#line 29988 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(ix86_pre_reload_split ()
   && (TARGET_AVX512VBMI2 || GET_MODE_SIZE (GET_MODE_INNER (V8HImode)) >= 4)) && 
#line 1025 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9885; /* *expandv8hi_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_251 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  if (!const_0_to_15_operand (operands[3], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (pattern152 (x3, 
E_V16SFmode) != 0
          || !(
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9886; /* avx512dq_rangepv16sf */

    case E_V8SFmode:
      if (pattern152 (x3, 
E_V8SFmode) != 0
          || !(
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9890; /* avx512dq_rangepv8sf */

    case E_V4SFmode:
      if (pattern152 (x3, 
E_V4SFmode) != 0
          || !(
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 520 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9892; /* avx512dq_rangepv4sf */

    case E_V8DFmode:
      if (pattern152 (x3, 
E_V8DFmode) != 0
          || !(
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9894; /* avx512dq_rangepv8df */

    case E_V4DFmode:
      if (pattern152 (x3, 
E_V4DFmode) != 0
          || !(
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9898; /* avx512dq_rangepv4df */

    case E_V2DFmode:
      if (pattern152 (x3, 
E_V2DFmode) != 0
          || !(
#line 30054 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 521 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9900; /* avx512dq_rangepv2df */

    default:
      return -1;
    }
}

 int
recog_255 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern176 (x1))
    {
    case 0:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10147; /* vpshrdv_v32hi */

    case 1:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10148; /* vpshrdv_v16si */

    case 2:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 757 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 10149; /* vpshrdv_v8di */

    case 3:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10150; /* vpshrdv_v16hi */

    case 4:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10151; /* vpshrdv_v8si */

    case 5:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10152; /* vpshrdv_v4di */

    case 6:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 759 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10153; /* vpshrdv_v8hi */

    case 7:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10154; /* vpshrdv_v4si */

    case 8:
      if (!(
#line 30660 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VBMI2) && 
#line 760 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 10155; /* vpshrdv_v2di */

    default:
      return -1;
    }
}

 int
recog_262 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 51:
      return recog_245 (x1, insn, pnum_clobbers);

    case 59:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!cmpps_imm_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern61 (x2, 
E_V8SFmode) != 0
              || !(
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3207; /* avx_cmpv8sf3 */

        case E_V4SFmode:
          if (pattern61 (x2, 
E_V4SFmode) != 0
              || !
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 3208; /* avx_cmpv4sf3 */

        case E_V4DFmode:
          if (pattern61 (x2, 
E_V4DFmode) != 0
              || !(
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 3209; /* avx_cmpv4df3 */

        case E_V2DFmode:
          if (pattern61 (x2, 
E_V2DFmode) != 0
              || !(
#line 4100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 3210; /* avx_cmpv2df3 */

        default:
          return -1;
        }

    case 133:
      return recog_244 (x1, insn, pnum_clobbers);

    case 217:
      return recog_260 (x1, insn, pnum_clobbers);

    case 219:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      switch (pattern665 (x2))
        {
        case 0:
          if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 4256; /* fma_fcmaddc_v32hf */
          break;

        case 1:
          if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4262; /* fma_fcmaddc_v16hf */
          break;

        case 2:
          if ((
#line 7164 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && 1 && 1) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4266; /* fma_fcmaddc_v8hf */
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || maybe_ne (SUBREG_BYTE (x5), 0))
        return -1;
      switch (pattern593 (x2))
        {
        case 0:
          if (!(
#line 7270 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4289; /* fma_v32hf_fcmaddc_bcst */

        case 1:
          if (!(
#line 7270 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4290; /* fma_v16hf_fcmaddc_bcst */

        case 2:
          if (!(
#line 7270 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && ix86_pre_reload_split ()) && 
#line 554 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4291; /* fma_v8hf_fcmaddc_bcst */

        default:
          return -1;
        }

    case 218:
      switch (pattern169 (x1))
        {
        case 0:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4280; /* fma_fmaddc_v16sf_pair */

        case 1:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4282; /* fma_fmaddc_v8sf_pair */

        case 2:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4284; /* fma_fmaddc_v4sf_pair */

        default:
          return -1;
        }

    case 220:
      switch (pattern169 (x1))
        {
        case 0:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4281; /* fma_fcmaddc_v16sf_pair */

        case 1:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4283; /* fma_fcmaddc_v8sf_pair */

        case 2:
          if (!(
#line 7229 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4285; /* fma_fcmaddc_v4sf_pair */

        default:
          return -1;
        }

    case 50:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[2] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[1] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4SImode:
          if (pattern958 (x2, 
E_V4SImode) != 0
              || !
#line 12216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 5234; /* sse4_1_insertps_v4si */

        case E_V4SFmode:
          if (pattern958 (x2, 
E_V4SFmode) != 0
              || !
#line 12216 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
            return -1;
          return 5235; /* sse4_1_insertps_v4sf */

        default:
          return -1;
        }

    case 167:
      return recog_252 (x1, insn, pnum_clobbers);

    case 155:
      return recog_247 (x1, insn, pnum_clobbers);

    case 47:
      return recog_243 (x1, insn, pnum_clobbers);

    case 121:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_mul_8_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V4TImode:
          if (pattern152 (x2, 
E_V4TImode) != 0
              || !(
#line 23244 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 725 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
            return -1;
          return 8570; /* avx512bw_palignrv4ti */

        case E_V2TImode:
          if (pattern152 (x2, 
E_V2TImode) != 0
              || !(
#line 23244 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3) && 
#line 725 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 8571; /* avx2_palignrv2ti */

        case E_V1TImode:
          if (pattern152 (x2, 
E_V1TImode) != 0
              || !
#line 23244 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3))
            return -1;
          return 8572; /* ssse3_palignrv1ti */

        default:
          return -1;
        }

    case 122:
      if (GET_MODE (x2) != E_V2DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_V2DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      if (!const_0_to_255_operand (operands[2], E_VOIDmode))
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_VOIDmode)
          || !
#line 23438 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4A))
        return -1;
      return 8602; /* sse4a_extrqi */

    case 126:
      return recog_258 (x1, insn, pnum_clobbers);

    case 128:
      return recog_259 (x1, insn, pnum_clobbers);

    case 53:
      if (pattern63 (x1, 
E_V16QImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!nonimmediate_operand (operands[3], E_V16QImode)
          || !
#line 26725 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
        return -1;
      return 8957; /* xop_pperm */

    case 135:
      return recog_257 (x1, insn, pnum_clobbers);

    case 143:
      if (pattern160 (x1, 
E_V2DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode)
          || !
#line 27438 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_PCLMUL))
        return -1;
      return 9016; /* pclmulqdq */

    case 152:
      if (pattern63 (x1, 
E_V4DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode)
          || !
#line 27895 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2))
        return -1;
      return 9106; /* avx2_permv2ti */

    case 146:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8SImode:
          if (pattern61 (x2, 
E_V8SImode) != 0
              || !
#line 28549 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9376; /* *avx_vperm2f128v8si_full */

        case E_V8SFmode:
          if (pattern61 (x2, 
E_V8SFmode) != 0
              || !
#line 28549 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9377; /* *avx_vperm2f128v8sf_full */

        case E_V4DFmode:
          if (pattern61 (x2, 
E_V4DFmode) != 0
              || !
#line 28549 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 9378; /* *avx_vperm2f128v4df_full */

        default:
          return -1;
        }

    case 153:
      return recog_242 (x1, insn, pnum_clobbers);

    case 169:
      return recog_249 (x1, insn, pnum_clobbers);

    case 170:
      return recog_248 (x1, insn, pnum_clobbers);

    case 171:
      return recog_246 (x1, insn, pnum_clobbers);

    case 194:
      return recog_251 (x1, insn, pnum_clobbers);

    case 186:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HImode:
          if (pattern163 (x2, 
E_V8HImode, 
E_V16QImode) != 0
              || !(
#line 30166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9982; /* *avx512bw_dbpsadbwv8hi */

        case E_V16HImode:
          if (pattern163 (x2, 
E_V16HImode, 
E_V32QImode) != 0
              || !(
#line 30166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 9984; /* *avx512bw_dbpsadbwv16hi */

        case E_V32HImode:
          if (pattern163 (x2, 
E_V32HImode, 
E_V64QImode) != 0
              || !(
#line 30166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 9986; /* *avx512bw_dbpsadbwv32hi */

        default:
          return -1;
        }

    case 182:
      if (pattern160 (x1, 
E_V4SImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_3_operand (operands[3], E_SImode)
          || !
#line 30234 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10015; /* sha1rnds4 */

    case 185:
      if (pattern160 (x1, 
E_V4SImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!register_operand (operands[3], E_V4SImode)
          || !
#line 30269 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA))
        return -1;
      return 10018; /* sha256rnds2 */

    case 224:
      if (pattern171 (x1) != 0
          || !
#line 30282 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM3))
        return -1;
      return 10019; /* vsm3msg1 */

    case 225:
      if (pattern171 (x1) != 0
          || !
#line 30294 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SM3))
        return -1;
      return 10020; /* vsm3msg2 */

    case 241:
      if (pattern159 (x1, 
E_V4DImode) != 0)
        return -1;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!register_operand (operands[3], E_V2DImode)
          || !
#line 30342 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SHA512))
        return -1;
      return 10024; /* vsha512rnds2 */

    case 195:
      switch (pattern173 (x1))
        {
        case 0:
          if (!
#line 30451 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512IFMA && TARGET_EVEX512))
            return -1;
          return 10037; /* vpmadd52luqv8di */

        case 1:
          if (!(
#line 30464 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10039; /* vpmadd52luqv4di */

        case 2:
          if (!
#line 30464 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)))
            return -1;
          return 10041; /* vpmadd52luqv2di */

        default:
          return -1;
        }

    case 196:
      switch (pattern173 (x1))
        {
        case 0:
          if (!
#line 30451 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512IFMA && TARGET_EVEX512))
            return -1;
          return 10038; /* vpmadd52huqv8di */

        case 1:
          if (!(
#line 30464 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)) && 
#line 704 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10040; /* vpmadd52huqv4di */

        case 2:
          if (!
#line 30464 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXIFMA || (TARGET_AVX512IFMA && TARGET_AVX512VL)))
            return -1;
          return 10042; /* vpmadd52huqv2di */

        default:
          return -1;
        }

    case 198:
      switch (pattern174 (x1))
        {
        case 0:
          if (!(
#line 30588 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10093; /* vgf2p8affineinvqb_v64qi */

        case 1:
          if (!(
#line 30588 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10095; /* vgf2p8affineinvqb_v32qi */

        case 2:
          if (!
#line 30588 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI))
            return -1;
          return 10097; /* vgf2p8affineinvqb_v16qi */

        default:
          return -1;
        }

    case 199:
      switch (pattern174 (x1))
        {
        case 0:
          if (!(
#line 30605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10099; /* vgf2p8affineqb_v64qi */

        case 1:
          if (!(
#line 30605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI) && 
#line 635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10101; /* vgf2p8affineqb_v32qi */

        case 2:
          if (!
#line 30605 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_GFNI))
            return -1;
          return 10103; /* vgf2p8affineqb_v16qi */

        default:
          return -1;
        }

    case 202:
      return recog_256 (x1, insn, pnum_clobbers);

    case 201:
      return recog_254 (x1, insn, pnum_clobbers);

    case 203:
      return recog_255 (x1, insn, pnum_clobbers);

    case 204:
      return recog_253 (x1, insn, pnum_clobbers);

    case 205:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30822 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10201; /* vpdpbusd_v16si */

        case 1:
          if (!(
#line 30833 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10202; /* vpdpbusd_v8si */

        case 2:
          if (!
#line 30833 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10203; /* vpdpbusd_v4si */

        default:
          return -1;
        }

    case 206:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30891 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10210; /* vpdpbusds_v16si */

        case 1:
          if (!(
#line 30902 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10211; /* vpdpbusds_v8si */

        case 2:
          if (!
#line 30902 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10212; /* vpdpbusds_v4si */

        default:
          return -1;
        }

    case 207:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 30960 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10219; /* vpdpwssd_v16si */

        case 1:
          if (!(
#line 30971 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10220; /* vpdpwssd_v8si */

        case 2:
          if (!
#line 30971 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10221; /* vpdpwssd_v4si */

        default:
          return -1;
        }

    case 208:
      switch (pattern177 (x1))
        {
        case 0:
          if (!
#line 31029 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VNNI && TARGET_EVEX512))
            return -1;
          return 10228; /* vpdpwssds_v16si */

        case 1:
          if (!(
#line 31040 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)) && 
#line 668 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)))
            return -1;
          return 10229; /* vpdpwssds_v8si */

        case 2:
          if (!
#line 31040 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNI || (TARGET_AVX512VNNI && TARGET_AVX512VL)))
            return -1;
          return 10230; /* vpdpwssds_v4si */

        default:
          return -1;
        }

    case 213:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DImode:
          if (pattern152 (x2, 
E_V8DImode) != 0
              || !(
#line 31169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ) && 
#line 620 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 10249; /* vpclmulqdq_v8di */

        case E_V4DImode:
          if (pattern152 (x2, 
E_V4DImode) != 0
              || !
#line 31169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ))
            return -1;
          return 10250; /* vpclmulqdq_v4di */

        case E_V2DImode:
          if (pattern152 (x2, 
E_V2DImode) != 0
              || !(
#line 31169 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_VPCLMULQDQ) && 
#line 620 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10251; /* vpclmulqdq_v2di */

        default:
          return -1;
        }

    case 216:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern908 (x2, 
E_V32BFmode, 
E_V16SFmode) != 0
              || !(
#line 31448 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 10279; /* avx512f_dpbf16ps_v16sf */

        case E_V8SFmode:
          if (pattern908 (x2, 
E_V16BFmode, 
E_V8SFmode) != 0
              || !(
#line 31448 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10281; /* avx512f_dpbf16ps_v8sf */

        case E_V4SFmode:
          if (pattern908 (x2, 
E_V8BFmode, 
E_V4SFmode) != 0
              || !(
#line 31448 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BF16) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 10283; /* avx512f_dpbf16ps_v4sf */

        default:
          return -1;
        }

    case 227:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10299; /* vpdpbssd_v8si */

        case 1:
          if (!
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10305; /* vpdpbssd_v4si */

        case 2:
          if (!
#line 31832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10311; /* vpdpbssd_v16si */

        default:
          return -1;
        }

    case 228:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10300; /* vpdpbssds_v8si */

        case 1:
          if (!
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10306; /* vpdpbssds_v4si */

        case 2:
          if (!
#line 31832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10312; /* vpdpbssds_v16si */

        default:
          return -1;
        }

    case 229:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10301; /* vpdpbsud_v8si */

        case 1:
          if (!
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10307; /* vpdpbsud_v4si */

        case 2:
          if (!
#line 31832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10313; /* vpdpbsud_v16si */

        default:
          return -1;
        }

    case 230:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10302; /* vpdpbsuds_v8si */

        case 1:
          if (!
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10308; /* vpdpbsuds_v4si */

        case 2:
          if (!
#line 31832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10314; /* vpdpbsuds_v16si */

        default:
          return -1;
        }

    case 231:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10303; /* vpdpbuud_v8si */

        case 1:
          if (!
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10309; /* vpdpbuud_v4si */

        case 2:
          if (!
#line 31832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10315; /* vpdpbuud_v16si */

        default:
          return -1;
        }

    case 232:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10304; /* vpdpbuuds_v8si */

        case 1:
          if (!
#line 31821 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT8 || TARGET_AVX10_2))
            return -1;
          return 10310; /* vpdpbuuds_v4si */

        case 2:
          if (!
#line 31832 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10316; /* vpdpbuuds_v16si */

        default:
          return -1;
        }

    case 233:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10451; /* vpdpwusd_v8si */

        case 1:
          if (!
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10457; /* vpdpwusd_v4si */

        case 2:
          if (!
#line 32241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10463; /* vpdpwusd_v16si */

        default:
          return -1;
        }

    case 234:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10452; /* vpdpwusds_v8si */

        case 1:
          if (!
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10458; /* vpdpwusds_v4si */

        case 2:
          if (!
#line 32241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10464; /* vpdpwusds_v16si */

        default:
          return -1;
        }

    case 235:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10453; /* vpdpwsud_v8si */

        case 1:
          if (!
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10459; /* vpdpwsud_v4si */

        case 2:
          if (!
#line 32241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10465; /* vpdpwsud_v16si */

        default:
          return -1;
        }

    case 236:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10454; /* vpdpwsuds_v8si */

        case 1:
          if (!
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10460; /* vpdpwsuds_v4si */

        case 2:
          if (!
#line 32241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10466; /* vpdpwsuds_v16si */

        default:
          return -1;
        }

    case 237:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10455; /* vpdpwuud_v8si */

        case 1:
          if (!
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10461; /* vpdpwuud_v4si */

        case 2:
          if (!
#line 32241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10467; /* vpdpwuud_v16si */

        default:
          return -1;
        }

    case 238:
      switch (pattern178 (x1))
        {
        case 0:
          if (!(
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2) && 
#line 665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 10456; /* vpdpwuuds_v8si */

        case 1:
          if (!
#line 32230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXVNNIINT16 || TARGET_AVX10_2))
            return -1;
          return 10462; /* vpdpwuuds_v4si */

        case 2:
          if (!
#line 32241 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10468; /* vpdpwuuds_v16si */

        default:
          return -1;
        }

    case 244:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SFmode:
          if (pattern172 (x2, 
E_V16SFmode) != 0
              || !
#line 32293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10505; /* vdpphps_v16sf */

        case E_V8SFmode:
          if (pattern172 (x2, 
E_V8SFmode) != 0
              || !
#line 32293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10506; /* vdpphps_v8sf */

        case E_V4SFmode:
          if (pattern172 (x2, 
E_V4SFmode) != 0
              || !
#line 32293 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10507; /* vdpphps_v4sf */

        default:
          return -1;
        }

    case 277:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      x5 = XVECEXP (x2, 0, 1);
      operands[2] = x5;
      x6 = XVECEXP (x2, 0, 2);
      operands[3] = x6;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V32BFmode:
          if (pattern1022 (x2, 
E_V32BFmode) != 0
              || !
#line 32883 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10826; /* avx10_2_minmaxbf16_v32bf */

        case E_V16BFmode:
          if (pattern1022 (x2, 
E_V16BFmode) != 0
              || !
#line 32883 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10828; /* avx10_2_minmaxbf16_v16bf */

        case E_V8BFmode:
          if (pattern1022 (x2, 
E_V8BFmode) != 0
              || !
#line 32883 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10830; /* avx10_2_minmaxbf16_v8bf */

        default:
          return -1;
        }

    case 278:
      return recog_250 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_287 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  operands[6] = x4;
  res = recog_286 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x3, 0, 5);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x6 = XVECEXP (x3, 0, 6);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x7 = XVECEXP (x3, 0, 7);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V8HImode)
      || GET_MODE (x2) != E_V8HImode
      || !vector_operand (operands[1], E_V8HImode)
      || pattern672 (x3) != 0
      || !
#line 20834 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
    return -1;
  return 8374; /* sse2_pshuflw_1 */
}

 int
recog_291 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 4);
  if (GET_CODE (x4) != CONST_INT)
    return -1;
  operands[6] = x4;
  res = recog_290 (x1, insn, pnum_clobbers);
  if (res >= 0)
    return res;
  if (XWINT (x4, 0) != 4L)
    return -1;
  x5 = XVECEXP (x3, 0, 5);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x6 = XVECEXP (x3, 0, 6);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x7 = XVECEXP (x3, 0, 7);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || pattern1403 (x3) != 0
      || !register_operand (operands[0], E_V16HImode)
      || GET_MODE (x2) != E_V16HImode
      || !nonimmediate_operand (operands[1], E_V16HImode)
      || pattern672 (x3) != 0)
    return -1;
  x8 = XVECEXP (x3, 0, 8);
  operands[6] = x8;
  if (!const_8_to_11_operand (operands[6], E_VOIDmode))
    return -1;
  x9 = XVECEXP (x3, 0, 9);
  operands[7] = x9;
  if (!const_8_to_11_operand (operands[7], E_VOIDmode))
    return -1;
  x10 = XVECEXP (x3, 0, 10);
  operands[8] = x10;
  if (!const_8_to_11_operand (operands[8], E_VOIDmode))
    return -1;
  x11 = XVECEXP (x3, 0, 11);
  operands[9] = x11;
  if (!const_8_to_11_operand (operands[9], E_VOIDmode)
      || !
#line 20768 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2
   && 1 && 1
   && INTVAL (operands[2]) + 8 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 8 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 8 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 8 == INTVAL (operands[9])))
    return -1;
  return 8372; /* avx2_pshuflw_1 */
}

 int
recog_298 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5446; /* *avx512bw_vpternlogv64qi_1 */

        case 1:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5473; /* *avx512vl_vpternlogv32qi_1 */

        case 2:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5500; /* *avx512vl_vpternlogv16qi_1 */

        case 3:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5527; /* *avx512bw_vpternlogv32hi_1 */

        case 4:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5554; /* *avx512vl_vpternlogv16hi_1 */

        case 5:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5581; /* *avx512vl_vpternlogv8hi_1 */

        case 6:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5608; /* *avx512f_vpternlogv16si_1 */

        case 7:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5635; /* *avx512vl_vpternlogv8si_1 */

        case 8:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5662; /* *avx512vl_vpternlogv4si_1 */

        case 9:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5689; /* *avx512f_vpternlogv8di_1 */

        case 10:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5716; /* *avx512vl_vpternlogv4di_1 */

        case 11:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5743; /* *avx512vl_vpternlogv2di_1 */

        case 12:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5449; /* *avx512bw_vpternlogv64qi_1 */

        case 13:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5476; /* *avx512vl_vpternlogv32qi_1 */

        case 14:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5503; /* *avx512vl_vpternlogv16qi_1 */

        case 15:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5530; /* *avx512bw_vpternlogv32hi_1 */

        case 16:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5557; /* *avx512vl_vpternlogv16hi_1 */

        case 17:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5584; /* *avx512vl_vpternlogv8hi_1 */

        case 18:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5611; /* *avx512f_vpternlogv16si_1 */

        case 19:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5638; /* *avx512vl_vpternlogv8si_1 */

        case 20:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5665; /* *avx512vl_vpternlogv4si_1 */

        case 21:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5692; /* *avx512f_vpternlogv8di_1 */

        case 22:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5719; /* *avx512vl_vpternlogv4di_1 */

        case 23:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5746; /* *avx512vl_vpternlogv2di_1 */

        case 24:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5452; /* *avx512bw_vpternlogv64qi_1 */

        case 25:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5479; /* *avx512vl_vpternlogv32qi_1 */

        case 26:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5506; /* *avx512vl_vpternlogv16qi_1 */

        case 27:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5533; /* *avx512bw_vpternlogv32hi_1 */

        case 28:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5560; /* *avx512vl_vpternlogv16hi_1 */

        case 29:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5587; /* *avx512vl_vpternlogv8hi_1 */

        case 30:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5614; /* *avx512f_vpternlogv16si_1 */

        case 31:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5641; /* *avx512vl_vpternlogv8si_1 */

        case 32:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5668; /* *avx512vl_vpternlogv4si_1 */

        case 33:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5695; /* *avx512f_vpternlogv8di_1 */

        case 34:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5722; /* *avx512vl_vpternlogv4di_1 */

        case 35:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5749; /* *avx512vl_vpternlogv2di_1 */

        case 36:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6730; /* *avx512bw_vpternlogv64qi_3 */

        case 37:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6739; /* *avx512vl_vpternlogv32qi_3 */

        case 38:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6748; /* *avx512vl_vpternlogv16qi_3 */

        case 39:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6757; /* *avx512bw_vpternlogv32hi_3 */

        case 40:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6766; /* *avx512vl_vpternlogv16hi_3 */

        case 41:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6775; /* *avx512vl_vpternlogv8hi_3 */

        case 42:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6784; /* *avx512f_vpternlogv16si_3 */

        case 43:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6793; /* *avx512vl_vpternlogv8si_3 */

        case 44:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6802; /* *avx512vl_vpternlogv4si_3 */

        case 45:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6811; /* *avx512f_vpternlogv8di_3 */

        case 46:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6820; /* *avx512vl_vpternlogv4di_3 */

        case 47:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6829; /* *avx512vl_vpternlogv2di_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern535 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6094; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6121; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6148; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6175; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6202; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6229; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6256; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6283; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6310; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6337; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6364; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6391; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6097; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6124; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6151; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6178; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6205; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6232; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6259; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6286; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6313; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6340; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6367; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6394; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6100; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6127; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6154; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6181; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6208; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6235; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6262; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6289; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6316; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6343; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6370; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6397; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_308 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern537 (x2))
        {
        case 0:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5772; /* *avx512bw_vpternlogv32hf_1 */

        case 1:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5799; /* *avx512vl_vpternlogv16hf_1 */

        case 2:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5826; /* *avx512fp16_vpternlogv8hf_1 */

        case 3:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5853; /* *avx512bw_vpternlogv32bf_1 */

        case 4:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5880; /* *avx512vl_vpternlogv16bf_1 */

        case 5:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5907; /* *avx512vl_vpternlogv8bf_1 */

        case 6:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5934; /* *avx512f_vpternlogv16sf_1 */

        case 7:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5961; /* *avx512vl_vpternlogv8sf_1 */

        case 8:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5988; /* *avx512vl_vpternlogv4sf_1 */

        case 9:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6015; /* *avx512f_vpternlogv8df_1 */

        case 10:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6042; /* *avx512vl_vpternlogv4df_1 */

        case 11:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6069; /* *avx512vl_vpternlogv2df_1 */

        case 12:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5775; /* *avx512bw_vpternlogv32hf_1 */

        case 13:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5802; /* *avx512vl_vpternlogv16hf_1 */

        case 14:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5829; /* *avx512fp16_vpternlogv8hf_1 */

        case 15:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5856; /* *avx512bw_vpternlogv32bf_1 */

        case 16:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5883; /* *avx512vl_vpternlogv16bf_1 */

        case 17:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5910; /* *avx512vl_vpternlogv8bf_1 */

        case 18:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5937; /* *avx512f_vpternlogv16sf_1 */

        case 19:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5964; /* *avx512vl_vpternlogv8sf_1 */

        case 20:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5991; /* *avx512vl_vpternlogv4sf_1 */

        case 21:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6018; /* *avx512f_vpternlogv8df_1 */

        case 22:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6045; /* *avx512vl_vpternlogv4df_1 */

        case 23:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6072; /* *avx512vl_vpternlogv2df_1 */

        case 24:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5778; /* *avx512bw_vpternlogv32hf_1 */

        case 25:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5805; /* *avx512vl_vpternlogv16hf_1 */

        case 26:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5832; /* *avx512fp16_vpternlogv8hf_1 */

        case 27:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5859; /* *avx512bw_vpternlogv32bf_1 */

        case 28:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5886; /* *avx512vl_vpternlogv16bf_1 */

        case 29:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5913; /* *avx512vl_vpternlogv8bf_1 */

        case 30:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5940; /* *avx512f_vpternlogv16sf_1 */

        case 31:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5967; /* *avx512vl_vpternlogv8sf_1 */

        case 32:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5994; /* *avx512vl_vpternlogv4sf_1 */

        case 33:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6021; /* *avx512f_vpternlogv8df_1 */

        case 34:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6048; /* *avx512vl_vpternlogv4df_1 */

        case 35:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6075; /* *avx512vl_vpternlogv2df_1 */

        case 36:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6840; /* *avx512bw_vpternlogv32hf_3 */

        case 37:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6849; /* *avx512vl_vpternlogv16hf_3 */

        case 38:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6858; /* *avx512fp16_vpternlogv8hf_3 */

        case 39:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6867; /* *avx512bw_vpternlogv32bf_3 */

        case 40:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6876; /* *avx512vl_vpternlogv16bf_3 */

        case 41:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6885; /* *avx512vl_vpternlogv8bf_3 */

        case 42:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6894; /* *avx512f_vpternlogv16sf_3 */

        case 43:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6903; /* *avx512vl_vpternlogv8sf_3 */

        case 44:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6912; /* *avx512vl_vpternlogv4sf_3 */

        case 45:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6921; /* *avx512f_vpternlogv8df_3 */

        case 46:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6930; /* *avx512vl_vpternlogv4df_3 */

        case 47:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6939; /* *avx512vl_vpternlogv2df_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern538 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6420; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6447; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6474; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6501; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6528; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6555; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6582; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6609; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6636; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6663; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6690; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6717; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern538 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6423; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6450; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6477; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6504; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6531; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6558; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6585; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6612; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6639; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6666; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6693; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6720; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern538 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6426; /* *avx512bw_vpternlogv32hf_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6453; /* *avx512vl_vpternlogv16hf_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6480; /* *avx512fp16_vpternlogv8hf_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6507; /* *avx512bw_vpternlogv32bf_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6534; /* *avx512vl_vpternlogv16bf_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6561; /* *avx512vl_vpternlogv8bf_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6588; /* *avx512f_vpternlogv16sf_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6615; /* *avx512vl_vpternlogv8sf_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6642; /* *avx512vl_vpternlogv4sf_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6669; /* *avx512f_vpternlogv8df_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6696; /* *avx512vl_vpternlogv4df_2 */

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 6723; /* *avx512vl_vpternlogv2df_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_323 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V8DFmode:
          if (!register_operand (operands[0], E_V8DFmode)
              || GET_MODE (x3) != E_V8DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8HFmode:
              if (!vector_operand (operands[1], E_V8HFmode)
                  || !(
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4646; /* avx512fp16_float_extend_phv8df2 */

            case E_V8SFmode:
              if (!vector_operand (operands[1], E_V8SFmode)
                  || !(
#line 10207 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1 && 1) && 
#line 467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5091; /* avx512f_cvtps2pd512 */

            default:
              return -1;
            }

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x3) != E_V16SFmode
              || !vector_operand (operands[1], E_V16HFmode)
              || !(
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4650; /* avx512fp16_float_extend_phv16sf2 */

        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || GET_MODE (x3) != E_V8SFmode
              || !vector_operand (operands[1], E_V8HFmode)
              || !(
#line 8022 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1003 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4654; /* avx512fp16_float_extend_phv8sf2 */

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || GET_MODE (x3) != E_V4DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4HFmode:
              if (!memory_operand (operands[1], E_V4HFmode)
                  || !
#line 8061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                return -1;
              return 4662; /* *avx512fp16_float_extend_phv4df2_load */

            case E_V4SFmode:
              if (!vector_operand (operands[1], E_V4SFmode)
                  || !
#line 10207 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1 && 1))
                return -1;
              return 5095; /* avx_cvtps2pd256 */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || GET_MODE (x3) != E_V4SFmode
              || !memory_operand (operands[1], E_V4HFmode)
              || !
#line 8061 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4664; /* *avx512fp16_float_extend_phv4sf2_load */

        case E_V2DFmode:
          if (!register_operand (operands[0], E_V2DFmode)
              || GET_MODE (x3) != E_V2DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V2HFmode:
              if (!memory_operand (operands[1], E_V2HFmode)
                  || !
#line 8100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                return -1;
              return 4668; /* *avx512fp16_float_extend_phv2df2_load */

            case E_V2SFmode:
              if (!memory_operand (operands[1], E_V2SFmode)
                  || !
#line 10389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
                return -1;
              return 5143; /* sse2_cvtps2pd_1 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != PARALLEL)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      switch (XVECLEN (x5, 0))
        {
        case 4:
          x7 = XVECEXP (x5, 0, 0);
          if (GET_CODE (x7) != CONST_INT)
            return -1;
          x8 = XVECEXP (x5, 0, 1);
          if (GET_CODE (x8) != CONST_INT)
            return -1;
          x9 = XVECEXP (x5, 0, 2);
          if (GET_CODE (x9) != CONST_INT)
            return -1;
          x10 = XVECEXP (x5, 0, 3);
          if (GET_CODE (x10) != CONST_INT)
            return -1;
          switch (pattern1130 (x5))
            {
            case 0:
              if (XWINT (x9, 0) != 2L
                  || XWINT (x10, 0) != 3L)
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4DFmode:
                  if (!register_operand (operands[0], E_V4DFmode)
                      || GET_MODE (x3) != E_V4DFmode)
                    return -1;
                  switch (GET_MODE (x4))
                    {
                    case E_V4HFmode:
                      if (!register_operand (operands[1], E_V8HFmode)
                          || !
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                        return -1;
                      return 4658; /* avx512fp16_float_extend_phv4df2 */

                    case E_V4SFmode:
                      if (!nonimmediate_operand (operands[1], E_V8SFmode)
                          || !
#line 10220 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
                        return -1;
                      return 5097; /* *avx_cvtps2pd256_2 */

                    default:
                      return -1;
                    }

                case E_V4SFmode:
                  if (pattern607 (x3, 
E_V8HFmode, 
E_V4HFmode, 
E_V4SFmode) != 0
                      || !
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                    return -1;
                  return 4660; /* avx512fp16_float_extend_phv4sf2 */

                default:
                  return -1;
                }

            case 1:
              if (XWINT (x9, 0) != 4L
                  || XWINT (x10, 0) != 6L)
                return -1;
              switch (pattern1468 (x3))
                {
                case 0:
                  if (!
#line 31910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10357; /* vcvtneeph2ps_v8hf */

                case 1:
                  if (!
#line 31910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10358; /* vcvtneebf162ps_v8bf */

                default:
                  return -1;
                }

            case 2:
              switch (pattern1468 (x3))
                {
                case 0:
                  if (!
#line 31938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10361; /* vcvtneoph2ps_v8hf */

                case 1:
                  if (!
#line 31938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10362; /* vcvtneobf162ps_v8bf */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 2:
          x7 = XVECEXP (x5, 0, 0);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x8 = XVECEXP (x5, 0, 1);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || !register_operand (operands[0], E_V2DFmode)
              || GET_MODE (x3) != E_V2DFmode)
            return -1;
          switch (GET_MODE (x4))
            {
            case E_V2HFmode:
              if (!register_operand (operands[1], E_V8HFmode)
                  || !
#line 8090 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
                return -1;
              return 4666; /* avx512fp16_float_extend_phv2df2 */

            case E_V2SFmode:
              if (!register_operand (operands[1], E_V4SFmode)
                  || !
#line 10375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
                return -1;
              return 5141; /* sse2_cvtps2pd */

            default:
              return -1;
            }

        case 8:
          x7 = XVECEXP (x5, 0, 0);
          if (GET_CODE (x7) != CONST_INT)
            return -1;
          x8 = XVECEXP (x5, 0, 1);
          if (GET_CODE (x8) != CONST_INT
              || pattern918 (x5) != 0)
            return -1;
          switch (pattern1130 (x5))
            {
            case 0:
              if (pattern1539 (x5) != 0
                  || pattern917 (x3, 
E_V16SFmode, 
E_V8SFmode, 
E_V8DFmode) != 0
                  || !
#line 10235 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
                return -1;
              return 5098; /* vec_unpacks_lo_v16sf */

            case 1:
              x9 = XVECEXP (x5, 0, 2);
              if (XWINT (x9, 0) != 4L)
                return -1;
              x10 = XVECEXP (x5, 0, 3);
              if (XWINT (x10, 0) != 6L)
                return -1;
              x11 = XVECEXP (x5, 0, 4);
              if (XWINT (x11, 0) != 8L)
                return -1;
              x12 = XVECEXP (x5, 0, 5);
              if (XWINT (x12, 0) != 10L)
                return -1;
              x13 = XVECEXP (x5, 0, 6);
              if (XWINT (x13, 0) != 12L)
                return -1;
              x14 = XVECEXP (x5, 0, 7);
              if (XWINT (x14, 0) != 14L)
                return -1;
              switch (pattern1741 (x3))
                {
                case 0:
                  if (!
#line 31925 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10359; /* vcvtneeph2ps_v16hf */

                case 1:
                  if (!
#line 31925 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10360; /* vcvtneebf162ps_v16bf */

                default:
                  return -1;
                }

            case 2:
              x11 = XVECEXP (x5, 0, 4);
              if (XWINT (x11, 0) != 9L)
                return -1;
              x12 = XVECEXP (x5, 0, 5);
              if (XWINT (x12, 0) != 11L)
                return -1;
              x13 = XVECEXP (x5, 0, 6);
              if (XWINT (x13, 0) != 13L)
                return -1;
              x14 = XVECEXP (x5, 0, 7);
              if (XWINT (x14, 0) != 15L)
                return -1;
              switch (pattern1741 (x3))
                {
                case 0:
                  if (!
#line 31953 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10363; /* vcvtneoph2ps_v16hf */

                case 1:
                  if (!
#line 31953 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVXNECONVERT))
                    return -1;
                  return 10364; /* vcvtneobf162ps_v16bf */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_328 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          switch (pattern519 (x3))
            {
            case 0:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4408; /* avx512fp16_vcvtw2ph_v8hi */

            case 1:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4432; /* avx512fp16_vcvtdq2ph_v8si */

            case 2:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4448; /* avx512fp16_vcvtqq2ph_v8di */

            default:
              return -1;
            }

        case E_V16HFmode:
          switch (pattern520 (x3))
            {
            case 0:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4416; /* avx512fp16_vcvtw2ph_v16hi */

            case 1:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4440; /* avx512fp16_vcvtdq2ph_v16si */

            default:
              return -1;
            }

        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x3) != E_V32HFmode
              || !vector_operand (operands[1], E_V32HImode)
              || !(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4424; /* avx512fp16_vcvtw2ph_v32hi */

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x3) != E_V16SFmode
              || !vector_operand (operands[1], E_V16SImode)
              || !(
#line 8628 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1) && 
#line 433 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 4744; /* floatv16siv16sf2 */

        case E_V8SFmode:
          if (!register_operand (operands[0], E_V8SFmode)
              || GET_MODE (x3) != E_V8SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!vector_operand (operands[1], E_V8SImode)
                  || !(
#line 8628 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1) && 
#line 433 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 4748; /* floatv8siv8sf2 */

            case E_V8DImode:
              if (!nonimmediate_operand (operands[1], E_V8DImode)
                  || !(
#line 9175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4900; /* floatv8div8sf2 */

            default:
              return -1;
            }

        case E_V4SFmode:
          if (!register_operand (operands[0], E_V4SFmode)
              || GET_MODE (x3) != E_V4SFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!vector_operand (operands[1], E_V4SImode)
                  || !
#line 8628 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1 && 1))
                return -1;
              return 4750; /* floatv4siv4sf2 */

            case E_V4DImode:
              if (!nonimmediate_operand (operands[1], E_V4DImode)
                  || !(
#line 9175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4908; /* floatv4div4sf2 */

            default:
              return -1;
            }

        case E_V2DFmode:
          switch (pattern521 (x3))
            {
            case 0:
              if (!
#line 8857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                return -1;
              return 4824; /* sse2_cvtpi2pd */

            case 1:
              if (!(
#line 9161 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4892; /* floatv2div2df2 */

            default:
              return -1;
            }

        case E_V8DFmode:
          switch (pattern522 (x3, 
E_V8DFmode))
            {
            case 0:
              if (!(
#line 9151 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1) && 
#line 467 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 4872; /* floatv8siv8df2 */

            case 1:
              if (!(
#line 9161 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4876; /* floatv8div8df2 */

            default:
              return -1;
            }

        case E_V4DFmode:
          switch (pattern523 (x3, 
E_V4DFmode))
            {
            case 0:
              if (!
#line 9151 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && 1))
                return -1;
              return 4874; /* floatv4siv4df2 */

            case 1:
              if (!(
#line 9161 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4884; /* floatv4div4df2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != PARALLEL)
        return -1;
      x6 = XEXP (x4, 0);
      operands[1] = x6;
      switch (XVECLEN (x5, 0))
        {
        case 8:
          if (pattern669 (x5) != 0
              || pattern917 (x3, 
E_V16SImode, 
E_V8SImode, 
E_V8DFmode) != 0
              || !
#line 9352 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 4924; /* avx512f_cvtdq2pd512_2 */

        case 4:
          if (pattern670 (x5, 
3, 
2, 
1) != 0
              || pattern917 (x3, 
E_V8SImode, 
E_V4SImode, 
E_V4DFmode) != 0
              || !
#line 9365 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 4925; /* avx_cvtdq2pd256_2 */

        case 2:
          x7 = XVECEXP (x5, 0, 0);
          if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x8 = XVECEXP (x5, 0, 1);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
              || pattern917 (x3, 
E_V4SImode, 
E_V2SImode, 
E_V2DFmode) != 0
              || !
#line 9377 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && 1))
            return -1;
          return 4926; /* sse2_cvtdq2pd */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_333 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          switch (pattern519 (x3))
            {
            case 0:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4412; /* avx512fp16_vcvtuw2ph_v8hi */

            case 1:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4436; /* avx512fp16_vcvtudq2ph_v8si */

            case 2:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4452; /* avx512fp16_vcvtuqq2ph_v8di */

            default:
              return -1;
            }

        case E_V16HFmode:
          switch (pattern520 (x3))
            {
            case 0:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4420; /* avx512fp16_vcvtuw2ph_v16hi */

            case 1:
              if (!(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4444; /* avx512fp16_vcvtudq2ph_v16si */

            default:
              return -1;
            }

        case E_V32HFmode:
          if (!register_operand (operands[0], E_V32HFmode)
              || GET_MODE (x3) != E_V32HFmode
              || !vector_operand (operands[1], E_V32HImode)
              || !(
#line 7650 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4428; /* avx512fp16_vcvtuw2ph_v32hi */

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x3) != E_V16SFmode
              || !nonimmediate_operand (operands[1], E_V16SImode)
              || !(
#line 8641 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4752; /* *floatunsv16siv16sf2 */

        case E_V8SFmode:
          switch (pattern522 (x3, 
E_V8SFmode))
            {
            case 0:
              if (!(
#line 8641 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4756; /* *floatunsv8siv8sf2 */

            case 1:
              if (!(
#line 9175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4904; /* floatunsv8div8sf2 */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern523 (x3, 
E_V4SFmode))
            {
            case 0:
              if (!(
#line 8641 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4760; /* *floatunsv4siv4sf2 */

            case 1:
              if (!(
#line 9175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4910; /* floatunsv4div4sf2 */

            default:
              return -1;
            }

        case E_V2DFmode:
          switch (pattern521 (x3))
            {
            case 0:
              if (!
#line 8877 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_MMX_WITH_SSE && TARGET_AVX512VL))
                return -1;
              return 4825; /* floatunsv2siv2df2 */

            case 1:
              if (!(
#line 9161 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4896; /* floatunsv2div2df2 */

            default:
              return -1;
            }

        case E_V8DFmode:
          if (!register_operand (operands[0], E_V8DFmode)
              || GET_MODE (x3) != E_V8DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8DImode:
              if (!nonimmediate_operand (operands[1], E_V8DImode)
                  || !(
#line 9161 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4880; /* floatunsv8div8df2 */

            case E_V8SImode:
              if (!nonimmediate_operand (operands[1], E_V8SImode)
                  || !(
#line 9325 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 4918; /* floatunsv8siv8df2 */

            default:
              return -1;
            }

        case E_V4DFmode:
          if (!register_operand (operands[0], E_V4DFmode)
              || GET_MODE (x3) != E_V4DFmode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4DImode:
              if (!nonimmediate_operand (operands[1], E_V4DImode)
                  || !(
#line 9161 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4888; /* floatunsv4div4df2 */

            case E_V4SImode:
              if (!nonimmediate_operand (operands[1], E_V4SImode)
                  || !(
#line 9325 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 4920; /* floatunsv4siv4df2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      if (GET_MODE (x4) != E_V2SImode)
        return -1;
      x5 = XEXP (x4, 1);
      if (GET_CODE (x5) != PARALLEL
          || XVECLEN (x5, 0) != 2)
        return -1;
      x6 = XVECEXP (x5, 0, 0);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XVECEXP (x5, 0, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || !register_operand (operands[0], E_V2DFmode)
          || GET_MODE (x3) != E_V2DFmode)
        return -1;
      x8 = XEXP (x4, 0);
      operands[1] = x8;
      if (!nonimmediate_operand (operands[1], E_V4SImode)
          || !
#line 9337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
        return -1;
      return 4922; /* *floatunsv2siv2df2 */

    default:
      return -1;
    }
}

 int
recog_341 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern28 (x1))
    {
    case 0:
      if (!(
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4546; /* avx512fp16_fixuns_truncv8hi2 */

    case 1:
      if (!(
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 4554; /* avx512fp16_fixuns_truncv16hi2 */

    case 2:
      if (!(
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4562; /* avx512fp16_fixuns_truncv32hi2 */

    case 3:
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4570; /* avx512fp16_fixuns_truncv8si2 */

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !
#line 9557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
            return -1;
          return 4961; /* fixuns_truncv8dfv8si2 */

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !(
#line 9900 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 440 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5062; /* *fixuns_truncv8sfv8si2 */

        default:
          return -1;
        }

    case 4:
      if (!(
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4578; /* avx512fp16_fixuns_truncv16si2 */

    case 5:
      if (!
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 4812; /* fixuns_truncv16sfv16si2 */

    case 6:
      if (!(
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4586; /* avx512fp16_fixuns_truncv8di2 */

    case 7:
      if (!(
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 4998; /* fixuns_truncv8dfv8di2 */

    case 8:
      if (!(
#line 9729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 5042; /* fixuns_truncv8sfv8di2 */

    case 9:
      switch (GET_MODE (operands[1]))
        {
        case E_V4HFmode:
          if (!memory_operand (operands[1], E_V4HFmode)
              || !
#line 7919 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
            return -1;
          return 4608; /* *avx512fp16_fixuns_truncv4si2_load */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !
#line 9665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512F))
            return -1;
          return 4976; /* fixuns_truncv4dfv4si2 */

        case E_V4SFmode:
          if (!nonimmediate_operand (operands[1], E_V4SFmode)
              || !
#line 9900 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))
            return -1;
          return 5064; /* *fixuns_truncv4sfv4si2 */

        default:
          return -1;
        }

    case 10:
      if (!
#line 7919 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4612; /* *avx512fp16_fixuns_truncv4di2_load */

    case 11:
      if (!(
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5004; /* fixuns_truncv4dfv4di2 */

    case 12:
      if (!(
#line 9729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5048; /* fixuns_truncv4sfv4di2 */

    case 13:
      if (!
#line 7969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4624; /* *avx512fp16_fixuns_truncv2di2_load */

    case 14:
      if (!(
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 5008; /* fixuns_truncv2dfv2di2 */

    case 15:
      if (!
#line 7909 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4600; /* avx512fp16_fixuns_truncv4si2 */

    case 16:
      if (!
#line 7909 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4604; /* avx512fp16_fixuns_truncv4di2 */

    case 17:
      if (!
#line 7959 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL))
        return -1;
      return 4620; /* avx512fp16_fixuns_truncv2di2 */

    case 18:
      if (!
#line 9752 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL))
        return -1;
      return 5056; /* avx512dq_fixuns_truncv2sfv2di2 */

    default:
      return -1;
    }
}

 int
recog_346 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x3) != E_V16SImode
          || !nonimmediate_operand (operands[1], E_V16SImode)
          || !(
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9988; /* clzv16si2 */

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode)
          || GET_MODE (x3) != E_V8SImode
          || !nonimmediate_operand (operands[1], E_V8SImode)
          || !(
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9990; /* clzv8si2 */

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode)
          || GET_MODE (x3) != E_V4SImode
          || !nonimmediate_operand (operands[1], E_V4SImode)
          || !(
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9992; /* clzv4si2 */

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode)
          || GET_MODE (x3) != E_V8DImode
          || !nonimmediate_operand (operands[1], E_V8DImode)
          || !(
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 9994; /* clzv8di2 */

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode)
          || GET_MODE (x3) != E_V4DImode
          || !nonimmediate_operand (operands[1], E_V4DImode)
          || !(
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9996; /* clzv4di2 */

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode)
          || GET_MODE (x3) != E_V2DImode
          || !nonimmediate_operand (operands[1], E_V2DImode)
          || !(
#line 30177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512CD) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 9998; /* clzv2di2 */

    default:
      return -1;
    }
}

 int
recog_349 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (pattern32 (x1))
    {
    case 0:
      if (!
#line 17539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && TARGET_64BIT
   && ix86_pre_reload_split ()))
        return -1;
      return 7625; /* *rotlv1ti3_internal */

    case 1:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7661; /* avx512f_rolv16si */

    case 2:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7665; /* avx512vl_rolv8si */

    case 3:
      if (const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7669; /* avx512vl_rolv4si */
      if (!const_0_to_31_operand (operands[2], E_SImode)
          || !
#line 26840 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8963; /* xop_rotlv4si3 */

    case 4:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7673; /* avx512f_rolv8di */

    case 5:
      if (!(
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7677; /* avx512vl_rolv4di */

    case 6:
      if (const_0_to_255_operand (operands[2], E_SImode)
          && (
#line 17635 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7681; /* avx512vl_rolv2di */
      if (!const_0_to_63_operand (operands[2], E_SImode)
          || !
#line 26840 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8964; /* xop_rotlv2di3 */

    case 7:
      if (!
#line 26840 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8961; /* xop_rotlv16qi3 */

    case 8:
      if (!
#line 26840 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_XOP))
        return -1;
      return 8962; /* xop_rotlv8hi3 */

    case 9:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7637; /* avx512f_rolvv16si */

    case 10:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7641; /* avx512vl_rolvv8si */

    case 11:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7645; /* avx512vl_rolvv4si */

    case 12:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
        return -1;
      return 7649; /* avx512f_rolvv8di */

    case 13:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7653; /* avx512vl_rolvv4di */

    case 14:
      if (!(
#line 17625 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return -1;
      return 7657; /* avx512vl_rolvv2di */

    default:
      return -1;
    }
}

 int
recog_360 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (XINT (x3, 1))
    {
    case 39:
      if (GET_MODE (x3) != E_CCGZmode)
        return -1;
      x4 = XVECEXP (x3, 0, 2);
      if (GET_CODE (x4) != LTU)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != REG
          || REGNO (x5) != 17
          || GET_MODE (x5) != E_CCmode)
        return -1;
      x6 = XEXP (x4, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x7 = XEXP (x2, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17
          || GET_MODE (x7) != E_CCGZmode)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != CLOBBER)
        return -1;
      x9 = XVECEXP (x3, 0, 0);
      operands[1] = x9;
      x10 = XVECEXP (x3, 0, 1);
      operands[2] = x10;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      switch (GET_MODE (operands[1]))
        {
        case E_SImode:
          if (pattern1658 (x4, 
E_SImode) != 0
              || !
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          return 521; /* subsi3_carry_ccgz */

        case E_DImode:
          if (pattern1658 (x4, 
E_DImode) != 0
              || !
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 522; /* subdi3_carry_ccgz */

        default:
          return -1;
        }

    case 22:
      x4 = XVECEXP (x3, 0, 2);
      if (GET_CODE (x4) != REG
          || REGNO (x4) != 7
          || pattern550 (x1) != 0)
        return -1;
      x9 = XVECEXP (x3, 0, 0);
      operands[1] = x9;
      if (!tls_symbolic_operand (operands[1], E_VOIDmode))
        return -1;
      x10 = XVECEXP (x3, 0, 1);
      operands[2] = x10;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern1542 (x3, 
E_SImode) != 0
              || !(
#line 23386 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
            return -1;
          return 1669; /* *tls_dynamic_gnu2_call_64_si */

        case E_DImode:
          if (pattern1542 (x3, 
E_DImode) != 0
              || !(
#line 23386 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
            return -1;
          return 1670; /* *tls_dynamic_gnu2_call_64_di */

        default:
          return -1;
        }

    case 52:
      if (GET_MODE (x3) != E_V8QImode)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != CLOBBER)
        return -1;
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      if (pattern925 (x1) != 0
          || !
#line 23153 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
        return -1;
      return 8557; /* *ssse3_pshufbv8qi3 */

    case 132:
      if (pattern553 (x1, 
132, 
3) != 0)
        return -1;
      x9 = XVECEXP (x3, 0, 0);
      operands[1] = x9;
      if (!register_operand (operands[1], E_V16QImode))
        return -1;
      x10 = XVECEXP (x3, 0, 1);
      operands[2] = x10;
      if (!nonimmediate_operand (operands[2], E_V16QImode))
        return -1;
      x4 = XVECEXP (x3, 0, 2);
      operands[3] = x4;
      if (!const_0_to_255_operand (operands[3], E_SImode))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      x12 = XEXP (x8, 1);
      x13 = XVECEXP (x12, 0, 0);
      if (!rtx_equal_p (x13, operands[1]))
        return -1;
      x14 = XVECEXP (x12, 0, 1);
      if (!rtx_equal_p (x14, operands[2]))
        return -1;
      x15 = XVECEXP (x12, 0, 2);
      if (!rtx_equal_p (x15, operands[3]))
        return -1;
      switch (pattern1756 (x3))
        {
        case 0:
          if (!
#line 26268 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
            return -1;
          return 8911; /* sse4_2_pcmpistri */

        case 1:
          if (!
#line 26292 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
            return -1;
          return 8912; /* sse4_2_pcmpistrm */

        default:
          return -1;
        }

    case 153:
      x4 = XVECEXP (x3, 0, 2);
      if (GET_CODE (x4) != MEM)
        return -1;
      x5 = XEXP (x4, 0);
      if (GET_CODE (x5) != UNSPEC
          || XVECLEN (x5, 0) != 3
          || XINT (x5, 1) != 154)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != CLOBBER)
        return -1;
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      x16 = XVECEXP (x5, 0, 2);
      if (!const1248_operand (x16, E_SImode))
        return -1;
      x9 = XVECEXP (x3, 0, 0);
      switch (GET_CODE (x9))
        {
        case REG:
        case SUBREG:
          operands[1] = x9;
          x10 = XVECEXP (x3, 0, 1);
          operands[7] = x10;
          operands[6] = x4;
          x17 = XVECEXP (x5, 0, 0);
          operands[4] = x17;
          x18 = XVECEXP (x5, 0, 1);
          operands[3] = x18;
          operands[5] = x16;
          x11 = XEXP (x8, 0);
          operands[2] = x11;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              if (!register_operand (operands[0], E_V16SImode)
                  || GET_MODE (x3) != E_V16SImode
                  || !vsib_mem_operator (operands[6], E_SImode))
                return -1;
              switch (GET_MODE (operands[1]))
                {
                case E_V16SImode:
                  if (!register_operand (operands[1], E_V16SImode))
                    return -1;
                  switch (pattern1808 (x5, 
E_HImode, 
E_V16SImode))
                    {
                    case 0:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9670; /* *avx512f_gathersiv16si */

                    case 1:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9682; /* *avx512f_gathersiv16si */

                    default:
                      return -1;
                    }

                case E_V8SImode:
                  if (!register_operand (operands[1], E_V8SImode))
                    return -1;
                  switch (pattern1808 (x5, 
E_QImode, 
E_V8DImode))
                    {
                    case 0:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9718; /* *avx512f_gatherdiv16si */

                    case 1:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9730; /* *avx512f_gatherdiv16si */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case E_V16SFmode:
              if (!register_operand (operands[0], E_V16SFmode)
                  || GET_MODE (x3) != E_V16SFmode
                  || !vsib_mem_operator (operands[6], E_SFmode))
                return -1;
              switch (GET_MODE (operands[1]))
                {
                case E_V16SFmode:
                  if (!register_operand (operands[1], E_V16SFmode))
                    return -1;
                  switch (pattern1808 (x5, 
E_HImode, 
E_V16SImode))
                    {
                    case 0:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9671; /* *avx512f_gathersiv16sf */

                    case 1:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9683; /* *avx512f_gathersiv16sf */

                    default:
                      return -1;
                    }

                case E_V8SFmode:
                  if (!register_operand (operands[1], E_V8SFmode))
                    return -1;
                  switch (pattern1808 (x5, 
E_QImode, 
E_V8DImode))
                    {
                    case 0:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9719; /* *avx512f_gatherdiv16sf */

                    case 1:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9731; /* *avx512f_gatherdiv16sf */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case E_V8DImode:
              switch (pattern1729 (x3, 
E_DImode, 
E_V8DImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9672; /* *avx512f_gathersiv8di */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9720; /* *avx512f_gatherdiv8di */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9684; /* *avx512f_gathersiv8di */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9732; /* *avx512f_gatherdiv8di */

                default:
                  return -1;
                }

            case E_V8DFmode:
              switch (pattern1729 (x3, 
E_DFmode, 
E_V8DFmode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9673; /* *avx512f_gathersiv8df */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9721; /* *avx512f_gatherdiv8df */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9685; /* *avx512f_gathersiv8df */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9733; /* *avx512f_gatherdiv8df */

                default:
                  return -1;
                }

            case E_V8SImode:
              if (pattern1730 (x3, 
E_SImode, 
E_V8SImode) != 0)
                return -1;
              switch (GET_MODE (operands[1]))
                {
                case E_V8SImode:
                  if (!register_operand (operands[1], E_V8SImode))
                    return -1;
                  switch (pattern1817 (x5, 
E_V8SImode))
                    {
                    case 0:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9674; /* *avx512f_gathersiv8si */

                    case 1:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9686; /* *avx512f_gathersiv8si */

                    default:
                      return -1;
                    }

                case E_V4SImode:
                  if (!register_operand (operands[1], E_V4SImode))
                    return -1;
                  switch (pattern1817 (x5, 
E_V4DImode))
                    {
                    case 0:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9722; /* *avx512f_gatherdiv8si */

                    case 1:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9734; /* *avx512f_gatherdiv8si */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case E_V8SFmode:
              if (pattern1730 (x3, 
E_SFmode, 
E_V8SFmode) != 0)
                return -1;
              switch (GET_MODE (operands[1]))
                {
                case E_V8SFmode:
                  if (!register_operand (operands[1], E_V8SFmode))
                    return -1;
                  switch (pattern1817 (x5, 
E_V8SImode))
                    {
                    case 0:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9675; /* *avx512f_gathersiv8sf */

                    case 1:
                      if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9687; /* *avx512f_gathersiv8sf */

                    default:
                      return -1;
                    }

                case E_V4SFmode:
                  if (!register_operand (operands[1], E_V4SFmode))
                    return -1;
                  switch (pattern1817 (x5, 
E_V4DImode))
                    {
                    case 0:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                        return -1;
                      return 9723; /* *avx512f_gatherdiv8sf */

                    case 1:
                      if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                        return -1;
                      return 9735; /* *avx512f_gatherdiv8sf */

                    default:
                      return -1;
                    }

                default:
                  return -1;
                }

            case E_V4DImode:
              switch (pattern1732 (x3, 
E_DImode, 
E_V4DImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9676; /* *avx512f_gathersiv4di */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9724; /* *avx512f_gatherdiv4di */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9688; /* *avx512f_gathersiv4di */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9736; /* *avx512f_gatherdiv4di */

                default:
                  return -1;
                }

            case E_V4DFmode:
              switch (pattern1732 (x3, 
E_DFmode, 
E_V4DFmode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9677; /* *avx512f_gathersiv4df */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9725; /* *avx512f_gatherdiv4df */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9689; /* *avx512f_gathersiv4df */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9737; /* *avx512f_gatherdiv4df */

                default:
                  return -1;
                }

            case E_V4SImode:
              switch (pattern1734 (x3, 
E_SImode, 
E_V4SImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9678; /* *avx512f_gathersiv4si */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9726; /* *avx512f_gatherdiv4si */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9690; /* *avx512f_gathersiv4si */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9738; /* *avx512f_gatherdiv4si */

                default:
                  return -1;
                }

            case E_V4SFmode:
              switch (pattern1734 (x3, 
E_SFmode, 
E_V4SFmode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9679; /* *avx512f_gathersiv4sf */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9727; /* *avx512f_gatherdiv4sf */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9691; /* *avx512f_gathersiv4sf */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9739; /* *avx512f_gatherdiv4sf */

                default:
                  return -1;
                }

            case E_V2DImode:
              switch (pattern1734 (x3, 
E_DImode, 
E_V2DImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9680; /* *avx512f_gathersiv2di */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9728; /* *avx512f_gatherdiv2di */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9692; /* *avx512f_gathersiv2di */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9740; /* *avx512f_gatherdiv2di */

                default:
                  return -1;
                }

            case E_V2DFmode:
              switch (pattern1734 (x3, 
E_DFmode, 
E_V2DFmode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9681; /* *avx512f_gathersiv2df */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9729; /* *avx512f_gatherdiv2df */

                case 2:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9693; /* *avx512f_gathersiv2df */

                case 3:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9741; /* *avx512f_gatherdiv2df */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case PC:
          x10 = XVECEXP (x3, 0, 1);
          operands[6] = x10;
          operands[5] = x4;
          x17 = XVECEXP (x5, 0, 0);
          operands[3] = x17;
          x18 = XVECEXP (x5, 0, 1);
          operands[2] = x18;
          operands[4] = x16;
          x11 = XEXP (x8, 0);
          operands[1] = x11;
          switch (GET_MODE (operands[0]))
            {
            case E_V16SImode:
              switch (pattern1702 (x3, 
E_SImode, 
E_V16SImode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9694; /* *avx512f_gathersiv16si_2 */

                case 1:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9706; /* *avx512f_gathersiv16si_2 */

                case 2:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9742; /* *avx512f_gatherdiv16si_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9754; /* *avx512f_gatherdiv16si_2 */

                default:
                  return -1;
                }

            case E_V16SFmode:
              switch (pattern1702 (x3, 
E_SFmode, 
E_V16SFmode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9695; /* *avx512f_gathersiv16sf_2 */

                case 1:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9707; /* *avx512f_gathersiv16sf_2 */

                case 2:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9743; /* *avx512f_gatherdiv16sf_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9755; /* *avx512f_gatherdiv16sf_2 */

                default:
                  return -1;
                }

            case E_V8DImode:
              switch (pattern1704 (x3, 
E_DImode, 
E_V8DImode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9696; /* *avx512f_gathersiv8di_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9744; /* *avx512f_gatherdiv8di_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9708; /* *avx512f_gathersiv8di_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9756; /* *avx512f_gatherdiv8di_2 */

                default:
                  return -1;
                }

            case E_V8DFmode:
              switch (pattern1704 (x3, 
E_DFmode, 
E_V8DFmode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9697; /* *avx512f_gathersiv8df_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9745; /* *avx512f_gatherdiv8df_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9709; /* *avx512f_gathersiv8df_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9757; /* *avx512f_gatherdiv8df_2 */

                default:
                  return -1;
                }

            case E_V8SImode:
              switch (pattern1706 (x3, 
E_SImode, 
E_V8SImode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9698; /* *avx512f_gathersiv8si_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9746; /* *avx512f_gatherdiv8si_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9710; /* *avx512f_gathersiv8si_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9758; /* *avx512f_gatherdiv8si_2 */

                default:
                  return -1;
                }

            case E_V8SFmode:
              switch (pattern1706 (x3, 
E_SFmode, 
E_V8SFmode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9699; /* *avx512f_gathersiv8sf_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9747; /* *avx512f_gatherdiv8sf_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9711; /* *avx512f_gathersiv8sf_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9759; /* *avx512f_gatherdiv8sf_2 */

                default:
                  return -1;
                }

            case E_V4DImode:
              switch (pattern1708 (x3, 
E_DImode, 
E_V4DImode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9700; /* *avx512f_gathersiv4di_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9748; /* *avx512f_gatherdiv4di_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9712; /* *avx512f_gathersiv4di_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9760; /* *avx512f_gatherdiv4di_2 */

                default:
                  return -1;
                }

            case E_V4DFmode:
              switch (pattern1708 (x3, 
E_DFmode, 
E_V4DFmode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9701; /* *avx512f_gathersiv4df_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9749; /* *avx512f_gatherdiv4df_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9713; /* *avx512f_gathersiv4df_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9761; /* *avx512f_gatherdiv4df_2 */

                default:
                  return -1;
                }

            case E_V4SImode:
              switch (pattern1710 (x3, 
E_SImode, 
E_V4SImode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9702; /* *avx512f_gathersiv4si_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9750; /* *avx512f_gatherdiv4si_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9714; /* *avx512f_gathersiv4si_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9762; /* *avx512f_gatherdiv4si_2 */

                default:
                  return -1;
                }

            case E_V4SFmode:
              switch (pattern1710 (x3, 
E_SFmode, 
E_V4SFmode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9703; /* *avx512f_gathersiv4sf_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9751; /* *avx512f_gatherdiv4sf_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9715; /* *avx512f_gathersiv4sf_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9763; /* *avx512f_gatherdiv4sf_2 */

                default:
                  return -1;
                }

            case E_V2DImode:
              switch (pattern1710 (x3, 
E_DImode, 
E_V2DImode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9704; /* *avx512f_gathersiv2di_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9752; /* *avx512f_gatherdiv2di_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9716; /* *avx512f_gathersiv2di_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9764; /* *avx512f_gatherdiv2di_2 */

                default:
                  return -1;
                }

            case E_V2DFmode:
              switch (pattern1710 (x3, 
E_DFmode, 
E_V2DFmode))
                {
                case 0:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9705; /* *avx512f_gathersiv2df_2 */

                case 1:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  return 9753; /* *avx512f_gatherdiv2df_2 */

                case 2:
                  if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9717; /* *avx512f_gathersiv2df_2 */

                case 3:
                  if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  return 9765; /* *avx512f_gatherdiv2df_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_402 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  switch (pattern201 (x1))
    {
    case 0:
      x2 = XVECEXP (x1, 0, 0);
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      switch (pattern700 (x1))
        {
        case 0:
          if ((
#line 16596 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 1122; /* *lshrdi3_doubleword_mask */
          break;

        case 1:
          if ((
#line 16596 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1124; /* *lshrti3_doubleword_mask */
          break;

        case 2:
          if ((
#line 2271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
            return 2602; /* klshiftrtqi */
          break;

        case 3:
          if (
#line 2271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return 2604; /* klshiftrthi */
          break;

        case 4:
          if ((
#line 2271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2606; /* klshiftrtsi */
          break;

        case 5:
          if ((
#line 2271 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2073 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return 2608; /* klshiftrtdi */
          break;

        default:
          break;
        }
      x4 = XEXP (x2, 1);
      x5 = XEXP (x4, 1);
      operands[2] = x5;
      switch (pattern701 (x1))
        {
        case 0:
          operands[0] = x3;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (register_operand (operands[0], E_DImode)
                  && GET_MODE (x4) == E_DImode
                  && register_operand (operands[1], E_DImode)
                  && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return 1130; /* lshrdi3_doubleword */
              break;

            case E_TImode:
              if (register_operand (operands[0], E_TImode)
                  && GET_MODE (x4) == E_TImode
                  && register_operand (operands[1], E_TImode)
                  && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return 1132; /* lshrti3_doubleword */
              break;

            case E_SImode:
              if (nonimmediate_operand (operands[0], E_SImode)
                  && GET_MODE (x4) == E_SImode
                  && nonimmediate_operand (operands[1], E_SImode)
                  && 
#line 17399 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands, TARGET_APX_NDD)
   && true))
                return 1181; /* *lshrsi3_1 */
              break;

            case E_QImode:
              if (nonimmediate_operand (operands[0], E_QImode)
                  && GET_MODE (x4) == E_QImode
                  && nonimmediate_operand (operands[1], E_QImode)
                  && 
#line 17575 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, QImode, operands, TARGET_APX_NDD)
   && true))
                return 1213; /* *lshrqi3_1 */
              break;

            case E_HImode:
              if (nonimmediate_operand (operands[0], E_HImode)
                  && GET_MODE (x4) == E_HImode
                  && nonimmediate_operand (operands[1], E_HImode)
                  && 
#line 17613 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, HImode, operands, TARGET_APX_NDD)
   && true))
                return 1215; /* *lshrhi3_1 */
              break;

            case E_V2QImode:
              if (register_operand (operands[0], E_V2QImode)
                  && GET_MODE (x4) == E_V2QImode
                  && register_operand (operands[1], E_V2QImode)
                  && 
#line 4012 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size))
                return 2215; /* lshrv2qi3 */
              break;

            default:
              break;
            }
          break;

        case 1:
          x6 = XEXP (x3, 0);
          operands[0] = x6;
          switch (pattern376 (x4))
            {
            case 0:
              if (
#line 17652 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 1216; /* *lshrqi3_1_slp */
              break;

            case 1:
              if (
#line 17652 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return 1218; /* *lshrhi3_1_slp */
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      x7 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x7) != CLOBBER)
        return -1;
      x8 = XEXP (x7, 0);
      if (GET_CODE (x8) != REG
          || REGNO (x8) != 17
          || GET_MODE (x8) != E_CCmode)
        return -1;
      switch (GET_CODE (x5))
        {
        case CONST_INT:
          if (pattern1151 (x2) == 0
              && GET_MODE (x4) == E_DImode
              && nonimmediate_operand (operands[1], E_DImode)
              && 
#line 17375 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 1179; /* *highpartdisi2 */
          break;

        case SUBREG:
          switch (pattern1154 (x2, 
E_SImode))
            {
            case 0:
              if (
#line 17854 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()))
                return 1245; /* *lshrsi3_mask */
              break;

            case 1:
              if (
#line 17902 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1257; /* *lshrsi3_add */
              break;

            case 2:
              if (
#line 17948 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1269; /* *lshrsi3_sub */
              break;

            default:
              break;
            }
          break;

        default:
          break;
        }
      operands[0] = x3;
      if (!nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x4) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      operands[2] = x5;
      if (nonmemory_operand (operands[2], E_QImode)
          && (
#line 17399 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1183; /* *lshrdi3_1 */
      if (GET_CODE (x5) != SUBREG
          || maybe_ne (SUBREG_BYTE (x5), 0)
          || GET_MODE (x5) != E_QImode)
        return -1;
      x9 = XEXP (x5, 0);
      switch (pattern1152 (x9))
        {
        case 0:
          if (!(
#line 17854 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1248; /* *lshrdi3_mask */

        case 1:
          if (!(
#line 17902 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1260; /* *lshrdi3_add */

        case 2:
          if (!(
#line 17948 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1272; /* *lshrdi3_sub */

        default:
          return -1;
        }

    case 1:
      if (register_operand (operands[0], E_DImode)
          && register_operand (operands[1], E_DImode)
          && (
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (4 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 4 * BITS_PER_UNIT - 1))
	 == (2 * 4 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
        return 1126; /* *lshrdi3_doubleword_mask_1 */
      if (!nonimmediate_operand (operands[0], E_DImode)
          || !nonimmediate_operand (operands[1], E_DImode)
          || !(
#line 17879 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1))
      == 8 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1254; /* *lshrdi3_mask_1 */

    case 2:
      if (!(
#line 16657 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(((INTVAL (operands[3]) & (8 * BITS_PER_UNIT)) == 0
    || ((INTVAL (operands[3]) & (2 * 8 * BITS_PER_UNIT - 1))
	 == (2 * 8 * BITS_PER_UNIT - 1)))
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1128; /* *lshrti3_doubleword_mask_1 */

    case 3:
      if (!
#line 17879 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1))
      == 4 * BITS_PER_UNIT - 1
   && ix86_pre_reload_split ()))
        return -1;
      return 1251; /* *lshrsi3_mask_1 */

    case 4:
      if (!
#line 17926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      return 1263; /* *lshrsi3_add_1 */

    case 5:
      if (!(
#line 17926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1266; /* *lshrdi3_add_1 */

    case 6:
      if (!
#line 17978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
        return -1;
      return 1275; /* *lshrsi3_sub_1 */

    case 7:
      if (!(
#line 17978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (LSHIFTRT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      return 1278; /* *lshrdi3_sub_1 */

    default:
      return -1;
    }
}

 int
recog_419 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != MEM
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x2, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 0);
  switch (GET_CODE (x6))
    {
    case SUBREG:
    case MEM:
      operands[1] = x6;
      if (!memory_operand (operands[1], E_SImode)
          || pattern385 (x1) != 0)
        return -1;
      x7 = XEXP (x3, 1);
      operands[2] = x7;
      x8 = XVECEXP (x1, 0, 1);
      x9 = XEXP (x8, 1);
      x10 = XEXP (x9, 1);
      operands[3] = x10;
      if (!immediate_operand (operands[3], E_SImode)
          || !
#line 20488 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && !TARGET_INDIRECT_BRANCH_REGISTER))
        return -1;
      return 1485; /* *sibcall_value_pop_memory */

    case SYMBOL_REF:
      if (!constant_call_address_operand (x6, E_VOIDmode))
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != UNSPEC)
        return -1;
      x11 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x11) != CLOBBER)
        return -1;
      switch (pattern1159 (x8))
        {
        case 0:
          operands[2] = x6;
          x7 = XEXP (x3, 1);
          operands[3] = x7;
          x12 = XVECEXP (x8, 0, 0);
          operands[1] = x12;
          if (!tls_symbolic_operand (operands[1], E_VOIDmode))
            return -1;
          x13 = XEXP (x11, 0);
          operands[4] = x13;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern1713 (x1, 
E_SImode) != 0
                  || !(
#line 23009 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1650; /* *tls_global_dynamic_64_si */

            case E_DImode:
              if (pattern1713 (x1, 
E_DImode) != 0
                  || !(
#line 23009 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1651; /* *tls_global_dynamic_64_di */

            default:
              return -1;
            }

        case 1:
          operands[1] = x6;
          x7 = XEXP (x3, 1);
          operands[2] = x7;
          x13 = XEXP (x11, 0);
          operands[3] = x13;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pattern1644 (x1, 
E_SImode) != 0
                  || !(
#line 23127 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 1654; /* *tls_local_dynamic_base_64_si */

            case E_DImode:
              if (pattern1644 (x1, 
E_DImode) != 0
                  || !(
#line 23127 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 1655; /* *tls_local_dynamic_base_64_di */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      if (GET_MODE (x6) != E_DImode)
        return -1;
      x8 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x8) != UNSPEC)
        return -1;
      x11 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x11) != CLOBBER
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      x14 = XEXP (x6, 0);
      if (!register_operand (x14, E_DImode))
        return -1;
      x15 = XEXP (x6, 1);
      if (!immediate_operand (x15, E_DImode)
          || GET_MODE (x8) != E_DImode)
        return -1;
      x13 = XEXP (x11, 0);
      if (!register_operand (x13, E_DImode))
        return -1;
      switch (pattern1159 (x8))
        {
        case 0:
          x16 = XVECEXP (x8, 0, 1);
          if (GET_MODE (x16) != E_DImode)
            return -1;
          operands[2] = x14;
          operands[3] = x15;
          x7 = XEXP (x3, 1);
          operands[4] = x7;
          x12 = XVECEXP (x8, 0, 0);
          operands[1] = x12;
          if (!tls_symbolic_operand (operands[1], E_VOIDmode))
            return -1;
          operands[5] = x13;
          if (!
#line 23051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_cmodel == CM_LARGE_PIC && !TARGET_PECOFF
   && GET_CODE (operands[3]) == CONST
   && GET_CODE (XEXP (operands[3], 0)) == UNSPEC
   && XINT (XEXP (operands[3], 0), 1) == UNSPEC_PLTOFF))
            return -1;
          return 1652; /* *tls_global_dynamic_64_largepic */

        case 1:
          x12 = XVECEXP (x8, 0, 0);
          if (GET_MODE (x12) != E_DImode)
            return -1;
          operands[1] = x14;
          operands[2] = x15;
          x7 = XEXP (x3, 1);
          operands[3] = x7;
          operands[4] = x13;
          if (!
#line 23148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_cmodel == CM_LARGE_PIC && !TARGET_PECOFF
   && GET_CODE (operands[2]) == CONST
   && GET_CODE (XEXP (operands[2], 0)) == UNSPEC
   && XINT (XEXP (operands[2], 0), 1) == UNSPEC_PLTOFF))
            return -1;
          return 1656; /* *tls_local_dynamic_base_64_largepic */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_424 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XVECEXP (x1, 0, 3);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XEXP (x2, 1);
  switch (GET_CODE (x4))
    {
    case UNSIGNED_FIX:
      switch (pattern387 (x1))
        {
        case 0:
          if (!
#line 5923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_SSE_MATH
   && optimize_function_for_speed_p (cfun)))
            return -1;
          return 223; /* *fixuns_truncsf_1 */

        case 1:
          if (!
#line 5923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_SSE_MATH
   && optimize_function_for_speed_p (cfun)))
            return -1;
          return 224; /* *fixuns_truncdf_1 */

        default:
          return -1;
        }

    case FIX:
      if (GET_MODE (x4) != E_DImode)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != USE)
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x6) != USE)
        return -1;
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x8 = XEXP (x4, 0);
      operands[1] = x8;
      if (!register_operand (operands[1], E_VOIDmode))
        return -1;
      x9 = XEXP (x5, 0);
      operands[2] = x9;
      if (!memory_operand (operands[2], E_HImode))
        return -1;
      x10 = XEXP (x6, 0);
      operands[3] = x10;
      if (!memory_operand (operands[3], E_HImode))
        return -1;
      x11 = XEXP (x3, 0);
      operands[4] = x11;
      if (!scratch_operand (operands[4], E_XFmode)
          || !
#line 6033 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(TARGET_64BIT && SSE_FLOAT_MODE_P (GET_MODE (operands[1])))))
        return -1;
      return 235; /* fix_truncdi_i387 */

    case FLOAT:
      switch (pattern389 (x1))
        {
        case 0:
          if (!
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (SFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          return 254; /* floatdisf2_i387_with_xmm */

        case 1:
          if (!
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (DFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          return 255; /* floatdidf2_i387_with_xmm */

        case 2:
          if (!
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (XFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          return 256; /* floatdixf2_i387_with_xmm */

        default:
          return -1;
        }

    case DIV:
      switch (pattern394 (x1, 
MOD))
        {
        case 0:
          return 639; /* divmodsi4_1 */

        case 1:
          if (!
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 640; /* divmoddi4_1 */

        case 2:
          if (!
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH))
            return -1;
          return 667; /* *divmodhi4_noext */

        case 3:
          return 669; /* *divmodsi4_noext */

        case 4:
          if (!
#line 1192 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 671; /* *divmoddi4_noext */

        default:
          return -1;
        }

    case UDIV:
      switch (pattern394 (x1, 
UMOD))
        {
        case 0:
          return 641; /* udivmodsi4_1 */

        case 1:
          if (!
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 642; /* udivmoddi4_1 */

        case 2:
          if (!
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH))
            return -1;
          return 668; /* *udivmodhi4_noext */

        case 3:
          return 670; /* *udivmodsi4_noext */

        case 4:
          if (!
#line 1192 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 672; /* *udivmoddi4_noext */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      if (GET_MODE (x4) != E_DImode)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != SET)
        return -1;
      x11 = XEXP (x3, 0);
      if (GET_CODE (x11) != REG
          || REGNO (x11) != 17
          || GET_MODE (x11) != E_CCmode)
        return -1;
      switch (pattern1047 (x1))
        {
        case 0:
          switch (pattern1486 (x1, 
MOD))
            {
            case 0:
              if (!
#line 11497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 643; /* divmodsi4_zext_1 */

            case 1:
              if (!
#line 11892 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 673; /* *divmodsi4_noext_zext_1 */

            default:
              return -1;
            }

        case 1:
          switch (pattern1486 (x1, 
UMOD))
            {
            case 0:
              if (!
#line 11533 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 644; /* udivmodsi4_zext_1 */

            case 1:
              if (!
#line 11892 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 674; /* *udivmodsi4_noext_zext_1 */

            default:
              return -1;
            }

        case 2:
          switch (pattern1487 (x1, 
DIV))
            {
            case 0:
              if (!
#line 11556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 645; /* divmodsi4_zext_2 */

            case 1:
              if (!
#line 11906 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 675; /* *divmodsi4_noext_zext_2 */

            default:
              return -1;
            }

        case 3:
          switch (pattern1487 (x1, 
UDIV))
            {
            case 0:
              if (!
#line 11593 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 646; /* udivmodsi4_zext_2 */

            case 1:
              if (!
#line 11906 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 676; /* *udivmodsi4_noext_zext_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC:
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      switch (XVECLEN (x4, 0))
        {
        case 4:
          if (XINT (x4, 1) != 20
              || pattern812 (x4) != 0
              || pattern1233 (x1) != 0
              || !tls_symbolic_operand (operands[2], E_VOIDmode))
            return -1;
          x12 = XVECEXP (x4, 0, 2);
          operands[3] = x12;
          if (!constant_call_address_operand (operands[3], E_VOIDmode))
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          x9 = XEXP (x5, 0);
          operands[4] = x9;
          if (!scratch_operand (operands[4], E_SImode))
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          x10 = XEXP (x6, 0);
          operands[5] = x10;
          if (!scratch_operand (operands[5], E_SImode)
              || !
#line 22965 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_GNU_TLS))
            return -1;
          return 1649; /* *tls_global_dynamic_32_gnu */

        case 3:
          if (XINT (x4, 1) != 21
              || GET_MODE (x4) != E_SImode)
            return -1;
          x12 = XVECEXP (x4, 0, 2);
          if (GET_CODE (x12) != REG
              || REGNO (x12) != 7
              || GET_MODE (x12) != E_SImode
              || pattern1233 (x1) != 0
              || !constant_call_address_operand (operands[2], E_VOIDmode))
            return -1;
          x5 = XVECEXP (x1, 0, 1);
          x9 = XEXP (x5, 0);
          operands[3] = x9;
          if (!scratch_operand (operands[3], E_SImode))
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          x10 = XEXP (x6, 0);
          operands[4] = x10;
          if (!scratch_operand (operands[4], E_SImode)
              || !
#line 23088 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_GNU_TLS))
            return -1;
          return 1653; /* *tls_local_dynamic_base_32_gnu */

        case 1:
          x5 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x5) != USE)
            return -1;
          x6 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x6) != USE
              || !nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x4) != E_DImode)
            return -1;
          x13 = XVECEXP (x4, 0, 0);
          operands[1] = x13;
          if (!register_operand (operands[1], E_XFmode))
            return -1;
          x9 = XEXP (x5, 0);
          operands[2] = x9;
          if (!memory_operand (operands[2], E_HImode))
            return -1;
          x10 = XEXP (x6, 0);
          operands[3] = x10;
          if (!memory_operand (operands[3], E_HImode))
            return -1;
          x11 = XEXP (x3, 0);
          operands[4] = x11;
          if (!scratch_operand (operands[4], E_XFmode))
            return -1;
          switch (XINT (x4, 1))
            {
            case 78:
              if (!
#line 25394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1750; /* fistdi2_floor */

            case 79:
              if (!
#line 25394 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations))
                return -1;
              return 1751; /* fistdi2_ceil */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PLUS:
      if (pattern395 (x1) != 0)
        return -1;
      return 1657; /* *tls_local_dynamic_32_once */

    case UNSPEC_VOLATILE:
      if (XVECLEN (x4, 0) != 1
          || XINT (x4, 1) != 3)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern712 (x5, 
7, 
MINUS) != 0)
        return -1;
      x6 = XVECEXP (x1, 0, 2);
      if (pattern942 (x6, 
E_CCmode, 
17) != 0)
        return -1;
      x11 = XEXP (x3, 0);
      if (GET_CODE (x11) != MEM
          || GET_MODE (x11) != E_BLKmode)
        return -1;
      x14 = XEXP (x11, 0);
      if (GET_CODE (x14) != SCRATCH)
        return -1;
      x7 = XEXP (x2, 0);
      operands[0] = x7;
      x13 = XVECEXP (x4, 0, 0);
      operands[1] = x13;
      x15 = XEXP (x5, 1);
      x16 = XEXP (x15, 1);
      operands[2] = x16;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern1762 (x1, 
E_SImode) != 0
              || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))
            return -1;
          return 1863; /* adjust_stack_and_probe_si */

        case E_DImode:
          if (pattern1762 (x1, 
E_DImode) != 0
              || !
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))
            return -1;
          return 1864; /* adjust_stack_and_probe_di */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 rtx_insn *
split_6 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case AND:
      switch (pattern70 (x3))
        {
        case 0:
          if (!(
#line 3716 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == -1
   && CONST_WIDE_INT_ELT (operands[3], 1) == 0) && 
#line 3722 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_28 (insn, operands);

        case 1:
          if (!(
#line 3738 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && CONST_WIDE_INT_P (operands[3])
   && CONST_WIDE_INT_NUNITS (operands[3]) == 2
   && CONST_WIDE_INT_ELT (operands[3], 0) == 0
   && CONST_WIDE_INT_ELT (operands[3], 1) == -1) && 
#line 3744 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_31 (insn, operands);

        case 2:
          if (!(
#line 3760 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && CONST_INT_P (operands[3])
   && UINTVAL (operands[3]) == 0xffffffff00000000ll) && 
#line 3764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_34 (insn, operands);

        default:
          return NULL;
        }

    case REG:
    case SUBREG:
      operands[1] = x4;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (pattern826 (x3, 
E_QImode) != 0
              || !
#line 7107 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_135 (insn, operands);

        case E_HImode:
          if (pattern826 (x3, 
E_HImode) != 0
              || !
#line 7107 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_136 (insn, operands);

        case E_SImode:
          if (pattern827 (x3, 
E_SImode) != 0
              || !
#line 7107 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_137 (insn, operands);

        case E_DImode:
          if (pattern827 (x3, 
E_DImode) != 0
              || !(
#line 7107 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF && reload_completed
   && ix86_lea_for_add_ok (insn, operands)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_138 (insn, operands);

        default:
          return NULL;
        }

    case PLUS:
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          switch (pattern432 (x3))
            {
            case 0:
              if (!(
#line 7910 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7912 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_156 (insn, operands);

            case 1:
              if (!(
#line 7910 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7912 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_157 (insn, operands);

            default:
              return NULL;
            }

        case MULT:
          switch (pattern435 (x3))
            {
            case 0:
              if (!(
#line 7976 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_162 (insn, operands);

            case 1:
              if (!(
#line 7976 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7978 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_163 (insn, operands);

            default:
              return NULL;
            }

        case ASHIFT:
          switch (pattern577 (x3))
            {
            case 0:
              if (!(
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_164 (insn, operands);

            case 1:
              if (!(
#line 8002 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 8004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_165 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case MULT:
      switch (pattern399 (x3))
        {
        case 0:
          if (!(
#line 7932 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7934 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_158 (insn, operands);

        case 1:
          if (!(
#line 7932 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7934 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_159 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      x7 = XEXP (x4, 1);
      operands[2] = x7;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
          operands[1] = x6;
          x5 = XEXP (x3, 1);
          switch (GET_CODE (x5))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
            case CONST_POLY_INT:
            case CONST_FIXED:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case CONST:
            case REG:
            case SUBREG:
            case LABEL_REF:
            case SYMBOL_REF:
            case HIGH:
              operands[3] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_QImode:
                  if (pattern1067 (x3, 
E_QImode) != 0
                      || !(
#line 7953 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7955 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_160 (insn, operands);

                case E_HImode:
                  if (pattern1067 (x3, 
E_HImode) != 0
                      || !(
#line 7953 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 7955 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_161 (insn, operands);

                case E_DImode:
                  if (pattern604 (x3, 
E_DImode) != 0
                      || !((
#line 14151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT / 2
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14165 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_472 (insn, operands);

                case E_TImode:
                  if (pattern604 (x3, 
E_TImode) != 0
                      || !((
#line 14151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 16 * BITS_PER_UNIT / 2
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1196 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14165 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_475 (insn, operands);

                default:
                  return NULL;
                }

            case ZERO_EXTEND:
              switch (pattern944 (x3))
                {
                case 0:
                  if (!((
#line 14074 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14076 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_436 (insn, operands);

                case 1:
                  if (!((
#line 14074 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14076 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_439 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case SIGN_EXTEND:
          switch (pattern715 (x3))
            {
            case 0:
              if (!((
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14112 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_448 (insn, operands);

            case 1:
              if (!((
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14112 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_454 (insn, operands);

            case 2:
              if (!((
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14197 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_478 (insn, operands);

            case 3:
              if (!((
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14197 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_484 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          switch (pattern715 (x3))
            {
            case 0:
              if (!((
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14112 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_451 (insn, operands);

            case 1:
              if (!((
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14112 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_457 (insn, operands);

            case 2:
              if (!((
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14197 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_481 (insn, operands);

            case 3:
              if (!((
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT
   && (TImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14197 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_487 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case ZERO_EXTEND:
      switch (pattern404 (x3))
        {
        case 0:
          if (!((
#line 14091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14093 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_442 (insn, operands);

        case 1:
          if (!((
#line 14091 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14093 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_445 (insn, operands);

        case 2:
          if (!((
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14137 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_460 (insn, operands);

        case 3:
          if (!((
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14137 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_466 (insn, operands);

        case 4:
          if (!((
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14137 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_463 (insn, operands);

        case 5:
          if (!((
#line 14135 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14137 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_469 (insn, operands);

        case 6:
          if (!((
#line 14212 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(DImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14223 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_490 (insn, operands);

        case 7:
          if (!((
#line 14212 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TImode == DImode
   ? CONST_INT_P (operands[2])
     && (UINTVAL (operands[2]) & GET_MODE_MASK (SImode)) == 0
     && !ix86_endbr_immediate_operand (operands[2], VOIDmode)
   : CONST_WIDE_INT_P (operands[2])
     && CONST_WIDE_INT_NUNITS (operands[2]) == 2
     && CONST_WIDE_INT_ELT (operands[2], 0) == 0
     && !ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[2],
								    1)),
				       VOIDmode)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14223 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_493 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_20 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x5;
      switch (pattern1167 (x3))
        {
        case 0:
          if ((
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_295 (insn, operands);
          break;

        case 1:
          if ((
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12759 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])
	|| rtx_equal_p (operands[0], operands[2])))))
            return gen_split_298 (insn, operands);
          break;

        case 2:
          if (nonimmediate_operand (operands[0], E_DImode)
              && nonimmediate_operand (operands[1], E_DImode))
            {
              if (x86_64_hilo_general_operand (operands[2], E_DImode)
                  && ((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 13543 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_394 (insn, operands);
              if (const_int_operand (operands[2], E_DImode)
                  && (
#line 13669 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (XOR, DImode, operands)
   && IN_RANGE (exact_log2 (INTVAL (operands[2])), 31, 63)) && 
#line 13673 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return gen_split_401 (insn, operands);
            }
          if (const_int_operand (operands[2], E_DImode))
            {
              if (QIreg_operand (operands[0], E_DImode)
                  && register_operand (operands[1], E_DImode)
                  && (
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_429 (insn, operands);
              if (any_QIreg_operand (operands[0], E_DImode)
                  && general_operand (operands[1], E_DImode)
                  && (
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_435 (insn, operands);
            }
          break;

        case 3:
          if (((
#line 13541 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13543 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return gen_split_396 (insn, operands);
          break;

        case 4:
          if (QIreg_operand (operands[0], E_HImode)
              && register_operand (operands[1], E_HImode)
              && 
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_425 (insn, operands);
          if (any_QIreg_operand (operands[0], E_HImode)
              && general_operand (operands[1], E_HImode)
              && 
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_431 (insn, operands);
          break;

        case 5:
          if (QIreg_operand (operands[0], E_SImode)
              && register_operand (operands[1], E_SImode)
              && 
#line 13966 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~(255 << 8))
    && !(TARGET_APX_NDD && REGNO (operands[0]) != REGNO (operands[1]))))
            return gen_split_427 (insn, operands);
          if (any_QIreg_operand (operands[0], E_SImode)
              && general_operand (operands[1], E_SImode)
              && 
#line 14004 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed
    && (!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
    && !(INTVAL (operands[2]) & ~255)
    && (INTVAL (operands[2]) & 128)
    && !(TARGET_APX_NDD
	 && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_433 (insn, operands);
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || pattern1166 (x4) != 0)
        return NULL;
      x6 = XEXP (x5, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      switch (pattern1667 (x3))
        {
        case 0:
          if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_301 (insn, operands);
          break;

        case 1:
          if ((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_304 (insn, operands);
          break;

        case 2:
          if (((
#line 12782 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !rtx_equal_p (operands[0], operands[1]))))
            return gen_split_307 (insn, operands);
          break;

        default:
          break;
        }
      operands[1] = x7;
      switch (pattern1668 (x3))
        {
        case 0:
          if (!(
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_310 (insn, operands);

        case 1:
          if (!(
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_313 (insn, operands);

        case 2:
          if (!((
#line 12815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 12817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_316 (insn, operands);

        case 3:
          if (!
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_330 (insn, operands);

        case 4:
          if (!
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed))
            return NULL;
          return gen_split_333 (insn, operands);

        case 5:
          if (!(
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 13058 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_336 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != IOR)
        return NULL;
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      x7 = XEXP (x6, 0);
      operands[1] = x7;
      x9 = XEXP (x6, 1);
      operands[2] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern1227 (x4, 
E_SImode) != 0)
            return NULL;
          x10 = XEXP (x4, 1);
          operands[3] = x10;
          if (nonimmediate_operand (operands[3], E_SImode))
            {
              if (nonimmediate_operand (operands[2], E_SImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[1])
                      && 
#line 13450 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                    return gen_split_385 (insn, operands);
                }
              if (register_operand (operands[2], E_SImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[2])
                      && 
#line 13469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
                    return gen_split_387 (insn, operands);
                }
            }
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          if (!nonimmediate_operand (operands[3], E_SImode))
            return NULL;
          if (nonimmediate_operand (operands[2], E_SImode)
              && rtx_equal_p (x10, operands[1])
              && 
#line 13488 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return gen_split_389 (insn, operands);
          if (!register_operand (operands[2], E_SImode)
              || !rtx_equal_p (x10, operands[2])
              || !
#line 13507 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return NULL;
          return gen_split_391 (insn, operands);

        case E_DImode:
          if (pattern1227 (x4, 
E_DImode) != 0)
            return NULL;
          x10 = XEXP (x4, 1);
          operands[3] = x10;
          if (nonimmediate_operand (operands[3], E_DImode))
            {
              if (nonimmediate_operand (operands[2], E_DImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[1])
                      && (
#line 13450 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return gen_split_386 (insn, operands);
                }
              if (register_operand (operands[2], E_DImode))
                {
                  x11 = XEXP (x5, 1);
                  if (rtx_equal_p (x11, operands[2])
                      && (
#line 13469 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return gen_split_388 (insn, operands);
                }
            }
          x11 = XEXP (x5, 1);
          operands[3] = x11;
          if (!nonimmediate_operand (operands[3], E_DImode))
            return NULL;
          if (nonimmediate_operand (operands[2], E_DImode)
              && rtx_equal_p (x10, operands[1])
              && (
#line 13488 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return gen_split_390 (insn, operands);
          if (!register_operand (operands[2], E_DImode)
              || !rtx_equal_p (x10, operands[2])
              || !(
#line 13507 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_392 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != XOR)
        return NULL;
      switch (pattern1042 (x3))
        {
        case 0:
          if (!(
#line 13698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 13700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_402 (insn, operands);

        case 1:
          if (!(
#line 13698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 13700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_403 (insn, operands);

        case 2:
          if (!((
#line 13698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI && ix86_pre_reload_split ()) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 13700 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_404 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      switch (pattern1051 (x3, 
1))
        {
        case 0:
          if (!(
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18861 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_803 (insn, operands);

        case 1:
          if (!((
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18861 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_805 (insn, operands);

        case 2:
          if (!(
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()) && 
#line 18889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_807 (insn, operands);

        case 3:
          if (!((
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 18889 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_809 (insn, operands);

        default:
          return NULL;
        }

    case SIGN_EXTEND:
      if (GET_MODE (x5) != E_DImode)
        return NULL;
      x6 = XEXP (x5, 0);
      if (GET_CODE (x6) != MINUS
          || GET_MODE (x6) != E_SImode)
        return NULL;
      x7 = XEXP (x6, 0);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return NULL;
      x9 = XEXP (x6, 1);
      if (GET_CODE (x9) != SUBREG
          || maybe_ne (SUBREG_BYTE (x9), 0)
          || GET_MODE (x9) != E_SImode)
        return NULL;
      x12 = XEXP (x9, 0);
      if (GET_CODE (x12) != CLZ
          || GET_MODE (x12) != E_DImode)
        return NULL;
      x10 = XEXP (x4, 1);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 63])
        return NULL;
      x8 = XEXP (x3, 0);
      operands[0] = x8;
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x4) != E_DImode)
        return NULL;
      x13 = XEXP (x12, 0);
      operands[1] = x13;
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !(
#line 21341 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_LZCNT && TARGET_64BIT && ix86_pre_reload_split ()) && 
#line 21343 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
        return NULL;
      return gen_split_884 (insn, operands);

    case PLUS:
      x11 = XEXP (x5, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
        return NULL;
      switch (pattern941 (x3))
        {
        case 0:
          if (!
#line 21897 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
            return NULL;
          return gen_split_908 (insn, operands);

        case 1:
          if (!(
#line 21897 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVOID_FALSE_DEP_FOR_BLS
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return NULL;
          return gen_split_909 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_30 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (pattern340 (x1) != 0)
    return NULL;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      switch (pattern1138 (x3))
        {
        case 0:
          if (!(
#line 4851 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 4853 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_63 (insn, operands);

        case 1:
          if (!(
#line 4851 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 4853 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_64 (insn, operands);

        case 2:
          if (!(
#line 4905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)) && 
#line 4907 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_65 (insn, operands);

        default:
          return NULL;
        }

    case PLUS:
      if (GET_MODE (x4) != E_SImode
          || !register_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return NULL;
      x5 = XEXP (x4, 0);
      switch (GET_CODE (x5))
        {
        case REG:
        case SUBREG:
          operands[1] = x5;
          if (!register_operand (operands[1], E_SImode))
            return NULL;
          x6 = XEXP (x4, 1);
          operands[2] = x6;
          if (!x86_64_nonmemory_operand (operands[2], E_SImode))
            return NULL;
          if (
#line 7077 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && reload_completed && ix86_avoid_lea_for_add (insn, operands)))
            return gen_split_130 (insn, operands);
          if (!
#line 7127 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed && ix86_lea_for_add_ok (insn, operands)))
            return NULL;
          return gen_split_139 (insn, operands);

        case UNSPEC:
          if (pattern1141 (x5) != 0)
            return NULL;
          x6 = XEXP (x4, 1);
          operands[1] = x6;
          if (!register_operand (operands[1], E_SImode)
              || !(
#line 23269 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_X32) && 
#line 23271 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_928 (insn, operands);

        default:
          return NULL;
        }

    case ASHIFT:
      if (GET_MODE (x4) != E_SImode
          || GET_MODE (x3) != E_DImode)
        return NULL;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      x6 = XEXP (x4, 1);
      operands[2] = x6;
      switch (GET_CODE (operands[2]))
        {
        case REG:
        case SUBREG:
          if (!register_operand (operands[2], E_QImode)
              || !register_operand (operands[0], E_DImode)
              || !nonimmediate_operand (operands[1], E_SImode)
              || !
#line 16100 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed))
            return NULL;
          return gen_split_580 (insn, operands);

        case CONST_INT:
          if (!const_0_to_3_operand (operands[2], E_VOIDmode)
              || !general_reg_operand (operands[0], E_DImode)
              || !index_reg_operand (operands[1], E_SImode)
              || !
#line 16335 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && reload_completed
   && REGNO (operands[0]) != REGNO (operands[1])))
            return NULL;
          return gen_split_591 (insn, operands);

        default:
          return NULL;
        }

    case LSHIFTRT:
      if (pattern1162 (x3) != 0
          || !
#line 17536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed))
        return NULL;
      return gen_split_632 (insn, operands);

    case ASHIFTRT:
      if (pattern1162 (x3) != 0
          || !
#line 17536 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed))
        return NULL;
      return gen_split_633 (insn, operands);

    case ROTATE:
      if (pattern1163 (x3) != 0
          || !
#line 18666 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed
   && !optimize_function_for_size_p (cfun)))
        return NULL;
      return gen_split_794 (insn, operands);

    case ROTATERT:
      if (pattern1163 (x3) != 0
          || !
#line 18682 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_BMI2 && reload_completed
   && !optimize_function_for_size_p (cfun)))
        return NULL;
      return gen_split_795 (insn, operands);

    case CTZ:
      if (pattern1164 (x3, 
E_SImode, 
E_DImode) != 0
          || !
#line 21203 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_BMI || TARGET_CPU_P (GENERIC))
   && (TARGET_AVOID_FALSE_DEP_FOR_BMI || TARGET_AVOID_FALSE_DEP_FOR_TZCNT)
   && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1])))
        return NULL;
      return gen_split_883 (insn, operands);

    case CLZ:
      if (pattern1164 (x3, 
E_SImode, 
E_DImode) != 0
          || !(
#line 21628 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT && TARGET_64BIT) && 
#line 21630 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
        return NULL;
      return gen_split_895 (insn, operands);

    case POPCOUNT:
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pattern348 (x3, 
E_SImode, 
E_DImode) != 0
              || !(
#line 22465 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT && TARGET_64BIT) && 
#line 22473 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( TARGET_AVOID_FALSE_DEP_FOR_BMI && epilogue_completed
   && optimize_function_for_speed_p (cfun)
   && !reg_mentioned_p (operands[0], operands[1]))))
            return NULL;
          return gen_split_919 (insn, operands);

        case E_SImode:
          if (pattern348 (x3, 
E_HImode, 
E_SImode) != 0
              || !(
#line 22531 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_POPCNT
   && ix86_pre_reload_split ()) && 
#line 22534 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_921 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_37 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case LSHIFTRT:
      if (GET_MODE (x5) != E_SImode)
        return NULL;
      x6 = XVECEXP (x1, 0, 1);
      if (pattern231 (x6, 
E_CCmode, 
17) != 0
          || !mask_reg_operand (operands[0], E_DImode)
          || GET_MODE (x4) != E_DImode)
        return NULL;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      if (!mask_reg_operand (operands[1], E_SImode))
        return NULL;
      x8 = XEXP (x5, 1);
      operands[2] = x8;
      if (!const_0_to_31_operand (operands[2], E_VOIDmode)
          || !
#line 2323 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && reload_completed))
        return NULL;
      return gen_split_1238 (insn, operands);

    case UNSPEC:
      if (pattern352 (x1) != 0)
        return NULL;
      switch (pattern1034 (x1))
        {
        case 0:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1350 (insn, operands);

        case 1:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1371 (insn, operands);

        case 2:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1377 (insn, operands);

        case 3:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1413 (insn, operands);

        case 4:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1422 (insn, operands);

        case 5:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1353 (insn, operands);

        case 6:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1356 (insn, operands);

        case 7:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1359 (insn, operands);

        case 8:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1362 (insn, operands);

        case 9:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1365 (insn, operands);

        case 10:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1374 (insn, operands);

        case 11:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1380 (insn, operands);

        case 12:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1383 (insn, operands);

        case 13:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1386 (insn, operands);

        case 14:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1389 (insn, operands);

        case 15:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1392 (insn, operands);

        case 16:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1425 (insn, operands);

        case 17:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1368 (insn, operands);

        case 18:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1416 (insn, operands);

        case 19:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1419 (insn, operands);

        case 20:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (HImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1410 (insn, operands);

        case 21:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1351 (insn, operands);

        case 22:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1372 (insn, operands);

        case 23:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1378 (insn, operands);

        case 24:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1414 (insn, operands);

        case 25:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1423 (insn, operands);

        case 26:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1354 (insn, operands);

        case 27:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1357 (insn, operands);

        case 28:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1360 (insn, operands);

        case 29:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1363 (insn, operands);

        case 30:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1366 (insn, operands);

        case 31:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1375 (insn, operands);

        case 32:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1381 (insn, operands);

        case 33:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1384 (insn, operands);

        case 34:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1387 (insn, operands);

        case 35:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1390 (insn, operands);

        case 36:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1393 (insn, operands);

        case 37:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1426 (insn, operands);

        case 38:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1369 (insn, operands);

        case 39:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1417 (insn, operands);

        case 40:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1420 (insn, operands);

        case 41:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1411 (insn, operands);

        case 42:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1352 (insn, operands);

        case 43:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1373 (insn, operands);

        case 44:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1379 (insn, operands);

        case 45:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1415 (insn, operands);

        case 46:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1424 (insn, operands);

        case 47:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1355 (insn, operands);

        case 48:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1358 (insn, operands);

        case 49:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1361 (insn, operands);

        case 50:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1364 (insn, operands);

        case 51:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1367 (insn, operands);

        case 52:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1376 (insn, operands);

        case 53:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1382 (insn, operands);

        case 54:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1385 (insn, operands);

        case 55:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1388 (insn, operands);

        case 56:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1391 (insn, operands);

        case 57:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1394 (insn, operands);

        case 58:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1427 (insn, operands);

        case 59:
          if (!((
#line 4439 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V32HFmode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 309 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 4445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1370 (insn, operands);

        case 60:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1418 (insn, operands);

        case 61:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1421 (insn, operands);

        case 62:
          if (!((
#line 4528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
  && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))
  && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4533 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1412 (insn, operands);

        case 63:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1440 (insn, operands);

        case 64:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1443 (insn, operands);

        case 65:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1452 (insn, operands);

        case 66:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1458 (insn, operands);

        case 67:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1446 (insn, operands);

        case 68:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1449 (insn, operands);

        case 69:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1455 (insn, operands);

        case 70:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1459 (insn, operands);

        case 71:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1460 (insn, operands);

        case 72:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1461 (insn, operands);

        case 73:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1462 (insn, operands);

        case 74:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (HImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (HImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1463 (insn, operands);

        case 75:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1441 (insn, operands);

        case 76:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1444 (insn, operands);

        case 77:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1453 (insn, operands);

        case 78:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1464 (insn, operands);

        case 79:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1447 (insn, operands);

        case 80:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1450 (insn, operands);

        case 81:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1456 (insn, operands);

        case 82:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1465 (insn, operands);

        case 83:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1466 (insn, operands);

        case 84:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1467 (insn, operands);

        case 85:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1468 (insn, operands);

        case 86:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (SImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (SImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1469 (insn, operands);

        case 87:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V64QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1442 (insn, operands);

        case 88:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1445 (insn, operands);

        case 89:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V16HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1454 (insn, operands);

        case 90:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V16SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1470 (insn, operands);

        case 91:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32QImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1448 (insn, operands);

        case 92:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V32HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1451 (insn, operands);

        case 93:
          if (!((
#line 4638 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW
   && ix86_pre_reload_split ()
   && (GET_MODE_NUNITS (V8HImode)
      < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4644 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1457 (insn, operands);

        case 94:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1471 (insn, operands);

        case 95:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4SImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1472 (insn, operands);

        case 96:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V8DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1473 (insn, operands);

        case 97:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V4DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1474 (insn, operands);

        case 98:
          if (!((
#line 4728 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (!VALID_MASK_AVX512BW_MODE (DImode) || TARGET_AVX512BW)
   && (GET_MODE_NUNITS (V2DImode)
       < GET_MODE_PRECISION (DImode))
   && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)) && 
#line 4734 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1475 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_72 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern537 (x2))
        {
        case 0:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2008 (insn, operands);

        case 1:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2035 (insn, operands);

        case 2:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2062 (insn, operands);

        case 3:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2089 (insn, operands);

        case 4:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2116 (insn, operands);

        case 5:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2143 (insn, operands);

        case 6:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2170 (insn, operands);

        case 7:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2197 (insn, operands);

        case 8:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2224 (insn, operands);

        case 9:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2251 (insn, operands);

        case 10:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2278 (insn, operands);

        case 11:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2305 (insn, operands);

        case 12:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2011 (insn, operands);

        case 13:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2038 (insn, operands);

        case 14:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2065 (insn, operands);

        case 15:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2092 (insn, operands);

        case 16:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2119 (insn, operands);

        case 17:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2146 (insn, operands);

        case 18:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2173 (insn, operands);

        case 19:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2200 (insn, operands);

        case 20:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2227 (insn, operands);

        case 21:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2254 (insn, operands);

        case 22:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2281 (insn, operands);

        case 23:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2308 (insn, operands);

        case 24:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2014 (insn, operands);

        case 25:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2041 (insn, operands);

        case 26:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2068 (insn, operands);

        case 27:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2095 (insn, operands);

        case 28:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2122 (insn, operands);

        case 29:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2149 (insn, operands);

        case 30:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2176 (insn, operands);

        case 31:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2203 (insn, operands);

        case 32:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2230 (insn, operands);

        case 33:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2257 (insn, operands);

        case 34:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2284 (insn, operands);

        case 35:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2311 (insn, operands);

        case 36:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3076 (insn, operands);

        case 37:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3085 (insn, operands);

        case 38:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3094 (insn, operands);

        case 39:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3103 (insn, operands);

        case 40:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3112 (insn, operands);

        case 41:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3121 (insn, operands);

        case 42:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3130 (insn, operands);

        case 43:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3139 (insn, operands);

        case 44:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3148 (insn, operands);

        case 45:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3157 (insn, operands);

        case 46:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3166 (insn, operands);

        case 47:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3175 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern538 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2656 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2683 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2710 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2737 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2764 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2791 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2818 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2845 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2872 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2899 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2926 (insn, operands);

        case 11:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2953 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern538 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2659 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2686 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2713 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2740 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2767 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2794 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2821 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2848 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2875 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2902 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2929 (insn, operands);

        case 11:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2956 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern538 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2662 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2689 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2716 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2743 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2770 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2797 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2824 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2851 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2878 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2905 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2932 (insn, operands);

        case 11:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2959 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_81 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx_insn *res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      if (!register_operand (operands[0], E_V64QImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V64QImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 282 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1135 (insn, operands);
      if (!ternlog_operand (operands[1], E_V64QImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1641 (insn, operands);

    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V32QImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 282 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1136 (insn, operands);
      if (!ternlog_operand (operands[1], E_V32QImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1642 (insn, operands);

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V16QImode)
          && 
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return gen_split_1137 (insn, operands);
      if (!ternlog_operand (operands[1], E_V16QImode)
          || !(
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1643 (insn, operands);

    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V32HImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 283 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1138 (insn, operands);
      if (!ternlog_operand (operands[1], E_V32HImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1644 (insn, operands);

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V16HImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 283 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1139 (insn, operands);
      if (!ternlog_operand (operands[1], E_V16HImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1645 (insn, operands);

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V8HImode)
          && 
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return gen_split_1140 (insn, operands);
      if (!ternlog_operand (operands[1], E_V8HImode)
          || !(
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1646 (insn, operands);

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V16SImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 284 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1141 (insn, operands);
      if (!ternlog_operand (operands[1], E_V16SImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1647 (insn, operands);

    case E_V8SImode:
      if (!register_operand (operands[0], E_V8SImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V8SImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 284 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1142 (insn, operands);
      if (!ternlog_operand (operands[1], E_V8SImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1648 (insn, operands);

    case E_V4SImode:
      if (!register_operand (operands[0], E_V4SImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V4SImode)
          && 
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return gen_split_1143 (insn, operands);
      if (!ternlog_operand (operands[1], E_V4SImode)
          || !(
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1649 (insn, operands);

    case E_V8DImode:
      if (!register_operand (operands[0], E_V8DImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V8DImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return gen_split_1144 (insn, operands);
      if (!ternlog_operand (operands[1], E_V8DImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1650 (insn, operands);

    case E_V4DImode:
      if (!register_operand (operands[0], E_V4DImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V4DImode)
          && (
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return gen_split_1145 (insn, operands);
      if (!ternlog_operand (operands[1], E_V4DImode)
          || !((
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1651 (insn, operands);

    case E_V2DImode:
      if (!register_operand (operands[0], E_V2DImode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V2DImode)
          && 
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return gen_split_1146 (insn, operands);
      if (!ternlog_operand (operands[1], E_V2DImode)
          || !(
#line 13733 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13737 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_1652 (insn, operands);

    case E_V4TImode:
      if (!register_operand (operands[0], E_V4TImode)
          || !int_float_vector_all_ones_operand (operands[1], E_V4TImode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 286 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1147 (insn, operands);

    case E_V2TImode:
      if (!register_operand (operands[0], E_V2TImode)
          || !int_float_vector_all_ones_operand (operands[1], E_V2TImode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 286 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1148 (insn, operands);

    case E_V1TImode:
      if (!register_operand (operands[0], E_V1TImode)
          || !int_float_vector_all_ones_operand (operands[1], E_V1TImode)
          || !
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return NULL;
      return gen_split_1149 (insn, operands);

    case E_V32HFmode:
      if (!register_operand (operands[0], E_V32HFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V32HFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 287 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1150 (insn, operands);

    case E_V16HFmode:
      if (!register_operand (operands[0], E_V16HFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V16HFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 287 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1151 (insn, operands);

    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V8HFmode)
          || !
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return NULL;
      return gen_split_1152 (insn, operands);

    case E_V32BFmode:
      if (!register_operand (operands[0], E_V32BFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V32BFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 288 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1153 (insn, operands);

    case E_V16BFmode:
      if (!register_operand (operands[0], E_V16BFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V16BFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 288 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1154 (insn, operands);

    case E_V8BFmode:
      if (!register_operand (operands[0], E_V8BFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V8BFmode)
          || !
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return NULL;
      return gen_split_1155 (insn, operands);

    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V16SFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1156 (insn, operands);

    case E_V8SFmode:
      if (!register_operand (operands[0], E_V8SFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V8SFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1157 (insn, operands);

    case E_V4SFmode:
      if (!register_operand (operands[0], E_V4SFmode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V4SFmode)
          && 
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return gen_split_1158 (insn, operands);
      if (!zero_extended_scalar_load_operand (operands[1], E_V4SFmode)
          || !
#line 1916 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && reload_completed))
        return NULL;
      return gen_split_1187 (insn, operands);

    case E_V8DFmode:
      if (!register_operand (operands[0], E_V8DFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V8DFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (64 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return NULL;
      return gen_split_1159 (insn, operands);

    case E_V4DFmode:
      if (!register_operand (operands[0], E_V4DFmode)
          || !int_float_vector_all_ones_operand (operands[1], E_V4DFmode)
          || !(
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (32 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()) && 
#line 290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return NULL;
      return gen_split_1160 (insn, operands);

    case E_V2DFmode:
      if (!register_operand (operands[0], E_V2DFmode))
        return NULL;
      if (int_float_vector_all_ones_operand (operands[1], E_V2DFmode)
          && 
#line 1558 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed
  && (16 == 64 || EXT_REX_SSE_REG_P (operands[0]))
  && optimize_insn_for_speed_p ()))
        return gen_split_1161 (insn, operands);
      if (!zero_extended_scalar_load_operand (operands[1], E_V2DFmode)
          || !
#line 1930 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed))
        return NULL;
      return gen_split_1188 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_86 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  rtx_insn *res ATTRIBUTE_UNUSED;
  switch (XVECLEN (x1, 0))
    {
    case 2:
      x2 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x2) != SET)
        return NULL;
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case UNSPEC:
          x4 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x4) != CLOBBER)
            return NULL;
          x5 = XEXP (x2, 0);
          operands[0] = x5;
          switch (XVECLEN (x3, 0))
            {
            case 1:
              x6 = XVECEXP (x3, 0, 0);
              operands[1] = x6;
              switch (XINT (x3, 1))
                {
                case 74:
                  if (pattern1052 (x1) != 0
                      || !(
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()) && 
#line 25254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_933 (insn, operands);

                case 75:
                  if (pattern1052 (x1) != 0
                      || !(
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()) && 
#line 25254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_934 (insn, operands);

                case 76:
                  if (pattern1052 (x1) != 0
                      || !(
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()) && 
#line 25254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_935 (insn, operands);

                case 77:
                  if (pattern1052 (x1) != 0
                      || !(
#line 25250 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && (flag_fp_int_builtin_inexact || !flag_trapping_math)
   && ix86_pre_reload_split ()) && 
#line 25254 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                    return NULL;
                  return gen_split_936 (insn, operands);

                case 78:
                  switch (pattern1053 (x1))
                    {
                    case 0:
                      if (!(
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()) && 
#line 25371 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_937 (insn, operands);

                    case 1:
                      if (!(
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()) && 
#line 25371 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_939 (insn, operands);

                    case 2:
                      if (!(
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()) && 
#line 25371 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_941 (insn, operands);

                    default:
                      return NULL;
                    }

                case 79:
                  switch (pattern1053 (x1))
                    {
                    case 0:
                      if (!(
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()) && 
#line 25371 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_938 (insn, operands);

                    case 1:
                      if (!(
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()) && 
#line 25371 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_940 (insn, operands);

                    case 2:
                      if (!(
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()) && 
#line 25371 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                        return NULL;
                      return gen_split_942 (insn, operands);

                    default:
                      return NULL;
                    }

                case 118:
                  if (GET_MODE (x3) != E_V4SImode
                      || !register_operand (operands[0], E_V4SImode)
                      || !nonimmediate_operand (operands[1], E_DImode))
                    return NULL;
                  x7 = XEXP (x4, 0);
                  operands[2] = x7;
                  if (!scratch_operand (operands[2], E_V4SImode)
                      || !(
#line 1881 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC) && 
#line 1883 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                    return NULL;
                  return gen_split_1186 (insn, operands);

                default:
                  return NULL;
                }

            case 3:
              if (XINT (x3, 1) != 52
                  || GET_MODE (x3) != E_V8QImode
                  || pattern925 (x1) != 0
                  || !
#line 23158 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSSE3 && reload_completed
   && SSE_REGNO_P (REGNO (operands[0]))))
                return NULL;
              return gen_split_3478 (insn, operands);

            default:
              return NULL;
            }

        case SMAX:
          switch (pattern215 (x1))
            {
            case 0:
              if (((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_965 (insn, operands);
              if (!((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_985 (insn, operands);

            case 1:
              if (!((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_969 (insn, operands);

            case 2:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_973 (insn, operands);

            case 3:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_977 (insn, operands);

            case 4:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_981 (insn, operands);

            default:
              return NULL;
            }

        case SMIN:
          switch (pattern215 (x1))
            {
            case 0:
              if (((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_966 (insn, operands);
              if (!((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_986 (insn, operands);

            case 1:
              if (!((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_970 (insn, operands);

            case 2:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_974 (insn, operands);

            case 3:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_978 (insn, operands);

            case 4:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_982 (insn, operands);

            default:
              return NULL;
            }

        case UMAX:
          switch (pattern215 (x1))
            {
            case 0:
              if (((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_967 (insn, operands);
              if (!((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_987 (insn, operands);

            case 1:
              if (!((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_971 (insn, operands);

            case 2:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_975 (insn, operands);

            case 3:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_979 (insn, operands);

            case 4:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_983 (insn, operands);

            default:
              return NULL;
            }

        case UMIN:
          switch (pattern215 (x1))
            {
            case 0:
              if (((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return gen_split_968 (insn, operands);
              if (!((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_988 (insn, operands);

            case 1:
              if (!((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 26941 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_972 (insn, operands);

            case 2:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_976 (insn, operands);

            case 3:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_980 (insn, operands);

            case 4:
              if (!(
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 27000 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
                return NULL;
              return gen_split_984 (insn, operands);

            default:
              return NULL;
            }

        case PLUS:
        case MINUS:
        case MULT:
        case AND:
        case IOR:
        case XOR:
        case ASHIFT:
          return split_36 (x1, insn);

        case COMPARE:
          operands[2] = x3;
          if (!compare_operator (operands[2], E_VOIDmode))
            return NULL;
          x8 = XEXP (x3, 0);
          if (GET_CODE (x8) != AND)
            return NULL;
          x9 = XEXP (x3, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return NULL;
          x4 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x4) != SET)
            return NULL;
          x10 = XEXP (x4, 1);
          if (GET_CODE (x10) != AND)
            return NULL;
          x5 = XEXP (x2, 0);
          operands[0] = x5;
          if (!flags_reg_operand (operands[0], E_VOIDmode))
            return NULL;
          x11 = XEXP (x8, 0);
          operands[3] = x11;
          if (!aligned_operand (operands[3], E_VOIDmode))
            return NULL;
          x12 = XEXP (x8, 1);
          operands[4] = x12;
          if (!const_int_operand (operands[4], E_VOIDmode))
            return NULL;
          x7 = XEXP (x4, 0);
          operands[1] = x7;
          if (!register_operand (operands[1], E_VOIDmode))
            return NULL;
          x13 = XEXP (x10, 0);
          if (!rtx_equal_p (x13, operands[3]))
            return NULL;
          x14 = XEXP (x10, 1);
          if (!rtx_equal_p (x14, operands[4])
              || !
#line 27720 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(! TARGET_PARTIAL_REG_STALL && reload_completed
   && optimize_insn_for_speed_p ()
   && ((GET_MODE (operands[1]) == HImode && ! TARGET_FAST_PREFIX)
       || (GET_MODE (operands[1]) == QImode && TARGET_PROMOTE_QImode))
   /* Ensure that the operand will remain sign-extended immediate.  */
   && ix86_match_ccmode (insn, INTVAL (operands[4]) >= 0 ? CCNOmode : CCZmode)))
            return NULL;
          return gen_split_990 (insn, operands);

        case NEG:
          return split_38 (x1, insn);

        case ABS:
          x4 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x4) != USE)
            return NULL;
          x5 = XEXP (x2, 0);
          operands[0] = x5;
          x8 = XEXP (x3, 0);
          operands[1] = x8;
          switch (pattern831 (x1))
            {
            case 0:
              if (!(
#line 683 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1031 (insn, operands);

            case 1:
              if (!(
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2242 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1040 (insn, operands);

            case 2:
              if (!((
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)) && 
#line 2242 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1042 (insn, operands);

            case 3:
              if (!(
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2242 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1044 (insn, operands);

            case 4:
              if (!((
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2226 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)) && 
#line 2242 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
( reload_completed)))
                return NULL;
              return gen_split_1046 (insn, operands);

            case 5:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 411 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1263 (insn, operands);

            case 6:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 412 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1265 (insn, operands);

            case 7:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 412 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1267 (insn, operands);

            case 8:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 413 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1269 (insn, operands);

            case 9:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 414 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1271 (insn, operands);

            case 10:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 414 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1273 (insn, operands);

            case 11:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1275 (insn, operands);

            case 12:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1277 (insn, operands);

            case 13:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1279 (insn, operands);

            case 14:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 416 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1281 (insn, operands);

            case 15:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 417 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1283 (insn, operands);

            case 16:
              if (!((
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 417 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 2591 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1285 (insn, operands);

            default:
              return NULL;
            }

        case LSHIFTRT:
          x4 = XVECEXP (x1, 0, 1);
          if (pattern374 (x4) != 0)
            return NULL;
          x5 = XEXP (x2, 0);
          operands[0] = x5;
          x8 = XEXP (x3, 0);
          operands[1] = x8;
          x9 = XEXP (x3, 1);
          operands[2] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V2QImode:
              if (pattern1234 (x3, 
E_V2QImode) != 0
                  || !
#line 4014 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed))
                return NULL;
              return gen_split_1066 (insn, operands);

            case E_QImode:
              if (pattern1328 (x3, 
E_QImode) != 0
                  || !
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                return NULL;
              return gen_split_1231 (insn, operands);

            case E_HImode:
              if (pattern1328 (x3, 
E_HImode) != 0
                  || !
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed))
                return NULL;
              return gen_split_1233 (insn, operands);

            case E_SImode:
              if (pattern1328 (x3, 
E_SImode) != 0
                  || !(
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return NULL;
              return gen_split_1235 (insn, operands);

            case E_DImode:
              if (pattern1328 (x3, 
E_DImode) != 0
                  || !(
#line 2296 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && reload_completed) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
                return NULL;
              return gen_split_1237 (insn, operands);

            default:
              return NULL;
            }

        case ASHIFTRT:
          if (GET_MODE (x3) != E_V2QImode)
            return NULL;
          x4 = XVECEXP (x1, 0, 1);
          if (pattern353 (x4) != 0)
            return NULL;
          x5 = XEXP (x2, 0);
          operands[0] = x5;
          if (!register_operand (operands[0], E_V2QImode))
            return NULL;
          x8 = XEXP (x3, 0);
          operands[1] = x8;
          if (!register_operand (operands[1], E_V2QImode))
            return NULL;
          x9 = XEXP (x3, 1);
          operands[2] = x9;
          if (!nonmemory_operand (operands[2], E_QImode)
              || !
#line 4014 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun))
   && reload_completed))
            return NULL;
          return gen_split_1067 (insn, operands);

        case ZERO_EXTEND:
          return split_37 (x1, insn);

        case NE:
        case EQ:
          operands[1] = x3;
          switch (pattern560 (x1))
            {
            case 0:
              if (!((
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)) && 
#line 2389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1239 (insn, operands);

            case 1:
              if (!(
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 2389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1240 (insn, operands);

            case 2:
              if (!(
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 2389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1241 (insn, operands);

            case 3:
              if (!((
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)) && 
#line 2389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1242 (insn, operands);

            default:
              return NULL;
            }

        case IF_THEN_ELSE:
          x8 = XEXP (x3, 0);
          if (!bt_comparison_operator (x8, E_VOIDmode))
            return NULL;
          x12 = XEXP (x8, 1);
          if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + -1])
            return NULL;
          x4 = XVECEXP (x1, 0, 1);
          if (pattern231 (x4, 
E_CCmode, 
17) != 0)
            return NULL;
          switch (pattern1172 (x2))
            {
            case 0:
              if (!((
#line 2422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)) && 
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1243 (insn, operands);

            case 1:
              if (!(
#line 2422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1244 (insn, operands);

            case 2:
              if (!(
#line 2422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1245 (insn, operands);

            case 3:
              if (!((
#line 2422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)) && 
#line 2424 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1246 (insn, operands);

            case 4:
              if (!((
#line 2458 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)) && 
#line 2460 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1247 (insn, operands);

            case 5:
              if (!(
#line 2458 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL) && 
#line 2460 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1248 (insn, operands);

            case 6:
              if (!((
#line 2458 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW)) && 
#line 2460 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1249 (insn, operands);

            case 7:
              if (!((
#line 2458 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)) && 
#line 2460 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1250 (insn, operands);

            case 8:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1251 (insn, operands);

            case 9:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1254 (insn, operands);

            case 10:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW)) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1257 (insn, operands);

            case 11:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1260 (insn, operands);

            case 12:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1252 (insn, operands);

            case 13:
              if (!(
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1255 (insn, operands);

            case 14:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW)) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1258 (insn, operands);

            case 15:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1261 (insn, operands);

            case 16:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && ((((
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1253 (insn, operands);

            case 17:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1256 (insn, operands);

            case 18:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && ((((
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1259 (insn, operands);

            case 19:
              if (!((
#line 2501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))) && ((((
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))) && 
#line 2504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( reload_completed)))
                return NULL;
              return gen_split_1262 (insn, operands);

            default:
              return NULL;
            }

        case VEC_MERGE:
          if (pattern216 (x1) != 0
              || !
#line 8358 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2 && reload_completed
   && SSE_REG_P (operands[2])))
            return NULL;
          return gen_split_1524 (insn, operands);

        default:
          return NULL;
        }

    case 3:
      x2 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x2) != SET)
        return NULL;
      x3 = XEXP (x2, 1);
      if (GET_CODE (x3) != UNSPEC)
        return NULL;
      x5 = XEXP (x2, 0);
      operands[0] = x5;
      switch (XVECLEN (x3, 0))
        {
        case 5:
          if (pattern723 (x1, 
131, 
5) != 0
              || pattern1711 (x1) != 0
              || !(
#line 26084 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2
   && ix86_pre_reload_split ()) && 
#line 26087 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3699 (insn, operands);

        case 3:
          if (pattern723 (x1, 
132, 
3) != 0
              || pattern1712 (x1) != 0
              || !(
#line 26221 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2
   && ix86_pre_reload_split ()) && 
#line 26224 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3700 (insn, operands);

        case 1:
          x4 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x4) != CLOBBER)
            return NULL;
          x15 = XVECEXP (x1, 0, 2);
          if (GET_CODE (x15) != CLOBBER
              || GET_MODE (x3) != E_DImode)
            return NULL;
          x6 = XVECEXP (x3, 0, 0);
          operands[1] = x6;
          x7 = XEXP (x4, 0);
          operands[2] = x7;
          if (!memory_operand (operands[2], E_DImode))
            return NULL;
          x16 = XEXP (x15, 0);
          operands[3] = x16;
          if (!scratch_operand (operands[3], E_DFmode))
            return NULL;
          switch (XINT (x3, 1))
            {
            case 287:
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || !memory_operand (operands[1], E_DImode)
                  || !(
#line 196 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)) && 
#line 198 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
( reload_completed)))
                return NULL;
              return gen_split_3828 (insn, operands);

            case 288:
              if (!memory_operand (operands[0], E_DImode)
                  || !nonimmediate_operand (operands[1], E_DImode)
                  || !(
#line 295 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(!TARGET_64BIT && (TARGET_80387 || TARGET_SSE)) && 
#line 297 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
( reload_completed)))
                return NULL;
              return gen_split_3829 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_13 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 0);
  if (!general_reg_operand (x3, E_SImode))
    return NULL;
  operands[8] = x3;
  switch (pattern950 (x1, 
E_SImode, 
E_DImode))
    {
    case 0:
      if (
#line 9672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))))
        {
          *pmatch_len_ = 3;
          res = gen_peephole2_100 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    case 1:
      if (
#line 9727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (6, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && !reg_overlap_mentioned_p (operands[0], operands[10])
   && !reg_overlap_mentioned_p (operands[10], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[11])
   && !reg_overlap_mentioned_p (operands[11], operands[1])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))))
        {
          *pmatch_len_ = 5;
          res = gen_peephole2_102 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    default:
      break;
    }
  operands[0] = x3;
  if (pattern953 (x1, 
E_SImode) != 0
      || !
#line 26563 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (2, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])
  && !reg_mentioned_p (operands[2], operands[6])))
    return NULL;
  *pmatch_len_ = 3;
  return gen_peephole2_207 (insn, operands);
}

 rtx_insn *
peephole2_17 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x2) != SET)
    return NULL;
  x3 = XEXP (x2, 0);
  if (!general_reg_operand (x3, E_DImode))
    return NULL;
  operands[8] = x3;
  switch (pattern950 (x1, 
E_DImode, 
E_TImode))
    {
    case 0:
      if ((
#line 9672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (4, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 3;
          res = gen_peephole2_101 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    case 1:
      if ((
#line 9727 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && peep2_reg_dead_p (6, operands[0])
   && peep2_reg_dead_p (3, operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[2], operands[1])
   && !reg_overlap_mentioned_p (operands[6], operands[9])
   && !reg_overlap_mentioned_p (operands[0], operands[10])
   && !reg_overlap_mentioned_p (operands[10], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[11])
   && !reg_overlap_mentioned_p (operands[11], operands[1])
   && (rtx_equal_p (operands[6], operands[0])
       ? (rtx_equal_p (operands[7], operands[1])
	  && rtx_equal_p (operands[8], operands[2]))
       : (rtx_equal_p (operands[8], operands[0])
	  && rtx_equal_p (operands[9], operands[1])
	  && rtx_equal_p (operands[6], operands[2])))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        {
          *pmatch_len_ = 5;
          res = gen_peephole2_103 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    default:
      break;
    }
  operands[0] = x3;
  if (pattern953 (x1, 
E_DImode) != 0
      || !(
#line 26563 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (2, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])
  && !reg_mentioned_p (operands[2], operands[6])) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
    return NULL;
  *pmatch_len_ = 3;
  return gen_peephole2_208 (insn, operands);
}

 rtx_insn *
peephole2_20 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (!flags_reg_operand (x2, E_VOIDmode))
    return NULL;
  x3 = XEXP (x1, 1);
  operands[0] = x3;
  operands[4] = x2;
  res = peephole2_19 (x1, insn, pmatch_len_);
  if (res != NULL_RTX)
    return res;
  if (peep2_current_count < 4)
    return NULL;
  operands[6] = x2;
  x4 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 2)
    return NULL;
  x5 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x5) != SET)
    return NULL;
  x6 = XEXP (x5, 0);
  operands[7] = x6;
  if (!flags_reg_operand (operands[7], E_VOIDmode))
    return NULL;
  x7 = XEXP (x5, 1);
  operands[1] = x7;
  x8 = XVECEXP (x4, 0, 1);
  operands[5] = x8;
  x9 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x9) != SET)
    return NULL;
  x10 = XEXP (x9, 1);
  if (!ix86_comparison_operator (x10, E_QImode))
    return NULL;
  operands[3] = x10;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != REG
      || REGNO (x11) != 17)
    return NULL;
  x12 = XEXP (x10, 1);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x13 = XEXP (x9, 0);
  operands[2] = x13;
  if (!register_operand (operands[2], E_QImode))
    return NULL;
  x14 = PATTERN (peep2_next_insn (3));
  switch (GET_CODE (x14))
    {
    case SET:
      x15 = XEXP (x14, 1);
      if (GET_CODE (x15) != ZERO_EXTEND)
        return NULL;
      x16 = XEXP (x14, 0);
      operands[4] = x16;
      if (!any_QIreg_operand (operands[4], E_VOIDmode))
        return NULL;
      x17 = XEXP (x15, 0);
      if (!rtx_equal_p (x17, operands[2])
          || !
#line 20002 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((peep2_reg_dead_p (4, operands[2])
    || operands_match_p (operands[2], operands[4]))
   && ! reg_overlap_mentioned_p (operands[4], operands[0])
   && ! reg_overlap_mentioned_p (operands[4], operands[1])
   && ! reg_overlap_mentioned_p (operands[4], operands[5])
   && ! reg_set_p (operands[4], operands[5])
   && refers_to_regno_p (FLAGS_REG, operands[1], (rtx *)NULL)
   && peep2_regno_dead_p (0, FLAGS_REG)))
        return NULL;
      *pmatch_len_ = 3;
      return gen_peephole2_171 (insn, operands);

    case PARALLEL:
      if (XVECLEN (x14, 0) != 2)
        return NULL;
      x18 = XVECEXP (x14, 0, 0);
      if (GET_CODE (x18) != SET)
        return NULL;
      x19 = XEXP (x18, 1);
      if (GET_CODE (x19) != ZERO_EXTEND)
        return NULL;
      x20 = XVECEXP (x14, 0, 1);
      if (GET_CODE (x20) != CLOBBER)
        return NULL;
      x21 = XEXP (x20, 0);
      if (GET_CODE (x21) != REG
          || REGNO (x21) != 17
          || GET_MODE (x21) != E_CCmode)
        return NULL;
      x22 = XEXP (x18, 0);
      operands[4] = x22;
      if (!any_QIreg_operand (operands[4], E_VOIDmode))
        return NULL;
      x23 = XEXP (x19, 0);
      if (!rtx_equal_p (x23, operands[2])
          || !
#line 20075 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((peep2_reg_dead_p (4, operands[2])
    || operands_match_p (operands[2], operands[4]))
   && ! reg_overlap_mentioned_p (operands[4], operands[0])
   && ! reg_overlap_mentioned_p (operands[4], operands[1])
   && ! reg_overlap_mentioned_p (operands[4], operands[5])
   && ! reg_set_p (operands[4], operands[5])
   && refers_to_regno_p (FLAGS_REG, operands[1], (rtx *)NULL)
   && peep2_regno_dead_p (0, FLAGS_REG)))
        return NULL;
      *pmatch_len_ = 3;
      return gen_peephole2_174 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_24 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  if (memory_operand (operands[1], E_SImode)
      && register_operand (operands[0], E_SImode))
    {
      res = peephole2_23 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (peep2_current_count < 3
      || peep2_current_count < 4
      || !general_reg_operand (operands[1], E_SImode)
      || !general_reg_operand (operands[0], E_SImode))
    return NULL;
  x3 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 2)
    return NULL;
  x4 = XVECEXP (x3, 0, 0);
  if (GET_CODE (x4) != SET)
    return NULL;
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17)
    return NULL;
  x6 = XVECEXP (x3, 0, 1);
  if (GET_CODE (x6) != SET)
    return NULL;
  x7 = XEXP (x4, 1);
  operands[5] = x7;
  x8 = XEXP (x6, 1);
  operands[6] = x8;
  x9 = XEXP (x6, 0);
  if (!rtx_equal_p (x9, operands[0]))
    return NULL;
  x10 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x10) != SET
      || pattern1335 (x10, 
E_SImode) != 0
      || !
#line 26529 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
  && REGNO (operands[2]) != REGNO (operands[0])
  && REGNO (operands[2]) != REGNO (operands[1])
  && peep2_reg_dead_p (1, operands[1])
  && peep2_reg_dead_p (4, operands[2])
  && !reg_overlap_mentioned_p (operands[0], operands[3])))
    return NULL;
  *pmatch_len_ = 3;
  return gen_peephole2_204 (insn, operands);
}

 rtx_insn *
peephole2_26 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count >= 2)
    {
      res = peephole2_24 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  x2 = XEXP (x1, 1);
  operands[1] = x2;
  if (memory_operand (operands[1], E_SImode)
      && push_operand (operands[0], E_SImode)
      && 
#line 27818 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!(TARGET_PUSH_MEMORY || optimize_insn_for_size_p ())
   && !RTX_FRAME_RELATED_P (peep2_next_insn (0))))
    {
      *pmatch_len_ = 0;
      res = gen_peephole2_253 (insn, operands);
      if (res != NULL_RTX)
        return res;
    }
  if (peep2_current_count < 2)
    return NULL;
  if (general_reg_operand (operands[1], E_SImode))
    {
      x3 = PATTERN (peep2_next_insn (1));
      if (pattern418 (x3, 
E_SImode) == 0
          && 
#line 28018 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   && (SImode != QImode
       || any_QIreg_operand (operands[1], QImode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_281 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count >= 3)
    {
      res = peephole2_25 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
    }
  if (mmx_reg_operand (operands[1], E_VOIDmode)
      && mmx_reg_operand (operands[0], E_VOIDmode))
    {
      x3 = PATTERN (peep2_next_insn (1));
      if (pattern598 (x3) == 0
          && 
#line 28037 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_283 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (sse_reg_operand (operands[1], E_VOIDmode)
      && sse_reg_operand (operands[0], E_VOIDmode))
    {
      x3 = PATTERN (peep2_next_insn (1));
      if (pattern598 (x3) == 0
          && 
#line 28049 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(REGNO (operands[0]) != REGNO (operands[1])
   /* Punt if operands[1] is %[xy]mm16+ and AVX512BW is not enabled,
      as EVEX encoded vpadd[bw], vpmullw, vpmin[su][bw] and vpmax[su][bw]
      instructions require AVX512BW and AVX512VL, but with the original
      instructions it might require just AVX512VL.
      AVX512VL is implied from TARGET_HARD_REGNO_MODE_OK.  */
   && (!EXT_REX_SSE_REGNO_P (REGNO (operands[1]))
       || TARGET_AVX512BW
       || GET_MODE_SIZE (GET_MODE_INNER (GET_MODE (operands[0]))) > 2
       || logic_operator (operands[3], VOIDmode))))
        {
          *pmatch_len_ = 1;
          res = gen_peephole2_284 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
    }
  if (peep2_current_count >= 3
      && peep2_current_count >= 4)
    {
      if (memory_operand (operands[1], E_QImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern730 (x3, 
E_QImode) == 0
              && 
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (QImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_301 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (memory_operand (operands[1], E_HImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern730 (x3, 
E_HImode) == 0
              && 
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (HImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_302 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (memory_operand (operands[1], E_SImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern731 (x3, 
E_SImode) == 0
              && 
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (SImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_303 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
      if (memory_operand (operands[1], E_DImode))
        {
          x3 = PATTERN (peep2_next_insn (1));
          if (pattern731 (x3, 
E_DImode) == 0
              && (
#line 28174 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && REGNO (operands[4]) == REGNO (operands[0])
   && REGNO (operands[5]) == REGNO (operands[3])
   && peep2_reg_dead_p (4, operands[3])
   && ((REGNO (operands[0]) == REGNO (operands[3]))
       || peep2_reg_dead_p (2, operands[0]))
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && !reg_overlap_mentioned_p (operands[3], operands[1])
   && !reg_overlap_mentioned_p (operands[0], operands[2])
   && (DImode != QImode
       || immediate_operand (operands[2], QImode)
       || any_QIreg_operand (operands[2], QImode))
   && ix86_match_ccmode (peep2_next_insn (3), CCGOCmode)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 3;
              res = gen_peephole2_304 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
        }
    }
  if (!memory_operand (operands[1], E_VOIDmode)
      || !register_operand (operands[0], E_VOIDmode))
    return NULL;
  x3 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x3) != SET)
    return NULL;
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!memory_operand (operands[2], E_VOIDmode))
    return NULL;
  x5 = XEXP (x3, 1);
  if (!rtx_equal_p (x5, operands[0])
      || !
#line 28507 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_VOLATILE_P (operands[1])
   && !MEM_VOLATILE_P (operands[2])
   && rtx_equal_p (operands[1], operands[2])
   && !reg_overlap_mentioned_p (operands[0], operands[2])))
    return NULL;
  *pmatch_len_ = 1;
  return gen_peephole2_331 (insn, operands);
}

 rtx_insn *
peephole2_40 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (pattern231 (x2, 
E_CCmode, 
17) != 0)
    return NULL;
  x3 = XVECEXP (x1, 0, 0);
  x4 = XEXP (x3, 1);
  switch (XWINT (x4, 0))
    {
    case 0L:
      res = peephole2_39 (x1, insn, pmatch_len_);
      if (res != NULL_RTX)
        return res;
      break;

    case 1L:
      x5 = XEXP (x3, 0);
      if (GET_CODE (x5) == ZERO_EXTRACT
          && pattern1058 (x5) == 0
          && 
#line 19089 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && !TARGET_USE_BT))
        {
          *pmatch_len_ = 0;
          res = gen_peephole2_165 (insn, operands);
          if (res != NULL_RTX)
            return res;
        }
      break;

    default:
      break;
    }
  if (peep2_current_count < 2
      || peep2_current_count < 3)
    return NULL;
  x5 = XEXP (x3, 0);
  operands[0] = x5;
  x6 = PATTERN (peep2_next_insn (1));
  if (pattern419 (x6, 
UNSPEC_VOLATILE, 
3) != 0)
    return NULL;
  x7 = XVECEXP (x6, 0, 1);
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = PATTERN (peep2_next_insn (2));
  if (pattern1518 (x8) != 0)
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode))
        return NULL;
      operands[1] = x4;
      switch (pattern1790 (x6, 
E_SImode))
        {
        case 0:
          if (
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_407 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 1:
          if (
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_409 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 2:
          if (
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_411 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 3:
          if ((
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_413 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        default:
          break;
        }
      operands[2] = x4;
      if (pattern1746 (x6, 
E_SImode) != 0
          || !
#line 754 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_421 (insn, operands);

    case E_DImode:
      if (!register_operand (operands[0], E_DImode))
        return NULL;
      operands[1] = x4;
      switch (pattern1790 (x6, 
E_DImode))
        {
        case 0:
          if ((
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_408 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 1:
          if ((
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_410 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 2:
          if ((
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_412 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        case 3:
          if ((
#line 557 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(REGNO (operands[0]) == REGNO (operands[2])) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pmatch_len_ = 2;
              res = gen_peephole2_414 (insn, operands);
              if (res != NULL_RTX)
                return res;
            }
          break;

        default:
          break;
        }
      operands[2] = x4;
      if (pattern1746 (x6, 
E_DImode) != 0
          || !(
#line 754 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_422 (insn, operands);

    case E_QImode:
      if (pattern1747 (x4, 
E_QImode) != 0
          || !
#line 754 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_419 (insn, operands);

    case E_HImode:
      if (pattern1747 (x4, 
E_HImode) != 0
          || !
#line 754 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(peep2_reg_dead_p (3, operands[0])
   && (unsigned HOST_WIDE_INT) INTVAL (operands[2])
      == -(unsigned HOST_WIDE_INT) INTVAL (operands[3])
   && !reg_overlap_mentioned_p (operands[0], operands[1])))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_420 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
peephole2_48 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pmatch_len_ ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  rtx_insn *res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3)
    return NULL;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x2, 0);
  operands[0] = x4;
  x5 = XEXP (x3, 1);
  operands[1] = x5;
  x6 = XEXP (x3, 0);
  if (!rtx_equal_p (x6, operands[0]))
    return NULL;
  x7 = PATTERN (peep2_next_insn (1));
  if (GET_CODE (x7) != SET)
    return NULL;
  x8 = XEXP (x7, 1);
  if (!rtx_equal_p (x8, operands[0]))
    return NULL;
  x9 = XEXP (x7, 0);
  if (!rtx_equal_p (x9, operands[1]))
    return NULL;
  x10 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x10) != SET)
    return NULL;
  x11 = XEXP (x10, 1);
  if (GET_CODE (x11) != COMPARE)
    return NULL;
  x12 = XEXP (x11, 1);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return NULL;
  x13 = XEXP (x10, 0);
  if (GET_CODE (x13) != REG
      || REGNO (x13) != 17)
    return NULL;
  x14 = XEXP (x11, 0);
  if (!rtx_equal_p (x14, operands[0]))
    return NULL;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || !plusminuslogic_operator (operands[2], E_QImode)
          || !memory_operand (operands[1], E_QImode)
          || !
#line 28209 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_305 (insn, operands);

    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || !plusminuslogic_operator (operands[2], E_HImode)
          || !memory_operand (operands[1], E_HImode)
          || !
#line 28209 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_306 (insn, operands);

    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || !plusminuslogic_operator (operands[2], E_SImode)
          || !memory_operand (operands[1], E_SImode)
          || !
#line 28209 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_307 (insn, operands);

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || !plusminuslogic_operator (operands[2], E_DImode)
          || !memory_operand (operands[1], E_DImode)
          || !(
#line 28209 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((TARGET_READ_MODIFY_WRITE || optimize_insn_for_size_p ())
   && COMMUTATIVE_ARITH_P (operands[2])
   && peep2_reg_dead_p (3, operands[0])
   && !reg_overlap_mentioned_p (operands[0], operands[1])
   && ix86_match_ccmode (peep2_next_insn (2),
			 GET_CODE (operands[2]) == PLUS
			 ? CCGOCmode : CCNOmode)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return NULL;
      *pmatch_len_ = 2;
      return gen_peephole2_308 (insn, operands);

    default:
      return NULL;
    }
}
