/* Generated automatically by the program `genrecog' from the target
   machine description file.  */

#define IN_TARGET_CODE 1

#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "backend.h"
#include "predict.h"
#include "rtl.h"
#include "memmodel.h"
#include "tm_p.h"
#include "emit-rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "output.h"
#include "flags.h"
#include "df.h"
#include "resource.h"
#include "diagnostic-core.h"
#include "reload.h"
#include "regs.h"
#include "tm-constrs.h"
#include "insn-recog.h"


/* `recog' contains a decision tree that recognizes whether the rtx
   X0 is a valid instruction.

   recog returns -1 if the rtx is not valid.  If the rtx is valid, recog
   returns a nonnegative number which is the insn code number for the
   pattern that matched.  This is the same as the order in the machine
   description of the entry that matched.  This number can be used as an
   index into `insn_data' and other tables.
   The third parameter to recog is an optional pointer to an int.  If
   present, recog will accept a pattern if it matches except for missing
   CLOBBER expressions at the end.  In that case, the value pointed to by
   the optional pointer will be set to the number of CLOBBERs that need
   to be added (it should be initialized to zero by the caller).  If it   is set nonzero, the caller should allocate a PARALLEL of the
   appropriate size, copy the initial entries, and call add_clobbers
   (found in insn-emit.cc) to fill in the CLOBBERs.

   The function split_insns returns 0 if the rtl could not
   be split or the split rtl as an INSN list if it can be.

   The function peephole2_insns returns 0 if the rtl could not
   be matched. If there was a match, the new rtl is returned in an INSN list,
   and LAST_INSN will point to the last recognized insn in the old sequence.
*/




int
pattern0 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_QImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!register_operand (operands[0], E_TImode)
      || GET_MODE (x2) != E_TImode
      || !register_operand (operands[1], E_TImode))
    return -1;
  x5 = XEXP (x3, 0);
  operands[2] = x5;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  x6 = XEXP (x3, 1);
  operands[3] = x6;
  if (!const_int_operand (operands[3], E_QImode))
    return -1;
  return 0;
}

int
pattern18 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!register_operand (operands[2], E_QImode))
    return -1;
  return pattern17 (x1); /* [-1, 1] */
}

int
pattern22 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!nonimmediate_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern32 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  switch (GET_CODE (operands[2]))
    {
    case CONST_INT:
      switch (GET_MODE (operands[0]))
        {
        case E_V1TImode:
          return pattern30 (x3); /* [-1, 0] */

        case E_V16SImode:
          if (pattern31 (x3, 
E_V16SImode) != 0)
            return -1;
          return 1;

        case E_V8SImode:
          if (pattern31 (x3, 
E_V8SImode) != 0)
            return -1;
          return 2;

        case E_V4SImode:
          if (!register_operand (operands[0], E_V4SImode)
              || GET_MODE (x3) != E_V4SImode
              || !nonimmediate_operand (operands[1], E_V4SImode))
            return -1;
          return 3;

        case E_V8DImode:
          if (pattern31 (x3, 
E_V8DImode) != 0)
            return -1;
          return 4;

        case E_V4DImode:
          if (pattern31 (x3, 
E_V4DImode) != 0)
            return -1;
          return 5;

        case E_V2DImode:
          if (!register_operand (operands[0], E_V2DImode)
              || GET_MODE (x3) != E_V2DImode
              || !nonimmediate_operand (operands[1], E_V2DImode))
            return -1;
          return 6;

        case E_V16QImode:
          if (!register_operand (operands[0], E_V16QImode)
              || GET_MODE (x3) != E_V16QImode
              || !nonimmediate_operand (operands[1], E_V16QImode)
              || !const_0_to_7_operand (operands[2], E_SImode))
            return -1;
          return 7;

        case E_V8HImode:
          if (!register_operand (operands[0], E_V8HImode)
              || GET_MODE (x3) != E_V8HImode
              || !nonimmediate_operand (operands[1], E_V8HImode)
              || !const_0_to_15_operand (operands[2], E_SImode))
            return -1;
          return 8;

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern14 (x3, 
E_V16SImode) != 0)
            return -1;
          return 9;

        case E_V8SImode:
          if (pattern14 (x3, 
E_V8SImode) != 0)
            return -1;
          return 10;

        case E_V4SImode:
          if (pattern14 (x3, 
E_V4SImode) != 0)
            return -1;
          return 11;

        case E_V8DImode:
          if (pattern14 (x3, 
E_V8DImode) != 0)
            return -1;
          return 12;

        case E_V4DImode:
          if (pattern14 (x3, 
E_V4DImode) != 0)
            return -1;
          return 13;

        case E_V2DImode:
          if (pattern14 (x3, 
E_V2DImode) != 0)
            return -1;
          return 14;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern54 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_V4HImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_V4HImode)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != VEC_CONCAT
      || GET_MODE (x4) != E_V8HImode)
    return -1;
  x5 = XEXP (x3, 1);
  if (GET_CODE (x5) != PARALLEL
      || XVECLEN (x5, 0) != 4)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x5, 0, 1);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x8 = XVECEXP (x5, 0, 2);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x9 = XVECEXP (x5, 0, 3);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x10 = XEXP (x2, 1);
  if (GET_CODE (x10) != VEC_SELECT
      || GET_MODE (x10) != E_V4HImode)
    return -1;
  x11 = XEXP (x10, 0);
  if (GET_CODE (x11) != VEC_CONCAT
      || GET_MODE (x11) != E_V8HImode)
    return -1;
  x12 = XEXP (x10, 1);
  if (GET_CODE (x12) != PARALLEL
      || XVECLEN (x12, 0) != 4)
    return -1;
  x13 = XVECEXP (x12, 0, 0);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x14 = XVECEXP (x12, 0, 1);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x15 = XVECEXP (x12, 0, 2);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x16 = XVECEXP (x12, 0, 3);
  if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x17 = XEXP (x1, 0);
  operands[0] = x17;
  if (!register_operand (operands[0], E_V4HImode)
      || pattern53 (x2) != 0)
    return -1;
  return 0;
}

int
pattern72 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      x4 = XEXP (x1, 1);
      return pattern71 (x4, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      x4 = XEXP (x1, 1);
      if (pattern71 (x4, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern81 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_QImode
      || !register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  if (!nonimmediate_operand (operands[1], E_QImode))
    return -1;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return 0;
}

int
pattern88 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern92 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_BLKmode)
    return -1;
  x3 = XEXP (x1, 0);
  operands[0] = x3;
  if (!memory_operand (operands[0], E_BLKmode))
    return -1;
  x4 = XVECEXP (x2, 0, 0);
  operands[1] = x4;
  if (!register_operand (operands[1], E_SImode))
    return -1;
  x5 = XVECEXP (x2, 0, 1);
  operands[2] = x5;
  if (!register_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern101 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4HImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_CONCAT
      || GET_MODE (x3) != E_V8HImode)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != VEC_SELECT
      || GET_MODE (x9) != E_V4HImode)
    return -1;
  x10 = XEXP (x9, 0);
  if (GET_CODE (x10) != VEC_CONCAT
      || GET_MODE (x10) != E_V8HImode)
    return -1;
  x11 = XEXP (x9, 1);
  if (GET_CODE (x11) != PARALLEL
      || XVECLEN (x11, 0) != 4)
    return -1;
  x12 = XVECEXP (x11, 0, 0);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x13 = XVECEXP (x11, 0, 1);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x14 = XVECEXP (x11, 0, 2);
  if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x15 = XVECEXP (x11, 0, 3);
  if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V4HImode)
      || GET_MODE (x1) != E_V4HImode
      || pattern53 (x1) != 0)
    return -1;
  return 0;
}

int
pattern119 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_DImode
      || pattern41 (x1, 
E_SImode, 
E_DImode) != 0)
    return -1;
  return 0;
}

int
pattern125 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  x7 = XEXP (x3, 0);
  operands[1] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern124 (x2, 
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern124 (x2, 
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern136 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern145 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SImode:
      return pattern128 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

    case E_V8SImode:
      if (pattern128 (x1, 
E_V8SImode, 
E_QImode) != 0)
        return -1;
      return 1;

    case E_V4SImode:
      if (pattern129 (x1, 
E_QImode, 
E_V4SImode) != 0)
        return -1;
      return 2;

    case E_V8DImode:
      if (pattern128 (x1, 
E_V8DImode, 
E_QImode) != 0)
        return -1;
      return 3;

    case E_V4DImode:
      if (pattern128 (x1, 
E_V4DImode, 
E_QImode) != 0)
        return -1;
      return 4;

    case E_V2DImode:
      if (pattern128 (x1, 
E_V2DImode, 
E_QImode) != 0)
        return -1;
      return 5;

    case E_V64QImode:
      if (pattern128 (x1, 
E_V64QImode, 
E_DImode) != 0)
        return -1;
      return 6;

    case E_V16QImode:
      if (pattern128 (x1, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 7;

    case E_V32QImode:
      if (pattern128 (x1, 
E_V32QImode, 
E_SImode) != 0)
        return -1;
      return 8;

    case E_V32HImode:
      if (pattern128 (x1, 
E_V32HImode, 
E_SImode) != 0)
        return -1;
      return 9;

    case E_V16HImode:
      if (pattern128 (x1, 
E_V16HImode, 
E_HImode) != 0)
        return -1;
      return 10;

    case E_V8HImode:
      if (pattern129 (x1, 
E_QImode, 
E_V8HImode) != 0)
        return -1;
      return 11;

    default:
      return -1;
    }
}

int
pattern157 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern152 (x3, 
E_V64QImode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern152 (x3, 
E_V32QImode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern152 (x3, 
E_V16QImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern164 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V64QImode:
      return pattern163 (x3, 
E_V64QImode, 
E_V32HFmode); /* [-1, 0] */

    case E_V32QImode:
      if (pattern163 (x3, 
E_V32QImode, 
E_V16HFmode) != 0)
        return -1;
      return 1;

    case E_V16QImode:
      if (pattern163 (x3, 
E_V16QImode, 
E_V8HFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern173 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  x6 = XVECEXP (x3, 0, 2);
  operands[3] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V8DImode:
      return pattern172 (x3, 
E_V8DImode); /* [-1, 0] */

    case E_V4DImode:
      if (pattern172 (x3, 
E_V4DImode) != 0)
        return -1;
      return 1;

    case E_V2DImode:
      if (pattern172 (x3, 
E_V2DImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern180 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x1, 1);
  operands[2] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x1) != E_V8HFmode)
        return -1;
      switch (GET_MODE (x2))
        {
        case E_V4HFmode:
          if (!const0_operand (operands[2], E_V4HFmode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V4SImode:
              if (!vector_operand (operands[1], E_V4SImode))
                return -1;
              return 0;

            case E_V4DImode:
              if (!vector_operand (operands[1], E_V4DImode))
                return -1;
              return 1;

            default:
              return -1;
            }

        case E_V2HFmode:
          if (!vector_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V6HFmode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_V4SFmode:
      if (pattern179 (x1, 
E_V2SFmode, 
E_V2DImode, 
E_V4SFmode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern192 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22, x23, x24, x25;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL)
    return -1;
  x5 = XEXP (x1, 1);
  if (GET_CODE (x5) != i1)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != VEC_SELECT)
    return -1;
  x7 = XEXP (x6, 1);
  if (GET_CODE (x7) != PARALLEL)
    return -1;
  x8 = XEXP (x3, 0);
  operands[1] = x8;
  x9 = XEXP (x6, 0);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (XVECLEN (x4, 0))
    {
    case 8:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x12 = XVECEXP (x4, 0, 2);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x13 = XVECEXP (x4, 0, 3);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x14 = XVECEXP (x4, 0, 4);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x15 = XVECEXP (x4, 0, 5);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 10])
        return -1;
      x16 = XVECEXP (x4, 0, 6);
      if (x16 != const_int_rtx[MAX_SAVED_CONST_INT + 12])
        return -1;
      x17 = XVECEXP (x4, 0, 7);
      if (x17 != const_int_rtx[MAX_SAVED_CONST_INT + 14]
          || XVECLEN (x7, 0) != 8)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x20 = XVECEXP (x7, 0, 2);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x21 = XVECEXP (x7, 0, 3);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
        return -1;
      x22 = XVECEXP (x7, 0, 4);
      if (x22 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
        return -1;
      x23 = XVECEXP (x7, 0, 5);
      if (x23 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
        return -1;
      x24 = XVECEXP (x7, 0, 6);
      if (x24 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
        return -1;
      x25 = XVECEXP (x7, 0, 7);
      if (x25 != const_int_rtx[MAX_SAVED_CONST_INT + 15]
          || pattern191 (x1, 
E_V8QImode, 
E_V8HImode, 
E_V16QImode) != 0)
        return -1;
      return 0;

    case 4:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x12 = XVECEXP (x4, 0, 2);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x13 = XVECEXP (x4, 0, 3);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 6]
          || XVECLEN (x7, 0) != 4)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x20 = XVECEXP (x7, 0, 2);
      if (x20 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x21 = XVECEXP (x7, 0, 3);
      if (x21 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || pattern191 (x1, 
E_V4HImode, 
E_V4SImode, 
E_V8HImode) != 0)
        return -1;
      return 1;

    case 2:
      x10 = XVECEXP (x4, 0, 0);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x11 = XVECEXP (x4, 0, 1);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 2]
          || XVECLEN (x7, 0) != 2)
        return -1;
      x18 = XVECEXP (x7, 0, 0);
      if (x18 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x19 = XVECEXP (x7, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 3]
          || pattern191 (x1, 
E_V2SImode, 
E_V2DImode, 
E_V4SImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern222 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != USE)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 0);
  operands[0] = x6;
  x7 = XEXP (x5, 1);
  x8 = XEXP (x7, 0);
  operands[1] = x8;
  x9 = XEXP (x2, 0);
  operands[2] = x9;
  switch (GET_MODE (operands[0]))
    {
    case E_HFmode:
      return pattern221 (x7, 
E_V8HFmode, 
E_HFmode); /* [-1, 0] */

    case E_SFmode:
      if (pattern221 (x7, 
E_V4SFmode, 
E_SFmode) != 0)
        return -1;
      return 1;

    case E_DFmode:
      if (pattern221 (x7, 
E_V2DFmode, 
E_DFmode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern236 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[1] = x2;
  x3 = XEXP (x1, 1);
  operands[2] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V4HImode:
      return pattern235 (x1, 
E_V4HImode); /* [-1, 0] */

    case E_V2SImode:
      if (pattern235 (x1, 
E_V2SImode) != 0)
        return -1;
      return 1;

    case E_V2HImode:
      if (pattern235 (x1, 
E_V2HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern246 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  x8 = XEXP (x6, 1);
  operands[2] = x8;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  return pattern245 (x6); /* [-1, 1] */
}

int
pattern256 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V2QImode)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  if (!memory_operand (operands[0], E_HImode)
      || GET_MODE (x2) != E_HImode)
    return -1;
  x5 = XEXP (x3, 0);
  operands[1] = x5;
  if (!register_operand (operands[1], E_V2DImode))
    return -1;
  return 0;
}

int
pattern262 (rtx x1, int *pnum_clobbers, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL
      || !nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern268 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  operands[3] = x4;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern2 (x1); /* [-1, 1] */
}

int
pattern274 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1)
      || !register_mmxmem_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern279 (rtx x1, int *pnum_clobbers, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (!nonimmediate_operand (x3, i2))
    return -1;
  x4 = XEXP (x1, 1);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      if (pnum_clobbers == NULL)
        return -1;
      operands[1] = x4;
      if (!nonimmediate_operand (operands[1], i1))
        return -1;
      operands[2] = x3;
      return 0;

    case ASHIFT:
      if (GET_MODE (x4) != i1)
        return -1;
      operands[1] = x3;
      res = pattern37 (x4, 
i1, 
i2);
      if (res >= 0)
        return res + 1; /* [1, 3] */
      return -1;

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[2] = x4;
      if (!const_scalar_int_operand (operands[2], i1))
        return -1;
      operands[1] = x3;
      return 4;

    default:
      return -1;
    }
}

int
pattern295 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V4QImode:
      switch (GET_MODE (operands[1]))
        {
        case E_V4SImode:
          if (!register_operand (operands[1], E_V4SImode))
            return -1;
          return 0;

        case E_V4DImode:
          if (!register_operand (operands[1], E_V4DImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V2HImode:
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern307 (rtx x1, int i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != VEC_SELECT
      || GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL
      || XVECLEN (x3, 0) != 2)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern315 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 2);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern319 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !float_vector_all_ones_operand (operands[1], i1)
      || !const0_operand (operands[2], i1)
      || !register_operand (operands[3], i1)
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern325 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  operands[1] = x2;
  switch (GET_MODE (operands[0]))
    {
    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x1) != E_V32HImode
          || !vector_operand (operands[1], i1))
        return -1;
      return 0;

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x1) != E_V16HImode
          || !vector_operand (operands[1], i2))
        return -1;
      return 1;

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || !vector_operand (operands[1], i3))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern330 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern332 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != E_V4SImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != SIGN_EXTEND
      || GET_MODE (x2) != E_V4SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != VEC_SELECT
      || GET_MODE (x3) != E_V4HImode)
    return -1;
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 4)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x7 = XVECEXP (x4, 0, 2);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x8 = XVECEXP (x4, 0, 3);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x9 = XEXP (x1, 1);
  if (GET_CODE (x9) != SIGN_EXTEND)
    return -1;
  return 0;
}

int
pattern339 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  switch (GET_MODE (operands[0]))
    {
    case E_V4DImode:
      return pattern338 (x1, 
E_V4DImode); /* [-1, 0] */

    case E_V2DImode:
      if (pattern338 (x1, 
E_V2DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern343 (rtx x1, int *pnum_clobbers, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_SImode)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != i1
      || GET_MODE (x6) != E_SImode)
    return -1;
  x7 = XEXP (x2, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_DImode)
      || GET_MODE (x3) != E_DImode)
    return -1;
  return 0;
}

int
pattern348 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern352 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (XVECLEN (x4, 0) != 3)
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != UNSPEC
      || XVECLEN (x6, 0) != 3)
    return -1;
  return 0;
}

int
pattern355 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_MODE (x5) != i2
      || !nonimmediate_operand (operands[4], i1))
    return -1;
  x6 = XEXP (x1, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern359 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !general_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern364 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XVECEXP (x5, 0, 0);
  operands[0] = x6;
  x7 = XVECEXP (x5, 0, 1);
  operands[2] = x7;
  if (!const_int_operand (operands[2], E_SImode))
    return -1;
  x8 = XEXP (x4, 1);
  operands[1] = x8;
  x9 = XVECEXP (x1, 0, 1);
  x10 = XEXP (x9, 1);
  x11 = XEXP (x10, 0);
  if (!rtx_equal_p (x11, operands[0]))
    return -1;
  x12 = XEXP (x10, 1);
  if (!rtx_equal_p (x12, operands[1]))
    return -1;
  x13 = XEXP (x9, 0);
  if (!rtx_equal_p (x13, operands[0]))
    return -1;
  switch (GET_MODE (x4))
    {
    case E_QImode:
      return pattern363 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern363 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern363 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern363 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern377 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x2, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[0] = x5;
      x6 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x6))
        {
        case CLOBBER:
          return 0;

        case USE:
          return 1;

        default:
          return -1;
        }

    case STRICT_LOW_PART:
      x6 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x6) != CLOBBER)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != REG
          || REGNO (x7) != 17
          || GET_MODE (x7) != E_CCmode)
        return -1;
      x8 = XEXP (x5, 0);
      operands[0] = x8;
      res = pattern376 (x3);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern394 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != REG
      || REGNO (x5) != 17
      || GET_MODE (x5) != E_CCmode)
    return -1;
  x6 = XVECEXP (x1, 0, 0);
  x7 = XEXP (x6, 0);
  operands[0] = x7;
  x8 = XEXP (x6, 1);
  x9 = XEXP (x8, 0);
  operands[2] = x9;
  x10 = XEXP (x8, 1);
  operands[3] = x10;
  x11 = XEXP (x2, 0);
  operands[1] = x11;
  x12 = XEXP (x3, 0);
  if (!rtx_equal_p (x12, operands[2]))
    return -1;
  x13 = XEXP (x3, 1);
  if (!rtx_equal_p (x13, operands[3]))
    return -1;
  x14 = XVECEXP (x1, 0, 2);
  switch (GET_CODE (x14))
    {
    case UNSPEC:
      return pattern391 (x1); /* [-1, 1] */

    case USE:
      res = pattern393 (x1);
      if (res >= 0)
        return res + 2; /* [2, 4] */
      return -1;

    default:
      return -1;
    }
}

int
pattern411 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
      || !register_operand (operands[0], E_V2DImode)
      || GET_MODE (x1) != E_V2DImode
      || GET_MODE (x2) != E_V2DImode
      || GET_MODE (x3) != i2)
    return -1;
  x7 = XEXP (x3, 0);
  if (GET_MODE (x7) != i1
      || !nonimm_or_0_operand (operands[2], E_V2DImode))
    return -1;
  return 0;
}

int
pattern415 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_SFmode:
      if (!memory_operand (operands[1], E_SFmode))
        return -1;
      return 0;

    case E_DFmode:
      if (!memory_operand (operands[1], E_DFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern421 (rtx x1, machine_mode i1, rtx_code i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != LTU)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x2, 1);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern428 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_TImode
      || !nonimmediate_operand (operands[0], E_TImode)
      || GET_MODE (x1) != E_TImode
      || GET_MODE (x2) != E_TImode)
    return -1;
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!nonimmediate_operand (operands[1], E_DImode)
      || !const_int_operand (operands[2], E_QImode))
    return -1;
  x5 = XEXP (x1, 1);
  return pattern259 (x5, 
E_DImode, 
E_TImode); /* [-1, 1] */
}

int
pattern437 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  operands[2] = x3;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x1, 0);
  operands[0] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      return 0;

    case E_HImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern448 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  operands[2] = x1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return -1;
  x3 = XEXP (x1, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return 0;

    case E_DImode:
      return 1;

    default:
      return -1;
    }
}

int
pattern455 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!register_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern464 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !vector_operand (operands[1], i2)
      || !vector_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[3], i2))
    return -1;
  x3 = XEXP (x1, 2);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[4], E_QImode))
    return -1;
  return 0;
}

int
pattern473 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  if (!const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  x5 = XEXP (x1, 1);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_V32BFmode:
      return pattern472 (x1, 
E_V32BFmode, 
E_SImode); /* [-1, 0] */

    case E_V16BFmode:
      if (pattern472 (x1, 
E_V16BFmode, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_V8BFmode:
      if (pattern472 (x1, 
E_V8BFmode, 
E_QImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern482 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1)
      || !register_operand (operands[5], i2))
    return -1;
  return 0;
}

int
pattern490 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  x4 = XVECEXP (x2, 0, 1);
  operands[2] = x4;
  x5 = XVECEXP (x2, 0, 2);
  operands[3] = x5;
  x6 = XEXP (x1, 2);
  operands[4] = x6;
  x7 = XEXP (x1, 1);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
      if (!rtx_equal_p (x7, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          return pattern484 (x1, 
E_V16SImode, 
E_HImode); /* [-1, 0] */

        case E_V8SImode:
          if (pattern484 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 1;

        case E_V4SImode:
          if (pattern484 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 2;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[5] = x7;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (pattern489 (x1, 
E_V16SImode, 
E_HImode) != 0)
            return -1;
          return 3;

        case E_V8SImode:
          if (pattern489 (x1, 
E_V8SImode, 
E_QImode) != 0)
            return -1;
          return 4;

        case E_V4SImode:
          if (pattern489 (x1, 
E_V4SImode, 
E_QImode) != 0)
            return -1;
          return 5;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern502 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XVECEXP (x4, 0, 1);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[0], E_V8HFmode)
          || GET_MODE (x1) != E_V8HFmode
          || GET_MODE (x2) != E_V2HFmode)
        return -1;
      x7 = XEXP (x2, 0);
      if (GET_MODE (x7) != E_V2HFmode
          || !vector_operand (operands[1], i1)
          || GET_MODE (x3) != E_V2HFmode
          || !nonimm_or_0_operand (operands[2], E_V8HFmode)
          || !const0_operand (operands[4], E_V6HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (pattern501 (x1, 
E_V2SFmode, 
E_V4SFmode, 
i1) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern510 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HImode:
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      return 0;

    case E_V8SImode:
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      return 1;

    case E_V8DImode:
      if (!register_operand (operands[1], E_V8DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern515 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const0_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V4DImode:
      if (!register_operand (operands[1], E_V4DImode))
        return -1;
      return 0;

    case E_V4SImode:
      if (!register_operand (operands[1], E_V4SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern521 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V2DFmode)
      || GET_MODE (x1) != E_V2DFmode)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V2SImode:
      if (!nonimmediate_operand (operands[1], E_V2SImode))
        return -1;
      return 0;

    case E_V2DImode:
      if (!nonimmediate_operand (operands[1], E_V2DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern526 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !permvar_truncate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern534 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !regmem_or_bitnot_regmem_operand (operands[1], i1)
      || !regmem_or_bitnot_regmem_operand (operands[2], i1)
      || !regmem_or_bitnot_regmem_operand (operands[3], i1)
      || !regmem_or_bitnot_regmem_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern537 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  x5 = XEXP (x1, 1);
  switch (GET_CODE (x5))
    {
    case AND:
      return pattern536 (x1); /* [-1, 11] */

    case IOR:
      res = pattern536 (x1);
      if (res >= 0)
        return res + 12; /* [12, 23] */
      return -1;

    case XOR:
      res = pattern536 (x1);
      if (res >= 0)
        return res + 24; /* [24, 35] */
      return -1;

    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      operands[3] = x5;
      switch (GET_MODE (operands[0]))
        {
        case E_V32HFmode:
          if (pattern532 (x1, 
E_V32HFmode) != 0)
            return -1;
          return 36;

        case E_V16HFmode:
          if (pattern532 (x1, 
E_V16HFmode) != 0)
            return -1;
          return 37;

        case E_V8HFmode:
          if (pattern532 (x1, 
E_V8HFmode) != 0)
            return -1;
          return 38;

        case E_V32BFmode:
          if (pattern532 (x1, 
E_V32BFmode) != 0)
            return -1;
          return 39;

        case E_V16BFmode:
          if (pattern532 (x1, 
E_V16BFmode) != 0)
            return -1;
          return 40;

        case E_V8BFmode:
          if (pattern532 (x1, 
E_V8BFmode) != 0)
            return -1;
          return 41;

        case E_V16SFmode:
          if (pattern532 (x1, 
E_V16SFmode) != 0)
            return -1;
          return 42;

        case E_V8SFmode:
          if (pattern532 (x1, 
E_V8SFmode) != 0)
            return -1;
          return 43;

        case E_V4SFmode:
          if (pattern532 (x1, 
E_V4SFmode) != 0)
            return -1;
          return 44;

        case E_V8DFmode:
          if (pattern532 (x1, 
E_V8DFmode) != 0)
            return -1;
          return 45;

        case E_V4DFmode:
          if (pattern532 (x1, 
E_V4DFmode) != 0)
            return -1;
          return 46;

        case E_V2DFmode:
          if (pattern532 (x1, 
E_V2DFmode) != 0)
            return -1;
          return 47;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern550 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x2) != CLOBBER)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 17
      || GET_MODE (x3) != E_CCmode)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[0] = x5;
  return 0;
}

int
pattern556 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_QImode:
      x4 = XEXP (x1, 1);
      return pattern555 (x4, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      x4 = XEXP (x1, 1);
      if (pattern555 (x4, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern561 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern566 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], E_SImode)
      || GET_MODE (x1) != E_SImode
      || !nonimmediate_operand (operands[1], E_SImode)
      || !x86_64_general_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern572 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!ix86_carry_flag_operator (operands[1], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) != REG
      || REGNO (x2) != 17)
    return -1;
  x3 = XEXP (x1, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern577 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!const123_operand (operands[2], E_VOIDmode))
    return -1;
  return pattern434 (x1); /* [-1, 1] */
}

int
pattern581 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (GET_MODE (x2) != E_QImode)
    return -1;
  switch (GET_CODE (x2))
    {
    case SUBREG:
      if (maybe_ne (SUBREG_BYTE (x2), 0))
        return -1;
      x3 = XEXP (x2, 0);
      switch (GET_CODE (x3))
        {
        case AND:
          operands[4] = x3;
          if (!and_operator (operands[4], E_VOIDmode))
            return -1;
          return pattern579 (x1); /* [-1, 3] */

        case PLUS:
          res = pattern579 (x1);
          if (res >= 0)
            return res + 4; /* [4, 7] */
          return -1;

        case MINUS:
          x4 = XEXP (x3, 0);
          operands[3] = x4;
          if (!const_int_operand (operands[3], E_VOIDmode))
            return -1;
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (!int248_register_operand (operands[2], E_VOIDmode))
            return -1;
          res = pattern578 (x1);
          if (res >= 0)
            return res + 8; /* [8, 11] */
          return -1;

        default:
          return -1;
        }

    case AND:
      res = pattern580 (x1);
      if (res >= 0)
        return res + 12; /* [12, 15] */
      return -1;

    case PLUS:
      res = pattern580 (x1);
      if (res >= 0)
        return res + 16; /* [16, 19] */
      return -1;

    case MINUS:
      x3 = XEXP (x2, 0);
      operands[3] = x3;
      if (!const_int_operand (operands[3], E_QImode))
        return -1;
      x6 = XEXP (x2, 1);
      operands[2] = x6;
      if (!register_operand (operands[2], E_QImode))
        return -1;
      res = pattern578 (x1);
      if (res >= 0)
        return res + 20; /* [20, 23] */
      return -1;

    default:
      return -1;
    }
}

int
pattern599 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != 3)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != UNSPEC_VOLATILE
      || XVECLEN (x3, 0) != i1)
    return -1;
  return 0;
}

int
pattern603 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_no_SP_operand (operands[1], i1)
      || !const_0_to_3_operand (operands[2], E_VOIDmode)
      || !const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern609 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V2SImode:
      if (!register_operand (operands[0], E_V2SImode)
          || GET_MODE (x1) != E_V2SImode)
        return -1;
      switch (GET_MODE (x2))
        {
        case E_V2HImode:
          if (!register_operand (operands[1], E_V4HImode))
            return -1;
          return 0;

        case E_V2QImode:
          if (!register_operand (operands[1], E_V4QImode))
            return -1;
          return 1;

        default:
          return -1;
        }

    case E_V2HImode:
      if (pattern607 (x1, 
E_V4QImode, 
E_V2QImode, 
E_V2HImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern627 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern632 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern638 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 2);
  switch (GET_CODE (x3))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      operands[3] = x3;
      return pattern637 (x1); /* [-1, 28] */

    case NEG:
      x4 = XEXP (x3, 0);
      operands[3] = x4;
      return 29;

    default:
      return -1;
    }
}

int
pattern641 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V16HFmode:
      if (!vector_operand (operands[1], E_V16HFmode))
        return -1;
      return 0;

    case E_V16SFmode:
      if (!vector_operand (operands[1], E_V16SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern646 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern651 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i3)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern656 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  operands[2] = x2;
  x3 = XVECEXP (x1, 0, 2);
  x4 = XEXP (x3, 0);
  operands[3] = x4;
  x5 = XEXP (x3, 1);
  operands[4] = x5;
  switch (GET_CODE (operands[4]))
    {
    case REG:
    case SUBREG:
    case MEM:
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          return pattern653 (x1, 
E_V8SFmode); /* [-1, 0] */

        case E_V4SFmode:
          if (pattern653 (x1, 
E_V4SFmode) != 0)
            return -1;
          return 1;

        case E_V4DFmode:
          if (pattern653 (x1, 
E_V4DFmode) != 0)
            return -1;
          return 2;

        case E_V2DFmode:
          if (pattern653 (x1, 
E_V2DFmode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      switch (GET_MODE (operands[0]))
        {
        case E_V8SFmode:
          if (pattern654 (x1, 
E_V8SImode, 
E_V8SFmode) != 0)
            return -1;
          return 4;

        case E_V4SFmode:
          if (pattern654 (x1, 
E_V4SImode, 
E_V4SFmode) != 0)
            return -1;
          return 5;

        case E_V4DFmode:
          if (pattern654 (x1, 
E_V4DImode, 
E_V4DFmode) != 0)
            return -1;
          return 6;

        case E_V2DFmode:
          if (pattern654 (x1, 
E_V2DImode, 
E_V2DFmode) != 0)
            return -1;
          return 7;

        case E_V32QImode:
          if (pattern655 (x1, 
E_V32QImode) != 0)
            return -1;
          return 8;

        case E_V16QImode:
          if (pattern655 (x1, 
E_V16QImode) != 0)
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern677 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != E_V2DImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x4, 0);
  operands[1] = x6;
  if (!memory_operand (operands[1], E_DImode))
    return -1;
  x7 = XEXP (x2, 1);
  switch (XVECLEN (x7, 0))
    {
    case 8:
      x8 = XVECEXP (x7, 0, 0);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x9 = XVECEXP (x7, 0, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x10 = XVECEXP (x7, 0, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
        return -1;
      x11 = XVECEXP (x7, 0, 3);
      if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
        return -1;
      x12 = XVECEXP (x7, 0, 4);
      if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
        return -1;
      x13 = XVECEXP (x7, 0, 5);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
        return -1;
      x14 = XVECEXP (x7, 0, 6);
      if (x14 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
        return -1;
      x15 = XVECEXP (x7, 0, 7);
      if (x15 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
          || GET_MODE (x2) != E_V8QImode
          || GET_MODE (x3) != E_V16QImode)
        return -1;
      return pattern539 (x1); /* [-1, 2] */

    case 4:
      res = pattern675 (x1, 
E_V8HImode, 
E_V4HImode);
      if (res >= 0)
        return res + 3; /* [3, 4] */
      return -1;

    case 2:
      if (pattern676 (x1, 
E_V2SImode, 
E_V4SImode) != 0)
        return -1;
      return 5;

    default:
      return -1;
    }
}

int
pattern698 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[3] = x5;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern245 (x1); /* [-1, 1] */
}

int
pattern705 (rtx x1, machine_mode i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != E_DImode)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x5) != SET)
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_CODE (x6) != UNSPEC_VOLATILE
      || XVECLEN (x6, 0) != 1
      || XINT (x6, 1) != i2
      || GET_MODE (x6) != i1)
    return -1;
  x7 = XVECEXP (x6, 0, 0);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
      || !register_operand (operands[0], E_DImode))
    return -1;
  x8 = XEXP (x5, 0);
  operands[1] = x8;
  if (!register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern713 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i2
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern721 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_CODE (x5) != SIGN_EXTEND)
    return -1;
  x6 = XEXP (x3, 1);
  if (GET_CODE (x6) != SIGN_EXTEND)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_CODE (x7) != i1)
    return -1;
  x8 = XEXP (x2, 0);
  if (GET_CODE (x8) != REG
      || REGNO (x8) != 17
      || GET_MODE (x8) != E_CCOmode)
    return -1;
  x9 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x9) != SET)
    return -1;
  x10 = XEXP (x9, 1);
  if (GET_CODE (x10) != i1
      || GET_MODE (x3) != E_CCOmode)
    return -1;
  x11 = XEXP (x5, 0);
  operands[1] = x11;
  x12 = XEXP (x9, 0);
  operands[0] = x12;
  x13 = XEXP (x7, 0);
  if (!rtx_equal_p (x13, operands[1]))
    return -1;
  x14 = XEXP (x10, 0);
  if (!rtx_equal_p (x14, operands[1]))
    return -1;
  x15 = XEXP (x4, 1);
  switch (GET_CODE (x15))
    {
    case SIGN_EXTEND:
      x16 = XEXP (x15, 0);
      operands[2] = x16;
      x17 = XEXP (x7, 1);
      if (!rtx_equal_p (x17, operands[2]))
        return -1;
      x18 = XEXP (x10, 1);
      if (!rtx_equal_p (x18, operands[2]))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_TImode:
          return pattern719 (x1, 
E_DImode, 
E_TImode); /* [-1, 0] */

        case E_POImode:
          if (pattern719 (x1, 
E_TImode, 
E_POImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[3] = x15;
      x17 = XEXP (x7, 1);
      operands[2] = x17;
      x18 = XEXP (x10, 1);
      if (!rtx_equal_p (x18, operands[2]))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_TImode:
          if (pattern720 (x1, 
E_DImode, 
E_TImode) != 0)
            return -1;
          return 2;

        case E_POImode:
          if (pattern720 (x1, 
E_TImode, 
E_POImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern751 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern757 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (GET_CODE (x2))
    {
    case REG:
    case SUBREG:
    case MEM:
      if (!rtx_equal_p (x2, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          return pattern755 (x1, 
E_SImode); /* [-1, 0] */

        case E_DImode:
          if (pattern755 (x1, 
E_DImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case NOT:
      x3 = XEXP (x2, 0);
      if (!rtx_equal_p (x3, operands[1]))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (pattern756 (x1, 
E_SImode) != 0)
            return -1;
          return 2;

        case E_DImode:
          if (pattern756 (x1, 
E_DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern773 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!vector_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V8DFmode:
      if (!nonimmediate_operand (operands[1], E_V8DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern780 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern787 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!memory_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[1], i1)
      || !const0_or_m1_operand (operands[2], i2))
    return -1;
  return 0;
}

int
pattern796 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i3)
      || GET_MODE (x1) != i3)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i2
      || !vector_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern805 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (!pmovzx_parallel (operands[4], E_VOIDmode))
    return -1;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != SUBREG
      || maybe_ne (SUBREG_BYTE (x3), 0))
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != VEC_CONCAT)
    return -1;
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x4, 1);
  operands[2] = x6;
  x7 = XEXP (x2, 1);
  operands[3] = x7;
  x8 = XEXP (x1, 1);
  x9 = XVECEXP (x8, 0, 0);
  operands[5] = x9;
  if (!const_int_operand (operands[5], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V32QImode:
      if (!register_operand (operands[0], E_V32QImode)
          || GET_MODE (x1) != E_V32QImode
          || GET_MODE (x2) != E_V64QImode
          || GET_MODE (x3) != E_V32QImode
          || !const0_operand (operands[3], E_V32QImode))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_V16HImode:
          if (!nonimmediate_operand (operands[1], E_V8HImode)
              || !const0_operand (operands[2], E_V8HImode))
            return -1;
          return 0;

        case E_V8SImode:
          if (!nonimmediate_operand (operands[1], E_V4SImode)
              || !const0_operand (operands[2], E_V4SImode))
            return -1;
          return 1;

        case E_V4DImode:
          if (!nonimmediate_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V2DImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_V64QImode:
      if (!register_operand (operands[0], E_V64QImode)
          || GET_MODE (x1) != E_V64QImode
          || GET_MODE (x2) != E_V128QImode
          || GET_MODE (x3) != E_V64QImode
          || !const0_operand (operands[3], E_V64QImode))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_V32HImode:
          if (!nonimmediate_operand (operands[1], E_V16HImode)
              || !const0_operand (operands[2], E_V16HImode))
            return -1;
          return 3;

        case E_V16SImode:
          if (!nonimmediate_operand (operands[1], E_V8SImode)
              || !const0_operand (operands[2], E_V8SImode))
            return -1;
          return 4;

        case E_V8DImode:
          if (!nonimmediate_operand (operands[1], E_V4DImode)
              || !const0_operand (operands[2], E_V4DImode))
            return -1;
          return 5;

        default:
          return -1;
        }

    case E_V16QImode:
      if (!register_operand (operands[0], E_V16QImode)
          || GET_MODE (x1) != E_V16QImode
          || GET_MODE (x2) != E_V32QImode
          || GET_MODE (x3) != E_V16QImode
          || !const0_operand (operands[3], E_V16QImode))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_V8HImode:
          if (!vector_operand (operands[1], E_V4HImode)
              || !const0_operand (operands[2], E_V4HImode))
            return -1;
          return 6;

        case E_V4SImode:
          if (!vector_operand (operands[1], E_V2SImode)
              || !const0_operand (operands[2], E_V2SImode))
            return -1;
          return 7;

        case E_V2DImode:
          if (!vector_operand (operands[1], E_DImode)
              || !const0_operand (operands[2], E_DImode))
            return -1;
          return 8;

        default:
          return -1;
        }

    case E_V32HImode:
      if (!register_operand (operands[0], E_V32HImode)
          || GET_MODE (x1) != E_V32HImode
          || GET_MODE (x2) != E_V64HImode
          || GET_MODE (x3) != E_V32HImode
          || !const0_operand (operands[3], E_V32HImode))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_V64QImode:
          if (!nonimmediate_operand (operands[1], E_V32QImode)
              || !const0_operand (operands[2], E_V32QImode))
            return -1;
          return 9;

        case E_V16SImode:
          if (!nonimmediate_operand (operands[1], E_V8SImode)
              || !const0_operand (operands[2], E_V8SImode))
            return -1;
          return 10;

        case E_V8DImode:
          if (!nonimmediate_operand (operands[1], E_V4DImode)
              || !const0_operand (operands[2], E_V4DImode))
            return -1;
          return 11;

        default:
          return -1;
        }

    case E_V16HImode:
      if (!register_operand (operands[0], E_V16HImode)
          || GET_MODE (x1) != E_V16HImode
          || GET_MODE (x2) != E_V32HImode
          || GET_MODE (x3) != E_V16HImode
          || !const0_operand (operands[3], E_V16HImode))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_V32QImode:
          if (!nonimmediate_operand (operands[1], E_V16QImode)
              || !const0_operand (operands[2], E_V16QImode))
            return -1;
          return 12;

        case E_V8SImode:
          if (!nonimmediate_operand (operands[1], E_V4SImode)
              || !const0_operand (operands[2], E_V4SImode))
            return -1;
          return 13;

        case E_V4DImode:
          if (!nonimmediate_operand (operands[1], E_V2DImode)
              || !const0_operand (operands[2], E_V2DImode))
            return -1;
          return 14;

        default:
          return -1;
        }

    case E_V8HImode:
      if (!register_operand (operands[0], E_V8HImode)
          || GET_MODE (x1) != E_V8HImode
          || GET_MODE (x2) != E_V16HImode
          || GET_MODE (x3) != E_V8HImode
          || !const0_operand (operands[3], E_V8HImode))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_V16QImode:
          if (!vector_operand (operands[1], E_V8QImode)
              || !const0_operand (operands[2], E_V8QImode))
            return -1;
          return 15;

        case E_V4SImode:
          if (!vector_operand (operands[1], E_V2SImode)
              || !const0_operand (operands[2], E_V2SImode))
            return -1;
          return 16;

        case E_V2DImode:
          if (!vector_operand (operands[1], E_DImode)
              || !const0_operand (operands[2], E_DImode))
            return -1;
          return 17;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern883 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  operands[2] = x3;
  if (!nonimmediate_operand (operands[2], i2))
    return -1;
  x4 = XEXP (x1, 1);
  operands[1] = x4;
  if (!register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern894 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[2] = x4;
  return pattern893 (x3); /* [-1, 0] */
}

int
pattern898 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i2
      || !register_operand (operands[1], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_SImode:
      if (!register_operand (operands[2], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[2], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern910 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V8QImode)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_CODE (x4) != VEC_SELECT
      || GET_MODE (x4) != E_V8QImode)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != PARALLEL
      || XVECLEN (x5, 0) != 8)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x5, 0, 1);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x8 = XVECEXP (x5, 0, 2);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 2])
    return -1;
  x9 = XVECEXP (x5, 0, 3);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x10 = XVECEXP (x5, 0, 4);
  if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 4])
    return -1;
  x11 = XVECEXP (x5, 0, 5);
  if (x11 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x12 = XVECEXP (x5, 0, 6);
  if (x12 != const_int_rtx[MAX_SAVED_CONST_INT + 6])
    return -1;
  x13 = XVECEXP (x5, 0, 7);
  if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 7]
      || !register_operand (operands[0], E_V16QImode)
      || GET_MODE (x1) != E_V16QImode
      || GET_MODE (x2) != E_V8QImode
      || !nonimmediate_operand (operands[1], E_V8HFmode))
    return -1;
  x14 = XEXP (x4, 0);
  operands[2] = x14;
  if (!nonimm_or_0_operand (operands[2], E_V16QImode))
    return -1;
  x15 = XEXP (x2, 2);
  operands[3] = x15;
  x16 = XEXP (x1, 1);
  operands[4] = x16;
  if (!const0_operand (operands[4], E_V8QImode))
    return -1;
  return 0;
}

int
pattern930 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern936 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x1, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern946 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1)
      || !const0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern953 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[2] = x2;
  x3 = XEXP (x1, 1);
  operands[3] = x3;
  if (!general_gr_operand (operands[3], i1))
    return -1;
  x4 = PATTERN (peep2_next_insn (1));
  x5 = XEXP (x4, 1);
  return pattern952 (x5, 
i1); /* [-1, 0] */
}

int
pattern956 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      if (!register_operand (operands[0], E_HImode)
          || GET_MODE (x1) != E_HImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V16QImode:
          if (!nonimm_or_0_operand (operands[1], E_V16QImode)
              || !nonimm_or_0_operand (operands[2], E_V16QImode))
            return -1;
          return 0;

        case E_V16HImode:
          if (!nonimm_or_0_operand (operands[1], E_V16HImode)
              || !nonimm_or_0_operand (operands[2], E_V16HImode))
            return -1;
          return 1;

        case E_V16SImode:
          if (!nonimm_or_0_operand (operands[1], E_V16SImode)
              || !nonimm_or_0_operand (operands[2], E_V16SImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    case E_QImode:
      if (!register_operand (operands[0], E_QImode)
          || GET_MODE (x1) != E_QImode)
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_V8HImode:
          if (!nonimm_or_0_operand (operands[1], E_V8HImode)
              || !nonimm_or_0_operand (operands[2], E_V8HImode))
            return -1;
          return 3;

        case E_V8SImode:
          if (!nonimm_or_0_operand (operands[1], E_V8SImode)
              || !nonimm_or_0_operand (operands[2], E_V8SImode))
            return -1;
          return 4;

        case E_V4SImode:
          if (!nonimm_or_0_operand (operands[1], E_V4SImode)
              || !nonimm_or_0_operand (operands[2], E_V4SImode))
            return -1;
          return 5;

        case E_V8DImode:
          if (!nonimm_or_0_operand (operands[1], E_V8DImode)
              || !nonimm_or_0_operand (operands[2], E_V8DImode))
            return -1;
          return 6;

        case E_V4DImode:
          if (!nonimm_or_0_operand (operands[1], E_V4DImode)
              || !nonimm_or_0_operand (operands[2], E_V4DImode))
            return -1;
          return 7;

        case E_V2DImode:
          if (!nonimm_or_0_operand (operands[1], E_V2DImode)
              || !nonimm_or_0_operand (operands[2], E_V2DImode))
            return -1;
          return 8;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern972 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 2);
  if (GET_CODE (x2) != UNSPEC
      || XVECLEN (x2, 0) != 3
      || XINT (x2, 1) != 59)
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x4 = XEXP (x1, 0);
  operands[3] = x4;
  x5 = XEXP (x1, 1);
  operands[4] = x5;
  x6 = XVECEXP (x2, 0, 0);
  operands[1] = x6;
  x7 = XVECEXP (x2, 0, 1);
  operands[2] = x7;
  switch (GET_MODE (x1))
    {
    case E_V32QImode:
      return pattern971 (x2, 
E_V32QImode, 
E_SImode); /* [-1, 0] */

    case E_V16QImode:
      if (pattern971 (x2, 
E_V16QImode, 
E_HImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern981 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !memory_operand (operands[1], i1)
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], i2))
    return -1;
  return 0;
}

int
pattern985 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V4DImode)
      || GET_MODE (x1) != E_V4DImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_V4DImode
      || !nonimm_or_0_operand (operands[2], E_V4DImode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V4DFmode:
      if (!vector_operand (operands[1], E_V4DFmode))
        return -1;
      return 1;

    case E_V4SFmode:
      if (!vector_operand (operands[1], E_V4SFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern997 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !nonimmediate_operand (operands[2], i1)
      || !reg_or_0_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1006 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_comparison_uns_operator (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1012 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i1)
      || !const48_operand (operands[2], E_SImode))
    return -1;
  return 0;
}

int
pattern1021 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimm_or_0_operand (operands[2], i2)
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1029 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != SUBREG
      || maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x1, 0);
      if (GET_CODE (x8) != ZERO_EXTRACT)
        return -1;
      x9 = XEXP (x8, 1);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x10 = XEXP (x8, 2);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x11 = XEXP (x8, 0);
      operands[0] = x11;
      if (!int248_register_operand (operands[0], E_VOIDmode))
        return -1;
      x12 = XEXP (x5, 0);
      operands[1] = x12;
      if (!int248_register_operand (operands[1], E_VOIDmode))
        return -1;
      x13 = XEXP (x3, 1);
      operands[2] = x13;
      if (!nonmemory_operand (operands[2], E_QImode))
        return -1;
      return pattern1028 (x1); /* [-1, 2] */

    default:
      return -1;
    }
}

int
pattern1042 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x5, 1);
  operands[2] = x7;
  x8 = XEXP (x4, 1);
  operands[3] = x8;
  x9 = XEXP (x3, 1);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_HImode:
      return pattern1041 (x3, 
E_HImode); /* [-1, 0] */

    case E_SImode:
      if (pattern1041 (x3, 
E_SImode) != 0)
        return -1;
      return 1;

    case E_DImode:
      if (pattern1041 (x3, 
E_DImode) != 0)
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1047 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (!register_operand (x3, E_DImode))
    return -1;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != E_SImode)
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  if (!register_operand (x7, E_SImode))
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != E_SImode)
    return -1;
  switch (GET_CODE (x5))
    {
    case DIV:
      return 0;

    case UDIV:
      return 1;

    case MOD:
      return 2;

    case UMOD:
      return 3;

    default:
      return -1;
    }
}

int
pattern1057 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (peep2_current_count < 3
      || GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  operands[2] = x2;
  if (!general_reg_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 0);
  if (!rtx_equal_p (x3, operands[1]))
    return -1;
  x4 = PATTERN (peep2_next_insn (2));
  if (GET_CODE (x4) != SET)
    return -1;
  x5 = XEXP (x4, 1);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  x6 = XEXP (x4, 0);
  if (!rtx_equal_p (x6, operands[2]))
    return -1;
  return 0;
}

int
pattern1065 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_HImode)
      || GET_MODE (x1) != E_HImode)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != E_HImode)
    return -1;
  return pattern740 (); /* [-1, 2] */
}

int
pattern1071 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_carry_flag_unset_operator (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1080 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1087 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_MODE (x2))
    {
    case E_HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_SFmode:
      if (!vector_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_DFmode:
      if (!vector_operand (operands[1], E_V2DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1090 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimm_or_0_operand (operands[2], i1)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!vector_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V4SFmode:
      if (!nonimmediate_operand (operands[1], E_V4SFmode))
        return -1;
      return 1;

    case E_V4DFmode:
      if (!nonimmediate_operand (operands[1], E_V4DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1099 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1107 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[2], i1)
      || !register_operand (operands[1], i1)
      || !avx2_pblendw_operand (operands[3], E_SImode))
    return -1;
  return 0;
}

int
pattern1114 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3, machine_mode i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i4
      || !nonimmediate_operand (operands[2], i3))
    return -1;
  x4 = XEXP (x2, 1);
  return pattern1113 (x4, 
i1, 
i2, 
i3, 
i4); /* [-1, 0] */
}

int
pattern1120 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1126 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !register_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1132 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x3 = XEXP (x1, 1);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x4 = XEXP (x1, 2);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1141 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != 19
      || GET_MODE (x1) != E_SImode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern1146 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1153 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  return pattern1152 (x3); /* [-1, 2] */
}

int
pattern1160 (rtx x1, machine_mode i1, int i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != UNSPEC_VOLATILE
      || XVECLEN (x1, 0) != 1
      || XINT (x1, 1) != i2
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  return 0;
}

int
pattern1166 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[3] = x3;
      x4 = XEXP (x3, 1);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x5 = XEXP (x3, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
          || GET_MODE (x1) != E_QImode)
        return -1;
      x6 = XEXP (x3, 0);
      if (!int248_register_operand (x6, E_VOIDmode))
        return -1;
      return 0;

    default:
      return -1;
    }
}

int
pattern1180 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (!rtx_equal_p (x1, operands[0]))
    return -1;
  x2 = PATTERN (peep2_next_insn (2));
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case SUBREG:
    case MEM:
      if (!rtx_equal_p (x3, operands[1]))
        return -1;
      return 0;

    case REG:
      if (peep2_current_count < 4)
        return -1;
      operands[5] = x3;
      if (!general_reg_operand (operands[5], i1))
        return -1;
      x4 = PATTERN (peep2_next_insn (3));
      if (GET_CODE (x4) != SET)
        return -1;
      x5 = XEXP (x4, 1);
      if (!rtx_equal_p (x5, operands[5]))
        return -1;
      x6 = XEXP (x4, 0);
      if (!rtx_equal_p (x6, operands[1]))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1188 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  operands[3] = x2;
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  if (!int248_register_operand (operands[1], E_VOIDmode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x6 = XEXP (x1, 0);
  switch (GET_MODE (x6))
    {
    case E_HImode:
      if (!extract_operator (operands[3], E_HImode))
        return -1;
      return 0;

    case E_SImode:
      if (!extract_operator (operands[3], E_SImode))
        return -1;
      return 1;

    case E_DImode:
      if (!extract_operator (operands[3], E_DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1202 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2
      || !register_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1208 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HFmode:
      if (!register_operand (operands[1], E_V8HFmode))
        return -1;
      return 0;

    case E_V8SFmode:
      if (!nonimmediate_operand (operands[1], E_V8SFmode))
        return -1;
      return 1;

    case E_V8DFmode:
      if (!nonimmediate_operand (operands[1], E_V8DFmode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1217 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 1);
  operands[2] = x4;
  if (!const_int_operand (operands[2], E_QImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      return pattern1216 (x1, 
E_DImode, 
E_SImode); /* [-1, 0] */

    case E_DImode:
      if (pattern1216 (x1, 
E_TImode, 
E_DImode) != 0)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1222 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[1]))
    return -1;
  x5 = XVECEXP (x1, 0, 0);
  x6 = XEXP (x5, 1);
  x7 = XEXP (x6, 0);
  switch (GET_MODE (x7))
    {
    case E_QImode:
      if (!nonimmediate_operand (operands[1], E_QImode)
          || !nonimmediate_operand (operands[0], E_QImode)
          || GET_MODE (x3) != E_QImode)
        return -1;
      return 0;

    case E_HImode:
      if (!nonimmediate_operand (operands[1], E_HImode)
          || !nonimmediate_operand (operands[0], E_HImode)
          || GET_MODE (x3) != E_HImode)
        return -1;
      return 1;

    case E_SImode:
      if (!nonimmediate_operand (operands[1], E_SImode)
          || !nonimmediate_operand (operands[0], E_SImode)
          || GET_MODE (x3) != E_SImode)
        return -1;
      return 2;

    case E_DImode:
      if (!nonimmediate_operand (operands[1], E_DImode)
          || !nonimmediate_operand (operands[0], E_DImode)
          || GET_MODE (x3) != E_DImode)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1235 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  if (!nonmemory_operand (operands[2], E_QImode))
    return -1;
  x4 = XEXP (x1, 1);
  return pattern376 (x4); /* [-1, 1] */
}

int
pattern1242 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (GET_CODE (x1) != SET)
    return -1;
  x2 = XEXP (x1, 1);
  if (GET_CODE (x2) != PLUS
      || GET_MODE (x2) != E_SImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != REG
      || REGNO (x3) != 7
      || GET_MODE (x3) != E_SImode)
    return -1;
  return 0;
}

int
pattern1246 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vector_all_ones_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || GET_MODE (x1) != i2
      || !vector_operand (operands[0], i1)
      || !const0_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1252 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  if (!int248_register_operand (operands[1], E_VOIDmode))
    return -1;
  x6 = XEXP (x2, 1);
  x7 = XEXP (x6, 0);
  x8 = XEXP (x7, 0);
  operands[2] = x8;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x9 = XEXP (x1, 0);
  switch (GET_CODE (x9))
    {
    case STRICT_LOW_PART:
      x10 = XEXP (x9, 0);
      operands[0] = x10;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      return pattern1251 (); /* [-1, 2] */

    case REG:
    case SUBREG:
      operands[0] = x9;
      if (!register_operand (operands[0], E_QImode))
        return -1;
      res = pattern1251 ();
      if (res >= 0)
        return res + 3; /* [3, 5] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1268 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !register_operand (operands[1], i1))
    return -1;
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[2], i2)
      || !nonimm_or_0_operand (operands[4], i1)
      || !register_operand (operands[5], i3))
    return -1;
  return 0;
}

int
pattern1278 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !nonimmediate_operand (operands[1], i2)
      || !nonimmediate_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i2)
      || !register_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1288 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 8);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 9);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 10);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 11);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1296 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8HFmode)
      || GET_MODE (x1) != E_V8HFmode)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != E_V8HFmode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != E_V8HFmode
      || !nonimm_or_0_operand (operands[2], E_V8HFmode)
      || !register_operand (operands[3], E_QImode))
    return -1;
  switch (GET_MODE (operands[1]))
    {
    case E_V8HImode:
      if (!register_operand (operands[1], E_V8HImode))
        return -1;
      return 0;

    case E_V8SImode:
      if (!register_operand (operands[1], E_V8SImode))
        return -1;
      return 1;

    case E_V8DImode:
      if (!register_operand (operands[1], E_V8DImode))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1308 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!nonimmediate_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!memory_operand (operands[0], E_SImode))
        return -1;
      x5 = XVECEXP (x1, 0, 0);
      x6 = XEXP (x5, 1);
      if (GET_MODE (x6) != E_SImode
          || !memory_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x5 = XVECEXP (x1, 0, 0);
      x6 = XEXP (x5, 1);
      if (GET_MODE (x6) != E_DImode
          || !memory_operand (operands[3], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1321 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  if (maybe_ne (SUBREG_BYTE (x2), 0)
      || GET_MODE (x2) != E_QImode)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_CODE (x3) != AND)
    return -1;
  return pattern698 (x1); /* [-1, 1] */
}

int
pattern1327 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (!register_operand (operands[0], E_SImode)
          || GET_MODE (x1) != E_SImode
          || !nonimmediate_operand (operands[1], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!register_operand (operands[0], E_DImode)
          || GET_MODE (x1) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1338 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!general_reg_operand (operands[0], i1)
      || GET_CODE (x1) != PARALLEL
      || XVECLEN (x1, 0) != 2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_CODE (x2) != SET)
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (GET_CODE (x3) != CLOBBER)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17
      || GET_MODE (x4) != E_CCmode)
    return -1;
  x5 = XEXP (x2, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  x6 = XEXP (x2, 0);
  if (!rtx_equal_p (x6, operands[0]))
    return -1;
  switch (GET_CODE (x5))
    {
    case PLUS:
      x7 = XEXP (x5, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      return 0;

    case IOR:
      x7 = XEXP (x5, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      return 1;

    case XOR:
      x7 = XEXP (x5, 0);
      if (!rtx_equal_p (x7, operands[0]))
        return -1;
      return 2;

    default:
      return -1;
    }
}

int
pattern1355 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !vector_operand (operands[1], i1)
      || !vector_operand (operands[2], i1))
    return -1;
  x3 = XVECEXP (x2, 0, 2);
  if (GET_MODE (x3) != i1
      || !vector_operand (operands[3], i1)
      || !const0_operand (operands[4], i1)
      || !register_operand (operands[5], i2))
    return -1;
  return 0;
}

int
pattern1364 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1)
      || !nonimmediate_operand (operands[3], i1)
      || !const0_operand (operands[4], i1))
    return -1;
  return 0;
}

int
pattern1373 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !bcst_vector_operand (operands[1], i1)
      || pattern1360 (
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1381 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !nonimmediate_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1392 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i2)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i2)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1)
    return -1;
  return 0;
}

int
pattern1400 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x4 = XEXP (x2, 2);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1408 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[2] = x4;
  if (!register_operand (operands[2], E_XFmode))
    return -1;
  x5 = XVECEXP (x3, 0, 1);
  operands[3] = x5;
  if (!register_operand (operands[3], E_XFmode))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  operands[1] = x7;
  if (!register_operand (operands[1], E_XFmode))
    return -1;
  x8 = XEXP (x6, 1);
  x9 = XVECEXP (x8, 0, 0);
  if (!rtx_equal_p (x9, operands[2]))
    return -1;
  x10 = XVECEXP (x8, 0, 1);
  if (!rtx_equal_p (x10, operands[3]))
    return -1;
  return 0;
}

int
pattern1422 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[2] = x4;
  if (!int248_register_operand (operands[2], E_VOIDmode))
    return -1;
  x5 = XEXP (x3, 1);
  operands[3] = x5;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  return pattern198 (x1); /* [-1, 1] */
}

int
pattern1430 (rtx x1, int i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20, x21, x22;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 2);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case PLUS:
      x4 = XEXP (x3, 0);
      if (GET_CODE (x4) != ASHIFT)
        return -1;
      x5 = XEXP (x4, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
        return -1;
      x6 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x6) != SET)
        return -1;
      x7 = XEXP (x6, 1);
      if (GET_CODE (x7) != MEM
          || GET_MODE (x7) != E_BLKmode)
        return -1;
      x8 = XEXP (x6, 0);
      if (GET_CODE (x8) != MEM
          || GET_MODE (x8) != E_BLKmode)
        return -1;
      x9 = XVECEXP (x1, 0, 0);
      x10 = XEXP (x9, 0);
      operands[2] = x10;
      x11 = XVECEXP (x1, 0, 1);
      x12 = XEXP (x11, 1);
      x13 = XEXP (x12, 0);
      x14 = XEXP (x13, 0);
      operands[5] = x14;
      x15 = XEXP (x2, 0);
      operands[1] = x15;
      x16 = XEXP (x3, 1);
      operands[4] = x16;
      x17 = XEXP (x4, 0);
      if (!rtx_equal_p (x17, operands[5]))
        return -1;
      x18 = XEXP (x7, 0);
      if (!rtx_equal_p (x18, operands[4]))
        return -1;
      x19 = XEXP (x8, 0);
      if (!rtx_equal_p (x19, operands[3]))
        return -1;
      x20 = XVECEXP (x1, 0, 4);
      x21 = XEXP (x20, 0);
      if (!rtx_equal_p (x21, operands[5]))
        return -1;
      switch (GET_MODE (operands[2]))
        {
        case E_SImode:
          return pattern1428 (x1, 
E_SImode); /* [-1, 0] */

        case E_DImode:
          if (pattern1428 (x1, 
E_DImode) != 0)
            return -1;
          return 1;

        default:
          return -1;
        }

    case CONST_INT:
      if (XWINT (x3, 0) != 0L)
        return -1;
      x15 = XEXP (x2, 0);
      if (GET_CODE (x15) != MEM
          || GET_MODE (x15) != E_BLKmode)
        return -1;
      x6 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x6) != USE)
        return -1;
      x9 = XVECEXP (x1, 0, 0);
      x10 = XEXP (x9, 0);
      operands[1] = x10;
      x11 = XVECEXP (x1, 0, 1);
      x12 = XEXP (x11, 1);
      x13 = XEXP (x12, 0);
      x14 = XEXP (x13, 0);
      operands[4] = x14;
      x8 = XEXP (x6, 0);
      operands[2] = x8;
      if (!register_operand (operands[2], i2))
        return -1;
      x22 = XEXP (x15, 0);
      if (!rtx_equal_p (x22, operands[3]))
        return -1;
      x20 = XVECEXP (x1, 0, 4);
      x21 = XEXP (x20, 0);
      if (!rtx_equal_p (x21, operands[4]))
        return -1;
      switch (GET_MODE (operands[1]))
        {
        case E_SImode:
          if (pattern1429 (x12, 
E_SImode) != 0)
            return -1;
          return 2;

        case E_DImode:
          if (pattern1429 (x12, 
E_DImode) != 0)
            return -1;
          return 3;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1477 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[0], i1))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 1);
  if (GET_MODE (x7) != i1)
    return -1;
  x8 = XEXP (x7, 0);
  if (GET_MODE (x8) != i1)
    return -1;
  return 0;
}

int
pattern1487 (rtx x1, rtx_code i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != i1)
    return -1;
  x4 = XVECEXP (x1, 0, 0);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XEXP (x4, 1);
  x7 = XEXP (x6, 0);
  x8 = XEXP (x7, 0);
  operands[2] = x8;
  if (!register_operand (operands[2], E_SImode))
    return -1;
  x9 = XEXP (x7, 1);
  operands[3] = x9;
  if (!nonimmediate_operand (operands[3], E_SImode))
    return -1;
  x10 = XEXP (x2, 0);
  operands[0] = x10;
  return pattern1485 (x1); /* [-1, 1] */
}

int
pattern1499 (rtx x1, machine_mode i1, machine_mode i2, machine_mode i3)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2)
    return -1;
  x2 = XEXP (x1, 0);
  if (GET_MODE (x2) != i2
      || !register_operand (operands[1], i2)
      || !register_operand (operands[2], i2)
      || !nonimmediate_operand (operands[3], i1)
      || !register_operand (operands[5], i3))
    return -1;
  return 0;
}

int
pattern1509 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !ix86_carry_flag_unset_operator (operands[2], i1)
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  return 0;
}

int
pattern1517 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case COMPARE:
      x4 = XEXP (x3, 0);
      if (!plusminuslogic_operator (x4, i1))
        return -1;
      operands[3] = x4;
      x5 = XEXP (x3, 1);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x6 = XEXP (x2, 0);
      if (GET_CODE (x6) != REG
          || REGNO (x6) != 17)
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x7) != SET)
        return -1;
      x8 = XEXP (x4, 1);
      operands[2] = x8;
      if (!nonmemory_operand (operands[2], i1))
        return -1;
      x9 = XEXP (x4, 0);
      if (!rtx_equal_p (x9, operands[0]))
        return -1;
      x10 = XEXP (x7, 1);
      if (!rtx_equal_p (x10, operands[3]))
        return -1;
      x11 = XEXP (x7, 0);
      if (!rtx_equal_p (x11, operands[0]))
        return -1;
      return 0;

    case PLUS:
    case MINUS:
    case AND:
    case IOR:
    case XOR:
      if (peep2_current_count < 4)
        return -1;
      operands[3] = x3;
      if (!plusminuslogic_operator (operands[3], E_SImode))
        return -1;
      x7 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x7) != CLOBBER)
        return -1;
      x11 = XEXP (x7, 0);
      if (GET_CODE (x11) != REG
          || REGNO (x11) != 17
          || GET_MODE (x11) != E_CCmode)
        return -1;
      x6 = XEXP (x2, 0);
      operands[4] = x6;
      if (!register_operand (operands[4], E_SImode))
        return -1;
      x5 = XEXP (x3, 1);
      operands[2] = x5;
      if (!nonmemory_operand (operands[2], E_SImode))
        return -1;
      x4 = XEXP (x3, 0);
      if (!rtx_equal_p (x4, operands[4]))
        return -1;
      x12 = PATTERN (peep2_next_insn (3));
      if (GET_CODE (x12) != SET)
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1545 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  x6 = XEXP (x5, 0);
  operands[1] = x6;
  x7 = XEXP (x3, 1);
  x8 = XEXP (x7, 0);
  x9 = XEXP (x8, 0);
  if (!rtx_equal_p (x9, operands[1]))
    return -1;
  x10 = XVECEXP (x1, 0, 1);
  x11 = XEXP (x10, 1);
  x12 = XEXP (x11, 0);
  if (!rtx_equal_p (x12, operands[1]))
    return -1;
  x13 = XEXP (x4, 1);
  switch (GET_CODE (x13))
    {
    case SIGN_EXTEND:
      x14 = XEXP (x13, 0);
      operands[2] = x14;
      x15 = XEXP (x8, 1);
      if (!rtx_equal_p (x15, operands[2]))
        return -1;
      x16 = XEXP (x11, 1);
      if (!rtx_equal_p (x16, operands[2]))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_HImode:
          return pattern1543 (x1, 
E_QImode, 
E_HImode); /* [-1, 0] */

        case E_SImode:
          if (pattern1543 (x1, 
E_HImode, 
E_SImode) != 0)
            return -1;
          return 1;

        case E_DImode:
          if (GET_MODE (x5) != E_DImode
              || !nonimmediate_operand (operands[1], E_SImode)
              || GET_MODE (x13) != E_DImode
              || !x86_64_sext_operand (operands[2], E_SImode)
              || pattern718 (x1, 
E_SImode, 
E_DImode) != 0)
            return -1;
          return 2;

        case E_TImode:
          if (GET_MODE (x5) != E_TImode
              || !nonimmediate_operand (operands[1], E_DImode)
              || GET_MODE (x13) != E_TImode
              || pattern718 (x1, 
E_DImode, 
E_TImode) != 0)
            return -1;
          return 3;

        case E_POImode:
          if (pattern719 (x1, 
E_TImode, 
E_POImode) != 0)
            return -1;
          return 4;

        default:
          return -1;
        }

    case CONST_INT:
    case CONST_WIDE_INT:
      operands[3] = x13;
      x15 = XEXP (x8, 1);
      operands[2] = x15;
      x16 = XEXP (x11, 1);
      if (!rtx_equal_p (x16, operands[2]))
        return -1;
      switch (GET_MODE (x4))
        {
        case E_HImode:
          if (pattern1544 (x1, 
E_QImode, 
E_HImode) != 0)
            return -1;
          return 5;

        case E_SImode:
          if (pattern1544 (x1, 
E_HImode, 
E_SImode) != 0)
            return -1;
          return 6;

        case E_DImode:
          if (pattern1544 (x1, 
E_SImode, 
E_DImode) != 0)
            return -1;
          return 7;

        case E_TImode:
          if (GET_MODE (x5) != E_TImode
              || !nonimmediate_operand (operands[1], E_DImode)
              || pattern718 (x1, 
E_DImode, 
E_TImode) != 0)
            return -1;
          return 8;

        case E_POImode:
          if (pattern720 (x1, 
E_TImode, 
E_POImode) != 0)
            return -1;
          return 9;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1593 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !vsib_mem_operator (operands[5], i1))
    return -1;
  switch (GET_MODE (operands[6]))
    {
    case E_HImode:
      x2 = XVECEXP (x1, 0, 2);
      x3 = XEXP (x2, 0);
      return pattern1592 (x3, 
E_V16SImode, 
E_HImode); /* [-1, 1] */

    case E_QImode:
      x2 = XVECEXP (x1, 0, 2);
      x3 = XEXP (x2, 0);
      res = pattern1592 (x3, 
E_V8DImode, 
E_QImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1605 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (!rtx_equal_p (x2, operands[2]))
    return -1;
  x3 = XEXP (x1, 1);
  if (!rtx_equal_p (x3, operands[3]))
    return -1;
  switch (GET_CODE (operands[3]))
    {
    case REG:
    case SUBREG:
    case MEM:
      if (!nonimmediate_operand (operands[3], E_SImode))
        return -1;
      return 0;

    case CONST_INT:
      if (!const_int_operand (operands[3], E_SImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1615 (rtx x1, int *pnum_clobbers)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  if (!rtx_equal_p (x4, operands[2]))
    return -1;
  x5 = XEXP (x3, 1);
  if (!rtx_equal_p (x5, operands[3]))
    return -1;
  x6 = XVECEXP (x1, 0, 2);
  return pattern1553 (x6, pnum_clobbers); /* [-1, 2] */
}

int
pattern1626 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !register_operand (operands[1], i1)
      || !register_operand (operands[2], i1)
      || !nonimm_or_0_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1634 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (GET_MODE (x2) != i1)
    return -1;
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_MODE (x4) != i1
      || !nonimmediate_operand (operands[1], i1)
      || !register_operand (operands[2], i1))
    return -1;
  x5 = XEXP (x3, 2);
  if (GET_MODE (x5) != i1
      || !register_operand (operands[3], i1))
    return -1;
  return 0;
}

int
pattern1645 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[2], i1)
      || !register_operand (operands[3], i1)
      || !register_operand (operands[0], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 1);
  if (GET_MODE (x3) != i1
      || !register_operand (operands[1], i1))
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  x5 = XEXP (x4, 1);
  if (GET_MODE (x5) != i1)
    return -1;
  return 0;
}

int
pattern1656 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_7_operand (operands[4], E_VOIDmode)
      || !const_0_to_7_operand (operands[5], E_VOIDmode)
      || !const_0_to_7_operand (operands[6], E_VOIDmode)
      || !const_8_to_15_operand (operands[7], E_VOIDmode)
      || !const_8_to_15_operand (operands[8], E_VOIDmode)
      || !const_8_to_15_operand (operands[9], E_VOIDmode)
      || !const_8_to_15_operand (operands[10], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1665 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  if (GET_MODE (x3) != i1)
    return -1;
  x4 = XEXP (x2, 1);
  if (GET_MODE (x4) != i1)
    return -1;
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i1)
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1)
    return -1;
  x8 = XEXP (x6, 1);
  if (GET_MODE (x8) != i1)
    return -1;
  x9 = XEXP (x8, 0);
  if (GET_MODE (x9) != i1)
    return -1;
  return 0;
}

int
pattern1675 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XVECEXP (x3, 0, 1);
  operands[4] = x4;
  if (!const_int_operand (operands[4], E_SImode))
    return -1;
  x5 = XEXP (x2, 0);
  if (!rtx_equal_p (x5, operands[0]))
    return -1;
  x6 = XVECEXP (x1, 0, 1);
  x7 = XEXP (x6, 1);
  x8 = XEXP (x7, 0);
  if (!rtx_equal_p (x8, operands[1]))
    return -1;
  x9 = XEXP (x7, 1);
  if (!rtx_equal_p (x9, operands[0]))
    return -1;
  x10 = XEXP (x6, 0);
  if (!rtx_equal_p (x10, operands[1]))
    return -1;
  x11 = PATTERN (peep2_next_insn (2));
  return pattern1518 (x11); /* [-1, 0] */
}

int
pattern1688 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V4SImode:
      if (!register_operand (operands[3], E_V4SImode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1694 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[0], i1))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_V8SImode:
      if (!register_operand (operands[2], E_V8SImode))
        return -1;
      return 0;

    case E_V8DImode:
      if (!register_operand (operands[2], E_V8DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1702 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i2)
      || GET_MODE (x1) != i2
      || !vsib_mem_operator (operands[5], i1))
    return -1;
  switch (GET_MODE (operands[6]))
    {
    case E_HImode:
      x2 = XVECEXP (x1, 0, 2);
      x3 = XEXP (x2, 0);
      return pattern1701 (x3, 
E_HImode, 
E_V16SImode); /* [-1, 1] */

    case E_QImode:
      x2 = XVECEXP (x1, 0, 2);
      x3 = XEXP (x2, 0);
      res = pattern1701 (x3, 
E_QImode, 
E_V8DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1715 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (maybe_ne (SUBREG_BYTE (x4), 0)
      || GET_MODE (x4) != E_QImode)
    return -1;
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case SIGN_EXTRACT:
    case ZERO_EXTRACT:
      operands[4] = x5;
      x6 = XEXP (x5, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x7 = XEXP (x5, 2);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
        return -1;
      x8 = XEXP (x5, 0);
      operands[2] = x8;
      if (!int248_register_operand (operands[2], E_VOIDmode))
        return -1;
      x9 = XEXP (x1, 0);
      switch (GET_MODE (x9))
        {
        case E_HImode:
          if (GET_MODE (x2) != E_HImode
              || !extract_operator (operands[3], E_HImode)
              || !extract_operator (operands[4], E_HImode))
            return -1;
          return 0;

        case E_SImode:
          if (GET_MODE (x2) != E_SImode
              || !extract_operator (operands[3], E_SImode)
              || !extract_operator (operands[4], E_SImode))
            return -1;
          return 1;

        case E_DImode:
          if (GET_MODE (x2) != E_DImode
              || !extract_operator (operands[3], E_DImode)
              || !extract_operator (operands[4], E_DImode))
            return -1;
          return 2;

        default:
          return -1;
        }

    default:
      return -1;
    }
}

int
pattern1735 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (GET_MODE (x1) != i1
      || !ix86_carry_flag_operator (operands[3], i1)
      || !nonimmediate_operand (operands[1], i1)
      || !x86_64_general_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1741 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], E_V8SFmode)
      || GET_MODE (x1) != E_V8SFmode)
    return -1;
  x2 = XEXP (x1, 0);
  switch (GET_MODE (x2))
    {
    case E_V8HFmode:
      if (!memory_operand (operands[1], E_V16HFmode))
        return -1;
      return 0;

    case E_V8BFmode:
      if (!memory_operand (operands[1], E_V16BFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1752 (rtx x1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 1);
  if (XWINT (x2, 0) != 1L)
    return -1;
  x3 = XVECEXP (x1, 0, 2);
  if (XWINT (x3, 0) != 2L)
    return -1;
  x4 = XVECEXP (x1, 0, 3);
  if (XWINT (x4, 0) != 3L)
    return -1;
  x5 = XVECEXP (x1, 0, 4);
  if (XWINT (x5, 0) != 4L)
    return -1;
  x6 = XVECEXP (x1, 0, 5);
  if (XWINT (x6, 0) != 5L)
    return -1;
  x7 = XVECEXP (x1, 0, 6);
  if (XWINT (x7, 0) != 6L)
    return -1;
  x8 = XVECEXP (x1, 0, 7);
  if (XWINT (x8, 0) != 7L)
    return -1;
  x9 = XVECEXP (x1, 0, 8);
  if (XWINT (x9, 0) != 8L)
    return -1;
  x10 = XVECEXP (x1, 0, 9);
  if (XWINT (x10, 0) != 9L)
    return -1;
  x11 = XVECEXP (x1, 0, 10);
  if (XWINT (x11, 0) != 10L)
    return -1;
  x12 = XVECEXP (x1, 0, 11);
  if (XWINT (x12, 0) != 11L)
    return -1;
  x13 = XVECEXP (x1, 0, 12);
  if (XWINT (x13, 0) != 12L)
    return -1;
  x14 = XVECEXP (x1, 0, 13);
  if (XWINT (x14, 0) != 13L)
    return -1;
  x15 = XVECEXP (x1, 0, 14);
  if (XWINT (x15, 0) != 14L)
    return -1;
  x16 = XVECEXP (x1, 0, 15);
  if (XWINT (x16, 0) != 15L)
    return -1;
  return 0;
}

int
pattern1770 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[3], i1))
    return -1;
  switch (GET_MODE (x1))
    {
    case E_SImode:
      if (!vsib_address_operand (operands[4], E_SImode))
        return -1;
      return 0;

    case E_DImode:
      if (!vsib_address_operand (operands[4], E_DImode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1777 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[0], i1)
      || GET_MODE (x1) != i1
      || !register_operand (operands[2], i1)
      || !vsib_mem_operator (operands[7], i2)
      || !register_operand (operands[5], i1)
      || !scratch_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 1);
  x3 = XEXP (x2, 0);
  switch (GET_MODE (x3))
    {
    case E_SImode:
      return pattern1776 (
E_SImode); /* [-1, 1] */

    case E_DImode:
      res = pattern1776 (
E_DImode);
      if (res >= 0)
        return res + 2; /* [2, 3] */
      return -1;

    default:
      return -1;
    }
}

int
pattern1790 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  if (!const_int_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  if (XVECLEN (x3, 0) != 4
      || XINT (x3, 1) != 109)
    return -1;
  x4 = XVECEXP (x1, 0, 1);
  x5 = XEXP (x4, 1);
  if (GET_CODE (x5) != UNSPEC_VOLATILE
      || XVECLEN (x5, 0) != 1
      || XINT (x5, 1) != 109)
    return -1;
  x6 = XVECEXP (x5, 0, 0);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x7 = XVECEXP (x1, 0, 2);
  if (GET_CODE (x7) != SET)
    return -1;
  x8 = XEXP (x7, 1);
  if (GET_CODE (x8) != UNSPEC_VOLATILE
      || XVECLEN (x8, 0) != 1
      || XINT (x8, 1) != 109
      || GET_MODE (x8) != E_CCZmode)
    return -1;
  x9 = XVECEXP (x8, 0, 0);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x10 = XEXP (x7, 0);
  if (GET_CODE (x10) != REG
      || REGNO (x10) != 17
      || GET_MODE (x10) != E_CCZmode)
    return -1;
  x11 = XEXP (x2, 0);
  operands[2] = x11;
  x12 = XVECEXP (x3, 0, 0);
  operands[3] = x12;
  x13 = XVECEXP (x3, 0, 2);
  operands[4] = x13;
  x14 = XVECEXP (x3, 0, 3);
  operands[5] = x14;
  if (!const_int_operand (operands[5], E_SImode))
    return -1;
  x15 = XVECEXP (x3, 0, 1);
  if (!rtx_equal_p (x15, operands[2]))
    return -1;
  x16 = XEXP (x4, 0);
  if (!rtx_equal_p (x16, operands[3]))
    return -1;
  x17 = PATTERN (peep2_next_insn (2));
  x18 = XEXP (x17, 1);
  x19 = XEXP (x18, 0);
  if (!rtx_equal_p (x19, operands[2]))
    return -1;
  x20 = XEXP (x18, 1);
  if (!rtx_equal_p (x20, operands[1]))
    return -1;
  switch (GET_MODE (operands[2]))
    {
    case E_QImode:
      return pattern1789 (x1, 
E_QImode); /* [-1, 0] */

    case E_HImode:
      if (pattern1789 (x1, 
E_HImode) != 0)
        return -1;
      return 1;

    case E_SImode:
      if (pattern1789 (x1, 
E_SImode) != 0)
        return -1;
      return 2;

    case E_DImode:
      if (pattern1789 (x1, 
E_DImode) != 0)
        return -1;
      return 3;

    default:
      return -1;
    }
}

int
pattern1819 (machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!vsib_address_operand (operands[2], i1))
    return -1;
  switch (GET_MODE (operands[3]))
    {
    case E_V8SImode:
      if (!register_operand (operands[3], E_V8SImode)
          || !register_operand (operands[4], E_V8SFmode))
        return -1;
      return 0;

    case E_V4DImode:
      if (!register_operand (operands[3], E_V4DImode)
          || !register_operand (operands[4], E_V4SFmode))
        return -1;
      return 1;

    default:
      return -1;
    }
}

int
pattern1826 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!nonimmediate_operand (operands[1], i1))
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 1);
  if (GET_MODE (x4) != i2
      || !ix86_carry_flag_operator (operands[4], i2)
      || !const_scalar_int_operand (operands[6], i2)
      || !nonimmediate_operand (operands[0], i1))
    return -1;
  x5 = XVECEXP (x1, 0, 1);
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i1)
    return -1;
  x7 = XEXP (x6, 0);
  if (GET_MODE (x7) != i1
      || !ix86_carry_flag_operator (operands[5], i1)
      || !x86_64_immediate_operand (operands[2], i1))
    return -1;
  return 0;
}

int
pattern1837 ()
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  int res ATTRIBUTE_UNUSED;
  if (!const_0_to_15_operand (operands[2], E_VOIDmode)
      || !const_0_to_15_operand (operands[3], E_VOIDmode)
      || !const_0_to_15_operand (operands[4], E_VOIDmode)
      || !const_0_to_15_operand (operands[5], E_VOIDmode)
      || !const_0_to_15_operand (operands[6], E_VOIDmode)
      || !const_0_to_15_operand (operands[7], E_VOIDmode)
      || !const_0_to_15_operand (operands[8], E_VOIDmode)
      || !const_0_to_15_operand (operands[9], E_VOIDmode)
      || !const_0_to_15_operand (operands[10], E_VOIDmode)
      || !const_0_to_15_operand (operands[11], E_VOIDmode)
      || !const_0_to_15_operand (operands[12], E_VOIDmode)
      || !const_0_to_15_operand (operands[13], E_VOIDmode)
      || !const_0_to_15_operand (operands[14], E_VOIDmode)
      || !const_0_to_15_operand (operands[15], E_VOIDmode)
      || !const_0_to_15_operand (operands[16], E_VOIDmode)
      || !const_0_to_15_operand (operands[17], E_VOIDmode))
    return -1;
  return 0;
}

int
pattern1845 (rtx x1, int i1, int i2, int i3, int i4)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 28);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + i4])
    return -1;
  x3 = XVECEXP (x1, 0, 29);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + i3])
    return -1;
  x4 = XVECEXP (x1, 0, 30);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + i2])
    return -1;
  x5 = XVECEXP (x1, 0, 31);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + i1])
    return -1;
  return 0;
}

int
pattern1850 (rtx x1, machine_mode i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  if (!register_operand (operands[4], i1)
      || GET_MODE (x1) != i1
      || !nonmemory_operand (operands[2], i1))
    return -1;
  x2 = PATTERN (peep2_next_insn (3));
  x3 = XEXP (x2, 1);
  if (!rtx_equal_p (x3, operands[4]))
    return -1;
  x4 = PATTERN (peep2_next_insn (4));
  x5 = XEXP (x4, 1);
  x6 = XEXP (x5, 0);
  operands[5] = x6;
  x7 = XEXP (x5, 1);
  operands[6] = x7;
  return 0;
}

int
pattern1857 (rtx x1, machine_mode i1, machine_mode i2)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  if (GET_MODE (x5) != i2
      || !ix86_carry_flag_operator (operands[4], i2))
    return -1;
  x6 = XEXP (x5, 1);
  if (GET_MODE (x6) != i2
      || !nonimmediate_operand (operands[1], i1))
    return -1;
  x7 = XEXP (x4, 1);
  if (GET_MODE (x7) != i2
      || !x86_64_sext_operand (operands[2], i1)
      || pattern1855 (x1, 
i1, 
i2) != 0)
    return -1;
  return 0;
}

int
pattern1865 (rtx x1, int i1)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  int res ATTRIBUTE_UNUSED;
  if (XVECLEN (x1, 0) != i1)
    return -1;
  x2 = XVECEXP (x1, 0, 0);
  if (x2 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
    return -1;
  x3 = XVECEXP (x1, 0, 1);
  if (x3 != const_int_rtx[MAX_SAVED_CONST_INT + 3])
    return -1;
  x4 = XVECEXP (x1, 0, 2);
  if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 5])
    return -1;
  x5 = XVECEXP (x1, 0, 3);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 7])
    return -1;
  x6 = XVECEXP (x1, 0, 4);
  if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 9])
    return -1;
  x7 = XVECEXP (x1, 0, 5);
  if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 11])
    return -1;
  x8 = XVECEXP (x1, 0, 6);
  if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 13])
    return -1;
  x9 = XVECEXP (x1, 0, 7);
  if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 15])
    return -1;
  return 0;
}

 int
recog_1 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != REG
      || REGNO (x4) != 17)
    return -1;
  x5 = XEXP (x3, 1);
  if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
    return -1;
  x6 = XEXP (x2, 1);
  switch (GET_CODE (x6))
    {
    case COMPARE:
      if (GET_MODE (x6) != E_CCmode)
        return -1;
      x7 = XEXP (x6, 0);
      if (GET_CODE (x7) != MINUS)
        return -1;
      x8 = XEXP (x6, 1);
      if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != UNSPEC
          || XVECLEN (x9, 0) != 1
          || XINT (x9, 1) != 109
          || GET_MODE (x9) != E_CCmode)
        return -1;
      x10 = XEXP (x1, 0);
      operands[0] = x10;
      if (!flags_reg_operand (operands[0], E_CCmode)
          || GET_MODE (x2) != E_CCmode
          || !comparison_operator (operands[1], E_VOIDmode)
          || GET_MODE (x4) != E_CCmode)
        return -1;
      x11 = XEXP (x7, 0);
      operands[2] = x11;
      x12 = XEXP (x7, 1);
      operands[3] = x12;
      x13 = XVECEXP (x9, 0, 0);
      operands[4] = x13;
      if (!const_0_to_15_operand (operands[4], E_SImode))
        return -1;
      switch (GET_MODE (x7))
        {
        case E_QImode:
          if (!nonimmediate_operand (operands[2], E_QImode)
              || !general_operand (operands[3], E_QImode)
              || !
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 1; /* ccmpqi */

        case E_HImode:
          if (!nonimmediate_operand (operands[2], E_HImode)
              || !general_operand (operands[3], E_HImode)
              || !
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 2; /* ccmphi */

        case E_SImode:
          if (!nonimmediate_operand (operands[2], E_SImode)
              || !x86_64_general_operand (operands[3], E_SImode)
              || !
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP))
            return -1;
          return 3; /* ccmpsi */

        case E_DImode:
          if (!nonimmediate_operand (operands[2], E_DImode)
              || !x86_64_general_operand (operands[3], E_DImode)
              || !(
#line 1539 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_CCMP) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4; /* ccmpdi */

        default:
          return -1;
        }

    case LABEL_REF:
      x9 = XEXP (x2, 2);
      if (GET_CODE (x9) != PC)
        return -1;
      x10 = XEXP (x1, 0);
      if (GET_CODE (x10) != PC
          || !ix86_comparison_operator (operands[1], E_VOIDmode))
        return -1;
      x7 = XEXP (x6, 0);
      operands[0] = x7;
      return 1458; /* *jcc */

    case REG:
    case SUBREG:
    case MEM:
      operands[2] = x6;
      x10 = XEXP (x1, 0);
      operands[0] = x10;
      x9 = XEXP (x2, 2);
      operands[3] = x9;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (pattern1186 (x2, 
E_HImode) != 0
              || !
#line 26357 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1803; /* *movhicc_noc */

        case E_QImode:
          if (pattern1187 (x2) != 0
              || !
#line 26431 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE && !TARGET_PARTIAL_REG_STALL))
            return -1;
          return 1808; /* *movqicc_noc */

        case E_XFmode:
          if (!register_operand (operands[0], E_XFmode)
              || GET_MODE (x2) != E_XFmode
              || !fcmov_comparison_operator (operands[1], E_VOIDmode)
              || !register_operand (operands[2], E_XFmode)
              || !register_operand (operands[3], E_XFmode)
              || !
#line 26625 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE))
            return -1;
          return 1810; /* *movxfcc_1 */

        case E_DFmode:
          if (!register_operand (operands[0], E_DFmode)
              || pattern1245 (x2, 
E_DFmode) != 0
              || !
#line 26640 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1811; /* *movdfcc_1 */

        case E_SFmode:
          if (!register_operand (operands[0], E_SFmode)
              || pattern1245 (x2, 
E_SFmode) != 0
              || !
#line 26675 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && TARGET_CMOVE
   && !(MEM_P (operands[2]) && MEM_P (operands[3]))))
            return -1;
          return 1812; /* *movsfcc_1_387 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_14 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XVECLEN (x2, 0))
    {
    case 1:
      return recog_13 (x1, insn, pnum_clobbers);

    case 2:
      return recog_12 (x1, insn, pnum_clobbers);

    case 3:
      switch (XINT (x2, 1))
        {
        case 39:
          if (pnum_clobbers == NULL
              || GET_MODE (x2) != E_CCGZmode)
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          if (GET_CODE (x3) != LTU)
            return -1;
          x4 = XEXP (x3, 0);
          if (GET_CODE (x4) != REG
              || REGNO (x4) != 17
              || GET_MODE (x4) != E_CCmode)
            return -1;
          x5 = XEXP (x3, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x6 = XEXP (x1, 0);
          if (GET_CODE (x6) != REG
              || REGNO (x6) != 17
              || GET_MODE (x6) != E_CCGZmode)
            return -1;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          switch (GET_MODE (operands[1]))
            {
            case E_SImode:
              if (!register_operand (operands[1], E_SImode)
                  || !x86_64_general_operand (operands[2], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 521; /* subsi3_carry_ccgz */

            case E_DImode:
              if (!register_operand (operands[1], E_DImode)
                  || !x86_64_general_operand (operands[2], E_DImode)
                  || GET_MODE (x3) != E_DImode
                  || !
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 522; /* subdi3_carry_ccgz */

            default:
              return -1;
            }

        case 59:
          return recog_11 (x1, insn, pnum_clobbers);

        case 48:
          if (GET_MODE (x2) != E_HFmode)
            return -1;
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          if (!nonimmediate_operand (operands[0], E_HFmode))
            return -1;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          if (!nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          if (!nonimm_or_0_operand (operands[2], E_HFmode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!register_operand (operands[3], E_QImode)
              || !
#line 26591 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
            return -1;
          return 1809; /* movhf_mask */

        case 51:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          x3 = XVECEXP (x2, 0, 2);
          switch (GET_CODE (x3))
            {
            case LT:
              switch (pattern735 (x2))
                {
                case 0:
                  if (
#line 26824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[3])
      && rtx_equal_p (operands[2], operands[4]))
  && ix86_pre_reload_split ()))
                    return 1827; /* *ieee_maxsf3_1 */
                  if (!
#line 26845 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[4])
      && rtx_equal_p (operands[2], operands[3]))
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1829; /* *ieee_minsf3_1 */

                case 1:
                  if (
#line 26824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[3])
      && rtx_equal_p (operands[2], operands[4]))
  && ix86_pre_reload_split ()))
                    return 1828; /* *ieee_maxdf3_1 */
                  if (!
#line 26845 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
  && (rtx_equal_p (operands[1], operands[4])
      && rtx_equal_p (operands[2], operands[3]))
  && ix86_pre_reload_split ()))
                    return -1;
                  return 1830; /* *ieee_mindf3_1 */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              operands[3] = x3;
              switch (GET_MODE (operands[0]))
                {
                case E_V2SFmode:
                  if (pattern957 (x2, 
E_V2SFmode) == 0
                      && 
#line 1317 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                    return 2075; /* mmx_blendvps */
                  break;

                case E_V8QImode:
                  if (pattern957 (x2, 
E_V8QImode) == 0
                      && 
#line 4319 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                    return 2241; /* mmx_pblendvb_v8qi */
                  break;

                case E_V4QImode:
                  if (pattern957 (x2, 
E_V4QImode) == 0
                      && 
#line 4395 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2245; /* mmx_pblendvb_v4qi */
                  break;

                case E_V2QImode:
                  if (pattern957 (x2, 
E_V2QImode) == 0
                      && 
#line 4395 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2246; /* mmx_pblendvb_v2qi */
                  break;

                case E_V2HImode:
                  if (pattern957 (x2, 
E_V2HImode) == 0
                      && 
#line 4395 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
                    return 2247; /* mmx_pblendvb_v2hi */
                  break;

                case E_SFmode:
                  if (pattern957 (x2, 
E_SFmode) == 0
                      && 
#line 23547 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8614; /* sse4_1_blendvss */
                  break;

                case E_DFmode:
                  if (pattern957 (x2, 
E_DFmode) == 0
                      && 
#line 23547 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))
                    return 8615; /* sse4_1_blendvsd */
                  break;

                default:
                  break;
                }
              if (GET_CODE (x3) != SUBREG)
                return -1;
              switch (pattern845 (x2))
                {
                case 0:
                  if (!
#line 4371 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2243; /* *mmx_pblendvb_v8qi_2 */

                case 1:
                  if (!
#line 4371 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2244; /* *mmx_pblendvb_v8qi_2 */

                case 2:
                  if (!
#line 4447 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2251; /* *mmx_pblendvb_v4qi_2 */

                default:
                  return -1;
                }

            case EQ:
              switch (pattern737 (x2))
                {
                case 0:
                  if (!
#line 4343 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE && ix86_pre_reload_split ()))
                    return -1;
                  return 2242; /* *mmx_pblendvb_v8qi_1 */

                case 1:
                  if (!
#line 4419 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2248; /* *mmx_pblendvb_v4qi_1 */

                case 2:
                  if (!
#line 4419 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2249; /* *mmx_pblendvb_v2qi_1 */

                case 3:
                  if (!
#line 4419 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2 && ix86_pre_reload_split ()))
                    return -1;
                  return 2250; /* *mmx_pblendvb_v2hi_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 50:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[2] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[1] = x8;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V2SFmode:
              if (pattern958 (x2, 
E_V2SFmode) != 0
                  || !
#line 1261 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                return -1;
              return 2072; /* sse4_1_insertps_v2sf */

            case E_V2SImode:
              if (pattern958 (x2, 
E_V2SImode) != 0
                  || !
#line 1261 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
                return -1;
              return 2073; /* sse4_1_insertps_v2si */

            default:
              return -1;
            }

        case 53:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          x3 = XVECEXP (x2, 0, 2);
          operands[3] = x3;
          if (!nonimmediate_operand (operands[3], E_V16QImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8QImode:
              if (pattern959 (x2, 
E_V8QImode) != 0
                  || !
#line 4517 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP && TARGET_MMX_WITH_SSE))
                return -1;
              return 2263; /* mmx_ppermv64 */

            case E_V4QImode:
              if (pattern959 (x2, 
E_V4QImode) != 0
                  || !
#line 4529 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_XOP))
                return -1;
              return 2264; /* mmx_ppermv32 */

            default:
              return -1;
            }

        case 47:
          if (GET_MODE (x2) != E_V8QImode)
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          if (GET_CODE (x3) != MEM
              || GET_MODE (x3) != E_V8QImode)
            return -1;
          x6 = XEXP (x1, 0);
          if (GET_CODE (x6) != MEM
              || GET_MODE (x6) != E_V8QImode)
            return -1;
          x9 = XEXP (x6, 0);
          operands[0] = x9;
          x7 = XVECEXP (x2, 0, 0);
          operands[1] = x7;
          switch (pattern1060 (x2, 
E_V8QImode))
            {
            case 0:
              if (!(
#line 6865 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE || TARGET_3DNOW_A) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
                return -1;
              return 2385; /* *mmx_maskmovq */

            case 1:
              if (!(
#line 6865 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE || TARGET_3DNOW_A) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
                return -1;
              return 2386; /* *mmx_maskmovq */

            default:
              return -1;
            }

        case 157:
          x6 = XEXP (x1, 0);
          operands[0] = x6;
          x7 = XVECEXP (x2, 0, 0);
          switch (GET_CODE (x7))
            {
            case CONST_INT:
            case CONST_DOUBLE:
            case CONST_VECTOR:
            case REG:
            case SUBREG:
            case MEM:
              operands[1] = x7;
              x3 = XVECEXP (x2, 0, 2);
              if (GET_CODE (x3) != CONST_INT)
                return -1;
              x8 = XVECEXP (x2, 0, 1);
              operands[2] = x8;
              if (XWINT (x3, 0) == 0L)
                {
                  switch (pattern956 (x2))
                    {
                    case 0:
                      if ((
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3462; /* *avx512vl_eqv16qi3_1 */
                      break;

                    case 1:
                      if ((
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3474; /* *avx512vl_eqv16hi3_1 */
                      break;

                    case 2:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 3530; /* *avx512f_eqv16si3_1 */
                      break;

                    case 3:
                      if ((
#line 4585 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3478; /* *avx512vl_eqv8hi3_1 */
                      break;

                    case 4:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3534; /* *avx512vl_eqv8si3_1 */
                      break;

                    case 5:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3538; /* *avx512vl_eqv4si3_1 */
                      break;

                    case 6:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                        return 3542; /* *avx512f_eqv8di3_1 */
                      break;

                    case 7:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3546; /* *avx512vl_eqv4di3_1 */
                      break;

                    case 8:
                      if ((
#line 4674 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[1]) && MEM_P (operands[2]))) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                        return 3550; /* *avx512vl_eqv2di3_1 */
                      break;

                    default:
                      break;
                    }
                }
              operands[3] = x3;
              if (!const_0_to_7_operand (operands[3], E_SImode))
                return -1;
              switch (pattern67 (x2))
                {
                case 0:
                  if (!(
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3482; /* avx512vl_ucmpv16qi3 */

                case 1:
                  if (!(
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3488; /* avx512vl_ucmpv16hi3 */

                case 2:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3552; /* avx512f_ucmpv16si3 */

                case 3:
                  if (!(
#line 4600 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3490; /* avx512vl_ucmpv8hi3 */

                case 4:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3554; /* avx512vl_ucmpv8si3 */

                case 5:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3556; /* avx512vl_ucmpv4si3 */

                case 6:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3558; /* avx512f_ucmpv8di3 */

                case 7:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3560; /* avx512vl_ucmpv4di3 */

                case 8:
                  if (!(
#line 4689 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3562; /* avx512vl_ucmpv2di3 */

                default:
                  return -1;
                }

            case US_MINUS:
              switch (pattern424 (x2))
                {
                case 0:
                  if (!(
#line 4792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V16QImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3609; /* *avx512vl_ucmpv16qi3_1 */

                case 1:
                  if (!(
#line 4792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V16HImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3615; /* *avx512vl_ucmpv16hi3_1 */

                case 2:
                  if (!(
#line 4792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()
  && ix86_binary_operator_ok (US_MINUS, V8HImode, operands)
  && (INTVAL (operands[4]) & 1) == 0) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3617; /* *avx512vl_ucmpv8hi3_1 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 52:
          if (pattern59 (x1, pnum_clobbers, 
E_V8QImode) != 0)
            return -1;
          x8 = XVECEXP (x2, 0, 1);
          operands[2] = x8;
          if (!register_mmxmem_operand (operands[2], E_V8QImode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[4] = x3;
          if (!reg_or_const_vector_operand (operands[4], E_V4SImode)
              || !
#line 23153 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
            return -1;
          *pnum_clobbers = 1;
          return 8557; /* *ssse3_pshufbv8qi3 */

        case 132:
          if (pnum_clobbers == NULL
              || pattern251 (x1) != 0
              || !nonimmediate_operand (operands[3], E_V16QImode))
            return -1;
          x3 = XVECEXP (x2, 0, 2);
          operands[4] = x3;
          if (!const_0_to_255_operand (operands[4], E_SImode)
              || !
#line 26312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
            return -1;
          *pnum_clobbers = 2;
          return 8913; /* sse4_2_pcmpistr_cconly */

        default:
          return -1;
        }

    case 5:
      if (pnum_clobbers == NULL
          || XINT (x2, 1) != 131
          || pattern251 (x1) != 0
          || !register_operand (operands[3], E_SImode))
        return -1;
      x3 = XVECEXP (x2, 0, 2);
      operands[4] = x3;
      if (!nonimmediate_operand (operands[4], E_V16QImode))
        return -1;
      x10 = XVECEXP (x2, 0, 3);
      operands[5] = x10;
      if (!register_operand (operands[5], E_SImode))
        return -1;
      x11 = XVECEXP (x2, 0, 4);
      operands[6] = x11;
      if (!const_0_to_255_operand (operands[6], E_SImode)
          || !
#line 26187 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_2))
        return -1;
      *pnum_clobbers = 2;
      return 8909; /* sse4_2_pcmpestr_cconly */

    default:
      return -1;
    }
}

 int
recog_28 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_DFmode:
      if (GET_MODE (x3) != E_DFmode)
        return -1;
      if (nonimm_ssenomem_operand (operands[0], E_DFmode)
          && nonimmediate_operand (operands[1], E_SFmode)
          && 
#line 5307 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (TARGET_SSE2 && TARGET_SSE_MATH)))
        return 200; /* *extendsfdf2 */
      if (!register_operand (operands[0], E_DFmode)
          || !nonimmediate_operand (operands[1], E_HFmode)
          || !
#line 5463 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
        return -1;
      return 202; /* *extendhfdf2 */

    case E_SFmode:
      if (!register_operand (operands[0], E_SFmode)
          || GET_MODE (x3) != E_SFmode
          || !nonimmediate_operand (operands[1], E_HFmode)
          || !
#line 5463 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
        return -1;
      return 201; /* *extendhfsf2 */

    case E_XFmode:
      if (!nonimmediate_operand (operands[0], E_XFmode))
        return -1;
      switch (pattern429 (x3, 
E_XFmode))
        {
        case 0:
          if (!
#line 5525 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 204; /* *extendsfxf2_i387 */

        case 1:
          if (!
#line 5525 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387))
            return -1;
          return 205; /* *extenddfxf2_i387 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_30 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (GET_MODE (x3) != E_SImode)
        return -1;
      if (register_operand (operands[0], E_SImode))
        {
          switch (pattern263 ())
            {
            case 0:
              if (
#line 5781 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
                return 212; /* fix_trunchfsi2 */
              break;

            case 1:
              if (
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)))
                return 225; /* fix_truncsfsi_sse */
              break;

            case 2:
              if (
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)))
                return 227; /* fix_truncdfsi_sse */
              break;

            default:
              break;
            }
        }
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_SImode)
          || !register_operand (operands[1], E_VOIDmode))
        return -1;
      if (
#line 5987 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 230; /* fix_truncsi_i387_fisttp */
        }
      if (!
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || SImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 233; /* *fix_truncsi_i387_1 */

    case E_DImode:
      if (GET_MODE (x3) != E_DImode)
        return -1;
      if (register_operand (operands[0], E_DImode))
        {
          switch (pattern263 ())
            {
            case 0:
              if ((
#line 5781 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 214; /* fix_trunchfdi2 */
              break;

            case 1:
              if ((
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 226; /* fix_truncsfdi_sse */
              break;

            case 2:
              if ((
#line 5957 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode)
   && (!TARGET_FISTTP || TARGET_SSE_MATH)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 228; /* fix_truncdfdi_sse */
              break;

            default:
              break;
            }
        }
      if (pnum_clobbers == NULL
          || !nonimmediate_operand (operands[0], E_DImode)
          || !register_operand (operands[1], E_VOIDmode))
        return -1;
      if (
#line 5987 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 231; /* fix_truncdi_i387_fisttp */
        }
      if (!
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || DImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 234; /* *fix_truncdi_i387_1 */

    case E_HImode:
      if (pattern262 (x3, pnum_clobbers, 
E_VOIDmode, 
E_HImode) != 0)
        return -1;
      if (
#line 5987 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && TARGET_FISTTP
   && !((SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
	&& TARGET_SSE_MATH)))
        {
          *pnum_clobbers = 1;
          return 229; /* fix_trunchi_i387_fisttp */
        }
      if (!
#line 6005 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(X87_FLOAT_MODE_P (GET_MODE (operands[1]))
   && !TARGET_FISTTP
   && !(SSE_FLOAT_MODE_P (GET_MODE (operands[1]))
	 && (TARGET_64BIT || HImode != DImode))
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 232; /* *fix_trunchi_i387_1 */

    case E_V2SImode:
      if (!register_operand (operands[0], E_V2SImode)
          || GET_MODE (x3) != E_V2SImode
          || !vector_operand (operands[1], E_V2DFmode)
          || !
#line 8922 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 4828; /* sse2_cvttpd2pi */

    default:
      return -1;
    }
}

 int
recog_38 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case XOR:
      if (pnum_clobbers == NULL)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x5 = XEXP (x3, 0);
      operands[1] = x5;
      x6 = XEXP (x3, 1);
      operands[2] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_HImode:
          if (pattern743 (x2, 
E_HImode) != 0
              || !
#line 13621 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, HImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 835; /* *notxorhi_1 */

        case E_QImode:
          if (pattern743 (x2, 
E_QImode) != 0
              || !
#line 13821 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (XOR, QImode, operands, TARGET_APX_NDD)))
            return -1;
          *pnum_clobbers = 1;
          return 871; /* *notxorqi_1 */

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (pattern40 (x1))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_TImode:
              if (!nonimmediate_operand (operands[0], E_TImode)
                  || GET_MODE (x2) != E_TImode
                  || !nonimmediate_operand (operands[1], E_TImode)
                  || !(
#line 14990 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 1031; /* *one_cmplti2_doubleword */

            case E_HImode:
              if (!nonimmediate_operand (operands[0], E_HImode)
                  || GET_MODE (x2) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 15003 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1032; /* *one_cmplhi2_1 */

            case E_QImode:
              if (!nonimmediate_operand (operands[0], E_QImode)
                  || GET_MODE (x2) != E_QImode
                  || !nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 15047 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NOT, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 1041; /* *one_cmplqi2_1 */

            case E_V4QImode:
              if (!register_operand (operands[0], E_V4QImode)
                  || GET_MODE (x2) != E_V4QImode
                  || !register_operand (operands[1], E_V4QImode))
                return -1;
              return 2265; /* one_cmplv4qi2 */

            case E_V2QImode:
              if (!register_operand (operands[0], E_V2QImode)
                  || GET_MODE (x2) != E_V2QImode
                  || !register_operand (operands[1], E_V2QImode))
                return -1;
              return 2266; /* one_cmplv2qi2 */

            case E_V2HImode:
              if (!register_operand (operands[0], E_V2HImode)
                  || GET_MODE (x2) != E_V2HImode
                  || !register_operand (operands[1], E_V2HImode))
                return -1;
              return 2267; /* one_cmplv2hi2 */

            default:
              return -1;
            }

        case 1:
          if (!
#line 15073 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1042; /* *one_cmplqi_1_slp */

        case 2:
          if (!
#line 15073 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 1043; /* *one_cmplhi_1_slp */

        default:
          return -1;
        }

    case ZERO_EXTRACT:
      if (pnum_clobbers == NULL
          || GET_MODE (x3) != E_DImode)
        return -1;
      x6 = XEXP (x3, 1);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x4 = XEXP (x1, 0);
      if (GET_CODE (x4) != ZERO_EXTRACT
          || GET_MODE (x4) != E_DImode)
        return -1;
      x7 = XEXP (x4, 1);
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x8 = XEXP (x4, 0);
      operands[0] = x8;
      if (!nonimmediate_operand (operands[0], E_DImode))
        return -1;
      x9 = XEXP (x4, 2);
      operands[1] = x9;
      if (!const_0_to_63_operand (operands[1], E_QImode)
          || GET_MODE (x2) != E_DImode)
        return -1;
      x5 = XEXP (x3, 0);
      if (!rtx_equal_p (x5, operands[0]))
        return -1;
      x10 = XEXP (x3, 2);
      if (!rtx_equal_p (x10, operands[1])
          || !
#line 19072 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && (TARGET_USE_BT || reload_completed)))
        return -1;
      *pnum_clobbers = 1;
      return 1415; /* *btcq_imm */

    case UNSPEC:
      if (XVECLEN (x3, 0) != 3)
        return -1;
      x4 = XEXP (x1, 0);
      operands[0] = x4;
      x11 = XVECEXP (x3, 0, 0);
      operands[1] = x11;
      x12 = XVECEXP (x3, 0, 1);
      operands[2] = x12;
      x13 = XVECEXP (x3, 0, 2);
      operands[3] = x13;
      switch (XINT (x3, 1))
        {
        case 59:
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              switch (pattern961 (x2))
                {
                case 0:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3381; /* *avx512f_cmpv16si3 */

                case 1:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 310 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3388; /* *avx512vl_cmpv16hf3 */

                case 2:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3390; /* *avx512f_cmpv16sf3 */

                case 3:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3446; /* *avx512vl_cmpv16qi3 */

                case 4:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3452; /* *avx512vl_cmpv16hi3 */

                default:
                  return -1;
                }

            case E_QImode:
              switch (pattern962 (x2))
                {
                case 0:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3382; /* *avx512vl_cmpv8si3 */

                case 1:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 307 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3383; /* *avx512vl_cmpv4si3 */

                case 2:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3384; /* *avx512f_cmpv8di3 */

                case 3:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3385; /* *avx512vl_cmpv4di3 */

                case 4:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3386; /* *avx512vl_cmpv2di3 */

                case 5:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 311 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                    return -1;
                  return 3389; /* *avx512fp16_cmpv8hf3 */

                case 6:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3391; /* *avx512vl_cmpv8sf3 */

                case 7:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 312 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3392; /* *avx512vl_cmpv4sf3 */

                case 8:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3393; /* *avx512f_cmpv8df3 */

                case 9:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3394; /* *avx512vl_cmpv4df3 */

                case 10:
                  if (!(
#line 4472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 313 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3395; /* *avx512vl_cmpv2df3 */

                case 11:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3454; /* *avx512vl_cmpv8hi3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 157:
          if (!const_0_to_7_operand (operands[3], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_HImode:
              switch (pattern1065 (x2))
                {
                case 0:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3447; /* *avx512vl_cmpv16qi3 */

                case 1:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3453; /* *avx512vl_cmpv16hi3 */

                case 2:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3600; /* *avx512f_ucmpv16si3 */

                default:
                  return -1;
                }

            case E_QImode:
              switch (pattern1066 (x2))
                {
                case 0:
                  if (!(
#line 4567 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && ix86_pre_reload_split ()) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3455; /* *avx512vl_cmpv8hi3 */

                case 1:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3601; /* *avx512vl_ucmpv8si3 */

                case 2:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 500 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3602; /* *avx512vl_ucmpv4si3 */

                case 3:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return -1;
                  return 3603; /* *avx512f_ucmpv8di3 */

                case 4:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3604; /* *avx512vl_ucmpv4di3 */

                case 5:
                  if (!(
#line 4765 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()) && 
#line 501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                    return -1;
                  return 3605; /* *avx512vl_ucmpv2di3 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_55 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case CONST_WIDE_INT:
    case CONST_POLY_INT:
    case CONST_FIXED:
    case CONST_DOUBLE:
    case CONST_VECTOR:
    case CONST:
    case REG:
    case SUBREG:
    case MEM:
    case LABEL_REF:
    case SYMBOL_REF:
    case HIGH:
      operands[1] = x3;
      res = recog_54 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (pnum_clobbers == NULL
          || GET_CODE (x3) != SUBREG
          || maybe_ne (SUBREG_BYTE (x3), 0)
          || GET_MODE (x3) != E_QImode)
        return -1;
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          operands[3] = x4;
          x5 = XEXP (x4, 1);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x6 = XEXP (x4, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x7 = XEXP (x2, 1);
          if (pattern600 (x7) != 0)
            return -1;
          x8 = XEXP (x7, 0);
          operands[4] = x8;
          x9 = XEXP (x8, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 8])
            return -1;
          x10 = XEXP (x8, 2);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 8]
              || GET_MODE (x2) != E_QImode)
            return -1;
          switch (pattern1252 (x1))
            {
            case 0:
              if (!
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 408; /* *subqi_exthi_2_slp */

            case 1:
              if (!
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                return -1;
              *pnum_clobbers = 1;
              return 409; /* *subqi_extsi_2_slp */

            case 2:
              if (!(
#line 8260 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 410; /* *subqi_extdi_2_slp */

            case 3:
              *pnum_clobbers = 1;
              return 419; /* *subqi_ext2hi_0 */

            case 4:
              *pnum_clobbers = 1;
              return 420; /* *subqi_ext2si_0 */

            case 5:
              if (!
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 421; /* *subqi_ext2di_0 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case MINUS:
      if (pnum_clobbers == NULL)
        return -1;
      x11 = XEXP (x1, 0);
      operands[0] = x11;
      switch (pattern291 (x2))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1346 (x2, 
E_QImode) != 0
                  || !
#line 9289 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 487; /* subqi3_carry */

            case E_HImode:
              if (pattern1346 (x2, 
E_HImode) != 0
                  || !
#line 9289 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              *pnum_clobbers = 1;
              return 488; /* subhi3_carry */

            default:
              return -1;
            }

        case 1:
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1257 (x2, 
E_QImode) != 0
                  || !
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 570; /* *subqi3_eq */

            case E_HImode:
              if (pattern1257 (x2, 
E_HImode) != 0
                  || !
#line 10242 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 571; /* *subhi3_eq */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case VEC_SELECT:
      switch (pattern91 (x1))
        {
        case 0:
          x4 = XEXP (x3, 0);
          operands[1] = x4;
          if (pattern963 (x2) != 0)
            return -1;
          x7 = XEXP (x2, 1);
          x8 = XEXP (x7, 0);
          if (!rtx_equal_p (x8, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (pattern1495 (x2, 
E_SFmode, 
E_V2SFmode) != 0
                  || !
#line 1058 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE3 && TARGET_MMX_WITH_SSE && ix86_partial_vec_fp_math
   && ix86_pre_reload_split ()))
                return -1;
              return 2067; /* *mmx_hsubv2sf3_low */

            case E_DFmode:
              if (pattern1495 (x2, 
E_DFmode, 
E_V2DFmode) != 0
                  || !
#line 3772 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE3 && TARGET_V2DF_REDUCTION_PREFER_HADDPD))
                return -1;
              return 3154; /* *sse3_hsubv2df3_low */

            default:
              return -1;
            }

        case 1:
          switch (pattern851 (x2))
            {
            case 0:
              if (!
#line 22618 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8524; /* ssse3_phsubwv4hi3 */

            case 1:
              if (!
#line 22705 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSSE3))
                return -1;
              return 8531; /* ssse3_phsubdv2si3 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_62 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != PARALLEL)
    return -1;
  x4 = XEXP (x1, 0);
  operands[0] = x4;
  x5 = XEXP (x2, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
      return recog_61 (x1, insn, pnum_clobbers);

    case VEC_CONCAT:
      switch (pattern275 (x2))
        {
        case 0:
          x6 = XVECEXP (x3, 0, 1);
          if (GET_CODE (x6) == CONST_INT)
            {
              switch (pattern967 (x2))
                {
                case 0:
                  if (
#line 1691 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                    return 2087; /* *vec_interleave_lowv2sf */
                  break;

                case 1:
                  if (
#line 4996 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return 2303; /* mmx_punpckldq */
                  break;

                case 2:
                  if (
#line 1708 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                    return 2088; /* *vec_interleave_highv2sf */
                  break;

                case 3:
                  if (
#line 4975 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
                    return 2302; /* mmx_punpckhdq */
                  break;

                default:
                  break;
                }
            }
          x7 = XVECEXP (x3, 0, 0);
          operands[3] = x7;
          switch (pattern968 (x2))
            {
            case 0:
              if (!
#line 6202 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2368; /* *punpckwd */

            case 1:
              if (!
#line 6202 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2369; /* *punpckwd */

            case 2:
              if (!
#line 6202 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
                return -1;
              return 2370; /* *punpckwd */

            default:
              return -1;
            }

        case 1:
          if (!
#line 4855 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2296; /* mmx_punpckhbw */

        case 2:
          if (!
#line 4895 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2298; /* mmx_punpcklbw */

        case 3:
          if (!
#line 4876 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2297; /* mmx_punpckhbw_low */

        case 4:
          if (!
#line 4933 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2300; /* mmx_punpckhwd */

        case 5:
          if (!
#line 4916 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return -1;
          return 2299; /* mmx_punpcklbw_low */

        case 6:
          if (!
#line 4954 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX || TARGET_MMX_WITH_SSE))
            return -1;
          return 2301; /* mmx_punpcklwd */

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern276 (x2) != 0
          || !
#line 8409 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
        return -1;
      return 4716; /* sse_cvtps2pi */

    case FIX:
      if (pattern278 (x2) != 0
          || !
#line 8473 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
        return -1;
      return 4718; /* sse_cvttps2pi */

    default:
      return -1;
    }
}

 int
recog_66 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XEXP (x3, 1);
  operands[2] = x4;
  x5 = XEXP (x3, 0);
  switch (GET_CODE (x5))
    {
    case REG:
    case SUBREG:
    case MEM:
    case VEC_DUPLICATE:
      operands[1] = x5;
      x6 = XEXP (x3, 2);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 5918 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3760; /* *fma_fmadd_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 5946 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3775; /* *fma_fmadd_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 5918 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3761; /* *fma_fmadd_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 5946 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3784; /* *fma_fmadd_df */

            case E_HFmode:
              if (pattern861 (x3, 
E_HFmode) != 0
                  || !(
#line 5946 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3774; /* *fma_fmadd_hf */

            default:
              return -1;
            }

        case NEG:
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode
                  || GET_MODE (x6) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3823; /* *fma_fmsub_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3838; /* *fma_fmsub_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode
                  || GET_MODE (x6) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6017 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3824; /* *fma_fmsub_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3847; /* *fma_fmsub_df */

            case E_HFmode:
              if (pattern862 (x3, 
E_HFmode) != 0
                  || !(
#line 6049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3837; /* *fma_fmsub_hf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case NEG:
      x8 = XEXP (x5, 0);
      operands[1] = x8;
      x6 = XEXP (x3, 2);
      switch (GET_CODE (x6))
        {
        case REG:
        case SUBREG:
        case MEM:
        case VEC_DUPLICATE:
          operands[3] = x6;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode
                  || GET_MODE (x5) != E_SFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6123 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3886; /* *fma_fnmadd_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3901; /* *fma_fnmadd_sf */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode
                  || GET_MODE (x5) != E_DFmode)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6123 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3887; /* *fma_fnmadd_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3910; /* *fma_fnmadd_df */

            case E_HFmode:
              if (pattern863 (x3, 
E_HFmode) != 0
                  || !(
#line 6155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3900; /* *fma_fnmadd_hf */

            default:
              return -1;
            }

        case NEG:
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          switch (GET_MODE (operands[0]))
            {
            case E_SFmode:
              if (pattern864 (x3, 
E_SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_SFmode)
                  && nonimmediate_operand (operands[2], E_SFmode)
                  && nonimmediate_operand (operands[3], E_SFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3943; /* *fma_fnmsub_sf */
              if (!bcst_vector_operand (operands[1], E_SFmode)
                  || !bcst_vector_operand (operands[2], E_SFmode)
                  || !bcst_vector_operand (operands[3], E_SFmode)
                  || !
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3972; /* *fma_fnmsub_sf */

            case E_DFmode:
              if (pattern864 (x3, 
E_DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_DFmode)
                  && nonimmediate_operand (operands[2], E_DFmode)
                  && nonimmediate_operand (operands[3], E_DFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3945; /* *fma_fnmsub_df */
              if (!bcst_vector_operand (operands[1], E_DFmode)
                  || !bcst_vector_operand (operands[2], E_DFmode)
                  || !bcst_vector_operand (operands[3], E_DFmode)
                  || !
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1))
                return -1;
              return 3981; /* *fma_fnmsub_df */

            case E_HFmode:
              if (pattern865 (x3, 
E_HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1 && 1) && 
#line 5934 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 3971; /* *fma_fnmsub_hf */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_73 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  if (GET_CODE (x4) != PARALLEL
      || XVECLEN (x4, 0) != 1)
    return -1;
  x5 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  operands[2] = x5;
  x6 = XEXP (x3, 0);
  operands[1] = x6;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      switch (pattern974 (x2, 
E_SImode))
        {
        case 0:
          if (
#line 5442 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)))
            return 2324; /* *mmx_pextrw_zext */
          break;

        case 1:
          if (
#line 6103 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2))
            return 2362; /* *pextrw_zext */
          break;

        case 2:
          if (
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return 8389; /* *vec_extractv8hi_zext */
          break;

        case 3:
          if (
#line 5479 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE))
            return 2328; /* *mmx_pextrb_zext */
          break;

        case 4:
          if (
#line 6135 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1))
            return 2366; /* *pextrb_zext */
          break;

        case 5:
          if ((
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 21045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1)))
            return 8387; /* *vec_extractv16qi_zext */
          break;

        default:
          break;
        }
      break;

    case E_DImode:
      switch (pattern974 (x2, 
E_DImode))
        {
        case 0:
          if ((
#line 5442 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2325; /* *mmx_pextrw_zext */
          break;

        case 1:
          if ((
#line 6103 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2363; /* *pextrw_zext */
          break;

        case 2:
          if ((
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 8390; /* *vec_extractv8hi_zext */
          break;

        case 3:
          if ((
#line 5479 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1 && TARGET_MMX_WITH_SSE) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2329; /* *mmx_pextrb_zext */
          break;

        case 4:
          if ((
#line 6135 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE4_1) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 2367; /* *pextrb_zext */
          break;

        case 5:
          if ((
#line 21102 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && (
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21045 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1))))
            return 8388; /* *vec_extractv16qi_zext */
          break;

        default:
          break;
        }
      break;

    default:
      break;
    }
  if (!register_operand (operands[0], E_DImode)
      || GET_MODE (x2) != E_DImode
      || GET_MODE (x3) != E_SImode)
    return -1;
  operands[1] = x6;
  switch (XWINT (x5, 0))
    {
    case 0L:
      switch (GET_MODE (operands[1]))
        {
        case E_V2SImode:
          if (register_operand (operands[1], E_V2SImode))
            {
              if (
#line 5754 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE4_1))
                return 2350; /* *vec_extractv2si_0_zext_sse4 */
              if (
#line 5769 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_FROM_VEC))
                return 2351; /* *vec_extractv2si_0_zext */
            }
          break;

        case E_V4SImode:
          if (register_operand (operands[1], E_V4SImode))
            {
              if (
#line 21202 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE4_1))
                return 8397; /* *vec_extractv4si_0_zext_sse4 */
              if (
#line 21217 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_FROM_VEC))
                return 8398; /* *vec_extractv4si_0_zext */
            }
          break;

        default:
          break;
        }
      break;

    case 1L:
      if (register_operand (operands[1], E_V2SImode)
          && 
#line 5831 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && TARGET_64BIT && TARGET_SSE4_1))
        return 2353; /* *vec_extractv2si_1_zext */
      break;

    default:
      break;
    }
  operands[2] = x5;
  switch (GET_MODE (operands[1]))
    {
    case E_V2SImode:
      if (!memory_operand (operands[1], E_V2SImode)
          || !const_0_to_1_operand (operands[2], E_SImode)
          || !
#line 5847 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_64BIT))
        return -1;
      return 2354; /* *vec_extractv2si_zext_mem */

    case E_V4SImode:
      if (!const_0_to_3_operand (operands[2], E_SImode))
        return -1;
      if (register_operand (operands[1], E_V4SImode)
          && 
#line 21278 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE4_1))
        return 8400; /* *vec_extractv4si_zext */
      if (!memory_operand (operands[1], E_V4SImode)
          || !
#line 21301 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_64BIT && TARGET_SSE))
        return -1;
      return 8402; /* *vec_extractv4si_zext_mem */

    default:
      return -1;
    }
}

 int
recog_79 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      x5 = XEXP (x3, 1);
      switch (GET_CODE (x5))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          x6 = XEXP (x2, 1);
          switch (GET_CODE (x6))
            {
            case CONST_INT:
            case CONST_WIDE_INT:
              operands[3] = x6;
              operands[1] = x4;
              operands[2] = x5;
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (pattern603 (x2, 
E_SImode) != 0
                      || !
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))))
                    return -1;
                  return 376; /* *leasi_general_4 */

                case E_DImode:
                  if (GET_MODE (x2) != E_DImode
                      || GET_MODE (x3) != E_DImode)
                    return -1;
                  if (register_operand (operands[0], E_DImode)
                      && register_no_SP_operand (operands[1], E_DImode)
                      && const_0_to_3_operand (operands[2], E_VOIDmode)
                      && const_int_operand (operands[3], E_VOIDmode)
                      && (
#line 8051 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
((unsigned HOST_WIDE_INT) INTVAL (operands[3])
   < (HOST_WIDE_INT_1U << INTVAL (operands[2]))) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 378; /* *leadi_general_4 */
                  if (!nonimmediate_operand (operands[0], E_DImode)
                      || !register_operand (operands[1], E_DImode)
                      || !const_int_operand (operands[2], E_QImode)
                      || !const_scalar_int_operand (operands[3], E_DImode)
                      || !(
#line 14151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 8 * BITS_PER_UNIT / 2
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                    return -1;
                  return 929; /* *concatsidi3_5 */

                default:
                  return -1;
                }

            case ZERO_EXTEND:
              if (GET_MODE (x6) != E_DImode
                  || !nonimmediate_operand (operands[0], E_DImode)
                  || GET_MODE (x2) != E_DImode
                  || GET_MODE (x3) != E_DImode)
                return -1;
              operands[1] = x4;
              if (!register_operand (operands[1], E_DImode))
                return -1;
              operands[2] = x5;
              if (!const_int_operand (operands[2], E_QImode))
                return -1;
              x7 = XEXP (x6, 0);
              operands[3] = x7;
              if (!nonimmediate_operand (operands[3], E_SImode)
                  || !(
#line 14074 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 893; /* *concatsidi3_1 */

            case SUBREG:
              switch (pattern443 (x2, 
LSHIFTRT))
                {
                case 0:
                  operands[2] = x5;
                  if (pattern1348 (x2) == 0)
                    {
                      if (
#line 15451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && TARGET_APX_NF))
                        return 1066; /* x86_64_shld_1_nf */
                      if (pnum_clobbers != NULL
                          && 
#line 15451 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && true))
                        {
                          *pnum_clobbers = 1;
                          return 1067; /* x86_64_shld_1 */
                        }
                    }
                  operands[3] = x5;
                  if (pattern1349 (x2) != 0)
                    return -1;
                  if (
#line 15473 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && TARGET_APX_NF))
                    return 1068; /* x86_64_shld_ndd_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15473 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && INTVAL (operands[4]) == 64 - INTVAL (operands[3])
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1069; /* x86_64_shld_ndd_1 */

                case 1:
                  operands[2] = x5;
                  if (pattern1350 (x2) == 0)
                    {
                      if (
#line 15683 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
  && TARGET_APX_NF))
                        return 1078; /* x86_shld_1_nf */
                      if (pnum_clobbers != NULL
                          && 
#line 15683 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
  && true))
                        {
                          *pnum_clobbers = 1;
                          return 1079; /* x86_shld_1 */
                        }
                    }
                  operands[3] = x5;
                  if (pattern1351 (x2) != 0)
                    return -1;
                  if (
#line 15705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD 
   && INTVAL (operands[4]) == 32 - INTVAL (operands[3])
   && TARGET_APX_NF))
                    return 1080; /* x86_shld_ndd_1_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD 
   && INTVAL (operands[4]) == 32 - INTVAL (operands[3])
   && true))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1081; /* x86_shld_ndd_1 */

                default:
                  return -1;
                }

            case LSHIFTRT:
              switch (pattern446 (x2, pnum_clobbers))
                {
                case 0:
                  if (
#line 15489 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_APX_NF
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return 1070; /* *x86_64_shld_shrd_1_nozext_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15545 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && INTVAL (operands[3]) == 64 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1071; /* *x86_64_shld_shrd_1_nozext */

                case 1:
                  if (
#line 15721 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF
   && INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return 1082; /* *x86_shld_shrd_1_nozext_nf */
                  if (pnum_clobbers == NULL
                      || !
#line 15777 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 32 - INTVAL (operands[2])
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1083; /* *x86_shld_shrd_1_nozext */

                case 2:
                  x7 = XEXP (x6, 0);
                  operands[1] = x7;
                  if (nonimmediate_operand (operands[0], E_DImode))
                    {
                      operands[2] = x5;
                      if (rtx_equal_p (x4, operands[0]))
                        {
                          x8 = XEXP (x6, 1);
                          x9 = XEXP (x8, 1);
                          if (rtx_equal_p (x9, operands[2])
                              && 
#line 15598 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            {
                              *pnum_clobbers = 1;
                              return 1072; /* *x86_64_shld_2 */
                            }
                        }
                    }
                  operands[2] = x7;
                  if (!register_operand (operands[0], E_DImode))
                    return -1;
                  operands[1] = x4;
                  if (!nonimmediate_operand (operands[1], E_DImode))
                    return -1;
                  operands[3] = x5;
                  x8 = XEXP (x6, 1);
                  x9 = XEXP (x8, 1);
                  if (!rtx_equal_p (x9, operands[3])
                      || !
#line 15619 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1073; /* *x86_64_shld_ndd_2 */

                case 3:
                  x7 = XEXP (x6, 0);
                  operands[1] = x7;
                  if (nonimmediate_operand (operands[0], E_SImode))
                    {
                      operands[2] = x5;
                      if (rtx_equal_p (x4, operands[0]))
                        {
                          x8 = XEXP (x6, 1);
                          x9 = XEXP (x8, 1);
                          if (rtx_equal_p (x9, operands[2])
                              && 
#line 15829 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && ix86_pre_reload_split ()))
                            {
                              *pnum_clobbers = 1;
                              return 1084; /* *x86_shld_2 */
                            }
                        }
                    }
                  operands[2] = x7;
                  if (!register_operand (operands[0], E_SImode))
                    return -1;
                  operands[1] = x4;
                  if (!nonimmediate_operand (operands[1], E_SImode))
                    return -1;
                  operands[3] = x5;
                  x8 = XEXP (x6, 1);
                  x9 = XEXP (x8, 1);
                  if (!rtx_equal_p (x9, operands[3])
                      || !
#line 15850 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD
   && ix86_pre_reload_split ()))
                    return -1;
                  *pnum_clobbers = 1;
                  return 1085; /* *x86_shld_ndd_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case AND:
          switch (pattern290 (x2, 
LSHIFTRT))
            {
            case 0:
              x6 = XEXP (x2, 1);
              x7 = XEXP (x6, 0);
              x10 = XEXP (x7, 0);
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              if (nonimmediate_operand (operands[0], E_DImode))
                {
                  res = recog_77 (x1, insn, pnum_clobbers);
                  if (res >= 0)
                    return res;
                }
              operands[2] = x11;
              if (!register_operand (operands[0], E_DImode))
                return -1;
              operands[1] = x4;
              if (!nonimmediate_operand (operands[1], E_DImode))
                return -1;
              x12 = XEXP (x5, 0);
              operands[3] = x12;
              x13 = XEXP (x7, 1);
              x14 = XEXP (x13, 1);
              x15 = XEXP (x14, 0);
              if (!rtx_equal_p (x15, operands[3]))
                return -1;
              if (
#line 15436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
                return 1064; /* x86_64_shld_ndd_nf */
              if (pnum_clobbers == NULL
                  || !
#line 15436 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              *pnum_clobbers = 1;
              return 1065; /* x86_64_shld_ndd */

            case 1:
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || pattern289 (x2, 
E_SImode, 
E_DImode) != 0)
                return -1;
              x6 = XEXP (x2, 1);
              x7 = XEXP (x6, 0);
              x10 = XEXP (x7, 0);
              x11 = XEXP (x10, 0);
              operands[1] = x11;
              x12 = XEXP (x5, 0);
              operands[2] = x12;
              if (rtx_equal_p (x4, operands[0]))
                {
                  x13 = XEXP (x7, 1);
                  x14 = XEXP (x13, 1);
                  x15 = XEXP (x14, 0);
                  if (rtx_equal_p (x15, operands[2]))
                    {
                      if (
#line 15645 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF))
                        return 1074; /* x86_shld_nf */
                      if (pnum_clobbers != NULL)
                        {
                          *pnum_clobbers = 1;
                          return 1075; /* x86_shld */
                        }
                    }
                }
              operands[2] = x11;
              operands[1] = x4;
              if (!nonimmediate_operand (operands[1], E_SImode))
                return -1;
              operands[3] = x12;
              x13 = XEXP (x7, 1);
              x14 = XEXP (x13, 1);
              x15 = XEXP (x14, 0);
              if (!rtx_equal_p (x15, operands[3]))
                return -1;
              if (
#line 15667 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && TARGET_APX_NF))
                return 1076; /* x86_shld_ndd_nf */
              if (pnum_clobbers == NULL
                  || !
#line 15667 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NDD && true))
                return -1;
              *pnum_clobbers = 1;
              return 1077; /* x86_shld_ndd */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SIGN_EXTEND:
      switch (pattern260 (x2, 
E_SImode, 
E_DImode))
        {
        case 0:
          if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 905; /* *concatsidi3_3 */

        case 1:
          if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 935; /* *concatsidi3_6 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      switch (pattern260 (x2, 
E_SImode, 
E_DImode))
        {
        case 0:
          if (!(
#line 14110 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 908; /* *concatsidi3_3 */

        case 1:
          if (!(
#line 14183 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == 4 * BITS_PER_UNIT
   && (DImode == DImode
       ? CONST_INT_P (operands[3])
	 && (UINTVAL (operands[3]) & ~GET_MODE_MASK (SImode)) == 0
       : CONST_INT_P (operands[3])
       ? INTVAL (operands[3]) >= 0
       : CONST_WIDE_INT_NUNITS (operands[3]) == 2
	 && CONST_WIDE_INT_ELT (operands[3], 1) == 0)
   && !(CONST_INT_P (operands[3])
	? ix86_endbr_immediate_operand (operands[3], VOIDmode)
	: ix86_endbr_immediate_operand (GEN_INT (CONST_WIDE_INT_ELT (operands[3],
								     0)),
					VOIDmode))) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 938; /* *concatsidi3_6 */

        default:
          return -1;
        }

    case CONST_INT:
      switch (pattern288 (x2, pnum_clobbers))
        {
        case 0:
          x5 = XEXP (x3, 1);
          operands[2] = x5;
          if (register_operand (operands[2], E_QImode))
            {
              switch (pattern752 (x2))
                {
                case 0:
                  if (
#line 18837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT))
                    {
                      *pnum_clobbers = 1;
                      return 1391; /* *btssi */
                    }
                  break;

                case 1:
                  if ((
#line 18837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 1393; /* *btsdi */
                    }
                  break;

                default:
                  break;
                }
            }
          if (GET_CODE (x5) != SUBREG)
            return -1;
          switch (pattern761 (x2))
            {
            case 0:
              if (!
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return -1;
              *pnum_clobbers = 1;
              return 1395; /* *btssi_mask */

            case 1:
              if (!(
#line 18856 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              *pnum_clobbers = 1;
              return 1397; /* *btsdi_mask */

            default:
              return -1;
            }

        case 1:
          if (!
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1399; /* *btssi_mask_1 */

        case 2:
          if (!(
#line 18884 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[2]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          *pnum_clobbers = 1;
          return 1401; /* *btsdi_mask_1 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_98 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  switch (GET_MODE (operands[0]))
    {
    case E_DImode:
      if (pnum_clobbers != NULL)
        {
          x2 = XEXP (x1, 1);
          if (pattern738 (x2, 
E_DImode, 
E_QImode) == 0
              && 
#line 1195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            {
              *pnum_clobbers = 1;
              return 1131; /* ashrdi3_doubleword */
            }
        }
      x2 = XEXP (x1, 1);
      if (GET_MODE (x2) != E_DImode
          || !nonimmediate_operand (operands[1], E_DImode))
        return -1;
      if (nonimmediate_operand (operands[0], E_DImode)
          && const_int_operand (operands[2], E_QImode))
        {
          if ((
#line 17258 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (DImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 1168; /* ashrdi3_cvt_nf */
          if (pnum_clobbers != NULL
              && (
#line 17258 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[2]) == GET_MODE_BITSIZE (DImode)-1
   && (TARGET_USE_CLTD || optimize_function_for_size_p (cfun))
   && ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            {
              *pnum_clobbers = 1;
              return 1169; /* ashrdi3_cvt */
            }
        }
      if (register_operand (operands[0], E_DImode)
          && register_operand (operands[2], E_DImode)
          && (
#line 17327 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1174; /* *bmi2_ashrdi3_1 */
      if (!nonimmediate_operand (operands[0], E_DImode)
          || !nonmemory_operand (operands[2], E_QImode))
        return -1;
      if ((
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return 1177; /* *ashrdi3_1_nf */
      if (pnum_clobbers == NULL
          || !(
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1178; /* *ashrdi3_1 */

    case E_SImode:
      x2 = XEXP (x1, 1);
      if (pattern623 (x2, 
E_SImode) != 0)
        return -1;
      if (
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && TARGET_APX_NF))
        return 1175; /* *ashrsi3_1_nf */
      if (pnum_clobbers == NULL
          || !
#line 17337 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ASHIFTRT, SImode, operands, TARGET_APX_NDD)
   && true))
        return -1;
      *pnum_clobbers = 1;
      return 1176; /* *ashrsi3_1 */

    default:
      return -1;
    }
}

 int
recog_103 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  if (GET_CODE (x2) == SUBREG
      && known_eq (SUBREG_BYTE (x2), 0))
    {
      x3 = XEXP (x2, 0);
      operands[0] = x3;
      if (register_operand (operands[0], E_QImode))
        {
          x4 = XEXP (x1, 1);
          x5 = XEXP (x4, 2);
          operands[2] = x5;
          if (register_operand (operands[2], E_QImode))
            {
              switch (GET_MODE (x2))
                {
                case E_SImode:
                  if (GET_MODE (x4) == E_SImode
                      && register_operand (operands[1], E_SImode)
                      && 
#line 19356 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()))
                    {
                      *pnum_clobbers = 1;
                      return 1434; /* *btsi_setcqi */
                    }
                  break;

                case E_DImode:
                  if (GET_MODE (x4) == E_DImode
                      && register_operand (operands[1], E_DImode)
                      && (
#line 19356 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    {
                      *pnum_clobbers = 1;
                      return 1435; /* *btdi_setcqi */
                    }
                  break;

                default:
                  break;
                }
            }
        }
    }
  x4 = XEXP (x1, 1);
  x5 = XEXP (x4, 2);
  if (GET_CODE (x5) != SUBREG
      || maybe_ne (SUBREG_BYTE (x5), 0)
      || GET_MODE (x5) != E_QImode)
    return -1;
  x6 = XEXP (x5, 0);
  if (GET_CODE (x6) != AND)
    return -1;
  operands[0] = x2;
  x7 = XEXP (x6, 0);
  operands[2] = x7;
  x8 = XEXP (x6, 1);
  operands[3] = x8;
  if (!const_int_operand (operands[3], E_VOIDmode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_SImode:
      if (pattern1440 (x4, 
E_SImode) != 0
          || !
#line 19437 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
        return -1;
      *pnum_clobbers = 1;
      return 1442; /* *btsi_setcsi_mask */

    case E_DImode:
      if (pattern1440 (x4, 
E_DImode) != 0
          || !(
#line 19437 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_BT
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1443; /* *btdi_setcdi_mask */

    default:
      return -1;
    }
}

 int
recog_104 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (GET_CODE (x3) != CONST_INT)
    return -1;
  x4 = XEXP (x2, 0);
  operands[1] = x4;
  if (XWINT (x3, 0) == 1L)
    {
      res = recog_103 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
    }
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  operands[2] = x3;
  if (!const_0_to_255_operand (operands[2], E_QImode))
    return -1;
  x6 = XEXP (x2, 2);
  operands[3] = x6;
  if (!const_0_to_255_operand (operands[3], E_QImode))
    return -1;
  switch (pattern126 (x2))
    {
    case 0:
      if (!
#line 22184 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM))
        return -1;
      *pnum_clobbers = 1;
      return 1604; /* tbm_bextri_si */

    case 1:
      if (!(
#line 22184 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_TBM) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
        return -1;
      *pnum_clobbers = 1;
      return 1605; /* tbm_bextri_di */

    default:
      return -1;
    }
}

 int
recog_107 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (XINT (x2, 1))
    {
    case 17:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      return 1487; /* *memory_blockage */

    case 14:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case CONST_INT:
          if (XWINT (x4, 0) != 0L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (pnum_clobbers == NULL
                  || !register_operand (operands[0], E_SImode)
                  || GET_MODE (x2) != E_SImode
                  || !
#line 20785 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
                return -1;
              *pnum_clobbers = 1;
              return 1498; /* *set_got */

            case E_DImode:
              if (!register_operand (operands[0], E_DImode)
                  || GET_MODE (x2) != E_DImode
                  || !
#line 20815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                return -1;
              return 1500; /* set_got_rex64 */

            default:
              return -1;
            }

        case LABEL_REF:
          if (pnum_clobbers == NULL
              || !register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode)
            return -1;
          x5 = XEXP (x4, 0);
          operands[1] = x5;
          if (!
#line 20807 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT))
            return -1;
          *pnum_clobbers = 1;
          return 1499; /* *set_got_labelled */

        default:
          return -1;
        }

    case 15:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (GET_CODE (x4) != LABEL_REF)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!
#line 20824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
        return -1;
      return 1501; /* set_rip_rex64 */

    case 16:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      if (GET_CODE (x4) != LABEL_REF)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!register_operand (operands[0], E_DImode))
        return -1;
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      if (!
#line 20835 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LP64))
        return -1;
      return 1502; /* set_got_offset_rex64 */

    case 97:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern302 (x2))
        {
        case 0:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return 1546; /* tzcnt_si_nf */
          if (pnum_clobbers == NULL
              || !
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))
            return -1;
          *pnum_clobbers = 1;
          return 1550; /* tzcnt_si */

        case 1:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && (((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI))))
            return 1548; /* tzcnt_di_nf */
          if (pnum_clobbers == NULL
              || !(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21660 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_BMI)))
            return -1;
          *pnum_clobbers = 1;
          return 1552; /* tzcnt_di */

        default:
          return -1;
        }

    case 96:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern302 (x2))
        {
        case 0:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return 1547; /* lzcnt_si_nf */
          if (pnum_clobbers == NULL
              || !
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))
            return -1;
          *pnum_clobbers = 1;
          return 1551; /* lzcnt_si */

        case 1:
          if ((
#line 21678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_APX_NF) && (((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT))))
            return 1549; /* lzcnt_di_nf */
          if (pnum_clobbers == NULL
              || !(((
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 21661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_LZCNT)))
            return -1;
          *pnum_clobbers = 1;
          return 1553; /* lzcnt_di */

        default:
          return -1;
        }

    case 19:
      x4 = XVECEXP (x2, 0, 0);
      if (x4 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      switch (pattern23 (x2))
        {
        case 0:
          if (!
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode))
            return -1;
          return 1658; /* *load_tp_si */

        case 1:
          if (!
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode))
            return -1;
          return 1659; /* *load_tp_di */

        default:
          return -1;
        }

    case 22:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!tls_symbolic_operand (operands[1], E_VOIDmode))
        return -1;
      switch (pattern23 (x2))
        {
        case 0:
          if (!(
#line 23372 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
            return -1;
          return 1667; /* *tls_dynamic_gnu2_lea_64_si */

        case 1:
          if (!(
#line 23372 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
            return -1;
          return 1668; /* *tls_dynamic_gnu2_lea_64_di */

        default:
          return -1;
        }

    case 70:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_XFmode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (pnum_clobbers == NULL
              || !nonimmediate_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !
#line 25151 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          *pnum_clobbers = 1;
          return 1733; /* lrintxfdi2 */

        case E_SImode:
          if (!nonimmediate_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !
#line 25160 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387))
            return -1;
          return 1735; /* lrintxfsi2 */

        default:
          return -1;
        }

    case 78:
      switch (pattern120 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1746; /* *fistsi2_floor_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1748; /* *fistdi2_floor_1 */

        default:
          return -1;
        }

    case 79:
      switch (pattern120 (x1, pnum_clobbers))
        {
        case 0:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1747; /* *fistsi2_ceil_1 */

        case 1:
          if (!
#line 25367 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_FANCY_MATH_387
   && flag_unsafe_math_optimizations
   && ix86_pre_reload_split ()))
            return -1;
          *pnum_clobbers = 1;
          return 1749; /* *fistdi2_ceil_1 */

        default:
          return -1;
        }

    case 49:
      return recog_106 (x1, insn, pnum_clobbers);

    case 18:
      if (pnum_clobbers == NULL)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!memory_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode
              || !const0_operand (operands[1], E_SImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode))
            return -1;
          *pnum_clobbers = 1;
          return 1861; /* probe_stack_1_si */

        case E_DImode:
          if (!memory_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !const0_operand (operands[1], E_DImode)
              || !
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode))
            return -1;
          *pnum_clobbers = 1;
          return 1862; /* probe_stack_1_di */

        default:
          return -1;
        }

    case 33:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      return 1955; /* *pause */

    case 102:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 29831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIRI))
            return -1;
          return 1986; /* movdirisi */

        case 1:
          if (!(
#line 29831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIRI) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1987; /* movdiridi */

        default:
          return -1;
        }

    case 103:
      if (GET_MODE (x2) != E_XImode)
        return -1;
      x3 = XEXP (x1, 0);
      if (GET_CODE (x3) != MEM
          || GET_MODE (x3) != E_XImode)
        return -1;
      x6 = XEXP (x3, 0);
      operands[0] = x6;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!memory_operand (operands[1], E_XImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || !(
#line 29839 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIR64B) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)))
            return -1;
          return 1988; /* movdir64b_si */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || !(
#line 29839 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_MOVDIR64B) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)))
            return -1;
          return 1989; /* movdir64b_di */

        default:
          return -1;
        }

    case 111:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DImode)
          || !
#line 636 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE)
   && (TARGET_SSE || TARGET_3DNOW_A)))
        return -1;
      return 2048; /* sse_movntq */

    case 117:
      switch (pattern121 (x1))
        {
        case 0:
          if (!
#line 2012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 2561; /* sse2_movntisi */

        case 1:
          if (!(
#line 2012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 2562; /* sse2_movntidi */

        default:
          return -1;
        }

    case 156:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case VEC_SELECT:
          switch (pattern457 (x4))
            {
            case 0:
              switch (pattern1087 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4474; /* avx512fp16_vcvtsh2usi */

                case 1:
                  if (!
#line 9013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                    return -1;
                  return 4834; /* avx512f_vcvtss2usi */

                case 2:
                  if (!
#line 9049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                    return -1;
                  return 4846; /* avx512f_vcvtsd2usi */

                default:
                  return -1;
                }

            case 1:
              switch (pattern1087 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4478; /* avx512fp16_vcvtsh2usiq */

                case 1:
                  if (!(
#line 9013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4836; /* avx512f_vcvtss2usiq */

                case 2:
                  if (!(
#line 9049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4848; /* avx512f_vcvtsd2usiq */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x4;
          if (!nonimmediate_operand (operands[1], E_HFmode))
            return -1;
          switch (pattern23 (x2))
            {
            case 0:
              if (!
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4482; /* avx512fp16_vcvtsh2usi_2 */

            case 1:
              if (!(
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 4484; /* avx512fp16_vcvtsh2usiq_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 46:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      switch (GET_CODE (x4))
        {
        case VEC_SELECT:
          switch (pattern457 (x4))
            {
            case 0:
              switch (pattern1088 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4476; /* avx512fp16_vcvtsh2si */

                case 1:
                  if (!
#line 8542 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 4723; /* sse_cvtss2si */

                case 2:
                  if (!
#line 9085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 4858; /* sse2_cvtsd2si */

                default:
                  return -1;
                }

            case 1:
              switch (pattern1088 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7815 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4480; /* avx512fp16_vcvtsh2siq */

                case 1:
                  if (!(
#line 8542 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4725; /* sse_cvtss2siq */

                case 2:
                  if (!(
#line 9085 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4860; /* sse2_cvtsd2siq */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case REG:
        case SUBREG:
        case MEM:
          operands[1] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              switch (pattern766 (x2, 
E_SImode))
                {
                case 0:
                  if (!
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                    return -1;
                  return 4483; /* avx512fp16_vcvtsh2si_2 */

                case 1:
                  if (!
#line 8555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                    return -1;
                  return 4727; /* sse_cvtss2si_2 */

                case 2:
                  if (!
#line 9099 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
                    return -1;
                  return 4862; /* sse2_cvtsd2si_2 */

                default:
                  return -1;
                }

            case E_DImode:
              switch (pattern766 (x2, 
E_DImode))
                {
                case 0:
                  if (!(
#line 7826 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4485; /* avx512fp16_vcvtsh2siq_2 */

                case 1:
                  if (!(
#line 8555 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4728; /* sse_cvtss2siq_2 */

                case 2:
                  if (!(
#line 9099 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return -1;
                  return 4863; /* sse2_cvtsd2siq_2 */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 172:
      switch (pattern123 (x1))
        {
        case 0:
          if (!
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return -1;
          return 4626; /* unspec_avx512fp16_fix_truncsi2 */

        case 1:
          if (!
#line 8570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
            return -1;
          return 4729; /* unspec_sse_cvttss2si */

        case 2:
          if (!
#line 9114 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
            return -1;
          return 4864; /* unspec_sse2_cvttsd2si */

        case 3:
          if (!(
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4630; /* unspec_avx512fp16_fix_truncdi2 */

        case 4:
          if (!(
#line 8570 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4731; /* unspec_sse_cvttss2siq */

        case 5:
          if (!(
#line 9114 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4866; /* unspec_sse2_cvttsd2siq */

        default:
          return -1;
        }

    case 173:
      switch (pattern123 (x1))
        {
        case 0:
          if (!
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
            return -1;
          return 4628; /* unspec_avx512fp16_fixuns_truncsi2 */

        case 1:
          if (!
#line 9024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 4838; /* unspec_avx512f_vcvttss2usi */

        case 2:
          if (!
#line 9060 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 4850; /* unspec_avx512f_vcvttsd2usi */

        case 3:
          if (!(
#line 7980 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4632; /* unspec_avx512fp16_fixuns_truncdi2 */

        case 4:
          if (!(
#line 9024 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4840; /* unspec_avx512f_vcvttss2usiq */

        case 5:
          if (!(
#line 9060 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 4852; /* unspec_avx512f_vcvttsd2usiq */

        default:
          return -1;
        }

    case 191:
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x2) != E_DImode
              || !register_operand (operands[1], E_V64QImode)
              || !(
#line 10246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5099; /* avx512bw_cvtb2maskv64qi */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x2) != E_SImode)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V32QImode:
              if (!register_operand (operands[1], E_V32QImode)
                  || !(
#line 10246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 317 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 5101; /* avx512vl_cvtb2maskv32qi */

            case E_V32HImode:
              if (!register_operand (operands[1], E_V32HImode)
                  || !(
#line 10246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 318 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 5102; /* avx512bw_cvtw2maskv32hi */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 275:
      switch (pattern125 (x1))
        {
        case 0:
          if (!
#line 32857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10810; /* avx10_2_vcvttsd2sissi */

        case 1:
          if (!
#line 32870 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10818; /* avx10_2_vcvttss2sissi */

        case 2:
          if (!(
#line 32857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10814; /* avx10_2_vcvttsd2sisdi */

        case 3:
          if (!(
#line 32870 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10822; /* avx10_2_vcvttss2sisdi */

        default:
          return -1;
        }

    case 276:
      switch (pattern125 (x1))
        {
        case 0:
          if (!
#line 32857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10812; /* avx10_2_vcvttsd2usissi */

        case 1:
          if (!
#line 32870 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10820; /* avx10_2_vcvttss2usissi */

        case 2:
          if (!(
#line 32857 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10816; /* avx10_2_vcvttsd2usisdi */

        case 3:
          if (!(
#line 32870 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 10824; /* avx10_2_vcvttss2usisdi */

        default:
          return -1;
        }

    case 280:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0])
          || !
#line 60 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE2))
        return -1;
      return 10904; /* *sse2_lfence */

    case 281:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0])
          || !
#line 79 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE || TARGET_3DNOW_A))
        return -1;
      return 10905; /* *sse_sfence */

    case 282:
      if (GET_MODE (x2) != E_BLKmode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      x4 = XVECEXP (x2, 0, 0);
      if (!rtx_equal_p (x4, operands[0]))
        return -1;
      if (
#line 98 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_64BIT || TARGET_SSE2))
        return 10906; /* mfence_sse2 */
      if (pnum_clobbers == NULL)
        return -1;
      *pnum_clobbers = 1;
      return 10907; /* mfence_nosse */

    case 284:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DFmode)
          || !
#line 356 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_80387))
        return -1;
      return 10915; /* storedi_via_fpu */

    case 286:
      if (GET_MODE (x2) != E_DImode)
        return -1;
      x3 = XEXP (x1, 0);
      operands[0] = x3;
      if (!memory_operand (operands[0], E_DImode))
        return -1;
      x4 = XVECEXP (x2, 0, 0);
      operands[1] = x4;
      if (!register_operand (operands[1], E_DFmode)
          || !
#line 382 "/build/gcc/src/gcc/gcc/config/i386/sync.md"
(TARGET_SSE))
        return -1;
      return 10917; /* storedi_via_sse */

    default:
      return -1;
    }
}

 int
recog_146 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (XVECLEN (x4, 0))
    {
    case 1:
      x5 = XEXP (x2, 2);
      if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x7 = XEXP (x3, 1);
      operands[3] = x7;
      x8 = XEXP (x3, 2);
      operands[4] = x8;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      x9 = XEXP (x2, 1);
      operands[2] = x9;
      switch (XINT (x4, 1))
        {
        case 54:
          if (pattern1271 (x2) != 0
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2982 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2886; /* avx512fp16_vmrcpv8hf2_mask */

        case 161:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1359 (x2, 
E_V4SFmode) != 0
                  || !
#line 3038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2902; /* srcp14v4sf_mask */

            case E_V2DFmode:
              if (pattern1359 (x2, 
E_V2DFmode) != 0
                  || !(
#line 3038 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2903; /* srcp14v2df_mask */

            default:
              return -1;
            }

        case 162:
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1359 (x2, 
E_V4SFmode) != 0
                  || !
#line 3192 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 2974; /* rsqrt14_v4sf_mask */

            case E_V2DFmode:
              if (pattern1359 (x2, 
E_V2DFmode) != 0
                  || !(
#line 3192 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2975; /* rsqrt14_v2df_mask */

            default:
              return -1;
            }

        case 55:
          if (pattern1271 (x2) != 0
              || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3240 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 2979; /* avx512fp16_vmrsqrtv8hf2_mask */

        default:
          return -1;
        }

    case 2:
      x5 = XEXP (x2, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      switch (XINT (x4, 1))
        {
        case 63:
          switch (pattern768 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3122; /* avx512fp16_ieee_vmmaxv8hf3_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 3130; /* sse_ieee_vmmaxv4sf3_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3138; /* sse2_ieee_vmmaxv2df3_mask */

            default:
              return -1;
            }

        case 62:
          switch (pattern768 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3126; /* avx512fp16_ieee_vmminv8hf3_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE)))
                return -1;
              return 3134; /* sse_ieee_vmminv4sf3_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3142; /* sse2_ieee_vmminv2df3_mask */

            default:
              return -1;
            }

        case 221:
          if (pattern769 (x2) != 0
              || !(
#line 389 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4330; /* avx512fp16_fmulcsh_v8hf_mask */

        case 222:
          if (pattern769 (x2) != 0
              || !(
#line 389 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4334; /* avx512fp16_fcmulcsh_v8hf_mask */

        case 58:
          switch (pattern768 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 5322; /* avx512f_vmscalefv8hf_mask */

            case 1:
              if (!
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 5326; /* avx512f_vmscalefv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 5330; /* avx512f_vmscalefv2df_mask */

            default:
              return -1;
            }

        case 165:
          switch (pattern768 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 6983; /* avx512f_sgetexpv8hf_mask */

            case 1:
              if (!
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 6987; /* avx512f_sgetexpv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 6991; /* avx512f_sgetexpv2df_mask */

            default:
              return -1;
            }

        case 94:
          if (XWINT (x5, 0) != 1L)
            return -1;
          x6 = XVECEXP (x4, 0, 0);
          operands[2] = x6;
          x10 = XVECEXP (x4, 0, 1);
          operands[3] = x10;
          if (!const_0_to_255_operand (operands[3], E_SImode))
            return -1;
          x7 = XEXP (x3, 1);
          operands[4] = x7;
          x8 = XEXP (x3, 2);
          operands[5] = x8;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          operands[1] = x9;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1523 (x2, 
E_V8HFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 7099; /* avx512f_rndscalev8hf_mask */

            case E_V4SFmode:
              if (pattern1523 (x2, 
E_V4SFmode) != 0
                  || !
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 7103; /* avx512f_rndscalev4sf_mask */

            case E_V2DFmode:
              if (pattern1523 (x2, 
E_V2DFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 7107; /* avx512f_rndscalev2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 3:
      x5 = XEXP (x2, 2);
      if (GET_CODE (x5) != CONST_INT)
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x10 = XVECEXP (x4, 0, 1);
      operands[2] = x10;
      x11 = XVECEXP (x4, 0, 2);
      operands[3] = x11;
      switch (XINT (x4, 1))
        {
        case 192:
          switch (pattern1101 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 3196; /* reducesv8hf_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode)))))
                return -1;
              return 3200; /* reducesv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 3204; /* reducesv2df_mask */

            default:
              return -1;
            }

        case 217:
          switch (pattern1102 (x2))
            {
            case 0:
              if (!(
#line 371 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4317; /* avx512fp16_fma_fmaddcsh_v8hf_maskz */

            case 1:
              if (!
#line 7511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4324; /* avx512fp16_fmaddcsh_v8hf_mask */

            default:
              return -1;
            }

        case 219:
          switch (pattern1102 (x2))
            {
            case 0:
              if (!(
#line 371 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                return -1;
              return 4321; /* avx512fp16_fma_fcmaddcsh_v8hf_maskz */

            case 1:
              if (!
#line 7511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))
                return -1;
              return 4326; /* avx512fp16_fcmaddcsh_v8hf_mask */

            default:
              return -1;
            }

        case 194:
          if (XWINT (x5, 0) != 1L
              || !const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          x7 = XEXP (x3, 1);
          operands[4] = x7;
          x8 = XEXP (x3, 2);
          operands[5] = x8;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1099 (x2, 
E_V4SFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 30077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ)))
                return -1;
              return 9903; /* avx512dq_rangesv4sf_mask */

            case E_V2DFmode:
              if (pattern1099 (x2, 
E_V2DFmode) != 0
                  || !(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9907; /* avx512dq_rangesv2df_mask */

            default:
              return -1;
            }

        case 166:
          if (XWINT (x5, 0) != 1L
              || !const_0_to_15_operand (operands[3], E_SImode))
            return -1;
          switch (pattern1100 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30145 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 9971; /* avx512f_vgetmantv8hf_mask */

            case 1:
              if (!
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 9975; /* avx512f_vgetmantv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30145 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 9979; /* avx512f_vgetmantv2df_mask */

            default:
              return -1;
            }

        case 278:
          switch (pattern1101 (x2))
            {
            case 0:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 10869; /* avx10_2_minmaxsv8hf_mask */

            case 1:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2)))
                return -1;
              return 10873; /* avx10_2_minmaxsv4sf_mask */

            case 2:
              if (!(
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 10877; /* avx10_2_minmaxsv2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case 4:
      if (XINT (x4, 1) != 163)
        return -1;
      x6 = XVECEXP (x4, 0, 0);
      operands[1] = x6;
      x10 = XVECEXP (x4, 0, 1);
      operands[2] = x10;
      x11 = XVECEXP (x4, 0, 2);
      operands[3] = x11;
      x12 = XVECEXP (x4, 0, 3);
      operands[4] = x12;
      if (!const_0_to_255_operand (operands[4], E_SImode))
        return -1;
      x7 = XEXP (x3, 1);
      switch (GET_CODE (x7))
        {
        case CONST_INT:
        case CONST_DOUBLE:
        case CONST_VECTOR:
          operands[5] = x7;
          x5 = XEXP (x2, 2);
          if (x5 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x8 = XEXP (x3, 2);
          operands[6] = x8;
          if (!register_operand (operands[6], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[2]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1619 (x2, 
E_V4SFmode, 
E_V4SImode) != 0
                  || !
#line 154 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                return -1;
              return 7052; /* avx512f_sfixupimmv4sf_maskz_1 */

            case E_V2DFmode:
              if (pattern1619 (x2, 
E_V2DFmode, 
E_V2DImode) != 0
                  || !(
#line 154 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14180 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 7056; /* avx512f_sfixupimmv2df_maskz_1 */

            default:
              return -1;
            }

        case REG:
        case SUBREG:
          if (!rtx_equal_p (x7, operands[2]))
            return -1;
          x8 = XEXP (x3, 2);
          if (x8 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x5 = XEXP (x2, 2);
          operands[5] = x5;
          if (!register_operand (operands[5], E_QImode))
            return -1;
          x9 = XEXP (x2, 1);
          if (!rtx_equal_p (x9, operands[1]))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1620 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
                  || !
#line 14199 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
                return -1;
              return 7058; /* avx512f_sfixupimmv4sf_mask */

            case E_V2DFmode:
              if (pattern1620 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
                  || !(
#line 14199 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 7060; /* avx512f_sfixupimmv2df_mask */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_158 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  switch (GET_CODE (x3))
    {
    case CONST_INT:
    case CONST_DOUBLE:
    case CONST_VECTOR:
      operands[4] = x3;
      x4 = XEXP (x2, 2);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
          operands[5] = x4;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1377 (x2, 
E_V4SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4SFmode)
                  && nonimmediate_operand (operands[2], E_V4SFmode)
                  && nonimmediate_operand (operands[3], E_V4SFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3948; /* *fma_fnmsub_v4sf */
              if (!bcst_vector_operand (operands[1], E_V4SFmode)
                  || !bcst_vector_operand (operands[2], E_V4SFmode)
                  || !bcst_vector_operand (operands[3], E_V4SFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3980; /* fma_fnmsub_v4sf_maskz_1 */

            case E_V2DFmode:
              if (pattern1377 (x2, 
E_V2DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V2DFmode)
                  && nonimmediate_operand (operands[2], E_V2DFmode)
                  && nonimmediate_operand (operands[3], E_V2DFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3952; /* *fma_fnmsub_v2df */
              if (!bcst_vector_operand (operands[1], E_V2DFmode)
                  || !bcst_vector_operand (operands[2], E_V2DFmode)
                  || !bcst_vector_operand (operands[3], E_V2DFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3989; /* fma_fnmsub_v2df_maskz_1 */

            case E_V8SFmode:
              if (pattern1377 (x2, 
E_V8SFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V8SFmode)
                  && nonimmediate_operand (operands[2], E_V8SFmode)
                  && nonimmediate_operand (operands[3], E_V8SFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3956; /* *fma_fnmsub_v8sf */
              if (!bcst_vector_operand (operands[1], E_V8SFmode)
                  || !bcst_vector_operand (operands[2], E_V8SFmode)
                  || !bcst_vector_operand (operands[3], E_V8SFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3978; /* fma_fnmsub_v8sf_maskz_1 */

            case E_V4DFmode:
              if (pattern1377 (x2, 
E_V4DFmode) != 0)
                return -1;
              if (nonimmediate_operand (operands[1], E_V4DFmode)
                  && nonimmediate_operand (operands[2], E_V4DFmode)
                  && nonimmediate_operand (operands[3], E_V4DFmode)
                  && 
#line 6230 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_FMA4))
                return 3960; /* *fma_fnmsub_v4df */
              if (!bcst_vector_operand (operands[1], E_V4DFmode)
                  || !bcst_vector_operand (operands[2], E_V4DFmode)
                  || !bcst_vector_operand (operands[3], E_V4DFmode)
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5938 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
                return -1;
              return 3987; /* fma_fnmsub_v4df_maskz_1 */

            case E_V32HFmode:
              if (pattern1378 (x2, 
E_SImode, 
E_V32HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5931 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
                return -1;
              return 3964; /* fma_fnmsub_v32hf_maskz_1 */

            case E_V16HFmode:
              if (pattern1378 (x2, 
E_HImode, 
E_V16HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (32 == 64 || TARGET_AVX512VL) && 1) && 
#line 5932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3968; /* fma_fnmsub_v16hf_maskz_1 */

            case E_V8HFmode:
              if (pattern1378 (x2, 
E_QImode, 
E_V8HFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (16 == 64 || TARGET_AVX512VL) && 1) && 
#line 5933 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
                return -1;
              return 3970; /* fma_fnmsub_v8hf_maskz_1 */

            case E_V16SFmode:
              if (pattern1378 (x2, 
E_HImode, 
E_V16SFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5935 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3974; /* fma_fnmsub_v16sf_maskz_1 */

            case E_V8DFmode:
              if (pattern1378 (x2, 
E_QImode, 
E_V8DFmode) != 0
                  || !(
#line 6263 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && (64 == 64 || TARGET_AVX512VL) && 1) && 
#line 5937 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                return -1;
              return 3983; /* fma_fnmsub_v8df_maskz_1 */

            case E_V32BFmode:
              if (pattern1379 (x2, 
E_SImode, 
E_V32BFmode) != 0
                  || !
#line 32589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10593; /* avx10_2_fnmsubbf16_v32bf_maskz_1 */

            case E_V16BFmode:
              if (pattern1379 (x2, 
E_HImode, 
E_V16BFmode) != 0
                  || !
#line 32589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10595; /* avx10_2_fnmsubbf16_v16bf_maskz_1 */

            case E_V8BFmode:
              if (pattern1379 (x2, 
E_QImode, 
E_V8BFmode) != 0
                  || !
#line 32589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
                return -1;
              return 10597; /* avx10_2_fnmsubbf16_v8bf_maskz_1 */

            default:
              return -1;
            }

        case CONST_INT:
          if (XWINT (x4, 0) != 1L)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V4SFmode:
              if (pattern1380 (x2, 
E_V4SFmode) != 0
                  || !
#line 7008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4))
                return -1;
              return 4250; /* *fma4i_vmfnmsub_v4sf */

            case E_V2DFmode:
              if (pattern1380 (x2, 
E_V2DFmode) != 0
                  || !(
#line 7008 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA4) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 4251; /* *fma4i_vmfnmsub_v2df */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case REG:
    case SUBREG:
    case MEM:
      switch (pattern636 (x2))
        {
        case 0:
          if (pattern1284 (x2, 
E_V32HFmode, 
E_SImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V32HFmode)
              && vector_operand (operands[3], E_V32HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return 3990; /* avx512bw_fnmsub_v32hf_mask */
          if (!vector_operand (operands[1], E_V32HFmode)
              || !nonimmediate_operand (operands[3], E_V32HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 524 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)))
            return -1;
          return 4002; /* avx512bw_fnmsub_v32hf_mask3 */

        case 1:
          if (pattern1284 (x2, 
E_V16HFmode, 
E_HImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V16HFmode)
              && vector_operand (operands[3], E_V16HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3992; /* avx512vl_fnmsub_v16hf_mask */
          if (!vector_operand (operands[1], E_V16HFmode)
              || !nonimmediate_operand (operands[3], E_V16HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 525 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4004; /* avx512vl_fnmsub_v16hf_mask3 */

        case 2:
          if (pattern1284 (x2, 
E_V8HFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8HFmode)
              && vector_operand (operands[3], E_V8HFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return 3993; /* avx512fp16_fnmsub_v8hf_mask */
          if (!vector_operand (operands[1], E_V8HFmode)
              || !nonimmediate_operand (operands[3], E_V8HFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4006; /* avx512fp16_fnmsub_v8hf_mask3 */

        case 3:
          if (pattern1284 (x2, 
E_V16SFmode, 
E_HImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V16SFmode)
              && vector_operand (operands[3], E_V16SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3994; /* avx512f_fnmsub_v16sf_mask */
          if (!vector_operand (operands[1], E_V16SFmode)
              || !nonimmediate_operand (operands[3], E_V16SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4008; /* avx512f_fnmsub_v16sf_mask3 */

        case 4:
          if (pattern1284 (x2, 
E_V8SFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8SFmode)
              && vector_operand (operands[3], E_V8SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3996; /* avx512vl_fnmsub_v8sf_mask */
          if (!vector_operand (operands[1], E_V8SFmode)
              || !nonimmediate_operand (operands[3], E_V8SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4010; /* avx512vl_fnmsub_v8sf_mask3 */

        case 5:
          if (pattern1284 (x2, 
E_V4SFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V4SFmode)
              && vector_operand (operands[3], E_V4SFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 3997; /* avx512vl_fnmsub_v4sf_mask */
          if (!vector_operand (operands[1], E_V4SFmode)
              || !nonimmediate_operand (operands[3], E_V4SFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 527 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4012; /* avx512vl_fnmsub_v4sf_mask3 */

        case 6:
          if (pattern1284 (x2, 
E_V8DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V8DFmode)
              && vector_operand (operands[3], E_V8DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return 3998; /* avx512f_fnmsub_v8df_mask */
          if (!vector_operand (operands[1], E_V8DFmode)
              || !nonimmediate_operand (operands[3], E_V8DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 4014; /* avx512f_fnmsub_v8df_mask3 */

        case 7:
          if (pattern1284 (x2, 
E_V4DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V4DFmode)
              && vector_operand (operands[3], E_V4DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4000; /* avx512vl_fnmsub_v4df_mask */
          if (!vector_operand (operands[1], E_V4DFmode)
              || !nonimmediate_operand (operands[3], E_V4DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4016; /* avx512vl_fnmsub_v4df_mask3 */

        case 8:
          if (pattern1284 (x2, 
E_V2DFmode, 
E_QImode) != 0)
            return -1;
          if (nonimmediate_operand (operands[1], E_V2DFmode)
              && vector_operand (operands[3], E_V2DFmode)
              && rtx_equal_p (x3, operands[1])
              && (
#line 6308 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && 1) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return 4001; /* avx512vl_fnmsub_v2df_mask */
          if (!vector_operand (operands[1], E_V2DFmode)
              || !nonimmediate_operand (operands[3], E_V2DFmode)
              || !rtx_equal_p (x3, operands[3])
              || !(
#line 6327 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 528 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 4018; /* avx512vl_fnmsub_v2df_mask3 */

        case 9:
          if (pattern1285 (x2, 
E_SImode, 
E_V32BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10598; /* avx10_2_fnmsubbf16_v32bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32628 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10601; /* avx10_2_fnmsubbf16_v32bf_mask3 */

        case 10:
          if (pattern1285 (x2, 
E_HImode, 
E_V16BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10599; /* avx10_2_fnmsubbf16_v16bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32628 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10602; /* avx10_2_fnmsubbf16_v16bf_mask3 */

        case 11:
          if (pattern1285 (x2, 
E_QImode, 
E_V8BFmode) != 0)
            return -1;
          if (rtx_equal_p (x3, operands[1])
              && 
#line 32609 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return 10600; /* avx10_2_fnmsubbf16_v8bf_mask */
          if (!rtx_equal_p (x3, operands[3])
              || !
#line 32628 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))
            return -1;
          return 10603; /* avx10_2_fnmsubbf16_v8bf_mask3 */

        case 12:
          if (pattern1381 (x2, 
E_V8HFmode) != 0
              || !(
#line 6655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
            return -1;
          return 4166; /* *fmai_fnmsub_v8hf */

        case 13:
          if (pattern1381 (x2, 
E_V4SFmode) != 0
              || !
#line 6655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F))
            return -1;
          return 4168; /* *fmai_fnmsub_v4sf */

        case 14:
          if (pattern1381 (x2, 
E_V2DFmode) != 0
              || !(
#line 6655 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_FMA || TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
            return -1;
          return 4170; /* *fmai_fnmsub_v2df */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_166 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 0);
  if (GET_CODE (x5) != CONST_INT)
    return -1;
  operands[2] = x5;
  if (const_0_to_7_operand (operands[2], E_VOIDmode))
    {
      x6 = XVECEXP (x4, 0, 1);
      operands[3] = x6;
      if (const_0_to_7_operand (operands[3], E_VOIDmode))
        {
          x7 = XEXP (x2, 1);
          operands[4] = x7;
          x8 = XEXP (x2, 2);
          operands[5] = x8;
          if (register_operand (operands[5], E_QImode))
            {
              switch (GET_MODE (operands[0]))
                {
                case E_V2DFmode:
                  if (pattern1528 (x2, 
E_V2DFmode, 
E_V8DFmode) == 0
                      && (
#line 12421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[4]))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return 5240; /* avx512dq_vextractf64x2_1_mask */
                  break;

                case E_V2DImode:
                  if (pattern1528 (x2, 
E_V2DImode, 
E_V8DImode) == 0
                      && (
#line 12421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && INTVAL (operands[2]) % 2 == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[4]))) && 
#line 717 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
                    return 5241; /* avx512dq_vextracti64x2_1_mask */
                  break;

                default:
                  break;
                }
            }
        }
    }
  x6 = XVECEXP (x4, 0, 1);
  if (GET_CODE (x6) != CONST_INT)
    return -1;
  x7 = XEXP (x2, 1);
  operands[2] = x7;
  x8 = XEXP (x2, 2);
  operands[3] = x8;
  if (!register_operand (operands[3], E_QImode))
    return -1;
  switch (XWINT (x5, 0))
    {
    case 0L:
      if (XWINT (x6, 0) != 1L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || pattern1529 (x2, 
E_V2DImode, 
E_V4DImode) != 0
              || !
#line 12851 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5264; /* vec_extract_lo_v4di_mask */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || pattern1529 (x2, 
E_V2DFmode, 
E_V4DFmode) != 0
              || !
#line 12851 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5265; /* vec_extract_lo_v4df_mask */

        default:
          return -1;
        }

    case 2L:
      if (XWINT (x6, 0) != 3L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V2DImode:
          if (!nonimmediate_operand (operands[0], E_V2DImode)
              || pattern1529 (x2, 
E_V2DImode, 
E_V4DImode) != 0
              || !
#line 12888 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5268; /* vec_extract_hi_v4di_mask */

        case E_V2DFmode:
          if (!nonimmediate_operand (operands[0], E_V2DFmode)
              || pattern1529 (x2, 
E_V2DFmode, 
E_V4DFmode) != 0
              || !
#line 12888 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ
   && TARGET_AVX512VL
   && (!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[2]))))
            return -1;
          return 5269; /* vec_extract_hi_v4df_mask */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_173 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19, x20;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 1);
  x5 = XVECEXP (x4, 0, 1);
  operands[3] = x5;
  x6 = XVECEXP (x4, 0, 2);
  operands[4] = x6;
  x7 = XVECEXP (x4, 0, 3);
  operands[5] = x7;
  x8 = XVECEXP (x4, 0, 5);
  operands[7] = x8;
  x9 = XVECEXP (x4, 0, 6);
  operands[8] = x9;
  x10 = XVECEXP (x4, 0, 7);
  operands[9] = x10;
  x11 = XVECEXP (x4, 0, 8);
  operands[10] = x11;
  x12 = XVECEXP (x4, 0, 9);
  operands[11] = x12;
  x13 = XVECEXP (x4, 0, 10);
  operands[12] = x13;
  x14 = XVECEXP (x4, 0, 11);
  operands[13] = x14;
  x15 = XVECEXP (x4, 0, 12);
  operands[14] = x15;
  x16 = XVECEXP (x4, 0, 13);
  operands[15] = x16;
  x17 = XVECEXP (x4, 0, 14);
  operands[16] = x17;
  x18 = XVECEXP (x4, 0, 15);
  operands[17] = x18;
  x19 = XEXP (x2, 1);
  operands[18] = x19;
  x20 = XEXP (x2, 2);
  operands[19] = x20;
  if (!register_operand (operands[19], E_HImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!register_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || GET_MODE (x3) != E_V16SFmode
          || !register_operand (operands[1], E_V16SFmode)
          || pattern1837 () != 0
          || !nonimm_or_0_operand (operands[18], E_V16SFmode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20453 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 8361; /* *avx512f_shuf_f32x4_1_mask_1 */

    case E_V16SImode:
      if (!register_operand (operands[0], E_V16SImode)
          || GET_MODE (x2) != E_V16SImode
          || GET_MODE (x3) != E_V16SImode
          || !nonimm_or_0_operand (operands[18], E_V16SImode))
        return -1;
      if (register_operand (operands[1], E_V16SImode)
          && pattern1837 () == 0
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 20453 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F
   && (INTVAL (operands[2]) & 3) == 0
   && INTVAL (operands[2]) == INTVAL (operands[3]) - 1
   && INTVAL (operands[2]) == INTVAL (operands[4]) - 2
   && INTVAL (operands[2]) == INTVAL (operands[5]) - 3
   && (INTVAL (operands[6]) & 3) == 0
   && INTVAL (operands[6]) == INTVAL (operands[7]) - 1
   && INTVAL (operands[6]) == INTVAL (operands[8]) - 2
   && INTVAL (operands[6]) == INTVAL (operands[9]) - 3
   && (INTVAL (operands[10]) & 3) == 0
   && INTVAL (operands[10]) == INTVAL (operands[11]) - 1
   && INTVAL (operands[10]) == INTVAL (operands[12]) - 2
   && INTVAL (operands[10]) == INTVAL (operands[13]) - 3
   && (INTVAL (operands[14]) & 3) == 0
   && INTVAL (operands[14]) == INTVAL (operands[15]) - 1
   && INTVAL (operands[14]) == INTVAL (operands[16]) - 2
   && INTVAL (operands[14]) == INTVAL (operands[17]) - 3) && 
#line 721 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 8363; /* *avx512f_shuf_i32x4_1_mask_1 */
      if (!nonimmediate_operand (operands[1], E_V16SImode)
          || pattern1793 () != 0
          || !const_8_to_11_operand (operands[10], E_VOIDmode)
          || !const_8_to_11_operand (operands[11], E_VOIDmode)
          || !const_8_to_11_operand (operands[12], E_VOIDmode)
          || !const_8_to_11_operand (operands[13], E_VOIDmode)
          || !const_12_to_15_operand (operands[14], E_VOIDmode)
          || !const_12_to_15_operand (operands[15], E_VOIDmode)
          || !const_12_to_15_operand (operands[16], E_VOIDmode)
          || !const_12_to_15_operand (operands[17], E_VOIDmode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 20535 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512
   && INTVAL (operands[2]) + 4 == INTVAL (operands[6])
   && INTVAL (operands[3]) + 4 == INTVAL (operands[7])
   && INTVAL (operands[4]) + 4 == INTVAL (operands[8])
   && INTVAL (operands[5]) + 4 == INTVAL (operands[9])
   && INTVAL (operands[2]) + 8 == INTVAL (operands[10])
   && INTVAL (operands[3]) + 8 == INTVAL (operands[11])
   && INTVAL (operands[4]) + 8 == INTVAL (operands[12])
   && INTVAL (operands[5]) + 8 == INTVAL (operands[13])
   && INTVAL (operands[2]) + 12 == INTVAL (operands[14])
   && INTVAL (operands[3]) + 12 == INTVAL (operands[15])
   && INTVAL (operands[4]) + 12 == INTVAL (operands[16])
   && INTVAL (operands[5]) + 12 == INTVAL (operands[17]))))
        return -1;
      return 8365; /* avx512f_pshufd_1_mask */

    default:
      return -1;
    }
}

 int
recog_184 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  operands[1] = x4;
  x5 = XEXP (x3, 1);
  operands[2] = x5;
  x6 = XEXP (x2, 1);
  operands[3] = x6;
  x7 = XEXP (x2, 2);
  operands[4] = x7;
  switch (GET_MODE (operands[0]))
    {
    case E_V16HImode:
      if (pattern129 (x2, 
E_HImode, 
E_V16HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7536; /* ashrv16hi3_mask */
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9496; /* avx512vl_ashrvv16hi_mask */

    case E_V8HImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 793 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7538; /* ashrv8hi3_mask */
      if (!register_operand (operands[1], E_V8HImode)
          || !nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9494; /* avx512vl_ashrvv8hi_mask */

    case E_V8SImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7540; /* ashrv8si3_mask */
      if (!register_operand (operands[1], E_V8SImode)
          || !nonimmediate_operand (operands[2], E_V8SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29144 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9484; /* avx2_ashrvv8si_mask */

    case E_V4SImode:
      if (pattern129 (x2, 
E_QImode, 
E_V4SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7542; /* ashrv4si3_mask */
      if (!register_operand (operands[1], E_V4SImode)
          || !nonimmediate_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29144 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9482; /* avx2_ashrvv4si_mask */

    case E_V2DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V2DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17080 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7544; /* ashrv2di3_mask */
      if (!register_operand (operands[1], E_V2DImode)
          || !nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29144 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL)) && 
#line 681 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9488; /* avx2_ashrvv2di_mask */

    case E_V32HImode:
      if (pattern129 (x2, 
E_SImode, 
E_V32HImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 788 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
        return 7554; /* ashrv32hi3_mask */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29155 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9498; /* avx512bw_ashrvv32hi_mask */

    case E_V4DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V4DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return 7556; /* ashrv4di3_mask */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29144 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL)) && 
#line 681 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9490; /* avx2_ashrvv4di_mask */

    case E_V16SImode:
      if (pattern129 (x2, 
E_HImode, 
E_V16SImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7558; /* ashrv16si3_mask */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29144 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 680 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9486; /* avx512f_ashrvv16si_mask */

    case E_V8DImode:
      if (pattern129 (x2, 
E_QImode, 
E_V8DImode) != 0)
        return -1;
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17124 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 789 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7560; /* ashrv8di3_mask */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29144 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 682 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9492; /* avx512f_ashrvv8di_mask */

    default:
      return -1;
    }
}

 int
recog_186 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern142 (x2))
    {
    case 0:
      if (nonimmediate_operand (operands[1], E_V16HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7573; /* lshrv16hi3_mask */
      if (!register_operand (operands[1], E_V16HImode)
          || !nonimmediate_operand (operands[2], E_V16HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9530; /* avx512vl_lshrvv16hi_mask */

    case 1:
      if (nonimmediate_operand (operands[1], E_V8HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 798 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))))
        return 7577; /* lshrv8hi3_mask */
      if (!register_operand (operands[1], E_V8HImode)
          || !nonimmediate_operand (operands[2], E_V8HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 9526; /* avx512vl_lshrvv8hi_mask */

    case 2:
      if (nonimmediate_operand (operands[1], E_V8SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7581; /* lshrv8si3_mask */
      if (!register_operand (operands[1], E_V8SImode)
          || !nonimmediate_operand (operands[2], E_V8SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9506; /* avx2_lshrvv8si_mask */

    case 3:
      if (nonimmediate_operand (operands[1], E_V4SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7585; /* lshrv4si3_mask */
      if (!register_operand (operands[1], E_V4SImode)
          || !nonimmediate_operand (operands[2], E_V4SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9510; /* avx2_lshrvv4si_mask */

    case 4:
      if (nonimmediate_operand (operands[1], E_V4DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7589; /* lshrv4di3_mask */
      if (!register_operand (operands[1], E_V4DImode)
          || !nonimmediate_operand (operands[2], E_V4DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (32 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9518; /* avx2_lshrvv4di_mask */

    case 5:
      if (nonimmediate_operand (operands[1], E_V2DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 17276 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
        return 7593; /* lshrv2di3_mask */
      if (!register_operand (operands[1], E_V2DImode)
          || !nonimmediate_operand (operands[2], E_V2DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 29166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (16 == 64 || TARGET_AVX512VL))))
        return -1;
      return 9522; /* avx2_lshrvv2di_mask */

    case 6:
      if (nonimmediate_operand (operands[1], E_V32HImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512))))
        return 7613; /* lshrv32hi3_mask */
      if (!register_operand (operands[1], E_V32HImode)
          || !nonimmediate_operand (operands[2], E_V32HImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29177 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 685 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 9534; /* avx512bw_lshrvv32hi_mask */

    case 7:
      if (nonimmediate_operand (operands[1], E_V16SImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 784 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7617; /* lshrv16si3_mask */
      if (!register_operand (operands[1], E_V16SImode)
          || !nonimmediate_operand (operands[2], E_V16SImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 803 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9502; /* avx512f_lshrvv16si_mask */

    case 8:
      if (nonimmediate_operand (operands[1], E_V8DImode)
          && nonmemory_operand (operands[2], E_DImode)
          && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 17364 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 785 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return 7621; /* lshrv8di3_mask */
      if (!register_operand (operands[1], E_V8DImode)
          || !nonimmediate_operand (operands[2], E_V8DImode)
          || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 29166 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && (64 == 64 || TARGET_AVX512VL)) && 
#line 804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))))
        return -1;
      return 9514; /* avx512f_lshrvv8di_mask */

    default:
      return -1;
    }
}

 int
recog_191 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern151 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24121 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512BW && TARGET_AVX512VL)))
        return -1;
      return 8683; /* avx2_zero_extendv16qiv16hi2_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24175 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW && TARGET_EVEX512)))
        return -1;
      return 8691; /* avx512bw_zero_extendv32qiv32hi2_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24245 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512BW && TARGET_AVX512VL)))
        return -1;
      return 8703; /* *sse4_1_zero_extendv8qiv8hi2_mask_1 */

    case 3:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24396 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8715; /* avx512f_zero_extendv16qiv16si2_mask */

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24595 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8745; /* avx512f_zero_extendv16hiv16si2_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24428 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8723; /* *avx2_zero_extendv8qiv8si2_mask_1 */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24648 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8753; /* avx2_zero_extendv8hiv8si2_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24516 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8735; /* *sse4_1_zero_extendv4qiv4si2_mask_1 */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24718 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8765; /* *sse4_1_zero_extendv4hiv4si2_mask_1 */

    case 9:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24874 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8781; /* *avx512f_zero_extendv8qiv8di2_mask_1 */

    case 10:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25100 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8812; /* avx512f_zero_extendv8hiv8di2_mask */

    case 11:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25290 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 8840; /* avx512f_zero_extendv8siv8di2_mask */

    case 12:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24958 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8793; /* *avx2_zero_extendv4qiv4di2_mask_1 */

    case 13:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25130 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8820; /* *avx2_zero_extendv4hiv4di2_mask_1 */

    case 14:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25341 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
        return -1;
      return 8846; /* avx2_zero_extendv4siv4di2_mask */

    case 15:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8805; /* *sse4_1_zero_extendv2qiv2di2_mask_1 */

    case 16:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25213 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8832; /* *sse4_1_zero_extendv2hiv2di2_mask_1 */

    case 17:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25407 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
        return -1;
      return 8856; /* *sse4_1_zero_extendv2siv2di2_mask_1 */

    case 18:
      x3 = XEXP (x2, 0);
      x4 = XEXP (x3, 0);
      x5 = XEXP (x4, 0);
      operands[1] = x5;
      switch (pattern896 (x2))
        {
        case 0:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24233 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512BW && TARGET_AVX512VL)))
            return 8699; /* sse4_1_zero_extendv8qiv8hi2_mask */
          break;

        case 1:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24417 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
            return 8719; /* avx2_zero_extendv8qiv8si2_mask */
          break;

        case 2:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24864 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return 8777; /* avx512f_zero_extendv8qiv8di2_mask */
          break;

        case 3:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24504 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8731; /* sse4_1_zero_extendv4qiv4si2_mask */
          break;

        case 4:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24706 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8761; /* sse4_1_zero_extendv4hiv4si2_mask */
          break;

        case 5:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24947 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
            return 8789; /* avx2_zero_extendv4qiv4di2_mask */
          break;

        case 6:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25119 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2 && TARGET_AVX512VL)))
            return 8816; /* avx2_zero_extendv4hiv4di2_mask */
          break;

        case 7:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25037 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8801; /* sse4_1_zero_extendv2qiv2di2_mask */
          break;

        case 8:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25201 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8828; /* sse4_1_zero_extendv2hiv2di2_mask */
          break;

        case 9:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 25395 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL)))
            return 8852; /* sse4_1_zero_extendv2siv2di2_mask */
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG
          || maybe_ne (SUBREG_BYTE (x5), 0))
        return -1;
      switch (pattern412 (x2))
        {
        case 0:
          if (!
#line 24292 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512BW
   && ix86_pre_reload_split ()))
            return -1;
          return 8707; /* *avx512vl_zero_extendv8qiv8hi2_mask_2 */

        case 1:
          if (!
#line 24470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL
   && ix86_pre_reload_split ()))
            return -1;
          return 8727; /* *avx512vl_zero_extendv8qiv8si2_mask_2 */

        case 2:
          if (!
#line 24914 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && ix86_pre_reload_split ()))
            return -1;
          return 8785; /* *avx512f_zero_extendv8qiv8di2_mask_2 */

        case 3:
          if (!
#line 24758 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL
   && ix86_pre_reload_split ()))
            return -1;
          return 8769; /* *avx512vl_zero_extendv4hiv4si2_mask_2 */

        case 4:
          if (!
#line 25168 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL
   && ix86_pre_reload_split ()))
            return -1;
          return 8824; /* *avx512vl_zero_extendv4hiv4di2_mask_2 */

        case 5:
          if (!
#line 25445 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL
   && ix86_pre_reload_split ()))
            return -1;
          return 8860; /* *avx512vl_zero_extendv2siv2di2_mask_2 */

        case 6:
          if ((
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 24539 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE4_1 && TARGET_AVX512VL
   && ix86_pre_reload_split ())))
            return 8739; /* *sse4_1_zero_extendv4qiv4si2_2 */
          if (!
#line 24564 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL
   && ix86_pre_reload_split ()))
            return -1;
          return 8741; /* *avx512vl_zero_extendv4qiv4si2_mask_2 */

        case 7:
          if (!
#line 25004 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL
   && ix86_pre_reload_split ()))
            return -1;
          return 8797; /* *avx512vl_zero_extendv4qiv4di2_mask_2 */

        case 8:
          if (!
#line 25259 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL
   && ix86_pre_reload_split ()))
            return -1;
          return 8836; /* *avx512vl_zero_extendv2hiv2di2_mask_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_200 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  switch (pattern138 (x2))
    {
    case 0:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4548; /* avx512fp16_fixuns_truncv8hi2_mask */

    case 1:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 4556; /* avx512fp16_fixuns_truncv16hi2_mask */

    case 2:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 693 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4564; /* avx512fp16_fixuns_truncv32hi2_mask */

    case 3:
      switch (GET_MODE (operands[1]))
        {
        case E_V8HFmode:
          if (!vector_operand (operands[1], E_V8HFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
            return -1;
          return 4572; /* avx512fp16_fixuns_truncv8si2_mask */

        case E_V8DFmode:
          if (!vector_operand (operands[1], E_V8DFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9557 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 4963; /* fixuns_truncv8dfv8si2_mask */

        case E_V8SFmode:
          if (!nonimmediate_operand (operands[1], E_V8SFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9900 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 440 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))))
            return -1;
          return 5063; /* fixuns_truncv8sfv8si2_mask */

        default:
          return -1;
        }

    case 4:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 694 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4580; /* avx512fp16_fixuns_truncv16si2_mask */

    case 5:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8764 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 4814; /* fixuns_truncv16sfv16si2_mask */

    case 6:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 7869 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16) && 
#line 695 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 4588; /* avx512fp16_fixuns_truncv8di2_mask */

    case 7:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 5000; /* fixuns_truncv8dfv8di2_mask */

    case 8:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512))))
        return -1;
      return 5044; /* fixuns_truncv8sfv8di2_mask */

    case 9:
      switch (GET_MODE (operands[1]))
        {
        case E_V4HFmode:
          if (!memory_operand (operands[1], E_V4HFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7919 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
            return -1;
          return 4609; /* *avx512fp16_fixuns_truncv4si2_load_mask */

        case E_V4DFmode:
          if (!nonimmediate_operand (operands[1], E_V4DFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9665 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && TARGET_AVX512F)))
            return -1;
          return 4977; /* fixuns_truncv4dfv4si2_mask */

        case E_V4SFmode:
          if (!nonimmediate_operand (operands[1], E_V4SFmode)
              || !(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9900 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL)))
            return -1;
          return 5065; /* fixuns_truncv4sfv4si2_mask */

        default:
          return -1;
        }

    case 10:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7919 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4613; /* *avx512fp16_fixuns_truncv4di2_load_mask */

    case 11:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5005; /* fixuns_truncv4dfv4di2_mask */

    case 12:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9729 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 626 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5049; /* fixuns_truncv4sfv4di2_mask */

    case 13:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7969 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4625; /* *avx512fp16_fixuns_truncv2di2_load_mask */

    case 14:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 9686 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && 1) && 
#line 536 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL))))
        return -1;
      return 5009; /* fixuns_truncv2dfv2di2_mask */

    case 15:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7909 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4601; /* avx512fp16_fixuns_truncv4si2_mask */

    case 16:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7909 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4605; /* avx512fp16_fixuns_truncv4di2_mask */

    case 17:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7959 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)))
        return -1;
      return 4621; /* avx512fp16_fixuns_truncv2di2_mask */

    case 18:
      if (!(
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9752 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ && TARGET_AVX512VL)))
        return -1;
      return 5057; /* avx512dq_fixuns_truncv2sfv2di2_mask */

    default:
      return -1;
    }
}

 int
recog_211 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  operands[1] = x3;
  switch (GET_MODE (operands[0]))
    {
    case E_V16SFmode:
      if (!memory_operand (operands[0], E_V16SFmode)
          || GET_MODE (x2) != E_V16SFmode
          || !register_operand (operands[1], E_V16SFmode)
          || !(
#line 2023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2563; /* avx512f_movntv16sf */

    case E_V8SFmode:
      if (!memory_operand (operands[0], E_V8SFmode)
          || GET_MODE (x2) != E_V8SFmode
          || !register_operand (operands[1], E_V8SFmode)
          || !(
#line 2023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2564; /* avx_movntv8sf */

    case E_V4SFmode:
      if (!memory_operand (operands[0], E_V4SFmode)
          || GET_MODE (x2) != E_V4SFmode
          || !register_operand (operands[1], E_V4SFmode)
          || !
#line 2023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
        return -1;
      return 2565; /* sse_movntv4sf */

    case E_V8DFmode:
      if (!memory_operand (operands[0], E_V8DFmode)
          || GET_MODE (x2) != E_V8DFmode
          || !register_operand (operands[1], E_V8DFmode)
          || !(
#line 2023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2566; /* avx512f_movntv8df */

    case E_V4DFmode:
      if (!memory_operand (operands[0], E_V4DFmode)
          || GET_MODE (x2) != E_V4DFmode
          || !register_operand (operands[1], E_V4DFmode)
          || !(
#line 2023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2567; /* avx_movntv4df */

    case E_V2DFmode:
      if (!memory_operand (operands[0], E_V2DFmode)
          || GET_MODE (x2) != E_V2DFmode
          || !register_operand (operands[1], E_V2DFmode)
          || !(
#line 2023 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 376 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
        return -1;
      return 2568; /* sse2_movntv2df */

    case E_V8DImode:
      if (!memory_operand (operands[0], E_V8DImode)
          || GET_MODE (x2) != E_V8DImode
          || !register_operand (operands[1], E_V8DImode)
          || !(
#line 2033 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
        return -1;
      return 2569; /* avx512f_movntv8di */

    case E_V4DImode:
      if (!memory_operand (operands[0], E_V4DImode)
          || GET_MODE (x2) != E_V4DImode
          || !register_operand (operands[1], E_V4DImode)
          || !(
#line 2033 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2) && 
#line 614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
        return -1;
      return 2570; /* avx_movntv4di */

    case E_V2DImode:
      if (!memory_operand (operands[0], E_V2DImode)
          || GET_MODE (x2) != E_V2DImode
          || !register_operand (operands[1], E_V2DImode)
          || !
#line 2033 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))
        return -1;
      return 2571; /* sse2_movntv2di */

    default:
      return -1;
    }
}

 int
recog_221 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 0);
  x4 = XEXP (x3, 0);
  x5 = XEXP (x4, 0);
  switch (GET_CODE (x5))
    {
    case PLUS:
      switch (pattern777 (x2))
        {
        case 0:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
            return -1;
          return 2764; /* avx512fp16_vmaddv8hf3_mask_round */

        case 1:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
            return -1;
          return 2772; /* sse_vmaddv4sf3_mask_round */

        case 2:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2780; /* sse2_vmaddv2df3_mask_round */

        default:
          return -1;
        }

    case MINUS:
      switch (pattern777 (x2))
        {
        case 0:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
            return -1;
          return 2768; /* avx512fp16_vmsubv8hf3_mask_round */

        case 1:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
            return -1;
          return 2776; /* sse_vmsubv4sf3_mask_round */

        case 2:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2713 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2784; /* sse2_vmsubv2df3_mask_round */

        default:
          return -1;
        }

    case MULT:
      switch (pattern777 (x2))
        {
        case 0:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
            return -1;
          return 2830; /* avx512fp16_vmmulv8hf3_mask_round */

        case 1:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
            return -1;
          return 2838; /* sse_vmmulv4sf3_mask_round */

        case 2:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2846; /* sse2_vmmulv2df3_mask_round */

        default:
          return -1;
        }

    case DIV:
      switch (pattern777 (x2))
        {
        case 0:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
            return -1;
          return 2834; /* avx512fp16_vmdivv8hf3_mask_round */

        case 1:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
            return -1;
          return 2842; /* sse_vmdivv4sf3_mask_round */

        case 2:
          if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 2804 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2850; /* sse2_vmdivv2df3_mask_round */

        default:
          return -1;
        }

    case SQRT:
      x6 = XEXP (x3, 2);
      if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x7 = XEXP (x5, 0);
      operands[1] = x7;
      x8 = XEXP (x4, 1);
      operands[3] = x8;
      x9 = XEXP (x4, 2);
      operands[4] = x9;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      x10 = XEXP (x3, 1);
      operands[2] = x10;
      x11 = XVECEXP (x2, 0, 1);
      operands[5] = x11;
      if (!const_4_or_8_to_11_operand (operands[5], E_SImode))
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V8HFmode:
          if (pattern1532 (x2, 
E_V8HFmode) != 0
              || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
            return -1;
          return 2931; /* avx512fp16_vmsqrtv8hf2_mask_round */

        case E_V4SFmode:
          if (pattern1532 (x2, 
E_V4SFmode) != 0
              || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
            return -1;
          return 2935; /* sse_vmsqrtv4sf2_mask_round */

        case E_V2DFmode:
          if (pattern1532 (x2, 
E_V2DFmode) != 0
              || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3086 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 2939; /* sse2_vmsqrtv2df2_mask_round */

        default:
          return -1;
        }

    case VEC_DUPLICATE:
      x11 = XVECEXP (x2, 0, 1);
      operands[5] = x11;
      x7 = XEXP (x5, 0);
      switch (GET_CODE (x7))
        {
        case SQRT:
          x6 = XEXP (x3, 2);
          if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
            return -1;
          x12 = XEXP (x7, 0);
          operands[1] = x12;
          x8 = XEXP (x4, 1);
          operands[3] = x8;
          x9 = XEXP (x4, 2);
          operands[4] = x9;
          if (!register_operand (operands[4], E_QImode))
            return -1;
          x10 = XEXP (x3, 1);
          operands[2] = x10;
          if (!const_4_or_8_to_11_operand (operands[5], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V8HFmode:
              if (pattern1566 (x2, 
E_V8HFmode, 
E_HFmode) != 0
                  || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                return -1;
              return 2943; /* *avx512fp16_vmsqrtv8hf2_mask_round */

            case E_V4SFmode:
              if (pattern1566 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                  || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
                return -1;
              return 2947; /* *sse_vmsqrtv4sf2_mask_round */

            case E_V2DFmode:
              if (pattern1566 (x2, 
E_V2DFmode, 
E_DFmode) != 0
                  || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3105 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                return -1;
              return 2951; /* *sse2_vmsqrtv2df2_mask_round */

            default:
              return -1;
            }

        case FLOAT_EXTEND:
          x12 = XEXP (x7, 0);
          if (GET_CODE (x12) != VEC_SELECT
              || GET_MODE (x12) != E_HFmode
              || pattern1205 (x3) != 0)
            return -1;
          x13 = XEXP (x12, 0);
          operands[1] = x13;
          if (!register_operand (operands[1], E_V8HFmode))
            return -1;
          x8 = XEXP (x4, 1);
          operands[3] = x8;
          x9 = XEXP (x4, 2);
          operands[4] = x9;
          if (!register_operand (operands[4], E_QImode))
            return -1;
          x10 = XEXP (x3, 1);
          operands[2] = x10;
          if (!const48_operand (operands[5], E_SImode))
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_V2DFmode:
              if (pattern1749 (x2, 
E_V2DFmode, 
E_DFmode) != 0
                  || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4694; /* avx512fp16_vcvtsh2sd_mask_round */

            case E_V4SFmode:
              if (pattern1749 (x2, 
E_V4SFmode, 
E_SFmode) != 0
                  || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8289 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4698; /* avx512fp16_vcvtsh2ss_mask_round */

            default:
              return -1;
            }

        case FLOAT_TRUNCATE:
          if (!const_4_or_8_to_11_operand (operands[5], E_SImode))
            return -1;
          x12 = XEXP (x7, 0);
          switch (GET_CODE (x12))
            {
            case VEC_SELECT:
              if (pattern1205 (x3) != 0
                  || pattern1460 (x2, 
E_HFmode, 
E_V8HFmode) != 0)
                return -1;
              x13 = XEXP (x12, 0);
              operands[1] = x13;
              x8 = XEXP (x4, 1);
              operands[3] = x8;
              if (!nonimm_or_0_operand (operands[3], E_V8HFmode))
                return -1;
              x9 = XEXP (x4, 2);
              operands[4] = x9;
              if (!register_operand (operands[4], E_QImode))
                return -1;
              x10 = XEXP (x3, 1);
              operands[2] = x10;
              if (!register_operand (operands[2], E_V8HFmode))
                return -1;
              switch (GET_MODE (x12))
                {
                case E_DFmode:
                  if (!register_operand (operands[1], E_V2DFmode)
                      || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                    return -1;
                  return 4706; /* avx512fp16_vcvtsd2sh_mask_round */

                case E_SFmode:
                  if (!register_operand (operands[1], E_V4SFmode)
                      || !(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 8319 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                    return -1;
                  return 4710; /* avx512fp16_vcvtss2sh_mask_round */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
            case MEM:
              operands[2] = x12;
              if (!nonimmediate_operand (operands[2], E_V2DFmode))
                return -1;
              x9 = XEXP (x4, 2);
              if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
                  || pattern1460 (x2, 
E_V2SFmode, 
E_V4SFmode) != 0)
                return -1;
              x8 = XEXP (x4, 1);
              operands[1] = x8;
              if (!register_operand (operands[1], E_V4SFmode))
                return -1;
              x10 = XEXP (x3, 1);
              operands[3] = x10;
              if (!nonimm_or_0_operand (operands[3], E_V4SFmode))
                return -1;
              x6 = XEXP (x3, 2);
              operands[4] = x6;
              if (!register_operand (operands[4], E_QImode)
                  || !(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 9990 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                return -1;
              return 5074; /* sse2_cvtsd2ss_mask_round */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case SMAX:
      switch (pattern778 (x2))
        {
        case 0:
          if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
            return -1;
          return 3100; /* *avx512fp16_vmsmaxv8hf3_mask_round */

        case 1:
          if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
            return -1;
          return 3108; /* *sse_vmsmaxv4sf3_mask_round */

        case 2:
          if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 3116; /* *sse2_vmsmaxv2df3_mask_round */

        default:
          return -1;
        }

    case SMIN:
      switch (pattern778 (x2))
        {
        case 0:
          if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
            return -1;
          return 3104; /* *avx512fp16_vmsminv8hf3_mask_round */

        case 1:
          if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
            return -1;
          return 3112; /* *sse_vmsminv4sf3_mask_round */

        case 2:
          if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3470 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
            return -1;
          return 3120; /* *sse2_vmsminv2df3_mask_round */

        default:
          return -1;
        }

    case UNSPEC:
      switch (XVECLEN (x5, 0))
        {
        case 2:
          x6 = XEXP (x3, 2);
          if (GET_CODE (x6) != CONST_INT)
            return -1;
          switch (XINT (x5, 1))
            {
            case 63:
              switch (pattern1117 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 3124; /* avx512fp16_ieee_vmmaxv8hf3_mask_round */

                case 1:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
                    return -1;
                  return 3132; /* sse_ieee_vmmaxv4sf3_mask_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 3140; /* sse2_ieee_vmmaxv2df3_mask_round */

                default:
                  return -1;
                }

            case 62:
              switch (pattern1117 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 3128; /* avx512fp16_ieee_vmminv8hf3_mask_round */

                case 1:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))))
                    return -1;
                  return 3136; /* sse_ieee_vmminv4sf3_mask_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 3489 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 3144; /* sse2_ieee_vmminv2df3_mask_round */

                default:
                  return -1;
                }

            case 221:
              if (pattern1118 (x2) != 0
                  || !(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 389 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4331; /* avx512fp16_fmulcsh_v8hf_mask_round */

            case 222:
              if (pattern1118 (x2) != 0
                  || !(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 389 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7526 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                return -1;
              return 4335; /* avx512fp16_fcmulcsh_v8hf_mask_round */

            case 58:
              if (XWINT (x6, 0) != 1L)
                return -1;
              x14 = XVECEXP (x5, 0, 0);
              operands[1] = x14;
              x15 = XVECEXP (x5, 0, 1);
              operands[2] = x15;
              x8 = XEXP (x4, 1);
              operands[3] = x8;
              x9 = XEXP (x4, 2);
              operands[4] = x9;
              if (!register_operand (operands[4], E_QImode))
                return -1;
              x11 = XVECEXP (x2, 0, 1);
              operands[5] = x11;
              if (!const_4_or_8_to_11_operand (operands[5], E_SImode))
                return -1;
              switch (pattern1627 (x2))
                {
                case 0:
                  if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 5323; /* avx512f_vmscalefv8hf_mask_round */

                case 1:
                  if (!
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 5327; /* avx512f_vmscalefv4sf_mask_round */

                case 2:
                  if (!(
#line 421 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 13598 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 5331; /* avx512f_vmscalefv2df_mask_round */

                default:
                  return -1;
                }

            case 165:
              if (XWINT (x6, 0) != 1L)
                return -1;
              x14 = XVECEXP (x5, 0, 0);
              operands[1] = x14;
              x15 = XVECEXP (x5, 0, 1);
              operands[2] = x15;
              x8 = XEXP (x4, 1);
              operands[3] = x8;
              x9 = XEXP (x4, 2);
              operands[4] = x9;
              if (!register_operand (operands[4], E_QImode))
                return -1;
              x11 = XVECEXP (x2, 0, 1);
              operands[5] = x11;
              if (!const48_operand (operands[5], E_SImode))
                return -1;
              switch (pattern1627 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 6985; /* avx512f_sgetexpv8hf_mask_round */

                case 1:
                  if (!
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 6989; /* avx512f_sgetexpv4sf_mask_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14031 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 6993; /* avx512f_sgetexpv2df_mask_round */

                default:
                  return -1;
                }

            case 94:
              if (XWINT (x6, 0) != 1L)
                return -1;
              x14 = XVECEXP (x5, 0, 0);
              operands[2] = x14;
              x15 = XVECEXP (x5, 0, 1);
              operands[3] = x15;
              if (!const_0_to_255_operand (operands[3], E_SImode))
                return -1;
              x8 = XEXP (x4, 1);
              operands[4] = x8;
              x9 = XEXP (x4, 2);
              operands[5] = x9;
              if (!register_operand (operands[5], E_QImode))
                return -1;
              x10 = XEXP (x3, 1);
              operands[1] = x10;
              x11 = XVECEXP (x2, 0, 1);
              operands[6] = x11;
              if (!const48_operand (operands[6], E_SImode))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V8HFmode:
                  if (pattern1717 (x2, 
E_V8HFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 7101; /* avx512f_rndscalev8hf_mask_round */

                case E_V4SFmode:
                  if (pattern1717 (x2, 
E_V4SFmode) != 0
                      || !
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 7105; /* avx512f_rndscalev4sf_mask_round */

                case E_V2DFmode:
                  if (pattern1717 (x2, 
E_V2DFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14225 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 7109; /* avx512f_rndscalev2df_mask_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 3:
          x6 = XEXP (x3, 2);
          if (GET_CODE (x6) != CONST_INT)
            return -1;
          x14 = XVECEXP (x5, 0, 0);
          operands[1] = x14;
          x15 = XVECEXP (x5, 0, 1);
          operands[2] = x15;
          x16 = XVECEXP (x5, 0, 2);
          operands[3] = x16;
          switch (XINT (x5, 1))
            {
            case 192:
              switch (pattern1385 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V8HFmode))) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 3198; /* reducesv8hf_mask_round */

                case 1:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V4SFmode))))))
                    return -1;
                  return 3202; /* reducesv4sf_mask_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 4044 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ || (VALID_AVX512FP16_REG_MODE (V2DFmode))) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 3206; /* reducesv2df_mask_round */

                default:
                  return -1;
                }

            case 217:
              switch (pattern1386 (x2))
                {
                case 0:
                  if (!(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 371 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                    return -1;
                  return 4319; /* avx512fp16_fma_fmaddcsh_v8hf_maskz_round */

                case 1:
                  if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4325; /* avx512fp16_fmaddcsh_v8hf_mask_round */

                default:
                  return -1;
                }

            case 219:
              switch (pattern1386 (x2))
                {
                case 0:
                  if (!(
#line 437 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 371 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7491 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16))))
                    return -1;
                  return 4323; /* avx512fp16_fma_fcmaddcsh_v8hf_maskz_round */

                case 1:
                  if (!(
#line 221 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 7511 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))
                    return -1;
                  return 4327; /* avx512fp16_fcmaddcsh_v8hf_mask_round */

                default:
                  return -1;
                }

            case 194:
              if (XWINT (x6, 0) != 1L
                  || !const_0_to_15_operand (operands[3], E_SImode))
                return -1;
              x8 = XEXP (x4, 1);
              operands[4] = x8;
              x9 = XEXP (x4, 2);
              operands[5] = x9;
              if (!register_operand (operands[5], E_QImode))
                return -1;
              x11 = XVECEXP (x2, 0, 1);
              operands[6] = x11;
              if (!const48_operand (operands[6], E_SImode))
                return -1;
              x10 = XEXP (x3, 1);
              if (!rtx_equal_p (x10, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1383 (x2, 
E_V4SFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 30077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ))))
                    return -1;
                  return 9905; /* avx512dq_rangesv4sf_mask_round */

                case E_V2DFmode:
                  if (pattern1383 (x2, 
E_V2DFmode) != 0
                      || !(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30077 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512DQ) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 9909; /* avx512dq_rangesv2df_mask_round */

                default:
                  return -1;
                }

            case 166:
              if (XWINT (x6, 0) != 1L
                  || !const_0_to_15_operand (operands[3], E_SImode))
                return -1;
              switch (pattern1384 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30145 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 9973; /* avx512f_vgetmantv8hf_mask_round */

                case 1:
                  if (!
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 9977; /* avx512f_vgetmantv4sf_mask_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 30145 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 9981; /* avx512f_vgetmantv2df_mask_round */

                default:
                  return -1;
                }

            case 278:
              switch (pattern1385 (x2))
                {
                case 0:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 478 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16)))))
                    return -1;
                  return 10871; /* avx10_2_minmaxsv8hf_mask_round */

                case 1:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2))))
                    return -1;
                  return 10875; /* avx10_2_minmaxsv4sf_mask_round */

                case 2:
                  if (!(
#line 463 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 355 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 32910 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX10_2) && 
#line 479 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 10879; /* avx10_2_minmaxsv2df_mask_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case 4:
          if (XINT (x5, 1) != 163)
            return -1;
          x14 = XVECEXP (x5, 0, 0);
          operands[1] = x14;
          x15 = XVECEXP (x5, 0, 1);
          operands[2] = x15;
          x16 = XVECEXP (x5, 0, 2);
          operands[3] = x16;
          x17 = XVECEXP (x5, 0, 3);
          operands[4] = x17;
          if (!const_0_to_255_operand (operands[4], E_SImode))
            return -1;
          x11 = XVECEXP (x2, 0, 1);
          if (!const48_operand (x11, E_SImode))
            return -1;
          x8 = XEXP (x4, 1);
          switch (GET_CODE (x8))
            {
            case CONST_INT:
            case CONST_DOUBLE:
            case CONST_VECTOR:
              operands[5] = x8;
              x6 = XEXP (x3, 2);
              if (x6 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                return -1;
              x9 = XEXP (x4, 2);
              operands[6] = x9;
              if (!register_operand (operands[6], E_QImode))
                return -1;
              operands[7] = x11;
              x10 = XEXP (x3, 1);
              if (!rtx_equal_p (x10, operands[2]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1750 (x2, 
E_V4SFmode, 
E_V4SImode) != 0
                      || !
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 7053; /* avx512f_sfixupimmv4sf_maskz_1_round */

                case E_V2DFmode:
                  if (pattern1750 (x2, 
E_V2DFmode, 
E_V2DImode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 154 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14180 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))))
                    return -1;
                  return 7057; /* avx512f_sfixupimmv2df_maskz_1_round */

                default:
                  return -1;
                }

            case REG:
            case SUBREG:
              if (!rtx_equal_p (x8, operands[2]))
                return -1;
              x9 = XEXP (x4, 2);
              if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
                return -1;
              x6 = XEXP (x3, 2);
              operands[5] = x6;
              if (!register_operand (operands[5], E_QImode))
                return -1;
              operands[6] = x11;
              x10 = XEXP (x3, 1);
              if (!rtx_equal_p (x10, operands[1]))
                return -1;
              switch (GET_MODE (operands[0]))
                {
                case E_V4SFmode:
                  if (pattern1751 (x2, 
E_V4SImode, 
E_V4SFmode) != 0
                      || !
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F))
                    return -1;
                  return 7059; /* avx512f_sfixupimmv4sf_mask_round */

                case E_V2DFmode:
                  if (pattern1751 (x2, 
E_V2DImode, 
E_V2DFmode) != 0
                      || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 14199 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 474 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
                    return -1;
                  return 7061; /* avx512f_sfixupimmv2df_mask_round */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case FMA:
      return recog_216 (x1, insn, pnum_clobbers);

    case FLOAT_EXTEND:
      if (GET_MODE (x5) != E_V2DFmode)
        return -1;
      x7 = XEXP (x5, 0);
      if (pattern897 (x7, 
2, 
E_V2SFmode) != 0)
        return -1;
      x18 = XEXP (x7, 1);
      x19 = XVECEXP (x18, 0, 1);
      if (x19 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x9 = XEXP (x4, 2);
      if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 1]
          || pattern1463 (x2) != 0)
        return -1;
      x12 = XEXP (x7, 0);
      operands[2] = x12;
      if (!register_operand (operands[2], E_V4SFmode))
        return -1;
      x8 = XEXP (x4, 1);
      operands[1] = x8;
      if (!register_operand (operands[1], E_V2DFmode))
        return -1;
      x10 = XEXP (x3, 1);
      operands[3] = x10;
      if (!nonimm_or_0_operand (operands[3], E_V2DFmode))
        return -1;
      x6 = XEXP (x3, 2);
      operands[4] = x6;
      if (!register_operand (operands[4], E_QImode))
        return -1;
      x11 = XVECEXP (x2, 0, 1);
      operands[5] = x11;
      if (!const48_operand (operands[5], E_SImode)
          || !(
#line 263 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && (
#line 84 "/build/gcc/src/gcc/gcc/config/i386/subst.md"
(TARGET_AVX512F) && 
#line 10034 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2))))
        return -1;
      return 5079; /* sse2_cvtss2sd_mask_round */

    default:
      return -1;
    }
}

 int
recog_239 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 0);
  operands[0] = x2;
  x3 = XEXP (x1, 1);
  x4 = XVECEXP (x3, 0, 0);
  operands[1] = x4;
  x5 = XVECEXP (x3, 0, 1);
  operands[2] = x5;
  if (!const_0_to_255_operand (operands[2], E_SImode))
    return -1;
  switch (GET_MODE (operands[0]))
    {
    case E_V8HImode:
      if (GET_MODE (x3) != E_V8HImode
          || !register_operand (operands[1], E_V8SFmode))
        return -1;
      if (register_operand (operands[0], E_V8HImode)
          && 
#line 29409 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL))
        return 9588; /* vcvtps2ph256 */
      if (!memory_operand (operands[0], E_V8HImode)
          || !
#line 29421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_F16C || TARGET_AVX512VL))
        return -1;
      return 9590; /* *vcvtps2ph256 */

    case E_V16HImode:
      if (GET_MODE (x3) != E_V16HImode
          || !register_operand (operands[1], E_V16SFmode))
        return -1;
      if (register_operand (operands[0], E_V16HImode)
          && 
#line 29460 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return 9592; /* *avx512f_vcvtps2ph512 */
      if (!memory_operand (operands[0], E_V16HImode)
          || !
#line 29472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512))
        return -1;
      return 9596; /* *avx512f_vcvtps2ph512 */

    default:
      return -1;
    }
}

 int
recog_242 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10;
  int res ATTRIBUTE_UNUSED;
  if (pnum_clobbers == NULL)
    return -1;
  x2 = XEXP (x1, 1);
  x3 = XVECEXP (x2, 0, 2);
  if (GET_CODE (x3) != MEM)
    return -1;
  x4 = XEXP (x3, 0);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 3
      || XINT (x4, 1) != 154)
    return -1;
  x5 = XEXP (x1, 0);
  operands[0] = x5;
  x6 = XVECEXP (x4, 0, 2);
  if (!const1248_operand (x6, E_SImode))
    return -1;
  x7 = XVECEXP (x2, 0, 0);
  switch (GET_CODE (x7))
    {
    case REG:
    case SUBREG:
      operands[1] = x7;
      x8 = XVECEXP (x2, 0, 1);
      operands[7] = x8;
      operands[6] = x3;
      x9 = XVECEXP (x4, 0, 0);
      operands[4] = x9;
      x10 = XVECEXP (x4, 0, 1);
      operands[3] = x10;
      operands[5] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          if (!register_operand (operands[0], E_V16SImode)
              || GET_MODE (x2) != E_V16SImode
              || !vsib_mem_operator (operands[6], E_SImode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V16SImode:
              if (!register_operand (operands[1], E_V16SImode)
                  || !register_operand (operands[7], E_HImode))
                return -1;
              switch (pattern1770 (x4, 
E_V16SImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9670; /* *avx512f_gathersiv16si */

                case 1:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9682; /* *avx512f_gathersiv16si */

                default:
                  return -1;
                }

            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode)
                  || !register_operand (operands[7], E_QImode))
                return -1;
              switch (pattern1770 (x4, 
E_V8DImode))
                {
                case 0:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9718; /* *avx512f_gatherdiv16si */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9730; /* *avx512f_gatherdiv16si */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case E_V16SFmode:
          if (!register_operand (operands[0], E_V16SFmode)
              || GET_MODE (x2) != E_V16SFmode
              || !vsib_mem_operator (operands[6], E_SFmode))
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V16SFmode:
              if (!register_operand (operands[1], E_V16SFmode)
                  || !register_operand (operands[7], E_HImode))
                return -1;
              switch (pattern1770 (x4, 
E_V16SImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9671; /* *avx512f_gathersiv16sf */

                case 1:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9683; /* *avx512f_gathersiv16sf */

                default:
                  return -1;
                }

            case E_V8SFmode:
              if (!register_operand (operands[1], E_V8SFmode)
                  || !register_operand (operands[7], E_QImode))
                return -1;
              switch (pattern1770 (x4, 
E_V8DImode))
                {
                case 0:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9719; /* *avx512f_gatherdiv16sf */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9731; /* *avx512f_gatherdiv16sf */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case E_V8DImode:
          switch (pattern1636 (x2, 
E_DImode, 
E_V8DImode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9672; /* *avx512f_gathersiv8di */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9720; /* *avx512f_gatherdiv8di */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9684; /* *avx512f_gathersiv8di */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9732; /* *avx512f_gatherdiv8di */

            default:
              return -1;
            }

        case E_V8DFmode:
          switch (pattern1636 (x2, 
E_DFmode, 
E_V8DFmode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9673; /* *avx512f_gathersiv8df */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9721; /* *avx512f_gatherdiv8df */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9685; /* *avx512f_gathersiv8df */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9733; /* *avx512f_gatherdiv8df */

            default:
              return -1;
            }

        case E_V8SImode:
          if (pattern1637 (x2, 
E_SImode, 
E_V8SImode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8SImode:
              if (!register_operand (operands[1], E_V8SImode))
                return -1;
              switch (pattern1770 (x4, 
E_V8SImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9674; /* *avx512f_gathersiv8si */

                case 1:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9686; /* *avx512f_gathersiv8si */

                default:
                  return -1;
                }

            case E_V4SImode:
              if (!register_operand (operands[1], E_V4SImode))
                return -1;
              switch (pattern1770 (x4, 
E_V4DImode))
                {
                case 0:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9722; /* *avx512f_gatherdiv8si */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9734; /* *avx512f_gatherdiv8si */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case E_V8SFmode:
          if (pattern1637 (x2, 
E_SFmode, 
E_V8SFmode) != 0)
            return -1;
          switch (GET_MODE (operands[1]))
            {
            case E_V8SFmode:
              if (!register_operand (operands[1], E_V8SFmode))
                return -1;
              switch (pattern1770 (x4, 
E_V8SImode))
                {
                case 0:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9675; /* *avx512f_gathersiv8sf */

                case 1:
                  if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9687; /* *avx512f_gathersiv8sf */

                default:
                  return -1;
                }

            case E_V4SFmode:
              if (!register_operand (operands[1], E_V4SFmode))
                return -1;
              switch (pattern1770 (x4, 
E_V4DImode))
                {
                case 0:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9723; /* *avx512f_gatherdiv8sf */

                case 1:
                  if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                    return -1;
                  *pnum_clobbers = 1;
                  return 9735; /* *avx512f_gatherdiv8sf */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        case E_V4DImode:
          switch (pattern1639 (x2, 
E_DImode, 
E_V4DImode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9676; /* *avx512f_gathersiv4di */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9724; /* *avx512f_gatherdiv4di */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9688; /* *avx512f_gathersiv4di */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9736; /* *avx512f_gatherdiv4di */

            default:
              return -1;
            }

        case E_V4DFmode:
          switch (pattern1639 (x2, 
E_DFmode, 
E_V4DFmode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9677; /* *avx512f_gathersiv4df */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9725; /* *avx512f_gatherdiv4df */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9689; /* *avx512f_gathersiv4df */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9737; /* *avx512f_gatherdiv4df */

            default:
              return -1;
            }

        case E_V4SImode:
          switch (pattern1641 (x2, 
E_SImode, 
E_V4SImode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9678; /* *avx512f_gathersiv4si */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9726; /* *avx512f_gatherdiv4si */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9690; /* *avx512f_gathersiv4si */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9738; /* *avx512f_gatherdiv4si */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern1641 (x2, 
E_SFmode, 
E_V4SFmode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9679; /* *avx512f_gathersiv4sf */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9727; /* *avx512f_gatherdiv4sf */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9691; /* *avx512f_gathersiv4sf */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9739; /* *avx512f_gatherdiv4sf */

            default:
              return -1;
            }

        case E_V2DImode:
          switch (pattern1641 (x2, 
E_DImode, 
E_V2DImode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9680; /* *avx512f_gathersiv2di */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9728; /* *avx512f_gatherdiv2di */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9692; /* *avx512f_gathersiv2di */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9740; /* *avx512f_gatherdiv2di */

            default:
              return -1;
            }

        case E_V2DFmode:
          switch (pattern1641 (x2, 
E_DFmode, 
E_V2DFmode))
            {
            case 0:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9681; /* *avx512f_gathersiv2df */

            case 1:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9729; /* *avx512f_gatherdiv2df */

            case 2:
              if (!(
#line 29709 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9693; /* *avx512f_gathersiv2df */

            case 3:
              if (!(
#line 29771 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9741; /* *avx512f_gatherdiv2df */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case PC:
      x8 = XVECEXP (x2, 0, 1);
      operands[6] = x8;
      operands[5] = x3;
      x9 = XVECEXP (x4, 0, 0);
      operands[3] = x9;
      x10 = XVECEXP (x4, 0, 1);
      operands[2] = x10;
      operands[4] = x6;
      switch (GET_MODE (operands[0]))
        {
        case E_V16SImode:
          switch (pattern1593 (x2, 
E_SImode, 
E_V16SImode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9694; /* *avx512f_gathersiv16si_2 */

            case 1:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9706; /* *avx512f_gathersiv16si_2 */

            case 2:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9742; /* *avx512f_gatherdiv16si_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9754; /* *avx512f_gatherdiv16si_2 */

            default:
              return -1;
            }

        case E_V16SFmode:
          switch (pattern1593 (x2, 
E_SFmode, 
E_V16SFmode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9695; /* *avx512f_gathersiv16sf_2 */

            case 1:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9707; /* *avx512f_gathersiv16sf_2 */

            case 2:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9743; /* *avx512f_gatherdiv16sf_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1009 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9755; /* *avx512f_gatherdiv16sf_2 */

            default:
              return -1;
            }

        case E_V8DImode:
          switch (pattern1595 (x2, 
E_DImode, 
E_V8DImode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9696; /* *avx512f_gathersiv8di_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9744; /* *avx512f_gatherdiv8di_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9708; /* *avx512f_gathersiv8di_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9756; /* *avx512f_gatherdiv8di_2 */

            default:
              return -1;
            }

        case E_V8DFmode:
          switch (pattern1595 (x2, 
E_DFmode, 
E_V8DFmode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9697; /* *avx512f_gathersiv8df_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9745; /* *avx512f_gatherdiv8df_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9709; /* *avx512f_gathersiv8df_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1010 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9757; /* *avx512f_gatherdiv8df_2 */

            default:
              return -1;
            }

        case E_V8SImode:
          switch (pattern1597 (x2, 
E_SImode, 
E_V8SImode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9698; /* *avx512f_gathersiv8si_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9746; /* *avx512f_gatherdiv8si_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9710; /* *avx512f_gathersiv8si_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9758; /* *avx512f_gatherdiv8si_2 */

            default:
              return -1;
            }

        case E_V8SFmode:
          switch (pattern1597 (x2, 
E_SFmode, 
E_V8SFmode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9699; /* *avx512f_gathersiv8sf_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9747; /* *avx512f_gatherdiv8sf_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9711; /* *avx512f_gathersiv8sf_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9759; /* *avx512f_gatherdiv8sf_2 */

            default:
              return -1;
            }

        case E_V4DImode:
          switch (pattern1599 (x2, 
E_DImode, 
E_V4DImode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9700; /* *avx512f_gathersiv4di_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9748; /* *avx512f_gatherdiv4di_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9712; /* *avx512f_gathersiv4di_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9760; /* *avx512f_gatherdiv4di_2 */

            default:
              return -1;
            }

        case E_V4DFmode:
          switch (pattern1599 (x2, 
E_DFmode, 
E_V4DFmode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9701; /* *avx512f_gathersiv4df_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9749; /* *avx512f_gatherdiv4df_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9713; /* *avx512f_gathersiv4df_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1012 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9761; /* *avx512f_gatherdiv4df_2 */

            default:
              return -1;
            }

        case E_V4SImode:
          switch (pattern1601 (x2, 
E_SImode, 
E_V4SImode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9702; /* *avx512f_gathersiv4si_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9750; /* *avx512f_gatherdiv4si_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9714; /* *avx512f_gathersiv4si_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9762; /* *avx512f_gatherdiv4si_2 */

            default:
              return -1;
            }

        case E_V4SFmode:
          switch (pattern1601 (x2, 
E_SFmode, 
E_V4SFmode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9703; /* *avx512f_gathersiv4sf_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9751; /* *avx512f_gatherdiv4sf_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9715; /* *avx512f_gathersiv4sf_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9763; /* *avx512f_gatherdiv4sf_2 */

            default:
              return -1;
            }

        case E_V2DImode:
          switch (pattern1601 (x2, 
E_DImode, 
E_V2DImode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9704; /* *avx512f_gathersiv2di_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9752; /* *avx512f_gatherdiv2di_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9716; /* *avx512f_gathersiv2di_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9764; /* *avx512f_gatherdiv2di_2 */

            default:
              return -1;
            }

        case E_V2DFmode:
          switch (pattern1601 (x2, 
E_DFmode, 
E_V2DFmode))
            {
            case 0:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9705; /* *avx512f_gathersiv2df_2 */

            case 1:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == SImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9753; /* *avx512f_gatherdiv2df_2 */

            case 2:
              if (!(
#line 29730 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9717; /* *avx512f_gathersiv2df_2 */

            case 3:
              if (!(
#line 29792 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && ((
#line 1014 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode)) && 
#line 1398 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(Pmode == DImode))))
                return -1;
              *pnum_clobbers = 1;
              return 9765; /* *avx512f_gatherdiv2df_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_289 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx x18, x19;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 1);
  if (pattern920 (x3) != 0)
    return -1;
  x4 = XVECEXP (x3, 0, 0);
  switch (XWINT (x4, 0))
    {
    case 0L:
      if (pattern1752 (x3) != 0)
        return -1;
      switch (pattern1764 (x2))
        {
        case 0:
          if (!(
#line 13011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5280; /* vec_extract_lo_v32hi */

        case 1:
          if (!(
#line 13011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5281; /* vec_extract_lo_v32hf */

        case 2:
          if (!(
#line 13011 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && !(MEM_P (operands[0]) && MEM_P (operands[1]))) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5282; /* vec_extract_lo_v32bf */

        case 3:
          if (!
#line 13181 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX && !(MEM_P (operands[0]) && MEM_P (operands[1]))))
            return -1;
          return 5294; /* vec_extract_lo_v32qi */

        default:
          return -1;
        }

    case 16L:
      x5 = XVECEXP (x3, 0, 1);
      if (XWINT (x5, 0) != 17L)
        return -1;
      x6 = XVECEXP (x3, 0, 2);
      if (XWINT (x6, 0) != 18L)
        return -1;
      x7 = XVECEXP (x3, 0, 3);
      if (XWINT (x7, 0) != 19L)
        return -1;
      x8 = XVECEXP (x3, 0, 4);
      if (XWINT (x8, 0) != 20L)
        return -1;
      x9 = XVECEXP (x3, 0, 5);
      if (XWINT (x9, 0) != 21L)
        return -1;
      x10 = XVECEXP (x3, 0, 6);
      if (XWINT (x10, 0) != 22L)
        return -1;
      x11 = XVECEXP (x3, 0, 7);
      if (XWINT (x11, 0) != 23L)
        return -1;
      x12 = XVECEXP (x3, 0, 8);
      if (XWINT (x12, 0) != 24L)
        return -1;
      x13 = XVECEXP (x3, 0, 9);
      if (XWINT (x13, 0) != 25L)
        return -1;
      x14 = XVECEXP (x3, 0, 10);
      if (XWINT (x14, 0) != 26L)
        return -1;
      x15 = XVECEXP (x3, 0, 11);
      if (XWINT (x15, 0) != 27L)
        return -1;
      x16 = XVECEXP (x3, 0, 12);
      if (XWINT (x16, 0) != 28L)
        return -1;
      x17 = XVECEXP (x3, 0, 13);
      if (XWINT (x17, 0) != 29L)
        return -1;
      x18 = XVECEXP (x3, 0, 14);
      if (XWINT (x18, 0) != 30L)
        return -1;
      x19 = XVECEXP (x3, 0, 15);
      if (XWINT (x19, 0) != 31L)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_V16HImode:
          if (!nonimmediate_operand (operands[0], E_V16HImode)
              || GET_MODE (x2) != E_V16HImode
              || !register_operand (operands[1], E_V32HImode)
              || !(
#line 13052 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5283; /* vec_extract_hi_v32hi */

        case E_V16HFmode:
          if (!nonimmediate_operand (operands[0], E_V16HFmode)
              || GET_MODE (x2) != E_V16HFmode
              || !register_operand (operands[1], E_V32HFmode)
              || !(
#line 13052 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5284; /* vec_extract_hi_v32hf */

        case E_V16BFmode:
          if (!nonimmediate_operand (operands[0], E_V16BFmode)
              || GET_MODE (x2) != E_V16BFmode
              || !register_operand (operands[1], E_V32BFmode)
              || !(
#line 13052 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 1032 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_EVEX512)))
            return -1;
          return 5285; /* vec_extract_hi_v32bf */

        case E_V16QImode:
          if (!nonimmediate_operand (operands[0], E_V16QImode)
              || GET_MODE (x2) != E_V16QImode
              || !register_operand (operands[1], E_V32QImode)
              || !
#line 13199 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
            return -1;
          return 5295; /* vec_extract_hi_v32qi */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_301 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5447; /* *avx512bw_vpternlogv64qi_1 */

        case 1:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5474; /* *avx512vl_vpternlogv32qi_1 */

        case 2:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5501; /* *avx512vl_vpternlogv16qi_1 */

        case 3:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5528; /* *avx512bw_vpternlogv32hi_1 */

        case 4:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5555; /* *avx512vl_vpternlogv16hi_1 */

        case 5:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5582; /* *avx512vl_vpternlogv8hi_1 */

        case 6:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5609; /* *avx512f_vpternlogv16si_1 */

        case 7:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5636; /* *avx512vl_vpternlogv8si_1 */

        case 8:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5663; /* *avx512vl_vpternlogv4si_1 */

        case 9:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5690; /* *avx512f_vpternlogv8di_1 */

        case 10:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5717; /* *avx512vl_vpternlogv4di_1 */

        case 11:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5744; /* *avx512vl_vpternlogv2di_1 */

        case 12:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5450; /* *avx512bw_vpternlogv64qi_1 */

        case 13:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5477; /* *avx512vl_vpternlogv32qi_1 */

        case 14:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5504; /* *avx512vl_vpternlogv16qi_1 */

        case 15:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5531; /* *avx512bw_vpternlogv32hi_1 */

        case 16:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5558; /* *avx512vl_vpternlogv16hi_1 */

        case 17:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5585; /* *avx512vl_vpternlogv8hi_1 */

        case 18:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5612; /* *avx512f_vpternlogv16si_1 */

        case 19:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5639; /* *avx512vl_vpternlogv8si_1 */

        case 20:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5666; /* *avx512vl_vpternlogv4si_1 */

        case 21:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5693; /* *avx512f_vpternlogv8di_1 */

        case 22:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5720; /* *avx512vl_vpternlogv4di_1 */

        case 23:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5747; /* *avx512vl_vpternlogv2di_1 */

        case 24:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5453; /* *avx512bw_vpternlogv64qi_1 */

        case 25:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5480; /* *avx512vl_vpternlogv32qi_1 */

        case 26:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5507; /* *avx512vl_vpternlogv16qi_1 */

        case 27:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5534; /* *avx512bw_vpternlogv32hi_1 */

        case 28:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5561; /* *avx512vl_vpternlogv16hi_1 */

        case 29:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5588; /* *avx512vl_vpternlogv8hi_1 */

        case 30:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5615; /* *avx512f_vpternlogv16si_1 */

        case 31:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5642; /* *avx512vl_vpternlogv8si_1 */

        case 32:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5669; /* *avx512vl_vpternlogv4si_1 */

        case 33:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 5696; /* *avx512f_vpternlogv8di_1 */

        case 34:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 5723; /* *avx512vl_vpternlogv4di_1 */

        case 35:
          if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 5750; /* *avx512vl_vpternlogv2di_1 */

        case 36:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6731; /* *avx512bw_vpternlogv64qi_3 */

        case 37:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6740; /* *avx512vl_vpternlogv32qi_3 */

        case 38:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6749; /* *avx512vl_vpternlogv16qi_3 */

        case 39:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6758; /* *avx512bw_vpternlogv32hi_3 */

        case 40:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6767; /* *avx512vl_vpternlogv16hi_3 */

        case 41:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6776; /* *avx512vl_vpternlogv8hi_3 */

        case 42:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6785; /* *avx512f_vpternlogv16si_3 */

        case 43:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6794; /* *avx512vl_vpternlogv8si_3 */

        case 44:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6803; /* *avx512vl_vpternlogv4si_3 */

        case 45:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6812; /* *avx512f_vpternlogv8di_3 */

        case 46:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6821; /* *avx512vl_vpternlogv4di_3 */

        case 47:
          if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
            return -1;
          return 6830; /* *avx512vl_vpternlogv2di_3 */

        default:
          return -1;
        }

    case AND:
      switch (pattern535 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6095; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6122; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6149; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6176; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6203; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6230; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6257; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6284; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6311; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6338; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6365; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6392; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case IOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6098; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6125; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6152; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6179; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6206; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6233; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6260; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6287; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6314; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6341; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6368; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6395; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    case XOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6101; /* *avx512bw_vpternlogv64qi_2 */

        case 1:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6128; /* *avx512vl_vpternlogv32qi_2 */

        case 2:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6155; /* *avx512vl_vpternlogv16qi_2 */

        case 3:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6182; /* *avx512bw_vpternlogv32hi_2 */

        case 4:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6209; /* *avx512vl_vpternlogv16hi_2 */

        case 5:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6236; /* *avx512vl_vpternlogv8hi_2 */

        case 6:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6263; /* *avx512f_vpternlogv16si_2 */

        case 7:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6290; /* *avx512vl_vpternlogv8si_2 */

        case 8:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6317; /* *avx512vl_vpternlogv4si_2 */

        case 9:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
            return -1;
          return 6344; /* *avx512f_vpternlogv8di_2 */

        case 10:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
            return -1;
          return 6371; /* *avx512vl_vpternlogv4di_2 */

        case 11:
          if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
            return -1;
          return 6398; /* *avx512vl_vpternlogv2di_2 */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_310 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  int res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern537 (x2))
            {
            case 0:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5753; /* *avx512bw_vpternlogv32hf_1 */

            case 1:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5780; /* *avx512vl_vpternlogv16hf_1 */

            case 2:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5807; /* *avx512fp16_vpternlogv8hf_1 */

            case 3:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5834; /* *avx512bw_vpternlogv32bf_1 */

            case 4:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5861; /* *avx512vl_vpternlogv16bf_1 */

            case 5:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5888; /* *avx512vl_vpternlogv8bf_1 */

            case 6:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5915; /* *avx512f_vpternlogv16sf_1 */

            case 7:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5942; /* *avx512vl_vpternlogv8sf_1 */

            case 8:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5969; /* *avx512vl_vpternlogv4sf_1 */

            case 9:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5996; /* *avx512f_vpternlogv8df_1 */

            case 10:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6023; /* *avx512vl_vpternlogv4df_1 */

            case 11:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6050; /* *avx512vl_vpternlogv2df_1 */

            case 12:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5756; /* *avx512bw_vpternlogv32hf_1 */

            case 13:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5783; /* *avx512vl_vpternlogv16hf_1 */

            case 14:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5810; /* *avx512fp16_vpternlogv8hf_1 */

            case 15:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5837; /* *avx512bw_vpternlogv32bf_1 */

            case 16:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5864; /* *avx512vl_vpternlogv16bf_1 */

            case 17:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5891; /* *avx512vl_vpternlogv8bf_1 */

            case 18:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5918; /* *avx512f_vpternlogv16sf_1 */

            case 19:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5945; /* *avx512vl_vpternlogv8sf_1 */

            case 20:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5972; /* *avx512vl_vpternlogv4sf_1 */

            case 21:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5999; /* *avx512f_vpternlogv8df_1 */

            case 22:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6026; /* *avx512vl_vpternlogv4df_1 */

            case 23:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6053; /* *avx512vl_vpternlogv2df_1 */

            case 24:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5759; /* *avx512bw_vpternlogv32hf_1 */

            case 25:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5786; /* *avx512vl_vpternlogv16hf_1 */

            case 26:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5813; /* *avx512fp16_vpternlogv8hf_1 */

            case 27:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5840; /* *avx512bw_vpternlogv32bf_1 */

            case 28:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5867; /* *avx512vl_vpternlogv16bf_1 */

            case 29:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5894; /* *avx512vl_vpternlogv8bf_1 */

            case 30:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5921; /* *avx512f_vpternlogv16sf_1 */

            case 31:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5948; /* *avx512vl_vpternlogv8sf_1 */

            case 32:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5975; /* *avx512vl_vpternlogv4sf_1 */

            case 33:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6002; /* *avx512f_vpternlogv8df_1 */

            case 34:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6029; /* *avx512vl_vpternlogv4df_1 */

            case 35:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6056; /* *avx512vl_vpternlogv2df_1 */

            case 36:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6833; /* *avx512bw_vpternlogv32hf_3 */

            case 37:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6842; /* *avx512vl_vpternlogv16hf_3 */

            case 38:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6851; /* *avx512fp16_vpternlogv8hf_3 */

            case 39:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6860; /* *avx512bw_vpternlogv32bf_3 */

            case 40:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6869; /* *avx512vl_vpternlogv16bf_3 */

            case 41:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6878; /* *avx512vl_vpternlogv8bf_3 */

            case 42:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6887; /* *avx512f_vpternlogv16sf_3 */

            case 43:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6896; /* *avx512vl_vpternlogv8sf_3 */

            case 44:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6905; /* *avx512vl_vpternlogv4sf_3 */

            case 45:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6914; /* *avx512f_vpternlogv8df_3 */

            case 46:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6923; /* *avx512vl_vpternlogv4df_3 */

            case 47:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6932; /* *avx512vl_vpternlogv2df_3 */

            default:
              return -1;
            }

        case AND:
          switch (pattern538 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6401; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6428; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6455; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6482; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6509; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6536; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6563; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6590; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6617; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6644; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6671; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6698; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case IOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6404; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6431; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6458; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6485; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6512; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6539; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6566; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6593; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6620; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6647; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6674; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6701; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case XOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6407; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6434; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6461; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6488; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6515; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6542; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6569; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6596; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6623; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6650; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6677; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6704; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case IOR:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern537 (x2))
            {
            case 0:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5762; /* *avx512bw_vpternlogv32hf_1 */

            case 1:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5789; /* *avx512vl_vpternlogv16hf_1 */

            case 2:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5816; /* *avx512fp16_vpternlogv8hf_1 */

            case 3:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5843; /* *avx512bw_vpternlogv32bf_1 */

            case 4:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5870; /* *avx512vl_vpternlogv16bf_1 */

            case 5:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5897; /* *avx512vl_vpternlogv8bf_1 */

            case 6:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5924; /* *avx512f_vpternlogv16sf_1 */

            case 7:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5951; /* *avx512vl_vpternlogv8sf_1 */

            case 8:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5978; /* *avx512vl_vpternlogv4sf_1 */

            case 9:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6005; /* *avx512f_vpternlogv8df_1 */

            case 10:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6032; /* *avx512vl_vpternlogv4df_1 */

            case 11:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6059; /* *avx512vl_vpternlogv2df_1 */

            case 12:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5765; /* *avx512bw_vpternlogv32hf_1 */

            case 13:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5792; /* *avx512vl_vpternlogv16hf_1 */

            case 14:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5819; /* *avx512fp16_vpternlogv8hf_1 */

            case 15:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5846; /* *avx512bw_vpternlogv32bf_1 */

            case 16:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5873; /* *avx512vl_vpternlogv16bf_1 */

            case 17:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5900; /* *avx512vl_vpternlogv8bf_1 */

            case 18:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5927; /* *avx512f_vpternlogv16sf_1 */

            case 19:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5954; /* *avx512vl_vpternlogv8sf_1 */

            case 20:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5981; /* *avx512vl_vpternlogv4sf_1 */

            case 21:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6008; /* *avx512f_vpternlogv8df_1 */

            case 22:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6035; /* *avx512vl_vpternlogv4df_1 */

            case 23:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6062; /* *avx512vl_vpternlogv2df_1 */

            case 24:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5768; /* *avx512bw_vpternlogv32hf_1 */

            case 25:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5795; /* *avx512vl_vpternlogv16hf_1 */

            case 26:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5822; /* *avx512fp16_vpternlogv8hf_1 */

            case 27:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5849; /* *avx512bw_vpternlogv32bf_1 */

            case 28:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5876; /* *avx512vl_vpternlogv16bf_1 */

            case 29:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5903; /* *avx512vl_vpternlogv8bf_1 */

            case 30:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 5930; /* *avx512f_vpternlogv16sf_1 */

            case 31:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 5957; /* *avx512vl_vpternlogv8sf_1 */

            case 32:
              if (!
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 5984; /* *avx512vl_vpternlogv4sf_1 */

            case 33:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6011; /* *avx512f_vpternlogv8df_1 */

            case 34:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6038; /* *avx512vl_vpternlogv4df_1 */

            case 35:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6065; /* *avx512vl_vpternlogv2df_1 */

            case 36:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6836; /* *avx512bw_vpternlogv32hf_3 */

            case 37:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6845; /* *avx512vl_vpternlogv16hf_3 */

            case 38:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6854; /* *avx512fp16_vpternlogv8hf_3 */

            case 39:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6863; /* *avx512bw_vpternlogv32bf_3 */

            case 40:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6872; /* *avx512vl_vpternlogv16bf_3 */

            case 41:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6881; /* *avx512vl_vpternlogv8bf_3 */

            case 42:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6890; /* *avx512f_vpternlogv16sf_3 */

            case 43:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6899; /* *avx512vl_vpternlogv8sf_3 */

            case 44:
              if (!
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()))
                return -1;
              return 6908; /* *avx512vl_vpternlogv4sf_3 */

            case 45:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6917; /* *avx512f_vpternlogv8df_3 */

            case 46:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6926; /* *avx512vl_vpternlogv4df_3 */

            case 47:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6935; /* *avx512vl_vpternlogv2df_3 */

            default:
              return -1;
            }

        case AND:
          switch (pattern538 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6410; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6437; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6464; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6491; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6518; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6545; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6572; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6599; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6626; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6653; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6680; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6707; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case IOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6413; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6440; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6467; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6494; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6521; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6548; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6575; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6602; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6629; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6656; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6683; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6710; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        case XOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6416; /* *avx512bw_vpternlogv32hf_2 */

            case 1:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6443; /* *avx512vl_vpternlogv16hf_2 */

            case 2:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6470; /* *avx512fp16_vpternlogv8hf_2 */

            case 3:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6497; /* *avx512bw_vpternlogv32bf_2 */

            case 4:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6524; /* *avx512vl_vpternlogv16bf_2 */

            case 5:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6551; /* *avx512vl_vpternlogv8bf_2 */

            case 6:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6578; /* *avx512f_vpternlogv16sf_2 */

            case 7:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6605; /* *avx512vl_vpternlogv8sf_2 */

            case 8:
              if (!
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))))
                return -1;
              return 6632; /* *avx512vl_vpternlogv4sf_2 */

            case 9:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 6659; /* *avx512f_vpternlogv8df_2 */

            case 10:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 6686; /* *avx512vl_vpternlogv4df_2 */

            case 11:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 6713; /* *avx512vl_vpternlogv2df_2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case XOR:
      return recog_307 (x1, insn, pnum_clobbers);

    default:
      return -1;
    }
}

 int
recog_370 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      if (pnum_clobbers == NULL
          || !register_operand (operands[1], E_DImode))
        return -1;
      switch (pattern927 (x1))
        {
        case 0:
          if (!
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (SFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          *pnum_clobbers = 2;
          return 254; /* floatdisf2_i387_with_xmm */

        case 1:
          if (!
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (DFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          *pnum_clobbers = 2;
          return 255; /* floatdidf2_i387_with_xmm */

        case 2:
          if (!
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (XFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)))
            return -1;
          *pnum_clobbers = 2;
          return 256; /* floatdixf2_i387_with_xmm */

        default:
          return -1;
        }

    case UNSPEC:
      if (pattern681 (x1, 
E_V2SImode, 
E_V2SFmode) != 0
          || !
#line 1600 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
        return -1;
      return 2081; /* mmx_floatv2siv2sf2 */

    default:
      return -1;
    }
}

 int
recog_373 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      operands[1] = x4;
      res = recog_372 (x1, insn, pnum_clobbers);
      if (res >= 0)
        return res;
      if (GET_CODE (x4) != SUBREG
          || pattern559 (x4) != 0)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != CLOBBER
          || pattern571 (x1) != 0)
        return -1;
      x6 = XEXP (x4, 0);
      x7 = XEXP (x6, 0);
      operands[2] = x7;
      switch (pattern1607 (x2))
        {
        case 0:
          if (
#line 7007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 303; /* *addqi_exthi_1_slp */
          break;

        case 1:
          if (
#line 7007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return 304; /* *addqi_extsi_1_slp */
          break;

        case 2:
          if ((
#line 7007 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return 305; /* *addqi_extdi_1_slp */
          break;

        case 3:
          return 327; /* *addqi_exthi_0 */

        case 4:
          return 328; /* *addqi_extsi_0 */

        case 5:
          if (
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return 329; /* *addqi_extdi_0 */
          break;

        default:
          break;
        }
      x8 = XEXP (x3, 1);
      if (GET_CODE (x8) != SUBREG)
        return -1;
      switch (pattern1608 (x2))
        {
        case 0:
          if (!
#line 7040 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 306; /* *addqi_exthi_2_slp */

        case 1:
          if (!
#line 7040 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 307; /* *addqi_extsi_2_slp */

        case 2:
          if (!(
#line 7040 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 308; /* *addqi_extdi_2_slp */

        case 3:
          return 330; /* *addqi_ext2hi_0 */

        case 4:
          return 331; /* *addqi_ext2si_0 */

        case 5:
          if (!
#line 1164 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 332; /* *addqi_ext2di_0 */

        default:
          return -1;
        }

    case ZERO_EXTEND:
      x5 = XVECEXP (x1, 0, 1);
      if (pattern353 (x5) != 0)
        return -1;
      switch (pattern929 (x2))
        {
        case 0:
          if (!(
#line 6523 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 268; /* *adddi3_doubleword_zext */

        case 1:
          if (!(
#line 6523 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (UNKNOWN, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 269; /* *addti3_doubleword_zext */

        default:
          return -1;
        }

    case PLUS:
      if (pattern340 (x1) != 0)
        return -1;
      x6 = XEXP (x4, 0);
      switch (GET_CODE (x6))
        {
        case ASHIFT:
          switch (pattern1142 (x3))
            {
            case 0:
              if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 270; /* *adddi3_doubleword_concat */

            case 1:
              if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 273; /* *addti3_doubleword_concat */

            case 2:
              if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return -1;
              return 276; /* *adddi3_doubleword_concat_zext */

            case 3:
              if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 279; /* *addti3_doubleword_concat_zext */

            default:
              return -1;
            }

        case LTU:
        case UNLT:
          operands[4] = x6;
          x9 = XEXP (x6, 1);
          if (x9 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          x7 = XEXP (x6, 0);
          operands[3] = x7;
          if (!flags_reg_operand (operands[3], E_VOIDmode))
            return -1;
          x10 = XEXP (x4, 1);
          operands[1] = x10;
          x8 = XEXP (x3, 1);
          operands[2] = x8;
          switch (GET_MODE (operands[0]))
            {
            case E_QImode:
              if (pattern1609 (x3, 
E_QImode) != 0
                  || !
#line 8805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)))
                return -1;
              return 453; /* addqi3_carry */

            case E_HImode:
              if (pattern1609 (x3, 
E_HImode) != 0
                  || !
#line 8805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)))
                return -1;
              return 454; /* addhi3_carry */

            case E_SImode:
              if (pattern1610 (x3, 
E_SImode) != 0
                  || !
#line 8805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)))
                return -1;
              return 455; /* addsi3_carry */

            case E_DImode:
              if (pattern1610 (x3, 
E_DImode) != 0
                  || !(
#line 8805 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 456; /* adddi3_carry */

            default:
              return -1;
            }

        case EQ:
          switch (pattern1145 (x3))
            {
            case 0:
              if (!
#line 10148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              return 554; /* *addqi3_eq */

            case 1:
              if (!
#line 10148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              return 555; /* *addhi3_eq */

            case 2:
              if (!
#line 10148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              return 556; /* *addsi3_eq */

            case 3:
              if (!(
#line 10148 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 557; /* *adddi3_eq */

            default:
              return -1;
            }

        case NE:
          switch (pattern1148 (x3))
            {
            case 0:
              if (!
#line 10169 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              return 558; /* *addqi3_ne */

            case 1:
              if (!
#line 10169 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              return 559; /* *addhi3_ne */

            case 2:
              if (!
#line 10169 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (SImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
                return -1;
              return 560; /* *addsi3_ne */

            case 3:
              if (!(
#line 10169 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (DImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (PLUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 561; /* *adddi3_ne */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case IOR:
      switch (pattern357 (x1))
        {
        case 0:
          if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 271; /* *adddi3_doubleword_concat */

        case 1:
          if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 274; /* *addti3_doubleword_concat */

        case 2:
          if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 277; /* *adddi3_doubleword_concat_zext */

        case 3:
          if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 280; /* *addti3_doubleword_concat_zext */

        default:
          return -1;
        }

    case XOR:
      switch (pattern357 (x1))
        {
        case 0:
          if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 272; /* *adddi3_doubleword_concat */

        case 1:
          if (!(
#line 6554 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 275; /* *addti3_doubleword_concat */

        case 2:
          if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 4 * BITS_PER_UNIT) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return -1;
          return 278; /* *adddi3_doubleword_concat_zext */

        case 3:
          if (!(
#line 6585 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(INTVAL (operands[3]) == 8 * BITS_PER_UNIT) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 281; /* *addti3_doubleword_concat_zext */

        default:
          return -1;
        }

    case LTU:
    case UNLT:
      switch (pattern358 (x1))
        {
        case 0:
          if (pattern1508 (x3, 
E_QImode) != 0
              || !
#line 8877 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 457; /* *addqi3_carry_0 */

        case 1:
          if (pattern1508 (x3, 
E_HImode) != 0
              || !
#line 8877 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 458; /* *addhi3_carry_0 */

        case 2:
          if (pattern1508 (x3, 
E_SImode) != 0
              || !
#line 8877 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 459; /* *addsi3_carry_0 */

        case 3:
          if (pattern1508 (x3, 
E_DImode) != 0
              || !(
#line 8877 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 460; /* *adddi3_carry_0 */

        default:
          return -1;
        }

    case GE:
    case GEU:
      switch (pattern358 (x1))
        {
        case 0:
          if (pattern1509 (x3, 
E_QImode) != 0
              || !
#line 8891 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 461; /* *addqi3_carry_0r */

        case 1:
          if (pattern1509 (x3, 
E_HImode) != 0
              || !
#line 8891 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 462; /* *addhi3_carry_0r */

        case 2:
          if (pattern1509 (x3, 
E_SImode) != 0
              || !
#line 8891 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])))
            return -1;
          return 463; /* *addsi3_carry_0r */

        case 3:
          if (pattern1509 (x3, 
E_DImode) != 0
              || !(
#line 8891 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!MEM_P (operands[0]) || rtx_equal_p (operands[0], operands[1])) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 464; /* *adddi3_carry_0r */

        default:
          return -1;
        }

    case EQ:
      switch (pattern362 (x1))
        {
        case 0:
          if (!
#line 10195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 562; /* *addqi3_eq_0 */

        case 1:
          if (!
#line 10195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 563; /* *addhi3_eq_0 */

        case 2:
          if (!
#line 10195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, SImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 564; /* *addsi3_eq_0 */

        case 3:
          if (!(
#line 10195 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 565; /* *adddi3_eq_0 */

        default:
          return -1;
        }

    case NE:
      switch (pattern362 (x1))
        {
        case 0:
          if (!
#line 10216 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, QImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 566; /* *addqi3_ne_0 */

        case 1:
          if (!
#line 10216 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, HImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 567; /* *addhi3_ne_0 */

        case 2:
          if (!
#line 10216 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, SImode, operands)
   && ix86_pre_reload_split ()))
            return -1;
          return 568; /* *addsi3_ne_0 */

        case 3:
          if (!(
#line 10216 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (PLUS, DImode, operands)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 569; /* *adddi3_ne_0 */

        default:
          return -1;
        }

    case MINUS:
      x5 = XVECEXP (x1, 0, 1);
      if (pattern353 (x5) != 0)
        return -1;
      switch (pattern933 (x2))
        {
        case 0:
          if (!
#line 10264 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
            return -1;
          return 574; /* *subqi3_ne */

        case 1:
          if (!
#line 10264 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
            return -1;
          return 575; /* *subhi3_ne */

        case 2:
          if (!
#line 10264 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (SImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
            return -1;
          return 576; /* *subsi3_ne */

        case 3:
          if (!(
#line 10264 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (DImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 577; /* *subdi3_ne */

        case 4:
          if (!
#line 10293 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (QImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, QImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
            return -1;
          return 578; /* *subqi3_eq_1 */

        case 5:
          if (!
#line 10293 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (HImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, HImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
            return -1;
          return 579; /* *subhi3_eq_1 */

        case 6:
          if (!
#line 10293 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (SImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, SImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()))
            return -1;
          return 580; /* *subsi3_eq_1 */

        case 7:
          if (!(
#line 10293 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(CONST_INT_P (operands[2])
   && (DImode != DImode
       || INTVAL (operands[2]) != HOST_WIDE_INT_C (-0x80000000))
   && ix86_binary_operator_ok (MINUS, DImode, operands, TARGET_APX_NDD)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 581; /* *subdi3_eq_1 */

        default:
          return -1;
        }

    case LSHIFTRT:
      x10 = XEXP (x4, 1);
      if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 1])
        return -1;
      x8 = XEXP (x3, 1);
      if (GET_CODE (x8) != ASHIFT)
        return -1;
      x11 = XEXP (x8, 0);
      if (GET_CODE (x11) != LTU)
        return -1;
      x12 = XEXP (x11, 0);
      if (GET_CODE (x12) != REG
          || REGNO (x12) != 17
          || GET_MODE (x12) != E_CCCmode)
        return -1;
      x13 = XEXP (x11, 1);
      if (x13 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
        return -1;
      x14 = XEXP (x8, 1);
      if (GET_CODE (x14) != CONST_INT
          || pattern347 (x1) != 0)
        return -1;
      switch (XWINT (x14, 0))
        {
        case 31L:
          if (pattern1659 (x3, 
E_SImode) != 0)
            return -1;
          return 1385; /* rcrsi2 */

        case 63L:
          if (pattern1659 (x3, 
E_DImode) != 0
              || !
#line 18786 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1386; /* rcrdi2 */

        default:
          return -1;
        }

    case UNSPEC:
      x5 = XVECEXP (x1, 0, 1);
      if (pattern353 (x5) != 0)
        return -1;
      switch (pattern937 (x2))
        {
        case 0:
          if (!
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode))
            return -1;
          return 1661; /* *add_tp_si */

        case 1:
          if (!
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode))
            return -1;
          return 1662; /* *add_tp_di */

        case 2:
          if (!
#line 23344 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_GNU2_TLS))
            return -1;
          return 1666; /* *tls_dynamic_gnu2_combine_32 */

        case 3:
          if (!(
#line 23403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == SImode)))
            return -1;
          return 1671; /* *tls_dynamic_gnu2_combine_64_si */

        case 4:
          if (!(
#line 23403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_GNU2_TLS) && 
#line 1408 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ptr_mode == DImode)))
            return -1;
          return 1672; /* *tls_dynamic_gnu2_combine_64_di */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_394 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  int res ATTRIBUTE_UNUSED;
  switch (pattern558 (x1))
    {
    case 0:
      x2 = XVECEXP (x1, 0, 1);
      x3 = XEXP (x2, 0);
      if (GET_CODE (x3) != REG
          || REGNO (x3) != 17
          || GET_MODE (x3) != E_CCmode)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_DImode:
          if (!nonimmediate_operand (operands[0], E_DImode))
            return -1;
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (GET_MODE (x5) != E_DImode
              || !nonimmediate_operand (operands[1], E_DImode))
            return -1;
          if (x86_64_hilo_general_operand (operands[2], E_DImode)
              && (
#line 12515 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 703; /* *anddi3_doubleword */
          if (x86_64_szext_general_operand (operands[2], E_DImode)
              && 
#line 12557 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && ix86_binary_operator_ok (AND, DImode, operands, TARGET_APX_NDD)
   && true))
            return 706; /* *anddi_1 */
          if (!const_int_operand (operands[2], E_DImode)
              || !
#line 12590 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT && TARGET_USE_BT
   && ix86_binary_operator_ok (AND, DImode, operands)
   && IN_RANGE (exact_log2 (~INTVAL (operands[2])), 31, 63)))
            return -1;
          return 707; /* *anddi_1_btr */

        case E_TImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern564 (x5, 
E_TImode) != 0
              || !(
#line 12515 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 704; /* *andti3_doubleword */

        case E_HImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern565 (x5, 
E_HImode) != 0
              || !
#line 12685 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, HImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          return 720; /* *andhi_1 */

        case E_SImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern566 (x5) != 0
              || !
#line 12685 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, SImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          return 722; /* *andsi_1 */

        case E_QImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern565 (x5, 
E_QImode) != 0
              || !
#line 12723 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (AND, QImode, operands, TARGET_APX_NDD)
   && true))
            return -1;
          return 724; /* *andqi_1 */

        case E_V4QImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern567 (x5, 
E_V4QImode) != 0
              || !
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V4QImode, operands)))
            return -1;
          return 2283; /* *andv4qi3 */

        case E_V2QImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern567 (x5, 
E_V2QImode) != 0
              || !
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2QImode, operands)))
            return -1;
          return 2286; /* *andv2qi3 */

        case E_V2HImode:
          x4 = XVECEXP (x1, 0, 0);
          x5 = XEXP (x4, 1);
          if (pattern567 (x5, 
E_V2HImode) != 0
              || !
#line 4718 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(ix86_binary_operator_ok (AND, V2HImode, operands)))
            return -1;
          return 2289; /* *andv2hi3 */

        default:
          return -1;
        }

    case 1:
      switch (pattern569 (x1))
        {
        case 0:
          if (!
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 2572; /* kandqi */

        case 1:
          if (!
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F))
            return -1;
          return 2575; /* kandhi */

        case 2:
          if (!(
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2578; /* kandsi */

        case 3:
          if (!(
#line 2097 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F) && 
#line 2078 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW)))
            return -1;
          return 2581; /* kanddi */

        default:
          return -1;
        }

    case 2:
      if (!
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      return 725; /* *andqi_1_slp */

    case 3:
      if (!
#line 12755 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
        return -1;
      return 728; /* *andhi_1_slp */

    default:
      return -1;
    }
}

 int
recog_399 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      switch (pattern377 (x1))
        {
        case 0:
          x5 = XVECEXP (x1, 0, 1);
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != REG
              || REGNO (x6) != 17
              || GET_MODE (x6) != E_CCmode)
            return -1;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || GET_MODE (x3) != E_DImode
                  || !nonimmediate_operand (operands[1], E_DImode))
                return -1;
              if ((
#line 14251 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 952; /* *negdi2_doubleword */
              if (!(
#line 14360 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 961; /* *negdi_1 */

            case E_TImode:
              if (!nonimmediate_operand (operands[0], E_TImode)
                  || GET_MODE (x3) != E_TImode
                  || !nonimmediate_operand (operands[1], E_TImode)
                  || !(
#line 14251 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return -1;
              return 953; /* *negti2_doubleword */

            case E_QImode:
              if (!nonimmediate_operand (operands[0], E_QImode)
                  || GET_MODE (x3) != E_QImode
                  || !nonimmediate_operand (operands[1], E_QImode)
                  || !
#line 14360 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, QImode, operands, TARGET_APX_NDD)
   && true))
                return -1;
              return 955; /* *negqi_1 */

            case E_HImode:
              if (!nonimmediate_operand (operands[0], E_HImode)
                  || GET_MODE (x3) != E_HImode
                  || !nonimmediate_operand (operands[1], E_HImode)
                  || !
#line 14360 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, HImode, operands, TARGET_APX_NDD)
   && true))
                return -1;
              return 957; /* *neghi_1 */

            case E_SImode:
              if (!nonimmediate_operand (operands[0], E_SImode)
                  || GET_MODE (x3) != E_SImode
                  || !nonimmediate_operand (operands[1], E_SImode)
                  || !
#line 14360 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, SImode, operands, TARGET_APX_NDD)
   && true))
                return -1;
              return 959; /* *negsi_1 */

            case E_SFmode:
              if (!register_operand (operands[0], E_SFmode)
                  || GET_MODE (x3) != E_SFmode
                  || !register_operand (operands[1], E_SFmode)
                  || !
#line 14824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && !(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH)))
                return -1;
              return 1011; /* *negsf2_i387_1 */

            case E_DFmode:
              if (!register_operand (operands[0], E_DFmode)
                  || GET_MODE (x3) != E_DFmode
                  || !register_operand (operands[1], E_DFmode)
                  || !
#line 14824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && !(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH)))
                return -1;
              return 1013; /* *negdf2_i387_1 */

            case E_XFmode:
              if (!register_operand (operands[0], E_XFmode)
                  || GET_MODE (x3) != E_XFmode
                  || !register_operand (operands[1], E_XFmode)
                  || !
#line 14824 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && !(SSE_FLOAT_MODE_P (XFmode) && TARGET_SSE_MATH)))
                return -1;
              return 1015; /* *negxf2_i387_1 */

            case E_V2QImode:
              if (!register_operand (operands[0], E_V2QImode)
                  || GET_MODE (x3) != E_V2QImode
                  || !register_operand (operands[1], E_V2QImode)
                  || !
#line 3139 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(!TARGET_PARTIAL_REG_STALL || optimize_size || TARGET_SSE2))
                return -1;
              return 2123; /* negv2qi2 */

            default:
              return -1;
            }

        case 1:
          switch (pattern697 (x1, pnum_clobbers))
            {
            case 0:
              if (!
#line 14762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE))
                return -1;
              return 1008; /* *negtf2_1 */

            case 1:
              if (!
#line 14848 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16))
                return -1;
              *pnum_clobbers = 1;
              return 1017; /* *neghf2_1 */

            case 2:
              if (!
#line 14864 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH)))
                return -1;
              *pnum_clobbers = 1;
              return 1019; /* *negsf2_1 */

            case 3:
              if (!
#line 14864 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 || (SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH)))
                return -1;
              *pnum_clobbers = 1;
              return 1021; /* *negdf2_1 */

            case 4:
              if (!
#line 683 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                return -1;
              return 2050; /* *mmx_negv2sf2 */

            case 5:
              if (!
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
                return -1;
              return 2096; /* *mmx_negv2bf */

            case 6:
              if (!(
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
                return -1;
              return 2098; /* *mmx_negv4bf */

            case 7:
              if (!
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
                return -1;
              return 2100; /* *mmx_negv2hf */

            case 8:
              if (!(
#line 2240 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2226 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
                return -1;
              return 2102; /* *mmx_negv4hf */

            case 9:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 411 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 2654; /* *negv32bf2 */

            case 10:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 412 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 2656; /* *negv16bf2 */

            case 11:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 412 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2658; /* *negv8bf2 */

            case 12:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 413 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 2660; /* *negv32hf2 */

            case 13:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 414 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 2662; /* *negv16hf2 */

            case 14:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 414 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2664; /* *negv8hf2 */

            case 15:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 2666; /* *negv16sf2 */

            case 16:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 415 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 2668; /* *negv8sf2 */

            case 17:
              if (!
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return -1;
              return 2670; /* *negv4sf2 */

            case 18:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 416 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 2672; /* *negv8df2 */

            case 19:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 417 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 2674; /* *negv4df2 */

            case 20:
              if (!(
#line 2589 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 417 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2676; /* *negv2df2 */

            default:
              return -1;
            }

        case 2:
          if (!
#line 14409 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 973; /* *negqi_1_slp */

        case 3:
          if (!
#line 14409 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
            return -1;
          return 974; /* *neghi_1_slp */

        default:
          return -1;
        }

    case ABS:
      switch (pattern379 (x1))
        {
        case 0:
          if ((
#line 14658 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
            return 997; /* *nabsdi2_doubleword */
          if (!(
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 1006; /* *nabsdi2_1 */

        case 1:
          if (!(
#line 14658 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
            return -1;
          return 998; /* *nabsti2_doubleword */

        case 2:
          if (!
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            return -1;
          return 1003; /* *nabsqi2_1 */

        case 3:
          if (!
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            return -1;
          return 1004; /* *nabshi2_1 */

        case 4:
          if (!
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
            return -1;
          return 1005; /* *nabssi2_1 */

        case 5:
          switch (GET_MODE (operands[0]))
            {
            case E_TFmode:
              if (pattern1043 (x3, 
E_TFmode) != 0
                  || !
#line 14787 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE))
                return -1;
              return 1009; /* *nabstf2_1 */

            case E_SFmode:
              if (pattern1044 (x3, 
E_V4SFmode, 
E_SFmode) != 0
                  || !
#line 14923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH))
                return -1;
              return 1022; /* *nabssf2_1 */

            case E_DFmode:
              if (pattern1044 (x3, 
E_V2DFmode, 
E_DFmode) != 0
                  || !
#line 14923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH))
                return -1;
              return 1023; /* *nabsdf2_1 */

            case E_V2SFmode:
              if (pattern1045 (x3) != 0
                  || !
#line 700 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE))
                return -1;
              return 2051; /* *mmx_nabsv2sf2 */

            case E_V2BFmode:
              if (pattern1046 (x3, 
E_V2BFmode) != 0
                  || !
#line 2257 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
                return -1;
              return 2103; /* *mmx_nabsv2bf2 */

            case E_V4BFmode:
              if (pattern1046 (x3, 
E_V4BFmode) != 0
                  || !(
#line 2257 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2225 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
                return -1;
              return 2104; /* *mmx_nabsv4bf2 */

            case E_V2HFmode:
              if (pattern1046 (x3, 
E_V2HFmode) != 0
                  || !
#line 2257 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE))
                return -1;
              return 2105; /* *mmx_nabsv2hf2 */

            case E_V4HFmode:
              if (pattern1046 (x3, 
E_V4HFmode) != 0
                  || !(
#line 2257 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_SSE) && 
#line 2226 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_MMX_WITH_SSE)))
                return -1;
              return 2106; /* *mmx_nabsv4hf2 */

            case E_V16SFmode:
              if (pattern1043 (x3, 
E_V16SFmode) != 0
                  || !(
#line 2614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 2677; /* *nabsv16sf2 */

            case E_V8SFmode:
              if (pattern1043 (x3, 
E_V8SFmode) != 0
                  || !(
#line 2614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 374 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 2678; /* *nabsv8sf2 */

            case E_V4SFmode:
              if (pattern1043 (x3, 
E_V4SFmode) != 0
                  || !
#line 2614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE))
                return -1;
              return 2679; /* *nabsv4sf2 */

            case E_V8DFmode:
              if (pattern1043 (x3, 
E_V8DFmode) != 0
                  || !(
#line 2614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)))
                return -1;
              return 2680; /* *nabsv8df2 */

            case E_V4DFmode:
              if (pattern1043 (x3, 
E_V4DFmode) != 0
                  || !(
#line 2614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 375 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)))
                return -1;
              return 2681; /* *nabsv4df2 */

            case E_V2DFmode:
              if (pattern1043 (x3, 
E_V2DFmode) != 0
                  || !(
#line 2614 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE) && 
#line 376 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)))
                return -1;
              return 2682; /* *nabsv2df2 */

            default:
              return -1;
            }

        default:
          return -1;
        }

    case LTU:
    case UNLT:
      operands[1] = x4;
      if (pattern572 (operands[1]) != 0
          || pattern340 (x1) != 0)
        return -1;
      switch (GET_MODE (operands[0]))
        {
        case E_QImode:
          if (!register_operand (operands[0], E_QImode)
              || GET_MODE (x3) != E_QImode)
            return -1;
          return 1799; /* *x86_movqicc_0_m1_neg */

        case E_HImode:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x3) != E_HImode)
            return -1;
          return 1800; /* *x86_movhicc_0_m1_neg */

        case E_SImode:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x3) != E_SImode)
            return -1;
          return 1801; /* *x86_movsicc_0_m1_neg */

        case E_DImode:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x3) != E_DImode
              || !
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
            return -1;
          return 1802; /* *x86_movdicc_0_m1_neg */

        default:
          return -1;
        }

    default:
      return -1;
    }
}

 int
recog_415 (rtx x1 ATTRIBUTE_UNUSED,
	rtx_insn *insn ATTRIBUTE_UNUSED,
	int *pnum_clobbers ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15;
  int res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  switch (GET_CODE (x2))
    {
    case SET:
      x3 = XEXP (x2, 1);
      switch (GET_CODE (x3))
        {
        case CONST_INT:
        case CONST_WIDE_INT:
        case CONST_POLY_INT:
        case CONST_FIXED:
        case CONST_DOUBLE:
        case CONST_VECTOR:
        case CONST:
        case REG:
        case SUBREG:
        case MEM:
        case LABEL_REF:
        case SYMBOL_REF:
        case HIGH:
          res = recog_355 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case SIGN_EXTRACT:
        case ZERO_EXTRACT:
          res = recog_357 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case UNSPEC:
          res = recog_363 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case ZERO_EXTEND:
          res = recog_367 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case UNSIGNED_FIX:
          res = recog_368 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case FIX:
          res = recog_369 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case FLOAT:
          res = recog_370 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case UNSIGNED_FLOAT:
          res = recog_371 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case PLUS:
          res = recog_373 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case COMPARE:
          res = recog_384 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case NE:
        case EQ:
        case GE:
        case GT:
        case LE:
        case LT:
        case LTGT:
        case GEU:
        case GTU:
        case LEU:
        case LTU:
        case UNORDERED:
        case ORDERED:
        case UNEQ:
        case UNGE:
        case UNGT:
        case UNLE:
        case UNLT:
          switch (GET_CODE (x3))
            {
            case NE:
            case EQ:
              if (GET_CODE (x3) == EQ)
                {
                  res = recog_385 (x1, insn, pnum_clobbers);
                  if (res >= 0)
                    return res;
                }
              operands[1] = x3;
              switch (pattern560 (x1))
                {
                case 0:
                  if ((
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 1555 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512DQ)))
                    return 2626; /* *kortest_cmpqi_setcc */
                  break;

                case 1:
                  if (
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
                    return 2627; /* *kortest_cmphi_setcc */
                  break;

                case 2:
                  if (
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW))
                    return 2628; /* *kortest_cmpsi_setcc */
                  break;

                case 3:
                  if ((
#line 2387 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512BW) && 
#line 1556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512BW && TARGET_64BIT)))
                    return 2629; /* *kortest_cmpdi_setcc */
                  break;

                default:
                  break;
                }
              break;

            case GT:
              if (pattern368 (x1) == 0
                  && 
#line 1214 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
                return 2070; /* mmx_gtv2sf3 */
              break;

            case GE:
              if (pattern368 (x1) == 0
                  && 
#line 1225 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW))
                return 2071; /* mmx_gev2sf3 */
              break;

            default:
              break;
            }
          operands[1] = x3;
          switch (pattern369 (x1))
            {
            case 0:
              if (
#line 19529 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL
   && TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
                return 1448; /* *setcc_hi_1_and */
              break;

            case 1:
              if (
#line 19529 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL
   && TARGET_ZERO_EXTEND_WITH_AND && optimize_function_for_speed_p (cfun)))
                return 1449; /* *setcc_si_1_and */
              break;

            default:
              break;
            }
          break;

        case MINUS:
          res = recog_388 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case IF_THEN_ELSE:
          res = recog_390 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case MULT:
          res = recog_391 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case DIV:
          if (pnum_clobbers != NULL)
            {
              switch (pattern219 (x1))
                {
                case 0:
                  switch (GET_MODE (operands[0]))
                    {
                    case E_HImode:
                      if (pattern390 (x1, 
E_HImode) == 0
                          && 
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH))
                        {
                          *pnum_clobbers = 1;
                          return 647; /* *divmodhi4 */
                        }
                      break;

                    case E_SImode:
                      if (pattern390 (x1, 
E_SImode) == 0)
                        {
                          *pnum_clobbers = 1;
                          return 648; /* *divmodsi4 */
                        }
                      break;

                    case E_DImode:
                      if (pattern390 (x1, 
E_DImode) == 0
                          && 
#line 1192 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                        {
                          *pnum_clobbers = 1;
                          return 649; /* *divmoddi4 */
                        }
                      break;

                    default:
                      break;
                    }
                  break;

                case 1:
                  if (const_int_operand (operands[2], E_SImode)
                      && pattern1479 (x1) == 0
                      && 
#line 11919 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!optimize_function_for_size_p (cfun)))
                    {
                      *pnum_clobbers = 1;
                      return 677; /* *divmodsi4_const */
                    }
                  break;

                default:
                  break;
                }
            }
          break;

        case UDIV:
          if (pnum_clobbers != NULL)
            {
              switch (pattern220 (x1))
                {
                case 0:
                  switch (GET_MODE (operands[0]))
                    {
                    case E_HImode:
                      if (pattern390 (x1, 
E_HImode) == 0
                          && 
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH))
                        {
                          *pnum_clobbers = 1;
                          return 650; /* *udivmodhi4 */
                        }
                      break;

                    case E_SImode:
                      if (pattern390 (x1, 
E_SImode) == 0)
                        {
                          *pnum_clobbers = 1;
                          return 651; /* *udivmodsi4 */
                        }
                      break;

                    case E_DImode:
                      if (pattern390 (x1, 
E_DImode) == 0
                          && 
#line 1192 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT))
                        {
                          *pnum_clobbers = 1;
                          return 652; /* *udivmoddi4 */
                        }
                      break;

                    default:
                      break;
                    }
                  break;

                case 1:
                  switch (GET_MODE (operands[0]))
                    {
                    case E_SImode:
                      if (pattern1480 (x1, 
E_SImode) == 0
                          && 
#line 11672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)))
                        {
                          *pnum_clobbers = 1;
                          return 653; /* *udivmodsi4_pow2 */
                        }
                      break;

                    case E_DImode:
                      if (pattern1480 (x1, 
E_DImode) == 0
                          && (
#line 11672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                        {
                          *pnum_clobbers = 1;
                          return 654; /* *udivmoddi4_pow2 */
                        }
                      break;

                    default:
                      break;
                    }
                  break;

                default:
                  break;
                }
            }
          break;

        case IOR:
          res = recog_393 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case AND:
          res = recog_396 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case XOR:
          res = recog_397 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case NOT:
          res = recog_398 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case NEG:
          res = recog_399 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case ABS:
          res = recog_400 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case ASHIFT:
          res = recog_401 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case LSHIFTRT:
          res = recog_402 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case ASHIFTRT:
          res = recog_404 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case ROTATE:
          switch (pattern210 (x1))
            {
            case 0:
              x4 = XEXP (x3, 1);
              if (GET_CODE (x4) == SUBREG)
                {
                  switch (pattern1157 (x2))
                    {
                    case 0:
                      if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()))
                        return 1284; /* *rotlqi3_mask */
                      break;

                    case 1:
                      if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()))
                        return 1286; /* *rotlhi3_mask */
                      break;

                    case 2:
                      if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                        return 1288; /* *rotlsi3_mask */
                      break;

                    case 3:
                      if ((
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                        return 1290; /* *rotldi3_mask */
                      break;

                    case 4:
                      if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1300; /* *rotlqi3_add */
                      break;

                    case 5:
                      if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1302; /* *rotlhi3_add */
                      break;

                    case 6:
                      if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1304; /* *rotlsi3_add */
                      break;

                    case 7:
                      if ((
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                        return 1306; /* *rotldi3_add */
                      break;

                    case 8:
                      if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1316; /* *rotlqi3_sub */
                      break;

                    case 9:
                      if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1318; /* *rotlhi3_sub */
                      break;

                    case 10:
                      if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1320; /* *rotlsi3_sub */
                      break;

                    case 11:
                      if ((
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                        return 1322; /* *rotldi3_sub */
                      break;

                    default:
                      break;
                    }
                }
              operands[2] = x4;
              switch (pattern1158 (x2))
                {
                case 0:
                  if (
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands, TARGET_APX_NDD)
   && true))
                    return 1343; /* *rotlsi3_1 */
                  break;

                case 1:
                  if ((
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1347; /* *rotldi3_1 */
                  break;

                case 2:
                  if (
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands, TARGET_APX_NDD)
   && true))
                    return 1374; /* *rotlqi3_1 */
                  break;

                case 3:
                  if (
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands, TARGET_APX_NDD)
   && true))
                    return 1378; /* *rotlhi3_1 */
                  break;

                case 4:
                  if (
#line 18722 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 1381; /* *rotlqi3_1_slp */
                  break;

                case 5:
                  if (
#line 18722 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 1383; /* *rotlhi3_1_slp */
                  break;

                default:
                  break;
                }
              break;

            case 1:
              if (
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()))
                return 1292; /* *rotlqi3_mask_1 */
              break;

            case 2:
              if (
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()))
                return 1294; /* *rotlhi3_mask_1 */
              break;

            case 3:
              if (
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return 1296; /* *rotlsi3_mask_1 */
              break;

            case 4:
              if ((
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1298; /* *rotldi3_mask_1 */
              break;

            case 5:
              if (
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1308; /* *rotlqi3_add_1 */
              break;

            case 6:
              if (
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1310; /* *rotlhi3_add_1 */
              break;

            case 7:
              if (
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1312; /* *rotlsi3_add_1 */
              break;

            case 8:
              if ((
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1314; /* *rotldi3_add_1 */
              break;

            case 9:
              if (
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1324; /* *rotlqi3_sub_1 */
              break;

            case 10:
              if (
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1326; /* *rotlhi3_sub_1 */
              break;

            case 11:
              if (
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1328; /* *rotlsi3_sub_1 */
              break;

            case 12:
              if ((
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATE, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1330; /* *rotldi3_sub_1 */
              break;

            default:
              break;
            }
          break;

        case ROTATERT:
          switch (pattern210 (x1))
            {
            case 0:
              x4 = XEXP (x3, 1);
              if (GET_CODE (x4) == SUBREG)
                {
                  switch (pattern1157 (x2))
                    {
                    case 0:
                      if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()))
                        return 1285; /* *rotrqi3_mask */
                      break;

                    case 1:
                      if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()))
                        return 1287; /* *rotrhi3_mask */
                      break;

                    case 2:
                      if (
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                        return 1289; /* *rotrsi3_mask */
                      break;

                    case 3:
                      if ((
#line 18156 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                        return 1291; /* *rotrdi3_mask */
                      break;

                    case 4:
                      if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1301; /* *rotrqi3_add */
                      break;

                    case 5:
                      if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1303; /* *rotrhi3_add */
                      break;

                    case 6:
                      if (
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1305; /* *rotrsi3_add */
                      break;

                    case 7:
                      if ((
#line 18249 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                        return 1307; /* *rotrdi3_add */
                      break;

                    case 8:
                      if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1317; /* *rotrqi3_sub */
                      break;

                    case 9:
                      if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1319; /* *rotrhi3_sub */
                      break;

                    case 10:
                      if (
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                        return 1321; /* *rotrsi3_sub */
                      break;

                    case 11:
                      if ((
#line 18318 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                        return 1323; /* *rotrdi3_sub */
                      break;

                    default:
                      break;
                    }
                }
              operands[2] = x4;
              switch (pattern1158 (x2))
                {
                case 0:
                  if (
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands, TARGET_APX_NDD)
   && true))
                    return 1345; /* *rotrsi3_1 */
                  break;

                case 1:
                  if ((
#line 18510 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands, TARGET_APX_NDD)
   && true) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return 1349; /* *rotrdi3_1 */
                  break;

                case 2:
                  if (
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, QImode, operands, TARGET_APX_NDD)
   && true))
                    return 1376; /* *rotrqi3_1 */
                  break;

                case 3:
                  if (
#line 18691 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, HImode, operands, TARGET_APX_NDD)
   && true))
                    return 1380; /* *rotrhi3_1 */
                  break;

                case 4:
                  if (
#line 18722 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 1382; /* *rotrqi3_1_slp */
                  break;

                case 5:
                  if (
#line 18722 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)))
                    return 1384; /* *rotrhi3_1_slp */
                  break;

                default:
                  break;
                }
              break;

            case 1:
              if (
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, QImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (QImode)-1))
      == GET_MODE_BITSIZE (QImode)-1
   && ix86_pre_reload_split ()))
                return 1293; /* *rotrqi3_mask_1 */
              break;

            case 2:
              if (
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, HImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (HImode)-1))
      == GET_MODE_BITSIZE (HImode)-1
   && ix86_pre_reload_split ()))
                return 1295; /* *rotrhi3_mask_1 */
              break;

            case 3:
              if (
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (SImode)-1))
      == GET_MODE_BITSIZE (SImode)-1
   && ix86_pre_reload_split ()))
                return 1297; /* *rotrsi3_mask_1 */
              break;

            case 4:
              if ((
#line 18204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (GET_MODE_BITSIZE (DImode)-1))
      == GET_MODE_BITSIZE (DImode)-1
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1299; /* *rotrdi3_mask_1 */
              break;

            case 5:
              if (
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1309; /* *rotrqi3_add_1 */
              break;

            case 6:
              if (
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1311; /* *rotrhi3_add_1 */
              break;

            case 7:
              if (
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1313; /* *rotrsi3_add_1 */
              break;

            case 8:
              if ((
#line 18285 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1315; /* *rotrdi3_add_1 */
              break;

            case 9:
              if (
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, QImode, operands)
   && (INTVAL (operands[3]) & (1 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1325; /* *rotrqi3_sub_1 */
              break;

            case 10:
              if (
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, HImode, operands)
   && (INTVAL (operands[3]) & (2 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1327; /* *rotrhi3_sub_1 */
              break;

            case 11:
              if (
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, SImode, operands)
   && (INTVAL (operands[3]) & (4 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()))
                return 1329; /* *rotrsi3_sub_1 */
              break;

            case 12:
              if ((
#line 18354 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_binary_operator_ok (ROTATERT, DImode, operands)
   && (INTVAL (operands[3]) & (8 * BITS_PER_UNIT - 1)) == 0
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1331; /* *rotrdi3_sub_1 */
              break;

            default:
              break;
            }
          break;

        case CALL:
          res = recog_405 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case CTZ:
          res = recog_406 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case SIGN_EXTEND:
          res = recog_407 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case CLZ:
          res = recog_408 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case POPCOUNT:
          res = recog_409 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case SMAX:
          switch (pattern214 (x1))
            {
            case 0:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 1831; /* *smaxdi3_doubleword */
              if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1851; /* *smaxdi3_1 */
              break;

            case 1:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1835; /* *smaxti3_doubleword */
              break;

            case 2:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1839; /* *smaxqi3_1 */
              break;

            case 3:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1843; /* *smaxhi3_1 */
              break;

            case 4:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1847; /* *smaxsi3_1 */
              break;

            case 5:
              if (
#line 871 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (SMAX, V2SFmode, operands)))
                return 2055; /* *mmx_smaxv2sf3 */
              break;

            default:
              break;
            }
          break;

        case SMIN:
          switch (pattern214 (x1))
            {
            case 0:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 1832; /* *smindi3_doubleword */
              if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1852; /* *smindi3_1 */
              break;

            case 1:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1836; /* *sminti3_doubleword */
              break;

            case 2:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1840; /* *sminqi3_1 */
              break;

            case 3:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1844; /* *sminhi3_1 */
              break;

            case 4:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1848; /* *sminsi3_1 */
              break;

            case 5:
              if (
#line 871 "/build/gcc/src/gcc/gcc/config/i386/mmx.md"
(TARGET_3DNOW && ix86_binary_operator_ok (SMIN, V2SFmode, operands)))
                return 2056; /* *mmx_sminv2sf3 */
              break;

            default:
              break;
            }
          break;

        case UMAX:
          switch (pattern215 (x1))
            {
            case 0:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 1833; /* *umaxdi3_doubleword */
              if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1853; /* *umaxdi3_1 */
              break;

            case 1:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1837; /* *umaxti3_doubleword */
              break;

            case 2:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1841; /* *umaxqi3_1 */
              break;

            case 3:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1845; /* *umaxhi3_1 */
              break;

            case 4:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1849; /* *umaxsi3_1 */
              break;

            default:
              break;
            }
          break;

        case UMIN:
          switch (pattern215 (x1))
            {
            case 0:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return 1834; /* *umindi3_doubleword */
              if ((
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1854; /* *umindi3_1 */
              break;

            case 1:
              if ((
#line 26938 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return 1838; /* *uminti3_doubleword */
              break;

            case 2:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1842; /* *uminqi3_1 */
              break;

            case 3:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1846; /* *uminhi3_1 */
              break;

            case 4:
              if (
#line 26996 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()))
                return 1850; /* *uminsi3_1 */
              break;

            default:
              break;
            }
          break;

        case UNSPEC_VOLATILE:
          res = recog_410 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case VEC_MERGE:
          if (pattern216 (x1) == 0
              && 
#line 8353 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((TARGET_MMX || TARGET_MMX_WITH_SSE) && TARGET_SSE))
            return 4715; /* sse_cvtpi2ps */
          break;

        case VEC_CONCAT:
          res = recog_411 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case VEC_DUPLICATE:
          res = recog_412 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        case VEC_SELECT:
          res = recog_413 (x1, insn, pnum_clobbers);
          if (res >= 0)
            return res;
          break;

        default:
          break;
        }
      x5 = XVECEXP (x1, 0, 1);
      if (GET_CODE (x5) != UNSPEC
          || XVECLEN (x5, 0) != 1
          || XINT (x5, 1) != 38)
        return -1;
      return recog_414 (x1, insn, pnum_clobbers);

    case CALL:
      x6 = XEXP (x2, 0);
      if (GET_CODE (x6) != MEM
          || GET_MODE (x6) != E_QImode)
        return -1;
      x7 = XEXP (x6, 0);
      operands[0] = x7;
      x3 = XEXP (x2, 1);
      operands[1] = x3;
      x5 = XVECEXP (x1, 0, 1);
      switch (pattern708 (x5))
        {
        case 0:
          switch (GET_MODE (operands[0]))
            {
            case E_SImode:
              if (memory_operand (operands[0], E_SImode)
                  && (
#line 20204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
                return 1470; /* *sibcall_memory */
              break;

            case E_DImode:
              if (memory_operand (operands[0], E_DImode)
                  && (
#line 20204 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_X32 && !TARGET_INDIRECT_BRANCH_REGISTER) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
                return 1471; /* *sibcall_memory */
              break;

            default:
              break;
            }
          break;

        case 1:
          x8 = XEXP (x5, 1);
          x9 = XEXP (x8, 1);
          operands[2] = x9;
          if (immediate_operand (operands[2], E_SImode))
            {
              if (call_insn_operand (operands[0], E_SImode)
                  && 
#line 20255 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && !SIBLING_CALL_P (insn)))
                return 1472; /* *call_pop */
              if (sibcall_insn_operand (operands[0], E_SImode)
                  && 
#line 20265 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && SIBLING_CALL_P (insn)))
                return 1473; /* *sibcall_pop */
            }
          break;

        default:
          break;
        }
      if (x7 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || x3 != const_int_rtx[MAX_SAVED_CONST_INT + 0]
          || pattern383 (x5, 
104, 
1) != 0
          || !
#line 27501 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX))
        return -1;
      return 9018; /* avx_vzeroupper_callee_abi */

    case SIMPLE_RETURN:
      x5 = XVECEXP (x1, 0, 1);
      switch (GET_CODE (x5))
        {
        case UNSPEC:
          if (XVECLEN (x5, 0) != 1)
            return -1;
          x10 = XVECEXP (x5, 0, 0);
          if (x10 != const_int_rtx[MAX_SAVED_CONST_INT + 0])
            return -1;
          switch (XINT (x5, 1))
            {
            case 101:
              if (!
#line 20667 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return -1;
              return 1490; /* interrupt_return */

            case 29:
              if (!
#line 20678 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return -1;
              return 1491; /* simple_return_internal_long */

            default:
              return -1;
            }

        case USE:
          x11 = XEXP (x5, 0);
          operands[0] = x11;
          switch (GET_CODE (operands[0]))
            {
            case CONST_INT:
              if (!const_int_operand (operands[0], E_SImode)
                  || !
#line 20689 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return -1;
              return 1492; /* simple_return_pop_internal */

            case REG:
            case SUBREG:
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (!register_operand (operands[0], E_SImode)
                      || !(
#line 20707 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == SImode)))
                    return -1;
                  return 1493; /* *simple_return_indirect_internalsi */

                case E_DImode:
                  if (!register_operand (operands[0], E_DImode)
                      || !(
#line 20707 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1403 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(word_mode == DImode)))
                    return -1;
                  return 1494; /* *simple_return_indirect_internaldi */

                default:
                  return -1;
                }

            default:
              return -1;
            }

        default:
          return -1;
        }

    case UNSPEC_VOLATILE:
      if (XVECLEN (x2, 0) != 4
          || XINT (x2, 1) != 98
          || GET_MODE (x2) != E_V2DImode)
        return -1;
      x5 = XVECEXP (x1, 0, 1);
      if (pattern231 (x5, 
E_CCmode, 
17) != 0)
        return -1;
      x12 = XVECEXP (x2, 0, 0);
      operands[0] = x12;
      if (!register_operand (operands[0], E_V2DImode))
        return -1;
      x13 = XVECEXP (x2, 0, 1);
      operands[1] = x13;
      if (!register_operand (operands[1], E_V2DImode))
        return -1;
      x14 = XVECEXP (x2, 0, 2);
      operands[2] = x14;
      if (!register_operand (operands[2], E_V2DImode))
        return -1;
      x15 = XVECEXP (x2, 0, 3);
      operands[3] = x15;
      if (!register_operand (operands[3], E_SImode)
          || !
#line 31472 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_KL))
        return -1;
      return 10288; /* loadiwkey */

    default:
      return -1;
    }
}

 rtx_insn *
split_27 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 1);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
      switch (pattern377 (x1))
        {
        case 0:
          x5 = XVECEXP (x1, 0, 1);
          x6 = XEXP (x5, 0);
          if (GET_CODE (x6) != REG
              || REGNO (x6) != 17
              || GET_MODE (x6) != E_CCmode)
            return NULL;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (!nonimmediate_operand (operands[0], E_DImode)
                  || GET_MODE (x3) != E_DImode
                  || !nonimmediate_operand (operands[1], E_DImode)
                  || !((
#line 14251 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, DImode, operands, TARGET_APX_NDD)) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14253 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_496 (insn, operands);

            case E_TImode:
              if (!nonimmediate_operand (operands[0], E_TImode)
                  || GET_MODE (x3) != E_TImode
                  || !nonimmediate_operand (operands[1], E_TImode)
                  || !((
#line 14251 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(ix86_unary_operator_ok (NEG, TImode, operands, TARGET_APX_NDD)) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14253 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_497 (insn, operands);

            case E_SFmode:
              if (GET_MODE (x3) != E_SFmode)
                return NULL;
              if (fp_register_operand (operands[0], E_SFmode)
                  && fp_register_operand (operands[1], E_SFmode)
                  && 
#line 14831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return gen_split_519 (insn, operands);
              if (!general_reg_operand (operands[0], E_SFmode)
                  || !general_reg_operand (operands[1], E_SFmode)
                  || !
#line 14838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return NULL;
              return gen_split_525 (insn, operands);

            case E_DFmode:
              if (GET_MODE (x3) != E_DFmode)
                return NULL;
              if (fp_register_operand (operands[0], E_DFmode)
                  && fp_register_operand (operands[1], E_DFmode)
                  && 
#line 14831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return gen_split_521 (insn, operands);
              if (!general_reg_operand (operands[0], E_DFmode)
                  || !general_reg_operand (operands[1], E_DFmode)
                  || !
#line 14838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return NULL;
              return gen_split_527 (insn, operands);

            case E_XFmode:
              if (GET_MODE (x3) != E_XFmode)
                return NULL;
              if (fp_register_operand (operands[0], E_XFmode)
                  && fp_register_operand (operands[1], E_XFmode)
                  && 
#line 14831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return gen_split_523 (insn, operands);
              if (!general_reg_operand (operands[0], E_XFmode)
                  || !general_reg_operand (operands[1], E_XFmode)
                  || !
#line 14838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return NULL;
              return gen_split_529 (insn, operands);

            default:
              return NULL;
            }

        case 1:
          if (pattern830 (x1) != 0
              || !(
#line 14762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE) && 
#line 14764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_516 (insn, operands);

        case 2:
          if (!(
#line 14409 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 14413 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_498 (insn, operands);

        case 3:
          if (!(
#line 14409 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_PARTIAL_REG_STALL || optimize_function_for_size_p (cfun)) && 
#line 14413 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed
   && !(rtx_equal_p (operands[0], operands[1])))))
            return NULL;
          return gen_split_499 (insn, operands);

        default:
          return NULL;
        }

    case ABS:
      switch (pattern379 (x1))
        {
        case 0:
          if (((
#line 14658 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_505 (insn, operands);
          if (!((
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14733 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_514 (insn, operands);

        case 1:
          if (!((
#line 14658 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14661 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_506 (insn, operands);

        case 2:
          if (!(
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 14733 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_511 (insn, operands);

        case 3:
          if (!(
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 14733 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_512 (insn, operands);

        case 4:
          if (!(
#line 14729 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 14733 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_513 (insn, operands);

        case 5:
          switch (GET_MODE (operands[0]))
            {
            case E_TFmode:
              if (pattern1043 (x3, 
E_TFmode) != 0
                  || !(
#line 14787 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE) && 
#line 14789 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_517 (insn, operands);

            case E_SFmode:
              if (pattern1044 (x3, 
E_V4SFmode, 
E_SFmode) != 0
                  || !(
#line 14923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH) && 
#line 14925 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_544 (insn, operands);

            case E_DFmode:
              if (pattern1044 (x3, 
E_V2DFmode, 
E_DFmode) != 0
                  || !(
#line 14923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH) && 
#line 14925 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_545 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_29 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XVECEXP (x1, 0, 0);
  x3 = XEXP (x2, 0);
  operands[0] = x3;
  x4 = XEXP (x2, 1);
  x5 = XEXP (x4, 0);
  operands[1] = x5;
  x6 = XVECEXP (x1, 0, 1);
  switch (GET_CODE (x6))
    {
    case CLOBBER:
      x7 = XEXP (x6, 0);
      switch (pattern693 (x7))
        {
        case 0:
          if (!register_operand (operands[0], E_DImode)
              || GET_MODE (x4) != E_DImode
              || !general_operand (operands[1], E_DImode))
            return NULL;
          if (((
#line 14614 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)) && 
#line 14617 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return gen_split_503 (insn, operands);
          if (!((
#line 14701 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (DImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 1161 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_510 (insn, operands);

        case 1:
          if (!register_operand (operands[0], E_TImode)
              || GET_MODE (x4) != E_TImode
              || !general_operand (operands[1], E_TImode)
              || !((
#line 14614 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && ix86_pre_reload_split ()) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 14617 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_504 (insn, operands);

        case 2:
          if (!register_operand (operands[0], E_QImode)
              || GET_MODE (x4) != E_QImode
              || !general_operand (operands[1], E_QImode)
              || !(
#line 14701 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (QImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 14705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_507 (insn, operands);

        case 3:
          if (!register_operand (operands[0], E_HImode)
              || GET_MODE (x4) != E_HImode
              || !general_operand (operands[1], E_HImode)
              || !(
#line 14701 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (HImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 14705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_508 (insn, operands);

        case 4:
          if (!register_operand (operands[0], E_SImode)
              || GET_MODE (x4) != E_SImode
              || !general_operand (operands[1], E_SImode)
              || !(
#line 14701 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_CMOVE
   && (SImode != QImode || !TARGET_PARTIAL_REG_STALL)
   && ix86_pre_reload_split ()) && 
#line 14705 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( 1)))
            return NULL;
          return gen_split_509 (insn, operands);

        case 5:
          if (GET_MODE (x4) != E_SFmode)
            return NULL;
          if (fp_register_operand (operands[0], E_SFmode)
              && fp_register_operand (operands[1], E_SFmode)
              && 
#line 14831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
            return gen_split_518 (insn, operands);
          if (!general_reg_operand (operands[0], E_SFmode)
              || !general_reg_operand (operands[1], E_SFmode)
              || !
#line 14838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
            return NULL;
          return gen_split_524 (insn, operands);

        case 6:
          if (GET_MODE (x4) != E_DFmode)
            return NULL;
          if (fp_register_operand (operands[0], E_DFmode)
              && fp_register_operand (operands[1], E_DFmode)
              && 
#line 14831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
            return gen_split_520 (insn, operands);
          if (!general_reg_operand (operands[0], E_DFmode)
              || !general_reg_operand (operands[1], E_DFmode)
              || !
#line 14838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
            return NULL;
          return gen_split_526 (insn, operands);

        case 7:
          if (GET_MODE (x4) != E_XFmode)
            return NULL;
          if (fp_register_operand (operands[0], E_XFmode)
              && fp_register_operand (operands[1], E_XFmode)
              && 
#line 14831 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
            return gen_split_522 (insn, operands);
          if (!general_reg_operand (operands[0], E_XFmode)
              || !general_reg_operand (operands[1], E_XFmode)
              || !
#line 14838 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
            return NULL;
          return gen_split_528 (insn, operands);

        default:
          return NULL;
        }

    case USE:
      if (pattern830 (x1) != 0
          || !(
#line 14762 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_SSE) && 
#line 14764 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
        return NULL;
      return gen_split_515 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_35 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5, x6, x7, x8, x9;
  rtx x10, x11, x12, x13, x14, x15, x16, x17;
  rtx_insn *res ATTRIBUTE_UNUSED;
  switch (XVECLEN (x1, 0))
    {
    case 2:
      return split_34 (x1, insn);

    case 3:
      x2 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x2) != SET)
        return NULL;
      x3 = XVECEXP (x1, 0, 2);
      if (GET_CODE (x3) != CLOBBER)
        return NULL;
      x4 = XEXP (x2, 1);
      switch (GET_CODE (x4))
        {
        case SIGN_EXTEND:
          if (pattern244 (x1) != 0)
            return NULL;
          x5 = XEXP (x3, 0);
          operands[2] = x5;
          switch (GET_MODE (operands[0]))
            {
            case E_DImode:
              if (GET_MODE (x4) != E_DImode
                  || !register_operand (operands[1], E_SImode))
                return NULL;
              if (memory_operand (operands[0], E_DImode)
                  && register_operand (operands[2], E_SImode)
                  && (
#line 5015 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return gen_split_66 (insn, operands);
              if (!register_operand (operands[0], E_DImode)
                  || !scratch_operand (operands[2], E_SImode)
                  || !(
#line 5089 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return NULL;
              return gen_split_68 (insn, operands);

            case E_TImode:
              if (GET_MODE (x4) != E_TImode
                  || !register_operand (operands[1], E_DImode))
                return NULL;
              if (memory_operand (operands[0], E_TImode)
                  && register_operand (operands[2], E_DImode)
                  && (
#line 5015 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return gen_split_67 (insn, operands);
              if (!register_operand (operands[0], E_TImode)
                  || !scratch_operand (operands[2], E_DImode)
                  || !(
#line 5089 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_69 (insn, operands);

            default:
              return NULL;
            }

        case UNSIGNED_FLOAT:
          x6 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x6) != CLOBBER)
            return NULL;
          switch (pattern573 (x1))
            {
            case 0:
              if (!(
#line 6309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && TARGET_80387 && X87_ENABLE_FLOAT (SFmode, DImode)
   && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC) && 
#line 6313 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_97 (insn, operands);

            case 1:
              if (!(
#line 6309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && TARGET_80387 && X87_ENABLE_FLOAT (DFmode, DImode)
   && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC) && 
#line 6313 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_98 (insn, operands);

            case 2:
              if (!(
#line 6309 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT
   && TARGET_80387 && X87_ENABLE_FLOAT (XFmode, DImode)
   && TARGET_SSE2 && TARGET_INTER_UNIT_MOVES_TO_VEC) && 
#line 6313 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_99 (insn, operands);

            default:
              return NULL;
            }

        case DIV:
          if (pattern586 (x1, 
MOD) != 0)
            return NULL;
          x7 = XEXP (x2, 0);
          operands[0] = x7;
          x8 = XEXP (x4, 0);
          operands[2] = x8;
          x9 = XEXP (x4, 1);
          operands[3] = x9;
          x6 = XVECEXP (x1, 0, 1);
          x10 = XEXP (x6, 0);
          operands[1] = x10;
          x11 = XEXP (x6, 1);
          x12 = XEXP (x11, 0);
          if (!rtx_equal_p (x12, operands[2]))
            return NULL;
          x13 = XEXP (x11, 1);
          if (!rtx_equal_p (x13, operands[3]))
            return NULL;
          switch (GET_CODE (operands[2]))
            {
            case REG:
            case SUBREG:
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (pattern390 (x1, 
E_SImode) != 0)
                    return NULL;
                  if (
#line 11392 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()))
                    return gen_split_246 (insn, operands);
                  if (!
#line 11616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return NULL;
                  return gen_split_263 (insn, operands);

                case E_DImode:
                  if (pattern390 (x1, 
E_DImode) != 0)
                    return NULL;
                  if ((
#line 11392 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return gen_split_248 (insn, operands);
                  if (!(
#line 11616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1192 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return NULL;
                  return gen_split_264 (insn, operands);

                case E_HImode:
                  if (pattern390 (x1, 
E_HImode) != 0
                      || !(
#line 11616 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
                    return NULL;
                  return gen_split_262 (insn, operands);

                default:
                  return NULL;
                }

            case CONST_INT:
              if (!const_int_operand (operands[2], E_SImode)
                  || pattern1479 (x1) != 0
                  || !(
#line 11919 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!optimize_function_for_size_p (cfun)) && 
#line 11921 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_276 (insn, operands);

            default:
              return NULL;
            }

        case UDIV:
          if (pattern586 (x1, 
UMOD) != 0)
            return NULL;
          x7 = XEXP (x2, 0);
          operands[0] = x7;
          x8 = XEXP (x4, 0);
          operands[2] = x8;
          x9 = XEXP (x4, 1);
          operands[3] = x9;
          x6 = XVECEXP (x1, 0, 1);
          x10 = XEXP (x6, 0);
          operands[1] = x10;
          x11 = XEXP (x6, 1);
          x12 = XEXP (x11, 0);
          if (!rtx_equal_p (x12, operands[2]))
            return NULL;
          x13 = XEXP (x11, 1);
          if (!rtx_equal_p (x13, operands[3]))
            return NULL;
          switch (GET_CODE (operands[3]))
            {
            case REG:
            case SUBREG:
            case MEM:
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (pattern390 (x1, 
E_SImode) != 0)
                    return NULL;
                  if (
#line 11392 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()))
                    return gen_split_247 (insn, operands);
                  if (!
#line 11651 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                    return NULL;
                  return gen_split_266 (insn, operands);

                case E_DImode:
                  if (pattern390 (x1, 
E_DImode) != 0)
                    return NULL;
                  if ((
#line 11392 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return gen_split_249 (insn, operands);
                  if (!(
#line 11651 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1192 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                    return NULL;
                  return gen_split_267 (insn, operands);

                case E_HImode:
                  if (pattern390 (x1, 
E_HImode) != 0
                      || !(
#line 11651 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1191 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_HIMODE_MATH)))
                    return NULL;
                  return gen_split_265 (insn, operands);

                default:
                  return NULL;
                }

            case CONST_INT:
              switch (GET_MODE (operands[0]))
                {
                case E_SImode:
                  if (pattern1480 (x1, 
E_SImode) != 0
                      || !(
#line 11672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)) && 
#line 11674 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_268 (insn, operands);

                case E_DImode:
                  if (pattern1480 (x1, 
E_DImode) != 0
                      || !((
#line 11672 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)) && 
#line 11674 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_269 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          if (GET_MODE (x4) != E_DImode)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x6) != SET)
            return NULL;
          x5 = XEXP (x3, 0);
          if (GET_CODE (x5) != REG
              || REGNO (x5) != 17
              || GET_MODE (x5) != E_CCmode)
            return NULL;
          switch (pattern1047 (x1))
            {
            case 0:
              if (pattern1512 (x1, 
MOD) != 0)
                return NULL;
              if (
#line 11407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()))
                return gen_split_250 (insn, operands);
              if (!(
#line 11696 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11698 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_270 (insn, operands);

            case 1:
              x11 = XEXP (x6, 1);
              if (GET_CODE (x11) != UMOD)
                return NULL;
              x7 = XEXP (x2, 0);
              operands[0] = x7;
              x8 = XEXP (x4, 0);
              x14 = XEXP (x8, 0);
              operands[2] = x14;
              if (!register_operand (operands[2], E_SImode))
                return NULL;
              x15 = XEXP (x8, 1);
              operands[3] = x15;
              x10 = XEXP (x6, 0);
              operands[1] = x10;
              switch (pattern1605 (x11))
                {
                case 0:
                  if (
#line 11407 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()))
                    return gen_split_251 (insn, operands);
                  if (!(
#line 11731 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11733 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_271 (insn, operands);

                case 1:
                  if (!(
#line 11753 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)) && 
#line 11756 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_272 (insn, operands);

                default:
                  return NULL;
                }

            case 2:
              if (pattern1513 (x1, 
DIV) != 0)
                return NULL;
              if (
#line 11423 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()))
                return gen_split_252 (insn, operands);
              if (!(
#line 11779 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11781 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_273 (insn, operands);

            case 3:
              x11 = XEXP (x6, 1);
              if (GET_CODE (x11) != UDIV)
                return NULL;
              x7 = XEXP (x2, 0);
              operands[1] = x7;
              x8 = XEXP (x4, 0);
              x14 = XEXP (x8, 0);
              operands[2] = x14;
              if (!register_operand (operands[2], E_SImode))
                return NULL;
              x15 = XEXP (x8, 1);
              operands[3] = x15;
              x10 = XEXP (x6, 0);
              operands[0] = x10;
              switch (pattern1605 (x11))
                {
                case 0:
                  if (
#line 11423 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && TARGET_USE_8BIT_IDIV
   && TARGET_QIMODE_MATH
   && can_create_pseudo_p ()
   && !optimize_insn_for_size_p ()))
                    return gen_split_253 (insn, operands);
                  if (!(
#line 11815 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11817 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_274 (insn, operands);

                case 1:
                  if (!(
#line 11837 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT
   && IN_RANGE (exact_log2 (UINTVAL (operands[3])), 1, 31)) && 
#line 11840 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                    return NULL;
                  return gen_split_275 (insn, operands);

                default:
                  return NULL;
                }

            default:
              return NULL;
            }

        case ABS:
          switch (pattern587 (x1))
            {
            case 0:
              if (!(
#line 14848 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16) && 
#line 14850 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_530 (insn, operands);

            case 1:
              if (sse_reg_operand (operands[0], E_SFmode)
                  && sse_reg_operand (operands[1], E_SFmode)
                  && vector_operand (operands[2], E_V4SFmode)
                  && 
#line 14885 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
   && reload_completed))
                return gen_split_532 (insn, operands);
              if (fp_register_operand (operands[0], E_SFmode)
                  && fp_register_operand (operands[1], E_SFmode)
                  && 
#line 14905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return gen_split_536 (insn, operands);
              if (!general_reg_operand (operands[0], E_SFmode)
                  || !general_reg_operand (operands[1], E_SFmode)
                  || !
#line 14913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return NULL;
              return gen_split_540 (insn, operands);

            case 2:
              if (sse_reg_operand (operands[0], E_DFmode)
                  && sse_reg_operand (operands[1], E_DFmode)
                  && vector_operand (operands[2], E_V2DFmode)
                  && 
#line 14885 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
   && reload_completed))
                return gen_split_534 (insn, operands);
              if (fp_register_operand (operands[0], E_DFmode)
                  && fp_register_operand (operands[1], E_DFmode)
                  && 
#line 14905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return gen_split_538 (insn, operands);
              if (!general_reg_operand (operands[0], E_DFmode)
                  || !general_reg_operand (operands[1], E_DFmode)
                  || !
#line 14913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return NULL;
              return gen_split_542 (insn, operands);

            default:
              return NULL;
            }

        case NEG:
          switch (pattern587 (x1))
            {
            case 0:
              if (!(
#line 14848 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_AVX512FP16) && 
#line 14850 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_531 (insn, operands);

            case 1:
              if (sse_reg_operand (operands[0], E_SFmode)
                  && sse_reg_operand (operands[1], E_SFmode)
                  && vector_operand (operands[2], E_V4SFmode)
                  && 
#line 14885 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (SFmode) && TARGET_SSE_MATH
   && reload_completed))
                return gen_split_533 (insn, operands);
              if (fp_register_operand (operands[0], E_SFmode)
                  && fp_register_operand (operands[1], E_SFmode)
                  && 
#line 14905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return gen_split_537 (insn, operands);
              if (!general_reg_operand (operands[0], E_SFmode)
                  || !general_reg_operand (operands[1], E_SFmode)
                  || !
#line 14913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return NULL;
              return gen_split_541 (insn, operands);

            case 2:
              if (sse_reg_operand (operands[0], E_DFmode)
                  && sse_reg_operand (operands[1], E_DFmode)
                  && vector_operand (operands[2], E_V2DFmode)
                  && 
#line 14885 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(SSE_FLOAT_MODE_P (DFmode) && TARGET_SSE_MATH
   && reload_completed))
                return gen_split_535 (insn, operands);
              if (fp_register_operand (operands[0], E_DFmode)
                  && fp_register_operand (operands[1], E_DFmode)
                  && 
#line 14905 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return gen_split_539 (insn, operands);
              if (!general_reg_operand (operands[0], E_DFmode)
                  || !general_reg_operand (operands[1], E_DFmode)
                  || !
#line 14913 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_80387 && reload_completed))
                return NULL;
              return gen_split_543 (insn, operands);

            default:
              return NULL;
            }

        case ROTATE:
          switch (pattern588 (x1))
            {
            case 0:
              if (!(
#line 18389 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return NULL;
              return gen_split_780 (insn, operands);

            case 1:
              if (!(
#line 18389 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_781 (insn, operands);

            default:
              return NULL;
            }

        case ROTATERT:
          switch (pattern588 (x1))
            {
            case 0:
              if (!(
#line 18426 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1235 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT)))
                return NULL;
              return gen_split_782 (insn, operands);

            case 1:
              if (!(
#line 18426 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1236 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_783 (insn, operands);

            default:
              return NULL;
            }

        case FFS:
          if (GET_MODE (x4) != E_SImode)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x6) != CLOBBER
              || pattern711 (x1) != 0
              || !(
#line 20997 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_CMOVE) && 
#line 20999 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
            return NULL;
          return gen_split_876 (insn, operands);

        default:
          return NULL;
        }

    case 4:
      x2 = XVECEXP (x1, 0, 0);
      if (GET_CODE (x2) != SET)
        return NULL;
      x16 = XVECEXP (x1, 0, 3);
      if (GET_CODE (x16) != CLOBBER)
        return NULL;
      x4 = XEXP (x2, 1);
      switch (GET_CODE (x4))
        {
        case UNSIGNED_FIX:
          switch (pattern387 (x1))
            {
            case 0:
              if (!(
#line 5923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_SSE_MATH
   && optimize_function_for_speed_p (cfun)) && 
#line 5926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_80 (insn, operands);

            case 1:
              if (!(
#line 5923 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_SSE2 && TARGET_SSE_MATH
   && optimize_function_for_speed_p (cfun)) && 
#line 5926 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_81 (insn, operands);

            default:
              return NULL;
            }

        case FLOAT:
          switch (pattern389 (x1))
            {
            case 0:
              if (!(
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (SFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)) && 
#line 6222 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_90 (insn, operands);

            case 1:
              if (!(
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (DFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)) && 
#line 6222 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_91 (insn, operands);

            case 2:
              if (!(
#line 6218 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(!TARGET_64BIT && TARGET_INTER_UNIT_MOVES_TO_VEC
   && TARGET_80387 && X87_ENABLE_FLOAT (XFmode, DImode)
   && TARGET_SSE2 && optimize_function_for_speed_p (cfun)) && 
#line 6222 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_92 (insn, operands);

            default:
              return NULL;
            }

        case DIV:
          switch (pattern590 (x1, 
MOD))
            {
            case 0:
              if (!
#line 11441 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return NULL;
              return gen_split_254 (insn, operands);

            case 1:
              if (!(
#line 11441 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_255 (insn, operands);

            default:
              return NULL;
            }

        case UDIV:
          switch (pattern590 (x1, 
UMOD))
            {
            case 0:
              if (!
#line 11476 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed))
                return NULL;
              return gen_split_256 (insn, operands);

            case 1:
              if (!(
#line 11476 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(reload_completed) && 
#line 1167 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT)))
                return NULL;
              return gen_split_257 (insn, operands);

            default:
              return NULL;
            }

        case ZERO_EXTEND:
          if (GET_MODE (x4) != E_DImode)
            return NULL;
          x6 = XVECEXP (x1, 0, 1);
          if (GET_CODE (x6) != SET)
            return NULL;
          x3 = XVECEXP (x1, 0, 2);
          if (pattern384 (x3, 
32) != 0)
            return NULL;
          x17 = XEXP (x16, 0);
          if (GET_CODE (x17) != REG
              || REGNO (x17) != 17
              || GET_MODE (x17) != E_CCmode)
            return NULL;
          x7 = XEXP (x2, 0);
          if (!register_operand (x7, E_DImode))
            return NULL;
          x8 = XEXP (x4, 0);
          if (GET_MODE (x8) != E_SImode)
            return NULL;
          x10 = XEXP (x6, 0);
          if (!register_operand (x10, E_SImode))
            return NULL;
          x11 = XEXP (x6, 1);
          if (GET_MODE (x11) != E_SImode)
            return NULL;
          switch (GET_CODE (x8))
            {
            case DIV:
              if (pattern1512 (x1, 
MOD) != 0
                  || !(
#line 11497 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11499 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_258 (insn, operands);

            case UDIV:
              if (pattern1512 (x1, 
UMOD) != 0
                  || !(
#line 11533 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11535 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_259 (insn, operands);

            case MOD:
              if (pattern1513 (x1, 
DIV) != 0
                  || !(
#line 11556 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11558 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_260 (insn, operands);

            case UMOD:
              if (pattern1513 (x1, 
UDIV) != 0
                  || !(
#line 11593 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
(TARGET_64BIT) && 
#line 11595 "/build/gcc/src/gcc/gcc/config/i386/i386.md"
( reload_completed)))
                return NULL;
              return gen_split_261 (insn, operands);

            default:
              return NULL;
            }

        case PLUS:
          if (pattern395 (x1) != 0)
            return NULL;
          return gen_split_922 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_57 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4, x5;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  operands[1] = x3;
  x4 = XEXP (x2, 2);
  if (GET_CODE (x4) != UNSPEC
      || XVECLEN (x4, 0) != 3
      || XINT (x4, 1) != 59)
    return NULL;
  switch (pattern1001 (x2))
    {
    case 0:
      x5 = XVECEXP (x4, 0, 0);
      operands[3] = x5;
      switch (pattern1452 (x2))
        {
        case 0:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 389 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_EVEX512)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1293 (insn, operands);
          break;

        case 1:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 390 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1294 (insn, operands);
          break;

        case 2:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 391 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512FP16 && TARGET_AVX512VL)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1295 (insn, operands);
          break;

        case 3:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1296 (insn, operands);
          break;

        case 4:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 392 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1297 (insn, operands);
          break;

        case 5:
          if ((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1298 (insn, operands);
          break;

        case 6:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1299 (insn, operands);
          break;

        case 7:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 393 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1300 (insn, operands);
          break;

        case 8:
          if (((
#line 3332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE && ix86_pre_reload_split ()
   && ((rtx_equal_p (operands[1], operands[3])
	&& rtx_equal_p (operands[2], operands[4]))
       || (rtx_equal_p (operands[1], operands[4])
	   && rtx_equal_p (operands[2], operands[3])))
   && (INTVAL (operands[5]) == 1 || INTVAL (operands[5]) == 14)) && 
#line 394 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 3339 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1301 (insn, operands);
          break;

        case 9:
          if (((
#line 4217 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 421 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4221 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1338 (insn, operands);
          break;

        case 10:
          if ((
#line 4217 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4221 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1339 (insn, operands);
          break;

        case 11:
          if (((
#line 4217 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4221 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1340 (insn, operands);
          break;

        case 12:
          if (((
#line 4217 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 422 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 4221 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1341 (insn, operands);
          break;

        case 13:
          if ((
#line 4246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4250 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1342 (insn, operands);
          break;

        case 14:
          if ((
#line 4246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4250 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1343 (insn, operands);
          break;

        case 15:
          if (((
#line 4246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4250 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1344 (insn, operands);
          break;

        case 16:
          if (((
#line 4246 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4250 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_1345 (insn, operands);
          break;

        case 17:
          if (((
#line 18013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[2]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[1])))) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 18018 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3296 (insn, operands);
          break;

        case 18:
          if ((
#line 18013 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[2]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[1])))) && 
#line 18018 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return gen_split_3297 (insn, operands);
          break;

        default:
          break;
        }
      if (GET_CODE (x5) != SUBREG)
        return NULL;
      switch (pattern1455 (x2))
        {
        case 0:
          if (!(
#line 4281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1346 (insn, operands);

        case 1:
          if (!(
#line 4281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 4285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1347 (insn, operands);

        case 2:
          if (!((
#line 4281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1348 (insn, operands);

        case 3:
          if (!((
#line 4281 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* not LT or GE 0 */
  && ((INTVAL (operands[5]) == 1) || (INTVAL (operands[5]) == 5))) && 
#line 611 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 4285 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1349 (insn, operands);

        case 4:
          if (!((
#line 18042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
  && GET_MODE_SIZE (GET_MODE (operands[3])) == 32
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 18049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3298 (insn, operands);

        case 5:
          if (!(
#line 18042 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  && GET_MODE_CLASS (GET_MODE (operands[3])) == MODE_VECTOR_INT
  && GET_MODE_SIZE (GET_MODE (operands[3])) == 16
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 18049 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3299 (insn, operands);

        default:
          return NULL;
        }

    case 1:
      if (!((
#line 18074 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 629 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX2)) && 
#line 18079 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3300 (insn, operands);

    case 2:
      if (!(
#line 18074 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512VL && ix86_pre_reload_split ()
  /* LT or GE 0 */
  && ((INTVAL (operands[5]) == 1 && !MEM_P (operands[1]))
      || (INTVAL (operands[5]) == 5 && !MEM_P (operands[2])))) && 
#line 18079 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
        return NULL;
      return gen_split_3301 (insn, operands);

    default:
      return NULL;
    }
}

 rtx_insn *
split_66 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  x4 = XEXP (x3, 0);
  switch (GET_CODE (x4))
    {
    case REG:
    case SUBREG:
    case MEM:
    case NOT:
      switch (pattern533 (x2))
        {
        case 0:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1674 (insn, operands);

        case 1:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1701 (insn, operands);

        case 2:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1728 (insn, operands);

        case 3:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1755 (insn, operands);

        case 4:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1782 (insn, operands);

        case 5:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1809 (insn, operands);

        case 6:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1836 (insn, operands);

        case 7:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1863 (insn, operands);

        case 8:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1890 (insn, operands);

        case 9:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1917 (insn, operands);

        case 10:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1944 (insn, operands);

        case 11:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1971 (insn, operands);

        case 12:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1677 (insn, operands);

        case 13:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1704 (insn, operands);

        case 14:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1731 (insn, operands);

        case 15:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1758 (insn, operands);

        case 16:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1785 (insn, operands);

        case 17:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1812 (insn, operands);

        case 18:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1839 (insn, operands);

        case 19:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1866 (insn, operands);

        case 20:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1893 (insn, operands);

        case 21:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1920 (insn, operands);

        case 22:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1947 (insn, operands);

        case 23:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1974 (insn, operands);

        case 24:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1680 (insn, operands);

        case 25:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1707 (insn, operands);

        case 26:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1734 (insn, operands);

        case 27:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1761 (insn, operands);

        case 28:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1788 (insn, operands);

        case 29:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1815 (insn, operands);

        case 30:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1842 (insn, operands);

        case 31:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1869 (insn, operands);

        case 32:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1896 (insn, operands);

        case 33:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1923 (insn, operands);

        case 34:
          if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1950 (insn, operands);

        case 35:
          if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_1977 (insn, operands);

        case 36:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2964 (insn, operands);

        case 37:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2973 (insn, operands);

        case 38:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2982 (insn, operands);

        case 39:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2991 (insn, operands);

        case 40:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3000 (insn, operands);

        case 41:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3009 (insn, operands);

        case 42:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3018 (insn, operands);

        case 43:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3027 (insn, operands);

        case 44:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3036 (insn, operands);

        case 45:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3045 (insn, operands);

        case 46:
          if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3054 (insn, operands);

        case 47:
          if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_3063 (insn, operands);

        default:
          return NULL;
        }

    case AND:
      switch (pattern535 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2322 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2349 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2376 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2403 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2430 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2457 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2484 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2511 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2538 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2565 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2592 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2619 (insn, operands);

        default:
          return NULL;
        }

    case IOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2325 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2352 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2379 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2406 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2433 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2460 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2487 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2514 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2541 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2568 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2595 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2622 (insn, operands);

        default:
          return NULL;
        }

    case XOR:
      switch (pattern535 (x2))
        {
        case 0:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2328 (insn, operands);

        case 1:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 331 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2355 (insn, operands);

        case 2:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2382 (insn, operands);

        case 3:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2409 (insn, operands);

        case 4:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 332 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2436 (insn, operands);

        case 5:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2463 (insn, operands);

        case 6:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2490 (insn, operands);

        case 7:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 333 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2517 (insn, operands);

        case 8:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2544 (insn, operands);

        case 9:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2571 (insn, operands);

        case 10:
          if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 334 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2598 (insn, operands);

        case 11:
          if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
            return NULL;
          return gen_split_2625 (insn, operands);

        default:
          return NULL;
        }

    default:
      return NULL;
    }
}

 rtx_insn *
split_76 (rtx x1 ATTRIBUTE_UNUSED, rtx_insn *insn ATTRIBUTE_UNUSED)
{
  rtx * const operands ATTRIBUTE_UNUSED = &recog_data.operand[0];
  rtx x2, x3, x4;
  rtx_insn *res ATTRIBUTE_UNUSED;
  x2 = XEXP (x1, 1);
  x3 = XEXP (x2, 0);
  switch (GET_CODE (x3))
    {
    case AND:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern537 (x2))
            {
            case 0:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1990 (insn, operands);

            case 1:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2017 (insn, operands);

            case 2:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2044 (insn, operands);

            case 3:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2071 (insn, operands);

            case 4:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2098 (insn, operands);

            case 5:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2125 (insn, operands);

            case 6:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2152 (insn, operands);

            case 7:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2179 (insn, operands);

            case 8:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2206 (insn, operands);

            case 9:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2233 (insn, operands);

            case 10:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2260 (insn, operands);

            case 11:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2287 (insn, operands);

            case 12:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1993 (insn, operands);

            case 13:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2020 (insn, operands);

            case 14:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2047 (insn, operands);

            case 15:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2074 (insn, operands);

            case 16:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2101 (insn, operands);

            case 17:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2128 (insn, operands);

            case 18:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2155 (insn, operands);

            case 19:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2182 (insn, operands);

            case 20:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2209 (insn, operands);

            case 21:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2236 (insn, operands);

            case 22:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2263 (insn, operands);

            case 23:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2290 (insn, operands);

            case 24:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1996 (insn, operands);

            case 25:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2023 (insn, operands);

            case 26:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2050 (insn, operands);

            case 27:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2077 (insn, operands);

            case 28:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2104 (insn, operands);

            case 29:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2131 (insn, operands);

            case 30:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2158 (insn, operands);

            case 31:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2185 (insn, operands);

            case 32:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2212 (insn, operands);

            case 33:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2239 (insn, operands);

            case 34:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2266 (insn, operands);

            case 35:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2293 (insn, operands);

            case 36:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3070 (insn, operands);

            case 37:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3079 (insn, operands);

            case 38:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3088 (insn, operands);

            case 39:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3097 (insn, operands);

            case 40:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3106 (insn, operands);

            case 41:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3115 (insn, operands);

            case 42:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3124 (insn, operands);

            case 43:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3133 (insn, operands);

            case 44:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3142 (insn, operands);

            case 45:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3151 (insn, operands);

            case 46:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3160 (insn, operands);

            case 47:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3169 (insn, operands);

            default:
              return NULL;
            }

        case AND:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2638 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2665 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2692 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2719 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2746 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2773 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2800 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2827 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2854 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2881 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2908 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2935 (insn, operands);

            default:
              return NULL;
            }

        case IOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2641 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2668 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2695 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2722 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2749 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2776 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2803 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2830 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2857 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2884 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2911 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2938 (insn, operands);

            default:
              return NULL;
            }

        case XOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2644 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2671 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2698 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2725 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2752 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2779 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2806 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2833 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2860 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2887 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2914 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2941 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case IOR:
      x4 = XEXP (x3, 0);
      switch (GET_CODE (x4))
        {
        case REG:
        case SUBREG:
        case MEM:
        case NOT:
          switch (pattern537 (x2))
            {
            case 0:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_1999 (insn, operands);

            case 1:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2026 (insn, operands);

            case 2:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2053 (insn, operands);

            case 3:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2080 (insn, operands);

            case 4:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2107 (insn, operands);

            case 5:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2134 (insn, operands);

            case 6:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2161 (insn, operands);

            case 7:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2188 (insn, operands);

            case 8:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2215 (insn, operands);

            case 9:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2242 (insn, operands);

            case 10:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2269 (insn, operands);

            case 11:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2296 (insn, operands);

            case 12:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2002 (insn, operands);

            case 13:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2029 (insn, operands);

            case 14:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2056 (insn, operands);

            case 15:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2083 (insn, operands);

            case 16:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2110 (insn, operands);

            case 17:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2137 (insn, operands);

            case 18:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2164 (insn, operands);

            case 19:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2191 (insn, operands);

            case 20:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2218 (insn, operands);

            case 21:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2245 (insn, operands);

            case 22:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2272 (insn, operands);

            case 23:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2299 (insn, operands);

            case 24:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2005 (insn, operands);

            case 25:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2032 (insn, operands);

            case 26:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2059 (insn, operands);

            case 27:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2086 (insn, operands);

            case 28:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2113 (insn, operands);

            case 29:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2140 (insn, operands);

            case 30:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2167 (insn, operands);

            case 31:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2194 (insn, operands);

            case 32:
              if (!(
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2221 (insn, operands);

            case 33:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2248 (insn, operands);

            case 34:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2275 (insn, operands);

            case 35:
              if (!((
#line 13763 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13775 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2302 (insn, operands);

            case 36:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3073 (insn, operands);

            case 37:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3082 (insn, operands);

            case 38:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3091 (insn, operands);

            case 39:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3100 (insn, operands);

            case 40:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3109 (insn, operands);

            case 41:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3118 (insn, operands);

            case 42:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3127 (insn, operands);

            case 43:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3136 (insn, operands);

            case 44:
              if (!(
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3145 (insn, operands);

            case 45:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3154 (insn, operands);

            case 46:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3163 (insn, operands);

            case 47:
              if (!((
#line 13932 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13936 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_3172 (insn, operands);

            default:
              return NULL;
            }

        case AND:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2647 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2674 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2701 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2728 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2755 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2782 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2809 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2836 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2863 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2890 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2917 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2944 (insn, operands);

            default:
              return NULL;
            }

        case IOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2650 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2677 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2704 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2731 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2758 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2785 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2812 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2839 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2866 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2893 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2920 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2947 (insn, operands);

            default:
              return NULL;
            }

        case XOR:
          switch (pattern538 (x2))
            {
            case 0:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2653 (insn, operands);

            case 1:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 335 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2680 (insn, operands);

            case 2:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2707 (insn, operands);

            case 3:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2734 (insn, operands);

            case 4:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 336 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2761 (insn, operands);

            case 5:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2788 (insn, operands);

            case 6:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2815 (insn, operands);

            case 7:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 337 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2842 (insn, operands);

            case 8:
              if (!(
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2869 (insn, operands);

            case 9:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((64 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX512F && TARGET_EVEX512)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2896 (insn, operands);

            case 10:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((32 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_AVX)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2923 (insn, operands);

            case 11:
              if (!((
#line 13848 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
((16 == 64 || TARGET_AVX512VL
    || (TARGET_AVX512F && TARGET_EVEX512 && !TARGET_PREFER_AVX256))
   && ix86_pre_reload_split ()
   && (rtx_equal_p (STRIP_UNARY (operands[1]),
		    STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[4]))
       || rtx_equal_p (STRIP_UNARY (operands[1]),
		       STRIP_UNARY (operands[3]))
       || rtx_equal_p (STRIP_UNARY (operands[2]),
		       STRIP_UNARY (operands[3])))) && 
#line 338 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
(TARGET_SSE2)) && 
#line 13860 "/build/gcc/src/gcc/gcc/config/i386/sse.md"
( 1)))
                return NULL;
              return gen_split_2950 (insn, operands);

            default:
              return NULL;
            }

        default:
          return NULL;
        }

    case XOR:
      return split_72 (x1, insn);

    default:
      return NULL;
    }
}
