#ifdef __cplusplus
extern "C" {
#endif
/****************************************************************************
 *                                                                          *
 *                         GNAT COMPILER COMPONENTS                         *
 *                                                                          *
 *                               S N A M E S                                *
 *                                                                          *
 *                              C Header File                               *
 *                                                                          *
 *          Copyright (C) 1992-2008, Free Software Foundation, Inc.         *
 *                                                                          *
 * GNAT is free software;  you can  redistribute it  and/or modify it under *
 * terms of the  GNU General Public License as published  by the Free Soft- *
 * ware  Foundation;  either version 3,  or (at your option) any later ver- *
 * sion.  GNAT is distributed in the hope that it will be useful, but WITH- *
 * OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License *
 * for  more details.  You should have  received  a copy of the GNU General *
 * Public License  distributed with GNAT; see file COPYING3.  If not, go to *
 * http://www.gnu.org/licenses for a complete copy of the license.          *
 *                                                                          *
 * GNAT was originally developed  by the GNAT team at  New York University. *
 * Extensive contributions were provided by Ada Core Technologies Inc.      *
 *                                                                          *
 ****************************************************************************/

/* This is the C file that corresponds to the Ada package specification
   Snames. It was created automatically from the file snames.ads. */

/* Name_Id values */

enum Name_Id : Int
{
  Name_uParent                        = (First_Name_Id + 256 + 0),
  Name_uTag                           = (First_Name_Id + 256 + 1),
  Name_Off                            = (First_Name_Id + 256 + 2),
  Name_Space                          = (First_Name_Id + 256 + 3),
  Name_Time                           = (First_Name_Id + 256 + 4),
  Name_Default_Value                  = (First_Name_Id + 256 + 5),
  Name_Default_Component_Value        = (First_Name_Id + 256 + 6),
  Name_Designated_Storage_Model       = (First_Name_Id + 256 + 7),
  Name_Dimension                      = (First_Name_Id + 256 + 8),
  Name_Dimension_System               = (First_Name_Id + 256 + 9),
  Name_Disable_Controlled             = (First_Name_Id + 256 + 10),
  Name_Dynamic_Predicate              = (First_Name_Id + 256 + 11),
  Name_Exclusive_Functions            = (First_Name_Id + 256 + 12),
  Name_External_Initialization        = (First_Name_Id + 256 + 13),
  Name_Finalizable                    = (First_Name_Id + 256 + 14),
  Name_Full_Access_Only               = (First_Name_Id + 256 + 15),
  Name_Ghost_Predicate                = (First_Name_Id + 256 + 16),
  Name_Integer_Literal                = (First_Name_Id + 256 + 17),
  Name_Local_Restrictions             = (First_Name_Id + 256 + 18),
  Name_No_Controlled_Parts            = (First_Name_Id + 256 + 19),
  Name_No_Task_Parts                  = (First_Name_Id + 256 + 20),
  Name_Real_Literal                   = (First_Name_Id + 256 + 21),
  Name_Relaxed_Initialization         = (First_Name_Id + 256 + 22),
  Name_Stable_Properties              = (First_Name_Id + 256 + 23),
  Name_Static_Predicate               = (First_Name_Id + 256 + 24),
  Name_Storage_Model_Type             = (First_Name_Id + 256 + 25),
  Name_String_Literal                 = (First_Name_Id + 256 + 26),
  Name_Synchronization                = (First_Name_Id + 256 + 27),
  Name_Unimplemented                  = (First_Name_Id + 256 + 28),
  Name_User_Aspect                    = (First_Name_Id + 256 + 29),
  Name_uAbort_Signal                  = (First_Name_Id + 256 + 30),
  Name_uAlignment                     = (First_Name_Id + 256 + 31),
  Name_uAssign                        = (First_Name_Id + 256 + 32),
  Name_uATCB                          = (First_Name_Id + 256 + 33),
  Name_uChain                         = (First_Name_Id + 256 + 34),
  Name_uController                    = (First_Name_Id + 256 + 35),
  Name_uCPU                           = (First_Name_Id + 256 + 36),
  Name_uDispatching_Domain            = (First_Name_Id + 256 + 37),
  Name_uFinalizer                     = (First_Name_Id + 256 + 38),
  Name_uFinalizer_Old                 = (First_Name_Id + 256 + 39),
  Name_uFinalization_Controller       = (First_Name_Id + 256 + 40),
  Name_uInit                          = (First_Name_Id + 256 + 41),
  Name_uInit_Level                    = (First_Name_Id + 256 + 42),
  Name_uInvariant                     = (First_Name_Id + 256 + 43),
  Name_uMaster                        = (First_Name_Id + 256 + 44),
  Name_uObject                        = (First_Name_Id + 256 + 45),
  Name_uPost                          = (First_Name_Id + 256 + 46),
  Name_uPostcond_Enabled              = (First_Name_Id + 256 + 47),
  Name_uPre                           = (First_Name_Id + 256 + 48),
  Name_uPriority                      = (First_Name_Id + 256 + 49),
  Name_uRelative_Deadline             = (First_Name_Id + 256 + 50),
  Name_uResult                        = (First_Name_Id + 256 + 51),
  Name_uResult_Object_For_Postcond    = (First_Name_Id + 256 + 52),
  Name_uReturn_Success_For_Postcond   = (First_Name_Id + 256 + 53),
  Name_uSecondary_Stack               = (First_Name_Id + 256 + 54),
  Name_uSecondary_Stack_Size          = (First_Name_Id + 256 + 55),
  Name_uSize                          = (First_Name_Id + 256 + 56),
  Name_uStack                         = (First_Name_Id + 256 + 57),
  Name_uTask                          = (First_Name_Id + 256 + 58),
  Name_uTask_Id                       = (First_Name_Id + 256 + 59),
  Name_uTask_Info                     = (First_Name_Id + 256 + 60),
  Name_uTask_Name                     = (First_Name_Id + 256 + 61),
  Name_uType_Invariant                = (First_Name_Id + 256 + 62),
  Name_uVariants                      = (First_Name_Id + 256 + 63),
  Name_uWrapped_Statements            = (First_Name_Id + 256 + 64),
  Name_uDisp_Asynchronous_Select      = (First_Name_Id + 256 + 65),
  Name_uDisp_Conditional_Select       = (First_Name_Id + 256 + 66),
  Name_uDisp_Get_Prim_Op_Kind         = (First_Name_Id + 256 + 67),
  Name_uDisp_Get_Task_Id              = (First_Name_Id + 256 + 68),
  Name_uDisp_Requeue                  = (First_Name_Id + 256 + 69),
  Name_uDisp_Timed_Select             = (First_Name_Id + 256 + 70),
  Name_Initialize                     = (First_Name_Id + 256 + 71),
  Name_Adjust                         = (First_Name_Id + 256 + 72),
  Name_Finalize                       = (First_Name_Id + 256 + 73),
  Name_Finalize_Address               = (First_Name_Id + 256 + 74),
  Name_Next                           = (First_Name_Id + 256 + 75),
  Name_Prev                           = (First_Name_Id + 256 + 76),
  Name_Allocate                       = (First_Name_Id + 256 + 77),
  Name_Deallocate                     = (First_Name_Id + 256 + 78),
  Name_Dereference                    = (First_Name_Id + 256 + 79),
  Name_Decimal_IO                     = (First_Name_Id + 256 + 80),
  Name_Enumeration_IO                 = (First_Name_Id + 256 + 81),
  Name_Fixed_IO                       = (First_Name_Id + 256 + 82),
  Name_Float_IO                       = (First_Name_Id + 256 + 83),
  Name_Integer_IO                     = (First_Name_Id + 256 + 84),
  Name_Modular_IO                     = (First_Name_Id + 256 + 85),
  Name_Dim_Symbol                     = (First_Name_Id + 256 + 86),
  Name_Item                           = (First_Name_Id + 256 + 87),
  Name_Put_Dim_Of                     = (First_Name_Id + 256 + 88),
  Name_Sqrt                           = (First_Name_Id + 256 + 89),
  Name_Symbol                         = (First_Name_Id + 256 + 90),
  Name_Unit_Symbol                    = (First_Name_Id + 256 + 91),
  Name_ASCII                          = (First_Name_Id + 256 + 92),
  Name_Const                          = (First_Name_Id + 256 + 93),
  Name_Error                          = (First_Name_Id + 256 + 94),
  Name_False                          = (First_Name_Id + 256 + 95),
  Name_Go                             = (First_Name_Id + 256 + 96),
  Name_Put                            = (First_Name_Id + 256 + 97),
  Name_Put_Line                       = (First_Name_Id + 256 + 98),
  Name_To                             = (First_Name_Id + 256 + 99),
  Name_Defined                        = (First_Name_Id + 256 + 100),
  Name_Arith_64                       = (First_Name_Id + 256 + 101),
  Name_Arith_128                      = (First_Name_Id + 256 + 102),
  Name_Exception_Traces               = (First_Name_Id + 256 + 103),
  Name_Finalization                   = (First_Name_Id + 256 + 104),
  Name_Interfaces                     = (First_Name_Id + 256 + 105),
  Name_Memory                         = (First_Name_Id + 256 + 106),
  Name_Memory_Compare                 = (First_Name_Id + 256 + 107),
  Name_Memory_Copy                    = (First_Name_Id + 256 + 108),
  Name_Memory_Move                    = (First_Name_Id + 256 + 109),
  Name_Memory_Set                     = (First_Name_Id + 256 + 110),
  Name_Most_Recent_Exception          = (First_Name_Id + 256 + 111),
  Name_Stack_Checking                 = (First_Name_Id + 256 + 112),
  Name_Standard                       = (First_Name_Id + 256 + 113),
  Name_System                         = (First_Name_Id + 256 + 114),
  Name_Text_IO                        = (First_Name_Id + 256 + 115),
  Name_Wide_Text_IO                   = (First_Name_Id + 256 + 116),
  Name_Wide_Wide_Text_IO              = (First_Name_Id + 256 + 117),
  Name_Abort_Task                     = (First_Name_Id + 256 + 118),
  Name_Bounded_IO                     = (First_Name_Id + 256 + 119),
  Name_C_Streams                      = (First_Name_Id + 256 + 120),
  Name_Complex_IO                     = (First_Name_Id + 256 + 121),
  Name_Directories                    = (First_Name_Id + 256 + 122),
  Name_Direct_IO                      = (First_Name_Id + 256 + 123),
  Name_Dispatching                    = (First_Name_Id + 256 + 124),
  Name_Editing                        = (First_Name_Id + 256 + 125),
  Name_EDF                            = (First_Name_Id + 256 + 126),
  Name_Reset_Standard_Files           = (First_Name_Id + 256 + 127),
  Name_Sequential_IO                  = (First_Name_Id + 256 + 128),
  Name_Strings                        = (First_Name_Id + 256 + 129),
  Name_Streams                        = (First_Name_Id + 256 + 130),
  Name_Suspend_Until_True             = (First_Name_Id + 256 + 131),
  Name_Suspend_Until_True_And_Set_Deadline  = (First_Name_Id + 256 + 132),
  Name_Synchronous_Barriers           = (First_Name_Id + 256 + 133),
  Name_Task_Identification            = (First_Name_Id + 256 + 134),
  Name_Text_Streams                   = (First_Name_Id + 256 + 135),
  Name_Unbounded                      = (First_Name_Id + 256 + 136),
  Name_Unbounded_IO                   = (First_Name_Id + 256 + 137),
  Name_Wait_For_Release               = (First_Name_Id + 256 + 138),
  Name_Wide_Unbounded                 = (First_Name_Id + 256 + 139),
  Name_Wide_Wide_Unbounded            = (First_Name_Id + 256 + 140),
  Name_Yield                          = (First_Name_Id + 256 + 141),
  Name_No_DSA                         = (First_Name_Id + 256 + 142),
  Name_GARLIC_DSA                     = (First_Name_Id + 256 + 143),
  Name_PolyORB_DSA                    = (First_Name_Id + 256 + 144),
  Name_Addr                           = (First_Name_Id + 256 + 145),
  Name_Async                          = (First_Name_Id + 256 + 146),
  Name_Get_Active_Partition_ID        = (First_Name_Id + 256 + 147),
  Name_Get_RCI_Package_Receiver       = (First_Name_Id + 256 + 148),
  Name_Get_RCI_Package_Ref            = (First_Name_Id + 256 + 149),
  Name_Origin                         = (First_Name_Id + 256 + 150),
  Name_Params                         = (First_Name_Id + 256 + 151),
  Name_Partition                      = (First_Name_Id + 256 + 152),
  Name_Ras                            = (First_Name_Id + 256 + 153),
  Name_uCall                          = (First_Name_Id + 256 + 154),
  Name_RCI_Name                       = (First_Name_Id + 256 + 155),
  Name_Receiver                       = (First_Name_Id + 256 + 156),
  Name_Rpc                            = (First_Name_Id + 256 + 157),
  Name_Subp_Id                        = (First_Name_Id + 256 + 158),
  Name_Operation                      = (First_Name_Id + 256 + 159),
  Name_Argument                       = (First_Name_Id + 256 + 160),
  Name_Arg_Modes                      = (First_Name_Id + 256 + 161),
  Name_Target                         = (First_Name_Id + 256 + 162),
  Name_Req                            = (First_Name_Id + 256 + 163),
  Name_Obj_TypeCode                   = (First_Name_Id + 256 + 164),
  Name_Stub                           = (First_Name_Id + 256 + 165),
  Name_Op_Abs                         = (First_Name_Id + 256 + 166),
  Name_Op_And                         = (First_Name_Id + 256 + 167),
  Name_Op_Mod                         = (First_Name_Id + 256 + 168),
  Name_Op_Not                         = (First_Name_Id + 256 + 169),
  Name_Op_Or                          = (First_Name_Id + 256 + 170),
  Name_Op_Rem                         = (First_Name_Id + 256 + 171),
  Name_Op_Xor                         = (First_Name_Id + 256 + 172),
  Name_Op_Eq                          = (First_Name_Id + 256 + 173),
  Name_Op_Ne                          = (First_Name_Id + 256 + 174),
  Name_Op_Lt                          = (First_Name_Id + 256 + 175),
  Name_Op_Le                          = (First_Name_Id + 256 + 176),
  Name_Op_Gt                          = (First_Name_Id + 256 + 177),
  Name_Op_Ge                          = (First_Name_Id + 256 + 178),
  Name_Op_Add                         = (First_Name_Id + 256 + 179),
  Name_Op_Subtract                    = (First_Name_Id + 256 + 180),
  Name_Op_Concat                      = (First_Name_Id + 256 + 181),
  Name_Op_Multiply                    = (First_Name_Id + 256 + 182),
  Name_Op_Divide                      = (First_Name_Id + 256 + 183),
  Name_Op_Expon                       = (First_Name_Id + 256 + 184),
  Name_Ada_83                         = (First_Name_Id + 256 + 185),
  Name_Ada_95                         = (First_Name_Id + 256 + 186),
  Name_Ada_05                         = (First_Name_Id + 256 + 187),
  Name_Ada_2005                       = (First_Name_Id + 256 + 188),
  Name_Ada_12                         = (First_Name_Id + 256 + 189),
  Name_Ada_2012                       = (First_Name_Id + 256 + 190),
  Name_Ada_2022                       = (First_Name_Id + 256 + 191),
  Name_Aggregate_Individually_Assign  = (First_Name_Id + 256 + 192),
  Name_Allow_Integer_Address          = (First_Name_Id + 256 + 193),
  Name_Annotate                       = (First_Name_Id + 256 + 194),
  Name_Assertion_Policy               = (First_Name_Id + 256 + 195),
  Name_Assume_No_Invalid_Values       = (First_Name_Id + 256 + 196),
  Name_C_Pass_By_Copy                 = (First_Name_Id + 256 + 197),
  Name_Check_Float_Overflow           = (First_Name_Id + 256 + 198),
  Name_Check_Name                     = (First_Name_Id + 256 + 199),
  Name_Check_Policy                   = (First_Name_Id + 256 + 200),
  Name_Component_Alignment            = (First_Name_Id + 256 + 201),
  Name_Convention_Identifier          = (First_Name_Id + 256 + 202),
  Name_Debug_Policy                   = (First_Name_Id + 256 + 203),
  Name_Default_Storage_Pool           = (First_Name_Id + 256 + 204),
  Name_Detect_Blocking                = (First_Name_Id + 256 + 205),
  Name_Disable_Atomic_Synchronization  = (First_Name_Id + 256 + 206),
  Name_Discard_Names                  = (First_Name_Id + 256 + 207),
  Name_Elaboration_Checks             = (First_Name_Id + 256 + 208),
  Name_Eliminate                      = (First_Name_Id + 256 + 209),
  Name_Enable_Atomic_Synchronization  = (First_Name_Id + 256 + 210),
  Name_Extend_System                  = (First_Name_Id + 256 + 211),
  Name_Extensions_Allowed             = (First_Name_Id + 256 + 212),
  Name_External_Name_Casing           = (First_Name_Id + 256 + 213),
  Name_Favor_Top_Level                = (First_Name_Id + 256 + 214),
  Name_GNAT_Annotate                  = (First_Name_Id + 256 + 215),
  Name_Ignore_Pragma                  = (First_Name_Id + 256 + 216),
  Name_Implicit_Packing               = (First_Name_Id + 256 + 217),
  Name_Initialize_Scalars             = (First_Name_Id + 256 + 218),
  Name_Interrupt_State                = (First_Name_Id + 256 + 219),
  Name_License                        = (First_Name_Id + 256 + 220),
  Name_Locking_Policy                 = (First_Name_Id + 256 + 221),
  Name_No_Component_Reordering        = (First_Name_Id + 256 + 222),
  Name_No_Heap_Finalization           = (First_Name_Id + 256 + 223),
  Name_No_Run_Time                    = (First_Name_Id + 256 + 224),
  Name_Interrupts_System_By_Default   = (First_Name_Id + 256 + 225),
  Name_No_Strict_Aliasing             = (First_Name_Id + 256 + 226),
  Name_Normalize_Scalars              = (First_Name_Id + 256 + 227),
  Name_Optimize_Alignment             = (First_Name_Id + 256 + 228),
  Name_Overflow_Mode                  = (First_Name_Id + 256 + 229),
  Name_Overriding_Renamings           = (First_Name_Id + 256 + 230),
  Name_Partition_Elaboration_Policy   = (First_Name_Id + 256 + 231),
  Name_Persistent_BSS                 = (First_Name_Id + 256 + 232),
  Name_Prefix_Exception_Messages      = (First_Name_Id + 256 + 233),
  Name_Priority_Specific_Dispatching  = (First_Name_Id + 256 + 234),
  Name_Profile                        = (First_Name_Id + 256 + 235),
  Name_Profile_Warnings               = (First_Name_Id + 256 + 236),
  Name_Propagate_Exceptions           = (First_Name_Id + 256 + 237),
  Name_Queuing_Policy                 = (First_Name_Id + 256 + 238),
  Name_Rational                       = (First_Name_Id + 256 + 239),
  Name_Ravenscar                      = (First_Name_Id + 256 + 240),
  Name_Rename_Pragma                  = (First_Name_Id + 256 + 241),
  Name_Restricted_Run_Time            = (First_Name_Id + 256 + 242),
  Name_Restrictions                   = (First_Name_Id + 256 + 243),
  Name_Restriction_Warnings           = (First_Name_Id + 256 + 244),
  Name_Reviewable                     = (First_Name_Id + 256 + 245),
  Name_Short_Circuit_And_Or           = (First_Name_Id + 256 + 246),
  Name_Short_Descriptors              = (First_Name_Id + 256 + 247),
  Name_Source_File_Name               = (First_Name_Id + 256 + 248),
  Name_Source_File_Name_Project       = (First_Name_Id + 256 + 249),
  Name_SPARK_Mode                     = (First_Name_Id + 256 + 250),
  Name_Style_Checks                   = (First_Name_Id + 256 + 251),
  Name_Suppress                       = (First_Name_Id + 256 + 252),
  Name_Suppress_Exception_Locations   = (First_Name_Id + 256 + 253),
  Name_Task_Dispatching_Policy        = (First_Name_Id + 256 + 254),
  Name_Unevaluated_Use_Of_Old         = (First_Name_Id + 256 + 255),
  Name_Unsuppress                     = (First_Name_Id + 256 + 256),
  Name_Use_VADS_Size                  = (First_Name_Id + 256 + 257),
  Name_User_Aspect_Definition         = (First_Name_Id + 256 + 258),
  Name_Validity_Checks                = (First_Name_Id + 256 + 259),
  Name_Warning_As_Error               = (First_Name_Id + 256 + 260),
  Name_Warnings                       = (First_Name_Id + 256 + 261),
  Name_Wide_Character_Encoding        = (First_Name_Id + 256 + 262),
  Name_Abort_Defer                    = (First_Name_Id + 256 + 263),
  Name_Abstract_State                 = (First_Name_Id + 256 + 264),
  Name_All_Calls_Remote               = (First_Name_Id + 256 + 265),
  Name_Always_Terminates              = (First_Name_Id + 256 + 266),
  Name_Assert                         = (First_Name_Id + 256 + 267),
  Name_Assert_And_Cut                 = (First_Name_Id + 256 + 268),
  Name_Assume                         = (First_Name_Id + 256 + 269),
  Name_Async_Readers                  = (First_Name_Id + 256 + 270),
  Name_Async_Writers                  = (First_Name_Id + 256 + 271),
  Name_Asynchronous                   = (First_Name_Id + 256 + 272),
  Name_Atomic                         = (First_Name_Id + 256 + 273),
  Name_Atomic_Components              = (First_Name_Id + 256 + 274),
  Name_Attach_Handler                 = (First_Name_Id + 256 + 275),
  Name_Attribute_Definition           = (First_Name_Id + 256 + 276),
  Name_Check                          = (First_Name_Id + 256 + 277),
  Name_Comment                        = (First_Name_Id + 256 + 278),
  Name_Common_Object                  = (First_Name_Id + 256 + 279),
  Name_Compile_Time_Error             = (First_Name_Id + 256 + 280),
  Name_Compile_Time_Warning           = (First_Name_Id + 256 + 281),
  Name_Complete_Representation        = (First_Name_Id + 256 + 282),
  Name_Complex_Representation         = (First_Name_Id + 256 + 283),
  Name_Constant_After_Elaboration     = (First_Name_Id + 256 + 284),
  Name_Contract_Cases                 = (First_Name_Id + 256 + 285),
  Name_Controlled                     = (First_Name_Id + 256 + 286),
  Name_Convention                     = (First_Name_Id + 256 + 287),
  Name_CPP_Class                      = (First_Name_Id + 256 + 288),
  Name_CPP_Constructor                = (First_Name_Id + 256 + 289),
  Name_CPP_Virtual                    = (First_Name_Id + 256 + 290),
  Name_CPP_Vtable                     = (First_Name_Id + 256 + 291),
  Name_CUDA_Device                    = (First_Name_Id + 256 + 292),
  Name_CUDA_Execute                   = (First_Name_Id + 256 + 293),
  Name_CUDA_Global                    = (First_Name_Id + 256 + 294),
  Name_Deadline_Floor                 = (First_Name_Id + 256 + 295),
  Name_Debug                          = (First_Name_Id + 256 + 296),
  Name_Default_Initial_Condition      = (First_Name_Id + 256 + 297),
  Name_Depends                        = (First_Name_Id + 256 + 298),
  Name_Effective_Reads                = (First_Name_Id + 256 + 299),
  Name_Effective_Writes               = (First_Name_Id + 256 + 300),
  Name_Elaborate                      = (First_Name_Id + 256 + 301),
  Name_Elaborate_All                  = (First_Name_Id + 256 + 302),
  Name_Elaborate_Body                 = (First_Name_Id + 256 + 303),
  Name_Exceptional_Cases              = (First_Name_Id + 256 + 304),
  Name_Exit_Cases                     = (First_Name_Id + 256 + 305),
  Name_Export                         = (First_Name_Id + 256 + 306),
  Name_Export_Function                = (First_Name_Id + 256 + 307),
  Name_Export_Object                  = (First_Name_Id + 256 + 308),
  Name_Export_Procedure               = (First_Name_Id + 256 + 309),
  Name_Export_Valued_Procedure        = (First_Name_Id + 256 + 310),
  Name_Extended_Access                = (First_Name_Id + 256 + 311),
  Name_Extensions_Visible             = (First_Name_Id + 256 + 312),
  Name_External                       = (First_Name_Id + 256 + 313),
  Name_Finalize_Storage_Only          = (First_Name_Id + 256 + 314),
  Name_First_Controlling_Parameter    = (First_Name_Id + 256 + 315),
  Name_Ghost                          = (First_Name_Id + 256 + 316),
  Name_Global                         = (First_Name_Id + 256 + 317),
  Name_Ident                          = (First_Name_Id + 256 + 318),
  Name_Implementation_Defined         = (First_Name_Id + 256 + 319),
  Name_Implemented                    = (First_Name_Id + 256 + 320),
  Name_Import                         = (First_Name_Id + 256 + 321),
  Name_Import_Function                = (First_Name_Id + 256 + 322),
  Name_Import_Object                  = (First_Name_Id + 256 + 323),
  Name_Import_Procedure               = (First_Name_Id + 256 + 324),
  Name_Import_Valued_Procedure        = (First_Name_Id + 256 + 325),
  Name_Independent                    = (First_Name_Id + 256 + 326),
  Name_Independent_Components         = (First_Name_Id + 256 + 327),
  Name_Initial_Condition              = (First_Name_Id + 256 + 328),
  Name_Initializes                    = (First_Name_Id + 256 + 329),
  Name_Inline                         = (First_Name_Id + 256 + 330),
  Name_Inline_Always                  = (First_Name_Id + 256 + 331),
  Name_Inline_Generic                 = (First_Name_Id + 256 + 332),
  Name_Inspection_Point               = (First_Name_Id + 256 + 333),
  Name_Interface_Name                 = (First_Name_Id + 256 + 334),
  Name_Interrupt_Handler              = (First_Name_Id + 256 + 335),
  Name_Invariant                      = (First_Name_Id + 256 + 336),
  Name_Keep_Names                     = (First_Name_Id + 256 + 337),
  Name_Link_With                      = (First_Name_Id + 256 + 338),
  Name_Linker_Alias                   = (First_Name_Id + 256 + 339),
  Name_Linker_Constructor             = (First_Name_Id + 256 + 340),
  Name_Linker_Destructor              = (First_Name_Id + 256 + 341),
  Name_Linker_Options                 = (First_Name_Id + 256 + 342),
  Name_Linker_Section                 = (First_Name_Id + 256 + 343),
  Name_List                           = (First_Name_Id + 256 + 344),
  Name_Lock_Free                      = (First_Name_Id + 256 + 345),
  Name_Loop_Invariant                 = (First_Name_Id + 256 + 346),
  Name_Loop_Optimize                  = (First_Name_Id + 256 + 347),
  Name_Loop_Variant                   = (First_Name_Id + 256 + 348),
  Name_Machine_Attribute              = (First_Name_Id + 256 + 349),
  Name_Main                           = (First_Name_Id + 256 + 350),
  Name_Main_Storage                   = (First_Name_Id + 256 + 351),
  Name_Max_Entry_Queue_Length         = (First_Name_Id + 256 + 352),
  Name_Max_Queue_Length               = (First_Name_Id + 256 + 353),
  Name_Memory_Size                    = (First_Name_Id + 256 + 354),
  Name_No_Body                        = (First_Name_Id + 256 + 355),
  Name_No_Caching                     = (First_Name_Id + 256 + 356),
  Name_No_Elaboration_Code_All        = (First_Name_Id + 256 + 357),
  Name_No_Inline                      = (First_Name_Id + 256 + 358),
  Name_No_Raise                       = (First_Name_Id + 256 + 359),
  Name_No_Return                      = (First_Name_Id + 256 + 360),
  Name_No_Tagged_Streams              = (First_Name_Id + 256 + 361),
  Name_Obsolescent                    = (First_Name_Id + 256 + 362),
  Name_Optimize                       = (First_Name_Id + 256 + 363),
  Name_Ordered                        = (First_Name_Id + 256 + 364),
  Name_Pack                           = (First_Name_Id + 256 + 365),
  Name_Page                           = (First_Name_Id + 256 + 366),
  Name_Part_Of                        = (First_Name_Id + 256 + 367),
  Name_Passive                        = (First_Name_Id + 256 + 368),
  Name_Post                           = (First_Name_Id + 256 + 369),
  Name_Postcondition                  = (First_Name_Id + 256 + 370),
  Name_Post_Class                     = (First_Name_Id + 256 + 371),
  Name_Pre                            = (First_Name_Id + 256 + 372),
  Name_Precondition                   = (First_Name_Id + 256 + 373),
  Name_Predicate                      = (First_Name_Id + 256 + 374),
  Name_Predicate_Failure              = (First_Name_Id + 256 + 375),
  Name_Preelaborate                   = (First_Name_Id + 256 + 376),
  Name_Pre_Class                      = (First_Name_Id + 256 + 377),
  Name_Provide_Shift_Operators        = (First_Name_Id + 256 + 378),
  Name_Psect_Object                   = (First_Name_Id + 256 + 379),
  Name_Pure                           = (First_Name_Id + 256 + 380),
  Name_Pure_Function                  = (First_Name_Id + 256 + 381),
  Name_Refined_Depends                = (First_Name_Id + 256 + 382),
  Name_Refined_Global                 = (First_Name_Id + 256 + 383),
  Name_Refined_Post                   = (First_Name_Id + 256 + 384),
  Name_Refined_State                  = (First_Name_Id + 256 + 385),
  Name_Relative_Deadline              = (First_Name_Id + 256 + 386),
  Name_Remote_Access_Type             = (First_Name_Id + 256 + 387),
  Name_Remote_Call_Interface          = (First_Name_Id + 256 + 388),
  Name_Remote_Types                   = (First_Name_Id + 256 + 389),
  Name_Share_Generic                  = (First_Name_Id + 256 + 390),
  Name_Shared                         = (First_Name_Id + 256 + 391),
  Name_Shared_Passive                 = (First_Name_Id + 256 + 392),
  Name_Side_Effects                   = (First_Name_Id + 256 + 393),
  Name_Simple_Storage_Pool_Type       = (First_Name_Id + 256 + 394),
  Name_Simulate_Internal_Error        = (First_Name_Id + 256 + 395),
  Name_Source_Reference               = (First_Name_Id + 256 + 396),
  Name_Static_Elaboration_Desired     = (First_Name_Id + 256 + 397),
  Name_Stream_Convert                 = (First_Name_Id + 256 + 398),
  Name_Subprogram_Variant             = (First_Name_Id + 256 + 399),
  Name_Subtitle                       = (First_Name_Id + 256 + 400),
  Name_Suppress_All                   = (First_Name_Id + 256 + 401),
  Name_Suppress_Debug_Info            = (First_Name_Id + 256 + 402),
  Name_Suppress_Initialization        = (First_Name_Id + 256 + 403),
  Name_System_Name                    = (First_Name_Id + 256 + 404),
  Name_Task_Info                      = (First_Name_Id + 256 + 405),
  Name_Task_Name                      = (First_Name_Id + 256 + 406),
  Name_Task_Storage                   = (First_Name_Id + 256 + 407),
  Name_Test_Case                      = (First_Name_Id + 256 + 408),
  Name_Thread_Local_Storage           = (First_Name_Id + 256 + 409),
  Name_Time_Slice                     = (First_Name_Id + 256 + 410),
  Name_Title                          = (First_Name_Id + 256 + 411),
  Name_Type_Invariant                 = (First_Name_Id + 256 + 412),
  Name_Type_Invariant_Class           = (First_Name_Id + 256 + 413),
  Name_Unchecked_Union                = (First_Name_Id + 256 + 414),
  Name_Unimplemented_Unit             = (First_Name_Id + 256 + 415),
  Name_Universal_Aliasing             = (First_Name_Id + 256 + 416),
  Name_Unmodified                     = (First_Name_Id + 256 + 417),
  Name_Unreferenced                   = (First_Name_Id + 256 + 418),
  Name_Unreferenced_Objects           = (First_Name_Id + 256 + 419),
  Name_Unreserve_All_Interrupts       = (First_Name_Id + 256 + 420),
  Name_Unused                         = (First_Name_Id + 256 + 421),
  Name_Volatile                       = (First_Name_Id + 256 + 422),
  Name_Volatile_Components            = (First_Name_Id + 256 + 423),
  Name_Volatile_Full_Access           = (First_Name_Id + 256 + 424),
  Name_Volatile_Function              = (First_Name_Id + 256 + 425),
  Name_Weak_External                  = (First_Name_Id + 256 + 426),
  Name_Ada                            = (First_Name_Id + 256 + 427),
  Name_Ada_Pass_By_Copy               = (First_Name_Id + 256 + 428),
  Name_Ada_Pass_By_Reference          = (First_Name_Id + 256 + 429),
  Name_Assembler                      = (First_Name_Id + 256 + 430),
  Name_C_Variadic_0                   = (First_Name_Id + 256 + 431),
  Name_C_Variadic_1                   = (First_Name_Id + 256 + 432),
  Name_C_Variadic_2                   = (First_Name_Id + 256 + 433),
  Name_C_Variadic_3                   = (First_Name_Id + 256 + 434),
  Name_C_Variadic_4                   = (First_Name_Id + 256 + 435),
  Name_C_Variadic_5                   = (First_Name_Id + 256 + 436),
  Name_C_Variadic_6                   = (First_Name_Id + 256 + 437),
  Name_C_Variadic_7                   = (First_Name_Id + 256 + 438),
  Name_C_Variadic_8                   = (First_Name_Id + 256 + 439),
  Name_C_Variadic_9                   = (First_Name_Id + 256 + 440),
  Name_C_Variadic_10                  = (First_Name_Id + 256 + 441),
  Name_C_Variadic_11                  = (First_Name_Id + 256 + 442),
  Name_C_Variadic_12                  = (First_Name_Id + 256 + 443),
  Name_C_Variadic_13                  = (First_Name_Id + 256 + 444),
  Name_C_Variadic_14                  = (First_Name_Id + 256 + 445),
  Name_C_Variadic_15                  = (First_Name_Id + 256 + 446),
  Name_C_Variadic_16                  = (First_Name_Id + 256 + 447),
  Name_COBOL                          = (First_Name_Id + 256 + 448),
  Name_CPP                            = (First_Name_Id + 256 + 449),
  Name_Fortran                        = (First_Name_Id + 256 + 450),
  Name_Intrinsic                      = (First_Name_Id + 256 + 451),
  Name_Stdcall                        = (First_Name_Id + 256 + 452),
  Name_Stubbed                        = (First_Name_Id + 256 + 453),
  Name_Asm                            = (First_Name_Id + 256 + 454),
  Name_Assembly                       = (First_Name_Id + 256 + 455),
  Name_Default                        = (First_Name_Id + 256 + 456),
  Name_C_Plus_Plus                    = (First_Name_Id + 256 + 457),
  Name_DLL                            = (First_Name_Id + 256 + 458),
  Name_Win32                          = (First_Name_Id + 256 + 459),
  Name_Address_Type                   = (First_Name_Id + 256 + 460),
  Name_Aggregate                      = (First_Name_Id + 256 + 461),
  Name_All_Extensions                 = (First_Name_Id + 256 + 462),
  Name_Allow                          = (First_Name_Id + 256 + 463),
  Name_Amount                         = (First_Name_Id + 256 + 464),
  Name_As_Is                          = (First_Name_Id + 256 + 465),
  Name_Assertion                      = (First_Name_Id + 256 + 466),
  Name_Assertions                     = (First_Name_Id + 256 + 467),
  Name_Attribute_Name                 = (First_Name_Id + 256 + 468),
  Name_Auto                           = (First_Name_Id + 256 + 469),
  Name_Body_File_Name                 = (First_Name_Id + 256 + 470),
  Name_Boolean_Entry_Barriers         = (First_Name_Id + 256 + 471),
  Name_By_Any                         = (First_Name_Id + 256 + 472),
  Name_By_Entry                       = (First_Name_Id + 256 + 473),
  Name_By_Protected_Procedure         = (First_Name_Id + 256 + 474),
  Name_Casing                         = (First_Name_Id + 256 + 475),
  Name_Code                           = (First_Name_Id + 256 + 476),
  Name_Component                      = (First_Name_Id + 256 + 477),
  Name_Component_Size_4               = (First_Name_Id + 256 + 478),
  Name_Copy                           = (First_Name_Id + 256 + 479),
  Name_Copy_From                      = (First_Name_Id + 256 + 480),
  Name_Copy_To                        = (First_Name_Id + 256 + 481),
  Name_Decreases                      = (First_Name_Id + 256 + 482),
  Name_Disable                        = (First_Name_Id + 256 + 483),
  Name_Dot_Replacement                = (First_Name_Id + 256 + 484),
  Name_Dynamic                        = (First_Name_Id + 256 + 485),
  Name_Eliminated                     = (First_Name_Id + 256 + 486),
  Name_Ensures                        = (First_Name_Id + 256 + 487),
  Name_Entity                         = (First_Name_Id + 256 + 488),
  Name_Exception_Raised               = (First_Name_Id + 256 + 489),
  Name_External_Name                  = (First_Name_Id + 256 + 490),
  Name_Form                           = (First_Name_Id + 256 + 491),
  Name_Gcc                            = (First_Name_Id + 256 + 492),
  Name_General                        = (First_Name_Id + 256 + 493),
  Name_Gnat                           = (First_Name_Id + 256 + 494),
  Name_Gnat_Extended_Ravenscar        = (First_Name_Id + 256 + 495),
  Name_Gnat_Ravenscar_EDF             = (First_Name_Id + 256 + 496),
  Name_Gnatprove                      = (First_Name_Id + 256 + 497),
  Name_GPL                            = (First_Name_Id + 256 + 498),
  Name_High_Order_First               = (First_Name_Id + 256 + 499),
  Name_Ignore                         = (First_Name_Id + 256 + 500),
  Name_In_Out                         = (First_Name_Id + 256 + 501),
  Name_Increases                      = (First_Name_Id + 256 + 502),
  Name_Info                           = (First_Name_Id + 256 + 503),
  Name_Internal                       = (First_Name_Id + 256 + 504),
  Name_Ivdep                          = (First_Name_Id + 256 + 505),
  Name_Jorvik                         = (First_Name_Id + 256 + 506),
  Name_Link_Name                      = (First_Name_Id + 256 + 507),
  Name_Low_Order_First                = (First_Name_Id + 256 + 508),
  Name_Lowercase                      = (First_Name_Id + 256 + 509),
  Name_Max_Entry_Queue_Depth          = (First_Name_Id + 256 + 510),
  Name_Max_Size                       = (First_Name_Id + 256 + 511),
  Name_Mechanism                      = (First_Name_Id + 256 + 512),
  Name_Message                        = (First_Name_Id + 256 + 513),
  Name_Minimized                      = (First_Name_Id + 256 + 514),
  Name_Mixedcase                      = (First_Name_Id + 256 + 515),
  Name_Mode                           = (First_Name_Id + 256 + 516),
  Name_Modified_GPL                   = (First_Name_Id + 256 + 517),
  Name_Name                           = (First_Name_Id + 256 + 518),
  Name_New_Name                       = (First_Name_Id + 256 + 519),
  Name_No                             = (First_Name_Id + 256 + 520),
  Name_No_Dependence                  = (First_Name_Id + 256 + 521),
  Name_No_Dynamic_Attachment          = (First_Name_Id + 256 + 522),
  Name_No_Dynamic_Interrupts          = (First_Name_Id + 256 + 523),
  Name_No_Elaboration_Code            = (First_Name_Id + 256 + 524),
  Name_No_Implementation_Extensions   = (First_Name_Id + 256 + 525),
  Name_No_Obsolescent_Features        = (First_Name_Id + 256 + 526),
  Name_No_Requeue                     = (First_Name_Id + 256 + 527),
  Name_No_Requeue_Statements          = (First_Name_Id + 256 + 528),
  Name_No_Specification_Of_Aspect     = (First_Name_Id + 256 + 529),
  Name_No_Task_Attributes             = (First_Name_Id + 256 + 530),
  Name_No_Task_Attributes_Package     = (First_Name_Id + 256 + 531),
  Name_No_Use_Of_Attribute            = (First_Name_Id + 256 + 532),
  Name_No_Use_Of_Entity               = (First_Name_Id + 256 + 533),
  Name_No_Use_Of_Pragma               = (First_Name_Id + 256 + 534),
  Name_No_Unroll                      = (First_Name_Id + 256 + 535),
  Name_No_Unrecognized_Aspects        = (First_Name_Id + 256 + 536),
  Name_No_Vector                      = (First_Name_Id + 256 + 537),
  Name_Nominal                        = (First_Name_Id + 256 + 538),
  Name_None                           = (First_Name_Id + 256 + 539),
  Name_Normal_Return                  = (First_Name_Id + 256 + 540),
  Name_Null_Address                   = (First_Name_Id + 256 + 541),
  Name_On                             = (First_Name_Id + 256 + 542),
  Name_Optional                       = (First_Name_Id + 256 + 543),
  Name_Policy                         = (First_Name_Id + 256 + 544),
  Name_Parameter_Types                = (First_Name_Id + 256 + 545),
  Name_Proof_In                       = (First_Name_Id + 256 + 546),
  Name_Reason                         = (First_Name_Id + 256 + 547),
  Name_Reference                      = (First_Name_Id + 256 + 548),
  Name_Relaxed_Finalization           = (First_Name_Id + 256 + 549),
  Name_Renamed                        = (First_Name_Id + 256 + 550),
  Name_Requires                       = (First_Name_Id + 256 + 551),
  Name_Restricted                     = (First_Name_Id + 256 + 552),
  Name_Result_Mechanism               = (First_Name_Id + 256 + 553),
  Name_Result_Type                    = (First_Name_Id + 256 + 554),
  Name_Robustness                     = (First_Name_Id + 256 + 555),
  Name_Runtime                        = (First_Name_Id + 256 + 556),
  Name_SB                             = (First_Name_Id + 256 + 557),
  Name_Section                        = (First_Name_Id + 256 + 558),
  Name_Semaphore                      = (First_Name_Id + 256 + 559),
  Name_Simple_Barriers                = (First_Name_Id + 256 + 560),
  Name_SPARK                          = (First_Name_Id + 256 + 561),
  Name_SPARK_05                       = (First_Name_Id + 256 + 562),
  Name_Spec_File_Name                 = (First_Name_Id + 256 + 563),
  Name_State                          = (First_Name_Id + 256 + 564),
  Name_Statement_Assertions           = (First_Name_Id + 256 + 565),
  Name_Static                         = (First_Name_Id + 256 + 566),
  Name_Stack_Size                     = (First_Name_Id + 256 + 567),
  Name_Strict                         = (First_Name_Id + 256 + 568),
  Name_Structural                     = (First_Name_Id + 256 + 569),
  Name_Subunit_File_Name              = (First_Name_Id + 256 + 570),
  Name_Suppressible                   = (First_Name_Id + 256 + 571),
  Name_Synchronous                    = (First_Name_Id + 256 + 572),
  Name_Task_Stack_Size_Default        = (First_Name_Id + 256 + 573),
  Name_Task_Type                      = (First_Name_Id + 256 + 574),
  Name_Time_Slicing_Enabled           = (First_Name_Id + 256 + 575),
  Name_Top_Guard                      = (First_Name_Id + 256 + 576),
  Name_Unit_Name                      = (First_Name_Id + 256 + 577),
  Name_Unrestricted                   = (First_Name_Id + 256 + 578),
  Name_Unroll                         = (First_Name_Id + 256 + 579),
  Name_Uppercase                      = (First_Name_Id + 256 + 580),
  Name_User                           = (First_Name_Id + 256 + 581),
  Name_Variant                        = (First_Name_Id + 256 + 582),
  Name_Vector                         = (First_Name_Id + 256 + 583),
  Name_Warn                           = (First_Name_Id + 256 + 584),
  Name_Working_Storage                = (First_Name_Id + 256 + 585),
  Name_Abort_Signal                   = (First_Name_Id + 256 + 586),
  Name_Access                         = (First_Name_Id + 256 + 587),
  Name_Address                        = (First_Name_Id + 256 + 588),
  Name_Address_Size                   = (First_Name_Id + 256 + 589),
  Name_Aft                            = (First_Name_Id + 256 + 590),
  Name_Alignment                      = (First_Name_Id + 256 + 591),
  Name_Asm_Input                      = (First_Name_Id + 256 + 592),
  Name_Asm_Output                     = (First_Name_Id + 256 + 593),
  Name_Atomic_Always_Lock_Free        = (First_Name_Id + 256 + 594),
  Name_Bit                            = (First_Name_Id + 256 + 595),
  Name_Bit_Order                      = (First_Name_Id + 256 + 596),
  Name_Bit_Position                   = (First_Name_Id + 256 + 597),
  Name_Body_Version                   = (First_Name_Id + 256 + 598),
  Name_Callable                       = (First_Name_Id + 256 + 599),
  Name_Caller                         = (First_Name_Id + 256 + 600),
  Name_Code_Address                   = (First_Name_Id + 256 + 601),
  Name_Compiler_Version               = (First_Name_Id + 256 + 602),
  Name_Component_Size                 = (First_Name_Id + 256 + 603),
  Name_Compose                        = (First_Name_Id + 256 + 604),
  Name_Constrained                    = (First_Name_Id + 256 + 605),
  Name_Count                          = (First_Name_Id + 256 + 606),
  Name_Default_Bit_Order              = (First_Name_Id + 256 + 607),
  Name_Default_Scalar_Storage_Order   = (First_Name_Id + 256 + 608),
  Name_Definite                       = (First_Name_Id + 256 + 609),
  Name_Delta                          = (First_Name_Id + 256 + 610),
  Name_Denorm                         = (First_Name_Id + 256 + 611),
  Name_Deref                          = (First_Name_Id + 256 + 612),
  Name_Descriptor_Size                = (First_Name_Id + 256 + 613),
  Name_Digits                         = (First_Name_Id + 256 + 614),
  Name_Elaborated                     = (First_Name_Id + 256 + 615),
  Name_Emax                           = (First_Name_Id + 256 + 616),
  Name_Enabled                        = (First_Name_Id + 256 + 617),
  Name_Enum_Rep                       = (First_Name_Id + 256 + 618),
  Name_Enum_Val                       = (First_Name_Id + 256 + 619),
  Name_Epsilon                        = (First_Name_Id + 256 + 620),
  Name_Exponent                       = (First_Name_Id + 256 + 621),
  Name_External_Tag                   = (First_Name_Id + 256 + 622),
  Name_Fast_Math                      = (First_Name_Id + 256 + 623),
  Name_Finalization_Size              = (First_Name_Id + 256 + 624),
  Name_First                          = (First_Name_Id + 256 + 625),
  Name_First_Bit                      = (First_Name_Id + 256 + 626),
  Name_First_Valid                    = (First_Name_Id + 256 + 627),
  Name_Fixed_Value                    = (First_Name_Id + 256 + 628),
  Name_Fore                           = (First_Name_Id + 256 + 629),
  Name_Has_Access_Values              = (First_Name_Id + 256 + 630),
  Name_Has_Discriminants              = (First_Name_Id + 256 + 631),
  Name_Has_Same_Storage               = (First_Name_Id + 256 + 632),
  Name_Has_Tagged_Values              = (First_Name_Id + 256 + 633),
  Name_Identity                       = (First_Name_Id + 256 + 634),
  Name_Index                          = (First_Name_Id + 256 + 635),
  Name_Initialized                    = (First_Name_Id + 256 + 636),
  Name_Integer_Value                  = (First_Name_Id + 256 + 637),
  Name_Invalid_Value                  = (First_Name_Id + 256 + 638),
  Name_Large                          = (First_Name_Id + 256 + 639),
  Name_Last                           = (First_Name_Id + 256 + 640),
  Name_Last_Bit                       = (First_Name_Id + 256 + 641),
  Name_Last_Valid                     = (First_Name_Id + 256 + 642),
  Name_Leading_Part                   = (First_Name_Id + 256 + 643),
  Name_Length                         = (First_Name_Id + 256 + 644),
  Name_Library_Level                  = (First_Name_Id + 256 + 645),
  Name_Loop_Entry                     = (First_Name_Id + 256 + 646),
  Name_Machine_Emax                   = (First_Name_Id + 256 + 647),
  Name_Machine_Emin                   = (First_Name_Id + 256 + 648),
  Name_Machine_Mantissa               = (First_Name_Id + 256 + 649),
  Name_Machine_Overflows              = (First_Name_Id + 256 + 650),
  Name_Machine_Radix                  = (First_Name_Id + 256 + 651),
  Name_Machine_Rounding               = (First_Name_Id + 256 + 652),
  Name_Machine_Rounds                 = (First_Name_Id + 256 + 653),
  Name_Machine_Size                   = (First_Name_Id + 256 + 654),
  Name_Mantissa                       = (First_Name_Id + 256 + 655),
  Name_Max_Alignment_For_Allocation   = (First_Name_Id + 256 + 656),
  Name_Max_Integer_Size               = (First_Name_Id + 256 + 657),
  Name_Max_Size_In_Storage_Elements   = (First_Name_Id + 256 + 658),
  Name_Maximum_Alignment              = (First_Name_Id + 256 + 659),
  Name_Mechanism_Code                 = (First_Name_Id + 256 + 660),
  Name_Mod                            = (First_Name_Id + 256 + 661),
  Name_Model_Emin                     = (First_Name_Id + 256 + 662),
  Name_Model_Epsilon                  = (First_Name_Id + 256 + 663),
  Name_Model_Mantissa                 = (First_Name_Id + 256 + 664),
  Name_Model_Small                    = (First_Name_Id + 256 + 665),
  Name_Modulus                        = (First_Name_Id + 256 + 666),
  Name_Null_Parameter                 = (First_Name_Id + 256 + 667),
  Name_Object_Size                    = (First_Name_Id + 256 + 668),
  Name_Old                            = (First_Name_Id + 256 + 669),
  Name_Overlaps_Storage               = (First_Name_Id + 256 + 670),
  Name_Partition_ID                   = (First_Name_Id + 256 + 671),
  Name_Passed_By_Reference            = (First_Name_Id + 256 + 672),
  Name_Pool_Address                   = (First_Name_Id + 256 + 673),
  Name_Pos                            = (First_Name_Id + 256 + 674),
  Name_Position                       = (First_Name_Id + 256 + 675),
  Name_Preelaborable_Initialization   = (First_Name_Id + 256 + 676),
  Name_Priority                       = (First_Name_Id + 256 + 677),
  Name_Range                          = (First_Name_Id + 256 + 678),
  Name_Range_Length                   = (First_Name_Id + 256 + 679),
  Name_Reduce                         = (First_Name_Id + 256 + 680),
  Name_Ref                            = (First_Name_Id + 256 + 681),
  Name_Restriction_Set                = (First_Name_Id + 256 + 682),
  Name_Result                         = (First_Name_Id + 256 + 683),
  Name_Round                          = (First_Name_Id + 256 + 684),
  Name_Safe_Emax                      = (First_Name_Id + 256 + 685),
  Name_Safe_First                     = (First_Name_Id + 256 + 686),
  Name_Safe_Large                     = (First_Name_Id + 256 + 687),
  Name_Safe_Last                      = (First_Name_Id + 256 + 688),
  Name_Safe_Small                     = (First_Name_Id + 256 + 689),
  Name_Scalar_Storage_Order           = (First_Name_Id + 256 + 690),
  Name_Scale                          = (First_Name_Id + 256 + 691),
  Name_Scaling                        = (First_Name_Id + 256 + 692),
  Name_Signed_Zeros                   = (First_Name_Id + 256 + 693),
  Name_Size                           = (First_Name_Id + 256 + 694),
  Name_Small                          = (First_Name_Id + 256 + 695),
  Name_Small_Denominator              = (First_Name_Id + 256 + 696),
  Name_Small_Numerator                = (First_Name_Id + 256 + 697),
  Name_Storage_Size                   = (First_Name_Id + 256 + 698),
  Name_Storage_Unit                   = (First_Name_Id + 256 + 699),
  Name_Stream_Size                    = (First_Name_Id + 256 + 700),
  Name_Super                          = (First_Name_Id + 256 + 701),
  Name_System_Allocator_Alignment     = (First_Name_Id + 256 + 702),
  Name_Tag                            = (First_Name_Id + 256 + 703),
  Name_Target_Name                    = (First_Name_Id + 256 + 704),
  Name_Terminated                     = (First_Name_Id + 256 + 705),
  Name_To_Address                     = (First_Name_Id + 256 + 706),
  Name_Type_Class                     = (First_Name_Id + 256 + 707),
  Name_Type_Key                       = (First_Name_Id + 256 + 708),
  Name_Unbiased_Rounding              = (First_Name_Id + 256 + 709),
  Name_Unchecked_Access               = (First_Name_Id + 256 + 710),
  Name_Unconstrained_Array            = (First_Name_Id + 256 + 711),
  Name_Universal_Literal_String       = (First_Name_Id + 256 + 712),
  Name_Unrestricted_Access            = (First_Name_Id + 256 + 713),
  Name_Update                         = (First_Name_Id + 256 + 714),
  Name_VADS_Size                      = (First_Name_Id + 256 + 715),
  Name_Val                            = (First_Name_Id + 256 + 716),
  Name_Valid                          = (First_Name_Id + 256 + 717),
  Name_Valid_Scalars                  = (First_Name_Id + 256 + 718),
  Name_Value_Size                     = (First_Name_Id + 256 + 719),
  Name_Version                        = (First_Name_Id + 256 + 720),
  Name_Wchar_T_Size                   = (First_Name_Id + 256 + 721),
  Name_Wide_Wide_Width                = (First_Name_Id + 256 + 722),
  Name_Wide_Width                     = (First_Name_Id + 256 + 723),
  Name_Width                          = (First_Name_Id + 256 + 724),
  Name_Word_Size                      = (First_Name_Id + 256 + 725),
  Name_Adjacent                       = (First_Name_Id + 256 + 726),
  Name_Ceiling                        = (First_Name_Id + 256 + 727),
  Name_Copy_Sign                      = (First_Name_Id + 256 + 728),
  Name_Floor                          = (First_Name_Id + 256 + 729),
  Name_Fraction                       = (First_Name_Id + 256 + 730),
  Name_From_Any                       = (First_Name_Id + 256 + 731),
  Name_Image                          = (First_Name_Id + 256 + 732),
  Name_Img                            = (First_Name_Id + 256 + 733),
  Name_Input                          = (First_Name_Id + 256 + 734),
  Name_Machine                        = (First_Name_Id + 256 + 735),
  Name_Max                            = (First_Name_Id + 256 + 736),
  Name_Min                            = (First_Name_Id + 256 + 737),
  Name_Model                          = (First_Name_Id + 256 + 738),
  Name_Pred                           = (First_Name_Id + 256 + 739),
  Name_Remainder                      = (First_Name_Id + 256 + 740),
  Name_Rounding                       = (First_Name_Id + 256 + 741),
  Name_Succ                           = (First_Name_Id + 256 + 742),
  Name_To_Any                         = (First_Name_Id + 256 + 743),
  Name_Truncation                     = (First_Name_Id + 256 + 744),
  Name_TypeCode                       = (First_Name_Id + 256 + 745),
  Name_Valid_Value                    = (First_Name_Id + 256 + 746),
  Name_Value                          = (First_Name_Id + 256 + 747),
  Name_Wide_Image                     = (First_Name_Id + 256 + 748),
  Name_Wide_Wide_Image                = (First_Name_Id + 256 + 749),
  Name_Wide_Value                     = (First_Name_Id + 256 + 750),
  Name_Wide_Wide_Value                = (First_Name_Id + 256 + 751),
  Name_Output                         = (First_Name_Id + 256 + 752),
  Name_Put_Image                      = (First_Name_Id + 256 + 753),
  Name_Read                           = (First_Name_Id + 256 + 754),
  Name_Write                          = (First_Name_Id + 256 + 755),
  Name_Elab_Body                      = (First_Name_Id + 256 + 756),
  Name_Elab_Spec                      = (First_Name_Id + 256 + 757),
  Name_Elab_Subp_Body                 = (First_Name_Id + 256 + 758),
  Name_Simple_Storage_Pool            = (First_Name_Id + 256 + 759),
  Name_Storage_Pool                   = (First_Name_Id + 256 + 760),
  Name_Base                           = (First_Name_Id + 256 + 761),
  Name_Class                          = (First_Name_Id + 256 + 762),
  Name_Stub_Type                      = (First_Name_Id + 256 + 763),
  Name_Constant_Indexing              = (First_Name_Id + 256 + 764),
  Name_CPU                            = (First_Name_Id + 256 + 765),
  Name_Default_Iterator               = (First_Name_Id + 256 + 766),
  Name_Dispatching_Domain             = (First_Name_Id + 256 + 767),
  Name_Implicit_Dereference           = (First_Name_Id + 256 + 768),
  Name_Interrupt_Priority             = (First_Name_Id + 256 + 769),
  Name_Iterable                       = (First_Name_Id + 256 + 770),
  Name_Iterator_Element               = (First_Name_Id + 256 + 771),
  Name_Secondary_Stack_Size           = (First_Name_Id + 256 + 772),
  Name_Variable_Indexing              = (First_Name_Id + 256 + 773),
  Name_Ceiling_Locking                = (First_Name_Id + 256 + 774),
  Name_Inheritance_Locking            = (First_Name_Id + 256 + 775),
  Name_Concurrent_Readers_Locking     = (First_Name_Id + 256 + 776),
  Name_FIFO_Queuing                   = (First_Name_Id + 256 + 777),
  Name_Priority_Queuing               = (First_Name_Id + 256 + 778),
  Name_EDF_Across_Priorities          = (First_Name_Id + 256 + 779),
  Name_FIFO_Within_Priorities         = (First_Name_Id + 256 + 780),
  Name_Non_Preemptive_FIFO_Within_Priorities  = (First_Name_Id + 256 + 781),
  Name_Round_Robin_Within_Priorities  = (First_Name_Id + 256 + 782),
  Name_Concurrent                     = (First_Name_Id + 256 + 783),
  Name_Sequential                     = (First_Name_Id + 256 + 784),
  Name_Short_Float                    = (First_Name_Id + 256 + 785),
  Name_Float                          = (First_Name_Id + 256 + 786),
  Name_Long_Float                     = (First_Name_Id + 256 + 787),
  Name_Long_Long_Float                = (First_Name_Id + 256 + 788),
  Name_Signed_8                       = (First_Name_Id + 256 + 789),
  Name_Signed_16                      = (First_Name_Id + 256 + 790),
  Name_Signed_32                      = (First_Name_Id + 256 + 791),
  Name_Signed_64                      = (First_Name_Id + 256 + 792),
  Name_Signed_128                     = (First_Name_Id + 256 + 793),
  Name_Unsigned_8                     = (First_Name_Id + 256 + 794),
  Name_Unsigned_16                    = (First_Name_Id + 256 + 795),
  Name_Unsigned_32                    = (First_Name_Id + 256 + 796),
  Name_Unsigned_64                    = (First_Name_Id + 256 + 797),
  Name_Unsigned_128                   = (First_Name_Id + 256 + 798),
  Name_Access_Check                   = (First_Name_Id + 256 + 799),
  Name_Accessibility_Check            = (First_Name_Id + 256 + 800),
  Name_Alignment_Check                = (First_Name_Id + 256 + 801),
  Name_Allocation_Check               = (First_Name_Id + 256 + 802),
  Name_uAtomic_Synchronization        = (First_Name_Id + 256 + 803),
  Name_Characters_Assertion_Check     = (First_Name_Id + 256 + 804),
  Name_Containers_Assertion_Check     = (First_Name_Id + 256 + 805),
  Name_Discriminant_Check             = (First_Name_Id + 256 + 806),
  Name_Division_Check                 = (First_Name_Id + 256 + 807),
  Name_Duplicated_Tag_Check           = (First_Name_Id + 256 + 808),
  Name_Elaboration_Check              = (First_Name_Id + 256 + 809),
  Name_Index_Check                    = (First_Name_Id + 256 + 810),
  Name_Interfaces_Assertion_Check     = (First_Name_Id + 256 + 811),
  Name_IO_Assertion_Check             = (First_Name_Id + 256 + 812),
  Name_Length_Check                   = (First_Name_Id + 256 + 813),
  Name_Numerics_Assertion_Check       = (First_Name_Id + 256 + 814),
  Name_Overflow_Check                 = (First_Name_Id + 256 + 815),
  Name_Predicate_Check                = (First_Name_Id + 256 + 816),
  Name_Program_Error_Check            = (First_Name_Id + 256 + 817),
  Name_Range_Check                    = (First_Name_Id + 256 + 818),
  Name_Storage_Check                  = (First_Name_Id + 256 + 819),
  Name_Strings_Assertion_Check        = (First_Name_Id + 256 + 820),
  Name_System_Assertion_Check         = (First_Name_Id + 256 + 821),
  Name_Tag_Check                      = (First_Name_Id + 256 + 822),
  Name_Validity_Check                 = (First_Name_Id + 256 + 823),
  Name_Container_Checks               = (First_Name_Id + 256 + 824),
  Name_Tampering_Check                = (First_Name_Id + 256 + 825),
  Name_Tasking_Check                  = (First_Name_Id + 256 + 826),
  Name_Raise_Check                    = (First_Name_Id + 256 + 827),
  Name_All_Checks                     = (First_Name_Id + 256 + 828),
  Name_Abort                          = (First_Name_Id + 256 + 829),
  Name_Abs                            = (First_Name_Id + 256 + 830),
  Name_Accept                         = (First_Name_Id + 256 + 831),
  Name_And                            = (First_Name_Id + 256 + 832),
  Name_All                            = (First_Name_Id + 256 + 833),
  Name_Array                          = (First_Name_Id + 256 + 834),
  Name_At                             = (First_Name_Id + 256 + 835),
  Name_Begin                          = (First_Name_Id + 256 + 836),
  Name_Body                           = (First_Name_Id + 256 + 837),
  Name_Case                           = (First_Name_Id + 256 + 838),
  Name_Constant                       = (First_Name_Id + 256 + 839),
  Name_Declare                        = (First_Name_Id + 256 + 840),
  Name_Delay                          = (First_Name_Id + 256 + 841),
  Name_Do                             = (First_Name_Id + 256 + 842),
  Name_Else                           = (First_Name_Id + 256 + 843),
  Name_Elsif                          = (First_Name_Id + 256 + 844),
  Name_End                            = (First_Name_Id + 256 + 845),
  Name_Entry                          = (First_Name_Id + 256 + 846),
  Name_Exception                      = (First_Name_Id + 256 + 847),
  Name_Exit                           = (First_Name_Id + 256 + 848),
  Name_For                            = (First_Name_Id + 256 + 849),
  Name_Function                       = (First_Name_Id + 256 + 850),
  Name_Generic                        = (First_Name_Id + 256 + 851),
  Name_Goto                           = (First_Name_Id + 256 + 852),
  Name_If                             = (First_Name_Id + 256 + 853),
  Name_In                             = (First_Name_Id + 256 + 854),
  Name_Is                             = (First_Name_Id + 256 + 855),
  Name_Limited                        = (First_Name_Id + 256 + 856),
  Name_Loop                           = (First_Name_Id + 256 + 857),
  Name_New                            = (First_Name_Id + 256 + 858),
  Name_Not                            = (First_Name_Id + 256 + 859),
  Name_Null                           = (First_Name_Id + 256 + 860),
  Name_Of                             = (First_Name_Id + 256 + 861),
  Name_Or                             = (First_Name_Id + 256 + 862),
  Name_Others                         = (First_Name_Id + 256 + 863),
  Name_Out                            = (First_Name_Id + 256 + 864),
  Name_Package                        = (First_Name_Id + 256 + 865),
  Name_Pragma                         = (First_Name_Id + 256 + 866),
  Name_Private                        = (First_Name_Id + 256 + 867),
  Name_Procedure                      = (First_Name_Id + 256 + 868),
  Name_Raise                          = (First_Name_Id + 256 + 869),
  Name_Record                         = (First_Name_Id + 256 + 870),
  Name_Rem                            = (First_Name_Id + 256 + 871),
  Name_Renames                        = (First_Name_Id + 256 + 872),
  Name_Return                         = (First_Name_Id + 256 + 873),
  Name_Reverse                        = (First_Name_Id + 256 + 874),
  Name_Select                         = (First_Name_Id + 256 + 875),
  Name_Separate                       = (First_Name_Id + 256 + 876),
  Name_Subtype                        = (First_Name_Id + 256 + 877),
  Name_Task                           = (First_Name_Id + 256 + 878),
  Name_Terminate                      = (First_Name_Id + 256 + 879),
  Name_Then                           = (First_Name_Id + 256 + 880),
  Name_Type                           = (First_Name_Id + 256 + 881),
  Name_Use                            = (First_Name_Id + 256 + 882),
  Name_When                           = (First_Name_Id + 256 + 883),
  Name_While                          = (First_Name_Id + 256 + 884),
  Name_With                           = (First_Name_Id + 256 + 885),
  Name_Xor                            = (First_Name_Id + 256 + 886),
  Name_Compilation_ISO_Date           = (First_Name_Id + 256 + 887),
  Name_Compilation_Date               = (First_Name_Id + 256 + 888),
  Name_Compilation_Time               = (First_Name_Id + 256 + 889),
  Name_Divide                         = (First_Name_Id + 256 + 890),
  Name_Enclosing_Entity               = (First_Name_Id + 256 + 891),
  Name_Exception_Information          = (First_Name_Id + 256 + 892),
  Name_Exception_Message              = (First_Name_Id + 256 + 893),
  Name_Exception_Name                 = (First_Name_Id + 256 + 894),
  Name_File                           = (First_Name_Id + 256 + 895),
  Name_Generic_Dispatching_Constructor  = (First_Name_Id + 256 + 896),
  Name_Import_Address                 = (First_Name_Id + 256 + 897),
  Name_Import_Largest_Value           = (First_Name_Id + 256 + 898),
  Name_Import_Value                   = (First_Name_Id + 256 + 899),
  Name_Line                           = (First_Name_Id + 256 + 900),
  Name_Rotate_Left                    = (First_Name_Id + 256 + 901),
  Name_Rotate_Right                   = (First_Name_Id + 256 + 902),
  Name_Shift_Left                     = (First_Name_Id + 256 + 903),
  Name_Shift_Right                    = (First_Name_Id + 256 + 904),
  Name_Shift_Right_Arithmetic         = (First_Name_Id + 256 + 905),
  Name_Source_Location                = (First_Name_Id + 256 + 906),
  Name_To_Integer                     = (First_Name_Id + 256 + 907),
  Name_To_Pointer                     = (First_Name_Id + 256 + 908),
  Name_Unchecked_Conversion           = (First_Name_Id + 256 + 909),
  Name_Unchecked_Deallocation         = (First_Name_Id + 256 + 910),
  Name_Free                           = (First_Name_Id + 256 + 911),
  Name_Abstract                       = (First_Name_Id + 256 + 912),
  Name_Aliased                        = (First_Name_Id + 256 + 913),
  Name_Protected                      = (First_Name_Id + 256 + 914),
  Name_Until                          = (First_Name_Id + 256 + 915),
  Name_Requeue                        = (First_Name_Id + 256 + 916),
  Name_Tagged                         = (First_Name_Id + 256 + 917),
  Name_Discriminant                   = (First_Name_Id + 256 + 918),
  Name_Operands                       = (First_Name_Id + 256 + 919),
  Name_Present                        = (First_Name_Id + 256 + 920),
  Name_Synchronous_Task_Control       = (First_Name_Id + 256 + 921),
  Name_Cursor                         = (First_Name_Id + 256 + 922),
  Name_Element                        = (First_Name_Id + 256 + 923),
  Name_Has_Element                    = (First_Name_Id + 256 + 924),
  Name_Forward_Iterator               = (First_Name_Id + 256 + 925),
  Name_Reversible_Iterator            = (First_Name_Id + 256 + 926),
  Name_uNext                          = (First_Name_Id + 256 + 927),
  Name_Previous                       = (First_Name_Id + 256 + 928),
  Name_uPrevious                      = (First_Name_Id + 256 + 929),
  Name_Pseudo_Reference               = (First_Name_Id + 256 + 930),
  Name_Reference_Control_Type         = (First_Name_Id + 256 + 931),
  Name_Get_Element_Access             = (First_Name_Id + 256 + 932),
  Name_Empty                          = (First_Name_Id + 256 + 933),
  Name_Add_Named                      = (First_Name_Id + 256 + 934),
  Name_Add_Unnamed                    = (First_Name_Id + 256 + 935),
  Name_New_Indexed                    = (First_Name_Id + 256 + 936),
  Name_Assign_Indexed                 = (First_Name_Id + 256 + 937),
  Name_Interface                      = (First_Name_Id + 256 + 938),
  Name_Overriding                     = (First_Name_Id + 256 + 939),
  Name_Synchronized                   = (First_Name_Id + 256 + 940),
  Name_Some                           = (First_Name_Id + 256 + 941),
  Name_Finally                        = (First_Name_Id + 256 + 942),
};

/* Define the numeric values for attributes.  */

enum Attribute_Id : unsigned char
{
  Attr_Abort_Signal                   = 0,
  Attr_Access                         = 1,
  Attr_Address                        = 2,
  Attr_Address_Size                   = 3,
  Attr_Aft                            = 4,
  Attr_Alignment                      = 5,
  Attr_Asm_Input                      = 6,
  Attr_Asm_Output                     = 7,
  Attr_Atomic_Always_Lock_Free        = 8,
  Attr_Bit                            = 9,
  Attr_Bit_Order                      = 10,
  Attr_Bit_Position                   = 11,
  Attr_Body_Version                   = 12,
  Attr_Callable                       = 13,
  Attr_Caller                         = 14,
  Attr_Code_Address                   = 15,
  Attr_Compiler_Version               = 16,
  Attr_Component_Size                 = 17,
  Attr_Compose                        = 18,
  Attr_Constrained                    = 19,
  Attr_Count                          = 20,
  Attr_Default_Bit_Order              = 21,
  Attr_Default_Scalar_Storage_Order   = 22,
  Attr_Definite                       = 23,
  Attr_Delta                          = 24,
  Attr_Denorm                         = 25,
  Attr_Deref                          = 26,
  Attr_Descriptor_Size                = 27,
  Attr_Digits                         = 28,
  Attr_Elaborated                     = 29,
  Attr_Emax                           = 30,
  Attr_Enabled                        = 31,
  Attr_Enum_Rep                       = 32,
  Attr_Enum_Val                       = 33,
  Attr_Epsilon                        = 34,
  Attr_Exponent                       = 35,
  Attr_External_Tag                   = 36,
  Attr_Fast_Math                      = 37,
  Attr_Finalization_Size              = 38,
  Attr_First                          = 39,
  Attr_First_Bit                      = 40,
  Attr_First_Valid                    = 41,
  Attr_Fixed_Value                    = 42,
  Attr_Fore                           = 43,
  Attr_Has_Access_Values              = 44,
  Attr_Has_Discriminants              = 45,
  Attr_Has_Same_Storage               = 46,
  Attr_Has_Tagged_Values              = 47,
  Attr_Identity                       = 48,
  Attr_Index                          = 49,
  Attr_Initialized                    = 50,
  Attr_Integer_Value                  = 51,
  Attr_Invalid_Value                  = 52,
  Attr_Large                          = 53,
  Attr_Last                           = 54,
  Attr_Last_Bit                       = 55,
  Attr_Last_Valid                     = 56,
  Attr_Leading_Part                   = 57,
  Attr_Length                         = 58,
  Attr_Library_Level                  = 59,
  Attr_Loop_Entry                     = 60,
  Attr_Machine_Emax                   = 61,
  Attr_Machine_Emin                   = 62,
  Attr_Machine_Mantissa               = 63,
  Attr_Machine_Overflows              = 64,
  Attr_Machine_Radix                  = 65,
  Attr_Machine_Rounding               = 66,
  Attr_Machine_Rounds                 = 67,
  Attr_Machine_Size                   = 68,
  Attr_Mantissa                       = 69,
  Attr_Max_Alignment_For_Allocation   = 70,
  Attr_Max_Integer_Size               = 71,
  Attr_Max_Size_In_Storage_Elements   = 72,
  Attr_Maximum_Alignment              = 73,
  Attr_Mechanism_Code                 = 74,
  Attr_Mod                            = 75,
  Attr_Model_Emin                     = 76,
  Attr_Model_Epsilon                  = 77,
  Attr_Model_Mantissa                 = 78,
  Attr_Model_Small                    = 79,
  Attr_Modulus                        = 80,
  Attr_Null_Parameter                 = 81,
  Attr_Object_Size                    = 82,
  Attr_Old                            = 83,
  Attr_Overlaps_Storage               = 84,
  Attr_Partition_ID                   = 85,
  Attr_Passed_By_Reference            = 86,
  Attr_Pool_Address                   = 87,
  Attr_Pos                            = 88,
  Attr_Position                       = 89,
  Attr_Preelaborable_Initialization   = 90,
  Attr_Priority                       = 91,
  Attr_Range                          = 92,
  Attr_Range_Length                   = 93,
  Attr_Reduce                         = 94,
  Attr_Ref                            = 95,
  Attr_Restriction_Set                = 96,
  Attr_Result                         = 97,
  Attr_Round                          = 98,
  Attr_Safe_Emax                      = 99,
  Attr_Safe_First                     = 100,
  Attr_Safe_Large                     = 101,
  Attr_Safe_Last                      = 102,
  Attr_Safe_Small                     = 103,
  Attr_Scalar_Storage_Order           = 104,
  Attr_Scale                          = 105,
  Attr_Scaling                        = 106,
  Attr_Signed_Zeros                   = 107,
  Attr_Size                           = 108,
  Attr_Small                          = 109,
  Attr_Small_Denominator              = 110,
  Attr_Small_Numerator                = 111,
  Attr_Storage_Size                   = 112,
  Attr_Storage_Unit                   = 113,
  Attr_Stream_Size                    = 114,
  Attr_Super                          = 115,
  Attr_System_Allocator_Alignment     = 116,
  Attr_Tag                            = 117,
  Attr_Target_Name                    = 118,
  Attr_Terminated                     = 119,
  Attr_To_Address                     = 120,
  Attr_Type_Class                     = 121,
  Attr_Type_Key                       = 122,
  Attr_Unbiased_Rounding              = 123,
  Attr_Unchecked_Access               = 124,
  Attr_Unconstrained_Array            = 125,
  Attr_Universal_Literal_String       = 126,
  Attr_Unrestricted_Access            = 127,
  Attr_Update                         = 128,
  Attr_VADS_Size                      = 129,
  Attr_Val                            = 130,
  Attr_Valid                          = 131,
  Attr_Valid_Scalars                  = 132,
  Attr_Value_Size                     = 133,
  Attr_Version                        = 134,
  Attr_Wchar_T_Size                   = 135,
  Attr_Wide_Wide_Width                = 136,
  Attr_Wide_Width                     = 137,
  Attr_Width                          = 138,
  Attr_Word_Size                      = 139,
  Attr_Adjacent                       = 140,
  Attr_Ceiling                        = 141,
  Attr_Copy_Sign                      = 142,
  Attr_Floor                          = 143,
  Attr_Fraction                       = 144,
  Attr_From_Any                       = 145,
  Attr_Image                          = 146,
  Attr_Img                            = 147,
  Attr_Input                          = 148,
  Attr_Machine                        = 149,
  Attr_Max                            = 150,
  Attr_Min                            = 151,
  Attr_Model                          = 152,
  Attr_Pred                           = 153,
  Attr_Remainder                      = 154,
  Attr_Rounding                       = 155,
  Attr_Succ                           = 156,
  Attr_To_Any                         = 157,
  Attr_Truncation                     = 158,
  Attr_TypeCode                       = 159,
  Attr_Valid_Value                    = 160,
  Attr_Value                          = 161,
  Attr_Wide_Image                     = 162,
  Attr_Wide_Wide_Image                = 163,
  Attr_Wide_Value                     = 164,
  Attr_Wide_Wide_Value                = 165,
  Attr_Output                         = 166,
  Attr_Put_Image                      = 167,
  Attr_Read                           = 168,
  Attr_Write                          = 169,
  Attr_Elab_Body                      = 170,
  Attr_Elab_Spec                      = 171,
  Attr_Elab_Subp_Body                 = 172,
  Attr_Simple_Storage_Pool            = 173,
  Attr_Storage_Pool                   = 174,
  Attr_Base                           = 175,
  Attr_Class                          = 176,
  Attr_Stub_Type                      = 177,
  Attr_Constant_Indexing              = 178,
  Attr_CPU                            = 179,
  Attr_Default_Iterator               = 180,
  Attr_Dispatching_Domain             = 181,
  Attr_Implicit_Dereference           = 182,
  Attr_Interrupt_Priority             = 183,
  Attr_Iterable                       = 184,
  Attr_Iterator_Element               = 185,
  Attr_Variable_Indexing              = 186,
};

/* Define the function to return one of the numeric values above.  The operand
   is a Chars field value.  */

static inline Attribute_Id
Get_Attribute_Id (int id)
{
  extern unsigned char snames__get_attribute_id (int);
  return (Attribute_Id) snames__get_attribute_id (id);
}

/* Define the numeric values for the conventions.  */

enum Convention_Id : Byte
{
  Convention_Ada                            = 0,
  Convention_Intrinsic                      = 1,
  Convention_Entry                          = 2,
  Convention_Protected                      = 3,
  Convention_Stubbed                        = 4,
  Convention_Ada_Pass_By_Copy               = 5,
  Convention_Ada_Pass_By_Reference          = 6,
  Convention_Assembler                      = 7,
  Convention_C                              = 8,
  Convention_C_Variadic_0                   = 9,
  Convention_C_Variadic_1                   = 10,
  Convention_C_Variadic_2                   = 11,
  Convention_C_Variadic_3                   = 12,
  Convention_C_Variadic_4                   = 13,
  Convention_C_Variadic_5                   = 14,
  Convention_C_Variadic_6                   = 15,
  Convention_C_Variadic_7                   = 16,
  Convention_C_Variadic_8                   = 17,
  Convention_C_Variadic_9                   = 18,
  Convention_C_Variadic_10                  = 19,
  Convention_C_Variadic_11                  = 20,
  Convention_C_Variadic_12                  = 21,
  Convention_C_Variadic_13                  = 22,
  Convention_C_Variadic_14                  = 23,
  Convention_C_Variadic_15                  = 24,
  Convention_C_Variadic_16                  = 25,
  Convention_CPP                            = 26,
  Convention_COBOL                          = 27,
  Convention_Fortran                        = 28,
  Convention_Stdcall                        = 29,
};

/* Define the function to check if a Name_Id value is a valid pragma */

#define Is_Pragma_Name snames__is_pragma_name
extern Boolean Is_Pragma_Name (Name_Id);

/* Define the numeric values for the pragmas. */

enum Pragma_Id : Byte
{
  Pragma_Ada_83                         = 0,
  Pragma_Ada_95                         = 1,
  Pragma_Ada_05                         = 2,
  Pragma_Ada_2005                       = 3,
  Pragma_Ada_12                         = 4,
  Pragma_Ada_2012                       = 5,
  Pragma_Ada_2022                       = 6,
  Pragma_Aggregate_Individually_Assign  = 7,
  Pragma_Allow_Integer_Address          = 8,
  Pragma_Annotate                       = 9,
  Pragma_Assertion_Policy               = 10,
  Pragma_Assume_No_Invalid_Values       = 11,
  Pragma_C_Pass_By_Copy                 = 12,
  Pragma_Check_Float_Overflow           = 13,
  Pragma_Check_Name                     = 14,
  Pragma_Check_Policy                   = 15,
  Pragma_Component_Alignment            = 16,
  Pragma_Convention_Identifier          = 17,
  Pragma_Debug_Policy                   = 18,
  Pragma_Default_Storage_Pool           = 19,
  Pragma_Detect_Blocking                = 20,
  Pragma_Disable_Atomic_Synchronization  = 21,
  Pragma_Discard_Names                  = 22,
  Pragma_Elaboration_Checks             = 23,
  Pragma_Eliminate                      = 24,
  Pragma_Enable_Atomic_Synchronization  = 25,
  Pragma_Extend_System                  = 26,
  Pragma_Extensions_Allowed             = 27,
  Pragma_External_Name_Casing           = 28,
  Pragma_Favor_Top_Level                = 29,
  Pragma_GNAT_Annotate                  = 30,
  Pragma_Ignore_Pragma                  = 31,
  Pragma_Implicit_Packing               = 32,
  Pragma_Initialize_Scalars             = 33,
  Pragma_Interrupt_State                = 34,
  Pragma_License                        = 35,
  Pragma_Locking_Policy                 = 36,
  Pragma_No_Component_Reordering        = 37,
  Pragma_No_Heap_Finalization           = 38,
  Pragma_No_Run_Time                    = 39,
  Pragma_Interrupts_System_By_Default   = 40,
  Pragma_No_Strict_Aliasing             = 41,
  Pragma_Normalize_Scalars              = 42,
  Pragma_Optimize_Alignment             = 43,
  Pragma_Overflow_Mode                  = 44,
  Pragma_Overriding_Renamings           = 45,
  Pragma_Partition_Elaboration_Policy   = 46,
  Pragma_Persistent_BSS                 = 47,
  Pragma_Prefix_Exception_Messages      = 48,
  Pragma_Priority_Specific_Dispatching  = 49,
  Pragma_Profile                        = 50,
  Pragma_Profile_Warnings               = 51,
  Pragma_Propagate_Exceptions           = 52,
  Pragma_Queuing_Policy                 = 53,
  Pragma_Rational                       = 54,
  Pragma_Ravenscar                      = 55,
  Pragma_Rename_Pragma                  = 56,
  Pragma_Restricted_Run_Time            = 57,
  Pragma_Restrictions                   = 58,
  Pragma_Restriction_Warnings           = 59,
  Pragma_Reviewable                     = 60,
  Pragma_Short_Circuit_And_Or           = 61,
  Pragma_Short_Descriptors              = 62,
  Pragma_Source_File_Name               = 63,
  Pragma_Source_File_Name_Project       = 64,
  Pragma_SPARK_Mode                     = 65,
  Pragma_Style_Checks                   = 66,
  Pragma_Suppress                       = 67,
  Pragma_Suppress_Exception_Locations   = 68,
  Pragma_Task_Dispatching_Policy        = 69,
  Pragma_Unevaluated_Use_Of_Old         = 70,
  Pragma_Unsuppress                     = 71,
  Pragma_Use_VADS_Size                  = 72,
  Pragma_User_Aspect_Definition         = 73,
  Pragma_Validity_Checks                = 74,
  Pragma_Warning_As_Error               = 75,
  Pragma_Warnings                       = 76,
  Pragma_Wide_Character_Encoding        = 77,
  Pragma_Abort_Defer                    = 78,
  Pragma_Abstract_State                 = 79,
  Pragma_All_Calls_Remote               = 80,
  Pragma_Always_Terminates              = 81,
  Pragma_Assert                         = 82,
  Pragma_Assert_And_Cut                 = 83,
  Pragma_Assume                         = 84,
  Pragma_Async_Readers                  = 85,
  Pragma_Async_Writers                  = 86,
  Pragma_Asynchronous                   = 87,
  Pragma_Atomic                         = 88,
  Pragma_Atomic_Components              = 89,
  Pragma_Attach_Handler                 = 90,
  Pragma_Attribute_Definition           = 91,
  Pragma_Check                          = 92,
  Pragma_Comment                        = 93,
  Pragma_Common_Object                  = 94,
  Pragma_Compile_Time_Error             = 95,
  Pragma_Compile_Time_Warning           = 96,
  Pragma_Complete_Representation        = 97,
  Pragma_Complex_Representation         = 98,
  Pragma_Constant_After_Elaboration     = 99,
  Pragma_Contract_Cases                 = 100,
  Pragma_Controlled                     = 101,
  Pragma_Convention                     = 102,
  Pragma_CPP_Class                      = 103,
  Pragma_CPP_Constructor                = 104,
  Pragma_CPP_Virtual                    = 105,
  Pragma_CPP_Vtable                     = 106,
  Pragma_CUDA_Device                    = 107,
  Pragma_CUDA_Execute                   = 108,
  Pragma_CUDA_Global                    = 109,
  Pragma_Deadline_Floor                 = 110,
  Pragma_Debug                          = 111,
  Pragma_Default_Initial_Condition      = 112,
  Pragma_Depends                        = 113,
  Pragma_Effective_Reads                = 114,
  Pragma_Effective_Writes               = 115,
  Pragma_Elaborate                      = 116,
  Pragma_Elaborate_All                  = 117,
  Pragma_Elaborate_Body                 = 118,
  Pragma_Exceptional_Cases              = 119,
  Pragma_Exit_Cases                     = 120,
  Pragma_Export                         = 121,
  Pragma_Export_Function                = 122,
  Pragma_Export_Object                  = 123,
  Pragma_Export_Procedure               = 124,
  Pragma_Export_Valued_Procedure        = 125,
  Pragma_Extended_Access                = 126,
  Pragma_Extensions_Visible             = 127,
  Pragma_External                       = 128,
  Pragma_Finalize_Storage_Only          = 129,
  Pragma_First_Controlling_Parameter    = 130,
  Pragma_Ghost                          = 131,
  Pragma_Global                         = 132,
  Pragma_Ident                          = 133,
  Pragma_Implementation_Defined         = 134,
  Pragma_Implemented                    = 135,
  Pragma_Import                         = 136,
  Pragma_Import_Function                = 137,
  Pragma_Import_Object                  = 138,
  Pragma_Import_Procedure               = 139,
  Pragma_Import_Valued_Procedure        = 140,
  Pragma_Independent                    = 141,
  Pragma_Independent_Components         = 142,
  Pragma_Initial_Condition              = 143,
  Pragma_Initializes                    = 144,
  Pragma_Inline                         = 145,
  Pragma_Inline_Always                  = 146,
  Pragma_Inline_Generic                 = 147,
  Pragma_Inspection_Point               = 148,
  Pragma_Interface_Name                 = 149,
  Pragma_Interrupt_Handler              = 150,
  Pragma_Invariant                      = 151,
  Pragma_Keep_Names                     = 152,
  Pragma_Link_With                      = 153,
  Pragma_Linker_Alias                   = 154,
  Pragma_Linker_Constructor             = 155,
  Pragma_Linker_Destructor              = 156,
  Pragma_Linker_Options                 = 157,
  Pragma_Linker_Section                 = 158,
  Pragma_List                           = 159,
  Pragma_Lock_Free                      = 160,
  Pragma_Loop_Invariant                 = 161,
  Pragma_Loop_Optimize                  = 162,
  Pragma_Loop_Variant                   = 163,
  Pragma_Machine_Attribute              = 164,
  Pragma_Main                           = 165,
  Pragma_Main_Storage                   = 166,
  Pragma_Max_Entry_Queue_Length         = 167,
  Pragma_Max_Queue_Length               = 168,
  Pragma_Memory_Size                    = 169,
  Pragma_No_Body                        = 170,
  Pragma_No_Caching                     = 171,
  Pragma_No_Elaboration_Code_All        = 172,
  Pragma_No_Inline                      = 173,
  Pragma_No_Raise                       = 174,
  Pragma_No_Return                      = 175,
  Pragma_No_Tagged_Streams              = 176,
  Pragma_Obsolescent                    = 177,
  Pragma_Optimize                       = 178,
  Pragma_Ordered                        = 179,
  Pragma_Pack                           = 180,
  Pragma_Page                           = 181,
  Pragma_Part_Of                        = 182,
  Pragma_Passive                        = 183,
  Pragma_Post                           = 184,
  Pragma_Postcondition                  = 185,
  Pragma_Post_Class                     = 186,
  Pragma_Pre                            = 187,
  Pragma_Precondition                   = 188,
  Pragma_Predicate                      = 189,
  Pragma_Predicate_Failure              = 190,
  Pragma_Preelaborate                   = 191,
  Pragma_Pre_Class                      = 192,
  Pragma_Provide_Shift_Operators        = 193,
  Pragma_Psect_Object                   = 194,
  Pragma_Pure                           = 195,
  Pragma_Pure_Function                  = 196,
  Pragma_Refined_Depends                = 197,
  Pragma_Refined_Global                 = 198,
  Pragma_Refined_Post                   = 199,
  Pragma_Refined_State                  = 200,
  Pragma_Relative_Deadline              = 201,
  Pragma_Remote_Access_Type             = 202,
  Pragma_Remote_Call_Interface          = 203,
  Pragma_Remote_Types                   = 204,
  Pragma_Share_Generic                  = 205,
  Pragma_Shared                         = 206,
  Pragma_Shared_Passive                 = 207,
  Pragma_Side_Effects                   = 208,
  Pragma_Simple_Storage_Pool_Type       = 209,
  Pragma_Simulate_Internal_Error        = 210,
  Pragma_Source_Reference               = 211,
  Pragma_Static_Elaboration_Desired     = 212,
  Pragma_Stream_Convert                 = 213,
  Pragma_Subprogram_Variant             = 214,
  Pragma_Subtitle                       = 215,
  Pragma_Suppress_All                   = 216,
  Pragma_Suppress_Debug_Info            = 217,
  Pragma_Suppress_Initialization        = 218,
  Pragma_System_Name                    = 219,
  Pragma_Task_Info                      = 220,
  Pragma_Task_Name                      = 221,
  Pragma_Task_Storage                   = 222,
  Pragma_Test_Case                      = 223,
  Pragma_Thread_Local_Storage           = 224,
  Pragma_Time_Slice                     = 225,
  Pragma_Title                          = 226,
  Pragma_Type_Invariant                 = 227,
  Pragma_Type_Invariant_Class           = 228,
  Pragma_Unchecked_Union                = 229,
  Pragma_Unimplemented_Unit             = 230,
  Pragma_Universal_Aliasing             = 231,
  Pragma_Unmodified                     = 232,
  Pragma_Unreferenced                   = 233,
  Pragma_Unreferenced_Objects           = 234,
  Pragma_Unreserve_All_Interrupts       = 235,
  Pragma_Unused                         = 236,
  Pragma_Volatile                       = 237,
  Pragma_Volatile_Components            = 238,
  Pragma_Volatile_Full_Access           = 239,
  Pragma_Volatile_Function              = 240,
  Pragma_Weak_External                  = 241,
  Pragma_CPU                            = 242,
  Pragma_Default_Scalar_Storage_Order   = 243,
  Pragma_Dispatching_Domain             = 244,
  Pragma_Fast_Math                      = 245,
  Pragma_Interface                      = 246,
  Pragma_Interrupt_Priority             = 247,
  Pragma_Preelaborable_Initialization   = 248,
  Pragma_Priority                       = 249,
  Pragma_Secondary_Stack_Size           = 250,
  Pragma_Storage_Size                   = 251,
  Pragma_Storage_Unit                   = 252,
};

/* Define the function to return one of the numeric values above.  The operand
   is a Chars field value.  */

static inline Pragma_Id
Get_Pragma_Id (int id)
{
  extern unsigned char snames__get_pragma_id (int);
  return (Pragma_Id) snames__get_pragma_id (id);
}

/* End of snames.h (C version of Snames package spec) */

SUBTYPE (Convention_C_Family, Convention_Id, 
   Convention_C, Convention_CPP)
SUBTYPE (Convention_C_Variadic, Convention_Id, 
   Convention_C_Variadic_0, Convention_C_Variadic_16)
SUBTYPE (Foreign_Convention, Convention_Id, 
   Convention_Assembler, Convention_Stdcall)

#ifdef __cplusplus
}
#endif
