/* do not edit automatically generated by mc from m2builtins.  */
/* m2builtins.def definition module for m2builtins.cc.

Copyright (C) 2003-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_m2builtins_H)
#   define _m2builtins_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GCDataTypes.h"
#   include "Ggcctypes.h"

#   if defined (_m2builtins_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   GetBuiltinConst - returns the gcc tree of a built in constant, name.
                     NIL is returned if the constant is unknown.
*/

EXTERN tree m2builtins_GetBuiltinConst (char * name);

/*
   GetBuiltinConstType - returns the type of a builtin constant, name.

                         0 = unknown constant name
                         1 = integer
                         2 = real
*/

EXTERN unsigned int m2builtins_GetBuiltinConstType (char * name);

/*
   GetBuiltinTypeInfoType - returns value:
                            0    is ident is unknown.
                            1    if ident is IEC559, LIA1, ISO, IEEE, rounds, underflow,
                                             exception, extend.
                            2    if ident is radix, places, exponentmin, exponentmax,
                                             noofmodes.
                            3    if ident is large, small.
*/

EXTERN unsigned int m2builtins_GetBuiltinTypeInfoType (const char * ident);

/*
   GetBuiltinTypeInfo - returns a tree value:

                        NULL_TREE        if ident is unknown.
                        boolean tree     if ident is IEC559, LIA1, ISO, IEEE, rounds, underflow,
                                         exception, extend.
                        ZType tree       if ident is radix, places, exponentmin, exponentmax,
                                         noofmodes.
                        RType tree       if ident is large, small.
*/

EXTERN tree m2builtins_GetBuiltinTypeInfo (location_t location, tree type, const char * ident);

/*
   BuiltinExists - returns TRUE if the builtin function, name, exists
                   for this target architecture.
*/

EXTERN bool m2builtins_BuiltinExists (char * name);

/*
   BuildBuiltinTree - returns a tree containing the builtin function, name.
*/

EXTERN tree m2builtins_BuildBuiltinTree (location_t location, char * name);

/*
   BuiltinMemCopy and BuiltinAlloca - are called by M2GenGCC to implement open arrays.
*/

EXTERN tree m2builtins_BuiltinMemCopy (location_t location, tree dest, tree src, tree n);

/*
   BuiltinMemSet is called by M2GenGCC to implement the set type.
*/

EXTERN tree m2builtins_BuiltinMemSet (location_t location, tree dest, tree bytevalue, tree nbytes);

/*
   BuiltInAlloca - given an expression, n, allocate, n, bytes on the stack for the life
                   of the current function.
*/

EXTERN tree m2builtins_BuiltInAlloca (location_t location, tree n);

/*
   BuiltInIsfinite - given an expression, e, return an integer tree of 1 if the
                     value is finite.  Return an integer tree 0 if the value is
                     not finite.
*/

EXTERN tree m2builtins_BuiltInIsfinite (location_t location, tree e);

/*
   BuiltinStrNCopy - copy at most n characters from src to dest.
*/

EXTERN tree m2builtins_BuiltinStrNCopy (location_t location, tree dest, tree src, tree n);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
