/* do not edit automatically generated by mc from m2block.  */
/* m2block.def definition module for m2block.cc.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_m2block_H)
#   define _m2block_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "Ggcctypes.h"
#   include "GCDataTypes.h"

#   if defined (_m2block_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
    init - initialise the data structures in this module.
*/

EXTERN void m2block_init (void);

/*
    toplevel - return TRUE if we are in the global scope.
*/

EXTERN bool m2block_toplevel (void);

/*
    global_constant - t is a constant, we keep a chain of all constants
                      in the global binding level.
*/

EXTERN tree m2block_global_constant (tree t);

/*
    RememberInitModuleFunction - records tree, t, in the global binding level.
                                 So that it will not be garbage collected.
                                 In theory the inner modules could be placed
                                 inside the current_binding_level I suspect.
*/

EXTERN tree m2block_RememberInitModuleFunction (tree t);

/*
    DumpGlobalConstants - displays all global constants and checks none are
                          poisoned.
*/

EXTERN tree m2block_DumpGlobalConstants (void);

/*
    RememberConstant - adds a tree, t, onto the list of constants to be marked
                       whenever the ggc re-marks all used storage.  Constants
                       live throughout the whole compilation - and they
                       can be used by many different functions if necessary.
*/

EXTERN tree m2block_RememberConstant (tree t);

/*
    RememberType - remember the type, t, in the ggc marked list.
*/

EXTERN tree m2block_RememberType (tree t);

/*
    pushDecl - pushes a declaration onto the current binding level.
*/

EXTERN tree m2block_pushDecl (tree decl);

/*
    popGlobalScope - pops the current binding level, it expects this binding level
                     to be the global binding level.
*/

EXTERN void m2block_popGlobalScope (void);

/*
    pushGlobalScope - push the global scope onto the binding level stack.
                      There can only ever be one instance of the global binding
                      level on the stack.
*/

EXTERN void m2block_pushGlobalScope (void);

/*
    popFunctionScope - pops a binding level, returning the function associated with the
                       binding level.
*/

EXTERN tree m2block_popFunctionScope (void);

/*
    pushFunctionScope - push a binding level.
*/

EXTERN void m2block_pushFunctionScope (tree fndecl);

/*
   finishFunctionCode - adds cur_stmt_list to fndecl.  The current binding level
                        is then able to be destroyed by a call to popFunctionScope.
                        The cur_stmt_list is appended to the STATEMENT_LIST.
*/

EXTERN void m2block_finishFunctionCode (tree fndecl);

/*
   finishFunctionDecl - removes declarations from the current binding level and places
                        them inside fndecl.  The current binding level is then able to
                        be destroyed by a call to popFunctionScope.

                        The extra tree nodes associated with fndecl will be created
                        such as BIND_EXPR, BLOCK and the initial STATEMENT_LIST
                        containing the DECL_EXPR is also created.
*/

EXTERN void m2block_finishFunctionDecl (location_t location, tree fndecl);

/*
    getLabel - return the label, name, or create a label, name
               in the current scope.
*/

EXTERN tree m2block_getLabel (location_t location, char * name);

/*
   GetErrorNode - returns the gcc error_mark_node.
*/

EXTERN tree m2block_GetErrorNode (void);

/*
   includeDecl - pushes a declaration onto the current binding level providing
                 it is not already present.
*/

EXTERN void m2block_includeDecl (tree decl);

/*
   GetGlobals - returns a list of global variables, functions, constants.
*/

EXTERN tree m2block_GetGlobals (void);

/*
   GetGlobalContext - returns the global context tree.
*/

EXTERN tree m2block_GetGlobalContext (void);

/*
   begin_statement_list - starts a tree statement.  It pushes the
                          statement list and returns the list node.
*/

EXTERN tree m2block_begin_statement_list (void);

/*
   push_statement_list - pushes the statement list, t, onto the
                         current binding level.
*/

EXTERN tree m2block_push_statement_list (tree t);

/*
   pop_statement_list - pops and returns a statement list from the
                        current binding level.
*/

EXTERN tree m2block_pop_statement_list (void);

/*
   addStmtNote - remember this location represents the start of a Modula-2
                 statement.  It is flushed if another different location is
                 generated or another tree is given to add_stmt.
*/

EXTERN void m2block_addStmtNote (location_t location);

/*
   removeStmtNote - removes any pending stmt note.
*/

EXTERN void m2block_removeStmtNote (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
