/* do not edit automatically generated by mc from Sets.  */
/* Sets.mod provides a dynamic set module.

Copyright (C) 2009-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _Sets_C

#include "GSets.h"
#   include "GSYSTEM.h"
#   include "GSymbolTable.h"
#   include "GM2Error.h"
#   include "GStorage.h"
#   include "Glibc.h"
#   include "GM2Printf.h"
#   include "GAssertion.h"

#   define BitsetSize sizeof (unsigned int )
#   define MaxBitset (31)
#   define BitsPerByte (((MaxBitset+1)) / BitsetSize)
#   define Debugging false
typedef unsigned char *Sets_PtrToByte;

typedef struct Sets__T1_r Sets__T1;

typedef Sets__T1 *Sets_Set__opaque;

typedef unsigned int *Sets_PtrToBitset;

struct Sets__T1_r {
                    unsigned int init;
                    unsigned int start;
                    unsigned int end;
                    Sets_PtrToBitset pb;
                    unsigned int bytes;
                    unsigned int elements;
                  };


/*
   InitSet - initializes and returns a set.  The set will
             never contain an element less than, low.
*/

extern "C" Sets_Set Sets_InitSet (unsigned int low);

/*
   KillSet - deallocates Set, s.
*/

extern "C" Sets_Set Sets_KillSet (Sets_Set s);

/*
   DuplicateSet - returns a new duplicated set.
*/

extern "C" Sets_Set Sets_DuplicateSet (Sets_Set s);

/*
   ForeachElementInSetDo - for each element e in, s, call, p(e).
*/

extern "C" void Sets_ForeachElementInSetDo (Sets_Set s, SymbolKey_PerformOperation p);

/*
   IsElementInSet - returns TRUE if element, i, is in set, s.
*/

extern "C" bool Sets_IsElementInSet (Sets_Set s, unsigned int i);

/*
   NoOfElementsInSet - returns the number of elements in a set, s.
*/

extern "C" unsigned int Sets_NoOfElementsInSet (Sets_Set s);

/*
   ExcludeElementFromSet - excludes element, i, from set, s.
*/

extern "C" void Sets_ExcludeElementFromSet (Sets_Set s, unsigned int i);

/*
   IncludeElementIntoSet - includes element, i, into set, s.
*/

extern "C" void Sets_IncludeElementIntoSet (Sets_Set s, unsigned int i);

/*
   EqualSet - return TRUE if left = right.
*/

extern "C" bool Sets_EqualSet (Sets_Set left, Sets_Set right);

/*
   growSet -
*/

static void growSet (unsigned int i, unsigned int bytes);

/*
   checkRange - checks to make sure, i, is within range and
                it will extend the set bitmap if required.
*/

static void checkRange (Sets_Set__opaque s, unsigned int i);

/*
   findPos - returns a pointer to the BITSET which will contain, i.
*/

static Sets_PtrToBitset findPos (Sets_PtrToBitset pb, unsigned int i);


/*
   growSet -
*/

static void growSet (unsigned int i, unsigned int bytes)
{
  M2Printf_printf2 ((const char *) "i = %d,  bytes = %d\\n", 21, (const unsigned char *) &i, (sizeof (i)-1), (const unsigned char *) &bytes, (sizeof (bytes)-1));
}


/*
   checkRange - checks to make sure, i, is within range and
                it will extend the set bitmap if required.
*/

static void checkRange (Sets_Set__opaque s, unsigned int i)
{
  unsigned int bits;
  unsigned int o;
  unsigned int j;
  Sets_PtrToBitset b;
  Sets_PtrToByte v;

  if (i < s->init)
    {
      M2Error_InternalError ((const char *) "set element is too low and out of bounds", 40);
    }
  else if (i > (SymbolTable_FinalSymbol ()))
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "set element is too high and out of bounds", 41);
    }
  else
    {
      /* avoid dangling else.  */
      j = s->bytes*BitsPerByte;
      if (i >= j)
        {
          o = s->bytes;
          if (Debugging)
            {
              M2Printf_printf2 ((const char *) "previous bitset size %d bytes, need %d bits\\n", 45, (const unsigned char *) &o, (sizeof (o)-1), (const unsigned char *) &i, (sizeof (i)-1));
            }
          if (s->bytes == 0)
            {
              s->bytes = BitsetSize;
            }
          while (i >= (s->bytes*BitsPerByte))
            {
              if (Debugging)
                {
                  growSet (i, s->bytes);
                }
              s->bytes = s->bytes*2;
            }
          Storage_ALLOCATE (reinterpret_cast <void **> (&b), s->bytes);
          if (Debugging)
            {
              bits = s->bytes*8;
              M2Printf_printf2 ((const char *) "new allocated bitset size %d bytes, holds %d bits\\n", 51, (const unsigned char *) &s->bytes, (sizeof (s->bytes)-1), (const unsigned char *) &bits, (sizeof (bits)-1));
              if (i > bits)
                {
                  M2Error_InternalError ((const char *) "buffer is too small", 19);
                }
            }
          /* a := memset(b, 0, bytes) ;  */
          v = (Sets_PtrToByte) (b);
          v += o;
          Assertion_Assert ((libc_memset (reinterpret_cast <void *> (v), 0, static_cast<size_t> (s->bytes-o))) == v);
          Assertion_Assert ((libc_memcpy (reinterpret_cast <void *> (b), reinterpret_cast <void *> (s->pb), static_cast<size_t> (o))) == b);
          if (Debugging)
            {
              M2Printf_printf1 ((const char *) "deallocating old bitset size %d bytes\\n", 39, (const unsigned char *) &o, (sizeof (o)-1));
            }
          if (o > 0)
            {
              Storage_DEALLOCATE (reinterpret_cast <void **> (&s->pb), o);
            }
          s->pb = b;
        }
    }
}


/*
   findPos - returns a pointer to the BITSET which will contain, i.
*/

static Sets_PtrToBitset findPos (Sets_PtrToBitset pb, unsigned int i)
{
  Sets_PtrToByte v;

  if (((((i / (MaxBitset+1))*(MaxBitset+1)) / BitsPerByte) % BitsetSize) != 0)
    {
      M2Error_InternalError ((const char *) "must be a multiple of bitset size", 33);
    }
  v = (Sets_PtrToByte) (pb);
  v += ((i / (MaxBitset+1))*(MaxBitset+1)) / BitsPerByte;
  pb = (Sets_PtrToBitset) (v);
  return pb;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitSet - initializes and returns a set.  The set will
             never contain an element less than, low.
*/

extern "C" Sets_Set Sets_InitSet (unsigned int low)
{
  Sets_Set__opaque s;

  Storage_ALLOCATE ((void **) &s, sizeof (Sets__T1));
  s->init = low;
  s->start = 0;
  s->end = 0;
  s->pb = NULL;
  s->bytes = 0;
  s->elements = 0;
  return static_cast<Sets_Set> (s);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillSet - deallocates Set, s.
*/

extern "C" Sets_Set Sets_KillSet (Sets_Set s)
{
  if (static_cast<Sets_Set__opaque> (s)->bytes > 0)
    {
      Storage_DEALLOCATE (reinterpret_cast <void **> (&static_cast<Sets_Set__opaque> (s)->pb), static_cast<Sets_Set__opaque> (s)->bytes);
    }
  Storage_DEALLOCATE ((void **) &s, sizeof (Sets__T1));
  return static_cast<Sets_Set> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DuplicateSet - returns a new duplicated set.
*/

extern "C" Sets_Set Sets_DuplicateSet (Sets_Set s)
{
  Sets_Set__opaque t;

  Storage_ALLOCATE ((void **) &t, sizeof (Sets__T1));
  (*t) = (*static_cast<Sets_Set__opaque> (s));
  Storage_ALLOCATE (reinterpret_cast <void **> (&t->pb), t->bytes);
  Assertion_Assert ((libc_memcpy (reinterpret_cast <void *> (t->pb), reinterpret_cast <void *> (static_cast<Sets_Set__opaque> (s)->pb), static_cast<size_t> (t->bytes))) == t->pb);
  return static_cast<Sets_Set> (t);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ForeachElementInSetDo - for each element e in, s, call, p(e).
*/

extern "C" void Sets_ForeachElementInSetDo (Sets_Set s, SymbolKey_PerformOperation p)
{
  unsigned int i;
  unsigned int j;
  unsigned int c;
  Sets_PtrToBitset b;
  Sets_PtrToByte v;

  i = static_cast<Sets_Set__opaque> (s)->start;
  c = static_cast<Sets_Set__opaque> (s)->elements;
  b = findPos (static_cast<Sets_Set__opaque> (s)->pb, i);
  j = i % (MaxBitset+1);
  while ((i <= static_cast<Sets_Set__opaque> (s)->end) && (c > 0))
    {
      if ((((1 << (j)) & ((*b))) != 0))
        {
          c -= 1;
          (*p.proc) (i);
        }
      if (j == MaxBitset)
        {
          v = (Sets_PtrToByte) (b);
          v += BitsetSize;  /* avoid implications of C address arithmetic in mc PtrToByte  */
          b = (Sets_PtrToBitset) (v);  /* avoid implications of C address arithmetic in mc PtrToByte  */
          j = 0;
        }
      else
        {
          j += 1;
        }
      i += 1;
    }
}


/*
   IsElementInSet - returns TRUE if element, i, is in set, s.
*/

extern "C" bool Sets_IsElementInSet (Sets_Set s, unsigned int i)
{
  Sets_PtrToBitset b;

  checkRange (static_cast<Sets_Set__opaque> (s), i);
  b = findPos (static_cast<Sets_Set__opaque> (s)->pb, i);
  return (((1 << (i % (MaxBitset+1))) & ((*b))) != 0);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   NoOfElementsInSet - returns the number of elements in a set, s.
*/

extern "C" unsigned int Sets_NoOfElementsInSet (Sets_Set s)
{
  return static_cast<Sets_Set__opaque> (s)->elements;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ExcludeElementFromSet - excludes element, i, from set, s.
*/

extern "C" void Sets_ExcludeElementFromSet (Sets_Set s, unsigned int i)
{
  Sets_PtrToBitset b;

  checkRange (static_cast<Sets_Set__opaque> (s), i);
  b = findPos (static_cast<Sets_Set__opaque> (s)->pb, i);
  if ((((1 << (i % (MaxBitset+1))) & ((*b))) != 0))
    {
      static_cast<Sets_Set__opaque> (s)->elements -= 1;
      (*b) &= (~(1 << (i % (MaxBitset+1) )));
    }
}


/*
   IncludeElementIntoSet - includes element, i, into set, s.
*/

extern "C" void Sets_IncludeElementIntoSet (Sets_Set s, unsigned int i)
{
  Sets_PtrToBitset b;

  checkRange (static_cast<Sets_Set__opaque> (s), i);
  b = findPos (static_cast<Sets_Set__opaque> (s)->pb, i);
  if (! ((((1 << (i % (MaxBitset+1))) & ((*b))) != 0)))
    {
      static_cast<Sets_Set__opaque> (s)->elements += 1;
      (*b) |= (1 << (i % (MaxBitset+1) ));
      if ((static_cast<Sets_Set__opaque> (s)->start == 0) || (static_cast<Sets_Set__opaque> (s)->start > i))
        {
          static_cast<Sets_Set__opaque> (s)->start = i;
        }
      if ((static_cast<Sets_Set__opaque> (s)->end == 0) || (static_cast<Sets_Set__opaque> (s)->end < i))
        {
          static_cast<Sets_Set__opaque> (s)->end = i;
        }
    }
}


/*
   EqualSet - return TRUE if left = right.
*/

extern "C" bool Sets_EqualSet (Sets_Set left, Sets_Set right)
{
  Sets_PtrToByte v;
  Sets_PtrToBitset lptr;
  Sets_PtrToBitset rptr;
  unsigned int last;
  unsigned int el;

  if ((((static_cast<Sets_Set__opaque> (left)->init == static_cast<Sets_Set__opaque> (right)->init) && (static_cast<Sets_Set__opaque> (left)->start == static_cast<Sets_Set__opaque> (right)->start)) && (static_cast<Sets_Set__opaque> (left)->end == static_cast<Sets_Set__opaque> (right)->end)) && (static_cast<Sets_Set__opaque> (left)->elements == static_cast<Sets_Set__opaque> (right)->elements))
    {
      /* Now check contents.  */
      el = static_cast<Sets_Set__opaque> (left)->start;
      last = static_cast<Sets_Set__opaque> (left)->end;
      while (el <= last)
        {
          lptr = findPos (static_cast<Sets_Set__opaque> (left)->pb, el);
          rptr = findPos (static_cast<Sets_Set__opaque> (right)->pb, el);
          if ((el+BitsetSize) < last)
            {
              /* We can check complete bitset,  */
              if ((*lptr) != (*rptr))
                {
                  return false;
                }
              el += BitsetSize;
              v = (Sets_PtrToByte) (lptr);
              v += BitsetSize;  /* Avoid implications of C address arithmetic in mc PtrToByte  */
              lptr = (Sets_PtrToBitset) (v);  /* Avoid implications of C address arithmetic in mc PtrToByte  */
              v = (Sets_PtrToByte) (rptr);
              v += BitsetSize;  /* Avoid implications of C address arithmetic in mc PtrToByte  */
              rptr = (Sets_PtrToBitset) (v);
            }
          else
            {
              /* We must check remaining bits only.  */
              while ((el <= last) && (el >= static_cast<Sets_Set__opaque> (left)->init))
                {
                  if ((Sets_IsElementInSet (left, el)) != (Sets_IsElementInSet (right, el)))
                    {
                      return false;
                    }
                  el += 1;
                }
              return true;
            }
        }
      return true;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_Sets_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_Sets_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
